-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_8_station_284
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_8_station_284`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_8_station_284` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_8_station_284`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,500,'',0,'6.1','8','284','CASH','','2022-09-06 14:09:20',5,0.00,0.00,'','926','2022-09-06 14:09:20','926',0,0),(2,7000,'',0,'20','8','284','SALES','','2022-09-06 14:09:35',5,0.00,0.00,'','926','2022-09-06 14:09:35','926',0,0),(3,8000,'',0,'24','8','284','PURCHASES','','2022-09-06 14:09:53',5,0.00,0.00,'','926','2022-09-06 14:09:53','926',0,0),(4,4000,'',0,'22','8','284','PURCHASES','','2022-09-06 14:10:12',5,0.00,0.00,'','926','2022-09-06 14:10:12','926',0,0),(5,8001,'',0,'24','8','284','SALARIES & WAGES','','2022-09-06 14:10:30',5,0.00,0.00,'','926','2022-09-06 14:10:30','926',0,0),(6,2500,'',0,'2','8','284','Keystone-1009060914','','2022-09-06 14:11:27',5,0.00,0.00,'','926','2022-09-06 14:11:27','926',0,0),(7,2501,'',0,'2','8','284','UBA-0039769388','','2022-09-06 14:12:08',5,0.00,0.00,'','926','2022-09-06 14:12:08','926',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('8','284','1',1,'5','PMS PUMP 1',118294.46,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-09-08 14:27:53','926'),('8','284','1',2,'5','PMS PUMP 2',174088.24,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-09-08 14:28:45','926'),('8','284','2',3,'5','PMS PUMP 3',317751.89,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-09-08 15:07:33','926'),('8','284','2',4,'5','PMS PUMP 4',411405.85,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-09-08 15:09:16','926'),('8','284','3',5,'5','PMS PUMP 5',28194.66,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-09-14 13:36:02','926'),('8','284','4',6,'5','AGO PUMP ',0.00,'AGO DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=162 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('8','284',1,'001','2022-09-08','2022-09-08 13:07:44','2022-09-09 13:07:44','952',0.00,0.00,'926','2022-09-08 14:26:32','926','2022-09-08 14:26:48',10,0),('8','284',2,'001','2022-09-05','2022-09-08 19:51:38','2022-09-09 19:51:38','952',971199.46,971199.46,'952','2022-09-08 20:01:18','952','2022-09-08 20:02:25',10,0),('8','284',3,'002','2022-09-08','2022-09-08 20:05:20','2022-09-09 20:05:20','952',975966.09,0.00,'952','2022-09-08 20:07:55','952','2022-09-08 20:09:36',10,0),('8','284',4,'002','2022-09-06','2022-09-08 20:24:55','2022-09-09 20:24:55','952',863954.96,863954.96,'952','2022-09-08 20:33:43','952','2022-09-08 20:35:40',10,0),('8','284',5,'004','2022-09-08','2022-09-09 14:46:33','2022-09-10 14:46:33','952',1500368.32,1500368.32,'952','2022-09-09 14:50:59','927','2022-09-09 14:52:24',10,0),('8','284',6,'005','2022-09-09','2022-09-10 08:11:22','2022-09-11 08:11:22','952',1158249.95,1158249.95,'952','2022-09-10 08:15:10','952','2022-09-11 12:43:46',10,0),('8','284',7,'007','2022-09-10','2022-09-11 12:46:31','2022-09-12 12:46:31','952',1250863.57,1250863.57,'952','2022-09-11 13:26:18','952','2022-09-11 13:44:34',10,0),('8','284',8,'008','2022-09-12','2022-09-12 11:55:47','2022-09-13 11:55:47','952',927284.38,927284.38,'952','2022-09-12 11:59:17','952','2022-09-12 13:52:53',10,0),('8','284',9,'008','2022-09-12','2022-09-12 13:54:00','2022-09-13 13:54:00','952',1790755.01,1790755.01,'952','2022-09-13 10:02:36','952','2022-09-14 09:48:59',10,0),('8','284',10,'009','2022-09-14','2022-09-14 09:49:52','2022-09-15 09:49:52','952',862460.83,862460.83,'952','2022-09-14 09:52:33','467','2022-09-14 13:26:17',10,0),('8','284',11,'10','2022-09-14','2022-09-14 15:10:18','2022-09-15 15:10:18','952',1639930.16,1639930.16,'952','2022-09-15 12:46:40','952','2022-09-16 09:04:30',10,0),('8','284',12,'011','2022-09-16','2022-09-16 09:05:27','2022-09-17 09:05:27','952',1314271.53,1314271.53,'952','2022-09-16 09:08:09','952','2022-09-17 13:27:53',10,0),('8','284',13,'012','2022-09-17','2022-09-17 13:30:20','2022-09-18 13:30:20','952',1147443.22,1147443.22,'952','2022-09-17 13:33:14','952','2022-09-17 13:41:46',10,0),('8','284',14,'013','2022-09-17','2022-09-17 19:17:50','2022-09-18 19:17:50','952',0.00,0.00,'467','2022-09-19 12:30:12','467','2022-09-19 12:30:28',10,0),('8','284',15,'NEW SHIFT','2022-09-19','2022-09-19 12:30:56','2022-09-26 12:30:56','467',0.00,0.00,'467','2022-09-20 12:52:06','467','2022-09-20 12:52:25',10,0),('8','284',16,'014','2022-09-17','2022-09-20 12:58:43','2022-09-21 12:58:43','952',1736835.43,1736835.43,'952','2022-09-20 13:00:57','952','2022-09-20 13:01:51',10,0),('8','284',17,'015','2022-09-18','2022-09-20 13:06:57','2022-09-21 13:06:57','952',1416562.40,1416562.40,'952','2022-09-20 13:30:58','952','2022-09-20 13:35:29',10,0),('8','284',18,'016','2022-09-19','2022-09-20 13:36:54','2022-09-21 13:36:54','952',2161529.26,2161529.26,'952','2022-09-20 13:42:20','952','2022-09-21 14:39:08',10,0),('8','284',19,'017','2022-09-20','2022-09-21 14:40:56','2022-09-22 14:40:56','952',1980524.48,1980524.48,'952','2022-09-21 14:48:05','952','2022-09-21 14:54:04',10,0),('8','284',20,'017','2022-09-21','2022-09-22 13:11:56','2022-09-23 13:11:56','952',1050427.62,1050427.62,'952','2022-09-22 13:14:22','952','2022-09-23 20:06:53',10,0),('8','284',21,'018','2022-09-22','2022-09-23 20:07:48','2022-09-24 20:07:48','952',0.00,0.00,'467','2022-09-27 14:31:43','467','2022-09-27 14:32:46',10,0),('8','284',22,'NEW SHIFT','2022-09-27','2022-09-27 14:33:46','2022-10-04 14:33:46','467',1670538.32,1670538.32,'952','2022-09-28 14:26:05','952','2022-09-28 14:31:17',10,0),('8','284',23,'019','2022-09-23','2022-09-28 14:34:13','2022-09-29 14:34:13','952',1206275.29,1206275.29,'952','2022-09-28 14:37:13','952','2022-09-28 14:37:50',10,0),('8','284',24,'020','2022-09-24','2022-09-28 14:52:44','2022-09-29 14:52:44','952',1219391.47,1219391.47,'952','2022-09-28 15:49:01','952','2022-09-28 15:54:05',10,0),('8','284',25,'21','2022-09-25','2022-09-28 15:58:46','2022-09-29 15:58:46','952',675795.56,675795.56,'952','2022-09-28 15:59:48','952','2022-09-28 16:00:14',10,0),('8','284',26,'22','2022-09-27','2022-09-28 22:57:32','2022-09-29 22:57:32','952',2353785.83,2353785.83,'952','2022-09-28 23:02:46','952','2022-09-28 23:03:30',10,0),('8','284',27,'23','2022-09-28','2022-09-28 23:04:22','2022-09-29 23:04:22','952',1418991.53,1418991.53,'952','2022-09-29 09:28:05','952','2022-09-30 00:12:41',10,0),('8','284',28,'24','2022-09-29','2022-09-30 00:14:00','2022-10-01 00:14:00','952',1530148.07,1530148.07,'952','2022-09-30 11:00:26','952','2022-09-30 11:15:37',10,0),('8','284',29,'25','2022-09-30','2022-10-01 17:39:07','2022-10-02 17:39:07','952',1662495.45,1662495.45,'952','2022-10-01 17:47:00','952','2022-10-01 21:24:22',10,0),('8','284',30,'26','2022-10-01','2022-10-07 14:30:34','2022-10-08 14:30:34','952',1238209.28,1238209.28,'952','2022-10-07 15:17:43','952','2022-10-07 15:27:07',10,0),('8','284',31,'27','2022-10-03','2022-10-07 15:27:48','2022-10-08 15:27:48','952',1074487.04,1074487.04,'952','2022-10-07 15:29:12','952','2022-10-07 15:38:45',10,0),('8','284',32,'28','2022-10-05','2022-10-07 15:40:21','2022-10-08 15:40:21','952',2746311.92,2746311.92,'952','2022-10-07 15:42:11','952','2022-10-07 15:48:39',10,0),('8','284',33,'29','2022-10-06','2022-10-07 15:49:21','2022-10-08 15:49:21','952',1677008.52,1677008.52,'952','2022-10-07 15:51:48','952','2022-10-07 15:53:08',10,0),('8','284',34,'30','2022-10-07','2022-10-07 15:54:00','2022-10-08 15:54:00','952',1845373.97,1845373.97,'952','2022-10-08 22:51:26','952','2022-10-09 23:07:22',10,0),('8','284',35,'31','2022-10-08','2022-10-09 23:08:44','2022-10-10 23:08:44','952',1987410.75,1987410.75,'952','2022-10-10 06:37:06','952','2022-10-10 06:37:39',10,0),('8','284',36,'32','2022-10-09','2022-10-10 06:56:11','2022-10-11 06:56:11','952',2774867.55,2774867.55,'952','2022-10-10 14:57:18','952','2022-10-10 14:58:04',10,0),('8','284',37,'33','2022-10-10','2022-10-10 15:21:17','2022-10-11 15:21:17','952',4180320.30,4180320.30,'952','2022-10-12 00:06:09','952','2022-10-12 00:11:09',10,0),('8','284',38,'33','2022-10-11','2022-10-12 23:18:08','2022-10-13 23:18:08','952',2500268.55,2641309.34,'952','2022-10-12 23:22:44','952','2022-10-14 08:47:33',10,0),('8','284',39,'34','2022-10-13','2022-10-14 08:53:13','2022-10-15 08:53:13','952',817440.00,922240.00,'952','2022-10-14 08:55:12','952','2022-10-14 08:56:57',10,0),('8','284',40,'35','2022-10-14','2022-10-16 10:44:41','2022-10-17 10:44:41','952',2707137.00,2707137.00,'952','2022-10-16 10:47:50','952','2022-10-16 10:48:32',10,0),('8','284',41,'36','2022-10-15','2022-10-16 10:49:42','2022-10-17 10:49:42','952',2266368.75,2266368.75,'952','2022-10-16 11:09:37','952','2022-10-16 11:10:17',10,0),('8','284',42,'36','2022-10-16','2022-10-19 13:33:27','2022-10-20 13:33:27','952',3362712.75,3362712.75,'952','2022-10-19 15:08:23','952','2022-10-19 15:09:13',10,0),('8','284',43,'37','2022-10-17','2022-10-19 15:10:52','2022-10-20 15:10:52','952',2769095.25,2769095.25,'952','2022-10-19 15:14:40','952','2022-10-21 08:25:03',10,0),('8','284',44,'40','2022-10-18','2022-10-21 08:28:07','2022-10-22 08:28:07','952',460000.00,450000.00,'952','2022-10-21 08:29:46','952','2022-10-21 08:30:09',10,0),('8','284',45,'41','2022-10-20','2022-10-21 08:36:43','2022-10-22 08:36:43','952',3208966.90,3208966.90,'952','2022-10-21 08:58:39','952','2022-10-21 08:59:08',10,0),('8','284',46,'42','2022-10-21','2022-10-22 16:12:19','2022-10-23 16:12:19','952',0.00,0.00,'952','2022-10-24 15:36:28','952','2022-10-24 15:37:54',10,0),('8','284',47,'43','2022-10-21','2022-10-24 15:39:28','2022-10-25 15:39:28','952',871049.10,889984.95,'952','2022-10-24 15:40:19','952','2022-10-24 15:41:41',10,0),('8','284',48,'46','2022-10-25','2022-10-26 13:10:10','2022-10-27 13:10:10','952',3738753.65,3738753.65,'952','2022-10-26 13:12:34','952','2022-10-27 11:04:17',10,0),('8','284',49,'48','2022-10-26','2022-10-27 11:05:30','2022-10-28 11:05:30','952',187532.35,187532.35,'952','2022-10-27 11:06:52','952','2022-10-27 11:07:27',10,0),('8','284',50,'50','2022-11-02','2022-11-03 15:21:23','2022-11-04 15:21:23','952',1576530.00,1576530.00,'952','2022-11-03 15:24:51','952','2022-11-05 00:01:08',10,0),('8','284',51,'51','2022-11-03','2022-11-05 00:03:14','2022-11-06 00:03:14','952',2080947.50,2122566.45,'952','2022-11-05 00:06:59','952','2022-11-06 07:10:34',10,0),('8','284',52,'52','2022-11-06','2022-11-06 07:11:45','2022-11-07 07:11:45','952',1790872.50,1826689.95,'952','2022-11-06 07:16:26','952','2022-11-06 19:20:06',10,0),('8','284',53,'53','2022-11-05','2022-11-07 11:13:14','2022-11-08 11:13:14','952',1228497.50,1253067.45,'952','2022-11-07 11:14:46','952','2022-11-07 11:23:04',10,0),('8','284',54,'54','2022-11-06','2022-11-07 11:24:37','2022-11-08 11:24:37','952',458247.50,467412.45,'952','2022-11-07 11:26:35','952','2022-11-07 11:29:47',10,0),('8','284',55,'55','2022-11-06','2022-11-07 11:38:41','2022-11-08 11:38:41','952',1120200.00,1120200.00,'952','2022-11-07 11:43:39','952','2022-11-08 23:20:17',10,0),('8','284',56,'56','2022-11-07','2022-11-08 23:21:09','2022-11-09 23:21:09','952',3284882.50,3284882.50,'952','2022-11-08 23:25:49','952','2022-11-09 12:01:24',10,0),('8','284',57,'57','2022-11-08','2022-11-09 12:02:21','2022-11-10 12:02:21','952',2456710.00,2456710.00,'952','2022-11-09 12:52:44','952','2022-11-09 12:54:11',10,0),('8','284',58,'58','2022-11-09','2022-11-11 06:47:46','2022-11-12 06:47:46','952',2511200.00,2511200.00,'952','2022-11-11 06:53:12','952','2022-11-11 11:58:34',10,0),('8','284',59,'59','2022-11-10','2022-11-12 06:32:03','2022-11-13 06:32:03','952',3085130.00,3085130.00,'952','2022-11-12 06:34:11','952','2022-11-12 06:34:44',10,0),('8','284',60,'60','2022-11-11','2022-11-12 06:37:13','2022-11-13 06:37:13','952',3076112.50,3076112.50,'952','2022-11-13 10:26:04','952','2022-11-14 10:42:58',10,0),('8','284',61,'61','2022-11-12','2022-11-14 10:44:16','2022-11-15 10:44:16','952',1429910.00,1429910.00,'952','2022-11-14 10:46:35','952','2022-11-14 10:48:42',10,0),('8','284',62,'62','2022-11-13','2022-11-14 10:49:32','2022-11-15 10:49:32','952',2629292.50,2681878.35,'952','2022-11-14 10:52:40','952','2022-11-14 10:55:06',10,0),('8','284',63,'63','2022-11-14','2022-11-15 15:29:46','2022-11-16 15:29:46','952',4367045.00,4454385.90,'952','2022-11-15 15:33:08','952','2022-11-15 22:52:33',10,0),('8','284',64,'64','2022-11-15','2022-11-16 09:47:37','2022-11-17 09:47:37','952',1245203.25,1245203.25,'952','2022-11-16 09:49:48','952','2022-11-16 09:52:29',10,0),('8','284',65,'65','2022-11-16','2022-11-16 09:55:15','2022-11-17 09:55:15','952',3174479.70,3174479.70,'952','2022-11-17 16:06:49','952','2022-11-18 09:02:10',10,0),('8','284',66,'66','2022-11-17','2022-11-18 09:03:09','2022-11-19 09:03:09','952',2270540.40,2270540.40,'952','2022-11-18 09:06:16','952','2022-11-19 21:52:24',10,0),('8','284',67,'67','2022-11-18','2022-11-19 23:18:40','2022-11-20 23:18:40','952',1791754.95,1791754.95,'952','2022-11-20 08:34:05','952','2022-11-20 08:47:47',10,0),('8','284',68,'68','2022-11-19','2022-11-20 08:48:54','2022-11-21 08:48:54','952',1812279.90,1812279.90,'952','2022-11-20 08:51:55','952','2022-11-22 08:07:07',10,0),('8','284',69,'69','2022-11-20','2022-11-22 08:09:55','2022-11-23 08:09:55','952',2297465.85,2297465.85,'952','2022-11-22 08:12:40','952','2022-11-22 08:14:44',10,0),('8','284',70,'70','2022-11-21','2022-11-22 08:16:08','2022-11-23 08:16:08','952',510000.00,510000.00,'952','2022-11-24 13:18:29','952','2022-11-24 13:21:50',10,0),('8','284',71,'71','2022-11-22','2022-11-24 13:23:20','2022-11-25 13:23:20','952',1814355.75,1814355.75,'952','2022-11-24 13:25:08','952','2022-11-24 13:27:22',10,0),('8','284',72,'72','2022-11-23','2022-11-24 13:28:11','2022-11-25 13:28:11','952',2082306.52,2082306.52,'952','2022-11-24 13:29:50','952','2022-11-24 13:32:42',10,0),('8','284',73,'73','2022-11-24','2022-11-24 13:33:29','2022-11-25 13:33:29','952',2281838.75,2281838.75,'952','2022-11-26 07:42:16','952','2022-11-27 14:32:32',10,0),('8','284',74,'74','2022-11-25','2022-11-27 14:37:38','2022-11-28 14:37:38','952',2239086.80,2239086.80,'952','2022-11-27 14:40:41','952','2022-11-27 14:45:31',10,0),('8','284',75,'75','2022-11-26','2022-11-27 14:46:43','2022-11-28 14:46:43','952',2010297.69,2033764.20,'952','2022-11-27 14:51:47','952','2022-11-27 14:53:54',10,0),('8','284',76,'76','2022-11-27','2022-11-28 18:26:30','2022-11-29 18:26:30','952',2547643.57,2577382.60,'952','2022-11-28 18:30:42','952','2022-12-01 00:15:12',10,0),('8','284',77,'77','2022-11-28','2022-12-01 00:16:21','2022-12-02 00:16:21','952',3211245.84,3248731.20,'952','2022-12-01 00:23:52','952','2022-12-01 00:26:36',10,0),('8','284',78,'78','2022-11-29','2022-12-01 00:28:53','2022-12-02 00:28:53','952',771300.69,780304.20,'952','2022-12-01 00:32:06','952','2022-12-01 00:32:23',10,0),('8','284',79,'79','2022-12-01','2022-12-03 08:22:31','2022-12-04 08:22:31','952',3702816.00,3702816.00,'952','2022-12-03 08:27:13','952','2022-12-03 12:33:24',10,0),('8','284',80,'80','2022-12-02','2022-12-06 12:36:34','2022-12-07 12:36:34','952',1044033.30,1005365.40,'952','2022-12-06 12:38:39','952','2022-12-06 12:42:20',10,0),('8','284',81,'Morning 81','2022-12-06','2022-12-06 12:43:30','2022-12-07 12:43:30','952',1326804.30,1277663.40,'952','2022-12-06 12:46:49','952','2022-12-07 18:17:50',10,0),('8','284',82,'Evening81','2022-12-06','2022-12-07 18:19:18','2022-12-08 18:19:18','952',2199506.40,2199506.40,'952','2022-12-07 18:22:01','952','2022-12-08 12:34:03',10,0),('8','284',83,'83','2022-12-07','2022-12-08 12:35:37','2022-12-09 12:35:37','952',4327708.50,4439908.35,'952','2022-12-08 12:36:38','952','2022-12-08 12:38:55',10,0),('8','284',84,'84','2022-12-08','2022-12-09 11:36:22','2022-12-10 11:36:22','952',1020384.00,1046838.40,'952','2022-12-09 11:41:11','952','2022-12-11 16:42:16',10,0),('8','284',85,'85','2022-12-11','2022-12-12 11:53:40','2022-12-13 11:53:40','952',1954937.70,2244558.10,'952','2022-12-14 07:48:32','952','2022-12-14 07:51:28',10,0),('8','284',86,'86','2022-12-13','2022-12-14 07:52:18','2022-12-15 07:52:18','952',4216037.20,4216037.20,'952','2022-12-14 07:54:53','952','2022-12-14 07:59:12',10,0),('8','284',87,'87','2022-12-13','2022-12-14 08:00:20','2022-12-15 08:00:20','952',2763417.50,2763417.50,'952','2022-12-14 08:04:01','952','2022-12-14 08:08:57',10,0),('8','284',88,'88','2022-12-14','2022-12-19 08:29:10','2022-12-20 08:29:10','952',3324337.70,3324337.70,'952','2022-12-19 08:34:03','952','2022-12-19 08:36:10',10,0),('8','284',89,'89','2022-12-15','2022-12-19 08:37:02','2022-12-20 08:37:02','952',1257189.50,1257189.50,'952','2022-12-19 08:39:41','952','2022-12-19 08:41:24',10,0),('8','284',90,'90','2022-12-17','2022-12-19 08:42:10','2022-12-20 08:42:10','952',2450568.60,2450568.60,'952','2022-12-19 08:44:35','952','2022-12-19 08:50:02',10,0),('8','284',91,'91','2022-12-18','2022-12-19 08:52:59','2022-12-20 08:52:59','952',2762199.20,2762199.20,'952','2022-12-19 08:55:41','952','2022-12-19 08:59:57',10,0),('8','284',92,'92','2022-12-18','2022-12-19 09:12:16','2022-12-20 09:12:16','952',2900821.90,2900821.90,'952','2022-12-19 09:14:51','952','2022-12-19 09:19:37',10,0),('8','284',93,'93','2022-12-12','2022-12-20 08:03:52','2022-12-21 08:03:52','952',1771814.30,1771814.30,'952','2022-12-20 08:05:42','952','2022-12-20 08:07:47',10,0),('8','284',94,'94','2022-12-20','2022-12-21 10:34:54','2022-12-22 10:34:54','952',2274935.00,2274935.00,'952','2022-12-21 10:36:38','952','2022-12-22 09:28:53',10,0),('8','284',95,'95','2022-12-21','2022-12-22 09:29:58','2022-12-23 09:29:58','952',2659651.20,2659651.20,'952','2022-12-22 09:32:05','952','2022-12-22 09:34:07',10,0),('8','284',96,'96','2022-12-22','2022-12-25 09:24:57','2022-12-26 09:24:57','952',2325576.60,2325576.60,'952','2022-12-25 09:26:31','952','2022-12-25 09:29:44',10,0),('8','284',97,'97','2022-12-23','2022-12-25 09:30:39','2022-12-26 09:30:39','952',1639053.70,1639053.70,'952','2022-12-25 09:33:22','952','2022-12-25 09:35:38',10,0),('8','284',98,'98','2022-12-24','2022-12-25 09:36:33','2022-12-26 09:36:33','952',1005522.20,1005522.20,'952','2022-12-30 12:08:53','952','2022-12-30 12:10:46',10,0),('8','284',99,'99','2022-12-25','2022-12-30 12:11:59','2022-12-31 12:11:59','952',929569.10,929569.10,'952','2022-12-30 12:13:51','952','2022-12-30 12:22:44',10,0),('8','284',100,'100','2022-12-26','2022-12-30 12:23:42','2022-12-31 12:23:42','952',1433622.90,1433622.90,'952','2022-12-30 12:26:24','952','2022-12-30 12:28:27',10,0),('8','284',101,'101','2022-12-27','2022-12-30 12:29:33','2022-12-31 12:29:33','952',807122.20,807122.20,'952','2022-12-30 12:32:02','952','2022-12-30 12:38:51',10,0),('8','284',102,'102','2022-12-28','2022-12-30 12:39:39','2022-12-31 12:39:39','952',1054341.00,1054341.00,'952','2022-12-30 12:41:28','952','2022-12-30 12:42:55',10,0),('8','284',103,'103','2022-12-30','2023-01-07 10:55:09','2023-01-08 10:55:09','952',951817.96,990146.20,'952','2023-01-07 11:00:18','952','2023-01-07 11:03:45',10,0),('8','284',104,'104','2023-01-04','2023-01-07 11:05:00','2023-01-08 11:05:00','952',1062465.36,1062465.36,'952','2023-01-07 11:06:47','952','2023-01-07 11:08:27',10,0),('8','284',105,'105','2023-01-05','2023-01-07 11:09:19','2023-01-08 11:09:19','952',1438651.62,1438651.62,'952','2023-01-07 11:11:19','952','2023-01-07 11:13:33',10,0),('8','284',106,'106','2023-01-06','2023-01-07 11:14:43','2023-01-08 11:14:43','952',0.00,0.00,'952','2023-01-08 07:32:25','952','2023-01-08 07:32:47',10,0),('8','284',107,'107','2023-01-06','2023-01-08 07:33:48','2023-01-09 07:33:48','952',1379412.20,1379412.20,'952','2023-01-08 07:36:14','952','2023-01-09 22:18:23',10,0),('8','284',108,'108','2023-01-07','2023-01-09 22:19:50','2023-01-10 22:19:50','952',1515523.70,1515523.70,'952','2023-01-09 22:21:56','952','2023-01-09 22:25:13',10,0),('8','284',109,'109','2023-01-08','2023-01-09 22:26:15','2023-01-10 22:26:15','952',1283506.86,1283506.86,'952','2023-01-09 22:29:10','952','2023-01-09 22:31:48',10,0),('8','284',110,'110','2023-01-09','2023-01-09 22:32:32','2023-01-10 22:32:32','952',0.00,0.00,'952','2023-01-12 15:44:55','952','2023-01-12 15:45:13',10,0),('8','284',111,'111','2023-01-09','2023-01-12 15:47:08','2023-01-13 15:47:08','952',3005601.18,3005601.18,'952','2023-01-12 15:49:05','952','2023-01-12 15:51:54',10,0),('8','284',112,'112','2023-01-10','2023-01-12 15:52:42','2023-01-13 15:52:42','952',1283572.42,1283572.42,'952','2023-01-12 15:55:29','952','2023-01-12 15:57:36',10,0),('8','284',113,'113','2023-01-11','2023-01-12 15:59:09','2023-01-13 15:59:09','952',1568284.60,1568284.60,'952','2023-01-12 16:13:19','952','2023-01-14 21:22:45',10,0),('8','284',114,'114','2023-01-12','2023-01-14 21:23:39','2023-01-15 21:23:39','952',1459806.64,1459806.64,'952','2023-01-14 21:27:18','952','2023-01-14 21:30:01',10,0),('8','284',115,'115','2023-01-13','2023-01-20 12:36:22','2023-01-21 12:36:22','952',509618.74,509618.74,'952','2023-01-20 12:40:07','952','2023-01-20 12:43:11',10,0),('8','284',116,'116','2023-01-16','2023-01-20 12:45:09','2023-01-21 12:45:09','952',2359271.96,2359271.96,'952','2023-01-20 12:48:06','952','2023-01-20 12:50:24',10,0),('8','284',117,'117','2023-01-17','2023-01-20 12:51:44','2023-01-21 12:51:44','952',2457862.28,2457862.28,'952','2023-01-20 12:54:36','952','2023-01-20 12:57:12',10,0),('8','284',118,'118','2023-01-18','2023-01-20 12:58:26','2023-01-21 12:58:26','952',1420881.88,1430418.00,'952','2023-01-20 13:00:27','952','2023-01-20 13:02:25',10,0),('8','284',119,'119','2023-01-19','2023-01-20 13:04:30','2023-01-21 13:04:30','952',1562786.50,1573275.00,'952','2023-01-20 13:06:51','952','2023-01-20 13:09:17',10,0),('8','284',120,'120','2023-01-20','2023-01-20 13:10:25','2023-01-21 13:10:25','952',1921799.02,1934697.00,'952','2023-01-24 17:19:17','952','2023-02-07 14:57:18',10,0),('8','284',121,'121','2023-01-21','2023-02-07 14:59:56','2023-02-08 14:59:56','952',1973636.08,1751748.00,'952','2023-02-07 15:06:35','952','2023-02-07 15:10:18',10,0),('8','284',122,'122','2023-01-22','2023-02-07 15:12:33','2023-02-08 15:12:33','952',2074802.86,1841541.00,'952','2023-02-07 15:14:27','952','2023-02-07 15:16:50',10,0),('8','284',123,'123','2023-01-23','2023-02-07 15:17:33','2023-02-08 15:17:33','952',851422.00,755700.00,'952','2023-02-07 15:20:15','952','2023-02-07 15:22:47',10,0),('8','284',124,'124','2023-01-24','2023-02-07 15:27:38','2023-02-08 15:27:38','952',520421.98,461913.00,'952','2023-02-07 15:34:22','952','2023-02-07 15:37:15',10,0),('8','284',125,'125','2023-01-31','2023-02-07 15:40:36','2023-02-08 15:40:36','952',0.00,0.00,'952','2023-02-07 15:46:29','952','2023-02-07 15:46:46',10,0),('8','284',126,'126','2023-01-31','2023-02-07 15:47:42','2023-02-08 15:47:42','952',0.00,0.00,'952','2023-02-07 15:50:03','952','2023-02-07 15:50:30',10,0),('8','284',127,'127','2023-01-31','2023-02-07 15:51:23','2023-02-08 15:51:23','952',925636.66,925636.66,'952','2023-02-07 15:53:50','952','2023-02-07 15:57:27',10,0),('8','284',129,'128','2023-02-01','2023-02-07 15:59:03','2023-02-08 15:59:03','952',978310.58,998571.45,'952','2023-02-07 16:00:40','952','2023-02-08 09:48:19',10,0),('8','284',130,'130','2023-02-02','2023-02-08 09:49:46','2023-02-09 09:49:46','952',1281334.34,1307870.85,'952','2023-02-08 10:03:53','952','2023-02-08 10:05:50',10,0),('8','284',131,'131','2023-02-03','2023-02-08 10:09:33','2023-02-09 10:09:33','952',1121436.68,1144661.70,'952','2023-02-08 10:11:01','952','2023-02-11 09:36:35',10,0),('8','284',132,'132','2023-02-05','2023-02-11 09:39:03','2023-02-12 09:39:03','952',1334826.22,1362470.55,'952','2023-02-11 09:42:08','952','2023-02-11 09:44:36',10,0),('8','284',133,'133','2023-02-06','2023-02-11 09:46:14','2023-02-12 09:46:14','952',1173316.30,1197615.75,'952','2023-02-11 09:50:40','952','2023-02-11 09:52:37',10,0),('8','284',134,'134','2023-02-07','2023-02-11 09:53:47','2023-02-12 09:53:47','952',2580974.76,2634426.90,'952','2023-02-11 10:00:05','952','2023-02-11 10:03:26',10,0),('8','284',135,'135','2023-02-07','2023-02-14 14:57:33','2023-02-15 14:57:33','952',1705936.70,1741266.75,'952','2023-02-17 23:42:34','952','2023-02-18 09:05:42',10,0),('8','284',136,'136','2023-02-08','2023-02-18 09:07:02','2023-02-19 09:07:02','952',78045.90,78045.90,'952','2023-02-18 09:08:29','952','2023-02-18 09:08:52',10,0),('8','284',137,'137','2023-02-09','2023-02-20 19:38:05','2023-02-21 19:38:05','952',1891583.25,1891583.25,'952','2023-02-20 19:41:00','952','2023-02-20 19:44:06',10,0),('8','284',138,'138','2023-02-10','2023-02-20 19:45:39','2023-02-21 19:45:39','952',3955245.60,3955245.60,'952','2023-02-20 20:10:38','952','2023-02-20 20:17:04',10,0),('8','284',139,'139','2023-02-11','2023-02-20 20:18:02','2023-02-21 20:18:02','952',1748325.45,1748325.45,'952','2023-02-20 20:21:52','952','2023-02-20 20:42:41',10,0),('8','284',140,'140','2023-02-12','2023-02-20 20:50:19','2023-02-21 20:50:19','952',1755901.65,1755901.65,'952','2023-02-20 20:52:58','952','2023-02-21 20:22:42',10,0),('8','284',141,'141','2023-02-13','2023-02-21 20:23:35','2023-02-22 20:23:35','952',1643475.00,1667643.75,'952','2023-02-23 23:32:09','952','2023-02-23 23:39:55',10,0),('8','284',142,'142','2023-02-18','2023-02-23 23:43:53','2023-02-24 23:43:53','952',1299952.60,1299952.60,'952','2023-02-23 23:48:29','952','2023-02-23 23:51:42',10,0),('8','284',143,'143','2023-02-19','2023-02-23 23:53:44','2023-02-24 23:53:44','952',1026779.60,1026779.60,'952','2023-02-23 23:55:57','952','2023-02-23 23:58:23',10,0),('8','284',144,'144','2023-02-20','2023-02-23 23:59:49','2023-02-24 23:59:49','952',2165715.00,2165715.00,'952','2023-02-24 00:03:31','952','2023-02-24 00:06:19',10,0),('8','284',145,'145','2023-02-21','2023-02-24 00:07:35','2023-02-25 00:07:35','952',981556.20,981556.20,'952','2023-02-24 00:09:52','952','2023-02-24 00:12:16',10,0),('8','284',146,'146','2023-02-23','2023-02-24 00:14:02','2023-02-25 00:14:02','952',1232044.40,1159571.20,'952','2023-02-24 00:17:06','952','2023-02-24 00:19:27',10,0),('8','284',147,'147','2023-02-24','2023-02-24 00:20:06','2023-02-25 00:20:06','952',1291602.20,1215625.60,'952','2023-02-24 23:09:48','952','2023-02-24 23:19:32',10,0),('8','284',148,'148','2023-02-25','2023-02-27 10:52:22','2023-02-28 10:52:22','952',1167896.60,1082021.85,'952','2023-02-27 10:53:53','952','2023-02-27 10:55:47',10,0),('8','284',149,'149','2023-02-26','2023-02-27 10:56:34','2023-02-28 10:56:34','952',946454.60,876862.35,'952','2023-02-27 10:59:40','952','2023-02-27 11:03:57',10,0),('8','284',150,'150','2023-02-27','2023-03-01 14:14:37','2023-03-02 14:14:37','952',2742752.80,2541079.80,'952','2023-03-01 23:28:23','952','2023-03-02 11:10:52',10,0),('8','284',151,'151','2023-02-28','2023-03-02 11:12:01','2023-03-03 11:12:01','952',1782950.40,1782950.40,'952','2023-03-02 11:14:25','952','2023-03-02 11:16:54',10,0),('8','284',152,'152','2023-03-01','2023-03-02 11:18:03','2023-03-03 11:18:03','952',1336053.60,1336053.60,'952','2023-03-02 11:20:15','952','2023-03-02 11:23:13',10,0),('8','284',153,'153','2023-03-02','2023-03-04 09:16:36','2023-03-05 09:16:36','952',1107706.95,1107706.95,'952','2023-03-04 09:20:32','952','2023-03-04 09:22:46',10,0),('8','284',154,'154','2023-03-03','2023-03-04 09:23:24','2023-03-05 09:23:24','952',978503.40,931908.00,'952','2023-03-04 09:25:26','952','2023-03-06 12:19:55',10,0),('8','284',155,'155','2023-03-04','2023-03-06 12:20:42','2023-03-07 12:20:42','952',1260573.30,1200546.00,'952','2023-03-06 12:22:03','952','2023-03-06 12:24:03',10,0),('8','284',156,'156','2023-03-05','2023-03-06 12:24:54','2023-03-07 12:24:54','952',1322259.75,1259295.00,'952','2023-03-06 12:26:11','952','2023-03-08 08:50:39',10,0),('8','284',157,'157','2023-03-06','2023-03-08 08:52:03','2023-03-09 08:52:03','952',3132681.30,2983506.00,'952','2023-03-08 08:54:48','952','2023-03-08 09:02:12',10,0),('8','284',158,'158','2023-03-07','2023-03-15 16:36:14','2023-03-16 16:36:14','952',1374702.00,1374702.00,'952','2023-03-15 16:38:12','952','2023-03-15 16:39:45',10,0),('8','284',159,'159','2023-03-12','2023-03-15 16:41:07','2023-03-16 16:41:07','952',1545675.00,1545675.00,'952','2023-03-15 16:42:24','952','2023-03-15 16:44:12',10,0),('8','284',160,'160','2023-03-13','2023-03-15 16:45:08','2023-03-16 16:45:08','952',1985613.00,1985613.00,'952','2023-03-15 16:47:06','952','2023-03-15 16:52:43',10,0),('8','284',161,'161','2023-03-14','2023-03-15 16:54:57','2023-03-16 16:54:57','952',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',3,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=961 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('8','284','1','1',1,'1','1',808253.78,808253.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','1',2,'2','1',54913.81,54913.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','1',3,'3','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','1',6,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','2',7,'1','1',260.99,3056.59,2795.60,522777.20,0.00,0.00,0.00,0.00,0.00),('8','284','1','2',8,'2','1',290.82,568.00,277.18,51832.66,0.00,0.00,0.00,0.00,0.00),('8','284','2','2',9,'3','1',279.39,2340.77,2061.38,385478.06,0.00,0.00,0.00,0.00,0.00),('8','284','2','2',10,'4','1',241.69,301.11,59.42,11111.54,0.00,0.00,0.00,0.00,0.00),('8','284','3','2',11,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','2',12,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','3',13,'1','1',3056.59,5640.91,2584.32,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','3',14,'2','1',568.00,568.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','3',15,'3','1',2340.77,4975.52,2634.75,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','3',16,'4','1',301.11,301.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','3',17,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','3',18,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','4',19,'1','1',5640.91,7697.13,2056.22,384513.14,0.00,0.00,0.00,0.00,0.00),('8','284','1','4',20,'2','1',568.00,568.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','4',21,'3','1',4975.52,7539.38,2563.86,479441.82,0.00,0.00,0.00,0.00,0.00),('8','284','2','4',22,'4','1',301.11,301.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','4',23,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','4',24,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','5',25,'1','1',7697.13,10681.84,2984.71,558140.77,0.00,0.00,0.00,0.00,0.00),('8','284','1','5',26,'2','1',568.00,2170.46,1602.46,299660.02,0.00,0.00,0.00,0.00,0.00),('8','284','2','5',27,'3','1',7539.38,7539.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','5',28,'4','1',301.11,3737.30,3436.19,642567.53,0.00,0.00,0.00,0.00,0.00),('8','284','3','5',29,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','5',30,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','6',31,'1','1',10681.84,13931.63,3249.79,607710.73,0.00,0.00,0.00,0.00,0.00),('8','284','1','6',32,'2','1',2170.46,2402.65,232.19,43419.53,0.00,0.00,0.00,0.00,0.00),('8','284','2','6',33,'3','1',7539.38,7539.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','6',34,'4','1',3737.30,6449.17,2711.87,507119.69,0.00,0.00,0.00,0.00,0.00),('8','284','3','6',35,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','6',36,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','7',37,'1','1',13931.63,15692.62,1760.99,329305.13,0.00,0.00,0.00,0.00,0.00),('8','284','1','7',38,'2','1',2402.65,2402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','7',39,'3','1',7539.38,9547.99,2008.61,375610.07,0.00,0.00,0.00,0.00,0.00),('8','284','2','7',40,'4','1',6449.17,9368.68,2919.51,545948.37,0.00,0.00,0.00,0.00,0.00),('8','284','3','7',41,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','7',42,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','8',43,'1','1',15692.62,18630.30,2937.68,549346.16,0.00,0.00,0.00,0.00,0.00),('8','284','1','8',44,'2','1',2402.65,2402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','8',45,'3','1',9547.99,11569.05,2021.06,377938.22,0.00,0.00,0.00,0.00,0.00),('8','284','2','8',46,'4','1',9368.68,9368.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','8',47,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','8',48,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','9',49,'1','1',18630.30,22892.98,4262.68,797121.16,0.00,0.00,0.00,0.00,0.00),('8','284','1','9',50,'2','1',2402.65,2402.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','9',51,'3','1',11569.05,14651.64,3082.59,576444.33,0.00,0.00,0.00,0.00,0.00),('8','284','2','9',52,'4','1',9368.68,11599.64,2230.96,417189.52,0.00,0.00,0.00,0.00,0.00),('8','284','3','9',53,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','9',54,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','10',55,'1','1',22892.98,24666.48,1773.50,331644.50,0.00,0.00,0.00,0.00,0.00),('8','284','1','10',56,'2','1',2402.65,2782.05,379.40,70947.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','10',57,'3','1',14651.64,16567.23,1915.59,358215.33,0.00,0.00,0.00,0.00,0.00),('8','284','2','10',58,'4','1',11599.64,12143.24,543.60,101653.20,0.00,0.00,0.00,0.00,0.00),('8','284','3','10',59,'5','1',5522.62,5522.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','10',60,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','11',61,'1','1',24666.48,27749.86,3083.38,576592.06,0.00,0.00,0.00,0.00,0.00),('8','284','1','11',62,'2','1',2782.05,2782.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','11',63,'3','1',16567.23,20262.87,3695.64,691084.68,0.00,0.00,0.00,0.00,0.00),('8','284','2','11',64,'4','1',12143.24,12933.90,790.66,147853.42,0.00,0.00,0.00,0.00,0.00),('8','284','3','11',65,'5','1',577.72,1777.72,1200.00,224400.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','11',66,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','12',67,'1','1',27749.86,31238.24,3488.38,652327.06,0.00,0.00,0.00,0.00,0.00),('8','284','1','12',68,'2','1',2782.05,5675.09,2893.04,540998.48,0.00,0.00,0.00,0.00,0.00),('8','284','2','12',69,'3','1',20262.87,20648.33,385.46,72081.02,0.00,0.00,0.00,0.00,0.00),('8','284','2','12',70,'4','1',12933.90,13195.21,261.31,48864.97,0.00,0.00,0.00,0.00,0.00),('8','284','3','12',71,'5','1',1777.72,1777.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','12',72,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','13',73,'1','1',31238.24,31238.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','13',74,'2','1',5675.09,6662.32,987.23,184612.01,0.00,0.00,0.00,0.00,0.00),('8','284','2','13',75,'3','1',20648.33,20648.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','13',76,'4','1',13195.21,16327.22,3132.01,585685.87,0.00,0.00,0.00,0.00,0.00),('8','284','3','13',77,'5','1',1777.72,3794.54,2016.82,377145.34,0.00,0.00,0.00,0.00,0.00),('8','284','4','13',78,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','14',79,'1','1',31238.24,31238.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','14',80,'2','1',6662.32,6662.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','14',81,'3','1',20648.33,20648.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','14',82,'4','1',16327.22,16327.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','14',83,'5','1',3794.54,3794.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','14',84,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','15',85,'1','1',31238.24,31238.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','15',86,'2','1',6662.32,6662.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','15',87,'3','1',20648.33,20648.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','15',88,'4','1',16327.22,16327.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','15',89,'5','1',3794.54,3794.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','15',90,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','16',91,'1','1',31238.24,31238.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','16',92,'2','1',6662.32,6662.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','16',93,'3','1',20648.33,20648.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','16',94,'4','1',16327.22,17795.09,1467.87,274491.69,0.00,0.00,0.00,0.00,0.00),('8','284','3','16',95,'5','1',3794.54,11614.56,7820.02,1462343.74,0.00,0.00,0.00,0.00,0.00),('8','284','4','16',96,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','17',97,'1','1',31238.24,31238.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','17',98,'2','1',6662.32,6662.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','17',99,'3','1',20648.33,20648.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','17',100,'4','1',17795.09,17795.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','17',101,'5','1',11614.56,19189.76,7575.20,1416562.40,0.00,0.00,0.00,0.00,0.00),('8','284','4','17',102,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','18',103,'1','1',31238.24,34822.43,3584.19,670243.53,0.00,0.00,0.00,0.00,0.00),('8','284','1','18',104,'2','1',6662.32,9842.21,3179.89,594639.43,0.00,0.00,0.00,0.00,0.00),('8','284','2','18',105,'3','1',20648.33,23870.39,3222.06,602525.22,0.00,0.00,0.00,0.00,0.00),('8','284','2','18',106,'4','1',17795.09,17976.43,181.34,33910.58,0.00,0.00,0.00,0.00,0.00),('8','284','3','18',107,'5','1',19189.76,20581.26,1391.50,260210.50,0.00,0.00,0.00,0.00,0.00),('8','284','4','18',108,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','19',109,'1','1',34822.43,39263.54,4441.11,830487.57,0.00,0.00,0.00,0.00,0.00),('8','284','1','19',110,'2','1',9842.21,13206.73,3364.52,629165.24,0.00,0.00,0.00,0.00,0.00),('8','284','2','19',111,'3','1',23870.39,26655.80,2785.41,520871.67,0.00,0.00,0.00,0.00,0.00),('8','284','2','19',112,'4','1',17976.43,17976.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','19',113,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','19',114,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','20',115,'1','1',39263.54,41359.65,2096.11,391972.57,0.00,0.00,0.00,0.00,0.00),('8','284','1','20',116,'2','1',13206.73,13206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','20',117,'3','1',26655.80,30176.95,3521.15,658455.05,0.00,0.00,0.00,0.00,0.00),('8','284','2','20',118,'4','1',17976.43,17976.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','20',119,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','20',120,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','21',121,'1','1',41359.65,41359.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','21',122,'2','1',13206.73,13206.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','21',123,'3','1',30176.95,30176.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','21',124,'4','1',17976.43,17976.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','21',125,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','21',126,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','22',127,'1','1',41359.65,44485.07,3125.42,584453.54,0.00,0.00,0.00,0.00,0.00),('8','284','1','22',128,'2','1',13206.73,14975.12,1768.39,330688.93,0.00,0.00,0.00,0.00,0.00),('8','284','2','22',129,'3','1',30176.95,34216.50,4039.55,755395.85,0.00,0.00,0.00,0.00,0.00),('8','284','2','22',130,'4','1',17976.43,17976.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','22',131,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','22',132,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','23',133,'1','1',44485.07,44485.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','23',134,'2','1',14975.12,14975.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','23',135,'3','1',34216.50,38506.31,4289.81,802194.47,0.00,0.00,0.00,0.00,0.00),('8','284','2','23',136,'4','1',17976.43,20137.29,2160.86,404080.82,0.00,0.00,0.00,0.00,0.00),('8','284','3','23',137,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','23',138,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','24',139,'1','1',44485.07,44485.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','24',140,'2','1',14975.12,14975.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','24',141,'3','1',38506.31,41196.65,2690.34,503093.58,0.00,0.00,0.00,0.00,0.00),('8','284','2','24',142,'4','1',20137.29,23967.76,3830.47,716297.89,0.00,0.00,0.00,0.00,0.00),('8','284','3','24',143,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','24',144,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','25',145,'1','1',44485.07,44485.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','25',146,'2','1',14975.12,14975.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','25',147,'3','1',41196.65,41196.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','25',148,'4','1',23967.76,27581.64,3613.88,675795.56,0.00,0.00,0.00,0.00,0.00),('8','284','3','25',149,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','25',150,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','26',151,'1','1',44485.07,47631.84,3146.77,588445.99,0.00,0.00,0.00,0.00,0.00),('8','284','1','26',152,'2','1',14975.12,14975.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','26',153,'3','1',41196.65,46097.27,4900.62,916415.94,0.00,0.00,0.00,0.00,0.00),('8','284','2','26',154,'4','1',27581.64,32121.34,4539.70,848923.90,0.00,0.00,0.00,0.00,0.00),('8','284','3','26',155,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','26',156,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','27',157,'1','1',47631.84,50195.11,2563.27,479331.49,0.00,0.00,0.00,0.00,0.00),('8','284','1','27',158,'2','1',14975.12,14975.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','27',159,'3','1',46097.27,48480.26,2382.99,445619.13,0.00,0.00,0.00,0.00,0.00),('8','284','2','27',160,'4','1',32121.34,34763.27,2641.93,494040.91,0.00,0.00,0.00,0.00,0.00),('8','284','3','27',161,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','27',162,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','28',163,'1','1',50195.11,53247.97,3052.86,570884.82,0.00,0.00,0.00,0.00,0.00),('8','284','1','28',164,'2','1',14975.12,14975.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','28',165,'3','1',48480.26,50482.21,2001.95,374364.65,0.00,0.00,0.00,0.00,0.00),('8','284','2','28',166,'4','1',34763.27,37891.07,3127.80,584898.60,0.00,0.00,0.00,0.00,0.00),('8','284','3','28',167,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','28',168,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','29',169,'1','1',53247.97,56796.47,3548.50,663569.50,0.00,0.00,0.00,0.00,0.00),('8','284','1','29',170,'2','1',14975.12,17410.12,2435.00,455345.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','29',171,'3','1',50482.21,51185.90,703.69,131590.03,0.00,0.00,0.00,0.00,0.00),('8','284','2','29',172,'4','1',37891.07,40094.23,2203.16,411990.92,0.00,0.00,0.00,0.00,0.00),('8','284','3','29',173,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','29',174,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','30',175,'1','1',56796.47,59632.35,2835.88,530309.56,0.00,0.00,0.00,0.00,0.00),('8','284','1','30',176,'2','1',17410.12,17914.03,503.91,94231.17,0.00,0.00,0.00,0.00,0.00),('8','284','2','30',177,'3','1',51185.90,52671.79,1485.89,277861.43,0.00,0.00,0.00,0.00,0.00),('8','284','2','30',178,'4','1',40094.23,41889.99,1795.76,335807.12,0.00,0.00,0.00,0.00,0.00),('8','284','3','30',179,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','30',180,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','31',181,'1','1',59632.35,59632.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','31',182,'2','1',17914.03,17914.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','31',183,'3','1',52671.79,53012.12,340.33,63641.71,0.00,0.00,0.00,0.00,0.00),('8','284','2','31',184,'4','1',41889.99,47295.58,5405.59,1010845.33,0.00,0.00,0.00,0.00,0.00),('8','284','3','31',185,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','31',186,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','32',187,'1','1',59632.35,65722.11,6089.76,1138785.12,0.00,0.00,0.00,0.00,0.00),('8','284','1','32',188,'2','1',17914.03,21843.09,3929.06,734734.22,0.00,0.00,0.00,0.00,0.00),('8','284','2','32',189,'3','1',53012.12,57679.46,4667.34,872792.58,0.00,0.00,0.00,0.00,0.00),('8','284','2','32',190,'4','1',47295.58,47295.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','32',191,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','32',192,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','33',193,'1','1',65722.11,70263.10,4540.99,849165.13,0.00,0.00,0.00,0.00,0.00),('8','284','1','33',194,'2','1',21843.09,25649.26,3806.17,711753.79,0.00,0.00,0.00,0.00,0.00),('8','284','2','33',195,'3','1',57679.46,58300.26,620.80,116089.60,0.00,0.00,0.00,0.00,0.00),('8','284','2','33',196,'4','1',47295.58,47295.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','33',197,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','33',198,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','34',199,'1','1',70263.10,73517.34,3254.24,608542.88,0.00,0.00,0.00,0.00,0.00),('8','284','1','34',200,'2','1',25649.26,27001.04,1351.78,252782.86,0.00,0.00,0.00,0.00,0.00),('8','284','2','34',201,'3','1',58300.26,58317.10,16.84,3149.08,0.00,0.00,0.00,0.00,0.00),('8','284','2','34',202,'4','1',47295.58,52541.03,5245.45,980899.15,0.00,0.00,0.00,0.00,0.00),('8','284','3','34',203,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','34',204,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','35',205,'1','1',73517.34,77085.22,3567.88,695736.60,0.00,0.00,0.00,0.00,0.00),('8','284','1','35',206,'2','1',27001.04,33625.01,6623.97,1291674.15,0.00,0.00,0.00,0.00,0.00),('8','284','2','35',207,'3','1',58317.10,58317.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','35',208,'4','1',52541.03,52541.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','35',209,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','35',210,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','36',211,'1','1',77085.22,79193.51,2108.29,411116.55,0.00,0.00,0.00,0.00,0.00),('8','284','1','36',212,'2','1',33625.01,34457.31,832.30,162298.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','36',213,'3','1',58317.10,61740.33,3423.23,667529.85,0.00,0.00,0.00,0.00,0.00),('8','284','2','36',214,'4','1',52541.03,60407.30,7866.27,1533922.65,0.00,0.00,0.00,0.00,0.00),('8','284','3','36',215,'5','1',20581.26,20581.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','36',216,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','37',217,'1','1',79193.51,79193.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','37',218,'2','1',34457.31,34617.92,160.61,31318.95,0.00,0.00,0.00,0.00,0.00),('8','284','2','37',219,'3','1',61740.33,68765.71,7025.38,1369949.10,0.00,0.00,0.00,0.00,0.00),('8','284','2','37',220,'4','1',60407.30,68025.71,7618.41,1485589.95,0.00,0.00,0.00,0.00,0.00),('8','284','3','37',221,'5','1',20581.26,27214.40,6633.14,1293462.30,0.00,0.00,0.00,0.00,0.00),('8','284','4','37',222,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','38',223,'1','1',79193.51,79193.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','38',224,'2','1',34617.92,34617.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','38',225,'3','1',68765.71,71062.72,2297.01,473184.06,0.00,0.00,0.00,0.00,0.00),('8','284','2','38',226,'4','1',68025.71,77570.33,9544.62,1966191.72,0.00,0.00,0.00,0.00,0.00),('8','284','3','38',227,'5','1',27214.40,28194.66,980.26,201933.56,0.00,0.00,0.00,0.00,0.00),('8','284','4','38',228,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','39',229,'1','1',79193.51,79193.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','39',230,'2','1',34617.92,34617.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','39',231,'3','1',71062.72,71815.94,753.22,165708.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','39',232,'4','1',77570.33,81009.11,3438.78,756531.60,0.00,0.00,0.00,0.00,0.00),('8','284','3','39',233,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','39',234,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','40',235,'1','1',79193.51,82264.30,3070.79,690927.75,0.00,0.00,0.00,0.00,0.00),('8','284','1','40',236,'2','1',34617.92,37479.63,2861.71,643884.75,0.00,0.00,0.00,0.00,0.00),('8','284','2','40',237,'3','1',71815.94,74668.31,2852.37,641783.25,0.00,0.00,0.00,0.00,0.00),('8','284','2','40',238,'4','1',81009.11,84255.96,3246.85,730541.25,0.00,0.00,0.00,0.00,0.00),('8','284','3','40',239,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','40',240,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','41',241,'1','1',82264.30,84764.45,2500.15,562533.75,0.00,0.00,0.00,0.00,0.00),('8','284','1','41',242,'2','1',37479.63,41518.48,4038.85,908741.25,0.00,0.00,0.00,0.00,0.00),('8','284','2','41',243,'3','1',74668.31,76252.83,1584.52,356517.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','41',244,'4','1',84255.96,86205.19,1949.23,438576.75,0.00,0.00,0.00,0.00,0.00),('8','284','3','41',245,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','41',246,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','42',247,'1','1',84764.45,88295.67,3531.22,794524.50,0.00,0.00,0.00,0.00,0.00),('8','284','1','42',248,'2','1',41518.48,43140.34,1621.86,364918.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','42',249,'3','1',76252.83,80577.48,4324.65,973046.25,0.00,0.00,0.00,0.00,0.00),('8','284','2','42',250,'4','1',86205.19,91672.85,5467.66,1230223.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','42',251,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','42',252,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','43',253,'1','1',88295.67,88295.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','43',254,'2','1',43140.34,43140.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','43',255,'3','1',80577.48,82960.22,2382.74,536116.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','43',256,'4','1',91672.85,101597.20,9924.35,2232978.75,0.00,0.00,0.00,0.00,0.00),('8','284','3','43',257,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','43',258,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','44',259,'1','1',88295.67,88295.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','44',260,'2','1',43140.34,43140.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','44',261,'3','1',82960.22,82960.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','44',262,'4','1',101597.20,103597.20,2000.00,450000.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','44',263,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','44',264,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','45',265,'1','1',88295.67,88295.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','45',266,'2','1',43140.34,43140.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','45',267,'3','1',82960.22,90085.68,7125.46,1638855.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','45',268,'4','1',103597.20,110423.77,6826.57,1570111.10,0.00,0.00,0.00,0.00,0.00),('8','284','3','45',269,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','45',270,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','46',271,'1','1',88295.67,88295.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','46',272,'2','1',43140.34,43140.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','46',273,'3','1',90085.68,90085.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','46',274,'4','1',110423.77,110423.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','46',275,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','46',276,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','47',277,'1','1',88295.67,88295.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','47',278,'2','1',43140.34,43140.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','47',279,'3','1',90085.68,90085.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','47',280,'4','1',110423.77,114210.94,3787.17,889984.95,0.00,0.00,0.00,0.00,0.00),('8','284','3','47',281,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','47',282,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','48',283,'1','1',88295.67,88295.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','48',284,'2','1',43140.34,43140.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','48',285,'3','1',90085.68,93825.00,3739.32,878740.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','48',286,'4','1',114210.94,126381.21,12170.27,2860013.45,0.00,0.00,0.00,0.00,0.00),('8','284','3','48',287,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','48',288,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','49',289,'1','1',88295.67,88295.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','49',290,'2','1',43140.34,43140.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','49',291,'3','1',93825.00,93825.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','49',292,'4','1',126381.21,127179.22,798.01,187532.35,0.00,0.00,0.00,0.00,0.00),('8','284','3','49',293,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','49',294,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','50',295,'1','1',88295.67,90386.56,2090.89,522722.50,0.00,0.00,0.00,0.00,0.00),('8','284','1','50',296,'2','1',43140.34,45733.22,2592.88,648220.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','50',297,'3','1',93825.00,95091.30,1266.30,316575.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','50',298,'4','1',127179.22,127535.27,356.05,89012.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','50',299,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','50',300,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','51',301,'1','1',90386.56,92921.75,2535.19,646473.45,0.00,0.00,0.00,0.00,0.00),('8','284','1','51',302,'2','1',45733.22,48276.52,2543.30,648541.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','51',303,'3','1',95091.30,97781.16,2689.86,685914.30,0.00,0.00,0.00,0.00,0.00),('8','284','2','51',304,'4','1',127535.27,128090.71,555.44,141637.20,0.00,0.00,0.00,0.00,0.00),('8','284','3','51',305,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','51',306,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','52',307,'1','1',92921.75,95485.23,2563.48,653687.40,0.00,0.00,0.00,0.00,0.00),('8','284','1','52',308,'2','1',48276.52,50847.41,2570.89,655576.95,0.00,0.00,0.00,0.00,0.00),('8','284','2','52',309,'3','1',97781.16,98617.26,836.10,213205.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','52',310,'4','1',128090.71,129283.73,1193.02,304220.10,0.00,0.00,0.00,0.00,0.00),('8','284','3','52',311,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','52',312,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','53',313,'1','1',95485.23,97593.15,2107.92,537519.60,0.00,0.00,0.00,0.00,0.00),('8','284','1','53',314,'2','1',50847.41,53653.48,2806.07,715547.85,0.00,0.00,0.00,0.00,0.00),('8','284','2','53',315,'3','1',98617.26,98617.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','53',316,'4','1',129283.73,129283.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','53',317,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','53',318,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','54',319,'1','1',97593.15,97670.58,77.43,19744.65,0.00,0.00,0.00,0.00,0.00),('8','284','1','54',320,'2','1',53653.48,54945.10,1291.62,329363.10,0.00,0.00,0.00,0.00,0.00),('8','284','2','54',321,'3','1',98617.26,98617.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','54',322,'4','1',129283.73,129747.67,463.94,118304.70,0.00,0.00,0.00,0.00,0.00),('8','284','3','54',323,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','54',324,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','55',325,'1','1',97670.58,98063.43,392.85,98212.50,0.00,0.00,0.00,0.00,0.00),('8','284','1','55',326,'2','1',54945.10,56650.33,1705.23,426307.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','55',327,'3','1',98617.26,98617.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','55',328,'4','1',129747.67,132130.39,2382.72,595680.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','55',329,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','55',330,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','56',331,'1','1',98063.43,101252.46,3189.03,797257.50,0.00,0.00,0.00,0.00,0.00),('8','284','1','56',332,'2','1',56650.33,58342.92,1692.59,423147.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','56',333,'3','1',98617.26,101780.19,3162.93,790732.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','56',334,'4','1',132130.39,137225.37,5094.98,1273745.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','56',335,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','56',336,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','57',337,'1','1',101252.46,102172.91,920.45,230112.50,0.00,0.00,0.00,0.00,0.00),('8','284','1','57',338,'2','1',58342.92,58342.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','57',339,'3','1',101780.19,104402.97,2622.78,655695.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','57',340,'4','1',137225.37,143508.98,6283.61,1570902.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','57',341,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','57',342,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','58',343,'1','1',102172.91,102172.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','58',344,'2','1',58342.92,58445.42,102.50,25625.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','58',345,'3','1',104402.97,107510.10,3107.13,776782.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','58',346,'4','1',143508.98,150344.15,6835.17,1708792.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','58',347,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','58',348,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','59',349,'1','1',102172.91,102172.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','59',350,'2','1',58445.42,58445.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','59',351,'3','1',107510.10,112401.46,4891.36,1222840.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','59',352,'4','1',150344.15,157793.31,7449.16,1862290.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','59',353,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','59',354,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','60',355,'1','1',102172.91,102172.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','60',356,'2','1',58445.42,58445.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','60',357,'3','1',112401.46,117050.61,4649.15,1162287.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','60',358,'4','1',157793.31,165448.61,7655.30,1913825.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','60',359,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','60',360,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','61',361,'1','1',102172.91,102172.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','61',362,'2','1',58445.42,58445.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','61',363,'3','1',117050.61,119931.58,2880.97,720242.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','61',364,'4','1',165448.61,168287.28,2838.67,709667.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','61',365,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','61',366,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','62',367,'1','1',102172.91,105785.25,3612.34,921146.70,0.00,0.00,0.00,0.00,0.00),('8','284','1','62',368,'2','1',58445.42,62293.66,3848.24,981301.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','62',369,'3','1',119931.58,121127.28,1195.70,304903.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','62',370,'4','1',168287.28,170148.17,1860.89,474526.95,0.00,0.00,0.00,0.00,0.00),('8','284','3','62',371,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','62',372,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','63',373,'1','1',105785.25,111531.62,5746.37,1465324.35,0.00,0.00,0.00,0.00,0.00),('8','284','1','63',374,'2','1',62293.66,68676.28,6382.62,1627568.10,0.00,0.00,0.00,0.00,0.00),('8','284','2','63',375,'3','1',121127.28,121208.98,81.70,20833.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','63',376,'4','1',170148.17,175405.66,5257.49,1340659.95,0.00,0.00,0.00,0.00,0.00),('8','284','3','63',377,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','63',378,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','64',379,'1','1',111531.62,112875.84,1344.22,342776.10,0.00,0.00,0.00,0.00,0.00),('8','284','1','64',380,'2','1',68676.28,72215.21,3538.93,902427.15,0.00,0.00,0.00,0.00,0.00),('8','284','2','64',381,'3','1',121208.98,121208.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','64',382,'4','1',175405.66,175405.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','64',383,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','64',384,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','65',385,'1','1',112875.84,114772.52,1896.68,483653.40,0.00,0.00,0.00,0.00,0.00),('8','284','1','65',386,'2','1',72215.21,76677.04,4461.83,1137766.65,0.00,0.00,0.00,0.00,0.00),('8','284','2','65',387,'3','1',121208.98,121208.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','65',388,'4','1',175405.66,181496.09,6090.43,1553059.65,0.00,0.00,0.00,0.00,0.00),('8','284','3','65',389,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','65',390,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','66',391,'1','1',114772.52,115765.86,993.34,253301.70,0.00,0.00,0.00,0.00,0.00),('8','284','1','66',392,'2','1',76677.04,77077.37,400.33,102084.15,0.00,0.00,0.00,0.00,0.00),('8','284','2','66',393,'3','1',121208.98,124842.46,3633.48,926537.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','66',394,'4','1',181496.09,185373.02,3876.93,988617.15,0.00,0.00,0.00,0.00,0.00),('8','284','3','66',395,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','66',396,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','67',397,'1','1',115765.86,115765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','67',398,'2','1',77077.37,79777.67,2700.30,688576.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','67',399,'3','1',124842.46,126916.56,2074.10,528895.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','67',400,'4','1',185373.02,187625.11,2252.09,574282.95,0.00,0.00,0.00,0.00,0.00),('8','284','3','67',401,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','67',402,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','68',403,'1','1',115765.86,115765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','68',404,'2','1',79777.67,82310.16,2532.49,645784.95,0.00,0.00,0.00,0.00,0.00),('8','284','2','68',405,'3','1',126916.56,128049.55,1132.99,288912.45,0.00,0.00,0.00,0.00,0.00),('8','284','2','68',406,'4','1',187625.11,191066.61,3441.50,877582.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','68',407,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','68',408,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','69',409,'1','1',115765.86,115765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','69',410,'2','1',82310.16,82779.24,469.08,119615.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','69',411,'3','1',128049.55,131227.56,3178.01,810392.55,0.00,0.00,0.00,0.00,0.00),('8','284','2','69',412,'4','1',191066.61,196429.19,5362.58,1367457.90,0.00,0.00,0.00,0.00,0.00),('8','284','3','69',413,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','69',414,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','70',415,'1','1',115765.86,115765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','70',416,'2','1',82779.24,82779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','70',417,'3','1',131227.56,132227.56,1000.00,255000.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','70',418,'4','1',196429.19,197429.19,1000.00,255000.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','70',419,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','70',420,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','71',421,'1','1',115765.86,115765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','71',422,'2','1',82779.24,82779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','71',423,'3','1',132227.56,133643.44,1415.88,363881.16,0.00,0.00,0.00,0.00,0.00),('8','284','2','71',424,'4','1',197429.19,203073.06,5643.87,1450474.59,0.00,0.00,0.00,0.00,0.00),('8','284','3','71',425,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','71',426,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','72',427,'1','1',115765.86,115765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','72',428,'2','1',82779.24,82779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','72',429,'3','1',133643.44,137192.99,3549.55,912234.35,0.00,0.00,0.00,0.00,0.00),('8','284','2','72',430,'4','1',203073.06,207625.87,4552.81,1170072.17,0.00,0.00,0.00,0.00,0.00),('8','284','3','72',431,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','72',432,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','73',433,'1','1',115765.86,115765.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','73',434,'2','1',82779.24,82779.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','73',435,'3','1',137192.99,141185.43,3992.44,1026057.08,0.00,0.00,0.00,0.00,0.00),('8','284','2','73',436,'4','1',207625.87,212512.18,4886.31,1255781.67,0.00,0.00,0.00,0.00,0.00),('8','284','3','73',437,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','73',438,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','74',439,'1','1',115765.86,117054.43,1288.57,331162.49,0.00,0.00,0.00,0.00,0.00),('8','284','1','74',440,'2','1',82779.24,84871.45,2092.21,537697.97,0.00,0.00,0.00,0.00,0.00),('8','284','2','74',441,'3','1',141185.43,143197.19,2011.76,517022.32,0.00,0.00,0.00,0.00,0.00),('8','284','2','74',442,'4','1',212512.18,215832.04,3319.86,853204.02,0.00,0.00,0.00,0.00,0.00),('8','284','3','74',443,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','74',444,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','75',445,'1','1',117054.43,117054.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','75',446,'2','1',84871.45,87573.53,2702.08,702540.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','75',447,'3','1',143197.19,145349.80,2152.61,559678.60,0.00,0.00,0.00,0.00,0.00),('8','284','2','75',448,'4','1',215832.04,218799.52,2967.48,771544.80,0.00,0.00,0.00,0.00,0.00),('8','284','3','75',449,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','75',450,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','76',451,'1','1',117054.43,117796.70,742.27,192990.20,0.00,0.00,0.00,0.00,0.00),('8','284','1','76',452,'2','1',87573.53,91508.60,3935.07,1023118.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','76',453,'3','1',145349.80,147728.12,2378.32,618363.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','76',454,'4','1',218799.52,221656.87,2857.35,742911.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','76',455,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','76',456,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','77',457,'1','1',117796.70,118294.46,497.76,129417.60,0.00,0.00,0.00,0.00,0.00),('8','284','1','77',458,'2','1',91508.60,95414.50,3905.90,1015534.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','77',459,'3','1',147728.12,151343.92,3615.80,940108.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','77',460,'4','1',221656.87,226132.53,4475.66,1163671.60,0.00,0.00,0.00,0.00,0.00),('8','284','3','77',461,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','77',462,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','78',463,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','78',464,'2','1',95414.50,97147.22,1732.72,450507.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','78',465,'3','1',151343.92,152142.46,798.54,207620.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','78',466,'4','1',226132.53,226602.44,469.91,122176.60,0.00,0.00,0.00,0.00,0.00),('8','284','3','78',467,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','78',468,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','79',469,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','79',470,'2','1',97147.22,97147.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','79',471,'3','1',152142.46,158251.09,6108.63,1588243.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','79',472,'4','1',226602.44,234735.41,8132.97,2114572.20,0.00,0.00,0.00,0.00,0.00),('8','284','3','79',473,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','79',474,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','80',475,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','80',476,'2','1',97147.22,97147.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','80',477,'3','1',158251.09,159686.75,1435.66,373271.60,0.00,0.00,0.00,0.00,0.00),('8','284','2','80',478,'4','1',234735.41,237166.54,2431.13,632093.80,0.00,0.00,0.00,0.00,0.00),('8','284','3','80',479,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','80',480,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','81',481,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','81',482,'2','1',97147.22,97147.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','81',483,'3','1',159686.75,162248.07,2561.32,665943.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','81',484,'4','1',237166.54,239519.31,2352.77,611720.20,0.00,0.00,0.00,0.00,0.00),('8','284','3','81',485,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','81',486,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','82',487,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','82',488,'2','1',97147.22,97147.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','82',489,'3','1',162248.07,166730.65,4482.58,1210296.60,0.00,0.00,0.00,0.00,0.00),('8','284','2','82',490,'4','1',239519.31,243183.05,3663.74,989209.80,0.00,0.00,0.00,0.00,0.00),('8','284','3','82',491,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','82',492,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','83',493,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','83',494,'2','1',97147.22,97147.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','83',495,'3','1',166730.65,173855.44,7124.79,1973566.83,0.00,0.00,0.00,0.00,0.00),('8','284','2','83',496,'4','1',243183.05,252086.81,8903.76,2466341.52,0.00,0.00,0.00,0.00,0.00),('8','284','3','83',497,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','83',498,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','84',499,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','84',500,'2','1',97147.22,97147.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','84',501,'3','1',173855.44,175017.97,1162.53,322020.81,0.00,0.00,0.00,0.00,0.00),('8','284','2','84',502,'4','1',252086.81,254703.48,2616.67,724817.59,0.00,0.00,0.00,0.00,0.00),('8','284','3','84',503,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','84',504,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','85',505,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','85',506,'2','1',97147.22,100318.90,3171.68,983220.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','85',507,'3','1',175017.97,176511.05,1493.08,462854.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','85',508,'4','1',254703.48,257279.23,2575.75,798482.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','85',509,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','85',510,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','86',511,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','86',512,'2','1',100318.90,103955.70,3636.80,1127408.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','86',513,'3','1',176511.05,181021.36,4510.31,1398196.10,0.00,0.00,0.00,0.00,0.00),('8','284','2','86',514,'4','1',257279.23,262732.24,5453.01,1690433.10,0.00,0.00,0.00,0.00,0.00),('8','284','3','86',515,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','86',516,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','87',517,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','87',518,'2','1',103955.70,107828.04,3872.34,1200425.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','87',519,'3','1',181021.36,182539.57,1518.21,470645.10,0.00,0.00,0.00,0.00,0.00),('8','284','2','87',520,'4','1',262732.24,266255.94,3523.70,1092347.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','87',521,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','87',522,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','88',523,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','88',524,'2','1',107828.04,112954.05,5126.01,1589063.10,0.00,0.00,0.00,0.00,0.00),('8','284','2','88',525,'3','1',182539.57,183723.95,1184.38,367157.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','88',526,'4','1',266255.94,270669.22,4413.28,1368116.80,0.00,0.00,0.00,0.00,0.00),('8','284','3','88',527,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','88',528,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','89',529,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','89',530,'2','1',112954.05,113416.77,462.72,143443.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','89',531,'3','1',183723.95,185152.75,1428.80,442928.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','89',532,'4','1',270669.22,272833.15,2163.93,670818.30,0.00,0.00,0.00,0.00,0.00),('8','284','3','89',533,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','89',534,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','90',535,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','90',536,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','90',537,'3','1',185152.75,188967.87,3815.12,1182687.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','90',538,'4','1',272833.15,276923.09,4089.94,1267881.40,0.00,0.00,0.00,0.00,0.00),('8','284','3','90',539,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','90',540,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','91',541,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','91',542,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','91',543,'3','1',188967.87,192993.47,4025.60,1247936.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','91',544,'4','1',276923.09,281807.81,4884.72,1514263.20,0.00,0.00,0.00,0.00,0.00),('8','284','3','91',545,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','91',546,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','92',547,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','92',548,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','92',549,'3','1',192993.47,197352.33,4358.86,1351246.60,0.00,0.00,0.00,0.00,0.00),('8','284','2','92',550,'4','1',281807.81,286806.44,4998.63,1549575.30,0.00,0.00,0.00,0.00,0.00),('8','284','3','92',551,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','92',552,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','93',553,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','93',554,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','93',555,'3','1',197352.33,199227.12,1874.79,581184.90,0.00,0.00,0.00,0.00,0.00),('8','284','2','93',556,'4','1',286806.44,290647.18,3840.74,1190629.40,0.00,0.00,0.00,0.00,0.00),('8','284','3','93',557,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','93',558,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','94',559,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','94',560,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','94',561,'3','1',199227.12,201752.07,2524.95,782734.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','94',562,'4','1',290647.18,295460.73,4813.55,1492200.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','94',563,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','94',564,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','95',565,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','95',566,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','95',567,'3','1',201752.07,205104.29,3352.22,1039188.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','95',568,'4','1',295460.73,300688.03,5227.30,1620463.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','95',569,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','95',570,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','96',571,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','96',572,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','96',573,'3','1',205104.29,208804.49,3700.20,1147062.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','96',574,'4','1',300688.03,304489.69,3801.66,1178514.60,0.00,0.00,0.00,0.00,0.00),('8','284','3','96',575,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','96',576,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','97',577,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','97',578,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','97',579,'3','1',208804.49,210742.11,1937.62,600662.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','97',580,'4','1',304489.69,307839.34,3349.65,1038391.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','97',581,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','97',582,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','98',583,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','98',584,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','98',585,'3','1',210742.11,212081.23,1339.12,415127.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','98',586,'4','1',307839.34,309743.84,1904.50,590395.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','98',587,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','98',588,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','99',589,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','99',590,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','99',591,'3','1',212081.23,214080.53,1999.30,619783.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','99',592,'4','1',309743.84,310743.15,999.31,309786.10,0.00,0.00,0.00,0.00,0.00),('8','284','3','99',593,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','99',594,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','100',595,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','100',596,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','100',597,'3','1',214080.53,216654.78,2574.25,798017.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','100',598,'4','1',310743.15,312793.49,2050.34,635605.40,0.00,0.00,0.00,0.00,0.00),('8','284','3','100',599,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','100',600,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','101',601,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','101',602,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','101',603,'3','1',216654.78,217855.90,1201.12,372347.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','101',604,'4','1',312793.49,314195.99,1402.50,434775.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','101',605,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','101',606,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','102',607,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','102',608,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','102',609,'3','1',217855.90,218909.40,1053.50,326585.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','102',610,'4','1',314195.99,316543.59,2347.60,727756.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','102',611,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','102',612,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','103',613,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','103',614,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','103',615,'3','1',218909.40,218955.58,46.18,14315.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','103',616,'4','1',316543.59,319691.43,3147.84,975830.40,0.00,0.00,0.00,0.00,0.00),('8','284','3','103',617,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','103',618,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','104',619,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','104',620,'2','1',113416.77,113416.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','104',621,'3','1',218955.58,220426.81,1471.23,438426.54,0.00,0.00,0.00,0.00,0.00),('8','284','2','104',622,'4','1',319691.43,321785.52,2094.09,624038.82,0.00,0.00,0.00,0.00,0.00),('8','284','3','104',623,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','104',624,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','105',625,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','105',626,'2','1',113416.77,113758.17,341.40,101737.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','105',627,'3','1',220426.81,222401.60,1974.79,588487.42,0.00,0.00,0.00,0.00,0.00),('8','284','2','105',628,'4','1',321785.52,324297.02,2511.50,748427.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','105',629,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','105',630,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','106',631,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','106',632,'2','1',113758.17,113758.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','106',633,'3','1',222401.60,222401.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','106',634,'4','1',324297.02,324297.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','106',635,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','106',636,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','107',637,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','107',638,'2','1',113758.17,115189.18,1431.01,426440.98,0.00,0.00,0.00,0.00,0.00),('8','284','2','107',639,'3','1',222401.60,224011.87,1610.27,479860.46,0.00,0.00,0.00,0.00,0.00),('8','284','2','107',640,'4','1',324297.02,325884.64,1587.62,473110.76,0.00,0.00,0.00,0.00,0.00),('8','284','3','107',641,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','107',642,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','108',643,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','108',644,'2','1',115189.18,115189.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','108',645,'3','1',224011.87,226262.27,2250.40,670619.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','108',646,'4','1',325884.64,328719.89,2835.25,844904.50,0.00,0.00,0.00,0.00,0.00),('8','284','3','108',647,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','108',648,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','109',649,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','109',650,'2','1',115189.18,115189.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','109',651,'3','1',226262.27,228240.38,1978.11,589476.78,0.00,0.00,0.00,0.00,0.00),('8','284','2','109',652,'4','1',328719.89,331048.85,2328.96,694030.08,0.00,0.00,0.00,0.00,0.00),('8','284','3','109',653,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','109',654,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','110',655,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','110',656,'2','1',115189.18,115189.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','110',657,'3','1',228240.38,228240.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','110',658,'4','1',331048.85,331048.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','110',659,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','110',660,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','111',661,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','111',662,'2','1',115189.18,118949.42,3760.24,1120551.52,0.00,0.00,0.00,0.00,0.00),('8','284','2','111',663,'3','1',228240.38,230934.46,2694.08,802835.84,0.00,0.00,0.00,0.00,0.00),('8','284','2','111',664,'4','1',331048.85,334680.44,3631.59,1082213.82,0.00,0.00,0.00,0.00,0.00),('8','284','3','111',665,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','111',666,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','112',667,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','112',668,'2','1',118949.42,120776.13,1826.71,544359.58,0.00,0.00,0.00,0.00,0.00),('8','284','2','112',669,'3','1',230934.46,232329.07,1394.61,415593.78,0.00,0.00,0.00,0.00,0.00),('8','284','2','112',670,'4','1',334680.44,335766.41,1085.97,323619.06,0.00,0.00,0.00,0.00,0.00),('8','284','3','112',671,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','112',672,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','113',673,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','113',674,'2','1',120776.13,123428.56,2652.43,790424.14,0.00,0.00,0.00,0.00,0.00),('8','284','2','113',675,'3','1',232329.07,233577.23,1248.16,371951.68,0.00,0.00,0.00,0.00,0.00),('8','284','2','113',676,'4','1',335766.41,337128.52,1362.11,405908.78,0.00,0.00,0.00,0.00,0.00),('8','284','3','113',677,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','113',678,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','114',679,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','114',680,'2','1',123428.56,125637.16,2208.60,658162.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','114',681,'3','1',233577.23,234745.17,1167.94,348046.12,0.00,0.00,0.00,0.00,0.00),('8','284','2','114',682,'4','1',337128.52,338650.66,1522.14,453597.72,0.00,0.00,0.00,0.00,0.00),('8','284','3','114',683,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','114',684,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','115',685,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','115',686,'2','1',125637.16,126847.29,1210.13,360618.74,0.00,0.00,0.00,0.00,0.00),('8','284','2','115',687,'3','1',234745.17,235245.17,500.00,149000.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','115',688,'4','1',338650.66,338650.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','115',689,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','115',690,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','116',691,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','116',692,'2','1',126847.29,130524.61,3677.32,1095841.36,0.00,0.00,0.00,0.00,0.00),('8','284','2','116',693,'3','1',235245.17,237378.18,2133.01,635636.98,0.00,0.00,0.00,0.00,0.00),('8','284','2','116',694,'4','1',338650.66,340757.35,2106.69,627793.62,0.00,0.00,0.00,0.00,0.00),('8','284','3','116',695,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','116',696,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','117',697,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','117',698,'2','1',130524.61,132939.36,2414.75,719595.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','117',699,'3','1',237378.18,240413.05,3034.87,904391.26,0.00,0.00,0.00,0.00,0.00),('8','284','2','117',700,'4','1',340757.35,343555.59,2798.24,833875.52,0.00,0.00,0.00,0.00,0.00),('8','284','3','117',701,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','117',702,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','118',703,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','118',704,'2','1',132939.36,134496.66,1557.30,467190.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','118',705,'3','1',240413.05,242158.41,1745.36,523608.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','118',706,'4','1',343555.59,345020.99,1465.40,439620.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','118',707,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','118',708,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','119',709,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','119',710,'2','1',134496.66,135999.16,1502.50,450750.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','119',711,'3','1',242158.41,244109.61,1951.20,585360.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','119',712,'4','1',345020.99,346811.54,1790.55,537165.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','119',713,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','119',714,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','120',715,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','120',716,'2','1',135999.16,137449.78,1450.62,435186.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','120',717,'3','1',244109.61,246522.52,2412.91,723873.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','120',718,'4','1',346811.54,349397.00,2585.46,775638.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','120',719,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','120',720,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','121',721,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','121',722,'2','1',137449.78,139490.48,2040.70,612210.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','121',723,'3','1',246522.52,248432.02,1909.50,572850.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','121',724,'4','1',349397.00,351285.96,1888.96,566688.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','121',725,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','121',726,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','122',727,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','122',728,'2','1',139490.48,141980.82,2490.34,747102.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','122',729,'3','1',248432.02,250637.41,2205.39,661617.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','122',730,'4','1',351285.96,352728.70,1442.74,432822.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','122',731,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','122',732,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','123',733,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','123',734,'2','1',141980.82,142593.57,612.75,183825.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','123',735,'3','1',250637.41,251533.13,895.72,268716.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','123',736,'4','1',352728.70,353739.23,1010.53,303159.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','123',737,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','123',738,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','124',739,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','124',740,'2','1',142593.57,143468.34,874.77,262431.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','124',741,'3','1',251533.13,252198.07,664.94,199482.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','124',742,'4','1',353739.23,353739.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','124',743,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','124',744,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','125',745,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','125',746,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','125',747,'3','1',252198.07,252198.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','125',748,'4','1',353739.23,353739.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','125',749,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','125',750,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','126',751,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','126',752,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','126',753,'3','1',252198.07,252198.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','126',754,'4','1',353739.23,353739.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','126',755,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','126',756,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','127',757,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','127',758,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','127',759,'3','1',252198.07,253722.70,1524.63,515324.94,0.00,0.00,0.00,0.00,0.00),('8','284','2','127',760,'4','1',353739.23,354953.17,1213.94,410311.72,0.00,0.00,0.00,0.00,0.00),('8','284','3','127',761,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','127',762,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','129',763,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','129',764,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','129',765,'3','1',253722.70,255116.00,1393.30,480688.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','129',766,'4','1',354953.17,356454.28,1501.11,517882.95,0.00,0.00,0.00,0.00,0.00),('8','284','3','129',767,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','129',768,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','130',769,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','130',770,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','130',771,'3','1',255116.00,257117.67,2001.67,690576.15,0.00,0.00,0.00,0.00,0.00),('8','284','2','130',772,'4','1',356454.28,358243.54,1789.26,617294.70,0.00,0.00,0.00,0.00,0.00),('8','284','3','130',773,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','130',774,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','131',775,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','131',776,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','131',777,'3','1',257117.67,258811.48,1693.81,584364.45,0.00,0.00,0.00,0.00,0.00),('8','284','2','131',778,'4','1',358243.54,359867.59,1624.05,560297.25,0.00,0.00,0.00,0.00,0.00),('8','284','3','131',779,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','131',780,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','132',781,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','132',782,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','132',783,'3','1',258811.48,261007.06,2195.58,757475.10,0.00,0.00,0.00,0.00,0.00),('8','284','2','132',784,'4','1',359867.59,361621.20,1753.61,604995.45,0.00,0.00,0.00,0.00,0.00),('8','284','3','132',785,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','132',786,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','133',787,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','133',788,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','133',789,'3','1',261007.06,262849.85,1842.79,635762.55,0.00,0.00,0.00,0.00,0.00),('8','284','2','133',790,'4','1',361621.20,363249.76,1628.56,561853.20,0.00,0.00,0.00,0.00,0.00),('8','284','3','133',791,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','133',792,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','134',793,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','134',794,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','134',795,'3','1',262849.85,266483.05,3633.20,1253454.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','134',796,'4','1',363249.76,367252.58,4002.82,1380972.90,0.00,0.00,0.00,0.00,0.00),('8','284','3','134',797,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','134',798,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','135',799,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','135',800,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','135',801,'3','1',266483.05,268961.13,2478.08,854937.60,0.00,0.00,0.00,0.00,0.00),('8','284','2','135',802,'4','1',367252.58,369821.65,2569.07,886329.15,0.00,0.00,0.00,0.00,0.00),('8','284','3','135',803,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','135',804,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','136',805,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','136',806,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','136',807,'3','1',268961.13,269187.35,226.22,78045.90,0.00,0.00,0.00,0.00,0.00),('8','284','2','136',808,'4','1',369821.65,369821.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','136',809,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','136',810,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','137',811,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','137',812,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','137',813,'3','1',269187.35,272255.57,3068.22,1058535.90,0.00,0.00,0.00,0.00,0.00),('8','284','2','137',814,'4','1',369821.65,372236.28,2414.63,833047.35,0.00,0.00,0.00,0.00,0.00),('8','284','3','137',815,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','137',816,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','138',817,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','138',818,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','138',819,'3','1',272255.57,277662.09,5406.52,1865249.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','138',820,'4','1',372236.28,378294.24,6057.96,2089996.20,0.00,0.00,0.00,0.00,0.00),('8','284','3','138',821,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','138',822,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','139',823,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','139',824,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','139',825,'3','1',277662.09,280530.98,2868.89,989767.05,0.00,0.00,0.00,0.00,0.00),('8','284','2','139',826,'4','1',378294.24,380492.96,2198.72,758558.40,0.00,0.00,0.00,0.00,0.00),('8','284','3','139',827,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','139',828,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','140',829,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','140',830,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','140',831,'3','1',280530.98,283361.57,2830.59,976553.55,0.00,0.00,0.00,0.00,0.00),('8','284','2','140',832,'4','1',380492.96,382751.94,2258.98,779348.10,0.00,0.00,0.00,0.00,0.00),('8','284','3','140',833,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','140',834,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','141',835,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','141',836,'2','1',143468.34,143468.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','141',837,'3','1',283361.57,285899.59,2538.02,875616.90,0.00,0.00,0.00,0.00,0.00),('8','284','2','141',838,'4','1',382751.94,385047.67,2295.73,792026.85,0.00,0.00,0.00,0.00,0.00),('8','284','3','141',839,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','141',840,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','142',841,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','142',842,'2','1',143468.34,145134.22,1665.88,566399.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','142',843,'3','1',285899.59,288057.10,2157.51,733553.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','142',844,'4','1',385047.67,385047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','142',845,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','142',846,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','143',847,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','143',848,'2','1',145134.22,146479.00,1344.78,457225.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','143',849,'3','1',288057.10,289732.26,1675.16,569554.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','143',850,'4','1',385047.67,385047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','143',851,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','143',852,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','144',853,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','144',854,'2','1',146479.00,150420.85,3941.85,1340229.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','144',855,'3','1',289732.26,292160.16,2427.90,825486.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','144',856,'4','1',385047.67,385047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','144',857,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','144',858,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','145',859,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','145',860,'2','1',150420.85,151786.58,1365.73,464348.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','145',861,'3','1',292160.16,293681.36,1521.20,517208.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','145',862,'4','1',385047.67,385047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','145',863,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','145',864,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','146',865,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','146',866,'2','1',151786.58,153942.13,2155.55,689776.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','146',867,'3','1',293681.36,295149.47,1468.11,469795.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','146',868,'4','1',385047.67,385047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','146',869,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','146',870,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','147',871,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','147',872,'2','1',153942.13,155631.05,1688.92,540454.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','147',873,'3','1',295149.47,297259.38,2109.91,675171.20,0.00,0.00,0.00,0.00,0.00),('8','284','2','147',874,'4','1',385047.67,385047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','147',875,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','147',876,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','148',877,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','148',878,'2','1',155631.05,157485.34,1854.29,584101.35,0.00,0.00,0.00,0.00,0.00),('8','284','2','148',879,'3','1',297259.38,298840.08,1580.70,497920.50,0.00,0.00,0.00,0.00,0.00),('8','284','2','148',880,'4','1',385047.67,385047.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','148',881,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','148',882,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','149',883,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','149',884,'2','1',157485.34,159232.28,1746.94,550286.10,0.00,0.00,0.00,0.00,0.00),('8','284','2','149',885,'3','1',298840.08,298840.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','149',886,'4','1',385047.67,386084.42,1036.75,326576.25,0.00,0.00,0.00,0.00,0.00),('8','284','3','149',887,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','149',888,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','150',889,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','150',890,'2','1',159232.28,162418.83,3186.55,1003763.25,0.00,0.00,0.00,0.00,0.00),('8','284','2','150',891,'3','1',298840.08,300066.41,1226.33,386293.95,0.00,0.00,0.00,0.00,0.00),('8','284','2','150',892,'4','1',386084.42,389738.46,3654.04,1151022.60,0.00,0.00,0.00,0.00,0.00),('8','284','3','150',893,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','150',894,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','151',895,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','151',896,'2','1',162418.83,165715.19,3296.36,1038353.40,0.00,0.00,0.00,0.00,0.00),('8','284','2','151',897,'3','1',300066.41,301411.02,1344.61,423552.15,0.00,0.00,0.00,0.00,0.00),('8','284','2','151',898,'4','1',389738.46,390757.65,1019.19,321044.85,0.00,0.00,0.00,0.00,0.00),('8','284','3','151',899,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','151',900,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','152',901,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','152',902,'2','1',165715.19,168408.71,2693.52,848458.80,0.00,0.00,0.00,0.00,0.00),('8','284','2','152',903,'3','1',301411.02,302303.02,892.00,280980.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','152',904,'4','1',390757.65,391413.57,655.92,206614.80,0.00,0.00,0.00,0.00,0.00),('8','284','3','152',905,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','152',906,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','153',907,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','153',908,'2','1',168408.71,169815.97,1407.26,443286.90,0.00,0.00,0.00,0.00,0.00),('8','284','2','153',909,'3','1',302303.02,303986.46,1683.44,530283.60,0.00,0.00,0.00,0.00,0.00),('8','284','2','153',910,'4','1',391413.57,391839.40,425.83,134136.45,0.00,0.00,0.00,0.00,0.00),('8','284','3','153',911,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','153',912,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','154',913,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','154',914,'2','1',169815.97,169815.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','154',915,'3','1',303986.46,305556.45,1569.99,470997.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','154',916,'4','1',391839.40,393375.77,1536.37,460911.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','154',917,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','154',918,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','155',919,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','155',920,'2','1',169815.97,169815.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','155',921,'3','1',305556.45,307060.73,1504.28,451284.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','155',922,'4','1',393375.77,395873.31,2497.54,749262.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','155',923,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','155',924,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','156',925,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','156',926,'2','1',169815.97,169815.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','156',927,'3','1',307060.73,308703.12,1642.39,492717.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','156',928,'4','1',395873.31,398428.57,2555.26,766578.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','156',929,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','156',930,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','157',931,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','157',932,'2','1',169815.97,173447.52,3631.55,1089465.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','157',933,'3','1',308703.12,311188.11,2484.99,745497.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','157',934,'4','1',398428.57,402257.05,3828.48,1148544.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','157',935,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','157',936,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','158',937,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','158',938,'2','1',173447.52,174088.24,640.72,192216.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','158',939,'3','1',311188.11,313507.49,2319.38,695814.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','158',940,'4','1',402257.05,403879.29,1622.24,486672.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','158',941,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','158',942,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','159',943,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','159',944,'2','1',174088.24,174088.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','159',945,'3','1',313507.49,315289.06,1781.57,534471.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','159',946,'4','1',403879.29,407249.97,3370.68,1011204.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','159',947,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','159',948,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','160',949,'1','1',118294.46,118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','160',950,'2','1',174088.24,174088.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','160',951,'3','1',315289.06,317751.89,2462.83,738849.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','160',952,'4','1',407249.97,411405.85,4155.88,1246764.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','160',953,'5','1',28194.66,28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','160',954,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','161',955,'1','1',118294.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','1','161',956,'2','1',174088.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','161',957,'3','1',317751.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','2','161',958,'4','1',411405.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','3','161',959,'5','1',28194.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','284','4','161',960,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=322 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('8','284','1','1',187.00,187.00,0.00,0.00,0.00,0.00,0.00,1),('8','284','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,2),('8','284','2','1',187.00,187.00,5193.58,0.00,0.00,0.00,0.00,3),('8','284','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,4),('8','284','3','2',0.00,187.00,0.00,0.00,0.00,0.00,0.00,5),('8','284','3','1',187.00,0.00,5219.07,0.00,0.00,0.00,0.00,6),('8','284','4','1',187.00,187.00,4620.08,0.00,0.00,0.00,0.00,7),('8','284','4','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,8),('8','284','5','1',187.00,187.00,8023.36,0.00,0.00,0.00,0.00,9),('8','284','5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,10),('8','284','6','1',187.00,187.00,6193.85,0.00,0.00,0.00,0.00,11),('8','284','6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,12),('8','284','7','1',187.00,187.00,6689.11,0.00,0.00,0.00,0.00,13),('8','284','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,14),('8','284','8','1',187.00,187.00,4958.74,0.00,0.00,0.00,0.00,15),('8','284','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,16),('8','284','9','1',187.00,187.00,9576.23,0.00,0.00,0.00,0.00,17),('8','284','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,18),('8','284','10','1',187.00,187.00,4612.09,0.00,0.00,0.00,0.00,19),('8','284','10','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,20),('8','284','11','1',187.00,187.00,8769.68,0.00,0.00,0.00,0.00,21),('8','284','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,22),('8','284','12','1',187.00,187.00,7028.19,0.00,0.00,0.00,0.00,23),('8','284','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,24),('8','284','13','1',187.00,187.00,6136.06,0.00,0.00,0.00,0.00,25),('8','284','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,26),('8','284','14','1',187.00,187.00,0.00,0.00,0.00,0.00,0.00,27),('8','284','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,28),('8','284','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('8','284','15','1',187.00,0.00,0.00,0.00,0.00,0.00,0.00,30),('8','284','16','2',0.00,187.00,0.00,0.00,0.00,0.00,0.00,31),('8','284','16','1',187.00,187.00,9287.89,0.00,0.00,0.00,0.00,32),('8','284','17','1',187.00,187.00,7575.20,0.00,0.00,0.00,0.00,33),('8','284','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,34),('8','284','18','1',187.00,187.00,11558.98,0.00,0.00,0.00,0.00,35),('8','284','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,36),('8','284','19','2',0.00,187.00,0.00,0.00,0.00,0.00,0.00,37),('8','284','19','1',187.00,187.00,10591.04,0.00,0.00,0.00,0.00,38),('8','284','20','2',0.00,187.00,0.00,0.00,0.00,0.00,0.00,39),('8','284','20','1',187.00,187.00,5617.26,0.00,0.00,0.00,0.00,40),('8','284','21','2',0.00,187.00,0.00,0.00,0.00,0.00,0.00,41),('8','284','21','1',187.00,187.00,0.00,0.00,0.00,0.00,0.00,42),('8','284','22','1',187.00,187.00,8933.36,0.00,0.00,0.00,0.00,43),('8','284','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,44),('8','284','23','1',187.00,187.00,6450.67,0.00,0.00,0.00,0.00,45),('8','284','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,46),('8','284','24','1',187.00,187.00,6520.81,0.00,0.00,0.00,0.00,47),('8','284','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,48),('8','284','25','1',187.00,187.00,3613.88,0.00,0.00,0.00,0.00,49),('8','284','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,50),('8','284','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('8','284','26','1',187.00,187.00,12587.09,0.00,0.00,0.00,0.00,52),('8','284','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('8','284','27','1',187.00,187.00,7588.19,0.00,0.00,0.00,0.00,54),('8','284','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,55),('8','284','28','1',187.00,187.00,8182.61,0.00,0.00,0.00,0.00,56),('8','284','29','1',187.00,187.00,8890.35,0.00,0.00,0.00,0.00,57),('8','284','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,58),('8','284','30','1',187.00,187.00,6621.44,0.00,0.00,0.00,0.00,59),('8','284','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,60),('8','284','31','1',187.00,187.00,5745.92,0.00,0.00,0.00,0.00,61),('8','284','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,62),('8','284','32','1',187.00,187.00,14686.16,0.00,0.00,0.00,0.00,63),('8','284','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,64),('8','284','33','1',187.00,187.00,8967.96,0.00,0.00,0.00,0.00,65),('8','284','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,66),('8','284','34','1',187.00,187.00,9868.31,0.00,0.00,0.00,0.00,67),('8','284','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,68),('8','284','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,69),('8','284','35','1',195.00,195.00,10191.85,0.00,0.00,0.00,0.00,70),('8','284','36','1',195.00,195.00,14230.09,0.00,0.00,0.00,0.00,71),('8','284','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,72),('8','284','37','1',195.00,195.00,21437.54,0.00,0.00,0.00,0.00,73),('8','284','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,74),('8','284','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('8','284','38','1',195.00,206.00,12821.89,0.00,0.00,0.00,0.00,76),('8','284','39','1',195.00,220.00,4192.00,0.00,0.00,0.00,0.00,77),('8','284','39','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,78),('8','284','40','1',225.00,225.00,12031.72,0.00,0.00,0.00,0.00,79),('8','284','40','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,80),('8','284','41','1',225.00,225.00,10072.75,0.00,0.00,0.00,0.00,81),('8','284','41','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,82),('8','284','42','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,83),('8','284','42','1',225.00,225.00,14945.39,0.00,0.00,0.00,0.00,84),('8','284','43','1',225.00,225.00,12307.09,0.00,0.00,0.00,0.00,85),('8','284','43','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,86),('8','284','44','1',230.00,225.00,2000.00,0.00,0.00,0.00,0.00,87),('8','284','44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,88),('8','284','45','1',230.00,230.00,13952.03,0.00,0.00,0.00,0.00,89),('8','284','45','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,90),('8','284','46','1',230.00,230.00,0.00,0.00,0.00,0.00,0.00,91),('8','284','46','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,92),('8','284','47','1',230.00,235.00,3787.17,0.00,0.00,0.00,0.00,93),('8','284','47','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,94),('8','284','48','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,95),('8','284','48','1',235.00,235.00,15909.59,0.00,0.00,0.00,0.00,96),('8','284','49','1',235.00,235.00,798.01,0.00,0.00,0.00,0.00,97),('8','284','49','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,98),('8','284','50','1',250.00,250.00,6306.12,0.00,0.00,0.00,0.00,99),('8','284','50','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,100),('8','284','51','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,101),('8','284','51','1',250.00,255.00,8323.79,0.00,0.00,0.00,0.00,102),('8','284','52','1',250.00,255.00,7163.49,0.00,0.00,0.00,0.00,103),('8','284','52','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,104),('8','284','53','1',250.00,255.00,4913.99,0.00,0.00,0.00,0.00,105),('8','284','53','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,106),('8','284','54','1',250.00,255.00,1832.99,0.00,0.00,0.00,0.00,107),('8','284','54','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,108),('8','284','55','1',250.00,250.00,4480.80,0.00,0.00,0.00,0.00,109),('8','284','55','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,110),('8','284','56','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,111),('8','284','56','1',250.00,250.00,13139.53,0.00,0.00,0.00,0.00,112),('8','284','57','1',250.00,250.00,9826.84,0.00,0.00,0.00,0.00,113),('8','284','57','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,114),('8','284','58','1',250.00,250.00,10044.80,0.00,0.00,0.00,0.00,115),('8','284','58','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,116),('8','284','59','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,117),('8','284','59','1',250.00,250.00,12340.52,0.00,0.00,0.00,0.00,118),('8','284','60','1',250.00,250.00,12304.45,0.00,0.00,0.00,0.00,119),('8','284','60','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,120),('8','284','61','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,121),('8','284','61','1',250.00,250.00,5719.64,0.00,0.00,0.00,0.00,122),('8','284','62','1',250.00,255.00,10517.17,0.00,0.00,0.00,0.00,123),('8','284','62','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,124),('8','284','63','1',250.00,255.00,17468.18,0.00,0.00,0.00,0.00,125),('8','284','63','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,126),('8','284','64','1',255.00,255.00,4883.15,0.00,0.00,0.00,0.00,127),('8','284','64','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,128),('8','284','65','1',255.00,255.00,12448.94,0.00,0.00,0.00,0.00,129),('8','284','65','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,130),('8','284','66','1',255.00,255.00,8904.08,0.00,0.00,0.00,0.00,131),('8','284','66','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,132),('8','284','67','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,133),('8','284','67','1',255.00,255.00,7026.49,0.00,0.00,0.00,0.00,134),('8','284','68','1',255.00,255.00,7106.98,0.00,0.00,0.00,0.00,135),('8','284','68','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,136),('8','284','69','1',255.00,255.00,9009.67,0.00,0.00,0.00,0.00,137),('8','284','69','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,138),('8','284','70','1',255.00,255.00,2000.00,0.00,0.00,0.00,0.00,139),('8','284','70','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,140),('8','284','71','1',257.00,257.00,7059.75,0.00,0.00,0.00,0.00,141),('8','284','71','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,142),('8','284','72','1',257.00,257.00,8102.36,0.00,0.00,0.00,0.00,143),('8','284','72','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,144),('8','284','73','1',257.00,257.00,8878.75,0.00,0.00,0.00,0.00,145),('8','284','73','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,146),('8','284','74','1',257.00,257.00,8712.40,0.00,0.00,0.00,0.00,147),('8','284','74','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,148),('8','284','75','1',257.00,260.00,7822.17,0.00,0.00,0.00,0.00,149),('8','284','75','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,150),('8','284','76','1',257.00,260.00,9913.01,0.00,0.00,0.00,0.00,151),('8','284','76','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,152),('8','284','77','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,153),('8','284','77','1',257.00,260.00,12495.12,0.00,0.00,0.00,0.00,154),('8','284','78','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,155),('8','284','78','1',257.00,260.00,3001.17,0.00,0.00,0.00,0.00,156),('8','284','79','1',260.00,260.00,14241.60,0.00,0.00,0.00,0.00,157),('8','284','79','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,158),('8','284','80','1',270.00,260.00,3866.79,0.00,0.00,0.00,0.00,159),('8','284','80','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,160),('8','284','81','2',0.00,2.00,0.00,0.00,0.00,0.00,0.00,161),('8','284','81','1',270.00,260.00,4914.09,0.00,0.00,0.00,0.00,162),('8','284','82','1',270.00,270.00,8146.32,0.00,0.00,0.00,0.00,163),('8','284','82','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,164),('8','284','83','1',270.00,277.00,16028.55,0.00,0.00,0.00,0.00,165),('8','284','83','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,166),('8','284','84','1',270.00,277.00,3779.20,0.00,0.00,0.00,0.00,167),('8','284','84','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,168),('8','284','85','1',270.00,310.00,7240.51,0.00,0.00,0.00,0.00,169),('8','284','85','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,170),('8','284','86','1',310.00,310.00,13600.12,0.00,0.00,0.00,0.00,171),('8','284','86','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,172),('8','284','87','1',310.00,310.00,8914.25,0.00,0.00,0.00,0.00,173),('8','284','87','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,174),('8','284','88','1',310.00,310.00,10723.67,0.00,0.00,0.00,0.00,175),('8','284','88','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,176),('8','284','89','1',310.00,310.00,4055.45,0.00,0.00,0.00,0.00,177),('8','284','89','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,178),('8','284','90','1',310.00,310.00,7905.06,0.00,0.00,0.00,0.00,179),('8','284','90','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,180),('8','284','91','1',310.00,310.00,8910.32,0.00,0.00,0.00,0.00,181),('8','284','91','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,182),('8','284','92','1',310.00,310.00,9357.49,0.00,0.00,0.00,0.00,183),('8','284','92','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,184),('8','284','93','1',310.00,310.00,5715.53,0.00,0.00,0.00,0.00,185),('8','284','93','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,186),('8','284','94','1',310.00,310.00,7338.50,0.00,0.00,0.00,0.00,187),('8','284','94','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,188),('8','284','95','1',310.00,310.00,8579.52,0.00,0.00,0.00,0.00,189),('8','284','95','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,190),('8','284','96','1',310.00,310.00,7501.86,0.00,0.00,0.00,0.00,191),('8','284','96','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,192),('8','284','97','1',310.00,310.00,5287.27,0.00,0.00,0.00,0.00,193),('8','284','97','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,194),('8','284','98','1',310.00,310.00,3243.62,0.00,0.00,0.00,0.00,195),('8','284','98','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,196),('8','284','99','1',310.00,310.00,2998.61,0.00,0.00,0.00,0.00,197),('8','284','99','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,198),('8','284','100','1',310.00,310.00,4624.59,0.00,0.00,0.00,0.00,199),('8','284','100','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,200),('8','284','101','1',310.00,310.00,2603.62,0.00,0.00,0.00,0.00,201),('8','284','101','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,202),('8','284','102','1',310.00,310.00,3401.10,0.00,0.00,0.00,0.00,203),('8','284','102','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,204),('8','284','103','1',298.00,310.00,3194.02,0.00,0.00,0.00,0.00,205),('8','284','103','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,206),('8','284','104','1',298.00,298.00,3565.32,0.00,0.00,0.00,0.00,207),('8','284','104','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,208),('8','284','105','1',298.00,298.00,4827.69,0.00,0.00,0.00,0.00,209),('8','284','105','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,210),('8','284','106','1',298.00,198.00,0.00,0.00,0.00,0.00,0.00,211),('8','284','106','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,212),('8','284','107','1',298.00,298.00,4628.90,0.00,0.00,0.00,0.00,213),('8','284','107','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,214),('8','284','108','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215),('8','284','108','1',298.00,298.00,5085.65,0.00,0.00,0.00,0.00,216),('8','284','109','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217),('8','284','109','1',298.00,298.00,4307.07,0.00,0.00,0.00,0.00,218),('8','284','110','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219),('8','284','110','1',298.00,198.00,0.00,0.00,0.00,0.00,0.00,220),('8','284','111','1',298.00,298.00,10085.91,0.00,0.00,0.00,0.00,221),('8','284','111','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,222),('8','284','112','1',298.00,298.00,4307.29,0.00,0.00,0.00,0.00,223),('8','284','112','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224),('8','284','113','1',298.00,298.00,5262.70,0.00,0.00,0.00,0.00,225),('8','284','113','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226),('8','284','114','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227),('8','284','114','1',298.00,298.00,4898.68,0.00,0.00,0.00,0.00,228),('8','284','115','1',298.00,298.00,1710.13,0.00,0.00,0.00,0.00,229),('8','284','115','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,230),('8','284','116','1',298.00,298.00,7917.02,0.00,0.00,0.00,0.00,231),('8','284','116','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232),('8','284','117','1',298.00,298.00,8247.86,0.00,0.00,0.00,0.00,233),('8','284','117','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,234),('8','284','118','1',298.00,300.00,4768.06,0.00,0.00,0.00,0.00,235),('8','284','118','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236),('8','284','119','1',298.00,300.00,5244.25,0.00,0.00,0.00,0.00,237),('8','284','119','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,238),('8','284','120','1',298.00,300.00,6448.99,0.00,0.00,0.00,0.00,239),('8','284','120','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240),('8','284','121','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241),('8','284','121','1',338.00,300.00,5839.16,0.00,0.00,0.00,0.00,242),('8','284','122','1',338.00,300.00,6138.47,0.00,0.00,0.00,0.00,243),('8','284','122','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244),('8','284','123','1',338.00,300.00,2519.00,0.00,0.00,0.00,0.00,245),('8','284','123','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,246),('8','284','124','1',338.00,300.00,1539.71,0.00,0.00,0.00,0.00,247),('8','284','124','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248),('8','284','125','1',338.00,338.00,0.00,0.00,0.00,0.00,0.00,249),('8','284','125','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250),('8','284','126','1',338.00,345.00,0.00,0.00,0.00,0.00,0.00,251),('8','284','126','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,252),('8','284','127','1',338.00,338.00,2738.57,0.00,0.00,0.00,0.00,253),('8','284','127','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,254),('8','284','129','1',338.00,345.00,2894.41,0.00,0.00,0.00,0.00,256),('8','284','129','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,257),('8','284','130','1',338.00,345.00,3790.93,0.00,0.00,0.00,0.00,258),('8','284','130','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,259),('8','284','131','1',338.00,345.00,3317.86,0.00,0.00,0.00,0.00,260),('8','284','131','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261),('8','284','132','1',338.00,345.00,3949.19,0.00,0.00,0.00,0.00,262),('8','284','132','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263),('8','284','133','1',338.00,345.00,3471.35,0.00,0.00,0.00,0.00,264),('8','284','133','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,265),('8','284','134','1',338.00,345.00,7636.02,0.00,0.00,0.00,0.00,266),('8','284','134','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267),('8','284','135','1',338.00,345.00,5047.15,0.00,0.00,0.00,0.00,268),('8','284','135','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269),('8','284','136','1',345.00,345.00,226.22,0.00,0.00,0.00,0.00,270),('8','284','136','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271),('8','284','137','1',345.00,345.00,5482.85,0.00,0.00,0.00,0.00,272),('8','284','137','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,273),('8','284','138','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274),('8','284','138','1',345.00,345.00,11464.48,0.00,0.00,0.00,0.00,275),('8','284','139','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,276),('8','284','139','1',345.00,345.00,5067.61,0.00,0.00,0.00,0.00,277),('8','284','140','1',345.00,345.00,5089.57,0.00,0.00,0.00,0.00,278),('8','284','140','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,279),('8','284','141','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,280),('8','284','141','1',340.00,345.00,4833.75,0.00,0.00,0.00,0.00,281),('8','284','142','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282),('8','284','142','1',340.00,340.00,3823.39,0.00,0.00,0.00,0.00,283),('8','284','143','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,284),('8','284','143','1',340.00,340.00,3019.94,0.00,0.00,0.00,0.00,285),('8','284','144','1',340.00,340.00,6369.75,0.00,0.00,0.00,0.00,286),('8','284','144','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287),('8','284','145','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288),('8','284','145','1',340.00,340.00,2886.93,0.00,0.00,0.00,0.00,289),('8','284','146','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,290),('8','284','146','1',340.00,320.00,3623.66,0.00,0.00,0.00,0.00,291),('8','284','147','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,292),('8','284','147','1',340.00,320.00,3798.83,0.00,0.00,0.00,0.00,293),('8','284','148','1',340.00,315.00,3434.99,0.00,0.00,0.00,0.00,294),('8','284','148','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,295),('8','284','149','1',340.00,315.00,2783.69,0.00,0.00,0.00,0.00,296),('8','284','149','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,297),('8','284','150','1',340.00,315.00,8066.92,0.00,0.00,0.00,0.00,298),('8','284','150','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,299),('8','284','151','1',315.00,315.00,5660.16,0.00,0.00,0.00,0.00,300),('8','284','151','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,301),('8','284','152','1',315.00,315.00,4241.44,0.00,0.00,0.00,0.00,302),('8','284','152','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,303),('8','284','153','1',315.00,315.00,3516.53,0.00,0.00,0.00,0.00,304),('8','284','153','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,305),('8','284','154','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,306),('8','284','154','1',315.00,300.00,3106.36,0.00,0.00,0.00,0.00,307),('8','284','155','1',315.00,300.00,4001.82,0.00,0.00,0.00,0.00,308),('8','284','155','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,309),('8','284','156','1',315.00,300.00,4197.65,0.00,0.00,0.00,0.00,310),('8','284','156','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311),('8','284','157','1',315.00,300.00,9945.02,0.00,0.00,0.00,0.00,312),('8','284','157','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,313),('8','284','158','1',300.00,300.00,4582.34,0.00,0.00,0.00,0.00,314),('8','284','158','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,315),('8','284','159','1',300.00,300.00,5152.25,0.00,0.00,0.00,0.00,316),('8','284','159','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317),('8','284','160','1',300.00,300.00,6618.71,0.00,0.00,0.00,0.00,318),('8','284','160','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,319),('8','284','161','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,320),('8','284','161','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,321);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('8',1,'284','PRODUCT TANK','Tank Containing Petroleum Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('8','284','1',1,0,'1','PMS TANK 1',40000.00,0.00,NULL,'TANK CONTAINING PETROL.','926','2022-09-06 13:55:16','2022-09-06 13:55:16','926',5,0),('8','284','1',2,0,'1','PMS TANK 2',45000.00,0.00,NULL,'TANK CONTAINING PETROL.','926','2022-09-06 13:56:44','2022-09-06 13:56:44','926',5,0),('8','284','1',3,0,'1','PMS TANK 3',28000.00,0.00,NULL,'TANK CONTAINING PETROL.','926','2022-09-06 13:58:22','2022-09-06 13:58:22','926',5,0),('8','284','1',4,0,'2','AGO TANK ',40000.00,0.00,NULL,'TANK CONTAINING DIESEL.','926','2022-09-06 14:06:21','2022-11-15 22:55:48','952',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'8','284',4,0.00,'2023-03-15 16:54:57'),(2,'8','284',3,3323.06,'2023-03-15 16:54:57'),(3,'8','284',2,4473.34,'2023-03-15 16:54:57'),(4,'8','284',1,1369.11,'2023-03-15 16:54:57');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=665 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,9350000.00,50000.00,0.00,0.00,'2022-09-07 14:00:42','',''),(2,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,9350000.00,50000.00,0.00,0.00,'2022-09-07 14:01:12','',''),(3,'8','284',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,38800.00,0.00,'2022-09-08 12:54:14','',''),(4,'8','284','1',1,'Received from bridging 3',0.00,0.00,38800.00,0.00,0.00,'2022-09-08 12:54:14','',''),(5,'8','284',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,11200.00,0.00,'2022-09-08 12:54:52','',''),(6,'8','284','2',1,'Received from bridging 4',0.00,0.00,11200.00,0.00,0.00,'2022-09-08 12:54:52','',''),(7,'8','284',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,26500.00,0.00,'2022-09-08 12:57:22','',''),(8,'8','284','2',1,'Received from bridging 5',0.00,0.00,26500.00,0.00,0.00,'2022-09-08 12:57:22','',''),(9,'8','284',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,23500.00,0.00,'2022-09-08 13:29:19','',''),(10,'8','284','3',1,'Received from bridging 6',0.00,0.00,23500.00,0.00,0.00,'2022-09-08 13:29:19','',''),(11,'8','284','1',1,'Sale Id shift 2',0.00,0.00,0.00,2795.60,0.00,'2022-09-08 20:02:25','',''),(12,'8','284','1',1,'Sale Id shift 2',0.00,0.00,0.00,277.18,0.00,'2022-09-08 20:02:25','',''),(13,'8','284','2',1,'Sale Id shift 2',0.00,0.00,0.00,2061.38,0.00,'2022-09-08 20:02:25','',''),(14,'8','284','2',1,'Sale Id shift 2',0.00,0.00,0.00,59.42,0.00,'2022-09-08 20:02:25','',''),(15,'8','284',NULL,1,'Sale Id shift 2',971199.46,0.00,0.00,0.00,0.00,'2022-09-08 20:02:25','',''),(16,'8','284','1',1,'Sale Id shift 3',0.00,0.00,0.00,2584.32,0.00,'2022-09-08 20:09:36','',''),(17,'8','284','2',1,'Sale Id shift 3',0.00,0.00,0.00,2634.75,0.00,'2022-09-08 20:09:36','',''),(18,'8','284',NULL,1,'Sale Id shift 3',975966.09,0.00,0.00,0.00,0.00,'2022-09-08 20:09:36','',''),(19,'8','284','1',1,'Sale Id shift 4',0.00,0.00,0.00,2056.22,0.00,'2022-09-08 20:35:40','',''),(20,'8','284','2',1,'Sale Id shift 4',0.00,0.00,0.00,2563.86,0.00,'2022-09-08 20:35:40','',''),(21,'8','284',NULL,1,'Sale Id shift 4',863954.96,0.00,0.00,0.00,0.00,'2022-09-08 20:35:40','',''),(22,'8','284','1',1,'Sale Id shift 5',0.00,0.00,0.00,2984.71,0.00,'2022-09-09 14:52:24','',''),(23,'8','284','1',1,'Sale Id shift 5',0.00,0.00,0.00,1602.46,0.00,'2022-09-09 14:52:24','',''),(24,'8','284','2',1,'Sale Id shift 5',0.00,0.00,0.00,3436.19,0.00,'2022-09-09 14:52:24','',''),(25,'8','284',NULL,1,'Sale Id shift 5',1500368.32,0.00,0.00,0.00,0.00,'2022-09-09 14:52:24','',''),(26,'8','284','1',1,'Sale Id shift 6',0.00,0.00,0.00,3249.79,0.00,'2022-09-11 12:43:46','',''),(27,'8','284','1',1,'Sale Id shift 6',0.00,0.00,0.00,232.19,0.00,'2022-09-11 12:43:46','',''),(28,'8','284','2',1,'Sale Id shift 6',0.00,0.00,0.00,2711.87,0.00,'2022-09-11 12:43:46','',''),(29,'8','284',NULL,1,'Sale Id shift 6',1158249.95,0.00,0.00,0.00,0.00,'2022-09-11 12:43:46','',''),(30,'8','284','1',1,'Sale Id shift 7',0.00,0.00,0.00,1760.99,0.00,'2022-09-11 13:44:34','',''),(31,'8','284','2',1,'Sale Id shift 7',0.00,0.00,0.00,2008.61,0.00,'2022-09-11 13:44:34','',''),(32,'8','284','2',1,'Sale Id shift 7',0.00,0.00,0.00,2919.51,0.00,'2022-09-11 13:44:34','',''),(33,'8','284',NULL,1,'Sale Id shift 7',1250863.57,0.00,0.00,0.00,0.00,'2022-09-11 13:44:34','',''),(34,'8','284','1',1,'Sale Id shift 8',0.00,0.00,0.00,2937.68,0.00,'2022-09-12 13:52:53','',''),(35,'8','284','2',1,'Sale Id shift 8',0.00,0.00,0.00,2021.06,0.00,'2022-09-12 13:52:53','',''),(36,'8','284',NULL,1,'Sale Id shift 8',927284.38,0.00,0.00,0.00,0.00,'2022-09-12 13:52:53','',''),(37,'8','284','1',1,'Sale Id shift 9',0.00,0.00,0.00,4262.68,0.00,'2022-09-14 09:48:59','',''),(38,'8','284','2',1,'Sale Id shift 9',0.00,0.00,0.00,3082.59,0.00,'2022-09-14 09:48:59','',''),(39,'8','284','2',1,'Sale Id shift 9',0.00,0.00,0.00,2230.96,0.00,'2022-09-14 09:48:59','',''),(40,'8','284',NULL,1,'Sale Id shift 9',1790755.01,0.00,0.00,0.00,0.00,'2022-09-14 09:48:59','',''),(41,'8','284','1',1,'Sale Id shift 10',0.00,0.00,0.00,1773.50,0.00,'2022-09-14 13:26:17','',''),(42,'8','284','1',1,'Sale Id shift 10',0.00,0.00,0.00,379.40,0.00,'2022-09-14 13:26:17','',''),(43,'8','284','2',1,'Sale Id shift 10',0.00,0.00,0.00,1915.59,0.00,'2022-09-14 13:26:17','',''),(44,'8','284','2',1,'Sale Id shift 10',0.00,0.00,0.00,543.60,0.00,'2022-09-14 13:26:17','',''),(45,'8','284',NULL,1,'Sale Id shift 10',862460.83,0.00,0.00,0.00,0.00,'2022-09-14 13:26:17','',''),(46,'8','284','1',1,'Sale Id shift 11',0.00,0.00,0.00,3083.38,0.00,'2022-09-16 09:04:30','',''),(47,'8','284','2',1,'Sale Id shift 11',0.00,0.00,0.00,3695.64,0.00,'2022-09-16 09:04:30','',''),(48,'8','284','2',1,'Sale Id shift 11',0.00,0.00,0.00,790.66,0.00,'2022-09-16 09:04:30','',''),(49,'8','284','3',1,'Sale Id shift 11',0.00,0.00,0.00,1200.00,0.00,'2022-09-16 09:04:30','',''),(50,'8','284',NULL,1,'Sale Id shift 11',1639930.16,0.00,0.00,0.00,0.00,'2022-09-16 09:04:30','',''),(51,'8','284','1',1,'Sale Id shift 12',0.00,0.00,0.00,3488.38,0.00,'2022-09-17 13:27:53','',''),(52,'8','284','1',1,'Sale Id shift 12',0.00,0.00,0.00,2893.04,0.00,'2022-09-17 13:27:53','',''),(53,'8','284','2',1,'Sale Id shift 12',0.00,0.00,0.00,385.46,0.00,'2022-09-17 13:27:53','',''),(54,'8','284','2',1,'Sale Id shift 12',0.00,0.00,0.00,261.31,0.00,'2022-09-17 13:27:53','',''),(55,'8','284',NULL,1,'Sale Id shift 12',1314271.53,0.00,0.00,0.00,0.00,'2022-09-17 13:27:53','',''),(56,'8','284','1',1,'Sale Id shift 13',0.00,0.00,0.00,987.23,0.00,'2022-09-17 13:41:46','',''),(57,'8','284','2',1,'Sale Id shift 13',0.00,0.00,0.00,3132.01,0.00,'2022-09-17 13:41:46','',''),(58,'8','284','3',1,'Sale Id shift 13',0.00,0.00,0.00,2016.82,0.00,'2022-09-17 13:41:46','',''),(59,'8','284',NULL,1,'Sale Id shift 13',1147443.22,0.00,0.00,0.00,0.00,'2022-09-17 13:41:46','',''),(60,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,9163000.00,49000.00,0.00,0.00,'2022-09-19 12:29:52','',''),(61,'8','284',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,19100.00,0.00,'2022-09-19 13:06:04','',''),(62,'8','284','1',1,'Received from bridging 7',0.00,0.00,19100.00,0.00,0.00,'2022-09-19 13:06:04','',''),(63,'8','284',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,29900.00,0.00,'2022-09-19 13:06:20','',''),(64,'8','284','2',1,'Received from bridging 8',0.00,0.00,29900.00,0.00,0.00,'2022-09-19 13:06:20','',''),(65,'8','284','2',1,'Sale Id shift 16',0.00,0.00,0.00,1467.87,0.00,'2022-09-20 13:01:51','',''),(66,'8','284','3',1,'Sale Id shift 16',0.00,0.00,0.00,7820.02,0.00,'2022-09-20 13:01:51','',''),(67,'8','284',NULL,1,'Sale Id shift 16',1736835.43,0.00,0.00,0.00,0.00,'2022-09-20 13:01:51','',''),(68,'8','284','3',1,'Sale Id shift 17',0.00,0.00,0.00,7575.20,0.00,'2022-09-20 13:35:29','',''),(69,'8','284',NULL,1,'Sale Id shift 17',1416562.40,0.00,0.00,0.00,0.00,'2022-09-20 13:35:29','',''),(70,'8','284','1',1,'Sale Id shift 18',0.00,0.00,0.00,3584.19,0.00,'2022-09-21 14:39:08','',''),(71,'8','284','1',1,'Sale Id shift 18',0.00,0.00,0.00,3179.89,0.00,'2022-09-21 14:39:08','',''),(72,'8','284','2',1,'Sale Id shift 18',0.00,0.00,0.00,3222.06,0.00,'2022-09-21 14:39:08','',''),(73,'8','284','2',1,'Sale Id shift 18',0.00,0.00,0.00,181.34,0.00,'2022-09-21 14:39:08','',''),(74,'8','284','3',1,'Sale Id shift 18',0.00,0.00,0.00,1391.50,0.00,'2022-09-21 14:39:08','',''),(75,'8','284',NULL,1,'Sale Id shift 18',2161529.26,0.00,0.00,0.00,0.00,'2022-09-21 14:39:08','',''),(76,'8','284','1',1,'Sale Id shift 19',0.00,0.00,0.00,4441.11,0.00,'2022-09-21 14:54:04','',''),(77,'8','284','1',1,'Sale Id shift 19',0.00,0.00,0.00,3364.52,0.00,'2022-09-21 14:54:04','',''),(78,'8','284','2',1,'Sale Id shift 19',0.00,0.00,0.00,2785.41,0.00,'2022-09-21 14:54:04','',''),(79,'8','284',NULL,1,'Sale Id shift 19',1980524.48,0.00,0.00,0.00,0.00,'2022-09-21 14:54:04','',''),(80,'8','284','1',1,'Sale Id shift 20',0.00,0.00,0.00,2096.11,0.00,'2022-09-23 20:06:53','',''),(81,'8','284','2',1,'Sale Id shift 20',0.00,0.00,0.00,3521.15,0.00,'2022-09-23 20:06:53','',''),(82,'8','284',NULL,1,'Sale Id shift 20',1050427.62,0.00,0.00,0.00,0.00,'2022-09-23 20:06:53','',''),(83,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,9200400.00,49200.00,0.00,0.00,'2022-09-28 10:08:48','',''),(84,'8','284',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,17500.00,0.00,'2022-09-28 14:15:48','',''),(85,'8','284','1',1,'Received from bridging 9',0.00,0.00,17500.00,0.00,0.00,'2022-09-28 14:15:48','',''),(86,'8','284','1',1,'Sale Id shift 22',0.00,0.00,0.00,3125.42,0.00,'2022-09-28 14:31:17','',''),(87,'8','284','1',1,'Sale Id shift 22',0.00,0.00,0.00,1768.39,0.00,'2022-09-28 14:31:17','',''),(88,'8','284','2',1,'Sale Id shift 22',0.00,0.00,0.00,4039.55,0.00,'2022-09-28 14:31:17','',''),(89,'8','284',NULL,1,'Sale Id shift 22',1670538.32,0.00,0.00,0.00,0.00,'2022-09-28 14:31:17','',''),(90,'8','284','2',1,'Sale Id shift 23',0.00,0.00,0.00,4289.81,0.00,'2022-09-28 14:37:50','',''),(91,'8','284','2',1,'Sale Id shift 23',0.00,0.00,0.00,2160.86,0.00,'2022-09-28 14:37:50','',''),(92,'8','284',NULL,1,'Sale Id shift 23',1206275.29,0.00,0.00,0.00,0.00,'2022-09-28 14:37:50','',''),(93,'8','284',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,31700.00,0.00,'2022-09-28 14:39:40','',''),(94,'8','284','2',1,'Received from bridging 10',0.00,0.00,31700.00,0.00,0.00,'2022-09-28 14:39:40','',''),(95,'8','284','2',1,'Sale Id shift 24',0.00,0.00,0.00,2690.34,0.00,'2022-09-28 15:54:05','',''),(96,'8','284','2',1,'Sale Id shift 24',0.00,0.00,0.00,3830.47,0.00,'2022-09-28 15:54:05','',''),(97,'8','284',NULL,1,'Sale Id shift 24',1219391.47,0.00,0.00,0.00,0.00,'2022-09-28 15:54:05','',''),(98,'8','284','2',1,'Sale Id shift 25',0.00,0.00,0.00,3613.88,0.00,'2022-09-28 16:00:14','',''),(99,'8','284',NULL,1,'Sale Id shift 25',675795.56,0.00,0.00,0.00,0.00,'2022-09-28 16:00:14','',''),(100,'8','284','1',1,'Sale Id shift 26',0.00,0.00,0.00,3146.77,0.00,'2022-09-28 23:03:30','',''),(101,'8','284','2',1,'Sale Id shift 26',0.00,0.00,0.00,4900.62,0.00,'2022-09-28 23:03:30','',''),(102,'8','284','2',1,'Sale Id shift 26',0.00,0.00,0.00,4539.70,0.00,'2022-09-28 23:03:30','',''),(103,'8','284',NULL,1,'Sale Id shift 26',2353785.83,0.00,0.00,0.00,0.00,'2022-09-28 23:03:30','',''),(104,'8','284','1',1,'Sale Id shift 27',0.00,0.00,0.00,2563.27,0.00,'2022-09-30 00:12:41','',''),(105,'8','284','2',1,'Sale Id shift 27',0.00,0.00,0.00,2382.99,0.00,'2022-09-30 00:12:41','',''),(106,'8','284','2',1,'Sale Id shift 27',0.00,0.00,0.00,2641.93,0.00,'2022-09-30 00:12:41','',''),(107,'8','284',NULL,1,'Sale Id shift 27',1418991.53,0.00,0.00,0.00,0.00,'2022-09-30 00:12:41','',''),(108,'8','284','1',1,'Sale Id shift 28',0.00,0.00,0.00,3052.86,0.00,'2022-09-30 11:15:37','',''),(109,'8','284','2',1,'Sale Id shift 28',0.00,0.00,0.00,2001.95,0.00,'2022-09-30 11:15:37','',''),(110,'8','284','2',1,'Sale Id shift 28',0.00,0.00,0.00,3127.80,0.00,'2022-09-30 11:15:37','',''),(111,'8','284',NULL,1,'Sale Id shift 28',1530148.07,0.00,0.00,0.00,0.00,'2022-09-30 11:15:37','',''),(112,'8','284','1',1,'Sale Id shift 29',0.00,0.00,0.00,3548.50,0.00,'2022-10-01 21:24:22','',''),(113,'8','284','1',1,'Sale Id shift 29',0.00,0.00,0.00,2435.00,0.00,'2022-10-01 21:24:22','',''),(114,'8','284','2',1,'Sale Id shift 29',0.00,0.00,0.00,703.69,0.00,'2022-10-01 21:24:22','',''),(115,'8','284','2',1,'Sale Id shift 29',0.00,0.00,0.00,2203.16,0.00,'2022-10-01 21:24:22','',''),(116,'8','284',NULL,1,'Sale Id shift 29',1662495.45,0.00,0.00,0.00,0.00,'2022-10-01 21:24:22','',''),(117,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,9350000.00,50000.00,0.00,0.00,'2022-10-07 14:38:32','',''),(118,'8','284',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,10500.00,0.00,'2022-10-07 15:02:02','',''),(119,'8','284','2',1,'Received from bridging 12',0.00,0.00,10500.00,0.00,0.00,'2022-10-07 15:02:02','',''),(120,'8','284',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,30000.00,0.00,'2022-10-07 15:15:23','',''),(121,'8','284','1',1,'Received from bridging 13',0.00,0.00,30000.00,0.00,0.00,'2022-10-07 15:15:23','',''),(122,'8','284','1',1,'Sale Id shift 30',0.00,0.00,0.00,2835.88,0.00,'2022-10-07 15:27:07','',''),(123,'8','284','1',1,'Sale Id shift 30',0.00,0.00,0.00,503.91,0.00,'2022-10-07 15:27:07','',''),(124,'8','284','2',1,'Sale Id shift 30',0.00,0.00,0.00,1485.89,0.00,'2022-10-07 15:27:07','',''),(125,'8','284','2',1,'Sale Id shift 30',0.00,0.00,0.00,1795.76,0.00,'2022-10-07 15:27:07','',''),(126,'8','284',NULL,1,'Sale Id shift 30',1238209.28,0.00,0.00,0.00,0.00,'2022-10-07 15:27:07','',''),(127,'8','284','2',1,'Sale Id shift 31',0.00,0.00,0.00,340.33,0.00,'2022-10-07 15:38:45','',''),(128,'8','284','2',1,'Sale Id shift 31',0.00,0.00,0.00,5405.59,0.00,'2022-10-07 15:38:45','',''),(129,'8','284',NULL,1,'Sale Id shift 31',1074487.04,0.00,0.00,0.00,0.00,'2022-10-07 15:38:45','',''),(130,'8','284','1',1,'Sale Id shift 32',0.00,0.00,0.00,6089.76,0.00,'2022-10-07 15:48:39','',''),(131,'8','284','1',1,'Sale Id shift 32',0.00,0.00,0.00,3929.06,0.00,'2022-10-07 15:48:39','',''),(132,'8','284','2',1,'Sale Id shift 32',0.00,0.00,0.00,4667.34,0.00,'2022-10-07 15:48:39','',''),(133,'8','284',NULL,1,'Sale Id shift 32',2746311.92,0.00,0.00,0.00,0.00,'2022-10-07 15:48:39','',''),(134,'8','284','1',1,'Sale Id shift 33',0.00,0.00,0.00,4540.99,0.00,'2022-10-07 15:53:08','',''),(135,'8','284','1',1,'Sale Id shift 33',0.00,0.00,0.00,3806.17,0.00,'2022-10-07 15:53:08','',''),(136,'8','284','2',1,'Sale Id shift 33',0.00,0.00,0.00,620.80,0.00,'2022-10-07 15:53:08','',''),(137,'8','284',NULL,1,'Sale Id shift 33',1677008.52,0.00,0.00,0.00,0.00,'2022-10-07 15:53:08','',''),(138,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,9750000.00,50000.00,0.00,0.00,'2022-10-08 22:37:25','',''),(139,'8','284',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,33000.00,0.00,'2022-10-08 22:45:19','',''),(140,'8','284','2',1,'Received from bridging 14',0.00,0.00,33000.00,0.00,0.00,'2022-10-08 22:45:19','',''),(141,'8','284','1',1,'Sale Id shift 34',0.00,0.00,0.00,3254.24,0.00,'2022-10-09 23:07:22','',''),(142,'8','284','1',1,'Sale Id shift 34',0.00,0.00,0.00,1351.78,0.00,'2022-10-09 23:07:22','',''),(143,'8','284','2',1,'Sale Id shift 34',0.00,0.00,0.00,16.84,0.00,'2022-10-09 23:07:22','',''),(144,'8','284','2',1,'Sale Id shift 34',0.00,0.00,0.00,5245.45,0.00,'2022-10-09 23:07:22','',''),(145,'8','284',NULL,1,'Sale Id shift 34',1845373.97,0.00,0.00,0.00,0.00,'2022-10-09 23:07:22','',''),(146,'8','284',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,9500.00,0.00,'2022-10-10 06:35:31','',''),(147,'8','284','1',1,'Received from bridging 15',0.00,0.00,9500.00,0.00,0.00,'2022-10-10 06:35:31','',''),(148,'8','284','1',1,'Sale Id shift 35',0.00,0.00,0.00,3567.88,0.00,'2022-10-10 06:37:39','',''),(149,'8','284','1',1,'Sale Id shift 35',0.00,0.00,0.00,6623.97,0.00,'2022-10-10 06:37:39','',''),(150,'8','284',NULL,1,'Sale Id shift 35',1987410.75,0.00,0.00,0.00,0.00,'2022-10-10 06:37:39','',''),(151,'8','284','1',1,'Sale Id shift 36',0.00,0.00,0.00,2108.29,0.00,'2022-10-10 14:58:04','',''),(152,'8','284','1',1,'Sale Id shift 36',0.00,0.00,0.00,832.30,0.00,'2022-10-10 14:58:04','',''),(153,'8','284','2',1,'Sale Id shift 36',0.00,0.00,0.00,3423.23,0.00,'2022-10-10 14:58:04','',''),(154,'8','284','2',1,'Sale Id shift 36',0.00,0.00,0.00,7866.27,0.00,'2022-10-10 14:58:04','',''),(155,'8','284',NULL,1,'Sale Id shift 36',2774867.55,0.00,0.00,0.00,0.00,'2022-10-10 14:58:04','',''),(156,'8','284',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,9560.00,0.00,'2022-10-10 15:18:29','',''),(157,'8','284','2',1,'Received from bridging 16',0.00,0.00,9560.00,0.00,0.00,'2022-10-10 15:18:29','',''),(158,'8','284',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,7440.00,0.00,'2022-10-10 15:18:53','',''),(159,'8','284','3',1,'Received from bridging 17',0.00,0.00,7440.00,0.00,0.00,'2022-10-10 15:18:53','',''),(160,'8','284','1',1,'Sale Id shift 37',0.00,0.00,0.00,160.61,0.00,'2022-10-12 00:11:09','',''),(161,'8','284','2',1,'Sale Id shift 37',0.00,0.00,0.00,7025.38,0.00,'2022-10-12 00:11:09','',''),(162,'8','284','2',1,'Sale Id shift 37',0.00,0.00,0.00,7618.41,0.00,'2022-10-12 00:11:09','',''),(163,'8','284','3',1,'Sale Id shift 37',0.00,0.00,0.00,6633.14,0.00,'2022-10-12 00:11:09','',''),(164,'8','284',NULL,1,'Sale Id shift 37',4180320.30,0.00,0.00,0.00,0.00,'2022-10-12 00:11:09','',''),(165,'8','284','2',1,'Sale Id shift 38',0.00,0.00,0.00,2297.01,0.00,'2022-10-14 08:47:33','',''),(166,'8','284','2',1,'Sale Id shift 38',0.00,0.00,0.00,9544.62,0.00,'2022-10-14 08:47:33','',''),(167,'8','284','3',1,'Sale Id shift 38',0.00,0.00,0.00,980.26,0.00,'2022-10-14 08:47:33','',''),(168,'8','284',NULL,1,'Sale Id shift 38',2500268.55,0.00,0.00,0.00,0.00,'2022-10-14 08:47:33','',''),(169,'8','284','2',1,'Sale Id shift 39',0.00,0.00,0.00,753.22,0.00,'2022-10-14 08:56:57','',''),(170,'8','284','2',1,'Sale Id shift 39',0.00,0.00,0.00,3438.78,0.00,'2022-10-14 08:56:57','',''),(171,'8','284',NULL,1,'Sale Id shift 39',817440.00,0.00,0.00,0.00,0.00,'2022-10-14 08:56:57','',''),(172,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,11227500.00,49900.00,0.00,0.00,'2022-10-15 13:46:03','',''),(173,'8','284',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,16000.00,0.00,'2022-10-16 10:40:37','',''),(174,'8','284','1',1,'Received from bridging 18',0.00,0.00,16000.00,0.00,0.00,'2022-10-16 10:40:37','',''),(175,'8','284',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,33900.00,0.00,'2022-10-16 10:41:11','',''),(176,'8','284','2',1,'Received from bridging 19',0.00,0.00,33900.00,0.00,0.00,'2022-10-16 10:41:11','',''),(177,'8','284','1',1,'Sale Id shift 40',0.00,0.00,0.00,3070.79,0.00,'2022-10-16 10:48:32','',''),(178,'8','284','1',1,'Sale Id shift 40',0.00,0.00,0.00,2861.71,0.00,'2022-10-16 10:48:32','',''),(179,'8','284','2',1,'Sale Id shift 40',0.00,0.00,0.00,2852.37,0.00,'2022-10-16 10:48:32','',''),(180,'8','284','2',1,'Sale Id shift 40',0.00,0.00,0.00,3246.85,0.00,'2022-10-16 10:48:32','',''),(181,'8','284',NULL,1,'Sale Id shift 40',2707137.00,0.00,0.00,0.00,0.00,'2022-10-16 10:48:32','',''),(182,'8','284','1',1,'Sale Id shift 41',0.00,0.00,0.00,2500.15,0.00,'2022-10-16 11:10:17','',''),(183,'8','284','1',1,'Sale Id shift 41',0.00,0.00,0.00,4038.85,0.00,'2022-10-16 11:10:17','',''),(184,'8','284','2',1,'Sale Id shift 41',0.00,0.00,0.00,1584.52,0.00,'2022-10-16 11:10:17','',''),(185,'8','284','2',1,'Sale Id shift 41',0.00,0.00,0.00,1949.23,0.00,'2022-10-16 11:10:17','',''),(186,'8','284',NULL,1,'Sale Id shift 41',2266368.75,0.00,0.00,0.00,0.00,'2022-10-16 11:10:17','',''),(187,'8','284','1',1,'Sale Id shift 42',0.00,0.00,0.00,3531.22,0.00,'2022-10-19 15:09:13','',''),(188,'8','284','1',1,'Sale Id shift 42',0.00,0.00,0.00,1621.86,0.00,'2022-10-19 15:09:13','',''),(189,'8','284','2',1,'Sale Id shift 42',0.00,0.00,0.00,4324.65,0.00,'2022-10-19 15:09:13','',''),(190,'8','284','2',1,'Sale Id shift 42',0.00,0.00,0.00,5467.66,0.00,'2022-10-19 15:09:13','',''),(191,'8','284',NULL,1,'Sale Id shift 42',3362712.75,0.00,0.00,0.00,0.00,'2022-10-19 15:09:13','',''),(192,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,4140000.00,18000.00,0.00,0.00,'2022-10-20 11:31:29','',''),(193,'8','284','2',1,'Sale Id shift 43',0.00,0.00,0.00,2382.74,0.00,'2022-10-21 08:25:03','',''),(194,'8','284','2',1,'Sale Id shift 43',0.00,0.00,0.00,9924.35,0.00,'2022-10-21 08:25:03','',''),(195,'8','284',NULL,1,'Sale Id shift 43',2769095.25,0.00,0.00,0.00,0.00,'2022-10-21 08:25:03','',''),(196,'8','284','2',1,'Sale Id shift 44',0.00,0.00,0.00,2000.00,0.00,'2022-10-21 08:30:09','',''),(197,'8','284',NULL,1,'Sale Id shift 44',460000.00,0.00,0.00,0.00,0.00,'2022-10-21 08:30:09','',''),(198,'8','284',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,18000.00,0.00,'2022-10-21 08:34:51','',''),(199,'8','284','2',1,'Received from bridging 20',0.00,0.00,18000.00,0.00,0.00,'2022-10-21 08:34:51','',''),(200,'8','284','2',1,'Sale Id shift 45',0.00,0.00,0.00,7125.46,0.00,'2022-10-21 08:59:08','',''),(201,'8','284','2',1,'Sale Id shift 45',0.00,0.00,0.00,6826.57,0.00,'2022-10-21 08:59:08','',''),(202,'8','284',NULL,1,'Sale Id shift 45',3208966.90,0.00,0.00,0.00,0.00,'2022-10-21 08:59:08','',''),(203,'8','284','2',1,'Sale Id shift 47',0.00,0.00,0.00,3787.17,0.00,'2022-10-24 15:41:41','',''),(204,'8','284',NULL,1,'Sale Id shift 47',871049.10,0.00,0.00,0.00,0.00,'2022-10-24 15:41:41','',''),(205,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,3948000.00,16800.00,0.00,0.00,'2022-10-25 12:18:42','',''),(206,'8','284',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,16800.00,0.00,'2022-10-25 12:33:08','',''),(207,'8','284','2',1,'Received from bridging 21',0.00,0.00,16800.00,0.00,0.00,'2022-10-25 12:33:08','',''),(208,'8','284','2',1,'Sale Id shift 48',0.00,0.00,0.00,3739.32,0.00,'2022-10-27 11:04:17','',''),(209,'8','284','2',1,'Sale Id shift 48',0.00,0.00,0.00,12170.27,0.00,'2022-10-27 11:04:17','',''),(210,'8','284',NULL,1,'Sale Id shift 48',3738753.65,0.00,0.00,0.00,0.00,'2022-10-27 11:04:17','',''),(211,'8','284','2',1,'Sale Id shift 49',0.00,0.00,0.00,798.01,0.00,'2022-10-27 11:07:27','',''),(212,'8','284',NULL,1,'Sale Id shift 49',187532.35,0.00,0.00,0.00,0.00,'2022-10-27 11:07:27','',''),(213,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,11175000.00,44700.00,0.00,0.00,'2022-11-03 14:04:42','',''),(214,'8','284',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,30000.00,0.00,'2022-11-03 15:09:11','',''),(215,'8','284','1',1,'Received from bridging 22',0.00,0.00,30000.00,0.00,0.00,'2022-11-03 15:09:11','',''),(216,'8','284',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,14700.00,0.00,'2022-11-03 15:09:31','',''),(217,'8','284','2',1,'Received from bridging 23',0.00,0.00,14700.00,0.00,0.00,'2022-11-03 15:09:31','',''),(218,'8','284','1',1,'Sale Id shift 50',0.00,0.00,0.00,2090.89,0.00,'2022-11-05 00:01:08','',''),(219,'8','284','1',1,'Sale Id shift 50',0.00,0.00,0.00,2592.88,0.00,'2022-11-05 00:01:08','',''),(220,'8','284','2',1,'Sale Id shift 50',0.00,0.00,0.00,1266.30,0.00,'2022-11-05 00:01:08','',''),(221,'8','284','2',1,'Sale Id shift 50',0.00,0.00,0.00,356.05,0.00,'2022-11-05 00:01:08','',''),(222,'8','284',NULL,1,'Sale Id shift 50',1576530.00,0.00,0.00,0.00,0.00,'2022-11-05 00:01:08','',''),(223,'8','284','1',1,'Sale Id shift 51',0.00,0.00,0.00,2535.19,0.00,'2022-11-06 07:10:34','',''),(224,'8','284','1',1,'Sale Id shift 51',0.00,0.00,0.00,2543.30,0.00,'2022-11-06 07:10:34','',''),(225,'8','284','2',1,'Sale Id shift 51',0.00,0.00,0.00,2689.86,0.00,'2022-11-06 07:10:34','',''),(226,'8','284','2',1,'Sale Id shift 51',0.00,0.00,0.00,555.44,0.00,'2022-11-06 07:10:34','',''),(227,'8','284',NULL,1,'Sale Id shift 51',2080947.50,0.00,0.00,0.00,0.00,'2022-11-06 07:10:34','',''),(228,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,4250000.00,17000.00,0.00,0.00,'2022-11-06 19:13:25','',''),(229,'8','284','1',1,'Sale Id shift 52',0.00,0.00,0.00,2563.48,0.00,'2022-11-06 19:20:06','',''),(230,'8','284','1',1,'Sale Id shift 52',0.00,0.00,0.00,2570.89,0.00,'2022-11-06 19:20:06','',''),(231,'8','284','2',1,'Sale Id shift 52',0.00,0.00,0.00,836.10,0.00,'2022-11-06 19:20:06','',''),(232,'8','284','2',1,'Sale Id shift 52',0.00,0.00,0.00,1193.02,0.00,'2022-11-06 19:20:06','',''),(233,'8','284',NULL,1,'Sale Id shift 52',1790872.50,0.00,0.00,0.00,0.00,'2022-11-06 19:20:06','',''),(234,'8','284','1',1,'Sale Id shift 53',0.00,0.00,0.00,2107.92,0.00,'2022-11-07 11:23:04','',''),(235,'8','284','1',1,'Sale Id shift 53',0.00,0.00,0.00,2806.07,0.00,'2022-11-07 11:23:04','',''),(236,'8','284',NULL,1,'Sale Id shift 53',1228497.50,0.00,0.00,0.00,0.00,'2022-11-07 11:23:04','',''),(237,'8','284','1',1,'Sale Id shift 54',0.00,0.00,0.00,77.43,0.00,'2022-11-07 11:29:47','',''),(238,'8','284','1',1,'Sale Id shift 54',0.00,0.00,0.00,1291.62,0.00,'2022-11-07 11:29:47','',''),(239,'8','284','2',1,'Sale Id shift 54',0.00,0.00,0.00,463.94,0.00,'2022-11-07 11:29:47','',''),(240,'8','284',NULL,1,'Sale Id shift 54',458247.50,0.00,0.00,0.00,0.00,'2022-11-07 11:29:47','',''),(241,'8','284',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,17000.00,0.00,'2022-11-07 16:05:17','',''),(242,'8','284','2',1,'Received from bridging 24',0.00,0.00,17000.00,0.00,0.00,'2022-11-07 16:05:17','',''),(243,'8','284','1',1,'Sale Id shift 55',0.00,0.00,0.00,392.85,0.00,'2022-11-08 23:20:17','',''),(244,'8','284','1',1,'Sale Id shift 55',0.00,0.00,0.00,1705.23,0.00,'2022-11-08 23:20:17','',''),(245,'8','284','2',1,'Sale Id shift 55',0.00,0.00,0.00,2382.72,0.00,'2022-11-08 23:20:17','',''),(246,'8','284',NULL,1,'Sale Id shift 55',1120200.00,0.00,0.00,0.00,0.00,'2022-11-08 23:20:17','',''),(247,'8','284','1',1,'Sale Id shift 56',0.00,0.00,0.00,3189.03,0.00,'2022-11-09 12:01:24','',''),(248,'8','284','1',1,'Sale Id shift 56',0.00,0.00,0.00,1692.59,0.00,'2022-11-09 12:01:24','',''),(249,'8','284','2',1,'Sale Id shift 56',0.00,0.00,0.00,3162.93,0.00,'2022-11-09 12:01:24','',''),(250,'8','284','2',1,'Sale Id shift 56',0.00,0.00,0.00,5094.98,0.00,'2022-11-09 12:01:24','',''),(251,'8','284',NULL,1,'Sale Id shift 56',3284882.50,0.00,0.00,0.00,0.00,'2022-11-09 12:01:24','',''),(252,'8','284','1',1,'Sale Id shift 57',0.00,0.00,0.00,920.45,0.00,'2022-11-09 12:54:11','',''),(253,'8','284','2',1,'Sale Id shift 57',0.00,0.00,0.00,2622.78,0.00,'2022-11-09 12:54:11','',''),(254,'8','284','2',1,'Sale Id shift 57',0.00,0.00,0.00,6283.61,0.00,'2022-11-09 12:54:11','',''),(255,'8','284',NULL,1,'Sale Id shift 57',2456710.00,0.00,0.00,0.00,0.00,'2022-11-09 12:54:11','',''),(256,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,8000000.00,32000.00,0.00,0.00,'2022-11-10 22:03:46','',''),(257,'8','284',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,32000.00,0.00,'2022-11-11 06:51:25','',''),(258,'8','284','2',1,'Received from bridging 25',0.00,0.00,32000.00,0.00,0.00,'2022-11-11 06:51:25','',''),(259,'8','284','1',1,'Sale Id shift 58',0.00,0.00,0.00,102.50,0.00,'2022-11-11 11:58:34','',''),(260,'8','284','2',1,'Sale Id shift 58',0.00,0.00,0.00,3107.13,0.00,'2022-11-11 11:58:34','',''),(261,'8','284','2',1,'Sale Id shift 58',0.00,0.00,0.00,6835.17,0.00,'2022-11-11 11:58:34','',''),(262,'8','284',NULL,1,'Sale Id shift 58',2511200.00,0.00,0.00,0.00,0.00,'2022-11-11 11:58:34','',''),(263,'8','284','2',1,'Sale Id shift 59',0.00,0.00,0.00,4891.36,0.00,'2022-11-12 06:34:44','',''),(264,'8','284','2',1,'Sale Id shift 59',0.00,0.00,0.00,7449.16,0.00,'2022-11-12 06:34:44','',''),(265,'8','284',NULL,1,'Sale Id shift 59',3085130.00,0.00,0.00,0.00,0.00,'2022-11-12 06:34:44','',''),(266,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,8200000.00,32800.00,0.00,0.00,'2022-11-14 08:08:48','',''),(267,'8','284',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,11450.00,0.00,'2022-11-14 10:34:52','',''),(268,'8','284','2',1,'Received from bridging 27',0.00,0.00,11450.00,0.00,0.00,'2022-11-14 10:34:52','',''),(269,'8','284',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,21350.00,0.00,'2022-11-14 10:35:15','',''),(270,'8','284','1',1,'Received from bridging 26',0.00,0.00,21350.00,0.00,0.00,'2022-11-14 10:35:15','',''),(271,'8','284','2',1,'Sale Id shift 60',0.00,0.00,0.00,4649.15,0.00,'2022-11-14 10:42:58','',''),(272,'8','284','2',1,'Sale Id shift 60',0.00,0.00,0.00,7655.30,0.00,'2022-11-14 10:42:58','',''),(273,'8','284',NULL,1,'Sale Id shift 60',3076112.50,0.00,0.00,0.00,0.00,'2022-11-14 10:42:58','',''),(274,'8','284','2',1,'Sale Id shift 61',0.00,0.00,0.00,2880.97,0.00,'2022-11-14 10:48:42','',''),(275,'8','284','2',1,'Sale Id shift 61',0.00,0.00,0.00,2838.67,0.00,'2022-11-14 10:48:42','',''),(276,'8','284',NULL,1,'Sale Id shift 61',1429910.00,0.00,0.00,0.00,0.00,'2022-11-14 10:48:42','',''),(277,'8','284','1',1,'Sale Id shift 62',0.00,0.00,0.00,3612.34,0.00,'2022-11-14 10:55:06','',''),(278,'8','284','1',1,'Sale Id shift 62',0.00,0.00,0.00,3848.24,0.00,'2022-11-14 10:55:06','',''),(279,'8','284','2',1,'Sale Id shift 62',0.00,0.00,0.00,1195.70,0.00,'2022-11-14 10:55:06','',''),(280,'8','284','2',1,'Sale Id shift 62',0.00,0.00,0.00,1860.89,0.00,'2022-11-14 10:55:06','',''),(281,'8','284',NULL,1,'Sale Id shift 62',2629292.50,0.00,0.00,0.00,0.00,'2022-11-14 10:55:06','',''),(282,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,4245750.00,16650.00,0.00,0.00,'2022-11-15 22:24:47','',''),(283,'8','284',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,16650.00,0.00,'2022-11-15 22:50:52','',''),(284,'8','284','1',1,'Received from bridging 28',0.00,0.00,16650.00,0.00,0.00,'2022-11-15 22:50:52','',''),(285,'8','284','1',1,'Sale Id shift 63',0.00,0.00,0.00,5746.37,0.00,'2022-11-15 22:52:33','',''),(286,'8','284','1',1,'Sale Id shift 63',0.00,0.00,0.00,6382.62,0.00,'2022-11-15 22:52:33','',''),(287,'8','284','2',1,'Sale Id shift 63',0.00,0.00,0.00,81.70,0.00,'2022-11-15 22:52:33','',''),(288,'8','284','2',1,'Sale Id shift 63',0.00,0.00,0.00,5257.49,0.00,'2022-11-15 22:52:33','',''),(289,'8','284',NULL,1,'Sale Id shift 63',4367045.00,0.00,0.00,0.00,0.00,'2022-11-15 22:52:33','',''),(290,'8','284','1',1,'Sale Id shift 64',0.00,0.00,0.00,1344.22,0.00,'2022-11-16 09:52:29','',''),(291,'8','284','1',1,'Sale Id shift 64',0.00,0.00,0.00,3538.93,0.00,'2022-11-16 09:52:29','',''),(292,'8','284',NULL,1,'Sale Id shift 64',1245203.25,0.00,0.00,0.00,0.00,'2022-11-16 09:52:29','',''),(293,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,8338500.00,32700.00,0.00,0.00,'2022-11-17 11:23:30','',''),(294,'8','284',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,32700.00,0.00,'2022-11-17 16:03:40','',''),(295,'8','284','2',1,'Received from bridging 29',0.00,0.00,32700.00,0.00,0.00,'2022-11-17 16:03:40','',''),(296,'8','284','1',1,'Sale Id shift 65',0.00,0.00,0.00,1896.68,0.00,'2022-11-18 09:02:10','',''),(297,'8','284','1',1,'Sale Id shift 65',0.00,0.00,0.00,4461.83,0.00,'2022-11-18 09:02:10','',''),(298,'8','284','2',1,'Sale Id shift 65',0.00,0.00,0.00,6090.43,0.00,'2022-11-18 09:02:10','',''),(299,'8','284',NULL,1,'Sale Id shift 65',3174479.70,0.00,0.00,0.00,0.00,'2022-11-18 09:02:10','',''),(300,'8','284','1',1,'Sale Id shift 66',0.00,0.00,0.00,993.34,0.00,'2022-11-19 21:52:24','',''),(301,'8','284','1',1,'Sale Id shift 66',0.00,0.00,0.00,400.33,0.00,'2022-11-19 21:52:24','',''),(302,'8','284','2',1,'Sale Id shift 66',0.00,0.00,0.00,3633.48,0.00,'2022-11-19 21:52:24','',''),(303,'8','284','2',1,'Sale Id shift 66',0.00,0.00,0.00,3876.93,0.00,'2022-11-19 21:52:24','',''),(304,'8','284',NULL,1,'Sale Id shift 66',2270540.40,0.00,0.00,0.00,0.00,'2022-11-19 21:52:24','',''),(305,'8','284','1',1,'Sale Id shift 67',0.00,0.00,0.00,2700.30,0.00,'2022-11-20 08:47:47','',''),(306,'8','284','2',1,'Sale Id shift 67',0.00,0.00,0.00,2074.10,0.00,'2022-11-20 08:47:47','',''),(307,'8','284','2',1,'Sale Id shift 67',0.00,0.00,0.00,2252.09,0.00,'2022-11-20 08:47:47','',''),(308,'8','284',NULL,1,'Sale Id shift 67',1791754.95,0.00,0.00,0.00,0.00,'2022-11-20 08:47:47','',''),(309,'8','284','1',1,'Sale Id shift 68',0.00,0.00,0.00,2532.49,0.00,'2022-11-22 08:07:07','',''),(310,'8','284','2',1,'Sale Id shift 68',0.00,0.00,0.00,1132.99,0.00,'2022-11-22 08:07:07','',''),(311,'8','284','2',1,'Sale Id shift 68',0.00,0.00,0.00,3441.50,0.00,'2022-11-22 08:07:07','',''),(312,'8','284',NULL,1,'Sale Id shift 68',1812279.90,0.00,0.00,0.00,0.00,'2022-11-22 08:07:07','',''),(313,'8','284','1',1,'Sale Id shift 69',0.00,0.00,0.00,469.08,0.00,'2022-11-22 08:14:44','',''),(314,'8','284','2',1,'Sale Id shift 69',0.00,0.00,0.00,3178.01,0.00,'2022-11-22 08:14:44','',''),(315,'8','284','2',1,'Sale Id shift 69',0.00,0.00,0.00,5362.58,0.00,'2022-11-22 08:14:44','',''),(316,'8','284',NULL,1,'Sale Id shift 69',2297465.85,0.00,0.00,0.00,0.00,'2022-11-22 08:14:44','',''),(317,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,8224000.00,32000.00,0.00,0.00,'2022-11-24 11:33:21','',''),(318,'8','284',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,32000.00,0.00,'2022-11-24 13:16:19','',''),(319,'8','284','2',1,'Received from bridging 31',0.00,0.00,32000.00,0.00,0.00,'2022-11-24 13:16:19','',''),(320,'8','284','2',1,'Sale Id shift 70',0.00,0.00,0.00,1000.00,0.00,'2022-11-24 13:21:50','',''),(321,'8','284','2',1,'Sale Id shift 70',0.00,0.00,0.00,1000.00,0.00,'2022-11-24 13:21:50','',''),(322,'8','284',NULL,1,'Sale Id shift 70',510000.00,0.00,0.00,0.00,0.00,'2022-11-24 13:21:50','',''),(323,'8','284','2',1,'Sale Id shift 71',0.00,0.00,0.00,1415.88,0.00,'2022-11-24 13:27:22','',''),(324,'8','284','2',1,'Sale Id shift 71',0.00,0.00,0.00,5643.87,0.00,'2022-11-24 13:27:22','',''),(325,'8','284',NULL,1,'Sale Id shift 71',1814355.75,0.00,0.00,0.00,0.00,'2022-11-24 13:27:22','',''),(326,'8','284','2',1,'Sale Id shift 72',0.00,0.00,0.00,3549.55,0.00,'2022-11-24 13:32:42','',''),(327,'8','284','2',1,'Sale Id shift 72',0.00,0.00,0.00,4552.81,0.00,'2022-11-24 13:32:42','',''),(328,'8','284',NULL,1,'Sale Id shift 72',2082306.52,0.00,0.00,0.00,0.00,'2022-11-24 13:32:42','',''),(329,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,8738000.00,34000.00,0.00,0.00,'2022-11-27 09:29:05','',''),(330,'8','284',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,17350.00,0.00,'2022-11-27 14:29:09','',''),(331,'8','284','2',1,'Received from bridging 33',0.00,0.00,17350.00,0.00,0.00,'2022-11-27 14:29:09','',''),(332,'8','284',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,16650.00,0.00,'2022-11-27 14:29:43','',''),(333,'8','284','1',1,'Received from bridging 32',0.00,0.00,16650.00,0.00,0.00,'2022-11-27 14:29:43','',''),(334,'8','284','2',1,'Sale Id shift 73',0.00,0.00,0.00,3992.44,0.00,'2022-11-27 14:32:32','',''),(335,'8','284','2',1,'Sale Id shift 73',0.00,0.00,0.00,4886.31,0.00,'2022-11-27 14:32:32','',''),(336,'8','284',NULL,1,'Sale Id shift 73',2281838.75,0.00,0.00,0.00,0.00,'2022-11-27 14:32:32','',''),(337,'8','284','1',1,'Sale Id shift 74',0.00,0.00,0.00,1288.57,0.00,'2022-11-27 14:45:31','',''),(338,'8','284','1',1,'Sale Id shift 74',0.00,0.00,0.00,2092.21,0.00,'2022-11-27 14:45:31','',''),(339,'8','284','2',1,'Sale Id shift 74',0.00,0.00,0.00,2011.76,0.00,'2022-11-27 14:45:31','',''),(340,'8','284','2',1,'Sale Id shift 74',0.00,0.00,0.00,3319.86,0.00,'2022-11-27 14:45:31','',''),(341,'8','284',NULL,1,'Sale Id shift 74',2239086.80,0.00,0.00,0.00,0.00,'2022-11-27 14:45:31','',''),(342,'8','284','1',1,'Sale Id shift 75',0.00,0.00,0.00,2702.08,0.00,'2022-11-27 14:53:54','',''),(343,'8','284','2',1,'Sale Id shift 75',0.00,0.00,0.00,2152.61,0.00,'2022-11-27 14:53:54','',''),(344,'8','284','2',1,'Sale Id shift 75',0.00,0.00,0.00,2967.48,0.00,'2022-11-27 14:53:54','',''),(345,'8','284',NULL,1,'Sale Id shift 75',2010297.69,0.00,0.00,0.00,0.00,'2022-11-27 14:53:54','',''),(346,'8','284','1',1,'Sale Id shift 76',0.00,0.00,0.00,742.27,0.00,'2022-12-01 00:15:12','',''),(347,'8','284','1',1,'Sale Id shift 76',0.00,0.00,0.00,3935.07,0.00,'2022-12-01 00:15:12','',''),(348,'8','284','2',1,'Sale Id shift 76',0.00,0.00,0.00,2378.32,0.00,'2022-12-01 00:15:12','',''),(349,'8','284','2',1,'Sale Id shift 76',0.00,0.00,0.00,2857.35,0.00,'2022-12-01 00:15:12','',''),(350,'8','284',NULL,1,'Sale Id shift 76',2547643.57,0.00,0.00,0.00,0.00,'2022-12-01 00:15:12','',''),(351,'8','284','1',1,'Sale Id shift 77',0.00,0.00,0.00,497.76,0.00,'2022-12-01 00:26:36','',''),(352,'8','284','1',1,'Sale Id shift 77',0.00,0.00,0.00,3905.90,0.00,'2022-12-01 00:26:36','',''),(353,'8','284','2',1,'Sale Id shift 77',0.00,0.00,0.00,3615.80,0.00,'2022-12-01 00:26:36','',''),(354,'8','284','2',1,'Sale Id shift 77',0.00,0.00,0.00,4475.66,0.00,'2022-12-01 00:26:36','',''),(355,'8','284',NULL,1,'Sale Id shift 77',3211245.84,0.00,0.00,0.00,0.00,'2022-12-01 00:26:36','',''),(356,'8','284','1',1,'Sale Id shift 78',0.00,0.00,0.00,1732.72,0.00,'2022-12-01 00:32:23','',''),(357,'8','284','2',1,'Sale Id shift 78',0.00,0.00,0.00,798.54,0.00,'2022-12-01 00:32:23','',''),(358,'8','284','2',1,'Sale Id shift 78',0.00,0.00,0.00,469.91,0.00,'2022-12-01 00:32:23','',''),(359,'8','284',NULL,1,'Sale Id shift 78',771300.69,0.00,0.00,0.00,0.00,'2022-12-01 00:32:23','',''),(360,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,4680000.00,18000.00,0.00,0.00,'2022-12-02 08:28:18','',''),(361,'8','284',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,18000.00,0.00,'2022-12-03 08:20:49','',''),(362,'8','284','2',1,'Received from bridging 34',0.00,0.00,18000.00,0.00,0.00,'2022-12-03 08:20:49','',''),(363,'8','284','2',1,'Sale Id shift 79',0.00,0.00,0.00,6108.63,0.00,'2022-12-03 12:33:24','',''),(364,'8','284','2',1,'Sale Id shift 79',0.00,0.00,0.00,8132.97,0.00,'2022-12-03 12:33:24','',''),(365,'8','284',NULL,1,'Sale Id shift 79',3702816.00,0.00,0.00,0.00,0.00,'2022-12-03 12:33:24','',''),(366,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,8910000.00,33000.00,0.00,0.00,'2022-12-06 10:24:36','',''),(367,'8','284',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,33000.00,0.00,'2022-12-06 12:34:36','',''),(368,'8','284','2',1,'Received from bridging 35',0.00,0.00,33000.00,0.00,0.00,'2022-12-06 12:34:36','',''),(369,'8','284','2',1,'Sale Id shift 80',0.00,0.00,0.00,1435.66,0.00,'2022-12-06 12:42:20','',''),(370,'8','284','2',1,'Sale Id shift 80',0.00,0.00,0.00,2431.13,0.00,'2022-12-06 12:42:20','',''),(371,'8','284',NULL,1,'Sale Id shift 80',1044033.30,0.00,0.00,0.00,0.00,'2022-12-06 12:42:20','',''),(372,'8','284','2',1,'Sale Id shift 81',0.00,0.00,0.00,2561.32,0.00,'2022-12-07 18:17:50','',''),(373,'8','284','2',1,'Sale Id shift 81',0.00,0.00,0.00,2352.77,0.00,'2022-12-07 18:17:50','',''),(374,'8','284',NULL,1,'Sale Id shift 81',1326804.30,0.00,0.00,0.00,0.00,'2022-12-07 18:17:50','',''),(375,'8','284','2',1,'Sale Id shift 82',0.00,0.00,0.00,4482.58,0.00,'2022-12-08 12:34:03','',''),(376,'8','284','2',1,'Sale Id shift 82',0.00,0.00,0.00,3663.74,0.00,'2022-12-08 12:34:03','',''),(377,'8','284',NULL,1,'Sale Id shift 82',2199506.40,0.00,0.00,0.00,0.00,'2022-12-08 12:34:03','',''),(378,'8','284','2',1,'Sale Id shift 83',0.00,0.00,0.00,7124.79,0.00,'2022-12-08 12:38:55','',''),(379,'8','284','2',1,'Sale Id shift 83',0.00,0.00,0.00,8903.76,0.00,'2022-12-08 12:38:55','',''),(380,'8','284',NULL,1,'Sale Id shift 83',4327708.50,0.00,0.00,0.00,0.00,'2022-12-08 12:38:55','',''),(381,'8','284','2',1,'Sale Id shift 84',0.00,0.00,0.00,1162.53,0.00,'2022-12-11 16:42:16','',''),(382,'8','284','2',1,'Sale Id shift 84',0.00,0.00,0.00,2616.67,0.00,'2022-12-11 16:42:16','',''),(383,'8','284',NULL,1,'Sale Id shift 84',1020384.00,0.00,0.00,0.00,0.00,'2022-12-11 16:42:16','',''),(384,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,13655500.00,44050.00,0.00,0.00,'2022-12-12 16:10:28','',''),(385,'8','284',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,27900.00,0.00,'2022-12-14 07:46:49','',''),(386,'8','284','2',1,'Received from bridging 37',0.00,0.00,27900.00,0.00,0.00,'2022-12-14 07:46:49','',''),(387,'8','284',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,16150.00,0.00,'2022-12-14 07:47:19','',''),(388,'8','284','1',1,'Received from bridging 36',0.00,0.00,16150.00,0.00,0.00,'2022-12-14 07:47:19','',''),(389,'8','284','1',1,'Sale Id shift 85',0.00,0.00,0.00,3171.68,0.00,'2022-12-14 07:51:28','',''),(390,'8','284','2',1,'Sale Id shift 85',0.00,0.00,0.00,1493.08,0.00,'2022-12-14 07:51:28','',''),(391,'8','284','2',1,'Sale Id shift 85',0.00,0.00,0.00,2575.75,0.00,'2022-12-14 07:51:28','',''),(392,'8','284',NULL,1,'Sale Id shift 85',1954937.70,0.00,0.00,0.00,0.00,'2022-12-14 07:51:28','',''),(393,'8','284','1',1,'Sale Id shift 86',0.00,0.00,0.00,3636.80,0.00,'2022-12-14 07:59:12','',''),(394,'8','284','2',1,'Sale Id shift 86',0.00,0.00,0.00,4510.31,0.00,'2022-12-14 07:59:12','',''),(395,'8','284','2',1,'Sale Id shift 86',0.00,0.00,0.00,5453.01,0.00,'2022-12-14 07:59:12','',''),(396,'8','284',NULL,1,'Sale Id shift 86',4216037.20,0.00,0.00,0.00,0.00,'2022-12-14 07:59:12','',''),(397,'8','284','1',1,'Sale Id shift 87',0.00,0.00,0.00,3872.34,0.00,'2022-12-14 08:08:57','',''),(398,'8','284','2',1,'Sale Id shift 87',0.00,0.00,0.00,1518.21,0.00,'2022-12-14 08:08:57','',''),(399,'8','284','2',1,'Sale Id shift 87',0.00,0.00,0.00,3523.70,0.00,'2022-12-14 08:08:57','',''),(400,'8','284',NULL,1,'Sale Id shift 87',2763417.50,0.00,0.00,0.00,0.00,'2022-12-14 08:08:57','',''),(401,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,10121500.00,32650.00,0.00,0.00,'2022-12-16 17:45:17','',''),(402,'8','284',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,32650.00,0.00,'2022-12-17 16:24:41','',''),(403,'8','284','2',1,'Received from bridging 38',0.00,0.00,32650.00,0.00,0.00,'2022-12-17 16:24:41','',''),(404,'8','284','1',1,'Sale Id shift 88',0.00,0.00,0.00,5126.01,0.00,'2022-12-19 08:36:10','',''),(405,'8','284','2',1,'Sale Id shift 88',0.00,0.00,0.00,1184.38,0.00,'2022-12-19 08:36:10','',''),(406,'8','284','2',1,'Sale Id shift 88',0.00,0.00,0.00,4413.28,0.00,'2022-12-19 08:36:10','',''),(407,'8','284',NULL,1,'Sale Id shift 88',3324337.70,0.00,0.00,0.00,0.00,'2022-12-19 08:36:10','',''),(408,'8','284','1',1,'Sale Id shift 89',0.00,0.00,0.00,462.72,0.00,'2022-12-19 08:41:24','',''),(409,'8','284','2',1,'Sale Id shift 89',0.00,0.00,0.00,1428.80,0.00,'2022-12-19 08:41:24','',''),(410,'8','284','2',1,'Sale Id shift 89',0.00,0.00,0.00,2163.93,0.00,'2022-12-19 08:41:24','',''),(411,'8','284',NULL,1,'Sale Id shift 89',1257189.50,0.00,0.00,0.00,0.00,'2022-12-19 08:41:24','',''),(412,'8','284','2',1,'Sale Id shift 90',0.00,0.00,0.00,3815.12,0.00,'2022-12-19 08:50:02','',''),(413,'8','284','2',1,'Sale Id shift 90',0.00,0.00,0.00,4089.94,0.00,'2022-12-19 08:50:02','',''),(414,'8','284',NULL,1,'Sale Id shift 90',2450568.60,0.00,0.00,0.00,0.00,'2022-12-19 08:50:02','',''),(415,'8','284','2',1,'Sale Id shift 91',0.00,0.00,0.00,4025.60,0.00,'2022-12-19 08:59:57','',''),(416,'8','284','2',1,'Sale Id shift 91',0.00,0.00,0.00,4884.72,0.00,'2022-12-19 08:59:57','',''),(417,'8','284',NULL,1,'Sale Id shift 91',2762199.20,0.00,0.00,0.00,0.00,'2022-12-19 08:59:57','',''),(418,'8','284','2',1,'Sale Id shift 92',0.00,0.00,0.00,4358.86,0.00,'2022-12-19 09:19:37','',''),(419,'8','284','2',1,'Sale Id shift 92',0.00,0.00,0.00,4998.63,0.00,'2022-12-19 09:19:37','',''),(420,'8','284',NULL,1,'Sale Id shift 92',2900821.90,0.00,0.00,0.00,0.00,'2022-12-19 09:19:37','',''),(421,'8','284','2',1,'Sale Id shift 93',0.00,0.00,0.00,1874.79,0.00,'2022-12-20 08:07:47','',''),(422,'8','284','2',1,'Sale Id shift 93',0.00,0.00,0.00,3840.74,0.00,'2022-12-20 08:07:47','',''),(423,'8','284',NULL,1,'Sale Id shift 93',1771814.30,0.00,0.00,0.00,0.00,'2022-12-20 08:07:47','',''),(424,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,9656500.00,31150.00,0.00,0.00,'2022-12-20 20:47:08','',''),(425,'8','284',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,31150.00,0.00,'2022-12-21 10:32:58','',''),(426,'8','284','2',1,'Received from bridging 39',0.00,0.00,31150.00,0.00,0.00,'2022-12-21 10:32:58','',''),(427,'8','284','2',1,'Sale Id shift 94',0.00,0.00,0.00,2524.95,0.00,'2022-12-22 09:28:53','',''),(428,'8','284','2',1,'Sale Id shift 94',0.00,0.00,0.00,4813.55,0.00,'2022-12-22 09:28:53','',''),(429,'8','284',NULL,1,'Sale Id shift 94',2274935.00,0.00,0.00,0.00,0.00,'2022-12-22 09:28:53','',''),(430,'8','284','2',1,'Sale Id shift 95',0.00,0.00,0.00,3352.22,0.00,'2022-12-22 09:34:07','',''),(431,'8','284','2',1,'Sale Id shift 95',0.00,0.00,0.00,5227.30,0.00,'2022-12-22 09:34:07','',''),(432,'8','284',NULL,1,'Sale Id shift 95',2659651.20,0.00,0.00,0.00,0.00,'2022-12-22 09:34:07','',''),(433,'8','284','2',1,'Sale Id shift 96',0.00,0.00,0.00,3700.20,0.00,'2022-12-25 09:29:44','',''),(434,'8','284','2',1,'Sale Id shift 96',0.00,0.00,0.00,3801.66,0.00,'2022-12-25 09:29:44','',''),(435,'8','284',NULL,1,'Sale Id shift 96',2325576.60,0.00,0.00,0.00,0.00,'2022-12-25 09:29:44','',''),(436,'8','284','2',1,'Sale Id shift 97',0.00,0.00,0.00,1937.62,0.00,'2022-12-25 09:35:39','',''),(437,'8','284','2',1,'Sale Id shift 97',0.00,0.00,0.00,3349.65,0.00,'2022-12-25 09:35:39','',''),(438,'8','284',NULL,1,'Sale Id shift 97',1639053.70,0.00,0.00,0.00,0.00,'2022-12-25 09:35:39','',''),(439,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,5270000.00,17000.00,0.00,0.00,'2022-12-29 13:00:58','',''),(440,'8','284',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,17000.00,0.00,'2022-12-30 12:07:08','',''),(441,'8','284','2',1,'Received from bridging 40',0.00,0.00,17000.00,0.00,0.00,'2022-12-30 12:07:08','',''),(442,'8','284','2',1,'Sale Id shift 98',0.00,0.00,0.00,1339.12,0.00,'2022-12-30 12:10:46','',''),(443,'8','284','2',1,'Sale Id shift 98',0.00,0.00,0.00,1904.50,0.00,'2022-12-30 12:10:46','',''),(444,'8','284',NULL,1,'Sale Id shift 98',1005522.20,0.00,0.00,0.00,0.00,'2022-12-30 12:10:46','',''),(445,'8','284','2',1,'Sale Id shift 99',0.00,0.00,0.00,1999.30,0.00,'2022-12-30 12:22:44','',''),(446,'8','284','2',1,'Sale Id shift 99',0.00,0.00,0.00,999.31,0.00,'2022-12-30 12:22:44','',''),(447,'8','284',NULL,1,'Sale Id shift 99',929569.10,0.00,0.00,0.00,0.00,'2022-12-30 12:22:44','',''),(448,'8','284','2',1,'Sale Id shift 100',0.00,0.00,0.00,2574.25,0.00,'2022-12-30 12:28:27','',''),(449,'8','284','2',1,'Sale Id shift 100',0.00,0.00,0.00,2050.34,0.00,'2022-12-30 12:28:27','',''),(450,'8','284',NULL,1,'Sale Id shift 100',1433622.90,0.00,0.00,0.00,0.00,'2022-12-30 12:28:27','',''),(451,'8','284','2',1,'Sale Id shift 101',0.00,0.00,0.00,1201.12,0.00,'2022-12-30 12:38:51','',''),(452,'8','284','2',1,'Sale Id shift 101',0.00,0.00,0.00,1402.50,0.00,'2022-12-30 12:38:51','',''),(453,'8','284',NULL,1,'Sale Id shift 101',807122.20,0.00,0.00,0.00,0.00,'2022-12-30 12:38:51','',''),(454,'8','284','2',1,'Sale Id shift 102',0.00,0.00,0.00,1053.50,0.00,'2022-12-30 12:42:55','',''),(455,'8','284','2',1,'Sale Id shift 102',0.00,0.00,0.00,2347.60,0.00,'2022-12-30 12:42:55','',''),(456,'8','284',NULL,1,'Sale Id shift 102',1054341.00,0.00,0.00,0.00,0.00,'2022-12-30 12:42:55','',''),(457,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,14542400.00,48800.00,0.00,0.00,'2023-01-06 09:42:06','',''),(458,'8','284',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,13800.00,0.00,'2023-01-07 10:49:29','',''),(459,'8','284','1',1,'Received from bridging 41',0.00,0.00,13800.00,0.00,0.00,'2023-01-07 10:49:29','',''),(460,'8','284',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,35000.00,0.00,'2023-01-07 10:49:52','',''),(461,'8','284','2',1,'Received from bridging 42',0.00,0.00,35000.00,0.00,0.00,'2023-01-07 10:49:52','',''),(462,'8','284','2',1,'Sale Id shift 103',0.00,0.00,0.00,46.18,0.00,'2023-01-07 11:03:45','',''),(463,'8','284','2',1,'Sale Id shift 103',0.00,0.00,0.00,3147.84,0.00,'2023-01-07 11:03:45','',''),(464,'8','284',NULL,1,'Sale Id shift 103',951817.96,0.00,0.00,0.00,0.00,'2023-01-07 11:03:45','',''),(465,'8','284','2',1,'Sale Id shift 104',0.00,0.00,0.00,1471.23,0.00,'2023-01-07 11:08:27','',''),(466,'8','284','2',1,'Sale Id shift 104',0.00,0.00,0.00,2094.09,0.00,'2023-01-07 11:08:27','',''),(467,'8','284',NULL,1,'Sale Id shift 104',1062465.36,0.00,0.00,0.00,0.00,'2023-01-07 11:08:27','',''),(468,'8','284','1',1,'Sale Id shift 105',0.00,0.00,0.00,341.40,0.00,'2023-01-07 11:13:33','',''),(469,'8','284','2',1,'Sale Id shift 105',0.00,0.00,0.00,1974.79,0.00,'2023-01-07 11:13:33','',''),(470,'8','284','2',1,'Sale Id shift 105',0.00,0.00,0.00,2511.50,0.00,'2023-01-07 11:13:33','',''),(471,'8','284',NULL,1,'Sale Id shift 105',1438651.62,0.00,0.00,0.00,0.00,'2023-01-07 11:13:33','',''),(472,'8','284','1',1,'Sale Id shift 107',0.00,0.00,0.00,1431.01,0.00,'2023-01-09 22:18:23','',''),(473,'8','284','2',1,'Sale Id shift 107',0.00,0.00,0.00,1610.27,0.00,'2023-01-09 22:18:23','',''),(474,'8','284','2',1,'Sale Id shift 107',0.00,0.00,0.00,1587.62,0.00,'2023-01-09 22:18:23','',''),(475,'8','284',NULL,1,'Sale Id shift 107',1379412.20,0.00,0.00,0.00,0.00,'2023-01-09 22:18:23','',''),(476,'8','284','2',1,'Sale Id shift 108',0.00,0.00,0.00,2250.40,0.00,'2023-01-09 22:25:13','',''),(477,'8','284','2',1,'Sale Id shift 108',0.00,0.00,0.00,2835.25,0.00,'2023-01-09 22:25:13','',''),(478,'8','284',NULL,1,'Sale Id shift 108',1515523.70,0.00,0.00,0.00,0.00,'2023-01-09 22:25:13','',''),(479,'8','284','2',1,'Sale Id shift 109',0.00,0.00,0.00,1978.11,0.00,'2023-01-09 22:31:48','',''),(480,'8','284','2',1,'Sale Id shift 109',0.00,0.00,0.00,2328.96,0.00,'2023-01-09 22:31:48','',''),(481,'8','284',NULL,1,'Sale Id shift 109',1283506.86,0.00,0.00,0.00,0.00,'2023-01-09 22:31:48','',''),(482,'8','284','1',1,'Sale Id shift 111',0.00,0.00,0.00,3760.24,0.00,'2023-01-12 15:51:54','',''),(483,'8','284','2',1,'Sale Id shift 111',0.00,0.00,0.00,2694.08,0.00,'2023-01-12 15:51:54','',''),(484,'8','284','2',1,'Sale Id shift 111',0.00,0.00,0.00,3631.59,0.00,'2023-01-12 15:51:54','',''),(485,'8','284',NULL,1,'Sale Id shift 111',3005601.18,0.00,0.00,0.00,0.00,'2023-01-12 15:51:54','',''),(486,'8','284','1',1,'Sale Id shift 112',0.00,0.00,0.00,1826.71,0.00,'2023-01-12 15:57:36','',''),(487,'8','284','2',1,'Sale Id shift 112',0.00,0.00,0.00,1394.61,0.00,'2023-01-12 15:57:36','',''),(488,'8','284','2',1,'Sale Id shift 112',0.00,0.00,0.00,1085.97,0.00,'2023-01-12 15:57:36','',''),(489,'8','284',NULL,1,'Sale Id shift 112',1283572.42,0.00,0.00,0.00,0.00,'2023-01-12 15:57:36','',''),(490,'8','284','1',1,'Sale Id shift 113',0.00,0.00,0.00,2652.43,0.00,'2023-01-14 21:22:45','',''),(491,'8','284','2',1,'Sale Id shift 113',0.00,0.00,0.00,1248.16,0.00,'2023-01-14 21:22:45','',''),(492,'8','284','2',1,'Sale Id shift 113',0.00,0.00,0.00,1362.11,0.00,'2023-01-14 21:22:45','',''),(493,'8','284',NULL,1,'Sale Id shift 113',1568284.60,0.00,0.00,0.00,0.00,'2023-01-14 21:22:45','',''),(494,'8','284','1',1,'Sale Id shift 114',0.00,0.00,0.00,2208.60,0.00,'2023-01-14 21:30:01','',''),(495,'8','284','2',1,'Sale Id shift 114',0.00,0.00,0.00,1167.94,0.00,'2023-01-14 21:30:01','',''),(496,'8','284','2',1,'Sale Id shift 114',0.00,0.00,0.00,1522.14,0.00,'2023-01-14 21:30:01','',''),(497,'8','284',NULL,1,'Sale Id shift 114',1459806.64,0.00,0.00,0.00,0.00,'2023-01-14 21:30:01','',''),(498,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,14602000.00,49000.00,0.00,0.00,'2023-01-18 14:44:16','',''),(499,'8','284',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,32200.00,0.00,'2023-01-19 15:25:34','',''),(500,'8','284','2',1,'Received from bridging 44',0.00,0.00,32200.00,0.00,0.00,'2023-01-19 15:25:34','',''),(501,'8','284',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,16800.00,0.00,'2023-01-19 15:25:51','',''),(502,'8','284','1',1,'Received from bridging 43',0.00,0.00,16800.00,0.00,0.00,'2023-01-19 15:25:51','',''),(503,'8','284','1',1,'Sale Id shift 115',0.00,0.00,0.00,1210.13,0.00,'2023-01-20 12:43:12','',''),(504,'8','284','2',1,'Sale Id shift 115',0.00,0.00,0.00,500.00,0.00,'2023-01-20 12:43:12','',''),(505,'8','284',NULL,1,'Sale Id shift 115',509618.74,0.00,0.00,0.00,0.00,'2023-01-20 12:43:12','',''),(506,'8','284','1',1,'Sale Id shift 116',0.00,0.00,0.00,3677.32,0.00,'2023-01-20 12:50:24','',''),(507,'8','284','2',1,'Sale Id shift 116',0.00,0.00,0.00,2133.01,0.00,'2023-01-20 12:50:24','',''),(508,'8','284','2',1,'Sale Id shift 116',0.00,0.00,0.00,2106.69,0.00,'2023-01-20 12:50:24','',''),(509,'8','284',NULL,1,'Sale Id shift 116',2359271.96,0.00,0.00,0.00,0.00,'2023-01-20 12:50:24','',''),(510,'8','284','1',1,'Sale Id shift 117',0.00,0.00,0.00,2414.75,0.00,'2023-01-20 12:57:12','',''),(511,'8','284','2',1,'Sale Id shift 117',0.00,0.00,0.00,3034.87,0.00,'2023-01-20 12:57:12','',''),(512,'8','284','2',1,'Sale Id shift 117',0.00,0.00,0.00,2798.24,0.00,'2023-01-20 12:57:12','',''),(513,'8','284',NULL,1,'Sale Id shift 117',2457862.28,0.00,0.00,0.00,0.00,'2023-01-20 12:57:12','',''),(514,'8','284','1',1,'Sale Id shift 118',0.00,0.00,0.00,1557.30,0.00,'2023-01-20 13:02:25','',''),(515,'8','284','2',1,'Sale Id shift 118',0.00,0.00,0.00,1745.36,0.00,'2023-01-20 13:02:25','',''),(516,'8','284','2',1,'Sale Id shift 118',0.00,0.00,0.00,1465.40,0.00,'2023-01-20 13:02:25','',''),(517,'8','284',NULL,1,'Sale Id shift 118',1420881.88,0.00,0.00,0.00,0.00,'2023-01-20 13:02:25','',''),(518,'8','284','1',1,'Sale Id shift 119',0.00,0.00,0.00,1502.50,0.00,'2023-01-20 13:09:17','',''),(519,'8','284','2',1,'Sale Id shift 119',0.00,0.00,0.00,1951.20,0.00,'2023-01-20 13:09:17','',''),(520,'8','284','2',1,'Sale Id shift 119',0.00,0.00,0.00,1790.55,0.00,'2023-01-20 13:09:17','',''),(521,'8','284',NULL,1,'Sale Id shift 119',1562786.50,0.00,0.00,0.00,0.00,'2023-01-20 13:09:17','',''),(522,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,11120200.00,32900.00,0.00,0.00,'2023-02-07 12:29:40','',''),(523,'8','284','1',1,'Sale Id shift 120',0.00,0.00,0.00,1450.62,0.00,'2023-02-07 14:57:19','',''),(524,'8','284','2',1,'Sale Id shift 120',0.00,0.00,0.00,2412.91,0.00,'2023-02-07 14:57:19','',''),(525,'8','284','2',1,'Sale Id shift 120',0.00,0.00,0.00,2585.46,0.00,'2023-02-07 14:57:19','',''),(526,'8','284',NULL,1,'Sale Id shift 120',1921799.02,0.00,0.00,0.00,0.00,'2023-02-07 14:57:19','',''),(527,'8','284','1',1,'Sale Id shift 121',0.00,0.00,0.00,2040.70,0.00,'2023-02-07 15:10:18','',''),(528,'8','284','2',1,'Sale Id shift 121',0.00,0.00,0.00,1909.50,0.00,'2023-02-07 15:10:18','',''),(529,'8','284','2',1,'Sale Id shift 121',0.00,0.00,0.00,1888.96,0.00,'2023-02-07 15:10:18','',''),(530,'8','284',NULL,1,'Sale Id shift 121',1973636.08,0.00,0.00,0.00,0.00,'2023-02-07 15:10:18','',''),(531,'8','284','1',1,'Sale Id shift 122',0.00,0.00,0.00,2490.34,0.00,'2023-02-07 15:16:50','',''),(532,'8','284','2',1,'Sale Id shift 122',0.00,0.00,0.00,2205.39,0.00,'2023-02-07 15:16:50','',''),(533,'8','284','2',1,'Sale Id shift 122',0.00,0.00,0.00,1442.74,0.00,'2023-02-07 15:16:50','',''),(534,'8','284',NULL,1,'Sale Id shift 122',2074802.86,0.00,0.00,0.00,0.00,'2023-02-07 15:16:50','',''),(535,'8','284','1',1,'Sale Id shift 123',0.00,0.00,0.00,612.75,0.00,'2023-02-07 15:22:47','',''),(536,'8','284','2',1,'Sale Id shift 123',0.00,0.00,0.00,895.72,0.00,'2023-02-07 15:22:47','',''),(537,'8','284','2',1,'Sale Id shift 123',0.00,0.00,0.00,1010.53,0.00,'2023-02-07 15:22:47','',''),(538,'8','284',NULL,1,'Sale Id shift 123',851422.00,0.00,0.00,0.00,0.00,'2023-02-07 15:22:47','',''),(539,'8','284',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,32900.00,0.00,'2023-02-07 15:33:10','',''),(540,'8','284','2',1,'Received from bridging 45',0.00,0.00,32900.00,0.00,0.00,'2023-02-07 15:33:10','',''),(541,'8','284','1',1,'Sale Id shift 124',0.00,0.00,0.00,874.77,0.00,'2023-02-07 15:37:15','',''),(542,'8','284','2',1,'Sale Id shift 124',0.00,0.00,0.00,664.94,0.00,'2023-02-07 15:37:15','',''),(543,'8','284',NULL,1,'Sale Id shift 124',520421.98,0.00,0.00,0.00,0.00,'2023-02-07 15:37:15','',''),(544,'8','284','2',1,'Sale Id shift 127',0.00,0.00,0.00,1524.63,0.00,'2023-02-07 15:57:27','',''),(545,'8','284','2',1,'Sale Id shift 127',0.00,0.00,0.00,1213.94,0.00,'2023-02-07 15:57:27','',''),(546,'8','284',NULL,1,'Sale Id shift 127',925636.66,0.00,0.00,0.00,0.00,'2023-02-07 15:57:27','',''),(547,'8','284','2',1,'Sale Id shift 129',0.00,0.00,0.00,1393.30,0.00,'2023-02-08 09:48:19','',''),(548,'8','284','2',1,'Sale Id shift 129',0.00,0.00,0.00,1501.11,0.00,'2023-02-08 09:48:19','',''),(549,'8','284',NULL,1,'Sale Id shift 129',978310.58,0.00,0.00,0.00,0.00,'2023-02-08 09:48:19','',''),(550,'8','284','2',1,'Sale Id shift 130',0.00,0.00,0.00,2001.67,0.00,'2023-02-08 10:05:50','',''),(551,'8','284','2',1,'Sale Id shift 130',0.00,0.00,0.00,1789.26,0.00,'2023-02-08 10:05:50','',''),(552,'8','284',NULL,1,'Sale Id shift 130',1281334.34,0.00,0.00,0.00,0.00,'2023-02-08 10:05:50','',''),(553,'8','284','2',1,'Sale Id shift 131',0.00,0.00,0.00,1693.81,0.00,'2023-02-11 09:36:35','',''),(554,'8','284','2',1,'Sale Id shift 131',0.00,0.00,0.00,1624.05,0.00,'2023-02-11 09:36:35','',''),(555,'8','284',NULL,1,'Sale Id shift 131',1121436.68,0.00,0.00,0.00,0.00,'2023-02-11 09:36:35','',''),(556,'8','284','2',1,'Sale Id shift 132',0.00,0.00,0.00,2195.58,0.00,'2023-02-11 09:44:36','',''),(557,'8','284','2',1,'Sale Id shift 132',0.00,0.00,0.00,1753.61,0.00,'2023-02-11 09:44:36','',''),(558,'8','284',NULL,1,'Sale Id shift 132',1334826.22,0.00,0.00,0.00,0.00,'2023-02-11 09:44:36','',''),(559,'8','284','2',1,'Sale Id shift 133',0.00,0.00,0.00,1842.79,0.00,'2023-02-11 09:52:37','',''),(560,'8','284','2',1,'Sale Id shift 133',0.00,0.00,0.00,1628.56,0.00,'2023-02-11 09:52:37','',''),(561,'8','284',NULL,1,'Sale Id shift 133',1173316.30,0.00,0.00,0.00,0.00,'2023-02-11 09:52:37','',''),(562,'8','284','2',1,'Sale Id shift 134',0.00,0.00,0.00,3633.20,0.00,'2023-02-11 10:03:26','',''),(563,'8','284','2',1,'Sale Id shift 134',0.00,0.00,0.00,4002.82,0.00,'2023-02-11 10:03:26','',''),(564,'8','284',NULL,1,'Sale Id shift 134',2580974.76,0.00,0.00,0.00,0.00,'2023-02-11 10:03:26','',''),(565,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,10953750.00,31750.00,0.00,0.00,'2023-02-16 13:42:45','',''),(566,'8','284',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,31750.00,0.00,'2023-02-17 23:41:44','',''),(567,'8','284','2',1,'Received from bridging 46',0.00,0.00,31750.00,0.00,0.00,'2023-02-17 23:41:44','',''),(568,'8','284','2',1,'Sale Id shift 135',0.00,0.00,0.00,2478.08,0.00,'2023-02-18 09:05:42','',''),(569,'8','284','2',1,'Sale Id shift 135',0.00,0.00,0.00,2569.07,0.00,'2023-02-18 09:05:42','',''),(570,'8','284',NULL,1,'Sale Id shift 135',1705936.70,0.00,0.00,0.00,0.00,'2023-02-18 09:05:42','',''),(571,'8','284','2',1,'Sale Id shift 136',0.00,0.00,0.00,226.22,0.00,'2023-02-18 09:08:52','',''),(572,'8','284',NULL,1,'Sale Id shift 136',78045.90,0.00,0.00,0.00,0.00,'2023-02-18 09:08:52','',''),(573,'8','284','2',1,'Sale Id shift 137',0.00,0.00,0.00,3068.22,0.00,'2023-02-20 19:44:06','',''),(574,'8','284','2',1,'Sale Id shift 137',0.00,0.00,0.00,2414.63,0.00,'2023-02-20 19:44:06','',''),(575,'8','284',NULL,1,'Sale Id shift 137',1891583.25,0.00,0.00,0.00,0.00,'2023-02-20 19:44:06','',''),(576,'8','284','2',1,'Sale Id shift 138',0.00,0.00,0.00,5406.52,0.00,'2023-02-20 20:17:04','',''),(577,'8','284','2',1,'Sale Id shift 138',0.00,0.00,0.00,6057.96,0.00,'2023-02-20 20:17:04','',''),(578,'8','284',NULL,1,'Sale Id shift 138',3955245.60,0.00,0.00,0.00,0.00,'2023-02-20 20:17:04','',''),(579,'8','284','2',1,'Sale Id shift 139',0.00,0.00,0.00,2868.89,0.00,'2023-02-20 20:42:42','',''),(580,'8','284','2',1,'Sale Id shift 139',0.00,0.00,0.00,2198.72,0.00,'2023-02-20 20:42:42','',''),(581,'8','284',NULL,1,'Sale Id shift 139',1748325.45,0.00,0.00,0.00,0.00,'2023-02-20 20:42:42','',''),(582,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,15164000.00,44600.00,0.00,0.00,'2023-02-20 22:31:08','',''),(583,'8','284','2',1,'Sale Id shift 140',0.00,0.00,0.00,2830.59,0.00,'2023-02-21 20:22:42','',''),(584,'8','284','2',1,'Sale Id shift 140',0.00,0.00,0.00,2258.98,0.00,'2023-02-21 20:22:42','',''),(585,'8','284',NULL,1,'Sale Id shift 140',1755901.65,0.00,0.00,0.00,0.00,'2023-02-21 20:22:42','',''),(586,'8','284',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,15000.00,0.00,'2023-02-23 23:29:34','',''),(587,'8','284','1',1,'Received from bridging 47',0.00,0.00,15000.00,0.00,0.00,'2023-02-23 23:29:34','',''),(588,'8','284',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,29600.00,0.00,'2023-02-23 23:29:53','',''),(589,'8','284','2',1,'Received from bridging 48',0.00,0.00,29600.00,0.00,0.00,'2023-02-23 23:29:53','',''),(590,'8','284','2',1,'Sale Id shift 141',0.00,0.00,0.00,2538.02,0.00,'2023-02-23 23:39:55','',''),(591,'8','284','2',1,'Sale Id shift 141',0.00,0.00,0.00,2295.73,0.00,'2023-02-23 23:39:55','',''),(592,'8','284',NULL,1,'Sale Id shift 141',1643475.00,0.00,0.00,0.00,0.00,'2023-02-23 23:39:55','',''),(593,'8','284','1',1,'Sale Id shift 142',0.00,0.00,0.00,1665.88,0.00,'2023-02-23 23:51:42','',''),(594,'8','284','2',1,'Sale Id shift 142',0.00,0.00,0.00,2157.51,0.00,'2023-02-23 23:51:42','',''),(595,'8','284',NULL,1,'Sale Id shift 142',1299952.60,0.00,0.00,0.00,0.00,'2023-02-23 23:51:42','',''),(596,'8','284','1',1,'Sale Id shift 143',0.00,0.00,0.00,1344.78,0.00,'2023-02-23 23:58:23','',''),(597,'8','284','2',1,'Sale Id shift 143',0.00,0.00,0.00,1675.16,0.00,'2023-02-23 23:58:23','',''),(598,'8','284',NULL,1,'Sale Id shift 143',1026779.60,0.00,0.00,0.00,0.00,'2023-02-23 23:58:23','',''),(599,'8','284','1',1,'Sale Id shift 144',0.00,0.00,0.00,3941.85,0.00,'2023-02-24 00:06:19','',''),(600,'8','284','2',1,'Sale Id shift 144',0.00,0.00,0.00,2427.90,0.00,'2023-02-24 00:06:19','',''),(601,'8','284',NULL,1,'Sale Id shift 144',2165715.00,0.00,0.00,0.00,0.00,'2023-02-24 00:06:19','',''),(602,'8','284','1',1,'Sale Id shift 145',0.00,0.00,0.00,1365.73,0.00,'2023-02-24 00:12:16','',''),(603,'8','284','2',1,'Sale Id shift 145',0.00,0.00,0.00,1521.20,0.00,'2023-02-24 00:12:16','',''),(604,'8','284',NULL,1,'Sale Id shift 145',981556.20,0.00,0.00,0.00,0.00,'2023-02-24 00:12:16','',''),(605,'8','284','1',1,'Sale Id shift 146',0.00,0.00,0.00,2155.55,0.00,'2023-02-24 00:19:27','',''),(606,'8','284','2',1,'Sale Id shift 146',0.00,0.00,0.00,1468.11,0.00,'2023-02-24 00:19:27','',''),(607,'8','284',NULL,1,'Sale Id shift 146',1232044.40,0.00,0.00,0.00,0.00,'2023-02-24 00:19:27','',''),(608,'8','284','1',1,'Sale Id shift 147',0.00,0.00,0.00,1688.92,0.00,'2023-02-24 23:19:32','',''),(609,'8','284','2',1,'Sale Id shift 147',0.00,0.00,0.00,2109.91,0.00,'2023-02-24 23:19:32','',''),(610,'8','284',NULL,1,'Sale Id shift 147',1291602.20,0.00,0.00,0.00,0.00,'2023-02-24 23:19:32','',''),(611,'8','284','1',1,'Sale Id shift 148',0.00,0.00,0.00,1854.29,0.00,'2023-02-27 10:55:47','',''),(612,'8','284','2',1,'Sale Id shift 148',0.00,0.00,0.00,1580.70,0.00,'2023-02-27 10:55:47','',''),(613,'8','284',NULL,1,'Sale Id shift 148',1167896.60,0.00,0.00,0.00,0.00,'2023-02-27 10:55:47','',''),(614,'8','284','1',1,'Sale Id shift 149',0.00,0.00,0.00,1746.94,0.00,'2023-02-27 11:03:57','',''),(615,'8','284','2',1,'Sale Id shift 149',0.00,0.00,0.00,1036.75,0.00,'2023-02-27 11:03:57','',''),(616,'8','284',NULL,1,'Sale Id shift 149',946454.60,0.00,0.00,0.00,0.00,'2023-02-27 11:03:57','',''),(617,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,10332000.00,32800.00,0.00,0.00,'2023-03-01 14:38:11','',''),(618,'8','284',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,15900.00,0.00,'2023-03-01 23:20:38','',''),(619,'8','284','1',1,'Received from bridging 49',0.00,0.00,15900.00,0.00,0.00,'2023-03-01 23:20:38','',''),(620,'8','284',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,16900.00,0.00,'2023-03-01 23:21:07','',''),(621,'8','284','2',1,'Received from bridging 50',0.00,0.00,16900.00,0.00,0.00,'2023-03-01 23:21:07','',''),(622,'8','284','1',1,'Sale Id shift 150',0.00,0.00,0.00,3186.55,0.00,'2023-03-02 11:10:53','',''),(623,'8','284','2',1,'Sale Id shift 150',0.00,0.00,0.00,1226.33,0.00,'2023-03-02 11:10:53','',''),(624,'8','284','2',1,'Sale Id shift 150',0.00,0.00,0.00,3654.04,0.00,'2023-03-02 11:10:53','',''),(625,'8','284',NULL,1,'Sale Id shift 150',2742752.80,0.00,0.00,0.00,0.00,'2023-03-02 11:10:53','',''),(626,'8','284','1',1,'Sale Id shift 151',0.00,0.00,0.00,3296.36,0.00,'2023-03-02 11:16:54','',''),(627,'8','284','2',1,'Sale Id shift 151',0.00,0.00,0.00,1344.61,0.00,'2023-03-02 11:16:54','',''),(628,'8','284','2',1,'Sale Id shift 151',0.00,0.00,0.00,1019.19,0.00,'2023-03-02 11:16:54','',''),(629,'8','284',NULL,1,'Sale Id shift 151',1782950.40,0.00,0.00,0.00,0.00,'2023-03-02 11:16:54','',''),(630,'8','284','1',1,'Sale Id shift 152',0.00,0.00,0.00,2693.52,0.00,'2023-03-02 11:23:13','',''),(631,'8','284','2',1,'Sale Id shift 152',0.00,0.00,0.00,892.00,0.00,'2023-03-02 11:23:14','',''),(632,'8','284','2',1,'Sale Id shift 152',0.00,0.00,0.00,655.92,0.00,'2023-03-02 11:23:14','',''),(633,'8','284',NULL,1,'Sale Id shift 152',1336053.60,0.00,0.00,0.00,0.00,'2023-03-02 11:23:14','',''),(634,'8','284','1',1,'Sale Id shift 153',0.00,0.00,0.00,1407.26,0.00,'2023-03-04 09:22:46','',''),(635,'8','284','2',1,'Sale Id shift 153',0.00,0.00,0.00,1683.44,0.00,'2023-03-04 09:22:46','',''),(636,'8','284','2',1,'Sale Id shift 153',0.00,0.00,0.00,425.83,0.00,'2023-03-04 09:22:46','',''),(637,'8','284',NULL,1,'Sale Id shift 153',1107706.95,0.00,0.00,0.00,0.00,'2023-03-04 09:22:46','',''),(638,'8','284','2',1,'Sale Id shift 154',0.00,0.00,0.00,1569.99,0.00,'2023-03-06 12:19:55','',''),(639,'8','284','2',1,'Sale Id shift 154',0.00,0.00,0.00,1536.37,0.00,'2023-03-06 12:19:55','',''),(640,'8','284',NULL,1,'Sale Id shift 154',978503.40,0.00,0.00,0.00,0.00,'2023-03-06 12:19:55','',''),(641,'8','284','2',1,'Sale Id shift 155',0.00,0.00,0.00,1504.28,0.00,'2023-03-06 12:24:03','',''),(642,'8','284','2',1,'Sale Id shift 155',0.00,0.00,0.00,2497.54,0.00,'2023-03-06 12:24:03','',''),(643,'8','284',NULL,1,'Sale Id shift 155',1260573.30,0.00,0.00,0.00,0.00,'2023-03-06 12:24:03','',''),(644,'8','284','2',1,'Sale Id shift 156',0.00,0.00,0.00,1642.39,0.00,'2023-03-08 08:50:39','',''),(645,'8','284','2',1,'Sale Id shift 156',0.00,0.00,0.00,2555.26,0.00,'2023-03-08 08:50:39','',''),(646,'8','284',NULL,1,'Sale Id shift 156',1322259.75,0.00,0.00,0.00,0.00,'2023-03-08 08:50:39','',''),(647,'8','284','1',1,'Sale Id shift 157',0.00,0.00,0.00,3631.55,0.00,'2023-03-08 09:02:12','',''),(648,'8','284','2',1,'Sale Id shift 157',0.00,0.00,0.00,2484.99,0.00,'2023-03-08 09:02:12','',''),(649,'8','284','2',1,'Sale Id shift 157',0.00,0.00,0.00,3828.48,0.00,'2023-03-08 09:02:12','',''),(650,'8','284',NULL,1,'Sale Id shift 157',3132681.30,0.00,0.00,0.00,0.00,'2023-03-08 09:02:12','',''),(651,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,5040000.00,16800.00,0.00,0.00,'2023-03-13 12:18:42','',''),(652,'8','284',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,16800.00,0.00,'2023-03-15 14:37:15','',''),(653,'8','284','2',1,'Received from bridging 51',0.00,0.00,16800.00,0.00,0.00,'2023-03-15 14:37:15','',''),(654,'8','284','1',1,'Sale Id shift 158',0.00,0.00,0.00,640.72,0.00,'2023-03-15 16:39:45','',''),(655,'8','284','2',1,'Sale Id shift 158',0.00,0.00,0.00,2319.38,0.00,'2023-03-15 16:39:45','',''),(656,'8','284','2',1,'Sale Id shift 158',0.00,0.00,0.00,1622.24,0.00,'2023-03-15 16:39:45','',''),(657,'8','284',NULL,1,'Sale Id shift 158',1374702.00,0.00,0.00,0.00,0.00,'2023-03-15 16:39:45','',''),(658,'8','284','2',1,'Sale Id shift 159',0.00,0.00,0.00,1781.57,0.00,'2023-03-15 16:44:12','',''),(659,'8','284','2',1,'Sale Id shift 159',0.00,0.00,0.00,3370.68,0.00,'2023-03-15 16:44:12','',''),(660,'8','284',NULL,1,'Sale Id shift 159',1545675.00,0.00,0.00,0.00,0.00,'2023-03-15 16:44:12','',''),(661,'8','284','2',1,'Sale Id shift 160',0.00,0.00,0.00,2462.83,0.00,'2023-03-15 16:52:43','',''),(662,'8','284','2',1,'Sale Id shift 160',0.00,0.00,0.00,4155.88,0.00,'2023-03-15 16:52:43','',''),(663,'8','284',NULL,1,'Sale Id shift 160',1985613.00,0.00,0.00,0.00,0.00,'2023-03-15 16:52:43','',''),(664,'8','284',NULL,1,'Purchased from Lausu Energy Resources',0.00,14835000.00,49450.00,0.00,0.00,'2023-03-19 19:34:46','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'8','284',2,0.00,'2023-03-15 16:54:57'),(2,'8','284',1,58615.51,'2023-03-19 19:34:46');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'8','284',1,'Sale Id shift 2',0.00,971199.46,187.00,971199.46,0.00,'2022-09-08 20:02:25'),(2,'8','284',1,'Sale Id shift 3',0.00,975966.09,0.00,0.00,-975966.09,'2022-09-08 20:09:36'),(3,'8','284',1,'Sale Id shift 4',0.00,863954.96,187.00,863954.96,0.00,'2022-09-08 20:35:40'),(4,'8','284',1,'Sale Id shift 5',0.00,1500368.32,187.00,1500368.32,0.00,'2022-09-09 14:52:24'),(5,'8','284',1,'Sale Id shift 6',0.00,1158249.95,187.00,1158249.95,0.00,'2022-09-11 12:43:46'),(6,'8','284',1,'Sale Id shift 7',0.00,1250863.57,187.00,1250863.57,0.00,'2022-09-11 13:44:34'),(7,'8','284',1,'Sale Id shift 8',0.00,927284.38,187.00,927284.38,0.00,'2022-09-12 13:52:53'),(8,'8','284',1,'Sale Id shift 9',0.00,1790755.01,187.00,1790755.01,0.00,'2022-09-14 09:48:59'),(9,'8','284',1,'Sale Id shift 10',0.00,862460.83,187.00,862460.83,0.00,'2022-09-14 13:26:17'),(10,'8','284',1,'Sale Id shift 11',0.00,1639930.16,187.00,1639930.16,0.00,'2022-09-16 09:04:30'),(11,'8','284',1,'Sale Id shift 12',0.00,1314271.53,187.00,1314271.53,0.00,'2022-09-17 13:27:53'),(12,'8','284',1,'Sale Id shift 13',0.00,1147443.22,187.00,1147443.22,0.00,'2022-09-17 13:41:46'),(13,'8','284',1,'Sale Id shift 16',0.00,1736835.43,187.00,1736835.43,0.00,'2022-09-20 13:01:51'),(14,'8','284',1,'Sale Id shift 17',0.00,1416562.40,187.00,1416562.40,0.00,'2022-09-20 13:35:29'),(15,'8','284',1,'Sale Id shift 18',0.00,2161529.26,187.00,2161529.26,0.00,'2022-09-21 14:39:08'),(16,'8','284',1,'Sale Id shift 19',0.00,1980524.48,187.00,1980524.48,0.00,'2022-09-21 14:54:04'),(17,'8','284',1,'Sale Id shift 20',0.00,1050427.62,187.00,1050427.62,0.00,'2022-09-23 20:06:53'),(18,'8','284',1,'Sale Id shift 22',0.00,1670538.32,187.00,1670538.32,0.00,'2022-09-28 14:31:17'),(19,'8','284',1,'Sale Id shift 23',0.00,1206275.29,187.00,1206275.29,0.00,'2022-09-28 14:37:50'),(20,'8','284',1,'Sale Id shift 24',0.00,1219391.47,187.00,1219391.47,0.00,'2022-09-28 15:54:05'),(21,'8','284',1,'Sale Id shift 25',0.00,675795.56,187.00,675795.56,0.00,'2022-09-28 16:00:14'),(22,'8','284',1,'Sale Id shift 26',0.00,2353785.83,187.00,2353785.83,0.00,'2022-09-28 23:03:30'),(23,'8','284',1,'Sale Id shift 27',0.00,1418991.53,187.00,1418991.53,0.00,'2022-09-30 00:12:41'),(24,'8','284',1,'Sale Id shift 28',0.00,1530148.07,187.00,1530148.07,0.00,'2022-09-30 11:15:37'),(25,'8','284',1,'Sale Id shift 29',0.00,1662495.45,187.00,1662495.45,0.00,'2022-10-01 21:24:22'),(26,'8','284',1,'Sale Id shift 30',0.00,1238209.28,187.00,1238209.28,0.00,'2022-10-07 15:27:07'),(27,'8','284',1,'Sale Id shift 31',0.00,1074487.04,187.00,1074487.04,0.00,'2022-10-07 15:38:45'),(28,'8','284',1,'Sale Id shift 32',0.00,2746311.92,187.00,2746311.92,0.00,'2022-10-07 15:48:39'),(29,'8','284',1,'Sale Id shift 33',0.00,1677008.52,187.00,1677008.52,0.00,'2022-10-07 15:53:08'),(30,'8','284',1,'Sale Id shift 34',0.00,1845373.97,187.00,1845373.97,0.00,'2022-10-09 23:07:22'),(31,'8','284',1,'Sale Id shift 35',0.00,1987410.75,195.00,1987410.75,0.00,'2022-10-10 06:37:39'),(32,'8','284',1,'Sale Id shift 36',0.00,2774867.55,195.00,2774867.55,0.00,'2022-10-10 14:58:04'),(33,'8','284',1,'Sale Id shift 37',0.00,4180320.30,195.00,4180320.30,0.00,'2022-10-12 00:11:09'),(34,'8','284',1,'Sale Id shift 38',0.00,2500268.55,206.00,2641309.34,141040.79,'2022-10-14 08:47:33'),(35,'8','284',1,'Sale Id shift 39',0.00,817440.00,220.00,922240.00,104800.00,'2022-10-14 08:56:57'),(36,'8','284',1,'Sale Id shift 40',0.00,2707137.00,225.00,2707137.00,0.00,'2022-10-16 10:48:32'),(37,'8','284',1,'Sale Id shift 41',0.00,2266368.75,225.00,2266368.75,0.00,'2022-10-16 11:10:17'),(38,'8','284',1,'Sale Id shift 42',0.00,3362712.75,225.00,3362712.75,0.00,'2022-10-19 15:09:13'),(39,'8','284',1,'Sale Id shift 43',0.00,2769095.25,225.00,2769095.25,0.00,'2022-10-21 08:25:03'),(40,'8','284',1,'Sale Id shift 44',0.00,460000.00,225.00,450000.00,-10000.00,'2022-10-21 08:30:09'),(41,'8','284',1,'Sale Id shift 45',0.00,3208966.90,230.00,3208966.90,0.00,'2022-10-21 08:59:08'),(42,'8','284',1,'Sale Id shift 47',0.00,871049.10,235.00,889984.95,18935.85,'2022-10-24 15:41:41'),(43,'8','284',1,'Sale Id shift 48',0.00,3738753.65,235.00,3738753.65,0.00,'2022-10-27 11:04:17'),(44,'8','284',1,'Sale Id shift 49',0.00,187532.35,235.00,187532.35,0.00,'2022-10-27 11:07:27'),(45,'8','284',1,'Sale Id shift 50',0.00,1576530.00,250.00,1576530.00,0.00,'2022-11-05 00:01:08'),(46,'8','284',1,'Sale Id shift 51',0.00,2080947.50,255.00,2122566.45,41618.95,'2022-11-06 07:10:34'),(47,'8','284',1,'Sale Id shift 52',0.00,1790872.50,255.00,1826689.95,35817.45,'2022-11-06 19:20:06'),(48,'8','284',1,'Sale Id shift 53',0.00,1228497.50,255.00,1253067.45,24569.95,'2022-11-07 11:23:04'),(49,'8','284',1,'Sale Id shift 54',0.00,458247.50,255.00,467412.45,9164.95,'2022-11-07 11:29:47'),(50,'8','284',1,'Sale Id shift 55',0.00,1120200.00,250.00,1120200.00,0.00,'2022-11-08 23:20:17'),(51,'8','284',1,'Sale Id shift 56',0.00,3284882.50,250.00,3284882.50,0.00,'2022-11-09 12:01:24'),(52,'8','284',1,'Sale Id shift 57',0.00,2456710.00,250.00,2456710.00,0.00,'2022-11-09 12:54:11'),(53,'8','284',1,'Sale Id shift 58',0.00,2511200.00,250.00,2511200.00,0.00,'2022-11-11 11:58:34'),(54,'8','284',1,'Sale Id shift 59',0.00,3085130.00,250.00,3085130.00,0.00,'2022-11-12 06:34:44'),(55,'8','284',1,'Sale Id shift 60',0.00,3076112.50,250.00,3076112.50,0.00,'2022-11-14 10:42:58'),(56,'8','284',1,'Sale Id shift 61',0.00,1429910.00,250.00,1429910.00,0.00,'2022-11-14 10:48:42'),(57,'8','284',1,'Sale Id shift 62',0.00,2629292.50,255.00,2681878.35,52585.85,'2022-11-14 10:55:06'),(58,'8','284',1,'Sale Id shift 63',0.00,4367045.00,255.00,4454385.90,87340.90,'2022-11-15 22:52:33'),(59,'8','284',1,'Sale Id shift 64',0.00,1245203.25,255.00,1245203.25,0.00,'2022-11-16 09:52:29'),(60,'8','284',1,'Sale Id shift 65',0.00,3174479.70,255.00,3174479.70,0.00,'2022-11-18 09:02:10'),(61,'8','284',1,'Sale Id shift 66',0.00,2270540.40,255.00,2270540.40,0.00,'2022-11-19 21:52:24'),(62,'8','284',1,'Sale Id shift 67',0.00,1791754.95,255.00,1791754.95,0.00,'2022-11-20 08:47:47'),(63,'8','284',1,'Sale Id shift 68',0.00,1812279.90,255.00,1812279.90,0.00,'2022-11-22 08:07:07'),(64,'8','284',1,'Sale Id shift 69',0.00,2297465.85,255.00,2297465.85,0.00,'2022-11-22 08:14:44'),(65,'8','284',1,'Sale Id shift 70',0.00,510000.00,255.00,510000.00,0.00,'2022-11-24 13:21:50'),(66,'8','284',1,'Sale Id shift 71',0.00,1814355.75,257.00,1814355.75,0.00,'2022-11-24 13:27:22'),(67,'8','284',1,'Sale Id shift 72',0.00,2082306.52,257.00,2082306.52,0.00,'2022-11-24 13:32:42'),(68,'8','284',1,'Sale Id shift 73',0.00,2281838.75,257.00,2281838.75,0.00,'2022-11-27 14:32:32'),(69,'8','284',1,'Sale Id shift 74',0.00,2239086.80,257.00,2239086.80,0.00,'2022-11-27 14:45:31'),(70,'8','284',1,'Sale Id shift 75',0.00,2010297.69,260.00,2033764.20,23466.51,'2022-11-27 14:53:54'),(71,'8','284',1,'Sale Id shift 76',0.00,2547643.57,260.00,2577382.60,29739.03,'2022-12-01 00:15:12'),(72,'8','284',1,'Sale Id shift 77',0.00,3211245.84,260.00,3248731.20,37485.36,'2022-12-01 00:26:36'),(73,'8','284',1,'Sale Id shift 78',0.00,771300.69,260.00,780304.20,9003.51,'2022-12-01 00:32:23'),(74,'8','284',1,'Sale Id shift 79',0.00,3702816.00,260.00,3702816.00,0.00,'2022-12-03 12:33:24'),(75,'8','284',1,'Sale Id shift 80',0.00,1044033.30,260.00,1005365.40,-38667.90,'2022-12-06 12:42:20'),(76,'8','284',1,'Sale Id shift 81',0.00,1326804.30,260.00,1277663.40,-49140.90,'2022-12-07 18:17:50'),(77,'8','284',1,'Sale Id shift 82',0.00,2199506.40,270.00,2199506.40,0.00,'2022-12-08 12:34:03'),(78,'8','284',1,'Sale Id shift 83',0.00,4327708.50,277.00,4439908.35,112199.85,'2022-12-08 12:38:55'),(79,'8','284',1,'Sale Id shift 84',0.00,1020384.00,277.00,1046838.40,26454.40,'2022-12-11 16:42:16'),(80,'8','284',1,'Sale Id shift 85',0.00,1954937.70,310.00,2244558.10,289620.40,'2022-12-14 07:51:28'),(81,'8','284',1,'Sale Id shift 86',0.00,4216037.20,310.00,4216037.20,0.00,'2022-12-14 07:59:12'),(82,'8','284',1,'Sale Id shift 87',0.00,2763417.50,310.00,2763417.50,0.00,'2022-12-14 08:08:57'),(83,'8','284',1,'Sale Id shift 88',0.00,3324337.70,310.00,3324337.70,0.00,'2022-12-19 08:36:10'),(84,'8','284',1,'Sale Id shift 89',0.00,1257189.50,310.00,1257189.50,0.00,'2022-12-19 08:41:24'),(85,'8','284',1,'Sale Id shift 90',0.00,2450568.60,310.00,2450568.60,0.00,'2022-12-19 08:50:02'),(86,'8','284',1,'Sale Id shift 91',0.00,2762199.20,310.00,2762199.20,0.00,'2022-12-19 08:59:57'),(87,'8','284',1,'Sale Id shift 92',0.00,2900821.90,310.00,2900821.90,0.00,'2022-12-19 09:19:37'),(88,'8','284',1,'Sale Id shift 93',0.00,1771814.30,310.00,1771814.30,0.00,'2022-12-20 08:07:47'),(89,'8','284',1,'Sale Id shift 94',0.00,2274935.00,310.00,2274935.00,0.00,'2022-12-22 09:28:53'),(90,'8','284',1,'Sale Id shift 95',0.00,2659651.20,310.00,2659651.20,0.00,'2022-12-22 09:34:07'),(91,'8','284',1,'Sale Id shift 96',0.00,2325576.60,310.00,2325576.60,0.00,'2022-12-25 09:29:44'),(92,'8','284',1,'Sale Id shift 97',0.00,1639053.70,310.00,1639053.70,0.00,'2022-12-25 09:35:39'),(93,'8','284',1,'Sale Id shift 98',0.00,1005522.20,310.00,1005522.20,0.00,'2022-12-30 12:10:46'),(94,'8','284',1,'Sale Id shift 99',0.00,929569.10,310.00,929569.10,0.00,'2022-12-30 12:22:44'),(95,'8','284',1,'Sale Id shift 100',0.00,1433622.90,310.00,1433622.90,0.00,'2022-12-30 12:28:27'),(96,'8','284',1,'Sale Id shift 101',0.00,807122.20,310.00,807122.20,0.00,'2022-12-30 12:38:51'),(97,'8','284',1,'Sale Id shift 102',0.00,1054341.00,310.00,1054341.00,0.00,'2022-12-30 12:42:55'),(98,'8','284',1,'Sale Id shift 103',0.00,951817.96,310.00,990146.20,38328.24,'2023-01-07 11:03:45'),(99,'8','284',1,'Sale Id shift 104',0.00,1062465.36,298.00,1062465.36,0.00,'2023-01-07 11:08:27'),(100,'8','284',1,'Sale Id shift 105',0.00,1438651.62,298.00,1438651.62,0.00,'2023-01-07 11:13:33'),(101,'8','284',1,'Sale Id shift 107',0.00,1379412.20,298.00,1379412.20,0.00,'2023-01-09 22:18:23'),(102,'8','284',1,'Sale Id shift 108',0.00,1515523.70,298.00,1515523.70,0.00,'2023-01-09 22:25:13'),(103,'8','284',1,'Sale Id shift 109',0.00,1283506.86,298.00,1283506.86,0.00,'2023-01-09 22:31:48'),(104,'8','284',1,'Sale Id shift 111',0.00,3005601.18,298.00,3005601.18,0.00,'2023-01-12 15:51:54'),(105,'8','284',1,'Sale Id shift 112',0.00,1283572.42,298.00,1283572.42,0.00,'2023-01-12 15:57:36'),(106,'8','284',1,'Sale Id shift 113',0.00,1568284.60,298.00,1568284.60,0.00,'2023-01-14 21:22:45'),(107,'8','284',1,'Sale Id shift 114',0.00,1459806.64,298.00,1459806.64,0.00,'2023-01-14 21:30:01'),(108,'8','284',1,'Sale Id shift 115',0.00,509618.74,298.00,509618.74,0.00,'2023-01-20 12:43:12'),(109,'8','284',1,'Sale Id shift 116',0.00,2359271.96,298.00,2359271.96,0.00,'2023-01-20 12:50:24'),(110,'8','284',1,'Sale Id shift 117',0.00,2457862.28,298.00,2457862.28,0.00,'2023-01-20 12:57:12'),(111,'8','284',1,'Sale Id shift 118',0.00,1420881.88,300.00,1430418.00,9536.12,'2023-01-20 13:02:25'),(112,'8','284',1,'Sale Id shift 119',0.00,1562786.50,300.00,1573275.00,10488.50,'2023-01-20 13:09:17'),(113,'8','284',1,'Sale Id shift 120',0.00,1921799.02,300.00,1934697.00,12897.98,'2023-02-07 14:57:19'),(114,'8','284',1,'Sale Id shift 121',0.00,1973636.08,300.00,1751748.00,-221888.08,'2023-02-07 15:10:18'),(115,'8','284',1,'Sale Id shift 122',0.00,2074802.86,300.00,1841541.00,-233261.86,'2023-02-07 15:16:50'),(116,'8','284',1,'Sale Id shift 123',0.00,851422.00,300.00,755700.00,-95722.00,'2023-02-07 15:22:47'),(117,'8','284',1,'Sale Id shift 124',0.00,520421.98,300.00,461913.00,-58508.98,'2023-02-07 15:37:15'),(118,'8','284',1,'Sale Id shift 127',0.00,925636.66,338.00,925636.66,0.00,'2023-02-07 15:57:27'),(119,'8','284',1,'Sale Id shift 129',0.00,978310.58,345.00,998571.45,20260.87,'2023-02-08 09:48:19'),(120,'8','284',1,'Sale Id shift 130',0.00,1281334.34,345.00,1307870.85,26536.51,'2023-02-08 10:05:50'),(121,'8','284',1,'Sale Id shift 131',0.00,1121436.68,345.00,1144661.70,23225.02,'2023-02-11 09:36:35'),(122,'8','284',1,'Sale Id shift 132',0.00,1334826.22,345.00,1362470.55,27644.33,'2023-02-11 09:44:36'),(123,'8','284',1,'Sale Id shift 133',0.00,1173316.30,345.00,1197615.75,24299.45,'2023-02-11 09:52:37'),(124,'8','284',1,'Sale Id shift 134',0.00,2580974.76,345.00,2634426.90,53452.14,'2023-02-11 10:03:26'),(125,'8','284',1,'Sale Id shift 135',0.00,1705936.70,345.00,1741266.75,35330.05,'2023-02-18 09:05:42'),(126,'8','284',1,'Sale Id shift 136',0.00,78045.90,345.00,78045.90,0.00,'2023-02-18 09:08:52'),(127,'8','284',1,'Sale Id shift 137',0.00,1891583.25,345.00,1891583.25,0.00,'2023-02-20 19:44:06'),(128,'8','284',1,'Sale Id shift 138',0.00,3955245.60,345.00,3955245.60,0.00,'2023-02-20 20:17:04'),(129,'8','284',1,'Sale Id shift 139',0.00,1748325.45,345.00,1748325.45,0.00,'2023-02-20 20:42:42'),(130,'8','284',1,'Sale Id shift 140',0.00,1755901.65,345.00,1755901.65,0.00,'2023-02-21 20:22:42'),(131,'8','284',1,'Sale Id shift 141',0.00,1643475.00,345.00,1667643.75,24168.75,'2023-02-23 23:39:55'),(132,'8','284',1,'Sale Id shift 142',0.00,1299952.60,340.00,1299952.60,0.00,'2023-02-23 23:51:42'),(133,'8','284',1,'Sale Id shift 143',0.00,1026779.60,340.00,1026779.60,0.00,'2023-02-23 23:58:23'),(134,'8','284',1,'Sale Id shift 144',0.00,2165715.00,340.00,2165715.00,0.00,'2023-02-24 00:06:19'),(135,'8','284',1,'Sale Id shift 145',0.00,981556.20,340.00,981556.20,0.00,'2023-02-24 00:12:16'),(136,'8','284',1,'Sale Id shift 146',0.00,1232044.40,320.00,1159571.20,-72473.20,'2023-02-24 00:19:27'),(137,'8','284',1,'Sale Id shift 147',0.00,1291602.20,320.00,1215625.60,-75976.60,'2023-02-24 23:19:32'),(138,'8','284',1,'Sale Id shift 148',0.00,1167896.60,315.00,1082021.85,-85874.75,'2023-02-27 10:55:47'),(139,'8','284',1,'Sale Id shift 149',0.00,946454.60,315.00,876862.35,-69592.25,'2023-02-27 11:03:57'),(140,'8','284',1,'Sale Id shift 150',0.00,2742752.80,315.00,2541079.80,-201673.00,'2023-03-02 11:10:53'),(141,'8','284',1,'Sale Id shift 151',0.00,1782950.40,315.00,1782950.40,0.00,'2023-03-02 11:16:54'),(142,'8','284',1,'Sale Id shift 152',0.00,1336053.60,315.00,1336053.60,0.00,'2023-03-02 11:23:14'),(143,'8','284',1,'Sale Id shift 153',0.00,1107706.95,315.00,1107706.95,0.00,'2023-03-04 09:22:46'),(144,'8','284',1,'Sale Id shift 154',0.00,978503.40,300.00,931908.00,-46595.40,'2023-03-06 12:19:55'),(145,'8','284',1,'Sale Id shift 155',0.00,1260573.30,300.00,1200546.00,-60027.30,'2023-03-06 12:24:03'),(146,'8','284',1,'Sale Id shift 156',0.00,1322259.75,300.00,1259295.00,-62964.75,'2023-03-08 08:50:39'),(147,'8','284',1,'Sale Id shift 157',0.00,3132681.30,300.00,2983506.00,-149175.30,'2023-03-08 09:02:12'),(148,'8','284',1,'Sale Id shift 158',0.00,1374702.00,300.00,1374702.00,0.00,'2023-03-15 16:39:45'),(149,'8','284',1,'Sale Id shift 159',0.00,1545675.00,300.00,1545675.00,0.00,'2023-03-15 16:44:12'),(150,'8','284',1,'Sale Id shift 160',0.00,1985613.00,300.00,1985613.00,0.00,'2023-03-15 16:52:43');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=673 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('8','284',1,'','24','3',0.00,9350000.00,'Purchase Id 2 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-07 14:00:42','',''),('8','284',2,'','supplier','1',9350000.00,0.00,'Purchase Id 2 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-07 14:00:42','',''),('8','284',3,'','24','3',0.00,9350000.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-07 14:01:12','',''),('8','284',4,'','supplier','1',9350000.00,0.00,'Purchase Id 1 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-07 14:01:12','',''),('8','284',5,'','20','2',0.00,0.00,'Sales from shift 1 on 2022-09-08 14:26:48 ','2022-09-08 14:26:48','',''),('8','284',6,'','6.1','1',0.00,0.00,'Sales from shift 1 on 2022-09-08 14:26:48 ','2022-09-08 14:26:48','',''),('8','284',7,'','20','2',971199.46,0.00,'Sales from shift 2 on 2022-09-08 20:02:25 ','2022-09-08 20:02:25','',''),('8','284',8,'','6.1','1',0.00,971199.46,'Sales from shift 2 on 2022-09-08 20:02:25 ','2022-09-08 20:02:25','',''),('8','284',9,'','20','2',0.00,0.00,'Sales from shift 3 on 2022-09-08 20:09:36 ','2022-09-08 20:09:36','',''),('8','284',10,'','6.1','1',0.00,0.00,'Sales from shift 3 on 2022-09-08 20:09:36 ','2022-09-08 20:09:36','',''),('8','284',11,'','20','2',863954.96,0.00,'Sales from shift 4 on 2022-09-08 20:35:40 ','2022-09-08 20:35:40','',''),('8','284',12,'','6.1','1',0.00,863954.96,'Sales from shift 4 on 2022-09-08 20:35:40 ','2022-09-08 20:35:40','',''),('8','284',13,'','20','2',1500368.32,0.00,'Sales from shift 5 on 2022-09-09 14:52:24 ','2022-09-09 14:52:24','',''),('8','284',14,'','6.1','1',0.00,1500368.32,'Sales from shift 5 on 2022-09-09 14:52:24 ','2022-09-09 14:52:24','',''),('8','284',15,'','20','2',1158249.95,0.00,'Sales from shift 6 on 2022-09-11 12:43:46 ','2022-09-11 12:43:46','',''),('8','284',16,'','6.1','1',0.00,1158249.95,'Sales from shift 6 on 2022-09-11 12:43:46 ','2022-09-11 12:43:46','',''),('8','284',17,'','20','2',1250863.57,0.00,'Sales from shift 7 on 2022-09-11 13:44:34 ','2022-09-11 13:44:34','',''),('8','284',18,'','6.1','1',0.00,1250863.57,'Sales from shift 7 on 2022-09-11 13:44:34 ','2022-09-11 13:44:34','',''),('8','284',19,'','20','2',927284.38,0.00,'Sales from shift 8 on 2022-09-12 13:52:53 ','2022-09-12 13:52:53','',''),('8','284',20,'','6.1','1',0.00,927284.38,'Sales from shift 8 on 2022-09-12 13:52:53 ','2022-09-12 13:52:53','',''),('8','284',21,'','2','6',1143250.00,0.00,'Payment Id 14 for invoice:005, receipt: 005 by Lausu Energy Resources','2022-09-13 16:57:03','',''),('8','284',22,'','supplier','1',0.00,1143250.00,'Payment Id 14 for invoice:005, receipt: 005 by Lausu Energy Resources','2022-09-13 16:57:03','',''),('8','284',23,'','2','6',1244310.00,0.00,'Payment Id 15 for invoice:006, receipt: 006 by Lausu Energy Resources','2022-09-13 16:57:31','',''),('8','284',24,'','supplier','1',0.00,1244310.00,'Payment Id 15 for invoice:006, receipt: 006 by Lausu Energy Resources','2022-09-13 16:57:31','',''),('8','284',25,'','2','6',924105.00,0.00,'Payment Id 16 for invoice:007, receipt: 007 by Lausu Energy Resources','2022-09-13 16:57:54','',''),('8','284',26,'','supplier','1',0.00,924105.00,'Payment Id 16 for invoice:007, receipt: 007 by Lausu Energy Resources','2022-09-13 16:57:54','',''),('8','284',27,'','2','6',1790755.00,0.00,'Payment Id 17 for invoice:08, receipt: 008 by Lausu Energy Resources','2022-09-13 16:58:13','',''),('8','284',28,'','supplier','1',0.00,1790755.00,'Payment Id 17 for invoice:08, receipt: 008 by Lausu Energy Resources','2022-09-13 16:58:13','',''),('8','284',29,'','20','2',1790755.01,0.00,'Sales from shift 9 on 2022-09-14 09:48:59 ','2022-09-14 09:48:59','',''),('8','284',30,'','6.1','1',0.00,1790755.01,'Sales from shift 9 on 2022-09-14 09:48:59 ','2022-09-14 09:48:59','',''),('8','284',31,'','20','2',862460.83,0.00,'Sales from shift 10 on 2022-09-14 13:26:17 ','2022-09-14 13:26:17','',''),('8','284',32,'','6.1','1',0.00,862460.83,'Sales from shift 10 on 2022-09-14 13:26:17 ','2022-09-14 13:26:17','',''),('8','284',33,'','2','6',509000.00,0.00,'Payment Id 13 for invoice:004, receipt: 004 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',34,'','supplier','1',0.00,509000.00,'Payment Id 13 for invoice:004, receipt: 004 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',35,'','2','6',1000000.00,0.00,'Payment Id 12 for invoice:004, receipt: 004 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',36,'','supplier','1',0.00,1000000.00,'Payment Id 12 for invoice:004, receipt: 004 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',37,'','2','6',871550.00,0.00,'Payment Id 11 for invoice:001, receipt: 001 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',38,'','supplier','1',0.00,871550.00,'Payment Id 11 for invoice:001, receipt: 001 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',39,'','2','6',966255.00,0.00,'Payment Id 6 for invoice:002, receipt: 002 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',40,'','supplier','1',0.00,966255.00,'Payment Id 6 for invoice:002, receipt: 002 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',41,'','2','6',857515.00,0.00,'Payment Id 5 for invoice:003, receipt: 003 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',42,'','supplier','1',0.00,857515.00,'Payment Id 5 for invoice:003, receipt: 003 by Lausu Energy Resources','2022-09-14 21:39:30','',''),('8','284',43,'','2','6',866175.00,0.00,'Payment Id 18 for invoice:009, receipt: 009 by Lausu Energy Resources','2022-09-14 21:44:48','',''),('8','284',44,'','supplier','1',0.00,866175.00,'Payment Id 18 for invoice:009, receipt: 009 by Lausu Energy Resources','2022-09-14 21:44:48','',''),('8','284',45,'','20','2',1639930.16,0.00,'Sales from shift 11 on 2022-09-16 09:04:30 ','2022-09-16 09:04:30','',''),('8','284',46,'','6.1','1',0.00,1639930.16,'Sales from shift 11 on 2022-09-16 09:04:30 ','2022-09-16 09:04:30','',''),('8','284',47,'','2','6',1314280.00,0.00,'Payment Id 20 for invoice:011, receipt: 011 by Lausu Energy Resources','2022-09-17 07:44:07','',''),('8','284',48,'','supplier','1',0.00,1314280.00,'Payment Id 20 for invoice:011, receipt: 011 by Lausu Energy Resources','2022-09-17 07:44:07','',''),('8','284',49,'','2','6',1639930.00,0.00,'Payment Id 19 for invoice:010, receipt: 010 by Lausu Energy Resources','2022-09-17 07:44:07','',''),('8','284',50,'','supplier','1',0.00,1639930.00,'Payment Id 19 for invoice:010, receipt: 010 by Lausu Energy Resources','2022-09-17 07:44:07','',''),('8','284',51,'','20','2',1314271.53,0.00,'Sales from shift 12 on 2022-09-17 13:27:53 ','2022-09-17 13:27:53','',''),('8','284',52,'','6.1','1',0.00,1314271.53,'Sales from shift 12 on 2022-09-17 13:27:53 ','2022-09-17 13:27:53','',''),('8','284',53,'','20','2',1147443.22,0.00,'Sales from shift 13 on 2022-09-17 13:41:46 ','2022-09-17 13:41:46','',''),('8','284',54,'','6.1','1',0.00,1147443.22,'Sales from shift 13 on 2022-09-17 13:41:46 ','2022-09-17 13:41:46','',''),('8','284',55,'','24','3',0.00,9163000.00,'Purchase Id 3 for 49,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-19 12:29:52','',''),('8','284',56,'','supplier','1',9163000.00,0.00,'Purchase Id 3 for 49,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-19 12:29:52','',''),('8','284',57,'','20','2',0.00,0.00,'Sales from shift 14 on 2022-09-19 12:30:28 ','2022-09-19 12:30:28','',''),('8','284',58,'','6.1','1',0.00,0.00,'Sales from shift 14 on 2022-09-19 12:30:28 ','2022-09-19 12:30:28','',''),('8','284',59,'','20','2',0.00,0.00,'Sales from shift 15 on 2022-09-20 12:52:25 ','2022-09-20 12:52:25','',''),('8','284',60,'','6.1','1',0.00,0.00,'Sales from shift 15 on 2022-09-20 12:52:25 ','2022-09-20 12:52:25','',''),('8','284',61,'','20','2',1736835.43,0.00,'Sales from shift 16 on 2022-09-20 13:01:51 ','2022-09-20 13:01:51','',''),('8','284',62,'','6.1','1',0.00,1736835.43,'Sales from shift 16 on 2022-09-20 13:01:51 ','2022-09-20 13:01:51','',''),('8','284',63,'','20','2',1416562.40,0.00,'Sales from shift 17 on 2022-09-20 13:35:29 ','2022-09-20 13:35:29','',''),('8','284',64,'','6.1','1',0.00,1416562.40,'Sales from shift 17 on 2022-09-20 13:35:29 ','2022-09-20 13:35:29','',''),('8','284',65,'','20','2',2161529.26,0.00,'Sales from shift 18 on 2022-09-21 14:39:08 ','2022-09-21 14:39:08','',''),('8','284',66,'','6.1','1',0.00,2161529.26,'Sales from shift 18 on 2022-09-21 14:39:08 ','2022-09-21 14:39:08','',''),('8','284',67,'','20','2',1980524.48,0.00,'Sales from shift 19 on 2022-09-21 14:54:04 ','2022-09-21 14:54:04','',''),('8','284',68,'','6.1','1',0.00,1980524.48,'Sales from shift 19 on 2022-09-21 14:54:04 ','2022-09-21 14:54:04','',''),('8','284',69,'','2','6',1147445.00,0.00,'Payment Id 21 for invoice:012, receipt: 012 by Lausu Energy Resources','2022-09-21 15:00:31','',''),('8','284',70,'','supplier','1',0.00,1147445.00,'Payment Id 21 for invoice:012, receipt: 012 by Lausu Energy Resources','2022-09-21 15:00:31','',''),('8','284',71,'','2','6',2161530.00,0.00,'Payment Id 24 for invoice:016, receipt: 016 by Lausu Energy Resources','2022-09-21 15:01:17','',''),('8','284',72,'','supplier','1',0.00,2161530.00,'Payment Id 24 for invoice:016, receipt: 016 by Lausu Energy Resources','2022-09-21 15:01:17','',''),('8','284',73,'','2','6',1416565.00,0.00,'Payment Id 23 for invoice:015, receipt: 015 by Lausu Energy Resources','2022-09-21 15:01:17','',''),('8','284',74,'','supplier','1',0.00,1416565.00,'Payment Id 23 for invoice:015, receipt: 015 by Lausu Energy Resources','2022-09-21 15:01:17','',''),('8','284',75,'','2','6',1736835.00,0.00,'Payment Id 22 for invoice:014, receipt: 0014 by Lausu Energy Resources','2022-09-21 15:01:17','',''),('8','284',76,'','supplier','1',0.00,1736835.00,'Payment Id 22 for invoice:014, receipt: 0014 by Lausu Energy Resources','2022-09-21 15:01:17','',''),('8','284',77,'','2','6',1050450.00,0.00,'Payment Id 25 for invoice:017, receipt: 017 by Lausu Energy Resources','2022-09-23 08:50:55','',''),('8','284',78,'','supplier','1',0.00,1050450.00,'Payment Id 25 for invoice:017, receipt: 017 by Lausu Energy Resources','2022-09-23 08:50:55','',''),('8','284',79,'','20','2',1050427.62,0.00,'Sales from shift 20 on 2022-09-23 20:06:53 ','2022-09-23 20:06:53','',''),('8','284',80,'','6.1','1',0.00,1050427.62,'Sales from shift 20 on 2022-09-23 20:06:53 ','2022-09-23 20:06:53','',''),('8','284',81,'','20','2',0.00,0.00,'Sales from shift 21 on 2022-09-27 14:32:46 ','2022-09-27 14:32:46','',''),('8','284',82,'','6.1','1',0.00,0.00,'Sales from shift 21 on 2022-09-27 14:32:46 ','2022-09-27 14:32:46','',''),('8','284',83,'','24','3',0.00,9200400.00,'Purchase Id 4 for 49,200.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-28 10:08:48','',''),('8','284',84,'','supplier','1',9200400.00,0.00,'Purchase Id 4 for 49,200.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-28 10:08:48','',''),('8','284',85,'','20','2',1670538.32,0.00,'Sales from shift 22 on 2022-09-28 14:31:17 ','2022-09-28 14:31:17','',''),('8','284',86,'','6.1','1',0.00,1670538.32,'Sales from shift 22 on 2022-09-28 14:31:17 ','2022-09-28 14:31:17','',''),('8','284',87,'','20','2',1206275.29,0.00,'Sales from shift 23 on 2022-09-28 14:37:50 ','2022-09-28 14:37:50','',''),('8','284',88,'','6.1','1',0.00,1206275.29,'Sales from shift 23 on 2022-09-28 14:37:50 ','2022-09-28 14:37:50','',''),('8','284',89,'','20','2',1219391.47,0.00,'Sales from shift 24 on 2022-09-28 15:54:05 ','2022-09-28 15:54:05','',''),('8','284',90,'','6.1','1',0.00,1219391.47,'Sales from shift 24 on 2022-09-28 15:54:05 ','2022-09-28 15:54:05','',''),('8','284',91,'','20','2',675795.56,0.00,'Sales from shift 25 on 2022-09-28 16:00:14 ','2022-09-28 16:00:14','',''),('8','284',92,'','6.1','1',0.00,675795.56,'Sales from shift 25 on 2022-09-28 16:00:14 ','2022-09-28 16:00:14','',''),('8','284',93,'','20','2',2353785.83,0.00,'Sales from shift 26 on 2022-09-28 23:03:30 ','2022-09-28 23:03:30','',''),('8','284',94,'','6.1','1',0.00,2353785.83,'Sales from shift 26 on 2022-09-28 23:03:30 ','2022-09-28 23:03:30','',''),('8','284',95,'','2','6',2353785.00,0.00,'Payment Id 30 for invoice:21, receipt: 21 by Lausu Energy Resources','2022-09-29 22:05:16','',''),('8','284',96,'','supplier','1',0.00,2353785.00,'Payment Id 30 for invoice:21, receipt: 21 by Lausu Energy Resources','2022-09-29 22:05:16','',''),('8','284',97,'','2','6',675795.00,0.00,'Payment Id 29 for invoice:21, receipt: 21 by Lausu Energy Resources','2022-09-29 22:05:16','',''),('8','284',98,'','supplier','1',0.00,675795.00,'Payment Id 29 for invoice:21, receipt: 21 by Lausu Energy Resources','2022-09-29 22:05:16','',''),('8','284',99,'','2','6',1219390.00,0.00,'Payment Id 28 for invoice:20, receipt: 20 by Lausu Energy Resources','2022-09-29 22:05:16','',''),('8','284',100,'','supplier','1',0.00,1219390.00,'Payment Id 28 for invoice:20, receipt: 20 by Lausu Energy Resources','2022-09-29 22:05:16','',''),('8','284',101,'','2','6',1206275.00,0.00,'Payment Id 27 for invoice:19, receipt: 19 by Lausu Energy Resources','2022-09-29 22:06:08','',''),('8','284',102,'','supplier','1',0.00,1206275.00,'Payment Id 27 for invoice:19, receipt: 19 by Lausu Energy Resources','2022-09-29 22:06:08','',''),('8','284',103,'','2','6',1670530.00,0.00,'Payment Id 26 for invoice:018, receipt: 018 by Lausu Energy Resources','2022-09-29 22:06:08','',''),('8','284',104,'','supplier','1',0.00,1670530.00,'Payment Id 26 for invoice:018, receipt: 018 by Lausu Energy Resources','2022-09-29 22:06:08','',''),('8','284',105,'','20','2',1418991.53,0.00,'Sales from shift 27 on 2022-09-30 00:12:41 ','2022-09-30 00:12:41','',''),('8','284',106,'','6.1','1',0.00,1418991.53,'Sales from shift 27 on 2022-09-30 00:12:41 ','2022-09-30 00:12:41','',''),('8','284',107,'','20','2',1530148.07,0.00,'Sales from shift 28 on 2022-09-30 11:15:37 ','2022-09-30 11:15:37','',''),('8','284',108,'','6.1','1',0.00,1530148.07,'Sales from shift 28 on 2022-09-30 11:15:37 ','2022-09-30 11:15:37','',''),('8','284',109,'','20','2',1662495.45,0.00,'Sales from shift 29 on 2022-10-01 21:24:22 ','2022-10-01 21:24:22','',''),('8','284',110,'','6.1','1',0.00,1662495.45,'Sales from shift 29 on 2022-10-01 21:24:22 ','2022-10-01 21:24:22','',''),('8','284',111,'','2','6',1238210.00,0.00,'Payment Id 34 for invoice:26, receipt: 26 by Lausu Energy Resources','2022-10-03 11:31:59','',''),('8','284',112,'','supplier','1',0.00,1238210.00,'Payment Id 34 for invoice:26, receipt: 26 by Lausu Energy Resources','2022-10-03 11:31:59','',''),('8','284',113,'','2','6',1662500.00,0.00,'Payment Id 33 for invoice:25, receipt: ,25 by Lausu Energy Resources','2022-10-03 11:31:59','',''),('8','284',114,'','supplier','1',0.00,1662500.00,'Payment Id 33 for invoice:25, receipt: ,25 by Lausu Energy Resources','2022-10-03 11:31:59','',''),('8','284',115,'','2','6',1530150.00,0.00,'Payment Id 32 for invoice:24, receipt: 24 by Lausu Energy Resources','2022-10-03 11:31:59','',''),('8','284',116,'','supplier','1',0.00,1530150.00,'Payment Id 32 for invoice:24, receipt: 24 by Lausu Energy Resources','2022-10-03 11:31:59','',''),('8','284',117,'','2','6',1418990.00,0.00,'Payment Id 31 for invoice:22, receipt: 22 by Lausu Energy Resources','2022-10-03 11:31:59','',''),('8','284',118,'','supplier','1',0.00,1418990.00,'Payment Id 31 for invoice:22, receipt: 22 by Lausu Energy Resources','2022-10-03 11:31:59','',''),('8','284',119,'','24','3',0.00,9350000.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-07 14:38:32','',''),('8','284',120,'','supplier','1',9350000.00,0.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-07 14:38:32','',''),('8','284',121,'','20','2',1238209.28,0.00,'Sales from shift 30 on 2022-10-07 15:27:07 ','2022-10-07 15:27:07','',''),('8','284',122,'','6.1','1',0.00,1238209.28,'Sales from shift 30 on 2022-10-07 15:27:07 ','2022-10-07 15:27:07','',''),('8','284',123,'','20','2',1074487.04,0.00,'Sales from shift 31 on 2022-10-07 15:38:45 ','2022-10-07 15:38:45','',''),('8','284',124,'','6.1','1',0.00,1074487.04,'Sales from shift 31 on 2022-10-07 15:38:45 ','2022-10-07 15:38:45','',''),('8','284',125,'','20','2',2746311.92,0.00,'Sales from shift 32 on 2022-10-07 15:48:39 ','2022-10-07 15:48:39','',''),('8','284',126,'','6.1','1',0.00,2746311.92,'Sales from shift 32 on 2022-10-07 15:48:39 ','2022-10-07 15:48:39','',''),('8','284',127,'','20','2',1677008.52,0.00,'Sales from shift 33 on 2022-10-07 15:53:08 ','2022-10-07 15:53:08','',''),('8','284',128,'','6.1','1',0.00,1677008.52,'Sales from shift 33 on 2022-10-07 15:53:08 ','2022-10-07 15:53:08','',''),('8','284',129,'','24','3',0.00,9750000.00,'Purchase Id 6 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-08 22:37:25','',''),('8','284',130,'','supplier','1',9750000.00,0.00,'Purchase Id 6 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-08 22:37:25','',''),('8','284',131,'','2','7',1845395.00,0.00,'Payment Id 38 for invoice:30, receipt: 30 by Lausu Energy Resources','2022-10-09 06:38:16','',''),('8','284',132,'','supplier','1',0.00,1845395.00,'Payment Id 38 for invoice:30, receipt: 30 by Lausu Energy Resources','2022-10-09 06:38:16','',''),('8','284',133,'','2','6',2746315.00,0.00,'Payment Id 36 for invoice:28, receipt: 28 by Lausu Energy Resources','2022-10-09 06:38:16','',''),('8','284',134,'','supplier','1',0.00,2746315.00,'Payment Id 36 for invoice:28, receipt: 28 by Lausu Energy Resources','2022-10-09 06:38:16','',''),('8','284',135,'','2','6',1074485.00,0.00,'Payment Id 35 for invoice:27, receipt: 27 by Lausu Energy Resources','2022-10-09 06:38:16','',''),('8','284',136,'','supplier','1',0.00,1074485.00,'Payment Id 35 for invoice:27, receipt: 27 by Lausu Energy Resources','2022-10-09 06:38:16','',''),('8','284',137,'','20','2',1845373.97,0.00,'Sales from shift 34 on 2022-10-09 23:07:22 ','2022-10-09 23:07:22','',''),('8','284',138,'','6.1','1',0.00,1845373.97,'Sales from shift 34 on 2022-10-09 23:07:22 ','2022-10-09 23:07:22','',''),('8','284',139,'','20','2',1987410.75,0.00,'Sales from shift 35 on 2022-10-10 06:37:39 ','2022-10-10 06:37:39','',''),('8','284',140,'','6.1','1',0.00,1987410.75,'Sales from shift 35 on 2022-10-10 06:37:39 ','2022-10-10 06:37:39','',''),('8','284',141,'','2','6',1987410.00,0.00,'Payment Id 39 for invoice:31, receipt: 31 by Lausu Energy Resources','2022-10-10 12:47:38','',''),('8','284',142,'','supplier','1',0.00,1987410.00,'Payment Id 39 for invoice:31, receipt: 31 by Lausu Energy Resources','2022-10-10 12:47:38','',''),('8','284',143,'','20','2',2774867.55,0.00,'Sales from shift 36 on 2022-10-10 14:58:04 ','2022-10-10 14:58:04','',''),('8','284',144,'','6.1','1',0.00,2774867.55,'Sales from shift 36 on 2022-10-10 14:58:04 ','2022-10-10 14:58:04','',''),('8','284',145,'','20','2',4180320.30,0.00,'Sales from shift 37 on 2022-10-12 00:11:09 ','2022-10-12 00:11:09','',''),('8','284',146,'','6.1','1',0.00,4180320.30,'Sales from shift 37 on 2022-10-12 00:11:09 ','2022-10-12 00:11:09','',''),('8','284',147,'','2','6',2774870.00,0.00,'Payment Id 40 for invoice:32, receipt: 32 by Lausu Energy Resources','2022-10-12 16:59:37','',''),('8','284',148,'','supplier','1',0.00,2774870.00,'Payment Id 40 for invoice:32, receipt: 32 by Lausu Energy Resources','2022-10-12 16:59:37','',''),('8','284',149,'','20','2',2641309.34,0.00,'Sales from shift 38 on 2022-10-14 08:47:33 ','2022-10-14 08:47:33','',''),('8','284',150,'','6.1','1',0.00,2641309.34,'Sales from shift 38 on 2022-10-14 08:47:33 ','2022-10-14 08:47:33','',''),('8','284',151,'','20','2',922240.00,0.00,'Sales from shift 39 on 2022-10-14 08:56:57 ','2022-10-14 08:56:57','',''),('8','284',152,'','6.1','1',0.00,922240.00,'Sales from shift 39 on 2022-10-14 08:56:57 ','2022-10-14 08:56:57','',''),('8','284',153,'','24','3',0.00,11227500.00,'Purchase Id 7 for 49,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-15 13:46:03','',''),('8','284',154,'','supplier','1',11227500.00,0.00,'Purchase Id 7 for 49,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-15 13:46:03','',''),('8','284',155,'','20','2',2707137.00,0.00,'Sales from shift 40 on 2022-10-16 10:48:32 ','2022-10-16 10:48:32','',''),('8','284',156,'','6.1','1',0.00,2707137.00,'Sales from shift 40 on 2022-10-16 10:48:32 ','2022-10-16 10:48:32','',''),('8','284',157,'','20','2',2266368.75,0.00,'Sales from shift 41 on 2022-10-16 11:10:17 ','2022-10-16 11:10:17','',''),('8','284',158,'','6.1','1',0.00,2266368.75,'Sales from shift 41 on 2022-10-16 11:10:17 ','2022-10-16 11:10:17','',''),('8','284',159,'','2','6',2707140.00,0.00,'Payment Id 43 for invoice:35, receipt: 35 by Lausu Energy Resources','2022-10-17 10:22:12','',''),('8','284',160,'','supplier','1',0.00,2707140.00,'Payment Id 43 for invoice:35, receipt: 35 by Lausu Energy Resources','2022-10-17 10:22:12','',''),('8','284',161,'','2','6',922240.00,0.00,'Payment Id 42 for invoice:34, receipt: 34 by Lausu Energy Resources','2022-10-17 10:22:12','',''),('8','284',162,'','supplier','1',0.00,922240.00,'Payment Id 42 for invoice:34, receipt: 34 by Lausu Energy Resources','2022-10-17 10:22:12','',''),('8','284',163,'','2','6',2641310.00,0.00,'Payment Id 41 for invoice:33, receipt: 33 by Lausu Energy Resources','2022-10-17 10:22:12','',''),('8','284',164,'','supplier','1',0.00,2641310.00,'Payment Id 41 for invoice:33, receipt: 33 by Lausu Energy Resources','2022-10-17 10:22:12','',''),('8','284',165,'','20','2',3362712.75,0.00,'Sales from shift 42 on 2022-10-19 15:09:13 ','2022-10-19 15:09:13','',''),('8','284',166,'','6.1','1',0.00,3362712.75,'Sales from shift 42 on 2022-10-19 15:09:13 ','2022-10-19 15:09:13','',''),('8','284',167,'','24','3',0.00,4140000.00,'Purchase Id 8 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-20 11:31:29','',''),('8','284',168,'','supplier','1',4140000.00,0.00,'Purchase Id 8 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-20 11:31:29','',''),('8','284',169,'','2','6',2769095.00,0.00,'Payment Id 46 for invoice:38, receipt: 38 by Lausu Energy Resources','2022-10-20 13:45:51','',''),('8','284',170,'','supplier','1',0.00,2769095.00,'Payment Id 46 for invoice:38, receipt: 38 by Lausu Energy Resources','2022-10-20 13:45:51','',''),('8','284',171,'','2','6',2266370.00,0.00,'Payment Id 45 for invoice:37, receipt: 37 by Lausu Energy Resources','2022-10-20 13:45:51','',''),('8','284',172,'','supplier','1',0.00,2266370.00,'Payment Id 45 for invoice:37, receipt: 37 by Lausu Energy Resources','2022-10-20 13:45:51','',''),('8','284',173,'','2','6',3362715.00,0.00,'Payment Id 44 for invoice:36, receipt: 36 by Lausu Energy Resources','2022-10-20 13:45:51','',''),('8','284',174,'','supplier','1',0.00,3362715.00,'Payment Id 44 for invoice:36, receipt: 36 by Lausu Energy Resources','2022-10-20 13:45:51','',''),('8','284',175,'','2','6',1676990.00,0.00,'Payment Id 37 for invoice:29, receipt: 29 by Lausu Energy Resources','2022-10-20 13:48:02','',''),('8','284',176,'','supplier','1',0.00,1676990.00,'Payment Id 37 for invoice:29, receipt: 29 by Lausu Energy Resources','2022-10-20 13:48:02','',''),('8','284',177,'','20','2',2769095.25,0.00,'Sales from shift 43 on 2022-10-21 08:25:03 ','2022-10-21 08:25:03','',''),('8','284',178,'','6.1','1',0.00,2769095.25,'Sales from shift 43 on 2022-10-21 08:25:03 ','2022-10-21 08:25:03','',''),('8','284',179,'','20','2',450000.00,0.00,'Sales from shift 44 on 2022-10-21 08:30:09 ','2022-10-21 08:30:09','',''),('8','284',180,'','6.1','1',0.00,450000.00,'Sales from shift 44 on 2022-10-21 08:30:09 ','2022-10-21 08:30:09','',''),('8','284',181,'','20','2',3208966.90,0.00,'Sales from shift 45 on 2022-10-21 08:59:08 ','2022-10-21 08:59:08','',''),('8','284',182,'','6.1','1',0.00,3208966.90,'Sales from shift 45 on 2022-10-21 08:59:08 ','2022-10-21 08:59:08','',''),('8','284',183,'','20','2',0.00,0.00,'Sales from shift 46 on 2022-10-24 15:37:54 ','2022-10-24 15:37:54','',''),('8','284',184,'','6.1','1',0.00,0.00,'Sales from shift 46 on 2022-10-24 15:37:54 ','2022-10-24 15:37:54','',''),('8','284',185,'','20','2',889984.95,0.00,'Sales from shift 47 on 2022-10-24 15:41:41 ','2022-10-24 15:41:41','',''),('8','284',186,'','6.1','1',0.00,889984.95,'Sales from shift 47 on 2022-10-24 15:41:41 ','2022-10-24 15:41:41','',''),('8','284',187,'','24','3',0.00,3948000.00,'Purchase Id 9 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-25 12:18:42','',''),('8','284',188,'','supplier','1',3948000.00,0.00,'Purchase Id 9 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-25 12:18:42','',''),('8','284',189,'','2','6',889985.00,0.00,'Payment Id 49 for invoice:43, receipt: 43 by Lausu Energy Resources','2022-10-27 10:34:06','',''),('8','284',190,'','supplier','1',0.00,889985.00,'Payment Id 49 for invoice:43, receipt: 43 by Lausu Energy Resources','2022-10-27 10:34:06','',''),('8','284',191,'','2','6',3209200.00,0.00,'Payment Id 48 for invoice:41, receipt: 41 by Lausu Energy Resources','2022-10-27 10:34:06','',''),('8','284',192,'','supplier','1',0.00,3209200.00,'Payment Id 48 for invoice:41, receipt: 41 by Lausu Energy Resources','2022-10-27 10:34:06','',''),('8','284',193,'','2','6',450000.00,0.00,'Payment Id 47 for invoice:40, receipt: 40 by Lausu Energy Resources','2022-10-27 10:34:07','',''),('8','284',194,'','supplier','1',0.00,450000.00,'Payment Id 47 for invoice:40, receipt: 40 by Lausu Energy Resources','2022-10-27 10:34:07','',''),('8','284',195,'','20','2',3738753.65,0.00,'Sales from shift 48 on 2022-10-27 11:04:17 ','2022-10-27 11:04:17','',''),('8','284',196,'','6.1','1',0.00,3738753.65,'Sales from shift 48 on 2022-10-27 11:04:17 ','2022-10-27 11:04:17','',''),('8','284',197,'','20','2',187532.35,0.00,'Sales from shift 49 on 2022-10-27 11:07:27 ','2022-10-27 11:07:27','',''),('8','284',198,'','6.1','1',0.00,187532.35,'Sales from shift 49 on 2022-10-27 11:07:27 ','2022-10-27 11:07:27','',''),('8','284',199,'','2','6',3738755.00,0.00,'Payment Id 52 for invoice:47, receipt: 47 by Lausu Energy Resources','2022-11-01 17:07:32','',''),('8','284',200,'','supplier','1',0.00,3738755.00,'Payment Id 52 for invoice:47, receipt: 47 by Lausu Energy Resources','2022-11-01 17:07:32','',''),('8','284',201,'','2','6',4180240.00,0.00,'Payment Id 51 for invoice:46, receipt: 46 by Lausu Energy Resources','2022-11-02 13:33:40','',''),('8','284',202,'','supplier','1',0.00,4180240.00,'Payment Id 51 for invoice:46, receipt: 46 by Lausu Energy Resources','2022-11-02 13:33:40','',''),('8','284',203,'','2','6',1980525.00,0.00,'Payment Id 50 for invoice:17, receipt: 17 by Lausu Energy Resources','2022-11-02 13:33:40','',''),('8','284',204,'','supplier','1',0.00,1980525.00,'Payment Id 50 for invoice:17, receipt: 17 by Lausu Energy Resources','2022-11-02 13:33:40','',''),('8','284',205,'','24','3',0.00,11175000.00,'Purchase Id 10 for 44,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-03 14:04:42','',''),('8','284',206,'','supplier','1',11175000.00,0.00,'Purchase Id 10 for 44,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-03 14:04:42','',''),('8','284',207,'','20','2',1576530.00,0.00,'Sales from shift 50 on 2022-11-05 00:01:08 ','2022-11-05 00:01:08','',''),('8','284',208,'','6.1','1',0.00,1576530.00,'Sales from shift 50 on 2022-11-05 00:01:08 ','2022-11-05 00:01:08','',''),('8','284',209,'','20','2',2122566.45,0.00,'Sales from shift 51 on 2022-11-06 07:10:34 ','2022-11-06 07:10:34','',''),('8','284',210,'','6.1','1',0.00,2122566.45,'Sales from shift 51 on 2022-11-06 07:10:34 ','2022-11-06 07:10:34','',''),('8','284',211,'','24','3',0.00,4250000.00,'Purchase Id 11 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-06 19:13:25','',''),('8','284',212,'','supplier','1',4250000.00,0.00,'Purchase Id 11 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-06 19:13:25','',''),('8','284',213,'','20','2',1826689.95,0.00,'Sales from shift 52 on 2022-11-06 19:20:06 ','2022-11-06 19:20:06','',''),('8','284',214,'','6.1','1',0.00,1826689.95,'Sales from shift 52 on 2022-11-06 19:20:06 ','2022-11-06 19:20:06','',''),('8','284',215,'','20','2',1253067.45,0.00,'Sales from shift 53 on 2022-11-07 11:23:04 ','2022-11-07 11:23:04','',''),('8','284',216,'','6.1','1',0.00,1253067.45,'Sales from shift 53 on 2022-11-07 11:23:04 ','2022-11-07 11:23:04','',''),('8','284',217,'','20','2',467412.45,0.00,'Sales from shift 54 on 2022-11-07 11:29:47 ','2022-11-07 11:29:47','',''),('8','284',218,'','6.1','1',0.00,467412.45,'Sales from shift 54 on 2022-11-07 11:29:47 ','2022-11-07 11:29:47','',''),('8','284',219,'','2','6',1253075.00,0.00,'Payment Id 57 for invoice:53, receipt: 53 by Lausu Energy Resources','2022-11-07 12:19:45','',''),('8','284',220,'','supplier','1',0.00,1253075.00,'Payment Id 57 for invoice:53, receipt: 53 by Lausu Energy Resources','2022-11-07 12:19:45','',''),('8','284',221,'','2','6',1826690.00,0.00,'Payment Id 56 for invoice:52, receipt: 52 by Lausu Energy Resources','2022-11-07 12:19:45','',''),('8','284',222,'','supplier','1',0.00,1826690.00,'Payment Id 56 for invoice:52, receipt: 52 by Lausu Energy Resources','2022-11-07 12:19:45','',''),('8','284',223,'','2','6',2122565.00,0.00,'Payment Id 55 for invoice:51, receipt: 51 by Lausu Energy Resources','2022-11-07 12:19:45','',''),('8','284',224,'','supplier','1',0.00,2122565.00,'Payment Id 55 for invoice:51, receipt: 51 by Lausu Energy Resources','2022-11-07 12:19:45','',''),('8','284',225,'','2','6',1576530.00,0.00,'Payment Id 54 for invoice:50, receipt: 50 by Lausu Energy Resources','2022-11-07 12:19:45','',''),('8','284',226,'','supplier','1',0.00,1576530.00,'Payment Id 54 for invoice:50, receipt: 50 by Lausu Energy Resources','2022-11-07 12:19:45','',''),('8','284',227,'','2','6',187535.00,0.00,'Payment Id 53 for invoice:49, receipt: 49 by Lausu Energy Resources','2022-11-07 12:20:15','',''),('8','284',228,'','supplier','1',0.00,187535.00,'Payment Id 53 for invoice:49, receipt: 49 by Lausu Energy Resources','2022-11-07 12:20:15','',''),('8','284',229,'','2','6',1120200.00,0.00,'Payment Id 59 for invoice:55, receipt: 55 by Lausu Energy Resources','2022-11-07 16:05:52','',''),('8','284',230,'','supplier','1',0.00,1120200.00,'Payment Id 59 for invoice:55, receipt: 55 by Lausu Energy Resources','2022-11-07 16:05:52','',''),('8','284',231,'','2','6',467410.00,0.00,'Payment Id 58 for invoice:54, receipt: 54 by Lausu Energy Resources','2022-11-07 16:05:52','',''),('8','284',232,'','supplier','1',0.00,467410.00,'Payment Id 58 for invoice:54, receipt: 54 by Lausu Energy Resources','2022-11-07 16:05:52','',''),('8','284',233,'','20','2',1120200.00,0.00,'Sales from shift 55 on 2022-11-08 23:20:17 ','2022-11-08 23:20:17','',''),('8','284',234,'','6.1','1',0.00,1120200.00,'Sales from shift 55 on 2022-11-08 23:20:17 ','2022-11-08 23:20:17','',''),('8','284',235,'','20','2',3284882.50,0.00,'Sales from shift 56 on 2022-11-09 12:01:24 ','2022-11-09 12:01:24','',''),('8','284',236,'','6.1','1',0.00,3284882.50,'Sales from shift 56 on 2022-11-09 12:01:24 ','2022-11-09 12:01:24','',''),('8','284',237,'','20','2',2456710.00,0.00,'Sales from shift 57 on 2022-11-09 12:54:11 ','2022-11-09 12:54:11','',''),('8','284',238,'','6.1','1',0.00,2456710.00,'Sales from shift 57 on 2022-11-09 12:54:11 ','2022-11-09 12:54:11','',''),('8','284',239,'','2','6',3284885.00,0.00,'Payment Id 60 for invoice:56, receipt: 56 by Lausu Energy Resources','2022-11-09 13:00:23','',''),('8','284',240,'','supplier','1',0.00,3284885.00,'Payment Id 60 for invoice:56, receipt: 56 by Lausu Energy Resources','2022-11-09 13:00:23','',''),('8','284',241,'','24','3',0.00,8000000.00,'Purchase Id 12 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-10 22:03:46','',''),('8','284',242,'','supplier','1',8000000.00,0.00,'Purchase Id 12 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-10 22:03:46','',''),('8','284',243,'','20','2',2511200.00,0.00,'Sales from shift 58 on 2022-11-11 11:58:34 ','2022-11-11 11:58:34','',''),('8','284',244,'','6.1','1',0.00,2511200.00,'Sales from shift 58 on 2022-11-11 11:58:34 ','2022-11-11 11:58:34','',''),('8','284',245,'','20','2',3085130.00,0.00,'Sales from shift 59 on 2022-11-12 06:34:44 ','2022-11-12 06:34:44','',''),('8','284',246,'','6.1','1',0.00,3085130.00,'Sales from shift 59 on 2022-11-12 06:34:44 ','2022-11-12 06:34:44','',''),('8','284',247,'','2','6',3085130.00,0.00,'Payment Id 63 for invoice:59, receipt: 59 by Lausu Energy Resources','2022-11-13 06:50:51','',''),('8','284',248,'','supplier','1',0.00,3085130.00,'Payment Id 63 for invoice:59, receipt: 59 by Lausu Energy Resources','2022-11-13 06:50:51','',''),('8','284',249,'','24','3',0.00,8200000.00,'Purchase Id 13 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-14 08:08:48','',''),('8','284',250,'','supplier','1',8200000.00,0.00,'Purchase Id 13 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-14 08:08:48','',''),('8','284',251,'','20','2',3076112.50,0.00,'Sales from shift 60 on 2022-11-14 10:42:58 ','2022-11-14 10:42:58','',''),('8','284',252,'','6.1','1',0.00,3076112.50,'Sales from shift 60 on 2022-11-14 10:42:58 ','2022-11-14 10:42:58','',''),('8','284',253,'','20','2',1429910.00,0.00,'Sales from shift 61 on 2022-11-14 10:48:42 ','2022-11-14 10:48:42','',''),('8','284',254,'','6.1','1',0.00,1429910.00,'Sales from shift 61 on 2022-11-14 10:48:42 ','2022-11-14 10:48:42','',''),('8','284',255,'','20','2',2681878.35,0.00,'Sales from shift 62 on 2022-11-14 10:55:06 ','2022-11-14 10:55:06','',''),('8','284',256,'','6.1','1',0.00,2681878.35,'Sales from shift 62 on 2022-11-14 10:55:06 ','2022-11-14 10:55:06','',''),('8','284',257,'','2','6',2456710.00,0.00,'Payment Id 61 for invoice:57, receipt: 57 by Lausu Energy Resources','2022-11-14 13:45:38','',''),('8','284',258,'','supplier','1',0.00,2456710.00,'Payment Id 61 for invoice:57, receipt: 57 by Lausu Energy Resources','2022-11-14 13:45:38','',''),('8','284',259,'','2','7',2681880.00,0.00,'Payment Id 66 for invoice:62, receipt: 62 by Lausu Energy Resources','2022-11-15 16:45:22','',''),('8','284',260,'','supplier','1',0.00,2681880.00,'Payment Id 66 for invoice:62, receipt: 62 by Lausu Energy Resources','2022-11-15 16:45:22','',''),('8','284',261,'','2','6',1429910.00,0.00,'Payment Id 65 for invoice:61, receipt: 61 by Lausu Energy Resources','2022-11-15 16:45:22','',''),('8','284',262,'','supplier','1',0.00,1429910.00,'Payment Id 65 for invoice:61, receipt: 61 by Lausu Energy Resources','2022-11-15 16:45:22','',''),('8','284',263,'','2','6',3076115.00,0.00,'Payment Id 64 for invoice:60, receipt: 60 by Lausu Energy Resources','2022-11-15 16:45:22','',''),('8','284',264,'','supplier','1',0.00,3076115.00,'Payment Id 64 for invoice:60, receipt: 60 by Lausu Energy Resources','2022-11-15 16:45:22','',''),('8','284',265,'','2','6',2511200.00,0.00,'Payment Id 62 for invoice:58, receipt: 58 by Lausu Energy Resources','2022-11-15 16:45:22','',''),('8','284',266,'','supplier','1',0.00,2511200.00,'Payment Id 62 for invoice:58, receipt: 58 by Lausu Energy Resources','2022-11-15 16:45:22','',''),('8','284',267,'','24','3',0.00,4245750.00,'Purchase Id 15 for 16,650.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-15 22:24:47','',''),('8','284',268,'','supplier','1',4245750.00,0.00,'Purchase Id 15 for 16,650.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-15 22:24:47','',''),('8','284',269,'','20','2',4454385.90,0.00,'Sales from shift 63 on 2022-11-15 22:52:33 ','2022-11-15 22:52:33','',''),('8','284',270,'','6.1','1',0.00,4454385.90,'Sales from shift 63 on 2022-11-15 22:52:33 ','2022-11-15 22:52:33','',''),('8','284',271,'','20','2',1245203.25,0.00,'Sales from shift 64 on 2022-11-16 09:52:29 ','2022-11-16 09:52:29','',''),('8','284',272,'','6.1','1',0.00,1245203.25,'Sales from shift 64 on 2022-11-16 09:52:29 ','2022-11-16 09:52:29','',''),('8','284',273,'','24','3',0.00,8338500.00,'Purchase Id 16 for 32,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-17 11:23:30','',''),('8','284',274,'','supplier','1',8338500.00,0.00,'Purchase Id 16 for 32,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-17 11:23:30','',''),('8','284',275,'','2','6',1245205.00,0.00,'Payment Id 68 for invoice:64, receipt: 64 by Lausu Energy Resources','2022-11-17 11:24:18','',''),('8','284',276,'','supplier','1',0.00,1245205.00,'Payment Id 68 for invoice:64, receipt: 64 by Lausu Energy Resources','2022-11-17 11:24:18','',''),('8','284',277,'','2','6',4454380.00,0.00,'Payment Id 67 for invoice:63, receipt: 63 by Lausu Energy Resources','2022-11-17 11:24:18','',''),('8','284',278,'','supplier','1',0.00,4454380.00,'Payment Id 67 for invoice:63, receipt: 63 by Lausu Energy Resources','2022-11-17 11:24:18','',''),('8','284',279,'','20','2',3174479.70,0.00,'Sales from shift 65 on 2022-11-18 09:02:10 ','2022-11-18 09:02:10','',''),('8','284',280,'','6.1','1',0.00,3174479.70,'Sales from shift 65 on 2022-11-18 09:02:10 ','2022-11-18 09:02:10','',''),('8','284',281,'','6.1','1',3174490.00,0.00,'Payment Id 69 for invoice:65, receipt: 65 by Lausu Energy Resources','2022-11-19 06:02:48','',''),('8','284',282,'','supplier','1',0.00,3174490.00,'Payment Id 69 for invoice:65, receipt: 65 by Lausu Energy Resources','2022-11-19 06:02:48','',''),('8','284',283,'','20','2',2270540.40,0.00,'Sales from shift 66 on 2022-11-19 21:52:24 ','2022-11-19 21:52:24','',''),('8','284',284,'','6.1','1',0.00,2270540.40,'Sales from shift 66 on 2022-11-19 21:52:24 ','2022-11-19 21:52:24','',''),('8','284',285,'','20','2',1791754.95,0.00,'Sales from shift 67 on 2022-11-20 08:47:47 ','2022-11-20 08:47:47','',''),('8','284',286,'','6.1','1',0.00,1791754.95,'Sales from shift 67 on 2022-11-20 08:47:47 ','2022-11-20 08:47:47','',''),('8','284',287,'','2','6',2270540.00,0.00,'Payment Id 70 for invoice:66, receipt: 66 by Lausu Energy Resources','2022-11-21 14:45:36','',''),('8','284',288,'','supplier','1',0.00,2270540.00,'Payment Id 70 for invoice:66, receipt: 66 by Lausu Energy Resources','2022-11-21 14:45:36','',''),('8','284',289,'','20','2',1812279.90,0.00,'Sales from shift 68 on 2022-11-22 08:07:07 ','2022-11-22 08:07:07','',''),('8','284',290,'','6.1','1',0.00,1812279.90,'Sales from shift 68 on 2022-11-22 08:07:07 ','2022-11-22 08:07:07','',''),('8','284',291,'','20','2',2297465.85,0.00,'Sales from shift 69 on 2022-11-22 08:14:44 ','2022-11-22 08:14:44','',''),('8','284',292,'','6.1','1',0.00,2297465.85,'Sales from shift 69 on 2022-11-22 08:14:44 ','2022-11-22 08:14:44','',''),('8','284',293,'','24','3',0.00,8224000.00,'Purchase Id 17 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-24 11:33:21','',''),('8','284',294,'','supplier','1',8224000.00,0.00,'Purchase Id 17 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-24 11:33:21','',''),('8','284',295,'','20','2',510000.00,0.00,'Sales from shift 70 on 2022-11-24 13:21:50 ','2022-11-24 13:21:50','',''),('8','284',296,'','6.1','1',0.00,510000.00,'Sales from shift 70 on 2022-11-24 13:21:50 ','2022-11-24 13:21:50','',''),('8','284',297,'','20','2',1814355.75,0.00,'Sales from shift 71 on 2022-11-24 13:27:22 ','2022-11-24 13:27:22','',''),('8','284',298,'','6.1','1',0.00,1814355.75,'Sales from shift 71 on 2022-11-24 13:27:22 ','2022-11-24 13:27:22','',''),('8','284',299,'','20','2',2082306.52,0.00,'Sales from shift 72 on 2022-11-24 13:32:42 ','2022-11-24 13:32:42','',''),('8','284',300,'','6.1','1',0.00,2082306.52,'Sales from shift 72 on 2022-11-24 13:32:42 ','2022-11-24 13:32:42','',''),('8','284',301,'','2','6',1814355.00,0.00,'Payment Id 75 for invoice:71, receipt: 71 by Lausu Energy Resources','2022-11-25 17:49:38','',''),('8','284',302,'','supplier','1',0.00,1814355.00,'Payment Id 75 for invoice:71, receipt: 71 by Lausu Energy Resources','2022-11-25 17:49:38','',''),('8','284',303,'','2','6',510000.00,0.00,'Payment Id 74 for invoice:70, receipt: 70 by Lausu Energy Resources','2022-11-25 17:49:38','',''),('8','284',304,'','supplier','1',0.00,510000.00,'Payment Id 74 for invoice:70, receipt: 70 by Lausu Energy Resources','2022-11-25 17:49:38','',''),('8','284',305,'','2','6',2297465.00,0.00,'Payment Id 73 for invoice:69, receipt: 69 by Lausu Energy Resources','2022-11-25 17:49:38','',''),('8','284',306,'','supplier','1',0.00,2297465.00,'Payment Id 73 for invoice:69, receipt: 69 by Lausu Energy Resources','2022-11-25 17:49:38','',''),('8','284',307,'','2','6',1812280.00,0.00,'Payment Id 72 for invoice:68, receipt: 68 by Lausu Energy Resources','2022-11-25 17:49:38','',''),('8','284',308,'','supplier','1',0.00,1812280.00,'Payment Id 72 for invoice:68, receipt: 68 by Lausu Energy Resources','2022-11-25 17:49:38','',''),('8','284',309,'','2','6',1791755.00,0.00,'Payment Id 71 for invoice:67, receipt: 67 by Lausu Energy Resources','2022-11-25 17:52:58','',''),('8','284',310,'','supplier','1',0.00,1791755.00,'Payment Id 71 for invoice:67, receipt: 67 by Lausu Energy Resources','2022-11-25 17:52:58','',''),('8','284',311,'','24','3',0.00,8738000.00,'Purchase Id 18 for 34,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-27 09:29:05','',''),('8','284',312,'','supplier','1',8738000.00,0.00,'Purchase Id 18 for 34,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-27 09:29:05','',''),('8','284',313,'','20','2',2281838.75,0.00,'Sales from shift 73 on 2022-11-27 14:32:32 ','2022-11-27 14:32:32','',''),('8','284',314,'','6.1','1',0.00,2281838.75,'Sales from shift 73 on 2022-11-27 14:32:32 ','2022-11-27 14:32:32','',''),('8','284',315,'','20','2',2239086.80,0.00,'Sales from shift 74 on 2022-11-27 14:45:31 ','2022-11-27 14:45:31','',''),('8','284',316,'','6.1','1',0.00,2239086.80,'Sales from shift 74 on 2022-11-27 14:45:31 ','2022-11-27 14:45:31','',''),('8','284',317,'','20','2',2033764.20,0.00,'Sales from shift 75 on 2022-11-27 14:53:54 ','2022-11-27 14:53:54','',''),('8','284',318,'','6.1','1',0.00,2033764.20,'Sales from shift 75 on 2022-11-27 14:53:54 ','2022-11-27 14:53:54','',''),('8','284',319,'','2','6',2281840.00,0.00,'Payment Id 77 for invoice:73, receipt: 73 by Lausu Energy Resources','2022-11-28 16:22:04','',''),('8','284',320,'','supplier','1',0.00,2281840.00,'Payment Id 77 for invoice:73, receipt: 73 by Lausu Energy Resources','2022-11-28 16:22:04','',''),('8','284',321,'','2','6',2082310.00,0.00,'Payment Id 76 for invoice:72, receipt: 72 by Lausu Energy Resources','2022-11-28 16:24:14','',''),('8','284',322,'','supplier','1',0.00,2082310.00,'Payment Id 76 for invoice:72, receipt: 72 by Lausu Energy Resources','2022-11-28 16:24:14','',''),('8','284',323,'','2','6',2239040.00,0.00,'Payment Id 78 for invoice:74, receipt: 74 by Lausu Energy Resources','2022-11-28 16:26:02','',''),('8','284',324,'','supplier','1',0.00,2239040.00,'Payment Id 78 for invoice:74, receipt: 74 by Lausu Energy Resources','2022-11-28 16:26:02','',''),('8','284',325,'','20','2',2577382.60,0.00,'Sales from shift 76 on 2022-12-01 00:15:12 ','2022-12-01 00:15:12','',''),('8','284',326,'','6.1','1',0.00,2577382.60,'Sales from shift 76 on 2022-12-01 00:15:12 ','2022-12-01 00:15:12','',''),('8','284',327,'','20','2',3248731.20,0.00,'Sales from shift 77 on 2022-12-01 00:26:36 ','2022-12-01 00:26:36','',''),('8','284',328,'','6.1','1',0.00,3248731.20,'Sales from shift 77 on 2022-12-01 00:26:36 ','2022-12-01 00:26:36','',''),('8','284',329,'','20','2',780304.20,0.00,'Sales from shift 78 on 2022-12-01 00:32:23 ','2022-12-01 00:32:23','',''),('8','284',330,'','6.1','1',0.00,780304.20,'Sales from shift 78 on 2022-12-01 00:32:23 ','2022-12-01 00:32:23','',''),('8','284',331,'','2','6',2033765.00,0.00,'Payment Id 79 for invoice:75, receipt: 75 by Lausu Energy Resources','2022-12-01 15:19:40','',''),('8','284',332,'','supplier','1',0.00,2033765.00,'Payment Id 79 for invoice:75, receipt: 75 by Lausu Energy Resources','2022-12-01 15:19:40','',''),('8','284',333,'','2','6',2577385.00,0.00,'Payment Id 80 for invoice:76, receipt: 76 by Lausu Energy Resources','2022-12-01 15:20:43','',''),('8','284',334,'','supplier','1',0.00,2577385.00,'Payment Id 80 for invoice:76, receipt: 76 by Lausu Energy Resources','2022-12-01 15:20:43','',''),('8','284',335,'','24','3',0.00,4680000.00,'Purchase Id 19 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-02 08:28:18','',''),('8','284',336,'','supplier','1',4680000.00,0.00,'Purchase Id 19 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-02 08:28:18','',''),('8','284',337,'','20','2',3702816.00,0.00,'Sales from shift 79 on 2022-12-03 12:33:24 ','2022-12-03 12:33:24','',''),('8','284',338,'','6.1','1',0.00,3702816.00,'Sales from shift 79 on 2022-12-03 12:33:24 ','2022-12-03 12:33:24','',''),('8','284',339,'','2','6',3702815.00,0.00,'Payment Id 83 for invoice:79, receipt: 79 by Lausu Energy Resources','2022-12-03 13:52:42','',''),('8','284',340,'','supplier','1',0.00,3702815.00,'Payment Id 83 for invoice:79, receipt: 79 by Lausu Energy Resources','2022-12-03 13:52:42','',''),('8','284',341,'','2','6',780295.00,0.00,'Payment Id 82 for invoice:78, receipt: 78 by Lausu Energy Resources','2022-12-03 13:53:08','',''),('8','284',342,'','supplier','1',0.00,780295.00,'Payment Id 82 for invoice:78, receipt: 78 by Lausu Energy Resources','2022-12-03 13:53:08','',''),('8','284',343,'','2','6',3248740.00,0.00,'Payment Id 81 for invoice:77, receipt: 77 by Lausu Energy Resources','2022-12-03 13:55:26','',''),('8','284',344,'','supplier','1',0.00,3248740.00,'Payment Id 81 for invoice:77, receipt: 77 by Lausu Energy Resources','2022-12-03 13:55:26','',''),('8','284',345,'','24','3',0.00,8580000.00,'Purchase Id 20 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-06 10:24:36','',''),('8','284',346,'','supplier','1',8580000.00,0.00,'Purchase Id 20 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-06 10:24:36','',''),('8','284',347,'','20','2',1005365.40,0.00,'Sales from shift 80 on 2022-12-06 12:42:20 ','2022-12-06 12:42:20','',''),('8','284',348,'','6.1','1',0.00,1005365.40,'Sales from shift 80 on 2022-12-06 12:42:20 ','2022-12-06 12:42:20','',''),('8','284',349,'','20','2',1277663.40,0.00,'Sales from shift 81 on 2022-12-07 18:17:50 ','2022-12-07 18:17:50','',''),('8','284',350,'','6.1','1',0.00,1277663.40,'Sales from shift 81 on 2022-12-07 18:17:50 ','2022-12-07 18:17:50','',''),('8','284',351,'','20','2',2199506.40,0.00,'Sales from shift 82 on 2022-12-08 12:34:03 ','2022-12-08 12:34:03','',''),('8','284',352,'','6.1','1',0.00,2199506.40,'Sales from shift 82 on 2022-12-08 12:34:03 ','2022-12-08 12:34:03','',''),('8','284',353,'','20','2',4439908.35,0.00,'Sales from shift 83 on 2022-12-08 12:38:55 ','2022-12-08 12:38:55','',''),('8','284',354,'','6.1','1',0.00,4439908.35,'Sales from shift 83 on 2022-12-08 12:38:55 ','2022-12-08 12:38:55','',''),('8','284',355,'','2','6',1005365.00,0.00,'Payment Id 84 for invoice:80, receipt: 80 by Lausu Energy Resources','2022-12-08 17:27:28','',''),('8','284',356,'','supplier','1',0.00,1005365.00,'Payment Id 84 for invoice:80, receipt: 80 by Lausu Energy Resources','2022-12-08 17:27:28','',''),('8','284',357,'','2','6',1277665.00,0.00,'Payment Id 85 for invoice:Morning81, receipt: 81 by Lausu Energy Resources','2022-12-08 17:27:57','',''),('8','284',358,'','supplier','1',0.00,1277665.00,'Payment Id 85 for invoice:Morning81, receipt: 81 by Lausu Energy Resources','2022-12-08 17:27:57','',''),('8','284',359,'','20','2',1046838.40,0.00,'Sales from shift 84 on 2022-12-11 16:42:16 ','2022-12-11 16:42:16','',''),('8','284',360,'','6.1','1',0.00,1046838.40,'Sales from shift 84 on 2022-12-11 16:42:16 ','2022-12-11 16:42:16','',''),('8','284',361,'','24','3',0.00,13655500.00,'Purchase Id 21 for 44,050.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-12 16:10:28','',''),('8','284',362,'','supplier','1',13655500.00,0.00,'Purchase Id 21 for 44,050.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-12 16:10:28','',''),('8','284',363,'','2','6',4439910.00,0.00,'Payment Id 87 for invoice:83, receipt: 83 by Lausu Energy Resources','2022-12-13 13:05:39','',''),('8','284',364,'','supplier','1',0.00,4439910.00,'Payment Id 87 for invoice:83, receipt: 83 by Lausu Energy Resources','2022-12-13 13:05:39','',''),('8','284',365,'','2','6',2199505.00,0.00,'Payment Id 86 for invoice:82, receipt: 82 by Lausu Energy Resources','2022-12-13 13:05:39','',''),('8','284',366,'','supplier','1',0.00,2199505.00,'Payment Id 86 for invoice:82, receipt: 82 by Lausu Energy Resources','2022-12-13 13:05:39','',''),('8','284',367,'','20','2',2244558.10,0.00,'Sales from shift 85 on 2022-12-14 07:51:28 ','2022-12-14 07:51:28','',''),('8','284',368,'','6.1','1',0.00,2244558.10,'Sales from shift 85 on 2022-12-14 07:51:28 ','2022-12-14 07:51:28','',''),('8','284',369,'','20','2',4216037.20,0.00,'Sales from shift 86 on 2022-12-14 07:59:12 ','2022-12-14 07:59:12','',''),('8','284',370,'','6.1','1',0.00,4216037.20,'Sales from shift 86 on 2022-12-14 07:59:12 ','2022-12-14 07:59:12','',''),('8','284',371,'','20','2',2763417.50,0.00,'Sales from shift 87 on 2022-12-14 08:08:57 ','2022-12-14 08:08:57','',''),('8','284',372,'','6.1','1',0.00,2763417.50,'Sales from shift 87 on 2022-12-14 08:08:57 ','2022-12-14 08:08:57','',''),('8','284',373,'','24','3',0.00,10121500.00,'Purchase Id 22 for 32,650.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-16 17:45:17','',''),('8','284',374,'','supplier','1',10121500.00,0.00,'Purchase Id 22 for 32,650.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-16 17:45:17','',''),('8','284',375,'','20','2',3324337.70,0.00,'Sales from shift 88 on 2022-12-19 08:36:10 ','2022-12-19 08:36:10','',''),('8','284',376,'','6.1','1',0.00,3324337.70,'Sales from shift 88 on 2022-12-19 08:36:10 ','2022-12-19 08:36:10','',''),('8','284',377,'','20','2',1257189.50,0.00,'Sales from shift 89 on 2022-12-19 08:41:24 ','2022-12-19 08:41:24','',''),('8','284',378,'','6.1','1',0.00,1257189.50,'Sales from shift 89 on 2022-12-19 08:41:24 ','2022-12-19 08:41:24','',''),('8','284',379,'','20','2',2450568.60,0.00,'Sales from shift 90 on 2022-12-19 08:50:02 ','2022-12-19 08:50:02','',''),('8','284',380,'','6.1','1',0.00,2450568.60,'Sales from shift 90 on 2022-12-19 08:50:02 ','2022-12-19 08:50:02','',''),('8','284',381,'','20','2',2762199.20,0.00,'Sales from shift 91 on 2022-12-19 08:59:57 ','2022-12-19 08:59:57','',''),('8','284',382,'','6.1','1',0.00,2762199.20,'Sales from shift 91 on 2022-12-19 08:59:57 ','2022-12-19 08:59:57','',''),('8','284',383,'','20','2',2900821.90,0.00,'Sales from shift 92 on 2022-12-19 09:19:37 ','2022-12-19 09:19:37','',''),('8','284',384,'','6.1','1',0.00,2900821.90,'Sales from shift 92 on 2022-12-19 09:19:37 ','2022-12-19 09:19:37','',''),('8','284',385,'','2','6',2762200.00,0.00,'Payment Id 95 for invoice:91, receipt: 91 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',386,'','supplier','1',0.00,2762200.00,'Payment Id 95 for invoice:91, receipt: 91 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',387,'','2','6',2450570.00,0.00,'Payment Id 94 for invoice:90, receipt: 90 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',388,'','supplier','1',0.00,2450570.00,'Payment Id 94 for invoice:90, receipt: 90 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',389,'','2','6',3324340.00,0.00,'Payment Id 92 for invoice:88, receipt: 88 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',390,'','supplier','1',0.00,3324340.00,'Payment Id 92 for invoice:88, receipt: 88 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',391,'','2','6',2763420.00,0.00,'Payment Id 91 for invoice:87, receipt: 87 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',392,'','supplier','1',0.00,2763420.00,'Payment Id 91 for invoice:87, receipt: 87 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',393,'','2','6',4216040.00,0.00,'Payment Id 90 for invoice:86, receipt: 86 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',394,'','supplier','1',0.00,4216040.00,'Payment Id 90 for invoice:86, receipt: 86 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',395,'','2','6',2244560.00,0.00,'Payment Id 89 for invoice:85, receipt: 85 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',396,'','supplier','1',0.00,2244560.00,'Payment Id 89 for invoice:85, receipt: 85 by Lausu Energy Resources','2022-12-19 14:31:12','',''),('8','284',397,'','2','6',1092915.00,0.00,'Payment Id 88 for invoice:84, receipt: 84 by Lausu Energy Resources','2022-12-19 14:34:34','',''),('8','284',398,'','supplier','1',0.00,1092915.00,'Payment Id 88 for invoice:84, receipt: 84 by Lausu Energy Resources','2022-12-19 14:34:34','',''),('8','284',399,'','2','6',1257190.00,0.00,'Payment Id 93 for invoice:89, receipt: 89 by Lausu Energy Resources','2022-12-19 14:38:31','',''),('8','284',400,'','supplier','1',0.00,1257190.00,'Payment Id 93 for invoice:89, receipt: 89 by Lausu Energy Resources','2022-12-19 14:38:31','',''),('8','284',401,'','20','2',1771814.30,0.00,'Sales from shift 93 on 2022-12-20 08:07:47 ','2022-12-20 08:07:47','',''),('8','284',402,'','6.1','1',0.00,1771814.30,'Sales from shift 93 on 2022-12-20 08:07:47 ','2022-12-20 08:07:47','',''),('8','284',403,'','24','3',0.00,9500750.00,'Purchase Id 23 for 31,150.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-20 20:47:08','',''),('8','284',404,'','supplier','1',9500750.00,0.00,'Purchase Id 23 for 31,150.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-20 20:47:08','',''),('8','284',405,'','20','2',2274935.00,0.00,'Sales from shift 94 on 2022-12-22 09:28:53 ','2022-12-22 09:28:53','',''),('8','284',406,'','6.1','1',0.00,2274935.00,'Sales from shift 94 on 2022-12-22 09:28:53 ','2022-12-22 09:28:53','',''),('8','284',407,'','20','2',2659651.20,0.00,'Sales from shift 95 on 2022-12-22 09:34:07 ','2022-12-22 09:34:07','',''),('8','284',408,'','6.1','1',0.00,2659651.20,'Sales from shift 95 on 2022-12-22 09:34:07 ','2022-12-22 09:34:07','',''),('8','284',409,'','20','2',2325576.60,0.00,'Sales from shift 96 on 2022-12-25 09:29:44 ','2022-12-25 09:29:44','',''),('8','284',410,'','6.1','1',0.00,2325576.60,'Sales from shift 96 on 2022-12-25 09:29:44 ','2022-12-25 09:29:44','',''),('8','284',411,'','20','2',1639053.70,0.00,'Sales from shift 97 on 2022-12-25 09:35:38 ','2022-12-25 09:35:38','',''),('8','284',412,'','6.1','1',0.00,1639053.70,'Sales from shift 97 on 2022-12-25 09:35:38 ','2022-12-25 09:35:38','',''),('8','284',413,'','24','3',0.00,5270000.00,'Purchase Id 24 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-29 13:00:58','',''),('8','284',414,'','supplier','1',5270000.00,0.00,'Purchase Id 24 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-29 13:00:58','',''),('8','284',415,'','2','6',2325575.00,0.00,'Payment Id 100 for invoice:96, receipt: 96 by Lausu Energy Resources','2022-12-29 13:02:09','',''),('8','284',416,'','supplier','1',0.00,2325575.00,'Payment Id 100 for invoice:96, receipt: 96 by Lausu Energy Resources','2022-12-29 13:02:09','',''),('8','284',417,'','2','6',1771815.00,0.00,'Payment Id 97 for invoice:93, receipt: 93 by Lausu Energy Resources','2022-12-29 13:02:09','',''),('8','284',418,'','supplier','1',0.00,1771815.00,'Payment Id 97 for invoice:93, receipt: 93 by Lausu Energy Resources','2022-12-29 13:02:09','',''),('8','284',419,'','2','6',2900820.00,0.00,'Payment Id 96 for invoice:92, receipt: 92 by Lausu Energy Resources','2022-12-29 13:02:09','',''),('8','284',420,'','supplier','1',0.00,2900820.00,'Payment Id 96 for invoice:92, receipt: 92 by Lausu Energy Resources','2022-12-29 13:02:09','',''),('8','284',421,'','2','6',2274935.00,0.00,'Payment Id 98 for invoice:94, receipt: 94 by Lausu Energy Resources','2022-12-29 13:07:54','',''),('8','284',422,'','supplier','1',0.00,2274935.00,'Payment Id 98 for invoice:94, receipt: 94 by Lausu Energy Resources','2022-12-29 13:07:54','',''),('8','284',423,'','2','6',2659650.00,0.00,'Payment Id 99 for invoice:95, receipt: 95 by Lausu Energy Resources','2022-12-29 13:08:46','',''),('8','284',424,'','supplier','1',0.00,2659650.00,'Payment Id 99 for invoice:95, receipt: 95 by Lausu Energy Resources','2022-12-29 13:08:46','',''),('8','284',425,'','20','2',1005522.20,0.00,'Sales from shift 98 on 2022-12-30 12:10:46 ','2022-12-30 12:10:46','',''),('8','284',426,'','6.1','1',0.00,1005522.20,'Sales from shift 98 on 2022-12-30 12:10:46 ','2022-12-30 12:10:46','',''),('8','284',427,'','20','2',929569.10,0.00,'Sales from shift 99 on 2022-12-30 12:22:44 ','2022-12-30 12:22:44','',''),('8','284',428,'','6.1','1',0.00,929569.10,'Sales from shift 99 on 2022-12-30 12:22:44 ','2022-12-30 12:22:44','',''),('8','284',429,'','20','2',1433622.90,0.00,'Sales from shift 100 on 2022-12-30 12:28:27 ','2022-12-30 12:28:27','',''),('8','284',430,'','6.1','1',0.00,1433622.90,'Sales from shift 100 on 2022-12-30 12:28:27 ','2022-12-30 12:28:27','',''),('8','284',431,'','20','2',807122.20,0.00,'Sales from shift 101 on 2022-12-30 12:38:51 ','2022-12-30 12:38:51','',''),('8','284',432,'','6.1','1',0.00,807122.20,'Sales from shift 101 on 2022-12-30 12:38:51 ','2022-12-30 12:38:51','',''),('8','284',433,'','20','2',1054341.00,0.00,'Sales from shift 102 on 2022-12-30 12:42:55 ','2022-12-30 12:42:55','',''),('8','284',434,'','6.1','1',0.00,1054341.00,'Sales from shift 102 on 2022-12-30 12:42:55 ','2022-12-30 12:42:55','',''),('8','284',435,'','2','6',1005525.00,0.00,'Payment Id 102 for invoice:98, receipt: 98 by Lausu Energy Resources','2023-01-02 14:51:14','',''),('8','284',436,'','supplier','1',0.00,1005525.00,'Payment Id 102 for invoice:98, receipt: 98 by Lausu Energy Resources','2023-01-02 14:51:14','',''),('8','284',437,'','2','6',929570.00,0.00,'Payment Id 103 for invoice:99, receipt: 99 by Lausu Energy Resources','2023-01-02 14:51:34','',''),('8','284',438,'','supplier','1',0.00,929570.00,'Payment Id 103 for invoice:99, receipt: 99 by Lausu Energy Resources','2023-01-02 14:51:34','',''),('8','284',439,'','2','6',1639055.00,0.00,'Payment Id 101 for invoice:97, receipt: 97 by Lausu Energy Resources','2023-01-02 14:52:14','',''),('8','284',440,'','supplier','1',0.00,1639055.00,'Payment Id 101 for invoice:97, receipt: 97 by Lausu Energy Resources','2023-01-02 14:52:14','',''),('8','284',441,'','2','6',1433620.00,0.00,'Payment Id 104 for invoice:100, receipt: 100 by Lausu Energy Resources','2023-01-02 14:54:04','',''),('8','284',442,'','supplier','1',0.00,1433620.00,'Payment Id 104 for invoice:100, receipt: 100 by Lausu Energy Resources','2023-01-02 14:54:04','',''),('8','284',443,'','24','3',0.00,14542400.00,'Purchase Id 25 for 48,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-06 09:42:06','',''),('8','284',444,'','supplier','1',14542400.00,0.00,'Purchase Id 25 for 48,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-06 09:42:06','',''),('8','284',445,'','20','2',990146.20,0.00,'Sales from shift 103 on 2023-01-07 11:03:45 ','2023-01-07 11:03:45','',''),('8','284',446,'','6.1','1',0.00,990146.20,'Sales from shift 103 on 2023-01-07 11:03:45 ','2023-01-07 11:03:45','',''),('8','284',447,'','20','2',1062465.36,0.00,'Sales from shift 104 on 2023-01-07 11:08:27 ','2023-01-07 11:08:27','',''),('8','284',448,'','6.1','1',0.00,1062465.36,'Sales from shift 104 on 2023-01-07 11:08:27 ','2023-01-07 11:08:27','',''),('8','284',449,'','20','2',1438651.62,0.00,'Sales from shift 105 on 2023-01-07 11:13:33 ','2023-01-07 11:13:33','',''),('8','284',450,'','6.1','1',0.00,1438651.62,'Sales from shift 105 on 2023-01-07 11:13:33 ','2023-01-07 11:13:33','',''),('8','284',451,'','20','2',0.00,0.00,'Sales from shift 106 on 2023-01-08 07:32:47 ','2023-01-08 07:32:47','',''),('8','284',452,'','6.1','1',0.00,0.00,'Sales from shift 106 on 2023-01-08 07:32:47 ','2023-01-08 07:32:47','',''),('8','284',453,'','20','2',1379412.20,0.00,'Sales from shift 107 on 2023-01-09 22:18:23 ','2023-01-09 22:18:23','',''),('8','284',454,'','6.1','1',0.00,1379412.20,'Sales from shift 107 on 2023-01-09 22:18:23 ','2023-01-09 22:18:23','',''),('8','284',455,'','20','2',1515523.70,0.00,'Sales from shift 108 on 2023-01-09 22:25:13 ','2023-01-09 22:25:13','',''),('8','284',456,'','6.1','1',0.00,1515523.70,'Sales from shift 108 on 2023-01-09 22:25:13 ','2023-01-09 22:25:13','',''),('8','284',457,'','20','2',1283506.86,0.00,'Sales from shift 109 on 2023-01-09 22:31:48 ','2023-01-09 22:31:48','',''),('8','284',458,'','6.1','1',0.00,1283506.86,'Sales from shift 109 on 2023-01-09 22:31:48 ','2023-01-09 22:31:48','',''),('8','284',459,'','20','2',0.00,0.00,'Sales from shift 110 on 2023-01-12 15:45:13 ','2023-01-12 15:45:13','',''),('8','284',460,'','6.1','1',0.00,0.00,'Sales from shift 110 on 2023-01-12 15:45:13 ','2023-01-12 15:45:13','',''),('8','284',461,'','20','2',3005601.18,0.00,'Sales from shift 111 on 2023-01-12 15:51:54 ','2023-01-12 15:51:54','',''),('8','284',462,'','6.1','1',0.00,3005601.18,'Sales from shift 111 on 2023-01-12 15:51:54 ','2023-01-12 15:51:54','',''),('8','284',463,'','20','2',1283572.42,0.00,'Sales from shift 112 on 2023-01-12 15:57:36 ','2023-01-12 15:57:36','',''),('8','284',464,'','6.1','1',0.00,1283572.42,'Sales from shift 112 on 2023-01-12 15:57:36 ','2023-01-12 15:57:36','',''),('8','284',465,'','2','6',1515525.00,0.00,'Payment Id 110 for invoice:108, receipt: 108 by Lausu Energy Resources','2023-01-13 19:11:12','',''),('8','284',466,'','supplier','1',0.00,1515525.00,'Payment Id 110 for invoice:108, receipt: 108 by Lausu Energy Resources','2023-01-13 19:11:12','',''),('8','284',467,'','2','6',1438655.00,0.00,'Payment Id 108 for invoice:105, receipt: 105 by Lausu Energy Resources','2023-01-13 19:43:45','',''),('8','284',468,'','supplier','1',0.00,1438655.00,'Payment Id 108 for invoice:105, receipt: 105 by Lausu Energy Resources','2023-01-13 19:43:45','',''),('8','284',469,'','2','6',1001305.00,0.00,'Payment Id 106 for invoice:103, receipt: 103 by Lausu Energy Resources','2023-01-13 19:43:45','',''),('8','284',470,'','supplier','1',0.00,1001305.00,'Payment Id 106 for invoice:103, receipt: 103 by Lausu Energy Resources','2023-01-13 19:43:45','',''),('8','284',471,'','20','2',1568284.60,0.00,'Sales from shift 113 on 2023-01-14 21:22:45 ','2023-01-14 21:22:45','',''),('8','284',472,'','6.1','1',0.00,1568284.60,'Sales from shift 113 on 2023-01-14 21:22:45 ','2023-01-14 21:22:45','',''),('8','284',473,'','20','2',1459806.64,0.00,'Sales from shift 114 on 2023-01-14 21:30:01 ','2023-01-14 21:30:01','',''),('8','284',474,'','6.1','1',0.00,1459806.64,'Sales from shift 114 on 2023-01-14 21:30:01 ','2023-01-14 21:30:01','',''),('8','284',475,'','2','6',1459805.00,0.00,'Payment Id 115 for invoice:114, receipt: 114 by Lausu Energy Resources','2023-01-15 22:45:00','',''),('8','284',476,'','supplier','1',0.00,1459805.00,'Payment Id 115 for invoice:114, receipt: 114 by Lausu Energy Resources','2023-01-15 22:45:00','',''),('8','284',477,'','2','6',3005610.00,0.00,'Payment Id 112 for invoice:111, receipt: 111 by Lausu Energy Resources','2023-01-15 22:49:57','',''),('8','284',478,'','supplier','1',0.00,3005610.00,'Payment Id 112 for invoice:111, receipt: 111 by Lausu Energy Resources','2023-01-15 22:49:57','',''),('8','284',479,'','2','6',1283500.00,0.00,'Payment Id 111 for invoice:109, receipt: 109 by Lausu Energy Resources','2023-01-15 22:49:57','',''),('8','284',480,'','supplier','1',0.00,1283500.00,'Payment Id 111 for invoice:109, receipt: 109 by Lausu Energy Resources','2023-01-15 22:49:57','',''),('8','284',481,'','2','6',1568295.00,0.00,'Payment Id 114 for invoice:113, receipt: 13 by Lausu Energy Resources','2023-01-15 22:54:57','',''),('8','284',482,'','supplier','1',0.00,1568295.00,'Payment Id 114 for invoice:113, receipt: 13 by Lausu Energy Resources','2023-01-15 22:54:57','',''),('8','284',483,'','2','6',1283620.00,0.00,'Payment Id 113 for invoice:112, receipt: 112 by Lausu Energy Resources','2023-01-15 22:54:57','',''),('8','284',484,'','supplier','1',0.00,1283620.00,'Payment Id 113 for invoice:112, receipt: 112 by Lausu Energy Resources','2023-01-15 22:54:57','',''),('8','284',485,'','24','3',0.00,14602000.00,'Purchase Id 26 for 49,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-18 14:44:16','',''),('8','284',486,'','supplier','1',14602000.00,0.00,'Purchase Id 26 for 49,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-18 14:44:16','',''),('8','284',487,'','20','2',509618.74,0.00,'Sales from shift 115 on 2023-01-20 12:43:11 ','2023-01-20 12:43:11','',''),('8','284',488,'','6.1','1',0.00,509618.74,'Sales from shift 115 on 2023-01-20 12:43:11 ','2023-01-20 12:43:11','',''),('8','284',489,'','20','2',2359271.96,0.00,'Sales from shift 116 on 2023-01-20 12:50:24 ','2023-01-20 12:50:24','',''),('8','284',490,'','6.1','1',0.00,2359271.96,'Sales from shift 116 on 2023-01-20 12:50:24 ','2023-01-20 12:50:24','',''),('8','284',491,'','20','2',2457862.28,0.00,'Sales from shift 117 on 2023-01-20 12:57:12 ','2023-01-20 12:57:12','',''),('8','284',492,'','6.1','1',0.00,2457862.28,'Sales from shift 117 on 2023-01-20 12:57:12 ','2023-01-20 12:57:12','',''),('8','284',493,'','20','2',1430418.00,0.00,'Sales from shift 118 on 2023-01-20 13:02:25 ','2023-01-20 13:02:25','',''),('8','284',494,'','6.1','1',0.00,1430418.00,'Sales from shift 118 on 2023-01-20 13:02:25 ','2023-01-20 13:02:25','',''),('8','284',495,'','20','2',1573275.00,0.00,'Sales from shift 119 on 2023-01-20 13:09:17 ','2023-01-20 13:09:17','',''),('8','284',496,'','6.1','1',0.00,1573275.00,'Sales from shift 119 on 2023-01-20 13:09:17 ','2023-01-20 13:09:17','',''),('8','284',497,'','2','6',509665.00,0.00,'Payment Id 116 for invoice:115, receipt: 115 by Lausu Energy Resources','2023-01-20 14:54:32','',''),('8','284',498,'','supplier','1',0.00,509665.00,'Payment Id 116 for invoice:115, receipt: 115 by Lausu Energy Resources','2023-01-20 14:54:32','',''),('8','284',499,'','2','7',2457860.00,0.00,'Payment Id 118 for invoice:117, receipt: 117 by Lausu Energy Resources','2023-01-20 14:55:05','',''),('8','284',500,'','supplier','1',0.00,2457860.00,'Payment Id 118 for invoice:117, receipt: 117 by Lausu Energy Resources','2023-01-20 14:55:05','',''),('8','284',501,'','2','7',2359270.00,0.00,'Payment Id 117 for invoice:116, receipt: 116 by Lausu Energy Resources','2023-01-20 14:55:05','',''),('8','284',502,'','supplier','1',0.00,2359270.00,'Payment Id 117 for invoice:116, receipt: 116 by Lausu Energy Resources','2023-01-20 14:55:05','',''),('8','284',503,'','2','6',806815.00,0.00,'Payment Id 105 for invoice:101, receipt: 101 by Lausu Energy Resources','2023-01-20 14:56:58','',''),('8','284',504,'','supplier','1',0.00,806815.00,'Payment Id 105 for invoice:101, receipt: 101 by Lausu Energy Resources','2023-01-20 14:56:58','',''),('8','284',505,'','2','6',1064460.00,0.00,'Payment Id 107 for invoice:104, receipt: 104 by Lausu Energy Resources','2023-01-20 14:59:36','',''),('8','284',506,'','supplier','1',0.00,1064460.00,'Payment Id 107 for invoice:104, receipt: 104 by Lausu Energy Resources','2023-01-20 14:59:36','',''),('8','284',507,'','2','7',1573275.00,0.00,'Payment Id 120 for invoice:119, receipt: 119 by Lausu Energy Resources','2023-01-23 15:34:27','',''),('8','284',508,'','supplier','1',0.00,1573275.00,'Payment Id 120 for invoice:119, receipt: 119 by Lausu Energy Resources','2023-01-23 15:34:27','',''),('8','284',509,'','2','7',1430420.00,0.00,'Payment Id 119 for invoice:118, receipt: 118 by Lausu Energy Resources','2023-01-23 15:34:27','',''),('8','284',510,'','supplier','1',0.00,1430420.00,'Payment Id 119 for invoice:118, receipt: 118 by Lausu Energy Resources','2023-01-23 15:34:27','',''),('8','284',511,'','2','6',1379415.00,0.00,'Payment Id 109 for invoice:107, receipt: 107 by Lausu Energy Resources','2023-01-23 15:34:27','',''),('8','284',512,'','supplier','1',0.00,1379415.00,'Payment Id 109 for invoice:107, receipt: 107 by Lausu Energy Resources','2023-01-23 15:34:27','',''),('8','284',513,'','2','6',1943825.00,0.00,'Payment Id 121 for invoice:120, receipt: 120 by Lausu Energy Resources','2023-01-30 15:26:38','',''),('8','284',514,'','supplier','1',0.00,1943825.00,'Payment Id 121 for invoice:120, receipt: 120 by Lausu Energy Resources','2023-01-30 15:26:38','',''),('8','284',515,'','24','3',0.00,11120200.00,'Purchase Id 27 for 32,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-07 12:29:40','',''),('8','284',516,'','supplier','1',11120200.00,0.00,'Purchase Id 27 for 32,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-07 12:29:40','',''),('8','284',517,'','20','2',1934697.00,0.00,'Sales from shift 120 on 2023-02-07 14:57:18 ','2023-02-07 14:57:18','',''),('8','284',518,'','6.1','1',0.00,1934697.00,'Sales from shift 120 on 2023-02-07 14:57:18 ','2023-02-07 14:57:18','',''),('8','284',519,'','20','2',1751748.00,0.00,'Sales from shift 121 on 2023-02-07 15:10:18 ','2023-02-07 15:10:18','',''),('8','284',520,'','6.1','1',0.00,1751748.00,'Sales from shift 121 on 2023-02-07 15:10:18 ','2023-02-07 15:10:18','',''),('8','284',521,'','20','2',1841541.00,0.00,'Sales from shift 122 on 2023-02-07 15:16:50 ','2023-02-07 15:16:50','',''),('8','284',522,'','6.1','1',0.00,1841541.00,'Sales from shift 122 on 2023-02-07 15:16:50 ','2023-02-07 15:16:50','',''),('8','284',523,'','20','2',755700.00,0.00,'Sales from shift 123 on 2023-02-07 15:22:47 ','2023-02-07 15:22:47','',''),('8','284',524,'','6.1','1',0.00,755700.00,'Sales from shift 123 on 2023-02-07 15:22:47 ','2023-02-07 15:22:47','',''),('8','284',525,'','20','2',461913.00,0.00,'Sales from shift 124 on 2023-02-07 15:37:15 ','2023-02-07 15:37:15','',''),('8','284',526,'','6.1','1',0.00,461913.00,'Sales from shift 124 on 2023-02-07 15:37:15 ','2023-02-07 15:37:15','',''),('8','284',527,'','20','2',0.00,0.00,'Sales from shift 125 on 2023-02-07 15:46:46 ','2023-02-07 15:46:46','',''),('8','284',528,'','6.1','1',0.00,0.00,'Sales from shift 125 on 2023-02-07 15:46:46 ','2023-02-07 15:46:46','',''),('8','284',529,'','20','2',0.00,0.00,'Sales from shift 126 on 2023-02-07 15:50:30 ','2023-02-07 15:50:30','',''),('8','284',530,'','6.1','1',0.00,0.00,'Sales from shift 126 on 2023-02-07 15:50:30 ','2023-02-07 15:50:30','',''),('8','284',531,'','20','2',925636.66,0.00,'Sales from shift 127 on 2023-02-07 15:57:27 ','2023-02-07 15:57:27','',''),('8','284',532,'','6.1','1',0.00,925636.66,'Sales from shift 127 on 2023-02-07 15:57:27 ','2023-02-07 15:57:27','',''),('8','284',533,'','20','2',998571.45,0.00,'Sales from shift 129 on 2023-02-08 09:48:19 ','2023-02-08 09:48:19','',''),('8','284',534,'','6.1','1',0.00,998571.45,'Sales from shift 129 on 2023-02-08 09:48:19 ','2023-02-08 09:48:19','',''),('8','284',535,'','20','2',1307870.85,0.00,'Sales from shift 130 on 2023-02-08 10:05:50 ','2023-02-08 10:05:50','',''),('8','284',536,'','6.1','1',0.00,1307870.85,'Sales from shift 130 on 2023-02-08 10:05:50 ','2023-02-08 10:05:50','',''),('8','284',537,'','2','6',1144660.00,0.00,'Payment Id 129 for invoice:131, receipt: 131 by Lausu Energy Resources','2023-02-09 08:49:39','',''),('8','284',538,'','supplier','1',0.00,1144660.00,'Payment Id 129 for invoice:131, receipt: 131 by Lausu Energy Resources','2023-02-09 08:49:39','',''),('8','284',539,'','2','6',1751620.00,0.00,'Payment Id 122 for invoice:121, receipt: 121 by Lausu Energy Resources','2023-02-09 08:49:40','',''),('8','284',540,'','supplier','1',0.00,1751620.00,'Payment Id 122 for invoice:121, receipt: 121 by Lausu Energy Resources','2023-02-09 08:49:40','',''),('8','284',541,'','2','6',1307615.00,0.00,'Payment Id 128 for invoice:130, receipt: 130 by Lausu Energy Resources','2023-02-09 08:53:08','',''),('8','284',542,'','supplier','1',0.00,1307615.00,'Payment Id 128 for invoice:130, receipt: 130 by Lausu Energy Resources','2023-02-09 08:53:08','',''),('8','284',543,'','2','6',998525.00,0.00,'Payment Id 127 for invoice:129, receipt: 129 by Lausu Energy Resources','2023-02-09 08:53:08','',''),('8','284',544,'','supplier','1',0.00,998525.00,'Payment Id 127 for invoice:129, receipt: 129 by Lausu Energy Resources','2023-02-09 08:53:08','',''),('8','284',545,'','2','6',461915.00,0.00,'Payment Id 125 for invoice:124, receipt: 124 by Lausu Energy Resources','2023-02-09 08:53:50','',''),('8','284',546,'','supplier','1',0.00,461915.00,'Payment Id 125 for invoice:124, receipt: 124 by Lausu Energy Resources','2023-02-09 08:53:50','',''),('8','284',547,'','2','6',1841535.00,0.00,'Payment Id 123 for invoice:122, receipt: 122 by Lausu Energy Resources','2023-02-09 08:53:50','',''),('8','284',548,'','supplier','1',0.00,1841535.00,'Payment Id 123 for invoice:122, receipt: 122 by Lausu Energy Resources','2023-02-09 08:53:50','',''),('8','284',549,'','2','6',925935.00,0.00,'Payment Id 126 for invoice:127, receipt: 127 by Lausu Energy Resources','2023-02-09 08:56:41','',''),('8','284',550,'','supplier','1',0.00,925935.00,'Payment Id 126 for invoice:127, receipt: 127 by Lausu Energy Resources','2023-02-09 08:56:41','',''),('8','284',551,'','20','2',1144661.70,0.00,'Sales from shift 131 on 2023-02-11 09:36:35 ','2023-02-11 09:36:35','',''),('8','284',552,'','6.1','1',0.00,1144661.70,'Sales from shift 131 on 2023-02-11 09:36:35 ','2023-02-11 09:36:35','',''),('8','284',553,'','20','2',1362470.55,0.00,'Sales from shift 132 on 2023-02-11 09:44:36 ','2023-02-11 09:44:36','',''),('8','284',554,'','6.1','1',0.00,1362470.55,'Sales from shift 132 on 2023-02-11 09:44:36 ','2023-02-11 09:44:36','',''),('8','284',555,'','20','2',1197615.75,0.00,'Sales from shift 133 on 2023-02-11 09:52:37 ','2023-02-11 09:52:37','',''),('8','284',556,'','6.1','1',0.00,1197615.75,'Sales from shift 133 on 2023-02-11 09:52:37 ','2023-02-11 09:52:37','',''),('8','284',557,'','20','2',2634426.90,0.00,'Sales from shift 134 on 2023-02-11 10:03:26 ','2023-02-11 10:03:26','',''),('8','284',558,'','6.1','1',0.00,2634426.90,'Sales from shift 134 on 2023-02-11 10:03:26 ','2023-02-11 10:03:26','',''),('8','284',559,'','24','3',0.00,10953750.00,'Purchase Id 28 for 31,750.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-16 13:42:45','',''),('8','284',560,'','supplier','1',10953750.00,0.00,'Purchase Id 28 for 31,750.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-16 13:42:45','',''),('8','284',561,'','20','2',1741266.75,0.00,'Sales from shift 135 on 2023-02-18 09:05:42 ','2023-02-18 09:05:42','',''),('8','284',562,'','6.1','1',0.00,1741266.75,'Sales from shift 135 on 2023-02-18 09:05:42 ','2023-02-18 09:05:42','',''),('8','284',563,'','20','2',78045.90,0.00,'Sales from shift 136 on 2023-02-18 09:08:52 ','2023-02-18 09:08:52','',''),('8','284',564,'','6.1','1',0.00,78045.90,'Sales from shift 136 on 2023-02-18 09:08:52 ','2023-02-18 09:08:52','',''),('8','284',565,'','20','2',1891583.25,0.00,'Sales from shift 137 on 2023-02-20 19:44:06 ','2023-02-20 19:44:06','',''),('8','284',566,'','6.1','1',0.00,1891583.25,'Sales from shift 137 on 2023-02-20 19:44:06 ','2023-02-20 19:44:06','',''),('8','284',567,'','20','2',3955245.60,0.00,'Sales from shift 138 on 2023-02-20 20:17:04 ','2023-02-20 20:17:04','',''),('8','284',568,'','6.1','1',0.00,3955245.60,'Sales from shift 138 on 2023-02-20 20:17:04 ','2023-02-20 20:17:04','',''),('8','284',569,'','20','2',1748325.45,0.00,'Sales from shift 139 on 2023-02-20 20:42:41 ','2023-02-20 20:42:41','',''),('8','284',570,'','6.1','1',0.00,1748325.45,'Sales from shift 139 on 2023-02-20 20:42:41 ','2023-02-20 20:42:41','',''),('8','284',571,'','24','3',0.00,15164000.00,'Purchase Id 29 for 44,600.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-20 22:31:08','',''),('8','284',572,'','supplier','1',15164000.00,0.00,'Purchase Id 29 for 44,600.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-20 22:31:08','',''),('8','284',573,'','2','6',1755900.00,0.00,'Payment Id 138 for invoice:140, receipt: 140 by Lausu Energy Resources','2023-02-21 14:16:52','',''),('8','284',574,'','supplier','1',0.00,1755900.00,'Payment Id 138 for invoice:140, receipt: 140 by Lausu Energy Resources','2023-02-21 14:16:52','',''),('8','284',575,'','2','6',1748325.00,0.00,'Payment Id 137 for invoice:139, receipt: 139 by Lausu Energy Resources','2023-02-21 14:16:52','',''),('8','284',576,'','supplier','1',0.00,1748325.00,'Payment Id 137 for invoice:139, receipt: 139 by Lausu Energy Resources','2023-02-21 14:16:52','',''),('8','284',577,'','2','6',3943170.00,0.00,'Payment Id 136 for invoice:138, receipt: 138 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',578,'','supplier','1',0.00,3943170.00,'Payment Id 136 for invoice:138, receipt: 138 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',579,'','2','6',1891585.00,0.00,'Payment Id 135 for invoice:137, receipt: 137 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',580,'','supplier','1',0.00,1891585.00,'Payment Id 135 for invoice:137, receipt: 137 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',581,'','2','6',78045.00,0.00,'Payment Id 134 for invoice:136, receipt: 136 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',582,'','supplier','1',0.00,78045.00,'Payment Id 134 for invoice:136, receipt: 136 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',583,'','2','6',1741265.00,0.00,'Payment Id 133 for invoice:135, receipt: 135 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',584,'','supplier','1',0.00,1741265.00,'Payment Id 133 for invoice:135, receipt: 135 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',585,'','2','6',2634425.00,0.00,'Payment Id 132 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',586,'','supplier','1',0.00,2634425.00,'Payment Id 132 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',587,'','2','6',1197615.00,0.00,'Payment Id 131 for invoice:133, receipt: 133 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',588,'','supplier','1',0.00,1197615.00,'Payment Id 131 for invoice:133, receipt: 133 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',589,'','2','6',1362470.00,0.00,'Payment Id 130 for invoice:132, receipt: 132 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',590,'','supplier','1',0.00,1362470.00,'Payment Id 130 for invoice:132, receipt: 132 by Lausu Energy Resources','2023-02-21 14:16:53','',''),('8','284',591,'','20','2',1755901.65,0.00,'Sales from shift 140 on 2023-02-21 20:22:42 ','2023-02-21 20:22:42','',''),('8','284',592,'','6.1','1',0.00,1755901.65,'Sales from shift 140 on 2023-02-21 20:22:42 ','2023-02-21 20:22:42','',''),('8','284',593,'','20','2',1667643.75,0.00,'Sales from shift 141 on 2023-02-23 23:39:55 ','2023-02-23 23:39:55','',''),('8','284',594,'','6.1','1',0.00,1667643.75,'Sales from shift 141 on 2023-02-23 23:39:55 ','2023-02-23 23:39:55','',''),('8','284',595,'','20','2',1299952.60,0.00,'Sales from shift 142 on 2023-02-23 23:51:42 ','2023-02-23 23:51:42','',''),('8','284',596,'','6.1','1',0.00,1299952.60,'Sales from shift 142 on 2023-02-23 23:51:42 ','2023-02-23 23:51:42','',''),('8','284',597,'','20','2',1026779.60,0.00,'Sales from shift 143 on 2023-02-23 23:58:23 ','2023-02-23 23:58:23','',''),('8','284',598,'','6.1','1',0.00,1026779.60,'Sales from shift 143 on 2023-02-23 23:58:23 ','2023-02-23 23:58:23','',''),('8','284',599,'','20','2',2165715.00,0.00,'Sales from shift 144 on 2023-02-24 00:06:19 ','2023-02-24 00:06:19','',''),('8','284',600,'','6.1','1',0.00,2165715.00,'Sales from shift 144 on 2023-02-24 00:06:19 ','2023-02-24 00:06:19','',''),('8','284',601,'','20','2',981556.20,0.00,'Sales from shift 145 on 2023-02-24 00:12:16 ','2023-02-24 00:12:16','',''),('8','284',602,'','6.1','1',0.00,981556.20,'Sales from shift 145 on 2023-02-24 00:12:16 ','2023-02-24 00:12:16','',''),('8','284',603,'','20','2',1159571.20,0.00,'Sales from shift 146 on 2023-02-24 00:19:27 ','2023-02-24 00:19:27','',''),('8','284',604,'','6.1','1',0.00,1159571.20,'Sales from shift 146 on 2023-02-24 00:19:27 ','2023-02-24 00:19:27','',''),('8','284',605,'','2','6',981555.00,0.00,'Payment Id 143 for invoice:145, receipt: 145 by Lausu Energy Resources','2023-02-24 15:33:08','',''),('8','284',606,'','supplier','1',0.00,981555.00,'Payment Id 143 for invoice:145, receipt: 145 by Lausu Energy Resources','2023-02-24 15:33:08','',''),('8','284',607,'','2','6',2165615.00,0.00,'Payment Id 142 for invoice:144, receipt: 144 by Lausu Energy Resources','2023-02-24 15:33:08','',''),('8','284',608,'','supplier','1',0.00,2165615.00,'Payment Id 142 for invoice:144, receipt: 144 by Lausu Energy Resources','2023-02-24 15:33:08','',''),('8','284',609,'','2','6',1026780.00,0.00,'Payment Id 141 for invoice:143, receipt: 143 by Lausu Energy Resources','2023-02-24 15:33:08','',''),('8','284',610,'','supplier','1',0.00,1026780.00,'Payment Id 141 for invoice:143, receipt: 143 by Lausu Energy Resources','2023-02-24 15:33:08','',''),('8','284',611,'','2','6',1299685.00,0.00,'Payment Id 140 for invoice:142, receipt: 142 by Lausu Energy Resources','2023-02-24 15:33:08','',''),('8','284',612,'','supplier','1',0.00,1299685.00,'Payment Id 140 for invoice:142, receipt: 142 by Lausu Energy Resources','2023-02-24 15:33:08','',''),('8','284',613,'','2','6',1667645.00,0.00,'Payment Id 139 for invoice:141, receipt: 141 by Lausu Energy Resources','2023-02-24 15:33:30','',''),('8','284',614,'','supplier','1',0.00,1667645.00,'Payment Id 139 for invoice:141, receipt: 141 by Lausu Energy Resources','2023-02-24 15:33:30','',''),('8','284',615,'','20','2',1215625.60,0.00,'Sales from shift 147 on 2023-02-24 23:19:32 ','2023-02-24 23:19:32','',''),('8','284',616,'','6.1','1',0.00,1215625.60,'Sales from shift 147 on 2023-02-24 23:19:32 ','2023-02-24 23:19:32','',''),('8','284',617,'','20','2',1082021.85,0.00,'Sales from shift 148 on 2023-02-27 10:55:47 ','2023-02-27 10:55:47','',''),('8','284',618,'','6.1','1',0.00,1082021.85,'Sales from shift 148 on 2023-02-27 10:55:47 ','2023-02-27 10:55:47','',''),('8','284',619,'','20','2',876862.35,0.00,'Sales from shift 149 on 2023-02-27 11:03:57 ','2023-02-27 11:03:57','',''),('8','284',620,'','6.1','1',0.00,876862.35,'Sales from shift 149 on 2023-02-27 11:03:57 ','2023-02-27 11:03:57','',''),('8','284',621,'','2','6',876865.00,0.00,'Payment Id 147 for invoice:149, receipt: 149 by Lausu Energy Resources','2023-03-01 13:19:22','',''),('8','284',622,'','supplier','1',0.00,876865.00,'Payment Id 147 for invoice:149, receipt: 149 by Lausu Energy Resources','2023-03-01 13:19:22','',''),('8','284',623,'','2','6',1082020.00,0.00,'Payment Id 146 for invoice:148, receipt: 148 by Lausu Energy Resources','2023-03-01 13:19:22','',''),('8','284',624,'','supplier','1',0.00,1082020.00,'Payment Id 146 for invoice:148, receipt: 148 by Lausu Energy Resources','2023-03-01 13:19:22','',''),('8','284',625,'','2','6',1215645.00,0.00,'Payment Id 145 for invoice:147, receipt: 147 by Lausu Energy Resources','2023-03-01 13:28:50','',''),('8','284',626,'','supplier','1',0.00,1215645.00,'Payment Id 145 for invoice:147, receipt: 147 by Lausu Energy Resources','2023-03-01 13:28:50','',''),('8','284',627,'','2','6',1159570.00,0.00,'Payment Id 144 for invoice:146, receipt: 146 by Lausu Energy Resources','2023-03-01 13:28:50','',''),('8','284',628,'','supplier','1',0.00,1159570.00,'Payment Id 144 for invoice:146, receipt: 146 by Lausu Energy Resources','2023-03-01 13:28:50','',''),('8','284',629,'','24','3',0.00,10332000.00,'Purchase Id 30 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-01 14:38:11','',''),('8','284',630,'','supplier','1',10332000.00,0.00,'Purchase Id 30 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-01 14:38:11','',''),('8','284',631,'','20','2',2541079.80,0.00,'Sales from shift 150 on 2023-03-02 11:10:52 ','2023-03-02 11:10:52','',''),('8','284',632,'','6.1','1',0.00,2541079.80,'Sales from shift 150 on 2023-03-02 11:10:52 ','2023-03-02 11:10:52','',''),('8','284',633,'','20','2',1782950.40,0.00,'Sales from shift 151 on 2023-03-02 11:16:54 ','2023-03-02 11:16:54','',''),('8','284',634,'','6.1','1',0.00,1782950.40,'Sales from shift 151 on 2023-03-02 11:16:54 ','2023-03-02 11:16:54','',''),('8','284',635,'','20','2',1336053.60,0.00,'Sales from shift 152 on 2023-03-02 11:23:13 ','2023-03-02 11:23:13','',''),('8','284',636,'','6.1','1',0.00,1336053.60,'Sales from shift 152 on 2023-03-02 11:23:13 ','2023-03-02 11:23:13','',''),('8','284',637,'','2','6',1336055.00,0.00,'Payment Id 150 for invoice:152, receipt: 152 by Lausu Energy Resources','2023-03-03 13:24:33','',''),('8','284',638,'','supplier','1',0.00,1336055.00,'Payment Id 150 for invoice:152, receipt: 152 by Lausu Energy Resources','2023-03-03 13:24:33','',''),('8','284',639,'','2','6',1782950.00,0.00,'Payment Id 149 for invoice:151, receipt: 151 by Lausu Energy Resources','2023-03-03 13:24:33','',''),('8','284',640,'','supplier','1',0.00,1782950.00,'Payment Id 149 for invoice:151, receipt: 151 by Lausu Energy Resources','2023-03-03 13:24:33','',''),('8','284',641,'','2','6',2541080.00,0.00,'Payment Id 148 for invoice:150, receipt: 150 by Lausu Energy Resources','2023-03-03 13:24:33','',''),('8','284',642,'','supplier','1',0.00,2541080.00,'Payment Id 148 for invoice:150, receipt: 150 by Lausu Energy Resources','2023-03-03 13:24:33','',''),('8','284',643,'','20','2',1107706.95,0.00,'Sales from shift 153 on 2023-03-04 09:22:46 ','2023-03-04 09:22:46','',''),('8','284',644,'','6.1','1',0.00,1107706.95,'Sales from shift 153 on 2023-03-04 09:22:46 ','2023-03-04 09:22:46','',''),('8','284',645,'','20','2',931908.00,0.00,'Sales from shift 154 on 2023-03-06 12:19:55 ','2023-03-06 12:19:55','',''),('8','284',646,'','6.1','1',0.00,931908.00,'Sales from shift 154 on 2023-03-06 12:19:55 ','2023-03-06 12:19:55','',''),('8','284',647,'','20','2',1200546.00,0.00,'Sales from shift 155 on 2023-03-06 12:24:03 ','2023-03-06 12:24:03','',''),('8','284',648,'','6.1','1',0.00,1200546.00,'Sales from shift 155 on 2023-03-06 12:24:03 ','2023-03-06 12:24:03','',''),('8','284',649,'','20','2',1259295.00,0.00,'Sales from shift 156 on 2023-03-08 08:50:39 ','2023-03-08 08:50:39','',''),('8','284',650,'','6.1','1',0.00,1259295.00,'Sales from shift 156 on 2023-03-08 08:50:39 ','2023-03-08 08:50:39','',''),('8','284',651,'','20','2',2983506.00,0.00,'Sales from shift 157 on 2023-03-08 09:02:12 ','2023-03-08 09:02:12','',''),('8','284',652,'','6.1','1',0.00,2983506.00,'Sales from shift 157 on 2023-03-08 09:02:12 ','2023-03-08 09:02:12','',''),('8','284',653,'','2','6',1259295.00,0.00,'Payment Id 154 for invoice:156, receipt: 156 by Lausu Energy Resources','2023-03-09 13:09:19','',''),('8','284',654,'','supplier','1',0.00,1259295.00,'Payment Id 154 for invoice:156, receipt: 156 by Lausu Energy Resources','2023-03-09 13:09:19','',''),('8','284',655,'','2','6',1200545.00,0.00,'Payment Id 153 for invoice:155, receipt: 155 by Lausu Energy Resources','2023-03-09 13:09:19','',''),('8','284',656,'','supplier','1',0.00,1200545.00,'Payment Id 153 for invoice:155, receipt: 155 by Lausu Energy Resources','2023-03-09 13:09:19','',''),('8','284',657,'','2','6',1107705.00,0.00,'Payment Id 151 for invoice:153, receipt: 153 by Lausu Energy Resources','2023-03-09 13:09:19','',''),('8','284',658,'','supplier','1',0.00,1107705.00,'Payment Id 151 for invoice:153, receipt: 153 by Lausu Energy Resources','2023-03-09 13:09:19','',''),('8','284',659,'','24','3',0.00,5040000.00,'Purchase Id 31 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-13 12:18:42','',''),('8','284',660,'','supplier','1',5040000.00,0.00,'Purchase Id 31 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-13 12:18:42','',''),('8','284',661,'','2','6',2983505.00,0.00,'Payment Id 155 for invoice:157, receipt: 157 by Lausu Energy Resources','2023-03-13 12:20:52','',''),('8','284',662,'','supplier','1',0.00,2983505.00,'Payment Id 155 for invoice:157, receipt: 157 by Lausu Energy Resources','2023-03-13 12:20:52','',''),('8','284',663,'','2','6',931910.00,0.00,'Payment Id 152 for invoice:154, receipt: 154 by Lausu Energy Resources','2023-03-13 12:22:58','',''),('8','284',664,'','supplier','1',0.00,931910.00,'Payment Id 152 for invoice:154, receipt: 154 by Lausu Energy Resources','2023-03-13 12:22:58','',''),('8','284',665,'','20','2',1374702.00,0.00,'Sales from shift 158 on 2023-03-15 16:39:45 ','2023-03-15 16:39:45','',''),('8','284',666,'','6.1','1',0.00,1374702.00,'Sales from shift 158 on 2023-03-15 16:39:45 ','2023-03-15 16:39:45','',''),('8','284',667,'','20','2',1545675.00,0.00,'Sales from shift 159 on 2023-03-15 16:44:12 ','2023-03-15 16:44:12','',''),('8','284',668,'','6.1','1',0.00,1545675.00,'Sales from shift 159 on 2023-03-15 16:44:12 ','2023-03-15 16:44:12','',''),('8','284',669,'','20','2',1985613.00,0.00,'Sales from shift 160 on 2023-03-15 16:52:43 ','2023-03-15 16:52:43','',''),('8','284',670,'','6.1','1',0.00,1985613.00,'Sales from shift 160 on 2023-03-15 16:52:43 ','2023-03-15 16:52:43','',''),('8','284',671,'','24','3',0.00,14835000.00,'Purchase Id 33 for 49,450.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-19 19:34:46','',''),('8','284',672,'','supplier','1',14835000.00,0.00,'Purchase Id 33 for 49,450.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-19 19:34:46','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'8','284','PMS','Petrol','Litres',0,300.00,187.00,187.00,187.00,0.00,0,'2022-09-06 13:55:16','926','926','2022-09-06 13:55:16',0),(2,'8','284','AGO','Diesel','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-09-06 14:06:21','926','926','2022-09-06 14:06:21',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'8','284',1,187.00,0.00,0.00,0.00,'Cost from purchase id #2','2022-09-07 14:00:42','467'),(2,'8','284',1,187.00,187.00,187.00,187.00,'','2022-09-19 17:10:06','926'),(3,'8','284',1,195.00,187.00,0.00,0.00,'Cost from purchase id #6','2022-10-08 22:37:25','927'),(4,'8','284',1,225.00,187.00,0.00,0.00,'Cost from purchase id #7','2022-10-15 13:46:03','927'),(5,'8','284',1,230.00,187.00,0.00,0.00,'Cost from purchase id #8','2022-10-20 11:31:29','927'),(6,'8','284',1,235.00,187.00,0.00,0.00,'Cost from purchase id #9','2022-10-25 12:18:42','927'),(7,'8','284',1,250.00,187.00,0.00,0.00,'Cost from purchase id #10','2022-11-03 14:04:42','927'),(8,'8','284',1,255.00,187.00,0.00,0.00,'Cost from purchase id #15','2022-11-15 22:24:47','927'),(9,'8','284',1,257.00,187.00,0.00,0.00,'Cost from purchase id #17','2022-11-24 11:33:21','927'),(10,'8','284',1,260.00,187.00,0.00,0.00,'Cost from purchase id #19','2022-12-02 08:28:18','927'),(11,'8','284',1,270.00,187.00,0.00,0.00,'Cost from purchase id #20','2022-12-06 10:24:36','927'),(12,'8','284',1,310.00,187.00,0.00,0.00,'Cost from purchase id #21','2022-12-12 16:10:28','927'),(13,'8','284',1,298.00,187.00,0.00,0.00,'Cost from purchase id #25','2023-01-06 09:42:06','927'),(14,'8','284',1,338.00,187.00,0.00,0.00,'Cost from purchase id #27','2023-02-07 12:29:40','927'),(15,'8','284',1,345.00,187.00,0.00,0.00,'Cost from purchase id #28','2023-02-16 13:42:45','927'),(16,'8','284',1,340.00,187.00,0.00,0.00,'Cost from purchase id #29','2023-02-20 22:31:08','927'),(17,'8','284',1,315.00,187.00,0.00,0.00,'Cost from purchase id #30','2023-03-01 14:38:11','927'),(18,'8','284',1,300.00,187.00,0.00,0.00,'Cost from purchase id #31','2023-03-13 12:18:42','927');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'8','284','2022-09-05',1,1,187.00,50000.00,0.00,0.00,9350000.00,0.00,'','001','RAN869XA','','','','2022-09-06 14:57:56',15,'Purchase of Pms','952','','0000-00-00 00:00:00','467','2022-09-07 14:01:12'),(2,'8','284','2022-09-05',1,1,187.00,50000.00,0.00,0.00,9350000.00,0.00,'','002','NSR56ZQ','','','','2022-09-06 15:02:34',15,'Purchases of pns','952','','0000-00-00 00:00:00','467','2022-09-07 14:00:42'),(3,'8','284','2022-09-19',1,1,187.00,49000.00,0.00,0.00,9163000.00,0.00,'','003','NSR57ZQ','','','','2022-09-19 10:18:25',15,'Purchase of pms','952','','0000-00-00 00:00:00','467','2022-09-19 12:29:52'),(4,'8','284','2022-09-26',1,1,187.00,49200.00,0.00,0.00,9200400.00,0.00,'','004','NSR435ZS','','','','2022-09-27 15:15:51',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-09-28 10:08:48'),(5,'8','284','2022-10-04',1,1,187.00,50000.00,0.00,0.00,9350000.00,0.00,'','005','NSR572ZX','','','','2022-10-07 14:19:26',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-10-07 14:38:32'),(6,'8','284','2022-10-08',1,1,195.00,50000.00,0.00,0.00,9750000.00,0.00,'','006','RAN683XA','','','','2022-10-08 22:35:09',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-10-08 22:37:25'),(7,'8','284','2022-10-14',1,1,225.00,49900.00,0.00,0.00,11227500.00,0.00,'','007','NRS433ZS','','','','2022-10-14 10:33:49',15,'Purchase of the','952','','0000-00-00 00:00:00','927','2022-10-15 13:46:03'),(8,'8','284','2022-10-20',1,1,230.00,18000.00,0.00,0.00,4140000.00,0.00,'','008','WDL813XA','','','','2022-10-20 11:11:24',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-10-20 11:31:29'),(9,'8','284','2022-10-25',1,1,235.00,16800.00,0.00,0.00,3948000.00,0.00,'','008','RAN869XA','','','','2022-10-25 12:02:44',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-10-25 12:18:42'),(10,'8','284','2022-11-02',1,1,250.00,44700.00,0.00,0.00,11175000.00,0.00,'','009','RXH266ZA','','','','2022-11-03 14:00:44',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-11-03 14:04:42'),(11,'8','284','2022-11-04',1,1,250.00,17000.00,0.00,0.00,4250000.00,0.00,'','010','RAN31XF','','','','2022-11-06 18:50:57',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-11-06 19:13:25'),(12,'8','284','2022-11-08',1,1,250.00,32000.00,0.00,0.00,8000000.00,0.00,'','11','NSR435ZS','','','','2022-11-09 15:59:56',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-11-10 22:03:46'),(13,'8','284','2022-11-13',1,1,250.00,32800.00,0.00,0.00,8200000.00,0.00,'','12','BCH428XA','','','','2022-11-13 10:32:42',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-11-14 08:08:48'),(15,'8','284','2022-11-15',1,1,255.00,16650.00,0.00,0.00,4245750.00,0.00,'','14','RAN683XA','','','','2022-11-15 16:53:23',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-11-15 22:24:47'),(16,'8','284','2022-11-16',1,1,255.00,32700.00,0.00,0.00,8338500.00,0.00,'','14','BCH428XA','','','','2022-11-17 08:05:34',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-11-17 11:23:30'),(17,'8','284','2022-11-22',1,1,257.00,32000.00,0.00,0.00,8224000.00,0.00,'','17','WDL813XA','','','','2022-11-23 17:40:03',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-11-24 11:33:21'),(18,'8','284','2022-11-25',1,1,257.00,34000.00,0.00,0.00,8738000.00,0.00,'','18','TRN44YZ','','','','2022-11-26 14:14:21',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-11-27 09:29:05'),(19,'8','284','2022-11-30',1,1,260.00,18000.00,0.00,0.00,4680000.00,0.00,'','19','NSR435ZS','','','','2022-12-01 12:32:40',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-12-02 08:28:18'),(20,'8','284','2022-12-05',1,1,270.00,33000.00,0.00,0.00,8580000.00,0.00,'','20','RAN32XF','','','','2022-12-06 06:57:39',15,'Purchase of pms','952','927','2022-12-06 10:24:19','927','2022-12-06 10:24:36'),(21,'8','284','2022-12-11',1,1,310.00,44050.00,0.00,0.00,13655500.00,0.00,'','21','RBC619ZX','','','','2022-12-11 16:40:46',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-12-12 16:10:28'),(22,'8','284','2022-12-15',1,1,310.00,32650.00,0.00,0.00,10121500.00,0.00,'','22','BCH424XA','','','','2022-12-16 17:40:31',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-12-16 17:45:17'),(23,'8','284','2022-12-19',1,1,310.00,31150.00,0.00,0.00,9500750.00,0.00,'','23','WDL813XA','','','','2022-12-20 08:11:03',15,'Purchase of pms','952','927','2022-12-20 20:46:36','927','2022-12-20 20:47:08'),(24,'8','284','2022-12-23',1,1,310.00,17000.00,0.00,0.00,5270000.00,0.00,'','24','RAN33XF','','','','2022-12-27 18:00:27',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-12-29 13:00:58'),(25,'8','284','2023-01-06',1,1,298.00,48800.00,0.00,0.00,14542400.00,0.00,'','25','NSR57ZQ','','','','2023-01-06 08:35:42',15,'Purchase of the pms','952','','0000-00-00 00:00:00','927','2023-01-06 09:42:06'),(26,'8','284','2023-01-16',1,1,298.00,49000.00,0.00,0.00,14602000.00,0.00,'','26','DKA705ZP','','','','2023-01-17 09:53:38',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2023-01-18 14:44:16'),(27,'8','284','2023-01-31',1,1,338.00,32900.00,0.00,0.00,11120200.00,0.00,'','26','RAN33XF','','','','2023-02-07 09:25:03',15,'Purchase of the pms','952','','0000-00-00 00:00:00','927','2023-02-07 12:29:40'),(28,'8','284','2023-02-11',1,1,345.00,31750.00,0.00,0.00,10953750.00,0.00,'','28','RAN31XF','','','','2023-02-11 10:11:37',15,'Purchase of pms','952','927','2023-02-16 13:42:23','927','2023-02-16 13:42:45'),(29,'8','284','2023-02-17',1,1,340.00,44600.00,0.00,0.00,15164000.00,0.00,'','29','KWL63AZ','','','','2023-02-18 09:12:59',15,'Purchase of pms','952','','0000-00-00 00:00:00','927','2023-02-20 22:31:08'),(30,'8','284','2023-02-23',1,1,315.00,32800.00,0.00,0.00,10332000.00,0.00,'','27','BCH424XA','','','','2023-03-01 14:08:58',15,'Purchase of the pms','952','','0000-00-00 00:00:00','927','2023-03-01 14:38:11'),(31,'8','284','2023-03-12',1,1,300.00,16800.00,0.00,0.00,5040000.00,0.00,'','31','BCH428XA','','','','2023-03-12 09:43:08',15,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-13 12:18:42'),(33,'8','284','2023-03-16',1,1,300.00,49450.00,0.00,0.00,14835000.00,0.00,'','32','NSR435ZS','','','','2023-03-16 23:11:40',5,'Purchase of the pms','952','','0000-00-00 00:00:00','927','2023-03-19 19:34:46');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (5,'8','284','2022-09-07',1,'003','','10',857515.00,'003','','','6','Nazy','003',863954.00,'2022-09-09 17:52:51',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-14 21:39:30'),(6,'8','284','2022-09-06',1,'002','','10',966255.00,'002','','','6','Nazy','002',975966.90,'2022-09-09 18:09:14',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-14 21:39:30'),(11,'8','284','2022-09-05',1,'001','','10',871550.00,'001','','','6','Nazy','001',971199.00,'2022-09-09 22:44:39',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-14 21:39:30'),(12,'8','284','2022-09-08',1,'004','','10',1000000.00,'004','','','6','Nazy','004',1500368.32,'2022-09-09 22:45:58',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-14 21:39:30'),(13,'8','284','2022-09-08',1,'004','','10',509000.00,'004','','','6','Nazy','004',0.00,'2022-09-09 22:47:30',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-14 21:39:30'),(14,'8','284','2022-09-09',1,'005','','10',1143250.00,'005','','','6','Nazy','005',1158248.00,'2022-09-10 15:06:03',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-13 16:57:03'),(15,'8','284','2022-09-10',1,'006','','10',1244310.00,'006','','','6','Nazy','006',1250863.57,'2022-09-11 20:50:25',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-13 16:57:31'),(16,'8','284','2022-09-11',1,'007','','10',924105.00,'007','','','6','Nazy','007',927284.38,'2022-09-12 13:51:35',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-13 16:57:54'),(17,'8','284','2022-09-12',1,'008','','10',1790755.00,'08','','','6','Nazy','008',1790755.01,'2022-09-13 11:51:59',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-13 16:58:13'),(18,'8','284','2022-09-13',1,'009','','10',866175.00,'009','','','6','Nazy','009',862460.83,'2022-09-14 15:08:10',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-14 21:44:48'),(19,'8','284','2022-09-14',1,'010','','10',1639930.00,'010','','','6','Nazy','010',1639930.16,'2022-09-15 15:23:52',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-17 07:44:07'),(20,'8','284','2022-09-15',1,'011','','10',1314280.00,'011','','','6','Nazy','011',1314271.53,'2022-09-16 12:12:09',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-17 07:44:07'),(21,'8','284','2022-09-16',1,'012','','10',1147445.00,'012','','','6','Nazy','012',1147443.22,'2022-09-17 13:38:16',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-21 15:00:31'),(22,'8','284','2022-09-18',1,'0014','','10',1736835.00,'014','','','6','Nazy','014',1736835.43,'2022-09-20 13:05:25',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-21 15:01:17'),(23,'8','284','2022-09-19',1,'015','','10',1416565.00,'015','','','6','Nazy','015',1416562.40,'2022-09-20 13:34:00',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-21 15:01:17'),(24,'8','284','2022-09-20',1,'016','','10',2161530.00,'016','','','6','Nazy','016',2161529.26,'2022-09-20 15:06:48',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-21 15:01:17'),(25,'8','284','2022-09-21',1,'017','','10',1050450.00,'017','','','6','Nazy','017',1050427.62,'2022-09-22 21:12:02',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-23 08:50:55'),(26,'8','284','2022-09-23',1,'018','','10',1670530.00,'018','','','6','Nazy','018',1670538.32,'2022-09-28 14:30:16',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-29 22:06:08'),(27,'8','284','2022-09-24',1,'19','','10',1206275.00,'19','','','6','Nazy','019',1206275.00,'2022-09-28 15:44:46',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-29 22:06:08'),(28,'8','284','2022-09-26',1,'20','','10',1219390.00,'20','','','6','Nazy','20',1219391.47,'2022-09-28 15:56:59',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-29 22:05:16'),(29,'8','284','2022-09-28',1,'21','','10',675795.00,'21','','','6','Nazy','21',675795.56,'2022-09-28 16:02:50',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-29 22:05:16'),(30,'8','284','2022-09-29',1,'21','','10',2353785.00,'21','','','6','Nazy','21',2353785.00,'2022-09-29 09:24:36',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-09-29 22:05:16'),(31,'8','284','2022-09-30',1,'22','','10',1418990.00,'22','','','6','Nazy','22',1418991.53,'2022-09-30 00:09:04',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-03 11:31:59'),(32,'8','284','2022-10-01',1,'24','','10',1530150.00,'24','','','6','Nazy','24',1530150.00,'2022-10-01 17:49:41',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-03 11:31:59'),(33,'8','284','2022-10-02',1,',25','','10',1662500.00,'25','','','6','Nazy','25',1662495.45,'2022-10-03 11:10:36',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-03 11:31:59'),(34,'8','284','2022-10-03',1,'26','','10',1238210.00,'26','','','6','Nazy','26',1238209.00,'2022-10-03 11:20:58',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-03 11:31:59'),(35,'8','284','2022-10-06',1,'27','','10',1074485.00,'27','','','6','Nazy','27',1074487.00,'2022-10-07 15:36:22',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-09 06:38:16'),(36,'8','284','2022-10-06',1,'28','','10',2746315.00,'28','','','6','Nazy','28',2746311.00,'2022-10-07 15:45:55',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-09 06:38:16'),(37,'8','284','2022-10-07',1,'29','','10',1676990.00,'29','','','6','Nazy','29',1677008.00,'2022-10-07 19:00:46',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-20 13:48:02'),(38,'8','284','2022-10-08',1,'30','','10',1845395.00,'30','','','7','Nazy','30',1845394.10,'2022-10-08 22:54:45',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-09 06:38:16'),(39,'8','284','2022-10-09',1,'31','','10',1987410.00,'31','','','6','Nazy','31',1987409.00,'2022-10-09 23:19:58',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-10 12:47:38'),(40,'8','284','2022-10-11',1,'32','','10',2774870.00,'32','','','6','Nazy','32',2774869.00,'2022-10-12 00:14:27',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-12 16:59:37'),(41,'8','284','2022-10-14',1,'33','','10',2641310.00,'33','','','6','Nazy','33',2641309.00,'2022-10-14 08:50:28',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-17 10:22:12'),(42,'8','284','2022-10-14',1,'34','','10',922240.00,'34','','','6','34','34',922240.00,'2022-10-14 15:42:43',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-17 10:22:12'),(43,'8','284','2022-10-15',1,'35','','10',2707140.00,'35','','','6','Nazy','35',2707140.00,'2022-10-16 11:13:38',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-17 10:22:12'),(44,'8','284','2022-10-19',1,'36','','10',3362715.00,'36','','','6','Nazy','36',3362715.00,'2022-10-19 15:20:48',5,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-10-20 13:45:51'),(45,'8','284','2022-10-17',1,'37','','10',2266370.00,'37','','','6','Nazy','37',2266370.00,'2022-10-19 15:27:49',5,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-10-20 13:45:51'),(46,'8','284','2022-10-19',1,'38','','10',2769095.00,'38','','','6','Nazy','38',2769095.00,'2022-10-19 15:31:49',5,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-10-20 13:45:51'),(47,'8','284','2022-10-21',1,'40','','10',450000.00,'40','','','6','Nazy','40',450000.00,'2022-10-22 16:24:08',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-27 10:34:07'),(48,'8','284','2022-10-22',1,'41','','10',3209200.00,'41','','','6','Nazy','41',3208966.00,'2022-10-22 16:29:10',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-27 10:34:07'),(49,'8','284','2022-10-24',1,'43','','10',889985.00,'43','','','6','Nazy','43',889984.00,'2022-10-24 15:43:48',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-10-27 10:34:06'),(50,'8','284','2022-09-21',1,'17','','10',1980525.00,'17','','','6','Nazy','17',1980524.48,'2022-10-25 12:55:55',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-02 13:33:40'),(51,'8','284','2022-10-12',1,'46','','10',4180240.00,'46','','','6','Nazy','46',4180240.35,'2022-10-25 13:03:10',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-02 13:33:40'),(52,'8','284','2022-10-27',1,'47','','10',3738755.00,'47','','','6','Nazy','47',3738753.00,'2022-10-27 11:02:46',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-01 17:07:32'),(53,'8','284','2022-11-03',1,'49','','10',187535.00,'49','','','6','Nazy','49',187532.00,'2022-11-03 20:01:05',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-07 12:20:15'),(54,'8','284','2022-11-03',1,'50','','10',1576530.00,'50','','','6','Nazy','50',1576530.00,'2022-11-03 20:02:53',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-07 12:19:45'),(55,'8','284','2022-11-04',1,'51','','10',2122565.00,'51','','','6','51','51',2122566.45,'2022-11-05 00:08:35',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-07 12:19:45'),(56,'8','284','2022-11-06',1,'52','','10',1826690.00,'52','','','6','Nazy','52',1826689.95,'2022-11-06 07:18:11',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-07 12:19:45'),(57,'8','284','2022-11-07',1,'53','','10',1253075.00,'53','','','6','Nazy','53',1253067.45,'2022-11-07 11:18:37',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-07 12:19:45'),(58,'8','284','2022-11-07',1,'54','','10',467410.00,'54','','','6','Nazy','54',467412.45,'2022-11-07 11:28:20',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-07 16:05:52'),(59,'8','284','2022-11-07',1,'55','','10',1120200.00,'55','','','6','Nazy','55',1120200.00,'2022-11-07 11:48:40',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-07 16:05:52'),(60,'8','284','2022-11-08',1,'56','','10',3284885.00,'56','','','6','56','56',3284882.50,'2022-11-08 23:27:40',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-09 13:00:23'),(61,'8','284','2022-11-09',1,'57','','10',2456710.00,'57','','','6','Nazy','57',2456710.00,'2022-11-09 12:53:43',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-14 13:45:38'),(62,'8','284','2022-11-11',1,'58','','10',2511200.00,'58','','','6','Nazy','58',2511200.00,'2022-11-11 06:55:18',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-15 16:45:22'),(63,'8','284','2022-11-12',1,'59','','5',3085130.00,'59','','','6','Nazy','59',3085130.00,'2022-11-12 06:36:15',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-13 06:50:51'),(64,'8','284','2022-11-13',1,'60','','10',3076115.00,'60','','','6','Nazy','60',3076112.50,'2022-11-13 10:27:21',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-15 16:45:22'),(65,'8','284','2022-11-14',1,'61','','10',1429910.00,'61','','','6','61','61',1429910.00,'2022-11-14 10:48:09',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-15 16:45:22'),(66,'8','284','2022-11-14',1,'62','','10',2681880.00,'62','','','7','Nazy','62',2681878.35,'2022-11-14 10:54:35',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-15 16:45:22'),(67,'8','284','2022-11-15',1,'63','','10',4454380.00,'63','','','6','Nazy','63',4454385.90,'2022-11-15 17:18:00',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-17 11:24:18'),(68,'8','284','2022-11-16',1,'64','','10',1245205.00,'64','','','6','Nazy','64',1245203.25,'2022-11-16 09:51:08',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-17 11:24:18'),(69,'8','284','2022-11-17',1,'65','','0',3174490.00,'65','Nazy','Lausu','','Nazy','',3174479.70,'2022-11-17 16:10:21',5,'Payment of pms','952','927','2022-11-19 06:02:42','927','2022-11-19 06:02:48'),(70,'8','284','2022-11-19',1,'66','','10',2270540.00,'66','','','6','Nazy','66',2270540.40,'2022-11-19 12:55:17',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-21 14:45:36'),(71,'8','284','2022-11-20',1,'67','','10',1791755.00,'67','','','6','Nazy','67',1791754.95,'2022-11-20 08:39:32',5,'Payment of pms','952','','0000-00-00 00:00:00','465','2022-11-25 17:52:58'),(72,'8','284','2022-11-21',1,'68','','10',1812280.00,'68','','','6','Nazy','68',1812279.90,'2022-11-20 08:53:51',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-25 17:49:38'),(73,'8','284','2022-11-22',1,'69','','10',2297465.00,'69','','','6','Nazy','69',2297465.85,'2022-11-22 08:14:11',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-25 17:49:38'),(74,'8','284','2022-11-23',1,'70','','10',510000.00,'70','','','6','Nazy','70',510000.00,'2022-11-24 13:20:18',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-25 17:49:38'),(75,'8','284','2022-11-23',1,'71','','10',1814355.00,'71','','','6','Nazy','71',1814355.75,'2022-11-24 13:26:55',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-25 17:49:38'),(76,'8','284','2022-11-24',1,'72','','5',2082310.00,'72','','','6','Nazy','000123',2082306.52,'2022-11-24 13:31:13',5,'Payment of pms','952','927','2022-11-28 16:23:58','927','2022-11-28 16:24:14'),(77,'8','284','2022-11-26',1,'73','','10',2281840.00,'73','','','6','Nazy','73',2281838.75,'2022-11-26 07:44:10',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-11-28 16:22:04'),(78,'8','284','2022-11-27',1,'74','','5',2239040.00,'74','','','6','Nazy','000124',2239086.80,'2022-11-27 14:44:36',5,'Payment of pms','952','927','2022-11-28 16:25:50','927','2022-11-28 16:26:02'),(79,'8','284','2022-11-27',1,'75','','10',2033765.00,'75','','','6','Nazy','75',2033764.20,'2022-11-27 14:53:29',5,'Payment of pms','952','','0000-00-00 00:00:00','465','2022-12-01 15:19:40'),(80,'8','284','2022-11-28',1,'76','','5',2577385.00,'76','','','6','Nazy','76',2577382.60,'2022-11-28 18:32:27',5,'Payment of pms','952','','0000-00-00 00:00:00','465','2022-12-01 15:20:43'),(81,'8','284','2022-12-01',1,'77','','10',3248740.00,'77','','','6','Nazy','77',3248731.20,'2022-12-01 00:25:44',5,'Payment of the pms','952','','0000-00-00 00:00:00','465','2022-12-03 13:55:26'),(82,'8','284','2022-12-01',1,'78','','10',780295.00,'78','','','6','Nazy','78',780304.20,'2022-12-01 00:34:32',5,'Payment of the pms','952','','0000-00-00 00:00:00','465','2022-12-03 13:53:08'),(83,'8','284','2022-12-03',1,'79','','10',3702815.00,'79','','','6','Nazy','79',3702816.00,'2022-12-03 08:30:31',5,'Payment of pms','952','','0000-00-00 00:00:00','465','2022-12-03 13:52:42'),(84,'8','284','2022-12-06',1,'80','','10',1005365.00,'80','','','6','Nazy','80',1005365.40,'2022-12-06 12:41:26',5,'Payment of pms','952','','0000-00-00 00:00:00','465','2022-12-08 17:27:28'),(85,'8','284','2022-12-06',1,'81','','10',1277665.00,'Morning81','','','6','Nazy','81',1277663.40,'2022-12-06 12:49:23',5,'Payment of pms','952','','0000-00-00 00:00:00','465','2022-12-08 17:27:57'),(86,'8','284','2022-12-08',1,'82','','10',2199505.00,'82','','','6','Nazy','82',2199506.40,'2022-12-08 12:33:33',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-13 13:05:39'),(87,'8','284','2022-12-08',1,'83','','10',4439910.00,'83','','','6','Nazy','83',4439908.35,'2022-12-08 12:38:16',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-13 13:05:39'),(88,'8','284','2022-12-12',1,'84','','10',1092915.00,'84','','','6','Nazy','84',1046838.40,'2022-12-12 11:52:10',5,'Purchase of pms','952','','0000-00-00 00:00:00','927','2022-12-19 14:34:34'),(89,'8','284','2022-12-12',1,'85','','10',2244560.00,'85','','','6','Nazy','85',2244558.10,'2022-12-14 07:50:31',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-19 14:31:12'),(90,'8','284','2022-12-14',1,'86','','10',4216040.00,'86','','','6','Nazy','86',4216037.20,'2022-12-14 07:57:17',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-19 14:31:12'),(91,'8','284','2022-12-14',1,'87','','10',2763420.00,'87','','','6','Nazy','87',2763417.50,'2022-12-14 08:05:51',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-19 14:31:12'),(92,'8','284','2022-12-17',1,'88','','10',3324340.00,'88','','','6','Nazy','88',3324337.70,'2022-12-19 08:35:41',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-19 14:31:12'),(93,'8','284','2022-12-18',1,'89','','5',1257190.00,'89','','','6','Nazy','00001',1257189.50,'2022-12-19 08:40:59',5,'Payment of pms','952','927','2022-12-19 14:38:15','927','2022-12-19 14:38:31'),(94,'8','284','2022-12-18',1,'90','','10',2450570.00,'90','','','6','Nazy','90',2450568.60,'2022-12-19 08:49:02',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-19 14:31:12'),(95,'8','284','2022-12-18',1,'91','','10',2762200.00,'91','','','6','Nazy','91',2762199.20,'2022-12-19 08:57:38',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-19 14:31:12'),(96,'8','284','2022-12-19',1,'92','','10',2900820.00,'92','','','6','Nazy','92',2900821.90,'2022-12-19 09:17:34',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-29 13:02:09'),(97,'8','284','2022-12-20',1,'93','','10',1771815.00,'93','','','6','Nazy','93',1771814.30,'2022-12-20 08:07:15',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-29 13:02:09'),(98,'8','284','2022-12-21',1,'94','','10',2274935.00,'94','','','6','Nazy','94',2274935.00,'2022-12-21 10:39:09',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2022-12-29 13:07:54'),(99,'8','284','2022-12-22',1,'95','','10',2659650.00,'95','','','6','Nazy','95',2659651.20,'2022-12-22 09:33:14',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2022-12-29 13:08:46'),(100,'8','284','2022-12-25',1,'96','','10',2325575.00,'96','','','6','Nazy','96',2325576.60,'2022-12-25 09:28:19',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2022-12-29 13:02:09'),(101,'8','284','2022-12-25',1,'97','','10',1639055.00,'97','','','6','Nazy','97',1639053.70,'2022-12-25 09:34:45',5,'Payment of the pms','952','','0000-00-00 00:00:00','465','2023-01-02 14:52:14'),(102,'8','284','2022-12-27',1,'98','','10',1005525.00,'98','','','6','Nazy','98',1005522.20,'2022-12-30 12:10:11',5,'Payment of the pms','952','','0000-00-00 00:00:00','465','2023-01-02 14:51:14'),(103,'8','284','2022-12-28',1,'99','','10',929570.00,'99','','','6','Nazy','99',929569.10,'2022-12-30 12:15:58',5,'Payment of the pms','952','','0000-00-00 00:00:00','465','2023-01-02 14:51:34'),(104,'8','284','2022-12-28',1,'100','','10',1433620.00,'100','','','6','Nazy','100',1433622.90,'2022-12-30 12:27:39',5,'Payment of the pms','952','','0000-00-00 00:00:00','465','2023-01-02 14:54:04'),(105,'8','284','2022-12-29',1,'101','','5',806815.00,'101','','','6','Nazy','00001',807122.20,'2022-12-30 12:33:14',5,'Payment of pms','952','927','2023-01-20 14:56:37','927','2023-01-20 14:56:58'),(106,'8','284','2023-01-03',1,'103','','10',1001305.00,'103','','','6','Nazy','103',990146.20,'2023-01-07 11:03:03',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2023-01-13 19:43:45'),(107,'8','284','2023-01-07',1,'104','','5',1064460.00,'104','','','6','Nazy','104',1062465.36,'2023-01-07 11:08:02',5,'Payment of the pms','952','927','2023-01-20 14:59:14','927','2023-01-20 14:59:36'),(108,'8','284','2023-01-07',1,'105','','10',1438655.00,'105','','','6','Nazy','105',1438651.62,'2023-01-07 11:13:04',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-01-13 19:43:45'),(109,'8','284','2023-01-08',1,'107','','10',1379415.00,'107','','','6','Nazy','107',1379412.20,'2023-01-08 07:37:54',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-01-23 15:34:27'),(110,'8','284','2023-01-09',1,'108','','10',1515525.00,'108','','','6','Nazy','108',1515523.70,'2023-01-09 22:23:43',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-01-13 19:11:12'),(111,'8','284','2023-01-09',1,'109','','5',1283500.00,'109','','','6','Nazy','161280',1283506.86,'2023-01-09 22:31:04',5,'Payment of the pms','952','927','2023-01-15 22:49:36','927','2023-01-15 22:49:57'),(112,'8','284','2023-01-10',1,'111','','5',3005610.00,'111','','','6','Nazy','161323',3005601.18,'2023-01-12 15:50:45',5,'Payment of the pms','952','927','2023-01-15 22:47:17','927','2023-01-15 22:49:57'),(113,'8','284','2023-01-11',1,'112','','5',1283620.00,'112','','','6','Nazy','00002',1283572.42,'2023-01-12 15:56:58',5,'Payment of the pms','952','927','2023-01-15 22:54:32','927','2023-01-15 22:54:57'),(114,'8','284','2023-01-12',1,'13','','5',1568295.00,'113','','','6','Nazy','00001',1568284.60,'2023-01-12 16:14:50',5,'Payment of the pms','952','927','2023-01-15 22:53:44','927','2023-01-15 22:54:57'),(115,'8','284','2023-01-14',1,'114','','10',1459805.00,'114','','','6','Nazy','114',1459806.64,'2023-01-14 21:29:05',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-01-15 22:45:00'),(116,'8','284','2023-01-13',1,'115','','5',509665.00,'115','','','6','Nazy','00001',509618.74,'2023-01-20 12:42:33',5,'Payment of pms','952','927','2023-01-20 14:54:22','927','2023-01-20 14:54:32'),(117,'8','284','2023-01-16',1,'116','','10',2359270.00,'116','','','7','Nazy','116',2359271.96,'2023-01-20 12:49:53',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2023-01-20 14:55:05'),(118,'8','284','2023-01-17',1,'117','','10',2457860.00,'117','','','7','Nazy','117',2457862.28,'2023-01-20 12:56:35',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2023-01-20 14:55:05'),(119,'8','284','2023-01-18',1,'118','','10',1430420.00,'118','','','7','Nazy','118',1430418.00,'2023-01-20 13:01:56',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2023-01-23 15:34:27'),(120,'8','284','2023-01-19',1,'119','','10',1573275.00,'119','','','7','Nazy','119',1573275.00,'2023-01-20 13:08:43',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2023-01-23 15:34:27'),(121,'8','284','2023-01-23',1,'120','','10',1943825.00,'120','','','6','Nazy','Nazy',1934697.00,'2023-01-24 17:22:08',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-01-30 15:26:38'),(122,'8','284','2023-01-22',1,'121','','5',1751620.00,'121','','','6','121','121',1751748.00,'2023-02-07 15:09:10',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-09 08:49:40'),(123,'8','284','2023-01-23',1,'122','','10',1841535.00,'122','','','6','122','122',1841541.00,'2023-02-07 15:16:19',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-09 08:53:50'),(124,'8','284','2023-01-24',1,'123','','10',755700.00,'123','','','6','123','123',755700.00,'2023-02-07 15:22:16',0,'Payment of the pms','952','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(125,'8','284','2023-01-30',1,'124','','10',461915.00,'124','','','6','Nazy','124',461913.00,'2023-02-07 15:38:38',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2023-02-09 08:53:50'),(126,'8','284','2023-02-02',1,'127','','5',925935.00,'127','','','6','Nazy','00003',925636.66,'2023-02-07 15:54:59',5,'Payment of pms','952','927','2023-02-09 08:56:30','927','2023-02-09 08:56:41'),(127,'8','284','2023-02-03',1,'129','','5',998525.00,'129','','','6','129','00003',998571.45,'2023-02-07 16:02:16',5,'Payment','952','927','2023-02-09 08:52:29','927','2023-02-09 08:53:08'),(128,'8','284','2023-02-04',1,'130','','10',1307615.00,'130','','','6','Nazy','130',1307870.85,'2023-02-08 10:05:28',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-09 08:53:08'),(129,'8','284','2023-02-05',1,'131','','10',1144660.00,'131','','','6','Nazy','131',1144661.70,'2023-02-08 10:12:54',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-09 08:49:39'),(130,'8','284','2023-02-06',1,'132','','5',1362470.00,'132','','','6','Nazy','132',1362470.55,'2023-02-11 09:44:07',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:53'),(131,'8','284','2023-02-07',1,'133','','5',1197615.00,'133','','','6','Nazy','133',1197615.75,'2023-02-11 09:52:07',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:53'),(132,'8','284','2023-02-09',1,'134','','10',2634425.00,'134','','','6','Nazy','134',2634426.90,'2023-02-11 10:01:47',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:53'),(133,'8','284','2023-02-08',1,'135','','10',1741265.00,'135','','','6','Nazy','135',1741266.75,'2023-02-17 23:44:26',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:53'),(134,'8','284','2023-02-13',1,'136','','10',78045.00,'136','','','6','Nazy','136',78045.90,'2023-02-18 09:10:16',5,'Payment of pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:53'),(135,'8','284','2023-02-12',1,'137','','5',1891585.00,'137','','','6','Nazy','137',1891583.25,'2023-02-20 19:43:30',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:53'),(136,'8','284','2023-02-12',1,'138','','5',3943170.00,'138','','','6','Nazy','138',3955245.60,'2023-02-20 20:13:27',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:53'),(137,'8','284','2023-02-20',1,'139','','5',1748325.00,'139','','','6','Nazy','139',1748325.45,'2023-02-20 20:25:28',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:52'),(138,'8','284','2023-02-18',1,'140','','5',1755900.00,'140','','','6','Nazy','140',1755901.65,'2023-02-20 20:55:04',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-21 14:16:52'),(139,'8','284','2023-02-19',1,'141','','10',1667645.00,'141','','','6','Nazy','141',1667643.75,'2023-02-23 23:34:18',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-24 15:33:30'),(140,'8','284','2023-02-20',1,'142','','5',1299685.00,'142','','','6','Nazy','142',1299952.60,'2023-02-23 23:50:30',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-24 15:33:08'),(141,'8','284','2023-02-22',1,'143','','5',1026780.00,'143','','','6','Nazy','143',1026779.60,'2023-02-23 23:57:15',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-24 15:33:08'),(142,'8','284','2023-02-24',1,'144','','5',2165615.00,'144','','','6','Nazy','144',2165715.00,'2023-02-24 00:05:18',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-24 15:33:08'),(143,'8','284','2023-02-24',1,'145','','5',981555.00,'145','','','6','Nazy','145',981556.20,'2023-02-24 00:11:12',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-02-24 15:33:08'),(144,'8','284','2023-02-24',1,'146','','5',1159570.00,'146','','','6','Nazy','146',1159571.20,'2023-02-24 00:18:10',5,'Payment of the same','952','','0000-00-00 00:00:00','927','2023-03-01 13:28:50'),(145,'8','284','2023-02-24',1,'147','','5',1215645.00,'147','','','6','Nazy','147',1215625.60,'2023-02-24 23:16:59',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-01 13:28:50'),(146,'8','284','2023-02-27',1,'148','','5',1082020.00,'148','','','6','Nazy','148',1082021.85,'2023-02-27 10:55:15',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-01 13:19:22'),(147,'8','284','2023-02-27',1,'149','','5',876865.00,'149','','','6','Nazy','149',876862.35,'2023-02-27 11:02:31',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-01 13:19:22'),(148,'8','284','2023-03-01',1,'150','','10',2541080.00,'150','','','6','Nazy','150',2541079.80,'2023-03-01 23:35:09',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-03 13:24:33'),(149,'8','284','2023-03-02',1,'151','','10',1782950.00,'151','','','6','Nazy','151',1782950.40,'2023-03-02 11:15:26',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-03 13:24:33'),(150,'8','284','2023-03-02',1,'152','','10',1336055.00,'152','','','6','Nazy','152',1336053.60,'2023-03-02 11:21:27',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-03 13:24:33'),(151,'8','284','2023-03-04',1,'153','','10',1107705.00,'153','','','6','Nazy','153',1107706.95,'2023-03-04 09:21:29',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-09 13:09:20'),(152,'8','284','2023-03-04',1,'154','','10',931910.00,'154','','','6','Nazy','154',931908.00,'2023-03-04 09:27:14',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-13 12:22:58'),(153,'8','284','2023-03-06',1,'155','','10',1200545.00,'155','','','6','Nazy','155',1200546.00,'2023-03-06 12:23:13',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-09 13:09:19'),(154,'8','284','2023-03-06',1,'156','','10',1259295.00,'156','','','6','Nazy','156',1259295.00,'2023-03-06 12:29:21',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-09 13:09:19'),(155,'8','284','2023-03-08',1,'157','','10',2983505.00,'157','','','6','Nazy','157',2983506.00,'2023-03-08 08:59:00',5,'Payment of the pms','952','','0000-00-00 00:00:00','927','2023-03-13 12:20:52'),(156,'8','284','2023-03-10',1,'158','','10',1374700.00,'158','','','6','Nazy','158',1374702.00,'2023-03-15 16:39:20',0,'Payment of the pms','952','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(157,'8','284','2023-03-14',1,'159','','5',1545675.00,'159','','','6','Nazy','159',1545675.00,'2023-03-15 16:43:37',0,'Payment of the pms','952','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(158,'8','284','2023-03-15',1,'160','','5',1985615.00,'160','','','6','Nazy','160',1985613.00,'2023-03-15 16:50:43',0,'Payment of pms','952','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (3,'8',2,'284',1,1,'2022-09-08 00:00:00','AA Rano',38800.00,38800.00,0.00,'001','','1','NSR56ZQ','Usman','08168551182','Delivery of pms',5,'2022-09-08 12:12:50','952','0000-00-00 00:00:00','','2022-09-08 12:54:14','927'),(4,'8',2,'284',1,1,'2022-09-08 00:00:00','AA Rano',11200.00,11200.00,0.00,'001','','2','NSR56ZQ','Usman','08168551182','Received of Pms',5,'2022-09-08 12:14:41','952','0000-00-00 00:00:00','','2022-09-08 12:54:52','927'),(5,'8',1,'284',1,1,'2022-09-08 00:00:00','AA Rano',26500.00,26500.00,0.00,'','','2','RAN869XA','Usain','','',5,'2022-09-08 12:21:38','952','0000-00-00 00:00:00','','2022-09-08 12:57:22','927'),(6,'8',1,'284',1,1,'2022-09-08 00:00:00','AA Rano',23500.00,23500.00,0.00,'002','','3','RAN869XA','Usain','','Received of PMS',5,'2022-09-08 12:49:40','952','0000-00-00 00:00:00','','2022-09-08 13:29:19','927'),(7,'8',3,'284',1,1,'2022-09-19 00:00:00','AA Rano',19100.00,19100.00,0.00,'003','','1','NSR57ZQ','Ali','07043189737','',5,'2022-09-19 12:36:43','952','0000-00-00 00:00:00','','2022-09-19 13:06:04','467'),(8,'8',3,'284',1,1,'2022-09-19 00:00:00','AA Rano',29900.00,29900.00,0.00,'003','','2','NSR57ZQ','Ali','07043189737','',5,'2022-09-19 12:36:43','952','0000-00-00 00:00:00','','2022-09-19 13:06:20','467'),(9,'8',4,'284',1,1,'2022-09-28 00:00:00','AA Rano',17500.00,17500.00,0.00,'004','','1','NSR435ZS','Alhji Gambo','07033278968','Delivery of pms',5,'2022-09-28 13:56:38','952','0000-00-00 00:00:00','','2022-09-28 14:15:48','927'),(10,'8',4,'284',1,1,'2022-09-28 00:00:00','AA Rano',31700.00,31700.00,0.00,'004','','2','NSR435ZS','Alhji Gambo','07033278968','Received of Pms',5,'2022-09-28 13:56:38','952','0000-00-00 00:00:00','','2022-09-28 14:39:40','927'),(12,'8',5,'284',1,1,'2022-10-07 00:00:00','AA Rano',10500.00,10500.00,0.00,'','','2','NSR572ZX','Alhji Bahari','08032972447','',5,'2022-10-07 14:46:55','952','0000-00-00 00:00:00','','2022-10-07 15:02:02','927'),(13,'8',5,'284',1,1,'2022-10-07 00:00:00','AA Rano',30000.00,30000.00,0.00,'005','','1','NSR572ZX','Alhji Bahari','08032972447','Delivery of pms',5,'2022-10-07 15:11:42','952','0000-00-00 00:00:00','','2022-10-07 15:15:23','952'),(14,'8',6,'284',1,1,'2022-10-08 00:00:00','AA Rano',33000.00,33000.00,0.00,'006','','2','RAN683XA','Shamsu','','Received of Pms',5,'2022-10-08 22:43:31','952','0000-00-00 00:00:00','','2022-10-08 22:45:19','952'),(15,'8',5,'284',1,1,'2022-10-10 00:00:00','AA Rano',9500.00,9500.00,0.00,'005','','1','NSR572ZX','Alhji Bahari','08032972447','Received of pms',5,'2022-10-10 06:34:20','952','0000-00-00 00:00:00','','2022-10-10 06:35:31','952'),(16,'8',6,'284',1,1,'2022-10-10 00:00:00','AA Rano',9560.00,9560.00,0.00,'006','','2','RAN683XA','Shamsu','','Received of Pms',5,'2022-10-10 15:17:05','952','0000-00-00 00:00:00','','2022-10-10 15:18:29','952'),(17,'8',6,'284',1,1,'2022-10-10 00:00:00','AA Rano',7440.00,7440.00,0.00,'006','','3','RAN683XA','Shamsu','','Received of PMS',5,'2022-10-10 15:17:05','952','0000-00-00 00:00:00','','2022-10-10 15:18:53','952'),(18,'8',7,'284',1,1,'2022-10-16 00:00:00','AA Rano',16000.00,16000.00,0.00,'007','','1','NRS433ZS','Auwal','','Received of pms',5,'2022-10-16 10:39:45','952','0000-00-00 00:00:00','','2022-10-16 10:40:37','952'),(19,'8',7,'284',1,1,'2022-10-16 00:00:00','AA Rano',33900.00,33900.00,0.00,'007','','2','NRS433ZS','Auwal','','Received of Pms',5,'2022-10-16 10:39:45','952','0000-00-00 00:00:00','','2022-10-16 10:41:11','952'),(20,'8',8,'284',1,1,'2022-10-21 00:00:00','AA Rano',18000.00,18000.00,0.00,'008','','2','WDL813XA','Me Daban','','Received of Pms',5,'2022-10-21 08:33:51','952','0000-00-00 00:00:00','','2022-10-21 08:34:51','952'),(21,'8',9,'284',1,1,'2022-10-25 00:00:00','AA Rano',16800.00,16800.00,0.00,'009','','2','RAN869XA','Usman','','Received of Pms',5,'2022-10-25 12:32:02','952','0000-00-00 00:00:00','','2022-10-25 12:33:08','952'),(22,'8',10,'284',1,1,'2022-11-03 00:00:00','AA Rano',30000.00,30000.00,0.00,'009','','1','RXH266ZA','Baba','','Received of pms',5,'2022-11-03 15:08:26','952','0000-00-00 00:00:00','','2022-11-03 15:09:11','952'),(23,'8',10,'284',1,1,'2022-11-03 00:00:00','AA Rano',14700.00,14700.00,0.00,'009','','2','RXH266ZA','Baba','','Received of Pms',5,'2022-11-03 15:08:26','952','0000-00-00 00:00:00','','2022-11-03 15:09:31','952'),(24,'8',11,'284',1,1,'2022-11-06 00:00:00','AA Rano',17000.00,17000.00,0.00,'010','','2','RAN31XF','Shafi\'u','','Received of Pms',5,'2022-11-06 19:16:14','952','0000-00-00 00:00:00','','2022-11-07 16:05:17','927'),(25,'8',12,'284',1,1,'2022-11-11 00:00:00','AA Rano',32000.00,32000.00,0.00,'11','','2','NSR435ZS','Alhji Gambo','','Received of Pms',5,'2022-11-11 06:45:53','952','0000-00-00 00:00:00','','2022-11-11 06:51:25','952'),(26,'8',13,'284',1,1,'2022-11-14 00:00:00','AA Rano',21350.00,21350.00,0.00,'12','','1','BCH428XA','Yalo','','Received of pms',5,'2022-11-14 10:34:14','952','0000-00-00 00:00:00','','2022-11-14 10:35:15','952'),(27,'8',13,'284',1,1,'2022-11-14 00:00:00','AA Rano',11450.00,11450.00,0.00,'12','','2','BCH428XA','Yalo','','Received of Pms',5,'2022-11-14 10:34:14','952','0000-00-00 00:00:00','','2022-11-14 10:34:52','952'),(28,'8',15,'284',1,1,'2022-11-15 00:00:00','AA Rano',16650.00,16650.00,0.00,'14','','1','RAN683XA','Usman','','Received of pms',5,'2022-11-15 22:49:58','952','0000-00-00 00:00:00','','2022-11-15 22:50:52','952'),(29,'8',16,'284',1,1,'2022-11-17 00:00:00','AA Rano',32700.00,32700.00,0.00,'14','','2','BCH428XA','Aramma','','Received of Pms',5,'2022-11-17 16:01:01','952','0000-00-00 00:00:00','','2022-11-17 16:03:40','952'),(31,'8',17,'284',1,1,'2022-11-24 00:00:00','AA Rano',32000.00,32000.00,0.00,'17','','2','WDL813XA','Me Daban','','Received of Pms',5,'2022-11-24 13:15:40','952','0000-00-00 00:00:00','','2022-11-24 13:16:19','952'),(32,'8',18,'284',1,1,'2022-11-27 00:00:00','AA Rano',16650.00,16650.00,0.00,'18','','1','TRN44YZ','Shuaibu','','Received of pms',5,'2022-11-27 14:27:51','952','0000-00-00 00:00:00','','2022-11-27 14:29:43','952'),(33,'8',18,'284',1,1,'2022-11-27 00:00:00','AA Rano',17350.00,17350.00,0.00,'18','','2','TRN44YZ','Shuaibu','','Received of Pms',5,'2022-11-27 14:27:51','952','0000-00-00 00:00:00','','2022-11-27 14:29:09','952'),(34,'8',19,'284',1,1,'2022-12-03 00:00:00','AA Rano',18000.00,18000.00,0.00,'18','','2','NSR435ZS','Alhji Gambo','','Received of Pms',5,'2022-12-03 08:20:13','952','0000-00-00 00:00:00','','2022-12-03 08:20:49','952'),(35,'8',20,'284',1,1,'2022-12-06 00:00:00','AA Rano',33000.00,33000.00,0.00,'20','','2','RAN32XF','Isah','','Received of Pms',5,'2022-12-06 12:34:01','952','0000-00-00 00:00:00','','2022-12-06 12:34:36','952'),(36,'8',21,'284',1,1,'2022-12-14 00:00:00','AA Rano',16150.00,16150.00,0.00,'21','','1','RBC619ZX','Sabi\'u','','Received of pms',5,'2022-12-14 07:46:26','952','0000-00-00 00:00:00','','2022-12-14 07:47:19','952'),(37,'8',21,'284',1,1,'2022-12-14 00:00:00','AA Rano',27900.00,27900.00,0.00,'21','','2','RBC619ZX','Sabi\'u','','Received of Pms',5,'2022-12-14 07:46:26','952','0000-00-00 00:00:00','','2022-12-14 07:46:49','952'),(38,'8',22,'284',1,1,'2022-12-17 00:00:00','AA Rano',32650.00,32650.00,0.00,'22','','2','BCH424XA','Aramma','','Received of Pms',5,'2022-12-17 16:24:17','952','0000-00-00 00:00:00','','2022-12-17 16:24:41','952'),(39,'8',23,'284',1,1,'2022-12-21 00:00:00','AA Rano',31150.00,31150.00,0.00,'23','','2','WDL813XA','Me Daban','','Received of Pms',5,'2022-12-21 10:32:30','952','0000-00-00 00:00:00','','2022-12-21 10:32:58','952'),(40,'8',24,'284',1,1,'2022-12-30 00:00:00','AA Rano',17000.00,17000.00,0.00,'24','','2','RAN33XF','Abdullahi','','Received of Pms',5,'2022-12-30 12:06:52','952','0000-00-00 00:00:00','','2022-12-30 12:07:08','952'),(41,'8',25,'284',1,1,'2023-01-07 00:00:00','AA Rano',13800.00,13800.00,0.00,'25','','1','NSR57ZQ','Ali','','Received of pms',5,'2023-01-07 10:49:07','952','0000-00-00 00:00:00','','2023-01-07 10:49:29','952'),(42,'8',25,'284',1,1,'2023-01-07 00:00:00','AA Rano',35000.00,35000.00,0.00,'25','','2','NSR57ZQ','Ali','','Received of Pms',5,'2023-01-07 10:49:07','952','0000-00-00 00:00:00','','2023-01-07 10:49:52','952'),(43,'8',26,'284',1,1,'2023-01-19 00:00:00','AA Rano',16800.00,16800.00,0.00,'26','','1','DKA705ZP','Alhji','','Received of pms',5,'2023-01-19 15:24:22','952','0000-00-00 00:00:00','','2023-01-19 15:25:51','952'),(44,'8',26,'284',1,1,'2023-01-19 00:00:00','AA Rano',32200.00,32200.00,0.00,'26','','2','DKA705ZP','Alhji','','Received of Pms',5,'2023-01-19 15:24:22','952','0000-00-00 00:00:00','','2023-01-19 15:25:34','952'),(45,'8',27,'284',1,1,'2023-02-07 00:00:00','AA Rano',32900.00,32900.00,0.00,'26','','2','RAN33XF','Abdullahi','','Delivery of pms',5,'2023-02-07 15:32:38','952','0000-00-00 00:00:00','','2023-02-07 15:33:10','952'),(46,'8',28,'284',1,1,'2023-02-17 00:00:00','AA Rano',31750.00,31750.00,0.00,'28','','2','RAN31XF','Shafi\'u','','Delivery of pms',5,'2023-02-17 23:39:18','952','0000-00-00 00:00:00','','2023-02-17 23:41:44','952'),(47,'8',29,'284',1,1,'2023-02-23 00:00:00','AA Rano',15000.00,15000.00,0.00,'29','','1','KWL63AZ','','','Delivery of pms',5,'2023-02-23 23:29:06','952','0000-00-00 00:00:00','','2023-02-23 23:29:34','952'),(48,'8',29,'284',1,1,'2023-02-23 00:00:00','AA Rano',29600.00,29600.00,0.00,'29','','2','KWL63AZ','','','Delivery of pms',5,'2023-02-23 23:29:06','952','0000-00-00 00:00:00','','2023-02-23 23:29:53','952'),(49,'8',30,'284',1,1,'2023-03-01 00:00:00','AA Rano',15900.00,15900.00,0.00,'30','','1','BCH424XA','Aramma','','Delivery of pms',5,'2023-03-01 23:19:52','952','0000-00-00 00:00:00','','2023-03-01 23:20:38','952'),(50,'8',30,'284',1,1,'2023-03-01 00:00:00','AA Rano',16900.00,16900.00,0.00,'30','','2','BCH424XA','Aramma','','Received of Pms',5,'2023-03-01 23:19:52','952','0000-00-00 00:00:00','','2023-03-01 23:21:07','952'),(51,'8',31,'284',1,1,'2023-03-15 00:00:00','AA Rano',16800.00,16800.00,0.00,'31','','2','BCH428XA','Lurwan','','Received of Pms',5,'2023-03-15 14:36:47','952','0000-00-00 00:00:00','','2023-03-15 14:37:15','952');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'8','284','Lausu Energy Resources','Babangida Bashir','08063654848','babangida@lausuenergy.com','KANO','KANO','Lausu Energy Resources AA Rano House Hotoro.','Nigeria',0.00,0.00,'0000-00-00','2022-09-06 13:51:30',5,'926','2022-09-06 13:51:30','926');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:57:18
