-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_8_station_216
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_8_station_216`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_8_station_216` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_8_station_216`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','8','216','PURCHASES','','2022-10-16 02:03:52',5,0.00,0.00,'','963','2022-10-16 02:03:52','963',0,0),(2,7000,'',0,'20','8','216','SALES','','2022-10-16 02:04:05',5,0.00,0.00,'','963','2022-10-16 02:04:05','963',0,0),(3,500,'',0,'6.1','8','216','CASH','','2022-10-16 02:04:16',5,0.00,0.00,'','963','2022-10-16 02:04:16','963',0,0),(4,8000,'',0,'24','8','216','SALARIES & WAGES','','2022-10-16 02:04:32',5,0.00,0.00,'','963','2022-10-16 02:04:32','963',0,0),(5,8001,'',0,'24','8','216','PURCHASES','','2022-10-16 02:04:50',5,0.00,0.00,'','963','2022-10-16 02:04:50','963',0,0),(6,2500,'',0,'2','8','216','UBA-0039769388','','2022-10-17 13:40:26',5,0.00,0.00,'','963','2022-10-17 13:40:26','963',0,0),(7,2501,'',0,'2','8','216','Keystone-1009060914','','2022-10-17 13:40:41',5,0.00,0.00,'','963','2022-10-17 13:40:41','963',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('8','216','1',1,'5','PMS PUMP 1',1183463.97,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-12-09 16:44:07','963'),('8','216','2',2,'5','PMS PUMP 2',610385.41,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-12-09 16:45:41','963'),('8','216','3',3,'5','AGO PUMP ',0.00,'AGO DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('8','216','4',4,'5','DPK PUMP',0.00,'DPK DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('8','216',1,'001','2022-12-08','2022-12-09 09:18:25','2022-12-10 09:18:25','959',0.00,0.00,'467','2022-12-09 13:58:39','467','2022-12-09 13:59:02',10,0),('8','216',2,'001','2022-12-08','2022-12-10 12:08:52','2022-12-11 12:08:52','959',1833208.90,1833208.90,'959','2022-12-10 13:01:00','959','2022-12-10 13:36:11',10,0),('8','216',3,'003','2022-12-09','2022-12-10 13:41:25','2022-12-11 13:41:25','959',1466402.40,1466402.40,'959','2022-12-10 13:44:31','959','2022-12-10 13:48:47',10,0),('8','216',4,'004','2022-12-10','2022-12-12 13:06:33','2022-12-13 13:06:33','959',1474394.80,1474394.80,'959','2022-12-12 13:07:57','959','2022-12-12 13:12:45',10,0),('8','216',5,'05','2022-12-11','2022-12-12 13:14:25','2022-12-13 13:14:25','959',247993.50,247993.50,'959','2022-12-12 13:16:38','959','2022-12-25 11:44:56',10,0),('8','216',6,'006','2022-12-19','2022-12-25 14:57:56','2022-12-26 14:57:56','959',776682.50,0.00,'959','2022-12-25 15:03:37','959','2022-12-25 15:06:03',10,0),('8','216',7,'007','2022-12-21','2022-12-25 15:25:04','2022-12-26 15:25:04','959',0.00,0.00,'959','2022-12-27 18:14:21','959','2022-12-27 18:14:37',10,0),('8','216',8,'08','2022-12-20','2022-12-27 18:18:49','2022-12-28 18:18:49','959',614321.85,614321.85,'959','2022-12-27 18:20:00','959','2022-12-27 18:20:27',10,0),('8','216',9,'09','2022-12-21','2022-12-27 18:21:28','2022-12-28 18:21:28','959',653572.30,653572.30,'959','2022-12-27 18:28:36','959','2022-12-27 18:31:24',10,0),('8','216',10,'010','2022-12-22','2022-12-27 20:52:51','2022-12-28 20:52:51','959',0.00,0.00,'959','2022-12-27 21:21:55','959','2022-12-27 21:22:10',10,0),('8','216',11,'11','2022-12-22','2022-12-27 21:23:34','2022-12-28 21:23:34','959',636684.45,636684.45,'959','2022-12-27 21:24:19','959','2022-12-29 07:59:10',10,0),('8','216',12,'012','2022-12-23','2022-12-29 08:27:38','2022-12-30 08:27:38','959',1023793.50,1023793.50,'959','2022-12-29 08:31:20','959','2022-12-29 08:32:18',10,0),('8','216',13,'013','2022-12-24','2022-12-29 08:38:59','2022-12-30 08:38:59','959',1199144.10,1199144.10,'959','2022-12-29 08:42:37','959','2022-12-29 08:47:11',10,0),('8','216',14,'014','2022-12-25','2022-12-29 08:54:04','2022-12-30 08:54:04','959',1274479.10,1274479.10,'959','2022-12-29 08:56:43','959','2022-12-29 09:01:07',10,0),('8','216',15,'015','2022-12-26','2022-12-29 09:03:58','2022-12-30 09:03:58','959',1309837.75,1309837.75,'959','2022-12-29 09:06:57','959','2022-12-29 09:12:42',10,0),('8','216',16,'016','2022-12-27','2022-12-29 09:15:35','2022-12-30 09:15:35','959',1021670.70,1021670.70,'959','2022-12-29 09:18:28','959','2022-12-29 09:24:20',10,0),('8','216',17,'017','2022-12-28','2022-12-29 09:26:42','2022-12-30 09:26:42','959',959014.55,959014.55,'959','2022-12-29 09:28:41','959','2022-12-29 19:05:24',10,0),('8','216',18,'018','2022-12-29','2023-01-01 09:16:37','2023-01-02 09:16:37','959',765357.85,765357.85,'959','2023-01-03 17:24:15','959','2023-01-03 19:08:42',10,0),('8','216',19,'019','2022-12-31','2023-01-03 19:10:59','2023-01-04 19:10:59','959',757831.40,0.00,'959','2023-01-03 19:12:27','959','2023-01-03 19:42:16',10,0),('8','216',20,'020','2023-01-01','2023-01-03 19:43:37','2023-01-04 19:43:37','959',0.00,0.00,'959','2023-01-04 06:25:28','959','2023-01-04 06:25:45',10,0),('8','216',21,'21','2023-01-01','2023-01-04 06:27:46','2023-01-05 06:27:46','959',605059.75,605059.75,'959','2023-01-04 06:30:13','959','2023-01-04 06:32:29',10,0),('8','216',22,'22','2023-01-02','2023-01-04 06:33:47','2023-01-05 06:33:47','959',750400.35,750400.35,'959','2023-01-04 06:35:43','959','2023-01-04 06:37:32',10,0),('8','216',23,'23','2023-01-03','2023-01-04 06:39:07','2023-01-05 06:39:07','959',862411.85,862411.85,'959','2023-01-04 14:23:33','959','2023-01-04 18:41:28',10,0),('8','216',24,'24','2023-01-04','2023-01-04 18:42:54','2023-01-05 18:42:54','959',843145.40,843145.40,'959','2023-01-05 10:09:55','959','2023-01-06 08:15:14',10,0),('8','216',25,'25','2023-01-05','2023-01-06 08:16:04','2023-01-07 08:16:04','959',721806.00,721806.00,'959','2023-01-06 10:33:10','959','2023-01-09 22:38:56',10,0),('8','216',26,'26','2023-01-06','2023-01-09 22:42:23','2023-01-10 22:42:23','959',654548.95,654548.95,'959','2023-01-10 14:44:19','959','2023-01-11 18:01:14',10,0),('8','216',27,'27','2023-01-07','2023-01-11 18:08:44','2023-01-12 18:08:44','959',779711.55,779711.55,'959','2023-01-11 18:10:16','959','2023-01-12 15:07:33',10,0),('8','216',28,'28','2023-01-08','2023-01-12 15:09:03','2023-01-13 15:09:03','959',705527.90,705527.90,'959','2023-01-13 18:22:32','959','2023-01-13 18:40:34',10,0),('8','216',29,'29','2023-01-09','2023-01-13 18:43:36','2023-01-14 18:43:36','959',591702.15,591702.15,'959','2023-01-13 18:45:59','959','2023-01-13 18:49:06',10,0),('8','216',30,'30','2023-01-10','2023-01-14 17:43:20','2023-01-15 17:43:20','959',599879.55,599879.55,'959','2023-01-14 17:47:45','959','2023-01-14 17:57:36',10,0),('8','216',31,'31','2023-01-11','2023-01-14 17:59:20','2023-01-15 17:59:20','959',627344.05,627344.05,'959','2023-01-14 18:02:26','959','2023-01-14 18:05:04',10,0),('8','216',32,'032','2023-01-12','2023-01-14 18:06:02','2023-01-15 18:06:02','959',652719.95,652719.95,'959','2023-01-14 18:07:53','959','2023-01-14 18:10:14',10,0),('8','216',33,'33','2023-01-13','2023-01-15 08:59:31','2023-01-16 08:59:31','959',518191.10,518191.10,'959','2023-01-15 09:00:59','959','2023-01-15 09:01:27',10,0),('8','216',34,'34','2023-02-23','2023-02-25 01:40:12','2023-02-26 01:40:12','959',758955.35,771819.00,'959','2023-02-26 21:01:27','959','2023-02-27 19:10:26',10,0),('8','216',35,'35','2023-02-24','2023-02-27 19:12:49','2023-02-28 19:12:49','959',1841766.00,1841766.00,'959','2023-02-27 19:14:31','959','2023-02-27 19:17:28',10,0),('8','216',36,'36','2023-02-26','2023-02-27 19:19:54','2023-02-28 19:19:54','959',2134374.00,2134374.00,'959','2023-02-27 19:21:27','959','2023-02-27 19:24:00',10,0),('8','216',37,'37','2023-02-26','2023-03-01 14:30:51','2023-03-02 14:30:51','959',2336331.00,2336331.00,'959','2023-03-01 14:33:27','959','2023-03-01 14:35:49',10,0),('8','216',38,'38','2023-02-28','2023-03-01 14:36:41','2023-03-02 14:36:41','959',2146059.00,2146059.00,'959','2023-03-01 14:38:06','959','2023-03-03 07:13:47',10,0),('8','216',39,'39','2023-03-01','2023-03-03 07:34:05','2023-03-04 07:34:05','959',726408.00,726408.00,'959','2023-03-03 07:38:29','959','2023-03-03 07:51:40',10,0),('8','216',40,'40','2023-03-02','2023-03-05 10:44:53','2023-03-06 10:44:53','959',1894464.00,1894464.00,'959','2023-03-05 10:47:31','959','2023-03-05 10:49:33',10,0),('8','216',41,'41','2023-03-03','2023-03-05 10:50:33','2023-03-06 10:50:33','959',2345919.00,2345919.00,'959','2023-03-05 10:52:41','959','2023-03-05 10:54:44',10,0),('8','216',42,'42','2023-03-04','2023-03-05 10:56:20','2023-03-06 10:56:20','959',2020929.00,2020929.00,'959','2023-03-05 10:58:24','959','2023-03-05 11:00:20',10,0),('8','216',43,'43','2023-03-04','2023-03-05 11:04:43','2023-03-06 11:04:43','959',2119845.00,2119845.00,'959','2023-03-07 09:51:23','959','2023-03-07 09:53:37',10,0),('8','216',44,'44','2023-03-06','2023-03-07 10:04:30','2023-03-08 10:04:30','959',1542153.00,1542153.00,'959','2023-03-10 07:26:44','959','2023-03-10 07:29:30',10,0),('8','216',45,'45','2023-03-07','2023-03-10 07:30:39','2023-03-11 07:30:39','959',1589532.00,1589532.00,'959','2023-03-10 07:32:42','959','2023-03-10 07:39:07',10,0),('8','216',46,'46','2023-03-08','2023-03-10 07:42:05','2023-03-11 07:42:05','959',1698564.00,1698564.00,'959','2023-03-10 07:45:04','959','2023-03-10 07:47:01',10,0),('8','216',47,'47','2023-03-09','2023-03-11 11:41:35','2023-03-12 11:41:35','959',2148216.00,2148216.00,'959','2023-03-11 11:43:58','959','2023-03-11 11:47:49',10,0),('8','216',48,'48','2023-03-10','2023-03-12 17:06:15','2023-03-13 17:06:15','959',1913616.00,1913616.00,'959','2023-03-12 17:08:55','959','2023-03-12 17:11:43',10,0),('8','216',49,'49','2023-03-11','2023-03-12 17:13:34','2023-03-13 17:13:34','959',1893693.00,1893693.00,'959','2023-03-12 17:15:52','959','2023-03-12 17:17:34',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=197 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('8','216','1','1',1,'1','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','1',2,'2','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','1',3,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','1',4,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','2',5,'1','1',1102261.43,1102261.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','2',6,'2','1',510855.21,517176.62,6321.41,1833208.90,0.00,0.00,0.00,0.00,0.00),('8','216','3','2',7,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','2',8,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','3',9,'1','1',1102261.43,1102261.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','3',10,'2','1',517176.62,522233.18,5056.56,1466402.40,0.00,0.00,0.00,0.00,0.00),('8','216','3','3',11,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','3',12,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','4',13,'1','1',1102261.43,1102261.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','4',14,'2','1',522233.18,527317.30,5084.12,1474394.80,0.00,0.00,0.00,0.00,0.00),('8','216','3','4',15,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','4',16,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','5',17,'1','1',1102261.43,1102261.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','5',18,'2','1',527317.30,528172.45,855.15,247993.50,0.00,0.00,0.00,0.00,0.00),('8','216','3','5',19,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','5',20,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','6',21,'1','1',1102261.43,1103540.28,1278.85,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','6',22,'2','1',528172.45,529440.10,1267.65,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','6',23,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','6',24,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','7',25,'1','1',1103540.28,1103540.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','7',26,'2','1',529440.10,529440.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','7',27,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','7',28,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','8',29,'1','1',1103540.28,1104329.54,789.26,240724.30,0.00,0.00,0.00,0.00,0.00),('8','216','2','8',30,'2','1',529440.10,530665.01,1224.91,373597.55,0.00,0.00,0.00,0.00,0.00),('8','216','3','8',31,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','8',32,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','9',33,'1','1',1104329.54,1106036.24,1706.70,520543.50,0.00,0.00,0.00,0.00,0.00),('8','216','2','9',34,'2','1',530665.01,531101.17,436.16,133028.80,0.00,0.00,0.00,0.00,0.00),('8','216','3','9',35,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','9',36,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','10',37,'1','1',1106036.24,1106036.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','10',38,'2','1',531101.17,531101.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','10',39,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','10',40,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','11',41,'1','1',1106036.24,1107296.06,1259.82,384245.10,0.00,0.00,0.00,0.00,0.00),('8','216','2','11',42,'2','1',531101.17,531928.84,827.67,252439.35,0.00,0.00,0.00,0.00,0.00),('8','216','3','11',43,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','11',44,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','12',45,'1','1',1107296.06,1109398.45,2102.39,641228.95,0.00,0.00,0.00,0.00,0.00),('8','216','2','12',46,'2','1',531928.84,533183.15,1254.31,382564.55,0.00,0.00,0.00,0.00,0.00),('8','216','3','12',47,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','12',48,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','13',49,'1','1',1109398.45,1110924.47,1526.02,465436.10,0.00,0.00,0.00,0.00,0.00),('8','216','2','13',50,'2','1',533183.15,535588.75,2405.60,733708.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','13',51,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','13',52,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','14',53,'1','1',1110924.47,1113776.85,2852.38,869975.90,0.00,0.00,0.00,0.00,0.00),('8','216','2','14',54,'2','1',535588.75,536914.99,1326.24,404503.20,0.00,0.00,0.00,0.00,0.00),('8','216','3','14',55,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','14',56,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','15',57,'1','1',1113776.85,1115574.54,1797.69,548295.45,0.00,0.00,0.00,0.00,0.00),('8','216','2','15',58,'2','1',536914.99,539411.85,2496.86,761542.30,0.00,0.00,0.00,0.00,0.00),('8','216','3','15',59,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','15',60,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','16',61,'1','1',1115574.54,1117776.30,2201.76,671536.80,0.00,0.00,0.00,0.00,0.00),('8','216','2','16',62,'2','1',539411.85,540559.83,1147.98,350133.90,0.00,0.00,0.00,0.00,0.00),('8','216','3','16',63,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','16',64,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','17',65,'1','1',1117776.30,1119172.63,1396.33,425880.65,0.00,0.00,0.00,0.00,0.00),('8','216','2','17',66,'2','1',540559.83,542307.81,1747.98,533133.90,0.00,0.00,0.00,0.00,0.00),('8','216','3','17',67,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','17',68,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','18',69,'1','1',1119172.63,1119616.77,444.14,135462.70,0.00,0.00,0.00,0.00,0.00),('8','216','2','18',70,'2','1',542307.81,544373.04,2065.23,629895.15,0.00,0.00,0.00,0.00,0.00),('8','216','3','18',71,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','18',72,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','19',73,'1','1',1119616.77,1120969.56,1352.79,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','19',74,'2','1',544373.04,545589.17,1216.13,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','19',75,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','19',76,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','20',77,'1','1',1120969.56,1120969.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','20',78,'2','1',545589.17,545589.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','20',79,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','20',80,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','21',81,'1','1',1120969.56,1121968.52,998.96,294693.20,0.00,0.00,0.00,0.00,0.00),('8','216','2','21',82,'2','1',545589.17,546641.26,1052.09,310366.55,0.00,0.00,0.00,0.00,0.00),('8','216','3','21',83,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','21',84,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','22',85,'1','1',1121968.52,1123369.43,1400.91,413268.45,0.00,0.00,0.00,0.00,0.00),('8','216','2','22',86,'2','1',546641.26,547784.08,1142.82,337131.90,0.00,0.00,0.00,0.00,0.00),('8','216','3','22',87,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','22',88,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','23',89,'1','1',1123369.43,1124855.15,1485.72,438287.40,0.00,0.00,0.00,0.00,0.00),('8','216','2','23',90,'2','1',547784.08,549221.79,1437.71,424124.45,0.00,0.00,0.00,0.00,0.00),('8','216','3','23',91,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','23',92,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','24',93,'1','1',1124855.15,1125864.22,1009.07,297675.65,0.00,0.00,0.00,0.00,0.00),('8','216','2','24',94,'2','1',549221.79,551070.84,1849.05,545469.75,0.00,0.00,0.00,0.00,0.00),('8','216','3','24',95,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','24',96,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','25',97,'1','1',1125864.22,1126886.57,1022.35,301593.25,0.00,0.00,0.00,0.00,0.00),('8','216','2','25',98,'2','1',551070.84,552495.29,1424.45,420212.75,0.00,0.00,0.00,0.00,0.00),('8','216','3','25',99,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','25',100,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','26',101,'1','1',1126886.57,1128441.59,1555.02,458730.90,0.00,0.00,0.00,0.00,0.00),('8','216','2','26',102,'2','1',552495.29,553159.08,663.79,195818.05,0.00,0.00,0.00,0.00,0.00),('8','216','3','26',103,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','26',104,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','27',105,'1','1',1128441.59,1130209.73,1768.14,521601.30,0.00,0.00,0.00,0.00,0.00),('8','216','2','27',106,'2','1',553159.08,554034.03,874.95,258110.25,0.00,0.00,0.00,0.00,0.00),('8','216','3','27',107,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','27',108,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','28',109,'1','1',1130209.73,1131492.25,1282.52,378343.40,0.00,0.00,0.00,0.00,0.00),('8','216','2','28',110,'2','1',554034.03,555143.13,1109.10,327184.50,0.00,0.00,0.00,0.00,0.00),('8','216','3','28',111,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','28',112,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','29',113,'1','1',1131492.25,1132385.56,893.31,263526.45,0.00,0.00,0.00,0.00,0.00),('8','216','2','29',114,'2','1',555143.13,556255.59,1112.46,328175.70,0.00,0.00,0.00,0.00,0.00),('8','216','3','29',115,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','29',116,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','30',117,'1','1',1132385.56,1133170.11,784.55,231442.25,0.00,0.00,0.00,0.00,0.00),('8','216','2','30',118,'2','1',556255.59,557504.53,1248.94,368437.30,0.00,0.00,0.00,0.00,0.00),('8','216','3','30',119,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','30',120,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','31',121,'1','1',1133170.11,1134489.17,1319.06,389122.70,0.00,0.00,0.00,0.00,0.00),('8','216','2','31',122,'2','1',557504.53,558312.06,807.53,238221.35,0.00,0.00,0.00,0.00,0.00),('8','216','3','31',123,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','31',124,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','32',125,'1','1',1134489.17,1135419.54,930.37,274459.15,0.00,0.00,0.00,0.00,0.00),('8','216','2','32',126,'2','1',558312.06,559594.30,1282.24,378260.80,0.00,0.00,0.00,0.00,0.00),('8','216','3','32',127,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','32',128,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','33',129,'1','1',1135419.54,1135419.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','33',130,'2','1',559594.30,561350.88,1756.58,518191.10,0.00,0.00,0.00,0.00,0.00),('8','216','3','33',131,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','33',132,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','34',133,'1','1',1135419.54,1135531.59,112.05,33615.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','34',134,'2','1',561350.88,563811.56,2460.68,738204.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','34',135,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','34',136,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','35',137,'1','1',1135531.59,1139756.49,4224.90,1267470.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','35',138,'2','1',563811.56,565725.88,1914.32,574296.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','35',139,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','35',140,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','36',141,'1','1',1139756.49,1141070.69,1314.20,394260.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','36',142,'2','1',565725.88,571526.26,5800.38,1740114.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','36',143,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','36',144,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','37',145,'1','1',1141070.69,1144805.47,3734.78,1120434.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','37',146,'2','1',571526.26,575579.25,4052.99,1215897.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','37',147,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','37',148,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','38',149,'1','1',1144805.47,1149115.71,4310.24,1293072.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','38',150,'2','1',575579.25,578422.54,2843.29,852987.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','38',151,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','38',152,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','39',153,'1','1',1149115.71,1151537.07,2421.36,726408.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','39',154,'2','1',578422.54,578422.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','39',155,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','39',156,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','40',157,'1','1',1151537.07,1154759.79,3222.72,966816.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','40',158,'2','1',578422.54,581514.70,3092.16,927648.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','40',159,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','40',160,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','41',161,'1','1',1154759.79,1159225.07,4465.28,1339584.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','41',162,'2','1',581514.70,584869.15,3354.45,1006335.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','41',163,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','41',164,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','42',165,'1','1',1159225.07,1162449.50,3224.43,967329.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','42',166,'2','1',584869.15,588381.15,3512.00,1053600.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','42',167,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','42',168,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','43',169,'1','1',1162449.50,1167112.21,4662.71,1398813.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','43',170,'2','1',588381.15,590784.59,2403.44,721032.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','43',171,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','43',172,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','44',173,'1','1',1167112.21,1167112.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','44',174,'2','1',590784.59,595925.10,5140.51,1542153.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','44',175,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','44',176,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','45',177,'1','1',1167112.21,1169984.48,2872.27,861681.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','45',178,'2','1',595925.10,598351.27,2426.17,727851.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','45',179,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','45',180,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','46',181,'1','1',1169984.48,1173400.92,3416.44,1024932.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','46',182,'2','1',598351.27,600596.71,2245.44,673632.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','46',183,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','46',184,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','47',185,'1','1',1173400.92,1176484.18,3083.26,924978.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','47',186,'2','1',600596.71,604674.17,4077.46,1223238.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','47',187,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','47',188,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','48',189,'1','1',1176484.18,1179827.93,3343.75,1003125.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','48',190,'2','1',604674.17,607709.14,3034.97,910491.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','48',191,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','48',192,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','1','49',193,'1','1',1179827.93,1183463.97,3636.04,1090812.00,0.00,0.00,0.00,0.00,0.00),('8','216','2','49',194,'2','1',607709.14,610385.41,2676.27,802881.00,0.00,0.00,0.00,0.00,0.00),('8','216','3','49',195,'3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','216','4','49',196,'4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('8','216','1','1',0.00,290.00,0.00,0.00,0.00,0.00,0.00,1),('8','216','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,2),('8','216','1','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('8','216','2','1',290.00,290.00,6321.41,0.00,0.00,0.00,0.00,4),('8','216','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,5),('8','216','2','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,6),('8','216','3','1',290.00,290.00,5056.56,0.00,0.00,0.00,0.00,7),('8','216','3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,8),('8','216','3','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,9),('8','216','4','1',290.00,290.00,5084.12,0.00,0.00,0.00,0.00,10),('8','216','4','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,11),('8','216','4','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,12),('8','216','5','1',290.00,290.00,855.15,0.00,0.00,0.00,0.00,13),('8','216','5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,14),('8','216','5','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,15),('8','216','6','1',305.00,0.00,2546.50,0.00,0.00,0.00,0.00,16),('8','216','6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,17),('8','216','6','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,18),('8','216','7','1',305.00,0.00,0.00,0.00,0.00,0.00,0.00,19),('8','216','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,20),('8','216','7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,21),('8','216','8','1',305.00,305.00,2014.17,0.00,0.00,0.00,0.00,22),('8','216','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,23),('8','216','8','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,24),('8','216','9','1',305.00,305.00,2142.86,0.00,0.00,0.00,0.00,25),('8','216','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,26),('8','216','9','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('8','216','10','1',305.00,0.00,0.00,0.00,0.00,0.00,0.00,28),('8','216','10','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('8','216','10','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,30),('8','216','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,31),('8','216','11','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,32),('8','216','11','1',305.00,305.00,2087.49,0.00,0.00,0.00,0.00,33),('8','216','12','1',305.00,305.00,3356.70,0.00,0.00,0.00,0.00,34),('8','216','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('8','216','12','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,36),('8','216','13','1',305.00,305.00,3931.62,0.00,0.00,0.00,0.00,37),('8','216','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,38),('8','216','13','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('8','216','14','1',305.00,305.00,4178.62,0.00,0.00,0.00,0.00,40),('8','216','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,41),('8','216','14','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,42),('8','216','15','1',305.00,305.00,4294.55,0.00,0.00,0.00,0.00,43),('8','216','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,44),('8','216','15','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,45),('8','216','16','1',305.00,305.00,3349.74,0.00,0.00,0.00,0.00,46),('8','216','16','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,47),('8','216','16','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,48),('8','216','17','1',305.00,305.00,3144.31,0.00,0.00,0.00,0.00,49),('8','216','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,50),('8','216','17','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('8','216','18','1',305.00,305.00,2509.37,0.00,0.00,0.00,0.00,52),('8','216','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('8','216','18','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,54),('8','216','19','2',0.00,295.00,0.00,0.00,0.00,0.00,0.00,55),('8','216','19','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,56),('8','216','19','1',295.00,0.00,2568.92,0.00,0.00,0.00,0.00,57),('8','216','20','2',0.00,295.00,0.00,0.00,0.00,0.00,0.00,58),('8','216','20','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,59),('8','216','20','1',295.00,0.00,0.00,0.00,0.00,0.00,0.00,60),('8','216','21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,61),('8','216','21','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,62),('8','216','21','1',295.00,295.00,2051.05,0.00,0.00,0.00,0.00,63),('8','216','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,64),('8','216','22','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,65),('8','216','22','1',295.00,295.00,2543.73,0.00,0.00,0.00,0.00,66),('8','216','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,67),('8','216','23','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,68),('8','216','23','1',295.00,295.00,2923.43,0.00,0.00,0.00,0.00,69),('8','216','24','1',295.00,295.00,2858.12,0.00,0.00,0.00,0.00,70),('8','216','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,71),('8','216','24','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,72),('8','216','25','1',295.00,295.00,2446.80,0.00,0.00,0.00,0.00,73),('8','216','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,74),('8','216','25','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('8','216','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,76),('8','216','26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,77),('8','216','26','1',295.00,295.00,2218.81,0.00,0.00,0.00,0.00,78),('8','216','27','1',295.00,295.00,2643.09,0.00,0.00,0.00,0.00,79),('8','216','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,80),('8','216','27','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,81),('8','216','28','1',295.00,295.00,2391.62,0.00,0.00,0.00,0.00,82),('8','216','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,83),('8','216','28','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,84),('8','216','29','1',295.00,295.00,2005.77,0.00,0.00,0.00,0.00,85),('8','216','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,86),('8','216','29','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,87),('8','216','30','1',295.00,295.00,2033.49,0.00,0.00,0.00,0.00,88),('8','216','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,89),('8','216','30','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,90),('8','216','31','1',295.00,295.00,2126.59,0.00,0.00,0.00,0.00,91),('8','216','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,92),('8','216','31','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,93),('8','216','32','1',295.00,295.00,2212.61,0.00,0.00,0.00,0.00,94),('8','216','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,95),('8','216','32','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,96),('8','216','33','1',295.00,295.00,1756.58,0.00,0.00,0.00,0.00,97),('8','216','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,98),('8','216','33','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,99),('8','216','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,100),('8','216','34','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,101),('8','216','34','1',295.00,300.00,2572.73,0.00,0.00,0.00,0.00,102),('8','216','35','1',300.00,300.00,6139.22,0.00,0.00,0.00,0.00,103),('8','216','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,104),('8','216','35','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,105),('8','216','36','1',300.00,300.00,7114.58,0.00,0.00,0.00,0.00,106),('8','216','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,107),('8','216','36','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,108),('8','216','37','1',300.00,300.00,7787.77,0.00,0.00,0.00,0.00,109),('8','216','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,110),('8','216','37','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,111),('8','216','38','1',300.00,300.00,7153.53,0.00,0.00,0.00,0.00,112),('8','216','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,113),('8','216','38','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,114),('8','216','39','1',300.00,300.00,2421.36,0.00,0.00,0.00,0.00,115),('8','216','39','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,116),('8','216','39','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,117),('8','216','40','1',300.00,300.00,6314.88,0.00,0.00,0.00,0.00,118),('8','216','40','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,119),('8','216','40','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,120),('8','216','41','1',300.00,300.00,7819.73,0.00,0.00,0.00,0.00,121),('8','216','41','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,122),('8','216','41','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,123),('8','216','42','1',300.00,300.00,6736.43,0.00,0.00,0.00,0.00,124),('8','216','42','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,125),('8','216','42','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,126),('8','216','43','1',300.00,300.00,7066.15,0.00,0.00,0.00,0.00,127),('8','216','43','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,128),('8','216','43','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,129),('8','216','44','1',300.00,300.00,5140.51,0.00,0.00,0.00,0.00,130),('8','216','44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,131),('8','216','44','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,132),('8','216','45','1',300.00,300.00,5298.44,0.00,0.00,0.00,0.00,133),('8','216','45','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,134),('8','216','45','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,135),('8','216','46','1',300.00,300.00,5661.88,0.00,0.00,0.00,0.00,136),('8','216','46','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,137),('8','216','46','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,138),('8','216','47','1',300.00,300.00,7160.72,0.00,0.00,0.00,0.00,139),('8','216','47','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,140),('8','216','47','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,141),('8','216','48','1',300.00,300.00,6378.72,0.00,0.00,0.00,0.00,142),('8','216','48','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,143),('8','216','48','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,144),('8','216','49','1',300.00,300.00,6312.31,0.00,0.00,0.00,0.00,145),('8','216','49','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,146),('8','216','49','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,147);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('8',1,'216','PRODUCT TANK','Tanks Containing Products.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('8','216','1',1,0,'1','PMS TANK 1',41000.00,0.00,NULL,'TANK CONTAINING PETROL.','963','2022-10-16 01:57:42','2022-10-16 01:57:42','963',5,0),('8','216','1',2,0,'1','PMS TANK 3',33000.00,0.00,NULL,'Tank Containing Petrol','963','2022-10-16 01:59:42','2022-10-16 01:59:42','963',5,0),('8','216','1',3,0,'2','AGO TANK ',33000.00,0.00,NULL,'TANK CONTAINING DIESEL.','963','2022-10-16 02:01:21','2022-10-16 02:01:21','963',5,0),('8','216','1',4,0,'3','DPK TANK',33000.00,0.00,NULL,'TANK CONTAINING KEROSINE.','963','2022-10-16 02:02:21','2022-10-16 02:02:21','963',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'8','216',4,0.00,'2023-03-12 17:13:34'),(2,'8','216',3,0.00,'2023-03-12 17:13:34'),(3,'8','216',2,4746.07,'2023-03-12 17:13:34'),(4,'8','216',1,5683.50,'2023-03-12 17:13:34');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,4959000.00,17100.00,0.00,0.00,'2022-12-09 14:45:37','',''),(2,'8','216',NULL,1,'Returned purchase #1 to Lausu Energy Resources',4959000.00,0.00,0.00,17100.00,0.00,'2022-12-09 14:52:27','',''),(3,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,145000.00,500.00,0.00,0.00,'2022-12-10 12:03:41','',''),(4,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,4959000.00,17100.00,0.00,0.00,'2022-12-10 12:11:18','',''),(5,'8','216',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,350.00,0.00,'2022-12-10 12:34:13','',''),(6,'8','216','2',1,'Received from bridging 2',0.00,0.00,350.00,0.00,0.00,'2022-12-10 12:34:13','',''),(7,'8','216',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,150.00,0.00,'2022-12-10 12:35:16','',''),(8,'8','216','1',1,'Received from bridging 1',0.00,0.00,150.00,0.00,0.00,'2022-12-10 12:35:16','',''),(9,'8','216',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,17100.00,0.00,'2022-12-10 12:47:41','',''),(10,'8','216','2',1,'Received from bridging 3',0.00,0.00,17100.00,0.00,0.00,'2022-12-10 12:47:41','',''),(11,'8','216','2',1,'Sale Id shift 2',0.00,0.00,0.00,6321.41,0.00,'2022-12-10 13:36:11','',''),(12,'8','216',NULL,1,'Sale Id shift 2',1833208.90,0.00,0.00,0.00,0.00,'2022-12-10 13:36:11','',''),(13,'8','216','2',1,'Sale Id shift 3',0.00,0.00,0.00,5056.56,0.00,'2022-12-10 13:48:47','',''),(14,'8','216',NULL,1,'Sale Id shift 3',1466402.40,0.00,0.00,0.00,0.00,'2022-12-10 13:48:47','',''),(15,'8','216','2',1,'Sale Id shift 4',0.00,0.00,0.00,5084.12,0.00,'2022-12-12 13:12:45','',''),(16,'8','216',NULL,1,'Sale Id shift 4',1474394.80,0.00,0.00,0.00,0.00,'2022-12-12 13:12:45','',''),(17,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,10171750.00,33350.00,0.00,0.00,'2022-12-21 16:24:32','',''),(18,'8','216',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,16150.00,0.00,'2022-12-25 11:41:44','',''),(19,'8','216','2',1,'Received from bridging 5',0.00,0.00,16150.00,0.00,0.00,'2022-12-25 11:41:44','',''),(20,'8','216',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,17200.00,0.00,'2022-12-25 11:42:06','',''),(21,'8','216','1',1,'Received from bridging 4',0.00,0.00,17200.00,0.00,0.00,'2022-12-25 11:42:06','',''),(22,'8','216','2',1,'Sale Id shift 5',0.00,0.00,0.00,855.15,0.00,'2022-12-25 11:44:56','',''),(23,'8','216',NULL,1,'Sale Id shift 5',247993.50,0.00,0.00,0.00,0.00,'2022-12-25 11:44:56','',''),(24,'8','216','1',1,'Sale Id shift 6',0.00,0.00,0.00,1278.85,0.00,'2022-12-25 15:06:03','',''),(25,'8','216','2',1,'Sale Id shift 6',0.00,0.00,0.00,1267.65,0.00,'2022-12-25 15:06:03','',''),(26,'8','216',NULL,1,'Sale Id shift 6',776682.50,0.00,0.00,0.00,0.00,'2022-12-25 15:06:03','',''),(27,'8','216','1',1,'Sale Id shift 8',0.00,0.00,0.00,789.26,0.00,'2022-12-27 18:20:27','',''),(28,'8','216','2',1,'Sale Id shift 8',0.00,0.00,0.00,1224.91,0.00,'2022-12-27 18:20:27','',''),(29,'8','216',NULL,1,'Sale Id shift 8',614321.85,0.00,0.00,0.00,0.00,'2022-12-27 18:20:27','',''),(30,'8','216','1',1,'Sale Id shift 9',0.00,0.00,0.00,1706.70,0.00,'2022-12-27 18:31:24','',''),(31,'8','216','2',1,'Sale Id shift 9',0.00,0.00,0.00,436.16,0.00,'2022-12-27 18:31:24','',''),(32,'8','216',NULL,1,'Sale Id shift 9',653572.30,0.00,0.00,0.00,0.00,'2022-12-27 18:31:24','',''),(33,'8','216','1',1,'Sale Id shift 11',0.00,0.00,0.00,1259.82,0.00,'2022-12-29 07:59:10','',''),(34,'8','216','2',1,'Sale Id shift 11',0.00,0.00,0.00,827.67,0.00,'2022-12-29 07:59:10','',''),(35,'8','216',NULL,1,'Sale Id shift 11',636684.45,0.00,0.00,0.00,0.00,'2022-12-29 07:59:10','',''),(36,'8','216','1',1,'Sale Id shift 12',0.00,0.00,0.00,2102.39,0.00,'2022-12-29 08:32:18','',''),(37,'8','216','2',1,'Sale Id shift 12',0.00,0.00,0.00,1254.31,0.00,'2022-12-29 08:32:18','',''),(38,'8','216',NULL,1,'Sale Id shift 12',1023793.50,0.00,0.00,0.00,0.00,'2022-12-29 08:32:18','',''),(39,'8','216','1',1,'Sale Id shift 13',0.00,0.00,0.00,1526.02,0.00,'2022-12-29 08:47:11','',''),(40,'8','216','2',1,'Sale Id shift 13',0.00,0.00,0.00,2405.60,0.00,'2022-12-29 08:47:11','',''),(41,'8','216',NULL,1,'Sale Id shift 13',1199144.10,0.00,0.00,0.00,0.00,'2022-12-29 08:47:11','',''),(42,'8','216','1',1,'Sale Id shift 14',0.00,0.00,0.00,2852.38,0.00,'2022-12-29 09:01:07','',''),(43,'8','216','2',1,'Sale Id shift 14',0.00,0.00,0.00,1326.24,0.00,'2022-12-29 09:01:07','',''),(44,'8','216',NULL,1,'Sale Id shift 14',1274479.10,0.00,0.00,0.00,0.00,'2022-12-29 09:01:07','',''),(45,'8','216','1',1,'Sale Id shift 15',0.00,0.00,0.00,1797.69,0.00,'2022-12-29 09:12:42','',''),(46,'8','216','2',1,'Sale Id shift 15',0.00,0.00,0.00,2496.86,0.00,'2022-12-29 09:12:42','',''),(47,'8','216',NULL,1,'Sale Id shift 15',1309837.75,0.00,0.00,0.00,0.00,'2022-12-29 09:12:42','',''),(48,'8','216','1',1,'Sale Id shift 16',0.00,0.00,0.00,2201.76,0.00,'2022-12-29 09:24:20','',''),(49,'8','216','2',1,'Sale Id shift 16',0.00,0.00,0.00,1147.98,0.00,'2022-12-29 09:24:20','',''),(50,'8','216',NULL,1,'Sale Id shift 16',1021670.70,0.00,0.00,0.00,0.00,'2022-12-29 09:24:20','',''),(51,'8','216','1',1,'Sale Id shift 17',0.00,0.00,0.00,1396.33,0.00,'2022-12-29 19:05:24','',''),(52,'8','216','2',1,'Sale Id shift 17',0.00,0.00,0.00,1747.98,0.00,'2022-12-29 19:05:24','',''),(53,'8','216',NULL,1,'Sale Id shift 17',959014.55,0.00,0.00,0.00,0.00,'2022-12-29 19:05:24','',''),(54,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,9735000.00,33000.00,0.00,0.00,'2023-01-03 16:47:57','',''),(55,'8','216',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,17000.00,0.00,'2023-01-03 16:52:43','',''),(56,'8','216','2',1,'Received from bridging 7',0.00,0.00,17000.00,0.00,0.00,'2023-01-03 16:52:43','',''),(57,'8','216',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,16000.00,0.00,'2023-01-03 16:53:26','',''),(58,'8','216','1',1,'Received from bridging 6',0.00,0.00,16000.00,0.00,0.00,'2023-01-03 16:53:26','',''),(59,'8','216','1',1,'Sale Id shift 18',0.00,0.00,0.00,444.14,0.00,'2023-01-03 19:08:42','',''),(60,'8','216','2',1,'Sale Id shift 18',0.00,0.00,0.00,2065.23,0.00,'2023-01-03 19:08:42','',''),(61,'8','216',NULL,1,'Sale Id shift 18',765357.85,0.00,0.00,0.00,0.00,'2023-01-03 19:08:42','',''),(62,'8','216','1',1,'Sale Id shift 19',0.00,0.00,0.00,1352.79,0.00,'2023-01-03 19:42:16','',''),(63,'8','216','2',1,'Sale Id shift 19',0.00,0.00,0.00,1216.13,0.00,'2023-01-03 19:42:16','',''),(64,'8','216',NULL,1,'Sale Id shift 19',757831.40,0.00,0.00,0.00,0.00,'2023-01-03 19:42:16','',''),(65,'8','216','1',1,'Sale Id shift 21',0.00,0.00,0.00,998.96,0.00,'2023-01-04 06:32:29','',''),(66,'8','216','2',1,'Sale Id shift 21',0.00,0.00,0.00,1052.09,0.00,'2023-01-04 06:32:29','',''),(67,'8','216',NULL,1,'Sale Id shift 21',605059.75,0.00,0.00,0.00,0.00,'2023-01-04 06:32:29','',''),(68,'8','216','1',1,'Sale Id shift 22',0.00,0.00,0.00,1400.91,0.00,'2023-01-04 06:37:32','',''),(69,'8','216','2',1,'Sale Id shift 22',0.00,0.00,0.00,1142.82,0.00,'2023-01-04 06:37:32','',''),(70,'8','216',NULL,1,'Sale Id shift 22',750400.35,0.00,0.00,0.00,0.00,'2023-01-04 06:37:32','',''),(71,'8','216','1',1,'Sale Id shift 23',0.00,0.00,0.00,1485.72,0.00,'2023-01-04 18:41:28','',''),(72,'8','216','2',1,'Sale Id shift 23',0.00,0.00,0.00,1437.71,0.00,'2023-01-04 18:41:28','',''),(73,'8','216',NULL,1,'Sale Id shift 23',862411.85,0.00,0.00,0.00,0.00,'2023-01-04 18:41:28','',''),(74,'8','216','1',1,'Sale Id shift 24',0.00,0.00,0.00,1009.07,0.00,'2023-01-06 08:15:14','',''),(75,'8','216','2',1,'Sale Id shift 24',0.00,0.00,0.00,1849.05,0.00,'2023-01-06 08:15:14','',''),(76,'8','216',NULL,1,'Sale Id shift 24',843145.40,0.00,0.00,0.00,0.00,'2023-01-06 08:15:14','',''),(77,'8','216','1',1,'Sale Id shift 25',0.00,0.00,0.00,1022.35,0.00,'2023-01-09 22:38:56','',''),(78,'8','216','2',1,'Sale Id shift 25',0.00,0.00,0.00,1424.45,0.00,'2023-01-09 22:38:56','',''),(79,'8','216',NULL,1,'Sale Id shift 25',721806.00,0.00,0.00,0.00,0.00,'2023-01-09 22:38:56','',''),(80,'8','216','1',1,'Sale Id shift 26',0.00,0.00,0.00,1555.02,0.00,'2023-01-11 18:01:14','',''),(81,'8','216','2',1,'Sale Id shift 26',0.00,0.00,0.00,663.79,0.00,'2023-01-11 18:01:14','',''),(82,'8','216',NULL,1,'Sale Id shift 26',654548.95,0.00,0.00,0.00,0.00,'2023-01-11 18:01:14','',''),(83,'8','216','1',1,'Sale Id shift 27',0.00,0.00,0.00,1768.14,0.00,'2023-01-12 15:07:33','',''),(84,'8','216','2',1,'Sale Id shift 27',0.00,0.00,0.00,874.95,0.00,'2023-01-12 15:07:33','',''),(85,'8','216',NULL,1,'Sale Id shift 27',779711.55,0.00,0.00,0.00,0.00,'2023-01-12 15:07:33','',''),(86,'8','216','1',1,'Sale Id shift 28',0.00,0.00,0.00,1282.52,0.00,'2023-01-13 18:40:34','',''),(87,'8','216','2',1,'Sale Id shift 28',0.00,0.00,0.00,1109.10,0.00,'2023-01-13 18:40:34','',''),(88,'8','216',NULL,1,'Sale Id shift 28',705527.90,0.00,0.00,0.00,0.00,'2023-01-13 18:40:34','',''),(89,'8','216','1',1,'Sale Id shift 29',0.00,0.00,0.00,893.31,0.00,'2023-01-13 18:49:06','',''),(90,'8','216','2',1,'Sale Id shift 29',0.00,0.00,0.00,1112.46,0.00,'2023-01-13 18:49:06','',''),(91,'8','216',NULL,1,'Sale Id shift 29',591702.15,0.00,0.00,0.00,0.00,'2023-01-13 18:49:06','',''),(92,'8','216','1',1,'Sale Id shift 30',0.00,0.00,0.00,784.55,0.00,'2023-01-14 17:57:36','',''),(93,'8','216','2',1,'Sale Id shift 30',0.00,0.00,0.00,1248.94,0.00,'2023-01-14 17:57:36','',''),(94,'8','216',NULL,1,'Sale Id shift 30',599879.55,0.00,0.00,0.00,0.00,'2023-01-14 17:57:36','',''),(95,'8','216','1',1,'Sale Id shift 31',0.00,0.00,0.00,1319.06,0.00,'2023-01-14 18:05:04','',''),(96,'8','216','2',1,'Sale Id shift 31',0.00,0.00,0.00,807.53,0.00,'2023-01-14 18:05:04','',''),(97,'8','216',NULL,1,'Sale Id shift 31',627344.05,0.00,0.00,0.00,0.00,'2023-01-14 18:05:04','',''),(98,'8','216','1',1,'Sale Id shift 32',0.00,0.00,0.00,930.37,0.00,'2023-01-14 18:10:14','',''),(99,'8','216','2',1,'Sale Id shift 32',0.00,0.00,0.00,1282.24,0.00,'2023-01-14 18:10:14','',''),(100,'8','216',NULL,1,'Sale Id shift 32',652719.95,0.00,0.00,0.00,0.00,'2023-01-14 18:10:14','',''),(101,'8','216','2',1,'Sale Id shift 33',0.00,0.00,0.00,1756.58,0.00,'2023-01-15 09:01:27','',''),(102,'8','216',NULL,1,'Sale Id shift 33',518191.10,0.00,0.00,0.00,0.00,'2023-01-15 09:01:27','',''),(103,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,9960000.00,33200.00,0.00,0.00,'2023-02-26 10:02:51','',''),(104,'8','216',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,17000.00,0.00,'2023-02-26 14:35:23','',''),(105,'8','216','2',1,'Received from bridging 9',0.00,0.00,17000.00,0.00,0.00,'2023-02-26 14:35:23','',''),(106,'8','216',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,16200.00,0.00,'2023-02-26 14:36:29','',''),(107,'8','216','1',1,'Received from bridging 8',0.00,0.00,16200.00,0.00,0.00,'2023-02-26 14:36:29','',''),(108,'8','216','1',1,'Sale Id shift 34',0.00,0.00,0.00,112.05,0.00,'2023-02-27 19:10:26','',''),(109,'8','216','2',1,'Sale Id shift 34',0.00,0.00,0.00,2460.68,0.00,'2023-02-27 19:10:26','',''),(110,'8','216',NULL,1,'Sale Id shift 34',758955.35,0.00,0.00,0.00,0.00,'2023-02-27 19:10:26','',''),(111,'8','216','1',1,'Sale Id shift 35',0.00,0.00,0.00,4224.90,0.00,'2023-02-27 19:17:28','',''),(112,'8','216','2',1,'Sale Id shift 35',0.00,0.00,0.00,1914.32,0.00,'2023-02-27 19:17:28','',''),(113,'8','216',NULL,1,'Sale Id shift 35',1841766.00,0.00,0.00,0.00,0.00,'2023-02-27 19:17:28','',''),(114,'8','216','1',1,'Sale Id shift 36',0.00,0.00,0.00,1314.20,0.00,'2023-02-27 19:24:00','',''),(115,'8','216','2',1,'Sale Id shift 36',0.00,0.00,0.00,5800.38,0.00,'2023-02-27 19:24:00','',''),(116,'8','216',NULL,1,'Sale Id shift 36',2134374.00,0.00,0.00,0.00,0.00,'2023-02-27 19:24:00','',''),(117,'8','216','1',1,'Sale Id shift 37',0.00,0.00,0.00,3734.78,0.00,'2023-03-01 14:35:49','',''),(118,'8','216','2',1,'Sale Id shift 37',0.00,0.00,0.00,4052.99,0.00,'2023-03-01 14:35:49','',''),(119,'8','216',NULL,1,'Sale Id shift 37',2336331.00,0.00,0.00,0.00,0.00,'2023-03-01 14:35:49','',''),(120,'8','216','1',1,'Sale Id shift 38',0.00,0.00,0.00,4310.24,0.00,'2023-03-03 07:13:47','',''),(121,'8','216','2',1,'Sale Id shift 38',0.00,0.00,0.00,2843.29,0.00,'2023-03-03 07:13:47','',''),(122,'8','216',NULL,1,'Sale Id shift 38',2146059.00,0.00,0.00,0.00,0.00,'2023-03-03 07:13:47','',''),(123,'8','216','1',1,'Sale Id shift 39',0.00,0.00,0.00,2421.36,0.00,'2023-03-03 07:51:40','',''),(124,'8','216',NULL,1,'Sale Id shift 39',726408.00,0.00,0.00,0.00,0.00,'2023-03-03 07:51:40','',''),(125,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,9900000.00,33000.00,0.00,0.00,'2023-03-03 14:20:10','',''),(126,'8','216',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,16000.00,0.00,'2023-03-03 14:53:31','',''),(127,'8','216','1',1,'Received from bridging 10',0.00,0.00,16000.00,0.00,0.00,'2023-03-03 14:53:31','',''),(128,'8','216',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,17000.00,0.00,'2023-03-03 14:53:47','',''),(129,'8','216','2',1,'Received from bridging 11',0.00,0.00,17000.00,0.00,0.00,'2023-03-03 14:53:47','',''),(130,'8','216','1',1,'Sale Id shift 40',0.00,0.00,0.00,3222.72,0.00,'2023-03-05 10:49:33','',''),(131,'8','216','2',1,'Sale Id shift 40',0.00,0.00,0.00,3092.16,0.00,'2023-03-05 10:49:33','',''),(132,'8','216',NULL,1,'Sale Id shift 40',1894464.00,0.00,0.00,0.00,0.00,'2023-03-05 10:49:33','',''),(133,'8','216','1',1,'Sale Id shift 41',0.00,0.00,0.00,4465.28,0.00,'2023-03-05 10:54:44','',''),(134,'8','216','2',1,'Sale Id shift 41',0.00,0.00,0.00,3354.45,0.00,'2023-03-05 10:54:44','',''),(135,'8','216',NULL,1,'Sale Id shift 41',2345919.00,0.00,0.00,0.00,0.00,'2023-03-05 10:54:44','',''),(136,'8','216','1',1,'Sale Id shift 42',0.00,0.00,0.00,3224.43,0.00,'2023-03-05 11:00:20','',''),(137,'8','216','2',1,'Sale Id shift 42',0.00,0.00,0.00,3512.00,0.00,'2023-03-05 11:00:20','',''),(138,'8','216',NULL,1,'Sale Id shift 42',2020929.00,0.00,0.00,0.00,0.00,'2023-03-05 11:00:20','',''),(139,'8','216','1',1,'Sale Id shift 43',0.00,0.00,0.00,4662.71,0.00,'2023-03-07 09:53:37','',''),(140,'8','216','2',1,'Sale Id shift 43',0.00,0.00,0.00,2403.44,0.00,'2023-03-07 09:53:37','',''),(141,'8','216',NULL,1,'Sale Id shift 43',2119845.00,0.00,0.00,0.00,0.00,'2023-03-07 09:53:37','',''),(142,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,10410000.00,34700.00,0.00,0.00,'2023-03-08 08:29:31','',''),(143,'8','216',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,17000.00,0.00,'2023-03-08 09:12:36','',''),(144,'8','216','2',1,'Received from bridging 13',0.00,0.00,17000.00,0.00,0.00,'2023-03-08 09:12:36','',''),(145,'8','216',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,17700.00,0.00,'2023-03-08 09:13:12','',''),(146,'8','216','1',1,'Received from bridging 12',0.00,0.00,17700.00,0.00,0.00,'2023-03-08 09:13:12','',''),(147,'8','216','2',1,'Sale Id shift 44',0.00,0.00,0.00,5140.51,0.00,'2023-03-10 07:29:31','',''),(148,'8','216',NULL,1,'Sale Id shift 44',1542153.00,0.00,0.00,0.00,0.00,'2023-03-10 07:29:31','',''),(149,'8','216','1',1,'Sale Id shift 45',0.00,0.00,0.00,2872.27,0.00,'2023-03-10 07:39:07','',''),(150,'8','216','2',1,'Sale Id shift 45',0.00,0.00,0.00,2426.17,0.00,'2023-03-10 07:39:07','',''),(151,'8','216',NULL,1,'Sale Id shift 45',1589532.00,0.00,0.00,0.00,0.00,'2023-03-10 07:39:07','',''),(152,'8','216','1',1,'Sale Id shift 46',0.00,0.00,0.00,3416.44,0.00,'2023-03-10 07:47:01','',''),(153,'8','216','2',1,'Sale Id shift 46',0.00,0.00,0.00,2245.44,0.00,'2023-03-10 07:47:01','',''),(154,'8','216',NULL,1,'Sale Id shift 46',1698564.00,0.00,0.00,0.00,0.00,'2023-03-10 07:47:01','',''),(155,'8','216','1',1,'Sale Id shift 47',0.00,0.00,0.00,3083.26,0.00,'2023-03-11 11:47:49','',''),(156,'8','216','2',1,'Sale Id shift 47',0.00,0.00,0.00,4077.46,0.00,'2023-03-11 11:47:49','',''),(157,'8','216',NULL,1,'Sale Id shift 47',2148216.00,0.00,0.00,0.00,0.00,'2023-03-11 11:47:49','',''),(158,'8','216','1',1,'Sale Id shift 48',0.00,0.00,0.00,3343.75,0.00,'2023-03-12 17:11:44','',''),(159,'8','216','2',1,'Sale Id shift 48',0.00,0.00,0.00,3034.97,0.00,'2023-03-12 17:11:44','',''),(160,'8','216',NULL,1,'Sale Id shift 48',1913616.00,0.00,0.00,0.00,0.00,'2023-03-12 17:11:44','',''),(161,'8','216','1',1,'Sale Id shift 49',0.00,0.00,0.00,3636.04,0.00,'2023-03-12 17:17:34','',''),(162,'8','216','2',1,'Sale Id shift 49',0.00,0.00,0.00,2676.27,0.00,'2023-03-12 17:17:34','',''),(163,'8','216',NULL,1,'Sale Id shift 49',1893693.00,0.00,0.00,0.00,0.00,'2023-03-12 17:17:34','',''),(164,'8','216',NULL,1,'Purchased from Lausu Energy Resources',0.00,10140000.00,33800.00,0.00,0.00,'2023-03-20 16:05:20','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'8','216',3,0.00,'2023-03-12 17:13:34'),(2,'8','216',2,0.00,'2023-03-12 17:13:34'),(3,'8','216',1,44229.57,'2023-03-20 16:05:20');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'8','216',1,'Sale Id shift 2',0.00,1833208.90,290.00,1833208.90,0.00,'2022-12-10 13:36:11'),(2,'8','216',1,'Sale Id shift 3',0.00,1466402.40,290.00,1466402.40,0.00,'2022-12-10 13:48:47'),(3,'8','216',1,'Sale Id shift 4',0.00,1474394.80,290.00,1474394.80,0.00,'2022-12-12 13:12:45'),(4,'8','216',1,'Sale Id shift 5',0.00,247993.50,290.00,247993.50,0.00,'2022-12-25 11:44:56'),(5,'8','216',1,'Sale Id shift 6',0.00,776682.50,0.00,0.00,-776682.50,'2022-12-25 15:06:03'),(6,'8','216',1,'Sale Id shift 8',0.00,614321.85,305.00,614321.85,0.00,'2022-12-27 18:20:27'),(7,'8','216',1,'Sale Id shift 9',0.00,653572.30,305.00,653572.30,0.00,'2022-12-27 18:31:24'),(8,'8','216',1,'Sale Id shift 11',0.00,636684.45,305.00,636684.45,0.00,'2022-12-29 07:59:10'),(9,'8','216',1,'Sale Id shift 12',0.00,1023793.50,305.00,1023793.50,0.00,'2022-12-29 08:32:18'),(10,'8','216',1,'Sale Id shift 13',0.00,1199144.10,305.00,1199144.10,0.00,'2022-12-29 08:47:11'),(11,'8','216',1,'Sale Id shift 14',0.00,1274479.10,305.00,1274479.10,0.00,'2022-12-29 09:01:07'),(12,'8','216',1,'Sale Id shift 15',0.00,1309837.75,305.00,1309837.75,0.00,'2022-12-29 09:12:42'),(13,'8','216',1,'Sale Id shift 16',0.00,1021670.70,305.00,1021670.70,0.00,'2022-12-29 09:24:20'),(14,'8','216',1,'Sale Id shift 17',0.00,959014.55,305.00,959014.55,0.00,'2022-12-29 19:05:24'),(15,'8','216',1,'Sale Id shift 18',0.00,765357.85,305.00,765357.85,0.00,'2023-01-03 19:08:42'),(16,'8','216',1,'Sale Id shift 19',0.00,757831.40,0.00,0.00,-757831.40,'2023-01-03 19:42:16'),(17,'8','216',1,'Sale Id shift 21',0.00,605059.75,295.00,605059.75,0.00,'2023-01-04 06:32:29'),(18,'8','216',1,'Sale Id shift 22',0.00,750400.35,295.00,750400.35,0.00,'2023-01-04 06:37:32'),(19,'8','216',1,'Sale Id shift 23',0.00,862411.85,295.00,862411.85,0.00,'2023-01-04 18:41:28'),(20,'8','216',1,'Sale Id shift 24',0.00,843145.40,295.00,843145.40,0.00,'2023-01-06 08:15:14'),(21,'8','216',1,'Sale Id shift 25',0.00,721806.00,295.00,721806.00,0.00,'2023-01-09 22:38:56'),(22,'8','216',1,'Sale Id shift 26',0.00,654548.95,295.00,654548.95,0.00,'2023-01-11 18:01:14'),(23,'8','216',1,'Sale Id shift 27',0.00,779711.55,295.00,779711.55,0.00,'2023-01-12 15:07:33'),(24,'8','216',1,'Sale Id shift 28',0.00,705527.90,295.00,705527.90,0.00,'2023-01-13 18:40:34'),(25,'8','216',1,'Sale Id shift 29',0.00,591702.15,295.00,591702.15,0.00,'2023-01-13 18:49:06'),(26,'8','216',1,'Sale Id shift 30',0.00,599879.55,295.00,599879.55,0.00,'2023-01-14 17:57:36'),(27,'8','216',1,'Sale Id shift 31',0.00,627344.05,295.00,627344.05,0.00,'2023-01-14 18:05:04'),(28,'8','216',1,'Sale Id shift 32',0.00,652719.95,295.00,652719.95,0.00,'2023-01-14 18:10:14'),(29,'8','216',1,'Sale Id shift 33',0.00,518191.10,295.00,518191.10,0.00,'2023-01-15 09:01:27'),(30,'8','216',1,'Sale Id shift 34',0.00,758955.35,300.00,771819.00,12863.65,'2023-02-27 19:10:26'),(31,'8','216',1,'Sale Id shift 35',0.00,1841766.00,300.00,1841766.00,0.00,'2023-02-27 19:17:28'),(32,'8','216',1,'Sale Id shift 36',0.00,2134374.00,300.00,2134374.00,0.00,'2023-02-27 19:24:00'),(33,'8','216',1,'Sale Id shift 37',0.00,2336331.00,300.00,2336331.00,0.00,'2023-03-01 14:35:49'),(34,'8','216',1,'Sale Id shift 38',0.00,2146059.00,300.00,2146059.00,0.00,'2023-03-03 07:13:47'),(35,'8','216',1,'Sale Id shift 39',0.00,726408.00,300.00,726408.00,0.00,'2023-03-03 07:51:40'),(36,'8','216',1,'Sale Id shift 40',0.00,1894464.00,300.00,1894464.00,0.00,'2023-03-05 10:49:33'),(37,'8','216',1,'Sale Id shift 41',0.00,2345919.00,300.00,2345919.00,0.00,'2023-03-05 10:54:44'),(38,'8','216',1,'Sale Id shift 42',0.00,2020929.00,300.00,2020929.00,0.00,'2023-03-05 11:00:20'),(39,'8','216',1,'Sale Id shift 43',0.00,2119845.00,300.00,2119845.00,0.00,'2023-03-07 09:53:37'),(40,'8','216',1,'Sale Id shift 44',0.00,1542153.00,300.00,1542153.00,0.00,'2023-03-10 07:29:31'),(41,'8','216',1,'Sale Id shift 45',0.00,1589532.00,300.00,1589532.00,0.00,'2023-03-10 07:39:07'),(42,'8','216',1,'Sale Id shift 46',0.00,1698564.00,300.00,1698564.00,0.00,'2023-03-10 07:47:01'),(43,'8','216',1,'Sale Id shift 47',0.00,2148216.00,300.00,2148216.00,0.00,'2023-03-11 11:47:49'),(44,'8','216',1,'Sale Id shift 48',0.00,1913616.00,300.00,1913616.00,0.00,'2023-03-12 17:11:44'),(45,'8','216',1,'Sale Id shift 49',0.00,1893693.00,300.00,1893693.00,0.00,'2023-03-12 17:17:34');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=210 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('8','216',1,'','20','2',0.00,0.00,'Sales from shift 1 on 2022-12-09 13:59:02 ','2022-12-09 13:59:02','',''),('8','216',2,'','6.1','3',0.00,0.00,'Sales from shift 1 on 2022-12-09 13:59:02 ','2022-12-09 13:59:02','',''),('8','216',3,'','24','5',0.00,4959000.00,'Purchase Id 1 for 17,100.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-09 14:45:37','',''),('8','216',4,'','supplier','1',4959000.00,0.00,'Purchase Id 1 for 17,100.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-09 14:45:37','',''),('8','216',5,'','supplier','1',0.00,4959000.00,'Purchase Id 1 for 17,100.00 litters of Petrol - PMS returned to Lausu Energy Resources','2022-12-09 14:52:27','',''),('8','216',6,'','24','5',0.00,145000.00,'Purchase Id 5 for 500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-10 12:03:41','',''),('8','216',7,'','supplier','1',145000.00,0.00,'Purchase Id 5 for 500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-10 12:03:41','',''),('8','216',8,'','24','5',0.00,4959000.00,'Purchase Id 6 for 17,100.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-10 12:11:18','',''),('8','216',9,'','supplier','1',4959000.00,0.00,'Purchase Id 6 for 17,100.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-10 12:11:18','',''),('8','216',10,'','20','2',1833208.90,0.00,'Sales from shift 2 on 2022-12-10 13:36:11 ','2022-12-10 13:36:11','',''),('8','216',11,'','6.1','3',0.00,1833208.90,'Sales from shift 2 on 2022-12-10 13:36:11 ','2022-12-10 13:36:11','',''),('8','216',12,'','20','2',1466402.40,0.00,'Sales from shift 3 on 2022-12-10 13:48:47 ','2022-12-10 13:48:47','',''),('8','216',13,'','6.1','3',0.00,1466402.40,'Sales from shift 3 on 2022-12-10 13:48:47 ','2022-12-10 13:48:47','',''),('8','216',14,'','2','6',1833210.00,0.00,'Payment Id 1 for invoice:2, receipt: 002 by Lausu Energy Resources','2022-12-11 22:45:10','',''),('8','216',15,'','supplier','1',0.00,1833210.00,'Payment Id 1 for invoice:2, receipt: 002 by Lausu Energy Resources','2022-12-11 22:45:10','',''),('8','216',16,'','2','6',1466400.00,0.00,'Payment Id 2 for invoice:3, receipt: 003 by Lausu Energy Resources','2022-12-11 22:45:33','',''),('8','216',17,'','supplier','1',0.00,1466400.00,'Payment Id 2 for invoice:3, receipt: 003 by Lausu Energy Resources','2022-12-11 22:45:33','',''),('8','216',18,'','20','2',1474394.80,0.00,'Sales from shift 4 on 2022-12-12 13:12:45 ','2022-12-12 13:12:45','',''),('8','216',19,'','6.1','3',0.00,1474394.80,'Sales from shift 4 on 2022-12-12 13:12:45 ','2022-12-12 13:12:45','',''),('8','216',20,'','2','6',1474395.00,0.00,'Payment Id 3 for invoice:4, receipt: 4 by Lausu Energy Resources','2022-12-14 14:32:37','',''),('8','216',21,'','supplier','1',0.00,1474395.00,'Payment Id 3 for invoice:4, receipt: 4 by Lausu Energy Resources','2022-12-14 14:32:37','',''),('8','216',22,'','24','5',0.00,10171750.00,'Purchase Id 7 for 33,350.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-21 16:24:32','',''),('8','216',23,'','supplier','1',10171750.00,0.00,'Purchase Id 7 for 33,350.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-21 16:24:32','',''),('8','216',24,'','20','2',247993.50,0.00,'Sales from shift 5 on 2022-12-25 11:44:56 ','2022-12-25 11:44:56','',''),('8','216',25,'','6.1','3',0.00,247993.50,'Sales from shift 5 on 2022-12-25 11:44:56 ','2022-12-25 11:44:56','',''),('8','216',26,'','20','2',0.00,0.00,'Sales from shift 6 on 2022-12-25 15:06:03 ','2022-12-25 15:06:03','',''),('8','216',27,'','6.1','3',0.00,0.00,'Sales from shift 6 on 2022-12-25 15:06:03 ','2022-12-25 15:06:03','',''),('8','216',28,'','2','6',247995.00,0.00,'Payment Id 4 for invoice:5, receipt: 5 by Lausu Energy Resources','2022-12-27 02:37:30','',''),('8','216',29,'','supplier','1',0.00,247995.00,'Payment Id 4 for invoice:5, receipt: 5 by Lausu Energy Resources','2022-12-27 02:37:30','',''),('8','216',30,'','2','6',776680.00,0.00,'Payment Id 5 for invoice:6, receipt: 006 by Lausu Energy Resources','2022-12-27 02:38:58','',''),('8','216',31,'','supplier','1',0.00,776680.00,'Payment Id 5 for invoice:6, receipt: 006 by Lausu Energy Resources','2022-12-27 02:38:58','',''),('8','216',32,'','2','6',614320.00,0.00,'Payment Id 6 for invoice:7, receipt: 007 by Lausu Energy Resources','2022-12-27 02:39:23','',''),('8','216',33,'','supplier','1',0.00,614320.00,'Payment Id 6 for invoice:7, receipt: 007 by Lausu Energy Resources','2022-12-27 02:39:23','',''),('8','216',34,'','20','2',0.00,0.00,'Sales from shift 7 on 2022-12-27 18:14:37 ','2022-12-27 18:14:37','',''),('8','216',35,'','6.1','3',0.00,0.00,'Sales from shift 7 on 2022-12-27 18:14:37 ','2022-12-27 18:14:37','',''),('8','216',36,'','20','2',614321.85,0.00,'Sales from shift 8 on 2022-12-27 18:20:27 ','2022-12-27 18:20:27','',''),('8','216',37,'','6.1','3',0.00,614321.85,'Sales from shift 8 on 2022-12-27 18:20:27 ','2022-12-27 18:20:27','',''),('8','216',38,'','20','2',653572.30,0.00,'Sales from shift 9 on 2022-12-27 18:31:24 ','2022-12-27 18:31:24','',''),('8','216',39,'','6.1','3',0.00,653572.30,'Sales from shift 9 on 2022-12-27 18:31:24 ','2022-12-27 18:31:24','',''),('8','216',40,'','2','6',653575.00,0.00,'Payment Id 7 for invoice:9, receipt: 9 by Lausu Energy Resources','2022-12-27 19:06:14','',''),('8','216',41,'','supplier','1',0.00,653575.00,'Payment Id 7 for invoice:9, receipt: 9 by Lausu Energy Resources','2022-12-27 19:06:14','',''),('8','216',42,'','20','2',0.00,0.00,'Sales from shift 10 on 2022-12-27 21:22:10 ','2022-12-27 21:22:10','',''),('8','216',43,'','6.1','3',0.00,0.00,'Sales from shift 10 on 2022-12-27 21:22:10 ','2022-12-27 21:22:10','',''),('8','216',44,'','20','2',636684.45,0.00,'Sales from shift 11 on 2022-12-29 07:59:10 ','2022-12-29 07:59:10','',''),('8','216',45,'','6.1','3',0.00,636684.45,'Sales from shift 11 on 2022-12-29 07:59:10 ','2022-12-29 07:59:10','',''),('8','216',46,'','20','2',1023793.50,0.00,'Sales from shift 12 on 2022-12-29 08:32:18 ','2022-12-29 08:32:18','',''),('8','216',47,'','6.1','3',0.00,1023793.50,'Sales from shift 12 on 2022-12-29 08:32:18 ','2022-12-29 08:32:18','',''),('8','216',48,'','20','2',1199144.10,0.00,'Sales from shift 13 on 2022-12-29 08:47:11 ','2022-12-29 08:47:11','',''),('8','216',49,'','6.1','3',0.00,1199144.10,'Sales from shift 13 on 2022-12-29 08:47:11 ','2022-12-29 08:47:11','',''),('8','216',50,'','20','2',1274479.10,0.00,'Sales from shift 14 on 2022-12-29 09:01:07 ','2022-12-29 09:01:07','',''),('8','216',51,'','6.1','3',0.00,1274479.10,'Sales from shift 14 on 2022-12-29 09:01:07 ','2022-12-29 09:01:07','',''),('8','216',52,'','20','2',1309837.75,0.00,'Sales from shift 15 on 2022-12-29 09:12:42 ','2022-12-29 09:12:42','',''),('8','216',53,'','6.1','3',0.00,1309837.75,'Sales from shift 15 on 2022-12-29 09:12:42 ','2022-12-29 09:12:42','',''),('8','216',54,'','20','2',1021670.70,0.00,'Sales from shift 16 on 2022-12-29 09:24:20 ','2022-12-29 09:24:20','',''),('8','216',55,'','6.1','3',0.00,1021670.70,'Sales from shift 16 on 2022-12-29 09:24:20 ','2022-12-29 09:24:20','',''),('8','216',56,'','20','2',959014.55,0.00,'Sales from shift 17 on 2022-12-29 19:05:24 ','2022-12-29 19:05:24','',''),('8','216',57,'','6.1','3',0.00,959014.55,'Sales from shift 17 on 2022-12-29 19:05:24 ','2022-12-29 19:05:24','',''),('8','216',58,'','2','6',636685.00,0.00,'Payment Id 8 for invoice:11, receipt: 11 by Lausu Energy Resources','2023-01-02 00:43:37','',''),('8','216',59,'','supplier','1',0.00,636685.00,'Payment Id 8 for invoice:11, receipt: 11 by Lausu Energy Resources','2023-01-02 00:43:37','',''),('8','216',60,'','2','6',1023795.00,0.00,'Payment Id 9 for invoice:12, receipt: 012 by Lausu Energy Resources','2023-01-02 00:44:08','',''),('8','216',61,'','supplier','1',0.00,1023795.00,'Payment Id 9 for invoice:12, receipt: 012 by Lausu Energy Resources','2023-01-02 00:44:08','',''),('8','216',62,'','2','6',1199145.00,0.00,'Payment Id 10 for invoice:13, receipt: 013 by Lausu Energy Resources','2023-01-02 00:44:43','',''),('8','216',63,'','supplier','1',0.00,1199145.00,'Payment Id 10 for invoice:13, receipt: 013 by Lausu Energy Resources','2023-01-02 00:44:43','',''),('8','216',64,'','2','6',1274480.00,0.00,'Payment Id 11 for invoice:14, receipt: 014 by Lausu Energy Resources','2023-01-02 00:45:33','',''),('8','216',65,'','supplier','1',0.00,1274480.00,'Payment Id 11 for invoice:14, receipt: 014 by Lausu Energy Resources','2023-01-02 00:45:33','',''),('8','216',66,'','2','6',1021670.00,0.00,'Payment Id 13 for invoice:16, receipt: 016 by Lausu Energy Resources','2023-01-02 00:51:03','',''),('8','216',67,'','supplier','1',0.00,1021670.00,'Payment Id 13 for invoice:16, receipt: 016 by Lausu Energy Resources','2023-01-02 00:51:03','',''),('8','216',68,'','2','6',959015.00,0.00,'Payment Id 14 for invoice:17, receipt: 017 by Lausu Energy Resources','2023-01-02 00:51:41','',''),('8','216',69,'','supplier','1',0.00,959015.00,'Payment Id 14 for invoice:17, receipt: 017 by Lausu Energy Resources','2023-01-02 00:51:41','',''),('8','216',70,'','2','6',270000.00,0.00,'Payment Id 15 for invoice:17, receipt: 17 by Lausu Energy Resources','2023-01-02 00:52:14','',''),('8','216',71,'','supplier','1',0.00,270000.00,'Payment Id 15 for invoice:17, receipt: 17 by Lausu Energy Resources','2023-01-02 00:52:14','',''),('8','216',72,'','2','6',1039835.00,0.00,'Payment Id 12 for invoice:15, receipt: 015 by Lausu Energy Resources','2023-01-03 12:34:22','',''),('8','216',73,'','supplier','1',0.00,1039835.00,'Payment Id 12 for invoice:15, receipt: 015 by Lausu Energy Resources','2023-01-03 12:34:22','',''),('8','216',74,'','24','5',0.00,9735000.00,'Purchase Id 9 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-03 16:47:57','',''),('8','216',75,'','supplier','1',9735000.00,0.00,'Purchase Id 9 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-03 16:47:57','',''),('8','216',76,'','20','2',765357.85,0.00,'Sales from shift 18 on 2023-01-03 19:08:42 ','2023-01-03 19:08:42','',''),('8','216',77,'','6.1','3',0.00,765357.85,'Sales from shift 18 on 2023-01-03 19:08:42 ','2023-01-03 19:08:42','',''),('8','216',78,'','20','2',0.00,0.00,'Sales from shift 19 on 2023-01-03 19:42:16 ','2023-01-03 19:42:16','',''),('8','216',79,'','6.1','3',0.00,0.00,'Sales from shift 19 on 2023-01-03 19:42:16 ','2023-01-03 19:42:16','',''),('8','216',80,'','20','2',0.00,0.00,'Sales from shift 20 on 2023-01-04 06:25:45 ','2023-01-04 06:25:45','',''),('8','216',81,'','6.1','3',0.00,0.00,'Sales from shift 20 on 2023-01-04 06:25:45 ','2023-01-04 06:25:45','',''),('8','216',82,'','20','2',605059.75,0.00,'Sales from shift 21 on 2023-01-04 06:32:29 ','2023-01-04 06:32:29','',''),('8','216',83,'','6.1','3',0.00,605059.75,'Sales from shift 21 on 2023-01-04 06:32:29 ','2023-01-04 06:32:29','',''),('8','216',84,'','20','2',750400.35,0.00,'Sales from shift 22 on 2023-01-04 06:37:32 ','2023-01-04 06:37:32','',''),('8','216',85,'','6.1','3',0.00,750400.35,'Sales from shift 22 on 2023-01-04 06:37:32 ','2023-01-04 06:37:32','',''),('8','216',86,'','2','6',965355.00,0.00,'Payment Id 16 for invoice:18, receipt: 018 by Lausu Energy Resources','2023-01-04 14:35:27','',''),('8','216',87,'','supplier','1',0.00,965355.00,'Payment Id 16 for invoice:18, receipt: 018 by Lausu Energy Resources','2023-01-04 14:35:27','',''),('8','216',88,'','2','6',557830.00,0.00,'Payment Id 17 for invoice:19, receipt: 019 by Lausu Energy Resources','2023-01-04 14:36:00','',''),('8','216',89,'','supplier','1',0.00,557830.00,'Payment Id 17 for invoice:19, receipt: 019 by Lausu Energy Resources','2023-01-04 14:36:00','',''),('8','216',90,'','20','2',862411.85,0.00,'Sales from shift 23 on 2023-01-04 18:41:28 ','2023-01-04 18:41:28','',''),('8','216',91,'','6.1','3',0.00,862411.85,'Sales from shift 23 on 2023-01-04 18:41:28 ','2023-01-04 18:41:28','',''),('8','216',92,'','2','6',605060.00,0.00,'Payment Id 18 for invoice:21, receipt: 21 by Lausu Energy Resources','2023-01-05 14:05:37','',''),('8','216',93,'','supplier','1',0.00,605060.00,'Payment Id 18 for invoice:21, receipt: 21 by Lausu Energy Resources','2023-01-05 14:05:37','',''),('8','216',94,'','2','6',750400.00,0.00,'Payment Id 19 for invoice:22, receipt: 22 by Lausu Energy Resources','2023-01-05 14:05:53','',''),('8','216',95,'','supplier','1',0.00,750400.00,'Payment Id 19 for invoice:22, receipt: 22 by Lausu Energy Resources','2023-01-05 14:05:53','',''),('8','216',96,'','20','2',843145.40,0.00,'Sales from shift 24 on 2023-01-06 08:15:14 ','2023-01-06 08:15:14','',''),('8','216',97,'','6.1','3',0.00,843145.40,'Sales from shift 24 on 2023-01-06 08:15:14 ','2023-01-06 08:15:14','',''),('8','216',98,'','2','6',862410.00,0.00,'Payment Id 20 for invoice:23, receipt: 023 by Lausu Energy Resources','2023-01-07 18:13:11','',''),('8','216',99,'','supplier','1',0.00,862410.00,'Payment Id 20 for invoice:23, receipt: 023 by Lausu Energy Resources','2023-01-07 18:13:11','',''),('8','216',100,'','2','6',843145.00,0.00,'Payment Id 21 for invoice:24, receipt: 024 by Lausu Energy Resources','2023-01-07 18:13:54','',''),('8','216',101,'','supplier','1',0.00,843145.00,'Payment Id 21 for invoice:24, receipt: 024 by Lausu Energy Resources','2023-01-07 18:13:54','',''),('8','216',102,'','20','2',721806.00,0.00,'Sales from shift 25 on 2023-01-09 22:38:56 ','2023-01-09 22:38:56','',''),('8','216',103,'','6.1','3',0.00,721806.00,'Sales from shift 25 on 2023-01-09 22:38:56 ','2023-01-09 22:38:56','',''),('8','216',104,'','2','6',721805.00,0.00,'Payment Id 22 for invoice:25, receipt: 025 by Lausu Energy Resources','2023-01-11 17:15:11','',''),('8','216',105,'','supplier','1',0.00,721805.00,'Payment Id 22 for invoice:25, receipt: 025 by Lausu Energy Resources','2023-01-11 17:15:11','',''),('8','216',106,'','2','6',654550.00,0.00,'Payment Id 23 for invoice:26, receipt: 026 by Lausu Energy Resources','2023-01-11 17:15:29','',''),('8','216',107,'','supplier','1',0.00,654550.00,'Payment Id 23 for invoice:26, receipt: 026 by Lausu Energy Resources','2023-01-11 17:15:29','',''),('8','216',108,'','20','2',654548.95,0.00,'Sales from shift 26 on 2023-01-11 18:01:14 ','2023-01-11 18:01:14','',''),('8','216',109,'','6.1','3',0.00,654548.95,'Sales from shift 26 on 2023-01-11 18:01:14 ','2023-01-11 18:01:14','',''),('8','216',110,'','20','2',779711.55,0.00,'Sales from shift 27 on 2023-01-12 15:07:33 ','2023-01-12 15:07:33','',''),('8','216',111,'','6.1','3',0.00,779711.55,'Sales from shift 27 on 2023-01-12 15:07:33 ','2023-01-12 15:07:33','',''),('8','216',112,'','2','6',779710.00,0.00,'Payment Id 24 for invoice:27, receipt: 027 by Lausu Energy Resources','2023-01-12 15:12:39','',''),('8','216',113,'','supplier','1',0.00,779710.00,'Payment Id 24 for invoice:27, receipt: 027 by Lausu Energy Resources','2023-01-12 15:12:39','',''),('8','216',114,'','20','2',705527.90,0.00,'Sales from shift 28 on 2023-01-13 18:40:34 ','2023-01-13 18:40:34','',''),('8','216',115,'','6.1','3',0.00,705527.90,'Sales from shift 28 on 2023-01-13 18:40:34 ','2023-01-13 18:40:34','',''),('8','216',116,'','20','2',591702.15,0.00,'Sales from shift 29 on 2023-01-13 18:49:06 ','2023-01-13 18:49:06','',''),('8','216',117,'','6.1','3',0.00,591702.15,'Sales from shift 29 on 2023-01-13 18:49:06 ','2023-01-13 18:49:06','',''),('8','216',118,'','2','6',705525.00,0.00,'Payment Id 25 for invoice:28, receipt: 028 by Lausu Energy Resources','2023-01-14 09:05:26','',''),('8','216',119,'','supplier','1',0.00,705525.00,'Payment Id 25 for invoice:28, receipt: 028 by Lausu Energy Resources','2023-01-14 09:05:26','',''),('8','216',120,'','2','6',591700.00,0.00,'Payment Id 26 for invoice:29, receipt: 029 by Lausu Energy Resources','2023-01-14 09:05:48','',''),('8','216',121,'','supplier','1',0.00,591700.00,'Payment Id 26 for invoice:29, receipt: 029 by Lausu Energy Resources','2023-01-14 09:05:48','',''),('8','216',122,'','20','2',599879.55,0.00,'Sales from shift 30 on 2023-01-14 17:57:36 ','2023-01-14 17:57:36','',''),('8','216',123,'','6.1','3',0.00,599879.55,'Sales from shift 30 on 2023-01-14 17:57:36 ','2023-01-14 17:57:36','',''),('8','216',124,'','20','2',627344.05,0.00,'Sales from shift 31 on 2023-01-14 18:05:04 ','2023-01-14 18:05:04','',''),('8','216',125,'','6.1','3',0.00,627344.05,'Sales from shift 31 on 2023-01-14 18:05:04 ','2023-01-14 18:05:04','',''),('8','216',126,'','20','2',652719.95,0.00,'Sales from shift 32 on 2023-01-14 18:10:14 ','2023-01-14 18:10:14','',''),('8','216',127,'','6.1','3',0.00,652719.95,'Sales from shift 32 on 2023-01-14 18:10:14 ','2023-01-14 18:10:14','',''),('8','216',128,'','20','2',518191.10,0.00,'Sales from shift 33 on 2023-01-15 09:01:27 ','2023-01-15 09:01:27','',''),('8','216',129,'','6.1','3',0.00,518191.10,'Sales from shift 33 on 2023-01-15 09:01:27 ','2023-01-15 09:01:27','',''),('8','216',130,'','2','6',599880.00,0.00,'Payment Id 27 for invoice:30, receipt: 030 by Lausu Energy Resources','2023-01-16 18:15:18','',''),('8','216',131,'','supplier','1',0.00,599880.00,'Payment Id 27 for invoice:30, receipt: 030 by Lausu Energy Resources','2023-01-16 18:15:18','',''),('8','216',132,'','2','6',627345.00,0.00,'Payment Id 28 for invoice:31, receipt: 031 by Lausu Energy Resources','2023-01-16 18:15:38','',''),('8','216',133,'','supplier','1',0.00,627345.00,'Payment Id 28 for invoice:31, receipt: 031 by Lausu Energy Resources','2023-01-16 18:15:38','',''),('8','216',134,'','2','6',652720.00,0.00,'Payment Id 29 for invoice:32, receipt: 032 by Lausu Energy Resources','2023-01-17 17:33:45','',''),('8','216',135,'','supplier','1',0.00,652720.00,'Payment Id 29 for invoice:32, receipt: 032 by Lausu Energy Resources','2023-01-17 17:33:45','',''),('8','216',136,'','2','6',518190.00,0.00,'Payment Id 30 for invoice:33, receipt: 033 by Lausu Energy Resources','2023-02-24 15:10:35','',''),('8','216',137,'','supplier','1',0.00,518190.00,'Payment Id 30 for invoice:33, receipt: 033 by Lausu Energy Resources','2023-02-24 15:10:35','',''),('8','216',138,'','24','5',0.00,9960000.00,'Purchase Id 10 for 33,200.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-26 10:02:51','',''),('8','216',139,'','supplier','1',9960000.00,0.00,'Purchase Id 10 for 33,200.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-26 10:02:51','',''),('8','216',140,'','20','2',771819.00,0.00,'Sales from shift 34 on 2023-02-27 19:10:26 ','2023-02-27 19:10:26','',''),('8','216',141,'','6.1','3',0.00,771819.00,'Sales from shift 34 on 2023-02-27 19:10:26 ','2023-02-27 19:10:26','',''),('8','216',142,'','20','2',1841766.00,0.00,'Sales from shift 35 on 2023-02-27 19:17:28 ','2023-02-27 19:17:28','',''),('8','216',143,'','6.1','3',0.00,1841766.00,'Sales from shift 35 on 2023-02-27 19:17:28 ','2023-02-27 19:17:28','',''),('8','216',144,'','20','2',2134374.00,0.00,'Sales from shift 36 on 2023-02-27 19:24:00 ','2023-02-27 19:24:00','',''),('8','216',145,'','6.1','3',0.00,2134374.00,'Sales from shift 36 on 2023-02-27 19:24:00 ','2023-02-27 19:24:00','',''),('8','216',146,'','20','2',2336331.00,0.00,'Sales from shift 37 on 2023-03-01 14:35:49 ','2023-03-01 14:35:49','',''),('8','216',147,'','6.1','3',0.00,2336331.00,'Sales from shift 37 on 2023-03-01 14:35:49 ','2023-03-01 14:35:49','',''),('8','216',148,'','2','6',771820.00,0.00,'Payment Id 31 for invoice:34, receipt: 34 by Lausu Energy Resources','2023-03-01 16:03:52','',''),('8','216',149,'','supplier','1',0.00,771820.00,'Payment Id 31 for invoice:34, receipt: 34 by Lausu Energy Resources','2023-03-01 16:03:52','',''),('8','216',150,'','2','6',1841765.00,0.00,'Payment Id 32 for invoice:35, receipt: 35 by Lausu Energy Resources','2023-03-01 16:04:14','',''),('8','216',151,'','supplier','1',0.00,1841765.00,'Payment Id 32 for invoice:35, receipt: 35 by Lausu Energy Resources','2023-03-01 16:04:14','',''),('8','216',152,'','2','6',2134375.00,0.00,'Payment Id 33 for invoice:36, receipt: 36 by Lausu Energy Resources','2023-03-01 16:04:38','',''),('8','216',153,'','supplier','1',0.00,2134375.00,'Payment Id 33 for invoice:36, receipt: 36 by Lausu Energy Resources','2023-03-01 16:04:38','',''),('8','216',154,'','2','6',2336330.00,0.00,'Payment Id 34 for invoice:37, receipt: 37 by Lausu Energy Resources','2023-03-01 16:05:05','',''),('8','216',155,'','supplier','1',0.00,2336330.00,'Payment Id 34 for invoice:37, receipt: 37 by Lausu Energy Resources','2023-03-01 16:05:05','',''),('8','216',156,'','20','2',2146059.00,0.00,'Sales from shift 38 on 2023-03-03 07:13:47 ','2023-03-03 07:13:47','',''),('8','216',157,'','6.1','3',0.00,2146059.00,'Sales from shift 38 on 2023-03-03 07:13:47 ','2023-03-03 07:13:47','',''),('8','216',158,'','20','2',726408.00,0.00,'Sales from shift 39 on 2023-03-03 07:51:40 ','2023-03-03 07:51:40','',''),('8','216',159,'','6.1','3',0.00,726408.00,'Sales from shift 39 on 2023-03-03 07:51:40 ','2023-03-03 07:51:40','',''),('8','216',160,'','24','5',0.00,9900000.00,'Purchase Id 11 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-03 14:20:10','',''),('8','216',161,'','supplier','1',9900000.00,0.00,'Purchase Id 11 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-03 14:20:10','',''),('8','216',162,'','2','6',2146060.00,0.00,'Payment Id 35 for invoice:38, receipt: 38 by Lausu Energy Resources','2023-03-05 07:34:42','',''),('8','216',163,'','supplier','1',0.00,2146060.00,'Payment Id 35 for invoice:38, receipt: 38 by Lausu Energy Resources','2023-03-05 07:34:42','',''),('8','216',164,'','2','6',726410.00,0.00,'Payment Id 36 for invoice:39, receipt: 39 by Lausu Energy Resources','2023-03-05 07:35:33','',''),('8','216',165,'','supplier','1',0.00,726410.00,'Payment Id 36 for invoice:39, receipt: 39 by Lausu Energy Resources','2023-03-05 07:35:33','',''),('8','216',166,'','20','2',1894464.00,0.00,'Sales from shift 40 on 2023-03-05 10:49:33 ','2023-03-05 10:49:33','',''),('8','216',167,'','6.1','3',0.00,1894464.00,'Sales from shift 40 on 2023-03-05 10:49:33 ','2023-03-05 10:49:33','',''),('8','216',168,'','20','2',2345919.00,0.00,'Sales from shift 41 on 2023-03-05 10:54:44 ','2023-03-05 10:54:44','',''),('8','216',169,'','6.1','3',0.00,2345919.00,'Sales from shift 41 on 2023-03-05 10:54:44 ','2023-03-05 10:54:44','',''),('8','216',170,'','20','2',2020929.00,0.00,'Sales from shift 42 on 2023-03-05 11:00:20 ','2023-03-05 11:00:20','',''),('8','216',171,'','6.1','3',0.00,2020929.00,'Sales from shift 42 on 2023-03-05 11:00:20 ','2023-03-05 11:00:20','',''),('8','216',172,'','2','6',1894465.00,0.00,'Payment Id 37 for invoice:40, receipt: 40 by Lausu Energy Resources','2023-03-06 09:40:40','',''),('8','216',173,'','supplier','1',0.00,1894465.00,'Payment Id 37 for invoice:40, receipt: 40 by Lausu Energy Resources','2023-03-06 09:40:40','',''),('8','216',174,'','2','6',2345920.00,0.00,'Payment Id 38 for invoice:41, receipt: 41 by Lausu Energy Resources','2023-03-06 09:41:10','',''),('8','216',175,'','supplier','1',0.00,2345920.00,'Payment Id 38 for invoice:41, receipt: 41 by Lausu Energy Resources','2023-03-06 09:41:10','',''),('8','216',176,'','20','2',2119845.00,0.00,'Sales from shift 43 on 2023-03-07 09:53:37 ','2023-03-07 09:53:37','',''),('8','216',177,'','6.1','3',0.00,2119845.00,'Sales from shift 43 on 2023-03-07 09:53:37 ','2023-03-07 09:53:37','',''),('8','216',178,'','24','5',0.00,10410000.00,'Purchase Id 12 for 34,700.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-08 08:29:31','',''),('8','216',179,'','supplier','1',10410000.00,0.00,'Purchase Id 12 for 34,700.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-08 08:29:31','',''),('8','216',180,'','2','6',2020930.00,0.00,'Payment Id 39 for invoice:42, receipt: 42 by Lausu Energy Resources','2023-03-08 08:34:35','',''),('8','216',181,'','supplier','1',0.00,2020930.00,'Payment Id 39 for invoice:42, receipt: 42 by Lausu Energy Resources','2023-03-08 08:34:35','',''),('8','216',182,'','2','6',2119845.00,0.00,'Payment Id 40 for invoice:43, receipt: 43 by Lausu Energy Resources','2023-03-09 09:40:07','',''),('8','216',183,'','supplier','1',0.00,2119845.00,'Payment Id 40 for invoice:43, receipt: 43 by Lausu Energy Resources','2023-03-09 09:40:07','',''),('8','216',184,'','20','2',1542153.00,0.00,'Sales from shift 44 on 2023-03-10 07:29:30 ','2023-03-10 07:29:30','',''),('8','216',185,'','6.1','3',0.00,1542153.00,'Sales from shift 44 on 2023-03-10 07:29:30 ','2023-03-10 07:29:30','',''),('8','216',186,'','20','2',1589532.00,0.00,'Sales from shift 45 on 2023-03-10 07:39:07 ','2023-03-10 07:39:07','',''),('8','216',187,'','6.1','3',0.00,1589532.00,'Sales from shift 45 on 2023-03-10 07:39:07 ','2023-03-10 07:39:07','',''),('8','216',188,'','20','2',1698564.00,0.00,'Sales from shift 46 on 2023-03-10 07:47:01 ','2023-03-10 07:47:01','',''),('8','216',189,'','6.1','3',0.00,1698564.00,'Sales from shift 46 on 2023-03-10 07:47:01 ','2023-03-10 07:47:01','',''),('8','216',190,'','2','6',1542155.00,0.00,'Payment Id 41 for invoice:44, receipt: 44 by Lausu Energy Resources','2023-03-10 09:14:30','',''),('8','216',191,'','supplier','1',0.00,1542155.00,'Payment Id 41 for invoice:44, receipt: 44 by Lausu Energy Resources','2023-03-10 09:14:30','',''),('8','216',192,'','2','6',1589530.00,0.00,'Payment Id 42 for invoice:45, receipt: 45 by Lausu Energy Resources','2023-03-10 09:15:19','',''),('8','216',193,'','supplier','1',0.00,1589530.00,'Payment Id 42 for invoice:45, receipt: 45 by Lausu Energy Resources','2023-03-10 09:15:19','',''),('8','216',194,'','20','2',2148216.00,0.00,'Sales from shift 47 on 2023-03-11 11:47:49 ','2023-03-11 11:47:49','',''),('8','216',195,'','6.1','3',0.00,2148216.00,'Sales from shift 47 on 2023-03-11 11:47:49 ','2023-03-11 11:47:49','',''),('8','216',196,'','2','6',1692565.00,0.00,'Payment Id 43 for invoice:46, receipt: 46 by Lausu Energy Resources','2023-03-12 10:49:06','',''),('8','216',197,'','supplier','1',0.00,1692565.00,'Payment Id 43 for invoice:46, receipt: 46 by Lausu Energy Resources','2023-03-12 10:49:06','',''),('8','216',198,'','2','6',2154215.00,0.00,'Payment Id 44 for invoice:47, receipt: 47 by Lausu Energy Resources','2023-03-12 10:49:54','',''),('8','216',199,'','supplier','1',0.00,2154215.00,'Payment Id 44 for invoice:47, receipt: 47 by Lausu Energy Resources','2023-03-12 10:49:54','',''),('8','216',200,'','20','2',1913616.00,0.00,'Sales from shift 48 on 2023-03-12 17:11:43 ','2023-03-12 17:11:43','',''),('8','216',201,'','6.1','3',0.00,1913616.00,'Sales from shift 48 on 2023-03-12 17:11:43 ','2023-03-12 17:11:43','',''),('8','216',202,'','20','2',1893693.00,0.00,'Sales from shift 49 on 2023-03-12 17:17:34 ','2023-03-12 17:17:34','',''),('8','216',203,'','6.1','3',0.00,1893693.00,'Sales from shift 49 on 2023-03-12 17:17:34 ','2023-03-12 17:17:34','',''),('8','216',204,'','2','6',1913615.00,0.00,'Payment Id 45 for invoice:48, receipt: 48 by Lausu Energy Resources','2023-03-13 15:03:35','',''),('8','216',205,'','supplier','1',0.00,1913615.00,'Payment Id 45 for invoice:48, receipt: 48 by Lausu Energy Resources','2023-03-13 15:03:35','',''),('8','216',206,'','2','6',1893695.00,0.00,'Payment Id 46 for invoice:49, receipt: 49 by Lausu Energy Resources','2023-03-17 11:12:56','',''),('8','216',207,'','supplier','1',0.00,1893695.00,'Payment Id 46 for invoice:49, receipt: 49 by Lausu Energy Resources','2023-03-17 11:12:56','',''),('8','216',208,'','24','5',0.00,10140000.00,'Purchase Id 13 for 33,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-20 16:05:20','',''),('8','216',209,'','supplier','1',10140000.00,0.00,'Purchase Id 13 for 33,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-20 16:05:20','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'8','216','PMS','Petrol','Litres',0,300.00,0.00,0.00,0.00,0.00,0,'2022-10-16 01:57:42','963','963','2022-10-16 01:57:42',0),(2,'8','216','AGO','Diesel','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-10-16 02:01:21','963','963','2022-10-16 02:01:21',0),(3,'8','216','DPK','Kerosene','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-10-16 02:02:21','963','963','2022-10-16 02:02:21',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'8','216',1,290.00,0.00,0.00,0.00,'Cost from purchase id #1','2022-12-09 14:45:37','928'),(2,'8','216',1,305.00,0.00,0.00,0.00,'Cost from purchase id #7','2022-12-21 16:24:32','928'),(3,'8','216',1,295.00,0.00,0.00,0.00,'Cost from purchase id #9','2023-01-03 16:47:57','928'),(4,'8','216',1,300.00,0.00,0.00,0.00,'Cost from purchase id #10','2023-02-26 10:02:51','928');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'8','216','2022-12-08',1,1,290.00,17100.00,0.00,0.00,4959000.00,0.00,'','001','Bch 428 xa','','','','2022-12-08 21:59:33',2,'Purchase of pms','959','','0000-00-00 00:00:00','928','2022-12-09 14:52:27'),(5,'8','216','2022-12-03',1,1,290.00,500.00,0.00,0.00,145000.00,0.00,'','001','WDL 813 XA','','','','2022-12-10 11:20:24',15,'Purchase of pms','959','','0000-00-00 00:00:00','928','2022-12-10 12:03:41'),(6,'8','216','2022-12-08',1,1,290.00,17100.00,0.00,0.00,4959000.00,0.00,'','002','BCH 428 XA','','','','2022-12-10 11:41:50',15,'Purchase of pms','959','','0000-00-00 00:00:00','928','2022-12-10 12:11:18'),(7,'8','216','2022-12-19',1,1,305.00,33350.00,0.00,0.00,10171750.00,0.00,'','003','TRN743ZY','','','','2022-12-21 10:46:39',15,'Purchase of pms','959','','0000-00-00 00:00:00','928','2022-12-21 16:24:32'),(9,'8','216','2022-12-30',1,1,295.00,33000.00,0.00,0.00,9735000.00,0.00,'','8','RAN 31 XF','','','','2023-01-03 16:41:08',15,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-03 16:47:57'),(10,'8','216','2023-02-22',1,1,300.00,33200.00,0.00,0.00,9960000.00,0.00,'','9','BCH 428 XA','','','','2023-02-25 10:11:41',15,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-02-26 10:02:51'),(11,'8','216','2023-03-01',1,1,300.00,33000.00,0.00,0.00,9900000.00,0.00,'','9','DKA 705 ZP','','','','2023-03-03 07:56:06',15,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-03 14:20:10'),(12,'8','216','2023-03-06',1,1,300.00,34700.00,0.00,0.00,10410000.00,0.00,'','10','WDL 813 XA','','','','2023-03-08 07:04:16',15,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-08 08:29:31'),(13,'8','216','2023-03-15',1,1,300.00,33800.00,0.00,0.00,10140000.00,0.00,'','11','NSR 572 ZX','','','','2023-03-20 09:29:07',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-20 16:05:20');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'8','216','2022-12-09',1,'002','','10',1833210.00,'2','','','6','Nazy','002',1833208.90,'2022-12-10 13:31:27',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2022-12-11 22:45:10'),(2,'8','216','2022-12-10',1,'003','','10',1466400.00,'3','','','6','Nazy','003',1466402.40,'2022-12-10 13:54:41',5,'Purchase of pms','959','','0000-00-00 00:00:00','928','2022-12-11 22:45:33'),(3,'8','216','2022-12-12',1,'4','','10',1474395.00,'4','','','6','Nazy','4',1474394.80,'2022-12-12 13:11:55',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2022-12-14 14:32:37'),(4,'8','216','2022-12-20',1,'5','','10',247995.00,'5','','','6','Nazy','5',247993.50,'2022-12-25 11:44:23',5,'Payment of the pms','959','','0000-00-00 00:00:00','928','2022-12-27 02:37:30'),(5,'8','216','2022-12-25',1,'006','','10',776680.00,'6','','','6','Nazy','006',776682.50,'2022-12-25 15:20:35',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2022-12-27 02:38:58'),(6,'8','216','2022-12-21',1,'007','','10',614320.00,'7','','','6','Nazy','007',614321.85,'2022-12-25 15:59:45',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2022-12-27 02:39:23'),(7,'8','216','2022-12-24',1,'9','','10',653575.00,'9','','','6','Nazy','9',653572.30,'2022-12-27 18:30:38',5,'Payment of the pms','959','','0000-00-00 00:00:00','928','2022-12-27 19:06:14'),(8,'8','216','2022-12-27',1,'11','','10',636685.00,'11','','','6','Nazy','11',636684.45,'2022-12-29 07:58:45',5,'Payment of the pms','959','','0000-00-00 00:00:00','928','2023-01-02 00:43:37'),(9,'8','216','2022-12-24',1,'012','','10',1023795.00,'12','','','6','Nazy','012',1023793.50,'2022-12-29 08:36:01',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-02 00:44:08'),(10,'8','216','2022-12-25',1,'013','','10',1199145.00,'13','','','6','Nazy','013',1199144.10,'2022-12-29 08:45:52',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-02 00:44:43'),(11,'8','216','2022-12-26',1,'014','','10',1274480.00,'14','','','6','Nazy','014',1274479.10,'2022-12-29 08:59:22',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-02 00:45:33'),(12,'8','216','2022-12-27',1,'015','','5',1039835.00,'15','','','6','Nazy','032312',1309837.75,'2022-12-29 09:09:48',5,'Payment of pms','959','467','2023-01-03 12:34:06','467','2023-01-03 12:34:22'),(13,'8','216','2022-12-28',1,'016','','10',1021670.00,'16','','','6','Nazy','016',1021670.70,'2022-12-29 09:20:27',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-02 00:51:03'),(14,'8','216','2022-12-29',1,'017','','10',959015.00,'17','','','6','Nazy','017',959014.55,'2022-12-29 09:32:26',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-02 00:51:41'),(15,'8','216','2022-12-29',1,'17','','10',270000.00,'17','','','6','Nazy','17',0.00,'2022-12-29 19:07:59',5,'Payment of the pms','959','','0000-00-00 00:00:00','928','2023-01-02 00:52:14'),(16,'8','216','2022-12-30',1,'018','','10',965355.00,'18','','','6','Nazy','018',765357.85,'2023-01-03 17:38:21',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-04 14:35:27'),(17,'8','216','2023-01-03',1,'019','','10',557830.00,'19','','','6','Nazy','019',757831.40,'2023-01-03 19:18:14',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-04 14:36:00'),(18,'8','216','2023-01-03',1,'21','','10',605060.00,'21','','','6','Nazy','21',605059.75,'2023-01-04 06:31:56',5,'Payment of the pms','959','','0000-00-00 00:00:00','928','2023-01-05 14:05:37'),(19,'8','216','2023-01-04',1,'22','','10',750400.00,'22','','','6','Nazy','22',750400.35,'2023-01-04 06:37:02',5,'Payment of the pms','959','','0000-00-00 00:00:00','928','2023-01-05 14:05:53'),(20,'8','216','2023-01-04',1,'023','','10',862410.00,'23','','','6','Nazy','023',862411.85,'2023-01-04 14:26:25',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-07 18:13:11'),(21,'8','216','2023-01-05',1,'024','','10',843145.00,'24','','','6','Nazy','024',843145.40,'2023-01-06 10:29:34',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-07 18:13:54'),(22,'8','216','2023-01-06',1,'025','','10',721805.00,'25','','','6','Nazy','025',721806.00,'2023-01-06 10:34:41',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-11 17:15:11'),(23,'8','216','2023-01-07',1,'026','','10',654550.00,'26','','','6','Nazy','026',654548.95,'2023-01-10 14:47:47',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-11 17:15:29'),(24,'8','216','2023-01-07',1,'027','','10',779710.00,'27','','','6','Nazy','027',779711.55,'2023-01-11 18:13:07',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-12 15:12:39'),(25,'8','216','2023-01-08',1,'028','','10',705525.00,'28','','','6','Nazy','028',705527.90,'2023-01-13 18:40:00',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-14 09:05:26'),(26,'8','216','2023-01-09',1,'029','','10',591700.00,'29','','','6','Nazy','029',591702.15,'2023-01-13 18:47:20',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-14 09:05:49'),(27,'8','216','2023-01-10',1,'030','','10',599880.00,'30','','','6','Nazy','030',599879.55,'2023-01-14 17:49:05',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-16 18:15:18'),(28,'8','216','2023-01-11',1,'031','','10',627345.00,'31','','','6','Nazy','031',627344.05,'2023-01-14 18:04:04',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-16 18:15:38'),(29,'8','216','2023-01-13',1,'032','','10',652720.00,'32','','','6','Nazy','032',652719.95,'2023-01-14 18:09:41',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-01-17 17:33:45'),(30,'8','216','2023-01-13',1,'033','','10',518190.00,'33','','','6','Nazy','033',518191.10,'2023-01-17 18:57:48',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-02-24 15:10:35'),(31,'8','216','2023-02-23',1,'34','','10',771820.00,'34','','','6','Nazy','34',771819.00,'2023-02-26 21:10:09',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-01 16:03:52'),(32,'8','216','2023-02-24',1,'35','','10',1841765.00,'35','','','6','Nazy','35',1841766.00,'2023-02-27 19:16:49',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-01 16:04:14'),(33,'8','216','2023-02-26',1,'36','','10',2134375.00,'36','','','6','Nazy','36',2134374.00,'2023-02-27 19:23:07',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-01 16:04:38'),(34,'8','216','2023-02-27',1,'37','','10',2336330.00,'37','','','6','Nazy','37',2336331.00,'2023-03-01 14:35:22',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-01 16:05:05'),(35,'8','216','2023-02-28',1,'38','','10',2146060.00,'38','','','6','Nazy','38',2146059.00,'2023-03-01 14:40:00',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-05 07:34:42'),(36,'8','216','2023-03-01',1,'39','','10',726410.00,'39','','','6','Nazy','39',726408.00,'2023-03-03 07:48:07',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-05 07:35:33'),(37,'8','216','2023-03-02',1,'40','','10',1894465.00,'40','','','6','Nazy','40',1894464.00,'2023-03-05 10:49:07',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-06 09:40:40'),(38,'8','216','2023-03-03',1,'41','','10',2345920.00,'41','','','6','Nazy','41',2345919.00,'2023-03-05 10:54:15',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-06 09:41:10'),(39,'8','216','2023-03-04',1,'42','','10',2020930.00,'42','','','6','Nazy','42',2020929.00,'2023-03-05 10:59:52',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-08 08:34:35'),(40,'8','216','2023-03-05',1,'43','','10',2119845.00,'43','','','6','Nazy','43',2119845.00,'2023-03-07 09:53:01',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-09 09:40:07'),(41,'8','216','2023-03-06',1,'44','','10',1542155.00,'44','','','6','Nazy','44',1542153.00,'2023-03-10 07:29:02',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-10 09:14:30'),(42,'8','216','2023-03-07',1,'45','','10',1589530.00,'45','','','6','Nazy','45',1589532.00,'2023-03-10 07:34:14',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-10 09:15:19'),(43,'8','216','2023-03-08',1,'46','','5',1692565.00,'46','','','6','Nazy','1232023',1698564.00,'2023-03-10 07:46:31',5,'Payment of pms','959','928','2023-03-12 10:48:48','928','2023-03-12 10:49:06'),(44,'8','216','2023-03-09',1,'47','','10',2154215.00,'47','','','6','Nazy','47',2148216.00,'2023-03-11 11:51:17',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-12 10:49:54'),(45,'8','216','2023-03-10',1,'48','','10',1913615.00,'48','','','6','Nazy','48',1913616.00,'2023-03-12 17:11:19',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-13 15:03:35'),(46,'8','216','2023-03-12',1,'49','','10',1893695.00,'49','','','6','Nazy','49',1893693.00,'2023-03-12 17:17:10',5,'Payment of pms','959','','0000-00-00 00:00:00','928','2023-03-17 11:12:56');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'8',5,'216',1,1,'2022-12-10 00:00:00','AA RANO',150.00,150.00,0.00,'001','','1','WDL 813 XA','Muhammad','','Received of pms',5,'2022-12-10 12:26:24','959','0000-00-00 00:00:00','','2022-12-10 12:35:16','959'),(2,'8',5,'216',1,1,'2022-12-10 00:00:00','AA RANO',350.00,350.00,0.00,'001','','2','WDL 813 XA','Muhammad','','Received of pms',5,'2022-12-10 12:26:24','959','0000-00-00 00:00:00','','2022-12-10 12:34:13','959'),(3,'8',6,'216',1,1,'2022-12-10 00:00:00','AA RANO',17100.00,17100.00,0.00,'002','','2','BCH 428 XA','Danja','08034997784','Received of pms',5,'2022-12-10 12:42:08','959','0000-00-00 00:00:00','','2022-12-10 12:47:41','959'),(4,'8',7,'216',1,1,'2022-12-25 00:00:00','AA Rano',17200.00,17200.00,0.00,'003','','1','TRN743ZY','Kamal','','Received of pms',5,'2022-12-25 11:41:20','959','0000-00-00 00:00:00','','2022-12-25 11:42:06','959'),(5,'8',7,'216',1,1,'2022-12-25 00:00:00','AA Rano',16150.00,16150.00,0.00,'003','','2','TRN743ZY','Kamal','','Received of Pms',5,'2022-12-25 11:41:20','959','0000-00-00 00:00:00','','2022-12-25 11:41:44','959'),(6,'8',9,'216',1,1,'2023-01-03 00:00:00','AA Rano',16000.00,16000.00,0.00,'004','','1','RAN 31 XF','Shafi\'u','','Delivery of pms',5,'2023-01-03 16:52:15','959','0000-00-00 00:00:00','','2023-01-03 16:53:26','959'),(7,'8',9,'216',1,1,'2023-01-03 00:00:00','AA Rano',17000.00,17000.00,0.00,'004','','2','RAN 31 XF','Shafi\'u','','Received of Pms',5,'2023-01-03 16:52:15','959','0000-00-00 00:00:00','','2023-01-03 16:52:43','959'),(8,'8',10,'216',1,1,'2023-02-26 00:00:00','AA Rano',16200.00,16200.00,0.00,'10','','1','BCH 428 XA','Yalo','','10',5,'2023-02-26 14:34:17','959','0000-00-00 00:00:00','','2023-02-26 14:36:29','959'),(9,'8',10,'216',1,1,'2023-02-26 00:00:00','AA Rano',17000.00,17000.00,0.00,'10','','2','BCH 428 XA','Yalo','','',5,'2023-02-26 14:34:17','959','0000-00-00 00:00:00','','2023-02-26 14:35:23','959'),(10,'8',11,'216',1,1,'2023-03-03 00:00:00','AA Rano',16000.00,16000.00,0.00,'11','','1','DKA 705 ZP','Abdullah','','Received of pms',5,'2023-03-03 14:53:13','959','0000-00-00 00:00:00','','2023-03-03 14:53:31','959'),(11,'8',11,'216',1,1,'2023-03-03 00:00:00','AA Rano',17000.00,17000.00,0.00,'11','','2','DKA 705 ZP','Abdullah','','Delivery of pms',5,'2023-03-03 14:53:13','959','0000-00-00 00:00:00','','2023-03-03 14:53:47','959'),(12,'8',12,'216',1,1,'2023-03-08 00:00:00','AA Rano',17700.00,17700.00,0.00,'12','','1','WDL 813 XA','Abdullahi','','Received of pms',5,'2023-03-08 09:11:28','959','0000-00-00 00:00:00','','2023-03-08 09:13:12','959'),(13,'8',12,'216',1,1,'2023-03-08 00:00:00','AA Rano',17000.00,17000.00,0.00,'12','','2','WDL 813 XA','Abdullahi','','Received of Pms',5,'2023-03-08 09:11:28','959','0000-00-00 00:00:00','','2023-03-08 09:12:36','959');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'8','216','Lausu Energy Resources','Babangida Bashir','08063654848','info@','KANO','KANO','Lausu Energy Head Office.','Nigeria',0.00,0.00,'0000-00-00','2022-10-16 01:53:59',5,'963','2022-10-16 01:53:59','963');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:57:15
