-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_8_station_215
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_8_station_215`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_8_station_215` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_8_station_215`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','8','215','PURCHASES','','2022-10-16 01:47:18',5,0.00,0.00,'','963','2022-10-16 01:47:18','963',0,0),(2,7000,'',0,'20','8','215','SALES','','2022-10-16 01:47:33',5,0.00,0.00,'','963','2022-10-16 01:47:33','963',0,0),(3,500,'',0,'6.1','8','215','CASH','','2022-10-16 01:47:46',5,0.00,0.00,'','963','2022-10-16 01:47:46','963',0,0),(4,8000,'',0,'24','8','215','SALARIES & WAGES','','2022-10-16 01:48:01',5,0.00,0.00,'','963','2022-10-16 01:48:01','963',0,0),(5,8001,'',0,'24','8','215','PURCHASES','','2022-10-16 01:48:17',5,0.00,0.00,'','963','2022-10-16 01:48:17','963',0,0),(6,2500,'',0,'2','8','215','UBA-0039769388','','2022-10-17 13:44:40',5,0.00,0.00,'','963','2022-10-17 13:44:40','963',0,0),(7,2501,'',0,'2','8','215','Keystone-1009060914','','2022-10-17 13:44:53',5,0.00,0.00,'','963','2022-10-17 13:44:53','963',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('8','215','1',3,'5','PMS PUMP 3',899454.98,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-12-04 21:19:38','963'),('8','215','1',4,'5','PMS PUMP 4',26757.66,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-12-04 21:20:22','963');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('8','215',1,'Daily shift','2022-12-16','2022-12-17 11:45:49','2022-12-18 11:45:49','960',809634.70,809634.70,'960','2022-12-17 11:47:34','960','2022-12-17 11:48:25',10,0),('8','215',2,'Daily shift','2022-12-17','2022-12-18 13:36:12','2022-12-19 13:36:12','960',919029.10,919029.10,'960','2022-12-18 13:38:09','960','2022-12-18 13:43:26',10,0),('8','215',3,'Daily shift','2022-12-18','2022-12-19 15:27:43','2022-12-20 15:27:43','960',1579639.10,1579639.10,'960','2022-12-19 15:30:15','960','2022-12-19 15:31:21',10,0),('8','215',4,'Daily shift','2022-12-19','2022-12-20 09:34:57','2022-12-21 09:34:57','960',1315497.40,1315497.40,'960','2022-12-20 09:36:19','960','2022-12-20 09:37:10',10,0),('8','215',5,'Daily shift','2022-12-20','2022-12-21 14:19:16','2022-12-22 14:19:16','960',1041547.30,1041547.30,'960','2022-12-21 14:20:37','960','2022-12-21 14:21:14',10,0),('8','215',6,'Daily shift','2022-12-23','2022-12-25 16:07:31','2022-12-26 16:07:31','960',316054.30,316054.30,'960','2022-12-25 16:08:43','960','2022-12-25 16:21:23',10,0),('8','215',7,'Daily shift','2022-12-24','2022-12-25 16:25:52','2022-12-26 16:25:52','960',995847.10,995847.10,'960','2022-12-25 16:27:02','960','2022-12-25 16:27:30',10,0),('8','215',8,'Daily shift','2022-12-25','2022-12-26 08:33:26','2022-12-27 08:33:26','960',1161427.40,1161427.40,'960','2022-12-26 08:34:47','960','2022-12-26 08:35:46',10,0),('8','215',9,'Daily shift','2022-12-26','2022-12-27 09:25:18','2022-12-28 09:25:18','960',767253.10,767253.10,'960','2022-12-27 09:26:45','960','2022-12-27 09:27:17',10,0),('8','215',10,'Daily shift','2022-12-27','2022-12-28 08:30:20','2022-12-29 08:30:20','960',585528.00,585528.00,'960','2022-12-28 08:31:28','960','2022-12-28 08:31:54',10,0),('8','215',11,'Daily shift','2022-12-28','2022-12-29 08:20:32','2022-12-30 08:20:32','960',539545.70,539545.70,'960','2022-12-29 08:21:31','960','2022-12-29 08:22:19',10,0),('8','215',12,'Daily shift','2022-12-29','2022-12-30 09:41:46','2022-12-31 09:41:46','960',596985.60,596985.60,'960','2022-12-30 09:43:43','960','2022-12-30 09:45:36',10,0),('8','215',13,'Daily shift','2023-01-01','2023-01-02 08:14:03','2023-01-03 08:14:03','960',1170801.00,1170801.00,'960','2023-01-02 08:15:18','960','2023-01-02 08:17:02',10,0),('8','215',14,'Daily shift','2023-01-02','2023-01-03 08:19:58','2023-01-04 08:19:58','960',601539.00,601539.00,'960','2023-01-03 08:21:12','960','2023-01-03 08:21:50',10,0),('8','215',15,'Daily shift','2023-01-03','2023-01-04 08:48:38','2023-01-05 08:48:38','960',739491.00,739491.00,'960','2023-01-04 08:49:54','960','2023-01-04 08:50:25',10,0),('8','215',16,'Daily shift','2023-01-04','2023-01-05 09:07:18','2023-01-06 09:07:18','960',695388.00,695388.00,'960','2023-01-05 09:08:46','960','2023-01-05 09:09:23',10,0),('8','215',17,'Daily shift','2023-01-05','2023-01-06 09:25:00','2023-01-07 09:25:00','960',630939.00,630939.00,'960','2023-01-06 09:26:34','960','2023-01-06 09:27:06',10,0),('8','215',18,'Daily shift','2023-01-06','2023-01-07 08:24:30','2023-01-08 08:24:30','960',547395.00,547395.00,'960','2023-01-07 08:25:36','960','2023-01-07 08:26:03',10,0),('8','215',19,'Daily shift','2023-01-07','2023-01-08 09:06:28','2023-01-09 09:06:28','960',437331.00,437331.00,'960','2023-01-08 09:07:55','960','2023-01-08 09:08:24',10,0),('8','215',20,'Daily shift','2023-01-08','2023-01-09 09:30:26','2023-01-10 09:30:26','960',1275075.00,1275075.00,'960','2023-01-09 09:32:43','960','2023-01-09 09:33:10',10,0),('8','215',21,'Daily shift','2023-01-09','2023-01-10 08:12:42','2023-01-11 08:12:42','960',640035.00,640035.00,'960','2023-01-10 08:14:00','960','2023-01-10 08:14:35',10,0),('8','215',22,'Daily shift','2023-01-10','2023-01-11 10:06:14','2023-01-12 10:06:14','960',538485.00,538485.00,'960','2023-01-11 10:07:20','960','2023-01-11 10:08:22',10,0),('8','215',23,'Daily shift','2023-01-11','2023-01-12 08:41:01','2023-01-13 08:41:01','960',443241.00,443241.00,'960','2023-01-12 08:41:59','960','2023-01-12 08:42:26',10,0),('8','215',24,'Daily shift','2023-01-12','2023-01-13 08:50:13','2023-01-14 08:50:13','960',554151.00,554151.00,'960','2023-01-13 08:52:34','960','2023-01-13 08:53:04',10,0),('8','215',25,'Daily shift','2023-01-13','2023-01-14 09:18:08','2023-01-15 09:18:08','960',1352460.00,1352460.00,'960','2023-01-14 09:18:52','960','2023-01-14 09:19:12',10,0),('8','215',26,'Daily shift','2023-01-14','2023-01-15 08:55:44','2023-01-16 08:55:44','960',1127547.00,1127547.00,'960','2023-01-15 08:56:45','960','2023-01-15 08:57:08',10,0),('8','215',27,'Daily shift','2023-01-15','2023-01-16 09:11:33','2023-01-17 09:11:33','960',2402016.00,2402016.00,'960','2023-01-16 09:12:34','960','2023-01-16 09:13:10',10,0),('8','215',28,'Daily shift','2023-01-16','2023-01-17 09:02:05','2023-01-18 09:02:05','960',959616.00,959616.00,'960','2023-01-17 09:03:21','960','2023-01-17 09:03:47',10,0),('8','215',29,'Daily shift','2023-01-17','2023-01-18 08:10:27','2023-01-19 08:10:27','960',968238.00,968238.00,'960','2023-01-18 08:11:19','960','2023-01-18 08:11:42',10,0),('8','215',30,'Daily shift','2023-01-18','2023-01-19 09:01:50','2023-01-20 09:01:50','960',1110249.00,1110249.00,'960','2023-01-19 09:02:35','960','2023-01-19 09:03:02',10,0),('8','215',31,'Daily shift','2023-01-19','2023-01-20 16:33:39','2023-01-21 16:33:39','960',967941.00,967941.00,'960','2023-01-20 16:35:25','960','2023-01-20 16:35:49',10,0),('8','215',32,'Daily shift','2023-01-20','2023-01-21 09:12:07','2023-01-22 09:12:07','960',1154004.00,1154004.00,'960','2023-01-21 09:12:58','960','2023-01-21 09:13:26',10,0),('8','215',33,'Daily shift','2023-01-21','2023-01-22 08:44:31','2023-01-23 08:44:31','960',1437135.00,1437135.00,'960','2023-01-22 08:47:11','960','2023-01-22 08:49:18',10,0),('8','215',34,'Daily shift','2023-01-22','2023-01-23 12:15:47','2023-01-24 12:15:47','960',862467.00,862467.00,'960','2023-01-23 12:16:34','960','2023-01-23 12:17:00',10,0),('8','215',35,'Daily shift','2023-01-22','2023-01-23 12:25:12','2023-01-24 12:25:12','960',1612458.80,1612458.80,'960','2023-01-23 12:25:50','960','2023-01-23 12:26:14',10,0),('8','215',36,'Daily shift','2023-01-23','2023-01-24 14:38:43','2023-01-25 14:38:43','960',1504123.10,1504123.10,'960','2023-01-24 14:39:27','960','2023-01-24 14:40:09',10,0),('8','215',37,'Daily shift','2023-01-25','2023-01-26 13:48:19','2023-01-27 13:48:19','960',1392160.40,1392160.40,'960','2023-01-26 13:49:15','960','2023-01-26 13:49:44',10,0),('8','215',38,'Daily shift','2023-01-30','2023-01-31 10:23:01','2023-02-01 10:23:01','960',1094450.76,1094450.76,'960','2023-01-31 10:25:16','960','2023-01-31 10:26:06',10,0),('8','215',39,'Daily shift','2023-01-31','2023-02-01 08:36:44','2023-02-02 08:36:44','960',680654.26,680654.26,'960','2023-02-01 08:37:24','960','2023-02-01 08:37:53',10,0),('8','215',40,'Daily shift','2023-02-01','2023-02-02 12:24:10','2023-02-03 12:24:10','960',944679.00,944679.00,'960','2023-02-02 12:25:45','960','2023-02-02 12:26:34',10,0),('8','215',41,'Daily shift','2023-02-02','2023-02-03 08:34:18','2023-02-04 08:34:18','960',1007803.65,1007803.65,'960','2023-02-03 08:35:27','960','2023-02-03 08:35:59',10,0),('8','215',42,'Daily shift','2023-02-03','2023-02-04 14:13:43','2023-02-05 14:13:43','960',691690.50,691690.50,'960','2023-02-04 14:14:27','960','2023-02-04 14:14:53',10,0),('8','215',43,'Daily shift','2023-02-04','2023-02-05 08:52:57','2023-02-06 08:52:57','960',684210.90,684210.90,'960','2023-02-05 08:53:50','960','2023-02-05 08:54:29',10,0),('8','215',44,'Daily shift','2023-02-05','2023-02-06 08:44:34','2023-02-07 08:44:34','960',1463207.10,1463207.10,'960','2023-02-06 08:45:53','960','2023-02-06 08:50:08',10,0),('8','215',45,'Daily shift','2023-02-06','2023-02-07 16:52:32','2023-02-08 16:52:32','960',1431301.50,1431301.50,'960','2023-02-07 16:55:30','960','2023-02-07 16:56:13',10,0),('8','215',46,'Daily shift','2023-02-07','2023-02-08 13:17:08','2023-02-09 13:17:08','960',1204408.80,1204408.80,'960','2023-02-08 13:17:56','960','2023-02-08 13:18:27',10,0),('8','215',47,'Daily shift','2023-02-08','2023-02-09 13:12:03','2023-02-10 13:12:03','960',1444625.40,1444625.40,'960','2023-02-09 13:13:02','960','2023-02-09 13:13:45',10,0),('8','215',48,'Daily shift','2023-02-09','2023-02-10 10:18:55','2023-02-11 10:18:55','960',931710.45,931710.45,'960','2023-02-10 10:19:40','960','2023-02-10 10:20:07',10,0),('8','215',49,'Daily shift','2023-02-11','2023-02-12 08:58:03','2023-02-13 08:58:03','960',1998898.95,1998898.95,'960','2023-02-12 08:58:50','960','2023-02-12 08:59:17',10,0),('8','215',50,'Daily shift','2023-02-12','2023-02-13 12:18:48','2023-02-14 12:18:48','960',2502519.60,2502519.60,'960','2023-02-13 12:19:32','960','2023-02-13 12:20:03',10,0),('8','215',51,'Daily shift','2023-02-13','2023-02-14 08:49:07','2023-02-15 08:49:07','960',650994.30,650994.30,'960','2023-02-14 08:50:43','960','2023-02-14 08:51:20',10,0),('8','215',52,'Daily shift','2023-02-18','2023-02-20 10:09:29','2023-02-21 10:09:29','960',801692.80,801692.80,'960','2023-02-20 10:10:14','960','2023-02-20 10:10:58',10,0),('8','215',53,'Daily shift','2023-02-19','2023-02-20 10:15:33','2023-02-21 10:15:33','960',1318856.60,1318856.60,'960','2023-02-20 10:17:00','960','2023-02-20 10:17:19',10,0),('8','215',54,'Daily shift','2023-02-20','2023-02-21 08:21:03','2023-02-22 08:21:03','960',928618.20,928618.20,'960','2023-02-21 08:22:11','960','2023-02-21 08:23:06',10,0),('8','215',55,'Daily shift','2023-02-21','2023-02-22 12:27:43','2023-02-23 12:27:43','960',734359.20,734359.20,'960','2023-02-22 12:28:33','960','2023-02-22 12:28:58',10,0),('8','215',56,'Daily shift','2023-02-22','2023-02-23 08:37:33','2023-02-24 08:37:33','960',827913.60,827913.60,'960','2023-02-23 08:38:32','960','2023-02-23 08:38:57',10,0),('8','215',57,'Daily shift','2023-02-23','2023-02-24 08:12:06','2023-02-25 08:12:06','960',968409.60,968409.60,'960','2023-02-24 08:12:56','960','2023-02-24 08:14:35',10,0),('8','215',58,'Daily shift','2023-02-24','2023-02-26 22:29:54','2023-02-27 22:29:54','960',703577.60,703577.60,'960','2023-02-26 22:31:23','960','2023-02-26 22:31:52',10,0),('8','215',59,'Daily shift','2023-02-26','2023-02-27 10:21:49','2023-02-28 10:21:49','960',1918512.00,1918512.00,'960','2023-02-27 10:22:42','960','2023-02-27 10:23:10',10,0),('8','215',60,'Daily shift','2023-02-27','2023-02-28 10:17:22','2023-03-01 10:17:22','960',851008.00,851008.00,'960','2023-02-28 10:18:20','960','2023-02-28 10:18:50',10,0),('8','215',61,'Daily shift','2023-02-28','2023-03-01 11:37:41','2023-03-02 11:37:41','960',848723.20,848723.20,'960','2023-03-01 11:38:36','960','2023-03-01 11:39:04',10,0),('8','215',62,'Daily shift','2023-03-01','2023-03-02 11:26:12','2023-03-03 11:26:12','960',731318.40,731318.40,'960','2023-03-02 11:27:32','960','2023-03-02 11:28:42',10,0),('8','215',63,'Daily shift','2023-03-02','2023-03-04 08:45:47','2023-03-05 08:45:47','960',776809.60,776809.60,'960','2023-03-04 08:46:32','960','2023-03-04 08:46:56',10,0),('8','215',64,'Daily shift','2023-03-03','2023-03-04 08:52:32','2023-03-05 08:52:32','960',813513.00,813513.00,'960','2023-03-04 08:53:56','960','2023-03-04 08:54:31',10,0),('8','215',65,'Daily shift','2023-03-04','2023-03-06 08:53:59','2023-03-07 08:53:59','960',910197.00,910197.00,'960','2023-03-06 08:54:46','960','2023-03-06 08:55:10',10,0),('8','215',66,'Daily shift','2023-03-05','2023-03-06 08:57:44','2023-03-07 08:57:44','960',1497204.00,1497204.00,'960','2023-03-06 08:58:48','960','2023-03-06 08:59:16',10,0),('8','215',67,'Daily shift','2023-03-06','2023-03-08 08:53:01','2023-03-09 08:53:01','960',1105152.00,1105152.00,'960','2023-03-08 08:54:53','960','2023-03-08 08:55:25',10,0),('8','215',68,'Daily shift','2023-03-07','2023-03-08 09:08:14','2023-03-09 09:08:14','960',797256.00,797256.00,'960','2023-03-08 09:11:44','960','2023-03-08 09:12:27',10,0),('8','215',69,'Daily shift','2023-03-08','2023-03-09 10:04:15','2023-03-10 10:04:15','960',1044402.00,1044402.00,'960','2023-03-09 10:05:02','960','2023-03-09 10:06:43',10,0),('8','215',70,'Daily shift','2023-03-09','2023-03-10 09:17:13','2023-03-11 09:17:13','960',1313070.00,1313070.00,'960','2023-03-10 09:19:07','960','2023-03-10 09:19:38',10,0),('8','215',71,'Daily shift','2023-03-10','2023-03-11 08:36:50','2023-03-12 08:36:50','960',895659.00,895659.00,'960','2023-03-11 08:37:35','960','2023-03-11 08:38:20',10,0),('8','215',72,'Daily shift','2023-03-11','2023-03-12 12:58:04','2023-03-13 12:58:04','960',654804.00,654804.00,'960','2023-03-12 13:00:22','960','2023-03-12 13:00:44',10,0),('8','215',73,'Daily shift','2023-03-12','2023-03-13 09:18:51','2023-03-14 09:18:51','960',1786785.00,1786785.00,'960','2023-03-13 09:26:33','960','2023-03-13 09:28:07',10,0),('8','215',74,'Daily shift','2023-03-13','2023-03-14 08:36:08','2023-03-15 08:36:08','960',1526997.00,1526997.00,'960','2023-03-14 08:37:39','960','2023-03-14 08:38:02',10,0),('8','215',75,'Daily shift','2023-03-14','2023-03-15 09:13:47','2023-03-16 09:13:47','960',1413231.00,1413231.00,'960','2023-03-15 09:14:31','960','2023-03-15 09:15:06',10,0),('8','215',76,'Daily shift','2023-03-15','2023-03-16 08:28:22','2023-03-17 08:28:22','960',1399482.00,1399482.00,'960','2023-03-16 08:29:24','960','2023-03-16 08:29:46',10,0),('8','215',77,'Daily shift','2023-03-16','2023-03-17 08:06:28','2023-03-18 08:06:28','960',1227666.00,1227666.00,'960','2023-03-17 08:07:36','960','2023-03-17 08:08:02',10,0),('8','215',78,'Daily shift','2023-03-17','2023-03-20 07:54:22','2023-03-21 07:54:22','960',1419363.00,1419363.00,'960','2023-03-20 07:55:23','960','2023-03-20 07:55:54',10,0),('8','215',79,'Daily shift','2023-03-19','2023-03-20 10:49:09','2023-03-21 10:49:09','960',2195994.00,2195994.00,'960','2023-03-20 10:49:51','960','2023-03-20 10:50:18',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('8','215','1','1',1,'3','1',643709.75,646364.29,2654.54,809634.70,0.00,0.00,0.00,0.00,0.00),('8','215','1','1',2,'4','1',14681.40,14681.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','2',3,'3','1',646364.29,649328.90,2964.61,919029.10,0.00,0.00,0.00,0.00,0.00),('8','215','1','2',4,'4','1',14681.40,14681.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','3',5,'3','1',649328.90,652742.77,3413.87,1058299.70,0.00,0.00,0.00,0.00,0.00),('8','215','1','3',6,'4','1',14681.40,16363.14,1681.74,521339.40,0.00,0.00,0.00,0.00,0.00),('8','215','1','4',7,'3','1',652742.77,655870.65,3127.88,969642.80,0.00,0.00,0.00,0.00,0.00),('8','215','1','4',8,'4','1',16363.14,17478.80,1115.66,345854.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','5',9,'3','1',655870.65,658497.86,2627.21,814435.10,0.00,0.00,0.00,0.00,0.00),('8','215','1','5',10,'4','1',17478.80,18211.42,732.62,227112.20,0.00,0.00,0.00,0.00,0.00),('8','215','1','6',11,'3','1',658497.86,659398.83,900.97,279300.70,0.00,0.00,0.00,0.00,0.00),('8','215','1','6',12,'4','1',18211.42,18329.98,118.56,36753.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','7',13,'3','1',659398.83,662135.21,2736.38,848277.80,0.00,0.00,0.00,0.00,0.00),('8','215','1','7',14,'4','1',18329.98,18806.01,476.03,147569.30,0.00,0.00,0.00,0.00,0.00),('8','215','1','8',15,'3','1',662135.21,664550.44,2415.23,748721.30,0.00,0.00,0.00,0.00,0.00),('8','215','1','8',16,'4','1',18806.01,20137.32,1331.31,412706.10,0.00,0.00,0.00,0.00,0.00),('8','215','1','9',17,'3','1',664550.44,666466.83,1916.39,594080.90,0.00,0.00,0.00,0.00,0.00),('8','215','1','9',18,'4','1',20137.32,20695.94,558.62,173172.20,0.00,0.00,0.00,0.00,0.00),('8','215','1','10',19,'3','1',666466.83,667799.45,1332.62,413112.20,0.00,0.00,0.00,0.00,0.00),('8','215','1','10',20,'4','1',20695.94,21252.12,556.18,172415.80,0.00,0.00,0.00,0.00,0.00),('8','215','1','11',21,'3','1',667799.45,669107.70,1308.25,405557.50,0.00,0.00,0.00,0.00,0.00),('8','215','1','11',22,'4','1',21252.12,21684.34,432.22,133988.20,0.00,0.00,0.00,0.00,0.00),('8','215','1','12',23,'3','1',669107.70,671033.46,1925.76,596985.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','12',24,'4','1',21684.34,21684.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','13',25,'3','1',671033.46,674212.73,3179.27,953781.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','13',26,'4','1',21684.34,22407.74,723.40,217020.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','14',27,'3','1',674212.73,675797.57,1584.84,475452.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','14',28,'4','1',22407.74,22828.03,420.29,126087.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','15',29,'3','1',675797.57,678062.02,2264.45,679335.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','15',30,'4','1',22828.03,23028.55,200.52,60156.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','16',31,'3','1',678062.02,680057.16,1995.14,598542.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','16',32,'4','1',23028.55,23351.37,322.82,96846.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','17',33,'3','1',680057.16,681898.34,1841.18,552354.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','17',34,'4','1',23351.37,23613.32,261.95,78585.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','18',35,'3','1',681898.34,683656.34,1758.00,527400.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','18',36,'4','1',23613.32,23679.97,66.65,19995.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','19',37,'3','1',683656.34,684916.01,1259.67,377901.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','19',38,'4','1',23679.97,23878.07,198.10,59430.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','20',39,'3','1',684916.01,687688.12,2772.11,831633.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','20',40,'4','1',23878.07,25356.21,1478.14,443442.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','21',41,'3','1',687688.12,689821.57,2133.45,640035.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','21',42,'4','1',25356.21,25356.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','22',43,'3','1',689821.57,691616.52,1794.95,538485.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','22',44,'4','1',25356.21,25356.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','23',45,'3','1',691616.52,693093.99,1477.47,443241.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','23',46,'4','1',25356.21,25356.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','24',47,'3','1',693093.99,694941.16,1847.17,554151.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','24',48,'4','1',25356.21,25356.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','25',49,'3','1',694941.16,699449.36,4508.20,1352460.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','25',50,'4','1',25356.21,25356.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','26',51,'3','1',699449.36,703207.85,3758.49,1127547.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','26',52,'4','1',25356.21,25356.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','27',53,'3','1',703207.85,711214.57,8006.72,2402016.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','27',54,'4','1',25356.21,25356.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','28',55,'3','1',711214.57,714405.17,3190.60,957180.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','28',56,'4','1',25356.21,25364.33,8.12,2436.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','29',57,'3','1',714405.17,717632.63,3227.46,968238.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','29',58,'4','1',25364.33,25364.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','30',59,'3','1',717632.63,721333.46,3700.83,1110249.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','30',60,'4','1',25364.33,25364.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','31',61,'3','1',721333.46,724559.93,3226.47,967941.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','31',62,'4','1',25364.33,25364.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','32',63,'3','1',724559.93,728406.61,3846.68,1154004.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','32',64,'4','1',25364.33,25364.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','33',65,'3','1',728406.61,733197.06,4790.45,1437135.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','33',66,'4','1',25364.33,25364.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','34',67,'3','1',733197.06,736071.95,2874.89,862467.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','34',68,'4','1',25364.33,25364.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','35',69,'3','1',736071.95,741273.43,5201.48,1612458.80,0.00,0.00,0.00,0.00,0.00),('8','215','1','35',70,'4','1',25364.33,25364.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','36',71,'3','1',741273.43,746125.44,4852.01,1504123.10,0.00,0.00,0.00,0.00,0.00),('8','215','1','36',72,'4','1',25364.33,25364.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','37',73,'3','1',746125.44,750599.53,4474.09,1386967.90,0.00,0.00,0.00,0.00,0.00),('8','215','1','37',74,'4','1',25364.33,25381.08,16.75,5192.50,0.00,0.00,0.00,0.00,0.00),('8','215','1','38',75,'3','1',750599.53,753837.55,3238.02,1094450.76,0.00,0.00,0.00,0.00,0.00),('8','215','1','38',76,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','39',77,'3','1',753837.55,755851.32,2013.77,680654.26,0.00,0.00,0.00,0.00,0.00),('8','215','1','39',78,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','40',79,'3','1',755851.32,758589.52,2738.20,944679.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','40',80,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','41',81,'3','1',758589.52,761510.69,2921.17,1007803.65,0.00,0.00,0.00,0.00,0.00),('8','215','1','41',82,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','42',83,'3','1',761510.69,763515.59,2004.90,691690.50,0.00,0.00,0.00,0.00,0.00),('8','215','1','42',84,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','43',85,'3','1',763515.59,765498.81,1983.22,684210.90,0.00,0.00,0.00,0.00,0.00),('8','215','1','43',86,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','44',87,'3','1',765498.81,769739.99,4241.18,1463207.10,0.00,0.00,0.00,0.00,0.00),('8','215','1','44',88,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','45',89,'3','1',769739.99,773888.69,4148.70,1431301.50,0.00,0.00,0.00,0.00,0.00),('8','215','1','45',90,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','46',91,'3','1',773888.69,777379.73,3491.04,1204408.80,0.00,0.00,0.00,0.00,0.00),('8','215','1','46',92,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','47',93,'3','1',777379.73,781567.05,4187.32,1444625.40,0.00,0.00,0.00,0.00,0.00),('8','215','1','47',94,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','48',95,'3','1',781567.05,784267.66,2700.61,931710.45,0.00,0.00,0.00,0.00,0.00),('8','215','1','48',96,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','49',97,'3','1',784267.66,790061.57,5793.91,1998898.95,0.00,0.00,0.00,0.00,0.00),('8','215','1','49',98,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','50',99,'3','1',790061.57,797315.25,7253.68,2502519.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','50',100,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','51',101,'3','1',797315.25,799202.19,1886.94,650994.30,0.00,0.00,0.00,0.00,0.00),('8','215','1','51',102,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','52',103,'3','1',799202.19,801560.11,2357.92,801692.80,0.00,0.00,0.00,0.00,0.00),('8','215','1','52',104,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','53',105,'3','1',801560.11,805439.10,3878.99,1318856.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','53',106,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','54',107,'3','1',805439.10,808170.33,2731.23,928618.20,0.00,0.00,0.00,0.00,0.00),('8','215','1','54',108,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','55',109,'3','1',808170.33,810330.21,2159.88,734359.20,0.00,0.00,0.00,0.00,0.00),('8','215','1','55',110,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','56',111,'3','1',810330.21,812917.44,2587.23,827913.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','56',112,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','57',113,'3','1',812917.44,815943.72,3026.28,968409.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','57',114,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','58',115,'3','1',815943.72,818142.40,2198.68,703577.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','58',116,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','59',117,'3','1',818142.40,824137.75,5995.35,1918512.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','59',118,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','60',119,'3','1',824137.75,826797.15,2659.40,851008.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','60',120,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','61',121,'3','1',826797.15,829449.41,2652.26,848723.20,0.00,0.00,0.00,0.00,0.00),('8','215','1','61',122,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','62',123,'3','1',829449.41,831734.78,2285.37,731318.40,0.00,0.00,0.00,0.00,0.00),('8','215','1','62',124,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','63',125,'3','1',831734.78,834162.31,2427.53,776809.60,0.00,0.00,0.00,0.00,0.00),('8','215','1','63',126,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','64',127,'3','1',834162.31,836874.02,2711.71,813513.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','64',128,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','65',129,'3','1',836874.02,839908.01,3033.99,910197.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','65',130,'4','1',25381.08,25381.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','66',131,'3','1',839908.01,843522.11,3614.10,1084230.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','66',132,'4','1',25381.08,26757.66,1376.58,412974.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','67',133,'3','1',843522.11,847205.95,3683.84,1105152.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','67',134,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','68',135,'3','1',847205.95,849863.47,2657.52,797256.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','68',136,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','69',137,'3','1',849863.47,853344.81,3481.34,1044402.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','69',138,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','70',139,'3','1',853344.81,857721.71,4376.90,1313070.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','70',140,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','71',141,'3','1',857721.71,860707.24,2985.53,895659.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','71',142,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','72',143,'3','1',860707.24,862889.92,2182.68,654804.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','72',144,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','73',145,'3','1',862889.92,868845.87,5955.95,1786785.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','73',146,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','74',147,'3','1',868845.87,873935.86,5089.99,1526997.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','74',148,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','75',149,'3','1',873935.86,878646.63,4710.77,1413231.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','75',150,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','76',151,'3','1',878646.63,883311.57,4664.94,1399482.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','76',152,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','77',153,'3','1',883311.57,887403.79,4092.22,1227666.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','77',154,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','78',155,'3','1',887403.79,892135.00,4731.21,1419363.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','78',156,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','79',157,'3','1',892135.00,899454.98,7319.98,2195994.00,0.00,0.00,0.00,0.00,0.00),('8','215','1','79',158,'4','1',26757.66,26757.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('8','215','1','1',305.00,305.00,2654.54,0.00,0.00,0.00,0.00,1),('8','215','2','1',310.00,310.00,2964.61,0.00,0.00,0.00,0.00,2),('8','215','3','1',310.00,310.00,5095.61,0.00,0.00,0.00,0.00,3),('8','215','4','1',310.00,310.00,4243.54,0.00,0.00,0.00,0.00,4),('8','215','5','1',310.00,310.00,3359.83,0.00,0.00,0.00,0.00,5),('8','215','6','1',310.00,310.00,1019.53,0.00,0.00,0.00,0.00,6),('8','215','7','1',310.00,310.00,3212.41,0.00,0.00,0.00,0.00,7),('8','215','8','1',310.00,310.00,3746.54,0.00,0.00,0.00,0.00,8),('8','215','9','1',310.00,310.00,2475.01,0.00,0.00,0.00,0.00,9),('8','215','10','1',310.00,310.00,1888.80,0.00,0.00,0.00,0.00,10),('8','215','11','1',310.00,310.00,1740.47,0.00,0.00,0.00,0.00,11),('8','215','12','1',310.00,310.00,1925.76,0.00,0.00,0.00,0.00,12),('8','215','13','1',300.00,300.00,3902.67,0.00,0.00,0.00,0.00,13),('8','215','14','1',300.00,300.00,2005.13,0.00,0.00,0.00,0.00,14),('8','215','15','1',300.00,300.00,2464.97,0.00,0.00,0.00,0.00,15),('8','215','16','1',300.00,300.00,2317.96,0.00,0.00,0.00,0.00,16),('8','215','17','1',300.00,300.00,2103.13,0.00,0.00,0.00,0.00,17),('8','215','18','1',300.00,300.00,1824.65,0.00,0.00,0.00,0.00,18),('8','215','19','1',300.00,300.00,1457.77,0.00,0.00,0.00,0.00,19),('8','215','20','1',300.00,300.00,4250.25,0.00,0.00,0.00,0.00,20),('8','215','21','1',300.00,300.00,2133.45,0.00,0.00,0.00,0.00,21),('8','215','22','1',300.00,300.00,1794.95,0.00,0.00,0.00,0.00,22),('8','215','23','1',300.00,300.00,1477.47,0.00,0.00,0.00,0.00,23),('8','215','24','1',300.00,300.00,1847.17,0.00,0.00,0.00,0.00,24),('8','215','25','1',300.00,300.00,4508.20,0.00,0.00,0.00,0.00,25),('8','215','26','1',300.00,300.00,3758.49,0.00,0.00,0.00,0.00,26),('8','215','27','1',300.00,300.00,8006.72,0.00,0.00,0.00,0.00,27),('8','215','28','1',300.00,300.00,3198.72,0.00,0.00,0.00,0.00,28),('8','215','29','1',300.00,300.00,3227.46,0.00,0.00,0.00,0.00,29),('8','215','30','1',300.00,300.00,3700.83,0.00,0.00,0.00,0.00,30),('8','215','31','1',300.00,300.00,3226.47,0.00,0.00,0.00,0.00,31),('8','215','32','1',300.00,300.00,3846.68,0.00,0.00,0.00,0.00,32),('8','215','33','1',300.00,300.00,4790.45,0.00,0.00,0.00,0.00,33),('8','215','34','1',300.00,300.00,2874.89,0.00,0.00,0.00,0.00,34),('8','215','35','1',310.00,310.00,5201.48,0.00,0.00,0.00,0.00,35),('8','215','36','1',310.00,310.00,4852.01,0.00,0.00,0.00,0.00,36),('8','215','37','1',310.00,310.00,4490.84,0.00,0.00,0.00,0.00,37),('8','215','38','1',338.00,338.00,3238.02,0.00,0.00,0.00,0.00,38),('8','215','39','1',338.00,338.00,2013.77,0.00,0.00,0.00,0.00,39),('8','215','40','1',345.00,345.00,2738.20,0.00,0.00,0.00,0.00,40),('8','215','41','1',345.00,345.00,2921.17,0.00,0.00,0.00,0.00,41),('8','215','42','1',345.00,345.00,2004.90,0.00,0.00,0.00,0.00,42),('8','215','43','1',345.00,345.00,1983.22,0.00,0.00,0.00,0.00,43),('8','215','44','1',345.00,345.00,4241.18,0.00,0.00,0.00,0.00,44),('8','215','45','1',345.00,345.00,4148.70,0.00,0.00,0.00,0.00,45),('8','215','46','1',345.00,345.00,3491.04,0.00,0.00,0.00,0.00,46),('8','215','47','1',345.00,345.00,4187.32,0.00,0.00,0.00,0.00,47),('8','215','48','1',345.00,345.00,2700.61,0.00,0.00,0.00,0.00,48),('8','215','49','1',345.00,345.00,5793.91,0.00,0.00,0.00,0.00,49),('8','215','50','1',345.00,345.00,7253.68,0.00,0.00,0.00,0.00,50),('8','215','51','1',345.00,345.00,1886.94,0.00,0.00,0.00,0.00,51),('8','215','52','1',340.00,340.00,2357.92,0.00,0.00,0.00,0.00,52),('8','215','53','1',340.00,340.00,3878.99,0.00,0.00,0.00,0.00,53),('8','215','54','1',340.00,340.00,2731.23,0.00,0.00,0.00,0.00,54),('8','215','55','1',340.00,340.00,2159.88,0.00,0.00,0.00,0.00,55),('8','215','56','1',320.00,320.00,2587.23,0.00,0.00,0.00,0.00,56),('8','215','57','1',320.00,320.00,3026.28,0.00,0.00,0.00,0.00,57),('8','215','58','1',320.00,320.00,2198.68,0.00,0.00,0.00,0.00,58),('8','215','59','1',320.00,320.00,5995.35,0.00,0.00,0.00,0.00,59),('8','215','60','1',320.00,320.00,2659.40,0.00,0.00,0.00,0.00,60),('8','215','61','1',320.00,320.00,2652.26,0.00,0.00,0.00,0.00,61),('8','215','62','1',320.00,320.00,2285.37,0.00,0.00,0.00,0.00,62),('8','215','63','1',320.00,320.00,2427.53,0.00,0.00,0.00,0.00,63),('8','215','64','1',300.00,300.00,2711.71,0.00,0.00,0.00,0.00,64),('8','215','65','1',300.00,300.00,3033.99,0.00,0.00,0.00,0.00,65),('8','215','66','1',300.00,300.00,4990.68,0.00,0.00,0.00,0.00,66),('8','215','67','1',300.00,300.00,3683.84,0.00,0.00,0.00,0.00,67),('8','215','68','1',300.00,300.00,2657.52,0.00,0.00,0.00,0.00,68),('8','215','69','1',300.00,300.00,3481.34,0.00,0.00,0.00,0.00,69),('8','215','70','1',300.00,300.00,4376.90,0.00,0.00,0.00,0.00,70),('8','215','71','1',300.00,300.00,2985.53,0.00,0.00,0.00,0.00,71),('8','215','72','1',300.00,300.00,2182.68,0.00,0.00,0.00,0.00,72),('8','215','73','1',300.00,300.00,5955.95,0.00,0.00,0.00,0.00,73),('8','215','74','1',300.00,300.00,5089.99,0.00,0.00,0.00,0.00,74),('8','215','75','1',300.00,300.00,4710.77,0.00,0.00,0.00,0.00,75),('8','215','76','1',300.00,300.00,4664.94,0.00,0.00,0.00,0.00,76),('8','215','77','1',300.00,300.00,4092.22,0.00,0.00,0.00,0.00,77),('8','215','78','1',300.00,300.00,4731.21,0.00,0.00,0.00,0.00,78),('8','215','79','1',300.00,300.00,7319.98,0.00,0.00,0.00,0.00,79);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('8',1,'215','PRODUCT TANKS','Tanks Containing Petroleum Product');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('8','215','1',1,0,'1','PMS TANK 1 & 3',60000.00,0.00,NULL,'TANK CONTAINING PETROL.','963','2022-10-16 01:39:58','2022-12-16 14:58:39','467',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'8','215',1,22848.49,'2023-03-20 10:49:09');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,854000.00,2800.00,0.00,0.00,'2022-12-17 07:28:48','',''),(2,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5185000.00,17000.00,0.00,0.00,'2022-12-17 07:29:02','',''),(3,'8','215',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,17000.00,0.00,'2022-12-17 11:36:41','',''),(4,'8','215','1',1,'Received from bridging 1',0.00,0.00,17000.00,0.00,0.00,'2022-12-17 11:36:41','',''),(5,'8','215',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,2800.00,0.00,'2022-12-17 11:43:32','',''),(6,'8','215','1',1,'Received from bridging 2',0.00,0.00,2800.00,0.00,0.00,'2022-12-17 11:43:32','',''),(7,'8','215','1',1,'Sale Id shift 1',0.00,0.00,0.00,2654.54,0.00,'2022-12-17 11:48:25','',''),(8,'8','215',NULL,1,'Sale Id shift 1',809634.70,0.00,0.00,0.00,0.00,'2022-12-17 11:48:25','',''),(9,'8','215','1',1,'Sale Id shift 2',0.00,0.00,0.00,2964.61,0.00,'2022-12-18 13:43:26','',''),(10,'8','215',NULL,1,'Sale Id shift 2',919029.10,0.00,0.00,0.00,0.00,'2022-12-18 13:43:26','',''),(11,'8','215','1',1,'Sale Id shift 3',0.00,0.00,0.00,3413.87,0.00,'2022-12-19 15:31:21','',''),(12,'8','215','1',1,'Sale Id shift 3',0.00,0.00,0.00,1681.74,0.00,'2022-12-19 15:31:21','',''),(13,'8','215',NULL,1,'Sale Id shift 3',1579639.10,0.00,0.00,0.00,0.00,'2022-12-19 15:31:21','',''),(14,'8','215','1',1,'Sale Id shift 4',0.00,0.00,0.00,3127.88,0.00,'2022-12-20 09:37:10','',''),(15,'8','215','1',1,'Sale Id shift 4',0.00,0.00,0.00,1115.66,0.00,'2022-12-20 09:37:10','',''),(16,'8','215',NULL,1,'Sale Id shift 4',1315497.40,0.00,0.00,0.00,0.00,'2022-12-20 09:37:10','',''),(17,'8','215','1',1,'Sale Id shift 5',0.00,0.00,0.00,2627.21,0.00,'2022-12-21 14:21:14','',''),(18,'8','215','1',1,'Sale Id shift 5',0.00,0.00,0.00,732.62,0.00,'2022-12-21 14:21:14','',''),(19,'8','215',NULL,1,'Sale Id shift 5',1041547.30,0.00,0.00,0.00,0.00,'2022-12-21 14:21:14','',''),(20,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5022000.00,16200.00,0.00,0.00,'2022-12-23 15:52:28','',''),(21,'8','215',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,16200.00,0.00,'2022-12-23 17:52:50','',''),(22,'8','215','1',1,'Received from bridging 3',0.00,0.00,16200.00,0.00,0.00,'2022-12-23 17:52:50','',''),(23,'8','215','1',1,'Sale Id shift 6',0.00,0.00,0.00,900.97,0.00,'2022-12-25 16:21:23','',''),(24,'8','215','1',1,'Sale Id shift 6',0.00,0.00,0.00,118.56,0.00,'2022-12-25 16:21:23','',''),(25,'8','215',NULL,1,'Sale Id shift 6',316054.30,0.00,0.00,0.00,0.00,'2022-12-25 16:21:23','',''),(26,'8','215','1',1,'Sale Id shift 7',0.00,0.00,0.00,2736.38,0.00,'2022-12-25 16:27:30','',''),(27,'8','215','1',1,'Sale Id shift 7',0.00,0.00,0.00,476.03,0.00,'2022-12-25 16:27:30','',''),(28,'8','215',NULL,1,'Sale Id shift 7',995847.10,0.00,0.00,0.00,0.00,'2022-12-25 16:27:30','',''),(29,'8','215','1',1,'Sale Id shift 8',0.00,0.00,0.00,2415.23,0.00,'2022-12-26 08:35:46','',''),(30,'8','215','1',1,'Sale Id shift 8',0.00,0.00,0.00,1331.31,0.00,'2022-12-26 08:35:46','',''),(31,'8','215',NULL,1,'Sale Id shift 8',1161427.40,0.00,0.00,0.00,0.00,'2022-12-26 08:35:46','',''),(32,'8','215','1',1,'Sale Id shift 9',0.00,0.00,0.00,1916.39,0.00,'2022-12-27 09:27:17','',''),(33,'8','215','1',1,'Sale Id shift 9',0.00,0.00,0.00,558.62,0.00,'2022-12-27 09:27:17','',''),(34,'8','215',NULL,1,'Sale Id shift 9',767253.10,0.00,0.00,0.00,0.00,'2022-12-27 09:27:17','',''),(35,'8','215','1',1,'Sale Id shift 10',0.00,0.00,0.00,1332.62,0.00,'2022-12-28 08:31:54','',''),(36,'8','215','1',1,'Sale Id shift 10',0.00,0.00,0.00,556.18,0.00,'2022-12-28 08:31:54','',''),(37,'8','215',NULL,1,'Sale Id shift 10',585528.00,0.00,0.00,0.00,0.00,'2022-12-28 08:31:54','',''),(38,'8','215','1',1,'Sale Id shift 11',0.00,0.00,0.00,1308.25,0.00,'2022-12-29 08:22:19','',''),(39,'8','215','1',1,'Sale Id shift 11',0.00,0.00,0.00,432.22,0.00,'2022-12-29 08:22:19','',''),(40,'8','215',NULL,1,'Sale Id shift 11',539545.70,0.00,0.00,0.00,0.00,'2022-12-29 08:22:19','',''),(41,'8','215','1',1,'Sale Id shift 12',0.00,0.00,0.00,1925.76,0.00,'2022-12-30 09:45:36','',''),(42,'8','215',NULL,1,'Sale Id shift 12',596985.60,0.00,0.00,0.00,0.00,'2022-12-30 09:45:36','',''),(43,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5040000.00,16800.00,0.00,0.00,'2023-01-01 12:09:36','',''),(44,'8','215',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,16800.00,0.00,'2023-01-01 17:26:02','',''),(45,'8','215','1',1,'Received from bridging 4',0.00,0.00,16800.00,0.00,0.00,'2023-01-01 17:26:02','',''),(46,'8','215','1',1,'Sale Id shift 13',0.00,0.00,0.00,3179.27,0.00,'2023-01-02 08:17:02','',''),(47,'8','215','1',1,'Sale Id shift 13',0.00,0.00,0.00,723.40,0.00,'2023-01-02 08:17:02','',''),(48,'8','215',NULL,1,'Sale Id shift 13',1170801.00,0.00,0.00,0.00,0.00,'2023-01-02 08:17:02','',''),(49,'8','215','1',1,'Sale Id shift 14',0.00,0.00,0.00,1584.84,0.00,'2023-01-03 08:21:50','',''),(50,'8','215','1',1,'Sale Id shift 14',0.00,0.00,0.00,420.29,0.00,'2023-01-03 08:21:50','',''),(51,'8','215',NULL,1,'Sale Id shift 14',601539.00,0.00,0.00,0.00,0.00,'2023-01-03 08:21:50','',''),(52,'8','215','1',1,'Sale Id shift 15',0.00,0.00,0.00,2264.45,0.00,'2023-01-04 08:50:25','',''),(53,'8','215','1',1,'Sale Id shift 15',0.00,0.00,0.00,200.52,0.00,'2023-01-04 08:50:25','',''),(54,'8','215',NULL,1,'Sale Id shift 15',739491.00,0.00,0.00,0.00,0.00,'2023-01-04 08:50:25','',''),(55,'8','215','1',1,'Sale Id shift 16',0.00,0.00,0.00,1995.14,0.00,'2023-01-05 09:09:23','',''),(56,'8','215','1',1,'Sale Id shift 16',0.00,0.00,0.00,322.82,0.00,'2023-01-05 09:09:23','',''),(57,'8','215',NULL,1,'Sale Id shift 16',695388.00,0.00,0.00,0.00,0.00,'2023-01-05 09:09:23','',''),(58,'8','215','1',1,'Sale Id shift 17',0.00,0.00,0.00,1841.18,0.00,'2023-01-06 09:27:06','',''),(59,'8','215','1',1,'Sale Id shift 17',0.00,0.00,0.00,261.95,0.00,'2023-01-06 09:27:06','',''),(60,'8','215',NULL,1,'Sale Id shift 17',630939.00,0.00,0.00,0.00,0.00,'2023-01-06 09:27:06','',''),(61,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,9780000.00,32600.00,0.00,0.00,'2023-01-06 09:41:46','',''),(62,'8','215',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,32600.00,0.00,'2023-01-06 22:03:41','',''),(63,'8','215','1',1,'Received from bridging 5',0.00,0.00,32600.00,0.00,0.00,'2023-01-06 22:03:41','',''),(64,'8','215','1',1,'Sale Id shift 18',0.00,0.00,0.00,1758.00,0.00,'2023-01-07 08:26:03','',''),(65,'8','215','1',1,'Sale Id shift 18',0.00,0.00,0.00,66.65,0.00,'2023-01-07 08:26:03','',''),(66,'8','215',NULL,1,'Sale Id shift 18',547395.00,0.00,0.00,0.00,0.00,'2023-01-07 08:26:03','',''),(67,'8','215','1',1,'Sale Id shift 19',0.00,0.00,0.00,1259.67,0.00,'2023-01-08 09:08:24','',''),(68,'8','215','1',1,'Sale Id shift 19',0.00,0.00,0.00,198.10,0.00,'2023-01-08 09:08:24','',''),(69,'8','215',NULL,1,'Sale Id shift 19',437331.00,0.00,0.00,0.00,0.00,'2023-01-08 09:08:24','',''),(70,'8','215','1',1,'Sale Id shift 20',0.00,0.00,0.00,2772.11,0.00,'2023-01-09 09:33:10','',''),(71,'8','215','1',1,'Sale Id shift 20',0.00,0.00,0.00,1478.14,0.00,'2023-01-09 09:33:10','',''),(72,'8','215',NULL,1,'Sale Id shift 20',1275075.00,0.00,0.00,0.00,0.00,'2023-01-09 09:33:10','',''),(73,'8','215','1',1,'Sale Id shift 21',0.00,0.00,0.00,2133.45,0.00,'2023-01-10 08:14:35','',''),(74,'8','215',NULL,1,'Sale Id shift 21',640035.00,0.00,0.00,0.00,0.00,'2023-01-10 08:14:35','',''),(75,'8','215','1',1,'Sale Id shift 22',0.00,0.00,0.00,1794.95,0.00,'2023-01-11 10:08:22','',''),(76,'8','215',NULL,1,'Sale Id shift 22',538485.00,0.00,0.00,0.00,0.00,'2023-01-11 10:08:22','',''),(77,'8','215','1',1,'Sale Id shift 23',0.00,0.00,0.00,1477.47,0.00,'2023-01-12 08:42:26','',''),(78,'8','215',NULL,1,'Sale Id shift 23',443241.00,0.00,0.00,0.00,0.00,'2023-01-12 08:42:26','',''),(79,'8','215','1',1,'Sale Id shift 24',0.00,0.00,0.00,1847.17,0.00,'2023-01-13 08:53:04','',''),(80,'8','215',NULL,1,'Sale Id shift 24',554151.00,0.00,0.00,0.00,0.00,'2023-01-13 08:53:04','',''),(81,'8','215','1',1,'Sale Id shift 25',0.00,0.00,0.00,4508.20,0.00,'2023-01-14 09:19:12','',''),(82,'8','215',NULL,1,'Sale Id shift 25',1352460.00,0.00,0.00,0.00,0.00,'2023-01-14 09:19:12','',''),(83,'8','215','1',1,'Sale Id shift 26',0.00,0.00,0.00,3758.49,0.00,'2023-01-15 08:57:08','',''),(84,'8','215',NULL,1,'Sale Id shift 26',1127547.00,0.00,0.00,0.00,0.00,'2023-01-15 08:57:08','',''),(85,'8','215','1',1,'Sale Id shift 27',0.00,0.00,0.00,8006.72,0.00,'2023-01-16 09:13:10','',''),(86,'8','215',NULL,1,'Sale Id shift 27',2402016.00,0.00,0.00,0.00,0.00,'2023-01-16 09:13:10','',''),(87,'8','215','1',1,'Sale Id shift 28',0.00,0.00,0.00,3190.60,0.00,'2023-01-17 09:03:47','',''),(88,'8','215','1',1,'Sale Id shift 28',0.00,0.00,0.00,8.12,0.00,'2023-01-17 09:03:47','',''),(89,'8','215',NULL,1,'Sale Id shift 28',959616.00,0.00,0.00,0.00,0.00,'2023-01-17 09:03:47','',''),(90,'8','215','1',1,'Sale Id shift 29',0.00,0.00,0.00,3227.46,0.00,'2023-01-18 08:11:43','',''),(91,'8','215',NULL,1,'Sale Id shift 29',968238.00,0.00,0.00,0.00,0.00,'2023-01-18 08:11:43','',''),(92,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,4785000.00,15950.00,0.00,0.00,'2023-01-18 14:43:50','',''),(93,'8','215',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,15950.00,0.00,'2023-01-18 19:55:35','',''),(94,'8','215','1',1,'Received from bridging 6',0.00,0.00,15950.00,0.00,0.00,'2023-01-18 19:55:35','',''),(95,'8','215','1',1,'Sale Id shift 30',0.00,0.00,0.00,3700.83,0.00,'2023-01-19 09:03:02','',''),(96,'8','215',NULL,1,'Sale Id shift 30',1110249.00,0.00,0.00,0.00,0.00,'2023-01-19 09:03:02','',''),(97,'8','215','1',1,'Sale Id shift 31',0.00,0.00,0.00,3226.47,0.00,'2023-01-20 16:35:49','',''),(98,'8','215',NULL,1,'Sale Id shift 31',967941.00,0.00,0.00,0.00,0.00,'2023-01-20 16:35:49','',''),(99,'8','215','1',1,'Sale Id shift 32',0.00,0.00,0.00,3846.68,0.00,'2023-01-21 09:13:26','',''),(100,'8','215',NULL,1,'Sale Id shift 32',1154004.00,0.00,0.00,0.00,0.00,'2023-01-21 09:13:26','',''),(101,'8','215','1',1,'Sale Id shift 33',0.00,0.00,0.00,4790.45,0.00,'2023-01-22 08:49:18','',''),(102,'8','215',NULL,1,'Sale Id shift 33',1437135.00,0.00,0.00,0.00,0.00,'2023-01-22 08:49:18','',''),(103,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5040000.00,16800.00,0.00,0.00,'2023-01-22 13:22:13','',''),(104,'8','215',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,16800.00,0.00,'2023-01-22 19:35:18','',''),(105,'8','215','1',1,'Received from bridging 7',0.00,0.00,16800.00,0.00,0.00,'2023-01-22 19:35:18','',''),(106,'8','215','1',1,'Sale Id shift 34',0.00,0.00,0.00,2874.89,0.00,'2023-01-23 12:17:00','',''),(107,'8','215',NULL,1,'Sale Id shift 34',862467.00,0.00,0.00,0.00,0.00,'2023-01-23 12:17:00','',''),(108,'8','215','1',1,'Sale Id shift 35',0.00,0.00,0.00,5201.48,0.00,'2023-01-23 12:26:14','',''),(109,'8','215',NULL,1,'Sale Id shift 35',1612458.80,0.00,0.00,0.00,0.00,'2023-01-23 12:26:14','',''),(110,'8','215','1',1,'Sale Id shift 36',0.00,0.00,0.00,4852.01,0.00,'2023-01-24 14:40:09','',''),(111,'8','215',NULL,1,'Sale Id shift 36',1504123.10,0.00,0.00,0.00,0.00,'2023-01-24 14:40:09','',''),(112,'8','215','1',1,'Sale Id shift 37',0.00,0.00,0.00,4474.09,0.00,'2023-01-26 13:49:44','',''),(113,'8','215','1',1,'Sale Id shift 37',0.00,0.00,0.00,16.75,0.00,'2023-01-26 13:49:44','',''),(114,'8','215',NULL,1,'Sale Id shift 37',1392160.40,0.00,0.00,0.00,0.00,'2023-01-26 13:49:44','',''),(115,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5270000.00,17000.00,0.00,0.00,'2023-01-30 08:47:56','',''),(116,'8','215',NULL,1,'Returned purchase #8 to Lausu Energy Resources',5270000.00,0.00,0.00,17000.00,0.00,'2023-01-30 12:07:11','',''),(117,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5746000.00,17000.00,0.00,0.00,'2023-01-30 15:27:06','',''),(118,'8','215',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,17000.00,0.00,'2023-01-31 10:21:15','',''),(119,'8','215','1',1,'Received from bridging 8',0.00,0.00,17000.00,0.00,0.00,'2023-01-31 10:21:15','',''),(120,'8','215','1',1,'Sale Id shift 38',0.00,0.00,0.00,3238.02,0.00,'2023-01-31 10:26:06','',''),(121,'8','215',NULL,1,'Sale Id shift 38',1094450.76,0.00,0.00,0.00,0.00,'2023-01-31 10:26:06','',''),(122,'8','215','1',1,'Sale Id shift 39',0.00,0.00,0.00,2013.77,0.00,'2023-02-01 08:37:54','',''),(123,'8','215',NULL,1,'Sale Id shift 39',680654.26,0.00,0.00,0.00,0.00,'2023-02-01 08:37:54','',''),(124,'8','215','1',1,'Sale Id shift 40',0.00,0.00,0.00,2738.20,0.00,'2023-02-02 12:26:34','',''),(125,'8','215',NULL,1,'Sale Id shift 40',944679.00,0.00,0.00,0.00,0.00,'2023-02-02 12:26:34','',''),(126,'8','215','1',1,'Sale Id shift 41',0.00,0.00,0.00,2921.17,0.00,'2023-02-03 08:35:59','',''),(127,'8','215',NULL,1,'Sale Id shift 41',1007803.65,0.00,0.00,0.00,0.00,'2023-02-03 08:35:59','',''),(128,'8','215','1',1,'Sale Id shift 42',0.00,0.00,0.00,2004.90,0.00,'2023-02-04 14:14:53','',''),(129,'8','215',NULL,1,'Sale Id shift 42',691690.50,0.00,0.00,0.00,0.00,'2023-02-04 14:14:53','',''),(130,'8','215','1',1,'Sale Id shift 43',0.00,0.00,0.00,1983.22,0.00,'2023-02-05 08:54:29','',''),(131,'8','215',NULL,1,'Sale Id shift 43',684210.90,0.00,0.00,0.00,0.00,'2023-02-05 08:54:29','',''),(132,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5692500.00,16500.00,0.00,0.00,'2023-02-05 18:57:06','',''),(133,'8','215',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,16500.00,0.00,'2023-02-05 19:53:31','',''),(134,'8','215','1',1,'Received from bridging 9',0.00,0.00,16500.00,0.00,0.00,'2023-02-05 19:53:31','',''),(135,'8','215','1',1,'Sale Id shift 44',0.00,0.00,0.00,4241.18,0.00,'2023-02-06 08:50:08','',''),(136,'8','215',NULL,1,'Sale Id shift 44',1463207.10,0.00,0.00,0.00,0.00,'2023-02-06 08:50:08','',''),(137,'8','215','1',1,'Sale Id shift 45',0.00,0.00,0.00,4148.70,0.00,'2023-02-07 16:56:13','',''),(138,'8','215',NULL,1,'Sale Id shift 45',1431301.50,0.00,0.00,0.00,0.00,'2023-02-07 16:56:13','',''),(139,'8','215','1',1,'Sale Id shift 46',0.00,0.00,0.00,3491.04,0.00,'2023-02-08 13:18:27','',''),(140,'8','215',NULL,1,'Sale Id shift 46',1204408.80,0.00,0.00,0.00,0.00,'2023-02-08 13:18:27','',''),(141,'8','215','1',1,'Sale Id shift 47',0.00,0.00,0.00,4187.32,0.00,'2023-02-09 13:13:45','',''),(142,'8','215',NULL,1,'Sale Id shift 47',1444625.40,0.00,0.00,0.00,0.00,'2023-02-09 13:13:45','',''),(143,'8','215','1',1,'Sale Id shift 48',0.00,0.00,0.00,2700.61,0.00,'2023-02-10 10:20:07','',''),(144,'8','215',NULL,1,'Sale Id shift 48',931710.45,0.00,0.00,0.00,0.00,'2023-02-10 10:20:07','',''),(145,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5140500.00,14900.00,0.00,0.00,'2023-02-11 06:24:04','',''),(146,'8','215',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,14900.00,0.00,'2023-02-11 18:23:42','',''),(147,'8','215','1',1,'Received from bridging 10',0.00,0.00,14900.00,0.00,0.00,'2023-02-11 18:23:42','',''),(148,'8','215','1',1,'Sale Id shift 49',0.00,0.00,0.00,5793.91,0.00,'2023-02-12 08:59:17','',''),(149,'8','215',NULL,1,'Sale Id shift 49',1998898.95,0.00,0.00,0.00,0.00,'2023-02-12 08:59:17','',''),(150,'8','215','1',1,'Sale Id shift 50',0.00,0.00,0.00,7253.68,0.00,'2023-02-13 12:20:03','',''),(151,'8','215',NULL,1,'Sale Id shift 50',2502519.60,0.00,0.00,0.00,0.00,'2023-02-13 12:20:03','',''),(152,'8','215','1',1,'Sale Id shift 51',0.00,0.00,0.00,1886.94,0.00,'2023-02-14 08:51:20','',''),(153,'8','215',NULL,1,'Sale Id shift 51',650994.30,0.00,0.00,0.00,0.00,'2023-02-14 08:51:20','',''),(154,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,11424000.00,33600.00,0.00,0.00,'2023-02-19 18:47:59','',''),(155,'8','215',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,33600.00,0.00,'2023-02-20 10:07:20','',''),(156,'8','215','1',1,'Received from bridging 11',0.00,0.00,33600.00,0.00,0.00,'2023-02-20 10:07:20','',''),(157,'8','215','1',1,'Sale Id shift 52',0.00,0.00,0.00,2357.92,0.00,'2023-02-20 10:10:58','',''),(158,'8','215',NULL,1,'Sale Id shift 52',801692.80,0.00,0.00,0.00,0.00,'2023-02-20 10:10:58','',''),(159,'8','215','1',1,'Sale Id shift 53',0.00,0.00,0.00,3878.99,0.00,'2023-02-20 10:17:19','',''),(160,'8','215',NULL,1,'Sale Id shift 53',1318856.60,0.00,0.00,0.00,0.00,'2023-02-20 10:17:19','',''),(161,'8','215','1',1,'Sale Id shift 54',0.00,0.00,0.00,2731.23,0.00,'2023-02-21 08:23:06','',''),(162,'8','215',NULL,1,'Sale Id shift 54',928618.20,0.00,0.00,0.00,0.00,'2023-02-21 08:23:06','',''),(163,'8','215','1',1,'Sale Id shift 55',0.00,0.00,0.00,2159.88,0.00,'2023-02-22 12:28:58','',''),(164,'8','215',NULL,1,'Sale Id shift 55',734359.20,0.00,0.00,0.00,0.00,'2023-02-22 12:28:58','',''),(165,'8','215','1',1,'Sale Id shift 56',0.00,0.00,0.00,2587.23,0.00,'2023-02-23 08:38:57','',''),(166,'8','215',NULL,1,'Sale Id shift 56',827913.60,0.00,0.00,0.00,0.00,'2023-02-23 08:38:57','',''),(167,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5392000.00,16850.00,0.00,0.00,'2023-02-23 09:52:59','',''),(168,'8','215',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,16850.00,0.00,'2023-02-24 08:11:15','',''),(169,'8','215','1',1,'Received from bridging 12',0.00,0.00,16850.00,0.00,0.00,'2023-02-24 08:11:15','',''),(170,'8','215','1',1,'Sale Id shift 57',0.00,0.00,0.00,3026.28,0.00,'2023-02-24 08:14:35','',''),(171,'8','215',NULL,1,'Sale Id shift 57',968409.60,0.00,0.00,0.00,0.00,'2023-02-24 08:14:35','',''),(172,'8','215','1',1,'Sale Id shift 58',0.00,0.00,0.00,2198.68,0.00,'2023-02-26 22:31:52','',''),(173,'8','215',NULL,1,'Sale Id shift 58',703577.60,0.00,0.00,0.00,0.00,'2023-02-26 22:31:52','',''),(174,'8','215','1',1,'Sale Id shift 59',0.00,0.00,0.00,5995.35,0.00,'2023-02-27 10:23:10','',''),(175,'8','215',NULL,1,'Sale Id shift 59',1918512.00,0.00,0.00,0.00,0.00,'2023-02-27 10:23:10','',''),(176,'8','215','1',1,'Sale Id shift 60',0.00,0.00,0.00,2659.40,0.00,'2023-02-28 10:18:50','',''),(177,'8','215',NULL,1,'Sale Id shift 60',851008.00,0.00,0.00,0.00,0.00,'2023-02-28 10:18:50','',''),(178,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,5808000.00,18150.00,0.00,0.00,'2023-02-28 12:14:35','',''),(179,'8','215',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,18150.00,0.00,'2023-02-28 22:47:34','',''),(180,'8','215','1',1,'Received from bridging 13',0.00,0.00,18150.00,0.00,0.00,'2023-02-28 22:47:34','',''),(181,'8','215','1',1,'Sale Id shift 61',0.00,0.00,0.00,2652.26,0.00,'2023-03-01 11:39:04','',''),(182,'8','215',NULL,1,'Sale Id shift 61',848723.20,0.00,0.00,0.00,0.00,'2023-03-01 11:39:04','',''),(183,'8','215','1',1,'Sale Id shift 62',0.00,0.00,0.00,2285.37,0.00,'2023-03-02 11:28:42','',''),(184,'8','215',NULL,1,'Sale Id shift 62',731318.40,0.00,0.00,0.00,0.00,'2023-03-02 11:28:42','',''),(185,'8','215','1',1,'Sale Id shift 63',0.00,0.00,0.00,2427.53,0.00,'2023-03-04 08:46:56','',''),(186,'8','215',NULL,1,'Sale Id shift 63',776809.60,0.00,0.00,0.00,0.00,'2023-03-04 08:46:56','',''),(187,'8','215','1',1,'Sale Id shift 64',0.00,0.00,0.00,2711.71,0.00,'2023-03-04 08:54:31','',''),(188,'8','215',NULL,1,'Sale Id shift 64',813513.00,0.00,0.00,0.00,0.00,'2023-03-04 08:54:31','',''),(189,'8','215','1',1,'Sale Id shift 65',0.00,0.00,0.00,3033.99,0.00,'2023-03-06 08:55:10','',''),(190,'8','215',NULL,1,'Sale Id shift 65',910197.00,0.00,0.00,0.00,0.00,'2023-03-06 08:55:10','',''),(191,'8','215','1',1,'Sale Id shift 66',0.00,0.00,0.00,3614.10,0.00,'2023-03-06 08:59:16','',''),(192,'8','215','1',1,'Sale Id shift 66',0.00,0.00,0.00,1376.58,0.00,'2023-03-06 08:59:16','',''),(193,'8','215',NULL,1,'Sale Id shift 66',1497204.00,0.00,0.00,0.00,0.00,'2023-03-06 08:59:16','',''),(194,'8','215','1',1,'Sale Id shift 67',0.00,0.00,0.00,3683.84,0.00,'2023-03-08 08:55:25','',''),(195,'8','215',NULL,1,'Sale Id shift 67',1105152.00,0.00,0.00,0.00,0.00,'2023-03-08 08:55:25','',''),(196,'8','215','1',1,'Sale Id shift 68',0.00,0.00,0.00,2657.52,0.00,'2023-03-08 09:12:27','',''),(197,'8','215',NULL,1,'Sale Id shift 68',797256.00,0.00,0.00,0.00,0.00,'2023-03-08 09:12:27','',''),(198,'8','215','1',1,'Sale Id shift 69',0.00,0.00,0.00,3481.34,0.00,'2023-03-09 10:06:43','',''),(199,'8','215',NULL,1,'Sale Id shift 69',1044402.00,0.00,0.00,0.00,0.00,'2023-03-09 10:06:43','',''),(200,'8','215','1',1,'Sale Id shift 70',0.00,0.00,0.00,4376.90,0.00,'2023-03-10 09:19:38','',''),(201,'8','215',NULL,1,'Sale Id shift 70',1313070.00,0.00,0.00,0.00,0.00,'2023-03-10 09:19:38','',''),(202,'8','215','1',1,'Sale Id shift 71',0.00,0.00,0.00,2985.53,0.00,'2023-03-11 08:38:20','',''),(203,'8','215',NULL,1,'Sale Id shift 71',895659.00,0.00,0.00,0.00,0.00,'2023-03-11 08:38:20','',''),(204,'8','215','1',1,'Sale Id shift 72',0.00,0.00,0.00,2182.68,0.00,'2023-03-12 13:00:44','',''),(205,'8','215',NULL,1,'Sale Id shift 72',654804.00,0.00,0.00,0.00,0.00,'2023-03-12 13:00:44','',''),(206,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,9960000.00,33200.00,0.00,0.00,'2023-03-12 13:22:05','',''),(207,'8','215',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,33200.00,0.00,'2023-03-13 09:16:17','',''),(208,'8','215','1',1,'Received from bridging 14',0.00,0.00,33200.00,0.00,0.00,'2023-03-13 09:16:17','',''),(209,'8','215','1',1,'Sale Id shift 73',0.00,0.00,0.00,5955.95,0.00,'2023-03-13 09:28:07','',''),(210,'8','215',NULL,1,'Sale Id shift 73',1786785.00,0.00,0.00,0.00,0.00,'2023-03-13 09:28:07','',''),(211,'8','215','1',1,'Sale Id shift 74',0.00,0.00,0.00,5089.99,0.00,'2023-03-14 08:38:02','',''),(212,'8','215',NULL,1,'Sale Id shift 74',1526997.00,0.00,0.00,0.00,0.00,'2023-03-14 08:38:02','',''),(213,'8','215','1',1,'Sale Id shift 75',0.00,0.00,0.00,4710.77,0.00,'2023-03-15 09:15:06','',''),(214,'8','215',NULL,1,'Sale Id shift 75',1413231.00,0.00,0.00,0.00,0.00,'2023-03-15 09:15:06','',''),(215,'8','215','1',1,'Sale Id shift 76',0.00,0.00,0.00,4664.94,0.00,'2023-03-16 08:29:46','',''),(216,'8','215',NULL,1,'Sale Id shift 76',1399482.00,0.00,0.00,0.00,0.00,'2023-03-16 08:29:46','',''),(217,'8','215',NULL,1,'Purchased from Lausu Energy Resources',0.00,4500000.00,15000.00,0.00,0.00,'2023-03-16 15:01:23','',''),(218,'8','215',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,15000.00,0.00,'2023-03-16 19:46:21','',''),(219,'8','215','1',1,'Received from bridging 15',0.00,0.00,15000.00,0.00,0.00,'2023-03-16 19:46:21','',''),(220,'8','215','1',1,'Sale Id shift 77',0.00,0.00,0.00,4092.22,0.00,'2023-03-17 08:08:02','',''),(221,'8','215',NULL,1,'Sale Id shift 77',1227666.00,0.00,0.00,0.00,0.00,'2023-03-17 08:08:02','',''),(222,'8','215','1',1,'Sale Id shift 78',0.00,0.00,0.00,4731.21,0.00,'2023-03-20 07:55:54','',''),(223,'8','215',NULL,1,'Sale Id shift 78',1419363.00,0.00,0.00,0.00,0.00,'2023-03-20 07:55:54','',''),(224,'8','215','1',1,'Sale Id shift 79',0.00,0.00,0.00,7319.98,0.00,'2023-03-20 10:50:19','',''),(225,'8','215',NULL,1,'Sale Id shift 79',2195994.00,0.00,0.00,0.00,0.00,'2023-03-20 10:50:19','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'8','215',1,22848.49,'2023-03-20 10:50:19');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'8','215',1,'Sale Id shift 1',0.00,809634.70,305.00,809634.70,0.00,'2022-12-17 11:48:25'),(2,'8','215',1,'Sale Id shift 2',0.00,919029.10,310.00,919029.10,0.00,'2022-12-18 13:43:26'),(3,'8','215',1,'Sale Id shift 3',0.00,1579639.10,310.00,1579639.10,0.00,'2022-12-19 15:31:21'),(4,'8','215',1,'Sale Id shift 4',0.00,1315497.40,310.00,1315497.40,0.00,'2022-12-20 09:37:10'),(5,'8','215',1,'Sale Id shift 5',0.00,1041547.30,310.00,1041547.30,0.00,'2022-12-21 14:21:14'),(6,'8','215',1,'Sale Id shift 6',0.00,316054.30,310.00,316054.30,0.00,'2022-12-25 16:21:23'),(7,'8','215',1,'Sale Id shift 7',0.00,995847.10,310.00,995847.10,0.00,'2022-12-25 16:27:30'),(8,'8','215',1,'Sale Id shift 8',0.00,1161427.40,310.00,1161427.40,0.00,'2022-12-26 08:35:46'),(9,'8','215',1,'Sale Id shift 9',0.00,767253.10,310.00,767253.10,0.00,'2022-12-27 09:27:17'),(10,'8','215',1,'Sale Id shift 10',0.00,585528.00,310.00,585528.00,0.00,'2022-12-28 08:31:54'),(11,'8','215',1,'Sale Id shift 11',0.00,539545.70,310.00,539545.70,0.00,'2022-12-29 08:22:19'),(12,'8','215',1,'Sale Id shift 12',0.00,596985.60,310.00,596985.60,0.00,'2022-12-30 09:45:36'),(13,'8','215',1,'Sale Id shift 13',0.00,1170801.00,300.00,1170801.00,0.00,'2023-01-02 08:17:02'),(14,'8','215',1,'Sale Id shift 14',0.00,601539.00,300.00,601539.00,0.00,'2023-01-03 08:21:50'),(15,'8','215',1,'Sale Id shift 15',0.00,739491.00,300.00,739491.00,0.00,'2023-01-04 08:50:25'),(16,'8','215',1,'Sale Id shift 16',0.00,695388.00,300.00,695388.00,0.00,'2023-01-05 09:09:23'),(17,'8','215',1,'Sale Id shift 17',0.00,630939.00,300.00,630939.00,0.00,'2023-01-06 09:27:06'),(18,'8','215',1,'Sale Id shift 18',0.00,547395.00,300.00,547395.00,0.00,'2023-01-07 08:26:03'),(19,'8','215',1,'Sale Id shift 19',0.00,437331.00,300.00,437331.00,0.00,'2023-01-08 09:08:24'),(20,'8','215',1,'Sale Id shift 20',0.00,1275075.00,300.00,1275075.00,0.00,'2023-01-09 09:33:10'),(21,'8','215',1,'Sale Id shift 21',0.00,640035.00,300.00,640035.00,0.00,'2023-01-10 08:14:35'),(22,'8','215',1,'Sale Id shift 22',0.00,538485.00,300.00,538485.00,0.00,'2023-01-11 10:08:22'),(23,'8','215',1,'Sale Id shift 23',0.00,443241.00,300.00,443241.00,0.00,'2023-01-12 08:42:26'),(24,'8','215',1,'Sale Id shift 24',0.00,554151.00,300.00,554151.00,0.00,'2023-01-13 08:53:04'),(25,'8','215',1,'Sale Id shift 25',0.00,1352460.00,300.00,1352460.00,0.00,'2023-01-14 09:19:12'),(26,'8','215',1,'Sale Id shift 26',0.00,1127547.00,300.00,1127547.00,0.00,'2023-01-15 08:57:08'),(27,'8','215',1,'Sale Id shift 27',0.00,2402016.00,300.00,2402016.00,0.00,'2023-01-16 09:13:10'),(28,'8','215',1,'Sale Id shift 28',0.00,959616.00,300.00,959616.00,0.00,'2023-01-17 09:03:47'),(29,'8','215',1,'Sale Id shift 29',0.00,968238.00,300.00,968238.00,0.00,'2023-01-18 08:11:43'),(30,'8','215',1,'Sale Id shift 30',0.00,1110249.00,300.00,1110249.00,0.00,'2023-01-19 09:03:02'),(31,'8','215',1,'Sale Id shift 31',0.00,967941.00,300.00,967941.00,0.00,'2023-01-20 16:35:49'),(32,'8','215',1,'Sale Id shift 32',0.00,1154004.00,300.00,1154004.00,0.00,'2023-01-21 09:13:26'),(33,'8','215',1,'Sale Id shift 33',0.00,1437135.00,300.00,1437135.00,0.00,'2023-01-22 08:49:18'),(34,'8','215',1,'Sale Id shift 34',0.00,862467.00,300.00,862467.00,0.00,'2023-01-23 12:17:00'),(35,'8','215',1,'Sale Id shift 35',0.00,1612458.80,310.00,1612458.80,0.00,'2023-01-23 12:26:14'),(36,'8','215',1,'Sale Id shift 36',0.00,1504123.10,310.00,1504123.10,0.00,'2023-01-24 14:40:09'),(37,'8','215',1,'Sale Id shift 37',0.00,1392160.40,310.00,1392160.40,0.00,'2023-01-26 13:49:44'),(38,'8','215',1,'Sale Id shift 38',0.00,1094450.76,338.00,1094450.76,0.00,'2023-01-31 10:26:06'),(39,'8','215',1,'Sale Id shift 39',0.00,680654.26,338.00,680654.26,0.00,'2023-02-01 08:37:54'),(40,'8','215',1,'Sale Id shift 40',0.00,944679.00,345.00,944679.00,0.00,'2023-02-02 12:26:34'),(41,'8','215',1,'Sale Id shift 41',0.00,1007803.65,345.00,1007803.65,0.00,'2023-02-03 08:35:59'),(42,'8','215',1,'Sale Id shift 42',0.00,691690.50,345.00,691690.50,0.00,'2023-02-04 14:14:53'),(43,'8','215',1,'Sale Id shift 43',0.00,684210.90,345.00,684210.90,0.00,'2023-02-05 08:54:29'),(44,'8','215',1,'Sale Id shift 44',0.00,1463207.10,345.00,1463207.10,0.00,'2023-02-06 08:50:08'),(45,'8','215',1,'Sale Id shift 45',0.00,1431301.50,345.00,1431301.50,0.00,'2023-02-07 16:56:13'),(46,'8','215',1,'Sale Id shift 46',0.00,1204408.80,345.00,1204408.80,0.00,'2023-02-08 13:18:27'),(47,'8','215',1,'Sale Id shift 47',0.00,1444625.40,345.00,1444625.40,0.00,'2023-02-09 13:13:45'),(48,'8','215',1,'Sale Id shift 48',0.00,931710.45,345.00,931710.45,0.00,'2023-02-10 10:20:07'),(49,'8','215',1,'Sale Id shift 49',0.00,1998898.95,345.00,1998898.95,0.00,'2023-02-12 08:59:17'),(50,'8','215',1,'Sale Id shift 50',0.00,2502519.60,345.00,2502519.60,0.00,'2023-02-13 12:20:03'),(51,'8','215',1,'Sale Id shift 51',0.00,650994.30,345.00,650994.30,0.00,'2023-02-14 08:51:20'),(52,'8','215',1,'Sale Id shift 52',0.00,801692.80,340.00,801692.80,0.00,'2023-02-20 10:10:58'),(53,'8','215',1,'Sale Id shift 53',0.00,1318856.60,340.00,1318856.60,0.00,'2023-02-20 10:17:19'),(54,'8','215',1,'Sale Id shift 54',0.00,928618.20,340.00,928618.20,0.00,'2023-02-21 08:23:06'),(55,'8','215',1,'Sale Id shift 55',0.00,734359.20,340.00,734359.20,0.00,'2023-02-22 12:28:58'),(56,'8','215',1,'Sale Id shift 56',0.00,827913.60,320.00,827913.60,0.00,'2023-02-23 08:38:57'),(57,'8','215',1,'Sale Id shift 57',0.00,968409.60,320.00,968409.60,0.00,'2023-02-24 08:14:35'),(58,'8','215',1,'Sale Id shift 58',0.00,703577.60,320.00,703577.60,0.00,'2023-02-26 22:31:52'),(59,'8','215',1,'Sale Id shift 59',0.00,1918512.00,320.00,1918512.00,0.00,'2023-02-27 10:23:10'),(60,'8','215',1,'Sale Id shift 60',0.00,851008.00,320.00,851008.00,0.00,'2023-02-28 10:18:50'),(61,'8','215',1,'Sale Id shift 61',0.00,848723.20,320.00,848723.20,0.00,'2023-03-01 11:39:04'),(62,'8','215',1,'Sale Id shift 62',0.00,731318.40,320.00,731318.40,0.00,'2023-03-02 11:28:42'),(63,'8','215',1,'Sale Id shift 63',0.00,776809.60,320.00,776809.60,0.00,'2023-03-04 08:46:56'),(64,'8','215',1,'Sale Id shift 64',0.00,813513.00,300.00,813513.00,0.00,'2023-03-04 08:54:31'),(65,'8','215',1,'Sale Id shift 65',0.00,910197.00,300.00,910197.00,0.00,'2023-03-06 08:55:10'),(66,'8','215',1,'Sale Id shift 66',0.00,1497204.00,300.00,1497204.00,0.00,'2023-03-06 08:59:16'),(67,'8','215',1,'Sale Id shift 67',0.00,1105152.00,300.00,1105152.00,0.00,'2023-03-08 08:55:25'),(68,'8','215',1,'Sale Id shift 68',0.00,797256.00,300.00,797256.00,0.00,'2023-03-08 09:12:27'),(69,'8','215',1,'Sale Id shift 69',0.00,1044402.00,300.00,1044402.00,0.00,'2023-03-09 10:06:43'),(70,'8','215',1,'Sale Id shift 70',0.00,1313070.00,300.00,1313070.00,0.00,'2023-03-10 09:19:38'),(71,'8','215',1,'Sale Id shift 71',0.00,895659.00,300.00,895659.00,0.00,'2023-03-11 08:38:20'),(72,'8','215',1,'Sale Id shift 72',0.00,654804.00,300.00,654804.00,0.00,'2023-03-12 13:00:44'),(73,'8','215',1,'Sale Id shift 73',0.00,1786785.00,300.00,1786785.00,0.00,'2023-03-13 09:28:07'),(74,'8','215',1,'Sale Id shift 74',0.00,1526997.00,300.00,1526997.00,0.00,'2023-03-14 08:38:02'),(75,'8','215',1,'Sale Id shift 75',0.00,1413231.00,300.00,1413231.00,0.00,'2023-03-15 09:15:06'),(76,'8','215',1,'Sale Id shift 76',0.00,1399482.00,300.00,1399482.00,0.00,'2023-03-16 08:29:46'),(77,'8','215',1,'Sale Id shift 77',0.00,1227666.00,300.00,1227666.00,0.00,'2023-03-17 08:08:02'),(78,'8','215',1,'Sale Id shift 78',0.00,1419363.00,300.00,1419363.00,0.00,'2023-03-20 07:55:54'),(79,'8','215',1,'Sale Id shift 79',0.00,2195994.00,300.00,2195994.00,0.00,'2023-03-20 10:50:19');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=352 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('8','215',1,'','24','5',0.00,854000.00,'Purchase Id 1 for 2,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-17 07:28:48','',''),('8','215',2,'','supplier','1',854000.00,0.00,'Purchase Id 1 for 2,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-17 07:28:48','',''),('8','215',3,'','24','5',0.00,5185000.00,'Purchase Id 2 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-17 07:29:02','',''),('8','215',4,'','supplier','1',5185000.00,0.00,'Purchase Id 2 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-17 07:29:02','',''),('8','215',5,'','20','2',809634.70,0.00,'Sales from shift 1 on 2022-12-17 11:48:25 ','2022-12-17 11:48:25','',''),('8','215',6,'','6.1','3',0.00,809634.70,'Sales from shift 1 on 2022-12-17 11:48:25 ','2022-12-17 11:48:25','',''),('8','215',7,'','20','2',919029.10,0.00,'Sales from shift 2 on 2022-12-18 13:43:26 ','2022-12-18 13:43:26','',''),('8','215',8,'','6.1','3',0.00,919029.10,'Sales from shift 2 on 2022-12-18 13:43:26 ','2022-12-18 13:43:26','',''),('8','215',9,'','20','2',1579639.10,0.00,'Sales from shift 3 on 2022-12-19 15:31:21 ','2022-12-19 15:31:21','',''),('8','215',10,'','6.1','3',0.00,1579639.10,'Sales from shift 3 on 2022-12-19 15:31:21 ','2022-12-19 15:31:21','',''),('8','215',11,'','20','2',1315497.40,0.00,'Sales from shift 4 on 2022-12-20 09:37:10 ','2022-12-20 09:37:10','',''),('8','215',12,'','6.1','3',0.00,1315497.40,'Sales from shift 4 on 2022-12-20 09:37:10 ','2022-12-20 09:37:10','',''),('8','215',13,'','2','7',1579640.00,0.00,'Payment Id 3 for invoice:3, receipt: 003 by Lausu Energy Resources','2022-12-20 13:43:09','',''),('8','215',14,'','supplier','1',0.00,1579640.00,'Payment Id 3 for invoice:3, receipt: 003 by Lausu Energy Resources','2022-12-20 13:43:09','',''),('8','215',15,'','2','7',919030.00,0.00,'Payment Id 2 for invoice:2, receipt: 002 by Lausu Energy Resources','2022-12-20 13:43:09','',''),('8','215',16,'','supplier','1',0.00,919030.00,'Payment Id 2 for invoice:2, receipt: 002 by Lausu Energy Resources','2022-12-20 13:43:09','',''),('8','215',17,'','2','7',809635.00,0.00,'Payment Id 1 for invoice:1, receipt: 001 by Lausu Energy Resources','2022-12-20 13:43:09','',''),('8','215',18,'','supplier','1',0.00,809635.00,'Payment Id 1 for invoice:1, receipt: 001 by Lausu Energy Resources','2022-12-20 13:43:09','',''),('8','215',19,'','20','2',1041547.30,0.00,'Sales from shift 5 on 2022-12-21 14:21:14 ','2022-12-21 14:21:14','',''),('8','215',20,'','6.1','3',0.00,1041547.30,'Sales from shift 5 on 2022-12-21 14:21:14 ','2022-12-21 14:21:14','',''),('8','215',21,'','24','5',0.00,5022000.00,'Purchase Id 3 for 16,200.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-23 15:52:28','',''),('8','215',22,'','supplier','1',5022000.00,0.00,'Purchase Id 3 for 16,200.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-23 15:52:28','',''),('8','215',23,'','2','7',1315500.00,0.00,'Payment Id 4 for invoice:4, receipt: 004 by Lausu Energy Resources','2022-12-25 14:26:49','',''),('8','215',24,'','supplier','1',0.00,1315500.00,'Payment Id 4 for invoice:4, receipt: 004 by Lausu Energy Resources','2022-12-25 14:26:49','',''),('8','215',25,'','20','2',316054.30,0.00,'Sales from shift 6 on 2022-12-25 16:21:23 ','2022-12-25 16:21:23','',''),('8','215',26,'','6.1','3',0.00,316054.30,'Sales from shift 6 on 2022-12-25 16:21:23 ','2022-12-25 16:21:23','',''),('8','215',27,'','20','2',995847.10,0.00,'Sales from shift 7 on 2022-12-25 16:27:30 ','2022-12-25 16:27:30','',''),('8','215',28,'','6.1','3',0.00,995847.10,'Sales from shift 7 on 2022-12-25 16:27:30 ','2022-12-25 16:27:30','',''),('8','215',29,'','20','2',1161427.40,0.00,'Sales from shift 8 on 2022-12-26 08:35:46 ','2022-12-26 08:35:46','',''),('8','215',30,'','6.1','3',0.00,1161427.40,'Sales from shift 8 on 2022-12-26 08:35:46 ','2022-12-26 08:35:46','',''),('8','215',31,'','20','2',767253.10,0.00,'Sales from shift 9 on 2022-12-27 09:27:17 ','2022-12-27 09:27:17','',''),('8','215',32,'','6.1','3',0.00,767253.10,'Sales from shift 9 on 2022-12-27 09:27:17 ','2022-12-27 09:27:17','',''),('8','215',33,'','20','2',585528.00,0.00,'Sales from shift 10 on 2022-12-28 08:31:54 ','2022-12-28 08:31:54','',''),('8','215',34,'','6.1','3',0.00,585528.00,'Sales from shift 10 on 2022-12-28 08:31:54 ','2022-12-28 08:31:54','',''),('8','215',35,'','20','2',539545.70,0.00,'Sales from shift 11 on 2022-12-29 08:22:19 ','2022-12-29 08:22:19','',''),('8','215',36,'','6.1','3',0.00,539545.70,'Sales from shift 11 on 2022-12-29 08:22:19 ','2022-12-29 08:22:19','',''),('8','215',37,'','2','7',585530.00,0.00,'Payment Id 10 for invoice:10, receipt: 010 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',38,'','supplier','1',0.00,585530.00,'Payment Id 10 for invoice:10, receipt: 010 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',39,'','2','7',767255.00,0.00,'Payment Id 9 for invoice:9, receipt: 009 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',40,'','supplier','1',0.00,767255.00,'Payment Id 9 for invoice:9, receipt: 009 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',41,'','2','7',1161430.00,0.00,'Payment Id 8 for invoice:8, receipt: 008 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',42,'','supplier','1',0.00,1161430.00,'Payment Id 8 for invoice:8, receipt: 008 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',43,'','2','7',995850.00,0.00,'Payment Id 7 for invoice:7, receipt: 007 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',44,'','supplier','1',0.00,995850.00,'Payment Id 7 for invoice:7, receipt: 007 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',45,'','2','7',316055.00,0.00,'Payment Id 6 for invoice:6, receipt: 006 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',46,'','supplier','1',0.00,316055.00,'Payment Id 6 for invoice:6, receipt: 006 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',47,'','2','7',1041550.00,0.00,'Payment Id 5 for invoice:5, receipt: 005 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',48,'','supplier','1',0.00,1041550.00,'Payment Id 5 for invoice:5, receipt: 005 by Lausu Energy Resources','2022-12-29 13:21:35','',''),('8','215',49,'','20','2',596985.60,0.00,'Sales from shift 12 on 2022-12-30 09:45:36 ','2022-12-30 09:45:36','',''),('8','215',50,'','6.1','3',0.00,596985.60,'Sales from shift 12 on 2022-12-30 09:45:36 ','2022-12-30 09:45:36','',''),('8','215',51,'','24','5',0.00,5040000.00,'Purchase Id 4 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-01 12:09:36','',''),('8','215',52,'','supplier','1',5040000.00,0.00,'Purchase Id 4 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-01 12:09:36','',''),('8','215',53,'','20','2',1170801.00,0.00,'Sales from shift 13 on 2023-01-02 08:17:02 ','2023-01-02 08:17:02','',''),('8','215',54,'','6.1','3',0.00,1170801.00,'Sales from shift 13 on 2023-01-02 08:17:02 ','2023-01-02 08:17:02','',''),('8','215',55,'','2','7',596985.00,0.00,'Payment Id 12 for invoice:12, receipt: 012 by Lausu Energy Resources','2023-01-02 17:09:05','',''),('8','215',56,'','supplier','1',0.00,596985.00,'Payment Id 12 for invoice:12, receipt: 012 by Lausu Energy Resources','2023-01-02 17:09:05','',''),('8','215',57,'','20','2',601539.00,0.00,'Sales from shift 14 on 2023-01-03 08:21:50 ','2023-01-03 08:21:50','',''),('8','215',58,'','6.1','3',0.00,601539.00,'Sales from shift 14 on 2023-01-03 08:21:50 ','2023-01-03 08:21:50','',''),('8','215',59,'','2','7',1170800.00,0.00,'Payment Id 13 for invoice:13, receipt: 013 by Lausu Energy Resources','2023-01-03 17:18:04','',''),('8','215',60,'','supplier','1',0.00,1170800.00,'Payment Id 13 for invoice:13, receipt: 013 by Lausu Energy Resources','2023-01-03 17:18:04','',''),('8','215',61,'','2','7',539545.00,0.00,'Payment Id 11 for invoice:11, receipt: 011 by Lausu Energy Resources','2023-01-03 17:18:04','',''),('8','215',62,'','supplier','1',0.00,539545.00,'Payment Id 11 for invoice:11, receipt: 011 by Lausu Energy Resources','2023-01-03 17:18:04','',''),('8','215',63,'','20','2',739491.00,0.00,'Sales from shift 15 on 2023-01-04 08:50:25 ','2023-01-04 08:50:25','',''),('8','215',64,'','6.1','3',0.00,739491.00,'Sales from shift 15 on 2023-01-04 08:50:25 ','2023-01-04 08:50:25','',''),('8','215',65,'','20','2',695388.00,0.00,'Sales from shift 16 on 2023-01-05 09:09:23 ','2023-01-05 09:09:23','',''),('8','215',66,'','6.1','3',0.00,695388.00,'Sales from shift 16 on 2023-01-05 09:09:23 ','2023-01-05 09:09:23','',''),('8','215',67,'','20','2',630939.00,0.00,'Sales from shift 17 on 2023-01-06 09:27:06 ','2023-01-06 09:27:06','',''),('8','215',68,'','6.1','3',0.00,630939.00,'Sales from shift 17 on 2023-01-06 09:27:06 ','2023-01-06 09:27:06','',''),('8','215',69,'','24','5',0.00,9780000.00,'Purchase Id 5 for 32,600.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-06 09:41:46','',''),('8','215',70,'','supplier','1',9780000.00,0.00,'Purchase Id 5 for 32,600.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-06 09:41:46','',''),('8','215',71,'','20','2',547395.00,0.00,'Sales from shift 18 on 2023-01-07 08:26:03 ','2023-01-07 08:26:03','',''),('8','215',72,'','6.1','3',0.00,547395.00,'Sales from shift 18 on 2023-01-07 08:26:03 ','2023-01-07 08:26:03','',''),('8','215',73,'','20','2',437331.00,0.00,'Sales from shift 19 on 2023-01-08 09:08:24 ','2023-01-08 09:08:24','',''),('8','215',74,'','6.1','3',0.00,437331.00,'Sales from shift 19 on 2023-01-08 09:08:24 ','2023-01-08 09:08:24','',''),('8','215',75,'','20','2',1275075.00,0.00,'Sales from shift 20 on 2023-01-09 09:33:10 ','2023-01-09 09:33:10','',''),('8','215',76,'','6.1','3',0.00,1275075.00,'Sales from shift 20 on 2023-01-09 09:33:10 ','2023-01-09 09:33:10','',''),('8','215',77,'','2','7',1275075.00,0.00,'Payment Id 20 for invoice:20, receipt: 020 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',78,'','supplier','1',0.00,1275075.00,'Payment Id 20 for invoice:20, receipt: 020 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',79,'','2','7',437330.00,0.00,'Payment Id 19 for invoice:19, receipt: 019 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',80,'','supplier','1',0.00,437330.00,'Payment Id 19 for invoice:19, receipt: 019 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',81,'','2','7',547395.00,0.00,'Payment Id 18 for invoice:18, receipt: 018 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',82,'','supplier','1',0.00,547395.00,'Payment Id 18 for invoice:18, receipt: 018 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',83,'','2','7',630940.00,0.00,'Payment Id 17 for invoice:17, receipt: 017 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',84,'','supplier','1',0.00,630940.00,'Payment Id 17 for invoice:17, receipt: 017 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',85,'','2','7',695390.00,0.00,'Payment Id 16 for invoice:16, receipt: 016 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',86,'','supplier','1',0.00,695390.00,'Payment Id 16 for invoice:16, receipt: 016 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',87,'','2','7',739490.00,0.00,'Payment Id 15 for invoice:15, receipt: 015 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',88,'','supplier','1',0.00,739490.00,'Payment Id 15 for invoice:15, receipt: 015 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',89,'','2','7',601540.00,0.00,'Payment Id 14 for invoice:14, receipt: 014 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',90,'','supplier','1',0.00,601540.00,'Payment Id 14 for invoice:14, receipt: 014 by Lausu Energy Resources','2023-01-09 14:00:16','',''),('8','215',91,'','20','2',640035.00,0.00,'Sales from shift 21 on 2023-01-10 08:14:35 ','2023-01-10 08:14:35','',''),('8','215',92,'','6.1','3',0.00,640035.00,'Sales from shift 21 on 2023-01-10 08:14:35 ','2023-01-10 08:14:35','',''),('8','215',93,'','20','2',538485.00,0.00,'Sales from shift 22 on 2023-01-11 10:08:22 ','2023-01-11 10:08:22','',''),('8','215',94,'','6.1','3',0.00,538485.00,'Sales from shift 22 on 2023-01-11 10:08:22 ','2023-01-11 10:08:22','',''),('8','215',95,'','20','2',443241.00,0.00,'Sales from shift 23 on 2023-01-12 08:42:26 ','2023-01-12 08:42:26','',''),('8','215',96,'','6.1','3',0.00,443241.00,'Sales from shift 23 on 2023-01-12 08:42:26 ','2023-01-12 08:42:26','',''),('8','215',97,'','20','2',554151.00,0.00,'Sales from shift 24 on 2023-01-13 08:53:04 ','2023-01-13 08:53:04','',''),('8','215',98,'','6.1','3',0.00,554151.00,'Sales from shift 24 on 2023-01-13 08:53:04 ','2023-01-13 08:53:04','',''),('8','215',99,'','20','2',1352460.00,0.00,'Sales from shift 25 on 2023-01-14 09:19:12 ','2023-01-14 09:19:12','',''),('8','215',100,'','6.1','3',0.00,1352460.00,'Sales from shift 25 on 2023-01-14 09:19:12 ','2023-01-14 09:19:12','',''),('8','215',101,'','20','2',1127547.00,0.00,'Sales from shift 26 on 2023-01-15 08:57:08 ','2023-01-15 08:57:08','',''),('8','215',102,'','6.1','3',0.00,1127547.00,'Sales from shift 26 on 2023-01-15 08:57:08 ','2023-01-15 08:57:08','',''),('8','215',103,'','2','7',554150.00,0.00,'Payment Id 25 for invoice:24, receipt: 24 by Lausu Energy Resources','2023-01-15 23:07:30','',''),('8','215',104,'','supplier','1',0.00,554150.00,'Payment Id 25 for invoice:24, receipt: 24 by Lausu Energy Resources','2023-01-15 23:07:30','',''),('8','215',105,'','2','7',443240.00,0.00,'Payment Id 24 for invoice:23, receipt: 23 by Lausu Energy Resources','2023-01-15 23:07:30','',''),('8','215',106,'','supplier','1',0.00,443240.00,'Payment Id 24 for invoice:23, receipt: 23 by Lausu Energy Resources','2023-01-15 23:07:30','',''),('8','215',107,'','2','7',538485.00,0.00,'Payment Id 23 for invoice:22, receipt: 22 by Lausu Energy Resources','2023-01-15 23:07:30','',''),('8','215',108,'','supplier','1',0.00,538485.00,'Payment Id 23 for invoice:22, receipt: 22 by Lausu Energy Resources','2023-01-15 23:07:30','',''),('8','215',109,'','2','7',1275075.00,0.00,'Payment Id 21 for invoice:20, receipt: 20 by Lausu Energy Resources','2023-01-15 23:07:51','',''),('8','215',110,'','supplier','1',0.00,1275075.00,'Payment Id 21 for invoice:20, receipt: 20 by Lausu Energy Resources','2023-01-15 23:07:51','',''),('8','215',111,'','20','2',2402016.00,0.00,'Sales from shift 27 on 2023-01-16 09:13:10 ','2023-01-16 09:13:10','',''),('8','215',112,'','6.1','3',0.00,2402016.00,'Sales from shift 27 on 2023-01-16 09:13:10 ','2023-01-16 09:13:10','',''),('8','215',113,'','20','2',959616.00,0.00,'Sales from shift 28 on 2023-01-17 09:03:47 ','2023-01-17 09:03:47','',''),('8','215',114,'','6.1','3',0.00,959616.00,'Sales from shift 28 on 2023-01-17 09:03:47 ','2023-01-17 09:03:47','',''),('8','215',115,'','20','2',968238.00,0.00,'Sales from shift 29 on 2023-01-18 08:11:42 ','2023-01-18 08:11:42','',''),('8','215',116,'','6.1','3',0.00,968238.00,'Sales from shift 29 on 2023-01-18 08:11:42 ','2023-01-18 08:11:42','',''),('8','215',117,'','24','5',0.00,4785000.00,'Purchase Id 6 for 15,950.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-18 14:43:50','',''),('8','215',118,'','supplier','1',4785000.00,0.00,'Purchase Id 6 for 15,950.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-18 14:43:50','',''),('8','215',119,'','20','2',1110249.00,0.00,'Sales from shift 30 on 2023-01-19 09:03:02 ','2023-01-19 09:03:02','',''),('8','215',120,'','6.1','3',0.00,1110249.00,'Sales from shift 30 on 2023-01-19 09:03:02 ','2023-01-19 09:03:02','',''),('8','215',121,'','20','2',967941.00,0.00,'Sales from shift 31 on 2023-01-20 16:35:49 ','2023-01-20 16:35:49','',''),('8','215',122,'','6.1','3',0.00,967941.00,'Sales from shift 31 on 2023-01-20 16:35:49 ','2023-01-20 16:35:49','',''),('8','215',123,'','20','2',1154004.00,0.00,'Sales from shift 32 on 2023-01-21 09:13:26 ','2023-01-21 09:13:26','',''),('8','215',124,'','6.1','3',0.00,1154004.00,'Sales from shift 32 on 2023-01-21 09:13:26 ','2023-01-21 09:13:26','',''),('8','215',125,'','2','7',1110250.00,0.00,'Payment Id 31 for invoice:30, receipt: 30 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',126,'','supplier','1',0.00,1110250.00,'Payment Id 31 for invoice:30, receipt: 30 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',127,'','2','7',968240.00,0.00,'Payment Id 30 for invoice:29, receipt: 29 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',128,'','supplier','1',0.00,968240.00,'Payment Id 30 for invoice:29, receipt: 29 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',129,'','2','7',959615.00,0.00,'Payment Id 29 for invoice:28, receipt: 28 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',130,'','supplier','1',0.00,959615.00,'Payment Id 29 for invoice:28, receipt: 28 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',131,'','2','7',2402015.00,0.00,'Payment Id 28 for invoice:27, receipt: 27 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',132,'','supplier','1',0.00,2402015.00,'Payment Id 28 for invoice:27, receipt: 27 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',133,'','2','7',1127550.00,0.00,'Payment Id 27 for invoice:26, receipt: 26 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',134,'','supplier','1',0.00,1127550.00,'Payment Id 27 for invoice:26, receipt: 26 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',135,'','2','7',1352460.00,0.00,'Payment Id 26 for invoice:25, receipt: 25 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',136,'','supplier','1',0.00,1352460.00,'Payment Id 26 for invoice:25, receipt: 25 by Lausu Energy Resources','2023-01-21 15:13:44','',''),('8','215',137,'','2','7',967940.00,0.00,'Payment Id 32 for invoice:31, receipt: 31 by Lausu Energy Resources','2023-01-21 15:13:58','',''),('8','215',138,'','supplier','1',0.00,967940.00,'Payment Id 32 for invoice:31, receipt: 31 by Lausu Energy Resources','2023-01-21 15:13:58','',''),('8','215',139,'','2','7',640035.00,0.00,'Payment Id 22 for invoice:21, receipt: 021 by Lausu Energy Resources','2023-01-21 15:17:42','',''),('8','215',140,'','supplier','1',0.00,640035.00,'Payment Id 22 for invoice:21, receipt: 021 by Lausu Energy Resources','2023-01-21 15:17:42','',''),('8','215',141,'','20','2',1437135.00,0.00,'Sales from shift 33 on 2023-01-22 08:49:18 ','2023-01-22 08:49:18','',''),('8','215',142,'','6.1','3',0.00,1437135.00,'Sales from shift 33 on 2023-01-22 08:49:18 ','2023-01-22 08:49:18','',''),('8','215',143,'','24','5',0.00,5040000.00,'Purchase Id 7 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-22 13:22:13','',''),('8','215',144,'','supplier','1',5040000.00,0.00,'Purchase Id 7 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-22 13:22:13','',''),('8','215',145,'','20','2',862467.00,0.00,'Sales from shift 34 on 2023-01-23 12:17:00 ','2023-01-23 12:17:00','',''),('8','215',146,'','6.1','3',0.00,862467.00,'Sales from shift 34 on 2023-01-23 12:17:00 ','2023-01-23 12:17:00','',''),('8','215',147,'','20','2',1612458.80,0.00,'Sales from shift 35 on 2023-01-23 12:26:14 ','2023-01-23 12:26:14','',''),('8','215',148,'','6.1','3',0.00,1612458.80,'Sales from shift 35 on 2023-01-23 12:26:14 ','2023-01-23 12:26:14','',''),('8','215',149,'','2','7',1154005.00,0.00,'Payment Id 33 for invoice:32, receipt: 32 by Lausu Energy Resources','2023-01-23 15:37:38','',''),('8','215',150,'','supplier','1',0.00,1154005.00,'Payment Id 33 for invoice:32, receipt: 32 by Lausu Energy Resources','2023-01-23 15:37:38','',''),('8','215',151,'','20','2',1504123.10,0.00,'Sales from shift 36 on 2023-01-24 14:40:09 ','2023-01-24 14:40:09','',''),('8','215',152,'','6.1','3',0.00,1504123.10,'Sales from shift 36 on 2023-01-24 14:40:09 ','2023-01-24 14:40:09','',''),('8','215',153,'','2','7',1612460.00,0.00,'Payment Id 36 for invoice:35, receipt: 35 by Lausu Energy Resources','2023-01-24 15:41:30','',''),('8','215',154,'','supplier','1',0.00,1612460.00,'Payment Id 36 for invoice:35, receipt: 35 by Lausu Energy Resources','2023-01-24 15:41:30','',''),('8','215',155,'','2','7',862470.00,0.00,'Payment Id 35 for invoice:34, receipt: 34 by Lausu Energy Resources','2023-01-24 15:41:30','',''),('8','215',156,'','supplier','1',0.00,862470.00,'Payment Id 35 for invoice:34, receipt: 34 by Lausu Energy Resources','2023-01-24 15:41:30','',''),('8','215',157,'','20','2',1392160.40,0.00,'Sales from shift 37 on 2023-01-26 13:49:44 ','2023-01-26 13:49:44','',''),('8','215',158,'','6.1','3',0.00,1392160.40,'Sales from shift 37 on 2023-01-26 13:49:44 ','2023-01-26 13:49:44','',''),('8','215',159,'','2','7',1437135.00,0.00,'Payment Id 34 for invoice:33, receipt: 33 by Lausu Energy Resources','2023-01-28 14:34:17','',''),('8','215',160,'','supplier','1',0.00,1437135.00,'Payment Id 34 for invoice:33, receipt: 33 by Lausu Energy Resources','2023-01-28 14:34:17','',''),('8','215',161,'','2','7',1504125.00,0.00,'Payment Id 37 for invoice:36, receipt: 36 by Lausu Energy Resources','2023-01-28 14:34:52','',''),('8','215',162,'','supplier','1',0.00,1504125.00,'Payment Id 37 for invoice:36, receipt: 36 by Lausu Energy Resources','2023-01-28 14:34:52','',''),('8','215',163,'','24','5',0.00,5270000.00,'Purchase Id 8 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-30 08:47:56','',''),('8','215',164,'','supplier','1',5270000.00,0.00,'Purchase Id 8 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-30 08:47:56','',''),('8','215',165,'','supplier','1',0.00,5270000.00,'Purchase Id 8 for 17,000.00 litters of Petrol - PMS returned to Lausu Energy Resources','2023-01-30 12:07:11','',''),('8','215',166,'','24','5',0.00,5746000.00,'Purchase Id 9 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-30 15:27:06','',''),('8','215',167,'','supplier','1',5746000.00,0.00,'Purchase Id 9 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-30 15:27:06','',''),('8','215',168,'','20','2',1094450.76,0.00,'Sales from shift 38 on 2023-01-31 10:26:06 ','2023-01-31 10:26:06','',''),('8','215',169,'','6.1','3',0.00,1094450.76,'Sales from shift 38 on 2023-01-31 10:26:06 ','2023-01-31 10:26:06','',''),('8','215',170,'','2','7',1392160.00,0.00,'Payment Id 38 for invoice:37, receipt: 37 by Lausu Energy Resources','2023-01-31 19:37:08','',''),('8','215',171,'','supplier','1',0.00,1392160.00,'Payment Id 38 for invoice:37, receipt: 37 by Lausu Energy Resources','2023-01-31 19:37:08','',''),('8','215',172,'','20','2',680654.26,0.00,'Sales from shift 39 on 2023-02-01 08:37:53 ','2023-02-01 08:37:53','',''),('8','215',173,'','6.1','3',0.00,680654.26,'Sales from shift 39 on 2023-02-01 08:37:53 ','2023-02-01 08:37:53','',''),('8','215',174,'','2','7',1094450.00,0.00,'Payment Id 39 for invoice:38, receipt: 38 by Lausu Energy Resources','2023-02-01 14:11:07','',''),('8','215',175,'','supplier','1',0.00,1094450.00,'Payment Id 39 for invoice:38, receipt: 38 by Lausu Energy Resources','2023-02-01 14:11:07','',''),('8','215',176,'','20','2',944679.00,0.00,'Sales from shift 40 on 2023-02-02 12:26:34 ','2023-02-02 12:26:34','',''),('8','215',177,'','6.1','3',0.00,944679.00,'Sales from shift 40 on 2023-02-02 12:26:34 ','2023-02-02 12:26:34','',''),('8','215',178,'','20','2',1007803.65,0.00,'Sales from shift 41 on 2023-02-03 08:35:59 ','2023-02-03 08:35:59','',''),('8','215',179,'','6.1','3',0.00,1007803.65,'Sales from shift 41 on 2023-02-03 08:35:59 ','2023-02-03 08:35:59','',''),('8','215',180,'','2','7',944680.00,0.00,'Payment Id 41 for invoice:40, receipt: 40 by Lausu Energy Resources','2023-02-03 15:44:03','',''),('8','215',181,'','supplier','1',0.00,944680.00,'Payment Id 41 for invoice:40, receipt: 40 by Lausu Energy Resources','2023-02-03 15:44:03','',''),('8','215',182,'','2','7',694750.00,0.00,'Payment Id 40 for invoice:39, receipt: 39 by Lausu Energy Resources','2023-02-03 15:44:03','',''),('8','215',183,'','supplier','1',0.00,694750.00,'Payment Id 40 for invoice:39, receipt: 39 by Lausu Energy Resources','2023-02-03 15:44:03','',''),('8','215',184,'','20','2',691690.50,0.00,'Sales from shift 42 on 2023-02-04 14:14:53 ','2023-02-04 14:14:53','',''),('8','215',185,'','6.1','3',0.00,691690.50,'Sales from shift 42 on 2023-02-04 14:14:53 ','2023-02-04 14:14:53','',''),('8','215',186,'','20','2',684210.90,0.00,'Sales from shift 43 on 2023-02-05 08:54:29 ','2023-02-05 08:54:29','',''),('8','215',187,'','6.1','3',0.00,684210.90,'Sales from shift 43 on 2023-02-05 08:54:29 ','2023-02-05 08:54:29','',''),('8','215',188,'','24','5',0.00,5692500.00,'Purchase Id 10 for 16,500.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-05 18:57:06','',''),('8','215',189,'','supplier','1',5692500.00,0.00,'Purchase Id 10 for 16,500.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-05 18:57:06','',''),('8','215',190,'','20','2',1463207.10,0.00,'Sales from shift 44 on 2023-02-06 08:50:08 ','2023-02-06 08:50:08','',''),('8','215',191,'','6.1','3',0.00,1463207.10,'Sales from shift 44 on 2023-02-06 08:50:08 ','2023-02-06 08:50:08','',''),('8','215',192,'','20','2',1431301.50,0.00,'Sales from shift 45 on 2023-02-07 16:56:13 ','2023-02-07 16:56:13','',''),('8','215',193,'','6.1','3',0.00,1431301.50,'Sales from shift 45 on 2023-02-07 16:56:13 ','2023-02-07 16:56:13','',''),('8','215',194,'','2','7',1070010.00,0.00,'Payment Id 46 for invoice:45, receipt: 45 by Lausu Energy Resources','2023-02-07 17:00:33','',''),('8','215',195,'','supplier','1',0.00,1070010.00,'Payment Id 46 for invoice:45, receipt: 45 by Lausu Energy Resources','2023-02-07 17:00:33','',''),('8','215',196,'','2','7',225210.00,0.00,'Payment Id 44 for invoice:43, receipt: 43 by Lausu Energy Resources','2023-02-07 17:00:33','',''),('8','215',197,'','supplier','1',0.00,225210.00,'Payment Id 44 for invoice:43, receipt: 43 by Lausu Energy Resources','2023-02-07 17:00:33','',''),('8','215',198,'','2','7',691690.00,0.00,'Payment Id 43 for invoice:42, receipt: 42 by Lausu Energy Resources','2023-02-07 17:00:33','',''),('8','215',199,'','supplier','1',0.00,691690.00,'Payment Id 43 for invoice:42, receipt: 42 by Lausu Energy Resources','2023-02-07 17:00:33','',''),('8','215',200,'','20','2',1204408.80,0.00,'Sales from shift 46 on 2023-02-08 13:18:27 ','2023-02-08 13:18:27','',''),('8','215',201,'','6.1','3',0.00,1204408.80,'Sales from shift 46 on 2023-02-08 13:18:27 ','2023-02-08 13:18:27','',''),('8','215',202,'','20','2',1444625.40,0.00,'Sales from shift 47 on 2023-02-09 13:13:45 ','2023-02-09 13:13:45','',''),('8','215',203,'','6.1','3',0.00,1444625.40,'Sales from shift 47 on 2023-02-09 13:13:45 ','2023-02-09 13:13:45','',''),('8','215',204,'','20','2',931710.45,0.00,'Sales from shift 48 on 2023-02-10 10:20:07 ','2023-02-10 10:20:07','',''),('8','215',205,'','6.1','3',0.00,931710.45,'Sales from shift 48 on 2023-02-10 10:20:07 ','2023-02-10 10:20:07','',''),('8','215',206,'','24','5',0.00,5140500.00,'Purchase Id 11 for 14,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-11 06:24:04','',''),('8','215',207,'','supplier','1',5140500.00,0.00,'Purchase Id 11 for 14,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-11 06:24:04','',''),('8','215',208,'','20','2',1998898.95,0.00,'Sales from shift 49 on 2023-02-12 08:59:17 ','2023-02-12 08:59:17','',''),('8','215',209,'','6.1','3',0.00,1998898.95,'Sales from shift 49 on 2023-02-12 08:59:17 ','2023-02-12 08:59:17','',''),('8','215',210,'','20','2',2502519.60,0.00,'Sales from shift 50 on 2023-02-13 12:20:03 ','2023-02-13 12:20:03','',''),('8','215',211,'','6.1','3',0.00,2502519.60,'Sales from shift 50 on 2023-02-13 12:20:03 ','2023-02-13 12:20:03','',''),('8','215',212,'','2','7',1431900.00,0.00,'Payment Id 56 for invoice:55, receipt: 55 by Lausu Energy Resources','2023-02-13 12:30:50','',''),('8','215',213,'','supplier','1',0.00,1431900.00,'Payment Id 56 for invoice:55, receipt: 55 by Lausu Energy Resources','2023-02-13 12:30:50','',''),('8','215',214,'','2','7',567710.00,0.00,'Payment Id 57 for invoice:56, receipt: 56 by Lausu Energy Resources','2023-02-13 12:34:12','',''),('8','215',215,'','supplier','1',0.00,567710.00,'Payment Id 57 for invoice:56, receipt: 56 by Lausu Energy Resources','2023-02-13 12:34:12','',''),('8','215',216,'','2','7',460077.25,0.00,'Payment Id 51 for invoice:50, receipt: 50 by Lausu Energy Resources','2023-02-13 12:38:22','',''),('8','215',217,'','supplier','1',0.00,460077.25,'Payment Id 51 for invoice:50, receipt: 50 by Lausu Energy Resources','2023-02-13 12:38:22','',''),('8','215',218,'','2','7',639103.75,0.00,'Payment Id 53 for invoice:52, receipt: 52 by Lausu Energy Resources','2023-02-13 12:40:34','',''),('8','215',219,'','supplier','1',0.00,639103.75,'Payment Id 53 for invoice:52, receipt: 52 by Lausu Energy Resources','2023-02-13 12:40:34','',''),('8','215',220,'','2','7',392216.75,0.00,'Payment Id 47 for invoice:46, receipt: 46 by Lausu Energy Resources','2023-02-13 12:44:44','',''),('8','215',221,'','supplier','1',0.00,392216.75,'Payment Id 47 for invoice:46, receipt: 46 by Lausu Energy Resources','2023-02-13 12:44:44','',''),('8','215',222,'','2','7',1007805.00,0.00,'Payment Id 42 for invoice:41, receipt: 41 by Lausu Energy Resources','2023-02-13 12:49:03','',''),('8','215',223,'','supplier','1',0.00,1007805.00,'Payment Id 42 for invoice:41, receipt: 41 by Lausu Energy Resources','2023-02-13 12:49:03','',''),('8','215',224,'','20','2',650994.30,0.00,'Sales from shift 51 on 2023-02-14 08:51:20 ','2023-02-14 08:51:20','',''),('8','215',225,'','6.1','3',0.00,650994.30,'Sales from shift 51 on 2023-02-14 08:51:20 ','2023-02-14 08:51:20','',''),('8','215',226,'','2','7',366000.00,0.00,'Payment Id 55 for invoice:54, receipt: 54 by Lausu Energy Resources','2023-02-16 14:26:57','',''),('8','215',227,'','supplier','1',0.00,366000.00,'Payment Id 55 for invoice:54, receipt: 54 by Lausu Energy Resources','2023-02-16 14:26:57','',''),('8','215',228,'','2','7',565710.00,0.00,'Payment Id 54 for invoice:53, receipt: 53 by Lausu Energy Resources','2023-02-16 14:26:57','',''),('8','215',229,'','supplier','1',0.00,565710.00,'Payment Id 54 for invoice:53, receipt: 53 by Lausu Energy Resources','2023-02-16 14:26:57','',''),('8','215',230,'','2','7',459000.00,0.00,'Payment Id 45 for invoice:44, receipt: 44 by Lausu Energy Resources','2023-02-16 14:26:57','',''),('8','215',231,'','supplier','1',0.00,459000.00,'Payment Id 45 for invoice:44, receipt: 44 by Lausu Energy Resources','2023-02-16 14:26:57','',''),('8','215',232,'','2','7',805625.00,0.00,'Payment Id 52 for invoice:51, receipt: 51 by Lausu Energy Resources','2023-02-16 14:30:17','',''),('8','215',233,'','supplier','1',0.00,805625.00,'Payment Id 52 for invoice:51, receipt: 51 by Lausu Energy Resources','2023-02-16 14:30:17','',''),('8','215',234,'','2','7',744410.00,0.00,'Payment Id 50 for invoice:49, receipt: 49 by Lausu Energy Resources','2023-02-16 17:26:46','',''),('8','215',235,'','supplier','1',0.00,744410.00,'Payment Id 50 for invoice:49, receipt: 49 by Lausu Energy Resources','2023-02-16 17:26:46','',''),('8','215',236,'','2','7',854300.00,0.00,'Payment Id 48 for invoice:47, receipt: 47 by Lausu Energy Resources','2023-02-16 17:29:42','',''),('8','215',237,'','supplier','1',0.00,854300.00,'Payment Id 48 for invoice:47, receipt: 47 by Lausu Energy Resources','2023-02-16 17:29:42','',''),('8','215',238,'','24','5',0.00,11424000.00,'Purchase Id 12 for 33,600.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-19 18:47:59','',''),('8','215',239,'','supplier','1',11424000.00,0.00,'Purchase Id 12 for 33,600.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-19 18:47:59','',''),('8','215',240,'','20','2',801692.80,0.00,'Sales from shift 52 on 2023-02-20 10:10:58 ','2023-02-20 10:10:58','',''),('8','215',241,'','6.1','3',0.00,801692.80,'Sales from shift 52 on 2023-02-20 10:10:58 ','2023-02-20 10:10:58','',''),('8','215',242,'','20','2',1318856.60,0.00,'Sales from shift 53 on 2023-02-20 10:17:19 ','2023-02-20 10:17:19','',''),('8','215',243,'','6.1','3',0.00,1318856.60,'Sales from shift 53 on 2023-02-20 10:17:19 ','2023-02-20 10:17:19','',''),('8','215',244,'','20','2',928618.20,0.00,'Sales from shift 54 on 2023-02-21 08:23:06 ','2023-02-21 08:23:06','',''),('8','215',245,'','6.1','3',0.00,928618.20,'Sales from shift 54 on 2023-02-21 08:23:06 ','2023-02-21 08:23:06','',''),('8','215',246,'','20','2',734359.20,0.00,'Sales from shift 55 on 2023-02-22 12:28:58 ','2023-02-22 12:28:58','',''),('8','215',247,'','6.1','3',0.00,734359.20,'Sales from shift 55 on 2023-02-22 12:28:58 ','2023-02-22 12:28:58','',''),('8','215',248,'','20','2',827913.60,0.00,'Sales from shift 56 on 2023-02-23 08:38:57 ','2023-02-23 08:38:57','',''),('8','215',249,'','6.1','3',0.00,827913.60,'Sales from shift 56 on 2023-02-23 08:38:57 ','2023-02-23 08:38:57','',''),('8','215',250,'','24','5',0.00,5392000.00,'Purchase Id 13 for 16,850.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-23 09:52:59','',''),('8','215',251,'','supplier','1',5392000.00,0.00,'Purchase Id 13 for 16,850.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-23 09:52:59','',''),('8','215',252,'','20','2',968409.60,0.00,'Sales from shift 57 on 2023-02-24 08:14:35 ','2023-02-24 08:14:35','',''),('8','215',253,'','6.1','3',0.00,968409.60,'Sales from shift 57 on 2023-02-24 08:14:35 ','2023-02-24 08:14:35','',''),('8','215',254,'','2','7',734360.00,0.00,'Payment Id 63 for invoice:62, receipt: 62 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',255,'','supplier','1',0.00,734360.00,'Payment Id 63 for invoice:62, receipt: 62 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',256,'','2','7',928620.00,0.00,'Payment Id 62 for invoice:61, receipt: 61 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',257,'','supplier','1',0.00,928620.00,'Payment Id 62 for invoice:61, receipt: 61 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',258,'','2','7',1318855.00,0.00,'Payment Id 61 for invoice:60, receipt: 60 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',259,'','supplier','1',0.00,1318855.00,'Payment Id 61 for invoice:60, receipt: 60 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',260,'','2','7',801690.00,0.00,'Payment Id 60 for invoice:59, receipt: 59 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',261,'','supplier','1',0.00,801690.00,'Payment Id 60 for invoice:59, receipt: 59 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',262,'','2','7',650995.00,0.00,'Payment Id 59 for invoice:58, receipt: 58 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',263,'','supplier','1',0.00,650995.00,'Payment Id 59 for invoice:58, receipt: 58 by Lausu Energy Resources','2023-02-24 12:25:47','',''),('8','215',264,'','2','7',2503134.75,0.00,'Payment Id 58 for invoice:57, receipt: 57 by Lausu Energy Resources','2023-02-24 12:28:16','',''),('8','215',265,'','supplier','1',0.00,2503134.75,'Payment Id 58 for invoice:57, receipt: 57 by Lausu Energy Resources','2023-02-24 12:28:16','',''),('8','215',266,'','20','2',703577.60,0.00,'Sales from shift 58 on 2023-02-26 22:31:52 ','2023-02-26 22:31:52','',''),('8','215',267,'','6.1','3',0.00,703577.60,'Sales from shift 58 on 2023-02-26 22:31:52 ','2023-02-26 22:31:52','',''),('8','215',268,'','20','2',1918512.00,0.00,'Sales from shift 59 on 2023-02-27 10:23:10 ','2023-02-27 10:23:10','',''),('8','215',269,'','6.1','3',0.00,1918512.00,'Sales from shift 59 on 2023-02-27 10:23:10 ','2023-02-27 10:23:10','',''),('8','215',270,'','20','2',851008.00,0.00,'Sales from shift 60 on 2023-02-28 10:18:50 ','2023-02-28 10:18:50','',''),('8','215',271,'','6.1','3',0.00,851008.00,'Sales from shift 60 on 2023-02-28 10:18:50 ','2023-02-28 10:18:50','',''),('8','215',272,'','24','5',0.00,5808000.00,'Purchase Id 14 for 18,150.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-28 12:14:35','',''),('8','215',273,'','supplier','1',5808000.00,0.00,'Purchase Id 14 for 18,150.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-28 12:14:35','',''),('8','215',274,'','20','2',848723.20,0.00,'Sales from shift 61 on 2023-03-01 11:39:04 ','2023-03-01 11:39:04','',''),('8','215',275,'','6.1','3',0.00,848723.20,'Sales from shift 61 on 2023-03-01 11:39:04 ','2023-03-01 11:39:04','',''),('8','215',276,'','2','7',851010.00,0.00,'Payment Id 68 for invoice:68, receipt: 68 by Lausu Energy Resources','2023-03-01 16:39:13','',''),('8','215',277,'','supplier','1',0.00,851010.00,'Payment Id 68 for invoice:68, receipt: 68 by Lausu Energy Resources','2023-03-01 16:39:13','',''),('8','215',278,'','2','7',1918515.00,0.00,'Payment Id 67 for invoice:67, receipt: 67 by Lausu Energy Resources','2023-03-01 16:39:13','',''),('8','215',279,'','supplier','1',0.00,1918515.00,'Payment Id 67 for invoice:67, receipt: 67 by Lausu Energy Resources','2023-03-01 16:39:13','',''),('8','215',280,'','2','7',703580.00,0.00,'Payment Id 66 for invoice:66, receipt: 66 by Lausu Energy Resources','2023-03-01 16:39:13','',''),('8','215',281,'','supplier','1',0.00,703580.00,'Payment Id 66 for invoice:66, receipt: 66 by Lausu Energy Resources','2023-03-01 16:39:13','',''),('8','215',282,'','2','7',968410.00,0.00,'Payment Id 65 for invoice:64, receipt: 64 by Lausu Energy Resources','2023-03-01 16:39:13','',''),('8','215',283,'','supplier','1',0.00,968410.00,'Payment Id 65 for invoice:64, receipt: 64 by Lausu Energy Resources','2023-03-01 16:39:13','',''),('8','215',284,'','2','7',827915.00,0.00,'Payment Id 64 for invoice:63, receipt: 63 by Lausu Energy Resources','2023-03-01 16:44:25','',''),('8','215',285,'','supplier','1',0.00,827915.00,'Payment Id 64 for invoice:63, receipt: 63 by Lausu Energy Resources','2023-03-01 16:44:25','',''),('8','215',286,'','2','7',557139.55,0.00,'Payment Id 49 for invoice:48, receipt: 48 by Lausu Energy Resources','2023-03-01 17:13:53','',''),('8','215',287,'','supplier','1',0.00,557139.55,'Payment Id 49 for invoice:48, receipt: 48 by Lausu Energy Resources','2023-03-01 17:13:53','',''),('8','215',288,'','20','2',731318.40,0.00,'Sales from shift 62 on 2023-03-02 11:28:42 ','2023-03-02 11:28:42','',''),('8','215',289,'','6.1','3',0.00,731318.40,'Sales from shift 62 on 2023-03-02 11:28:42 ','2023-03-02 11:28:42','',''),('8','215',290,'','2','7',731320.00,0.00,'Payment Id 70 for invoice:70, receipt: 70 by Lausu Energy Resources','2023-03-03 13:23:36','',''),('8','215',291,'','supplier','1',0.00,731320.00,'Payment Id 70 for invoice:70, receipt: 70 by Lausu Energy Resources','2023-03-03 13:23:36','',''),('8','215',292,'','2','7',848725.00,0.00,'Payment Id 69 for invoice:69, receipt: 69 by Lausu Energy Resources','2023-03-03 13:23:36','',''),('8','215',293,'','supplier','1',0.00,848725.00,'Payment Id 69 for invoice:69, receipt: 69 by Lausu Energy Resources','2023-03-03 13:23:36','',''),('8','215',294,'','20','2',776809.60,0.00,'Sales from shift 63 on 2023-03-04 08:46:56 ','2023-03-04 08:46:56','',''),('8','215',295,'','6.1','3',0.00,776809.60,'Sales from shift 63 on 2023-03-04 08:46:56 ','2023-03-04 08:46:56','',''),('8','215',296,'','20','2',813513.00,0.00,'Sales from shift 64 on 2023-03-04 08:54:31 ','2023-03-04 08:54:31','',''),('8','215',297,'','6.1','3',0.00,813513.00,'Sales from shift 64 on 2023-03-04 08:54:31 ','2023-03-04 08:54:31','',''),('8','215',298,'','20','2',910197.00,0.00,'Sales from shift 65 on 2023-03-06 08:55:10 ','2023-03-06 08:55:10','',''),('8','215',299,'','6.1','3',0.00,910197.00,'Sales from shift 65 on 2023-03-06 08:55:10 ','2023-03-06 08:55:10','',''),('8','215',300,'','20','2',1497204.00,0.00,'Sales from shift 66 on 2023-03-06 08:59:16 ','2023-03-06 08:59:16','',''),('8','215',301,'','6.1','3',0.00,1497204.00,'Sales from shift 66 on 2023-03-06 08:59:16 ','2023-03-06 08:59:16','',''),('8','215',302,'','2','7',910200.00,0.00,'Payment Id 73 for invoice:73, receipt: 73 by Lausu Energy Resources','2023-03-06 13:12:11','',''),('8','215',303,'','supplier','1',0.00,910200.00,'Payment Id 73 for invoice:73, receipt: 73 by Lausu Energy Resources','2023-03-06 13:12:11','',''),('8','215',304,'','2','7',813515.00,0.00,'Payment Id 72 for invoice:72, receipt: 72 by Lausu Energy Resources','2023-03-06 13:12:11','',''),('8','215',305,'','supplier','1',0.00,813515.00,'Payment Id 72 for invoice:72, receipt: 72 by Lausu Energy Resources','2023-03-06 13:12:11','',''),('8','215',306,'','2','7',776810.00,0.00,'Payment Id 71 for invoice:71, receipt: 71 by Lausu Energy Resources','2023-03-06 13:12:11','',''),('8','215',307,'','supplier','1',0.00,776810.00,'Payment Id 71 for invoice:71, receipt: 71 by Lausu Energy Resources','2023-03-06 13:12:11','',''),('8','215',308,'','20','2',1105152.00,0.00,'Sales from shift 67 on 2023-03-08 08:55:25 ','2023-03-08 08:55:25','',''),('8','215',309,'','6.1','3',0.00,1105152.00,'Sales from shift 67 on 2023-03-08 08:55:25 ','2023-03-08 08:55:25','',''),('8','215',310,'','20','2',797256.00,0.00,'Sales from shift 68 on 2023-03-08 09:12:27 ','2023-03-08 09:12:27','',''),('8','215',311,'','6.1','3',0.00,797256.00,'Sales from shift 68 on 2023-03-08 09:12:27 ','2023-03-08 09:12:27','',''),('8','215',312,'','20','2',1044402.00,0.00,'Sales from shift 69 on 2023-03-09 10:06:43 ','2023-03-09 10:06:43','',''),('8','215',313,'','6.1','3',0.00,1044402.00,'Sales from shift 69 on 2023-03-09 10:06:43 ','2023-03-09 10:06:43','',''),('8','215',314,'','2','7',797255.00,0.00,'Payment Id 76 for invoice:76, receipt: 76 by Lausu Energy Resources','2023-03-09 13:18:17','',''),('8','215',315,'','supplier','1',0.00,797255.00,'Payment Id 76 for invoice:76, receipt: 76 by Lausu Energy Resources','2023-03-09 13:18:17','',''),('8','215',316,'','2','7',1105150.00,0.00,'Payment Id 75 for invoice:75, receipt: 75 by Lausu Energy Resources','2023-03-09 13:18:17','',''),('8','215',317,'','supplier','1',0.00,1105150.00,'Payment Id 75 for invoice:75, receipt: 75 by Lausu Energy Resources','2023-03-09 13:18:17','',''),('8','215',318,'','2','7',1497205.00,0.00,'Payment Id 74 for invoice:74, receipt: 74 by Lausu Energy Resources','2023-03-09 13:18:17','',''),('8','215',319,'','supplier','1',0.00,1497205.00,'Payment Id 74 for invoice:74, receipt: 74 by Lausu Energy Resources','2023-03-09 13:18:17','',''),('8','215',320,'','20','2',1313070.00,0.00,'Sales from shift 70 on 2023-03-10 09:19:38 ','2023-03-10 09:19:38','',''),('8','215',321,'','6.1','3',0.00,1313070.00,'Sales from shift 70 on 2023-03-10 09:19:38 ','2023-03-10 09:19:38','',''),('8','215',322,'','20','2',895659.00,0.00,'Sales from shift 71 on 2023-03-11 08:38:20 ','2023-03-11 08:38:20','',''),('8','215',323,'','6.1','3',0.00,895659.00,'Sales from shift 71 on 2023-03-11 08:38:20 ','2023-03-11 08:38:20','',''),('8','215',324,'','20','2',654804.00,0.00,'Sales from shift 72 on 2023-03-12 13:00:44 ','2023-03-12 13:00:44','',''),('8','215',325,'','6.1','3',0.00,654804.00,'Sales from shift 72 on 2023-03-12 13:00:44 ','2023-03-12 13:00:44','',''),('8','215',326,'','24','5',0.00,9960000.00,'Purchase Id 15 for 33,200.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-12 13:22:05','',''),('8','215',327,'','supplier','1',9960000.00,0.00,'Purchase Id 15 for 33,200.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-12 13:22:05','',''),('8','215',328,'','20','2',1786785.00,0.00,'Sales from shift 73 on 2023-03-13 09:28:07 ','2023-03-13 09:28:07','',''),('8','215',329,'','6.1','3',0.00,1786785.00,'Sales from shift 73 on 2023-03-13 09:28:07 ','2023-03-13 09:28:07','',''),('8','215',330,'','2','7',895660.00,0.00,'Payment Id 80 for invoice:80, receipt: 80 by Lausu Energy Resources','2023-03-13 12:17:18','',''),('8','215',331,'','supplier','1',0.00,895660.00,'Payment Id 80 for invoice:80, receipt: 80 by Lausu Energy Resources','2023-03-13 12:17:18','',''),('8','215',332,'','2','7',1313070.00,0.00,'Payment Id 79 for invoice:79, receipt: 79 by Lausu Energy Resources','2023-03-13 12:17:18','',''),('8','215',333,'','supplier','1',0.00,1313070.00,'Payment Id 79 for invoice:79, receipt: 79 by Lausu Energy Resources','2023-03-13 12:17:18','',''),('8','215',334,'','2','7',1044400.00,0.00,'Payment Id 78 for invoice:78, receipt: 78 by Lausu Energy Resources','2023-03-13 12:17:18','',''),('8','215',335,'','supplier','1',0.00,1044400.00,'Payment Id 78 for invoice:78, receipt: 78 by Lausu Energy Resources','2023-03-13 12:17:18','',''),('8','215',336,'','2','7',797255.00,0.00,'Payment Id 77 for invoice:77, receipt: 77 by Lausu Energy Resources','2023-03-13 12:17:18','',''),('8','215',337,'','supplier','1',0.00,797255.00,'Payment Id 77 for invoice:77, receipt: 77 by Lausu Energy Resources','2023-03-13 12:17:18','',''),('8','215',338,'','20','2',1526997.00,0.00,'Sales from shift 74 on 2023-03-14 08:38:02 ','2023-03-14 08:38:02','',''),('8','215',339,'','6.1','3',0.00,1526997.00,'Sales from shift 74 on 2023-03-14 08:38:02 ','2023-03-14 08:38:02','',''),('8','215',340,'','20','2',1413231.00,0.00,'Sales from shift 75 on 2023-03-15 09:15:06 ','2023-03-15 09:15:06','',''),('8','215',341,'','6.1','3',0.00,1413231.00,'Sales from shift 75 on 2023-03-15 09:15:06 ','2023-03-15 09:15:06','',''),('8','215',342,'','20','2',1399482.00,0.00,'Sales from shift 76 on 2023-03-16 08:29:46 ','2023-03-16 08:29:46','',''),('8','215',343,'','6.1','3',0.00,1399482.00,'Sales from shift 76 on 2023-03-16 08:29:46 ','2023-03-16 08:29:46','',''),('8','215',344,'','24','5',0.00,4500000.00,'Purchase Id 16 for 15,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-16 15:01:23','',''),('8','215',345,'','supplier','1',4500000.00,0.00,'Purchase Id 16 for 15,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-16 15:01:23','',''),('8','215',346,'','20','2',1227666.00,0.00,'Sales from shift 77 on 2023-03-17 08:08:02 ','2023-03-17 08:08:02','',''),('8','215',347,'','6.1','3',0.00,1227666.00,'Sales from shift 77 on 2023-03-17 08:08:02 ','2023-03-17 08:08:02','',''),('8','215',348,'','20','2',1419363.00,0.00,'Sales from shift 78 on 2023-03-20 07:55:54 ','2023-03-20 07:55:54','',''),('8','215',349,'','6.1','3',0.00,1419363.00,'Sales from shift 78 on 2023-03-20 07:55:54 ','2023-03-20 07:55:54','',''),('8','215',350,'','20','2',2195994.00,0.00,'Sales from shift 79 on 2023-03-20 10:50:18 ','2023-03-20 10:50:18','',''),('8','215',351,'','6.1','3',0.00,2195994.00,'Sales from shift 79 on 2023-03-20 10:50:18 ','2023-03-20 10:50:18','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'8','215','PMS','Petrol','Litres',0,300.00,300.00,300.00,300.00,0.00,0,'2022-10-16 01:39:58','963','960','2023-03-04 08:51:31',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'8','215',1,305.00,305.00,305.00,305.00,'','2022-12-16 20:35:15','960'),(2,'8','215',1,310.00,310.00,310.00,310.00,'','2022-12-17 11:52:36','960'),(3,'8','215',1,300.00,300.00,300.00,300.00,'','2023-01-01 11:50:48','960'),(4,'8','215',1,310.00,310.00,310.00,310.00,'','2023-01-23 12:24:12','960'),(5,'8','215',1,338.00,338.00,338.00,338.00,'','2023-01-30 13:25:22','960'),(6,'8','215',1,345.00,345.00,345.00,345.00,'','2023-02-01 08:42:08','960'),(7,'8','215',1,340.00,340.00,340.00,340.00,'','2023-02-19 18:43:15','960'),(8,'8','215',1,320.00,320.00,320.00,320.00,'','2023-02-23 08:36:23','960'),(9,'8','215',1,300.00,300.00,300.00,300.00,'','2023-03-04 08:51:07','960');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'8','215','2022-12-04',1,1,305.00,2800.00,0.00,0.00,854000.00,0.00,'','001','TRN44YZ','','','','2022-12-16 20:27:50',15,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2022-12-17 07:28:48'),(2,'8','215','2022-12-15',1,1,305.00,17000.00,0.00,0.00,5185000.00,0.00,'','002','BCH242XA','','','','2022-12-16 20:32:23',15,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2022-12-17 07:29:02'),(3,'8','215','2022-12-23',1,1,310.00,16200.00,0.00,0.00,5022000.00,0.00,'','003','RAN33XF','','','','2022-12-23 15:40:10',15,'Purchase  of PMS','960','','0000-00-00 00:00:00','927','2022-12-23 15:52:28'),(4,'8','215','2022-12-31',1,1,300.00,16800.00,0.00,0.00,5040000.00,0.00,'','004','RAN31XF','','','','2023-01-01 11:53:42',15,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2023-01-01 12:09:36'),(5,'8','215','2023-01-05',1,1,300.00,32600.00,0.00,0.00,9780000.00,0.00,'','005','RAN683XA','','','','2023-01-06 09:32:36',15,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2023-01-06 09:41:46'),(6,'8','215','2023-01-17',1,1,300.00,15950.00,0.00,0.00,4785000.00,0.00,'','006','RAN869XA','','','','2023-01-18 08:15:42',15,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2023-01-18 14:43:50'),(7,'8','215','2023-01-21',1,1,300.00,16800.00,0.00,0.00,5040000.00,0.00,'','007','RAN869XA','','','','2023-01-22 08:53:56',15,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2023-01-22 13:22:13'),(8,'8','215','2023-01-29',1,1,310.00,17000.00,0.00,0.00,5270000.00,0.00,'','007','BCH242XA','','','','2023-01-29 20:35:59',2,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2023-01-30 12:07:11'),(9,'8','215','2023-01-29',1,1,338.00,17000.00,0.00,0.00,5746000.00,0.00,'','006','BCH242XA','','','','2023-01-30 13:26:59',15,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2023-01-30 15:27:06'),(10,'8','215','2023-02-04',1,1,345.00,16500.00,0.00,0.00,5692500.00,0.00,'','008','WDL813XA','','','','2023-02-05 09:06:33',15,'Purchase of  PMS','960','','0000-00-00 00:00:00','927','2023-02-05 18:57:06'),(11,'8','215','2023-02-10',1,1,345.00,14900.00,0.00,0.00,5140500.00,0.00,'','009','RAN441XA','','','','2023-02-10 22:23:36',15,'Purchase of PMS','960','','0000-00-00 00:00:00','927','2023-02-11 06:24:04'),(12,'8','215','2023-02-17',1,1,340.00,33600.00,0.00,0.00,11424000.00,0.00,'','010','NSR433ZS','','','','2023-02-19 18:45:06',15,'Purchases Of PMS','960','','0000-00-00 00:00:00','927','2023-02-19 18:47:59'),(13,'8','215','2023-02-22',1,1,320.00,16850.00,0.00,0.00,5392000.00,0.00,'','011','RAN869XA','','','','2023-02-23 08:48:53',15,'Purchases of PMS','960','','0000-00-00 00:00:00','927','2023-02-23 09:52:59'),(14,'8','215','2023-02-27',1,1,320.00,18150.00,0.00,0.00,5808000.00,0.00,'','012','RAN441XA','','','','2023-02-28 10:24:17',15,'Purchases of PMS','960','','0000-00-00 00:00:00','927','2023-02-28 12:14:35'),(15,'8','215','2023-03-11',1,1,300.00,33200.00,0.00,0.00,9960000.00,0.00,'','013','BCH248XA','','','','2023-03-12 13:13:17',15,'Purchases of PMS','960','','0000-00-00 00:00:00','927','2023-03-12 13:22:05'),(16,'8','215','2023-03-15',1,1,300.00,15000.00,0.00,0.00,4500000.00,0.00,'','13','RAN441XA','','','','2023-03-16 11:27:08',15,'Purchases of PMS','960','','0000-00-00 00:00:00','927','2023-03-16 15:01:23');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'8','215','2022-12-16',1,'001','','5',809635.00,'1','','','7','Kachako Lausu','001',809634.70,'2022-12-17 11:50:57',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-20 13:43:09'),(2,'8','215','2022-12-17',1,'002','','5',919030.00,'2','','','7','Kachako Lausu','002',919029.10,'2022-12-18 13:47:30',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-20 13:43:09'),(3,'8','215','2022-12-18',1,'003','','5',1579640.00,'3','','','7','Kachako Lausu','003',1579639.10,'2022-12-19 15:33:34',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-20 13:43:09'),(4,'8','215','2022-12-19',1,'004','','5',1315500.00,'4','','','7','Kachako Lausu','004',1315497.40,'2022-12-20 09:39:41',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-25 14:26:49'),(5,'8','215','2022-12-20',1,'005','','5',1041550.00,'5','','','7','Kachako Lausu','005',1041547.30,'2022-12-21 14:24:57',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-29 13:21:35'),(6,'8','215','2022-12-23',1,'006','','5',316055.00,'6','','','7','Kachako Lausu','006',316054.30,'2022-12-25 16:24:31',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-29 13:21:35'),(7,'8','215','2022-12-24',1,'007','','5',995850.00,'7','','','7','Kachako Lausu','007',995847.10,'2022-12-25 16:29:06',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-29 13:21:35'),(8,'8','215','2022-12-25',1,'008','','5',1161430.00,'8','','','7','Kachako Lausu','008',1161427.40,'2022-12-26 08:37:32',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-29 13:21:35'),(9,'8','215','2022-12-26',1,'009','','5',767255.00,'9','','','7','Kachako Lausu','009',767253.10,'2022-12-27 09:29:20',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-29 13:21:35'),(10,'8','215','2022-12-27',1,'010','','5',585530.00,'10','','','7','Kachako Lausu','010',585528.00,'2022-12-28 08:35:55',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2022-12-29 13:21:35'),(11,'8','215','2022-12-28',1,'011','','5',539545.00,'11','','','7','Kachako Lausu','011',539545.70,'2022-12-29 08:24:52',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-03 17:18:04'),(12,'8','215','2022-12-29',1,'012','','5',596985.00,'12','','','7','Kachako Lausu','012',596985.60,'2022-12-30 09:47:00',5,'Payments of PMS','960','','0000-00-00 00:00:00','465','2023-01-02 17:09:06'),(13,'8','215','2023-01-01',1,'013','','5',1170800.00,'13','','','7','Kachako Lausu','013',1170801.00,'2023-01-02 08:18:58',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-03 17:18:04'),(14,'8','215','2023-01-02',1,'014','','5',601540.00,'14','','','7','Kachako Lausu','014',601539.00,'2023-01-03 08:23:19',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-09 14:00:16'),(15,'8','215','2023-01-03',1,'015','','5',739490.00,'15','','','7','Kachako Lausu','015',739491.00,'2023-01-04 08:53:39',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-09 14:00:16'),(16,'8','215','2023-01-04',1,'016','','5',695390.00,'16','','','7','Kachako Lausu','016',695388.00,'2023-01-05 09:10:43',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-09 14:00:16'),(17,'8','215','2023-01-05',1,'017','','5',630940.00,'17','','','7','Kachako Lausu','017',630939.00,'2023-01-06 09:28:35',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-09 14:00:16'),(18,'8','215','2023-01-06',1,'018','','5',547395.00,'18','','','7','Kachako Lausu','018',547395.00,'2023-01-07 08:27:21',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-09 14:00:16'),(19,'8','215','2023-01-07',1,'019','','5',437330.00,'19','','','7','Kachako Lausu','019',437331.00,'2023-01-08 09:10:20',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-09 14:00:16'),(20,'8','215','2023-01-08',1,'020','','5',1275075.00,'20','','','7','Kachako Lausu','020',1275075.00,'2023-01-09 09:34:53',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-09 14:00:16'),(21,'8','215','2023-01-08',1,'20','','5',1275075.00,'20','','','7','Kachako Lausu','20',1275075.00,'2023-01-09 09:38:17',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-15 23:07:51'),(22,'8','215','2023-01-09',1,'021','','5',640035.00,'21','','','7','Kachako Lausu','021',640035.00,'2023-01-10 08:17:06',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-21 15:17:42'),(23,'8','215','2023-01-10',1,'22','','5',538485.00,'22','','','7','Kachako Lausu','22',538485.00,'2023-01-11 10:10:59',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-15 23:07:30'),(24,'8','215','2023-01-11',1,'23','','5',443240.00,'23','','','7','Kachako Lausu','23',443241.00,'2023-01-12 08:44:03',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-15 23:07:30'),(25,'8','215','2023-01-12',1,'24','','5',554150.00,'24','','','7','Kachako Lausu','24',554151.00,'2023-01-13 08:54:13',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-15 23:07:30'),(26,'8','215','2023-01-13',1,'25','','5',1352460.00,'25','','','7','Kachako Lausu','25',1352460.00,'2023-01-14 09:20:29',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-21 15:13:44'),(27,'8','215','2023-01-14',1,'26','','5',1127550.00,'26','','','7','Kachako Lausu','26',1127547.00,'2023-01-15 08:58:19',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-21 15:13:44'),(28,'8','215','2023-01-15',1,'27','','5',2402015.00,'27','','','7','Kachako Lausu','27',2402016.00,'2023-01-16 09:14:48',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-21 15:13:44'),(29,'8','215','2023-01-16',1,'28','','5',959615.00,'28','','','7','Kachako Lausu','28',959616.00,'2023-01-17 09:04:55',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-21 15:13:44'),(30,'8','215','2023-01-17',1,'29','','5',968240.00,'29','','','7','Kachako Lausu','29',968238.00,'2023-01-18 08:12:52',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-21 15:13:44'),(31,'8','215','2023-01-18',1,'30','','5',1110250.00,'30','','','7','Kachako Lausu','30',1110249.00,'2023-01-19 09:52:17',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-21 15:13:44'),(32,'8','215','2023-01-19',1,'31','','5',967940.00,'31','','','7','Kachako Lausu','31',967941.00,'2023-01-20 16:37:42',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-21 15:13:58'),(33,'8','215','2023-01-20',1,'32','','5',1154005.00,'32','','','7','Kachako Lausu','32',1154004.00,'2023-01-21 09:14:45',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-23 15:37:38'),(34,'8','215','2023-01-21',1,'33','','5',1437135.00,'33','','','7','Kachako Lausu','33',1437135.00,'2023-01-22 08:50:52',5,'Payments of PMS','960','','0000-00-00 00:00:00','465','2023-01-28 14:34:17'),(35,'8','215','2023-01-22',1,'34','','5',862470.00,'34','','','7','Kachako Lausu','34',862467.00,'2023-01-23 12:19:16',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-24 15:41:30'),(36,'8','215','2023-01-22',1,'35','','5',1612460.00,'35','','','7','Kachako Lausu','35',1612458.80,'2023-01-23 12:27:35',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-24 15:41:30'),(37,'8','215','2023-01-23',1,'36','','5',1504125.00,'36','','','7','Kachako Lausu','36',1504123.10,'2023-01-24 14:41:53',5,'Payments of PMS','960','','0000-00-00 00:00:00','465','2023-01-28 14:34:53'),(38,'8','215','2023-01-25',1,'37','','5',1392160.00,'37','','','7','Kachako Lausu','37',1392160.40,'2023-01-26 13:50:54',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-01-31 19:37:08'),(39,'8','215','2023-01-30',1,'38','','5',1094450.00,'38','','','7','Kachako Lausu','38',1094450.76,'2023-01-31 10:27:46',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-01 14:11:07'),(40,'8','215','2023-01-31',1,'39','','5',694750.00,'39','','','7','Kachako Lausu','39',694750.65,'2023-02-01 08:43:58',5,'Payments of PMS','960','927','2023-02-01 14:10:09','927','2023-02-03 15:44:03'),(41,'8','215','2023-02-01',1,'40','','5',944680.00,'40','','','7','Kachako Lausu','40',944679.00,'2023-02-02 12:27:43',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-03 15:44:03'),(42,'8','215','2023-02-02',1,'41','','5',1007805.00,'41','','','7','Kachako Lausu','41',1007803.65,'2023-02-03 08:37:14',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-13 12:49:03'),(43,'8','215','2023-02-03',1,'42','','5',691690.00,'42','','','7','Kachako Lausu','42',691690.50,'2023-02-04 14:16:21',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-07 17:00:33'),(44,'8','215','2023-02-04',1,'43','','5',225210.00,'43','','','7','Kachako Lausu','43',684210.90,'2023-02-05 08:56:09',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-07 17:00:33'),(45,'8','215','2023-02-04',1,'44','','5',459000.00,'44','','','7','Kachako Lausu','44',459000.00,'2023-02-05 09:03:25',5,'Payments of PMS','960','927','2023-02-16 14:22:00','927','2023-02-16 14:26:57'),(46,'8','215','2023-02-05',1,'45','','5',1070010.00,'45','','','7','Kachako Lausu','45',1463207.10,'2023-02-06 08:52:12',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-07 17:00:33'),(47,'8','215','2023-02-05',1,'46','','5',392216.75,'46','','','7','Kachako Lausu','46',393200.00,'2023-02-06 08:56:37',5,'Payments of PMS','960','927','2023-02-13 12:43:30','927','2023-02-13 12:44:44'),(48,'8','215','2023-02-06',1,'47','','5',854300.00,'47','','','7','Kachako Lausu','47',1431301.00,'2023-02-07 17:07:44',5,'Payments of PMS','960','927','2023-02-16 17:27:25','927','2023-02-16 17:29:42'),(49,'8','215','2023-02-06',1,'48','','5',557139.55,'48','','','7','Kachako Lausu','48',577100.00,'2023-02-07 17:09:19',5,'Payments of PMS','960','927','2023-02-13 12:42:04','927','2023-03-01 17:13:53'),(50,'8','215','2023-02-07',1,'49','','5',744410.00,'49','','','7','Kachako Lausu','49',1204408.80,'2023-02-08 13:23:01',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-16 17:26:46'),(51,'8','215','2023-02-08',1,'50','','5',460077.25,'50','','','7','Kachako Lausu','001',460000.00,'2023-02-08 13:24:05',5,'Payments of PMS','960','927','2023-02-13 12:38:12','927','2023-02-13 12:38:22'),(52,'8','215','2023-02-08',1,'51','','5',805625.00,'51','','','7','Kachako Lausu','51',1444625.40,'2023-02-09 13:19:22',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-16 14:30:17'),(53,'8','215','2023-02-09',1,'52','','5',639103.75,'52','','','7','Kachako Lausu','0001',639000.00,'2023-02-09 13:21:26',5,'Payments of PMS','960','927','2023-02-13 12:40:22','927','2023-02-13 12:40:34'),(54,'8','215','2023-02-09',1,'53','','5',565710.00,'53','','','7','Kachako Lausu','53',931710.45,'2023-02-10 10:22:19',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-16 14:26:57'),(55,'8','215','2023-02-09',1,'54','','10',366000.00,'54','','','7','Kachako Lausu','54',366000.00,'2023-02-10 10:23:47',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-16 14:26:57'),(56,'8','215','2023-02-11',1,'55','','5',1431900.00,'55','','','7','Kachako Lausu','55',1431900.00,'2023-02-12 09:28:15',5,'Payments of PMS','960','927','2023-02-13 12:30:38','927','2023-02-13 12:30:50'),(57,'8','215','2023-02-11',1,'56','','5',567710.00,'56','','','7','Kachako Lausu','0001',567000.00,'2023-02-12 09:29:46',5,'Payments of PMS','960','927','2023-02-13 12:34:02','927','2023-02-13 12:34:12'),(58,'8','215','2023-02-13',1,'57','','5',2503134.75,'57','','','7','Kachako Lausu','57',2502519.60,'2023-02-13 12:26:22',5,'Payments of PMS','960','927','2023-02-24 12:28:02','927','2023-02-24 12:28:16'),(59,'8','215','2023-02-13',1,'58','','5',650995.00,'58','','','7','Kachako Lausu','58',650994.30,'2023-02-14 08:57:11',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-24 12:25:47'),(60,'8','215','2023-02-18',1,'59','','5',801690.00,'59','','','7','Kachako Lausu','59',801692.80,'2023-02-20 10:13:24',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-24 12:25:47'),(61,'8','215','2023-02-19',1,'60','','5',1318855.00,'60','','','7','Kachako Lausu','60',1318856.60,'2023-02-20 10:19:57',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-24 12:25:47'),(62,'8','215','2023-02-20',1,'61','','5',928620.00,'61','','','7','Kachako Lausu','61',928618.20,'2023-02-21 08:31:29',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-24 12:25:47'),(63,'8','215','2023-02-21',1,'62','','5',734360.00,'62','','','7','Kachako Lausu','62',734359.20,'2023-02-22 12:32:19',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-02-24 12:25:47'),(64,'8','215','2023-02-22',1,'63','','5',827915.00,'63','','','7','Kachako Lausu','63',827913.60,'2023-02-23 08:41:23',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-01 16:44:25'),(65,'8','215','2023-02-23',1,'64','','5',968410.00,'64','','','7','Kachako Lausu','64',968409.00,'2023-02-24 08:21:55',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-01 16:39:13'),(66,'8','215','2023-02-24',1,'66','','5',703580.00,'66','','','7','Kachako Lausu','66',703577.60,'2023-02-26 22:34:37',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-01 16:39:13'),(67,'8','215','2023-02-26',1,'67','','5',1918515.00,'67','','','7','Kachako Lausu','67',1918512.00,'2023-02-27 10:25:24',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-01 16:39:13'),(68,'8','215','2023-02-27',1,'68','','5',851010.00,'68','','','7','Kachako Lausu','68',851008.00,'2023-02-28 10:21:54',5,'Payments of  PMS','960','','0000-00-00 00:00:00','927','2023-03-01 16:39:13'),(69,'8','215','2023-02-28',1,'69','','5',848725.00,'69','','','7','Kachako Lausu','69',848723.20,'2023-03-01 11:41:21',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-03 13:23:36'),(70,'8','215','2023-03-01',1,'70','','5',731320.00,'70','','','7','Kachako Lausu','70',731318.40,'2023-03-02 11:31:51',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-03 13:23:36'),(71,'8','215','2023-03-02',1,'71','','5',776810.00,'71','','','7','Kachako Lausu','71',776809.60,'2023-03-04 08:49:10',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-06 13:12:11'),(72,'8','215','2023-03-03',1,'72','','5',813515.00,'72','','','7','Kachako Lausu','72',813513.00,'2023-03-04 08:57:16',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-06 13:12:11'),(73,'8','215','2023-03-05',1,'73','','5',910200.00,'73','','','7','Kachako Lausu','73',910197.00,'2023-03-06 08:57:05',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-06 13:12:11'),(74,'8','215','2023-03-05',1,'74','','5',1497205.00,'74','','','7','Kachako Lausu','74',1497204.00,'2023-03-06 09:01:00',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-09 13:18:18'),(75,'8','215','2023-03-06',1,'75','','5',1105150.00,'75','','','7','Kachako Lausu','75',1105152.00,'2023-03-08 08:59:16',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-09 13:18:17'),(76,'8','215','2023-03-07',1,'76','','5',797255.00,'76','','','7','Kachako Lausu','76',797256.00,'2023-03-08 09:15:01',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-09 13:18:17'),(77,'8','215','2023-03-07',1,'77','','5',797255.00,'77','','','7','Kachako Lausu','77',797256.00,'2023-03-08 09:18:11',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-13 12:17:18'),(78,'8','215','2023-03-08',1,'78','','5',1044400.00,'78','','','7','Kachako Lausu','78',1044402.00,'2023-03-09 10:08:49',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-13 12:17:18'),(79,'8','215','2023-03-09',1,'79','','5',1313070.00,'79','','','7','Kachako Lausu','79',1313070.00,'2023-03-10 09:24:13',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-13 12:17:18'),(80,'8','215','2023-03-10',1,'80','','5',895660.00,'80','','','7','Kachako Lausu','80',895659.00,'2023-03-11 08:41:12',5,'Payments of PMS','960','','0000-00-00 00:00:00','927','2023-03-13 12:17:18'),(81,'8','215','2023-03-11',1,'81','','5',654805.00,'81','','','7','Kachako Lausu','81',654804.00,'2023-03-12 13:03:05',0,'Payments of PMS','960','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(82,'8','215','2023-03-12',1,'82','','5',1786785.00,'82','','','7','Kachako Lausu','82',1786785.00,'2023-03-13 09:35:11',0,'Payments of PMS','960','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(83,'8','215','2023-03-13',1,'83','','5',1527000.00,'83','','','7','Kachako Lausu','83',1526997.00,'2023-03-14 08:40:29',0,'Payments of PMS','960','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(84,'8','215','2023-03-14',1,'84','','5',1413230.00,'84','','','7','Kachako Lausu','84',1413231.00,'2023-03-15 09:17:39',0,'Payments of PMS','960','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(85,'8','215','2023-03-15',1,'85','','5',1399480.00,'85','','','7','Kachako Lausu','85',1399482.00,'2023-03-16 08:38:40',0,'Payments of PMS','960','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(86,'8','215','2023-03-16',1,'86','','5',1227665.00,'86','','','7','Kachako Lausu','86',1227666.00,'2023-03-17 08:09:56',0,'Payments of PMS','960','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(87,'8','215','2023-03-17',1,'87','','5',1419365.00,'87','','','7','Kachako Lausu','87',1419363.00,'2023-03-20 07:58:19',0,'Payments of  PMS','960','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(88,'8','215','2023-03-19',1,'88','','5',2195995.00,'88','','','7','Kachako Lausu','88',2195994.00,'2023-03-20 10:52:35',0,'Payments of PMS','960','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'8',2,'215',1,1,'2022-12-17 00:00:00','A A Rano Lagos',17000.00,17000.00,0.00,'001','','1','BCH242XA','Alaramma','07038288822','Delivery of PMS',5,'2022-12-17 11:35:27','960','0000-00-00 00:00:00','','2022-12-17 11:36:41','960'),(2,'8',1,'215',1,1,'2022-12-17 00:00:00','A A Rano Lagos',2800.00,2800.00,0.00,'002','','1','TRN44YZ','Shuaibu','08166136362','Delivery of PMS',5,'2022-12-17 11:42:46','960','0000-00-00 00:00:00','','2022-12-17 11:43:32','960'),(3,'8',3,'215',1,1,'2022-12-23 00:00:00','A A Rano Lagos',16200.00,16200.00,0.00,'003','','1','RAN33XF','Abdullahi','09066536097','Delivery of PMS',5,'2022-12-23 17:50:22','960','0000-00-00 00:00:00','','2022-12-23 17:52:50','960'),(4,'8',4,'215',1,1,'2023-01-01 00:00:00','A A Rano Lagos',16800.00,16800.00,0.00,'004','','1','RAN31XF','Shafiu','08038333810','Delivery of PMS',5,'2023-01-01 17:24:34','960','0000-00-00 00:00:00','','2023-01-01 17:26:02','960'),(5,'8',5,'215',1,1,'2023-01-06 00:00:00','A A Rano Lagos',32600.00,32600.00,0.00,'005','','1','RAN683XA','Shamsi','09032291031','Delivery of PMS',5,'2023-01-06 22:02:50','960','0000-00-00 00:00:00','','2023-01-06 22:03:41','960'),(6,'8',6,'215',1,1,'2023-01-18 00:00:00','A A Rano Lagos',15950.00,15950.00,0.00,'006','','1','RAN869XA','Usman','07066507909','Delivery of PMS',5,'2023-01-18 19:54:36','960','0000-00-00 00:00:00','','2023-01-18 19:55:35','960'),(7,'8',7,'215',1,1,'2023-01-22 00:00:00','A A Rano Lagos',16800.00,16800.00,0.00,'007','','1','RAN869XA','Usman','07066507909','Delivery of PMS',5,'2023-01-22 19:34:39','960','0000-00-00 00:00:00','','2023-01-22 19:35:18','960'),(8,'8',9,'215',1,1,'2023-01-31 00:00:00','A A Rano Lagos',17000.00,17000.00,0.00,'007','','1','BCH242XA','Alaramma','07038288822','Delivery of PMS',5,'2023-01-31 10:20:31','960','0000-00-00 00:00:00','','2023-01-31 10:21:15','960'),(9,'8',10,'215',1,1,'2023-02-05 00:00:00','A A Rano Lagos',16500.00,16500.00,0.00,'008','','1','WDL813XA','Hamisu','08025777097','Delivery of PMS',5,'2023-02-05 19:52:23','960','0000-00-00 00:00:00','','2023-02-05 19:53:31','960'),(10,'8',11,'215',1,1,'2023-02-11 00:00:00','A A Rano Lagos',14900.00,14900.00,0.00,'009','','1','RAN441XA','Daban Daban','08065000870','Delivery of PMS',5,'2023-02-11 18:22:47','960','0000-00-00 00:00:00','','2023-02-11 18:23:42','960'),(11,'8',12,'215',1,1,'2023-02-20 00:00:00','A A Rano Lagos',33600.00,33600.00,0.00,'010','','1','NSR433ZS','Yahaya','08143274058','Delivery of PMS',5,'2023-02-20 10:06:42','960','0000-00-00 00:00:00','','2023-02-20 10:07:20','960'),(12,'8',13,'215',1,1,'2023-02-24 00:00:00','A A Rano Lagos',16850.00,16850.00,0.00,'011','','1','RAN869XA','Usman','07066507909','Delivery of PMS',5,'2023-02-24 08:10:02','960','0000-00-00 00:00:00','','2023-02-24 08:11:15','960'),(13,'8',14,'215',1,1,'2023-02-28 00:00:00','A A Rano Lagos',18150.00,18150.00,0.00,'012','','1','RAN441XA','Daban Daban','08065000870','Delivery of PMS',5,'2023-02-28 22:46:59','960','0000-00-00 00:00:00','','2023-02-28 22:47:34','960'),(14,'8',15,'215',1,1,'2023-03-13 00:00:00','A A Rano Lagos',33200.00,33200.00,0.00,'12','','1','BCH248XA','Yellow','08034997784','Delivery of PMS',5,'2023-03-13 09:15:07','960','0000-00-00 00:00:00','','2023-03-13 09:16:17','960'),(15,'8',16,'215',1,1,'2023-03-16 00:00:00','A A Rano Lagos',15000.00,15000.00,0.00,'013','','1','RAN441XA','Daban Daban','08065000870','Delivery of PMS',5,'2023-03-16 19:45:36','960','0000-00-00 00:00:00','','2023-03-16 19:46:21','960');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'8','215','Lausu Energy Resources','Babangida Bashir','08063654848','info@','KANO','KANO','Lausu Energy Head office.','Nigeria',0.00,0.00,'0000-00-00','2022-10-16 01:36:19',5,'963','2022-10-16 01:36:19','963');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:57:15
