-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_8_station_214
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_8_station_214`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_8_station_214` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_8_station_214`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,2500,'',0,'2','8','214','UBA-0039769388','','2022-08-06 02:00:04',5,0.00,0.00,'','923','2022-08-06 02:00:04','923',0,0),(2,2501,'',0,'2','8','214','Keystone-1009080913','','2022-08-06 02:00:47',5,0.00,0.00,'','923','2022-08-06 02:00:47','923',0,0),(3,4000,'',0,'22','8','214','PURCHASES','','2022-08-06 02:01:12',5,0.00,0.00,'','923','2022-08-06 02:01:12','923',0,0),(4,7000,'',0,'20','8','214','SALES','','2022-08-06 02:01:24',5,0.00,0.00,'','923','2022-08-06 02:01:24','923',0,0),(5,500,'',0,'6.1','8','214','CASH','','2022-08-06 02:01:42',5,0.00,0.00,'','923','2022-08-06 02:01:42','923',0,0),(6,8000,'',0,'24','8','214','SALARIES & WAGES','','2022-08-06 02:02:01',5,0.00,0.00,'','923','2022-08-06 02:02:01','923',0,0),(7,8001,'',0,'24','8','214','PURCHASES','','2022-08-06 02:02:18',5,0.00,0.00,'','923','2022-08-06 02:02:18','923',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('8','214','1',1,'5','PMS PUMP 1',4379478.73,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-09 12:46:37','923'),('8','214','1',2,'5','PMS PUMP 2',514821.12,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-09 12:47:56','923'),('8','214','1',3,'5','PMS PUMP 3',753473.54,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-09 12:56:38','923'),('8','214','2',4,'5','PMS PUMP 5',358952.55,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-09 12:58:11','923'),('8','214','2',5,'5','PMS PUMP 4',2807079.64,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-09 12:57:29','923'),('8','214','2',6,'5','PMS PUMP 6',0.00,'PMS DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('8','214','3',7,'5','AGO PUMP ',0.00,'AGO DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('8','214',2,'001','2022-08-10','2022-08-10 07:29:54','2022-08-11 07:29:54','923',0.00,2367562.80,'923','2022-08-10 08:34:27','927','2022-08-10 09:42:03',10,0),('8','214',3,'002','2022-08-10','2022-08-11 07:55:08','2022-08-12 07:55:08','923',1226095.55,1226095.55,'923','2022-08-11 08:01:52','927','2022-08-12 14:11:38',10,0),('8','214',4,'03','2022-08-12','2022-08-12 14:50:11','2022-08-13 14:50:11','923',1199143.15,1199143.15,'923','2022-08-12 14:54:35','927','2022-08-12 22:04:46',10,0),('8','214',5,'04','2022-08-13','2022-08-13 08:36:15','2022-08-14 08:36:15','923',1230257.95,1230257.95,'923','2022-08-13 08:39:18','927','2022-08-13 21:58:02',10,0),('8','214',6,'05','2022-08-14','2022-08-14 08:19:12','2022-08-15 08:19:12','923',1111472.60,1111472.60,'923','2022-08-14 08:24:35','927','2022-08-14 09:51:43',10,0),('8','214',7,'06','2022-08-15','2022-08-15 09:22:54','2022-08-16 09:22:54','923',1086545.50,1086545.50,'923','2022-08-15 09:25:50','923','2022-08-16 09:40:52',10,0),('8','214',8,'07','2022-08-16','2022-08-16 09:41:45','2022-08-17 09:41:45','923',1160890.35,1160890.35,'923','2022-08-16 09:45:41','923','2022-08-20 10:14:30',10,0),('8','214',9,'07','2022-08-16','2022-08-20 10:16:10','2022-08-21 10:16:10','923',1423762.25,1370785.05,'923','2022-08-20 10:18:39','923','2022-08-20 10:19:27',10,0),('8','214',10,'08','2022-08-17','2022-08-20 10:22:18','2022-08-21 10:22:18','923',1064716.55,1025099.19,'923','2022-08-20 10:26:00','923','2022-08-20 10:26:38',10,0),('8','214',11,'08','2022-08-18','2022-08-20 10:30:00','2022-08-21 10:30:00','923',1186718.30,1142561.34,'923','2022-08-20 10:33:42','923','2022-08-20 10:34:14',10,0),('8','214',12,'09','2022-08-20','2022-08-20 10:47:49','2022-08-21 10:47:49','923',919284.10,885078.18,'923','2022-08-20 10:53:10','923','2022-08-20 10:54:48',10,0),('8','214',13,'09','2022-08-21','2022-08-21 07:47:35','2022-08-22 07:47:35','923',1140747.00,1098300.60,'923','2022-08-21 07:57:32','923','2022-08-21 19:33:22',10,0),('8','214',14,'10','2022-08-22','2022-08-22 12:32:44','2022-08-23 12:32:44','923',1255043.07,1212602.00,'923','2022-08-22 12:35:50','923','2022-08-23 07:43:47',10,0),('8','214',15,'10','2022-08-23','2022-08-23 07:45:17','2022-08-24 07:45:17','923',916631.19,885634.00,'923','2022-08-23 07:49:31','923','2022-08-23 11:53:34',10,0),('8','214',16,'11','2022-08-24','2022-08-24 08:00:30','2022-08-25 08:00:30','923',1395598.00,1395598.00,'923','2022-08-24 08:03:32','923','2022-08-24 17:30:40',10,0),('8','214',17,'12','2022-08-25','2022-08-25 07:38:15','2022-08-26 07:38:15','923',939342.00,892374.90,'923','2022-08-25 07:40:53','923','2022-08-25 07:41:27',10,0),('8','214',18,'12','2022-08-26','2022-08-26 08:01:44','2022-08-27 08:01:44','923',1034436.00,982714.20,'923','2022-08-26 08:04:33','923','2022-08-26 08:05:08',10,0),('8','214',19,'13','2022-08-27','2022-08-27 07:53:27','2022-08-28 07:53:27','923',1241462.00,1179388.90,'923','2022-08-28 15:35:35','923','2022-08-28 15:36:06',10,0),('8','214',20,'14','2022-08-28','2022-08-28 15:38:33','2022-08-29 15:38:33','923',1216716.00,1155880.20,'923','2022-08-28 18:58:10','923','2022-08-28 18:58:47',10,0),('8','214',21,'15','2022-08-29','2022-08-29 08:12:40','2022-08-30 08:12:40','923',1177730.64,1081008.80,'923','2022-08-29 08:15:16','923','2022-08-29 08:16:27',10,0),('8','214',22,'16','2022-08-30','2022-08-30 07:58:27','2022-08-31 07:58:27','923',1175890.41,1079319.70,'923','2022-08-30 08:00:28','923','2022-08-30 08:01:04',10,0),('8','214',23,'16','2022-08-31','2022-08-31 07:57:18','2022-09-01 07:57:18','923',2764154.20,2764154.20,'923','2022-08-31 07:59:17','923','2022-08-31 08:00:18',10,0),('8','214',24,'15','2022-09-01','2022-09-01 08:35:57','2022-09-02 08:35:57','923',1047895.60,1047895.60,'923','2022-09-01 08:40:34','923','2022-09-02 10:11:15',10,0),('8','214',25,'17','2022-09-02','2022-09-02 10:14:10','2022-09-03 10:14:10','923',1155581.90,1155581.90,'923','2022-09-02 10:16:16','923','2022-09-02 10:16:52',10,0),('8','214',26,'18','2022-09-03','2022-09-03 08:31:32','2022-09-04 08:31:32','923',1318926.80,1318926.80,'923','2022-09-03 08:39:46','923','2022-09-03 08:40:24',10,0),('8','214',27,'18','2022-09-04','2022-09-04 08:29:42','2022-09-05 08:29:42','923',1282501.90,1282501.90,'923','2022-09-04 08:31:39','923','2022-09-04 08:32:06',10,0),('8','214',28,'19','2022-09-05','2022-09-05 07:53:21','2022-09-06 07:53:21','923',880862.80,880862.80,'923','2022-09-05 07:55:40','923','2022-09-05 07:56:18',10,0),('8','214',29,'19','2022-09-06','2022-09-06 07:50:15','2022-09-07 07:50:15','923',823047.70,823047.70,'923','2022-09-06 07:52:06','923','2022-09-06 07:52:35',10,0),('8','214',30,'20','2022-09-07','2022-09-07 08:15:07','2022-09-08 08:15:07','923',1866998.90,1866998.90,'923','2022-09-07 08:16:58','923','2022-09-07 08:17:22',10,0),('8','214',31,'20','2022-09-08','2022-09-08 08:20:22','2022-09-09 08:20:22','923',671399.20,671399.20,'923','2022-09-08 08:23:17','923','2022-09-08 08:23:57',10,0),('8','214',32,'21','2022-09-09','2022-09-09 08:40:18','2022-09-10 08:40:18','923',854454.70,854454.70,'923','2022-09-09 08:42:11','923','2022-09-09 08:42:32',10,0),('8','214',33,'022','2022-09-10','2022-09-10 07:44:26','2022-09-11 07:44:26','923',572090.00,572090.00,'923','2022-09-10 07:46:21','923','2022-09-10 07:46:45',10,0),('8','214',34,'023','2022-09-11','2022-09-11 08:18:54','2022-09-12 08:18:54','923',589792.30,589792.30,'923','2022-09-11 08:21:18','923','2022-09-11 08:21:50',10,0),('8','214',35,'024','2022-09-12','2022-09-12 07:49:07','2022-09-13 07:49:07','923',662771.30,662771.30,'923','2022-09-12 07:51:09','923','2022-09-12 07:51:37',10,0),('8','214',36,'25','2022-09-13','2022-09-13 08:32:47','2022-09-14 08:32:47','923',1301220.70,1301220.70,'923','2022-09-13 09:48:18','923','2022-09-13 09:48:36',10,0),('8','214',37,'025','2022-09-14','2022-09-14 08:14:46','2022-09-15 08:14:46','923',2914252.30,2914252.30,'923','2022-09-14 08:16:43','923','2022-09-14 08:17:15',10,0),('8','214',38,'026','2022-09-15','2022-09-15 07:51:01','2022-09-16 07:51:01','923',944529.90,944529.90,'923','2022-09-15 07:52:36','923','2022-09-15 07:52:57',10,0),('8','214',39,'027','2022-09-16','2022-09-16 08:00:47','2022-09-17 08:00:47','923',1135006.80,1135006.80,'923','2022-09-16 15:28:12','923','2022-09-16 15:28:32',10,0),('8','214',40,'028','2022-09-17','2022-09-17 08:07:12','2022-09-18 08:07:12','923',1168192.20,1168192.20,'923','2022-09-17 08:10:30','923','2022-09-17 08:10:58',10,0),('8','214',41,'027','2022-09-18','2022-09-18 09:43:23','2022-09-19 09:43:23','923',1191094.80,1191094.80,'923','2022-09-18 09:44:47','923','2022-09-18 09:45:08',10,0),('8','214',42,'029','2022-09-20','2022-09-20 08:23:15','2022-09-21 08:23:15','923',1321079.50,1321079.50,'923','2022-09-20 08:25:04','923','2022-09-20 08:25:26',10,0),('8','214',43,'030','2022-09-20','2022-09-20 08:28:43','2022-09-21 08:28:43','923',1134590.70,1134590.70,'923','2022-09-20 08:30:08','923','2022-09-20 08:30:29',10,0),('8','214',44,'030','2022-09-21','2022-09-21 08:45:04','2022-09-22 08:45:04','923',2652852.20,2652852.20,'923','2022-09-21 08:47:02','923','2022-09-21 08:47:24',10,0),('8','214',45,'031','2022-09-22','2022-09-22 09:05:55','2022-09-23 09:05:55','923',1141702.40,1141702.40,'923','2022-09-22 09:08:20','923','2022-09-22 09:08:48',10,0),('8','214',46,'032','2022-09-23','2022-09-23 08:01:20','2022-09-24 08:01:20','923',1211793.40,1211793.40,'923','2022-09-23 08:03:01','923','2022-09-23 08:03:22',10,0),('8','214',47,'033','2022-09-24','2022-09-24 08:28:35','2022-09-25 08:28:35','923',1310044.30,1310044.30,'923','2022-09-24 08:30:17','923','2022-09-24 08:35:59',10,0),('8','214',48,'034','2022-09-25','2022-09-25 08:52:11','2022-09-26 08:52:11','923',1381161.30,1381161.30,'923','2022-09-25 10:48:46','923','2022-09-25 10:49:14',10,0),('8','214',49,'035','2022-09-26','2022-09-26 12:23:48','2022-09-27 12:23:48','923',1385464.80,1385464.80,'923','2022-09-26 12:25:39','923','2022-09-26 12:27:45',10,0),('8','214',50,'036','2022-09-27','2022-09-27 08:09:39','2022-09-28 08:09:39','923',1313542.20,1313542.20,'923','2022-09-27 08:11:31','923','2022-09-27 08:12:14',10,0),('8','214',51,'037','2022-09-28','2022-09-28 10:03:50','2022-09-29 10:03:50','923',3364012.70,3364012.70,'923','2022-09-28 10:05:35','923','2022-09-28 10:05:51',10,0),('8','214',52,'038','2022-09-29','2022-09-29 08:10:45','2022-09-30 08:10:45','923',873663.70,873663.70,'923','2022-09-29 10:53:07','923','2022-09-29 10:53:26',10,0),('8','214',53,'039','2022-09-30','2022-09-30 07:50:18','2022-10-01 07:50:18','923',668005.80,668005.80,'923','2022-09-30 07:52:06','923','2022-09-30 07:52:33',10,0),('8','214',54,'040','2022-10-01','2022-10-01 07:06:02','2022-10-02 07:06:02','923',835264.70,835264.70,'923','2022-10-01 07:07:39','923','2022-10-01 07:08:04',10,0),('8','214',55,'041','2022-10-02','2022-10-02 08:44:39','2022-10-03 08:44:39','923',872210.20,872210.20,'923','2022-10-02 08:46:38','923','2022-10-02 08:47:01',10,0),('8','214',56,'042','2022-10-03','2022-10-03 06:25:09','2022-10-04 06:25:09','923',720936.00,720936.00,'923','2022-10-03 06:28:01','923','2022-10-03 06:28:23',10,0),('8','214',57,'041','2022-10-03','2022-10-03 10:46:39','2022-10-04 10:46:39','923',302181.70,302181.70,'923','2022-10-03 10:49:20','923','2022-10-03 10:49:50',10,0),('8','214',58,'01','2022-10-04','2022-10-04 11:31:05','2022-10-05 11:31:05','923',391892.10,391892.10,'923','2022-10-04 15:03:53','923','2022-10-04 15:04:19',10,0),('8','214',59,'02','2022-10-05','2022-10-05 09:26:59','2022-10-06 09:26:59','923',0.00,0.00,'467','2022-10-07 12:39:21','467','2022-10-07 12:39:46',10,0),('8','214',60,'SHIFT','2022-10-07','2022-10-07 12:40:15','2022-10-14 12:40:15','467',2107924.60,0.00,'923','2022-10-07 14:06:08','923','2022-10-07 14:07:13',10,0),('8','214',61,'03','2022-10-07','2022-10-07 14:19:09','2022-10-08 14:19:09','923',1320300.50,1320300.50,'923','2022-10-07 14:21:08','923','2022-10-07 14:21:30',10,0),('8','214',62,'05','2022-10-07','2022-10-07 14:26:14','2022-10-08 14:26:14','923',207398.30,207398.30,'923','2022-10-07 14:27:39','923','2022-10-07 14:28:01',10,0),('8','214',63,'06','2022-10-08','2022-10-08 10:11:33','2022-10-09 10:11:33','923',588829.00,588829.00,'923','2022-10-08 10:12:50','923','2022-10-08 10:13:13',10,0),('8','214',64,'07','2022-10-09','2022-10-09 08:24:05','2022-10-10 08:24:05','923',1048608.10,1120354.97,'923','2022-10-09 08:25:31','923','2022-10-09 08:25:53',10,0),('8','214',65,'08','2022-10-10','2022-10-10 09:57:48','2022-10-11 09:57:48','923',1603955.30,1713699.61,'923','2022-10-10 13:23:14','923','2022-10-10 13:23:35',10,0),('8','214',66,'09','2022-10-11','2022-10-11 09:35:50','2022-10-12 09:35:50','923',2262950.62,2262950.62,'923','2022-10-11 10:19:04','923','2022-10-11 10:19:32',10,0),('8','214',67,'09','2022-10-12','2022-10-12 07:41:34','2022-10-13 07:41:34','923',2447871.44,2484046.88,'923','2022-10-12 10:09:40','923','2022-10-12 10:10:11',10,0),('8','214',68,'010','2022-10-13','2022-10-13 08:13:57','2022-10-14 08:13:57','923',1135261.26,1230332.40,'923','2022-10-22 10:40:55','923','2022-10-22 10:41:26',10,0),('8','214',69,'011','2022-10-22','2022-10-22 10:45:12','2022-10-23 10:45:12','923',1969290.60,1969290.60,'923','2022-10-22 10:49:03','923','2022-10-22 10:49:31',10,0),('8','214',70,'011','2022-10-23','2022-10-23 07:44:39','2022-10-24 07:44:39','923',1269007.05,1296007.20,'923','2022-10-23 07:46:02','923','2022-10-23 07:46:28',10,0),('8','214',71,'012','2022-10-24','2022-10-24 08:47:58','2022-10-25 08:47:58','923',958327.65,978717.60,'923','2022-10-27 11:15:26','923','2022-10-27 11:15:47',10,0),('8','214',72,'12','2022-10-27','2022-10-27 11:19:09','2022-10-28 11:19:09','923',2931921.60,2931921.60,'923','2022-10-27 11:20:03','923','2022-10-27 11:20:24',10,0),('8','214',73,'14','2022-10-27','2022-10-27 11:22:09','2022-10-28 11:22:09','923',1043961.60,1087460.00,'923','2022-10-27 11:23:21','923','2022-10-27 11:23:40',10,0),('8','214',74,'15','2022-10-28','2022-10-28 07:56:11','2022-10-29 07:56:11','923',738465.60,769235.00,'923','2022-11-06 10:20:29','923','2022-11-06 10:20:57',10,0),('8','214',75,'014','2022-11-06','2022-11-06 10:30:13','2022-11-07 10:30:13','923',1538927.55,1538927.55,'923','2022-11-06 10:31:59','923','2022-11-06 10:32:22',10,0),('8','214',76,'010','2022-11-07','2022-11-07 10:48:13','2022-11-08 10:48:13','923',1912076.70,1912076.70,'923','2022-11-07 11:12:29','923','2022-11-07 11:12:51',10,0),('8','214',77,'0012','2022-11-08','2022-11-08 06:27:59','2022-11-09 06:27:59','923',1696634.85,1696634.85,'923','2022-11-08 06:29:39','923','2022-11-08 06:30:38',10,0),('8','214',78,'0013','2022-11-09','2022-11-09 11:00:26','2022-11-10 11:00:26','923',3964130.55,3964130.55,'923','2022-11-09 13:35:06','923','2022-11-09 13:35:34',10,0),('8','214',79,'013','2022-11-10','2022-11-10 09:21:32','2022-11-11 09:21:32','923',1732186.95,1732186.95,'923','2022-11-10 09:23:03','923','2022-11-10 09:23:28',10,0),('8','214',80,'0012','2022-11-11','2022-11-11 08:18:53','2022-11-12 08:18:53','923',1144447.65,1144447.65,'923','2022-11-11 08:20:43','923','2022-11-11 08:21:07',10,0),('8','214',81,'013','2022-11-12','2022-11-12 08:44:48','2022-11-13 08:44:48','923',747762.00,747762.00,'923','2022-11-17 07:47:15','923','2022-11-17 07:47:43',10,0),('8','214',82,'0015','2022-11-17','2022-11-17 07:49:42','2022-11-18 07:49:42','923',1511757.30,1511757.30,'923','2022-11-17 07:50:51','923','2022-11-17 07:51:09',10,0),('8','214',83,'0016','2022-11-18','2022-11-18 08:47:22','2022-11-19 08:47:22','923',1823737.05,1823737.05,'923','2022-11-18 09:02:54','923','2022-11-18 09:03:19',10,0),('8','214',84,'0113','2022-11-20','2022-11-20 08:10:45','2022-11-21 08:10:45','923',939371.55,939371.55,'923','2022-11-20 18:15:00','923','2022-11-20 18:15:17',10,0),('8','214',85,'001','2022-11-21','2022-11-21 08:48:40','2022-11-22 08:48:40','923',1606776.60,1606776.60,'923','2022-11-21 08:50:16','923','2022-11-21 08:50:33',10,0),('8','214',86,'00010','2022-11-22','2022-11-22 08:47:26','2022-11-23 08:47:26','923',1813416.80,1813416.80,'923','2022-11-22 08:49:11','923','2022-11-22 08:49:44',10,0),('8','214',87,'0008','2022-11-23','2022-11-23 08:13:38','2022-11-24 08:13:38','923',4468588.80,4468588.80,'923','2022-11-23 08:15:24','923','2022-11-23 08:15:43',10,0),('8','214',88,'0101','2022-11-24','2022-11-24 08:32:11','2022-11-25 08:32:11','923',635887.20,635887.20,'923','2022-11-24 15:55:11','923','2022-11-24 15:55:30',10,0),('8','214',89,'0021','2022-11-25','2022-11-25 12:15:11','2022-11-26 12:15:11','923',1131702.00,1131702.00,'923','2022-11-25 12:24:58','923','2022-11-25 12:25:22',10,0),('8','214',90,'09','2022-11-26','2022-11-26 08:30:16','2022-11-27 08:30:16','923',1601451.80,1601451.80,'923','2022-11-26 08:32:03','923','2022-11-26 08:32:18',10,0),('8','214',91,'087','2022-11-27','2022-11-27 12:16:56','2022-11-28 12:16:56','923',1778610.60,1778610.60,'923','2022-11-27 12:18:37','923','2022-11-27 12:18:56',10,0),('8','214',92,'07','2022-11-28','2022-11-28 08:50:23','2022-11-29 08:50:23','923',1906998.60,1906998.60,'923','2022-11-28 08:52:10','923','2022-11-28 08:52:31',10,0),('8','214',93,'08','2022-11-29','2022-11-29 08:34:23','2022-11-30 08:34:23','923',1321450.00,1321450.00,'923','2022-11-29 08:35:45','923','2022-11-29 08:36:04',10,0),('8','214',94,'09','2022-11-30','2022-11-30 08:31:10','2022-12-01 08:31:10','923',1172732.60,1172732.60,'923','2022-12-07 08:03:26','923','2022-12-07 08:03:53',10,0),('8','214',95,'013','2022-12-07','2022-12-07 08:07:41','2022-12-08 08:07:41','923',6295201.20,6295201.20,'923','2022-12-07 08:09:39','923','2022-12-07 08:10:06',10,0),('8','214',96,'12','2022-12-08','2022-12-08 06:47:40','2022-12-09 06:47:40','923',2147137.20,2202803.72,'923','2022-12-15 08:36:26','923','2022-12-15 08:36:48',10,0),('8','214',97,'13','2022-12-15','2022-12-15 08:38:54','2022-12-16 08:38:54','923',605203.20,557171.20,'923','2022-12-15 08:40:58','923','2022-12-15 08:41:18',10,0),('8','214',98,'112','2022-12-15','2022-12-15 08:42:57','2022-12-16 08:42:57','923',514939.95,514939.95,'923','2022-12-15 08:44:48','923','2022-12-15 08:45:23',10,0),('8','214',99,'81','2022-12-16','2022-12-16 10:29:37','2022-12-17 10:29:37','923',1846366.20,1846366.20,'923','2022-12-16 11:42:45','923','2022-12-16 11:43:28',10,0),('8','214',100,'18','2022-12-17','2022-12-17 08:25:12','2022-12-18 08:25:12','923',1613924.55,1613924.55,'923','2022-12-17 08:27:02','923','2022-12-17 08:27:28',10,0),('8','214',101,'19','2022-12-18','2022-12-18 08:52:23','2022-12-19 08:52:23','923',1857334.50,1857334.50,'923','2022-12-18 08:54:15','923','2022-12-18 08:54:36',10,0),('8','214',102,'82','2022-12-19','2022-12-19 09:55:20','2022-12-20 09:55:20','923',1366233.75,1366233.75,'923','2022-12-19 17:15:33','923','2022-12-19 17:15:51',10,0),('8','214',103,'19','2022-12-20','2022-12-20 08:50:07','2022-12-21 08:50:07','923',1648108.35,1648108.35,'923','2022-12-20 12:19:22','923','2022-12-20 12:19:44',10,0),('8','214',104,'17','2022-12-21','2022-12-21 08:12:41','2022-12-22 08:12:41','923',4010627.25,4010627.25,'923','2022-12-21 08:14:56','923','2022-12-21 08:15:19',10,0),('8','214',105,'87','2022-12-22','2022-12-22 08:18:08','2022-12-23 08:18:08','923',1271368.35,1271368.35,'923','2022-12-22 08:19:21','923','2022-12-22 08:19:42',10,0),('8','214',106,'17','2022-12-23','2022-12-23 10:35:49','2022-12-24 10:35:49','923',1097267.85,1097267.85,'923','2022-12-26 08:08:47','923','2022-12-26 08:09:11',10,0),('8','214',107,'21','2022-12-26','2022-12-26 08:11:04','2022-12-27 08:11:04','923',374125.20,386391.60,'923','2022-12-26 08:12:09','923','2022-12-26 08:12:28',10,0),('8','214',108,'24','2022-12-26','2022-12-26 09:45:29','2022-12-27 09:45:29','923',2074780.80,2074780.80,'923','2022-12-26 11:08:24','923','2022-12-26 11:08:46',10,0),('8','214',109,'16','2022-12-27','2022-12-27 08:58:41','2022-12-28 08:58:41','923',1909949.65,1909949.65,'923','2022-12-27 08:59:41','923','2022-12-27 08:59:59',10,0),('8','214',110,'116','2022-12-29','2022-12-29 08:30:48','2022-12-30 08:30:48','923',1503180.30,1503180.30,'923','2022-12-29 15:27:09','923','2022-12-29 15:27:27',10,0),('8','214',111,'16','2022-12-30','2022-12-30 08:40:08','2022-12-31 08:40:08','923',1473807.00,1473807.00,'923','2022-12-30 08:42:19','923','2022-12-30 08:42:38',10,0),('8','214',112,'1011','2022-12-31','2022-12-31 08:37:06','2023-01-01 08:37:06','923',2087250.00,2087250.00,'923','2022-12-31 08:38:51','923','2022-12-31 08:39:15',10,0),('8','214',113,'77','2023-01-01','2023-01-01 11:11:21','2023-01-02 11:11:21','923',2271825.00,2271825.00,'923','2023-01-01 12:26:41','923','2023-01-01 12:27:03',10,0),('8','214',114,'81','2023-01-02','2023-01-02 12:21:31','2023-01-03 12:21:31','923',2094555.00,2094555.00,'923','2023-01-02 12:23:24','923','2023-01-02 12:24:18',10,0),('8','214',115,'18','2023-01-03','2023-01-03 11:27:44','2023-01-04 11:27:44','923',1863603.00,1863603.00,'923','2023-01-03 14:25:04','923','2023-01-03 14:25:27',10,0),('8','214',116,'76','2023-01-04','2023-01-04 09:28:45','2023-01-05 09:28:45','923',5252202.00,5252202.00,'923','2023-01-04 09:30:18','923','2023-01-04 09:30:40',10,0),('8','214',117,'21','2023-01-05','2023-01-05 08:47:45','2023-01-06 08:47:45','923',2300562.00,2300562.00,'923','2023-01-05 08:49:33','923','2023-01-05 08:49:53',10,0),('8','214',118,'176','2023-01-06','2023-01-06 10:01:23','2023-01-07 10:01:23','923',2124813.00,2124813.00,'923','2023-01-06 11:01:52','923','2023-01-06 11:02:10',10,0),('8','214',119,'089','2023-01-07','2023-01-07 10:58:19','2023-01-08 10:58:19','923',2156964.00,2156964.00,'923','2023-01-07 10:59:59','923','2023-01-07 11:00:17',10,0),('8','214',120,'098','2023-01-08','2023-01-08 11:00:36','2023-01-09 11:00:36','923',2748516.00,2748516.00,'923','2023-01-08 11:08:53','923','2023-01-08 11:09:16',10,0),('8','214',121,'718','2023-01-09','2023-01-09 08:58:21','2023-01-10 08:58:21','923',2310990.00,2310990.00,'923','2023-01-09 08:59:35','923','2023-01-09 08:59:56',10,0),('8','214',122,'170','2023-01-10','2023-01-10 08:58:17','2023-01-11 08:58:17','923',1922736.00,1922736.00,'923','2023-01-10 08:59:15','923','2023-01-10 08:59:37',10,0),('8','214',123,'179','2023-01-12','2023-01-12 10:54:38','2023-01-13 10:54:38','923',2784363.00,2784363.00,'923','2023-01-14 08:41:07','923','2023-01-14 08:41:24',10,0),('8','214',124,'18','2023-01-14','2023-01-14 08:43:04','2023-01-15 08:43:04','923',1589103.00,1589103.00,'923','2023-01-14 08:44:02','923','2023-01-14 08:44:23',10,0),('8','214',125,'19','2023-01-14','2023-01-14 08:45:58','2023-01-15 08:45:58','923',2088906.00,2088906.00,'923','2023-01-14 08:46:58','923','2023-01-14 08:47:21',10,0),('8','214',126,'185','2023-01-18','2023-01-18 08:08:53','2023-01-19 08:08:53','923',1395726.00,1395726.00,'923','2023-01-19 09:23:59','923','2023-01-19 09:24:18',10,0),('8','214',127,'177','2023-01-19','2023-01-19 09:31:26','2023-01-20 09:31:26','923',2505828.00,2505828.00,'923','2023-01-19 09:32:50','923','2023-01-19 09:33:12',10,0),('8','214',128,'180','2023-01-20','2023-01-20 09:45:39','2023-01-21 09:45:39','923',1472685.00,1472685.00,'923','2023-01-23 07:08:50','923','2023-01-23 07:09:16',10,0),('8','214',129,'128','2023-01-23','2023-01-23 07:11:17','2023-01-24 07:11:17','923',444315.06,435603.00,'923','2023-01-23 07:12:18','923','2023-01-23 07:12:36',10,0),('8','214',130,'129','2023-01-23','2023-01-23 07:14:33','2023-01-24 07:14:33','923',2379719.16,2379719.16,'923','2023-01-23 07:16:17','923','2023-01-23 07:16:39',10,0),('8','214',131,'130','2023-01-23','2023-01-23 07:18:42','2023-01-24 07:18:42','923',3154734.54,3154734.54,'923','2023-01-23 07:20:13','923','2023-01-23 07:20:29',10,0),('8','214',132,'135','2023-01-24','2023-01-24 09:48:13','2023-01-25 09:48:13','923',3101701.68,3101701.68,'923','2023-01-24 09:50:10','923','2023-01-24 09:50:27',10,0),('8','214',133,'112','2023-01-31','2023-01-31 07:25:15','2023-02-01 07:25:15','923',1443053.82,1306433.34,'923','2023-01-31 07:27:53','923','2023-01-31 07:28:11',10,0),('8','214',134,'113','2023-01-31','2023-01-31 07:29:03','2023-02-01 07:29:03','923',2154668.88,2154668.88,'923','2023-01-31 07:30:44','923','2023-01-31 07:31:05',10,0),('8','214',135,'134','2023-02-01','2023-02-01 09:33:55','2023-02-02 09:33:55','923',1847251.12,1885507.80,'923','2023-02-01 10:00:10','923','2023-02-01 10:00:31',10,0),('8','214',136,'136','2023-02-02','2023-02-03 06:24:10','2023-02-04 06:24:10','923',899982.46,918621.15,'923','2023-02-03 06:25:47','923','2023-02-03 06:26:20',10,0),('8','214',137,'137','2023-02-03','2023-02-03 06:58:18','2023-02-04 06:58:18','923',1658846.54,1693201.35,'923','2023-02-03 07:00:05','923','2023-02-03 07:00:38',10,0),('8','214',138,'144','2023-02-05','2023-02-05 16:51:51','2023-02-06 16:51:51','923',1885813.54,1924868.85,'923','2023-02-06 09:04:25','923','2023-02-06 09:04:52',10,0),('8','214',139,'127','2023-02-06','2023-02-06 09:15:59','2023-02-07 09:15:59','923',2116474.88,2160307.20,'923','2023-02-06 09:25:14','923','2023-02-06 09:25:35',10,0),('8','214',140,'146','2023-02-07','2023-02-07 09:21:19','2023-02-08 09:21:19','923',2003136.72,2044621.80,'923','2023-02-07 09:22:51','923','2023-02-07 09:23:12',10,0),('8','214',141,'227','2023-02-07','2023-02-07 21:03:55','2023-02-08 21:03:55','923',1694333.16,1729422.90,'923','2023-02-07 21:05:45','923','2023-02-08 08:49:35',10,0),('8','214',142,'147','2023-02-08','2023-02-08 08:59:21','2023-02-09 08:59:21','923',2638346.88,2692987.20,'923','2023-02-10 07:46:38','923','2023-02-10 07:47:08',10,0),('8','214',143,'143','2023-02-08','2023-02-10 07:51:16','2023-02-11 07:51:16','923',2314360.05,2314360.05,'923','2023-02-10 07:56:16','923','2023-02-10 07:57:16',10,0),('8','214',144,'145','2023-02-10','2023-02-10 08:01:08','2023-02-11 08:01:08','923',2771933.55,2771933.55,'923','2023-02-10 15:37:06','923','2023-02-10 15:37:37',10,0),('8','214',145,'145','2023-02-11','2023-02-11 16:18:33','2023-02-12 16:18:33','923',2557112.40,2557112.40,'923','2023-02-11 16:21:36','923','2023-02-11 16:22:25',10,0),('8','214',146,'145','2023-02-12','2023-02-12 15:40:44','2023-02-13 15:40:44','923',2322629.70,2322629.70,'923','2023-02-18 10:50:43','923','2023-02-18 10:51:26',10,0),('8','214',147,'146','2023-02-18','2023-02-18 10:54:42','2023-02-19 10:54:42','923',1365555.60,1385637.30,'923','2023-02-18 10:57:00','923','2023-02-18 10:57:49',10,0),('8','214',148,'148','2023-02-18','2023-02-18 11:00:44','2023-02-19 11:00:44','923',1938809.20,1938809.20,'923','2023-02-18 11:03:11','923','2023-02-18 11:04:00',10,0),('8','214',149,'148','2023-02-19','2023-02-19 09:04:00','2023-02-20 09:04:00','923',2008862.80,2008862.80,'923','2023-02-19 09:05:32','923','2023-02-19 09:05:55',10,0),('8','214',150,'149','2023-02-20','2023-02-20 18:01:37','2023-02-21 18:01:37','923',1931880.00,1931880.00,'923','2023-02-20 18:04:02','923','2023-02-20 18:04:32',10,0),('8','214',151,'150','2023-02-20','2023-02-24 08:42:33','2023-02-25 08:42:33','923',1049247.00,1189146.60,'923','2023-02-24 08:44:07','923','2023-02-24 08:44:45',10,0),('8','214',152,'152','2023-02-22','2023-02-24 08:49:46','2023-02-25 08:49:46','923',1779813.00,1779813.00,'923','2023-02-24 08:51:42','923','2023-02-24 08:52:19',10,0),('8','214',153,'153','2023-02-24','2023-02-24 08:55:45','2023-02-25 08:55:45','923',2229936.00,2229936.00,'923','2023-02-24 08:58:00','923','2023-02-24 08:58:26',10,0),('8','214',154,'154','2023-02-24','2023-02-26 11:13:04','2023-02-27 11:13:04','923',1845393.00,1845393.00,'923','2023-02-26 11:15:01','923','2023-02-26 11:15:27',10,0),('8','214',155,'155','2023-02-27','2023-02-27 09:06:28','2023-02-28 09:06:28','923',2285397.00,2285397.00,'923','2023-02-27 09:07:40','923','2023-03-01 09:17:35',10,0),('8','214',156,'156','2023-03-01','2023-03-01 09:21:36','2023-03-02 09:21:36','923',1703271.00,1703271.00,'923','2023-03-01 09:23:35','923','2023-03-01 09:23:55',10,0),('8','214',157,'157','2023-03-01','2023-03-02 09:31:35','2023-03-03 09:31:35','923',3592485.00,3592485.00,'923','2023-03-02 09:33:09','923','2023-03-02 09:33:27',10,0),('8','214',158,'158','2023-03-02','2023-03-02 09:36:12','2023-03-03 09:36:12','923',1643037.00,1643037.00,'923','2023-03-02 09:37:41','923','2023-03-02 09:38:02',10,0),('8','214',159,'157','2023-03-02','2023-03-03 20:32:16','2023-03-04 20:32:16','923',1755867.00,1755867.00,'923','2023-03-03 20:34:11','923','2023-03-03 20:34:28',10,0),('8','214',160,'159','2023-03-04','2023-03-04 09:25:47','2023-03-05 09:25:47','923',2225586.00,2225586.00,'923','2023-03-04 09:28:47','923','2023-03-04 09:29:19',10,0),('8','214',161,'160','2023-03-05','2023-03-05 18:56:52','2023-03-06 18:56:52','923',2023503.00,2023503.00,'923','2023-03-05 18:59:20','923','2023-03-05 18:59:41',10,0),('8','214',162,'162','2023-03-06','2023-03-06 10:31:30','2023-03-07 10:31:30','923',1554339.00,1554339.00,'923','2023-03-08 09:04:30','923','2023-03-08 09:04:47',10,0),('8','214',163,'163','2023-03-07','2023-03-08 09:07:55','2023-03-09 09:07:55','923',1727094.00,1727094.00,'923','2023-03-08 09:09:47','923','2023-03-08 09:12:39',10,0),('8','214',164,'163','2023-03-08','2023-03-08 09:13:19','2023-03-09 09:13:19','923',2955081.00,2955081.00,'923','2023-03-09 13:34:04','923','2023-03-09 13:34:21',10,0),('8','214',165,'165','2023-03-09','2023-03-09 13:36:05','2023-03-10 13:36:05','923',1382328.00,1382328.00,'923','2023-03-09 13:37:09','923','2023-03-09 13:37:31',10,0),('8','214',166,'167','2023-03-09','2023-03-14 08:23:05','2023-03-15 08:23:05','923',981882.00,981882.00,'923','2023-03-14 08:26:38','923','2023-03-14 08:27:04',10,0),('8','214',167,'167','2023-03-11','2023-03-14 08:30:48','2023-03-15 08:30:48','923',1807320.00,1807320.00,'923','2023-03-14 08:39:07','923','2023-03-14 08:39:32',10,0),('8','214',168,'168','2023-03-13','2023-03-14 08:47:50','2023-03-15 08:47:50','923',1543785.00,1543785.00,'923','2023-03-14 08:50:13','923','2023-03-14 09:01:17',10,0),('8','214',169,'169','2023-03-14','2023-03-16 09:35:05','2023-03-17 09:35:05','923',1540365.00,1540365.00,'923','2023-03-16 09:36:44','923','2023-03-16 09:37:06',10,0),('8','214',170,'170','2023-03-15','2023-03-16 09:38:31','2023-03-17 09:38:31','923',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',3,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1184 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('8','214','1','2',1,'1','1',4217843.97,4220495.06,2651.09,569984.35,0.00,0.00,0.00,0.00,0.00),('8','214','1','2',2,'2','1',265585.19,269037.66,3452.47,742281.05,0.00,0.00,0.00,0.00,0.00),('8','214','1','2',3,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','2',4,'4','1',22544.04,24914.21,2370.17,509586.55,0.00,0.00,0.00,0.00,0.00),('8','214','2','2',5,'5','1',2476613.54,2479151.73,2538.19,545710.85,0.00,0.00,0.00,0.00,0.00),('8','214','2','2',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','2',7,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','3',8,'1','1',4220495.06,4221509.41,1014.35,218085.25,0.00,0.00,0.00,0.00,0.00),('8','214','1','3',9,'2','1',269037.66,270217.09,1179.43,253577.45,0.00,0.00,0.00,0.00,0.00),('8','214','1','3',10,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','3',11,'4','1',24914.21,26095.91,1181.70,254065.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','3',12,'5','1',2479151.73,2481479.02,2327.29,500367.35,0.00,0.00,0.00,0.00,0.00),('8','214','2','3',13,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','3',14,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','4',15,'1','1',4221509.41,4222629.44,1120.03,240806.45,0.00,0.00,0.00,0.00,0.00),('8','214','1','4',16,'2','1',270217.09,271587.24,1370.15,294582.25,0.00,0.00,0.00,0.00,0.00),('8','214','1','4',17,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','4',18,'4','1',26095.91,27181.17,1085.26,233330.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','4',19,'5','1',2481479.02,2483480.99,2001.97,430423.55,0.00,0.00,0.00,0.00,0.00),('8','214','2','4',20,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','4',21,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','5',22,'1','1',4222629.44,4224066.55,1437.11,308978.65,0.00,0.00,0.00,0.00,0.00),('8','214','1','5',23,'2','1',271587.24,272466.84,879.60,189114.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','5',24,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','5',25,'4','1',27181.17,29728.53,2547.36,547682.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','5',26,'5','1',2483480.99,2484339.05,858.06,184482.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','5',27,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','5',28,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','6',29,'1','1',4224066.55,4224923.94,857.39,184338.85,0.00,0.00,0.00,0.00,0.00),('8','214','1','6',30,'2','1',272466.84,273335.22,868.38,186701.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','6',31,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','6',32,'4','1',29728.53,30981.96,1253.43,269487.45,0.00,0.00,0.00,0.00,0.00),('8','214','2','6',33,'5','1',2484339.05,2486529.49,2190.44,470944.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','6',34,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','6',35,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','7',36,'1','1',4224923.94,4226058.67,1134.73,243966.95,0.00,0.00,0.00,0.00,0.00),('8','214','1','7',37,'2','1',273335.22,274256.08,920.86,197984.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','7',38,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','7',39,'4','1',30981.96,31910.95,928.99,199732.85,0.00,0.00,0.00,0.00,0.00),('8','214','2','7',40,'5','1',2486529.49,2488598.61,2069.12,444860.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','7',41,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','7',42,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','8',43,'1','1',4226058.67,4227081.21,1022.54,219846.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','8',44,'2','1',274256.08,275862.99,1606.91,345485.65,0.00,0.00,0.00,0.00,0.00),('8','214','1','8',45,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','8',46,'4','1',31910.95,33059.49,1148.54,246936.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','8',47,'5','1',2488598.61,2490220.11,1621.50,348622.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','8',48,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','8',49,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','9',50,'1','1',4227081.21,4228778.61,1697.40,351361.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','9',51,'2','1',275862.99,278217.01,2354.02,487282.14,0.00,0.00,0.00,0.00,0.00),('8','214','1','9',52,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','9',53,'4','1',33059.49,34756.13,1696.64,351204.48,0.00,0.00,0.00,0.00,0.00),('8','214','2','9',54,'5','1',2490220.11,2491094.20,874.09,180936.63,0.00,0.00,0.00,0.00,0.00),('8','214','2','9',55,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','9',56,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','10',57,'1','1',4228778.61,4229525.01,746.40,154504.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','10',58,'2','1',278217.01,279512.61,1295.60,268189.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','10',59,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','10',60,'4','1',34756.13,34756.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','10',61,'5','1',2491094.20,2494004.37,2910.17,602405.19,0.00,0.00,0.00,0.00,0.00),('8','214','2','10',62,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','10',63,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','11',64,'1','1',4229525.01,4229707.26,182.25,37725.75,0.00,0.00,0.00,0.00,0.00),('8','214','1','11',65,'2','1',279512.61,281335.02,1822.41,377238.87,0.00,0.00,0.00,0.00,0.00),('8','214','1','11',66,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','11',67,'4','1',34756.13,37013.46,2257.33,467267.31,0.00,0.00,0.00,0.00,0.00),('8','214','2','11',68,'5','1',2494004.37,2495262.00,1257.63,260329.41,0.00,0.00,0.00,0.00,0.00),('8','214','2','11',69,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','11',70,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','12',71,'1','1',4229707.26,4230499.61,792.35,164016.45,0.00,0.00,0.00,0.00,0.00),('8','214','1','12',72,'2','1',281335.02,282370.53,1035.51,214350.57,0.00,0.00,0.00,0.00,0.00),('8','214','1','12',73,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','12',74,'4','1',37013.46,38651.65,1638.19,339105.33,0.00,0.00,0.00,0.00,0.00),('8','214','2','12',75,'5','1',2495262.00,2496071.69,809.69,167605.83,0.00,0.00,0.00,0.00,0.00),('8','214','2','12',76,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','12',77,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','13',78,'1','1',4230499.61,4231520.73,1021.12,211371.84,0.00,0.00,0.00,0.00,0.00),('8','214','1','13',79,'2','1',282370.53,283646.38,1275.85,264100.95,0.00,0.00,0.00,0.00,0.00),('8','214','1','13',80,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','13',81,'4','1',38651.65,39739.93,1088.28,225273.96,0.00,0.00,0.00,0.00,0.00),('8','214','2','13',82,'5','1',2496071.69,2497992.24,1920.55,397553.85,0.00,0.00,0.00,0.00,0.00),('8','214','2','13',83,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','13',84,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','14',85,'1','1',4231520.73,4232495.68,974.95,194990.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','14',86,'2','1',283646.38,285091.68,1445.30,289060.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','14',87,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','14',88,'4','1',39739.93,42246.69,2506.76,501352.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','14',89,'5','1',2497992.24,2499128.24,1136.00,227200.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','14',90,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','14',91,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','15',92,'1','1',4232495.68,4233452.97,957.29,191458.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','15',93,'2','1',285091.68,286371.38,1279.70,255940.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','15',94,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','15',95,'4','1',42246.69,43162.78,916.09,183218.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','15',96,'5','1',2499128.24,2500403.33,1275.09,255018.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','15',97,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','15',98,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','16',99,'1','1',4233452.97,4234875.32,1422.35,284470.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','16',100,'2','1',286371.38,288497.06,2125.68,425136.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','16',101,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','16',102,'4','1',43162.78,44505.42,1342.64,268528.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','16',103,'5','1',2500403.33,2502490.65,2087.32,417464.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','16',104,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','16',105,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','17',106,'1','1',4234875.32,4236032.50,1157.18,219864.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','17',107,'2','1',288497.06,289499.61,1002.55,190484.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','17',108,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','17',109,'4','1',44505.42,46232.59,1727.17,328162.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','17',110,'5','1',2502490.65,2503300.46,809.81,153863.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','17',111,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','17',112,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','18',113,'1','1',4236032.50,4237317.70,1285.20,244188.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','18',114,'2','1',289499.61,290863.12,1363.51,259066.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','18',115,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','18',116,'4','1',46232.59,48311.48,2078.89,394989.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','18',117,'5','1',2503300.46,2503745.04,444.58,84470.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','18',118,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','18',119,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','19',120,'1','1',4237317.70,4238668.52,1350.82,256655.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','19',121,'2','1',290863.12,292097.72,1234.60,234574.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','19',122,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','19',123,'4','1',48311.48,50691.30,2379.82,452165.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','19',124,'5','1',2503745.04,2504987.11,1242.07,235993.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','19',125,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','19',126,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','20',127,'1','1',4238668.52,4239811.59,1143.07,217183.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','20',128,'2','1',292097.72,293615.52,1517.80,288382.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','20',129,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','20',130,'4','1',50691.30,53043.34,2352.04,446887.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','20',131,'5','1',2504987.11,2506057.78,1070.67,203427.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','20',132,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','20',133,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','21',134,'1','1',4239811.59,4240930.74,1119.15,212638.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','21',135,'2','1',293615.52,294795.89,1180.37,224270.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','21',136,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','21',137,'4','1',53043.34,54129.61,1086.27,206391.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','21',138,'5','1',2506057.78,2508361.51,2303.73,437708.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','21',139,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','21',140,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','22',141,'1','1',4240930.74,4242260.84,1330.10,252719.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','22',142,'2','1',294795.89,296042.78,1246.89,236909.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','22',143,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','22',144,'4','1',54129.61,56410.55,2280.94,433378.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','22',145,'5','1',2508361.51,2509184.21,822.70,156313.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','22',146,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','22',147,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','23',148,'1','1',4242260.84,4245471.07,3210.23,609943.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','23',149,'2','1',296042.78,300378.85,4336.07,823853.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','23',150,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','23',151,'4','1',56410.55,59093.09,2682.54,509682.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','23',152,'5','1',2509184.21,2513503.55,4319.34,820674.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','23',153,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','23',154,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','24',155,'1','1',4245471.07,4246315.74,844.67,160487.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','24',156,'2','1',300378.85,301888.57,1509.72,286846.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','24',157,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','24',158,'4','1',59093.09,60204.52,1111.43,211171.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','24',159,'5','1',2513503.55,2515552.97,2049.42,389389.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','24',160,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','24',161,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','25',162,'1','1',4246315.74,4247835.37,1519.63,288729.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','25',163,'2','1',301888.57,303442.95,1554.38,295332.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','25',164,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','25',165,'4','1',60204.52,62351.87,2147.35,407996.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','25',166,'5','1',2515552.97,2516413.62,860.65,163523.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','25',167,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','25',168,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','26',169,'1','1',4247835.37,4249476.61,1641.24,311835.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','26',170,'2','1',303442.95,305465.88,2022.93,384356.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','26',171,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','26',172,'4','1',62351.87,64032.23,1680.36,319268.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','26',173,'5','1',2516413.62,2518010.81,1597.19,303466.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','26',174,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','26',175,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','27',176,'1','1',4249476.61,4250861.60,1384.99,263148.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','27',177,'2','1',305465.88,307501.38,2035.50,386745.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','27',178,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','27',179,'4','1',64032.23,65326.99,1294.76,246004.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','27',180,'5','1',2518010.81,2520045.57,2034.76,386604.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','27',181,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','27',182,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','28',183,'1','1',4250861.60,4251968.60,1107.00,210330.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','28',184,'2','1',307501.38,308556.76,1055.38,200522.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','28',185,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','28',186,'4','1',65326.99,66079.05,752.06,142891.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','28',187,'5','1',2520045.57,2521767.25,1721.68,327119.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','28',188,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','28',189,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','29',190,'1','1',4251968.60,4253077.70,1109.10,210729.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','29',191,'2','1',308556.76,309590.98,1034.22,196501.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','29',192,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','29',193,'4','1',66079.05,67094.07,1015.02,192853.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','29',194,'5','1',2521767.25,2522940.74,1173.49,222963.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','29',195,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','29',196,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','30',197,'1','1',4253077.70,4254989.70,1912.00,363280.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','30',198,'2','1',309590.98,312177.47,2586.49,491433.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','30',199,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','30',200,'4','1',67094.07,69666.72,2572.65,488803.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','30',201,'5','1',2522940.74,2525695.91,2755.17,523482.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','30',202,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','30',203,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','31',204,'1','1',4254989.70,4256109.70,1120.00,212800.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','31',205,'2','1',312177.47,313182.68,1005.21,190989.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','31',206,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','31',207,'4','1',69666.72,70461.66,794.94,151038.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','31',208,'5','1',2525695.91,2526309.44,613.53,116570.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','31',209,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','31',210,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','32',211,'1','1',4256109.70,4257013.06,903.36,171638.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','32',212,'2','1',313182.68,314920.05,1737.37,330100.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','32',213,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','32',214,'4','1',70461.66,71123.58,661.92,125764.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','32',215,'5','1',2526309.44,2527503.92,1194.48,226951.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','32',216,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','32',217,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','33',218,'1','1',4257013.06,4257672.21,659.15,125238.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','33',219,'2','1',314920.05,315717.86,797.81,151583.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','33',220,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','33',221,'4','1',71123.58,72041.90,918.32,174480.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','33',222,'5','1',2527503.92,2528139.64,635.72,120786.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','33',223,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','33',224,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','34',225,'1','1',4257672.21,4258358.61,686.40,130416.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','34',226,'2','1',315717.86,316721.74,1003.88,190737.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','34',227,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','34',228,'4','1',72041.90,72693.19,651.29,123745.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','34',229,'5','1',2528139.64,2528902.24,762.60,144894.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','34',230,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','34',231,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','35',232,'1','1',4258358.61,4259287.01,928.40,176396.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','35',233,'2','1',316721.74,317669.83,948.09,180137.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','35',234,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','35',235,'4','1',72693.19,73811.01,1117.82,212385.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','35',236,'5','1',2528902.24,2529396.20,493.96,93852.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','35',237,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','35',238,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','36',239,'1','1',4259287.01,4260476.08,1189.07,225923.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','36',240,'2','1',317669.83,319615.63,1945.80,369702.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','36',241,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','36',242,'4','1',73811.01,74967.28,1156.27,219691.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','36',243,'5','1',2529396.20,2531953.59,2557.39,485904.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','36',244,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','36',245,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','37',246,'1','1',4260476.08,4264094.42,3618.34,687484.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','37',247,'2','1',319615.63,324181.08,4565.45,867435.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','37',248,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','37',249,'4','1',74967.28,79172.18,4204.90,798931.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','37',250,'5','1',2531953.59,2534903.07,2949.48,560401.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','37',251,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','37',252,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','38',253,'1','1',4264094.42,4265030.05,935.63,177769.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','38',254,'2','1',324181.08,325893.00,1711.92,325264.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','38',255,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','38',256,'4','1',79172.18,80587.45,1415.27,268901.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','38',257,'5','1',2534903.07,2535811.46,908.39,172594.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','38',258,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','38',259,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','39',260,'1','1',4265030.05,4266178.28,1148.23,218163.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','39',261,'2','1',325893.00,327971.29,2078.29,394875.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','39',262,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','39',263,'4','1',80587.45,81481.17,893.72,169806.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','39',264,'5','1',2535811.46,2537664.94,1853.48,352161.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','39',265,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','39',266,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','40',267,'1','1',4266178.28,4267412.40,1234.12,234482.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','40',268,'2','1',327971.29,330031.43,2060.14,391426.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','40',269,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','40',270,'4','1',81481.17,83247.52,1766.35,335606.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','40',271,'5','1',2537664.94,2538752.71,1087.77,206676.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','40',272,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','40',273,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','41',274,'1','1',4267412.40,4268615.59,1203.19,228606.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','41',275,'2','1',330031.43,331402.95,1371.52,260588.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','41',276,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','41',277,'4','1',83247.52,84884.64,1637.12,311052.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','41',278,'5','1',2538752.71,2540809.80,2057.09,390847.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','41',279,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','41',280,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','42',281,'1','1',4268615.59,4269658.20,1042.61,198095.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','42',282,'2','1',331402.95,333903.26,2500.31,475058.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','42',283,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','42',284,'4','1',84884.64,87154.27,2269.63,431229.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','42',285,'5','1',2540809.80,2541950.30,1140.50,216695.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','42',286,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','42',287,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','43',288,'1','1',4269658.20,4270732.04,1073.84,204029.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','43',289,'2','1',333903.26,336247.74,2344.48,445451.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','43',290,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','43',291,'4','1',87154.27,87967.32,813.05,154479.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','43',292,'5','1',2541950.30,2543690.46,1740.16,330630.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','43',293,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','43',294,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','44',295,'1','1',4270732.04,4273375.56,2643.52,502268.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','44',296,'2','1',336247.74,340158.39,3910.65,743023.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','44',297,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','44',298,'4','1',87967.32,92104.84,4137.52,786128.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','44',299,'5','1',2543690.46,2546961.15,3270.69,621431.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','44',300,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','44',301,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','45',302,'1','1',4273375.56,4274398.18,1022.62,194297.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','45',303,'2','1',340158.39,342121.04,1962.65,372903.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','45',304,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','45',305,'4','1',92104.84,93486.58,1381.74,262530.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','45',306,'5','1',2546961.15,2548603.10,1641.95,311970.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','45',307,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','45',308,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','46',309,'1','1',4274398.18,4276631.96,2233.78,424418.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','46',310,'2','1',342121.04,343568.48,1447.44,275013.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','46',311,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','46',312,'4','1',93486.58,95090.40,1603.82,304725.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','46',313,'5','1',2548603.10,2549695.92,1092.82,207635.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','46',314,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','46',315,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','47',316,'1','1',4276631.96,4278216.87,1584.91,301132.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','47',317,'2','1',343568.48,345394.41,1825.93,346926.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','47',318,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','47',319,'4','1',95090.40,97077.67,1987.27,377581.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','47',320,'5','1',2549695.92,2551192.78,1496.86,284403.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','47',321,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','47',322,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','48',323,'1','1',4278216.87,4279355.33,1138.46,216307.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','48',324,'2','1',345394.41,347910.74,2516.33,478102.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','48',325,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','48',326,'4','1',97077.67,98474.76,1397.09,265447.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','48',327,'5','1',2551192.78,2553410.17,2217.39,421304.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','48',328,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','48',329,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','49',330,'1','1',4279355.33,4280873.62,1518.29,288475.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','49',331,'2','1',347910.74,350242.77,2332.03,443085.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','49',332,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','49',333,'4','1',98474.76,100676.59,2201.83,418347.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','49',334,'5','1',2553410.17,2554649.94,1239.77,235556.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','49',335,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','49',336,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','50',337,'1','1',4280873.62,4282153.33,1279.71,243144.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','50',338,'2','1',350242.77,353079.88,2837.11,539050.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','50',339,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','50',340,'4','1',100676.59,101918.29,1241.70,235923.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','50',341,'5','1',2554649.94,2556204.80,1554.86,295423.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','50',342,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','50',343,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','51',344,'1','1',4282153.33,4285942.16,3788.83,719877.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','51',345,'2','1',353079.88,357561.91,4482.03,851585.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','51',346,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','51',347,'4','1',101918.29,107354.78,5436.49,1032933.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','51',348,'5','1',2556204.80,2560202.78,3997.98,759616.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','51',349,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','51',350,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','52',351,'1','1',4285942.16,4286708.72,766.56,145646.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','52',352,'2','1',357561.91,359203.29,1641.38,311862.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','52',353,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','52',354,'4','1',107354.78,108906.28,1551.50,294785.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','52',355,'5','1',2560202.78,2560841.57,638.79,121370.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','52',356,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','52',357,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','53',358,'1','1',4286708.72,4287447.42,738.70,140353.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','53',359,'2','1',359203.29,360592.53,1389.24,263955.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','53',360,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','53',361,'4','1',108906.28,109421.54,515.26,97899.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','53',362,'5','1',2560841.57,2561714.19,872.62,165797.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','53',363,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','53',364,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','54',365,'1','1',4287447.42,4288289.14,841.72,159926.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','54',366,'2','1',360592.53,361861.42,1268.89,241089.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','54',367,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','54',368,'4','1',109421.54,110754.40,1332.86,253243.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','54',369,'5','1',2561714.19,2562666.85,952.66,181005.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','54',370,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','54',371,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','55',372,'1','1',4288289.14,4288904.76,615.62,116967.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','55',373,'2','1',361861.42,363435.97,1574.55,299164.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','55',374,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','55',375,'4','1',110754.40,111397.74,643.34,122234.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','55',376,'5','1',2562666.85,2564423.92,1757.07,333843.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','55',377,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','55',378,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','56',379,'1','1',4288904.76,4289976.80,1072.04,203687.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','56',380,'2','1',363435.97,364231.57,795.60,151164.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','56',381,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','56',382,'4','1',111397.74,112022.95,625.21,118789.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','56',383,'5','1',2564423.92,2565725.47,1301.55,247294.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','56',384,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','56',385,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','57',386,'1','1',4289976.80,4289976.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','57',387,'2','1',364231.57,365007.95,776.38,147512.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','57',388,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','57',389,'4','1',112022.95,112541.13,518.18,98454.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','57',390,'5','1',2565725.47,2566021.34,295.87,56215.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','57',391,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','57',392,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','58',393,'1','1',4289976.80,4290516.34,539.54,102512.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','58',394,'2','1',365007.95,366156.36,1148.41,218197.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','58',395,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','58',396,'4','1',112541.13,112785.03,243.90,46341.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','58',397,'5','1',2566021.34,2566152.08,130.74,24840.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','58',398,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','58',399,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','59',400,'1','1',4290516.34,4290516.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','59',401,'2','1',366156.36,366156.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','59',402,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','59',403,'4','1',112785.03,112785.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','59',404,'5','1',2566152.08,2566152.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','59',405,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','59',406,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','60',407,'1','1',4290516.34,4293418.52,2902.18,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','60',408,'2','1',366156.36,369923.95,3767.59,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','60',409,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','60',410,'5','1',2566152.08,2568177.38,2025.30,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','60',411,'4','1',112785.03,115184.30,2399.27,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','60',412,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','60',413,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','61',414,'1','1',4293418.52,4296744.77,3326.25,631987.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','61',415,'2','1',369923.95,373546.65,3622.70,688313.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','61',416,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','61',417,'5','1',2568177.38,2568177.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','61',418,'4','1',115184.30,115184.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','61',419,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','61',420,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','62',421,'1','1',4296744.77,4297145.70,400.93,76176.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','62',422,'2','1',373546.65,374237.29,690.64,131221.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','62',423,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','62',424,'4','1',115184.30,115184.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','62',425,'5','1',2568177.38,2568177.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','62',426,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','62',427,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','63',428,'1','1',4297145.70,4297145.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','63',429,'2','1',374237.29,374237.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','63',430,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','63',431,'4','1',115184.30,116644.84,1460.54,277502.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','63',432,'5','1',2568177.38,2569815.94,1638.56,311326.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','63',433,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','63',434,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','64',435,'1','1',4297145.70,4297145.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','64',436,'2','1',374237.29,374237.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','64',437,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','64',438,'4','1',116644.84,119421.36,2776.52,563633.56,0.00,0.00,0.00,0.00,0.00),('8','214','2','64',439,'5','1',2569815.94,2572558.41,2742.47,556721.41,0.00,0.00,0.00,0.00,0.00),('8','214','2','64',440,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','64',441,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','65',442,'1','1',4297145.70,4297145.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','65',443,'2','1',374237.29,374237.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','65',444,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','65',445,'4','1',119421.36,123964.45,4543.09,922247.27,0.00,0.00,0.00,0.00,0.00),('8','214','2','65',446,'5','1',2572558.41,2576457.19,3898.78,791452.34,0.00,0.00,0.00,0.00,0.00),('8','214','2','65',447,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','65',448,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','66',449,'1','1',4297145.70,4299130.17,1984.47,402847.41,0.00,0.00,0.00,0.00,0.00),('8','214','1','66',450,'2','1',374237.29,377033.87,2796.58,567705.74,0.00,0.00,0.00,0.00,0.00),('8','214','1','66',451,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','66',452,'4','1',123964.45,128153.23,4188.78,850322.34,0.00,0.00,0.00,0.00,0.00),('8','214','2','66',453,'5','1',2576457.19,2578634.90,2177.71,442075.13,0.00,0.00,0.00,0.00,0.00),('8','214','2','66',454,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','66',455,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','67',456,'1','1',4299130.17,4301792.79,2662.62,548499.72,0.00,0.00,0.00,0.00,0.00),('8','214','1','67',457,'2','1',377033.87,380566.38,3532.51,727697.06,0.00,0.00,0.00,0.00,0.00),('8','214','1','67',458,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','67',459,'4','1',128153.23,130659.11,2505.88,516211.28,0.00,0.00,0.00,0.00,0.00),('8','214','2','67',460,'5','1',2578634.90,2581992.37,3357.47,691638.82,0.00,0.00,0.00,0.00,0.00),('8','214','2','67',461,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','67',462,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','68',463,'1','1',4301792.79,4303054.05,1261.26,277477.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','68',464,'2','1',380566.38,382593.22,2026.84,445904.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','68',465,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','68',466,'4','1',130659.11,131527.46,868.35,191037.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','68',467,'5','1',2581992.37,2583428.34,1435.97,315913.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','68',468,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','68',469,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','69',470,'1','1',4303054.05,4303054.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','69',471,'2','1',382593.22,382593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','69',472,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','69',473,'4','1',131527.46,135710.00,4182.54,982896.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','69',474,'5','1',2583428.34,2587625.76,4197.42,986393.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','69',475,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','69',476,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','70',477,'1','1',4303054.05,4303054.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','70',478,'2','1',382593.22,382593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','70',479,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','70',480,'4','1',135710.00,138379.74,2669.74,640737.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','70',481,'5','1',2587625.76,2590356.05,2730.29,655269.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','70',482,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','70',483,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','71',484,'1','1',4303054.05,4303054.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','71',485,'2','1',382593.22,382593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','71',486,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','71',487,'4','1',138379.74,140475.70,2095.96,503030.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','71',488,'5','1',2590356.05,2592338.08,1982.03,475687.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','71',489,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','71',490,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','72',491,'1','1',4303054.05,4303054.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','72',492,'2','1',382593.22,382593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','72',493,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','72',494,'4','1',140475.70,146425.31,5949.61,1427906.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','72',495,'5','1',2592338.08,2598604.81,6266.73,1504015.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','72',496,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','72',497,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','73',498,'1','1',4303054.05,4303054.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','73',499,'2','1',382593.22,382593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','73',500,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','73',501,'4','1',146425.31,148736.29,2310.98,577745.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','73',502,'5','1',2598604.81,2600643.67,2038.86,509715.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','73',503,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','73',504,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','74',505,'1','1',4303054.05,4303054.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','74',506,'2','1',382593.22,382593.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','74',507,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','74',508,'4','1',148736.29,150517.45,1781.16,445290.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','74',509,'5','1',2600643.67,2601939.45,1295.78,323945.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','74',510,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','74',511,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','75',512,'1','1',4303054.05,4304205.44,1151.39,293604.45,0.00,0.00,0.00,0.00,0.00),('8','214','1','75',513,'2','1',382593.22,384643.33,2050.11,522778.05,0.00,0.00,0.00,0.00,0.00),('8','214','1','75',514,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','75',515,'4','1',150517.45,152114.73,1597.28,407306.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','75',516,'5','1',2601939.45,2603175.68,1236.23,315238.65,0.00,0.00,0.00,0.00,0.00),('8','214','2','75',517,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','75',518,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','76',519,'1','1',4304205.44,4305783.97,1578.53,402525.15,0.00,0.00,0.00,0.00,0.00),('8','214','1','76',520,'2','1',384643.33,387536.47,2893.14,737750.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','76',521,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','76',522,'4','1',152114.73,153199.32,1084.59,276570.45,0.00,0.00,0.00,0.00,0.00),('8','214','2','76',523,'5','1',2603175.68,2605117.76,1942.08,495230.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','76',524,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','76',525,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','77',526,'1','1',4305783.97,4307284.92,1500.95,382742.25,0.00,0.00,0.00,0.00,0.00),('8','214','1','77',527,'2','1',387536.47,390292.49,2756.02,702785.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','77',528,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','77',529,'4','1',153199.32,153199.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','77',530,'5','1',2605117.76,2607514.26,2396.50,611107.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','77',531,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','77',532,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','78',533,'1','1',4307284.92,4309415.07,2130.15,543188.25,0.00,0.00,0.00,0.00,0.00),('8','214','1','78',534,'2','1',390292.49,392664.32,2371.83,604816.65,0.00,0.00,0.00,0.00,0.00),('8','214','1','78',535,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','78',536,'4','1',153199.32,158923.80,5724.48,1459742.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','78',537,'5','1',2607514.26,2612833.41,5319.15,1356383.25,0.00,0.00,0.00,0.00,0.00),('8','214','2','78',538,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','78',539,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','79',540,'1','1',4309415.07,4309415.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','79',541,'2','1',392664.32,392664.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','79',542,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','79',543,'4','1',158923.80,162191.11,3267.31,833164.05,0.00,0.00,0.00,0.00,0.00),('8','214','2','79',544,'5','1',2612833.41,2616358.99,3525.58,899022.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','79',545,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','79',546,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','80',547,'1','1',4309415.07,4309415.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','80',548,'2','1',392664.32,392664.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','80',549,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','80',550,'4','1',162191.11,164389.63,2198.52,560622.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','80',551,'5','1',2616358.99,2618648.50,2289.51,583825.05,0.00,0.00,0.00,0.00,0.00),('8','214','2','80',552,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','80',553,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','81',554,'1','1',4309415.07,4309415.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','81',555,'2','1',392664.32,392664.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','81',556,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','81',557,'4','1',164389.63,166011.15,1621.52,413487.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','81',558,'5','1',2618648.50,2619959.38,1310.88,334274.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','81',559,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','81',560,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','82',561,'1','1',4309415.07,4309415.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','82',562,'2','1',392664.32,392664.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','82',563,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','82',564,'4','1',166011.15,169319.92,3308.77,843736.35,0.00,0.00,0.00,0.00,0.00),('8','214','2','82',565,'5','1',2619959.38,2622579.07,2619.69,668020.95,0.00,0.00,0.00,0.00,0.00),('8','214','2','82',566,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','82',567,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','83',568,'1','1',4309415.07,4309415.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','83',569,'2','1',392664.32,392664.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','83',570,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','83',571,'4','1',169319.92,173173.42,3853.50,982642.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','83',572,'5','1',2622579.07,2625877.48,3298.41,841094.55,0.00,0.00,0.00,0.00,0.00),('8','214','2','83',573,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','83',574,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','84',575,'1','1',4309415.07,4309415.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','84',576,'2','1',392664.32,392664.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','84',577,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','84',578,'4','1',173173.42,174872.29,1698.87,433211.85,0.00,0.00,0.00,0.00,0.00),('8','214','2','84',579,'5','1',2625877.48,2627862.42,1984.94,506159.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','84',580,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','84',581,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','85',582,'1','1',4309415.07,4310129.86,714.79,185845.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','85',583,'2','1',392664.32,394386.92,1722.60,447876.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','85',584,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','85',585,'4','1',174872.29,176550.05,1677.76,436217.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','85',586,'5','1',2627862.42,2629927.18,2064.76,536837.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','85',587,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','85',588,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','86',589,'1','1',4310129.86,4312835.81,2705.95,703547.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','86',590,'2','1',394386.92,395995.41,1608.49,418207.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','86',591,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','86',592,'4','1',176550.05,177660.14,1110.09,288623.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','86',593,'5','1',2629927.18,2631477.33,1550.15,403039.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','86',594,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','86',595,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','87',596,'1','1',4312835.81,4316984.34,4148.53,1078617.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','87',597,'2','1',395995.41,401343.57,5348.16,1390521.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','87',598,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','87',599,'4','1',177660.14,181385.61,3725.47,968622.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','87',600,'5','1',2631477.33,2635442.05,3964.72,1030827.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','87',601,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','87',602,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','88',603,'1','1',4316984.34,4316984.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','88',604,'2','1',401343.57,401399.21,55.64,14466.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','88',605,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','88',606,'4','1',181385.61,182542.52,1156.91,300796.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','88',607,'5','1',2635442.05,2636675.22,1233.17,320624.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','88',608,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','88',609,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','89',610,'1','1',4316984.34,4318497.45,1513.11,393408.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','89',611,'2','1',401399.21,402534.13,1134.92,295079.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','89',612,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','89',613,'4','1',182542.52,183629.57,1087.05,282633.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','89',614,'5','1',2636675.22,2637292.84,617.62,160581.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','89',615,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','89',616,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','90',617,'1','1',4318497.45,4319733.23,1235.78,321302.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','90',618,'2','1',402534.13,402552.58,18.45,4797.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','90',619,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','90',620,'4','1',183629.57,186653.70,3024.13,786273.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','90',621,'5','1',2637292.84,2639173.91,1881.07,489078.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','90',622,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','90',623,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','91',624,'1','1',4319733.23,4320081.06,347.83,90435.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','91',625,'2','1',402552.58,404736.31,2183.73,567769.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','91',626,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','91',627,'4','1',186653.70,187701.79,1048.09,272503.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','91',628,'5','1',2639173.91,2642435.07,3261.16,847901.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','91',629,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','91',630,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','92',631,'1','1',4320081.06,4321312.44,1231.38,320158.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','92',632,'2','1',404736.31,407587.18,2850.87,741226.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','92',633,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','92',634,'4','1',187701.79,189428.79,1727.00,449020.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','92',635,'5','1',2642435.07,2643960.43,1525.36,396593.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','92',636,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','92',637,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','93',638,'1','1',4321312.44,4323154.26,1841.82,478873.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','93',639,'2','1',407587.18,408320.36,733.18,190626.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','93',640,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','93',641,'4','1',189428.79,191936.29,2507.50,651950.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','93',642,'5','1',2643960.43,2643960.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','93',643,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','93',644,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','94',645,'1','1',4323154.26,4323783.91,629.65,163709.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','94',646,'2','1',408320.36,409384.56,1064.20,276692.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','94',647,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','94',648,'4','1',191936.29,193590.98,1654.69,430219.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','94',649,'5','1',2643960.43,2645122.40,1161.97,302112.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','94',650,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','94',651,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','95',652,'1','1',4323783.91,4329083.52,5299.61,1430894.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','95',653,'2','1',409384.56,416363.15,6978.59,1884219.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','95',654,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','95',655,'4','1',193590.98,199408.70,5817.72,1570784.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','95',656,'5','1',2645122.40,2650342.04,5219.64,1409302.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','95',657,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','95',658,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','96',659,'1','1',4329083.52,4329885.52,802.00,222154.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','96',660,'2','1',416363.15,418995.89,2632.74,729268.98,0.00,0.00,0.00,0.00,0.00),('8','214','1','96',661,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','96',662,'4','1',199408.70,201574.72,2166.02,599987.54,0.00,0.00,0.00,0.00,0.00),('8','214','2','96',663,'5','1',2650342.04,2652693.64,2351.60,651393.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','96',664,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','96',665,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','97',666,'1','1',4329885.52,4330128.79,243.27,70548.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','97',667,'2','1',418995.89,419744.83,748.94,217192.60,0.00,0.00,0.00,0.00,0.00),('8','214','1','97',668,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','97',669,'4','1',201574.72,202109.07,534.35,154961.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','97',670,'5','1',2652693.64,2653088.36,394.72,114468.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','97',671,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','97',672,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','98',673,'1','1',4330128.79,4330399.92,271.13,85405.95,0.00,0.00,0.00,0.00,0.00),('8','214','1','98',674,'2','1',419744.83,420189.34,444.51,140020.65,0.00,0.00,0.00,0.00,0.00),('8','214','1','98',675,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','98',676,'4','1',202109.07,202567.80,458.73,144499.95,0.00,0.00,0.00,0.00,0.00),('8','214','2','98',677,'5','1',2653088.36,2653548.72,460.36,145013.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','98',678,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','98',679,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','99',680,'1','1',4330399.92,4331336.43,936.51,295000.65,0.00,0.00,0.00,0.00,0.00),('8','214','1','99',681,'2','1',420189.34,421962.60,1773.26,558576.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','99',682,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','99',683,'4','1',202567.80,204019.40,1451.60,457254.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','99',684,'5','1',2653548.72,2655248.83,1700.11,535534.65,0.00,0.00,0.00,0.00,0.00),('8','214','2','99',685,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','99',686,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','100',687,'1','1',4331336.43,4331876.84,540.41,170229.15,0.00,0.00,0.00,0.00,0.00),('8','214','1','100',688,'2','1',421962.60,423181.97,1219.37,384101.55,0.00,0.00,0.00,0.00,0.00),('8','214','1','100',689,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','100',690,'4','1',204019.40,205915.83,1896.43,597375.45,0.00,0.00,0.00,0.00,0.00),('8','214','2','100',691,'5','1',2655248.83,2656716.19,1467.36,462218.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','100',692,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','100',693,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','101',694,'1','1',4331876.84,4332925.71,1048.87,330394.05,0.00,0.00,0.00,0.00,0.00),('8','214','1','101',695,'2','1',423181.97,424957.58,1775.61,559317.15,0.00,0.00,0.00,0.00,0.00),('8','214','1','101',696,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','101',697,'4','1',205915.83,207211.04,1295.21,407991.15,0.00,0.00,0.00,0.00,0.00),('8','214','2','101',698,'5','1',2656716.19,2658492.80,1776.61,559632.15,0.00,0.00,0.00,0.00,0.00),('8','214','2','101',699,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','101',700,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','102',701,'1','1',4332925.71,4333783.84,858.13,270310.95,0.00,0.00,0.00,0.00,0.00),('8','214','1','102',702,'2','1',424957.58,426149.46,1191.88,375442.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','102',703,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','102',704,'4','1',207211.04,208610.64,1399.60,440874.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','102',705,'5','1',2658492.80,2659380.44,887.64,279606.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','102',706,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','102',707,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','103',708,'1','1',4333783.84,4334760.64,976.80,307692.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','103',709,'2','1',426149.46,426752.42,602.96,189932.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','103',710,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','103',711,'4','1',208610.64,210090.90,1480.26,466281.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','103',712,'5','1',2659380.44,2661552.51,2172.07,684202.05,0.00,0.00,0.00,0.00,0.00),('8','214','2','103',713,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','103',714,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','104',715,'1','1',4334760.64,4337372.90,2612.26,822861.90,0.00,0.00,0.00,0.00,0.00),('8','214','1','104',716,'2','1',426752.42,430325.79,3573.37,1125611.55,0.00,0.00,0.00,0.00,0.00),('8','214','1','104',717,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','104',718,'4','1',210090.90,213447.79,3356.89,1057420.35,0.00,0.00,0.00,0.00,0.00),('8','214','2','104',719,'5','1',2661552.51,2664742.14,3189.63,1004733.45,0.00,0.00,0.00,0.00,0.00),('8','214','2','104',720,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','104',721,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','105',722,'1','1',4337372.90,4337372.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','105',723,'2','1',430325.79,431267.50,941.71,296638.65,0.00,0.00,0.00,0.00,0.00),('8','214','1','105',724,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','105',725,'4','1',213447.79,214919.82,1472.03,463689.45,0.00,0.00,0.00,0.00,0.00),('8','214','2','105',726,'5','1',2664742.14,2666364.49,1622.35,511040.25,0.00,0.00,0.00,0.00,0.00),('8','214','2','105',727,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','105',728,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','106',729,'1','1',4337372.90,4337372.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','106',730,'2','1',431267.50,431267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','106',731,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','106',732,'4','1',214919.82,216695.12,1775.30,559219.50,0.00,0.00,0.00,0.00,0.00),('8','214','2','106',733,'5','1',2666364.49,2668072.58,1708.09,538048.35,0.00,0.00,0.00,0.00,0.00),('8','214','2','106',734,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','106',735,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','107',736,'1','1',4337372.90,4337372.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','107',737,'2','1',431267.50,431267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','107',738,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','107',739,'4','1',216695.12,217362.10,666.98,210098.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','107',740,'5','1',2668072.58,2668632.24,559.66,176292.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','107',741,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','107',742,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','108',743,'1','1',4337372.90,4337372.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','108',744,'2','1',431267.50,431267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','108',745,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','108',746,'4','1',217362.10,221145.57,3783.47,1153958.35,0.00,0.00,0.00,0.00,0.00),('8','214','2','108',747,'5','1',2668632.24,2671651.33,3019.09,920822.45,0.00,0.00,0.00,0.00,0.00),('8','214','2','108',748,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','108',749,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','109',750,'1','1',4337372.90,4337372.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','109',751,'2','1',431267.50,431267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','109',752,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','109',753,'4','1',221145.57,224639.38,3493.81,1065612.05,0.00,0.00,0.00,0.00,0.00),('8','214','2','109',754,'5','1',2671651.33,2674419.65,2768.32,844337.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','109',755,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','109',756,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','110',757,'1','1',4337372.90,4337372.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','110',758,'2','1',431267.50,431267.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','110',759,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','110',760,'4','1',224639.38,227160.02,2520.64,768795.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','110',761,'5','1',2674419.65,2676827.47,2407.82,734385.10,0.00,0.00,0.00,0.00,0.00),('8','214','2','110',762,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','110',763,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','111',764,'1','1',4337372.90,4338232.22,859.32,257796.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','111',765,'2','1',431267.50,431577.90,310.40,93120.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','111',766,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','111',767,'4','1',227160.02,228278.36,1118.34,335502.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','111',768,'5','1',2676827.47,2679452.10,2624.63,787389.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','111',769,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','111',770,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','112',771,'1','1',4338232.22,4339431.71,1199.49,359847.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','112',772,'2','1',431577.90,433245.53,1667.63,500289.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','112',773,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','112',774,'4','1',228278.36,231133.41,2855.05,856515.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','112',775,'5','1',2679452.10,2680687.43,1235.33,370599.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','112',776,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','112',777,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','113',778,'1','1',4339431.71,4339952.75,521.04,156312.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','113',779,'2','1',433245.53,434740.27,1494.74,448422.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','113',780,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','113',781,'4','1',231133.41,234109.90,2976.49,892947.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','113',782,'5','1',2680687.43,2683267.91,2580.48,774144.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','113',783,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','113',784,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','114',785,'1','1',4339952.75,4341184.08,1231.33,369399.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','114',786,'2','1',434740.27,436487.10,1746.83,524049.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','114',787,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','114',788,'4','1',234109.90,237211.61,3101.71,930513.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','114',789,'5','1',2683267.91,2684169.89,901.98,270594.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','114',790,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','114',791,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','115',792,'1','1',4341184.08,4343322.40,2138.32,641496.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','115',793,'2','1',436487.10,437734.72,1247.62,374286.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','115',794,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','115',795,'4','1',237211.61,237938.75,727.14,218142.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','115',796,'5','1',2684169.89,2686268.82,2098.93,629679.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','115',797,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','115',798,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','116',799,'1','1',4343322.40,4346961.94,3639.54,1091862.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','116',800,'2','1',437734.72,443202.75,5468.03,1640409.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','116',801,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','116',802,'4','1',237938.75,242187.13,4248.38,1274514.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','116',803,'5','1',2686268.82,2690420.21,4151.39,1245417.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','116',804,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','116',805,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','117',806,'1','1',4346961.94,4348068.12,1106.18,331854.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','117',807,'2','1',443202.75,444906.18,1703.43,511029.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','117',808,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','117',809,'4','1',242187.13,245477.38,3290.25,987075.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','117',810,'5','1',2690420.21,2691988.89,1568.68,470604.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','117',811,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','117',812,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','118',813,'1','1',4348068.12,4349243.37,1175.25,352575.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','118',814,'2','1',444906.18,446618.37,1712.19,513657.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','118',815,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','118',816,'4','1',245477.38,247336.08,1858.70,557610.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','118',817,'5','1',2691988.89,2694325.46,2336.57,700971.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','118',818,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','118',819,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','119',820,'1','1',4349243.37,4349902.86,659.49,197847.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','119',821,'2','1',446618.37,448832.79,2214.42,664326.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','119',822,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','119',823,'4','1',247336.08,248683.92,1347.84,404352.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','119',824,'5','1',2694325.46,2697293.59,2968.13,890439.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','119',825,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','119',826,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','120',827,'1','1',4349902.86,4350700.76,797.90,239370.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','120',828,'2','1',448832.79,451188.10,2355.31,706593.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','120',829,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','120',830,'4','1',248683.92,251961.27,3277.35,983205.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','120',831,'5','1',2697293.59,2700024.75,2731.16,819348.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','120',832,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','120',833,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','121',834,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','121',835,'2','1',451188.10,452183.20,995.10,298530.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','121',836,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','121',837,'4','1',251961.27,255171.41,3210.14,963042.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','121',838,'5','1',2700024.75,2703522.81,3498.06,1049418.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','121',839,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','121',840,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','122',841,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','122',842,'2','1',452183.20,452183.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','122',843,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','122',844,'4','1',255171.41,258484.34,3312.93,993879.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','122',845,'5','1',2703522.81,2706619.00,3096.19,928857.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','122',846,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','122',847,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','123',848,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','123',849,'2','1',452183.20,452183.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','123',850,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','123',851,'4','1',258484.34,263544.60,5060.26,1518078.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','123',852,'5','1',2706619.00,2710839.95,4220.95,1266285.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','123',853,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','123',854,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','124',855,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','124',856,'2','1',452183.20,452183.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','124',857,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','124',858,'4','1',263544.60,266105.76,2561.16,768348.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','124',859,'5','1',2710839.95,2713575.80,2735.85,820755.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','124',860,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','124',861,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','125',862,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','125',863,'2','1',452183.20,452183.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','125',864,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','125',865,'4','1',266105.76,269672.59,3566.83,1070049.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','125',866,'5','1',2713575.80,2716971.99,3396.19,1018857.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','125',867,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','125',868,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','126',869,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','126',870,'2','1',452183.20,452183.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','126',871,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','126',872,'4','1',269672.59,272007.50,2334.91,700473.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','126',873,'5','1',2716971.99,2719289.50,2317.51,695253.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','126',874,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','126',875,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','127',876,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','127',877,'2','1',452183.20,452183.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','127',878,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','127',879,'4','1',272007.50,276159.10,4151.60,1245480.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','127',880,'5','1',2719289.50,2723490.66,4201.16,1260348.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','127',881,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','127',882,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','128',883,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','128',884,'2','1',452183.20,452183.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','128',885,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','128',886,'4','1',276159.10,278075.29,1916.19,574857.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','128',887,'5','1',2723490.66,2726483.42,2992.76,897828.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','128',888,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','128',889,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','129',890,'1','1',4350700.76,4350700.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','129',891,'2','1',452183.20,452183.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','129',892,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','129',893,'4','1',278075.29,278870.15,794.86,238458.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','129',894,'5','1',2726483.42,2727140.57,657.15,197145.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','129',895,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','129',896,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','130',897,'1','1',4350700.76,4352350.07,1649.31,504688.86,0.00,0.00,0.00,0.00,0.00),('8','214','1','130',898,'2','1',452183.20,455141.90,2958.70,905362.20,0.00,0.00,0.00,0.00,0.00),('8','214','1','130',899,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','130',900,'4','1',278870.15,280416.17,1546.02,473082.12,0.00,0.00,0.00,0.00,0.00),('8','214','2','130',901,'5','1',2727140.57,2728763.40,1622.83,496585.98,0.00,0.00,0.00,0.00,0.00),('8','214','2','130',902,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','130',903,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','131',904,'1','1',4352350.07,4354030.59,1680.52,514239.12,0.00,0.00,0.00,0.00,0.00),('8','214','1','131',905,'2','1',455141.90,457713.44,2571.54,786891.24,0.00,0.00,0.00,0.00,0.00),('8','214','1','131',906,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','131',907,'4','1',280416.17,282654.14,2237.97,684818.82,0.00,0.00,0.00,0.00,0.00),('8','214','2','131',908,'5','1',2728763.40,2732582.96,3819.56,1168785.36,0.00,0.00,0.00,0.00,0.00),('8','214','2','131',909,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','131',910,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','132',911,'1','1',4354030.59,4355778.84,1748.25,534964.50,0.00,0.00,0.00,0.00,0.00),('8','214','1','132',912,'2','1',457713.44,461378.18,3664.74,1121410.44,0.00,0.00,0.00,0.00,0.00),('8','214','1','132',913,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','132',914,'4','1',282654.14,283911.97,1257.83,384895.98,0.00,0.00,0.00,0.00,0.00),('8','214','2','132',915,'5','1',2732582.96,2736048.42,3465.46,1060430.76,0.00,0.00,0.00,0.00,0.00),('8','214','2','132',916,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','132',917,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','133',918,'1','1',4355778.84,4356988.67,1209.83,370207.98,0.00,0.00,0.00,0.00,0.00),('8','214','1','133',919,'2','1',461378.18,462778.16,1399.98,428393.88,0.00,0.00,0.00,0.00,0.00),('8','214','1','133',920,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','133',921,'4','1',283911.97,284934.56,1022.59,312912.54,0.00,0.00,0.00,0.00,0.00),('8','214','2','133',922,'5','1',2736048.42,2736685.41,636.99,194918.94,0.00,0.00,0.00,0.00,0.00),('8','214','2','133',923,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','133',924,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','134',925,'1','1',4356988.67,4358268.02,1279.35,432420.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','134',926,'2','1',462778.16,463738.12,959.96,324466.48,0.00,0.00,0.00,0.00,0.00),('8','214','1','134',927,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','134',928,'4','1',284934.56,286414.70,1480.14,500287.32,0.00,0.00,0.00,0.00,0.00),('8','214','2','134',929,'5','1',2736685.41,2739340.72,2655.31,897494.78,0.00,0.00,0.00,0.00,0.00),('8','214','2','134',930,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','134',931,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','135',932,'1','1',4358268.02,4359267.68,999.66,344882.70,0.00,0.00,0.00,0.00,0.00),('8','214','1','135',933,'2','1',463738.12,465301.61,1563.49,539404.05,0.00,0.00,0.00,0.00,0.00),('8','214','1','135',934,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','135',935,'4','1',286414.70,288084.56,1669.86,576101.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','135',936,'5','1',2739340.72,2740572.95,1232.23,425119.35,0.00,0.00,0.00,0.00,0.00),('8','214','2','135',937,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','135',938,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','136',939,'1','1',4359267.68,4359288.41,20.73,7151.85,0.00,0.00,0.00,0.00,0.00),('8','214','1','136',940,'2','1',465301.61,466162.05,860.44,296851.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','136',941,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','136',942,'4','1',288084.56,288987.01,902.45,311345.25,0.00,0.00,0.00,0.00,0.00),('8','214','2','136',943,'5','1',2740572.95,2741452.00,879.05,303272.25,0.00,0.00,0.00,0.00,0.00),('8','214','2','136',944,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','136',945,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','137',946,'1','1',4359288.41,4359961.52,673.11,232222.95,0.00,0.00,0.00,0.00,0.00),('8','214','1','137',947,'2','1',466162.05,467378.68,1216.63,419737.35,0.00,0.00,0.00,0.00,0.00),('8','214','1','137',948,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','137',949,'4','1',288987.01,289979.61,992.60,342447.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','137',950,'5','1',2741452.00,2743477.49,2025.49,698794.05,0.00,0.00,0.00,0.00,0.00),('8','214','2','137',951,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','137',952,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','138',953,'1','1',4359961.52,4359961.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','138',954,'2','1',467378.68,468615.55,1236.87,426720.15,0.00,0.00,0.00,0.00,0.00),('8','214','1','138',955,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','138',956,'4','1',289979.61,291993.35,2013.74,694740.30,0.00,0.00,0.00,0.00,0.00),('8','214','2','138',957,'5','1',2743477.49,2745806.21,2328.72,803408.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','138',958,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','138',959,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','139',960,'1','1',4359961.52,4361278.26,1316.74,454275.30,0.00,0.00,0.00,0.00,0.00),('8','214','1','139',961,'2','1',468615.55,469898.24,1282.69,442528.05,0.00,0.00,0.00,0.00,0.00),('8','214','1','139',962,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','139',963,'4','1',291993.35,294399.06,2405.71,829969.95,0.00,0.00,0.00,0.00,0.00),('8','214','2','139',964,'5','1',2745806.21,2747062.83,1256.62,433533.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','139',965,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','139',966,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','140',967,'1','1',4361278.26,4362397.38,1119.12,386096.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','140',968,'2','1',469898.24,471133.81,1235.57,426271.65,0.00,0.00,0.00,0.00,0.00),('8','214','1','140',969,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','140',970,'4','1',294399.06,296829.48,2430.42,838494.90,0.00,0.00,0.00,0.00,0.00),('8','214','2','140',971,'5','1',2747062.83,2748204.16,1141.33,393758.85,0.00,0.00,0.00,0.00,0.00),('8','214','2','140',972,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','140',973,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','141',974,'1','1',4362397.38,4362968.97,571.59,197198.55,0.00,0.00,0.00,0.00,0.00),('8','214','1','141',975,'2','1',471133.81,472698.42,1564.61,539790.45,0.00,0.00,0.00,0.00,0.00),('8','214','1','141',976,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','141',977,'4','1',296829.48,298060.01,1230.53,424532.85,0.00,0.00,0.00,0.00,0.00),('8','214','2','141',978,'5','1',2748204.16,2749850.25,1646.09,567901.05,0.00,0.00,0.00,0.00,0.00),('8','214','2','141',979,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','141',980,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','142',981,'1','1',4362968.97,4363828.44,859.47,296517.15,0.00,0.00,0.00,0.00,0.00),('8','214','1','142',982,'2','1',472698.42,474298.20,1599.78,551924.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','142',983,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','142',984,'4','1',298060.01,300866.16,2806.15,968121.75,0.00,0.00,0.00,0.00,0.00),('8','214','2','142',985,'5','1',2749850.25,2752390.61,2540.36,876424.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','142',986,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','142',987,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','143',988,'1','1',4363828.44,4364439.02,610.58,210650.10,0.00,0.00,0.00,0.00,0.00),('8','214','1','143',989,'2','1',474298.20,476123.12,1824.92,629597.40,0.00,0.00,0.00,0.00,0.00),('8','214','1','143',990,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','143',991,'4','1',300866.16,303661.20,2795.04,964288.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','143',992,'5','1',2752390.61,2753868.36,1477.75,509823.75,0.00,0.00,0.00,0.00,0.00),('8','214','2','143',993,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','143',994,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','144',995,'1','1',4364439.02,4366421.31,1982.29,683890.05,0.00,0.00,0.00,0.00,0.00),('8','214','1','144',996,'2','1',476123.12,478310.36,2187.24,754597.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','144',997,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','144',998,'4','1',303661.20,305113.41,1452.21,501012.45,0.00,0.00,0.00,0.00,0.00),('8','214','2','144',999,'5','1',2753868.36,2756281.21,2412.85,832433.25,0.00,0.00,0.00,0.00,0.00),('8','214','2','144',1000,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','144',1001,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','145',1002,'1','1',4366421.31,4367200.64,779.33,268868.85,0.00,0.00,0.00,0.00,0.00),('8','214','1','145',1003,'2','1',478310.36,482150.63,3840.27,1324893.15,0.00,0.00,0.00,0.00,0.00),('8','214','1','145',1004,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','145',1005,'4','1',305113.41,307874.70,2761.29,952645.05,0.00,0.00,0.00,0.00,0.00),('8','214','2','145',1006,'5','1',2756281.21,2756312.24,31.03,10705.35,0.00,0.00,0.00,0.00,0.00),('8','214','2','145',1007,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','145',1008,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','146',1009,'1','1',4367200.64,4367819.28,618.64,213430.80,0.00,0.00,0.00,0.00,0.00),('8','214','1','146',1010,'2','1',482150.63,484441.03,2290.40,790188.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','146',1011,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','146',1012,'4','1',307874.70,309586.06,1711.36,590419.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','146',1013,'5','1',2756312.24,2758424.10,2111.86,728591.70,0.00,0.00,0.00,0.00,0.00),('8','214','2','146',1014,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','146',1015,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','147',1016,'1','1',4367819.28,4369355.37,1536.09,529951.05,0.00,0.00,0.00,0.00,0.00),('8','214','1','147',1017,'2','1',484441.03,485715.96,1274.93,439850.85,0.00,0.00,0.00,0.00,0.00),('8','214','1','147',1018,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','147',1019,'4','1',309586.06,309586.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','147',1020,'5','1',2758424.10,2759629.42,1205.32,415835.40,0.00,0.00,0.00,0.00,0.00),('8','214','2','147',1021,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','147',1022,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','148',1023,'1','1',4369355.37,4369355.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','148',1024,'2','1',485715.96,485715.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','148',1025,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','148',1026,'4','1',309586.06,312728.44,3142.38,1068409.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','148',1027,'5','1',2759629.42,2762189.42,2560.00,870400.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','148',1028,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','148',1029,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','149',1030,'1','1',4369355.37,4369355.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','149',1031,'2','1',485715.96,485715.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','149',1032,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','149',1033,'4','1',312728.44,315546.33,2817.89,958082.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','149',1034,'5','1',2762189.42,2765279.95,3090.53,1050780.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','149',1035,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','149',1036,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','150',1037,'1','1',4369355.37,4369355.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','150',1038,'2','1',485715.96,485715.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','150',1039,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','150',1040,'4','1',315546.33,318073.35,2527.02,859186.80,0.00,0.00,0.00,0.00,0.00),('8','214','2','150',1041,'5','1',2765279.95,2768434.93,3154.98,1072693.20,0.00,0.00,0.00,0.00,0.00),('8','214','2','150',1042,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','150',1043,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','151',1044,'1','1',4369355.37,4369355.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','151',1045,'2','1',485715.96,485715.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','151',1046,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','151',1047,'4','1',318073.35,319715.69,1642.34,558395.60,0.00,0.00,0.00,0.00,0.00),('8','214','2','151',1048,'5','1',2768434.93,2770290.08,1855.15,630751.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','151',1049,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','151',1050,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','152',1051,'1','1',4369355.37,4369355.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','152',1052,'2','1',485715.96,487078.18,1362.22,408666.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','152',1053,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','152',1054,'4','1',319715.69,321969.40,2253.71,676113.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','152',1055,'5','1',2770290.08,2772606.86,2316.78,695034.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','152',1056,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','152',1057,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','153',1058,'1','1',4369355.37,4370993.33,1637.96,491388.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','153',1059,'2','1',487078.18,488277.31,1199.13,359739.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','153',1060,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','153',1061,'4','1',321969.40,323775.46,1806.06,541818.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','153',1062,'5','1',2772606.86,2775396.83,2789.97,836991.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','153',1063,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','153',1064,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','154',1065,'1','1',4370993.33,4371239.70,246.37,73911.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','154',1066,'2','1',488277.31,489976.21,1698.90,509670.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','154',1067,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','154',1068,'4','1',323775.46,325743.96,1968.50,590550.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','154',1069,'5','1',2775396.83,2777634.37,2237.54,671262.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','154',1070,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','154',1071,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','155',1072,'1','1',4371239.70,4372186.18,946.48,283944.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','155',1073,'2','1',489976.21,492406.66,2430.45,729135.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','155',1074,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','155',1075,'4','1',325743.96,329985.02,4241.06,1272318.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','155',1076,'5','1',2777634.37,2777634.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','155',1077,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','155',1078,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','156',1079,'1','1',4372186.18,4373116.70,930.52,279156.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','156',1080,'2','1',492406.66,493596.20,1189.54,356862.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','156',1081,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','156',1082,'4','1',329985.02,331250.31,1265.29,379587.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','156',1083,'5','1',2777634.37,2779926.59,2292.22,687666.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','156',1084,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','156',1085,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','157',1086,'1','1',4373116.70,4375590.58,2473.88,742164.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','157',1087,'2','1',493596.20,497381.06,3784.86,1135458.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','157',1088,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','157',1089,'4','1',331250.31,334417.09,3166.78,950034.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','157',1090,'5','1',2779926.59,2782476.02,2549.43,764829.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','157',1091,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','157',1092,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','158',1093,'1','1',4375590.58,4375590.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','158',1094,'2','1',497381.06,499386.40,2005.34,601602.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','158',1095,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','158',1096,'4','1',334417.09,336228.93,1811.84,543552.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','158',1097,'5','1',2782476.02,2784135.63,1659.61,497883.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','158',1098,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','158',1099,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','159',1100,'1','1',4375590.58,4376325.70,735.12,220536.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','159',1101,'2','1',499386.40,502302.40,2916.00,874800.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','159',1102,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','159',1103,'4','1',336228.93,337305.43,1076.50,322950.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','159',1104,'5','1',2784135.63,2785260.90,1125.27,337581.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','159',1105,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','159',1106,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','160',1107,'1','1',4376325.70,4376325.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','160',1108,'2','1',502302.40,504473.48,2171.08,651324.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','160',1109,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','160',1110,'4','1',337305.43,340065.70,2760.27,828081.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','160',1111,'5','1',2785260.90,2787748.17,2487.27,746181.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','160',1112,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','160',1113,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','161',1114,'1','1',4376325.70,4376434.05,108.35,32505.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','161',1115,'2','1',504473.48,506474.39,2000.91,600273.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','161',1116,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','161',1117,'4','1',340065.70,342694.74,2629.04,788712.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','161',1118,'5','1',2787748.17,2789754.88,2006.71,602013.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','161',1119,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','161',1120,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','162',1121,'1','1',4376434.05,4376434.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','162',1122,'2','1',506474.39,507918.68,1444.29,433287.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','162',1123,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','162',1124,'4','1',342694.74,344657.05,1962.31,588693.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','162',1125,'5','1',2789754.88,2791529.41,1774.53,532359.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','162',1126,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','162',1127,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','163',1128,'1','1',4376434.05,4376434.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','163',1129,'2','1',507918.68,509571.05,1652.37,495711.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','163',1130,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','163',1131,'4','1',344657.05,346781.44,2124.39,637317.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','163',1132,'5','1',2791529.41,2793509.63,1980.22,594066.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','163',1133,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','163',1134,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','164',1135,'1','1',4376434.05,4377004.13,570.08,171024.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','164',1136,'2','1',509571.05,510555.66,984.61,295383.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','164',1137,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','164',1138,'4','1',346781.44,350660.77,3879.33,1163799.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','164',1139,'5','1',2793509.63,2797925.88,4416.25,1324875.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','164',1140,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','164',1141,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','165',1142,'1','1',4377004.13,4377004.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','165',1143,'2','1',510555.66,510555.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','165',1144,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','165',1145,'4','1',350660.77,353026.93,2366.16,709848.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','165',1146,'5','1',2797925.88,2800167.48,2241.60,672480.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','165',1147,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','165',1148,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','166',1149,'1','1',4377004.13,4377004.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','166',1150,'2','1',510555.66,510555.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','166',1151,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','166',1152,'4','1',353026.93,354504.16,1477.23,443169.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','166',1153,'5','1',2800167.48,2801963.19,1795.71,538713.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','166',1154,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','166',1155,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','167',1156,'1','1',4377004.13,4377934.59,930.46,279138.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','167',1157,'2','1',510555.66,511681.34,1125.68,337704.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','167',1158,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','167',1159,'4','1',354504.16,356074.47,1570.31,471093.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','167',1160,'5','1',2801963.19,2804361.14,2397.95,719385.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','167',1161,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','167',1162,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','168',1163,'1','1',4377934.59,4378878.10,943.51,283053.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','168',1164,'2','1',511681.34,513002.65,1321.31,396393.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','168',1165,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','168',1166,'4','1',356074.47,358106.95,2032.48,609744.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','168',1167,'5','1',2804361.14,2805209.79,848.65,254595.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','168',1168,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','168',1169,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','169',1170,'1','1',4378878.10,4379478.73,600.63,180189.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','169',1171,'2','1',513002.65,514821.12,1818.47,545541.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','169',1172,'3','1',753473.54,753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','169',1173,'4','1',358106.95,358952.55,845.60,253680.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','169',1174,'5','1',2805209.79,2807079.64,1869.85,560955.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','169',1175,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','169',1176,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','170',1177,'1','1',4379478.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','170',1178,'2','1',514821.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','1','170',1179,'3','1',753473.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','170',1180,'4','1',358952.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','170',1181,'5','1',2807079.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','2','170',1182,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','214','3','170',1183,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=339 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('8','214','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,1),('8','214','2','1',0.00,215.00,11011.92,0.00,0.00,0.00,0.00,2),('8','214','3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('8','214','3','1',215.00,215.00,5702.77,0.00,0.00,0.00,0.00,4),('8','214','4','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,5),('8','214','4','1',215.00,215.00,5577.41,0.00,0.00,0.00,0.00,6),('8','214','5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,7),('8','214','5','1',215.00,215.00,5722.13,0.00,0.00,0.00,0.00,8),('8','214','6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,9),('8','214','6','1',215.00,215.00,5169.64,0.00,0.00,0.00,0.00,10),('8','214','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,11),('8','214','7','1',215.00,215.00,5053.70,0.00,0.00,0.00,0.00,12),('8','214','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,13),('8','214','8','1',215.00,215.00,5399.49,0.00,0.00,0.00,0.00,14),('8','214','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,15),('8','214','9','1',215.00,207.00,6622.15,0.00,0.00,0.00,0.00,16),('8','214','10','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,17),('8','214','10','1',215.00,207.00,4952.17,0.00,0.00,0.00,0.00,18),('8','214','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,19),('8','214','11','1',215.00,207.00,5519.62,0.00,0.00,0.00,0.00,20),('8','214','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,21),('8','214','12','1',215.00,207.00,4275.74,0.00,0.00,0.00,0.00,22),('8','214','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,23),('8','214','13','1',215.00,207.00,5305.80,0.00,0.00,0.00,0.00,24),('8','214','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,25),('8','214','14','1',207.00,200.00,6063.01,0.00,0.00,0.00,0.00,26),('8','214','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('8','214','15','1',207.00,200.00,4428.17,0.00,0.00,0.00,0.00,28),('8','214','16','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('8','214','16','1',200.00,200.00,6977.99,0.00,0.00,0.00,0.00,30),('8','214','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,31),('8','214','17','1',200.00,190.00,4696.71,0.00,0.00,0.00,0.00,32),('8','214','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,33),('8','214','18','1',200.00,190.00,5172.18,0.00,0.00,0.00,0.00,34),('8','214','19','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('8','214','19','1',200.00,190.00,6207.31,0.00,0.00,0.00,0.00,36),('8','214','20','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,37),('8','214','20','1',200.00,190.00,6083.58,0.00,0.00,0.00,0.00,38),('8','214','21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('8','214','21','1',207.00,190.00,5689.52,0.00,0.00,0.00,0.00,40),('8','214','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,41),('8','214','22','1',207.00,190.00,5680.63,0.00,0.00,0.00,0.00,42),('8','214','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,43),('8','214','23','1',190.00,190.00,14548.18,0.00,0.00,0.00,0.00,44),('8','214','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,45),('8','214','24','1',190.00,190.00,5515.24,0.00,0.00,0.00,0.00,46),('8','214','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,47),('8','214','25','1',190.00,190.00,6082.01,0.00,0.00,0.00,0.00,48),('8','214','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,49),('8','214','26','1',190.00,190.00,6941.72,0.00,0.00,0.00,0.00,50),('8','214','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('8','214','27','1',190.00,190.00,6750.01,0.00,0.00,0.00,0.00,52),('8','214','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('8','214','28','1',190.00,190.00,4636.12,0.00,0.00,0.00,0.00,54),('8','214','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,55),('8','214','29','1',190.00,190.00,4331.83,0.00,0.00,0.00,0.00,56),('8','214','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,57),('8','214','30','1',190.00,190.00,9826.31,0.00,0.00,0.00,0.00,58),('8','214','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,59),('8','214','31','1',190.00,190.00,3533.68,0.00,0.00,0.00,0.00,60),('8','214','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,61),('8','214','32','1',190.00,190.00,4497.13,0.00,0.00,0.00,0.00,62),('8','214','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,63),('8','214','33','1',190.00,190.00,3011.00,0.00,0.00,0.00,0.00,64),('8','214','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,65),('8','214','34','1',190.00,190.00,3104.17,0.00,0.00,0.00,0.00,66),('8','214','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,67),('8','214','35','1',190.00,190.00,3488.27,0.00,0.00,0.00,0.00,68),('8','214','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,69),('8','214','36','1',190.00,190.00,6848.53,0.00,0.00,0.00,0.00,70),('8','214','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,71),('8','214','37','1',190.00,190.00,15338.17,0.00,0.00,0.00,0.00,72),('8','214','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,73),('8','214','38','1',190.00,190.00,4971.21,0.00,0.00,0.00,0.00,74),('8','214','39','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('8','214','39','1',190.00,190.00,5973.72,0.00,0.00,0.00,0.00,76),('8','214','40','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,77),('8','214','40','1',190.00,190.00,6148.38,0.00,0.00,0.00,0.00,78),('8','214','41','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,79),('8','214','41','1',190.00,190.00,6268.92,0.00,0.00,0.00,0.00,80),('8','214','42','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,81),('8','214','42','1',190.00,190.00,6953.05,0.00,0.00,0.00,0.00,82),('8','214','43','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,83),('8','214','43','1',190.00,190.00,5971.53,0.00,0.00,0.00,0.00,84),('8','214','44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,85),('8','214','44','1',190.00,190.00,13962.38,0.00,0.00,0.00,0.00,86),('8','214','45','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,87),('8','214','45','1',190.00,190.00,6008.96,0.00,0.00,0.00,0.00,88),('8','214','46','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,89),('8','214','46','1',190.00,190.00,6377.86,0.00,0.00,0.00,0.00,90),('8','214','47','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,91),('8','214','47','1',190.00,190.00,6894.97,0.00,0.00,0.00,0.00,92),('8','214','48','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,93),('8','214','48','1',190.00,190.00,7269.27,0.00,0.00,0.00,0.00,94),('8','214','49','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,95),('8','214','49','1',190.00,190.00,7291.92,0.00,0.00,0.00,0.00,96),('8','214','50','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,97),('8','214','50','1',190.00,190.00,6913.38,0.00,0.00,0.00,0.00,98),('8','214','51','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,99),('8','214','51','1',190.00,190.00,17705.33,0.00,0.00,0.00,0.00,100),('8','214','52','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,101),('8','214','52','1',190.00,190.00,4598.23,0.00,0.00,0.00,0.00,102),('8','214','53','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,103),('8','214','53','1',190.00,190.00,3515.82,0.00,0.00,0.00,0.00,104),('8','214','54','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,105),('8','214','54','1',190.00,190.00,4396.13,0.00,0.00,0.00,0.00,106),('8','214','55','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,107),('8','214','55','1',190.00,190.00,4590.58,0.00,0.00,0.00,0.00,108),('8','214','56','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,109),('8','214','56','1',190.00,190.00,3794.40,0.00,0.00,0.00,0.00,110),('8','214','57','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,111),('8','214','57','1',190.00,190.00,1590.43,0.00,0.00,0.00,0.00,112),('8','214','58','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,113),('8','214','58','1',190.00,190.00,2062.59,0.00,0.00,0.00,0.00,114),('8','214','59','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,115),('8','214','59','1',190.00,190.00,0.00,0.00,0.00,0.00,0.00,116),('8','214','60','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,117),('8','214','60','1',190.00,0.00,11094.34,0.00,0.00,0.00,0.00,118),('8','214','61','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,119),('8','214','61','1',190.00,190.00,6948.95,0.00,0.00,0.00,0.00,120),('8','214','62','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,121),('8','214','62','1',190.00,190.00,1091.57,0.00,0.00,0.00,0.00,122),('8','214','63','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,123),('8','214','63','1',190.00,190.00,3099.10,0.00,0.00,0.00,0.00,124),('8','214','64','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,125),('8','214','64','1',190.00,203.00,5518.99,0.00,0.00,0.00,0.00,126),('8','214','65','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,127),('8','214','65','1',190.00,203.00,8441.87,0.00,0.00,0.00,0.00,128),('8','214','66','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,129),('8','214','66','1',203.00,203.00,11147.54,0.00,0.00,0.00,0.00,130),('8','214','67','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,131),('8','214','67','1',203.00,206.00,12058.48,0.00,0.00,0.00,0.00,132),('8','214','68','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,133),('8','214','68','1',203.00,220.00,5592.42,0.00,0.00,0.00,0.00,134),('8','214','69','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,135),('8','214','69','1',235.00,235.00,8379.96,0.00,0.00,0.00,0.00,136),('8','214','70','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,137),('8','214','70','1',235.00,240.00,5400.03,0.00,0.00,0.00,0.00,138),('8','214','71','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,139),('8','214','71','1',235.00,240.00,4077.99,0.00,0.00,0.00,0.00,140),('8','214','72','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,141),('8','214','72','1',240.00,240.00,12216.34,0.00,0.00,0.00,0.00,142),('8','214','73','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,143),('8','214','73','1',240.00,250.00,4349.84,0.00,0.00,0.00,0.00,144),('8','214','74','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,145),('8','214','74','1',240.00,250.00,3076.94,0.00,0.00,0.00,0.00,146),('8','214','75','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,147),('8','214','75','1',255.00,255.00,6035.01,0.00,0.00,0.00,0.00,148),('8','214','76','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,149),('8','214','76','1',255.00,255.00,7498.34,0.00,0.00,0.00,0.00,150),('8','214','77','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,151),('8','214','77','1',255.00,255.00,6653.47,0.00,0.00,0.00,0.00,152),('8','214','78','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,153),('8','214','78','1',255.00,255.00,15545.61,0.00,0.00,0.00,0.00,154),('8','214','79','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,155),('8','214','79','1',255.00,255.00,6792.89,0.00,0.00,0.00,0.00,156),('8','214','80','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,157),('8','214','80','1',255.00,255.00,4488.03,0.00,0.00,0.00,0.00,158),('8','214','81','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,159),('8','214','81','1',255.00,255.00,2932.40,0.00,0.00,0.00,0.00,160),('8','214','82','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,161),('8','214','82','1',255.00,255.00,5928.46,0.00,0.00,0.00,0.00,162),('8','214','83','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,163),('8','214','83','1',255.00,255.00,7151.91,0.00,0.00,0.00,0.00,164),('8','214','84','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,165),('8','214','84','1',255.00,255.00,3683.81,0.00,0.00,0.00,0.00,166),('8','214','85','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,167),('8','214','85','1',260.00,260.00,6179.91,0.00,0.00,0.00,0.00,168),('8','214','86','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,169),('8','214','86','1',260.00,260.00,6974.68,0.00,0.00,0.00,0.00,170),('8','214','87','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,171),('8','214','87','1',260.00,260.00,17186.88,0.00,0.00,0.00,0.00,172),('8','214','88','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,173),('8','214','88','1',260.00,260.00,2445.72,0.00,0.00,0.00,0.00,174),('8','214','89','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,175),('8','214','89','1',260.00,260.00,4352.70,0.00,0.00,0.00,0.00,176),('8','214','90','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,177),('8','214','90','1',260.00,260.00,6159.43,0.00,0.00,0.00,0.00,178),('8','214','91','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,179),('8','214','91','1',260.00,260.00,6840.81,0.00,0.00,0.00,0.00,180),('8','214','92','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,181),('8','214','92','1',260.00,260.00,7334.61,0.00,0.00,0.00,0.00,182),('8','214','93','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,183),('8','214','93','1',260.00,260.00,5082.50,0.00,0.00,0.00,0.00,184),('8','214','94','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,185),('8','214','94','1',260.00,260.00,4510.51,0.00,0.00,0.00,0.00,186),('8','214','95','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,187),('8','214','95','1',270.00,270.00,23315.56,0.00,0.00,0.00,0.00,188),('8','214','96','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,189),('8','214','96','1',270.00,277.00,7952.36,0.00,0.00,0.00,0.00,190),('8','214','97','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,191),('8','214','97','1',315.00,290.00,1921.28,0.00,0.00,0.00,0.00,192),('8','214','98','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,193),('8','214','98','1',315.00,315.00,1634.73,0.00,0.00,0.00,0.00,194),('8','214','99','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,195),('8','214','99','1',315.00,315.00,5861.48,0.00,0.00,0.00,0.00,196),('8','214','100','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,197),('8','214','100','1',315.00,315.00,5123.57,0.00,0.00,0.00,0.00,198),('8','214','101','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,199),('8','214','101','1',315.00,315.00,5896.30,0.00,0.00,0.00,0.00,200),('8','214','102','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,201),('8','214','102','1',315.00,315.00,4337.25,0.00,0.00,0.00,0.00,202),('8','214','103','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,203),('8','214','103','1',315.00,315.00,5232.09,0.00,0.00,0.00,0.00,204),('8','214','104','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,205),('8','214','104','1',315.00,315.00,12732.15,0.00,0.00,0.00,0.00,206),('8','214','105','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,207),('8','214','105','1',315.00,315.00,4036.09,0.00,0.00,0.00,0.00,208),('8','214','106','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,209),('8','214','106','1',315.00,315.00,3483.39,0.00,0.00,0.00,0.00,210),('8','214','107','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,211),('8','214','107','1',305.00,315.00,1226.64,0.00,0.00,0.00,0.00,212),('8','214','108','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213),('8','214','108','1',305.00,305.00,6802.56,0.00,0.00,0.00,0.00,214),('8','214','109','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215),('8','214','109','1',305.00,305.00,6262.13,0.00,0.00,0.00,0.00,216),('8','214','110','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217),('8','214','110','1',305.00,305.00,4928.46,0.00,0.00,0.00,0.00,218),('8','214','111','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219),('8','214','111','1',300.00,300.00,4912.69,0.00,0.00,0.00,0.00,220),('8','214','112','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,221),('8','214','112','1',300.00,300.00,6957.50,0.00,0.00,0.00,0.00,222),('8','214','113','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,223),('8','214','113','1',300.00,300.00,7572.75,0.00,0.00,0.00,0.00,224),('8','214','114','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,225),('8','214','114','1',300.00,300.00,6981.85,0.00,0.00,0.00,0.00,226),('8','214','115','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227),('8','214','115','1',300.00,300.00,6212.01,0.00,0.00,0.00,0.00,228),('8','214','116','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,229),('8','214','116','1',300.00,300.00,17507.34,0.00,0.00,0.00,0.00,230),('8','214','117','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231),('8','214','117','1',300.00,300.00,7668.54,0.00,0.00,0.00,0.00,232),('8','214','118','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233),('8','214','118','1',300.00,300.00,7082.71,0.00,0.00,0.00,0.00,234),('8','214','119','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235),('8','214','119','1',300.00,300.00,7189.88,0.00,0.00,0.00,0.00,236),('8','214','120','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237),('8','214','120','1',300.00,300.00,9161.72,0.00,0.00,0.00,0.00,238),('8','214','121','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,239),('8','214','121','1',300.00,300.00,7703.30,0.00,0.00,0.00,0.00,240),('8','214','122','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241),('8','214','122','1',300.00,300.00,6409.12,0.00,0.00,0.00,0.00,242),('8','214','123','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243),('8','214','123','1',300.00,300.00,9281.21,0.00,0.00,0.00,0.00,244),('8','214','124','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,245),('8','214','124','1',300.00,300.00,5297.01,0.00,0.00,0.00,0.00,246),('8','214','125','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,247),('8','214','125','1',300.00,300.00,6963.02,0.00,0.00,0.00,0.00,248),('8','214','126','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249),('8','214','126','1',300.00,300.00,4652.42,0.00,0.00,0.00,0.00,250),('8','214','127','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251),('8','214','127','1',300.00,300.00,8352.76,0.00,0.00,0.00,0.00,252),('8','214','128','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253),('8','214','128','1',300.00,300.00,4908.95,0.00,0.00,0.00,0.00,254),('8','214','129','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255),('8','214','129','1',306.00,300.00,1452.01,0.00,0.00,0.00,0.00,256),('8','214','130','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,257),('8','214','130','1',306.00,306.00,7776.86,0.00,0.00,0.00,0.00,258),('8','214','131','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,259),('8','214','131','1',306.00,306.00,10309.59,0.00,0.00,0.00,0.00,260),('8','214','132','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261),('8','214','132','1',306.00,306.00,10136.28,0.00,0.00,0.00,0.00,262),('8','214','133','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263),('8','214','133','1',338.00,306.00,4269.39,0.00,0.00,0.00,0.00,264),('8','214','134','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,265),('8','214','134','1',338.00,338.00,6374.76,0.00,0.00,0.00,0.00,266),('8','214','135','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267),('8','214','135','1',338.00,345.00,5465.24,0.00,0.00,0.00,0.00,268),('8','214','136','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269),('8','214','136','1',338.00,345.00,2662.67,0.00,0.00,0.00,0.00,270),('8','214','137','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271),('8','214','137','1',338.00,345.00,4907.83,0.00,0.00,0.00,0.00,272),('8','214','138','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,273),('8','214','138','1',338.00,345.00,5579.33,0.00,0.00,0.00,0.00,274),('8','214','139','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275),('8','214','139','1',338.00,345.00,6261.76,0.00,0.00,0.00,0.00,276),('8','214','140','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277),('8','214','140','1',338.00,345.00,5926.44,0.00,0.00,0.00,0.00,278),('8','214','141','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,279),('8','214','141','1',338.00,345.00,5012.82,0.00,0.00,0.00,0.00,280),('8','214','142','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281),('8','214','142','1',338.00,345.00,7805.76,0.00,0.00,0.00,0.00,282),('8','214','143','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,283),('8','214','143','1',345.00,345.00,6708.29,0.00,0.00,0.00,0.00,284),('8','214','144','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,285),('8','214','144','1',345.00,345.00,8034.59,0.00,0.00,0.00,0.00,286),('8','214','145','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287),('8','214','145','1',345.00,345.00,7411.92,0.00,0.00,0.00,0.00,288),('8','214','146','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289),('8','214','146','1',345.00,345.00,6732.26,0.00,0.00,0.00,0.00,290),('8','214','147','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291),('8','214','147','1',340.00,345.00,4016.34,0.00,0.00,0.00,0.00,292),('8','214','148','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,293),('8','214','148','1',340.00,340.00,5702.38,0.00,0.00,0.00,0.00,294),('8','214','149','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,295),('8','214','149','1',340.00,340.00,5908.42,0.00,0.00,0.00,0.00,296),('8','214','150','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,297),('8','214','150','1',340.00,340.00,5682.00,0.00,0.00,0.00,0.00,298),('8','214','151','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,299),('8','214','151','1',300.00,340.00,3497.49,0.00,0.00,0.00,0.00,300),('8','214','152','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,301),('8','214','152','1',300.00,300.00,5932.71,0.00,0.00,0.00,0.00,302),('8','214','153','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,303),('8','214','153','1',300.00,300.00,7433.12,0.00,0.00,0.00,0.00,304),('8','214','154','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,305),('8','214','154','1',300.00,300.00,6151.31,0.00,0.00,0.00,0.00,306),('8','214','155','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,307),('8','214','155','1',300.00,300.00,7617.99,0.00,0.00,0.00,0.00,308),('8','214','156','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,309),('8','214','156','1',300.00,300.00,5677.57,0.00,0.00,0.00,0.00,310),('8','214','157','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311),('8','214','157','1',300.00,300.00,11974.95,0.00,0.00,0.00,0.00,312),('8','214','158','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,313),('8','214','158','1',300.00,300.00,5476.79,0.00,0.00,0.00,0.00,314),('8','214','159','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,315),('8','214','159','1',300.00,300.00,5852.89,0.00,0.00,0.00,0.00,316),('8','214','160','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317),('8','214','160','1',300.00,300.00,7418.62,0.00,0.00,0.00,0.00,318),('8','214','161','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,319),('8','214','161','1',300.00,300.00,6745.01,0.00,0.00,0.00,0.00,320),('8','214','162','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,321),('8','214','162','1',300.00,300.00,5181.13,0.00,0.00,0.00,0.00,322),('8','214','163','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,323),('8','214','163','1',300.00,300.00,5756.98,0.00,0.00,0.00,0.00,324),('8','214','164','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,325),('8','214','164','1',300.00,300.00,9850.27,0.00,0.00,0.00,0.00,326),('8','214','165','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,327),('8','214','165','1',300.00,300.00,4607.76,0.00,0.00,0.00,0.00,328),('8','214','166','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,329),('8','214','166','1',300.00,300.00,3272.94,0.00,0.00,0.00,0.00,330),('8','214','167','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,331),('8','214','167','1',300.00,300.00,6024.40,0.00,0.00,0.00,0.00,332),('8','214','168','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,333),('8','214','168','1',300.00,300.00,5145.95,0.00,0.00,0.00,0.00,334),('8','214','169','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,335),('8','214','169','1',300.00,300.00,5134.55,0.00,0.00,0.00,0.00,336),('8','214','170','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,337),('8','214','170','1',300.00,300.00,0.00,0.00,0.00,0.00,0.00,338);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('8',1,'214','PRODUCT TANKS','Tank containing Petroleum Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('8','214','1',1,0,'1','PMS TANK 1',40000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','923','2022-08-06 01:52:28','2022-08-06 01:52:28','923',5,0),('8','214','1',2,0,'1','PMS TANK 2',39000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','923','2022-08-06 01:54:22','2022-08-06 01:54:22','923',5,0),('8','214','1',3,0,'2','AGO TANK ',40000.00,0.00,NULL,'TANK CONTAINING DIESEL.','923','2022-08-06 01:56:32','2022-08-06 01:57:34','923',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'8','214',3,0.00,'2023-03-16 09:38:31'),(2,'8','214',2,5525.39,'2023-03-16 09:38:31'),(3,'8','214',1,12529.31,'2023-03-16 09:38:31');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=914 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,11825000.00,55000.00,0.00,0.00,'2022-08-10 09:40:30','',''),(2,'8','214','1',1,'Sale Id shift 2',0.00,0.00,0.00,2651.09,0.00,'2022-08-10 09:42:03','',''),(3,'8','214','1',1,'Sale Id shift 2',0.00,0.00,0.00,3452.47,0.00,'2022-08-10 09:42:03','',''),(4,'8','214','2',1,'Sale Id shift 2',0.00,0.00,0.00,2370.17,0.00,'2022-08-10 09:42:03','',''),(5,'8','214','2',1,'Sale Id shift 2',0.00,0.00,0.00,2538.19,0.00,'2022-08-10 09:42:03','',''),(6,'8','214',NULL,1,'Sale Id shift 2',0.00,0.00,0.00,0.00,0.00,'2022-08-10 09:42:03','',''),(7,'8','214',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,23400.00,0.00,'2022-08-11 15:29:41','',''),(8,'8','214','2',1,'Received from bridging 2',0.00,0.00,23400.00,0.00,0.00,'2022-08-11 15:29:41','',''),(9,'8','214',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,31600.00,0.00,'2022-08-11 15:30:39','',''),(10,'8','214','1',1,'Received from bridging 1',0.00,0.00,31600.00,0.00,0.00,'2022-08-11 15:30:39','',''),(11,'8','214','1',1,'Sale Id shift 3',0.00,0.00,0.00,1014.35,0.00,'2022-08-12 14:11:38','',''),(12,'8','214','1',1,'Sale Id shift 3',0.00,0.00,0.00,1179.43,0.00,'2022-08-12 14:11:38','',''),(13,'8','214','2',1,'Sale Id shift 3',0.00,0.00,0.00,1181.70,0.00,'2022-08-12 14:11:38','',''),(14,'8','214','2',1,'Sale Id shift 3',0.00,0.00,0.00,2327.29,0.00,'2022-08-12 14:11:38','',''),(15,'8','214',NULL,1,'Sale Id shift 3',1226095.55,0.00,0.00,0.00,0.00,'2022-08-12 14:11:38','',''),(16,'8','214','1',1,'Sale Id shift 4',0.00,0.00,0.00,1120.03,0.00,'2022-08-12 22:04:46','',''),(17,'8','214','1',1,'Sale Id shift 4',0.00,0.00,0.00,1370.15,0.00,'2022-08-12 22:04:46','',''),(18,'8','214','2',1,'Sale Id shift 4',0.00,0.00,0.00,1085.26,0.00,'2022-08-12 22:04:46','',''),(19,'8','214','2',1,'Sale Id shift 4',0.00,0.00,0.00,2001.97,0.00,'2022-08-12 22:04:46','',''),(20,'8','214',NULL,1,'Sale Id shift 4',1199143.15,0.00,0.00,0.00,0.00,'2022-08-12 22:04:46','',''),(21,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,10621000.00,49400.00,0.00,0.00,'2022-08-13 21:17:58','',''),(22,'8','214','1',1,'Sale Id shift 5',0.00,0.00,0.00,1437.11,0.00,'2022-08-13 21:58:02','',''),(23,'8','214','1',1,'Sale Id shift 5',0.00,0.00,0.00,879.60,0.00,'2022-08-13 21:58:02','',''),(24,'8','214','2',1,'Sale Id shift 5',0.00,0.00,0.00,2547.36,0.00,'2022-08-13 21:58:02','',''),(25,'8','214','2',1,'Sale Id shift 5',0.00,0.00,0.00,858.06,0.00,'2022-08-13 21:58:02','',''),(26,'8','214',NULL,1,'Sale Id shift 5',1230257.95,0.00,0.00,0.00,0.00,'2022-08-13 21:58:02','',''),(27,'8','214','1',1,'Sale Id shift 6',0.00,0.00,0.00,857.39,0.00,'2022-08-14 09:51:43','',''),(28,'8','214','1',1,'Sale Id shift 6',0.00,0.00,0.00,868.38,0.00,'2022-08-14 09:51:43','',''),(29,'8','214','2',1,'Sale Id shift 6',0.00,0.00,0.00,1253.43,0.00,'2022-08-14 09:51:43','',''),(30,'8','214','2',1,'Sale Id shift 6',0.00,0.00,0.00,2190.44,0.00,'2022-08-14 09:51:43','',''),(31,'8','214',NULL,1,'Sale Id shift 6',1111472.60,0.00,0.00,0.00,0.00,'2022-08-14 09:51:43','',''),(32,'8','214',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,32300.00,0.00,'2022-08-14 16:09:30','',''),(33,'8','214','2',1,'Received from bridging 4',0.00,0.00,32300.00,0.00,0.00,'2022-08-14 16:09:30','',''),(34,'8','214',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,17100.00,0.00,'2022-08-14 16:09:30','',''),(35,'8','214','1',1,'Received from bridging 3',0.00,0.00,17100.00,0.00,0.00,'2022-08-14 16:09:30','',''),(36,'8','214','1',1,'Sale Id shift 7',0.00,0.00,0.00,1134.73,0.00,'2022-08-16 09:40:52','',''),(37,'8','214','1',1,'Sale Id shift 7',0.00,0.00,0.00,920.86,0.00,'2022-08-16 09:40:52','',''),(38,'8','214','2',1,'Sale Id shift 7',0.00,0.00,0.00,928.99,0.00,'2022-08-16 09:40:52','',''),(39,'8','214','2',1,'Sale Id shift 7',0.00,0.00,0.00,2069.12,0.00,'2022-08-16 09:40:52','',''),(40,'8','214',NULL,1,'Sale Id shift 7',1086545.50,0.00,0.00,0.00,0.00,'2022-08-16 09:40:52','',''),(41,'8','214','1',1,'Sale Id shift 8',0.00,0.00,0.00,1022.54,0.00,'2022-08-20 10:14:31','',''),(42,'8','214','1',1,'Sale Id shift 8',0.00,0.00,0.00,1606.91,0.00,'2022-08-20 10:14:31','',''),(43,'8','214','2',1,'Sale Id shift 8',0.00,0.00,0.00,1148.54,0.00,'2022-08-20 10:14:31','',''),(44,'8','214','2',1,'Sale Id shift 8',0.00,0.00,0.00,1621.50,0.00,'2022-08-20 10:14:31','',''),(45,'8','214',NULL,1,'Sale Id shift 8',1160890.35,0.00,0.00,0.00,0.00,'2022-08-20 10:14:31','',''),(46,'8','214','1',1,'Sale Id shift 9',0.00,0.00,0.00,1697.40,0.00,'2022-08-20 10:19:27','',''),(47,'8','214','1',1,'Sale Id shift 9',0.00,0.00,0.00,2354.02,0.00,'2022-08-20 10:19:27','',''),(48,'8','214','2',1,'Sale Id shift 9',0.00,0.00,0.00,1696.64,0.00,'2022-08-20 10:19:27','',''),(49,'8','214','2',1,'Sale Id shift 9',0.00,0.00,0.00,874.09,0.00,'2022-08-20 10:19:27','',''),(50,'8','214',NULL,1,'Sale Id shift 9',1423762.25,0.00,0.00,0.00,0.00,'2022-08-20 10:19:27','',''),(51,'8','214','1',1,'Sale Id shift 10',0.00,0.00,0.00,746.40,0.00,'2022-08-20 10:26:38','',''),(52,'8','214','1',1,'Sale Id shift 10',0.00,0.00,0.00,1295.60,0.00,'2022-08-20 10:26:38','',''),(53,'8','214','2',1,'Sale Id shift 10',0.00,0.00,0.00,2910.17,0.00,'2022-08-20 10:26:38','',''),(54,'8','214',NULL,1,'Sale Id shift 10',1064716.55,0.00,0.00,0.00,0.00,'2022-08-20 10:26:38','',''),(55,'8','214','1',1,'Sale Id shift 11',0.00,0.00,0.00,182.25,0.00,'2022-08-20 10:34:14','',''),(56,'8','214','1',1,'Sale Id shift 11',0.00,0.00,0.00,1822.41,0.00,'2022-08-20 10:34:14','',''),(57,'8','214','2',1,'Sale Id shift 11',0.00,0.00,0.00,2257.33,0.00,'2022-08-20 10:34:14','',''),(58,'8','214','2',1,'Sale Id shift 11',0.00,0.00,0.00,1257.63,0.00,'2022-08-20 10:34:14','',''),(59,'8','214',NULL,1,'Sale Id shift 11',1186718.30,0.00,0.00,0.00,0.00,'2022-08-20 10:34:14','',''),(60,'8','214','1',1,'Sale Id shift 12',0.00,0.00,0.00,792.35,0.00,'2022-08-20 10:54:48','',''),(61,'8','214','1',1,'Sale Id shift 12',0.00,0.00,0.00,1035.51,0.00,'2022-08-20 10:54:48','',''),(62,'8','214','2',1,'Sale Id shift 12',0.00,0.00,0.00,1638.19,0.00,'2022-08-20 10:54:48','',''),(63,'8','214','2',1,'Sale Id shift 12',0.00,0.00,0.00,809.69,0.00,'2022-08-20 10:54:48','',''),(64,'8','214',NULL,1,'Sale Id shift 12',919284.10,0.00,0.00,0.00,0.00,'2022-08-20 10:54:48','',''),(65,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,3487950.00,16850.00,0.00,0.00,'2022-08-21 08:12:15','',''),(66,'8','214',NULL,1,'Returned purchase #3 to Lausu Energy Resources',3487950.00,0.00,0.00,16850.00,0.00,'2022-08-21 08:33:57','',''),(67,'8','214','1',1,'Sale Id shift 13',0.00,0.00,0.00,1021.12,0.00,'2022-08-21 19:33:22','',''),(68,'8','214','1',1,'Sale Id shift 13',0.00,0.00,0.00,1275.85,0.00,'2022-08-21 19:33:22','',''),(69,'8','214','2',1,'Sale Id shift 13',0.00,0.00,0.00,1088.28,0.00,'2022-08-21 19:33:22','',''),(70,'8','214','2',1,'Sale Id shift 13',0.00,0.00,0.00,1920.55,0.00,'2022-08-21 19:33:22','',''),(71,'8','214',NULL,1,'Sale Id shift 13',1140747.00,0.00,0.00,0.00,0.00,'2022-08-21 19:33:22','',''),(74,'8','214','1',1,'Sale Id shift 14',0.00,0.00,0.00,974.95,0.00,'2022-08-23 07:43:47','',''),(75,'8','214','1',1,'Sale Id shift 14',0.00,0.00,0.00,1445.30,0.00,'2022-08-23 07:43:47','',''),(76,'8','214','2',1,'Sale Id shift 14',0.00,0.00,0.00,2506.76,0.00,'2022-08-23 07:43:47','',''),(77,'8','214','2',1,'Sale Id shift 14',0.00,0.00,0.00,1136.00,0.00,'2022-08-23 07:43:47','',''),(78,'8','214',NULL,1,'Sale Id shift 14',1255043.07,0.00,0.00,0.00,0.00,'2022-08-23 07:43:47','',''),(79,'8','214','1',1,'Sale Id shift 15',0.00,0.00,0.00,957.29,0.00,'2022-08-23 11:53:34','',''),(80,'8','214','1',1,'Sale Id shift 15',0.00,0.00,0.00,1279.70,0.00,'2022-08-23 11:53:34','',''),(81,'8','214','2',1,'Sale Id shift 15',0.00,0.00,0.00,916.09,0.00,'2022-08-23 11:53:34','',''),(82,'8','214','2',1,'Sale Id shift 15',0.00,0.00,0.00,1275.09,0.00,'2022-08-23 11:53:34','',''),(83,'8','214',NULL,1,'Sale Id shift 15',916631.19,0.00,0.00,0.00,0.00,'2022-08-23 11:53:34','',''),(84,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,3400000.00,17000.00,0.00,0.00,'2022-08-23 15:11:28','',''),(89,'8','214','1',1,'Sale Id shift 16',0.00,0.00,0.00,1422.35,0.00,'2022-08-24 17:30:40','',''),(90,'8','214','1',1,'Sale Id shift 16',0.00,0.00,0.00,2125.68,0.00,'2022-08-24 17:30:40','',''),(91,'8','214','2',1,'Sale Id shift 16',0.00,0.00,0.00,1342.64,0.00,'2022-08-24 17:30:40','',''),(92,'8','214','2',1,'Sale Id shift 16',0.00,0.00,0.00,2087.32,0.00,'2022-08-24 17:30:40','',''),(93,'8','214',NULL,1,'Sale Id shift 16',1395598.00,0.00,0.00,0.00,0.00,'2022-08-24 17:30:40','',''),(94,'8','214','1',1,'Sale Id shift 17',0.00,0.00,0.00,1157.18,0.00,'2022-08-25 07:41:27','',''),(95,'8','214','1',1,'Sale Id shift 17',0.00,0.00,0.00,1002.55,0.00,'2022-08-25 07:41:27','',''),(96,'8','214','2',1,'Sale Id shift 17',0.00,0.00,0.00,1727.17,0.00,'2022-08-25 07:41:27','',''),(97,'8','214','2',1,'Sale Id shift 17',0.00,0.00,0.00,809.81,0.00,'2022-08-25 07:41:27','',''),(98,'8','214',NULL,1,'Sale Id shift 17',939342.00,0.00,0.00,0.00,0.00,'2022-08-25 07:41:27','',''),(99,'8','214','1',1,'Sale Id shift 18',0.00,0.00,0.00,1285.20,0.00,'2022-08-26 08:05:08','',''),(100,'8','214','1',1,'Sale Id shift 18',0.00,0.00,0.00,1363.51,0.00,'2022-08-26 08:05:08','',''),(101,'8','214','2',1,'Sale Id shift 18',0.00,0.00,0.00,2078.89,0.00,'2022-08-26 08:05:08','',''),(102,'8','214','2',1,'Sale Id shift 18',0.00,0.00,0.00,444.58,0.00,'2022-08-26 08:05:08','',''),(103,'8','214',NULL,1,'Sale Id shift 18',1034436.00,0.00,0.00,0.00,0.00,'2022-08-26 08:05:08','',''),(104,'8','214',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,17000.00,0.00,'2022-08-28 13:05:26','',''),(105,'8','214','2',1,'Received from bridging 7',0.00,0.00,17000.00,0.00,0.00,'2022-08-28 13:05:26','',''),(106,'8','214','1',1,'Sale Id shift 19',0.00,0.00,0.00,1350.82,0.00,'2022-08-28 15:36:06','',''),(107,'8','214','1',1,'Sale Id shift 19',0.00,0.00,0.00,1234.60,0.00,'2022-08-28 15:36:06','',''),(108,'8','214','2',1,'Sale Id shift 19',0.00,0.00,0.00,2379.82,0.00,'2022-08-28 15:36:06','',''),(109,'8','214','2',1,'Sale Id shift 19',0.00,0.00,0.00,1242.07,0.00,'2022-08-28 15:36:06','',''),(110,'8','214',NULL,1,'Sale Id shift 19',1241462.00,0.00,0.00,0.00,0.00,'2022-08-28 15:36:06','',''),(115,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,3487950.00,16850.00,0.00,0.00,'2022-08-28 17:21:53','',''),(116,'8','214',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,16850.00,0.00,'2022-08-28 17:27:15','',''),(117,'8','214','1',1,'Received from bridging 8',0.00,0.00,16850.00,0.00,0.00,'2022-08-28 17:27:15','',''),(118,'8','214','1',1,'Sale Id shift 20',0.00,0.00,0.00,1143.07,0.00,'2022-08-28 18:58:47','',''),(119,'8','214','1',1,'Sale Id shift 20',0.00,0.00,0.00,1517.80,0.00,'2022-08-28 18:58:47','',''),(120,'8','214','2',1,'Sale Id shift 20',0.00,0.00,0.00,2352.04,0.00,'2022-08-28 18:58:47','',''),(121,'8','214','2',1,'Sale Id shift 20',0.00,0.00,0.00,1070.67,0.00,'2022-08-28 18:58:47','',''),(122,'8','214',NULL,1,'Sale Id shift 20',1216716.00,0.00,0.00,0.00,0.00,'2022-08-28 18:58:47','',''),(123,'8','214','1',1,'Sale Id shift 21',0.00,0.00,0.00,1119.15,0.00,'2022-08-29 08:16:27','',''),(124,'8','214','1',1,'Sale Id shift 21',0.00,0.00,0.00,1180.37,0.00,'2022-08-29 08:16:27','',''),(125,'8','214','2',1,'Sale Id shift 21',0.00,0.00,0.00,1086.27,0.00,'2022-08-29 08:16:27','',''),(126,'8','214','2',1,'Sale Id shift 21',0.00,0.00,0.00,2303.73,0.00,'2022-08-29 08:16:27','',''),(127,'8','214',NULL,1,'Sale Id shift 21',1177730.64,0.00,0.00,0.00,0.00,'2022-08-29 08:16:27','',''),(128,'8','214','1',1,'Sale Id shift 22',0.00,0.00,0.00,1330.10,0.00,'2022-08-30 08:01:04','',''),(129,'8','214','1',1,'Sale Id shift 22',0.00,0.00,0.00,1246.89,0.00,'2022-08-30 08:01:04','',''),(130,'8','214','2',1,'Sale Id shift 22',0.00,0.00,0.00,2280.94,0.00,'2022-08-30 08:01:04','',''),(131,'8','214','2',1,'Sale Id shift 22',0.00,0.00,0.00,822.70,0.00,'2022-08-30 08:01:04','',''),(132,'8','214',NULL,1,'Sale Id shift 22',1175890.41,0.00,0.00,0.00,0.00,'2022-08-30 08:01:04','',''),(133,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,9462000.00,49800.00,0.00,0.00,'2022-08-30 13:43:48','',''),(134,'8','214',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,29200.00,0.00,'2022-08-31 07:55:34','',''),(135,'8','214','2',1,'Received from bridging 10',0.00,0.00,29200.00,0.00,0.00,'2022-08-31 07:55:34','',''),(136,'8','214',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,20600.00,0.00,'2022-08-31 07:55:34','',''),(137,'8','214','1',1,'Received from bridging 9',0.00,0.00,20600.00,0.00,0.00,'2022-08-31 07:55:34','',''),(138,'8','214','1',1,'Sale Id shift 23',0.00,0.00,0.00,3210.23,0.00,'2022-08-31 08:00:18','',''),(139,'8','214','1',1,'Sale Id shift 23',0.00,0.00,0.00,4336.07,0.00,'2022-08-31 08:00:18','',''),(140,'8','214','2',1,'Sale Id shift 23',0.00,0.00,0.00,2682.54,0.00,'2022-08-31 08:00:18','',''),(141,'8','214','2',1,'Sale Id shift 23',0.00,0.00,0.00,4319.34,0.00,'2022-08-31 08:00:18','',''),(142,'8','214',NULL,1,'Sale Id shift 23',2764154.20,0.00,0.00,0.00,0.00,'2022-08-31 08:00:18','',''),(143,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,3420000.00,18000.00,0.00,0.00,'2022-09-01 15:59:53','',''),(144,'8','214','1',1,'Sale Id shift 24',0.00,0.00,0.00,844.67,0.00,'2022-09-02 10:11:15','',''),(145,'8','214','1',1,'Sale Id shift 24',0.00,0.00,0.00,1509.72,0.00,'2022-09-02 10:11:15','',''),(146,'8','214','2',1,'Sale Id shift 24',0.00,0.00,0.00,1111.43,0.00,'2022-09-02 10:11:15','',''),(147,'8','214','2',1,'Sale Id shift 24',0.00,0.00,0.00,2049.42,0.00,'2022-09-02 10:11:15','',''),(148,'8','214',NULL,1,'Sale Id shift 24',1047895.60,0.00,0.00,0.00,0.00,'2022-09-02 10:11:15','',''),(149,'8','214','1',1,'Sale Id shift 25',0.00,0.00,0.00,1519.63,0.00,'2022-09-02 10:16:52','',''),(150,'8','214','1',1,'Sale Id shift 25',0.00,0.00,0.00,1554.38,0.00,'2022-09-02 10:16:52','',''),(151,'8','214','2',1,'Sale Id shift 25',0.00,0.00,0.00,2147.35,0.00,'2022-09-02 10:16:52','',''),(152,'8','214','2',1,'Sale Id shift 25',0.00,0.00,0.00,860.65,0.00,'2022-09-02 10:16:52','',''),(153,'8','214',NULL,1,'Sale Id shift 25',1155581.90,0.00,0.00,0.00,0.00,'2022-09-02 10:16:52','',''),(154,'8','214',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,18000.00,0.00,'2022-09-03 08:26:32','',''),(155,'8','214','1',1,'Received from bridging 11',0.00,0.00,18000.00,0.00,0.00,'2022-09-03 08:26:32','',''),(156,'8','214','1',1,'Sale Id shift 26',0.00,0.00,0.00,1641.24,0.00,'2022-09-03 08:40:24','',''),(157,'8','214','1',1,'Sale Id shift 26',0.00,0.00,0.00,2022.93,0.00,'2022-09-03 08:40:24','',''),(158,'8','214','2',1,'Sale Id shift 26',0.00,0.00,0.00,1680.36,0.00,'2022-09-03 08:40:24','',''),(159,'8','214','2',1,'Sale Id shift 26',0.00,0.00,0.00,1597.19,0.00,'2022-09-03 08:40:24','',''),(160,'8','214',NULL,1,'Sale Id shift 26',1318926.80,0.00,0.00,0.00,0.00,'2022-09-03 08:40:24','',''),(161,'8','214','1',1,'Sale Id shift 27',0.00,0.00,0.00,1384.99,0.00,'2022-09-04 08:32:06','',''),(162,'8','214','1',1,'Sale Id shift 27',0.00,0.00,0.00,2035.50,0.00,'2022-09-04 08:32:06','',''),(163,'8','214','2',1,'Sale Id shift 27',0.00,0.00,0.00,1294.76,0.00,'2022-09-04 08:32:06','',''),(164,'8','214','2',1,'Sale Id shift 27',0.00,0.00,0.00,2034.76,0.00,'2022-09-04 08:32:06','',''),(165,'8','214',NULL,1,'Sale Id shift 27',1282501.90,0.00,0.00,0.00,0.00,'2022-09-04 08:32:06','',''),(166,'8','214','1',1,'Sale Id shift 28',0.00,0.00,0.00,1107.00,0.00,'2022-09-05 07:56:18','',''),(167,'8','214','1',1,'Sale Id shift 28',0.00,0.00,0.00,1055.38,0.00,'2022-09-05 07:56:18','',''),(168,'8','214','2',1,'Sale Id shift 28',0.00,0.00,0.00,752.06,0.00,'2022-09-05 07:56:18','',''),(169,'8','214','2',1,'Sale Id shift 28',0.00,0.00,0.00,1721.68,0.00,'2022-09-05 07:56:18','',''),(170,'8','214',NULL,1,'Sale Id shift 28',880862.80,0.00,0.00,0.00,0.00,'2022-09-05 07:56:18','',''),(171,'8','214','1',1,'Sale Id shift 29',0.00,0.00,0.00,1109.10,0.00,'2022-09-06 07:52:35','',''),(172,'8','214','1',1,'Sale Id shift 29',0.00,0.00,0.00,1034.22,0.00,'2022-09-06 07:52:35','',''),(173,'8','214','2',1,'Sale Id shift 29',0.00,0.00,0.00,1015.02,0.00,'2022-09-06 07:52:35','',''),(174,'8','214','2',1,'Sale Id shift 29',0.00,0.00,0.00,1173.49,0.00,'2022-09-06 07:52:35','',''),(175,'8','214',NULL,1,'Sale Id shift 29',823047.70,0.00,0.00,0.00,0.00,'2022-09-06 07:52:35','',''),(176,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,6270000.00,33000.00,0.00,0.00,'2022-09-06 17:56:36','',''),(177,'8','214','1',1,'Sale Id shift 30',0.00,0.00,0.00,1912.00,0.00,'2022-09-07 08:17:22','',''),(178,'8','214','1',1,'Sale Id shift 30',0.00,0.00,0.00,2586.49,0.00,'2022-09-07 08:17:22','',''),(179,'8','214','2',1,'Sale Id shift 30',0.00,0.00,0.00,2572.65,0.00,'2022-09-07 08:17:22','',''),(180,'8','214','2',1,'Sale Id shift 30',0.00,0.00,0.00,2755.17,0.00,'2022-09-07 08:17:22','',''),(181,'8','214',NULL,1,'Sale Id shift 30',1866998.90,0.00,0.00,0.00,0.00,'2022-09-07 08:17:22','',''),(182,'8','214','1',1,'Sale Id shift 31',0.00,0.00,0.00,1120.00,0.00,'2022-09-08 08:23:57','',''),(183,'8','214','1',1,'Sale Id shift 31',0.00,0.00,0.00,1005.21,0.00,'2022-09-08 08:23:57','',''),(184,'8','214','2',1,'Sale Id shift 31',0.00,0.00,0.00,794.94,0.00,'2022-09-08 08:23:57','',''),(185,'8','214','2',1,'Sale Id shift 31',0.00,0.00,0.00,613.53,0.00,'2022-09-08 08:23:57','',''),(186,'8','214',NULL,1,'Sale Id shift 31',671399.20,0.00,0.00,0.00,0.00,'2022-09-08 08:23:57','',''),(189,'8','214',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,16200.00,0.00,'2022-09-08 13:30:24','',''),(190,'8','214','1',1,'Received from bridging 12',0.00,0.00,16200.00,0.00,0.00,'2022-09-08 13:30:24','',''),(191,'8','214',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,16800.00,0.00,'2022-09-08 13:30:38','',''),(192,'8','214','2',1,'Received from bridging 13',0.00,0.00,16800.00,0.00,0.00,'2022-09-08 13:30:38','',''),(193,'8','214','1',1,'Sale Id shift 32',0.00,0.00,0.00,903.36,0.00,'2022-09-09 08:42:32','',''),(194,'8','214','1',1,'Sale Id shift 32',0.00,0.00,0.00,1737.37,0.00,'2022-09-09 08:42:32','',''),(195,'8','214','2',1,'Sale Id shift 32',0.00,0.00,0.00,661.92,0.00,'2022-09-09 08:42:32','',''),(196,'8','214','2',1,'Sale Id shift 32',0.00,0.00,0.00,1194.48,0.00,'2022-09-09 08:42:32','',''),(197,'8','214',NULL,1,'Sale Id shift 32',854454.70,0.00,0.00,0.00,0.00,'2022-09-09 08:42:32','',''),(198,'8','214','1',1,'Sale Id shift 33',0.00,0.00,0.00,659.15,0.00,'2022-09-10 07:46:45','',''),(199,'8','214','1',1,'Sale Id shift 33',0.00,0.00,0.00,797.81,0.00,'2022-09-10 07:46:45','',''),(200,'8','214','2',1,'Sale Id shift 33',0.00,0.00,0.00,918.32,0.00,'2022-09-10 07:46:45','',''),(201,'8','214','2',1,'Sale Id shift 33',0.00,0.00,0.00,635.72,0.00,'2022-09-10 07:46:45','',''),(202,'8','214',NULL,1,'Sale Id shift 33',572090.00,0.00,0.00,0.00,0.00,'2022-09-10 07:46:45','',''),(203,'8','214','1',1,'Sale Id shift 34',0.00,0.00,0.00,686.40,0.00,'2022-09-11 08:21:50','',''),(204,'8','214','1',1,'Sale Id shift 34',0.00,0.00,0.00,1003.88,0.00,'2022-09-11 08:21:50','',''),(205,'8','214','2',1,'Sale Id shift 34',0.00,0.00,0.00,651.29,0.00,'2022-09-11 08:21:50','',''),(206,'8','214','2',1,'Sale Id shift 34',0.00,0.00,0.00,762.60,0.00,'2022-09-11 08:21:50','',''),(207,'8','214',NULL,1,'Sale Id shift 34',589792.30,0.00,0.00,0.00,0.00,'2022-09-11 08:21:50','',''),(208,'8','214','1',1,'Sale Id shift 35',0.00,0.00,0.00,928.40,0.00,'2022-09-12 07:51:37','',''),(209,'8','214','1',1,'Sale Id shift 35',0.00,0.00,0.00,948.09,0.00,'2022-09-12 07:51:37','',''),(210,'8','214','2',1,'Sale Id shift 35',0.00,0.00,0.00,1117.82,0.00,'2022-09-12 07:51:37','',''),(211,'8','214','2',1,'Sale Id shift 35',0.00,0.00,0.00,493.96,0.00,'2022-09-12 07:51:37','',''),(212,'8','214',NULL,1,'Sale Id shift 35',662771.30,0.00,0.00,0.00,0.00,'2022-09-12 07:51:37','',''),(213,'8','214','1',1,'Sale Id shift 36',0.00,0.00,0.00,1189.07,0.00,'2022-09-13 09:48:36','',''),(214,'8','214','1',1,'Sale Id shift 36',0.00,0.00,0.00,1945.80,0.00,'2022-09-13 09:48:36','',''),(215,'8','214','2',1,'Sale Id shift 36',0.00,0.00,0.00,1156.27,0.00,'2022-09-13 09:48:36','',''),(216,'8','214','2',1,'Sale Id shift 36',0.00,0.00,0.00,2557.39,0.00,'2022-09-13 09:48:36','',''),(217,'8','214',NULL,1,'Sale Id shift 36',1301220.70,0.00,0.00,0.00,0.00,'2022-09-13 09:48:36','',''),(218,'8','214','1',1,'Sale Id shift 37',0.00,0.00,0.00,3618.34,0.00,'2022-09-14 08:17:15','',''),(219,'8','214','1',1,'Sale Id shift 37',0.00,0.00,0.00,4565.45,0.00,'2022-09-14 08:17:15','',''),(220,'8','214','2',1,'Sale Id shift 37',0.00,0.00,0.00,4204.90,0.00,'2022-09-14 08:17:15','',''),(221,'8','214','2',1,'Sale Id shift 37',0.00,0.00,0.00,2949.48,0.00,'2022-09-14 08:17:15','',''),(222,'8','214',NULL,1,'Sale Id shift 37',2914252.30,0.00,0.00,0.00,0.00,'2022-09-14 08:17:15','',''),(223,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,9481000.00,49900.00,0.00,0.00,'2022-09-14 21:57:34','',''),(224,'8','214','1',1,'Sale Id shift 38',0.00,0.00,0.00,935.63,0.00,'2022-09-15 07:52:57','',''),(225,'8','214','1',1,'Sale Id shift 38',0.00,0.00,0.00,1711.92,0.00,'2022-09-15 07:52:57','',''),(226,'8','214','2',1,'Sale Id shift 38',0.00,0.00,0.00,1415.27,0.00,'2022-09-15 07:52:57','',''),(227,'8','214','2',1,'Sale Id shift 38',0.00,0.00,0.00,908.39,0.00,'2022-09-15 07:52:57','',''),(228,'8','214',NULL,1,'Sale Id shift 38',944529.90,0.00,0.00,0.00,0.00,'2022-09-15 07:52:57','',''),(229,'8','214',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,32250.00,0.00,'2022-09-16 15:17:34','',''),(230,'8','214','2',1,'Received from bridging 15',0.00,0.00,32250.00,0.00,0.00,'2022-09-16 15:17:34','',''),(231,'8','214',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,17650.00,0.00,'2022-09-16 15:17:50','',''),(232,'8','214','1',1,'Received from bridging 14',0.00,0.00,17650.00,0.00,0.00,'2022-09-16 15:17:50','',''),(233,'8','214','1',1,'Sale Id shift 39',0.00,0.00,0.00,1148.23,0.00,'2022-09-16 15:28:32','',''),(234,'8','214','1',1,'Sale Id shift 39',0.00,0.00,0.00,2078.29,0.00,'2022-09-16 15:28:32','',''),(235,'8','214','2',1,'Sale Id shift 39',0.00,0.00,0.00,893.72,0.00,'2022-09-16 15:28:32','',''),(236,'8','214','2',1,'Sale Id shift 39',0.00,0.00,0.00,1853.48,0.00,'2022-09-16 15:28:32','',''),(237,'8','214',NULL,1,'Sale Id shift 39',1135006.80,0.00,0.00,0.00,0.00,'2022-09-16 15:28:32','',''),(238,'8','214','1',1,'Sale Id shift 40',0.00,0.00,0.00,1234.12,0.00,'2022-09-17 08:10:58','',''),(239,'8','214','1',1,'Sale Id shift 40',0.00,0.00,0.00,2060.14,0.00,'2022-09-17 08:10:58','',''),(240,'8','214','2',1,'Sale Id shift 40',0.00,0.00,0.00,1766.35,0.00,'2022-09-17 08:10:58','',''),(241,'8','214','2',1,'Sale Id shift 40',0.00,0.00,0.00,1087.77,0.00,'2022-09-17 08:10:58','',''),(242,'8','214',NULL,1,'Sale Id shift 40',1168192.20,0.00,0.00,0.00,0.00,'2022-09-17 08:10:58','',''),(243,'8','214','1',1,'Sale Id shift 41',0.00,0.00,0.00,1203.19,0.00,'2022-09-18 09:45:08','',''),(244,'8','214','1',1,'Sale Id shift 41',0.00,0.00,0.00,1371.52,0.00,'2022-09-18 09:45:08','',''),(245,'8','214','2',1,'Sale Id shift 41',0.00,0.00,0.00,1637.12,0.00,'2022-09-18 09:45:08','',''),(246,'8','214','2',1,'Sale Id shift 41',0.00,0.00,0.00,2057.09,0.00,'2022-09-18 09:45:08','',''),(247,'8','214',NULL,1,'Sale Id shift 41',1191094.80,0.00,0.00,0.00,0.00,'2022-09-18 09:45:08','',''),(248,'8','214','1',1,'Sale Id shift 42',0.00,0.00,0.00,1042.61,0.00,'2022-09-20 08:25:26','',''),(249,'8','214','1',1,'Sale Id shift 42',0.00,0.00,0.00,2500.31,0.00,'2022-09-20 08:25:26','',''),(250,'8','214','2',1,'Sale Id shift 42',0.00,0.00,0.00,2269.63,0.00,'2022-09-20 08:25:26','',''),(251,'8','214','2',1,'Sale Id shift 42',0.00,0.00,0.00,1140.50,0.00,'2022-09-20 08:25:26','',''),(252,'8','214',NULL,1,'Sale Id shift 42',1321079.50,0.00,0.00,0.00,0.00,'2022-09-20 08:25:26','',''),(253,'8','214','1',1,'Sale Id shift 43',0.00,0.00,0.00,1073.84,0.00,'2022-09-20 08:30:29','',''),(254,'8','214','1',1,'Sale Id shift 43',0.00,0.00,0.00,2344.48,0.00,'2022-09-20 08:30:29','',''),(255,'8','214','2',1,'Sale Id shift 43',0.00,0.00,0.00,813.05,0.00,'2022-09-20 08:30:29','',''),(256,'8','214','2',1,'Sale Id shift 43',0.00,0.00,0.00,1740.16,0.00,'2022-09-20 08:30:29','',''),(257,'8','214',NULL,1,'Sale Id shift 43',1134590.70,0.00,0.00,0.00,0.00,'2022-09-20 08:30:29','',''),(258,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,3230000.00,17000.00,0.00,0.00,'2022-09-20 12:26:01','',''),(259,'8','214',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,17000.00,0.00,'2022-09-20 13:50:40','',''),(260,'8','214','1',1,'Received from bridging 16',0.00,0.00,17000.00,0.00,0.00,'2022-09-20 13:50:40','',''),(261,'8','214','1',1,'Sale Id shift 44',0.00,0.00,0.00,2643.52,0.00,'2022-09-21 08:47:24','',''),(262,'8','214','1',1,'Sale Id shift 44',0.00,0.00,0.00,3910.65,0.00,'2022-09-21 08:47:24','',''),(263,'8','214','2',1,'Sale Id shift 44',0.00,0.00,0.00,4137.52,0.00,'2022-09-21 08:47:24','',''),(264,'8','214','2',1,'Sale Id shift 44',0.00,0.00,0.00,3270.69,0.00,'2022-09-21 08:47:24','',''),(265,'8','214',NULL,1,'Sale Id shift 44',2652852.20,0.00,0.00,0.00,0.00,'2022-09-21 08:47:24','',''),(266,'8','214','1',1,'Sale Id shift 45',0.00,0.00,0.00,1022.62,0.00,'2022-09-22 09:08:48','',''),(267,'8','214','1',1,'Sale Id shift 45',0.00,0.00,0.00,1962.65,0.00,'2022-09-22 09:08:48','',''),(268,'8','214','2',1,'Sale Id shift 45',0.00,0.00,0.00,1381.74,0.00,'2022-09-22 09:08:48','',''),(269,'8','214','2',1,'Sale Id shift 45',0.00,0.00,0.00,1641.95,0.00,'2022-09-22 09:08:48','',''),(270,'8','214',NULL,1,'Sale Id shift 45',1141702.40,0.00,0.00,0.00,0.00,'2022-09-22 09:08:48','',''),(271,'8','214','1',1,'Sale Id shift 46',0.00,0.00,0.00,2233.78,0.00,'2022-09-23 08:03:22','',''),(272,'8','214','1',1,'Sale Id shift 46',0.00,0.00,0.00,1447.44,0.00,'2022-09-23 08:03:22','',''),(273,'8','214','2',1,'Sale Id shift 46',0.00,0.00,0.00,1603.82,0.00,'2022-09-23 08:03:22','',''),(274,'8','214','2',1,'Sale Id shift 46',0.00,0.00,0.00,1092.82,0.00,'2022-09-23 08:03:22','',''),(275,'8','214',NULL,1,'Sale Id shift 46',1211793.40,0.00,0.00,0.00,0.00,'2022-09-23 08:03:22','',''),(276,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,9376500.00,49350.00,0.00,0.00,'2022-09-23 08:24:08','',''),(277,'8','214','1',1,'Sale Id shift 47',0.00,0.00,0.00,1584.91,0.00,'2022-09-24 08:35:59','',''),(278,'8','214','1',1,'Sale Id shift 47',0.00,0.00,0.00,1825.93,0.00,'2022-09-24 08:35:59','',''),(279,'8','214','2',1,'Sale Id shift 47',0.00,0.00,0.00,1987.27,0.00,'2022-09-24 08:35:59','',''),(280,'8','214','2',1,'Sale Id shift 47',0.00,0.00,0.00,1496.86,0.00,'2022-09-24 08:35:59','',''),(281,'8','214',NULL,1,'Sale Id shift 47',1310044.30,0.00,0.00,0.00,0.00,'2022-09-24 08:35:59','',''),(282,'8','214',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,17500.00,0.00,'2022-09-25 09:23:58','',''),(283,'8','214','1',1,'Received from bridging 17',0.00,0.00,17500.00,0.00,0.00,'2022-09-25 09:23:58','',''),(284,'8','214',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,31850.00,0.00,'2022-09-25 09:37:27','',''),(285,'8','214','2',1,'Received from bridging 18',0.00,0.00,31850.00,0.00,0.00,'2022-09-25 09:37:27','',''),(286,'8','214','1',1,'Sale Id shift 48',0.00,0.00,0.00,1138.46,0.00,'2022-09-25 10:49:14','',''),(287,'8','214','1',1,'Sale Id shift 48',0.00,0.00,0.00,2516.33,0.00,'2022-09-25 10:49:14','',''),(288,'8','214','2',1,'Sale Id shift 48',0.00,0.00,0.00,1397.09,0.00,'2022-09-25 10:49:14','',''),(289,'8','214','2',1,'Sale Id shift 48',0.00,0.00,0.00,2217.39,0.00,'2022-09-25 10:49:14','',''),(290,'8','214',NULL,1,'Sale Id shift 48',1381161.30,0.00,0.00,0.00,0.00,'2022-09-25 10:49:14','',''),(291,'8','214','1',1,'Sale Id shift 49',0.00,0.00,0.00,1518.29,0.00,'2022-09-26 12:27:45','',''),(292,'8','214','1',1,'Sale Id shift 49',0.00,0.00,0.00,2332.03,0.00,'2022-09-26 12:27:45','',''),(293,'8','214','2',1,'Sale Id shift 49',0.00,0.00,0.00,2201.83,0.00,'2022-09-26 12:27:45','',''),(294,'8','214','2',1,'Sale Id shift 49',0.00,0.00,0.00,1239.77,0.00,'2022-09-26 12:27:45','',''),(295,'8','214',NULL,1,'Sale Id shift 49',1385464.80,0.00,0.00,0.00,0.00,'2022-09-26 12:27:45','',''),(296,'8','214','1',1,'Sale Id shift 50',0.00,0.00,0.00,1279.71,0.00,'2022-09-27 08:12:14','',''),(297,'8','214','1',1,'Sale Id shift 50',0.00,0.00,0.00,2837.11,0.00,'2022-09-27 08:12:14','',''),(298,'8','214','2',1,'Sale Id shift 50',0.00,0.00,0.00,1241.70,0.00,'2022-09-27 08:12:14','',''),(299,'8','214','2',1,'Sale Id shift 50',0.00,0.00,0.00,1554.86,0.00,'2022-09-27 08:12:14','',''),(300,'8','214',NULL,1,'Sale Id shift 50',1313542.20,0.00,0.00,0.00,0.00,'2022-09-27 08:12:14','',''),(301,'8','214','1',1,'Sale Id shift 51',0.00,0.00,0.00,3788.83,0.00,'2022-09-28 10:05:51','',''),(302,'8','214','1',1,'Sale Id shift 51',0.00,0.00,0.00,4482.03,0.00,'2022-09-28 10:05:51','',''),(303,'8','214','2',1,'Sale Id shift 51',0.00,0.00,0.00,5436.49,0.00,'2022-09-28 10:05:51','',''),(304,'8','214','2',1,'Sale Id shift 51',0.00,0.00,0.00,3997.98,0.00,'2022-09-28 10:05:51','',''),(305,'8','214',NULL,1,'Sale Id shift 51',3364012.70,0.00,0.00,0.00,0.00,'2022-09-28 10:05:51','',''),(306,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,3420000.00,18000.00,0.00,0.00,'2022-09-28 10:08:27','',''),(307,'8','214','1',1,'Sale Id shift 52',0.00,0.00,0.00,766.56,0.00,'2022-09-29 10:53:26','',''),(308,'8','214','1',1,'Sale Id shift 52',0.00,0.00,0.00,1641.38,0.00,'2022-09-29 10:53:26','',''),(309,'8','214','2',1,'Sale Id shift 52',0.00,0.00,0.00,1551.50,0.00,'2022-09-29 10:53:26','',''),(310,'8','214','2',1,'Sale Id shift 52',0.00,0.00,0.00,638.79,0.00,'2022-09-29 10:53:26','',''),(311,'8','214',NULL,1,'Sale Id shift 52',873663.70,0.00,0.00,0.00,0.00,'2022-09-29 10:53:26','',''),(312,'8','214','1',1,'Sale Id shift 53',0.00,0.00,0.00,738.70,0.00,'2022-09-30 07:52:33','',''),(313,'8','214','1',1,'Sale Id shift 53',0.00,0.00,0.00,1389.24,0.00,'2022-09-30 07:52:33','',''),(314,'8','214','2',1,'Sale Id shift 53',0.00,0.00,0.00,515.26,0.00,'2022-09-30 07:52:33','',''),(315,'8','214','2',1,'Sale Id shift 53',0.00,0.00,0.00,872.62,0.00,'2022-09-30 07:52:33','',''),(316,'8','214',NULL,1,'Sale Id shift 53',668005.80,0.00,0.00,0.00,0.00,'2022-09-30 07:52:33','',''),(317,'8','214','1',1,'Sale Id shift 54',0.00,0.00,0.00,841.72,0.00,'2022-10-01 07:08:04','',''),(318,'8','214','1',1,'Sale Id shift 54',0.00,0.00,0.00,1268.89,0.00,'2022-10-01 07:08:04','',''),(319,'8','214','2',1,'Sale Id shift 54',0.00,0.00,0.00,1332.86,0.00,'2022-10-01 07:08:04','',''),(320,'8','214','2',1,'Sale Id shift 54',0.00,0.00,0.00,952.66,0.00,'2022-10-01 07:08:04','',''),(321,'8','214',NULL,1,'Sale Id shift 54',835264.70,0.00,0.00,0.00,0.00,'2022-10-01 07:08:04','',''),(322,'8','214','1',1,'Sale Id shift 55',0.00,0.00,0.00,615.62,0.00,'2022-10-02 08:47:01','',''),(323,'8','214','1',1,'Sale Id shift 55',0.00,0.00,0.00,1574.55,0.00,'2022-10-02 08:47:01','',''),(324,'8','214','2',1,'Sale Id shift 55',0.00,0.00,0.00,643.34,0.00,'2022-10-02 08:47:01','',''),(325,'8','214','2',1,'Sale Id shift 55',0.00,0.00,0.00,1757.07,0.00,'2022-10-02 08:47:01','',''),(326,'8','214',NULL,1,'Sale Id shift 55',872210.20,0.00,0.00,0.00,0.00,'2022-10-02 08:47:01','',''),(327,'8','214','1',1,'Sale Id shift 56',0.00,0.00,0.00,1072.04,0.00,'2022-10-03 06:28:23','',''),(328,'8','214','1',1,'Sale Id shift 56',0.00,0.00,0.00,795.60,0.00,'2022-10-03 06:28:23','',''),(329,'8','214','2',1,'Sale Id shift 56',0.00,0.00,0.00,625.21,0.00,'2022-10-03 06:28:23','',''),(330,'8','214','2',1,'Sale Id shift 56',0.00,0.00,0.00,1301.55,0.00,'2022-10-03 06:28:23','',''),(331,'8','214',NULL,1,'Sale Id shift 56',720936.00,0.00,0.00,0.00,0.00,'2022-10-03 06:28:23','',''),(332,'8','214','1',1,'Sale Id shift 57',0.00,0.00,0.00,776.38,0.00,'2022-10-03 10:49:50','',''),(333,'8','214','2',1,'Sale Id shift 57',0.00,0.00,0.00,518.18,0.00,'2022-10-03 10:49:50','',''),(334,'8','214','2',1,'Sale Id shift 57',0.00,0.00,0.00,295.87,0.00,'2022-10-03 10:49:50','',''),(335,'8','214',NULL,1,'Sale Id shift 57',302181.70,0.00,0.00,0.00,0.00,'2022-10-03 10:49:50','',''),(336,'8','214',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,18000.00,0.00,'2022-10-04 14:05:55','',''),(337,'8','214','1',1,'Received from bridging 19',0.00,0.00,18000.00,0.00,0.00,'2022-10-04 14:05:55','',''),(338,'8','214','1',1,'Sale Id shift 58',0.00,0.00,0.00,539.54,0.00,'2022-10-04 15:04:19','',''),(339,'8','214','1',1,'Sale Id shift 58',0.00,0.00,0.00,1148.41,0.00,'2022-10-04 15:04:19','',''),(340,'8','214','2',1,'Sale Id shift 58',0.00,0.00,0.00,243.90,0.00,'2022-10-04 15:04:19','',''),(341,'8','214','2',1,'Sale Id shift 58',0.00,0.00,0.00,130.74,0.00,'2022-10-04 15:04:19','',''),(342,'8','214',NULL,1,'Sale Id shift 58',391892.10,0.00,0.00,0.00,0.00,'2022-10-04 15:04:19','',''),(343,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,3230000.00,17000.00,0.00,0.00,'2022-10-07 11:17:42','',''),(344,'8','214',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,17000.00,0.00,'2022-10-07 13:41:56','',''),(345,'8','214','2',1,'Received from bridging 20',0.00,0.00,17000.00,0.00,0.00,'2022-10-07 13:41:56','',''),(346,'8','214','1',1,'Sale Id shift 60',0.00,0.00,0.00,2902.18,0.00,'2022-10-07 14:07:13','',''),(347,'8','214','1',1,'Sale Id shift 60',0.00,0.00,0.00,3767.59,0.00,'2022-10-07 14:07:13','',''),(348,'8','214','2',1,'Sale Id shift 60',0.00,0.00,0.00,2399.27,0.00,'2022-10-07 14:07:13','',''),(349,'8','214','2',1,'Sale Id shift 60',0.00,0.00,0.00,2025.30,0.00,'2022-10-07 14:07:13','',''),(350,'8','214',NULL,1,'Sale Id shift 60',2107924.60,0.00,0.00,0.00,0.00,'2022-10-07 14:07:13','',''),(351,'8','214','1',1,'Sale Id shift 61',0.00,0.00,0.00,3326.25,0.00,'2022-10-07 14:21:30','',''),(352,'8','214','1',1,'Sale Id shift 61',0.00,0.00,0.00,3622.70,0.00,'2022-10-07 14:21:30','',''),(353,'8','214',NULL,1,'Sale Id shift 61',1320300.50,0.00,0.00,0.00,0.00,'2022-10-07 14:21:30','',''),(354,'8','214','1',1,'Sale Id shift 62',0.00,0.00,0.00,400.93,0.00,'2022-10-07 14:28:01','',''),(355,'8','214','1',1,'Sale Id shift 62',0.00,0.00,0.00,690.64,0.00,'2022-10-07 14:28:01','',''),(356,'8','214',NULL,1,'Sale Id shift 62',207398.30,0.00,0.00,0.00,0.00,'2022-10-07 14:28:01','',''),(357,'8','214','2',1,'Sale Id shift 63',0.00,0.00,0.00,1460.54,0.00,'2022-10-08 10:13:13','',''),(358,'8','214','2',1,'Sale Id shift 63',0.00,0.00,0.00,1638.56,0.00,'2022-10-08 10:13:13','',''),(359,'8','214',NULL,1,'Sale Id shift 63',588829.00,0.00,0.00,0.00,0.00,'2022-10-08 10:13:13','',''),(360,'8','214','2',1,'Sale Id shift 64',0.00,0.00,0.00,2776.52,0.00,'2022-10-09 08:25:53','',''),(361,'8','214','2',1,'Sale Id shift 64',0.00,0.00,0.00,2742.47,0.00,'2022-10-09 08:25:53','',''),(362,'8','214',NULL,1,'Sale Id shift 64',1048608.10,0.00,0.00,0.00,0.00,'2022-10-09 08:25:53','',''),(363,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,5826100.00,28700.00,0.00,0.00,'2022-10-10 11:20:20','',''),(364,'8','214',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,14200.00,0.00,'2022-10-10 12:31:19','',''),(365,'8','214','1',1,'Received from bridging 21',0.00,0.00,14200.00,0.00,0.00,'2022-10-10 12:31:19','',''),(366,'8','214',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,14500.00,0.00,'2022-10-10 12:31:42','',''),(367,'8','214','2',1,'Received from bridging 22',0.00,0.00,14500.00,0.00,0.00,'2022-10-10 12:31:42','',''),(368,'8','214','2',1,'Sale Id shift 65',0.00,0.00,0.00,4543.09,0.00,'2022-10-10 13:23:35','',''),(369,'8','214','2',1,'Sale Id shift 65',0.00,0.00,0.00,3898.78,0.00,'2022-10-10 13:23:35','',''),(370,'8','214',NULL,1,'Sale Id shift 65',1603955.30,0.00,0.00,0.00,0.00,'2022-10-10 13:23:35','',''),(371,'8','214','1',1,'Sale Id shift 66',0.00,0.00,0.00,1984.47,0.00,'2022-10-11 10:19:32','',''),(372,'8','214','1',1,'Sale Id shift 66',0.00,0.00,0.00,2796.58,0.00,'2022-10-11 10:19:32','',''),(373,'8','214','2',1,'Sale Id shift 66',0.00,0.00,0.00,4188.78,0.00,'2022-10-11 10:19:32','',''),(374,'8','214','2',1,'Sale Id shift 66',0.00,0.00,0.00,2177.71,0.00,'2022-10-11 10:19:32','',''),(375,'8','214',NULL,1,'Sale Id shift 66',2262950.62,0.00,0.00,0.00,0.00,'2022-10-11 10:19:32','',''),(376,'8','214','1',1,'Sale Id shift 67',0.00,0.00,0.00,2662.62,0.00,'2022-10-12 10:10:11','',''),(377,'8','214','1',1,'Sale Id shift 67',0.00,0.00,0.00,3532.51,0.00,'2022-10-12 10:10:11','',''),(378,'8','214','2',1,'Sale Id shift 67',0.00,0.00,0.00,2505.88,0.00,'2022-10-12 10:10:11','',''),(379,'8','214','2',1,'Sale Id shift 67',0.00,0.00,0.00,3357.47,0.00,'2022-10-12 10:10:11','',''),(380,'8','214',NULL,1,'Sale Id shift 67',2447871.44,0.00,0.00,0.00,0.00,'2022-10-12 10:10:11','',''),(381,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,4218250.00,17950.00,0.00,0.00,'2022-10-21 21:18:47','',''),(382,'8','214',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,17950.00,0.00,'2022-10-22 10:04:37','',''),(383,'8','214','2',1,'Received from bridging 23',0.00,0.00,17950.00,0.00,0.00,'2022-10-22 10:04:37','',''),(384,'8','214','1',1,'Sale Id shift 68',0.00,0.00,0.00,1261.26,0.00,'2022-10-22 10:41:26','',''),(385,'8','214','1',1,'Sale Id shift 68',0.00,0.00,0.00,2026.84,0.00,'2022-10-22 10:41:26','',''),(386,'8','214','2',1,'Sale Id shift 68',0.00,0.00,0.00,868.35,0.00,'2022-10-22 10:41:26','',''),(387,'8','214','2',1,'Sale Id shift 68',0.00,0.00,0.00,1435.97,0.00,'2022-10-22 10:41:26','',''),(388,'8','214',NULL,1,'Sale Id shift 68',1135261.26,0.00,0.00,0.00,0.00,'2022-10-22 10:41:26','',''),(389,'8','214','2',1,'Sale Id shift 69',0.00,0.00,0.00,4182.54,0.00,'2022-10-22 10:49:31','',''),(390,'8','214','2',1,'Sale Id shift 69',0.00,0.00,0.00,4197.42,0.00,'2022-10-22 10:49:31','',''),(391,'8','214',NULL,1,'Sale Id shift 69',1969290.60,0.00,0.00,0.00,0.00,'2022-10-22 10:49:31','',''),(392,'8','214','2',1,'Sale Id shift 70',0.00,0.00,0.00,2669.74,0.00,'2022-10-23 07:46:28','',''),(393,'8','214','2',1,'Sale Id shift 70',0.00,0.00,0.00,2730.29,0.00,'2022-10-23 07:46:28','',''),(394,'8','214',NULL,1,'Sale Id shift 70',1269007.05,0.00,0.00,0.00,0.00,'2022-10-23 07:46:28','',''),(395,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,4680000.00,19500.00,0.00,0.00,'2022-10-26 09:58:44','',''),(396,'8','214',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,19500.00,0.00,'2022-10-27 10:32:37','',''),(397,'8','214','2',1,'Received from bridging 24',0.00,0.00,19500.00,0.00,0.00,'2022-10-27 10:32:37','',''),(398,'8','214','2',1,'Sale Id shift 71',0.00,0.00,0.00,2095.96,0.00,'2022-10-27 11:15:47','',''),(399,'8','214','2',1,'Sale Id shift 71',0.00,0.00,0.00,1982.03,0.00,'2022-10-27 11:15:47','',''),(400,'8','214',NULL,1,'Sale Id shift 71',958327.65,0.00,0.00,0.00,0.00,'2022-10-27 11:15:47','',''),(401,'8','214','2',1,'Sale Id shift 72',0.00,0.00,0.00,5949.61,0.00,'2022-10-27 11:20:24','',''),(402,'8','214','2',1,'Sale Id shift 72',0.00,0.00,0.00,6266.73,0.00,'2022-10-27 11:20:24','',''),(403,'8','214',NULL,1,'Sale Id shift 72',2931921.60,0.00,0.00,0.00,0.00,'2022-10-27 11:20:24','',''),(404,'8','214','2',1,'Sale Id shift 73',0.00,0.00,0.00,2310.98,0.00,'2022-10-27 11:23:40','',''),(405,'8','214','2',1,'Sale Id shift 73',0.00,0.00,0.00,2038.86,0.00,'2022-10-27 11:23:40','',''),(406,'8','214',NULL,1,'Sale Id shift 73',1043961.60,0.00,0.00,0.00,0.00,'2022-10-27 11:23:40','',''),(407,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,8364000.00,32800.00,0.00,0.00,'2022-11-05 11:04:18','',''),(408,'8','214',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,16400.00,0.00,'2022-11-06 08:46:41','',''),(409,'8','214','1',1,'Received from bridging 25',0.00,0.00,16400.00,0.00,0.00,'2022-11-06 08:46:41','',''),(410,'8','214',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,16400.00,0.00,'2022-11-06 08:46:59','',''),(411,'8','214','2',1,'Received from bridging 26',0.00,0.00,16400.00,0.00,0.00,'2022-11-06 08:46:59','',''),(412,'8','214','2',1,'Sale Id shift 74',0.00,0.00,0.00,1781.16,0.00,'2022-11-06 10:20:57','',''),(413,'8','214','2',1,'Sale Id shift 74',0.00,0.00,0.00,1295.78,0.00,'2022-11-06 10:20:57','',''),(414,'8','214',NULL,1,'Sale Id shift 74',738465.60,0.00,0.00,0.00,0.00,'2022-11-06 10:20:57','',''),(415,'8','214','1',1,'Sale Id shift 75',0.00,0.00,0.00,1151.39,0.00,'2022-11-06 10:32:22','',''),(416,'8','214','1',1,'Sale Id shift 75',0.00,0.00,0.00,2050.11,0.00,'2022-11-06 10:32:22','',''),(417,'8','214','2',1,'Sale Id shift 75',0.00,0.00,0.00,1597.28,0.00,'2022-11-06 10:32:22','',''),(418,'8','214','2',1,'Sale Id shift 75',0.00,0.00,0.00,1236.23,0.00,'2022-11-06 10:32:22','',''),(419,'8','214',NULL,1,'Sale Id shift 75',1538927.55,0.00,0.00,0.00,0.00,'2022-11-06 10:32:22','',''),(420,'8','214','1',1,'Sale Id shift 76',0.00,0.00,0.00,1578.53,0.00,'2022-11-07 11:12:51','',''),(421,'8','214','1',1,'Sale Id shift 76',0.00,0.00,0.00,2893.14,0.00,'2022-11-07 11:12:51','',''),(422,'8','214','2',1,'Sale Id shift 76',0.00,0.00,0.00,1084.59,0.00,'2022-11-07 11:12:51','',''),(423,'8','214','2',1,'Sale Id shift 76',0.00,0.00,0.00,1942.08,0.00,'2022-11-07 11:12:51','',''),(424,'8','214',NULL,1,'Sale Id shift 76',1912076.70,0.00,0.00,0.00,0.00,'2022-11-07 11:12:51','',''),(425,'8','214','1',1,'Sale Id shift 77',0.00,0.00,0.00,1500.95,0.00,'2022-11-08 06:30:38','',''),(426,'8','214','1',1,'Sale Id shift 77',0.00,0.00,0.00,2756.02,0.00,'2022-11-08 06:30:38','',''),(427,'8','214','2',1,'Sale Id shift 77',0.00,0.00,0.00,2396.50,0.00,'2022-11-08 06:30:38','',''),(428,'8','214',NULL,1,'Sale Id shift 77',1696634.85,0.00,0.00,0.00,0.00,'2022-11-08 06:30:38','',''),(429,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,4335000.00,17000.00,0.00,0.00,'2022-11-08 13:04:19','',''),(430,'8','214',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,17000.00,0.00,'2022-11-09 12:38:37','',''),(431,'8','214','2',1,'Received from bridging 27',0.00,0.00,17000.00,0.00,0.00,'2022-11-09 12:38:37','',''),(432,'8','214','1',1,'Sale Id shift 78',0.00,0.00,0.00,2130.15,0.00,'2022-11-09 13:35:34','',''),(433,'8','214','1',1,'Sale Id shift 78',0.00,0.00,0.00,2371.83,0.00,'2022-11-09 13:35:34','',''),(434,'8','214','2',1,'Sale Id shift 78',0.00,0.00,0.00,5724.48,0.00,'2022-11-09 13:35:34','',''),(435,'8','214','2',1,'Sale Id shift 78',0.00,0.00,0.00,5319.15,0.00,'2022-11-09 13:35:34','',''),(436,'8','214',NULL,1,'Sale Id shift 78',3964130.55,0.00,0.00,0.00,0.00,'2022-11-09 13:35:34','',''),(437,'8','214','2',1,'Sale Id shift 79',0.00,0.00,0.00,3267.31,0.00,'2022-11-10 09:23:28','',''),(438,'8','214','2',1,'Sale Id shift 79',0.00,0.00,0.00,3525.58,0.00,'2022-11-10 09:23:28','',''),(439,'8','214',NULL,1,'Sale Id shift 79',1732186.95,0.00,0.00,0.00,0.00,'2022-11-10 09:23:28','',''),(440,'8','214','2',1,'Sale Id shift 80',0.00,0.00,0.00,2198.52,0.00,'2022-11-11 08:21:07','',''),(441,'8','214','2',1,'Sale Id shift 80',0.00,0.00,0.00,2289.51,0.00,'2022-11-11 08:21:07','',''),(442,'8','214',NULL,1,'Sale Id shift 80',1144447.65,0.00,0.00,0.00,0.00,'2022-11-11 08:21:07','',''),(443,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,4258500.00,16700.00,0.00,0.00,'2022-11-16 13:27:17','',''),(444,'8','214',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,16700.00,0.00,'2022-11-16 16:41:04','',''),(445,'8','214','2',1,'Received from bridging 28',0.00,0.00,16700.00,0.00,0.00,'2022-11-16 16:41:04','',''),(446,'8','214','2',1,'Sale Id shift 81',0.00,0.00,0.00,1621.52,0.00,'2022-11-17 07:47:43','',''),(447,'8','214','2',1,'Sale Id shift 81',0.00,0.00,0.00,1310.88,0.00,'2022-11-17 07:47:43','',''),(448,'8','214',NULL,1,'Sale Id shift 81',747762.00,0.00,0.00,0.00,0.00,'2022-11-17 07:47:43','',''),(449,'8','214','2',1,'Sale Id shift 82',0.00,0.00,0.00,3308.77,0.00,'2022-11-17 07:51:09','',''),(450,'8','214','2',1,'Sale Id shift 82',0.00,0.00,0.00,2619.69,0.00,'2022-11-17 07:51:09','',''),(451,'8','214',NULL,1,'Sale Id shift 82',1511757.30,0.00,0.00,0.00,0.00,'2022-11-17 07:51:09','',''),(452,'8','214','2',1,'Sale Id shift 83',0.00,0.00,0.00,3853.50,0.00,'2022-11-18 09:03:19','',''),(453,'8','214','2',1,'Sale Id shift 83',0.00,0.00,0.00,3298.41,0.00,'2022-11-18 09:03:19','',''),(454,'8','214',NULL,1,'Sale Id shift 83',1823737.05,0.00,0.00,0.00,0.00,'2022-11-18 09:03:19','',''),(455,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,8580000.00,33000.00,0.00,0.00,'2022-11-20 11:05:00','',''),(456,'8','214',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,16550.00,0.00,'2022-11-20 15:30:52','',''),(457,'8','214','2',1,'Received from bridging 30',0.00,0.00,16550.00,0.00,0.00,'2022-11-20 15:30:52','',''),(458,'8','214',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,16450.00,0.00,'2022-11-20 15:31:15','',''),(459,'8','214','1',1,'Received from bridging 29',0.00,0.00,16450.00,0.00,0.00,'2022-11-20 15:31:15','',''),(460,'8','214','2',1,'Sale Id shift 84',0.00,0.00,0.00,1698.87,0.00,'2022-11-20 18:15:17','',''),(461,'8','214','2',1,'Sale Id shift 84',0.00,0.00,0.00,1984.94,0.00,'2022-11-20 18:15:17','',''),(462,'8','214',NULL,1,'Sale Id shift 84',939371.55,0.00,0.00,0.00,0.00,'2022-11-20 18:15:17','',''),(463,'8','214','1',1,'Sale Id shift 85',0.00,0.00,0.00,714.79,0.00,'2022-11-21 08:50:33','',''),(464,'8','214','1',1,'Sale Id shift 85',0.00,0.00,0.00,1722.60,0.00,'2022-11-21 08:50:33','',''),(465,'8','214','2',1,'Sale Id shift 85',0.00,0.00,0.00,1677.76,0.00,'2022-11-21 08:50:33','',''),(466,'8','214','2',1,'Sale Id shift 85',0.00,0.00,0.00,2064.76,0.00,'2022-11-21 08:50:33','',''),(467,'8','214',NULL,1,'Sale Id shift 85',1606776.60,0.00,0.00,0.00,0.00,'2022-11-21 08:50:33','',''),(468,'8','214','1',1,'Sale Id shift 86',0.00,0.00,0.00,2705.95,0.00,'2022-11-22 08:49:44','',''),(469,'8','214','1',1,'Sale Id shift 86',0.00,0.00,0.00,1608.49,0.00,'2022-11-22 08:49:44','',''),(470,'8','214','2',1,'Sale Id shift 86',0.00,0.00,0.00,1110.09,0.00,'2022-11-22 08:49:44','',''),(471,'8','214','2',1,'Sale Id shift 86',0.00,0.00,0.00,1550.15,0.00,'2022-11-22 08:49:44','',''),(472,'8','214',NULL,1,'Sale Id shift 86',1813416.80,0.00,0.00,0.00,0.00,'2022-11-22 08:49:44','',''),(473,'8','214','1',1,'Sale Id shift 87',0.00,0.00,0.00,4148.53,0.00,'2022-11-23 08:15:43','',''),(474,'8','214','1',1,'Sale Id shift 87',0.00,0.00,0.00,5348.16,0.00,'2022-11-23 08:15:43','',''),(475,'8','214','2',1,'Sale Id shift 87',0.00,0.00,0.00,3725.47,0.00,'2022-11-23 08:15:43','',''),(476,'8','214','2',1,'Sale Id shift 87',0.00,0.00,0.00,3964.72,0.00,'2022-11-23 08:15:43','',''),(477,'8','214',NULL,1,'Sale Id shift 87',4468588.80,0.00,0.00,0.00,0.00,'2022-11-23 08:15:43','',''),(478,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,8879000.00,34150.00,0.00,0.00,'2022-11-24 12:42:32','',''),(479,'8','214',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,19450.00,0.00,'2022-11-24 15:53:16','',''),(480,'8','214','2',1,'Received from bridging 32',0.00,0.00,19450.00,0.00,0.00,'2022-11-24 15:53:16','',''),(481,'8','214',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,14700.00,0.00,'2022-11-24 15:53:31','',''),(482,'8','214','1',1,'Received from bridging 31',0.00,0.00,14700.00,0.00,0.00,'2022-11-24 15:53:31','',''),(483,'8','214','1',1,'Sale Id shift 88',0.00,0.00,0.00,55.64,0.00,'2022-11-24 15:55:30','',''),(484,'8','214','2',1,'Sale Id shift 88',0.00,0.00,0.00,1156.91,0.00,'2022-11-24 15:55:30','',''),(485,'8','214','2',1,'Sale Id shift 88',0.00,0.00,0.00,1233.17,0.00,'2022-11-24 15:55:30','',''),(486,'8','214',NULL,1,'Sale Id shift 88',635887.20,0.00,0.00,0.00,0.00,'2022-11-24 15:55:30','',''),(487,'8','214','1',1,'Sale Id shift 89',0.00,0.00,0.00,1513.11,0.00,'2022-11-25 12:25:22','',''),(488,'8','214','1',1,'Sale Id shift 89',0.00,0.00,0.00,1134.92,0.00,'2022-11-25 12:25:22','',''),(489,'8','214','2',1,'Sale Id shift 89',0.00,0.00,0.00,1087.05,0.00,'2022-11-25 12:25:22','',''),(490,'8','214','2',1,'Sale Id shift 89',0.00,0.00,0.00,617.62,0.00,'2022-11-25 12:25:22','',''),(491,'8','214',NULL,1,'Sale Id shift 89',1131702.00,0.00,0.00,0.00,0.00,'2022-11-25 12:25:22','',''),(492,'8','214','1',1,'Sale Id shift 90',0.00,0.00,0.00,1235.78,0.00,'2022-11-26 08:32:18','',''),(493,'8','214','1',1,'Sale Id shift 90',0.00,0.00,0.00,18.45,0.00,'2022-11-26 08:32:18','',''),(494,'8','214','2',1,'Sale Id shift 90',0.00,0.00,0.00,3024.13,0.00,'2022-11-26 08:32:18','',''),(495,'8','214','2',1,'Sale Id shift 90',0.00,0.00,0.00,1881.07,0.00,'2022-11-26 08:32:18','',''),(496,'8','214',NULL,1,'Sale Id shift 90',1601451.80,0.00,0.00,0.00,0.00,'2022-11-26 08:32:18','',''),(497,'8','214','1',1,'Sale Id shift 91',0.00,0.00,0.00,347.83,0.00,'2022-11-27 12:18:56','',''),(498,'8','214','1',1,'Sale Id shift 91',0.00,0.00,0.00,2183.73,0.00,'2022-11-27 12:18:56','',''),(499,'8','214','2',1,'Sale Id shift 91',0.00,0.00,0.00,1048.09,0.00,'2022-11-27 12:18:56','',''),(500,'8','214','2',1,'Sale Id shift 91',0.00,0.00,0.00,3261.16,0.00,'2022-11-27 12:18:56','',''),(501,'8','214',NULL,1,'Sale Id shift 91',1778610.60,0.00,0.00,0.00,0.00,'2022-11-27 12:18:56','',''),(502,'8','214','1',1,'Sale Id shift 92',0.00,0.00,0.00,1231.38,0.00,'2022-11-28 08:52:31','',''),(503,'8','214','1',1,'Sale Id shift 92',0.00,0.00,0.00,2850.87,0.00,'2022-11-28 08:52:31','',''),(504,'8','214','2',1,'Sale Id shift 92',0.00,0.00,0.00,1727.00,0.00,'2022-11-28 08:52:31','',''),(505,'8','214','2',1,'Sale Id shift 92',0.00,0.00,0.00,1525.36,0.00,'2022-11-28 08:52:31','',''),(506,'8','214',NULL,1,'Sale Id shift 92',1906998.60,0.00,0.00,0.00,0.00,'2022-11-28 08:52:31','',''),(507,'8','214','1',1,'Sale Id shift 93',0.00,0.00,0.00,1841.82,0.00,'2022-11-29 08:36:04','',''),(508,'8','214','1',1,'Sale Id shift 93',0.00,0.00,0.00,733.18,0.00,'2022-11-29 08:36:04','',''),(509,'8','214','2',1,'Sale Id shift 93',0.00,0.00,0.00,2507.50,0.00,'2022-11-29 08:36:04','',''),(510,'8','214',NULL,1,'Sale Id shift 93',1321450.00,0.00,0.00,0.00,0.00,'2022-11-29 08:36:04','',''),(511,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,8964000.00,33200.00,0.00,0.00,'2022-12-06 10:26:11','',''),(512,'8','214',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,16300.00,0.00,'2022-12-06 11:13:38','',''),(513,'8','214','2',1,'Received from bridging 34',0.00,0.00,16300.00,0.00,0.00,'2022-12-06 11:13:38','',''),(514,'8','214',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,16900.00,0.00,'2022-12-06 11:13:56','',''),(515,'8','214','1',1,'Received from bridging 33',0.00,0.00,16900.00,0.00,0.00,'2022-12-06 11:13:56','',''),(516,'8','214','1',1,'Sale Id shift 94',0.00,0.00,0.00,629.65,0.00,'2022-12-07 08:03:53','',''),(517,'8','214','1',1,'Sale Id shift 94',0.00,0.00,0.00,1064.20,0.00,'2022-12-07 08:03:53','',''),(518,'8','214','2',1,'Sale Id shift 94',0.00,0.00,0.00,1654.69,0.00,'2022-12-07 08:03:53','',''),(519,'8','214','2',1,'Sale Id shift 94',0.00,0.00,0.00,1161.97,0.00,'2022-12-07 08:03:53','',''),(520,'8','214',NULL,1,'Sale Id shift 94',1172732.60,0.00,0.00,0.00,0.00,'2022-12-07 08:03:53','',''),(521,'8','214','1',1,'Sale Id shift 95',0.00,0.00,0.00,5299.61,0.00,'2022-12-07 08:10:06','',''),(522,'8','214','1',1,'Sale Id shift 95',0.00,0.00,0.00,6978.59,0.00,'2022-12-07 08:10:06','',''),(523,'8','214','2',1,'Sale Id shift 95',0.00,0.00,0.00,5817.72,0.00,'2022-12-07 08:10:06','',''),(524,'8','214','2',1,'Sale Id shift 95',0.00,0.00,0.00,5219.64,0.00,'2022-12-07 08:10:06','',''),(525,'8','214',NULL,1,'Sale Id shift 95',6295201.20,0.00,0.00,0.00,0.00,'2022-12-07 08:10:06','',''),(526,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,15639750.00,49650.00,0.00,0.00,'2022-12-14 21:43:14','',''),(527,'8','214',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,30850.00,0.00,'2022-12-15 08:34:14','',''),(528,'8','214','2',1,'Received from bridging 36',0.00,0.00,30850.00,0.00,0.00,'2022-12-15 08:34:14','',''),(529,'8','214',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,18800.00,0.00,'2022-12-15 08:34:28','',''),(530,'8','214','1',1,'Received from bridging 35',0.00,0.00,18800.00,0.00,0.00,'2022-12-15 08:34:28','',''),(531,'8','214','1',1,'Sale Id shift 96',0.00,0.00,0.00,802.00,0.00,'2022-12-15 08:36:48','',''),(532,'8','214','1',1,'Sale Id shift 96',0.00,0.00,0.00,2632.74,0.00,'2022-12-15 08:36:48','',''),(533,'8','214','2',1,'Sale Id shift 96',0.00,0.00,0.00,2166.02,0.00,'2022-12-15 08:36:48','',''),(534,'8','214','2',1,'Sale Id shift 96',0.00,0.00,0.00,2351.60,0.00,'2022-12-15 08:36:48','',''),(535,'8','214',NULL,1,'Sale Id shift 96',2147137.20,0.00,0.00,0.00,0.00,'2022-12-15 08:36:48','',''),(536,'8','214','1',1,'Sale Id shift 97',0.00,0.00,0.00,243.27,0.00,'2022-12-15 08:41:18','',''),(537,'8','214','1',1,'Sale Id shift 97',0.00,0.00,0.00,748.94,0.00,'2022-12-15 08:41:18','',''),(538,'8','214','2',1,'Sale Id shift 97',0.00,0.00,0.00,534.35,0.00,'2022-12-15 08:41:18','',''),(539,'8','214','2',1,'Sale Id shift 97',0.00,0.00,0.00,394.72,0.00,'2022-12-15 08:41:18','',''),(540,'8','214',NULL,1,'Sale Id shift 97',605203.20,0.00,0.00,0.00,0.00,'2022-12-15 08:41:18','',''),(541,'8','214','1',1,'Sale Id shift 98',0.00,0.00,0.00,271.13,0.00,'2022-12-15 08:45:23','',''),(542,'8','214','1',1,'Sale Id shift 98',0.00,0.00,0.00,444.51,0.00,'2022-12-15 08:45:23','',''),(543,'8','214','2',1,'Sale Id shift 98',0.00,0.00,0.00,458.73,0.00,'2022-12-15 08:45:23','',''),(544,'8','214','2',1,'Sale Id shift 98',0.00,0.00,0.00,460.36,0.00,'2022-12-15 08:45:23','',''),(545,'8','214',NULL,1,'Sale Id shift 98',514939.95,0.00,0.00,0.00,0.00,'2022-12-15 08:45:23','',''),(546,'8','214','1',1,'Sale Id shift 99',0.00,0.00,0.00,936.51,0.00,'2022-12-16 11:43:28','',''),(547,'8','214','1',1,'Sale Id shift 99',0.00,0.00,0.00,1773.26,0.00,'2022-12-16 11:43:28','',''),(548,'8','214','2',1,'Sale Id shift 99',0.00,0.00,0.00,1451.60,0.00,'2022-12-16 11:43:28','',''),(549,'8','214','2',1,'Sale Id shift 99',0.00,0.00,0.00,1700.11,0.00,'2022-12-16 11:43:28','',''),(550,'8','214',NULL,1,'Sale Id shift 99',1846366.20,0.00,0.00,0.00,0.00,'2022-12-16 11:43:28','',''),(551,'8','214','1',1,'Sale Id shift 100',0.00,0.00,0.00,540.41,0.00,'2022-12-17 08:27:28','',''),(552,'8','214','1',1,'Sale Id shift 100',0.00,0.00,0.00,1219.37,0.00,'2022-12-17 08:27:28','',''),(553,'8','214','2',1,'Sale Id shift 100',0.00,0.00,0.00,1896.43,0.00,'2022-12-17 08:27:28','',''),(554,'8','214','2',1,'Sale Id shift 100',0.00,0.00,0.00,1467.36,0.00,'2022-12-17 08:27:28','',''),(555,'8','214',NULL,1,'Sale Id shift 100',1613924.55,0.00,0.00,0.00,0.00,'2022-12-17 08:27:28','',''),(556,'8','214','1',1,'Sale Id shift 101',0.00,0.00,0.00,1048.87,0.00,'2022-12-18 08:54:36','',''),(557,'8','214','1',1,'Sale Id shift 101',0.00,0.00,0.00,1775.61,0.00,'2022-12-18 08:54:36','',''),(558,'8','214','2',1,'Sale Id shift 101',0.00,0.00,0.00,1295.21,0.00,'2022-12-18 08:54:36','',''),(559,'8','214','2',1,'Sale Id shift 101',0.00,0.00,0.00,1776.61,0.00,'2022-12-18 08:54:36','',''),(560,'8','214',NULL,1,'Sale Id shift 101',1857334.50,0.00,0.00,0.00,0.00,'2022-12-18 08:54:36','',''),(561,'8','214','1',1,'Sale Id shift 102',0.00,0.00,0.00,858.13,0.00,'2022-12-19 17:15:51','',''),(562,'8','214','1',1,'Sale Id shift 102',0.00,0.00,0.00,1191.88,0.00,'2022-12-19 17:15:51','',''),(563,'8','214','2',1,'Sale Id shift 102',0.00,0.00,0.00,1399.60,0.00,'2022-12-19 17:15:51','',''),(564,'8','214','2',1,'Sale Id shift 102',0.00,0.00,0.00,887.64,0.00,'2022-12-19 17:15:51','',''),(565,'8','214',NULL,1,'Sale Id shift 102',1366233.75,0.00,0.00,0.00,0.00,'2022-12-19 17:15:51','',''),(566,'8','214','1',1,'Sale Id shift 103',0.00,0.00,0.00,976.80,0.00,'2022-12-20 12:19:44','',''),(567,'8','214','1',1,'Sale Id shift 103',0.00,0.00,0.00,602.96,0.00,'2022-12-20 12:19:44','',''),(568,'8','214','2',1,'Sale Id shift 103',0.00,0.00,0.00,1480.26,0.00,'2022-12-20 12:19:44','',''),(569,'8','214','2',1,'Sale Id shift 103',0.00,0.00,0.00,2172.07,0.00,'2022-12-20 12:19:44','',''),(570,'8','214',NULL,1,'Sale Id shift 103',1648108.35,0.00,0.00,0.00,0.00,'2022-12-20 12:19:44','',''),(571,'8','214','1',1,'Sale Id shift 104',0.00,0.00,0.00,2612.26,0.00,'2022-12-21 08:15:19','',''),(572,'8','214','1',1,'Sale Id shift 104',0.00,0.00,0.00,3573.37,0.00,'2022-12-21 08:15:19','',''),(573,'8','214','2',1,'Sale Id shift 104',0.00,0.00,0.00,3356.89,0.00,'2022-12-21 08:15:19','',''),(574,'8','214','2',1,'Sale Id shift 104',0.00,0.00,0.00,3189.63,0.00,'2022-12-21 08:15:19','',''),(575,'8','214',NULL,1,'Sale Id shift 104',4010627.25,0.00,0.00,0.00,0.00,'2022-12-21 08:15:19','',''),(576,'8','214','1',1,'Sale Id shift 105',0.00,0.00,0.00,941.71,0.00,'2022-12-22 08:19:42','',''),(577,'8','214','2',1,'Sale Id shift 105',0.00,0.00,0.00,1472.03,0.00,'2022-12-22 08:19:42','',''),(578,'8','214','2',1,'Sale Id shift 105',0.00,0.00,0.00,1622.35,0.00,'2022-12-22 08:19:42','',''),(579,'8','214',NULL,1,'Sale Id shift 105',1271368.35,0.00,0.00,0.00,0.00,'2022-12-22 08:19:42','',''),(580,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,5490000.00,18000.00,0.00,0.00,'2022-12-25 14:15:48','',''),(581,'8','214',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,18000.00,0.00,'2022-12-26 08:07:57','',''),(582,'8','214','2',1,'Received from bridging 37',0.00,0.00,18000.00,0.00,0.00,'2022-12-26 08:07:57','',''),(583,'8','214','2',1,'Sale Id shift 106',0.00,0.00,0.00,1775.30,0.00,'2022-12-26 08:09:11','',''),(584,'8','214','2',1,'Sale Id shift 106',0.00,0.00,0.00,1708.09,0.00,'2022-12-26 08:09:11','',''),(585,'8','214',NULL,1,'Sale Id shift 106',1097267.85,0.00,0.00,0.00,0.00,'2022-12-26 08:09:11','',''),(586,'8','214','2',1,'Sale Id shift 107',0.00,0.00,0.00,666.98,0.00,'2022-12-26 08:12:28','',''),(587,'8','214','2',1,'Sale Id shift 107',0.00,0.00,0.00,559.66,0.00,'2022-12-26 08:12:28','',''),(588,'8','214',NULL,1,'Sale Id shift 107',374125.20,0.00,0.00,0.00,0.00,'2022-12-26 08:12:28','',''),(589,'8','214','2',1,'Sale Id shift 108',0.00,0.00,0.00,3783.47,0.00,'2022-12-26 11:08:46','',''),(590,'8','214','2',1,'Sale Id shift 108',0.00,0.00,0.00,3019.09,0.00,'2022-12-26 11:08:46','',''),(591,'8','214',NULL,1,'Sale Id shift 108',2074780.80,0.00,0.00,0.00,0.00,'2022-12-26 11:08:46','',''),(592,'8','214','2',1,'Sale Id shift 109',0.00,0.00,0.00,3493.81,0.00,'2022-12-27 08:59:59','',''),(593,'8','214','2',1,'Sale Id shift 109',0.00,0.00,0.00,2768.32,0.00,'2022-12-27 08:59:59','',''),(594,'8','214',NULL,1,'Sale Id shift 109',1909949.65,0.00,0.00,0.00,0.00,'2022-12-27 08:59:59','',''),(595,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,14955000.00,49850.00,0.00,0.00,'2022-12-29 13:00:39','',''),(596,'8','214',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,17050.00,0.00,'2022-12-29 15:22:15','',''),(597,'8','214','1',1,'Received from bridging 38',0.00,0.00,17050.00,0.00,0.00,'2022-12-29 15:22:15','',''),(598,'8','214',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,32800.00,0.00,'2022-12-29 15:25:32','',''),(599,'8','214','2',1,'Received from bridging 39',0.00,0.00,32800.00,0.00,0.00,'2022-12-29 15:25:32','',''),(600,'8','214','2',1,'Sale Id shift 110',0.00,0.00,0.00,2520.64,0.00,'2022-12-29 15:27:27','',''),(601,'8','214','2',1,'Sale Id shift 110',0.00,0.00,0.00,2407.82,0.00,'2022-12-29 15:27:27','',''),(602,'8','214',NULL,1,'Sale Id shift 110',1503180.30,0.00,0.00,0.00,0.00,'2022-12-29 15:27:27','',''),(603,'8','214','1',1,'Sale Id shift 111',0.00,0.00,0.00,859.32,0.00,'2022-12-30 08:42:38','',''),(604,'8','214','1',1,'Sale Id shift 111',0.00,0.00,0.00,310.40,0.00,'2022-12-30 08:42:38','',''),(605,'8','214','2',1,'Sale Id shift 111',0.00,0.00,0.00,1118.34,0.00,'2022-12-30 08:42:38','',''),(606,'8','214','2',1,'Sale Id shift 111',0.00,0.00,0.00,2624.63,0.00,'2022-12-30 08:42:38','',''),(607,'8','214',NULL,1,'Sale Id shift 111',1473807.00,0.00,0.00,0.00,0.00,'2022-12-30 08:42:38','',''),(608,'8','214','1',1,'Sale Id shift 112',0.00,0.00,0.00,1199.49,0.00,'2022-12-31 08:39:15','',''),(609,'8','214','1',1,'Sale Id shift 112',0.00,0.00,0.00,1667.63,0.00,'2022-12-31 08:39:15','',''),(610,'8','214','2',1,'Sale Id shift 112',0.00,0.00,0.00,2855.05,0.00,'2022-12-31 08:39:15','',''),(611,'8','214','2',1,'Sale Id shift 112',0.00,0.00,0.00,1235.33,0.00,'2022-12-31 08:39:15','',''),(612,'8','214',NULL,1,'Sale Id shift 112',2087250.00,0.00,0.00,0.00,0.00,'2022-12-31 08:39:15','',''),(613,'8','214','1',1,'Sale Id shift 113',0.00,0.00,0.00,521.04,0.00,'2023-01-01 12:27:03','',''),(614,'8','214','1',1,'Sale Id shift 113',0.00,0.00,0.00,1494.74,0.00,'2023-01-01 12:27:03','',''),(615,'8','214','2',1,'Sale Id shift 113',0.00,0.00,0.00,2976.49,0.00,'2023-01-01 12:27:03','',''),(616,'8','214','2',1,'Sale Id shift 113',0.00,0.00,0.00,2580.48,0.00,'2023-01-01 12:27:03','',''),(617,'8','214',NULL,1,'Sale Id shift 113',2271825.00,0.00,0.00,0.00,0.00,'2023-01-01 12:27:03','',''),(618,'8','214','1',1,'Sale Id shift 114',0.00,0.00,0.00,1231.33,0.00,'2023-01-02 12:24:18','',''),(619,'8','214','1',1,'Sale Id shift 114',0.00,0.00,0.00,1746.83,0.00,'2023-01-02 12:24:18','',''),(620,'8','214','2',1,'Sale Id shift 114',0.00,0.00,0.00,3101.71,0.00,'2023-01-02 12:24:18','',''),(621,'8','214','2',1,'Sale Id shift 114',0.00,0.00,0.00,901.98,0.00,'2023-01-02 12:24:18','',''),(622,'8','214',NULL,1,'Sale Id shift 114',2094555.00,0.00,0.00,0.00,0.00,'2023-01-02 12:24:18','',''),(623,'8','214','1',1,'Sale Id shift 115',0.00,0.00,0.00,2138.32,0.00,'2023-01-03 14:25:27','',''),(624,'8','214','1',1,'Sale Id shift 115',0.00,0.00,0.00,1247.62,0.00,'2023-01-03 14:25:27','',''),(625,'8','214','2',1,'Sale Id shift 115',0.00,0.00,0.00,727.14,0.00,'2023-01-03 14:25:27','',''),(626,'8','214','2',1,'Sale Id shift 115',0.00,0.00,0.00,2098.93,0.00,'2023-01-03 14:25:27','',''),(627,'8','214',NULL,1,'Sale Id shift 115',1863603.00,0.00,0.00,0.00,0.00,'2023-01-03 14:25:27','',''),(628,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,10230000.00,34100.00,0.00,0.00,'2023-01-03 17:15:12','',''),(629,'8','214',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,16700.00,0.00,'2023-01-04 09:26:19','',''),(630,'8','214','2',1,'Received from bridging 41',0.00,0.00,16700.00,0.00,0.00,'2023-01-04 09:26:19','',''),(631,'8','214',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,17400.00,0.00,'2023-01-04 09:26:35','',''),(632,'8','214','1',1,'Received from bridging 40',0.00,0.00,17400.00,0.00,0.00,'2023-01-04 09:26:35','',''),(633,'8','214','1',1,'Sale Id shift 116',0.00,0.00,0.00,3639.54,0.00,'2023-01-04 09:30:40','',''),(634,'8','214','1',1,'Sale Id shift 116',0.00,0.00,0.00,5468.03,0.00,'2023-01-04 09:30:40','',''),(635,'8','214','2',1,'Sale Id shift 116',0.00,0.00,0.00,4248.38,0.00,'2023-01-04 09:30:40','',''),(636,'8','214','2',1,'Sale Id shift 116',0.00,0.00,0.00,4151.39,0.00,'2023-01-04 09:30:40','',''),(637,'8','214',NULL,1,'Sale Id shift 116',5252202.00,0.00,0.00,0.00,0.00,'2023-01-04 09:30:40','',''),(638,'8','214','1',1,'Sale Id shift 117',0.00,0.00,0.00,1106.18,0.00,'2023-01-05 08:49:53','',''),(639,'8','214','1',1,'Sale Id shift 117',0.00,0.00,0.00,1703.43,0.00,'2023-01-05 08:49:53','',''),(640,'8','214','2',1,'Sale Id shift 117',0.00,0.00,0.00,3290.25,0.00,'2023-01-05 08:49:53','',''),(641,'8','214','2',1,'Sale Id shift 117',0.00,0.00,0.00,1568.68,0.00,'2023-01-05 08:49:53','',''),(642,'8','214',NULL,1,'Sale Id shift 117',2300562.00,0.00,0.00,0.00,0.00,'2023-01-05 08:49:53','',''),(643,'8','214','1',1,'Sale Id shift 118',0.00,0.00,0.00,1175.25,0.00,'2023-01-06 11:02:10','',''),(644,'8','214','1',1,'Sale Id shift 118',0.00,0.00,0.00,1712.19,0.00,'2023-01-06 11:02:10','',''),(645,'8','214','2',1,'Sale Id shift 118',0.00,0.00,0.00,1858.70,0.00,'2023-01-06 11:02:10','',''),(646,'8','214','2',1,'Sale Id shift 118',0.00,0.00,0.00,2336.57,0.00,'2023-01-06 11:02:10','',''),(647,'8','214',NULL,1,'Sale Id shift 118',2124813.00,0.00,0.00,0.00,0.00,'2023-01-06 11:02:10','',''),(648,'8','214','1',1,'Sale Id shift 119',0.00,0.00,0.00,659.49,0.00,'2023-01-07 11:00:17','',''),(649,'8','214','1',1,'Sale Id shift 119',0.00,0.00,0.00,2214.42,0.00,'2023-01-07 11:00:17','',''),(650,'8','214','2',1,'Sale Id shift 119',0.00,0.00,0.00,1347.84,0.00,'2023-01-07 11:00:17','',''),(651,'8','214','2',1,'Sale Id shift 119',0.00,0.00,0.00,2968.13,0.00,'2023-01-07 11:00:17','',''),(652,'8','214',NULL,1,'Sale Id shift 119',2156964.00,0.00,0.00,0.00,0.00,'2023-01-07 11:00:17','',''),(653,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,6255000.00,20850.00,0.00,0.00,'2023-01-07 15:34:29','',''),(654,'8','214',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,20850.00,0.00,'2023-01-08 11:03:01','',''),(655,'8','214','2',1,'Received from bridging 42',0.00,0.00,20850.00,0.00,0.00,'2023-01-08 11:03:01','',''),(656,'8','214','1',1,'Sale Id shift 120',0.00,0.00,0.00,797.90,0.00,'2023-01-08 11:09:16','',''),(657,'8','214','1',1,'Sale Id shift 120',0.00,0.00,0.00,2355.31,0.00,'2023-01-08 11:09:16','',''),(658,'8','214','2',1,'Sale Id shift 120',0.00,0.00,0.00,3277.35,0.00,'2023-01-08 11:09:16','',''),(659,'8','214','2',1,'Sale Id shift 120',0.00,0.00,0.00,2731.16,0.00,'2023-01-08 11:09:16','',''),(660,'8','214',NULL,1,'Sale Id shift 120',2748516.00,0.00,0.00,0.00,0.00,'2023-01-08 11:09:16','',''),(661,'8','214','1',1,'Sale Id shift 121',0.00,0.00,0.00,995.10,0.00,'2023-01-09 08:59:56','',''),(662,'8','214','2',1,'Sale Id shift 121',0.00,0.00,0.00,3210.14,0.00,'2023-01-09 08:59:56','',''),(663,'8','214','2',1,'Sale Id shift 121',0.00,0.00,0.00,3498.06,0.00,'2023-01-09 08:59:56','',''),(664,'8','214',NULL,1,'Sale Id shift 121',2310990.00,0.00,0.00,0.00,0.00,'2023-01-09 08:59:56','',''),(665,'8','214','2',1,'Sale Id shift 122',0.00,0.00,0.00,3312.93,0.00,'2023-01-10 08:59:37','',''),(666,'8','214','2',1,'Sale Id shift 122',0.00,0.00,0.00,3096.19,0.00,'2023-01-10 08:59:37','',''),(667,'8','214',NULL,1,'Sale Id shift 122',1922736.00,0.00,0.00,0.00,0.00,'2023-01-10 08:59:37','',''),(668,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,5055000.00,16850.00,0.00,0.00,'2023-01-13 12:26:42','',''),(669,'8','214',NULL,1,'Reception corrector for bridging 43',0.00,0.00,0.00,16850.00,0.00,'2023-01-14 08:39:26','',''),(670,'8','214','2',1,'Received from bridging 43',0.00,0.00,16850.00,0.00,0.00,'2023-01-14 08:39:26','',''),(671,'8','214','2',1,'Sale Id shift 123',0.00,0.00,0.00,5060.26,0.00,'2023-01-14 08:41:25','',''),(672,'8','214','2',1,'Sale Id shift 123',0.00,0.00,0.00,4220.95,0.00,'2023-01-14 08:41:25','',''),(673,'8','214',NULL,1,'Sale Id shift 123',2784363.00,0.00,0.00,0.00,0.00,'2023-01-14 08:41:25','',''),(674,'8','214','2',1,'Sale Id shift 124',0.00,0.00,0.00,2561.16,0.00,'2023-01-14 08:44:23','',''),(675,'8','214','2',1,'Sale Id shift 124',0.00,0.00,0.00,2735.85,0.00,'2023-01-14 08:44:23','',''),(676,'8','214',NULL,1,'Sale Id shift 124',1589103.00,0.00,0.00,0.00,0.00,'2023-01-14 08:44:23','',''),(677,'8','214','2',1,'Sale Id shift 125',0.00,0.00,0.00,3566.83,0.00,'2023-01-14 08:47:21','',''),(678,'8','214','2',1,'Sale Id shift 125',0.00,0.00,0.00,3396.19,0.00,'2023-01-14 08:47:21','',''),(679,'8','214',NULL,1,'Sale Id shift 125',2088906.00,0.00,0.00,0.00,0.00,'2023-01-14 08:47:21','',''),(680,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,4425000.00,14750.00,0.00,0.00,'2023-01-18 14:43:24','',''),(681,'8','214',NULL,1,'Reception corrector for bridging 44',0.00,0.00,0.00,14750.00,0.00,'2023-01-19 09:22:07','',''),(682,'8','214','2',1,'Received from bridging 44',0.00,0.00,14750.00,0.00,0.00,'2023-01-19 09:22:07','',''),(683,'8','214','2',1,'Sale Id shift 126',0.00,0.00,0.00,2334.91,0.00,'2023-01-19 09:24:18','',''),(684,'8','214','2',1,'Sale Id shift 126',0.00,0.00,0.00,2317.51,0.00,'2023-01-19 09:24:18','',''),(685,'8','214',NULL,1,'Sale Id shift 126',1395726.00,0.00,0.00,0.00,0.00,'2023-01-19 09:24:18','',''),(686,'8','214','2',1,'Sale Id shift 127',0.00,0.00,0.00,4151.60,0.00,'2023-01-19 09:33:12','',''),(687,'8','214','2',1,'Sale Id shift 127',0.00,0.00,0.00,4201.16,0.00,'2023-01-19 09:33:12','',''),(688,'8','214',NULL,1,'Sale Id shift 127',2505828.00,0.00,0.00,0.00,0.00,'2023-01-19 09:33:12','',''),(689,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,10067400.00,32900.00,0.00,0.00,'2023-01-22 13:21:47','',''),(690,'8','214',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,16100.00,0.00,'2023-01-22 19:20:01','',''),(691,'8','214','2',1,'Received from bridging 46',0.00,0.00,16100.00,0.00,0.00,'2023-01-22 19:20:01','',''),(692,'8','214',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,16800.00,0.00,'2023-01-22 19:20:36','',''),(693,'8','214','1',1,'Received from bridging 45',0.00,0.00,16800.00,0.00,0.00,'2023-01-22 19:20:36','',''),(694,'8','214','2',1,'Sale Id shift 128',0.00,0.00,0.00,1916.19,0.00,'2023-01-23 07:09:16','',''),(695,'8','214','2',1,'Sale Id shift 128',0.00,0.00,0.00,2992.76,0.00,'2023-01-23 07:09:16','',''),(696,'8','214',NULL,1,'Sale Id shift 128',1472685.00,0.00,0.00,0.00,0.00,'2023-01-23 07:09:16','',''),(697,'8','214','2',1,'Sale Id shift 129',0.00,0.00,0.00,794.86,0.00,'2023-01-23 07:12:36','',''),(698,'8','214','2',1,'Sale Id shift 129',0.00,0.00,0.00,657.15,0.00,'2023-01-23 07:12:36','',''),(699,'8','214',NULL,1,'Sale Id shift 129',444315.06,0.00,0.00,0.00,0.00,'2023-01-23 07:12:36','',''),(700,'8','214','1',1,'Sale Id shift 130',0.00,0.00,0.00,1649.31,0.00,'2023-01-23 07:16:39','',''),(701,'8','214','1',1,'Sale Id shift 130',0.00,0.00,0.00,2958.70,0.00,'2023-01-23 07:16:39','',''),(702,'8','214','2',1,'Sale Id shift 130',0.00,0.00,0.00,1546.02,0.00,'2023-01-23 07:16:39','',''),(703,'8','214','2',1,'Sale Id shift 130',0.00,0.00,0.00,1622.83,0.00,'2023-01-23 07:16:39','',''),(704,'8','214',NULL,1,'Sale Id shift 130',2379719.16,0.00,0.00,0.00,0.00,'2023-01-23 07:16:39','',''),(705,'8','214','1',1,'Sale Id shift 131',0.00,0.00,0.00,1680.52,0.00,'2023-01-23 07:20:29','',''),(706,'8','214','1',1,'Sale Id shift 131',0.00,0.00,0.00,2571.54,0.00,'2023-01-23 07:20:29','',''),(707,'8','214','2',1,'Sale Id shift 131',0.00,0.00,0.00,2237.97,0.00,'2023-01-23 07:20:29','',''),(708,'8','214','2',1,'Sale Id shift 131',0.00,0.00,0.00,3819.56,0.00,'2023-01-23 07:20:29','',''),(709,'8','214',NULL,1,'Sale Id shift 131',3154734.54,0.00,0.00,0.00,0.00,'2023-01-23 07:20:29','',''),(710,'8','214','1',1,'Sale Id shift 132',0.00,0.00,0.00,1748.25,0.00,'2023-01-24 09:50:27','',''),(711,'8','214','1',1,'Sale Id shift 132',0.00,0.00,0.00,3664.74,0.00,'2023-01-24 09:50:27','',''),(712,'8','214','2',1,'Sale Id shift 132',0.00,0.00,0.00,1257.83,0.00,'2023-01-24 09:50:27','',''),(713,'8','214','2',1,'Sale Id shift 132',0.00,0.00,0.00,3465.46,0.00,'2023-01-24 09:50:27','',''),(714,'8','214',NULL,1,'Sale Id shift 132',3101701.68,0.00,0.00,0.00,0.00,'2023-01-24 09:50:27','',''),(715,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,16900000.00,50000.00,0.00,0.00,'2023-01-30 15:20:03','',''),(716,'8','214',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,31500.00,0.00,'2023-01-31 06:51:30','',''),(717,'8','214','2',1,'Received from bridging 48',0.00,0.00,31500.00,0.00,0.00,'2023-01-31 06:51:30','',''),(718,'8','214',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,18500.00,0.00,'2023-01-31 06:51:57','',''),(719,'8','214','1',1,'Received from bridging 47',0.00,0.00,18500.00,0.00,0.00,'2023-01-31 06:51:57','',''),(720,'8','214','1',1,'Sale Id shift 133',0.00,0.00,0.00,1209.83,0.00,'2023-01-31 07:28:11','',''),(721,'8','214','1',1,'Sale Id shift 133',0.00,0.00,0.00,1399.98,0.00,'2023-01-31 07:28:11','',''),(722,'8','214','2',1,'Sale Id shift 133',0.00,0.00,0.00,1022.59,0.00,'2023-01-31 07:28:11','',''),(723,'8','214','2',1,'Sale Id shift 133',0.00,0.00,0.00,636.99,0.00,'2023-01-31 07:28:11','',''),(724,'8','214',NULL,1,'Sale Id shift 133',1443053.82,0.00,0.00,0.00,0.00,'2023-01-31 07:28:11','',''),(725,'8','214','1',1,'Sale Id shift 134',0.00,0.00,0.00,1279.35,0.00,'2023-01-31 07:31:05','',''),(726,'8','214','1',1,'Sale Id shift 134',0.00,0.00,0.00,959.96,0.00,'2023-01-31 07:31:05','',''),(727,'8','214','2',1,'Sale Id shift 134',0.00,0.00,0.00,1480.14,0.00,'2023-01-31 07:31:05','',''),(728,'8','214','2',1,'Sale Id shift 134',0.00,0.00,0.00,2655.31,0.00,'2023-01-31 07:31:05','',''),(729,'8','214',NULL,1,'Sale Id shift 134',2154668.88,0.00,0.00,0.00,0.00,'2023-01-31 07:31:05','',''),(730,'8','214','1',1,'Sale Id shift 135',0.00,0.00,0.00,999.66,0.00,'2023-02-01 10:00:31','',''),(731,'8','214','1',1,'Sale Id shift 135',0.00,0.00,0.00,1563.49,0.00,'2023-02-01 10:00:31','',''),(732,'8','214','2',1,'Sale Id shift 135',0.00,0.00,0.00,1669.86,0.00,'2023-02-01 10:00:31','',''),(733,'8','214','2',1,'Sale Id shift 135',0.00,0.00,0.00,1232.23,0.00,'2023-02-01 10:00:31','',''),(734,'8','214',NULL,1,'Sale Id shift 135',1847251.12,0.00,0.00,0.00,0.00,'2023-02-01 10:00:31','',''),(735,'8','214','1',1,'Sale Id shift 136',0.00,0.00,0.00,20.73,0.00,'2023-02-03 06:26:20','',''),(736,'8','214','1',1,'Sale Id shift 136',0.00,0.00,0.00,860.44,0.00,'2023-02-03 06:26:20','',''),(737,'8','214','2',1,'Sale Id shift 136',0.00,0.00,0.00,902.45,0.00,'2023-02-03 06:26:20','',''),(738,'8','214','2',1,'Sale Id shift 136',0.00,0.00,0.00,879.05,0.00,'2023-02-03 06:26:20','',''),(739,'8','214',NULL,1,'Sale Id shift 136',899982.46,0.00,0.00,0.00,0.00,'2023-02-03 06:26:20','',''),(740,'8','214','1',1,'Sale Id shift 137',0.00,0.00,0.00,673.11,0.00,'2023-02-03 07:00:38','',''),(741,'8','214','1',1,'Sale Id shift 137',0.00,0.00,0.00,1216.63,0.00,'2023-02-03 07:00:38','',''),(742,'8','214','2',1,'Sale Id shift 137',0.00,0.00,0.00,992.60,0.00,'2023-02-03 07:00:38','',''),(743,'8','214','2',1,'Sale Id shift 137',0.00,0.00,0.00,2025.49,0.00,'2023-02-03 07:00:38','',''),(744,'8','214',NULL,1,'Sale Id shift 137',1658846.54,0.00,0.00,0.00,0.00,'2023-02-03 07:00:38','',''),(745,'8','214','1',1,'Sale Id shift 138',0.00,0.00,0.00,1236.87,0.00,'2023-02-06 09:04:52','',''),(746,'8','214','2',1,'Sale Id shift 138',0.00,0.00,0.00,2013.74,0.00,'2023-02-06 09:04:52','',''),(747,'8','214','2',1,'Sale Id shift 138',0.00,0.00,0.00,2328.72,0.00,'2023-02-06 09:04:52','',''),(748,'8','214',NULL,1,'Sale Id shift 138',1885813.54,0.00,0.00,0.00,0.00,'2023-02-06 09:04:52','',''),(749,'8','214','1',1,'Sale Id shift 139',0.00,0.00,0.00,1316.74,0.00,'2023-02-06 09:25:35','',''),(750,'8','214','1',1,'Sale Id shift 139',0.00,0.00,0.00,1282.69,0.00,'2023-02-06 09:25:35','',''),(751,'8','214','2',1,'Sale Id shift 139',0.00,0.00,0.00,2405.71,0.00,'2023-02-06 09:25:35','',''),(752,'8','214','2',1,'Sale Id shift 139',0.00,0.00,0.00,1256.62,0.00,'2023-02-06 09:25:35','',''),(753,'8','214',NULL,1,'Sale Id shift 139',2116474.88,0.00,0.00,0.00,0.00,'2023-02-06 09:25:35','',''),(754,'8','214','1',1,'Sale Id shift 140',0.00,0.00,0.00,1119.12,0.00,'2023-02-07 09:23:12','',''),(755,'8','214','1',1,'Sale Id shift 140',0.00,0.00,0.00,1235.57,0.00,'2023-02-07 09:23:12','',''),(756,'8','214','2',1,'Sale Id shift 140',0.00,0.00,0.00,2430.42,0.00,'2023-02-07 09:23:12','',''),(757,'8','214','2',1,'Sale Id shift 140',0.00,0.00,0.00,1141.33,0.00,'2023-02-07 09:23:12','',''),(758,'8','214',NULL,1,'Sale Id shift 140',2003136.72,0.00,0.00,0.00,0.00,'2023-02-07 09:23:12','',''),(759,'8','214','1',1,'Sale Id shift 141',0.00,0.00,0.00,571.59,0.00,'2023-02-08 08:49:35','',''),(760,'8','214','1',1,'Sale Id shift 141',0.00,0.00,0.00,1564.61,0.00,'2023-02-08 08:49:35','',''),(761,'8','214','2',1,'Sale Id shift 141',0.00,0.00,0.00,1230.53,0.00,'2023-02-08 08:49:35','',''),(762,'8','214','2',1,'Sale Id shift 141',0.00,0.00,0.00,1646.09,0.00,'2023-02-08 08:49:35','',''),(763,'8','214',NULL,1,'Sale Id shift 141',1694333.16,0.00,0.00,0.00,0.00,'2023-02-08 08:49:35','',''),(764,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,11350500.00,32900.00,0.00,0.00,'2023-02-09 08:43:50','',''),(765,'8','214',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,15900.00,0.00,'2023-02-09 13:43:29','',''),(766,'8','214','2',1,'Received from bridging 50',0.00,0.00,15900.00,0.00,0.00,'2023-02-09 13:43:29','',''),(767,'8','214',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,17000.00,0.00,'2023-02-09 13:44:03','',''),(768,'8','214','1',1,'Received from bridging 49',0.00,0.00,17000.00,0.00,0.00,'2023-02-09 13:44:03','',''),(769,'8','214','1',1,'Sale Id shift 142',0.00,0.00,0.00,859.47,0.00,'2023-02-10 07:47:08','',''),(770,'8','214','1',1,'Sale Id shift 142',0.00,0.00,0.00,1599.78,0.00,'2023-02-10 07:47:08','',''),(771,'8','214','2',1,'Sale Id shift 142',0.00,0.00,0.00,2806.15,0.00,'2023-02-10 07:47:08','',''),(772,'8','214','2',1,'Sale Id shift 142',0.00,0.00,0.00,2540.36,0.00,'2023-02-10 07:47:08','',''),(773,'8','214',NULL,1,'Sale Id shift 142',2638346.88,0.00,0.00,0.00,0.00,'2023-02-10 07:47:08','',''),(774,'8','214','1',1,'Sale Id shift 143',0.00,0.00,0.00,610.58,0.00,'2023-02-10 07:57:16','',''),(775,'8','214','1',1,'Sale Id shift 143',0.00,0.00,0.00,1824.92,0.00,'2023-02-10 07:57:16','',''),(776,'8','214','2',1,'Sale Id shift 143',0.00,0.00,0.00,2795.04,0.00,'2023-02-10 07:57:16','',''),(777,'8','214','2',1,'Sale Id shift 143',0.00,0.00,0.00,1477.75,0.00,'2023-02-10 07:57:16','',''),(778,'8','214',NULL,1,'Sale Id shift 143',2314360.05,0.00,0.00,0.00,0.00,'2023-02-10 07:57:16','',''),(779,'8','214','1',1,'Sale Id shift 144',0.00,0.00,0.00,1982.29,0.00,'2023-02-10 15:37:37','',''),(780,'8','214','1',1,'Sale Id shift 144',0.00,0.00,0.00,2187.24,0.00,'2023-02-10 15:37:37','',''),(781,'8','214','2',1,'Sale Id shift 144',0.00,0.00,0.00,1452.21,0.00,'2023-02-10 15:37:37','',''),(782,'8','214','2',1,'Sale Id shift 144',0.00,0.00,0.00,2412.85,0.00,'2023-02-10 15:37:37','',''),(783,'8','214',NULL,1,'Sale Id shift 144',2771933.55,0.00,0.00,0.00,0.00,'2023-02-10 15:37:37','',''),(784,'8','214','1',1,'Sale Id shift 145',0.00,0.00,0.00,779.33,0.00,'2023-02-11 16:22:26','',''),(785,'8','214','1',1,'Sale Id shift 145',0.00,0.00,0.00,3840.27,0.00,'2023-02-11 16:22:26','',''),(786,'8','214','2',1,'Sale Id shift 145',0.00,0.00,0.00,2761.29,0.00,'2023-02-11 16:22:26','',''),(787,'8','214','2',1,'Sale Id shift 145',0.00,0.00,0.00,31.03,0.00,'2023-02-11 16:22:26','',''),(788,'8','214',NULL,1,'Sale Id shift 145',2557112.40,0.00,0.00,0.00,0.00,'2023-02-11 16:22:26','',''),(789,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,7021000.00,20650.00,0.00,0.00,'2023-02-17 18:23:03','',''),(790,'8','214',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,20650.00,0.00,'2023-02-18 10:46:51','',''),(791,'8','214','2',1,'Received from bridging 51',0.00,0.00,20650.00,0.00,0.00,'2023-02-18 10:46:51','',''),(792,'8','214','1',1,'Sale Id shift 146',0.00,0.00,0.00,618.64,0.00,'2023-02-18 10:51:26','',''),(793,'8','214','1',1,'Sale Id shift 146',0.00,0.00,0.00,2290.40,0.00,'2023-02-18 10:51:26','',''),(794,'8','214','2',1,'Sale Id shift 146',0.00,0.00,0.00,1711.36,0.00,'2023-02-18 10:51:26','',''),(795,'8','214','2',1,'Sale Id shift 146',0.00,0.00,0.00,2111.86,0.00,'2023-02-18 10:51:26','',''),(796,'8','214',NULL,1,'Sale Id shift 146',2322629.70,0.00,0.00,0.00,0.00,'2023-02-18 10:51:26','',''),(797,'8','214','1',1,'Sale Id shift 147',0.00,0.00,0.00,1536.09,0.00,'2023-02-18 10:57:49','',''),(798,'8','214','1',1,'Sale Id shift 147',0.00,0.00,0.00,1274.93,0.00,'2023-02-18 10:57:49','',''),(799,'8','214','2',1,'Sale Id shift 147',0.00,0.00,0.00,1205.32,0.00,'2023-02-18 10:57:49','',''),(800,'8','214',NULL,1,'Sale Id shift 147',1365555.60,0.00,0.00,0.00,0.00,'2023-02-18 10:57:49','',''),(801,'8','214','2',1,'Sale Id shift 148',0.00,0.00,0.00,3142.38,0.00,'2023-02-18 11:04:00','',''),(802,'8','214','2',1,'Sale Id shift 148',0.00,0.00,0.00,2560.00,0.00,'2023-02-18 11:04:00','',''),(803,'8','214',NULL,1,'Sale Id shift 148',1938809.20,0.00,0.00,0.00,0.00,'2023-02-18 11:04:00','',''),(804,'8','214','2',1,'Sale Id shift 149',0.00,0.00,0.00,2817.89,0.00,'2023-02-19 09:05:55','',''),(805,'8','214','2',1,'Sale Id shift 149',0.00,0.00,0.00,3090.53,0.00,'2023-02-19 09:05:55','',''),(806,'8','214',NULL,1,'Sale Id shift 149',2008862.80,0.00,0.00,0.00,0.00,'2023-02-19 09:05:55','',''),(807,'8','214','2',1,'Sale Id shift 150',0.00,0.00,0.00,2527.02,0.00,'2023-02-20 18:04:32','',''),(808,'8','214','2',1,'Sale Id shift 150',0.00,0.00,0.00,3154.98,0.00,'2023-02-20 18:04:32','',''),(809,'8','214',NULL,1,'Sale Id shift 150',1931880.00,0.00,0.00,0.00,0.00,'2023-02-20 18:04:32','',''),(810,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,14970000.00,49900.00,0.00,0.00,'2023-02-23 09:52:20','',''),(811,'8','214',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,32850.00,0.00,'2023-02-24 08:39:06','',''),(812,'8','214','2',1,'Received from bridging 53',0.00,0.00,32850.00,0.00,0.00,'2023-02-24 08:39:06','',''),(813,'8','214',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,17050.00,0.00,'2023-02-24 08:39:47','',''),(814,'8','214','1',1,'Received from bridging 52',0.00,0.00,17050.00,0.00,0.00,'2023-02-24 08:39:47','',''),(815,'8','214','2',1,'Sale Id shift 151',0.00,0.00,0.00,1642.34,0.00,'2023-02-24 08:44:45','',''),(816,'8','214','2',1,'Sale Id shift 151',0.00,0.00,0.00,1855.15,0.00,'2023-02-24 08:44:45','',''),(817,'8','214',NULL,1,'Sale Id shift 151',1049247.00,0.00,0.00,0.00,0.00,'2023-02-24 08:44:45','',''),(818,'8','214','1',1,'Sale Id shift 152',0.00,0.00,0.00,1362.22,0.00,'2023-02-24 08:52:19','',''),(819,'8','214','2',1,'Sale Id shift 152',0.00,0.00,0.00,2253.71,0.00,'2023-02-24 08:52:19','',''),(820,'8','214','2',1,'Sale Id shift 152',0.00,0.00,0.00,2316.78,0.00,'2023-02-24 08:52:19','',''),(821,'8','214',NULL,1,'Sale Id shift 152',1779813.00,0.00,0.00,0.00,0.00,'2023-02-24 08:52:19','',''),(822,'8','214','1',1,'Sale Id shift 153',0.00,0.00,0.00,1637.96,0.00,'2023-02-24 08:58:26','',''),(823,'8','214','1',1,'Sale Id shift 153',0.00,0.00,0.00,1199.13,0.00,'2023-02-24 08:58:26','',''),(824,'8','214','2',1,'Sale Id shift 153',0.00,0.00,0.00,1806.06,0.00,'2023-02-24 08:58:26','',''),(825,'8','214','2',1,'Sale Id shift 153',0.00,0.00,0.00,2789.97,0.00,'2023-02-24 08:58:26','',''),(826,'8','214',NULL,1,'Sale Id shift 153',2229936.00,0.00,0.00,0.00,0.00,'2023-02-24 08:58:26','',''),(827,'8','214','1',1,'Sale Id shift 154',0.00,0.00,0.00,246.37,0.00,'2023-02-26 11:15:27','',''),(828,'8','214','1',1,'Sale Id shift 154',0.00,0.00,0.00,1698.90,0.00,'2023-02-26 11:15:27','',''),(829,'8','214','2',1,'Sale Id shift 154',0.00,0.00,0.00,1968.50,0.00,'2023-02-26 11:15:27','',''),(830,'8','214','2',1,'Sale Id shift 154',0.00,0.00,0.00,2237.54,0.00,'2023-02-26 11:15:27','',''),(831,'8','214',NULL,1,'Sale Id shift 154',1845393.00,0.00,0.00,0.00,0.00,'2023-02-26 11:15:27','',''),(832,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,9600000.00,32000.00,0.00,0.00,'2023-02-26 20:07:00','',''),(833,'8','214','1',1,'Sale Id shift 155',0.00,0.00,0.00,946.48,0.00,'2023-03-01 09:17:35','',''),(834,'8','214','1',1,'Sale Id shift 155',0.00,0.00,0.00,2430.45,0.00,'2023-03-01 09:17:35','',''),(835,'8','214','2',1,'Sale Id shift 155',0.00,0.00,0.00,4241.06,0.00,'2023-03-01 09:17:35','',''),(836,'8','214',NULL,1,'Sale Id shift 155',2285397.00,0.00,0.00,0.00,0.00,'2023-03-01 09:17:35','',''),(837,'8','214','1',1,'Sale Id shift 156',0.00,0.00,0.00,930.52,0.00,'2023-03-01 09:23:55','',''),(838,'8','214','1',1,'Sale Id shift 156',0.00,0.00,0.00,1189.54,0.00,'2023-03-01 09:23:55','',''),(839,'8','214','2',1,'Sale Id shift 156',0.00,0.00,0.00,1265.29,0.00,'2023-03-01 09:23:55','',''),(840,'8','214','2',1,'Sale Id shift 156',0.00,0.00,0.00,2292.22,0.00,'2023-03-01 09:23:55','',''),(841,'8','214',NULL,1,'Sale Id shift 156',1703271.00,0.00,0.00,0.00,0.00,'2023-03-01 09:23:55','',''),(842,'8','214',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,16400.00,0.00,'2023-03-02 09:01:15','',''),(843,'8','214','2',1,'Received from bridging 55',0.00,0.00,16400.00,0.00,0.00,'2023-03-02 09:01:15','',''),(844,'8','214',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,15600.00,0.00,'2023-03-02 09:01:33','',''),(845,'8','214','1',1,'Received from bridging 54',0.00,0.00,15600.00,0.00,0.00,'2023-03-02 09:01:33','',''),(846,'8','214','1',1,'Sale Id shift 157',0.00,0.00,0.00,2473.88,0.00,'2023-03-02 09:33:27','',''),(847,'8','214','1',1,'Sale Id shift 157',0.00,0.00,0.00,3784.86,0.00,'2023-03-02 09:33:27','',''),(848,'8','214','2',1,'Sale Id shift 157',0.00,0.00,0.00,3166.78,0.00,'2023-03-02 09:33:27','',''),(849,'8','214','2',1,'Sale Id shift 157',0.00,0.00,0.00,2549.43,0.00,'2023-03-02 09:33:27','',''),(850,'8','214',NULL,1,'Sale Id shift 157',3592485.00,0.00,0.00,0.00,0.00,'2023-03-02 09:33:27','',''),(851,'8','214','1',1,'Sale Id shift 158',0.00,0.00,0.00,2005.34,0.00,'2023-03-02 09:38:02','',''),(852,'8','214','2',1,'Sale Id shift 158',0.00,0.00,0.00,1811.84,0.00,'2023-03-02 09:38:02','',''),(853,'8','214','2',1,'Sale Id shift 158',0.00,0.00,0.00,1659.61,0.00,'2023-03-02 09:38:02','',''),(854,'8','214',NULL,1,'Sale Id shift 158',1643037.00,0.00,0.00,0.00,0.00,'2023-03-02 09:38:02','',''),(855,'8','214','1',1,'Sale Id shift 159',0.00,0.00,0.00,735.12,0.00,'2023-03-03 20:34:28','',''),(856,'8','214','1',1,'Sale Id shift 159',0.00,0.00,0.00,2916.00,0.00,'2023-03-03 20:34:28','',''),(857,'8','214','2',1,'Sale Id shift 159',0.00,0.00,0.00,1076.50,0.00,'2023-03-03 20:34:28','',''),(858,'8','214','2',1,'Sale Id shift 159',0.00,0.00,0.00,1125.27,0.00,'2023-03-03 20:34:28','',''),(859,'8','214',NULL,1,'Sale Id shift 159',1755867.00,0.00,0.00,0.00,0.00,'2023-03-03 20:34:28','',''),(860,'8','214','1',1,'Sale Id shift 160',0.00,0.00,0.00,2171.08,0.00,'2023-03-04 09:29:19','',''),(861,'8','214','2',1,'Sale Id shift 160',0.00,0.00,0.00,2760.27,0.00,'2023-03-04 09:29:19','',''),(862,'8','214','2',1,'Sale Id shift 160',0.00,0.00,0.00,2487.27,0.00,'2023-03-04 09:29:19','',''),(863,'8','214',NULL,1,'Sale Id shift 160',2225586.00,0.00,0.00,0.00,0.00,'2023-03-04 09:29:19','',''),(864,'8','214','1',1,'Sale Id shift 161',0.00,0.00,0.00,108.35,0.00,'2023-03-05 18:59:41','',''),(865,'8','214','1',1,'Sale Id shift 161',0.00,0.00,0.00,2000.91,0.00,'2023-03-05 18:59:41','',''),(866,'8','214','2',1,'Sale Id shift 161',0.00,0.00,0.00,2629.04,0.00,'2023-03-05 18:59:41','',''),(867,'8','214','2',1,'Sale Id shift 161',0.00,0.00,0.00,2006.71,0.00,'2023-03-05 18:59:41','',''),(868,'8','214',NULL,1,'Sale Id shift 161',2023503.00,0.00,0.00,0.00,0.00,'2023-03-05 18:59:41','',''),(869,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,5130000.00,17100.00,0.00,0.00,'2023-03-06 12:07:53','',''),(870,'8','214',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,17100.00,0.00,'2023-03-08 08:06:27','',''),(871,'8','214','2',1,'Received from bridging 56',0.00,0.00,17100.00,0.00,0.00,'2023-03-08 08:06:27','',''),(872,'8','214','1',1,'Sale Id shift 162',0.00,0.00,0.00,1444.29,0.00,'2023-03-08 09:04:47','',''),(873,'8','214','2',1,'Sale Id shift 162',0.00,0.00,0.00,1962.31,0.00,'2023-03-08 09:04:47','',''),(874,'8','214','2',1,'Sale Id shift 162',0.00,0.00,0.00,1774.53,0.00,'2023-03-08 09:04:47','',''),(875,'8','214',NULL,1,'Sale Id shift 162',1554339.00,0.00,0.00,0.00,0.00,'2023-03-08 09:04:47','',''),(876,'8','214','1',1,'Sale Id shift 163',0.00,0.00,0.00,1652.37,0.00,'2023-03-08 09:12:39','',''),(877,'8','214','2',1,'Sale Id shift 163',0.00,0.00,0.00,2124.39,0.00,'2023-03-08 09:12:39','',''),(878,'8','214','2',1,'Sale Id shift 163',0.00,0.00,0.00,1980.22,0.00,'2023-03-08 09:12:39','',''),(879,'8','214',NULL,1,'Sale Id shift 163',1727094.00,0.00,0.00,0.00,0.00,'2023-03-08 09:12:39','',''),(880,'8','214','1',1,'Sale Id shift 164',0.00,0.00,0.00,570.08,0.00,'2023-03-09 13:34:21','',''),(881,'8','214','1',1,'Sale Id shift 164',0.00,0.00,0.00,984.61,0.00,'2023-03-09 13:34:21','',''),(882,'8','214','2',1,'Sale Id shift 164',0.00,0.00,0.00,3879.33,0.00,'2023-03-09 13:34:21','',''),(883,'8','214','2',1,'Sale Id shift 164',0.00,0.00,0.00,4416.25,0.00,'2023-03-09 13:34:21','',''),(884,'8','214',NULL,1,'Sale Id shift 164',2955081.00,0.00,0.00,0.00,0.00,'2023-03-09 13:34:21','',''),(885,'8','214','2',1,'Sale Id shift 165',0.00,0.00,0.00,2366.16,0.00,'2023-03-09 13:37:31','',''),(886,'8','214','2',1,'Sale Id shift 165',0.00,0.00,0.00,2241.60,0.00,'2023-03-09 13:37:31','',''),(887,'8','214',NULL,1,'Sale Id shift 165',1382328.00,0.00,0.00,0.00,0.00,'2023-03-09 13:37:31','',''),(888,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,9900000.00,33000.00,0.00,0.00,'2023-03-12 13:21:36','',''),(889,'8','214',NULL,1,'Reception corrector for bridging 60',0.00,0.00,0.00,16950.00,0.00,'2023-03-13 09:05:56','',''),(890,'8','214','2',1,'Received from bridging 60',0.00,0.00,16950.00,0.00,0.00,'2023-03-13 09:05:56','',''),(891,'8','214',NULL,1,'Reception corrector for bridging 59',0.00,0.00,0.00,16050.00,0.00,'2023-03-13 09:06:34','',''),(892,'8','214','1',1,'Received from bridging 59',0.00,0.00,16050.00,0.00,0.00,'2023-03-13 09:06:34','',''),(893,'8','214','2',1,'Sale Id shift 166',0.00,0.00,0.00,1477.23,0.00,'2023-03-14 08:27:04','',''),(894,'8','214','2',1,'Sale Id shift 166',0.00,0.00,0.00,1795.71,0.00,'2023-03-14 08:27:04','',''),(895,'8','214',NULL,1,'Sale Id shift 166',981882.00,0.00,0.00,0.00,0.00,'2023-03-14 08:27:04','',''),(896,'8','214','1',1,'Sale Id shift 167',0.00,0.00,0.00,930.46,0.00,'2023-03-14 08:39:32','',''),(897,'8','214','1',1,'Sale Id shift 167',0.00,0.00,0.00,1125.68,0.00,'2023-03-14 08:39:32','',''),(898,'8','214','2',1,'Sale Id shift 167',0.00,0.00,0.00,1570.31,0.00,'2023-03-14 08:39:32','',''),(899,'8','214','2',1,'Sale Id shift 167',0.00,0.00,0.00,2397.95,0.00,'2023-03-14 08:39:32','',''),(900,'8','214',NULL,1,'Sale Id shift 167',1807320.00,0.00,0.00,0.00,0.00,'2023-03-14 08:39:32','',''),(901,'8','214','1',1,'Sale Id shift 168',0.00,0.00,0.00,943.51,0.00,'2023-03-14 09:01:17','',''),(902,'8','214','1',1,'Sale Id shift 168',0.00,0.00,0.00,1321.31,0.00,'2023-03-14 09:01:17','',''),(903,'8','214','2',1,'Sale Id shift 168',0.00,0.00,0.00,2032.48,0.00,'2023-03-14 09:01:17','',''),(904,'8','214','2',1,'Sale Id shift 168',0.00,0.00,0.00,848.65,0.00,'2023-03-14 09:01:17','',''),(905,'8','214',NULL,1,'Sale Id shift 168',1543785.00,0.00,0.00,0.00,0.00,'2023-03-14 09:01:17','',''),(906,'8','214','1',1,'Sale Id shift 169',0.00,0.00,0.00,600.63,0.00,'2023-03-16 09:37:06','',''),(907,'8','214','1',1,'Sale Id shift 169',0.00,0.00,0.00,1818.47,0.00,'2023-03-16 09:37:06','',''),(908,'8','214','2',1,'Sale Id shift 169',0.00,0.00,0.00,845.60,0.00,'2023-03-16 09:37:06','',''),(909,'8','214','2',1,'Sale Id shift 169',0.00,0.00,0.00,1869.85,0.00,'2023-03-16 09:37:06','',''),(910,'8','214',NULL,1,'Sale Id shift 169',1540365.00,0.00,0.00,0.00,0.00,'2023-03-16 09:37:06','',''),(911,'8','214',NULL,1,'Purchased from Lausu Energy Resources',0.00,14940000.00,49800.00,0.00,0.00,'2023-03-17 08:26:46','',''),(912,'8','214',NULL,1,'Reception corrector for bridging 61',0.00,0.00,0.00,15400.00,0.00,'2023-03-17 10:42:54','',''),(913,'8','214','1',1,'Received from bridging 61',0.00,0.00,15400.00,0.00,0.00,'2023-03-17 10:42:54','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'8','214',2,0.00,'2023-03-16 09:38:31'),(2,'8','214',1,67854.70,'2023-03-17 08:26:46');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=168 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'8','214',1,'Sale Id shift 2',0.00,0.00,215.00,2367562.80,2367562.80,'2022-08-10 09:42:03'),(2,'8','214',1,'Sale Id shift 3',0.00,1226095.55,215.00,1226095.55,0.00,'2022-08-12 14:11:38'),(3,'8','214',1,'Sale Id shift 4',0.00,1199143.15,215.00,1199143.15,0.00,'2022-08-12 22:04:46'),(4,'8','214',1,'Sale Id shift 5',0.00,1230257.95,215.00,1230257.95,0.00,'2022-08-13 21:58:02'),(5,'8','214',1,'Sale Id shift 6',0.00,1111472.60,215.00,1111472.60,0.00,'2022-08-14 09:51:43'),(6,'8','214',1,'Sale Id shift 7',0.00,1086545.50,215.00,1086545.50,0.00,'2022-08-16 09:40:52'),(7,'8','214',1,'Sale Id shift 8',0.00,1160890.35,215.00,1160890.35,0.00,'2022-08-20 10:14:31'),(8,'8','214',1,'Sale Id shift 9',0.00,1423762.25,207.00,1370785.05,-52977.20,'2022-08-20 10:19:27'),(9,'8','214',1,'Sale Id shift 10',0.00,1064716.55,207.00,1025099.19,-39617.36,'2022-08-20 10:26:38'),(10,'8','214',1,'Sale Id shift 11',0.00,1186718.30,207.00,1142561.34,-44156.96,'2022-08-20 10:34:14'),(11,'8','214',1,'Sale Id shift 12',0.00,919284.10,207.00,885078.18,-34205.92,'2022-08-20 10:54:48'),(12,'8','214',1,'Sale Id shift 13',0.00,1140747.00,207.00,1098300.60,-42446.40,'2022-08-21 19:33:22'),(13,'8','214',1,'Sale Id shift 14',0.00,1255043.07,200.00,1212602.00,-42441.07,'2022-08-23 07:43:47'),(14,'8','214',1,'Sale Id shift 15',0.00,916631.19,200.00,885634.00,-30997.19,'2022-08-23 11:53:34'),(15,'8','214',1,'Sale Id shift 16',0.00,1395598.00,200.00,1395598.00,0.00,'2022-08-24 17:30:40'),(16,'8','214',1,'Sale Id shift 17',0.00,939342.00,190.00,892374.90,-46967.10,'2022-08-25 07:41:27'),(17,'8','214',1,'Sale Id shift 18',0.00,1034436.00,190.00,982714.20,-51721.80,'2022-08-26 08:05:08'),(18,'8','214',1,'Sale Id shift 19',0.00,1241462.00,190.00,1179388.90,-62073.10,'2022-08-28 15:36:06'),(19,'8','214',1,'Sale Id shift 20',0.00,1216716.00,190.00,1155880.20,-60835.80,'2022-08-28 18:58:47'),(20,'8','214',1,'Sale Id shift 21',0.00,1177730.64,190.00,1081008.80,-96721.84,'2022-08-29 08:16:27'),(21,'8','214',1,'Sale Id shift 22',0.00,1175890.41,190.00,1079319.70,-96570.71,'2022-08-30 08:01:04'),(22,'8','214',1,'Sale Id shift 23',0.00,2764154.20,190.00,2764154.20,0.00,'2022-08-31 08:00:18'),(23,'8','214',1,'Sale Id shift 24',0.00,1047895.60,190.00,1047895.60,0.00,'2022-09-02 10:11:15'),(24,'8','214',1,'Sale Id shift 25',0.00,1155581.90,190.00,1155581.90,0.00,'2022-09-02 10:16:52'),(25,'8','214',1,'Sale Id shift 26',0.00,1318926.80,190.00,1318926.80,0.00,'2022-09-03 08:40:24'),(26,'8','214',1,'Sale Id shift 27',0.00,1282501.90,190.00,1282501.90,0.00,'2022-09-04 08:32:06'),(27,'8','214',1,'Sale Id shift 28',0.00,880862.80,190.00,880862.80,0.00,'2022-09-05 07:56:18'),(28,'8','214',1,'Sale Id shift 29',0.00,823047.70,190.00,823047.70,0.00,'2022-09-06 07:52:35'),(29,'8','214',1,'Sale Id shift 30',0.00,1866998.90,190.00,1866998.90,0.00,'2022-09-07 08:17:22'),(30,'8','214',1,'Sale Id shift 31',0.00,671399.20,190.00,671399.20,0.00,'2022-09-08 08:23:57'),(31,'8','214',1,'Sale Id shift 32',0.00,854454.70,190.00,854454.70,0.00,'2022-09-09 08:42:32'),(32,'8','214',1,'Sale Id shift 33',0.00,572090.00,190.00,572090.00,0.00,'2022-09-10 07:46:45'),(33,'8','214',1,'Sale Id shift 34',0.00,589792.30,190.00,589792.30,0.00,'2022-09-11 08:21:50'),(34,'8','214',1,'Sale Id shift 35',0.00,662771.30,190.00,662771.30,0.00,'2022-09-12 07:51:37'),(35,'8','214',1,'Sale Id shift 36',0.00,1301220.70,190.00,1301220.70,0.00,'2022-09-13 09:48:36'),(36,'8','214',1,'Sale Id shift 37',0.00,2914252.30,190.00,2914252.30,0.00,'2022-09-14 08:17:15'),(37,'8','214',1,'Sale Id shift 38',0.00,944529.90,190.00,944529.90,0.00,'2022-09-15 07:52:57'),(38,'8','214',1,'Sale Id shift 39',0.00,1135006.80,190.00,1135006.80,0.00,'2022-09-16 15:28:32'),(39,'8','214',1,'Sale Id shift 40',0.00,1168192.20,190.00,1168192.20,0.00,'2022-09-17 08:10:58'),(40,'8','214',1,'Sale Id shift 41',0.00,1191094.80,190.00,1191094.80,0.00,'2022-09-18 09:45:08'),(41,'8','214',1,'Sale Id shift 42',0.00,1321079.50,190.00,1321079.50,0.00,'2022-09-20 08:25:26'),(42,'8','214',1,'Sale Id shift 43',0.00,1134590.70,190.00,1134590.70,0.00,'2022-09-20 08:30:29'),(43,'8','214',1,'Sale Id shift 44',0.00,2652852.20,190.00,2652852.20,0.00,'2022-09-21 08:47:24'),(44,'8','214',1,'Sale Id shift 45',0.00,1141702.40,190.00,1141702.40,0.00,'2022-09-22 09:08:48'),(45,'8','214',1,'Sale Id shift 46',0.00,1211793.40,190.00,1211793.40,0.00,'2022-09-23 08:03:22'),(46,'8','214',1,'Sale Id shift 47',0.00,1310044.30,190.00,1310044.30,0.00,'2022-09-24 08:35:59'),(47,'8','214',1,'Sale Id shift 48',0.00,1381161.30,190.00,1381161.30,0.00,'2022-09-25 10:49:14'),(48,'8','214',1,'Sale Id shift 49',0.00,1385464.80,190.00,1385464.80,0.00,'2022-09-26 12:27:45'),(49,'8','214',1,'Sale Id shift 50',0.00,1313542.20,190.00,1313542.20,0.00,'2022-09-27 08:12:14'),(50,'8','214',1,'Sale Id shift 51',0.00,3364012.70,190.00,3364012.70,0.00,'2022-09-28 10:05:51'),(51,'8','214',1,'Sale Id shift 52',0.00,873663.70,190.00,873663.70,0.00,'2022-09-29 10:53:26'),(52,'8','214',1,'Sale Id shift 53',0.00,668005.80,190.00,668005.80,0.00,'2022-09-30 07:52:33'),(53,'8','214',1,'Sale Id shift 54',0.00,835264.70,190.00,835264.70,0.00,'2022-10-01 07:08:04'),(54,'8','214',1,'Sale Id shift 55',0.00,872210.20,190.00,872210.20,0.00,'2022-10-02 08:47:01'),(55,'8','214',1,'Sale Id shift 56',0.00,720936.00,190.00,720936.00,0.00,'2022-10-03 06:28:23'),(56,'8','214',1,'Sale Id shift 57',0.00,302181.70,190.00,302181.70,0.00,'2022-10-03 10:49:50'),(57,'8','214',1,'Sale Id shift 58',0.00,391892.10,190.00,391892.10,0.00,'2022-10-04 15:04:19'),(58,'8','214',1,'Sale Id shift 60',0.00,2107924.60,0.00,0.00,-2107924.60,'2022-10-07 14:07:13'),(59,'8','214',1,'Sale Id shift 61',0.00,1320300.50,190.00,1320300.50,0.00,'2022-10-07 14:21:30'),(60,'8','214',1,'Sale Id shift 62',0.00,207398.30,190.00,207398.30,0.00,'2022-10-07 14:28:01'),(61,'8','214',1,'Sale Id shift 63',0.00,588829.00,190.00,588829.00,0.00,'2022-10-08 10:13:13'),(62,'8','214',1,'Sale Id shift 64',0.00,1048608.10,203.00,1120354.97,71746.87,'2022-10-09 08:25:53'),(63,'8','214',1,'Sale Id shift 65',0.00,1603955.30,203.00,1713699.61,109744.31,'2022-10-10 13:23:35'),(64,'8','214',1,'Sale Id shift 66',0.00,2262950.62,203.00,2262950.62,0.00,'2022-10-11 10:19:32'),(65,'8','214',1,'Sale Id shift 67',0.00,2447871.44,206.00,2484046.88,36175.44,'2022-10-12 10:10:11'),(66,'8','214',1,'Sale Id shift 68',0.00,1135261.26,220.00,1230332.40,95071.14,'2022-10-22 10:41:26'),(67,'8','214',1,'Sale Id shift 69',0.00,1969290.60,235.00,1969290.60,0.00,'2022-10-22 10:49:31'),(68,'8','214',1,'Sale Id shift 70',0.00,1269007.05,240.00,1296007.20,27000.15,'2022-10-23 07:46:28'),(69,'8','214',1,'Sale Id shift 71',0.00,958327.65,240.00,978717.60,20389.95,'2022-10-27 11:15:47'),(70,'8','214',1,'Sale Id shift 72',0.00,2931921.60,240.00,2931921.60,0.00,'2022-10-27 11:20:24'),(71,'8','214',1,'Sale Id shift 73',0.00,1043961.60,250.00,1087460.00,43498.40,'2022-10-27 11:23:40'),(72,'8','214',1,'Sale Id shift 74',0.00,738465.60,250.00,769235.00,30769.40,'2022-11-06 10:20:57'),(73,'8','214',1,'Sale Id shift 75',0.00,1538927.55,255.00,1538927.55,0.00,'2022-11-06 10:32:22'),(74,'8','214',1,'Sale Id shift 76',0.00,1912076.70,255.00,1912076.70,0.00,'2022-11-07 11:12:51'),(75,'8','214',1,'Sale Id shift 77',0.00,1696634.85,255.00,1696634.85,0.00,'2022-11-08 06:30:38'),(76,'8','214',1,'Sale Id shift 78',0.00,3964130.55,255.00,3964130.55,0.00,'2022-11-09 13:35:34'),(77,'8','214',1,'Sale Id shift 79',0.00,1732186.95,255.00,1732186.95,0.00,'2022-11-10 09:23:28'),(78,'8','214',1,'Sale Id shift 80',0.00,1144447.65,255.00,1144447.65,0.00,'2022-11-11 08:21:07'),(79,'8','214',1,'Sale Id shift 81',0.00,747762.00,255.00,747762.00,0.00,'2022-11-17 07:47:43'),(80,'8','214',1,'Sale Id shift 82',0.00,1511757.30,255.00,1511757.30,0.00,'2022-11-17 07:51:09'),(81,'8','214',1,'Sale Id shift 83',0.00,1823737.05,255.00,1823737.05,0.00,'2022-11-18 09:03:19'),(82,'8','214',1,'Sale Id shift 84',0.00,939371.55,255.00,939371.55,0.00,'2022-11-20 18:15:17'),(83,'8','214',1,'Sale Id shift 85',0.00,1606776.60,260.00,1606776.60,0.00,'2022-11-21 08:50:33'),(84,'8','214',1,'Sale Id shift 86',0.00,1813416.80,260.00,1813416.80,0.00,'2022-11-22 08:49:44'),(85,'8','214',1,'Sale Id shift 87',0.00,4468588.80,260.00,4468588.80,0.00,'2022-11-23 08:15:43'),(86,'8','214',1,'Sale Id shift 88',0.00,635887.20,260.00,635887.20,0.00,'2022-11-24 15:55:30'),(87,'8','214',1,'Sale Id shift 89',0.00,1131702.00,260.00,1131702.00,0.00,'2022-11-25 12:25:22'),(88,'8','214',1,'Sale Id shift 90',0.00,1601451.80,260.00,1601451.80,0.00,'2022-11-26 08:32:18'),(89,'8','214',1,'Sale Id shift 91',0.00,1778610.60,260.00,1778610.60,0.00,'2022-11-27 12:18:56'),(90,'8','214',1,'Sale Id shift 92',0.00,1906998.60,260.00,1906998.60,0.00,'2022-11-28 08:52:31'),(91,'8','214',1,'Sale Id shift 93',0.00,1321450.00,260.00,1321450.00,0.00,'2022-11-29 08:36:04'),(92,'8','214',1,'Sale Id shift 94',0.00,1172732.60,260.00,1172732.60,0.00,'2022-12-07 08:03:53'),(93,'8','214',1,'Sale Id shift 95',0.00,6295201.20,270.00,6295201.20,0.00,'2022-12-07 08:10:06'),(94,'8','214',1,'Sale Id shift 96',0.00,2147137.20,277.00,2202803.72,55666.52,'2022-12-15 08:36:48'),(95,'8','214',1,'Sale Id shift 97',0.00,605203.20,290.00,557171.20,-48032.00,'2022-12-15 08:41:18'),(96,'8','214',1,'Sale Id shift 98',0.00,514939.95,315.00,514939.95,0.00,'2022-12-15 08:45:23'),(97,'8','214',1,'Sale Id shift 99',0.00,1846366.20,315.00,1846366.20,0.00,'2022-12-16 11:43:28'),(98,'8','214',1,'Sale Id shift 100',0.00,1613924.55,315.00,1613924.55,0.00,'2022-12-17 08:27:28'),(99,'8','214',1,'Sale Id shift 101',0.00,1857334.50,315.00,1857334.50,0.00,'2022-12-18 08:54:36'),(100,'8','214',1,'Sale Id shift 102',0.00,1366233.75,315.00,1366233.75,0.00,'2022-12-19 17:15:51'),(101,'8','214',1,'Sale Id shift 103',0.00,1648108.35,315.00,1648108.35,0.00,'2022-12-20 12:19:44'),(102,'8','214',1,'Sale Id shift 104',0.00,4010627.25,315.00,4010627.25,0.00,'2022-12-21 08:15:19'),(103,'8','214',1,'Sale Id shift 105',0.00,1271368.35,315.00,1271368.35,0.00,'2022-12-22 08:19:42'),(104,'8','214',1,'Sale Id shift 106',0.00,1097267.85,315.00,1097267.85,0.00,'2022-12-26 08:09:11'),(105,'8','214',1,'Sale Id shift 107',0.00,374125.20,315.00,386391.60,12266.40,'2022-12-26 08:12:28'),(106,'8','214',1,'Sale Id shift 108',0.00,2074780.80,305.00,2074780.80,0.00,'2022-12-26 11:08:46'),(107,'8','214',1,'Sale Id shift 109',0.00,1909949.65,305.00,1909949.65,0.00,'2022-12-27 08:59:59'),(108,'8','214',1,'Sale Id shift 110',0.00,1503180.30,305.00,1503180.30,0.00,'2022-12-29 15:27:27'),(109,'8','214',1,'Sale Id shift 111',0.00,1473807.00,300.00,1473807.00,0.00,'2022-12-30 08:42:38'),(110,'8','214',1,'Sale Id shift 112',0.00,2087250.00,300.00,2087250.00,0.00,'2022-12-31 08:39:15'),(111,'8','214',1,'Sale Id shift 113',0.00,2271825.00,300.00,2271825.00,0.00,'2023-01-01 12:27:03'),(112,'8','214',1,'Sale Id shift 114',0.00,2094555.00,300.00,2094555.00,0.00,'2023-01-02 12:24:18'),(113,'8','214',1,'Sale Id shift 115',0.00,1863603.00,300.00,1863603.00,0.00,'2023-01-03 14:25:27'),(114,'8','214',1,'Sale Id shift 116',0.00,5252202.00,300.00,5252202.00,0.00,'2023-01-04 09:30:40'),(115,'8','214',1,'Sale Id shift 117',0.00,2300562.00,300.00,2300562.00,0.00,'2023-01-05 08:49:53'),(116,'8','214',1,'Sale Id shift 118',0.00,2124813.00,300.00,2124813.00,0.00,'2023-01-06 11:02:10'),(117,'8','214',1,'Sale Id shift 119',0.00,2156964.00,300.00,2156964.00,0.00,'2023-01-07 11:00:17'),(118,'8','214',1,'Sale Id shift 120',0.00,2748516.00,300.00,2748516.00,0.00,'2023-01-08 11:09:16'),(119,'8','214',1,'Sale Id shift 121',0.00,2310990.00,300.00,2310990.00,0.00,'2023-01-09 08:59:56'),(120,'8','214',1,'Sale Id shift 122',0.00,1922736.00,300.00,1922736.00,0.00,'2023-01-10 08:59:37'),(121,'8','214',1,'Sale Id shift 123',0.00,2784363.00,300.00,2784363.00,0.00,'2023-01-14 08:41:25'),(122,'8','214',1,'Sale Id shift 124',0.00,1589103.00,300.00,1589103.00,0.00,'2023-01-14 08:44:23'),(123,'8','214',1,'Sale Id shift 125',0.00,2088906.00,300.00,2088906.00,0.00,'2023-01-14 08:47:21'),(124,'8','214',1,'Sale Id shift 126',0.00,1395726.00,300.00,1395726.00,0.00,'2023-01-19 09:24:18'),(125,'8','214',1,'Sale Id shift 127',0.00,2505828.00,300.00,2505828.00,0.00,'2023-01-19 09:33:12'),(126,'8','214',1,'Sale Id shift 128',0.00,1472685.00,300.00,1472685.00,0.00,'2023-01-23 07:09:16'),(127,'8','214',1,'Sale Id shift 129',0.00,444315.06,300.00,435603.00,-8712.06,'2023-01-23 07:12:36'),(128,'8','214',1,'Sale Id shift 130',0.00,2379719.16,306.00,2379719.16,0.00,'2023-01-23 07:16:39'),(129,'8','214',1,'Sale Id shift 131',0.00,3154734.54,306.00,3154734.54,0.00,'2023-01-23 07:20:29'),(130,'8','214',1,'Sale Id shift 132',0.00,3101701.68,306.00,3101701.68,0.00,'2023-01-24 09:50:27'),(131,'8','214',1,'Sale Id shift 133',0.00,1443053.82,306.00,1306433.34,-136620.48,'2023-01-31 07:28:12'),(132,'8','214',1,'Sale Id shift 134',0.00,2154668.88,338.00,2154668.88,0.00,'2023-01-31 07:31:05'),(133,'8','214',1,'Sale Id shift 135',0.00,1847251.12,345.00,1885507.80,38256.68,'2023-02-01 10:00:31'),(134,'8','214',1,'Sale Id shift 136',0.00,899982.46,345.00,918621.15,18638.69,'2023-02-03 06:26:20'),(135,'8','214',1,'Sale Id shift 137',0.00,1658846.54,345.00,1693201.35,34354.81,'2023-02-03 07:00:38'),(136,'8','214',1,'Sale Id shift 138',0.00,1885813.54,345.00,1924868.85,39055.31,'2023-02-06 09:04:52'),(137,'8','214',1,'Sale Id shift 139',0.00,2116474.88,345.00,2160307.20,43832.32,'2023-02-06 09:25:35'),(138,'8','214',1,'Sale Id shift 140',0.00,2003136.72,345.00,2044621.80,41485.08,'2023-02-07 09:23:12'),(139,'8','214',1,'Sale Id shift 141',0.00,1694333.16,345.00,1729422.90,35089.74,'2023-02-08 08:49:35'),(140,'8','214',1,'Sale Id shift 142',0.00,2638346.88,345.00,2692987.20,54640.32,'2023-02-10 07:47:08'),(141,'8','214',1,'Sale Id shift 143',0.00,2314360.05,345.00,2314360.05,0.00,'2023-02-10 07:57:16'),(142,'8','214',1,'Sale Id shift 144',0.00,2771933.55,345.00,2771933.55,0.00,'2023-02-10 15:37:37'),(143,'8','214',1,'Sale Id shift 145',0.00,2557112.40,345.00,2557112.40,0.00,'2023-02-11 16:22:26'),(144,'8','214',1,'Sale Id shift 146',0.00,2322629.70,345.00,2322629.70,0.00,'2023-02-18 10:51:26'),(145,'8','214',1,'Sale Id shift 147',0.00,1365555.60,345.00,1385637.30,20081.70,'2023-02-18 10:57:49'),(146,'8','214',1,'Sale Id shift 148',0.00,1938809.20,340.00,1938809.20,0.00,'2023-02-18 11:04:00'),(147,'8','214',1,'Sale Id shift 149',0.00,2008862.80,340.00,2008862.80,0.00,'2023-02-19 09:05:55'),(148,'8','214',1,'Sale Id shift 150',0.00,1931880.00,340.00,1931880.00,0.00,'2023-02-20 18:04:32'),(149,'8','214',1,'Sale Id shift 151',0.00,1049247.00,340.00,1189146.60,139899.60,'2023-02-24 08:44:45'),(150,'8','214',1,'Sale Id shift 152',0.00,1779813.00,300.00,1779813.00,0.00,'2023-02-24 08:52:19'),(151,'8','214',1,'Sale Id shift 153',0.00,2229936.00,300.00,2229936.00,0.00,'2023-02-24 08:58:26'),(152,'8','214',1,'Sale Id shift 154',0.00,1845393.00,300.00,1845393.00,0.00,'2023-02-26 11:15:27'),(153,'8','214',1,'Sale Id shift 155',0.00,2285397.00,300.00,2285397.00,0.00,'2023-03-01 09:17:35'),(154,'8','214',1,'Sale Id shift 156',0.00,1703271.00,300.00,1703271.00,0.00,'2023-03-01 09:23:55'),(155,'8','214',1,'Sale Id shift 157',0.00,3592485.00,300.00,3592485.00,0.00,'2023-03-02 09:33:27'),(156,'8','214',1,'Sale Id shift 158',0.00,1643037.00,300.00,1643037.00,0.00,'2023-03-02 09:38:02'),(157,'8','214',1,'Sale Id shift 159',0.00,1755867.00,300.00,1755867.00,0.00,'2023-03-03 20:34:28'),(158,'8','214',1,'Sale Id shift 160',0.00,2225586.00,300.00,2225586.00,0.00,'2023-03-04 09:29:19'),(159,'8','214',1,'Sale Id shift 161',0.00,2023503.00,300.00,2023503.00,0.00,'2023-03-05 18:59:41'),(160,'8','214',1,'Sale Id shift 162',0.00,1554339.00,300.00,1554339.00,0.00,'2023-03-08 09:04:47'),(161,'8','214',1,'Sale Id shift 163',0.00,1727094.00,300.00,1727094.00,0.00,'2023-03-08 09:12:39'),(162,'8','214',1,'Sale Id shift 164',0.00,2955081.00,300.00,2955081.00,0.00,'2023-03-09 13:34:21'),(163,'8','214',1,'Sale Id shift 165',0.00,1382328.00,300.00,1382328.00,0.00,'2023-03-09 13:37:31'),(164,'8','214',1,'Sale Id shift 166',0.00,981882.00,300.00,981882.00,0.00,'2023-03-14 08:27:04'),(165,'8','214',1,'Sale Id shift 167',0.00,1807320.00,300.00,1807320.00,0.00,'2023-03-14 08:39:32'),(166,'8','214',1,'Sale Id shift 168',0.00,1543785.00,300.00,1543785.00,0.00,'2023-03-14 09:01:17'),(167,'8','214',1,'Sale Id shift 169',0.00,1540365.00,300.00,1540365.00,0.00,'2023-03-16 09:37:06');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=740 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('8','214',1,'','24','7',0.00,11825000.00,'Purchase Id 1 for 55,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-10 09:40:30','',''),('8','214',2,'','supplier','1',11825000.00,0.00,'Purchase Id 1 for 55,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-10 09:40:30','',''),('8','214',3,'','20','4',2367562.80,0.00,'Sales from shift 2 on 2022-08-10 09:42:03 ','2022-08-10 09:42:03','',''),('8','214',4,'','6.1','5',0.00,2367562.80,'Sales from shift 2 on 2022-08-10 09:42:03 ','2022-08-10 09:42:03','',''),('8','214',5,'','2','1',2367670.00,0.00,'Payment Id 1 for invoice:2, receipt: 01 by Lausu Energy Resources','2022-08-11 17:37:14','',''),('8','214',6,'','supplier','1',0.00,2367670.00,'Payment Id 1 for invoice:2, receipt: 01 by Lausu Energy Resources','2022-08-11 17:37:14','',''),('8','214',7,'','2','1',1226095.00,0.00,'Payment Id 2 for invoice:3, receipt: 02 by Lausu Energy Resources','2022-08-11 22:48:56','',''),('8','214',8,'','supplier','1',0.00,1226095.00,'Payment Id 2 for invoice:3, receipt: 02 by Lausu Energy Resources','2022-08-11 22:48:56','',''),('8','214',9,'','20','4',1226095.55,0.00,'Sales from shift 3 on 2022-08-12 14:11:38 ','2022-08-12 14:11:38','',''),('8','214',10,'','6.1','5',0.00,1226095.55,'Sales from shift 3 on 2022-08-12 14:11:38 ','2022-08-12 14:11:38','',''),('8','214',11,'','20','4',1199143.15,0.00,'Sales from shift 4 on 2022-08-12 22:04:46 ','2022-08-12 22:04:46','',''),('8','214',12,'','6.1','5',0.00,1199143.15,'Sales from shift 4 on 2022-08-12 22:04:46 ','2022-08-12 22:04:46','',''),('8','214',13,'','24','7',0.00,10621000.00,'Purchase Id 2 for 49,400.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-13 21:17:58','',''),('8','214',14,'','supplier','1',10621000.00,0.00,'Purchase Id 2 for 49,400.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-13 21:17:58','',''),('8','214',15,'','20','4',1230257.95,0.00,'Sales from shift 5 on 2022-08-13 21:58:02 ','2022-08-13 21:58:02','',''),('8','214',16,'','6.1','5',0.00,1230257.95,'Sales from shift 5 on 2022-08-13 21:58:02 ','2022-08-13 21:58:02','',''),('8','214',17,'','20','4',1111472.60,0.00,'Sales from shift 6 on 2022-08-14 09:51:43 ','2022-08-14 09:51:43','',''),('8','214',18,'','6.1','5',0.00,1111472.60,'Sales from shift 6 on 2022-08-14 09:51:43 ','2022-08-14 09:51:43','',''),('8','214',19,'','2','1',1230255.00,0.00,'Payment Id 4 for invoice:4, receipt: 04 by Lausu Energy Resources','2022-08-14 09:53:27','',''),('8','214',20,'','supplier','1',0.00,1230255.00,'Payment Id 4 for invoice:4, receipt: 04 by Lausu Energy Resources','2022-08-14 09:53:27','',''),('8','214',21,'','2','1',1199140.00,0.00,'Payment Id 3 for invoice:4, receipt: 03 by Lausu Energy Resources','2022-08-14 09:53:57','',''),('8','214',22,'','supplier','1',0.00,1199140.00,'Payment Id 3 for invoice:4, receipt: 03 by Lausu Energy Resources','2022-08-14 09:53:57','',''),('8','214',23,'','20','4',1086545.50,0.00,'Sales from shift 7 on 2022-08-16 09:40:52 ','2022-08-16 09:40:52','',''),('8','214',24,'','6.1','5',0.00,1086545.50,'Sales from shift 7 on 2022-08-16 09:40:52 ','2022-08-16 09:40:52','',''),('8','214',25,'','20','4',1160890.35,0.00,'Sales from shift 8 on 2022-08-20 10:14:30 ','2022-08-20 10:14:30','',''),('8','214',26,'','6.1','5',0.00,1160890.35,'Sales from shift 8 on 2022-08-20 10:14:30 ','2022-08-20 10:14:30','',''),('8','214',27,'','20','4',1370785.05,0.00,'Sales from shift 9 on 2022-08-20 10:19:27 ','2022-08-20 10:19:27','',''),('8','214',28,'','6.1','5',0.00,1370785.05,'Sales from shift 9 on 2022-08-20 10:19:27 ','2022-08-20 10:19:27','',''),('8','214',29,'','20','4',1025099.19,0.00,'Sales from shift 10 on 2022-08-20 10:26:38 ','2022-08-20 10:26:38','',''),('8','214',30,'','6.1','5',0.00,1025099.19,'Sales from shift 10 on 2022-08-20 10:26:38 ','2022-08-20 10:26:38','',''),('8','214',31,'','20','4',1142561.34,0.00,'Sales from shift 11 on 2022-08-20 10:34:14 ','2022-08-20 10:34:14','',''),('8','214',32,'','6.1','5',0.00,1142561.34,'Sales from shift 11 on 2022-08-20 10:34:14 ','2022-08-20 10:34:14','',''),('8','214',33,'','20','4',885078.18,0.00,'Sales from shift 12 on 2022-08-20 10:54:48 ','2022-08-20 10:54:48','',''),('8','214',34,'','6.1','5',0.00,885078.18,'Sales from shift 12 on 2022-08-20 10:54:48 ','2022-08-20 10:54:48','',''),('8','214',35,'','24','7',0.00,3487950.00,'Purchase Id 3 for 16,850.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-21 08:12:15','',''),('8','214',36,'','supplier','1',3487950.00,0.00,'Purchase Id 3 for 16,850.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-21 08:12:15','',''),('8','214',37,'','supplier','1',0.00,3487950.00,'Purchase Id 3 for 16,850.00 litters of Petrol - PMS returned to Lausu Energy Resources','2022-08-21 08:33:57','',''),('8','214',38,'','20','4',1098300.60,0.00,'Sales from shift 13 on 2022-08-21 19:33:22 ','2022-08-21 19:33:22','',''),('8','214',39,'','6.1','5',0.00,1098300.60,'Sales from shift 13 on 2022-08-21 19:33:22 ','2022-08-21 19:33:22','',''),('8','214',40,'','20','4',1212602.00,0.00,'Sales from shift 14 on 2022-08-23 07:43:47 ','2022-08-23 07:43:47','',''),('8','214',41,'','6.1','5',0.00,1212602.00,'Sales from shift 14 on 2022-08-23 07:43:47 ','2022-08-23 07:43:47','',''),('8','214',42,'','20','4',885634.00,0.00,'Sales from shift 15 on 2022-08-23 11:53:34 ','2022-08-23 11:53:34','',''),('8','214',43,'','6.1','5',0.00,885634.00,'Sales from shift 15 on 2022-08-23 11:53:34 ','2022-08-23 11:53:34','',''),('8','214',44,'','2','1',1111145.00,0.00,'Payment Id 5 for invoice:6, receipt: 05 by Lausu Energy Resources','2022-08-23 14:00:05','',''),('8','214',45,'','supplier','1',0.00,1111145.00,'Payment Id 5 for invoice:6, receipt: 05 by Lausu Energy Resources','2022-08-23 14:00:05','',''),('8','214',46,'','2','1',1086545.00,0.00,'Payment Id 6 for invoice:7, receipt: 06 by Lausu Energy Resources','2022-08-23 14:00:37','',''),('8','214',47,'','supplier','1',0.00,1086545.00,'Payment Id 6 for invoice:7, receipt: 06 by Lausu Energy Resources','2022-08-23 14:00:37','',''),('8','214',48,'','2','1',1212650.00,0.00,'Payment Id 13 for invoice:14, receipt: 10 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',49,'','supplier','1',0.00,1212650.00,'Payment Id 13 for invoice:14, receipt: 10 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',50,'','2','1',1098300.00,0.00,'Payment Id 12 for invoice:13, receipt: 10 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',51,'','supplier','1',0.00,1098300.00,'Payment Id 12 for invoice:13, receipt: 10 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',52,'','2','1',885080.00,0.00,'Payment Id 11 for invoice:13, receipt: 09 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',53,'','supplier','1',0.00,885080.00,'Payment Id 11 for invoice:13, receipt: 09 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',54,'','2','1',1142560.00,0.00,'Payment Id 10 for invoice:11, receipt: 09 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',55,'','supplier','1',0.00,1142560.00,'Payment Id 10 for invoice:11, receipt: 09 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',56,'','2','1',1025100.00,0.00,'Payment Id 9 for invoice:10, receipt: 08 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',57,'','supplier','1',0.00,1025100.00,'Payment Id 9 for invoice:10, receipt: 08 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',58,'','2','1',1370785.00,0.00,'Payment Id 8 for invoice:9, receipt: 07 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',59,'','supplier','1',0.00,1370785.00,'Payment Id 8 for invoice:9, receipt: 07 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',60,'','2','1',1160890.00,0.00,'Payment Id 7 for invoice:8, receipt: 07 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',61,'','supplier','1',0.00,1160890.00,'Payment Id 7 for invoice:8, receipt: 07 by Lausu Energy Resources','2022-08-23 14:02:31','',''),('8','214',62,'','24','7',0.00,3400000.00,'Purchase Id 4 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-23 15:11:28','',''),('8','214',63,'','supplier','1',3400000.00,0.00,'Purchase Id 4 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-23 15:11:28','',''),('8','214',64,'','20','4',1395598.00,0.00,'Sales from shift 16 on 2022-08-24 17:30:40 ','2022-08-24 17:30:40','',''),('8','214',65,'','6.1','5',0.00,1395598.00,'Sales from shift 16 on 2022-08-24 17:30:40 ','2022-08-24 17:30:40','',''),('8','214',66,'','20','4',892374.90,0.00,'Sales from shift 17 on 2022-08-25 07:41:27 ','2022-08-25 07:41:27','',''),('8','214',67,'','6.1','5',0.00,892374.90,'Sales from shift 17 on 2022-08-25 07:41:27 ','2022-08-25 07:41:27','',''),('8','214',68,'','2','1',892375.00,0.00,'Payment Id 16 for invoice:17, receipt: 11 by Lausu Energy Resources','2022-08-25 15:14:31','',''),('8','214',69,'','supplier','1',0.00,892375.00,'Payment Id 16 for invoice:17, receipt: 11 by Lausu Energy Resources','2022-08-25 15:14:31','',''),('8','214',70,'','2','1',1395600.00,0.00,'Payment Id 15 for invoice:16, receipt: 11 by Lausu Energy Resources','2022-08-25 15:14:31','',''),('8','214',71,'','supplier','1',0.00,1395600.00,'Payment Id 15 for invoice:16, receipt: 11 by Lausu Energy Resources','2022-08-25 15:14:31','',''),('8','214',72,'','20','4',982714.20,0.00,'Sales from shift 18 on 2022-08-26 08:05:08 ','2022-08-26 08:05:08','',''),('8','214',73,'','6.1','5',0.00,982714.20,'Sales from shift 18 on 2022-08-26 08:05:08 ','2022-08-26 08:05:08','',''),('8','214',74,'','20','4',1179388.90,0.00,'Sales from shift 19 on 2022-08-28 15:36:06 ','2022-08-28 15:36:06','',''),('8','214',75,'','6.1','5',0.00,1179388.90,'Sales from shift 19 on 2022-08-28 15:36:06 ','2022-08-28 15:36:06','',''),('8','214',76,'','24','7',0.00,3487950.00,'Purchase Id 5 for 16,850.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-28 17:21:53','',''),('8','214',77,'','supplier','1',3487950.00,0.00,'Purchase Id 5 for 16,850.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-28 17:21:53','',''),('8','214',78,'','20','4',1155880.20,0.00,'Sales from shift 20 on 2022-08-28 18:58:47 ','2022-08-28 18:58:47','',''),('8','214',79,'','6.1','5',0.00,1155880.20,'Sales from shift 20 on 2022-08-28 18:58:47 ','2022-08-28 18:58:47','',''),('8','214',80,'','20','4',1081008.80,0.00,'Sales from shift 21 on 2022-08-29 08:16:27 ','2022-08-29 08:16:27','',''),('8','214',81,'','6.1','5',0.00,1081008.80,'Sales from shift 21 on 2022-08-29 08:16:27 ','2022-08-29 08:16:27','',''),('8','214',82,'','2','1',1081010.00,0.00,'Payment Id 22 for invoice:21, receipt: 15 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',83,'','supplier','1',0.00,1081010.00,'Payment Id 22 for invoice:21, receipt: 15 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',84,'','2','1',1155880.00,0.00,'Payment Id 20 for invoice:20, receipt: 14 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',85,'','supplier','1',0.00,1155880.00,'Payment Id 20 for invoice:20, receipt: 14 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',86,'','2','1',1179390.00,0.00,'Payment Id 18 for invoice:19, receipt: 13 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',87,'','supplier','1',0.00,1179390.00,'Payment Id 18 for invoice:19, receipt: 13 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',88,'','2','1',982715.00,0.00,'Payment Id 17 for invoice:18, receipt: 12 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',89,'','supplier','1',0.00,982715.00,'Payment Id 17 for invoice:18, receipt: 12 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',90,'','2','1',885650.00,0.00,'Payment Id 14 for invoice:15, receipt: 10 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',91,'','supplier','1',0.00,885650.00,'Payment Id 14 for invoice:15, receipt: 10 by Lausu Energy Resources','2022-08-29 22:17:24','',''),('8','214',92,'','20','4',1079319.70,0.00,'Sales from shift 22 on 2022-08-30 08:01:04 ','2022-08-30 08:01:04','',''),('8','214',93,'','6.1','5',0.00,1079319.70,'Sales from shift 22 on 2022-08-30 08:01:04 ','2022-08-30 08:01:04','',''),('8','214',94,'','24','7',0.00,9462000.00,'Purchase Id 6 for 49,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-30 13:43:48','',''),('8','214',95,'','supplier','1',9462000.00,0.00,'Purchase Id 6 for 49,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-30 13:43:48','',''),('8','214',96,'','20','4',2764154.20,0.00,'Sales from shift 23 on 2022-08-31 08:00:18 ','2022-08-31 08:00:18','',''),('8','214',97,'','6.1','5',0.00,2764154.20,'Sales from shift 23 on 2022-08-31 08:00:18 ','2022-08-31 08:00:18','',''),('8','214',98,'','2','1',2764155.00,0.00,'Payment Id 24 for invoice:23, receipt: 16 by Lausu Energy Resources','2022-09-01 15:44:53','',''),('8','214',99,'','supplier','1',0.00,2764155.00,'Payment Id 24 for invoice:23, receipt: 16 by Lausu Energy Resources','2022-09-01 15:44:53','',''),('8','214',100,'','2','1',1079320.00,0.00,'Payment Id 23 for invoice:22, receipt: 16 by Lausu Energy Resources','2022-09-01 15:45:37','',''),('8','214',101,'','supplier','1',0.00,1079320.00,'Payment Id 23 for invoice:22, receipt: 16 by Lausu Energy Resources','2022-09-01 15:45:37','',''),('8','214',102,'','24','7',0.00,3420000.00,'Purchase Id 7 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-01 15:59:53','',''),('8','214',103,'','supplier','1',3420000.00,0.00,'Purchase Id 7 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-01 15:59:53','',''),('8','214',104,'','20','4',1047895.60,0.00,'Sales from shift 24 on 2022-09-02 10:11:15 ','2022-09-02 10:11:15','',''),('8','214',105,'','6.1','5',0.00,1047895.60,'Sales from shift 24 on 2022-09-02 10:11:15 ','2022-09-02 10:11:15','',''),('8','214',106,'','20','4',1155581.90,0.00,'Sales from shift 25 on 2022-09-02 10:16:52 ','2022-09-02 10:16:52','',''),('8','214',107,'','6.1','5',0.00,1155581.90,'Sales from shift 25 on 2022-09-02 10:16:52 ','2022-09-02 10:16:52','',''),('8','214',108,'','20','4',1318926.80,0.00,'Sales from shift 26 on 2022-09-03 08:40:24 ','2022-09-03 08:40:24','',''),('8','214',109,'','6.1','5',0.00,1318926.80,'Sales from shift 26 on 2022-09-03 08:40:24 ','2022-09-03 08:40:24','',''),('8','214',110,'','20','4',1282501.90,0.00,'Sales from shift 27 on 2022-09-04 08:32:06 ','2022-09-04 08:32:06','',''),('8','214',111,'','6.1','5',0.00,1282501.90,'Sales from shift 27 on 2022-09-04 08:32:06 ','2022-09-04 08:32:06','',''),('8','214',112,'','2','1',1282500.00,0.00,'Payment Id 28 for invoice:27, receipt: 19 by Lausu Energy Resources','2022-09-04 19:45:09','',''),('8','214',113,'','supplier','1',0.00,1282500.00,'Payment Id 28 for invoice:27, receipt: 19 by Lausu Energy Resources','2022-09-04 19:45:09','',''),('8','214',114,'','2','1',1155580.00,0.00,'Payment Id 26 for invoice:26, receipt: 18 by Lausu Energy Resources','2022-09-04 19:45:09','',''),('8','214',115,'','supplier','1',0.00,1155580.00,'Payment Id 26 for invoice:26, receipt: 18 by Lausu Energy Resources','2022-09-04 19:45:09','',''),('8','214',116,'','2','1',1047895.00,0.00,'Payment Id 25 for invoice:24, receipt: 17 by Lausu Energy Resources','2022-09-04 19:45:09','',''),('8','214',117,'','supplier','1',0.00,1047895.00,'Payment Id 25 for invoice:24, receipt: 17 by Lausu Energy Resources','2022-09-04 19:45:09','',''),('8','214',118,'','2','1',1318930.00,0.00,'Payment Id 27 for invoice:26, receipt: 18 by Lausu Energy Resources','2022-09-04 19:45:18','',''),('8','214',119,'','supplier','1',0.00,1318930.00,'Payment Id 27 for invoice:26, receipt: 18 by Lausu Energy Resources','2022-09-04 19:45:18','',''),('8','214',120,'','20','4',880862.80,0.00,'Sales from shift 28 on 2022-09-05 07:56:18 ','2022-09-05 07:56:18','',''),('8','214',121,'','6.1','5',0.00,880862.80,'Sales from shift 28 on 2022-09-05 07:56:18 ','2022-09-05 07:56:18','',''),('8','214',122,'','20','4',823047.70,0.00,'Sales from shift 29 on 2022-09-06 07:52:35 ','2022-09-06 07:52:35','',''),('8','214',123,'','6.1','5',0.00,823047.70,'Sales from shift 29 on 2022-09-06 07:52:35 ','2022-09-06 07:52:35','',''),('8','214',124,'','24','7',0.00,6270000.00,'Purchase Id 8 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-06 17:56:36','',''),('8','214',125,'','supplier','1',6270000.00,0.00,'Purchase Id 8 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-06 17:56:36','',''),('8','214',126,'','20','4',1866998.90,0.00,'Sales from shift 30 on 2022-09-07 08:17:22 ','2022-09-07 08:17:22','',''),('8','214',127,'','6.1','5',0.00,1866998.90,'Sales from shift 30 on 2022-09-07 08:17:22 ','2022-09-07 08:17:22','',''),('8','214',128,'','20','4',671399.20,0.00,'Sales from shift 31 on 2022-09-08 08:23:57 ','2022-09-08 08:23:57','',''),('8','214',129,'','6.1','5',0.00,671399.20,'Sales from shift 31 on 2022-09-08 08:23:57 ','2022-09-08 08:23:57','',''),('8','214',130,'','2','1',880865.00,0.00,'Payment Id 29 for invoice:28, receipt: 19 by Lausu Energy Resources','2022-09-08 13:31:57','',''),('8','214',131,'','supplier','1',0.00,880865.00,'Payment Id 29 for invoice:28, receipt: 19 by Lausu Energy Resources','2022-09-08 13:31:57','',''),('8','214',132,'','2','1',823050.00,0.00,'Payment Id 30 for invoice:29, receipt: 20 by Lausu Energy Resources','2022-09-08 13:32:14','',''),('8','214',133,'','supplier','1',0.00,823050.00,'Payment Id 30 for invoice:29, receipt: 20 by Lausu Energy Resources','2022-09-08 13:32:14','',''),('8','214',134,'','2','1',1867000.00,0.00,'Payment Id 31 for invoice:30, receipt: 20 by Lausu Energy Resources','2022-09-08 13:32:30','',''),('8','214',135,'','supplier','1',0.00,1867000.00,'Payment Id 31 for invoice:30, receipt: 20 by Lausu Energy Resources','2022-09-08 13:32:30','',''),('8','214',136,'','20','4',854454.70,0.00,'Sales from shift 32 on 2022-09-09 08:42:32 ','2022-09-09 08:42:32','',''),('8','214',137,'','6.1','5',0.00,854454.70,'Sales from shift 32 on 2022-09-09 08:42:32 ','2022-09-09 08:42:32','',''),('8','214',138,'','20','4',572090.00,0.00,'Sales from shift 33 on 2022-09-10 07:46:45 ','2022-09-10 07:46:45','',''),('8','214',139,'','6.1','5',0.00,572090.00,'Sales from shift 33 on 2022-09-10 07:46:45 ','2022-09-10 07:46:45','',''),('8','214',140,'','20','4',589792.30,0.00,'Sales from shift 34 on 2022-09-11 08:21:50 ','2022-09-11 08:21:50','',''),('8','214',141,'','6.1','5',0.00,589792.30,'Sales from shift 34 on 2022-09-11 08:21:50 ','2022-09-11 08:21:50','',''),('8','214',142,'','20','4',662771.30,0.00,'Sales from shift 35 on 2022-09-12 07:51:37 ','2022-09-12 07:51:37','',''),('8','214',143,'','6.1','5',0.00,662771.30,'Sales from shift 35 on 2022-09-12 07:51:37 ','2022-09-12 07:51:37','',''),('8','214',144,'','20','4',1301220.70,0.00,'Sales from shift 36 on 2022-09-13 09:48:36 ','2022-09-13 09:48:36','',''),('8','214',145,'','6.1','5',0.00,1301220.70,'Sales from shift 36 on 2022-09-13 09:48:36 ','2022-09-13 09:48:36','',''),('8','214',146,'','20','4',2914252.30,0.00,'Sales from shift 37 on 2022-09-14 08:17:15 ','2022-09-14 08:17:15','',''),('8','214',147,'','6.1','5',0.00,2914252.30,'Sales from shift 37 on 2022-09-14 08:17:15 ','2022-09-14 08:17:15','',''),('8','214',148,'','2','1',589790.00,0.00,'Payment Id 35 for invoice:34, receipt: 024 by Lausu Energy Resources','2022-09-14 21:41:59','',''),('8','214',149,'','supplier','1',0.00,589790.00,'Payment Id 35 for invoice:34, receipt: 024 by Lausu Energy Resources','2022-09-14 21:41:59','',''),('8','214',150,'','2','1',572090.00,0.00,'Payment Id 34 for invoice:33, receipt: 023 by Lausu Energy Resources','2022-09-14 21:41:59','',''),('8','214',151,'','supplier','1',0.00,572090.00,'Payment Id 34 for invoice:33, receipt: 023 by Lausu Energy Resources','2022-09-14 21:41:59','',''),('8','214',152,'','2','1',854455.00,0.00,'Payment Id 33 for invoice:32, receipt: 022 by Lausu Energy Resources','2022-09-14 21:41:59','',''),('8','214',153,'','supplier','1',0.00,854455.00,'Payment Id 33 for invoice:32, receipt: 022 by Lausu Energy Resources','2022-09-14 21:41:59','',''),('8','214',154,'','2','1',671400.00,0.00,'Payment Id 32 for invoice:31, receipt: 021 by Lausu Energy Resources','2022-09-14 21:41:59','',''),('8','214',155,'','supplier','1',0.00,671400.00,'Payment Id 32 for invoice:31, receipt: 021 by Lausu Energy Resources','2022-09-14 21:41:59','',''),('8','214',156,'','2','1',1301220.00,0.00,'Payment Id 37 for invoice:36, receipt:  by Lausu Energy Resources','2022-09-14 21:42:46','',''),('8','214',157,'','supplier','1',0.00,1301220.00,'Payment Id 37 for invoice:36, receipt:  by Lausu Energy Resources','2022-09-14 21:42:46','',''),('8','214',158,'','2','1',662770.00,0.00,'Payment Id 36 for invoice:35, receipt: 025 by Lausu Energy Resources','2022-09-14 21:42:46','',''),('8','214',159,'','supplier','1',0.00,662770.00,'Payment Id 36 for invoice:35, receipt: 025 by Lausu Energy Resources','2022-09-14 21:42:46','',''),('8','214',160,'','24','7',0.00,9481000.00,'Purchase Id 9 for 49,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-14 21:57:34','',''),('8','214',161,'','supplier','1',9481000.00,0.00,'Purchase Id 9 for 49,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-14 21:57:34','',''),('8','214',162,'','20','4',944529.90,0.00,'Sales from shift 38 on 2022-09-15 07:52:57 ','2022-09-15 07:52:57','',''),('8','214',163,'','6.1','5',0.00,944529.90,'Sales from shift 38 on 2022-09-15 07:52:57 ','2022-09-15 07:52:57','',''),('8','214',164,'','20','4',1135006.80,0.00,'Sales from shift 39 on 2022-09-16 15:28:32 ','2022-09-16 15:28:32','',''),('8','214',165,'','6.1','5',0.00,1135006.80,'Sales from shift 39 on 2022-09-16 15:28:32 ','2022-09-16 15:28:32','',''),('8','214',166,'','2','1',944530.00,0.00,'Payment Id 39 for invoice:38, receipt: 026 by Lausu Energy Resources','2022-09-17 07:43:15','',''),('8','214',167,'','supplier','1',0.00,944530.00,'Payment Id 39 for invoice:38, receipt: 026 by Lausu Energy Resources','2022-09-17 07:43:15','',''),('8','214',168,'','2','1',2914250.00,0.00,'Payment Id 38 for invoice:37, receipt: 024 by Lausu Energy Resources','2022-09-17 07:52:43','',''),('8','214',169,'','supplier','1',0.00,2914250.00,'Payment Id 38 for invoice:37, receipt: 024 by Lausu Energy Resources','2022-09-17 07:52:43','',''),('8','214',170,'','20','4',1168192.20,0.00,'Sales from shift 40 on 2022-09-17 08:10:58 ','2022-09-17 08:10:58','',''),('8','214',171,'','6.1','5',0.00,1168192.20,'Sales from shift 40 on 2022-09-17 08:10:58 ','2022-09-17 08:10:58','',''),('8','214',172,'','20','4',1191094.80,0.00,'Sales from shift 41 on 2022-09-18 09:45:08 ','2022-09-18 09:45:08','',''),('8','214',173,'','6.1','5',0.00,1191094.80,'Sales from shift 41 on 2022-09-18 09:45:08 ','2022-09-18 09:45:08','',''),('8','214',174,'','20','4',1321079.50,0.00,'Sales from shift 42 on 2022-09-20 08:25:26 ','2022-09-20 08:25:26','',''),('8','214',175,'','6.1','5',0.00,1321079.50,'Sales from shift 42 on 2022-09-20 08:25:26 ','2022-09-20 08:25:26','',''),('8','214',176,'','20','4',1134590.70,0.00,'Sales from shift 43 on 2022-09-20 08:30:29 ','2022-09-20 08:30:29','',''),('8','214',177,'','6.1','5',0.00,1134590.70,'Sales from shift 43 on 2022-09-20 08:30:29 ','2022-09-20 08:30:29','',''),('8','214',178,'','24','7',0.00,3230000.00,'Purchase Id 10 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-20 12:26:01','',''),('8','214',179,'','supplier','1',3230000.00,0.00,'Purchase Id 10 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-20 12:26:01','',''),('8','214',180,'','20','4',2652852.20,0.00,'Sales from shift 44 on 2022-09-21 08:47:24 ','2022-09-21 08:47:24','',''),('8','214',181,'','6.1','5',0.00,2652852.20,'Sales from shift 44 on 2022-09-21 08:47:24 ','2022-09-21 08:47:24','',''),('8','214',182,'','2','1',1321080.00,0.00,'Payment Id 43 for invoice:42, receipt: 028 by Lausu Energy Resources','2022-09-21 14:53:57','',''),('8','214',183,'','supplier','1',0.00,1321080.00,'Payment Id 43 for invoice:42, receipt: 028 by Lausu Energy Resources','2022-09-21 14:53:57','',''),('8','214',184,'','2','1',1191095.00,0.00,'Payment Id 42 for invoice:41, receipt: 026 by Lausu Energy Resources','2022-09-21 14:53:57','',''),('8','214',185,'','supplier','1',0.00,1191095.00,'Payment Id 42 for invoice:41, receipt: 026 by Lausu Energy Resources','2022-09-21 14:53:57','',''),('8','214',186,'','2','1',1168190.00,0.00,'Payment Id 41 for invoice:40, receipt: 027 by Lausu Energy Resources','2022-09-21 14:53:57','',''),('8','214',187,'','supplier','1',0.00,1168190.00,'Payment Id 41 for invoice:40, receipt: 027 by Lausu Energy Resources','2022-09-21 14:53:57','',''),('8','214',188,'','2','1',1135000.00,0.00,'Payment Id 40 for invoice:39, receipt: 027 by Lausu Energy Resources','2022-09-21 14:53:57','',''),('8','214',189,'','supplier','1',0.00,1135000.00,'Payment Id 40 for invoice:39, receipt: 027 by Lausu Energy Resources','2022-09-21 14:53:57','',''),('8','214',190,'','2','1',1134590.00,0.00,'Payment Id 44 for invoice:43, receipt: 029 by Lausu Energy Resources','2022-09-21 14:54:21','',''),('8','214',191,'','supplier','1',0.00,1134590.00,'Payment Id 44 for invoice:43, receipt: 029 by Lausu Energy Resources','2022-09-21 14:54:21','',''),('8','214',192,'','20','4',1141702.40,0.00,'Sales from shift 45 on 2022-09-22 09:08:48 ','2022-09-22 09:08:48','',''),('8','214',193,'','6.1','5',0.00,1141702.40,'Sales from shift 45 on 2022-09-22 09:08:48 ','2022-09-22 09:08:48','',''),('8','214',194,'','20','4',1211793.40,0.00,'Sales from shift 46 on 2022-09-23 08:03:22 ','2022-09-23 08:03:22','',''),('8','214',195,'','6.1','5',0.00,1211793.40,'Sales from shift 46 on 2022-09-23 08:03:22 ','2022-09-23 08:03:22','',''),('8','214',196,'','24','7',0.00,9376500.00,'Purchase Id 11 for 49,350.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-23 08:24:08','',''),('8','214',197,'','supplier','1',9376500.00,0.00,'Purchase Id 11 for 49,350.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-23 08:24:08','',''),('8','214',198,'','20','4',1310044.30,0.00,'Sales from shift 47 on 2022-09-24 08:35:59 ','2022-09-24 08:35:59','',''),('8','214',199,'','6.1','5',0.00,1310044.30,'Sales from shift 47 on 2022-09-24 08:35:59 ','2022-09-24 08:35:59','',''),('8','214',200,'','20','4',1381161.30,0.00,'Sales from shift 48 on 2022-09-25 10:49:14 ','2022-09-25 10:49:14','',''),('8','214',201,'','6.1','5',0.00,1381161.30,'Sales from shift 48 on 2022-09-25 10:49:14 ','2022-09-25 10:49:14','',''),('8','214',202,'','20','4',1385464.80,0.00,'Sales from shift 49 on 2022-09-26 12:27:45 ','2022-09-26 12:27:45','',''),('8','214',203,'','6.1','5',0.00,1385464.80,'Sales from shift 49 on 2022-09-26 12:27:45 ','2022-09-26 12:27:45','',''),('8','214',204,'','20','4',1313542.20,0.00,'Sales from shift 50 on 2022-09-27 08:12:14 ','2022-09-27 08:12:14','',''),('8','214',205,'','6.1','5',0.00,1313542.20,'Sales from shift 50 on 2022-09-27 08:12:14 ','2022-09-27 08:12:14','',''),('8','214',206,'','20','4',3364012.70,0.00,'Sales from shift 51 on 2022-09-28 10:05:51 ','2022-09-28 10:05:51','',''),('8','214',207,'','6.1','5',0.00,3364012.70,'Sales from shift 51 on 2022-09-28 10:05:51 ','2022-09-28 10:05:51','',''),('8','214',208,'','24','7',0.00,3420000.00,'Purchase Id 12 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-28 10:08:27','',''),('8','214',209,'','supplier','1',3420000.00,0.00,'Purchase Id 12 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-28 10:08:27','',''),('8','214',210,'','2','1',1313540.00,0.00,'Payment Id 50 for invoice:50, receipt:  by Lausu Energy Resources','2022-09-28 13:45:30','',''),('8','214',211,'','supplier','1',0.00,1313540.00,'Payment Id 50 for invoice:50, receipt:  by Lausu Energy Resources','2022-09-28 13:45:30','',''),('8','214',212,'','2','1',1385465.00,0.00,'Payment Id 49 for invoice:49, receipt: 034 by Lausu Energy Resources','2022-09-28 13:45:30','',''),('8','214',213,'','supplier','1',0.00,1385465.00,'Payment Id 49 for invoice:49, receipt: 034 by Lausu Energy Resources','2022-09-28 13:45:30','',''),('8','214',214,'','2','1',1381160.00,0.00,'Payment Id 48 for invoice:48, receipt: 033 by Lausu Energy Resources','2022-09-28 13:45:30','',''),('8','214',215,'','supplier','1',0.00,1381160.00,'Payment Id 48 for invoice:48, receipt: 033 by Lausu Energy Resources','2022-09-28 13:45:30','',''),('8','214',216,'','2','1',1310045.00,0.00,'Payment Id 47 for invoice:47, receipt: 032 by Lausu Energy Resources','2022-09-28 13:45:30','',''),('8','214',217,'','supplier','1',0.00,1310045.00,'Payment Id 47 for invoice:47, receipt: 032 by Lausu Energy Resources','2022-09-28 13:45:30','',''),('8','214',218,'','2','1',1211780.00,0.00,'Payment Id 46 for invoice:46, receipt: 031 by Lausu Energy Resources','2022-09-28 13:47:00','',''),('8','214',219,'','supplier','1',0.00,1211780.00,'Payment Id 46 for invoice:46, receipt: 031 by Lausu Energy Resources','2022-09-28 13:47:00','',''),('8','214',220,'','2','1',2652850.00,0.00,'Payment Id 45 for invoice:44, receipt: 030 by Lausu Energy Resources','2022-09-28 13:47:00','',''),('8','214',221,'','supplier','1',0.00,2652850.00,'Payment Id 45 for invoice:44, receipt: 030 by Lausu Energy Resources','2022-09-28 13:47:00','',''),('8','214',222,'','20','4',873663.70,0.00,'Sales from shift 52 on 2022-09-29 10:53:26 ','2022-09-29 10:53:26','',''),('8','214',223,'','6.1','5',0.00,873663.70,'Sales from shift 52 on 2022-09-29 10:53:26 ','2022-09-29 10:53:26','',''),('8','214',224,'','2','1',3364010.00,0.00,'Payment Id 51 for invoice:51, receipt: 035 by Lausu Energy Resources','2022-09-29 22:06:56','',''),('8','214',225,'','supplier','1',0.00,3364010.00,'Payment Id 51 for invoice:51, receipt: 035 by Lausu Energy Resources','2022-09-29 22:06:56','',''),('8','214',226,'','20','4',668005.80,0.00,'Sales from shift 53 on 2022-09-30 07:52:33 ','2022-09-30 07:52:33','',''),('8','214',227,'','6.1','5',0.00,668005.80,'Sales from shift 53 on 2022-09-30 07:52:33 ','2022-09-30 07:52:33','',''),('8','214',228,'','20','4',835264.70,0.00,'Sales from shift 54 on 2022-10-01 07:08:04 ','2022-10-01 07:08:04','',''),('8','214',229,'','6.1','5',0.00,835264.70,'Sales from shift 54 on 2022-10-01 07:08:04 ','2022-10-01 07:08:04','',''),('8','214',230,'','20','4',872210.20,0.00,'Sales from shift 55 on 2022-10-02 08:47:01 ','2022-10-02 08:47:01','',''),('8','214',231,'','6.1','5',0.00,872210.20,'Sales from shift 55 on 2022-10-02 08:47:01 ','2022-10-02 08:47:01','',''),('8','214',232,'','20','4',720936.00,0.00,'Sales from shift 56 on 2022-10-03 06:28:23 ','2022-10-03 06:28:23','',''),('8','214',233,'','6.1','5',0.00,720936.00,'Sales from shift 56 on 2022-10-03 06:28:23 ','2022-10-03 06:28:23','',''),('8','214',234,'','20','4',302181.70,0.00,'Sales from shift 57 on 2022-10-03 10:49:50 ','2022-10-03 10:49:50','',''),('8','214',235,'','6.1','5',0.00,302181.70,'Sales from shift 57 on 2022-10-03 10:49:50 ','2022-10-03 10:49:50','',''),('8','214',236,'','2','1',872260.00,0.00,'Payment Id 55 for invoice:55, receipt: 040 by Lausu Energy Resources','2022-10-03 11:29:03','',''),('8','214',237,'','supplier','1',0.00,872260.00,'Payment Id 55 for invoice:55, receipt: 040 by Lausu Energy Resources','2022-10-03 11:29:03','',''),('8','214',238,'','2','1',835105.00,0.00,'Payment Id 54 for invoice:54, receipt: 039 by Lausu Energy Resources','2022-10-03 11:29:03','',''),('8','214',239,'','supplier','1',0.00,835105.00,'Payment Id 54 for invoice:54, receipt: 039 by Lausu Energy Resources','2022-10-03 11:29:03','',''),('8','214',240,'','2','1',668060.00,0.00,'Payment Id 53 for invoice:53, receipt: 038 by Lausu Energy Resources','2022-10-03 11:29:03','',''),('8','214',241,'','supplier','1',0.00,668060.00,'Payment Id 53 for invoice:53, receipt: 038 by Lausu Energy Resources','2022-10-03 11:29:03','',''),('8','214',242,'','2','1',873665.00,0.00,'Payment Id 52 for invoice:52, receipt: 037 by Lausu Energy Resources','2022-10-03 11:29:03','',''),('8','214',243,'','supplier','1',0.00,873665.00,'Payment Id 52 for invoice:52, receipt: 037 by Lausu Energy Resources','2022-10-03 11:29:03','',''),('8','214',244,'','20','4',391892.10,0.00,'Sales from shift 58 on 2022-10-04 15:04:19 ','2022-10-04 15:04:19','',''),('8','214',245,'','6.1','5',0.00,391892.10,'Sales from shift 58 on 2022-10-04 15:04:19 ','2022-10-04 15:04:19','',''),('8','214',246,'','2','1',720930.00,0.00,'Payment Id 57 for invoice:57, receipt: 041 by Lausu Energy Resources','2022-10-06 20:03:36','',''),('8','214',247,'','supplier','1',0.00,720930.00,'Payment Id 57 for invoice:57, receipt: 041 by Lausu Energy Resources','2022-10-06 20:03:36','',''),('8','214',248,'','2','1',302180.00,0.00,'Payment Id 58 for invoice:57, receipt: 042 by Lausu Energy Resources','2022-10-06 20:03:59','',''),('8','214',249,'','supplier','1',0.00,302180.00,'Payment Id 58 for invoice:57, receipt: 042 by Lausu Energy Resources','2022-10-06 20:03:59','',''),('8','214',250,'','24','7',0.00,3230000.00,'Purchase Id 13 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-07 11:17:42','',''),('8','214',251,'','supplier','1',3230000.00,0.00,'Purchase Id 13 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-07 11:17:42','',''),('8','214',252,'','20','4',0.00,0.00,'Sales from shift 59 on 2022-10-07 12:39:46 ','2022-10-07 12:39:46','',''),('8','214',253,'','6.1','5',0.00,0.00,'Sales from shift 59 on 2022-10-07 12:39:46 ','2022-10-07 12:39:46','',''),('8','214',254,'','20','4',0.00,0.00,'Sales from shift 60 on 2022-10-07 14:07:13 ','2022-10-07 14:07:13','',''),('8','214',255,'','6.1','5',0.00,0.00,'Sales from shift 60 on 2022-10-07 14:07:13 ','2022-10-07 14:07:13','',''),('8','214',256,'','20','4',1320300.50,0.00,'Sales from shift 61 on 2022-10-07 14:21:30 ','2022-10-07 14:21:30','',''),('8','214',257,'','6.1','5',0.00,1320300.50,'Sales from shift 61 on 2022-10-07 14:21:30 ','2022-10-07 14:21:30','',''),('8','214',258,'','20','4',207398.30,0.00,'Sales from shift 62 on 2022-10-07 14:28:01 ','2022-10-07 14:28:01','',''),('8','214',259,'','6.1','5',0.00,207398.30,'Sales from shift 62 on 2022-10-07 14:28:01 ','2022-10-07 14:28:01','',''),('8','214',260,'','20','4',588829.00,0.00,'Sales from shift 63 on 2022-10-08 10:13:13 ','2022-10-08 10:13:13','',''),('8','214',261,'','6.1','5',0.00,588829.00,'Sales from shift 63 on 2022-10-08 10:13:13 ','2022-10-08 10:13:13','',''),('8','214',262,'','2','1',207400.00,0.00,'Payment Id 63 for invoice:62, receipt: 05 by Lausu Energy Resources','2022-10-09 06:40:11','',''),('8','214',263,'','supplier','1',0.00,207400.00,'Payment Id 63 for invoice:62, receipt: 05 by Lausu Energy Resources','2022-10-09 06:40:11','',''),('8','214',264,'','2','1',1320300.00,0.00,'Payment Id 62 for invoice:61, receipt: 04 by Lausu Energy Resources','2022-10-09 06:40:11','',''),('8','214',265,'','supplier','1',0.00,1320300.00,'Payment Id 62 for invoice:61, receipt: 04 by Lausu Energy Resources','2022-10-09 06:40:11','',''),('8','214',266,'','2','1',2107925.00,0.00,'Payment Id 61 for invoice:61, receipt: 02 by Lausu Energy Resources','2022-10-09 06:40:11','',''),('8','214',267,'','supplier','1',0.00,2107925.00,'Payment Id 61 for invoice:61, receipt: 02 by Lausu Energy Resources','2022-10-09 06:40:11','',''),('8','214',268,'','2','1',391890.00,0.00,'Payment Id 60 for invoice:58, receipt: 01 by Lausu Energy Resources','2022-10-09 06:40:11','',''),('8','214',269,'','supplier','1',0.00,391890.00,'Payment Id 60 for invoice:58, receipt: 01 by Lausu Energy Resources','2022-10-09 06:40:11','',''),('8','214',270,'','20','4',1120354.97,0.00,'Sales from shift 64 on 2022-10-09 08:25:53 ','2022-10-09 08:25:53','',''),('8','214',271,'','6.1','5',0.00,1120354.97,'Sales from shift 64 on 2022-10-09 08:25:53 ','2022-10-09 08:25:53','',''),('8','214',272,'','24','7',0.00,5826100.00,'Purchase Id 14 for 28,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-10 11:20:20','',''),('8','214',273,'','supplier','1',5826100.00,0.00,'Purchase Id 14 for 28,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-10 11:20:20','',''),('8','214',274,'','2','1',588830.00,0.00,'Payment Id 64 for invoice:63, receipt: 06 by Lausu Energy Resources','2022-10-10 12:33:20','',''),('8','214',275,'','supplier','1',0.00,588830.00,'Payment Id 64 for invoice:63, receipt: 06 by Lausu Energy Resources','2022-10-10 12:33:20','',''),('8','214',276,'','20','4',1713699.61,0.00,'Sales from shift 65 on 2022-10-10 13:23:35 ','2022-10-10 13:23:35','',''),('8','214',277,'','6.1','5',0.00,1713699.61,'Sales from shift 65 on 2022-10-10 13:23:35 ','2022-10-10 13:23:35','',''),('8','214',278,'','20','4',2262950.62,0.00,'Sales from shift 66 on 2022-10-11 10:19:32 ','2022-10-11 10:19:32','',''),('8','214',279,'','6.1','5',0.00,2262950.62,'Sales from shift 66 on 2022-10-11 10:19:32 ','2022-10-11 10:19:32','',''),('8','214',280,'','20','4',2484046.88,0.00,'Sales from shift 67 on 2022-10-12 10:10:11 ','2022-10-12 10:10:11','',''),('8','214',281,'','6.1','5',0.00,2484046.88,'Sales from shift 67 on 2022-10-12 10:10:11 ','2022-10-12 10:10:11','',''),('8','214',282,'','2','1',2262950.00,0.00,'Payment Id 66 for invoice:66, receipt: 09 by Lausu Energy Resources','2022-10-12 16:45:38','',''),('8','214',283,'','supplier','1',0.00,2262950.00,'Payment Id 66 for invoice:66, receipt: 09 by Lausu Energy Resources','2022-10-12 16:45:38','',''),('8','214',284,'','2','1',1713700.00,0.00,'Payment Id 65 for invoice:65, receipt: 07 by Lausu Energy Resources','2022-10-12 16:45:38','',''),('8','214',285,'','supplier','1',0.00,1713700.00,'Payment Id 65 for invoice:65, receipt: 07 by Lausu Energy Resources','2022-10-12 16:45:38','',''),('8','214',286,'','2','1',1141700.00,0.00,'Payment Id 59 for invoice:57, receipt: 04 by Lausu Energy Resources','2022-10-12 16:58:30','',''),('8','214',287,'','supplier','1',0.00,1141700.00,'Payment Id 59 for invoice:57, receipt: 04 by Lausu Energy Resources','2022-10-12 16:58:30','',''),('8','214',288,'','2','1',2484050.00,0.00,'Payment Id 67 for invoice:67, receipt: 10 by Lausu Energy Resources','2022-10-20 13:50:01','',''),('8','214',289,'','supplier','1',0.00,2484050.00,'Payment Id 67 for invoice:67, receipt: 10 by Lausu Energy Resources','2022-10-20 13:50:01','',''),('8','214',290,'','24','7',0.00,4218250.00,'Purchase Id 15 for 17,950.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-21 21:18:47','',''),('8','214',291,'','supplier','1',4218250.00,0.00,'Purchase Id 15 for 17,950.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-21 21:18:47','',''),('8','214',292,'','20','4',1230332.40,0.00,'Sales from shift 68 on 2022-10-22 10:41:26 ','2022-10-22 10:41:26','',''),('8','214',293,'','6.1','5',0.00,1230332.40,'Sales from shift 68 on 2022-10-22 10:41:26 ','2022-10-22 10:41:26','',''),('8','214',294,'','20','4',1969290.60,0.00,'Sales from shift 69 on 2022-10-22 10:49:31 ','2022-10-22 10:49:31','',''),('8','214',295,'','6.1','5',0.00,1969290.60,'Sales from shift 69 on 2022-10-22 10:49:31 ','2022-10-22 10:49:31','',''),('8','214',296,'','20','4',1296007.20,0.00,'Sales from shift 70 on 2022-10-23 07:46:28 ','2022-10-23 07:46:28','',''),('8','214',297,'','6.1','5',0.00,1296007.20,'Sales from shift 70 on 2022-10-23 07:46:28 ','2022-10-23 07:46:28','',''),('8','214',298,'','2','1',1296010.00,0.00,'Payment Id 70 for invoice:70, receipt: 012 by Lausu Energy Resources','2022-10-24 15:41:33','',''),('8','214',299,'','supplier','1',0.00,1296010.00,'Payment Id 70 for invoice:70, receipt: 012 by Lausu Energy Resources','2022-10-24 15:41:33','',''),('8','214',300,'','2','1',1969290.00,0.00,'Payment Id 69 for invoice:69, receipt: 010 by Lausu Energy Resources','2022-10-24 15:41:33','',''),('8','214',301,'','supplier','1',0.00,1969290.00,'Payment Id 69 for invoice:69, receipt: 010 by Lausu Energy Resources','2022-10-24 15:41:33','',''),('8','214',302,'','24','7',0.00,4680000.00,'Purchase Id 16 for 19,500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-26 09:58:44','',''),('8','214',303,'','supplier','1',4680000.00,0.00,'Purchase Id 16 for 19,500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-26 09:58:44','',''),('8','214',304,'','20','4',978717.60,0.00,'Sales from shift 71 on 2022-10-27 11:15:47 ','2022-10-27 11:15:47','',''),('8','214',305,'','6.1','5',0.00,978717.60,'Sales from shift 71 on 2022-10-27 11:15:47 ','2022-10-27 11:15:47','',''),('8','214',306,'','20','4',2931921.60,0.00,'Sales from shift 72 on 2022-10-27 11:20:24 ','2022-10-27 11:20:24','',''),('8','214',307,'','6.1','5',0.00,2931921.60,'Sales from shift 72 on 2022-10-27 11:20:24 ','2022-10-27 11:20:24','',''),('8','214',308,'','20','4',1087460.00,0.00,'Sales from shift 73 on 2022-10-27 11:23:40 ','2022-10-27 11:23:40','',''),('8','214',309,'','6.1','5',0.00,1087460.00,'Sales from shift 73 on 2022-10-27 11:23:40 ','2022-10-27 11:23:40','',''),('8','214',310,'','2','1',2931920.00,0.00,'Payment Id 72 for invoice:72, receipt: 13 by Lausu Energy Resources','2022-10-31 17:18:48','',''),('8','214',311,'','supplier','1',0.00,2931920.00,'Payment Id 72 for invoice:72, receipt: 13 by Lausu Energy Resources','2022-10-31 17:18:48','',''),('8','214',312,'','2','1',978720.00,0.00,'Payment Id 71 for invoice:71, receipt: 12 by Lausu Energy Resources','2022-10-31 17:19:06','',''),('8','214',313,'','supplier','1',0.00,978720.00,'Payment Id 71 for invoice:71, receipt: 12 by Lausu Energy Resources','2022-10-31 17:19:06','',''),('8','214',314,'','2','1',1230330.00,0.00,'Payment Id 68 for invoice:68, receipt: 008 by Lausu Energy Resources','2022-11-01 16:09:27','',''),('8','214',315,'','supplier','1',0.00,1230330.00,'Payment Id 68 for invoice:68, receipt: 008 by Lausu Energy Resources','2022-11-01 16:09:27','',''),('8','214',316,'','2','1',1087460.00,0.00,'Payment Id 73 for invoice:73, receipt: 15 by Lausu Energy Resources','2022-11-01 16:42:51','',''),('8','214',317,'','supplier','1',0.00,1087460.00,'Payment Id 73 for invoice:73, receipt: 15 by Lausu Energy Resources','2022-11-01 16:42:51','',''),('8','214',318,'','24','7',0.00,8364000.00,'Purchase Id 17 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-05 11:04:18','',''),('8','214',319,'','supplier','1',8364000.00,0.00,'Purchase Id 17 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-05 11:04:18','',''),('8','214',320,'','20','4',769235.00,0.00,'Sales from shift 74 on 2022-11-06 10:20:57 ','2022-11-06 10:20:57','',''),('8','214',321,'','6.1','5',0.00,769235.00,'Sales from shift 74 on 2022-11-06 10:20:57 ','2022-11-06 10:20:57','',''),('8','214',322,'','20','4',1538927.55,0.00,'Sales from shift 75 on 2022-11-06 10:32:22 ','2022-11-06 10:32:22','',''),('8','214',323,'','6.1','5',0.00,1538927.55,'Sales from shift 75 on 2022-11-06 10:32:22 ','2022-11-06 10:32:22','',''),('8','214',324,'','20','4',1912076.70,0.00,'Sales from shift 76 on 2022-11-07 11:12:51 ','2022-11-07 11:12:51','',''),('8','214',325,'','6.1','5',0.00,1912076.70,'Sales from shift 76 on 2022-11-07 11:12:51 ','2022-11-07 11:12:51','',''),('8','214',326,'','2','1',1538935.00,0.00,'Payment Id 75 for invoice:75, receipt: 002 by Lausu Energy Resources','2022-11-07 12:17:50','',''),('8','214',327,'','supplier','1',0.00,1538935.00,'Payment Id 75 for invoice:75, receipt: 002 by Lausu Energy Resources','2022-11-07 12:17:50','',''),('8','214',328,'','20','4',1696634.85,0.00,'Sales from shift 77 on 2022-11-08 06:30:38 ','2022-11-08 06:30:38','',''),('8','214',329,'','6.1','5',0.00,1696634.85,'Sales from shift 77 on 2022-11-08 06:30:38 ','2022-11-08 06:30:38','',''),('8','214',330,'','24','7',0.00,4335000.00,'Purchase Id 18 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-08 13:04:19','',''),('8','214',331,'','supplier','1',4335000.00,0.00,'Purchase Id 18 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-08 13:04:19','',''),('8','214',332,'','2','1',1912075.00,0.00,'Payment Id 76 for invoice:76, receipt: 0012 by Lausu Energy Resources','2022-11-09 12:39:13','',''),('8','214',333,'','supplier','1',0.00,1912075.00,'Payment Id 76 for invoice:76, receipt: 0012 by Lausu Energy Resources','2022-11-09 12:39:13','',''),('8','214',334,'','2','1',420000.00,0.00,'Payment Id 74 for invoice:74, receipt: 009 by Lausu Energy Resources','2022-11-09 12:59:42','',''),('8','214',335,'','supplier','1',0.00,420000.00,'Payment Id 74 for invoice:74, receipt: 009 by Lausu Energy Resources','2022-11-09 12:59:42','',''),('8','214',336,'','20','4',3964130.55,0.00,'Sales from shift 78 on 2022-11-09 13:35:34 ','2022-11-09 13:35:34','',''),('8','214',337,'','6.1','5',0.00,3964130.55,'Sales from shift 78 on 2022-11-09 13:35:34 ','2022-11-09 13:35:34','',''),('8','214',338,'','20','4',1732186.95,0.00,'Sales from shift 79 on 2022-11-10 09:23:28 ','2022-11-10 09:23:28','',''),('8','214',339,'','6.1','5',0.00,1732186.95,'Sales from shift 79 on 2022-11-10 09:23:28 ','2022-11-10 09:23:28','',''),('8','214',340,'','20','4',1144447.65,0.00,'Sales from shift 80 on 2022-11-11 08:21:07 ','2022-11-11 08:21:07','',''),('8','214',341,'','6.1','5',0.00,1144447.65,'Sales from shift 80 on 2022-11-11 08:21:07 ','2022-11-11 08:21:07','',''),('8','214',342,'','2','1',1144450.00,0.00,'Payment Id 80 for invoice:80, receipt: 0013 by Lausu Energy Resources','2022-11-13 06:49:50','',''),('8','214',343,'','supplier','1',0.00,1144450.00,'Payment Id 80 for invoice:80, receipt: 0013 by Lausu Energy Resources','2022-11-13 06:49:50','',''),('8','214',344,'','2','1',1732185.00,0.00,'Payment Id 79 for invoice:79, receipt: 003 by Lausu Energy Resources','2022-11-15 13:47:39','',''),('8','214',345,'','supplier','1',0.00,1732185.00,'Payment Id 79 for invoice:79, receipt: 003 by Lausu Energy Resources','2022-11-15 13:47:39','',''),('8','214',346,'','2','1',3964130.00,0.00,'Payment Id 77 for invoice:78, receipt: 0028 by Lausu Energy Resources','2022-11-15 13:47:39','',''),('8','214',347,'','supplier','1',0.00,3964130.00,'Payment Id 77 for invoice:78, receipt: 0028 by Lausu Energy Resources','2022-11-15 13:47:39','',''),('8','214',348,'','2','1',349230.00,0.00,'Payment Id 78 for invoice:78, receipt: 0021 by Lausu Energy Resources','2022-11-15 13:48:44','',''),('8','214',349,'','supplier','1',0.00,349230.00,'Payment Id 78 for invoice:78, receipt: 0021 by Lausu Energy Resources','2022-11-15 13:48:44','',''),('8','214',350,'','24','7',0.00,4258500.00,'Purchase Id 19 for 16,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-16 13:27:17','',''),('8','214',351,'','supplier','1',4258500.00,0.00,'Purchase Id 19 for 16,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-16 13:27:17','',''),('8','214',352,'','20','4',747762.00,0.00,'Sales from shift 81 on 2022-11-17 07:47:43 ','2022-11-17 07:47:43','',''),('8','214',353,'','6.1','5',0.00,747762.00,'Sales from shift 81 on 2022-11-17 07:47:43 ','2022-11-17 07:47:43','',''),('8','214',354,'','20','4',1511757.30,0.00,'Sales from shift 82 on 2022-11-17 07:51:09 ','2022-11-17 07:51:09','',''),('8','214',355,'','6.1','5',0.00,1511757.30,'Sales from shift 82 on 2022-11-17 07:51:09 ','2022-11-17 07:51:09','',''),('8','214',356,'','2','1',747760.00,0.00,'Payment Id 81 for invoice:81, receipt: 0026 by Lausu Energy Resources','2022-11-17 11:17:36','',''),('8','214',357,'','supplier','1',0.00,747760.00,'Payment Id 81 for invoice:81, receipt: 0026 by Lausu Energy Resources','2022-11-17 11:17:36','',''),('8','214',358,'','20','4',1823737.05,0.00,'Sales from shift 83 on 2022-11-18 09:03:19 ','2022-11-18 09:03:19','',''),('8','214',359,'','6.1','5',0.00,1823737.05,'Sales from shift 83 on 2022-11-18 09:03:19 ','2022-11-18 09:03:19','',''),('8','214',360,'','2','1',1511760.00,0.00,'Payment Id 82 for invoice:83, receipt: 0024 by Lausu Energy Resources','2022-11-19 05:58:05','',''),('8','214',361,'','supplier','1',0.00,1511760.00,'Payment Id 82 for invoice:83, receipt: 0024 by Lausu Energy Resources','2022-11-19 05:58:05','',''),('8','214',362,'','24','7',0.00,8580000.00,'Purchase Id 20 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-20 11:05:00','',''),('8','214',363,'','supplier','1',8580000.00,0.00,'Purchase Id 20 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-20 11:05:00','',''),('8','214',364,'','20','4',939371.55,0.00,'Sales from shift 84 on 2022-11-20 18:15:17 ','2022-11-20 18:15:17','',''),('8','214',365,'','6.1','5',0.00,939371.55,'Sales from shift 84 on 2022-11-20 18:15:17 ','2022-11-20 18:15:17','',''),('8','214',366,'','20','4',1606776.60,0.00,'Sales from shift 85 on 2022-11-21 08:50:33 ','2022-11-21 08:50:33','',''),('8','214',367,'','6.1','5',0.00,1606776.60,'Sales from shift 85 on 2022-11-21 08:50:33 ','2022-11-21 08:50:33','',''),('8','214',368,'','20','4',1813416.80,0.00,'Sales from shift 86 on 2022-11-22 08:49:44 ','2022-11-22 08:49:44','',''),('8','214',369,'','6.1','5',0.00,1813416.80,'Sales from shift 86 on 2022-11-22 08:49:44 ','2022-11-22 08:49:44','',''),('8','214',370,'','20','4',4468588.80,0.00,'Sales from shift 87 on 2022-11-23 08:15:43 ','2022-11-23 08:15:43','',''),('8','214',371,'','6.1','5',0.00,4468588.80,'Sales from shift 87 on 2022-11-23 08:15:43 ','2022-11-23 08:15:43','',''),('8','214',372,'','24','7',0.00,8879000.00,'Purchase Id 21 for 34,150.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-24 12:42:32','',''),('8','214',373,'','supplier','1',8879000.00,0.00,'Purchase Id 21 for 34,150.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-24 12:42:32','',''),('8','214',374,'','20','4',635887.20,0.00,'Sales from shift 88 on 2022-11-24 15:55:30 ','2022-11-24 15:55:30','',''),('8','214',375,'','6.1','5',0.00,635887.20,'Sales from shift 88 on 2022-11-24 15:55:30 ','2022-11-24 15:55:30','',''),('8','214',376,'','20','4',1131702.00,0.00,'Sales from shift 89 on 2022-11-25 12:25:22 ','2022-11-25 12:25:22','',''),('8','214',377,'','6.1','5',0.00,1131702.00,'Sales from shift 89 on 2022-11-25 12:25:22 ','2022-11-25 12:25:22','',''),('8','214',378,'','2','1',635890.00,0.00,'Payment Id 86 for invoice:88, receipt: 011 by Lausu Energy Resources','2022-11-25 17:46:10','',''),('8','214',379,'','supplier','1',0.00,635890.00,'Payment Id 86 for invoice:88, receipt: 011 by Lausu Energy Resources','2022-11-25 17:46:10','',''),('8','214',380,'','2','1',1813310.00,0.00,'Payment Id 85 for invoice:86, receipt: 0018 by Lausu Energy Resources','2022-11-25 17:46:52','',''),('8','214',381,'','supplier','1',0.00,1813310.00,'Payment Id 85 for invoice:86, receipt: 0018 by Lausu Energy Resources','2022-11-25 17:46:52','',''),('8','214',382,'','2','1',1606775.00,0.00,'Payment Id 84 for invoice:85, receipt: 0015 by Lausu Energy Resources','2022-11-25 17:46:52','',''),('8','214',383,'','supplier','1',0.00,1606775.00,'Payment Id 84 for invoice:85, receipt: 0015 by Lausu Energy Resources','2022-11-25 17:46:52','',''),('8','214',384,'','2','1',939370.00,0.00,'Payment Id 83 for invoice:84, receipt: 00012 by Lausu Energy Resources','2022-11-25 17:46:53','',''),('8','214',385,'','supplier','1',0.00,939370.00,'Payment Id 83 for invoice:84, receipt: 00012 by Lausu Energy Resources','2022-11-25 17:46:53','',''),('8','214',386,'','20','4',1601451.80,0.00,'Sales from shift 90 on 2022-11-26 08:32:18 ','2022-11-26 08:32:18','',''),('8','214',387,'','6.1','5',0.00,1601451.80,'Sales from shift 90 on 2022-11-26 08:32:18 ','2022-11-26 08:32:18','',''),('8','214',388,'','20','4',1778610.60,0.00,'Sales from shift 91 on 2022-11-27 12:18:56 ','2022-11-27 12:18:56','',''),('8','214',389,'','6.1','5',0.00,1778610.60,'Sales from shift 91 on 2022-11-27 12:18:56 ','2022-11-27 12:18:56','',''),('8','214',390,'','20','4',1906998.60,0.00,'Sales from shift 92 on 2022-11-28 08:52:31 ','2022-11-28 08:52:31','',''),('8','214',391,'','6.1','5',0.00,1906998.60,'Sales from shift 92 on 2022-11-28 08:52:31 ','2022-11-28 08:52:31','',''),('8','214',392,'','2','1',1601450.00,0.00,'Payment Id 88 for invoice:90, receipt: 023 by Lausu Energy Resources','2022-11-28 16:49:30','',''),('8','214',393,'','supplier','1',0.00,1601450.00,'Payment Id 88 for invoice:90, receipt: 023 by Lausu Energy Resources','2022-11-28 16:49:30','',''),('8','214',394,'','2','1',1131700.00,0.00,'Payment Id 87 for invoice:89, receipt: 027 by Lausu Energy Resources','2022-11-28 16:49:30','',''),('8','214',395,'','supplier','1',0.00,1131700.00,'Payment Id 87 for invoice:89, receipt: 027 by Lausu Energy Resources','2022-11-28 16:49:30','',''),('8','214',396,'','20','4',1321450.00,0.00,'Sales from shift 93 on 2022-11-29 08:36:04 ','2022-11-29 08:36:04','',''),('8','214',397,'','6.1','5',0.00,1321450.00,'Sales from shift 93 on 2022-11-29 08:36:04 ','2022-11-29 08:36:04','',''),('8','214',398,'','2','1',1778610.00,0.00,'Payment Id 89 for invoice:91, receipt: 08 by Lausu Energy Resources','2022-12-01 15:22:11','',''),('8','214',399,'','supplier','1',0.00,1778610.00,'Payment Id 89 for invoice:91, receipt: 08 by Lausu Energy Resources','2022-12-01 15:22:11','',''),('8','214',400,'','2','1',1907000.00,0.00,'Payment Id 90 for invoice:92, receipt: 09 by Lausu Energy Resources','2022-12-03 13:57:29','',''),('8','214',401,'','supplier','1',0.00,1907000.00,'Payment Id 90 for invoice:92, receipt: 09 by Lausu Energy Resources','2022-12-03 13:57:29','',''),('8','214',402,'','2','1',1321450.00,0.00,'Payment Id 91 for invoice:93, receipt: 010 by Lausu Energy Resources','2022-12-03 13:57:44','',''),('8','214',403,'','supplier','1',0.00,1321450.00,'Payment Id 91 for invoice:93, receipt: 010 by Lausu Energy Resources','2022-12-03 13:57:44','',''),('8','214',404,'','24','7',0.00,8964000.00,'Purchase Id 22 for 33,200.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-06 10:26:11','',''),('8','214',405,'','supplier','1',8964000.00,0.00,'Purchase Id 22 for 33,200.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-06 10:26:11','',''),('8','214',406,'','20','4',1172732.60,0.00,'Sales from shift 94 on 2022-12-07 08:03:53 ','2022-12-07 08:03:53','',''),('8','214',407,'','6.1','5',0.00,1172732.60,'Sales from shift 94 on 2022-12-07 08:03:53 ','2022-12-07 08:03:53','',''),('8','214',408,'','20','4',6295201.20,0.00,'Sales from shift 95 on 2022-12-07 08:10:06 ','2022-12-07 08:10:06','',''),('8','214',409,'','6.1','5',0.00,6295201.20,'Sales from shift 95 on 2022-12-07 08:10:06 ','2022-12-07 08:10:06','',''),('8','214',410,'','2','1',166480.00,0.00,'Payment Id 93 for invoice:94, receipt: 11 by Lausu Energy Resources','2022-12-10 06:41:19','',''),('8','214',411,'','supplier','1',0.00,166480.00,'Payment Id 93 for invoice:94, receipt: 11 by Lausu Energy Resources','2022-12-10 06:41:19','',''),('8','214',412,'','2','1',1006000.00,0.00,'Payment Id 92 for invoice:94, receipt: 10 by Lausu Energy Resources','2022-12-10 06:41:19','',''),('8','214',413,'','supplier','1',0.00,1006000.00,'Payment Id 92 for invoice:94, receipt: 10 by Lausu Energy Resources','2022-12-10 06:41:19','',''),('8','214',414,'','2','1',6295200.00,0.00,'Payment Id 94 for invoice:95, receipt: 12 by Lausu Energy Resources','2022-12-13 13:02:31','',''),('8','214',415,'','supplier','1',0.00,6295200.00,'Payment Id 94 for invoice:95, receipt: 12 by Lausu Energy Resources','2022-12-13 13:02:31','',''),('8','214',416,'','24','7',0.00,15639750.00,'Purchase Id 23 for 49,650.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-14 21:43:14','',''),('8','214',417,'','supplier','1',15639750.00,0.00,'Purchase Id 23 for 49,650.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-14 21:43:14','',''),('8','214',418,'','20','4',2202803.72,0.00,'Sales from shift 96 on 2022-12-15 08:36:48 ','2022-12-15 08:36:48','',''),('8','214',419,'','6.1','5',0.00,2202803.72,'Sales from shift 96 on 2022-12-15 08:36:48 ','2022-12-15 08:36:48','',''),('8','214',420,'','20','4',557171.20,0.00,'Sales from shift 97 on 2022-12-15 08:41:18 ','2022-12-15 08:41:18','',''),('8','214',421,'','6.1','5',0.00,557171.20,'Sales from shift 97 on 2022-12-15 08:41:18 ','2022-12-15 08:41:18','',''),('8','214',422,'','20','4',514939.95,0.00,'Sales from shift 98 on 2022-12-15 08:45:23 ','2022-12-15 08:45:23','',''),('8','214',423,'','6.1','5',0.00,514939.95,'Sales from shift 98 on 2022-12-15 08:45:23 ','2022-12-15 08:45:23','',''),('8','214',424,'','2','1',557170.00,0.00,'Payment Id 96 for invoice:97, receipt: 112 by Lausu Energy Resources','2022-12-15 12:37:43','',''),('8','214',425,'','supplier','1',0.00,557170.00,'Payment Id 96 for invoice:97, receipt: 112 by Lausu Energy Resources','2022-12-15 12:37:43','',''),('8','214',426,'','2','1',2202700.00,0.00,'Payment Id 95 for invoice:96, receipt: 12 by Lausu Energy Resources','2022-12-15 12:38:37','',''),('8','214',427,'','supplier','1',0.00,2202700.00,'Payment Id 95 for invoice:96, receipt: 12 by Lausu Energy Resources','2022-12-15 12:38:37','',''),('8','214',428,'','20','4',1846366.20,0.00,'Sales from shift 99 on 2022-12-16 11:43:28 ','2022-12-16 11:43:28','',''),('8','214',429,'','6.1','5',0.00,1846366.20,'Sales from shift 99 on 2022-12-16 11:43:28 ','2022-12-16 11:43:28','',''),('8','214',430,'','20','4',1613924.55,0.00,'Sales from shift 100 on 2022-12-17 08:27:28 ','2022-12-17 08:27:28','',''),('8','214',431,'','6.1','5',0.00,1613924.55,'Sales from shift 100 on 2022-12-17 08:27:28 ','2022-12-17 08:27:28','',''),('8','214',432,'','20','4',1857334.50,0.00,'Sales from shift 101 on 2022-12-18 08:54:36 ','2022-12-18 08:54:36','',''),('8','214',433,'','6.1','5',0.00,1857334.50,'Sales from shift 101 on 2022-12-18 08:54:36 ','2022-12-18 08:54:36','',''),('8','214',434,'','2','1',1846365.00,0.00,'Payment Id 98 for invoice:99, receipt: 13 by Lausu Energy Resources','2022-12-18 21:42:36','',''),('8','214',435,'','supplier','1',0.00,1846365.00,'Payment Id 98 for invoice:99, receipt: 13 by Lausu Energy Resources','2022-12-18 21:42:36','',''),('8','214',436,'','2','1',514900.00,0.00,'Payment Id 97 for invoice:98, receipt: 111 by Lausu Energy Resources','2022-12-18 21:42:36','',''),('8','214',437,'','supplier','1',0.00,514900.00,'Payment Id 97 for invoice:98, receipt: 111 by Lausu Energy Resources','2022-12-18 21:42:36','',''),('8','214',438,'','2','1',1613978.75,0.00,'Payment Id 99 for invoice:100, receipt: 0098 by Lausu Energy Resources','2022-12-18 21:44:26','',''),('8','214',439,'','supplier','1',0.00,1613978.75,'Payment Id 99 for invoice:100, receipt: 0098 by Lausu Energy Resources','2022-12-18 21:44:26','',''),('8','214',440,'','20','4',1366233.75,0.00,'Sales from shift 102 on 2022-12-19 17:15:51 ','2022-12-19 17:15:51','',''),('8','214',441,'','6.1','5',0.00,1366233.75,'Sales from shift 102 on 2022-12-19 17:15:51 ','2022-12-19 17:15:51','',''),('8','214',442,'','20','4',1648108.35,0.00,'Sales from shift 103 on 2022-12-20 12:19:44 ','2022-12-20 12:19:44','',''),('8','214',443,'','6.1','5',0.00,1648108.35,'Sales from shift 103 on 2022-12-20 12:19:44 ','2022-12-20 12:19:44','',''),('8','214',444,'','20','4',4010627.25,0.00,'Sales from shift 104 on 2022-12-21 08:15:19 ','2022-12-21 08:15:19','',''),('8','214',445,'','6.1','5',0.00,4010627.25,'Sales from shift 104 on 2022-12-21 08:15:19 ','2022-12-21 08:15:19','',''),('8','214',446,'','20','4',1271368.35,0.00,'Sales from shift 105 on 2022-12-22 08:19:42 ','2022-12-22 08:19:42','',''),('8','214',447,'','6.1','5',0.00,1271368.35,'Sales from shift 105 on 2022-12-22 08:19:42 ','2022-12-22 08:19:42','',''),('8','214',448,'','24','7',0.00,5490000.00,'Purchase Id 24 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-25 14:15:48','',''),('8','214',449,'','supplier','1',5490000.00,0.00,'Purchase Id 24 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-25 14:15:48','',''),('8','214',450,'','2','1',1648110.00,0.00,'Payment Id 102 for invoice:103, receipt: 20 by Lausu Energy Resources','2022-12-25 14:22:31','',''),('8','214',451,'','supplier','1',0.00,1648110.00,'Payment Id 102 for invoice:103, receipt: 20 by Lausu Energy Resources','2022-12-25 14:22:31','',''),('8','214',452,'','2','1',1857335.00,0.00,'Payment Id 101 for invoice:102, receipt: 17 by Lausu Energy Resources','2022-12-25 14:22:31','',''),('8','214',453,'','supplier','1',0.00,1857335.00,'Payment Id 101 for invoice:102, receipt: 17 by Lausu Energy Resources','2022-12-25 14:22:31','',''),('8','214',454,'','2','1',1366230.00,0.00,'Payment Id 100 for invoice:102, receipt: 18 by Lausu Energy Resources','2022-12-25 14:22:31','',''),('8','214',455,'','supplier','1',0.00,1366230.00,'Payment Id 100 for invoice:102, receipt: 18 by Lausu Energy Resources','2022-12-25 14:22:31','',''),('8','214',456,'','2','1',1271055.00,0.00,'Payment Id 104 for invoice:105, receipt: 189 by Lausu Energy Resources','2022-12-25 14:24:28','',''),('8','214',457,'','supplier','1',0.00,1271055.00,'Payment Id 104 for invoice:105, receipt: 189 by Lausu Energy Resources','2022-12-25 14:24:28','',''),('8','214',458,'','2','1',4010615.00,0.00,'Payment Id 103 for invoice:104, receipt: 56 by Lausu Energy Resources','2022-12-25 14:24:28','',''),('8','214',459,'','supplier','1',0.00,4010615.00,'Payment Id 103 for invoice:104, receipt: 56 by Lausu Energy Resources','2022-12-25 14:24:28','',''),('8','214',460,'','20','4',1097267.85,0.00,'Sales from shift 106 on 2022-12-26 08:09:11 ','2022-12-26 08:09:11','',''),('8','214',461,'','6.1','5',0.00,1097267.85,'Sales from shift 106 on 2022-12-26 08:09:11 ','2022-12-26 08:09:11','',''),('8','214',462,'','20','4',386391.60,0.00,'Sales from shift 107 on 2022-12-26 08:12:28 ','2022-12-26 08:12:28','',''),('8','214',463,'','6.1','5',0.00,386391.60,'Sales from shift 107 on 2022-12-26 08:12:28 ','2022-12-26 08:12:28','',''),('8','214',464,'','20','4',2074780.80,0.00,'Sales from shift 108 on 2022-12-26 11:08:46 ','2022-12-26 11:08:46','',''),('8','214',465,'','6.1','5',0.00,2074780.80,'Sales from shift 108 on 2022-12-26 11:08:46 ','2022-12-26 11:08:46','',''),('8','214',466,'','20','4',1909949.65,0.00,'Sales from shift 109 on 2022-12-27 08:59:59 ','2022-12-27 08:59:59','',''),('8','214',467,'','6.1','5',0.00,1909949.65,'Sales from shift 109 on 2022-12-27 08:59:59 ','2022-12-27 08:59:59','',''),('8','214',468,'','24','7',0.00,14955000.00,'Purchase Id 25 for 49,850.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-29 13:00:39','',''),('8','214',469,'','supplier','1',14955000.00,0.00,'Purchase Id 25 for 49,850.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-29 13:00:39','',''),('8','214',470,'','2','1',1097270.00,0.00,'Payment Id 105 for invoice:106, receipt: 19 by Lausu Energy Resources','2022-12-29 13:25:47','',''),('8','214',471,'','supplier','1',0.00,1097270.00,'Payment Id 105 for invoice:106, receipt: 19 by Lausu Energy Resources','2022-12-29 13:25:47','',''),('8','214',472,'','2','1',1909950.00,0.00,'Payment Id 108 for invoice:110, receipt: Q3 by Lausu Energy Resources','2022-12-29 13:34:14','',''),('8','214',473,'','supplier','1',0.00,1909950.00,'Payment Id 108 for invoice:110, receipt: Q3 by Lausu Energy Resources','2022-12-29 13:34:14','',''),('8','214',474,'','2','1',2074780.00,0.00,'Payment Id 107 for invoice:108, receipt: 126 by Lausu Energy Resources','2022-12-29 13:34:14','',''),('8','214',475,'','supplier','1',0.00,2074780.00,'Payment Id 107 for invoice:108, receipt: 126 by Lausu Energy Resources','2022-12-29 13:34:14','',''),('8','214',476,'','2','1',386390.00,0.00,'Payment Id 106 for invoice:107, receipt: 117 by Lausu Energy Resources','2022-12-29 13:34:14','',''),('8','214',477,'','supplier','1',0.00,386390.00,'Payment Id 106 for invoice:107, receipt: 117 by Lausu Energy Resources','2022-12-29 13:34:14','',''),('8','214',478,'','20','4',1503180.30,0.00,'Sales from shift 110 on 2022-12-29 15:27:27 ','2022-12-29 15:27:27','',''),('8','214',479,'','6.1','5',0.00,1503180.30,'Sales from shift 110 on 2022-12-29 15:27:27 ','2022-12-29 15:27:27','',''),('8','214',480,'','20','4',1473807.00,0.00,'Sales from shift 111 on 2022-12-30 08:42:38 ','2022-12-30 08:42:38','',''),('8','214',481,'','6.1','5',0.00,1473807.00,'Sales from shift 111 on 2022-12-30 08:42:38 ','2022-12-30 08:42:38','',''),('8','214',482,'','20','4',2087250.00,0.00,'Sales from shift 112 on 2022-12-31 08:39:15 ','2022-12-31 08:39:15','',''),('8','214',483,'','6.1','5',0.00,2087250.00,'Sales from shift 112 on 2022-12-31 08:39:15 ','2022-12-31 08:39:15','',''),('8','214',484,'','20','4',2271825.00,0.00,'Sales from shift 113 on 2023-01-01 12:27:03 ','2023-01-01 12:27:03','',''),('8','214',485,'','6.1','5',0.00,2271825.00,'Sales from shift 113 on 2023-01-01 12:27:03 ','2023-01-01 12:27:03','',''),('8','214',486,'','20','4',2094555.00,0.00,'Sales from shift 114 on 2023-01-02 12:24:18 ','2023-01-02 12:24:18','',''),('8','214',487,'','6.1','5',0.00,2094555.00,'Sales from shift 114 on 2023-01-02 12:24:18 ','2023-01-02 12:24:18','',''),('8','214',488,'','2','1',1473810.00,0.00,'Payment Id 110 for invoice:111, receipt: 110 by Lausu Energy Resources','2023-01-02 15:13:00','',''),('8','214',489,'','supplier','1',0.00,1473810.00,'Payment Id 110 for invoice:111, receipt: 110 by Lausu Energy Resources','2023-01-02 15:13:00','',''),('8','214',490,'','2','1',1503180.00,0.00,'Payment Id 109 for invoice:110, receipt: 10 by Lausu Energy Resources','2023-01-02 15:13:50','',''),('8','214',491,'','supplier','1',0.00,1503180.00,'Payment Id 109 for invoice:110, receipt: 10 by Lausu Energy Resources','2023-01-02 15:13:50','',''),('8','214',492,'','2','1',2271825.00,0.00,'Payment Id 112 for invoice:113, receipt: 119 by Lausu Energy Resources','2023-01-02 15:14:24','',''),('8','214',493,'','supplier','1',0.00,2271825.00,'Payment Id 112 for invoice:113, receipt: 119 by Lausu Energy Resources','2023-01-02 15:14:24','',''),('8','214',494,'','2','1',2087160.00,0.00,'Payment Id 111 for invoice:113, receipt: 09 by Lausu Energy Resources','2023-01-02 15:14:39','',''),('8','214',495,'','supplier','1',0.00,2087160.00,'Payment Id 111 for invoice:113, receipt: 09 by Lausu Energy Resources','2023-01-02 15:14:39','',''),('8','214',496,'','20','4',1863603.00,0.00,'Sales from shift 115 on 2023-01-03 14:25:27 ','2023-01-03 14:25:27','',''),('8','214',497,'','6.1','5',0.00,1863603.00,'Sales from shift 115 on 2023-01-03 14:25:27 ','2023-01-03 14:25:27','',''),('8','214',498,'','24','7',0.00,10230000.00,'Purchase Id 26 for 34,100.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-03 17:15:12','',''),('8','214',499,'','supplier','1',10230000.00,0.00,'Purchase Id 26 for 34,100.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-03 17:15:12','',''),('8','214',500,'','20','4',5252202.00,0.00,'Sales from shift 116 on 2023-01-04 09:30:40 ','2023-01-04 09:30:40','',''),('8','214',501,'','6.1','5',0.00,5252202.00,'Sales from shift 116 on 2023-01-04 09:30:40 ','2023-01-04 09:30:40','',''),('8','214',502,'','20','4',2300562.00,0.00,'Sales from shift 117 on 2023-01-05 08:49:53 ','2023-01-05 08:49:53','',''),('8','214',503,'','6.1','5',0.00,2300562.00,'Sales from shift 117 on 2023-01-05 08:49:53 ','2023-01-05 08:49:53','',''),('8','214',504,'','20','4',2124813.00,0.00,'Sales from shift 118 on 2023-01-06 11:02:10 ','2023-01-06 11:02:10','',''),('8','214',505,'','6.1','5',0.00,2124813.00,'Sales from shift 118 on 2023-01-06 11:02:10 ','2023-01-06 11:02:10','',''),('8','214',506,'','20','4',2156964.00,0.00,'Sales from shift 119 on 2023-01-07 11:00:17 ','2023-01-07 11:00:17','',''),('8','214',507,'','6.1','5',0.00,2156964.00,'Sales from shift 119 on 2023-01-07 11:00:17 ','2023-01-07 11:00:17','',''),('8','214',508,'','24','7',0.00,6255000.00,'Purchase Id 27 for 20,850.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-07 15:34:29','',''),('8','214',509,'','supplier','1',6255000.00,0.00,'Purchase Id 27 for 20,850.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-07 15:34:29','',''),('8','214',510,'','20','4',2748516.00,0.00,'Sales from shift 120 on 2023-01-08 11:09:16 ','2023-01-08 11:09:16','',''),('8','214',511,'','6.1','5',0.00,2748516.00,'Sales from shift 120 on 2023-01-08 11:09:16 ','2023-01-08 11:09:16','',''),('8','214',512,'','20','4',2310990.00,0.00,'Sales from shift 121 on 2023-01-09 08:59:56 ','2023-01-09 08:59:56','',''),('8','214',513,'','6.1','5',0.00,2310990.00,'Sales from shift 121 on 2023-01-09 08:59:56 ','2023-01-09 08:59:56','',''),('8','214',514,'','20','4',1922736.00,0.00,'Sales from shift 122 on 2023-01-10 08:59:37 ','2023-01-10 08:59:37','',''),('8','214',515,'','6.1','5',0.00,1922736.00,'Sales from shift 122 on 2023-01-10 08:59:37 ','2023-01-10 08:59:37','',''),('8','214',516,'','2','1',2310990.00,0.00,'Payment Id 120 for invoice:121, receipt: 170 by Lausu Energy Resources','2023-01-10 15:46:38','',''),('8','214',517,'','supplier','1',0.00,2310990.00,'Payment Id 120 for invoice:121, receipt: 170 by Lausu Energy Resources','2023-01-10 15:46:38','',''),('8','214',518,'','2','1',2094555.00,0.00,'Payment Id 113 for invoice:114, receipt: 117 by Lausu Energy Resources','2023-01-10 15:46:38','',''),('8','214',519,'','supplier','1',0.00,2094555.00,'Payment Id 113 for invoice:114, receipt: 117 by Lausu Energy Resources','2023-01-10 15:46:38','',''),('8','214',520,'','2','1',5252100.00,0.00,'Payment Id 115 for invoice:116, receipt: 78 by Lausu Energy Resources','2023-01-10 15:48:12','',''),('8','214',521,'','supplier','1',0.00,5252100.00,'Payment Id 115 for invoice:116, receipt: 78 by Lausu Energy Resources','2023-01-10 15:48:12','',''),('8','214',522,'','2','1',1863705.00,0.00,'Payment Id 114 for invoice:115, receipt: 76 by Lausu Energy Resources','2023-01-10 15:48:12','',''),('8','214',523,'','supplier','1',0.00,1863705.00,'Payment Id 114 for invoice:115, receipt: 76 by Lausu Energy Resources','2023-01-10 15:48:12','',''),('8','214',524,'','2','1',2300575.00,0.00,'Payment Id 116 for invoice:117, receipt: 16 by Lausu Energy Resources','2023-01-10 15:48:45','',''),('8','214',525,'','supplier','1',0.00,2300575.00,'Payment Id 116 for invoice:117, receipt: 16 by Lausu Energy Resources','2023-01-10 15:48:45','',''),('8','214',526,'','2','1',2124815.00,0.00,'Payment Id 117 for invoice:118, receipt: 089 by Lausu Energy Resources','2023-01-10 15:49:02','',''),('8','214',527,'','supplier','1',0.00,2124815.00,'Payment Id 117 for invoice:118, receipt: 089 by Lausu Energy Resources','2023-01-10 15:49:02','',''),('8','214',528,'','2','1',2157000.00,0.00,'Payment Id 118 for invoice:119, receipt: 07 by Lausu Energy Resources','2023-01-10 15:49:45','',''),('8','214',529,'','supplier','1',0.00,2157000.00,'Payment Id 118 for invoice:119, receipt: 07 by Lausu Energy Resources','2023-01-10 15:49:45','',''),('8','214',530,'','2','1',2748535.00,0.00,'Payment Id 119 for invoice:120, receipt: 098 by Lausu Energy Resources','2023-01-10 15:50:18','',''),('8','214',531,'','supplier','1',0.00,2748535.00,'Payment Id 119 for invoice:120, receipt: 098 by Lausu Energy Resources','2023-01-10 15:50:18','',''),('8','214',532,'','24','7',0.00,5055000.00,'Purchase Id 28 for 16,850.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-13 12:26:42','',''),('8','214',533,'','supplier','1',5055000.00,0.00,'Purchase Id 28 for 16,850.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-13 12:26:42','',''),('8','214',534,'','20','4',2784363.00,0.00,'Sales from shift 123 on 2023-01-14 08:41:24 ','2023-01-14 08:41:24','',''),('8','214',535,'','6.1','5',0.00,2784363.00,'Sales from shift 123 on 2023-01-14 08:41:24 ','2023-01-14 08:41:24','',''),('8','214',536,'','20','4',1589103.00,0.00,'Sales from shift 124 on 2023-01-14 08:44:23 ','2023-01-14 08:44:23','',''),('8','214',537,'','6.1','5',0.00,1589103.00,'Sales from shift 124 on 2023-01-14 08:44:23 ','2023-01-14 08:44:23','',''),('8','214',538,'','20','4',2088906.00,0.00,'Sales from shift 125 on 2023-01-14 08:47:21 ','2023-01-14 08:47:21','',''),('8','214',539,'','6.1','5',0.00,2088906.00,'Sales from shift 125 on 2023-01-14 08:47:21 ','2023-01-14 08:47:21','',''),('8','214',540,'','2','1',1922735.00,0.00,'Payment Id 121 for invoice:122, receipt: 122 by Lausu Energy Resources','2023-01-15 22:35:13','',''),('8','214',541,'','supplier','1',0.00,1922735.00,'Payment Id 121 for invoice:122, receipt: 122 by Lausu Energy Resources','2023-01-15 22:35:13','',''),('8','214',542,'','2','1',1589100.00,0.00,'Payment Id 123 for invoice:124, receipt: 179 by Lausu Energy Resources','2023-01-15 22:37:28','',''),('8','214',543,'','supplier','1',0.00,1589100.00,'Payment Id 123 for invoice:124, receipt: 179 by Lausu Energy Resources','2023-01-15 22:37:28','',''),('8','214',544,'','2','1',2784265.00,0.00,'Payment Id 122 for invoice:123, receipt: 187 by Lausu Energy Resources','2023-01-15 22:37:28','',''),('8','214',545,'','supplier','1',0.00,2784265.00,'Payment Id 122 for invoice:123, receipt: 187 by Lausu Energy Resources','2023-01-15 22:37:28','',''),('8','214',546,'','2','1',0.00,2157000.00,'Payment Id 118 for invoice:119, receipt: 07 by Lausu Energy Resources','2023-01-15 22:38:20','',''),('8','214',547,'','supplier','1',2157000.00,0.00,'Payment Id 118 for invoice:119, receipt: 07 by Lausu Energy Resources','2023-01-15 22:38:20','',''),('8','214',548,'','24','7',0.00,4425000.00,'Purchase Id 29 for 14,750.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-18 14:43:24','',''),('8','214',549,'','supplier','1',4425000.00,0.00,'Purchase Id 29 for 14,750.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-18 14:43:24','',''),('8','214',550,'','20','4',1395726.00,0.00,'Sales from shift 126 on 2023-01-19 09:24:18 ','2023-01-19 09:24:18','',''),('8','214',551,'','6.1','5',0.00,1395726.00,'Sales from shift 126 on 2023-01-19 09:24:18 ','2023-01-19 09:24:18','',''),('8','214',552,'','20','4',2505828.00,0.00,'Sales from shift 127 on 2023-01-19 09:33:12 ','2023-01-19 09:33:12','',''),('8','214',553,'','6.1','5',0.00,2505828.00,'Sales from shift 127 on 2023-01-19 09:33:12 ','2023-01-19 09:33:12','',''),('8','214',554,'','2','1',2505780.00,0.00,'Payment Id 126 for invoice:127, receipt: 127 by Lausu Energy Resources','2023-01-21 15:28:00','',''),('8','214',555,'','supplier','1',0.00,2505780.00,'Payment Id 126 for invoice:127, receipt: 127 by Lausu Energy Resources','2023-01-21 15:28:00','',''),('8','214',556,'','2','1',2088925.00,0.00,'Payment Id 125 for invoice:126, receipt: 126 by Lausu Energy Resources','2023-01-21 15:28:00','',''),('8','214',557,'','supplier','1',0.00,2088925.00,'Payment Id 125 for invoice:126, receipt: 126 by Lausu Energy Resources','2023-01-21 15:28:00','',''),('8','214',558,'','2','1',1395795.00,0.00,'Payment Id 124 for invoice:126, receipt: 127 by Lausu Energy Resources','2023-01-21 15:28:00','',''),('8','214',559,'','supplier','1',0.00,1395795.00,'Payment Id 124 for invoice:126, receipt: 127 by Lausu Energy Resources','2023-01-21 15:28:00','',''),('8','214',560,'','24','7',0.00,10067400.00,'Purchase Id 30 for 32,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-22 13:21:47','',''),('8','214',561,'','supplier','1',10067400.00,0.00,'Purchase Id 30 for 32,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-22 13:21:47','',''),('8','214',562,'','20','4',1472685.00,0.00,'Sales from shift 128 on 2023-01-23 07:09:16 ','2023-01-23 07:09:16','',''),('8','214',563,'','6.1','5',0.00,1472685.00,'Sales from shift 128 on 2023-01-23 07:09:16 ','2023-01-23 07:09:16','',''),('8','214',564,'','20','4',435603.00,0.00,'Sales from shift 129 on 2023-01-23 07:12:36 ','2023-01-23 07:12:36','',''),('8','214',565,'','6.1','5',0.00,435603.00,'Sales from shift 129 on 2023-01-23 07:12:36 ','2023-01-23 07:12:36','',''),('8','214',566,'','20','4',2379719.16,0.00,'Sales from shift 130 on 2023-01-23 07:16:39 ','2023-01-23 07:16:39','',''),('8','214',567,'','6.1','5',0.00,2379719.16,'Sales from shift 130 on 2023-01-23 07:16:39 ','2023-01-23 07:16:39','',''),('8','214',568,'','20','4',3154734.54,0.00,'Sales from shift 131 on 2023-01-23 07:20:29 ','2023-01-23 07:20:29','',''),('8','214',569,'','6.1','5',0.00,3154734.54,'Sales from shift 131 on 2023-01-23 07:20:29 ','2023-01-23 07:20:29','',''),('8','214',570,'','20','4',3101701.68,0.00,'Sales from shift 132 on 2023-01-24 09:50:27 ','2023-01-24 09:50:27','',''),('8','214',571,'','6.1','5',0.00,3101701.68,'Sales from shift 132 on 2023-01-24 09:50:27 ','2023-01-24 09:50:27','',''),('8','214',572,'','2','1',1472685.00,0.00,'Payment Id 127 for invoice:128, receipt: 128 by Lausu Energy Resources','2023-01-28 14:36:40','',''),('8','214',573,'','supplier','1',0.00,1472685.00,'Payment Id 127 for invoice:128, receipt: 128 by Lausu Energy Resources','2023-01-28 14:36:40','',''),('8','214',574,'','2','1',435605.00,0.00,'Payment Id 128 for invoice:129, receipt: 129 by Lausu Energy Resources','2023-01-28 14:36:57','',''),('8','214',575,'','supplier','1',0.00,435605.00,'Payment Id 128 for invoice:129, receipt: 129 by Lausu Energy Resources','2023-01-28 14:36:57','',''),('8','214',576,'','2','1',2379720.00,0.00,'Payment Id 129 for invoice:130, receipt: 130 by Lausu Energy Resources','2023-01-28 14:37:09','',''),('8','214',577,'','supplier','1',0.00,2379720.00,'Payment Id 129 for invoice:130, receipt: 130 by Lausu Energy Resources','2023-01-28 14:37:09','',''),('8','214',578,'','24','7',0.00,16900000.00,'Purchase Id 31 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-30 15:20:03','',''),('8','214',579,'','supplier','1',16900000.00,0.00,'Purchase Id 31 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-30 15:20:03','',''),('8','214',580,'','20','4',1306433.34,0.00,'Sales from shift 133 on 2023-01-31 07:28:11 ','2023-01-31 07:28:11','',''),('8','214',581,'','6.1','5',0.00,1306433.34,'Sales from shift 133 on 2023-01-31 07:28:11 ','2023-01-31 07:28:11','',''),('8','214',582,'','20','4',2154668.88,0.00,'Sales from shift 134 on 2023-01-31 07:31:05 ','2023-01-31 07:31:05','',''),('8','214',583,'','6.1','5',0.00,2154668.88,'Sales from shift 134 on 2023-01-31 07:31:05 ','2023-01-31 07:31:05','',''),('8','214',584,'','2','1',707675.00,0.00,'Payment Id 132 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-01-31 19:35:57','',''),('8','214',585,'','supplier','1',0.00,707675.00,'Payment Id 132 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-01-31 19:35:57','',''),('8','214',586,'','2','1',2925000.00,0.00,'Payment Id 131 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-01-31 19:35:57','',''),('8','214',587,'','supplier','1',0.00,2925000.00,'Payment Id 131 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-01-31 19:35:57','',''),('8','214',588,'','20','4',1885507.80,0.00,'Sales from shift 135 on 2023-02-01 10:00:31 ','2023-02-01 10:00:31','',''),('8','214',589,'','6.1','5',0.00,1885507.80,'Sales from shift 135 on 2023-02-01 10:00:31 ','2023-02-01 10:00:31','',''),('8','214',590,'','20','4',918621.15,0.00,'Sales from shift 136 on 2023-02-03 06:26:20 ','2023-02-03 06:26:20','',''),('8','214',591,'','6.1','5',0.00,918621.15,'Sales from shift 136 on 2023-02-03 06:26:20 ','2023-02-03 06:26:20','',''),('8','214',592,'','20','4',1693201.35,0.00,'Sales from shift 137 on 2023-02-03 07:00:38 ','2023-02-03 07:00:38','',''),('8','214',593,'','6.1','5',0.00,1693201.35,'Sales from shift 137 on 2023-02-03 07:00:38 ','2023-02-03 07:00:38','',''),('8','214',594,'','2','1',1886200.00,0.00,'Payment Id 135 for invoice:135, receipt: 135 by Lausu Energy Resources','2023-02-03 15:40:34','',''),('8','214',595,'','supplier','1',0.00,1886200.00,'Payment Id 135 for invoice:135, receipt: 135 by Lausu Energy Resources','2023-02-03 15:40:34','',''),('8','214',596,'','2','1',2154670.00,0.00,'Payment Id 134 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-02-03 15:40:34','',''),('8','214',597,'','supplier','1',0.00,2154670.00,'Payment Id 134 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-02-03 15:40:34','',''),('8','214',598,'','20','4',1924868.85,0.00,'Sales from shift 138 on 2023-02-06 09:04:52 ','2023-02-06 09:04:52','',''),('8','214',599,'','6.1','5',0.00,1924868.85,'Sales from shift 138 on 2023-02-06 09:04:52 ','2023-02-06 09:04:52','',''),('8','214',600,'','20','4',2160307.20,0.00,'Sales from shift 139 on 2023-02-06 09:25:35 ','2023-02-06 09:25:35','',''),('8','214',601,'','6.1','5',0.00,2160307.20,'Sales from shift 139 on 2023-02-06 09:25:35 ','2023-02-06 09:25:35','',''),('8','214',602,'','20','4',2044621.80,0.00,'Sales from shift 140 on 2023-02-07 09:23:12 ','2023-02-07 09:23:12','',''),('8','214',603,'','6.1','5',0.00,2044621.80,'Sales from shift 140 on 2023-02-07 09:23:12 ','2023-02-07 09:23:12','',''),('8','214',604,'','2','1',1200100.00,0.00,'Payment Id 141 for invoice:139, receipt: 139 by Lausu Energy Resources','2023-02-07 13:11:56','',''),('8','214',605,'','supplier','1',0.00,1200100.00,'Payment Id 141 for invoice:139, receipt: 139 by Lausu Energy Resources','2023-02-07 13:11:56','',''),('8','214',606,'','2','1',1313970.00,0.00,'Payment Id 139 for invoice:138, receipt: 136 by Lausu Energy Resources','2023-02-07 13:14:07','',''),('8','214',607,'','supplier','1',0.00,1313970.00,'Payment Id 139 for invoice:138, receipt: 136 by Lausu Energy Resources','2023-02-07 13:14:07','',''),('8','214',608,'','2','1',1148000.00,0.00,'Payment Id 137 for invoice:137, receipt: 142 by Lausu Energy Resources','2023-02-07 13:14:55','',''),('8','214',609,'','supplier','1',0.00,1148000.00,'Payment Id 137 for invoice:137, receipt: 142 by Lausu Energy Resources','2023-02-07 13:14:55','',''),('8','214',610,'','20','4',1729422.90,0.00,'Sales from shift 141 on 2023-02-08 08:49:35 ','2023-02-08 08:49:35','',''),('8','214',611,'','6.1','5',0.00,1729422.90,'Sales from shift 141 on 2023-02-08 08:49:35 ','2023-02-08 08:49:35','',''),('8','214',612,'','24','7',0.00,11350500.00,'Purchase Id 32 for 32,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-09 08:43:50','',''),('8','214',613,'','supplier','1',11350500.00,0.00,'Purchase Id 32 for 32,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-09 08:43:50','',''),('8','214',614,'','20','4',2692987.20,0.00,'Sales from shift 142 on 2023-02-10 07:47:08 ','2023-02-10 07:47:08','',''),('8','214',615,'','6.1','5',0.00,2692987.20,'Sales from shift 142 on 2023-02-10 07:47:08 ','2023-02-10 07:47:08','',''),('8','214',616,'','20','4',2314360.05,0.00,'Sales from shift 143 on 2023-02-10 07:57:16 ','2023-02-10 07:57:16','',''),('8','214',617,'','6.1','5',0.00,2314360.05,'Sales from shift 143 on 2023-02-10 07:57:16 ','2023-02-10 07:57:16','',''),('8','214',618,'','20','4',2771933.55,0.00,'Sales from shift 144 on 2023-02-10 15:37:37 ','2023-02-10 15:37:37','',''),('8','214',619,'','6.1','5',0.00,2771933.55,'Sales from shift 144 on 2023-02-10 15:37:37 ','2023-02-10 15:37:37','',''),('8','214',620,'','20','4',2557112.40,0.00,'Sales from shift 145 on 2023-02-11 16:22:25 ','2023-02-11 16:22:25','',''),('8','214',621,'','6.1','5',0.00,2557112.40,'Sales from shift 145 on 2023-02-11 16:22:25 ','2023-02-11 16:22:25','',''),('8','214',622,'','2','1',696061.00,0.00,'Payment Id 146 for invoice:143, receipt: 243 by Lausu Energy Resources','2023-02-13 15:17:06','',''),('8','214',623,'','supplier','1',0.00,696061.00,'Payment Id 146 for invoice:143, receipt: 243 by Lausu Energy Resources','2023-02-13 15:17:06','',''),('8','214',624,'','2','1',881642.00,0.00,'Payment Id 144 for invoice:142, receipt: 142 by Lausu Energy Resources','2023-02-13 15:19:14','',''),('8','214',625,'','supplier','1',0.00,881642.00,'Payment Id 144 for invoice:142, receipt: 142 by Lausu Energy Resources','2023-02-13 15:19:14','',''),('8','214',626,'','2','1',1811390.00,0.00,'Payment Id 145 for invoice:142, receipt: 143 by Lausu Energy Resources','2023-02-13 15:19:33','',''),('8','214',627,'','supplier','1',0.00,1811390.00,'Payment Id 145 for invoice:142, receipt: 143 by Lausu Energy Resources','2023-02-13 15:19:33','',''),('8','214',628,'','2','2',347677.99,0.00,'Payment Id 143 for invoice:142, receipt: 142 by Lausu Energy Resources','2023-02-13 15:21:29','',''),('8','214',629,'','supplier','1',0.00,347677.99,'Payment Id 143 for invoice:142, receipt: 142 by Lausu Energy Resources','2023-02-13 15:21:29','',''),('8','214',630,'','2','1',1429050.00,0.00,'Payment Id 149 for invoice:144, receipt: 145 by Lausu Energy Resources','2023-02-16 13:16:19','',''),('8','214',631,'','supplier','1',0.00,1429050.00,'Payment Id 149 for invoice:144, receipt: 145 by Lausu Energy Resources','2023-02-16 13:16:19','',''),('8','214',632,'','2','1',960215.00,0.00,'Payment Id 140 for invoice:139, receipt: 239 by Lausu Energy Resources','2023-02-16 13:24:41','',''),('8','214',633,'','supplier','1',0.00,960215.00,'Payment Id 140 for invoice:139, receipt: 239 by Lausu Energy Resources','2023-02-16 13:24:41','',''),('8','214',634,'','2','1',3930180.00,0.00,'Payment Id 133 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-02-16 13:36:42','',''),('8','214',635,'','supplier','1',0.00,3930180.00,'Payment Id 133 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-02-16 13:36:42','',''),('8','214',636,'','2','1',610100.00,0.00,'Payment Id 138 for invoice:138, receipt: 127 by Lausu Energy Resources','2023-02-16 13:39:00','',''),('8','214',637,'','supplier','1',0.00,610100.00,'Payment Id 138 for invoice:138, receipt: 127 by Lausu Energy Resources','2023-02-16 13:39:00','',''),('8','214',638,'','2','1',1380425.00,0.00,'Payment Id 142 for invoice:141, receipt: 141 by Lausu Energy Resources','2023-02-16 13:40:39','',''),('8','214',639,'','supplier','1',0.00,1380425.00,'Payment Id 142 for invoice:141, receipt: 141 by Lausu Energy Resources','2023-02-16 13:40:39','',''),('8','214',640,'','24','7',0.00,7021000.00,'Purchase Id 33 for 20,650.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-17 18:23:03','',''),('8','214',641,'','supplier','1',7021000.00,0.00,'Purchase Id 33 for 20,650.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-17 18:23:03','',''),('8','214',642,'','20','4',2322629.70,0.00,'Sales from shift 146 on 2023-02-18 10:51:26 ','2023-02-18 10:51:26','',''),('8','214',643,'','6.1','5',0.00,2322629.70,'Sales from shift 146 on 2023-02-18 10:51:26 ','2023-02-18 10:51:26','',''),('8','214',644,'','20','4',1385637.30,0.00,'Sales from shift 147 on 2023-02-18 10:57:49 ','2023-02-18 10:57:49','',''),('8','214',645,'','6.1','5',0.00,1385637.30,'Sales from shift 147 on 2023-02-18 10:57:49 ','2023-02-18 10:57:49','',''),('8','214',646,'','20','4',1938809.20,0.00,'Sales from shift 148 on 2023-02-18 11:04:00 ','2023-02-18 11:04:00','',''),('8','214',647,'','6.1','5',0.00,1938809.20,'Sales from shift 148 on 2023-02-18 11:04:00 ','2023-02-18 11:04:00','',''),('8','214',648,'','20','4',2008862.80,0.00,'Sales from shift 149 on 2023-02-19 09:05:55 ','2023-02-19 09:05:55','',''),('8','214',649,'','6.1','5',0.00,2008862.80,'Sales from shift 149 on 2023-02-19 09:05:55 ','2023-02-19 09:05:55','',''),('8','214',650,'','20','4',1931880.00,0.00,'Sales from shift 150 on 2023-02-20 18:04:32 ','2023-02-20 18:04:32','',''),('8','214',651,'','6.1','5',0.00,1931880.00,'Sales from shift 150 on 2023-02-20 18:04:32 ','2023-02-20 18:04:32','',''),('8','214',652,'','2','1',2008860.00,0.00,'Payment Id 154 for invoice:149, receipt: 149 by Lausu Energy Resources','2023-02-21 14:52:22','',''),('8','214',653,'','supplier','1',0.00,2008860.00,'Payment Id 154 for invoice:149, receipt: 149 by Lausu Energy Resources','2023-02-21 14:52:22','',''),('8','214',654,'','2','1',1938810.00,0.00,'Payment Id 153 for invoice:148, receipt: 148 by Lausu Energy Resources','2023-02-21 14:52:22','',''),('8','214',655,'','supplier','1',0.00,1938810.00,'Payment Id 153 for invoice:148, receipt: 148 by Lausu Energy Resources','2023-02-21 14:52:22','',''),('8','214',656,'','2','1',1382960.00,0.00,'Payment Id 152 for invoice:147, receipt: 147 by Lausu Energy Resources','2023-02-21 15:35:37','',''),('8','214',657,'','supplier','1',0.00,1382960.00,'Payment Id 152 for invoice:147, receipt: 147 by Lausu Energy Resources','2023-02-21 15:35:37','',''),('8','214',658,'','2','1',2318800.00,0.00,'Payment Id 151 for invoice:146, receipt: 146 by Lausu Energy Resources','2023-02-21 15:37:59','',''),('8','214',659,'','supplier','1',0.00,2318800.00,'Payment Id 151 for invoice:146, receipt: 146 by Lausu Energy Resources','2023-02-21 15:37:59','',''),('8','214',660,'','2','1',2553153.00,0.00,'Payment Id 150 for invoice:145, receipt: 145 by Lausu Energy Resources','2023-02-21 15:41:11','',''),('8','214',661,'','supplier','1',0.00,2553153.00,'Payment Id 150 for invoice:145, receipt: 145 by Lausu Energy Resources','2023-02-21 15:41:11','',''),('8','214',662,'','2','1',1337471.00,0.00,'Payment Id 148 for invoice:144, receipt: 144 by Lausu Energy Resources','2023-02-21 15:46:49','',''),('8','214',663,'','supplier','1',0.00,1337471.00,'Payment Id 148 for invoice:144, receipt: 144 by Lausu Energy Resources','2023-02-21 15:46:49','',''),('8','214',664,'','24','7',0.00,14970000.00,'Purchase Id 34 for 49,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-23 09:52:20','',''),('8','214',665,'','supplier','1',14970000.00,0.00,'Purchase Id 34 for 49,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-23 09:52:20','',''),('8','214',666,'','20','4',1189146.60,0.00,'Sales from shift 151 on 2023-02-24 08:44:45 ','2023-02-24 08:44:45','',''),('8','214',667,'','6.1','5',0.00,1189146.60,'Sales from shift 151 on 2023-02-24 08:44:45 ','2023-02-24 08:44:45','',''),('8','214',668,'','20','4',1779813.00,0.00,'Sales from shift 152 on 2023-02-24 08:52:19 ','2023-02-24 08:52:19','',''),('8','214',669,'','6.1','5',0.00,1779813.00,'Sales from shift 152 on 2023-02-24 08:52:19 ','2023-02-24 08:52:19','',''),('8','214',670,'','20','4',2229936.00,0.00,'Sales from shift 153 on 2023-02-24 08:58:26 ','2023-02-24 08:58:26','',''),('8','214',671,'','6.1','5',0.00,2229936.00,'Sales from shift 153 on 2023-02-24 08:58:26 ','2023-02-24 08:58:26','',''),('8','214',672,'','2','1',1189145.00,0.00,'Payment Id 156 for invoice:151, receipt: 151 by Lausu Energy Resources','2023-02-24 15:13:43','',''),('8','214',673,'','supplier','1',0.00,1189145.00,'Payment Id 156 for invoice:151, receipt: 151 by Lausu Energy Resources','2023-02-24 15:13:43','',''),('8','214',674,'','2','1',1931880.00,0.00,'Payment Id 155 for invoice:150, receipt: 150 by Lausu Energy Resources','2023-02-24 15:13:43','',''),('8','214',675,'','supplier','1',0.00,1931880.00,'Payment Id 155 for invoice:150, receipt: 150 by Lausu Energy Resources','2023-02-24 15:13:43','',''),('8','214',676,'','2','1',542200.00,0.00,'Payment Id 136 for invoice:137, receipt: 141 by Lausu Energy Resources','2023-02-24 15:17:03','',''),('8','214',677,'','supplier','1',0.00,542200.00,'Payment Id 136 for invoice:137, receipt: 141 by Lausu Energy Resources','2023-02-24 15:17:03','',''),('8','214',678,'','20','4',1845393.00,0.00,'Sales from shift 154 on 2023-02-26 11:15:27 ','2023-02-26 11:15:27','',''),('8','214',679,'','6.1','5',0.00,1845393.00,'Sales from shift 154 on 2023-02-26 11:15:27 ','2023-02-26 11:15:27','',''),('8','214',680,'','24','7',0.00,9600000.00,'Purchase Id 35 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-26 20:07:00','',''),('8','214',681,'','supplier','1',9600000.00,0.00,'Purchase Id 35 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-26 20:07:00','',''),('8','214',682,'','20','4',2285397.00,0.00,'Sales from shift 155 on 2023-03-01 09:17:35 ','2023-03-01 09:17:35','',''),('8','214',683,'','6.1','5',0.00,2285397.00,'Sales from shift 155 on 2023-03-01 09:17:35 ','2023-03-01 09:17:35','',''),('8','214',684,'','20','4',1703271.00,0.00,'Sales from shift 156 on 2023-03-01 09:23:55 ','2023-03-01 09:23:55','',''),('8','214',685,'','6.1','5',0.00,1703271.00,'Sales from shift 156 on 2023-03-01 09:23:55 ','2023-03-01 09:23:55','',''),('8','214',686,'','2','1',2285400.00,0.00,'Payment Id 160 for invoice:155, receipt: 155 by Lausu Energy Resources','2023-03-01 13:46:47','',''),('8','214',687,'','supplier','1',0.00,2285400.00,'Payment Id 160 for invoice:155, receipt: 155 by Lausu Energy Resources','2023-03-01 13:46:47','',''),('8','214',688,'','2','1',2229935.00,0.00,'Payment Id 158 for invoice:153, receipt: 153 by Lausu Energy Resources','2023-03-01 13:46:47','',''),('8','214',689,'','supplier','1',0.00,2229935.00,'Payment Id 158 for invoice:153, receipt: 153 by Lausu Energy Resources','2023-03-01 13:46:47','',''),('8','214',690,'','2','1',1845530.00,0.00,'Payment Id 159 for invoice:154, receipt: 154 by Lausu Energy Resources','2023-03-01 13:56:12','',''),('8','214',691,'','supplier','1',0.00,1845530.00,'Payment Id 159 for invoice:154, receipt: 154 by Lausu Energy Resources','2023-03-01 13:56:12','',''),('8','214',692,'','2','1',1779815.00,0.00,'Payment Id 157 for invoice:152, receipt: 152 by Lausu Energy Resources','2023-03-01 13:58:45','',''),('8','214',693,'','supplier','1',0.00,1779815.00,'Payment Id 157 for invoice:152, receipt: 152 by Lausu Energy Resources','2023-03-01 13:58:45','',''),('8','214',694,'','2','1',1703270.00,0.00,'Payment Id 161 for invoice:156, receipt: 156 by Lausu Energy Resources','2023-03-01 16:29:38','',''),('8','214',695,'','supplier','1',0.00,1703270.00,'Payment Id 161 for invoice:156, receipt: 156 by Lausu Energy Resources','2023-03-01 16:29:38','',''),('8','214',696,'','20','4',3592485.00,0.00,'Sales from shift 157 on 2023-03-02 09:33:27 ','2023-03-02 09:33:27','',''),('8','214',697,'','6.1','5',0.00,3592485.00,'Sales from shift 157 on 2023-03-02 09:33:27 ','2023-03-02 09:33:27','',''),('8','214',698,'','20','4',1643037.00,0.00,'Sales from shift 158 on 2023-03-02 09:38:02 ','2023-03-02 09:38:02','',''),('8','214',699,'','6.1','5',0.00,1643037.00,'Sales from shift 158 on 2023-03-02 09:38:02 ','2023-03-02 09:38:02','',''),('8','214',700,'','2','1',3592485.00,0.00,'Payment Id 162 for invoice:157, receipt: 157 by Lausu Energy Resources','2023-03-03 13:31:19','',''),('8','214',701,'','supplier','1',0.00,3592485.00,'Payment Id 162 for invoice:157, receipt: 157 by Lausu Energy Resources','2023-03-03 13:31:19','',''),('8','214',702,'','20','4',1755867.00,0.00,'Sales from shift 159 on 2023-03-03 20:34:28 ','2023-03-03 20:34:28','',''),('8','214',703,'','6.1','5',0.00,1755867.00,'Sales from shift 159 on 2023-03-03 20:34:28 ','2023-03-03 20:34:28','',''),('8','214',704,'','20','4',2225586.00,0.00,'Sales from shift 160 on 2023-03-04 09:29:19 ','2023-03-04 09:29:19','',''),('8','214',705,'','6.1','5',0.00,2225586.00,'Sales from shift 160 on 2023-03-04 09:29:19 ','2023-03-04 09:29:19','',''),('8','214',706,'','20','4',2023503.00,0.00,'Sales from shift 161 on 2023-03-05 18:59:41 ','2023-03-05 18:59:41','',''),('8','214',707,'','6.1','5',0.00,2023503.00,'Sales from shift 161 on 2023-03-05 18:59:41 ','2023-03-05 18:59:41','',''),('8','214',708,'','24','7',0.00,5130000.00,'Purchase Id 36 for 17,100.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-06 12:07:53','',''),('8','214',709,'','supplier','1',5130000.00,0.00,'Purchase Id 36 for 17,100.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-06 12:07:53','',''),('8','214',710,'','2','1',2023500.00,0.00,'Payment Id 165 for invoice:161, receipt: 161 by Lausu Energy Resources','2023-03-06 13:23:02','',''),('8','214',711,'','supplier','1',0.00,2023500.00,'Payment Id 165 for invoice:161, receipt: 161 by Lausu Energy Resources','2023-03-06 13:23:02','',''),('8','214',712,'','2','1',1755870.00,0.00,'Payment Id 164 for invoice:159, receipt: 159 by Lausu Energy Resources','2023-03-06 13:23:02','',''),('8','214',713,'','supplier','1',0.00,1755870.00,'Payment Id 164 for invoice:159, receipt: 159 by Lausu Energy Resources','2023-03-06 13:23:02','',''),('8','214',714,'','2','1',1643040.00,0.00,'Payment Id 163 for invoice:158, receipt: 158 by Lausu Energy Resources','2023-03-06 13:23:02','',''),('8','214',715,'','supplier','1',0.00,1643040.00,'Payment Id 163 for invoice:158, receipt: 158 by Lausu Energy Resources','2023-03-06 13:23:02','',''),('8','214',716,'','20','4',1554339.00,0.00,'Sales from shift 162 on 2023-03-08 09:04:47 ','2023-03-08 09:04:47','',''),('8','214',717,'','6.1','5',0.00,1554339.00,'Sales from shift 162 on 2023-03-08 09:04:47 ','2023-03-08 09:04:47','',''),('8','214',718,'','20','4',1727094.00,0.00,'Sales from shift 163 on 2023-03-08 09:12:39 ','2023-03-08 09:12:39','',''),('8','214',719,'','6.1','5',0.00,1727094.00,'Sales from shift 163 on 2023-03-08 09:12:39 ','2023-03-08 09:12:39','',''),('8','214',720,'','2','1',1727095.00,0.00,'Payment Id 167 for invoice:163, receipt: 163 by Lausu Energy Resources','2023-03-09 12:45:53','',''),('8','214',721,'','supplier','1',0.00,1727095.00,'Payment Id 167 for invoice:163, receipt: 163 by Lausu Energy Resources','2023-03-09 12:45:53','',''),('8','214',722,'','2','1',1553740.00,0.00,'Payment Id 166 for invoice:162, receipt: 162 by Lausu Energy Resources','2023-03-09 12:46:39','',''),('8','214',723,'','supplier','1',0.00,1553740.00,'Payment Id 166 for invoice:162, receipt: 162 by Lausu Energy Resources','2023-03-09 12:46:39','',''),('8','214',724,'','20','4',2955081.00,0.00,'Sales from shift 164 on 2023-03-09 13:34:21 ','2023-03-09 13:34:21','',''),('8','214',725,'','6.1','5',0.00,2955081.00,'Sales from shift 164 on 2023-03-09 13:34:21 ','2023-03-09 13:34:21','',''),('8','214',726,'','20','4',1382328.00,0.00,'Sales from shift 165 on 2023-03-09 13:37:31 ','2023-03-09 13:37:31','',''),('8','214',727,'','6.1','5',0.00,1382328.00,'Sales from shift 165 on 2023-03-09 13:37:31 ','2023-03-09 13:37:31','',''),('8','214',728,'','24','7',0.00,9900000.00,'Purchase Id 37 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-12 13:21:36','',''),('8','214',729,'','supplier','1',9900000.00,0.00,'Purchase Id 37 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-12 13:21:36','',''),('8','214',730,'','20','4',981882.00,0.00,'Sales from shift 166 on 2023-03-14 08:27:04 ','2023-03-14 08:27:04','',''),('8','214',731,'','6.1','5',0.00,981882.00,'Sales from shift 166 on 2023-03-14 08:27:04 ','2023-03-14 08:27:04','',''),('8','214',732,'','20','4',1807320.00,0.00,'Sales from shift 167 on 2023-03-14 08:39:32 ','2023-03-14 08:39:32','',''),('8','214',733,'','6.1','5',0.00,1807320.00,'Sales from shift 167 on 2023-03-14 08:39:32 ','2023-03-14 08:39:32','',''),('8','214',734,'','20','4',1543785.00,0.00,'Sales from shift 168 on 2023-03-14 09:01:17 ','2023-03-14 09:01:17','',''),('8','214',735,'','6.1','5',0.00,1543785.00,'Sales from shift 168 on 2023-03-14 09:01:17 ','2023-03-14 09:01:17','',''),('8','214',736,'','20','4',1540365.00,0.00,'Sales from shift 169 on 2023-03-16 09:37:06 ','2023-03-16 09:37:06','',''),('8','214',737,'','6.1','5',0.00,1540365.00,'Sales from shift 169 on 2023-03-16 09:37:06 ','2023-03-16 09:37:06','',''),('8','214',738,'','24','7',0.00,14940000.00,'Purchase Id 38 for 49,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-17 08:26:46','',''),('8','214',739,'','supplier','1',14940000.00,0.00,'Purchase Id 38 for 49,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-17 08:26:46','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'8','214','PMS','Petrol','Litres',0,300.00,0.00,0.00,0.00,0.00,0,'2022-08-06 01:52:28','923','923','2022-08-06 01:52:28',0),(2,'8','214','AGO','Diesel','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-08-06 01:56:32','923','923','2022-08-06 01:56:32',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'8','214',1,215.00,0.00,0.00,0.00,'Cost from purchase id #1','2022-08-10 09:40:30','927'),(2,'8','214',1,207.00,0.00,0.00,0.00,'Cost from purchase id #3','2022-08-21 08:12:15','927'),(3,'8','214',1,200.00,0.00,0.00,0.00,'Cost from purchase id #4','2022-08-23 15:11:28','927'),(4,'8','214',1,207.00,0.00,0.00,0.00,'Cost from purchase id #5','2022-08-28 17:21:53','927'),(5,'8','214',1,190.00,0.00,0.00,0.00,'Cost from purchase id #6','2022-08-30 13:43:48','927'),(6,'8','214',1,203.00,0.00,0.00,0.00,'Cost from purchase id #14','2022-10-10 11:20:20','927'),(7,'8','214',1,235.00,0.00,0.00,0.00,'Cost from purchase id #15','2022-10-21 21:18:47','927'),(8,'8','214',1,240.00,0.00,0.00,0.00,'Cost from purchase id #16','2022-10-26 09:58:44','927'),(9,'8','214',1,255.00,0.00,0.00,0.00,'Cost from purchase id #17','2022-11-05 11:04:18','927'),(10,'8','214',1,260.00,0.00,0.00,0.00,'Cost from purchase id #20','2022-11-20 11:05:00','927'),(11,'8','214',1,270.00,0.00,0.00,0.00,'Cost from purchase id #22','2022-12-06 10:26:11','927'),(12,'8','214',1,315.00,0.00,0.00,0.00,'Cost from purchase id #23','2022-12-14 21:43:14','927'),(13,'8','214',1,305.00,0.00,0.00,0.00,'Cost from purchase id #24','2022-12-25 14:15:48','927'),(14,'8','214',1,300.00,0.00,0.00,0.00,'Cost from purchase id #25','2022-12-29 13:00:39','927'),(15,'8','214',1,306.00,0.00,0.00,0.00,'Cost from purchase id #30','2023-01-22 13:21:47','927'),(16,'8','214',1,338.00,0.00,0.00,0.00,'Cost from purchase id #31','2023-01-30 15:20:03','927'),(17,'8','214',1,345.00,0.00,0.00,0.00,'Cost from purchase id #32','2023-02-09 08:43:50','927'),(18,'8','214',1,340.00,0.00,0.00,0.00,'Cost from purchase id #33','2023-02-17 18:23:03','927'),(19,'8','214',1,300.00,0.00,0.00,0.00,'Cost from purchase id #34','2023-02-23 09:52:20','927');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'8','214','2022-08-09',1,1,215.00,55000.00,0.00,0.00,11825000.00,0.00,'','00017','NSR 435 ZS','','','','2022-08-09 15:49:36',15,'Purchase of PM\'s ','923','467','2022-08-10 09:36:41','927','2022-08-10 09:40:30'),(2,'8','214','2022-08-13',1,1,215.00,49400.00,0.00,0.00,10621000.00,0.00,'','0016','BCH428XA','','','','2022-08-13 16:02:21',15,'Purchase of pms','923','','0000-00-00 00:00:00','927','2022-08-13 21:17:58'),(3,'8','214','2022-08-18',1,1,207.00,16850.00,0.00,0.00,3487950.00,0.00,'','00026','DKA705ZP','','','','2022-08-20 10:38:53',2,'Purchase of PM\'s','923','','0000-00-00 00:00:00','927','2022-08-21 08:33:57'),(4,'8','214','2022-08-23',1,1,200.00,17000.00,0.00,0.00,3400000.00,0.00,'','022','GML594XA','','','','2022-08-23 08:33:28',15,'Purchase of PM\'s','923','','0000-00-00 00:00:00','927','2022-08-23 15:11:28'),(5,'8','214','2022-08-18',1,1,207.00,16850.00,0.00,0.00,3487950.00,0.00,'','0016','DKA705ZP','','','','2022-08-28 17:16:53',15,'Purchase of PM\'s','923','','0000-00-00 00:00:00','927','2022-08-28 17:21:53'),(6,'8','214','2022-08-30',1,1,190.00,49800.00,0.00,0.00,9462000.00,0.00,'','0018','RAN32XF','','','','2022-08-30 10:11:33',15,'Purchase of PM\'s','923','','0000-00-00 00:00:00','927','2022-08-30 13:43:48'),(7,'8','214','2022-08-31',1,1,190.00,18000.00,0.00,0.00,3420000.00,0.00,'','0019','NSR435ZS','','','','2022-08-31 12:05:41',15,'Purchase of PM\'s','923','','0000-00-00 00:00:00','467','2022-09-01 15:59:53'),(8,'8','214','2022-09-06',1,1,190.00,33000.00,0.00,0.00,6270000.00,0.00,'','00028','BCH424XA','','','','2022-09-06 10:30:12',15,'PURCHASE OF PM\'S','923','','0000-00-00 00:00:00','927','2022-09-06 17:56:36'),(9,'8','214','2022-09-14',1,1,190.00,49900.00,0.00,0.00,9481000.00,0.00,'','00032','RAN683XA','','','','2022-09-14 08:48:59',15,'Purchase of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-14 21:57:34'),(10,'8','214','2022-09-17',1,1,190.00,17000.00,0.00,0.00,3230000.00,0.00,'','008','GML594XA','','','','2022-09-17 13:18:17',15,'Purchase of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-20 12:26:01'),(11,'8','214','2022-09-22',1,1,190.00,49350.00,0.00,0.00,9376500.00,0.00,'','00033','DKA705ZP','','','','2022-09-22 18:34:41',15,'PURCHASE OF PM\'S','923','','0000-00-00 00:00:00','927','2022-09-23 08:24:08'),(12,'8','214','2022-09-27',1,1,190.00,18000.00,0.00,0.00,3420000.00,0.00,'','00037','WDL813XA','','','','2022-09-27 13:54:39',15,'PURCHACES OF PM\'S','923','','0000-00-00 00:00:00','927','2022-09-28 10:08:27'),(13,'8','214','2022-10-07',1,1,190.00,17000.00,0.00,0.00,3230000.00,0.00,'','00050','RAN32XF','','','','2022-10-07 08:03:51',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2022-10-07 11:17:42'),(14,'8','214','2022-10-09',1,1,203.00,28700.00,0.00,0.00,5826100.00,0.00,'','00551','NSR56ZQ','','','','2022-10-09 18:48:36',15,'Purchase of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-10 11:20:20'),(15,'8','214','2022-10-21',1,1,235.00,17950.00,0.00,0.00,4218250.00,0.00,'','00405','NSR435ZS','','','','2022-10-21 08:32:06',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2022-10-21 21:18:47'),(16,'8','214','2022-10-25',1,1,240.00,19500.00,0.00,0.00,4680000.00,0.00,'','00563','NSR57ZQ','','','','2022-10-25 12:52:10',15,'PURCHASED OF PM\'S','923','','0000-00-00 00:00:00','927','2022-10-26 09:58:44'),(17,'8','214','2022-11-05',1,1,255.00,32800.00,0.00,0.00,8364000.00,0.00,'','002','RAN33XF','','','','2022-11-05 09:25:17',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2022-11-05 11:04:18'),(18,'8','214','2022-11-08',1,1,255.00,17000.00,0.00,0.00,4335000.00,0.00,'','00051','GML594XA','','','','2022-11-08 07:15:54',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2022-11-08 13:04:19'),(19,'8','214','2022-11-15',1,1,255.00,16700.00,0.00,0.00,4258500.00,0.00,'','00428','DKA705ZP','','','','2022-11-15 22:31:56',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2022-11-16 13:27:17'),(20,'8','214','2022-11-20',1,1,260.00,33000.00,0.00,0.00,8580000.00,0.00,'','00021','RAN33XF','','','','2022-11-20 08:13:16',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2022-11-20 11:05:00'),(21,'8','214','2022-11-24',1,1,260.00,34150.00,0.00,0.00,8879000.00,0.00,'','00001','NSR57ZQ','','','','2022-11-24 12:19:37',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2022-11-24 12:42:32'),(22,'8','214','2022-12-06',1,1,270.00,33200.00,0.00,0.00,8964000.00,0.00,'','00433','GML594XA','','','','2022-12-06 09:41:51',15,'Purchase of pms','923','','0000-00-00 00:00:00','927','2022-12-06 10:26:11'),(23,'8','214','2022-12-14',1,1,315.00,49650.00,0.00,0.00,15639750.00,0.00,'','00012','KMC756ZS','','','','2022-12-14 16:58:15',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2022-12-14 21:43:14'),(24,'8','214','2022-12-25',1,1,305.00,18000.00,0.00,0.00,5490000.00,0.00,'','00081','NSR435ZS','','','','2022-12-25 07:49:54',15,'PURCHASE OF PMS','923','','0000-00-00 00:00:00','927','2022-12-25 14:15:48'),(25,'8','214','2022-12-29',1,1,300.00,49850.00,0.00,0.00,14955000.00,0.00,'','0071','RAN32XF','','','','2022-12-29 10:28:09',15,'PURCHASE OF PMS','923','','0000-00-00 00:00:00','927','2022-12-29 13:00:39'),(26,'8','214','2023-01-02',1,1,300.00,34100.00,0.00,0.00,10230000.00,0.00,'','0072','NSR572ZS','','','','2023-01-02 12:27:09',15,'PURCHASE OF PMS','923','','0000-00-00 00:00:00','927','2023-01-03 17:15:12'),(27,'8','214','2023-01-06',1,1,300.00,20850.00,0.00,0.00,6255000.00,0.00,'','00448','NSR56ZQ','','','','2023-01-06 11:04:20',15,'PURCHASE OF PMS','923','','0000-00-00 00:00:00','927','2023-01-07 15:34:29'),(28,'8','214','2023-01-12',1,1,300.00,16850.00,0.00,0.00,5055000.00,0.00,'','00613','GML594XA','','','','2023-01-12 10:57:11',15,'PURCHASED OF PMS','923','','0000-00-00 00:00:00','927','2023-01-13 12:26:42'),(29,'8','214','2023-01-17',1,1,300.00,14750.00,0.00,0.00,4425000.00,0.00,'','00061','RAN441XA','','','','2023-01-18 08:08:07',15,'Purchase of pms','923','','0000-00-00 00:00:00','927','2023-01-18 14:43:24'),(30,'8','214','2023-01-21',1,1,306.00,32900.00,0.00,0.00,10067400.00,0.00,'','00459','BCH428XA','','','','2023-01-21 10:58:28',15,'PURCHASE OF PM\'S','923','','0000-00-00 00:00:00','927','2023-01-22 13:21:47'),(31,'8','214','2023-01-30',1,1,338.00,50000.00,0.00,0.00,16900000.00,0.00,'','00087','NSR435ZS','','','','2023-01-30 10:50:37',15,'Purchase of pms','923','','0000-00-00 00:00:00','927','2023-01-30 15:20:03'),(32,'8','214','2023-02-08',1,1,345.00,32900.00,0.00,0.00,11350500.00,0.00,'','00624','RAN683XA','','','','2023-02-08 10:27:59',15,'PURCHASE OF PMS','923','','0000-00-00 00:00:00','927','2023-02-09 08:43:50'),(33,'8','214','2023-02-16',1,1,340.00,20650.00,0.00,0.00,7021000.00,0.00,'','00634','NSR86ZX','','','','2023-02-17 11:02:57',15,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-17 18:23:03'),(34,'8','214','2023-02-22',1,1,300.00,49900.00,0.00,0.00,14970000.00,0.00,'','0087','RAN32XF','','','','2023-02-22 15:42:29',15,'Purchase of pms','923','','0000-00-00 00:00:00','927','2023-02-23 09:52:20'),(35,'8','214','2023-02-24',1,1,300.00,32000.00,0.00,0.00,9600000.00,0.00,'','00089','NSR435ZS','','','','2023-02-26 11:19:28',15,'Purchase of pms','923','','0000-00-00 00:00:00','927','2023-02-26 20:07:00'),(36,'8','214','2023-03-02',1,1,300.00,17100.00,0.00,0.00,5130000.00,0.00,'','0097','DKA705ZP','','','','2023-03-03 20:43:22',15,'Purchase of pms','923','','0000-00-00 00:00:00','927','2023-03-06 12:07:53'),(37,'8','214','2023-03-11',1,1,300.00,33000.00,0.00,0.00,9900000.00,0.00,'','00650','BCH424XA','','','','2023-03-11 12:14:15',15,'Purchase of pms','923','','0000-00-00 00:00:00','927','2023-03-12 13:21:36'),(38,'8','214','2023-03-16',1,1,300.00,49800.00,0.00,0.00,14940000.00,0.00,'','00081','NSR57ZQ','','','','2023-03-17 08:18:24',10,'Purchase of pms','923','','0000-00-00 00:00:00','927','2023-03-17 08:26:46');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'8','214','2022-08-10',1,'01','','5',2367670.00,'2','','','1','Malam madori station','1082022',2367562.80,'2022-08-10 23:23:17',5,'Payment invoice for malam madori','923','','0000-00-00 00:00:00','923','2022-08-11 17:37:14'),(2,'8','214','2022-08-11',1,'02','','5',1226095.00,'3','','','1','Malam madori station','1182022',1226095.55,'2022-08-11 22:46:30',5,'Payment of pms','923','','0000-00-00 00:00:00','923','2022-08-11 22:48:56'),(3,'8','214','2022-08-12',1,'03','','5',1199140.00,'4','','','1','Malam madori station','1282022',1199143.15,'2022-08-12 22:16:21',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-08-14 09:53:57'),(4,'8','214','2022-08-13',1,'04','','5',1230255.00,'4','','','1','Malam madori station','1382022',1230257.95,'2022-08-13 22:39:11',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-08-14 09:53:27'),(5,'8','214','2022-08-15',1,'05','','5',1111145.00,'6','','','1','Malam madori station','1482022',1111472.60,'2022-08-15 06:45:56',5,'Payment of pms','923','','0000-00-00 00:00:00','467','2022-08-23 14:00:05'),(6,'8','214','2022-08-15',1,'06','','5',1086545.00,'7','','','1','Malam madori station','1582022',1086545.50,'2022-08-15 21:43:29',5,'Payment of pms','923','','0000-00-00 00:00:00','467','2022-08-23 14:00:37'),(7,'8','214','2022-08-16',1,'07','','5',1160890.00,'8','','','1','Malam madori station','1682022',1160890.35,'2022-08-16 22:22:11',5,'Payment of PM\'s ','923','','0000-00-00 00:00:00','467','2022-08-23 14:02:31'),(8,'8','214','2022-08-17',1,'07','','5',1370785.00,'9','','','1','Malam madori station','1782022',1370785.05,'2022-08-20 10:21:09',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','467','2022-08-23 14:02:31'),(9,'8','214','2022-08-17',1,'08','','5',1025100.00,'10','','','1','Malam madori station','2502035',1025099.19,'2022-08-20 10:28:52',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','467','2022-08-23 14:02:31'),(10,'8','214','2022-08-18',1,'09','','5',1142560.00,'11','','','1','Malam madori station','2502036',1142561.34,'2022-08-20 10:36:28',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','467','2022-08-23 14:02:31'),(11,'8','214','2022-08-20',1,'09','','5',885080.00,'13','','','1','Malam madori station','2082022',885078.18,'2022-08-21 08:02:44',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','467','2022-08-23 14:02:31'),(12,'8','214','2022-08-21',1,'10','','5',1098300.00,'13','','','1','Malam madori station','2182022',1098300.60,'2022-08-21 19:28:38',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','467','2022-08-23 14:02:31'),(13,'8','214','2022-08-22',1,'10','','5',1212650.00,'14','','','1','Malam madori station','2282022',1212602.00,'2022-08-22 13:06:48',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','467','2022-08-23 14:02:31'),(14,'8','214','2022-08-23',1,'10','','5',885650.00,'15','','','1','Malam madori station','2382022',885634.00,'2022-08-23 11:51:14',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-08-29 22:17:24'),(15,'8','214','2022-08-24',1,'11','','5',1395600.00,'16','','','1','Malam madori station','2482022',1395598.00,'2022-08-24 15:48:43',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-08-25 15:14:31'),(16,'8','214','2022-08-25',1,'11','','5',892375.00,'17','','','1','Malam madori station','2582022',892374.90,'2022-08-25 14:09:56',5,'Purchase of PM\'s','923','','0000-00-00 00:00:00','927','2022-08-25 15:14:31'),(17,'8','214','2022-08-26',1,'12','','5',982715.00,'18','','','1','Malam madori station','2682022',982714.20,'2022-08-26 10:33:22',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-08-29 22:17:24'),(18,'8','214','2022-08-28',1,'13','','5',1179390.00,'19','','','1','Malam madori station','2682022',1179388.90,'2022-08-28 15:37:32',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-08-29 22:17:24'),(20,'8','214','2022-08-28',1,'14','','5',1155880.00,'20','','','1','Malam madori station','2882022',1155880.20,'2022-08-28 21:41:38',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-08-29 22:17:24'),(22,'8','214','2022-08-29',1,'15','','5',1081010.00,'21','','','1','Malam madori station','2982022',1081008.80,'2022-08-29 22:16:16',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-08-29 22:17:24'),(23,'8','214','2022-08-30',1,'16','','5',1079320.00,'22','','','1','Malam madori station','3082022',1079319.70,'2022-08-30 13:28:53',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','467','2022-09-01 15:45:37'),(24,'8','214','2022-08-31',1,'16','','5',2764155.00,'23','','','1','Malam madori station','3182022',2764154.20,'2022-09-01 08:33:54',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','467','2022-09-01 15:44:53'),(25,'8','214','2022-09-02',1,'17','','5',1047895.00,'24','','','1','Malam madori station','0292022',1047895.60,'2022-09-02 10:13:15',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-09-04 19:45:09'),(26,'8','214','2022-09-01',1,'18','','5',1155580.00,'26','','','1','Malam madori station','0192022',1155581.90,'2022-09-03 08:34:57',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-09-04 19:45:09'),(27,'8','214','2022-09-04',1,'18','','5',1318930.00,'26','','','1','Malam madori station','0492022',1318926.80,'2022-09-04 08:28:51',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-09-04 19:45:18'),(28,'8','214','2022-09-04',1,'19','','5',1282500.00,'27','','','1','Malam madori station','0492022',1282501.90,'2022-09-04 19:43:04',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','923','2022-09-04 19:45:09'),(29,'8','214','2022-09-05',1,'19','','5',880865.00,'28','','','1','Malam madori station','0592022',880862.80,'2022-09-05 19:20:16',5,'Payment of PM\'s','923','927','2022-09-08 13:30:55','927','2022-09-08 13:31:57'),(30,'8','214','2022-09-07',1,'20','','5',823050.00,'29','','','1','Malam madori station','0692022',823047.70,'2022-09-07 08:14:28',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-08 13:32:14'),(31,'8','214','2022-09-08',1,'20','','5',1867000.00,'30','','','1','Malam madori station','0792022',1866998.90,'2022-09-08 08:19:02',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-08 13:32:30'),(32,'8','214','2022-09-09',1,'021','','5',671400.00,'31','','','1','Malam madori station','892022',671399.20,'2022-09-09 08:39:42',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-14 21:41:59'),(33,'8','214','2022-09-10',1,'022','','5',854455.00,'32','','','1','Malam madori station','09092022',854454.70,'2022-09-10 07:43:45',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-14 21:41:59'),(34,'8','214','2022-09-11',1,'023','','5',572090.00,'33','','','1','Malam madori station','1092022',572090.00,'2022-09-11 08:18:21',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-14 21:41:59'),(35,'8','214','2022-09-12',1,'024','','5',589790.00,'34','','','1','Malam madori station','1192022',589792.30,'2022-09-12 07:48:27',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-14 21:41:59'),(36,'8','214','2022-09-13',1,'025','','5',662770.00,'35','','','1','Malam madori station','12092022',662771.30,'2022-09-13 08:32:09',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-14 21:42:46'),(37,'8','214','2022-09-13',1,'','','5',1301220.00,'36','','','1','Malam madori station','13092022',1301220.70,'2022-09-13 17:13:31',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-14 21:42:46'),(38,'8','214','2022-09-15',1,'024','','5',2914250.00,'37','','','1','Malam madori station','14092022',2914251.30,'2022-09-15 07:50:27',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-09-17 07:52:43'),(39,'8','214','2022-09-15',1,'026','','5',944530.00,'38','','','1','Malam madori station','15092022',944529.90,'2022-09-16 07:59:58',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-17 07:43:15'),(40,'8','214','2022-09-16',1,'027','','5',1135000.00,'39','','','1','Malam madori station','16092022',1135006.80,'2022-09-17 08:06:26',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-21 14:53:57'),(41,'8','214','2022-09-18',1,'027','','5',1168190.00,'40','','','1','Malam madori station','17092022',1168192.20,'2022-09-18 09:41:46',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-21 14:53:57'),(42,'8','214','2022-09-20',1,'026','','5',1191095.00,'41','','','1','Malam madori station','20092022',1191094.80,'2022-09-20 08:22:39',5,'Payment of PMS','923','','0000-00-00 00:00:00','927','2022-09-21 14:53:57'),(43,'8','214','2022-09-20',1,'028','','5',1321080.00,'42','','','1','Malam madori station','19092022',1321079.50,'2022-09-20 08:27:27',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-21 14:53:57'),(44,'8','214','2022-09-20',1,'029','','5',1134590.00,'43','','','1','Malam madori station','20092022',1134590.70,'2022-09-21 08:44:23',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-21 14:54:21'),(45,'8','214','2022-09-22',1,'030','','5',2652850.00,'44','','','1','Malam madori station','2192022',2652852.20,'2022-09-22 09:05:18',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-28 13:47:00'),(46,'8','214','2022-09-24',1,'031','','5',1211780.00,'46','','','1','Malam madori station','2392022',1211793.40,'2022-09-24 08:28:04',5,'Payment of PM\'s','923','927','2022-09-28 13:46:15','927','2022-09-28 13:47:00'),(47,'8','214','2022-09-25',1,'032','','5',1310045.00,'47','','','1','Malam madori station','24092022',1310044.30,'2022-09-25 08:51:32',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-28 13:45:30'),(48,'8','214','2022-09-25',1,'033','','5',1381160.00,'48','','','1','Malam madori station','25092022',1381161.30,'2022-09-26 12:23:02',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-09-28 13:45:30'),(49,'8','214','2022-09-26',1,'034','','5',1385465.00,'49','','','1','Malam madori station','26092022',1385464.80,'2022-09-27 08:08:16',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-28 13:45:30'),(50,'8','214','2022-09-27',1,'','','5',1313540.00,'50','','','1','Malam madori station','27092022',1313542.20,'2022-09-28 10:02:22',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-28 13:45:30'),(51,'8','214','2022-09-29',1,'035','','5',3364010.00,'51','','','1','Malam madori station','28092022',3364012.70,'2022-09-29 08:09:55',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-09-29 22:06:56'),(52,'8','214','2022-09-29',1,'037','','5',873665.00,'52','','','1','Malam madori station','29092022',873663.70,'2022-09-30 07:49:31',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-03 11:29:03'),(53,'8','214','2022-09-30',1,'038','','5',668060.00,'53','','','1','Malam madori station','30092022',668005.80,'2022-10-01 07:05:21',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-03 11:29:03'),(54,'8','214','2022-10-02',1,'039','','5',835105.00,'54','','','1','Malam madori station','02102022',835264.70,'2022-10-02 08:44:06',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-03 11:29:03'),(55,'8','214','2022-10-02',1,'040','','5',872260.00,'55','','','1','Malam madori station','02102022',872210.20,'2022-10-03 06:24:21',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-03 11:29:03'),(57,'8','214','2022-10-03',1,'041','','5',720930.00,'57','','','1','Malam madori station','021022',720936.00,'2022-10-03 11:04:48',5,'Payment of pms','923','927','2022-10-06 20:03:25','927','2022-10-06 20:03:36'),(58,'8','214','2022-10-03',1,'042','','5',302180.00,'57','','','1','Malam madori station','031022',302181.70,'2022-10-03 11:05:41',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-06 20:03:59'),(59,'8','214','2022-09-22',1,'04','','5',1141700.00,'57','','','1','Malam madori station','220922',1141702.40,'2022-10-03 11:07:20',5,'Payment of PM\'s','923','927','2022-10-12 16:58:10','927','2022-10-12 16:58:30'),(60,'8','214','2022-10-04',1,'01','','5',391890.00,'58','','','1','Malam madori station','04102022',391890.00,'2022-10-04 19:04:30',5,'Payment of PM\'s','923','467','2022-10-07 12:30:04','927','2022-10-09 06:40:11'),(61,'8','214','2022-10-04',1,'02','','5',2107925.00,'61','','','1','Malam madori station','04102032',2107924.60,'2022-10-07 14:23:23',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-09 06:40:11'),(62,'8','214','2022-10-05',1,'04','','5',1320300.00,'61','','','1','Malam madori station','051022',1320300.50,'2022-10-07 14:24:50',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-09 06:40:11'),(63,'8','214','2022-10-07',1,'05','','5',207400.00,'62','','','1','Malam madori station','06102022',207398.30,'2022-10-07 14:29:13',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-09 06:40:11'),(64,'8','214','2022-10-08',1,'06','','5',588830.00,'63','','','1','Malam madori station','08102022',588829.00,'2022-10-08 10:14:23',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-10 12:33:20'),(65,'8','214','2022-10-10',1,'07','','5',1713700.00,'65','','','1','Malam madori station','10102022',1713699.61,'2022-10-10 13:24:54',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-12 16:45:38'),(66,'8','214','2022-10-11',1,'09','','5',2262950.00,'66','','','1','Malam madori station','11102022',2262950.62,'2022-10-12 06:11:14',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-12 16:45:38'),(67,'8','214','2022-10-12',1,'10','','5',2484050.00,'67','','','1','Malam madori station','12102022',2484046.88,'2022-10-13 08:13:21',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-20 13:50:01'),(68,'8','214','2022-10-12',1,'008','','5',1230330.00,'68','','','1','Malam madori station','18102022',1230332.40,'2022-10-22 10:44:24',5,'Payments of PM\'s','923','','0000-00-00 00:00:00','927','2022-11-01 16:09:27'),(69,'8','214','2022-10-22',1,'010','','5',1969290.00,'69','','','1','Malam madori station','22102022',1969290.60,'2022-10-22 10:50:57',5,'PAYMENT OF PM\'S','923','','0000-00-00 00:00:00','927','2022-10-24 15:41:33'),(70,'8','214','2022-10-23',1,'012','','5',1296010.00,'70','','','1','Malam madori station','23102022',1296007.20,'2022-10-24 08:47:25',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-24 15:41:33'),(71,'8','214','2022-10-23',1,'12','','5',978720.00,'71','','','1','Malam madori station','24102022',978717.60,'2022-10-27 11:17:53',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-10-31 17:19:06'),(72,'8','214','2022-10-25',1,'13','','5',2931920.00,'72','','','1','Malam madori station','25102022',2931921.60,'2022-10-27 11:21:32',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-10-31 17:18:48'),(73,'8','214','2022-10-27',1,'15','','5',1087460.00,'73','','','1','Malam madori station','27102022',1087460.00,'2022-10-28 07:55:20',5,'Payment of PM\'s','923','','0000-00-00 00:00:00','927','2022-11-01 16:42:51'),(74,'8','214','2022-10-27',1,'009','','5',420000.00,'74','','','1','Malam madori station','271102022',769235.00,'2022-11-06 10:22:40',5,'Payment of pms','923','927','2022-11-09 12:58:18','927','2022-11-09 12:59:42'),(75,'8','214','2022-11-06',1,'002','','5',1538935.00,'75','','','1','Malam madori station','06112022',1538927.55,'2022-11-07 10:47:18',5,'Payment of PM\'s','923','927','2022-11-07 12:17:10','927','2022-11-07 12:17:50'),(76,'8','214','2022-11-07',1,'0012','','5',1912075.00,'76','','','1','Malam madori station','07112022',1912076.70,'2022-11-08 06:24:13',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-11-09 12:39:13'),(77,'8','214','2022-11-09',1,'0028','','5',3964130.00,'78','','','1','Malam madori station','09112022',3964130.55,'2022-11-09 16:23:06',5,'PAYMENT OF PMS','923','','0000-00-00 00:00:00','927','2022-11-15 13:47:39'),(78,'8','214','2022-10-27',1,'0021','','5',349230.00,'78','','','1','Malam madori station','2710',349235.00,'2022-11-09 16:25:24',5,'PAYMENT OF PMS','923','927','2022-11-15 13:48:37','927','2022-11-15 13:48:44'),(79,'8','214','2022-11-10',1,'003','','5',1732185.00,'79','','','1','Malam madori station','10112022',1732186.95,'2022-11-11 08:17:46',5,'PAYMENT OF PMS','923','','0000-00-00 00:00:00','927','2022-11-15 13:47:39'),(80,'8','214','2022-11-11',1,'0013','','5',1144450.00,'80','','','1','Malam madori station','11112022',1144447.65,'2022-11-12 08:44:17',5,'PAYMENT OF PMS','923','','0000-00-00 00:00:00','927','2022-11-13 06:49:50'),(81,'8','214','2022-11-11',1,'0026','','5',747760.00,'81','','','1','Malam madori station','17112022',747762.00,'2022-11-17 07:49:02',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-11-17 11:17:36'),(82,'8','214','2022-11-17',1,'0024','','5',1511760.00,'83','','','1','Malam madori station','18112022',1511757.30,'2022-11-18 09:05:15',5,'Payments of pms','923','','0000-00-00 00:00:00','927','2022-11-19 05:58:05'),(83,'8','214','2022-11-21',1,'00012','','5',939370.00,'84','','','1','Malam madori station','20112022',939371.55,'2022-11-21 08:47:59',5,'PAYMENT OF PMS','923','','0000-00-00 00:00:00','927','2022-11-25 17:46:53'),(84,'8','214','2022-11-21',1,'0015','','5',1606775.00,'85','','','1','Malam madori station','21112022',1606776.60,'2022-11-22 08:46:53',5,'PAYMENT OF PMS','923','','0000-00-00 00:00:00','927','2022-11-25 17:46:52'),(85,'8','214','2022-11-22',1,'0018','','5',1813310.00,'86','','','1','Malam madori station','22112022',1813416.80,'2022-11-23 08:13:05',5,'Payment of Pms','923','','0000-00-00 00:00:00','927','2022-11-25 17:46:52'),(86,'8','214','2022-11-24',1,'011','','5',635890.00,'88','','','1','Malam madori station','24112022',635887.20,'2022-11-25 12:14:15',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-11-25 17:46:10'),(87,'8','214','2022-11-25',1,'027','','5',1131700.00,'89','','','1','Malam madori station','25112022',1131702.00,'2022-11-26 08:01:34',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-11-28 16:49:30'),(88,'8','214','2022-11-26',1,'023','','5',1601450.00,'90','','','1','Malam madori station','26112022',1601451.80,'2022-11-27 12:16:23',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-11-28 16:49:30'),(89,'8','214','2022-11-27',1,'08','','5',1778610.00,'91','','','1','Malam madori station','27112022',1778610.60,'2022-11-28 08:49:42',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2022-12-01 15:22:11'),(90,'8','214','2022-11-28',1,'09','','5',1907000.00,'92','','','1','Malam madori station','28112022',1906998.60,'2022-11-29 08:33:50',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2022-12-03 13:57:29'),(91,'8','214','2022-11-29',1,'010','','5',1321450.00,'93','','','1','Malam madori station','29112922',1321450.00,'2022-11-30 08:30:16',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2022-12-03 13:57:44'),(92,'8','214','2022-12-07',1,'10','','5',1006000.00,'94','','','1','Malam madori station','29112022',1006200.00,'2022-12-07 08:05:24',5,'Payment of pms','923','927','2022-12-10 06:40:49','927','2022-12-10 06:41:19'),(93,'8','214','2022-12-06',1,'11','','5',166480.00,'94','','','1','Malam madori station','9612222',166480.00,'2022-12-07 08:06:49',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-10 06:41:19'),(94,'8','214','2022-12-07',1,'12','','5',6295200.00,'95','','','1','','071222',6295201.20,'2022-12-07 16:11:09',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-13 13:02:31'),(95,'8','214','2022-12-07',1,'12','','5',2202700.00,'96','','','1','Malam madori station','08122022',2202803.72,'2022-12-15 08:38:16',5,'Payment of pms','923','927','2022-12-15 12:38:10','927','2022-12-15 12:38:37'),(96,'8','214','2022-12-08',1,'112','','5',557170.00,'97','','','1','Malam madori station','09122022',557171.20,'2022-12-15 08:42:19',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-15 12:37:43'),(97,'8','214','2022-12-16',1,'111','','5',514900.00,'98','','','1','Malam madori station','15122022',514939.95,'2022-12-16 10:29:08',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-18 21:42:36'),(98,'8','214','2022-12-16',1,'13','','5',1846365.00,'99','','','1','Malam madori station','16122022',1846366.20,'2022-12-17 08:24:36',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-18 21:42:36'),(99,'8','214','2022-12-17',1,'0098','','5',1613978.75,'100','','','1','Malam madori station','17122022',1613924.55,'2022-12-18 08:51:49',5,'Payment of pms','923','927','2022-12-18 21:44:03','927','2022-12-18 21:44:26'),(100,'8','214','2022-12-19',1,'18','','5',1366230.00,'102','','','1','Malam madori station','18122022',1366233.75,'2022-12-19 17:18:05',5,'Payment of pms','923','927','2022-12-25 14:21:51','927','2022-12-25 14:22:31'),(101,'8','214','2022-12-18',1,'17','','5',1857335.00,'102','','','1','Malam madori station','181222',1857334.50,'2022-12-19 17:32:39',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-25 14:22:31'),(102,'8','214','2022-12-20',1,'20','','5',1648110.00,'103','','','1','Malam madori station','201222',1648108.35,'2022-12-21 08:12:06',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-25 14:22:31'),(103,'8','214','2022-12-21',1,'56','','5',4010615.00,'104','','','1','Malam madori station','21122022',4010627.25,'2022-12-22 08:17:03',5,'Payment of pms','923','927','2022-12-25 14:23:36','927','2022-12-25 14:24:28'),(104,'8','214','2022-12-22',1,'189','','5',1271055.00,'105','','','1','Malam madori station','22/12/2022',1271368.35,'2022-12-23 10:35:15',5,'Payment of pms','923','927','2022-12-25 14:24:16','927','2022-12-25 14:24:28'),(105,'8','214','2022-12-24',1,'19','','5',1097270.00,'106','','','1','Malam madori station','24122022',1097267.85,'2022-12-26 08:10:20',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-29 13:25:47'),(106,'8','214','2022-12-25',1,'117','','5',386390.00,'107','','','1','Malam madori station','25122022',386391.60,'2022-12-26 08:13:23',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-29 13:34:14'),(107,'8','214','2022-12-26',1,'126','','5',2074780.00,'108','','','1','Malam madori station','26122022',2074780.80,'2022-12-27 08:58:09',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-29 13:34:14'),(108,'8','214','2022-12-27',1,'Q3','','5',1909950.00,'110','','','1','Malam madori station','27122022',1909949.65,'2022-12-29 08:39:22',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2022-12-29 13:34:14'),(109,'8','214','2022-12-29',1,'10','','5',1503180.00,'110','','','1','Malam madori station','28122022',1503180.30,'2022-12-30 08:39:28',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2023-01-02 15:13:50'),(110,'8','214','2022-12-30',1,'110','','5',1473810.00,'111','','','1','Malam madori station','30122022',1473807.00,'2022-12-31 08:36:31',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2023-01-02 15:13:00'),(111,'8','214','2023-01-31',1,'09','','5',2087160.00,'113','','','1','Malam madori station','31122022',2087160.00,'2023-01-01 12:24:48',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2023-01-02 15:14:39'),(112,'8','214','2023-01-01',1,'119','','5',2271825.00,'113','','','1','Malam madori station','01012023',2271825.00,'2023-01-02 12:20:54',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2023-01-02 15:14:24'),(113,'8','214','2023-01-02',1,'117','','5',2094555.00,'114','','','1','Malam madori station','02012023',2094555.00,'2023-01-03 11:27:13',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-01-10 15:46:38'),(114,'8','214','2023-01-03',1,'76','','5',1863705.00,'115','','','1','Malam madori station','312023',1863603.00,'2023-01-04 09:28:08',5,'Payment of pms','923','927','2023-01-10 15:47:31','927','2023-01-10 15:48:12'),(115,'8','214','2023-01-04',1,'78','','5',5252100.00,'116','','','1','Malam madori station','412023',5252202.00,'2023-01-05 08:47:02',5,'Payment of pms','923','927','2023-01-10 15:48:03','927','2023-01-10 15:48:12'),(116,'8','214','2023-01-05',1,'16','','5',2300575.00,'117','','','1','Malam madori station','512023',2300562.00,'2023-01-06 10:00:54',5,'Payment of pms','923','927','2023-01-10 15:48:38','927','2023-01-10 15:48:45'),(117,'8','214','2023-01-06',1,'089','','5',2124815.00,'118','','','1','Malam madori station','612023',2124813.00,'2023-01-07 10:57:50',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-01-10 15:49:02'),(118,'8','214','2023-01-07',1,'07','','5',2157000.00,'119','','','1','Malam madori station','712023',2156964.00,'2023-01-08 11:00:03',2,'Payment of pms','923','927','2023-01-10 15:49:36','927','2023-01-10 15:49:45'),(119,'8','214','2023-01-07',1,'098','','5',2748535.00,'120','','','1','Malam madori station','812023',2748516.00,'2023-01-09 08:57:48',5,'Payment of pms','923','927','2023-01-10 15:50:10','927','2023-01-10 15:50:18'),(120,'8','214','2023-01-09',1,'170','','5',2310990.00,'121','','','1','Malam madori station','912023',2310990.00,'2023-01-10 08:57:45',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-01-10 15:46:38'),(121,'8','214','2023-01-10',1,'122','','5',1922735.00,'122','','','1','Malam madori station','1012023',1922736.00,'2023-01-11 08:21:31',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-01-15 22:35:13'),(122,'8','214','2023-01-11',1,'187','','5',2784265.00,'123','','','1','Malam madori station','1112023',2784363.00,'2023-01-14 08:42:26',5,'Payment of pms','923','927','2023-01-15 22:36:52','927','2023-01-15 22:37:28'),(123,'8','214','2023-01-12',1,'179','','5',1589100.00,'124','','','1','Malam madori station','1212023',1589103.00,'2023-01-14 08:45:21',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-01-15 22:37:28'),(124,'8','214','2023-01-19',1,'127','','5',1395795.00,'126','','','1','Malam madori station','1812023',1395726.00,'2023-01-19 09:29:28',5,'Payment of pms','923','927','2023-01-21 15:27:18','927','2023-01-21 15:28:00'),(125,'8','214','2023-01-14',1,'126','','5',2088925.00,'126','','','1','Malam madori station','1412023',2088924.00,'2023-01-19 09:30:41',5,'Payment of pms','923','927','2023-01-21 15:27:46','927','2023-01-21 15:28:00'),(126,'8','214','2023-01-19',1,'127','','5',2505780.00,'127','','','1','Malam madori station','1912023',2505828.00,'2023-01-20 09:45:10',5,'Payment of pms','923','927','2023-01-21 15:26:46','927','2023-01-21 15:28:00'),(127,'8','214','2023-01-19',1,'128','','5',1472685.00,'128','','','1','Malam madori station','2012023',1472685.00,'2023-01-23 07:10:46',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2023-01-28 14:36:40'),(128,'8','214','2023-01-21',1,'129','','5',435605.00,'129','','','1','Malam madori station','2112023',435603.00,'2023-01-23 07:13:49',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2023-01-28 14:36:57'),(129,'8','214','2023-01-21',1,'130','','5',2379720.00,'130','','','1','Malam madori station','22123',2379719.16,'2023-01-23 07:18:07',5,'Payment of pms','923','','0000-00-00 00:00:00','465','2023-01-28 14:37:09'),(131,'8','214','2023-01-29',1,'134','','5',2925000.00,'134','','','1','Malam madori station','2912023',2925000.00,'2023-01-31 19:12:07',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-01-31 19:35:57'),(132,'8','214','2023-01-30',1,'134','','5',707675.00,'134','','','1','Malam madori station','3012023',707675.00,'2023-01-31 19:13:04',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-01-31 19:35:57'),(133,'8','214','2023-01-31',1,'134','','5',3930180.00,'134','','','1','Malam madori station','3122023',3969180.00,'2023-01-31 19:14:20',5,'Payment of pms','923','927','2023-02-01 13:51:19','927','2023-02-16 13:36:42'),(134,'8','214','2023-02-01',1,'134','','5',2154670.00,'134','','','1','Malam madori station','31012023',2154670.00,'2023-02-01 09:32:46',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-03 15:40:35'),(135,'8','214','2023-02-01',1,'135','','5',1886200.00,'135','','','1','Malam madori station','010223',1885507.80,'2023-02-01 22:40:34',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-03 15:40:34'),(136,'8','214','2023-02-03',1,'141','','5',542200.00,'137','','','1','Malam madori station','00099',545200.00,'2023-02-04 05:58:56',5,'Payment of pms','923','927','2023-02-24 15:16:43','927','2023-02-24 15:17:03'),(137,'8','214','2023-02-03',1,'142','','5',1148000.00,'137','','','1','Malam madori station','322023',1693201.35,'2023-02-04 06:00:17',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-07 13:14:55'),(138,'8','214','2023-02-04',1,'127','','5',610100.00,'138','','','1','Malam madori station','0003',610900.00,'2023-02-06 09:09:59',5,'Payment of pms','923','927','2023-02-16 13:38:38','927','2023-02-16 13:39:00'),(139,'8','214','2023-02-04',1,'136','','5',1313970.00,'138','','','1','Malam madori station','432023',1924868.85,'2023-02-06 09:11:48',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-07 13:14:07'),(140,'8','214','2023-02-05',1,'239','','5',960215.00,'139','','','1','Malam madori station','0002',960215.00,'2023-02-06 09:28:28',5,'Payment of pms','923','927','2023-02-16 13:24:09','927','2023-02-16 13:24:42'),(141,'8','214','2023-02-05',1,'139','','5',1200100.00,'139','','','1','Malam madori station','0522023',2160307.20,'2023-02-06 09:29:21',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-07 13:11:56'),(142,'8','214','2023-02-07',1,'141','','5',1380425.00,'141','','','1','Malam madori station','622023',1729422.90,'2023-02-08 08:54:22',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-16 13:40:39'),(143,'8','214','2023-02-06',1,'142','','5',347677.99,'142','','','2','Malam madori station','008',349000.00,'2023-02-08 08:56:06',5,'Payment of pms','923','927','2023-02-13 15:21:18','927','2023-02-13 15:21:29'),(144,'8','214','2023-02-07',1,'142','','5',881642.00,'142','','','1','Malam madori station','006',881600.00,'2023-02-10 07:48:48',5,'Payment of pms','923','927','2023-02-13 15:19:02','927','2023-02-13 15:19:14'),(145,'8','214','2023-02-07',1,'143','','5',1811390.00,'142','','','1','Malam madori station','722023',2692987.20,'2023-02-10 07:50:06',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-13 15:19:33'),(146,'8','214','2023-02-08',1,'243','','5',696061.00,'143','','','1','Malam madori station','0004',696000.00,'2023-02-10 07:59:01',5,'Payment of pms','923','927','2023-02-13 15:16:52','927','2023-02-13 15:17:06'),(147,'8','214','2023-02-08',1,'144','','5',1618360.00,'143','','','1','Malam madori station','0822023',2314360.05,'2023-02-10 07:59:51',0,'Payment of pms','923','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(148,'8','214','2023-02-11',1,'144','','5',1337471.00,'144','','','1','Malam madori station','116',1343000.00,'2023-02-11 16:15:53',5,'Payment of pms','923','927','2023-02-21 15:46:21','927','2023-02-21 15:46:49'),(149,'8','214','2023-02-11',1,'145','','5',1429050.00,'144','','','1','Malam madori station','11022023',1429050.00,'2023-02-11 16:16:34',5,'Payment of pms','923','927','2023-02-16 13:16:04','927','2023-02-16 13:16:19'),(150,'8','214','2023-02-11',1,'145','','5',2553153.00,'145','','','1','Malam madori station','10022023',2557112.40,'2023-02-12 15:40:00',5,'Payment of pms','923','927','2023-02-21 15:40:56','927','2023-02-21 15:41:11'),(151,'8','214','2023-02-12',1,'146','','5',2318800.00,'146','','','1','Malam madori station','1222023',2322629.70,'2023-02-18 10:53:03',5,'Payment of pms','923','927','2023-02-21 15:37:43','927','2023-02-21 15:37:59'),(152,'8','214','2023-02-13',1,'147','','5',1382960.00,'147','','','1','Malam madori station','13022023',1385637.30,'2023-02-18 10:58:58',5,'Payment of pms','923','927','2023-02-21 15:35:26','927','2023-02-21 15:35:37'),(153,'8','214','2023-02-18',1,'148','','5',1938810.00,'148','','','1','Malam madori station','1822023',1938809.20,'2023-02-19 09:03:24',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-21 14:52:22'),(154,'8','214','2023-02-19',1,'149','','5',2008860.00,'149','','','1','Malam madori station','19022023',2008862.80,'2023-02-20 18:00:55',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-21 14:52:22'),(155,'8','214','2023-02-19',1,'150','','5',1931880.00,'150','','','1','Malam madori station','1922023',1931880.00,'2023-02-24 08:41:40',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-24 15:13:43'),(156,'8','214','2023-02-20',1,'151','','5',1189145.00,'151','','','1','Malam madori station','2022023',1189146.60,'2023-02-24 08:48:56',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-02-24 15:13:43'),(157,'8','214','2023-02-24',1,'152','','5',1779815.00,'152','','','1','Malam madori station','2222023',1779813.00,'2023-02-24 08:53:24',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-01 13:58:45'),(158,'8','214','2023-02-24',1,'153','','5',2229935.00,'153','','','1','Malam madori station','2432023',2229936.00,'2023-02-26 11:11:51',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-01 13:46:47'),(159,'8','214','2023-02-27',1,'154','','5',1845530.00,'154','','','1','Malam madori station','2722023',1845393.00,'2023-02-27 09:06:01',5,'Payment of pms','923','927','2023-03-01 13:54:47','927','2023-03-01 13:56:12'),(160,'8','214','2023-03-27',1,'155','','5',2285400.00,'155','','','1','Malam madori station','2622023',2285397.00,'2023-03-01 09:18:36',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-01 13:46:47'),(161,'8','214','2023-03-28',1,'156','','5',1703270.00,'156','','','1','Malam madori station','27022023',1703271.00,'2023-03-01 09:25:01',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-01 16:29:38'),(162,'8','214','2023-03-01',1,'157','','5',3592485.00,'157','','','1','','0122023',3592485.00,'2023-03-02 09:34:50',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-03 13:31:19'),(163,'8','214','2023-03-01',1,'158','','5',1643040.00,'158','','','1','Malam madori station','0232023',1643037.00,'2023-03-03 20:31:23',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-06 13:23:02'),(164,'8','214','2023-03-03',1,'159','','5',1755870.00,'159','','','1','Malam madori station','02032023',1755867.00,'2023-03-04 09:25:20',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-06 13:23:02'),(165,'8','214','2023-03-05',1,'161','','5',2023500.00,'161','','','1','Malam madori station','0532023',2023503.00,'2023-03-06 10:30:39',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-06 13:23:02'),(166,'8','214','2023-03-06',1,'162','','5',1553740.00,'162','','','1','Malam madori station','0632022',1554339.00,'2023-03-08 09:05:58',5,'Payment of pms','923','927','2023-03-09 12:46:20','927','2023-03-09 12:46:39'),(167,'8','214','2023-03-07',1,'163','','5',1727095.00,'163','','','1','Malam madori station','0732023',1727094.00,'2023-03-08 09:12:11',5,'Payment of pms','923','','0000-00-00 00:00:00','927','2023-03-09 12:45:53'),(168,'8','214','2023-03-08',1,'164','','5',2955080.00,'164','','','1','Malam madori station','0832023',2955081.00,'2023-03-09 13:35:08',0,'Payment of pms','923','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(169,'8','214','2023-03-09',1,'166','','5',1382330.00,'166','','','1','Malam madori station','0932023',1382328.00,'2023-03-14 08:24:45',0,'Payment of pms','923','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(170,'8','214','2023-03-10',1,'166','','5',981880.00,'166','','','1','Malam madori station','1032023',981882.00,'2023-03-14 08:28:20',0,'Payment of pms','923','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(171,'8','214','2023-03-12',1,'167','','5',1807320.00,'167','','','1','Malam madori station','1232023',1807320.00,'2023-03-14 08:40:30',0,'Payment of pms','923','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(172,'8','214','2023-03-13',1,'168','','5',1543785.00,'168','','','1','Malam madori station','1332023',1543785.00,'2023-03-14 09:04:00',0,'Payment of pms','923','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(173,'8','214','2023-03-14',1,'169','','5',1540365.00,'169','','','1','Malam madori station','1432023',1540365.00,'2023-03-16 09:37:53',0,'Payment of pms','923','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'8',1,'214',1,1,'2022-08-10 00:00:00','AA RANO',31600.00,31600.00,0.00,'01','','1','NSR 435 ZS','Alhaji gambo','07033279868','Dalivary of pms',5,'2022-08-10 23:11:20','923','0000-00-00 00:00:00','','2022-08-11 15:30:39','927'),(2,'8',1,'214',1,1,'2022-08-10 00:00:00','AA RANO',23400.00,23400.00,0.00,'01','','2','NSR 435 ZS','Alhaji gambo','07033279868','Dalivary of pms',5,'2022-08-10 23:11:20','923','0000-00-00 00:00:00','','2022-08-11 15:29:41','927'),(3,'8',2,'214',1,1,'2022-08-13 00:00:00','AA RANO',17100.00,17100.00,0.00,'02','','1','BCH428XA','Ridwan danja','08034997784','Dalivary of pms',5,'2022-08-13 22:27:21','923','0000-00-00 00:00:00','','2022-08-14 16:09:30','923'),(4,'8',2,'214',1,1,'2022-08-13 00:00:00','AA RANO',32300.00,32300.00,0.00,'02','','2','BCH428XA','Ridwan danja','08034997784','Dalivary of pms',5,'2022-08-13 22:27:21','923','0000-00-00 00:00:00','','2022-08-14 16:09:30','923'),(7,'8',4,'214',1,1,'2022-08-23 00:00:00','AA RANO',17000.00,17000.00,0.00,'03','','2','GML594XA','Kabiru','08147774782','Dalivary of pms',5,'2022-08-23 22:16:22','923','0000-00-00 00:00:00','','2022-08-28 13:05:26','927'),(8,'8',5,'214',1,1,'2022-08-28 00:00:00','AA RANO',16850.00,16850.00,0.00,'02','','1','DKA705ZP','Yunusa wanzam','07067180685','Dalivary of pms',5,'2022-08-28 17:26:08','923','0000-00-00 00:00:00','','2022-08-28 17:27:15','927'),(9,'8',6,'214',1,1,'2022-08-30 00:00:00','AA RANO',20600.00,20600.00,0.00,'003','','1','RAN32XF','Isah','07063462050','Dalivary of pms',5,'2022-08-30 15:26:29','923','0000-00-00 00:00:00','','2022-08-31 07:55:34','923'),(10,'8',6,'214',1,1,'2022-08-30 00:00:00','AA RANO',29200.00,29200.00,0.00,'03','','2','RAN32XF','Isah','07063462050','Dalivary of pms',5,'2022-08-30 15:26:29','923','0000-00-00 00:00:00','','2022-08-31 07:55:34','923'),(11,'8',7,'214',1,1,'2022-09-03 00:00:00','AA RANO',18000.00,18000.00,0.00,'004','','1','NSR435ZS','Alhaji gambo','07033279868','Delivery of PM\'s',5,'2022-09-03 08:25:38','923','0000-00-00 00:00:00','','2022-09-03 08:26:32','923'),(12,'8',8,'214',1,1,'2022-09-07 00:00:00','AA RANO',16200.00,16200.00,0.00,'0031','','1','BCH424XA','Aramma','07038288822','Delivery of PM\'s',5,'2022-09-07 08:21:24','923','0000-00-00 00:00:00','','2022-09-08 13:30:24','927'),(13,'8',8,'214',1,1,'2022-09-07 00:00:00','AA RANO',16800.00,16800.00,0.00,'0031','','2','BCH424XA','Aramma','07038288822','Dalivary of pms',5,'2022-09-07 08:21:24','923','0000-00-00 00:00:00','','2022-09-08 13:30:38','927'),(14,'8',9,'214',1,1,'2022-09-15 00:00:00','AA RANO',17650.00,17650.00,0.00,'00032','','1','RAN683XA','SHANSU','09032291031','Purchase of PM\'s',5,'2022-09-15 07:58:02','923','0000-00-00 00:00:00','','2022-09-16 15:17:50','927'),(15,'8',9,'214',1,1,'2022-09-15 00:00:00','AA RANO',32250.00,32250.00,0.00,'00032','','2','RAN683XA','SHANSU','09032291031','Purchase of PM\'s',5,'2022-09-15 07:58:02','923','0000-00-00 00:00:00','','2022-09-16 15:17:34','927'),(16,'8',10,'214',1,1,'2022-09-20 00:00:00','AA RANO',17000.00,17000.00,0.00,'005','','1','GML594XA','KABIRU','08147774782','Purchase of PM\'s',5,'2022-09-20 12:48:00','923','0000-00-00 00:00:00','','2022-09-20 13:50:40','927'),(17,'8',11,'214',1,1,'2022-09-24 00:00:00','AA RANO',17500.00,17500.00,0.00,'00033','','1','DKA705ZP','WANZAM','07067180685','Purchase of PM\'s',5,'2022-09-24 08:39:33','923','0000-00-00 00:00:00','','2022-09-25 09:23:58','927'),(18,'8',11,'214',1,1,'2022-09-24 00:00:00','AA RANO',31850.00,31850.00,0.00,'00033','','2','DKA705ZP','WANZAM','07067180685','Purchase of PM\'s',5,'2022-09-24 08:39:33','923','0000-00-00 00:00:00','','2022-09-25 09:37:27','927'),(19,'8',12,'214',1,1,'2022-09-30 00:00:00','AA RANO',18000.00,18000.00,0.00,'006','','1','WDL813XA','ME DABAN','08065000870','Purchase of PM\'s',5,'2022-09-30 07:56:37','923','0000-00-00 00:00:00','','2022-10-04 14:05:55','927'),(20,'8',13,'214',1,1,'2022-10-07 00:00:00','AA RANO',17000.00,17000.00,0.00,'00050','','2','RAN32XF','ISAH','07063462050','Purchase of PM\'s',5,'2022-10-07 12:01:47','923','0000-00-00 00:00:00','','2022-10-07 13:41:56','927'),(21,'8',14,'214',1,1,'2022-10-10 00:00:00','AA RANO',14200.00,14200.00,0.00,'00515','','1','NSR56ZQ','USAINI','07037469603','Purchase of PM\'s',5,'2022-10-10 12:10:55','923','0000-00-00 00:00:00','','2022-10-10 12:31:19','927'),(22,'8',14,'214',1,1,'2022-10-10 00:00:00','AA RANO',14500.00,14500.00,0.00,'00515','','2','NSR56ZQ','USAINI','07037469603','Purchase of PM\'s',5,'2022-10-10 12:10:55','923','0000-00-00 00:00:00','','2022-10-10 12:31:42','927'),(23,'8',15,'214',1,1,'2022-10-22 00:00:00','AA RANO',17950.00,17950.00,0.00,'0045','','2','NSR435ZS','Alhaji Gambo','07033279868','Purchase of PM\'s',5,'2022-10-22 08:24:01','923','0000-00-00 00:00:00','','2022-10-22 10:04:37','927'),(24,'8',16,'214',1,1,'2022-10-26 00:00:00','AA RANO',19500.00,19500.00,0.00,'000541','','2','NSR57ZQ','Ali','07043189737','Purchase of PM\'s',5,'2022-10-26 14:54:27','923','0000-00-00 00:00:00','','2022-10-27 10:32:37','927'),(25,'8',17,'214',1,1,'2022-11-05 00:00:00','AA RANO',16400.00,16400.00,0.00,'007','','1','RAN33XF','ABDULLAHI','09066536097','Purchase of PM\'s',5,'2022-11-05 11:12:38','923','0000-00-00 00:00:00','','2022-11-06 08:46:41','927'),(26,'8',17,'214',1,1,'2022-11-05 00:00:00','AA RANO',16400.00,16400.00,0.00,'007','','2','RAN33XF','ABDULLAHI','09066536097','Purchase of PM\'s',5,'2022-11-05 11:12:38','923','0000-00-00 00:00:00','','2022-11-06 08:46:59','927'),(27,'8',18,'214',1,1,'2022-11-08 00:00:00','AA RANO',17000.00,17000.00,0.00,'0051','','2','GML594XA','KABIRU','08147774782','Purchase of PM\'s',5,'2022-11-08 13:15:21','923','0000-00-00 00:00:00','','2022-11-09 12:38:37','927'),(28,'8',19,'214',1,1,'2022-11-16 00:00:00','AA RANO',16700.00,16700.00,0.00,'00589','','2','DKA705ZP','WANZAM','07067180685','Purchase of PM\'s',5,'2022-11-16 15:00:21','923','0000-00-00 00:00:00','','2022-11-16 16:41:04','927'),(29,'8',20,'214',1,1,'2022-11-20 00:00:00','AA RANO',16450.00,16450.00,0.00,'00056','','1','RAN33XF','ABDULLAHI','09066536097','Purchase of PM\'s',5,'2022-11-20 11:33:07','923','0000-00-00 00:00:00','','2022-11-20 15:31:15','923'),(30,'8',20,'214',1,1,'2022-11-20 00:00:00','AA RANO',16550.00,16550.00,0.00,'00056','','2','RAN33XF','ABDULLAHI','09066536097','Purchase of PM\'s',5,'2022-11-20 11:33:07','923','0000-00-00 00:00:00','','2022-11-20 15:30:52','923'),(31,'8',21,'214',1,1,'2022-11-24 00:00:00','AA RANO',14700.00,14700.00,0.00,'0007','','1','NSR57ZQ','ALI','07043189737','Purchase of PM\'s',5,'2022-11-24 15:52:31','923','0000-00-00 00:00:00','','2022-11-24 15:53:31','923'),(32,'8',21,'214',1,1,'2022-11-24 00:00:00','AA RANO',19450.00,19450.00,0.00,'0007','','2','NSR57ZQ','ALI','07043189737','Purchase of PM\'s',5,'2022-11-24 15:52:31','923','0000-00-00 00:00:00','','2022-11-24 15:53:16','923'),(33,'8',22,'214',1,1,'2022-12-06 00:00:00','AA RANO',16900.00,16900.00,0.00,'00433','','1','GML594XA','KABIRU','08147774782','Purchase of pms',5,'2022-12-06 11:12:28','923','0000-00-00 00:00:00','','2022-12-06 11:13:56','923'),(34,'8',22,'214',1,1,'2022-12-06 00:00:00','AA RANO',16300.00,16300.00,0.00,'00433','','2','GML594XA','KABIRU','08147774782','Purchase ofpms',5,'2022-12-06 11:12:28','923','0000-00-00 00:00:00','','2022-12-06 11:13:38','923'),(35,'8',23,'214',1,1,'2022-12-15 00:00:00','AA RANO',18800.00,18800.00,0.00,'081','','1','KMC756ZS','Ahmad','07032056942','Purchase of pms',5,'2022-12-15 08:33:22','923','0000-00-00 00:00:00','','2022-12-15 08:34:28','923'),(36,'8',23,'214',1,1,'2022-12-15 00:00:00','AA RANO',30850.00,30850.00,0.00,'0081','','2','KMC756ZS','Ahmad','07032056942','Purchase ofpms',5,'2022-12-15 08:33:22','923','0000-00-00 00:00:00','','2022-12-15 08:34:14','923'),(37,'8',24,'214',1,1,'2022-12-26 00:00:00','AA RANO',18000.00,18000.00,0.00,'0087','','2','NSR435ZS','Alhaji gambo','07033279868','Purchase ofpms',5,'2022-12-26 08:03:15','923','0000-00-00 00:00:00','','2022-12-26 08:07:57','923'),(38,'8',25,'214',1,1,'2022-12-29 00:00:00','AA RANO',17050.00,17050.00,0.00,'082','','1','RAN32XF','Isah','07063462050','Purchase of pms',5,'2022-12-29 15:21:44','923','0000-00-00 00:00:00','','2022-12-29 15:22:15','923'),(39,'8',25,'214',1,1,'2022-12-29 00:00:00','AA RANO',32800.00,32800.00,0.00,'082','','2','RAN32XF','Isah','07063462050','Purchase ofpms',5,'2022-12-29 15:24:46','923','0000-00-00 00:00:00','','2022-12-29 15:25:32','923'),(40,'8',26,'214',1,1,'2023-01-04 00:00:00','AA RANO',17400.00,17400.00,0.00,'0085','','1','NSR572ZS','Alhaji Buhari','08032973447','Purchase of pms',5,'2023-01-04 09:25:40','923','0000-00-00 00:00:00','','2023-01-04 09:26:35','923'),(41,'8',26,'214',1,1,'2023-01-04 00:00:00','AA RANO',16700.00,16700.00,0.00,'0085','','2','NSR572ZS','Alhaji Buhari','08032973447','Purchase ofpms',5,'2023-01-04 09:25:40','923','0000-00-00 00:00:00','','2023-01-04 09:26:19','923'),(42,'8',27,'214',1,1,'2023-01-08 00:00:00','AA RANO',20850.00,20850.00,0.00,'00609','','2','NSR56ZQ','Sani','09133786668','Purchase ofpms',5,'2023-01-08 11:02:40','923','0000-00-00 00:00:00','','2023-01-08 11:03:01','923'),(43,'8',28,'214',1,1,'2023-01-14 00:00:00','AA RANO',16850.00,16850.00,0.00,'00613','','2','GML594XA','KABIRU','08147774782','Purchase ofpms',5,'2023-01-14 08:39:03','923','0000-00-00 00:00:00','','2023-01-14 08:39:26','923'),(44,'8',29,'214',1,1,'2023-01-19 00:00:00','AA RANO',14750.00,14750.00,0.00,'00071','','2','RAN441XA','Me Daban','08065000870','Purchase ofpms',5,'2023-01-19 09:21:34','923','0000-00-00 00:00:00','','2023-01-19 09:22:07','923'),(45,'8',30,'214',1,1,'2023-01-22 00:00:00','AA RANO',16800.00,16800.00,0.00,'00067','','1','BCH428XA','Dan ja','0814012083','Purchase of pms',5,'2023-01-22 19:19:37','923','0000-00-00 00:00:00','','2023-01-22 19:20:36','923'),(46,'8',30,'214',1,1,'2023-01-22 00:00:00','AA RANO',16100.00,16100.00,0.00,'0067','','2','BCH428XA','Dan ja','0814012083','Purchase ofpms',5,'2023-01-22 19:19:37','923','0000-00-00 00:00:00','','2023-01-22 19:20:01','923'),(47,'8',31,'214',1,1,'2023-01-31 00:00:00','AA RANO',18500.00,18500.00,0.00,'0081','','1','NSR435ZS','Alhaji gambo','07033279868','Purchase of pms',5,'2023-01-31 06:50:47','923','0000-00-00 00:00:00','','2023-01-31 06:51:57','923'),(48,'8',31,'214',1,1,'2023-01-31 00:00:00','AA RANO',31500.00,31500.00,0.00,'0081','','2','NSR435ZS','Alhaji gambo','07033279868','Purchase ofpms',5,'2023-01-31 06:50:47','923','0000-00-00 00:00:00','','2023-01-31 06:51:30','923'),(49,'8',32,'214',1,1,'2023-02-09 00:00:00','AA RANO',17000.00,17000.00,0.00,'00624','','1','RAN683XA','SHAMSU','09032291031','Purchase of pms',5,'2023-02-09 13:42:57','923','0000-00-00 00:00:00','','2023-02-09 13:44:03','923'),(50,'8',32,'214',1,1,'2023-02-09 00:00:00','AA RANO',15900.00,15900.00,0.00,'00624','','2','RAN683XA','SHAMSU','09032291031','Purchase ofpms',5,'2023-02-09 13:42:57','923','0000-00-00 00:00:00','','2023-02-09 13:43:29','923'),(51,'8',33,'214',1,1,'2023-02-18 00:00:00','AA RANO',20650.00,20650.00,0.00,'00634','','2','NSR86ZX','SANI','09033786668','Purchase ofpms',5,'2023-02-18 10:43:40','923','0000-00-00 00:00:00','','2023-02-18 10:46:51','923'),(52,'8',34,'214',1,1,'2023-02-23 00:00:00','AA RANO',17050.00,17050.00,0.00,'0087','','1','RAN32XF','Isah','07063462050','Purchase of pms',5,'2023-02-23 21:06:43','923','0000-00-00 00:00:00','','2023-02-24 08:39:47','923'),(53,'8',34,'214',1,1,'2023-02-23 00:00:00','AA RANO',32850.00,32850.00,0.00,'0087','','2','RAN32XF','Isah','07063462050','Purchase ofpms',5,'2023-02-23 21:06:43','923','0000-00-00 00:00:00','','2023-02-24 08:39:06','923'),(54,'8',35,'214',1,1,'2023-03-02 00:00:00','AA RANO',15600.00,15600.00,0.00,'0091','','1','NSR435ZS','Alhaji gambo','07033279868','Purchase of pms',5,'2023-03-02 09:00:46','923','0000-00-00 00:00:00','','2023-03-02 09:01:33','923'),(55,'8',35,'214',1,1,'2023-03-02 00:00:00','AA RANO',16400.00,16400.00,0.00,'0091','','2','NSR435ZS','Alhaji gambo','07033279868','Purchase ofpms',5,'2023-03-02 09:00:46','923','0000-00-00 00:00:00','','2023-03-02 09:01:15','923'),(56,'8',36,'214',1,1,'2023-03-08 00:00:00','AA RANO',17100.00,17100.00,0.00,'0096','','2','DKA705ZP','Abdullahi','09066536097','Purchase ofpms',5,'2023-03-08 08:06:04','923','0000-00-00 00:00:00','','2023-03-08 08:06:27','923'),(59,'8',37,'214',1,1,'2023-03-13 00:00:00','AA RANO',16050.00,16050.00,0.00,'0098','','1','BCH424XA','ARAMMA','08068405034','Purchase of pms',5,'2023-03-13 09:04:39','923','0000-00-00 00:00:00','','2023-03-13 09:06:34','923'),(60,'8',37,'214',1,1,'2023-03-13 00:00:00','AA RANO',16950.00,16950.00,0.00,'0098','','2','BCH424XA','ARAMMA','08068405034','Purchase ofpms',5,'2023-03-13 09:04:39','923','0000-00-00 00:00:00','','2023-03-13 09:05:56','923'),(61,'8',38,'214',1,1,'2023-03-17 00:00:00','AA RANO',15400.00,15400.00,0.00,'0098','','1','NSR57ZQ','SHAFIU','08032528608','Purchase of pms',5,'2023-03-17 10:41:21','923','0000-00-00 00:00:00','','2023-03-17 10:42:54','923');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'8','214','Lausu Energy Resources','Babangida Bashir','08063654848','babangida@lausuenergy.com','KANO','KANO','AA Rano House Hotoro kano.','Nigeria',0.00,0.00,'0000-00-00','2022-08-06 01:50:03',5,'923','2022-08-06 01:50:03','923');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:57:14
