-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_8_station_213
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_8_station_213`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_8_station_213` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_8_station_213`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,2500,'',0,'2','8','213','UBA-0039769388','','2022-08-06 09:56:07',5,0.00,0.00,'','926','2022-08-06 09:56:07','926',0,0),(2,2501,'',0,'2','8','213','Keystone-1009080913','','2022-08-06 09:56:22',5,0.00,0.00,'','926','2022-08-06 09:56:22','926',0,0),(3,4000,'',0,'22','8','213','PURCHASES','','2022-08-06 09:59:22',5,0.00,0.00,'','926','2022-08-06 09:59:22','926',0,0),(4,8000,'',0,'24','8','213','PURCHASES','','2022-08-06 09:59:39',5,0.00,0.00,'','926','2022-08-06 09:59:39','926',0,0),(6,7000,'',0,'20','8','213','SALES','','2022-08-06 10:01:38',5,0.00,0.00,'','926','2022-08-06 10:01:38','926',0,0),(7,500,'',0,'6.1','8','213','CASH','','2022-08-06 10:02:27',5,0.00,0.00,'','926','2022-08-06 10:02:27','926',0,0),(8,8001,'',0,'24','8','213','SALARIES & WAGES','','2022-08-06 10:03:50',5,0.00,0.00,'','926','2022-08-06 10:03:50','926',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('8','213','1',1,'5','PMS PUMP 1',965040.70,'PMS DISPENSER.','',NULL,NULL,'',5,'2023-03-14 17:03:18','926'),('8','213','1',2,'5','PMS PUMP 2',188380.79,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-12 13:01:22','925'),('8','213','2',3,'5','PMS PUMP 3',14512.40,'PMS DISPENSER.','',NULL,NULL,'',5,'2023-03-14 17:08:20','926'),('8','213','2',4,'5','PMS TANK 4',0.00,'PMS DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('8','213','3',5,'5','AGO PUMP 1',0.00,'AGO DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('8','213','3',6,'5','AGO PUMP 2',0.00,'AGO DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('8','213','4',7,'5','DPK PUMP ',0.00,'DPK DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('8','213',1,'Daily shift','2022-08-12','2022-08-12 14:48:51','2022-08-13 14:48:51','925',0.00,0.00,'925','2022-08-12 15:27:51','925','2022-08-12 15:54:59',10,0),('8','213',2,'Daily shift','2022-08-13','2022-08-13 09:55:38','2022-08-14 09:55:38','925',0.00,0.00,'925','2022-08-13 11:19:58','925','2022-08-13 11:20:59',10,0),('8','213',3,'Daily shift','2022-08-10','2022-08-13 11:22:08','2022-08-14 11:22:08','925',864489.20,0.00,'925','2022-08-13 11:24:36','925','2022-08-13 11:30:06',10,0),('8','213',5,'DAILY SHIFT','2022-08-11','2022-08-14 10:05:32','2022-08-15 10:05:32','925',778166.70,778166.70,'925','2022-08-14 10:07:32','925','2022-08-14 10:09:49',10,0),('8','213',6,'Daily shift','2022-08-14','2022-08-14 10:27:52','2022-08-15 10:27:52','925',796860.95,796860.95,'925','2022-08-14 10:40:41','925','2022-08-14 10:41:16',10,0),('8','213',7,'DAILY SHIFT','2022-08-13','2022-08-14 10:42:46','2022-08-15 10:42:46','925',581658.85,568131.90,'925','2022-08-14 10:44:06','925','2022-08-14 10:45:29',10,0),('8','213',8,'DAILY SHIFT','2022-08-14','2022-08-14 10:47:36','2022-08-15 10:47:36','925',534229.85,521805.90,'925','2022-08-15 13:57:27','925','2022-08-15 13:58:01',10,0),('8','213',9,'DAILY SHIFT','2022-08-15','2022-08-15 13:58:48','2022-08-16 13:58:48','925',492352.15,480902.10,'925','2022-08-15 21:25:31','925','2022-08-16 10:44:33',10,0),('8','213',10,'Daily shift','2022-08-16','2022-08-16 20:54:22','2022-08-17 20:54:22','925',809971.65,779833.17,'925','2022-08-16 21:01:43','925','2022-08-20 21:48:02',10,0),('8','213',11,'Daily shift','2022-08-17','2022-08-21 09:12:10','2022-08-22 09:12:10','925',1189220.90,1144970.82,'925','2022-08-21 09:17:33','925','2022-08-21 09:19:36',10,0),('8','213',12,'Daily shift','2022-08-18','2022-08-21 09:21:52','2022-08-22 09:21:52','925',0.00,0.00,'925','2022-08-21 12:42:53','925','2022-08-21 12:43:30',10,0),('8','213',13,'Daily shift','2022-08-18','2022-08-21 12:45:54','2022-08-22 12:45:54','925',0.00,0.00,'926','2022-08-22 16:01:21','926','2022-08-22 16:01:35',10,0),('8','213',14,'Daily','2022-08-22','2022-08-22 16:03:22','2022-08-23 16:03:22','926',489142.00,0.00,'925','2022-08-22 21:14:52','926','2022-08-24 15:51:27',10,0),('8','213',15,'Daily','2022-08-24','2022-08-24 15:52:22','2022-08-31 15:52:22','926',719636.00,719636.00,'926','2022-08-24 16:28:21','926','2022-08-24 16:31:38',10,0),('8','213',16,'Daily shift','2022-08-21','2022-08-24 16:42:29','2022-08-25 16:42:29','925',495114.00,495114.00,'925','2022-08-24 16:47:49','925','2022-08-24 16:50:57',10,0),('8','213',17,'Daily shift','2022-08-22','2022-08-24 16:53:10','2022-08-25 16:53:10','925',580674.00,580674.00,'925','2022-08-24 16:56:35','925','2022-08-24 17:00:25',10,0),('8','213',18,'Daily','2022-08-24','2022-08-24 17:01:58','2022-08-31 17:01:58','926',647766.00,647766.00,'925','2022-08-24 17:06:46','925','2022-08-24 17:08:12',10,0),('8','213',19,'Daily shift','2022-08-24','2022-08-25 14:41:43','2022-08-26 14:41:43','925',1522162.00,1484107.95,'925','2022-08-25 14:47:35','925','2022-08-25 14:49:29',10,0),('8','213',20,'Daily shift','2022-08-25','2022-08-25 15:03:05','2022-08-26 15:03:05','925',820998.00,800473.05,'925','2022-08-25 23:13:13','925','2022-08-25 23:18:48',10,0),('8','213',21,'Daily shift','2022-08-26','2022-08-26 13:51:24','2022-08-27 13:51:24','925',777292.00,757859.70,'925','2022-08-27 07:37:59','925','2022-08-27 07:39:32',10,0),('8','213',22,'Daily shift','2022-08-27','2022-08-27 07:41:45','2022-08-28 07:41:45','925',779320.00,759837.00,'925','2022-08-28 09:08:14','925','2022-08-28 09:11:11',10,0),('8','213',23,'Daily shift','2022-08-28','2022-08-28 09:12:43','2022-08-29 09:12:43','925',680058.00,663056.55,'925','2022-08-29 07:40:16','925','2022-08-29 07:41:29',10,0),('8','213',24,'Daily shift','2022-08-29','2022-08-29 09:55:02','2022-08-30 09:55:02','925',707888.00,690190.80,'925','2022-08-30 08:24:06','925','2022-08-30 08:25:29',10,0),('8','213',25,'Daily shift','2022-08-30','2022-08-30 14:53:01','2022-08-31 14:53:01','925',797020.00,777094.50,'925','2022-08-30 21:21:35','925','2022-08-30 21:22:13',10,0),('8','213',26,'Daily shift','2022-08-31','2022-08-31 17:17:44','2022-09-01 17:17:44','925',0.00,0.00,'467','2022-09-01 12:08:01','467','2022-09-01 14:10:47',10,0),('8','213',27,'MORNING SHIFT','2022-09-01','2022-09-01 14:13:25','2022-09-08 14:13:25','467',1213274.40,1213274.40,'928','2022-09-01 17:08:02','925','2022-09-01 17:52:32',10,0),('8','213',28,'Daily shift','2022-09-01','2022-09-01 20:44:41','2022-09-02 20:44:41','925',909971.40,909971.40,'925','2022-09-01 20:50:45','925','2022-09-01 20:51:34',10,0),('8','213',29,'Daily shift','2022-09-02','2022-09-02 21:55:35','2022-09-03 21:55:35','925',829964.85,829964.85,'925','2022-09-02 21:57:38','925','2022-09-02 21:58:09',10,0),('8','213',30,'Daily shift','2022-09-03','2022-09-03 19:22:44','2022-09-04 19:22:44','925',746485.35,746485.35,'925','2022-09-03 19:24:41','925','2022-09-03 19:25:54',10,0),('8','213',31,'Daily shift','2022-09-04','2022-09-04 16:35:41','2022-09-05 16:35:41','925',856354.20,856354.20,'925','2022-09-04 19:13:23','925','2022-09-04 19:14:42',10,0),('8','213',32,'Daily shift','2022-09-05','2022-09-05 17:58:57','2022-09-06 17:58:57','925',940290.00,940290.00,'925','2022-09-05 22:32:53','925','2022-09-05 22:34:24',10,0),('8','213',33,'Daily shift','2022-09-06','2022-09-06 14:20:20','2022-09-07 14:20:20','925',991649.10,991649.10,'925','2022-09-06 20:33:55','925','2022-09-06 21:14:04',10,0),('8','213',34,'Daily shift','2022-09-07','2022-09-07 13:10:43','2022-09-08 13:10:43','925',1145841.45,1145841.45,'925','2022-09-07 20:58:25','925','2022-09-07 20:59:40',10,0),('8','213',35,'Daily shift','2022-09-08','2022-09-08 22:04:48','2022-09-09 22:04:48','925',1054836.90,1054836.90,'925','2022-09-08 22:07:45','925','2022-09-08 22:08:53',10,0),('8','213',36,'Daily shift','2022-09-09','2022-09-09 19:22:53','2022-09-10 19:22:53','925',759698.55,759698.55,'925','2022-09-09 19:55:37','925','2022-09-09 19:57:52',10,0),('8','213',37,'Daily shift','2022-09-10','2022-09-10 21:03:26','2022-09-11 21:03:26','925',772987.80,772987.80,'925','2022-09-10 21:09:52','925','2022-09-10 21:11:26',10,0),('8','213',38,'Daily shift','2022-09-11','2022-09-11 18:18:50','2022-09-12 18:18:50','925',880590.75,880590.75,'928','2022-09-14 11:48:53','928','2022-09-14 11:49:39',10,0),('8','213',39,'MORNING SHIFT','2022-09-14','2022-09-14 17:13:45','2022-09-21 17:13:45','467',1233717.50,1266183.75,'925','2022-09-14 20:49:49','925','2022-09-14 20:51:10',10,0),('8','213',40,'Daily shift','2022-09-15','2022-09-15 09:15:24','2022-09-16 09:15:24','925',952720.80,952720.80,'925','2022-09-15 20:55:06','925','2022-09-15 20:56:29',10,0),('8','213',41,'Daily shift','2022-09-16','2022-09-16 18:26:55','2022-09-17 18:26:55','925',1015068.60,989041.20,'925','2022-09-17 08:44:10','925','2022-09-17 08:45:07',10,0),('8','213',42,'Daily shift','2022-09-17','2022-09-17 21:42:58','2022-09-18 21:42:58','925',979691.70,954571.40,'925','2022-09-18 09:09:52','925','2022-09-18 09:10:21',10,0),('8','213',43,'Daily shift','2022-09-18','2022-09-18 22:17:11','2022-09-19 22:17:11','925',900299.40,877214.80,'925','2022-09-18 22:22:52','925','2022-09-18 22:23:34',10,0),('8','213',44,'Daily shift','2022-09-19','2022-09-19 14:05:49','2022-09-20 14:05:49','925',927486.30,903704.60,'925','2022-09-19 21:01:26','925','2022-09-19 21:02:23',10,0),('8','213',45,'Daily shift','2022-09-20','2022-09-20 20:17:39','2022-09-21 20:17:39','925',1221456.60,1190137.20,'925','2022-09-20 20:21:12','925','2022-09-20 20:22:23',10,0),('8','213',46,'Daily shift','2022-09-21','2022-09-21 16:49:01','2022-09-22 16:49:01','925',1323511.80,1289575.60,'925','2022-09-21 20:47:40','925','2022-09-21 20:48:41',10,0),('8','213',47,'Daily shift','2022-09-22','2022-09-22 15:00:49','2022-09-23 15:00:49','925',822194.10,801112.20,'925','2022-09-22 15:03:06','925','2022-09-22 15:03:34',10,0),('8','213',48,'Daily shift','2022-09-25','2022-09-25 19:06:49','2022-09-26 19:06:49','925',1128983.80,1128983.80,'925','2022-09-25 19:11:28','925','2022-09-25 19:12:07',10,0),('8','213',49,'Daily shift','2022-09-26','2022-09-26 19:21:05','2022-09-27 19:21:05','925',1046814.50,1046814.50,'925','2022-09-26 19:24:07','925','2022-09-26 19:34:28',10,0),('8','213',50,'Daily shift','2022-09-27','2022-09-27 19:35:19','2022-09-28 19:35:19','925',1350160.90,1350160.90,'925','2022-09-27 19:44:00','925','2022-09-27 19:44:41',10,0),('8','213',51,'Daily shift','2022-09-28','2022-09-28 19:26:57','2022-09-29 19:26:57','925',1617190.70,1617190.70,'925','2022-09-28 19:30:23','925','2022-09-28 19:39:04',10,0),('8','213',52,'Daily shift','2022-09-29','2022-09-29 19:27:33','2022-09-30 19:27:33','925',1034918.60,1034918.60,'925','2022-09-29 20:54:45','925','2022-09-29 20:56:41',10,0),('8','213',53,'Daily shift','2022-09-30','2022-09-30 20:23:08','2022-10-01 20:23:08','925',643936.60,643936.60,'925','2022-09-30 20:27:35','925','2022-09-30 20:28:29',10,0),('8','213',54,'Daily shift','2022-10-01','2022-10-01 21:25:34','2022-10-02 21:25:34','925',1176219.70,1176219.70,'925','2022-10-01 21:28:08','925','2022-10-01 21:28:48',10,0),('8','213',55,'Daily shift','2022-10-02','2022-10-02 20:41:36','2022-10-03 20:41:36','925',950427.50,950427.50,'925','2022-10-02 20:43:06','925','2022-10-02 20:43:39',10,0),('8','213',56,'Daily shift','2022-10-03','2022-10-03 21:46:54','2022-10-04 21:46:54','925',585589.50,585589.50,'925','2022-10-03 21:49:19','925','2022-10-03 21:50:03',10,0),('8','213',57,'Daily shift','2022-10-10','2022-10-10 21:51:29','2022-10-11 21:51:29','925',2782537.24,2782537.24,'925','2022-10-11 16:31:16','925','2022-10-11 16:31:59',10,0),('8','213',58,'Daily shift','2022-10-11','2022-10-11 16:38:16','2022-10-12 16:38:16','925',3049354.35,3109440.15,'925','2022-10-12 16:24:12','925','2022-10-12 16:24:40',10,0),('8','213',59,'Daily shift','2022-10-12','2022-10-12 20:19:04','2022-10-19 20:19:04','925',2595661.20,2595661.20,'925','2022-10-13 09:41:37','925','2022-10-13 09:42:56',10,0),('8','213',60,'Daily shift','2022-10-13','2022-10-13 20:13:29','2022-10-20 20:13:29','925',2227689.20,2227689.20,'925','2022-10-14 07:21:40','925','2022-10-14 07:22:17',10,0),('8','213',61,'Daily shift','2022-11-09','2022-11-09 20:15:12','2022-11-10 20:15:12','925',2144592.45,2144592.45,'925','2022-11-10 14:51:36','925','2022-11-10 14:52:29',10,0),('8','213',62,'Daily shifta','2022-11-10','2022-11-10 21:10:44','2022-11-11 21:10:44','925',1866811.10,1866811.10,'925','2022-11-11 15:17:23','925','2022-11-11 15:18:19',10,0),('8','213',63,'Daily shift','2022-11-11','2022-11-11 20:12:09','2022-11-12 20:12:09','925',1661018.37,1661018.37,'925','2022-11-12 15:02:12','925','2022-11-12 15:03:04',10,0),('8','213',64,'Daily shift','2022-11-12','2022-11-12 20:10:31','2022-11-13 20:10:31','925',1512183.53,1512183.53,'925','2022-11-13 07:15:35','925','2022-11-13 07:17:51',10,0),('8','213',65,'Daily shift no','2022-11-13','2022-11-13 19:45:37','2022-11-14 19:45:37','925',1243457.05,1243457.05,'925','2022-11-14 10:54:57','925','2022-11-14 10:55:22',10,0),('8','213',66,'Daily shift','2022-11-14','2022-11-14 19:00:18','2022-11-15 19:00:18','925',1493030.10,1493030.10,'925','2022-11-14 19:05:51','925','2022-11-14 19:07:34',10,0),('8','213',67,'Daily shift','2022-11-15','2022-11-15 20:45:12','2022-11-16 20:45:12','925',1833393.90,1833393.90,'925','2022-11-15 20:50:34','925','2022-11-15 20:51:49',10,0),('8','213',68,'Daily shift','2022-11-16','2022-11-16 22:04:42','2022-11-17 22:04:42','925',939057.90,939057.90,'925','2022-11-16 22:11:30','925','2022-11-16 22:12:34',10,0),('8','213',69,'Daily shift','2022-11-24','2022-11-24 17:21:47','2022-11-25 17:21:47','925',1538544.80,1538544.80,'925','2022-11-24 20:05:39','925','2022-11-24 20:08:23',10,0),('8','213',70,'Daily shift','2022-11-25','2022-11-25 18:54:30','2022-11-26 18:54:30','925',1164077.20,1164077.20,'925','2022-11-25 18:57:18','925','2022-11-25 18:58:29',10,0),('8','213',71,'Daily shift','2022-11-26','2022-11-26 18:49:22','2022-11-27 18:49:22','925',1083823.00,1083823.00,'925','2022-11-26 18:52:47','925','2022-11-26 18:53:32',10,0),('8','213',72,'Daily shift','2022-11-27','2022-11-27 19:11:47','2022-11-28 19:11:47','925',1164360.60,1164360.60,'925','2022-11-27 19:14:35','925','2022-11-27 19:15:02',10,0),('8','213',73,'Daily shift','2022-11-28','2022-11-28 18:55:11','2022-11-29 18:55:11','925',1080617.20,1080617.20,'925','2022-11-28 18:59:17','925','2022-11-28 19:00:02',10,0),('8','213',74,'Daily shift','2022-11-29','2022-11-29 19:32:15','2022-11-30 19:32:15','925',1276662.40,1276662.40,'925','2022-11-29 19:34:27','925','2022-11-29 19:35:20',10,0),('8','213',75,'Daily shift','2022-11-30','2022-11-30 19:43:24','2022-12-01 19:43:24','925',2374886.80,2374886.80,'925','2022-11-30 19:46:43','925','2022-11-30 19:47:24',10,0),('8','213',76,'Daily shift','2022-12-01','2022-12-01 18:59:16','2022-12-02 18:59:16','925',1710378.80,1710378.80,'925','2022-12-01 19:02:50','925','2022-12-01 19:03:28',10,0),('8','213',77,'Daily shift','2022-12-02','2022-12-02 13:59:21','2022-12-03 13:59:21','925',1299030.20,1299030.20,'925','2022-12-02 14:01:42','925','2022-12-02 14:02:19',10,0),('8','213',78,'Daily shift','2022-12-17','2022-12-17 16:13:02','2022-12-18 16:13:02','925',1080565.20,1080565.20,'925','2022-12-18 08:02:52','925','2022-12-18 08:03:42',10,0),('8','213',79,'Daily shift','2022-12-18','2022-12-18 19:20:34','2022-12-19 19:20:34','925',1088518.08,1088518.08,'925','2022-12-18 19:24:33','925','2022-12-18 19:31:05',10,0),('8','213',80,'Daily shift','2022-12-19','2022-12-19 18:09:23','2022-12-20 18:09:23','925',1141960.56,1141960.56,'925','2022-12-20 07:21:17','925','2022-12-20 07:22:16',10,0),('8','213',81,'Daily shift','2022-12-20','2022-12-20 17:35:33','2022-12-21 17:35:33','925',1372756.32,1372756.32,'925','2022-12-21 09:14:45','925','2022-12-21 09:15:59',10,0),('8','213',82,'Daily shift','2022-12-21','2022-12-21 18:18:02','2022-12-22 18:18:02','925',1724214.96,1724214.96,'925','2022-12-22 08:29:59','925','2022-12-22 08:30:46',10,0),('8','213',83,'Daily shift','2022-12-22','2022-12-22 16:17:46','2022-12-29 16:17:46','925',1056241.68,1056241.68,'925','2022-12-23 07:56:04','925','2022-12-23 07:56:46',10,0),('8','213',84,'Daily shift','2022-12-24','2022-12-24 06:02:14','2022-12-31 06:02:14','925',973374.48,973374.48,'925','2022-12-24 06:04:24','925','2022-12-24 06:05:32',10,0),('8','213',85,'Daily shift','2022-12-24','2022-12-24 18:42:42','2022-12-31 18:42:42','925',1117215.84,1117215.84,'925','2022-12-25 08:13:15','925','2022-12-25 08:16:22',10,0),('8','213',86,'Daily shift','2022-12-25','2022-12-25 14:47:20','2023-01-01 14:47:20','925',738861.00,738861.00,'925','2022-12-26 07:30:23','925','2022-12-26 07:31:37',10,0),('8','213',87,'Daily shift','2022-12-26','2022-12-26 19:02:57','2023-01-02 19:02:57','925',936651.00,936651.00,'925','2022-12-26 19:05:29','925','2022-12-26 19:06:24',10,0),('8','213',88,'Daily shift','2022-12-27','2022-12-27 16:30:55','2023-01-03 16:30:55','925',1235781.00,1235781.00,'925','2022-12-27 19:14:27','925','2022-12-27 19:15:37',10,0),('8','213',89,'Daily shift','2022-12-28','2022-12-28 17:23:25','2023-01-04 17:23:25','925',1410156.00,1410156.00,'925','2022-12-28 17:37:48','925','2022-12-28 17:38:27',10,0),('8','213',90,'Daily shift','2023-01-02','2023-01-02 20:27:27','2023-01-09 20:27:27','925',1087625.50,1087625.50,'925','2023-01-02 20:34:01','925','2023-01-02 20:34:32',10,0),('8','213',91,'Daily shift','2023-01-03','2023-01-03 21:06:42','2023-01-10 21:06:42','925',941471.40,941471.40,'925','2023-01-03 21:12:05','925','2023-01-03 21:12:51',10,0),('8','213',92,'Daily shift','2023-01-04','2023-01-04 20:27:06','2023-01-11 20:27:06','925',1415622.18,1415622.18,'925','2023-01-04 20:29:37','925','2023-01-04 20:30:28',10,0),('8','213',93,'Daily shift','2023-01-05','2023-01-05 19:57:20','2023-01-12 19:57:20','925',1203455.12,1203455.12,'925','2023-01-05 19:59:36','925','2023-01-05 20:00:10',10,0),('8','213',94,'Daily shift','2023-01-06','2023-01-06 19:07:10','2023-01-13 19:07:10','925',1339614.30,1339614.30,'925','2023-01-06 19:08:40','925','2023-01-06 19:09:00',10,0),('8','213',95,'Daily shift','2023-01-07','2023-01-07 19:17:11','2023-01-14 19:17:11','925',1115858.02,1115858.02,'925','2023-01-07 19:18:31','925','2023-01-07 19:19:00',10,0),('8','213',96,'Daily shift','2023-01-08','2023-01-08 22:34:30','2023-01-15 22:34:30','925',1115503.40,1115503.40,'925','2023-01-08 22:39:07','925','2023-01-08 22:39:44',10,0),('8','213',97,'Daily shift','2023-01-09','2023-01-09 19:13:58','2023-01-16 19:13:58','925',1636407.40,1636407.40,'925','2023-01-10 07:56:33','925','2023-01-10 07:57:01',10,0),('8','213',98,'Daily shift','2023-01-10','2023-01-10 19:18:30','2023-01-17 19:18:30','925',1480517.64,1480517.64,'925','2023-01-11 07:21:25','925','2023-01-11 07:22:03',10,0),('8','213',99,'Daily shift','2023-01-11','2023-01-11 19:33:10','2023-01-18 19:33:10','925',1893909.20,1893909.20,'925','2023-01-12 07:53:04','925','2023-01-12 07:53:32',10,0),('8','213',100,'Daily shift','2023-01-12','2023-01-12 19:25:24','2023-01-19 19:25:24','925',732105.54,732105.54,'925','2023-01-13 08:23:20','925','2023-01-13 08:24:21',10,0),('8','213',101,'Daily shift','2023-01-13','2023-01-13 09:00:50','2023-01-20 09:00:50','925',613778.68,613778.68,'925','2023-01-13 09:09:27','925','2023-01-13 09:17:48',10,0),('8','213',102,'Daily shift','2023-02-01','2023-02-01 21:31:26','2023-02-08 21:31:26','925',2174141.70,2174141.70,'925','2023-02-02 07:56:14','925','2023-02-02 07:56:55',10,0),('8','213',103,'Daily shift','2023-02-02','2023-02-02 21:01:44','2023-02-09 21:01:44','925',1297658.85,1297658.85,'925','2023-02-03 07:53:58','925','2023-02-03 07:54:50',10,0),('8','213',104,'Daily shift','2023-02-03','2023-02-03 21:46:26','2023-02-10 21:46:26','925',1486380.75,1486380.75,'925','2023-02-03 21:49:01','925','2023-02-03 21:50:43',10,0),('8','213',105,'Daily shift','2023-02-04','2023-02-04 21:08:48','2023-02-11 21:08:48','925',1342381.20,1342381.20,'925','2023-02-05 07:23:22','925','2023-02-05 07:24:07',10,0),('8','213',106,'Daily shift','2023-02-05','2023-02-05 19:39:32','2023-02-12 19:39:32','925',1589366.70,1589366.70,'925','2023-02-05 19:41:56','925','2023-02-05 19:42:59',10,0),('8','213',107,'Daily shift','2023-02-06','2023-02-06 20:34:47','2023-02-13 20:34:47','925',2254609.50,2254609.50,'925','2023-02-07 07:26:53','925','2023-02-07 07:27:53',10,0),('8','213',108,'Daily shift','2023-02-07','2023-02-07 21:27:23','2023-02-14 21:27:23','925',2544630.30,2544630.30,'925','2023-02-08 09:51:27','925','2023-02-08 09:51:59',10,0),('8','213',109,'Daily shift','2023-02-08','2023-02-08 21:03:39','2023-02-15 21:03:39','925',2663544.90,2663544.90,'925','2023-02-09 07:42:08','925','2023-02-09 07:42:49',10,0),('8','213',110,'Daily shift','2023-02-09','2023-02-09 21:55:53','2023-02-16 21:55:53','925',2675830.35,2675830.35,'925','2023-02-10 20:22:33','925','2023-02-10 20:23:50',10,0),('8','213',111,'Daily shift','2023-02-10','2023-02-10 20:47:26','2023-02-17 20:47:26','925',1784467.65,1784467.65,'925','2023-02-11 20:54:31','925','2023-02-11 20:55:50',10,0),('8','213',112,'Daily shift','2023-02-11','2023-02-11 21:05:14','2023-02-18 21:05:14','925',2218653.60,2218653.60,'925','2023-02-12 10:32:34','925','2023-02-12 10:32:58',10,0),('8','213',113,'Daily shift','2023-02-12','2023-02-12 10:38:05','2023-02-19 10:38:05','925',1069700.10,1069700.10,'925','2023-02-12 10:41:25','925','2023-02-12 10:42:15',10,0),('8','213',114,'Daily shift','2023-02-17','2023-02-17 21:11:35','2023-02-24 21:11:35','925',1152127.40,1152127.40,'925','2023-02-18 17:04:26','925','2023-02-18 17:05:09',10,0),('8','213',115,'Daily shift','2023-02-18','2023-02-18 21:04:36','2023-02-25 21:04:36','925',1129048.20,1129048.20,'925','2023-02-19 17:12:43','925','2023-02-19 17:13:43',10,0),('8','213',116,'Daily shift','2023-02-19','2023-02-19 20:36:40','2023-02-26 20:36:40','925',1261564.64,1261564.64,'925','2023-02-20 13:02:21','925','2023-02-20 13:02:51',10,0),('8','213',117,'Daily shift','2023-02-20','2023-02-20 20:45:33','2023-02-27 20:45:33','925',1359116.00,1359116.00,'925','2023-02-21 10:04:46','925','2023-02-21 10:05:40',10,0),('8','213',118,'Daily shift','2023-02-22','2023-02-22 17:18:46','2023-03-01 17:18:46','925',1002585.20,1002585.20,'925','2023-02-22 17:23:41','925','2023-02-22 17:24:07',10,0),('8','213',119,'Daily shift','2023-02-22','2023-02-22 21:14:16','2023-03-01 21:14:16','925',1494555.00,1494555.00,'925','2023-02-23 14:46:24','925','2023-02-23 14:47:02',10,0),('8','213',120,'Daily shift','2023-02-23','2023-02-23 21:23:13','2023-03-02 21:23:13','925',1350697.60,1350697.60,'925','2023-02-26 21:09:38','925','2023-02-26 21:10:07',10,0),('8','213',121,'Daily shift','2023-02-26','2023-02-26 21:15:35','2023-02-27 21:15:35','925',1894966.40,1894966.40,'925','2023-02-26 21:18:27','925','2023-02-26 21:19:20',10,0),('8','213',122,'Daily shift','2023-02-26','2023-02-26 21:23:30','2023-02-27 21:23:30','925',2331148.80,2331148.80,'925','2023-02-26 21:27:55','925','2023-02-26 21:48:43',10,0),('8','213',123,'Daily shift','2023-02-27','2023-02-27 22:09:51','2023-02-28 22:09:51','925',1740489.60,1740489.60,'925','2023-02-28 07:52:49','925','2023-02-28 07:53:28',10,0),('8','213',124,'Daily shift','2023-02-28','2023-02-28 21:36:27','2023-03-07 21:36:27','925',1424915.20,1424915.20,'925','2023-03-01 19:10:35','925','2023-03-01 19:12:11',10,0),('8','213',125,'Daily shift','2023-03-07','2023-03-07 22:16:57','2023-03-08 22:16:57','925',0.00,0.00,'926','2023-03-14 17:01:51','926','2023-03-14 17:02:07',10,0),('8','213',126,'Daily shift','2023-03-15','2023-03-15 17:00:05','2023-03-22 17:00:05','925',2131543.15,2131543.15,'925','2023-03-15 17:18:04','925','2023-03-15 17:19:12',10,0),('8','213',127,'Daily shift','2023-03-15','2023-03-15 17:23:01','2023-03-16 17:23:01','925',2194611.20,2194611.20,'925','2023-03-15 17:25:35','925','2023-03-15 17:26:06',10,0),('8','213',128,'Daily shift','2023-03-15','2023-03-15 17:30:32','2023-03-16 17:30:32','925',1957283.70,1957283.70,'925','2023-03-15 17:36:08','925','2023-03-15 17:36:37',10,0),('8','213',129,'Daily shift','2023-03-15','2023-03-15 17:40:02','2023-03-16 17:40:02','925',1548245.55,1548245.55,'925','2023-03-15 17:43:11','925','2023-03-15 17:43:48',10,0),('8','213',130,'Daily shift','2023-03-15','2023-03-15 17:45:04','2023-03-16 17:45:04','925',2358749.20,2358749.20,'925','2023-03-15 17:47:08','925','2023-03-15 17:47:42',10,0),('8','213',131,'Daily shift','2023-03-15','2023-03-15 21:48:28','2023-03-16 21:48:28','925',1028809.55,1028809.55,'925','2023-03-15 21:52:08','925','2023-03-15 21:52:47',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=911 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('8','213','1','1',1,'1','1',770991.47,770991.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','1',2,'2','1',36821.70,36821.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','1',3,'3','1',727331.02,727331.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','1',5,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','1',6,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','1',7,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','2',8,'1','1',770991.47,770991.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','2',9,'2','1',36821.70,36821.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','2',10,'3','1',727331.02,727331.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','2',11,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','2',12,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','2',13,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','2',14,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','3',15,'1','1',770991.47,772729.14,1737.67,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','3',16,'2','1',36821.70,36821.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','3',17,'3','1',727331.02,729614.23,2283.21,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','3',18,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','3',19,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','3',20,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','3',21,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','5',22,'1','1',772729.14,774397.60,1668.46,358718.90,0.00,0.00,0.00,0.00,0.00),('8','213','1','5',23,'2','1',36821.70,36821.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','5',24,'3','1',729614.23,731565.15,1950.92,419447.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','5',25,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','5',26,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','5',27,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','5',28,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','6',29,'1','1',774397.60,775582.55,1184.95,254764.25,0.00,0.00,0.00,0.00,0.00),('8','213','1','6',30,'2','1',36821.70,36821.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','6',31,'3','1',731565.15,734086.53,2521.38,542096.70,0.00,0.00,0.00,0.00,0.00),('8','213','2','6',32,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','6',33,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','6',34,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','6',35,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','7',36,'1','1',775582.55,776810.48,1227.93,257865.30,0.00,0.00,0.00,0.00,0.00),('8','213','1','7',37,'2','1',36821.70,36821.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','7',38,'3','1',734086.53,735563.99,1477.46,310266.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','7',39,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','7',40,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','7',41,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','7',42,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','8',43,'1','1',776810.48,778164.12,1353.64,284264.40,0.00,0.00,0.00,0.00,0.00),('8','213','1','8',44,'2','1',36821.70,37841.92,1020.22,214246.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','8',45,'3','1',735563.99,735674.92,110.93,23295.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','8',46,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','8',47,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','8',48,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','8',49,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','9',50,'1','1',778164.12,779137.15,973.03,204336.30,0.00,0.00,0.00,0.00,0.00),('8','213','1','9',51,'2','1',37841.92,39158.90,1316.98,276565.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','9',52,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','9',53,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','9',54,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','9',55,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','9',56,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','10',57,'1','1',779137.15,781090.68,1953.53,404380.71,0.00,0.00,0.00,0.00,0.00),('8','213','1','10',58,'2','1',39158.90,40972.68,1813.78,375452.46,0.00,0.00,0.00,0.00,0.00),('8','213','2','10',59,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','10',60,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','10',61,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','10',62,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','10',63,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','11',64,'1','1',781090.68,783845.62,2754.94,570272.58,0.00,0.00,0.00,0.00,0.00),('8','213','1','11',65,'2','1',40972.68,43749.00,2776.32,574698.24,0.00,0.00,0.00,0.00,0.00),('8','213','2','11',66,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','11',67,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','11',68,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','11',69,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','11',70,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','12',71,'1','1',783845.62,783845.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','12',72,'2','1',43749.00,43749.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','12',73,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','12',74,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','12',75,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','12',76,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','12',77,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','13',78,'1','1',783845.62,783845.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','13',79,'2','1',43749.00,43749.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','13',80,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','13',81,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','13',82,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','13',83,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','13',84,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','14',85,'1','1',783845.62,784876.77,1031.15,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','14',86,'2','1',43749.00,45163.56,1414.56,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','14',87,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','14',88,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','14',89,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','14',90,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','14',91,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','15',92,'1','1',784876.77,786676.73,1799.96,359992.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','15',93,'2','1',45163.56,46961.78,1798.22,359644.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','15',94,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','15',95,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','15',96,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','15',97,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','15',98,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','16',99,'1','1',786676.73,787819.86,1143.13,228626.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','16',100,'2','1',46961.78,48294.22,1332.44,266488.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','16',101,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','16',102,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','16',103,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','16',104,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','16',105,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','17',106,'1','1',787819.86,789000.59,1180.73,236146.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','17',107,'2','1',48294.22,50016.86,1722.64,344528.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','17',108,'3','1',735674.92,735674.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','17',109,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','17',110,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','17',111,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','17',112,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','18',113,'1','1',789000.59,790571.19,1570.60,314120.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','18',114,'2','1',50016.86,50933.10,916.24,183248.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','18',115,'3','1',735674.92,736426.91,751.99,150398.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','18',116,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','18',117,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','18',118,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','18',119,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','19',120,'1','1',790571.19,794053.24,3482.05,678999.75,0.00,0.00,0.00,0.00,0.00),('8','213','1','19',121,'2','1',50933.10,51934.31,1001.21,195235.95,0.00,0.00,0.00,0.00,0.00),('8','213','2','19',122,'3','1',736426.91,739554.46,3127.55,609872.25,0.00,0.00,0.00,0.00,0.00),('8','213','2','19',123,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','19',124,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','19',125,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','19',126,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','20',127,'1','1',794053.24,796258.11,2204.87,429949.65,0.00,0.00,0.00,0.00,0.00),('8','213','1','20',128,'2','1',51934.31,51934.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','20',129,'3','1',739554.46,741454.58,1900.12,370523.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','20',130,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','20',131,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','20',132,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','20',133,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','21',134,'1','1',796258.11,797930.33,1672.22,326082.90,0.00,0.00,0.00,0.00,0.00),('8','213','1','21',135,'2','1',51934.31,51934.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','21',136,'3','1',741454.58,743668.82,2214.24,431776.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','21',137,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','21',138,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','21',139,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','21',140,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','22',141,'1','1',797930.33,799723.22,1792.89,349613.55,0.00,0.00,0.00,0.00,0.00),('8','213','1','22',142,'2','1',51934.31,51934.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','22',143,'3','1',743668.82,745772.53,2103.71,410223.45,0.00,0.00,0.00,0.00,0.00),('8','213','2','22',144,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','22',145,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','22',146,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','22',147,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','23',148,'1','1',799723.22,801306.06,1582.84,308653.80,0.00,0.00,0.00,0.00,0.00),('8','213','1','23',149,'2','1',51934.31,51934.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','23',150,'3','1',745772.53,747589.98,1817.45,354402.75,0.00,0.00,0.00,0.00,0.00),('8','213','2','23',151,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','23',152,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','23',153,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','23',154,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','24',155,'1','1',801306.06,802955.78,1649.72,321695.40,0.00,0.00,0.00,0.00,0.00),('8','213','1','24',156,'2','1',51934.31,51934.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','24',157,'3','1',747589.98,749479.70,1889.72,368495.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','24',158,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','24',159,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','24',160,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','24',161,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','25',162,'1','1',802955.78,805011.36,2055.58,400838.10,0.00,0.00,0.00,0.00,0.00),('8','213','1','25',163,'2','1',51934.31,51934.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','25',164,'3','1',749479.70,751409.22,1929.52,376256.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','25',165,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','25',166,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','25',167,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','25',168,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','26',169,'1','1',805011.36,805011.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','26',170,'2','1',51934.31,51934.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','26',171,'3','1',751409.22,751409.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','26',172,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','26',173,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','26',174,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','26',175,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','27',176,'1','1',805011.36,808253.78,3242.42,632271.90,0.00,0.00,0.00,0.00,0.00),('8','213','1','27',177,'2','1',51934.31,54913.81,2979.50,581002.50,0.00,0.00,0.00,0.00,0.00),('8','213','2','27',178,'3','1',751409.22,751409.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','27',179,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','27',180,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','27',181,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','27',182,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','28',183,'1','1',808253.78,809820.01,1566.23,305414.85,0.00,0.00,0.00,0.00,0.00),('8','213','1','28',184,'2','1',54913.81,54913.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','28',185,'3','1',751409.22,754509.51,3100.29,604556.55,0.00,0.00,0.00,0.00,0.00),('8','213','2','28',186,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','28',187,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','28',188,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','28',189,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','29',190,'1','1',809820.01,811671.53,1851.52,361046.40,0.00,0.00,0.00,0.00,0.00),('8','213','1','29',191,'2','1',54913.81,57318.52,2404.71,468918.45,0.00,0.00,0.00,0.00,0.00),('8','213','2','29',192,'3','1',754509.51,754509.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','29',193,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','29',194,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','29',195,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','29',196,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','30',197,'1','1',811671.53,813534.20,1862.67,363220.65,0.00,0.00,0.00,0.00,0.00),('8','213','1','30',198,'2','1',57318.52,59283.98,1965.46,383264.70,0.00,0.00,0.00,0.00,0.00),('8','213','2','30',199,'3','1',754509.51,754509.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','30',200,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','30',201,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','30',202,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','30',203,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','31',204,'1','1',813534.20,815281.71,1747.51,340764.45,0.00,0.00,0.00,0.00,0.00),('8','213','1','31',205,'2','1',59283.98,61928.03,2644.05,515589.75,0.00,0.00,0.00,0.00,0.00),('8','213','2','31',206,'3','1',754509.51,754509.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','31',207,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','31',208,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','31',209,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','31',210,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','32',211,'1','1',815281.71,817966.85,2685.14,523602.30,0.00,0.00,0.00,0.00,0.00),('8','213','1','32',212,'2','1',61928.03,63293.72,1365.69,266309.55,0.00,0.00,0.00,0.00,0.00),('8','213','2','32',213,'3','1',754509.51,755280.68,771.17,150378.15,0.00,0.00,0.00,0.00,0.00),('8','213','2','32',214,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','32',215,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','32',216,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','32',217,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','33',218,'1','1',817966.85,820062.93,2096.08,408735.60,0.00,0.00,0.00,0.00,0.00),('8','213','1','33',219,'2','1',63293.72,63293.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','33',220,'3','1',755280.68,758269.98,2989.30,582913.50,0.00,0.00,0.00,0.00,0.00),('8','213','2','33',221,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','33',222,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','33',223,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','33',224,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','34',225,'1','1',820062.93,822780.31,2717.38,529889.10,0.00,0.00,0.00,0.00,0.00),('8','213','1','34',226,'2','1',63293.72,63293.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','34',227,'3','1',758269.98,761428.71,3158.73,615952.35,0.00,0.00,0.00,0.00,0.00),('8','213','2','34',228,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','34',229,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','34',230,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','34',231,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','35',232,'1','1',822780.31,825076.93,2296.62,447840.90,0.00,0.00,0.00,0.00,0.00),('8','213','1','35',233,'2','1',63293.72,63293.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','35',234,'3','1',761428.71,764541.51,3112.80,606996.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','35',235,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','35',236,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','35',237,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','35',238,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','36',239,'1','1',825076.93,826704.51,1627.58,317378.10,0.00,0.00,0.00,0.00,0.00),('8','213','1','36',240,'2','1',63293.72,63293.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','36',241,'3','1',764541.51,766809.82,2268.31,442320.45,0.00,0.00,0.00,0.00,0.00),('8','213','2','36',242,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','36',243,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','36',244,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','36',245,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','37',246,'1','1',826704.51,828389.74,1685.23,328619.85,0.00,0.00,0.00,0.00,0.00),('8','213','1','37',247,'2','1',63293.72,63293.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','37',248,'3','1',766809.82,769088.63,2278.81,444367.95,0.00,0.00,0.00,0.00,0.00),('8','213','2','37',249,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','37',250,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','37',251,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','37',252,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','38',253,'1','1',828389.74,830469.32,2079.58,405518.10,0.00,0.00,0.00,0.00,0.00),('8','213','1','38',254,'2','1',63293.72,65653.24,2359.52,460106.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','38',255,'3','1',769088.63,769165.38,76.75,14966.25,0.00,0.00,0.00,0.00,0.00),('8','213','2','38',256,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','38',257,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','38',258,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','38',259,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','39',260,'1','1',830469.32,833518.59,3049.27,594607.65,0.00,0.00,0.00,0.00,0.00),('8','213','1','39',261,'2','1',65653.24,69097.22,3443.98,671576.10,0.00,0.00,0.00,0.00,0.00),('8','213','2','39',262,'3','1',769165.38,769165.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','39',263,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','39',264,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','39',265,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','39',266,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','40',267,'1','1',833518.59,835690.31,2171.72,412626.80,0.00,0.00,0.00,0.00,0.00),('8','213','1','40',268,'2','1',69097.22,71939.82,2842.60,540094.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','40',269,'3','1',769165.38,769165.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','40',270,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','40',271,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','40',272,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','40',273,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','41',274,'1','1',835690.31,838163.81,2473.50,469965.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','41',275,'2','1',71939.82,72302.76,362.94,68958.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','41',276,'3','1',769165.38,771534.42,2369.04,450117.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','41',277,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','41',278,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','41',279,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','41',280,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','42',281,'1','1',838163.81,840759.29,2595.48,493141.20,0.00,0.00,0.00,0.00,0.00),('8','213','1','42',282,'2','1',72302.76,72302.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','42',283,'3','1',771534.42,773963.00,2428.58,461430.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','42',284,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','42',285,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','42',286,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','42',287,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','43',288,'1','1',840759.29,842985.18,2225.89,422919.10,0.00,0.00,0.00,0.00,0.00),('8','213','1','43',289,'2','1',72302.76,72302.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','43',290,'3','1',773963.00,776354.03,2391.03,454295.70,0.00,0.00,0.00,0.00,0.00),('8','213','2','43',291,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','43',292,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','43',293,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','43',294,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','44',295,'1','1',842985.18,845498.76,2513.58,477580.20,0.00,0.00,0.00,0.00,0.00),('8','213','1','44',296,'2','1',72302.76,72302.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','44',297,'3','1',776354.03,778596.79,2242.76,426124.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','44',298,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','44',299,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','44',300,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','44',301,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','45',302,'1','1',845498.76,847832.37,2333.61,443385.90,0.00,0.00,0.00,0.00,0.00),('8','213','1','45',303,'2','1',72302.76,72302.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','45',304,'3','1',778596.79,782527.06,3930.27,746751.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','45',305,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','45',306,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','45',307,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','45',308,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','46',309,'1','1',847832.37,851174.94,3342.57,635088.30,0.00,0.00,0.00,0.00,0.00),('8','213','1','46',310,'2','1',72302.76,74115.31,1812.55,344384.50,0.00,0.00,0.00,0.00,0.00),('8','213','2','46',311,'3','1',782527.06,784159.18,1632.12,310102.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','46',312,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','46',313,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','46',314,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','46',315,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','47',316,'1','1',851174.94,853177.32,2002.38,380452.20,0.00,0.00,0.00,0.00,0.00),('8','213','1','47',317,'2','1',74115.31,75302.28,1186.97,225524.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','47',318,'3','1',784159.18,785186.21,1027.03,195135.70,0.00,0.00,0.00,0.00,0.00),('8','213','2','47',319,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','47',320,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','47',321,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','47',322,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','48',323,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','48',324,'2','1',75302.28,77399.69,2097.41,398507.90,0.00,0.00,0.00,0.00,0.00),('8','213','2','48',325,'3','1',785186.21,789030.82,3844.61,730475.90,0.00,0.00,0.00,0.00,0.00),('8','213','2','48',326,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','48',327,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','48',328,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','48',329,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','49',330,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','49',331,'2','1',77399.69,80262.65,2862.96,543962.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','49',332,'3','1',789030.82,791677.41,2646.59,502852.10,0.00,0.00,0.00,0.00,0.00),('8','213','2','49',333,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','49',334,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','49',335,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','49',336,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','50',337,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','50',338,'2','1',80262.65,83298.26,3035.61,576765.90,0.00,0.00,0.00,0.00,0.00),('8','213','2','50',339,'3','1',791677.41,795747.91,4070.50,773395.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','50',340,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','50',341,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','50',342,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','50',343,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','51',344,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','51',345,'2','1',83298.26,86691.31,3393.05,644679.50,0.00,0.00,0.00,0.00,0.00),('8','213','2','51',346,'3','1',795747.91,800866.39,5118.48,972511.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','51',347,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','51',348,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','51',349,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','51',350,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','52',351,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','52',352,'2','1',86691.31,89712.23,3020.92,573974.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','52',353,'3','1',800866.39,803292.41,2426.02,460943.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','52',354,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','52',355,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','52',356,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','52',357,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','53',358,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','53',359,'2','1',89712.23,91922.74,2210.51,419996.90,0.00,0.00,0.00,0.00,0.00),('8','213','2','53',360,'3','1',803292.41,804471.04,1178.63,223939.70,0.00,0.00,0.00,0.00,0.00),('8','213','2','53',361,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','53',362,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','53',363,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','53',364,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','54',365,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','54',366,'2','1',91922.74,92324.96,402.22,76421.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','54',367,'3','1',804471.04,810259.45,5788.41,1099797.90,0.00,0.00,0.00,0.00,0.00),('8','213','2','54',368,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','54',369,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','54',370,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','54',371,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','55',372,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','55',373,'2','1',92324.96,92324.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','55',374,'3','1',810259.45,815261.70,5002.25,950427.50,0.00,0.00,0.00,0.00,0.00),('8','213','2','55',375,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','55',376,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','55',377,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','55',378,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','56',379,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','56',380,'2','1',92324.96,92672.60,347.64,66051.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','56',381,'3','1',815261.70,817996.11,2734.41,519537.90,0.00,0.00,0.00,0.00,0.00),('8','213','2','56',382,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','56',383,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','56',384,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','56',385,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','57',386,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','57',387,'2','1',92672.60,99116.64,6444.04,1308140.12,0.00,0.00,0.00,0.00,0.00),('8','213','2','57',388,'3','1',817996.11,825259.15,7263.04,1474397.12,0.00,0.00,0.00,0.00,0.00),('8','213','2','57',389,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','57',390,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','57',391,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','57',392,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','58',393,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','58',394,'2','1',99116.64,105159.51,6042.87,1250874.09,0.00,0.00,0.00,0.00,0.00),('8','213','2','58',395,'3','1',825259.15,834237.73,8978.58,1858566.06,0.00,0.00,0.00,0.00,0.00),('8','213','2','58',396,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','58',397,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','58',398,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','58',399,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','59',400,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','59',401,'2','1',105159.51,109660.39,4500.88,990193.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','59',402,'3','1',834237.73,841535.31,7297.58,1605467.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','59',403,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','59',404,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','59',405,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','59',406,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','60',407,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','60',408,'2','1',109660.39,109660.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','60',409,'3','1',841535.31,851661.17,10125.86,2227689.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','60',410,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','60',411,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','60',412,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','60',413,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','61',414,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','61',415,'2','1',109660.39,113425.97,3765.58,952691.74,0.00,0.00,0.00,0.00,0.00),('8','213','2','61',416,'3','1',851661.17,856372.24,4711.07,1191900.71,0.00,0.00,0.00,0.00,0.00),('8','213','2','61',417,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','61',418,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','61',419,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','61',420,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','62',421,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','62',422,'2','1',113425.97,116624.61,3198.64,809255.92,0.00,0.00,0.00,0.00,0.00),('8','213','2','62',423,'3','1',856372.24,860552.30,4180.06,1057555.18,0.00,0.00,0.00,0.00,0.00),('8','213','2','62',424,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','62',425,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','62',426,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','62',427,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','63',428,'1','1',853177.32,853177.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','63',429,'2','1',116624.61,119634.60,3009.99,761527.47,0.00,0.00,0.00,0.00,0.00),('8','213','2','63',430,'3','1',860552.30,864107.60,3555.30,899490.90,0.00,0.00,0.00,0.00,0.00),('8','213','2','63',431,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','63',432,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','63',433,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','63',434,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','64',435,'1','1',853177.32,853298.75,121.43,30721.79,0.00,0.00,0.00,0.00,0.00),('8','213','1','64',436,'2','1',119634.60,122535.56,2900.96,733942.88,0.00,0.00,0.00,0.00,0.00),('8','213','2','64',437,'3','1',864107.60,867062.22,2954.62,747518.86,0.00,0.00,0.00,0.00,0.00),('8','213','2','64',438,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','64',439,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','64',440,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','64',441,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','65',442,'1','1',853298.75,853298.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','65',443,'2','1',122535.56,125543.52,3007.96,761013.88,0.00,0.00,0.00,0.00,0.00),('8','213','2','65',444,'3','1',867062.22,868969.11,1906.89,482443.17,0.00,0.00,0.00,0.00,0.00),('8','213','2','65',445,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','65',446,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','65',447,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','65',448,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','66',449,'1','1',853298.75,855651.16,2352.41,599864.55,0.00,0.00,0.00,0.00,0.00),('8','213','1','66',450,'2','1',125543.52,129046.13,3502.61,893165.55,0.00,0.00,0.00,0.00,0.00),('8','213','2','66',451,'3','1',868969.11,868969.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','66',452,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','66',453,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','66',454,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','66',455,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','67',456,'1','1',855651.16,858760.98,3109.82,793004.10,0.00,0.00,0.00,0.00,0.00),('8','213','1','67',457,'2','1',129046.13,133126.09,4079.96,1040389.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','67',458,'3','1',868969.11,868969.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','67',459,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','67',460,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','67',461,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','67',462,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','68',463,'1','1',858760.98,860438.13,1677.15,427673.25,0.00,0.00,0.00,0.00,0.00),('8','213','1','68',464,'2','1',133126.09,135131.52,2005.43,511384.65,0.00,0.00,0.00,0.00,0.00),('8','213','2','68',465,'3','1',868969.11,868969.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','68',466,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','68',467,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','68',468,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','68',469,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','69',470,'1','1',860438.13,860438.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','69',471,'2','1',135131.52,137195.59,2064.07,536658.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','69',472,'3','1',868969.11,872822.52,3853.41,1001886.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','69',473,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','69',474,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','69',475,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','69',476,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','70',477,'1','1',860438.13,860438.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','70',478,'2','1',137195.59,138668.85,1473.26,383047.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','70',479,'3','1',872822.52,875826.48,3003.96,781029.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','70',480,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','70',481,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','70',482,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','70',483,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','71',484,'1','1',860438.13,860438.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','71',485,'2','1',138668.85,140782.50,2113.65,549549.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','71',486,'3','1',875826.48,877881.38,2054.90,534274.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','71',487,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','71',488,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','71',489,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','71',490,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','72',491,'1','1',860438.13,860438.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','72',492,'2','1',140782.50,142169.25,1386.75,360555.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','72',493,'3','1',877881.38,880972.94,3091.56,803805.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','72',494,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','72',495,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','72',496,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','72',497,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','73',498,'1','1',860438.13,860438.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','73',499,'2','1',142169.25,143307.86,1138.61,296038.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','73',500,'3','1',880972.94,883990.55,3017.61,784578.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','73',501,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','73',502,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','73',503,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','73',504,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','74',505,'1','1',860438.13,861355.56,917.43,238531.80,0.00,0.00,0.00,0.00,0.00),('8','213','1','74',506,'2','1',143307.86,145056.90,1749.04,454750.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','74',507,'3','1',883990.55,886234.32,2243.77,583380.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','74',508,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','74',509,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','74',510,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','74',511,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','75',512,'1','1',861355.56,864889.35,3533.79,918785.40,0.00,0.00,0.00,0.00,0.00),('8','213','1','75',513,'2','1',145056.90,145486.13,429.23,111599.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','75',514,'3','1',886234.32,891405.48,5171.16,1344501.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','75',515,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','75',516,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','75',517,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','75',518,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','76',519,'1','1',864889.35,866744.08,1854.73,482229.80,0.00,0.00,0.00,0.00,0.00),('8','213','1','76',520,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','76',521,'3','1',891405.48,896129.13,4723.65,1228149.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','76',522,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','76',523,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','76',524,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','76',525,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','77',526,'1','1',866744.08,866744.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','77',527,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','77',528,'3','1',896129.13,901125.40,4996.27,1299030.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','77',529,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','77',530,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','77',531,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','77',532,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','78',533,'1','1',866744.08,868480.43,1736.35,541741.20,0.00,0.00,0.00,0.00,0.00),('8','213','1','78',534,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','78',535,'3','1',901125.40,902852.40,1727.00,538824.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','78',536,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','78',537,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','78',538,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','78',539,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','79',540,'1','1',868480.43,870118.08,1637.65,510946.80,0.00,0.00,0.00,0.00,0.00),('8','213','1','79',541,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','79',542,'3','1',902852.40,904703.59,1851.19,577571.28,0.00,0.00,0.00,0.00,0.00),('8','213','2','79',543,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','79',544,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','79',545,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','79',546,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','80',547,'1','1',870118.08,871704.27,1586.19,494891.28,0.00,0.00,0.00,0.00,0.00),('8','213','1','80',548,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','80',549,'3','1',904703.59,906777.53,2073.94,647069.28,0.00,0.00,0.00,0.00,0.00),('8','213','2','80',550,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','80',551,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','80',552,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','80',553,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','81',554,'1','1',871704.27,873704.98,2000.71,624221.52,0.00,0.00,0.00,0.00,0.00),('8','213','1','81',555,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','81',556,'3','1',906777.53,909176.68,2399.15,748534.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','81',557,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','81',558,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','81',559,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','81',560,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','82',561,'1','1',873704.98,876275.80,2570.82,802095.84,0.00,0.00,0.00,0.00,0.00),('8','213','1','82',562,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','82',563,'3','1',909176.68,912132.19,2955.51,922119.12,0.00,0.00,0.00,0.00,0.00),('8','213','2','82',564,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','82',565,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','82',566,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','82',567,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','83',568,'1','1',876275.80,877796.06,1520.26,474321.12,0.00,0.00,0.00,0.00,0.00),('8','213','1','83',569,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','83',570,'3','1',912132.19,913997.32,1865.13,581920.56,0.00,0.00,0.00,0.00,0.00),('8','213','2','83',571,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','83',572,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','83',573,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','83',574,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','84',575,'1','1',877796.06,879028.11,1232.05,384399.60,0.00,0.00,0.00,0.00,0.00),('8','213','1','84',576,'2','1',145486.13,145486.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','84',577,'3','1',913997.32,915885.06,1887.74,588974.88,0.00,0.00,0.00,0.00,0.00),('8','213','2','84',578,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','84',579,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','84',580,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','84',581,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','85',582,'1','1',879028.11,880589.89,1561.78,487275.36,0.00,0.00,0.00,0.00,0.00),('8','213','1','85',583,'2','1',145486.13,145869.68,383.55,119667.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','85',584,'3','1',915885.06,917520.55,1635.49,510272.88,0.00,0.00,0.00,0.00,0.00),('8','213','2','85',585,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','85',586,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','85',587,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','85',588,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','86',589,'1','1',880589.89,881804.15,1214.26,364278.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','86',590,'2','1',145869.68,147118.29,1248.61,374583.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','86',591,'3','1',917520.55,917520.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','86',592,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','86',593,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','86',594,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','86',595,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','87',596,'1','1',881804.15,883225.27,1421.12,426336.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','87',597,'2','1',147118.29,148819.34,1701.05,510315.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','87',598,'3','1',917520.55,917520.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','87',599,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','87',600,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','87',601,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','87',602,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','88',603,'1','1',883225.27,885154.82,1929.55,578865.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','88',604,'2','1',148819.34,151009.06,2189.72,656916.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','88',605,'3','1',917520.55,917520.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','88',606,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','88',607,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','88',608,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','88',609,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','89',610,'1','1',885154.82,887052.21,1897.39,569217.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','89',611,'2','1',151009.06,153812.19,2803.13,840939.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','89',612,'3','1',917520.55,917520.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','89',613,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','89',614,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','89',615,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','89',616,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','90',617,'1','1',887052.21,888570.31,1518.10,452393.80,0.00,0.00,0.00,0.00,0.00),('8','213','1','90',618,'2','1',153812.19,155943.84,2131.65,635231.70,0.00,0.00,0.00,0.00,0.00),('8','213','2','90',619,'3','1',917520.55,917520.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','90',620,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','90',621,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','90',622,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','90',623,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','91',624,'1','1',888570.31,889910.57,1340.26,399397.48,0.00,0.00,0.00,0.00,0.00),('8','213','1','91',625,'2','1',155943.84,157120.22,1176.38,350561.24,0.00,0.00,0.00,0.00,0.00),('8','213','2','91',626,'3','1',917520.55,918163.21,642.66,191512.68,0.00,0.00,0.00,0.00,0.00),('8','213','2','91',627,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','91',628,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','91',629,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','91',630,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','92',631,'1','1',889910.57,892210.88,2300.31,685492.38,0.00,0.00,0.00,0.00,0.00),('8','213','1','92',632,'2','1',157120.22,157120.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','92',633,'3','1',918163.21,920613.31,2450.10,730129.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','92',634,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','92',635,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','92',636,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','92',637,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','93',638,'1','1',892210.88,894114.64,1903.76,567320.48,0.00,0.00,0.00,0.00,0.00),('8','213','1','93',639,'2','1',157120.22,157120.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','93',640,'3','1',920613.31,922747.99,2134.68,636134.64,0.00,0.00,0.00,0.00,0.00),('8','213','2','93',641,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','93',642,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','93',643,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','93',644,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','94',645,'1','1',894114.64,895971.36,1856.72,553302.56,0.00,0.00,0.00,0.00,0.00),('8','213','1','94',646,'2','1',157120.22,157120.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','94',647,'3','1',922747.99,925386.62,2638.63,786311.74,0.00,0.00,0.00,0.00,0.00),('8','213','2','94',648,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','94',649,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','94',650,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','94',651,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','95',652,'1','1',895971.36,896826.82,855.46,254927.08,0.00,0.00,0.00,0.00,0.00),('8','213','1','95',653,'2','1',157120.22,157675.52,555.30,165479.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','95',654,'3','1',925386.62,927720.35,2333.73,695451.54,0.00,0.00,0.00,0.00,0.00),('8','213','2','95',655,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','95',656,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','95',657,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','95',658,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','96',659,'1','1',896826.82,896826.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','96',660,'2','1',157675.52,159503.18,1827.66,544642.68,0.00,0.00,0.00,0.00,0.00),('8','213','2','96',661,'3','1',927720.35,929635.99,1915.64,570860.72,0.00,0.00,0.00,0.00,0.00),('8','213','2','96',662,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','96',663,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','96',664,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','96',665,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','97',666,'1','1',896826.82,896826.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','97',667,'2','1',159503.18,161999.07,2495.89,743775.22,0.00,0.00,0.00,0.00,0.00),('8','213','2','97',668,'3','1',929635.99,932631.40,2995.41,892632.18,0.00,0.00,0.00,0.00,0.00),('8','213','2','97',669,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','97',670,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','97',671,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','97',672,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','98',673,'1','1',896826.82,897429.83,603.01,179696.98,0.00,0.00,0.00,0.00,0.00),('8','213','1','98',674,'2','1',161999.07,164708.43,2709.36,807389.28,0.00,0.00,0.00,0.00,0.00),('8','213','2','98',675,'3','1',932631.40,934287.21,1655.81,493431.38,0.00,0.00,0.00,0.00,0.00),('8','213','2','98',676,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','98',677,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','98',678,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','98',679,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','99',680,'1','1',897429.83,900464.77,3034.94,904412.12,0.00,0.00,0.00,0.00,0.00),('8','213','1','99',681,'2','1',164708.43,168028.89,3320.46,989497.08,0.00,0.00,0.00,0.00,0.00),('8','213','2','99',682,'3','1',934287.21,934287.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','99',683,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','99',684,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','99',685,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','99',686,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','100',687,'1','1',900464.77,901560.69,1095.92,326584.16,0.00,0.00,0.00,0.00,0.00),('8','213','1','100',688,'2','1',168028.89,169389.70,1360.81,405521.38,0.00,0.00,0.00,0.00,0.00),('8','213','2','100',689,'3','1',934287.21,934287.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','100',690,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','100',691,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','100',692,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','100',693,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','101',694,'1','1',901560.69,903035.63,1474.94,439532.12,0.00,0.00,0.00,0.00,0.00),('8','213','1','101',695,'2','1',169389.70,169974.42,584.72,174246.56,0.00,0.00,0.00,0.00,0.00),('8','213','2','101',696,'3','1',934287.21,934287.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','101',697,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','101',698,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','101',699,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','101',700,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','102',701,'1','1',903035.63,905415.25,2379.62,820968.90,0.00,0.00,0.00,0.00,0.00),('8','213','1','102',702,'2','1',169974.42,170396.98,422.56,145783.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','102',703,'3','1',934287.21,937786.89,3499.68,1207389.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','102',704,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','102',705,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','102',706,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','102',707,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','103',708,'1','1',905415.25,906912.64,1497.39,516599.55,0.00,0.00,0.00,0.00,0.00),('8','213','1','103',709,'2','1',170396.98,170396.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','103',710,'3','1',937786.89,940050.83,2263.94,781059.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','103',711,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','103',712,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','103',713,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','103',714,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','104',715,'1','1',906912.64,908816.98,1904.34,656997.30,0.00,0.00,0.00,0.00,0.00),('8','213','1','104',716,'2','1',170396.98,170396.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','104',717,'3','1',940050.83,942454.84,2404.01,829383.45,0.00,0.00,0.00,0.00,0.00),('8','213','2','104',718,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','104',719,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','104',720,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','104',721,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','105',722,'1','1',908816.98,910071.29,1254.31,432736.95,0.00,0.00,0.00,0.00,0.00),('8','213','1','105',723,'2','1',170396.98,170396.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','105',724,'3','1',942454.84,945091.49,2636.65,909644.25,0.00,0.00,0.00,0.00,0.00),('8','213','2','105',725,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','105',726,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','105',727,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','105',728,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','106',729,'1','1',910071.29,912001.66,1930.37,665977.65,0.00,0.00,0.00,0.00,0.00),('8','213','1','106',730,'2','1',170396.98,170396.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','106',731,'3','1',945091.49,947767.98,2676.49,923389.05,0.00,0.00,0.00,0.00,0.00),('8','213','2','106',732,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','106',733,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','106',734,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','106',735,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','107',736,'1','1',912001.66,914514.38,2512.72,866888.40,0.00,0.00,0.00,0.00,0.00),('8','213','1','107',737,'2','1',170396.98,170396.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','107',738,'3','1',947767.98,951790.36,4022.38,1387721.10,0.00,0.00,0.00,0.00,0.00),('8','213','2','107',739,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','107',740,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','107',741,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','107',742,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','108',743,'1','1',914514.38,917371.48,2857.10,985699.50,0.00,0.00,0.00,0.00,0.00),('8','213','1','108',744,'2','1',170396.98,170396.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','108',745,'3','1',951790.36,956309.00,4518.64,1558930.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','108',746,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','108',747,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','108',748,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','108',749,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','109',750,'1','1',917371.48,919272.36,1900.88,655803.60,0.00,0.00,0.00,0.00,0.00),('8','213','1','109',751,'2','1',170396.98,170396.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','109',752,'3','1',956309.00,962128.54,5819.54,2007741.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','109',753,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','109',754,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','109',755,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','109',756,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','110',757,'1','1',919272.36,922411.53,3139.17,1083013.65,0.00,0.00,0.00,0.00,0.00),('8','213','1','110',758,'2','1',170396.98,170396.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','110',759,'3','1',962128.54,966745.40,4616.86,1592816.70,0.00,0.00,0.00,0.00,0.00),('8','213','2','110',760,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','110',761,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','110',762,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','110',763,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','111',764,'1','1',922411.53,924803.36,2391.83,825181.35,0.00,0.00,0.00,0.00,0.00),('8','213','1','111',765,'2','1',170396.98,171568.12,1171.14,404043.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','111',766,'3','1',966745.40,968354.80,1609.40,555243.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','111',767,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','111',768,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','111',769,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','111',770,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','112',771,'1','1',924803.36,927913.90,3110.54,1073136.30,0.00,0.00,0.00,0.00,0.00),('8','213','1','112',772,'2','1',171568.12,174888.46,3320.34,1145517.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','112',773,'3','1',968354.80,968354.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','112',774,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','112',775,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','112',776,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','112',777,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','113',778,'1','1',927913.90,928275.42,361.52,124724.40,0.00,0.00,0.00,0.00,0.00),('8','213','1','113',779,'2','1',174888.46,177627.52,2739.06,944975.70,0.00,0.00,0.00,0.00,0.00),('8','213','2','113',780,'3','1',968354.80,968354.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','113',781,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','113',782,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','113',783,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','113',784,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','114',785,'1','1',928275.42,929421.29,1145.87,389595.80,0.00,0.00,0.00,0.00,0.00),('8','213','1','114',786,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','114',787,'3','1',968354.80,970597.54,2242.74,762531.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','114',788,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','114',789,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','114',790,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','114',791,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','115',792,'1','1',929421.29,930720.83,1299.54,441843.60,0.00,0.00,0.00,0.00,0.00),('8','213','1','115',793,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','115',794,'3','1',970597.54,972618.73,2021.19,687204.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','115',795,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','115',796,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','115',797,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','115',798,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','116',799,'1','1',930720.83,931951.58,1230.75,418455.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','116',800,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','116',801,'3','1',972618.73,975098.46,2479.73,843109.64,0.00,0.00,0.00,0.00,0.00),('8','213','2','116',802,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','116',803,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','116',804,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','116',805,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','117',806,'1','1',931951.58,932983.58,1032.00,350880.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','117',807,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','117',808,'3','1',975098.46,978063.86,2965.40,1008236.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','117',809,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','117',810,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','117',811,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','117',812,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','118',813,'1','1',932983.58,934145.62,1162.04,395093.60,0.00,0.00,0.00,0.00,0.00),('8','213','1','118',814,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','118',815,'3','1',978063.86,979850.60,1786.74,607491.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','118',816,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','118',817,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','118',818,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','118',819,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','119',820,'1','1',934145.62,936373.66,2228.04,757533.60,0.00,0.00,0.00,0.00,0.00),('8','213','1','119',821,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','119',822,'3','1',979850.60,982018.31,2167.71,737021.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','119',823,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','119',824,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','119',825,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','119',826,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','120',827,'1','1',936373.66,937631.03,1257.37,427505.80,0.00,0.00,0.00,0.00,0.00),('8','213','1','120',828,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','120',829,'3','1',982018.31,984733.58,2715.27,923191.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','120',830,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','120',831,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','120',832,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','120',833,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','121',834,'1','1',937631.03,939638.69,2007.66,642451.20,0.00,0.00,0.00,0.00,0.00),('8','213','1','121',835,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','121',836,'3','1',984733.58,988647.69,3914.11,1252515.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','121',837,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','121',838,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','121',839,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','121',840,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','122',841,'1','1',939638.69,941805.40,2166.71,693347.20,0.00,0.00,0.00,0.00,0.00),('8','213','1','122',842,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','122',843,'3','1',988647.69,993765.82,5118.13,1637801.60,0.00,0.00,0.00,0.00,0.00),('8','213','2','122',844,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','122',845,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','122',846,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','122',847,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','123',848,'1','1',941805.40,943596.38,1790.98,573113.60,0.00,0.00,0.00,0.00,0.00),('8','213','1','123',849,'2','1',177627.52,177627.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','123',850,'3','1',993765.82,997413.87,3648.05,1167376.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','123',851,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','123',852,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','123',853,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','123',854,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','124',855,'1','1',943596.38,945558.73,1962.35,627952.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','124',856,'2','1',177627.52,179262.56,1635.04,523212.80,0.00,0.00,0.00,0.00,0.00),('8','213','2','124',857,'3','1',997413.87,998269.34,855.47,273750.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','124',858,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','124',859,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','124',860,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','124',861,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','125',862,'1','1',945558.73,945558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','125',863,'2','1',179262.56,179262.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','125',864,'3','1',998269.34,998269.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','125',865,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','125',866,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','125',867,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','125',868,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','126',869,'1','1',948486.71,951623.08,3136.37,925229.15,0.00,0.00,0.00,0.00,0.00),('8','213','1','126',870,'2','1',179262.56,179262.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','126',871,'3','1',2153.29,6242.49,4089.20,1206314.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','126',872,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','126',873,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','126',874,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','126',875,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','127',876,'1','1',951623.08,954408.50,2785.42,821698.90,0.00,0.00,0.00,0.00,0.00),('8','213','1','127',877,'2','1',179262.56,179262.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','127',878,'3','1',6242.49,10896.43,4653.94,1372912.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','127',879,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','127',880,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','127',881,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','127',882,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','128',883,'1','1',954408.50,956695.27,2286.77,674597.15,0.00,0.00,0.00,0.00,0.00),('8','213','1','128',884,'2','1',179262.56,179994.68,732.12,215975.40,0.00,0.00,0.00,0.00,0.00),('8','213','2','128',885,'3','1',10896.43,14512.40,3615.97,1066711.15,0.00,0.00,0.00,0.00,0.00),('8','213','2','128',886,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','128',887,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','128',888,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','128',889,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','129',890,'1','1',956695.27,958870.00,2174.73,641545.35,0.00,0.00,0.00,0.00,0.00),('8','213','1','129',891,'2','1',179994.68,183068.24,3073.56,906700.20,0.00,0.00,0.00,0.00,0.00),('8','213','2','129',892,'3','1',14512.40,14512.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','129',893,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','129',894,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','129',895,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','129',896,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','130',897,'1','1',958870.00,963725.75,4855.75,1432446.25,0.00,0.00,0.00,0.00,0.00),('8','213','1','130',898,'2','1',183068.24,186208.25,3140.01,926302.95,0.00,0.00,0.00,0.00,0.00),('8','213','2','130',899,'3','1',14512.40,14512.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','130',900,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','130',901,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','130',902,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','130',903,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','1','131',904,'1','1',963725.75,965040.70,1314.95,387910.25,0.00,0.00,0.00,0.00,0.00),('8','213','1','131',905,'2','1',186208.25,188380.79,2172.54,640899.30,0.00,0.00,0.00,0.00,0.00),('8','213','2','131',906,'3','1',14512.40,14512.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','2','131',907,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','131',908,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','3','131',909,'6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','213','4','131',910,'7','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=393 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('8','213','1','1',215.00,215.00,0.00,0.00,0.00,0.00,0.00,1),('8','213','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,2),('8','213','1','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('8','213','2','1',215.00,215.00,0.00,0.00,0.00,0.00,0.00,4),('8','213','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,5),('8','213','2','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,6),('8','213','3','1',215.00,0.00,4020.88,0.00,0.00,0.00,0.00,7),('8','213','3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,8),('8','213','3','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,9),('8','213','5','1',215.00,215.00,3619.38,0.00,0.00,0.00,0.00,12),('8','213','5','2',0.00,780.00,0.00,0.00,0.00,0.00,0.00,13),('8','213','5','3',0.00,250.00,0.00,0.00,0.00,0.00,0.00,14),('8','213','6','1',215.00,215.00,3706.33,0.00,0.00,0.00,0.00,15),('8','213','6','2',0.00,750.00,0.00,0.00,0.00,0.00,0.00,16),('8','213','6','3',0.00,250.00,0.00,0.00,0.00,0.00,0.00,17),('8','213','7','1',215.00,210.00,2705.39,0.00,0.00,0.00,0.00,18),('8','213','7','2',0.00,750.00,0.00,0.00,0.00,0.00,0.00,19),('8','213','7','3',0.00,250.00,0.00,0.00,0.00,0.00,0.00,20),('8','213','8','1',215.00,210.00,2484.79,0.00,0.00,0.00,0.00,21),('8','213','8','2',0.00,750.00,0.00,0.00,0.00,0.00,0.00,22),('8','213','8','3',0.00,250.00,0.00,0.00,0.00,0.00,0.00,23),('8','213','9','1',215.00,210.00,2290.01,0.00,0.00,0.00,0.00,24),('8','213','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,25),('8','213','9','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,26),('8','213','10','2',0.00,750.00,0.00,0.00,0.00,0.00,0.00,27),('8','213','10','3',0.00,250.00,0.00,0.00,0.00,0.00,0.00,28),('8','213','10','1',215.00,207.00,3767.31,0.00,0.00,0.00,0.00,29),('8','213','11','1',215.00,207.00,5531.26,0.00,0.00,0.00,0.00,30),('8','213','11','2',0.00,750.00,0.00,0.00,0.00,0.00,0.00,31),('8','213','11','3',0.00,250.00,0.00,0.00,0.00,0.00,0.00,32),('8','213','12','1',215.00,207.00,0.00,0.00,0.00,0.00,0.00,33),('8','213','12','2',0.00,750.00,0.00,0.00,0.00,0.00,0.00,34),('8','213','12','3',0.00,250.00,0.00,0.00,0.00,0.00,0.00,35),('8','213','13','2',0.00,207.00,0.00,0.00,0.00,0.00,0.00,36),('8','213','13','3',0.00,750.00,0.00,0.00,0.00,0.00,0.00,37),('8','213','13','1',215.00,250.00,0.00,0.00,0.00,0.00,0.00,38),('8','213','14','1',200.00,0.00,2445.71,0.00,0.00,0.00,0.00,39),('8','213','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,40),('8','213','14','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,41),('8','213','15','1',200.00,200.00,3598.18,0.00,0.00,0.00,0.00,42),('8','213','15','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,43),('8','213','15','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,44),('8','213','16','1',200.00,200.00,2475.57,0.00,0.00,0.00,0.00,45),('8','213','16','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,46),('8','213','16','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,47),('8','213','17','1',200.00,200.00,2903.37,0.00,0.00,0.00,0.00,48),('8','213','17','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,49),('8','213','17','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,50),('8','213','18','1',200.00,200.00,3238.83,0.00,0.00,0.00,0.00,51),('8','213','18','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,52),('8','213','18','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('8','213','19','1',200.00,195.00,7610.81,0.00,0.00,0.00,0.00,54),('8','213','19','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,55),('8','213','19','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,56),('8','213','20','1',200.00,195.00,4104.99,0.00,0.00,0.00,0.00,57),('8','213','20','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,58),('8','213','20','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,59),('8','213','21','1',200.00,195.00,3886.46,0.00,0.00,0.00,0.00,60),('8','213','21','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,61),('8','213','21','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,62),('8','213','22','1',200.00,195.00,3896.60,0.00,0.00,0.00,0.00,63),('8','213','22','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,64),('8','213','22','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,65),('8','213','23','1',200.00,195.00,3400.29,0.00,0.00,0.00,0.00,66),('8','213','23','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,67),('8','213','23','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,68),('8','213','24','1',200.00,195.00,3539.44,0.00,0.00,0.00,0.00,69),('8','213','24','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,70),('8','213','24','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,71),('8','213','25','1',200.00,195.00,3985.10,0.00,0.00,0.00,0.00,72),('8','213','25','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,73),('8','213','25','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,74),('8','213','26','1',200.00,195.00,0.00,0.00,0.00,0.00,0.00,75),('8','213','26','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,76),('8','213','26','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,77),('8','213','27','1',195.00,195.00,6221.92,0.00,0.00,0.00,0.00,78),('8','213','27','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,79),('8','213','27','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,80),('8','213','28','1',195.00,195.00,4666.52,0.00,0.00,0.00,0.00,81),('8','213','28','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,82),('8','213','28','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,83),('8','213','29','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,84),('8','213','29','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,85),('8','213','29','1',195.00,195.00,4256.23,0.00,0.00,0.00,0.00,86),('8','213','30','1',195.00,195.00,3828.13,0.00,0.00,0.00,0.00,87),('8','213','30','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,88),('8','213','30','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,89),('8','213','31','1',195.00,195.00,4391.56,0.00,0.00,0.00,0.00,90),('8','213','31','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,91),('8','213','31','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,92),('8','213','32','1',195.00,195.00,4822.00,0.00,0.00,0.00,0.00,93),('8','213','32','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,94),('8','213','32','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,95),('8','213','33','1',195.00,195.00,5085.38,0.00,0.00,0.00,0.00,96),('8','213','33','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,97),('8','213','33','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,98),('8','213','34','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,99),('8','213','34','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,100),('8','213','34','1',195.00,195.00,5876.11,0.00,0.00,0.00,0.00,101),('8','213','35','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,102),('8','213','35','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,103),('8','213','35','1',195.00,195.00,5409.42,0.00,0.00,0.00,0.00,104),('8','213','36','1',195.00,195.00,3895.89,0.00,0.00,0.00,0.00,105),('8','213','36','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,106),('8','213','36','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,107),('8','213','37','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,108),('8','213','37','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,109),('8','213','37','1',195.00,195.00,3964.04,0.00,0.00,0.00,0.00,110),('8','213','38','1',195.00,195.00,4515.85,0.00,0.00,0.00,0.00,111),('8','213','38','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,112),('8','213','38','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,113),('8','213','39','1',190.00,195.00,6493.25,0.00,0.00,0.00,0.00,114),('8','213','39','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,115),('8','213','39','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,116),('8','213','40','1',190.00,190.00,5014.32,0.00,0.00,0.00,0.00,117),('8','213','40','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,118),('8','213','40','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,119),('8','213','41','1',195.00,190.00,5205.48,0.00,0.00,0.00,0.00,120),('8','213','41','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,121),('8','213','41','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,122),('8','213','42','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,123),('8','213','42','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,124),('8','213','42','1',195.00,190.00,5024.06,0.00,0.00,0.00,0.00,125),('8','213','43','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,126),('8','213','43','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,127),('8','213','43','1',195.00,190.00,4616.92,0.00,0.00,0.00,0.00,128),('8','213','44','1',195.00,190.00,4756.34,0.00,0.00,0.00,0.00,129),('8','213','44','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,130),('8','213','44','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,131),('8','213','45','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,132),('8','213','45','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,133),('8','213','45','1',195.00,190.00,6263.88,0.00,0.00,0.00,0.00,134),('8','213','46','1',195.00,190.00,6787.24,0.00,0.00,0.00,0.00,135),('8','213','46','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,136),('8','213','46','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,137),('8','213','47','1',195.00,190.00,4216.38,0.00,0.00,0.00,0.00,138),('8','213','47','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,139),('8','213','47','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,140),('8','213','48','1',190.00,190.00,5942.02,0.00,0.00,0.00,0.00,141),('8','213','48','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,142),('8','213','48','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,143),('8','213','49','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,144),('8','213','49','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,145),('8','213','49','1',190.00,190.00,5509.55,0.00,0.00,0.00,0.00,146),('8','213','50','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,147),('8','213','50','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,148),('8','213','50','1',190.00,190.00,7106.11,0.00,0.00,0.00,0.00,149),('8','213','51','1',190.00,190.00,8511.53,0.00,0.00,0.00,0.00,150),('8','213','51','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,151),('8','213','51','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,152),('8','213','52','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,153),('8','213','52','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,154),('8','213','52','1',190.00,190.00,5446.94,0.00,0.00,0.00,0.00,155),('8','213','53','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,156),('8','213','53','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,157),('8','213','53','1',190.00,190.00,3389.14,0.00,0.00,0.00,0.00,158),('8','213','54','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,159),('8','213','54','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,160),('8','213','54','1',190.00,190.00,6190.63,0.00,0.00,0.00,0.00,161),('8','213','55','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,162),('8','213','55','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,163),('8','213','55','1',190.00,190.00,5002.25,0.00,0.00,0.00,0.00,164),('8','213','56','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,165),('8','213','56','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,166),('8','213','56','1',190.00,190.00,3082.05,0.00,0.00,0.00,0.00,167),('8','213','57','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,168),('8','213','57','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,169),('8','213','57','1',203.00,203.00,13707.08,0.00,0.00,0.00,0.00,170),('8','213','58','1',203.00,207.00,15021.45,0.00,0.00,0.00,0.00,171),('8','213','58','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,172),('8','213','58','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,173),('8','213','59','1',220.00,220.00,11798.46,0.00,0.00,0.00,0.00,174),('8','213','59','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,175),('8','213','59','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,176),('8','213','60','1',220.00,220.00,10125.86,0.00,0.00,0.00,0.00,177),('8','213','60','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,178),('8','213','60','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,179),('8','213','61','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,180),('8','213','61','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,181),('8','213','61','1',253.00,253.00,8476.65,0.00,0.00,0.00,0.00,182),('8','213','62','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,183),('8','213','62','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,184),('8','213','62','1',253.00,253.00,7378.70,0.00,0.00,0.00,0.00,185),('8','213','63','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,186),('8','213','63','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,187),('8','213','63','1',253.00,253.00,6565.29,0.00,0.00,0.00,0.00,188),('8','213','64','1',253.00,253.00,5977.01,0.00,0.00,0.00,0.00,189),('8','213','64','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,190),('8','213','64','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,191),('8','213','65','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,192),('8','213','65','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,193),('8','213','65','1',253.00,253.00,4914.85,0.00,0.00,0.00,0.00,194),('8','213','66','1',255.00,255.00,5855.02,0.00,0.00,0.00,0.00,195),('8','213','66','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,196),('8','213','66','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,197),('8','213','67','1',255.00,255.00,7189.78,0.00,0.00,0.00,0.00,198),('8','213','67','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,199),('8','213','67','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,200),('8','213','68','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,201),('8','213','68','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,202),('8','213','68','1',255.00,255.00,3682.58,0.00,0.00,0.00,0.00,203),('8','213','69','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,204),('8','213','69','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,205),('8','213','69','1',260.00,260.00,5917.48,0.00,0.00,0.00,0.00,206),('8','213','70','1',260.00,260.00,4477.22,0.00,0.00,0.00,0.00,207),('8','213','70','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,208),('8','213','70','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,209),('8','213','71','1',260.00,260.00,4168.55,0.00,0.00,0.00,0.00,210),('8','213','71','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,211),('8','213','71','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,212),('8','213','72','1',260.00,260.00,4478.31,0.00,0.00,0.00,0.00,213),('8','213','72','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,214),('8','213','72','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215),('8','213','73','1',260.00,260.00,4156.22,0.00,0.00,0.00,0.00,216),('8','213','73','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,217),('8','213','73','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,218),('8','213','74','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,219),('8','213','74','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,220),('8','213','74','1',260.00,260.00,4910.24,0.00,0.00,0.00,0.00,221),('8','213','75','1',260.00,260.00,9134.18,0.00,0.00,0.00,0.00,222),('8','213','75','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,223),('8','213','75','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,224),('8','213','76','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,225),('8','213','76','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226),('8','213','76','1',260.00,260.00,6578.38,0.00,0.00,0.00,0.00,227),('8','213','77','1',260.00,260.00,4996.27,0.00,0.00,0.00,0.00,228),('8','213','77','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,229),('8','213','77','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,230),('8','213','78','1',312.00,312.00,3463.35,0.00,0.00,0.00,0.00,231),('8','213','78','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,232),('8','213','78','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233),('8','213','79','1',312.00,312.00,3488.84,0.00,0.00,0.00,0.00,234),('8','213','79','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,235),('8','213','79','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236),('8','213','80','1',312.00,312.00,3660.13,0.00,0.00,0.00,0.00,237),('8','213','80','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,238),('8','213','80','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,239),('8','213','81','1',312.00,312.00,4399.86,0.00,0.00,0.00,0.00,240),('8','213','81','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,241),('8','213','81','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,242),('8','213','82','1',312.00,312.00,5526.33,0.00,0.00,0.00,0.00,243),('8','213','82','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,244),('8','213','82','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,245),('8','213','83','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,246),('8','213','83','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,247),('8','213','83','1',312.00,312.00,3385.39,0.00,0.00,0.00,0.00,248),('8','213','84','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,249),('8','213','84','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250),('8','213','84','1',312.00,312.00,3119.79,0.00,0.00,0.00,0.00,251),('8','213','85','1',312.00,312.00,3580.82,0.00,0.00,0.00,0.00,252),('8','213','85','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,253),('8','213','85','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,254),('8','213','86','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,255),('8','213','86','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,256),('8','213','86','1',300.00,300.00,2462.87,0.00,0.00,0.00,0.00,257),('8','213','87','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,258),('8','213','87','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,259),('8','213','87','1',300.00,300.00,3122.17,0.00,0.00,0.00,0.00,260),('8','213','88','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,261),('8','213','88','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,262),('8','213','88','1',300.00,300.00,4119.27,0.00,0.00,0.00,0.00,263),('8','213','89','1',300.00,300.00,4700.52,0.00,0.00,0.00,0.00,264),('8','213','89','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,265),('8','213','89','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,266),('8','213','90','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,267),('8','213','90','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,268),('8','213','90','1',298.00,298.00,3649.75,0.00,0.00,0.00,0.00,269),('8','213','91','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,270),('8','213','91','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271),('8','213','91','1',298.00,298.00,3159.30,0.00,0.00,0.00,0.00,272),('8','213','92','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,273),('8','213','92','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274),('8','213','92','1',298.00,298.00,4750.41,0.00,0.00,0.00,0.00,275),('8','213','93','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,276),('8','213','93','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277),('8','213','93','1',298.00,298.00,4038.44,0.00,0.00,0.00,0.00,278),('8','213','94','1',298.00,298.00,4495.35,0.00,0.00,0.00,0.00,279),('8','213','94','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,280),('8','213','94','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281),('8','213','95','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,282),('8','213','95','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,283),('8','213','95','1',298.00,298.00,3744.49,0.00,0.00,0.00,0.00,284),('8','213','96','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,285),('8','213','96','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,286),('8','213','96','1',298.00,298.00,3743.30,0.00,0.00,0.00,0.00,287),('8','213','97','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,288),('8','213','97','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289),('8','213','97','1',298.00,298.00,5491.30,0.00,0.00,0.00,0.00,290),('8','213','98','1',298.00,298.00,4968.18,0.00,0.00,0.00,0.00,291),('8','213','98','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,292),('8','213','98','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,293),('8','213','99','1',298.00,298.00,6355.40,0.00,0.00,0.00,0.00,294),('8','213','99','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,295),('8','213','99','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,296),('8','213','100','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,297),('8','213','100','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,298),('8','213','100','1',298.00,298.00,2456.73,0.00,0.00,0.00,0.00,299),('8','213','101','1',298.00,298.00,2059.66,0.00,0.00,0.00,0.00,300),('8','213','101','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,301),('8','213','101','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,302),('8','213','102','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,303),('8','213','102','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,304),('8','213','102','1',345.00,345.00,6301.86,0.00,0.00,0.00,0.00,305),('8','213','103','1',345.00,345.00,3761.33,0.00,0.00,0.00,0.00,306),('8','213','103','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,307),('8','213','103','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,308),('8','213','104','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,309),('8','213','104','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,310),('8','213','104','1',345.00,345.00,4308.35,0.00,0.00,0.00,0.00,311),('8','213','105','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,312),('8','213','105','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,313),('8','213','105','1',345.00,345.00,3890.96,0.00,0.00,0.00,0.00,314),('8','213','106','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,315),('8','213','106','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,316),('8','213','106','1',345.00,345.00,4606.86,0.00,0.00,0.00,0.00,317),('8','213','107','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,318),('8','213','107','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,319),('8','213','107','1',345.00,345.00,6535.10,0.00,0.00,0.00,0.00,320),('8','213','108','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,321),('8','213','108','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,322),('8','213','108','1',345.00,345.00,7375.74,0.00,0.00,0.00,0.00,323),('8','213','109','1',345.00,345.00,7720.42,0.00,0.00,0.00,0.00,324),('8','213','109','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,325),('8','213','109','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,326),('8','213','110','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,327),('8','213','110','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,328),('8','213','110','1',345.00,345.00,7756.03,0.00,0.00,0.00,0.00,329),('8','213','111','1',345.00,345.00,5172.37,0.00,0.00,0.00,0.00,330),('8','213','111','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,331),('8','213','111','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,332),('8','213','112','1',345.00,345.00,6430.88,0.00,0.00,0.00,0.00,333),('8','213','112','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,334),('8','213','112','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,335),('8','213','113','1',345.00,345.00,3100.58,0.00,0.00,0.00,0.00,336),('8','213','113','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,337),('8','213','113','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,338),('8','213','114','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,339),('8','213','114','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,340),('8','213','114','1',340.00,340.00,3388.61,0.00,0.00,0.00,0.00,341),('8','213','115','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,342),('8','213','115','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,343),('8','213','115','1',340.00,340.00,3320.73,0.00,0.00,0.00,0.00,344),('8','213','116','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,345),('8','213','116','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,346),('8','213','116','1',340.00,340.00,3710.48,0.00,0.00,0.00,0.00,347),('8','213','117','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,348),('8','213','117','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,349),('8','213','117','1',340.00,340.00,3997.40,0.00,0.00,0.00,0.00,350),('8','213','118','1',340.00,340.00,2948.78,0.00,0.00,0.00,0.00,351),('8','213','118','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,352),('8','213','118','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,353),('8','213','119','1',340.00,340.00,4395.75,0.00,0.00,0.00,0.00,354),('8','213','119','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,355),('8','213','119','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,356),('8','213','120','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,357),('8','213','120','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,358),('8','213','120','1',340.00,340.00,3972.64,0.00,0.00,0.00,0.00,359),('8','213','121','1',320.00,320.00,5921.77,0.00,0.00,0.00,0.00,360),('8','213','121','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,361),('8','213','121','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,362),('8','213','122','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,363),('8','213','122','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,364),('8','213','122','1',320.00,320.00,7284.84,0.00,0.00,0.00,0.00,365),('8','213','123','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,366),('8','213','123','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,367),('8','213','123','1',320.00,320.00,5439.03,0.00,0.00,0.00,0.00,368),('8','213','124','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,369),('8','213','124','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,370),('8','213','124','1',320.00,320.00,4452.86,0.00,0.00,0.00,0.00,371),('8','213','125','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,372),('8','213','125','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,373),('8','213','125','1',295.00,295.00,0.00,0.00,0.00,0.00,0.00,374),('8','213','126','1',295.00,295.00,7225.57,0.00,0.00,0.00,0.00,375),('8','213','126','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,376),('8','213','126','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,377),('8','213','127','1',295.00,295.00,7439.36,0.00,0.00,0.00,0.00,378),('8','213','127','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,379),('8','213','127','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,380),('8','213','128','1',295.00,295.00,6634.86,0.00,0.00,0.00,0.00,381),('8','213','128','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,382),('8','213','128','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,383),('8','213','129','1',295.00,295.00,5248.29,0.00,0.00,0.00,0.00,384),('8','213','129','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,385),('8','213','129','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,386),('8','213','130','1',295.00,295.00,7995.76,0.00,0.00,0.00,0.00,387),('8','213','130','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,388),('8','213','130','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,389),('8','213','131','2',800.00,800.00,0.00,0.00,0.00,0.00,0.00,390),('8','213','131','3',0.00,0.00,0.00,0.00,0.00,0.00,0.00,391),('8','213','131','1',295.00,295.00,3487.49,0.00,0.00,0.00,0.00,392);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('8',1,'213','PRODUCT TANK','Tanks Containing Petroleum Products.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('8','213','1',1,0,'1','PMS TANK 1',40000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','926','2022-08-06 09:48:05','2022-08-22 19:18:45','467',5,0),('8','213','1',2,0,'1','PMS TANK 2',40000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','926','2022-08-06 09:49:37','2022-08-22 19:17:23','467',5,0),('8','213','1',3,0,'2','AGO TANK ',33000.00,0.00,NULL,'TANK CONTAINING DIESEL.','926','2022-08-06 09:50:59','2022-08-06 09:50:59','926',5,0),('8','213','1',4,0,'3','DPK TANK ',33000.00,0.00,NULL,'DPK DISPENSER.','926','2022-08-06 09:54:10','2022-08-06 09:54:10','926',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'8','213',4,0.00,'2023-03-20 21:05:27'),(2,'8','213',3,0.00,'2023-03-20 21:05:27'),(3,'8','213',2,3952.57,'2023-03-20 21:05:27'),(4,'8','213',1,3419.66,'2023-03-20 21:05:27');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=458 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,6622000.00,30800.00,0.00,0.00,'2022-08-10 18:37:14','',''),(2,'8','213',NULL,1,'Reception corrector for bridging 2',0.00,0.00,0.00,8600.00,0.00,'2022-08-10 22:09:05','',''),(3,'8','213','2',1,'Received from bridging 2',0.00,0.00,8600.00,0.00,0.00,'2022-08-10 22:09:05','',''),(4,'8','213',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,22200.00,0.00,'2022-08-10 22:09:05','',''),(5,'8','213','1',1,'Received from bridging 1',0.00,0.00,22200.00,0.00,0.00,'2022-08-10 22:09:05','',''),(6,'8','213','1',1,'Sale Id shift 3',0.00,0.00,0.00,1737.67,0.00,'2022-08-13 11:30:06','',''),(7,'8','213','2',1,'Sale Id shift 3',0.00,0.00,0.00,2283.21,0.00,'2022-08-13 11:30:06','',''),(8,'8','213',NULL,1,'Sale Id shift 3',864489.20,0.00,0.00,0.00,0.00,'2022-08-13 11:30:06','',''),(9,'8','213','1',1,'Sale Id shift 5',0.00,0.00,0.00,1668.46,0.00,'2022-08-14 10:09:49','',''),(10,'8','213','2',1,'Sale Id shift 5',0.00,0.00,0.00,1950.92,0.00,'2022-08-14 10:09:49','',''),(11,'8','213',NULL,1,'Sale Id shift 5',778166.70,0.00,0.00,0.00,0.00,'2022-08-14 10:09:49','',''),(12,'8','213','1',1,'Sale Id shift 6',0.00,0.00,0.00,1184.95,0.00,'2022-08-14 10:41:16','',''),(13,'8','213','2',1,'Sale Id shift 6',0.00,0.00,0.00,2521.38,0.00,'2022-08-14 10:41:16','',''),(14,'8','213',NULL,1,'Sale Id shift 6',796860.95,0.00,0.00,0.00,0.00,'2022-08-14 10:41:16','',''),(15,'8','213','1',1,'Sale Id shift 7',0.00,0.00,0.00,1227.93,0.00,'2022-08-14 10:45:29','',''),(16,'8','213','2',1,'Sale Id shift 7',0.00,0.00,0.00,1477.46,0.00,'2022-08-14 10:45:29','',''),(17,'8','213',NULL,1,'Sale Id shift 7',581658.85,0.00,0.00,0.00,0.00,'2022-08-14 10:45:29','',''),(18,'8','213','1',1,'Sale Id shift 8',0.00,0.00,0.00,1353.64,0.00,'2022-08-15 13:58:01','',''),(19,'8','213','1',1,'Sale Id shift 8',0.00,0.00,0.00,1020.22,0.00,'2022-08-15 13:58:01','',''),(20,'8','213','2',1,'Sale Id shift 8',0.00,0.00,0.00,110.93,0.00,'2022-08-15 13:58:01','',''),(21,'8','213',NULL,1,'Sale Id shift 8',534229.85,0.00,0.00,0.00,0.00,'2022-08-15 13:58:01','',''),(22,'8','213','1',1,'Sale Id shift 9',0.00,0.00,0.00,973.03,0.00,'2022-08-16 10:44:33','',''),(23,'8','213','1',1,'Sale Id shift 9',0.00,0.00,0.00,1316.98,0.00,'2022-08-16 10:44:33','',''),(24,'8','213',NULL,1,'Sale Id shift 9',492352.15,0.00,0.00,0.00,0.00,'2022-08-16 10:44:33','',''),(25,'8','213','1',1,'Sale Id shift 10',0.00,0.00,0.00,1953.53,0.00,'2022-08-20 21:48:02','',''),(26,'8','213','1',1,'Sale Id shift 10',0.00,0.00,0.00,1813.78,0.00,'2022-08-20 21:48:02','',''),(27,'8','213',NULL,1,'Sale Id shift 10',809971.65,0.00,0.00,0.00,0.00,'2022-08-20 21:48:02','',''),(28,'8','213','1',1,'Sale Id shift 11',0.00,0.00,0.00,2754.94,0.00,'2022-08-21 09:19:36','',''),(29,'8','213','1',1,'Sale Id shift 11',0.00,0.00,0.00,2776.32,0.00,'2022-08-21 09:19:36','',''),(30,'8','213',NULL,1,'Sale Id shift 11',1189220.90,0.00,0.00,0.00,0.00,'2022-08-21 09:19:36','',''),(31,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,9940000.00,49700.00,0.00,0.00,'2022-08-22 12:38:41','',''),(32,'8','213',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,16700.00,0.00,'2022-08-22 13:30:35','',''),(33,'8','213','2',1,'Received from bridging 4',0.00,0.00,16700.00,0.00,0.00,'2022-08-22 13:30:35','',''),(34,'8','213',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,33000.00,0.00,'2022-08-22 19:21:11','',''),(35,'8','213','1',1,'Received from bridging 3',0.00,0.00,33000.00,0.00,0.00,'2022-08-22 19:21:11','',''),(36,'8','213','1',1,'Sale Id shift 14',0.00,0.00,0.00,1031.15,0.00,'2022-08-24 15:51:27','',''),(37,'8','213','1',1,'Sale Id shift 14',0.00,0.00,0.00,1414.56,0.00,'2022-08-24 15:51:27','',''),(38,'8','213',NULL,1,'Sale Id shift 14',489142.00,0.00,0.00,0.00,0.00,'2022-08-24 15:51:27','',''),(39,'8','213','1',1,'Sale Id shift 15',0.00,0.00,0.00,1799.96,0.00,'2022-08-24 16:31:38','',''),(40,'8','213','1',1,'Sale Id shift 15',0.00,0.00,0.00,1798.22,0.00,'2022-08-24 16:31:38','',''),(41,'8','213',NULL,1,'Sale Id shift 15',719636.00,0.00,0.00,0.00,0.00,'2022-08-24 16:31:38','',''),(42,'8','213','1',1,'Sale Id shift 16',0.00,0.00,0.00,1143.13,0.00,'2022-08-24 16:50:57','',''),(43,'8','213','1',1,'Sale Id shift 16',0.00,0.00,0.00,1332.44,0.00,'2022-08-24 16:50:57','',''),(44,'8','213',NULL,1,'Sale Id shift 16',495114.00,0.00,0.00,0.00,0.00,'2022-08-24 16:50:57','',''),(45,'8','213','1',1,'Sale Id shift 17',0.00,0.00,0.00,1180.73,0.00,'2022-08-24 17:00:25','',''),(46,'8','213','1',1,'Sale Id shift 17',0.00,0.00,0.00,1722.64,0.00,'2022-08-24 17:00:25','',''),(47,'8','213',NULL,1,'Sale Id shift 17',580674.00,0.00,0.00,0.00,0.00,'2022-08-24 17:00:25','',''),(48,'8','213','1',1,'Sale Id shift 18',0.00,0.00,0.00,1570.60,0.00,'2022-08-24 17:08:12','',''),(49,'8','213','1',1,'Sale Id shift 18',0.00,0.00,0.00,916.24,0.00,'2022-08-24 17:08:12','',''),(50,'8','213','2',1,'Sale Id shift 18',0.00,0.00,0.00,751.99,0.00,'2022-08-24 17:08:12','',''),(51,'8','213',NULL,1,'Sale Id shift 18',647766.00,0.00,0.00,0.00,0.00,'2022-08-24 17:08:12','',''),(52,'8','213','1',1,'Sale Id shift 19',0.00,0.00,0.00,3482.05,0.00,'2022-08-25 14:49:29','',''),(53,'8','213','1',1,'Sale Id shift 19',0.00,0.00,0.00,1001.21,0.00,'2022-08-25 14:49:29','',''),(54,'8','213','2',1,'Sale Id shift 19',0.00,0.00,0.00,3127.55,0.00,'2022-08-25 14:49:29','',''),(55,'8','213',NULL,1,'Sale Id shift 19',1522162.00,0.00,0.00,0.00,0.00,'2022-08-25 14:49:29','',''),(56,'8','213','1',1,'Sale Id shift 20',0.00,0.00,0.00,2204.87,0.00,'2022-08-25 23:18:48','',''),(57,'8','213','2',1,'Sale Id shift 20',0.00,0.00,0.00,1900.12,0.00,'2022-08-25 23:18:48','',''),(58,'8','213',NULL,1,'Sale Id shift 20',820998.00,0.00,0.00,0.00,0.00,'2022-08-25 23:18:48','',''),(59,'8','213','1',1,'Sale Id shift 21',0.00,0.00,0.00,1672.22,0.00,'2022-08-27 07:39:32','',''),(60,'8','213','2',1,'Sale Id shift 21',0.00,0.00,0.00,2214.24,0.00,'2022-08-27 07:39:32','',''),(61,'8','213',NULL,1,'Sale Id shift 21',777292.00,0.00,0.00,0.00,0.00,'2022-08-27 07:39:32','',''),(62,'8','213','1',1,'Sale Id shift 22',0.00,0.00,0.00,1792.89,0.00,'2022-08-28 09:11:11','',''),(63,'8','213','2',1,'Sale Id shift 22',0.00,0.00,0.00,2103.71,0.00,'2022-08-28 09:11:11','',''),(64,'8','213',NULL,1,'Sale Id shift 22',779320.00,0.00,0.00,0.00,0.00,'2022-08-28 09:11:11','',''),(65,'8','213','1',1,'Sale Id shift 23',0.00,0.00,0.00,1582.84,0.00,'2022-08-29 07:41:29','',''),(66,'8','213','2',1,'Sale Id shift 23',0.00,0.00,0.00,1817.45,0.00,'2022-08-29 07:41:29','',''),(67,'8','213',NULL,1,'Sale Id shift 23',680058.00,0.00,0.00,0.00,0.00,'2022-08-29 07:41:29','',''),(68,'8','213','1',1,'Sale Id shift 24',0.00,0.00,0.00,1649.72,0.00,'2022-08-30 08:25:29','',''),(69,'8','213','2',1,'Sale Id shift 24',0.00,0.00,0.00,1889.72,0.00,'2022-08-30 08:25:29','',''),(70,'8','213',NULL,1,'Sale Id shift 24',707888.00,0.00,0.00,0.00,0.00,'2022-08-30 08:25:29','',''),(71,'8','213','1',1,'Sale Id shift 25',0.00,0.00,0.00,2055.58,0.00,'2022-08-30 21:22:13','',''),(72,'8','213','2',1,'Sale Id shift 25',0.00,0.00,0.00,1929.52,0.00,'2022-08-30 21:22:13','',''),(73,'8','213',NULL,1,'Sale Id shift 25',797020.00,0.00,0.00,0.00,0.00,'2022-08-30 21:22:13','',''),(74,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,9691500.00,49700.00,0.00,0.00,'2022-09-01 12:08:59','',''),(75,'8','213',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,32900.00,0.00,'2022-09-01 15:45:29','',''),(76,'8','213','1',1,'Received from bridging 7',0.00,0.00,32900.00,0.00,0.00,'2022-09-01 15:45:29','',''),(77,'8','213',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,16800.00,0.00,'2022-09-01 15:45:41','',''),(78,'8','213','2',1,'Received from bridging 8',0.00,0.00,16800.00,0.00,0.00,'2022-09-01 15:45:41','',''),(79,'8','213','1',1,'Sale Id shift 27',0.00,0.00,0.00,3242.42,0.00,'2022-09-01 17:52:32','',''),(80,'8','213','1',1,'Sale Id shift 27',0.00,0.00,0.00,2979.50,0.00,'2022-09-01 17:52:32','',''),(81,'8','213',NULL,1,'Sale Id shift 27',1213274.40,0.00,0.00,0.00,0.00,'2022-09-01 17:52:32','',''),(82,'8','213','1',1,'Sale Id shift 28',0.00,0.00,0.00,1566.23,0.00,'2022-09-01 20:51:34','',''),(83,'8','213','2',1,'Sale Id shift 28',0.00,0.00,0.00,3100.29,0.00,'2022-09-01 20:51:34','',''),(84,'8','213',NULL,1,'Sale Id shift 28',909971.40,0.00,0.00,0.00,0.00,'2022-09-01 20:51:34','',''),(85,'8','213','1',1,'Sale Id shift 29',0.00,0.00,0.00,1851.52,0.00,'2022-09-02 21:58:09','',''),(86,'8','213','1',1,'Sale Id shift 29',0.00,0.00,0.00,2404.71,0.00,'2022-09-02 21:58:09','',''),(87,'8','213',NULL,1,'Sale Id shift 29',829964.85,0.00,0.00,0.00,0.00,'2022-09-02 21:58:09','',''),(88,'8','213','1',1,'Sale Id shift 30',0.00,0.00,0.00,1862.67,0.00,'2022-09-03 19:25:54','',''),(89,'8','213','1',1,'Sale Id shift 30',0.00,0.00,0.00,1965.46,0.00,'2022-09-03 19:25:54','',''),(90,'8','213',NULL,1,'Sale Id shift 30',746485.35,0.00,0.00,0.00,0.00,'2022-09-03 19:25:54','',''),(91,'8','213','1',1,'Sale Id shift 31',0.00,0.00,0.00,1747.51,0.00,'2022-09-04 19:14:42','',''),(92,'8','213','1',1,'Sale Id shift 31',0.00,0.00,0.00,2644.05,0.00,'2022-09-04 19:14:42','',''),(93,'8','213',NULL,1,'Sale Id shift 31',856354.20,0.00,0.00,0.00,0.00,'2022-09-04 19:14:42','',''),(94,'8','213','1',1,'Sale Id shift 32',0.00,0.00,0.00,2685.14,0.00,'2022-09-05 22:34:24','',''),(95,'8','213','1',1,'Sale Id shift 32',0.00,0.00,0.00,1365.69,0.00,'2022-09-05 22:34:24','',''),(96,'8','213','2',1,'Sale Id shift 32',0.00,0.00,0.00,771.17,0.00,'2022-09-05 22:34:24','',''),(97,'8','213',NULL,1,'Sale Id shift 32',940290.00,0.00,0.00,0.00,0.00,'2022-09-05 22:34:24','',''),(98,'8','213','1',1,'Sale Id shift 33',0.00,0.00,0.00,2096.08,0.00,'2022-09-06 21:14:04','',''),(99,'8','213','2',1,'Sale Id shift 33',0.00,0.00,0.00,2989.30,0.00,'2022-09-06 21:14:04','',''),(100,'8','213',NULL,1,'Sale Id shift 33',991649.10,0.00,0.00,0.00,0.00,'2022-09-06 21:14:04','',''),(101,'8','213','1',1,'Sale Id shift 34',0.00,0.00,0.00,2717.38,0.00,'2022-09-07 20:59:40','',''),(102,'8','213','2',1,'Sale Id shift 34',0.00,0.00,0.00,3158.73,0.00,'2022-09-07 20:59:40','',''),(103,'8','213',NULL,1,'Sale Id shift 34',1145841.45,0.00,0.00,0.00,0.00,'2022-09-07 20:59:40','',''),(104,'8','213','1',1,'Sale Id shift 35',0.00,0.00,0.00,2296.62,0.00,'2022-09-08 22:08:53','',''),(105,'8','213','2',1,'Sale Id shift 35',0.00,0.00,0.00,3112.80,0.00,'2022-09-08 22:08:53','',''),(106,'8','213',NULL,1,'Sale Id shift 35',1054836.90,0.00,0.00,0.00,0.00,'2022-09-08 22:08:53','',''),(107,'8','213','1',1,'Sale Id shift 36',0.00,0.00,0.00,1627.58,0.00,'2022-09-09 19:57:52','',''),(108,'8','213','2',1,'Sale Id shift 36',0.00,0.00,0.00,2268.31,0.00,'2022-09-09 19:57:52','',''),(109,'8','213',NULL,1,'Sale Id shift 36',759698.55,0.00,0.00,0.00,0.00,'2022-09-09 19:57:52','',''),(110,'8','213','1',1,'Sale Id shift 37',0.00,0.00,0.00,1685.23,0.00,'2022-09-10 21:11:26','',''),(111,'8','213','2',1,'Sale Id shift 37',0.00,0.00,0.00,2278.81,0.00,'2022-09-10 21:11:26','',''),(112,'8','213',NULL,1,'Sale Id shift 37',772987.80,0.00,0.00,0.00,0.00,'2022-09-10 21:11:26','',''),(113,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,9405000.00,49500.00,0.00,0.00,'2022-09-14 11:17:43','',''),(114,'8','213',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,33000.00,0.00,'2022-09-14 11:46:25','',''),(115,'8','213','1',1,'Received from bridging 9',0.00,0.00,33000.00,0.00,0.00,'2022-09-14 11:46:25','',''),(116,'8','213',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,16500.00,0.00,'2022-09-14 11:46:48','',''),(117,'8','213','2',1,'Received from bridging 10',0.00,0.00,16500.00,0.00,0.00,'2022-09-14 11:46:48','',''),(118,'8','213','1',1,'Sale Id shift 38',0.00,0.00,0.00,2079.58,0.00,'2022-09-14 11:49:39','',''),(119,'8','213','1',1,'Sale Id shift 38',0.00,0.00,0.00,2359.52,0.00,'2022-09-14 11:49:39','',''),(120,'8','213','2',1,'Sale Id shift 38',0.00,0.00,0.00,76.75,0.00,'2022-09-14 11:49:39','',''),(121,'8','213',NULL,1,'Sale Id shift 38',880590.75,0.00,0.00,0.00,0.00,'2022-09-14 11:49:39','',''),(122,'8','213','1',1,'Sale Id shift 39',0.00,0.00,0.00,3049.27,0.00,'2022-09-14 20:51:10','',''),(123,'8','213','1',1,'Sale Id shift 39',0.00,0.00,0.00,3443.98,0.00,'2022-09-14 20:51:10','',''),(124,'8','213',NULL,1,'Sale Id shift 39',1233717.50,0.00,0.00,0.00,0.00,'2022-09-14 20:51:10','',''),(125,'8','213','1',1,'Sale Id shift 40',0.00,0.00,0.00,2171.72,0.00,'2022-09-15 20:56:29','',''),(126,'8','213','1',1,'Sale Id shift 40',0.00,0.00,0.00,2842.60,0.00,'2022-09-15 20:56:29','',''),(127,'8','213',NULL,1,'Sale Id shift 40',952720.80,0.00,0.00,0.00,0.00,'2022-09-15 20:56:29','',''),(128,'8','213','1',1,'Sale Id shift 41',0.00,0.00,0.00,2473.50,0.00,'2022-09-17 08:45:07','',''),(129,'8','213','1',1,'Sale Id shift 41',0.00,0.00,0.00,362.94,0.00,'2022-09-17 08:45:07','',''),(130,'8','213','2',1,'Sale Id shift 41',0.00,0.00,0.00,2369.04,0.00,'2022-09-17 08:45:07','',''),(131,'8','213',NULL,1,'Sale Id shift 41',1015068.60,0.00,0.00,0.00,0.00,'2022-09-17 08:45:07','',''),(132,'8','213','1',1,'Sale Id shift 42',0.00,0.00,0.00,2595.48,0.00,'2022-09-18 09:10:21','',''),(133,'8','213','2',1,'Sale Id shift 42',0.00,0.00,0.00,2428.58,0.00,'2022-09-18 09:10:21','',''),(134,'8','213',NULL,1,'Sale Id shift 42',979691.70,0.00,0.00,0.00,0.00,'2022-09-18 09:10:21','',''),(135,'8','213','1',1,'Sale Id shift 43',0.00,0.00,0.00,2225.89,0.00,'2022-09-18 22:23:34','',''),(136,'8','213','2',1,'Sale Id shift 43',0.00,0.00,0.00,2391.03,0.00,'2022-09-18 22:23:34','',''),(137,'8','213',NULL,1,'Sale Id shift 43',900299.40,0.00,0.00,0.00,0.00,'2022-09-18 22:23:34','',''),(138,'8','213','1',1,'Sale Id shift 44',0.00,0.00,0.00,2513.58,0.00,'2022-09-19 21:02:23','',''),(139,'8','213','2',1,'Sale Id shift 44',0.00,0.00,0.00,2242.76,0.00,'2022-09-19 21:02:23','',''),(140,'8','213',NULL,1,'Sale Id shift 44',927486.30,0.00,0.00,0.00,0.00,'2022-09-19 21:02:23','',''),(141,'8','213','1',1,'Sale Id shift 45',0.00,0.00,0.00,2333.61,0.00,'2022-09-20 20:22:23','',''),(142,'8','213','2',1,'Sale Id shift 45',0.00,0.00,0.00,3930.27,0.00,'2022-09-20 20:22:23','',''),(143,'8','213',NULL,1,'Sale Id shift 45',1221456.60,0.00,0.00,0.00,0.00,'2022-09-20 20:22:23','',''),(144,'8','213','1',1,'Sale Id shift 46',0.00,0.00,0.00,3342.57,0.00,'2022-09-21 20:48:41','',''),(145,'8','213','1',1,'Sale Id shift 46',0.00,0.00,0.00,1812.55,0.00,'2022-09-21 20:48:41','',''),(146,'8','213','2',1,'Sale Id shift 46',0.00,0.00,0.00,1632.12,0.00,'2022-09-21 20:48:41','',''),(147,'8','213',NULL,1,'Sale Id shift 46',1323511.80,0.00,0.00,0.00,0.00,'2022-09-21 20:48:41','',''),(148,'8','213','1',1,'Sale Id shift 47',0.00,0.00,0.00,2002.38,0.00,'2022-09-22 15:03:34','',''),(149,'8','213','1',1,'Sale Id shift 47',0.00,0.00,0.00,1186.97,0.00,'2022-09-22 15:03:34','',''),(150,'8','213','2',1,'Sale Id shift 47',0.00,0.00,0.00,1027.03,0.00,'2022-09-22 15:03:34','',''),(151,'8','213',NULL,1,'Sale Id shift 47',822194.10,0.00,0.00,0.00,0.00,'2022-09-22 15:03:34','',''),(152,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,9500000.00,50000.00,0.00,0.00,'2022-09-25 10:45:06','',''),(153,'8','213',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,33000.00,0.00,'2022-09-25 14:22:35','',''),(154,'8','213','2',1,'Received from bridging 12',0.00,0.00,33000.00,0.00,0.00,'2022-09-25 14:22:35','',''),(155,'8','213',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,17000.00,0.00,'2022-09-25 14:23:00','',''),(156,'8','213','1',1,'Received from bridging 11',0.00,0.00,17000.00,0.00,0.00,'2022-09-25 14:23:00','',''),(157,'8','213','1',1,'Sale Id shift 48',0.00,0.00,0.00,2097.41,0.00,'2022-09-25 19:12:07','',''),(158,'8','213','2',1,'Sale Id shift 48',0.00,0.00,0.00,3844.61,0.00,'2022-09-25 19:12:07','',''),(159,'8','213',NULL,1,'Sale Id shift 48',1128983.80,0.00,0.00,0.00,0.00,'2022-09-25 19:12:07','',''),(160,'8','213','1',1,'Sale Id shift 49',0.00,0.00,0.00,2862.96,0.00,'2022-09-26 19:34:28','',''),(161,'8','213','2',1,'Sale Id shift 49',0.00,0.00,0.00,2646.59,0.00,'2022-09-26 19:34:28','',''),(162,'8','213',NULL,1,'Sale Id shift 49',1046814.50,0.00,0.00,0.00,0.00,'2022-09-26 19:34:28','',''),(163,'8','213','1',1,'Sale Id shift 50',0.00,0.00,0.00,3035.61,0.00,'2022-09-27 19:44:41','',''),(164,'8','213','2',1,'Sale Id shift 50',0.00,0.00,0.00,4070.50,0.00,'2022-09-27 19:44:41','',''),(165,'8','213',NULL,1,'Sale Id shift 50',1350160.90,0.00,0.00,0.00,0.00,'2022-09-27 19:44:41','',''),(166,'8','213','1',1,'Sale Id shift 51',0.00,0.00,0.00,3393.05,0.00,'2022-09-28 19:39:04','',''),(167,'8','213','2',1,'Sale Id shift 51',0.00,0.00,0.00,5118.48,0.00,'2022-09-28 19:39:04','',''),(168,'8','213',NULL,1,'Sale Id shift 51',1617190.70,0.00,0.00,0.00,0.00,'2022-09-28 19:39:04','',''),(169,'8','213','1',1,'Sale Id shift 52',0.00,0.00,0.00,3020.92,0.00,'2022-09-29 20:56:41','',''),(170,'8','213','2',1,'Sale Id shift 52',0.00,0.00,0.00,2426.02,0.00,'2022-09-29 20:56:41','',''),(171,'8','213',NULL,1,'Sale Id shift 52',1034918.60,0.00,0.00,0.00,0.00,'2022-09-29 20:56:41','',''),(172,'8','213','1',1,'Sale Id shift 53',0.00,0.00,0.00,2210.51,0.00,'2022-09-30 20:28:29','',''),(173,'8','213','2',1,'Sale Id shift 53',0.00,0.00,0.00,1178.63,0.00,'2022-09-30 20:28:29','',''),(174,'8','213',NULL,1,'Sale Id shift 53',643936.60,0.00,0.00,0.00,0.00,'2022-09-30 20:28:29','',''),(175,'8','213','1',1,'Sale Id shift 54',0.00,0.00,0.00,402.22,0.00,'2022-10-01 21:28:48','',''),(176,'8','213','2',1,'Sale Id shift 54',0.00,0.00,0.00,5788.41,0.00,'2022-10-01 21:28:48','',''),(177,'8','213',NULL,1,'Sale Id shift 54',1176219.70,0.00,0.00,0.00,0.00,'2022-10-01 21:28:48','',''),(178,'8','213','2',1,'Sale Id shift 55',0.00,0.00,0.00,5002.25,0.00,'2022-10-02 20:43:39','',''),(179,'8','213',NULL,1,'Sale Id shift 55',950427.50,0.00,0.00,0.00,0.00,'2022-10-02 20:43:39','',''),(180,'8','213','1',1,'Sale Id shift 56',0.00,0.00,0.00,347.64,0.00,'2022-10-03 21:50:03','',''),(181,'8','213','2',1,'Sale Id shift 56',0.00,0.00,0.00,2734.41,0.00,'2022-10-03 21:50:03','',''),(182,'8','213',NULL,1,'Sale Id shift 56',585589.50,0.00,0.00,0.00,0.00,'2022-10-03 21:50:03','',''),(183,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,10200750.00,50250.00,0.00,0.00,'2022-10-10 14:26:29','',''),(184,'8','213',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,33250.00,0.00,'2022-10-10 16:12:35','',''),(185,'8','213','2',1,'Received from bridging 14',0.00,0.00,33250.00,0.00,0.00,'2022-10-10 16:12:35','',''),(186,'8','213',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,17000.00,0.00,'2022-10-10 16:13:03','',''),(187,'8','213','1',1,'Received from bridging 13',0.00,0.00,17000.00,0.00,0.00,'2022-10-10 16:13:03','',''),(188,'8','213','1',1,'Sale Id shift 57',0.00,0.00,0.00,6444.04,0.00,'2022-10-11 16:31:59','',''),(189,'8','213','2',1,'Sale Id shift 57',0.00,0.00,0.00,7263.04,0.00,'2022-10-11 16:31:59','',''),(190,'8','213',NULL,1,'Sale Id shift 57',2782537.24,0.00,0.00,0.00,0.00,'2022-10-11 16:31:59','',''),(191,'8','213','1',1,'Sale Id shift 58',0.00,0.00,0.00,6042.87,0.00,'2022-10-12 16:24:40','',''),(192,'8','213','2',1,'Sale Id shift 58',0.00,0.00,0.00,8978.58,0.00,'2022-10-12 16:24:40','',''),(193,'8','213',NULL,1,'Sale Id shift 58',3049354.35,0.00,0.00,0.00,0.00,'2022-10-12 16:24:40','',''),(194,'8','213','1',1,'Sale Id shift 59',0.00,0.00,0.00,4500.88,0.00,'2022-10-13 09:42:56','',''),(195,'8','213','2',1,'Sale Id shift 59',0.00,0.00,0.00,7297.58,0.00,'2022-10-13 09:42:56','',''),(196,'8','213',NULL,1,'Sale Id shift 59',2595661.20,0.00,0.00,0.00,0.00,'2022-10-13 09:42:56','',''),(197,'8','213','2',1,'Sale Id shift 60',0.00,0.00,0.00,10125.86,0.00,'2022-10-14 07:22:17','',''),(198,'8','213',NULL,1,'Sale Id shift 60',2227689.20,0.00,0.00,0.00,0.00,'2022-10-14 07:22:17','',''),(199,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,12574100.00,49700.00,0.00,0.00,'2022-11-09 13:31:19','',''),(200,'8','213',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,17000.00,0.00,'2022-11-10 14:48:42','',''),(201,'8','213','2',1,'Received from bridging 16',0.00,0.00,17000.00,0.00,0.00,'2022-11-10 14:48:42','',''),(202,'8','213',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,32700.00,0.00,'2022-11-10 14:50:27','',''),(203,'8','213','1',1,'Received from bridging 15',0.00,0.00,32700.00,0.00,0.00,'2022-11-10 14:50:27','',''),(204,'8','213','1',1,'Sale Id shift 61',0.00,0.00,0.00,3765.58,0.00,'2022-11-10 14:52:29','',''),(205,'8','213','2',1,'Sale Id shift 61',0.00,0.00,0.00,4711.07,0.00,'2022-11-10 14:52:29','',''),(206,'8','213',NULL,1,'Sale Id shift 61',2144592.45,0.00,0.00,0.00,0.00,'2022-11-10 14:52:29','',''),(207,'8','213','1',1,'Sale Id shift 62',0.00,0.00,0.00,3198.64,0.00,'2022-11-11 15:18:19','',''),(208,'8','213','2',1,'Sale Id shift 62',0.00,0.00,0.00,4180.06,0.00,'2022-11-11 15:18:19','',''),(209,'8','213',NULL,1,'Sale Id shift 62',1866811.10,0.00,0.00,0.00,0.00,'2022-11-11 15:18:19','',''),(210,'8','213','1',1,'Sale Id shift 63',0.00,0.00,0.00,3009.99,0.00,'2022-11-12 15:03:04','',''),(211,'8','213','2',1,'Sale Id shift 63',0.00,0.00,0.00,3555.30,0.00,'2022-11-12 15:03:04','',''),(212,'8','213',NULL,1,'Sale Id shift 63',1661018.37,0.00,0.00,0.00,0.00,'2022-11-12 15:03:04','',''),(213,'8','213','1',1,'Sale Id shift 64',0.00,0.00,0.00,121.43,0.00,'2022-11-13 07:17:51','',''),(214,'8','213','1',1,'Sale Id shift 64',0.00,0.00,0.00,2900.96,0.00,'2022-11-13 07:17:51','',''),(215,'8','213','2',1,'Sale Id shift 64',0.00,0.00,0.00,2954.62,0.00,'2022-11-13 07:17:51','',''),(216,'8','213',NULL,1,'Sale Id shift 64',1512183.53,0.00,0.00,0.00,0.00,'2022-11-13 07:17:51','',''),(217,'8','213','1',1,'Sale Id shift 65',0.00,0.00,0.00,3007.96,0.00,'2022-11-14 10:55:22','',''),(218,'8','213','2',1,'Sale Id shift 65',0.00,0.00,0.00,1906.89,0.00,'2022-11-14 10:55:22','',''),(219,'8','213',NULL,1,'Sale Id shift 65',1243457.05,0.00,0.00,0.00,0.00,'2022-11-14 10:55:22','',''),(220,'8','213','1',1,'Sale Id shift 66',0.00,0.00,0.00,2352.41,0.00,'2022-11-14 19:07:35','',''),(221,'8','213','1',1,'Sale Id shift 66',0.00,0.00,0.00,3502.61,0.00,'2022-11-14 19:07:35','',''),(222,'8','213',NULL,1,'Sale Id shift 66',1493030.10,0.00,0.00,0.00,0.00,'2022-11-14 19:07:35','',''),(223,'8','213','1',1,'Sale Id shift 67',0.00,0.00,0.00,3109.82,0.00,'2022-11-15 20:51:49','',''),(224,'8','213','1',1,'Sale Id shift 67',0.00,0.00,0.00,4079.96,0.00,'2022-11-15 20:51:49','',''),(225,'8','213',NULL,1,'Sale Id shift 67',1833393.90,0.00,0.00,0.00,0.00,'2022-11-15 20:51:49','',''),(226,'8','213','1',1,'Sale Id shift 68',0.00,0.00,0.00,1677.15,0.00,'2022-11-16 22:12:34','',''),(227,'8','213','1',1,'Sale Id shift 68',0.00,0.00,0.00,2005.43,0.00,'2022-11-16 22:12:34','',''),(228,'8','213',NULL,1,'Sale Id shift 68',939057.90,0.00,0.00,0.00,0.00,'2022-11-16 22:12:34','',''),(229,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,12857000.00,49450.00,0.00,0.00,'2022-11-24 14:58:07','',''),(230,'8','213',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,32700.00,0.00,'2022-11-24 15:50:01','',''),(231,'8','213','2',1,'Received from bridging 18',0.00,0.00,32700.00,0.00,0.00,'2022-11-24 15:50:01','',''),(232,'8','213',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,16750.00,0.00,'2022-11-24 15:50:25','',''),(233,'8','213','1',1,'Received from bridging 17',0.00,0.00,16750.00,0.00,0.00,'2022-11-24 15:50:25','',''),(234,'8','213','1',1,'Sale Id shift 69',0.00,0.00,0.00,2064.07,0.00,'2022-11-24 20:08:23','',''),(235,'8','213','2',1,'Sale Id shift 69',0.00,0.00,0.00,3853.41,0.00,'2022-11-24 20:08:23','',''),(236,'8','213',NULL,1,'Sale Id shift 69',1538544.80,0.00,0.00,0.00,0.00,'2022-11-24 20:08:23','',''),(237,'8','213','1',1,'Sale Id shift 70',0.00,0.00,0.00,1473.26,0.00,'2022-11-25 18:58:29','',''),(238,'8','213','2',1,'Sale Id shift 70',0.00,0.00,0.00,3003.96,0.00,'2022-11-25 18:58:29','',''),(239,'8','213',NULL,1,'Sale Id shift 70',1164077.20,0.00,0.00,0.00,0.00,'2022-11-25 18:58:29','',''),(240,'8','213','1',1,'Sale Id shift 71',0.00,0.00,0.00,2113.65,0.00,'2022-11-26 18:53:32','',''),(241,'8','213','2',1,'Sale Id shift 71',0.00,0.00,0.00,2054.90,0.00,'2022-11-26 18:53:32','',''),(242,'8','213',NULL,1,'Sale Id shift 71',1083823.00,0.00,0.00,0.00,0.00,'2022-11-26 18:53:32','',''),(243,'8','213','1',1,'Sale Id shift 72',0.00,0.00,0.00,1386.75,0.00,'2022-11-27 19:15:02','',''),(244,'8','213','2',1,'Sale Id shift 72',0.00,0.00,0.00,3091.56,0.00,'2022-11-27 19:15:02','',''),(245,'8','213',NULL,1,'Sale Id shift 72',1164360.60,0.00,0.00,0.00,0.00,'2022-11-27 19:15:02','',''),(246,'8','213','1',1,'Sale Id shift 73',0.00,0.00,0.00,1138.61,0.00,'2022-11-28 19:00:02','',''),(247,'8','213','2',1,'Sale Id shift 73',0.00,0.00,0.00,3017.61,0.00,'2022-11-28 19:00:02','',''),(248,'8','213',NULL,1,'Sale Id shift 73',1080617.20,0.00,0.00,0.00,0.00,'2022-11-28 19:00:02','',''),(249,'8','213','1',1,'Sale Id shift 74',0.00,0.00,0.00,917.43,0.00,'2022-11-29 19:35:20','',''),(250,'8','213','1',1,'Sale Id shift 74',0.00,0.00,0.00,1749.04,0.00,'2022-11-29 19:35:20','',''),(251,'8','213','2',1,'Sale Id shift 74',0.00,0.00,0.00,2243.77,0.00,'2022-11-29 19:35:20','',''),(252,'8','213',NULL,1,'Sale Id shift 74',1276662.40,0.00,0.00,0.00,0.00,'2022-11-29 19:35:20','',''),(253,'8','213','1',1,'Sale Id shift 75',0.00,0.00,0.00,3533.79,0.00,'2022-11-30 19:47:24','',''),(254,'8','213','1',1,'Sale Id shift 75',0.00,0.00,0.00,429.23,0.00,'2022-11-30 19:47:24','',''),(255,'8','213','2',1,'Sale Id shift 75',0.00,0.00,0.00,5171.16,0.00,'2022-11-30 19:47:24','',''),(256,'8','213',NULL,1,'Sale Id shift 75',2374886.80,0.00,0.00,0.00,0.00,'2022-11-30 19:47:24','',''),(257,'8','213','1',1,'Sale Id shift 76',0.00,0.00,0.00,1854.73,0.00,'2022-12-01 19:03:28','',''),(258,'8','213','2',1,'Sale Id shift 76',0.00,0.00,0.00,4723.65,0.00,'2022-12-01 19:03:28','',''),(259,'8','213',NULL,1,'Sale Id shift 76',1710378.80,0.00,0.00,0.00,0.00,'2022-12-01 19:03:28','',''),(260,'8','213','2',1,'Sale Id shift 77',0.00,0.00,0.00,4996.27,0.00,'2022-12-02 14:02:19','',''),(261,'8','213',NULL,1,'Sale Id shift 77',1299030.20,0.00,0.00,0.00,0.00,'2022-12-02 14:02:19','',''),(262,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,13930800.00,44650.00,0.00,0.00,'2022-12-17 15:40:36','',''),(263,'8','213',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,16000.00,0.00,'2022-12-17 18:02:58','',''),(264,'8','213','2',1,'Received from bridging 20',0.00,0.00,16000.00,0.00,0.00,'2022-12-17 18:02:58','',''),(265,'8','213',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,28650.00,0.00,'2022-12-17 18:03:18','',''),(266,'8','213','1',1,'Received from bridging 19',0.00,0.00,28650.00,0.00,0.00,'2022-12-17 18:03:18','',''),(267,'8','213','1',1,'Sale Id shift 78',0.00,0.00,0.00,1736.35,0.00,'2022-12-18 08:03:42','',''),(268,'8','213','2',1,'Sale Id shift 78',0.00,0.00,0.00,1727.00,0.00,'2022-12-18 08:03:42','',''),(269,'8','213',NULL,1,'Sale Id shift 78',1080565.20,0.00,0.00,0.00,0.00,'2022-12-18 08:03:42','',''),(270,'8','213','1',1,'Sale Id shift 79',0.00,0.00,0.00,1637.65,0.00,'2022-12-18 19:31:05','',''),(271,'8','213','2',1,'Sale Id shift 79',0.00,0.00,0.00,1851.19,0.00,'2022-12-18 19:31:05','',''),(272,'8','213',NULL,1,'Sale Id shift 79',1088518.08,0.00,0.00,0.00,0.00,'2022-12-18 19:31:05','',''),(273,'8','213','1',1,'Sale Id shift 80',0.00,0.00,0.00,1586.19,0.00,'2022-12-20 07:22:16','',''),(274,'8','213','2',1,'Sale Id shift 80',0.00,0.00,0.00,2073.94,0.00,'2022-12-20 07:22:16','',''),(275,'8','213',NULL,1,'Sale Id shift 80',1141960.56,0.00,0.00,0.00,0.00,'2022-12-20 07:22:16','',''),(276,'8','213','1',1,'Sale Id shift 81',0.00,0.00,0.00,2000.71,0.00,'2022-12-21 09:15:59','',''),(277,'8','213','2',1,'Sale Id shift 81',0.00,0.00,0.00,2399.15,0.00,'2022-12-21 09:15:59','',''),(278,'8','213',NULL,1,'Sale Id shift 81',1372756.32,0.00,0.00,0.00,0.00,'2022-12-21 09:15:59','',''),(279,'8','213','1',1,'Sale Id shift 82',0.00,0.00,0.00,2570.82,0.00,'2022-12-22 08:30:47','',''),(280,'8','213','2',1,'Sale Id shift 82',0.00,0.00,0.00,2955.51,0.00,'2022-12-22 08:30:47','',''),(281,'8','213',NULL,1,'Sale Id shift 82',1724214.96,0.00,0.00,0.00,0.00,'2022-12-22 08:30:47','',''),(282,'8','213','1',1,'Sale Id shift 83',0.00,0.00,0.00,1520.26,0.00,'2022-12-23 07:56:46','',''),(283,'8','213','2',1,'Sale Id shift 83',0.00,0.00,0.00,1865.13,0.00,'2022-12-23 07:56:46','',''),(284,'8','213',NULL,1,'Sale Id shift 83',1056241.68,0.00,0.00,0.00,0.00,'2022-12-23 07:56:46','',''),(285,'8','213','1',1,'Sale Id shift 84',0.00,0.00,0.00,1232.05,0.00,'2022-12-24 06:05:32','',''),(286,'8','213','2',1,'Sale Id shift 84',0.00,0.00,0.00,1887.74,0.00,'2022-12-24 06:05:32','',''),(287,'8','213',NULL,1,'Sale Id shift 84',973374.48,0.00,0.00,0.00,0.00,'2022-12-24 06:05:32','',''),(288,'8','213','1',1,'Sale Id shift 85',0.00,0.00,0.00,1561.78,0.00,'2022-12-25 08:16:22','',''),(289,'8','213','1',1,'Sale Id shift 85',0.00,0.00,0.00,383.55,0.00,'2022-12-25 08:16:22','',''),(290,'8','213','2',1,'Sale Id shift 85',0.00,0.00,0.00,1635.49,0.00,'2022-12-25 08:16:22','',''),(291,'8','213',NULL,1,'Sale Id shift 85',1117215.84,0.00,0.00,0.00,0.00,'2022-12-25 08:16:22','',''),(292,'8','213','1',1,'Sale Id shift 86',0.00,0.00,0.00,1214.26,0.00,'2022-12-26 07:31:37','',''),(293,'8','213','1',1,'Sale Id shift 86',0.00,0.00,0.00,1248.61,0.00,'2022-12-26 07:31:37','',''),(294,'8','213',NULL,1,'Sale Id shift 86',738861.00,0.00,0.00,0.00,0.00,'2022-12-26 07:31:37','',''),(295,'8','213','1',1,'Sale Id shift 87',0.00,0.00,0.00,1421.12,0.00,'2022-12-26 19:06:24','',''),(296,'8','213','1',1,'Sale Id shift 87',0.00,0.00,0.00,1701.05,0.00,'2022-12-26 19:06:24','',''),(297,'8','213',NULL,1,'Sale Id shift 87',936651.00,0.00,0.00,0.00,0.00,'2022-12-26 19:06:24','',''),(298,'8','213','1',1,'Sale Id shift 88',0.00,0.00,0.00,1929.55,0.00,'2022-12-27 19:15:37','',''),(299,'8','213','1',1,'Sale Id shift 88',0.00,0.00,0.00,2189.72,0.00,'2022-12-27 19:15:37','',''),(300,'8','213',NULL,1,'Sale Id shift 88',1235781.00,0.00,0.00,0.00,0.00,'2022-12-27 19:15:37','',''),(301,'8','213','1',1,'Sale Id shift 89',0.00,0.00,0.00,1897.39,0.00,'2022-12-28 17:38:27','',''),(302,'8','213','1',1,'Sale Id shift 89',0.00,0.00,0.00,2803.13,0.00,'2022-12-28 17:38:27','',''),(303,'8','213',NULL,1,'Sale Id shift 89',1410156.00,0.00,0.00,0.00,0.00,'2022-12-28 17:38:27','',''),(304,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,14661600.00,49200.00,0.00,0.00,'2023-01-02 14:43:25','',''),(305,'8','213',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,17000.00,0.00,'2023-01-02 14:51:08','',''),(306,'8','213','2',1,'Received from bridging 22',0.00,0.00,17000.00,0.00,0.00,'2023-01-02 14:51:08','',''),(307,'8','213',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,32200.00,0.00,'2023-01-02 14:51:37','',''),(308,'8','213','1',1,'Received from bridging 21',0.00,0.00,32200.00,0.00,0.00,'2023-01-02 14:51:37','',''),(309,'8','213','1',1,'Sale Id shift 90',0.00,0.00,0.00,1518.10,0.00,'2023-01-02 20:34:32','',''),(310,'8','213','1',1,'Sale Id shift 90',0.00,0.00,0.00,2131.65,0.00,'2023-01-02 20:34:32','',''),(311,'8','213',NULL,1,'Sale Id shift 90',1087625.50,0.00,0.00,0.00,0.00,'2023-01-02 20:34:32','',''),(312,'8','213','1',1,'Sale Id shift 91',0.00,0.00,0.00,1340.26,0.00,'2023-01-03 21:12:51','',''),(313,'8','213','1',1,'Sale Id shift 91',0.00,0.00,0.00,1176.38,0.00,'2023-01-03 21:12:51','',''),(314,'8','213','2',1,'Sale Id shift 91',0.00,0.00,0.00,642.66,0.00,'2023-01-03 21:12:51','',''),(315,'8','213',NULL,1,'Sale Id shift 91',941471.40,0.00,0.00,0.00,0.00,'2023-01-03 21:12:51','',''),(316,'8','213','1',1,'Sale Id shift 92',0.00,0.00,0.00,2300.31,0.00,'2023-01-04 20:30:28','',''),(317,'8','213','2',1,'Sale Id shift 92',0.00,0.00,0.00,2450.10,0.00,'2023-01-04 20:30:28','',''),(318,'8','213',NULL,1,'Sale Id shift 92',1415622.18,0.00,0.00,0.00,0.00,'2023-01-04 20:30:28','',''),(319,'8','213','1',1,'Sale Id shift 93',0.00,0.00,0.00,1903.76,0.00,'2023-01-05 20:00:10','',''),(320,'8','213','2',1,'Sale Id shift 93',0.00,0.00,0.00,2134.68,0.00,'2023-01-05 20:00:10','',''),(321,'8','213',NULL,1,'Sale Id shift 93',1203455.12,0.00,0.00,0.00,0.00,'2023-01-05 20:00:10','',''),(322,'8','213','1',1,'Sale Id shift 94',0.00,0.00,0.00,1856.72,0.00,'2023-01-06 19:09:00','',''),(323,'8','213','2',1,'Sale Id shift 94',0.00,0.00,0.00,2638.63,0.00,'2023-01-06 19:09:00','',''),(324,'8','213',NULL,1,'Sale Id shift 94',1339614.30,0.00,0.00,0.00,0.00,'2023-01-06 19:09:00','',''),(325,'8','213','1',1,'Sale Id shift 95',0.00,0.00,0.00,855.46,0.00,'2023-01-07 19:19:00','',''),(326,'8','213','1',1,'Sale Id shift 95',0.00,0.00,0.00,555.30,0.00,'2023-01-07 19:19:00','',''),(327,'8','213','2',1,'Sale Id shift 95',0.00,0.00,0.00,2333.73,0.00,'2023-01-07 19:19:00','',''),(328,'8','213',NULL,1,'Sale Id shift 95',1115858.02,0.00,0.00,0.00,0.00,'2023-01-07 19:19:00','',''),(329,'8','213','1',1,'Sale Id shift 96',0.00,0.00,0.00,1827.66,0.00,'2023-01-08 22:39:45','',''),(330,'8','213','2',1,'Sale Id shift 96',0.00,0.00,0.00,1915.64,0.00,'2023-01-08 22:39:45','',''),(331,'8','213',NULL,1,'Sale Id shift 96',1115503.40,0.00,0.00,0.00,0.00,'2023-01-08 22:39:45','',''),(332,'8','213','1',1,'Sale Id shift 97',0.00,0.00,0.00,2495.89,0.00,'2023-01-10 07:57:01','',''),(333,'8','213','2',1,'Sale Id shift 97',0.00,0.00,0.00,2995.41,0.00,'2023-01-10 07:57:01','',''),(334,'8','213',NULL,1,'Sale Id shift 97',1636407.40,0.00,0.00,0.00,0.00,'2023-01-10 07:57:01','',''),(335,'8','213','1',1,'Sale Id shift 98',0.00,0.00,0.00,603.01,0.00,'2023-01-11 07:22:03','',''),(336,'8','213','1',1,'Sale Id shift 98',0.00,0.00,0.00,2709.36,0.00,'2023-01-11 07:22:03','',''),(337,'8','213','2',1,'Sale Id shift 98',0.00,0.00,0.00,1655.81,0.00,'2023-01-11 07:22:03','',''),(338,'8','213',NULL,1,'Sale Id shift 98',1480517.64,0.00,0.00,0.00,0.00,'2023-01-11 07:22:03','',''),(339,'8','213','1',1,'Sale Id shift 99',0.00,0.00,0.00,3034.94,0.00,'2023-01-12 07:53:32','',''),(340,'8','213','1',1,'Sale Id shift 99',0.00,0.00,0.00,3320.46,0.00,'2023-01-12 07:53:32','',''),(341,'8','213',NULL,1,'Sale Id shift 99',1893909.20,0.00,0.00,0.00,0.00,'2023-01-12 07:53:32','',''),(342,'8','213','1',1,'Sale Id shift 100',0.00,0.00,0.00,1095.92,0.00,'2023-01-13 08:24:21','',''),(343,'8','213','1',1,'Sale Id shift 100',0.00,0.00,0.00,1360.81,0.00,'2023-01-13 08:24:21','',''),(344,'8','213',NULL,1,'Sale Id shift 100',732105.54,0.00,0.00,0.00,0.00,'2023-01-13 08:24:21','',''),(345,'8','213','1',1,'Sale Id shift 101',0.00,0.00,0.00,1474.94,0.00,'2023-01-13 09:17:48','',''),(346,'8','213','1',1,'Sale Id shift 101',0.00,0.00,0.00,584.72,0.00,'2023-01-13 09:17:48','',''),(347,'8','213',NULL,1,'Sale Id shift 101',613778.68,0.00,0.00,0.00,0.00,'2023-01-13 09:17:48','',''),(348,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,17250000.00,50000.00,0.00,0.00,'2023-02-01 08:22:52','',''),(349,'8','213',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,16000.00,0.00,'2023-02-01 08:28:54','',''),(350,'8','213','1',1,'Received from bridging 23',0.00,0.00,16000.00,0.00,0.00,'2023-02-01 08:28:54','',''),(351,'8','213',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,34000.00,0.00,'2023-02-01 08:29:12','',''),(352,'8','213','2',1,'Received from bridging 24',0.00,0.00,34000.00,0.00,0.00,'2023-02-01 08:29:12','',''),(353,'8','213','1',1,'Sale Id shift 102',0.00,0.00,0.00,2379.62,0.00,'2023-02-02 07:56:55','',''),(354,'8','213','1',1,'Sale Id shift 102',0.00,0.00,0.00,422.56,0.00,'2023-02-02 07:56:55','',''),(355,'8','213','2',1,'Sale Id shift 102',0.00,0.00,0.00,3499.68,0.00,'2023-02-02 07:56:55','',''),(356,'8','213',NULL,1,'Sale Id shift 102',2174141.70,0.00,0.00,0.00,0.00,'2023-02-02 07:56:55','',''),(357,'8','213','1',1,'Sale Id shift 103',0.00,0.00,0.00,1497.39,0.00,'2023-02-03 07:54:50','',''),(358,'8','213','2',1,'Sale Id shift 103',0.00,0.00,0.00,2263.94,0.00,'2023-02-03 07:54:50','',''),(359,'8','213',NULL,1,'Sale Id shift 103',1297658.85,0.00,0.00,0.00,0.00,'2023-02-03 07:54:50','',''),(360,'8','213','1',1,'Sale Id shift 104',0.00,0.00,0.00,1904.34,0.00,'2023-02-03 21:50:43','',''),(361,'8','213','2',1,'Sale Id shift 104',0.00,0.00,0.00,2404.01,0.00,'2023-02-03 21:50:43','',''),(362,'8','213',NULL,1,'Sale Id shift 104',1486380.75,0.00,0.00,0.00,0.00,'2023-02-03 21:50:43','',''),(363,'8','213','1',1,'Sale Id shift 105',0.00,0.00,0.00,1254.31,0.00,'2023-02-05 07:24:07','',''),(364,'8','213','2',1,'Sale Id shift 105',0.00,0.00,0.00,2636.65,0.00,'2023-02-05 07:24:07','',''),(365,'8','213',NULL,1,'Sale Id shift 105',1342381.20,0.00,0.00,0.00,0.00,'2023-02-05 07:24:07','',''),(366,'8','213','1',1,'Sale Id shift 106',0.00,0.00,0.00,1930.37,0.00,'2023-02-05 19:42:59','',''),(367,'8','213','2',1,'Sale Id shift 106',0.00,0.00,0.00,2676.49,0.00,'2023-02-05 19:42:59','',''),(368,'8','213',NULL,1,'Sale Id shift 106',1589366.70,0.00,0.00,0.00,0.00,'2023-02-05 19:42:59','',''),(369,'8','213','1',1,'Sale Id shift 107',0.00,0.00,0.00,2512.72,0.00,'2023-02-07 07:27:53','',''),(370,'8','213','2',1,'Sale Id shift 107',0.00,0.00,0.00,4022.38,0.00,'2023-02-07 07:27:53','',''),(371,'8','213',NULL,1,'Sale Id shift 107',2254609.50,0.00,0.00,0.00,0.00,'2023-02-07 07:27:53','',''),(372,'8','213','1',1,'Sale Id shift 108',0.00,0.00,0.00,2857.10,0.00,'2023-02-08 09:52:00','',''),(373,'8','213','2',1,'Sale Id shift 108',0.00,0.00,0.00,4518.64,0.00,'2023-02-08 09:52:00','',''),(374,'8','213',NULL,1,'Sale Id shift 108',2544630.30,0.00,0.00,0.00,0.00,'2023-02-08 09:52:00','',''),(375,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,5865000.00,17000.00,0.00,0.00,'2023-02-08 21:21:00','',''),(376,'8','213',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,17000.00,0.00,'2023-02-08 22:08:23','',''),(377,'8','213','1',1,'Received from bridging 25',0.00,0.00,17000.00,0.00,0.00,'2023-02-08 22:08:23','',''),(378,'8','213','1',1,'Sale Id shift 109',0.00,0.00,0.00,1900.88,0.00,'2023-02-09 07:42:49','',''),(379,'8','213','2',1,'Sale Id shift 109',0.00,0.00,0.00,5819.54,0.00,'2023-02-09 07:42:49','',''),(380,'8','213',NULL,1,'Sale Id shift 109',2663544.90,0.00,0.00,0.00,0.00,'2023-02-09 07:42:49','',''),(381,'8','213','1',1,'Sale Id shift 110',0.00,0.00,0.00,3139.17,0.00,'2023-02-10 20:23:50','',''),(382,'8','213','2',1,'Sale Id shift 110',0.00,0.00,0.00,4616.86,0.00,'2023-02-10 20:23:50','',''),(383,'8','213',NULL,1,'Sale Id shift 110',2675830.35,0.00,0.00,0.00,0.00,'2023-02-10 20:23:50','',''),(384,'8','213','1',1,'Sale Id shift 111',0.00,0.00,0.00,2391.83,0.00,'2023-02-11 20:55:51','',''),(385,'8','213','1',1,'Sale Id shift 111',0.00,0.00,0.00,1171.14,0.00,'2023-02-11 20:55:51','',''),(386,'8','213','2',1,'Sale Id shift 111',0.00,0.00,0.00,1609.40,0.00,'2023-02-11 20:55:51','',''),(387,'8','213',NULL,1,'Sale Id shift 111',1784467.65,0.00,0.00,0.00,0.00,'2023-02-11 20:55:51','',''),(388,'8','213','1',1,'Sale Id shift 112',0.00,0.00,0.00,3110.54,0.00,'2023-02-12 10:32:58','',''),(389,'8','213','1',1,'Sale Id shift 112',0.00,0.00,0.00,3320.34,0.00,'2023-02-12 10:32:58','',''),(390,'8','213',NULL,1,'Sale Id shift 112',2218653.60,0.00,0.00,0.00,0.00,'2023-02-12 10:32:58','',''),(391,'8','213','1',1,'Sale Id shift 113',0.00,0.00,0.00,361.52,0.00,'2023-02-12 10:42:16','',''),(392,'8','213','1',1,'Sale Id shift 113',0.00,0.00,0.00,2739.06,0.00,'2023-02-12 10:42:16','',''),(393,'8','213',NULL,1,'Sale Id shift 113',1069700.10,0.00,0.00,0.00,0.00,'2023-02-12 10:42:16','',''),(394,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,16711000.00,49150.00,0.00,0.00,'2023-02-17 07:38:44','',''),(395,'8','213',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,30000.00,0.00,'2023-02-17 07:50:30','',''),(396,'8','213','2',1,'Received from bridging 27',0.00,0.00,30000.00,0.00,0.00,'2023-02-17 07:50:30','',''),(397,'8','213',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,19150.00,0.00,'2023-02-17 07:50:58','',''),(398,'8','213','1',1,'Received from bridging 26',0.00,0.00,19150.00,0.00,0.00,'2023-02-17 07:50:58','',''),(399,'8','213','1',1,'Sale Id shift 114',0.00,0.00,0.00,1145.87,0.00,'2023-02-18 17:05:09','',''),(400,'8','213','2',1,'Sale Id shift 114',0.00,0.00,0.00,2242.74,0.00,'2023-02-18 17:05:09','',''),(401,'8','213',NULL,1,'Sale Id shift 114',1152127.40,0.00,0.00,0.00,0.00,'2023-02-18 17:05:09','',''),(402,'8','213','1',1,'Sale Id shift 115',0.00,0.00,0.00,1299.54,0.00,'2023-02-19 17:13:43','',''),(403,'8','213','2',1,'Sale Id shift 115',0.00,0.00,0.00,2021.19,0.00,'2023-02-19 17:13:43','',''),(404,'8','213',NULL,1,'Sale Id shift 115',1129048.20,0.00,0.00,0.00,0.00,'2023-02-19 17:13:43','',''),(405,'8','213','1',1,'Sale Id shift 116',0.00,0.00,0.00,1230.75,0.00,'2023-02-20 13:02:51','',''),(406,'8','213','2',1,'Sale Id shift 116',0.00,0.00,0.00,2479.73,0.00,'2023-02-20 13:02:51','',''),(407,'8','213',NULL,1,'Sale Id shift 116',1261563.20,0.00,0.00,0.00,0.00,'2023-02-20 13:02:51','',''),(408,'8','213','1',1,'Sale Id shift 117',0.00,0.00,0.00,1032.00,0.00,'2023-02-21 10:05:40','',''),(409,'8','213','2',1,'Sale Id shift 117',0.00,0.00,0.00,2965.40,0.00,'2023-02-21 10:05:40','',''),(410,'8','213',NULL,1,'Sale Id shift 117',1359116.00,0.00,0.00,0.00,0.00,'2023-02-21 10:05:40','',''),(411,'8','213','1',1,'Sale Id shift 118',0.00,0.00,0.00,1162.04,0.00,'2023-02-22 17:24:07','',''),(412,'8','213','2',1,'Sale Id shift 118',0.00,0.00,0.00,1786.74,0.00,'2023-02-22 17:24:07','',''),(413,'8','213',NULL,1,'Sale Id shift 118',1002585.20,0.00,0.00,0.00,0.00,'2023-02-22 17:24:07','',''),(414,'8','213','1',1,'Sale Id shift 119',0.00,0.00,0.00,2228.04,0.00,'2023-02-23 14:47:03','',''),(415,'8','213','2',1,'Sale Id shift 119',0.00,0.00,0.00,2167.71,0.00,'2023-02-23 14:47:03','',''),(416,'8','213',NULL,1,'Sale Id shift 119',1494555.00,0.00,0.00,0.00,0.00,'2023-02-23 14:47:03','',''),(417,'8','213','1',1,'Sale Id shift 120',0.00,0.00,0.00,1257.37,0.00,'2023-02-26 21:10:07','',''),(418,'8','213','2',1,'Sale Id shift 120',0.00,0.00,0.00,2715.27,0.00,'2023-02-26 21:10:07','',''),(419,'8','213',NULL,1,'Sale Id shift 120',1350697.60,0.00,0.00,0.00,0.00,'2023-02-26 21:10:07','',''),(420,'8','213','1',1,'Sale Id shift 121',0.00,0.00,0.00,2007.66,0.00,'2023-02-26 21:19:20','',''),(421,'8','213','2',1,'Sale Id shift 121',0.00,0.00,0.00,3914.11,0.00,'2023-02-26 21:19:20','',''),(422,'8','213',NULL,1,'Sale Id shift 121',1894966.40,0.00,0.00,0.00,0.00,'2023-02-26 21:19:20','',''),(423,'8','213','1',1,'Sale Id shift 122',0.00,0.00,0.00,2166.71,0.00,'2023-02-26 21:48:44','',''),(424,'8','213','2',1,'Sale Id shift 122',0.00,0.00,0.00,5118.13,0.00,'2023-02-26 21:48:44','',''),(425,'8','213',NULL,1,'Sale Id shift 122',2331148.80,0.00,0.00,0.00,0.00,'2023-02-26 21:48:44','',''),(426,'8','213','1',1,'Sale Id shift 123',0.00,0.00,0.00,1790.98,0.00,'2023-02-28 07:53:28','',''),(427,'8','213','2',1,'Sale Id shift 123',0.00,0.00,0.00,3648.05,0.00,'2023-02-28 07:53:28','',''),(428,'8','213',NULL,1,'Sale Id shift 123',1740489.60,0.00,0.00,0.00,0.00,'2023-02-28 07:53:28','',''),(429,'8','213','1',1,'Sale Id shift 124',0.00,0.00,0.00,1962.35,0.00,'2023-03-01 19:12:11','',''),(430,'8','213','1',1,'Sale Id shift 124',0.00,0.00,0.00,1635.04,0.00,'2023-03-01 19:12:11','',''),(431,'8','213','2',1,'Sale Id shift 124',0.00,0.00,0.00,855.47,0.00,'2023-03-01 19:12:11','',''),(432,'8','213',NULL,1,'Sale Id shift 124',1424915.20,0.00,0.00,0.00,0.00,'2023-03-01 19:12:11','',''),(433,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,13053750.00,44250.00,0.00,0.00,'2023-03-07 21:32:15','',''),(434,'8','213',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,15700.00,0.00,'2023-03-08 08:39:07','',''),(435,'8','213','2',1,'Received from bridging 29',0.00,0.00,15700.00,0.00,0.00,'2023-03-08 08:39:07','',''),(436,'8','213',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,28550.00,0.00,'2023-03-08 08:39:32','',''),(437,'8','213','1',1,'Received from bridging 28',0.00,0.00,28550.00,0.00,0.00,'2023-03-08 08:39:32','',''),(438,'8','213','1',1,'Sale Id shift 126',0.00,0.00,0.00,3136.37,0.00,'2023-03-15 17:19:12','',''),(439,'8','213','2',1,'Sale Id shift 126',0.00,0.00,0.00,4089.20,0.00,'2023-03-15 17:19:12','',''),(440,'8','213',NULL,1,'Sale Id shift 126',2131543.15,0.00,0.00,0.00,0.00,'2023-03-15 17:19:12','',''),(441,'8','213','1',1,'Sale Id shift 127',0.00,0.00,0.00,2785.42,0.00,'2023-03-15 17:26:06','',''),(442,'8','213','2',1,'Sale Id shift 127',0.00,0.00,0.00,4653.94,0.00,'2023-03-15 17:26:06','',''),(443,'8','213',NULL,1,'Sale Id shift 127',2194611.20,0.00,0.00,0.00,0.00,'2023-03-15 17:26:06','',''),(444,'8','213','1',1,'Sale Id shift 128',0.00,0.00,0.00,2286.77,0.00,'2023-03-15 17:36:37','',''),(445,'8','213','1',1,'Sale Id shift 128',0.00,0.00,0.00,732.12,0.00,'2023-03-15 17:36:37','',''),(446,'8','213','2',1,'Sale Id shift 128',0.00,0.00,0.00,3615.97,0.00,'2023-03-15 17:36:37','',''),(447,'8','213',NULL,1,'Sale Id shift 128',1957283.70,0.00,0.00,0.00,0.00,'2023-03-15 17:36:37','',''),(448,'8','213','1',1,'Sale Id shift 129',0.00,0.00,0.00,2174.73,0.00,'2023-03-15 17:43:48','',''),(449,'8','213','1',1,'Sale Id shift 129',0.00,0.00,0.00,3073.56,0.00,'2023-03-15 17:43:48','',''),(450,'8','213',NULL,1,'Sale Id shift 129',1548245.55,0.00,0.00,0.00,0.00,'2023-03-15 17:43:48','',''),(451,'8','213','1',1,'Sale Id shift 130',0.00,0.00,0.00,4855.75,0.00,'2023-03-15 17:47:42','',''),(452,'8','213','1',1,'Sale Id shift 130',0.00,0.00,0.00,3140.01,0.00,'2023-03-15 17:47:42','',''),(453,'8','213',NULL,1,'Sale Id shift 130',2358749.20,0.00,0.00,0.00,0.00,'2023-03-15 17:47:42','',''),(454,'8','213','1',1,'Sale Id shift 131',0.00,0.00,0.00,1314.95,0.00,'2023-03-15 21:52:47','',''),(455,'8','213','1',1,'Sale Id shift 131',0.00,0.00,0.00,2172.54,0.00,'2023-03-15 21:52:47','',''),(456,'8','213',NULL,1,'Sale Id shift 131',1028809.55,0.00,0.00,0.00,0.00,'2023-03-15 21:52:47','',''),(457,'8','213',NULL,1,'Purchased from Lausu Energy Resources',0.00,14350000.00,50000.00,0.00,0.00,'2023-03-21 00:27:59','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'8','213',3,0.00,'2023-03-20 21:05:27'),(2,'8','213',2,0.00,'2023-03-20 21:05:27'),(3,'8','213',1,57372.23,'2023-03-21 00:27:59');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=125 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'8','213',1,'Sale Id shift 3',0.00,864489.20,0.00,0.00,-864489.20,'2022-08-13 11:30:06'),(2,'8','213',1,'Sale Id shift 5',0.00,778166.70,215.00,778166.70,0.00,'2022-08-14 10:09:49'),(3,'8','213',1,'Sale Id shift 6',0.00,796860.95,215.00,796860.95,0.00,'2022-08-14 10:41:16'),(4,'8','213',1,'Sale Id shift 7',0.00,581658.85,210.00,568131.90,-13526.95,'2022-08-14 10:45:29'),(5,'8','213',1,'Sale Id shift 8',0.00,534229.85,210.00,521805.90,-12423.95,'2022-08-15 13:58:01'),(6,'8','213',1,'Sale Id shift 9',0.00,492352.15,210.00,480902.10,-11450.05,'2022-08-16 10:44:33'),(7,'8','213',1,'Sale Id shift 10',0.00,809971.65,207.00,779833.17,-30138.48,'2022-08-20 21:48:02'),(8,'8','213',1,'Sale Id shift 11',0.00,1189220.90,207.00,1144970.82,-44250.08,'2022-08-21 09:19:36'),(9,'8','213',1,'Sale Id shift 14',0.00,489142.00,0.00,0.00,-489142.00,'2022-08-24 15:51:27'),(10,'8','213',1,'Sale Id shift 15',0.00,719636.00,200.00,719636.00,0.00,'2022-08-24 16:31:38'),(11,'8','213',1,'Sale Id shift 16',0.00,495114.00,200.00,495114.00,0.00,'2022-08-24 16:50:57'),(12,'8','213',1,'Sale Id shift 17',0.00,580674.00,200.00,580674.00,0.00,'2022-08-24 17:00:25'),(13,'8','213',1,'Sale Id shift 18',0.00,647766.00,200.00,647766.00,0.00,'2022-08-24 17:08:12'),(14,'8','213',1,'Sale Id shift 19',0.00,1522162.00,195.00,1484107.95,-38054.05,'2022-08-25 14:49:29'),(15,'8','213',1,'Sale Id shift 20',0.00,820998.00,195.00,800473.05,-20524.95,'2022-08-25 23:18:48'),(16,'8','213',1,'Sale Id shift 21',0.00,777292.00,195.00,757859.70,-19432.30,'2022-08-27 07:39:32'),(17,'8','213',1,'Sale Id shift 22',0.00,779320.00,195.00,759837.00,-19483.00,'2022-08-28 09:11:11'),(18,'8','213',1,'Sale Id shift 23',0.00,680058.00,195.00,663056.55,-17001.45,'2022-08-29 07:41:29'),(19,'8','213',1,'Sale Id shift 24',0.00,707888.00,195.00,690190.80,-17697.20,'2022-08-30 08:25:29'),(20,'8','213',1,'Sale Id shift 25',0.00,797020.00,195.00,777094.50,-19925.50,'2022-08-30 21:22:13'),(21,'8','213',1,'Sale Id shift 27',0.00,1213274.40,195.00,1213274.40,0.00,'2022-09-01 17:52:32'),(22,'8','213',1,'Sale Id shift 28',0.00,909971.40,195.00,909971.40,0.00,'2022-09-01 20:51:34'),(23,'8','213',1,'Sale Id shift 29',0.00,829964.85,195.00,829964.85,0.00,'2022-09-02 21:58:09'),(24,'8','213',1,'Sale Id shift 30',0.00,746485.35,195.00,746485.35,0.00,'2022-09-03 19:25:54'),(25,'8','213',1,'Sale Id shift 31',0.00,856354.20,195.00,856354.20,0.00,'2022-09-04 19:14:42'),(26,'8','213',1,'Sale Id shift 32',0.00,940290.00,195.00,940290.00,0.00,'2022-09-05 22:34:24'),(27,'8','213',1,'Sale Id shift 33',0.00,991649.10,195.00,991649.10,0.00,'2022-09-06 21:14:04'),(28,'8','213',1,'Sale Id shift 34',0.00,1145841.45,195.00,1145841.45,0.00,'2022-09-07 20:59:40'),(29,'8','213',1,'Sale Id shift 35',0.00,1054836.90,195.00,1054836.90,0.00,'2022-09-08 22:08:53'),(30,'8','213',1,'Sale Id shift 36',0.00,759698.55,195.00,759698.55,0.00,'2022-09-09 19:57:52'),(31,'8','213',1,'Sale Id shift 37',0.00,772987.80,195.00,772987.80,0.00,'2022-09-10 21:11:26'),(32,'8','213',1,'Sale Id shift 38',0.00,880590.75,195.00,880590.75,0.00,'2022-09-14 11:49:39'),(33,'8','213',1,'Sale Id shift 39',0.00,1233717.50,195.00,1266183.75,32466.25,'2022-09-14 20:51:10'),(34,'8','213',1,'Sale Id shift 40',0.00,952720.80,190.00,952720.80,0.00,'2022-09-15 20:56:29'),(35,'8','213',1,'Sale Id shift 41',0.00,1015068.60,190.00,989041.20,-26027.40,'2022-09-17 08:45:07'),(36,'8','213',1,'Sale Id shift 42',0.00,979691.70,190.00,954571.40,-25120.30,'2022-09-18 09:10:21'),(37,'8','213',1,'Sale Id shift 43',0.00,900299.40,190.00,877214.80,-23084.60,'2022-09-18 22:23:34'),(38,'8','213',1,'Sale Id shift 44',0.00,927486.30,190.00,903704.60,-23781.70,'2022-09-19 21:02:23'),(39,'8','213',1,'Sale Id shift 45',0.00,1221456.60,190.00,1190137.20,-31319.40,'2022-09-20 20:22:23'),(40,'8','213',1,'Sale Id shift 46',0.00,1323511.80,190.00,1289575.60,-33936.20,'2022-09-21 20:48:41'),(41,'8','213',1,'Sale Id shift 47',0.00,822194.10,190.00,801112.20,-21081.90,'2022-09-22 15:03:34'),(42,'8','213',1,'Sale Id shift 48',0.00,1128983.80,190.00,1128983.80,0.00,'2022-09-25 19:12:07'),(43,'8','213',1,'Sale Id shift 49',0.00,1046814.50,190.00,1046814.50,0.00,'2022-09-26 19:34:28'),(44,'8','213',1,'Sale Id shift 50',0.00,1350160.90,190.00,1350160.90,0.00,'2022-09-27 19:44:41'),(45,'8','213',1,'Sale Id shift 51',0.00,1617190.70,190.00,1617190.70,0.00,'2022-09-28 19:39:04'),(46,'8','213',1,'Sale Id shift 52',0.00,1034918.60,190.00,1034918.60,0.00,'2022-09-29 20:56:41'),(47,'8','213',1,'Sale Id shift 53',0.00,643936.60,190.00,643936.60,0.00,'2022-09-30 20:28:29'),(48,'8','213',1,'Sale Id shift 54',0.00,1176219.70,190.00,1176219.70,0.00,'2022-10-01 21:28:48'),(49,'8','213',1,'Sale Id shift 55',0.00,950427.50,190.00,950427.50,0.00,'2022-10-02 20:43:39'),(50,'8','213',1,'Sale Id shift 56',0.00,585589.50,190.00,585589.50,0.00,'2022-10-03 21:50:03'),(51,'8','213',1,'Sale Id shift 57',0.00,2782537.24,203.00,2782537.24,0.00,'2022-10-11 16:31:59'),(52,'8','213',1,'Sale Id shift 58',0.00,3049354.35,207.00,3109440.15,60085.80,'2022-10-12 16:24:40'),(53,'8','213',1,'Sale Id shift 59',0.00,2595661.20,220.00,2595661.20,0.00,'2022-10-13 09:42:56'),(54,'8','213',1,'Sale Id shift 60',0.00,2227689.20,220.00,2227689.20,0.00,'2022-10-14 07:22:17'),(55,'8','213',1,'Sale Id shift 61',0.00,2144592.45,253.00,2144592.45,0.00,'2022-11-10 14:52:29'),(56,'8','213',1,'Sale Id shift 62',0.00,1866811.10,253.00,1866811.10,0.00,'2022-11-11 15:18:19'),(57,'8','213',1,'Sale Id shift 63',0.00,1661018.37,253.00,1661018.37,0.00,'2022-11-12 15:03:04'),(58,'8','213',1,'Sale Id shift 64',0.00,1512183.53,253.00,1512183.53,0.00,'2022-11-13 07:17:51'),(59,'8','213',1,'Sale Id shift 65',0.00,1243457.05,253.00,1243457.05,0.00,'2022-11-14 10:55:22'),(60,'8','213',1,'Sale Id shift 66',0.00,1493030.10,255.00,1493030.10,0.00,'2022-11-14 19:07:35'),(61,'8','213',1,'Sale Id shift 67',0.00,1833393.90,255.00,1833393.90,0.00,'2022-11-15 20:51:49'),(62,'8','213',1,'Sale Id shift 68',0.00,939057.90,255.00,939057.90,0.00,'2022-11-16 22:12:34'),(63,'8','213',1,'Sale Id shift 69',0.00,1538544.80,260.00,1538544.80,0.00,'2022-11-24 20:08:23'),(64,'8','213',1,'Sale Id shift 70',0.00,1164077.20,260.00,1164077.20,0.00,'2022-11-25 18:58:29'),(65,'8','213',1,'Sale Id shift 71',0.00,1083823.00,260.00,1083823.00,0.00,'2022-11-26 18:53:32'),(66,'8','213',1,'Sale Id shift 72',0.00,1164360.60,260.00,1164360.60,0.00,'2022-11-27 19:15:02'),(67,'8','213',1,'Sale Id shift 73',0.00,1080617.20,260.00,1080617.20,0.00,'2022-11-28 19:00:02'),(68,'8','213',1,'Sale Id shift 74',0.00,1276662.40,260.00,1276662.40,0.00,'2022-11-29 19:35:20'),(69,'8','213',1,'Sale Id shift 75',0.00,2374886.80,260.00,2374886.80,0.00,'2022-11-30 19:47:24'),(70,'8','213',1,'Sale Id shift 76',0.00,1710378.80,260.00,1710378.80,0.00,'2022-12-01 19:03:28'),(71,'8','213',1,'Sale Id shift 77',0.00,1299030.20,260.00,1299030.20,0.00,'2022-12-02 14:02:19'),(72,'8','213',1,'Sale Id shift 78',0.00,1080565.20,312.00,1080565.20,0.00,'2022-12-18 08:03:42'),(73,'8','213',1,'Sale Id shift 79',0.00,1088518.08,312.00,1088518.08,0.00,'2022-12-18 19:31:05'),(74,'8','213',1,'Sale Id shift 80',0.00,1141960.56,312.00,1141960.56,0.00,'2022-12-20 07:22:16'),(75,'8','213',1,'Sale Id shift 81',0.00,1372756.32,312.00,1372756.32,0.00,'2022-12-21 09:15:59'),(76,'8','213',1,'Sale Id shift 82',0.00,1724214.96,312.00,1724214.96,0.00,'2022-12-22 08:30:47'),(77,'8','213',1,'Sale Id shift 83',0.00,1056241.68,312.00,1056241.68,0.00,'2022-12-23 07:56:46'),(78,'8','213',1,'Sale Id shift 84',0.00,973374.48,312.00,973374.48,0.00,'2022-12-24 06:05:32'),(79,'8','213',1,'Sale Id shift 85',0.00,1117215.84,312.00,1117215.84,0.00,'2022-12-25 08:16:22'),(80,'8','213',1,'Sale Id shift 86',0.00,738861.00,300.00,738861.00,0.00,'2022-12-26 07:31:37'),(81,'8','213',1,'Sale Id shift 87',0.00,936651.00,300.00,936651.00,0.00,'2022-12-26 19:06:24'),(82,'8','213',1,'Sale Id shift 88',0.00,1235781.00,300.00,1235781.00,0.00,'2022-12-27 19:15:37'),(83,'8','213',1,'Sale Id shift 89',0.00,1410156.00,300.00,1410156.00,0.00,'2022-12-28 17:38:27'),(84,'8','213',1,'Sale Id shift 90',0.00,1087625.50,298.00,1087625.50,0.00,'2023-01-02 20:34:32'),(85,'8','213',1,'Sale Id shift 91',0.00,941471.40,298.00,941471.40,0.00,'2023-01-03 21:12:51'),(86,'8','213',1,'Sale Id shift 92',0.00,1415622.18,298.00,1415622.18,0.00,'2023-01-04 20:30:28'),(87,'8','213',1,'Sale Id shift 93',0.00,1203455.12,298.00,1203455.12,0.00,'2023-01-05 20:00:10'),(88,'8','213',1,'Sale Id shift 94',0.00,1339614.30,298.00,1339614.30,0.00,'2023-01-06 19:09:00'),(89,'8','213',1,'Sale Id shift 95',0.00,1115858.02,298.00,1115858.02,0.00,'2023-01-07 19:19:00'),(90,'8','213',1,'Sale Id shift 96',0.00,1115503.40,298.00,1115503.40,0.00,'2023-01-08 22:39:45'),(91,'8','213',1,'Sale Id shift 97',0.00,1636407.40,298.00,1636407.40,0.00,'2023-01-10 07:57:01'),(92,'8','213',1,'Sale Id shift 98',0.00,1480517.64,298.00,1480517.64,0.00,'2023-01-11 07:22:03'),(93,'8','213',1,'Sale Id shift 99',0.00,1893909.20,298.00,1893909.20,0.00,'2023-01-12 07:53:32'),(94,'8','213',1,'Sale Id shift 100',0.00,732105.54,298.00,732105.54,0.00,'2023-01-13 08:24:21'),(95,'8','213',1,'Sale Id shift 101',0.00,613778.68,298.00,613778.68,0.00,'2023-01-13 09:17:48'),(96,'8','213',1,'Sale Id shift 102',0.00,2174141.70,345.00,2174141.70,0.00,'2023-02-02 07:56:55'),(97,'8','213',1,'Sale Id shift 103',0.00,1297658.85,345.00,1297658.85,0.00,'2023-02-03 07:54:50'),(98,'8','213',1,'Sale Id shift 104',0.00,1486380.75,345.00,1486380.75,0.00,'2023-02-03 21:50:43'),(99,'8','213',1,'Sale Id shift 105',0.00,1342381.20,345.00,1342381.20,0.00,'2023-02-05 07:24:07'),(100,'8','213',1,'Sale Id shift 106',0.00,1589366.70,345.00,1589366.70,0.00,'2023-02-05 19:42:59'),(101,'8','213',1,'Sale Id shift 107',0.00,2254609.50,345.00,2254609.50,0.00,'2023-02-07 07:27:53'),(102,'8','213',1,'Sale Id shift 108',0.00,2544630.30,345.00,2544630.30,0.00,'2023-02-08 09:52:00'),(103,'8','213',1,'Sale Id shift 109',0.00,2663544.90,345.00,2663544.90,0.00,'2023-02-09 07:42:49'),(104,'8','213',1,'Sale Id shift 110',0.00,2675830.35,345.00,2675830.35,0.00,'2023-02-10 20:23:50'),(105,'8','213',1,'Sale Id shift 111',0.00,1784467.65,345.00,1784467.65,0.00,'2023-02-11 20:55:51'),(106,'8','213',1,'Sale Id shift 112',0.00,2218653.60,345.00,2218653.60,0.00,'2023-02-12 10:32:58'),(107,'8','213',1,'Sale Id shift 113',0.00,1069700.10,345.00,1069700.10,0.00,'2023-02-12 10:42:16'),(108,'8','213',1,'Sale Id shift 114',0.00,1152127.40,340.00,1152127.40,0.00,'2023-02-18 17:05:09'),(109,'8','213',1,'Sale Id shift 115',0.00,1129048.20,340.00,1129048.20,0.00,'2023-02-19 17:13:43'),(110,'8','213',1,'Sale Id shift 116',0.00,1261563.20,340.00,1261563.20,0.00,'2023-02-20 13:02:51'),(111,'8','213',1,'Sale Id shift 117',0.00,1359116.00,340.00,1359116.00,0.00,'2023-02-21 10:05:40'),(112,'8','213',1,'Sale Id shift 118',0.00,1002585.20,340.00,1002585.20,0.00,'2023-02-22 17:24:07'),(113,'8','213',1,'Sale Id shift 119',0.00,1494555.00,340.00,1494555.00,0.00,'2023-02-23 14:47:03'),(114,'8','213',1,'Sale Id shift 120',0.00,1350697.60,340.00,1350697.60,0.00,'2023-02-26 21:10:07'),(115,'8','213',1,'Sale Id shift 121',0.00,1894966.40,320.00,1894966.40,0.00,'2023-02-26 21:19:20'),(116,'8','213',1,'Sale Id shift 122',0.00,2331148.80,320.00,2331148.80,0.00,'2023-02-26 21:48:44'),(117,'8','213',1,'Sale Id shift 123',0.00,1740489.60,320.00,1740489.60,0.00,'2023-02-28 07:53:28'),(118,'8','213',1,'Sale Id shift 124',0.00,1424915.20,320.00,1424915.20,0.00,'2023-03-01 19:12:11'),(119,'8','213',1,'Sale Id shift 126',0.00,2131543.15,295.00,2131543.15,0.00,'2023-03-15 17:19:12'),(120,'8','213',1,'Sale Id shift 127',0.00,2194611.20,295.00,2194611.20,0.00,'2023-03-15 17:26:06'),(121,'8','213',1,'Sale Id shift 128',0.00,1957283.70,295.00,1957283.70,0.00,'2023-03-15 17:36:37'),(122,'8','213',1,'Sale Id shift 129',0.00,1548245.55,295.00,1548245.55,0.00,'2023-03-15 17:43:48'),(123,'8','213',1,'Sale Id shift 130',0.00,2358749.20,295.00,2358749.20,0.00,'2023-03-15 17:47:42'),(124,'8','213',1,'Sale Id shift 131',0.00,1028809.55,295.00,1028809.55,0.00,'2023-03-15 21:52:47');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=541 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('8','213',1,'','24','4',0.00,6622000.00,'Purchase Id 1 for 30,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-10 18:37:14','',''),('8','213',2,'','supplier','1',6622000.00,0.00,'Purchase Id 1 for 30,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-10 18:37:14','',''),('8','213',3,'','20','6',0.00,0.00,'Sales from shift 1 on 2022-08-12 15:54:59 ','2022-08-12 15:54:59','',''),('8','213',4,'','6.1','7',0.00,0.00,'Sales from shift 1 on 2022-08-12 15:54:59 ','2022-08-12 15:54:59','',''),('8','213',5,'','20','6',0.00,0.00,'Sales from shift 2 on 2022-08-13 11:20:59 ','2022-08-13 11:20:59','',''),('8','213',6,'','6.1','7',0.00,0.00,'Sales from shift 2 on 2022-08-13 11:20:59 ','2022-08-13 11:20:59','',''),('8','213',7,'','20','6',0.00,0.00,'Sales from shift 3 on 2022-08-13 11:30:06 ','2022-08-13 11:30:06','',''),('8','213',8,'','6.1','7',0.00,0.00,'Sales from shift 3 on 2022-08-13 11:30:06 ','2022-08-13 11:30:06','',''),('8','213',9,'','20','6',778166.70,0.00,'Sales from shift 5 on 2022-08-14 10:09:49 ','2022-08-14 10:09:49','',''),('8','213',10,'','6.1','7',0.00,778166.70,'Sales from shift 5 on 2022-08-14 10:09:49 ','2022-08-14 10:09:49','',''),('8','213',11,'','20','6',796860.95,0.00,'Sales from shift 6 on 2022-08-14 10:41:16 ','2022-08-14 10:41:16','',''),('8','213',12,'','6.1','7',0.00,796860.95,'Sales from shift 6 on 2022-08-14 10:41:16 ','2022-08-14 10:41:16','',''),('8','213',13,'','20','6',568131.90,0.00,'Sales from shift 7 on 2022-08-14 10:45:29 ','2022-08-14 10:45:29','',''),('8','213',14,'','6.1','7',0.00,568131.90,'Sales from shift 7 on 2022-08-14 10:45:29 ','2022-08-14 10:45:29','',''),('8','213',15,'','20','6',521805.90,0.00,'Sales from shift 8 on 2022-08-15 13:58:01 ','2022-08-15 13:58:01','',''),('8','213',16,'','6.1','7',0.00,521805.90,'Sales from shift 8 on 2022-08-15 13:58:01 ','2022-08-15 13:58:01','',''),('8','213',17,'','2','2',774950.00,0.00,'Payment Id 1 for invoice:02, receipt:  by Lausu Energy Resources','2022-08-15 20:00:15','',''),('8','213',18,'','supplier','1',0.00,774950.00,'Payment Id 1 for invoice:02, receipt:  by Lausu Energy Resources','2022-08-15 20:00:15','',''),('8','213',19,'','2','2',861265.00,0.00,'Payment Id 2 for invoice:01, receipt:  by Lausu Energy Resources','2022-08-15 20:00:56','',''),('8','213',20,'','supplier','1',0.00,861265.00,'Payment Id 2 for invoice:01, receipt:  by Lausu Energy Resources','2022-08-15 20:00:56','',''),('8','213',21,'','20','6',480902.10,0.00,'Sales from shift 9 on 2022-08-16 10:44:33 ','2022-08-16 10:44:33','',''),('8','213',22,'','6.1','7',0.00,480902.10,'Sales from shift 9 on 2022-08-16 10:44:33 ','2022-08-16 10:44:33','',''),('8','213',23,'','20','6',779833.17,0.00,'Sales from shift 10 on 2022-08-20 21:48:02 ','2022-08-20 21:48:02','',''),('8','213',24,'','6.1','7',0.00,779833.17,'Sales from shift 10 on 2022-08-20 21:48:02 ','2022-08-20 21:48:02','',''),('8','213',25,'','20','6',1144970.82,0.00,'Sales from shift 11 on 2022-08-21 09:19:36 ','2022-08-21 09:19:36','',''),('8','213',26,'','6.1','7',0.00,1144970.82,'Sales from shift 11 on 2022-08-21 09:19:36 ','2022-08-21 09:19:36','',''),('8','213',27,'','20','6',0.00,0.00,'Sales from shift 12 on 2022-08-21 12:43:30 ','2022-08-21 12:43:30','',''),('8','213',28,'','6.1','7',0.00,0.00,'Sales from shift 12 on 2022-08-21 12:43:30 ','2022-08-21 12:43:30','',''),('8','213',29,'','24','4',0.00,9940000.00,'Purchase Id 2 for 49,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-22 12:38:41','',''),('8','213',30,'','supplier','1',9940000.00,0.00,'Purchase Id 2 for 49,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-22 12:38:41','',''),('8','213',31,'','2','2',568130.00,0.00,'Payment Id 5 for invoice:5, receipt: 005 by Lausu Energy Resources','2022-08-22 13:39:40','',''),('8','213',32,'','supplier','1',0.00,568130.00,'Payment Id 5 for invoice:5, receipt: 005 by Lausu Energy Resources','2022-08-22 13:39:40','',''),('8','213',33,'','2','2',480900.00,0.00,'Payment Id 4 for invoice:4, receipt: 4 by Lausu Energy Resources','2022-08-22 13:40:18','',''),('8','213',34,'','supplier','1',0.00,480900.00,'Payment Id 4 for invoice:4, receipt: 4 by Lausu Energy Resources','2022-08-22 13:40:18','',''),('8','213',35,'','2','2',796860.00,0.00,'Payment Id 3 for invoice:03, receipt: 03 by Lausu Energy Resources','2022-08-22 13:40:51','',''),('8','213',36,'','supplier','1',0.00,796860.00,'Payment Id 3 for invoice:03, receipt: 03 by Lausu Energy Resources','2022-08-22 13:40:51','',''),('8','213',37,'','20','6',0.00,0.00,'Sales from shift 13 on 2022-08-22 16:01:35 ','2022-08-22 16:01:35','',''),('8','213',38,'','6.1','7',0.00,0.00,'Sales from shift 13 on 2022-08-22 16:01:35 ','2022-08-22 16:01:35','',''),('8','213',39,'','2','2',522860.00,0.00,'Payment Id 6 for invoice:05, receipt: 006 by Lausu Energy Resources','2022-08-24 00:30:27','',''),('8','213',40,'','supplier','1',0.00,522860.00,'Payment Id 6 for invoice:05, receipt: 006 by Lausu Energy Resources','2022-08-24 00:30:27','',''),('8','213',41,'','2','2',480900.00,0.00,'Payment Id 7 for invoice:6, receipt: 006 by Lausu Energy Resources','2022-08-24 00:30:57','',''),('8','213',42,'','supplier','1',0.00,480900.00,'Payment Id 7 for invoice:6, receipt: 006 by Lausu Energy Resources','2022-08-24 00:30:57','',''),('8','213',43,'','2','2',1144765.00,0.00,'Payment Id 9 for invoice:8, receipt: 8 by Lausu Energy Resources','2022-08-24 00:31:40','',''),('8','213',44,'','supplier','1',0.00,1144765.00,'Payment Id 9 for invoice:8, receipt: 8 by Lausu Energy Resources','2022-08-24 00:31:40','',''),('8','213',45,'','2','2',506470.00,0.00,'Payment Id 10 for invoice:9, receipt: 9 by Lausu Energy Resources','2022-08-24 00:32:15','',''),('8','213',46,'','supplier','1',0.00,506470.00,'Payment Id 10 for invoice:9, receipt: 9 by Lausu Energy Resources','2022-08-24 00:32:15','',''),('8','213',47,'','2','2',719640.00,0.00,'Payment Id 11 for invoice:10, receipt: 10 by Lausu Energy Resources','2022-08-24 00:34:10','',''),('8','213',48,'','supplier','1',0.00,719640.00,'Payment Id 11 for invoice:10, receipt: 10 by Lausu Energy Resources','2022-08-24 00:34:10','',''),('8','213',49,'','2','2',495115.00,0.00,'Payment Id 12 for invoice:11, receipt: 11 by Lausu Energy Resources','2022-08-24 00:37:55','',''),('8','213',50,'','supplier','1',0.00,495115.00,'Payment Id 12 for invoice:11, receipt: 11 by Lausu Energy Resources','2022-08-24 00:37:55','',''),('8','213',51,'','20','6',0.00,0.00,'Sales from shift 14 on 2022-08-24 15:51:27 ','2022-08-24 15:51:27','',''),('8','213',52,'','6.1','7',0.00,0.00,'Sales from shift 14 on 2022-08-24 15:51:27 ','2022-08-24 15:51:27','',''),('8','213',53,'','20','6',719636.00,0.00,'Sales from shift 15 on 2022-08-24 16:31:38 ','2022-08-24 16:31:38','',''),('8','213',54,'','6.1','7',0.00,719636.00,'Sales from shift 15 on 2022-08-24 16:31:38 ','2022-08-24 16:31:38','',''),('8','213',55,'','20','6',495114.00,0.00,'Sales from shift 16 on 2022-08-24 16:50:57 ','2022-08-24 16:50:57','',''),('8','213',56,'','6.1','7',0.00,495114.00,'Sales from shift 16 on 2022-08-24 16:50:57 ','2022-08-24 16:50:57','',''),('8','213',57,'','20','6',580674.00,0.00,'Sales from shift 17 on 2022-08-24 17:00:25 ','2022-08-24 17:00:25','',''),('8','213',58,'','6.1','7',0.00,580674.00,'Sales from shift 17 on 2022-08-24 17:00:25 ','2022-08-24 17:00:25','',''),('8','213',59,'','20','6',647766.00,0.00,'Sales from shift 18 on 2022-08-24 17:08:12 ','2022-08-24 17:08:12','',''),('8','213',60,'','6.1','7',0.00,647766.00,'Sales from shift 18 on 2022-08-24 17:08:12 ','2022-08-24 17:08:12','',''),('8','213',61,'','20','6',1484107.95,0.00,'Sales from shift 19 on 2022-08-25 14:49:29 ','2022-08-25 14:49:29','',''),('8','213',62,'','6.1','7',0.00,1484107.95,'Sales from shift 19 on 2022-08-25 14:49:29 ','2022-08-25 14:49:29','',''),('8','213',63,'','2','2',580675.00,0.00,'Payment Id 13 for invoice:22, receipt: 12 by Lausu Energy Resources','2022-08-25 17:43:36','',''),('8','213',64,'','supplier','1',0.00,580675.00,'Payment Id 13 for invoice:22, receipt: 12 by Lausu Energy Resources','2022-08-25 17:43:36','',''),('8','213',65,'','2','2',647765.00,0.00,'Payment Id 14 for invoice:23, receipt: 13 by Lausu Energy Resources','2022-08-25 17:44:25','',''),('8','213',66,'','supplier','1',0.00,647765.00,'Payment Id 14 for invoice:23, receipt: 13 by Lausu Energy Resources','2022-08-25 17:44:25','',''),('8','213',67,'','20','6',800473.05,0.00,'Sales from shift 20 on 2022-08-25 23:18:48 ','2022-08-25 23:18:48','',''),('8','213',68,'','6.1','7',0.00,800473.05,'Sales from shift 20 on 2022-08-25 23:18:48 ','2022-08-25 23:18:48','',''),('8','213',69,'','2','2',1484130.00,0.00,'Payment Id 15 for invoice:14, receipt: 14 by Lausu Energy Resources','2022-08-26 11:59:46','',''),('8','213',70,'','supplier','1',0.00,1484130.00,'Payment Id 15 for invoice:14, receipt: 14 by Lausu Energy Resources','2022-08-26 11:59:46','',''),('8','213',71,'','20','6',757859.70,0.00,'Sales from shift 21 on 2022-08-27 07:39:32 ','2022-08-27 07:39:32','',''),('8','213',72,'','6.1','7',0.00,757859.70,'Sales from shift 21 on 2022-08-27 07:39:32 ','2022-08-27 07:39:32','',''),('8','213',73,'','2','2',800475.00,0.00,'Payment Id 16 for invoice:15, receipt: 15 by Lausu Energy Resources','2022-08-27 08:53:38','',''),('8','213',74,'','supplier','1',0.00,800475.00,'Payment Id 16 for invoice:15, receipt: 15 by Lausu Energy Resources','2022-08-27 08:53:38','',''),('8','213',75,'','20','6',759837.00,0.00,'Sales from shift 22 on 2022-08-28 09:11:11 ','2022-08-28 09:11:11','',''),('8','213',76,'','6.1','7',0.00,759837.00,'Sales from shift 22 on 2022-08-28 09:11:11 ','2022-08-28 09:11:11','',''),('8','213',77,'','20','6',663056.55,0.00,'Sales from shift 23 on 2022-08-29 07:41:29 ','2022-08-29 07:41:29','',''),('8','213',78,'','6.1','7',0.00,663056.55,'Sales from shift 23 on 2022-08-29 07:41:29 ','2022-08-29 07:41:29','',''),('8','213',79,'','2','2',759840.00,0.00,'Payment Id 18 for invoice:27, receipt: 27 by Lausu Energy Resources','2022-08-29 20:23:01','',''),('8','213',80,'','supplier','1',0.00,759840.00,'Payment Id 18 for invoice:27, receipt: 27 by Lausu Energy Resources','2022-08-29 20:23:01','',''),('8','213',81,'','2','2',663060.00,0.00,'Payment Id 19 for invoice:28, receipt: 28 by Lausu Energy Resources','2022-08-29 20:23:16','',''),('8','213',82,'','supplier','1',0.00,663060.00,'Payment Id 19 for invoice:28, receipt: 28 by Lausu Energy Resources','2022-08-29 20:23:16','',''),('8','213',83,'','20','6',690190.80,0.00,'Sales from shift 24 on 2022-08-30 08:25:29 ','2022-08-30 08:25:29','',''),('8','213',84,'','6.1','7',0.00,690190.80,'Sales from shift 24 on 2022-08-30 08:25:29 ','2022-08-30 08:25:29','',''),('8','213',85,'','20','6',777094.50,0.00,'Sales from shift 25 on 2022-08-30 21:22:13 ','2022-08-30 21:22:13','',''),('8','213',86,'','6.1','7',0.00,777094.50,'Sales from shift 25 on 2022-08-30 21:22:13 ','2022-08-30 21:22:13','',''),('8','213',87,'','24','4',0.00,9691500.00,'Purchase Id 3 for 49,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-01 12:08:59','',''),('8','213',88,'','supplier','1',9691500.00,0.00,'Purchase Id 3 for 49,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-01 12:08:59','',''),('8','213',89,'','2','2',690190.00,0.00,'Payment Id 20 for invoice:29, receipt: 29 by Lausu Energy Resources','2022-09-01 12:12:17','',''),('8','213',90,'','supplier','1',0.00,690190.00,'Payment Id 20 for invoice:29, receipt: 29 by Lausu Energy Resources','2022-09-01 12:12:17','',''),('8','213',91,'','2','2',777095.00,0.00,'Payment Id 21 for invoice:25, receipt: 30 by Lausu Energy Resources','2022-09-01 12:12:29','',''),('8','213',92,'','supplier','1',0.00,777095.00,'Payment Id 21 for invoice:25, receipt: 30 by Lausu Energy Resources','2022-09-01 12:12:29','',''),('8','213',93,'','2','2',757860.00,0.00,'Payment Id 17 for invoice:26, receipt: 26 by Lausu Energy Resources','2022-09-01 12:15:32','',''),('8','213',94,'','supplier','1',0.00,757860.00,'Payment Id 17 for invoice:26, receipt: 26 by Lausu Energy Resources','2022-09-01 12:15:32','',''),('8','213',95,'','20','6',0.00,0.00,'Sales from shift 26 on 2022-09-01 14:10:47 ','2022-09-01 14:10:47','',''),('8','213',96,'','6.1','7',0.00,0.00,'Sales from shift 26 on 2022-09-01 14:10:47 ','2022-09-01 14:10:47','',''),('8','213',97,'','20','6',1213274.40,0.00,'Sales from shift 27 on 2022-09-01 17:52:32 ','2022-09-01 17:52:32','',''),('8','213',98,'','6.1','7',0.00,1213274.40,'Sales from shift 27 on 2022-09-01 17:52:32 ','2022-09-01 17:52:32','',''),('8','213',99,'','20','6',909971.40,0.00,'Sales from shift 28 on 2022-09-01 20:51:34 ','2022-09-01 20:51:34','',''),('8','213',100,'','6.1','7',0.00,909971.40,'Sales from shift 28 on 2022-09-01 20:51:34 ','2022-09-01 20:51:34','',''),('8','213',101,'','2','2',1213475.00,0.00,'Payment Id 23 for invoice:27, receipt: 31 by Lausu Energy Resources','2022-09-02 15:04:08','',''),('8','213',102,'','supplier','1',0.00,1213475.00,'Payment Id 23 for invoice:27, receipt: 31 by Lausu Energy Resources','2022-09-02 15:04:08','',''),('8','213',103,'','20','6',829964.85,0.00,'Sales from shift 29 on 2022-09-02 21:58:09 ','2022-09-02 21:58:09','',''),('8','213',104,'','6.1','7',0.00,829964.85,'Sales from shift 29 on 2022-09-02 21:58:09 ','2022-09-02 21:58:09','',''),('8','213',105,'','20','6',746485.35,0.00,'Sales from shift 30 on 2022-09-03 19:25:54 ','2022-09-03 19:25:54','',''),('8','213',106,'','6.1','7',0.00,746485.35,'Sales from shift 30 on 2022-09-03 19:25:54 ','2022-09-03 19:25:54','',''),('8','213',107,'','2','2',909975.00,0.00,'Payment Id 24 for invoice:28, receipt: 001 by Lausu Energy Resources','2022-09-04 19:12:27','',''),('8','213',108,'','supplier','1',0.00,909975.00,'Payment Id 24 for invoice:28, receipt: 001 by Lausu Energy Resources','2022-09-04 19:12:27','',''),('8','213',109,'','20','6',856354.20,0.00,'Sales from shift 31 on 2022-09-04 19:14:42 ','2022-09-04 19:14:42','',''),('8','213',110,'','6.1','7',0.00,856354.20,'Sales from shift 31 on 2022-09-04 19:14:42 ','2022-09-04 19:14:42','',''),('8','213',111,'','20','6',940290.00,0.00,'Sales from shift 32 on 2022-09-05 22:34:24 ','2022-09-05 22:34:24','',''),('8','213',112,'','6.1','7',0.00,940290.00,'Sales from shift 32 on 2022-09-05 22:34:24 ','2022-09-05 22:34:24','',''),('8','213',113,'','2','2',746485.00,0.00,'Payment Id 26 for invoice:30, receipt: 003 by Lausu Energy Resources','2022-09-06 16:22:56','',''),('8','213',114,'','supplier','1',0.00,746485.00,'Payment Id 26 for invoice:30, receipt: 003 by Lausu Energy Resources','2022-09-06 16:22:56','',''),('8','213',115,'','2','2',856355.00,0.00,'Payment Id 27 for invoice:31, receipt: 004 by Lausu Energy Resources','2022-09-06 16:23:23','',''),('8','213',116,'','supplier','1',0.00,856355.00,'Payment Id 27 for invoice:31, receipt: 004 by Lausu Energy Resources','2022-09-06 16:23:23','',''),('8','213',117,'','2','2',940290.00,0.00,'Payment Id 28 for invoice:32, receipt: 005 by Lausu Energy Resources','2022-09-06 16:23:41','',''),('8','213',118,'','supplier','1',0.00,940290.00,'Payment Id 28 for invoice:32, receipt: 005 by Lausu Energy Resources','2022-09-06 16:23:41','',''),('8','213',119,'','2','2',829965.00,0.00,'Payment Id 25 for invoice:29, receipt: 002 by Lausu Energy Resources','2022-09-06 16:25:02','',''),('8','213',120,'','supplier','1',0.00,829965.00,'Payment Id 25 for invoice:29, receipt: 002 by Lausu Energy Resources','2022-09-06 16:25:02','',''),('8','213',121,'','20','6',991649.10,0.00,'Sales from shift 33 on 2022-09-06 21:14:04 ','2022-09-06 21:14:04','',''),('8','213',122,'','6.1','7',0.00,991649.10,'Sales from shift 33 on 2022-09-06 21:14:04 ','2022-09-06 21:14:04','',''),('8','213',123,'','20','6',1145841.45,0.00,'Sales from shift 34 on 2022-09-07 20:59:40 ','2022-09-07 20:59:40','',''),('8','213',124,'','6.1','7',0.00,1145841.45,'Sales from shift 34 on 2022-09-07 20:59:40 ','2022-09-07 20:59:40','',''),('8','213',125,'','2','2',991650.00,0.00,'Payment Id 29 for invoice:33, receipt: 006 by Lausu Energy Resources','2022-09-08 14:07:45','',''),('8','213',126,'','supplier','1',0.00,991650.00,'Payment Id 29 for invoice:33, receipt: 006 by Lausu Energy Resources','2022-09-08 14:07:45','',''),('8','213',127,'','20','6',1054836.90,0.00,'Sales from shift 35 on 2022-09-08 22:08:53 ','2022-09-08 22:08:53','',''),('8','213',128,'','6.1','7',0.00,1054836.90,'Sales from shift 35 on 2022-09-08 22:08:53 ','2022-09-08 22:08:53','',''),('8','213',129,'','2','2',1145840.00,0.00,'Payment Id 30 for invoice:34, receipt: 007 by Lausu Energy Resources','2022-09-09 17:40:37','',''),('8','213',130,'','supplier','1',0.00,1145840.00,'Payment Id 30 for invoice:34, receipt: 007 by Lausu Energy Resources','2022-09-09 17:40:37','',''),('8','213',131,'','2','2',1054840.00,0.00,'Payment Id 31 for invoice:35, receipt: 008 by Lausu Energy Resources','2022-09-09 17:41:09','',''),('8','213',132,'','supplier','1',0.00,1054840.00,'Payment Id 31 for invoice:35, receipt: 008 by Lausu Energy Resources','2022-09-09 17:41:09','',''),('8','213',133,'','20','6',759698.55,0.00,'Sales from shift 36 on 2022-09-09 19:57:52 ','2022-09-09 19:57:52','',''),('8','213',134,'','6.1','7',0.00,759698.55,'Sales from shift 36 on 2022-09-09 19:57:52 ','2022-09-09 19:57:52','',''),('8','213',135,'','20','6',772987.80,0.00,'Sales from shift 37 on 2022-09-10 21:11:26 ','2022-09-10 21:11:26','',''),('8','213',136,'','6.1','7',0.00,772987.80,'Sales from shift 37 on 2022-09-10 21:11:26 ','2022-09-10 21:11:26','',''),('8','213',137,'','2','2',759700.00,0.00,'Payment Id 32 for invoice:36, receipt: 009 by Lausu Energy Resources','2022-09-13 14:54:16','',''),('8','213',138,'','supplier','1',0.00,759700.00,'Payment Id 32 for invoice:36, receipt: 009 by Lausu Energy Resources','2022-09-13 14:54:16','',''),('8','213',139,'','2','2',773000.00,0.00,'Payment Id 33 for invoice:37, receipt: 10 by Lausu Energy Resources','2022-09-13 14:54:30','',''),('8','213',140,'','supplier','1',0.00,773000.00,'Payment Id 33 for invoice:37, receipt: 10 by Lausu Energy Resources','2022-09-13 14:54:30','',''),('8','213',141,'','24','4',0.00,9405000.00,'Purchase Id 4 for 49,500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-14 11:17:43','',''),('8','213',142,'','supplier','1',9405000.00,0.00,'Purchase Id 4 for 49,500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-14 11:17:43','',''),('8','213',143,'','20','6',880590.75,0.00,'Sales from shift 38 on 2022-09-14 11:49:39 ','2022-09-14 11:49:39','',''),('8','213',144,'','6.1','7',0.00,880590.75,'Sales from shift 38 on 2022-09-14 11:49:39 ','2022-09-14 11:49:39','',''),('8','213',145,'','2','2',880590.00,0.00,'Payment Id 34 for invoice:38, receipt: 11 by Lausu Energy Resources','2022-09-14 18:58:31','',''),('8','213',146,'','supplier','1',0.00,880590.00,'Payment Id 34 for invoice:38, receipt: 11 by Lausu Energy Resources','2022-09-14 18:58:31','',''),('8','213',147,'','20','6',1266183.75,0.00,'Sales from shift 39 on 2022-09-14 20:51:10 ','2022-09-14 20:51:10','',''),('8','213',148,'','6.1','7',0.00,1266183.75,'Sales from shift 39 on 2022-09-14 20:51:10 ','2022-09-14 20:51:10','',''),('8','213',149,'','20','6',952720.80,0.00,'Sales from shift 40 on 2022-09-15 20:56:29 ','2022-09-15 20:56:29','',''),('8','213',150,'','6.1','7',0.00,952720.80,'Sales from shift 40 on 2022-09-15 20:56:29 ','2022-09-15 20:56:29','',''),('8','213',151,'','20','6',989041.20,0.00,'Sales from shift 41 on 2022-09-17 08:45:07 ','2022-09-17 08:45:07','',''),('8','213',152,'','6.1','7',0.00,989041.20,'Sales from shift 41 on 2022-09-17 08:45:07 ','2022-09-17 08:45:07','',''),('8','213',153,'','2','2',1233720.00,0.00,'Payment Id 35 for invoice:39, receipt:  14 by Lausu Energy Resources','2022-09-17 10:22:45','',''),('8','213',154,'','supplier','1',0.00,1233720.00,'Payment Id 35 for invoice:39, receipt:  14 by Lausu Energy Resources','2022-09-17 10:22:45','',''),('8','213',155,'','20','6',954571.40,0.00,'Sales from shift 42 on 2022-09-18 09:10:21 ','2022-09-18 09:10:21','',''),('8','213',156,'','6.1','7',0.00,954571.40,'Sales from shift 42 on 2022-09-18 09:10:21 ','2022-09-18 09:10:21','',''),('8','213',157,'','20','6',877214.80,0.00,'Sales from shift 43 on 2022-09-18 22:23:34 ','2022-09-18 22:23:34','',''),('8','213',158,'','6.1','7',0.00,877214.80,'Sales from shift 43 on 2022-09-18 22:23:34 ','2022-09-18 22:23:34','',''),('8','213',159,'','20','6',903704.60,0.00,'Sales from shift 44 on 2022-09-19 21:02:23 ','2022-09-19 21:02:23','',''),('8','213',160,'','6.1','7',0.00,903704.60,'Sales from shift 44 on 2022-09-19 21:02:23 ','2022-09-19 21:02:23','',''),('8','213',161,'','2','2',952720.00,0.00,'Payment Id 36 for invoice:40, receipt: 15 by Lausu Energy Resources','2022-09-20 13:35:35','',''),('8','213',162,'','supplier','1',0.00,952720.00,'Payment Id 36 for invoice:40, receipt: 15 by Lausu Energy Resources','2022-09-20 13:35:35','',''),('8','213',163,'','2','2',989040.00,0.00,'Payment Id 37 for invoice:41, receipt: 16 by Lausu Energy Resources','2022-09-20 13:37:24','',''),('8','213',164,'','supplier','1',0.00,989040.00,'Payment Id 37 for invoice:41, receipt: 16 by Lausu Energy Resources','2022-09-20 13:37:24','',''),('8','213',165,'','2','2',954570.00,0.00,'Payment Id 38 for invoice:42, receipt: 17 by Lausu Energy Resources','2022-09-20 13:37:36','',''),('8','213',166,'','supplier','1',0.00,954570.00,'Payment Id 38 for invoice:42, receipt: 17 by Lausu Energy Resources','2022-09-20 13:37:36','',''),('8','213',167,'','2','2',877215.00,0.00,'Payment Id 39 for invoice:43, receipt: 18 by Lausu Energy Resources','2022-09-20 13:37:52','',''),('8','213',168,'','supplier','1',0.00,877215.00,'Payment Id 39 for invoice:43, receipt: 18 by Lausu Energy Resources','2022-09-20 13:37:52','',''),('8','213',169,'','20','6',1190137.20,0.00,'Sales from shift 45 on 2022-09-20 20:22:23 ','2022-09-20 20:22:23','',''),('8','213',170,'','6.1','7',0.00,1190137.20,'Sales from shift 45 on 2022-09-20 20:22:23 ','2022-09-20 20:22:23','',''),('8','213',171,'','2','2',903705.00,0.00,'Payment Id 40 for invoice:44, receipt: 19 by Lausu Energy Resources','2022-09-21 13:39:08','',''),('8','213',172,'','supplier','1',0.00,903705.00,'Payment Id 40 for invoice:44, receipt: 19 by Lausu Energy Resources','2022-09-21 13:39:08','',''),('8','213',173,'','20','6',1289575.60,0.00,'Sales from shift 46 on 2022-09-21 20:48:41 ','2022-09-21 20:48:41','',''),('8','213',174,'','6.1','7',0.00,1289575.60,'Sales from shift 46 on 2022-09-21 20:48:41 ','2022-09-21 20:48:41','',''),('8','213',175,'','20','6',801112.20,0.00,'Sales from shift 47 on 2022-09-22 15:03:34 ','2022-09-22 15:03:34','',''),('8','213',176,'','6.1','7',0.00,801112.20,'Sales from shift 47 on 2022-09-22 15:03:34 ','2022-09-22 15:03:34','',''),('8','213',177,'','2','2',1190140.00,0.00,'Payment Id 41 for invoice:45, receipt: 20 by Lausu Energy Resources','2022-09-23 14:08:55','',''),('8','213',178,'','supplier','1',0.00,1190140.00,'Payment Id 41 for invoice:45, receipt: 20 by Lausu Energy Resources','2022-09-23 14:08:55','',''),('8','213',179,'','2','2',1289575.00,0.00,'Payment Id 42 for invoice:46, receipt: 21 by Lausu Energy Resources','2022-09-23 14:09:13','',''),('8','213',180,'','supplier','1',0.00,1289575.00,'Payment Id 42 for invoice:46, receipt: 21 by Lausu Energy Resources','2022-09-23 14:09:13','',''),('8','213',181,'','24','4',0.00,9500000.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-25 10:45:06','',''),('8','213',182,'','supplier','1',9500000.00,0.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-25 10:45:06','',''),('8','213',183,'','20','6',1128983.80,0.00,'Sales from shift 48 on 2022-09-25 19:12:07 ','2022-09-25 19:12:07','',''),('8','213',184,'','6.1','7',0.00,1128983.80,'Sales from shift 48 on 2022-09-25 19:12:07 ','2022-09-25 19:12:07','',''),('8','213',185,'','2','2',801115.00,0.00,'Payment Id 43 for invoice:47, receipt: 22 by Lausu Energy Resources','2022-09-26 16:26:30','',''),('8','213',186,'','supplier','1',0.00,801115.00,'Payment Id 43 for invoice:47, receipt: 22 by Lausu Energy Resources','2022-09-26 16:26:30','',''),('8','213',187,'','20','6',1046814.50,0.00,'Sales from shift 49 on 2022-09-26 19:34:28 ','2022-09-26 19:34:28','',''),('8','213',188,'','6.1','7',0.00,1046814.50,'Sales from shift 49 on 2022-09-26 19:34:28 ','2022-09-26 19:34:28','',''),('8','213',189,'','2','2',1128985.00,0.00,'Payment Id 44 for invoice:48, receipt: 25 by Lausu Energy Resources','2022-09-27 16:34:22','',''),('8','213',190,'','supplier','1',0.00,1128985.00,'Payment Id 44 for invoice:48, receipt: 25 by Lausu Energy Resources','2022-09-27 16:34:22','',''),('8','213',191,'','20','6',1350160.90,0.00,'Sales from shift 50 on 2022-09-27 19:44:41 ','2022-09-27 19:44:41','',''),('8','213',192,'','6.1','7',0.00,1350160.90,'Sales from shift 50 on 2022-09-27 19:44:41 ','2022-09-27 19:44:41','',''),('8','213',193,'','2','2',1046815.00,0.00,'Payment Id 45 for invoice:49, receipt: 26 by Lausu Energy Resources','2022-09-28 13:13:34','',''),('8','213',194,'','supplier','1',0.00,1046815.00,'Payment Id 45 for invoice:49, receipt: 26 by Lausu Energy Resources','2022-09-28 13:13:34','',''),('8','213',195,'','20','6',1617190.70,0.00,'Sales from shift 51 on 2022-09-28 19:39:04 ','2022-09-28 19:39:04','',''),('8','213',196,'','6.1','7',0.00,1617190.70,'Sales from shift 51 on 2022-09-28 19:39:04 ','2022-09-28 19:39:04','',''),('8','213',197,'','20','6',1034918.60,0.00,'Sales from shift 52 on 2022-09-29 20:56:41 ','2022-09-29 20:56:41','',''),('8','213',198,'','6.1','7',0.00,1034918.60,'Sales from shift 52 on 2022-09-29 20:56:41 ','2022-09-29 20:56:41','',''),('8','213',199,'','2','2',1350160.00,0.00,'Payment Id 46 for invoice:50, receipt: 27 by Lausu Energy Resources','2022-09-30 12:29:53','',''),('8','213',200,'','supplier','1',0.00,1350160.00,'Payment Id 46 for invoice:50, receipt: 27 by Lausu Energy Resources','2022-09-30 12:29:53','',''),('8','213',201,'','2','2',1617190.00,0.00,'Payment Id 47 for invoice:51, receipt: 28 by Lausu Energy Resources','2022-09-30 12:30:05','',''),('8','213',202,'','supplier','1',0.00,1617190.00,'Payment Id 47 for invoice:51, receipt: 28 by Lausu Energy Resources','2022-09-30 12:30:05','',''),('8','213',203,'','20','6',643936.60,0.00,'Sales from shift 53 on 2022-09-30 20:28:29 ','2022-09-30 20:28:29','',''),('8','213',204,'','6.1','7',0.00,643936.60,'Sales from shift 53 on 2022-09-30 20:28:29 ','2022-09-30 20:28:29','',''),('8','213',205,'','20','6',1176219.70,0.00,'Sales from shift 54 on 2022-10-01 21:28:48 ','2022-10-01 21:28:48','',''),('8','213',206,'','6.1','7',0.00,1176219.70,'Sales from shift 54 on 2022-10-01 21:28:48 ','2022-10-01 21:28:48','',''),('8','213',207,'','20','6',950427.50,0.00,'Sales from shift 55 on 2022-10-02 20:43:39 ','2022-10-02 20:43:39','',''),('8','213',208,'','6.1','7',0.00,950427.50,'Sales from shift 55 on 2022-10-02 20:43:39 ','2022-10-02 20:43:39','',''),('8','213',209,'','2','2',1034920.00,0.00,'Payment Id 48 for invoice:52, receipt: 29 by Lausu Energy Resources','2022-10-03 02:04:05','',''),('8','213',210,'','supplier','1',0.00,1034920.00,'Payment Id 48 for invoice:52, receipt: 29 by Lausu Energy Resources','2022-10-03 02:04:05','',''),('8','213',211,'','20','6',585589.50,0.00,'Sales from shift 56 on 2022-10-03 21:50:03 ','2022-10-03 21:50:03','',''),('8','213',212,'','6.1','7',0.00,585589.50,'Sales from shift 56 on 2022-10-03 21:50:03 ','2022-10-03 21:50:03','',''),('8','213',213,'','2','2',643940.00,0.00,'Payment Id 49 for invoice:53, receipt: 30 by Lausu Energy Resources','2022-10-04 17:31:59','',''),('8','213',214,'','supplier','1',0.00,643940.00,'Payment Id 49 for invoice:53, receipt: 30 by Lausu Energy Resources','2022-10-04 17:31:59','',''),('8','213',215,'','2','2',585590.00,0.00,'Payment Id 52 for invoice:56, receipt: 031022 by Lausu Energy Resources','2022-10-04 18:03:43','',''),('8','213',216,'','supplier','1',0.00,585590.00,'Payment Id 52 for invoice:56, receipt: 031022 by Lausu Energy Resources','2022-10-04 18:03:43','',''),('8','213',217,'','2','2',950430.00,0.00,'Payment Id 51 for invoice:55, receipt: 002 by Lausu Energy Resources','2022-10-05 14:31:29','',''),('8','213',218,'','supplier','1',0.00,950430.00,'Payment Id 51 for invoice:55, receipt: 002 by Lausu Energy Resources','2022-10-05 14:31:29','',''),('8','213',219,'','2','2',1176220.00,0.00,'Payment Id 50 for invoice:54, receipt: 001 by Lausu Energy Resources','2022-10-07 11:07:23','',''),('8','213',220,'','supplier','1',0.00,1176220.00,'Payment Id 50 for invoice:54, receipt: 001 by Lausu Energy Resources','2022-10-07 11:07:23','',''),('8','213',221,'','24','4',0.00,10200750.00,'Purchase Id 6 for 50,250.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-10 14:26:29','',''),('8','213',222,'','supplier','1',10200750.00,0.00,'Purchase Id 6 for 50,250.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-10 14:26:29','',''),('8','213',223,'','20','6',2782537.24,0.00,'Sales from shift 57 on 2022-10-11 16:31:59 ','2022-10-11 16:31:59','',''),('8','213',224,'','6.1','7',0.00,2782537.24,'Sales from shift 57 on 2022-10-11 16:31:59 ','2022-10-11 16:31:59','',''),('8','213',225,'','20','6',3109440.15,0.00,'Sales from shift 58 on 2022-10-12 16:24:40 ','2022-10-12 16:24:40','',''),('8','213',226,'','6.1','7',0.00,3109440.15,'Sales from shift 58 on 2022-10-12 16:24:40 ','2022-10-12 16:24:40','',''),('8','213',227,'','2','2',2782540.00,0.00,'Payment Id 53 for invoice:57, receipt: 001 by Lausu Energy Resources','2022-10-12 16:26:26','',''),('8','213',228,'','supplier','1',0.00,2782540.00,'Payment Id 53 for invoice:57, receipt: 001 by Lausu Energy Resources','2022-10-12 16:26:26','',''),('8','213',229,'','20','6',2595661.20,0.00,'Sales from shift 59 on 2022-10-13 09:42:56 ','2022-10-13 09:42:56','',''),('8','213',230,'','6.1','7',0.00,2595661.20,'Sales from shift 59 on 2022-10-13 09:42:56 ','2022-10-13 09:42:56','',''),('8','213',231,'','20','6',2227689.20,0.00,'Sales from shift 60 on 2022-10-14 07:22:17 ','2022-10-14 07:22:17','',''),('8','213',232,'','6.1','7',0.00,2227689.20,'Sales from shift 60 on 2022-10-14 07:22:17 ','2022-10-14 07:22:17','',''),('8','213',233,'','2','2',3109235.00,0.00,'Payment Id 54 for invoice:58, receipt: 0002 by Lausu Energy Resources','2022-10-14 14:32:03','',''),('8','213',234,'','supplier','1',0.00,3109235.00,'Payment Id 54 for invoice:58, receipt: 0002 by Lausu Energy Resources','2022-10-14 14:32:03','',''),('8','213',235,'','2','2',2227690.00,0.00,'Payment Id 56 for invoice:60, receipt: 004 by Lausu Energy Resources','2022-10-14 14:32:31','',''),('8','213',236,'','supplier','1',0.00,2227690.00,'Payment Id 56 for invoice:60, receipt: 004 by Lausu Energy Resources','2022-10-14 14:32:31','',''),('8','213',237,'','2','2',2595660.00,0.00,'Payment Id 55 for invoice:59, receipt: 003 by Lausu Energy Resources','2022-10-18 11:55:38','',''),('8','213',238,'','supplier','1',0.00,2595660.00,'Payment Id 55 for invoice:59, receipt: 003 by Lausu Energy Resources','2022-10-18 11:55:38','',''),('8','213',239,'','24','4',0.00,12574100.00,'Purchase Id 7 for 49,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-09 13:31:19','',''),('8','213',240,'','supplier','1',12574100.00,0.00,'Purchase Id 7 for 49,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-09 13:31:19','',''),('8','213',241,'','20','6',2144592.45,0.00,'Sales from shift 61 on 2022-11-10 14:52:29 ','2022-11-10 14:52:29','',''),('8','213',242,'','6.1','7',0.00,2144592.45,'Sales from shift 61 on 2022-11-10 14:52:29 ','2022-11-10 14:52:29','',''),('8','213',243,'','2','2',779835.00,0.00,'Payment Id 8 for invoice:16, receipt: 16 by Lausu Energy Resources','2022-11-11 12:14:32','',''),('8','213',244,'','supplier','1',0.00,779835.00,'Payment Id 8 for invoice:16, receipt: 16 by Lausu Energy Resources','2022-11-11 12:14:32','',''),('8','213',245,'','2','2',2144675.00,0.00,'Payment Id 57 for invoice:61, receipt: 0005 by Lausu Energy Resources','2022-11-11 15:08:38','',''),('8','213',246,'','supplier','1',0.00,2144675.00,'Payment Id 57 for invoice:61, receipt: 0005 by Lausu Energy Resources','2022-11-11 15:08:38','',''),('8','213',247,'','20','6',1866811.10,0.00,'Sales from shift 62 on 2022-11-11 15:18:19 ','2022-11-11 15:18:19','',''),('8','213',248,'','6.1','7',0.00,1866811.10,'Sales from shift 62 on 2022-11-11 15:18:19 ','2022-11-11 15:18:19','',''),('8','213',249,'','20','6',1661018.37,0.00,'Sales from shift 63 on 2022-11-12 15:03:04 ','2022-11-12 15:03:04','',''),('8','213',250,'','6.1','7',0.00,1661018.37,'Sales from shift 63 on 2022-11-12 15:03:04 ','2022-11-12 15:03:04','',''),('8','213',251,'','20','6',1512183.53,0.00,'Sales from shift 64 on 2022-11-13 07:17:51 ','2022-11-13 07:17:51','',''),('8','213',252,'','6.1','7',0.00,1512183.53,'Sales from shift 64 on 2022-11-13 07:17:51 ','2022-11-13 07:17:51','',''),('8','213',253,'','20','6',1243457.05,0.00,'Sales from shift 65 on 2022-11-14 10:55:22 ','2022-11-14 10:55:22','',''),('8','213',254,'','6.1','7',0.00,1243457.05,'Sales from shift 65 on 2022-11-14 10:55:22 ','2022-11-14 10:55:22','',''),('8','213',255,'','20','6',1493030.10,0.00,'Sales from shift 66 on 2022-11-14 19:07:34 ','2022-11-14 19:07:34','',''),('8','213',256,'','6.1','7',0.00,1493030.10,'Sales from shift 66 on 2022-11-14 19:07:34 ','2022-11-14 19:07:34','',''),('8','213',257,'','2','2',1512185.00,0.00,'Payment Id 59 for invoice:64, receipt: 0008 by Lausu Energy Resources','2022-11-15 17:13:28','',''),('8','213',258,'','supplier','1',0.00,1512185.00,'Payment Id 59 for invoice:64, receipt: 0008 by Lausu Energy Resources','2022-11-15 17:13:28','',''),('8','213',259,'','2','2',1253350.00,0.00,'Payment Id 60 for invoice:65, receipt: 0009 by Lausu Energy Resources','2022-11-15 17:14:14','',''),('8','213',260,'','supplier','1',0.00,1253350.00,'Payment Id 60 for invoice:65, receipt: 0009 by Lausu Energy Resources','2022-11-15 17:14:14','',''),('8','213',261,'','2','2',1666120.00,0.00,'Payment Id 58 for invoice:63, receipt: 0007 by Lausu Energy Resources','2022-11-15 17:21:36','',''),('8','213',262,'','supplier','1',0.00,1666120.00,'Payment Id 58 for invoice:63, receipt: 0007 by Lausu Energy Resources','2022-11-15 17:21:36','',''),('8','213',263,'','20','6',1833393.90,0.00,'Sales from shift 67 on 2022-11-15 20:51:49 ','2022-11-15 20:51:49','',''),('8','213',264,'','6.1','7',0.00,1833393.90,'Sales from shift 67 on 2022-11-15 20:51:49 ','2022-11-15 20:51:49','',''),('8','213',265,'','20','6',939057.90,0.00,'Sales from shift 68 on 2022-11-16 22:12:34 ','2022-11-16 22:12:34','',''),('8','213',266,'','6.1','7',0.00,939057.90,'Sales from shift 68 on 2022-11-16 22:12:34 ','2022-11-16 22:12:34','',''),('8','213',267,'','2','2',1493285.00,0.00,'Payment Id 61 for invoice:66, receipt: 010 by Lausu Energy Resources','2022-11-17 13:15:10','',''),('8','213',268,'','supplier','1',0.00,1493285.00,'Payment Id 61 for invoice:66, receipt: 010 by Lausu Energy Resources','2022-11-17 13:15:10','',''),('8','213',269,'','2','2',939060.00,0.00,'Payment Id 63 for invoice:68, receipt: 68 by Lausu Energy Resources','2022-11-22 09:30:15','',''),('8','213',270,'','supplier','1',0.00,939060.00,'Payment Id 63 for invoice:68, receipt: 68 by Lausu Energy Resources','2022-11-22 09:30:15','',''),('8','213',271,'','2','2',1833395.00,0.00,'Payment Id 62 for invoice:67, receipt: 011 by Lausu Energy Resources','2022-11-22 09:31:05','',''),('8','213',272,'','supplier','1',0.00,1833395.00,'Payment Id 62 for invoice:67, receipt: 011 by Lausu Energy Resources','2022-11-22 09:31:05','',''),('8','213',273,'','24','4',0.00,12857000.00,'Purchase Id 8 for 49,450.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-24 14:58:07','',''),('8','213',274,'','supplier','1',12857000.00,0.00,'Purchase Id 8 for 49,450.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-24 14:58:07','',''),('8','213',275,'','20','6',1538544.80,0.00,'Sales from shift 69 on 2022-11-24 20:08:23 ','2022-11-24 20:08:23','',''),('8','213',276,'','6.1','7',0.00,1538544.80,'Sales from shift 69 on 2022-11-24 20:08:23 ','2022-11-24 20:08:23','',''),('8','213',277,'','20','6',1164077.20,0.00,'Sales from shift 70 on 2022-11-25 18:58:29 ','2022-11-25 18:58:29','',''),('8','213',278,'','6.1','7',0.00,1164077.20,'Sales from shift 70 on 2022-11-25 18:58:29 ','2022-11-25 18:58:29','',''),('8','213',279,'','20','6',1083823.00,0.00,'Sales from shift 71 on 2022-11-26 18:53:32 ','2022-11-26 18:53:32','',''),('8','213',280,'','6.1','7',0.00,1083823.00,'Sales from shift 71 on 2022-11-26 18:53:32 ','2022-11-26 18:53:32','',''),('8','213',281,'','20','6',1164360.60,0.00,'Sales from shift 72 on 2022-11-27 19:15:02 ','2022-11-27 19:15:02','',''),('8','213',282,'','6.1','7',0.00,1164360.60,'Sales from shift 72 on 2022-11-27 19:15:02 ','2022-11-27 19:15:02','',''),('8','213',283,'','2','2',1083825.00,0.00,'Payment Id 66 for invoice:71, receipt: 71 by Lausu Energy Resources','2022-11-28 16:59:05','',''),('8','213',284,'','supplier','1',0.00,1083825.00,'Payment Id 66 for invoice:71, receipt: 71 by Lausu Energy Resources','2022-11-28 16:59:05','',''),('8','213',285,'','2','2',1164080.00,0.00,'Payment Id 65 for invoice:70, receipt: 70 by Lausu Energy Resources','2022-11-28 16:59:24','',''),('8','213',286,'','supplier','1',0.00,1164080.00,'Payment Id 65 for invoice:70, receipt: 70 by Lausu Energy Resources','2022-11-28 16:59:24','',''),('8','213',287,'','2','2',1538545.00,0.00,'Payment Id 64 for invoice:69, receipt: 69 by Lausu Energy Resources','2022-11-28 17:14:11','',''),('8','213',288,'','supplier','1',0.00,1538545.00,'Payment Id 64 for invoice:69, receipt: 69 by Lausu Energy Resources','2022-11-28 17:14:11','',''),('8','213',289,'','20','6',1080617.20,0.00,'Sales from shift 73 on 2022-11-28 19:00:02 ','2022-11-28 19:00:02','',''),('8','213',290,'','6.1','7',0.00,1080617.20,'Sales from shift 73 on 2022-11-28 19:00:02 ','2022-11-28 19:00:02','',''),('8','213',291,'','20','6',1276662.40,0.00,'Sales from shift 74 on 2022-11-29 19:35:20 ','2022-11-29 19:35:20','',''),('8','213',292,'','6.1','7',0.00,1276662.40,'Sales from shift 74 on 2022-11-29 19:35:20 ','2022-11-29 19:35:20','',''),('8','213',293,'','2','2',1164360.00,0.00,'Payment Id 67 for invoice:72, receipt: 72 by Lausu Energy Resources','2022-11-30 13:36:15','',''),('8','213',294,'','supplier','1',0.00,1164360.00,'Payment Id 67 for invoice:72, receipt: 72 by Lausu Energy Resources','2022-11-30 13:36:15','',''),('8','213',295,'','20','6',2374886.80,0.00,'Sales from shift 75 on 2022-11-30 19:47:24 ','2022-11-30 19:47:24','',''),('8','213',296,'','6.1','7',0.00,2374886.80,'Sales from shift 75 on 2022-11-30 19:47:24 ','2022-11-30 19:47:24','',''),('8','213',297,'','2','2',1080620.00,0.00,'Payment Id 68 for invoice:73, receipt: 73 by Lausu Energy Resources','2022-12-01 11:02:39','',''),('8','213',298,'','supplier','1',0.00,1080620.00,'Payment Id 68 for invoice:73, receipt: 73 by Lausu Energy Resources','2022-12-01 11:02:39','',''),('8','213',299,'','20','6',1710378.80,0.00,'Sales from shift 76 on 2022-12-01 19:03:28 ','2022-12-01 19:03:28','',''),('8','213',300,'','6.1','7',0.00,1710378.80,'Sales from shift 76 on 2022-12-01 19:03:28 ','2022-12-01 19:03:28','',''),('8','213',301,'','20','6',1299030.20,0.00,'Sales from shift 77 on 2022-12-02 14:02:19 ','2022-12-02 14:02:19','',''),('8','213',302,'','6.1','7',0.00,1299030.20,'Sales from shift 77 on 2022-12-02 14:02:19 ','2022-12-02 14:02:19','',''),('8','213',303,'','2','2',1276660.00,0.00,'Payment Id 69 for invoice:74, receipt: 74 by Lausu Energy Resources','2022-12-02 15:19:37','',''),('8','213',304,'','supplier','1',0.00,1276660.00,'Payment Id 69 for invoice:74, receipt: 74 by Lausu Energy Resources','2022-12-02 15:19:37','',''),('8','213',305,'','2','2',2374890.00,0.00,'Payment Id 70 for invoice:75, receipt: 75 by Lausu Energy Resources','2022-12-04 00:55:43','',''),('8','213',306,'','supplier','1',0.00,2374890.00,'Payment Id 70 for invoice:75, receipt: 75 by Lausu Energy Resources','2022-12-04 00:55:43','',''),('8','213',307,'','2','2',1710380.00,0.00,'Payment Id 71 for invoice:76, receipt: 76 by Lausu Energy Resources','2022-12-04 21:59:39','',''),('8','213',308,'','supplier','1',0.00,1710380.00,'Payment Id 71 for invoice:76, receipt: 76 by Lausu Energy Resources','2022-12-04 21:59:39','',''),('8','213',309,'','2','2',1299030.00,0.00,'Payment Id 72 for invoice:77, receipt: 77 by Lausu Energy Resources','2022-12-13 13:47:26','',''),('8','213',310,'','supplier','1',0.00,1299030.00,'Payment Id 72 for invoice:77, receipt: 77 by Lausu Energy Resources','2022-12-13 13:47:26','',''),('8','213',311,'','24','4',0.00,13930800.00,'Purchase Id 9 for 44,650.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-17 15:40:36','',''),('8','213',312,'','supplier','1',13930800.00,0.00,'Purchase Id 9 for 44,650.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-17 15:40:36','',''),('8','213',313,'','20','6',1080565.20,0.00,'Sales from shift 78 on 2022-12-18 08:03:42 ','2022-12-18 08:03:42','',''),('8','213',314,'','6.1','7',0.00,1080565.20,'Sales from shift 78 on 2022-12-18 08:03:42 ','2022-12-18 08:03:42','',''),('8','213',315,'','20','6',1088518.08,0.00,'Sales from shift 79 on 2022-12-18 19:31:05 ','2022-12-18 19:31:05','',''),('8','213',316,'','6.1','7',0.00,1088518.08,'Sales from shift 79 on 2022-12-18 19:31:05 ','2022-12-18 19:31:05','',''),('8','213',317,'','20','6',1141960.56,0.00,'Sales from shift 80 on 2022-12-20 07:22:16 ','2022-12-20 07:22:16','',''),('8','213',318,'','6.1','7',0.00,1141960.56,'Sales from shift 80 on 2022-12-20 07:22:16 ','2022-12-20 07:22:16','',''),('8','213',319,'','2','2',1080565.00,0.00,'Payment Id 73 for invoice:78, receipt: 78 by Lausu Energy Resources','2022-12-20 12:59:22','',''),('8','213',320,'','supplier','1',0.00,1080565.00,'Payment Id 73 for invoice:78, receipt: 78 by Lausu Energy Resources','2022-12-20 12:59:22','',''),('8','213',321,'','20','6',1372756.32,0.00,'Sales from shift 81 on 2022-12-21 09:15:59 ','2022-12-21 09:15:59','',''),('8','213',322,'','6.1','7',0.00,1372756.32,'Sales from shift 81 on 2022-12-21 09:15:59 ','2022-12-21 09:15:59','',''),('8','213',323,'','2','2',1141960.00,0.00,'Payment Id 75 for invoice:80, receipt: 80 by Lausu Energy Resources','2022-12-21 16:23:41','',''),('8','213',324,'','supplier','1',0.00,1141960.00,'Payment Id 75 for invoice:80, receipt: 80 by Lausu Energy Resources','2022-12-21 16:23:41','',''),('8','213',325,'','20','6',1724214.96,0.00,'Sales from shift 82 on 2022-12-22 08:30:46 ','2022-12-22 08:30:46','',''),('8','213',326,'','6.1','7',0.00,1724214.96,'Sales from shift 82 on 2022-12-22 08:30:46 ','2022-12-22 08:30:46','',''),('8','213',327,'','20','6',1056241.68,0.00,'Sales from shift 83 on 2022-12-23 07:56:46 ','2022-12-23 07:56:46','',''),('8','213',328,'','6.1','7',0.00,1056241.68,'Sales from shift 83 on 2022-12-23 07:56:46 ','2022-12-23 07:56:46','',''),('8','213',329,'','20','6',973374.48,0.00,'Sales from shift 84 on 2022-12-24 06:05:32 ','2022-12-24 06:05:32','',''),('8','213',330,'','6.1','7',0.00,973374.48,'Sales from shift 84 on 2022-12-24 06:05:32 ','2022-12-24 06:05:32','',''),('8','213',331,'','2','2',1372750.00,0.00,'Payment Id 76 for invoice:81, receipt: 81 by Lausu Energy Resources','2022-12-25 03:43:46','',''),('8','213',332,'','supplier','1',0.00,1372750.00,'Payment Id 76 for invoice:81, receipt: 81 by Lausu Energy Resources','2022-12-25 03:43:46','',''),('8','213',333,'','2','2',1724215.00,0.00,'Payment Id 77 for invoice:82, receipt: 82 by Lausu Energy Resources','2022-12-25 03:44:10','',''),('8','213',334,'','supplier','1',0.00,1724215.00,'Payment Id 77 for invoice:82, receipt: 82 by Lausu Energy Resources','2022-12-25 03:44:10','',''),('8','213',335,'','20','6',1117215.84,0.00,'Sales from shift 85 on 2022-12-25 08:16:22 ','2022-12-25 08:16:22','',''),('8','213',336,'','6.1','7',0.00,1117215.84,'Sales from shift 85 on 2022-12-25 08:16:22 ','2022-12-25 08:16:22','',''),('8','213',337,'','20','6',738861.00,0.00,'Sales from shift 86 on 2022-12-26 07:31:37 ','2022-12-26 07:31:37','',''),('8','213',338,'','6.1','7',0.00,738861.00,'Sales from shift 86 on 2022-12-26 07:31:37 ','2022-12-26 07:31:37','',''),('8','213',339,'','20','6',936651.00,0.00,'Sales from shift 87 on 2022-12-26 19:06:24 ','2022-12-26 19:06:24','',''),('8','213',340,'','6.1','7',0.00,936651.00,'Sales from shift 87 on 2022-12-26 19:06:24 ','2022-12-26 19:06:24','',''),('8','213',341,'','2','2',1056240.00,0.00,'Payment Id 78 for invoice:83, receipt: 83 by Lausu Energy Resources','2022-12-27 09:44:22','',''),('8','213',342,'','supplier','1',0.00,1056240.00,'Payment Id 78 for invoice:83, receipt: 83 by Lausu Energy Resources','2022-12-27 09:44:22','',''),('8','213',343,'','20','6',1235781.00,0.00,'Sales from shift 88 on 2022-12-27 19:15:37 ','2022-12-27 19:15:37','',''),('8','213',344,'','6.1','7',0.00,1235781.00,'Sales from shift 88 on 2022-12-27 19:15:37 ','2022-12-27 19:15:37','',''),('8','213',345,'','20','6',1410156.00,0.00,'Sales from shift 89 on 2022-12-28 17:38:27 ','2022-12-28 17:38:27','',''),('8','213',346,'','6.1','7',0.00,1410156.00,'Sales from shift 89 on 2022-12-28 17:38:27 ','2022-12-28 17:38:27','',''),('8','213',347,'','2','2',1088520.00,0.00,'Payment Id 74 for invoice:79, receipt: 79 by Lausu Energy Resources','2023-01-01 23:55:59','',''),('8','213',348,'','supplier','1',0.00,1088520.00,'Payment Id 74 for invoice:79, receipt: 79 by Lausu Energy Resources','2023-01-01 23:55:59','',''),('8','213',349,'','2','2',1235780.00,0.00,'Payment Id 83 for invoice:88, receipt: 88 by Lausu Energy Resources','2023-01-02 00:30:19','',''),('8','213',350,'','supplier','1',0.00,1235780.00,'Payment Id 83 for invoice:88, receipt: 88 by Lausu Energy Resources','2023-01-02 00:30:19','',''),('8','213',351,'','2','2',936650.00,0.00,'Payment Id 82 for invoice:87, receipt: 87 by Lausu Energy Resources','2023-01-02 00:31:07','',''),('8','213',352,'','supplier','1',0.00,936650.00,'Payment Id 82 for invoice:87, receipt: 87 by Lausu Energy Resources','2023-01-02 00:31:07','',''),('8','213',353,'','2','2',973375.00,0.00,'Payment Id 79 for invoice:84, receipt: 84 by Lausu Energy Resources','2023-01-02 14:20:15','',''),('8','213',354,'','supplier','1',0.00,973375.00,'Payment Id 79 for invoice:84, receipt: 84 by Lausu Energy Resources','2023-01-02 14:20:15','',''),('8','213',355,'','2','2',1117215.00,0.00,'Payment Id 80 for invoice:85, receipt: 85 by Lausu Energy Resources','2023-01-02 14:26:32','',''),('8','213',356,'','supplier','1',0.00,1117215.00,'Payment Id 80 for invoice:85, receipt: 85 by Lausu Energy Resources','2023-01-02 14:26:32','',''),('8','213',357,'','2','2',744305.00,0.00,'Payment Id 81 for invoice:86, receipt: 86 by Lausu Energy Resources','2023-01-02 14:27:08','',''),('8','213',358,'','supplier','1',0.00,744305.00,'Payment Id 81 for invoice:86, receipt: 86 by Lausu Energy Resources','2023-01-02 14:27:08','',''),('8','213',359,'','24','4',0.00,14661600.00,'Purchase Id 10 for 49,200.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-02 14:43:25','',''),('8','213',360,'','supplier','1',14661600.00,0.00,'Purchase Id 10 for 49,200.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-02 14:43:25','',''),('8','213',361,'','20','6',1087625.50,0.00,'Sales from shift 90 on 2023-01-02 20:34:32 ','2023-01-02 20:34:32','',''),('8','213',362,'','6.1','7',0.00,1087625.50,'Sales from shift 90 on 2023-01-02 20:34:32 ','2023-01-02 20:34:32','',''),('8','213',363,'','2','2',1410170.00,0.00,'Payment Id 84 for invoice:89, receipt: 89 by Lausu Energy Resources','2023-01-03 14:14:23','',''),('8','213',364,'','supplier','1',0.00,1410170.00,'Payment Id 84 for invoice:89, receipt: 89 by Lausu Energy Resources','2023-01-03 14:14:23','',''),('8','213',365,'','20','6',941471.40,0.00,'Sales from shift 91 on 2023-01-03 21:12:51 ','2023-01-03 21:12:51','',''),('8','213',366,'','6.1','7',0.00,941471.40,'Sales from shift 91 on 2023-01-03 21:12:51 ','2023-01-03 21:12:51','',''),('8','213',367,'','2','2',1087625.00,0.00,'Payment Id 85 for invoice:90, receipt: 90 by Lausu Energy Resources','2023-01-04 14:37:13','',''),('8','213',368,'','supplier','1',0.00,1087625.00,'Payment Id 85 for invoice:90, receipt: 90 by Lausu Energy Resources','2023-01-04 14:37:13','',''),('8','213',369,'','20','6',1415622.18,0.00,'Sales from shift 92 on 2023-01-04 20:30:28 ','2023-01-04 20:30:28','',''),('8','213',370,'','6.1','7',0.00,1415622.18,'Sales from shift 92 on 2023-01-04 20:30:28 ','2023-01-04 20:30:28','',''),('8','213',371,'','20','6',1203455.12,0.00,'Sales from shift 93 on 2023-01-05 20:00:10 ','2023-01-05 20:00:10','',''),('8','213',372,'','6.1','7',0.00,1203455.12,'Sales from shift 93 on 2023-01-05 20:00:10 ','2023-01-05 20:00:10','',''),('8','213',373,'','20','6',1339614.30,0.00,'Sales from shift 94 on 2023-01-06 19:09:00 ','2023-01-06 19:09:00','',''),('8','213',374,'','6.1','7',0.00,1339614.30,'Sales from shift 94 on 2023-01-06 19:09:00 ','2023-01-06 19:09:00','',''),('8','213',375,'','2','2',941470.00,0.00,'Payment Id 86 for invoice:91, receipt: 91 by Lausu Energy Resources','2023-01-07 18:11:50','',''),('8','213',376,'','supplier','1',0.00,941470.00,'Payment Id 86 for invoice:91, receipt: 91 by Lausu Energy Resources','2023-01-07 18:11:50','',''),('8','213',377,'','2','2',1415620.00,0.00,'Payment Id 87 for invoice:92, receipt: 92 by Lausu Energy Resources','2023-01-07 18:12:06','',''),('8','213',378,'','supplier','1',0.00,1415620.00,'Payment Id 87 for invoice:92, receipt: 92 by Lausu Energy Resources','2023-01-07 18:12:06','',''),('8','213',379,'','20','6',1115858.02,0.00,'Sales from shift 95 on 2023-01-07 19:19:00 ','2023-01-07 19:19:00','',''),('8','213',380,'','6.1','7',0.00,1115858.02,'Sales from shift 95 on 2023-01-07 19:19:00 ','2023-01-07 19:19:00','',''),('8','213',381,'','20','6',1115503.40,0.00,'Sales from shift 96 on 2023-01-08 22:39:44 ','2023-01-08 22:39:44','',''),('8','213',382,'','6.1','7',0.00,1115503.40,'Sales from shift 96 on 2023-01-08 22:39:44 ','2023-01-08 22:39:44','',''),('8','213',383,'','20','6',1636407.40,0.00,'Sales from shift 97 on 2023-01-10 07:57:01 ','2023-01-10 07:57:01','',''),('8','213',384,'','6.1','7',0.00,1636407.40,'Sales from shift 97 on 2023-01-10 07:57:01 ','2023-01-10 07:57:01','',''),('8','213',385,'','20','6',1480517.64,0.00,'Sales from shift 98 on 2023-01-11 07:22:03 ','2023-01-11 07:22:03','',''),('8','213',386,'','6.1','7',0.00,1480517.64,'Sales from shift 98 on 2023-01-11 07:22:03 ','2023-01-11 07:22:03','',''),('8','213',387,'','2','2',1203455.00,0.00,'Payment Id 88 for invoice:93, receipt: 93 by Lausu Energy Resources','2023-01-11 17:17:04','',''),('8','213',388,'','supplier','1',0.00,1203455.00,'Payment Id 88 for invoice:93, receipt: 93 by Lausu Energy Resources','2023-01-11 17:17:04','',''),('8','213',389,'','2','2',1339615.00,0.00,'Payment Id 89 for invoice:94, receipt: 94 by Lausu Energy Resources','2023-01-11 17:17:31','',''),('8','213',390,'','supplier','1',0.00,1339615.00,'Payment Id 89 for invoice:94, receipt: 94 by Lausu Energy Resources','2023-01-11 17:17:31','',''),('8','213',391,'','2','2',1115860.00,0.00,'Payment Id 90 for invoice:95, receipt: 95 by Lausu Energy Resources','2023-01-11 17:17:56','',''),('8','213',392,'','supplier','1',0.00,1115860.00,'Payment Id 90 for invoice:95, receipt: 95 by Lausu Energy Resources','2023-01-11 17:17:56','',''),('8','213',393,'','2','2',1115505.00,0.00,'Payment Id 91 for invoice:96, receipt: 96 by Lausu Energy Resources','2023-01-11 17:18:29','',''),('8','213',394,'','supplier','1',0.00,1115505.00,'Payment Id 91 for invoice:96, receipt: 96 by Lausu Energy Resources','2023-01-11 17:18:29','',''),('8','213',395,'','2','2',1636410.00,0.00,'Payment Id 92 for invoice:97, receipt: 97 by Lausu Energy Resources','2023-01-11 17:18:53','',''),('8','213',396,'','supplier','1',0.00,1636410.00,'Payment Id 92 for invoice:97, receipt: 97 by Lausu Energy Resources','2023-01-11 17:18:53','',''),('8','213',397,'','20','6',1893909.20,0.00,'Sales from shift 99 on 2023-01-12 07:53:32 ','2023-01-12 07:53:32','',''),('8','213',398,'','6.1','7',0.00,1893909.20,'Sales from shift 99 on 2023-01-12 07:53:32 ','2023-01-12 07:53:32','',''),('8','213',399,'','2','2',1480520.00,0.00,'Payment Id 93 for invoice:98, receipt: 98 by Lausu Energy Resources','2023-01-12 15:09:23','',''),('8','213',400,'','supplier','1',0.00,1480520.00,'Payment Id 93 for invoice:98, receipt: 98 by Lausu Energy Resources','2023-01-12 15:09:23','',''),('8','213',401,'','20','6',732105.54,0.00,'Sales from shift 100 on 2023-01-13 08:24:21 ','2023-01-13 08:24:21','',''),('8','213',402,'','6.1','7',0.00,732105.54,'Sales from shift 100 on 2023-01-13 08:24:21 ','2023-01-13 08:24:21','',''),('8','213',403,'','20','6',613778.68,0.00,'Sales from shift 101 on 2023-01-13 09:17:48 ','2023-01-13 09:17:48','',''),('8','213',404,'','6.1','7',0.00,613778.68,'Sales from shift 101 on 2023-01-13 09:17:48 ','2023-01-13 09:17:48','',''),('8','213',405,'','2','2',1893910.00,0.00,'Payment Id 94 for invoice:99, receipt: 99 by Lausu Energy Resources','2023-01-14 08:46:23','',''),('8','213',406,'','supplier','1',0.00,1893910.00,'Payment Id 94 for invoice:99, receipt: 99 by Lausu Energy Resources','2023-01-14 08:46:23','',''),('8','213',407,'','2','2',732105.00,0.00,'Payment Id 95 for invoice:100, receipt: 100 by Lausu Energy Resources','2023-01-16 18:16:15','',''),('8','213',408,'','supplier','1',0.00,732105.00,'Payment Id 95 for invoice:100, receipt: 100 by Lausu Energy Resources','2023-01-16 18:16:15','',''),('8','213',409,'','2','2',613780.00,0.00,'Payment Id 96 for invoice:101, receipt: 101 by Lausu Energy Resources','2023-01-19 16:49:54','',''),('8','213',410,'','supplier','1',0.00,613780.00,'Payment Id 96 for invoice:101, receipt: 101 by Lausu Energy Resources','2023-01-19 16:49:54','',''),('8','213',411,'','24','4',0.00,17250000.00,'Purchase Id 11 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-01 08:22:52','',''),('8','213',412,'','supplier','1',17250000.00,0.00,'Purchase Id 11 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-01 08:22:52','',''),('8','213',413,'','20','6',2174141.70,0.00,'Sales from shift 102 on 2023-02-02 07:56:55 ','2023-02-02 07:56:55','',''),('8','213',414,'','6.1','7',0.00,2174141.70,'Sales from shift 102 on 2023-02-02 07:56:55 ','2023-02-02 07:56:55','',''),('8','213',415,'','20','6',1297658.85,0.00,'Sales from shift 103 on 2023-02-03 07:54:50 ','2023-02-03 07:54:50','',''),('8','213',416,'','6.1','7',0.00,1297658.85,'Sales from shift 103 on 2023-02-03 07:54:50 ','2023-02-03 07:54:50','',''),('8','213',417,'','20','6',1486380.75,0.00,'Sales from shift 104 on 2023-02-03 21:50:43 ','2023-02-03 21:50:43','',''),('8','213',418,'','6.1','7',0.00,1486380.75,'Sales from shift 104 on 2023-02-03 21:50:43 ','2023-02-03 21:50:43','',''),('8','213',419,'','20','6',1342381.20,0.00,'Sales from shift 105 on 2023-02-05 07:24:07 ','2023-02-05 07:24:07','',''),('8','213',420,'','6.1','7',0.00,1342381.20,'Sales from shift 105 on 2023-02-05 07:24:07 ','2023-02-05 07:24:07','',''),('8','213',421,'','20','6',1589366.70,0.00,'Sales from shift 106 on 2023-02-05 19:42:59 ','2023-02-05 19:42:59','',''),('8','213',422,'','6.1','7',0.00,1589366.70,'Sales from shift 106 on 2023-02-05 19:42:59 ','2023-02-05 19:42:59','',''),('8','213',423,'','2','2',1342380.00,0.00,'Payment Id 100 for invoice:105, receipt: 105 by Lausu Energy Resources','2023-02-06 18:15:24','',''),('8','213',424,'','supplier','1',0.00,1342380.00,'Payment Id 100 for invoice:105, receipt: 105 by Lausu Energy Resources','2023-02-06 18:15:24','',''),('8','213',425,'','20','6',2254609.50,0.00,'Sales from shift 107 on 2023-02-07 07:27:53 ','2023-02-07 07:27:53','',''),('8','213',426,'','6.1','7',0.00,2254609.50,'Sales from shift 107 on 2023-02-07 07:27:53 ','2023-02-07 07:27:53','',''),('8','213',427,'','20','6',2544630.30,0.00,'Sales from shift 108 on 2023-02-08 09:51:59 ','2023-02-08 09:51:59','',''),('8','213',428,'','6.1','7',0.00,2544630.30,'Sales from shift 108 on 2023-02-08 09:51:59 ','2023-02-08 09:51:59','',''),('8','213',429,'','2','2',2174225.00,0.00,'Payment Id 97 for invoice:102, receipt: 102 by Lausu Energy Resources','2023-02-08 12:26:52','',''),('8','213',430,'','supplier','1',0.00,2174225.00,'Payment Id 97 for invoice:102, receipt: 102 by Lausu Energy Resources','2023-02-08 12:26:52','',''),('8','213',431,'','24','4',0.00,5865000.00,'Purchase Id 12 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-08 21:21:00','',''),('8','213',432,'','supplier','1',5865000.00,0.00,'Purchase Id 12 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-08 21:21:00','',''),('8','213',433,'','20','6',2663544.90,0.00,'Sales from shift 109 on 2023-02-09 07:42:49 ','2023-02-09 07:42:49','',''),('8','213',434,'','6.1','7',0.00,2663544.90,'Sales from shift 109 on 2023-02-09 07:42:49 ','2023-02-09 07:42:49','',''),('8','213',435,'','2','2',1297660.00,0.00,'Payment Id 98 for invoice:103, receipt: 103 by Lausu Energy Resources','2023-02-10 17:06:57','',''),('8','213',436,'','supplier','1',0.00,1297660.00,'Payment Id 98 for invoice:103, receipt: 103 by Lausu Energy Resources','2023-02-10 17:06:57','',''),('8','213',437,'','2','2',1923730.00,0.00,'Payment Id 103 for invoice:108, receipt: 108 by Lausu Energy Resources','2023-02-10 17:08:35','',''),('8','213',438,'','supplier','1',0.00,1923730.00,'Payment Id 103 for invoice:108, receipt: 108 by Lausu Energy Resources','2023-02-10 17:08:35','',''),('8','213',439,'','2','2',1486380.00,0.00,'Payment Id 99 for invoice:104, receipt: 104 by Lausu Energy Resources','2023-02-10 17:15:54','',''),('8','213',440,'','supplier','1',0.00,1486380.00,'Payment Id 99 for invoice:104, receipt: 104 by Lausu Energy Resources','2023-02-10 17:15:54','',''),('8','213',441,'','2','2',1589370.00,0.00,'Payment Id 101 for invoice:106, receipt: 106 by Lausu Energy Resources','2023-02-10 17:17:39','',''),('8','213',442,'','supplier','1',0.00,1589370.00,'Payment Id 101 for invoice:106, receipt: 106 by Lausu Energy Resources','2023-02-10 17:17:39','',''),('8','213',443,'','20','6',2675830.35,0.00,'Sales from shift 110 on 2023-02-10 20:23:50 ','2023-02-10 20:23:50','',''),('8','213',444,'','6.1','7',0.00,2675830.35,'Sales from shift 110 on 2023-02-10 20:23:50 ','2023-02-10 20:23:50','',''),('8','213',445,'','20','6',1784467.65,0.00,'Sales from shift 111 on 2023-02-11 20:55:50 ','2023-02-11 20:55:50','',''),('8','213',446,'','6.1','7',0.00,1784467.65,'Sales from shift 111 on 2023-02-11 20:55:50 ','2023-02-11 20:55:50','',''),('8','213',447,'','20','6',2218653.60,0.00,'Sales from shift 112 on 2023-02-12 10:32:58 ','2023-02-12 10:32:58','',''),('8','213',448,'','6.1','7',0.00,2218653.60,'Sales from shift 112 on 2023-02-12 10:32:58 ','2023-02-12 10:32:58','',''),('8','213',449,'','20','6',1069700.10,0.00,'Sales from shift 113 on 2023-02-12 10:42:15 ','2023-02-12 10:42:15','',''),('8','213',450,'','6.1','7',0.00,1069700.10,'Sales from shift 113 on 2023-02-12 10:42:15 ','2023-02-12 10:42:15','',''),('8','213',451,'','2','2',2026610.00,0.00,'Payment Id 102 for invoice:107, receipt: 107 by Lausu Energy Resources','2023-02-13 15:50:50','',''),('8','213',452,'','supplier','1',0.00,2026610.00,'Payment Id 102 for invoice:107, receipt: 107 by Lausu Energy Resources','2023-02-13 15:50:50','',''),('8','213',453,'','2','2',620900.00,0.00,'Payment Id 104 for invoice:108, receipt: 108 by Lausu Energy Resources','2023-02-13 15:52:06','',''),('8','213',454,'','supplier','1',0.00,620900.00,'Payment Id 104 for invoice:108, receipt: 108 by Lausu Energy Resources','2023-02-13 15:52:06','',''),('8','213',455,'','2','2',1718745.00,0.00,'Payment Id 105 for invoice:109, receipt: 109 by Lausu Energy Resources','2023-02-13 15:53:13','',''),('8','213',456,'','supplier','1',0.00,1718745.00,'Payment Id 105 for invoice:109, receipt: 109 by Lausu Energy Resources','2023-02-13 15:53:13','',''),('8','213',457,'','2','2',2282530.00,0.00,'Payment Id 107 for invoice:110, receipt: 110 by Lausu Energy Resources','2023-02-13 15:56:21','',''),('8','213',458,'','supplier','1',0.00,2282530.00,'Payment Id 107 for invoice:110, receipt: 110 by Lausu Energy Resources','2023-02-13 15:56:21','',''),('8','213',459,'','2','2',872600.00,0.00,'Payment Id 113 for invoice:113, receipt: 113 by Lausu Energy Resources','2023-02-13 15:58:54','',''),('8','213',460,'','supplier','1',0.00,872600.00,'Payment Id 113 for invoice:113, receipt: 113 by Lausu Energy Resources','2023-02-13 15:58:54','',''),('8','213',461,'','2','2',1484470.00,0.00,'Payment Id 109 for invoice:111, receipt: 111 by Lausu Energy Resources','2023-02-13 16:00:11','',''),('8','213',462,'','supplier','1',0.00,1484470.00,'Payment Id 109 for invoice:111, receipt: 111 by Lausu Energy Resources','2023-02-13 16:00:11','',''),('8','213',463,'','2','1',944800.00,0.00,'Payment Id 106 for invoice:109, receipt: 109 by Lausu Energy Resources','2023-02-17 02:11:38','',''),('8','213',464,'','supplier','1',0.00,944800.00,'Payment Id 106 for invoice:109, receipt: 109 by Lausu Energy Resources','2023-02-17 02:11:38','',''),('8','213',465,'','2','2',393300.00,0.00,'Payment Id 108 for invoice:110, receipt: 110 by Lausu Energy Resources','2023-02-17 02:12:10','',''),('8','213',466,'','supplier','1',0.00,393300.00,'Payment Id 108 for invoice:110, receipt: 110 by Lausu Energy Resources','2023-02-17 02:12:10','',''),('8','213',467,'','2','2',300000.00,0.00,'Payment Id 110 for invoice:111, receipt: 111 by Lausu Energy Resources','2023-02-17 02:12:38','',''),('8','213',468,'','supplier','1',0.00,300000.00,'Payment Id 110 for invoice:111, receipt: 111 by Lausu Energy Resources','2023-02-17 02:12:38','',''),('8','213',469,'','2','2',998600.00,0.00,'Payment Id 112 for invoice:112, receipt: 112 by Lausu Energy Resources','2023-02-17 02:13:53','',''),('8','213',470,'','supplier','1',0.00,998600.00,'Payment Id 112 for invoice:112, receipt: 112 by Lausu Energy Resources','2023-02-17 02:13:53','',''),('8','213',471,'','2','2',197100.00,0.00,'Payment Id 114 for invoice:113, receipt: 113 by Lausu Energy Resources','2023-02-17 02:14:45','',''),('8','213',472,'','supplier','1',0.00,197100.00,'Payment Id 114 for invoice:113, receipt: 113 by Lausu Energy Resources','2023-02-17 02:14:45','',''),('8','213',473,'','6.1','7',0.00,197100.00,'Payment Id 114 for invoice:113, receipt: 113 by Lausu Energy Resources','2023-02-17 02:22:32','',''),('8','213',474,'','supplier','1',197100.00,0.00,'Payment Id 114 for invoice:113, receipt: 113 by Lausu Energy Resources','2023-02-17 02:22:32','',''),('8','213',475,'','24','4',0.00,16711000.00,'Purchase Id 13 for 49,150.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-17 07:38:44','',''),('8','213',476,'','supplier','1',16711000.00,0.00,'Purchase Id 13 for 49,150.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-17 07:38:44','',''),('8','213',477,'','20','6',1152127.40,0.00,'Sales from shift 114 on 2023-02-18 17:05:09 ','2023-02-18 17:05:09','',''),('8','213',478,'','6.1','7',0.00,1152127.40,'Sales from shift 114 on 2023-02-18 17:05:09 ','2023-02-18 17:05:09','',''),('8','213',479,'','20','6',1129048.20,0.00,'Sales from shift 115 on 2023-02-19 17:13:43 ','2023-02-19 17:13:43','',''),('8','213',480,'','6.1','7',0.00,1129048.20,'Sales from shift 115 on 2023-02-19 17:13:43 ','2023-02-19 17:13:43','',''),('8','213',481,'','20','6',1261564.64,0.00,'Sales from shift 116 on 2023-02-20 13:02:51 ','2023-02-20 13:02:51','',''),('8','213',482,'','6.1','7',0.00,1261564.64,'Sales from shift 116 on 2023-02-20 13:02:51 ','2023-02-20 13:02:51','',''),('8','213',483,'','2','2',1220050.00,0.00,'Payment Id 111 for invoice:112, receipt: 112 by Lausu Energy Resources','2023-02-20 13:16:27','',''),('8','213',484,'','supplier','1',0.00,1220050.00,'Payment Id 111 for invoice:112, receipt: 112 by Lausu Energy Resources','2023-02-20 13:16:27','',''),('8','213',485,'','2','2',1152330.00,0.00,'Payment Id 116 for invoice:114, receipt: 114 by Lausu Energy Resources','2023-02-20 13:19:12','',''),('8','213',486,'','supplier','1',0.00,1152330.00,'Payment Id 116 for invoice:114, receipt: 114 by Lausu Energy Resources','2023-02-20 13:19:12','',''),('8','213',487,'','2','2',1129050.00,0.00,'Payment Id 117 for invoice:115, receipt: 115 by Lausu Energy Resources','2023-02-20 13:19:45','',''),('8','213',488,'','supplier','1',0.00,1129050.00,'Payment Id 117 for invoice:115, receipt: 115 by Lausu Energy Resources','2023-02-20 13:19:45','',''),('8','213',489,'','20','6',1359116.00,0.00,'Sales from shift 117 on 2023-02-21 10:05:40 ','2023-02-21 10:05:40','',''),('8','213',490,'','6.1','7',0.00,1359116.00,'Sales from shift 117 on 2023-02-21 10:05:40 ','2023-02-21 10:05:40','',''),('8','213',491,'','20','6',1002585.20,0.00,'Sales from shift 118 on 2023-02-22 17:24:07 ','2023-02-22 17:24:07','',''),('8','213',492,'','6.1','7',0.00,1002585.20,'Sales from shift 118 on 2023-02-22 17:24:07 ','2023-02-22 17:24:07','',''),('8','213',493,'','20','6',1494555.00,0.00,'Sales from shift 119 on 2023-02-23 14:47:02 ','2023-02-23 14:47:02','',''),('8','213',494,'','6.1','7',0.00,1494555.00,'Sales from shift 119 on 2023-02-23 14:47:02 ','2023-02-23 14:47:02','',''),('8','213',495,'','20','6',1350697.60,0.00,'Sales from shift 120 on 2023-02-26 21:10:07 ','2023-02-26 21:10:07','',''),('8','213',496,'','6.1','7',0.00,1350697.60,'Sales from shift 120 on 2023-02-26 21:10:07 ','2023-02-26 21:10:07','',''),('8','213',497,'','20','6',1894966.40,0.00,'Sales from shift 121 on 2023-02-26 21:19:20 ','2023-02-26 21:19:20','',''),('8','213',498,'','6.1','7',0.00,1894966.40,'Sales from shift 121 on 2023-02-26 21:19:20 ','2023-02-26 21:19:20','',''),('8','213',499,'','20','6',2331148.80,0.00,'Sales from shift 122 on 2023-02-26 21:48:43 ','2023-02-26 21:48:43','',''),('8','213',500,'','6.1','7',0.00,2331148.80,'Sales from shift 122 on 2023-02-26 21:48:43 ','2023-02-26 21:48:43','',''),('8','213',501,'','20','6',1740489.60,0.00,'Sales from shift 123 on 2023-02-28 07:53:28 ','2023-02-28 07:53:28','',''),('8','213',502,'','6.1','7',0.00,1740489.60,'Sales from shift 123 on 2023-02-28 07:53:28 ','2023-02-28 07:53:28','',''),('8','213',503,'','2','2',1359120.00,0.00,'Payment Id 119 for invoice:117, receipt: 117 by Lausu Energy Resources','2023-03-01 14:49:57','',''),('8','213',504,'','supplier','1',0.00,1359120.00,'Payment Id 119 for invoice:117, receipt: 117 by Lausu Energy Resources','2023-03-01 14:49:57','',''),('8','213',505,'','2','2',1002585.00,0.00,'Payment Id 120 for invoice:118, receipt: 118 by Lausu Energy Resources','2023-03-01 14:50:20','',''),('8','213',506,'','supplier','1',0.00,1002585.00,'Payment Id 120 for invoice:118, receipt: 118 by Lausu Energy Resources','2023-03-01 14:50:20','',''),('8','213',507,'','2','2',1494555.00,0.00,'Payment Id 121 for invoice:119, receipt: 119 by Lausu Energy Resources','2023-03-01 14:50:49','',''),('8','213',508,'','supplier','1',0.00,1494555.00,'Payment Id 121 for invoice:119, receipt: 119 by Lausu Energy Resources','2023-03-01 14:50:49','',''),('8','213',509,'','2','2',1261565.00,0.00,'Payment Id 118 for invoice:116, receipt: 116 by Lausu Energy Resources','2023-03-01 15:06:11','',''),('8','213',510,'','supplier','1',0.00,1261565.00,'Payment Id 118 for invoice:116, receipt: 116 by Lausu Energy Resources','2023-03-01 15:06:11','',''),('8','213',511,'','2','2',1894900.00,0.00,'Payment Id 123 for invoice:121, receipt: 121 by Lausu Energy Resources','2023-03-01 15:07:56','',''),('8','213',512,'','supplier','1',0.00,1894900.00,'Payment Id 123 for invoice:121, receipt: 121 by Lausu Energy Resources','2023-03-01 15:07:56','',''),('8','213',513,'','2','2',1271050.00,0.00,'Payment Id 122 for invoice:120, receipt: 120 by Lausu Energy Resources','2023-03-01 17:13:24','',''),('8','213',514,'','supplier','1',0.00,1271050.00,'Payment Id 122 for invoice:120, receipt: 120 by Lausu Energy Resources','2023-03-01 17:13:24','',''),('8','213',515,'','20','6',1424915.20,0.00,'Sales from shift 124 on 2023-03-01 19:12:11 ','2023-03-01 19:12:11','',''),('8','213',516,'','6.1','7',0.00,1424915.20,'Sales from shift 124 on 2023-03-01 19:12:11 ','2023-03-01 19:12:11','',''),('8','213',517,'','24','4',0.00,13053750.00,'Purchase Id 14 for 44,250.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-07 21:32:15','',''),('8','213',518,'','supplier','1',13053750.00,0.00,'Purchase Id 14 for 44,250.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-07 21:32:15','',''),('8','213',519,'','20','6',0.00,0.00,'Sales from shift 125 on 2023-03-14 17:02:07 ','2023-03-14 17:02:07','',''),('8','213',520,'','6.1','7',0.00,0.00,'Sales from shift 125 on 2023-03-14 17:02:07 ','2023-03-14 17:02:07','',''),('8','213',521,'','20','6',2131543.15,0.00,'Sales from shift 126 on 2023-03-15 17:19:12 ','2023-03-15 17:19:12','',''),('8','213',522,'','6.1','7',0.00,2131543.15,'Sales from shift 126 on 2023-03-15 17:19:12 ','2023-03-15 17:19:12','',''),('8','213',523,'','20','6',2194611.20,0.00,'Sales from shift 127 on 2023-03-15 17:26:06 ','2023-03-15 17:26:06','',''),('8','213',524,'','6.1','7',0.00,2194611.20,'Sales from shift 127 on 2023-03-15 17:26:06 ','2023-03-15 17:26:06','',''),('8','213',525,'','20','6',1957283.70,0.00,'Sales from shift 128 on 2023-03-15 17:36:37 ','2023-03-15 17:36:37','',''),('8','213',526,'','6.1','7',0.00,1957283.70,'Sales from shift 128 on 2023-03-15 17:36:37 ','2023-03-15 17:36:37','',''),('8','213',527,'','20','6',1548245.55,0.00,'Sales from shift 129 on 2023-03-15 17:43:48 ','2023-03-15 17:43:48','',''),('8','213',528,'','6.1','7',0.00,1548245.55,'Sales from shift 129 on 2023-03-15 17:43:48 ','2023-03-15 17:43:48','',''),('8','213',529,'','20','6',2358749.20,0.00,'Sales from shift 130 on 2023-03-15 17:47:42 ','2023-03-15 17:47:42','',''),('8','213',530,'','6.1','7',0.00,2358749.20,'Sales from shift 130 on 2023-03-15 17:47:42 ','2023-03-15 17:47:42','',''),('8','213',531,'','2','2',2331210.00,0.00,'Payment Id 124 for invoice:122, receipt: 122 by Lausu Energy Resources','2023-03-15 18:16:48','',''),('8','213',532,'','supplier','1',0.00,2331210.00,'Payment Id 124 for invoice:122, receipt: 122 by Lausu Energy Resources','2023-03-15 18:16:48','',''),('8','213',533,'','2','2',1740490.00,0.00,'Payment Id 125 for invoice:123, receipt: 123 by Lausu Energy Resources','2023-03-15 18:17:10','',''),('8','213',534,'','supplier','1',0.00,1740490.00,'Payment Id 125 for invoice:123, receipt: 123 by Lausu Energy Resources','2023-03-15 18:17:10','',''),('8','213',535,'','2','2',1424910.00,0.00,'Payment Id 126 for invoice:124, receipt: 124 by Lausu Energy Resources','2023-03-15 18:17:56','',''),('8','213',536,'','supplier','1',0.00,1424910.00,'Payment Id 126 for invoice:124, receipt: 124 by Lausu Energy Resources','2023-03-15 18:17:56','',''),('8','213',537,'','20','6',1028809.55,0.00,'Sales from shift 131 on 2023-03-15 21:52:47 ','2023-03-15 21:52:47','',''),('8','213',538,'','6.1','7',0.00,1028809.55,'Sales from shift 131 on 2023-03-15 21:52:47 ','2023-03-15 21:52:47','',''),('8','213',539,'','24','4',0.00,14350000.00,'Purchase Id 15 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-21 00:27:59','',''),('8','213',540,'','supplier','1',14350000.00,0.00,'Purchase Id 15 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-21 00:27:59','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'8','213','PMS','Petrol','Litres',0,287.00,287.00,287.00,287.00,0.00,0,'2022-08-06 09:48:05','926','926','2022-08-22 16:06:29',0),(2,'8','213','AGO','Diesel','Litres',0,800.00,800.00,800.00,800.00,0.00,0,'2022-08-06 09:50:59','926','926','2022-08-06 09:50:59',0),(3,'8','213','DPK','Kerosene','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-08-06 09:54:10','926','926','2022-08-06 09:54:10',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'8','213',1,215.00,0.00,0.00,0.00,'Cost from purchase id #1','2022-08-10 18:37:14','928'),(2,'8','213',1,200.00,0.00,0.00,0.00,'Cost from purchase id #2','2022-08-22 12:38:41','467'),(3,'8','213',1,200.00,200.00,200.00,200.00,'','2022-08-22 17:15:26','926'),(4,'8','213',2,800.00,800.00,800.00,800.00,'','2022-08-22 17:16:08','926'),(5,'8','213',1,200.00,195.00,195.00,195.00,'','2022-08-25 14:37:08','467'),(6,'8','213',1,195.00,195.00,0.00,0.00,'Cost from purchase id #3','2022-09-01 12:08:59','928'),(7,'8','213',1,190.00,195.00,0.00,0.00,'Cost from purchase id #4','2022-09-14 11:17:43','928'),(8,'8','213',1,195.00,190.00,190.00,190.00,'CHANGE PRICE','2022-09-15 14:32:16','467'),(9,'8','213',1,190.00,190.00,0.00,0.00,'Cost from purchase id #5','2022-09-25 10:45:06','928'),(10,'8','213',1,203.00,190.00,0.00,0.00,'Cost from purchase id #6','2022-10-10 14:26:29','928'),(11,'8','213',1,203.00,203.00,203.00,203.00,'CHANGE PRICE','2022-10-11 16:27:34','467'),(12,'8','213',1,207.00,207.00,207.00,207.00,'Change of price','2022-10-12 16:21:13','925'),(13,'8','213',1,220.00,220.00,220.00,220.00,'Change of price','2022-10-12 16:33:26','925'),(14,'8','213',1,253.00,253.00,253.00,253.00,'Change of price','2022-11-09 12:30:12','925'),(15,'8','213',1,255.00,255.00,255.00,255.00,'Change of price','2022-11-14 07:29:05','925'),(16,'8','213',1,260.00,260.00,260.00,260.00,'Change of price','2022-11-24 14:01:04','925'),(17,'8','213',1,312.00,312.00,312.00,312.00,'Change of price','2022-12-17 13:46:25','925'),(18,'8','213',1,300.00,300.00,300.00,300.00,'Change of price','2022-12-25 14:46:16','925'),(19,'8','213',1,298.00,298.00,298.00,298.00,'Change of price','2023-01-02 14:27:25','925'),(20,'8','213',1,345.00,345.00,345.00,345.00,'Change of price','2023-02-01 08:11:41','925'),(21,'8','213',1,340.00,340.00,340.00,340.00,'Change of price','2023-02-17 06:19:22','925'),(22,'8','213',1,320.00,320.00,320.00,320.00,'Change of price','2023-02-24 06:11:47','925'),(23,'8','213',1,320.00,320.00,320.00,320.00,'Change of price','2023-02-24 23:51:24','925'),(24,'8','213',1,295.00,295.00,295.00,295.00,'Change of price','2023-03-06 13:53:01','925'),(25,'8','213',1,287.00,287.00,287.00,287.00,'Change of price','2023-03-20 21:06:51','925'),(26,'8','213',1,287.00,287.00,287.00,287.00,'Change of price','2023-03-20 21:06:59','925');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'8','213','2022-08-10',1,1,215.00,30800.00,0.00,0.00,6622000.00,0.00,'','00993','GML594XA','','','','2022-08-10 11:54:38',15,'Supply of pms','925','','0000-00-00 00:00:00','928','2022-08-10 18:37:14'),(2,'8','213','2022-08-19',1,1,200.00,49700.00,0.00,0.00,9940000.00,0.00,'','00994','NSR572ZS','','','','2022-08-21 13:22:52',15,'Supply of pms','925','','0000-00-00 00:00:00','467','2022-08-22 12:38:41'),(3,'8','213','2022-09-01',1,1,195.00,49700.00,0.00,0.00,9691500.00,0.00,'','08331','RAN31XF','','','','2022-09-01 11:26:03',15,'Supply of pms','925','','0000-00-00 00:00:00','928','2022-09-01 12:08:59'),(4,'8','213','2022-09-14',1,1,190.00,49500.00,0.00,0.00,9405000.00,0.00,'','00037','RAN33XF','','','','2022-09-14 11:04:35',15,'Purchase of pms','925','','0000-00-00 00:00:00','928','2022-09-14 11:17:43'),(5,'8','213','2022-09-25',1,1,190.00,50000.00,0.00,0.00,9500000.00,0.00,'','0005','RAN32XF','','','','2022-09-25 09:06:45',15,'Purchase of pms','925','','0000-00-00 00:00:00','928','2022-09-25 10:45:06'),(6,'8','213','2022-10-10',1,1,203.00,50250.00,0.00,0.00,10200750.00,0.00,'','0001','GML594XA','','','','2022-10-10 08:59:21',15,'Purchase of pms','925','','0000-00-00 00:00:00','928','2022-10-10 14:26:29'),(7,'8','213','2022-11-09',1,1,253.00,49700.00,0.00,0.00,12574100.00,0.00,'','0001','NSR572ZS','','','','2022-11-09 12:20:09',15,'Purchase of pms','925','','0000-00-00 00:00:00','928','2022-11-09 13:31:19'),(8,'8','213','2022-11-23',1,1,260.00,49450.00,0.00,0.00,12857000.00,0.00,'','2022','RYM497XA','','','','2022-11-24 14:05:15',15,'Purchase of pms','925','','0000-00-00 00:00:00','928','2022-11-24 14:58:07'),(9,'8','213','2022-12-17',1,1,312.00,44650.00,0.00,0.00,13930800.00,0.00,'','0001','GMT191XA','','','','2022-12-17 13:44:08',15,'Purchase of pms','925','928','2022-12-17 15:40:12','928','2022-12-17 15:40:36'),(10,'8','213','2023-01-01',1,1,298.00,49200.00,0.00,0.00,14661600.00,0.00,'','001','DkA705ZP','','','','2023-01-02 14:25:37',15,'Supply of pms','925','','0000-00-00 00:00:00','928','2023-01-02 14:43:25'),(11,'8','213','2023-02-01',1,1,345.00,50000.00,0.00,0.00,17250000.00,0.00,'','001','NSR572ZS','','','','2023-02-01 08:14:17',15,'Purchase of pms','925','','0000-00-00 00:00:00','928','2023-02-01 08:22:52'),(12,'8','213','2023-02-08',1,1,345.00,17000.00,0.00,0.00,5865000.00,0.00,'','001','RAN31XF','','','','2023-02-08 20:59:44',15,'Purchase of pms','925','','0000-00-00 00:00:00','928','2023-02-08 21:21:00'),(13,'8','213','2023-02-16',1,1,340.00,49150.00,0.00,0.00,16711000.00,0.00,'','002','NSR57ZQ','','','','2023-02-17 06:22:10',15,'Supply of pms','925','','0000-00-00 00:00:00','928','2023-02-17 07:38:44'),(14,'8','213','2023-03-07',1,1,295.00,44250.00,0.00,0.00,13053750.00,0.00,'','001','GMT406YR','','','','2023-03-07 20:47:19',15,'Purchase of pms','925','','0000-00-00 00:00:00','928','2023-03-07 21:32:15'),(15,'8','213','2023-03-19',1,1,287.00,50000.00,0.00,0.00,14350000.00,0.00,'','001','RAN32XF','','','','2023-03-20 21:10:04',5,'Purchase of pms','925','','0000-00-00 00:00:00','928','2023-03-21 00:27:59');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'8','213','2022-08-11',1,'','','5',774950.00,'02','','','2','Sani','778166',778166.70,'2022-08-14 10:14:52',5,'PYMMT','925','467','2022-08-14 12:25:58','928','2022-08-15 20:00:15'),(2,'8','213','2022-08-10',1,'','','5',861265.00,'01','','','2','Sani','001',778166.70,'2022-08-14 10:19:14',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-15 20:00:56'),(3,'8','213','2022-08-12',1,'03','','5',796860.00,'03','','','2','Sani makarfi1','03',0.00,'2022-08-15 15:30:48',5,'Payment by makarfi1','925','','0000-00-00 00:00:00','928','2022-08-22 13:40:51'),(4,'8','213','2022-08-13',1,'4','','10',480900.00,'4','','','2','Sani makarfi1','004',480902.10,'2022-08-16 10:54:18',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-08-22 13:40:18'),(5,'8','213','2022-08-14',1,'005','','10',568130.00,'5','','','2','Sani makarfi1','005',480902.10,'2022-08-16 10:59:19',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-08-22 13:39:40'),(6,'8','213','2022-08-14',1,'006','','5',522860.00,'05','','','2','Sani makarfi1','006',480902.10,'2022-08-16 11:02:19',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-24 00:30:27'),(7,'8','213','2022-08-15',1,'006','','5',480900.00,'6','','','2','Sani makarfi1','006',0.00,'2022-08-22 18:10:30',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-24 00:30:57'),(8,'8','213','2022-08-16',1,'16','','10',779835.00,'16','','','2','Sani makarfi1','16',0.00,'2022-08-22 18:18:49',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-11-11 12:14:32'),(9,'8','213','2022-08-17',1,'8','','5',1144765.00,'8','','','2','Sani makarfi1','8',0.00,'2022-08-22 18:34:20',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-24 00:31:40'),(10,'8','213','2022-08-18',1,'9','','5',506470.00,'9','','','2','Sani makarfi1','9',0.00,'2022-08-22 18:36:17',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-24 00:32:15'),(11,'8','213','2022-08-19',1,'10','','5',719640.00,'10','','','2','Sani makarfi1','10',0.00,'2022-08-22 18:38:58',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-24 00:34:10'),(12,'8','213','2022-08-21',1,'11','','5',495115.00,'11','','','2','Sani makarfi1','11',0.00,'2022-08-22 18:41:16',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-24 00:37:55'),(13,'8','213','2022-08-22',1,'12','','5',580675.00,'22','','','2','Sani makarfi1','22',647766.00,'2022-08-24 17:14:47',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-25 17:43:36'),(14,'8','213','2022-08-23',1,'13','','10',647765.00,'23','','','2','Sani makarfi1','23',647766.00,'2022-08-24 17:17:20',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-08-25 17:44:25'),(15,'8','213','2022-08-24',1,'14','','10',1484130.00,'14','','','2','Sani makarfi1','14',1484107.95,'2022-08-25 15:01:13',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-08-26 11:59:46'),(16,'8','213','2022-08-25',1,'15','','5',800475.00,'15','','','2','Sani makarfi1','15',0.00,'2022-08-26 14:43:29',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-27 08:53:38'),(17,'8','213','2022-08-26',1,'26','','5',757860.00,'26','','','2','Sani makarfi1','26',0.00,'2022-08-29 17:18:40',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-01 12:15:32'),(18,'8','213','2022-08-27',1,'27','','5',759840.00,'27','','','2','Sani makarfi1','27',0.00,'2022-08-29 17:22:32',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-29 20:23:01'),(19,'8','213','2022-08-28',1,'28','','5',663060.00,'28','','','2','Sani makarfi1','28',0.00,'2022-08-29 17:24:25',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-08-29 20:23:16'),(20,'8','213','2022-08-29',1,'29','','5',690190.00,'29','','','2','Sani makarfi1','29',690190.80,'2022-08-30 08:28:00',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-01 12:12:17'),(21,'8','213','2022-08-30',1,'30','','10',777095.00,'25','','','2','Sani makarfi1','30',777094.50,'2022-08-30 21:26:02',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-09-01 12:12:29'),(23,'8','213','2022-09-01',1,'31','','5',1213475.00,'27','','','2','Sani makarfi1','31',1213274.40,'2022-09-01 19:28:14',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-02 15:04:08'),(24,'8','213','2022-09-01',1,'001','','5',909975.00,'28','','','2','Sani makarfi1','001',909971.40,'2022-09-01 20:55:56',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-04 19:12:27'),(25,'8','213','2022-09-02',1,'002','','5',829965.00,'29','','','2','Sani makarfi1','002',829964.85,'2022-09-02 22:03:15',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-06 16:25:02'),(26,'8','213','2022-09-03',1,'003','','5',746485.00,'30','','','2','Sani makarfi1','003',746485.35,'2022-09-03 19:31:40',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-06 16:22:56'),(27,'8','213','2022-09-04',1,'004','','5',856355.00,'31','','','2','Sani makarfi1','004',856354.20,'2022-09-04 19:18:03',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-06 16:23:23'),(28,'8','213','2022-09-05',1,'005','','5',940290.00,'32','','','2','Sani makarfi1','005',940290.00,'2022-09-05 22:36:39',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-06 16:23:41'),(29,'8','213','2022-09-06',1,'006','','5',991650.00,'33','','','2','Sani makarfi1','006',991649.10,'2022-09-06 21:15:47',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-08 14:07:45'),(30,'8','213','2022-09-07',1,'007','','5',1145840.00,'34','','','2','Sani makarfi1','007',1145841.45,'2022-09-07 21:02:36',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-09 17:40:37'),(31,'8','213','2022-09-08',1,'008','','5',1054840.00,'35','','','2','Sani makarfi1','008',1054836.90,'2022-09-08 22:12:10',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-09 17:41:09'),(32,'8','213','2022-09-09',1,'009','','5',759700.00,'36','','','2','Sani makarfi1','009',759698.55,'2022-09-09 20:00:45',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-13 14:54:16'),(33,'8','213','2022-09-10',1,'10','','5',773000.00,'37','','','2','Sani makarfi1','10',772987.80,'2022-09-10 21:14:49',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-13 14:54:30'),(34,'8','213','2022-09-11',1,'11','','5',880590.00,'38','','','2','Sani makarfi1','11',880590.75,'2022-09-14 12:02:25',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-14 18:58:31'),(35,'8','213','2022-09-14',1,' 14','','5',1233720.00,'39','','','2','Sani makarfi1','14',1266183.75,'2022-09-14 20:54:11',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-17 10:22:45'),(36,'8','213','2022-09-15',1,'15','','5',952720.00,'40','','','2','Sani makarfi1','15',952720.80,'2022-09-15 20:58:42',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-20 13:35:35'),(37,'8','213','2022-09-16',1,'16','','5',989040.00,'41','','','2','Sani makarfi1','16',989041.20,'2022-09-17 08:47:58',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-20 13:37:24'),(38,'8','213','2022-09-17',1,'17','','5',954570.00,'42','','','2','Sani makarfi1','17',954571.40,'2022-09-18 09:14:55',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-20 13:37:36'),(39,'8','213','2022-09-18',1,'18','','5',877215.00,'43','','','2','Sani makarfi1','18',877214.80,'2022-09-18 22:25:25',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-20 13:37:52'),(40,'8','213','2022-09-19',1,'19','','5',903705.00,'44','','','2','Sani makarfi1','19',903704.60,'2022-09-19 21:04:13',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-21 13:39:08'),(41,'8','213','2022-09-20',1,'20','','5',1190140.00,'45','','','2','Sani makarfi1','20',1190137.20,'2022-09-20 20:24:00',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-09-23 14:08:55'),(42,'8','213','2022-09-21',1,'21','','5',1289575.00,'46','','','2','Sani makarfi1','21',1289575.60,'2022-09-21 20:55:07',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-23 14:09:13'),(43,'8','213','2022-09-22',1,'22','','5',801115.00,'47','','','2','Sani makarfi1','22',801112.20,'2022-09-22 15:05:36',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-26 16:26:30'),(44,'8','213','2022-09-25',1,'25','','5',1128985.00,'48','','','2','Sani makarfi1','25',1128983.80,'2022-09-25 19:16:29',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-27 16:34:22'),(45,'8','213','2022-09-26',1,'26','','5',1046815.00,'49','','','2','Sani makarfi1','26',1046814.50,'2022-09-26 19:37:06',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-28 13:13:34'),(46,'8','213','2022-09-27',1,'27','','5',1350160.00,'50','','','2','Sani makarfi1','27',1350160.90,'2022-09-27 20:03:29',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-09-30 12:29:53'),(47,'8','213','2022-09-28',1,'28','','5',1617190.00,'51','','','2','Sani makarfi1','28',1617190.70,'2022-09-28 19:44:30',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-09-30 12:30:05'),(48,'8','213','2022-09-29',1,'29','','5',1034920.00,'52','','','2','Sani makarfi1','29',1034918.60,'2022-09-29 21:00:02',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-10-03 02:04:05'),(49,'8','213','2022-09-30',1,'30','','5',643940.00,'53','','','2','Sani makarfi1','30',643936.60,'2022-09-30 20:30:09',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-10-04 17:31:59'),(50,'8','213','2022-10-01',1,'001','','5',1176220.00,'54','','','2','Sani makarfi1','001',1176219.70,'2022-10-01 21:30:55',5,'Payment to bank','925','','0000-00-00 00:00:00','465','2022-10-07 11:07:23'),(51,'8','213','2022-10-02',1,'002','','5',950430.00,'55','','','2','Sani makarfi1','002',950427.50,'2022-10-02 20:46:05',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-10-05 14:31:29'),(52,'8','213','2022-10-04',1,'031022','','5',585590.00,'56','','','2','MAKARFI','031022',585590.00,'2022-10-04 10:29:07',5,'','467','467','2022-10-04 15:38:17','928','2022-10-04 18:03:43'),(53,'8','213','2022-10-10',1,'001','','5',2782540.00,'57','','','2','Sani makarfi1','0001',2782537.24,'2022-10-11 16:34:04',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-10-12 16:26:26'),(54,'8','213','2022-10-11',1,'0002','','5',3109235.00,'58','','','2','Sani makarfi1','0002',3109440.15,'2022-10-12 16:27:09',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-10-14 14:32:03'),(55,'8','213','2022-10-12',1,'003','','5',2595660.00,'59','','','2','Sani makarfi1','0003',2595661.20,'2022-10-13 09:46:31',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-10-18 11:55:38'),(56,'8','213','2022-10-13',1,'004','','5',2227690.00,'60','','','2','Sani makarfi1','0004',2227689.20,'2022-10-14 07:24:18',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-10-14 14:32:31'),(57,'8','213','2022-11-09',1,'0005','','5',2144675.00,'61','','','2','Sani makarfi1','0005',2144592.45,'2022-11-10 14:56:21',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-11-11 15:08:38'),(58,'8','213','2022-11-11',1,'0007','','5',1666120.00,'63','','','2','Sani makarfi1','0007',1661018.37,'2022-11-12 15:05:06',5,'Payment to bank','925','928','2022-11-15 17:21:14','928','2022-11-15 17:21:36'),(59,'8','213','2022-11-12',1,'0008','','5',1512185.00,'64','','','2','Sani makarfi1','0008',1512183.53,'2022-11-13 07:20:40',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-11-15 17:13:28'),(60,'8','213','2022-11-13',1,'0009','','5',1253350.00,'65','','','2','Sani makarfi1','0009',1243457.05,'2022-11-14 11:06:08',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-11-15 17:14:14'),(61,'8','213','2022-11-14',1,'010','','5',1493285.00,'66','','','2','Sani makarfi1','010',1493030.10,'2022-11-14 19:11:38',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-11-17 13:15:10'),(62,'8','213','2022-11-15',1,'011','','5',1833395.00,'67','','','2','Sani makarfi1','011',1833393.90,'2022-11-15 20:53:57',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-11-22 09:31:05'),(63,'8','213','2022-11-16',1,'68','','5',939060.00,'68','','','2','Sani makarfi1','68',939057.90,'2022-11-16 22:14:38',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-11-22 09:30:15'),(64,'8','213','2022-11-24',1,'69','','5',1538545.00,'69','','','2','Sani makarfi1','69',1538544.80,'2022-11-24 20:10:56',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-11-28 17:14:11'),(65,'8','213','2022-11-25',1,'70','','5',1164080.00,'70','','','2','Sani makarfi1','70',1164077.20,'2022-11-25 19:01:44',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-11-28 16:59:24'),(66,'8','213','2022-11-26',1,'71','','5',1083825.00,'71','','','2','Sani makarfi1','71',1083823.00,'2022-11-26 18:55:14',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-11-28 16:59:05'),(67,'8','213','2022-11-27',1,'72','','5',1164360.00,'72','','','2','Sani makarfi1','72',1164360.60,'2022-11-27 19:16:28',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-11-30 13:36:15'),(68,'8','213','2022-11-28',1,'73','','5',1080620.00,'73','','','2','Sani makarfi1','73',1080617.20,'2022-11-28 19:02:07',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-12-01 11:02:39'),(69,'8','213','2022-11-29',1,'74','','5',1276660.00,'74','','','2','Sani makarfi1','74',1276662.40,'2022-11-29 19:37:08',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-12-02 15:19:37'),(70,'8','213','2022-11-30',1,'75','','5',2374890.00,'75','','','2','Sani makarfi1','75',2374886.80,'2022-11-30 19:48:50',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-12-04 00:55:43'),(71,'8','213','2022-12-01',1,'76','','5',1710380.00,'76','','','2','Sani makarfi1','76',1710378.80,'2022-12-01 19:05:51',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2022-12-04 21:59:39'),(72,'8','213','2022-12-02',1,'77','','5',1299030.00,'77','','','2','Sani makarfi1','77',1299030.20,'2022-12-02 14:03:43',5,'Payment to pos','925','','0000-00-00 00:00:00','465','2022-12-13 13:47:26'),(73,'8','213','2022-12-17',1,'78','','10',1080565.00,'78','','','2','Sani makarfi1','78',1080565.20,'2022-12-18 08:05:30',5,'Payment to pos','925','','0000-00-00 00:00:00','465','2022-12-20 12:59:22'),(74,'8','213','2022-12-18',1,'79','','10',1088520.00,'79','','','2','Sani makarfi1','79',1088518.08,'2022-12-18 19:44:33',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-01 23:55:59'),(75,'8','213','2022-12-19',1,'80','','10',1141960.00,'80','','','2','Sani makarfi1','80',1141960.56,'2022-12-20 07:24:17',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-12-21 16:23:41'),(76,'8','213','2022-12-21',1,'81','','10',1372750.00,'81','','','2','Sani makarfi1','81',1372756.32,'2022-12-21 09:17:22',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-12-25 03:43:46'),(77,'8','213','2022-12-21',1,'82','','10',1724215.00,'82','','','2','Sani makarfi1','82',1724214.96,'2022-12-22 08:32:35',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-12-25 03:44:10'),(78,'8','213','2022-12-22',1,'83','','10',1056240.00,'83','','','2','Sani makarfi1','83',1056241.68,'2022-12-23 07:59:14',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2022-12-27 09:44:22'),(79,'8','213','2022-12-23',1,'84','','10',973375.00,'84','','','2','Sani makarfi1','84',973374.48,'2022-12-24 06:07:24',5,'Payment to pos','925','','0000-00-00 00:00:00','465','2023-01-02 14:20:15'),(80,'8','213','2022-12-24',1,'85','','10',1117215.00,'85','','','2','Sani makarfi1','85',1117215.84,'2022-12-25 08:18:45',5,'Payment to pos','925','','0000-00-00 00:00:00','465','2023-01-02 14:26:32'),(81,'8','213','2022-12-25',1,'86','','10',744305.00,'86','','','2','Sani makarfi1','86',738861.00,'2022-12-26 07:33:59',5,'Payment to pos','925','','0000-00-00 00:00:00','465','2023-01-02 14:27:08'),(82,'8','213','2022-12-26',1,'87','','10',936650.00,'87','','','2','Sani makarfi1','87',936651.00,'2022-12-26 19:08:02',5,'Payment to pod','925','','0000-00-00 00:00:00','928','2023-01-02 00:31:07'),(83,'8','213','2022-12-27',1,'88','','10',1235780.00,'88','','','2','Sani makarfi1','88',1235781.00,'2022-12-27 19:16:54',5,'Payment for pos','925','','0000-00-00 00:00:00','928','2023-01-02 00:30:19'),(84,'8','213','2022-12-28',1,'89','','10',1410170.00,'89','','','2','Sani makarfi1','89',1410156.00,'2022-12-28 17:40:46',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-03 14:14:23'),(85,'8','213','2023-01-02',1,'90','','10',1087625.00,'90','','','2','Sani makarfi1','90',1087625.50,'2023-01-02 20:35:59',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-04 14:37:13'),(86,'8','213','2023-01-03',1,'91','','10',941470.00,'91','','','2','Sani makarfi1','91',941471.40,'2023-01-03 21:14:24',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-07 18:11:50'),(87,'8','213','2023-01-04',1,'92','','10',1415620.00,'92','','','2','Sani makarfi1','92',1415622.18,'2023-01-04 20:31:40',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-07 18:12:06'),(88,'8','213','2023-01-05',1,'93','','10',1203455.00,'93','','','2','Sani makarfi1','93',1203455.12,'2023-01-05 20:01:16',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-11 17:17:04'),(89,'8','213','2023-01-06',1,'94','','10',1339615.00,'94','','','2','Sani makarfi1','94',1339614.30,'2023-01-06 19:10:41',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-11 17:17:31'),(90,'8','213','2023-01-07',1,'95','','10',1115860.00,'95','','','2','Sani makarfi1','95',1115858.02,'2023-01-07 19:20:26',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-11 17:17:56'),(91,'8','213','2023-01-08',1,'96','','10',1115505.00,'96','','','2','Sani makarfi1','96',1115503.40,'2023-01-08 22:42:26',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-11 17:18:29'),(92,'8','213','2023-01-09',1,'97','','5',1636410.00,'97','','','2','Sani makarfi1','97',1636407.40,'2023-01-10 07:58:33',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-01-11 17:18:53'),(93,'8','213','2023-01-10',1,'98','','5',1480520.00,'98','','','2','Sani makarfi1','98',1480517.64,'2023-01-11 07:23:36',5,'Payment of POS','925','','0000-00-00 00:00:00','928','2023-01-12 15:09:23'),(94,'8','213','2023-01-11',1,'99','','5',1893910.00,'99','','','2','Sani makarfi1','99',1893909.20,'2023-01-12 07:55:36',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-14 08:46:23'),(95,'8','213','2023-01-12',1,'100','','10',732105.00,'100','','','2','Sani makarfi1','100',732105.54,'2023-01-13 08:25:31',5,'Payment to POS','925','','0000-00-00 00:00:00','928','2023-01-16 18:16:15'),(96,'8','213','2023-01-13',1,'101','','10',613780.00,'101','','','2','Sani makarfi1','101',613778.68,'2023-01-13 09:20:01',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-01-19 16:49:54'),(97,'8','213','2023-02-01',1,'102','','5',2174225.00,'102','','','2','102','102',2174141.70,'2023-02-02 08:05:00',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-02-08 12:26:52'),(98,'8','213','2023-02-02',1,'103','','10',1297660.00,'103','','','2','Sani makarfi1','103',1297658.85,'2023-02-03 07:56:14',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-10 17:06:57'),(99,'8','213','2023-02-03',1,'104','','10',1486380.00,'104','','','2','Sani makarfi1','104',1486380.75,'2023-02-03 21:51:49',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-10 17:15:54'),(100,'8','213','2023-02-04',1,'105','','10',1342380.00,'105','','','2','Sani makarfi1','105',1342381.20,'2023-02-05 07:26:18',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-06 18:15:24'),(101,'8','213','2023-02-05',1,'106','','10',1589370.00,'106','','','2','Sani makarfi1','106',1589366.70,'2023-02-05 19:45:31',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-10 17:17:39'),(102,'8','213','2023-02-06',1,'107','','5',2026610.00,'107','','','2','Sani makarfi1','107',2254609.50,'2023-02-07 07:30:30',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-02-13 15:50:50'),(103,'8','213','2023-02-08',1,'108','','5',1923730.00,'108','','','2','Sani makarfi1','108',2544630.30,'2023-02-08 09:57:44',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-02-10 17:08:35'),(104,'8','213','2023-02-08',1,'108','','10',620900.00,'108','','','2','Sani makarfi1','109',620900.00,'2023-02-08 10:15:58',5,'Payment to POS','925','','0000-00-00 00:00:00','928','2023-02-13 15:52:06'),(105,'8','213','2023-02-08',1,'109','','5',1718745.00,'109','','','2','Sani makarfi1','110',2663544.90,'2023-02-09 07:46:20',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-02-13 15:53:13'),(106,'8','213','2023-02-09',1,'109','','5',944800.00,'109','','','1','Sani makarfi1','1622023',944800.00,'2023-02-09 07:49:57',5,'Payment to pos','925','928','2023-02-16 19:18:16','928','2023-02-17 02:11:38'),(107,'8','213','2023-02-09',1,'110','','5',2282530.00,'110','','','2','Sani makarfi1','112',2675830.35,'2023-02-10 20:28:37',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-02-13 15:56:21'),(108,'8','213','2023-02-09',1,'110','','10',393300.00,'110','','','2','Sani makarfi1','113',393300.00,'2023-02-10 20:30:34',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-17 02:12:10'),(109,'8','213','2023-02-10',1,'111','','5',1484470.00,'111','','','2','Sani makarfi1','114',1784467.65,'2023-02-11 21:02:17',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-02-13 16:00:11'),(110,'8','213','2023-02-10',1,'111','','10',300000.00,'111','','','2','Sani makarfi1','115',300000.00,'2023-02-11 21:04:13',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-17 02:12:38'),(111,'8','213','2023-02-11',1,'112','','5',1220050.00,'112','','','2','Sani makarfi1','116',2218653.60,'2023-02-12 10:35:24',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-02-20 13:16:27'),(112,'8','213','2023-02-11',1,'112','','10',998600.00,'112','','','2','Sani makarfi1','117',998600.00,'2023-02-12 10:37:10',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-17 02:13:53'),(113,'8','213','2023-02-12',1,'113','','5',872600.00,'113','','','2','Sani makarfi1','118',1069700.10,'2023-02-13 08:16:38',5,'Payment to bank','925','','0000-00-00 00:00:00','928','2023-02-13 15:58:54'),(114,'8','213','2023-02-12',1,'113','','10',197100.00,'113','','','2','Sani makarfi1','119',197100.00,'2023-02-13 08:18:05',2,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-17 02:14:45'),(115,'8','213','2023-02-12',1,'113','','10',197100.00,'113','','','2','Sani makarfi1','120',197100.10,'2023-02-17 07:33:11',0,'Payment to pos','925','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(116,'8','213','2023-02-17',1,'114','','5',1152330.00,'114','','','2','Sani makarfi1','121',1152127.40,'2023-02-18 17:07:20',5,'Payment to bank','925','928','2023-02-20 13:18:56','928','2023-02-20 13:19:12'),(117,'8','213','2023-02-18',1,'115','','10',1129050.00,'115','','','2','Sani makarfi1','122',1129048.20,'2023-02-19 17:16:01',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-02-20 13:19:45'),(118,'8','213','2023-02-19',1,'116','','5',1261565.00,'116','','','2','Sani makarfi1','123',1261564.64,'2023-02-20 13:04:24',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-03-01 15:06:11'),(119,'8','213','2023-02-20',1,'117','','5',1359120.00,'117','','','2','Sani makarfi1','124',1359116.00,'2023-02-21 10:08:07',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-03-01 14:49:58'),(120,'8','213','2023-02-21',1,'118','','5',1002585.00,'118','','','2','Sani makarfi1','125',1002585.20,'2023-02-22 17:26:52',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-03-01 14:50:20'),(121,'8','213','2023-02-22',1,'119','','10',1494555.00,'119','','','2','Sani makarfi1','126',1494555.00,'2023-02-23 14:50:54',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-03-01 14:50:49'),(122,'8','213','2023-02-13',1,'120','','5',1271050.00,'120','','','2','Sani makarfi1','132023',1271050.00,'2023-02-26 21:13:30',5,'Payment to pos','925','928','2023-03-01 17:13:04','928','2023-03-01 17:13:24'),(123,'8','213','2023-02-24',1,'121','','5',1894900.00,'121','','','2','Sani makarfi1','128',1894966.40,'2023-02-26 21:22:35',5,'Payment to pos','925','928','2023-03-01 15:07:32','928','2023-03-01 15:07:56'),(124,'8','213','2023-02-26',1,'122','','5',2331210.00,'122','','','2','Sani makarfi1','\'130',2331148.80,'2023-02-26 21:31:20',5,'Payment to pos','925','928','2023-03-15 18:16:29','928','2023-03-15 18:16:48'),(125,'8','213','2023-02-27',1,'123','','5',1740490.00,'123','','','2','Sani makarfi1','130',1740489.60,'2023-02-28 07:54:51',5,'Payment to pos','925','','0000-00-00 00:00:00','928','2023-03-15 18:17:10'),(126,'8','213','2023-03-28',1,'124','','5',1424910.00,'124','','','2','Sani makarfi1','131',1424915.20,'2023-03-01 19:14:00',5,'Payment to pos','925','928','2023-03-15 18:17:43','928','2023-03-15 18:17:56'),(127,'8','213','2023-03-08',1,'126','','5',2131545.00,'126','','','2','Sani makarfi1','132',2131543.15,'2023-03-15 17:22:16',0,'Payment to pos','925','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(128,'8','213','2023-03-09',1,'127','','5',2194620.00,'127','','','2','Sani makarfi1','133',2194611.20,'2023-03-15 17:29:18',0,'Payment to pos','925','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(129,'8','213','2023-03-10',1,'128','','5',1957285.00,'128','','','2','Sani makarfi1','134',1957283.70,'2023-03-15 17:38:59',0,'Payment to pos','925','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(130,'8','213','2023-03-13',1,'131','','5',1028800.00,'131','','','2','Sani makarfi1',' 134',1028809.55,'2023-03-17 12:27:00',0,'Payment to','925','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(131,'8','213','2023-03-11',1,'131','','10',1548835.00,'131','','','2','Sani makarfi1','135',1548835.00,'2023-03-17 16:27:12',0,'Payment to pos','925','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(132,'8','213','2023-03-12',1,'131','','10',2358170.00,'131','','','2','Sani makarfi1','136',2358170.00,'2023-03-17 16:30:03',0,'Payment to pos\r\n','925','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'8',1,'213',1,1,'2022-08-10 00:00:00','A.A.RANO',22200.00,22200.00,0.00,'1082022','','1','GML594XA','KABIRU','0817774782','DELEVERY OF PMS ',5,'2022-08-10 21:51:19','928','0000-00-00 00:00:00','','2022-08-10 22:09:05','928'),(2,'8',1,'213',1,1,'2022-08-10 00:00:00','A.A.RANO',8600.00,8600.00,0.00,'1082022','','2','GML594XA','KABIRU','0817774782','DELEVERY OF PMS',5,'2022-08-10 21:51:19','928','0000-00-00 00:00:00','','2022-08-10 22:09:05','928'),(3,'8',2,'213',1,1,'2022-08-22 00:00:00','AA Rano',33000.00,33000.00,0.00,'02','','1','NSR572ZS','Alh bahari','08032973447','Purchase of pms',5,'2022-08-22 12:58:16','925','0000-00-00 00:00:00','','2022-08-22 19:21:11','467'),(4,'8',2,'213',1,1,'2022-08-22 00:00:00','AA Rano',16700.00,16700.00,0.00,'02','','2','NSR572ZS','Alh bahari','08032973447','Purchase of pms',5,'2022-08-22 12:58:16','925','0000-00-00 00:00:00','','2022-08-22 13:30:35','928'),(7,'8',3,'213',1,1,'2022-09-01 00:00:00','AA Rano',32900.00,32900.00,0.00,'08331','','1','RAN31XF','Shafiu','08032528608','Purchase of pms',5,'2022-09-01 14:34:30','925','0000-00-00 00:00:00','','2022-09-01 15:45:29','928'),(8,'8',3,'213',1,1,'2022-09-01 00:00:00','AA Rano',16800.00,16800.00,0.00,'08331','','2','RAN31XF','Shafiu','08032528608','Purchase of pms',5,'2022-09-01 14:34:30','925','0000-00-00 00:00:00','','2022-09-01 15:45:41','928'),(9,'8',4,'213',1,1,'2022-09-14 00:00:00','AA Rano',33000.00,33000.00,0.00,'00037','','1','RAN33XF','Abdullahi','09066536097','Purchase of pms',5,'2022-09-14 11:32:33','925','0000-00-00 00:00:00','','2022-09-14 11:46:25','928'),(10,'8',4,'213',1,1,'2022-09-14 00:00:00','AA Rano',16500.00,16500.00,0.00,'00037','','2','RAN33XF','Abdullahi','09066536097','Purchase of pms',5,'2022-09-14 11:32:33','925','0000-00-00 00:00:00','','2022-09-14 11:46:48','928'),(11,'8',5,'213',1,1,'2022-09-25 00:00:00','AA Rano',17000.00,17000.00,0.00,'0005','','1','RAN32XF','Isa','07063462050','Purchase of pms',5,'2022-09-25 13:48:54','925','0000-00-00 00:00:00','','2022-09-25 14:23:00','928'),(12,'8',5,'213',1,1,'2022-09-25 00:00:00','AA Rano',33000.00,33000.00,0.00,'0005','','2','RAN32XF','Isa','07063462050','Purchase of pms',5,'2022-09-25 13:48:54','925','0000-00-00 00:00:00','','2022-09-25 14:22:35','928'),(13,'8',6,'213',1,1,'2022-10-10 00:00:00','AA Rano',17000.00,17000.00,0.00,'0001','','1','GML594XA','Kabiru','08147774782','Purchase of pms',5,'2022-10-10 15:47:50','925','0000-00-00 00:00:00','','2022-10-10 16:13:03','928'),(14,'8',6,'213',1,1,'2022-10-10 00:00:00','AA Rano',33250.00,33250.00,0.00,'0001','','2','GML594XA','Kabiru','08147774782','Purchase of pms',5,'2022-10-10 15:47:50','925','0000-00-00 00:00:00','','2022-10-10 16:12:35','928'),(15,'8',7,'213',1,1,'2022-11-09 00:00:00','AA Rano',32700.00,32700.00,0.00,'0001','','1','NSR572ZS','Alh bahari','08032973447','Purchase of pms',5,'2022-11-09 13:47:38','925','0000-00-00 00:00:00','','2022-11-10 14:50:27','928'),(16,'8',7,'213',1,1,'2022-11-09 00:00:00','AA Rano',17000.00,17000.00,0.00,'0001','','2','NSR572ZS','Alh bahari','08032973447','Purchase of pms',5,'2022-11-09 13:47:38','925','0000-00-00 00:00:00','','2022-11-10 14:48:42','928'),(17,'8',8,'213',1,1,'2022-11-24 00:00:00','AA Rano',16750.00,16750.00,0.00,'2022','','1','RYM497XA','Isah','09055551553','Purchase of pms',5,'2022-11-24 15:38:19','925','0000-00-00 00:00:00','','2022-11-24 15:50:25','928'),(18,'8',8,'213',1,1,'2022-11-24 00:00:00','AA Rano',32700.00,32700.00,0.00,'2022','','2','RYM497XA','Isah','09055551553','Purchase of pms',5,'2022-11-24 15:38:19','925','0000-00-00 00:00:00','','2022-11-24 15:50:01','928'),(19,'8',9,'213',1,1,'2022-12-17 00:00:00','AA Rano',28650.00,28650.00,0.00,'0001','','1','GMT191XA','Abubakar','08101522444','Purchase of pms',5,'2022-12-17 16:11:23','925','0000-00-00 00:00:00','','2022-12-17 18:03:18','928'),(20,'8',9,'213',1,1,'2022-12-17 00:00:00','AA Rano',16000.00,16000.00,0.00,'0001','','2','GMT191XA','Abubakar','08101522444','Purchase of pms',5,'2022-12-17 16:11:23','925','0000-00-00 00:00:00','','2022-12-17 18:02:58','928'),(21,'8',10,'213',1,1,'2023-01-02 00:00:00','AA Rano',32200.00,32200.00,0.00,'001','','1','DkA705ZP','Yahaya','08069769924','Purchase of pms',5,'2023-01-02 14:50:24','925','0000-00-00 00:00:00','','2023-01-02 14:51:37','928'),(22,'8',10,'213',1,1,'2023-01-02 00:00:00','AA Rano',17000.00,17000.00,0.00,'001','','2','DkA705ZP','Yahaya','08069769924','Purchase of pms',5,'2023-01-02 14:50:24','925','0000-00-00 00:00:00','','2023-01-02 14:51:08','928'),(23,'8',11,'213',1,1,'2023-02-01 00:00:00','AA Rano',16000.00,16000.00,0.00,'001','','1','NSR572ZS','Alh bahari','08032973447','Purchase of pms',5,'2023-02-01 08:27:06','925','0000-00-00 00:00:00','','2023-02-01 08:28:54','928'),(24,'8',11,'213',1,1,'2023-02-01 00:00:00','AA Rano',34000.00,34000.00,0.00,'001','','2','NSR572ZS','Alh bahari','08032973447','Purchase of pms',5,'2023-02-01 08:27:06','925','0000-00-00 00:00:00','','2023-02-01 08:29:12','928'),(25,'8',12,'213',1,1,'2023-02-08 00:00:00','AA Rano',17000.00,17000.00,0.00,'001','','1','RAN31XF','Isah','07063462050','Purchase of pms',5,'2023-02-08 22:05:03','925','0000-00-00 00:00:00','','2023-02-08 22:08:23','928'),(26,'8',13,'213',1,1,'2023-02-17 00:00:00','AA Rano',19150.00,19150.00,0.00,'001','','1','NSR57ZQ','Ali','09066536097','Purchase of pms',5,'2023-02-17 07:49:20','925','0000-00-00 00:00:00','','2023-02-17 07:50:58','928'),(27,'8',13,'213',1,1,'2023-02-17 00:00:00','AA Rano',30000.00,30000.00,0.00,'001','','2','NSR57ZQ','Ali','09066536097','Purchase of pms',5,'2023-02-17 07:49:20','925','0000-00-00 00:00:00','','2023-02-17 07:50:30','928'),(28,'8',14,'213',1,1,'2023-03-07 00:00:00','AA Rano',28550.00,28550.00,0.00,'001','','1','GMT406YR','Abdullahi','07063462050','Purchase of pms',5,'2023-03-07 22:14:01','925','0000-00-00 00:00:00','','2023-03-08 08:39:32','928'),(29,'8',14,'213',1,1,'2023-03-07 00:00:00','AA Rano',15700.00,15700.00,0.00,'001','','2','GMT406YR','Abdullahi','07063462050','Purchase of pms',5,'2023-03-07 22:14:01','925','0000-00-00 00:00:00','','2023-03-08 08:39:07','928');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'8','213','Lausu Energy Resources','Babangida Umar Bashir','08063654848','info@','KANO','KANO','Lausu Energy AA Rano House Hotoro.','Nigeria',0.00,0.00,'0000-00-00','2022-08-06 09:45:05',5,'926','2022-08-06 09:45:05','926');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:57:13
