-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_8_station_212
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_8_station_212`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_8_station_212` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_8_station_212`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,500,'',0,'6.1','8','212','CASH','','2022-07-17 09:03:41',5,0.00,0.00,'','910','2022-07-17 09:03:41','910',0,0),(2,4000,'',0,'22','8','212','PURCHASES','','2022-07-17 09:04:02',5,0.00,0.00,'','910','2022-07-17 09:04:02','910',0,0),(3,8000,'',0,'24','8','212','PURCHASES','','2022-07-17 09:04:13',5,0.00,0.00,'','910','2022-07-17 09:04:13','910',0,0),(4,8001,'',0,'24','8','212','SALARIES & WAGES','','2022-07-17 09:04:43',5,0.00,0.00,'','910','2022-07-17 09:04:43','910',0,0),(5,7000,'',0,'20','8','212','SALES','','2022-07-17 09:05:01',5,0.00,0.00,'','910','2022-07-17 09:05:01','910',0,0),(6,2500,'',0,'2','8','212','KEYSTONE 1009060914','','2022-07-17 12:39:38',5,0.00,0.00,'','910','2022-07-17 12:39:38','910',0,0),(7,2501,'',0,'2','8','212','UBA-0039769388','','2022-08-06 02:09:55',5,0.00,0.00,'','910','2022-08-06 02:09:55','910',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1,'','8','212','DRIVER SHORTAGE ','JAFAR NAMADI','08038204064','lausuenergy@gmail.com','KANO','KANO','KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2022-07-17 12:58:03',5,'910','2022-07-17 12:58:03','910');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('8','212','1',1,'5','PMS PUMP 1',278235.50,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-12 13:25:10','910'),('8','212','1',2,'5','PMS PUMP 2',325167.87,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-12 13:29:07','910'),('8','212','2',3,'5','PMS 3',644945.89,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-12 15:07:16','910'),('8','212','2',4,'5','PMS PUMP 4',2742260.81,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-12 15:08:53','910'),('8','212','3',5,'5','AGO PUMP ',0.00,'AGO DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=176 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('8','212',7,'Daily shift','2022-08-10','2022-08-10 18:30:22','2022-08-11 18:30:22','910',0.00,0.00,'910','2022-08-12 12:57:49','910','2022-08-12 13:08:19',10,0),('8','212',8,'Daily shift','2022-08-10','2022-08-12 15:13:57','2022-08-13 15:13:57','910',141639.85,141639.85,'910','2022-08-12 15:19:15','910','2022-08-12 15:53:15',10,0),('8','212',9,'Daily shift','2022-08-11','2022-08-12 15:55:55','2022-08-13 15:55:55','910',238086.70,238086.70,'910','2022-08-12 15:59:24','910','2022-08-12 16:06:56',10,0),('8','212',10,'Daily shift ','2022-08-12','2022-08-12 19:23:11','2022-08-13 19:23:11','910',316918.60,316918.60,'910','2022-08-12 19:25:51','910','2022-08-12 19:26:53',10,0),('8','212',11,'Daily shift','2022-08-12','2022-08-12 20:18:33','2022-08-13 20:18:33','910',219923.50,219923.50,'910','2022-08-13 19:24:12','910','2022-08-13 19:25:41',10,0),('8','212',12,'Daily shift','2022-08-14','2022-08-14 19:46:42','2022-08-15 19:46:42','910',826702.95,826702.95,'910','2022-08-14 19:57:29','910','2022-08-14 19:58:25',10,0),('8','212',13,'Daily shift','2022-08-15','2022-08-15 20:08:47','2022-08-16 20:08:47','910',174964.85,174964.85,'910','2022-08-15 20:11:24','910','2022-08-15 20:12:31',10,0),('8','212',14,'Daily shift','2022-08-16','2022-08-16 20:48:21','2022-08-17 20:48:21','910',210162.50,210162.50,'910','2022-08-16 20:50:08','910','2022-08-16 20:51:01',10,0),('8','212',15,'Daily shift','2022-08-17','2022-08-19 18:45:57','2022-08-20 18:45:57','910',255119.00,255119.00,'910','2022-08-19 18:48:56','910','2022-08-19 19:05:23',10,0),('8','212',16,'Daily shift','2022-08-18','2022-08-19 19:06:38','2022-08-20 19:06:38','910',273692.85,273692.85,'910','2022-08-19 19:09:09','910','2022-08-19 19:09:45',10,0),('8','212',17,'Daily shift','2022-08-19','2022-08-19 19:11:32','2022-08-20 19:11:32','910',220884.55,220884.55,'910','2022-08-19 19:13:40','910','2022-08-19 19:14:20',10,0),('8','212',18,'Daily shift','2022-08-20','2022-08-20 20:19:05','2022-08-21 20:19:05','910',192941.00,192941.00,'910','2022-08-20 20:31:26','910','2022-08-20 20:33:36',10,0),('8','212',19,'Daily shift','2022-08-21','2022-08-21 19:44:21','2022-08-22 19:44:21','910',732855.45,732855.45,'910','2022-08-21 19:46:58','910','2022-08-21 19:47:52',10,0),('8','212',20,'Daily shift','2022-08-23','2022-08-23 09:38:28','2022-08-24 09:38:28','910',149014.35,149014.35,'910','2022-08-23 09:40:14','910','2022-08-23 14:07:23',10,0),('8','212',21,'Daily shift','2022-08-23','2022-08-23 19:10:43','2022-08-24 19:10:43','910',138932.00,149351.90,'910','2022-08-23 19:13:18','910','2022-08-23 19:15:01',10,0),('8','212',22,'DAILY','2022-08-24','2022-08-24 17:05:41','2022-08-31 17:05:41','926',0.00,0.00,'910','2022-08-24 20:43:26','910','2022-08-24 20:45:05',10,0),('8','212',23,'Daily shift','2022-08-24','2022-08-24 20:46:54','2022-08-25 20:46:54','910',188854.00,179411.30,'910','2022-08-24 20:49:34','910','2022-08-25 16:54:48',10,0),('8','212',24,'Daily shift','2022-08-25','2022-08-25 19:24:29','2022-08-26 19:24:29','910',305742.00,290454.90,'910','2022-08-25 19:27:32','910','2022-08-25 19:40:35',10,0),('8','212',25,'Daily shift','2022-08-26','2022-08-26 20:32:08','2022-08-27 20:32:08','910',229940.00,218443.00,'910','2022-08-26 20:36:02','910','2022-08-26 20:38:18',10,0),('8','212',26,'Daily shift','2022-08-27','2022-08-27 19:39:18','2022-08-28 19:39:18','910',374942.00,356194.90,'910','2022-08-27 19:41:31','910','2022-08-28 19:45:48',10,0),('8','212',27,'Daily shift ','2022-08-28','2022-08-28 19:46:58','2022-08-29 19:46:58','910',603020.00,572869.00,'910','2022-08-28 19:49:43','910','2022-08-28 19:50:15',10,0),('8','212',28,'Daily shift ','2022-08-29','2022-08-29 19:47:45','2022-08-30 19:47:45','910',137470.00,130596.50,'910','2022-08-29 19:49:40','910','2022-08-29 19:50:40',10,0),('8','212',29,'Daily shift','2022-08-30','2022-08-30 19:04:47','2022-08-31 19:04:47','910',236740.00,224903.00,'910','2022-08-30 19:06:51','910','2022-08-30 19:08:06',10,0),('8','212',30,'Daily shift','2022-08-31','2022-08-31 19:47:03','2022-09-01 19:47:03','910',352148.00,334540.60,'910','2022-08-31 19:50:34','910','2022-08-31 19:53:10',10,0),('8','212',31,'Daily shift','2022-09-01','2022-09-01 20:07:22','2022-09-02 20:07:22','910',327610.00,311229.50,'910','2022-09-01 20:10:00','910','2022-09-01 20:13:15',10,0),('8','212',32,'Daily shift','2022-09-02','2022-09-02 19:45:59','2022-09-03 19:45:59','910',850260.00,807747.00,'910','2022-09-02 19:48:52','910','2022-09-02 19:49:23',10,0),('8','212',33,'Daily shift','2022-09-03','2022-09-04 08:18:41','2022-09-05 08:18:41','910',635118.00,603362.10,'910','2022-09-04 08:21:29','910','2022-09-04 08:22:09',10,0),('8','212',34,'Daily shift','2022-09-04','2022-09-05 12:31:36','2022-09-06 12:31:36','910',1498562.00,1423633.90,'910','2022-09-05 12:33:49','910','2022-09-05 21:38:54',10,0),('8','212',35,'Daily shift','2022-09-05','2022-09-05 21:40:31','2022-09-06 21:40:31','910',327286.00,310921.70,'910','2022-09-05 21:43:03','910','2022-09-05 21:44:16',10,0),('8','212',36,'Daily shift','2022-09-06','2022-09-06 20:47:23','2022-09-07 20:47:23','910',240258.80,240258.80,'910','2022-09-06 20:50:31','910','2022-09-06 20:51:56',10,0),('8','212',37,'Daily shift','2022-09-07','2022-09-07 20:35:26','2022-09-08 20:35:26','910',145855.40,145855.40,'910','2022-09-07 20:40:23','910','2022-09-07 20:41:20',10,0),('8','212',38,'Daily shift','2022-09-08','2022-09-08 19:15:53','2022-09-09 19:15:53','910',346742.40,346742.40,'910','2022-09-08 19:20:10','910','2022-09-08 19:21:00',10,0),('8','212',39,'Daily shift','2022-09-10','2022-09-10 09:23:05','2022-09-11 09:23:05','910',254218.10,254218.10,'910','2022-09-10 09:26:29','910','2022-09-10 09:27:12',10,0),('8','212',40,'Daily shift','2022-09-10','2022-09-10 19:31:36','2022-09-11 19:31:36','910',306927.90,306927.90,'910','2022-09-10 19:34:11','910','2022-09-10 19:34:54',10,0),('8','212',41,'Daily shift','2022-09-11','2022-09-11 21:09:02','2022-09-12 21:09:02','910',1725135.40,1725135.40,'910','2022-09-11 21:12:16','910','2022-09-11 21:12:53',10,0),('8','212',42,'Daily shift','2022-09-12','2022-09-12 19:22:14','2022-09-13 19:22:14','910',911838.50,911838.50,'910','2022-09-12 19:24:18','910','2022-09-12 19:26:15',10,0),('8','212',43,'Daily shift','2022-09-13','2022-09-13 21:09:17','2022-09-14 21:09:17','910',664756.80,664756.80,'910','2022-09-13 21:11:56','910','2022-09-13 21:12:41',10,0),('8','212',44,'Daily shift','2022-09-14','2022-09-14 19:40:39','2022-09-15 19:40:39','910',544053.60,544053.60,'910','2022-09-14 19:42:06','910','2022-09-14 19:42:38',10,0),('8','212',45,'Daily shift ','2022-09-15','2022-09-15 18:51:53','2022-09-16 18:51:53','910',525469.70,525469.70,'910','2022-09-15 18:54:10','910','2022-09-15 18:54:48',10,0),('8','212',46,'Daily shift','2022-09-16','2022-09-16 20:02:23','2022-09-17 20:02:23','910',462902.70,462902.70,'910','2022-09-16 20:06:26','910','2022-09-16 20:07:18',10,0),('8','212',47,'Daily shift ','2022-09-17','2022-09-17 22:25:27','2022-09-18 22:25:27','910',241117.60,241117.60,'910','2022-09-17 22:26:47','910','2022-09-17 22:27:28',10,0),('8','212',48,'Daily shift','2022-09-18','2022-09-18 19:25:27','2022-09-19 19:25:27','910',1016728.00,1016728.00,'910','2022-09-18 19:28:06','910','2022-09-19 22:25:47',10,0),('8','212',49,'Daily shift','2022-09-19','2022-09-19 22:26:42','2022-09-20 22:26:42','910',224505.90,224505.90,'910','2022-09-19 22:29:21','910','2022-09-20 10:10:25',10,0),('8','212',50,'Daily shift','2022-09-20','2022-09-20 20:30:36','2022-09-21 20:30:36','910',283996.80,283996.80,'910','2022-09-20 20:34:56','910','2022-09-20 20:35:29',10,0),('8','212',51,'Daily shift','2022-09-21','2022-09-21 21:45:02','2022-09-22 21:45:02','910',258730.60,258730.60,'910','2022-09-21 21:47:23','910','2022-09-21 21:49:03',10,0),('8','212',52,'Daily shift','2022-09-22','2022-09-22 22:14:21','2022-09-23 22:14:21','910',394383.00,394383.00,'910','2022-09-22 22:16:25','910','2022-09-22 22:17:01',10,0),('8','212',53,'Daily shift','2022-09-23','2022-09-23 20:07:32','2022-09-24 20:07:32','910',409358.80,409358.80,'910','2022-09-23 20:14:13','910','2022-09-23 20:15:08',10,0),('8','212',54,'Daily shift','2022-09-24','2022-09-25 07:48:05','2022-09-26 07:48:05','910',331855.90,331855.90,'910','2022-09-25 07:50:33','910','2022-09-25 07:52:13',10,0),('8','212',55,'Daily shift','2022-09-25','2022-09-26 08:21:48','2022-09-27 08:21:48','910',1931452.60,1931452.60,'910','2022-09-26 08:24:12','910','2022-09-26 08:25:21',10,0),('8','212',56,'Daily shift','2022-09-26','2022-09-27 08:08:25','2022-09-28 08:08:25','910',536869.70,536869.70,'910','2022-09-27 08:10:05','910','2022-09-27 08:10:31',10,0),('8','212',57,'Daily shift','2022-09-27','2022-09-27 19:24:43','2022-09-28 19:24:43','910',271375.10,271375.10,'910','2022-09-27 19:26:35','910','2022-09-27 19:27:12',10,0),('8','212',58,'Daily shift','2022-09-28','2022-09-28 22:16:05','2022-09-29 22:16:05','910',236563.30,236563.30,'910','2022-09-28 22:17:42','910','2022-09-28 22:18:19',10,0),('8','212',59,'Daily shift','2022-09-29','2022-09-29 19:17:07','2022-09-30 19:17:07','910',401278.10,401278.10,'910','2022-09-29 19:19:32','910','2022-09-29 19:20:20',10,0),('8','212',60,'Daily shift','2022-09-30','2022-09-30 20:48:22','2022-10-01 20:48:22','910',476518.10,476518.10,'910','2022-09-30 20:50:43','910','2022-09-30 20:51:37',10,0),('8','212',61,'Daily shift','2022-10-01','2022-10-01 20:53:45','2022-10-02 20:53:45','910',337244.30,337244.30,'910','2022-10-01 20:56:22','910','2022-10-01 20:57:07',10,0),('8','212',62,'Daily shift','2022-10-02','2022-10-02 19:11:37','2022-10-03 19:11:37','910',1011330.10,1011330.10,'910','2022-10-02 19:15:34','910','2022-10-02 19:16:05',10,0),('8','212',63,'Daily shift','2022-10-03','2022-10-03 19:11:19','2022-10-04 19:11:19','910',228932.90,228932.90,'910','2022-10-03 19:14:39','910','2022-10-03 19:15:33',10,0),('8','212',64,'Daily shift','2022-10-04','2022-10-04 15:28:09','2022-10-05 15:28:09','910',265236.20,265236.20,'910','2022-10-04 15:29:40','910','2022-10-04 15:30:22',10,0),('8','212',65,'AFTERNOON SHIFT 4/10/2022','2022-10-04','2022-10-04 15:40:23','2022-10-05 15:40:23','910',40105.20,40105.20,'910','2022-10-04 19:19:53','910','2022-10-04 19:20:51',10,0),('8','212',66,'Daily shift','2022-10-05','2022-10-05 20:39:10','2022-10-06 20:39:10','910',340645.30,340645.30,'910','2022-10-05 20:41:34','910','2022-10-05 20:42:15',10,0),('8','212',67,'Daily shift','2022-10-06','2022-10-06 18:53:29','2022-10-07 18:53:29','910',789898.40,789898.40,'910','2022-10-06 18:55:35','910','2022-10-06 18:58:26',10,0),('8','212',68,'Daily shift','2022-10-07','2022-10-07 19:21:41','2022-10-08 19:21:41','910',1347164.60,1347164.60,'910','2022-10-07 19:23:52','910','2022-10-07 19:24:44',10,0),('8','212',69,'Daily shift','2022-10-08','2022-10-08 19:04:08','2022-10-09 19:04:08','910',1231887.80,1231887.80,'910','2022-10-08 21:39:32','910','2022-10-08 21:53:33',10,0),('8','212',70,'Daily shift','2022-10-09','2022-10-10 09:30:20','2022-10-11 09:30:20','910',3219763.95,3219763.95,'910','2022-10-10 09:32:59','910','2022-10-10 09:34:37',10,0),('8','212',71,'Daily shift ','2022-10-10','2022-10-10 21:54:01','2022-10-11 21:54:01','910',4990404.90,4990404.90,'910','2022-10-10 22:11:13','910','2022-10-10 22:14:28',10,0),('8','212',72,'Daily shift','2022-10-11','2022-10-12 07:21:29','2022-10-13 07:21:29','910',0.00,0.00,'910','2022-10-12 07:26:06','910','2022-10-12 07:27:10',10,0),('8','212',73,'Daily shift','2022-10-11','2022-10-12 07:30:48','2022-10-19 07:30:48','910',2915958.84,2915958.84,'910','2022-10-12 18:50:15','910','2022-10-12 18:50:59',10,0),('8','212',74,'Daily shift','2022-10-12','2022-10-12 20:14:55','2022-10-13 20:14:55','910',2222646.80,2222646.80,'910','2022-10-12 20:17:19','910','2022-10-12 20:18:19',10,0),('8','212',75,'Daily shift','2022-10-13','2022-10-13 19:57:29','2022-10-14 19:57:29','910',2965630.80,2965630.80,'910','2022-10-13 20:00:27','910','2022-10-13 20:01:07',10,0),('8','212',76,'Daily shift','2022-10-14','2022-10-14 22:42:08','2022-10-15 22:42:08','910',2010509.60,2010509.60,'910','2022-10-14 22:48:50','910','2022-10-14 22:51:56',10,0),('8','212',77,'Daily shift','2022-10-15','2022-10-15 20:07:10','2022-10-16 20:07:10','910',0.00,0.00,'910','2022-10-16 21:34:03','910','2022-10-16 21:34:38',10,0),('8','212',78,'Daily shift','2022-10-15','2022-10-16 21:36:07','2022-10-23 21:36:07','910',1529804.25,1529804.25,'467','2022-10-20 13:27:52','467','2022-10-20 13:28:43',10,0),('8','212',79,'Daily shift','2022-10-16','2022-10-20 13:34:15','2022-10-21 13:34:15','910',2646258.75,2646258.75,'910','2022-10-20 13:36:07','910','2022-10-20 13:36:49',10,0),('8','212',80,'Daily shift','2022-10-17','2022-10-20 13:41:31','2022-10-21 13:41:31','910',1287094.50,1287094.50,'910','2022-10-20 13:57:27','910','2022-10-20 13:58:00',10,0),('8','212',81,'Daily shift','2022-10-20','2022-10-20 18:51:49','2022-10-21 18:51:49','910',2204814.50,2204814.50,'910','2022-10-20 18:53:50','910','2022-10-20 18:54:30',10,0),('8','212',82,'Daily shift','2022-10-21','2022-10-21 19:11:23','2022-10-22 19:11:23','910',1273040.80,1273040.80,'910','2022-10-21 19:23:30','910','2022-10-21 19:24:27',10,0),('8','212',83,'Daily shift','2022-10-22','2022-10-22 20:30:03','2022-10-23 20:30:03','910',1124827.50,1124827.50,'910','2022-10-22 20:32:39','910','2022-10-22 20:33:29',10,0),('8','212',84,'Daily shift','2022-10-23','2022-10-23 18:29:31','2022-10-24 18:29:31','910',1886894.90,1886894.90,'910','2022-10-23 18:32:32','910','2022-10-23 18:33:19',10,0),('8','212',85,'Daily shift','2022-10-24','2022-10-25 07:52:04','2022-10-26 07:52:04','910',886826.55,886826.55,'910','2022-10-25 11:12:50','910','2022-10-25 11:14:09',10,0),('8','212',86,'Daily shift','2022-10-25','2022-10-25 20:12:53','2022-10-26 20:12:53','910',2358434.15,2358434.15,'910','2022-10-25 20:15:25','910','2022-10-25 20:15:54',10,0),('8','212',87,'Daily shift','2022-10-26','2022-10-27 05:08:00','2022-10-28 05:08:00','910',0.00,0.00,'910','2022-10-27 05:19:58','910','2022-10-27 05:20:31',10,0),('8','212',88,'Daily shift','2022-10-26','2022-10-27 05:21:42','2022-10-28 05:21:42','910',929680.00,929680.00,'910','2022-10-27 05:23:09','910','2022-10-27 05:23:43',10,0),('8','212',89,'Daily shift','2022-10-27','2022-10-28 07:41:29','2022-10-29 07:41:29','910',1280637.50,1280637.50,'910','2022-10-28 07:45:57','910','2022-10-28 07:46:46',10,0),('8','212',90,'Daily shift','2022-10-28','2022-10-28 19:54:27','2022-10-29 19:54:27','910',1862450.00,1862450.00,'910','2022-10-28 19:56:16','910','2022-10-28 19:57:02',10,0),('8','212',91,'Daily shift','2022-10-30','2022-10-30 18:30:24','2022-10-31 18:30:24','910',1374487.50,1374487.50,'910','2022-11-04 20:40:10','910','2022-11-04 20:41:08',10,0),('8','212',92,'Daily shift','2022-11-05','2022-11-05 18:26:06','2022-11-06 18:26:06','910',478020.45,478020.45,'910','2022-11-05 18:28:57','910','2022-11-05 18:29:33',10,0),('8','212',93,'Daily shift','2022-11-06','2022-11-06 21:14:33','2022-11-07 21:14:33','910',688500.00,688500.00,'910','2022-11-06 21:18:42','910','2022-11-06 21:19:31',10,0),('8','212',94,'Daily shift','2022-11-06','2022-11-06 21:24:52','2022-11-07 21:24:52','910',2098722.50,2098722.50,'910','2022-11-06 21:27:36','910','2022-11-06 21:28:32',10,0),('8','212',95,'Daily shift','2022-11-07','2022-11-07 21:27:22','2022-11-08 21:27:22','910',1308097.50,1308097.50,'910','2022-11-07 21:30:14','910','2022-11-07 21:30:49',10,0),('8','212',96,'Daily shift ','2022-11-08','2022-11-08 20:39:59','2022-11-09 20:39:59','910',1504165.00,1504165.00,'910','2022-11-08 20:42:21','910','2022-11-08 20:49:52',10,0),('8','212',97,'Daily shift','2022-11-09','2022-11-09 19:07:07','2022-11-10 19:07:07','910',1786335.00,1786335.00,'910','2022-11-09 19:10:01','910','2022-11-09 19:10:45',10,0),('8','212',98,'Daily shift','2022-11-10','2022-11-10 18:40:08','2022-11-11 18:40:08','910',1773220.00,1773220.00,'910','2022-11-10 18:43:48','910','2022-11-10 18:45:02',10,0),('8','212',99,'Daily shift','2022-11-11','2022-11-11 19:21:05','2022-11-12 19:21:05','910',1671802.50,1671802.50,'910','2022-11-11 19:23:31','910','2022-11-11 19:24:13',10,0),('8','212',100,'Daily shift','2022-11-12','2022-11-12 18:37:12','2022-11-13 18:37:12','910',2025752.50,2025752.50,'910','2022-11-12 18:39:01','910','2022-11-12 18:39:44',10,0),('8','212',101,'Daily shift','2022-11-13','2022-11-14 11:37:33','2022-11-15 11:37:33','910',1644081.90,1644081.90,'910','2022-11-15 20:22:47','910','2022-11-15 20:23:24',10,0),('8','212',102,'Daily shift','2022-11-14','2022-11-15 20:28:46','2022-11-16 20:28:46','910',780279.60,780279.60,'910','2022-11-15 20:32:02','910','2022-11-15 20:32:37',10,0),('8','212',103,'Daily shift','2022-11-15','2022-11-15 20:36:06','2022-11-16 20:36:06','910',1462386.75,1462386.75,'910','2022-11-15 20:38:01','910','2022-11-15 20:38:39',10,0),('8','212',104,'Daily shift','2022-11-16','2022-11-17 09:34:42','2022-11-18 09:34:42','910',1406837.55,1406837.55,'910','2022-11-17 13:00:43','910','2022-11-17 13:01:34',10,0),('8','212',105,'Daily shift','2022-11-17','2022-11-18 12:14:34','2022-11-19 12:14:34','910',1579046.70,1579046.70,'910','2022-11-18 12:16:19','910','2022-11-18 12:16:58',10,0),('8','212',106,'Daily shift','2022-11-18','2022-11-18 18:59:51','2022-11-19 18:59:51','910',1858442.55,1858442.55,'910','2022-11-18 19:02:09','910','2022-11-18 19:02:44',10,0),('8','212',107,'Daily shift','2022-11-19','2022-11-20 06:53:47','2022-11-21 06:53:47','910',1376199.30,1376199.30,'910','2022-11-20 06:55:39','910','2022-11-20 06:56:11',10,0),('8','212',108,'Daily shift','2022-11-20','2022-11-20 19:50:23','2022-11-21 19:50:23','910',2126707.65,2126707.65,'910','2022-11-20 19:53:45','910','2022-11-20 19:54:19',10,0),('8','212',109,'Daily shift','2022-11-21','2022-11-22 21:12:01','2022-11-23 21:12:01','910',208521.15,208521.15,'910','2022-11-22 21:14:01','910','2022-11-22 21:14:37',10,0),('8','212',110,'Daily shift','2022-11-22','2022-11-23 07:59:03','2022-11-24 07:59:03','910',849259.65,849259.65,'910','2022-11-23 08:01:39','910','2022-11-23 08:02:27',10,0),('8','212',111,'Daily shift','2022-11-23','2022-11-24 07:38:06','2022-11-25 07:38:06','910',1318413.75,1318413.75,'910','2022-11-24 07:41:01','910','2022-11-24 07:41:34',10,0),('8','212',112,'Daily shift','2022-11-24','2022-11-25 09:31:21','2022-11-26 09:31:21','910',1639764.75,1639764.75,'910','2022-11-25 09:33:37','910','2022-11-25 09:34:10',10,0),('8','212',113,'Daily shift','2022-11-25','2022-11-25 18:56:41','2022-11-26 18:56:41','910',1468851.00,1468851.00,'910','2022-11-25 19:00:24','910','2022-11-25 19:00:55',10,0),('8','212',114,'Daily shift','2022-11-26','2022-11-27 08:35:33','2022-11-28 08:35:33','910',701760.80,701760.80,'910','2022-11-27 08:37:29','910','2022-11-27 08:37:57',10,0),('8','212',115,'Daily shift','2022-11-27','2022-11-27 18:36:58','2022-11-28 18:36:58','910',2136035.20,2136035.20,'910','2022-11-27 18:39:17','910','2022-11-27 18:39:46',10,0),('8','212',116,'Daily shift','2022-11-28','2022-12-01 18:42:26','2022-12-02 18:42:26','910',328177.20,328177.20,'910','2022-12-03 14:47:10','910','2022-12-03 14:48:08',10,0),('8','212',117,'Daily shift','2022-12-01','2022-12-03 14:51:22','2022-12-04 14:51:22','910',1594260.90,1535214.20,'910','2022-12-03 14:54:07','910','2022-12-03 14:54:47',10,0),('8','212',118,'Daily shift','2022-12-02','2022-12-03 14:57:50','2022-12-04 14:57:50','910',3717189.90,3579516.20,'910','2022-12-03 14:59:41','910','2022-12-03 15:00:25',10,0),('8','212',119,'Daily shift','2022-12-03','2022-12-03 18:54:11','2022-12-04 18:54:11','910',1083712.50,1083712.50,'910','2022-12-03 18:55:56','910','2022-12-03 18:56:37',10,0),('8','212',120,'Daily shift','2022-12-04','2022-12-05 10:06:28','2022-12-06 10:06:28','910',1718236.80,1718236.80,'910','2022-12-05 10:08:07','910','2022-12-05 10:12:01',10,0),('8','212',121,'Daily shift','2022-12-05','2022-12-06 06:01:35','2022-12-07 06:01:35','910',491421.60,491421.60,'910','2022-12-06 06:03:12','910','2022-12-06 06:03:44',10,0),('8','212',122,'Daily shift ','2022-12-06','2022-12-06 20:00:12','2022-12-07 20:00:12','910',2305959.30,2305959.30,'910','2022-12-06 20:01:56','910','2022-12-06 20:02:39',10,0),('8','212',123,'Daily shift','2022-12-07','2022-12-07 21:55:27','2022-12-08 21:55:27','910',2119063.85,2119063.85,'910','2022-12-07 22:03:22','910','2022-12-07 22:04:35',10,0),('8','212',124,'Daily shift','2022-12-14','2022-12-15 15:40:26','2022-12-16 15:40:26','910',2304698.95,2304698.95,'910','2022-12-15 15:42:27','910','2022-12-15 15:42:55',10,0),('8','212',125,'Daily shift','2022-12-15','2022-12-16 14:59:16','2022-12-17 14:59:16','910',2143311.25,2143311.25,'910','2022-12-16 15:01:07','910','2022-12-16 15:01:41',10,0),('8','212',126,'Daily shift','2022-12-16','2022-12-17 11:15:16','2022-12-18 11:15:16','910',741012.75,741012.75,'910','2022-12-17 11:17:41','910','2022-12-17 11:18:44',10,0),('8','212',127,'Daily shift','2022-12-16','2022-12-17 11:23:24','2022-12-18 11:23:24','910',606026.70,606026.70,'910','2022-12-17 11:26:03','910','2022-12-17 11:26:53',10,0),('8','212',128,'Daily shift','2022-12-17','2022-12-18 13:35:38','2022-12-19 13:35:38','910',1085266.60,1085266.60,'910','2022-12-18 13:37:33','910','2022-12-18 13:38:08',10,0),('8','212',129,'Daily shift','2022-12-20','2022-12-21 19:16:37','2022-12-22 19:16:37','910',539545.10,539545.10,'910','2022-12-21 19:18:25','910','2022-12-21 19:19:31',10,0),('8','212',130,'Daily shift','2022-12-21','2022-12-22 12:06:14','2022-12-23 12:06:14','910',1535919.80,916597.30,'910','2022-12-22 12:07:44','910','2022-12-22 12:08:05',10,0),('8','212',131,'Daily shift','2022-12-24','2022-12-25 14:01:54','2022-12-26 14:01:54','910',561391.40,335023.90,'910','2022-12-25 14:03:51','910','2022-12-25 14:04:46',10,0),('8','212',132,'Daily shift','2022-12-27','2022-12-28 11:44:35','2022-12-29 11:44:35','910',658145.50,392764.25,'910','2022-12-28 11:46:00','910','2022-12-28 11:46:27',10,0),('8','212',133,'Daily shift','2022-12-29','2022-12-30 20:59:48','2022-12-31 20:59:48','910',552218.50,329549.75,'910','2022-12-30 21:01:06','910','2022-12-30 21:01:39',10,0),('8','212',134,'Daily shift','2023-01-01','2023-01-01 21:56:04','2023-01-02 21:56:04','910',2156598.00,2156598.00,'910','2023-01-01 21:58:30','910','2023-01-01 21:59:21',10,0),('8','212',135,'Daily shift','2023-01-03','2023-01-04 21:32:27','2023-01-05 21:32:27','910',361523.30,361523.30,'910','2023-01-04 21:33:40','910','2023-01-04 21:34:06',10,0),('8','212',136,'Daily shift','2023-01-05','2023-01-06 09:35:13','2023-01-07 09:35:13','910',1250856.00,1250856.00,'910','2023-01-06 09:37:28','910','2023-01-06 09:38:09',10,0),('8','212',137,'Daily shift','2023-01-06','2023-01-07 12:53:23','2023-01-08 12:53:23','910',622587.90,622587.90,'910','2023-01-07 12:55:28','910','2023-01-07 12:55:52',10,0),('8','212',138,'Daily shift','2023-01-26','2023-01-27 23:01:25','2023-01-28 23:01:25','910',1714937.25,1714937.25,'910','2023-01-27 23:03:38','910','2023-01-27 23:04:15',10,0),('8','212',139,'Daily shift','2023-01-29','2023-01-30 17:28:52','2023-01-31 17:28:52','910',1930464.48,1930464.48,'910','2023-01-30 17:30:26','910','2023-01-30 17:30:48',10,0),('8','212',140,'Daily shift','2023-01-30','2023-01-31 14:37:46','2023-02-01 14:37:46','910',1083885.60,1083885.60,'910','2023-01-31 14:39:10','910','2023-01-31 14:39:37',10,0),('8','212',141,'Daily shift','2023-01-31','2023-02-01 09:59:56','2023-02-02 09:59:56','910',689206.50,689206.50,'910','2023-02-01 10:07:44','910','2023-02-01 10:08:06',10,0),('8','212',142,'Daily shift','2023-02-01','2023-02-02 20:37:11','2023-02-03 20:37:11','910',1154273.40,1154273.40,'910','2023-02-02 20:39:10','910','2023-02-02 20:39:37',10,0),('8','212',143,'Daily shift','2023-02-02','2023-02-03 18:57:35','2023-02-04 18:57:35','910',1618215.60,1618215.60,'910','2023-02-03 18:59:14','910','2023-02-03 18:59:47',10,0),('8','212',144,'Daily shift','2023-02-03','2023-02-06 08:21:50','2023-02-07 08:21:50','910',2461336.95,2461336.95,'910','2023-02-06 08:23:33','910','2023-02-06 08:23:59',10,0),('8','212',145,'Daily shift','2023-02-05','2023-02-07 10:38:07','2023-02-08 10:38:07','910',933207.75,933207.75,'910','2023-02-07 10:39:52','910','2023-02-07 10:40:13',10,0),('8','212',146,'Daily shift','2023-02-06','2023-02-10 08:32:10','2023-02-11 08:32:10','910',1051497.90,1051497.90,'910','2023-02-16 19:53:12','910','2023-02-16 19:53:35',10,0),('8','212',147,'Daily shift','2023-02-16','2023-02-17 19:34:00','2023-02-18 19:34:00','910',1498767.60,1498767.60,'910','2023-02-17 19:36:57','910','2023-02-17 19:37:29',10,0),('8','212',148,'Daily shift','2023-02-17','2023-02-21 10:37:04','2023-02-22 10:37:04','910',710402.80,710402.80,'910','2023-02-21 10:38:40','910','2023-02-21 10:39:46',10,0),('8','212',149,'Daily shift','2023-02-18','2023-02-21 10:41:40','2023-02-22 10:41:40','910',737711.60,737711.60,'910','2023-02-21 10:43:19','910','2023-02-21 10:44:01',10,0),('8','212',150,'Daily shift','2023-02-19','2023-02-21 10:46:05','2023-02-22 10:46:05','910',2162019.20,2162019.20,'910','2023-02-21 10:49:16','910','2023-02-21 10:49:52',10,0),('8','212',151,'Daily shift','2023-02-20','2023-02-21 10:54:48','2023-02-22 10:54:48','910',1137055.20,1137055.20,'910','2023-02-21 10:56:34','910','2023-02-21 10:57:06',10,0),('8','212',152,'Daily shift','2023-02-21','2023-02-23 21:53:33','2023-02-24 21:53:33','910',688727.80,688727.80,'910','2023-02-23 21:55:11','910','2023-02-23 21:55:30',10,0),('8','212',153,'Daily shift','2023-02-22','2023-02-23 21:59:20','2023-02-24 21:59:20','910',1156595.20,1156595.20,'910','2023-02-23 22:01:03','910','2023-02-23 22:01:31',10,0),('8','212',154,'Daily shift','2023-02-23','2023-02-24 08:56:38','2023-02-25 08:56:38','910',682278.40,682278.40,'910','2023-02-24 08:58:29','910','2023-02-24 08:58:52',10,0),('8','212',155,'Daily shift','2023-02-24','2023-02-27 09:08:39','2023-02-28 09:08:39','910',955337.60,955337.60,'910','2023-02-27 09:13:57','910','2023-02-27 09:15:23',10,0),('8','212',156,'Daily shift','2023-02-26','2023-02-27 09:17:12','2023-02-28 09:17:12','910',1905596.80,1905596.80,'910','2023-02-27 09:18:51','910','2023-02-27 09:19:23',10,0),('8','212',157,'Daily shift','2023-02-27','2023-02-28 23:10:34','2023-03-01 23:10:34','910',1000000.00,1000000.00,'910','2023-02-28 23:12:20','910','2023-02-28 23:12:41',10,0),('8','212',158,'Daily shift','2023-02-28','2023-03-01 17:36:52','2023-03-02 17:36:52','910',1051404.80,1051404.80,'910','2023-03-01 17:38:14','910','2023-03-01 17:38:35',10,0),('8','212',159,'Daily shift','2023-03-01','2023-03-03 23:14:59','2023-03-04 23:14:59','910',860579.20,860579.20,'910','2023-03-03 23:16:43','910','2023-03-03 23:17:10',10,0),('8','212',160,'Daily shift','2023-03-02','2023-03-03 23:20:04','2023-03-04 23:20:04','910',840409.60,840409.60,'910','2023-03-03 23:21:39','910','2023-03-03 23:22:10',10,0),('8','212',161,'Daily shift','2023-03-03','2023-03-04 22:59:41','2023-03-05 22:59:41','910',1058994.00,1058994.00,'910','2023-03-04 23:01:51','910','2023-03-04 23:02:13',10,0),('8','212',162,'Daily shift','2023-03-04','2023-03-06 17:38:15','2023-03-07 17:38:15','910',887757.00,887757.00,'910','2023-03-06 17:40:41','910','2023-03-06 17:41:04',10,0),('8','212',163,'Daily shift','2023-03-05','2023-03-06 17:42:41','2023-03-07 17:42:41','910',1644354.00,1644354.00,'910','2023-03-06 17:44:20','910','2023-03-06 17:44:45',10,0),('8','212',164,'Daily shift','2023-03-06','2023-03-09 00:02:54','2023-03-10 00:02:54','910',594768.00,594768.00,'910','2023-03-09 00:04:12','910','2023-03-09 00:04:45',10,0),('8','212',165,'Daily shift','2023-03-07','2023-03-09 00:07:16','2023-03-10 00:07:16','910',473319.00,473319.00,'910','2023-03-09 23:15:27','910','2023-03-09 23:15:51',10,0),('8','212',166,'Daily shift','2023-03-08','2023-03-09 23:18:15','2023-03-10 23:18:15','910',713025.00,713025.00,'910','2023-03-09 23:19:49','910','2023-03-09 23:20:16',10,0),('8','212',167,'Daily shift','2023-03-09','2023-03-11 13:48:15','2023-03-12 13:48:15','910',818979.00,818979.00,'910','2023-03-11 13:49:31','910','2023-03-11 13:49:58',10,0),('8','212',168,'Daily shift','2023-03-10','2023-03-11 13:51:44','2023-03-12 13:51:44','910',1181796.00,1181796.00,'910','2023-03-11 13:53:09','910','2023-03-11 13:53:34',10,0),('8','212',169,'Daily shift','2023-03-12','2023-03-13 17:07:17','2023-03-14 17:07:17','910',3009384.00,3009384.00,'910','2023-03-13 17:08:57','910','2023-03-13 17:09:16',10,0),('8','212',170,'Daily shift','2023-03-13','2023-03-18 13:41:10','2023-03-19 13:41:10','910',1086264.00,1086264.00,'910','2023-03-18 13:42:38','910','2023-03-18 13:43:06',10,0),('8','212',171,'Daily shifted ','2023-03-14','2023-03-18 13:46:30','2023-03-19 13:46:30','910',992754.00,992754.00,'910','2023-03-18 13:48:01','910','2023-03-18 13:48:24',10,0),('8','212',172,'Daily shift','2023-03-15','2023-03-18 13:50:29','2023-03-19 13:50:29','910',1046916.00,1046916.00,'910','2023-03-18 13:52:22','910','2023-03-18 13:53:00',10,0),('8','212',173,'Daily shift','2023-03-16','2023-03-18 13:55:53','2023-03-19 13:55:53','910',1136550.00,1136550.00,'910','2023-03-18 13:57:43','910','2023-03-18 13:58:13',10,0),('8','212',174,'Daily shift','2023-03-17','2023-03-18 14:03:32','2023-03-19 14:03:32','910',966654.00,966654.00,'910','2023-03-20 08:43:18','910','2023-03-20 08:43:35',10,0),('8','212',175,'Daily shift','2023-03-19','2023-03-20 08:50:29','2023-03-21 08:50:29','910',3211365.30,3211365.30,'910','2023-03-20 08:53:31','910','2023-03-20 08:53:56',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=876 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('8','212','1','7',31,'1','1',19351.31,19351.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','7',32,'2','1',120893.29,120893.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','7',33,'3','1',352909.37,352909.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','7',34,'4','1',2543877.35,2543877.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','7',35,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','8',36,'1','1',83566.82,83566.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','8',37,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','8',38,'3','1',414820.51,415077.58,257.07,55270.05,0.00,0.00,0.00,0.00,0.00),('8','212','2','8',39,'4','1',2618645.53,2619047.25,401.72,86369.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','8',40,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','9',41,'1','1',83566.82,83566.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','9',42,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','9',43,'3','1',415077.58,415920.81,843.23,181294.45,0.00,0.00,0.00,0.00,0.00),('8','212','2','9',44,'4','1',2619047.25,2619311.40,264.15,56792.25,0.00,0.00,0.00,0.00,0.00),('8','212','3','9',45,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','10',46,'1','1',83566.82,83566.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','10',47,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','10',48,'3','1',415920.81,416775.66,854.85,183792.75,0.00,0.00,0.00,0.00,0.00),('8','212','2','10',49,'4','1',2619311.40,2619930.59,619.19,133125.85,0.00,0.00,0.00,0.00,0.00),('8','212','3','10',50,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','11',51,'1','1',83566.82,83566.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','11',52,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','11',53,'3','1',416775.66,417124.66,349.00,75035.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','11',54,'4','1',2619930.59,2620604.49,673.90,144888.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','11',55,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','12',56,'1','1',83566.82,84883.69,1316.87,283127.05,0.00,0.00,0.00,0.00,0.00),('8','212','1','12',57,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','12',58,'3','1',417124.66,418938.08,1813.42,389885.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','12',59,'4','1',2620604.49,2621319.33,714.84,153690.60,0.00,0.00,0.00,0.00,0.00),('8','212','3','12',60,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','13',61,'1','1',84883.69,85174.30,290.61,62481.15,0.00,0.00,0.00,0.00,0.00),('8','212','1','13',62,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','13',63,'3','1',418938.08,419461.26,523.18,112483.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','13',64,'4','1',2621319.33,2621319.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','13',65,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','14',66,'1','1',85174.30,85533.14,358.84,77150.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','14',67,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','14',68,'3','1',419461.26,420079.92,618.66,133011.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','14',69,'4','1',2621319.33,2621319.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','14',70,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','15',71,'1','1',85533.14,86112.34,579.20,124528.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','15',72,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','15',73,'3','1',420079.92,420687.32,607.40,130591.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','15',74,'4','1',2621319.33,2621319.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','15',75,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','16',76,'1','1',86112.34,86902.80,790.46,169948.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','16',77,'2','1',161492.27,161492.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','16',78,'3','1',420687.32,420687.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','16',79,'4','1',2621319.33,2621801.86,482.53,103743.95,0.00,0.00,0.00,0.00,0.00),('8','212','3','16',80,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','17',81,'1','1',86902.80,87129.91,227.11,48828.65,0.00,0.00,0.00,0.00,0.00),('8','212','1','17',82,'2','1',161492.27,162048.49,556.22,119587.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','17',83,'3','1',420687.32,420931.36,244.04,52468.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','17',84,'4','1',2621801.86,2621801.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','17',85,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','18',86,'1','1',87129.91,87129.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','18',87,'2','1',162048.49,162275.68,227.19,48845.85,0.00,0.00,0.00,0.00,0.00),('8','212','2','18',88,'3','1',420931.36,421544.39,613.03,131801.45,0.00,0.00,0.00,0.00,0.00),('8','212','2','18',89,'4','1',2621801.86,2621859.04,57.18,12293.70,0.00,0.00,0.00,0.00,0.00),('8','212','3','18',90,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','19',91,'1','1',87129.91,88055.74,925.83,199053.45,0.00,0.00,0.00,0.00,0.00),('8','212','1','19',92,'2','1',162275.68,163254.11,978.43,210362.45,0.00,0.00,0.00,0.00,0.00),('8','212','2','19',93,'3','1',421544.39,422453.05,908.66,195361.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','19',94,'4','1',2621859.04,2622454.75,595.71,128077.65,0.00,0.00,0.00,0.00,0.00),('8','212','3','19',95,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','20',96,'1','1',88055.74,88305.24,249.50,53642.50,0.00,0.00,0.00,0.00,0.00),('8','212','1','20',97,'2','1',163254.11,163697.70,443.59,95371.85,0.00,0.00,0.00,0.00,0.00),('8','212','2','20',98,'3','1',422453.05,422453.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','20',99,'4','1',2622454.75,2622454.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','20',100,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','21',101,'1','1',88305.24,88551.56,246.32,52958.80,0.00,0.00,0.00,0.00,0.00),('8','212','1','21',102,'2','1',163697.70,163697.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','21',103,'3','1',422453.05,422901.39,448.34,96393.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','21',104,'4','1',2622454.75,2622454.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','21',105,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','22',106,'1','1',88551.56,88551.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','22',107,'2','1',163697.70,163697.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','22',108,'3','1',422901.39,422901.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','22',109,'4','1',2622454.75,2622454.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','22',110,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','23',111,'1','1',88551.56,88705.45,153.89,29239.10,0.00,0.00,0.00,0.00,0.00),('8','212','1','23',112,'2','1',163697.70,164123.01,425.31,80808.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','23',113,'3','1',422901.39,423266.46,365.07,69363.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','23',114,'4','1',2622454.75,2622454.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','23',115,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','24',116,'1','1',88705.45,88980.62,275.17,52282.30,0.00,0.00,0.00,0.00,0.00),('8','212','1','24',117,'2','1',164123.01,164947.74,824.73,156698.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','24',118,'3','1',423266.46,423695.27,428.81,81473.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','24',119,'4','1',2622454.75,2622454.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','24',120,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','25',121,'1','1',88980.62,89074.55,93.93,17846.70,0.00,0.00,0.00,0.00,0.00),('8','212','1','25',122,'2','1',164947.74,165312.79,365.05,69359.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','25',123,'3','1',423695.27,424385.99,690.72,131236.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','25',124,'4','1',2622454.75,2622454.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','25',125,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','26',126,'1','1',89074.55,89074.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','26',127,'2','1',165312.79,166285.25,972.46,184767.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','26',128,'3','1',424385.99,425288.24,902.25,171427.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','26',129,'4','1',2622454.75,2622454.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','26',130,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','27',131,'1','1',89074.55,90139.38,1064.83,202317.70,0.00,0.00,0.00,0.00,0.00),('8','212','1','27',132,'2','1',166285.25,166886.71,601.46,114277.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','27',133,'3','1',425288.24,425770.14,481.90,91561.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','27',134,'4','1',2622454.75,2623321.66,866.91,164712.90,0.00,0.00,0.00,0.00,0.00),('8','212','3','27',135,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','28',136,'1','1',90139.38,90139.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','28',137,'2','1',166886.71,167317.66,430.95,81880.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','28',138,'3','1',425770.14,426026.54,256.40,48716.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','28',139,'4','1',2623321.66,2623321.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','28',140,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','29',141,'1','1',90139.38,90560.11,420.73,79938.70,0.00,0.00,0.00,0.00,0.00),('8','212','1','29',142,'2','1',167317.66,167548.52,230.86,43863.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','29',143,'3','1',426026.54,426558.65,532.11,101100.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','29',144,'4','1',2623321.66,2623321.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','29',145,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','30',146,'1','1',90560.11,90804.07,243.96,46352.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','30',147,'2','1',167548.52,167630.84,82.32,15640.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','30',148,'3','1',426558.65,427142.55,583.90,110941.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','30',149,'4','1',2623321.66,2624172.22,850.56,161606.40,0.00,0.00,0.00,0.00,0.00),('8','212','3','30',150,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','31',151,'1','1',90804.07,91837.36,1033.29,196325.10,0.00,0.00,0.00,0.00,0.00),('8','212','1','31',152,'2','1',167630.84,167734.36,103.52,19668.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','31',153,'3','1',427142.55,427643.79,501.24,95235.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','31',154,'4','1',2624172.22,2624172.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','31',155,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','32',156,'1','1',91837.36,92242.37,405.01,76951.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','32',157,'2','1',167734.36,169282.95,1548.59,294232.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','32',158,'3','1',427643.79,428442.25,798.46,151707.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','32',159,'4','1',2624172.22,2625671.46,1499.24,284855.60,0.00,0.00,0.00,0.00,0.00),('8','212','3','32',160,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','33',161,'1','1',92242.37,92423.95,181.58,34500.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','33',162,'2','1',169282.95,170891.80,1608.85,305681.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','33',163,'3','1',428442.25,429827.41,1385.16,263180.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','33',164,'4','1',2625671.46,2625671.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','33',165,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','34',166,'1','1',92423.95,95264.24,2840.29,539655.10,0.00,0.00,0.00,0.00,0.00),('8','212','1','34',167,'2','1',170891.80,172323.07,1431.27,271941.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','34',168,'3','1',429827.41,431681.21,1853.80,352222.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','34',169,'4','1',2625671.46,2627038.91,1367.45,259815.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','34',170,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','35',171,'1','1',95264.24,95264.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','35',172,'2','1',172323.07,173331.87,1008.80,191672.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','35',173,'3','1',431681.21,432308.84,627.63,119249.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','35',174,'4','1',2627038.91,2627038.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','35',175,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','36',176,'1','1',95264.24,95557.74,293.50,55765.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','36',177,'2','1',173331.87,173374.87,43.00,8170.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','36',178,'3','1',432308.84,433236.86,928.02,176323.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','36',179,'4','1',2627038.91,2627038.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','36',180,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','37',181,'1','1',95557.74,95557.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','37',182,'2','1',173374.87,173901.44,526.57,100048.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','37',183,'3','1',433236.86,433477.95,241.09,45807.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','37',184,'4','1',2627038.91,2627038.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','37',185,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','38',186,'1','1',95557.74,96130.65,572.91,108852.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','38',187,'2','1',173901.44,174182.46,281.02,53393.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','38',188,'3','1',433477.95,434448.98,971.03,184495.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','38',189,'4','1',2627038.91,2627038.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','38',190,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','39',191,'1','1',96130.65,96274.89,144.24,27405.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','39',192,'2','1',174182.46,174335.53,153.07,29083.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','39',193,'3','1',434448.98,435100.40,651.42,123769.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','39',194,'4','1',2627038.91,2627428.17,389.26,73959.40,0.00,0.00,0.00,0.00,0.00),('8','212','3','39',195,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','40',196,'1','1',96274.89,96274.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','40',197,'2','1',174335.53,175033.51,697.98,132616.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','40',198,'3','1',435100.40,436017.83,917.43,174311.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','40',199,'4','1',2627428.17,2627428.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','40',200,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','41',201,'1','1',96274.89,98317.35,2042.46,388067.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','41',202,'2','1',175033.51,177088.23,2054.72,390396.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','41',203,'3','1',436017.83,438869.06,2851.23,541733.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','41',204,'4','1',2627428.17,2629559.42,2131.25,404937.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','41',205,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','42',206,'1','1',98317.35,98416.56,99.21,18849.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','42',207,'2','1',177088.23,178944.86,1856.63,352759.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','42',208,'3','1',438869.06,441712.37,2843.31,540228.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','42',209,'4','1',2629559.42,2629559.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','42',210,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','43',211,'1','1',98416.56,99924.67,1508.11,286540.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','43',212,'2','1',178944.86,179239.14,294.28,55913.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','43',213,'3','1',441712.37,443408.70,1696.33,322302.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','43',214,'4','1',2629559.42,2629559.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','43',215,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','44',216,'1','1',99924.67,99924.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','44',217,'2','1',179239.14,181229.76,1990.62,378217.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','44',218,'3','1',443408.70,444281.52,872.82,165835.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','44',219,'4','1',2629559.42,2629559.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','44',220,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','45',221,'1','1',99924.67,101082.56,1157.89,219999.10,0.00,0.00,0.00,0.00,0.00),('8','212','1','45',222,'2','1',181229.76,181229.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','45',223,'3','1',444281.52,445422.17,1140.65,216723.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','45',224,'4','1',2629559.42,2630026.51,467.09,88747.10,0.00,0.00,0.00,0.00,0.00),('8','212','3','45',225,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','46',226,'1','1',101082.56,101087.82,5.26,999.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','46',227,'2','1',181229.76,182549.57,1319.81,250763.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','46',228,'3','1',445422.17,446533.43,1111.26,211139.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','46',229,'4','1',2630026.51,2630026.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','46',230,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','47',231,'1','1',101087.82,101087.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','47',232,'2','1',182549.57,183105.01,555.44,105533.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','47',233,'3','1',446533.43,447247.03,713.60,135584.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','47',234,'4','1',2630026.51,2630026.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','47',235,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','48',236,'1','1',101087.82,102874.82,1787.00,339530.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','48',237,'2','1',183105.01,184396.63,1291.62,245407.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','48',238,'3','1',447247.03,448452.04,1205.01,228951.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','48',239,'4','1',2630026.51,2631094.08,1067.57,202838.30,0.00,0.00,0.00,0.00,0.00),('8','212','3','48',240,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','49',241,'1','1',102874.82,103257.12,382.30,72637.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','49',242,'2','1',184396.63,184523.41,126.78,24088.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','49',243,'3','1',448452.04,449124.57,672.53,127780.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','49',244,'4','1',2631094.08,2631094.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','49',245,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','50',246,'1','1',103257.12,103762.99,505.87,96115.30,0.00,0.00,0.00,0.00,0.00),('8','212','1','50',247,'2','1',184523.41,184689.31,165.90,31521.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','50',248,'3','1',449124.57,449947.52,822.95,156360.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','50',249,'4','1',2631094.08,2631094.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','50',250,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','51',251,'1','1',103762.99,103762.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','51',252,'2','1',184689.31,185352.92,663.61,126085.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','51',253,'3','1',449947.52,450645.65,698.13,132644.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','51',254,'4','1',2631094.08,2631094.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','51',255,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','52',256,'1','1',103762.99,104549.33,786.34,149404.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','52',257,'2','1',185352.92,185652.27,299.35,56876.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','52',258,'3','1',450645.65,451635.66,990.01,188101.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','52',259,'4','1',2631094.08,2631094.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','52',260,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','53',261,'1','1',104549.33,104745.64,196.31,37298.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','53',262,'2','1',185652.27,186260.69,608.42,115599.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','53',263,'3','1',451635.66,452985.45,1349.79,256460.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','53',264,'4','1',2631094.08,2631094.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','53',265,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','54',266,'1','1',104745.64,104745.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','54',267,'2','1',186260.69,187262.97,1002.28,190433.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','54',268,'3','1',452985.45,453729.78,744.33,141422.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','54',269,'4','1',2631094.08,2631094.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','54',270,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','55',271,'1','1',104745.64,108235.68,3490.04,663107.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','55',272,'2','1',187262.97,189663.46,2400.49,456093.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','55',273,'3','1',453729.78,456025.15,2295.37,436120.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','55',274,'4','1',2631094.08,2633073.72,1979.64,376131.60,0.00,0.00,0.00,0.00,0.00),('8','212','3','55',275,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','56',276,'1','1',108235.68,109250.43,1014.75,192802.50,0.00,0.00,0.00,0.00,0.00),('8','212','1','56',277,'2','1',189663.46,190129.59,466.13,88564.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','56',278,'3','1',456025.15,457369.90,1344.75,255502.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','56',279,'4','1',2633073.72,2633073.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','56',280,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','57',281,'1','1',109250.43,109250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','57',282,'2','1',190129.59,190129.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','57',283,'3','1',457369.90,458261.46,891.56,169396.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','57',284,'4','1',2633073.72,2633610.45,536.73,101978.70,0.00,0.00,0.00,0.00,0.00),('8','212','3','57',285,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','58',286,'1','1',109250.43,109250.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','58',287,'2','1',190129.59,190129.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','58',288,'3','1',458261.46,458910.31,648.85,123281.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','58',289,'4','1',2633610.45,2634206.67,596.22,113281.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','58',290,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','59',291,'1','1',109250.43,110266.26,1015.83,193007.70,0.00,0.00,0.00,0.00,0.00),('8','212','1','59',292,'2','1',190129.59,190129.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','59',293,'3','1',458910.31,459896.87,986.56,187446.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','59',294,'4','1',2634206.67,2634316.27,109.60,20824.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','59',295,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','60',296,'1','1',110266.26,111486.80,1220.54,231902.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','60',297,'2','1',190129.59,190346.77,217.18,41264.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','60',298,'3','1',459896.87,460967.14,1070.27,203351.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','60',299,'4','1',2634316.27,2634316.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','60',300,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','61',301,'1','1',111486.80,111899.06,412.26,78329.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','61',302,'2','1',190346.77,191343.17,996.40,189316.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','61',303,'3','1',460967.14,461333.45,366.31,69598.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','61',304,'4','1',2634316.27,2634316.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','61',305,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','62',306,'1','1',111899.06,113845.54,1946.48,369831.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','62',307,'2','1',191343.17,192713.22,1370.05,260309.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','62',308,'3','1',461333.45,462618.67,1285.22,244191.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','62',309,'4','1',2634316.27,2635037.31,721.04,136997.60,0.00,0.00,0.00,0.00,0.00),('8','212','3','62',310,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','63',311,'1','1',113845.54,114211.37,365.83,69507.70,0.00,0.00,0.00,0.00,0.00),('8','212','1','63',312,'2','1',192713.22,192889.51,176.29,33495.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','63',313,'3','1',462618.67,463281.46,662.79,125930.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','63',314,'4','1',2635037.31,2635037.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','63',315,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','64',316,'1','1',114211.37,114881.94,670.57,127408.30,0.00,0.00,0.00,0.00,0.00),('8','212','1','64',317,'2','1',192889.51,193181.03,291.52,55388.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','64',318,'3','1',463281.46,463715.35,433.89,82439.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','64',319,'4','1',2635037.31,2635037.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','64',320,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','65',321,'1','1',114881.94,115027.52,145.58,27660.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','65',322,'2','1',193181.03,193181.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','65',323,'3','1',463715.35,463780.85,65.50,12445.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','65',324,'4','1',2635037.31,2635037.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','65',325,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','66',326,'1','1',115027.52,115213.93,186.41,35417.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','66',327,'2','1',193181.03,194082.81,901.78,171338.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','66',328,'3','1',463780.85,464485.53,704.68,133889.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','66',329,'4','1',2635037.31,2635037.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','66',330,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','67',331,'1','1',115213.93,117523.20,2309.27,438761.30,0.00,0.00,0.00,0.00,0.00),('8','212','1','67',332,'2','1',194082.81,194082.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','67',333,'3','1',464485.53,466333.62,1848.09,351137.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','67',334,'4','1',2635037.31,2635037.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','67',335,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','68',336,'1','1',117523.20,118366.26,843.06,160181.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','68',337,'2','1',194082.81,197182.46,3099.65,588933.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','68',338,'3','1',466333.62,469481.25,3147.63,598049.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','68',339,'4','1',2635037.31,2635037.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','68',340,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','69',341,'1','1',118366.26,119516.94,1150.68,218629.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','69',342,'2','1',197182.46,198744.48,1562.02,296783.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','69',343,'3','1',469481.25,472210.35,2729.10,518529.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','69',344,'4','1',2635037.31,2636079.13,1041.82,197945.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','69',345,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','70',346,'1','1',119516.94,125556.45,6039.51,1177704.45,0.00,0.00,0.00,0.00,0.00),('8','212','1','70',347,'2','1',198744.48,200364.26,1619.78,315857.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','70',348,'3','1',472210.35,475327.52,3117.17,607848.15,0.00,0.00,0.00,0.00,0.00),('8','212','2','70',349,'4','1',2636079.13,2641814.28,5735.15,1118354.25,0.00,0.00,0.00,0.00,0.00),('8','212','3','70',350,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','71',351,'1','1',125556.45,132971.63,7415.18,1445960.10,0.00,0.00,0.00,0.00,0.00),('8','212','1','71',352,'2','1',200364.26,206209.81,5845.55,1139882.25,0.00,0.00,0.00,0.00,0.00),('8','212','2','71',353,'3','1',475327.52,482640.06,7312.54,1425945.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','71',354,'4','1',2641814.28,2646832.83,5018.55,978617.25,0.00,0.00,0.00,0.00,0.00),('8','212','3','71',355,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','72',356,'1','1',132971.63,132971.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','72',357,'2','1',206209.81,206209.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','72',358,'3','1',482640.06,482640.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','72',359,'4','1',2646832.83,2646832.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','72',360,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','73',361,'1','1',132971.63,134652.93,1681.30,346347.80,0.00,0.00,0.00,0.00,0.00),('8','212','1','73',362,'2','1',206209.81,212009.47,5799.66,1194729.96,0.00,0.00,0.00,0.00,0.00),('8','212','2','73',363,'3','1',482640.06,486306.38,3666.32,755261.92,0.00,0.00,0.00,0.00,0.00),('8','212','2','73',364,'4','1',2646832.83,2649840.69,3007.86,619619.16,0.00,0.00,0.00,0.00,0.00),('8','212','3','73',365,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','74',366,'1','1',134652.93,138032.14,3379.21,743426.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','74',367,'2','1',212009.47,215646.05,3636.58,800047.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','74',368,'3','1',486306.38,487847.98,1541.60,339152.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','74',369,'4','1',2649840.69,2651386.24,1545.55,340021.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','74',370,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','75',371,'1','1',138032.14,142228.54,4196.40,923208.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','75',372,'2','1',215646.05,219898.56,4252.51,935552.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','75',373,'3','1',487847.98,491219.94,3371.96,741831.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','75',374,'4','1',2651386.24,2653045.51,1659.27,365039.40,0.00,0.00,0.00,0.00,0.00),('8','212','3','75',375,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','76',376,'1','1',142228.54,146078.29,3849.75,846945.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','76',377,'2','1',219898.56,222221.21,2322.65,510983.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','76',378,'3','1',491219.94,492607.43,1387.49,305247.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','76',379,'4','1',2653045.51,2654624.30,1578.79,347333.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','76',380,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','77',381,'1','1',146078.29,146078.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','77',382,'2','1',222221.21,222221.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','77',383,'3','1',492607.43,492607.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','77',384,'4','1',2654624.30,2654624.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','77',385,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','78',386,'1','1',146078.29,147485.04,1406.75,316518.75,0.00,0.00,0.00,0.00,0.00),('8','212','1','78',387,'2','1',222221.21,224322.33,2101.12,472752.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','78',388,'3','1',492607.43,493495.14,887.71,199734.75,0.00,0.00,0.00,0.00,0.00),('8','212','2','78',389,'4','1',2654624.30,2657027.85,2403.55,540798.75,0.00,0.00,0.00,0.00,0.00),('8','212','3','78',390,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','79',391,'1','1',147485.04,151691.32,4206.28,946413.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','79',392,'2','1',224322.33,231877.20,7554.87,1699845.75,0.00,0.00,0.00,0.00,0.00),('8','212','2','79',393,'3','1',493495.14,493495.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','79',394,'4','1',2657027.85,2657027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','79',395,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','80',396,'1','1',151691.32,155229.25,3537.93,796034.25,0.00,0.00,0.00,0.00,0.00),('8','212','1','80',397,'2','1',231877.20,234059.69,2182.49,491060.25,0.00,0.00,0.00,0.00,0.00),('8','212','2','80',398,'3','1',493495.14,493495.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','80',399,'4','1',2657027.85,2657027.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','80',400,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','81',401,'1','1',155229.25,158944.53,3715.28,854514.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','81',402,'2','1',234059.69,235296.24,1236.55,284406.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','81',403,'3','1',493495.14,497031.20,3536.06,813293.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','81',404,'4','1',2657027.85,2658126.11,1098.26,252599.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','81',405,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','82',406,'1','1',158944.53,159594.45,649.92,149481.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','82',407,'2','1',235296.24,237565.18,2268.94,521856.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','82',408,'3','1',497031.20,499330.62,2299.42,528866.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','82',409,'4','1',2658126.11,2658442.79,316.68,72836.40,0.00,0.00,0.00,0.00,0.00),('8','212','3','82',410,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','83',411,'1','1',159594.45,160129.10,534.65,125642.75,0.00,0.00,0.00,0.00,0.00),('8','212','1','83',412,'2','1',237565.18,239817.81,2252.63,529368.05,0.00,0.00,0.00,0.00,0.00),('8','212','2','83',413,'3','1',499330.62,501329.84,1999.22,469816.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','83',414,'4','1',2658442.79,2658442.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','83',415,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','84',416,'1','1',160129.10,163045.37,2916.27,685323.45,0.00,0.00,0.00,0.00,0.00),('8','212','1','84',417,'2','1',239817.81,241557.44,1739.63,408813.05,0.00,0.00,0.00,0.00,0.00),('8','212','2','84',418,'3','1',501329.84,503279.02,1949.18,458057.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','84',419,'4','1',2658442.79,2659867.05,1424.26,334701.10,0.00,0.00,0.00,0.00,0.00),('8','212','3','84',420,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','85',421,'1','1',163045.37,164099.84,1054.47,247800.45,0.00,0.00,0.00,0.00,0.00),('8','212','1','85',422,'2','1',241557.44,242580.70,1023.26,240466.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','85',423,'3','1',503279.02,504461.34,1182.32,277845.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','85',424,'4','1',2659867.05,2660380.73,513.68,120714.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','85',425,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','86',426,'1','1',164099.84,167049.05,2949.21,693064.35,0.00,0.00,0.00,0.00,0.00),('8','212','1','86',427,'2','1',242580.70,245522.68,2941.98,691365.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','86',428,'3','1',504461.34,507081.56,2620.22,615751.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','86',429,'4','1',2660380.73,2661905.21,1524.48,358252.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','86',430,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','87',431,'1','1',167049.05,167049.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','87',432,'2','1',245522.68,245522.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','87',433,'3','1',507081.56,507081.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','87',434,'4','1',2661905.21,2661905.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','87',435,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','88',436,'1','1',167049.05,168571.04,1521.99,380497.50,0.00,0.00,0.00,0.00,0.00),('8','212','1','88',437,'2','1',245522.68,246632.74,1110.06,277515.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','88',438,'3','1',507081.56,507930.50,848.94,212235.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','88',439,'4','1',2661905.21,2662142.94,237.73,59432.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','88',440,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','89',441,'1','1',168571.04,169830.77,1259.73,314932.50,0.00,0.00,0.00,0.00,0.00),('8','212','1','89',442,'2','1',246632.74,248085.76,1453.02,363255.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','89',443,'3','1',507930.50,509472.34,1541.84,385460.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','89',444,'4','1',2662142.94,2663010.90,867.96,216990.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','89',445,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','90',446,'1','1',169830.77,171877.29,2046.52,511630.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','90',447,'2','1',248085.76,249285.80,1200.04,300010.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','90',448,'3','1',509472.34,511974.16,2501.82,625455.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','90',449,'4','1',2663010.90,2664712.32,1701.42,425355.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','90',450,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','91',451,'1','1',171877.29,172837.20,959.91,239977.50,0.00,0.00,0.00,0.00,0.00),('8','212','1','91',452,'2','1',249285.80,250266.51,980.71,245177.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','91',453,'3','1',511974.16,512943.86,969.70,242425.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','91',454,'4','1',2664712.32,2667299.95,2587.63,646907.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','91',455,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','92',456,'1','1',172837.20,173003.39,166.19,42378.45,0.00,0.00,0.00,0.00,0.00),('8','212','1','92',457,'2','1',250266.51,250947.07,680.56,173542.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','92',458,'3','1',512943.86,513971.70,1027.84,262099.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','92',459,'4','1',2667299.95,2667299.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','92',460,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','93',461,'1','1',173003.39,173708.60,705.21,179828.55,0.00,0.00,0.00,0.00,0.00),('8','212','1','93',462,'2','1',250947.07,251632.49,685.42,174782.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','93',463,'3','1',513971.70,514650.25,678.55,173030.25,0.00,0.00,0.00,0.00,0.00),('8','212','2','93',464,'4','1',2667299.95,2667930.77,630.82,160859.10,0.00,0.00,0.00,0.00,0.00),('8','212','3','93',465,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','94',466,'1','1',173708.60,176204.38,2495.78,623945.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','94',467,'2','1',251632.49,253746.97,2114.48,528620.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','94',468,'3','1',514650.25,517095.46,2445.21,611302.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','94',469,'4','1',2667930.77,2669270.19,1339.42,334855.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','94',470,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','95',471,'1','1',176204.38,178473.24,2268.86,567215.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','95',472,'2','1',253746.97,254599.17,852.20,213050.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','95',473,'3','1',517095.46,519206.79,2111.33,527832.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','95',474,'4','1',2669270.19,2669270.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','95',475,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','96',476,'1','1',178473.24,180961.58,2488.34,622085.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','96',477,'2','1',254599.17,254862.97,263.80,65950.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','96',478,'3','1',519206.79,522161.40,2954.61,738652.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','96',479,'4','1',2669270.19,2669580.10,309.91,77477.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','96',480,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','97',481,'1','1',180961.58,182040.81,1079.23,269807.50,0.00,0.00,0.00,0.00,0.00),('8','212','1','97',482,'2','1',254862.97,257563.56,2700.59,675147.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','97',483,'3','1',522161.40,524659.27,2497.87,624467.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','97',484,'4','1',2669580.10,2670447.75,867.65,216912.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','97',485,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','98',486,'1','1',182040.81,184371.37,2330.56,582640.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','98',487,'2','1',257563.56,257576.17,12.61,3152.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','98',488,'3','1',524659.27,527809.97,3150.70,787675.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','98',489,'4','1',2670447.75,2672046.76,1599.01,399752.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','98',490,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','99',491,'1','1',184371.37,185211.55,840.18,210045.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','99',492,'2','1',257576.17,260134.87,2558.70,639675.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','99',493,'3','1',527809.97,530187.65,2377.68,594420.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','99',494,'4','1',2672046.76,2672957.41,910.65,227662.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','99',495,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','100',496,'1','1',185211.55,186686.41,1474.86,368715.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','100',497,'2','1',260134.87,260917.36,782.49,195622.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','100',498,'3','1',530187.65,533211.30,3023.65,755912.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','100',499,'4','1',2672957.41,2675779.42,2822.01,705502.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','100',500,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','101',501,'1','1',186686.41,187110.94,424.53,108255.15,0.00,0.00,0.00,0.00,0.00),('8','212','1','101',502,'2','1',260917.36,261301.34,383.98,97914.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','101',503,'3','1',533211.30,535310.75,2099.45,535359.75,0.00,0.00,0.00,0.00,0.00),('8','212','2','101',504,'4','1',2675779.42,2679318.84,3539.42,902552.10,0.00,0.00,0.00,0.00,0.00),('8','212','3','101',505,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','102',506,'1','1',187110.94,187110.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','102',507,'2','1',261301.34,261301.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','102',508,'3','1',535310.75,536620.81,1310.06,334065.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','102',509,'4','1',2679318.84,2681068.70,1749.86,446214.30,0.00,0.00,0.00,0.00,0.00),('8','212','3','102',510,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','103',511,'1','1',187110.94,188957.58,1846.64,470893.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','103',512,'2','1',261301.34,261301.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','103',513,'3','1',536620.81,538886.27,2265.46,577692.30,0.00,0.00,0.00,0.00,0.00),('8','212','2','103',514,'4','1',2681068.70,2682691.45,1622.75,413801.25,0.00,0.00,0.00,0.00,0.00),('8','212','3','103',515,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','104',516,'1','1',188957.58,189823.23,865.65,220740.75,0.00,0.00,0.00,0.00,0.00),('8','212','1','104',517,'2','1',261301.34,263729.05,2427.71,619066.05,0.00,0.00,0.00,0.00,0.00),('8','212','2','104',518,'3','1',538886.27,541021.77,2135.50,544552.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','104',519,'4','1',2682691.45,2682779.60,88.15,22478.25,0.00,0.00,0.00,0.00,0.00),('8','212','3','104',520,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','105',521,'1','1',189823.23,192845.99,3022.76,770803.80,0.00,0.00,0.00,0.00,0.00),('8','212','1','105',522,'2','1',263729.05,264264.46,535.41,136529.55,0.00,0.00,0.00,0.00,0.00),('8','212','2','105',523,'3','1',541021.77,543655.94,2634.17,671713.35,0.00,0.00,0.00,0.00,0.00),('8','212','2','105',524,'4','1',2682779.60,2682779.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','105',525,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','106',526,'1','1',192845.99,193243.23,397.24,101296.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','106',527,'2','1',264264.46,265956.10,1691.64,431368.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','106',528,'3','1',543655.94,546844.94,3189.00,813195.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','106',529,'4','1',2682779.60,2684789.73,2010.13,512583.15,0.00,0.00,0.00,0.00,0.00),('8','212','3','106',530,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','107',531,'1','1',193243.23,193243.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','107',532,'2','1',265956.10,267023.10,1067.00,272085.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','107',533,'3','1',546844.94,548882.16,2037.22,519491.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','107',534,'4','1',2684789.73,2687082.37,2292.64,584623.20,0.00,0.00,0.00,0.00,0.00),('8','212','3','107',535,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','108',536,'1','1',193243.23,195499.66,2256.43,575389.65,0.00,0.00,0.00,0.00,0.00),('8','212','1','108',537,'2','1',267023.10,269172.75,2149.65,548160.75,0.00,0.00,0.00,0.00,0.00),('8','212','2','108',538,'3','1',548882.16,550962.31,2080.15,530438.25,0.00,0.00,0.00,0.00,0.00),('8','212','2','108',539,'4','1',2687082.37,2688936.17,1853.80,472719.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','108',540,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','109',541,'1','1',195499.66,195956.81,457.15,116573.25,0.00,0.00,0.00,0.00,0.00),('8','212','1','109',542,'2','1',269172.75,269533.33,360.58,91947.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','109',543,'3','1',550962.31,550962.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','109',544,'4','1',2688936.17,2688936.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','109',545,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','110',546,'1','1',195956.81,197133.93,1177.12,300165.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','110',547,'2','1',269533.33,269803.98,270.65,69015.75,0.00,0.00,0.00,0.00,0.00),('8','212','2','110',548,'3','1',550962.31,552327.51,1365.20,348126.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','110',549,'4','1',2688936.17,2689453.63,517.46,131952.30,0.00,0.00,0.00,0.00,0.00),('8','212','3','110',550,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','111',551,'1','1',197133.93,197722.64,588.71,150121.05,0.00,0.00,0.00,0.00,0.00),('8','212','1','111',552,'2','1',269803.98,271849.47,2045.49,521599.95,0.00,0.00,0.00,0.00,0.00),('8','212','2','111',553,'3','1',552327.51,554473.83,2146.32,547311.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','111',554,'4','1',2689453.63,2689843.36,389.73,99381.15,0.00,0.00,0.00,0.00,0.00),('8','212','3','111',555,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','112',556,'1','1',197722.64,200294.11,2571.47,655724.85,0.00,0.00,0.00,0.00,0.00),('8','212','1','112',557,'2','1',271849.47,272146.30,296.83,75691.65,0.00,0.00,0.00,0.00,0.00),('8','212','2','112',558,'3','1',554473.83,557993.98,3520.15,897638.25,0.00,0.00,0.00,0.00,0.00),('8','212','2','112',559,'4','1',2689843.36,2689885.36,42.00,10710.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','112',560,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','113',561,'1','1',200294.11,200891.31,597.20,152286.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','113',562,'2','1',272146.30,274451.58,2305.28,587846.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','113',563,'3','1',557993.98,560537.39,2543.41,648569.55,0.00,0.00,0.00,0.00,0.00),('8','212','2','113',564,'4','1',2689885.36,2690199.67,314.31,80149.05,0.00,0.00,0.00,0.00,0.00),('8','212','3','113',565,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','114',566,'1','1',200891.31,201417.49,526.18,136806.80,0.00,0.00,0.00,0.00,0.00),('8','212','1','114',567,'2','1',274451.58,275596.21,1144.63,297603.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','114',568,'3','1',560537.39,561205.66,668.27,173750.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','114',569,'4','1',2690199.67,2690559.67,360.00,93600.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','114',570,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','115',571,'1','1',201417.49,204372.73,2955.24,768362.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','115',572,'2','1',275596.21,277218.00,1621.79,421665.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','115',573,'3','1',561205.66,563927.53,2721.87,707686.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','115',574,'4','1',2690559.67,2691476.29,916.62,238321.20,0.00,0.00,0.00,0.00,0.00),('8','212','3','115',575,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','116',576,'1','1',204372.73,205218.42,845.69,219879.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','116',577,'2','1',277218.00,277379.42,161.42,41969.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','116',578,'3','1',563927.53,564182.64,255.11,66328.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','116',579,'4','1',2691476.29,2691476.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','116',580,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','117',581,'1','1',205218.42,205218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','117',582,'2','1',277379.42,277379.71,0.29,75.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','117',583,'3','1',564182.64,566464.51,2281.87,593286.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','117',584,'4','1',2691476.29,2695098.80,3622.51,941852.60,0.00,0.00,0.00,0.00,0.00),('8','212','3','117',585,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','118',586,'1','1',205218.42,205218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','118',587,'2','1',277379.71,277379.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','118',588,'3','1',566464.51,573124.76,6660.25,1731665.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','118',589,'4','1',2695098.80,2702205.92,7107.12,1847851.20,0.00,0.00,0.00,0.00,0.00),('8','212','3','118',590,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','119',591,'1','1',205218.42,205218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','119',592,'2','1',277379.71,277379.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','119',593,'3','1',573124.76,574918.91,1794.15,484420.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','119',594,'4','1',2702205.92,2704425.52,2219.60,599292.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','119',595,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','120',596,'1','1',205218.42,205218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','120',597,'2','1',277379.71,277379.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','120',598,'3','1',574918.91,577883.95,2965.04,800560.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','120',599,'4','1',2704425.52,2707824.32,3398.80,917676.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','120',600,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','121',601,'1','1',205218.42,205218.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','121',602,'2','1',277379.71,277379.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','121',603,'3','1',577883.95,578881.63,997.68,269373.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','121',604,'4','1',2707824.32,2708646.72,822.40,222048.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','121',605,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','122',606,'1','1',205218.42,210489.86,5271.44,1423288.80,0.00,0.00,0.00,0.00,0.00),('8','212','1','122',607,'2','1',277379.71,280648.86,3269.15,882670.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','122',608,'3','1',578881.63,578881.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','122',609,'4','1',2708646.72,2708646.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','122',610,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','123',611,'1','1',210489.86,214593.56,4103.70,1136724.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','123',612,'2','1',280648.86,284195.21,3546.35,982338.95,0.00,0.00,0.00,0.00,0.00),('8','212','2','123',613,'3','1',578881.63,578881.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','123',614,'4','1',2708646.72,2708646.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','123',615,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','124',616,'1','1',214593.56,217103.45,2509.89,765516.45,0.00,0.00,0.00,0.00,0.00),('8','212','1','124',617,'2','1',284195.21,284645.63,450.42,137378.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','124',618,'3','1',578881.63,581858.47,2976.84,907936.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','124',619,'4','1',2708646.72,2710265.96,1619.24,493868.20,0.00,0.00,0.00,0.00,0.00),('8','212','3','124',620,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','125',621,'1','1',217103.45,217687.80,584.35,178226.75,0.00,0.00,0.00,0.00,0.00),('8','212','1','125',622,'2','1',284645.63,284645.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','125',623,'3','1',581858.47,585297.83,3439.36,1049004.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','125',624,'4','1',2710265.96,2713269.50,3003.54,916079.70,0.00,0.00,0.00,0.00,0.00),('8','212','3','125',625,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','126',626,'1','1',217687.80,218813.14,1125.34,343228.70,0.00,0.00,0.00,0.00,0.00),('8','212','1','126',627,'2','1',284645.63,285949.84,1304.21,397784.05,0.00,0.00,0.00,0.00,0.00),('8','212','2','126',628,'3','1',585297.83,585297.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','126',629,'4','1',2713269.50,2713269.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','126',630,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','127',631,'1','1',218813.14,219415.62,602.48,111458.80,0.00,0.00,0.00,0.00,0.00),('8','212','1','127',632,'2','1',285949.84,286522.93,573.09,106021.65,0.00,0.00,0.00,0.00,0.00),('8','212','2','127',633,'3','1',585297.83,586583.35,1285.52,237821.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','127',634,'4','1',2713269.50,2714084.23,814.73,150725.05,0.00,0.00,0.00,0.00,0.00),('8','212','3','127',635,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','128',636,'1','1',219415.62,219828.37,412.75,127952.50,0.00,0.00,0.00,0.00,0.00),('8','212','1','128',637,'2','1',286522.93,287731.35,1208.42,374610.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','128',638,'3','1',586583.35,588065.80,1482.45,459559.50,0.00,0.00,0.00,0.00,0.00),('8','212','2','128',639,'4','1',2714084.23,2714481.47,397.24,123144.40,0.00,0.00,0.00,0.00,0.00),('8','212','3','128',640,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','129',641,'1','1',219828.37,220175.57,347.20,64232.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','129',642,'2','1',287731.35,288165.29,433.94,80278.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','129',643,'3','1',588065.80,589371.59,1305.79,241571.15,0.00,0.00,0.00,0.00,0.00),('8','212','2','129',644,'4','1',2714481.47,2715311.00,829.53,153463.05,0.00,0.00,0.00,0.00,0.00),('8','212','3','129',645,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','130',646,'1','1',220175.57,220835.36,659.79,122061.15,0.00,0.00,0.00,0.00,0.00),('8','212','1','130',647,'2','1',288165.29,289445.00,1279.71,236746.35,0.00,0.00,0.00,0.00,0.00),('8','212','2','130',648,'3','1',589371.59,590606.73,1235.14,228500.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','130',649,'4','1',2715311.00,2717090.94,1779.94,329288.90,0.00,0.00,0.00,0.00,0.00),('8','212','3','130',650,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','131',651,'1','1',220835.36,221207.73,372.37,68888.45,0.00,0.00,0.00,0.00,0.00),('8','212','1','131',652,'2','1',289445.00,290111.06,666.06,123221.10,0.00,0.00,0.00,0.00,0.00),('8','212','2','131',653,'3','1',590606.73,590606.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','131',654,'4','1',2717090.94,2717863.45,772.51,142914.35,0.00,0.00,0.00,0.00,0.00),('8','212','3','131',655,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','132',656,'1','1',221207.73,221207.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','132',657,'2','1',290111.06,290111.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','132',658,'3','1',590606.73,591678.87,1072.14,198345.90,0.00,0.00,0.00,0.00,0.00),('8','212','2','132',659,'4','1',2717863.45,2718914.36,1050.91,194418.35,0.00,0.00,0.00,0.00,0.00),('8','212','3','132',660,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','133',661,'1','1',221207.73,221207.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','133',662,'2','1',290111.06,290111.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','133',663,'3','1',591678.87,592284.89,606.02,112113.70,0.00,0.00,0.00,0.00,0.00),('8','212','2','133',664,'4','1',2718914.36,2720089.69,1175.33,217436.05,0.00,0.00,0.00,0.00,0.00),('8','212','3','133',665,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','134',666,'1','1',221207.73,223350.18,2142.45,642735.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','134',667,'2','1',290111.06,291946.37,1835.31,550593.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','134',668,'3','1',592284.89,595495.79,3210.90,963270.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','134',669,'4','1',2720089.69,2720089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','134',670,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','135',671,'1','1',223350.18,223350.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','135',672,'2','1',291946.37,291946.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','135',673,'3','1',595495.79,596116.87,621.08,114899.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','135',674,'4','1',2720089.69,2721422.79,1333.10,246623.50,0.00,0.00,0.00,0.00,0.00),('8','212','3','135',675,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','136',676,'1','1',223350.18,224921.78,1571.60,471480.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','136',677,'2','1',291946.37,292092.57,146.20,43860.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','136',678,'3','1',596116.87,597642.18,1525.31,457593.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','136',679,'4','1',2721422.79,2722349.20,926.41,277923.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','136',680,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','137',681,'1','1',224921.78,226302.81,1381.03,255490.55,0.00,0.00,0.00,0.00,0.00),('8','212','1','137',682,'2','1',292092.57,292092.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','137',683,'3','1',597642.18,598181.63,539.45,99798.25,0.00,0.00,0.00,0.00,0.00),('8','212','2','137',684,'4','1',2722349.20,2723794.06,1444.86,267299.10,0.00,0.00,0.00,0.00,0.00),('8','212','3','137',685,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','138',686,'1','1',226302.81,229903.22,3600.41,702079.95,0.00,0.00,0.00,0.00,0.00),('8','212','1','138',687,'2','1',292092.57,293583.85,1491.28,290799.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','138',688,'3','1',598181.63,598954.20,772.57,150651.15,0.00,0.00,0.00,0.00,0.00),('8','212','2','138',689,'4','1',2723794.06,2726724.35,2930.29,571406.55,0.00,0.00,0.00,0.00,0.00),('8','212','3','138',690,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','139',691,'1','1',229903.22,232719.51,2816.29,946273.44,0.00,0.00,0.00,0.00,0.00),('8','212','1','139',692,'2','1',293583.85,294431.99,848.14,284975.04,0.00,0.00,0.00,0.00,0.00),('8','212','2','139',693,'3','1',598954.20,599713.68,759.48,255185.28,0.00,0.00,0.00,0.00,0.00),('8','212','2','139',694,'4','1',2726724.35,2728045.87,1321.52,444030.72,0.00,0.00,0.00,0.00,0.00),('8','212','3','139',695,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','140',696,'1','1',232719.51,234413.69,1694.18,569244.48,0.00,0.00,0.00,0.00,0.00),('8','212','1','140',697,'2','1',294431.99,294929.41,497.42,167133.12,0.00,0.00,0.00,0.00,0.00),('8','212','2','140',698,'3','1',599713.68,600747.93,1034.25,347508.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','140',699,'4','1',2728045.87,2728045.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','140',700,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','141',701,'1','1',234413.69,234855.15,441.46,152303.70,0.00,0.00,0.00,0.00,0.00),('8','212','1','141',702,'2','1',294929.41,295429.64,500.23,172579.35,0.00,0.00,0.00,0.00,0.00),('8','212','2','141',703,'3','1',600747.93,601803.94,1056.01,364323.45,0.00,0.00,0.00,0.00,0.00),('8','212','2','141',704,'4','1',2728045.87,2728045.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','141',705,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','142',706,'1','1',234855.15,235871.67,1016.52,350699.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','142',707,'2','1',295429.64,296266.49,836.85,288713.25,0.00,0.00,0.00,0.00,0.00),('8','212','2','142',708,'3','1',601803.94,602165.86,361.92,124862.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','142',709,'4','1',2728045.87,2729176.30,1130.43,389998.35,0.00,0.00,0.00,0.00,0.00),('8','212','3','142',710,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','143',711,'1','1',235871.67,238552.57,2680.90,924910.50,0.00,0.00,0.00,0.00,0.00),('8','212','1','143',712,'2','1',296266.49,296540.38,273.89,94492.05,0.00,0.00,0.00,0.00,0.00),('8','212','2','143',713,'3','1',602165.86,603901.55,1735.69,598813.05,0.00,0.00,0.00,0.00,0.00),('8','212','2','143',714,'4','1',2729176.30,2729176.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','143',715,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','144',716,'1','1',238552.57,241751.39,3198.82,1103592.90,0.00,0.00,0.00,0.00,0.00),('8','212','1','144',717,'2','1',296540.38,299791.58,3251.20,1121664.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','144',718,'3','1',603901.55,603901.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','144',719,'4','1',2729176.30,2729860.59,684.29,236080.05,0.00,0.00,0.00,0.00,0.00),('8','212','3','144',720,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','145',721,'1','1',241751.39,243494.28,1742.89,601297.05,0.00,0.00,0.00,0.00,0.00),('8','212','1','145',722,'2','1',299791.58,300319.99,528.41,182301.45,0.00,0.00,0.00,0.00,0.00),('8','212','2','145',723,'3','1',603901.55,604197.20,295.65,101999.25,0.00,0.00,0.00,0.00,0.00),('8','212','2','145',724,'4','1',2729860.59,2729998.59,138.00,47610.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','145',725,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','146',726,'1','1',243494.28,246354.01,2859.73,986606.85,0.00,0.00,0.00,0.00,0.00),('8','212','1','146',727,'2','1',300319.99,300508.08,188.09,64891.05,0.00,0.00,0.00,0.00,0.00),('8','212','2','146',728,'3','1',604197.20,604197.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','146',729,'4','1',2729998.59,2729998.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','146',730,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','147',731,'1','1',246354.01,248163.96,1809.95,615383.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','147',732,'2','1',300508.08,300778.27,270.19,91864.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','147',733,'3','1',604197.20,605432.97,1235.77,420161.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','147',734,'4','1',2729998.59,2731090.82,1092.23,371358.20,0.00,0.00,0.00,0.00,0.00),('8','212','3','147',735,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','148',736,'1','1',248163.96,248201.55,37.59,12780.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','148',737,'2','1',300778.27,301485.62,707.35,240499.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','148',738,'3','1',605432.97,606777.45,1344.48,457123.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','148',739,'4','1',2731090.82,2731090.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','148',740,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','149',741,'1','1',248201.55,248378.98,177.43,60326.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','149',742,'2','1',301485.62,302264.40,778.78,264785.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','149',743,'3','1',606777.45,607990.98,1213.53,412600.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','149',744,'4','1',2731090.82,2731090.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','149',745,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','150',746,'1','1',248378.98,250409.12,2030.14,690247.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','150',747,'2','1',302264.40,303290.65,1026.25,348925.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','150',748,'3','1',607990.98,609700.15,1709.17,581117.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','150',749,'4','1',2731090.82,2732684.14,1593.32,541728.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','150',750,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','151',751,'1','1',250409.12,251415.61,1006.49,342206.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','151',752,'2','1',303290.65,304204.65,914.00,310760.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','151',753,'3','1',609700.15,611123.94,1423.79,484088.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','151',754,'4','1',2732684.14,2732684.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','151',755,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','152',756,'1','1',251415.61,252767.23,1351.62,459550.80,0.00,0.00,0.00,0.00,0.00),('8','212','1','152',757,'2','1',304204.65,304204.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','152',758,'3','1',611123.94,611236.35,112.41,38219.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','152',759,'4','1',2732684.14,2733245.78,561.64,190957.60,0.00,0.00,0.00,0.00,0.00),('8','212','3','152',760,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','153',761,'1','1',252767.23,253035.73,268.50,85920.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','153',762,'2','1',304204.65,305340.99,1136.34,363628.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','153',763,'3','1',611236.35,613385.07,2148.72,687590.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','153',764,'4','1',2733245.78,2733306.58,60.80,19456.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','153',765,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','154',766,'1','1',253035.73,254372.89,1337.16,427891.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','154',767,'2','1',305340.99,305340.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','154',768,'3','1',613385.07,614180.03,794.96,254387.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','154',769,'4','1',2733306.58,2733306.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','154',770,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','155',771,'1','1',254372.89,254554.41,181.52,58086.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','155',772,'2','1',305340.99,306604.50,1263.51,404323.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','155',773,'3','1',614180.03,615449.52,1269.49,406236.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','155',774,'4','1',2733306.58,2733577.49,270.91,86691.20,0.00,0.00,0.00,0.00,0.00),('8','212','3','155',775,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','156',776,'1','1',254554.41,255958.73,1404.32,449382.40,0.00,0.00,0.00,0.00,0.00),('8','212','1','156',777,'2','1',306604.50,307886.29,1281.79,410172.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','156',778,'3','1',615449.52,617528.91,2079.39,665404.80,0.00,0.00,0.00,0.00,0.00),('8','212','2','156',779,'4','1',2733577.49,2734766.98,1189.49,380636.80,0.00,0.00,0.00,0.00,0.00),('8','212','3','156',780,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','157',781,'1','1',255958.73,256788.26,829.53,265449.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','157',782,'2','1',307886.29,308259.65,373.36,119475.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','157',783,'3','1',617528.91,618593.76,1064.85,340752.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','157',784,'4','1',2734766.98,2735624.24,857.26,274323.20,0.00,0.00,0.00,0.00,0.00),('8','212','3','157',785,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','158',786,'1','1',256788.26,258636.79,1848.53,591529.60,0.00,0.00,0.00,0.00,0.00),('8','212','1','158',787,'2','1',308259.65,308259.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','158',788,'3','1',618593.76,620030.87,1437.11,459875.20,0.00,0.00,0.00,0.00,0.00),('8','212','2','158',789,'4','1',2735624.24,2735624.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','158',790,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','159',791,'1','1',258636.79,258636.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','159',792,'2','1',308259.65,309668.33,1408.68,450777.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','159',793,'3','1',620030.87,621311.50,1280.63,409801.60,0.00,0.00,0.00,0.00,0.00),('8','212','2','159',794,'4','1',2735624.24,2735624.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','159',795,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','160',796,'1','1',258636.79,260271.05,1634.26,522963.20,0.00,0.00,0.00,0.00,0.00),('8','212','1','160',797,'2','1',309668.33,309668.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','160',798,'3','1',621311.50,622303.52,992.02,317446.40,0.00,0.00,0.00,0.00,0.00),('8','212','2','160',799,'4','1',2735624.24,2735624.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','160',800,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','161',801,'1','1',260271.05,260363.29,92.24,27672.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','161',802,'2','1',309668.33,310666.48,998.15,299445.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','161',803,'3','1',622303.52,623668.16,1364.64,409392.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','161',804,'4','1',2735624.24,2736699.19,1074.95,322485.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','161',805,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','162',806,'1','1',260363.29,260661.33,298.04,89412.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','162',807,'2','1',310666.48,311340.33,673.85,202155.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','162',808,'3','1',623668.16,625514.83,1846.67,554001.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','162',809,'4','1',2736699.19,2736839.82,140.63,42189.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','162',810,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','163',811,'1','1',260661.33,262607.77,1946.44,583932.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','163',812,'2','1',311340.33,312653.36,1313.03,393909.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','163',813,'3','1',625514.83,626878.98,1364.15,409245.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','163',814,'4','1',2736839.82,2737697.38,857.56,257268.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','163',815,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','164',816,'1','1',262607.77,263680.48,1072.71,321813.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','164',817,'2','1',312653.36,313563.21,909.85,272955.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','164',818,'3','1',626878.98,626878.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','164',819,'4','1',2737697.38,2737697.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','164',820,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','165',821,'1','1',263680.48,264667.94,987.46,296238.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','165',822,'2','1',313563.21,314153.48,590.27,177081.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','165',823,'3','1',626878.98,626878.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','165',824,'4','1',2737697.38,2737697.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','165',825,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','166',826,'1','1',264667.94,264667.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','166',827,'2','1',314153.48,315332.97,1179.49,353847.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','166',828,'3','1',626878.98,628076.24,1197.26,359178.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','166',829,'4','1',2737697.38,2737697.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','166',830,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','167',831,'1','1',264667.94,265686.17,1018.23,305469.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','167',832,'2','1',315332.97,315680.45,347.48,104244.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','167',833,'3','1',628076.24,629440.46,1364.22,409266.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','167',834,'4','1',2737697.38,2737697.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','167',835,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','168',836,'1','1',265686.17,265821.36,135.19,40557.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','168',837,'2','1',315680.45,317527.29,1846.84,554052.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','168',838,'3','1',629440.46,631397.75,1957.29,587187.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','168',839,'4','1',2737697.38,2737697.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','168',840,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','169',841,'1','1',265821.36,268971.63,3150.27,945081.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','169',842,'2','1',317527.29,319295.20,1767.91,530373.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','169',843,'3','1',631397.75,634668.58,3270.83,981249.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','169',844,'4','1',2737697.38,2739539.65,1842.27,552681.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','169',845,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','170',846,'1','1',268971.63,270021.82,1050.19,315057.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','170',847,'2','1',319295.20,319954.47,659.27,197781.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','170',848,'3','1',634668.58,636580.00,1911.42,573426.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','170',849,'4','1',2739539.65,2739539.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','170',850,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','171',851,'1','1',270021.82,271519.91,1498.09,449427.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','171',852,'2','1',319954.47,319954.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','171',853,'3','1',636580.00,637906.75,1326.75,398025.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','171',854,'4','1',2739539.65,2740023.99,484.34,145302.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','171',855,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','172',856,'1','1',271519.91,271665.44,145.53,43659.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','172',857,'2','1',319954.47,321554.67,1600.20,480060.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','172',858,'3','1',637906.75,639430.41,1523.66,457098.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','172',859,'4','1',2740023.99,2740244.32,220.33,66099.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','172',860,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','173',861,'1','1',271665.44,273415.63,1750.19,525057.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','173',862,'2','1',321554.67,321554.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','173',863,'3','1',639430.41,641129.97,1699.56,509868.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','173',864,'4','1',2740244.32,2740583.07,338.75,101625.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','173',865,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','174',866,'1','1',273415.63,273522.50,106.87,32061.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','174',867,'2','1',321554.67,323190.65,1635.98,490794.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','174',868,'3','1',641129.97,642430.64,1300.67,390201.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','174',869,'4','1',2740583.07,2740761.73,178.66,53598.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','174',870,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','212','1','175',871,'1','1',273522.50,278235.50,4713.00,1413900.30,0.00,0.00,0.00,0.00,0.00),('8','212','1','175',872,'2','1',323190.65,325167.87,1977.22,593166.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','175',873,'3','1',642430.64,644945.89,2515.25,754575.00,0.00,0.00,0.00,0.00,0.00),('8','212','2','175',874,'4','1',2740761.73,2742260.81,1499.08,449724.00,0.00,0.00,0.00,0.00,0.00),('8','212','3','175',875,'5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=351 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('8','212','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,13),('8','212','7','1',215.00,215.00,0.00,0.00,0.00,0.00,0.00,14),('8','212','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,15),('8','212','8','1',215.00,215.00,658.79,0.00,0.00,0.00,0.00,16),('8','212','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,17),('8','212','9','1',215.00,215.00,1107.38,0.00,0.00,0.00,0.00,18),('8','212','10','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,19),('8','212','10','1',215.00,215.00,1474.04,0.00,0.00,0.00,0.00,20),('8','212','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,21),('8','212','11','1',215.00,215.00,1022.90,0.00,0.00,0.00,0.00,22),('8','212','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,23),('8','212','12','1',215.00,215.00,3845.13,0.00,0.00,0.00,0.00,24),('8','212','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,25),('8','212','13','1',215.00,215.00,813.79,0.00,0.00,0.00,0.00,26),('8','212','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('8','212','14','1',215.00,215.00,977.50,0.00,0.00,0.00,0.00,28),('8','212','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('8','212','15','1',215.00,215.00,1186.60,0.00,0.00,0.00,0.00,30),('8','212','16','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,31),('8','212','16','1',215.00,215.00,1272.99,0.00,0.00,0.00,0.00,32),('8','212','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,33),('8','212','17','1',215.00,215.00,1027.37,0.00,0.00,0.00,0.00,34),('8','212','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('8','212','18','1',215.00,215.00,897.40,0.00,0.00,0.00,0.00,36),('8','212','19','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,37),('8','212','19','1',215.00,215.00,3408.63,0.00,0.00,0.00,0.00,38),('8','212','20','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('8','212','20','1',215.00,215.00,693.09,0.00,0.00,0.00,0.00,40),('8','212','21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,41),('8','212','21','1',200.00,215.00,694.66,0.00,0.00,0.00,0.00,42),('8','212','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,43),('8','212','22','1',200.00,215.00,0.00,0.00,0.00,0.00,0.00,44),('8','212','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,45),('8','212','23','1',200.00,190.00,944.27,0.00,0.00,0.00,0.00,46),('8','212','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,47),('8','212','24','1',200.00,190.00,1528.71,0.00,0.00,0.00,0.00,48),('8','212','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,49),('8','212','25','1',200.00,190.00,1149.70,0.00,0.00,0.00,0.00,50),('8','212','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,51),('8','212','26','1',200.00,190.00,1874.71,0.00,0.00,0.00,0.00,52),('8','212','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,53),('8','212','27','1',200.00,190.00,3015.10,0.00,0.00,0.00,0.00,54),('8','212','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,55),('8','212','28','1',200.00,190.00,687.35,0.00,0.00,0.00,0.00,56),('8','212','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,57),('8','212','29','1',200.00,190.00,1183.70,0.00,0.00,0.00,0.00,58),('8','212','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,59),('8','212','30','1',200.00,190.00,1760.74,0.00,0.00,0.00,0.00,60),('8','212','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,61),('8','212','31','1',200.00,190.00,1638.05,0.00,0.00,0.00,0.00,62),('8','212','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,63),('8','212','32','1',200.00,190.00,4251.30,0.00,0.00,0.00,0.00,64),('8','212','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,65),('8','212','33','1',200.00,190.00,3175.59,0.00,0.00,0.00,0.00,66),('8','212','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,67),('8','212','34','1',200.00,190.00,7492.81,0.00,0.00,0.00,0.00,68),('8','212','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,69),('8','212','35','1',200.00,190.00,1636.43,0.00,0.00,0.00,0.00,70),('8','212','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,71),('8','212','36','1',190.00,190.00,1264.52,0.00,0.00,0.00,0.00,72),('8','212','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,73),('8','212','37','1',190.00,190.00,767.66,0.00,0.00,0.00,0.00,74),('8','212','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,75),('8','212','38','1',190.00,190.00,1824.96,0.00,0.00,0.00,0.00,76),('8','212','39','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,77),('8','212','39','1',190.00,190.00,1337.99,0.00,0.00,0.00,0.00,78),('8','212','40','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,79),('8','212','40','1',190.00,190.00,1615.41,0.00,0.00,0.00,0.00,80),('8','212','41','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,81),('8','212','41','1',190.00,190.00,9079.66,0.00,0.00,0.00,0.00,82),('8','212','42','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,83),('8','212','42','1',190.00,190.00,4799.15,0.00,0.00,0.00,0.00,84),('8','212','43','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,85),('8','212','43','1',190.00,190.00,3498.72,0.00,0.00,0.00,0.00,86),('8','212','44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,87),('8','212','44','1',190.00,190.00,2863.44,0.00,0.00,0.00,0.00,88),('8','212','45','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,89),('8','212','45','1',190.00,190.00,2765.63,0.00,0.00,0.00,0.00,90),('8','212','46','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,91),('8','212','46','1',190.00,190.00,2436.33,0.00,0.00,0.00,0.00,92),('8','212','47','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,93),('8','212','47','1',190.00,190.00,1269.04,0.00,0.00,0.00,0.00,94),('8','212','48','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,95),('8','212','48','1',190.00,190.00,5351.20,0.00,0.00,0.00,0.00,96),('8','212','49','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,97),('8','212','49','1',190.00,190.00,1181.61,0.00,0.00,0.00,0.00,98),('8','212','50','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,99),('8','212','50','1',190.00,190.00,1494.72,0.00,0.00,0.00,0.00,100),('8','212','51','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,101),('8','212','51','1',190.00,190.00,1361.74,0.00,0.00,0.00,0.00,102),('8','212','52','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,103),('8','212','52','1',190.00,190.00,2075.70,0.00,0.00,0.00,0.00,104),('8','212','53','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,105),('8','212','53','1',190.00,190.00,2154.52,0.00,0.00,0.00,0.00,106),('8','212','54','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,107),('8','212','54','1',190.00,190.00,1746.61,0.00,0.00,0.00,0.00,108),('8','212','55','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,109),('8','212','55','1',190.00,190.00,10165.54,0.00,0.00,0.00,0.00,110),('8','212','56','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,111),('8','212','56','1',190.00,190.00,2825.63,0.00,0.00,0.00,0.00,112),('8','212','57','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,113),('8','212','57','1',190.00,190.00,1428.29,0.00,0.00,0.00,0.00,114),('8','212','58','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,115),('8','212','58','1',190.00,190.00,1245.07,0.00,0.00,0.00,0.00,116),('8','212','59','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,117),('8','212','59','1',190.00,190.00,2111.99,0.00,0.00,0.00,0.00,118),('8','212','60','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,119),('8','212','60','1',190.00,190.00,2507.99,0.00,0.00,0.00,0.00,120),('8','212','61','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,121),('8','212','61','1',190.00,190.00,1774.97,0.00,0.00,0.00,0.00,122),('8','212','62','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,123),('8','212','62','1',190.00,190.00,5322.79,0.00,0.00,0.00,0.00,124),('8','212','63','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,125),('8','212','63','1',190.00,190.00,1204.91,0.00,0.00,0.00,0.00,126),('8','212','64','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,127),('8','212','64','1',190.00,190.00,1395.98,0.00,0.00,0.00,0.00,128),('8','212','65','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,129),('8','212','65','1',190.00,190.00,211.08,0.00,0.00,0.00,0.00,130),('8','212','66','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,131),('8','212','66','1',190.00,190.00,1792.87,0.00,0.00,0.00,0.00,132),('8','212','67','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,133),('8','212','67','1',190.00,190.00,4157.36,0.00,0.00,0.00,0.00,134),('8','212','68','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,135),('8','212','68','1',190.00,190.00,7090.34,0.00,0.00,0.00,0.00,136),('8','212','69','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,137),('8','212','69','1',190.00,190.00,6483.62,0.00,0.00,0.00,0.00,138),('8','212','70','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,139),('8','212','70','1',195.00,195.00,16511.61,0.00,0.00,0.00,0.00,140),('8','212','71','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,141),('8','212','71','1',195.00,195.00,25591.82,0.00,0.00,0.00,0.00,142),('8','212','72','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,143),('8','212','72','1',206.00,206.00,0.00,0.00,0.00,0.00,0.00,144),('8','212','73','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,145),('8','212','73','1',206.00,206.00,14155.14,0.00,0.00,0.00,0.00,146),('8','212','74','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,147),('8','212','74','1',220.00,220.00,10102.94,0.00,0.00,0.00,0.00,148),('8','212','75','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,149),('8','212','75','1',220.00,220.00,13480.14,0.00,0.00,0.00,0.00,150),('8','212','76','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,151),('8','212','76','1',220.00,220.00,9138.68,0.00,0.00,0.00,0.00,152),('8','212','77','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,153),('8','212','77','1',225.00,225.00,0.00,0.00,0.00,0.00,0.00,154),('8','212','78','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,155),('8','212','78','1',225.00,225.00,6799.13,0.00,0.00,0.00,0.00,156),('8','212','79','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,157),('8','212','79','1',225.00,225.00,11761.15,0.00,0.00,0.00,0.00,158),('8','212','80','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,159),('8','212','80','1',225.00,225.00,5720.42,0.00,0.00,0.00,0.00,160),('8','212','81','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,161),('8','212','81','1',230.00,230.00,9586.15,0.00,0.00,0.00,0.00,162),('8','212','82','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,163),('8','212','82','1',230.00,230.00,5534.96,0.00,0.00,0.00,0.00,164),('8','212','83','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,165),('8','212','83','1',235.00,235.00,4786.50,0.00,0.00,0.00,0.00,166),('8','212','84','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,167),('8','212','84','1',235.00,235.00,8029.34,0.00,0.00,0.00,0.00,168),('8','212','85','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,169),('8','212','85','1',235.00,235.00,3773.73,0.00,0.00,0.00,0.00,170),('8','212','86','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,171),('8','212','86','1',235.00,235.00,10035.89,0.00,0.00,0.00,0.00,172),('8','212','87','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,173),('8','212','87','1',235.00,235.00,0.00,0.00,0.00,0.00,0.00,174),('8','212','88','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,175),('8','212','88','1',250.00,250.00,3718.72,0.00,0.00,0.00,0.00,176),('8','212','89','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,177),('8','212','89','1',250.00,250.00,5122.55,0.00,0.00,0.00,0.00,178),('8','212','90','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,179),('8','212','90','1',250.00,250.00,7449.80,0.00,0.00,0.00,0.00,180),('8','212','91','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,181),('8','212','91','1',250.00,250.00,5497.95,0.00,0.00,0.00,0.00,182),('8','212','92','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,183),('8','212','92','1',255.00,255.00,1874.59,0.00,0.00,0.00,0.00,184),('8','212','93','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,185),('8','212','93','1',255.00,255.00,2700.00,0.00,0.00,0.00,0.00,186),('8','212','94','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,187),('8','212','94','1',250.00,250.00,8394.89,0.00,0.00,0.00,0.00,188),('8','212','95','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,189),('8','212','95','1',250.00,250.00,5232.39,0.00,0.00,0.00,0.00,190),('8','212','96','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,191),('8','212','96','1',250.00,250.00,6016.66,0.00,0.00,0.00,0.00,192),('8','212','97','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,193),('8','212','97','1',250.00,250.00,7145.34,0.00,0.00,0.00,0.00,194),('8','212','98','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,195),('8','212','98','1',250.00,250.00,7092.88,0.00,0.00,0.00,0.00,196),('8','212','99','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,197),('8','212','99','1',250.00,250.00,6687.21,0.00,0.00,0.00,0.00,198),('8','212','100','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,199),('8','212','100','1',250.00,250.00,8103.01,0.00,0.00,0.00,0.00,200),('8','212','101','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,201),('8','212','101','1',255.00,255.00,6447.38,0.00,0.00,0.00,0.00,202),('8','212','102','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,203),('8','212','102','1',255.00,255.00,3059.92,0.00,0.00,0.00,0.00,204),('8','212','103','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,205),('8','212','103','1',255.00,255.00,5734.85,0.00,0.00,0.00,0.00,206),('8','212','104','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,207),('8','212','104','1',255.00,255.00,5517.01,0.00,0.00,0.00,0.00,208),('8','212','105','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,209),('8','212','105','1',255.00,255.00,6192.34,0.00,0.00,0.00,0.00,210),('8','212','106','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,211),('8','212','106','1',255.00,255.00,7288.01,0.00,0.00,0.00,0.00,212),('8','212','107','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,213),('8','212','107','1',255.00,255.00,5396.86,0.00,0.00,0.00,0.00,214),('8','212','108','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215),('8','212','108','1',255.00,255.00,8340.03,0.00,0.00,0.00,0.00,216),('8','212','109','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,217),('8','212','109','1',255.00,255.00,817.73,0.00,0.00,0.00,0.00,218),('8','212','110','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219),('8','212','110','1',255.00,255.00,3330.43,0.00,0.00,0.00,0.00,220),('8','212','111','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,221),('8','212','111','1',255.00,255.00,5170.25,0.00,0.00,0.00,0.00,222),('8','212','112','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,223),('8','212','112','1',255.00,255.00,6430.45,0.00,0.00,0.00,0.00,224),('8','212','113','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,225),('8','212','113','1',255.00,255.00,5760.20,0.00,0.00,0.00,0.00,226),('8','212','114','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,227),('8','212','114','1',260.00,260.00,2699.08,0.00,0.00,0.00,0.00,228),('8','212','115','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,229),('8','212','115','1',260.00,260.00,8215.52,0.00,0.00,0.00,0.00,230),('8','212','116','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,231),('8','212','116','1',260.00,260.00,1262.22,0.00,0.00,0.00,0.00,232),('8','212','117','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233),('8','212','117','1',270.00,260.00,5904.67,0.00,0.00,0.00,0.00,234),('8','212','118','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,235),('8','212','118','1',270.00,260.00,13767.37,0.00,0.00,0.00,0.00,236),('8','212','119','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,237),('8','212','119','1',270.00,270.00,4013.75,0.00,0.00,0.00,0.00,238),('8','212','120','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,239),('8','212','120','1',270.00,270.00,6363.84,0.00,0.00,0.00,0.00,240),('8','212','121','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241),('8','212','121','1',270.00,270.00,1820.08,0.00,0.00,0.00,0.00,242),('8','212','122','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,243),('8','212','122','1',270.00,270.00,8540.59,0.00,0.00,0.00,0.00,244),('8','212','123','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,245),('8','212','123','1',277.00,277.00,7650.05,0.00,0.00,0.00,0.00,246),('8','212','124','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,247),('8','212','124','1',305.00,305.00,7556.39,0.00,0.00,0.00,0.00,248),('8','212','125','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,249),('8','212','125','1',305.00,305.00,7027.25,0.00,0.00,0.00,0.00,250),('8','212','126','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,251),('8','212','126','1',305.00,305.00,2429.55,0.00,0.00,0.00,0.00,252),('8','212','127','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,253),('8','212','127','1',185.00,185.00,3275.82,0.00,0.00,0.00,0.00,254),('8','212','128','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,255),('8','212','128','1',310.00,310.00,3500.86,0.00,0.00,0.00,0.00,256),('8','212','129','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,257),('8','212','129','1',185.00,185.00,2916.46,0.00,0.00,0.00,0.00,258),('8','212','130','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,259),('8','212','130','1',310.00,185.00,4954.58,0.00,0.00,0.00,0.00,260),('8','212','131','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261),('8','212','131','1',310.00,185.00,1810.94,0.00,0.00,0.00,0.00,262),('8','212','132','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263),('8','212','132','1',310.00,185.00,2123.05,0.00,0.00,0.00,0.00,264),('8','212','133','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,265),('8','212','133','1',310.00,185.00,1781.35,0.00,0.00,0.00,0.00,266),('8','212','134','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,267),('8','212','134','1',300.00,300.00,7188.66,0.00,0.00,0.00,0.00,268),('8','212','135','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,269),('8','212','135','1',185.00,185.00,1954.18,0.00,0.00,0.00,0.00,270),('8','212','136','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,271),('8','212','136','1',300.00,300.00,4169.52,0.00,0.00,0.00,0.00,272),('8','212','137','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,273),('8','212','137','1',185.00,185.00,3365.34,0.00,0.00,0.00,0.00,274),('8','212','138','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,275),('8','212','138','1',195.00,195.00,8794.55,0.00,0.00,0.00,0.00,276),('8','212','139','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,277),('8','212','139','1',336.00,336.00,5745.43,0.00,0.00,0.00,0.00,278),('8','212','140','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,279),('8','212','140','1',336.00,336.00,3225.85,0.00,0.00,0.00,0.00,280),('8','212','141','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,281),('8','212','141','1',345.00,345.00,1997.70,0.00,0.00,0.00,0.00,282),('8','212','142','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,283),('8','212','142','1',345.00,345.00,3345.72,0.00,0.00,0.00,0.00,284),('8','212','143','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,285),('8','212','143','1',345.00,345.00,4690.48,0.00,0.00,0.00,0.00,286),('8','212','144','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,287),('8','212','144','1',345.00,345.00,7134.31,0.00,0.00,0.00,0.00,288),('8','212','145','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,289),('8','212','145','1',345.00,345.00,2704.95,0.00,0.00,0.00,0.00,290),('8','212','146','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,291),('8','212','146','1',345.00,345.00,3047.82,0.00,0.00,0.00,0.00,292),('8','212','147','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,293),('8','212','147','1',340.00,340.00,4408.14,0.00,0.00,0.00,0.00,294),('8','212','148','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,295),('8','212','148','1',340.00,340.00,2089.42,0.00,0.00,0.00,0.00,296),('8','212','149','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,297),('8','212','149','1',340.00,340.00,2169.74,0.00,0.00,0.00,0.00,298),('8','212','150','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,299),('8','212','150','1',340.00,340.00,6358.88,0.00,0.00,0.00,0.00,300),('8','212','151','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,301),('8','212','151','1',340.00,340.00,3344.28,0.00,0.00,0.00,0.00,302),('8','212','152','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,303),('8','212','152','1',340.00,340.00,2025.67,0.00,0.00,0.00,0.00,304),('8','212','153','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,305),('8','212','153','1',320.00,320.00,3614.36,0.00,0.00,0.00,0.00,306),('8','212','154','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,307),('8','212','154','1',320.00,320.00,2132.12,0.00,0.00,0.00,0.00,308),('8','212','155','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,309),('8','212','155','1',320.00,320.00,2985.43,0.00,0.00,0.00,0.00,310),('8','212','156','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,311),('8','212','156','1',320.00,320.00,5954.99,0.00,0.00,0.00,0.00,312),('8','212','157','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,313),('8','212','157','1',320.00,320.00,3125.00,0.00,0.00,0.00,0.00,314),('8','212','158','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,315),('8','212','158','1',320.00,320.00,3285.64,0.00,0.00,0.00,0.00,316),('8','212','159','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317),('8','212','159','1',320.00,320.00,2689.31,0.00,0.00,0.00,0.00,318),('8','212','160','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,319),('8','212','160','1',320.00,320.00,2626.28,0.00,0.00,0.00,0.00,320),('8','212','161','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,321),('8','212','161','1',300.00,300.00,3529.98,0.00,0.00,0.00,0.00,322),('8','212','162','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,323),('8','212','162','1',300.00,300.00,2959.19,0.00,0.00,0.00,0.00,324),('8','212','163','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,325),('8','212','163','1',300.00,300.00,5481.18,0.00,0.00,0.00,0.00,326),('8','212','164','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,327),('8','212','164','1',300.00,300.00,1982.56,0.00,0.00,0.00,0.00,328),('8','212','165','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,329),('8','212','165','1',300.00,300.00,1577.73,0.00,0.00,0.00,0.00,330),('8','212','166','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,331),('8','212','166','1',300.00,300.00,2376.75,0.00,0.00,0.00,0.00,332),('8','212','167','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,333),('8','212','167','1',300.00,300.00,2729.93,0.00,0.00,0.00,0.00,334),('8','212','168','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,335),('8','212','168','1',300.00,300.00,3939.32,0.00,0.00,0.00,0.00,336),('8','212','169','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,337),('8','212','169','1',300.00,300.00,10031.28,0.00,0.00,0.00,0.00,338),('8','212','170','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,339),('8','212','170','1',300.00,300.00,3620.88,0.00,0.00,0.00,0.00,340),('8','212','171','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,341),('8','212','171','1',300.00,300.00,3309.18,0.00,0.00,0.00,0.00,342),('8','212','172','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,343),('8','212','172','1',300.00,300.00,3489.72,0.00,0.00,0.00,0.00,344),('8','212','173','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,345),('8','212','173','1',300.00,300.00,3788.50,0.00,0.00,0.00,0.00,346),('8','212','174','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,347),('8','212','174','1',300.00,300.00,3222.18,0.00,0.00,0.00,0.00,348),('8','212','175','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,349),('8','212','175','1',300.00,300.00,10704.55,0.00,0.00,0.00,0.00,350);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
INSERT INTO `depots_shifts_stocklevels` VALUES (1,'8','212','6','2022-07-17 14:42:21','910','1',215.00,6500.00,1397500.00),(2,'8','212','11','2022-08-12 20:24:45','910','1',215.00,17000.00,3655000.00);
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('8',1,'212','PRODUCT TANK','Tanks Containing Petroleum Product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('8','212','1',1,0,'1','PMS TANK 1',33000.00,0.00,NULL,'TANK CONTAINING PETROL.','910','2022-07-17 08:42:39','2022-07-17 08:42:39','910',5,0),('8','212','1',2,0,'1','PMS TANK 2',33000.00,0.00,NULL,'TANK CONTAINING PETROL.','910','2022-07-17 08:45:15','2022-07-17 08:45:15','910',5,0),('8','212','1',3,0,'2','AGO TANK ',33000.00,0.00,NULL,'TANK CONTAINING DIESEL.','910','2022-07-17 08:47:21','2022-07-17 08:47:21','910',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'8','212',3,0.00,'2023-03-20 08:50:29'),(2,'8','212',2,16473.67,'2023-03-20 08:50:29'),(3,'8','212',1,16495.94,'2023-03-20 08:50:29');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=823 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (25,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,6417750.00,29850.00,0.00,0.00,'2022-08-11 15:37:01','',''),(26,'8','212','2',1,'Sale Id shift 8',0.00,0.00,0.00,257.07,0.00,'2022-08-12 15:53:15','',''),(27,'8','212','2',1,'Sale Id shift 8',0.00,0.00,0.00,401.72,0.00,'2022-08-12 15:53:15','',''),(28,'8','212',NULL,1,'Sale Id shift 8',141639.85,0.00,0.00,0.00,0.00,'2022-08-12 15:53:15','',''),(29,'8','212','2',1,'Sale Id shift 9',0.00,0.00,0.00,843.23,0.00,'2022-08-12 16:06:56','',''),(30,'8','212','2',1,'Sale Id shift 9',0.00,0.00,0.00,264.15,0.00,'2022-08-12 16:06:56','',''),(31,'8','212',NULL,1,'Sale Id shift 9',238086.70,0.00,0.00,0.00,0.00,'2022-08-12 16:06:56','',''),(32,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,3655000.00,17000.00,0.00,0.00,'2022-08-12 18:16:06','',''),(33,'8','212','2',1,'Sale Id shift 10',0.00,0.00,0.00,854.85,0.00,'2022-08-12 19:26:53','',''),(34,'8','212','2',1,'Sale Id shift 10',0.00,0.00,0.00,619.19,0.00,'2022-08-12 19:26:53','',''),(35,'8','212',NULL,1,'Sale Id shift 10',316918.60,0.00,0.00,0.00,0.00,'2022-08-12 19:26:53','',''),(36,'8','212',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,28850.00,0.00,'2022-08-12 19:58:22','',''),(37,'8','212','2',1,'Received from bridging 8',0.00,0.00,28850.00,0.00,0.00,'2022-08-12 19:58:22','',''),(38,'8','212',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,1000.00,0.00,'2022-08-12 19:58:22','',''),(39,'8','212','1',1,'Received from bridging 7',0.00,0.00,1000.00,0.00,0.00,'2022-08-12 19:58:22','',''),(40,'8','212',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,17000.00,0.00,'2022-08-12 21:00:32','',''),(41,'8','212','1',1,'Received from bridging 9',0.00,0.00,17000.00,0.00,0.00,'2022-08-12 21:00:32','',''),(42,'8','212','2',1,'Sale Id shift 11',0.00,0.00,0.00,349.00,0.00,'2022-08-13 19:25:41','',''),(43,'8','212','2',1,'Sale Id shift 11',0.00,0.00,0.00,673.90,0.00,'2022-08-13 19:25:41','',''),(44,'8','212',NULL,1,'Sale Id shift 11',219923.50,0.00,0.00,0.00,0.00,'2022-08-13 19:25:41','',''),(45,'8','212','1',1,'Sale Id shift 12',0.00,0.00,0.00,1316.87,0.00,'2022-08-14 19:58:25','',''),(46,'8','212','2',1,'Sale Id shift 12',0.00,0.00,0.00,1813.42,0.00,'2022-08-14 19:58:25','',''),(47,'8','212','2',1,'Sale Id shift 12',0.00,0.00,0.00,714.84,0.00,'2022-08-14 19:58:25','',''),(48,'8','212',NULL,1,'Sale Id shift 12',826702.95,0.00,0.00,0.00,0.00,'2022-08-14 19:58:25','',''),(49,'8','212','1',1,'Sale Id shift 13',0.00,0.00,0.00,290.61,0.00,'2022-08-15 20:12:31','',''),(50,'8','212','2',1,'Sale Id shift 13',0.00,0.00,0.00,523.18,0.00,'2022-08-15 20:12:31','',''),(51,'8','212',NULL,1,'Sale Id shift 13',174964.85,0.00,0.00,0.00,0.00,'2022-08-15 20:12:31','',''),(52,'8','212','1',1,'Sale Id shift 14',0.00,0.00,0.00,358.84,0.00,'2022-08-16 20:51:01','',''),(53,'8','212','2',1,'Sale Id shift 14',0.00,0.00,0.00,618.66,0.00,'2022-08-16 20:51:01','',''),(54,'8','212',NULL,1,'Sale Id shift 14',210162.50,0.00,0.00,0.00,0.00,'2022-08-16 20:51:01','',''),(55,'8','212','1',1,'Sale Id shift 15',0.00,0.00,0.00,579.20,0.00,'2022-08-19 19:05:23','',''),(56,'8','212','2',1,'Sale Id shift 15',0.00,0.00,0.00,607.40,0.00,'2022-08-19 19:05:23','',''),(57,'8','212',NULL,1,'Sale Id shift 15',255119.00,0.00,0.00,0.00,0.00,'2022-08-19 19:05:23','',''),(58,'8','212','1',1,'Sale Id shift 16',0.00,0.00,0.00,790.46,0.00,'2022-08-19 19:09:45','',''),(59,'8','212','2',1,'Sale Id shift 16',0.00,0.00,0.00,482.53,0.00,'2022-08-19 19:09:45','',''),(60,'8','212',NULL,1,'Sale Id shift 16',273692.85,0.00,0.00,0.00,0.00,'2022-08-19 19:09:45','',''),(61,'8','212','1',1,'Sale Id shift 17',0.00,0.00,0.00,227.11,0.00,'2022-08-19 19:14:20','',''),(62,'8','212','1',1,'Sale Id shift 17',0.00,0.00,0.00,556.22,0.00,'2022-08-19 19:14:20','',''),(63,'8','212','2',1,'Sale Id shift 17',0.00,0.00,0.00,244.04,0.00,'2022-08-19 19:14:20','',''),(64,'8','212',NULL,1,'Sale Id shift 17',220884.55,0.00,0.00,0.00,0.00,'2022-08-19 19:14:20','',''),(65,'8','212','1',1,'Sale Id shift 18',0.00,0.00,0.00,227.19,0.00,'2022-08-20 20:33:36','',''),(66,'8','212','2',1,'Sale Id shift 18',0.00,0.00,0.00,613.03,0.00,'2022-08-20 20:33:36','',''),(67,'8','212','2',1,'Sale Id shift 18',0.00,0.00,0.00,57.18,0.00,'2022-08-20 20:33:36','',''),(68,'8','212',NULL,1,'Sale Id shift 18',192941.00,0.00,0.00,0.00,0.00,'2022-08-20 20:33:36','',''),(69,'8','212','1',1,'Sale Id shift 19',0.00,0.00,0.00,925.83,0.00,'2022-08-21 19:47:52','',''),(70,'8','212','1',1,'Sale Id shift 19',0.00,0.00,0.00,978.43,0.00,'2022-08-21 19:47:52','',''),(71,'8','212','2',1,'Sale Id shift 19',0.00,0.00,0.00,908.66,0.00,'2022-08-21 19:47:52','',''),(72,'8','212','2',1,'Sale Id shift 19',0.00,0.00,0.00,595.71,0.00,'2022-08-21 19:47:52','',''),(73,'8','212',NULL,1,'Sale Id shift 19',732855.45,0.00,0.00,0.00,0.00,'2022-08-21 19:47:52','',''),(74,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,6050000.00,30250.00,0.00,0.00,'2022-08-23 13:28:14','',''),(75,'8','212',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,15250.00,0.00,'2022-08-23 14:04:03','',''),(76,'8','212','1',1,'Received from bridging 10',0.00,0.00,15250.00,0.00,0.00,'2022-08-23 14:04:03','',''),(77,'8','212','1',1,'Sale Id shift 20',0.00,0.00,0.00,249.50,0.00,'2022-08-23 14:07:23','',''),(78,'8','212','1',1,'Sale Id shift 20',0.00,0.00,0.00,443.59,0.00,'2022-08-23 14:07:23','',''),(79,'8','212',NULL,1,'Sale Id shift 20',149014.35,0.00,0.00,0.00,0.00,'2022-08-23 14:07:23','',''),(80,'8','212','1',1,'Returned bridging 10',0.00,0.00,0.00,15250.00,0.00,'2022-08-23 14:14:32','',''),(81,'8','212',NULL,1,'Reception Return corrector for bridging 10',0.00,0.00,15250.00,0.00,0.00,'2022-08-23 14:14:32','',''),(82,'8','212',NULL,1,'Reception corrector for bridging 12',0.00,0.00,0.00,15250.00,0.00,'2022-08-23 14:14:58','',''),(83,'8','212','1',1,'Received from bridging 12',0.00,0.00,15250.00,0.00,0.00,'2022-08-23 14:14:58','',''),(84,'8','212',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,15000.00,0.00,'2022-08-23 14:15:16','',''),(85,'8','212','2',1,'Received from bridging 13',0.00,0.00,15000.00,0.00,0.00,'2022-08-23 14:15:16','',''),(86,'8','212','1',1,'Sale Id shift 21',0.00,0.00,0.00,246.32,0.00,'2022-08-23 19:15:01','',''),(87,'8','212','2',1,'Sale Id shift 21',0.00,0.00,0.00,448.34,0.00,'2022-08-23 19:15:01','',''),(88,'8','212',NULL,1,'Sale Id shift 21',138932.00,0.00,0.00,0.00,0.00,'2022-08-23 19:15:01','',''),(89,'8','212','1',1,'Sale Id shift 23',0.00,0.00,0.00,153.89,0.00,'2022-08-25 16:54:48','',''),(90,'8','212','1',1,'Sale Id shift 23',0.00,0.00,0.00,425.31,0.00,'2022-08-25 16:54:48','',''),(91,'8','212','2',1,'Sale Id shift 23',0.00,0.00,0.00,365.07,0.00,'2022-08-25 16:54:48','',''),(92,'8','212',NULL,1,'Sale Id shift 23',188854.00,0.00,0.00,0.00,0.00,'2022-08-25 16:54:48','',''),(93,'8','212','1',1,'Sale Id shift 24',0.00,0.00,0.00,275.17,0.00,'2022-08-25 19:40:35','',''),(94,'8','212','1',1,'Sale Id shift 24',0.00,0.00,0.00,824.73,0.00,'2022-08-25 19:40:35','',''),(95,'8','212','2',1,'Sale Id shift 24',0.00,0.00,0.00,428.81,0.00,'2022-08-25 19:40:35','',''),(96,'8','212',NULL,1,'Sale Id shift 24',305742.00,0.00,0.00,0.00,0.00,'2022-08-25 19:40:35','',''),(97,'8','212','1',1,'Sale Id shift 25',0.00,0.00,0.00,93.93,0.00,'2022-08-26 20:38:18','',''),(98,'8','212','1',1,'Sale Id shift 25',0.00,0.00,0.00,365.05,0.00,'2022-08-26 20:38:18','',''),(99,'8','212','2',1,'Sale Id shift 25',0.00,0.00,0.00,690.72,0.00,'2022-08-26 20:38:18','',''),(100,'8','212',NULL,1,'Sale Id shift 25',229940.00,0.00,0.00,0.00,0.00,'2022-08-26 20:38:18','',''),(101,'8','212','1',1,'Sale Id shift 26',0.00,0.00,0.00,972.46,0.00,'2022-08-28 19:45:48','',''),(102,'8','212','2',1,'Sale Id shift 26',0.00,0.00,0.00,902.25,0.00,'2022-08-28 19:45:48','',''),(103,'8','212',NULL,1,'Sale Id shift 26',374942.00,0.00,0.00,0.00,0.00,'2022-08-28 19:45:48','',''),(104,'8','212','1',1,'Sale Id shift 27',0.00,0.00,0.00,1064.83,0.00,'2022-08-28 19:50:15','',''),(105,'8','212','1',1,'Sale Id shift 27',0.00,0.00,0.00,601.46,0.00,'2022-08-28 19:50:15','',''),(106,'8','212','2',1,'Sale Id shift 27',0.00,0.00,0.00,481.90,0.00,'2022-08-28 19:50:15','',''),(107,'8','212','2',1,'Sale Id shift 27',0.00,0.00,0.00,866.91,0.00,'2022-08-28 19:50:15','',''),(108,'8','212',NULL,1,'Sale Id shift 27',603020.00,0.00,0.00,0.00,0.00,'2022-08-28 19:50:15','',''),(109,'8','212','1',1,'Sale Id shift 28',0.00,0.00,0.00,430.95,0.00,'2022-08-29 19:50:40','',''),(110,'8','212','2',1,'Sale Id shift 28',0.00,0.00,0.00,256.40,0.00,'2022-08-29 19:50:40','',''),(111,'8','212',NULL,1,'Sale Id shift 28',137470.00,0.00,0.00,0.00,0.00,'2022-08-29 19:50:40','',''),(112,'8','212','1',1,'Sale Id shift 29',0.00,0.00,0.00,420.73,0.00,'2022-08-30 19:08:06','',''),(113,'8','212','1',1,'Sale Id shift 29',0.00,0.00,0.00,230.86,0.00,'2022-08-30 19:08:06','',''),(114,'8','212','2',1,'Sale Id shift 29',0.00,0.00,0.00,532.11,0.00,'2022-08-30 19:08:06','',''),(115,'8','212',NULL,1,'Sale Id shift 29',236740.00,0.00,0.00,0.00,0.00,'2022-08-30 19:08:06','',''),(116,'8','212','1',1,'Sale Id shift 30',0.00,0.00,0.00,243.96,0.00,'2022-08-31 19:53:10','',''),(117,'8','212','1',1,'Sale Id shift 30',0.00,0.00,0.00,82.32,0.00,'2022-08-31 19:53:10','',''),(118,'8','212','2',1,'Sale Id shift 30',0.00,0.00,0.00,583.90,0.00,'2022-08-31 19:53:10','',''),(119,'8','212','2',1,'Sale Id shift 30',0.00,0.00,0.00,850.56,0.00,'2022-08-31 19:53:10','',''),(120,'8','212',NULL,1,'Sale Id shift 30',352148.00,0.00,0.00,0.00,0.00,'2022-08-31 19:53:10','',''),(121,'8','212','1',1,'Sale Id shift 31',0.00,0.00,0.00,1033.29,0.00,'2022-09-01 20:13:15','',''),(122,'8','212','1',1,'Sale Id shift 31',0.00,0.00,0.00,103.52,0.00,'2022-09-01 20:13:15','',''),(123,'8','212','2',1,'Sale Id shift 31',0.00,0.00,0.00,501.24,0.00,'2022-09-01 20:13:15','',''),(124,'8','212',NULL,1,'Sale Id shift 31',327610.00,0.00,0.00,0.00,0.00,'2022-09-01 20:13:15','',''),(125,'8','212','1',1,'Sale Id shift 32',0.00,0.00,0.00,405.01,0.00,'2022-09-02 19:49:23','',''),(126,'8','212','1',1,'Sale Id shift 32',0.00,0.00,0.00,1548.59,0.00,'2022-09-02 19:49:23','',''),(127,'8','212','2',1,'Sale Id shift 32',0.00,0.00,0.00,798.46,0.00,'2022-09-02 19:49:23','',''),(128,'8','212','2',1,'Sale Id shift 32',0.00,0.00,0.00,1499.24,0.00,'2022-09-02 19:49:23','',''),(129,'8','212',NULL,1,'Sale Id shift 32',850260.00,0.00,0.00,0.00,0.00,'2022-09-02 19:49:23','',''),(130,'8','212','1',1,'Sale Id shift 33',0.00,0.00,0.00,181.58,0.00,'2022-09-04 08:22:09','',''),(131,'8','212','1',1,'Sale Id shift 33',0.00,0.00,0.00,1608.85,0.00,'2022-09-04 08:22:09','',''),(132,'8','212','2',1,'Sale Id shift 33',0.00,0.00,0.00,1385.16,0.00,'2022-09-04 08:22:09','',''),(133,'8','212',NULL,1,'Sale Id shift 33',635118.00,0.00,0.00,0.00,0.00,'2022-09-04 08:22:09','',''),(134,'8','212','1',1,'Sale Id shift 34',0.00,0.00,0.00,2840.29,0.00,'2022-09-05 21:38:54','',''),(135,'8','212','1',1,'Sale Id shift 34',0.00,0.00,0.00,1431.27,0.00,'2022-09-05 21:38:54','',''),(136,'8','212','2',1,'Sale Id shift 34',0.00,0.00,0.00,1853.80,0.00,'2022-09-05 21:38:54','',''),(137,'8','212','2',1,'Sale Id shift 34',0.00,0.00,0.00,1367.45,0.00,'2022-09-05 21:38:54','',''),(138,'8','212',NULL,1,'Sale Id shift 34',1498562.00,0.00,0.00,0.00,0.00,'2022-09-05 21:38:54','',''),(139,'8','212','1',1,'Sale Id shift 35',0.00,0.00,0.00,1008.80,0.00,'2022-09-05 21:44:16','',''),(140,'8','212','2',1,'Sale Id shift 35',0.00,0.00,0.00,627.63,0.00,'2022-09-05 21:44:16','',''),(141,'8','212',NULL,1,'Sale Id shift 35',327286.00,0.00,0.00,0.00,0.00,'2022-09-05 21:44:16','',''),(142,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,6308000.00,33200.00,0.00,0.00,'2022-09-06 07:13:12','',''),(143,'8','212',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,17900.00,0.00,'2022-09-06 17:57:41','',''),(144,'8','212','1',1,'Received from bridging 14',0.00,0.00,17900.00,0.00,0.00,'2022-09-06 17:57:41','',''),(145,'8','212','1',1,'Sale Id shift 36',0.00,0.00,0.00,293.50,0.00,'2022-09-06 20:51:56','',''),(146,'8','212','1',1,'Sale Id shift 36',0.00,0.00,0.00,43.00,0.00,'2022-09-06 20:51:56','',''),(147,'8','212','2',1,'Sale Id shift 36',0.00,0.00,0.00,928.02,0.00,'2022-09-06 20:51:56','',''),(148,'8','212',NULL,1,'Sale Id shift 36',240258.80,0.00,0.00,0.00,0.00,'2022-09-06 20:51:56','',''),(149,'8','212','1',1,'Sale Id shift 37',0.00,0.00,0.00,526.57,0.00,'2022-09-07 20:41:20','',''),(150,'8','212','2',1,'Sale Id shift 37',0.00,0.00,0.00,241.09,0.00,'2022-09-07 20:41:20','',''),(151,'8','212',NULL,1,'Sale Id shift 37',145855.40,0.00,0.00,0.00,0.00,'2022-09-07 20:41:21','',''),(152,'8','212',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,15300.00,0.00,'2022-09-08 13:34:21','',''),(153,'8','212','2',1,'Received from bridging 15',0.00,0.00,15300.00,0.00,0.00,'2022-09-08 13:34:21','',''),(154,'8','212','1',1,'Sale Id shift 38',0.00,0.00,0.00,572.91,0.00,'2022-09-08 19:21:00','',''),(155,'8','212','1',1,'Sale Id shift 38',0.00,0.00,0.00,281.02,0.00,'2022-09-08 19:21:00','',''),(156,'8','212','2',1,'Sale Id shift 38',0.00,0.00,0.00,971.03,0.00,'2022-09-08 19:21:00','',''),(157,'8','212',NULL,1,'Sale Id shift 38',346742.40,0.00,0.00,0.00,0.00,'2022-09-08 19:21:00','',''),(158,'8','212','1',1,'Sale Id shift 39',0.00,0.00,0.00,144.24,0.00,'2022-09-10 09:27:12','',''),(159,'8','212','1',1,'Sale Id shift 39',0.00,0.00,0.00,153.07,0.00,'2022-09-10 09:27:12','',''),(160,'8','212','2',1,'Sale Id shift 39',0.00,0.00,0.00,651.42,0.00,'2022-09-10 09:27:12','',''),(161,'8','212','2',1,'Sale Id shift 39',0.00,0.00,0.00,389.26,0.00,'2022-09-10 09:27:12','',''),(162,'8','212',NULL,1,'Sale Id shift 39',254218.10,0.00,0.00,0.00,0.00,'2022-09-10 09:27:12','',''),(163,'8','212','1',1,'Sale Id shift 40',0.00,0.00,0.00,697.98,0.00,'2022-09-10 19:34:54','',''),(164,'8','212','2',1,'Sale Id shift 40',0.00,0.00,0.00,917.43,0.00,'2022-09-10 19:34:54','',''),(165,'8','212',NULL,1,'Sale Id shift 40',306927.90,0.00,0.00,0.00,0.00,'2022-09-10 19:34:54','',''),(166,'8','212','1',1,'Sale Id shift 41',0.00,0.00,0.00,2042.46,0.00,'2022-09-11 21:12:53','',''),(167,'8','212','1',1,'Sale Id shift 41',0.00,0.00,0.00,2054.72,0.00,'2022-09-11 21:12:53','',''),(168,'8','212','2',1,'Sale Id shift 41',0.00,0.00,0.00,2851.23,0.00,'2022-09-11 21:12:53','',''),(169,'8','212','2',1,'Sale Id shift 41',0.00,0.00,0.00,2131.25,0.00,'2022-09-11 21:12:53','',''),(170,'8','212',NULL,1,'Sale Id shift 41',1725135.40,0.00,0.00,0.00,0.00,'2022-09-11 21:12:53','',''),(171,'8','212','1',1,'Sale Id shift 42',0.00,0.00,0.00,99.21,0.00,'2022-09-12 19:26:15','',''),(172,'8','212','1',1,'Sale Id shift 42',0.00,0.00,0.00,1856.63,0.00,'2022-09-12 19:26:15','',''),(173,'8','212','2',1,'Sale Id shift 42',0.00,0.00,0.00,2843.31,0.00,'2022-09-12 19:26:15','',''),(174,'8','212',NULL,1,'Sale Id shift 42',911838.50,0.00,0.00,0.00,0.00,'2022-09-12 19:26:15','',''),(175,'8','212','1',1,'Sale Id shift 43',0.00,0.00,0.00,1508.11,0.00,'2022-09-13 21:12:41','',''),(176,'8','212','1',1,'Sale Id shift 43',0.00,0.00,0.00,294.28,0.00,'2022-09-13 21:12:41','',''),(177,'8','212','2',1,'Sale Id shift 43',0.00,0.00,0.00,1696.33,0.00,'2022-09-13 21:12:41','',''),(178,'8','212',NULL,1,'Sale Id shift 43',664756.80,0.00,0.00,0.00,0.00,'2022-09-13 21:12:41','',''),(179,'8','212','1',1,'Sale Id shift 44',0.00,0.00,0.00,1990.62,0.00,'2022-09-14 19:42:38','',''),(180,'8','212','2',1,'Sale Id shift 44',0.00,0.00,0.00,872.82,0.00,'2022-09-14 19:42:38','',''),(181,'8','212',NULL,1,'Sale Id shift 44',544053.60,0.00,0.00,0.00,0.00,'2022-09-14 19:42:38','',''),(182,'8','212','1',1,'Sale Id shift 45',0.00,0.00,0.00,1157.89,0.00,'2022-09-15 18:54:48','',''),(183,'8','212','2',1,'Sale Id shift 45',0.00,0.00,0.00,1140.65,0.00,'2022-09-15 18:54:48','',''),(184,'8','212','2',1,'Sale Id shift 45',0.00,0.00,0.00,467.09,0.00,'2022-09-15 18:54:48','',''),(185,'8','212',NULL,1,'Sale Id shift 45',525469.70,0.00,0.00,0.00,0.00,'2022-09-15 18:54:48','',''),(186,'8','212','1',1,'Sale Id shift 46',0.00,0.00,0.00,5.26,0.00,'2022-09-16 20:07:18','',''),(187,'8','212','1',1,'Sale Id shift 46',0.00,0.00,0.00,1319.81,0.00,'2022-09-16 20:07:18','',''),(188,'8','212','2',1,'Sale Id shift 46',0.00,0.00,0.00,1111.26,0.00,'2022-09-16 20:07:18','',''),(189,'8','212',NULL,1,'Sale Id shift 46',462902.70,0.00,0.00,0.00,0.00,'2022-09-16 20:07:18','',''),(190,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,6441000.00,33900.00,0.00,0.00,'2022-09-17 07:46:28','',''),(191,'8','212','1',1,'Sale Id shift 47',0.00,0.00,0.00,555.44,0.00,'2022-09-17 22:27:28','',''),(192,'8','212','2',1,'Sale Id shift 47',0.00,0.00,0.00,713.60,0.00,'2022-09-17 22:27:28','',''),(193,'8','212',NULL,1,'Sale Id shift 47',241117.60,0.00,0.00,0.00,0.00,'2022-09-17 22:27:28','',''),(194,'8','212','1',1,'Sale Id shift 48',0.00,0.00,0.00,1787.00,0.00,'2022-09-19 22:25:47','',''),(195,'8','212','1',1,'Sale Id shift 48',0.00,0.00,0.00,1291.62,0.00,'2022-09-19 22:25:47','',''),(196,'8','212','2',1,'Sale Id shift 48',0.00,0.00,0.00,1205.01,0.00,'2022-09-19 22:25:47','',''),(197,'8','212','2',1,'Sale Id shift 48',0.00,0.00,0.00,1067.57,0.00,'2022-09-19 22:25:47','',''),(198,'8','212',NULL,1,'Sale Id shift 48',1016728.00,0.00,0.00,0.00,0.00,'2022-09-19 22:25:47','',''),(199,'8','212','1',1,'Sale Id shift 49',0.00,0.00,0.00,382.30,0.00,'2022-09-20 10:10:25','',''),(200,'8','212','1',1,'Sale Id shift 49',0.00,0.00,0.00,126.78,0.00,'2022-09-20 10:10:25','',''),(201,'8','212','2',1,'Sale Id shift 49',0.00,0.00,0.00,672.53,0.00,'2022-09-20 10:10:25','',''),(202,'8','212',NULL,1,'Sale Id shift 49',224505.90,0.00,0.00,0.00,0.00,'2022-09-20 10:10:25','',''),(203,'8','212',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,16900.00,0.00,'2022-09-20 12:27:20','',''),(204,'8','212','1',1,'Received from bridging 16',0.00,0.00,16900.00,0.00,0.00,'2022-09-20 12:27:20','',''),(205,'8','212','1',1,'Sale Id shift 50',0.00,0.00,0.00,505.87,0.00,'2022-09-20 20:35:29','',''),(206,'8','212','1',1,'Sale Id shift 50',0.00,0.00,0.00,165.90,0.00,'2022-09-20 20:35:29','',''),(207,'8','212','2',1,'Sale Id shift 50',0.00,0.00,0.00,822.95,0.00,'2022-09-20 20:35:29','',''),(208,'8','212',NULL,1,'Sale Id shift 50',283996.80,0.00,0.00,0.00,0.00,'2022-09-20 20:35:29','',''),(209,'8','212',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,17000.00,0.00,'2022-09-21 14:55:21','',''),(210,'8','212','2',1,'Received from bridging 17',0.00,0.00,17000.00,0.00,0.00,'2022-09-21 14:55:21','',''),(211,'8','212','1',1,'Sale Id shift 51',0.00,0.00,0.00,663.61,0.00,'2022-09-21 21:49:03','',''),(212,'8','212','2',1,'Sale Id shift 51',0.00,0.00,0.00,698.13,0.00,'2022-09-21 21:49:03','',''),(213,'8','212',NULL,1,'Sale Id shift 51',258730.60,0.00,0.00,0.00,0.00,'2022-09-21 21:49:03','',''),(214,'8','212','1',1,'Sale Id shift 52',0.00,0.00,0.00,786.34,0.00,'2022-09-22 22:17:01','',''),(215,'8','212','1',1,'Sale Id shift 52',0.00,0.00,0.00,299.35,0.00,'2022-09-22 22:17:01','',''),(216,'8','212','2',1,'Sale Id shift 52',0.00,0.00,0.00,990.01,0.00,'2022-09-22 22:17:01','',''),(217,'8','212',NULL,1,'Sale Id shift 52',394383.00,0.00,0.00,0.00,0.00,'2022-09-22 22:17:01','',''),(218,'8','212','1',1,'Sale Id shift 53',0.00,0.00,0.00,196.31,0.00,'2022-09-23 20:15:08','',''),(219,'8','212','1',1,'Sale Id shift 53',0.00,0.00,0.00,608.42,0.00,'2022-09-23 20:15:08','',''),(220,'8','212','2',1,'Sale Id shift 53',0.00,0.00,0.00,1349.79,0.00,'2022-09-23 20:15:08','',''),(221,'8','212',NULL,1,'Sale Id shift 53',409358.80,0.00,0.00,0.00,0.00,'2022-09-23 20:15:08','',''),(222,'8','212','1',1,'Sale Id shift 54',0.00,0.00,0.00,1002.28,0.00,'2022-09-25 07:52:13','',''),(223,'8','212','2',1,'Sale Id shift 54',0.00,0.00,0.00,744.33,0.00,'2022-09-25 07:52:13','',''),(224,'8','212',NULL,1,'Sale Id shift 54',331855.90,0.00,0.00,0.00,0.00,'2022-09-25 07:52:13','',''),(225,'8','212','1',1,'Sale Id shift 55',0.00,0.00,0.00,3490.04,0.00,'2022-09-26 08:25:21','',''),(226,'8','212','1',1,'Sale Id shift 55',0.00,0.00,0.00,2400.49,0.00,'2022-09-26 08:25:21','',''),(227,'8','212','2',1,'Sale Id shift 55',0.00,0.00,0.00,2295.37,0.00,'2022-09-26 08:25:21','',''),(228,'8','212','2',1,'Sale Id shift 55',0.00,0.00,0.00,1979.64,0.00,'2022-09-26 08:25:21','',''),(229,'8','212',NULL,1,'Sale Id shift 55',1931452.60,0.00,0.00,0.00,0.00,'2022-09-26 08:25:21','',''),(230,'8','212','1',1,'Sale Id shift 56',0.00,0.00,0.00,1014.75,0.00,'2022-09-27 08:10:31','',''),(231,'8','212','1',1,'Sale Id shift 56',0.00,0.00,0.00,466.13,0.00,'2022-09-27 08:10:31','',''),(232,'8','212','2',1,'Sale Id shift 56',0.00,0.00,0.00,1344.75,0.00,'2022-09-27 08:10:31','',''),(233,'8','212',NULL,1,'Sale Id shift 56',536869.70,0.00,0.00,0.00,0.00,'2022-09-27 08:10:31','',''),(234,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,6270000.00,33000.00,0.00,0.00,'2022-09-27 16:13:51','',''),(235,'8','212','2',1,'Sale Id shift 57',0.00,0.00,0.00,891.56,0.00,'2022-09-27 19:27:12','',''),(236,'8','212','2',1,'Sale Id shift 57',0.00,0.00,0.00,536.73,0.00,'2022-09-27 19:27:12','',''),(237,'8','212',NULL,1,'Sale Id shift 57',271375.10,0.00,0.00,0.00,0.00,'2022-09-27 19:27:12','',''),(238,'8','212',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,18850.00,0.00,'2022-09-28 10:09:12','',''),(239,'8','212','1',1,'Received from bridging 18',0.00,0.00,18850.00,0.00,0.00,'2022-09-28 10:09:12','',''),(240,'8','212',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,14150.00,0.00,'2022-09-28 10:09:24','',''),(241,'8','212','2',1,'Received from bridging 19',0.00,0.00,14150.00,0.00,0.00,'2022-09-28 10:09:24','',''),(242,'8','212','2',1,'Sale Id shift 58',0.00,0.00,0.00,648.85,0.00,'2022-09-28 22:18:19','',''),(243,'8','212','2',1,'Sale Id shift 58',0.00,0.00,0.00,596.22,0.00,'2022-09-28 22:18:19','',''),(244,'8','212',NULL,1,'Sale Id shift 58',236563.30,0.00,0.00,0.00,0.00,'2022-09-28 22:18:19','',''),(245,'8','212','1',1,'Sale Id shift 59',0.00,0.00,0.00,1015.83,0.00,'2022-09-29 19:20:20','',''),(246,'8','212','2',1,'Sale Id shift 59',0.00,0.00,0.00,986.56,0.00,'2022-09-29 19:20:20','',''),(247,'8','212','2',1,'Sale Id shift 59',0.00,0.00,0.00,109.60,0.00,'2022-09-29 19:20:20','',''),(248,'8','212',NULL,1,'Sale Id shift 59',401278.10,0.00,0.00,0.00,0.00,'2022-09-29 19:20:20','',''),(249,'8','212','1',1,'Sale Id shift 60',0.00,0.00,0.00,1220.54,0.00,'2022-09-30 20:51:37','',''),(250,'8','212','1',1,'Sale Id shift 60',0.00,0.00,0.00,217.18,0.00,'2022-09-30 20:51:37','',''),(251,'8','212','2',1,'Sale Id shift 60',0.00,0.00,0.00,1070.27,0.00,'2022-09-30 20:51:37','',''),(252,'8','212',NULL,1,'Sale Id shift 60',476518.10,0.00,0.00,0.00,0.00,'2022-09-30 20:51:37','',''),(253,'8','212','1',1,'Sale Id shift 61',0.00,0.00,0.00,412.26,0.00,'2022-10-01 20:57:07','',''),(254,'8','212','1',1,'Sale Id shift 61',0.00,0.00,0.00,996.40,0.00,'2022-10-01 20:57:07','',''),(255,'8','212','2',1,'Sale Id shift 61',0.00,0.00,0.00,366.31,0.00,'2022-10-01 20:57:07','',''),(256,'8','212',NULL,1,'Sale Id shift 61',337244.30,0.00,0.00,0.00,0.00,'2022-10-01 20:57:07','',''),(257,'8','212','1',1,'Sale Id shift 62',0.00,0.00,0.00,1946.48,0.00,'2022-10-02 19:16:05','',''),(258,'8','212','1',1,'Sale Id shift 62',0.00,0.00,0.00,1370.05,0.00,'2022-10-02 19:16:05','',''),(259,'8','212','2',1,'Sale Id shift 62',0.00,0.00,0.00,1285.22,0.00,'2022-10-02 19:16:05','',''),(260,'8','212','2',1,'Sale Id shift 62',0.00,0.00,0.00,721.04,0.00,'2022-10-02 19:16:05','',''),(261,'8','212',NULL,1,'Sale Id shift 62',1011330.10,0.00,0.00,0.00,0.00,'2022-10-02 19:16:05','',''),(262,'8','212','1',1,'Sale Id shift 63',0.00,0.00,0.00,365.83,0.00,'2022-10-03 19:15:33','',''),(263,'8','212','1',1,'Sale Id shift 63',0.00,0.00,0.00,176.29,0.00,'2022-10-03 19:15:33','',''),(264,'8','212','2',1,'Sale Id shift 63',0.00,0.00,0.00,662.79,0.00,'2022-10-03 19:15:33','',''),(265,'8','212',NULL,1,'Sale Id shift 63',228932.90,0.00,0.00,0.00,0.00,'2022-10-03 19:15:33','',''),(266,'8','212','1',1,'Sale Id shift 64',0.00,0.00,0.00,670.57,0.00,'2022-10-04 15:30:23','',''),(267,'8','212','1',1,'Sale Id shift 64',0.00,0.00,0.00,291.52,0.00,'2022-10-04 15:30:23','',''),(268,'8','212','2',1,'Sale Id shift 64',0.00,0.00,0.00,433.89,0.00,'2022-10-04 15:30:23','',''),(269,'8','212',NULL,1,'Sale Id shift 64',265236.20,0.00,0.00,0.00,0.00,'2022-10-04 15:30:23','',''),(270,'8','212','1',1,'Sale Id shift 65',0.00,0.00,0.00,145.58,0.00,'2022-10-04 19:20:51','',''),(271,'8','212','2',1,'Sale Id shift 65',0.00,0.00,0.00,65.50,0.00,'2022-10-04 19:20:51','',''),(272,'8','212',NULL,1,'Sale Id shift 65',40105.20,0.00,0.00,0.00,0.00,'2022-10-04 19:20:51','',''),(273,'8','212','1',1,'Sale Id shift 66',0.00,0.00,0.00,186.41,0.00,'2022-10-05 20:42:15','',''),(274,'8','212','1',1,'Sale Id shift 66',0.00,0.00,0.00,901.78,0.00,'2022-10-05 20:42:15','',''),(275,'8','212','2',1,'Sale Id shift 66',0.00,0.00,0.00,704.68,0.00,'2022-10-05 20:42:15','',''),(276,'8','212',NULL,1,'Sale Id shift 66',340645.30,0.00,0.00,0.00,0.00,'2022-10-05 20:42:15','',''),(277,'8','212','1',1,'Sale Id shift 67',0.00,0.00,0.00,2309.27,0.00,'2022-10-06 18:58:26','',''),(278,'8','212','2',1,'Sale Id shift 67',0.00,0.00,0.00,1848.09,0.00,'2022-10-06 18:58:26','',''),(279,'8','212',NULL,1,'Sale Id shift 67',789898.40,0.00,0.00,0.00,0.00,'2022-10-06 18:58:26','',''),(280,'8','212','1',1,'Sale Id shift 68',0.00,0.00,0.00,843.06,0.00,'2022-10-07 19:24:44','',''),(281,'8','212','1',1,'Sale Id shift 68',0.00,0.00,0.00,3099.65,0.00,'2022-10-07 19:24:44','',''),(282,'8','212','2',1,'Sale Id shift 68',0.00,0.00,0.00,3147.63,0.00,'2022-10-07 19:24:44','',''),(283,'8','212',NULL,1,'Sale Id shift 68',1347164.60,0.00,0.00,0.00,0.00,'2022-10-07 19:24:44','',''),(284,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,3256500.00,16700.00,0.00,0.00,'2022-10-08 19:24:25','',''),(285,'8','212','1',1,'Sale Id shift 69',0.00,0.00,0.00,1150.68,0.00,'2022-10-08 21:53:33','',''),(286,'8','212','1',1,'Sale Id shift 69',0.00,0.00,0.00,1562.02,0.00,'2022-10-08 21:53:33','',''),(287,'8','212','2',1,'Sale Id shift 69',0.00,0.00,0.00,2729.10,0.00,'2022-10-08 21:53:33','',''),(288,'8','212','2',1,'Sale Id shift 69',0.00,0.00,0.00,1041.82,0.00,'2022-10-08 21:53:33','',''),(289,'8','212',NULL,1,'Sale Id shift 69',1231887.80,0.00,0.00,0.00,0.00,'2022-10-08 21:53:33','',''),(290,'8','212',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,7250.00,0.00,'2022-10-08 22:38:09','',''),(291,'8','212','1',1,'Received from bridging 20',0.00,0.00,7250.00,0.00,0.00,'2022-10-08 22:38:09','',''),(292,'8','212',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,9450.00,0.00,'2022-10-08 22:38:29','',''),(293,'8','212','2',1,'Received from bridging 21',0.00,0.00,9450.00,0.00,0.00,'2022-10-08 22:38:29','',''),(294,'8','212','1',1,'Sale Id shift 70',0.00,0.00,0.00,6039.51,0.00,'2022-10-10 09:34:37','',''),(295,'8','212','1',1,'Sale Id shift 70',0.00,0.00,0.00,1619.78,0.00,'2022-10-10 09:34:37','',''),(296,'8','212','2',1,'Sale Id shift 70',0.00,0.00,0.00,3117.17,0.00,'2022-10-10 09:34:37','',''),(297,'8','212','2',1,'Sale Id shift 70',0.00,0.00,0.00,5735.15,0.00,'2022-10-10 09:34:37','',''),(298,'8','212',NULL,1,'Sale Id shift 70',3219763.95,0.00,0.00,0.00,0.00,'2022-10-10 09:34:37','',''),(299,'8','212','1',1,'Sale Id shift 71',0.00,0.00,0.00,7415.18,0.00,'2022-10-10 22:14:28','',''),(300,'8','212','1',1,'Sale Id shift 71',0.00,0.00,0.00,5845.55,0.00,'2022-10-10 22:14:28','',''),(301,'8','212','2',1,'Sale Id shift 71',0.00,0.00,0.00,7312.54,0.00,'2022-10-10 22:14:28','',''),(302,'8','212','2',1,'Sale Id shift 71',0.00,0.00,0.00,5018.55,0.00,'2022-10-10 22:14:28','',''),(303,'8','212',NULL,1,'Sale Id shift 71',4990404.90,0.00,0.00,0.00,0.00,'2022-10-10 22:14:28','',''),(304,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,10300000.00,50000.00,0.00,0.00,'2022-10-12 05:52:44','',''),(305,'8','212',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,32100.00,0.00,'2022-10-12 16:41:16','',''),(306,'8','212','1',1,'Received from bridging 22',0.00,0.00,32100.00,0.00,0.00,'2022-10-12 16:41:16','',''),(307,'8','212',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,17900.00,0.00,'2022-10-12 16:41:31','',''),(308,'8','212','2',1,'Received from bridging 23',0.00,0.00,17900.00,0.00,0.00,'2022-10-12 16:41:31','',''),(309,'8','212','1',1,'Sale Id shift 73',0.00,0.00,0.00,1681.30,0.00,'2022-10-12 18:50:59','',''),(310,'8','212','1',1,'Sale Id shift 73',0.00,0.00,0.00,5799.66,0.00,'2022-10-12 18:50:59','',''),(311,'8','212','2',1,'Sale Id shift 73',0.00,0.00,0.00,3666.32,0.00,'2022-10-12 18:50:59','',''),(312,'8','212','2',1,'Sale Id shift 73',0.00,0.00,0.00,3007.86,0.00,'2022-10-12 18:50:59','',''),(313,'8','212',NULL,1,'Sale Id shift 73',2915958.84,0.00,0.00,0.00,0.00,'2022-10-12 18:50:59','',''),(314,'8','212','1',1,'Sale Id shift 74',0.00,0.00,0.00,3379.21,0.00,'2022-10-12 20:18:19','',''),(315,'8','212','1',1,'Sale Id shift 74',0.00,0.00,0.00,3636.58,0.00,'2022-10-12 20:18:19','',''),(316,'8','212','2',1,'Sale Id shift 74',0.00,0.00,0.00,1541.60,0.00,'2022-10-12 20:18:19','',''),(317,'8','212','2',1,'Sale Id shift 74',0.00,0.00,0.00,1545.55,0.00,'2022-10-12 20:18:19','',''),(318,'8','212',NULL,1,'Sale Id shift 74',2222646.80,0.00,0.00,0.00,0.00,'2022-10-12 20:18:19','',''),(319,'8','212','1',1,'Sale Id shift 75',0.00,0.00,0.00,4196.40,0.00,'2022-10-13 20:01:07','',''),(320,'8','212','1',1,'Sale Id shift 75',0.00,0.00,0.00,4252.51,0.00,'2022-10-13 20:01:07','',''),(321,'8','212','2',1,'Sale Id shift 75',0.00,0.00,0.00,3371.96,0.00,'2022-10-13 20:01:07','',''),(322,'8','212','2',1,'Sale Id shift 75',0.00,0.00,0.00,1659.27,0.00,'2022-10-13 20:01:07','',''),(323,'8','212',NULL,1,'Sale Id shift 75',2965630.80,0.00,0.00,0.00,0.00,'2022-10-13 20:01:07','',''),(324,'8','212','1',1,'Sale Id shift 76',0.00,0.00,0.00,3849.75,0.00,'2022-10-14 22:51:56','',''),(325,'8','212','1',1,'Sale Id shift 76',0.00,0.00,0.00,2322.65,0.00,'2022-10-14 22:51:56','',''),(326,'8','212','2',1,'Sale Id shift 76',0.00,0.00,0.00,1387.49,0.00,'2022-10-14 22:51:56','',''),(327,'8','212','2',1,'Sale Id shift 76',0.00,0.00,0.00,1578.79,0.00,'2022-10-14 22:51:56','',''),(328,'8','212',NULL,1,'Sale Id shift 76',2010509.60,0.00,0.00,0.00,0.00,'2022-10-14 22:51:56','',''),(329,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,3825000.00,17000.00,0.00,0.00,'2022-10-15 19:52:02','',''),(330,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,7200000.00,32000.00,0.00,0.00,'2022-10-19 22:36:48','',''),(331,'8','212',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,17000.00,0.00,'2022-10-20 11:31:51','',''),(332,'8','212','1',1,'Received from bridging 24',0.00,0.00,17000.00,0.00,0.00,'2022-10-20 11:31:51','',''),(333,'8','212',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,14700.00,0.00,'2022-10-20 11:32:18','',''),(334,'8','212','2',1,'Received from bridging 26',0.00,0.00,14700.00,0.00,0.00,'2022-10-20 11:32:18','',''),(335,'8','212','1',1,'Sale Id shift 78',0.00,0.00,0.00,1406.75,0.00,'2022-10-20 13:28:44','',''),(336,'8','212','1',1,'Sale Id shift 78',0.00,0.00,0.00,2101.12,0.00,'2022-10-20 13:28:44','',''),(337,'8','212','2',1,'Sale Id shift 78',0.00,0.00,0.00,887.71,0.00,'2022-10-20 13:28:44','',''),(338,'8','212','2',1,'Sale Id shift 78',0.00,0.00,0.00,2403.55,0.00,'2022-10-20 13:28:44','',''),(339,'8','212',NULL,1,'Sale Id shift 78',1529804.25,0.00,0.00,0.00,0.00,'2022-10-20 13:28:44','',''),(340,'8','212','1',1,'Sale Id shift 79',0.00,0.00,0.00,4206.28,0.00,'2022-10-20 13:36:49','',''),(341,'8','212','1',1,'Sale Id shift 79',0.00,0.00,0.00,7554.87,0.00,'2022-10-20 13:36:49','',''),(342,'8','212',NULL,1,'Sale Id shift 79',2646258.75,0.00,0.00,0.00,0.00,'2022-10-20 13:36:49','',''),(343,'8','212',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,17300.00,0.00,'2022-10-20 13:55:49','',''),(344,'8','212','1',1,'Received from bridging 25',0.00,0.00,17300.00,0.00,0.00,'2022-10-20 13:55:49','',''),(345,'8','212','1',1,'Sale Id shift 80',0.00,0.00,0.00,3537.93,0.00,'2022-10-20 13:58:00','',''),(346,'8','212','1',1,'Sale Id shift 80',0.00,0.00,0.00,2182.49,0.00,'2022-10-20 13:58:00','',''),(347,'8','212',NULL,1,'Sale Id shift 80',1287094.50,0.00,0.00,0.00,0.00,'2022-10-20 13:58:00','',''),(348,'8','212','1',1,'Sale Id shift 81',0.00,0.00,0.00,3715.28,0.00,'2022-10-20 18:54:30','',''),(349,'8','212','1',1,'Sale Id shift 81',0.00,0.00,0.00,1236.55,0.00,'2022-10-20 18:54:30','',''),(350,'8','212','2',1,'Sale Id shift 81',0.00,0.00,0.00,3536.06,0.00,'2022-10-20 18:54:30','',''),(351,'8','212','2',1,'Sale Id shift 81',0.00,0.00,0.00,1098.26,0.00,'2022-10-20 18:54:30','',''),(352,'8','212',NULL,1,'Sale Id shift 81',2204814.50,0.00,0.00,0.00,0.00,'2022-10-20 18:54:30','',''),(353,'8','212','1',1,'Sale Id shift 82',0.00,0.00,0.00,649.92,0.00,'2022-10-21 19:24:27','',''),(354,'8','212','1',1,'Sale Id shift 82',0.00,0.00,0.00,2268.94,0.00,'2022-10-21 19:24:27','',''),(355,'8','212','2',1,'Sale Id shift 82',0.00,0.00,0.00,2299.42,0.00,'2022-10-21 19:24:27','',''),(356,'8','212','2',1,'Sale Id shift 82',0.00,0.00,0.00,316.68,0.00,'2022-10-21 19:24:27','',''),(357,'8','212',NULL,1,'Sale Id shift 82',1273040.80,0.00,0.00,0.00,0.00,'2022-10-21 19:24:27','',''),(358,'8','212','1',1,'Sale Id shift 83',0.00,0.00,0.00,534.65,0.00,'2022-10-22 20:33:29','',''),(359,'8','212','1',1,'Sale Id shift 83',0.00,0.00,0.00,2252.63,0.00,'2022-10-22 20:33:29','',''),(360,'8','212','2',1,'Sale Id shift 83',0.00,0.00,0.00,1999.22,0.00,'2022-10-22 20:33:29','',''),(361,'8','212',NULL,1,'Sale Id shift 83',1124827.50,0.00,0.00,0.00,0.00,'2022-10-22 20:33:29','',''),(362,'8','212','1',1,'Sale Id shift 84',0.00,0.00,0.00,2916.27,0.00,'2022-10-23 18:33:19','',''),(363,'8','212','1',1,'Sale Id shift 84',0.00,0.00,0.00,1739.63,0.00,'2022-10-23 18:33:19','',''),(364,'8','212','2',1,'Sale Id shift 84',0.00,0.00,0.00,1949.18,0.00,'2022-10-23 18:33:19','',''),(365,'8','212','2',1,'Sale Id shift 84',0.00,0.00,0.00,1424.26,0.00,'2022-10-23 18:33:19','',''),(366,'8','212',NULL,1,'Sale Id shift 84',1886894.90,0.00,0.00,0.00,0.00,'2022-10-23 18:33:19','',''),(367,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,7755000.00,33000.00,0.00,0.00,'2022-10-25 05:42:27','',''),(368,'8','212',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,16000.00,0.00,'2022-10-25 11:10:24','',''),(369,'8','212','2',1,'Received from bridging 28',0.00,0.00,16000.00,0.00,0.00,'2022-10-25 11:10:24','',''),(370,'8','212',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,17000.00,0.00,'2022-10-25 11:10:24','',''),(371,'8','212','1',1,'Received from bridging 27',0.00,0.00,17000.00,0.00,0.00,'2022-10-25 11:10:24','',''),(372,'8','212','1',1,'Sale Id shift 85',0.00,0.00,0.00,1054.47,0.00,'2022-10-25 11:14:09','',''),(373,'8','212','1',1,'Sale Id shift 85',0.00,0.00,0.00,1023.26,0.00,'2022-10-25 11:14:09','',''),(374,'8','212','2',1,'Sale Id shift 85',0.00,0.00,0.00,1182.32,0.00,'2022-10-25 11:14:09','',''),(375,'8','212','2',1,'Sale Id shift 85',0.00,0.00,0.00,513.68,0.00,'2022-10-25 11:14:09','',''),(376,'8','212',NULL,1,'Sale Id shift 85',886826.55,0.00,0.00,0.00,0.00,'2022-10-25 11:14:09','',''),(377,'8','212','1',1,'Sale Id shift 86',0.00,0.00,0.00,2949.21,0.00,'2022-10-25 20:15:54','',''),(378,'8','212','1',1,'Sale Id shift 86',0.00,0.00,0.00,2941.98,0.00,'2022-10-25 20:15:54','',''),(379,'8','212','2',1,'Sale Id shift 86',0.00,0.00,0.00,2620.22,0.00,'2022-10-25 20:15:54','',''),(380,'8','212','2',1,'Sale Id shift 86',0.00,0.00,0.00,1524.48,0.00,'2022-10-25 20:15:54','',''),(381,'8','212',NULL,1,'Sale Id shift 86',2358434.15,0.00,0.00,0.00,0.00,'2022-10-25 20:15:54','',''),(382,'8','212','1',1,'Sale Id shift 88',0.00,0.00,0.00,1521.99,0.00,'2022-10-27 05:23:43','',''),(383,'8','212','1',1,'Sale Id shift 88',0.00,0.00,0.00,1110.06,0.00,'2022-10-27 05:23:43','',''),(384,'8','212','2',1,'Sale Id shift 88',0.00,0.00,0.00,848.94,0.00,'2022-10-27 05:23:43','',''),(385,'8','212','2',1,'Sale Id shift 88',0.00,0.00,0.00,237.73,0.00,'2022-10-27 05:23:43','',''),(386,'8','212',NULL,1,'Sale Id shift 88',929680.00,0.00,0.00,0.00,0.00,'2022-10-27 05:23:43','',''),(387,'8','212','1',1,'Sale Id shift 89',0.00,0.00,0.00,1259.73,0.00,'2022-10-28 07:46:46','',''),(388,'8','212','1',1,'Sale Id shift 89',0.00,0.00,0.00,1453.02,0.00,'2022-10-28 07:46:46','',''),(389,'8','212','2',1,'Sale Id shift 89',0.00,0.00,0.00,1541.84,0.00,'2022-10-28 07:46:46','',''),(390,'8','212','2',1,'Sale Id shift 89',0.00,0.00,0.00,867.96,0.00,'2022-10-28 07:46:46','',''),(391,'8','212',NULL,1,'Sale Id shift 89',1280637.50,0.00,0.00,0.00,0.00,'2022-10-28 07:46:46','',''),(392,'8','212','1',1,'Sale Id shift 90',0.00,0.00,0.00,2046.52,0.00,'2022-10-28 19:57:02','',''),(393,'8','212','1',1,'Sale Id shift 90',0.00,0.00,0.00,1200.04,0.00,'2022-10-28 19:57:02','',''),(394,'8','212','2',1,'Sale Id shift 90',0.00,0.00,0.00,2501.82,0.00,'2022-10-28 19:57:02','',''),(395,'8','212','2',1,'Sale Id shift 90',0.00,0.00,0.00,1701.42,0.00,'2022-10-28 19:57:02','',''),(396,'8','212',NULL,1,'Sale Id shift 90',1862450.00,0.00,0.00,0.00,0.00,'2022-10-28 19:57:02','',''),(397,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,8415000.00,33000.00,0.00,0.00,'2022-11-04 11:10:07','',''),(398,'8','212',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,16000.00,0.00,'2022-11-04 20:37:37','',''),(399,'8','212','2',1,'Received from bridging 30',0.00,0.00,16000.00,0.00,0.00,'2022-11-04 20:37:37','',''),(400,'8','212',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,17000.00,0.00,'2022-11-04 20:37:37','',''),(401,'8','212','1',1,'Received from bridging 29',0.00,0.00,17000.00,0.00,0.00,'2022-11-04 20:37:37','',''),(402,'8','212','1',1,'Sale Id shift 91',0.00,0.00,0.00,959.91,0.00,'2022-11-04 20:41:08','',''),(403,'8','212','1',1,'Sale Id shift 91',0.00,0.00,0.00,980.71,0.00,'2022-11-04 20:41:08','',''),(404,'8','212','2',1,'Sale Id shift 91',0.00,0.00,0.00,969.70,0.00,'2022-11-04 20:41:08','',''),(405,'8','212','2',1,'Sale Id shift 91',0.00,0.00,0.00,2587.63,0.00,'2022-11-04 20:41:08','',''),(406,'8','212',NULL,1,'Sale Id shift 91',1374487.50,0.00,0.00,0.00,0.00,'2022-11-04 20:41:08','',''),(407,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,4335000.00,17000.00,0.00,0.00,'2022-11-04 22:45:46','',''),(408,'8','212',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,8800.00,0.00,'2022-11-05 13:17:11','',''),(409,'8','212','2',1,'Received from bridging 32',0.00,0.00,8800.00,0.00,0.00,'2022-11-05 13:17:11','',''),(410,'8','212',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,8200.00,0.00,'2022-11-05 13:17:11','',''),(411,'8','212','1',1,'Received from bridging 31',0.00,0.00,8200.00,0.00,0.00,'2022-11-05 13:17:11','',''),(412,'8','212','1',1,'Sale Id shift 92',0.00,0.00,0.00,166.19,0.00,'2022-11-05 18:29:33','',''),(413,'8','212','1',1,'Sale Id shift 92',0.00,0.00,0.00,680.56,0.00,'2022-11-05 18:29:33','',''),(414,'8','212','2',1,'Sale Id shift 92',0.00,0.00,0.00,1027.84,0.00,'2022-11-05 18:29:33','',''),(415,'8','212',NULL,1,'Sale Id shift 92',478020.45,0.00,0.00,0.00,0.00,'2022-11-05 18:29:33','',''),(416,'8','212','1',1,'Sale Id shift 93',0.00,0.00,0.00,705.21,0.00,'2022-11-06 21:19:31','',''),(417,'8','212','1',1,'Sale Id shift 93',0.00,0.00,0.00,685.42,0.00,'2022-11-06 21:19:31','',''),(418,'8','212','2',1,'Sale Id shift 93',0.00,0.00,0.00,678.55,0.00,'2022-11-06 21:19:31','',''),(419,'8','212','2',1,'Sale Id shift 93',0.00,0.00,0.00,630.82,0.00,'2022-11-06 21:19:31','',''),(420,'8','212',NULL,1,'Sale Id shift 93',688500.00,0.00,0.00,0.00,0.00,'2022-11-06 21:19:31','',''),(421,'8','212','1',1,'Sale Id shift 94',0.00,0.00,0.00,2495.78,0.00,'2022-11-06 21:28:32','',''),(422,'8','212','1',1,'Sale Id shift 94',0.00,0.00,0.00,2114.48,0.00,'2022-11-06 21:28:32','',''),(423,'8','212','2',1,'Sale Id shift 94',0.00,0.00,0.00,2445.21,0.00,'2022-11-06 21:28:32','',''),(424,'8','212','2',1,'Sale Id shift 94',0.00,0.00,0.00,1339.42,0.00,'2022-11-06 21:28:32','',''),(425,'8','212',NULL,1,'Sale Id shift 94',2098722.50,0.00,0.00,0.00,0.00,'2022-11-06 21:28:32','',''),(426,'8','212','1',1,'Sale Id shift 95',0.00,0.00,0.00,2268.86,0.00,'2022-11-07 21:30:49','',''),(427,'8','212','1',1,'Sale Id shift 95',0.00,0.00,0.00,852.20,0.00,'2022-11-07 21:30:49','',''),(428,'8','212','2',1,'Sale Id shift 95',0.00,0.00,0.00,2111.33,0.00,'2022-11-07 21:30:49','',''),(429,'8','212',NULL,1,'Sale Id shift 95',1308097.50,0.00,0.00,0.00,0.00,'2022-11-07 21:30:49','',''),(430,'8','212','1',1,'Sale Id shift 96',0.00,0.00,0.00,2488.34,0.00,'2022-11-08 20:49:52','',''),(431,'8','212','1',1,'Sale Id shift 96',0.00,0.00,0.00,263.80,0.00,'2022-11-08 20:49:52','',''),(432,'8','212','2',1,'Sale Id shift 96',0.00,0.00,0.00,2954.61,0.00,'2022-11-08 20:49:52','',''),(433,'8','212','2',1,'Sale Id shift 96',0.00,0.00,0.00,309.91,0.00,'2022-11-08 20:49:52','',''),(434,'8','212',NULL,1,'Sale Id shift 96',1504165.00,0.00,0.00,0.00,0.00,'2022-11-08 20:49:52','',''),(435,'8','212','1',1,'Sale Id shift 97',0.00,0.00,0.00,1079.23,0.00,'2022-11-09 19:10:45','',''),(436,'8','212','1',1,'Sale Id shift 97',0.00,0.00,0.00,2700.59,0.00,'2022-11-09 19:10:45','',''),(437,'8','212','2',1,'Sale Id shift 97',0.00,0.00,0.00,2497.87,0.00,'2022-11-09 19:10:45','',''),(438,'8','212','2',1,'Sale Id shift 97',0.00,0.00,0.00,867.65,0.00,'2022-11-09 19:10:45','',''),(439,'8','212',NULL,1,'Sale Id shift 97',1786335.00,0.00,0.00,0.00,0.00,'2022-11-09 19:10:45','',''),(440,'8','212','1',1,'Sale Id shift 98',0.00,0.00,0.00,2330.56,0.00,'2022-11-10 18:45:02','',''),(441,'8','212','1',1,'Sale Id shift 98',0.00,0.00,0.00,12.61,0.00,'2022-11-10 18:45:02','',''),(442,'8','212','2',1,'Sale Id shift 98',0.00,0.00,0.00,3150.70,0.00,'2022-11-10 18:45:02','',''),(443,'8','212','2',1,'Sale Id shift 98',0.00,0.00,0.00,1599.01,0.00,'2022-11-10 18:45:02','',''),(444,'8','212',NULL,1,'Sale Id shift 98',1773220.00,0.00,0.00,0.00,0.00,'2022-11-10 18:45:02','',''),(445,'8','212','1',1,'Sale Id shift 99',0.00,0.00,0.00,840.18,0.00,'2022-11-11 19:24:13','',''),(446,'8','212','1',1,'Sale Id shift 99',0.00,0.00,0.00,2558.70,0.00,'2022-11-11 19:24:13','',''),(447,'8','212','2',1,'Sale Id shift 99',0.00,0.00,0.00,2377.68,0.00,'2022-11-11 19:24:13','',''),(448,'8','212','2',1,'Sale Id shift 99',0.00,0.00,0.00,910.65,0.00,'2022-11-11 19:24:13','',''),(449,'8','212',NULL,1,'Sale Id shift 99',1671802.50,0.00,0.00,0.00,0.00,'2022-11-11 19:24:13','',''),(450,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,4175000.00,16700.00,0.00,0.00,'2022-11-12 15:38:54','',''),(451,'8','212',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,16700.00,0.00,'2022-11-12 18:36:24','',''),(452,'8','212','2',1,'Received from bridging 33',0.00,0.00,16700.00,0.00,0.00,'2022-11-12 18:36:24','',''),(453,'8','212','1',1,'Sale Id shift 100',0.00,0.00,0.00,1474.86,0.00,'2022-11-12 18:39:44','',''),(454,'8','212','1',1,'Sale Id shift 100',0.00,0.00,0.00,782.49,0.00,'2022-11-12 18:39:44','',''),(455,'8','212','2',1,'Sale Id shift 100',0.00,0.00,0.00,3023.65,0.00,'2022-11-12 18:39:44','',''),(456,'8','212','2',1,'Sale Id shift 100',0.00,0.00,0.00,2822.01,0.00,'2022-11-12 18:39:44','',''),(457,'8','212',NULL,1,'Sale Id shift 100',2025752.50,0.00,0.00,0.00,0.00,'2022-11-12 18:39:44','',''),(458,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,4335000.00,17000.00,0.00,0.00,'2022-11-15 11:44:14','',''),(459,'8','212',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,17000.00,0.00,'2022-11-15 20:18:12','',''),(460,'8','212','1',1,'Received from bridging 34',0.00,0.00,17000.00,0.00,0.00,'2022-11-15 20:18:12','',''),(461,'8','212','1',1,'Sale Id shift 101',0.00,0.00,0.00,424.53,0.00,'2022-11-15 20:23:24','',''),(462,'8','212','1',1,'Sale Id shift 101',0.00,0.00,0.00,383.98,0.00,'2022-11-15 20:23:24','',''),(463,'8','212','2',1,'Sale Id shift 101',0.00,0.00,0.00,2099.45,0.00,'2022-11-15 20:23:24','',''),(464,'8','212','2',1,'Sale Id shift 101',0.00,0.00,0.00,3539.42,0.00,'2022-11-15 20:23:24','',''),(465,'8','212',NULL,1,'Sale Id shift 101',1644081.90,0.00,0.00,0.00,0.00,'2022-11-15 20:23:24','',''),(466,'8','212','2',1,'Sale Id shift 102',0.00,0.00,0.00,1310.06,0.00,'2022-11-15 20:32:37','',''),(467,'8','212','2',1,'Sale Id shift 102',0.00,0.00,0.00,1749.86,0.00,'2022-11-15 20:32:37','',''),(468,'8','212',NULL,1,'Sale Id shift 102',780279.60,0.00,0.00,0.00,0.00,'2022-11-15 20:32:37','',''),(469,'8','212','1',1,'Sale Id shift 103',0.00,0.00,0.00,1846.64,0.00,'2022-11-15 20:38:39','',''),(470,'8','212','2',1,'Sale Id shift 103',0.00,0.00,0.00,2265.46,0.00,'2022-11-15 20:38:39','',''),(471,'8','212','2',1,'Sale Id shift 103',0.00,0.00,0.00,1622.75,0.00,'2022-11-15 20:38:39','',''),(472,'8','212',NULL,1,'Sale Id shift 103',1462386.75,0.00,0.00,0.00,0.00,'2022-11-15 20:38:39','',''),(473,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,4335000.00,17000.00,0.00,0.00,'2022-11-17 11:15:04','',''),(474,'8','212',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,17000.00,0.00,'2022-11-17 12:56:30','',''),(475,'8','212','2',1,'Received from bridging 35',0.00,0.00,17000.00,0.00,0.00,'2022-11-17 12:56:30','',''),(476,'8','212','1',1,'Sale Id shift 104',0.00,0.00,0.00,865.65,0.00,'2022-11-17 13:01:34','',''),(477,'8','212','1',1,'Sale Id shift 104',0.00,0.00,0.00,2427.71,0.00,'2022-11-17 13:01:34','',''),(478,'8','212','2',1,'Sale Id shift 104',0.00,0.00,0.00,2135.50,0.00,'2022-11-17 13:01:34','',''),(479,'8','212','2',1,'Sale Id shift 104',0.00,0.00,0.00,88.15,0.00,'2022-11-17 13:01:34','',''),(480,'8','212',NULL,1,'Sale Id shift 104',1406837.55,0.00,0.00,0.00,0.00,'2022-11-17 13:01:34','',''),(481,'8','212','1',1,'Sale Id shift 105',0.00,0.00,0.00,3022.76,0.00,'2022-11-18 12:16:58','',''),(482,'8','212','1',1,'Sale Id shift 105',0.00,0.00,0.00,535.41,0.00,'2022-11-18 12:16:58','',''),(483,'8','212','2',1,'Sale Id shift 105',0.00,0.00,0.00,2634.17,0.00,'2022-11-18 12:16:58','',''),(484,'8','212',NULL,1,'Sale Id shift 105',1579046.70,0.00,0.00,0.00,0.00,'2022-11-18 12:16:58','',''),(485,'8','212','1',1,'Sale Id shift 106',0.00,0.00,0.00,397.24,0.00,'2022-11-18 19:02:44','',''),(486,'8','212','1',1,'Sale Id shift 106',0.00,0.00,0.00,1691.64,0.00,'2022-11-18 19:02:44','',''),(487,'8','212','2',1,'Sale Id shift 106',0.00,0.00,0.00,3189.00,0.00,'2022-11-18 19:02:44','',''),(488,'8','212','2',1,'Sale Id shift 106',0.00,0.00,0.00,2010.13,0.00,'2022-11-18 19:02:44','',''),(489,'8','212',NULL,1,'Sale Id shift 106',1858442.55,0.00,0.00,0.00,0.00,'2022-11-18 19:02:44','',''),(490,'8','212','1',1,'Sale Id shift 107',0.00,0.00,0.00,1067.00,0.00,'2022-11-20 06:56:11','',''),(491,'8','212','2',1,'Sale Id shift 107',0.00,0.00,0.00,2037.22,0.00,'2022-11-20 06:56:11','',''),(492,'8','212','2',1,'Sale Id shift 107',0.00,0.00,0.00,2292.64,0.00,'2022-11-20 06:56:11','',''),(493,'8','212',NULL,1,'Sale Id shift 107',1376199.30,0.00,0.00,0.00,0.00,'2022-11-20 06:56:11','',''),(494,'8','212','1',1,'Sale Id shift 108',0.00,0.00,0.00,2256.43,0.00,'2022-11-20 19:54:19','',''),(495,'8','212','1',1,'Sale Id shift 108',0.00,0.00,0.00,2149.65,0.00,'2022-11-20 19:54:19','',''),(496,'8','212','2',1,'Sale Id shift 108',0.00,0.00,0.00,2080.15,0.00,'2022-11-20 19:54:19','',''),(497,'8','212','2',1,'Sale Id shift 108',0.00,0.00,0.00,1853.80,0.00,'2022-11-20 19:54:19','',''),(498,'8','212',NULL,1,'Sale Id shift 108',2126707.65,0.00,0.00,0.00,0.00,'2022-11-20 19:54:19','',''),(499,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,8415000.00,33000.00,0.00,0.00,'2022-11-22 20:36:40','',''),(500,'8','212',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,16000.00,0.00,'2022-11-22 21:10:20','',''),(501,'8','212','2',1,'Received from bridging 37',0.00,0.00,16000.00,0.00,0.00,'2022-11-22 21:10:20','',''),(502,'8','212',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,17000.00,0.00,'2022-11-22 21:10:20','',''),(503,'8','212','1',1,'Received from bridging 36',0.00,0.00,17000.00,0.00,0.00,'2022-11-22 21:10:20','',''),(504,'8','212','1',1,'Sale Id shift 109',0.00,0.00,0.00,457.15,0.00,'2022-11-22 21:14:37','',''),(505,'8','212','1',1,'Sale Id shift 109',0.00,0.00,0.00,360.58,0.00,'2022-11-22 21:14:37','',''),(506,'8','212',NULL,1,'Sale Id shift 109',208521.15,0.00,0.00,0.00,0.00,'2022-11-22 21:14:37','',''),(507,'8','212','1',1,'Sale Id shift 110',0.00,0.00,0.00,1177.12,0.00,'2022-11-23 08:02:27','',''),(508,'8','212','1',1,'Sale Id shift 110',0.00,0.00,0.00,270.65,0.00,'2022-11-23 08:02:27','',''),(509,'8','212','2',1,'Sale Id shift 110',0.00,0.00,0.00,1365.20,0.00,'2022-11-23 08:02:27','',''),(510,'8','212','2',1,'Sale Id shift 110',0.00,0.00,0.00,517.46,0.00,'2022-11-23 08:02:27','',''),(511,'8','212',NULL,1,'Sale Id shift 110',849259.65,0.00,0.00,0.00,0.00,'2022-11-23 08:02:27','',''),(512,'8','212','1',1,'Sale Id shift 111',0.00,0.00,0.00,588.71,0.00,'2022-11-24 07:41:34','',''),(513,'8','212','1',1,'Sale Id shift 111',0.00,0.00,0.00,2045.49,0.00,'2022-11-24 07:41:34','',''),(514,'8','212','2',1,'Sale Id shift 111',0.00,0.00,0.00,2146.32,0.00,'2022-11-24 07:41:34','',''),(515,'8','212','2',1,'Sale Id shift 111',0.00,0.00,0.00,389.73,0.00,'2022-11-24 07:41:34','',''),(516,'8','212',NULL,1,'Sale Id shift 111',1318413.75,0.00,0.00,0.00,0.00,'2022-11-24 07:41:34','',''),(517,'8','212','1',1,'Sale Id shift 112',0.00,0.00,0.00,2571.47,0.00,'2022-11-25 09:34:10','',''),(518,'8','212','1',1,'Sale Id shift 112',0.00,0.00,0.00,296.83,0.00,'2022-11-25 09:34:10','',''),(519,'8','212','2',1,'Sale Id shift 112',0.00,0.00,0.00,3520.15,0.00,'2022-11-25 09:34:10','',''),(520,'8','212','2',1,'Sale Id shift 112',0.00,0.00,0.00,42.00,0.00,'2022-11-25 09:34:10','',''),(521,'8','212',NULL,1,'Sale Id shift 112',1639764.75,0.00,0.00,0.00,0.00,'2022-11-25 09:34:10','',''),(522,'8','212','1',1,'Sale Id shift 113',0.00,0.00,0.00,597.20,0.00,'2022-11-25 19:00:55','',''),(523,'8','212','1',1,'Sale Id shift 113',0.00,0.00,0.00,2305.28,0.00,'2022-11-25 19:00:55','',''),(524,'8','212','2',1,'Sale Id shift 113',0.00,0.00,0.00,2543.41,0.00,'2022-11-25 19:00:55','',''),(525,'8','212','2',1,'Sale Id shift 113',0.00,0.00,0.00,314.31,0.00,'2022-11-25 19:00:55','',''),(526,'8','212',NULL,1,'Sale Id shift 113',1468851.00,0.00,0.00,0.00,0.00,'2022-11-25 19:00:55','',''),(527,'8','212','1',1,'Sale Id shift 114',0.00,0.00,0.00,526.18,0.00,'2022-11-27 08:37:57','',''),(528,'8','212','1',1,'Sale Id shift 114',0.00,0.00,0.00,1144.63,0.00,'2022-11-27 08:37:57','',''),(529,'8','212','2',1,'Sale Id shift 114',0.00,0.00,0.00,668.27,0.00,'2022-11-27 08:37:57','',''),(530,'8','212','2',1,'Sale Id shift 114',0.00,0.00,0.00,360.00,0.00,'2022-11-27 08:37:57','',''),(531,'8','212',NULL,1,'Sale Id shift 114',701760.80,0.00,0.00,0.00,0.00,'2022-11-27 08:37:57','',''),(532,'8','212','1',1,'Sale Id shift 115',0.00,0.00,0.00,2955.24,0.00,'2022-11-27 18:39:46','',''),(533,'8','212','1',1,'Sale Id shift 115',0.00,0.00,0.00,1621.79,0.00,'2022-11-27 18:39:46','',''),(534,'8','212','2',1,'Sale Id shift 115',0.00,0.00,0.00,2721.87,0.00,'2022-11-27 18:39:46','',''),(535,'8','212','2',1,'Sale Id shift 115',0.00,0.00,0.00,916.62,0.00,'2022-11-27 18:39:46','',''),(536,'8','212',NULL,1,'Sale Id shift 115',2136035.20,0.00,0.00,0.00,0.00,'2022-11-27 18:39:46','',''),(537,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,8320000.00,32000.00,0.00,0.00,'2022-12-01 10:55:42','',''),(538,'8','212',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,32000.00,0.00,'2022-12-01 18:40:11','',''),(539,'8','212','2',1,'Received from bridging 38',0.00,0.00,32000.00,0.00,0.00,'2022-12-01 18:40:11','',''),(540,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,270000.00,1000.00,0.00,0.00,'2022-12-03 14:40:01','',''),(541,'8','212',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,1000.00,0.00,'2022-12-03 14:44:06','',''),(542,'8','212','1',1,'Received from bridging 39',0.00,0.00,1000.00,0.00,0.00,'2022-12-03 14:44:06','',''),(543,'8','212','1',1,'Sale Id shift 116',0.00,0.00,0.00,845.69,0.00,'2022-12-03 14:48:08','',''),(544,'8','212','1',1,'Sale Id shift 116',0.00,0.00,0.00,161.42,0.00,'2022-12-03 14:48:08','',''),(545,'8','212','2',1,'Sale Id shift 116',0.00,0.00,0.00,255.11,0.00,'2022-12-03 14:48:08','',''),(546,'8','212',NULL,1,'Sale Id shift 116',328177.20,0.00,0.00,0.00,0.00,'2022-12-03 14:48:08','',''),(547,'8','212','1',1,'Sale Id shift 117',0.00,0.00,0.00,0.29,0.00,'2022-12-03 14:54:47','',''),(548,'8','212','2',1,'Sale Id shift 117',0.00,0.00,0.00,2281.87,0.00,'2022-12-03 14:54:47','',''),(549,'8','212','2',1,'Sale Id shift 117',0.00,0.00,0.00,3622.51,0.00,'2022-12-03 14:54:47','',''),(550,'8','212',NULL,1,'Sale Id shift 117',1594260.90,0.00,0.00,0.00,0.00,'2022-12-03 14:54:47','',''),(551,'8','212','2',1,'Sale Id shift 118',0.00,0.00,0.00,6660.25,0.00,'2022-12-03 15:00:26','',''),(552,'8','212','2',1,'Sale Id shift 118',0.00,0.00,0.00,7107.12,0.00,'2022-12-03 15:00:26','',''),(553,'8','212',NULL,1,'Sale Id shift 118',3717189.90,0.00,0.00,0.00,0.00,'2022-12-03 15:00:26','',''),(554,'8','212','2',1,'Sale Id shift 119',0.00,0.00,0.00,1794.15,0.00,'2022-12-03 18:56:37','',''),(555,'8','212','2',1,'Sale Id shift 119',0.00,0.00,0.00,2219.60,0.00,'2022-12-03 18:56:37','',''),(556,'8','212',NULL,1,'Sale Id shift 119',1083712.50,0.00,0.00,0.00,0.00,'2022-12-03 18:56:37','',''),(557,'8','212','2',1,'Sale Id shift 120',0.00,0.00,0.00,2965.04,0.00,'2022-12-05 10:12:01','',''),(558,'8','212','2',1,'Sale Id shift 120',0.00,0.00,0.00,3398.80,0.00,'2022-12-05 10:12:01','',''),(559,'8','212',NULL,1,'Sale Id shift 120',1718236.80,0.00,0.00,0.00,0.00,'2022-12-05 10:12:01','',''),(560,'8','212','2',1,'Sale Id shift 121',0.00,0.00,0.00,997.68,0.00,'2022-12-06 06:03:44','',''),(561,'8','212','2',1,'Sale Id shift 121',0.00,0.00,0.00,822.40,0.00,'2022-12-06 06:03:44','',''),(562,'8','212',NULL,1,'Sale Id shift 121',491421.60,0.00,0.00,0.00,0.00,'2022-12-06 06:03:44','',''),(563,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,4320000.00,16000.00,0.00,0.00,'2022-12-06 10:23:17','',''),(564,'8','212',NULL,1,'Reception corrector for bridging 45',0.00,0.00,0.00,16000.00,0.00,'2022-12-06 19:53:07','',''),(565,'8','212','1',1,'Received from bridging 45',0.00,0.00,16000.00,0.00,0.00,'2022-12-06 19:53:07','',''),(566,'8','212','1',1,'Sale Id shift 122',0.00,0.00,0.00,5271.44,0.00,'2022-12-06 20:02:39','',''),(567,'8','212','1',1,'Sale Id shift 122',0.00,0.00,0.00,3269.15,0.00,'2022-12-06 20:02:39','',''),(568,'8','212',NULL,1,'Sale Id shift 122',2305959.30,0.00,0.00,0.00,0.00,'2022-12-06 20:02:39','',''),(569,'8','212','1',1,'Sale Id shift 123',0.00,0.00,0.00,4103.70,0.00,'2022-12-07 22:04:35','',''),(570,'8','212','1',1,'Sale Id shift 123',0.00,0.00,0.00,3546.35,0.00,'2022-12-07 22:04:35','',''),(571,'8','212',NULL,1,'Sale Id shift 123',2119063.85,0.00,0.00,0.00,0.00,'2022-12-07 22:04:35','',''),(572,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,13587750.00,44550.00,0.00,0.00,'2022-12-15 08:39:10','',''),(573,'8','212',NULL,1,'Reception corrector for bridging 47',0.00,0.00,0.00,29550.00,0.00,'2022-12-15 15:39:05','',''),(574,'8','212','2',1,'Received from bridging 47',0.00,0.00,29550.00,0.00,0.00,'2022-12-15 15:39:05','',''),(575,'8','212',NULL,1,'Reception corrector for bridging 46',0.00,0.00,0.00,15000.00,0.00,'2022-12-15 15:39:05','',''),(576,'8','212','1',1,'Received from bridging 46',0.00,0.00,15000.00,0.00,0.00,'2022-12-15 15:39:05','',''),(577,'8','212','1',1,'Sale Id shift 124',0.00,0.00,0.00,2509.89,0.00,'2022-12-15 15:42:55','',''),(578,'8','212','1',1,'Sale Id shift 124',0.00,0.00,0.00,450.42,0.00,'2022-12-15 15:42:55','',''),(579,'8','212','2',1,'Sale Id shift 124',0.00,0.00,0.00,2976.84,0.00,'2022-12-15 15:42:55','',''),(580,'8','212','2',1,'Sale Id shift 124',0.00,0.00,0.00,1619.24,0.00,'2022-12-15 15:42:55','',''),(581,'8','212',NULL,1,'Sale Id shift 124',2304698.95,0.00,0.00,0.00,0.00,'2022-12-15 15:42:55','',''),(582,'8','212','1',1,'Sale Id shift 125',0.00,0.00,0.00,584.35,0.00,'2022-12-16 15:01:41','',''),(583,'8','212','2',1,'Sale Id shift 125',0.00,0.00,0.00,3439.36,0.00,'2022-12-16 15:01:41','',''),(584,'8','212','2',1,'Sale Id shift 125',0.00,0.00,0.00,3003.54,0.00,'2022-12-16 15:01:41','',''),(585,'8','212',NULL,1,'Sale Id shift 125',2143311.25,0.00,0.00,0.00,0.00,'2022-12-16 15:01:41','',''),(586,'8','212','1',1,'Sale Id shift 126',0.00,0.00,0.00,1125.34,0.00,'2022-12-17 11:18:44','',''),(587,'8','212','1',1,'Sale Id shift 126',0.00,0.00,0.00,1304.21,0.00,'2022-12-17 11:18:44','',''),(588,'8','212',NULL,1,'Sale Id shift 126',741012.75,0.00,0.00,0.00,0.00,'2022-12-17 11:18:44','',''),(589,'8','212','1',1,'Sale Id shift 127',0.00,0.00,0.00,602.48,0.00,'2022-12-17 11:26:53','',''),(590,'8','212','1',1,'Sale Id shift 127',0.00,0.00,0.00,573.09,0.00,'2022-12-17 11:26:53','',''),(591,'8','212','2',1,'Sale Id shift 127',0.00,0.00,0.00,1285.52,0.00,'2022-12-17 11:26:53','',''),(592,'8','212','2',1,'Sale Id shift 127',0.00,0.00,0.00,814.73,0.00,'2022-12-17 11:26:53','',''),(593,'8','212',NULL,1,'Sale Id shift 127',606026.70,0.00,0.00,0.00,0.00,'2022-12-17 11:26:53','',''),(594,'8','212','1',1,'Sale Id shift 128',0.00,0.00,0.00,412.75,0.00,'2022-12-18 13:38:08','',''),(595,'8','212','1',1,'Sale Id shift 128',0.00,0.00,0.00,1208.42,0.00,'2022-12-18 13:38:08','',''),(596,'8','212','2',1,'Sale Id shift 128',0.00,0.00,0.00,1482.45,0.00,'2022-12-18 13:38:08','',''),(597,'8','212','2',1,'Sale Id shift 128',0.00,0.00,0.00,397.24,0.00,'2022-12-18 13:38:08','',''),(598,'8','212',NULL,1,'Sale Id shift 128',1085266.60,0.00,0.00,0.00,0.00,'2022-12-18 13:38:08','',''),(599,'8','212','1',1,'Sale Id shift 129',0.00,0.00,0.00,347.20,0.00,'2022-12-21 19:19:31','',''),(600,'8','212','1',1,'Sale Id shift 129',0.00,0.00,0.00,433.94,0.00,'2022-12-21 19:19:31','',''),(601,'8','212','2',1,'Sale Id shift 129',0.00,0.00,0.00,1305.79,0.00,'2022-12-21 19:19:31','',''),(602,'8','212','2',1,'Sale Id shift 129',0.00,0.00,0.00,829.53,0.00,'2022-12-21 19:19:31','',''),(603,'8','212',NULL,1,'Sale Id shift 129',539545.10,0.00,0.00,0.00,0.00,'2022-12-21 19:19:31','',''),(604,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,5580000.00,18000.00,0.00,0.00,'2022-12-21 19:29:08','',''),(605,'8','212',NULL,1,'Reception corrector for bridging 48',0.00,0.00,0.00,18000.00,0.00,'2022-12-22 12:05:18','',''),(606,'8','212','2',1,'Received from bridging 48',0.00,0.00,18000.00,0.00,0.00,'2022-12-22 12:05:18','',''),(607,'8','212','1',1,'Sale Id shift 130',0.00,0.00,0.00,659.79,0.00,'2022-12-22 12:08:05','',''),(608,'8','212','1',1,'Sale Id shift 130',0.00,0.00,0.00,1279.71,0.00,'2022-12-22 12:08:05','',''),(609,'8','212','2',1,'Sale Id shift 130',0.00,0.00,0.00,1235.14,0.00,'2022-12-22 12:08:05','',''),(610,'8','212','2',1,'Sale Id shift 130',0.00,0.00,0.00,1779.94,0.00,'2022-12-22 12:08:05','',''),(611,'8','212',NULL,1,'Sale Id shift 130',1535919.80,0.00,0.00,0.00,0.00,'2022-12-22 12:08:05','',''),(612,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,5115000.00,16500.00,0.00,0.00,'2022-12-23 15:52:50','',''),(613,'8','212',NULL,1,'Reception corrector for bridging 49',0.00,0.00,0.00,16500.00,0.00,'2022-12-23 19:20:23','',''),(614,'8','212','1',1,'Received from bridging 49',0.00,0.00,16500.00,0.00,0.00,'2022-12-23 19:20:23','',''),(615,'8','212','1',1,'Sale Id shift 131',0.00,0.00,0.00,372.37,0.00,'2022-12-25 14:04:46','',''),(616,'8','212','1',1,'Sale Id shift 131',0.00,0.00,0.00,666.06,0.00,'2022-12-25 14:04:46','',''),(617,'8','212','2',1,'Sale Id shift 131',0.00,0.00,0.00,772.51,0.00,'2022-12-25 14:04:46','',''),(618,'8','212',NULL,1,'Sale Id shift 131',561391.40,0.00,0.00,0.00,0.00,'2022-12-25 14:04:46','',''),(619,'8','212','2',1,'Sale Id shift 132',0.00,0.00,0.00,1072.14,0.00,'2022-12-28 11:46:27','',''),(620,'8','212','2',1,'Sale Id shift 132',0.00,0.00,0.00,1050.91,0.00,'2022-12-28 11:46:27','',''),(621,'8','212',NULL,1,'Sale Id shift 132',658145.50,0.00,0.00,0.00,0.00,'2022-12-28 11:46:27','',''),(622,'8','212','2',1,'Sale Id shift 133',0.00,0.00,0.00,606.02,0.00,'2022-12-30 21:01:39','',''),(623,'8','212','2',1,'Sale Id shift 133',0.00,0.00,0.00,1175.33,0.00,'2022-12-30 21:01:39','',''),(624,'8','212',NULL,1,'Sale Id shift 133',552218.50,0.00,0.00,0.00,0.00,'2022-12-30 21:01:39','',''),(625,'8','212','1',1,'Sale Id shift 134',0.00,0.00,0.00,2142.45,0.00,'2023-01-01 21:59:21','',''),(626,'8','212','1',1,'Sale Id shift 134',0.00,0.00,0.00,1835.31,0.00,'2023-01-01 21:59:21','',''),(627,'8','212','2',1,'Sale Id shift 134',0.00,0.00,0.00,3210.90,0.00,'2023-01-01 21:59:21','',''),(628,'8','212',NULL,1,'Sale Id shift 134',2156598.00,0.00,0.00,0.00,0.00,'2023-01-01 21:59:21','',''),(629,'8','212','2',1,'Sale Id shift 135',0.00,0.00,0.00,621.08,0.00,'2023-01-04 21:34:07','',''),(630,'8','212','2',1,'Sale Id shift 135',0.00,0.00,0.00,1333.10,0.00,'2023-01-04 21:34:07','',''),(631,'8','212',NULL,1,'Sale Id shift 135',361523.30,0.00,0.00,0.00,0.00,'2023-01-04 21:34:07','',''),(632,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,4770000.00,15900.00,0.00,0.00,'2023-01-05 06:34:16','',''),(633,'8','212',NULL,1,'Reception corrector for bridging 50',0.00,0.00,0.00,15900.00,0.00,'2023-01-06 09:34:13','',''),(634,'8','212','1',1,'Received from bridging 50',0.00,0.00,15900.00,0.00,0.00,'2023-01-06 09:34:13','',''),(635,'8','212','1',1,'Sale Id shift 136',0.00,0.00,0.00,1571.60,0.00,'2023-01-06 09:38:09','',''),(636,'8','212','1',1,'Sale Id shift 136',0.00,0.00,0.00,146.20,0.00,'2023-01-06 09:38:09','',''),(637,'8','212','2',1,'Sale Id shift 136',0.00,0.00,0.00,1525.31,0.00,'2023-01-06 09:38:09','',''),(638,'8','212','2',1,'Sale Id shift 136',0.00,0.00,0.00,926.41,0.00,'2023-01-06 09:38:09','',''),(639,'8','212',NULL,1,'Sale Id shift 136',1250856.00,0.00,0.00,0.00,0.00,'2023-01-06 09:38:09','',''),(640,'8','212','1',1,'Sale Id shift 137',0.00,0.00,0.00,1381.03,0.00,'2023-01-07 12:55:52','',''),(641,'8','212','2',1,'Sale Id shift 137',0.00,0.00,0.00,539.45,0.00,'2023-01-07 12:55:52','',''),(642,'8','212','2',1,'Sale Id shift 137',0.00,0.00,0.00,1444.86,0.00,'2023-01-07 12:55:52','',''),(643,'8','212',NULL,1,'Sale Id shift 137',622587.90,0.00,0.00,0.00,0.00,'2023-01-07 12:55:52','',''),(644,'8','212','1',1,'Sale Id shift 138',0.00,0.00,0.00,3600.41,0.00,'2023-01-27 23:04:15','',''),(645,'8','212','1',1,'Sale Id shift 138',0.00,0.00,0.00,1491.28,0.00,'2023-01-27 23:04:15','',''),(646,'8','212','2',1,'Sale Id shift 138',0.00,0.00,0.00,772.57,0.00,'2023-01-27 23:04:15','',''),(647,'8','212','2',1,'Sale Id shift 138',0.00,0.00,0.00,2930.29,0.00,'2023-01-27 23:04:15','',''),(648,'8','212',NULL,1,'Sale Id shift 138',1714937.25,0.00,0.00,0.00,0.00,'2023-01-27 23:04:15','',''),(649,'8','212','1',1,'Sale Id shift 139',0.00,0.00,0.00,2816.29,0.00,'2023-01-30 17:30:48','',''),(650,'8','212','1',1,'Sale Id shift 139',0.00,0.00,0.00,848.14,0.00,'2023-01-30 17:30:48','',''),(651,'8','212','2',1,'Sale Id shift 139',0.00,0.00,0.00,759.48,0.00,'2023-01-30 17:30:48','',''),(652,'8','212','2',1,'Sale Id shift 139',0.00,0.00,0.00,1321.52,0.00,'2023-01-30 17:30:48','',''),(653,'8','212',NULL,1,'Sale Id shift 139',1930464.48,0.00,0.00,0.00,0.00,'2023-01-30 17:30:48','',''),(654,'8','212','1',1,'Sale Id shift 140',0.00,0.00,0.00,1694.18,0.00,'2023-01-31 14:39:37','',''),(655,'8','212','1',1,'Sale Id shift 140',0.00,0.00,0.00,497.42,0.00,'2023-01-31 14:39:37','',''),(656,'8','212','2',1,'Sale Id shift 140',0.00,0.00,0.00,1034.25,0.00,'2023-01-31 14:39:37','',''),(657,'8','212',NULL,1,'Sale Id shift 140',1083885.60,0.00,0.00,0.00,0.00,'2023-01-31 14:39:37','',''),(658,'8','212','1',1,'Sale Id shift 141',0.00,0.00,0.00,441.46,0.00,'2023-02-01 10:08:06','',''),(659,'8','212','1',1,'Sale Id shift 141',0.00,0.00,0.00,500.23,0.00,'2023-02-01 10:08:06','',''),(660,'8','212','2',1,'Sale Id shift 141',0.00,0.00,0.00,1056.01,0.00,'2023-02-01 10:08:06','',''),(661,'8','212',NULL,1,'Sale Id shift 141',689206.50,0.00,0.00,0.00,0.00,'2023-02-01 10:08:06','',''),(662,'8','212','1',1,'Sale Id shift 142',0.00,0.00,0.00,1016.52,0.00,'2023-02-02 20:39:37','',''),(663,'8','212','1',1,'Sale Id shift 142',0.00,0.00,0.00,836.85,0.00,'2023-02-02 20:39:37','',''),(664,'8','212','2',1,'Sale Id shift 142',0.00,0.00,0.00,361.92,0.00,'2023-02-02 20:39:37','',''),(665,'8','212','2',1,'Sale Id shift 142',0.00,0.00,0.00,1130.43,0.00,'2023-02-02 20:39:37','',''),(666,'8','212',NULL,1,'Sale Id shift 142',1154273.40,0.00,0.00,0.00,0.00,'2023-02-02 20:39:37','',''),(667,'8','212','1',1,'Sale Id shift 143',0.00,0.00,0.00,2680.90,0.00,'2023-02-03 18:59:47','',''),(668,'8','212','1',1,'Sale Id shift 143',0.00,0.00,0.00,273.89,0.00,'2023-02-03 18:59:47','',''),(669,'8','212','2',1,'Sale Id shift 143',0.00,0.00,0.00,1735.69,0.00,'2023-02-03 18:59:47','',''),(670,'8','212',NULL,1,'Sale Id shift 143',1618215.60,0.00,0.00,0.00,0.00,'2023-02-03 18:59:47','',''),(671,'8','212','1',1,'Sale Id shift 144',0.00,0.00,0.00,3198.82,0.00,'2023-02-06 08:23:59','',''),(672,'8','212','1',1,'Sale Id shift 144',0.00,0.00,0.00,3251.20,0.00,'2023-02-06 08:23:59','',''),(673,'8','212','2',1,'Sale Id shift 144',0.00,0.00,0.00,684.29,0.00,'2023-02-06 08:23:59','',''),(674,'8','212',NULL,1,'Sale Id shift 144',2461336.95,0.00,0.00,0.00,0.00,'2023-02-06 08:23:59','',''),(675,'8','212','1',1,'Sale Id shift 145',0.00,0.00,0.00,1742.89,0.00,'2023-02-07 10:40:13','',''),(676,'8','212','1',1,'Sale Id shift 145',0.00,0.00,0.00,528.41,0.00,'2023-02-07 10:40:13','',''),(677,'8','212','2',1,'Sale Id shift 145',0.00,0.00,0.00,295.65,0.00,'2023-02-07 10:40:13','',''),(678,'8','212','2',1,'Sale Id shift 145',0.00,0.00,0.00,138.00,0.00,'2023-02-07 10:40:13','',''),(679,'8','212',NULL,1,'Sale Id shift 145',933207.75,0.00,0.00,0.00,0.00,'2023-02-07 10:40:13','',''),(680,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,15300000.00,45000.00,0.00,0.00,'2023-02-16 17:23:38','',''),(681,'8','212',NULL,1,'Reception corrector for bridging 52',0.00,0.00,0.00,30500.00,0.00,'2023-02-16 19:51:17','',''),(682,'8','212','2',1,'Received from bridging 52',0.00,0.00,30500.00,0.00,0.00,'2023-02-16 19:51:17','',''),(683,'8','212',NULL,1,'Reception corrector for bridging 51',0.00,0.00,0.00,14500.00,0.00,'2023-02-16 19:51:17','',''),(684,'8','212','1',1,'Received from bridging 51',0.00,0.00,14500.00,0.00,0.00,'2023-02-16 19:51:17','',''),(685,'8','212','1',1,'Sale Id shift 146',0.00,0.00,0.00,2859.73,0.00,'2023-02-16 19:53:35','',''),(686,'8','212','1',1,'Sale Id shift 146',0.00,0.00,0.00,188.09,0.00,'2023-02-16 19:53:35','',''),(687,'8','212',NULL,1,'Sale Id shift 146',1051497.90,0.00,0.00,0.00,0.00,'2023-02-16 19:53:35','',''),(688,'8','212','1',1,'Sale Id shift 147',0.00,0.00,0.00,1809.95,0.00,'2023-02-17 19:37:29','',''),(689,'8','212','1',1,'Sale Id shift 147',0.00,0.00,0.00,270.19,0.00,'2023-02-17 19:37:29','',''),(690,'8','212','2',1,'Sale Id shift 147',0.00,0.00,0.00,1235.77,0.00,'2023-02-17 19:37:29','',''),(691,'8','212','2',1,'Sale Id shift 147',0.00,0.00,0.00,1092.23,0.00,'2023-02-17 19:37:29','',''),(692,'8','212',NULL,1,'Sale Id shift 147',1498767.60,0.00,0.00,0.00,0.00,'2023-02-17 19:37:29','',''),(693,'8','212','1',1,'Sale Id shift 148',0.00,0.00,0.00,37.59,0.00,'2023-02-21 10:39:46','',''),(694,'8','212','1',1,'Sale Id shift 148',0.00,0.00,0.00,707.35,0.00,'2023-02-21 10:39:46','',''),(695,'8','212','2',1,'Sale Id shift 148',0.00,0.00,0.00,1344.48,0.00,'2023-02-21 10:39:46','',''),(696,'8','212',NULL,1,'Sale Id shift 148',710402.80,0.00,0.00,0.00,0.00,'2023-02-21 10:39:46','',''),(697,'8','212','1',1,'Sale Id shift 149',0.00,0.00,0.00,177.43,0.00,'2023-02-21 10:44:01','',''),(698,'8','212','1',1,'Sale Id shift 149',0.00,0.00,0.00,778.78,0.00,'2023-02-21 10:44:01','',''),(699,'8','212','2',1,'Sale Id shift 149',0.00,0.00,0.00,1213.53,0.00,'2023-02-21 10:44:01','',''),(700,'8','212',NULL,1,'Sale Id shift 149',737711.60,0.00,0.00,0.00,0.00,'2023-02-21 10:44:01','',''),(701,'8','212','1',1,'Sale Id shift 150',0.00,0.00,0.00,2030.14,0.00,'2023-02-21 10:49:52','',''),(702,'8','212','1',1,'Sale Id shift 150',0.00,0.00,0.00,1026.25,0.00,'2023-02-21 10:49:52','',''),(703,'8','212','2',1,'Sale Id shift 150',0.00,0.00,0.00,1709.17,0.00,'2023-02-21 10:49:52','',''),(704,'8','212','2',1,'Sale Id shift 150',0.00,0.00,0.00,1593.32,0.00,'2023-02-21 10:49:52','',''),(705,'8','212',NULL,1,'Sale Id shift 150',2162019.20,0.00,0.00,0.00,0.00,'2023-02-21 10:49:52','',''),(706,'8','212','1',1,'Sale Id shift 151',0.00,0.00,0.00,1006.49,0.00,'2023-02-21 10:57:06','',''),(707,'8','212','1',1,'Sale Id shift 151',0.00,0.00,0.00,914.00,0.00,'2023-02-21 10:57:06','',''),(708,'8','212','2',1,'Sale Id shift 151',0.00,0.00,0.00,1423.79,0.00,'2023-02-21 10:57:06','',''),(709,'8','212',NULL,1,'Sale Id shift 151',1137055.20,0.00,0.00,0.00,0.00,'2023-02-21 10:57:06','',''),(710,'8','212','1',1,'Sale Id shift 152',0.00,0.00,0.00,1351.62,0.00,'2023-02-23 21:55:30','',''),(711,'8','212','2',1,'Sale Id shift 152',0.00,0.00,0.00,112.41,0.00,'2023-02-23 21:55:30','',''),(712,'8','212','2',1,'Sale Id shift 152',0.00,0.00,0.00,561.64,0.00,'2023-02-23 21:55:30','',''),(713,'8','212',NULL,1,'Sale Id shift 152',688727.80,0.00,0.00,0.00,0.00,'2023-02-23 21:55:30','',''),(714,'8','212','1',1,'Sale Id shift 153',0.00,0.00,0.00,268.50,0.00,'2023-02-23 22:01:31','',''),(715,'8','212','1',1,'Sale Id shift 153',0.00,0.00,0.00,1136.34,0.00,'2023-02-23 22:01:31','',''),(716,'8','212','2',1,'Sale Id shift 153',0.00,0.00,0.00,2148.72,0.00,'2023-02-23 22:01:31','',''),(717,'8','212','2',1,'Sale Id shift 153',0.00,0.00,0.00,60.80,0.00,'2023-02-23 22:01:31','',''),(718,'8','212',NULL,1,'Sale Id shift 153',1156595.20,0.00,0.00,0.00,0.00,'2023-02-23 22:01:31','',''),(719,'8','212','1',1,'Sale Id shift 154',0.00,0.00,0.00,1337.16,0.00,'2023-02-24 08:58:52','',''),(720,'8','212','2',1,'Sale Id shift 154',0.00,0.00,0.00,794.96,0.00,'2023-02-24 08:58:52','',''),(721,'8','212',NULL,1,'Sale Id shift 154',682278.40,0.00,0.00,0.00,0.00,'2023-02-24 08:58:52','',''),(722,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,5376000.00,16800.00,0.00,0.00,'2023-02-24 10:53:41','',''),(723,'8','212',NULL,1,'Reception corrector for bridging 53',0.00,0.00,0.00,16800.00,0.00,'2023-02-27 09:11:36','',''),(724,'8','212','1',1,'Received from bridging 53',0.00,0.00,16800.00,0.00,0.00,'2023-02-27 09:11:36','',''),(725,'8','212','1',1,'Sale Id shift 155',0.00,0.00,0.00,181.52,0.00,'2023-02-27 09:15:24','',''),(726,'8','212','1',1,'Sale Id shift 155',0.00,0.00,0.00,1263.51,0.00,'2023-02-27 09:15:24','',''),(727,'8','212','2',1,'Sale Id shift 155',0.00,0.00,0.00,1269.49,0.00,'2023-02-27 09:15:24','',''),(728,'8','212','2',1,'Sale Id shift 155',0.00,0.00,0.00,270.91,0.00,'2023-02-27 09:15:24','',''),(729,'8','212',NULL,1,'Sale Id shift 155',955337.60,0.00,0.00,0.00,0.00,'2023-02-27 09:15:24','',''),(730,'8','212','1',1,'Sale Id shift 156',0.00,0.00,0.00,1404.32,0.00,'2023-02-27 09:19:23','',''),(731,'8','212','1',1,'Sale Id shift 156',0.00,0.00,0.00,1281.79,0.00,'2023-02-27 09:19:23','',''),(732,'8','212','2',1,'Sale Id shift 156',0.00,0.00,0.00,2079.39,0.00,'2023-02-27 09:19:23','',''),(733,'8','212','2',1,'Sale Id shift 156',0.00,0.00,0.00,1189.49,0.00,'2023-02-27 09:19:23','',''),(734,'8','212',NULL,1,'Sale Id shift 156',1905596.80,0.00,0.00,0.00,0.00,'2023-02-27 09:19:23','',''),(735,'8','212','1',1,'Sale Id shift 157',0.00,0.00,0.00,829.53,0.00,'2023-02-28 23:12:41','',''),(736,'8','212','1',1,'Sale Id shift 157',0.00,0.00,0.00,373.36,0.00,'2023-02-28 23:12:41','',''),(737,'8','212','2',1,'Sale Id shift 157',0.00,0.00,0.00,1064.85,0.00,'2023-02-28 23:12:41','',''),(738,'8','212','2',1,'Sale Id shift 157',0.00,0.00,0.00,857.26,0.00,'2023-02-28 23:12:41','',''),(739,'8','212',NULL,1,'Sale Id shift 157',1000000.00,0.00,0.00,0.00,0.00,'2023-02-28 23:12:41','',''),(740,'8','212','1',1,'Sale Id shift 158',0.00,0.00,0.00,1848.53,0.00,'2023-03-01 17:38:36','',''),(741,'8','212','2',1,'Sale Id shift 158',0.00,0.00,0.00,1437.11,0.00,'2023-03-01 17:38:36','',''),(742,'8','212',NULL,1,'Sale Id shift 158',1051404.80,0.00,0.00,0.00,0.00,'2023-03-01 17:38:36','',''),(743,'8','212','1',1,'Sale Id shift 159',0.00,0.00,0.00,1408.68,0.00,'2023-03-03 23:17:10','',''),(744,'8','212','2',1,'Sale Id shift 159',0.00,0.00,0.00,1280.63,0.00,'2023-03-03 23:17:10','',''),(745,'8','212',NULL,1,'Sale Id shift 159',860579.20,0.00,0.00,0.00,0.00,'2023-03-03 23:17:10','',''),(746,'8','212','1',1,'Sale Id shift 160',0.00,0.00,0.00,1634.26,0.00,'2023-03-03 23:22:10','',''),(747,'8','212','2',1,'Sale Id shift 160',0.00,0.00,0.00,992.02,0.00,'2023-03-03 23:22:10','',''),(748,'8','212',NULL,1,'Sale Id shift 160',840409.60,0.00,0.00,0.00,0.00,'2023-03-03 23:22:10','',''),(749,'8','212','1',1,'Sale Id shift 161',0.00,0.00,0.00,92.24,0.00,'2023-03-04 23:02:13','',''),(750,'8','212','1',1,'Sale Id shift 161',0.00,0.00,0.00,998.15,0.00,'2023-03-04 23:02:13','',''),(751,'8','212','2',1,'Sale Id shift 161',0.00,0.00,0.00,1364.64,0.00,'2023-03-04 23:02:13','',''),(752,'8','212','2',1,'Sale Id shift 161',0.00,0.00,0.00,1074.95,0.00,'2023-03-04 23:02:13','',''),(753,'8','212',NULL,1,'Sale Id shift 161',1058994.00,0.00,0.00,0.00,0.00,'2023-03-04 23:02:13','',''),(754,'8','212','1',1,'Sale Id shift 162',0.00,0.00,0.00,298.04,0.00,'2023-03-06 17:41:04','',''),(755,'8','212','1',1,'Sale Id shift 162',0.00,0.00,0.00,673.85,0.00,'2023-03-06 17:41:04','',''),(756,'8','212','2',1,'Sale Id shift 162',0.00,0.00,0.00,1846.67,0.00,'2023-03-06 17:41:04','',''),(757,'8','212','2',1,'Sale Id shift 162',0.00,0.00,0.00,140.63,0.00,'2023-03-06 17:41:04','',''),(758,'8','212',NULL,1,'Sale Id shift 162',887757.00,0.00,0.00,0.00,0.00,'2023-03-06 17:41:04','',''),(759,'8','212','1',1,'Sale Id shift 163',0.00,0.00,0.00,1946.44,0.00,'2023-03-06 17:44:45','',''),(760,'8','212','1',1,'Sale Id shift 163',0.00,0.00,0.00,1313.03,0.00,'2023-03-06 17:44:45','',''),(761,'8','212','2',1,'Sale Id shift 163',0.00,0.00,0.00,1364.15,0.00,'2023-03-06 17:44:45','',''),(762,'8','212','2',1,'Sale Id shift 163',0.00,0.00,0.00,857.56,0.00,'2023-03-06 17:44:45','',''),(763,'8','212',NULL,1,'Sale Id shift 163',1644354.00,0.00,0.00,0.00,0.00,'2023-03-06 17:44:45','',''),(764,'8','212','1',1,'Sale Id shift 164',0.00,0.00,0.00,1072.71,0.00,'2023-03-09 00:04:45','',''),(765,'8','212','1',1,'Sale Id shift 164',0.00,0.00,0.00,909.85,0.00,'2023-03-09 00:04:45','',''),(766,'8','212',NULL,1,'Sale Id shift 164',594768.00,0.00,0.00,0.00,0.00,'2023-03-09 00:04:45','',''),(767,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,10200000.00,34000.00,0.00,0.00,'2023-03-09 10:55:00','',''),(768,'8','212',NULL,1,'Reception corrector for bridging 55',0.00,0.00,0.00,16300.00,0.00,'2023-03-09 20:55:56','',''),(769,'8','212','2',1,'Received from bridging 55',0.00,0.00,16300.00,0.00,0.00,'2023-03-09 20:55:56','',''),(770,'8','212',NULL,1,'Reception corrector for bridging 54',0.00,0.00,0.00,17700.00,0.00,'2023-03-09 20:55:56','',''),(771,'8','212','1',1,'Received from bridging 54',0.00,0.00,17700.00,0.00,0.00,'2023-03-09 20:55:56','',''),(772,'8','212','1',1,'Sale Id shift 165',0.00,0.00,0.00,987.46,0.00,'2023-03-09 23:15:51','',''),(773,'8','212','1',1,'Sale Id shift 165',0.00,0.00,0.00,590.27,0.00,'2023-03-09 23:15:51','',''),(774,'8','212',NULL,1,'Sale Id shift 165',473319.00,0.00,0.00,0.00,0.00,'2023-03-09 23:15:51','',''),(775,'8','212','1',1,'Sale Id shift 166',0.00,0.00,0.00,1179.49,0.00,'2023-03-09 23:20:16','',''),(776,'8','212','2',1,'Sale Id shift 166',0.00,0.00,0.00,1197.26,0.00,'2023-03-09 23:20:16','',''),(777,'8','212',NULL,1,'Sale Id shift 166',713025.00,0.00,0.00,0.00,0.00,'2023-03-09 23:20:16','',''),(778,'8','212','1',1,'Sale Id shift 167',0.00,0.00,0.00,1018.23,0.00,'2023-03-11 13:49:58','',''),(779,'8','212','1',1,'Sale Id shift 167',0.00,0.00,0.00,347.48,0.00,'2023-03-11 13:49:58','',''),(780,'8','212','2',1,'Sale Id shift 167',0.00,0.00,0.00,1364.22,0.00,'2023-03-11 13:49:58','',''),(781,'8','212',NULL,1,'Sale Id shift 167',818979.00,0.00,0.00,0.00,0.00,'2023-03-11 13:49:58','',''),(782,'8','212','1',1,'Sale Id shift 168',0.00,0.00,0.00,135.19,0.00,'2023-03-11 13:53:35','',''),(783,'8','212','1',1,'Sale Id shift 168',0.00,0.00,0.00,1846.84,0.00,'2023-03-11 13:53:35','',''),(784,'8','212','2',1,'Sale Id shift 168',0.00,0.00,0.00,1957.29,0.00,'2023-03-11 13:53:35','',''),(785,'8','212',NULL,1,'Sale Id shift 168',1181796.00,0.00,0.00,0.00,0.00,'2023-03-11 13:53:35','',''),(786,'8','212','1',1,'Sale Id shift 169',0.00,0.00,0.00,3150.27,0.00,'2023-03-13 17:09:16','',''),(787,'8','212','1',1,'Sale Id shift 169',0.00,0.00,0.00,1767.91,0.00,'2023-03-13 17:09:16','',''),(788,'8','212','2',1,'Sale Id shift 169',0.00,0.00,0.00,3270.83,0.00,'2023-03-13 17:09:16','',''),(789,'8','212','2',1,'Sale Id shift 169',0.00,0.00,0.00,1842.27,0.00,'2023-03-13 17:09:16','',''),(790,'8','212',NULL,1,'Sale Id shift 169',3009384.00,0.00,0.00,0.00,0.00,'2023-03-13 17:09:16','',''),(791,'8','212','1',1,'Sale Id shift 170',0.00,0.00,0.00,1050.19,0.00,'2023-03-18 13:43:06','',''),(792,'8','212','1',1,'Sale Id shift 170',0.00,0.00,0.00,659.27,0.00,'2023-03-18 13:43:06','',''),(793,'8','212','2',1,'Sale Id shift 170',0.00,0.00,0.00,1911.42,0.00,'2023-03-18 13:43:06','',''),(794,'8','212',NULL,1,'Sale Id shift 170',1086264.00,0.00,0.00,0.00,0.00,'2023-03-18 13:43:06','',''),(795,'8','212','1',1,'Sale Id shift 171',0.00,0.00,0.00,1498.09,0.00,'2023-03-18 13:48:24','',''),(796,'8','212','2',1,'Sale Id shift 171',0.00,0.00,0.00,1326.75,0.00,'2023-03-18 13:48:24','',''),(797,'8','212','2',1,'Sale Id shift 171',0.00,0.00,0.00,484.34,0.00,'2023-03-18 13:48:24','',''),(798,'8','212',NULL,1,'Sale Id shift 171',992754.00,0.00,0.00,0.00,0.00,'2023-03-18 13:48:24','',''),(799,'8','212','1',1,'Sale Id shift 172',0.00,0.00,0.00,145.53,0.00,'2023-03-18 13:53:00','',''),(800,'8','212','1',1,'Sale Id shift 172',0.00,0.00,0.00,1600.20,0.00,'2023-03-18 13:53:00','',''),(801,'8','212','2',1,'Sale Id shift 172',0.00,0.00,0.00,1523.66,0.00,'2023-03-18 13:53:00','',''),(802,'8','212','2',1,'Sale Id shift 172',0.00,0.00,0.00,220.33,0.00,'2023-03-18 13:53:00','',''),(803,'8','212',NULL,1,'Sale Id shift 172',1046916.00,0.00,0.00,0.00,0.00,'2023-03-18 13:53:00','',''),(804,'8','212','1',1,'Sale Id shift 173',0.00,0.00,0.00,1750.19,0.00,'2023-03-18 13:58:13','',''),(805,'8','212','2',1,'Sale Id shift 173',0.00,0.00,0.00,1699.56,0.00,'2023-03-18 13:58:13','',''),(806,'8','212','2',1,'Sale Id shift 173',0.00,0.00,0.00,338.75,0.00,'2023-03-18 13:58:13','',''),(807,'8','212',NULL,1,'Sale Id shift 173',1136550.00,0.00,0.00,0.00,0.00,'2023-03-18 13:58:13','',''),(808,'8','212',NULL,1,'Purchased from Lausu Energy Resources',0.00,10500000.00,35000.00,0.00,0.00,'2023-03-19 19:33:04','',''),(809,'8','212',NULL,1,'Reception corrector for bridging 57',0.00,0.00,0.00,17000.00,0.00,'2023-03-20 08:42:04','',''),(810,'8','212','2',1,'Received from bridging 57',0.00,0.00,17000.00,0.00,0.00,'2023-03-20 08:42:04','',''),(811,'8','212',NULL,1,'Reception corrector for bridging 56',0.00,0.00,0.00,18000.00,0.00,'2023-03-20 08:42:04','',''),(812,'8','212','1',1,'Received from bridging 56',0.00,0.00,18000.00,0.00,0.00,'2023-03-20 08:42:04','',''),(813,'8','212','1',1,'Sale Id shift 174',0.00,0.00,0.00,106.87,0.00,'2023-03-20 08:43:35','',''),(814,'8','212','1',1,'Sale Id shift 174',0.00,0.00,0.00,1635.98,0.00,'2023-03-20 08:43:35','',''),(815,'8','212','2',1,'Sale Id shift 174',0.00,0.00,0.00,1300.67,0.00,'2023-03-20 08:43:35','',''),(816,'8','212','2',1,'Sale Id shift 174',0.00,0.00,0.00,178.66,0.00,'2023-03-20 08:43:35','',''),(817,'8','212',NULL,1,'Sale Id shift 174',966654.00,0.00,0.00,0.00,0.00,'2023-03-20 08:43:35','',''),(818,'8','212','1',1,'Sale Id shift 175',0.00,0.00,0.00,4713.00,0.00,'2023-03-20 08:53:56','',''),(819,'8','212','1',1,'Sale Id shift 175',0.00,0.00,0.00,1977.22,0.00,'2023-03-20 08:53:56','',''),(820,'8','212','2',1,'Sale Id shift 175',0.00,0.00,0.00,2515.25,0.00,'2023-03-20 08:53:56','',''),(821,'8','212','2',1,'Sale Id shift 175',0.00,0.00,0.00,1499.08,0.00,'2023-03-20 08:53:56','',''),(822,'8','212',NULL,1,'Sale Id shift 175',3211365.00,0.00,0.00,0.00,0.00,'2023-03-20 08:53:56','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'8','212',2,0.00,'2023-03-20 08:50:29'),(2,'8','212',1,32969.61,'2023-03-20 08:53:56');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=168 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (4,'8','212',1,'Sale Id shift 8',0.00,141639.85,215.00,141639.85,0.00,'2022-08-12 15:53:15'),(5,'8','212',1,'Sale Id shift 9',0.00,238086.70,215.00,238086.70,0.00,'2022-08-12 16:06:56'),(6,'8','212',1,'Sale Id shift 10',0.00,316918.60,215.00,316918.60,0.00,'2022-08-12 19:26:53'),(7,'8','212',1,'Sale Id shift 11',0.00,219923.50,215.00,219923.50,0.00,'2022-08-13 19:25:41'),(8,'8','212',1,'Sale Id shift 12',0.00,826702.95,215.00,826702.95,0.00,'2022-08-14 19:58:25'),(9,'8','212',1,'Sale Id shift 13',0.00,174964.85,215.00,174964.85,0.00,'2022-08-15 20:12:31'),(10,'8','212',1,'Sale Id shift 14',0.00,210162.50,215.00,210162.50,0.00,'2022-08-16 20:51:01'),(11,'8','212',1,'Sale Id shift 15',0.00,255119.00,215.00,255119.00,0.00,'2022-08-19 19:05:23'),(12,'8','212',1,'Sale Id shift 16',0.00,273692.85,215.00,273692.85,0.00,'2022-08-19 19:09:45'),(13,'8','212',1,'Sale Id shift 17',0.00,220884.55,215.00,220884.55,0.00,'2022-08-19 19:14:20'),(14,'8','212',1,'Sale Id shift 18',0.00,192941.00,215.00,192941.00,0.00,'2022-08-20 20:33:36'),(15,'8','212',1,'Sale Id shift 19',0.00,732855.45,215.00,732855.45,0.00,'2022-08-21 19:47:52'),(16,'8','212',1,'Sale Id shift 20',0.00,149014.35,215.00,149014.35,0.00,'2022-08-23 14:07:23'),(17,'8','212',1,'Sale Id shift 21',0.00,138932.00,215.00,149351.90,10419.90,'2022-08-23 19:15:01'),(18,'8','212',1,'Sale Id shift 23',0.00,188854.00,190.00,179411.30,-9442.70,'2022-08-25 16:54:48'),(19,'8','212',1,'Sale Id shift 24',0.00,305742.00,190.00,290454.90,-15287.10,'2022-08-25 19:40:35'),(20,'8','212',1,'Sale Id shift 25',0.00,229940.00,190.00,218443.00,-11497.00,'2022-08-26 20:38:18'),(21,'8','212',1,'Sale Id shift 26',0.00,374942.00,190.00,356194.90,-18747.10,'2022-08-28 19:45:48'),(22,'8','212',1,'Sale Id shift 27',0.00,603020.00,190.00,572869.00,-30151.00,'2022-08-28 19:50:15'),(23,'8','212',1,'Sale Id shift 28',0.00,137470.00,190.00,130596.50,-6873.50,'2022-08-29 19:50:40'),(24,'8','212',1,'Sale Id shift 29',0.00,236740.00,190.00,224903.00,-11837.00,'2022-08-30 19:08:06'),(25,'8','212',1,'Sale Id shift 30',0.00,352148.00,190.00,334540.60,-17607.40,'2022-08-31 19:53:10'),(26,'8','212',1,'Sale Id shift 31',0.00,327610.00,190.00,311229.50,-16380.50,'2022-09-01 20:13:15'),(27,'8','212',1,'Sale Id shift 32',0.00,850260.00,190.00,807747.00,-42513.00,'2022-09-02 19:49:23'),(28,'8','212',1,'Sale Id shift 33',0.00,635118.00,190.00,603362.10,-31755.90,'2022-09-04 08:22:09'),(29,'8','212',1,'Sale Id shift 34',0.00,1498562.00,190.00,1423633.90,-74928.10,'2022-09-05 21:38:54'),(30,'8','212',1,'Sale Id shift 35',0.00,327286.00,190.00,310921.70,-16364.30,'2022-09-05 21:44:16'),(31,'8','212',1,'Sale Id shift 36',0.00,240258.80,190.00,240258.80,0.00,'2022-09-06 20:51:56'),(32,'8','212',1,'Sale Id shift 37',0.00,145855.40,190.00,145855.40,0.00,'2022-09-07 20:41:21'),(33,'8','212',1,'Sale Id shift 38',0.00,346742.40,190.00,346742.40,0.00,'2022-09-08 19:21:00'),(34,'8','212',1,'Sale Id shift 39',0.00,254218.10,190.00,254218.10,0.00,'2022-09-10 09:27:12'),(35,'8','212',1,'Sale Id shift 40',0.00,306927.90,190.00,306927.90,0.00,'2022-09-10 19:34:54'),(36,'8','212',1,'Sale Id shift 41',0.00,1725135.40,190.00,1725135.40,0.00,'2022-09-11 21:12:53'),(37,'8','212',1,'Sale Id shift 42',0.00,911838.50,190.00,911838.50,0.00,'2022-09-12 19:26:15'),(38,'8','212',1,'Sale Id shift 43',0.00,664756.80,190.00,664756.80,0.00,'2022-09-13 21:12:41'),(39,'8','212',1,'Sale Id shift 44',0.00,544053.60,190.00,544053.60,0.00,'2022-09-14 19:42:38'),(40,'8','212',1,'Sale Id shift 45',0.00,525469.70,190.00,525469.70,0.00,'2022-09-15 18:54:48'),(41,'8','212',1,'Sale Id shift 46',0.00,462902.70,190.00,462902.70,0.00,'2022-09-16 20:07:18'),(42,'8','212',1,'Sale Id shift 47',0.00,241117.60,190.00,241117.60,0.00,'2022-09-17 22:27:28'),(43,'8','212',1,'Sale Id shift 48',0.00,1016728.00,190.00,1016728.00,0.00,'2022-09-19 22:25:47'),(44,'8','212',1,'Sale Id shift 49',0.00,224505.90,190.00,224505.90,0.00,'2022-09-20 10:10:25'),(45,'8','212',1,'Sale Id shift 50',0.00,283996.80,190.00,283996.80,0.00,'2022-09-20 20:35:29'),(46,'8','212',1,'Sale Id shift 51',0.00,258730.60,190.00,258730.60,0.00,'2022-09-21 21:49:03'),(47,'8','212',1,'Sale Id shift 52',0.00,394383.00,190.00,394383.00,0.00,'2022-09-22 22:17:01'),(48,'8','212',1,'Sale Id shift 53',0.00,409358.80,190.00,409358.80,0.00,'2022-09-23 20:15:08'),(49,'8','212',1,'Sale Id shift 54',0.00,331855.90,190.00,331855.90,0.00,'2022-09-25 07:52:13'),(50,'8','212',1,'Sale Id shift 55',0.00,1931452.60,190.00,1931452.60,0.00,'2022-09-26 08:25:21'),(51,'8','212',1,'Sale Id shift 56',0.00,536869.70,190.00,536869.70,0.00,'2022-09-27 08:10:31'),(52,'8','212',1,'Sale Id shift 57',0.00,271375.10,190.00,271375.10,0.00,'2022-09-27 19:27:12'),(53,'8','212',1,'Sale Id shift 58',0.00,236563.30,190.00,236563.30,0.00,'2022-09-28 22:18:19'),(54,'8','212',1,'Sale Id shift 59',0.00,401278.10,190.00,401278.10,0.00,'2022-09-29 19:20:20'),(55,'8','212',1,'Sale Id shift 60',0.00,476518.10,190.00,476518.10,0.00,'2022-09-30 20:51:37'),(56,'8','212',1,'Sale Id shift 61',0.00,337244.30,190.00,337244.30,0.00,'2022-10-01 20:57:07'),(57,'8','212',1,'Sale Id shift 62',0.00,1011330.10,190.00,1011330.10,0.00,'2022-10-02 19:16:05'),(58,'8','212',1,'Sale Id shift 63',0.00,228932.90,190.00,228932.90,0.00,'2022-10-03 19:15:33'),(59,'8','212',1,'Sale Id shift 64',0.00,265236.20,190.00,265236.20,0.00,'2022-10-04 15:30:23'),(60,'8','212',1,'Sale Id shift 65',0.00,40105.20,190.00,40105.20,0.00,'2022-10-04 19:20:51'),(61,'8','212',1,'Sale Id shift 66',0.00,340645.30,190.00,340645.30,0.00,'2022-10-05 20:42:15'),(62,'8','212',1,'Sale Id shift 67',0.00,789898.40,190.00,789898.40,0.00,'2022-10-06 18:58:26'),(63,'8','212',1,'Sale Id shift 68',0.00,1347164.60,190.00,1347164.60,0.00,'2022-10-07 19:24:44'),(64,'8','212',1,'Sale Id shift 69',0.00,1231887.80,190.00,1231887.80,0.00,'2022-10-08 21:53:33'),(65,'8','212',1,'Sale Id shift 70',0.00,3219763.95,195.00,3219763.95,0.00,'2022-10-10 09:34:37'),(66,'8','212',1,'Sale Id shift 71',0.00,4990404.90,195.00,4990404.90,0.00,'2022-10-10 22:14:28'),(67,'8','212',1,'Sale Id shift 73',0.00,2915958.84,206.00,2915958.84,0.00,'2022-10-12 18:50:59'),(68,'8','212',1,'Sale Id shift 74',0.00,2222646.80,220.00,2222646.80,0.00,'2022-10-12 20:18:19'),(69,'8','212',1,'Sale Id shift 75',0.00,2965630.80,220.00,2965630.80,0.00,'2022-10-13 20:01:07'),(70,'8','212',1,'Sale Id shift 76',0.00,2010509.60,220.00,2010509.60,0.00,'2022-10-14 22:51:56'),(71,'8','212',1,'Sale Id shift 78',0.00,1529804.25,225.00,1529804.25,0.00,'2022-10-20 13:28:44'),(72,'8','212',1,'Sale Id shift 79',0.00,2646258.75,225.00,2646258.75,0.00,'2022-10-20 13:36:49'),(73,'8','212',1,'Sale Id shift 80',0.00,1287094.50,225.00,1287094.50,0.00,'2022-10-20 13:58:00'),(74,'8','212',1,'Sale Id shift 81',0.00,2204814.50,230.00,2204814.50,0.00,'2022-10-20 18:54:30'),(75,'8','212',1,'Sale Id shift 82',0.00,1273040.80,230.00,1273040.80,0.00,'2022-10-21 19:24:27'),(76,'8','212',1,'Sale Id shift 83',0.00,1124827.50,235.00,1124827.50,0.00,'2022-10-22 20:33:29'),(77,'8','212',1,'Sale Id shift 84',0.00,1886894.90,235.00,1886894.90,0.00,'2022-10-23 18:33:19'),(78,'8','212',1,'Sale Id shift 85',0.00,886826.55,235.00,886826.55,0.00,'2022-10-25 11:14:09'),(79,'8','212',1,'Sale Id shift 86',0.00,2358434.15,235.00,2358434.15,0.00,'2022-10-25 20:15:54'),(80,'8','212',1,'Sale Id shift 88',0.00,929680.00,250.00,929680.00,0.00,'2022-10-27 05:23:43'),(81,'8','212',1,'Sale Id shift 89',0.00,1280637.50,250.00,1280637.50,0.00,'2022-10-28 07:46:46'),(82,'8','212',1,'Sale Id shift 90',0.00,1862450.00,250.00,1862450.00,0.00,'2022-10-28 19:57:02'),(83,'8','212',1,'Sale Id shift 91',0.00,1374487.50,250.00,1374487.50,0.00,'2022-11-04 20:41:08'),(84,'8','212',1,'Sale Id shift 92',0.00,478020.45,255.00,478020.45,0.00,'2022-11-05 18:29:33'),(85,'8','212',1,'Sale Id shift 93',0.00,688500.00,255.00,688500.00,0.00,'2022-11-06 21:19:31'),(86,'8','212',1,'Sale Id shift 94',0.00,2098722.50,250.00,2098722.50,0.00,'2022-11-06 21:28:32'),(87,'8','212',1,'Sale Id shift 95',0.00,1308097.50,250.00,1308097.50,0.00,'2022-11-07 21:30:49'),(88,'8','212',1,'Sale Id shift 96',0.00,1504165.00,250.00,1504165.00,0.00,'2022-11-08 20:49:52'),(89,'8','212',1,'Sale Id shift 97',0.00,1786335.00,250.00,1786335.00,0.00,'2022-11-09 19:10:45'),(90,'8','212',1,'Sale Id shift 98',0.00,1773220.00,250.00,1773220.00,0.00,'2022-11-10 18:45:02'),(91,'8','212',1,'Sale Id shift 99',0.00,1671802.50,250.00,1671802.50,0.00,'2022-11-11 19:24:13'),(92,'8','212',1,'Sale Id shift 100',0.00,2025752.50,250.00,2025752.50,0.00,'2022-11-12 18:39:44'),(93,'8','212',1,'Sale Id shift 101',0.00,1644081.90,255.00,1644081.90,0.00,'2022-11-15 20:23:24'),(94,'8','212',1,'Sale Id shift 102',0.00,780279.60,255.00,780279.60,0.00,'2022-11-15 20:32:37'),(95,'8','212',1,'Sale Id shift 103',0.00,1462386.75,255.00,1462386.75,0.00,'2022-11-15 20:38:39'),(96,'8','212',1,'Sale Id shift 104',0.00,1406837.55,255.00,1406837.55,0.00,'2022-11-17 13:01:34'),(97,'8','212',1,'Sale Id shift 105',0.00,1579046.70,255.00,1579046.70,0.00,'2022-11-18 12:16:58'),(98,'8','212',1,'Sale Id shift 106',0.00,1858442.55,255.00,1858442.55,0.00,'2022-11-18 19:02:44'),(99,'8','212',1,'Sale Id shift 107',0.00,1376199.30,255.00,1376199.30,0.00,'2022-11-20 06:56:11'),(100,'8','212',1,'Sale Id shift 108',0.00,2126707.65,255.00,2126707.65,0.00,'2022-11-20 19:54:19'),(101,'8','212',1,'Sale Id shift 109',0.00,208521.15,255.00,208521.15,0.00,'2022-11-22 21:14:37'),(102,'8','212',1,'Sale Id shift 110',0.00,849259.65,255.00,849259.65,0.00,'2022-11-23 08:02:27'),(103,'8','212',1,'Sale Id shift 111',0.00,1318413.75,255.00,1318413.75,0.00,'2022-11-24 07:41:34'),(104,'8','212',1,'Sale Id shift 112',0.00,1639764.75,255.00,1639764.75,0.00,'2022-11-25 09:34:10'),(105,'8','212',1,'Sale Id shift 113',0.00,1468851.00,255.00,1468851.00,0.00,'2022-11-25 19:00:55'),(106,'8','212',1,'Sale Id shift 114',0.00,701760.80,260.00,701760.80,0.00,'2022-11-27 08:37:57'),(107,'8','212',1,'Sale Id shift 115',0.00,2136035.20,260.00,2136035.20,0.00,'2022-11-27 18:39:46'),(108,'8','212',1,'Sale Id shift 116',0.00,328177.20,260.00,328177.20,0.00,'2022-12-03 14:48:08'),(109,'8','212',1,'Sale Id shift 117',0.00,1594260.90,260.00,1535214.20,-59046.70,'2022-12-03 14:54:47'),(110,'8','212',1,'Sale Id shift 118',0.00,3717189.90,260.00,3579516.20,-137673.70,'2022-12-03 15:00:26'),(111,'8','212',1,'Sale Id shift 119',0.00,1083712.50,270.00,1083712.50,0.00,'2022-12-03 18:56:37'),(112,'8','212',1,'Sale Id shift 120',0.00,1718236.80,270.00,1718236.80,0.00,'2022-12-05 10:12:01'),(113,'8','212',1,'Sale Id shift 121',0.00,491421.60,270.00,491421.60,0.00,'2022-12-06 06:03:44'),(114,'8','212',1,'Sale Id shift 122',0.00,2305959.30,270.00,2305959.30,0.00,'2022-12-06 20:02:39'),(115,'8','212',1,'Sale Id shift 123',0.00,2119063.85,277.00,2119063.85,0.00,'2022-12-07 22:04:35'),(116,'8','212',1,'Sale Id shift 124',0.00,2304698.95,305.00,2304698.95,0.00,'2022-12-15 15:42:55'),(117,'8','212',1,'Sale Id shift 125',0.00,2143311.25,305.00,2143311.25,0.00,'2022-12-16 15:01:41'),(118,'8','212',1,'Sale Id shift 126',0.00,741012.75,305.00,741012.75,0.00,'2022-12-17 11:18:44'),(119,'8','212',1,'Sale Id shift 127',0.00,606026.70,185.00,606026.70,0.00,'2022-12-17 11:26:53'),(120,'8','212',1,'Sale Id shift 128',0.00,1085266.60,310.00,1085266.60,0.00,'2022-12-18 13:38:08'),(121,'8','212',1,'Sale Id shift 129',0.00,539545.10,185.00,539545.10,0.00,'2022-12-21 19:19:31'),(122,'8','212',1,'Sale Id shift 130',0.00,1535919.80,185.00,916597.30,-619322.50,'2022-12-22 12:08:05'),(123,'8','212',1,'Sale Id shift 131',0.00,561391.40,185.00,335023.90,-226367.50,'2022-12-25 14:04:46'),(124,'8','212',1,'Sale Id shift 132',0.00,658145.50,185.00,392764.25,-265381.25,'2022-12-28 11:46:27'),(125,'8','212',1,'Sale Id shift 133',0.00,552218.50,185.00,329549.75,-222668.75,'2022-12-30 21:01:39'),(126,'8','212',1,'Sale Id shift 134',0.00,2156598.00,300.00,2156598.00,0.00,'2023-01-01 21:59:21'),(127,'8','212',1,'Sale Id shift 135',0.00,361523.30,185.00,361523.30,0.00,'2023-01-04 21:34:07'),(128,'8','212',1,'Sale Id shift 136',0.00,1250856.00,300.00,1250856.00,0.00,'2023-01-06 09:38:09'),(129,'8','212',1,'Sale Id shift 137',0.00,622587.90,185.00,622587.90,0.00,'2023-01-07 12:55:52'),(130,'8','212',1,'Sale Id shift 138',0.00,1714937.25,195.00,1714937.25,0.00,'2023-01-27 23:04:15'),(131,'8','212',1,'Sale Id shift 139',0.00,1930464.48,336.00,1930464.48,0.00,'2023-01-30 17:30:48'),(132,'8','212',1,'Sale Id shift 140',0.00,1083885.60,336.00,1083885.60,0.00,'2023-01-31 14:39:37'),(133,'8','212',1,'Sale Id shift 141',0.00,689206.50,345.00,689206.50,0.00,'2023-02-01 10:08:06'),(134,'8','212',1,'Sale Id shift 142',0.00,1154273.40,345.00,1154273.40,0.00,'2023-02-02 20:39:37'),(135,'8','212',1,'Sale Id shift 143',0.00,1618215.60,345.00,1618215.60,0.00,'2023-02-03 18:59:47'),(136,'8','212',1,'Sale Id shift 144',0.00,2461336.95,345.00,2461336.95,0.00,'2023-02-06 08:23:59'),(137,'8','212',1,'Sale Id shift 145',0.00,933207.75,345.00,933207.75,0.00,'2023-02-07 10:40:13'),(138,'8','212',1,'Sale Id shift 146',0.00,1051497.90,345.00,1051497.90,0.00,'2023-02-16 19:53:35'),(139,'8','212',1,'Sale Id shift 147',0.00,1498767.60,340.00,1498767.60,0.00,'2023-02-17 19:37:29'),(140,'8','212',1,'Sale Id shift 148',0.00,710402.80,340.00,710402.80,0.00,'2023-02-21 10:39:46'),(141,'8','212',1,'Sale Id shift 149',0.00,737711.60,340.00,737711.60,0.00,'2023-02-21 10:44:01'),(142,'8','212',1,'Sale Id shift 150',0.00,2162019.20,340.00,2162019.20,0.00,'2023-02-21 10:49:52'),(143,'8','212',1,'Sale Id shift 151',0.00,1137055.20,340.00,1137055.20,0.00,'2023-02-21 10:57:06'),(144,'8','212',1,'Sale Id shift 152',0.00,688727.80,340.00,688727.80,0.00,'2023-02-23 21:55:30'),(145,'8','212',1,'Sale Id shift 153',0.00,1156595.20,320.00,1156595.20,0.00,'2023-02-23 22:01:31'),(146,'8','212',1,'Sale Id shift 154',0.00,682278.40,320.00,682278.40,0.00,'2023-02-24 08:58:52'),(147,'8','212',1,'Sale Id shift 155',0.00,955337.60,320.00,955337.60,0.00,'2023-02-27 09:15:24'),(148,'8','212',1,'Sale Id shift 156',0.00,1905596.80,320.00,1905596.80,0.00,'2023-02-27 09:19:23'),(149,'8','212',1,'Sale Id shift 157',0.00,1000000.00,320.00,1000000.00,0.00,'2023-02-28 23:12:41'),(150,'8','212',1,'Sale Id shift 158',0.00,1051404.80,320.00,1051404.80,0.00,'2023-03-01 17:38:36'),(151,'8','212',1,'Sale Id shift 159',0.00,860579.20,320.00,860579.20,0.00,'2023-03-03 23:17:10'),(152,'8','212',1,'Sale Id shift 160',0.00,840409.60,320.00,840409.60,0.00,'2023-03-03 23:22:10'),(153,'8','212',1,'Sale Id shift 161',0.00,1058994.00,300.00,1058994.00,0.00,'2023-03-04 23:02:13'),(154,'8','212',1,'Sale Id shift 162',0.00,887757.00,300.00,887757.00,0.00,'2023-03-06 17:41:04'),(155,'8','212',1,'Sale Id shift 163',0.00,1644354.00,300.00,1644354.00,0.00,'2023-03-06 17:44:45'),(156,'8','212',1,'Sale Id shift 164',0.00,594768.00,300.00,594768.00,0.00,'2023-03-09 00:04:45'),(157,'8','212',1,'Sale Id shift 165',0.00,473319.00,300.00,473319.00,0.00,'2023-03-09 23:15:51'),(158,'8','212',1,'Sale Id shift 166',0.00,713025.00,300.00,713025.00,0.00,'2023-03-09 23:20:16'),(159,'8','212',1,'Sale Id shift 167',0.00,818979.00,300.00,818979.00,0.00,'2023-03-11 13:49:58'),(160,'8','212',1,'Sale Id shift 168',0.00,1181796.00,300.00,1181796.00,0.00,'2023-03-11 13:53:35'),(161,'8','212',1,'Sale Id shift 169',0.00,3009384.00,300.00,3009384.00,0.00,'2023-03-13 17:09:16'),(162,'8','212',1,'Sale Id shift 170',0.00,1086264.00,300.00,1086264.00,0.00,'2023-03-18 13:43:06'),(163,'8','212',1,'Sale Id shift 171',0.00,992754.00,300.00,992754.00,0.00,'2023-03-18 13:48:24'),(164,'8','212',1,'Sale Id shift 172',0.00,1046916.00,300.00,1046916.00,0.00,'2023-03-18 13:53:00'),(165,'8','212',1,'Sale Id shift 173',0.00,1136550.00,300.00,1136550.00,0.00,'2023-03-18 13:58:13'),(166,'8','212',1,'Sale Id shift 174',0.00,966654.00,300.00,966654.00,0.00,'2023-03-20 08:43:35'),(167,'8','212',1,'Sale Id shift 175',0.00,3211365.00,300.00,3211365.00,0.00,'2023-03-20 08:53:56');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=773 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('8','212',25,'','24','3',0.00,6417750.00,'Purchase Id 5 for 29,850.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-11 15:37:01','',''),('8','212',26,'','supplier','1',6417750.00,0.00,'Purchase Id 5 for 29,850.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-11 15:37:01','',''),('8','212',27,'','20','5',0.00,0.00,'Sales from shift 7 on 2022-08-12 13:08:19 ','2022-08-12 13:08:19','',''),('8','212',28,'','6.1','1',0.00,0.00,'Sales from shift 7 on 2022-08-12 13:08:19 ','2022-08-12 13:08:19','',''),('8','212',29,'','20','5',141639.85,0.00,'Sales from shift 8 on 2022-08-12 15:53:15 ','2022-08-12 15:53:15','',''),('8','212',30,'','6.1','1',0.00,141639.85,'Sales from shift 8 on 2022-08-12 15:53:15 ','2022-08-12 15:53:15','',''),('8','212',31,'','20','5',238086.70,0.00,'Sales from shift 9 on 2022-08-12 16:06:56 ','2022-08-12 16:06:56','',''),('8','212',32,'','6.1','1',0.00,238086.70,'Sales from shift 9 on 2022-08-12 16:06:56 ','2022-08-12 16:06:56','',''),('8','212',33,'','24','3',0.00,3655000.00,'Purchase Id 6 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-12 18:16:06','',''),('8','212',34,'','supplier','1',3655000.00,0.00,'Purchase Id 6 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-12 18:16:06','',''),('8','212',35,'','20','5',316918.60,0.00,'Sales from shift 10 on 2022-08-12 19:26:53 ','2022-08-12 19:26:53','',''),('8','212',36,'','6.1','1',0.00,316918.60,'Sales from shift 10 on 2022-08-12 19:26:53 ','2022-08-12 19:26:53','',''),('8','212',37,'','20','5',219923.50,0.00,'Sales from shift 11 on 2022-08-13 19:25:41 ','2022-08-13 19:25:41','',''),('8','212',38,'','6.1','1',0.00,219923.50,'Sales from shift 11 on 2022-08-13 19:25:41 ','2022-08-13 19:25:41','',''),('8','212',39,'','20','5',826702.95,0.00,'Sales from shift 12 on 2022-08-14 19:58:25 ','2022-08-14 19:58:25','',''),('8','212',40,'','6.1','1',0.00,826702.95,'Sales from shift 12 on 2022-08-14 19:58:25 ','2022-08-14 19:58:25','',''),('8','212',41,'','2','6',6417750.00,0.00,'Payment Id 6 for invoice:12, receipt: 610622 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',42,'','supplier','1',0.00,6417750.00,'Payment Id 6 for invoice:12, receipt: 610622 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',43,'','2','6',6417750.00,0.00,'Payment Id 5 for invoice:12, receipt: 003 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',44,'','supplier','1',0.00,6417750.00,'Payment Id 5 for invoice:12, receipt: 003 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',45,'','2','6',6417750.00,0.00,'Payment Id 4 for invoice:12, receipt: 003 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',46,'','supplier','1',0.00,6417750.00,'Payment Id 4 for invoice:12, receipt: 003 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',47,'','2','6',6417750.00,0.00,'Payment Id 3 for invoice:2, receipt: 002 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',48,'','supplier','1',0.00,6417750.00,'Payment Id 3 for invoice:2, receipt: 002 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',49,'','2','6',6417750.00,0.00,'Payment Id 2 for invoice:1, receipt: 001 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',50,'','supplier','1',0.00,6417750.00,'Payment Id 2 for invoice:1, receipt: 001 by Lausu Energy Resources','2022-08-15 12:54:50','',''),('8','212',51,'','20','5',174964.85,0.00,'Sales from shift 13 on 2022-08-15 20:12:31 ','2022-08-15 20:12:31','',''),('8','212',52,'','6.1','1',0.00,174964.85,'Sales from shift 13 on 2022-08-15 20:12:31 ','2022-08-15 20:12:31','',''),('8','212',53,'','20','5',210162.50,0.00,'Sales from shift 14 on 2022-08-16 20:51:01 ','2022-08-16 20:51:01','',''),('8','212',54,'','6.1','1',0.00,210162.50,'Sales from shift 14 on 2022-08-16 20:51:01 ','2022-08-16 20:51:01','',''),('8','212',55,'','20','5',255119.00,0.00,'Sales from shift 15 on 2022-08-19 19:05:23 ','2022-08-19 19:05:23','',''),('8','212',56,'','6.1','1',0.00,255119.00,'Sales from shift 15 on 2022-08-19 19:05:23 ','2022-08-19 19:05:23','',''),('8','212',57,'','20','5',273692.85,0.00,'Sales from shift 16 on 2022-08-19 19:09:45 ','2022-08-19 19:09:45','',''),('8','212',58,'','6.1','1',0.00,273692.85,'Sales from shift 16 on 2022-08-19 19:09:45 ','2022-08-19 19:09:45','',''),('8','212',59,'','20','5',220884.55,0.00,'Sales from shift 17 on 2022-08-19 19:14:20 ','2022-08-19 19:14:20','',''),('8','212',60,'','6.1','1',0.00,220884.55,'Sales from shift 17 on 2022-08-19 19:14:20 ','2022-08-19 19:14:20','',''),('8','212',61,'','2','6',6417750.00,0.00,'Payment Id 8 for invoice:17, receipt: 005 by Lausu Energy Resources','2022-08-19 19:23:38','',''),('8','212',62,'','supplier','1',0.00,6417750.00,'Payment Id 8 for invoice:17, receipt: 005 by Lausu Energy Resources','2022-08-19 19:23:38','',''),('8','212',63,'','2','6',6417750.00,0.00,'Payment Id 7 for invoice:13, receipt: 004 by Lausu Energy Resources','2022-08-19 19:23:38','',''),('8','212',64,'','supplier','1',0.00,6417750.00,'Payment Id 7 for invoice:13, receipt: 004 by Lausu Energy Resources','2022-08-19 19:23:38','',''),('8','212',65,'','2','6',6417750.00,0.00,'Payment Id 9 for invoice:18, receipt: 006 by Lausu Energy Resources','2022-08-19 19:29:21','',''),('8','212',66,'','supplier','1',0.00,6417750.00,'Payment Id 9 for invoice:18, receipt: 006 by Lausu Energy Resources','2022-08-19 19:29:21','',''),('8','212',67,'','2','6',6417750.00,0.00,'Payment Id 10 for invoice:19, receipt: 007 by Lausu Energy Resources','2022-08-19 19:32:21','',''),('8','212',68,'','supplier','1',0.00,6417750.00,'Payment Id 10 for invoice:19, receipt: 007 by Lausu Energy Resources','2022-08-19 19:32:21','',''),('8','212',69,'','20','5',192941.00,0.00,'Sales from shift 18 on 2022-08-20 20:33:36 ','2022-08-20 20:33:36','',''),('8','212',70,'','6.1','1',0.00,192941.00,'Sales from shift 18 on 2022-08-20 20:33:36 ','2022-08-20 20:33:36','',''),('8','212',71,'','20','5',732855.45,0.00,'Sales from shift 19 on 2022-08-21 19:47:52 ','2022-08-21 19:47:52','',''),('8','212',72,'','6.1','1',0.00,732855.45,'Sales from shift 19 on 2022-08-21 19:47:52 ','2022-08-21 19:47:52','',''),('8','212',73,'','2','6',0.00,6417750.00,'Payment Id 10 for invoice:19, receipt: 007 by Lausu Energy Resources','2022-08-22 13:23:52','',''),('8','212',74,'','supplier','1',6417750.00,0.00,'Payment Id 10 for invoice:19, receipt: 007 by Lausu Energy Resources','2022-08-22 13:23:52','',''),('8','212',75,'','2','6',0.00,6417750.00,'Payment Id 2 for invoice:1, receipt: 001 by Lausu Energy Resources','2022-08-22 21:49:41','',''),('8','212',76,'','supplier','1',6417750.00,0.00,'Payment Id 2 for invoice:1, receipt: 001 by Lausu Energy Resources','2022-08-22 21:49:41','',''),('8','212',77,'','2','6',0.00,6417750.00,'Payment Id 3 for invoice:2, receipt: 002 by Lausu Energy Resources','2022-08-22 21:51:31','',''),('8','212',78,'','supplier','1',6417750.00,0.00,'Payment Id 3 for invoice:2, receipt: 002 by Lausu Energy Resources','2022-08-22 21:51:31','',''),('8','212',79,'','2','6',0.00,6417750.00,'Payment Id 4 for invoice:12, receipt: 003 by Lausu Energy Resources','2022-08-22 21:53:00','',''),('8','212',80,'','supplier','1',6417750.00,0.00,'Payment Id 4 for invoice:12, receipt: 003 by Lausu Energy Resources','2022-08-22 21:53:00','',''),('8','212',81,'','2','6',0.00,6417750.00,'Payment Id 5 for invoice:12, receipt: 003 by Lausu Energy Resources','2022-08-22 21:55:08','',''),('8','212',82,'','supplier','1',6417750.00,0.00,'Payment Id 5 for invoice:12, receipt: 003 by Lausu Energy Resources','2022-08-22 21:55:08','',''),('8','212',83,'','2','6',0.00,6417750.00,'Payment Id 6 for invoice:12, receipt: 610622 by Lausu Energy Resources','2022-08-22 21:55:39','',''),('8','212',84,'','supplier','1',6417750.00,0.00,'Payment Id 6 for invoice:12, receipt: 610622 by Lausu Energy Resources','2022-08-22 21:55:39','',''),('8','212',85,'','2','6',0.00,6417750.00,'Payment Id 7 for invoice:13, receipt: 004 by Lausu Energy Resources','2022-08-22 21:57:02','',''),('8','212',86,'','supplier','1',6417750.00,0.00,'Payment Id 7 for invoice:13, receipt: 004 by Lausu Energy Resources','2022-08-22 21:57:02','',''),('8','212',87,'','2','6',0.00,6417750.00,'Payment Id 8 for invoice:17, receipt: 005 by Lausu Energy Resources','2022-08-22 21:57:40','',''),('8','212',88,'','supplier','1',6417750.00,0.00,'Payment Id 8 for invoice:17, receipt: 005 by Lausu Energy Resources','2022-08-22 21:57:40','',''),('8','212',89,'','2','6',0.00,6417750.00,'Payment Id 9 for invoice:18, receipt: 006 by Lausu Energy Resources','2022-08-22 21:58:16','',''),('8','212',90,'','supplier','1',6417750.00,0.00,'Payment Id 9 for invoice:18, receipt: 006 by Lausu Energy Resources','2022-08-22 21:58:16','',''),('8','212',91,'','24','3',0.00,6503750.00,'Purchase Id 7 for 30,250.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-23 13:28:14','',''),('8','212',92,'','supplier','1',6503750.00,0.00,'Purchase Id 7 for 30,250.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-23 13:28:14','',''),('8','212',93,'','2','6',212665.00,0.00,'Payment Id 11 for invoice:19, receipt: 007 by Lausu Energy Resources','2022-08-23 13:35:15','',''),('8','212',94,'','supplier','1',0.00,212665.00,'Payment Id 11 for invoice:19, receipt: 007 by Lausu Energy Resources','2022-08-23 13:35:15','',''),('8','212',95,'','2','6',681730.00,0.00,'Payment Id 22 for invoice:19, receipt: 610559 by Lausu Energy Resources','2022-08-23 13:35:42','',''),('8','212',96,'','supplier','1',0.00,681730.00,'Payment Id 22 for invoice:19, receipt: 610559 by Lausu Energy Resources','2022-08-23 13:35:42','',''),('8','212',97,'','2','6',263510.00,0.00,'Payment Id 20 for invoice:19, receipt: 008 by Lausu Energy Resources','2022-08-23 13:36:24','',''),('8','212',98,'','supplier','1',0.00,263510.00,'Payment Id 20 for invoice:19, receipt: 008 by Lausu Energy Resources','2022-08-23 13:36:24','',''),('8','212',99,'','2','6',245630.00,0.00,'Payment Id 19 for invoice:19, receipt: 007 by Lausu Energy Resources','2022-08-23 13:36:50','',''),('8','212',100,'','supplier','1',0.00,245630.00,'Payment Id 19 for invoice:19, receipt: 007 by Lausu Energy Resources','2022-08-23 13:36:50','',''),('8','212',101,'','2','6',202345.00,0.00,'Payment Id 18 for invoice:19, receipt: 006 by Lausu Energy Resources','2022-08-23 13:37:38','',''),('8','212',102,'','supplier','1',0.00,202345.00,'Payment Id 18 for invoice:19, receipt: 006 by Lausu Energy Resources','2022-08-23 13:37:38','',''),('8','212',103,'','2','6',174965.00,0.00,'Payment Id 17 for invoice:19, receipt: 005 by Lausu Energy Resources','2022-08-23 13:38:03','',''),('8','212',104,'','supplier','1',0.00,174965.00,'Payment Id 17 for invoice:19, receipt: 005 by Lausu Energy Resources','2022-08-23 13:38:03','',''),('8','212',105,'','2','6',316920.00,0.00,'Payment Id 14 for invoice:19, receipt: 003 by Lausu Energy Resources','2022-08-23 13:38:45','',''),('8','212',106,'','supplier','1',0.00,316920.00,'Payment Id 14 for invoice:19, receipt: 003 by Lausu Energy Resources','2022-08-23 13:38:45','',''),('8','212',107,'','2','6',219925.00,0.00,'Payment Id 15 for invoice:19, receipt: 004 by Lausu Energy Resources','2022-08-23 13:39:02','',''),('8','212',108,'','supplier','1',0.00,219925.00,'Payment Id 15 for invoice:19, receipt: 004 by Lausu Energy Resources','2022-08-23 13:39:02','',''),('8','212',109,'','2','6',826705.00,0.00,'Payment Id 16 for invoice:19, receipt: 610622 by Lausu Energy Resources','2022-08-23 13:39:19','',''),('8','212',110,'','supplier','1',0.00,826705.00,'Payment Id 16 for invoice:19, receipt: 610622 by Lausu Energy Resources','2022-08-23 13:39:19','',''),('8','212',111,'','2','6',238090.00,0.00,'Payment Id 13 for invoice:, receipt: 610622 by Lausu Energy Resources','2022-08-23 13:39:58','',''),('8','212',112,'','supplier','1',0.00,238090.00,'Payment Id 13 for invoice:, receipt: 610622 by Lausu Energy Resources','2022-08-23 13:39:58','',''),('8','212',113,'','2','6',141640.00,0.00,'Payment Id 12 for invoice:19, receipt:  by Lausu Energy Resources','2022-08-23 13:40:22','',''),('8','212',114,'','supplier','1',0.00,141640.00,'Payment Id 12 for invoice:19, receipt:  by Lausu Energy Resources','2022-08-23 13:40:22','',''),('8','212',115,'','2','6',185760.00,0.00,'Payment Id 21 for invoice:19, receipt: 009 by Lausu Energy Resources','2022-08-23 13:41:33','',''),('8','212',116,'','supplier','1',0.00,185760.00,'Payment Id 21 for invoice:19, receipt: 009 by Lausu Energy Resources','2022-08-23 13:41:33','',''),('8','212',117,'','20','5',149014.35,0.00,'Sales from shift 20 on 2022-08-23 14:07:23 ','2022-08-23 14:07:23','',''),('8','212',118,'','6.1','1',0.00,149014.35,'Sales from shift 20 on 2022-08-23 14:07:23 ','2022-08-23 14:07:23','',''),('8','212',119,'','20','5',149351.90,0.00,'Sales from shift 21 on 2022-08-23 19:15:01 ','2022-08-23 19:15:01','',''),('8','212',120,'','6.1','1',0.00,149351.90,'Sales from shift 21 on 2022-08-23 19:15:01 ','2022-08-23 19:15:01','',''),('8','212',121,'','20','5',0.00,0.00,'Sales from shift 22 on 2022-08-24 20:45:05 ','2022-08-24 20:45:05','',''),('8','212',122,'','6.1','1',0.00,0.00,'Sales from shift 22 on 2022-08-24 20:45:05 ','2022-08-24 20:45:05','',''),('8','212',123,'','20','5',179411.30,0.00,'Sales from shift 23 on 2022-08-25 16:54:48 ','2022-08-25 16:54:48','',''),('8','212',124,'','6.1','1',0.00,179411.30,'Sales from shift 23 on 2022-08-25 16:54:48 ','2022-08-25 16:54:48','',''),('8','212',125,'','20','5',290454.90,0.00,'Sales from shift 24 on 2022-08-25 19:40:35 ','2022-08-25 19:40:35','',''),('8','212',126,'','6.1','1',0.00,290454.90,'Sales from shift 24 on 2022-08-25 19:40:35 ','2022-08-25 19:40:35','',''),('8','212',127,'','20','5',218443.00,0.00,'Sales from shift 25 on 2022-08-26 20:38:18 ','2022-08-26 20:38:18','',''),('8','212',128,'','6.1','1',0.00,218443.00,'Sales from shift 25 on 2022-08-26 20:38:18 ','2022-08-26 20:38:18','',''),('8','212',129,'','20','5',356194.90,0.00,'Sales from shift 26 on 2022-08-28 19:45:48 ','2022-08-28 19:45:48','',''),('8','212',130,'','6.1','1',0.00,356194.90,'Sales from shift 26 on 2022-08-28 19:45:48 ','2022-08-28 19:45:48','',''),('8','212',131,'','20','5',572869.00,0.00,'Sales from shift 27 on 2022-08-28 19:50:15 ','2022-08-28 19:50:15','',''),('8','212',132,'','6.1','1',0.00,572869.00,'Sales from shift 27 on 2022-08-28 19:50:15 ','2022-08-28 19:50:15','',''),('8','212',133,'','20','5',130596.50,0.00,'Sales from shift 28 on 2022-08-29 19:50:40 ','2022-08-29 19:50:40','',''),('8','212',134,'','6.1','1',0.00,130596.50,'Sales from shift 28 on 2022-08-29 19:50:40 ','2022-08-29 19:50:40','',''),('8','212',135,'','20','5',224903.00,0.00,'Sales from shift 29 on 2022-08-30 19:08:06 ','2022-08-30 19:08:06','',''),('8','212',136,'','6.1','1',0.00,224903.00,'Sales from shift 29 on 2022-08-30 19:08:06 ','2022-08-30 19:08:06','',''),('8','212',137,'','20','5',334540.60,0.00,'Sales from shift 30 on 2022-08-31 19:53:10 ','2022-08-31 19:53:10','',''),('8','212',138,'','6.1','1',0.00,334540.60,'Sales from shift 30 on 2022-08-31 19:53:10 ','2022-08-31 19:53:10','',''),('8','212',139,'','2','6',334540.00,0.00,'Payment Id 32 for invoice:30, receipt: 018 by Lausu Energy Resources','2022-09-01 15:24:33','',''),('8','212',140,'','supplier','1',0.00,334540.00,'Payment Id 32 for invoice:30, receipt: 018 by Lausu Energy Resources','2022-09-01 15:24:33','',''),('8','212',141,'','2','6',224910.00,0.00,'Payment Id 31 for invoice:29, receipt: 017 by Lausu Energy Resources','2022-09-01 15:25:55','',''),('8','212',142,'','supplier','1',0.00,224910.00,'Payment Id 31 for invoice:29, receipt: 017 by Lausu Energy Resources','2022-09-01 15:25:55','',''),('8','212',143,'','2','6',130595.00,0.00,'Payment Id 30 for invoice:28, receipt: 016 by Lausu Energy Resources','2022-09-01 15:26:39','',''),('8','212',144,'','supplier','1',0.00,130595.00,'Payment Id 30 for invoice:28, receipt: 016 by Lausu Energy Resources','2022-09-01 15:26:39','',''),('8','212',145,'','2','6',218445.50,0.00,'Payment Id 27 for invoice:25, receipt: 014 by Lausu Energy Resources','2022-09-01 15:30:09','',''),('8','212',146,'','supplier','1',0.00,218445.50,'Payment Id 27 for invoice:25, receipt: 014 by Lausu Energy Resources','2022-09-01 15:30:09','',''),('8','212',147,'','2','6',572870.00,0.00,'Payment Id 29 for invoice:27, receipt: 015 by Lausu Energy Resources','2022-09-01 15:35:25','',''),('8','212',148,'','supplier','1',0.00,572870.00,'Payment Id 29 for invoice:27, receipt: 015 by Lausu Energy Resources','2022-09-01 15:35:25','',''),('8','212',149,'','2','6',356195.00,0.00,'Payment Id 28 for invoice:26, receipt: 015 by Lausu Energy Resources','2022-09-01 15:38:07','',''),('8','212',150,'','supplier','1',0.00,356195.00,'Payment Id 28 for invoice:26, receipt: 015 by Lausu Energy Resources','2022-09-01 15:38:07','',''),('8','212',151,'','2','6',290455.00,0.00,'Payment Id 26 for invoice:24, receipt: 013 by Lausu Energy Resources','2022-09-01 15:38:43','',''),('8','212',152,'','supplier','1',0.00,290455.00,'Payment Id 26 for invoice:24, receipt: 013 by Lausu Energy Resources','2022-09-01 15:38:43','',''),('8','212',153,'','2','6',179410.00,0.00,'Payment Id 25 for invoice:23, receipt: 013 by Lausu Energy Resources','2022-09-01 15:39:56','',''),('8','212',154,'','supplier','1',0.00,179410.00,'Payment Id 25 for invoice:23, receipt: 013 by Lausu Energy Resources','2022-09-01 15:39:56','',''),('8','212',155,'','2','6',138935.00,0.00,'Payment Id 24 for invoice:21, receipt: 012 by Lausu Energy Resources','2022-09-01 15:40:58','',''),('8','212',156,'','supplier','1',0.00,138935.00,'Payment Id 24 for invoice:21, receipt: 012 by Lausu Energy Resources','2022-09-01 15:40:58','',''),('8','212',157,'','2','6',138630.00,0.00,'Payment Id 23 for invoice:20, receipt: 011 by Lausu Energy Resources','2022-09-01 15:41:27','',''),('8','212',158,'','supplier','1',0.00,138630.00,'Payment Id 23 for invoice:20, receipt: 011 by Lausu Energy Resources','2022-09-01 15:41:27','',''),('8','212',159,'','20','5',311229.50,0.00,'Sales from shift 31 on 2022-09-01 20:13:15 ','2022-09-01 20:13:15','',''),('8','212',160,'','6.1','1',0.00,311229.50,'Sales from shift 31 on 2022-09-01 20:13:15 ','2022-09-01 20:13:15','',''),('8','212',161,'','20','5',807747.00,0.00,'Sales from shift 32 on 2022-09-02 19:49:23 ','2022-09-02 19:49:23','',''),('8','212',162,'','6.1','1',0.00,807747.00,'Sales from shift 32 on 2022-09-02 19:49:23 ','2022-09-02 19:49:23','',''),('8','212',163,'','20','5',603362.10,0.00,'Sales from shift 33 on 2022-09-04 08:22:09 ','2022-09-04 08:22:09','',''),('8','212',164,'','6.1','1',0.00,603362.10,'Sales from shift 33 on 2022-09-04 08:22:09 ','2022-09-04 08:22:09','',''),('8','212',165,'','20','5',1423633.90,0.00,'Sales from shift 34 on 2022-09-05 21:38:54 ','2022-09-05 21:38:54','',''),('8','212',166,'','6.1','1',0.00,1423633.90,'Sales from shift 34 on 2022-09-05 21:38:54 ','2022-09-05 21:38:54','',''),('8','212',167,'','20','5',310921.70,0.00,'Sales from shift 35 on 2022-09-05 21:44:16 ','2022-09-05 21:44:16','',''),('8','212',168,'','6.1','1',0.00,310921.70,'Sales from shift 35 on 2022-09-05 21:44:16 ','2022-09-05 21:44:16','',''),('8','212',169,'','24','3',0.00,6308000.00,'Purchase Id 8 for 33,200.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-06 07:13:12','',''),('8','212',170,'','supplier','1',6308000.00,0.00,'Purchase Id 8 for 33,200.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-06 07:13:12','',''),('8','212',171,'','2','6',310920.00,0.00,'Payment Id 37 for invoice:35, receipt: 020 by Lausu Energy Resources','2022-09-06 19:03:11','',''),('8','212',172,'','supplier','1',0.00,310920.00,'Payment Id 37 for invoice:35, receipt: 020 by Lausu Energy Resources','2022-09-06 19:03:11','',''),('8','212',173,'','2','6',603365.00,0.00,'Payment Id 35 for invoice:33, receipt: 019 by Lausu Energy Resources','2022-09-06 19:03:36','',''),('8','212',174,'','supplier','1',0.00,603365.00,'Payment Id 35 for invoice:33, receipt: 019 by Lausu Energy Resources','2022-09-06 19:03:36','',''),('8','212',175,'','2','6',807750.00,0.00,'Payment Id 34 for invoice:32, receipt: 019 by Lausu Energy Resources','2022-09-06 19:04:01','',''),('8','212',176,'','supplier','1',0.00,807750.00,'Payment Id 34 for invoice:32, receipt: 019 by Lausu Energy Resources','2022-09-06 19:04:01','',''),('8','212',177,'','2','6',311230.00,0.00,'Payment Id 33 for invoice:31, receipt: 018 by Lausu Energy Resources','2022-09-06 19:05:01','',''),('8','212',178,'','supplier','1',0.00,311230.00,'Payment Id 33 for invoice:31, receipt: 018 by Lausu Energy Resources','2022-09-06 19:05:01','',''),('8','212',179,'','20','5',240258.80,0.00,'Sales from shift 36 on 2022-09-06 20:51:56 ','2022-09-06 20:51:56','',''),('8','212',180,'','6.1','1',0.00,240258.80,'Sales from shift 36 on 2022-09-06 20:51:56 ','2022-09-06 20:51:56','',''),('8','212',181,'','20','5',145855.40,0.00,'Sales from shift 37 on 2022-09-07 20:41:20 ','2022-09-07 20:41:20','',''),('8','212',182,'','6.1','1',0.00,145855.40,'Sales from shift 37 on 2022-09-07 20:41:20 ','2022-09-07 20:41:20','',''),('8','212',183,'','2','6',145855.00,0.00,'Payment Id 39 for invoice:37, receipt: 022 by Lausu Energy Resources','2022-09-08 13:34:38','',''),('8','212',184,'','supplier','1',0.00,145855.00,'Payment Id 39 for invoice:37, receipt: 022 by Lausu Energy Resources','2022-09-08 13:34:38','',''),('8','212',185,'','20','5',346742.40,0.00,'Sales from shift 38 on 2022-09-08 19:21:00 ','2022-09-08 19:21:00','',''),('8','212',186,'','6.1','1',0.00,346742.40,'Sales from shift 38 on 2022-09-08 19:21:00 ','2022-09-08 19:21:00','',''),('8','212',187,'','2','6',346740.00,0.00,'Payment Id 40 for invoice:38, receipt: 023 by Lausu Energy Resources','2022-09-09 14:58:54','',''),('8','212',188,'','supplier','1',0.00,346740.00,'Payment Id 40 for invoice:38, receipt: 023 by Lausu Energy Resources','2022-09-09 14:58:54','',''),('8','212',189,'','20','5',254218.10,0.00,'Sales from shift 39 on 2022-09-10 09:27:12 ','2022-09-10 09:27:12','',''),('8','212',190,'','6.1','1',0.00,254218.10,'Sales from shift 39 on 2022-09-10 09:27:12 ','2022-09-10 09:27:12','',''),('8','212',191,'','20','5',306927.90,0.00,'Sales from shift 40 on 2022-09-10 19:34:54 ','2022-09-10 19:34:54','',''),('8','212',192,'','6.1','1',0.00,306927.90,'Sales from shift 40 on 2022-09-10 19:34:54 ','2022-09-10 19:34:54','',''),('8','212',193,'','20','5',1725135.40,0.00,'Sales from shift 41 on 2022-09-11 21:12:53 ','2022-09-11 21:12:53','',''),('8','212',194,'','6.1','1',0.00,1725135.40,'Sales from shift 41 on 2022-09-11 21:12:53 ','2022-09-11 21:12:53','',''),('8','212',195,'','2','6',1423630.00,0.00,'Payment Id 36 for invoice:34, receipt: 3379016 by Lausu Energy Resources','2022-09-12 15:08:55','',''),('8','212',196,'','supplier','1',0.00,1423630.00,'Payment Id 36 for invoice:34, receipt: 3379016 by Lausu Energy Resources','2022-09-12 15:08:55','',''),('8','212',197,'','2','6',240260.00,0.00,'Payment Id 38 for invoice:36, receipt: 021 by Lausu Energy Resources','2022-09-12 15:09:11','',''),('8','212',198,'','supplier','1',0.00,240260.00,'Payment Id 38 for invoice:36, receipt: 021 by Lausu Energy Resources','2022-09-12 15:09:11','',''),('8','212',199,'','2','6',306930.00,0.00,'Payment Id 42 for invoice:40, receipt: 024 by Lausu Energy Resources','2022-09-12 15:47:29','',''),('8','212',200,'','supplier','1',0.00,306930.00,'Payment Id 42 for invoice:40, receipt: 024 by Lausu Energy Resources','2022-09-12 15:47:29','',''),('8','212',201,'','2','6',254220.00,0.00,'Payment Id 41 for invoice:39, receipt: 024 by Lausu Energy Resources','2022-09-12 15:47:47','',''),('8','212',202,'','supplier','1',0.00,254220.00,'Payment Id 41 for invoice:39, receipt: 024 by Lausu Energy Resources','2022-09-12 15:47:47','',''),('8','212',203,'','20','5',911838.50,0.00,'Sales from shift 42 on 2022-09-12 19:26:15 ','2022-09-12 19:26:15','',''),('8','212',204,'','6.1','1',0.00,911838.50,'Sales from shift 42 on 2022-09-12 19:26:15 ','2022-09-12 19:26:15','',''),('8','212',205,'','20','5',664756.80,0.00,'Sales from shift 43 on 2022-09-13 21:12:41 ','2022-09-13 21:12:41','',''),('8','212',206,'','6.1','1',0.00,664756.80,'Sales from shift 43 on 2022-09-13 21:12:41 ','2022-09-13 21:12:41','',''),('8','212',207,'','20','5',544053.60,0.00,'Sales from shift 44 on 2022-09-14 19:42:38 ','2022-09-14 19:42:38','',''),('8','212',208,'','6.1','1',0.00,544053.60,'Sales from shift 44 on 2022-09-14 19:42:38 ','2022-09-14 19:42:38','',''),('8','212',209,'','2','6',664755.00,0.00,'Payment Id 45 for invoice:43, receipt: 026 by Lausu Energy Resources','2022-09-14 21:58:23','',''),('8','212',210,'','supplier','1',0.00,664755.00,'Payment Id 45 for invoice:43, receipt: 026 by Lausu Energy Resources','2022-09-14 21:58:23','',''),('8','212',211,'','2','6',911840.00,0.00,'Payment Id 44 for invoice:42, receipt: 025 by Lausu Energy Resources','2022-09-14 21:58:23','',''),('8','212',212,'','supplier','1',0.00,911840.00,'Payment Id 44 for invoice:42, receipt: 025 by Lausu Energy Resources','2022-09-14 21:58:23','',''),('8','212',213,'','2','6',1725135.00,0.00,'Payment Id 43 for invoice:41, receipt: 025 by Lausu Energy Resources','2022-09-14 21:58:24','',''),('8','212',214,'','supplier','1',0.00,1725135.00,'Payment Id 43 for invoice:41, receipt: 025 by Lausu Energy Resources','2022-09-14 21:58:24','',''),('8','212',215,'','20','5',525469.70,0.00,'Sales from shift 45 on 2022-09-15 18:54:48 ','2022-09-15 18:54:48','',''),('8','212',216,'','6.1','1',0.00,525469.70,'Sales from shift 45 on 2022-09-15 18:54:48 ','2022-09-15 18:54:48','',''),('8','212',217,'','20','5',462902.70,0.00,'Sales from shift 46 on 2022-09-16 20:07:18 ','2022-09-16 20:07:18','',''),('8','212',218,'','6.1','1',0.00,462902.70,'Sales from shift 46 on 2022-09-16 20:07:18 ','2022-09-16 20:07:18','',''),('8','212',219,'','24','3',0.00,6441000.00,'Purchase Id 9 for 33,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-17 07:46:28','',''),('8','212',220,'','supplier','1',6441000.00,0.00,'Purchase Id 9 for 33,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-17 07:46:28','',''),('8','212',221,'','2','6',544055.00,0.00,'Payment Id 46 for invoice:44, receipt: 026 by Lausu Energy Resources','2022-09-17 07:47:03','',''),('8','212',222,'','supplier','1',0.00,544055.00,'Payment Id 46 for invoice:44, receipt: 026 by Lausu Energy Resources','2022-09-17 07:47:03','',''),('8','212',223,'','2','6',525470.00,0.00,'Payment Id 47 for invoice:45, receipt: 027 by Lausu Energy Resources','2022-09-17 07:51:21','',''),('8','212',224,'','supplier','1',0.00,525470.00,'Payment Id 47 for invoice:45, receipt: 027 by Lausu Energy Resources','2022-09-17 07:51:21','',''),('8','212',225,'','20','5',241117.60,0.00,'Sales from shift 47 on 2022-09-17 22:27:28 ','2022-09-17 22:27:28','',''),('8','212',226,'','6.1','1',0.00,241117.60,'Sales from shift 47 on 2022-09-17 22:27:28 ','2022-09-17 22:27:28','',''),('8','212',227,'','20','5',1016728.00,0.00,'Sales from shift 48 on 2022-09-19 22:25:47 ','2022-09-19 22:25:47','',''),('8','212',228,'','6.1','1',0.00,1016728.00,'Sales from shift 48 on 2022-09-19 22:25:47 ','2022-09-19 22:25:47','',''),('8','212',229,'','20','5',224505.90,0.00,'Sales from shift 49 on 2022-09-20 10:10:25 ','2022-09-20 10:10:25','',''),('8','212',230,'','6.1','1',0.00,224505.90,'Sales from shift 49 on 2022-09-20 10:10:25 ','2022-09-20 10:10:25','',''),('8','212',231,'','20','5',283996.80,0.00,'Sales from shift 50 on 2022-09-20 20:35:29 ','2022-09-20 20:35:29','',''),('8','212',232,'','6.1','1',0.00,283996.80,'Sales from shift 50 on 2022-09-20 20:35:29 ','2022-09-20 20:35:29','',''),('8','212',233,'','2','6',224505.00,0.00,'Payment Id 51 for invoice:49, receipt: 031 by Lausu Energy Resources','2022-09-21 14:56:26','',''),('8','212',234,'','supplier','1',0.00,224505.00,'Payment Id 51 for invoice:49, receipt: 031 by Lausu Energy Resources','2022-09-21 14:56:26','',''),('8','212',235,'','2','6',241115.00,0.00,'Payment Id 49 for invoice:47, receipt: 029 by Lausu Energy Resources','2022-09-21 14:58:45','',''),('8','212',236,'','supplier','1',0.00,241115.00,'Payment Id 49 for invoice:47, receipt: 029 by Lausu Energy Resources','2022-09-21 14:58:45','',''),('8','212',237,'','20','5',258730.60,0.00,'Sales from shift 51 on 2022-09-21 21:49:03 ','2022-09-21 21:49:03','',''),('8','212',238,'','6.1','1',0.00,258730.60,'Sales from shift 51 on 2022-09-21 21:49:03 ','2022-09-21 21:49:03','',''),('8','212',239,'','20','5',394383.00,0.00,'Sales from shift 52 on 2022-09-22 22:17:01 ','2022-09-22 22:17:01','',''),('8','212',240,'','6.1','1',0.00,394383.00,'Sales from shift 52 on 2022-09-22 22:17:01 ','2022-09-22 22:17:01','',''),('8','212',241,'','2','6',462900.00,0.00,'Payment Id 48 for invoice:46, receipt: 028 by Lausu Energy Resources','2022-09-23 08:24:47','',''),('8','212',242,'','supplier','1',0.00,462900.00,'Payment Id 48 for invoice:46, receipt: 028 by Lausu Energy Resources','2022-09-23 08:24:47','',''),('8','212',243,'','2','6',1017680.00,0.00,'Payment Id 50 for invoice:48, receipt: 030 by Lausu Energy Resources','2022-09-23 08:48:41','',''),('8','212',244,'','supplier','1',0.00,1017680.00,'Payment Id 50 for invoice:48, receipt: 030 by Lausu Energy Resources','2022-09-23 08:48:41','',''),('8','212',245,'','2','6',258730.00,0.00,'Payment Id 53 for invoice:51, receipt: 033 by Lausu Energy Resources','2022-09-23 08:49:57','',''),('8','212',246,'','supplier','1',0.00,258730.00,'Payment Id 53 for invoice:51, receipt: 033 by Lausu Energy Resources','2022-09-23 08:49:57','',''),('8','212',247,'','2','6',283995.00,0.00,'Payment Id 52 for invoice:50, receipt: 032 by Lausu Energy Resources','2022-09-23 08:49:57','',''),('8','212',248,'','supplier','1',0.00,283995.00,'Payment Id 52 for invoice:50, receipt: 032 by Lausu Energy Resources','2022-09-23 08:49:57','',''),('8','212',249,'','20','5',409358.80,0.00,'Sales from shift 53 on 2022-09-23 20:15:08 ','2022-09-23 20:15:08','',''),('8','212',250,'','6.1','1',0.00,409358.80,'Sales from shift 53 on 2022-09-23 20:15:08 ','2022-09-23 20:15:08','',''),('8','212',251,'','20','5',331855.90,0.00,'Sales from shift 54 on 2022-09-25 07:52:13 ','2022-09-25 07:52:13','',''),('8','212',252,'','6.1','1',0.00,331855.90,'Sales from shift 54 on 2022-09-25 07:52:13 ','2022-09-25 07:52:13','',''),('8','212',253,'','20','5',1931452.60,0.00,'Sales from shift 55 on 2022-09-26 08:25:21 ','2022-09-26 08:25:21','',''),('8','212',254,'','6.1','1',0.00,1931452.60,'Sales from shift 55 on 2022-09-26 08:25:21 ','2022-09-26 08:25:21','',''),('8','212',255,'','20','5',536869.70,0.00,'Sales from shift 56 on 2022-09-27 08:10:31 ','2022-09-27 08:10:31','',''),('8','212',256,'','6.1','1',0.00,536869.70,'Sales from shift 56 on 2022-09-27 08:10:31 ','2022-09-27 08:10:31','',''),('8','212',257,'','2','6',394385.00,0.00,'Payment Id 54 for invoice:52, receipt: 033 by Lausu Energy Resources','2022-09-27 16:11:56','',''),('8','212',258,'','supplier','1',0.00,394385.00,'Payment Id 54 for invoice:52, receipt: 033 by Lausu Energy Resources','2022-09-27 16:11:56','',''),('8','212',259,'','2','6',409360.00,0.00,'Payment Id 55 for invoice:53, receipt: 034 by Lausu Energy Resources','2022-09-27 16:12:48','',''),('8','212',260,'','supplier','1',0.00,409360.00,'Payment Id 55 for invoice:53, receipt: 034 by Lausu Energy Resources','2022-09-27 16:12:48','',''),('8','212',261,'','2','6',331855.00,0.00,'Payment Id 56 for invoice:54, receipt: 034 by Lausu Energy Resources','2022-09-27 16:13:13','',''),('8','212',262,'','supplier','1',0.00,331855.00,'Payment Id 56 for invoice:54, receipt: 034 by Lausu Energy Resources','2022-09-27 16:13:13','',''),('8','212',263,'','24','3',0.00,6270000.00,'Purchase Id 10 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-27 16:13:51','',''),('8','212',264,'','supplier','1',6270000.00,0.00,'Purchase Id 10 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-27 16:13:51','',''),('8','212',265,'','20','5',271375.10,0.00,'Sales from shift 57 on 2022-09-27 19:27:12 ','2022-09-27 19:27:12','',''),('8','212',266,'','6.1','1',0.00,271375.10,'Sales from shift 57 on 2022-09-27 19:27:12 ','2022-09-27 19:27:12','',''),('8','212',267,'','2','6',1931560.00,0.00,'Payment Id 57 for invoice:55, receipt: 035 by Lausu Energy Resources','2022-09-28 13:48:25','',''),('8','212',268,'','supplier','1',0.00,1931560.00,'Payment Id 57 for invoice:55, receipt: 035 by Lausu Energy Resources','2022-09-28 13:48:25','',''),('8','212',269,'','20','5',236563.30,0.00,'Sales from shift 58 on 2022-09-28 22:18:19 ','2022-09-28 22:18:19','',''),('8','212',270,'','6.1','1',0.00,236563.30,'Sales from shift 58 on 2022-09-28 22:18:19 ','2022-09-28 22:18:19','',''),('8','212',271,'','20','5',401278.10,0.00,'Sales from shift 59 on 2022-09-29 19:20:20 ','2022-09-29 19:20:20','',''),('8','212',272,'','6.1','1',0.00,401278.10,'Sales from shift 59 on 2022-09-29 19:20:20 ','2022-09-29 19:20:20','',''),('8','212',273,'','2','6',536870.00,0.00,'Payment Id 58 for invoice:56, receipt: 036 by Lausu Energy Resources','2022-09-29 21:11:24','',''),('8','212',274,'','supplier','1',0.00,536870.00,'Payment Id 58 for invoice:56, receipt: 036 by Lausu Energy Resources','2022-09-29 21:11:24','',''),('8','212',275,'','2','6',271375.00,0.00,'Payment Id 59 for invoice:57, receipt: 037 by Lausu Energy Resources','2022-09-29 21:12:53','',''),('8','212',276,'','supplier','1',0.00,271375.00,'Payment Id 59 for invoice:57, receipt: 037 by Lausu Energy Resources','2022-09-29 21:12:53','',''),('8','212',277,'','2','6',236565.00,0.00,'Payment Id 60 for invoice:58, receipt: 037 by Lausu Energy Resources','2022-09-29 21:13:26','',''),('8','212',278,'','supplier','1',0.00,236565.00,'Payment Id 60 for invoice:58, receipt: 037 by Lausu Energy Resources','2022-09-29 21:13:26','',''),('8','212',279,'','20','5',476518.10,0.00,'Sales from shift 60 on 2022-09-30 20:51:37 ','2022-09-30 20:51:37','',''),('8','212',280,'','6.1','1',0.00,476518.10,'Sales from shift 60 on 2022-09-30 20:51:37 ','2022-09-30 20:51:37','',''),('8','212',281,'','20','5',337244.30,0.00,'Sales from shift 61 on 2022-10-01 20:57:07 ','2022-10-01 20:57:07','',''),('8','212',282,'','6.1','1',0.00,337244.30,'Sales from shift 61 on 2022-10-01 20:57:07 ','2022-10-01 20:57:07','',''),('8','212',283,'','20','5',1011330.10,0.00,'Sales from shift 62 on 2022-10-02 19:16:05 ','2022-10-02 19:16:05','',''),('8','212',284,'','6.1','1',0.00,1011330.10,'Sales from shift 62 on 2022-10-02 19:16:05 ','2022-10-02 19:16:05','',''),('8','212',285,'','2','6',1011330.00,0.00,'Payment Id 64 for invoice:62, receipt: 041 by Lausu Energy Resources','2022-10-03 11:33:22','',''),('8','212',286,'','supplier','1',0.00,1011330.00,'Payment Id 64 for invoice:62, receipt: 041 by Lausu Energy Resources','2022-10-03 11:33:22','',''),('8','212',287,'','2','6',476520.00,0.00,'Payment Id 62 for invoice:60, receipt: 039 by Lausu Energy Resources','2022-10-03 11:33:22','',''),('8','212',288,'','supplier','1',0.00,476520.00,'Payment Id 62 for invoice:60, receipt: 039 by Lausu Energy Resources','2022-10-03 11:33:22','',''),('8','212',289,'','2','6',401280.00,0.00,'Payment Id 61 for invoice:59, receipt: 038 by Lausu Energy Resources','2022-10-03 11:33:22','',''),('8','212',290,'','supplier','1',0.00,401280.00,'Payment Id 61 for invoice:59, receipt: 038 by Lausu Energy Resources','2022-10-03 11:33:22','',''),('8','212',291,'','20','5',228932.90,0.00,'Sales from shift 63 on 2022-10-03 19:15:33 ','2022-10-03 19:15:33','',''),('8','212',292,'','6.1','1',0.00,228932.90,'Sales from shift 63 on 2022-10-03 19:15:33 ','2022-10-03 19:15:33','',''),('8','212',293,'','20','5',265236.20,0.00,'Sales from shift 64 on 2022-10-04 15:30:22 ','2022-10-04 15:30:22','',''),('8','212',294,'','6.1','1',0.00,265236.20,'Sales from shift 64 on 2022-10-04 15:30:22 ','2022-10-04 15:30:22','',''),('8','212',295,'','20','5',40105.20,0.00,'Sales from shift 65 on 2022-10-04 19:20:51 ','2022-10-04 19:20:51','',''),('8','212',296,'','6.1','1',0.00,40105.20,'Sales from shift 65 on 2022-10-04 19:20:51 ','2022-10-04 19:20:51','',''),('8','212',297,'','20','5',340645.30,0.00,'Sales from shift 66 on 2022-10-05 20:42:15 ','2022-10-05 20:42:15','',''),('8','212',298,'','6.1','1',0.00,340645.30,'Sales from shift 66 on 2022-10-05 20:42:15 ','2022-10-05 20:42:15','',''),('8','212',299,'','20','5',789898.40,0.00,'Sales from shift 67 on 2022-10-06 18:58:26 ','2022-10-06 18:58:26','',''),('8','212',300,'','6.1','1',0.00,789898.40,'Sales from shift 67 on 2022-10-06 18:58:26 ','2022-10-06 18:58:26','',''),('8','212',301,'','2','6',789900.00,0.00,'Payment Id 69 for invoice:67, receipt: 046 by Lausu Energy Resources','2022-10-07 13:48:37','',''),('8','212',302,'','supplier','1',0.00,789900.00,'Payment Id 69 for invoice:67, receipt: 046 by Lausu Energy Resources','2022-10-07 13:48:37','',''),('8','212',303,'','2','6',340645.00,0.00,'Payment Id 68 for invoice:66, receipt: 045 by Lausu Energy Resources','2022-10-07 13:48:37','',''),('8','212',304,'','supplier','1',0.00,340645.00,'Payment Id 68 for invoice:66, receipt: 045 by Lausu Energy Resources','2022-10-07 13:48:37','',''),('8','212',305,'','2','6',265235.00,0.00,'Payment Id 66 for invoice:64, receipt: 043 by Lausu Energy Resources','2022-10-07 13:48:37','',''),('8','212',306,'','supplier','1',0.00,265235.00,'Payment Id 66 for invoice:64, receipt: 043 by Lausu Energy Resources','2022-10-07 13:48:37','',''),('8','212',307,'','2','6',228930.00,0.00,'Payment Id 65 for invoice:63, receipt: 042 by Lausu Energy Resources','2022-10-07 13:49:38','',''),('8','212',308,'','supplier','1',0.00,228930.00,'Payment Id 65 for invoice:63, receipt: 042 by Lausu Energy Resources','2022-10-07 13:49:38','',''),('8','212',309,'','2','6',337245.00,0.00,'Payment Id 63 for invoice:61, receipt: 040 by Lausu Energy Resources','2022-10-07 13:49:38','',''),('8','212',310,'','supplier','1',0.00,337245.00,'Payment Id 63 for invoice:61, receipt: 040 by Lausu Energy Resources','2022-10-07 13:49:38','',''),('8','212',311,'','20','5',1347164.60,0.00,'Sales from shift 68 on 2022-10-07 19:24:44 ','2022-10-07 19:24:44','',''),('8','212',312,'','6.1','1',0.00,1347164.60,'Sales from shift 68 on 2022-10-07 19:24:44 ','2022-10-07 19:24:44','',''),('8','212',313,'','24','3',0.00,3256500.00,'Purchase Id 11 for 16,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-08 19:24:25','',''),('8','212',314,'','supplier','1',3256500.00,0.00,'Purchase Id 11 for 16,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-08 19:24:25','',''),('8','212',315,'','20','5',1231887.80,0.00,'Sales from shift 69 on 2022-10-08 21:53:33 ','2022-10-08 21:53:33','',''),('8','212',316,'','6.1','1',0.00,1231887.80,'Sales from shift 69 on 2022-10-08 21:53:33 ','2022-10-08 21:53:33','',''),('8','212',317,'','20','5',3219763.95,0.00,'Sales from shift 70 on 2022-10-10 09:34:37 ','2022-10-10 09:34:37','',''),('8','212',318,'','6.1','1',0.00,3219763.95,'Sales from shift 70 on 2022-10-10 09:34:37 ','2022-10-10 09:34:37','',''),('8','212',319,'','20','5',4990404.90,0.00,'Sales from shift 71 on 2022-10-10 22:14:28 ','2022-10-10 22:14:28','',''),('8','212',320,'','6.1','1',0.00,4990404.90,'Sales from shift 71 on 2022-10-10 22:14:28 ','2022-10-10 22:14:28','',''),('8','212',321,'','24','3',0.00,10300000.00,'Purchase Id 12 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-12 05:52:44','',''),('8','212',322,'','supplier','1',10300000.00,0.00,'Purchase Id 12 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-12 05:52:44','',''),('8','212',323,'','20','5',0.00,0.00,'Sales from shift 72 on 2022-10-12 07:27:10 ','2022-10-12 07:27:10','',''),('8','212',324,'','6.1','1',0.00,0.00,'Sales from shift 72 on 2022-10-12 07:27:10 ','2022-10-12 07:27:10','',''),('8','212',325,'','2','6',4990530.00,0.00,'Payment Id 73 for invoice:71, receipt: 050 by Lausu Energy Resources','2022-10-12 16:43:47','',''),('8','212',326,'','supplier','1',0.00,4990530.00,'Payment Id 73 for invoice:71, receipt: 050 by Lausu Energy Resources','2022-10-12 16:43:47','',''),('8','212',327,'','2','6',3219765.00,0.00,'Payment Id 72 for invoice:70, receipt: 049 by Lausu Energy Resources','2022-10-12 16:44:35','',''),('8','212',328,'','supplier','1',0.00,3219765.00,'Payment Id 72 for invoice:70, receipt: 049 by Lausu Energy Resources','2022-10-12 16:44:35','',''),('8','212',329,'','2','6',1347200.00,0.00,'Payment Id 70 for invoice:68, receipt: 047 by Lausu Energy Resources','2022-10-12 16:44:35','',''),('8','212',330,'','supplier','1',0.00,1347200.00,'Payment Id 70 for invoice:68, receipt: 047 by Lausu Energy Resources','2022-10-12 16:44:35','',''),('8','212',331,'','20','5',2915958.84,0.00,'Sales from shift 73 on 2022-10-12 18:50:59 ','2022-10-12 18:50:59','',''),('8','212',332,'','6.1','1',0.00,2915958.84,'Sales from shift 73 on 2022-10-12 18:50:59 ','2022-10-12 18:50:59','',''),('8','212',333,'','20','5',2222646.80,0.00,'Sales from shift 74 on 2022-10-12 20:18:19 ','2022-10-12 20:18:19','',''),('8','212',334,'','6.1','1',0.00,2222646.80,'Sales from shift 74 on 2022-10-12 20:18:19 ','2022-10-12 20:18:19','',''),('8','212',335,'','20','5',2965630.80,0.00,'Sales from shift 75 on 2022-10-13 20:01:07 ','2022-10-13 20:01:07','',''),('8','212',336,'','6.1','1',0.00,2965630.80,'Sales from shift 75 on 2022-10-13 20:01:07 ','2022-10-13 20:01:07','',''),('8','212',337,'','20','5',2010509.60,0.00,'Sales from shift 76 on 2022-10-14 22:51:56 ','2022-10-14 22:51:56','',''),('8','212',338,'','6.1','1',0.00,2010509.60,'Sales from shift 76 on 2022-10-14 22:51:56 ','2022-10-14 22:51:56','',''),('8','212',339,'','24','3',0.00,3825000.00,'Purchase Id 13 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-15 19:52:02','',''),('8','212',340,'','supplier','1',3825000.00,0.00,'Purchase Id 13 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-15 19:52:02','',''),('8','212',341,'','20','5',0.00,0.00,'Sales from shift 77 on 2022-10-16 21:34:38 ','2022-10-16 21:34:38','',''),('8','212',342,'','6.1','1',0.00,0.00,'Sales from shift 77 on 2022-10-16 21:34:38 ','2022-10-16 21:34:38','',''),('8','212',343,'','2','6',2222650.00,0.00,'Payment Id 75 for invoice:74, receipt: 052 by Lausu Energy Resources','2022-10-17 14:27:37','',''),('8','212',344,'','supplier','1',0.00,2222650.00,'Payment Id 75 for invoice:74, receipt: 052 by Lausu Energy Resources','2022-10-17 14:27:37','',''),('8','212',345,'','2','6',2915960.00,0.00,'Payment Id 74 for invoice:73, receipt: 051 by Lausu Energy Resources','2022-10-17 14:27:37','',''),('8','212',346,'','supplier','1',0.00,2915960.00,'Payment Id 74 for invoice:73, receipt: 051 by Lausu Energy Resources','2022-10-17 14:27:37','',''),('8','212',347,'','24','3',0.00,7200000.00,'Purchase Id 14 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-19 22:36:48','',''),('8','212',348,'','supplier','1',7200000.00,0.00,'Purchase Id 14 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-19 22:36:48','',''),('8','212',349,'','20','5',1529804.25,0.00,'Sales from shift 78 on 2022-10-20 13:28:43 ','2022-10-20 13:28:43','',''),('8','212',350,'','6.1','1',0.00,1529804.25,'Sales from shift 78 on 2022-10-20 13:28:43 ','2022-10-20 13:28:43','',''),('8','212',351,'','20','5',2646258.75,0.00,'Sales from shift 79 on 2022-10-20 13:36:49 ','2022-10-20 13:36:49','',''),('8','212',352,'','6.1','1',0.00,2646258.75,'Sales from shift 79 on 2022-10-20 13:36:49 ','2022-10-20 13:36:49','',''),('8','212',353,'','20','5',1287094.50,0.00,'Sales from shift 80 on 2022-10-20 13:58:00 ','2022-10-20 13:58:00','',''),('8','212',354,'','6.1','1',0.00,1287094.50,'Sales from shift 80 on 2022-10-20 13:58:00 ','2022-10-20 13:58:00','',''),('8','212',355,'','2','6',2646260.00,0.00,'Payment Id 79 for invoice:79, receipt: 056 by Lausu Energy Resources','2022-10-20 14:14:23','',''),('8','212',356,'','supplier','1',0.00,2646260.00,'Payment Id 79 for invoice:79, receipt: 056 by Lausu Energy Resources','2022-10-20 14:14:23','',''),('8','212',357,'','20','5',2204814.50,0.00,'Sales from shift 81 on 2022-10-20 18:54:30 ','2022-10-20 18:54:30','',''),('8','212',358,'','6.1','1',0.00,2204814.50,'Sales from shift 81 on 2022-10-20 18:54:30 ','2022-10-20 18:54:30','',''),('8','212',359,'','20','5',1273040.80,0.00,'Sales from shift 82 on 2022-10-21 19:24:27 ','2022-10-21 19:24:27','',''),('8','212',360,'','6.1','1',0.00,1273040.80,'Sales from shift 82 on 2022-10-21 19:24:27 ','2022-10-21 19:24:27','',''),('8','212',361,'','20','5',1124827.50,0.00,'Sales from shift 83 on 2022-10-22 20:33:29 ','2022-10-22 20:33:29','',''),('8','212',362,'','6.1','1',0.00,1124827.50,'Sales from shift 83 on 2022-10-22 20:33:29 ','2022-10-22 20:33:29','',''),('8','212',363,'','20','5',1886894.90,0.00,'Sales from shift 84 on 2022-10-23 18:33:19 ','2022-10-23 18:33:19','',''),('8','212',364,'','6.1','1',0.00,1886894.90,'Sales from shift 84 on 2022-10-23 18:33:19 ','2022-10-23 18:33:19','',''),('8','212',365,'','2','6',1886895.00,0.00,'Payment Id 84 for invoice:84, receipt: 061 by Lausu Energy Resources','2022-10-24 15:00:49','',''),('8','212',366,'','supplier','1',0.00,1886895.00,'Payment Id 84 for invoice:84, receipt: 061 by Lausu Energy Resources','2022-10-24 15:00:49','',''),('8','212',367,'','2','6',1124830.00,0.00,'Payment Id 83 for invoice:83, receipt: 060 by Lausu Energy Resources','2022-10-24 15:00:49','',''),('8','212',368,'','supplier','1',0.00,1124830.00,'Payment Id 83 for invoice:83, receipt: 060 by Lausu Energy Resources','2022-10-24 15:00:49','',''),('8','212',369,'','2','6',1273040.00,0.00,'Payment Id 82 for invoice:82, receipt: 059 by Lausu Energy Resources','2022-10-24 15:00:49','',''),('8','212',370,'','supplier','1',0.00,1273040.00,'Payment Id 82 for invoice:82, receipt: 059 by Lausu Energy Resources','2022-10-24 15:00:49','',''),('8','212',371,'','2','6',1287095.00,0.00,'Payment Id 80 for invoice:80, receipt: 057 by Lausu Energy Resources','2022-10-24 15:00:49','',''),('8','212',372,'','supplier','1',0.00,1287095.00,'Payment Id 80 for invoice:80, receipt: 057 by Lausu Energy Resources','2022-10-24 15:00:49','',''),('8','212',373,'','2','6',1529805.00,0.00,'Payment Id 78 for invoice:78, receipt: 055 by Lausu Energy Resources','2022-10-24 21:55:51','',''),('8','212',374,'','supplier','1',0.00,1529805.00,'Payment Id 78 for invoice:78, receipt: 055 by Lausu Energy Resources','2022-10-24 21:55:51','',''),('8','212',375,'','24','3',0.00,7755000.00,'Purchase Id 16 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-25 05:42:27','',''),('8','212',376,'','supplier','1',7755000.00,0.00,'Purchase Id 16 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-25 05:42:27','',''),('8','212',377,'','20','5',886826.55,0.00,'Sales from shift 85 on 2022-10-25 11:14:09 ','2022-10-25 11:14:09','',''),('8','212',378,'','6.1','1',0.00,886826.55,'Sales from shift 85 on 2022-10-25 11:14:09 ','2022-10-25 11:14:09','',''),('8','212',379,'','20','5',2358434.15,0.00,'Sales from shift 86 on 2022-10-25 20:15:54 ','2022-10-25 20:15:54','',''),('8','212',380,'','6.1','1',0.00,2358434.15,'Sales from shift 86 on 2022-10-25 20:15:54 ','2022-10-25 20:15:54','',''),('8','212',381,'','20','5',0.00,0.00,'Sales from shift 87 on 2022-10-27 05:20:31 ','2022-10-27 05:20:31','',''),('8','212',382,'','6.1','1',0.00,0.00,'Sales from shift 87 on 2022-10-27 05:20:31 ','2022-10-27 05:20:31','',''),('8','212',383,'','20','5',929680.00,0.00,'Sales from shift 88 on 2022-10-27 05:23:43 ','2022-10-27 05:23:43','',''),('8','212',384,'','6.1','1',0.00,929680.00,'Sales from shift 88 on 2022-10-27 05:23:43 ','2022-10-27 05:23:43','',''),('8','212',385,'','2','6',929680.00,0.00,'Payment Id 87 for invoice:88, receipt: 064 by Lausu Energy Resources','2022-10-27 10:35:27','',''),('8','212',386,'','supplier','1',0.00,929680.00,'Payment Id 87 for invoice:88, receipt: 064 by Lausu Energy Resources','2022-10-27 10:35:27','',''),('8','212',387,'','2','6',2358435.00,0.00,'Payment Id 86 for invoice:86, receipt: 063 by Lausu Energy Resources','2022-10-27 10:35:27','',''),('8','212',388,'','supplier','1',0.00,2358435.00,'Payment Id 86 for invoice:86, receipt: 063 by Lausu Energy Resources','2022-10-27 10:35:27','',''),('8','212',389,'','2','6',886830.00,0.00,'Payment Id 85 for invoice:85, receipt: 062 by Lausu Energy Resources','2022-10-27 10:35:27','',''),('8','212',390,'','supplier','1',0.00,886830.00,'Payment Id 85 for invoice:85, receipt: 062 by Lausu Energy Resources','2022-10-27 10:35:27','',''),('8','212',391,'','20','5',1280637.50,0.00,'Sales from shift 89 on 2022-10-28 07:46:46 ','2022-10-28 07:46:46','',''),('8','212',392,'','6.1','1',0.00,1280637.50,'Sales from shift 89 on 2022-10-28 07:46:46 ','2022-10-28 07:46:46','',''),('8','212',393,'','20','5',1862450.00,0.00,'Sales from shift 90 on 2022-10-28 19:57:02 ','2022-10-28 19:57:02','',''),('8','212',394,'','6.1','1',0.00,1862450.00,'Sales from shift 90 on 2022-10-28 19:57:02 ','2022-10-28 19:57:02','',''),('8','212',395,'','2','6',1280640.00,0.00,'Payment Id 88 for invoice:89, receipt: 065 by Lausu Energy Resources','2022-10-31 17:46:45','',''),('8','212',396,'','supplier','1',0.00,1280640.00,'Payment Id 88 for invoice:89, receipt: 065 by Lausu Energy Resources','2022-10-31 17:46:45','',''),('8','212',397,'','2','6',1862450.00,0.00,'Payment Id 89 for invoice:90, receipt: 066 by Lausu Energy Resources','2022-10-31 17:48:04','',''),('8','212',398,'','supplier','1',0.00,1862450.00,'Payment Id 89 for invoice:90, receipt: 066 by Lausu Energy Resources','2022-10-31 17:48:04','',''),('8','212',399,'','2','6',40105.00,0.00,'Payment Id 67 for invoice:65, receipt: 044 by Lausu Energy Resources','2022-10-31 17:52:13','',''),('8','212',400,'','supplier','1',0.00,40105.00,'Payment Id 67 for invoice:65, receipt: 044 by Lausu Energy Resources','2022-10-31 17:52:13','',''),('8','212',401,'','2','6',2204815.00,0.00,'Payment Id 81 for invoice:81, receipt: 058 by Lausu Energy Resources','2022-11-02 13:39:42','',''),('8','212',402,'','supplier','1',0.00,2204815.00,'Payment Id 81 for invoice:81, receipt: 058 by Lausu Energy Resources','2022-11-02 13:39:42','',''),('8','212',403,'','2','6',1264290.00,0.00,'Payment Id 71 for invoice:69, receipt: 048 by Lausu Energy Resources','2022-11-02 14:11:30','',''),('8','212',404,'','supplier','1',0.00,1264290.00,'Payment Id 71 for invoice:69, receipt: 048 by Lausu Energy Resources','2022-11-02 14:11:30','',''),('8','212',405,'','24','3',0.00,8415000.00,'Purchase Id 17 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-04 11:10:07','',''),('8','212',406,'','supplier','1',8415000.00,0.00,'Purchase Id 17 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-04 11:10:07','',''),('8','212',407,'','20','5',1374487.50,0.00,'Sales from shift 91 on 2022-11-04 20:41:08 ','2022-11-04 20:41:08','',''),('8','212',408,'','6.1','1',0.00,1374487.50,'Sales from shift 91 on 2022-11-04 20:41:08 ','2022-11-04 20:41:08','',''),('8','212',409,'','24','3',0.00,4335000.00,'Purchase Id 18 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-04 22:45:46','',''),('8','212',410,'','supplier','1',4335000.00,0.00,'Purchase Id 18 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-04 22:45:46','',''),('8','212',411,'','20','5',478020.45,0.00,'Sales from shift 92 on 2022-11-05 18:29:33 ','2022-11-05 18:29:33','',''),('8','212',412,'','6.1','1',0.00,478020.45,'Sales from shift 92 on 2022-11-05 18:29:33 ','2022-11-05 18:29:33','',''),('8','212',413,'','20','5',688500.00,0.00,'Sales from shift 93 on 2022-11-06 21:19:31 ','2022-11-06 21:19:31','',''),('8','212',414,'','6.1','1',0.00,688500.00,'Sales from shift 93 on 2022-11-06 21:19:31 ','2022-11-06 21:19:31','',''),('8','212',415,'','20','5',2098722.50,0.00,'Sales from shift 94 on 2022-11-06 21:28:32 ','2022-11-06 21:28:32','',''),('8','212',416,'','6.1','1',0.00,2098722.50,'Sales from shift 94 on 2022-11-06 21:28:32 ','2022-11-06 21:28:32','',''),('8','212',417,'','2','6',2098725.00,0.00,'Payment Id 96 for invoice:94, receipt: 073 by Lausu Energy Resources','2022-11-07 12:22:00','',''),('8','212',418,'','supplier','1',0.00,2098725.00,'Payment Id 96 for invoice:94, receipt: 073 by Lausu Energy Resources','2022-11-07 12:22:00','',''),('8','212',419,'','2','6',688500.00,0.00,'Payment Id 95 for invoice:93, receipt: 072 by Lausu Energy Resources','2022-11-07 12:22:00','',''),('8','212',420,'','supplier','1',0.00,688500.00,'Payment Id 95 for invoice:93, receipt: 072 by Lausu Energy Resources','2022-11-07 12:22:00','',''),('8','212',421,'','2','6',478020.00,0.00,'Payment Id 94 for invoice:92, receipt: 071 by Lausu Energy Resources','2022-11-07 12:22:00','',''),('8','212',422,'','supplier','1',0.00,478020.00,'Payment Id 94 for invoice:92, receipt: 071 by Lausu Energy Resources','2022-11-07 12:22:00','',''),('8','212',423,'','20','5',1308097.50,0.00,'Sales from shift 95 on 2022-11-07 21:30:49 ','2022-11-07 21:30:49','',''),('8','212',424,'','6.1','1',0.00,1308097.50,'Sales from shift 95 on 2022-11-07 21:30:49 ','2022-11-07 21:30:49','',''),('8','212',425,'','20','5',1504165.00,0.00,'Sales from shift 96 on 2022-11-08 20:49:52 ','2022-11-08 20:49:52','',''),('8','212',426,'','6.1','1',0.00,1504165.00,'Sales from shift 96 on 2022-11-08 20:49:52 ','2022-11-08 20:49:52','',''),('8','212',427,'','2','6',1504165.00,0.00,'Payment Id 98 for invoice:96, receipt: 075 by Lausu Energy Resources','2022-11-09 13:01:06','',''),('8','212',428,'','supplier','1',0.00,1504165.00,'Payment Id 98 for invoice:96, receipt: 075 by Lausu Energy Resources','2022-11-09 13:01:06','',''),('8','212',429,'','2','6',1308100.00,0.00,'Payment Id 97 for invoice:95, receipt: 074 by Lausu Energy Resources','2022-11-09 13:01:06','',''),('8','212',430,'','supplier','1',0.00,1308100.00,'Payment Id 97 for invoice:95, receipt: 074 by Lausu Energy Resources','2022-11-09 13:01:06','',''),('8','212',431,'','2','6',1347200.00,0.00,'Payment Id 91 for invoice:91, receipt: 068 by Lausu Energy Resources','2022-11-09 13:03:20','',''),('8','212',432,'','supplier','1',0.00,1347200.00,'Payment Id 91 for invoice:91, receipt: 068 by Lausu Energy Resources','2022-11-09 13:03:20','',''),('8','212',433,'','2','6',2044955.00,0.00,'Payment Id 90 for invoice:91, receipt: 067 by Lausu Energy Resources','2022-11-09 13:03:20','',''),('8','212',434,'','supplier','1',0.00,2044955.00,'Payment Id 90 for invoice:91, receipt: 067 by Lausu Energy Resources','2022-11-09 13:03:20','',''),('8','212',435,'','2','6',1374200.00,0.00,'Payment Id 93 for invoice:91, receipt: 070 by Lausu Energy Resources','2022-11-09 13:06:16','',''),('8','212',436,'','supplier','1',0.00,1374200.00,'Payment Id 93 for invoice:91, receipt: 070 by Lausu Energy Resources','2022-11-09 13:06:16','',''),('8','212',437,'','2','6',2850330.00,0.00,'Payment Id 92 for invoice:91, receipt: 069 by Lausu Energy Resources','2022-11-09 13:06:45','',''),('8','212',438,'','supplier','1',0.00,2850330.00,'Payment Id 92 for invoice:91, receipt: 069 by Lausu Energy Resources','2022-11-09 13:06:45','',''),('8','212',439,'','20','5',1786335.00,0.00,'Sales from shift 97 on 2022-11-09 19:10:45 ','2022-11-09 19:10:45','',''),('8','212',440,'','6.1','1',0.00,1786335.00,'Sales from shift 97 on 2022-11-09 19:10:45 ','2022-11-09 19:10:45','',''),('8','212',441,'','20','5',1773220.00,0.00,'Sales from shift 98 on 2022-11-10 18:45:02 ','2022-11-10 18:45:02','',''),('8','212',442,'','6.1','1',0.00,1773220.00,'Sales from shift 98 on 2022-11-10 18:45:02 ','2022-11-10 18:45:02','',''),('8','212',443,'','20','5',1671802.50,0.00,'Sales from shift 99 on 2022-11-11 19:24:13 ','2022-11-11 19:24:13','',''),('8','212',444,'','6.1','1',0.00,1671802.50,'Sales from shift 99 on 2022-11-11 19:24:13 ','2022-11-11 19:24:13','',''),('8','212',445,'','24','3',0.00,4175000.00,'Purchase Id 19 for 16,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-12 15:38:54','',''),('8','212',446,'','supplier','1',4175000.00,0.00,'Purchase Id 19 for 16,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-12 15:38:54','',''),('8','212',447,'','20','5',2025752.50,0.00,'Sales from shift 100 on 2022-11-12 18:39:44 ','2022-11-12 18:39:44','',''),('8','212',448,'','6.1','1',0.00,2025752.50,'Sales from shift 100 on 2022-11-12 18:39:44 ','2022-11-12 18:39:44','',''),('8','212',449,'','24','3',0.00,4335000.00,'Purchase Id 20 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-15 11:44:14','',''),('8','212',450,'','supplier','1',4335000.00,0.00,'Purchase Id 20 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-15 11:44:14','',''),('8','212',451,'','20','5',1644081.90,0.00,'Sales from shift 101 on 2022-11-15 20:23:24 ','2022-11-15 20:23:24','',''),('8','212',452,'','6.1','1',0.00,1644081.90,'Sales from shift 101 on 2022-11-15 20:23:24 ','2022-11-15 20:23:24','',''),('8','212',453,'','20','5',780279.60,0.00,'Sales from shift 102 on 2022-11-15 20:32:37 ','2022-11-15 20:32:37','',''),('8','212',454,'','6.1','1',0.00,780279.60,'Sales from shift 102 on 2022-11-15 20:32:37 ','2022-11-15 20:32:37','',''),('8','212',455,'','20','5',1462386.75,0.00,'Sales from shift 103 on 2022-11-15 20:38:39 ','2022-11-15 20:38:39','',''),('8','212',456,'','6.1','1',0.00,1462386.75,'Sales from shift 103 on 2022-11-15 20:38:39 ','2022-11-15 20:38:39','',''),('8','212',457,'','2','6',780280.00,0.00,'Payment Id 104 for invoice:102, receipt: 081 by Lausu Energy Resources','2022-11-16 16:43:08','',''),('8','212',458,'','supplier','1',0.00,780280.00,'Payment Id 104 for invoice:102, receipt: 081 by Lausu Energy Resources','2022-11-16 16:43:08','',''),('8','212',459,'','2','6',1644080.00,0.00,'Payment Id 103 for invoice:101, receipt: 080 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',460,'','supplier','1',0.00,1644080.00,'Payment Id 103 for invoice:101, receipt: 080 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',461,'','2','6',2025755.00,0.00,'Payment Id 102 for invoice:100, receipt: 079 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',462,'','supplier','1',0.00,2025755.00,'Payment Id 102 for invoice:100, receipt: 079 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',463,'','2','6',1671805.00,0.00,'Payment Id 101 for invoice:99, receipt: 078 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',464,'','supplier','1',0.00,1671805.00,'Payment Id 101 for invoice:99, receipt: 078 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',465,'','2','6',1773220.00,0.00,'Payment Id 100 for invoice:98, receipt: 077 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',466,'','supplier','1',0.00,1773220.00,'Payment Id 100 for invoice:98, receipt: 077 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',467,'','2','6',1786335.00,0.00,'Payment Id 99 for invoice:97, receipt: 076 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',468,'','supplier','1',0.00,1786335.00,'Payment Id 99 for invoice:97, receipt: 076 by Lausu Energy Resources','2022-11-16 16:43:09','',''),('8','212',469,'','24','3',0.00,4335000.00,'Purchase Id 21 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-17 11:15:04','',''),('8','212',470,'','supplier','1',4335000.00,0.00,'Purchase Id 21 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-17 11:15:04','',''),('8','212',471,'','20','5',1406837.55,0.00,'Sales from shift 104 on 2022-11-17 13:01:34 ','2022-11-17 13:01:34','',''),('8','212',472,'','6.1','1',0.00,1406837.55,'Sales from shift 104 on 2022-11-17 13:01:34 ','2022-11-17 13:01:34','',''),('8','212',473,'','20','5',1579046.70,0.00,'Sales from shift 105 on 2022-11-18 12:16:58 ','2022-11-18 12:16:58','',''),('8','212',474,'','6.1','1',0.00,1579046.70,'Sales from shift 105 on 2022-11-18 12:16:58 ','2022-11-18 12:16:58','',''),('8','212',475,'','20','5',1858442.55,0.00,'Sales from shift 106 on 2022-11-18 19:02:44 ','2022-11-18 19:02:44','',''),('8','212',476,'','6.1','1',0.00,1858442.55,'Sales from shift 106 on 2022-11-18 19:02:44 ','2022-11-18 19:02:44','',''),('8','212',477,'','2','6',1406845.00,0.00,'Payment Id 106 for invoice:104, receipt: 083 by Lausu Energy Resources','2022-11-19 05:59:35','',''),('8','212',478,'','supplier','1',0.00,1406845.00,'Payment Id 106 for invoice:104, receipt: 083 by Lausu Energy Resources','2022-11-19 05:59:35','',''),('8','212',479,'','20','5',1376199.30,0.00,'Sales from shift 107 on 2022-11-20 06:56:11 ','2022-11-20 06:56:11','',''),('8','212',480,'','6.1','1',0.00,1376199.30,'Sales from shift 107 on 2022-11-20 06:56:11 ','2022-11-20 06:56:11','',''),('8','212',481,'','20','5',2126707.65,0.00,'Sales from shift 108 on 2022-11-20 19:54:19 ','2022-11-20 19:54:19','',''),('8','212',482,'','6.1','1',0.00,2126707.65,'Sales from shift 108 on 2022-11-20 19:54:19 ','2022-11-20 19:54:19','',''),('8','212',483,'','2','6',1376200.00,0.00,'Payment Id 109 for invoice:107, receipt: 086 by Lausu Energy Resources','2022-11-21 14:46:34','',''),('8','212',484,'','supplier','1',0.00,1376200.00,'Payment Id 109 for invoice:107, receipt: 086 by Lausu Energy Resources','2022-11-21 14:46:34','',''),('8','212',485,'','2','6',1858445.00,0.00,'Payment Id 108 for invoice:106, receipt: 085 by Lausu Energy Resources','2022-11-21 14:46:34','',''),('8','212',486,'','supplier','1',0.00,1858445.00,'Payment Id 108 for invoice:106, receipt: 085 by Lausu Energy Resources','2022-11-21 14:46:34','',''),('8','212',487,'','2','6',1579050.00,0.00,'Payment Id 107 for invoice:105, receipt: 084 by Lausu Energy Resources','2022-11-21 14:46:34','',''),('8','212',488,'','supplier','1',0.00,1579050.00,'Payment Id 107 for invoice:105, receipt: 084 by Lausu Energy Resources','2022-11-21 14:46:34','',''),('8','212',489,'','2','6',1462390.00,0.00,'Payment Id 105 for invoice:103, receipt: 082 by Lausu Energy Resources','2022-11-21 15:21:22','',''),('8','212',490,'','supplier','1',0.00,1462390.00,'Payment Id 105 for invoice:103, receipt: 082 by Lausu Energy Resources','2022-11-21 15:21:22','',''),('8','212',491,'','24','3',0.00,8415000.00,'Purchase Id 22 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-22 20:36:40','',''),('8','212',492,'','supplier','1',8415000.00,0.00,'Purchase Id 22 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-22 20:36:40','',''),('8','212',493,'','20','5',208521.15,0.00,'Sales from shift 109 on 2022-11-22 21:14:37 ','2022-11-22 21:14:37','',''),('8','212',494,'','6.1','1',0.00,208521.15,'Sales from shift 109 on 2022-11-22 21:14:37 ','2022-11-22 21:14:37','',''),('8','212',495,'','20','5',849259.65,0.00,'Sales from shift 110 on 2022-11-23 08:02:27 ','2022-11-23 08:02:27','',''),('8','212',496,'','6.1','1',0.00,849259.65,'Sales from shift 110 on 2022-11-23 08:02:27 ','2022-11-23 08:02:27','',''),('8','212',497,'','20','5',1318413.75,0.00,'Sales from shift 111 on 2022-11-24 07:41:34 ','2022-11-24 07:41:34','',''),('8','212',498,'','6.1','1',0.00,1318413.75,'Sales from shift 111 on 2022-11-24 07:41:34 ','2022-11-24 07:41:34','',''),('8','212',499,'','2','6',849260.00,0.00,'Payment Id 112 for invoice:110, receipt: 089 by Lausu Energy Resources','2022-11-24 13:51:44','',''),('8','212',500,'','supplier','1',0.00,849260.00,'Payment Id 112 for invoice:110, receipt: 089 by Lausu Energy Resources','2022-11-24 13:51:44','',''),('8','212',501,'','2','6',208520.00,0.00,'Payment Id 111 for invoice:109, receipt: 088 by Lausu Energy Resources','2022-11-24 13:52:03','',''),('8','212',502,'','supplier','1',0.00,208520.00,'Payment Id 111 for invoice:109, receipt: 088 by Lausu Energy Resources','2022-11-24 13:52:03','',''),('8','212',503,'','2','6',2126710.00,0.00,'Payment Id 110 for invoice:108, receipt: 087 by Lausu Energy Resources','2022-11-24 13:52:35','',''),('8','212',504,'','supplier','1',0.00,2126710.00,'Payment Id 110 for invoice:108, receipt: 087 by Lausu Energy Resources','2022-11-24 13:52:35','',''),('8','212',505,'','20','5',1639764.75,0.00,'Sales from shift 112 on 2022-11-25 09:34:10 ','2022-11-25 09:34:10','',''),('8','212',506,'','6.1','1',0.00,1639764.75,'Sales from shift 112 on 2022-11-25 09:34:10 ','2022-11-25 09:34:10','',''),('8','212',507,'','2','6',1639765.00,0.00,'Payment Id 114 for invoice:112, receipt: 091 by Lausu Energy Resources','2022-11-25 17:51:39','',''),('8','212',508,'','supplier','1',0.00,1639765.00,'Payment Id 114 for invoice:112, receipt: 091 by Lausu Energy Resources','2022-11-25 17:51:39','',''),('8','212',509,'','2','6',1318415.00,0.00,'Payment Id 113 for invoice:111, receipt: 090 by Lausu Energy Resources','2022-11-25 17:51:39','',''),('8','212',510,'','supplier','1',0.00,1318415.00,'Payment Id 113 for invoice:111, receipt: 090 by Lausu Energy Resources','2022-11-25 17:51:39','',''),('8','212',511,'','20','5',1468851.00,0.00,'Sales from shift 113 on 2022-11-25 19:00:55 ','2022-11-25 19:00:55','',''),('8','212',512,'','6.1','1',0.00,1468851.00,'Sales from shift 113 on 2022-11-25 19:00:55 ','2022-11-25 19:00:55','',''),('8','212',513,'','20','5',701760.80,0.00,'Sales from shift 114 on 2022-11-27 08:37:57 ','2022-11-27 08:37:57','',''),('8','212',514,'','6.1','1',0.00,701760.80,'Sales from shift 114 on 2022-11-27 08:37:57 ','2022-11-27 08:37:57','',''),('8','212',515,'','20','5',2136035.20,0.00,'Sales from shift 115 on 2022-11-27 18:39:46 ','2022-11-27 18:39:46','',''),('8','212',516,'','6.1','1',0.00,2136035.20,'Sales from shift 115 on 2022-11-27 18:39:46 ','2022-11-27 18:39:46','',''),('8','212',517,'','2','6',2136035.00,0.00,'Payment Id 117 for invoice:115, receipt: 094 by Lausu Energy Resources','2022-11-28 16:18:54','',''),('8','212',518,'','supplier','1',0.00,2136035.00,'Payment Id 117 for invoice:115, receipt: 094 by Lausu Energy Resources','2022-11-28 16:18:54','',''),('8','212',519,'','2','6',701760.00,0.00,'Payment Id 116 for invoice:114, receipt: 093 by Lausu Energy Resources','2022-11-28 16:18:54','',''),('8','212',520,'','supplier','1',0.00,701760.00,'Payment Id 116 for invoice:114, receipt: 093 by Lausu Energy Resources','2022-11-28 16:18:54','',''),('8','212',521,'','2','6',1468850.00,0.00,'Payment Id 115 for invoice:113, receipt: 092 by Lausu Energy Resources','2022-11-28 16:18:54','',''),('8','212',522,'','supplier','1',0.00,1468850.00,'Payment Id 115 for invoice:113, receipt: 092 by Lausu Energy Resources','2022-11-28 16:18:54','',''),('8','212',523,'','24','3',0.00,8320000.00,'Purchase Id 23 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-01 10:55:42','',''),('8','212',524,'','supplier','1',8320000.00,0.00,'Purchase Id 23 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-01 10:55:42','',''),('8','212',525,'','24','3',0.00,270000.00,'Purchase Id 25 for 1,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-03 14:40:01','',''),('8','212',526,'','supplier','1',270000.00,0.00,'Purchase Id 25 for 1,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-03 14:40:01','',''),('8','212',527,'','20','5',328177.20,0.00,'Sales from shift 116 on 2022-12-03 14:48:08 ','2022-12-03 14:48:08','',''),('8','212',528,'','6.1','1',0.00,328177.20,'Sales from shift 116 on 2022-12-03 14:48:08 ','2022-12-03 14:48:08','',''),('8','212',529,'','20','5',1535214.20,0.00,'Sales from shift 117 on 2022-12-03 14:54:47 ','2022-12-03 14:54:47','',''),('8','212',530,'','6.1','1',0.00,1535214.20,'Sales from shift 117 on 2022-12-03 14:54:47 ','2022-12-03 14:54:47','',''),('8','212',531,'','20','5',3579516.20,0.00,'Sales from shift 118 on 2022-12-03 15:00:25 ','2022-12-03 15:00:25','',''),('8','212',532,'','6.1','1',0.00,3579516.20,'Sales from shift 118 on 2022-12-03 15:00:25 ','2022-12-03 15:00:25','',''),('8','212',533,'','20','5',1083712.50,0.00,'Sales from shift 119 on 2022-12-03 18:56:37 ','2022-12-03 18:56:37','',''),('8','212',534,'','6.1','1',0.00,1083712.50,'Sales from shift 119 on 2022-12-03 18:56:37 ','2022-12-03 18:56:37','',''),('8','212',535,'','20','5',1718236.80,0.00,'Sales from shift 120 on 2022-12-05 10:12:01 ','2022-12-05 10:12:01','',''),('8','212',536,'','6.1','1',0.00,1718236.80,'Sales from shift 120 on 2022-12-05 10:12:01 ','2022-12-05 10:12:01','',''),('8','212',537,'','2','6',1535140.00,0.00,'Payment Id 119 for invoice:117, receipt: 096 by Lausu Energy Resources','2022-12-05 13:18:43','',''),('8','212',538,'','supplier','1',0.00,1535140.00,'Payment Id 119 for invoice:117, receipt: 096 by Lausu Energy Resources','2022-12-05 13:18:43','',''),('8','212',539,'','2','6',328255.00,0.00,'Payment Id 118 for invoice:116, receipt: 095 by Lausu Energy Resources','2022-12-05 13:18:43','',''),('8','212',540,'','supplier','1',0.00,328255.00,'Payment Id 118 for invoice:116, receipt: 095 by Lausu Energy Resources','2022-12-05 13:18:43','',''),('8','212',541,'','2','6',1083715.00,0.00,'Payment Id 121 for invoice:119, receipt: 098 by Lausu Energy Resources','2022-12-05 13:19:27','',''),('8','212',542,'','supplier','1',0.00,1083715.00,'Payment Id 121 for invoice:119, receipt: 098 by Lausu Energy Resources','2022-12-05 13:19:27','',''),('8','212',543,'','2','6',3579520.00,0.00,'Payment Id 120 for invoice:118, receipt: 097 by Lausu Energy Resources','2022-12-05 13:19:27','',''),('8','212',544,'','supplier','1',0.00,3579520.00,'Payment Id 120 for invoice:118, receipt: 097 by Lausu Energy Resources','2022-12-05 13:19:27','',''),('8','212',545,'','20','5',491421.60,0.00,'Sales from shift 121 on 2022-12-06 06:03:44 ','2022-12-06 06:03:44','',''),('8','212',546,'','6.1','1',0.00,491421.60,'Sales from shift 121 on 2022-12-06 06:03:44 ','2022-12-06 06:03:44','',''),('8','212',547,'','24','3',0.00,4320000.00,'Purchase Id 26 for 16,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-06 10:23:17','',''),('8','212',548,'','supplier','1',4320000.00,0.00,'Purchase Id 26 for 16,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-06 10:23:17','',''),('8','212',549,'','20','5',2305959.30,0.00,'Sales from shift 122 on 2022-12-06 20:02:39 ','2022-12-06 20:02:39','',''),('8','212',550,'','6.1','1',0.00,2305959.30,'Sales from shift 122 on 2022-12-06 20:02:39 ','2022-12-06 20:02:39','',''),('8','212',551,'','20','5',2119063.85,0.00,'Sales from shift 123 on 2022-12-07 22:04:35 ','2022-12-07 22:04:35','',''),('8','212',552,'','6.1','1',0.00,2119063.85,'Sales from shift 123 on 2022-12-07 22:04:35 ','2022-12-07 22:04:35','',''),('8','212',553,'','2','6',1718240.00,0.00,'Payment Id 122 for invoice:120, receipt: 099 by Lausu Energy Resources','2022-12-08 17:03:16','',''),('8','212',554,'','supplier','1',0.00,1718240.00,'Payment Id 122 for invoice:120, receipt: 099 by Lausu Energy Resources','2022-12-08 17:03:16','',''),('8','212',555,'','2','6',491420.00,0.00,'Payment Id 123 for invoice:121, receipt: 100 by Lausu Energy Resources','2022-12-08 17:03:31','',''),('8','212',556,'','supplier','1',0.00,491420.00,'Payment Id 123 for invoice:121, receipt: 100 by Lausu Energy Resources','2022-12-08 17:03:31','',''),('8','212',557,'','2','6',2305960.00,0.00,'Payment Id 124 for invoice:122, receipt: 101 by Lausu Energy Resources','2022-12-08 17:04:07','',''),('8','212',558,'','supplier','1',0.00,2305960.00,'Payment Id 124 for invoice:122, receipt: 101 by Lausu Energy Resources','2022-12-08 17:04:07','',''),('8','212',559,'','24','3',0.00,13587750.00,'Purchase Id 27 for 44,550.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-15 08:39:10','',''),('8','212',560,'','supplier','1',13587750.00,0.00,'Purchase Id 27 for 44,550.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-15 08:39:10','',''),('8','212',561,'','20','5',2304698.95,0.00,'Sales from shift 124 on 2022-12-15 15:42:55 ','2022-12-15 15:42:55','',''),('8','212',562,'','6.1','1',0.00,2304698.95,'Sales from shift 124 on 2022-12-15 15:42:55 ','2022-12-15 15:42:55','',''),('8','212',563,'','20','5',2143311.25,0.00,'Sales from shift 125 on 2022-12-16 15:01:41 ','2022-12-16 15:01:41','',''),('8','212',564,'','6.1','1',0.00,2143311.25,'Sales from shift 125 on 2022-12-16 15:01:41 ','2022-12-16 15:01:41','',''),('8','212',565,'','20','5',741012.75,0.00,'Sales from shift 126 on 2022-12-17 11:18:44 ','2022-12-17 11:18:44','',''),('8','212',566,'','6.1','1',0.00,741012.75,'Sales from shift 126 on 2022-12-17 11:18:44 ','2022-12-17 11:18:44','',''),('8','212',567,'','20','5',606026.70,0.00,'Sales from shift 127 on 2022-12-17 11:26:53 ','2022-12-17 11:26:53','',''),('8','212',568,'','6.1','1',0.00,606026.70,'Sales from shift 127 on 2022-12-17 11:26:53 ','2022-12-17 11:26:53','',''),('8','212',569,'','20','5',1085266.60,0.00,'Sales from shift 128 on 2022-12-18 13:38:08 ','2022-12-18 13:38:08','',''),('8','212',570,'','6.1','1',0.00,1085266.60,'Sales from shift 128 on 2022-12-18 13:38:08 ','2022-12-18 13:38:08','',''),('8','212',571,'','2','6',2143310.00,0.00,'Payment Id 127 for invoice:125, receipt: 104 by Lausu Energy Resources','2022-12-18 22:07:03','',''),('8','212',572,'','supplier','1',0.00,2143310.00,'Payment Id 127 for invoice:125, receipt: 104 by Lausu Energy Resources','2022-12-18 22:07:03','',''),('8','212',573,'','2','6',2304700.00,0.00,'Payment Id 126 for invoice:124, receipt: 103 by Lausu Energy Resources','2022-12-18 22:07:03','',''),('8','212',574,'','supplier','1',0.00,2304700.00,'Payment Id 126 for invoice:124, receipt: 103 by Lausu Energy Resources','2022-12-18 22:07:03','',''),('8','212',575,'','2','6',2119050.00,0.00,'Payment Id 125 for invoice:123, receipt: 102 by Lausu Energy Resources','2022-12-18 22:07:03','',''),('8','212',576,'','supplier','1',0.00,2119050.00,'Payment Id 125 for invoice:123, receipt: 102 by Lausu Energy Resources','2022-12-18 22:07:03','',''),('8','212',577,'','2','6',606030.00,0.00,'Payment Id 129 for invoice:127, receipt: 106 by Lausu Energy Resources','2022-12-19 15:05:48','',''),('8','212',578,'','supplier','1',0.00,606030.00,'Payment Id 129 for invoice:127, receipt: 106 by Lausu Energy Resources','2022-12-19 15:05:48','',''),('8','212',579,'','2','6',741015.00,0.00,'Payment Id 128 for invoice:126, receipt: 105 by Lausu Energy Resources','2022-12-19 15:05:48','',''),('8','212',580,'','supplier','1',0.00,741015.00,'Payment Id 128 for invoice:126, receipt: 105 by Lausu Energy Resources','2022-12-19 15:05:48','',''),('8','212',581,'','20','5',539545.10,0.00,'Sales from shift 129 on 2022-12-21 19:19:31 ','2022-12-21 19:19:31','',''),('8','212',582,'','6.1','1',0.00,539545.10,'Sales from shift 129 on 2022-12-21 19:19:31 ','2022-12-21 19:19:31','',''),('8','212',583,'','24','3',0.00,5580000.00,'Purchase Id 28 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-21 19:29:08','',''),('8','212',584,'','supplier','1',5580000.00,0.00,'Purchase Id 28 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-21 19:29:08','',''),('8','212',585,'','20','5',916597.30,0.00,'Sales from shift 130 on 2022-12-22 12:08:05 ','2022-12-22 12:08:05','',''),('8','212',586,'','6.1','1',0.00,916597.30,'Sales from shift 130 on 2022-12-22 12:08:05 ','2022-12-22 12:08:05','',''),('8','212',587,'','24','3',0.00,5115000.00,'Purchase Id 29 for 16,500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-23 15:52:50','',''),('8','212',588,'','supplier','1',5115000.00,0.00,'Purchase Id 29 for 16,500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-23 15:52:50','',''),('8','212',589,'','20','5',335023.90,0.00,'Sales from shift 131 on 2022-12-25 14:04:46 ','2022-12-25 14:04:46','',''),('8','212',590,'','6.1','1',0.00,335023.90,'Sales from shift 131 on 2022-12-25 14:04:46 ','2022-12-25 14:04:46','',''),('8','212',591,'','20','5',392764.25,0.00,'Sales from shift 132 on 2022-12-28 11:46:27 ','2022-12-28 11:46:27','',''),('8','212',592,'','6.1','1',0.00,392764.25,'Sales from shift 132 on 2022-12-28 11:46:27 ','2022-12-28 11:46:27','',''),('8','212',593,'','2','6',916600.00,0.00,'Payment Id 132 for invoice:130, receipt: 109 by Lausu Energy Resources','2022-12-29 13:23:08','',''),('8','212',594,'','supplier','1',0.00,916600.00,'Payment Id 132 for invoice:130, receipt: 109 by Lausu Energy Resources','2022-12-29 13:23:08','',''),('8','212',595,'','2','6',539545.00,0.00,'Payment Id 131 for invoice:129, receipt: 108 by Lausu Energy Resources','2022-12-29 13:23:08','',''),('8','212',596,'','supplier','1',0.00,539545.00,'Payment Id 131 for invoice:129, receipt: 108 by Lausu Energy Resources','2022-12-29 13:23:08','',''),('8','212',597,'','2','6',1085270.00,0.00,'Payment Id 130 for invoice:128, receipt: 107 by Lausu Energy Resources','2022-12-29 13:23:08','',''),('8','212',598,'','supplier','1',0.00,1085270.00,'Payment Id 130 for invoice:128, receipt: 107 by Lausu Energy Resources','2022-12-29 13:23:08','',''),('8','212',599,'','2','6',334970.00,0.00,'Payment Id 133 for invoice:131, receipt: 110 by Lausu Energy Resources','2022-12-29 13:25:02','',''),('8','212',600,'','supplier','1',0.00,334970.00,'Payment Id 133 for invoice:131, receipt: 110 by Lausu Energy Resources','2022-12-29 13:25:02','',''),('8','212',601,'','20','5',329549.75,0.00,'Sales from shift 133 on 2022-12-30 21:01:39 ','2022-12-30 21:01:39','',''),('8','212',602,'','6.1','1',0.00,329549.75,'Sales from shift 133 on 2022-12-30 21:01:39 ','2022-12-30 21:01:39','',''),('8','212',603,'','20','5',2156598.00,0.00,'Sales from shift 134 on 2023-01-01 21:59:21 ','2023-01-01 21:59:21','',''),('8','212',604,'','6.1','1',0.00,2156598.00,'Sales from shift 134 on 2023-01-01 21:59:21 ','2023-01-01 21:59:21','',''),('8','212',605,'','2','6',329550.00,0.00,'Payment Id 135 for invoice:133, receipt: 112 by Lausu Energy Resources','2023-01-02 15:27:41','',''),('8','212',606,'','supplier','1',0.00,329550.00,'Payment Id 135 for invoice:133, receipt: 112 by Lausu Energy Resources','2023-01-02 15:27:41','',''),('8','212',607,'','2','6',2156600.00,0.00,'Payment Id 136 for invoice:134, receipt: 113 by Lausu Energy Resources','2023-01-02 15:28:01','',''),('8','212',608,'','supplier','1',0.00,2156600.00,'Payment Id 136 for invoice:134, receipt: 113 by Lausu Energy Resources','2023-01-02 15:28:01','',''),('8','212',609,'','2','6',392840.00,0.00,'Payment Id 134 for invoice:132, receipt: 111 by Lausu Energy Resources','2023-01-03 17:19:36','',''),('8','212',610,'','supplier','1',0.00,392840.00,'Payment Id 134 for invoice:132, receipt: 111 by Lausu Energy Resources','2023-01-03 17:19:36','',''),('8','212',611,'','20','5',361523.30,0.00,'Sales from shift 135 on 2023-01-04 21:34:06 ','2023-01-04 21:34:06','',''),('8','212',612,'','6.1','1',0.00,361523.30,'Sales from shift 135 on 2023-01-04 21:34:06 ','2023-01-04 21:34:06','',''),('8','212',613,'','24','3',0.00,4770000.00,'Purchase Id 30 for 15,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-05 06:34:16','',''),('8','212',614,'','supplier','1',4770000.00,0.00,'Purchase Id 30 for 15,900.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-05 06:34:16','',''),('8','212',615,'','20','5',1250856.00,0.00,'Sales from shift 136 on 2023-01-06 09:38:09 ','2023-01-06 09:38:09','',''),('8','212',616,'','6.1','1',0.00,1250856.00,'Sales from shift 136 on 2023-01-06 09:38:09 ','2023-01-06 09:38:09','',''),('8','212',617,'','20','5',622587.90,0.00,'Sales from shift 137 on 2023-01-07 12:55:52 ','2023-01-07 12:55:52','',''),('8','212',618,'','6.1','1',0.00,622587.90,'Sales from shift 137 on 2023-01-07 12:55:52 ','2023-01-07 12:55:52','',''),('8','212',619,'','2','6',1250860.00,0.00,'Payment Id 138 for invoice:136, receipt: 115 by Lausu Energy Resources','2023-01-10 15:44:03','',''),('8','212',620,'','supplier','1',0.00,1250860.00,'Payment Id 138 for invoice:136, receipt: 115 by Lausu Energy Resources','2023-01-10 15:44:03','',''),('8','212',621,'','2','6',361525.00,0.00,'Payment Id 137 for invoice:135, receipt: 114 by Lausu Energy Resources','2023-01-10 15:44:03','',''),('8','212',622,'','supplier','1',0.00,361525.00,'Payment Id 137 for invoice:135, receipt: 114 by Lausu Energy Resources','2023-01-10 15:44:03','',''),('8','212',623,'','2','6',622590.00,0.00,'Payment Id 139 for invoice:137, receipt: 116 by Lausu Energy Resources','2023-01-20 14:49:03','',''),('8','212',624,'','supplier','1',0.00,622590.00,'Payment Id 139 for invoice:137, receipt: 116 by Lausu Energy Resources','2023-01-20 14:49:03','',''),('8','212',625,'','20','5',1714937.25,0.00,'Sales from shift 138 on 2023-01-27 23:04:15 ','2023-01-27 23:04:15','',''),('8','212',626,'','6.1','1',0.00,1714937.25,'Sales from shift 138 on 2023-01-27 23:04:15 ','2023-01-27 23:04:15','',''),('8','212',627,'','2','6',1714940.00,0.00,'Payment Id 140 for invoice:138, receipt: 117 by Lausu Energy Resources','2023-01-30 16:49:00','',''),('8','212',628,'','supplier','1',0.00,1714940.00,'Payment Id 140 for invoice:138, receipt: 117 by Lausu Energy Resources','2023-01-30 16:49:00','',''),('8','212',629,'','20','5',1930464.48,0.00,'Sales from shift 139 on 2023-01-30 17:30:48 ','2023-01-30 17:30:48','',''),('8','212',630,'','6.1','1',0.00,1930464.48,'Sales from shift 139 on 2023-01-30 17:30:48 ','2023-01-30 17:30:48','',''),('8','212',631,'','20','5',1083885.60,0.00,'Sales from shift 140 on 2023-01-31 14:39:37 ','2023-01-31 14:39:37','',''),('8','212',632,'','6.1','1',0.00,1083885.60,'Sales from shift 140 on 2023-01-31 14:39:37 ','2023-01-31 14:39:37','',''),('8','212',633,'','2','6',1930465.00,0.00,'Payment Id 141 for invoice:139, receipt: 118 by Lausu Energy Resources','2023-01-31 19:38:26','',''),('8','212',634,'','supplier','1',0.00,1930465.00,'Payment Id 141 for invoice:139, receipt: 118 by Lausu Energy Resources','2023-01-31 19:38:26','',''),('8','212',635,'','20','5',689206.50,0.00,'Sales from shift 141 on 2023-02-01 10:08:06 ','2023-02-01 10:08:06','',''),('8','212',636,'','6.1','1',0.00,689206.50,'Sales from shift 141 on 2023-02-01 10:08:06 ','2023-02-01 10:08:06','',''),('8','212',637,'','20','5',1154273.40,0.00,'Sales from shift 142 on 2023-02-02 20:39:37 ','2023-02-02 20:39:37','',''),('8','212',638,'','6.1','1',0.00,1154273.40,'Sales from shift 142 on 2023-02-02 20:39:37 ','2023-02-02 20:39:37','',''),('8','212',639,'','2','6',689210.00,0.00,'Payment Id 143 for invoice:141, receipt: 120 by Lausu Energy Resources','2023-02-03 15:47:57','',''),('8','212',640,'','supplier','1',0.00,689210.00,'Payment Id 143 for invoice:141, receipt: 120 by Lausu Energy Resources','2023-02-03 15:47:57','',''),('8','212',641,'','2','6',1083885.00,0.00,'Payment Id 142 for invoice:140, receipt: 119 by Lausu Energy Resources','2023-02-03 15:47:57','',''),('8','212',642,'','supplier','1',0.00,1083885.00,'Payment Id 142 for invoice:140, receipt: 119 by Lausu Energy Resources','2023-02-03 15:47:57','',''),('8','212',643,'','20','5',1618215.60,0.00,'Sales from shift 143 on 2023-02-03 18:59:47 ','2023-02-03 18:59:47','',''),('8','212',644,'','6.1','1',0.00,1618215.60,'Sales from shift 143 on 2023-02-03 18:59:47 ','2023-02-03 18:59:47','',''),('8','212',645,'','20','5',2461336.95,0.00,'Sales from shift 144 on 2023-02-06 08:23:59 ','2023-02-06 08:23:59','',''),('8','212',646,'','6.1','1',0.00,2461336.95,'Sales from shift 144 on 2023-02-06 08:23:59 ','2023-02-06 08:23:59','',''),('8','212',647,'','20','5',933207.75,0.00,'Sales from shift 145 on 2023-02-07 10:40:13 ','2023-02-07 10:40:13','',''),('8','212',648,'','6.1','1',0.00,933207.75,'Sales from shift 145 on 2023-02-07 10:40:13 ','2023-02-07 10:40:13','',''),('8','212',649,'','2','6',933210.00,0.00,'Payment Id 148 for invoice:145, receipt: 124 by Lausu Energy Resources','2023-02-07 16:39:54','',''),('8','212',650,'','supplier','1',0.00,933210.00,'Payment Id 148 for invoice:145, receipt: 124 by Lausu Energy Resources','2023-02-07 16:39:54','',''),('8','212',651,'','2','6',2461340.00,0.00,'Payment Id 147 for invoice:144, receipt: 123 by Lausu Energy Resources','2023-02-07 16:39:54','',''),('8','212',652,'','supplier','1',0.00,2461340.00,'Payment Id 147 for invoice:144, receipt: 123 by Lausu Energy Resources','2023-02-07 16:39:54','',''),('8','212',653,'','2','6',1618215.00,0.00,'Payment Id 145 for invoice:143, receipt: 122 by Lausu Energy Resources','2023-02-07 16:39:54','',''),('8','212',654,'','supplier','1',0.00,1618215.00,'Payment Id 145 for invoice:143, receipt: 122 by Lausu Energy Resources','2023-02-07 16:39:54','',''),('8','212',655,'','2','6',1154275.00,0.00,'Payment Id 144 for invoice:142, receipt: 121 by Lausu Energy Resources','2023-02-07 16:39:54','',''),('8','212',656,'','supplier','1',0.00,1154275.00,'Payment Id 144 for invoice:142, receipt: 121 by Lausu Energy Resources','2023-02-07 16:39:54','',''),('8','212',657,'','24','3',0.00,15300000.00,'Purchase Id 31 for 45,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-16 17:23:38','',''),('8','212',658,'','supplier','1',15300000.00,0.00,'Purchase Id 31 for 45,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-16 17:23:38','',''),('8','212',659,'','20','5',1051497.90,0.00,'Sales from shift 146 on 2023-02-16 19:53:35 ','2023-02-16 19:53:35','',''),('8','212',660,'','6.1','1',0.00,1051497.90,'Sales from shift 146 on 2023-02-16 19:53:35 ','2023-02-16 19:53:35','',''),('8','212',661,'','20','5',1498767.60,0.00,'Sales from shift 147 on 2023-02-17 19:37:29 ','2023-02-17 19:37:29','',''),('8','212',662,'','6.1','1',0.00,1498767.60,'Sales from shift 147 on 2023-02-17 19:37:29 ','2023-02-17 19:37:29','',''),('8','212',663,'','20','5',710402.80,0.00,'Sales from shift 148 on 2023-02-21 10:39:46 ','2023-02-21 10:39:46','',''),('8','212',664,'','6.1','1',0.00,710402.80,'Sales from shift 148 on 2023-02-21 10:39:46 ','2023-02-21 10:39:46','',''),('8','212',665,'','20','5',737711.60,0.00,'Sales from shift 149 on 2023-02-21 10:44:01 ','2023-02-21 10:44:01','',''),('8','212',666,'','6.1','1',0.00,737711.60,'Sales from shift 149 on 2023-02-21 10:44:01 ','2023-02-21 10:44:01','',''),('8','212',667,'','20','5',2162019.20,0.00,'Sales from shift 150 on 2023-02-21 10:49:52 ','2023-02-21 10:49:52','',''),('8','212',668,'','6.1','1',0.00,2162019.20,'Sales from shift 150 on 2023-02-21 10:49:52 ','2023-02-21 10:49:52','',''),('8','212',669,'','20','5',1137055.20,0.00,'Sales from shift 151 on 2023-02-21 10:57:06 ','2023-02-21 10:57:06','',''),('8','212',670,'','6.1','1',0.00,1137055.20,'Sales from shift 151 on 2023-02-21 10:57:06 ','2023-02-21 10:57:06','',''),('8','212',671,'','20','5',688727.80,0.00,'Sales from shift 152 on 2023-02-23 21:55:30 ','2023-02-23 21:55:30','',''),('8','212',672,'','6.1','1',0.00,688727.80,'Sales from shift 152 on 2023-02-23 21:55:30 ','2023-02-23 21:55:30','',''),('8','212',673,'','20','5',1156595.20,0.00,'Sales from shift 153 on 2023-02-23 22:01:31 ','2023-02-23 22:01:31','',''),('8','212',674,'','6.1','1',0.00,1156595.20,'Sales from shift 153 on 2023-02-23 22:01:31 ','2023-02-23 22:01:31','',''),('8','212',675,'','20','5',682278.40,0.00,'Sales from shift 154 on 2023-02-24 08:58:52 ','2023-02-24 08:58:52','',''),('8','212',676,'','6.1','1',0.00,682278.40,'Sales from shift 154 on 2023-02-24 08:58:52 ','2023-02-24 08:58:52','',''),('8','212',677,'','24','3',0.00,5376000.00,'Purchase Id 32 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-24 10:53:41','',''),('8','212',678,'','supplier','1',5376000.00,0.00,'Purchase Id 32 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-24 10:53:41','',''),('8','212',679,'','2','6',688730.00,0.00,'Payment Id 157 for invoice:152, receipt: 131 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',680,'','supplier','1',0.00,688730.00,'Payment Id 157 for invoice:152, receipt: 131 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',681,'','2','6',1137055.00,0.00,'Payment Id 156 for invoice:151, receipt: 130 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',682,'','supplier','1',0.00,1137055.00,'Payment Id 156 for invoice:151, receipt: 130 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',683,'','2','6',2162020.00,0.00,'Payment Id 155 for invoice:150, receipt: 129 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',684,'','supplier','1',0.00,2162020.00,'Payment Id 155 for invoice:150, receipt: 129 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',685,'','2','6',737710.00,0.00,'Payment Id 154 for invoice:149, receipt: 128 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',686,'','supplier','1',0.00,737710.00,'Payment Id 154 for invoice:149, receipt: 128 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',687,'','2','6',710405.00,0.00,'Payment Id 153 for invoice:148, receipt: 127 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',688,'','supplier','1',0.00,710405.00,'Payment Id 153 for invoice:148, receipt: 127 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',689,'','2','6',1498745.00,0.00,'Payment Id 152 for invoice:147, receipt: 126 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',690,'','supplier','1',0.00,1498745.00,'Payment Id 152 for invoice:147, receipt: 126 by Lausu Energy Resources','2023-02-24 13:58:38','',''),('8','212',691,'','20','5',955337.60,0.00,'Sales from shift 155 on 2023-02-27 09:15:23 ','2023-02-27 09:15:23','',''),('8','212',692,'','6.1','1',0.00,955337.60,'Sales from shift 155 on 2023-02-27 09:15:23 ','2023-02-27 09:15:23','',''),('8','212',693,'','20','5',1905596.80,0.00,'Sales from shift 156 on 2023-02-27 09:19:23 ','2023-02-27 09:19:23','',''),('8','212',694,'','6.1','1',0.00,1905596.80,'Sales from shift 156 on 2023-02-27 09:19:23 ','2023-02-27 09:19:23','',''),('8','212',695,'','20','5',1000000.00,0.00,'Sales from shift 157 on 2023-02-28 23:12:41 ','2023-02-28 23:12:41','',''),('8','212',696,'','6.1','1',0.00,1000000.00,'Sales from shift 157 on 2023-02-28 23:12:41 ','2023-02-28 23:12:41','',''),('8','212',697,'','2','6',1000000.00,0.00,'Payment Id 162 for invoice:157, receipt: 136 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',698,'','supplier','1',0.00,1000000.00,'Payment Id 162 for invoice:157, receipt: 136 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',699,'','2','6',1905600.00,0.00,'Payment Id 161 for invoice:156, receipt: 135 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',700,'','supplier','1',0.00,1905600.00,'Payment Id 161 for invoice:156, receipt: 135 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',701,'','2','6',955340.00,0.00,'Payment Id 160 for invoice:155, receipt: 134 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',702,'','supplier','1',0.00,955340.00,'Payment Id 160 for invoice:155, receipt: 134 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',703,'','2','6',682280.00,0.00,'Payment Id 159 for invoice:154, receipt: 133 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',704,'','supplier','1',0.00,682280.00,'Payment Id 159 for invoice:154, receipt: 133 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',705,'','2','6',1156595.00,0.00,'Payment Id 158 for invoice:153, receipt: 132 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',706,'','supplier','1',0.00,1156595.00,'Payment Id 158 for invoice:153, receipt: 132 by Lausu Energy Resources','2023-03-01 14:51:06','',''),('8','212',707,'','2','6',649900.00,0.00,'Payment Id 151 for invoice:146, receipt: 125 by Lausu Energy Resources','2023-03-01 15:02:44','',''),('8','212',708,'','supplier','1',0.00,649900.00,'Payment Id 151 for invoice:146, receipt: 125 by Lausu Energy Resources','2023-03-01 15:02:44','',''),('8','212',709,'','20','5',1051404.80,0.00,'Sales from shift 158 on 2023-03-01 17:38:35 ','2023-03-01 17:38:35','',''),('8','212',710,'','6.1','1',0.00,1051404.80,'Sales from shift 158 on 2023-03-01 17:38:35 ','2023-03-01 17:38:35','',''),('8','212',711,'','2','6',1051405.00,0.00,'Payment Id 163 for invoice:158, receipt: 137 by Lausu Energy Resources','2023-03-03 13:17:21','',''),('8','212',712,'','supplier','1',0.00,1051405.00,'Payment Id 163 for invoice:158, receipt: 137 by Lausu Energy Resources','2023-03-03 13:17:21','',''),('8','212',713,'','20','5',860579.20,0.00,'Sales from shift 159 on 2023-03-03 23:17:10 ','2023-03-03 23:17:10','',''),('8','212',714,'','6.1','1',0.00,860579.20,'Sales from shift 159 on 2023-03-03 23:17:10 ','2023-03-03 23:17:10','',''),('8','212',715,'','20','5',840409.60,0.00,'Sales from shift 160 on 2023-03-03 23:22:10 ','2023-03-03 23:22:10','',''),('8','212',716,'','6.1','1',0.00,840409.60,'Sales from shift 160 on 2023-03-03 23:22:10 ','2023-03-03 23:22:10','',''),('8','212',717,'','20','5',1058994.00,0.00,'Sales from shift 161 on 2023-03-04 23:02:13 ','2023-03-04 23:02:13','',''),('8','212',718,'','6.1','1',0.00,1058994.00,'Sales from shift 161 on 2023-03-04 23:02:13 ','2023-03-04 23:02:13','',''),('8','212',719,'','20','5',887757.00,0.00,'Sales from shift 162 on 2023-03-06 17:41:04 ','2023-03-06 17:41:04','',''),('8','212',720,'','6.1','1',0.00,887757.00,'Sales from shift 162 on 2023-03-06 17:41:04 ','2023-03-06 17:41:04','',''),('8','212',721,'','20','5',1644354.00,0.00,'Sales from shift 163 on 2023-03-06 17:44:45 ','2023-03-06 17:44:45','',''),('8','212',722,'','6.1','1',0.00,1644354.00,'Sales from shift 163 on 2023-03-06 17:44:45 ','2023-03-06 17:44:45','',''),('8','212',723,'','20','5',594768.00,0.00,'Sales from shift 164 on 2023-03-09 00:04:45 ','2023-03-09 00:04:45','',''),('8','212',724,'','6.1','1',0.00,594768.00,'Sales from shift 164 on 2023-03-09 00:04:45 ','2023-03-09 00:04:45','',''),('8','212',725,'','24','3',0.00,10200000.00,'Purchase Id 33 for 34,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-09 10:55:00','',''),('8','212',726,'','supplier','1',10200000.00,0.00,'Purchase Id 33 for 34,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-09 10:55:00','',''),('8','212',727,'','20','5',473319.00,0.00,'Sales from shift 165 on 2023-03-09 23:15:51 ','2023-03-09 23:15:51','',''),('8','212',728,'','6.1','1',0.00,473319.00,'Sales from shift 165 on 2023-03-09 23:15:51 ','2023-03-09 23:15:51','',''),('8','212',729,'','20','5',713025.00,0.00,'Sales from shift 166 on 2023-03-09 23:20:16 ','2023-03-09 23:20:16','',''),('8','212',730,'','6.1','1',0.00,713025.00,'Sales from shift 166 on 2023-03-09 23:20:16 ','2023-03-09 23:20:16','',''),('8','212',731,'','2','6',887760.00,0.00,'Payment Id 167 for invoice:162, receipt: 141 by Lausu Energy Resources','2023-03-10 11:02:18','',''),('8','212',732,'','supplier','1',0.00,887760.00,'Payment Id 167 for invoice:162, receipt: 141 by Lausu Energy Resources','2023-03-10 11:02:18','',''),('8','212',733,'','2','6',1058995.00,0.00,'Payment Id 166 for invoice:161, receipt: 140 by Lausu Energy Resources','2023-03-10 11:02:57','',''),('8','212',734,'','supplier','1',0.00,1058995.00,'Payment Id 166 for invoice:161, receipt: 140 by Lausu Energy Resources','2023-03-10 11:02:57','',''),('8','212',735,'','2','6',860580.00,0.00,'Payment Id 164 for invoice:159, receipt: 138 by Lausu Energy Resources','2023-03-10 11:04:30','',''),('8','212',736,'','supplier','1',0.00,860580.00,'Payment Id 164 for invoice:159, receipt: 138 by Lausu Energy Resources','2023-03-10 11:04:30','',''),('8','212',737,'','2','6',1644355.00,0.00,'Payment Id 168 for invoice:163, receipt: 142 by Lausu Energy Resources','2023-03-10 11:10:11','',''),('8','212',738,'','supplier','1',0.00,1644355.00,'Payment Id 168 for invoice:163, receipt: 142 by Lausu Energy Resources','2023-03-10 11:10:11','',''),('8','212',739,'','20','5',818979.00,0.00,'Sales from shift 167 on 2023-03-11 13:49:58 ','2023-03-11 13:49:58','',''),('8','212',740,'','6.1','1',0.00,818979.00,'Sales from shift 167 on 2023-03-11 13:49:58 ','2023-03-11 13:49:58','',''),('8','212',741,'','20','5',1181796.00,0.00,'Sales from shift 168 on 2023-03-11 13:53:34 ','2023-03-11 13:53:34','',''),('8','212',742,'','6.1','1',0.00,1181796.00,'Sales from shift 168 on 2023-03-11 13:53:34 ','2023-03-11 13:53:34','',''),('8','212',743,'','20','5',3009384.00,0.00,'Sales from shift 169 on 2023-03-13 17:09:16 ','2023-03-13 17:09:16','',''),('8','212',744,'','6.1','1',0.00,3009384.00,'Sales from shift 169 on 2023-03-13 17:09:16 ','2023-03-13 17:09:16','',''),('8','212',745,'','2','6',3009385.00,0.00,'Payment Id 174 for invoice:169, receipt: 148 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',746,'','supplier','1',0.00,3009385.00,'Payment Id 174 for invoice:169, receipt: 148 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',747,'','2','6',1181800.00,0.00,'Payment Id 173 for invoice:168, receipt: 147 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',748,'','supplier','1',0.00,1181800.00,'Payment Id 173 for invoice:168, receipt: 147 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',749,'','2','6',818980.00,0.00,'Payment Id 172 for invoice:167, receipt: 146 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',750,'','supplier','1',0.00,818980.00,'Payment Id 172 for invoice:167, receipt: 146 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',751,'','2','6',713025.00,0.00,'Payment Id 171 for invoice:166, receipt: 145 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',752,'','supplier','1',0.00,713025.00,'Payment Id 171 for invoice:166, receipt: 145 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',753,'','2','6',473320.00,0.00,'Payment Id 170 for invoice:165, receipt: 144 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',754,'','supplier','1',0.00,473320.00,'Payment Id 170 for invoice:165, receipt: 144 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',755,'','2','6',594585.00,0.00,'Payment Id 169 for invoice:164, receipt: 143 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',756,'','supplier','1',0.00,594585.00,'Payment Id 169 for invoice:164, receipt: 143 by Lausu Energy Resources','2023-03-15 13:39:55','',''),('8','212',757,'','2','6',818010.00,0.00,'Payment Id 165 for invoice:160, receipt: 139 by Lausu Energy Resources','2023-03-15 13:40:51','',''),('8','212',758,'','supplier','1',0.00,818010.00,'Payment Id 165 for invoice:160, receipt: 139 by Lausu Energy Resources','2023-03-15 13:40:51','',''),('8','212',759,'','20','5',1086264.00,0.00,'Sales from shift 170 on 2023-03-18 13:43:06 ','2023-03-18 13:43:06','',''),('8','212',760,'','6.1','1',0.00,1086264.00,'Sales from shift 170 on 2023-03-18 13:43:06 ','2023-03-18 13:43:06','',''),('8','212',761,'','20','5',992754.00,0.00,'Sales from shift 171 on 2023-03-18 13:48:24 ','2023-03-18 13:48:24','',''),('8','212',762,'','6.1','1',0.00,992754.00,'Sales from shift 171 on 2023-03-18 13:48:24 ','2023-03-18 13:48:24','',''),('8','212',763,'','20','5',1046916.00,0.00,'Sales from shift 172 on 2023-03-18 13:53:00 ','2023-03-18 13:53:00','',''),('8','212',764,'','6.1','1',0.00,1046916.00,'Sales from shift 172 on 2023-03-18 13:53:00 ','2023-03-18 13:53:00','',''),('8','212',765,'','20','5',1136550.00,0.00,'Sales from shift 173 on 2023-03-18 13:58:13 ','2023-03-18 13:58:13','',''),('8','212',766,'','6.1','1',0.00,1136550.00,'Sales from shift 173 on 2023-03-18 13:58:13 ','2023-03-18 13:58:13','',''),('8','212',767,'','24','3',0.00,10500000.00,'Purchase Id 34 for 35,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-19 19:33:04','',''),('8','212',768,'','supplier','1',10500000.00,0.00,'Purchase Id 34 for 35,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-19 19:33:04','',''),('8','212',769,'','20','5',966654.00,0.00,'Sales from shift 174 on 2023-03-20 08:43:35 ','2023-03-20 08:43:35','',''),('8','212',770,'','6.1','1',0.00,966654.00,'Sales from shift 174 on 2023-03-20 08:43:35 ','2023-03-20 08:43:35','',''),('8','212',771,'','20','5',3211365.30,0.00,'Sales from shift 175 on 2023-03-20 08:53:56 ','2023-03-20 08:53:56','',''),('8','212',772,'','6.1','1',0.00,3211365.30,'Sales from shift 175 on 2023-03-20 08:53:56 ','2023-03-20 08:53:56','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'8','212','PMS','Petrol','Litres',0,300.00,300.00,300.00,300.00,0.00,0,'2022-07-17 08:42:39','910','910','2023-03-04 22:56:33',0),(2,'8','212','AGO','Diesel','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-07-17 08:47:21','910','910','2022-07-17 08:47:21',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'8','212',1,210.00,210.00,210.00,210.00,'PMS PUMP PRICE','2022-07-17 11:17:28','910'),(2,'8','212',1,195.00,195.00,195.00,195.00,'PMS PUMP PRICE DECREMENT','2022-07-17 12:28:37','910'),(3,'8','212',1,200.00,195.00,0.00,0.00,'Cost from purchase id #2','2022-07-17 12:58:26','910'),(4,'8','212',1,200.00,200.00,200.00,200.00,'PMS PUMP PRICE INCREMENT','2022-07-17 13:18:16','910'),(5,'8','212',1,220.00,200.00,0.00,0.00,'Cost from purchase id #3','2022-07-17 13:52:15','910'),(6,'8','212',1,215.00,215.00,215.00,215.00,'PMS PUMP PRICE DECREMENT','2022-07-17 14:27:02','910'),(7,'8','212',1,200.00,215.00,0.00,0.00,'Cost from purchase id #7','2022-08-23 13:28:14','467'),(8,'8','212',1,200.00,195.00,195.00,195.00,'','2022-08-24 17:07:20','926'),(9,'8','212',1,200.00,190.00,190.00,190.00,'','2022-08-25 16:51:49','467'),(10,'8','212',1,190.00,190.00,0.00,0.00,'Cost from purchase id #8','2022-09-06 07:13:12','927'),(11,'8','212',1,195.00,195.00,195.00,195.00,'','2022-10-08 19:23:41','910'),(12,'8','212',1,190.00,190.00,190.00,190.00,'','2022-10-08 19:27:12','910'),(13,'8','212',1,195.00,195.00,195.00,195.00,'','2022-10-08 19:28:58','910'),(14,'8','212',1,206.00,206.00,206.00,206.00,'','2022-10-11 17:47:31','910'),(15,'8','212',1,220.00,220.00,220.00,220.00,'','2022-10-12 18:59:53','910'),(16,'8','212',1,225.00,225.00,225.00,225.00,'','2022-10-14 22:45:20','910'),(17,'8','212',1,230.00,230.00,230.00,230.00,'','2022-10-20 18:50:17','910'),(18,'8','212',1,235.00,235.00,235.00,235.00,'','2022-10-21 19:19:36','910'),(19,'8','212',1,250.00,250.00,250.00,250.00,'','2022-10-27 05:14:53','910'),(20,'8','212',1,255.00,250.00,0.00,0.00,'Cost from purchase id #17','2022-11-04 11:10:07','927'),(21,'8','212',1,255.00,255.00,255.00,255.00,'','2022-11-04 20:46:02','910'),(22,'8','212',1,250.00,250.00,250.00,250.00,'','2022-11-06 21:22:06','910'),(23,'8','212',1,255.00,255.00,255.00,255.00,'','2022-11-14 11:36:30','910'),(24,'8','212',1,260.00,260.00,260.00,260.00,'','2022-11-27 08:34:22','910'),(25,'8','212',1,270.00,260.00,0.00,0.00,'Cost from purchase id #25','2022-12-03 14:40:01','467'),(26,'8','212',1,270.00,270.00,270.00,270.00,'','2022-12-03 15:04:00','910'),(27,'8','212',1,277.00,277.00,277.00,277.00,'','2022-12-06 20:06:17','910'),(28,'8','212',1,305.00,305.00,305.00,305.00,'','2022-12-14 15:47:01','910'),(29,'8','212',1,185.00,185.00,185.00,185.00,'','2022-12-17 11:22:11','910'),(30,'8','212',1,310.00,310.00,310.00,310.00,'','2022-12-17 11:30:20','910'),(31,'8','212',1,185.00,185.00,185.00,185.00,'','2022-12-21 19:15:29','910'),(32,'8','212',1,310.00,185.00,0.00,0.00,'Cost from purchase id #28','2022-12-21 19:29:08','927'),(33,'8','212',1,300.00,300.00,300.00,300.00,'','2023-01-01 21:54:41','910'),(34,'8','212',1,185.00,185.00,185.00,185.00,'','2023-01-04 21:31:15','910'),(35,'8','212',1,300.00,300.00,300.00,300.00,'','2023-01-04 21:41:09','910'),(36,'8','212',1,185.00,185.00,185.00,185.00,'','2023-01-07 12:52:34','910'),(37,'8','212',1,195.00,195.00,195.00,195.00,'','2023-01-27 22:59:51','910'),(38,'8','212',1,336.00,336.00,336.00,336.00,'','2023-01-30 17:27:49','910'),(39,'8','212',1,345.00,345.00,345.00,345.00,'','2023-02-01 09:58:58','910'),(40,'8','212',1,340.00,345.00,0.00,0.00,'Cost from purchase id #31','2023-02-16 17:23:38','927'),(41,'8','212',1,340.00,340.00,340.00,340.00,'','2023-02-16 20:46:52','910'),(42,'8','212',1,320.00,320.00,320.00,320.00,'','2023-02-23 21:58:31','910'),(43,'8','212',1,300.00,300.00,300.00,300.00,'','2023-03-04 22:56:25','910');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (5,'8','212','2022-08-10',1,1,215.00,29850.00,0.00,0.00,6417750.00,0.00,'','','RAN 32 XF','','','','2022-08-11 15:35:57',15,'PMS DELIVARY','910','','0000-00-00 00:00:00','927','2022-08-11 15:37:01'),(6,'8','212','2022-08-12',1,1,215.00,17000.00,0.00,0.00,3655000.00,0.00,'','00023','BCH-424-XA','','','','2022-08-12 18:08:56',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-08-12 18:16:06'),(7,'8','212','2022-08-23',1,1,200.00,30250.00,0.00,0.00,6503750.00,0.00,'','00030','NSR-57-ZQ','','','','2022-08-23 12:20:28',15,'PURCHASE OF P.M.S','910','467','2022-08-23 13:27:58','467','2022-08-23 13:28:14'),(8,'8','212','2022-09-05',1,1,190.00,33200.00,0.00,0.00,6308000.00,0.00,'','00036','WDL-813-XA','','','','2022-09-05 21:56:22',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-06 07:13:12'),(9,'8','212','2022-09-16',1,1,190.00,33900.00,0.00,0.00,6441000.00,0.00,'','0001','NSR-433-ZS','','','','2022-09-16 20:13:20',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-17 07:46:28'),(10,'8','212','2022-09-26',1,1,190.00,33000.00,0.00,0.00,6270000.00,0.00,'','00046','RAN-31-XF','','','','2022-09-27 08:14:00',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','465','2022-09-27 16:13:51'),(11,'8','212','2022-10-08',1,1,195.00,16700.00,0.00,0.00,3256500.00,0.00,'','00047','BCH-428-XA','','','','2022-10-08 09:36:21',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-08 19:24:25'),(12,'8','212','2022-10-10',1,1,206.00,50000.00,0.00,0.00,10300000.00,0.00,'','00048','RAN-33-XF','','','','2022-10-11 17:42:01',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-12 05:52:44'),(13,'8','212','2022-10-14',1,1,225.00,17000.00,0.00,0.00,3825000.00,0.00,'','00048','BCH-424-XA','','','','2022-10-14 22:56:32',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-15 19:52:02'),(14,'8','212','2022-10-19',1,1,225.00,32000.00,0.00,0.00,7200000.00,0.00,'','00561','WDL-813-XA','','','','2022-10-19 21:44:58',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-19 22:36:48'),(16,'8','212','2022-10-24',1,1,235.00,33000.00,0.00,0.00,7755000.00,0.00,'','00569','RAN-869-XA','','','','2022-10-24 21:59:26',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-25 05:42:27'),(17,'8','212','2022-11-03',1,1,255.00,33000.00,0.00,0.00,8415000.00,0.00,'','00067','RAN-31-XF','','','','2022-11-03 23:05:11',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-04 11:10:07'),(18,'8','212','2022-11-04',1,1,255.00,17000.00,0.00,0.00,4335000.00,0.00,'','00765','RAN-32-XF','','','','2022-11-04 20:49:04',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-04 22:45:46'),(19,'8','212','2022-11-12',1,1,250.00,16700.00,0.00,0.00,4175000.00,0.00,'','00048','BCH-428-XA','','','','2022-11-12 12:52:22',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-12 15:38:54'),(20,'8','212','2022-11-15',1,1,255.00,17000.00,0.00,0.00,4335000.00,0.00,'','00089','RAN-869-XA','','','','2022-11-15 11:14:21',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-15 11:44:14'),(21,'8','212','2022-11-16',1,1,255.00,17000.00,0.00,0.00,4335000.00,0.00,'','00078','BCH-424-XA','','','','2022-11-17 09:33:08',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-17 11:15:04'),(22,'8','212','2022-11-22',1,1,255.00,33000.00,0.00,0.00,8415000.00,0.00,'','00049','RAN-31-XF','','','','2022-11-22 18:44:50',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-22 20:36:40'),(23,'8','212','2022-11-30',1,1,260.00,32000.00,0.00,0.00,8320000.00,0.00,'','00597','NSR-435-ZS','','','','2022-11-30 20:29:18',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-01 10:55:42'),(25,'8','212','2022-12-03',1,1,270.00,1000.00,0.00,0.00,270000.00,0.00,'','00047','NSR-57-ZQ','','','','2022-12-03 14:38:56',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','467','2022-12-03 14:40:01'),(26,'8','212','2022-12-05',1,1,270.00,16000.00,0.00,0.00,4320000.00,0.00,'','00045','RAN-32-XF','','','','2022-12-06 06:00:30',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-06 10:23:17'),(27,'8','212','2022-12-13',1,1,305.00,44550.00,0.00,0.00,13587750.00,0.00,'','00039','DZW-549-XA','','','','2022-12-14 15:43:56',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-15 08:39:10'),(28,'8','212','2022-12-19',1,1,310.00,18000.00,0.00,0.00,5580000.00,0.00,'','00445','WDL-813-XA','','','','2022-12-19 21:44:24',15,'PURCHASE OF P.M.S ','910','','0000-00-00 00:00:00','927','2022-12-21 19:29:08'),(29,'8','212','2022-12-23',1,1,310.00,16500.00,0.00,0.00,5115000.00,0.00,'','00446','RAN-33-XF','','','','2022-12-23 14:32:11',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-23 15:52:50'),(30,'8','212','2023-01-01',1,1,300.00,15900.00,0.00,0.00,4770000.00,0.00,'','0047','NSR-572-ZS','','','','2023-01-04 21:29:49',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2023-01-05 06:34:16'),(31,'8','212','2023-02-16',1,1,340.00,45000.00,0.00,0.00,15300000.00,0.00,'','0082','K.M.C-62-ZB','','','','2023-02-16 12:47:24',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-16 17:23:38'),(32,'8','212','2023-02-21',1,1,320.00,16800.00,0.00,0.00,5376000.00,0.00,'','00478','BCH-428-XA','','','','2023-02-24 09:01:38',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-24 10:53:41'),(33,'8','212','2023-03-08',1,1,300.00,34000.00,0.00,0.00,10200000.00,0.00,'','0049','JMT-511-ZY','','','','2023-03-09 00:10:51',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-09 10:55:00'),(34,'8','212','2023-03-15',1,1,300.00,35000.00,0.00,0.00,10500000.00,0.00,'','0050','RAN-441-XA','','','','2023-03-18 14:06:41',15,'PURCHASE OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-19 19:33:04');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (2,'8','212','2022-08-11',1,'001','','5',6417750.00,'1','','','6','TOTAL KACHAKO1','001',141639.85,'2022-08-12 15:38:04',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-15 12:54:50'),(3,'8','212','2022-08-12',1,'002','','5',6417750.00,'2','','','6','TOTAL KACHAKO1','002',238090.00,'2022-08-12 16:04:59',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-15 12:54:50'),(4,'8','212','2022-08-15',1,'003','','5',6417750.00,'12','','','6','TOTAL KACHAKO1','610623',316920.00,'2022-08-15 12:49:51',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-15 12:54:50'),(5,'8','212','2022-08-15',1,'003','','5',6417750.00,'12','','','6','TOTAL KACHAKO1','003',219925.00,'2022-08-15 12:51:51',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-15 12:54:50'),(6,'8','212','2022-08-15',1,'610622','','5',6417750.00,'12','','','6','TOTAL KACHAKO1','610622',826705.00,'2022-08-15 12:53:46',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-15 12:54:50'),(7,'8','212','2022-08-16',1,'004','','5',6417750.00,'13','','','6','TOTAL KACHAKO1','004',174965.00,'2022-08-16 11:38:06',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-19 19:23:38'),(8,'8','212','2022-08-17',1,'005','','5',6417750.00,'17','','','6','TOTAL KACHAKO1','005',202325.00,'2022-08-19 19:22:24',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-19 19:23:38'),(9,'8','212','2022-08-18',1,'006','','5',6417750.00,'18','','','6','TOTAL KACHAKO1','006',245630.00,'2022-08-19 19:28:51',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-19 19:29:21'),(10,'8','212','2022-08-19',1,'007','','5',6417750.00,'19','','','6','TOTAL KACHAKO1','007',263510.00,'2022-08-19 19:31:59',2,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','910','2022-08-19 19:32:21'),(11,'8','212','2022-08-19',1,'007','','5',212665.00,'19','','','6','TOTAL KACHAKO1','007',732855.45,'2022-08-22 13:37:33',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:35:15'),(12,'8','212','2022-08-11',1,'','','5',141640.00,'19','','','6','TOTAL KACHAKO1','001',732855.45,'2022-08-22 22:05:43',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:40:22'),(13,'8','212','2022-08-12',1,'610622','','5',238090.00,'','','','6','TOTAL KACHAKO1','610622',732855.45,'2022-08-22 22:14:37',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:39:58'),(14,'8','212','2022-08-15',1,'003','','5',316920.00,'19','','','6','TOTAL KACHAKO1','003',732855.45,'2022-08-22 22:17:57',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:38:45'),(15,'8','212','2022-08-15',1,'004','','5',219925.00,'19','','','6','TOTAL KACHAKO1','004',732855.45,'2022-08-22 22:20:50',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:39:02'),(16,'8','212','2022-08-15',1,'610622','','5',826705.00,'19','','','6','TOTAL KACHAKO1','610622',732855.45,'2022-08-22 22:24:33',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:39:19'),(17,'8','212','2022-08-16',1,'005','','5',174965.00,'19','','','6','TOTAL KACHAKO1','005',732855.45,'2022-08-22 22:27:44',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:38:03'),(18,'8','212','2022-08-17',1,'006','','5',202345.00,'19','','','6','TOTAL KACHAKO1','006',732855.45,'2022-08-22 22:31:53',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:37:38'),(19,'8','212','2022-08-18',1,'007','','5',245630.00,'19','','','6','TOTAL KACHAKO1','007',732855.45,'2022-08-22 22:34:51',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:36:50'),(20,'8','212','2022-08-19',1,'008','','5',263510.00,'19','','','6','TOTAL KACHAKO1','008',732855.45,'2022-08-22 22:37:50',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:36:24'),(21,'8','212','2022-08-22',1,'009','','5',185760.00,'19','','','6','TOTAL KACHAKO1','010',732855.45,'2022-08-22 22:42:59',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:41:33'),(22,'8','212','2022-08-22',1,'610559','','5',681730.00,'19','','','6','TOTAL KACHAKO1','610559',732855.45,'2022-08-23 09:35:34',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-08-23 13:35:42'),(23,'8','212','2022-08-23',1,'011','','5',138630.00,'20','','','6','TOTAL KACHAKO1','011',149014.35,'2022-08-23 09:43:08',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-09-01 15:41:27'),(24,'8','212','2022-08-23',1,'012','','5',138935.00,'21','','','6','TOTAL KACHAKO1','012',149351.90,'2022-08-23 19:18:12',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-09-01 15:40:58'),(25,'8','212','2022-08-24',1,'013','','5',179410.00,'23','','','6','TOTAL KACHAKO1','013',179411.30,'2022-08-24 20:52:08',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-09-01 15:39:56'),(26,'8','212','2022-08-25',1,'013','','5',290455.00,'24','','','6','TOTAL KACHAKO1','013',290454.90,'2022-08-25 19:33:34',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-09-01 15:38:43'),(27,'8','212','2022-08-26',1,'014','','5',218445.50,'25','','','6','TOTAL KACHAKO1','014',218443.00,'2022-08-26 20:41:53',5,'PAYMENT OF P.M.S','910','467','2022-09-01 15:29:06','467','2022-09-01 15:30:09'),(28,'8','212','2022-08-27',1,'015','','5',356195.00,'26','','','6','TOTAL KACHAKO1','015',356194.90,'2022-08-27 19:47:42',5,'PAYMENT OF P.M.S','910','467','2022-09-01 15:38:03','467','2022-09-01 15:38:07'),(29,'8','212','2022-08-28',1,'015','','5',572870.00,'27','','','6','TOTAL KACHAKO1','015',572869.00,'2022-08-28 19:52:58',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-09-01 15:35:25'),(30,'8','212','2022-08-29',1,'016','','5',130595.00,'28','','','6','TOTAL KACHAKO1','016',130596.50,'2022-08-29 19:52:42',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-09-01 15:26:39'),(31,'8','212','2022-08-30',1,'017','','5',224910.00,'29','','','6','TOTAL KACHAKO1','017',224903.00,'2022-08-30 19:10:01',5,'PAYMENT OF P.M.S','910','467','2022-09-01 15:25:21','467','2022-09-01 15:25:55'),(32,'8','212','2022-08-31',1,'018','','5',334540.00,'30','','','6','TOTAL KACHAKO1','018',334540.60,'2022-08-31 19:55:02',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','467','2022-09-01 15:24:33'),(33,'8','212','2022-09-01',1,'018','','5',311230.00,'31','','','6','TOTAL KACHAKO1','018',311229.50,'2022-09-01 20:16:56',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-06 19:05:01'),(34,'8','212','2022-09-02',1,'019','','5',807750.00,'32','','','6','TOTAL KACHAKO1','019',807747.00,'2022-09-02 19:51:56',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-06 19:04:01'),(35,'8','212','2022-09-03',1,'019','','5',603365.00,'33','','','6','TOTAL KACHAKO1','019',603362.10,'2022-09-04 08:24:11',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-06 19:03:36'),(36,'8','212','2022-09-04',1,'3379016','','5',1423630.00,'34','','','6','TOTAL KACHAKO1','3379016',1423633.90,'2022-09-05 12:37:15',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-12 15:08:55'),(37,'8','212','2022-09-05',1,'020','','5',310920.00,'35','','','6','TOTAL KACHAKO1','020',310921.70,'2022-09-05 21:53:08',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-06 19:03:11'),(38,'8','212','2022-09-06',1,'021','','5',240260.00,'36','','','6','TOTAL KACHAKO1','021',240258.80,'2022-09-06 20:53:45',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-12 15:09:11'),(39,'8','212','2022-09-07',1,'022','','5',145855.00,'37','','','6','TOTAL KACHAKO1','022',145855.40,'2022-09-07 20:43:13',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-08 13:34:38'),(40,'8','212','2022-09-08',1,'023','','5',346740.00,'38','','','6','TOTAL KACHAKO1','023',346742.40,'2022-09-08 19:22:47',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-09 14:58:54'),(41,'8','212','2022-09-10',1,'024','','5',254220.00,'39','','','6','TOTAL KACHAKO1','024',254218.10,'2022-09-10 09:28:57',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-12 15:47:47'),(42,'8','212','2022-09-10',1,'024','','5',306930.00,'40','','','6','TOTAL KACHAKO1','024',306927.90,'2022-09-10 19:36:39',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-12 15:47:29'),(43,'8','212','2022-09-11',1,'025','','5',1725135.00,'41','','','6','TOTAL KACHAKO1','025',1725135.40,'2022-09-11 21:14:30',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-14 21:58:24'),(44,'8','212','2022-09-12',1,'025','','5',911840.00,'42','','','6','TOTAL KACHAKO1','025',911838.50,'2022-09-12 19:28:14',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-14 21:58:23'),(45,'8','212','2022-09-13',1,'026','','5',664755.00,'43','','','6','TOTAL KACHAKO1','026',664756.80,'2022-09-13 21:14:06',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-14 21:58:23'),(46,'8','212','2022-09-14',1,'026','','5',544055.00,'44','','','6','TOTAL KACHAKO1','026',544053.60,'2022-09-14 19:43:57',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-17 07:47:03'),(47,'8','212','2022-09-15',1,'027','','5',525470.00,'45','','','6','TOTAL KACHAKO1','027',525469.70,'2022-09-15 18:56:21',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-17 07:51:21'),(48,'8','212','2022-09-16',1,'028','','5',462900.00,'46','','','6','TOTAL KACHAKO1','028',462902.70,'2022-09-16 20:09:58',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-23 08:24:47'),(49,'8','212','2022-09-17',1,'029','','5',241115.00,'47','','','6','TOTAL KACHAKO1','029',241117.60,'2022-09-17 22:29:05',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-21 14:58:45'),(50,'8','212','2022-09-18',1,'030','','5',1017680.00,'48','','','6','TOTAL KACHAKO1','030',1016728.00,'2022-09-18 19:30:38',5,'PAYMENT OF P.M.S','910','927','2022-09-23 08:47:46','927','2022-09-23 08:48:41'),(51,'8','212','2022-09-19',1,'031','','5',224505.00,'49','','','6','TOTAL KACHAKO1','031',224505.90,'2022-09-20 10:09:48',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-21 14:56:26'),(52,'8','212','2022-09-20',1,'032','','5',283995.00,'50','','','6','TOTAL KACHAKO1','032',283996.80,'2022-09-20 20:36:44',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-23 08:49:57'),(53,'8','212','2022-09-21',1,'033','','5',258730.00,'51','','','6','TOTAL KACHAKO1','033',258730.60,'2022-09-21 21:51:27',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-09-23 08:49:57'),(54,'8','212','2022-09-22',1,'033','','5',394385.00,'52','','','6','TOTAL KACHAKO1','033',394383.00,'2022-09-22 22:18:21',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-09-27 16:11:56'),(55,'8','212','2022-09-23',1,'034','','5',409360.00,'53','','','6','TOTAL KACHAKO1','034',409358.80,'2022-09-23 20:16:23',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-09-27 16:12:48'),(56,'8','212','2022-09-24',1,'034','','5',331855.00,'54','','','6','TOTAL KACHAKO1','034',331855.90,'2022-09-25 07:53:35',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-09-27 16:13:13'),(57,'8','212','2022-09-25',1,'035','','5',1931560.00,'55','','','6','TOTAL KACHAKO1','035',1931452.60,'2022-09-26 08:26:31',5,'PAYMENT OF P.M.S','910','927','2022-09-28 13:47:49','927','2022-09-28 13:48:25'),(58,'8','212','2022-09-26',1,'036','','5',536870.00,'56','','','6','TOTAL KACHAKO1','036',536869.70,'2022-09-27 08:11:52',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-09-29 21:11:24'),(59,'8','212','2022-09-27',1,'037','','5',271375.00,'57','','','6','TOTAL KACHAKO1','037',271375.10,'2022-09-27 19:28:40',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-09-29 21:12:53'),(60,'8','212','2022-09-28',1,'037','','5',236565.00,'58','','','6','TOTAL KACHAKO1','037',236563.30,'2022-09-28 22:19:45',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-09-29 21:13:26'),(61,'8','212','2022-09-29',1,'038','','5',401280.00,'59','','','6','TOTAL KACHAKO1','038',401278.10,'2022-09-29 19:21:48',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-03 11:33:22'),(62,'8','212','2022-09-30',1,'039','','5',476520.00,'60','','','6','TOTAL KACHAKO1','039',476518.10,'2022-09-30 20:53:45',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-03 11:33:22'),(63,'8','212','2022-10-01',1,'040','','5',337245.00,'61','','','6','TOTAL KACHAKO1','040',337244.30,'2022-10-01 20:58:32',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-07 13:49:38'),(64,'8','212','2022-10-02',1,'041','','5',1011330.00,'62','','','6','TOTAL KACHAKO1','041',1011330.10,'2022-10-02 19:17:24',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-03 11:33:22'),(65,'8','212','2022-10-03',1,'042','','5',228930.00,'63','','','6','TOTAL KACHAKO1','042',228930.00,'2022-10-04 06:20:33',5,'PAYMENT OF P.M.S','910','467','2022-10-04 15:36:48','927','2022-10-07 13:49:38'),(66,'8','212','2022-10-04',1,'043','','5',265235.00,'64','','','6','TOTAL KACHAKO1','043',265234.00,'2022-10-04 15:33:22',5,'PAYMENT OF P.M.S','910','467','2022-10-04 15:36:24','927','2022-10-07 13:48:37'),(67,'8','212','2022-10-04',1,'044','','5',40105.00,'65','','','6','TOTAL KACHAKO1','044',0.00,'2022-10-04 19:22:48',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-31 17:52:14'),(68,'8','212','2022-10-05',1,'045','','5',340645.00,'66','','','6','TOTAL KACHAKO1','045',340645.30,'2022-10-05 20:43:51',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-07 13:48:37'),(69,'8','212','2022-10-06',1,'046','','5',789900.00,'67','','','6','TOTAL KACHAKO1','046',789898.40,'2022-10-06 19:01:20',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-07 13:48:37'),(70,'8','212','2022-10-07',1,'047','','5',1347200.00,'68','','','6','TOTAL KACHAKO1','047',1347164.60,'2022-10-07 19:26:36',5,'PAYMENT OF P.M.S','910','927','2022-10-12 16:44:08','927','2022-10-12 16:44:35'),(71,'8','212','2022-10-08',1,'048','','5',1264290.00,'69','','','6','TOTAL KACHAKO1','048',1264266.00,'2022-10-08 22:05:44',5,'PAYMENT OF P.M.S','910','927','2022-11-02 14:09:43','927','2022-11-02 14:11:30'),(72,'8','212','2022-10-09',1,'049','','5',3219765.00,'70','','','6','TOTAL KACHAKO1','049',3219763.95,'2022-10-10 09:36:22',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-12 16:44:35'),(73,'8','212','2022-10-10',1,'050','','5',4990530.00,'71','','','6','TOTAL KACHAKO1','050',4990404.90,'2022-10-10 22:23:11',5,'PAYMENT OF P.M.S','910','927','2022-10-12 16:43:17','927','2022-10-12 16:43:47'),(74,'8','212','2022-10-11',1,'051','','5',2915960.00,'73','','','6','TOTAL KACHAKO1','051',2915958.84,'2022-10-12 18:52:44',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-17 14:27:37'),(75,'8','212','2022-10-12',1,'052','','5',2222650.00,'74','','','6','TOTAL KACHAKO1','052',2222646.80,'2022-10-12 20:20:24',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-17 14:27:37'),(78,'8','212','2022-10-15',1,'055','','5',1529805.00,'78','','','6','TOTAL KACHAKO1','055',1529804.25,'2022-10-20 13:33:25',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-10-24 21:55:51'),(79,'8','212','2022-10-16',1,'056','','5',2646260.00,'79','','','6','TOTAL KACHAKO1','056',2646258.75,'2022-10-20 13:38:56',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-20 14:14:23'),(80,'8','212','2022-10-17',1,'057','','5',1287095.00,'80','','','6','TOTAL KACHAKO1','057',1287094.50,'2022-10-20 13:59:07',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-24 15:00:49'),(81,'8','212','2022-10-20',1,'058','','5',2204815.00,'81','','','6','TOTAL KACHAKO1','058',2204814.50,'2022-10-20 18:56:16',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-02 13:39:42'),(82,'8','212','2022-10-21',1,'059','','5',1273040.00,'82','','','6','TOTAL KACHAKO1','059',1273040.80,'2022-10-21 19:25:48',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-24 15:00:49'),(83,'8','212','2022-10-22',1,'060','','5',1124830.00,'83','','','6','TOTAL KACHAKO1','060',1124827.50,'2022-10-22 20:35:04',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-24 15:00:49'),(84,'8','212','2022-10-23',1,'061','','5',1886895.00,'84','','','6','TOTAL KACHAKO1','061',1886894.90,'2022-10-23 18:34:28',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-24 15:00:49'),(85,'8','212','2022-10-24',1,'062','','5',886830.00,'85','','','6','TOTAL KACHAKO1','062',886826.55,'2022-10-25 11:15:21',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-27 10:35:27'),(86,'8','212','2022-10-25',1,'063','','5',2358435.00,'86','','','6','TOTAL KACHAKO1','063',2358434.15,'2022-10-25 20:17:15',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-27 10:35:27'),(87,'8','212','2022-10-26',1,'064','','5',929680.00,'88','','','6','TOTAL KACHAKO1','064',929680.00,'2022-10-27 05:25:08',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-27 10:35:27'),(88,'8','212','2022-10-27',1,'065','','5',1280640.00,'89','','','6','TOTAL KACHAKO1','065',1280637.50,'2022-10-28 07:48:46',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-31 17:46:45'),(89,'8','212','2022-10-28',1,'066','','5',1862450.00,'90','','','6','TOTAL KACHAKO1','066',1862450.00,'2022-10-28 19:58:16',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-10-31 17:48:04'),(90,'8','212','2022-10-14',1,'067','','5',2044955.00,'91','','','6','TOTAL KACHAKO1','067',2044955.00,'2022-11-02 16:58:56',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-09 13:03:20'),(91,'8','212','2022-10-08',1,'068','','5',1347200.00,'91','','','6','TOTAL KACHAKO1','068',1231887.00,'2022-11-02 17:12:49',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-09 13:03:20'),(92,'8','212','2022-10-13',1,'069','','5',2850330.00,'91','','','6','TOTAL KACHAKO1','069',2965630.00,'2022-11-02 17:17:14',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-09 13:06:45'),(93,'8','212','2022-10-30',1,'070','','5',1374200.00,'91','','','6','TOTAL KACHAKO1','070',1374487.50,'2022-11-04 20:44:20',5,'PAYMENT OF P.M.S','910','927','2022-11-09 13:06:00','927','2022-11-09 13:06:16'),(94,'8','212','2022-11-05',1,'071','','5',478020.00,'92','','','6','TOTAL KACHAKO1','071',478020.45,'2022-11-05 18:31:36',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-07 12:22:00'),(95,'8','212','2022-11-06',1,'072','','5',688500.00,'93','','','6','TOTAL KACHAKO1','072',688500.00,'2022-11-06 21:20:47',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-07 12:22:00'),(96,'8','212','2022-11-06',1,'073','','5',2098725.00,'94','','','6','TOTAL KACHAKO1','073',2098722.50,'2022-11-06 21:29:58',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-07 12:22:00'),(97,'8','212','2022-11-07',1,'074','','5',1308100.00,'95','','','6','TOTAL KACHAKO1','074',1308097.50,'2022-11-07 21:33:21',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-09 13:01:06'),(98,'8','212','2022-11-08',1,'075','','5',1504165.00,'96','','','6','TOTAL KACHAKO1','075',1504165.00,'2022-11-08 20:51:09',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-09 13:01:06'),(99,'8','212','2022-11-09',1,'076','','5',1786335.00,'97','','','6','TOTAL KACHAKO1','076',1786335.00,'2022-11-09 19:12:22',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-16 16:43:09'),(100,'8','212','2022-11-10',1,'077','','5',1773220.00,'98','','','6','TOTAL KACHAKO1','077',1773220.00,'2022-11-10 18:47:04',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-16 16:43:09'),(101,'8','212','2022-11-11',1,'078','','5',1671805.00,'99','','','6','TOTAL KACHAKO1','078',1671802.50,'2022-11-11 19:26:15',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-16 16:43:09'),(102,'8','212','2022-11-12',1,'079','','5',2025755.00,'100','','','6','TOTAL KACHAKO1','079',2025752.50,'2022-11-12 18:41:00',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-16 16:43:09'),(103,'8','212','2022-11-13',1,'080','','5',1644080.00,'101','','','6','TOTAL KACHAKO1','080',1644081.90,'2022-11-15 20:25:12',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-16 16:43:09'),(104,'8','212','2022-11-14',1,'081','','5',780280.00,'102','','','6','TOTAL KACHAKO1','081',780279.60,'2022-11-15 20:34:39',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-16 16:43:09'),(105,'8','212','2022-11-15',1,'082','','5',1462390.00,'103','','','6','TOTAL KACHAKO1','082',1462386.75,'2022-11-15 20:40:07',5,'PAYMENT OF P.M.S','910','927','2022-11-21 15:18:15','927','2022-11-21 15:21:22'),(106,'8','212','2022-11-16',1,'083','','5',1406845.00,'104','','','6','TOTAL KACHAKO1','083',1406837.55,'2022-11-17 13:03:41',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-19 05:59:35'),(107,'8','212','2022-11-17',1,'084','','5',1579050.00,'105','','','6','TOTAL KACHAKO1','084',1579046.70,'2022-11-18 12:18:15',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-21 14:46:34'),(108,'8','212','2022-11-18',1,'085','','5',1858445.00,'106','','','6','TOTAL KACHAKO1','085',1858442.55,'2022-11-18 19:04:05',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-21 14:46:34'),(109,'8','212','2022-11-19',1,'086','','5',1376200.00,'107','','','6','TOTAL KACHAKO1','086',1376199.30,'2022-11-20 06:57:34',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-21 14:46:34'),(110,'8','212','2022-11-20',1,'087','','5',2126710.00,'108','','','6','TOTAL KACHAKO1','087',2126707.65,'2022-11-20 19:56:12',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-11-24 13:52:35'),(111,'8','212','2022-11-21',1,'088','','5',208520.00,'109','','','6','TOTAL KACHAKO1','088',208521.15,'2022-11-22 21:16:25',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-11-24 13:52:03'),(112,'8','212','2022-11-22',1,'089','','5',849260.00,'110','','','6','TOTAL KACHAKO1','089',849259.65,'2022-11-23 08:04:09',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-11-24 13:51:44'),(113,'8','212','2022-11-23',1,'090','','5',1318415.00,'111','','','6','TOTAL KACHAKO1','090',1318413.75,'2022-11-24 07:42:50',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-25 17:51:39'),(114,'8','212','2022-11-24',1,'091','','5',1639765.00,'112','','','6','TOTAL KACHAKO1','091',1639764.75,'2022-11-25 09:35:31',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-25 17:51:39'),(115,'8','212','2022-11-25',1,'092','','5',1468850.00,'113','','','6','TOTAL KACHAKO1','092',1468851.00,'2022-11-25 19:02:08',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-28 16:18:54'),(116,'8','212','2022-11-26',1,'093','','5',701760.00,'114','','','6','TOTAL KACHAKO1','093',701760.80,'2022-11-27 08:39:00',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-28 16:18:54'),(117,'8','212','2022-11-27',1,'094','','5',2136035.00,'115','','','6','TOTAL KACHAKO1','094',2136035.20,'2022-11-27 18:41:00',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-11-28 16:18:54'),(118,'8','212','2022-11-28',1,'095','','5',328255.00,'116','','','6','TOTAL KACHAKO1','095',328177.20,'2022-12-03 14:49:58',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-05 13:18:43'),(119,'8','212','2022-12-01',1,'096','','5',1535140.00,'117','','','6','TOTAL KACHAKO1','096',1535214.20,'2022-12-03 14:56:32',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-05 13:18:43'),(120,'8','212','2022-12-02',1,'097','','5',3579520.00,'118','','','6','TOTAL KACHAKO1','097',3579516.20,'2022-12-03 15:01:57',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-05 13:19:27'),(121,'8','212','2022-12-03',1,'098','','5',1083715.00,'119','','','6','TOTAL KACHAKO1','098',1083712.50,'2022-12-03 18:59:30',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-05 13:19:27'),(122,'8','212','2022-12-04',1,'099','','5',1718240.00,'120','','','6','TOTAL KACHAKO1','099',1718236.80,'2022-12-05 10:13:52',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-12-08 17:03:16'),(123,'8','212','2022-12-05',1,'100','','5',491420.00,'121','','','6','TOTAL KACHAKO1','100',491421.60,'2022-12-06 06:05:24',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-12-08 17:03:31'),(124,'8','212','2022-12-06',1,'101','','5',2305960.00,'122','','','6','TOTAL KACHAKO1','101',2305959.30,'2022-12-06 20:04:22',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2022-12-08 17:04:07'),(125,'8','212','2022-12-07',1,'102','','5',2119050.00,'123','','','6','TOTAL KACHAKO1','102',2119063.85,'2022-12-07 22:05:58',5,'PAYMENT OF P.M.S','910','927','2022-12-18 22:06:03','927','2022-12-18 22:07:03'),(126,'8','212','2022-12-14',1,'103','','5',2304700.00,'124','','','6','TOTAL KACHAKO1','103',2304698.95,'2022-12-15 15:44:18',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-18 22:07:03'),(127,'8','212','2022-12-15',1,'104','','5',2143310.00,'125','','','6','TOTAL KACHAKO1','104',2143311.25,'2022-12-16 15:02:57',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-18 22:07:03'),(128,'8','212','2022-12-16',1,'105','','5',741015.00,'126','','','6','TOTAL KACHAKO1','105',741012.75,'2022-12-17 11:20:24',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-19 15:05:48'),(129,'8','212','2022-12-16',1,'106','','5',606030.00,'127','','','6','TOTAL KACHAKO1','106',606026.70,'2022-12-17 11:28:22',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-19 15:05:48'),(130,'8','212','2022-12-17',1,'107','','5',1085270.00,'128','','','6','TOTAL KACHAKO1','107',1085266.60,'2022-12-18 13:40:05',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-29 13:23:08'),(131,'8','212','2022-12-20',1,'108','','5',539545.00,'129','','','6','TOTAL KACHAKO1','108',539545.10,'2022-12-21 19:21:22',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-29 13:23:08'),(132,'8','212','2022-12-21',1,'109','','5',916600.00,'130','','','6','TOTAL KACHAKO1','109',916597.30,'2022-12-22 12:09:27',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2022-12-29 13:23:08'),(133,'8','212','2022-12-24',1,'110','','5',334970.00,'131','','','6','TOTAL KACHAKO1','110',335023.90,'2022-12-25 14:06:01',5,'PAYMENT OF P.M.S','910','927','2022-12-29 13:24:47','927','2022-12-29 13:25:02'),(134,'8','212','2022-12-27',1,'111','','5',392840.00,'132','','','6','TOTAL KACHAKO1','111',392764.25,'2022-12-28 11:48:21',5,'PAYMENT OF P.M.S','910','927','2023-01-03 17:19:22','927','2023-01-03 17:19:36'),(135,'8','212','2022-12-29',1,'112','','5',329550.00,'133','','','6','TOTAL KACHAKO1','112',329549.75,'2022-12-30 21:02:55',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2023-01-02 15:27:41'),(136,'8','212','2023-01-01',1,'113','','5',2156600.00,'134','','','6','TOTAL KACHAKO1','113',2156598.00,'2023-01-01 22:00:45',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2023-01-02 15:28:01'),(137,'8','212','2023-01-03',1,'114','','5',361525.00,'135','','','6','TOTAL KACHAKO1','114',361523.30,'2023-01-04 21:35:51',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-01-10 15:44:03'),(138,'8','212','2023-01-05',1,'115','','5',1250860.00,'136','','','6','TOTAL KACHAKO1','115',1250856.00,'2023-01-06 09:39:42',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-01-10 15:44:03'),(139,'8','212','2023-01-06',1,'116','','5',622590.00,'137','','','6','TOTAL KACHAKO1','116',622587.90,'2023-01-07 12:57:08',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-01-20 14:49:03'),(140,'8','212','2023-01-26',1,'117','','5',1714940.00,'138','','','6','TOTAL KACHAKO1','117',1714937.25,'2023-01-27 23:06:05',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-01-30 16:49:00'),(141,'8','212','2023-01-29',1,'118','','5',1930465.00,'139','','','6','TOTAL KACHAKO1','118',1930464.48,'2023-01-30 17:32:46',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-01-31 19:38:26'),(142,'8','212','2023-01-30',1,'119','','5',1083885.00,'140','','','6','TOTAL KACHAKO1','119',1083885.60,'2023-01-31 14:41:55',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-03 15:47:57'),(143,'8','212','2023-01-31',1,'120','','5',689210.00,'141','','','6','TOTAL KACHAKO1','120',689206.50,'2023-02-01 10:09:47',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-03 15:47:57'),(144,'8','212','2023-02-01',1,'121','','5',1154275.00,'142','','','6','TOTAL KACHAKO1','121',1154273.40,'2023-02-02 20:41:17',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-07 16:39:54'),(145,'8','212','2023-02-02',1,'122','','5',1618215.00,'143','','','6','TOTAL KACHAKO1','122',1618215.60,'2023-02-03 19:01:03',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-07 16:39:54'),(147,'8','212','2023-02-03',1,'123','','5',2461340.00,'144','','','6','TOTAL KACHAKO1','123',2461336.95,'2023-02-06 08:25:54',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-07 16:39:54'),(148,'8','212','2023-02-05',1,'124','','5',933210.00,'145','','','6','TOTAL KACHAKO1','124',933207.75,'2023-02-07 10:41:19',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-07 16:39:54'),(151,'8','212','2023-02-16',1,'125','','5',649900.00,'146','','','6','TOTAL KACHAKO1','125',1051497.90,'2023-02-16 20:45:00',5,'PAYMENT OF P.M.S','910','927','2023-03-01 15:01:49','927','2023-03-01 15:02:44'),(152,'8','212','2023-02-16',1,'126','','5',1498745.00,'147','','','6','TOTAL KACHAKO1','126',1498767.60,'2023-02-17 19:39:28',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-24 13:58:38'),(153,'8','212','2023-02-17',1,'127','','5',710405.00,'148','','','6','TOTAL KACHAKO1','127',710402.80,'2023-02-21 10:40:52',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-24 13:58:38'),(154,'8','212','2023-02-18',1,'128','','5',737710.00,'149','','','6','TOTAL KACHAKO1','128',737711.60,'2023-02-21 10:45:14',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-24 13:58:38'),(155,'8','212','2023-02-19',1,'129','','5',2162020.00,'150','','','6','TOTAL KACHAKO1','129',2162019.20,'2023-02-21 10:51:28',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-24 13:58:38'),(156,'8','212','2023-02-20',1,'130','','5',1137055.00,'151','','','6','TOTAL KACHAKO1','130',1137055.20,'2023-02-21 10:58:11',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-24 13:58:38'),(157,'8','212','2023-02-21',1,'131','','5',688730.00,'152','','','6','TOTAL KACHAKO1','131',688727.00,'2023-02-23 21:57:30',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-02-24 13:58:38'),(158,'8','212','2023-02-22',1,'132','','5',1156595.00,'153','','','6','TOTAL KACHAKO1','132',1156595.20,'2023-02-23 22:03:24',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-01 14:51:06'),(159,'8','212','2023-02-23',1,'133','','5',682280.00,'154','','','6','TOTAL KACHAKO1','133',682278.40,'2023-02-24 09:00:09',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-01 14:51:06'),(160,'8','212','2023-02-24',1,'134','','5',955340.00,'155','','','6','TOTAL KACHAKO1','134',955337.60,'2023-02-27 09:16:30',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-01 14:51:06'),(161,'8','212','2023-02-26',1,'135','','5',1905600.00,'156','','','6','TOTAL KACHAKO1','135',1905596.80,'2023-02-27 09:20:28',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-01 14:51:06'),(162,'8','212','2023-02-27',1,'136','','5',1000000.00,'157','','','6','TOTAL KACHAKO1','136',1000000.00,'2023-02-28 23:14:06',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-01 14:51:06'),(163,'8','212','2023-02-28',1,'137','','5',1051405.00,'158','','','6','TOTAL KACHAKO1','137',1051404.80,'2023-03-01 17:40:10',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-03 13:17:21'),(164,'8','212','2023-03-01',1,'138','','5',860580.00,'159','','','6','TOTAL KACHAKO1','138',860579.20,'2023-03-03 23:19:05',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2023-03-10 11:04:30'),(165,'8','212','2023-03-02',1,'139','','5',818010.00,'160','','','6','TOTAL KACHAKO1','139',840409.60,'2023-03-03 23:24:12',5,'PAYMENT OF P.M.S','910','927','2023-03-15 13:40:40','927','2023-03-15 13:40:51'),(166,'8','212','2023-03-03',1,'140','','5',1058995.00,'161','','','6','TOTAL KACHAKO1','140',1058994.00,'2023-03-04 23:03:57',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2023-03-10 11:02:57'),(167,'8','212','2023-03-04',1,'141','','5',887760.00,'162','','','6','TOTAL KACHAKO1','141',887757.00,'2023-03-06 17:42:02',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2023-03-10 11:02:18'),(168,'8','212','2023-03-05',1,'142','','5',1644355.00,'163','','','6','TOTAL KACHAKO1','142',1644354.00,'2023-03-06 17:45:57',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','465','2023-03-10 11:10:11'),(169,'8','212','2023-03-06',1,'143','','5',594585.00,'164','','','6','TOTAL KACHAKO1','143',594768.00,'2023-03-09 00:06:34',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-15 13:39:55'),(170,'8','212','2023-03-07',1,'144','','5',473320.00,'165','','','6','TOTAL KACHAKO1','144',473319.00,'2023-03-09 23:17:21',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-15 13:39:55'),(171,'8','212','2023-03-08',1,'145','','5',713025.00,'166','','','6','TOTAL KACHAKO1','145',713025.00,'2023-03-09 23:21:28',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-15 13:39:55'),(172,'8','212','2023-03-09',1,'146','','5',818980.00,'167','','','6','TOTAL KACHAKO1','146',818979.00,'2023-03-11 13:51:09',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-15 13:39:55'),(173,'8','212','2023-03-10',1,'147','','5',1181800.00,'168','','','6','TOTAL KACHAKO1','147',1181796.00,'2023-03-11 13:54:34',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-15 13:39:55'),(174,'8','212','2023-03-12',1,'148','','5',3009385.00,'169','','','6','TOTAL KACHAKO1','148',3009384.00,'2023-03-13 17:10:47',5,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','927','2023-03-15 13:39:55'),(175,'8','212','2023-03-13',1,'149','','5',1086235.00,'170','','','6','TOTAL KACHAKO1','149',1086264.00,'2023-03-18 13:45:44',0,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(176,'8','212','2023-03-14',1,'150','','5',992755.00,'171','','','6','TOTAL KACHAKO1','150',992754.00,'2023-03-18 13:49:35',0,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(177,'8','212','2023-03-15',1,'151','','5',1046920.00,'172','','','6','TOTAL KACHAKO1','151',1046916.00,'2023-03-18 13:54:13',0,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(178,'8','212','2023-03-16',1,'152','','5',1136550.00,'173','','','6','TOTAL KACHAKO1','152',1136550.00,'2023-03-18 13:59:50',0,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(179,'8','212','2023-03-17',1,'153','','5',966655.00,'174','','','6','TOTAL KACHAKO1','153',966654.00,'2023-03-20 08:48:13',0,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(180,'8','212','2023-03-19',1,'154','','5',3211365.00,'175','','','6','TOTAL KACHAKO1','154',3211365.30,'2023-03-20 13:17:34',0,'PAYMENT OF P.M.S','910','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (7,'8',5,'212',1,1,'2022-08-11 00:00:00','AA RANO LAGOS',1000.00,1000.00,0.00,'23456','','1','RAN 32 XF','ISAH','07043189737','DISCHARGE OF PMS',5,'2022-08-11 15:40:04','927','0000-00-00 00:00:00','','2022-08-12 19:58:22','910'),(8,'8',5,'212',1,1,'2022-08-11 00:00:00','AA RANO LAGOS',28850.00,28850.00,0.00,'23456','','2','RAN 32 XF','ISAH','07043189737','DISCHARGE OF PMS',5,'2022-08-11 15:40:04','927','0000-00-00 00:00:00','','2022-08-12 19:58:22','910'),(9,'8',6,'212',1,1,'2022-08-12 00:00:00','A A RANO',17000.00,17000.00,0.00,'00023','','1','BCH-424-XA','ARAMMA','07038288822','DELIVERY OF P.M.S',5,'2022-08-12 20:57:15','910','0000-00-00 00:00:00','','2022-08-12 21:00:32','910'),(10,'8',7,'212',1,1,'2022-08-23 00:00:00','A A RANO',15500.00,15250.00,0.00,'00030','','1','NSR-57-ZQ','MALAM ALI','07043189737','DELIVERY OF P.M.S',2,'2022-08-23 14:02:49','910','2022-08-23 14:14:32','467','2022-08-23 14:04:03','467'),(12,'8',7,'212',1,1,'2022-08-23 00:00:00','A A RANO',15250.00,15250.00,0.00,'00030','','1','NSR-57-ZQ','MALAM ALI','07043189737','DELIVERY OF P.M.S',5,'2022-08-23 14:11:21','910','0000-00-00 00:00:00','','2022-08-23 14:14:58','467'),(13,'8',7,'212',1,1,'2022-08-23 00:00:00','A A RANO',15000.00,15000.00,0.00,'00030','','2','NSR-57-ZQ','MALAM ALI','07043189737','DELIVERY OF P.M.S',5,'2022-08-23 14:11:21','910','0000-00-00 00:00:00','','2022-08-23 14:15:16','467'),(14,'8',8,'212',1,1,'2022-09-06 00:00:00','TOTAL LAGOS',17900.00,17900.00,0.00,'00036','','1','WDL-813-XA','MEDABAM','08065000870','DELIVERY OF P.M.S',5,'2022-09-06 11:31:29','910','0000-00-00 00:00:00','','2022-09-06 17:57:41','927'),(15,'8',8,'212',1,1,'2022-09-06 00:00:00','TOTAL LAGOS',15300.00,15300.00,0.00,'00036','','2','WDL-813-XA','MEDABAM','08065000870','DELIVERY OF P.M.S',5,'2022-09-06 11:31:29','910','0000-00-00 00:00:00','','2022-09-08 13:34:21','927'),(16,'8',9,'212',1,1,'2022-09-17 00:00:00','A A RANO',16900.00,16900.00,0.00,'0001','','1','NSR-433-ZS','AUWAL','09028469012','DELIVERY OF P.M.S',5,'2022-09-17 22:24:26','910','0000-00-00 00:00:00','','2022-09-20 12:27:20','927'),(17,'8',9,'212',1,1,'2022-09-17 00:00:00','A A RANO',17000.00,17000.00,0.00,'0001','','2','NSR-433-ZS','AUWAL','09028469012','DELIVERY OF P.M.S',5,'2022-09-17 22:24:26','910','0000-00-00 00:00:00','','2022-09-21 14:55:21','927'),(18,'8',10,'212',1,1,'2022-09-27 00:00:00','A A RANO',18850.00,18850.00,0.00,'00046','','1','RAN-31-XF','SHAFI\'U','08032528608','DELIVERY OF P.M.S',5,'2022-09-27 19:23:36','910','0000-00-00 00:00:00','','2022-09-28 10:09:12','927'),(19,'8',10,'212',1,1,'2022-09-27 00:00:00','A A RANO',14150.00,14150.00,0.00,'00046','','2','RAN-31-XF','SHAFI\'U','08032528608','DELIVERY OF P.M.S',5,'2022-09-27 19:23:36','910','0000-00-00 00:00:00','','2022-09-28 10:09:24','927'),(20,'8',11,'212',1,1,'2022-10-08 00:00:00','TOTAL LAGOS',7250.00,7250.00,0.00,'00047','','1','BCH-428-XA','LURWAN YELLOW','08034997784','DELIVERY OF P.M.S',5,'2022-10-08 21:36:01','910','0000-00-00 00:00:00','','2022-10-08 22:38:09','927'),(21,'8',11,'212',1,1,'2022-10-08 00:00:00','TOTAL LAGOS',9450.00,9450.00,0.00,'00047','','2','BCH-428-XA','LURWAN YELLOW','08034997784','DELIVERY OF P.M.S',5,'2022-10-08 21:36:01','910','0000-00-00 00:00:00','','2022-10-08 22:38:29','927'),(22,'8',12,'212',1,1,'2022-10-12 00:00:00','TOTAL LAGOS',32100.00,32100.00,0.00,'00047','','1','RAN-33-XF','ABDULLAHI','09066536097','DELIVERY OF P.M.S',5,'2022-10-12 07:19:59','910','0000-00-00 00:00:00','','2022-10-12 16:41:16','927'),(23,'8',12,'212',1,1,'2022-10-12 00:00:00','TOTAL LAGOS',17900.00,17900.00,0.00,'00047','','2','RAN-33-XF','ABDULLAHI','09066536097','DELIVERY OF P.M.S',5,'2022-10-12 07:19:59','910','0000-00-00 00:00:00','','2022-10-12 16:41:31','927'),(24,'8',13,'212',1,1,'2022-10-15 00:00:00','TOTAL LAGOS',17000.00,17000.00,0.00,'00049','','1','BCH-424-XA','ARAMMA','07038288822','DELIVERY OF P.M.S',5,'2022-10-15 20:05:02','910','0000-00-00 00:00:00','','2022-10-20 11:31:51','927'),(25,'8',14,'212',1,1,'2022-10-20 00:00:00','TOTAL LAGOS',17300.00,17300.00,0.00,'0056','','1','WDL-813-XA','MEDABAM','08065000870','DELIVERY OF P.M.S',5,'2022-10-20 07:55:18','910','0000-00-00 00:00:00','','2022-10-20 13:55:49','467'),(26,'8',14,'212',1,1,'2022-10-20 00:00:00','TOTAL LAGOS',14700.00,14700.00,0.00,'0056','','2','WDL-813-XA','MEDABAM','08065000870','DELIVERY OF P.M.S',5,'2022-10-20 07:55:18','910','0000-00-00 00:00:00','','2022-10-20 11:32:18','927'),(27,'8',16,'212',1,1,'2022-10-25 00:00:00','TOTAL LAGOS',17000.00,17000.00,0.00,'00569','','1','RAN-869-XA','USMAN','07066507909','DELIVERY OF P.M.S',5,'2022-10-25 07:50:50','910','0000-00-00 00:00:00','','2022-10-25 11:10:24','910'),(28,'8',16,'212',1,1,'2022-10-25 00:00:00','TOTAL LAGOS',16000.00,16000.00,0.00,'00569','','2','RAN-869-XA','USMAN','07066507909','DELIVERY OF P.M.S',5,'2022-10-25 07:50:50','910','0000-00-00 00:00:00','','2022-10-25 11:10:24','910'),(29,'8',17,'212',1,1,'2022-11-04 00:00:00','TOTAL LAGOS',17000.00,17000.00,0.00,'00679','','1','RAN-31-XF','SHAFI\'U','08032528608','DELIVERY OF P.M.S',5,'2022-11-04 20:35:02','910','0000-00-00 00:00:00','','2022-11-04 20:37:37','910'),(30,'8',17,'212',1,1,'2022-11-04 00:00:00','TOTAL LAGOS',16000.00,16000.00,0.00,'00679','','2','RAN-31-XF','SHAFI\'U','08032528608','DELIVERY OF P.M.S',5,'2022-11-04 20:35:02','910','0000-00-00 00:00:00','','2022-11-04 20:37:37','910'),(31,'8',18,'212',1,1,'2022-11-05 00:00:00','TOTAL LAGOS',8200.00,8200.00,0.00,'00089','','1','RAN-32-XF','ISAH ','07063462050','',5,'2022-11-05 13:15:21','910','0000-00-00 00:00:00','','2022-11-05 13:17:11','910'),(32,'8',18,'212',1,1,'2022-11-05 00:00:00','TOTAL LAGOS',8800.00,8800.00,0.00,'00089','','2','RAN-32-XF','ISAH ','07063462050','',5,'2022-11-05 13:15:21','910','0000-00-00 00:00:00','','2022-11-05 13:17:11','910'),(33,'8',19,'212',1,1,'2022-11-12 00:00:00','A A RANO',16700.00,16700.00,0.00,'00048','','2','BCH-428-XA','LURWAN YELLOW','08034997784','DELIVERY OF P.M.S',5,'2022-11-12 18:35:01','910','0000-00-00 00:00:00','','2022-11-12 18:36:24','910'),(34,'8',20,'212',1,1,'2022-11-15 00:00:00','TOTAL LAGOS',17000.00,17000.00,0.00,'00089','','1','RAN-869-XA','USMAN','07066507909','DELIVERY OF P.M.S',5,'2022-11-15 20:17:04','910','0000-00-00 00:00:00','','2022-11-15 20:18:12','910'),(35,'8',21,'212',1,1,'2022-11-17 00:00:00','TOTAL LAGOS',17000.00,17000.00,0.00,'00078','','2','BCH-424-XA','ARAMMA','07038288822','DELIVERY OF P.M.S',5,'2022-11-17 12:55:03','910','0000-00-00 00:00:00','','2022-11-17 12:56:30','910'),(36,'8',22,'212',1,1,'2022-11-22 00:00:00','TOTAL LAGOS',17000.00,17000.00,0.00,'00049','','1','RAN-31-XF','SHAFI\'U','08032528608','DELIVERY OF P.M.S',5,'2022-11-22 21:08:43','910','0000-00-00 00:00:00','','2022-11-22 21:10:20','910'),(37,'8',22,'212',1,1,'2022-11-22 00:00:00','TOTAL LAGOS',16000.00,16000.00,0.00,'00049','','2','RAN-31-XF','SHAFI\'U','08032528608','DELIVERY OF P.M.S',5,'2022-11-22 21:08:43','910','0000-00-00 00:00:00','','2022-11-22 21:10:20','910'),(38,'8',23,'212',1,1,'2022-12-01 00:00:00','TOTAL LAGOS',32000.00,32000.00,0.00,'00597','','2','NSR-435-ZS','ALH. GAMBO ','07033279868','DELIVERY OF P.M.S',5,'2022-12-01 18:38:43','910','0000-00-00 00:00:00','','2022-12-01 18:40:11','910'),(39,'8',25,'212',1,1,'2022-12-03 00:00:00','TOTAL LAGOS',1000.00,1000.00,0.00,'00047','','1','NSR-57-ZQ','BASHIR ','08036563766','DELIVERY OF P.M.S',5,'2022-12-03 14:42:41','910','0000-00-00 00:00:00','','2022-12-03 14:44:06','910'),(45,'8',26,'212',1,1,'2022-12-06 00:00:00','TOTAL LAGOS',16000.00,16000.00,0.00,'00045','','1','RAN-32-XF','I SAH','07063462050','',5,'2022-12-06 19:50:34','910','0000-00-00 00:00:00','','2022-12-06 19:53:07','910'),(46,'8',27,'212',1,1,'2022-12-15 00:00:00','TOTAL LAGOS',15000.00,15000.00,0.00,'00039','','1','DZW-549-XA','SAGIRU','08035647129','',5,'2022-12-15 15:37:23','910','0000-00-00 00:00:00','','2022-12-15 15:39:05','910'),(47,'8',27,'212',1,1,'2022-12-15 00:00:00','TOTAL LAGOS',29550.00,29550.00,0.00,'00039','','2','DZW-549-XA','SAGIRU','08035647129','',5,'2022-12-15 15:37:23','910','0000-00-00 00:00:00','','2022-12-15 15:39:05','910'),(48,'8',28,'212',1,1,'2022-12-22 00:00:00','TOTAL LAGOS ',18000.00,18000.00,0.00,'00445','','2','WDL-813-XA','MEDABAM','08065000870','',5,'2022-12-22 12:04:46','910','0000-00-00 00:00:00','','2022-12-22 12:05:18','910'),(49,'8',29,'212',1,1,'2022-12-23 00:00:00','TOTAL LAGOS ',16500.00,16500.00,0.00,'00446','','1','RAN-33-XF','ABDULLAHI ','09066536097','DELIVERY OF P.M.S',5,'2022-12-23 19:19:56','910','0000-00-00 00:00:00','','2022-12-23 19:20:23','910'),(50,'8',30,'212',1,1,'2023-01-06 00:00:00','TOTAL LAGOS ',15900.00,15900.00,0.00,'00447','','1','NSR-572-ZS','ALH. BUHARI ','08024460069','DELIVERY OF P.M.S',5,'2023-01-06 09:33:49','910','0000-00-00 00:00:00','','2023-01-06 09:34:13','910'),(51,'8',31,'212',1,1,'2023-02-16 00:00:00','A A RANO',14500.00,14500.00,0.00,'0082','','1','K.M.C-62-ZB','YUSUF','08035051702','DELIVERY OF P.M.S',5,'2023-02-16 19:38:53','910','0000-00-00 00:00:00','','2023-02-16 19:51:17','910'),(52,'8',31,'212',1,1,'2023-02-16 00:00:00','A A RANO',30500.00,30500.00,0.00,'0082','','2','K.M.C-62-ZB','YUSUF','08035051702','DELIVERY OF P M S',5,'2023-02-16 19:38:53','910','0000-00-00 00:00:00','','2023-02-16 19:51:17','910'),(53,'8',32,'212',1,1,'2023-02-24 00:00:00','A A RANO',16800.00,16800.00,0.00,'00478','','1','BCH-428-XA','LURWANU ','08034997784','DELIVERY OF P.M.S',5,'2023-02-24 16:26:59','910','0000-00-00 00:00:00','','2023-02-27 09:11:36','910'),(54,'8',33,'212',1,1,'2023-03-09 00:00:00','A A RANO',17700.00,17700.00,0.00,'0049','','1','JMT-511-ZY','ALH.DANLAMI','08035585607','DELIVERY OF P.M.S',5,'2023-03-09 20:55:02','910','0000-00-00 00:00:00','','2023-03-09 20:55:56','910'),(55,'8',33,'212',1,1,'2023-03-09 00:00:00','A A RANO',16300.00,16300.00,0.00,'0049','','2','JMT-511-ZY','ALH.DANLAMI','08035585607','DELIVERY OF P M S',5,'2023-03-09 20:55:02','910','0000-00-00 00:00:00','','2023-03-09 20:55:56','910'),(56,'8',34,'212',1,1,'2023-03-20 00:00:00','A A RANO',18000.00,18000.00,0.00,'0050','','1','RAN-441-XA','MEDABAM','08065000870','DELIVERY OF P.M.S',5,'2023-03-20 08:37:49','910','0000-00-00 00:00:00','','2023-03-20 08:42:04','910'),(57,'8',34,'212',1,1,'2023-03-20 00:00:00','A A RANO',17000.00,17000.00,0.00,'0050','','2','RAN-441-XA','MEDABAM','08065000870','DELIVERY OF P M S',5,'2023-03-20 08:37:49','910','0000-00-00 00:00:00','','2023-03-20 08:42:04','910');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'8','212','Lausu Energy Resources','Babangida Bashir','08063654848','babangida@lausuenergy.com','KANO','KANO','Lausu Energy Head Office Hotoro Kano.','Nigeria',0.00,0.00,'0000-00-00','2022-07-17 08:39:58',5,'910','2022-07-17 08:39:58','910');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:57:12
