-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_8_station_211
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_8_station_211`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_8_station_211` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_8_station_211`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,4000,'',0,'22','8','211','PURCHASES','','2022-08-06 09:30:32',5,0.00,0.00,'','926','2022-08-06 09:30:32','926',0,0),(2,7000,'',0,'20','8','211','SALES','','2022-08-06 09:30:44',5,0.00,0.00,'','926','2022-08-06 09:30:44','926',0,0),(3,8000,'',0,'24','8','211','PURCHASES','','2022-08-06 09:31:01',5,0.00,0.00,'','926','2022-08-06 09:31:01','926',0,0),(4,8001,'',0,'24','8','211','SALARIES & WAGES','','2022-08-06 09:31:13',5,0.00,0.00,'','926','2022-08-06 09:31:13','926',0,0),(5,500,'',0,'6.1','8','211','CASH','','2022-08-06 09:31:29',5,0.00,0.00,'','926','2022-08-06 09:31:29','926',0,0),(6,2500,'',0,'2','8','211','UBA-0039769388','','2022-08-06 09:32:03',5,0.00,0.00,'','926','2022-08-06 09:32:03','926',0,0),(7,2501,'',0,'2','8','211','Keystone-1009080913','','2022-08-06 09:32:17',5,0.00,0.00,'','926','2022-08-06 09:32:17','926',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('8','211','1',1,'5','PMS PUMP 4',1362826.07,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-09 13:27:04','924'),('8','211','1',2,'5','PMS PUMP 5',2510501.78,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-09 13:28:41','924'),('8','211','1',3,'5','PMS PUMP 6',664641.49,'PMS DISPENSER.','',NULL,NULL,'',5,'2022-08-09 13:31:48','924'),('8','211','2',4,'5','PMS PUMP 4B',0.00,'PMS DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('8','211','2',5,'5','PMS PUMP 5B',0.00,'PMS DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('8','211','2',6,'5','PMS PUMP 6B',0.00,'PMS DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('8','211','3',7,'5','AGO PUMP 7',0.00,'AGO DISPENSER.',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('8','211',1,'Daily shift','2022-08-10','2022-08-10 08:56:22','2022-08-11 08:56:22','924',462462.85,462462.85,'924','2022-08-10 09:00:20','467','2022-08-10 09:52:20',10,0),('8','211',2,'Daily shift','2022-08-11','2022-08-11 11:36:14','2022-08-12 11:36:14','924',865957.65,865957.65,'924','2022-08-11 11:44:59','928','2022-08-11 14:19:51',10,0),('8','211',3,'Daily shift','2022-08-12','2022-08-12 07:35:48','2022-08-13 07:35:48','924',934420.10,934420.10,'924','2022-08-12 07:38:52','924','2022-08-13 10:05:21',10,0),('8','211',4,'Daily shift','2022-08-13','2022-08-13 10:06:47','2022-08-14 10:06:47','924',1104633.45,1104633.45,'924','2022-08-13 10:10:53','924','2022-08-13 10:11:24',10,0),('8','211',5,'Daily shift','2022-08-14','2022-08-14 09:51:08','2022-08-15 09:51:08','924',777268.00,777268.00,'924','2022-08-14 09:54:52','924','2022-08-14 09:55:57',10,0),('8','211',6,'Daily shift','2022-08-15','2022-08-15 08:38:14','2022-08-16 08:38:14','924',2483153.25,2483153.25,'924','2022-08-15 08:40:29','924','2022-08-15 09:00:36',10,0),('8','211',7,'Daily shift','2022-08-16','2022-08-16 08:05:54','2022-08-17 08:05:54','924',682167.05,682167.05,'924','2022-08-16 08:08:10','924','2022-08-16 20:26:19',10,0),('8','211',8,'Daily shift','2022-08-16','2022-08-19 19:33:54','2022-08-20 19:33:54','924',985983.55,949295.79,'924','2022-08-19 19:39:33','924','2022-08-19 19:41:46',10,0),('8','211',9,'Daily shift','2022-08-17','2022-08-19 19:44:39','2022-08-20 19:44:39','924',645144.05,621138.69,'924','2022-08-19 19:51:49','924','2022-08-19 19:56:03',10,0),('8','211',10,'Daily shift','2022-08-18','2022-08-19 19:58:16','2022-08-20 19:58:16','924',575097.05,553698.09,'924','2022-08-19 20:00:09','924','2022-08-19 20:00:36',10,0),('8','211',11,'Daily shift','2022-08-19','2022-08-19 20:02:00','2022-08-20 20:02:00','924',529437.50,509737.50,'924','2022-08-21 10:30:59','924','2022-08-21 10:32:07',10,0),('8','211',12,'Daily shift','2022-08-21','2022-08-21 12:08:08','2022-08-22 12:08:08','924',761428.95,733096.71,'924','2022-08-21 12:10:38','924','2022-08-21 12:34:19',10,0),('8','211',13,'Daily shift','2022-08-22','2022-08-22 08:13:26','2022-08-23 08:13:26','924',2129467.50,1980900.00,'924','2022-08-22 08:15:47','924','2022-08-23 10:36:53',10,0),('8','211',14,'Daily shift','2022-08-24','2022-08-24 09:26:04','2022-08-25 09:26:04','924',639100.00,639100.00,'924','2022-08-24 14:08:01','924','2022-08-24 16:58:34',10,0),('8','211',15,'DAILY','2022-08-24','2022-08-24 17:03:51','2022-08-31 17:03:51','926',0.00,0.00,'924','2022-08-25 08:38:28','924','2022-08-25 08:39:02',10,0),('8','211',16,'Daily shift','2022-08-25','2022-08-25 08:39:40','2022-08-26 08:39:40','924',662386.00,645826.35,'924','2022-08-25 08:41:02','924','2022-08-25 08:41:21',10,0),('8','211',17,'Daily shift','2022-08-26','2022-08-26 09:54:01','2022-08-27 09:54:01','924',675460.00,658573.50,'924','2022-08-26 09:57:41','924','2022-08-26 09:57:58',10,0),('8','211',18,'Daily shift','2022-08-27','2022-08-27 08:14:23','2022-08-28 08:14:23','924',684824.00,667703.40,'924','2022-08-27 08:15:49','924','2022-08-27 08:16:22',10,0),('8','211',19,'Daily shift','2022-08-28','2022-08-28 10:17:31','2022-08-29 10:17:31','924',706368.00,688708.80,'924','2022-08-28 10:19:55','924','2022-08-28 10:20:28',10,0),('8','211',20,'Daily shift','2022-08-29','2022-08-29 09:13:43','2022-08-30 09:13:43','924',1698224.00,1655768.40,'924','2022-08-29 09:15:17','924','2022-08-29 09:15:48',10,0),('8','211',21,'Daily shift','2022-08-30','2022-08-30 08:03:23','2022-08-31 08:03:23','924',924930.00,901806.75,'924','2022-08-30 08:04:40','924','2022-08-30 08:05:01',10,0),('8','211',22,'Daily shift','2022-08-31','2022-08-31 07:33:46','2022-09-01 07:33:46','924',908494.00,885781.65,'924','2022-08-31 07:37:55','924','2022-08-31 07:38:21',10,0),('8','211',23,'Daily shift','2022-09-01','2022-09-01 10:11:31','2022-09-02 10:11:31','924',700695.45,700695.45,'924','2022-09-01 10:13:17','924','2022-09-01 10:13:50',10,0),('8','211',24,'Daily shift','2022-09-02','2022-09-02 09:10:41','2022-09-03 09:10:41','924',617908.20,617908.20,'924','2022-09-02 09:15:02','924','2022-09-02 09:15:25',10,0),('8','211',25,'Daily shift','2022-09-03','2022-09-03 07:46:17','2022-09-04 07:46:17','924',749090.55,749090.55,'924','2022-09-03 07:48:44','924','2022-09-03 07:49:04',10,0),('8','211',26,'Daily shift','2022-09-04','2022-09-04 10:14:01','2022-09-05 10:14:01','924',889902.00,889902.00,'924','2022-09-04 10:15:57','924','2022-09-04 10:16:34',10,0),('8','211',27,'Daily shift','2022-09-05','2022-09-05 09:06:50','2022-09-06 09:06:50','924',1770083.25,1770083.25,'924','2022-09-05 09:08:18','924','2022-09-05 09:08:37',10,0),('8','211',28,'Daily shift','2022-09-06','2022-09-06 08:42:15','2022-09-07 08:42:15','924',768444.30,768444.30,'924','2022-09-06 08:43:51','924','2022-09-06 08:44:32',10,0),('8','211',29,'Daily shift','2022-09-07','2022-09-07 08:36:28','2022-09-08 08:36:28','924',776160.45,756258.90,'924','2022-09-07 08:37:45','924','2022-09-07 08:38:06',10,0),('8','211',30,'Daily shift','2022-09-08','2022-09-08 09:39:42','2022-09-09 09:39:42','924',729407.25,710704.50,'924','2022-09-08 09:41:23','924','2022-09-08 09:41:43',10,0),('8','211',31,'Daily shift','2022-09-09','2022-09-09 08:54:07','2022-09-10 08:54:07','924',909257.70,885943.40,'924','2022-09-09 08:55:13','924','2022-09-09 08:55:37',10,0),('8','211',32,'Daily shift','2022-09-10','2022-09-10 10:59:22','2022-09-11 10:59:22','924',942577.35,918408.70,'924','2022-09-10 11:00:47','924','2022-09-10 11:01:38',10,0),('8','211',33,'Daily shift','2022-09-11','2022-09-11 09:02:54','2022-09-12 09:02:54','924',953731.60,953731.60,'924','2022-09-11 09:08:24','924','2022-09-11 09:09:30',10,0),('8','211',34,'Daily shift','2022-09-12','2022-09-12 09:28:26','2022-09-13 09:28:26','924',1965071.20,1965071.20,'924','2022-09-12 09:29:54','924','2022-09-12 09:30:22',10,0),('8','211',35,'Daily shift','2022-09-13','2022-09-13 09:09:13','2022-09-14 09:09:13','924',826655.80,826655.80,'924','2022-09-13 09:10:49','924','2022-09-13 09:11:22',10,0),('8','211',36,'Daily shift','2022-09-14','2022-09-14 09:19:57','2022-09-15 09:19:57','924',955392.20,955392.20,'924','2022-09-14 09:21:57','924','2022-09-14 09:22:32',10,0),('8','211',37,'Daily shift','2022-09-15','2022-09-15 08:30:26','2022-09-16 08:30:26','924',677038.40,677038.40,'924','2022-09-15 08:32:52','924','2022-09-15 08:33:35',10,0),('8','211',38,'Daily shift','2022-09-16','2022-09-16 07:58:41','2022-09-17 07:58:41','924',808953.50,808953.50,'924','2022-09-16 07:59:45','924','2022-09-16 08:00:19',10,0),('8','211',39,'Daily shift','2022-09-17','2022-09-17 08:38:06','2022-09-18 08:38:06','924',703072.20,703072.20,'924','2022-09-17 08:40:39','924','2022-09-17 08:41:17',10,0),('8','211',40,'Daily shift','2022-09-18','2022-09-18 09:30:17','2022-09-19 09:30:17','924',712969.30,712969.30,'924','2022-09-18 09:31:19','924','2022-09-18 09:31:36',10,0),('8','211',41,'Daily shift','2022-09-20','2022-09-20 09:43:11','2022-09-21 09:43:11','924',1622275.10,1622275.10,'924','2022-09-20 09:45:47','924','2022-09-20 09:46:36',10,0),('8','211',42,'Daily shift','2022-09-20','2022-09-20 09:48:31','2022-09-21 09:48:31','924',616671.60,616671.60,'924','2022-09-20 09:50:36','924','2022-09-20 09:51:17',10,0),('8','211',43,'Daily shift','2022-09-21','2022-09-21 09:21:31','2022-09-22 09:21:31','924',704088.70,704088.70,'924','2022-09-21 09:22:47','924','2022-09-21 09:23:19',10,0),('8','211',44,'Daily shift','2022-09-22','2022-09-22 08:32:00','2022-09-23 08:32:00','924',849016.90,849016.90,'924','2022-09-22 08:33:33','924','2022-09-22 08:34:50',10,0),('8','211',45,'Daily shift','2022-09-23','2022-09-23 08:17:38','2022-09-24 08:17:38','924',576745.00,576745.00,'924','2022-09-23 08:19:17','924','2022-09-23 08:20:10',10,0),('8','211',46,'Daily shift','2022-09-24','2022-09-24 07:41:11','2022-09-25 07:41:11','924',676781.90,676781.90,'924','2022-09-24 07:44:24','924','2022-09-24 07:45:14',10,0),('8','211',47,'Daily shift','2022-09-25','2022-09-25 10:08:45','2022-09-26 10:08:45','924',684801.80,684801.80,'924','2022-09-25 10:10:07','924','2022-09-25 10:10:43',10,0),('8','211',48,'Daily shift','2022-09-26','2022-09-26 09:07:58','2022-09-27 09:07:58','924',1933080.90,1933080.90,'924','2022-09-26 09:09:10','924','2022-09-26 09:09:35',10,0),('8','211',49,'Daily shift','2022-09-27','2022-09-27 08:10:50','2022-09-28 08:10:50','924',863489.20,863489.20,'924','2022-09-27 08:12:03','924','2022-09-27 08:13:07',10,0),('8','211',50,'Daily shift','2022-09-28','2022-09-28 08:24:49','2022-09-29 08:24:49','924',838369.30,838369.30,'924','2022-09-28 08:26:23','924','2022-09-28 08:27:00',10,0),('8','211',51,'Daily shift','2022-09-29','2022-09-29 07:16:42','2022-09-30 07:16:42','924',1070422.00,1070422.00,'924','2022-09-29 07:18:19','924','2022-09-29 07:19:40',10,0),('8','211',52,'Daily shift','2022-09-30','2022-09-30 07:41:17','2022-10-01 07:41:17','924',931163.40,931163.40,'924','2022-09-30 07:43:57','924','2022-09-30 07:44:30',10,0),('8','211',53,'Daily shift','2022-10-01','2022-10-01 07:02:19','2022-10-02 07:02:19','924',884700.80,884700.80,'924','2022-10-01 07:03:23','924','2022-10-01 07:03:43',10,0),('8','211',54,'Daily shift','2022-10-02','2022-10-02 08:52:05','2022-10-03 08:52:05','924',780362.30,780362.30,'924','2022-10-02 08:54:58','924','2022-10-02 08:55:25',10,0),('8','211',55,'Daily shift','2022-10-03','2022-10-03 09:12:25','2022-10-04 09:12:25','924',1804671.30,1804671.30,'924','2022-10-03 09:13:26','924','2022-10-03 09:14:36',10,0),('8','211',56,'Daily shift','2022-10-03','2022-10-03 13:19:40','2022-10-04 13:19:40','924',491925.20,491925.20,'924','2022-10-03 13:26:18','924','2022-10-03 13:26:43',10,0),('8','211',57,'Daily shift','2022-10-04','2022-10-04 08:48:57','2022-10-05 08:48:57','924',346297.80,346297.80,'924','2022-10-04 08:50:14','924','2022-10-04 08:50:50',10,0),('8','211',58,'Daily shift','2022-10-05','2022-10-05 10:08:31','2022-10-06 10:08:31','924',876633.40,876633.40,'924','2022-10-05 10:09:53','924','2022-10-05 10:10:15',10,0),('8','211',59,'Daily shift','2022-10-06','2022-10-06 08:30:51','2022-10-07 08:30:51','924',1179624.50,1179624.50,'924','2022-10-06 08:33:47','924','2022-10-06 08:34:52',10,0),('8','211',60,'Daily shift','2022-10-08','2022-10-08 08:26:31','2022-10-09 08:26:31','924',2005858.50,2005858.50,'924','2022-10-08 10:34:02','924','2022-10-08 10:34:39',10,0),('8','211',61,'Daily shift','2022-10-09','2022-10-09 10:41:41','2022-10-16 10:41:41','924',3309372.50,3535803.25,'924','2022-10-09 10:43:08','924','2022-10-09 10:43:39',10,0),('8','211',62,'Daily shift','2022-10-10','2022-10-10 08:38:59','2022-10-17 08:38:59','924',1128632.30,1205854.51,'924','2022-10-10 08:40:35','924','2022-10-10 08:41:14',10,0),('8','211',63,'Daily shift','2022-10-11','2022-10-11 10:50:46','2022-10-12 10:50:46','924',2757781.39,2757781.39,'924','2022-10-11 10:52:12','924','2022-10-11 10:52:36',10,0),('8','211',64,'Daily shift','2022-10-12','2022-10-12 13:36:22','2022-10-13 13:36:22','924',1577236.92,1600545.84,'924','2022-10-12 13:41:46','924','2022-10-12 13:42:38',10,0),('8','211',65,'Daily shift','2022-10-16','2022-10-16 10:32:51','2022-10-23 10:32:51','924',1164089.34,1265314.50,'924','2022-10-16 13:06:43','924','2022-10-16 13:07:43',10,0),('8','211',66,'Daily shift','2022-10-17','2022-10-17 10:37:37','2022-10-24 10:37:37','924',5290067.25,5290067.25,'924','2022-10-17 10:40:05','924','2022-10-17 10:40:38',10,0),('8','211',67,'Daily shift','2022-10-18','2022-10-18 09:41:30','2022-10-25 09:41:30','924',818435.25,818435.25,'924','2022-10-18 09:42:56','924','2022-10-18 09:43:34',10,0),('8','211',68,'Daily shift','2022-10-22','2022-10-22 08:44:36','2022-10-29 08:44:36','924',2848136.55,2848136.55,'924','2022-10-22 08:47:14','924','2022-10-22 08:48:07',10,0),('8','211',69,'Daily shift','2022-10-23','2022-10-23 09:21:03','2022-10-30 09:21:03','924',2620148.95,2675896.80,'924','2022-10-23 09:22:03','924','2022-10-23 09:22:24',10,0),('8','211',70,'Daily shift','2022-10-24','2022-10-24 08:48:31','2022-10-31 08:48:31','924',2051406.65,2095053.60,'924','2022-10-24 08:49:21','924','2022-10-24 08:49:41',10,0),('8','211',71,'Daily shift','2022-10-26','2022-10-26 09:41:10','2022-11-02 09:41:10','924',1736107.20,1736107.20,'924','2022-10-26 09:42:55','924','2022-10-26 09:44:26',10,0),('8','211',72,'Daily shift','2022-10-27','2022-10-27 09:09:53','2022-11-03 09:09:53','924',2518636.80,2623580.00,'924','2022-10-27 09:11:47','924','2022-10-27 09:12:16',10,0),('8','211',73,'Daily shift','2022-10-28','2022-10-28 08:59:23','2022-10-29 08:59:23','924',2576455.20,2683807.50,'924','2022-10-28 09:01:20','924','2022-10-28 09:01:45',10,0),('8','211',74,'Daily shift','2022-10-29','2022-10-29 09:09:00','2022-10-30 09:09:00','924',445449.60,464010.00,'924','2022-10-29 09:11:19','924','2022-10-29 09:12:00',10,0),('8','211',75,'Daily shift','2022-11-06','2022-11-06 09:38:48','2022-11-13 09:38:48','924',1458299.10,1458299.10,'924','2022-11-06 11:05:42','924','2022-11-06 11:06:07',10,0),('8','211',76,'Daily shift','2022-11-07','2022-11-07 08:33:21','2022-11-14 08:33:21','924',4861437.30,4861437.30,'924','2022-11-07 08:34:23','924','2022-11-07 08:34:49',10,0),('8','211',77,'Daily shift','2022-11-08','2022-11-08 08:50:35','2022-11-15 08:50:35','924',1840350.30,1840350.30,'924','2022-11-08 08:51:39','924','2022-11-08 08:52:14',10,0),('8','211',78,'Daily shift','2022-11-09','2022-11-09 10:32:03','2022-11-16 10:32:03','924',1811986.65,1811986.65,'924','2022-11-09 10:33:50','924','2022-11-09 10:34:21',10,0),('8','211',79,'Daily shift','2022-11-10','2022-11-10 08:06:07','2022-11-17 08:06:07','924',1946970.90,1946970.90,'924','2022-11-10 08:08:18','924','2022-11-10 08:09:06',10,0),('8','211',80,'Daily shift','2022-11-11','2022-11-11 10:57:38','2022-11-18 10:57:38','924',2171692.20,2171692.20,'924','2022-11-11 10:58:42','924','2022-11-11 10:59:02',10,0),('8','211',81,'Daily shift','2022-11-12','2022-11-12 09:45:42','2022-11-19 09:45:42','924',2132350.80,2132350.80,'924','2022-11-12 09:47:32','924','2022-11-12 09:48:07',10,0),('8','211',82,'Daily shift','2022-11-13','2022-11-13 08:41:23','2022-11-20 08:41:23','924',530848.80,530848.80,'924','2022-11-13 08:44:26','924','2022-11-13 08:46:44',10,0),('8','211',83,'Daily shift','2022-11-16','2022-11-16 09:47:07','2022-11-23 09:47:07','924',845704.95,845704.95,'924','2022-11-16 15:57:23','924','2022-11-16 15:57:47',10,0),('8','211',84,'Daily shift','2022-11-17','2022-11-17 08:34:24','2022-11-24 08:34:24','924',2133289.20,2133289.20,'924','2022-11-17 08:35:16','924','2022-11-17 08:35:37',10,0),('8','211',85,'Daily shift','2022-11-18','2022-11-18 09:49:52','2022-11-25 09:49:52','924',2185372.95,2185372.95,'924','2022-11-18 09:51:02','924','2022-11-18 09:51:33',10,0),('8','211',86,'Daily shift','2022-11-19','2022-11-19 09:42:43','2022-11-26 09:42:43','924',2139401.55,2139401.55,'924','2022-11-19 09:44:03','924','2022-11-19 09:44:26',10,0),('8','211',87,'Daily shift','2022-11-20','2022-11-20 07:55:13','2022-11-27 07:55:13','924',1096127.70,1096127.70,'924','2022-11-20 07:56:41','924','2022-11-20 07:57:18',10,0),('8','211',88,'Daily shift','2022-11-21','2022-11-21 15:11:34','2022-11-28 15:11:34','924',4457013.60,4457013.60,'924','2022-11-21 15:13:11','924','2022-11-21 15:13:29',10,0),('8','211',89,'Daily shift','2022-11-28','2022-11-28 10:48:29','2022-11-29 10:48:29','924',4161861.60,4161861.60,'924','2022-11-28 10:50:47','924','2022-11-28 10:51:12',10,0),('8','211',90,'Daily shift','2022-11-29','2022-11-29 10:48:08','2022-12-06 10:48:08','924',2524940.60,2524940.60,'924','2022-11-29 10:49:15','924','2022-11-29 10:49:32',10,0),('8','211',91,'Daily shift','2022-11-30','2022-11-30 13:06:32','2022-12-07 13:06:32','924',2477534.80,2477534.80,'924','2022-11-30 13:08:15','924','2022-11-30 13:08:39',10,0),('8','211',92,'Daily shift','2022-12-01','2022-12-01 09:52:24','2022-12-08 09:52:24','924',2514954.00,2514954.00,'924','2022-12-01 09:54:15','924','2022-12-01 09:54:31',10,0),('8','211',93,'Daily shift','2022-12-07','2022-12-07 09:29:25','2022-12-14 09:29:25','924',3124664.10,3124664.10,'924','2022-12-08 07:18:53','924','2022-12-08 07:19:15',10,0),('8','211',94,'Daily shift','2022-12-08','2022-12-08 09:41:09','2022-12-15 09:41:09','924',1373063.40,1408661.34,'924','2022-12-08 09:43:34','924','2022-12-08 09:44:00',10,0),('8','211',95,'Daily shift','2022-12-09','2022-12-09 21:03:56','2022-12-16 21:03:56','924',1021478.60,1021478.60,'924','2022-12-09 21:07:44','924','2022-12-09 21:08:07',10,0),('8','211',96,'Daily shift','2022-12-10','2022-12-10 09:37:49','2022-12-17 09:37:49','924',2846999.60,2846999.60,'924','2022-12-10 09:39:57','924','2022-12-10 09:40:20',10,0),('8','211',97,'Daily shift','2022-12-11','2022-12-11 08:53:57','2022-12-18 08:53:57','924',3799150.80,3799150.80,'924','2022-12-11 08:55:03','924','2022-12-11 08:55:21',10,0),('8','211',98,'Daily shift','2022-12-12','2022-12-12 18:42:04','2022-12-19 18:42:04','924',7718331.60,7718331.60,'924','2022-12-12 22:51:36','924','2022-12-12 22:52:04',10,0),('8','211',99,'Daily shift','2022-12-13','2022-12-13 08:28:42','2022-12-20 08:28:42','924',3341860.20,3341860.20,'924','2022-12-13 08:30:01','924','2022-12-13 08:30:27',10,0),('8','211',100,'Daily shift','2022-12-14','2022-12-14 09:57:19','2022-12-21 09:57:19','924',2332269.45,2332269.45,'924','2022-12-14 09:58:57','924','2022-12-14 09:59:26',10,0),('8','211',101,'Daily shift','2022-12-15','2022-12-15 10:06:49','2022-12-22 10:06:49','924',2723118.30,2723118.30,'924','2022-12-15 10:10:37','924','2022-12-15 10:11:08',10,0),('8','211',102,'Daily shift','2022-12-19','2022-12-19 12:22:57','2022-12-26 12:22:57','924',5515574.40,5515574.40,'924','2022-12-19 17:24:46','924','2022-12-19 17:25:04',10,0),('8','211',103,'Daily shift','2022-12-20','2022-12-20 10:24:18','2022-12-27 10:24:18','924',2182824.00,2182824.00,'924','2022-12-20 10:25:35','924','2022-12-20 10:25:57',10,0),('8','211',104,'Daily shift','2022-12-21','2022-12-21 08:31:28','2022-12-28 08:31:28','924',1768595.85,1768595.85,'924','2022-12-21 08:32:38','924','2022-12-21 08:34:00',10,0),('8','211',105,'Daily shift','2022-12-22','2022-12-22 10:22:28','2022-12-29 10:22:28','924',2005686.90,2005686.90,'924','2022-12-22 10:23:42','924','2022-12-22 10:24:09',10,0),('8','211',107,'Daily shift','2022-12-23','2022-12-23 08:10:04','2022-12-30 08:10:04','924',1685224.80,1685224.80,'924','2022-12-23 08:11:28','924','2022-12-23 08:12:29',10,0),('8','211',108,'Daily shift','2022-12-24','2022-12-24 09:18:02','2022-12-31 09:18:02','924',810060.30,810060.30,'924','2022-12-24 09:23:26','924','2022-12-24 09:23:42',10,0),('8','211',109,'Daily shift','2022-12-26','2022-12-26 11:57:40','2023-01-02 11:57:40','924',5728915.65,5728915.65,'924','2022-12-26 12:01:47','924','2022-12-26 12:02:15',10,0),('8','211',110,'Daily shift','2022-12-27','2022-12-27 08:22:49','2023-01-03 08:22:49','924',2496196.25,2496196.25,'924','2022-12-27 08:23:49','924','2022-12-27 08:24:08',10,0),('8','211',111,'Daily shift','2022-12-28','2022-12-28 22:23:02','2023-01-04 22:23:02','924',1454020.40,1454020.40,'924','2022-12-28 22:24:58','924','2022-12-28 22:25:18',10,0),('8','211',112,'Daily shift','2022-12-30','2022-12-30 21:09:12','2023-01-06 21:09:12','924',1739838.00,1739838.00,'924','2022-12-30 21:13:06','924','2022-12-30 21:13:42',10,0),('8','211',113,'Daily shift','2022-12-31','2022-12-31 08:44:29','2023-01-01 08:44:29','924',1384440.00,1384440.00,'924','2022-12-31 08:45:20','924','2022-12-31 08:45:34',10,0),('8','211',114,'Daily shift','2023-01-01','2023-01-01 08:31:17','2023-01-08 08:31:17','924',1887105.00,1887105.00,'924','2023-01-01 08:32:17','924','2023-01-01 08:32:53',10,0),('8','211',115,'Daily shift','2023-01-02','2023-01-02 08:46:38','2023-01-09 08:46:38','924',4935738.00,4935738.00,'924','2023-01-02 08:47:41','924','2023-01-02 08:47:57',10,0),('8','211',116,'Daily shift','2023-01-03','2023-01-03 15:50:26','2023-01-10 15:50:26','924',2021592.00,2021592.00,'924','2023-01-03 15:51:32','924','2023-01-03 15:51:50',10,0),('8','211',117,'Daily shift','2023-01-05','2023-01-06 12:07:23','2023-01-13 12:07:23','924',1374825.00,1374825.00,'924','2023-01-06 12:09:38','924','2023-01-06 12:10:01',10,0),('8','211',118,'Daily shift','2023-01-07','2023-01-07 20:26:25','2023-01-14 20:26:25','924',1356786.00,1356786.00,'924','2023-01-07 21:08:50','924','2023-01-07 21:09:14',10,0),('8','211',119,'Daily shift','2023-01-08','2023-01-08 10:03:34','2023-01-15 10:03:34','924',1734462.00,1734462.00,'924','2023-01-08 10:04:31','924','2023-01-08 10:04:55',10,0),('8','211',120,'Daily shift','2023-01-09','2023-01-09 09:18:26','2023-01-16 09:18:26','924',5022882.00,5022882.00,'924','2023-01-09 09:19:25','924','2023-01-09 09:19:52',10,0),('8','211',121,'Daily shift','2023-01-10','2023-01-10 08:47:47','2023-01-17 08:47:47','924',649725.00,649725.00,'924','2023-01-10 08:49:16','924','2023-01-10 08:50:05',10,0),('8','211',122,'Daily shift','2023-01-13','2023-01-13 21:59:31','2023-01-20 21:59:31','924',1571844.00,1571844.00,'924','2023-01-13 22:21:40','924','2023-01-14 08:45:45',10,0),('8','211',123,'Daily shift','2023-01-14','2023-01-14 08:46:54','2023-01-21 08:46:54','924',1615038.00,1615038.00,'924','2023-01-14 08:48:08','924','2023-01-14 08:48:36',10,0),('8','211',124,'Daily shift','2023-01-15','2023-01-15 09:22:43','2023-01-22 09:22:43','924',1993785.00,1993785.00,'924','2023-01-15 09:24:06','924','2023-01-15 09:25:00',10,0),('8','211',125,'Daily shift','2023-01-16','2023-01-16 08:33:59','2023-01-23 08:33:59','924',4751337.00,4751337.00,'924','2023-01-16 08:34:54','924','2023-01-16 08:35:21',10,0),('8','211',126,'Daily shift','2023-01-19','2023-01-19 17:04:22','2023-01-26 17:04:22','924',1965870.00,1965870.00,'924','2023-01-19 17:05:39','924','2023-01-19 17:05:59',10,0),('8','211',127,'Daily shift','2023-01-20','2023-01-20 08:24:49','2023-01-27 08:24:49','924',1844826.00,1844826.00,'924','2023-01-20 08:25:59','924','2023-01-20 08:26:22',10,0),('8','211',128,'Daily shift','2023-01-21','2023-01-21 09:04:24','2023-01-28 09:04:24','924',2118222.00,2118222.00,'924','2023-01-21 09:05:26','924','2023-01-21 09:06:11',10,0),('8','211',129,'Daily shift','2023-01-22','2023-01-22 09:34:40','2023-01-23 09:34:40','924',827913.60,811680.00,'924','2023-01-22 09:35:55','924','2023-01-22 09:36:50',10,0),('8','211',130,'Daily shift','2023-01-22','2023-01-22 09:40:01','2023-01-29 09:40:01','924',3702015.54,3702015.54,'924','2023-01-22 09:41:48','924','2023-01-22 09:42:13',10,0),('8','211',131,'Daily shift','2023-01-23','2023-01-23 08:19:42','2023-01-30 08:19:42','924',5234114.70,5234114.70,'924','2023-01-23 08:20:47','924','2023-01-23 08:21:10',10,0),('8','211',132,'Daily shift','2023-01-31','2023-01-31 22:37:03','2023-02-07 22:37:03','924',956019.48,956019.48,'924','2023-01-31 22:39:18','924','2023-01-31 22:39:42',10,0),('8','211',133,'Daily shift','2023-02-01','2023-02-01 08:36:48','2023-02-08 08:36:48','924',1288597.96,1315284.90,'924','2023-02-01 08:39:43','924','2023-02-01 08:40:01',10,0),('8','211',134,'Daily shift','2023-02-02','2023-02-02 08:58:59','2023-02-09 08:58:59','924',2039921.26,2082168.15,'924','2023-02-02 09:00:07','924','2023-02-02 09:00:28',10,0),('8','211',135,'Daily shift','2023-02-03','2023-02-03 11:34:18','2023-02-10 11:34:18','924',1856921.30,1895378.25,'924','2023-02-03 11:35:28','924','2023-02-03 11:35:44',10,0),('8','211',136,'Daily shift','2023-02-04','2023-02-04 07:37:02','2023-02-11 07:37:02','924',2912701.48,2973023.70,'924','2023-02-04 07:38:32','924','2023-02-04 07:38:55',10,0),('8','211',137,'Daily shift','2023-02-05','2023-02-05 09:58:02','2023-02-12 09:58:02','924',1959865.96,2000454.90,'924','2023-02-05 09:59:47','924','2023-02-05 10:00:30',10,0),('8','211',138,'Daily shift','2023-02-07','2023-02-07 12:34:20','2023-02-08 12:34:20','924',4375911.00,4375911.00,'924','2023-02-07 12:35:24','924','2023-02-07 12:35:45',10,0),('8','211',139,'Daily shift','2023-02-07','2023-02-07 12:42:34','2023-02-08 12:42:34','924',2694877.80,2694877.80,'924','2023-02-07 12:43:44','924','2023-02-07 12:44:02',10,0),('8','211',140,'Daily shift','2023-02-08','2023-02-08 09:16:06','2023-02-09 09:16:06','924',2400965.40,2400965.40,'924','2023-02-08 09:17:37','924','2023-02-08 09:22:22',10,0),('8','211',141,'Daily shift','2023-02-09','2023-02-09 13:18:24','2023-02-10 13:18:24','924',2741825.40,2741825.40,'924','2023-02-09 16:19:41','924','2023-02-09 16:20:14',10,0),('8','211',142,'Daily shift','2023-02-10','2023-02-10 18:36:56','2023-02-11 18:36:56','924',3313838.85,3313838.85,'924','2023-02-10 18:38:04','924','2023-02-10 18:38:22',10,0),('8','211',143,'Daily shift','2023-02-12','2023-02-12 22:06:04','2023-02-19 22:06:04','924',3202414.20,3202414.20,'924','2023-02-12 22:06:55','924','2023-02-12 22:07:25',10,0),('8','211',144,'Daily shift','2023-02-12','2023-02-12 22:25:24','2023-02-19 22:25:24','924',2435068.65,2435068.65,'924','2023-02-12 22:26:44','924','2023-02-12 22:27:25',10,0),('8','211',145,'Daily shift','2023-02-13','2023-02-13 08:55:05','2023-02-20 08:55:05','924',5558733.15,5558733.15,'924','2023-02-13 08:56:22','924','2023-02-13 08:56:47',10,0),('8','211',146,'Daily shift','2023-02-14','2023-02-14 08:51:11','2023-02-15 08:51:11','924',2640716.25,2640716.25,'924','2023-02-14 08:52:27','924','2023-02-14 08:53:01',10,0),('8','211',147,'Daily shift','2023-02-18','2023-02-18 10:17:47','2023-02-25 10:17:47','924',1541985.00,1541985.00,'924','2023-02-18 21:23:38','924','2023-02-18 21:23:58',10,0),('8','211',148,'Daily shift','2023-02-19','2023-02-19 22:50:13','2023-02-26 22:50:13','924',1742398.00,1742398.00,'924','2023-02-19 22:52:03','924','2023-02-19 22:52:22',10,0),('8','211',149,'Daily shift','2023-02-20','2023-02-20 15:36:40','2023-02-27 15:36:40','924',4704580.00,4704580.00,'924','2023-02-20 15:37:52','924','2023-02-20 15:38:11',10,0),('8','211',150,'Daily shift','2023-02-21','2023-02-21 14:31:23','2023-02-28 14:31:23','924',1803774.80,1803774.80,'924','2023-02-21 14:32:30','924','2023-02-21 14:33:07',10,0),('8','211',151,'Daily shift','2023-02-24','2023-02-24 09:45:31','2023-03-03 09:45:31','924',2573905.40,2271093.00,'924','2023-02-24 15:00:54','924','2023-02-24 15:01:13',10,0),('8','211',152,'Daily shift','2023-02-25','2023-02-25 10:55:35','2023-03-04 10:55:35','924',2742147.00,2742147.00,'924','2023-02-25 10:56:38','924','2023-02-25 10:57:19',10,0),('8','211',153,'Daily shift','2023-02-27','2023-02-27 17:30:29','2023-02-28 17:30:29','924',5702841.00,5702841.00,'924','2023-02-27 17:32:44','924','2023-02-27 17:33:14',10,0),('8','211',154,'Daily shift','2023-02-28','2023-02-28 09:02:21','2023-03-01 09:02:21','924',4264782.00,4264782.00,'924','2023-02-28 09:03:28','924','2023-02-28 09:03:46',10,0),('8','211',155,'Daily shift','2023-03-02','2023-03-02 17:28:27','2023-03-09 17:28:27','924',3774066.00,3774066.00,'924','2023-03-02 17:29:35','924','2023-03-02 17:30:13',10,0),('8','211',156,'Daily shift','2023-03-02','2023-03-02 17:33:10','2023-03-09 17:33:10','924',3667452.00,3667452.00,'924','2023-03-02 17:34:42','924','2023-03-02 17:37:30',10,0),('8','211',157,'Daily shift','2023-03-03','2023-03-03 12:27:42','2023-03-10 12:27:42','924',2361747.00,2361747.00,'924','2023-03-04 08:30:05','924','2023-03-04 08:30:24',10,0),('8','211',158,'Daily shift','2023-03-05','2023-03-05 11:40:12','2023-03-12 11:40:12','924',3331101.00,3331101.00,'924','2023-03-05 11:41:49','924','2023-03-05 11:42:14',10,0),('8','211',159,'Daily shift','2023-03-06','2023-03-06 09:29:54','2023-03-13 09:29:54','924',6023160.00,6023160.00,'924','2023-03-06 09:31:31','924','2023-03-06 09:31:55',10,0),('8','211',160,'Daily shift','2023-03-07','2023-03-07 09:13:58','2023-03-14 09:13:58','924',4220085.00,4220085.00,'924','2023-03-07 09:15:26','924','2023-03-07 09:15:55',10,0),('8','211',161,'Daily shift','2023-03-08','2023-03-08 09:28:32','2023-03-15 09:28:32','924',3022200.00,3022200.00,'924','2023-03-08 09:31:34','924','2023-03-08 09:32:43',10,0),('8','211',162,'Daily shift','2023-03-09','2023-03-09 11:06:43','2023-03-10 11:06:43','924',1523139.00,1523139.00,'924','2023-03-09 11:08:35','924','2023-03-09 11:09:00',10,0),('8','211',163,'Daily shift','2023-03-13','2023-03-13 11:50:38','2023-03-20 11:50:38','924',5057010.00,5057010.00,'924','2023-03-13 22:51:55','924','2023-03-13 22:52:14',10,0),('8','211',164,'Daily shift','2023-03-18','2023-03-18 12:50:51','2023-03-25 12:50:51','924',3359736.00,3359736.00,'924','2023-03-18 12:53:12','924','2023-03-18 12:53:37',10,0),('8','211',165,'Daily shift','2023-03-20','2023-03-20 13:38:32','2023-03-27 13:38:32','924',1475589.00,1475589.00,'924','2023-03-20 13:39:53','924','2023-03-20 13:40:13',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=1149 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('8','211','1','1',1,'1','1',757603.00,758584.52,981.52,211026.80,0.00,0.00,0.00,0.00,0.00),('8','211','1','1',2,'2','1',2427947.12,2427947.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','1',3,'3','1',116649.29,117818.76,1169.47,251436.05,0.00,0.00,0.00,0.00,0.00),('8','211','2','1',4,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','1',5,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','1',6,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','1',7,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','2',8,'1','1',758584.52,759676.15,1091.63,234700.45,0.00,0.00,0.00,0.00,0.00),('8','211','1','2',9,'2','1',2427947.12,2429064.00,1116.88,240129.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','2',10,'3','1',117818.76,119637.96,1819.20,391128.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','2',11,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','2',12,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','2',13,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','2',14,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','3',15,'1','1',759676.15,759676.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','3',16,'2','1',2429064.00,2431484.28,2420.28,520360.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','3',17,'3','1',119637.96,121563.82,1925.86,414059.90,0.00,0.00,0.00,0.00,0.00),('8','211','2','3',18,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','3',19,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','3',20,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','3',21,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','4',22,'1','1',759676.15,762659.12,2982.97,641338.55,0.00,0.00,0.00,0.00,0.00),('8','211','1','4',23,'2','1',2431484.28,2431484.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','4',24,'3','1',121563.82,123718.68,2154.86,463294.90,0.00,0.00,0.00,0.00,0.00),('8','211','2','4',25,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','4',26,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','4',27,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','4',28,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','5',29,'1','1',762659.12,762659.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','5',30,'2','1',2431484.28,2433174.98,1690.70,363500.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','5',31,'3','1',123718.68,125643.18,1924.50,413767.50,0.00,0.00,0.00,0.00,0.00),('8','211','2','5',32,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','5',33,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','5',34,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','5',35,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','6',36,'1','1',762659.12,766658.04,3998.92,859767.80,0.00,0.00,0.00,0.00,0.00),('8','211','1','6',37,'2','1',2433174.98,2437153.39,3978.41,855358.15,0.00,0.00,0.00,0.00,0.00),('8','211','1','6',38,'3','1',125643.18,129215.40,3572.22,768027.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','6',39,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','6',40,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','6',41,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','6',42,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','7',43,'1','1',766658.04,768407.75,1749.71,376187.65,0.00,0.00,0.00,0.00,0.00),('8','211','1','7',44,'2','1',2437153.39,2437153.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','7',45,'3','1',129215.40,130638.56,1423.16,305979.40,0.00,0.00,0.00,0.00,0.00),('8','211','2','7',46,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','7',47,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','7',48,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','7',49,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','8',50,'1','1',768407.75,771199.50,2791.75,577892.25,0.00,0.00,0.00,0.00,0.00),('8','211','1','8',51,'2','1',2437153.39,2437153.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','8',52,'3','1',130638.56,132432.78,1794.22,371403.54,0.00,0.00,0.00,0.00,0.00),('8','211','2','8',53,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','8',54,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','8',55,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','8',56,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','9',57,'1','1',771199.50,772585.79,1386.29,286962.03,0.00,0.00,0.00,0.00,0.00),('8','211','1','9',58,'2','1',2437153.39,2437295.99,142.60,29518.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','9',59,'3','1',132432.78,133904.56,1471.78,304658.46,0.00,0.00,0.00,0.00,0.00),('8','211','2','9',60,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','9',61,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','9',62,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','9',63,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','10',64,'1','1',772585.79,773786.00,1200.21,248443.47,0.00,0.00,0.00,0.00,0.00),('8','211','1','10',65,'2','1',2437295.99,2437295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','10',66,'3','1',133904.56,135379.22,1474.66,305254.62,0.00,0.00,0.00,0.00,0.00),('8','211','2','10',67,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','10',68,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','10',69,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','10',70,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','11',71,'1','1',773786.00,774867.06,1081.06,223779.42,0.00,0.00,0.00,0.00,0.00),('8','211','1','11',72,'2','1',2437295.99,2437295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','11',73,'3','1',135379.22,136760.66,1381.44,285958.08,0.00,0.00,0.00,0.00,0.00),('8','211','2','11',74,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','11',75,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','11',76,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','11',77,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','12',78,'1','1',774867.06,774867.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','12',79,'2','1',2437295.99,2437295.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','12',80,'3','1',136760.66,140302.19,3541.53,733096.71,0.00,0.00,0.00,0.00,0.00),('8','211','2','12',81,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','12',82,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','12',83,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','12',84,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','13',85,'1','1',774867.06,777425.16,2558.10,511620.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','13',86,'2','1',2437295.99,2442565.11,5269.12,1053824.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','13',87,'3','1',140302.19,142379.47,2077.28,415456.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','13',88,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','13',89,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','13',90,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','13',91,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','14',92,'1','1',777425.16,777425.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','14',93,'2','1',2442565.11,2444339.22,1774.11,354822.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','14',94,'3','1',142379.47,143800.86,1421.39,284278.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','14',95,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','14',96,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','14',97,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','14',98,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','15',99,'1','1',777425.16,777425.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','15',100,'2','1',2444339.22,2444339.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','15',101,'3','1',143800.86,143800.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','15',102,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','15',103,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','15',104,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','15',105,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','16',106,'1','1',777425.16,777425.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','16',107,'2','1',2444339.22,2446181.31,1842.09,359207.55,0.00,0.00,0.00,0.00,0.00),('8','211','1','16',108,'3','1',143800.86,145270.70,1469.84,286618.80,0.00,0.00,0.00,0.00,0.00),('8','211','2','16',109,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','16',110,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','16',111,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','16',112,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','17',113,'1','1',777425.16,777425.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','17',114,'2','1',2446181.31,2447550.47,1369.16,266986.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','17',115,'3','1',145270.70,147278.84,2008.14,391587.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','17',116,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','17',117,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','17',118,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','17',119,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','18',120,'1','1',777425.16,777425.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','18',121,'2','1',2447550.47,2449303.77,1753.30,341893.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','18',122,'3','1',147278.84,148949.66,1670.82,325809.90,0.00,0.00,0.00,0.00,0.00),('8','211','2','18',123,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','18',124,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','18',125,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','18',126,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','19',127,'1','1',777425.16,778892.98,1467.82,286224.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','19',128,'2','1',2449303.77,2449317.10,13.33,2599.35,0.00,0.00,0.00,0.00,0.00),('8','211','1','19',129,'3','1',148949.66,151000.35,2050.69,399884.55,0.00,0.00,0.00,0.00,0.00),('8','211','2','19',130,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','19',131,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','19',132,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','19',133,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','20',134,'1','1',778892.98,783462.84,4569.86,891122.70,0.00,0.00,0.00,0.00,0.00),('8','211','1','20',135,'2','1',2449317.10,2449355.80,38.70,7546.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','20',136,'3','1',151000.35,154882.91,3882.56,757099.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','20',137,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','20',138,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','20',139,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','20',140,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','21',141,'1','1',783462.84,786585.14,3122.30,608848.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','21',142,'2','1',2449355.80,2449355.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','21',143,'3','1',154882.91,156385.26,1502.35,292958.25,0.00,0.00,0.00,0.00,0.00),('8','211','2','21',144,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','21',145,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','21',146,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','21',147,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','22',148,'1','1',786585.14,789293.66,2708.52,528161.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','22',149,'2','1',2449355.80,2449355.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','22',150,'3','1',156385.26,158219.21,1833.95,357620.25,0.00,0.00,0.00,0.00,0.00),('8','211','2','22',151,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','22',152,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','22',153,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','22',154,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','23',155,'1','1',789293.66,791617.45,2323.79,453139.05,0.00,0.00,0.00,0.00,0.00),('8','211','1','23',156,'2','1',2449355.80,2449355.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','23',157,'3','1',158219.21,159488.73,1269.52,247556.40,0.00,0.00,0.00,0.00,0.00),('8','211','2','23',158,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','23',159,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','23',160,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','23',161,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','24',162,'1','1',791617.45,793254.45,1637.00,319215.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','24',163,'2','1',2449355.80,2449355.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','24',164,'3','1',159488.73,161020.49,1531.76,298693.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','24',165,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','24',166,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','24',167,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','24',168,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','25',169,'1','1',793254.45,795325.04,2070.59,403765.05,0.00,0.00,0.00,0.00,0.00),('8','211','1','25',170,'2','1',2449355.80,2449355.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','25',171,'3','1',161020.49,162791.39,1770.90,345325.50,0.00,0.00,0.00,0.00,0.00),('8','211','2','25',172,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','25',173,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','25',174,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','25',175,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','26',176,'1','1',795325.04,796848.95,1523.91,297162.45,0.00,0.00,0.00,0.00,0.00),('8','211','1','26',177,'2','1',2449355.80,2450526.96,1171.16,228376.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','26',178,'3','1',162791.39,164659.92,1868.53,364363.35,0.00,0.00,0.00,0.00,0.00),('8','211','2','26',179,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','26',180,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','26',181,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','26',182,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','27',183,'1','1',796848.95,801384.78,4535.83,884486.85,0.00,0.00,0.00,0.00,0.00),('8','211','1','27',184,'2','1',2450526.96,2450547.90,20.94,4083.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','27',185,'3','1',164659.92,169180.50,4520.58,881513.10,0.00,0.00,0.00,0.00,0.00),('8','211','2','27',186,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','27',187,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','27',188,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','27',189,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','28',190,'1','1',801384.78,803659.29,2274.51,443529.45,0.00,0.00,0.00,0.00,0.00),('8','211','1','28',191,'2','1',2450547.90,2450547.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','28',192,'3','1',169180.50,170846.73,1666.23,324914.85,0.00,0.00,0.00,0.00,0.00),('8','211','2','28',193,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','28',194,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','28',195,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','28',196,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','29',197,'1','1',803659.29,806191.50,2532.21,481119.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','29',198,'2','1',2450547.90,2450547.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','29',199,'3','1',170846.73,172294.83,1448.10,275139.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','29',200,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','29',201,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','29',202,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','29',203,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','30',204,'1','1',806191.50,808317.72,2126.22,403981.80,0.00,0.00,0.00,0.00,0.00),('8','211','1','30',205,'2','1',2450547.90,2450547.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','30',206,'3','1',172294.83,173909.16,1614.33,306722.70,0.00,0.00,0.00,0.00,0.00),('8','211','2','30',207,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','30',208,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','30',209,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','30',210,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','31',211,'1','1',808317.72,811015.89,2698.17,512652.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','31',212,'2','1',2450547.90,2450547.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','31',213,'3','1',173909.16,175873.85,1964.69,373291.10,0.00,0.00,0.00,0.00,0.00),('8','211','2','31',214,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','31',215,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','31',216,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','31',217,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','32',218,'1','1',811015.89,813220.38,2204.49,418853.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','32',219,'2','1',2450547.90,2450671.57,123.67,23497.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','32',220,'3','1',175873.85,178379.42,2505.57,476058.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','32',221,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','32',222,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','32',223,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','32',224,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','33',225,'1','1',813220.38,813833.34,612.96,116462.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','33',226,'2','1',2450671.57,2450671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','33',227,'3','1',178379.42,182786.10,4406.68,837269.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','33',228,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','33',229,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','33',230,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','33',231,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','34',232,'1','1',813833.34,819081.69,5248.35,997186.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','34',233,'2','1',2450671.57,2450671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','34',234,'3','1',182786.10,187880.23,5094.13,967884.70,0.00,0.00,0.00,0.00,0.00),('8','211','2','34',235,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','34',236,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','34',237,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','34',238,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','35',239,'1','1',819081.69,821511.25,2429.56,461616.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','35',240,'2','1',2450671.57,2450671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','35',241,'3','1',187880.23,189801.49,1921.26,365039.40,0.00,0.00,0.00,0.00,0.00),('8','211','2','35',242,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','35',243,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','35',244,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','35',245,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','36',246,'1','1',821511.25,824236.66,2725.41,517827.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','36',247,'2','1',2450671.57,2450671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','36',248,'3','1',189801.49,192104.46,2302.97,437564.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','36',249,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','36',250,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','36',251,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','36',252,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','37',253,'1','1',824236.66,826458.97,2222.31,422238.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','37',254,'2','1',2450671.57,2450671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','37',255,'3','1',192104.46,193445.51,1341.05,254799.50,0.00,0.00,0.00,0.00,0.00),('8','211','2','37',256,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','37',257,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','37',258,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','37',259,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','38',260,'1','1',826458.97,828778.85,2319.88,440777.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','38',261,'2','1',2450671.57,2450671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','38',262,'3','1',193445.51,195383.28,1937.77,368176.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','38',263,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','38',264,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','38',265,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','38',266,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','39',267,'1','1',828778.85,830355.96,1577.11,299650.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','39',268,'2','1',2450671.57,2450671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','39',269,'3','1',195383.28,197506.55,2123.27,403421.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','39',270,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','39',271,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','39',272,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','39',273,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','40',274,'1','1',830355.96,832060.41,1704.45,323845.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','40',275,'2','1',2450671.57,2450671.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','40',276,'3','1',197506.55,199554.57,2048.02,389123.80,0.00,0.00,0.00,0.00,0.00),('8','211','2','40',277,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','40',278,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','40',279,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','40',280,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','41',281,'1','1',832060.41,833463.94,1403.53,266670.70,0.00,0.00,0.00,0.00,0.00),('8','211','1','41',282,'2','1',2450671.57,2453956.68,3285.11,624170.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','41',283,'3','1',199554.57,203404.22,3849.65,731433.50,0.00,0.00,0.00,0.00,0.00),('8','211','2','41',284,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','41',285,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','41',286,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','41',287,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','42',288,'1','1',833463.94,834635.19,1171.25,222537.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','42',289,'2','1',2453956.68,2454679.80,723.12,137392.80,0.00,0.00,0.00,0.00,0.00),('8','211','1','42',290,'3','1',203404.22,204755.49,1351.27,256741.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','42',291,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','42',292,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','42',293,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','42',294,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','43',295,'1','1',834635.19,836417.76,1782.57,338688.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','43',296,'2','1',2454679.80,2454679.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','43',297,'3','1',204755.49,206678.65,1923.16,365400.40,0.00,0.00,0.00,0.00,0.00),('8','211','2','43',298,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','43',299,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','43',300,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','43',301,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','44',302,'1','1',836417.76,839287.35,2869.59,545222.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','44',303,'2','1',2454679.80,2455303.22,623.42,118449.80,0.00,0.00,0.00,0.00,0.00),('8','211','1','44',304,'3','1',206678.65,207654.15,975.50,185345.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','44',305,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','44',306,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','44',307,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','44',308,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','45',309,'1','1',839287.35,841329.09,2041.74,387930.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','45',310,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','45',311,'3','1',207654.15,208647.91,993.76,188814.40,0.00,0.00,0.00,0.00,0.00),('8','211','2','45',312,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','45',313,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','45',314,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','45',315,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','46',316,'1','1',841329.09,843340.99,2011.90,382261.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','46',317,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','46',318,'3','1',208647.91,210198.02,1550.11,294520.90,0.00,0.00,0.00,0.00,0.00),('8','211','2','46',319,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','46',320,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','46',321,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','46',322,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','47',323,'1','1',843340.99,845236.64,1895.65,360173.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','47',324,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','47',325,'3','1',210198.02,211906.59,1708.57,324628.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','47',326,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','47',327,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','47',328,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','47',329,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','48',330,'1','1',845236.64,850162.47,4925.83,935907.70,0.00,0.00,0.00,0.00,0.00),('8','211','1','48',331,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','48',332,'3','1',211906.59,217154.87,5248.28,997173.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','48',333,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','48',334,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','48',335,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','48',336,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','49',337,'1','1',850162.47,852508.54,2346.07,445753.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','49',338,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','49',339,'3','1',217154.87,219353.48,2198.61,417735.90,0.00,0.00,0.00,0.00,0.00),('8','211','2','49',340,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','49',341,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','49',342,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','49',343,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','50',344,'1','1',852508.54,855333.95,2825.41,536827.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','50',345,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','50',346,'3','1',219353.48,220940.54,1587.06,301541.40,0.00,0.00,0.00,0.00,0.00),('8','211','2','50',347,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','50',348,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','50',349,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','50',350,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','51',351,'1','1',855333.95,858509.11,3175.16,603280.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','51',352,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','51',353,'3','1',220940.54,223399.18,2458.64,467141.60,0.00,0.00,0.00,0.00,0.00),('8','211','2','51',354,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','51',355,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','51',356,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','51',357,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','52',358,'1','1',858509.11,860525.19,2016.08,383055.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','52',359,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','52',360,'3','1',223399.18,226283.96,2884.78,548108.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','52',361,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','52',362,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','52',363,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','52',364,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','53',365,'1','1',860525.19,862736.68,2211.49,420183.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','53',366,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','53',367,'3','1',226283.96,228728.79,2444.83,464517.70,0.00,0.00,0.00,0.00,0.00),('8','211','2','53',368,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','53',369,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','53',370,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','53',371,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','54',372,'1','1',862736.68,864822.67,2085.99,396338.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','54',373,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','54',374,'3','1',228728.79,230749.97,2021.18,384024.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','54',375,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','54',376,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','54',377,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','54',378,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','55',379,'1','1',864822.67,869494.57,4671.90,887661.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','55',380,'2','1',2455303.22,2455303.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','55',381,'3','1',230749.97,235576.34,4826.37,917010.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','55',382,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','55',383,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','55',384,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','55',385,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','56',386,'1','1',869494.57,870862.46,1367.89,259899.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','56',387,'2','1',2455303.22,2455305.72,2.50,475.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','56',388,'3','1',235576.34,236795.03,1218.69,231551.10,0.00,0.00,0.00,0.00,0.00),('8','211','2','56',389,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','56',390,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','56',391,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','56',392,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','57',393,'1','1',870862.46,872023.80,1161.34,220654.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','57',394,'2','1',2455305.72,2455305.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','57',395,'3','1',236795.03,237456.31,661.28,125643.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','57',396,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','57',397,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','57',398,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','57',399,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','58',400,'1','1',872023.80,874701.67,2677.87,508795.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','58',401,'2','1',2455305.72,2456957.11,1651.39,313764.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','58',402,'3','1',237456.31,237740.91,284.60,54074.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','58',403,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','58',404,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','58',405,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','58',406,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','59',407,'1','1',874701.67,877683.71,2982.04,566587.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','59',408,'2','1',2456957.11,2460183.62,3226.51,613036.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','59',409,'3','1',237740.91,237740.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','59',410,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','59',411,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','59',412,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','59',413,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','60',414,'1','1',877683.71,883631.89,5948.18,1130154.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','60',415,'2','1',2460183.62,2464792.59,4608.97,875704.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','60',416,'3','1',237740.91,237740.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','60',417,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','60',418,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','60',419,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','60',420,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','61',421,'1','1',883631.89,892849.40,9217.51,1871154.53,0.00,0.00,0.00,0.00,0.00),('8','211','1','61',422,'2','1',2464792.59,2472992.83,8200.24,1664648.72,0.00,0.00,0.00,0.00,0.00),('8','211','1','61',423,'3','1',237740.91,237740.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','61',424,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','61',425,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','61',426,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','61',427,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','62',428,'1','1',892849.40,895294.80,2445.40,496416.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','62',429,'2','1',2472992.83,2474850.36,1857.53,377078.59,0.00,0.00,0.00,0.00,0.00),('8','211','1','62',430,'3','1',237740.91,239378.15,1637.24,332359.72,0.00,0.00,0.00,0.00,0.00),('8','211','2','62',431,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','62',432,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','62',433,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','62',434,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','63',435,'1','1',895294.80,902296.26,7001.46,1421296.38,0.00,0.00,0.00,0.00,0.00),('8','211','1','63',436,'2','1',2474850.36,2481434.03,6583.67,1336485.01,0.00,0.00,0.00,0.00,0.00),('8','211','1','63',437,'3','1',239378.15,239378.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','63',438,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','63',439,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','63',440,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','63',441,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','64',442,'1','1',902296.26,902296.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','64',443,'2','1',2481434.03,2485477.96,4043.93,833049.58,0.00,0.00,0.00,0.00,0.00),('8','211','1','64',444,'3','1',239378.15,243103.86,3725.71,767496.26,0.00,0.00,0.00,0.00,0.00),('8','211','2','64',445,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','64',446,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','64',447,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','64',448,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','65',449,'1','1',902296.26,905594.08,3297.82,742009.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','65',450,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','65',451,'3','1',243103.86,245429.66,2325.80,523305.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','65',452,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','65',453,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','65',454,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','65',455,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','66',456,'1','1',905594.08,918790.15,13196.07,2969115.75,0.00,0.00,0.00,0.00,0.00),('8','211','1','66',457,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','66',458,'3','1',245429.66,255745.00,10315.34,2320951.50,0.00,0.00,0.00,0.00,0.00),('8','211','2','66',459,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','66',460,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','66',461,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','66',462,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','67',463,'1','1',918790.15,920999.39,2209.24,497079.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','67',464,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','67',465,'3','1',255745.00,257173.25,1428.25,321356.25,0.00,0.00,0.00,0.00,0.00),('8','211','2','67',466,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','67',467,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','67',468,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','67',469,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','68',470,'1','1',920999.39,928077.01,7077.62,1663240.70,0.00,0.00,0.00,0.00,0.00),('8','211','1','68',471,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','68',472,'3','1',257173.25,262215.36,5042.11,1184895.85,0.00,0.00,0.00,0.00,0.00),('8','211','2','68',473,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','68',474,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','68',475,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','68',476,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','69',477,'1','1',928077.01,933859.60,5782.59,1387821.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','69',478,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','69',479,'3','1',262215.36,267582.34,5366.98,1288075.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','69',480,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','69',481,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','69',482,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','69',483,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','70',484,'1','1',933859.60,938564.25,4704.65,1129116.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','70',485,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','70',486,'3','1',267582.34,271607.08,4024.74,965937.60,0.00,0.00,0.00,0.00,0.00),('8','211','2','70',487,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','70',488,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','70',489,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','70',490,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','71',491,'1','1',938564.25,942709.53,4145.28,994867.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','71',492,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','71',493,'3','1',271607.08,274695.58,3088.50,741240.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','71',494,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','71',495,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','71',496,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','71',497,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','72',498,'1','1',942709.53,948450.25,5740.72,1435180.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','72',499,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','72',500,'3','1',274695.58,279449.18,4753.60,1188400.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','72',501,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','72',502,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','72',503,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','72',504,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','73',505,'1','1',948450.25,954770.20,6319.95,1579987.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','73',506,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','73',507,'3','1',279449.18,283864.46,4415.28,1103820.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','73',508,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','73',509,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','73',510,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','73',511,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','74',512,'1','1',954770.20,955731.45,961.25,240312.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','74',513,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','74',514,'3','1',283864.46,284759.25,894.79,223697.50,0.00,0.00,0.00,0.00,0.00),('8','211','2','74',515,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','74',516,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','74',517,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','74',518,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','75',519,'1','1',955731.45,958181.25,2449.80,624699.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','75',520,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','75',521,'3','1',284759.25,288028.27,3269.02,833600.10,0.00,0.00,0.00,0.00,0.00),('8','211','2','75',522,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','75',523,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','75',524,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','75',525,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','76',526,'1','1',958181.25,968394.27,10213.02,2604320.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','76',527,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','76',528,'3','1',288028.27,296879.71,8851.44,2257117.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','76',529,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','76',530,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','76',531,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','76',532,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','77',533,'1','1',968394.27,972280.01,3885.74,990863.70,0.00,0.00,0.00,0.00,0.00),('8','211','1','77',534,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','77',535,'3','1',296879.71,300211.03,3331.32,849486.60,0.00,0.00,0.00,0.00,0.00),('8','211','2','77',536,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','77',537,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','77',538,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','77',539,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','78',540,'1','1',972280.01,975432.20,3152.19,803808.45,0.00,0.00,0.00,0.00,0.00),('8','211','1','78',541,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','78',542,'3','1',300211.03,304164.67,3953.64,1008178.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','78',543,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','78',544,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','78',545,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','78',546,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','79',547,'1','1',975432.20,979605.82,4173.62,1064273.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','79',548,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','79',549,'3','1',304164.67,307626.23,3461.56,882697.80,0.00,0.00,0.00,0.00,0.00),('8','211','2','79',550,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','79',551,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','79',552,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','79',553,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','80',554,'1','1',979605.82,984491.50,4885.68,1245848.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','80',555,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','80',556,'3','1',307626.23,311256.99,3630.76,925843.80,0.00,0.00,0.00,0.00,0.00),('8','211','2','80',557,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','80',558,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','80',559,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','80',560,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','81',561,'1','1',984491.50,988927.67,4436.17,1131223.35,0.00,0.00,0.00,0.00,0.00),('8','211','1','81',562,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','81',563,'3','1',311256.99,315182.98,3925.99,1001127.45,0.00,0.00,0.00,0.00,0.00),('8','211','2','81',564,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','81',565,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','81',566,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','81',567,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','82',568,'1','1',988927.67,990262.17,1334.50,340297.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','82',569,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','82',570,'3','1',315182.98,315930.24,747.26,190551.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','82',571,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','82',572,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','82',573,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','82',574,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','83',575,'1','1',990262.17,991847.99,1585.82,404384.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','83',576,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','83',577,'3','1',315930.24,317660.91,1730.67,441320.85,0.00,0.00,0.00,0.00,0.00),('8','211','2','83',578,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','83',579,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','83',580,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','83',581,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','84',582,'1','1',991847.99,995996.35,4148.36,1057831.80,0.00,0.00,0.00,0.00,0.00),('8','211','1','84',583,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','84',584,'3','1',317660.91,321878.39,4217.48,1075457.40,0.00,0.00,0.00,0.00,0.00),('8','211','2','84',585,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','84',586,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','84',587,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','84',588,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','85',589,'1','1',995996.35,999944.84,3948.49,1006864.95,0.00,0.00,0.00,0.00,0.00),('8','211','1','85',590,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','85',591,'3','1',321878.39,326499.99,4621.60,1178508.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','85',592,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','85',593,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','85',594,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','85',595,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','86',596,'1','1',999944.84,1004305.47,4360.63,1111960.65,0.00,0.00,0.00,0.00,0.00),('8','211','1','86',597,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','86',598,'3','1',326499.99,330529.17,4029.18,1027440.90,0.00,0.00,0.00,0.00,0.00),('8','211','2','86',599,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','86',600,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','86',601,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','86',602,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','87',603,'1','1',1004305.47,1006406.94,2101.47,535874.85,0.00,0.00,0.00,0.00,0.00),('8','211','1','87',604,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','87',605,'3','1',330529.17,332726.24,2197.07,560252.85,0.00,0.00,0.00,0.00,0.00),('8','211','2','87',606,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','87',607,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','87',608,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','87',609,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','88',610,'1','1',1006406.94,1016242.20,9835.26,2557167.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','88',611,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','88',612,'3','1',332726.24,340033.34,7307.10,1899846.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','88',613,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','88',614,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','88',615,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','88',616,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','89',617,'1','1',1016242.20,1026317.36,10075.16,2619541.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','89',618,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','89',619,'3','1',340033.34,345965.34,5932.00,1542320.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','89',620,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','89',621,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','89',622,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','89',623,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','90',624,'1','1',1026317.36,1031566.15,5248.79,1364685.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','90',625,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','90',626,'3','1',345965.34,350427.86,4462.52,1160255.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','90',627,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','90',628,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','90',629,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','90',630,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','91',631,'1','1',1031566.15,1036752.41,5186.26,1348427.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','91',632,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','91',633,'3','1',350427.86,354770.58,4342.72,1129107.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','91',634,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','91',635,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','91',636,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','91',637,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','92',638,'1','1',1036752.41,1041467.83,4715.42,1226009.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','92',639,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','92',640,'3','1',354770.58,359728.06,4957.48,1288944.80,0.00,0.00,0.00,0.00,0.00),('8','211','2','92',641,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','92',642,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','92',643,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','92',644,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','93',645,'1','1',1041467.83,1047673.13,6205.30,1675431.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','93',646,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','93',647,'3','1',359728.06,365095.59,5367.53,1449233.10,0.00,0.00,0.00,0.00,0.00),('8','211','2','93',648,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','93',649,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','93',650,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','93',651,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','94',652,'1','1',1047673.13,1050350.90,2677.77,741742.29,0.00,0.00,0.00,0.00,0.00),('8','211','1','94',653,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','94',654,'3','1',365095.59,367503.24,2407.65,666919.05,0.00,0.00,0.00,0.00,0.00),('8','211','2','94',655,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','94',656,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','94',657,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','94',658,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','95',659,'1','1',1050350.90,1051934.57,1583.67,459264.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','95',660,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','95',661,'3','1',367503.24,369441.91,1938.67,562214.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','95',662,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','95',663,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','95',664,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','95',665,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','96',666,'1','1',1051934.57,1057181.08,5246.51,1521487.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','96',667,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','96',668,'3','1',369441.91,374012.64,4570.73,1325511.70,0.00,0.00,0.00,0.00,0.00),('8','211','2','96',669,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','96',670,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','96',671,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','96',672,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','97',673,'1','1',1057181.08,1064593.68,7412.60,2149654.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','97',674,'2','1',2485477.96,2485477.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','97',675,'3','1',374012.64,379700.56,5687.92,1649496.80,0.00,0.00,0.00,0.00,0.00),('8','211','2','97',676,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','97',677,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','97',678,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','97',679,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','98',680,'1','1',1064593.68,1074705.13,10111.45,3185106.75,0.00,0.00,0.00,0.00,0.00),('8','211','1','98',681,'2','1',2485477.96,2491524.12,6046.16,1904540.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','98',682,'3','1',379700.56,388045.59,8345.03,2628684.45,0.00,0.00,0.00,0.00,0.00),('8','211','2','98',683,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','98',684,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','98',685,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','98',686,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','99',687,'1','1',1074705.13,1080808.78,6103.65,1922649.75,0.00,0.00,0.00,0.00,0.00),('8','211','1','99',688,'2','1',2491524.12,2495920.57,4396.45,1384881.75,0.00,0.00,0.00,0.00,0.00),('8','211','1','99',689,'3','1',388045.59,388154.57,108.98,34328.70,0.00,0.00,0.00,0.00,0.00),('8','211','2','99',690,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','99',691,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','99',692,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','99',693,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','100',694,'1','1',1080808.78,1084799.72,3990.94,1257146.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','100',695,'2','1',2495920.57,2499333.66,3413.09,1075123.35,0.00,0.00,0.00,0.00,0.00),('8','211','1','100',696,'3','1',388154.57,388154.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','100',697,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','100',698,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','100',699,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','100',700,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','101',701,'1','1',1084799.72,1089868.00,5068.28,1596508.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','101',702,'2','1',2499333.66,2502910.20,3576.54,1126610.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','101',703,'3','1',388154.57,388154.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','101',704,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','101',705,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','101',706,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','101',707,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','102',708,'1','1',1089868.00,1095980.45,6112.45,1925421.75,0.00,0.00,0.00,0.00,0.00),('8','211','1','102',709,'2','1',2502910.20,2509276.06,6365.86,2005245.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','102',710,'3','1',388154.57,393186.02,5031.45,1584906.75,0.00,0.00,0.00,0.00,0.00),('8','211','2','102',711,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','102',712,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','102',713,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','102',714,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','103',715,'1','1',1095980.45,1100077.74,4097.29,1290646.35,0.00,0.00,0.00,0.00,0.00),('8','211','1','103',716,'2','1',2509276.06,2509418.83,142.77,44972.55,0.00,0.00,0.00,0.00,0.00),('8','211','1','103',717,'3','1',393186.02,395875.56,2689.54,847205.10,0.00,0.00,0.00,0.00,0.00),('8','211','2','103',718,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','103',719,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','103',720,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','103',721,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','104',722,'1','1',1100077.74,1102793.55,2715.81,855480.15,0.00,0.00,0.00,0.00,0.00),('8','211','1','104',723,'2','1',2509418.83,2509418.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','104',724,'3','1',395875.56,398774.34,2898.78,913115.70,0.00,0.00,0.00,0.00,0.00),('8','211','2','104',725,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','104',726,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','104',727,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','104',728,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','105',729,'1','1',1102793.55,1106128.12,3334.57,1050389.55,0.00,0.00,0.00,0.00,0.00),('8','211','1','105',730,'2','1',2509418.83,2509418.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','105',731,'3','1',398774.34,401807.03,3032.69,955297.35,0.00,0.00,0.00,0.00,0.00),('8','211','2','105',732,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','105',733,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','105',734,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','105',735,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','107',736,'1','1',1106128.12,1108988.06,2859.94,900881.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','107',737,'2','1',2509418.83,2510408.90,990.07,311872.05,0.00,0.00,0.00,0.00,0.00),('8','211','1','107',738,'3','1',401807.03,403306.94,1499.91,472471.65,0.00,0.00,0.00,0.00,0.00),('8','211','2','107',739,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','107',740,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','107',741,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','107',742,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','108',743,'1','1',1108988.06,1110294.35,1306.29,411481.35,0.00,0.00,0.00,0.00,0.00),('8','211','1','108',744,'2','1',2510408.90,2510484.00,75.10,23656.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','108',745,'3','1',403306.94,404497.17,1190.23,374922.45,0.00,0.00,0.00,0.00,0.00),('8','211','2','108',746,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','108',747,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','108',748,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','108',749,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','109',750,'1','1',1110294.35,1120854.50,10560.15,3220845.75,0.00,0.00,0.00,0.00,0.00),('8','211','1','109',751,'2','1',2510484.00,2510501.78,17.78,5422.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','109',752,'3','1',404497.17,412702.57,8205.40,2502647.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','109',753,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','109',754,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','109',755,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','109',756,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','110',757,'1','1',1120854.50,1125362.70,4508.20,1375001.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','110',758,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','110',759,'3','1',412702.57,416378.62,3676.05,1121195.25,0.00,0.00,0.00,0.00,0.00),('8','211','2','110',760,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','110',761,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','110',762,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','110',763,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','111',764,'1','1',1125362.70,1127842.25,2479.55,756262.75,0.00,0.00,0.00,0.00,0.00),('8','211','1','111',765,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','111',766,'3','1',416378.62,418666.35,2287.73,697757.65,0.00,0.00,0.00,0.00,0.00),('8','211','2','111',767,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','111',768,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','111',769,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','111',770,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','112',771,'1','1',1127842.25,1131185.51,3343.26,1002978.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','112',772,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','112',773,'3','1',418666.35,421122.55,2456.20,736860.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','112',774,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','112',775,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','112',776,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','112',777,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','113',778,'1','1',1131185.51,1134300.10,3114.59,934377.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','113',779,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','113',780,'3','1',421122.55,422622.76,1500.21,450063.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','113',781,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','113',782,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','113',783,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','113',784,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','114',785,'1','1',1134300.10,1140325.48,6025.38,1807614.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','114',786,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','114',787,'3','1',422622.76,422887.73,264.97,79491.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','114',788,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','114',789,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','114',790,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','114',791,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','115',792,'1','1',1140325.48,1149196.15,8870.67,2661201.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','115',793,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','115',794,'3','1',422887.73,430469.52,7581.79,2274537.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','115',795,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','115',796,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','115',797,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','115',798,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','116',799,'1','1',1149196.15,1152708.80,3512.65,1053795.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','116',800,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','116',801,'3','1',430469.52,433695.51,3225.99,967797.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','116',802,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','116',803,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','116',804,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','116',805,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','117',806,'1','1',1152708.80,1154633.67,1924.87,577461.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','117',807,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','117',808,'3','1',433695.51,436353.39,2657.88,797364.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','117',809,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','117',810,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','117',811,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','117',812,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','118',813,'1','1',1154633.67,1157099.41,2465.74,739722.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','118',814,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','118',815,'3','1',436353.39,438410.27,2056.88,617064.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','118',816,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','118',817,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','118',818,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','118',819,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','119',820,'1','1',1157099.41,1160153.57,3054.16,916248.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','119',821,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','119',822,'3','1',438410.27,441137.65,2727.38,818214.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','119',823,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','119',824,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','119',825,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','119',826,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','120',827,'1','1',1160153.57,1168882.68,8729.11,2618733.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','120',828,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','120',829,'3','1',441137.65,449151.48,8013.83,2404149.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','120',830,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','120',831,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','120',832,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','120',833,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','121',834,'1','1',1168882.68,1169740.86,858.18,257454.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','121',835,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','121',836,'3','1',449151.48,450459.05,1307.57,392271.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','121',837,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','121',838,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','121',839,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','121',840,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','122',841,'1','1',1169740.86,1172055.82,2314.96,694488.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','122',842,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','122',843,'3','1',450459.05,453383.57,2924.52,877356.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','122',844,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','122',845,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','122',846,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','122',847,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','123',848,'1','1',1172055.82,1174546.83,2491.01,747303.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','123',849,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','123',850,'3','1',453383.57,456276.02,2892.45,867735.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','123',851,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','123',852,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','123',853,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','123',854,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','124',855,'1','1',1174546.83,1177651.15,3104.32,931296.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','124',856,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','124',857,'3','1',456276.02,459817.65,3541.63,1062489.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','124',858,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','124',859,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','124',860,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','124',861,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','125',862,'1','1',1177651.15,1185712.83,8061.68,2418504.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','125',863,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','125',864,'3','1',459817.65,467593.76,7776.11,2332833.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','125',865,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','125',866,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','125',867,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','125',868,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','126',869,'1','1',1185712.83,1189153.12,3440.29,1032087.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','126',870,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','126',871,'3','1',467593.76,470706.37,3112.61,933783.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','126',872,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','126',873,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','126',874,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','126',875,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','127',876,'1','1',1189153.12,1192527.08,3373.96,1012188.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','127',877,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','127',878,'3','1',470706.37,473481.83,2775.46,832638.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','127',879,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','127',880,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','127',881,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','127',882,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','128',883,'1','1',1192527.08,1196520.16,3993.08,1197924.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','128',884,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','128',885,'3','1',473481.83,476549.49,3067.66,920298.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','128',886,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','128',887,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','128',888,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','128',889,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','129',890,'1','1',1196520.16,1197866.51,1346.35,403905.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','129',891,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','129',892,'3','1',476549.49,477908.74,1359.25,407775.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','129',893,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','129',894,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','129',895,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','129',896,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','130',897,'1','1',1197866.51,1203795.76,5929.25,1814350.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','130',898,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','130',899,'3','1',477908.74,484077.58,6168.84,1887665.04,0.00,0.00,0.00,0.00,0.00),('8','211','2','130',900,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','130',901,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','130',902,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','130',903,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','131',904,'1','1',1203795.76,1213863.56,10067.80,3080746.80,0.00,0.00,0.00,0.00,0.00),('8','211','1','131',905,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','131',906,'3','1',484077.58,491114.73,7037.15,2153367.90,0.00,0.00,0.00,0.00,0.00),('8','211','2','131',907,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','131',908,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','131',909,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','131',910,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','132',911,'1','1',1213863.56,1215845.40,1981.84,669861.92,0.00,0.00,0.00,0.00,0.00),('8','211','1','132',912,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','132',913,'3','1',491114.73,491961.35,846.62,286157.56,0.00,0.00,0.00,0.00,0.00),('8','211','2','132',914,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','132',915,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','132',916,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','132',917,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','133',918,'1','1',1215845.40,1217859.32,2013.92,694802.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','133',919,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','133',920,'3','1',491961.35,493759.85,1798.50,620482.50,0.00,0.00,0.00,0.00,0.00),('8','211','2','133',921,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','133',922,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','133',923,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','133',924,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','134',925,'1','1',1217859.32,1221260.10,3400.78,1173269.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','134',926,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','134',927,'3','1',493759.85,496394.34,2634.49,908899.05,0.00,0.00,0.00,0.00,0.00),('8','211','2','134',928,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','134',929,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','134',930,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','134',931,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','135',932,'1','1',1221260.10,1223819.40,2559.30,882958.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','135',933,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','135',934,'3','1',496394.34,499328.89,2934.55,1012419.75,0.00,0.00,0.00,0.00,0.00),('8','211','2','135',935,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','135',936,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','135',937,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','135',938,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','136',939,'1','1',1223819.40,1228176.38,4356.98,1503158.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','136',940,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','136',941,'3','1',499328.89,503589.37,4260.48,1469865.60,0.00,0.00,0.00,0.00,0.00),('8','211','2','136',942,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','136',943,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','136',944,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','136',945,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','137',946,'1','1',1228176.38,1228444.46,268.08,92487.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','137',947,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','137',948,'3','1',503589.37,509119.71,5530.34,1907967.30,0.00,0.00,0.00,0.00,0.00),('8','211','2','137',949,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','137',950,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','137',951,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','137',952,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','138',953,'1','1',1228444.46,1234565.84,6121.38,2111876.10,0.00,0.00,0.00,0.00,0.00),('8','211','1','138',954,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','138',955,'3','1',509119.71,515682.13,6562.42,2264034.90,0.00,0.00,0.00,0.00,0.00),('8','211','2','138',956,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','138',957,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','138',958,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','138',959,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','139',960,'1','1',1234565.84,1237422.72,2856.88,985623.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','139',961,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','139',962,'3','1',515682.13,520636.49,4954.36,1709254.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','139',963,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','139',964,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','139',965,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','139',966,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','140',967,'1','1',1237422.72,1240697.84,3275.12,1129916.40,0.00,0.00,0.00,0.00,0.00),('8','211','1','140',968,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','140',969,'3','1',520636.49,524320.69,3684.20,1271049.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','140',970,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','140',971,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','140',972,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','140',973,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','141',974,'1','1',1240697.84,1243912.18,3214.34,1108947.30,0.00,0.00,0.00,0.00,0.00),('8','211','1','141',975,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','141',976,'3','1',524320.69,529053.67,4732.98,1632878.10,0.00,0.00,0.00,0.00,0.00),('8','211','2','141',977,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','141',978,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','141',979,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','141',980,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','142',981,'1','1',1243912.18,1247720.47,3808.29,1313860.05,0.00,0.00,0.00,0.00,0.00),('8','211','1','142',982,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','142',983,'3','1',529053.67,534850.71,5797.04,1999978.80,0.00,0.00,0.00,0.00,0.00),('8','211','2','142',984,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','142',985,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','142',986,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','142',987,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','143',988,'1','1',1247720.47,1252001.17,4280.70,1476841.50,0.00,0.00,0.00,0.00,0.00),('8','211','1','143',989,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','143',990,'3','1',534850.71,539852.37,5001.66,1725572.70,0.00,0.00,0.00,0.00,0.00),('8','211','2','143',991,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','143',992,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','143',993,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','143',994,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','144',995,'1','1',1252001.17,1256329.57,4328.40,1493298.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','144',996,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','144',997,'3','1',539852.37,542582.14,2729.77,941770.65,0.00,0.00,0.00,0.00,0.00),('8','211','2','144',998,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','144',999,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','144',1000,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','144',1001,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','145',1002,'1','1',1256329.57,1263852.39,7522.82,2595372.90,0.00,0.00,0.00,0.00,0.00),('8','211','1','145',1003,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','145',1004,'3','1',542582.14,551171.59,8589.45,2963360.25,0.00,0.00,0.00,0.00,0.00),('8','211','2','145',1005,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','145',1006,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','145',1007,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','145',1008,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','146',1009,'1','1',1263852.39,1267212.24,3359.85,1159148.25,0.00,0.00,0.00,0.00,0.00),('8','211','1','146',1010,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','146',1011,'3','1',551171.59,555465.99,4294.40,1481568.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','146',1012,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','146',1013,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','146',1014,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','146',1015,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','147',1016,'1','1',1267212.24,1268856.26,1644.02,558966.80,0.00,0.00,0.00,0.00,0.00),('8','211','1','147',1017,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','147',1018,'3','1',555465.99,558357.22,2891.23,983018.20,0.00,0.00,0.00,0.00,0.00),('8','211','2','147',1019,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','147',1020,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','147',1021,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','147',1022,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','148',1023,'1','1',1268856.26,1272629.06,3772.80,1282752.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','148',1024,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','148',1025,'3','1',558357.22,559709.12,1351.90,459646.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','148',1026,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','148',1027,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','148',1028,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','148',1029,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','149',1030,'1','1',1272629.06,1278564.30,5935.24,2017981.60,0.00,0.00,0.00,0.00,0.00),('8','211','1','149',1031,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','149',1032,'3','1',559709.12,567610.88,7901.76,2686598.40,0.00,0.00,0.00,0.00,0.00),('8','211','2','149',1033,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','149',1034,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','149',1035,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','149',1036,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','150',1037,'1','1',1278564.30,1280873.83,2309.53,785240.20,0.00,0.00,0.00,0.00,0.00),('8','211','1','150',1038,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','150',1039,'3','1',567610.88,570606.57,2995.69,1018534.60,0.00,0.00,0.00,0.00,0.00),('8','211','2','150',1040,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','150',1041,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','150',1042,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','150',1043,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','151',1044,'1','1',1280873.83,1284775.90,3902.07,1170621.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','151',1045,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','151',1046,'3','1',570606.57,574274.81,3668.24,1100472.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','151',1047,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','151',1048,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','151',1049,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','151',1050,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','152',1051,'1','1',1284775.90,1289218.07,4442.17,1332651.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','152',1052,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','152',1053,'3','1',574274.81,578973.13,4698.32,1409496.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','152',1054,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','152',1055,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','152',1056,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','152',1057,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','153',1058,'1','1',1289218.07,1298957.41,9739.34,2921802.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','153',1059,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','153',1060,'3','1',578973.13,588243.26,9270.13,2781039.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','153',1061,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','153',1062,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','153',1063,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','153',1064,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','154',1065,'1','1',1298957.41,1306368.13,7410.72,2223216.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','154',1066,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','154',1067,'3','1',588243.26,595048.48,6805.22,2041566.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','154',1068,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','154',1069,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','154',1070,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','154',1071,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','155',1072,'1','1',1306368.13,1313470.60,7102.47,2130741.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','155',1073,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','155',1074,'3','1',595048.48,600526.23,5477.75,1643325.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','155',1075,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','155',1076,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','155',1077,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','155',1078,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','156',1079,'1','1',1313470.60,1319528.87,6058.27,1817481.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','156',1080,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','156',1081,'3','1',600526.23,606692.80,6166.57,1849971.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','156',1082,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','156',1083,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','156',1084,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','156',1085,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','157',1086,'1','1',1319528.87,1323467.38,3938.51,1181553.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','157',1087,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','157',1088,'3','1',606692.80,610626.78,3933.98,1180194.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','157',1089,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','157',1090,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','157',1091,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','157',1092,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','158',1093,'1','1',1323467.38,1328633.90,5166.52,1549956.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','158',1094,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','158',1095,'3','1',610626.78,616563.93,5937.15,1781145.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','158',1096,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','158',1097,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','158',1098,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','158',1099,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','159',1100,'1','1',1328633.90,1338337.16,9703.26,2910978.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','159',1101,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','159',1102,'3','1',616563.93,626937.87,10373.94,3112182.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','159',1103,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','159',1104,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','159',1105,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','159',1106,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','160',1107,'1','1',1338337.16,1345828.60,7491.44,2247432.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','160',1108,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','160',1109,'3','1',626937.87,633513.38,6575.51,1972653.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','160',1110,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','160',1111,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','160',1112,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','160',1113,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','161',1114,'1','1',1345828.60,1346885.84,1057.24,317172.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','161',1115,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','161',1116,'3','1',633513.38,642530.14,9016.76,2705028.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','161',1117,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','161',1118,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','161',1119,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','161',1120,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','162',1121,'1','1',1346885.84,1346885.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','162',1122,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','162',1123,'3','1',642530.14,647607.27,5077.13,1523139.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','162',1124,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','162',1125,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','162',1126,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','162',1127,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','163',1128,'1','1',1346885.84,1354572.18,7686.34,2305902.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','163',1129,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','163',1130,'3','1',647607.27,656777.63,9170.36,2751108.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','163',1131,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','163',1132,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','163',1133,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','163',1134,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','164',1135,'1','1',1354572.18,1360441.44,5869.26,1760778.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','164',1136,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','164',1137,'3','1',656777.63,662107.49,5329.86,1598958.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','164',1138,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','164',1139,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','164',1140,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','164',1141,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','165',1142,'1','1',1360441.44,1362826.07,2384.63,715389.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','165',1143,'2','1',2510501.78,2510501.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','1','165',1144,'3','1',662107.49,664641.49,2534.00,760200.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','165',1145,'4','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','165',1146,'5','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','2','165',1147,'6','1',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('8','211','3','165',1148,'7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=329 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('8','211','1','1',215.00,215.00,2150.99,0.00,0.00,0.00,0.00,1),('8','211','1','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,2),('8','211','2','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,3),('8','211','2','1',215.00,215.00,4027.71,0.00,0.00,0.00,0.00,4),('8','211','3','1',215.00,215.00,4346.14,0.00,0.00,0.00,0.00,5),('8','211','3','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,6),('8','211','4','1',215.00,215.00,5137.83,0.00,0.00,0.00,0.00,7),('8','211','4','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,8),('8','211','5','1',215.00,215.00,3615.20,0.00,0.00,0.00,0.00,9),('8','211','5','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,10),('8','211','6','1',215.00,215.00,11549.55,0.00,0.00,0.00,0.00,11),('8','211','6','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,12),('8','211','7','1',215.00,215.00,3172.87,0.00,0.00,0.00,0.00,13),('8','211','7','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,14),('8','211','8','1',215.00,207.00,4585.97,0.00,0.00,0.00,0.00,15),('8','211','8','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,16),('8','211','9','1',215.00,207.00,3000.67,0.00,0.00,0.00,0.00,17),('8','211','9','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,18),('8','211','10','1',215.00,207.00,2674.87,0.00,0.00,0.00,0.00,19),('8','211','10','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,20),('8','211','11','1',215.00,207.00,2462.50,0.00,0.00,0.00,0.00,21),('8','211','11','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,22),('8','211','12','1',215.00,207.00,3541.53,0.00,0.00,0.00,0.00,23),('8','211','12','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,24),('8','211','13','1',215.00,200.00,9904.50,0.00,0.00,0.00,0.00,25),('8','211','13','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,26),('8','211','14','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,27),('8','211','14','1',200.00,200.00,3195.50,0.00,0.00,0.00,0.00,28),('8','211','15','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,29),('8','211','15','1',200.00,0.00,0.00,0.00,0.00,0.00,0.00,30),('8','211','16','1',200.00,195.00,3311.93,0.00,0.00,0.00,0.00,31),('8','211','16','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,32),('8','211','17','1',200.00,195.00,3377.30,0.00,0.00,0.00,0.00,33),('8','211','17','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,34),('8','211','18','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,35),('8','211','18','1',200.00,195.00,3424.12,0.00,0.00,0.00,0.00,36),('8','211','19','1',200.00,195.00,3531.84,0.00,0.00,0.00,0.00,37),('8','211','19','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,38),('8','211','20','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,39),('8','211','20','1',200.00,195.00,8491.12,0.00,0.00,0.00,0.00,40),('8','211','21','1',200.00,195.00,4624.65,0.00,0.00,0.00,0.00,41),('8','211','21','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,42),('8','211','22','1',200.00,195.00,4542.47,0.00,0.00,0.00,0.00,43),('8','211','22','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,44),('8','211','23','1',195.00,195.00,3593.31,0.00,0.00,0.00,0.00,45),('8','211','23','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,46),('8','211','24','1',195.00,195.00,3168.76,0.00,0.00,0.00,0.00,47),('8','211','24','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,48),('8','211','25','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,49),('8','211','25','1',195.00,195.00,3841.49,0.00,0.00,0.00,0.00,50),('8','211','26','1',195.00,195.00,4563.60,0.00,0.00,0.00,0.00,51),('8','211','26','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,52),('8','211','27','1',195.00,195.00,9077.35,0.00,0.00,0.00,0.00,53),('8','211','27','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,54),('8','211','28','1',195.00,195.00,3940.74,0.00,0.00,0.00,0.00,55),('8','211','28','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,56),('8','211','29','1',195.00,190.00,3980.31,0.00,0.00,0.00,0.00,57),('8','211','29','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,58),('8','211','30','1',195.00,190.00,3740.55,0.00,0.00,0.00,0.00,59),('8','211','30','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,60),('8','211','31','1',195.00,190.00,4662.86,0.00,0.00,0.00,0.00,61),('8','211','31','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,62),('8','211','32','1',195.00,190.00,4833.73,0.00,0.00,0.00,0.00,63),('8','211','32','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,64),('8','211','33','1',190.00,190.00,5019.64,0.00,0.00,0.00,0.00,65),('8','211','33','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,66),('8','211','34','1',190.00,190.00,10342.48,0.00,0.00,0.00,0.00,67),('8','211','34','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,68),('8','211','35','1',190.00,190.00,4350.82,0.00,0.00,0.00,0.00,69),('8','211','35','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,70),('8','211','36','1',190.00,190.00,5028.38,0.00,0.00,0.00,0.00,71),('8','211','36','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,72),('8','211','37','1',190.00,190.00,3563.36,0.00,0.00,0.00,0.00,73),('8','211','37','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,74),('8','211','38','1',190.00,190.00,4257.65,0.00,0.00,0.00,0.00,75),('8','211','38','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,76),('8','211','39','1',190.00,190.00,3700.38,0.00,0.00,0.00,0.00,77),('8','211','39','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,78),('8','211','40','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,79),('8','211','40','1',190.00,190.00,3752.47,0.00,0.00,0.00,0.00,80),('8','211','41','1',190.00,190.00,8538.29,0.00,0.00,0.00,0.00,81),('8','211','41','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,82),('8','211','42','1',190.00,190.00,3245.64,0.00,0.00,0.00,0.00,83),('8','211','42','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,84),('8','211','43','1',190.00,190.00,3705.73,0.00,0.00,0.00,0.00,85),('8','211','43','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,86),('8','211','44','1',190.00,190.00,4468.51,0.00,0.00,0.00,0.00,87),('8','211','44','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,88),('8','211','45','1',190.00,190.00,3035.50,0.00,0.00,0.00,0.00,89),('8','211','45','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,90),('8','211','46','1',190.00,190.00,3562.01,0.00,0.00,0.00,0.00,91),('8','211','46','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,92),('8','211','47','1',190.00,190.00,3604.22,0.00,0.00,0.00,0.00,93),('8','211','47','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,94),('8','211','48','1',190.00,190.00,10174.11,0.00,0.00,0.00,0.00,95),('8','211','48','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,96),('8','211','49','1',190.00,190.00,4544.68,0.00,0.00,0.00,0.00,97),('8','211','49','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,98),('8','211','50','1',190.00,190.00,4412.47,0.00,0.00,0.00,0.00,99),('8','211','50','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,100),('8','211','51','1',190.00,190.00,5633.80,0.00,0.00,0.00,0.00,101),('8','211','51','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,102),('8','211','52','1',190.00,190.00,4900.86,0.00,0.00,0.00,0.00,103),('8','211','52','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,104),('8','211','53','1',190.00,190.00,4656.32,0.00,0.00,0.00,0.00,105),('8','211','53','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,106),('8','211','54','1',190.00,190.00,4107.17,0.00,0.00,0.00,0.00,107),('8','211','54','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,108),('8','211','55','1',190.00,190.00,9498.27,0.00,0.00,0.00,0.00,109),('8','211','55','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,110),('8','211','56','1',190.00,190.00,2589.08,0.00,0.00,0.00,0.00,111),('8','211','56','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,112),('8','211','57','1',190.00,190.00,1822.62,0.00,0.00,0.00,0.00,113),('8','211','57','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,114),('8','211','58','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,115),('8','211','58','1',190.00,190.00,4613.86,0.00,0.00,0.00,0.00,116),('8','211','59','1',190.00,190.00,6208.55,0.00,0.00,0.00,0.00,117),('8','211','59','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,118),('8','211','60','1',190.00,190.00,10557.15,0.00,0.00,0.00,0.00,119),('8','211','60','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,120),('8','211','61','1',190.00,203.00,17417.75,0.00,0.00,0.00,0.00,121),('8','211','61','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,122),('8','211','62','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,123),('8','211','62','1',190.00,203.00,5940.17,0.00,0.00,0.00,0.00,124),('8','211','63','1',203.00,203.00,13585.13,0.00,0.00,0.00,0.00,125),('8','211','63','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,126),('8','211','64','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,127),('8','211','64','1',203.00,206.00,7769.64,0.00,0.00,0.00,0.00,128),('8','211','65','1',207.00,225.00,5623.62,0.00,0.00,0.00,0.00,129),('8','211','65','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,130),('8','211','66','1',225.00,225.00,23511.41,0.00,0.00,0.00,0.00,131),('8','211','66','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,132),('8','211','67','1',225.00,225.00,3637.49,0.00,0.00,0.00,0.00,133),('8','211','67','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,134),('8','211','68','1',235.00,235.00,12119.73,0.00,0.00,0.00,0.00,135),('8','211','68','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,136),('8','211','69','1',235.00,240.00,11149.57,0.00,0.00,0.00,0.00,137),('8','211','69','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,138),('8','211','70','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,139),('8','211','70','1',235.00,240.00,8729.39,0.00,0.00,0.00,0.00,140),('8','211','71','1',240.00,240.00,7233.78,0.00,0.00,0.00,0.00,141),('8','211','71','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,142),('8','211','72','1',240.00,250.00,10494.32,0.00,0.00,0.00,0.00,143),('8','211','72','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,144),('8','211','73','1',240.00,250.00,10735.23,0.00,0.00,0.00,0.00,145),('8','211','73','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,146),('8','211','74','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,147),('8','211','74','1',240.00,250.00,1856.04,0.00,0.00,0.00,0.00,148),('8','211','75','1',255.00,255.00,5718.82,0.00,0.00,0.00,0.00,149),('8','211','75','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,150),('8','211','76','1',255.00,255.00,19064.46,0.00,0.00,0.00,0.00,151),('8','211','76','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,152),('8','211','77','1',255.00,255.00,7217.06,0.00,0.00,0.00,0.00,153),('8','211','77','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,154),('8','211','78','1',255.00,255.00,7105.83,0.00,0.00,0.00,0.00,155),('8','211','78','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,156),('8','211','79','1',255.00,255.00,7635.18,0.00,0.00,0.00,0.00,157),('8','211','79','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,158),('8','211','80','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,159),('8','211','80','1',255.00,255.00,8516.44,0.00,0.00,0.00,0.00,160),('8','211','81','1',255.00,255.00,8362.16,0.00,0.00,0.00,0.00,161),('8','211','81','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,162),('8','211','82','1',255.00,255.00,2081.76,0.00,0.00,0.00,0.00,163),('8','211','82','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,164),('8','211','83','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,165),('8','211','83','1',255.00,255.00,3316.49,0.00,0.00,0.00,0.00,166),('8','211','84','1',255.00,255.00,8365.84,0.00,0.00,0.00,0.00,167),('8','211','84','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,168),('8','211','85','1',255.00,255.00,8570.09,0.00,0.00,0.00,0.00,169),('8','211','85','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,170),('8','211','86','1',255.00,255.00,8389.81,0.00,0.00,0.00,0.00,171),('8','211','86','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,172),('8','211','87','1',255.00,255.00,4298.54,0.00,0.00,0.00,0.00,173),('8','211','87','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,174),('8','211','88','1',260.00,260.00,17142.36,0.00,0.00,0.00,0.00,175),('8','211','88','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,176),('8','211','89','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,177),('8','211','89','1',260.00,260.00,16007.16,0.00,0.00,0.00,0.00,178),('8','211','90','1',260.00,260.00,9711.31,0.00,0.00,0.00,0.00,179),('8','211','90','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,180),('8','211','91','1',260.00,260.00,9528.98,0.00,0.00,0.00,0.00,181),('8','211','91','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,182),('8','211','92','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,183),('8','211','92','1',260.00,260.00,9672.90,0.00,0.00,0.00,0.00,184),('8','211','93','1',270.00,270.00,11572.83,0.00,0.00,0.00,0.00,185),('8','211','93','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,186),('8','211','94','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,187),('8','211','94','1',270.00,277.00,5085.42,0.00,0.00,0.00,0.00,188),('8','211','95','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,189),('8','211','95','1',290.00,290.00,3522.34,0.00,0.00,0.00,0.00,190),('8','211','96','1',290.00,290.00,9817.24,0.00,0.00,0.00,0.00,191),('8','211','96','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,192),('8','211','97','1',290.00,290.00,13100.52,0.00,0.00,0.00,0.00,193),('8','211','97','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,194),('8','211','98','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,195),('8','211','98','1',315.00,315.00,24502.64,0.00,0.00,0.00,0.00,196),('8','211','99','1',315.00,315.00,10609.08,0.00,0.00,0.00,0.00,197),('8','211','99','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,198),('8','211','100','1',315.00,315.00,7404.03,0.00,0.00,0.00,0.00,199),('8','211','100','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,200),('8','211','101','1',315.00,315.00,8644.82,0.00,0.00,0.00,0.00,201),('8','211','101','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,202),('8','211','102','1',315.00,315.00,17509.76,0.00,0.00,0.00,0.00,203),('8','211','102','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,204),('8','211','103','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,205),('8','211','103','1',315.00,315.00,6929.60,0.00,0.00,0.00,0.00,206),('8','211','104','1',315.00,315.00,5614.59,0.00,0.00,0.00,0.00,207),('8','211','104','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,208),('8','211','105','1',315.00,315.00,6367.26,0.00,0.00,0.00,0.00,209),('8','211','105','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,210),('8','211','107','1',315.00,315.00,5349.92,0.00,0.00,0.00,0.00,211),('8','211','107','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,212),('8','211','108','1',315.00,315.00,2571.62,0.00,0.00,0.00,0.00,213),('8','211','108','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,214),('8','211','109','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,215),('8','211','109','1',305.00,305.00,18783.33,0.00,0.00,0.00,0.00,216),('8','211','110','1',305.00,305.00,8184.25,0.00,0.00,0.00,0.00,217),('8','211','110','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,218),('8','211','111','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,219),('8','211','111','1',305.00,305.00,4767.28,0.00,0.00,0.00,0.00,220),('8','211','112','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,221),('8','211','112','1',300.00,300.00,5799.46,0.00,0.00,0.00,0.00,222),('8','211','113','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,223),('8','211','113','1',300.00,300.00,4614.80,0.00,0.00,0.00,0.00,224),('8','211','114','1',300.00,300.00,6290.35,0.00,0.00,0.00,0.00,225),('8','211','114','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,226),('8','211','115','1',300.00,300.00,16452.46,0.00,0.00,0.00,0.00,227),('8','211','115','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,228),('8','211','116','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,229),('8','211','116','1',300.00,300.00,6738.64,0.00,0.00,0.00,0.00,230),('8','211','117','1',300.00,300.00,4582.75,0.00,0.00,0.00,0.00,231),('8','211','117','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,232),('8','211','118','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,233),('8','211','118','1',300.00,300.00,4522.62,0.00,0.00,0.00,0.00,234),('8','211','119','1',300.00,300.00,5781.54,0.00,0.00,0.00,0.00,235),('8','211','119','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,236),('8','211','120','1',300.00,300.00,16742.94,0.00,0.00,0.00,0.00,237),('8','211','120','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,238),('8','211','121','1',300.00,300.00,2165.75,0.00,0.00,0.00,0.00,239),('8','211','121','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,240),('8','211','122','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,241),('8','211','122','1',300.00,300.00,5239.48,0.00,0.00,0.00,0.00,242),('8','211','123','1',300.00,300.00,5383.46,0.00,0.00,0.00,0.00,243),('8','211','123','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,244),('8','211','124','1',300.00,300.00,6645.95,0.00,0.00,0.00,0.00,245),('8','211','124','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,246),('8','211','125','1',300.00,300.00,15837.79,0.00,0.00,0.00,0.00,247),('8','211','125','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,248),('8','211','126','1',300.00,300.00,6552.90,0.00,0.00,0.00,0.00,249),('8','211','126','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,250),('8','211','127','1',300.00,300.00,6149.42,0.00,0.00,0.00,0.00,251),('8','211','127','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,252),('8','211','128','1',300.00,300.00,7060.74,0.00,0.00,0.00,0.00,253),('8','211','128','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,254),('8','211','129','1',306.00,300.00,2705.60,0.00,0.00,0.00,0.00,255),('8','211','129','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,256),('8','211','130','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,257),('8','211','130','1',306.00,306.00,12098.09,0.00,0.00,0.00,0.00,258),('8','211','131','1',306.00,306.00,17104.95,0.00,0.00,0.00,0.00,259),('8','211','131','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,260),('8','211','132','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,261),('8','211','132','1',338.00,338.00,2828.46,0.00,0.00,0.00,0.00,262),('8','211','133','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,263),('8','211','133','1',338.00,345.00,3812.42,0.00,0.00,0.00,0.00,264),('8','211','134','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,265),('8','211','134','1',338.00,345.00,6035.27,0.00,0.00,0.00,0.00,266),('8','211','135','1',338.00,345.00,5493.85,0.00,0.00,0.00,0.00,267),('8','211','135','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,268),('8','211','136','1',338.00,345.00,8617.46,0.00,0.00,0.00,0.00,269),('8','211','136','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,270),('8','211','137','1',338.00,345.00,5798.42,0.00,0.00,0.00,0.00,271),('8','211','137','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,272),('8','211','138','1',345.00,345.00,12683.80,0.00,0.00,0.00,0.00,273),('8','211','138','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,274),('8','211','139','1',345.00,345.00,7811.24,0.00,0.00,0.00,0.00,275),('8','211','139','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,276),('8','211','140','1',345.00,345.00,6959.32,0.00,0.00,0.00,0.00,277),('8','211','140','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,278),('8','211','141','1',345.00,345.00,7947.32,0.00,0.00,0.00,0.00,279),('8','211','141','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,280),('8','211','142','1',345.00,345.00,9605.33,0.00,0.00,0.00,0.00,281),('8','211','142','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,282),('8','211','143','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,283),('8','211','143','1',345.00,345.00,9282.36,0.00,0.00,0.00,0.00,284),('8','211','144','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,285),('8','211','144','1',345.00,345.00,7058.17,0.00,0.00,0.00,0.00,286),('8','211','145','1',345.00,345.00,16112.27,0.00,0.00,0.00,0.00,287),('8','211','145','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,288),('8','211','146','1',345.00,345.00,7654.25,0.00,0.00,0.00,0.00,289),('8','211','146','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,290),('8','211','147','1',340.00,340.00,4535.25,0.00,0.00,0.00,0.00,291),('8','211','147','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,292),('8','211','148','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,293),('8','211','148','1',340.00,340.00,5124.70,0.00,0.00,0.00,0.00,294),('8','211','149','1',340.00,340.00,13837.00,0.00,0.00,0.00,0.00,295),('8','211','149','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,296),('8','211','150','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,297),('8','211','150','1',340.00,340.00,5305.22,0.00,0.00,0.00,0.00,298),('8','211','151','1',340.00,300.00,7570.31,0.00,0.00,0.00,0.00,299),('8','211','151','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,300),('8','211','152','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,301),('8','211','152','1',300.00,300.00,9140.49,0.00,0.00,0.00,0.00,302),('8','211','153','1',300.00,300.00,19009.47,0.00,0.00,0.00,0.00,303),('8','211','153','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,304),('8','211','154','1',300.00,300.00,14215.94,0.00,0.00,0.00,0.00,305),('8','211','154','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,306),('8','211','155','1',300.00,300.00,12580.22,0.00,0.00,0.00,0.00,307),('8','211','155','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,308),('8','211','156','1',300.00,300.00,12224.84,0.00,0.00,0.00,0.00,309),('8','211','156','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,310),('8','211','157','1',300.00,300.00,7872.49,0.00,0.00,0.00,0.00,311),('8','211','157','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,312),('8','211','158','1',300.00,300.00,11103.67,0.00,0.00,0.00,0.00,313),('8','211','158','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,314),('8','211','159','1',300.00,300.00,20077.20,0.00,0.00,0.00,0.00,315),('8','211','159','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,316),('8','211','160','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,317),('8','211','160','1',300.00,300.00,14066.95,0.00,0.00,0.00,0.00,318),('8','211','161','1',300.00,300.00,10074.00,0.00,0.00,0.00,0.00,319),('8','211','161','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,320),('8','211','162','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,321),('8','211','162','1',300.00,300.00,5077.13,0.00,0.00,0.00,0.00,322),('8','211','163','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,323),('8','211','163','1',300.00,300.00,16856.70,0.00,0.00,0.00,0.00,324),('8','211','164','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,325),('8','211','164','1',300.00,300.00,11199.12,0.00,0.00,0.00,0.00,326),('8','211','165','1',300.00,300.00,4918.63,0.00,0.00,0.00,0.00,327),('8','211','165','2',0.00,0.00,0.00,0.00,0.00,0.00,0.00,328);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('8',1,'211','PRODUCT TANK','Tank Containing Petroleum product.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('8','211','1',1,0,'1','PMS TANK 1',60000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','926','2022-08-06 09:01:10','2022-08-13 11:28:39','467',5,0),('8','211','1',2,0,'1','PMS TANK 2',39000.00,0.00,NULL,'TANK CONTAINING PETROLEUM PRODUCTS','926','2022-08-06 09:03:47','2022-08-06 09:03:47','926',5,0),('8','211','1',3,0,'2','AGO TANK ',39000.00,0.00,NULL,'TANK CONTAINING DIESEL.','926','2022-08-06 09:28:50','2022-08-06 09:28:50','926',5,0);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'8','211',3,0.00,'2023-03-20 13:38:32'),(2,'8','211',2,0.00,'2023-03-20 13:38:32'),(3,'8','211',1,6148.70,'2023-03-20 13:38:32');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=634 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (1,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,5966250.00,27750.00,0.00,0.00,'2022-08-10 05:32:01','',''),(2,'8','211','1',1,'Sale Id shift 1',0.00,0.00,0.00,981.52,0.00,'2022-08-10 09:52:20','',''),(3,'8','211','1',1,'Sale Id shift 1',0.00,0.00,0.00,1169.47,0.00,'2022-08-10 09:52:20','',''),(4,'8','211',NULL,1,'Sale Id shift 1',462462.85,0.00,0.00,0.00,0.00,'2022-08-10 09:52:20','',''),(5,'8','211',NULL,1,'Reception corrector for bridging 1',0.00,0.00,0.00,27750.00,0.00,'2022-08-11 14:16:31','',''),(6,'8','211','1',1,'Received from bridging 1',0.00,0.00,27750.00,0.00,0.00,'2022-08-11 14:16:31','',''),(7,'8','211','1',1,'Sale Id shift 2',0.00,0.00,0.00,1091.63,0.00,'2022-08-11 14:19:51','',''),(8,'8','211','1',1,'Sale Id shift 2',0.00,0.00,0.00,1116.88,0.00,'2022-08-11 14:19:51','',''),(9,'8','211','1',1,'Sale Id shift 2',0.00,0.00,0.00,1819.20,0.00,'2022-08-11 14:19:51','',''),(10,'8','211',NULL,1,'Sale Id shift 2',865957.65,0.00,0.00,0.00,0.00,'2022-08-11 14:19:51','',''),(11,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,7095000.00,33000.00,0.00,0.00,'2022-08-13 09:43:23','',''),(12,'8','211','1',1,'Sale Id shift 3',0.00,0.00,0.00,2420.28,0.00,'2022-08-13 10:05:21','',''),(13,'8','211','1',1,'Sale Id shift 3',0.00,0.00,0.00,1925.86,0.00,'2022-08-13 10:05:21','',''),(14,'8','211',NULL,1,'Sale Id shift 3',934420.10,0.00,0.00,0.00,0.00,'2022-08-13 10:05:21','',''),(15,'8','211','1',1,'Sale Id shift 4',0.00,0.00,0.00,2982.97,0.00,'2022-08-13 10:11:24','',''),(16,'8','211','1',1,'Sale Id shift 4',0.00,0.00,0.00,2154.86,0.00,'2022-08-13 10:11:24','',''),(17,'8','211',NULL,1,'Sale Id shift 4',1104633.45,0.00,0.00,0.00,0.00,'2022-08-13 10:11:24','',''),(18,'8','211',NULL,1,'Reception corrector for bridging 3',0.00,0.00,0.00,33000.00,0.00,'2022-08-13 11:35:11','',''),(19,'8','211','1',1,'Received from bridging 3',0.00,0.00,33000.00,0.00,0.00,'2022-08-13 11:35:11','',''),(20,'8','211','1',1,'Sale Id shift 5',0.00,0.00,0.00,1690.70,0.00,'2022-08-14 09:55:57','',''),(21,'8','211','1',1,'Sale Id shift 5',0.00,0.00,0.00,1924.50,0.00,'2022-08-14 09:55:57','',''),(22,'8','211',NULL,1,'Sale Id shift 5',777268.00,0.00,0.00,0.00,0.00,'2022-08-14 09:55:57','',''),(23,'8','211','1',1,'Sale Id shift 6',0.00,0.00,0.00,3998.92,0.00,'2022-08-15 09:00:36','',''),(24,'8','211','1',1,'Sale Id shift 6',0.00,0.00,0.00,3978.41,0.00,'2022-08-15 09:00:36','',''),(25,'8','211','1',1,'Sale Id shift 6',0.00,0.00,0.00,3572.22,0.00,'2022-08-15 09:00:36','',''),(26,'8','211',NULL,1,'Sale Id shift 6',2483153.25,0.00,0.00,0.00,0.00,'2022-08-15 09:00:36','',''),(27,'8','211','1',1,'Sale Id shift 7',0.00,0.00,0.00,1749.71,0.00,'2022-08-16 20:26:19','',''),(28,'8','211','1',1,'Sale Id shift 7',0.00,0.00,0.00,1423.16,0.00,'2022-08-16 20:26:19','',''),(29,'8','211',NULL,1,'Sale Id shift 7',682167.05,0.00,0.00,0.00,0.00,'2022-08-16 20:26:19','',''),(30,'8','211','1',1,'Sale Id shift 8',0.00,0.00,0.00,2791.75,0.00,'2022-08-19 19:41:46','',''),(31,'8','211','1',1,'Sale Id shift 8',0.00,0.00,0.00,1794.22,0.00,'2022-08-19 19:41:46','',''),(32,'8','211',NULL,1,'Sale Id shift 8',985983.55,0.00,0.00,0.00,0.00,'2022-08-19 19:41:46','',''),(33,'8','211','1',1,'Sale Id shift 9',0.00,0.00,0.00,1386.29,0.00,'2022-08-19 19:56:03','',''),(34,'8','211','1',1,'Sale Id shift 9',0.00,0.00,0.00,142.60,0.00,'2022-08-19 19:56:03','',''),(35,'8','211','1',1,'Sale Id shift 9',0.00,0.00,0.00,1471.78,0.00,'2022-08-19 19:56:03','',''),(36,'8','211',NULL,1,'Sale Id shift 9',645144.05,0.00,0.00,0.00,0.00,'2022-08-19 19:56:03','',''),(37,'8','211','1',1,'Sale Id shift 10',0.00,0.00,0.00,1200.21,0.00,'2022-08-19 20:00:36','',''),(38,'8','211','1',1,'Sale Id shift 10',0.00,0.00,0.00,1474.66,0.00,'2022-08-19 20:00:36','',''),(39,'8','211',NULL,1,'Sale Id shift 10',575097.05,0.00,0.00,0.00,0.00,'2022-08-19 20:00:36','',''),(40,'8','211','1',1,'Sale Id shift 11',0.00,0.00,0.00,1081.06,0.00,'2022-08-21 10:32:07','',''),(41,'8','211','1',1,'Sale Id shift 11',0.00,0.00,0.00,1381.44,0.00,'2022-08-21 10:32:07','',''),(42,'8','211',NULL,1,'Sale Id shift 11',529437.50,0.00,0.00,0.00,0.00,'2022-08-21 10:32:07','',''),(43,'8','211','1',1,'Sale Id shift 12',0.00,0.00,0.00,3541.53,0.00,'2022-08-21 12:34:19','',''),(44,'8','211',NULL,1,'Sale Id shift 12',761428.95,0.00,0.00,0.00,0.00,'2022-08-21 12:34:19','',''),(45,'8','211','1',1,'Sale Id shift 13',0.00,0.00,0.00,2558.10,0.00,'2022-08-23 10:36:53','',''),(46,'8','211','1',1,'Sale Id shift 13',0.00,0.00,0.00,5269.12,0.00,'2022-08-23 10:36:53','',''),(47,'8','211','1',1,'Sale Id shift 13',0.00,0.00,0.00,2077.28,0.00,'2022-08-23 10:36:53','',''),(48,'8','211',NULL,1,'Sale Id shift 13',2129467.50,0.00,0.00,0.00,0.00,'2022-08-23 10:36:53','',''),(49,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,10000000.00,50000.00,0.00,0.00,'2022-08-24 00:01:50','',''),(50,'8','211',NULL,1,'Reception corrector for bridging 4',0.00,0.00,0.00,50000.00,0.00,'2022-08-24 13:47:29','',''),(51,'8','211','1',1,'Received from bridging 4',0.00,0.00,50000.00,0.00,0.00,'2022-08-24 13:47:29','',''),(52,'8','211','1',1,'Sale Id shift 14',0.00,0.00,0.00,1774.11,0.00,'2022-08-24 16:58:34','',''),(53,'8','211','1',1,'Sale Id shift 14',0.00,0.00,0.00,1421.39,0.00,'2022-08-24 16:58:34','',''),(54,'8','211',NULL,1,'Sale Id shift 14',639100.00,0.00,0.00,0.00,0.00,'2022-08-24 16:58:34','',''),(55,'8','211','1',1,'Sale Id shift 16',0.00,0.00,0.00,1842.09,0.00,'2022-08-25 08:41:21','',''),(56,'8','211','1',1,'Sale Id shift 16',0.00,0.00,0.00,1469.84,0.00,'2022-08-25 08:41:21','',''),(57,'8','211',NULL,1,'Sale Id shift 16',662386.00,0.00,0.00,0.00,0.00,'2022-08-25 08:41:21','',''),(58,'8','211','1',1,'Sale Id shift 17',0.00,0.00,0.00,1369.16,0.00,'2022-08-26 09:57:58','',''),(59,'8','211','1',1,'Sale Id shift 17',0.00,0.00,0.00,2008.14,0.00,'2022-08-26 09:57:58','',''),(60,'8','211',NULL,1,'Sale Id shift 17',675460.00,0.00,0.00,0.00,0.00,'2022-08-26 09:57:58','',''),(61,'8','211','1',1,'Sale Id shift 18',0.00,0.00,0.00,1753.30,0.00,'2022-08-27 08:16:22','',''),(62,'8','211','1',1,'Sale Id shift 18',0.00,0.00,0.00,1670.82,0.00,'2022-08-27 08:16:22','',''),(63,'8','211',NULL,1,'Sale Id shift 18',684824.00,0.00,0.00,0.00,0.00,'2022-08-27 08:16:22','',''),(64,'8','211','1',1,'Sale Id shift 19',0.00,0.00,0.00,1467.82,0.00,'2022-08-28 10:20:28','',''),(65,'8','211','1',1,'Sale Id shift 19',0.00,0.00,0.00,13.33,0.00,'2022-08-28 10:20:28','',''),(66,'8','211','1',1,'Sale Id shift 19',0.00,0.00,0.00,2050.69,0.00,'2022-08-28 10:20:28','',''),(67,'8','211',NULL,1,'Sale Id shift 19',706368.00,0.00,0.00,0.00,0.00,'2022-08-28 10:20:28','',''),(68,'8','211','1',1,'Sale Id shift 20',0.00,0.00,0.00,4569.86,0.00,'2022-08-29 09:15:48','',''),(69,'8','211','1',1,'Sale Id shift 20',0.00,0.00,0.00,38.70,0.00,'2022-08-29 09:15:48','',''),(70,'8','211','1',1,'Sale Id shift 20',0.00,0.00,0.00,3882.56,0.00,'2022-08-29 09:15:48','',''),(71,'8','211',NULL,1,'Sale Id shift 20',1698224.00,0.00,0.00,0.00,0.00,'2022-08-29 09:15:48','',''),(72,'8','211','1',1,'Sale Id shift 21',0.00,0.00,0.00,3122.30,0.00,'2022-08-30 08:05:01','',''),(73,'8','211','1',1,'Sale Id shift 21',0.00,0.00,0.00,1502.35,0.00,'2022-08-30 08:05:01','',''),(74,'8','211',NULL,1,'Sale Id shift 21',924930.00,0.00,0.00,0.00,0.00,'2022-08-30 08:05:01','',''),(75,'8','211','1',1,'Sale Id shift 22',0.00,0.00,0.00,2708.52,0.00,'2022-08-31 07:38:21','',''),(76,'8','211','1',1,'Sale Id shift 22',0.00,0.00,0.00,1833.95,0.00,'2022-08-31 07:38:21','',''),(77,'8','211',NULL,1,'Sale Id shift 22',908494.00,0.00,0.00,0.00,0.00,'2022-08-31 07:38:21','',''),(78,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,6240000.00,32000.00,0.00,0.00,'2022-08-31 13:33:10','',''),(79,'8','211','1',1,'Sale Id shift 23',0.00,0.00,0.00,2323.79,0.00,'2022-09-01 10:13:50','',''),(80,'8','211','1',1,'Sale Id shift 23',0.00,0.00,0.00,1269.52,0.00,'2022-09-01 10:13:50','',''),(81,'8','211',NULL,1,'Sale Id shift 23',700695.45,0.00,0.00,0.00,0.00,'2022-09-01 10:13:50','',''),(82,'8','211',NULL,1,'Reception corrector for bridging 5',0.00,0.00,0.00,32000.00,0.00,'2022-09-01 12:02:31','',''),(83,'8','211','1',1,'Received from bridging 5',0.00,0.00,32000.00,0.00,0.00,'2022-09-01 12:02:31','',''),(84,'8','211','1',1,'Sale Id shift 24',0.00,0.00,0.00,1637.00,0.00,'2022-09-02 09:15:25','',''),(85,'8','211','1',1,'Sale Id shift 24',0.00,0.00,0.00,1531.76,0.00,'2022-09-02 09:15:25','',''),(86,'8','211',NULL,1,'Sale Id shift 24',617908.20,0.00,0.00,0.00,0.00,'2022-09-02 09:15:25','',''),(87,'8','211','1',1,'Sale Id shift 25',0.00,0.00,0.00,2070.59,0.00,'2022-09-03 07:49:04','',''),(88,'8','211','1',1,'Sale Id shift 25',0.00,0.00,0.00,1770.90,0.00,'2022-09-03 07:49:04','',''),(89,'8','211',NULL,1,'Sale Id shift 25',749090.55,0.00,0.00,0.00,0.00,'2022-09-03 07:49:04','',''),(90,'8','211','1',1,'Sale Id shift 26',0.00,0.00,0.00,1523.91,0.00,'2022-09-04 10:16:34','',''),(91,'8','211','1',1,'Sale Id shift 26',0.00,0.00,0.00,1171.16,0.00,'2022-09-04 10:16:34','',''),(92,'8','211','1',1,'Sale Id shift 26',0.00,0.00,0.00,1868.53,0.00,'2022-09-04 10:16:34','',''),(93,'8','211',NULL,1,'Sale Id shift 26',889902.00,0.00,0.00,0.00,0.00,'2022-09-04 10:16:34','',''),(94,'8','211','1',1,'Sale Id shift 27',0.00,0.00,0.00,4535.83,0.00,'2022-09-05 09:08:37','',''),(95,'8','211','1',1,'Sale Id shift 27',0.00,0.00,0.00,20.94,0.00,'2022-09-05 09:08:37','',''),(96,'8','211','1',1,'Sale Id shift 27',0.00,0.00,0.00,4520.58,0.00,'2022-09-05 09:08:37','',''),(97,'8','211',NULL,1,'Sale Id shift 27',1770083.25,0.00,0.00,0.00,0.00,'2022-09-05 09:08:37','',''),(98,'8','211','1',1,'Sale Id shift 28',0.00,0.00,0.00,2274.51,0.00,'2022-09-06 08:44:32','',''),(99,'8','211','1',1,'Sale Id shift 28',0.00,0.00,0.00,1666.23,0.00,'2022-09-06 08:44:32','',''),(100,'8','211',NULL,1,'Sale Id shift 28',768444.30,0.00,0.00,0.00,0.00,'2022-09-06 08:44:32','',''),(101,'8','211','1',1,'Sale Id shift 29',0.00,0.00,0.00,2532.21,0.00,'2022-09-07 08:38:06','',''),(102,'8','211','1',1,'Sale Id shift 29',0.00,0.00,0.00,1448.10,0.00,'2022-09-07 08:38:06','',''),(103,'8','211',NULL,1,'Sale Id shift 29',776160.45,0.00,0.00,0.00,0.00,'2022-09-07 08:38:06','',''),(104,'8','211','1',1,'Sale Id shift 30',0.00,0.00,0.00,2126.22,0.00,'2022-09-08 09:41:43','',''),(105,'8','211','1',1,'Sale Id shift 30',0.00,0.00,0.00,1614.33,0.00,'2022-09-08 09:41:43','',''),(106,'8','211',NULL,1,'Sale Id shift 30',729407.25,0.00,0.00,0.00,0.00,'2022-09-08 09:41:43','',''),(107,'8','211','1',1,'Sale Id shift 31',0.00,0.00,0.00,2698.17,0.00,'2022-09-09 08:55:37','',''),(108,'8','211','1',1,'Sale Id shift 31',0.00,0.00,0.00,1964.69,0.00,'2022-09-09 08:55:37','',''),(109,'8','211',NULL,1,'Sale Id shift 31',909257.70,0.00,0.00,0.00,0.00,'2022-09-09 08:55:37','',''),(110,'8','211','1',1,'Sale Id shift 32',0.00,0.00,0.00,2204.49,0.00,'2022-09-10 11:01:38','',''),(111,'8','211','1',1,'Sale Id shift 32',0.00,0.00,0.00,123.67,0.00,'2022-09-10 11:01:38','',''),(112,'8','211','1',1,'Sale Id shift 32',0.00,0.00,0.00,2505.57,0.00,'2022-09-10 11:01:38','',''),(113,'8','211',NULL,1,'Sale Id shift 32',942577.35,0.00,0.00,0.00,0.00,'2022-09-10 11:01:38','',''),(114,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,9500000.00,50000.00,0.00,0.00,'2022-09-10 12:55:11','',''),(115,'8','211',NULL,1,'Reception corrector for bridging 6',0.00,0.00,0.00,50000.00,0.00,'2022-09-10 23:50:29','',''),(116,'8','211','1',1,'Received from bridging 6',0.00,0.00,50000.00,0.00,0.00,'2022-09-10 23:50:29','',''),(117,'8','211','1',1,'Sale Id shift 33',0.00,0.00,0.00,612.96,0.00,'2022-09-11 09:09:30','',''),(118,'8','211','1',1,'Sale Id shift 33',0.00,0.00,0.00,4406.68,0.00,'2022-09-11 09:09:30','',''),(119,'8','211',NULL,1,'Sale Id shift 33',953731.60,0.00,0.00,0.00,0.00,'2022-09-11 09:09:30','',''),(120,'8','211','1',1,'Sale Id shift 34',0.00,0.00,0.00,5248.35,0.00,'2022-09-12 09:30:22','',''),(121,'8','211','1',1,'Sale Id shift 34',0.00,0.00,0.00,5094.13,0.00,'2022-09-12 09:30:22','',''),(122,'8','211',NULL,1,'Sale Id shift 34',1965071.20,0.00,0.00,0.00,0.00,'2022-09-12 09:30:22','',''),(123,'8','211','1',1,'Sale Id shift 35',0.00,0.00,0.00,2429.56,0.00,'2022-09-13 09:11:22','',''),(124,'8','211','1',1,'Sale Id shift 35',0.00,0.00,0.00,1921.26,0.00,'2022-09-13 09:11:22','',''),(125,'8','211',NULL,1,'Sale Id shift 35',826655.80,0.00,0.00,0.00,0.00,'2022-09-13 09:11:22','',''),(126,'8','211','1',1,'Sale Id shift 36',0.00,0.00,0.00,2725.41,0.00,'2022-09-14 09:22:32','',''),(127,'8','211','1',1,'Sale Id shift 36',0.00,0.00,0.00,2302.97,0.00,'2022-09-14 09:22:32','',''),(128,'8','211',NULL,1,'Sale Id shift 36',955392.20,0.00,0.00,0.00,0.00,'2022-09-14 09:22:32','',''),(129,'8','211','1',1,'Sale Id shift 37',0.00,0.00,0.00,2222.31,0.00,'2022-09-15 08:33:35','',''),(130,'8','211','1',1,'Sale Id shift 37',0.00,0.00,0.00,1341.05,0.00,'2022-09-15 08:33:35','',''),(131,'8','211',NULL,1,'Sale Id shift 37',677038.40,0.00,0.00,0.00,0.00,'2022-09-15 08:33:35','',''),(132,'8','211','1',1,'Sale Id shift 38',0.00,0.00,0.00,2319.88,0.00,'2022-09-16 08:00:19','',''),(133,'8','211','1',1,'Sale Id shift 38',0.00,0.00,0.00,1937.77,0.00,'2022-09-16 08:00:19','',''),(134,'8','211',NULL,1,'Sale Id shift 38',808953.50,0.00,0.00,0.00,0.00,'2022-09-16 08:00:19','',''),(135,'8','211','1',1,'Sale Id shift 39',0.00,0.00,0.00,1577.11,0.00,'2022-09-17 08:41:17','',''),(136,'8','211','1',1,'Sale Id shift 39',0.00,0.00,0.00,2123.27,0.00,'2022-09-17 08:41:17','',''),(137,'8','211',NULL,1,'Sale Id shift 39',703072.20,0.00,0.00,0.00,0.00,'2022-09-17 08:41:17','',''),(138,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,6270000.00,33000.00,0.00,0.00,'2022-09-17 20:05:40','',''),(139,'8','211','1',1,'Sale Id shift 40',0.00,0.00,0.00,1704.45,0.00,'2022-09-18 09:31:36','',''),(140,'8','211','1',1,'Sale Id shift 40',0.00,0.00,0.00,2048.02,0.00,'2022-09-18 09:31:36','',''),(141,'8','211',NULL,1,'Sale Id shift 40',712969.30,0.00,0.00,0.00,0.00,'2022-09-18 09:31:36','',''),(142,'8','211','1',1,'Sale Id shift 41',0.00,0.00,0.00,1403.53,0.00,'2022-09-20 09:46:36','',''),(143,'8','211','1',1,'Sale Id shift 41',0.00,0.00,0.00,3285.11,0.00,'2022-09-20 09:46:36','',''),(144,'8','211','1',1,'Sale Id shift 41',0.00,0.00,0.00,3849.65,0.00,'2022-09-20 09:46:36','',''),(145,'8','211',NULL,1,'Sale Id shift 41',1622275.10,0.00,0.00,0.00,0.00,'2022-09-20 09:46:36','',''),(146,'8','211','1',1,'Sale Id shift 42',0.00,0.00,0.00,1171.25,0.00,'2022-09-20 09:51:17','',''),(147,'8','211','1',1,'Sale Id shift 42',0.00,0.00,0.00,723.12,0.00,'2022-09-20 09:51:17','',''),(148,'8','211','1',1,'Sale Id shift 42',0.00,0.00,0.00,1351.27,0.00,'2022-09-20 09:51:17','',''),(149,'8','211',NULL,1,'Sale Id shift 42',616671.60,0.00,0.00,0.00,0.00,'2022-09-20 09:51:17','',''),(150,'8','211',NULL,1,'Reception corrector for bridging 7',0.00,0.00,0.00,33200.00,0.00,'2022-09-20 13:21:47','',''),(151,'8','211','1',1,'Received from bridging 7',0.00,0.00,33200.00,0.00,0.00,'2022-09-20 13:21:47','',''),(152,'8','211','1',1,'Sale Id shift 43',0.00,0.00,0.00,1782.57,0.00,'2022-09-21 09:23:19','',''),(153,'8','211','1',1,'Sale Id shift 43',0.00,0.00,0.00,1923.16,0.00,'2022-09-21 09:23:19','',''),(154,'8','211',NULL,1,'Sale Id shift 43',704088.70,0.00,0.00,0.00,0.00,'2022-09-21 09:23:19','',''),(155,'8','211','1',1,'Sale Id shift 44',0.00,0.00,0.00,2869.59,0.00,'2022-09-22 08:34:51','',''),(156,'8','211','1',1,'Sale Id shift 44',0.00,0.00,0.00,623.42,0.00,'2022-09-22 08:34:51','',''),(157,'8','211','1',1,'Sale Id shift 44',0.00,0.00,0.00,975.50,0.00,'2022-09-22 08:34:51','',''),(158,'8','211',NULL,1,'Sale Id shift 44',849016.90,0.00,0.00,0.00,0.00,'2022-09-22 08:34:51','',''),(159,'8','211','1',1,'Sale Id shift 45',0.00,0.00,0.00,2041.74,0.00,'2022-09-23 08:20:10','',''),(160,'8','211','1',1,'Sale Id shift 45',0.00,0.00,0.00,993.76,0.00,'2022-09-23 08:20:10','',''),(161,'8','211',NULL,1,'Sale Id shift 45',576745.00,0.00,0.00,0.00,0.00,'2022-09-23 08:20:10','',''),(162,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,3230000.00,17000.00,0.00,0.00,'2022-09-23 13:54:22','',''),(163,'8','211','1',1,'Sale Id shift 46',0.00,0.00,0.00,2011.90,0.00,'2022-09-24 07:45:14','',''),(164,'8','211','1',1,'Sale Id shift 46',0.00,0.00,0.00,1550.11,0.00,'2022-09-24 07:45:14','',''),(165,'8','211',NULL,1,'Sale Id shift 46',676781.90,0.00,0.00,0.00,0.00,'2022-09-24 07:45:14','',''),(166,'8','211','1',1,'Sale Id shift 47',0.00,0.00,0.00,1895.65,0.00,'2022-09-25 10:10:43','',''),(167,'8','211','1',1,'Sale Id shift 47',0.00,0.00,0.00,1708.57,0.00,'2022-09-25 10:10:43','',''),(168,'8','211',NULL,1,'Sale Id shift 47',684801.80,0.00,0.00,0.00,0.00,'2022-09-25 10:10:43','',''),(169,'8','211',NULL,1,'Reception corrector for bridging 8',0.00,0.00,0.00,17100.00,0.00,'2022-09-25 14:24:12','',''),(170,'8','211','1',1,'Received from bridging 8',0.00,0.00,17100.00,0.00,0.00,'2022-09-25 14:24:12','',''),(171,'8','211','1',1,'Sale Id shift 48',0.00,0.00,0.00,4925.83,0.00,'2022-09-26 09:09:35','',''),(172,'8','211','1',1,'Sale Id shift 48',0.00,0.00,0.00,5248.28,0.00,'2022-09-26 09:09:35','',''),(173,'8','211',NULL,1,'Sale Id shift 48',1933080.90,0.00,0.00,0.00,0.00,'2022-09-26 09:09:35','',''),(174,'8','211','1',1,'Sale Id shift 49',0.00,0.00,0.00,2346.07,0.00,'2022-09-27 08:13:07','',''),(175,'8','211','1',1,'Sale Id shift 49',0.00,0.00,0.00,2198.61,0.00,'2022-09-27 08:13:07','',''),(176,'8','211',NULL,1,'Sale Id shift 49',863489.20,0.00,0.00,0.00,0.00,'2022-09-27 08:13:07','',''),(177,'8','211','1',1,'Sale Id shift 50',0.00,0.00,0.00,2825.41,0.00,'2022-09-28 08:27:00','',''),(178,'8','211','1',1,'Sale Id shift 50',0.00,0.00,0.00,1587.06,0.00,'2022-09-28 08:27:00','',''),(179,'8','211',NULL,1,'Sale Id shift 50',838369.30,0.00,0.00,0.00,0.00,'2022-09-28 08:27:00','',''),(180,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,6080000.00,32000.00,0.00,0.00,'2022-09-28 13:11:49','',''),(181,'8','211','1',1,'Sale Id shift 51',0.00,0.00,0.00,3175.16,0.00,'2022-09-29 07:19:40','',''),(182,'8','211','1',1,'Sale Id shift 51',0.00,0.00,0.00,2458.64,0.00,'2022-09-29 07:19:40','',''),(183,'8','211',NULL,1,'Sale Id shift 51',1070422.00,0.00,0.00,0.00,0.00,'2022-09-29 07:19:40','',''),(184,'8','211',NULL,1,'Reception corrector for bridging 9',0.00,0.00,0.00,32000.00,0.00,'2022-09-29 13:51:27','',''),(185,'8','211','1',1,'Received from bridging 9',0.00,0.00,32000.00,0.00,0.00,'2022-09-29 13:51:27','',''),(186,'8','211','1',1,'Sale Id shift 52',0.00,0.00,0.00,2016.08,0.00,'2022-09-30 07:44:30','',''),(187,'8','211','1',1,'Sale Id shift 52',0.00,0.00,0.00,2884.78,0.00,'2022-09-30 07:44:30','',''),(188,'8','211',NULL,1,'Sale Id shift 52',931163.40,0.00,0.00,0.00,0.00,'2022-09-30 07:44:30','',''),(189,'8','211','1',1,'Sale Id shift 53',0.00,0.00,0.00,2211.49,0.00,'2022-10-01 07:03:43','',''),(190,'8','211','1',1,'Sale Id shift 53',0.00,0.00,0.00,2444.83,0.00,'2022-10-01 07:03:43','',''),(191,'8','211',NULL,1,'Sale Id shift 53',884700.80,0.00,0.00,0.00,0.00,'2022-10-01 07:03:43','',''),(192,'8','211','1',1,'Sale Id shift 54',0.00,0.00,0.00,2085.99,0.00,'2022-10-02 08:55:25','',''),(193,'8','211','1',1,'Sale Id shift 54',0.00,0.00,0.00,2021.18,0.00,'2022-10-02 08:55:25','',''),(194,'8','211',NULL,1,'Sale Id shift 54',780362.30,0.00,0.00,0.00,0.00,'2022-10-02 08:55:25','',''),(195,'8','211','1',1,'Sale Id shift 55',0.00,0.00,0.00,4671.90,0.00,'2022-10-03 09:14:36','',''),(196,'8','211','1',1,'Sale Id shift 55',0.00,0.00,0.00,4826.37,0.00,'2022-10-03 09:14:36','',''),(197,'8','211',NULL,1,'Sale Id shift 55',1804671.30,0.00,0.00,0.00,0.00,'2022-10-03 09:14:36','',''),(198,'8','211','1',1,'Sale Id shift 56',0.00,0.00,0.00,1367.89,0.00,'2022-10-03 13:26:43','',''),(199,'8','211','1',1,'Sale Id shift 56',0.00,0.00,0.00,2.50,0.00,'2022-10-03 13:26:43','',''),(200,'8','211','1',1,'Sale Id shift 56',0.00,0.00,0.00,1218.69,0.00,'2022-10-03 13:26:43','',''),(201,'8','211',NULL,1,'Sale Id shift 56',491925.20,0.00,0.00,0.00,0.00,'2022-10-03 13:26:43','',''),(202,'8','211','1',1,'Sale Id shift 57',0.00,0.00,0.00,1161.34,0.00,'2022-10-04 08:50:50','',''),(203,'8','211','1',1,'Sale Id shift 57',0.00,0.00,0.00,661.28,0.00,'2022-10-04 08:50:50','',''),(204,'8','211',NULL,1,'Sale Id shift 57',346297.80,0.00,0.00,0.00,0.00,'2022-10-04 08:50:50','',''),(205,'8','211','1',1,'Sale Id shift 58',0.00,0.00,0.00,2677.87,0.00,'2022-10-05 10:10:15','',''),(206,'8','211','1',1,'Sale Id shift 58',0.00,0.00,0.00,1651.39,0.00,'2022-10-05 10:10:15','',''),(207,'8','211','1',1,'Sale Id shift 58',0.00,0.00,0.00,284.60,0.00,'2022-10-05 10:10:15','',''),(208,'8','211',NULL,1,'Sale Id shift 58',876633.40,0.00,0.00,0.00,0.00,'2022-10-05 10:10:15','',''),(209,'8','211','1',1,'Sale Id shift 59',0.00,0.00,0.00,2982.04,0.00,'2022-10-06 08:34:52','',''),(210,'8','211','1',1,'Sale Id shift 59',0.00,0.00,0.00,3226.51,0.00,'2022-10-06 08:34:52','',''),(211,'8','211',NULL,1,'Sale Id shift 59',1179624.50,0.00,0.00,0.00,0.00,'2022-10-06 08:34:52','',''),(212,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,6270000.00,33000.00,0.00,0.00,'2022-10-07 12:15:08','',''),(213,'8','211',NULL,1,'Reception corrector for bridging 10',0.00,0.00,0.00,33000.00,0.00,'2022-10-08 10:27:39','',''),(214,'8','211','1',1,'Received from bridging 10',0.00,0.00,33000.00,0.00,0.00,'2022-10-08 10:27:39','',''),(215,'8','211','1',1,'Sale Id shift 60',0.00,0.00,0.00,5948.18,0.00,'2022-10-08 10:34:39','',''),(216,'8','211','1',1,'Sale Id shift 60',0.00,0.00,0.00,4608.97,0.00,'2022-10-08 10:34:39','',''),(217,'8','211',NULL,1,'Sale Id shift 60',2005858.50,0.00,0.00,0.00,0.00,'2022-10-08 10:34:39','',''),(218,'8','211','1',1,'Sale Id shift 61',0.00,0.00,0.00,9217.51,0.00,'2022-10-09 10:43:39','',''),(219,'8','211','1',1,'Sale Id shift 61',0.00,0.00,0.00,8200.24,0.00,'2022-10-09 10:43:39','',''),(220,'8','211',NULL,1,'Sale Id shift 61',3309372.50,0.00,0.00,0.00,0.00,'2022-10-09 10:43:39','',''),(221,'8','211','1',1,'Sale Id shift 62',0.00,0.00,0.00,2445.40,0.00,'2022-10-10 08:41:14','',''),(222,'8','211','1',1,'Sale Id shift 62',0.00,0.00,0.00,1857.53,0.00,'2022-10-10 08:41:14','',''),(223,'8','211','1',1,'Sale Id shift 62',0.00,0.00,0.00,1637.24,0.00,'2022-10-10 08:41:14','',''),(224,'8','211',NULL,1,'Sale Id shift 62',1128632.30,0.00,0.00,0.00,0.00,'2022-10-10 08:41:14','',''),(225,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,4313750.00,21250.00,0.00,0.00,'2022-10-10 14:29:03','',''),(226,'8','211',NULL,1,'Reception corrector for bridging 11',0.00,0.00,0.00,21250.00,0.00,'2022-10-11 09:11:17','',''),(227,'8','211','1',1,'Received from bridging 11',0.00,0.00,21250.00,0.00,0.00,'2022-10-11 09:11:17','',''),(228,'8','211','1',1,'Sale Id shift 63',0.00,0.00,0.00,7001.46,0.00,'2022-10-11 10:52:36','',''),(229,'8','211','1',1,'Sale Id shift 63',0.00,0.00,0.00,6583.67,0.00,'2022-10-11 10:52:36','',''),(230,'8','211',NULL,1,'Sale Id shift 63',2757781.39,0.00,0.00,0.00,0.00,'2022-10-11 10:52:36','',''),(231,'8','211','1',1,'Sale Id shift 64',0.00,0.00,0.00,4043.93,0.00,'2022-10-12 13:42:38','',''),(232,'8','211','1',1,'Sale Id shift 64',0.00,0.00,0.00,3725.71,0.00,'2022-10-12 13:42:38','',''),(233,'8','211',NULL,1,'Sale Id shift 64',1577236.92,0.00,0.00,0.00,0.00,'2022-10-12 13:42:38','',''),(234,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,6789600.00,32800.00,0.00,0.00,'2022-10-16 09:37:54','',''),(235,'8','211',NULL,1,'Returned purchase #11 to Lausu Energy Resources',6789600.00,0.00,0.00,32800.00,0.00,'2022-10-16 10:58:52','',''),(236,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,7380000.00,32800.00,0.00,0.00,'2022-10-16 11:14:56','',''),(237,'8','211',NULL,1,'Reception corrector for bridging 13',0.00,0.00,0.00,32800.00,0.00,'2022-10-16 12:49:36','',''),(238,'8','211','1',1,'Received from bridging 13',0.00,0.00,32800.00,0.00,0.00,'2022-10-16 12:49:36','',''),(239,'8','211','1',1,'Sale Id shift 65',0.00,0.00,0.00,3297.82,0.00,'2022-10-16 13:07:43','',''),(240,'8','211','1',1,'Sale Id shift 65',0.00,0.00,0.00,2325.80,0.00,'2022-10-16 13:07:43','',''),(241,'8','211',NULL,1,'Sale Id shift 65',1164089.34,0.00,0.00,0.00,0.00,'2022-10-16 13:07:43','',''),(242,'8','211','1',1,'Sale Id shift 66',0.00,0.00,0.00,13196.07,0.00,'2022-10-17 10:40:39','',''),(243,'8','211','1',1,'Sale Id shift 66',0.00,0.00,0.00,10315.34,0.00,'2022-10-17 10:40:39','',''),(244,'8','211',NULL,1,'Sale Id shift 66',5290067.25,0.00,0.00,0.00,0.00,'2022-10-17 10:40:39','',''),(245,'8','211','1',1,'Sale Id shift 67',0.00,0.00,0.00,2209.24,0.00,'2022-10-18 09:43:34','',''),(246,'8','211','1',1,'Sale Id shift 67',0.00,0.00,0.00,1428.25,0.00,'2022-10-18 09:43:34','',''),(247,'8','211',NULL,1,'Sale Id shift 67',818435.25,0.00,0.00,0.00,0.00,'2022-10-18 09:43:34','',''),(248,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,7531750.00,32050.00,0.00,0.00,'2022-10-22 08:28:01','',''),(249,'8','211',NULL,1,'Reception corrector for bridging 14',0.00,0.00,0.00,32050.00,0.00,'2022-10-22 08:41:18','',''),(250,'8','211','1',1,'Received from bridging 14',0.00,0.00,32050.00,0.00,0.00,'2022-10-22 08:41:18','',''),(251,'8','211','1',1,'Sale Id shift 68',0.00,0.00,0.00,7077.62,0.00,'2022-10-22 08:48:07','',''),(252,'8','211','1',1,'Sale Id shift 68',0.00,0.00,0.00,5042.11,0.00,'2022-10-22 08:48:07','',''),(253,'8','211',NULL,1,'Sale Id shift 68',2848136.55,0.00,0.00,0.00,0.00,'2022-10-22 08:48:07','',''),(254,'8','211','1',1,'Sale Id shift 69',0.00,0.00,0.00,5782.59,0.00,'2022-10-23 09:22:24','',''),(255,'8','211','1',1,'Sale Id shift 69',0.00,0.00,0.00,5366.98,0.00,'2022-10-23 09:22:24','',''),(256,'8','211',NULL,1,'Sale Id shift 69',2620148.95,0.00,0.00,0.00,0.00,'2022-10-23 09:22:24','',''),(257,'8','211','1',1,'Sale Id shift 70',0.00,0.00,0.00,4704.65,0.00,'2022-10-24 08:49:41','',''),(258,'8','211','1',1,'Sale Id shift 70',0.00,0.00,0.00,4024.74,0.00,'2022-10-24 08:49:41','',''),(259,'8','211',NULL,1,'Sale Id shift 70',2051406.65,0.00,0.00,0.00,0.00,'2022-10-24 08:49:41','',''),(260,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,7284000.00,30350.00,0.00,0.00,'2022-10-26 09:12:00','',''),(261,'8','211',NULL,1,'Reception corrector for bridging 15',0.00,0.00,0.00,30350.00,0.00,'2022-10-26 09:35:04','',''),(262,'8','211','1',1,'Received from bridging 15',0.00,0.00,30350.00,0.00,0.00,'2022-10-26 09:35:04','',''),(263,'8','211','1',1,'Sale Id shift 71',0.00,0.00,0.00,4145.28,0.00,'2022-10-26 09:44:26','',''),(264,'8','211','1',1,'Sale Id shift 71',0.00,0.00,0.00,3088.50,0.00,'2022-10-26 09:44:26','',''),(265,'8','211',NULL,1,'Sale Id shift 71',1736107.20,0.00,0.00,0.00,0.00,'2022-10-26 09:44:26','',''),(266,'8','211','1',1,'Sale Id shift 72',0.00,0.00,0.00,5740.72,0.00,'2022-10-27 09:12:16','',''),(267,'8','211','1',1,'Sale Id shift 72',0.00,0.00,0.00,4753.60,0.00,'2022-10-27 09:12:16','',''),(268,'8','211',NULL,1,'Sale Id shift 72',2518636.80,0.00,0.00,0.00,0.00,'2022-10-27 09:12:16','',''),(269,'8','211','1',1,'Sale Id shift 73',0.00,0.00,0.00,6319.95,0.00,'2022-10-28 09:01:45','',''),(270,'8','211','1',1,'Sale Id shift 73',0.00,0.00,0.00,4415.28,0.00,'2022-10-28 09:01:45','',''),(271,'8','211',NULL,1,'Sale Id shift 73',2576455.20,0.00,0.00,0.00,0.00,'2022-10-28 09:01:45','',''),(272,'8','211','1',1,'Sale Id shift 74',0.00,0.00,0.00,961.25,0.00,'2022-10-29 09:12:00','',''),(273,'8','211','1',1,'Sale Id shift 74',0.00,0.00,0.00,894.79,0.00,'2022-10-29 09:12:00','',''),(274,'8','211',NULL,1,'Sale Id shift 74',445449.60,0.00,0.00,0.00,0.00,'2022-10-29 09:12:00','',''),(275,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,8415000.00,33000.00,0.00,0.00,'2022-11-05 23:39:14','',''),(276,'8','211',NULL,1,'Reception corrector for bridging 16',0.00,0.00,0.00,33000.00,0.00,'2022-11-06 10:25:51','',''),(277,'8','211','1',1,'Received from bridging 16',0.00,0.00,33000.00,0.00,0.00,'2022-11-06 10:25:51','',''),(278,'8','211','1',1,'Sale Id shift 75',0.00,0.00,0.00,2449.80,0.00,'2022-11-06 11:06:07','',''),(279,'8','211','1',1,'Sale Id shift 75',0.00,0.00,0.00,3269.02,0.00,'2022-11-06 11:06:07','',''),(280,'8','211',NULL,1,'Sale Id shift 75',1458299.10,0.00,0.00,0.00,0.00,'2022-11-06 11:06:07','',''),(281,'8','211','1',1,'Sale Id shift 76',0.00,0.00,0.00,10213.02,0.00,'2022-11-07 08:34:49','',''),(282,'8','211','1',1,'Sale Id shift 76',0.00,0.00,0.00,8851.44,0.00,'2022-11-07 08:34:49','',''),(283,'8','211',NULL,1,'Sale Id shift 76',4861437.30,0.00,0.00,0.00,0.00,'2022-11-07 08:34:49','',''),(284,'8','211','1',1,'Sale Id shift 77',0.00,0.00,0.00,3885.74,0.00,'2022-11-08 08:52:14','',''),(285,'8','211','1',1,'Sale Id shift 77',0.00,0.00,0.00,3331.32,0.00,'2022-11-08 08:52:14','',''),(286,'8','211',NULL,1,'Sale Id shift 77',1840350.30,0.00,0.00,0.00,0.00,'2022-11-08 08:52:14','',''),(287,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,8440500.00,33100.00,0.00,0.00,'2022-11-08 13:21:31','',''),(288,'8','211',NULL,1,'Reception corrector for bridging 17',0.00,0.00,0.00,33100.00,0.00,'2022-11-09 09:31:49','',''),(289,'8','211','1',1,'Received from bridging 17',0.00,0.00,33100.00,0.00,0.00,'2022-11-09 09:31:49','',''),(290,'8','211','1',1,'Sale Id shift 78',0.00,0.00,0.00,3152.19,0.00,'2022-11-09 10:34:21','',''),(291,'8','211','1',1,'Sale Id shift 78',0.00,0.00,0.00,3953.64,0.00,'2022-11-09 10:34:21','',''),(292,'8','211',NULL,1,'Sale Id shift 78',1811986.65,0.00,0.00,0.00,0.00,'2022-11-09 10:34:21','',''),(293,'8','211','1',1,'Sale Id shift 79',0.00,0.00,0.00,4173.62,0.00,'2022-11-10 08:09:06','',''),(294,'8','211','1',1,'Sale Id shift 79',0.00,0.00,0.00,3461.56,0.00,'2022-11-10 08:09:06','',''),(295,'8','211',NULL,1,'Sale Id shift 79',1946970.90,0.00,0.00,0.00,0.00,'2022-11-10 08:09:06','',''),(296,'8','211','1',1,'Sale Id shift 80',0.00,0.00,0.00,4885.68,0.00,'2022-11-11 10:59:02','',''),(297,'8','211','1',1,'Sale Id shift 80',0.00,0.00,0.00,3630.76,0.00,'2022-11-11 10:59:02','',''),(298,'8','211',NULL,1,'Sale Id shift 80',2171692.20,0.00,0.00,0.00,0.00,'2022-11-11 10:59:02','',''),(299,'8','211','1',1,'Sale Id shift 81',0.00,0.00,0.00,4436.17,0.00,'2022-11-12 09:48:07','',''),(300,'8','211','1',1,'Sale Id shift 81',0.00,0.00,0.00,3925.99,0.00,'2022-11-12 09:48:07','',''),(301,'8','211',NULL,1,'Sale Id shift 81',2132350.80,0.00,0.00,0.00,0.00,'2022-11-12 09:48:07','',''),(302,'8','211','1',1,'Sale Id shift 82',0.00,0.00,0.00,1334.50,0.00,'2022-11-13 08:46:44','',''),(303,'8','211','1',1,'Sale Id shift 82',0.00,0.00,0.00,747.26,0.00,'2022-11-13 08:46:44','',''),(304,'8','211',NULL,1,'Sale Id shift 82',530848.80,0.00,0.00,0.00,0.00,'2022-11-13 08:46:44','',''),(305,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,8415000.00,33000.00,0.00,0.00,'2022-11-15 17:25:01','',''),(306,'8','211',NULL,1,'Reception corrector for bridging 18',0.00,0.00,0.00,33000.00,0.00,'2022-11-16 14:10:40','',''),(307,'8','211','1',1,'Received from bridging 18',0.00,0.00,33000.00,0.00,0.00,'2022-11-16 14:10:40','',''),(308,'8','211','1',1,'Sale Id shift 83',0.00,0.00,0.00,1585.82,0.00,'2022-11-16 15:57:47','',''),(309,'8','211','1',1,'Sale Id shift 83',0.00,0.00,0.00,1730.67,0.00,'2022-11-16 15:57:47','',''),(310,'8','211',NULL,1,'Sale Id shift 83',845704.95,0.00,0.00,0.00,0.00,'2022-11-16 15:57:47','',''),(311,'8','211','1',1,'Sale Id shift 84',0.00,0.00,0.00,4148.36,0.00,'2022-11-17 08:35:37','',''),(312,'8','211','1',1,'Sale Id shift 84',0.00,0.00,0.00,4217.48,0.00,'2022-11-17 08:35:37','',''),(313,'8','211',NULL,1,'Sale Id shift 84',2133289.20,0.00,0.00,0.00,0.00,'2022-11-17 08:35:37','',''),(314,'8','211','1',1,'Sale Id shift 85',0.00,0.00,0.00,3948.49,0.00,'2022-11-18 09:51:33','',''),(315,'8','211','1',1,'Sale Id shift 85',0.00,0.00,0.00,4621.60,0.00,'2022-11-18 09:51:33','',''),(316,'8','211',NULL,1,'Sale Id shift 85',2185372.95,0.00,0.00,0.00,0.00,'2022-11-18 09:51:33','',''),(317,'8','211','1',1,'Sale Id shift 86',0.00,0.00,0.00,4360.63,0.00,'2022-11-19 09:44:26','',''),(318,'8','211','1',1,'Sale Id shift 86',0.00,0.00,0.00,4029.18,0.00,'2022-11-19 09:44:26','',''),(319,'8','211',NULL,1,'Sale Id shift 86',2139401.55,0.00,0.00,0.00,0.00,'2022-11-19 09:44:26','',''),(320,'8','211','1',1,'Sale Id shift 87',0.00,0.00,0.00,2101.47,0.00,'2022-11-20 07:57:18','',''),(321,'8','211','1',1,'Sale Id shift 87',0.00,0.00,0.00,2197.07,0.00,'2022-11-20 07:57:18','',''),(322,'8','211',NULL,1,'Sale Id shift 87',1096127.70,0.00,0.00,0.00,0.00,'2022-11-20 07:57:18','',''),(323,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,4420000.00,17000.00,0.00,0.00,'2022-11-20 23:56:51','',''),(324,'8','211',NULL,1,'Reception corrector for bridging 19',0.00,0.00,0.00,17000.00,0.00,'2022-11-21 09:21:38','',''),(325,'8','211','1',1,'Received from bridging 19',0.00,0.00,17000.00,0.00,0.00,'2022-11-21 09:21:38','',''),(326,'8','211','1',1,'Sale Id shift 88',0.00,0.00,0.00,9835.26,0.00,'2022-11-21 15:13:29','',''),(327,'8','211','1',1,'Sale Id shift 88',0.00,0.00,0.00,7307.10,0.00,'2022-11-21 15:13:29','',''),(328,'8','211',NULL,1,'Sale Id shift 88',4457013.60,0.00,0.00,0.00,0.00,'2022-11-21 15:13:29','',''),(329,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,11700000.00,45000.00,0.00,0.00,'2022-11-28 10:05:42','',''),(330,'8','211',NULL,1,'Reception corrector for bridging 20',0.00,0.00,0.00,45000.00,0.00,'2022-11-28 10:26:58','',''),(331,'8','211','1',1,'Received from bridging 20',0.00,0.00,45000.00,0.00,0.00,'2022-11-28 10:26:58','',''),(332,'8','211','1',1,'Sale Id shift 89',0.00,0.00,0.00,10075.16,0.00,'2022-11-28 10:51:12','',''),(333,'8','211','1',1,'Sale Id shift 89',0.00,0.00,0.00,5932.00,0.00,'2022-11-28 10:51:12','',''),(334,'8','211',NULL,1,'Sale Id shift 89',4161861.60,0.00,0.00,0.00,0.00,'2022-11-28 10:51:12','',''),(335,'8','211','1',1,'Sale Id shift 90',0.00,0.00,0.00,5248.79,0.00,'2022-11-29 10:49:32','',''),(336,'8','211','1',1,'Sale Id shift 90',0.00,0.00,0.00,4462.52,0.00,'2022-11-29 10:49:32','',''),(337,'8','211',NULL,1,'Sale Id shift 90',2524940.60,0.00,0.00,0.00,0.00,'2022-11-29 10:49:32','',''),(338,'8','211','1',1,'Sale Id shift 91',0.00,0.00,0.00,5186.26,0.00,'2022-11-30 13:08:39','',''),(339,'8','211','1',1,'Sale Id shift 91',0.00,0.00,0.00,4342.72,0.00,'2022-11-30 13:08:39','',''),(340,'8','211',NULL,1,'Sale Id shift 91',2477534.80,0.00,0.00,0.00,0.00,'2022-11-30 13:08:39','',''),(341,'8','211','1',1,'Sale Id shift 92',0.00,0.00,0.00,4715.42,0.00,'2022-12-01 09:54:31','',''),(342,'8','211','1',1,'Sale Id shift 92',0.00,0.00,0.00,4957.48,0.00,'2022-12-01 09:54:31','',''),(343,'8','211',NULL,1,'Sale Id shift 92',2514954.00,0.00,0.00,0.00,0.00,'2022-12-01 09:54:31','',''),(344,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,4590000.00,17000.00,0.00,0.00,'2022-12-06 16:20:46','',''),(345,'8','211',NULL,1,'Reception corrector for bridging 21',0.00,0.00,0.00,17000.00,0.00,'2022-12-07 19:54:32','',''),(346,'8','211','1',1,'Received from bridging 21',0.00,0.00,17000.00,0.00,0.00,'2022-12-07 19:54:32','',''),(347,'8','211','1',1,'Sale Id shift 93',0.00,0.00,0.00,6205.30,0.00,'2022-12-08 07:19:15','',''),(348,'8','211','1',1,'Sale Id shift 93',0.00,0.00,0.00,5367.53,0.00,'2022-12-08 07:19:15','',''),(349,'8','211',NULL,1,'Sale Id shift 93',3124664.10,0.00,0.00,0.00,0.00,'2022-12-08 07:19:15','',''),(350,'8','211','1',1,'Sale Id shift 94',0.00,0.00,0.00,2677.77,0.00,'2022-12-08 09:44:00','',''),(351,'8','211','1',1,'Sale Id shift 94',0.00,0.00,0.00,2407.65,0.00,'2022-12-08 09:44:00','',''),(352,'8','211',NULL,1,'Sale Id shift 94',1373063.40,0.00,0.00,0.00,0.00,'2022-12-08 09:44:00','',''),(353,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,9541000.00,32900.00,0.00,0.00,'2022-12-08 17:35:47','',''),(354,'8','211',NULL,1,'Reception corrector for bridging 22',0.00,0.00,0.00,32900.00,0.00,'2022-12-09 14:41:00','',''),(355,'8','211','1',1,'Received from bridging 22',0.00,0.00,32900.00,0.00,0.00,'2022-12-09 14:41:00','',''),(356,'8','211','1',1,'Sale Id shift 95',0.00,0.00,0.00,1583.67,0.00,'2022-12-09 21:08:07','',''),(357,'8','211','1',1,'Sale Id shift 95',0.00,0.00,0.00,1938.67,0.00,'2022-12-09 21:08:07','',''),(358,'8','211',NULL,1,'Sale Id shift 95',1021478.60,0.00,0.00,0.00,0.00,'2022-12-09 21:08:07','',''),(359,'8','211','1',1,'Sale Id shift 96',0.00,0.00,0.00,5246.51,0.00,'2022-12-10 09:40:20','',''),(360,'8','211','1',1,'Sale Id shift 96',0.00,0.00,0.00,4570.73,0.00,'2022-12-10 09:40:20','',''),(361,'8','211',NULL,1,'Sale Id shift 96',2846999.60,0.00,0.00,0.00,0.00,'2022-12-10 09:40:20','',''),(362,'8','211','1',1,'Sale Id shift 97',0.00,0.00,0.00,7412.60,0.00,'2022-12-11 08:55:22','',''),(363,'8','211','1',1,'Sale Id shift 97',0.00,0.00,0.00,5687.92,0.00,'2022-12-11 08:55:22','',''),(364,'8','211',NULL,1,'Sale Id shift 97',3799150.80,0.00,0.00,0.00,0.00,'2022-12-11 08:55:22','',''),(365,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,14143500.00,44900.00,0.00,0.00,'2022-12-12 11:37:59','',''),(366,'8','211',NULL,1,'Reception corrector for bridging 23',0.00,0.00,0.00,44900.00,0.00,'2022-12-12 20:18:55','',''),(367,'8','211','1',1,'Received from bridging 23',0.00,0.00,44900.00,0.00,0.00,'2022-12-12 20:18:55','',''),(368,'8','211','1',1,'Sale Id shift 98',0.00,0.00,0.00,10111.45,0.00,'2022-12-12 22:52:04','',''),(369,'8','211','1',1,'Sale Id shift 98',0.00,0.00,0.00,6046.16,0.00,'2022-12-12 22:52:04','',''),(370,'8','211','1',1,'Sale Id shift 98',0.00,0.00,0.00,8345.03,0.00,'2022-12-12 22:52:04','',''),(371,'8','211',NULL,1,'Sale Id shift 98',7718331.60,0.00,0.00,0.00,0.00,'2022-12-12 22:52:04','',''),(372,'8','211','1',1,'Sale Id shift 99',0.00,0.00,0.00,6103.65,0.00,'2022-12-13 08:30:27','',''),(373,'8','211','1',1,'Sale Id shift 99',0.00,0.00,0.00,4396.45,0.00,'2022-12-13 08:30:27','',''),(374,'8','211','1',1,'Sale Id shift 99',0.00,0.00,0.00,108.98,0.00,'2022-12-13 08:30:27','',''),(375,'8','211',NULL,1,'Sale Id shift 99',3341860.20,0.00,0.00,0.00,0.00,'2022-12-13 08:30:27','',''),(376,'8','211','1',1,'Sale Id shift 100',0.00,0.00,0.00,3990.94,0.00,'2022-12-14 09:59:26','',''),(377,'8','211','1',1,'Sale Id shift 100',0.00,0.00,0.00,3413.09,0.00,'2022-12-14 09:59:26','',''),(378,'8','211',NULL,1,'Sale Id shift 100',2332269.45,0.00,0.00,0.00,0.00,'2022-12-14 09:59:26','',''),(379,'8','211','1',1,'Sale Id shift 101',0.00,0.00,0.00,5068.28,0.00,'2022-12-15 10:11:08','',''),(380,'8','211','1',1,'Sale Id shift 101',0.00,0.00,0.00,3576.54,0.00,'2022-12-15 10:11:08','',''),(381,'8','211',NULL,1,'Sale Id shift 101',2723118.30,0.00,0.00,0.00,0.00,'2022-12-15 10:11:08','',''),(382,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,14080500.00,44700.00,0.00,0.00,'2022-12-18 12:16:57','',''),(383,'8','211',NULL,1,'Reception corrector for bridging 24',0.00,0.00,0.00,44700.00,0.00,'2022-12-19 13:12:05','',''),(384,'8','211','1',1,'Received from bridging 24',0.00,0.00,44700.00,0.00,0.00,'2022-12-19 13:12:05','',''),(385,'8','211','1',1,'Sale Id shift 102',0.00,0.00,0.00,6112.45,0.00,'2022-12-19 17:25:04','',''),(386,'8','211','1',1,'Sale Id shift 102',0.00,0.00,0.00,6365.86,0.00,'2022-12-19 17:25:04','',''),(387,'8','211','1',1,'Sale Id shift 102',0.00,0.00,0.00,5031.45,0.00,'2022-12-19 17:25:04','',''),(388,'8','211',NULL,1,'Sale Id shift 102',5515574.40,0.00,0.00,0.00,0.00,'2022-12-19 17:25:04','',''),(389,'8','211','1',1,'Sale Id shift 103',0.00,0.00,0.00,4097.29,0.00,'2022-12-20 10:25:57','',''),(390,'8','211','1',1,'Sale Id shift 103',0.00,0.00,0.00,142.77,0.00,'2022-12-20 10:25:57','',''),(391,'8','211','1',1,'Sale Id shift 103',0.00,0.00,0.00,2689.54,0.00,'2022-12-20 10:25:57','',''),(392,'8','211',NULL,1,'Sale Id shift 103',2182824.00,0.00,0.00,0.00,0.00,'2022-12-20 10:25:57','',''),(393,'8','211','1',1,'Sale Id shift 104',0.00,0.00,0.00,2715.81,0.00,'2022-12-21 08:34:00','',''),(394,'8','211','1',1,'Sale Id shift 104',0.00,0.00,0.00,2898.78,0.00,'2022-12-21 08:34:00','',''),(395,'8','211',NULL,1,'Sale Id shift 104',1768595.85,0.00,0.00,0.00,0.00,'2022-12-21 08:34:00','',''),(396,'8','211','1',1,'Sale Id shift 105',0.00,0.00,0.00,3334.57,0.00,'2022-12-22 10:24:09','',''),(397,'8','211','1',1,'Sale Id shift 105',0.00,0.00,0.00,3032.69,0.00,'2022-12-22 10:24:09','',''),(398,'8','211',NULL,1,'Sale Id shift 105',2005686.90,0.00,0.00,0.00,0.00,'2022-12-22 10:24:09','',''),(399,'8','211','1',1,'Sale Id shift 107',0.00,0.00,0.00,2859.94,0.00,'2022-12-23 08:12:29','',''),(400,'8','211','1',1,'Sale Id shift 107',0.00,0.00,0.00,990.07,0.00,'2022-12-23 08:12:29','',''),(401,'8','211','1',1,'Sale Id shift 107',0.00,0.00,0.00,1499.91,0.00,'2022-12-23 08:12:29','',''),(402,'8','211',NULL,1,'Sale Id shift 107',1685224.80,0.00,0.00,0.00,0.00,'2022-12-23 08:12:29','',''),(403,'8','211','1',1,'Sale Id shift 108',0.00,0.00,0.00,1306.29,0.00,'2022-12-24 09:23:42','',''),(404,'8','211','1',1,'Sale Id shift 108',0.00,0.00,0.00,75.10,0.00,'2022-12-24 09:23:42','',''),(405,'8','211','1',1,'Sale Id shift 108',0.00,0.00,0.00,1190.23,0.00,'2022-12-24 09:23:42','',''),(406,'8','211',NULL,1,'Sale Id shift 108',810060.30,0.00,0.00,0.00,0.00,'2022-12-24 09:23:42','',''),(407,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,10080000.00,32000.00,0.00,0.00,'2022-12-26 10:52:23','',''),(408,'8','211',NULL,1,'Returned purchase #25 to Lausu Energy Resources',10080000.00,0.00,0.00,32000.00,0.00,'2022-12-26 11:51:41','',''),(409,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,9760000.00,32000.00,0.00,0.00,'2022-12-26 11:53:35','',''),(410,'8','211',NULL,1,'Reception corrector for bridging 25',0.00,0.00,0.00,32000.00,0.00,'2022-12-26 12:00:51','',''),(411,'8','211','1',1,'Received from bridging 25',0.00,0.00,32000.00,0.00,0.00,'2022-12-26 12:00:51','',''),(412,'8','211','1',1,'Sale Id shift 109',0.00,0.00,0.00,10560.15,0.00,'2022-12-26 12:02:15','',''),(413,'8','211','1',1,'Sale Id shift 109',0.00,0.00,0.00,17.78,0.00,'2022-12-26 12:02:15','',''),(414,'8','211','1',1,'Sale Id shift 109',0.00,0.00,0.00,8205.40,0.00,'2022-12-26 12:02:15','',''),(415,'8','211',NULL,1,'Sale Id shift 109',5728915.65,0.00,0.00,0.00,0.00,'2022-12-26 12:02:15','',''),(416,'8','211','1',1,'Sale Id shift 110',0.00,0.00,0.00,4508.20,0.00,'2022-12-27 08:24:08','',''),(417,'8','211','1',1,'Sale Id shift 110',0.00,0.00,0.00,3676.05,0.00,'2022-12-27 08:24:08','',''),(418,'8','211',NULL,1,'Sale Id shift 110',2496196.25,0.00,0.00,0.00,0.00,'2022-12-27 08:24:08','',''),(419,'8','211','1',1,'Sale Id shift 111',0.00,0.00,0.00,2479.55,0.00,'2022-12-28 22:25:18','',''),(420,'8','211','1',1,'Sale Id shift 111',0.00,0.00,0.00,2287.73,0.00,'2022-12-28 22:25:18','',''),(421,'8','211',NULL,1,'Sale Id shift 111',1454020.40,0.00,0.00,0.00,0.00,'2022-12-28 22:25:18','',''),(422,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,13350000.00,44500.00,0.00,0.00,'2022-12-30 20:36:28','',''),(423,'8','211',NULL,1,'Reception corrector for bridging 26',0.00,0.00,0.00,44500.00,0.00,'2022-12-30 21:12:40','',''),(424,'8','211','1',1,'Received from bridging 26',0.00,0.00,44500.00,0.00,0.00,'2022-12-30 21:12:40','',''),(425,'8','211','1',1,'Sale Id shift 112',0.00,0.00,0.00,3343.26,0.00,'2022-12-30 21:13:42','',''),(426,'8','211','1',1,'Sale Id shift 112',0.00,0.00,0.00,2456.20,0.00,'2022-12-30 21:13:42','',''),(427,'8','211',NULL,1,'Sale Id shift 112',1739838.00,0.00,0.00,0.00,0.00,'2022-12-30 21:13:42','',''),(428,'8','211','1',1,'Sale Id shift 113',0.00,0.00,0.00,3114.59,0.00,'2022-12-31 08:45:34','',''),(429,'8','211','1',1,'Sale Id shift 113',0.00,0.00,0.00,1500.21,0.00,'2022-12-31 08:45:34','',''),(430,'8','211',NULL,1,'Sale Id shift 113',1384440.00,0.00,0.00,0.00,0.00,'2022-12-31 08:45:34','',''),(431,'8','211','1',1,'Sale Id shift 114',0.00,0.00,0.00,6025.38,0.00,'2023-01-01 08:32:53','',''),(432,'8','211','1',1,'Sale Id shift 114',0.00,0.00,0.00,264.97,0.00,'2023-01-01 08:32:53','',''),(433,'8','211',NULL,1,'Sale Id shift 114',1887105.00,0.00,0.00,0.00,0.00,'2023-01-01 08:32:53','',''),(434,'8','211','1',1,'Sale Id shift 115',0.00,0.00,0.00,8870.67,0.00,'2023-01-02 08:47:57','',''),(435,'8','211','1',1,'Sale Id shift 115',0.00,0.00,0.00,7581.79,0.00,'2023-01-02 08:47:57','',''),(436,'8','211',NULL,1,'Sale Id shift 115',4935738.00,0.00,0.00,0.00,0.00,'2023-01-02 08:47:57','',''),(437,'8','211','1',1,'Sale Id shift 116',0.00,0.00,0.00,3512.65,0.00,'2023-01-03 15:51:50','',''),(438,'8','211','1',1,'Sale Id shift 116',0.00,0.00,0.00,3225.99,0.00,'2023-01-03 15:51:50','',''),(439,'8','211',NULL,1,'Sale Id shift 116',2021592.00,0.00,0.00,0.00,0.00,'2023-01-03 15:51:50','',''),(440,'8','211','1',1,'Sale Id shift 117',0.00,0.00,0.00,1924.87,0.00,'2023-01-06 12:10:01','',''),(441,'8','211','1',1,'Sale Id shift 117',0.00,0.00,0.00,2657.88,0.00,'2023-01-06 12:10:01','',''),(442,'8','211',NULL,1,'Sale Id shift 117',1374825.00,0.00,0.00,0.00,0.00,'2023-01-06 12:10:01','',''),(443,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,8640000.00,28800.00,0.00,0.00,'2023-01-07 16:12:38','',''),(444,'8','211',NULL,1,'Reception corrector for bridging 27',0.00,0.00,0.00,28800.00,0.00,'2023-01-07 20:42:32','',''),(445,'8','211','1',1,'Received from bridging 27',0.00,0.00,28800.00,0.00,0.00,'2023-01-07 20:42:32','',''),(446,'8','211','1',1,'Sale Id shift 118',0.00,0.00,0.00,2465.74,0.00,'2023-01-07 21:09:14','',''),(447,'8','211','1',1,'Sale Id shift 118',0.00,0.00,0.00,2056.88,0.00,'2023-01-07 21:09:14','',''),(448,'8','211',NULL,1,'Sale Id shift 118',1356786.00,0.00,0.00,0.00,0.00,'2023-01-07 21:09:14','',''),(449,'8','211','1',1,'Sale Id shift 119',0.00,0.00,0.00,3054.16,0.00,'2023-01-08 10:04:55','',''),(450,'8','211','1',1,'Sale Id shift 119',0.00,0.00,0.00,2727.38,0.00,'2023-01-08 10:04:55','',''),(451,'8','211',NULL,1,'Sale Id shift 119',1734462.00,0.00,0.00,0.00,0.00,'2023-01-08 10:04:55','',''),(452,'8','211','1',1,'Sale Id shift 120',0.00,0.00,0.00,8729.11,0.00,'2023-01-09 09:19:52','',''),(453,'8','211','1',1,'Sale Id shift 120',0.00,0.00,0.00,8013.83,0.00,'2023-01-09 09:19:52','',''),(454,'8','211',NULL,1,'Sale Id shift 120',5022882.00,0.00,0.00,0.00,0.00,'2023-01-09 09:19:52','',''),(455,'8','211','1',1,'Sale Id shift 121',0.00,0.00,0.00,858.18,0.00,'2023-01-10 08:50:05','',''),(456,'8','211','1',1,'Sale Id shift 121',0.00,0.00,0.00,1307.57,0.00,'2023-01-10 08:50:05','',''),(457,'8','211',NULL,1,'Sale Id shift 121',649725.00,0.00,0.00,0.00,0.00,'2023-01-10 08:50:05','',''),(458,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,9900000.00,33000.00,0.00,0.00,'2023-01-13 22:06:45','',''),(459,'8','211',NULL,1,'Reception corrector for bridging 28',0.00,0.00,0.00,33000.00,0.00,'2023-01-13 22:20:11','',''),(460,'8','211','1',1,'Received from bridging 28',0.00,0.00,33000.00,0.00,0.00,'2023-01-13 22:20:11','',''),(461,'8','211','1',1,'Sale Id shift 122',0.00,0.00,0.00,2314.96,0.00,'2023-01-14 08:45:46','',''),(462,'8','211','1',1,'Sale Id shift 122',0.00,0.00,0.00,2924.52,0.00,'2023-01-14 08:45:46','',''),(463,'8','211',NULL,1,'Sale Id shift 122',1571844.00,0.00,0.00,0.00,0.00,'2023-01-14 08:45:46','',''),(464,'8','211','1',1,'Sale Id shift 123',0.00,0.00,0.00,2491.01,0.00,'2023-01-14 08:48:36','',''),(465,'8','211','1',1,'Sale Id shift 123',0.00,0.00,0.00,2892.45,0.00,'2023-01-14 08:48:36','',''),(466,'8','211',NULL,1,'Sale Id shift 123',1615038.00,0.00,0.00,0.00,0.00,'2023-01-14 08:48:36','',''),(467,'8','211','1',1,'Sale Id shift 124',0.00,0.00,0.00,3104.32,0.00,'2023-01-15 09:25:00','',''),(468,'8','211','1',1,'Sale Id shift 124',0.00,0.00,0.00,3541.63,0.00,'2023-01-15 09:25:00','',''),(469,'8','211',NULL,1,'Sale Id shift 124',1993785.00,0.00,0.00,0.00,0.00,'2023-01-15 09:25:00','',''),(470,'8','211','1',1,'Sale Id shift 125',0.00,0.00,0.00,8061.68,0.00,'2023-01-16 08:35:21','',''),(471,'8','211','1',1,'Sale Id shift 125',0.00,0.00,0.00,7776.11,0.00,'2023-01-16 08:35:21','',''),(472,'8','211',NULL,1,'Sale Id shift 125',4751337.00,0.00,0.00,0.00,0.00,'2023-01-16 08:35:21','',''),(473,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,10500000.00,35000.00,0.00,0.00,'2023-01-19 16:51:26','',''),(474,'8','211',NULL,1,'Reception corrector for bridging 29',0.00,0.00,0.00,35000.00,0.00,'2023-01-19 17:04:56','',''),(475,'8','211','1',1,'Received from bridging 29',0.00,0.00,35000.00,0.00,0.00,'2023-01-19 17:04:56','',''),(476,'8','211','1',1,'Sale Id shift 126',0.00,0.00,0.00,3440.29,0.00,'2023-01-19 17:05:59','',''),(477,'8','211','1',1,'Sale Id shift 126',0.00,0.00,0.00,3112.61,0.00,'2023-01-19 17:05:59','',''),(478,'8','211',NULL,1,'Sale Id shift 126',1965870.00,0.00,0.00,0.00,0.00,'2023-01-19 17:05:59','',''),(479,'8','211','1',1,'Sale Id shift 127',0.00,0.00,0.00,3373.96,0.00,'2023-01-20 08:26:22','',''),(480,'8','211','1',1,'Sale Id shift 127',0.00,0.00,0.00,2775.46,0.00,'2023-01-20 08:26:22','',''),(481,'8','211',NULL,1,'Sale Id shift 127',1844826.00,0.00,0.00,0.00,0.00,'2023-01-20 08:26:22','',''),(482,'8','211','1',1,'Sale Id shift 128',0.00,0.00,0.00,3993.08,0.00,'2023-01-21 09:06:11','',''),(483,'8','211','1',1,'Sale Id shift 128',0.00,0.00,0.00,3067.66,0.00,'2023-01-21 09:06:11','',''),(484,'8','211',NULL,1,'Sale Id shift 128',2118222.00,0.00,0.00,0.00,0.00,'2023-01-21 09:06:11','',''),(485,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,5140800.00,16800.00,0.00,0.00,'2023-01-21 17:41:46','',''),(486,'8','211',NULL,1,'Reception corrector for bridging 30',0.00,0.00,0.00,16800.00,0.00,'2023-01-21 18:15:30','',''),(487,'8','211','1',1,'Received from bridging 30',0.00,0.00,16800.00,0.00,0.00,'2023-01-21 18:15:30','',''),(488,'8','211','1',1,'Sale Id shift 129',0.00,0.00,0.00,1346.35,0.00,'2023-01-22 09:36:50','',''),(489,'8','211','1',1,'Sale Id shift 129',0.00,0.00,0.00,1359.25,0.00,'2023-01-22 09:36:50','',''),(490,'8','211',NULL,1,'Sale Id shift 129',827913.60,0.00,0.00,0.00,0.00,'2023-01-22 09:36:50','',''),(491,'8','211','1',1,'Sale Id shift 130',0.00,0.00,0.00,5929.25,0.00,'2023-01-22 09:42:13','',''),(492,'8','211','1',1,'Sale Id shift 130',0.00,0.00,0.00,6168.84,0.00,'2023-01-22 09:42:13','',''),(493,'8','211',NULL,1,'Sale Id shift 130',3702015.54,0.00,0.00,0.00,0.00,'2023-01-22 09:42:13','',''),(494,'8','211','1',1,'Sale Id shift 131',0.00,0.00,0.00,10067.80,0.00,'2023-01-23 08:21:10','',''),(495,'8','211','1',1,'Sale Id shift 131',0.00,0.00,0.00,7037.15,0.00,'2023-01-23 08:21:10','',''),(496,'8','211',NULL,1,'Sale Id shift 131',5234114.70,0.00,0.00,0.00,0.00,'2023-01-23 08:21:10','',''),(497,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,11154000.00,33000.00,0.00,0.00,'2023-01-31 22:18:28','',''),(498,'8','211',NULL,1,'Reception corrector for bridging 31',0.00,0.00,0.00,33000.00,0.00,'2023-01-31 22:29:53','',''),(499,'8','211','1',1,'Received from bridging 31',0.00,0.00,33000.00,0.00,0.00,'2023-01-31 22:29:53','',''),(500,'8','211','1',1,'Sale Id shift 132',0.00,0.00,0.00,1981.84,0.00,'2023-01-31 22:39:42','',''),(501,'8','211','1',1,'Sale Id shift 132',0.00,0.00,0.00,846.62,0.00,'2023-01-31 22:39:42','',''),(502,'8','211',NULL,1,'Sale Id shift 132',956019.48,0.00,0.00,0.00,0.00,'2023-01-31 22:39:42','',''),(503,'8','211','1',1,'Sale Id shift 133',0.00,0.00,0.00,2013.92,0.00,'2023-02-01 08:40:01','',''),(504,'8','211','1',1,'Sale Id shift 133',0.00,0.00,0.00,1798.50,0.00,'2023-02-01 08:40:01','',''),(505,'8','211',NULL,1,'Sale Id shift 133',1288597.96,0.00,0.00,0.00,0.00,'2023-02-01 08:40:01','',''),(506,'8','211','1',1,'Sale Id shift 134',0.00,0.00,0.00,3400.78,0.00,'2023-02-02 09:00:28','',''),(507,'8','211','1',1,'Sale Id shift 134',0.00,0.00,0.00,2634.49,0.00,'2023-02-02 09:00:28','',''),(508,'8','211',NULL,1,'Sale Id shift 134',2039921.26,0.00,0.00,0.00,0.00,'2023-02-02 09:00:28','',''),(509,'8','211','1',1,'Sale Id shift 135',0.00,0.00,0.00,2559.30,0.00,'2023-02-03 11:35:44','',''),(510,'8','211','1',1,'Sale Id shift 135',0.00,0.00,0.00,2934.55,0.00,'2023-02-03 11:35:44','',''),(511,'8','211',NULL,1,'Sale Id shift 135',1856921.30,0.00,0.00,0.00,0.00,'2023-02-03 11:35:44','',''),(512,'8','211','1',1,'Sale Id shift 136',0.00,0.00,0.00,4356.98,0.00,'2023-02-04 07:38:55','',''),(513,'8','211','1',1,'Sale Id shift 136',0.00,0.00,0.00,4260.48,0.00,'2023-02-04 07:38:55','',''),(514,'8','211',NULL,1,'Sale Id shift 136',2912701.48,0.00,0.00,0.00,0.00,'2023-02-04 07:38:55','',''),(515,'8','211','1',1,'Sale Id shift 137',0.00,0.00,0.00,268.08,0.00,'2023-02-05 10:00:30','',''),(516,'8','211','1',1,'Sale Id shift 137',0.00,0.00,0.00,5530.34,0.00,'2023-02-05 10:00:30','',''),(517,'8','211',NULL,1,'Sale Id shift 137',1959865.96,0.00,0.00,0.00,0.00,'2023-02-05 10:00:30','',''),(518,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,11316000.00,32800.00,0.00,0.00,'2023-02-07 11:16:28','',''),(519,'8','211',NULL,1,'Reception corrector for bridging 32',0.00,0.00,0.00,32800.00,0.00,'2023-02-07 12:03:37','',''),(520,'8','211','1',1,'Received from bridging 32',0.00,0.00,32800.00,0.00,0.00,'2023-02-07 12:03:37','',''),(521,'8','211','1',1,'Sale Id shift 138',0.00,0.00,0.00,6121.38,0.00,'2023-02-07 12:35:45','',''),(522,'8','211','1',1,'Sale Id shift 138',0.00,0.00,0.00,6562.42,0.00,'2023-02-07 12:35:45','',''),(523,'8','211',NULL,1,'Sale Id shift 138',4375911.00,0.00,0.00,0.00,0.00,'2023-02-07 12:35:45','',''),(524,'8','211','1',1,'Sale Id shift 139',0.00,0.00,0.00,2856.88,0.00,'2023-02-07 12:44:02','',''),(525,'8','211','1',1,'Sale Id shift 139',0.00,0.00,0.00,4954.36,0.00,'2023-02-07 12:44:02','',''),(526,'8','211',NULL,1,'Sale Id shift 139',2694877.80,0.00,0.00,0.00,0.00,'2023-02-07 12:44:02','',''),(527,'8','211','1',1,'Sale Id shift 140',0.00,0.00,0.00,3275.12,0.00,'2023-02-08 09:22:22','',''),(528,'8','211','1',1,'Sale Id shift 140',0.00,0.00,0.00,3684.20,0.00,'2023-02-08 09:22:22','',''),(529,'8','211',NULL,1,'Sale Id shift 140',2400965.40,0.00,0.00,0.00,0.00,'2023-02-08 09:22:22','',''),(530,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,5899500.00,17100.00,0.00,0.00,'2023-02-09 13:34:21','',''),(531,'8','211',NULL,1,'Reception corrector for bridging 33',0.00,0.00,0.00,17100.00,0.00,'2023-02-09 15:35:45','',''),(532,'8','211','1',1,'Received from bridging 33',0.00,0.00,17100.00,0.00,0.00,'2023-02-09 15:35:45','',''),(533,'8','211','1',1,'Sale Id shift 141',0.00,0.00,0.00,3214.34,0.00,'2023-02-09 16:20:14','',''),(534,'8','211','1',1,'Sale Id shift 141',0.00,0.00,0.00,4732.98,0.00,'2023-02-09 16:20:14','',''),(535,'8','211',NULL,1,'Sale Id shift 141',2741825.40,0.00,0.00,0.00,0.00,'2023-02-09 16:20:14','',''),(536,'8','211','1',1,'Sale Id shift 142',0.00,0.00,0.00,3808.29,0.00,'2023-02-10 18:38:22','',''),(537,'8','211','1',1,'Sale Id shift 142',0.00,0.00,0.00,5797.04,0.00,'2023-02-10 18:38:22','',''),(538,'8','211',NULL,1,'Sale Id shift 142',3313838.85,0.00,0.00,0.00,0.00,'2023-02-10 18:38:23','',''),(539,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,12075000.00,35000.00,0.00,0.00,'2023-02-12 08:11:25','',''),(540,'8','211',NULL,1,'Reception corrector for bridging 34',0.00,0.00,0.00,35000.00,0.00,'2023-02-12 20:59:30','',''),(541,'8','211','1',1,'Received from bridging 34',0.00,0.00,35000.00,0.00,0.00,'2023-02-12 20:59:30','',''),(542,'8','211','1',1,'Sale Id shift 143',0.00,0.00,0.00,4280.70,0.00,'2023-02-12 22:07:25','',''),(543,'8','211','1',1,'Sale Id shift 143',0.00,0.00,0.00,5001.66,0.00,'2023-02-12 22:07:25','',''),(544,'8','211',NULL,1,'Sale Id shift 143',3202414.20,0.00,0.00,0.00,0.00,'2023-02-12 22:07:25','',''),(545,'8','211','1',1,'Sale Id shift 144',0.00,0.00,0.00,4328.40,0.00,'2023-02-12 22:27:25','',''),(546,'8','211','1',1,'Sale Id shift 144',0.00,0.00,0.00,2729.77,0.00,'2023-02-12 22:27:25','',''),(547,'8','211',NULL,1,'Sale Id shift 144',2435068.65,0.00,0.00,0.00,0.00,'2023-02-12 22:27:25','',''),(548,'8','211','1',1,'Sale Id shift 145',0.00,0.00,0.00,7522.82,0.00,'2023-02-13 08:56:47','',''),(549,'8','211','1',1,'Sale Id shift 145',0.00,0.00,0.00,8589.45,0.00,'2023-02-13 08:56:47','',''),(550,'8','211',NULL,1,'Sale Id shift 145',5558733.15,0.00,0.00,0.00,0.00,'2023-02-13 08:56:47','',''),(551,'8','211','1',1,'Sale Id shift 146',0.00,0.00,0.00,3359.85,0.00,'2023-02-14 08:53:01','',''),(552,'8','211','1',1,'Sale Id shift 146',0.00,0.00,0.00,4294.40,0.00,'2023-02-14 08:53:01','',''),(553,'8','211',NULL,1,'Sale Id shift 146',2640716.25,0.00,0.00,0.00,0.00,'2023-02-14 08:53:01','',''),(554,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,9792000.00,28800.00,0.00,0.00,'2023-02-17 23:10:45','',''),(555,'8','211',NULL,1,'Reception corrector for bridging 35',0.00,0.00,0.00,28800.00,0.00,'2023-02-18 12:56:49','',''),(556,'8','211','1',1,'Received from bridging 35',0.00,0.00,28800.00,0.00,0.00,'2023-02-18 12:56:49','',''),(557,'8','211','1',1,'Sale Id shift 147',0.00,0.00,0.00,1644.02,0.00,'2023-02-18 21:23:58','',''),(558,'8','211','1',1,'Sale Id shift 147',0.00,0.00,0.00,2891.23,0.00,'2023-02-18 21:23:58','',''),(559,'8','211',NULL,1,'Sale Id shift 147',1541985.00,0.00,0.00,0.00,0.00,'2023-02-18 21:23:58','',''),(560,'8','211','1',1,'Sale Id shift 148',0.00,0.00,0.00,3772.80,0.00,'2023-02-19 22:52:22','',''),(561,'8','211','1',1,'Sale Id shift 148',0.00,0.00,0.00,1351.90,0.00,'2023-02-19 22:52:22','',''),(562,'8','211',NULL,1,'Sale Id shift 148',1742398.00,0.00,0.00,0.00,0.00,'2023-02-19 22:52:22','',''),(563,'8','211','1',1,'Sale Id shift 149',0.00,0.00,0.00,5935.24,0.00,'2023-02-20 15:38:11','',''),(564,'8','211','1',1,'Sale Id shift 149',0.00,0.00,0.00,7901.76,0.00,'2023-02-20 15:38:11','',''),(565,'8','211',NULL,1,'Sale Id shift 149',4704580.00,0.00,0.00,0.00,0.00,'2023-02-20 15:38:11','',''),(566,'8','211','1',1,'Sale Id shift 150',0.00,0.00,0.00,2309.53,0.00,'2023-02-21 14:33:07','',''),(567,'8','211','1',1,'Sale Id shift 150',0.00,0.00,0.00,2995.69,0.00,'2023-02-21 14:33:07','',''),(568,'8','211',NULL,1,'Sale Id shift 150',1803774.80,0.00,0.00,0.00,0.00,'2023-02-21 14:33:07','',''),(569,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,9855000.00,32850.00,0.00,0.00,'2023-02-24 10:04:36','',''),(570,'8','211',NULL,1,'Reception corrector for bridging 36',0.00,0.00,0.00,32850.00,0.00,'2023-02-24 10:07:13','',''),(571,'8','211','1',1,'Received from bridging 36',0.00,0.00,32850.00,0.00,0.00,'2023-02-24 10:07:13','',''),(572,'8','211','1',1,'Sale Id shift 151',0.00,0.00,0.00,3902.07,0.00,'2023-02-24 15:01:14','',''),(573,'8','211','1',1,'Sale Id shift 151',0.00,0.00,0.00,3668.24,0.00,'2023-02-24 15:01:14','',''),(574,'8','211',NULL,1,'Sale Id shift 151',2573905.40,0.00,0.00,0.00,0.00,'2023-02-24 15:01:14','',''),(575,'8','211','1',1,'Sale Id shift 152',0.00,0.00,0.00,4442.17,0.00,'2023-02-25 10:57:19','',''),(576,'8','211','1',1,'Sale Id shift 152',0.00,0.00,0.00,4698.32,0.00,'2023-02-25 10:57:19','',''),(577,'8','211',NULL,1,'Sale Id shift 152',2742147.00,0.00,0.00,0.00,0.00,'2023-02-25 10:57:19','',''),(578,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,5400000.00,18000.00,0.00,0.00,'2023-02-26 21:28:09','',''),(579,'8','211',NULL,1,'Reception corrector for bridging 37',0.00,0.00,0.00,18000.00,0.00,'2023-02-26 22:24:15','',''),(580,'8','211','1',1,'Received from bridging 37',0.00,0.00,18000.00,0.00,0.00,'2023-02-26 22:24:15','',''),(581,'8','211','1',1,'Sale Id shift 153',0.00,0.00,0.00,9739.34,0.00,'2023-02-27 17:33:14','',''),(582,'8','211','1',1,'Sale Id shift 153',0.00,0.00,0.00,9270.13,0.00,'2023-02-27 17:33:14','',''),(583,'8','211',NULL,1,'Sale Id shift 153',5702841.00,0.00,0.00,0.00,0.00,'2023-02-27 17:33:14','',''),(584,'8','211','1',1,'Sale Id shift 154',0.00,0.00,0.00,7410.72,0.00,'2023-02-28 09:03:46','',''),(585,'8','211','1',1,'Sale Id shift 154',0.00,0.00,0.00,6805.22,0.00,'2023-02-28 09:03:46','',''),(586,'8','211',NULL,1,'Sale Id shift 154',4264782.00,0.00,0.00,0.00,0.00,'2023-02-28 09:03:46','',''),(587,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,9450000.00,31500.00,0.00,0.00,'2023-03-01 16:05:58','',''),(588,'8','211',NULL,1,'Reception corrector for bridging 38',0.00,0.00,0.00,31500.00,0.00,'2023-03-02 09:16:01','',''),(589,'8','211','1',1,'Received from bridging 38',0.00,0.00,31500.00,0.00,0.00,'2023-03-02 09:16:01','',''),(590,'8','211','1',1,'Sale Id shift 155',0.00,0.00,0.00,7102.47,0.00,'2023-03-02 17:30:13','',''),(591,'8','211','1',1,'Sale Id shift 155',0.00,0.00,0.00,5477.75,0.00,'2023-03-02 17:30:13','',''),(592,'8','211',NULL,1,'Sale Id shift 155',3774066.00,0.00,0.00,0.00,0.00,'2023-03-02 17:30:13','',''),(593,'8','211','1',1,'Sale Id shift 156',0.00,0.00,0.00,6058.27,0.00,'2023-03-02 17:37:30','',''),(594,'8','211','1',1,'Sale Id shift 156',0.00,0.00,0.00,6166.57,0.00,'2023-03-02 17:37:30','',''),(595,'8','211',NULL,1,'Sale Id shift 156',3667452.00,0.00,0.00,0.00,0.00,'2023-03-02 17:37:30','',''),(596,'8','211','1',1,'Sale Id shift 157',0.00,0.00,0.00,3938.51,0.00,'2023-03-04 08:30:24','',''),(597,'8','211','1',1,'Sale Id shift 157',0.00,0.00,0.00,3933.98,0.00,'2023-03-04 08:30:24','',''),(598,'8','211',NULL,1,'Sale Id shift 157',2361747.00,0.00,0.00,0.00,0.00,'2023-03-04 08:30:24','',''),(599,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,13500000.00,45000.00,0.00,0.00,'2023-03-04 22:16:12','',''),(600,'8','211',NULL,1,'Reception corrector for bridging 39',0.00,0.00,0.00,45000.00,0.00,'2023-03-04 22:20:23','',''),(601,'8','211','1',1,'Received from bridging 39',0.00,0.00,45000.00,0.00,0.00,'2023-03-04 22:20:23','',''),(602,'8','211','1',1,'Sale Id shift 158',0.00,0.00,0.00,5166.52,0.00,'2023-03-05 11:42:14','',''),(603,'8','211','1',1,'Sale Id shift 158',0.00,0.00,0.00,5937.15,0.00,'2023-03-05 11:42:14','',''),(604,'8','211',NULL,1,'Sale Id shift 158',3331101.00,0.00,0.00,0.00,0.00,'2023-03-05 11:42:14','',''),(605,'8','211','1',1,'Sale Id shift 159',0.00,0.00,0.00,9703.26,0.00,'2023-03-06 09:31:55','',''),(606,'8','211','1',1,'Sale Id shift 159',0.00,0.00,0.00,10373.94,0.00,'2023-03-06 09:31:55','',''),(607,'8','211',NULL,1,'Sale Id shift 159',6023160.00,0.00,0.00,0.00,0.00,'2023-03-06 09:31:55','',''),(608,'8','211','1',1,'Sale Id shift 160',0.00,0.00,0.00,7491.44,0.00,'2023-03-07 09:15:55','',''),(609,'8','211','1',1,'Sale Id shift 160',0.00,0.00,0.00,6575.51,0.00,'2023-03-07 09:15:55','',''),(610,'8','211',NULL,1,'Sale Id shift 160',4220085.00,0.00,0.00,0.00,0.00,'2023-03-07 09:15:55','',''),(611,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,4485000.00,14950.00,0.00,0.00,'2023-03-07 22:50:29','',''),(612,'8','211',NULL,1,'Reception corrector for bridging 40',0.00,0.00,0.00,14950.00,0.00,'2023-03-08 08:28:43','',''),(613,'8','211','1',1,'Received from bridging 40',0.00,0.00,14950.00,0.00,0.00,'2023-03-08 08:28:43','',''),(614,'8','211','1',1,'Sale Id shift 161',0.00,0.00,0.00,1057.24,0.00,'2023-03-08 09:32:43','',''),(615,'8','211','1',1,'Sale Id shift 161',0.00,0.00,0.00,9016.76,0.00,'2023-03-08 09:32:43','',''),(616,'8','211',NULL,1,'Sale Id shift 161',3022200.00,0.00,0.00,0.00,0.00,'2023-03-08 09:32:43','',''),(617,'8','211','1',1,'Sale Id shift 162',0.00,0.00,0.00,5077.13,0.00,'2023-03-09 11:09:00','',''),(618,'8','211',NULL,1,'Sale Id shift 162',1523139.00,0.00,0.00,0.00,0.00,'2023-03-09 11:09:00','',''),(619,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,5040000.00,16800.00,0.00,0.00,'2023-03-12 10:40:20','',''),(620,'8','211',NULL,1,'Reception corrector for bridging 41',0.00,0.00,0.00,16800.00,0.00,'2023-03-13 14:58:12','',''),(621,'8','211','1',1,'Received from bridging 41',0.00,0.00,16800.00,0.00,0.00,'2023-03-13 14:58:12','',''),(622,'8','211','1',1,'Sale Id shift 163',0.00,0.00,0.00,7686.34,0.00,'2023-03-13 22:52:14','',''),(623,'8','211','1',1,'Sale Id shift 163',0.00,0.00,0.00,9170.36,0.00,'2023-03-13 22:52:14','',''),(624,'8','211',NULL,1,'Sale Id shift 163',5057010.00,0.00,0.00,0.00,0.00,'2023-03-13 22:52:14','',''),(625,'8','211',NULL,1,'Purchased from Lausu Energy Resources',0.00,4800000.00,16000.00,0.00,0.00,'2023-03-18 11:58:59','',''),(626,'8','211',NULL,1,'Reception corrector for bridging 42',0.00,0.00,0.00,16000.00,0.00,'2023-03-18 12:49:14','',''),(627,'8','211','1',1,'Received from bridging 42',0.00,0.00,16000.00,0.00,0.00,'2023-03-18 12:49:14','',''),(628,'8','211','1',1,'Sale Id shift 164',0.00,0.00,0.00,5869.26,0.00,'2023-03-18 12:53:37','',''),(629,'8','211','1',1,'Sale Id shift 164',0.00,0.00,0.00,5329.86,0.00,'2023-03-18 12:53:37','',''),(630,'8','211',NULL,1,'Sale Id shift 164',3359736.00,0.00,0.00,0.00,0.00,'2023-03-18 12:53:37','',''),(631,'8','211','1',1,'Sale Id shift 165',0.00,0.00,0.00,2384.63,0.00,'2023-03-20 13:40:14','',''),(632,'8','211','1',1,'Sale Id shift 165',0.00,0.00,0.00,2534.00,0.00,'2023-03-20 13:40:14','',''),(633,'8','211',NULL,1,'Sale Id shift 165',1475589.00,0.00,0.00,0.00,0.00,'2023-03-20 13:40:14','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'8','211',2,0.00,'2023-03-20 13:38:32'),(2,'8','211',1,5848.70,'2023-03-20 13:40:14');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=164 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1,'8','211',1,'Sale Id shift 1',0.00,462462.85,215.00,462462.85,0.00,'2022-08-10 09:52:20'),(2,'8','211',1,'Sale Id shift 2',0.00,865957.65,215.00,865957.65,0.00,'2022-08-11 14:19:51'),(3,'8','211',1,'Sale Id shift 3',0.00,934420.10,215.00,934420.10,0.00,'2022-08-13 10:05:21'),(4,'8','211',1,'Sale Id shift 4',0.00,1104633.45,215.00,1104633.45,0.00,'2022-08-13 10:11:24'),(5,'8','211',1,'Sale Id shift 5',0.00,777268.00,215.00,777268.00,0.00,'2022-08-14 09:55:57'),(6,'8','211',1,'Sale Id shift 6',0.00,2483153.25,215.00,2483153.25,0.00,'2022-08-15 09:00:36'),(7,'8','211',1,'Sale Id shift 7',0.00,682167.05,215.00,682167.05,0.00,'2022-08-16 20:26:19'),(8,'8','211',1,'Sale Id shift 8',0.00,985983.55,207.00,949295.79,-36687.76,'2022-08-19 19:41:46'),(9,'8','211',1,'Sale Id shift 9',0.00,645144.05,207.00,621138.69,-24005.36,'2022-08-19 19:56:03'),(10,'8','211',1,'Sale Id shift 10',0.00,575097.05,207.00,553698.09,-21398.96,'2022-08-19 20:00:36'),(11,'8','211',1,'Sale Id shift 11',0.00,529437.50,207.00,509737.50,-19700.00,'2022-08-21 10:32:07'),(12,'8','211',1,'Sale Id shift 12',0.00,761428.95,207.00,733096.71,-28332.24,'2022-08-21 12:34:19'),(13,'8','211',1,'Sale Id shift 13',0.00,2129467.50,200.00,1980900.00,-148567.50,'2022-08-23 10:36:53'),(14,'8','211',1,'Sale Id shift 14',0.00,639100.00,200.00,639100.00,0.00,'2022-08-24 16:58:34'),(15,'8','211',1,'Sale Id shift 16',0.00,662386.00,195.00,645826.35,-16559.65,'2022-08-25 08:41:21'),(16,'8','211',1,'Sale Id shift 17',0.00,675460.00,195.00,658573.50,-16886.50,'2022-08-26 09:57:58'),(17,'8','211',1,'Sale Id shift 18',0.00,684824.00,195.00,667703.40,-17120.60,'2022-08-27 08:16:22'),(18,'8','211',1,'Sale Id shift 19',0.00,706368.00,195.00,688708.80,-17659.20,'2022-08-28 10:20:28'),(19,'8','211',1,'Sale Id shift 20',0.00,1698224.00,195.00,1655768.40,-42455.60,'2022-08-29 09:15:48'),(20,'8','211',1,'Sale Id shift 21',0.00,924930.00,195.00,901806.75,-23123.25,'2022-08-30 08:05:01'),(21,'8','211',1,'Sale Id shift 22',0.00,908494.00,195.00,885781.65,-22712.35,'2022-08-31 07:38:21'),(22,'8','211',1,'Sale Id shift 23',0.00,700695.45,195.00,700695.45,0.00,'2022-09-01 10:13:50'),(23,'8','211',1,'Sale Id shift 24',0.00,617908.20,195.00,617908.20,0.00,'2022-09-02 09:15:25'),(24,'8','211',1,'Sale Id shift 25',0.00,749090.55,195.00,749090.55,0.00,'2022-09-03 07:49:04'),(25,'8','211',1,'Sale Id shift 26',0.00,889902.00,195.00,889902.00,0.00,'2022-09-04 10:16:34'),(26,'8','211',1,'Sale Id shift 27',0.00,1770083.25,195.00,1770083.25,0.00,'2022-09-05 09:08:37'),(27,'8','211',1,'Sale Id shift 28',0.00,768444.30,195.00,768444.30,0.00,'2022-09-06 08:44:32'),(28,'8','211',1,'Sale Id shift 29',0.00,776160.45,190.00,756258.90,-19901.55,'2022-09-07 08:38:06'),(29,'8','211',1,'Sale Id shift 30',0.00,729407.25,190.00,710704.50,-18702.75,'2022-09-08 09:41:43'),(30,'8','211',1,'Sale Id shift 31',0.00,909257.70,190.00,885943.40,-23314.30,'2022-09-09 08:55:37'),(31,'8','211',1,'Sale Id shift 32',0.00,942577.35,190.00,918408.70,-24168.65,'2022-09-10 11:01:38'),(32,'8','211',1,'Sale Id shift 33',0.00,953731.60,190.00,953731.60,0.00,'2022-09-11 09:09:30'),(33,'8','211',1,'Sale Id shift 34',0.00,1965071.20,190.00,1965071.20,0.00,'2022-09-12 09:30:22'),(34,'8','211',1,'Sale Id shift 35',0.00,826655.80,190.00,826655.80,0.00,'2022-09-13 09:11:22'),(35,'8','211',1,'Sale Id shift 36',0.00,955392.20,190.00,955392.20,0.00,'2022-09-14 09:22:32'),(36,'8','211',1,'Sale Id shift 37',0.00,677038.40,190.00,677038.40,0.00,'2022-09-15 08:33:35'),(37,'8','211',1,'Sale Id shift 38',0.00,808953.50,190.00,808953.50,0.00,'2022-09-16 08:00:19'),(38,'8','211',1,'Sale Id shift 39',0.00,703072.20,190.00,703072.20,0.00,'2022-09-17 08:41:17'),(39,'8','211',1,'Sale Id shift 40',0.00,712969.30,190.00,712969.30,0.00,'2022-09-18 09:31:36'),(40,'8','211',1,'Sale Id shift 41',0.00,1622275.10,190.00,1622275.10,0.00,'2022-09-20 09:46:36'),(41,'8','211',1,'Sale Id shift 42',0.00,616671.60,190.00,616671.60,0.00,'2022-09-20 09:51:17'),(42,'8','211',1,'Sale Id shift 43',0.00,704088.70,190.00,704088.70,0.00,'2022-09-21 09:23:19'),(43,'8','211',1,'Sale Id shift 44',0.00,849016.90,190.00,849016.90,0.00,'2022-09-22 08:34:51'),(44,'8','211',1,'Sale Id shift 45',0.00,576745.00,190.00,576745.00,0.00,'2022-09-23 08:20:10'),(45,'8','211',1,'Sale Id shift 46',0.00,676781.90,190.00,676781.90,0.00,'2022-09-24 07:45:14'),(46,'8','211',1,'Sale Id shift 47',0.00,684801.80,190.00,684801.80,0.00,'2022-09-25 10:10:43'),(47,'8','211',1,'Sale Id shift 48',0.00,1933080.90,190.00,1933080.90,0.00,'2022-09-26 09:09:35'),(48,'8','211',1,'Sale Id shift 49',0.00,863489.20,190.00,863489.20,0.00,'2022-09-27 08:13:07'),(49,'8','211',1,'Sale Id shift 50',0.00,838369.30,190.00,838369.30,0.00,'2022-09-28 08:27:00'),(50,'8','211',1,'Sale Id shift 51',0.00,1070422.00,190.00,1070422.00,0.00,'2022-09-29 07:19:40'),(51,'8','211',1,'Sale Id shift 52',0.00,931163.40,190.00,931163.40,0.00,'2022-09-30 07:44:30'),(52,'8','211',1,'Sale Id shift 53',0.00,884700.80,190.00,884700.80,0.00,'2022-10-01 07:03:43'),(53,'8','211',1,'Sale Id shift 54',0.00,780362.30,190.00,780362.30,0.00,'2022-10-02 08:55:25'),(54,'8','211',1,'Sale Id shift 55',0.00,1804671.30,190.00,1804671.30,0.00,'2022-10-03 09:14:36'),(55,'8','211',1,'Sale Id shift 56',0.00,491925.20,190.00,491925.20,0.00,'2022-10-03 13:26:43'),(56,'8','211',1,'Sale Id shift 57',0.00,346297.80,190.00,346297.80,0.00,'2022-10-04 08:50:50'),(57,'8','211',1,'Sale Id shift 58',0.00,876633.40,190.00,876633.40,0.00,'2022-10-05 10:10:15'),(58,'8','211',1,'Sale Id shift 59',0.00,1179624.50,190.00,1179624.50,0.00,'2022-10-06 08:34:52'),(59,'8','211',1,'Sale Id shift 60',0.00,2005858.50,190.00,2005858.50,0.00,'2022-10-08 10:34:39'),(60,'8','211',1,'Sale Id shift 61',0.00,3309372.50,203.00,3535803.25,226430.75,'2022-10-09 10:43:39'),(61,'8','211',1,'Sale Id shift 62',0.00,1128632.30,203.00,1205854.51,77222.21,'2022-10-10 08:41:14'),(62,'8','211',1,'Sale Id shift 63',0.00,2757781.39,203.00,2757781.39,0.00,'2022-10-11 10:52:36'),(63,'8','211',1,'Sale Id shift 64',0.00,1577236.92,206.00,1600545.84,23308.92,'2022-10-12 13:42:38'),(64,'8','211',1,'Sale Id shift 65',0.00,1164089.34,225.00,1265314.50,101225.16,'2022-10-16 13:07:43'),(65,'8','211',1,'Sale Id shift 66',0.00,5290067.25,225.00,5290067.25,0.00,'2022-10-17 10:40:39'),(66,'8','211',1,'Sale Id shift 67',0.00,818435.25,225.00,818435.25,0.00,'2022-10-18 09:43:34'),(67,'8','211',1,'Sale Id shift 68',0.00,2848136.55,235.00,2848136.55,0.00,'2022-10-22 08:48:07'),(68,'8','211',1,'Sale Id shift 69',0.00,2620148.95,240.00,2675896.80,55747.85,'2022-10-23 09:22:24'),(69,'8','211',1,'Sale Id shift 70',0.00,2051406.65,240.00,2095053.60,43646.95,'2022-10-24 08:49:41'),(70,'8','211',1,'Sale Id shift 71',0.00,1736107.20,240.00,1736107.20,0.00,'2022-10-26 09:44:26'),(71,'8','211',1,'Sale Id shift 72',0.00,2518636.80,250.00,2623580.00,104943.20,'2022-10-27 09:12:16'),(72,'8','211',1,'Sale Id shift 73',0.00,2576455.20,250.00,2683807.50,107352.30,'2022-10-28 09:01:45'),(73,'8','211',1,'Sale Id shift 74',0.00,445449.60,250.00,464010.00,18560.40,'2022-10-29 09:12:00'),(74,'8','211',1,'Sale Id shift 75',0.00,1458299.10,255.00,1458299.10,0.00,'2022-11-06 11:06:07'),(75,'8','211',1,'Sale Id shift 76',0.00,4861437.30,255.00,4861437.30,0.00,'2022-11-07 08:34:49'),(76,'8','211',1,'Sale Id shift 77',0.00,1840350.30,255.00,1840350.30,0.00,'2022-11-08 08:52:14'),(77,'8','211',1,'Sale Id shift 78',0.00,1811986.65,255.00,1811986.65,0.00,'2022-11-09 10:34:21'),(78,'8','211',1,'Sale Id shift 79',0.00,1946970.90,255.00,1946970.90,0.00,'2022-11-10 08:09:06'),(79,'8','211',1,'Sale Id shift 80',0.00,2171692.20,255.00,2171692.20,0.00,'2022-11-11 10:59:02'),(80,'8','211',1,'Sale Id shift 81',0.00,2132350.80,255.00,2132350.80,0.00,'2022-11-12 09:48:07'),(81,'8','211',1,'Sale Id shift 82',0.00,530848.80,255.00,530848.80,0.00,'2022-11-13 08:46:44'),(82,'8','211',1,'Sale Id shift 83',0.00,845704.95,255.00,845704.95,0.00,'2022-11-16 15:57:47'),(83,'8','211',1,'Sale Id shift 84',0.00,2133289.20,255.00,2133289.20,0.00,'2022-11-17 08:35:37'),(84,'8','211',1,'Sale Id shift 85',0.00,2185372.95,255.00,2185372.95,0.00,'2022-11-18 09:51:33'),(85,'8','211',1,'Sale Id shift 86',0.00,2139401.55,255.00,2139401.55,0.00,'2022-11-19 09:44:26'),(86,'8','211',1,'Sale Id shift 87',0.00,1096127.70,255.00,1096127.70,0.00,'2022-11-20 07:57:18'),(87,'8','211',1,'Sale Id shift 88',0.00,4457013.60,260.00,4457013.60,0.00,'2022-11-21 15:13:29'),(88,'8','211',1,'Sale Id shift 89',0.00,4161861.60,260.00,4161861.60,0.00,'2022-11-28 10:51:12'),(89,'8','211',1,'Sale Id shift 90',0.00,2524940.60,260.00,2524940.60,0.00,'2022-11-29 10:49:32'),(90,'8','211',1,'Sale Id shift 91',0.00,2477534.80,260.00,2477534.80,0.00,'2022-11-30 13:08:39'),(91,'8','211',1,'Sale Id shift 92',0.00,2514954.00,260.00,2514954.00,0.00,'2022-12-01 09:54:31'),(92,'8','211',1,'Sale Id shift 93',0.00,3124664.10,270.00,3124664.10,0.00,'2022-12-08 07:19:15'),(93,'8','211',1,'Sale Id shift 94',0.00,1373063.40,277.00,1408661.34,35597.94,'2022-12-08 09:44:00'),(94,'8','211',1,'Sale Id shift 95',0.00,1021478.60,290.00,1021478.60,0.00,'2022-12-09 21:08:07'),(95,'8','211',1,'Sale Id shift 96',0.00,2846999.60,290.00,2846999.60,0.00,'2022-12-10 09:40:20'),(96,'8','211',1,'Sale Id shift 97',0.00,3799150.80,290.00,3799150.80,0.00,'2022-12-11 08:55:22'),(97,'8','211',1,'Sale Id shift 98',0.00,7718331.60,315.00,7718331.60,0.00,'2022-12-12 22:52:04'),(98,'8','211',1,'Sale Id shift 99',0.00,3341860.20,315.00,3341860.20,0.00,'2022-12-13 08:30:27'),(99,'8','211',1,'Sale Id shift 100',0.00,2332269.45,315.00,2332269.45,0.00,'2022-12-14 09:59:26'),(100,'8','211',1,'Sale Id shift 101',0.00,2723118.30,315.00,2723118.30,0.00,'2022-12-15 10:11:08'),(101,'8','211',1,'Sale Id shift 102',0.00,5515574.40,315.00,5515574.40,0.00,'2022-12-19 17:25:04'),(102,'8','211',1,'Sale Id shift 103',0.00,2182824.00,315.00,2182824.00,0.00,'2022-12-20 10:25:57'),(103,'8','211',1,'Sale Id shift 104',0.00,1768595.85,315.00,1768595.85,0.00,'2022-12-21 08:34:00'),(104,'8','211',1,'Sale Id shift 105',0.00,2005686.90,315.00,2005686.90,0.00,'2022-12-22 10:24:09'),(105,'8','211',1,'Sale Id shift 107',0.00,1685224.80,315.00,1685224.80,0.00,'2022-12-23 08:12:29'),(106,'8','211',1,'Sale Id shift 108',0.00,810060.30,315.00,810060.30,0.00,'2022-12-24 09:23:42'),(107,'8','211',1,'Sale Id shift 109',0.00,5728915.65,305.00,5728915.65,0.00,'2022-12-26 12:02:15'),(108,'8','211',1,'Sale Id shift 110',0.00,2496196.25,305.00,2496196.25,0.00,'2022-12-27 08:24:08'),(109,'8','211',1,'Sale Id shift 111',0.00,1454020.40,305.00,1454020.40,0.00,'2022-12-28 22:25:18'),(110,'8','211',1,'Sale Id shift 112',0.00,1739838.00,300.00,1739838.00,0.00,'2022-12-30 21:13:42'),(111,'8','211',1,'Sale Id shift 113',0.00,1384440.00,300.00,1384440.00,0.00,'2022-12-31 08:45:34'),(112,'8','211',1,'Sale Id shift 114',0.00,1887105.00,300.00,1887105.00,0.00,'2023-01-01 08:32:53'),(113,'8','211',1,'Sale Id shift 115',0.00,4935738.00,300.00,4935738.00,0.00,'2023-01-02 08:47:57'),(114,'8','211',1,'Sale Id shift 116',0.00,2021592.00,300.00,2021592.00,0.00,'2023-01-03 15:51:50'),(115,'8','211',1,'Sale Id shift 117',0.00,1374825.00,300.00,1374825.00,0.00,'2023-01-06 12:10:01'),(116,'8','211',1,'Sale Id shift 118',0.00,1356786.00,300.00,1356786.00,0.00,'2023-01-07 21:09:14'),(117,'8','211',1,'Sale Id shift 119',0.00,1734462.00,300.00,1734462.00,0.00,'2023-01-08 10:04:55'),(118,'8','211',1,'Sale Id shift 120',0.00,5022882.00,300.00,5022882.00,0.00,'2023-01-09 09:19:52'),(119,'8','211',1,'Sale Id shift 121',0.00,649725.00,300.00,649725.00,0.00,'2023-01-10 08:50:05'),(120,'8','211',1,'Sale Id shift 122',0.00,1571844.00,300.00,1571844.00,0.00,'2023-01-14 08:45:46'),(121,'8','211',1,'Sale Id shift 123',0.00,1615038.00,300.00,1615038.00,0.00,'2023-01-14 08:48:36'),(122,'8','211',1,'Sale Id shift 124',0.00,1993785.00,300.00,1993785.00,0.00,'2023-01-15 09:25:00'),(123,'8','211',1,'Sale Id shift 125',0.00,4751337.00,300.00,4751337.00,0.00,'2023-01-16 08:35:21'),(124,'8','211',1,'Sale Id shift 126',0.00,1965870.00,300.00,1965870.00,0.00,'2023-01-19 17:05:59'),(125,'8','211',1,'Sale Id shift 127',0.00,1844826.00,300.00,1844826.00,0.00,'2023-01-20 08:26:22'),(126,'8','211',1,'Sale Id shift 128',0.00,2118222.00,300.00,2118222.00,0.00,'2023-01-21 09:06:11'),(127,'8','211',1,'Sale Id shift 129',0.00,827913.60,300.00,811680.00,-16233.60,'2023-01-22 09:36:50'),(128,'8','211',1,'Sale Id shift 130',0.00,3702015.54,306.00,3702015.54,0.00,'2023-01-22 09:42:13'),(129,'8','211',1,'Sale Id shift 131',0.00,5234114.70,306.00,5234114.70,0.00,'2023-01-23 08:21:10'),(130,'8','211',1,'Sale Id shift 132',0.00,956019.48,338.00,956019.48,0.00,'2023-01-31 22:39:42'),(131,'8','211',1,'Sale Id shift 133',0.00,1288597.96,345.00,1315284.90,26686.94,'2023-02-01 08:40:01'),(132,'8','211',1,'Sale Id shift 134',0.00,2039921.26,345.00,2082168.15,42246.89,'2023-02-02 09:00:28'),(133,'8','211',1,'Sale Id shift 135',0.00,1856921.30,345.00,1895378.25,38456.95,'2023-02-03 11:35:44'),(134,'8','211',1,'Sale Id shift 136',0.00,2912701.48,345.00,2973023.70,60322.22,'2023-02-04 07:38:55'),(135,'8','211',1,'Sale Id shift 137',0.00,1959865.96,345.00,2000454.90,40588.94,'2023-02-05 10:00:30'),(136,'8','211',1,'Sale Id shift 138',0.00,4375911.00,345.00,4375911.00,0.00,'2023-02-07 12:35:45'),(137,'8','211',1,'Sale Id shift 139',0.00,2694877.80,345.00,2694877.80,0.00,'2023-02-07 12:44:02'),(138,'8','211',1,'Sale Id shift 140',0.00,2400965.40,345.00,2400965.40,0.00,'2023-02-08 09:22:22'),(139,'8','211',1,'Sale Id shift 141',0.00,2741825.40,345.00,2741825.40,0.00,'2023-02-09 16:20:14'),(140,'8','211',1,'Sale Id shift 142',0.00,3313838.85,345.00,3313838.85,0.00,'2023-02-10 18:38:23'),(141,'8','211',1,'Sale Id shift 143',0.00,3202414.20,345.00,3202414.20,0.00,'2023-02-12 22:07:25'),(142,'8','211',1,'Sale Id shift 144',0.00,2435068.65,345.00,2435068.65,0.00,'2023-02-12 22:27:25'),(143,'8','211',1,'Sale Id shift 145',0.00,5558733.15,345.00,5558733.15,0.00,'2023-02-13 08:56:47'),(144,'8','211',1,'Sale Id shift 146',0.00,2640716.25,345.00,2640716.25,0.00,'2023-02-14 08:53:01'),(145,'8','211',1,'Sale Id shift 147',0.00,1541985.00,340.00,1541985.00,0.00,'2023-02-18 21:23:58'),(146,'8','211',1,'Sale Id shift 148',0.00,1742398.00,340.00,1742398.00,0.00,'2023-02-19 22:52:22'),(147,'8','211',1,'Sale Id shift 149',0.00,4704580.00,340.00,4704580.00,0.00,'2023-02-20 15:38:11'),(148,'8','211',1,'Sale Id shift 150',0.00,1803774.80,340.00,1803774.80,0.00,'2023-02-21 14:33:07'),(149,'8','211',1,'Sale Id shift 151',0.00,2573905.40,300.00,2271093.00,-302812.40,'2023-02-24 15:01:14'),(150,'8','211',1,'Sale Id shift 152',0.00,2742147.00,300.00,2742147.00,0.00,'2023-02-25 10:57:19'),(151,'8','211',1,'Sale Id shift 153',0.00,5702841.00,300.00,5702841.00,0.00,'2023-02-27 17:33:14'),(152,'8','211',1,'Sale Id shift 154',0.00,4264782.00,300.00,4264782.00,0.00,'2023-02-28 09:03:46'),(153,'8','211',1,'Sale Id shift 155',0.00,3774066.00,300.00,3774066.00,0.00,'2023-03-02 17:30:13'),(154,'8','211',1,'Sale Id shift 156',0.00,3667452.00,300.00,3667452.00,0.00,'2023-03-02 17:37:30'),(155,'8','211',1,'Sale Id shift 157',0.00,2361747.00,300.00,2361747.00,0.00,'2023-03-04 08:30:24'),(156,'8','211',1,'Sale Id shift 158',0.00,3331101.00,300.00,3331101.00,0.00,'2023-03-05 11:42:14'),(157,'8','211',1,'Sale Id shift 159',0.00,6023160.00,300.00,6023160.00,0.00,'2023-03-06 09:31:55'),(158,'8','211',1,'Sale Id shift 160',0.00,4220085.00,300.00,4220085.00,0.00,'2023-03-07 09:15:55'),(159,'8','211',1,'Sale Id shift 161',0.00,3022200.00,300.00,3022200.00,0.00,'2023-03-08 09:32:43'),(160,'8','211',1,'Sale Id shift 162',0.00,1523139.00,300.00,1523139.00,0.00,'2023-03-09 11:09:00'),(161,'8','211',1,'Sale Id shift 163',0.00,5057010.00,300.00,5057010.00,0.00,'2023-03-13 22:52:14'),(162,'8','211',1,'Sale Id shift 164',0.00,3359736.00,300.00,3359736.00,0.00,'2023-03-18 12:53:37'),(163,'8','211',1,'Sale Id shift 165',0.00,1475589.00,300.00,1475589.00,0.00,'2023-03-20 13:40:14');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=755 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('8','211',1,'','24','3',0.00,5966250.00,'Purchase Id 1 for 27,750.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-10 05:32:01','',''),('8','211',2,'','supplier','1',5966250.00,0.00,'Purchase Id 1 for 27,750.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-10 05:32:01','',''),('8','211',3,'','20','2',462462.85,0.00,'Sales from shift 1 on 2022-08-10 09:52:20 ','2022-08-10 09:52:20','',''),('8','211',4,'','6.1','5',0.00,462462.85,'Sales from shift 1 on 2022-08-10 09:52:20 ','2022-08-10 09:52:20','',''),('8','211',5,'','20','2',865957.65,0.00,'Sales from shift 2 on 2022-08-11 14:19:51 ','2022-08-11 14:19:51','',''),('8','211',6,'','6.1','5',0.00,865957.65,'Sales from shift 2 on 2022-08-11 14:19:51 ','2022-08-11 14:19:51','',''),('8','211',7,'','2','6',462460.00,0.00,'Payment Id 1 for invoice:1, receipt: 1 by Lausu Energy Resources','2022-08-11 14:21:48','',''),('8','211',8,'','supplier','1',0.00,462460.00,'Payment Id 1 for invoice:1, receipt: 1 by Lausu Energy Resources','2022-08-11 14:21:48','',''),('8','211',9,'','2','6',866000.00,0.00,'Payment Id 2 for invoice:2, receipt: 2 by Lausu Energy Resources','2022-08-11 20:24:26','',''),('8','211',10,'','supplier','1',0.00,866000.00,'Payment Id 2 for invoice:2, receipt: 2 by Lausu Energy Resources','2022-08-11 20:24:26','',''),('8','211',11,'','24','3',0.00,0.00,'Purchase Id 2 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-13 09:43:23','',''),('8','211',12,'','supplier','1',0.00,0.00,'Purchase Id 2 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-13 09:43:23','',''),('8','211',13,'','20','2',934420.10,0.00,'Sales from shift 3 on 2022-08-13 10:05:21 ','2022-08-13 10:05:21','',''),('8','211',14,'','6.1','5',0.00,934420.10,'Sales from shift 3 on 2022-08-13 10:05:21 ','2022-08-13 10:05:21','',''),('8','211',15,'','20','2',1104633.45,0.00,'Sales from shift 4 on 2022-08-13 10:11:24 ','2022-08-13 10:11:24','',''),('8','211',16,'','6.1','5',0.00,1104633.45,'Sales from shift 4 on 2022-08-13 10:11:24 ','2022-08-13 10:11:24','',''),('8','211',17,'','20','2',777268.00,0.00,'Sales from shift 5 on 2022-08-14 09:55:57 ','2022-08-14 09:55:57','',''),('8','211',18,'','6.1','5',0.00,777268.00,'Sales from shift 5 on 2022-08-14 09:55:57 ','2022-08-14 09:55:57','',''),('8','211',19,'','20','2',2483153.25,0.00,'Sales from shift 6 on 2022-08-15 09:00:36 ','2022-08-15 09:00:36','',''),('8','211',20,'','6.1','5',0.00,2483153.25,'Sales from shift 6 on 2022-08-15 09:00:36 ','2022-08-15 09:00:36','',''),('8','211',21,'','2','6',934420.00,0.00,'Payment Id 3 for invoice:3, receipt: 3 by Lausu Energy Resources','2022-08-15 20:11:53','',''),('8','211',22,'','supplier','1',0.00,934420.00,'Payment Id 3 for invoice:3, receipt: 3 by Lausu Energy Resources','2022-08-15 20:11:53','',''),('8','211',23,'','2','6',777260.00,0.00,'Payment Id 4 for invoice:5, receipt: 5 by Lausu Energy Resources','2022-08-15 20:12:10','',''),('8','211',24,'','supplier','1',0.00,777260.00,'Payment Id 4 for invoice:5, receipt: 5 by Lausu Energy Resources','2022-08-15 20:12:10','',''),('8','211',25,'','20','2',682167.05,0.00,'Sales from shift 7 on 2022-08-16 20:26:19 ','2022-08-16 20:26:19','',''),('8','211',26,'','6.1','5',0.00,682167.05,'Sales from shift 7 on 2022-08-16 20:26:19 ','2022-08-16 20:26:19','',''),('8','211',27,'','2','6',682165.00,0.00,'Payment Id 5 for invoice:7, receipt: 7 by Lausu Energy Resources','2022-08-16 20:35:01','',''),('8','211',28,'','supplier','1',0.00,682165.00,'Payment Id 5 for invoice:7, receipt: 7 by Lausu Energy Resources','2022-08-16 20:35:01','',''),('8','211',29,'','20','2',949295.79,0.00,'Sales from shift 8 on 2022-08-19 19:41:46 ','2022-08-19 19:41:46','',''),('8','211',30,'','6.1','5',0.00,949295.79,'Sales from shift 8 on 2022-08-19 19:41:46 ','2022-08-19 19:41:46','',''),('8','211',31,'','20','2',621138.69,0.00,'Sales from shift 9 on 2022-08-19 19:56:03 ','2022-08-19 19:56:03','',''),('8','211',32,'','6.1','5',0.00,621138.69,'Sales from shift 9 on 2022-08-19 19:56:03 ','2022-08-19 19:56:03','',''),('8','211',33,'','20','2',553698.09,0.00,'Sales from shift 10 on 2022-08-19 20:00:36 ','2022-08-19 20:00:36','',''),('8','211',34,'','6.1','5',0.00,553698.09,'Sales from shift 10 on 2022-08-19 20:00:36 ','2022-08-19 20:00:36','',''),('8','211',35,'','20','2',509737.50,0.00,'Sales from shift 11 on 2022-08-21 10:32:07 ','2022-08-21 10:32:07','',''),('8','211',36,'','6.1','5',0.00,509737.50,'Sales from shift 11 on 2022-08-21 10:32:07 ','2022-08-21 10:32:07','',''),('8','211',37,'','20','2',733096.71,0.00,'Sales from shift 12 on 2022-08-21 12:34:19 ','2022-08-21 12:34:19','',''),('8','211',38,'','6.1','5',0.00,733096.71,'Sales from shift 12 on 2022-08-21 12:34:19 ','2022-08-21 12:34:19','',''),('8','211',39,'','2','6',682165.00,0.00,'Payment Id 7 for invoice:7, receipt: 7 by Lausu Energy Resources','2022-08-22 11:29:11','',''),('8','211',40,'','supplier','1',0.00,682165.00,'Payment Id 7 for invoice:7, receipt: 7 by Lausu Energy Resources','2022-08-22 11:29:11','',''),('8','211',41,'','2','6',949205.00,0.00,'Payment Id 8 for invoice:8, receipt: 8 by Lausu Energy Resources','2022-08-22 11:29:40','',''),('8','211',42,'','supplier','1',0.00,949205.00,'Payment Id 8 for invoice:8, receipt: 8 by Lausu Energy Resources','2022-08-22 11:29:40','',''),('8','211',43,'','2','6',0.00,682165.00,'Payment Id 7 for invoice:7, receipt: 7 by Lausu Energy Resources','2022-08-22 12:08:41','',''),('8','211',44,'','supplier','1',682165.00,0.00,'Payment Id 7 for invoice:7, receipt: 7 by Lausu Energy Resources','2022-08-22 12:08:41','',''),('8','211',45,'','2','6',2483150.00,0.00,'Payment Id 6 for invoice:6, receipt: 6 by Lausu Energy Resources','2022-08-22 12:11:15','',''),('8','211',46,'','supplier','1',0.00,2483150.00,'Payment Id 6 for invoice:6, receipt: 6 by Lausu Energy Resources','2022-08-22 12:11:15','',''),('8','211',47,'','2','6',621150.00,0.00,'Payment Id 9 for invoice:9, receipt: 9 by Lausu Energy Resources','2022-08-22 12:12:41','',''),('8','211',48,'','supplier','1',0.00,621150.00,'Payment Id 9 for invoice:9, receipt: 9 by Lausu Energy Resources','2022-08-22 12:12:41','',''),('8','211',49,'','2','6',553700.00,0.00,'Payment Id 10 for invoice:10, receipt: 10 by Lausu Energy Resources','2022-08-22 12:15:12','',''),('8','211',50,'','supplier','1',0.00,553700.00,'Payment Id 10 for invoice:10, receipt: 10 by Lausu Energy Resources','2022-08-22 12:15:12','',''),('8','211',51,'','2','6',733100.00,0.00,'Payment Id 12 for invoice:12, receipt: 12 by Lausu Energy Resources','2022-08-22 12:16:14','',''),('8','211',52,'','supplier','1',0.00,733100.00,'Payment Id 12 for invoice:12, receipt: 12 by Lausu Energy Resources','2022-08-22 12:16:14','',''),('8','211',53,'','2','6',1980900.00,0.00,'Payment Id 13 for invoice:13, receipt: 13 by Lausu Energy Resources','2022-08-22 12:16:42','',''),('8','211',54,'','supplier','1',0.00,1980900.00,'Payment Id 13 for invoice:13, receipt: 13 by Lausu Energy Resources','2022-08-22 12:16:42','',''),('8','211',55,'','2','6',509750.00,0.00,'Payment Id 11 for invoice:11, receipt: 11 by Lausu Energy Resources','2022-08-22 18:34:24','',''),('8','211',56,'','supplier','1',0.00,509750.00,'Payment Id 11 for invoice:11, receipt: 11 by Lausu Energy Resources','2022-08-22 18:34:24','',''),('8','211',57,'','20','2',1980900.00,0.00,'Sales from shift 13 on 2022-08-23 10:36:53 ','2022-08-23 10:36:53','',''),('8','211',58,'','6.1','5',0.00,1980900.00,'Sales from shift 13 on 2022-08-23 10:36:53 ','2022-08-23 10:36:53','',''),('8','211',59,'','24','3',0.00,10000000.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-24 00:01:50','',''),('8','211',60,'','supplier','1',10000000.00,0.00,'Purchase Id 3 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-24 00:01:50','',''),('8','211',61,'','2','6',1104630.00,0.00,'Payment Id 14 for invoice:04, receipt: 04 by Lausu Energy Resources','2022-08-24 00:15:53','',''),('8','211',62,'','supplier','1',0.00,1104630.00,'Payment Id 14 for invoice:04, receipt: 04 by Lausu Energy Resources','2022-08-24 00:15:53','',''),('8','211',63,'','20','2',639100.00,0.00,'Sales from shift 14 on 2022-08-24 16:58:34 ','2022-08-24 16:58:34','',''),('8','211',64,'','6.1','5',0.00,639100.00,'Sales from shift 14 on 2022-08-24 16:58:34 ','2022-08-24 16:58:34','',''),('8','211',65,'','20','2',0.00,0.00,'Sales from shift 15 on 2022-08-25 08:39:02 ','2022-08-25 08:39:02','',''),('8','211',66,'','6.1','5',0.00,0.00,'Sales from shift 15 on 2022-08-25 08:39:02 ','2022-08-25 08:39:02','',''),('8','211',67,'','20','2',645826.35,0.00,'Sales from shift 16 on 2022-08-25 08:41:21 ','2022-08-25 08:41:21','',''),('8','211',68,'','6.1','5',0.00,645826.35,'Sales from shift 16 on 2022-08-25 08:41:21 ','2022-08-25 08:41:21','',''),('8','211',69,'','20','2',658573.50,0.00,'Sales from shift 17 on 2022-08-26 09:57:58 ','2022-08-26 09:57:58','',''),('8','211',70,'','6.1','5',0.00,658573.50,'Sales from shift 17 on 2022-08-26 09:57:58 ','2022-08-26 09:57:58','',''),('8','211',71,'','20','2',667703.40,0.00,'Sales from shift 18 on 2022-08-27 08:16:22 ','2022-08-27 08:16:22','',''),('8','211',72,'','6.1','5',0.00,667703.40,'Sales from shift 18 on 2022-08-27 08:16:22 ','2022-08-27 08:16:22','',''),('8','211',73,'','2','6',667700.00,0.00,'Payment Id 18 for invoice:18, receipt: 18 by Lausu Energy Resources','2022-08-27 09:07:37','',''),('8','211',74,'','supplier','1',0.00,667700.00,'Payment Id 18 for invoice:18, receipt: 18 by Lausu Energy Resources','2022-08-27 09:07:37','',''),('8','211',75,'','2','6',658710.00,0.00,'Payment Id 17 for invoice:17, receipt: 17 by Lausu Energy Resources','2022-08-27 09:08:29','',''),('8','211',76,'','supplier','1',0.00,658710.00,'Payment Id 17 for invoice:17, receipt: 17 by Lausu Energy Resources','2022-08-27 09:08:29','',''),('8','211',77,'','2','6',645825.00,0.00,'Payment Id 16 for invoice:16, receipt: 16 by Lausu Energy Resources','2022-08-27 09:20:08','',''),('8','211',78,'','supplier','1',0.00,645825.00,'Payment Id 16 for invoice:16, receipt: 16 by Lausu Energy Resources','2022-08-27 09:20:08','',''),('8','211',79,'','2','6',639100.00,0.00,'Payment Id 15 for invoice:15, receipt: 15 by Lausu Energy Resources','2022-08-27 10:13:13','',''),('8','211',80,'','supplier','1',0.00,639100.00,'Payment Id 15 for invoice:15, receipt: 15 by Lausu Energy Resources','2022-08-27 10:13:13','',''),('8','211',81,'','20','2',688708.80,0.00,'Sales from shift 19 on 2022-08-28 10:20:28 ','2022-08-28 10:20:28','',''),('8','211',82,'','6.1','5',0.00,688708.80,'Sales from shift 19 on 2022-08-28 10:20:28 ','2022-08-28 10:20:28','',''),('8','211',83,'','20','2',1655768.40,0.00,'Sales from shift 20 on 2022-08-29 09:15:48 ','2022-08-29 09:15:48','',''),('8','211',84,'','6.1','5',0.00,1655768.40,'Sales from shift 20 on 2022-08-29 09:15:48 ','2022-08-29 09:15:48','',''),('8','211',85,'','2','6',688710.00,0.00,'Payment Id 19 for invoice:19, receipt: 19 by Lausu Energy Resources','2022-08-29 20:21:36','',''),('8','211',86,'','supplier','1',0.00,688710.00,'Payment Id 19 for invoice:19, receipt: 19 by Lausu Energy Resources','2022-08-29 20:21:36','',''),('8','211',87,'','2','6',1655770.00,0.00,'Payment Id 20 for invoice:20, receipt: 20 by Lausu Energy Resources','2022-08-29 20:21:54','',''),('8','211',88,'','supplier','1',0.00,1655770.00,'Payment Id 20 for invoice:20, receipt: 20 by Lausu Energy Resources','2022-08-29 20:21:54','',''),('8','211',89,'','20','2',901806.75,0.00,'Sales from shift 21 on 2022-08-30 08:05:01 ','2022-08-30 08:05:01','',''),('8','211',90,'','6.1','5',0.00,901806.75,'Sales from shift 21 on 2022-08-30 08:05:01 ','2022-08-30 08:05:01','',''),('8','211',91,'','20','2',885781.65,0.00,'Sales from shift 22 on 2022-08-31 07:38:21 ','2022-08-31 07:38:21','',''),('8','211',92,'','6.1','5',0.00,885781.65,'Sales from shift 22 on 2022-08-31 07:38:21 ','2022-08-31 07:38:21','',''),('8','211',93,'','24','3',0.00,6240000.00,'Purchase Id 4 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-31 13:33:10','',''),('8','211',94,'','supplier','1',6240000.00,0.00,'Purchase Id 4 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-08-31 13:33:10','',''),('8','211',95,'','2','6',901780.00,0.00,'Payment Id 21 for invoice:21, receipt: 21 by Lausu Energy Resources','2022-08-31 15:19:07','',''),('8','211',96,'','supplier','1',0.00,901780.00,'Payment Id 21 for invoice:21, receipt: 21 by Lausu Energy Resources','2022-08-31 15:19:07','',''),('8','211',97,'','20','2',700695.45,0.00,'Sales from shift 23 on 2022-09-01 10:13:50 ','2022-09-01 10:13:50','',''),('8','211',98,'','6.1','5',0.00,700695.45,'Sales from shift 23 on 2022-09-01 10:13:50 ','2022-09-01 10:13:50','',''),('8','211',99,'','20','2',617908.20,0.00,'Sales from shift 24 on 2022-09-02 09:15:25 ','2022-09-02 09:15:25','',''),('8','211',100,'','6.1','5',0.00,617908.20,'Sales from shift 24 on 2022-09-02 09:15:25 ','2022-09-02 09:15:25','',''),('8','211',101,'','2','6',885780.00,0.00,'Payment Id 22 for invoice:22, receipt: 22 by Lausu Energy Resources','2022-09-02 15:49:31','',''),('8','211',102,'','supplier','1',0.00,885780.00,'Payment Id 22 for invoice:22, receipt: 22 by Lausu Energy Resources','2022-09-02 15:49:31','',''),('8','211',103,'','2','6',617910.00,0.00,'Payment Id 24 for invoice:24, receipt: 24 by Lausu Energy Resources','2022-09-02 15:49:46','',''),('8','211',104,'','supplier','1',0.00,617910.00,'Payment Id 24 for invoice:24, receipt: 24 by Lausu Energy Resources','2022-09-02 15:49:46','',''),('8','211',105,'','20','2',749090.55,0.00,'Sales from shift 25 on 2022-09-03 07:49:04 ','2022-09-03 07:49:04','',''),('8','211',106,'','6.1','5',0.00,749090.55,'Sales from shift 25 on 2022-09-03 07:49:04 ','2022-09-03 07:49:04','',''),('8','211',107,'','20','2',889902.00,0.00,'Sales from shift 26 on 2022-09-04 10:16:34 ','2022-09-04 10:16:34','',''),('8','211',108,'','6.1','5',0.00,889902.00,'Sales from shift 26 on 2022-09-04 10:16:34 ','2022-09-04 10:16:34','',''),('8','211',109,'','20','2',1770083.25,0.00,'Sales from shift 27 on 2022-09-05 09:08:37 ','2022-09-05 09:08:37','',''),('8','211',110,'','6.1','5',0.00,1770083.25,'Sales from shift 27 on 2022-09-05 09:08:37 ','2022-09-05 09:08:37','',''),('8','211',111,'','2','6',1770080.00,0.00,'Payment Id 27 for invoice:27, receipt: 27 by Lausu Energy Resources','2022-09-05 18:17:16','',''),('8','211',112,'','supplier','1',0.00,1770080.00,'Payment Id 27 for invoice:27, receipt: 27 by Lausu Energy Resources','2022-09-05 18:17:16','',''),('8','211',113,'','2','6',889900.00,0.00,'Payment Id 26 for invoice:26, receipt: 26 by Lausu Energy Resources','2022-09-05 18:17:32','',''),('8','211',114,'','supplier','1',0.00,889900.00,'Payment Id 26 for invoice:26, receipt: 26 by Lausu Energy Resources','2022-09-05 18:17:32','',''),('8','211',115,'','2','6',749090.00,0.00,'Payment Id 25 for invoice:25, receipt: 25 by Lausu Energy Resources','2022-09-05 18:17:51','',''),('8','211',116,'','supplier','1',0.00,749090.00,'Payment Id 25 for invoice:25, receipt: 25 by Lausu Energy Resources','2022-09-05 18:17:51','',''),('8','211',117,'','20','2',768444.30,0.00,'Sales from shift 28 on 2022-09-06 08:44:32 ','2022-09-06 08:44:32','',''),('8','211',118,'','6.1','5',0.00,768444.30,'Sales from shift 28 on 2022-09-06 08:44:32 ','2022-09-06 08:44:32','',''),('8','211',119,'','2','6',768445.00,0.00,'Payment Id 28 for invoice:28, receipt: 28 by Lausu Energy Resources','2022-09-06 16:21:32','',''),('8','211',120,'','supplier','1',0.00,768445.00,'Payment Id 28 for invoice:28, receipt: 28 by Lausu Energy Resources','2022-09-06 16:21:32','',''),('8','211',121,'','20','2',756258.90,0.00,'Sales from shift 29 on 2022-09-07 08:38:06 ','2022-09-07 08:38:06','',''),('8','211',122,'','6.1','5',0.00,756258.90,'Sales from shift 29 on 2022-09-07 08:38:06 ','2022-09-07 08:38:06','',''),('8','211',123,'','2','6',756260.00,0.00,'Payment Id 29 for invoice:29, receipt: 29 by Lausu Energy Resources','2022-09-07 17:33:16','',''),('8','211',124,'','supplier','1',0.00,756260.00,'Payment Id 29 for invoice:29, receipt: 29 by Lausu Energy Resources','2022-09-07 17:33:16','',''),('8','211',125,'','20','2',710704.50,0.00,'Sales from shift 30 on 2022-09-08 09:41:43 ','2022-09-08 09:41:43','',''),('8','211',126,'','6.1','5',0.00,710704.50,'Sales from shift 30 on 2022-09-08 09:41:43 ','2022-09-08 09:41:43','',''),('8','211',127,'','2','6',710705.00,0.00,'Payment Id 30 for invoice:30, receipt: 30 by Lausu Energy Resources','2022-09-08 14:11:27','',''),('8','211',128,'','supplier','1',0.00,710705.00,'Payment Id 30 for invoice:30, receipt: 30 by Lausu Energy Resources','2022-09-08 14:11:27','',''),('8','211',129,'','20','2',885943.40,0.00,'Sales from shift 31 on 2022-09-09 08:55:37 ','2022-09-09 08:55:37','',''),('8','211',130,'','6.1','5',0.00,885943.40,'Sales from shift 31 on 2022-09-09 08:55:37 ','2022-09-09 08:55:37','',''),('8','211',131,'','2','6',700695.00,0.00,'Payment Id 23 for invoice:23, receipt: 23 by Lausu Energy Resources','2022-09-09 17:32:40','',''),('8','211',132,'','supplier','1',0.00,700695.00,'Payment Id 23 for invoice:23, receipt: 23 by Lausu Energy Resources','2022-09-09 17:32:40','',''),('8','211',133,'','20','2',918408.70,0.00,'Sales from shift 32 on 2022-09-10 11:01:38 ','2022-09-10 11:01:38','',''),('8','211',134,'','6.1','5',0.00,918408.70,'Sales from shift 32 on 2022-09-10 11:01:38 ','2022-09-10 11:01:38','',''),('8','211',135,'','24','3',0.00,9500000.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-10 12:55:11','',''),('8','211',136,'','supplier','1',9500000.00,0.00,'Purchase Id 5 for 50,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-10 12:55:11','',''),('8','211',137,'','2','6',885945.00,0.00,'Payment Id 31 for invoice:31, receipt: 31 by Lausu Energy Resources','2022-09-10 23:50:51','',''),('8','211',138,'','supplier','1',0.00,885945.00,'Payment Id 31 for invoice:31, receipt: 31 by Lausu Energy Resources','2022-09-10 23:50:51','',''),('8','211',139,'','20','2',953731.60,0.00,'Sales from shift 33 on 2022-09-11 09:09:30 ','2022-09-11 09:09:30','',''),('8','211',140,'','6.1','5',0.00,953731.60,'Sales from shift 33 on 2022-09-11 09:09:30 ','2022-09-11 09:09:30','',''),('8','211',141,'','20','2',1965071.20,0.00,'Sales from shift 34 on 2022-09-12 09:30:22 ','2022-09-12 09:30:22','',''),('8','211',142,'','6.1','5',0.00,1965071.20,'Sales from shift 34 on 2022-09-12 09:30:22 ','2022-09-12 09:30:22','',''),('8','211',143,'','2','6',918410.00,0.00,'Payment Id 32 for invoice:32, receipt: 32 by Lausu Energy Resources','2022-09-12 11:36:43','',''),('8','211',144,'','supplier','1',0.00,918410.00,'Payment Id 32 for invoice:32, receipt: 32 by Lausu Energy Resources','2022-09-12 11:36:43','',''),('8','211',145,'','2','6',953730.00,0.00,'Payment Id 33 for invoice:33, receipt: 33 by Lausu Energy Resources','2022-09-12 11:37:01','',''),('8','211',146,'','supplier','1',0.00,953730.00,'Payment Id 33 for invoice:33, receipt: 33 by Lausu Energy Resources','2022-09-12 11:37:01','',''),('8','211',147,'','2','6',1965070.00,0.00,'Payment Id 34 for invoice:34, receipt: 34 by Lausu Energy Resources','2022-09-12 11:37:21','',''),('8','211',148,'','supplier','1',0.00,1965070.00,'Payment Id 34 for invoice:34, receipt: 34 by Lausu Energy Resources','2022-09-12 11:37:21','',''),('8','211',149,'','20','2',826655.80,0.00,'Sales from shift 35 on 2022-09-13 09:11:22 ','2022-09-13 09:11:22','',''),('8','211',150,'','6.1','5',0.00,826655.80,'Sales from shift 35 on 2022-09-13 09:11:22 ','2022-09-13 09:11:22','',''),('8','211',151,'','2','6',826655.00,0.00,'Payment Id 35 for invoice:35, receipt: 35 by Lausu Energy Resources','2022-09-13 16:17:42','',''),('8','211',152,'','supplier','1',0.00,826655.00,'Payment Id 35 for invoice:35, receipt: 35 by Lausu Energy Resources','2022-09-13 16:17:42','',''),('8','211',153,'','20','2',955392.20,0.00,'Sales from shift 36 on 2022-09-14 09:22:32 ','2022-09-14 09:22:32','',''),('8','211',154,'','6.1','5',0.00,955392.20,'Sales from shift 36 on 2022-09-14 09:22:32 ','2022-09-14 09:22:32','',''),('8','211',155,'','20','2',677038.40,0.00,'Sales from shift 37 on 2022-09-15 08:33:35 ','2022-09-15 08:33:35','',''),('8','211',156,'','6.1','5',0.00,677038.40,'Sales from shift 37 on 2022-09-15 08:33:35 ','2022-09-15 08:33:35','',''),('8','211',157,'','20','2',808953.50,0.00,'Sales from shift 38 on 2022-09-16 08:00:19 ','2022-09-16 08:00:19','',''),('8','211',158,'','6.1','5',0.00,808953.50,'Sales from shift 38 on 2022-09-16 08:00:19 ','2022-09-16 08:00:19','',''),('8','211',159,'','20','2',703072.20,0.00,'Sales from shift 39 on 2022-09-17 08:41:17 ','2022-09-17 08:41:17','',''),('8','211',160,'','6.1','5',0.00,703072.20,'Sales from shift 39 on 2022-09-17 08:41:17 ','2022-09-17 08:41:17','',''),('8','211',161,'','24','3',0.00,6270000.00,'Purchase Id 6 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-17 20:05:40','',''),('8','211',162,'','supplier','1',6270000.00,0.00,'Purchase Id 6 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-17 20:05:40','',''),('8','211',163,'','20','2',712969.30,0.00,'Sales from shift 40 on 2022-09-18 09:31:36 ','2022-09-18 09:31:36','',''),('8','211',164,'','6.1','5',0.00,712969.30,'Sales from shift 40 on 2022-09-18 09:31:36 ','2022-09-18 09:31:36','',''),('8','211',165,'','20','2',1622275.10,0.00,'Sales from shift 41 on 2022-09-20 09:46:36 ','2022-09-20 09:46:36','',''),('8','211',166,'','6.1','5',0.00,1622275.10,'Sales from shift 41 on 2022-09-20 09:46:36 ','2022-09-20 09:46:36','',''),('8','211',167,'','20','2',616671.60,0.00,'Sales from shift 42 on 2022-09-20 09:51:17 ','2022-09-20 09:51:17','',''),('8','211',168,'','6.1','5',0.00,616671.60,'Sales from shift 42 on 2022-09-20 09:51:17 ','2022-09-20 09:51:17','',''),('8','211',169,'','2','6',955390.00,0.00,'Payment Id 36 for invoice:36, receipt: 36 by Lausu Energy Resources','2022-09-20 13:28:31','',''),('8','211',170,'','supplier','1',0.00,955390.00,'Payment Id 36 for invoice:36, receipt: 36 by Lausu Energy Resources','2022-09-20 13:28:31','',''),('8','211',171,'','2','6',677040.00,0.00,'Payment Id 37 for invoice:37, receipt: 37 by Lausu Energy Resources','2022-09-20 13:30:33','',''),('8','211',172,'','supplier','1',0.00,677040.00,'Payment Id 37 for invoice:37, receipt: 37 by Lausu Energy Resources','2022-09-20 13:30:33','',''),('8','211',173,'','2','6',808955.00,0.00,'Payment Id 38 for invoice:38, receipt: 38 by Lausu Energy Resources','2022-09-20 13:30:48','',''),('8','211',174,'','supplier','1',0.00,808955.00,'Payment Id 38 for invoice:38, receipt: 38 by Lausu Energy Resources','2022-09-20 13:30:48','',''),('8','211',175,'','2','6',703070.00,0.00,'Payment Id 39 for invoice:39, receipt: 39 by Lausu Energy Resources','2022-09-20 13:31:15','',''),('8','211',176,'','supplier','1',0.00,703070.00,'Payment Id 39 for invoice:39, receipt: 39 by Lausu Energy Resources','2022-09-20 13:31:15','',''),('8','211',177,'','2','6',712970.00,0.00,'Payment Id 40 for invoice:40, receipt: 40 by Lausu Energy Resources','2022-09-20 13:31:35','',''),('8','211',178,'','supplier','1',0.00,712970.00,'Payment Id 40 for invoice:40, receipt: 40 by Lausu Energy Resources','2022-09-20 13:31:35','',''),('8','211',179,'','2','6',1622295.00,0.00,'Payment Id 41 for invoice:41, receipt: 41 by Lausu Energy Resources','2022-09-20 13:32:05','',''),('8','211',180,'','supplier','1',0.00,1622295.00,'Payment Id 41 for invoice:41, receipt: 41 by Lausu Energy Resources','2022-09-20 13:32:05','',''),('8','211',181,'','20','2',704088.70,0.00,'Sales from shift 43 on 2022-09-21 09:23:19 ','2022-09-21 09:23:19','',''),('8','211',182,'','6.1','5',0.00,704088.70,'Sales from shift 43 on 2022-09-21 09:23:19 ','2022-09-21 09:23:19','',''),('8','211',183,'','2','6',616760.00,0.00,'Payment Id 43 for invoice:42, receipt: 42 by Lausu Energy Resources','2022-09-21 13:49:50','',''),('8','211',184,'','supplier','1',0.00,616760.00,'Payment Id 43 for invoice:42, receipt: 42 by Lausu Energy Resources','2022-09-21 13:49:50','',''),('8','211',185,'','2','6',704090.00,0.00,'Payment Id 44 for invoice:43, receipt: 43 by Lausu Energy Resources','2022-09-21 14:00:15','',''),('8','211',186,'','supplier','1',0.00,704090.00,'Payment Id 44 for invoice:43, receipt: 43 by Lausu Energy Resources','2022-09-21 14:00:15','',''),('8','211',187,'','20','2',849016.90,0.00,'Sales from shift 44 on 2022-09-22 08:34:50 ','2022-09-22 08:34:50','',''),('8','211',188,'','6.1','5',0.00,849016.90,'Sales from shift 44 on 2022-09-22 08:34:50 ','2022-09-22 08:34:50','',''),('8','211',189,'','20','2',576745.00,0.00,'Sales from shift 45 on 2022-09-23 08:20:10 ','2022-09-23 08:20:10','',''),('8','211',190,'','6.1','5',0.00,576745.00,'Sales from shift 45 on 2022-09-23 08:20:10 ','2022-09-23 08:20:10','',''),('8','211',191,'','24','3',0.00,3230000.00,'Purchase Id 7 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-23 13:54:22','',''),('8','211',192,'','supplier','1',3230000.00,0.00,'Purchase Id 7 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-23 13:54:22','',''),('8','211',193,'','20','2',676781.90,0.00,'Sales from shift 46 on 2022-09-24 07:45:14 ','2022-09-24 07:45:14','',''),('8','211',194,'','6.1','5',0.00,676781.90,'Sales from shift 46 on 2022-09-24 07:45:14 ','2022-09-24 07:45:14','',''),('8','211',195,'','20','2',684801.80,0.00,'Sales from shift 47 on 2022-09-25 10:10:43 ','2022-09-25 10:10:43','',''),('8','211',196,'','6.1','5',0.00,684801.80,'Sales from shift 47 on 2022-09-25 10:10:43 ','2022-09-25 10:10:43','',''),('8','211',197,'','20','2',1933080.90,0.00,'Sales from shift 48 on 2022-09-26 09:09:35 ','2022-09-26 09:09:35','',''),('8','211',198,'','6.1','5',0.00,1933080.90,'Sales from shift 48 on 2022-09-26 09:09:35 ','2022-09-26 09:09:35','',''),('8','211',199,'','2','6',849015.00,0.00,'Payment Id 45 for invoice:44, receipt: 44 by Lausu Energy Resources','2022-09-26 16:36:54','',''),('8','211',200,'','supplier','1',0.00,849015.00,'Payment Id 45 for invoice:44, receipt: 44 by Lausu Energy Resources','2022-09-26 16:36:54','',''),('8','211',201,'','2','6',576745.00,0.00,'Payment Id 46 for invoice:45, receipt: 45 by Lausu Energy Resources','2022-09-26 16:37:22','',''),('8','211',202,'','supplier','1',0.00,576745.00,'Payment Id 46 for invoice:45, receipt: 45 by Lausu Energy Resources','2022-09-26 16:37:22','',''),('8','211',203,'','2','6',676780.00,0.00,'Payment Id 47 for invoice:46, receipt: 46 by Lausu Energy Resources','2022-09-26 16:37:39','',''),('8','211',204,'','supplier','1',0.00,676780.00,'Payment Id 47 for invoice:46, receipt: 46 by Lausu Energy Resources','2022-09-26 16:37:39','',''),('8','211',205,'','2','6',684800.00,0.00,'Payment Id 48 for invoice:47, receipt: 47 by Lausu Energy Resources','2022-09-26 16:37:52','',''),('8','211',206,'','supplier','1',0.00,684800.00,'Payment Id 48 for invoice:47, receipt: 47 by Lausu Energy Resources','2022-09-26 16:37:52','',''),('8','211',207,'','2','6',1933080.00,0.00,'Payment Id 49 for invoice:48, receipt: 48 by Lausu Energy Resources','2022-09-26 16:38:11','',''),('8','211',208,'','supplier','1',0.00,1933080.00,'Payment Id 49 for invoice:48, receipt: 48 by Lausu Energy Resources','2022-09-26 16:38:11','',''),('8','211',209,'','20','2',863489.20,0.00,'Sales from shift 49 on 2022-09-27 08:13:07 ','2022-09-27 08:13:07','',''),('8','211',210,'','6.1','5',0.00,863489.20,'Sales from shift 49 on 2022-09-27 08:13:07 ','2022-09-27 08:13:07','',''),('8','211',211,'','2','6',863490.00,0.00,'Payment Id 50 for invoice:49, receipt: 49 by Lausu Energy Resources','2022-09-27 16:33:42','',''),('8','211',212,'','supplier','1',0.00,863490.00,'Payment Id 50 for invoice:49, receipt: 49 by Lausu Energy Resources','2022-09-27 16:33:42','',''),('8','211',213,'','20','2',838369.30,0.00,'Sales from shift 50 on 2022-09-28 08:27:00 ','2022-09-28 08:27:00','',''),('8','211',214,'','6.1','5',0.00,838369.30,'Sales from shift 50 on 2022-09-28 08:27:00 ','2022-09-28 08:27:00','',''),('8','211',215,'','24','3',0.00,6080000.00,'Purchase Id 8 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-28 13:11:49','',''),('8','211',216,'','supplier','1',6080000.00,0.00,'Purchase Id 8 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-09-28 13:11:49','',''),('8','211',217,'','20','2',1070422.00,0.00,'Sales from shift 51 on 2022-09-29 07:19:40 ','2022-09-29 07:19:40','',''),('8','211',218,'','6.1','5',0.00,1070422.00,'Sales from shift 51 on 2022-09-29 07:19:40 ','2022-09-29 07:19:40','',''),('8','211',219,'','2','6',838370.00,0.00,'Payment Id 51 for invoice:50, receipt: 50 by Lausu Energy Resources','2022-09-29 13:51:57','',''),('8','211',220,'','supplier','1',0.00,838370.00,'Payment Id 51 for invoice:50, receipt: 50 by Lausu Energy Resources','2022-09-29 13:51:57','',''),('8','211',221,'','20','2',931163.40,0.00,'Sales from shift 52 on 2022-09-30 07:44:30 ','2022-09-30 07:44:30','',''),('8','211',222,'','6.1','5',0.00,931163.40,'Sales from shift 52 on 2022-09-30 07:44:30 ','2022-09-30 07:44:30','',''),('8','211',223,'','20','2',884700.80,0.00,'Sales from shift 53 on 2022-10-01 07:03:43 ','2022-10-01 07:03:43','',''),('8','211',224,'','6.1','5',0.00,884700.80,'Sales from shift 53 on 2022-10-01 07:03:43 ','2022-10-01 07:03:43','',''),('8','211',225,'','20','2',780362.30,0.00,'Sales from shift 54 on 2022-10-02 08:55:25 ','2022-10-02 08:55:25','',''),('8','211',226,'','6.1','5',0.00,780362.30,'Sales from shift 54 on 2022-10-02 08:55:25 ','2022-10-02 08:55:25','',''),('8','211',227,'','2','6',1070420.00,0.00,'Payment Id 52 for invoice:51, receipt: 51 by Lausu Energy Resources','2022-10-03 02:02:17','',''),('8','211',228,'','supplier','1',0.00,1070420.00,'Payment Id 52 for invoice:51, receipt: 51 by Lausu Energy Resources','2022-10-03 02:02:17','',''),('8','211',229,'','20','2',1804671.30,0.00,'Sales from shift 55 on 2022-10-03 09:14:36 ','2022-10-03 09:14:36','',''),('8','211',230,'','6.1','5',0.00,1804671.30,'Sales from shift 55 on 2022-10-03 09:14:36 ','2022-10-03 09:14:36','',''),('8','211',231,'','20','2',491925.20,0.00,'Sales from shift 56 on 2022-10-03 13:26:43 ','2022-10-03 13:26:43','',''),('8','211',232,'','6.1','5',0.00,491925.20,'Sales from shift 56 on 2022-10-03 13:26:43 ','2022-10-03 13:26:43','',''),('8','211',233,'','2','6',884700.00,0.00,'Payment Id 53 for invoice:53, receipt: 53 by Lausu Energy Resources','2022-10-03 22:52:22','',''),('8','211',234,'','supplier','1',0.00,884700.00,'Payment Id 53 for invoice:53, receipt: 53 by Lausu Energy Resources','2022-10-03 22:52:22','',''),('8','211',235,'','2','7',780365.00,0.00,'Payment Id 54 for invoice:54, receipt: 54 by Lausu Energy Resources','2022-10-03 22:52:49','',''),('8','211',236,'','supplier','1',0.00,780365.00,'Payment Id 54 for invoice:54, receipt: 54 by Lausu Energy Resources','2022-10-03 22:52:49','',''),('8','211',237,'','2','6',931165.00,0.00,'Payment Id 55 for invoice:52, receipt: 52 by Lausu Energy Resources','2022-10-03 22:53:32','',''),('8','211',238,'','supplier','1',0.00,931165.00,'Payment Id 55 for invoice:52, receipt: 52 by Lausu Energy Resources','2022-10-03 22:53:32','',''),('8','211',239,'','2','6',1804670.00,0.00,'Payment Id 56 for invoice:55, receipt: 55 by Lausu Energy Resources','2022-10-03 22:54:07','',''),('8','211',240,'','supplier','1',0.00,1804670.00,'Payment Id 56 for invoice:55, receipt: 55 by Lausu Energy Resources','2022-10-03 22:54:07','',''),('8','211',241,'','20','2',346297.80,0.00,'Sales from shift 57 on 2022-10-04 08:50:50 ','2022-10-04 08:50:50','',''),('8','211',242,'','6.1','5',0.00,346297.80,'Sales from shift 57 on 2022-10-04 08:50:50 ','2022-10-04 08:50:50','',''),('8','211',243,'','20','2',876633.40,0.00,'Sales from shift 58 on 2022-10-05 10:10:15 ','2022-10-05 10:10:15','',''),('8','211',244,'','6.1','5',0.00,876633.40,'Sales from shift 58 on 2022-10-05 10:10:15 ','2022-10-05 10:10:15','',''),('8','211',245,'','20','2',1179624.50,0.00,'Sales from shift 59 on 2022-10-06 08:34:52 ','2022-10-06 08:34:52','',''),('8','211',246,'','6.1','5',0.00,1179624.50,'Sales from shift 59 on 2022-10-06 08:34:52 ','2022-10-06 08:34:52','',''),('8','211',247,'','24','3',0.00,6270000.00,'Purchase Id 9 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-07 12:15:08','',''),('8','211',248,'','supplier','1',6270000.00,0.00,'Purchase Id 9 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-07 12:15:08','',''),('8','211',249,'','2','6',876735.00,0.00,'Payment Id 59 for invoice:58, receipt: 58 by Lausu Energy Resources','2022-10-07 15:02:50','',''),('8','211',250,'','supplier','1',0.00,876735.00,'Payment Id 59 for invoice:58, receipt: 58 by Lausu Energy Resources','2022-10-07 15:02:50','',''),('8','211',251,'','20','2',2005858.50,0.00,'Sales from shift 60 on 2022-10-08 10:34:39 ','2022-10-08 10:34:39','',''),('8','211',252,'','6.1','5',0.00,2005858.50,'Sales from shift 60 on 2022-10-08 10:34:39 ','2022-10-08 10:34:39','',''),('8','211',253,'','2','6',491925.00,0.00,'Payment Id 57 for invoice:56, receipt: 56 by Lausu Energy Resources','2022-10-08 23:06:50','',''),('8','211',254,'','supplier','1',0.00,491925.00,'Payment Id 57 for invoice:56, receipt: 56 by Lausu Energy Resources','2022-10-08 23:06:50','',''),('8','211',255,'','2','6',346300.00,0.00,'Payment Id 58 for invoice:01, receipt: 01 by Lausu Energy Resources','2022-10-09 10:39:43','',''),('8','211',256,'','supplier','1',0.00,346300.00,'Payment Id 58 for invoice:01, receipt: 01 by Lausu Energy Resources','2022-10-09 10:39:43','',''),('8','211',257,'','20','2',3535803.25,0.00,'Sales from shift 61 on 2022-10-09 10:43:39 ','2022-10-09 10:43:39','',''),('8','211',258,'','6.1','5',0.00,3535803.25,'Sales from shift 61 on 2022-10-09 10:43:39 ','2022-10-09 10:43:39','',''),('8','211',259,'','20','2',1205854.51,0.00,'Sales from shift 62 on 2022-10-10 08:41:14 ','2022-10-10 08:41:14','',''),('8','211',260,'','6.1','5',0.00,1205854.51,'Sales from shift 62 on 2022-10-10 08:41:14 ','2022-10-10 08:41:14','',''),('8','211',261,'','24','3',0.00,4313750.00,'Purchase Id 10 for 21,250.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-10 14:29:03','',''),('8','211',262,'','supplier','1',4313750.00,0.00,'Purchase Id 10 for 21,250.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-10 14:29:03','',''),('8','211',263,'','2','6',2005860.00,0.00,'Payment Id 61 for invoice:60, receipt: 60 by Lausu Energy Resources','2022-10-10 16:28:04','',''),('8','211',264,'','supplier','1',0.00,2005860.00,'Payment Id 61 for invoice:60, receipt: 60 by Lausu Energy Resources','2022-10-10 16:28:04','',''),('8','211',265,'','20','2',2757781.39,0.00,'Sales from shift 63 on 2022-10-11 10:52:36 ','2022-10-11 10:52:36','',''),('8','211',266,'','6.1','5',0.00,2757781.39,'Sales from shift 63 on 2022-10-11 10:52:36 ','2022-10-11 10:52:36','',''),('8','211',267,'','20','2',1600545.84,0.00,'Sales from shift 64 on 2022-10-12 13:42:38 ','2022-10-12 13:42:38','',''),('8','211',268,'','6.1','5',0.00,1600545.84,'Sales from shift 64 on 2022-10-12 13:42:38 ','2022-10-12 13:42:38','',''),('8','211',269,'','2','6',2757780.00,0.00,'Payment Id 64 for invoice:63, receipt: 63 by Lausu Energy Resources','2022-10-12 16:37:10','',''),('8','211',270,'','supplier','1',0.00,2757780.00,'Payment Id 64 for invoice:63, receipt: 63 by Lausu Energy Resources','2022-10-12 16:37:10','',''),('8','211',271,'','2','6',3535805.00,0.00,'Payment Id 62 for invoice:61, receipt: 61 by Lausu Energy Resources','2022-10-12 16:38:06','',''),('8','211',272,'','supplier','1',0.00,3535805.00,'Payment Id 62 for invoice:61, receipt: 61 by Lausu Energy Resources','2022-10-12 16:38:06','',''),('8','211',273,'','2','6',1179625.00,0.00,'Payment Id 60 for invoice:59, receipt: 59 by Lausu Energy Resources','2022-10-12 16:47:14','',''),('8','211',274,'','supplier','1',0.00,1179625.00,'Payment Id 60 for invoice:59, receipt: 59 by Lausu Energy Resources','2022-10-12 16:47:14','',''),('8','211',275,'','24','3',0.00,6789600.00,'Purchase Id 11 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-16 09:37:54','',''),('8','211',276,'','supplier','1',6789600.00,0.00,'Purchase Id 11 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-16 09:37:54','',''),('8','211',277,'','supplier','1',0.00,6789600.00,'Purchase Id 11 for 32,800.00 litters of Petrol - PMS returned to Lausu Energy Resources','2022-10-16 10:58:52','',''),('8','211',278,'','24','3',0.00,7380000.00,'Purchase Id 12 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-16 11:14:56','',''),('8','211',279,'','supplier','1',7380000.00,0.00,'Purchase Id 12 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-16 11:14:56','',''),('8','211',280,'','20','2',1265314.50,0.00,'Sales from shift 65 on 2022-10-16 13:07:43 ','2022-10-16 13:07:43','',''),('8','211',281,'','6.1','5',0.00,1265314.50,'Sales from shift 65 on 2022-10-16 13:07:43 ','2022-10-16 13:07:43','',''),('8','211',282,'','20','2',5290067.25,0.00,'Sales from shift 66 on 2022-10-17 10:40:38 ','2022-10-17 10:40:38','',''),('8','211',283,'','6.1','5',0.00,5290067.25,'Sales from shift 66 on 2022-10-17 10:40:38 ','2022-10-17 10:40:38','',''),('8','211',284,'','2','6',1205855.00,0.00,'Payment Id 63 for invoice:62, receipt: 62 by Lausu Energy Resources','2022-10-17 12:16:53','',''),('8','211',285,'','supplier','1',0.00,1205855.00,'Payment Id 63 for invoice:62, receipt: 62 by Lausu Energy Resources','2022-10-17 12:16:53','',''),('8','211',286,'','2','6',1600545.00,0.00,'Payment Id 65 for invoice:64, receipt: 64 by Lausu Energy Resources','2022-10-17 12:17:19','',''),('8','211',287,'','supplier','1',0.00,1600545.00,'Payment Id 65 for invoice:64, receipt: 64 by Lausu Energy Resources','2022-10-17 12:17:19','',''),('8','211',288,'','2','6',1265315.00,0.00,'Payment Id 66 for invoice:65, receipt: 65 by Lausu Energy Resources','2022-10-17 12:17:39','',''),('8','211',289,'','supplier','1',0.00,1265315.00,'Payment Id 66 for invoice:65, receipt: 65 by Lausu Energy Resources','2022-10-17 12:17:39','',''),('8','211',290,'','20','2',818435.25,0.00,'Sales from shift 67 on 2022-10-18 09:43:34 ','2022-10-18 09:43:34','',''),('8','211',291,'','6.1','5',0.00,818435.25,'Sales from shift 67 on 2022-10-18 09:43:34 ','2022-10-18 09:43:34','',''),('8','211',292,'','2','6',818435.00,0.00,'Payment Id 68 for invoice:67, receipt: 67 by Lausu Energy Resources','2022-10-18 13:28:37','',''),('8','211',293,'','supplier','1',0.00,818435.00,'Payment Id 68 for invoice:67, receipt: 67 by Lausu Energy Resources','2022-10-18 13:28:37','',''),('8','211',294,'','24','3',0.00,7531750.00,'Purchase Id 13 for 32,050.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-22 08:28:01','',''),('8','211',295,'','supplier','1',7531750.00,0.00,'Purchase Id 13 for 32,050.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-22 08:28:01','',''),('8','211',296,'','20','2',2848136.55,0.00,'Sales from shift 68 on 2022-10-22 08:48:07 ','2022-10-22 08:48:07','',''),('8','211',297,'','6.1','5',0.00,2848136.55,'Sales from shift 68 on 2022-10-22 08:48:07 ','2022-10-22 08:48:07','',''),('8','211',298,'','20','2',2675896.80,0.00,'Sales from shift 69 on 2022-10-23 09:22:24 ','2022-10-23 09:22:24','',''),('8','211',299,'','6.1','5',0.00,2675896.80,'Sales from shift 69 on 2022-10-23 09:22:24 ','2022-10-23 09:22:24','',''),('8','211',300,'','20','2',2095053.60,0.00,'Sales from shift 70 on 2022-10-24 08:49:41 ','2022-10-24 08:49:41','',''),('8','211',301,'','6.1','5',0.00,2095053.60,'Sales from shift 70 on 2022-10-24 08:49:41 ','2022-10-24 08:49:41','',''),('8','211',302,'','2','6',5000000.00,0.00,'Payment Id 67 for invoice:66, receipt: 66 by Lausu Energy Resources','2022-10-24 16:21:16','',''),('8','211',303,'','supplier','1',0.00,5000000.00,'Payment Id 67 for invoice:66, receipt: 66 by Lausu Energy Resources','2022-10-24 16:21:16','',''),('8','211',304,'','2','6',2848136.00,0.00,'Payment Id 69 for invoice:68, receipt: 68 by Lausu Energy Resources','2022-10-24 16:21:54','',''),('8','211',305,'','supplier','1',0.00,2848136.00,'Payment Id 69 for invoice:68, receipt: 68 by Lausu Energy Resources','2022-10-24 16:21:54','',''),('8','211',306,'','24','3',0.00,7284000.00,'Purchase Id 14 for 30,350.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-26 09:12:00','',''),('8','211',307,'','supplier','1',7284000.00,0.00,'Purchase Id 14 for 30,350.00 litters of Petrol - PMS from Lausu Energy Resources','2022-10-26 09:12:00','',''),('8','211',308,'','20','2',1736107.20,0.00,'Sales from shift 71 on 2022-10-26 09:44:26 ','2022-10-26 09:44:26','',''),('8','211',309,'','6.1','5',0.00,1736107.20,'Sales from shift 71 on 2022-10-26 09:44:26 ','2022-10-26 09:44:26','',''),('8','211',310,'','2','6',2095055.00,0.00,'Payment Id 71 for invoice:70, receipt: 70 by Lausu Energy Resources','2022-10-26 13:39:39','',''),('8','211',311,'','supplier','1',0.00,2095055.00,'Payment Id 71 for invoice:70, receipt: 70 by Lausu Energy Resources','2022-10-26 13:39:39','',''),('8','211',312,'','2','6',2675895.00,0.00,'Payment Id 70 for invoice:69, receipt: 69 by Lausu Energy Resources','2022-10-26 13:40:12','',''),('8','211',313,'','supplier','1',0.00,2675895.00,'Payment Id 70 for invoice:69, receipt: 69 by Lausu Energy Resources','2022-10-26 13:40:12','',''),('8','211',314,'','20','2',2623580.00,0.00,'Sales from shift 72 on 2022-10-27 09:12:16 ','2022-10-27 09:12:16','',''),('8','211',315,'','6.1','5',0.00,2623580.00,'Sales from shift 72 on 2022-10-27 09:12:16 ','2022-10-27 09:12:16','',''),('8','211',316,'','2','6',1736110.00,0.00,'Payment Id 72 for invoice:71, receipt: 71 by Lausu Energy Resources','2022-10-27 21:28:15','',''),('8','211',317,'','supplier','1',0.00,1736110.00,'Payment Id 72 for invoice:71, receipt: 71 by Lausu Energy Resources','2022-10-27 21:28:15','',''),('8','211',318,'','2','6',2623580.00,0.00,'Payment Id 73 for invoice:72, receipt: 72 by Lausu Energy Resources','2022-10-27 21:29:24','',''),('8','211',319,'','supplier','1',0.00,2623580.00,'Payment Id 73 for invoice:72, receipt: 72 by Lausu Energy Resources','2022-10-27 21:29:24','',''),('8','211',320,'','20','2',2683807.50,0.00,'Sales from shift 73 on 2022-10-28 09:01:45 ','2022-10-28 09:01:45','',''),('8','211',321,'','6.1','5',0.00,2683807.50,'Sales from shift 73 on 2022-10-28 09:01:45 ','2022-10-28 09:01:45','',''),('8','211',322,'','20','2',464010.00,0.00,'Sales from shift 74 on 2022-10-29 09:12:00 ','2022-10-29 09:12:00','',''),('8','211',323,'','6.1','5',0.00,464010.00,'Sales from shift 74 on 2022-10-29 09:12:00 ','2022-10-29 09:12:00','',''),('8','211',324,'','2','6',2683810.00,0.00,'Payment Id 74 for invoice:73, receipt: 73 by Lausu Energy Resources','2022-10-29 17:56:43','',''),('8','211',325,'','supplier','1',0.00,2683810.00,'Payment Id 74 for invoice:73, receipt: 73 by Lausu Energy Resources','2022-10-29 17:56:43','',''),('8','211',326,'','2','6',464010.00,0.00,'Payment Id 75 for invoice:74, receipt: 74 by Lausu Energy Resources','2022-11-03 12:56:38','',''),('8','211',327,'','supplier','1',0.00,464010.00,'Payment Id 75 for invoice:74, receipt: 74 by Lausu Energy Resources','2022-11-03 12:56:38','',''),('8','211',328,'','24','3',0.00,8415000.00,'Purchase Id 15 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-05 23:39:14','',''),('8','211',329,'','supplier','1',8415000.00,0.00,'Purchase Id 15 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-05 23:39:14','',''),('8','211',330,'','20','2',1458299.10,0.00,'Sales from shift 75 on 2022-11-06 11:06:07 ','2022-11-06 11:06:07','',''),('8','211',331,'','6.1','5',0.00,1458299.10,'Sales from shift 75 on 2022-11-06 11:06:07 ','2022-11-06 11:06:07','',''),('8','211',332,'','20','2',4861437.30,0.00,'Sales from shift 76 on 2022-11-07 08:34:49 ','2022-11-07 08:34:49','',''),('8','211',333,'','6.1','5',0.00,4861437.30,'Sales from shift 76 on 2022-11-07 08:34:49 ','2022-11-07 08:34:49','',''),('8','211',334,'','20','2',1840350.30,0.00,'Sales from shift 77 on 2022-11-08 08:52:14 ','2022-11-08 08:52:14','',''),('8','211',335,'','6.1','5',0.00,1840350.30,'Sales from shift 77 on 2022-11-08 08:52:14 ','2022-11-08 08:52:14','',''),('8','211',336,'','24','3',0.00,8440500.00,'Purchase Id 16 for 33,100.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-08 13:21:31','',''),('8','211',337,'','supplier','1',8440500.00,0.00,'Purchase Id 16 for 33,100.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-08 13:21:31','',''),('8','211',338,'','20','2',1811986.65,0.00,'Sales from shift 78 on 2022-11-09 10:34:21 ','2022-11-09 10:34:21','',''),('8','211',339,'','6.1','5',0.00,1811986.65,'Sales from shift 78 on 2022-11-09 10:34:21 ','2022-11-09 10:34:21','',''),('8','211',340,'','2','6',1840350.00,0.00,'Payment Id 78 for invoice:77, receipt: 77 by Lausu Energy Resources','2022-11-09 12:03:29','',''),('8','211',341,'','supplier','1',0.00,1840350.00,'Payment Id 78 for invoice:77, receipt: 77 by Lausu Energy Resources','2022-11-09 12:03:29','',''),('8','211',342,'','20','2',1946970.90,0.00,'Sales from shift 79 on 2022-11-10 08:09:06 ','2022-11-10 08:09:06','',''),('8','211',343,'','6.1','5',0.00,1946970.90,'Sales from shift 79 on 2022-11-10 08:09:06 ','2022-11-10 08:09:06','',''),('8','211',344,'','20','2',2171692.20,0.00,'Sales from shift 80 on 2022-11-11 10:59:02 ','2022-11-11 10:59:02','',''),('8','211',345,'','6.1','5',0.00,2171692.20,'Sales from shift 80 on 2022-11-11 10:59:02 ','2022-11-11 10:59:02','',''),('8','211',346,'','20','2',2132350.80,0.00,'Sales from shift 81 on 2022-11-12 09:48:07 ','2022-11-12 09:48:07','',''),('8','211',347,'','6.1','5',0.00,2132350.80,'Sales from shift 81 on 2022-11-12 09:48:07 ','2022-11-12 09:48:07','',''),('8','211',348,'','20','2',530848.80,0.00,'Sales from shift 82 on 2022-11-13 08:46:44 ','2022-11-13 08:46:44','',''),('8','211',349,'','6.1','5',0.00,530848.80,'Sales from shift 82 on 2022-11-13 08:46:44 ','2022-11-13 08:46:44','',''),('8','211',350,'','2','6',2171690.00,0.00,'Payment Id 81 for invoice:80, receipt: 80 by Lausu Energy Resources','2022-11-14 13:44:33','',''),('8','211',351,'','supplier','1',0.00,2171690.00,'Payment Id 81 for invoice:80, receipt: 80 by Lausu Energy Resources','2022-11-14 13:44:33','',''),('8','211',352,'','24','3',0.00,8415000.00,'Purchase Id 17 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-15 17:25:01','',''),('8','211',353,'','supplier','1',8415000.00,0.00,'Purchase Id 17 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-15 17:25:01','',''),('8','211',354,'','2','6',2132350.00,0.00,'Payment Id 82 for invoice:81, receipt: 81 by Lausu Energy Resources','2022-11-15 17:25:26','',''),('8','211',355,'','supplier','1',0.00,2132350.00,'Payment Id 82 for invoice:81, receipt: 81 by Lausu Energy Resources','2022-11-15 17:25:26','',''),('8','211',356,'','20','2',845704.95,0.00,'Sales from shift 83 on 2022-11-16 15:57:47 ','2022-11-16 15:57:47','',''),('8','211',357,'','6.1','5',0.00,845704.95,'Sales from shift 83 on 2022-11-16 15:57:47 ','2022-11-16 15:57:47','',''),('8','211',358,'','20','2',2133289.20,0.00,'Sales from shift 84 on 2022-11-17 08:35:37 ','2022-11-17 08:35:37','',''),('8','211',359,'','6.1','5',0.00,2133289.20,'Sales from shift 84 on 2022-11-17 08:35:37 ','2022-11-17 08:35:37','',''),('8','211',360,'','2','6',845705.00,0.00,'Payment Id 84 for invoice:83, receipt: 83 by Lausu Energy Resources','2022-11-17 13:12:11','',''),('8','211',361,'','supplier','1',0.00,845705.00,'Payment Id 84 for invoice:83, receipt: 83 by Lausu Energy Resources','2022-11-17 13:12:11','',''),('8','211',362,'','2','6',2133290.00,0.00,'Payment Id 85 for invoice:84, receipt: 84 by Lausu Energy Resources','2022-11-17 13:12:27','',''),('8','211',363,'','supplier','1',0.00,2133290.00,'Payment Id 85 for invoice:84, receipt: 84 by Lausu Energy Resources','2022-11-17 13:12:27','',''),('8','211',364,'','20','2',2185372.95,0.00,'Sales from shift 85 on 2022-11-18 09:51:33 ','2022-11-18 09:51:33','',''),('8','211',365,'','6.1','5',0.00,2185372.95,'Sales from shift 85 on 2022-11-18 09:51:33 ','2022-11-18 09:51:33','',''),('8','211',366,'','20','2',2139401.55,0.00,'Sales from shift 86 on 2022-11-19 09:44:26 ','2022-11-19 09:44:26','',''),('8','211',367,'','6.1','5',0.00,2139401.55,'Sales from shift 86 on 2022-11-19 09:44:26 ','2022-11-19 09:44:26','',''),('8','211',368,'','20','2',1096127.70,0.00,'Sales from shift 87 on 2022-11-20 07:57:18 ','2022-11-20 07:57:18','',''),('8','211',369,'','6.1','5',0.00,1096127.70,'Sales from shift 87 on 2022-11-20 07:57:18 ','2022-11-20 07:57:18','',''),('8','211',370,'','24','3',0.00,4420000.00,'Purchase Id 18 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-20 23:56:51','',''),('8','211',371,'','supplier','1',4420000.00,0.00,'Purchase Id 18 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-20 23:56:51','',''),('8','211',372,'','2','6',2185370.00,0.00,'Payment Id 86 for invoice:85, receipt: 85 by Lausu Energy Resources','2022-11-21 14:40:18','',''),('8','211',373,'','supplier','1',0.00,2185370.00,'Payment Id 86 for invoice:85, receipt: 85 by Lausu Energy Resources','2022-11-21 14:40:18','',''),('8','211',374,'','20','2',4457013.60,0.00,'Sales from shift 88 on 2022-11-21 15:13:29 ','2022-11-21 15:13:29','',''),('8','211',375,'','6.1','5',0.00,4457013.60,'Sales from shift 88 on 2022-11-21 15:13:29 ','2022-11-21 15:13:29','',''),('8','211',376,'','2','6',1096125.00,0.00,'Payment Id 88 for invoice:87, receipt: 87 by Lausu Energy Resources','2022-11-21 17:02:32','',''),('8','211',377,'','supplier','1',0.00,1096125.00,'Payment Id 88 for invoice:87, receipt: 87 by Lausu Energy Resources','2022-11-21 17:02:32','',''),('8','211',378,'','2','6',2139400.00,0.00,'Payment Id 87 for invoice:86, receipt: 86 by Lausu Energy Resources','2022-11-21 17:03:03','',''),('8','211',379,'','supplier','1',0.00,2139400.00,'Payment Id 87 for invoice:86, receipt: 86 by Lausu Energy Resources','2022-11-21 17:03:03','',''),('8','211',380,'','2','6',4457015.00,0.00,'Payment Id 89 for invoice:88, receipt: 88 by Lausu Energy Resources','2022-11-23 16:09:41','',''),('8','211',381,'','supplier','1',0.00,4457015.00,'Payment Id 89 for invoice:88, receipt: 88 by Lausu Energy Resources','2022-11-23 16:09:41','',''),('8','211',382,'','2','6',4861435.00,0.00,'Payment Id 77 for invoice:76, receipt: 76 by Lausu Energy Resources','2022-11-23 16:29:18','',''),('8','211',383,'','supplier','1',0.00,4861435.00,'Payment Id 77 for invoice:76, receipt: 76 by Lausu Energy Resources','2022-11-23 16:29:18','',''),('8','211',384,'','2','6',1946970.00,0.00,'Payment Id 80 for invoice:79, receipt: 79 by Lausu Energy Resources','2022-11-25 11:49:14','',''),('8','211',385,'','supplier','1',0.00,1946970.00,'Payment Id 80 for invoice:79, receipt: 79 by Lausu Energy Resources','2022-11-25 11:49:14','',''),('8','211',386,'','24','3',0.00,11700000.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-28 10:05:42','',''),('8','211',387,'','supplier','1',11700000.00,0.00,'Purchase Id 19 for 45,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-11-28 10:05:42','',''),('8','211',388,'','20','2',4161861.60,0.00,'Sales from shift 89 on 2022-11-28 10:51:12 ','2022-11-28 10:51:12','',''),('8','211',389,'','6.1','5',0.00,4161861.60,'Sales from shift 89 on 2022-11-28 10:51:12 ','2022-11-28 10:51:12','',''),('8','211',390,'','2','6',4161860.00,0.00,'Payment Id 90 for invoice:89, receipt: 89 by Lausu Energy Resources','2022-11-28 17:14:41','',''),('8','211',391,'','supplier','1',0.00,4161860.00,'Payment Id 90 for invoice:89, receipt: 89 by Lausu Energy Resources','2022-11-28 17:14:41','',''),('8','211',392,'','20','2',2524940.60,0.00,'Sales from shift 90 on 2022-11-29 10:49:32 ','2022-11-29 10:49:32','',''),('8','211',393,'','6.1','5',0.00,2524940.60,'Sales from shift 90 on 2022-11-29 10:49:32 ','2022-11-29 10:49:32','',''),('8','211',394,'','2','6',2524940.00,0.00,'Payment Id 91 for invoice:90, receipt: 90 by Lausu Energy Resources','2022-11-29 17:36:01','',''),('8','211',395,'','supplier','1',0.00,2524940.00,'Payment Id 91 for invoice:90, receipt: 90 by Lausu Energy Resources','2022-11-29 17:36:01','',''),('8','211',396,'','20','2',2477534.80,0.00,'Sales from shift 91 on 2022-11-30 13:08:39 ','2022-11-30 13:08:39','',''),('8','211',397,'','6.1','5',0.00,2477534.80,'Sales from shift 91 on 2022-11-30 13:08:39 ','2022-11-30 13:08:39','',''),('8','211',398,'','20','2',2514954.00,0.00,'Sales from shift 92 on 2022-12-01 09:54:31 ','2022-12-01 09:54:31','',''),('8','211',399,'','6.1','5',0.00,2514954.00,'Sales from shift 92 on 2022-12-01 09:54:31 ','2022-12-01 09:54:31','',''),('8','211',400,'','2','6',2477535.00,0.00,'Payment Id 92 for invoice:91, receipt: 91 by Lausu Energy Resources','2022-12-01 12:17:01','',''),('8','211',401,'','supplier','1',0.00,2477535.00,'Payment Id 92 for invoice:91, receipt: 91 by Lausu Energy Resources','2022-12-01 12:17:01','',''),('8','211',402,'','2','6',2514955.00,0.00,'Payment Id 93 for invoice:92, receipt: 92 by Lausu Energy Resources','2022-12-01 12:18:25','',''),('8','211',403,'','supplier','1',0.00,2514955.00,'Payment Id 93 for invoice:92, receipt: 92 by Lausu Energy Resources','2022-12-01 12:18:25','',''),('8','211',404,'','24','3',0.00,4590000.00,'Purchase Id 20 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-06 16:20:46','',''),('8','211',405,'','supplier','1',4590000.00,0.00,'Purchase Id 20 for 17,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-06 16:20:46','',''),('8','211',406,'','2','6',530850.00,0.00,'Payment Id 83 for invoice:82, receipt: 82 by Lausu Energy Resources','2022-12-06 17:33:56','',''),('8','211',407,'','supplier','1',0.00,530850.00,'Payment Id 83 for invoice:82, receipt: 82 by Lausu Energy Resources','2022-12-06 17:33:56','',''),('8','211',408,'','2','6',1458300.00,0.00,'Payment Id 76 for invoice:75, receipt: 75 by Lausu Energy Resources','2022-12-06 17:34:12','',''),('8','211',409,'','supplier','1',0.00,1458300.00,'Payment Id 76 for invoice:75, receipt: 75 by Lausu Energy Resources','2022-12-06 17:34:12','',''),('8','211',410,'','20','2',3124664.10,0.00,'Sales from shift 93 on 2022-12-08 07:19:15 ','2022-12-08 07:19:15','',''),('8','211',411,'','6.1','5',0.00,3124664.10,'Sales from shift 93 on 2022-12-08 07:19:15 ','2022-12-08 07:19:15','',''),('8','211',412,'','20','2',1408661.34,0.00,'Sales from shift 94 on 2022-12-08 09:44:00 ','2022-12-08 09:44:00','',''),('8','211',413,'','6.1','5',0.00,1408661.34,'Sales from shift 94 on 2022-12-08 09:44:00 ','2022-12-08 09:44:00','',''),('8','211',414,'','24','3',0.00,9541000.00,'Purchase Id 22 for 32,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-08 17:35:47','',''),('8','211',415,'','supplier','1',9541000.00,0.00,'Purchase Id 22 for 32,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-08 17:35:47','',''),('8','211',416,'','20','2',1021478.60,0.00,'Sales from shift 95 on 2022-12-09 21:08:07 ','2022-12-09 21:08:07','',''),('8','211',417,'','6.1','5',0.00,1021478.60,'Sales from shift 95 on 2022-12-09 21:08:07 ','2022-12-09 21:08:07','',''),('8','211',418,'','2','6',3124665.00,0.00,'Payment Id 94 for invoice:93, receipt: 93 by Lausu Energy Resources','2022-12-10 07:45:20','',''),('8','211',419,'','supplier','1',0.00,3124665.00,'Payment Id 94 for invoice:93, receipt: 93 by Lausu Energy Resources','2022-12-10 07:45:20','',''),('8','211',420,'','2','6',1408665.00,0.00,'Payment Id 95 for invoice:94, receipt: 94 by Lausu Energy Resources','2022-12-10 07:47:18','',''),('8','211',421,'','supplier','1',0.00,1408665.00,'Payment Id 95 for invoice:94, receipt: 94 by Lausu Energy Resources','2022-12-10 07:47:18','',''),('8','211',422,'','20','2',2846999.60,0.00,'Sales from shift 96 on 2022-12-10 09:40:20 ','2022-12-10 09:40:20','',''),('8','211',423,'','6.1','5',0.00,2846999.60,'Sales from shift 96 on 2022-12-10 09:40:20 ','2022-12-10 09:40:20','',''),('8','211',424,'','20','2',3799150.80,0.00,'Sales from shift 97 on 2022-12-11 08:55:21 ','2022-12-11 08:55:21','',''),('8','211',425,'','6.1','5',0.00,3799150.80,'Sales from shift 97 on 2022-12-11 08:55:21 ','2022-12-11 08:55:21','',''),('8','211',426,'','2','6',1804670.00,0.00,'Payment Id 79 for invoice:78, receipt: 78 by Lausu Energy Resources','2022-12-11 22:30:42','',''),('8','211',427,'','supplier','1',0.00,1804670.00,'Payment Id 79 for invoice:78, receipt: 78 by Lausu Energy Resources','2022-12-11 22:30:42','',''),('8','211',428,'','24','3',0.00,14143500.00,'Purchase Id 23 for 44,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-12 11:37:59','',''),('8','211',429,'','supplier','1',14143500.00,0.00,'Purchase Id 23 for 44,900.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-12 11:37:59','',''),('8','211',430,'','2','6',3799150.00,0.00,'Payment Id 98 for invoice:97, receipt: 97 by Lausu Energy Resources','2022-12-12 16:29:12','',''),('8','211',431,'','supplier','1',0.00,3799150.00,'Payment Id 98 for invoice:97, receipt: 97 by Lausu Energy Resources','2022-12-12 16:29:12','',''),('8','211',432,'','2','6',2847000.00,0.00,'Payment Id 97 for invoice:96, receipt: 96 by Lausu Energy Resources','2022-12-12 16:29:51','',''),('8','211',433,'','supplier','1',0.00,2847000.00,'Payment Id 97 for invoice:96, receipt: 96 by Lausu Energy Resources','2022-12-12 16:29:51','',''),('8','211',434,'','20','2',7718331.60,0.00,'Sales from shift 98 on 2022-12-12 22:52:04 ','2022-12-12 22:52:04','',''),('8','211',435,'','6.1','5',0.00,7718331.60,'Sales from shift 98 on 2022-12-12 22:52:04 ','2022-12-12 22:52:04','',''),('8','211',436,'','20','2',3341860.20,0.00,'Sales from shift 99 on 2022-12-13 08:30:27 ','2022-12-13 08:30:27','',''),('8','211',437,'','6.1','5',0.00,3341860.20,'Sales from shift 99 on 2022-12-13 08:30:27 ','2022-12-13 08:30:27','',''),('8','211',438,'','2','6',3341860.00,0.00,'Payment Id 100 for invoice:99, receipt: 99 by Lausu Energy Resources','2022-12-13 16:42:26','',''),('8','211',439,'','supplier','1',0.00,3341860.00,'Payment Id 100 for invoice:99, receipt: 99 by Lausu Energy Resources','2022-12-13 16:42:26','',''),('8','211',440,'','20','2',2332269.45,0.00,'Sales from shift 100 on 2022-12-14 09:59:26 ','2022-12-14 09:59:26','',''),('8','211',441,'','6.1','5',0.00,2332269.45,'Sales from shift 100 on 2022-12-14 09:59:26 ','2022-12-14 09:59:26','',''),('8','211',442,'','2','6',2332270.00,0.00,'Payment Id 101 for invoice:100, receipt: 100 by Lausu Energy Resources','2022-12-14 14:33:55','',''),('8','211',443,'','supplier','1',0.00,2332270.00,'Payment Id 101 for invoice:100, receipt: 100 by Lausu Energy Resources','2022-12-14 14:33:55','',''),('8','211',444,'','20','2',2723118.30,0.00,'Sales from shift 101 on 2022-12-15 10:11:08 ','2022-12-15 10:11:08','',''),('8','211',445,'','6.1','5',0.00,2723118.30,'Sales from shift 101 on 2022-12-15 10:11:08 ','2022-12-15 10:11:08','',''),('8','211',446,'','2','6',975075.00,0.00,'Payment Id 96 for invoice:95, receipt: 95 by Lausu Energy Resources','2022-12-15 23:13:27','',''),('8','211',447,'','supplier','1',0.00,975075.00,'Payment Id 96 for invoice:95, receipt: 95 by Lausu Energy Resources','2022-12-15 23:13:27','',''),('8','211',448,'','2','6',7718330.00,0.00,'Payment Id 99 for invoice:98, receipt: 98 by Lausu Energy Resources','2022-12-16 16:23:21','',''),('8','211',449,'','supplier','1',0.00,7718330.00,'Payment Id 99 for invoice:98, receipt: 98 by Lausu Energy Resources','2022-12-16 16:23:21','',''),('8','211',450,'','24','3',0.00,14080500.00,'Purchase Id 24 for 44,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-18 12:16:57','',''),('8','211',451,'','supplier','1',14080500.00,0.00,'Purchase Id 24 for 44,700.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-18 12:16:57','',''),('8','211',452,'','2','6',2723120.00,0.00,'Payment Id 102 for invoice:101, receipt: 101 by Lausu Energy Resources','2022-12-19 13:52:28','',''),('8','211',453,'','supplier','1',0.00,2723120.00,'Payment Id 102 for invoice:101, receipt: 101 by Lausu Energy Resources','2022-12-19 13:52:28','',''),('8','211',454,'','20','2',5515574.40,0.00,'Sales from shift 102 on 2022-12-19 17:25:04 ','2022-12-19 17:25:04','',''),('8','211',455,'','6.1','5',0.00,5515574.40,'Sales from shift 102 on 2022-12-19 17:25:04 ','2022-12-19 17:25:04','',''),('8','211',456,'','20','2',2182824.00,0.00,'Sales from shift 103 on 2022-12-20 10:25:57 ','2022-12-20 10:25:57','',''),('8','211',457,'','6.1','5',0.00,2182824.00,'Sales from shift 103 on 2022-12-20 10:25:57 ','2022-12-20 10:25:57','',''),('8','211',458,'','2','6',2182825.00,0.00,'Payment Id 104 for invoice:103, receipt: 103 by Lausu Energy Resources','2022-12-20 17:48:31','',''),('8','211',459,'','supplier','1',0.00,2182825.00,'Payment Id 104 for invoice:103, receipt: 103 by Lausu Energy Resources','2022-12-20 17:48:31','',''),('8','211',460,'','20','2',1768595.85,0.00,'Sales from shift 104 on 2022-12-21 08:34:00 ','2022-12-21 08:34:00','',''),('8','211',461,'','6.1','5',0.00,1768595.85,'Sales from shift 104 on 2022-12-21 08:34:00 ','2022-12-21 08:34:00','',''),('8','211',462,'','20','2',2005686.90,0.00,'Sales from shift 105 on 2022-12-22 10:24:09 ','2022-12-22 10:24:09','',''),('8','211',463,'','6.1','5',0.00,2005686.90,'Sales from shift 105 on 2022-12-22 10:24:09 ','2022-12-22 10:24:09','',''),('8','211',464,'','20','2',1685224.80,0.00,'Sales from shift 107 on 2022-12-23 08:12:29 ','2022-12-23 08:12:29','',''),('8','211',465,'','6.1','5',0.00,1685224.80,'Sales from shift 107 on 2022-12-23 08:12:29 ','2022-12-23 08:12:29','',''),('8','211',466,'','2','6',5515475.00,0.00,'Payment Id 103 for invoice:102, receipt: 102 by Lausu Energy Resources','2022-12-23 15:41:55','',''),('8','211',467,'','supplier','1',0.00,5515475.00,'Payment Id 103 for invoice:102, receipt: 102 by Lausu Energy Resources','2022-12-23 15:41:55','',''),('8','211',468,'','2','6',1768595.00,0.00,'Payment Id 105 for invoice:104, receipt: 104 by Lausu Energy Resources','2022-12-23 15:53:12','',''),('8','211',469,'','supplier','1',0.00,1768595.00,'Payment Id 105 for invoice:104, receipt: 104 by Lausu Energy Resources','2022-12-23 15:53:12','',''),('8','211',470,'','20','2',810060.30,0.00,'Sales from shift 108 on 2022-12-24 09:23:42 ','2022-12-24 09:23:42','',''),('8','211',471,'','6.1','5',0.00,810060.30,'Sales from shift 108 on 2022-12-24 09:23:42 ','2022-12-24 09:23:42','',''),('8','211',472,'','2','6',2005685.00,0.00,'Payment Id 106 for invoice:105, receipt: 105 by Lausu Energy Resources','2022-12-25 03:38:43','',''),('8','211',473,'','supplier','1',0.00,2005685.00,'Payment Id 106 for invoice:105, receipt: 105 by Lausu Energy Resources','2022-12-25 03:38:43','',''),('8','211',474,'','24','3',0.00,10080000.00,'Purchase Id 25 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-26 10:52:23','',''),('8','211',475,'','supplier','1',10080000.00,0.00,'Purchase Id 25 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-26 10:52:23','',''),('8','211',476,'','supplier','1',0.00,10080000.00,'Purchase Id 25 for 32,000.00 litters of Petrol - PMS returned to Lausu Energy Resources','2022-12-26 11:51:41','',''),('8','211',477,'','24','3',0.00,9760000.00,'Purchase Id 26 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-26 11:53:35','',''),('8','211',478,'','supplier','1',9760000.00,0.00,'Purchase Id 26 for 32,000.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-26 11:53:35','',''),('8','211',479,'','20','2',5728915.65,0.00,'Sales from shift 109 on 2022-12-26 12:02:15 ','2022-12-26 12:02:15','',''),('8','211',480,'','6.1','5',0.00,5728915.65,'Sales from shift 109 on 2022-12-26 12:02:15 ','2022-12-26 12:02:15','',''),('8','211',481,'','20','2',2496196.25,0.00,'Sales from shift 110 on 2022-12-27 08:24:08 ','2022-12-27 08:24:08','',''),('8','211',482,'','6.1','5',0.00,2496196.25,'Sales from shift 110 on 2022-12-27 08:24:08 ','2022-12-27 08:24:08','',''),('8','211',483,'','2','6',1683230.00,0.00,'Payment Id 107 for invoice:107, receipt: 107 by Lausu Energy Resources','2022-12-27 09:38:56','',''),('8','211',484,'','supplier','1',0.00,1683230.00,'Payment Id 107 for invoice:107, receipt: 107 by Lausu Energy Resources','2022-12-27 09:38:56','',''),('8','211',485,'','2','6',812725.00,0.00,'Payment Id 108 for invoice:108, receipt: 108 by Lausu Energy Resources','2022-12-27 09:40:11','',''),('8','211',486,'','supplier','1',0.00,812725.00,'Payment Id 108 for invoice:108, receipt: 108 by Lausu Energy Resources','2022-12-27 09:40:11','',''),('8','211',487,'','20','2',1454020.40,0.00,'Sales from shift 111 on 2022-12-28 22:25:18 ','2022-12-28 22:25:18','',''),('8','211',488,'','6.1','5',0.00,1454020.40,'Sales from shift 111 on 2022-12-28 22:25:18 ','2022-12-28 22:25:18','',''),('8','211',489,'','2','6',5728915.00,0.00,'Payment Id 109 for invoice:109, receipt: 109 by Lausu Energy Resources','2022-12-30 17:59:26','',''),('8','211',490,'','supplier','1',0.00,5728915.00,'Payment Id 109 for invoice:109, receipt: 109 by Lausu Energy Resources','2022-12-30 17:59:26','',''),('8','211',491,'','24','3',0.00,13350000.00,'Purchase Id 27 for 44,500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-30 20:36:28','',''),('8','211',492,'','supplier','1',13350000.00,0.00,'Purchase Id 27 for 44,500.00 litters of Petrol - PMS from Lausu Energy Resources','2022-12-30 20:36:28','',''),('8','211',493,'','20','2',1739838.00,0.00,'Sales from shift 112 on 2022-12-30 21:13:42 ','2022-12-30 21:13:42','',''),('8','211',494,'','6.1','5',0.00,1739838.00,'Sales from shift 112 on 2022-12-30 21:13:42 ','2022-12-30 21:13:42','',''),('8','211',495,'','20','2',1384440.00,0.00,'Sales from shift 113 on 2022-12-31 08:45:34 ','2022-12-31 08:45:34','',''),('8','211',496,'','6.1','5',0.00,1384440.00,'Sales from shift 113 on 2022-12-31 08:45:34 ','2022-12-31 08:45:34','',''),('8','211',497,'','20','2',1887105.00,0.00,'Sales from shift 114 on 2023-01-01 08:32:53 ','2023-01-01 08:32:53','',''),('8','211',498,'','6.1','5',0.00,1887105.00,'Sales from shift 114 on 2023-01-01 08:32:53 ','2023-01-01 08:32:53','',''),('8','211',499,'','2','6',2496195.00,0.00,'Payment Id 110 for invoice:110, receipt: 110 by Lausu Energy Resources','2023-01-02 00:33:54','',''),('8','211',500,'','supplier','1',0.00,2496195.00,'Payment Id 110 for invoice:110, receipt: 110 by Lausu Energy Resources','2023-01-02 00:33:54','',''),('8','211',501,'','2','6',1454020.00,0.00,'Payment Id 111 for invoice:111, receipt: 111 by Lausu Energy Resources','2023-01-02 00:34:21','',''),('8','211',502,'','supplier','1',0.00,1454020.00,'Payment Id 111 for invoice:111, receipt: 111 by Lausu Energy Resources','2023-01-02 00:34:21','',''),('8','211',503,'','2','6',1739840.00,0.00,'Payment Id 112 for invoice:112, receipt: 112 by Lausu Energy Resources','2023-01-02 00:38:12','',''),('8','211',504,'','supplier','1',0.00,1739840.00,'Payment Id 112 for invoice:112, receipt: 112 by Lausu Energy Resources','2023-01-02 00:38:12','',''),('8','211',505,'','2','6',1384440.00,0.00,'Payment Id 113 for invoice:113, receipt: 113 by Lausu Energy Resources','2023-01-02 00:38:43','',''),('8','211',506,'','supplier','1',0.00,1384440.00,'Payment Id 113 for invoice:113, receipt: 113 by Lausu Energy Resources','2023-01-02 00:38:43','',''),('8','211',507,'','20','2',4935738.00,0.00,'Sales from shift 115 on 2023-01-02 08:47:57 ','2023-01-02 08:47:57','',''),('8','211',508,'','6.1','5',0.00,4935738.00,'Sales from shift 115 on 2023-01-02 08:47:57 ','2023-01-02 08:47:57','',''),('8','211',509,'','20','2',2021592.00,0.00,'Sales from shift 116 on 2023-01-03 15:51:50 ','2023-01-03 15:51:50','',''),('8','211',510,'','6.1','5',0.00,2021592.00,'Sales from shift 116 on 2023-01-03 15:51:50 ','2023-01-03 15:51:50','',''),('8','211',511,'','2','6',1887105.00,0.00,'Payment Id 114 for invoice:114, receipt: 114 by Lausu Energy Resources','2023-01-04 14:39:12','',''),('8','211',512,'','supplier','1',0.00,1887105.00,'Payment Id 114 for invoice:114, receipt: 114 by Lausu Energy Resources','2023-01-04 14:39:12','',''),('8','211',513,'','2','6',2021590.00,0.00,'Payment Id 116 for invoice:116, receipt: 116 by Lausu Energy Resources','2023-01-04 14:41:11','',''),('8','211',514,'','supplier','1',0.00,2021590.00,'Payment Id 116 for invoice:116, receipt: 116 by Lausu Energy Resources','2023-01-04 14:41:11','',''),('8','211',515,'','2','6',4935740.00,0.00,'Payment Id 115 for invoice:115, receipt: 115 by Lausu Energy Resources','2023-01-04 17:56:33','',''),('8','211',516,'','supplier','1',0.00,4935740.00,'Payment Id 115 for invoice:115, receipt: 115 by Lausu Energy Resources','2023-01-04 17:56:33','',''),('8','211',517,'','20','2',1374825.00,0.00,'Sales from shift 117 on 2023-01-06 12:10:01 ','2023-01-06 12:10:01','',''),('8','211',518,'','6.1','5',0.00,1374825.00,'Sales from shift 117 on 2023-01-06 12:10:01 ','2023-01-06 12:10:01','',''),('8','211',519,'','24','3',0.00,8640000.00,'Purchase Id 28 for 28,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-07 16:12:38','',''),('8','211',520,'','supplier','1',8640000.00,0.00,'Purchase Id 28 for 28,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-07 16:12:38','',''),('8','211',521,'','2','6',1374825.00,0.00,'Payment Id 117 for invoice:117, receipt: 117 by Lausu Energy Resources','2023-01-07 18:11:11','',''),('8','211',522,'','supplier','1',0.00,1374825.00,'Payment Id 117 for invoice:117, receipt: 117 by Lausu Energy Resources','2023-01-07 18:11:11','',''),('8','211',523,'','20','2',1356786.00,0.00,'Sales from shift 118 on 2023-01-07 21:09:14 ','2023-01-07 21:09:14','',''),('8','211',524,'','6.1','5',0.00,1356786.00,'Sales from shift 118 on 2023-01-07 21:09:14 ','2023-01-07 21:09:14','',''),('8','211',525,'','20','2',1734462.00,0.00,'Sales from shift 119 on 2023-01-08 10:04:55 ','2023-01-08 10:04:55','',''),('8','211',526,'','6.1','5',0.00,1734462.00,'Sales from shift 119 on 2023-01-08 10:04:55 ','2023-01-08 10:04:55','',''),('8','211',527,'','20','2',5022882.00,0.00,'Sales from shift 120 on 2023-01-09 09:19:52 ','2023-01-09 09:19:52','',''),('8','211',528,'','6.1','5',0.00,5022882.00,'Sales from shift 120 on 2023-01-09 09:19:52 ','2023-01-09 09:19:52','',''),('8','211',529,'','20','2',649725.00,0.00,'Sales from shift 121 on 2023-01-10 08:50:05 ','2023-01-10 08:50:05','',''),('8','211',530,'','6.1','5',0.00,649725.00,'Sales from shift 121 on 2023-01-10 08:50:05 ','2023-01-10 08:50:05','',''),('8','211',531,'','2','6',1356785.00,0.00,'Payment Id 118 for invoice:118, receipt: 118 by Lausu Energy Resources','2023-01-11 17:20:48','',''),('8','211',532,'','supplier','1',0.00,1356785.00,'Payment Id 118 for invoice:118, receipt: 118 by Lausu Energy Resources','2023-01-11 17:20:48','',''),('8','211',533,'','2','6',1734460.00,0.00,'Payment Id 119 for invoice:119, receipt: 119 by Lausu Energy Resources','2023-01-11 17:21:07','',''),('8','211',534,'','supplier','1',0.00,1734460.00,'Payment Id 119 for invoice:119, receipt: 119 by Lausu Energy Resources','2023-01-11 17:21:07','',''),('8','211',535,'','2','7',5022880.00,0.00,'Payment Id 120 for invoice:120, receipt: 120 by Lausu Energy Resources','2023-01-11 17:21:25','',''),('8','211',536,'','supplier','1',0.00,5022880.00,'Payment Id 120 for invoice:120, receipt: 120 by Lausu Energy Resources','2023-01-11 17:21:25','',''),('8','211',537,'','2','6',649725.00,0.00,'Payment Id 121 for invoice:121, receipt: 121 by Lausu Energy Resources','2023-01-11 17:22:18','',''),('8','211',538,'','supplier','1',0.00,649725.00,'Payment Id 121 for invoice:121, receipt: 121 by Lausu Energy Resources','2023-01-11 17:22:18','',''),('8','211',539,'','24','3',0.00,9900000.00,'Purchase Id 29 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-13 22:06:45','',''),('8','211',540,'','supplier','1',9900000.00,0.00,'Purchase Id 29 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-13 22:06:45','',''),('8','211',541,'','20','2',1571844.00,0.00,'Sales from shift 122 on 2023-01-14 08:45:45 ','2023-01-14 08:45:45','',''),('8','211',542,'','6.1','5',0.00,1571844.00,'Sales from shift 122 on 2023-01-14 08:45:45 ','2023-01-14 08:45:45','',''),('8','211',543,'','20','2',1615038.00,0.00,'Sales from shift 123 on 2023-01-14 08:48:36 ','2023-01-14 08:48:36','',''),('8','211',544,'','6.1','5',0.00,1615038.00,'Sales from shift 123 on 2023-01-14 08:48:36 ','2023-01-14 08:48:36','',''),('8','211',545,'','20','2',1993785.00,0.00,'Sales from shift 124 on 2023-01-15 09:25:00 ','2023-01-15 09:25:00','',''),('8','211',546,'','6.1','5',0.00,1993785.00,'Sales from shift 124 on 2023-01-15 09:25:00 ','2023-01-15 09:25:00','',''),('8','211',547,'','20','2',4751337.00,0.00,'Sales from shift 125 on 2023-01-16 08:35:21 ','2023-01-16 08:35:21','',''),('8','211',548,'','6.1','5',0.00,4751337.00,'Sales from shift 125 on 2023-01-16 08:35:21 ','2023-01-16 08:35:21','',''),('8','211',549,'','2','6',1571885.00,0.00,'Payment Id 122 for invoice:122, receipt: 122 by Lausu Energy Resources','2023-01-16 18:16:42','',''),('8','211',550,'','supplier','1',0.00,1571885.00,'Payment Id 122 for invoice:122, receipt: 122 by Lausu Energy Resources','2023-01-16 18:16:42','',''),('8','211',551,'','2','6',4752335.00,0.00,'Payment Id 125 for invoice:125, receipt: 125 by Lausu Energy Resources','2023-01-16 18:17:18','',''),('8','211',552,'','supplier','1',0.00,4752335.00,'Payment Id 125 for invoice:125, receipt: 125 by Lausu Energy Resources','2023-01-16 18:17:18','',''),('8','211',553,'','2','6',1615040.00,0.00,'Payment Id 123 for invoice:123, receipt: 123 by Lausu Energy Resources','2023-01-17 17:29:28','',''),('8','211',554,'','supplier','1',0.00,1615040.00,'Payment Id 123 for invoice:123, receipt: 123 by Lausu Energy Resources','2023-01-17 17:29:28','',''),('8','211',555,'','2','6',1993785.00,0.00,'Payment Id 124 for invoice:124, receipt: 124 by Lausu Energy Resources','2023-01-17 17:32:23','',''),('8','211',556,'','supplier','1',0.00,1993785.00,'Payment Id 124 for invoice:124, receipt: 124 by Lausu Energy Resources','2023-01-17 17:32:23','',''),('8','211',557,'','24','3',0.00,10500000.00,'Purchase Id 30 for 35,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-19 16:51:26','',''),('8','211',558,'','supplier','1',10500000.00,0.00,'Purchase Id 30 for 35,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-19 16:51:26','',''),('8','211',559,'','20','2',1965870.00,0.00,'Sales from shift 126 on 2023-01-19 17:05:59 ','2023-01-19 17:05:59','',''),('8','211',560,'','6.1','5',0.00,1965870.00,'Sales from shift 126 on 2023-01-19 17:05:59 ','2023-01-19 17:05:59','',''),('8','211',561,'','20','2',1844826.00,0.00,'Sales from shift 127 on 2023-01-20 08:26:22 ','2023-01-20 08:26:22','',''),('8','211',562,'','6.1','5',0.00,1844826.00,'Sales from shift 127 on 2023-01-20 08:26:22 ','2023-01-20 08:26:22','',''),('8','211',563,'','20','2',2118222.00,0.00,'Sales from shift 128 on 2023-01-21 09:06:11 ','2023-01-21 09:06:11','',''),('8','211',564,'','6.1','5',0.00,2118222.00,'Sales from shift 128 on 2023-01-21 09:06:11 ','2023-01-21 09:06:11','',''),('8','211',565,'','2','6',1965825.00,0.00,'Payment Id 126 for invoice:126, receipt: 126 by Lausu Energy Resources','2023-01-21 12:29:00','',''),('8','211',566,'','supplier','1',0.00,1965825.00,'Payment Id 126 for invoice:126, receipt: 126 by Lausu Energy Resources','2023-01-21 12:29:00','',''),('8','211',567,'','2','6',1844825.00,0.00,'Payment Id 127 for invoice:127, receipt: 127 by Lausu Energy Resources','2023-01-21 12:30:46','',''),('8','211',568,'','supplier','1',0.00,1844825.00,'Payment Id 127 for invoice:127, receipt: 127 by Lausu Energy Resources','2023-01-21 12:30:46','',''),('8','211',569,'','24','3',0.00,5140800.00,'Purchase Id 31 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-21 17:41:46','',''),('8','211',570,'','supplier','1',5140800.00,0.00,'Purchase Id 31 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-21 17:41:46','',''),('8','211',571,'','20','2',811680.00,0.00,'Sales from shift 129 on 2023-01-22 09:36:50 ','2023-01-22 09:36:50','',''),('8','211',572,'','6.1','5',0.00,811680.00,'Sales from shift 129 on 2023-01-22 09:36:50 ','2023-01-22 09:36:50','',''),('8','211',573,'','20','2',3702015.54,0.00,'Sales from shift 130 on 2023-01-22 09:42:13 ','2023-01-22 09:42:13','',''),('8','211',574,'','6.1','5',0.00,3702015.54,'Sales from shift 130 on 2023-01-22 09:42:13 ','2023-01-22 09:42:13','',''),('8','211',575,'','20','2',5234114.70,0.00,'Sales from shift 131 on 2023-01-23 08:21:10 ','2023-01-23 08:21:10','',''),('8','211',576,'','6.1','5',0.00,5234114.70,'Sales from shift 131 on 2023-01-23 08:21:10 ','2023-01-23 08:21:10','',''),('8','211',577,'','2','6',2118220.00,0.00,'Payment Id 128 for invoice:128, receipt: 128 by Lausu Energy Resources','2023-01-25 19:39:33','',''),('8','211',578,'','supplier','1',0.00,2118220.00,'Payment Id 128 for invoice:128, receipt: 128 by Lausu Energy Resources','2023-01-25 19:39:33','',''),('8','211',579,'','2','6',811605.00,0.00,'Payment Id 129 for invoice:129, receipt: 129 by Lausu Energy Resources','2023-01-25 19:41:58','',''),('8','211',580,'','supplier','1',0.00,811605.00,'Payment Id 129 for invoice:129, receipt: 129 by Lausu Energy Resources','2023-01-25 19:41:58','',''),('8','211',581,'','2','6',5234000.00,0.00,'Payment Id 131 for invoice:131, receipt: 131 by Lausu Energy Resources','2023-01-27 20:26:26','',''),('8','211',582,'','supplier','1',0.00,5234000.00,'Payment Id 131 for invoice:131, receipt: 131 by Lausu Energy Resources','2023-01-27 20:26:26','',''),('8','211',583,'','2','6',3702000.00,0.00,'Payment Id 130 for invoice:130, receipt: 130 by Lausu Energy Resources','2023-01-29 19:03:42','',''),('8','211',584,'','supplier','1',0.00,3702000.00,'Payment Id 130 for invoice:130, receipt: 130 by Lausu Energy Resources','2023-01-29 19:03:42','',''),('8','211',585,'','24','3',0.00,11154000.00,'Purchase Id 32 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-31 22:18:28','',''),('8','211',586,'','supplier','1',11154000.00,0.00,'Purchase Id 32 for 33,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-01-31 22:18:28','',''),('8','211',587,'','20','2',956019.48,0.00,'Sales from shift 132 on 2023-01-31 22:39:42 ','2023-01-31 22:39:42','',''),('8','211',588,'','6.1','5',0.00,956019.48,'Sales from shift 132 on 2023-01-31 22:39:42 ','2023-01-31 22:39:42','',''),('8','211',589,'','20','2',1315284.90,0.00,'Sales from shift 133 on 2023-02-01 08:40:01 ','2023-02-01 08:40:01','',''),('8','211',590,'','6.1','5',0.00,1315284.90,'Sales from shift 133 on 2023-02-01 08:40:01 ','2023-02-01 08:40:01','',''),('8','211',591,'','20','2',2082168.15,0.00,'Sales from shift 134 on 2023-02-02 09:00:28 ','2023-02-02 09:00:28','',''),('8','211',592,'','6.1','5',0.00,2082168.15,'Sales from shift 134 on 2023-02-02 09:00:28 ','2023-02-02 09:00:28','',''),('8','211',593,'','20','2',1895378.25,0.00,'Sales from shift 135 on 2023-02-03 11:35:44 ','2023-02-03 11:35:44','',''),('8','211',594,'','6.1','5',0.00,1895378.25,'Sales from shift 135 on 2023-02-03 11:35:44 ','2023-02-03 11:35:44','',''),('8','211',595,'','20','2',2973023.70,0.00,'Sales from shift 136 on 2023-02-04 07:38:55 ','2023-02-04 07:38:55','',''),('8','211',596,'','6.1','5',0.00,2973023.70,'Sales from shift 136 on 2023-02-04 07:38:55 ','2023-02-04 07:38:55','',''),('8','211',597,'','20','2',2000454.90,0.00,'Sales from shift 137 on 2023-02-05 10:00:30 ','2023-02-05 10:00:30','',''),('8','211',598,'','6.1','5',0.00,2000454.90,'Sales from shift 137 on 2023-02-05 10:00:30 ','2023-02-05 10:00:30','',''),('8','211',599,'','2','6',1315285.00,0.00,'Payment Id 132 for invoice:133, receipt: 133 by Lausu Energy Resources','2023-02-06 17:55:52','',''),('8','211',600,'','supplier','1',0.00,1315285.00,'Payment Id 132 for invoice:133, receipt: 133 by Lausu Energy Resources','2023-02-06 17:55:52','',''),('8','211',601,'','2','6',2081170.00,0.00,'Payment Id 133 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-02-06 17:56:31','',''),('8','211',602,'','supplier','1',0.00,2081170.00,'Payment Id 133 for invoice:134, receipt: 134 by Lausu Energy Resources','2023-02-06 17:56:31','',''),('8','211',603,'','2','6',1442625.00,0.00,'Payment Id 135 for invoice:136, receipt: 136 by Lausu Energy Resources','2023-02-06 17:59:02','',''),('8','211',604,'','supplier','1',0.00,1442625.00,'Payment Id 135 for invoice:136, receipt: 136 by Lausu Energy Resources','2023-02-06 17:59:02','',''),('8','211',605,'','2','6',956075.00,0.00,'Payment Id 136 for invoice:132, receipt: 132 by Lausu Energy Resources','2023-02-06 18:01:49','',''),('8','211',606,'','supplier','1',0.00,956075.00,'Payment Id 136 for invoice:132, receipt: 132 by Lausu Energy Resources','2023-02-06 18:01:49','',''),('8','211',607,'','2','6',340155.00,0.00,'Payment Id 139 for invoice:139, receipt: 139 by Lausu Energy Resources','2023-02-06 18:04:30','',''),('8','211',608,'','supplier','1',0.00,340155.00,'Payment Id 139 for invoice:139, receipt: 139 by Lausu Energy Resources','2023-02-06 18:04:30','',''),('8','211',609,'','24','3',0.00,11316000.00,'Purchase Id 33 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-07 11:16:28','',''),('8','211',610,'','supplier','1',11316000.00,0.00,'Purchase Id 33 for 32,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-07 11:16:28','',''),('8','211',611,'','20','2',4375911.00,0.00,'Sales from shift 138 on 2023-02-07 12:35:45 ','2023-02-07 12:35:45','',''),('8','211',612,'','6.1','5',0.00,4375911.00,'Sales from shift 138 on 2023-02-07 12:35:45 ','2023-02-07 12:35:45','',''),('8','211',613,'','20','2',2694877.80,0.00,'Sales from shift 139 on 2023-02-07 12:44:02 ','2023-02-07 12:44:02','',''),('8','211',614,'','6.1','5',0.00,2694877.80,'Sales from shift 139 on 2023-02-07 12:44:02 ','2023-02-07 12:44:02','',''),('8','211',615,'','2','6',1008290.00,0.00,'Payment Id 141 for invoice:141, receipt: 141 by Lausu Energy Resources','2023-02-07 15:15:51','',''),('8','211',616,'','supplier','1',0.00,1008290.00,'Payment Id 141 for invoice:141, receipt: 141 by Lausu Energy Resources','2023-02-07 15:15:51','',''),('8','211',617,'','2','6',1357450.00,0.00,'Payment Id 137 for invoice:137, receipt: 137 by Lausu Energy Resources','2023-02-07 15:22:25','',''),('8','211',618,'','supplier','1',0.00,1357450.00,'Payment Id 137 for invoice:137, receipt: 137 by Lausu Energy Resources','2023-02-07 15:22:25','',''),('8','211',619,'','20','2',2400965.40,0.00,'Sales from shift 140 on 2023-02-08 09:22:22 ','2023-02-08 09:22:22','',''),('8','211',620,'','6.1','5',0.00,2400965.40,'Sales from shift 140 on 2023-02-08 09:22:22 ','2023-02-08 09:22:22','',''),('8','211',621,'','2','6',3367620.00,0.00,'Payment Id 140 for invoice:140, receipt: 140 by Lausu Energy Resources','2023-02-08 14:26:42','',''),('8','211',622,'','supplier','1',0.00,3367620.00,'Payment Id 140 for invoice:140, receipt: 140 by Lausu Energy Resources','2023-02-08 14:26:42','',''),('8','211',623,'','24','3',0.00,5899500.00,'Purchase Id 34 for 17,100.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-09 13:34:21','',''),('8','211',624,'','supplier','1',5899500.00,0.00,'Purchase Id 34 for 17,100.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-09 13:34:21','',''),('8','211',625,'','2','6',1513190.00,0.00,'Payment Id 143 for invoice:143, receipt: 143 by Lausu Energy Resources','2023-02-09 13:40:19','',''),('8','211',626,'','supplier','1',0.00,1513190.00,'Payment Id 143 for invoice:143, receipt: 143 by Lausu Energy Resources','2023-02-09 13:40:19','',''),('8','211',627,'','20','2',2741825.40,0.00,'Sales from shift 141 on 2023-02-09 16:20:14 ','2023-02-09 16:20:14','',''),('8','211',628,'','6.1','5',0.00,2741825.40,'Sales from shift 141 on 2023-02-09 16:20:14 ','2023-02-09 16:20:14','',''),('8','211',629,'','2','6',452750.00,0.00,'Payment Id 134 for invoice:135, receipt: 135 by Lausu Energy Resources','2023-02-09 18:16:08','',''),('8','211',630,'','supplier','1',0.00,452750.00,'Payment Id 134 for invoice:135, receipt: 135 by Lausu Energy Resources','2023-02-09 18:16:08','',''),('8','211',631,'','2','6',1356815.00,0.00,'Payment Id 144 for invoice:144, receipt: 144 by Lausu Energy Resources','2023-02-10 16:53:53','',''),('8','211',632,'','supplier','1',0.00,1356815.00,'Payment Id 144 for invoice:144, receipt: 144 by Lausu Energy Resources','2023-02-10 16:53:53','',''),('8','211',633,'','2','6',1180950.00,0.00,'Payment Id 142 for invoice:142, receipt: 142 by Lausu Energy Resources','2023-02-10 16:55:04','',''),('8','211',634,'','supplier','1',0.00,1180950.00,'Payment Id 142 for invoice:142, receipt: 142 by Lausu Energy Resources','2023-02-10 16:55:04','',''),('8','211',635,'','2','6',1647650.00,0.00,'Payment Id 147 for invoice:147, receipt: 147 by Lausu Energy Resources','2023-02-10 16:57:22','',''),('8','211',636,'','supplier','1',0.00,1647650.00,'Payment Id 147 for invoice:147, receipt: 147 by Lausu Energy Resources','2023-02-10 16:57:22','',''),('8','211',637,'','20','2',3313838.85,0.00,'Sales from shift 142 on 2023-02-10 18:38:22 ','2023-02-10 18:38:22','',''),('8','211',638,'','6.1','5',0.00,3313838.85,'Sales from shift 142 on 2023-02-10 18:38:22 ','2023-02-10 18:38:22','',''),('8','211',639,'','24','3',0.00,12075000.00,'Purchase Id 35 for 35,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-12 08:11:25','',''),('8','211',640,'','supplier','1',12075000.00,0.00,'Purchase Id 35 for 35,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-12 08:11:25','',''),('8','211',641,'','20','2',3202414.20,0.00,'Sales from shift 143 on 2023-02-12 22:07:25 ','2023-02-12 22:07:25','',''),('8','211',642,'','6.1','5',0.00,3202414.20,'Sales from shift 143 on 2023-02-12 22:07:25 ','2023-02-12 22:07:25','',''),('8','211',643,'','20','2',2435068.65,0.00,'Sales from shift 144 on 2023-02-12 22:27:25 ','2023-02-12 22:27:25','',''),('8','211',644,'','6.1','5',0.00,2435068.65,'Sales from shift 144 on 2023-02-12 22:27:25 ','2023-02-12 22:27:25','',''),('8','211',645,'','20','2',5558733.15,0.00,'Sales from shift 145 on 2023-02-13 08:56:47 ','2023-02-13 08:56:47','',''),('8','211',646,'','6.1','5',0.00,5558733.15,'Sales from shift 145 on 2023-02-13 08:56:47 ','2023-02-13 08:56:47','',''),('8','211',647,'','2','6',1094175.00,0.00,'Payment Id 146 for invoice:146, receipt: 146 by Lausu Energy Resources','2023-02-13 17:53:19','',''),('8','211',648,'','supplier','1',0.00,1094175.00,'Payment Id 146 for invoice:146, receipt: 146 by Lausu Energy Resources','2023-02-13 17:53:19','',''),('8','211',649,'','2','6',1342600.00,0.00,'Payment Id 148 for invoice:148, receipt: 148 by Lausu Energy Resources','2023-02-13 17:55:16','',''),('8','211',650,'','supplier','1',0.00,1342600.00,'Payment Id 148 for invoice:148, receipt: 148 by Lausu Energy Resources','2023-02-13 17:55:16','',''),('8','211',651,'','2','6',1970800.00,0.00,'Payment Id 149 for invoice:149, receipt: 149 by Lausu Energy Resources','2023-02-13 17:57:59','',''),('8','211',652,'','supplier','1',0.00,1970800.00,'Payment Id 149 for invoice:149, receipt: 149 by Lausu Energy Resources','2023-02-13 17:57:59','',''),('8','211',653,'','20','2',2640716.25,0.00,'Sales from shift 146 on 2023-02-14 08:53:01 ','2023-02-14 08:53:01','',''),('8','211',654,'','6.1','5',0.00,2640716.25,'Sales from shift 146 on 2023-02-14 08:53:01 ','2023-02-14 08:53:01','',''),('8','211',655,'','2','6',1104900.00,0.00,'Payment Id 151 for invoice:151, receipt: 151 by Lausu Energy Resources','2023-02-16 19:02:46','',''),('8','211',656,'','supplier','1',0.00,1104900.00,'Payment Id 151 for invoice:151, receipt: 151 by Lausu Energy Resources','2023-02-16 19:02:46','',''),('8','211',657,'','2','6',1092470.00,0.00,'Payment Id 152 for invoice:152, receipt: 152 by Lausu Energy Resources','2023-02-16 19:04:44','',''),('8','211',658,'','supplier','1',0.00,1092470.00,'Payment Id 152 for invoice:152, receipt: 152 by Lausu Energy Resources','2023-02-16 19:04:44','',''),('8','211',659,'','2','6',1342600.00,0.00,'Payment Id 153 for invoice:153, receipt: 153 by Lausu Energy Resources','2023-02-16 19:05:35','',''),('8','211',660,'','supplier','1',0.00,1342600.00,'Payment Id 153 for invoice:153, receipt: 153 by Lausu Energy Resources','2023-02-16 19:05:35','',''),('8','211',661,'','2','6',3338635.00,0.00,'Payment Id 154 for invoice:154, receipt: 154 by Lausu Energy Resources','2023-02-16 19:06:29','',''),('8','211',662,'','supplier','1',0.00,3338635.00,'Payment Id 154 for invoice:154, receipt: 154 by Lausu Energy Resources','2023-02-16 19:06:29','',''),('8','211',663,'','24','3',0.00,9792000.00,'Purchase Id 36 for 28,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-17 23:10:45','',''),('8','211',664,'','supplier','1',9792000.00,0.00,'Purchase Id 36 for 28,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-17 23:10:45','',''),('8','211',665,'','20','2',1541985.00,0.00,'Sales from shift 147 on 2023-02-18 21:23:58 ','2023-02-18 21:23:58','',''),('8','211',666,'','6.1','5',0.00,1541985.00,'Sales from shift 147 on 2023-02-18 21:23:58 ','2023-02-18 21:23:58','',''),('8','211',667,'','20','2',1742398.00,0.00,'Sales from shift 148 on 2023-02-19 22:52:22 ','2023-02-19 22:52:22','',''),('8','211',668,'','6.1','5',0.00,1742398.00,'Sales from shift 148 on 2023-02-19 22:52:22 ','2023-02-19 22:52:22','',''),('8','211',669,'','2','6',2097515.00,0.00,'Payment Id 150 for invoice:150, receipt: 150 by Lausu Energy Resources','2023-02-20 09:15:16','',''),('8','211',670,'','supplier','1',0.00,2097515.00,'Payment Id 150 for invoice:150, receipt: 150 by Lausu Energy Resources','2023-02-20 09:15:16','',''),('8','211',671,'','20','2',4704580.00,0.00,'Sales from shift 149 on 2023-02-20 15:38:11 ','2023-02-20 15:38:11','',''),('8','211',672,'','6.1','5',0.00,4704580.00,'Sales from shift 149 on 2023-02-20 15:38:11 ','2023-02-20 15:38:11','',''),('8','211',673,'','20','2',1803774.80,0.00,'Sales from shift 150 on 2023-02-21 14:33:07 ','2023-02-21 14:33:07','',''),('8','211',674,'','6.1','5',0.00,1803774.80,'Sales from shift 150 on 2023-02-21 14:33:07 ','2023-02-21 14:33:07','',''),('8','211',675,'','2','6',4704580.00,0.00,'Payment Id 160 for invoice:162, receipt: 162 by Lausu Energy Resources','2023-02-21 17:34:48','',''),('8','211',676,'','supplier','1',0.00,4704580.00,'Payment Id 160 for invoice:162, receipt: 162 by Lausu Energy Resources','2023-02-21 17:34:48','',''),('8','211',677,'','2','6',1742400.00,0.00,'Payment Id 159 for invoice:160, receipt: 160 by Lausu Energy Resources','2023-02-21 17:50:18','',''),('8','211',678,'','supplier','1',0.00,1742400.00,'Payment Id 159 for invoice:160, receipt: 160 by Lausu Energy Resources','2023-02-21 17:50:18','',''),('8','211',679,'','2','6',1541985.00,0.00,'Payment Id 158 for invoice:159, receipt: 159 by Lausu Energy Resources','2023-02-21 17:51:40','',''),('8','211',680,'','supplier','1',0.00,1541985.00,'Payment Id 158 for invoice:159, receipt: 159 by Lausu Energy Resources','2023-02-21 17:51:40','',''),('8','211',681,'','2','6',1573290.00,0.00,'Payment Id 138 for invoice:138, receipt: 38 by Lausu Energy Resources','2023-02-23 09:53:40','',''),('8','211',682,'','supplier','1',0.00,1573290.00,'Payment Id 138 for invoice:138, receipt: 38 by Lausu Energy Resources','2023-02-23 09:53:40','',''),('8','211',683,'','24','3',0.00,9855000.00,'Purchase Id 37 for 32,850.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-24 10:04:36','',''),('8','211',684,'','supplier','1',9855000.00,0.00,'Purchase Id 37 for 32,850.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-24 10:04:36','',''),('8','211',685,'','20','2',2271093.00,0.00,'Sales from shift 151 on 2023-02-24 15:01:13 ','2023-02-24 15:01:13','',''),('8','211',686,'','6.1','5',0.00,2271093.00,'Sales from shift 151 on 2023-02-24 15:01:13 ','2023-02-24 15:01:13','',''),('8','211',687,'','20','2',2742147.00,0.00,'Sales from shift 152 on 2023-02-25 10:57:19 ','2023-02-25 10:57:19','',''),('8','211',688,'','6.1','5',0.00,2742147.00,'Sales from shift 152 on 2023-02-25 10:57:19 ','2023-02-25 10:57:19','',''),('8','211',689,'','24','3',0.00,5400000.00,'Purchase Id 38 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-26 21:28:09','',''),('8','211',690,'','supplier','1',5400000.00,0.00,'Purchase Id 38 for 18,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-02-26 21:28:09','',''),('8','211',691,'','20','2',5702841.00,0.00,'Sales from shift 153 on 2023-02-27 17:33:14 ','2023-02-27 17:33:14','',''),('8','211',692,'','6.1','5',0.00,5702841.00,'Sales from shift 153 on 2023-02-27 17:33:14 ','2023-02-27 17:33:14','',''),('8','211',693,'','20','2',4264782.00,0.00,'Sales from shift 154 on 2023-02-28 09:03:46 ','2023-02-28 09:03:46','',''),('8','211',694,'','6.1','5',0.00,4264782.00,'Sales from shift 154 on 2023-02-28 09:03:46 ','2023-02-28 09:03:46','',''),('8','211',695,'','24','3',0.00,9450000.00,'Purchase Id 39 for 31,500.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-01 16:05:58','',''),('8','211',696,'','supplier','1',9450000.00,0.00,'Purchase Id 39 for 31,500.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-01 16:05:58','',''),('8','211',697,'','2','6',1147550.00,0.00,'Payment Id 157 for invoice:157, receipt: 157 by Lausu Energy Resources','2023-03-01 16:07:05','',''),('8','211',698,'','supplier','1',0.00,1147550.00,'Payment Id 157 for invoice:157, receipt: 157 by Lausu Energy Resources','2023-03-01 16:07:05','',''),('8','211',699,'','2','6',1803775.00,0.00,'Payment Id 161 for invoice:163, receipt: 163 by Lausu Energy Resources','2023-03-02 13:23:42','',''),('8','211',700,'','supplier','1',0.00,1803775.00,'Payment Id 161 for invoice:163, receipt: 163 by Lausu Energy Resources','2023-03-02 13:23:42','',''),('8','211',701,'','2','6',2742145.00,0.00,'Payment Id 162 for invoice:164, receipt: 164 by Lausu Energy Resources','2023-03-02 13:24:01','',''),('8','211',702,'','supplier','1',0.00,2742145.00,'Payment Id 162 for invoice:164, receipt: 164 by Lausu Energy Resources','2023-03-02 13:24:01','',''),('8','211',703,'','2','6',4264780.00,0.00,'Payment Id 164 for invoice:166, receipt: 166 by Lausu Energy Resources','2023-03-02 13:24:39','',''),('8','211',704,'','supplier','1',0.00,4264780.00,'Payment Id 164 for invoice:166, receipt: 166 by Lausu Energy Resources','2023-03-02 13:24:39','',''),('8','211',705,'','20','2',3774066.00,0.00,'Sales from shift 155 on 2023-03-02 17:30:13 ','2023-03-02 17:30:13','',''),('8','211',706,'','6.1','5',0.00,3774066.00,'Sales from shift 155 on 2023-03-02 17:30:13 ','2023-03-02 17:30:13','',''),('8','211',707,'','20','2',3667452.00,0.00,'Sales from shift 156 on 2023-03-02 17:37:30 ','2023-03-02 17:37:30','',''),('8','211',708,'','6.1','5',0.00,3667452.00,'Sales from shift 156 on 2023-03-02 17:37:30 ','2023-03-02 17:37:30','',''),('8','211',709,'','20','2',2361747.00,0.00,'Sales from shift 157 on 2023-03-04 08:30:24 ','2023-03-04 08:30:24','',''),('8','211',710,'','6.1','5',0.00,2361747.00,'Sales from shift 157 on 2023-03-04 08:30:24 ','2023-03-04 08:30:24','',''),('8','211',711,'','24','3',0.00,13500000.00,'Purchase Id 40 for 45,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-04 22:16:12','',''),('8','211',712,'','supplier','1',13500000.00,0.00,'Purchase Id 40 for 45,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-04 22:16:12','',''),('8','211',713,'','2','6',2358735.00,0.00,'Payment Id 169 for invoice:172, receipt: 172 by Lausu Energy Resources','2023-03-05 07:24:50','',''),('8','211',714,'','supplier','1',0.00,2358735.00,'Payment Id 169 for invoice:172, receipt: 172 by Lausu Energy Resources','2023-03-05 07:24:50','',''),('8','211',715,'','2','6',3667450.00,0.00,'Payment Id 167 for invoice:170, receipt: 170 by Lausu Energy Resources','2023-03-05 07:26:08','',''),('8','211',716,'','supplier','1',0.00,3667450.00,'Payment Id 167 for invoice:170, receipt: 170 by Lausu Energy Resources','2023-03-05 07:26:08','',''),('8','211',717,'','2','6',3774065.00,0.00,'Payment Id 166 for invoice:168, receipt: 168 by Lausu Energy Resources','2023-03-05 07:26:39','',''),('8','211',718,'','supplier','1',0.00,3774065.00,'Payment Id 166 for invoice:168, receipt: 168 by Lausu Energy Resources','2023-03-05 07:26:39','',''),('8','211',719,'','2','6',4264780.00,0.00,'Payment Id 163 for invoice:165, receipt: 165 by Lausu Energy Resources','2023-03-05 07:27:28','',''),('8','211',720,'','supplier','1',0.00,4264780.00,'Payment Id 163 for invoice:165, receipt: 165 by Lausu Energy Resources','2023-03-05 07:27:28','',''),('8','211',721,'','20','2',3331101.00,0.00,'Sales from shift 158 on 2023-03-05 11:42:14 ','2023-03-05 11:42:14','',''),('8','211',722,'','6.1','5',0.00,3331101.00,'Sales from shift 158 on 2023-03-05 11:42:14 ','2023-03-05 11:42:14','',''),('8','211',723,'','20','2',6023160.00,0.00,'Sales from shift 159 on 2023-03-06 09:31:55 ','2023-03-06 09:31:55','',''),('8','211',724,'','6.1','5',0.00,6023160.00,'Sales from shift 159 on 2023-03-06 09:31:55 ','2023-03-06 09:31:55','',''),('8','211',725,'','20','2',4220085.00,0.00,'Sales from shift 160 on 2023-03-07 09:15:55 ','2023-03-07 09:15:55','',''),('8','211',726,'','6.1','5',0.00,4220085.00,'Sales from shift 160 on 2023-03-07 09:15:55 ','2023-03-07 09:15:55','',''),('8','211',727,'','24','3',0.00,4485000.00,'Purchase Id 41 for 14,950.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-07 22:50:29','',''),('8','211',728,'','supplier','1',4485000.00,0.00,'Purchase Id 41 for 14,950.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-07 22:50:29','',''),('8','211',729,'','2','6',1438060.00,0.00,'Payment Id 165 for invoice:167, receipt: 167 by Lausu Energy Resources','2023-03-08 08:35:38','',''),('8','211',730,'','supplier','1',0.00,1438060.00,'Payment Id 165 for invoice:167, receipt: 167 by Lausu Energy Resources','2023-03-08 08:35:38','',''),('8','211',731,'','2','6',3331100.00,0.00,'Payment Id 170 for invoice:173, receipt: 173 by Lausu Energy Resources','2023-03-08 08:36:08','',''),('8','211',732,'','supplier','1',0.00,3331100.00,'Payment Id 170 for invoice:173, receipt: 173 by Lausu Energy Resources','2023-03-08 08:36:08','',''),('8','211',733,'','2','6',6023160.00,0.00,'Payment Id 171 for invoice:174, receipt: 174 by Lausu Energy Resources','2023-03-08 08:36:49','',''),('8','211',734,'','supplier','1',0.00,6023160.00,'Payment Id 171 for invoice:174, receipt: 174 by Lausu Energy Resources','2023-03-08 08:36:49','',''),('8','211',735,'','2','6',4220085.00,0.00,'Payment Id 172 for invoice:175, receipt: 175 by Lausu Energy Resources','2023-03-08 08:37:39','',''),('8','211',736,'','supplier','1',0.00,4220085.00,'Payment Id 172 for invoice:175, receipt: 175 by Lausu Energy Resources','2023-03-08 08:37:39','',''),('8','211',737,'','20','2',3022200.00,0.00,'Sales from shift 161 on 2023-03-08 09:32:43 ','2023-03-08 09:32:43','',''),('8','211',738,'','6.1','5',0.00,3022200.00,'Sales from shift 161 on 2023-03-08 09:32:43 ','2023-03-08 09:32:43','',''),('8','211',739,'','20','2',1523139.00,0.00,'Sales from shift 162 on 2023-03-09 11:09:00 ','2023-03-09 11:09:00','',''),('8','211',740,'','6.1','5',0.00,1523139.00,'Sales from shift 162 on 2023-03-09 11:09:00 ','2023-03-09 11:09:00','',''),('8','211',741,'','2','6',3022200.00,0.00,'Payment Id 173 for invoice:176, receipt: 176 by Lausu Energy Resources','2023-03-09 15:04:07','',''),('8','211',742,'','supplier','1',0.00,3022200.00,'Payment Id 173 for invoice:176, receipt: 176 by Lausu Energy Resources','2023-03-09 15:04:07','',''),('8','211',743,'','24','3',0.00,5040000.00,'Purchase Id 42 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-12 10:40:20','',''),('8','211',744,'','supplier','1',5040000.00,0.00,'Purchase Id 42 for 16,800.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-12 10:40:20','',''),('8','211',745,'','20','2',5057010.00,0.00,'Sales from shift 163 on 2023-03-13 22:52:14 ','2023-03-13 22:52:14','',''),('8','211',746,'','6.1','5',0.00,5057010.00,'Sales from shift 163 on 2023-03-13 22:52:14 ','2023-03-13 22:52:14','',''),('8','211',747,'','2','6',5057010.00,0.00,'Payment Id 175 for invoice:178, receipt: 178 by Lausu Energy Resources','2023-03-15 13:59:45','',''),('8','211',748,'','supplier','1',0.00,5057010.00,'Payment Id 175 for invoice:178, receipt: 178 by Lausu Energy Resources','2023-03-15 13:59:45','',''),('8','211',749,'','24','3',0.00,4800000.00,'Purchase Id 44 for 16,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-18 11:58:59','',''),('8','211',750,'','supplier','1',4800000.00,0.00,'Purchase Id 44 for 16,000.00 litters of Petrol - PMS from Lausu Energy Resources','2023-03-18 11:58:59','',''),('8','211',751,'','20','2',3359736.00,0.00,'Sales from shift 164 on 2023-03-18 12:53:37 ','2023-03-18 12:53:37','',''),('8','211',752,'','6.1','5',0.00,3359736.00,'Sales from shift 164 on 2023-03-18 12:53:37 ','2023-03-18 12:53:37','',''),('8','211',753,'','20','2',1475589.00,0.00,'Sales from shift 165 on 2023-03-20 13:40:13 ','2023-03-20 13:40:13','',''),('8','211',754,'','6.1','5',0.00,1475589.00,'Sales from shift 165 on 2023-03-20 13:40:13 ','2023-03-20 13:40:13','','');
/*!40000 ALTER TABLE `ledgers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `options`
--

DROP TABLE IF EXISTS `options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` bigint NOT NULL,
  `station_id` bigint NOT NULL,
  `option_key` varchar(200) NOT NULL,
  `option_value` longtext,
  `thedate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `station_id` (`station_id`,`option_key`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `options`
--

LOCK TABLES `options` WRITE;
/*!40000 ALTER TABLE `options` DISABLE KEYS */;
/*!40000 ALTER TABLE `options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `measurement` varchar(20) NOT NULL,
  `quantity2` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`code`,`name`,`measurement`,`quantity2`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `cleanup` (`cleanup`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'8','211','PMS','Petrol','Litres',0,300.00,207.00,207.00,207.00,0.00,0,'2022-08-06 09:01:10','926','926','2022-08-06 09:01:10',0),(2,'8','211','AGO','Diesel','Litres',0,0.00,0.00,0.00,0.00,0.00,0,'2022-08-06 09:28:50','926','926','2022-08-06 09:28:50',0);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_changevalues`
--

DROP TABLE IF EXISTS `products_changevalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_changevalues` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `change_id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity` bigint NOT NULL,
  `oldrate` decimal(20,2) NOT NULL,
  `newrate` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`change_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_changevalues`
--

LOCK TABLES `products_changevalues` WRITE;
/*!40000 ALTER TABLE `products_changevalues` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_changevalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_prices`
--

DROP TABLE IF EXISTS `products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_dealer` decimal(20,2) NOT NULL DEFAULT '0.00',
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_prices`
--

LOCK TABLES `products_prices` WRITE;
/*!40000 ALTER TABLE `products_prices` DISABLE KEYS */;
INSERT INTO `products_prices` VALUES (1,'8','211',1,215.00,0.00,0.00,0.00,'Cost from purchase id #1','2022-08-10 05:32:01','928'),(2,'8','211',1,200.00,0.00,0.00,0.00,'Cost from purchase id #3','2022-08-24 00:01:50','928'),(3,'8','211',1,195.00,0.00,0.00,0.00,'Cost from purchase id #4','2022-08-31 13:33:10','467'),(4,'8','211',1,190.00,0.00,0.00,0.00,'Cost from purchase id #5','2022-09-10 12:55:11','928'),(5,'8','211',1,203.00,0.00,0.00,0.00,'Cost from purchase id #10','2022-10-10 14:29:03','928'),(6,'8','211',1,207.00,207.00,207.00,207.00,'CHANGE PRICE','2022-10-12 16:15:25','467'),(7,'8','211',1,225.00,207.00,0.00,0.00,'Cost from purchase id #12','2022-10-16 11:14:56','928'),(8,'8','211',1,235.00,207.00,0.00,0.00,'Cost from purchase id #13','2022-10-22 08:28:01','928'),(9,'8','211',1,240.00,207.00,0.00,0.00,'Cost from purchase id #14','2022-10-26 09:12:00','928'),(10,'8','211',1,255.00,207.00,0.00,0.00,'Cost from purchase id #15','2022-11-05 23:39:14','928'),(11,'8','211',1,260.00,207.00,0.00,0.00,'Cost from purchase id #18','2022-11-20 23:56:51','928'),(12,'8','211',1,270.00,207.00,0.00,0.00,'Cost from purchase id #20','2022-12-06 16:20:46','928'),(13,'8','211',1,290.00,207.00,0.00,0.00,'Cost from purchase id #22','2022-12-08 17:35:47','928'),(14,'8','211',1,315.00,207.00,0.00,0.00,'Cost from purchase id #23','2022-12-12 11:37:59','928'),(15,'8','211',1,305.00,207.00,0.00,0.00,'Cost from purchase id #26','2022-12-26 11:53:35','928'),(16,'8','211',1,300.00,207.00,0.00,0.00,'Cost from purchase id #27','2022-12-30 20:36:28','928'),(17,'8','211',1,306.00,207.00,0.00,0.00,'Cost from purchase id #31','2023-01-21 17:41:46','928'),(18,'8','211',1,338.00,207.00,0.00,0.00,'Cost from purchase id #32','2023-01-31 22:18:28','928'),(19,'8','211',1,345.00,207.00,0.00,0.00,'Cost from purchase id #33','2023-02-07 11:16:28','928'),(20,'8','211',1,340.00,207.00,0.00,0.00,'Cost from purchase id #36','2023-02-17 23:10:45','928'),(21,'8','211',1,300.00,207.00,0.00,0.00,'Cost from purchase id #37','2023-02-24 10:04:36','928');
/*!40000 ALTER TABLE `products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_reconciliations`
--

DROP TABLE IF EXISTS `products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_reconciliations`
--

LOCK TABLES `products_reconciliations` WRITE;
/*!40000 ALTER TABLE `products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products_shortages`
--

DROP TABLE IF EXISTS `products_shortages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `products_shortages` (
  `shortage_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shortagedate` date NOT NULL,
  `product_id` varchar(10) NOT NULL,
  `type` int NOT NULL DEFAULT '0',
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`shortage_id`),
  KEY `companycode` (`company_id`,`shortagedate`,`product_id`,`rate`,`quantity`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products_shortages`
--

LOCK TABLES `products_shortages` WRITE;
/*!40000 ALTER TABLE `products_shortages` DISABLE KEYS */;
/*!40000 ALTER TABLE `products_shortages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pts_nozzles`
--

DROP TABLE IF EXISTS `pts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pts_nozzles` (
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pts_id` int NOT NULL,
  `pump` varchar(20) NOT NULL,
  `code` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `last_volume` decimal(20,2) NOT NULL,
  `last_price` decimal(20,2) NOT NULL,
  `last_amount` decimal(20,2) NOT NULL,
  `last_transaction` int NOT NULL DEFAULT '0',
  `total_volume` decimal(20,2) NOT NULL,
  `total_amount` decimal(20,2) NOT NULL,
  `total_transactions` decimal(20,2) NOT NULL,
  `lastconnect` datetime NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `terminal_id` (`pts_id`,`pump`,`code`,`lastconnect`),
  KEY `companycode` (`company_id`,`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pts_nozzles`
--

LOCK TABLES `pts_nozzles` WRITE;
/*!40000 ALTER TABLE `pts_nozzles` DISABLE KEYS */;
/*!40000 ALTER TABLE `pts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
INSERT INTO `purchases` VALUES (1,'8','211','2022-08-09',1,1,215.00,27750.00,0.00,0.00,5966250.00,0.00,'','00013','RAN683XA','','','','2022-08-09 13:41:37',15,'','924','','0000-00-00 00:00:00','928','2022-08-10 05:32:01'),(2,'8','211','2022-08-12',1,1,215.00,33000.00,0.00,0.00,0.00,0.00,'','00024','BCH424XA','','','','2022-08-12 22:51:47',15,'Purchase of PM\'s','924','','0000-00-00 00:00:00','928','2022-08-13 09:43:23'),(3,'8','211','2022-08-23',1,1,200.00,50000.00,0.00,0.00,10000000.00,0.00,'','00030','RAN33XF','','','','2022-08-23 10:44:37',15,'Purchase of PM\'s','924','','0000-00-00 00:00:00','928','2022-08-24 00:01:50'),(4,'8','211','2022-08-31',1,1,195.00,32000.00,0.00,0.00,6240000.00,0.00,'','03','NSR 435 ZS','','','','2022-08-31 07:42:08',15,'Purchase of PM\'s','924','467','2022-08-31 13:32:50','467','2022-08-31 13:33:10'),(5,'8','211','2022-09-10',1,1,190.00,50000.00,0.00,0.00,9500000.00,0.00,'','00035','BCH428XA','','','','2022-09-10 12:38:38',15,'Purchase of Pms','924','','0000-00-00 00:00:00','928','2022-09-10 12:55:11'),(6,'8','211','2022-09-17',1,1,190.00,33000.00,0.00,0.00,6270000.00,0.00,'','00036','GML594XA','','','','2022-09-17 19:48:31',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-09-17 20:05:40'),(7,'8','211','2022-09-23',1,1,190.00,17000.00,0.00,0.00,3230000.00,0.00,'','00037','RAN689XA','','','','2022-09-23 08:31:20',15,'Purchase of PM\'s','924','','0000-00-00 00:00:00','928','2022-09-23 13:54:22'),(8,'8','211','2022-09-28',1,1,190.00,32000.00,0.00,0.00,6080000.00,0.00,'','00036','WDL813','','','','2022-09-28 08:29:34',15,'Purchase of PM\'s','924','','0000-00-00 00:00:00','928','2022-09-28 13:11:49'),(9,'8','211','2022-10-07',1,1,190.00,33000.00,0.00,0.00,6270000.00,0.00,'','00049','RAN32XF','','','','2022-10-07 08:40:39',15,'Purchase of PMS','924','','0000-00-00 00:00:00','928','2022-10-07 12:15:08'),(10,'8','211','2022-10-10',1,1,203.00,21250.00,0.00,0.00,4313750.00,0.00,'','00555','Nsr56ZQ','','','','2022-10-10 08:45:55',10,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-10-10 14:29:03'),(11,'8','211','2022-10-15',1,1,207.00,32800.00,0.00,0.00,6789600.00,0.00,'','00558','BCH424XA','','','','2022-10-15 17:19:51',2,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-10-16 10:58:53'),(12,'8','211','2022-10-16',1,1,225.00,32800.00,0.00,0.00,7380000.00,0.00,'','00558','BCH424XA','','','','2022-10-16 11:13:04',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-10-16 11:14:56'),(13,'8','211','2022-10-21',1,1,235.00,32050.00,0.00,0.00,7531750.00,0.00,'','00562','NSr435ZS','','','','2022-10-21 08:37:54',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-10-22 08:28:01'),(14,'8','211','2022-10-25',1,1,240.00,30350.00,0.00,0.00,7284000.00,0.00,'','00567','Nsr57ZQ','','','','2022-10-25 10:34:44',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-10-26 09:12:00'),(15,'8','211','2022-11-05',1,1,255.00,33000.00,0.00,0.00,8415000.00,0.00,'','00010','RAN32XF','','','','2022-11-05 11:00:21',15,'Purchase of pms','924','928','2022-11-05 23:38:41','928','2022-11-05 23:39:14'),(16,'8','211','2022-11-07',1,1,255.00,33100.00,0.00,0.00,8440500.00,0.00,'','00579','GML594XA','','','','2022-11-07 23:00:10',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-11-08 13:21:31'),(17,'8','211','2022-11-15',1,1,255.00,33000.00,0.00,0.00,8415000.00,0.00,'','00011','DKA705ZP','','','','2022-11-15 15:35:14',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-11-15 17:25:01'),(18,'8','211','2022-11-20',1,1,260.00,17000.00,0.00,0.00,4420000.00,0.00,'','0012','RAN33XF','','','','2022-11-20 07:54:25',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-11-20 23:56:51'),(19,'8','211','2022-11-27',1,1,260.00,45000.00,0.00,0.00,11700000.00,0.00,'','0003','KUJ983XU','','','','2022-11-27 20:17:57',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-11-28 10:05:42'),(20,'8','211','2022-12-06',1,1,270.00,17000.00,0.00,0.00,4590000.00,0.00,'','000989','GML594XA','','','','2022-12-06 13:24:36',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-12-06 16:20:46'),(22,'8','211','2022-12-08',1,1,290.00,32900.00,0.00,0.00,9541000.00,0.00,'','','BCH428XA','','','','2022-12-08 14:51:14',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-12-08 17:35:47'),(23,'8','211','2022-12-11',1,1,315.00,44900.00,0.00,0.00,14143500.00,0.00,'','','Trn535XA','','','','2022-12-11 10:13:17',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-12-12 11:37:59'),(24,'8','211','2022-12-18',1,1,315.00,44700.00,0.00,0.00,14080500.00,0.00,'','','ABC06ZU','','','','2022-12-18 10:47:24',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-12-18 12:16:57'),(25,'8','211','2022-12-25',1,1,315.00,32000.00,0.00,0.00,10080000.00,0.00,'','','NSr435ZS','','','','2022-12-25 12:08:17',2,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-12-26 11:51:41'),(26,'8','211','2022-12-26',1,1,305.00,32000.00,0.00,0.00,9760000.00,0.00,'','','NSR435ZS','','','','2022-12-26 11:51:11',15,'Purchase of pms','924','928','2022-12-26 11:53:24','928','2022-12-26 11:53:35'),(27,'8','211','2022-12-30',1,1,300.00,44500.00,0.00,0.00,13350000.00,0.00,'','','ABC068ZU','','','','2022-12-30 20:25:49',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2022-12-30 20:36:28'),(28,'8','211','2023-01-06',1,1,300.00,28800.00,0.00,0.00,8640000.00,0.00,'','','Nsr56Zq','','','','2023-01-06 17:13:10',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2023-01-07 16:12:38'),(29,'8','211','2023-01-12',1,1,300.00,33000.00,0.00,0.00,9900000.00,0.00,'','','GML594XA','','','','2023-01-12 17:33:24',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2023-01-13 22:06:45'),(30,'8','211','2023-01-18',1,1,300.00,35000.00,0.00,0.00,10500000.00,0.00,'','','RAN441XA','','','','2023-01-18 19:34:32',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2023-01-19 16:51:26'),(31,'8','211','2023-01-21',1,1,306.00,16800.00,0.00,0.00,5140800.00,0.00,'','','BCH428XA','','','','2023-01-21 17:37:56',15,'Purchase of pms','924','','0000-00-00 00:00:00','928','2023-01-21 17:41:46'),(32,'8','211','2023-01-31',1,1,338.00,33000.00,0.00,0.00,11154000.00,0.00,'','','BCH424XA','','','','2023-01-31 09:08:42',15,'Purchase of Pms ','924','','0000-00-00 00:00:00','928','2023-01-31 22:18:29'),(33,'8','211','2023-02-07',1,1,345.00,32800.00,0.00,0.00,11316000.00,0.00,'','','WDL813XA','','','','2023-02-07 00:21:51',15,'Purchase of Pms ','924','928','2023-02-07 11:16:09','928','2023-02-07 11:16:28'),(34,'8','211','2023-02-09',1,1,345.00,17100.00,0.00,0.00,5899500.00,0.00,'','','RAN683XA','','','','2023-02-09 13:17:29',15,'Purchase of Pms ','924','','0000-00-00 00:00:00','928','2023-02-09 13:34:21'),(35,'8','211','2023-02-10',1,1,345.00,35000.00,0.00,0.00,12075000.00,0.00,'','','RAN 441XA','','','','2023-02-10 18:46:06',15,'Purchase of Pms ','924','','0000-00-00 00:00:00','928','2023-02-12 08:11:25'),(36,'8','211','2023-02-17',1,1,340.00,28800.00,0.00,0.00,9792000.00,0.00,'','','Nsr56zq','','','','2023-02-17 21:53:00',15,'purchase of pms ','924','','0000-00-00 00:00:00','928','2023-02-17 23:10:45'),(37,'8','211','2023-02-24',1,1,300.00,32850.00,0.00,0.00,9855000.00,0.00,'','','RAN869XA','','','','2023-02-24 09:42:46',15,'PURCHASE OF PMS ','924','','0000-00-00 00:00:00','928','2023-02-24 10:04:36'),(38,'8','211','2023-02-26',1,1,300.00,18000.00,0.00,0.00,5400000.00,0.00,'','','NSR435ZS','','','','2023-02-26 21:23:39',15,'Purchase of pms ','924','','0000-00-00 00:00:00','928','2023-02-26 21:28:09'),(39,'8','211','2023-02-28',1,1,300.00,31500.00,0.00,0.00,9450000.00,0.00,'','','RAN441XA','','','','2023-02-28 13:33:12',15,'Purchase of pms ','924','','0000-00-00 00:00:00','928','2023-03-01 16:05:58'),(40,'8','211','2023-03-04',1,1,300.00,45000.00,0.00,0.00,13500000.00,0.00,'','','RSH369ZA','','','','2023-03-04 22:10:32',15,'purchase of pms ','924','','0000-00-00 00:00:00','928','2023-03-04 22:16:12'),(41,'8','211','2023-03-07',1,1,300.00,14950.00,0.00,0.00,4485000.00,0.00,'','','WDL813XA','','','','2023-03-07 22:43:19',15,'Purchase of pms ','924','','0000-00-00 00:00:00','928','2023-03-07 22:50:29'),(42,'8','211','2023-03-11',1,1,300.00,16800.00,0.00,0.00,5040000.00,0.00,'','','BCH424XA','','','','2023-03-11 22:01:58',15,'PURCHASE OF PMS ','924','','0000-00-00 00:00:00','928','2023-03-12 10:40:20'),(44,'8','211','2023-03-18',1,1,300.00,16000.00,0.00,0.00,4800000.00,0.00,'','','NSR572XA','','','','2023-03-18 00:14:12',15,'purchase of pms ','924','','0000-00-00 00:00:00','928','2023-03-18 11:58:59');
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_payments`
--

DROP TABLE IF EXISTS `purchases_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `supplier_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`supplier_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=178 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_payments`
--

LOCK TABLES `purchases_payments` WRITE;
/*!40000 ALTER TABLE `purchases_payments` DISABLE KEYS */;
INSERT INTO `purchases_payments` VALUES (1,'8','211','2022-08-10',1,'1','','5',462460.00,'1','','','6','Gujungu station','1',462462.85,'2022-08-10 22:29:16',5,'Payment Receipt by tazara','924','','0000-00-00 00:00:00','928','2022-08-11 14:21:48'),(2,'8','211','2022-08-11',1,'2','','5',866000.00,'2','','','6','Gujungu station','2',865957.65,'2022-08-11 19:13:03',5,'Payment Receipt by tazara1','924','','0000-00-00 00:00:00','928','2022-08-11 20:24:26'),(3,'8','211','2022-08-12',1,'3','','5',934420.00,'3','','','6','Gujungu station','3',934420.10,'2022-08-12 23:49:47',5,'Payment receipt by gujungu','924','','0000-00-00 00:00:00','928','2022-08-15 20:11:53'),(4,'8','211','2022-08-14',1,'5','','10',777260.00,'5','','','6','Gujungu station','5',777268.00,'2022-08-14 20:25:39',5,'Payment Receipt by tazara1','924','','0000-00-00 00:00:00','928','2022-08-15 20:12:10'),(5,'8','211','2022-08-16',1,'7','','5',682165.00,'7','','','6','Gujungu station','7',682167.05,'2022-08-16 13:57:48',5,'Payment Receipt by gujungu','924','','0000-00-00 00:00:00','928','2022-08-16 20:35:01'),(6,'8','211','2022-08-21',1,'6','','10',2483150.00,'6','','','6','Gujungu station','6',2483150.00,'2022-08-21 12:14:03',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-22 12:11:15'),(7,'8','211','2022-08-21',1,'7','','5',682165.00,'7','','','6','Gujungu station','7',682167.05,'2022-08-21 12:17:53',2,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-22 11:29:11'),(8,'8','211','2022-08-21',1,'8','','5',949205.00,'8','','','6','Gujungu station','8',949204.71,'2022-08-21 12:21:32',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-22 11:29:40'),(9,'8','211','2022-08-21',1,'9','','10',621150.00,'9','','','6','Gujungu station','9',621050.00,'2022-08-21 12:24:07',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-22 12:12:41'),(10,'8','211','2022-08-21',1,'10','','5',553700.00,'10','','','6','Gujungu station','10',553698.09,'2022-08-21 12:26:02',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-22 12:15:12'),(11,'8','211','2022-08-21',1,'11','','10',509750.00,'11','','','6','Gujungu station','11',553698.09,'2022-08-21 12:28:42',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-22 18:34:24'),(12,'8','211','2022-08-21',1,'12','','10',733100.00,'12','','','6','Gujungu station','12',733096.71,'2022-08-21 12:30:00',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-22 12:16:14'),(13,'8','211','2022-08-22',1,'13','','10',1980900.00,'13','','','6','Gujungu station','13',1980900.00,'2022-08-22 08:19:04',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-22 12:16:42'),(14,'8','211','2022-08-12',1,'04','','5',1104630.00,'04','','','6','Gujungu station','04',1104633.45,'2022-08-23 10:51:11',5,'Payment Receipt by gujungu station','924','467','2022-08-23 13:49:25','928','2022-08-24 00:15:53'),(15,'8','211','2022-08-24',1,'15','','10',639100.00,'15','','','6','Gujungu station','15',639100.00,'2022-08-24 19:44:23',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-27 10:13:13'),(16,'8','211','2022-08-25',1,'16','','10',645825.00,'16','','','6','Gujungu station','16',645826.35,'2022-08-25 18:05:26',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-27 09:20:08'),(17,'8','211','2022-08-26',1,'17','','5',658710.00,'17','','','6','Gujungu station','17',658573.50,'2022-08-26 10:00:17',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-27 09:08:29'),(18,'8','211','2022-08-27',1,'18','','10',667700.00,'18','','','6','Gujungu station','18',667703.40,'2022-08-27 08:22:41',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-27 09:07:37'),(19,'8','211','2022-08-28',1,'19','','10',688710.00,'19','','','6','Gujungu station','19',688708.80,'2022-08-28 10:21:47',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-29 20:21:36'),(20,'8','211','2022-08-29',1,'20','','10',1655770.00,'20','','','6','Gujungu station','20',1655768.40,'2022-08-29 09:20:02',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-08-29 20:21:54'),(21,'8','211','2022-08-30',1,'21','','10',901780.00,'21','','','6','Gujungu station','21',901806.75,'2022-08-30 14:14:25',5,'Payment Receipt by gujungu','924','','0000-00-00 00:00:00','928','2022-08-31 15:19:07'),(22,'8','211','2022-08-31',1,'22','','10',885780.00,'22','','','6','Gujungu station','22',885781.65,'2022-08-31 07:39:39',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-02 15:49:31'),(23,'8','211','2022-09-02',1,'23','','10',700695.00,'23','','','6','Gujungu station','23',700695.55,'2022-09-02 12:44:32',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','467','2022-09-09 17:32:40'),(24,'8','211','2022-09-02',1,'24','','10',617910.00,'24','','','6','Gujungu station','24',617908.20,'2022-09-02 12:45:52',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-02 15:49:46'),(25,'8','211','2022-09-03',1,'25','','10',749090.00,'25','','','6','Gujungu station','25',749090.55,'2022-09-03 07:50:21',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-05 18:17:51'),(26,'8','211','2022-09-04',1,'26','','10',889900.00,'26','','','6','Gujungu station','26',889902.00,'2022-09-04 10:17:49',5,'Payment Receipt by gujungu','924','','0000-00-00 00:00:00','928','2022-09-05 18:17:32'),(27,'8','211','2022-09-05',1,'27','','10',1770080.00,'27','','','6','Gujungu station','27',1770083.25,'2022-09-05 09:10:03',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-05 18:17:16'),(28,'8','211','2022-09-06',1,'28','','5',768445.00,'28','','','6','Gujungu station','28',768444.30,'2022-09-06 08:46:00',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-06 16:21:32'),(29,'8','211','2022-09-07',1,'29','','5',756260.00,'29','','','6','Gujungu station','29',756258.90,'2022-09-07 08:39:50',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-07 17:33:16'),(30,'8','211','2022-09-08',1,'30','','5',710705.00,'30','','','6','Gujungu station','30',710704.50,'2022-09-08 09:42:47',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-08 14:11:27'),(31,'8','211','2022-09-09',1,'31','','5',885945.00,'31','','','6','Gujungu station','31',885943.40,'2022-09-09 08:58:22',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-10 23:50:51'),(32,'8','211','2022-09-10',1,'32','','10',918410.00,'32','','','6','Gujungu station','32',918408.70,'2022-09-10 11:03:09',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-12 11:36:43'),(33,'8','211','2022-09-11',1,'33','','10',953730.00,'33','','','6','Gujungu station','33',953731.60,'2022-09-11 09:11:11',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-12 11:37:01'),(34,'8','211','2022-09-12',1,'34','','10',1965070.00,'34','','','6','Gujungu station','34',1965071.20,'2022-09-12 09:32:18',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-12 11:37:21'),(35,'8','211','2022-09-13',1,'35','','5',826655.00,'35','','','6','Gujungu station','35',826655.80,'2022-09-13 09:12:38',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-13 16:17:42'),(36,'8','211','2022-09-14',1,'36','','10',955390.00,'36','','','6','Gujungu station','36',955392.20,'2022-09-14 09:23:42',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-20 13:28:31'),(37,'8','211','2022-09-15',1,'37','','10',677040.00,'37','','','6','Gujungu station','37',677038.40,'2022-09-15 08:34:52',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-20 13:30:33'),(38,'8','211','2022-09-16',1,'38','','5',808955.00,'38','','','6','Gujungu station','38',808953.50,'2022-09-16 08:30:14',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-20 13:30:48'),(39,'8','211','2022-09-17',1,'39','','10',703070.00,'39','','','6','Gujungu station','39',703072.20,'2022-09-17 08:43:26',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-20 13:31:15'),(40,'8','211','2022-09-18',1,'40','','10',712970.00,'40','','','6','Gujungu station','40',712969.30,'2022-09-18 09:32:43',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-20 13:31:35'),(41,'8','211','2022-09-20',1,'41','','10',1622295.00,'41','','','6','Gujungu station','41',1622275.10,'2022-09-20 09:47:46',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-20 13:32:05'),(43,'8','211','2022-09-20',1,'42','','5',616760.00,'42','','','6','42','42',616671.60,'2022-09-20 13:40:35',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-21 13:49:50'),(44,'8','211','2022-09-21',1,'43','','5',704090.00,'43','','','6','Gujungu station','43',704088.70,'2022-09-21 09:25:47',5,'Payment received by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-21 14:00:15'),(45,'8','211','2022-09-22',1,'44','','10',849015.00,'44','','','6','Gujungu station','44',849016.90,'2022-09-22 08:36:44',5,'Payment Receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-26 16:36:54'),(46,'8','211','2022-09-23',1,'45','','10',576745.00,'45','','','6','Gujungu station','45',576745.00,'2022-09-23 08:29:45',5,'Payment Received by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-26 16:37:22'),(47,'8','211','2022-09-24',1,'46','','10',676780.00,'46','','','6','Gujungu station','46',676781.90,'2022-09-24 07:46:26',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-26 16:37:39'),(48,'8','211','2022-09-25',1,'47','','10',684800.00,'47','','','6','Gujungu station','47',684801.80,'2022-09-25 10:12:05',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-26 16:37:52'),(49,'8','211','2022-09-26',1,'48','','10',1933080.00,'48','','','6','Gujungu station','48',1933080.90,'2022-09-26 09:11:01',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-26 16:38:11'),(50,'8','211','2022-09-27',1,'49','','5',863490.00,'49','','','6','Gujungu station','49',863489.20,'2022-09-27 08:14:11',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-27 16:33:42'),(51,'8','211','2022-09-28',1,'50','','5',838370.00,'50','','','6','Gujungu station','50',838369.30,'2022-09-28 08:28:08',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-09-29 13:51:57'),(52,'8','211','2022-09-29',1,'51','','10',1070420.00,'51','','','6','Gujungu station','51',1070422.00,'2022-09-29 07:21:19',5,'Payment receipt by gujungu','924','','0000-00-00 00:00:00','928','2022-10-03 02:02:17'),(53,'8','211','2022-10-01',1,'53','','10',884700.00,'53','','','6','Gujungu station','53',884700.80,'2022-10-01 07:04:36',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-03 22:52:22'),(54,'8','211','2022-10-02',1,'54','','5',780365.00,'54','','','7','Gujungu station','54',780362.30,'2022-10-02 08:56:17',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-03 22:52:49'),(55,'8','211','2022-10-03',1,'52','','10',931165.00,'52','','','6','Gujungu station','52',931163.40,'2022-10-03 09:11:51',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-03 22:53:32'),(56,'8','211','2022-10-03',1,'55','','10',1804670.00,'55','','','6','Gujungu station','55',1804671.30,'2022-10-03 09:15:45',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-03 22:54:07'),(57,'8','211','2022-10-03',1,'56','','10',491925.00,'56','','','6','Gujungu station','56',491925.20,'2022-10-03 13:27:53',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-08 23:06:50'),(58,'8','211','2022-10-04',1,'01','','5',346300.00,'01','','','6','Gujungu station','100422',346300.00,'2022-10-04 08:52:53',5,'Payment receipt by gujungu','924','467','2022-10-09 10:38:31','928','2022-10-09 10:39:43'),(59,'8','211','2022-10-05',1,'58','','5',876735.00,'58','','','6','Gujungu station','58',0.00,'2022-10-05 10:11:39',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-07 15:02:50'),(60,'8','211','2022-10-06',1,'59','','10',1179625.00,'59','','','6','Gujungu station','59',1179624.50,'2022-10-06 08:36:11',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-12 16:47:14'),(61,'8','211','2022-10-08',1,'60','','10',2005860.00,'60','','','6','Gujungu station','60',2005858.50,'2022-10-08 10:36:18',5,'Payment received by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-10 16:28:04'),(62,'8','211','2022-10-09',1,'61','','5',3535805.00,'61','','','6','Gujungu station','61',3535803.25,'2022-10-09 10:45:05',5,'Payment received by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-12 16:38:06'),(63,'8','211','2022-10-10',1,'62','','5',1205855.00,'62','','','6','Gujungu station','62',1205854.51,'2022-10-10 08:44:16',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-17 12:16:53'),(64,'8','211','2022-10-11',1,'63','','5',2757780.00,'63','','','6','Gujungu station','63',2757781.39,'2022-10-11 10:53:35',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-12 16:37:10'),(65,'8','211','2022-10-12',1,'64','','5',1600545.00,'64','','','6','Gujungu station','64',1600545.84,'2022-10-12 13:45:30',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-17 12:17:19'),(66,'8','211','2022-10-16',1,'65','','5',1265315.00,'65','','','6','Gujungu station','65',1265314.50,'2022-10-16 13:14:22',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-17 12:17:39'),(67,'8','211','2022-10-17',1,'66','','5',5000000.00,'66','','','6','Gujungu station','66',5290067.25,'2022-10-17 10:41:46',5,'Payment receipt by gujungu station','924','928','2022-10-24 16:21:00','928','2022-10-24 16:21:16'),(68,'8','211','2022-10-18',1,'67','','5',818435.00,'67','','','6','Gujungu station','67',818435.25,'2022-10-18 09:44:21',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-18 13:28:37'),(69,'8','211','2022-10-22',1,'68','','5',2848136.00,'68','','','6','Gujungu station','68',2848136.55,'2022-10-22 08:49:26',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-24 16:21:54'),(70,'8','211','2022-10-23',1,'69','','5',2675895.00,'69','','','6','Gujungu station','69',2675896.80,'2022-10-23 09:24:43',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-26 13:40:12'),(71,'8','211','2022-10-24',1,'70','','5',2095055.00,'70','','','6','Gujungu station','70',2095053.60,'2022-10-24 08:50:30',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-26 13:39:39'),(72,'8','211','2022-10-26',1,'71','','5',1736110.00,'71','','','6','Gujungu station','71',1736107.20,'2022-10-26 09:45:24',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-27 21:28:15'),(73,'8','211','2022-10-27',1,'72','','5',2623580.00,'72','','','6','Gujungu station','72',2623580.00,'2022-10-27 09:13:15',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-27 21:29:24'),(74,'8','211','2022-10-28',1,'73','','5',2683810.00,'73','','','6','Gujungu station','73',2683807.50,'2022-10-28 09:02:51',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-10-29 17:56:43'),(75,'8','211','2022-10-29',1,'74','','5',464010.00,'74','','','6','Gujungu station','74',464010.00,'2022-10-29 09:13:22',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-03 12:56:38'),(76,'8','211','2022-11-06',1,'75','','5',1458300.00,'75','','','6','Gujungu station','75',1458299.10,'2022-11-06 11:07:31',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-06 17:34:12'),(77,'8','211','2022-11-07',1,'76','','5',4861435.00,'76','','','6','Gujungu station','76',4861437.30,'2022-11-07 08:35:42',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-23 16:29:18'),(78,'8','211','2022-11-08',1,'77','','5',1840350.00,'77','','','6','Gujungu station','77',1840350.30,'2022-11-08 08:53:25',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-09 12:03:29'),(79,'8','211','2022-11-09',1,'78','','5',1804670.00,'78','','','6','Gujungu station','78',1811986.65,'2022-11-09 10:35:06',5,'Payment receipt by gujungu station','924','928','2022-12-11 22:28:55','928','2022-12-11 22:30:42'),(80,'8','211','2022-11-10',1,'79','','5',1946970.00,'79','','','6','Gujungu station','79',1946970.90,'2022-11-10 08:10:03',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-25 11:49:14'),(81,'8','211','2022-11-11',1,'80','','5',2171690.00,'80','','','6','Gujungu station','80',2171692.20,'2022-11-11 11:00:06',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-14 13:44:33'),(82,'8','211','2022-11-12',1,'81','','5',2132350.00,'81','','','6','Gujungu station','81',2132350.80,'2022-11-12 09:49:11',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-15 17:25:26'),(83,'8','211','2022-11-13',1,'82','','5',530850.00,'82','','','6','Gujungu station','82',530848.80,'2022-11-13 08:51:29',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-06 17:33:56'),(84,'8','211','2022-11-16',1,'83','','5',845705.00,'83','','','6','Gujungu station','83',845704.95,'2022-11-16 15:58:32',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-17 13:12:11'),(85,'8','211','2022-11-17',1,'84','','5',2133290.00,'84','','','6','Gujungu station','84',2133289.20,'2022-11-17 08:36:20',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-17 13:12:27'),(86,'8','211','2022-11-18',1,'85','','5',2185370.00,'85','','','6','Gujungu station','85',2185372.95,'2022-11-18 09:53:06',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-21 14:40:18'),(87,'8','211','2022-11-19',1,'86','','5',2139400.00,'86','','','6','Gujungu station','86',2139401.55,'2022-11-19 09:45:24',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-21 17:03:03'),(88,'8','211','2022-11-20',1,'87','','5',1096125.00,'87','','','6','Gujungu station','87',1096127.70,'2022-11-20 07:59:57',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-21 17:02:32'),(89,'8','211','2022-11-21',1,'88','','5',4457015.00,'88','','','6','Gujungu station','88',4457013.60,'2022-11-21 15:14:27',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-23 16:09:41'),(90,'8','211','2022-11-28',1,'89','','5',4161860.00,'89','','','6','Gujungu station','89',4161861.60,'2022-11-28 10:52:13',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-28 17:14:41'),(91,'8','211','2022-11-29',1,'90','','5',2524940.00,'90','','','6','Gujungu station','90',2524940.60,'2022-11-29 10:50:18',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-11-29 17:36:01'),(92,'8','211','2022-11-30',1,'91','','5',2477535.00,'91','','','6','Gujungu station','91',2477534.80,'2022-11-30 13:09:52',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-01 12:17:01'),(93,'8','211','2022-12-01',1,'92','','5',2514955.00,'92','','','6','Gujungu station','92',2514954.00,'2022-12-01 09:55:38',5,'Payment receipt by gujungu','924','928','2022-12-01 12:18:00','928','2022-12-01 12:18:25'),(94,'8','211','2022-12-08',1,'93','','5',3124665.00,'93','','','6','Gujungu station','93',3124664.10,'2022-12-08 07:20:14',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-10 07:45:20'),(95,'8','211','2022-12-08',1,'94','','5',1408665.00,'94','','','6','Gujungu station','94',1408661.34,'2022-12-08 09:44:52',5,'Payment receipt by gujungu station','924','928','2022-12-10 07:46:54','928','2022-12-10 07:47:18'),(96,'8','211','2022-12-09',1,'95','','5',975075.00,'95','','','6','Gujungu station','95',1021478.60,'2022-12-09 21:09:04',5,'Payment receipt by gujungu station','924','928','2022-12-15 23:13:05','928','2022-12-15 23:13:27'),(97,'8','211','2022-12-10',1,'96','','5',2847000.00,'96','','','6','Gujungu station','96',2846999.60,'2022-12-10 09:41:26',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-12 16:29:51'),(98,'8','211','2022-12-11',1,'97','','5',3799150.00,'97','','','6','Gujungu station','97',3799150.80,'2022-12-11 08:56:12',5,'','924','','0000-00-00 00:00:00','928','2022-12-12 16:29:12'),(99,'8','211','2022-12-12',1,'98','','5',7718330.00,'98','','','6','Gujungu station','98',7718331.60,'2022-12-12 22:53:00',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-16 16:23:21'),(100,'8','211','2022-12-13',1,'99','','5',3341860.00,'99','','','6','Gujungu station','99',3341860.20,'2022-12-13 08:31:26',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-13 16:42:26'),(101,'8','211','2022-12-14',1,'100','','5',2332270.00,'100','','','6','Gujungu station','100',2332269.45,'2022-12-14 10:00:25',5,'Payment receipt by gujungu','924','','0000-00-00 00:00:00','928','2022-12-14 14:33:55'),(102,'8','211','2022-12-15',1,'101','','5',2723120.00,'101','','','6','Gujungu station','101',2723118.30,'2022-12-15 10:12:33',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-19 13:52:28'),(103,'8','211','2022-12-19',1,'102','','5',5515475.00,'102','','','6','Gujungu station','102',5515574.40,'2022-12-19 17:26:00',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-23 15:41:55'),(104,'8','211','2022-12-20',1,'103','','5',2182825.00,'103','','','6','Gujungu station','103',2182824.00,'2022-12-20 10:26:36',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-20 17:48:31'),(105,'8','211','2022-12-21',1,'104','','5',1768595.00,'104','','','6','Gujungu station','104',1768595.85,'2022-12-21 08:35:08',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-23 15:53:12'),(106,'8','211','2022-12-22',1,'105','','5',2005685.00,'105','','','6','Gujungu station','105',2005686.90,'2022-12-22 10:24:56',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2022-12-25 03:38:43'),(107,'8','211','2022-12-23',1,'107','','5',1683230.00,'107','','','6','Gujungu station','107',1685224.80,'2022-12-23 08:13:28',5,'Payment receipt by gujungu station','924','928','2022-12-27 09:36:43','928','2022-12-27 09:38:56'),(108,'8','211','2022-12-24',1,'108','','5',812725.00,'108','','','6','Gujungu station','108',810060.30,'2022-12-24 09:24:28',5,'Payment receipt by gujungu station','924','928','2022-12-27 09:39:37','928','2022-12-27 09:40:11'),(109,'8','211','2022-12-26',1,'109','','5',5728915.00,'109','','','6','Gujungu station','109',5728915.65,'2022-12-26 12:03:04',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','465','2022-12-30 17:59:26'),(110,'8','211','2022-12-27',1,'110','','5',2496195.00,'110','','','6','Gujungu station','110',2496196.25,'2022-12-27 08:24:48',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-02 00:33:54'),(111,'8','211','2022-12-28',1,'111','','5',1454020.00,'111','','','6','Gujungu station','111',1454020.40,'2022-12-28 22:26:05',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-02 00:34:21'),(112,'8','211','2022-12-30',1,'112','','5',1739840.00,'112','','','6','Gujungu station','112',1739838.00,'2022-12-30 21:14:30',5,'Payment receipt by gujungu station','924','928','2023-01-02 00:37:45','928','2023-01-02 00:38:12'),(113,'8','211','2022-12-31',1,'113','','5',1384440.00,'113','','','6','Gujungu station','113',1384440.00,'2022-12-31 08:46:30',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-02 00:38:43'),(114,'8','211','2023-01-01',1,'114','','5',1887105.00,'114','','','6','Gujungu station','114',1887105.00,'2023-01-01 08:33:46',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-04 14:39:12'),(115,'8','211','2023-01-02',1,'115','','5',4935740.00,'115','','','6','Gujungu station','115',4935738.00,'2023-01-02 08:48:51',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-04 17:56:33'),(116,'8','211','2023-01-03',1,'116','','5',2021590.00,'116','','','6','Gujungu station','116',2021592.00,'2023-01-03 16:12:30',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-04 14:41:11'),(117,'8','211','2023-01-06',1,'117','','5',1374825.00,'117','','','6','Gujungu station','117',1374825.00,'2023-01-06 12:11:20',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-07 18:11:11'),(118,'8','211','2023-01-07',1,'118','','5',1356785.00,'118','','','6','Gujungu station','118',1356786.00,'2023-01-07 21:10:15',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-11 17:20:48'),(119,'8','211','2023-01-08',1,'119','','5',1734460.00,'119','','','6','Gujungu station','119',1734462.00,'2023-01-08 10:05:51',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-11 17:21:07'),(120,'8','211','2023-01-09',1,'120','','5',5022880.00,'120','','','7','Gujungu station','120',5022882.00,'2023-01-09 09:21:08',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-11 17:21:25'),(121,'8','211','2023-01-10',1,'121','','5',649725.00,'121','','','6','Gujungu station','121',649725.00,'2023-01-10 08:51:20',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-11 17:22:18'),(122,'8','211','2023-01-13',1,'122','','5',1571885.00,'122','','','6','Gujungu station','122',1571844.00,'2023-01-13 22:22:42',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-16 18:16:42'),(123,'8','211','2023-01-14',1,'123','','5',1615040.00,'123','','','6','Gujungu station','123',1615038.00,'2023-01-14 08:49:26',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-17 17:29:28'),(124,'8','211','2023-01-15',1,'124','','5',1993785.00,'124','','','6','Gujungu station','124',1993785.00,'2023-01-15 09:25:50',5,'Payment receipt by gujungu station','924','928','2023-01-17 17:32:00','928','2023-01-17 17:32:23'),(125,'8','211','2023-01-16',1,'125','','5',4752335.00,'125','','','6','Gujungu station','125',4751337.00,'2023-01-16 08:36:29',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-16 18:17:18'),(126,'8','211','2023-01-19',1,'126','','5',1965825.00,'126','','','6','Gujungu station','126',1965870.00,'2023-01-19 17:07:04',5,'Payment receipt by gujungu station','924','928','2023-01-21 12:28:35','928','2023-01-21 12:29:00'),(127,'8','211','2023-01-20',1,'127','','5',1844825.00,'127','','','6','Gujungu station','127',1844826.00,'2023-01-20 08:27:16',5,'Payment receipt by gujungu station','924','928','2023-01-21 12:30:26','928','2023-01-21 12:30:46'),(128,'8','211','2023-01-21',1,'128','','5',2118220.00,'128','','','6','Gujungu station','128',2118222.00,'2023-01-21 09:07:14',5,'Payment receipt by gujungu station','924','','0000-00-00 00:00:00','928','2023-01-25 19:39:33'),(129,'8','211','2023-01-22',1,'129','','5',811605.00,'129','','','6','Gujungu station','129',811680.00,'2023-01-22 09:38:13',5,'Payment receipt by gujungu station','924','928','2023-01-25 19:41:39','928','2023-01-25 19:41:58'),(130,'8','211','2023-01-22',1,'130','','5',3702000.00,'130','','','6','Gujungu station','130',3702015.54,'2023-01-22 09:42:57',5,'Payment receipt by gujungu station','924','928','2023-01-29 19:03:25','928','2023-01-29 19:03:42'),(131,'8','211','2023-01-23',1,'131','','5',5234000.00,'131','','','6','Gujungu station','131',5234114.70,'2023-01-23 08:22:17',5,'Payment receipt by gujungu station','924','928','2023-01-27 20:24:59','928','2023-01-27 20:26:26'),(132,'8','211','2023-02-01',1,'133','','5',1315285.00,'133','','','6','Gujungu station','133',1315284.90,'2023-02-01 08:46:00',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-06 17:55:52'),(133,'8','211','2023-02-02',1,'134','','5',2081170.00,'134','','','6','Gujungu station','134',2082168.15,'2023-02-02 09:01:53',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-06 17:56:31'),(134,'8','211','2023-02-03',1,'135','','5',452750.00,'135','','','6','Gujungu station','322023',452750.00,'2023-02-03 11:37:18',5,' Payment Receipt by Gujungu Station POS','924','928','2023-02-09 18:15:42','928','2023-02-09 18:16:08'),(135,'8','211','2023-02-03',1,'136','','5',1442625.00,'136','','','6','Gujungu station','136',1442625.00,'2023-02-03 11:39:59',5,'Payment receipt by gujungu Station ','924','467','2023-02-06 13:30:40','928','2023-02-06 17:59:02'),(136,'8','211','2023-02-04',1,'132','','5',956075.00,'132','','','6','Gujungu station','132',956019.48,'2023-02-04 09:04:01',5,'Payment receipt by gujungu ','924','928','2023-02-06 18:01:23','928','2023-02-06 18:01:49'),(137,'8','211','2023-02-04',1,'137','','10',1357450.00,'137','','','6','Gujungu station','137',1357450.00,'2023-02-04 09:06:42',5,'Payment receipt by gujungu Station pos','924','','0000-00-00 00:00:00','928','2023-02-07 15:22:25'),(138,'8','211','2023-02-05',1,'38','','5',1573290.00,'138','','','6','Gujungu station','138',1660990.00,'2023-02-05 10:22:55',5,'Payment receipt by gujungu Station ','924','928','2023-02-22 13:46:04','928','2023-02-23 09:53:40'),(139,'8','211','2023-02-05',1,'139','','10',340155.00,'139','','','6','Gujungu station','139',0.00,'2023-02-05 10:24:55',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-06 18:04:30'),(140,'8','211','2023-02-07',1,'140','','5',3367620.00,'140','','','6','Gujungu station','140',0.00,'2023-02-07 12:40:34',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-08 14:26:42'),(141,'8','211','2023-02-07',1,'141','','10',1008290.00,'141','','','6','Gujungu station','141',0.00,'2023-02-07 12:41:52',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-07 15:15:51'),(142,'8','211','2023-02-07',1,'142','','5',1180950.00,'142','','','6','Gujungu station','142',1180950.00,'2023-02-07 12:45:37',5,'Payment receipt by gujungu Station ','924','467','2023-02-09 13:40:49','928','2023-02-10 16:55:04'),(143,'8','211','2023-02-07',1,'143','','5',1513190.00,'143','','','6','Gujungu station','010322',1513190.00,'2023-02-07 12:47:03',5,'Payment receipt by gujungu Station ','924','467','2023-02-09 13:40:04','467','2023-02-09 13:40:19'),(144,'8','211','2023-02-08',1,'144','','5',1356815.00,'144','','','6','Gujungu station','144',1356815.00,'2023-02-08 09:24:47',5,'Payment receipt by gujungu Station ','924','467','2023-02-09 13:41:12','928','2023-02-10 16:53:53'),(145,'8','211','2023-02-08',1,'145','','5',1647650.00,'145','','','6','Gujungu station','145',1044150.00,'2023-02-08 09:26:20',0,'Payment receipt by gujungu Station ','924','928','2023-02-17 09:46:15','','0000-00-00 00:00:00'),(146,'8','211','2023-02-09',1,'146','','5',1094175.00,'146','','','6','Gujungu station','146',1094175.00,'2023-02-09 16:37:28',5,'','924','467','2023-02-10 15:57:38','928','2023-02-13 17:53:19'),(147,'8','211','2023-02-09',1,'147','','10',1647650.00,'147','','','6','Gujungu station','147',1647650.00,'2023-02-09 16:40:00',5,'Payment receipt by gujungu ','924','','0000-00-00 00:00:00','928','2023-02-10 16:57:22'),(148,'8','211','2023-02-10',1,'148','','5',1342600.00,'148','','','6','Gujungu station','148',3313838.85,'2023-02-10 18:40:57',5,'Payment receipt by gujungu Station ','924','928','2023-02-13 17:55:00','928','2023-02-13 17:55:16'),(149,'8','211','2023-02-10',1,'149','','5',1970800.00,'149','','','6','Gujungu station','1322023',1970850.00,'2023-02-10 18:42:05',5,'Payment receipt by gujungu ','924','928','2023-02-13 17:57:42','928','2023-02-13 17:57:59'),(150,'8','211','2023-02-12',1,'150','','5',2097515.00,'150','','','6','Gujungu Station ','150',3202414.20,'2023-02-12 22:23:15',5,'payment Receipt by Gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-20 09:15:16'),(151,'8','211','2023-02-12',1,'151','','10',1104900.00,'151','','','6','Gujungu Station ','151',1104900.00,'2023-02-12 22:24:50',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-16 19:02:46'),(152,'8','211','2023-02-12',1,'152','','5',1092470.00,'152','','','6','Gujungu Station ','152',2435068.65,'2023-02-12 22:29:15',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-16 19:04:44'),(153,'8','211','2023-02-12',1,'153','','10',1342600.00,'153','','','6','Gujungu Station ','153',1342600.00,'2023-02-12 22:30:30',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-16 19:05:35'),(154,'8','211','2023-02-13',1,'154','','5',3338635.00,'154','','','6','Gujungu Station ','154',3338635.00,'2023-02-13 08:59:32',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-16 19:06:29'),(155,'8','211','2023-02-13',1,'155','','5',2220100.00,'155','','','6','Gujungu Station ','132023',2220100.00,'2023-02-13 09:00:39',0,'payment receipt by gujungu Station ','924','928','2023-03-03 12:40:52','','0000-00-00 00:00:00'),(156,'8','211','2023-02-14',1,'156','','5',1493165.00,'156','','','6','Gujungu Station ','156',1493165.00,'2023-02-14 08:54:30',0,'payment receipt by gujungu Station ','924','928','2023-03-03 12:40:14','','0000-00-00 00:00:00'),(157,'8','211','2023-02-14',1,'157','','10',1147550.00,'157','','','6','Gujungu Station ','157',1147550.00,'2023-02-14 08:55:31',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-01 16:07:05'),(158,'8','211','2023-02-18',1,'159','','5',1541985.00,'159','','','6','Gujungu Station ','159',1541985.00,'2023-02-18 21:30:36',5,'payment receipt by gujungu ','924','','0000-00-00 00:00:00','928','2023-02-21 17:51:40'),(159,'8','211','2023-02-19',1,'160','','5',1742400.00,'160','','','6','Gujungu Station ','160',1742398.00,'2023-02-19 22:53:35',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-21 17:50:18'),(160,'8','211','2023-02-20',1,'162','','5',4704580.00,'162','','','6','Gujungu Station ','162',4704580.00,'2023-02-20 15:39:45',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-02-21 17:34:48'),(161,'8','211','2023-02-21',1,'163','','5',1803775.00,'163','','','6','Gujungu Station ','163',1803774.80,'2023-02-21 14:35:59',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-02 13:23:42'),(162,'8','211','2023-02-25',1,'164','','5',2742145.00,'164','','','6','Gujungu Station ','164',2742147.00,'2023-02-25 10:59:54',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-02 13:24:01'),(163,'8','211','2023-02-27',1,'165','','5',4264780.00,'165','','','6','Gujungu Station ','165',5702841.00,'2023-02-27 17:34:48',5,'Payment receipt by gujungu Station ','924','467','2023-03-02 17:17:03','928','2023-03-05 07:27:28'),(164,'8','211','2023-02-28',1,'166','','5',4264780.00,'166','','','6','Gujungu Station ','166',4264780.00,'2023-02-28 09:06:20',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-02 13:24:39'),(165,'8','211','2023-03-02',1,'167','','5',1438060.00,'167','','','6','Gujungu Station ','167',1438060.00,'2023-03-02 17:27:27',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-08 08:35:38'),(166,'8','211','2023-03-02',1,'168','','5',3774065.00,'168','','','6','Gujungu Station ','168',3774066.00,'2023-03-02 17:31:35',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-05 07:26:39'),(167,'8','211','2023-03-02',1,'170','','5',3667450.00,'170','','','6','Gujungu Station ','170',3667450.00,'2023-03-02 17:41:22',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-05 07:26:08'),(169,'8','211','2023-03-04',1,'172','','5',2358735.00,'172','','','6','Gujungu Station ','172',2358735.00,'2023-03-04 08:32:12',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-05 07:24:50'),(170,'8','211','2023-03-05',1,'173','','5',3331100.00,'173','','','6','Gujungu Station ','173',3331101.00,'2023-03-05 11:43:47',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-08 08:36:08'),(171,'8','211','2023-03-06',1,'174','','5',6023160.00,'174','','','6','Gujungu Station ','174',6023160.00,'2023-03-06 09:34:12',5,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-08 08:36:49'),(172,'8','211','2023-03-07',1,'175','','5',4220085.00,'175','','','6','Gujungu Station ','175',4220085.00,'2023-03-07 09:17:23',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-08 08:37:39'),(173,'8','211','2023-03-08',1,'176','','5',3022200.00,'176','','','6','Gujungu Station ','176',3022200.00,'2023-03-08 09:37:34',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-09 15:04:08'),(174,'8','211','2023-03-09',1,'177','','5',1523140.00,'177','','','6','Gujungu Station ','177',1523139.00,'2023-03-09 11:10:08',0,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(175,'8','211','2023-03-13',1,'178','','5',5057010.00,'178','','','6','Gujungu Station ','178',5057010.00,'2023-03-13 22:56:09',5,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','928','2023-03-15 13:59:45'),(176,'8','211','2023-03-18',1,'179','','5',3359735.00,'179','','','6','Gujungu Station ','179',3359736.00,'2023-03-18 12:55:10',0,'payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(177,'8','211','2023-03-20',1,'180','','5',1475590.00,'180','','','6','Gujungu Station ','180',1475589.00,'2023-03-20 13:42:13',0,'Payment receipt by gujungu Station ','924','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `purchases_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases_receptions`
--

DROP TABLE IF EXISTS `purchases_receptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases_receptions` (
  `bridge_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `purchase_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `loadingdate` datetime NOT NULL,
  `loadingpoint` varchar(100) DEFAULT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `received` decimal(20,2) NOT NULL,
  `distributed` decimal(20,2) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `vessel` varchar(50) NOT NULL,
  `drivername` varchar(30) NOT NULL,
  `driverphone` varchar(30) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`bridge_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`supplier_id`,`loadingdate`,`quantity`,`waybill`,`meterno`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`purchase_id`),
  KEY `truck_id` (`tank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases_receptions`
--

LOCK TABLES `purchases_receptions` WRITE;
/*!40000 ALTER TABLE `purchases_receptions` DISABLE KEYS */;
INSERT INTO `purchases_receptions` VALUES (1,'8',1,'211',1,1,'2022-08-10 00:00:00','AARano',27750.00,27750.00,0.00,'01','','1','RAN683XA','Shamsu','09024025840','Delivery of PM\'s',5,'2022-08-10 23:27:57','924','0000-00-00 00:00:00','','2022-08-11 14:16:31','928'),(3,'8',2,'211',1,1,'2022-08-13 00:00:00','AARano',33000.00,33000.00,0.00,'02','','1','BCH424XA','Aranma','07038288822','Delivery of PM\'s',5,'2022-08-13 10:01:17','924','0000-00-00 00:00:00','','2022-08-13 11:35:11','924'),(4,'8',3,'211',1,1,'2022-08-24 00:00:00','AARano',50000.00,50000.00,0.00,'03','','1','RAN33XF','Abdullahi','09066536097','Delivery of PM\'s',5,'2022-08-24 13:14:54','924','0000-00-00 00:00:00','','2022-08-24 13:47:29','928'),(5,'8',4,'211',1,1,'2022-09-01 00:00:00','AARano',32000.00,32000.00,0.00,'03','','1','NSR 435 ZS','A.Gambo','07033279868','Delivery of PM\'s',5,'2022-09-01 10:18:16','924','0000-00-00 00:00:00','','2022-09-01 12:02:31','928'),(6,'8',5,'211',1,1,'2022-09-10 00:00:00','AARano',50000.00,50000.00,0.00,'00035','','1','BCH428XA','RILWAN','08034997784','Delivery of PM\'s',5,'2022-09-10 12:59:59','924','0000-00-00 00:00:00','','2022-09-10 23:50:29','928'),(7,'8',6,'211',1,1,'2022-09-17 00:00:00','AARano',33000.00,33200.00,0.00,'00035','','1','GML594XA','KABIRU','08147774782','Delivery of PM\'s',5,'2022-09-17 20:20:40','924','0000-00-00 00:00:00','','2022-09-20 13:21:47','928'),(8,'8',7,'211',1,1,'2022-09-24 00:00:00','AARano',17000.00,17100.00,0.00,'00036','','1','RAN689XA','USMAN','07066507909','Delivery of PM\'s',5,'2022-09-24 07:39:37','924','0000-00-00 00:00:00','','2022-09-25 14:24:12','928'),(9,'8',8,'211',1,1,'2022-09-29 00:00:00','AARano',32000.00,32000.00,0.00,'00036','','1','WDL813','MEDABAN -DABAN','08065000870','Delivery of PM\'s',5,'2022-09-29 07:15:21','924','0000-00-00 00:00:00','','2022-09-29 13:51:27','928'),(10,'8',9,'211',1,1,'2022-10-07 00:00:00','AA RANO',33000.00,33000.00,0.00,'00049','','1','RAN32XF','ISAH','07063462050','Purchase of pms',5,'2022-10-07 17:57:00','924','0000-00-00 00:00:00','','2022-10-08 10:27:39','928'),(11,'8',10,'211',1,1,'2022-10-10 00:00:00','AA RANO',21000.00,21250.00,0.00,'00555','','1','Nsr56ZQ','Usaini','07037469603','Purchase of pms',5,'2022-10-10 16:22:09','924','0000-00-00 00:00:00','','2022-10-11 09:11:17','928'),(13,'8',12,'211',1,1,'2022-10-16 00:00:00','AA RANO',32800.00,32800.00,0.00,'00558','','1','BCH424XA','ARANMA','07038288822','Purchase of pms',5,'2022-10-16 12:48:39','924','0000-00-00 00:00:00','','2022-10-16 12:49:36','928'),(14,'8',13,'211',1,1,'2022-10-22 00:00:00','AA RANO',32050.00,32050.00,0.00,'00558','','1','NSr435ZS','A. GAMBO','07033279868','Purchase of pms',5,'2022-10-22 08:35:30','924','0000-00-00 00:00:00','','2022-10-22 08:41:18','928'),(15,'8',14,'211',1,1,'2022-10-26 00:00:00','AA RANO',30350.00,30350.00,0.00,'00567','','1','Nsr57ZQ','ALI','08022756280','Purchase of pms',5,'2022-10-26 09:33:56','924','0000-00-00 00:00:00','','2022-10-26 09:35:04','928'),(16,'8',15,'211',1,1,'2022-11-06 00:00:00','AA RANO',33000.00,33000.00,0.00,'00049','','1','RAN32XF','ISAH','07063462050','Purchase of pms',5,'2022-11-06 09:37:17','924','0000-00-00 00:00:00','','2022-11-06 10:25:51','928'),(17,'8',16,'211',1,1,'2022-11-09 00:00:00','AA RANO',33100.00,33100.00,0.00,'00579','','1','GML594XA','KABIRU','08147774782','Purchase of pms',5,'2022-11-09 08:38:14','924','0000-00-00 00:00:00','','2022-11-09 09:31:49','928'),(18,'8',17,'211',1,1,'2022-11-16 00:00:00','AA RANO',33000.00,33000.00,0.00,'00011','','1','DKA705ZP','WANZAN','07067180685','Purchase of pms',5,'2022-11-16 09:16:53','924','0000-00-00 00:00:00','','2022-11-16 14:10:40','928'),(19,'8',18,'211',1,1,'2022-11-21 00:00:00','AA RANO',17000.00,17000.00,0.00,'0012','','1','RAN33XF','Abdullahi','09066536097','Purchase of pms',5,'2022-11-21 08:46:38','924','0000-00-00 00:00:00','','2022-11-21 09:21:38','928'),(20,'8',19,'211',1,1,'2022-11-28 00:00:00','AA RANO',45000.00,45000.00,0.00,'0003','','1','KUJ983XU','Umar','08037372750','Purchase of pms',5,'2022-11-28 10:20:09','924','0000-00-00 00:00:00','','2022-11-28 10:26:58','928'),(21,'8',20,'211',1,1,'2022-12-07 00:00:00','AA RANO',17000.00,17000.00,0.00,'00989','','1','GML594XA','Kaabiru','08147774782','Purchase of pms',5,'2022-12-07 09:27:25','924','0000-00-00 00:00:00','','2022-12-07 19:54:32','928'),(22,'8',22,'211',1,1,'2022-12-09 00:00:00','AA RANO',32900.00,32900.00,0.00,'','','1','BCH428XA','Lirwan yali','08034997784','Purchase of pms',5,'2022-12-09 11:59:52','924','0000-00-00 00:00:00','','2022-12-09 14:41:00','928'),(23,'8',23,'211',1,1,'2022-12-12 00:00:00','AA RANO',44900.00,44900.00,0.00,'','','1','Trn535XA','Aminu','08036408436','Purchase of pms',5,'2022-12-12 18:40:29','924','0000-00-00 00:00:00','','2022-12-12 20:18:55','928'),(24,'8',24,'211',1,1,'2022-12-19 00:00:00','AA RANO',44700.00,44700.00,0.00,'','','1','ABC06ZU','Muhd shehu','08032525104','',5,'2022-12-19 12:21:25','924','0000-00-00 00:00:00','','2022-12-19 13:12:05','928'),(25,'8',26,'211',1,1,'2022-12-26 00:00:00','AA RANO',32000.00,32000.00,0.00,'','','1','NSR435ZS','A. GAMBO','07033279868','Purchase of pms',5,'2022-12-26 11:57:00','924','0000-00-00 00:00:00','','2022-12-26 12:00:51','928'),(26,'8',27,'211',1,1,'2022-12-30 00:00:00','AA RANO',44500.00,44500.00,0.00,'','','1','ABC068ZU','Amadu makole','07033039557','Purchase of pms',5,'2022-12-30 20:42:33','924','0000-00-00 00:00:00','','2022-12-30 21:12:40','928'),(27,'8',28,'211',1,1,'2023-01-07 00:00:00','AA RANO',28800.00,28800.00,0.00,'','','1','Nsr56Zq','SANI','091335528','Purchase of pms',5,'2023-01-07 18:54:25','924','0000-00-00 00:00:00','','2023-01-07 20:42:32','928'),(28,'8',29,'211',1,1,'2023-01-13 00:00:00','AA RANO',33000.00,33000.00,0.00,'','','1','GML594XA','Kabiru','08147774782','Purchase of pms',5,'2023-01-13 22:18:38','924','0000-00-00 00:00:00','','2023-01-13 22:20:11','928'),(29,'8',30,'211',1,1,'2023-01-19 00:00:00','AA RANO',35000.00,35000.00,0.00,'','','1','RAN441XA','Medaban-Daban','08065000870','Purchase of pms',5,'2023-01-19 16:59:01','924','0000-00-00 00:00:00','','2023-01-19 17:04:56','928'),(30,'8',31,'211',1,1,'2023-01-21 00:00:00','AA RANO',16800.00,16800.00,0.00,'','','1','BCH428XA','Lirwan','08034997784','Purchase of pms',5,'2023-01-21 18:13:02','924','0000-00-00 00:00:00','','2023-01-21 18:15:30','928'),(31,'8',32,'211',1,1,'2023-01-31 00:00:00','AA RANO',33000.00,33000.00,0.00,'','','1','BCH424XA','ARANMA','07038288822','Purchase of pms',5,'2023-01-31 22:26:40','924','0000-00-00 00:00:00','','2023-01-31 22:29:53','928'),(32,'8',33,'211',1,1,'2023-02-07 00:00:00','AA RANO',32800.00,32800.00,0.00,'','','1','WDL813XA','Hamisu ','','Purchase of pms',5,'2023-02-07 11:59:00','924','0000-00-00 00:00:00','','2023-02-07 12:03:37','928'),(33,'8',34,'211',1,1,'2023-02-09 00:00:00','AA RANO',17100.00,17100.00,0.00,'','','1','RAN683XA','SHAMSU','','Purchase of pms',5,'2023-02-09 15:21:05','924','0000-00-00 00:00:00','','2023-02-09 15:35:45','928'),(34,'8',35,'211',1,1,'2023-02-12 00:00:00','AA RANO',35000.00,35000.00,0.00,'','','1','RAN 441XA','MEDABAN ','','purchase of pms',5,'2023-02-12 20:29:31','924','0000-00-00 00:00:00','','2023-02-12 20:59:30','928'),(35,'8',36,'211',1,1,'2023-02-18 00:00:00','AA RANO',28800.00,28800.00,0.00,'','','1','Nsr56zq','Sani','','purchase of pms',5,'2023-02-18 10:15:11','924','0000-00-00 00:00:00','','2023-02-18 12:56:49','928'),(36,'8',37,'211',1,1,'2023-02-24 00:00:00','AA RANO',32850.00,32850.00,0.00,'','','1','RAN869XA','USMAN','','purchase of pms',5,'2023-02-24 10:06:23','924','0000-00-00 00:00:00','','2023-02-24 10:07:13','928'),(37,'8',38,'211',1,1,'2023-02-26 00:00:00','AA RANO',18000.00,18000.00,0.00,'','','1','NSR435ZS','A.GAMBO','','purchase of pms',5,'2023-02-26 22:21:18','924','0000-00-00 00:00:00','','2023-02-26 22:24:15','928'),(38,'8',39,'211',1,1,'2023-03-02 00:00:00','AA RANO',31500.00,31500.00,0.00,'','','1','RAN441XA','MEDABAN ','','purchase of pms',5,'2023-03-02 08:48:01','924','0000-00-00 00:00:00','','2023-03-02 09:16:01','928'),(39,'8',40,'211',1,1,'2023-03-04 00:00:00','AA RANO',45000.00,45000.00,0.00,'','','1','RSH369ZA','GAMBO NUHU','08064258129','purchase of pms',5,'2023-03-04 22:19:22','924','0000-00-00 00:00:00','','2023-03-04 22:20:23','928'),(40,'8',41,'211',1,1,'2023-03-07 00:00:00','AA RANO',14950.00,14950.00,0.00,'','','1','WDL813XA','HAMISU','08025777097','purchase of pms',5,'2023-03-07 23:38:44','924','0000-00-00 00:00:00','','2023-03-08 08:28:43','928'),(41,'8',42,'211',1,1,'2023-03-12 00:00:00','AA RANO',16800.00,16800.00,0.00,'','','1','BCH424XA','Aranma','','purchase of pms',5,'2023-03-12 23:50:43','924','0000-00-00 00:00:00','','2023-03-13 14:58:12','928'),(42,'8',44,'211',1,1,'2023-03-18 00:00:00','AA RANO',16000.00,16000.00,0.00,'','','1','NSR572XA','A.Buhari','','purchase of pms',5,'2023-03-18 12:48:37','924','0000-00-00 00:00:00','','2023-03-18 12:49:14','924');
/*!40000 ALTER TABLE `purchases_receptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports`
--

DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `type` varchar(20) NOT NULL,
  `sql` text NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`report_id`),
  KEY `companycode` (`company_id`,`name`,`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports`
--

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_fields`
--

DROP TABLE IF EXISTS `reports_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(20) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `fieldname` varchar(50) NOT NULL,
  `order` int NOT NULL,
  `visibility` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`report_id`,`field_id`,`order`,`visibility`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_fields`
--

LOCK TABLES `reports_fields` WRITE;
/*!40000 ALTER TABLE `reports_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `reports_filters`
--

DROP TABLE IF EXISTS `reports_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports_filters` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `report_id` varchar(50) NOT NULL,
  `field_id` varchar(50) NOT NULL,
  `filter_id` int NOT NULL AUTO_INCREMENT,
  `criteria` varchar(20) NOT NULL,
  `value` varchar(100) NOT NULL,
  PRIMARY KEY (`filter_id`),
  KEY `companycode` (`company_id`,`report_id`),
  KEY `field_id` (`field_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `reports_filters`
--

LOCK TABLES `reports_filters` WRITE;
/*!40000 ALTER TABLE `reports_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `reports_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_customers`
--

DROP TABLE IF EXISTS `retail_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(100) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`name`,`phone`,`email`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_customers`
--

LOCK TABLES `retail_customers` WRITE;
/*!40000 ALTER TABLE `retail_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory`
--

DROP TABLE IF EXISTS `retail_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` int NOT NULL,
  `qtyout` int NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory`
--

LOCK TABLES `retail_inventory` WRITE;
/*!40000 ALTER TABLE `retail_inventory` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_balances`
--

DROP TABLE IF EXISTS `retail_inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_balances`
--

LOCK TABLES `retail_inventory_balances` WRITE;
/*!40000 ALTER TABLE `retail_inventory_balances` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_inventory_costs`
--

DROP TABLE IF EXISTS `retail_inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_inventory_costs`
--

LOCK TABLES `retail_inventory_costs` WRITE;
/*!40000 ALTER TABLE `retail_inventory_costs` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products`
--

DROP TABLE IF EXISTS `retail_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products` (
  `product_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `reorder` decimal(20,2) NOT NULL,
  `is_low` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`product_id`),
  KEY `companycode` (`company_id`,`name`,`cost`,`selling`,`createdby`,`modifiedby`),
  KEY `depot_id` (`station_id`),
  KEY `reorder` (`reorder`),
  KEY `selling_bulk` (`selling_bulk`),
  KEY `parent_id` (`parent_id`),
  KEY `is_low` (`is_low`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products`
--

LOCK TABLES `retail_products` WRITE;
/*!40000 ALTER TABLE `retail_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_prices`
--

DROP TABLE IF EXISTS `retail_products_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_prices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `selling` decimal(10,2) NOT NULL,
  `selling_bulk` decimal(20,2) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`cost`,`selling`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`),
  KEY `selling_bulk` (`selling_bulk`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_prices`
--

LOCK TABLES `retail_products_prices` WRITE;
/*!40000 ALTER TABLE `retail_products_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_products_reconciliations`
--

DROP TABLE IF EXISTS `retail_products_reconciliations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_products_reconciliations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `quantity_in` decimal(20,2) NOT NULL,
  `quantity_out` decimal(20,2) NOT NULL,
  `oldbalance` decimal(20,2) NOT NULL,
  `newbalance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`),
  KEY `shift_id` (`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_products_reconciliations`
--

LOCK TABLES `retail_products_reconciliations` WRITE;
/*!40000 ALTER TABLE `retail_products_reconciliations` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_products_reconciliations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_purchases`
--

DROP TABLE IF EXISTS `retail_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_purchases` (
  `purchase_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `purchasedate` date NOT NULL,
  `product_id` int NOT NULL,
  `supplier_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `truckno` varchar(20) NOT NULL,
  `cheque` varchar(20) NOT NULL,
  `accountgroup` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`purchase_id`),
  KEY `companycode` (`company_id`,`purchasedate`,`product_id`,`supplier_id`,`rate`,`quantity`,`status`),
  KEY `waybill` (`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_purchases`
--

LOCK TABLES `retail_purchases` WRITE;
/*!40000 ALTER TABLE `retail_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales`
--

DROP TABLE IF EXISTS `retail_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `saledate` date NOT NULL,
  `customer_id` varchar(20) NOT NULL DEFAULT '',
  `customer_name` varchar(50) NOT NULL,
  `customer_phone` varchar(30) NOT NULL,
  `quantity_kg` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `payment_method` varchar(10) NOT NULL,
  `payment_account_type` varchar(20) NOT NULL,
  `payment_account_id` varchar(20) NOT NULL,
  `paid` decimal(20,2) DEFAULT NULL,
  `change` decimal(20,2) DEFAULT '0.00',
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`customer_name`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `payment_method` (`payment_method`,`payment_account_type`,`payment_account_id`),
  KEY `customer_id` (`customer_id`),
  KEY `change` (`change`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales`
--

LOCK TABLES `retail_sales` WRITE;
/*!40000 ALTER TABLE `retail_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_items`
--

DROP TABLE IF EXISTS `retail_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `product_type` varchar(10) NOT NULL,
  `product_name` varchar(100) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `quantity_2` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `parent_rate` decimal(20,2) NOT NULL,
  `parent_quantity` decimal(20,2) NOT NULL,
  `parent_cost` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`sale_id`,`product_id`,`rate`,`quantity`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`product_type`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_items`
--

LOCK TABLES `retail_sales_items` WRITE;
/*!40000 ALTER TABLE `retail_sales_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `retail_sales_payments`
--

DROP TABLE IF EXISTS `retail_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `retail_sales_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `sale_id` varchar(20) NOT NULL,
  `payment_method` varchar(50) NOT NULL,
  `account_type` varchar(10) DEFAULT NULL,
  `account_id` bigint DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_by` bigint DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`sale_id`,`payment_method`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `product_type` (`account_type`),
  KEY `parent_id` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `retail_sales_payments`
--

LOCK TABLES `retail_sales_payments` WRITE;
/*!40000 ALTER TABLE `retail_sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `retail_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales` (
  `sale_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `is_credit` int NOT NULL DEFAULT '0',
  `saledate` date NOT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `cost` decimal(20,2) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `discountamount` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `paid` int NOT NULL,
  `details` text NOT NULL,
  `ledger_notes` varchar(150) DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`sale_id`),
  KEY `companycode` (`company_id`,`saledate`,`product_id`,`customer_id`,`rate`,`quantity`,`status`),
  KEY `paid` (`paid`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`is_credit`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_daily`
--

DROP TABLE IF EXISTS `sales_daily`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_daily` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `saledate` date NOT NULL,
  `average` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `target` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`average`,`saledate`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_daily`
--

LOCK TABLES `sales_daily` WRITE;
/*!40000 ALTER TABLE `sales_daily` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_daily` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions`
--

DROP TABLE IF EXISTS `sales_distributions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions` (
  `distribution_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `sale_id` int NOT NULL,
  `purchase_id` varchar(20) NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `loadingdate` date NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `destination` varchar(50) NOT NULL,
  `waybill` varchar(20) NOT NULL,
  `meterno` varchar(20) NOT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `truckno` varchar(20) NOT NULL,
  `drivername` varchar(50) NOT NULL,
  `details` varchar(300) NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  PRIMARY KEY (`distribution_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`loadingdate`,`quantity`,`destination`,`waybill`,`meterno`,`nozzle_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`tank_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `truckno` (`truckno`),
  KEY `purchase_id_2` (`purchase_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions`
--

LOCK TABLES `sales_distributions` WRITE;
/*!40000 ALTER TABLE `sales_distributions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_delivery`
--

DROP TABLE IF EXISTS `sales_distributions_delivery`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_delivery` (
  `delivery_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `distribution_id` int NOT NULL,
  `sale_id` int NOT NULL,
  `bridge_id` int NOT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `customer_id` int NOT NULL,
  `quantity` int NOT NULL,
  `truck_id` int NOT NULL,
  `deliveredon` date NOT NULL,
  `details` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`delivery_id`),
  KEY `companycode` (`company_id`,`station_id`,`product_id`,`customer_id`,`quantity`,`thedate`,`createdby`),
  KEY `purchase_id` (`sale_id`),
  KEY `truck_id` (`truck_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `distribution_id` (`distribution_id`),
  KEY `deliveredon` (`deliveredon`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_delivery`
--

LOCK TABLES `sales_distributions_delivery` WRITE;
/*!40000 ALTER TABLE `sales_distributions_delivery` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_delivery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_distributions_trucks`
--

DROP TABLE IF EXISTS `sales_distributions_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_distributions_trucks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sale_id` varchar(20) NOT NULL,
  `distribution_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `bridge_id` varchar(20) NOT NULL,
  `truck_id` varchar(20) NOT NULL,
  `driver_id` varchar(20) NOT NULL,
  `quantity` int NOT NULL,
  `destination` varchar(150) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `bridge_id` (`bridge_id`),
  KEY `companycode` (`company_id`,`distribution_id`,`truck_id`),
  KEY `sale_id` (`sale_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_distributions_trucks`
--

LOCK TABLES `sales_distributions_trucks` WRITE;
/*!40000 ALTER TABLE `sales_distributions_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_distributions_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_fueltickets`
--

DROP TABLE IF EXISTS `sales_fueltickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_fueltickets` (
  `ticket_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `ticketdate` date NOT NULL,
  `code` varchar(20) NOT NULL,
  `product_id` int NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `quantity` int NOT NULL,
  `allowance` decimal(10,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `truck_number` varchar(20) NOT NULL,
  `truck_capacity` int NOT NULL,
  `truck_provider` varchar(50) NOT NULL,
  `truck_from` varchar(50) NOT NULL,
  `truck_destination` varchar(50) NOT NULL,
  `driver_name` varchar(50) NOT NULL,
  `driver_phone` varchar(50) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `companycode` (`company_id`,`ticketdate`,`product_id`,`truck_number`,`rate`,`quantity`,`status`),
  KEY `paid` (`truck_provider`),
  KEY `invoice` (`code`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_fueltickets`
--

LOCK TABLES `sales_fueltickets` WRITE;
/*!40000 ALTER TABLE `sales_fueltickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_fueltickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales_payments`
--

DROP TABLE IF EXISTS `sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sales_payments` (
  `payment_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `paymentdate` date NOT NULL,
  `customer_id` int NOT NULL,
  `receipt` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `method` varchar(10) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `invoice` varchar(20) NOT NULL,
  `paidby` varchar(50) NOT NULL,
  `receivedby` varchar(50) NOT NULL,
  `bank` varchar(20) NOT NULL,
  `depositor` varchar(30) NOT NULL,
  `teller` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`payment_id`),
  KEY `companycode` (`company_id`,`paymentdate`,`customer_id`,`receipt`,`status`),
  KEY `invoice` (`invoice`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales_payments`
--

LOCK TABLES `sales_payments` WRITE;
/*!40000 ALTER TABLE `sales_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_cashbacks`
--

DROP TABLE IF EXISTS `shifts_cashbacks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_cashbacks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `regno` varchar(100) DEFAULT NULL,
  `cashdate` date NOT NULL,
  `driver` varchar(100) DEFAULT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`cashdate`,`driver`,`customer_id`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`),
  KEY `is_credit` (`regno`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_cashbacks`
--

LOCK TABLES `shifts_cashbacks` WRITE;
/*!40000 ALTER TABLE `shifts_cashbacks` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_cashbacks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shifts_remittance`
--

DROP TABLE IF EXISTS `shifts_remittance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `shifts_remittance` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `shift_id` bigint unsigned NOT NULL,
  `paymentdate` date NOT NULL,
  `method` int DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `paidby` varchar(50) DEFAULT NULL,
  `paidto` varchar(100) DEFAULT NULL,
  `bank` bigint unsigned DEFAULT NULL,
  `depositor` varchar(100) DEFAULT NULL,
  `teller` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `status` int NOT NULL,
  `details` text,
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `approved_by` bigint unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `reversed_at` datetime DEFAULT NULL,
  `reversed_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`paymentdate`,`method`,`bank`,`status`),
  KEY `depot_id` (`station_id`),
  KEY `shift_id` (`shift_id`),
  KEY `amount` (`amount`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shifts_remittance`
--

LOCK TABLES `shifts_remittance` WRITE;
/*!40000 ALTER TABLE `shifts_remittance` DISABLE KEYS */;
/*!40000 ALTER TABLE `shifts_remittance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `supplier_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`supplier_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers`
--

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (1,'8','211','Lausu Energy Resources','Babangida Umar Bashir','08063654848','info@','KANO','KANO','Lausu Energy AA Rano House.','Nigeria',0.00,0.00,'0000-00-00','2022-08-06 08:59:15',5,'926','2022-08-06 08:59:15','926');
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `suppliers_status`
--

DROP TABLE IF EXISTS `suppliers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `supplier_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `suppliers_status`
--

LOCK TABLES `suppliers_status` WRITE;
/*!40000 ALTER TABLE `suppliers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers_status` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-03-21  2:57:11
