-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_97
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_97`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_97` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_97`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3648 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1759,3000,'',0,'24','5','97','PURCHASES','','2019-01-20 13:17:01',5,0.00,0.00,'','401','2019-01-20 13:17:01','401',0,1),(1760,3002,'',0,'24','5','97','SALARIES AND WAGES','','2019-01-20 13:17:49',5,0.00,0.00,'','401','2019-01-20 13:17:49','401',0,1),(1761,3003,'',0,'6.1','5','97','CASH','','2019-01-20 13:18:41',5,0.00,0.00,'','401','2019-01-20 13:18:41','401',0,1),(1762,3500,'',0,'20','5','97','SALES','','2019-01-20 13:19:58',5,0.00,0.00,'','401','2019-01-20 13:19:58','401',0,1),(1789,4000,'',0,'2','5','97','UBA  1019882661','','2019-01-23 18:35:11',5,0.00,0.00,'','401','2019-01-23 18:35:11','401',0,1),(1809,3004,'',0,'24','5','97','DIESEL INTERNAL CONSUPTION(GEN','','2019-02-22 13:54:41',5,0.00,0.00,'','401','2019-02-22 13:54:41','401',0,1),(1810,3005,'',0,'24','5','97','CLEANING & SANITARY ITEMS','','2019-02-22 13:55:13',5,0.00,0.00,'','401','2019-02-22 13:55:13','401',0,1),(1811,3007,'',0,'24','5','97','TRANSPORT FARE','','2019-02-22 13:56:03',5,0.00,0.00,'','401','2019-02-22 13:56:03','401',0,1),(1812,3008,'',0,'24','5','97','OTHER OPERATING EXPENSES','','2019-02-22 13:56:41',5,0.00,0.00,'','401','2019-02-22 13:56:41','401',0,1),(1813,3009,'',0,'24','5','97','GENERATOR REPAIRS & MAINTAINAN','','2019-02-22 13:57:30',5,0.00,0.00,'','401','2019-02-22 13:57:30','401',0,1),(1814,3010,'',0,'24','5','97','PUMP REPAIRS & MAINATAINACE','','2019-02-22 13:58:30',5,0.00,0.00,'','401','2019-02-22 13:58:30','401',0,1),(1815,3011,'',0,'24','5','97','WEIGHT AND MEASURE','','2019-02-22 13:59:34',5,0.00,0.00,'','401','2019-02-22 13:59:34','401',0,1),(1816,3012,'',0,'24','5','97','DPR EXPENSES','','2019-02-22 14:00:04',5,0.00,0.00,'','401','2019-02-22 14:00:04','401',0,1),(1817,3013,'',0,'24','5','97','TRAVELLINGEXPENSES','','2019-02-22 14:01:27',5,0.00,0.00,'','401','2019-02-22 14:01:27','401',0,1),(1818,3014,'',0,'24','5','97','MEDICAL EXPENSES','','2019-02-22 14:02:36',5,0.00,0.00,'','401','2019-02-22 14:02:36','401',0,1),(1819,3015,'',0,'24','5','97','OFFICIAL CAR FUEL & REPAIRS','','2019-02-22 14:22:54',5,0.00,0.00,'','401','2019-02-22 14:22:54','401',0,1),(1820,2016,'',0,'24','5','97','PUBLIC RELATION','','2019-02-22 14:23:19',5,0.00,0.00,'','401','2019-02-22 14:23:19','401',0,1),(3227,4014,'',0,'2','5','97','ZB:EBILLS-1016650302.','','2021-03-06 01:10:33',5,0.00,0.00,'','600','2021-03-06 01:10:33','600',0,1),(3280,4031,'',0,'2','5','97','U B A-FANISAU (1022244737)','','2021-03-29 11:25:14',5,0.00,0.00,'','600','2021-03-29 11:25:14','600',0,1),(3644,4052,'',0,'2','5','97','1022244791-U.B.A','','2021-09-17 14:19:43',5,0.00,0.00,'','600','2021-09-17 14:19:43','600',0,1),(3645,4053,'',0,'2','5','97','JA\'IZ - 0010037957','','2022-03-01 20:02:15',5,0.00,0.00,'','600','2022-03-01 20:02:15','600',0,0),(3646,3016,'',0,'24','5','97','PUBLIC RELATION','','2022-10-27 11:44:38',5,0.00,0.00,'','401','2022-10-27 11:44:38','401',0,0),(3647,2000,'',0,'6','5','97','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:25:28',5,0.00,0.00,'','600','2023-02-06 10:25:28','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','97','0000-00-00','2023-02-07 13:32:28',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'5','97','0000-00-00','2023-02-22 12:38:45',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','97','0000-00-00','2023-02-22 12:41:42',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(4,'5','97','0000-00-00','2023-02-22 12:56:50',5,'795','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(5,'5','97','0000-00-00','2023-02-22 12:59:34',5,'795','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (2,'5','97','1','3647','6',0.00,'Pms price increase from 185 to 220 on 20/1/2023  8,750ltrs ×35 = 306,250',306250.00,'2023-01-20'),(3,'5','97','1','103','supplier',306250.00,'Pms price increase from 185 to 220 on 20/1/2023  8,750ltrs ×35 = 306,250',0.00,'2023-01-20'),(4,'5','97','2','103','supplier',0.00,'Pms price increase from 220 to 210 on 19/2/2023  1400ltrs ×10 = 14,000',14000.00,'2023-02-19'),(5,'5','97','2','3647','6',14000.00,'Pms price decrease from 220 to 210 on 19/2/2023  1,400ltrs ×10 = 14,000',0.00,'2023-02-19'),(6,'5','97','3','103','supplier',0.00,'Ago price decrease from 830 to 820 on 20/2/2023 Dipping 350ltrs × 10 3,500',3500.00,'2023-02-20'),(7,'5','97','3','3647','6',3500.00,'Ago price decrease from 830 to 820 on 20/2/2023 Dipping 350 × 10 3,500',0.00,'2023-02-20'),(8,'5','97','4','103','supplier',0.00,'PMS Price decrease( 220 to 210 300litres on 19/2/2023',3000.00,'2023-02-19'),(9,'5','97','4','3647','6',3000.00,'PMS Price decrease 220 to 210, 300litres on 19/2/2023',0.00,'2023-02-19'),(10,'5','97','5','103','supplier',0.00,'Ago Price decrease 830 to 820 250litres on 20/2/2023',2500.00,'2023-02-22'),(11,'5','97','5','3647','6',2500.00,'Ago Price decrease 830 to 820 250litres on 20/2/2023',0.00,'2023-02-22');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64816 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
INSERT INTO `accounts_vouchers_items` VALUES (64759,'5','97',31755,1809,'AGO CONSUMPTION ',16000.00),(64760,'5','97',31755,1812,'WATER SUPPLY',1500.00),(64761,'5','97',31755,1819,'MANAGER PMS',1400.00),(64762,'5','97',31755,1812,'RTT 50 LITRES',7000.00),(64763,'5','97',31755,1811,'SECURITY TO FANISAU',15000.00),(64769,'5','97',31756,1809,'AGO CONSUMPTION ',11925.00),(64770,'5','97',31756,1812,'WATER SUPPLY',1500.00),(64771,'5','97',31756,1819,'MANAGER PMS',1400.00),(64772,'5','97',31756,1812,'LEDA PURCHASE',1500.00),(64773,'5','97',31756,1813,'REPLACEMENT OF FAN BELT',3000.00),(64774,'5','97',31757,1809,'AGO CONSUMPTION ',11925.00),(64775,'5','97',31757,1812,'WATER SUPPLY',1500.00),(64786,'5','97',31763,1809,'AGO CONSUMPTION ',11925.00),(64787,'5','97',31763,1812,'WATER SUPPLY',1500.00),(64788,'5','97',31763,1819,'MANAGER PMS',1400.00),(64789,'5','97',31763,1812,'POLICE PMS',3000.00),(64790,'5','97',31763,1812,'KMC 38 XX AGO 530 AMINU',140450.00),(64791,'5','97',31763,1812,'DUFTY MANGERS FOODS',2000.00),(64794,'5','97',31766,1809,'AGO CONSUMPTION ',14000.00),(64795,'5','97',31766,1812,'POS PAPER',3500.00),(64796,'5','97',31766,1811,'DEPUTY MANAGER\'S TRANSPORT TO MAFARA',5000.00),(64797,'5','97',31766,1811,'TRANSPORT TO BANK',1000.00),(64798,'5','97',31766,1812,'KMC 143 YT AGO 700 UBALE',178000.00),(64799,'5','97',31767,1809,'AGO CONSUMPTION ',14000.00),(64800,'5','97',31767,1813,'FAN BELT REPLACEMENT',3000.00),(64801,'5','97',31768,1809,'AGO CONSUMPTION ',14000.00),(64802,'5','97',31768,1814,'WEIGHT AND PUMP',5000.00),(64803,'5','97',31768,1812,'GWL 63 YJ AGO 30 JIBRIN',7650.00),(64804,'5','97',31769,1809,'AGO CONSUMPTION ',16000.00),(64805,'5','97',31769,1811,'TRANSPORT TO BANK',1000.00),(64806,'5','97',31769,1813,'GENERATOR SERVICE',4000.00),(64807,'5','97',31769,1812,'TRN 178 ZG AGO 430 AUWALU',109650.00),(64808,'5','97',31769,1812,'BOREHOLE DRILLING',425000.00),(64809,'5','97',31770,1809,'AGO CONSUMPTION ',14000.00),(64810,'5','97',31770,1812,'POLICE PMS',2000.00),(64811,'5','97',31770,1810,'CLEAN AND IZAL',2500.00),(64814,'5','97',31771,1809,'AGO CONSUMPTION ',16000.00),(64815,'5','97',31771,1812,'ROBBER BAN',3000.00);
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1413 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1412,'','5','97','SALBAS TRANSPORT','','','','','','','Nigeria',0.00,0.00,0.00,'0000-00-00','2019-01-31 10:53:27',5,'401','2021-02-18 09:28:15','401');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18665 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','97',16787,'614',150.00,1000.00,'2021-10-13','','2021-10-13 14:21:34','401','401',2021,'401','2021-10-13 14:21:34',5),('5','97',16788,'614',150.00,10000.00,'2021-10-13','','2021-10-13 14:31:01','401','401',2021,'401','2021-10-13 14:31:01',5),('5','97',16789,'614',10340.89,2000.00,'2021-10-13','','2021-10-13 15:43:02','401','401',2021,'401','2021-10-13 15:43:02',5),('5','97',16790,'615',150.00,4000.00,'2021-10-13','','2021-10-13 15:43:33','401','401',2021,'401','2021-10-13 15:43:33',5),('5','97',16792,'614',590.88,5000.00,'2021-10-13','','2021-10-13 21:34:12','401','401',2021,'401','2021-10-13 21:34:12',5),('5','97',16793,'615',732.94,5500.00,'2021-10-13','','2021-10-13 21:34:41','401','401',2021,'401','2021-10-13 21:34:41',5),('5','97',16805,'614',277.84,5000.00,'2021-10-14','','2021-10-14 22:11:33','401','401',2021,'401','2021-10-14 22:11:33',5),('5','97',16806,'615',431.96,5000.00,'2021-10-14','','2021-10-14 22:12:01','401','401',2021,'401','2021-10-14 22:12:01',5),('5','97',16809,'615',18500.00,150.00,'2021-10-15','','2021-10-15 09:34:27','401','401',2021,'401','2021-10-15 09:34:27',5),('5','97',16810,'614',30450.00,15200.00,'2021-10-15','','2021-10-15 09:36:13','401','401',2021,'401','2021-10-15 09:36:13',5),('5','97',16829,'614',2890.01,8000.00,'2021-10-16','','2021-10-16 20:31:09','401','401',2021,'401','2021-10-16 20:31:09',5),('5','97',16834,'617',385.38,200.00,'2021-10-17','','2021-10-17 10:36:56','401','401',2021,'401','2021-10-17 10:36:56',5),('5','97',16835,'615',-4377.46,150.00,'2021-10-17','','2021-10-17 10:37:32','401','401',2021,'401','2021-10-17 10:37:32',5),('5','97',16836,'616',50.92,100.00,'2021-10-17','','2021-10-17 10:37:52','401','401',2021,'401','2021-10-17 10:37:52',5),('5','97',17313,'614',17.04,700.00,'2021-10-30','','2021-10-30 21:49:36','401','401',2021,'401','2021-10-30 21:49:36',5),('5','97',17381,'614',19.50,14000.00,'2021-10-31','','2021-10-31 21:03:03','401','401',2021,'401','2021-10-31 21:03:03',5),('5','97',17457,'614',352.90,2000.00,'2021-11-03','','2021-11-03 21:28:22','401','401',2021,'401','2021-11-03 21:28:22',5),('5','97',17458,'615',150.00,11000.00,'2021-11-03','','2021-11-03 21:28:45','401','401',2021,'401','2021-11-03 21:28:45',5),('5','97',17472,'615',134.90,2700.00,'2021-11-04','','2021-11-04 20:39:10','401','401',2021,'401','2021-11-04 20:39:10',5),('5','97',17498,'614',4628.57,13000.00,'2021-11-05','','2021-11-05 23:22:24','401','401',2021,'401','2021-11-05 23:22:24',5),('5','97',17547,'614',25414.53,1500.00,'2021-11-07','','2021-11-09 12:23:07','401','401',2021,'401','2021-11-09 12:23:07',5),('5','97',17566,'614',30311.00,17000.00,'2021-11-10','','2021-11-10 14:50:34','401','401',2021,'401','2021-11-10 14:50:34',5),('5','97',17570,'614',5475.03,20000.00,'2021-11-09','','2021-11-11 08:19:27','401','401',2021,'401','2021-11-11 08:19:27',5),('5','97',17608,'614',1875.85,12500.00,'2021-11-13','','2021-11-13 22:28:44','401','401',2021,'401','2021-11-13 22:28:44',5),('5','97',17609,'615',6201.54,6500.00,'2021-11-13','','2021-11-13 22:29:18','401','401',2021,'401','2021-11-13 22:29:18',5),('5','97',17622,'614',357.60,8500.00,'2021-11-14','','2021-11-14 21:33:52','401','401',2021,'401','2021-11-14 21:33:52',5),('5','97',17623,'615',201.02,10000.00,'2021-11-14','','2021-11-14 21:34:38','401','401',2021,'401','2021-11-14 21:34:38',5),('5','97',17665,'614',33383.62,15000.00,'2021-11-16','','2021-11-16 23:10:46','401','401',2021,'401','2021-11-16 23:10:46',5),('5','97',17761,'614',1009.64,4000.00,'2021-11-24','','2021-11-24 23:36:55','401','401',2021,'401','2021-11-24 23:36:55',5),('5','97',17762,'617',6717.66,10000.00,'2021-11-24','','2021-11-24 23:37:16','401','401',2021,'401','2021-11-24 23:37:16',5),('5','97',17771,'614',608.82,6000.00,'2021-11-25','','2021-11-25 22:17:08','401','401',2021,'401','2021-11-25 22:17:08',5),('5','97',17772,'615',5758.94,11000.00,'2021-11-25','','2021-11-25 22:17:42','401','401',2021,'401','2021-11-25 22:17:42',5),('5','97',17795,'614',424.45,5000.00,'2021-11-26','','2021-11-26 23:22:20','401','401',2021,'401','2021-11-26 23:22:20',5),('5','97',17796,'615',65.61,6200.00,'2021-11-26','','2021-11-26 23:22:56','401','401',2021,'401','2021-11-26 23:22:56',5),('5','97',17898,'614',13196.77,14500.00,'2021-12-02','','2021-12-02 22:44:34','401','401',2021,'401','2021-12-02 22:44:34',5),('5','97',17907,'614',311.12,13500.00,'2021-12-04','','2021-12-04 07:07:27','401','401',2021,'401','2021-12-04 07:07:27',5),('5','97',17909,'615',23308.81,150.00,'2021-12-04','','2021-12-04 14:37:54','401','401',2021,'401','2021-12-04 14:37:54',5),('5','97',17984,'614',28260.63,150.00,'2021-12-11','','2021-12-11 17:53:08','401','401',2021,'401','2021-12-11 17:53:08',5),('5','97',17985,'615',2100.65,150.00,'2021-12-11','','2021-12-11 17:53:33','401','401',2021,'401','2021-12-11 17:53:33',5),('5','97',17986,'616',2311.04,150.00,'2021-12-11','','2021-12-11 17:53:55','401','401',2021,'401','2021-12-11 17:53:55',5),('5','97',17987,'617',2690.73,150.00,'2021-12-11','','2021-12-11 17:54:19','401','401',2021,'401','2021-12-11 17:54:19',5),('5','97',18039,'614',150.00,800.00,'2021-12-14','','2021-12-14 20:11:05','401','401',2021,'401','2021-12-14 20:11:05',5),('5','97',18051,'614',159.70,9100.00,'2021-12-15','','2021-12-15 21:08:33','401','401',2021,'401','2021-12-15 21:08:33',5),('5','97',18052,'616',150.00,2500.00,'2021-12-15','','2021-12-15 21:09:18','401','401',2021,'401','2021-12-15 21:09:18',5),('5','97',18053,'617',150.00,2300.00,'2021-12-15','','2021-12-15 21:09:48','401','401',2021,'401','2021-12-15 21:09:48',5),('5','97',18068,'614',141.30,9000.00,'2021-12-16','','2021-12-16 21:31:10','401','401',2021,'401','2021-12-16 21:31:10',5),('5','97',18069,'617',136.49,2000.00,'2021-12-16','','2021-12-16 21:31:52','401','401',2021,'401','2021-12-16 21:31:52',5),('5','97',18097,'614',26789.33,2500.00,'2021-12-17','','2021-12-17 19:31:25','401','401',2021,'401','2021-12-17 19:31:25',5),('5','97',18098,'617',13162.21,1200.00,'2021-12-17','','2021-12-17 19:32:32','401','401',2021,'401','2021-12-17 19:32:32',5),('5','97',18099,'614',2500.00,10000.00,'2021-12-17','','2021-12-17 19:33:27','401','401',2021,'401','2021-12-17 19:33:27',5),('5','97',18100,'617',1200.00,5000.00,'2021-12-17','','2021-12-17 19:34:08','401','401',2021,'401','2021-12-17 19:34:08',5),('5','97',18112,'617',314.88,1000.00,'2021-12-18','','2021-12-18 21:32:38','401','401',2021,'401','2021-12-18 21:32:38',5),('5','97',18124,'617',275.03,2000.00,'2021-12-19','','2021-12-19 20:22:53','401','401',2021,'401','2021-12-19 20:22:53',5),('5','97',18141,'617',101.30,2200.00,'2021-12-20','','2021-12-20 21:56:56','401','401',2021,'401','2021-12-20 21:56:56',5),('5','97',18151,'614',1405.72,9000.00,'2021-12-21','','2021-12-21 22:47:34','401','401',2021,'401','2021-12-21 22:47:34',5),('5','97',18329,'615',150.00,11000.00,'2022-01-02','','2022-01-03 08:53:17','401','401',2022,'401','2022-01-03 08:53:17',5),('5','97',18330,'617',200.00,7800.00,'2022-01-02','','2022-01-03 08:54:18','401','401',2022,'401','2022-01-03 08:54:18',5),('5','97',18340,'615',657.48,10500.00,'2022-01-02','','2022-01-03 21:37:53','401','401',2022,'401','2022-01-03 21:37:53',5),('5','97',18341,'617',204.46,8500.00,'2022-01-02','','2022-01-03 21:38:34','401','401',2022,'401','2022-01-03 21:38:34',5),('5','97',18342,'615',10500.00,1200.00,'2022-01-02','','2022-01-03 21:39:09','401','401',2022,'401','2022-01-03 21:39:09',5),('5','97',18343,'615',1200.00,11500.00,'2022-01-02','','2022-01-03 21:43:30','401','401',2022,'401','2022-01-03 21:43:30',5),('5','97',18355,'614',9638.16,8500.00,'2022-01-04','','2022-01-04 21:19:40','401','401',2022,'401','2022-01-04 21:19:40',5),('5','97',18356,'615',485.09,11800.00,'2022-01-04','','2022-01-04 21:21:02','401','401',2022,'401','2022-01-04 21:21:02',5),('5','97',18357,'617',6.59,216.00,'2022-01-04','','2022-01-04 21:22:11','401','401',2022,'401','2022-01-04 21:22:11',5),('5','97',18362,'614',249.53,13500.00,'2022-01-05','','2022-01-06 09:40:47','401','401',2022,'401','2022-01-06 09:40:47',5),('5','97',18363,'615',39.76,1700.00,'2022-01-05','','2022-01-06 09:41:16','401','401',2022,'401','2022-01-06 09:41:16',5),('5','97',18370,'614',507.11,10000.00,'2022-01-06','','2022-01-06 22:26:06','401','401',2022,'401','2022-01-06 22:26:06',5),('5','97',18380,'614',1116.02,8200.00,'2022-01-07','','2022-01-07 22:58:50','401','401',2022,'401','2022-01-07 22:58:50',5),('5','97',18435,'614',17366.72,3800.00,'2022-01-13','','2022-01-13 22:40:59','401','401',2022,'401','2022-01-13 22:40:59',5),('5','97',18449,'614',-11542.15,15500.00,'2022-01-15','','2022-01-15 22:02:47','401','401',2022,'401','2022-01-15 22:02:47',5),('5','97',18457,'614',277.84,11500.00,'2022-01-16','','2022-01-16 22:45:16','401','401',2022,'401','2022-01-16 22:45:16',5),('5','97',18482,'614',263.43,11500.00,'2022-01-17','','2022-01-17 22:33:10','401','401',2022,'401','2022-01-17 22:33:10',5),('5','97',18491,'617',17200.83,200.00,'2022-01-18','','2022-01-18 12:06:25','401','401',2022,'401','2022-01-18 12:06:25',5),('5','97',18492,'615',33130.20,150.00,'2022-01-18','','2022-01-18 12:06:56','401','401',2022,'401','2022-01-18 12:06:56',5),('5','97',18503,'614',146.09,2200.00,'2022-01-17','','2022-01-19 12:36:47','401','401',2022,'401','2022-01-19 12:36:47',5),('5','97',18550,'614',8143.70,10000.00,'2022-01-23','','2022-01-24 16:39:03','401','401',2022,'401','2022-01-24 16:39:03',5),('5','97',18568,'614',500.00,2000.00,'2022-01-25','','2022-01-26 23:19:58','401','401',2022,'401','2022-01-26 23:19:58',5),('5','97',18569,'616',16450.70,643.00,'2022-02-11','','2022-02-11 11:57:50','600','600',2022,'600','2022-02-11 11:57:50',5),('5','97',18570,'614',42226.88,150.00,'2022-02-11','','2022-02-11 21:12:22','401','401',2022,'401','2022-02-11 21:12:22',5),('5','97',18571,'615',38189.13,150.00,'2022-02-11','','2022-02-11 21:12:48','401','401',2022,'401','2022-02-11 21:12:48',5),('5','97',18572,'614',150.00,1500.00,'2022-02-15','','2022-02-15 23:40:02','401','401',2022,'401','2022-02-15 23:40:02',5),('5','97',18573,'614',1547.18,8000.00,'2022-02-21','','2022-02-21 22:02:12','401','401',2022,'401','2022-02-21 22:02:12',5),('5','97',18574,'614',26552.95,9000.00,'2022-02-23','','2022-02-23 06:20:08','401','401',2022,'401','2022-02-23 06:20:08',5),('5','97',18575,'614',499.31,8300.00,'2022-02-24','','2022-02-24 20:27:37','401','401',2022,'401','2022-02-24 20:27:37',5),('5','97',18576,'614',242.48,2500.00,'2022-02-25','','2022-02-25 23:24:48','401','401',2022,'401','2022-02-25 23:24:48',5),('5','97',18577,'615',375.67,6500.00,'2022-02-25','','2022-02-25 23:25:36','401','401',2022,'401','2022-02-25 23:25:36',5),('5','97',18578,'616',643.00,150.00,'2022-03-05','','2022-03-07 12:32:31','401','401',2022,'401','2022-03-07 12:32:31',5),('5','97',18579,'617',200.00,600.00,'2022-03-05','','2022-03-07 12:33:11','401','401',2022,'401','2022-03-07 12:33:11',5),('5','97',18580,'614',381.90,700.00,'2022-03-05','','2022-03-07 16:24:55','401','401',2022,'401','2022-03-07 16:24:55',5),('5','97',18581,'614',111.82,9000.00,'2022-03-06','','2022-03-09 00:42:31','401','401',2022,'401','2022-03-09 00:42:31',5),('5','97',18582,'614',9000.00,9200.00,'2022-03-05','','2022-03-09 00:47:56','401','401',2022,'401','2022-03-09 00:47:56',5),('5','97',18583,'614',209.04,10000.00,'2022-03-07','','2022-03-09 10:45:09','401','401',2022,'401','2022-03-09 10:45:09',5),('5','97',18584,'614',210.47,9000.00,'2022-03-08','','2022-03-10 10:44:54','401','401',2022,'401','2022-03-10 10:44:54',5),('5','97',18585,'614',401.33,10000.00,'2022-03-09','','2022-03-10 23:41:40','401','401',2022,'401','2022-03-10 23:41:40',5),('5','97',18586,'614',40435.55,200.00,'2022-03-11','','2022-03-12 23:15:48','401','401',2022,'401','2022-03-12 23:15:48',5),('5','97',18587,'617',600.00,2000.00,'2022-03-14','','2022-03-14 22:34:10','401','401',2022,'401','2022-03-14 22:34:10',5),('5','97',18588,'614',749.79,7200.00,'2022-03-25','','2022-03-26 23:15:23','401','401',2022,'401','2022-03-26 23:15:23',5),('5','97',18589,'614',234.52,5000.00,'2022-03-28','','2022-03-28 00:11:29','401','401',2022,'401','2022-03-28 00:11:29',5),('5','97',18590,'614',5000.00,10000.00,'2022-03-28','','2022-03-28 00:14:05','401','401',2022,'401','2022-03-28 00:14:05',5),('5','97',18591,'615',2166.11,3000.00,'2022-03-29','','2022-03-31 10:16:11','401','401',2022,'401','2022-03-31 10:16:11',5),('5','97',18592,'617',1220.43,5700.00,'2022-03-29','','2022-03-31 10:17:00','401','401',2022,'401','2022-03-31 10:17:00',5),('5','97',18593,'614',2447.29,9000.00,'2022-04-04','','2022-04-04 22:39:14','401','401',2022,'401','2022-04-04 22:39:14',5),('5','97',18594,'614',885.21,10500.00,'2022-04-05','','2022-04-05 23:55:58','401','401',2022,'401','2022-04-05 23:55:58',5),('5','97',18595,'614',454.96,1500.00,'2022-04-06','','2022-04-06 23:47:04','401','401',2022,'401','2022-04-06 23:47:04',5),('5','97',18596,'614',14.89,4500.00,'2022-04-08','','2022-04-08 23:32:28','401','401',2022,'401','2022-04-08 23:32:28',5),('5','97',18597,'615',2662.94,5000.00,'2022-04-08','','2022-04-08 23:33:22','401','401',2022,'401','2022-04-08 23:33:22',5),('5','97',18598,'618',500.00,350.00,'2022-04-10','','2022-04-10 04:34:58','401','401',2022,'401','2022-04-10 04:34:58',5),('5','97',18599,'615',108.25,3500.00,'2022-04-10','','2022-04-10 04:39:09','401','401',2022,'401','2022-04-10 04:39:09',5),('5','97',18600,'615',68.47,1400.00,'2022-04-10','','2022-04-10 23:06:08','401','401',2022,'401','2022-04-10 23:06:08',5),('5','97',18601,'615',8485.22,9500.00,'2022-04-13','','2022-04-13 14:52:59','401','401',2022,'401','2022-04-13 14:52:59',5),('5','97',18602,'614',30416.16,500.00,'2022-04-19','','2022-04-19 12:10:30','401','401',2022,'401','2022-04-19 12:10:30',5),('5','97',18603,'617',29576.36,200.00,'2022-04-19','','2022-04-19 13:09:57','401','401',2022,'401','2022-04-19 13:09:57',5),('5','97',18604,'614',346.57,9000.00,'2022-04-25','','2022-04-25 23:29:18','401','401',2022,'401','2022-04-25 23:29:18',5),('5','97',18605,'619',0.00,9000.00,'2022-04-25','','2022-04-26 21:57:13','401','401',2022,'401','2022-04-26 21:57:13',5),('5','97',18606,'614',407.50,9000.00,'2022-04-24','','2022-04-26 22:00:11','401','401',2022,'401','2022-04-26 22:00:11',5),('5','97',18607,'615',345.01,30000.00,'2022-04-30','','2022-05-09 11:42:34','401','401',2022,'401','2022-05-09 11:42:34',5),('5','97',18608,'614',26166.46,200.00,'2022-05-11','','2022-05-13 14:46:24','401','401',2022,'401','2022-05-13 14:46:24',5),('5','97',18609,'614',25263.82,450.00,'2022-05-19','','2022-05-20 23:58:14','401','401',2022,'401','2022-05-20 23:58:14',5),('5','97',18610,'615',4713.91,8500.00,'2022-05-24','','2022-05-24 00:11:48','401','401',2022,'401','2022-05-24 00:11:48',5),('5','97',18611,'614',5729.97,7500.00,'2022-05-26','','2022-05-26 23:19:01','401','401',2022,'401','2022-05-26 23:19:01',5),('5','97',18612,'614',384.55,700.00,'2022-05-27','','2022-05-27 23:59:46','401','401',2022,'401','2022-05-27 23:59:46',5),('5','97',18613,'614',152.68,6500.00,'2022-05-28','','2022-05-28 16:58:25','401','401',2022,'401','2022-05-28 16:58:25',5),('5','97',18614,'614',321.50,2000.00,'2022-05-29','','2022-05-29 23:14:30','401','401',2022,'401','2022-05-29 23:14:30',5),('5','97',18615,'614',130.10,700.00,'2022-05-30','','2022-05-30 18:27:26','401','401',2022,'401','2022-05-30 18:27:26',5),('5','97',18616,'614',700.00,7000.00,'2022-05-30','','2022-05-30 18:29:29','401','401',2022,'401','2022-05-30 18:29:29',5),('5','97',18617,'615',645.11,3000.00,'2022-06-02','','2022-06-02 00:04:08','401','401',2022,'401','2022-06-02 00:04:08',5),('5','97',18618,'615',856.31,2300.00,'2022-06-03','','2022-06-03 22:19:47','401','401',2022,'401','2022-06-03 22:19:47',5),('5','97',18619,'615',200.00,3300.00,'2022-06-18','','2022-06-18 21:55:50','401','401',2022,'401','2022-06-18 21:55:50',5),('5','97',18620,'615',124.17,3500.00,'2022-06-20','','2022-06-20 00:00:52','401','401',2022,'401','2022-06-20 00:00:52',5),('5','97',18621,'614',28614.16,200.00,'2022-07-13','','2022-07-13 14:37:12','401','401',2022,'401','2022-07-13 14:37:12',5),('5','97',18622,'617',-975.90,200.00,'2022-07-14','','2022-07-14 19:54:30','401','401',2022,'401','2022-07-14 19:54:30',5),('5','97',18623,'615',4835.41,6500.00,'2022-07-22','','2022-07-22 10:25:30','401','401',2022,'401','2022-07-22 10:25:30',5),('5','97',18624,'616',150.00,2000.00,'2022-07-22','','2022-07-22 10:26:34','401','401',2022,'401','2022-07-22 10:26:34',5),('5','97',18625,'614',590.74,4000.00,'2022-08-02','','2022-08-02 21:46:07','401','401',2022,'401','2022-08-02 21:46:07',5),('5','97',18626,'614',163.51,4000.00,'2022-08-03','','2022-08-03 17:18:20','401','401',2022,'401','2022-08-03 17:18:20',5),('5','97',18627,'615',28275.73,18000.00,'2022-08-05','','2022-08-05 12:34:20','401','401',2022,'401','2022-08-05 12:34:20',5),('5','97',18628,'614',10081.23,35000.00,'2022-08-12','','2022-09-05 14:59:22','401','401',2022,'401','2022-09-05 14:59:22',5),('5','97',18629,'615',14778.89,30000.00,'2022-08-10','','2022-09-05 14:59:57','401','401',2022,'401','2022-09-05 14:59:57',5),('5','97',18630,'616',443.75,35000.00,'2022-08-08','','2022-09-05 15:00:32','401','401',2022,'401','2022-09-05 15:00:32',5),('5','97',18631,'617',200.00,40000.00,'2022-09-01','','2022-09-05 15:00:55','401','401',2022,'401','2022-09-05 15:00:55',5),('5','97',18632,'615',2037.05,40000.00,'2022-08-22','','2022-09-06 13:42:12','401','401',2022,'401','2022-09-06 13:42:12',5),('5','97',18633,'614',4595.25,40000.00,'2022-08-28','','2022-09-06 15:29:40','401','401',2022,'401','2022-09-06 15:29:40',5),('5','97',18634,'617',1655.81,40000.00,'2022-08-28','','2022-09-06 15:30:06','401','401',2022,'401','2022-09-06 15:30:06',5),('5','97',18635,'614',17967.79,1000.00,'2022-09-07','','2022-09-07 09:53:08','401','401',2022,'401','2022-09-07 09:53:08',5),('5','97',18636,'614',1000.00,400.00,'2022-09-07','','2022-09-07 09:55:32','401','401',2022,'401','2022-09-07 09:55:32',5),('5','97',18637,'616',5671.00,150.00,'2022-09-07','','2022-09-07 09:59:52','401','401',2022,'401','2022-09-07 09:59:52',5),('5','97',18638,'617',36075.49,500.00,'2022-09-06','','2022-09-08 11:12:54','401','401',2022,'401','2022-09-08 11:12:54',5),('5','97',18639,'616',44594.34,100.00,'2022-09-07','','2022-09-08 11:13:25','401','401',2022,'401','2022-09-08 11:13:25',5),('5','97',18640,'617',30000.00,700.00,'2022-09-12','','2022-09-12 14:31:32','401','401',2022,'401','2022-09-12 14:31:32',5),('5','97',18641,'616',29700.00,150.00,'2022-09-12','','2022-09-12 14:31:54','401','401',2022,'401','2022-09-12 14:31:54',5),('5','97',18642,'616',45010.00,150.00,'2022-09-15','','2022-09-15 13:11:50','401','401',2022,'401','2022-09-15 13:11:50',5),('5','97',18643,'615',5772.00,6500.00,'2022-10-28','','2022-10-28 00:27:33','401','401',2022,'401','2022-10-28 00:27:33',5),('5','97',18644,'615',198.52,9000.00,'2022-11-01','','2022-11-01 21:30:29','401','401',2022,'401','2022-11-01 21:30:29',5),('5','97',18645,'617',700.00,5000.00,'2022-11-03','','2022-11-03 21:43:51','401','401',2022,'401','2022-11-03 21:43:51',5),('5','97',18646,'617',5000.00,5000.00,'2022-11-03','','2022-11-03 21:43:52','401','401',2022,'401','2022-11-03 21:43:52',5),('5','97',18647,'617',63.92,5000.00,'2022-11-05','','2022-11-05 22:22:34','401','401',2022,'401','2022-11-05 22:22:34',5),('5','97',18648,'617',236.35,5000.00,'2022-11-05','','2022-11-06 23:35:03','401','401',2022,'401','2022-11-06 23:35:03',5),('5','97',18649,'615',3679.16,10000.00,'2022-11-05','','2022-11-06 23:35:46','401','401',2022,'401','2022-11-06 23:35:46',5),('5','97',18650,'615',1855.70,6000.00,'2022-11-06','','2022-11-07 10:05:21','401','401',2022,'401','2022-11-07 10:05:21',5),('5','97',18651,'614',6496.45,6500.00,'2022-11-06','','2022-11-08 08:40:14','401','401',2022,'401','2022-11-08 08:40:14',5),('5','97',18652,'615',252.45,4500.00,'2022-11-06','','2022-11-08 08:40:51','401','401',2022,'401','2022-11-08 08:40:51',5),('5','97',18653,'614',621.61,2500.00,'2022-11-10','','2022-11-11 21:37:34','401','401',2022,'401','2022-11-11 21:37:34',5),('5','97',18654,'614',17746.78,600.00,'2022-11-21','','2022-11-21 13:39:03','600','600',2022,'600','2022-11-21 13:39:03',5),('5','97',18655,'614',694.00,3000.00,'2022-11-21','','2022-11-21 23:24:50','401','401',2022,'401','2022-11-21 23:24:50',5),('5','97',18656,'615',3545.36,6000.00,'2022-11-21','','2022-11-21 23:28:20','401','401',2022,'401','2022-11-21 23:28:20',5),('5','97',18657,'614',2822.04,5000.00,'2022-11-30','','2022-11-30 22:14:10','401','401',2022,'401','2022-11-30 22:14:10',5),('5','97',18658,'614',328.74,4000.00,'2022-12-01','','2022-12-01 23:09:11','401','401',2022,'401','2022-12-01 23:09:11',5),('5','97',18659,'615',1728.83,5000.00,'2022-12-01','','2022-12-01 23:09:31','401','401',2022,'401','2022-12-01 23:09:31',5),('5','97',18660,'615',212.05,8500.00,'2022-12-02','','2022-12-02 23:53:58','401','401',2022,'401','2022-12-02 23:53:58',5),('5','97',18661,'614',509.50,4000.00,'2022-12-03','','2022-12-03 21:51:33','401','401',2022,'401','2022-12-03 21:51:33',5),('5','97',18662,'615',294.44,3500.00,'2022-12-03','','2022-12-03 21:51:59','401','401',2022,'401','2022-12-03 21:51:59',5),('5','97',18663,'614',171.26,1000.00,'2022-12-05','','2022-12-05 01:06:35','401','401',2022,'401','2022-12-05 01:06:35',5),('5','97',18664,'615',233.50,4000.00,'2022-12-04','','2022-12-05 01:07:02','401','401',2022,'401','2022-12-05 01:07:02',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1732 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','97','614',1713,'5','PUMP 1',2684231.40,'','',NULL,NULL,'',5,'2021-02-28 10:42:29','600'),('5','97','614',1714,'5','PUMP 2',2203681.30,'','',NULL,NULL,'',5,'2021-02-28 10:44:24','600'),('5','97','615',1715,'5','PUMP 3',2390939.05,'','',NULL,NULL,'',5,'2021-02-28 10:45:47','600'),('5','97','615',1716,'5','PUMP 4',2056815.71,'','',NULL,NULL,'',5,'2021-02-28 10:47:52','600'),('5','97','616',1717,'5','PUMP 5',410698.91,'','',NULL,NULL,'',5,'2021-02-28 10:49:00','600'),('5','97','616',1718,'5','PUMP 6',885753.92,'','',NULL,NULL,'',5,'2021-02-28 10:49:56','600'),('5','97','617',1719,'5','PUMP 7',601092.68,'','',NULL,NULL,'',5,'2021-02-28 10:51:05','600'),('5','97','617',1720,'5','PUMP 8',1137184.87,'','',NULL,NULL,'',5,'2021-02-28 10:52:46','600'),('5','97','616',1721,'5','PUMP 9',186827.43,'','',NULL,NULL,'',5,'2021-10-13 13:13:54','600'),('5','97','616',1722,'5','PUMP 13',454627.28,'',NULL,NULL,NULL,NULL,5,'2020-02-05 14:14:12','401'),('5','97','616',1723,'5','PUMP 14',247545.47,'',NULL,NULL,NULL,NULL,5,'2020-02-05 13:01:55','401'),('5','97','616',1724,'5','PUMP 15',323981.33,'',NULL,NULL,NULL,NULL,5,'2020-02-05 13:03:37','401'),('5','97','616',1725,'5','PUMP 16',324999.90,'',NULL,NULL,NULL,NULL,5,'2020-02-05 14:15:33','401'),('5','97','617',1726,'5','PUMP 10',88667.56,'','',NULL,NULL,'',5,'2021-10-13 13:14:35','600'),('5','97','617',1727,'5','PUMP 11',245354.39,'',NULL,NULL,NULL,NULL,5,'2020-02-05 12:57:29','401'),('5','97','617',1728,'5','PUMP 12',199309.14,'',NULL,NULL,NULL,NULL,5,'2020-02-05 12:59:03','401'),('5','97','618',1729,'5','PUMP 17',816827.43,'','',NULL,NULL,'',5,'2021-02-28 10:57:54','600'),('5','97','618',1730,'5','PUMP 18',395771.40,'',NULL,NULL,NULL,NULL,5,'2020-02-05 14:17:18','401'),('5','97','619',1731,'5','PUMP 19',88667.56,'','',NULL,NULL,'',5,'2021-02-28 10:59:40','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (131,'5','97','1715','615','PMS TANKS CONNECTION ERROR.','2021-03-19 14:15:00',0,'600'),(132,'5','97','1716','615','PMS TANKS CONNECTION ERROR.','2021-03-19 14:16:05',0,'600'),(133,'5','97','1717','616','PMS TANKS CONNECTION ERROR.','2021-03-19 14:17:04',0,'600'),(134,'5','97','1718','616','PMS TANKS CONNECTION ERROR.','2021-03-19 14:17:52',0,'600'),(135,'5','97','1719','617','PMS TANKS CONNECTION ERROR.','2021-03-19 14:18:52',0,'600'),(136,'5','97','1720','617','PMS TANKS CONNECTION ERROR.','2021-03-19 14:20:06',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257881 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','97',231242,'Full time shift','2021-10-01','2021-10-01 00:00:00',NULL,'401',181683.06,181683.06,'401','2021-10-13 14:10:45','607','2021-10-13 14:14:52',10,0),('5','97',231253,'Full time shift','2021-10-02','2021-10-02 00:00:00',NULL,'401',138550.00,138550.00,'401','2021-10-13 14:22:21','607','2021-10-13 14:29:08',10,0),('5','97',231262,'Full time shift','2021-10-03','2021-10-03 00:00:00',NULL,'401',1269685.24,1269685.24,'401','2021-10-13 14:35:15','607','2021-10-13 14:37:58',10,0),('5','97',231269,'Full time shift','2021-10-04','2021-10-04 00:00:00',NULL,'401',1306934.00,1306934.00,'401','2021-10-13 14:42:55','607','2021-10-13 14:45:33',10,0),('5','97',231272,'Full time shift','2021-10-05','2021-10-05 00:00:00',NULL,'401',1119614.40,1119614.40,'401','2021-10-13 14:47:54','607','2021-10-13 14:57:17',10,0),('5','97',231278,'Full time shift','2021-10-06','2021-10-06 00:00:00',NULL,'401',1364632.74,1364632.74,'401','2021-10-13 15:03:23','607','2021-10-13 15:06:24',10,0),('5','97',231281,'Full time shift','2021-10-07','2021-10-07 00:00:00',NULL,'401',213042.63,213042.63,'401','2021-10-13 15:12:59','607','2021-10-13 15:15:08',10,0),('5','97',231289,'Full time shift','2021-10-08','2021-10-08 00:00:00',NULL,'401',0.00,0.00,'401','2021-10-13 15:31:20','607','2021-10-13 15:34:33',10,0),('5','97',231291,'Full time shift','2021-10-09','2021-10-09 00:00:00',NULL,'401',0.00,0.00,'401','2021-10-13 15:35:45','607','2021-10-13 15:36:31',10,0),('5','97',231293,'Full time shift','2021-10-10','2021-10-10 00:00:00',NULL,'401',0.00,0.00,'401','2021-10-13 15:38:10','607','2021-10-13 15:38:45',10,0),('5','97',231294,'Full time shift','2021-10-11','2021-10-11 00:00:00',NULL,'401',318325.96,318325.96,'401','2021-10-13 15:41:00','607','2021-10-13 15:41:21',10,0),('5','97',231296,'Full time shift','2021-10-12','2021-10-12 00:00:00',NULL,'401',762217.34,762217.34,'401','2021-10-13 15:45:40','607','2021-10-13 15:45:57',10,0),('5','97',231303,'Full time shift','2021-10-13','2021-10-13 00:00:00',NULL,'401',1595802.60,1595802.60,'401','2021-10-13 21:38:06','607','2021-10-14 05:39:23',10,0),('5','97',231404,'Full time shift','2021-10-14','2021-10-14 00:00:00',NULL,'401',1515362.10,1515362.10,'401','2021-10-14 22:13:49','607','2021-10-15 10:06:08',10,0),('5','97',231759,'Full time shift','2021-10-15','2021-10-15 00:00:00',NULL,'401',1229142.25,1229142.25,'401','2021-10-15 21:01:23','607','2021-10-16 06:39:01',10,0),('5','97',231916,'Full time shift','2021-10-16','2021-10-16 00:00:00',NULL,'401',1262526.28,1262526.28,'401','2021-10-16 20:31:54','607','2021-10-17 00:08:06',10,0),('5','97',232088,'Full time shift','2021-10-17','2021-10-17 00:00:00',NULL,'401',1452727.72,1452727.72,'401','2021-10-17 20:40:45','607','2021-10-17 22:14:17',10,0),('5','97',232384,'Full time shift','2021-10-18','2021-10-18 00:00:00',NULL,'401',1351778.56,1351778.56,'401','2021-10-18 20:15:26','607','2021-10-19 07:33:18',10,0),('5','97',232638,'Full time shift','2021-10-19','2021-10-19 00:00:00',NULL,'401',1239108.07,1239108.07,'401','2021-10-19 23:02:53','607','2021-10-19 23:27:42',10,0),('5','97',232866,'Full time shift','2021-10-20','2021-10-20 00:00:00',NULL,'401',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','97',233071,'Full time shift','2021-10-20','2021-10-20 00:00:00',NULL,'401',612893.04,612893.04,'401','2021-10-20 19:33:10','607','2021-10-21 08:33:57',10,0),('5','97',233172,'Full time shift','2021-10-21','2021-10-21 00:00:00',NULL,'401',0.00,0.00,'401','2021-10-21 21:11:04','607','2021-10-22 09:16:42',10,0),('5','97',233480,'Full time shift','2021-10-22','2021-10-22 00:00:00',NULL,'401',0.00,0.00,'401','2021-10-22 21:53:39','607','2021-10-23 08:02:43',10,0),('5','97',233811,'Full time shift','2021-10-23','2021-10-23 00:00:00',NULL,'401',211900.00,211900.00,'401','2021-10-23 21:24:46','607','2021-10-23 22:38:09',10,0),('5','97',233826,'Full time shift','2021-10-24','2021-10-24 00:00:00',NULL,'401',1565716.06,1565716.06,'401','2021-10-24 21:23:21','607','2021-10-25 11:13:12',10,0),('5','97',234178,'Full time shift','2021-10-25','2021-10-25 00:00:00',NULL,'401',1607626.62,1607626.62,'401','2021-10-25 22:55:29','607','2021-10-26 08:27:15',10,0),('5','97',234423,'Full time shift','2021-10-26','2021-10-26 00:00:00',NULL,'401',994300.00,1006500.00,'401','2021-10-26 20:57:31','607','2021-10-27 06:19:25',10,0),('5','97',234645,'Full time shift','2021-10-27','2021-10-27 00:00:00',NULL,'401',252896.13,255999.15,'401','2021-10-27 21:56:05','607','2021-10-28 09:16:54',10,0),('5','97',234952,'Full time shift','2021-10-28','2021-10-28 00:00:00',NULL,'401',0.00,0.00,'401','2021-10-28 19:06:40','607','2021-10-29 08:43:26',10,0),('5','97',235163,'Full time shift','2021-10-29','2021-10-29 00:00:00',NULL,'401',0.00,0.00,'401','2021-10-29 21:38:41','607','2021-10-30 16:47:01',10,0),('5','97',235497,'Full time shift','2021-10-30','2021-10-30 00:00:00',NULL,'401',112282.50,112282.50,'401','2021-10-30 21:50:22','607','2021-10-30 22:03:02',10,0),('5','97',235569,'Full time shift','2021-10-31','2021-10-31 00:00:00',NULL,'401',2255008.80,2255008.80,'401','2021-10-31 21:06:40','607','2021-11-01 08:45:04',10,0),('5','97',235909,'Full time shift','2021-11-01','2021-11-01 00:00:00',NULL,'401',542640.45,542640.45,'401','2021-11-01 22:17:49','607','2021-11-02 09:09:56',10,0),('5','97',236098,'Full time shift','2021-11-02','2021-11-02 00:00:00',NULL,'401',2506622.25,2506622.25,'401','2021-11-02 23:27:01','607','2021-11-03 08:58:51',10,0),('5','97',236413,'Full time shift','2021-11-03','2021-11-03 00:00:00',NULL,'401',2059987.05,2059987.05,'401','2021-11-03 21:29:54','607','2021-11-04 10:32:26',10,0),('5','97',236701,'Full time shift','2021-11-04','2021-11-04 00:00:00',NULL,'401',2287386.75,2287386.75,'401','2021-11-04 20:40:46','607','2021-11-05 10:15:01',10,0),('5','97',236856,'Full time shift','2021-11-05','2021-11-05 00:00:00',NULL,'401',2125968.90,2125968.90,'401','2021-11-05 23:25:45','600','2021-11-07 08:11:21',10,0),('5','97',237580,'Full time Shift','2021-11-06','2021-11-06 00:00:00',NULL,'401',247633.65,247633.65,'401','2021-11-08 22:15:33','600','2021-11-09 08:37:35',10,0),('5','97',237712,'Full time Shift','2021-11-07','2021-11-07 00:00:00',NULL,'401',0.00,0.00,'401','2021-11-09 11:48:58','600','2021-11-10 12:49:25',10,0),('5','97',238031,'Full time Shift','2021-11-08','2021-11-08 00:00:00',NULL,'401',179685.00,179685.00,'401','2021-11-10 14:16:26','600','2021-11-10 14:33:30',10,0),('5','97',238039,'Full time Shift','2021-11-09','2021-11-09 00:00:00',NULL,'401',1901620.05,1901620.05,'401','2021-11-10 14:39:21','600','2021-11-10 21:15:51',10,0),('5','97',238181,'Full time Shift','2021-11-10','2021-11-10 00:00:00',NULL,'401',2635594.50,2635594.50,'401','2021-11-11 08:20:51','600','2021-11-11 08:23:29',10,0),('5','97',238250,'Full time Shift','2021-11-11','2021-11-11 00:00:00',NULL,'401',1982668.05,1982668.05,'401','2021-11-11 23:19:34','600','2021-11-12 08:14:12',10,0),('5','97',238439,'Full time shift','2021-11-12','2021-11-12 00:00:00',NULL,'401',2321871.75,2321871.75,'401','2021-11-12 21:48:34','600','2021-11-13 09:57:17',10,0),('5','97',238772,'Full time shift','2021-11-13','2021-11-13 00:00:00',NULL,'401',3042827.70,3042827.70,'401','2021-11-13 22:30:42','600','2021-11-14 09:39:11',10,0),('5','97',239030,'Full time shift','2021-11-14','2021-11-14 00:00:00',NULL,'401',2966873.25,2966873.25,'401','2021-11-14 21:36:48','600','2021-11-15 08:16:17',10,0),('5','97',239168,'Full time shift','2021-11-15','2021-11-15 00:00:00',NULL,'401',3091786.50,3091786.50,'401','2021-11-15 22:33:36','600','2021-11-16 08:06:01',10,0),('5','97',239422,'Full time shift497','2021-11-16','2021-11-16 00:00:00',NULL,'401',2877845.85,2877845.85,'401','2021-11-16 23:09:49','600','2021-11-17 08:04:19',10,0),('5','97',239633,'Full time shift','2021-11-17','2021-11-17 00:00:00',NULL,'401',2423381.40,2423381.40,'401','2021-11-17 21:44:32','600','2021-11-18 09:47:26',10,0),('5','97',239862,'Full time shift','2021-11-18','2021-11-18 00:00:00',NULL,'401',2376023.10,2376023.10,'401','2021-11-18 22:43:09','600','2021-11-19 08:10:55',10,0),('5','97',240075,'Full time shift','2021-11-19','2021-11-19 00:00:00',NULL,'401',1762632.30,1762632.30,'401','2021-11-19 21:23:02','600','2021-11-20 08:19:07',10,0),('5','97',240255,'Full time shift','2021-11-20','2021-11-20 00:00:00',NULL,'401',2046221.10,2046221.10,'401','2021-11-20 22:01:21','600','2021-11-21 19:44:06',10,0),('5','97',240620,'Full time shift','2021-11-21','2021-11-21 00:00:00',NULL,'401',2252523.90,2252523.90,'401','2021-11-21 20:27:39','600','2021-11-22 07:58:38',10,0),('5','97',240755,'Full time shift','2021-11-22','2021-11-22 00:00:00',NULL,'401',1886880.60,1886880.60,'401','2021-11-22 22:03:06','600','2021-11-23 06:08:36',10,0),('5','97',241045,'Full time shift','2021-11-23','2021-11-23 00:00:00',NULL,'401',1841639.25,1841639.25,'401','2021-11-23 22:20:32','600','2021-11-24 08:43:16',10,0),('5','97',241321,'Full time shift','2021-11-24','2021-11-24 00:00:00',NULL,'401',2466740.10,2466740.10,'401','2021-11-24 23:39:57','600','2021-11-25 07:53:01',10,0),('5','97',241577,'Full time shift','2021-11-25','2021-11-25 00:00:00',NULL,'401',2724140.10,2724140.10,'401','2021-11-25 22:19:39','600','2021-11-26 08:25:05',10,0),('5','97',241953,'Full time shift','2021-11-26','2021-11-26 00:00:00',NULL,'401',1722548.85,1722548.85,'401','2021-11-26 23:25:17','600','2021-11-27 07:54:32',10,0),('5','97',242099,'Full time shift','2021-11-27','2021-11-27 00:00:00',NULL,'401',1253189.85,1253189.85,'401','2021-11-27 21:41:05','600','2021-11-28 13:38:59',10,0),('5','97',242319,'Full time shift','2021-11-28','2021-11-28 00:00:00',NULL,'401',168049.20,168049.20,'401','2021-11-29 10:31:13','600','2021-11-29 14:01:13',10,0),('5','97',242585,'Full time shift','2021-11-29','2021-11-29 00:00:00',NULL,'401',0.00,0.00,'401','2021-11-29 19:15:36','600','2021-11-30 08:49:20',10,0),('5','97',242799,'Full time shift','2021-11-30','2021-11-30 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-01 05:16:32','600','2021-12-01 08:35:36',10,0),('5','97',243001,'Full time shift','2021-12-01','2021-12-01 00:00:00',NULL,'401',105791.40,105791.40,'401','2021-12-01 20:22:59','600','2021-12-02 07:18:43',10,0),('5','97',243238,'Full time shift','2021-12-02','2021-12-02 00:00:00',NULL,'401',2341165.20,2341165.20,'401','2021-12-02 22:46:30','600','2021-12-03 09:18:18',10,0),('5','97',243628,'Full time shift','2021-12-03','2021-12-03 00:00:00',NULL,'401',2172142.50,2172142.50,'401','2021-12-04 07:10:19','600','2021-12-04 10:41:12',10,0),('5','97',243737,'Full time shift','2021-12-04','2021-12-04 00:00:00',NULL,'401',2853818.55,2853818.55,'401','2021-12-04 22:21:59','600','2021-12-05 07:48:51',10,0),('5','97',244015,'Full time shift','2021-12-05','2021-12-05 00:00:00',NULL,'401',2241252.75,2241252.75,'401','2021-12-05 21:27:51','600','2021-12-06 08:57:02',10,0),('5','97',244257,'Full time shift','2021-12-06','2021-12-06 00:00:00',NULL,'401',2093145.45,2093145.45,'401','2021-12-06 21:44:07','604','2021-12-07 10:27:17',10,0),('5','97',244492,'Full time shift','2021-12-07','2021-12-07 00:00:00',NULL,'401',1582041.45,1582041.45,'401','2021-12-07 23:47:00','600','2021-12-08 08:24:25',10,0),('5','97',244712,'Full time shift','2021-12-08','2021-12-08 00:00:00',NULL,'401',785416.50,785416.50,'401','2021-12-08 22:15:30','600','2021-12-09 03:52:30',10,0),('5','97',244816,'Full time shift','2021-12-09','2021-12-09 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-09 22:07:30','600','2021-12-10 10:50:04',10,0),('5','97',245085,'Full time shift','2021-12-10','2021-12-10 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-10 23:00:58','604','2021-12-11 05:36:13',10,0),('5','97',245378,'Full time shift','2021-12-11','2021-12-11 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-11 17:51:32','600','2021-12-12 03:42:40',10,0),('5','97',245622,'Full time shift','2021-12-12','2021-12-12 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-12 19:20:47','600','2021-12-13 10:34:16',10,0),('5','97',245779,'Full time shift','2021-12-13','2021-12-13 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-13 21:45:58','600','2021-12-14 08:47:51',10,0),('5','97',246037,'Full time shift','2021-12-14','2021-12-14 00:00:00',NULL,'401',105649.50,105649.50,'401','2021-12-14 20:12:13','600','2021-12-15 09:13:37',10,0),('5','97',246295,'Full time shift','2021-12-15','2021-12-15 00:00:00',NULL,'401',2165592.00,2165592.00,'401','2021-12-15 21:14:19','600','2021-12-16 03:50:16',10,0),('5','97',246678,'Full time shift','2021-12-16','2021-12-16 00:00:00',NULL,'401',1740495.90,1740495.90,'401','2021-12-16 21:32:49','600','2021-12-17 09:38:32',10,0),('5','97',246815,'Full time shift','2021-12-17','2021-12-17 00:00:00',NULL,'401',1685331.45,1685331.45,'401','2021-12-17 22:39:49','600','2021-12-18 04:01:47',10,0),('5','97',246920,'Full time shift','2021-12-18','2021-12-18 00:00:00',NULL,'401',1709264.70,1709264.70,'401','2021-12-18 21:35:57','600','2021-12-19 07:53:45',10,0),('5','97',247255,'Full time shift','2021-12-19','2021-12-19 00:00:00',NULL,'401',1654265.25,1654265.25,'401','2021-12-19 20:25:35','600','2021-12-20 09:26:49',10,0),('5','97',247505,'Full time shift','2021-12-20','2021-12-20 00:00:00',NULL,'401',364316.70,364316.70,'401','2021-12-20 21:59:51','600','2021-12-21 07:55:04',10,0),('5','97',247714,'Full time shift','2021-12-21','2021-12-21 00:00:00',NULL,'401',1429705.20,1429705.20,'401','2021-12-21 22:49:13','600','2021-12-22 07:58:51',10,0),('5','97',247987,'Full time shift','2021-12-22','2021-12-22 00:00:00',NULL,'401',1710865.20,1710865.20,'401','2021-12-22 21:48:05','600','2021-12-23 08:22:03',10,0),('5','97',248230,'Full time shift','2021-12-23','2021-12-23 00:00:00',NULL,'401',1260972.90,1260972.90,'401','2021-12-24 09:26:33','600','2021-12-24 14:10:09',10,0),('5','97',248622,'Full time shift','2021-12-24','2021-12-24 00:00:00',NULL,'401',495024.75,495024.75,'401','2021-12-24 23:38:32','600','2021-12-25 08:24:31',10,0),('5','97',248729,'Full time shift','2021-12-25','2021-12-25 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-25 20:40:57','600','2021-12-26 07:11:54',10,0),('5','97',249087,'Full time shift','2021-12-26','2021-12-26 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-26 23:51:22','600','2021-12-27 12:11:59',10,0),('5','97',249318,'Full time shift','2021-12-27','2021-12-27 00:00:00',NULL,'401',0.00,0.00,'401','2021-12-27 20:33:12','600','2021-12-28 07:33:27',10,0),('5','97',249438,'Full time shift','2021-12-28','2021-12-28 00:00:00',NULL,'401',206299.50,206299.50,'401','2021-12-28 23:46:32','600','2021-12-29 08:39:07',10,0),('5','97',249672,'Full time shift','2021-12-29','2021-12-29 00:00:00',NULL,'401',1742338.95,1742338.95,'401','2021-12-29 22:20:11','600','2021-12-30 07:59:53',10,0),('5','97',249986,'Full time shift','2021-12-30','2021-12-30 00:00:00',NULL,'401',2319814.20,2319814.20,'401','2021-12-30 23:36:09','600','2021-12-31 08:46:09',10,0),('5','97',250312,'Full time shift','2021-12-31','2021-12-31 00:00:00',NULL,'401',2258302.20,2258302.20,'401','2021-12-31 23:04:49','600','2022-01-01 08:35:05',10,0),('5','97',250542,'Full time shift','2022-01-01','2022-01-01 00:00:00',NULL,'401',1409240.25,1409240.25,'401','2022-01-01 22:27:15','600','2022-01-02 09:28:23',10,0),('5','97',250860,'Full time shift','2022-01-02','2022-01-02 00:00:00',NULL,'401',3213775.95,3213775.95,'401','2022-01-03 08:56:08','600','2022-01-03 10:14:16',10,0),('5','97',250961,'Full time shift','2022-01-03','2022-01-03 00:00:00',NULL,'401',3218872.80,3218872.80,'401','2022-01-03 21:45:07','600','2022-01-04 08:32:06',10,0),('5','97',251097,'Full time shift','2022-01-04','2022-01-04 00:00:00',NULL,'401',3304270.20,3304270.20,'401','2022-01-04 21:26:41','600','2022-01-05 11:35:10',10,0),('5','97',251577,'Full time shift','2022-01-05','2022-01-05 00:00:00',NULL,'401',2402843.85,2402843.85,'401','2022-01-06 09:42:49','600','2022-01-06 10:31:30',10,0),('5','97',251734,'Full time shift','2022-01-06','2022-01-06 00:00:00',NULL,'401',1465856.70,1465856.70,'401','2022-01-06 22:30:12','600','2022-01-07 10:15:25',10,0),('5','97',251969,'Full time shift','2022-01-07','2022-01-07 00:00:00',NULL,'401',1320823.35,1320823.35,'401','2022-01-07 23:01:51','600','2022-01-08 13:22:24',10,0),('5','97',252217,'Full time shift','2022-01-08','2022-01-08 00:00:00',NULL,'401',255507.45,255507.45,'401','2022-01-09 00:34:48','600','2022-01-09 09:50:51',10,0),('5','97',252454,'Full time shift','2022-01-09','2022-01-09 00:00:00',NULL,'401',0.00,0.00,'401','2022-01-09 23:44:42','600','2022-01-10 09:39:43',10,0),('5','97',252634,'Full time shift','2022-01-10','2022-01-10 00:00:00',NULL,'401',222783.00,222783.00,'401','2022-01-10 21:59:03','600','2022-01-11 09:23:29',10,0),('5','97',252950,'Full time shift','2022-01-11','2022-01-11 00:00:00',NULL,'401',1850681.25,1850681.25,'401','2022-01-12 00:06:08','600','2022-01-12 09:34:22',10,0),('5','97',253052,'Full time shift','2022-01-12','2022-01-12 00:00:00',NULL,'401',1379946.15,1379946.15,'401','2022-01-12 22:24:27','600','2022-01-13 09:10:12',10,0),('5','97',253449,'Full time shift','2022-01-13','2022-01-13 00:00:00',NULL,'401',2036430.00,2036430.00,'401','2022-01-13 22:38:16','600','2022-01-14 09:49:59',10,0),('5','97',253691,'Full time shift','2022-01-14','2022-01-14 00:00:00',NULL,'401',495024.75,495024.75,'401','2022-01-14 23:53:38','600','2022-01-15 10:52:31',10,0),('5','97',253922,'Full time shift','2022-01-15','2022-01-15 00:00:00',NULL,'401',2511656.40,2511656.40,'401','2022-01-15 22:09:20','600','2022-01-16 06:21:26',10,0),('5','97',254166,'Full time shift','2022-01-16','2022-01-16 00:00:00',NULL,'401',1854034.05,1854034.05,'401','2022-01-16 22:47:54','600','2022-01-17 05:25:05',10,0),('5','97',254422,'Full time shift','2022-01-17','2022-01-17 00:00:00',NULL,'401',1873395.15,1873395.15,'401','2022-01-17 22:34:02','600','2022-01-19 09:50:25',10,0),('5','97',254817,'Full time shift','2022-01-18','2022-01-18 00:00:00',NULL,'401',338895.15,338895.15,'401','2022-01-19 16:31:03','600','2022-01-19 16:34:01',10,0),('5','97',255056,'Full time shift','2022-01-19','2022-01-19 00:00:00',NULL,'401',187192.50,187192.50,'401','2022-01-20 13:04:05','600','2022-01-20 16:43:27',10,0),('5','97',255171,'Full time shift','2022-01-20','2022-01-20 00:00:00',NULL,'401',1635240.75,1635240.75,'401','2022-01-20 23:56:15','600','2022-01-21 09:54:14',10,0),('5','97',255256,'Full time shift it','2022-01-21','2022-01-21 00:00:00',NULL,'401',1496678.70,1496678.70,'401','2022-01-21 23:58:53','600','2022-01-22 09:20:41',10,0),('5','97',255632,'Full time shift','2022-01-22','2022-01-22 00:00:00',NULL,'401',1383782.40,1383782.40,'401','2022-01-22 22:42:18','600','2022-01-24 09:35:20',10,0),('5','97',256057,'Full time shift','2022-01-23','2022-01-23 00:00:00',NULL,'401',1378698.75,1378698.75,'401','2022-01-24 23:15:26','600','2022-01-25 09:15:31',10,0),('5','97',256327,'Full time shift','2022-01-24','2022-01-24 00:00:00',NULL,'401',188801.25,188801.25,'401','2022-01-25 12:32:07','600','2022-01-25 13:24:57',10,0),('5','97',256393,'Full time shift','2022-01-25','2022-01-25 00:00:00',NULL,'401',0.00,0.00,'401','2022-01-25 22:28:04','600','2022-01-26 09:10:38',10,0),('5','97',256699,'Full time shift','2022-01-26','2022-01-26 00:00:00',NULL,'401',267663.00,267663.00,'401','2022-01-26 23:23:32','600','2022-01-27 10:01:42',10,0),('5','97',256942,'Full time shift','2022-01-27','2022-01-27 00:00:00',NULL,'401',1684971.75,1684971.75,'401','2022-01-27 23:30:23','600','2022-01-28 10:46:34',10,0),('5','97',257140,'Full time shift','2022-01-28','2022-01-28 00:00:00',NULL,'401',1646739.60,1646739.60,'401','2022-01-28 23:17:38','600','2022-01-29 13:22:57',10,0),('5','97',257463,'Full time shift','2022-01-29','2022-01-29 00:00:00',NULL,'401',1803517.65,1803517.65,'401','2022-01-29 23:36:38','600','2022-01-30 10:17:13',10,0),('5','97',257464,'Full time shift','2022-01-30','2022-01-30 00:00:00',NULL,'401',1412061.75,1412061.75,'401','2022-01-31 09:32:29','600','2022-02-01 09:06:56',10,0),('5','97',257465,'Morning shift','2022-01-31','2022-01-31 00:00:00',NULL,'401',1164048.60,1164048.60,'401','2022-02-01 15:52:46','600','2022-02-01 19:31:09',10,0),('5','97',257466,'Full time shift','2022-02-01','2022-02-01 00:00:00',NULL,'401',155951.40,155951.40,'401','2022-02-01 22:40:09','600','2022-02-02 14:41:47',10,0),('5','97',257467,'Full time shift','2022-02-02','2022-02-02 00:00:00',NULL,'401',367174.50,367174.50,'401','2022-02-02 22:00:15','600','2022-02-03 14:03:53',10,0),('5','97',257468,'Full time shift','2022-02-03','2022-02-03 00:00:00',NULL,'401',990136.95,990136.95,'401','2022-02-03 22:51:23','600','2022-02-04 09:23:10',10,0),('5','97',257469,'Full time shift','2022-02-04','2022-02-04 00:00:00',NULL,'401',1359519.15,1359519.15,'401','2022-02-04 22:32:13','600','2022-02-05 05:29:31',10,0),('5','97',257470,'Full time shift','2022-02-05','2022-02-05 00:00:00',NULL,'401',1648571.10,1648571.10,'401','2022-02-05 23:46:08','600','2022-02-06 05:23:17',10,0),('5','97',257471,'Full time shift','2022-02-06','2022-02-06 00:00:00',NULL,'401',1662150.60,1662150.60,'401','2022-02-06 22:51:42','600','2022-02-07 05:07:50',10,0),('5','97',257472,'Full time shift.','2022-02-07','2022-02-07 00:00:00',NULL,'401',561102.30,561102.30,'401','2022-02-08 11:48:29','600','2022-02-09 09:09:54',10,0),('5','97',257473,'Full time shift','2022-02-08','2022-02-08 00:00:00',NULL,'401',0.00,0.00,'401','2022-02-09 13:29:59','600','2022-02-09 15:09:20',10,0),('5','97',257474,'Full time shift','2022-02-09','2022-02-09 00:00:00',NULL,'401',0.00,0.00,'401','2022-02-09 21:03:51','600','2022-02-10 10:03:10',10,0),('5','97',257475,'Full time shift','2022-02-10','2022-02-10 00:00:00',NULL,'401',0.00,0.00,'401','2022-02-10 22:59:09','600','2022-02-11 09:42:07',10,0),('5','97',257476,'Full time shift','2022-02-11','2022-02-11 00:00:00',NULL,'401',0.00,0.00,'401','2022-02-11 21:10:18','600','2022-02-12 08:43:53',10,0),('5','97',257477,'Full time shift','2022-02-12','2022-02-12 00:00:00',NULL,'401',0.00,0.00,'401','2022-02-13 15:50:56','600','2022-02-14 08:57:02',10,0),('5','97',257478,'Full time shift 970970','2022-02-13','2022-02-13 00:00:00',NULL,'401',0.00,0.00,'401','2022-02-14 14:26:01','600','2022-02-15 09:46:32',10,0),('5','97',257479,'Full time shift','2022-02-14','2022-02-14 00:00:00',NULL,'401',0.00,0.00,'401','2022-02-15 16:37:21','600','2022-02-15 16:47:50',10,0),('5','97',257480,'Full time shift','2022-02-15','2022-02-15 00:00:00',NULL,'401',184511.25,184511.25,'401','2022-02-15 23:44:10','600','2022-02-16 09:18:44',10,0),('5','97',257481,'Full time shift ','2022-02-16','2022-02-16 00:00:00',NULL,'401',1372940.25,1372940.25,'401','2022-02-17 07:36:21','600','2022-02-17 08:57:02',10,0),('5','97',257482,'Full time shift','2022-02-17','2022-02-17 00:00:00',NULL,'401',1330673.85,1330673.85,'401','2022-02-17 22:18:04','600','2022-02-18 09:23:08',10,0),('5','97',257483,'Full time shift','2022-02-18','2022-02-18 00:00:00',NULL,'401',1031383.65,1031383.65,'401','2022-02-18 22:40:12','600','2022-02-19 11:51:47',10,0),('5','97',257484,'Full time shift','2022-02-19','2022-02-19 00:00:00',NULL,'401',837155.55,837155.55,'401','2022-02-19 23:03:23','600','2022-02-20 08:48:03',10,0),('5','97',257485,'Full time shift','2022-02-20','2022-02-20 00:00:00',NULL,'401',148315.20,148315.20,'401','2022-02-20 21:56:52','600','2022-02-21 09:56:59',10,0),('5','97',257486,'Full time shift','2022-02-21','2022-02-21 00:00:00',NULL,'401',1311263.25,1311263.25,'401','2022-02-21 22:04:49','600','2022-02-22 09:21:09',10,0),('5','97',257487,'Full time shift','2022-02-22','2022-02-22 16:47:04','2022-02-23 16:47:04','401',1402613.85,1402613.85,'401','2022-02-23 06:19:09','600','2022-02-23 09:12:44',10,0),('5','97',257488,'Full time shift','2022-02-24','2022-02-24 00:21:24','2022-02-25 00:21:24','401',0.00,0.00,'401','2022-02-24 00:21:48','600','2022-02-24 08:12:02',10,0),('5','97',257489,'Full time shift','2022-02-24','2022-02-24 20:25:41','2022-02-25 20:25:41','401',1329490.80,1329490.80,'401','2022-02-24 20:28:49','600','2022-02-25 09:39:59',10,0),('5','97',257490,'Full time shift','2022-02-25','2022-02-25 23:11:00','2022-02-26 23:11:00','401',1389763.65,1389763.65,'401','2022-02-25 23:28:01','600','2022-02-26 09:46:16',10,0),('5','97',257491,'Full time shift','2022-02-27','2022-02-27 00:03:36','2022-02-28 00:03:36','401',1973089.80,1973089.80,'401','2022-02-27 00:06:22','600','2022-02-27 09:01:47',10,0),('5','97',257492,'Full time shift','2022-02-28','2022-02-28 00:11:32','2022-03-01 00:11:32','401',1871364.00,1871364.00,'401','2022-02-28 00:13:12','600','2022-02-28 08:49:44',10,0),('5','97',257493,'Full time shift','2022-02-28','2022-02-28 22:44:21','2022-03-01 22:44:21','401',1814473.65,1814473.65,'401','2022-02-28 23:42:43','600','2022-03-01 09:23:12',10,0),('5','97',257494,'Full time shift','2022-03-01','2022-03-02 00:28:49','2022-03-03 00:28:49','401',1427368.80,1427368.80,'401','2022-03-02 00:35:30','600','2022-03-02 09:35:38',10,0),('5','97',257495,'Full time','2022-03-02','2022-03-02 14:10:26','2022-03-03 14:10:26','401',1387321.65,1387321.65,'401','2022-03-03 16:14:21','600','2022-03-04 09:27:00',10,0),('5','97',257496,'Full time shift','2022-03-03','2022-03-05 23:41:29','2022-03-06 23:41:29','401',1815000.00,1815000.00,'401','2022-03-05 23:42:31','600','2022-03-06 11:30:14',10,0),('5','97',257497,'Full time shift','2022-03-04','2022-03-06 19:13:45','2022-03-07 19:13:45','401',285471.45,285471.45,'401','2022-03-06 19:16:51','600','2022-03-07 09:58:10',10,0),('5','97',257498,'Full time shift','2022-03-05','2022-03-07 12:29:02','2022-03-08 12:29:02','401',172228.65,172228.65,'401','2022-03-07 16:36:33','600','2022-03-08 09:18:36',10,0),('5','97',257499,'Full time shift','2022-03-06','2022-03-09 00:39:58','2022-03-10 00:39:58','401',1483508.40,1483508.40,'401','2022-03-09 00:50:04','600','2022-03-09 09:40:45',10,0),('5','97',257500,'Full time shift','2022-03-07','2022-03-09 10:42:10','2022-03-10 10:42:10','401',1615272.45,1615272.45,'401','2022-03-09 10:47:03','600','2022-03-10 09:06:50',10,0),('5','97',257501,'Full time shift','2022-03-08','2022-03-10 10:43:34','2022-03-11 10:43:34','401',1418780.55,1418780.55,'401','2022-03-10 10:46:02','600','2022-03-10 11:30:18',10,0),('5','97',257502,'Full time shift','2022-03-09','2022-03-10 23:40:52','2022-03-11 23:40:52','401',1578134.25,1578134.25,'401','2022-03-10 23:42:40','600','2022-03-11 09:58:39',10,0),('5','97',257503,'Full time shift','2022-03-10','2022-03-11 23:30:41','2022-03-12 23:30:41','401',332371.05,332371.05,'401','2022-03-11 23:31:51','600','2022-03-13 08:51:53',10,0),('5','97',257504,'Full time shift','2022-03-11','2022-03-13 22:44:19','2022-03-14 22:44:19','401',280018.20,280018.20,'401','2022-03-13 22:46:17','600','2022-03-14 09:14:54',10,0),('5','97',257505,'Full time shift','2022-03-12','2022-03-14 12:40:51','2022-03-15 12:40:51','401',1757418.30,1757418.30,'401','2022-03-14 12:42:09','600','2022-03-14 12:51:24',10,0),('5','97',257506,'Full time shift','2022-03-13','2022-03-14 12:55:01','2022-03-15 12:55:01','401',1643403.30,1643403.30,'401','2022-03-14 12:56:43','600','2022-03-14 16:25:50',10,0),('5','97',257507,'Full time shift','2022-03-14','2022-03-14 22:32:43','2022-03-15 22:32:43','401',2100364.20,2100364.20,'401','2022-03-14 22:36:38','600','2022-03-15 09:12:18',10,0),('5','97',257508,'Full time shift','2022-03-15','2022-03-15 23:09:49','2022-03-16 23:09:49','401',1659302.70,1659302.70,'401','2022-03-15 23:12:04','600','2022-03-16 11:37:10',10,0),('5','97',257509,'Full time shift','2022-03-16','2022-03-16 16:47:29','2022-03-17 16:47:29','401',1490395.50,1490395.50,'401','2022-03-18 00:18:05','600','2022-03-18 09:19:03',10,0),('5','97',257510,'Full time shift','2022-03-17','2022-03-18 11:27:27','2022-03-19 11:27:27','401',1086039.90,1086039.90,'401','2022-03-18 11:28:57','600','2022-03-19 10:10:35',10,0),('5','97',257511,'Full time shift','2022-03-18','2022-03-19 18:12:07','2022-03-20 18:12:07','401',672596.10,672596.10,'401','2022-03-19 18:13:52','600','2022-03-20 13:15:07',10,0),('5','97',257512,'Full time shift','2022-03-19','2022-03-21 10:12:07','2022-03-22 10:12:07','401',364640.10,364640.10,'401','2022-03-21 10:15:42','600','2022-03-22 09:01:19',10,0),('5','97',257513,'Full time shift','2022-03-20','2022-03-24 12:07:03','2022-03-25 12:07:03','401',0.00,0.00,'401','2022-03-24 14:22:47','600','2022-03-25 10:17:46',10,0),('5','97',257514,'Full time shift','2022-03-21','2022-03-25 11:10:15','2022-03-26 11:10:15','401',0.00,0.00,'401','2022-03-25 11:10:48','600','2022-03-25 13:22:30',10,0),('5','97',257515,'Full time shift','2022-03-22','2022-03-25 15:43:17','2022-03-26 15:43:17','401',0.00,0.00,'401','2022-03-25 15:43:44','600','2022-03-25 15:47:23',10,0),('5','97',257516,'Full time shift','2022-03-23','2022-03-25 15:55:48','2022-03-26 15:55:48','401',0.00,0.00,'401','2022-03-25 15:56:25','600','2022-03-25 15:58:05',10,0),('5','97',257517,'Full time shift','2022-03-24','2022-03-25 15:59:23','2022-03-26 15:59:23','401',419545.50,419545.50,'401','2022-03-25 16:02:00','600','2022-03-25 16:25:06',10,0),('5','97',257518,'Full time shift','2022-03-25','2022-03-26 23:10:58','2022-03-27 23:10:58','401',1149304.20,1149304.20,'401','2022-03-26 23:16:42','600','2022-03-27 08:55:55',10,0),('5','97',257519,'Full time shift','2022-03-26','2022-03-27 11:00:55','2022-03-28 11:00:55','401',1495667.25,1495667.25,'401','2022-03-28 00:15:54','600','2022-03-28 10:10:20',10,0),('5','97',257520,'Full time shift','2022-03-27','2022-03-28 15:05:52','2022-03-29 15:05:52','401',1264388.40,1264388.40,'401','2022-03-28 15:07:10','600','2022-03-29 11:34:32',10,0),('5','97',257521,'Full time shift','2022-03-28','2022-03-30 13:16:58','2022-03-31 13:16:58','401',1722410.25,1722410.25,'401','2022-03-30 15:04:42','600','2022-03-30 15:07:42',10,0),('5','97',257522,'Full time shift','2022-03-29','2022-03-30 16:05:33','2022-03-31 16:05:33','401',1362319.20,1362319.20,'401','2022-03-31 10:19:33','600','2022-03-31 12:19:57',10,0),('5','97',257523,'Full time shift','2022-03-30','2022-03-31 13:16:30','2022-04-01 13:16:30','401',1278858.90,1278858.90,'401','2022-03-31 13:18:25','600','2022-03-31 13:43:17',10,0),('5','97',257524,'Full time shift','2022-03-31','2022-03-31 16:17:20','2022-04-01 16:17:20','401',993770.25,993770.25,'401','2022-04-01 00:03:26','600','2022-04-01 16:20:10',10,0),('5','97',257525,'Full time shift','2022-04-01','2022-04-04 09:15:09','2022-04-05 09:15:09','401',1262332.50,1262332.50,'401','2022-04-04 09:17:08','600','2022-04-04 09:35:21',10,0),('5','97',257526,'Full time shift','2022-04-02','2022-04-04 09:51:28','2022-04-05 09:51:28','401',1534475.25,1534475.25,'401','2022-04-04 10:00:38','600','2022-04-04 10:17:10',10,0),('5','97',257527,'Full time shift','2022-04-03','2022-04-04 13:05:11','2022-04-05 13:05:11','401',1258636.50,1258636.50,'401','2022-04-04 13:06:43','600','2022-04-04 13:09:53',10,0),('5','97',257528,'Full time shift','2022-04-04','2022-04-04 22:33:50','2022-04-05 22:33:50','401',1338940.35,1338940.35,'401','2022-04-04 22:40:47','600','2022-04-05 11:31:20',10,0),('5','97',257529,'Full time shift','2022-04-05','2022-04-05 23:55:06','2022-04-06 23:55:06','401',1657431.60,1657431.60,'401','2022-04-05 23:57:47','600','2022-04-06 09:03:48',10,0),('5','97',257530,'Full time shift','2022-04-06','2022-04-06 23:47:54','2022-04-07 23:47:54','401',1704511.05,1704511.05,'401','2022-04-06 23:49:38','600','2022-04-07 13:56:29',10,0),('5','97',257531,'Full time shift','2022-04-07','2022-04-08 13:53:42','2022-04-09 13:53:42','401',1792300.95,1792300.95,'401','2022-04-08 23:35:56','600','2022-04-09 08:57:49',10,0),('5','97',257532,'Full time shift','2022-04-08','2022-04-09 16:51:13','2022-04-10 16:51:13','401',1586361.15,1586361.15,'401','2022-04-10 04:41:59','600','2022-04-10 13:55:29',10,0),('5','97',257533,'Full time shift','2022-04-09','2022-04-10 23:07:06','2022-04-11 23:07:06','401',1601640.15,1601640.15,'401','2022-04-10 23:09:51','600','2022-04-11 09:05:13',10,0),('5','97',257534,'Full time shift','2022-04-10','2022-04-11 16:39:34','2022-04-12 16:39:34','401',1662261.15,1662261.15,'401','2022-04-11 16:45:34','600','2022-04-12 08:52:34',10,0),('5','97',257535,'Full time shift','2022-04-11','2022-04-12 16:14:25','2022-04-13 16:14:25','401',2198464.95,2198464.95,'401','2022-04-12 16:21:01','600','2022-04-13 08:56:20',10,0),('5','97',257536,'Full time shift','2022-04-12','2022-04-13 14:42:04','2022-04-14 14:42:04','401',2714050.35,2714050.35,'401','2022-04-13 14:56:15','600','2022-04-13 15:00:15',10,0),('5','97',257537,'Full time shift','2022-04-13','2022-04-13 15:01:16','2022-04-14 15:01:16','401',2302012.35,2302012.35,'401','2022-04-13 23:04:51','600','2022-04-14 09:20:54',10,0),('5','97',257538,'Full time shift','2022-04-14','2022-04-14 16:06:25','2022-04-15 16:06:25','401',1864290.45,1864290.45,'401','2022-04-14 23:59:31','600','2022-04-15 10:16:50',10,0),('5','97',257539,'Full time shift','2022-04-15','2022-04-16 00:21:46','2022-04-17 00:21:46','401',1212533.85,1212533.85,'401','2022-04-16 00:24:16','600','2022-04-16 08:28:24',10,0),('5','97',257540,'Full time shift','2022-04-16','2022-04-16 15:40:31','2022-04-17 15:40:31','401',838284.15,838284.15,'401','2022-04-18 13:08:23','600','2022-04-19 10:37:47',10,0),('5','97',257541,'Full time shift','2022-04-17','2022-04-19 12:04:05','2022-04-20 12:04:05','401',201448.50,201448.50,'401','2022-04-19 12:05:21','600','2022-04-19 13:50:21',10,0),('5','97',257542,'Full time shift','2022-04-18','2022-04-19 15:29:54','2022-04-20 15:29:54','401',1235671.80,1235671.80,'401','2022-04-19 15:31:26','600','2022-04-20 09:41:48',10,0),('5','97',257543,'Full time shift','2022-04-19','2022-04-20 23:35:01','2022-04-21 23:35:01','401',1170336.75,1170336.75,'401','2022-04-20 23:36:24','600','2022-04-21 09:20:42',10,0),('5','97',257544,'Full time shift','2022-04-20','2022-04-21 11:18:19','2022-04-22 11:18:19','401',841470.30,841470.30,'401','2022-04-22 21:04:45','600','2022-04-23 09:11:15',10,0),('5','97',257545,'Full time shift','2022-04-21','2022-04-23 23:58:05','2022-04-24 23:58:05','401',339015.60,339015.60,'401','2022-04-23 23:58:50','600','2022-04-24 09:09:15',10,0),('5','97',257546,'Full time shift','2022-04-22','2022-04-24 23:04:39','2022-04-25 23:04:39','401',333646.50,333646.50,'401','2022-04-24 23:05:48','600','2022-04-25 11:35:18',10,0),('5','97',257547,'Full time shift','2022-04-23','2022-04-25 23:27:00','2022-04-26 23:27:00','401',1417762.50,1417762.50,'401','2022-04-25 23:30:36','600','2022-04-26 10:13:01',10,0),('5','97',257548,'Full time shift','2022-04-24','2022-04-26 17:21:16','2022-04-27 17:21:16','401',1438507.95,1438507.95,'401','2022-04-26 22:01:19','600','2022-04-27 10:14:10',10,0),('5','97',257549,'Full time shift','2022-04-25','2022-04-29 14:42:55','2022-04-30 14:42:55','401',1462127.70,1462127.70,'401','2022-04-29 14:46:04','600','2022-04-29 15:04:46',10,0),('5','97',257550,'Full time shift','2022-04-26','2022-04-29 15:08:21','2022-04-30 15:08:21','401',821954.10,821954.10,'401','2022-04-29 15:09:36','600','2022-04-29 15:11:26',10,0),('5','97',257551,'Full time shift','2022-04-27','2022-04-29 15:16:29','2022-04-30 15:16:29','401',331239.15,331239.15,'401','2022-04-29 15:17:26','600','2022-04-29 15:26:26',10,0),('5','97',257552,'Full time shift','2022-04-28','2022-04-29 15:47:11','2022-04-30 15:47:11','401',201316.50,201316.50,'401','2022-04-29 15:50:39','600','2022-04-29 16:00:10',10,0),('5','97',257553,'Full time shift','2022-04-29','2022-04-29 23:35:04','2022-04-30 23:35:04','401',1606200.75,1606200.75,'401','2022-04-29 23:36:15','600','2022-05-09 10:51:54',10,0),('5','97',257554,'Full time shift','2022-04-30','2022-05-09 11:37:12','2022-05-10 11:37:12','401',1751204.40,1751204.40,'401','2022-05-09 11:43:57','600','2022-05-09 12:07:01',10,0),('5','97',257555,'Full time shift','2022-05-01','2022-05-09 12:22:26','2022-05-10 12:22:26','401',1466429.25,1466429.25,'401','2022-05-09 12:28:04','600','2022-05-09 12:42:31',10,0),('5','97',257556,'Full time shift','2022-05-02','2022-05-09 12:43:54','2022-05-10 12:43:54','401',1214004.00,1214004.00,'401','2022-05-09 12:46:02','600','2022-05-09 13:06:15',10,0),('5','97',257557,'Full time shift','2022-05-03','2022-05-09 13:16:08','2022-05-10 13:16:08','401',686748.15,686748.15,'401','2022-05-09 13:18:46','600','2022-05-09 13:34:22',10,0),('5','97',257558,'Full time shift','2022-05-04','2022-05-09 13:37:47','2022-05-10 13:37:47','401',346500.00,346500.00,'401','2022-05-09 13:38:49','600','2022-05-09 13:39:55',10,0),('5','97',257559,'Full time shift','2022-05-05','2022-05-09 13:41:39','2022-05-10 13:41:39','401',1691250.00,1691250.00,'401','2022-05-09 13:43:20','600','2022-05-09 13:44:17',10,0),('5','97',257560,'Full time shift','2022-05-06','2022-05-09 13:53:44','2022-05-10 13:53:44','401',1537118.55,1537118.55,'401','2022-05-09 13:55:21','600','2022-05-09 13:57:25',10,0),('5','97',257561,'Full time shift','2022-05-07','2022-05-09 14:06:50','2022-05-10 14:06:50','401',1324497.90,1324497.90,'401','2022-05-09 14:07:49','600','2022-05-09 14:12:18',10,0),('5','97',257562,'Full time shift','2022-05-08','2022-05-09 14:13:58','2022-05-10 14:13:58','401',1097428.20,1097428.20,'401','2022-05-09 14:16:23','600','2022-05-09 14:19:00',10,0),('5','97',257563,'Full time shift 72783','2022-05-08','2022-05-09 14:59:13','2022-05-10 14:59:13','401',1094337.75,1094337.75,'401','2022-05-09 22:04:18','600','2022-05-10 09:40:19',10,0),('5','97',257564,'Full time shift','2022-05-10','2022-05-10 15:29:41','2022-05-11 15:29:41','401',430887.60,430887.60,'401','2022-05-11 17:00:39','600','2022-05-12 12:55:23',10,0),('5','97',257565,'Full time shift','2022-05-11','2022-05-12 15:07:52','2022-05-13 15:07:52','401',397141.80,397141.80,'401','2022-05-12 15:09:54','600','2022-05-12 15:14:16',10,0),('5','97',257566,'Full time shift','2022-05-12','2022-05-12 15:17:21','2022-05-13 15:17:21','401',1268747.70,1268747.70,'401','2022-05-13 08:05:29','600','2022-05-13 11:31:40',10,0),('5','97',257567,'Full time shift','2022-05-13','2022-05-13 14:44:43','2022-05-14 14:44:43','401',1457821.20,1457821.20,'401','2022-05-14 21:26:02','600','2022-05-15 06:14:48',10,0),('5','97',257568,'Full time shift','2022-05-14','2022-05-15 16:03:40','2022-05-16 16:03:40','401',1566102.45,1566102.45,'401','2022-05-15 16:05:54','600','2022-05-16 09:54:00',10,0),('5','97',257569,'Full time shift','2022-05-15','2022-05-16 11:27:50','2022-05-17 11:27:50','401',1631421.00,1631421.00,'401','2022-05-16 12:39:02','600','2022-05-16 12:40:22',10,0),('5','97',257570,'Full time shift','2022-05-16','2022-05-16 12:41:48','2022-05-17 12:41:48','401',1505981.40,1505981.40,'401','2022-05-16 21:57:43','600','2022-05-17 06:03:33',10,0),('5','97',257571,'Full time shift','2022-05-17','2022-05-17 08:00:55','2022-05-18 08:00:55','401',1151926.05,1151926.05,'401','2022-05-17 21:00:18','600','2022-05-17 21:58:53',10,0),('5','97',257572,'Full time shift','2022-05-18','2022-05-18 06:11:37','2022-05-19 06:11:37','401',698062.20,698062.20,'401','2022-05-18 23:53:01','604','2022-05-19 01:06:32',10,0),('5','97',257573,'Full time shift','2022-05-19','2022-05-19 08:17:18','2022-05-20 08:17:18','401',536241.75,536241.75,'401','2022-05-19 23:16:53','600','2022-05-20 06:03:50',10,0),('5','97',257574,'Full time shift','2022-05-20','2022-05-20 09:25:27','2022-05-21 09:25:27','401',865809.45,865809.45,'401','2022-05-20 23:55:32','600','2022-05-21 06:19:03',10,0),('5','97',257575,'Full time shift','2022-05-21','2022-05-21 16:07:59','2022-05-22 16:07:59','401',1430886.60,1430886.60,'401','2022-05-21 23:40:23','600','2022-05-22 08:06:05',10,0),('5','97',257576,'Full time shift','2022-05-22','2022-05-22 09:43:49','2022-05-23 09:43:49','401',1784724.15,1784724.15,'401','2022-05-22 22:09:11','600','2022-05-23 05:59:18',10,0),('5','97',257577,'Full time shift','2022-05-23','2022-05-23 13:18:57','2022-05-24 13:18:57','401',1787860.80,1787860.80,'401','2022-05-24 00:14:29','600','2022-05-24 07:55:53',10,0),('5','97',257578,'Full time shift','2022-05-24','2022-05-24 08:46:52','2022-05-25 08:46:52','401',1458560.40,1458560.40,'401','2022-05-24 21:38:48','600','2022-05-25 06:04:05',10,0),('5','97',257579,'Full time shift','2022-05-25','2022-05-25 09:32:50','2022-05-26 09:32:50','401',2345699.40,2345699.40,'401','2022-05-25 21:58:51','600','2022-05-26 05:24:35',10,0),('5','97',257580,'Full time shift','2022-05-26','2022-05-26 08:42:26','2022-05-27 08:42:26','401',1174049.25,1174049.25,'401','2022-05-26 23:20:22','600','2022-05-27 05:20:29',10,0),('5','97',257581,'Full time shift','2022-05-27','2022-05-28 00:01:15','2022-05-29 00:01:15','401',1409360.70,1409360.70,'401','2022-05-28 00:02:19','600','2022-05-28 06:09:59',10,0),('5','97',257582,'Full time shift','2022-05-28','2022-05-28 16:33:34','2022-05-29 16:33:34','401',1147071.75,1147071.75,'401','2022-05-28 17:01:02','600','2022-05-29 08:10:15',10,0),('5','97',257583,'Full time shift','2022-05-29','2022-05-29 15:54:53','2022-05-30 15:54:53','401',1137305.40,1137305.40,'401','2022-05-29 23:16:01','600','2022-05-30 05:56:13',10,0),('5','97',257584,'Full time shift','2022-05-30','2022-05-30 10:04:41','2022-05-31 10:04:41','401',1133960.85,1133960.85,'401','2022-05-30 18:30:36','600','2022-05-31 09:00:51',10,0),('5','97',257585,'Full time shift','2022-05-31','2022-05-31 18:17:27','2022-06-01 18:17:27','401',898425.00,898425.00,'401','2022-05-31 18:18:58','600','2022-05-31 22:58:20',10,0),('5','97',257586,'Full time shift','2022-06-01','2022-06-02 00:01:28','2022-06-03 00:01:28','401',492089.40,492089.40,'401','2022-06-02 00:05:42','600','2022-06-02 09:04:15',10,0),('5','97',257587,'Full time shift','2022-06-02','2022-06-02 23:32:28','2022-06-03 23:32:28','401',339438.00,339438.00,'401','2022-06-02 23:34:34','600','2022-06-03 09:25:42',10,0),('5','97',257588,'daily','2022-04-17','2022-06-03 10:30:42','2022-06-04 10:30:42','600',0.00,0.00,'600','2022-06-03 10:33:48','600','2022-06-03 10:34:05',10,0),('5','97',257589,'Full time shift','2022-06-03','2022-06-03 22:18:25','2022-06-04 22:18:25','401',346500.00,346500.00,'401','2022-06-03 22:20:41','600','2022-06-04 09:21:54',10,0),('5','97',257590,'Full time shift','2022-06-04','2022-06-04 20:40:21','2022-06-05 20:40:21','401',159093.00,159093.00,'401','2022-06-04 20:42:12','600','2022-06-05 05:31:47',10,0),('5','97',257591,'Full time shift','2022-06-05','2022-06-05 23:22:28','2022-06-06 23:22:28','401',970493.70,970493.70,'401','2022-06-05 23:24:20','600','2022-06-06 09:47:34',10,0),('5','97',257592,'Full time shift','2022-06-06','2022-06-06 17:14:11','2022-06-07 17:14:11','401',1218935.85,1218935.85,'401','2022-06-07 00:06:50','600','2022-06-07 09:04:56',10,0),('5','97',257593,'Full time shift','2022-06-07','2022-06-08 08:42:16','2022-06-09 08:42:16','401',883730.10,883730.10,'401','2022-06-08 08:43:11','600','2022-06-08 09:44:17',10,0),('5','97',257594,'Full time shift','2022-06-08','2022-06-09 08:44:14','2022-06-10 08:44:14','401',283979.85,283979.85,'401','2022-06-09 08:45:23','600','2022-06-09 11:13:10',10,0),('5','97',257595,'Full time shift','2022-06-09','2022-06-09 13:05:59','2022-06-10 13:05:59','401',639084.60,639084.60,'401','2022-06-10 05:28:06','600','2022-06-10 09:20:20',10,0),('5','97',257596,'Full time shift','2022-06-10','2022-06-10 22:20:11','2022-06-11 22:20:11','401',417846.00,417846.00,'401','2022-06-10 22:21:39','600','2022-06-11 09:28:15',10,0),('5','97',257597,'Full time shift','2022-06-11','2022-06-11 21:35:36','2022-06-12 21:35:36','401',353966.25,353966.25,'401','2022-06-12 09:19:54','600','2022-06-12 09:53:31',10,0),('5','97',257598,'Full time shift','2022-06-12','2022-06-12 21:30:36','2022-06-13 21:30:36','401',0.00,0.00,'401','2022-06-12 21:31:02','600','2022-06-13 09:31:23',10,0),('5','97',257599,'Full time shift','2022-06-13','2022-06-13 20:40:56','2022-06-14 20:40:56','401',0.00,0.00,'401','2022-06-13 20:41:24','600','2022-06-14 10:46:15',10,0),('5','97',257600,'Full time shift','2022-06-14','2022-06-14 10:48:08','2022-06-15 10:48:08','401',0.00,0.00,'401','2022-06-14 23:10:35','600','2022-06-15 09:23:10',10,0),('5','97',257601,'Full time shift','2022-06-15','2022-06-15 16:24:18','2022-06-16 16:24:18','401',0.00,0.00,'401','2022-06-15 21:43:36','600','2022-06-16 12:47:28',10,0),('5','97',257602,'Full time shift','2022-06-16','2022-06-16 13:40:59','2022-06-17 13:40:59','401',0.00,0.00,'401','2022-06-16 23:58:25','600','2022-06-17 09:55:20',10,0),('5','97',257603,'Full time shift','2022-06-17','2022-06-17 11:31:10','2022-06-18 11:31:10','401',189832.50,189832.50,'401','2022-06-18 09:44:10','600','2022-06-18 09:45:44',10,0),('5','97',257604,'Full time shift','2022-06-18','2022-06-18 21:57:09','2022-06-19 21:57:09','401',1034142.45,1034142.45,'401','2022-06-18 21:59:13','600','2022-06-19 09:32:31',10,0),('5','97',257605,'Full time shift','2022-06-19','2022-06-19 23:58:12','2022-06-20 23:58:12','401',1075258.80,1075258.80,'401','2022-06-20 00:03:13','600','2022-06-20 09:56:32',10,0),('5','97',257606,'Full time shift','2022-06-20','2022-06-20 22:44:18','2022-06-21 22:44:18','401',881944.80,881944.80,'401','2022-06-20 22:46:32','600','2022-06-21 09:55:25',10,0),('5','97',257607,'Full time shift','2022-06-21','2022-06-21 22:33:08','2022-06-22 22:33:08','401',829098.60,829098.60,'401','2022-06-21 22:35:22','600','2022-06-22 09:25:46',10,0),('5','97',257608,'Full time shift','2022-06-22','2022-06-22 10:17:59','2022-06-23 10:17:59','401',752239.95,752239.95,'401','2022-06-22 22:55:55','600','2022-06-23 10:00:26',10,0),('5','97',257609,'Full time shift','2022-06-23','2022-06-23 17:44:25','2022-06-24 17:44:25','401',691394.55,691394.55,'401','2022-06-23 23:24:57','600','2022-06-24 09:42:20',10,0),('5','97',257610,'Full time shift','2022-06-24','2022-06-26 13:14:50','2022-06-27 13:14:50','401',405838.95,405838.95,'401','2022-06-26 13:18:03','600','2022-06-26 13:31:06',10,0),('5','97',257611,'Full time shift','2022-06-26','2022-06-26 14:04:57','2022-06-27 14:04:57','401',341467.50,341467.50,'401','2022-06-26 14:12:55','600','2022-06-26 16:51:09',10,0),('5','97',257612,'Full time shift','2022-06-26','2022-06-26 17:11:04','2022-06-27 17:11:04','401',424068.15,424068.15,'401','2022-06-26 23:10:02','600','2022-06-27 10:23:17',10,0),('5','97',257613,'Full time shift','2022-06-27','2022-06-27 20:31:31','2022-06-28 20:31:31','401',0.00,0.00,'401','2022-06-27 20:31:56','600','2022-06-28 09:16:42',10,0),('5','97',257614,'Full time shift','2022-06-28','2022-06-28 22:42:36','2022-06-29 22:42:36','401',0.00,0.00,'401','2022-06-28 22:43:03','600','2022-06-29 09:06:04',10,0),('5','97',257615,'Full time shift','2022-06-29','2022-06-29 13:32:52','2022-06-30 13:32:52','401',0.00,0.00,'401','2022-06-29 20:13:51','600','2022-06-30 08:27:58',10,0),('5','97',257616,'Full time shift','2022-06-30','2022-06-30 10:41:45','2022-07-01 10:41:45','401',0.00,0.00,'401','2022-06-30 22:46:51','600','2022-07-01 09:52:45',10,0),('5','97',257617,'Full time shift','2022-07-01','2022-07-03 09:48:38','2022-07-04 09:48:38','401',0.00,0.00,'401','2022-07-03 09:49:10','600','2022-07-03 11:15:39',10,0),('5','97',257618,'Full time shift','2022-07-02','2022-07-03 17:26:03','2022-07-04 17:26:03','401',0.00,0.00,'401','2022-07-03 17:26:36','600','2022-07-03 17:28:17',10,0),('5','97',257619,'Full time shift','2022-07-03','2022-07-03 17:54:51','2022-07-04 17:54:51','401',0.00,0.00,'600','2022-07-04 12:11:56','600','2022-07-04 12:12:12',10,0),('5','97',257620,'Full time shift','2022-07-04','2022-07-04 23:39:58','2022-07-05 23:39:58','401',0.00,0.00,'401','2022-07-04 23:40:19','600','2022-07-05 09:14:52',10,0),('5','97',257621,'Full time shift','2022-07-05','2022-07-05 17:44:32','2022-07-06 17:44:32','401',200557.50,200557.50,'401','2022-07-05 21:18:58','600','2022-07-06 09:12:44',10,0),('5','97',257622,'Full time shift','2022-07-06','2022-07-06 14:27:50','2022-07-07 14:27:50','401',722629.05,722629.05,'401','2022-07-06 22:43:47','600','2022-07-07 10:37:16',10,0),('5','97',257623,'Full time shift','2022-07-07','2022-07-07 14:03:31','2022-07-08 14:03:31','401',940038.00,940038.00,'401','2022-07-07 22:00:26','600','2022-07-08 08:55:11',10,0),('5','97',257624,'Full time shift','2022-07-08','2022-07-08 23:42:27','2022-07-09 23:42:27','401',1237287.15,1237287.15,'401','2022-07-08 23:43:35','600','2022-07-09 16:33:13',10,0),('5','97',257625,'Morning shift','2022-07-09','2022-07-09 17:51:04','2022-07-10 17:51:04','401',429872.85,429872.85,'401','2022-07-09 17:53:56','600','2022-07-10 10:53:56',10,0),('5','97',257626,'Afternoon shift','2022-07-09','2022-07-10 11:24:09','2022-07-11 11:24:09','401',610445.55,610445.55,'401','2022-07-10 11:28:44','600','2022-07-10 13:55:29',10,0),('5','97',257627,'Full time shift','2022-07-10','2022-07-10 15:25:08','2022-07-11 15:25:08','401',625851.60,701712.40,'401','2022-07-12 00:01:11','600','2022-07-12 10:51:02',10,0),('5','97',257628,'Full time shift','2022-07-11','2022-07-12 23:39:49','2022-07-13 23:39:49','401',795620.25,795620.25,'401','2022-07-12 23:41:24','600','2022-07-13 09:30:54',10,0),('5','97',257629,'Full time shift','2022-07-12','2022-07-13 14:19:23','2022-07-14 14:19:23','401',665726.20,665726.20,'401','2022-07-13 14:20:31','600','2022-07-13 14:34:13',10,0),('5','97',257630,'Full time shift','2022-07-13','2022-07-13 14:38:08','2022-07-14 14:38:08','401',941111.65,941111.65,'401','2022-07-14 09:11:41','600','2022-07-14 09:44:32',10,0),('5','97',257631,'Full time shift','2022-07-14','2022-07-14 13:32:23','2022-07-15 13:32:23','401',1315459.15,1315459.15,'401','2022-07-14 22:30:08','600','2022-07-15 10:50:26',10,0),('5','97',257632,'Full time shift it','2022-07-15','2022-07-15 22:45:29','2022-07-16 22:45:29','401',1858158.50,1858158.50,'401','2022-07-15 22:47:28','600','2022-07-16 09:53:36',10,0),('5','97',257633,'Full time shift','2022-07-16','2022-07-16 15:49:42','2022-07-17 15:49:42','401',1940359.55,1940359.55,'401','2022-07-16 22:50:46','600','2022-07-17 04:57:47',10,0),('5','97',257634,'Full time shift','2022-07-17','2022-07-17 09:43:21','2022-07-18 09:43:21','401',1513716.25,1513716.25,'401','2022-07-17 22:04:34','600','2022-07-18 07:30:43',10,0),('5','97',257635,'Full time shift','2022-07-18','2022-07-18 09:49:21','2022-07-19 09:49:21','401',1503668.90,1503668.90,'401','2022-07-19 08:13:23','600','2022-07-19 09:32:14',10,0),('5','97',257636,'Full time shift','2022-07-19','2022-07-19 23:53:48','2022-07-20 23:53:48','401',1406144.30,1406144.30,'401','2022-07-19 23:55:56','600','2022-07-20 09:08:26',10,0),('5','97',257637,'Full time shift it','2022-07-20','2022-07-20 13:04:18','2022-07-21 13:04:18','401',2004273.35,2004273.35,'401','2022-07-20 22:39:11','600','2022-07-21 08:57:37',10,0),('5','97',257638,'Full time shift','2022-07-21','2022-07-21 13:39:54','2022-07-22 13:39:54','401',2117761.60,2117761.60,'401','2022-07-22 10:27:52','600','2022-07-22 10:37:35',10,0),('5','97',257639,'Full time shift','2022-07-22','2022-07-22 15:16:20','2022-07-23 15:16:20','401',2469257.90,2469257.90,'401','2022-07-22 21:35:22','600','2022-07-23 10:32:48',10,0),('5','97',257640,'Full time shift','2022-07-24','2022-07-24 00:17:06','2022-07-25 00:17:06','401',2213293.75,2213293.75,'401','2022-07-24 00:21:06','600','2022-07-24 09:30:44',10,0),('5','97',257641,'Full time shift','2022-07-24','2022-07-24 23:21:01','2022-07-25 23:21:01','401',1550829.10,1550829.10,'401','2022-07-24 23:22:17','600','2022-07-25 07:35:10',10,0),('5','97',257642,'Full time shift','2022-07-25','2022-07-26 10:28:16','2022-07-27 10:28:16','401',928897.95,928897.95,'401','2022-07-26 10:31:42','600','2022-07-26 12:13:16',10,0),('5','97',257643,'Full time shift','2022-07-26','2022-07-26 22:41:57','2022-07-27 22:41:57','401',633737.85,633737.85,'401','2022-07-26 22:44:31','600','2022-07-27 09:10:22',10,0),('5','97',257644,'Full time shift','2022-07-27','2022-07-28 00:20:29','2022-07-29 00:20:29','401',460544.55,460544.55,'401','2022-07-28 00:21:43','600','2022-07-28 09:21:54',10,0),('5','97',257645,'Full time shift','2022-07-28','2022-07-29 10:51:57','2022-07-30 10:51:57','401',0.00,0.00,'401','2022-07-29 10:52:38','600','2022-07-29 13:11:02',10,0),('5','97',257646,'Full time shift','2022-07-29','2022-07-29 17:25:57','2022-07-30 17:25:57','401',0.00,0.00,'401','2022-07-30 20:58:22','600','2022-07-31 10:14:34',10,0),('5','97',257647,'Full time shift','2022-07-30','2022-07-31 10:54:53','2022-08-01 10:54:53','401',0.00,0.00,'401','2022-07-31 10:55:46','600','2022-07-31 15:23:59',10,0),('5','97',257648,'Full time shift','2022-07-31','2022-07-31 15:25:27','2022-08-01 15:25:27','401',0.00,0.00,'401','2022-07-31 19:59:04','600','2022-08-01 08:21:00',10,0),('5','97',257649,'Full time shift','2022-08-01','2022-08-01 11:41:09','2022-08-02 11:41:09','401',153078.25,153078.25,'401','2022-08-01 22:55:45','600','2022-08-02 11:13:57',10,0),('5','97',257650,'Full time shift','2022-08-02','2022-08-02 14:08:49','2022-08-03 14:08:49','401',925643.80,925643.80,'401','2022-08-02 21:47:54','600','2022-08-03 09:58:19',10,0),('5','97',257651,'Full time shift','2022-08-03','2022-08-03 14:02:13','2022-08-04 14:02:13','401',1181228.70,1181228.70,'401','2022-08-03 17:19:42','600','2022-08-04 08:18:27',10,0),('5','97',257652,'Full time shift','2022-08-04','2022-08-04 12:45:27','2022-08-05 12:45:27','401',1206018.70,1206018.70,'401','2022-08-04 23:43:18','600','2022-08-05 10:26:59',10,0),('5','97',257653,'Full time shift','2022-08-05','2022-08-05 12:31:31','2022-08-06 12:31:31','401',1311849.80,1311849.80,'401','2022-08-05 20:12:07','600','2022-08-06 08:56:52',10,0),('5','97',257654,'Full time shift','2022-08-06','2022-08-07 00:15:04','2022-08-08 00:15:04','401',1433463.25,1433463.25,'401','2022-08-07 00:16:11','600','2022-08-07 09:59:24',10,0),('5','97',257655,'Full time shift','2022-08-07','2022-08-07 23:06:24','2022-08-08 23:06:24','401',1137441.05,1137441.05,'401','2022-08-07 23:07:38','600','2022-09-03 05:06:46',10,0),('5','97',257656,'Full time shift','2022-08-08','2022-09-03 06:01:08','2022-09-04 06:01:08','401',1230631.10,1230631.10,'401','2022-09-03 23:27:33','600','2022-09-04 10:08:24',10,0),('5','97',257657,'Full time shift','2022-09-04','2022-09-04 11:21:32','2022-09-05 11:21:32','401',1291860.55,1291860.55,'401','2022-09-04 19:30:36','600','2022-09-05 10:22:09',10,0),('5','97',257658,'Full time shift','2022-08-10','2022-09-05 11:37:42','2022-09-06 11:37:42','401',1217662.60,1217662.60,'401','2022-09-05 14:06:41','600','2022-09-05 14:12:10',10,0),('5','97',257659,'Full time shift','2022-08-11','2022-09-05 14:20:33','2022-09-06 14:20:33','401',1385779.50,1385779.50,'401','2022-09-05 14:22:22','600','2022-09-05 14:28:14',10,0),('5','97',257660,'Full time shift','2022-08-12','2022-09-05 14:30:35','2022-09-06 14:30:35','401',0.00,0.00,'401','2022-09-05 14:33:03','600','2022-09-05 14:54:25',10,0),('5','97',257661,'Full time shift','2022-08-12','2022-09-05 14:57:47','2022-09-06 14:57:47','401',1146184.15,1146184.15,'401','2022-09-05 15:14:19','600','2022-09-05 15:15:27',10,0),('5','97',257662,'Full time shift','2022-08-13','2022-09-05 15:17:56','2022-09-06 15:17:56','401',1574292.65,1574292.65,'401','2022-09-05 15:23:18','600','2022-09-05 15:25:45',10,0),('5','97',257663,'Full time shift','2022-08-14','2022-09-05 15:27:08','2022-09-06 15:27:08','401',1288328.90,1288328.90,'401','2022-09-05 15:32:53','600','2022-09-05 15:34:13',10,0),('5','97',257664,'Full time shift','2022-08-15','2022-09-05 15:35:44','2022-09-06 15:35:44','401',1149040.55,1149040.55,'401','2022-09-05 15:39:42','600','2022-09-05 15:41:20',10,0),('5','97',257665,'Full time shift','2022-08-15','2022-09-05 17:48:47','2022-09-06 17:48:47','401',1088614.00,1088614.00,'401','2022-09-05 21:32:47','600','2022-09-05 21:46:26',10,0),('5','97',257666,'Full time shift','2022-08-17','2022-09-05 21:55:32','2022-09-06 21:55:32','401',1522916.30,1522916.30,'401','2022-09-05 21:58:52','600','2022-09-05 21:59:48',10,0),('5','97',257667,'Full time shift','2022-08-18','2022-09-05 22:01:07','2022-09-06 22:01:07','401',1363566.55,1363566.55,'401','2022-09-05 22:02:59','600','2022-09-05 22:04:08',10,0),('5','97',257668,'Full time shift','2022-08-19','2022-09-05 22:05:39','2022-09-06 22:05:39','401',926246.90,926246.90,'401','2022-09-05 22:08:42','600','2022-09-05 22:09:29',10,0),('5','97',257669,'Full time shift','2022-08-20','2022-09-05 22:10:39','2022-09-06 22:10:39','401',1315895.75,1315895.75,'401','2022-09-05 22:12:52','600','2022-09-06 08:26:33',10,0),('5','97',257670,'Full time shift','2022-08-21','2022-09-06 08:34:50','2022-09-07 08:34:50','401',1253449.00,1253449.00,'401','2022-09-06 13:35:46','600','2022-09-06 13:36:56',10,0),('5','97',257671,'Full time shift','2022-08-22','2022-09-06 13:39:32','2022-09-07 13:39:32','401',1196702.10,1196702.10,'401','2022-09-06 13:43:10','600','2022-09-06 14:02:32',10,0),('5','97',257672,'Full time shift ','2022-08-23','2022-09-06 14:03:12','2022-09-07 14:03:12','401',1160780.65,1160780.65,'401','2022-09-06 14:05:07','600','2022-09-06 14:52:57',10,0),('5','97',257673,'Full time shift','2022-08-24','2022-09-06 14:56:56','2022-09-07 14:56:56','401',1418716.90,1418716.90,'401','2022-09-06 14:59:26','600','2022-09-06 15:00:45',10,0),('5','97',257674,'Full time shift','2022-08-25','2022-09-06 15:02:03','2022-09-07 15:02:03','401',1989347.55,1989347.55,'401','2022-09-06 15:04:43','600','2022-09-06 15:05:19',10,0),('5','97',257675,'Full time shift','2022-08-26','2022-09-06 15:06:05','2022-09-07 15:06:05','401',1496381.75,1496381.75,'401','2022-09-06 15:07:41','600','2022-09-06 15:20:36',10,0),('5','97',257676,'Full time shift','2022-08-27','2022-09-06 15:22:31','2022-09-07 15:22:31','401',1730379.00,1730379.00,'401','2022-09-06 15:24:24','600','2022-09-06 15:26:23',10,0),('5','97',257677,'Full time shift','2022-08-28','2022-09-06 15:26:53','2022-09-07 15:26:53','401',1670786.80,1670786.80,'401','2022-09-06 15:31:39','600','2022-09-06 15:39:01',10,0),('5','97',257678,'Full time shift','2022-08-29','2022-09-06 15:39:37','2022-09-07 15:39:37','401',1477361.90,1477361.90,'401','2022-09-06 15:41:43','600','2022-09-06 16:06:55',10,0),('5','97',257679,'Full time shift','2022-08-30','2022-09-06 16:11:55','2022-09-07 16:11:55','401',1353767.10,1353767.10,'401','2022-09-06 16:16:47','600','2022-09-06 16:17:42',10,0),('5','97',257680,'Full time shift','2022-08-31','2022-09-06 16:18:42','2022-09-07 16:18:42','401',1484042.25,1484042.25,'401','2022-09-06 16:21:30','600','2022-09-06 16:22:11',10,0),('5','97',257681,'Full time shift','2022-09-01','2022-09-06 16:23:13','2022-09-07 16:23:13','401',1562393.45,1562393.45,'401','2022-09-06 16:25:23','600','2022-09-06 16:26:36',10,0),('5','97',257682,'Full time shift','2022-09-02','2022-09-06 16:27:29','2022-09-07 16:27:29','401',1626878.90,1626878.90,'401','2022-09-06 16:29:40','600','2022-09-06 16:29:55',10,0),('5','97',257683,'Full time shift','2022-09-03','2022-09-06 16:30:46','2022-09-07 16:30:46','401',1460549.10,1460549.10,'401','2022-09-06 16:32:19','600','2022-09-06 16:33:08',10,0),('5','97',257684,'Full time shift','2022-09-04','2022-09-06 16:33:35','2022-09-07 16:33:35','401',1706884.00,1706884.00,'401','2022-09-06 16:34:45','600','2022-09-06 16:36:12',10,0),('5','97',257685,'Full time shift','2022-09-05','2022-09-06 16:36:48','2022-09-07 16:36:48','401',1482214.45,1482214.45,'401','2022-09-06 16:38:05','600','2022-09-06 16:41:11',10,0),('5','97',257686,'Full time shift','2022-09-06','2022-09-06 16:41:28','2022-09-07 16:41:28','401',1627583.75,1627583.75,'401','2022-09-06 22:56:43','600','2022-09-07 09:22:46',10,0),('5','97',257687,'Full time shift','2022-09-07','2022-09-07 09:51:25','2022-09-08 09:51:25','401',1411995.85,1411995.85,'401','2022-09-07 21:14:28','600','2022-09-08 08:52:47',10,0),('5','97',257688,'Full time shift','2022-09-08','2022-09-08 10:32:06','2022-09-09 10:32:06','401',1610837.55,1610837.55,'401','2022-09-08 21:07:32','600','2022-09-09 09:14:24',10,0),('5','97',257689,'Full time shift','2022-09-09','2022-09-09 11:13:28','2022-09-10 11:13:28','401',593505.90,593505.90,'401','2022-09-09 22:00:48','600','2022-09-10 09:39:25',10,0),('5','97',257690,'Full time shift','2022-09-10','2022-09-10 21:06:51','2022-09-11 21:06:51','401',1516741.00,1516741.00,'401','2022-09-10 22:48:30','600','2022-09-11 05:53:24',10,0),('5','97',257691,'Full time shift','2022-09-11','2022-09-11 09:12:38','2022-09-12 09:12:38','401',1407158.10,1407158.10,'401','2022-09-11 22:34:32','600','2022-09-12 05:52:07',10,0),('5','97',257692,'Full time shift','2022-09-12','2022-09-12 09:51:03','2022-09-13 09:51:03','401',1479642.95,1479642.95,'401','2022-09-12 22:23:53','600','2022-09-13 10:22:18',10,0),('5','97',257693,'Full time shift','2022-09-13','2022-09-13 18:28:07','2022-09-14 18:28:07','401',1308355.15,1308355.15,'401','2022-09-13 20:00:20','600','2022-09-14 05:59:30',10,0),('5','97',257694,'Full time shift','2022-09-14','2022-09-14 07:28:51','2022-09-15 07:28:51','401',1259951.75,1259951.75,'401','2022-09-14 22:05:54','600','2022-09-15 06:26:27',10,0),('5','97',257695,'Full time shift','2022-09-15','2022-09-15 13:05:03','2022-09-16 13:05:03','401',925534.65,925534.65,'401','2022-09-16 07:43:58','600','2022-09-16 10:16:39',10,0),('5','97',257696,'Full time shift','2022-09-16','2022-09-16 22:31:33','2022-09-17 22:31:33','401',490268.50,490268.50,'401','2022-09-16 22:32:18','600','2022-09-17 08:18:18',10,0),('5','97',257697,'Full time shift','2022-09-17','2022-09-17 18:28:17','2022-09-18 18:28:17','401',1026050.70,1026050.70,'401','2022-09-17 23:41:08','600','2022-09-18 08:24:01',10,0),('5','97',257698,'Full time shift','2022-09-18','2022-09-18 08:29:34','2022-09-19 08:29:34','401',1429317.40,1429317.40,'401','2022-09-18 21:19:49','600','2022-09-19 08:00:41',10,0),('5','97',257699,'Full time shift','2022-09-19','2022-09-19 13:55:37','2022-09-20 13:55:37','401',1462425.00,1462425.00,'401','2022-09-19 23:00:03','600','2022-09-20 05:57:48',10,0),('5','97',257700,'Full time shift','2022-09-20','2022-09-20 22:35:50','2022-09-21 22:35:50','401',2013486.35,2013486.35,'401','2022-09-20 22:37:31','600','2022-09-21 06:07:15',10,0),('5','97',257701,'Full time shift','2022-09-21','2022-09-21 13:47:00','2022-09-22 13:47:00','401',1149919.30,1149919.30,'401','2022-09-21 21:31:46','600','2022-09-22 08:42:17',10,0),('5','97',257702,'Full time shift','2022-09-22','2022-09-22 21:33:50','2022-09-23 21:33:50','401',1643179.25,1643179.25,'401','2022-09-22 21:35:32','600','2022-09-23 10:28:31',10,0),('5','97',257703,'Full time shift','2022-09-23','2022-09-23 22:22:56','2022-09-24 22:22:56','401',1489144.55,1489144.55,'401','2022-09-23 22:24:38','600','2022-09-24 05:55:11',10,0),('5','97',257704,'Full time shift','2022-09-24','2022-09-24 13:27:28','2022-09-25 13:27:28','401',388537.00,388537.00,'401','2022-09-24 21:54:34','600','2022-09-25 08:19:49',10,0),('5','97',257705,'Full time shift','2022-09-25','2022-09-25 21:20:18','2022-09-26 21:20:18','401',1141594.30,1141594.30,'401','2022-09-25 21:21:33','600','2022-09-26 08:24:11',10,0),('5','97',257706,'Full time shift ','2022-09-26','2022-09-26 22:23:36','2022-09-27 22:23:36','401',1552962.15,1552962.15,'401','2022-09-26 22:25:44','600','2022-09-27 06:05:02',10,0),('5','97',257707,'Full time shift','2022-09-27','2022-09-27 23:27:40','2022-09-28 23:27:40','401',1557398.45,1557398.45,'401','2022-09-27 23:29:14','600','2022-09-28 10:00:55',10,0),('5','97',257708,'Full time shift','2022-09-28','2022-09-28 22:03:43','2022-09-29 22:03:43','401',1544672.30,1544672.30,'401','2022-09-28 23:23:23','600','2022-09-29 06:14:49',10,0),('5','97',257709,'Full time shift','2022-09-29','2022-09-29 23:26:01','2022-09-30 23:26:01','401',1557398.45,1557398.45,'401','2022-09-29 23:32:16','600','2022-09-30 08:18:07',10,0),('5','97',257710,'Full time shift','2022-09-30','2022-10-01 00:03:51','2022-10-02 00:03:51','401',1729655.65,1729655.65,'401','2022-10-01 00:05:25','600','2022-10-01 10:21:22',10,0),('5','97',257711,'Full time shift','2022-10-01','2022-10-01 13:09:52','2022-10-02 13:09:52','401',1956813.45,1956813.45,'401','2022-10-01 21:52:28','600','2022-10-02 05:06:39',10,0),('5','97',257712,'Full time shift','2022-10-03','2022-10-03 15:36:16','2022-10-04 15:36:16','401',2303877.15,2303877.15,'401','2022-10-03 15:40:29','600','2022-10-04 09:06:02',10,0),('5','97',257713,'Full time shift','2022-10-03','2022-10-04 09:30:47','2022-10-05 09:30:47','401',2329958.45,2329958.45,'401','2022-10-04 14:28:26','600','2022-10-05 06:16:29',10,0),('5','97',257714,'Full time shift','2022-10-04','2022-10-05 14:53:45','2022-10-06 14:53:45','401',2001781.40,2001781.40,'401','2022-10-05 14:55:32','600','2022-10-06 08:03:56',10,0),('5','97',257715,'Full time shift','2022-10-05','2022-10-06 13:59:37','2022-10-07 13:59:37','401',1571188.35,1571188.35,'401','2022-10-06 14:02:56','600','2022-10-07 06:22:30',10,0),('5','97',257716,'Full time shift','2022-10-06','2022-10-07 13:06:19','2022-10-08 13:06:19','401',591502.35,591502.35,'401','2022-10-07 13:07:02','600','2022-10-08 08:11:36',10,0),('5','97',257717,'Full time shift','2022-10-07','2022-10-08 09:45:12','2022-10-09 09:45:12','401',925049.95,925049.95,'401','2022-10-09 00:36:42','600','2022-10-09 07:55:21',10,0),('5','97',257718,'Full time shift','2022-10-08','2022-10-09 09:14:10','2022-10-10 09:14:10','401',0.00,0.00,'401','2022-10-09 09:14:45','600','2022-10-10 10:25:39',10,0),('5','97',257719,'Full time shift','2022-10-09','2022-10-10 18:40:00','2022-10-11 18:40:00','401',0.00,0.00,'401','2022-10-10 18:40:45','600','2022-10-11 08:32:06',10,0),('5','97',257720,'Full time shift','2022-10-10','2022-10-11 09:20:37','2022-10-12 09:20:37','401',0.00,0.00,'401','2022-10-11 09:26:11','600','2022-10-11 12:29:43',10,0),('5','97',257721,'Full time shift','2022-10-11','2022-10-12 00:45:25','2022-10-13 00:45:25','401',0.00,0.00,'401','2022-10-12 00:45:52','600','2022-10-12 08:57:45',10,0),('5','97',257722,'Full time shift','2022-10-12','2022-10-12 09:18:24','2022-10-13 09:18:24','401',0.00,0.00,'401','2022-10-13 23:46:07','600','2022-10-14 08:12:04',10,0),('5','97',257723,'Full time shift','2022-10-13','2022-10-14 08:57:23','2022-10-15 08:57:23','401',0.00,0.00,'401','2022-10-14 08:57:56','600','2022-10-15 10:27:07',10,0),('5','97',257724,'Full time shift','2022-10-14','2022-10-15 10:58:08','2022-10-16 10:58:08','401',0.00,0.00,'401','2022-10-15 10:58:36','600','2022-10-16 09:57:10',10,0),('5','97',257725,'Full time shift','2022-10-15','2022-10-16 13:53:52','2022-10-17 13:53:52','401',0.00,0.00,'401','2022-10-16 13:54:11','600','2022-10-17 08:06:47',10,0),('5','97',257726,'Full time shift it','2022-10-16','2022-10-17 22:28:27','2022-10-18 22:28:27','401',0.00,0.00,'401','2022-10-17 22:28:55','600','2022-10-18 06:36:41',10,0),('5','97',257727,'Full time shift','2022-10-17','2022-10-18 11:56:35','2022-10-19 11:56:35','401',0.00,0.00,'401','2022-10-18 11:56:55','600','2022-10-18 21:27:25',10,0),('5','97',257728,'Full time shift','2022-10-18','2022-10-18 23:44:52','2022-10-19 23:44:52','401',0.00,0.00,'401','2022-10-18 23:45:29','600','2022-10-19 05:58:46',10,0),('5','97',257729,'Full time shift ','2022-10-19','2022-10-19 08:12:34','2022-10-20 08:12:34','401',0.00,0.00,'401','2022-10-20 00:43:57','600','2022-10-20 09:07:13',10,0),('5','97',257730,'Full time shift','2022-10-20','2022-10-20 12:08:41','2022-10-21 12:08:41','401',0.00,0.00,'401','2022-10-20 23:20:05','600','2022-10-21 05:58:18',10,0),('5','97',257731,'Full time shift','2022-10-21','2022-10-21 12:04:17','2022-10-22 12:04:17','401',0.00,0.00,'401','2022-10-22 12:33:40','600','2022-10-23 05:51:21',10,0),('5','97',257732,'Full time shift','2022-10-22','2022-10-23 09:17:54','2022-10-24 09:17:54','401',0.00,0.00,'401','2022-10-23 09:18:48','600','2022-10-23 12:25:53',10,0),('5','97',257733,'Full time shift','2022-10-23','2022-10-23 20:28:10','2022-10-24 20:28:10','401',0.00,0.00,'401','2022-10-23 20:29:17','600','2022-10-24 06:01:20',10,0),('5','97',257734,'Full time shift50','2022-10-24','2022-10-24 19:20:28','2022-10-25 19:20:28','401',0.00,0.00,'401','2022-10-24 20:07:41','600','2022-10-25 05:55:11',10,0),('5','97',257735,'Full time shift','2022-10-25','2022-10-25 10:38:26','2022-10-26 10:38:26','401',0.00,0.00,'401','2022-10-25 18:54:01','600','2022-10-26 06:01:18',10,0),('5','97',257736,'Full time shift','2022-10-26','2022-10-26 20:25:33','2022-10-27 20:25:33','401',535225.35,535225.35,'401','2022-10-27 07:22:54','600','2022-10-27 10:15:10',10,0),('5','97',257737,'Full time shift','2022-10-27','2022-10-27 16:19:11','2022-10-28 16:19:11','401',1601132.45,1601132.45,'401','2022-10-28 00:28:49','600','2022-10-28 08:02:30',10,0),('5','97',257738,'Full time shift','2022-10-28','2022-10-28 11:20:54','2022-10-29 11:20:54','401',1807179.90,1807179.90,'401','2022-10-28 22:34:08','600','2022-10-29 09:35:58',10,0),('5','97',257739,'Full time shift','2022-10-29','2022-10-29 14:26:58','2022-10-30 14:26:58','401',1753239.45,1753239.45,'401','2022-10-29 20:47:11','600','2022-10-30 05:47:41',10,0),('5','97',257740,'Full time shift ','2022-10-30','2022-10-30 21:00:34','2022-10-31 21:00:34','401',2019885.50,2019885.50,'401','2022-10-30 21:02:00','600','2022-10-31 06:01:04',10,0),('5','97',257741,'Full time shift ','2022-10-31','2022-10-31 13:51:40','2022-11-01 13:51:40','401',2363262.15,2363262.15,'401','2022-11-01 21:16:05','600','2022-11-01 21:18:15',10,0),('5','97',257742,'Full time shift','2022-11-01','2022-11-01 21:26:54','2022-11-02 21:26:54','401',2484932.95,2484932.95,'401','2022-11-01 21:32:38','600','2022-11-02 05:59:06',10,0),('5','97',257743,'Full time shift','2022-11-02','2022-11-02 14:36:22','2022-11-03 14:36:22','401',2674968.65,2674968.65,'401','2022-11-03 12:04:24','600','2022-11-03 16:26:39',10,0),('5','97',257744,'Full time shift','2022-11-03','2022-11-03 21:40:58','2022-11-04 21:40:58','401',2641454.05,2641454.05,'401','2022-11-03 21:45:31','600','2022-11-04 08:12:02',10,0),('5','97',257745,'Full time shift','2022-11-04','2022-11-04 23:57:37','2022-11-05 23:57:37','401',2345602.05,2345602.05,'401','2022-11-05 22:25:13','600','2022-11-06 09:16:20',10,0),('5','97',257746,'Full time shift','2022-11-06','2022-11-06 23:36:50','2022-11-07 23:36:50','401',2372160.65,2372160.65,'401','2022-11-06 23:40:20','600','2022-11-07 06:06:14',10,0),('5','97',257747,'Full time shift','2022-11-07','2022-11-07 10:01:38','2022-11-08 10:01:38','401',2313326.95,2313326.95,'401','2022-11-07 10:06:45','600','2022-11-08 08:16:27',10,0),('5','97',257748,'Full time shift','2022-11-07','2022-11-08 08:35:45','2022-11-09 08:35:45','401',1821165.90,1821165.90,'401','2022-11-08 08:42:13','606','2022-11-08 15:51:17',10,0),('5','97',257749,'Full time shift','2022-11-08','2022-11-09 12:24:00','2022-11-10 12:24:00','401',1697191.85,1697191.85,'401','2022-11-09 12:25:45','600','2022-11-09 15:36:33',10,0),('5','97',257750,'Full time shift','2022-11-09','2022-11-09 23:17:32','2022-11-10 23:17:32','401',1532974.75,1532974.75,'401','2022-11-09 23:18:39','600','2022-11-10 09:28:18',10,0),('5','97',257751,'Full time shift','2022-11-10','2022-11-10 10:16:49','2022-11-11 10:16:49','401',941043.20,941043.20,'401','2022-11-10 23:32:02','600','2022-11-11 09:26:34',10,0),('5','97',257752,'Full time shift','2022-11-11','2022-11-11 21:35:17','2022-11-12 21:35:17','401',526228.80,526228.80,'401','2022-11-11 21:39:02','600','2022-11-12 09:27:31',10,0),('5','97',257753,'Full time shift','2022-11-12','2022-11-12 19:59:37','2022-11-13 19:59:37','401',0.00,0.00,'401','2022-11-13 14:51:21','600','2022-11-14 08:07:46',10,0),('5','97',257754,'Full time shift','2022-11-13','2022-11-15 09:31:49','2022-11-16 09:31:49','401',100519.75,100519.75,'401','2022-11-15 09:34:16','600','2022-11-15 09:35:13',10,0),('5','97',257755,'Full time shift','2022-11-14','2022-11-15 09:36:09','2022-11-16 09:36:09','401',0.00,0.00,'401','2022-11-15 09:36:37','600','2022-11-15 09:37:28',10,0),('5','97',257756,'Full time shift','2022-11-15','2022-11-15 09:39:04','2022-11-16 09:39:04','401',0.00,0.00,'401','2022-11-16 08:37:38','600','2022-11-16 09:37:55',10,0),('5','97',257757,'Full time shift','2022-11-16','2022-11-16 10:33:04','2022-11-17 10:33:04','401',0.00,0.00,'401','2022-11-16 18:38:30','600','2022-11-17 09:54:43',10,0),('5','97',257758,'Full time shift','2022-11-17','2022-11-17 23:31:38','2022-11-18 23:31:38','401',0.00,0.00,'401','2022-11-17 23:32:03','600','2022-11-18 08:36:23',10,0),('5','97',257759,'Full time shift','2022-11-18','2022-11-18 21:25:45','2022-11-19 21:25:45','401',0.00,0.00,'401','2022-11-18 21:26:10','600','2022-11-19 09:14:08',10,0),('5','97',257760,'Full time shift','2022-11-19','2022-11-19 18:25:47','2022-11-20 18:25:47','401',0.00,0.00,'401','2022-11-19 18:26:09','600','2022-11-20 10:32:02',10,0),('5','97',257761,'Full time shift','2022-11-20','2022-11-20 23:43:25','2022-11-21 23:43:25','401',552262.00,552262.00,'401','2022-11-20 23:47:11','600','2022-11-21 06:05:24',10,0),('5','97',257762,'Full time shift','2022-11-21','2022-11-21 15:20:45','2022-11-22 15:20:45','401',1549693.20,1549693.20,'401','2022-11-21 23:29:59','600','2022-11-22 08:11:42',10,0),('5','97',257763,'Full time shift','2022-11-22','2022-11-22 22:47:25','2022-11-23 22:47:25','401',1849443.15,1849443.15,'401','2022-11-22 22:51:08','600','2022-11-23 06:10:35',10,0),('5','97',257764,'Full time shift','2022-11-23','2022-11-23 13:21:00','2022-11-24 13:21:00','401',1699175.05,1699175.05,'401','2022-11-23 22:58:39','600','2022-11-24 06:45:02',10,0),('5','97',257765,'Daily ','2022-11-24','2022-11-24 10:20:48','2022-11-25 10:20:48','600',1468579.95,1468579.95,'401','2022-11-24 23:26:44','600','2022-11-25 06:07:27',10,0),('5','97',257766,'Full time shift','2022-11-25','2022-11-26 00:03:25','2022-11-27 00:03:25','401',929119.95,929119.95,'401','2022-11-26 00:04:48','600','2022-11-26 09:22:33',10,0),('5','97',257767,'Full time shift','2022-11-26','2022-11-26 22:46:48','2022-11-27 22:46:48','401',372331.00,372331.00,'401','2022-11-26 22:47:54','600','2022-11-27 09:28:53',10,0),('5','97',257768,'Full time shift','2022-11-27','2022-11-28 08:38:59','2022-11-29 08:38:59','401',0.00,0.00,'401','2022-11-28 08:39:19','600','2022-11-28 10:11:25',10,0),('5','97',257769,'Full time shift','2022-11-28','2022-11-28 18:51:28','2022-11-29 18:51:28','401',0.00,0.00,'401','2022-11-28 18:52:05','600','2022-11-29 06:01:33',10,0),('5','97',257770,'Full time shift ','2022-11-29','2022-11-30 05:53:06','2022-12-01 05:53:06','401',558755.50,558755.50,'401','2022-11-30 05:55:13','600','2022-11-30 06:18:54',10,0),('5','97',257771,'Full time shift','2022-11-30','2022-11-30 10:43:07','2022-12-01 10:43:07','401',1530784.35,1530784.35,'401','2022-11-30 22:16:08','600','2022-12-01 06:07:05',10,0),('5','97',257772,'Full time shift','2022-12-01','2022-12-01 23:10:11','2022-12-02 23:10:11','401',1525534.05,1525534.05,'401','2022-12-01 23:11:39','600','2022-12-02 06:09:29',10,0),('5','97',257773,'Full time shift','2022-12-02','2022-12-02 23:51:57','2022-12-03 23:51:57','401',1524007.80,1524007.80,'401','2022-12-02 23:54:53','600','2022-12-03 10:08:11',10,0),('5','97',257774,'Full time shift','2022-12-03','2022-12-03 21:52:44','2022-12-04 21:52:44','401',1312619.40,1312619.40,'401','2022-12-03 21:54:14','600','2022-12-04 09:04:23',10,0),('5','97',257775,'Full time shift','2022-12-04','2022-12-05 01:05:21','2022-12-06 01:05:21','401',787685.60,787685.60,'401','2022-12-05 01:08:27','600','2022-12-05 08:13:42',10,0),('5','97',257776,'Full time shift','2022-12-05','2022-12-06 08:56:14','2022-12-07 08:56:14','401',0.00,0.00,'401','2022-12-06 08:56:34','600','2022-12-07 06:13:13',10,0),('5','97',257777,'Full time shift','2022-12-07','2022-12-07 19:18:37','2022-12-08 19:18:37','401',0.00,0.00,'401','2022-12-07 19:20:10','600','2022-12-09 06:05:54',10,0),('5','97',257778,'Full time shift','2022-12-08','2022-12-09 13:24:49','2022-12-10 13:24:49','401',0.00,0.00,'401','2022-12-09 13:25:08','600','2022-12-09 14:47:32',10,0),('5','97',257779,'Full time shift','2022-12-09','2022-12-09 18:56:37','2022-12-10 18:56:37','401',0.00,0.00,'401','2022-12-09 19:06:30','600','2022-12-10 06:07:50',10,0),('5','97',257780,'Full time shift','2022-12-10','2022-12-10 21:55:29','2022-12-11 21:55:29','401',0.00,0.00,'401','2022-12-10 21:56:44','600','2022-12-11 09:16:12',10,0),('5','97',257781,'Full time shift','2022-12-11','2022-12-11 23:39:53','2022-12-12 23:39:53','401',0.00,0.00,'401','2022-12-11 23:40:26','600','2022-12-12 06:18:57',10,0),('5','97',257782,'Full time shift','2022-12-12','2022-12-12 20:37:20','2022-12-13 20:37:20','401',0.00,0.00,'401','2022-12-12 20:37:46','600','2022-12-13 09:18:50',10,0),('5','97',257783,'Full time shift','2022-12-13','2022-12-13 20:05:42','2022-12-14 20:05:42','401',0.00,0.00,'401','2022-12-13 20:06:12','797','2022-12-14 09:37:52',10,0),('5','97',257784,'Full time shift','2022-12-14','2022-12-14 19:13:13','2022-12-15 19:13:13','401',0.00,0.00,'401','2022-12-14 19:13:56','797','2022-12-15 09:49:18',10,0),('5','97',257785,'Full time shift','2022-12-15','2022-12-15 22:38:17','2022-12-16 22:38:17','401',0.00,0.00,'401','2022-12-15 22:38:39','797','2022-12-16 09:58:46',10,0),('5','97',257786,'Full time shift','2022-12-16','2022-12-16 20:29:26','2022-12-17 20:29:26','401',0.00,0.00,'401','2022-12-16 20:29:58','797','2022-12-17 12:15:10',10,0),('5','97',257787,'Full time shift','2022-12-17','2022-12-17 20:16:39','2022-12-18 20:16:39','401',0.00,0.00,'401','2022-12-17 20:17:12','797','2022-12-18 12:31:57',10,0),('5','97',257788,'Full time shift ','2022-12-18','2022-12-18 22:55:37','2022-12-19 22:55:37','401',496040.50,496040.50,'401','2022-12-18 23:01:05','797','2022-12-19 08:55:37',10,0),('5','97',257789,'Full time shift','2022-12-19','2022-12-19 21:52:27','2022-12-20 21:52:27','401',1518809.30,1518809.30,'401','2022-12-19 21:55:46','797','2022-12-20 09:00:29',10,0),('5','97',257790,'Full time shift','2022-12-20','2022-12-20 22:53:31','2022-12-21 22:53:31','401',1669589.85,1669589.85,'401','2022-12-20 23:04:24','797','2022-12-21 09:17:45',10,0),('5','97',257791,'Full time shift','2022-12-21','2022-12-21 22:04:40','2022-12-22 22:04:40','401',1330927.00,1330927.00,'401','2022-12-21 22:09:48','797','2022-12-22 09:27:09',10,0),('5','97',257792,'Full time shift','2022-12-23','2022-12-23 13:29:53','2022-12-24 13:29:53','401',484200.50,484200.50,'401','2022-12-23 13:33:21','797','2022-12-23 18:34:04',10,0),('5','97',257793,'Full time shift ','2022-12-24','2022-12-24 23:15:40','2022-12-25 23:15:40','401',0.00,0.00,'401','2022-12-24 23:16:14','797','2022-12-25 07:18:25',10,0),('5','97',257794,'Full time shift','2022-12-25','2022-12-25 19:29:37','2022-12-26 19:29:37','401',0.00,0.00,'401','2022-12-25 19:30:00','797','2022-12-26 08:22:22',10,0),('5','97',257795,'Full time shift','2022-12-26','2022-12-26 20:06:15','2022-12-27 20:06:15','401',0.00,0.00,'401','2022-12-26 20:06:54','797','2022-12-27 09:08:59',10,0),('5','97',257796,'Full time shift','2022-12-27','2022-12-27 21:52:48','2022-12-28 21:52:48','401',0.00,0.00,'401','2022-12-27 21:53:40','797','2022-12-28 09:13:15',10,0),('5','97',257797,'Full time shift','2022-12-28','2022-12-28 20:39:54','2022-12-29 20:39:54','401',0.00,0.00,'401','2022-12-28 20:40:13','797','2022-12-29 10:17:01',10,0),('5','97',257798,'Full time shift','2022-12-29','2022-12-29 11:20:17','2022-12-30 11:20:17','401',0.00,0.00,'401','2022-12-29 18:33:34','797','2022-12-30 09:00:43',10,0),('5','97',257799,'Full time shift','2022-12-30','2022-12-31 17:48:54','2023-01-01 17:48:54','401',0.00,0.00,'401','2022-12-31 17:49:12','797','2022-12-31 17:51:07',10,0),('5','97',257800,'Full time shift','2022-12-31','2022-12-31 17:56:43','2023-01-01 17:56:43','401',0.00,0.00,'401','2022-12-31 17:57:10','797','2023-01-01 08:51:52',10,0),('5','97',257801,'Full time shift','2023-01-01','2023-01-01 21:44:32','2023-01-02 21:44:32','401',0.00,0.00,'401','2023-01-01 21:44:59','797','2023-01-02 08:20:17',10,0),('5','97',257802,'Full time shift','2023-01-02','2023-01-02 14:51:03','2023-01-03 14:51:03','401',0.00,0.00,'401','2023-01-02 18:13:18','797','2023-01-03 10:33:17',10,0),('5','97',257803,'Full time shift','2023-01-03','2023-01-03 18:29:59','2023-01-04 18:29:59','401',0.00,0.00,'401','2023-01-03 18:30:20','797','2023-01-04 11:24:04',10,0),('5','97',257804,'Full time shift','2023-01-04','2023-01-04 13:16:58','2023-01-05 13:16:58','401',0.00,0.00,'401','2023-01-04 19:17:01','797','2023-01-04 21:49:10',10,0),('5','97',257805,'Full time shift','2023-01-05','2023-01-05 17:59:26','2023-01-06 17:59:26','401',0.00,0.00,'401','2023-01-05 17:59:49','797','2023-01-06 15:01:54',10,0),('5','97',257806,'Full time shift ','2023-01-06','2023-01-06 16:27:02','2023-01-07 16:27:02','401',0.00,0.00,'401','2023-01-06 16:27:26','797','2023-01-07 05:47:23',10,0),('5','97',257807,'Full time shift','2023-01-07','2023-01-07 19:09:57','2023-01-08 19:09:57','401',0.00,0.00,'401','2023-01-07 19:10:15','797','2023-01-08 09:35:06',10,0),('5','97',257808,'Full time shift','2023-01-08','2023-01-09 00:19:57','2023-01-10 00:19:57','401',0.00,0.00,'401','2023-01-09 00:20:17','797','2023-01-09 09:46:10',10,0),('5','97',257809,'Full time shift','2023-01-09','2023-01-09 10:02:35','2023-01-10 10:02:35','401',0.00,0.00,'401','2023-01-09 23:35:38','797','2023-01-10 09:19:30',10,0),('5','97',257810,'Full time shift4','2023-01-10','2023-01-10 20:58:45','2023-01-11 20:58:45','401',0.00,0.00,'401','2023-01-10 20:59:51','797','2023-01-11 09:43:35',10,0),('5','97',257811,'Full time shift','2023-01-11','2023-01-11 21:43:32','2023-01-12 21:43:32','401',0.00,0.00,'401','2023-01-11 21:43:59','797','2023-01-12 09:31:20',10,0),('5','97',257812,'Full time shift','2023-01-12','2023-01-12 19:30:02','2023-01-13 19:30:02','401',0.00,0.00,'401','2023-01-12 19:30:23','797','2023-01-13 09:21:27',10,0),('5','97',257813,'Full time shift','2023-01-13','2023-01-13 23:23:55','2023-01-14 23:23:55','401',0.00,0.00,'401','2023-01-13 23:24:41','797','2023-01-14 16:52:02',10,0),('5','97',257814,'Full time shift','2023-01-14','2023-01-14 22:09:04','2023-01-15 22:09:04','401',0.00,0.00,'401','2023-01-14 22:09:49','797','2023-01-15 07:55:00',10,0),('5','97',257815,'Full time shift','2023-01-15','2023-01-15 22:21:28','2023-01-16 22:21:28','401',0.00,0.00,'401','2023-01-15 22:22:00','797','2023-01-16 10:12:11',10,0),('5','97',257816,'Full time shift','2023-01-16','2023-01-16 23:45:06','2023-01-17 23:45:06','401',370943.50,370943.50,'401','2023-01-16 23:47:29','797','2023-01-17 10:14:31',10,0),('5','97',257817,'Full time shift','2023-01-17','2023-01-17 11:36:41','2023-01-18 11:36:41','401',1986383.85,1986383.85,'401','2023-01-17 23:01:17','797','2023-01-18 09:15:34',10,0),('5','97',257818,'Full time shift','2023-01-18','2023-01-18 09:49:01','2023-01-19 09:49:01','401',1894285.30,1894285.30,'401','2023-01-18 21:18:42','797','2023-01-19 09:19:23',10,0),('5','97',257819,'Full time shift','2023-01-19','2023-01-19 22:37:16','2023-01-20 22:37:16','401',1517741.85,1517741.85,'401','2023-01-19 22:38:16','797','2023-01-20 09:25:57',10,0),('5','97',257820,'Full time shift','2023-01-20','2023-01-20 12:54:57','2023-01-21 12:54:57','401',1182634.70,1182634.70,'401','2023-01-20 12:55:34','797','2023-01-20 13:10:49',10,0),('5','97',257821,'Full time shift','2023-01-20','2023-01-20 15:38:34','2023-01-21 15:38:34','401',697028.20,828898.40,'401','2023-01-20 23:55:21','797','2023-01-21 06:52:34',10,0),('5','97',257822,'Full time shift','2023-01-21','2023-01-21 22:17:55','2023-01-22 22:17:55','401',642789.90,764398.80,'401','2023-01-21 22:19:06','797','2023-01-22 10:43:03',10,0),('5','97',257823,'Full time shift','2023-01-22','2023-01-23 10:26:14','2023-01-24 10:26:14','401',0.00,0.00,'401','2023-01-23 10:26:33','797','2023-01-23 10:35:53',10,0),('5','97',257824,'Full time shift','2023-01-23','2023-01-24 10:22:46','2023-01-25 10:22:46','401',0.00,0.00,'401','2023-01-24 10:23:05','797','2023-01-24 10:39:14',10,0),('5','97',257825,'Full time shift','2023-01-24','2023-01-24 10:51:59','2023-01-25 10:51:59','401',2244655.60,2244655.60,'401','2023-01-24 23:19:22','797','2023-01-25 09:31:07',10,0),('5','97',257826,'Full time shift ','2023-01-25','2023-01-25 14:14:14','2023-01-26 14:14:14','401',2280025.00,2280025.00,'401','2023-01-26 00:23:25','797','2023-01-26 09:21:51',10,0),('5','97',257827,'Full time shift','2023-01-26','2023-01-26 23:32:00','2023-01-27 23:32:00','401',2163517.40,1819321.45,'401','2023-01-26 23:33:30','797','2023-01-27 09:44:18',10,0),('5','97',257828,'Full time shift ','2023-01-27','2023-01-27 15:43:10','2023-01-28 15:43:10','401',2038143.80,1713893.65,'401','2023-01-27 23:59:05','797','2023-01-28 09:44:50',10,0),('5','97',257829,'Full time shift','2023-01-28','2023-01-28 10:13:42','2023-01-29 10:13:42','401',0.00,0.00,'401','2023-01-28 23:55:50','797','2023-01-29 11:00:12',10,0),('5','97',257830,'Full time shift ','2023-01-29','2023-01-29 21:41:45','2023-01-30 21:41:45','401',0.00,0.00,'401','2023-01-29 21:42:27','797','2023-01-30 09:22:43',10,0),('5','97',257831,'Full time shift','2023-01-30','2023-01-31 09:15:33','2023-02-01 09:15:33','401',0.00,0.00,'401','2023-01-31 09:16:01','797','2023-01-31 11:09:07',10,0),('5','97',257832,'Full time shift','2023-01-31','2023-01-31 16:28:25','2023-02-01 16:28:25','401',0.00,0.00,'401','2023-02-01 00:15:22','797','2023-02-01 13:53:40',10,0),('5','97',257833,'Full time shift ','2023-02-01','2023-02-01 15:43:27','2023-02-02 15:43:27','401',0.00,0.00,'401','2023-02-01 20:50:53','797','2023-02-02 11:30:27',10,0),('5','97',257834,'Full time shift','2023-02-02','2023-02-02 14:56:23','2023-02-03 14:56:23','401',0.00,0.00,'401','2023-02-02 22:58:56','797','2023-02-03 10:02:07',10,0),('5','97',257835,'Full time shift','2023-02-03','2023-02-03 23:37:28','2023-02-04 23:37:28','401',0.00,0.00,'401','2023-02-03 23:37:48','797','2023-02-04 13:19:40',10,0),('5','97',257836,'Full time shift','2023-02-04','2023-02-04 21:23:56','2023-02-05 21:23:56','401',0.00,0.00,'401','2023-02-04 21:24:30','797','2023-02-05 11:50:54',10,0),('5','97',257837,'Full time shift','2023-02-05','2023-02-05 13:17:44','2023-02-06 13:17:44','401',0.00,0.00,'401','2023-02-05 22:08:06','797','2023-02-06 09:07:35',10,0),('5','97',257838,'Full time shift','2023-02-07','2023-02-07 09:57:17','2023-02-08 09:57:17','401',441144.00,441144.00,'401','2023-02-07 09:59:01','797','2023-02-07 11:15:39',10,0),('5','97',257839,'Full time shift','2023-02-07','2023-02-07 16:18:39','2023-02-08 16:18:39','401',2506688.80,2506688.80,'401','2023-02-08 00:33:17','797','2023-02-08 09:24:22',10,0),('5','97',257840,'Full time shift ','2023-02-08','2023-02-08 16:18:43','2023-02-09 16:18:43','401',1768738.40,1768738.40,'401','2023-02-08 23:36:19','797','2023-02-09 09:24:16',10,0),('5','97',257841,'Full time shift ','2023-02-09','2023-02-10 00:57:32','2023-02-11 00:57:32','401',1988063.00,1988063.00,'401','2023-02-10 01:01:02','797','2023-02-10 09:03:10',10,0),('5','97',257842,'Full time shift','2023-02-10','2023-02-10 14:07:16','2023-02-11 14:07:16','401',1881873.40,1881873.40,'401','2023-02-10 23:47:08','797','2023-02-11 09:41:41',10,0),('5','97',257843,'Full time shift','2023-02-11','2023-02-11 23:45:01','2023-02-12 23:45:01','401',1775622.20,1775622.20,'401','2023-02-12 06:28:07','797','2023-02-12 07:35:51',10,0),('5','97',257844,'Full time shift','2023-02-12','2023-02-12 23:46:43','2023-02-13 23:46:43','401',1736389.60,1736389.60,'401','2023-02-13 09:41:55','797','2023-02-13 10:05:31',10,0),('5','97',257845,'Full time shift','2023-02-13','2023-02-13 23:05:12','2023-02-14 23:05:12','401',326686.80,326686.80,'401','2023-02-13 23:06:41','797','2023-02-14 09:36:18',10,0),('5','97',257846,'Full time shift','2023-02-14','2023-02-14 22:39:44','2023-02-15 22:39:44','401',0.00,0.00,'401','2023-02-14 22:40:39','797','2023-02-15 09:23:34',10,0),('5','97',257847,'Full time shift','2023-02-15','2023-02-15 09:37:36','2023-02-16 09:37:36','401',0.00,0.00,'401','2023-02-15 22:42:38','797','2023-02-16 08:44:17',10,0),('5','97',257848,'Full time shift ','2023-02-16','2023-02-16 20:01:41','2023-02-17 20:01:41','401',0.00,0.00,'401','2023-02-16 20:02:01','797','2023-02-17 12:21:53',10,0),('5','97',257849,'Full time shift','2023-02-17','2023-02-17 21:54:32','2023-02-18 21:54:32','401',0.00,0.00,'401','2023-02-17 21:54:55','797','2023-02-18 16:30:09',10,0),('5','97',257850,'Full time shift','2023-02-18','2023-02-18 22:08:12','2023-02-19 22:08:12','401',0.00,0.00,'401','2023-02-18 22:08:59','797','2023-02-19 08:32:35',10,0),('5','97',257851,'Full time shift','2023-02-19','2023-02-19 22:48:48','2023-02-20 22:48:48','401',0.00,0.00,'401','2023-02-19 22:49:12','797','2023-02-20 09:19:01',10,0),('5','97',257852,'Full time shift','2023-02-20','2023-02-21 23:36:20','2023-02-22 23:36:20','401',0.00,0.00,'401','2023-02-21 23:36:46','797','2023-02-22 09:49:48',10,0),('5','97',257853,'Full time shift','2023-02-21','2023-02-23 08:46:34','2023-02-24 08:46:34','401',0.00,0.00,'401','2023-02-23 08:46:53','797','2023-02-23 08:53:58',10,0),('5','97',257854,'Full time shift ','2023-02-22','2023-02-23 10:59:01','2023-02-24 10:59:01','401',0.00,0.00,'401','2023-02-23 10:59:30','797','2023-02-23 11:04:39',10,0),('5','97',257855,'Full time shift ','2023-02-23','2023-02-23 19:34:51','2023-02-24 19:34:51','401',0.00,0.00,'401','2023-02-23 19:35:15','797','2023-02-24 18:51:30',10,0),('5','97',257856,'Full time shift ','2023-02-24','2023-02-25 00:13:05','2023-02-26 00:13:05','401',682440.00,682440.00,'401','2023-02-25 00:14:08','797','2023-02-25 10:30:45',10,0),('5','97',257857,'Full time shift','2023-02-25','2023-02-26 23:36:01','2023-02-27 23:36:01','401',1268841.20,1268841.20,'401','2023-02-26 23:37:26','797','2023-02-27 15:39:08',10,0),('5','97',257858,'Full time shift','2023-02-26','2023-02-28 01:31:45','2023-03-01 01:31:45','401',1559727.40,1559727.40,'401','2023-02-28 12:53:21','797','2023-02-28 12:55:18',10,0),('5','97',257859,'Full time shift ','2023-02-27','2023-02-28 13:31:26','2023-03-01 13:31:26','401',2106645.20,2106645.20,'401','2023-02-28 13:33:24','797','2023-02-28 15:39:48',10,0),('5','97',257860,'Full time shift ','2023-02-28','2023-02-28 23:33:36','2023-03-01 23:33:36','401',2768427.20,2642589.60,'401','2023-02-28 23:35:37','797','2023-03-01 09:34:04',10,0),('5','97',257861,'Full time shift','2023-03-01','2023-03-01 23:44:36','2023-03-02 23:44:36','401',2557365.80,2441121.90,'401','2023-03-01 23:46:21','797','2023-03-02 10:08:42',10,0),('5','97',257862,'Full time shift ','2023-03-02','2023-03-02 12:57:56','2023-03-03 12:57:56','401',2607671.00,2489140.50,'401','2023-03-02 23:34:14','797','2023-03-03 09:20:58',10,0),('5','97',257863,'Full time shift ','2023-03-03','2023-03-04 00:21:17','2023-03-05 00:21:17','401',2968179.90,2968179.90,'401','2023-03-05 00:18:42','797','2023-03-05 09:44:42',10,0),('5','97',257864,'Full time shift','2023-03-04','2023-03-06 00:14:33','2023-03-07 00:14:33','401',3390046.80,3390046.80,'401','2023-03-06 00:16:13','797','2023-03-06 09:01:22',10,0),('5','97',257865,'Full time shift ','2023-03-05','2023-03-06 10:19:11','2023-03-07 10:19:11','401',2537635.80,2235536.30,'401','2023-03-06 10:20:37','797','2023-03-06 10:34:15',10,0),('5','97',257866,'Full time shift','2023-03-06','2023-03-06 23:43:06','2023-03-07 23:43:06','401',2747955.00,2747955.00,'401','2023-03-06 23:45:03','797','2023-03-07 09:26:03',10,0),('5','97',257867,'Full time shift ','2023-03-07','2023-03-07 23:22:04','2023-03-08 23:22:04','401',2957070.90,2957070.90,'401','2023-03-08 00:12:12','797','2023-03-08 09:51:34',10,0),('5','97',257868,'Full time shift','2023-03-08','2023-03-08 15:56:55','2023-03-09 15:56:55','401',3295084.80,3295084.80,'401','2023-03-10 09:25:47','797','2023-03-10 09:27:46',10,0),('5','97',257869,'Full time shift','2023-03-09','2023-03-10 09:29:38','2023-03-11 09:29:38','401',2564335.20,2564335.20,'401','2023-03-10 09:30:56','797','2023-03-10 14:10:40',10,0),('5','97',257870,'Full time shift','2023-03-10','2023-03-11 00:06:58','2023-03-12 00:06:58','401',1773792.30,1773792.30,'401','2023-03-11 00:08:21','797','2023-03-11 10:34:01',10,0),('5','97',257871,'Full time shift','2023-03-11','2023-03-12 10:20:39','2023-03-13 10:20:39','401',1785000.00,1785000.00,'401','2023-03-12 13:22:43','797','2023-03-12 14:22:43',10,0),('5','97',257872,'Full time shift','2023-03-12','2023-03-13 01:28:31','2023-03-14 01:28:31','401',1121576.40,1121576.40,'401','2023-03-13 01:29:15','797','2023-03-13 10:00:50',10,0),('5','97',257873,'Full time shift','2023-03-13','2023-03-13 22:19:13','2023-03-14 22:19:13','401',381225.60,381225.60,'401','2023-03-13 22:20:22','797','2023-03-14 08:30:13',10,0),('5','97',257874,'Full time shift','2023-03-14','2023-03-14 22:24:45','2023-03-15 22:24:45','401',0.00,0.00,'401','2023-03-14 22:25:03','797','2023-03-15 08:26:57',10,0),('5','97',257875,'Full time shift ','2023-03-15','2023-03-15 19:55:39','2023-03-16 19:55:39','401',0.00,0.00,'401','2023-03-15 19:56:07','797','2023-03-16 09:33:28',10,0),('5','97',257876,'Full time shift','2023-03-16','2023-03-17 16:18:45','2023-03-18 16:18:45','401',0.00,0.00,'401','2023-03-17 17:37:14','797','2023-03-18 11:02:32',10,0),('5','97',257877,'Full time shift ','2023-03-17','2023-03-18 12:38:21','2023-03-19 12:38:21','401',0.00,0.00,'401','2023-03-18 12:39:03','797','2023-03-18 13:23:42',10,0),('5','97',257878,'Full time shift','2023-03-18','2023-03-18 16:16:18','2023-03-19 16:16:18','401',0.00,0.00,'401','2023-03-18 16:16:35','797','2023-03-19 11:36:08',10,0),('5','97',257879,'Full time shift','2023-03-19','2023-03-19 16:54:46','2023-03-20 16:54:46','401',0.00,0.00,'401','2023-03-19 16:55:52','797','2023-03-20 12:21:00',10,0),('5','97',257880,'Full time shift','2023-03-20','2023-03-20 20:57:15','2023-03-21 20:57:15','401',0.00,0.00,'401','2023-03-20 20:57:55','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4911212 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','97','614','76429',1524927,'1713','237',85775.98,85775.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76429',1524928,'1714','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76429',1524929,'1715','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76429',1524930,'1716','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76429',1524931,'1717','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76429',1524932,'1718','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76429',1524933,'1719','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76429',1524934,'1720','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76429',1524935,'1721','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76429',1524936,'1722','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76429',1524937,'1723','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76429',1524938,'1724','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76429',1524939,'1725','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76429',1524940,'1726','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76429',1524941,'1727','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76429',1524942,'1728','237',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76429',1524943,'1729','238',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76429',1524944,'1730','238',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76429',1524945,'1731','239',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76459',1525466,'1713','237',85775.98,85775.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76459',1525467,'1714','237',298563.78,298563.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76459',1525468,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76459',1525469,'1716','237',260473.80,260473.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76459',1525470,'1717','237',94921.71,94921.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76459',1525471,'1718','237',241789.67,241789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76459',1525472,'1719','237',91529.32,91529.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76459',1525473,'1720','237',213997.87,213997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76459',1525474,'1721','237',25701.70,25701.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76459',1525475,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76459',1525476,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76459',1525477,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76459',1525478,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76459',1525479,'1726','237',189468.10,189468.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76459',1525480,'1727','237',33854.97,33854.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76459',1525481,'1728','237',127080.88,127080.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76459',1525482,'1729','238',90679.97,90679.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76459',1525483,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76459',1525484,'1731','239',35644.78,35644.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76468',1525581,'1713','237',85775.98,85775.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76468',1525582,'1714','237',298563.78,298563.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76468',1525583,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76468',1525584,'1716','237',260473.80,260473.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76468',1525585,'1717','237',94921.71,94921.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76468',1525586,'1718','237',241789.67,241789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76468',1525587,'1719','237',91529.32,91529.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76468',1525588,'1720','237',213997.87,213997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76468',1525589,'1721','237',25701.70,25701.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76468',1525590,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76468',1525591,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76468',1525592,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76468',1525593,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76468',1525594,'1726','237',189468.10,189468.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76468',1525595,'1727','237',33854.97,33854.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76468',1525596,'1728','237',127080.88,127080.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76468',1525597,'1729','238',90679.97,90679.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76468',1525598,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76468',1525599,'1731','239',35644.78,35644.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76516',1526564,'1713','237',85775.98,85775.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76516',1526565,'1714','237',298563.78,298563.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76516',1526566,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76516',1526567,'1716','237',260473.80,260473.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76516',1526568,'1717','237',94921.71,94921.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76516',1526569,'1718','237',241789.67,241789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76516',1526570,'1719','237',91529.32,91529.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76516',1526571,'1720','237',213997.87,213997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76516',1526572,'1721','237',25701.70,25701.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76516',1526573,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76516',1526574,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76516',1526575,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76516',1526576,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76516',1526577,'1726','237',189468.10,189468.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76516',1526578,'1727','237',33854.97,33854.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76516',1526579,'1728','237',127080.88,127080.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76516',1526580,'1729','238',90679.97,90679.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76516',1526581,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76516',1526582,'1731','239',35644.78,35644.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76518',1526633,'1713','237',85775.98,85775.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76518',1526634,'1714','237',298563.78,298563.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76518',1526635,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76518',1526636,'1716','237',260473.80,260473.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76518',1526637,'1717','237',94921.71,94921.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76518',1526638,'1718','237',241789.67,241789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76518',1526639,'1719','237',91529.32,91529.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76518',1526640,'1720','237',213997.87,213997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76518',1526641,'1721','237',25701.70,25701.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76518',1526642,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76518',1526643,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76518',1526644,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76518',1526645,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76518',1526646,'1726','237',189468.10,189468.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76518',1526647,'1727','237',33854.97,33854.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76518',1526648,'1728','237',127080.88,127080.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76518',1526649,'1729','238',90679.97,90679.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76518',1526650,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76518',1526651,'1731','239',35644.78,35644.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76519',1526652,'1713','237',85775.98,85775.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76519',1526653,'1714','237',298563.78,298563.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76519',1526654,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76519',1526655,'1716','237',260473.80,260473.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76519',1526656,'1717','237',94921.71,94921.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76519',1526657,'1718','237',241789.67,241789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76519',1526658,'1719','237',91529.32,91529.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76519',1526659,'1720','237',213997.87,213997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76519',1526660,'1721','237',25701.70,25701.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76519',1526661,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76519',1526662,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76519',1526663,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76519',1526664,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76519',1526665,'1726','237',189468.10,189468.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76519',1526666,'1727','237',33854.97,33854.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76519',1526667,'1728','237',127080.88,127080.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76519',1526668,'1729','238',90679.97,90679.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76519',1526669,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76519',1526670,'1731','239',35644.78,35644.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76520',1526671,'1713','237',85775.98,85775.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76520',1526672,'1714','237',298563.78,298563.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76520',1526673,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76520',1526674,'1716','237',260473.80,260473.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76520',1526675,'1717','237',94921.71,94921.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76520',1526676,'1718','237',241789.67,241789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76520',1526677,'1719','237',91529.32,91529.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76520',1526678,'1720','237',213997.87,213997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76520',1526679,'1721','237',25701.70,25701.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76520',1526680,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76520',1526681,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76520',1526682,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76520',1526683,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76520',1526684,'1726','237',189468.10,189468.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76520',1526685,'1727','237',33854.97,33854.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76520',1526686,'1728','237',127080.88,127080.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76520',1526687,'1729','238',90679.97,90679.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76520',1526688,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76520',1526689,'1731','239',35644.78,35644.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76558',1527523,'1713','237',85775.98,89243.95,3467.97,485515.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','76558',1527524,'1714','237',298563.78,301082.23,2518.45,352583.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76558',1527525,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76558',1527526,'1716','237',260473.80,265608.71,5134.91,718887.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','76558',1527527,'1717','237',94921.71,94921.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76558',1527528,'1718','237',241789.67,241789.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76558',1527529,'1719','237',91529.32,91529.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76558',1527530,'1720','237',213997.87,213997.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76558',1527531,'1721','237',25701.70,25701.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76558',1527532,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76558',1527533,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76558',1527534,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76558',1527535,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76558',1527536,'1726','237',189468.10,191852.21,2384.11,333775.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','76558',1527537,'1727','237',33854.97,35069.92,1214.95,170093.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76558',1527538,'1728','237',127080.88,129724.91,2644.03,370164.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','76558',1527539,'1729','238',90679.97,91823.40,1143.43,291574.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','76558',1527540,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76558',1527541,'1731','239',35644.78,35732.99,88.21,24257.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','76582',1527954,'1713','237',89243.95,89243.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76582',1527955,'1714','237',301082.23,301082.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76582',1527956,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76582',1527957,'1716','237',265608.71,265608.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76582',1527958,'1717','237',94921.71,100460.46,5538.75,775425.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76582',1527959,'1718','237',241789.67,242835.85,1046.18,146465.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','76582',1527960,'1719','237',91529.32,94602.04,3072.72,430180.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','76582',1527961,'1720','237',213997.87,220459.34,6461.47,904605.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','76582',1527962,'1721','237',25701.70,27132.29,1430.59,200282.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','76582',1527963,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76582',1527964,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76582',1527965,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76582',1527966,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76582',1527967,'1726','237',191852.21,191852.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76582',1527968,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76582',1527969,'1728','237',129724.91,129724.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76582',1527970,'1729','238',91823.40,92086.42,263.02,67070.10,0.00,0.00,0.00,0.00,0.00),('5','97','618','76582',1527971,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76582',1527972,'1731','239',35732.99,35770.88,37.89,10419.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','76584',1527996,'1713','237',89243.95,89243.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76584',1527997,'1714','237',301082.23,302388.21,1305.98,182837.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','76584',1527998,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76584',1527999,'1716','237',265608.71,267123.57,1514.86,212080.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','76584',1528000,'1717','237',100460.46,106161.40,5700.94,798131.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','76584',1528001,'1718','237',242835.85,242835.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76584',1528002,'1719','237',94602.04,96009.60,1407.56,197058.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','76584',1528003,'1720','237',220459.34,228186.71,7727.37,1081831.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','76584',1528004,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76584',1528005,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76584',1528006,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76584',1528007,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76584',1528008,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76584',1528009,'1726','237',191852.21,191852.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76584',1528010,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76584',1528011,'1728','237',129724.91,129724.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76584',1528012,'1729','238',92086.42,92347.63,261.21,66608.55,0.00,0.00,0.00,0.00,0.00),('5','97','618','76584',1528013,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76584',1528014,'1731','239',35770.88,35816.05,45.17,12421.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','76591',1528203,'1713','237',89243.95,92120.01,2876.06,402648.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','76591',1528204,'1714','237',302388.21,304735.04,2346.83,328556.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','76591',1528205,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76591',1528206,'1716','237',267123.57,272943.75,5820.18,814825.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','76591',1528207,'1717','237',106161.40,107222.97,1061.57,148619.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','76591',1528208,'1718','237',242835.85,246312.05,3476.20,486668.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76591',1528209,'1719','237',96009.60,96009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76591',1528210,'1720','237',228186.71,232512.10,4325.39,605554.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','76591',1528211,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76591',1528212,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76591',1528213,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76591',1528214,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76591',1528215,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76591',1528216,'1726','237',191852.21,191852.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76591',1528217,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76591',1528218,'1728','237',129724.91,129724.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76591',1528219,'1729','238',92347.63,93023.77,676.14,172415.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','76591',1528220,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76591',1528221,'1731','239',35816.05,35904.60,88.55,24351.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','76597',1528279,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76597',1528280,'1714','237',304735.04,311836.44,7101.40,994196.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76597',1528281,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76597',1528282,'1716','237',272943.75,282446.57,9502.82,1330394.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','76597',1528283,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76597',1528284,'1718','237',246312.05,246312.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76597',1528285,'1719','237',96009.60,96009.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76597',1528286,'1720','237',232512.10,232512.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76597',1528287,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76597',1528288,'1722','237',75179.85,75179.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76597',1528289,'1723','237',207461.85,207461.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76597',1528290,'1724','237',68601.66,68601.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76597',1528291,'1725','237',58122.21,58122.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76597',1528292,'1726','237',191852.21,191852.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76597',1528293,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76597',1528294,'1728','237',129724.91,129724.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76597',1528295,'1729','238',93023.77,93758.25,734.48,187292.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','76597',1528296,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76597',1528297,'1731','239',35904.60,35970.61,66.01,18152.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','76602',1528365,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76602',1528366,'1714','237',311836.44,314909.09,3072.65,430171.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76602',1528367,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76602',1528368,'1716','237',282446.57,286354.98,3908.41,547177.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','76602',1528369,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76602',1528370,'1718','237',246312.05,249866.59,3554.54,497635.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','76602',1528371,'1719','237',96009.60,98455.02,2445.42,342358.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','76602',1528372,'1720','237',232512.10,232816.18,304.08,42571.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','76602',1528373,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76602',1528374,'1722','237',75179.85,75646.67,466.82,65354.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','76602',1528375,'1723','237',207461.85,208506.68,1044.83,146276.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','76602',1528376,'1724','237',68601.66,70338.78,1737.12,243196.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','76602',1528377,'1725','237',58122.21,58144.38,22.17,3103.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','76602',1528378,'1726','237',191852.21,191918.69,66.48,9307.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','76602',1528379,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76602',1528380,'1728','237',129724.91,129725.07,0.16,22.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','76602',1528381,'1729','238',93758.25,94363.70,605.45,154389.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','76602',1528382,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76602',1528383,'1731','239',35970.61,36068.31,97.70,26867.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','76948',1535141,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76948',1535142,'1714','237',314909.09,315795.22,886.13,124058.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','76948',1535143,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','76948',1535144,'1716','237',286354.98,287478.64,1123.66,157312.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','76948',1535145,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76948',1535146,'1718','237',249866.59,253714.10,3847.51,538651.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','76948',1535147,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','76948',1535148,'1720','237',232816.18,236653.77,3837.59,537262.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','76948',1535149,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76948',1535150,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','76948',1535151,'1723','237',208506.68,211422.69,2916.01,408241.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','76948',1535152,'1724','237',70338.78,73783.10,3444.32,482204.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','76948',1535153,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76948',1535154,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76948',1535155,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','76948',1535156,'1728','237',129725.07,129725.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','76948',1535157,'1729','238',94363.70,94963.68,599.98,152994.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','76948',1535158,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','76948',1535159,'1731','239',36068.31,36125.31,57.00,15675.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78170',1559031,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78170',1559032,'1714','237',315795.22,317241.37,1446.15,202461.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78170',1559033,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78170',1559034,'1716','237',287478.64,288829.46,1350.82,189114.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78170',1559035,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78170',1559036,'1718','237',253714.10,255516.92,1802.82,252394.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78170',1559037,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78170',1559038,'1720','237',236653.77,238090.42,1436.65,201131.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78170',1559039,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78170',1559040,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78170',1559041,'1723','237',211422.69,211826.51,403.82,56534.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78170',1559042,'1724','237',73783.10,73783.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78170',1559043,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78170',1559044,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78170',1559045,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78170',1559046,'1728','237',129725.07,129725.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78170',1559047,'1729','238',94963.68,95134.41,170.73,43536.15,0.00,0.00,0.00,0.00,0.00),('5','97','618','78170',1559048,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78170',1559049,'1731','239',36125.31,36192.00,66.69,18339.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78185',1559295,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78185',1559296,'1714','237',317241.37,319312.17,2070.80,289912.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78185',1559297,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78185',1559298,'1716','237',288829.46,290546.10,1716.64,240329.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78185',1559299,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78185',1559300,'1718','237',255516.92,257532.77,2015.85,282219.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78185',1559301,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78185',1559302,'1720','237',238090.42,240121.78,2031.36,284390.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78185',1559303,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78185',1559304,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78185',1559305,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78185',1559306,'1724','237',73783.10,77073.02,3289.92,460588.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78185',1559307,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78185',1559308,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78185',1559309,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78185',1559310,'1728','237',129725.07,129725.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78185',1559311,'1729','238',95134.41,95747.20,612.79,156261.45,0.00,0.00,0.00,0.00,0.00),('5','97','618','78185',1559312,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78185',1559313,'1731','239',36192.00,36298.73,106.73,29350.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78187',1559357,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78187',1559358,'1714','237',319312.17,320845.02,1532.85,214599.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78187',1559359,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78187',1559360,'1716','237',290546.10,291887.94,1341.84,187857.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78187',1559361,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78187',1559362,'1718','237',257532.77,259189.42,1656.65,231931.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78187',1559363,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78187',1559364,'1720','237',240121.78,241524.25,1402.47,196345.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78187',1559365,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78187',1559366,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78187',1559367,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78187',1559368,'1724','237',77073.02,77073.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78187',1559369,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78187',1559370,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78187',1559371,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78187',1559372,'1728','237',129725.07,129725.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78187',1559373,'1729','238',95747.20,95766.64,19.44,4957.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','78187',1559374,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78187',1559375,'1731','239',36298.73,36324.36,25.63,7048.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78193',1559449,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78193',1559450,'1714','237',320845.02,322422.79,1577.77,220887.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','78193',1559451,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78193',1559452,'1716','237',291887.94,293061.92,1173.98,164357.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','78193',1559453,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78193',1559454,'1718','237',259189.42,261014.74,1825.32,255544.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78193',1559455,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78193',1559456,'1720','237',241524.25,243212.46,1688.21,236349.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78193',1559457,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78193',1559458,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78193',1559459,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78193',1559460,'1724','237',77073.02,77073.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78193',1559461,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78193',1559462,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78193',1559463,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78193',1559464,'1728','237',129725.07,129725.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78193',1559465,'1729','238',95766.64,96031.65,265.01,67577.55,0.00,0.00,0.00,0.00,0.00),('5','97','618','78193',1559466,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78193',1559467,'1731','239',36324.36,36366.77,42.41,11662.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78194',1559468,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78194',1559469,'1714','237',322422.79,323938.12,1515.33,212146.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','78194',1559470,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78194',1559471,'1716','237',293061.92,295897.83,2835.91,397027.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78194',1559472,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78194',1559473,'1718','237',261014.74,263036.69,2021.95,283073.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78194',1559474,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78194',1559475,'1720','237',243212.46,245533.39,2320.93,324930.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78194',1559476,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78194',1559477,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78194',1559478,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78194',1559479,'1724','237',77073.02,77073.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78194',1559480,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78194',1559481,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78194',1559482,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78194',1559483,'1728','237',129725.07,129725.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78194',1559484,'1729','238',96031.65,96081.44,49.79,12696.45,0.00,0.00,0.00,0.00,0.00),('5','97','618','78194',1559485,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78194',1559486,'1731','239',36366.77,36387.44,20.67,5684.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78195',1559487,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78195',1559488,'1714','237',323938.12,324711.52,773.40,108276.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78195',1559489,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78195',1559490,'1716','237',295897.83,297593.08,1695.25,237335.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78195',1559491,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78195',1559492,'1718','237',263036.69,265025.08,1988.39,278374.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78195',1559493,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78195',1559494,'1720','237',245533.39,247548.07,2014.68,282055.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78195',1559495,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78195',1559496,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78195',1559497,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78195',1559498,'1724','237',77073.02,77073.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78195',1559499,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78195',1559500,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78195',1559501,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78195',1559502,'1728','237',129725.07,129725.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78195',1559503,'1729','238',96081.44,96257.83,176.39,44979.45,0.00,0.00,0.00,0.00,0.00),('5','97','618','78195',1559504,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78195',1559505,'1731','239',36387.44,36414.58,27.14,7463.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78196',1559506,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78196',1559507,'1714','237',324711.52,326080.67,1369.15,191681.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78196',1559508,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78196',1559509,'1716','237',297593.08,299443.62,1850.54,259075.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78196',1559510,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78196',1559511,'1718','237',265025.08,266794.08,1769.00,247660.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78196',1559512,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78196',1559513,'1720','237',247548.07,248972.24,1424.17,199383.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78196',1559514,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78196',1559515,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78196',1559516,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78196',1559517,'1724','237',77073.02,83284.25,6211.23,869572.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78196',1559518,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78196',1559519,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78196',1559520,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78196',1559521,'1728','237',129725.07,129725.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78196',1559522,'1729','238',96257.83,96257.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78196',1559523,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78196',1559524,'1731','239',36414.58,36414.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78198',1559554,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78198',1559555,'1714','237',326080.67,327845.08,1764.41,247017.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78198',1559556,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78198',1559557,'1716','237',299443.62,301812.93,2369.31,331703.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78198',1559558,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78198',1559559,'1718','237',266794.08,266794.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78198',1559560,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78198',1559561,'1720','237',248972.24,248972.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78198',1559562,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78198',1559563,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78198',1559564,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78198',1559565,'1724','237',83284.25,84949.50,1665.25,233135.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78198',1559566,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78198',1559567,'1726','237',191918.69,191918.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78198',1559568,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78198',1559569,'1728','237',129725.07,131309.12,1584.05,221767.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78198',1559570,'1729','238',96257.83,96257.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78198',1559571,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78198',1559572,'1731','239',36414.58,36414.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78200',1559586,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78200',1559587,'1714','237',327845.08,329086.71,1241.63,173828.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','78200',1559588,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78200',1559589,'1716','237',301812.93,304396.94,2584.01,361761.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78200',1559590,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78200',1559591,'1718','237',266794.08,266794.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78200',1559592,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78200',1559593,'1720','237',248972.24,248972.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78200',1559594,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78200',1559595,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78200',1559596,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78200',1559597,'1724','237',84949.50,86505.39,1555.89,217824.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78200',1559598,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78200',1559599,'1726','237',191918.69,195732.66,3813.97,533955.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','78200',1559600,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78200',1559601,'1728','237',131309.12,133239.53,1930.41,270257.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78200',1559602,'1729','238',96257.83,96639.80,381.97,97402.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','78200',1559603,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78200',1559604,'1731','239',36414.58,36467.54,52.96,14564.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78202',1559617,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78202',1559618,'1714','237',329086.71,330959.57,1872.86,262200.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78202',1559619,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78202',1559620,'1716','237',304396.94,306922.48,2525.54,353575.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78202',1559621,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78202',1559622,'1718','237',266794.08,266794.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78202',1559623,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78202',1559624,'1720','237',248972.24,248972.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78202',1559625,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78202',1559626,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78202',1559627,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78202',1559628,'1724','237',86505.39,87977.76,1472.37,206131.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78202',1559629,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78202',1559630,'1726','237',195732.66,196958.12,1225.46,171564.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','78202',1559631,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78202',1559632,'1728','237',133239.53,135205.08,1965.55,275177.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78202',1559633,'1729','238',96639.80,97016.67,376.87,96101.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','78202',1559634,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78202',1559635,'1731','239',36467.54,36481.32,13.78,3789.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78206',1559687,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78206',1559688,'1714','237',330959.57,332516.63,1557.06,217988.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78206',1559689,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78206',1559690,'1716','237',306922.48,308837.92,1915.44,268161.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78206',1559691,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78206',1559692,'1718','237',266794.08,266794.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78206',1559693,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78206',1559694,'1720','237',248972.24,248972.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78206',1559695,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78206',1559696,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78206',1559697,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78206',1559698,'1724','237',87977.76,89606.32,1628.56,227998.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78206',1559699,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78206',1559700,'1726','237',196958.12,197654.36,696.24,97473.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78206',1559701,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78206',1559702,'1728','237',135205.08,136372.92,1167.84,163497.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78206',1559703,'1729','238',97016.67,97055.67,39.00,9945.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78206',1559704,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78206',1559705,'1731','239',36481.32,36519.77,38.45,10573.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78210',1559757,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78210',1559758,'1714','237',332516.63,333197.84,681.21,95369.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78210',1559759,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78210',1559760,'1716','237',308837.92,309479.42,641.50,89810.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78210',1559761,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78210',1559762,'1718','237',266794.08,268554.74,1760.66,246492.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78210',1559763,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78210',1559764,'1720','237',248972.24,250800.99,1828.75,256025.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78210',1559765,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78210',1559766,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78210',1559767,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78210',1559768,'1724','237',89606.32,91168.21,1561.89,218664.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78210',1559769,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78210',1559770,'1726','237',197654.36,198589.55,935.19,130926.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78210',1559771,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78210',1559772,'1728','237',136372.92,137966.73,1593.81,223133.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78210',1559773,'1729','238',97055.67,97202.21,146.54,37367.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','78210',1559774,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78210',1559775,'1731','239',36519.77,36537.00,17.23,4738.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78211',1559776,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78211',1559777,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78211',1559778,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78211',1559779,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78211',1559780,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78211',1559781,'1718','237',268554.74,270906.91,2352.17,329303.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78211',1559782,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78211',1559783,'1720','237',250800.99,252274.55,1473.56,206298.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78211',1559784,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78211',1559785,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78211',1559786,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78211',1559787,'1724','237',91168.21,92880.87,1712.66,239772.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78211',1559788,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78211',1559789,'1726','237',198589.55,199279.11,689.56,96538.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','78211',1559790,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78211',1559791,'1728','237',137966.73,139181.57,1214.84,170077.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78211',1559792,'1729','238',97202.21,97249.24,47.03,11992.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','78211',1559793,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78211',1559794,'1731','239',36537.00,36549.33,12.33,3390.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78214',1559823,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78214',1559824,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78214',1559825,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78214',1559826,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78214',1559827,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78214',1559828,'1718','237',270906.91,273377.86,2470.95,345933.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78214',1559829,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78214',1559830,'1720','237',252274.55,254258.32,1983.77,277727.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78214',1559831,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78214',1559832,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78214',1559833,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78214',1559834,'1724','237',92880.87,94586.72,1705.85,238819.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78214',1559835,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78214',1559836,'1726','237',199279.11,200380.25,1101.14,154159.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78214',1559837,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78214',1559838,'1728','237',139181.57,141245.93,2064.36,289010.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78214',1559839,'1729','238',97249.24,97602.75,353.51,90145.05,0.00,0.00,0.00,0.00,0.00),('5','97','618','78214',1559840,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78214',1559841,'1731','239',36549.33,36612.62,63.29,17404.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78215',1559842,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78215',1559843,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78215',1559844,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78215',1559845,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78215',1559846,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78215',1559847,'1718','237',273377.86,275873.38,2495.52,349372.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78215',1559848,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78215',1559849,'1720','237',254258.32,256335.83,2077.51,290851.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78215',1559850,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78215',1559851,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78215',1559852,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78215',1559853,'1724','237',94586.72,96252.46,1665.74,233203.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78215',1559854,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78215',1559855,'1726','237',200380.25,201696.90,1316.65,184331.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78215',1559856,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78215',1559857,'1728','237',141245.93,142576.97,1331.04,186345.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78215',1559858,'1729','238',97602.75,97743.53,140.78,35898.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','78215',1559859,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78215',1559860,'1731','239',36612.62,36679.41,66.79,18367.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78218',1559880,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78218',1559881,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78218',1559882,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78218',1559883,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78218',1559884,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78218',1559885,'1718','237',275873.38,278154.15,2280.77,319307.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78218',1559886,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78218',1559887,'1720','237',256335.83,258491.47,2155.64,301789.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78218',1559888,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78218',1559889,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78218',1559890,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78218',1559891,'1724','237',96252.46,98205.33,1952.87,273401.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78218',1559892,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78218',1559893,'1726','237',201696.90,203459.21,1762.31,246723.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','78218',1559894,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78218',1559895,'1728','237',142576.97,144227.96,1650.99,231138.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78218',1559896,'1729','238',97743.53,97900.18,156.65,39945.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','78218',1559897,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78218',1559898,'1731','239',36679.41,36730.03,50.62,13920.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78220',1559911,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78220',1559912,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78220',1559913,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78220',1559914,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78220',1559915,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78220',1559916,'1718','237',278154.15,280065.01,1910.86,267520.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78220',1559917,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78220',1559918,'1720','237',258491.47,259875.20,1383.73,193722.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78220',1559919,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78220',1559920,'1722','237',75646.67,75646.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78220',1559921,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78220',1559922,'1724','237',98205.33,99621.88,1416.55,198317.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78220',1559923,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78220',1559924,'1726','237',203459.21,205970.40,2511.19,351566.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78220',1559925,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78220',1559926,'1728','237',144227.96,145537.45,1309.49,183328.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78220',1559927,'1729','238',97900.18,98160.81,260.63,66460.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','78220',1559928,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78220',1559929,'1731','239',36730.03,36744.00,13.97,3841.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78221',1559930,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78221',1559931,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78221',1559932,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78221',1559933,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78221',1559934,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78221',1559935,'1718','237',280065.01,282767.36,2702.35,378329.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78221',1559936,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78221',1559937,'1720','237',259875.20,261490.80,1615.60,226184.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78221',1559938,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78221',1559939,'1722','237',75646.67,76374.40,727.73,101882.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78221',1559940,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78221',1559941,'1724','237',99621.88,100097.55,475.67,66593.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78221',1559942,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78221',1559943,'1726','237',205970.40,205970.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78221',1559944,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78221',1559945,'1728','237',145537.45,146808.70,1271.25,177975.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78221',1559946,'1729','238',98160.81,98370.24,209.43,53404.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','78221',1559947,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78221',1559948,'1731','239',36744.00,36783.97,39.97,10991.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78226',1560033,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78226',1560034,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78226',1560035,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78226',1560036,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78226',1560037,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78226',1560038,'1718','237',282767.36,284920.76,2153.40,301476.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78226',1560039,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78226',1560040,'1720','237',261490.80,263762.87,2272.07,318089.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78226',1560041,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78226',1560042,'1722','237',76374.40,78231.19,1856.79,259950.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78226',1560043,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78226',1560044,'1724','237',100097.55,100097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78226',1560045,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78226',1560046,'1726','237',205970.40,207383.17,1412.77,197787.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','78226',1560047,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78226',1560048,'1728','237',146808.70,148158.59,1349.89,188984.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78226',1560049,'1729','238',98370.24,98586.72,216.48,55202.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78226',1560050,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78226',1560051,'1731','239',36783.97,36799.15,15.18,4174.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78229',1560125,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78229',1560126,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78229',1560127,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78229',1560128,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78229',1560129,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78229',1560130,'1718','237',284920.76,287313.14,2392.38,334933.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','78229',1560131,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78229',1560132,'1720','237',263762.87,265760.87,1998.00,279720.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78229',1560133,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78229',1560134,'1722','237',78231.19,78978.59,747.40,104636.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78229',1560135,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78229',1560136,'1724','237',100097.55,100097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78229',1560137,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78229',1560138,'1726','237',207383.17,208799.87,1416.70,198338.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78229',1560139,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78229',1560140,'1728','237',148158.59,149356.03,1197.44,167641.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78229',1560141,'1729','238',98586.72,98730.92,144.20,36771.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78229',1560142,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78229',1560143,'1731','239',36799.15,36811.47,12.32,3388.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78230',1560144,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78230',1560145,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78230',1560146,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78230',1560147,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78230',1560148,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78230',1560149,'1718','237',287313.14,289905.18,2592.04,362885.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78230',1560150,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78230',1560151,'1720','237',265760.87,268259.89,2499.02,349862.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78230',1560152,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78230',1560153,'1722','237',78978.59,78978.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78230',1560154,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78230',1560155,'1724','237',100097.55,100097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78230',1560156,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78230',1560157,'1726','237',208799.87,210353.73,1553.86,217540.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','78230',1560158,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78230',1560159,'1728','237',149356.03,152195.04,2839.01,397461.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78230',1560160,'1729','238',98730.92,98792.07,61.15,15593.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','78230',1560161,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78230',1560162,'1731','239',36811.47,36824.88,13.41,3687.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78232',1560179,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78232',1560180,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78232',1560181,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78232',1560182,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78232',1560183,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78232',1560184,'1718','237',289905.18,290685.93,780.75,109305.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78232',1560185,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78232',1560186,'1720','237',268259.89,268877.07,617.18,86405.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78232',1560187,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78232',1560188,'1722','237',78978.59,78978.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78232',1560189,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78232',1560190,'1724','237',100097.55,100097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78232',1560191,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78232',1560192,'1726','237',210353.73,212381.57,2027.84,283897.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78232',1560193,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78232',1560194,'1728','237',152195.04,153917.73,1722.69,241176.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78232',1560195,'1729','238',98792.07,98839.31,47.24,12046.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','78232',1560196,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78232',1560197,'1731','239',36824.88,36837.10,12.22,3360.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78251',1560535,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78251',1560536,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78251',1560537,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78251',1560538,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78251',1560539,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78251',1560540,'1718','237',290685.93,293370.11,2684.18,375785.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','78251',1560541,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78251',1560542,'1720','237',268877.07,270859.26,1982.19,277506.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78251',1560543,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78251',1560544,'1722','237',78978.59,78978.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78251',1560545,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78251',1560546,'1724','237',100097.55,100097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78251',1560547,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78251',1560548,'1726','237',212381.57,214183.68,1802.11,252295.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','78251',1560549,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78251',1560550,'1728','237',153917.73,155372.27,1454.54,203635.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78251',1560551,'1729','238',98839.31,98923.71,84.40,21522.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78251',1560552,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78251',1560553,'1731','239',36837.10,36887.68,50.58,13909.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78255',1560616,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78255',1560617,'1714','237',333197.84,333197.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78255',1560618,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78255',1560619,'1716','237',309479.42,309479.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78255',1560620,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78255',1560621,'1718','237',293370.11,295972.57,2602.46,364344.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78255',1560622,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78255',1560623,'1720','237',270859.26,272781.33,1922.07,269089.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78255',1560624,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78255',1560625,'1722','237',78978.59,78978.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78255',1560626,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78255',1560627,'1724','237',100097.55,100097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78255',1560628,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78255',1560629,'1726','237',214183.68,215993.51,1809.83,253376.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','78255',1560630,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78255',1560631,'1728','237',155372.27,157337.04,1964.77,275067.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','78255',1560632,'1729','238',98923.71,99259.16,335.45,85539.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','78255',1560633,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78255',1560634,'1731','239',36887.68,36946.00,58.32,16038.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78258',1560681,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78258',1560682,'1714','237',333197.84,335687.73,2489.89,348584.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','78258',1560683,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78258',1560684,'1716','237',309479.42,312604.26,3124.84,437477.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78258',1560685,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78258',1560686,'1718','237',295972.57,297921.11,1948.54,272795.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78258',1560687,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78258',1560688,'1720','237',272781.33,274751.67,1970.34,275847.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78258',1560689,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78258',1560690,'1722','237',78978.59,78978.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78258',1560691,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78258',1560692,'1724','237',100097.55,100097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78258',1560693,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78258',1560694,'1726','237',215993.51,217086.48,1092.97,153015.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','78258',1560695,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78258',1560696,'1728','237',157337.04,158980.10,1643.06,230028.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78258',1560697,'1729','238',99259.16,99605.63,346.47,88349.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','78258',1560698,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78258',1560699,'1731','239',36946.00,36992.00,46.00,12650.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78260',1560712,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78260',1560713,'1714','237',335687.73,335687.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78260',1560714,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78260',1560715,'1716','237',312604.26,312604.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78260',1560716,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78260',1560717,'1718','237',297921.11,298881.38,960.27,134437.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78260',1560718,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78260',1560719,'1720','237',274751.67,276407.56,1655.89,231824.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78260',1560720,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78260',1560721,'1722','237',78978.59,78978.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78260',1560722,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78260',1560723,'1724','237',100097.55,100097.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78260',1560724,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78260',1560725,'1726','237',217086.48,217086.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78260',1560726,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78260',1560727,'1728','237',158980.10,160421.71,1441.61,201825.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78260',1560728,'1729','238',99605.63,100029.24,423.61,108020.55,0.00,0.00,0.00,0.00,0.00),('5','97','618','78260',1560729,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78260',1560730,'1731','239',36992.00,37056.81,64.81,17822.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78261',1560731,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78261',1560732,'1714','237',335687.73,336927.00,1239.27,173497.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','78261',1560733,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78261',1560734,'1716','237',312604.26,314820.06,2215.80,310212.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78261',1560735,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78261',1560736,'1718','237',298881.38,300751.46,1870.08,261811.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','78261',1560737,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78261',1560738,'1720','237',276407.56,277993.13,1585.57,221979.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78261',1560739,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78261',1560740,'1722','237',78978.59,79664.15,685.56,95978.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78261',1560741,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78261',1560742,'1724','237',100097.55,100925.09,827.54,115855.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78261',1560743,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78261',1560744,'1726','237',217086.48,217605.00,518.52,72592.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','78261',1560745,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78261',1560746,'1728','237',160421.71,160421.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78261',1560747,'1729','238',100029.24,100076.86,47.62,12143.10,0.00,0.00,0.00,0.00,0.00),('5','97','618','78261',1560748,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78261',1560749,'1731','239',37056.81,37089.74,32.93,9055.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78262',1560750,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78262',1560751,'1714','237',336927.00,337996.82,1069.82,149774.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','78262',1560752,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78262',1560753,'1716','237',314820.06,316577.99,1757.93,246110.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','78262',1560754,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78262',1560755,'1718','237',300751.46,302473.10,1721.64,241029.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78262',1560756,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78262',1560757,'1720','237',277993.13,277993.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78262',1560758,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78262',1560759,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78262',1560760,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78262',1560761,'1724','237',100925.09,101950.80,1025.71,143599.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78262',1560762,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78262',1560763,'1726','237',217605.00,218576.30,971.30,135982.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78262',1560764,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78262',1560765,'1728','237',160421.71,160421.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78262',1560766,'1729','238',100076.86,100679.80,602.94,153749.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','78262',1560767,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78262',1560768,'1731','239',37089.74,37193.70,103.96,28589.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78264',1560792,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78264',1560793,'1714','237',337996.82,338847.15,850.33,119046.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','78264',1560794,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78264',1560795,'1716','237',316577.99,320359.24,3781.25,529375.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78264',1560796,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78264',1560797,'1718','237',302473.10,303857.99,1384.89,193884.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78264',1560798,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78264',1560799,'1720','237',277993.13,279648.32,1655.19,231726.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78264',1560800,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78264',1560801,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78264',1560802,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78264',1560803,'1724','237',101950.80,101950.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78264',1560804,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78264',1560805,'1726','237',218576.30,219808.50,1232.20,172508.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78264',1560806,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78264',1560807,'1728','237',160421.71,162239.59,1817.88,254503.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','78264',1560808,'1729','238',100679.80,100742.42,62.62,15968.10,0.00,0.00,0.00,0.00,0.00),('5','97','618','78264',1560809,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78264',1560810,'1731','239',37193.70,37203.29,9.59,2637.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78267',1560889,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78267',1560890,'1714','237',338847.15,340600.03,1752.88,245403.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','78267',1560891,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78267',1560892,'1716','237',320359.24,320359.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78267',1560893,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78267',1560894,'1718','237',303857.99,305304.36,1446.37,202491.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78267',1560895,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78267',1560896,'1720','237',279648.32,281553.63,1905.31,266743.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78267',1560897,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78267',1560898,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78267',1560899,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78267',1560900,'1724','237',101950.80,101950.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78267',1560901,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78267',1560902,'1726','237',219808.50,220599.09,790.59,110682.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78267',1560903,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78267',1560904,'1728','237',162239.59,163747.29,1507.70,211078.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78267',1560905,'1729','238',100742.42,101057.71,315.29,80398.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','78267',1560906,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78267',1560907,'1731','239',37203.29,37221.04,17.75,4881.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78268',1560908,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78268',1560909,'1714','237',340600.03,342282.94,1682.91,235607.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78268',1560910,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78268',1560911,'1716','237',320359.24,321980.13,1620.89,226924.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78268',1560912,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78268',1560913,'1718','237',305304.36,307167.38,1863.02,260822.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78268',1560914,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78268',1560915,'1720','237',281553.63,283391.76,1838.13,257338.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78268',1560916,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78268',1560917,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78268',1560918,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78268',1560919,'1724','237',101950.80,103312.12,1361.32,190584.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78268',1560920,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78268',1560921,'1726','237',220599.09,221239.88,640.79,89710.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78268',1560922,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78268',1560923,'1728','237',163747.29,163747.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78268',1560924,'1729','238',101057.71,101153.00,95.29,24298.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','78268',1560925,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78268',1560926,'1731','239',37221.04,37230.60,9.56,2629.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78270',1560943,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78270',1560944,'1714','237',342282.94,343038.17,755.23,105732.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','78270',1560945,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78270',1560946,'1716','237',321980.13,323189.48,1209.35,169309.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78270',1560947,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78270',1560948,'1718','237',307167.38,308806.31,1638.93,229450.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','78270',1560949,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78270',1560950,'1720','237',283391.76,284583.89,1192.13,166898.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78270',1560951,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78270',1560952,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78270',1560953,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78270',1560954,'1724','237',103312.12,104637.06,1324.94,185491.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78270',1560955,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78270',1560956,'1726','237',221239.88,221744.61,504.73,70662.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','78270',1560957,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78270',1560958,'1728','237',163747.29,164493.88,746.59,104522.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78270',1560959,'1729','238',101153.00,101257.77,104.77,26716.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','78270',1560960,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78270',1560961,'1731','239',37230.60,37238.27,7.67,2109.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78274',1561042,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78274',1561043,'1714','237',343038.17,343038.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78274',1561044,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78274',1561045,'1716','237',323189.48,324856.32,1666.84,233357.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78274',1561046,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78274',1561047,'1718','237',308806.31,309220.25,413.94,57951.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78274',1561048,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78274',1561049,'1720','237',284583.89,285822.25,1238.36,173370.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78274',1561050,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78274',1561051,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78274',1561052,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78274',1561053,'1724','237',104637.06,105847.24,1210.18,169425.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78274',1561054,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78274',1561055,'1726','237',221744.61,222512.28,767.67,107473.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','78274',1561056,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78274',1561057,'1728','237',164493.88,164493.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78274',1561058,'1729','238',101257.77,101257.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78274',1561059,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78274',1561060,'1731','239',37238.27,37238.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78276',1561077,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78276',1561078,'1714','237',343038.17,344765.73,1727.56,241858.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78276',1561079,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78276',1561080,'1716','237',324856.32,326367.56,1511.24,211573.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78276',1561081,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78276',1561082,'1718','237',309220.25,310568.59,1348.34,188767.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78276',1561083,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78276',1561084,'1720','237',285822.25,287650.20,1827.95,255913.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78276',1561085,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78276',1561086,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78276',1561087,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78276',1561088,'1724','237',105847.24,106866.77,1019.53,142734.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78276',1561089,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78276',1561090,'1726','237',222512.28,223412.00,899.72,125960.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','78276',1561091,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78276',1561092,'1728','237',164493.88,165849.36,1355.48,189767.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','78276',1561093,'1729','238',101257.77,101280.39,22.62,5768.10,0.00,0.00,0.00,0.00,0.00),('5','97','618','78276',1561094,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78276',1561095,'1731','239',37238.27,37279.49,41.22,11335.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78341',1562435,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78341',1562436,'1714','237',344765.73,346220.89,1455.16,203722.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78341',1562437,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78341',1562438,'1716','237',326367.56,328676.24,2308.68,323215.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','78341',1562439,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78341',1562440,'1718','237',310568.59,311614.16,1045.57,146379.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78341',1562441,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78341',1562442,'1720','237',287650.20,287650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78341',1562443,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78341',1562444,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78341',1562445,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78341',1562446,'1724','237',106866.77,106866.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78341',1562447,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78341',1562448,'1726','237',223412.00,224533.41,1121.41,156997.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','78341',1562449,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78341',1562450,'1728','237',165849.36,167060.90,1211.54,169615.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78341',1562451,'1729','238',101280.39,101362.14,81.75,20846.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','78341',1562452,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78341',1562453,'1731','239',37279.49,37315.16,35.67,9809.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78342',1562454,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78342',1562455,'1714','237',346220.89,348157.98,1937.09,271192.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','78342',1562456,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78342',1562457,'1716','237',328676.24,331232.48,2556.24,357873.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78342',1562458,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78342',1562459,'1718','237',311614.16,311614.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78342',1562460,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78342',1562461,'1720','237',287650.20,287650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78342',1562462,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78342',1562463,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78342',1562464,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78342',1562465,'1724','237',106866.77,110050.53,3183.76,445726.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78342',1562466,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78342',1562467,'1726','237',224533.41,225624.25,1090.84,152717.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78342',1562468,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78342',1562469,'1728','237',167060.90,168530.20,1469.30,205702.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78342',1562470,'1729','238',101362.14,101442.26,80.12,20430.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78342',1562471,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78342',1562472,'1731','239',37315.16,37331.39,16.23,4463.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78485',1565171,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78485',1565172,'1714','237',348157.98,349583.72,1425.74,199603.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','78485',1565173,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78485',1565174,'1716','237',331232.48,332511.90,1279.42,179118.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78485',1565175,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78485',1565176,'1718','237',311614.16,311614.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78485',1565177,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78485',1565178,'1720','237',287650.20,287650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78485',1565179,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78485',1565180,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78485',1565181,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78485',1565182,'1724','237',110050.53,111320.94,1270.41,177857.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78485',1565183,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78485',1565184,'1726','237',225624.25,227578.45,1954.20,273588.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78485',1565185,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78485',1565186,'1728','237',168530.20,170199.71,1669.51,233731.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78485',1565187,'1729','238',101442.26,101524.76,82.50,21037.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','78485',1565188,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78485',1565189,'1731','239',37331.39,37355.46,24.07,6619.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78516',1565759,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78516',1565760,'1714','237',349583.72,349583.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78516',1565761,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78516',1565762,'1716','237',332511.90,332511.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78516',1565763,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78516',1565764,'1718','237',311614.16,311614.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78516',1565765,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78516',1565766,'1720','237',287650.20,287650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78516',1565767,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78516',1565768,'1722','237',79664.15,79664.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78516',1565769,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78516',1565770,'1724','237',111320.94,113679.04,2358.10,330134.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78516',1565771,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78516',1565772,'1726','237',227578.45,230439.77,2861.32,400584.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','78516',1565773,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78516',1565774,'1728','237',170199.71,172734.84,2535.13,354918.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','78516',1565775,'1729','238',101524.76,101615.47,90.71,23131.05,0.00,0.00,0.00,0.00,0.00),('5','97','618','78516',1565776,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78516',1565777,'1731','239',37355.46,37376.72,21.26,5846.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78593',1567260,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78593',1567261,'1714','237',349583.72,349583.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78593',1567262,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78593',1567263,'1716','237',332511.90,332511.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78593',1567264,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78593',1567265,'1718','237',311614.16,311614.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78593',1567266,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78593',1567267,'1720','237',287650.20,287650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78593',1567268,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78593',1567269,'1722','237',79664.15,83471.06,3806.91,532967.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78593',1567270,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78593',1567271,'1724','237',113679.04,113679.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78593',1567272,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78593',1567273,'1726','237',230439.77,231540.37,1100.60,154084.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78593',1567274,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78593',1567275,'1728','237',172734.84,174327.09,1592.25,222915.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78593',1567276,'1729','238',101615.47,102455.11,839.64,214108.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','78593',1567277,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78593',1567278,'1731','239',37376.72,37393.58,16.86,4636.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78616',1567676,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78616',1567677,'1714','237',349583.72,349583.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78616',1567678,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78616',1567679,'1716','237',332511.90,332511.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78616',1567680,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78616',1567681,'1718','237',311614.16,311614.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78616',1567682,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78616',1567683,'1720','237',287650.20,287650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78616',1567684,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78616',1567685,'1722','237',83471.06,84671.06,1200.00,168000.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78616',1567686,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78616',1567687,'1724','237',113679.04,126253.00,12573.96,1760354.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78616',1567688,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78616',1567689,'1726','237',231540.37,231540.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78616',1567690,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78616',1567691,'1728','237',174327.09,174327.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78616',1567692,'1729','238',102455.11,102519.33,64.22,16376.10,0.00,0.00,0.00,0.00,0.00),('5','97','618','78616',1567693,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78616',1567694,'1731','239',37393.58,37397.35,3.77,1036.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78622',1567779,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78622',1567780,'1714','237',349583.72,351355.14,1771.42,247998.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','78622',1567781,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78622',1567782,'1716','237',332511.90,334251.97,1740.07,243609.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78622',1567783,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78622',1567784,'1718','237',311614.16,311614.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78622',1567785,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78622',1567786,'1720','237',287650.20,287650.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78622',1567787,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78622',1567788,'1722','237',84671.06,85471.06,800.00,112000.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78622',1567789,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78622',1567790,'1724','237',126253.00,128203.88,1950.88,273123.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78622',1567791,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78622',1567792,'1726','237',231540.37,231540.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78622',1567793,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78622',1567794,'1728','237',174327.09,174327.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78622',1567795,'1729','238',102519.33,103064.01,544.68,138893.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','78622',1567796,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78622',1567797,'1731','239',37397.35,37443.09,45.74,12578.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78628',1567900,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78628',1567901,'1714','237',351355.14,352509.94,1154.80,161672.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78628',1567902,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78628',1567903,'1716','237',334251.97,335857.69,1605.72,224800.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78628',1567904,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78628',1567905,'1718','237',311614.16,313113.33,1499.17,209883.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78628',1567906,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78628',1567907,'1720','237',287650.20,289097.37,1447.17,202603.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','78628',1567908,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78628',1567909,'1722','237',85471.06,85765.01,293.95,41153.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78628',1567910,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78628',1567911,'1724','237',128203.88,128203.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78628',1567912,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78628',1567913,'1726','237',231540.37,231540.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78628',1567914,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78628',1567915,'1728','237',174327.09,174327.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78628',1567916,'1729','238',103064.01,103085.67,21.66,5523.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','78628',1567917,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78628',1567918,'1731','239',37443.09,37454.99,11.90,3272.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78633',1567959,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78633',1567960,'1714','237',352509.94,354742.24,2232.30,312522.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78633',1567961,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78633',1567962,'1716','237',335857.69,338237.68,2379.99,333198.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78633',1567963,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78633',1567964,'1718','237',313113.33,314175.89,1062.56,148758.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78633',1567965,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78633',1567966,'1720','237',289097.37,291724.80,2627.43,367840.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78633',1567967,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78633',1567968,'1722','237',85765.01,85865.01,100.00,14000.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78633',1567969,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78633',1567970,'1724','237',128203.88,128203.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78633',1567971,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78633',1567972,'1726','237',231540.37,233311.83,1771.46,248004.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','78633',1567973,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78633',1567974,'1728','237',174327.09,174327.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78633',1567975,'1729','238',103085.67,103317.42,231.75,59096.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','78633',1567976,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78633',1567977,'1731','239',37454.99,37502.83,47.84,13156.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78638',1568058,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78638',1568059,'1714','237',354742.24,356299.60,1557.36,218030.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78638',1568060,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78638',1568061,'1716','237',338237.68,340786.87,2549.19,356886.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78638',1568062,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78638',1568063,'1718','237',314175.89,315986.34,1810.45,253463.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78638',1568064,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78638',1568065,'1720','237',291724.80,291724.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78638',1568066,'1721','237',27132.29,27132.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78638',1568067,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78638',1568068,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78638',1568069,'1724','237',128203.88,128203.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78638',1568070,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78638',1568071,'1726','237',233311.83,233717.76,405.93,56830.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','78638',1568072,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78638',1568073,'1728','237',174327.09,174328.43,1.34,187.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','78638',1568074,'1729','238',103317.42,103582.00,264.58,67467.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','78638',1568075,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78638',1568076,'1731','239',37502.83,37550.83,48.00,13200.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78639',1568077,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78639',1568078,'1714','237',356299.60,356929.16,629.56,88138.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78639',1568079,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78639',1568080,'1716','237',340786.87,342209.36,1422.49,199148.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78639',1568081,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78639',1568082,'1718','237',315986.34,317850.48,1864.14,260979.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78639',1568083,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78639',1568084,'1720','237',291724.80,293666.81,1942.01,271881.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78639',1568085,'1721','237',27132.29,27414.99,282.70,39578.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78639',1568086,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78639',1568087,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78639',1568088,'1724','237',128203.88,128203.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78639',1568089,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78639',1568090,'1726','237',233717.76,233808.09,90.33,12646.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','78639',1568091,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78639',1568092,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78639',1568093,'1729','238',103582.00,103649.09,67.09,17107.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','78639',1568094,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78639',1568095,'1731','239',37550.83,37596.44,45.61,12542.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','78641',1568119,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78641',1568120,'1714','237',356929.16,359520.72,2591.56,362818.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78641',1568121,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78641',1568122,'1716','237',342209.36,344939.57,2730.21,382229.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78641',1568123,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78641',1568124,'1718','237',317850.48,320653.45,2802.97,392415.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78641',1568125,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78641',1568126,'1720','237',293666.81,295971.91,2305.10,322714.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78641',1568127,'1721','237',27414.99,27503.87,88.88,12443.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78641',1568128,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78641',1568129,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78641',1568130,'1724','237',128203.88,128203.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78641',1568131,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78641',1568132,'1726','237',233808.09,233808.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78641',1568133,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78641',1568134,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78641',1568135,'1729','238',103649.09,104152.34,503.25,128328.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','78641',1568136,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78641',1568137,'1731','239',37596.44,37624.26,27.82,7650.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78642',1568138,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78642',1568139,'1714','237',359520.72,360762.70,1241.98,173877.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','78642',1568140,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78642',1568141,'1716','237',344939.57,345831.61,892.04,124885.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78642',1568142,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78642',1568143,'1718','237',320653.45,322165.59,1512.14,211699.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78642',1568144,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78642',1568145,'1720','237',295971.91,297853.11,1881.20,263368.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78642',1568146,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78642',1568147,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78642',1568148,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78642',1568149,'1724','237',128203.88,128203.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78642',1568150,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78642',1568151,'1726','237',233808.09,233808.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78642',1568152,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78642',1568153,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78642',1568154,'1729','238',104152.34,104152.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78642',1568155,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78642',1568156,'1731','239',37624.26,37624.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78643',1568157,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78643',1568158,'1714','237',360762.70,362313.35,1550.65,217091.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78643',1568159,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78643',1568160,'1716','237',345831.61,348446.66,2615.05,366107.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78643',1568161,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78643',1568162,'1718','237',322165.59,325002.75,2837.16,397202.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','78643',1568163,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78643',1568164,'1720','237',297853.11,300557.16,2704.05,378567.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78643',1568165,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78643',1568166,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78643',1568167,'1723','237',211826.51,211826.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78643',1568168,'1724','237',128203.88,128203.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78643',1568169,'1725','237',58144.38,58144.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78643',1568170,'1726','237',233808.09,233808.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78643',1568171,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78643',1568172,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78643',1568173,'1729','238',104152.34,104597.12,444.78,113418.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','78643',1568174,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78643',1568175,'1731','239',37624.26,37731.20,106.94,29408.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','78644',1568176,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78644',1568177,'1714','237',362313.35,362313.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78644',1568178,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78644',1568179,'1716','237',348446.66,348446.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78644',1568180,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78644',1568181,'1718','237',325002.75,326625.92,1623.17,227243.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','78644',1568182,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78644',1568183,'1720','237',300557.16,301595.26,1038.10,145334.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78644',1568184,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78644',1568185,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78644',1568186,'1723','237',211826.51,212478.40,651.89,91264.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','78644',1568187,'1724','237',128203.88,130855.86,2651.98,371277.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','78644',1568188,'1725','237',58144.38,58155.17,10.79,1510.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','78644',1568189,'1726','237',233808.09,234946.17,1138.08,159331.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','78644',1568190,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78644',1568191,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78644',1568192,'1729','238',104597.12,104597.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78644',1568193,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78644',1568194,'1731','239',37731.20,37731.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78646',1568229,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78646',1568230,'1714','237',362313.35,365208.46,2895.11,405315.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','78646',1568231,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78646',1568232,'1716','237',348446.66,348446.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78646',1568233,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78646',1568234,'1718','237',326625.92,329218.46,2592.54,362955.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','78646',1568235,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78646',1568236,'1720','237',301595.26,303336.17,1740.91,243727.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78646',1568237,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78646',1568238,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78646',1568239,'1723','237',212478.40,214899.20,2420.80,338912.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78646',1568240,'1724','237',130855.86,132834.01,1978.15,276941.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78646',1568241,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78646',1568242,'1726','237',234946.17,234946.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78646',1568243,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78646',1568244,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78646',1568245,'1729','238',104597.12,104715.82,118.70,30268.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','78646',1568246,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78646',1568247,'1731','239',37731.20,37813.47,82.27,22624.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','78647',1568248,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78647',1568249,'1714','237',365208.46,365208.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78647',1568250,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','78647',1568251,'1716','237',348446.66,348446.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78647',1568252,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78647',1568253,'1718','237',329218.46,331009.94,1791.48,250807.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','78647',1568254,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','78647',1568255,'1720','237',303336.17,304254.13,917.96,128514.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78647',1568256,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78647',1568257,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78647',1568258,'1723','237',214899.20,214899.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','78647',1568259,'1724','237',132834.01,133862.22,1028.21,143949.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','78647',1568260,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78647',1568261,'1726','237',234946.17,234946.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78647',1568262,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','78647',1568263,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','78647',1568264,'1729','238',104715.82,104743.26,27.44,6997.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','78647',1568265,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','78647',1568266,'1731','239',37813.47,37849.55,36.08,9922.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79127',1577979,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79127',1577980,'1714','237',365208.46,367459.56,2251.10,315154.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79127',1577981,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79127',1577982,'1716','237',348446.66,350450.89,2004.23,280592.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','79127',1577983,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79127',1577984,'1718','237',331009.94,333200.40,2190.46,306664.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','79127',1577985,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79127',1577986,'1720','237',304254.13,305253.51,999.38,139913.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79127',1577987,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79127',1577988,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79127',1577989,'1723','237',214899.20,215830.88,931.68,130435.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79127',1577990,'1724','237',133862.22,135544.23,1682.01,235481.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','79127',1577991,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79127',1577992,'1726','237',234946.17,234946.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79127',1577993,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79127',1577994,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79127',1577995,'1729','238',104743.26,105657.03,913.77,233011.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','79127',1577996,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79127',1577997,'1731','239',37849.55,37861.42,11.87,3264.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','79138',1578174,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79138',1578175,'1714','237',367459.56,369316.13,1856.57,259919.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','79138',1578176,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79138',1578177,'1716','237',350450.89,354255.21,3804.32,532604.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','79138',1578178,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79138',1578179,'1718','237',333200.40,336820.96,3620.56,506878.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','79138',1578180,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79138',1578181,'1720','237',305253.51,306993.11,1739.60,243544.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79138',1578182,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79138',1578183,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79138',1578184,'1723','237',215830.88,217380.78,1549.90,216986.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79138',1578185,'1724','237',135544.23,138014.84,2470.61,345885.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','79138',1578186,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79138',1578187,'1726','237',234946.17,234946.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79138',1578188,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79138',1578189,'1728','237',174328.43,174328.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79138',1578190,'1729','238',105657.03,105861.50,204.47,52139.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','79138',1578191,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79138',1578192,'1731','239',37861.42,37896.14,34.72,9548.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79141',1578240,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79141',1578241,'1714','237',369316.13,370990.41,1674.28,234399.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','79141',1578242,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79141',1578243,'1716','237',354255.21,355525.33,1270.12,177816.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','79141',1578244,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79141',1578245,'1718','237',336820.96,339069.51,2248.55,314797.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79141',1578246,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79141',1578247,'1720','237',306993.11,309209.66,2216.55,310317.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79141',1578248,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79141',1578249,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79141',1578250,'1723','237',217380.78,218373.97,993.19,139046.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79141',1578251,'1724','237',138014.84,140252.27,2237.43,313240.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79141',1578252,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79141',1578253,'1726','237',234946.17,237289.59,2343.42,328078.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','79141',1578254,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79141',1578255,'1728','237',174328.43,176879.72,2551.29,357180.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','79141',1578256,'1729','238',105861.50,105975.01,113.51,28945.05,0.00,0.00,0.00,0.00,0.00),('5','97','618','79141',1578257,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79141',1578258,'1731','239',37896.14,37954.42,58.28,16027.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79149',1578440,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79149',1578441,'1714','237',370990.41,372283.00,1292.59,180962.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','79149',1578442,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79149',1578443,'1716','237',355525.33,356843.43,1318.10,184534.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79149',1578444,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79149',1578445,'1718','237',339069.51,342291.14,3221.63,451028.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','79149',1578446,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79149',1578447,'1720','237',309209.66,311553.85,2344.19,328186.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79149',1578448,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79149',1578449,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79149',1578450,'1723','237',218373.97,218373.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79149',1578451,'1724','237',140252.27,142306.85,2054.58,287641.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79149',1578452,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79149',1578453,'1726','237',237289.59,240592.35,3302.76,462386.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','79149',1578454,'1727','237',35069.92,35069.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79149',1578455,'1728','237',176879.72,176879.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79149',1578456,'1729','238',105975.01,106344.15,369.14,94130.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','79149',1578457,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79149',1578458,'1731','239',37954.42,37982.02,27.60,7590.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79152',1578520,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79152',1578521,'1714','237',372283.00,375948.44,3665.44,513161.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','79152',1578522,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79152',1578523,'1716','237',356843.43,360382.28,3538.85,495439.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79152',1578524,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79152',1578525,'1718','237',342291.14,346112.53,3821.39,534994.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','79152',1578526,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79152',1578527,'1720','237',311553.85,316496.62,4942.77,691987.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','79152',1578528,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79152',1578529,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79152',1578530,'1723','237',218373.97,218373.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79152',1578531,'1724','237',142306.85,142306.89,0.04,5.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79152',1578532,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79152',1578533,'1726','237',240592.35,241905.50,1313.15,183841.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79152',1578534,'1727','237',35069.92,35070.19,0.27,37.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','79152',1578535,'1728','237',176879.72,180804.36,3924.64,549449.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','79152',1578536,'1729','238',106344.15,106420.64,76.49,19504.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','79152',1578537,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79152',1578538,'1731','239',37982.02,38080.96,98.94,27208.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','79154',1578550,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79154',1578551,'1714','237',375948.44,379456.22,3507.78,491089.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','79154',1578552,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79154',1578553,'1716','237',360382.28,362099.76,1717.48,240447.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','79154',1578554,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79154',1578555,'1718','237',346112.53,348715.97,2603.44,364481.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','79154',1578556,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79154',1578557,'1720','237',316496.62,319665.46,3168.84,443637.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79154',1578558,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79154',1578559,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79154',1578560,'1723','237',218373.97,219261.96,887.99,124318.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79154',1578561,'1724','237',142306.89,144061.97,1755.08,245711.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79154',1578562,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79154',1578563,'1726','237',241905.50,243146.34,1240.84,173717.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','79154',1578564,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79154',1578565,'1728','237',180804.36,181678.47,874.11,122375.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','79154',1578566,'1729','238',106420.64,106824.96,404.32,103101.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','79154',1578567,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79154',1578568,'1731','239',38080.96,38140.82,59.86,16461.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','79783',1591021,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79783',1591022,'1714','237',379456.22,380969.58,1513.36,211870.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','79783',1591023,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79783',1591024,'1716','237',362099.76,364055.33,1955.57,273779.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','79783',1591025,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79783',1591026,'1718','237',348715.97,350441.33,1725.36,241550.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','79783',1591027,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79783',1591028,'1720','237',319665.46,320821.05,1155.59,161782.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79783',1591029,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79783',1591030,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79783',1591031,'1723','237',219261.96,219261.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79783',1591032,'1724','237',144061.97,145661.46,1599.49,223928.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79783',1591033,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79783',1591034,'1726','237',243146.34,243928.00,781.66,109432.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','79783',1591035,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79783',1591036,'1728','237',181678.47,182351.66,673.19,94246.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','79783',1591037,'1729','238',106824.96,107052.10,227.14,57920.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','79783',1591038,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79783',1591039,'1731','239',38140.82,38141.72,0.90,247.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','79785',1591054,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79785',1591055,'1714','237',380969.58,380969.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79785',1591056,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79785',1591057,'1716','237',364055.33,364055.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79785',1591058,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79785',1591059,'1718','237',350441.33,351864.19,1422.86,199200.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','79785',1591060,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79785',1591061,'1720','237',320821.05,321874.78,1053.73,147522.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79785',1591062,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79785',1591063,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79785',1591064,'1723','237',219261.96,219261.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79785',1591065,'1724','237',145661.46,147448.78,1787.32,250224.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','79785',1591066,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79785',1591067,'1726','237',243928.00,245185.78,1257.78,176089.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','79785',1591068,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79785',1591069,'1728','237',182351.66,182351.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79785',1591070,'1729','238',107052.10,107094.94,42.84,10924.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','79785',1591071,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79785',1591072,'1731','239',38141.72,38158.44,16.72,4598.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79942',1594203,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79942',1594204,'1714','237',380969.58,380969.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79942',1594205,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79942',1594206,'1716','237',364055.33,365538.93,1483.60,207704.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79942',1594207,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79942',1594208,'1718','237',351864.19,353803.36,1939.17,271483.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','79942',1594209,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79942',1594210,'1720','237',321874.78,324358.86,2484.08,347771.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79942',1594211,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79942',1594212,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79942',1594213,'1723','237',219261.96,219261.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79942',1594214,'1724','237',147448.78,148839.16,1390.38,194653.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79942',1594215,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79942',1594216,'1726','237',245185.78,246656.67,1470.89,205924.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','79942',1594217,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79942',1594218,'1728','237',182351.66,182351.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79942',1594219,'1729','238',107094.94,107142.58,47.64,12148.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','79942',1594220,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79942',1594221,'1731','239',38158.44,38170.60,12.16,3344.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79944',1594240,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79944',1594241,'1714','237',380969.58,381639.38,669.80,93772.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79944',1594242,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79944',1594243,'1716','237',365538.93,366572.28,1033.35,144669.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79944',1594244,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79944',1594245,'1718','237',353803.36,354775.75,972.39,136134.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','79944',1594246,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79944',1594247,'1720','237',324358.86,324358.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79944',1594248,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79944',1594249,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79944',1594250,'1723','237',219261.96,219261.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79944',1594251,'1724','237',148839.16,150151.08,1311.92,183668.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','79944',1594252,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79944',1594253,'1726','237',246656.67,247083.02,426.35,59689.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79944',1594254,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79944',1594255,'1728','237',182351.66,182549.41,197.75,27685.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79944',1594256,'1729','238',107142.58,107424.54,281.96,71899.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','79944',1594257,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79944',1594258,'1731','239',38170.60,38179.85,9.25,2543.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','79966',1594681,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79966',1594682,'1714','237',381639.38,383230.77,1591.39,222794.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','79966',1594683,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79966',1594684,'1716','237',366572.28,368460.03,1887.75,264285.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79966',1594685,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79966',1594686,'1718','237',354775.75,356789.32,2013.57,281899.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','79966',1594687,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79966',1594688,'1720','237',324358.86,326381.77,2022.91,283207.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','79966',1594689,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79966',1594690,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79966',1594691,'1723','237',219261.96,219261.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79966',1594692,'1724','237',150151.08,150151.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79966',1594693,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79966',1594694,'1726','237',247083.02,248095.79,1012.77,141787.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','79966',1594695,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79966',1594696,'1728','237',182549.41,183973.01,1423.60,199304.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79966',1594697,'1729','238',107424.54,107469.54,45.00,11475.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79966',1594698,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79966',1594699,'1731','239',38179.85,38201.46,21.61,5942.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','79969',1594743,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79969',1594744,'1714','237',383230.77,384433.01,1202.24,168313.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','79969',1594745,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79969',1594746,'1716','237',368460.03,370125.31,1665.28,233139.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','79969',1594747,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79969',1594748,'1718','237',356789.32,356789.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79969',1594749,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79969',1594750,'1720','237',326381.77,326381.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79969',1594751,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79969',1594752,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79969',1594753,'1723','237',219261.96,219261.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79969',1594754,'1724','237',150151.08,151379.34,1228.26,171956.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','79969',1594755,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79969',1594756,'1726','237',248095.79,249070.52,974.73,136462.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','79969',1594757,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79969',1594758,'1728','237',183973.01,183973.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','79969',1594759,'1729','238',107469.54,107591.73,122.19,31158.45,0.00,0.00,0.00,0.00,0.00),('5','97','618','79969',1594760,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79969',1594761,'1731','239',38201.46,38217.67,16.21,4457.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','79972',1594793,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79972',1594794,'1714','237',384433.01,387981.92,3548.91,496847.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','79972',1594795,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79972',1594796,'1716','237',370125.31,373440.21,3314.90,464086.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79972',1594797,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79972',1594798,'1718','237',356789.32,358494.48,1705.16,238722.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','79972',1594799,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79972',1594800,'1720','237',326381.77,328324.30,1942.53,271954.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79972',1594801,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79972',1594802,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79972',1594803,'1723','237',219261.96,220158.81,896.85,125559.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79972',1594804,'1724','237',151379.34,154600.61,3221.27,450977.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','79972',1594805,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79972',1594806,'1726','237',249070.52,251072.26,2001.74,280243.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','79972',1594807,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79972',1594808,'1728','237',183973.01,184579.49,606.48,84907.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','79972',1594809,'1729','238',107591.73,107774.08,182.35,46499.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','79972',1594810,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79972',1594811,'1731','239',38217.67,38325.89,108.22,29760.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','79973',1594812,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79973',1594813,'1714','237',387981.92,390131.42,2149.50,300930.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79973',1594814,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79973',1594815,'1716','237',373440.21,375949.19,2508.98,351257.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','79973',1594816,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79973',1594817,'1718','237',358494.48,361096.58,2602.10,364294.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79973',1594818,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79973',1594819,'1720','237',328324.30,331770.05,3445.75,482405.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79973',1594820,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79973',1594821,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79973',1594822,'1723','237',220158.81,222095.78,1936.97,271175.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','79973',1594823,'1724','237',154600.61,156272.06,1671.45,234003.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79973',1594824,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79973',1594825,'1726','237',251072.26,252150.15,1077.89,150904.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','79973',1594826,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79973',1594827,'1728','237',184579.49,186333.03,1753.54,245495.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','79973',1594828,'1729','238',107774.08,108041.51,267.43,68194.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','79973',1594829,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79973',1594830,'1731','239',38325.89,38409.33,83.44,22946.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79975',1594848,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79975',1594849,'1714','237',390131.42,391309.90,1178.48,164987.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','79975',1594850,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79975',1594851,'1716','237',375949.19,375949.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79975',1594852,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79975',1594853,'1718','237',361096.58,362313.22,1216.64,170329.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','79975',1594854,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79975',1594855,'1720','237',331770.05,333310.92,1540.87,215721.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','79975',1594856,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79975',1594857,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79975',1594858,'1723','237',222095.78,222095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79975',1594859,'1724','237',156272.06,156272.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79975',1594860,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79975',1594861,'1726','237',252150.15,252150.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79975',1594862,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79975',1594863,'1728','237',186333.03,186608.20,275.17,38523.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','79975',1594864,'1729','238',108041.51,108074.34,32.83,8371.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','79975',1594865,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79975',1594866,'1731','239',38409.33,38430.74,21.41,5887.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','79978',1594938,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79978',1594939,'1714','237',391309.90,391309.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79978',1594940,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79978',1594941,'1716','237',375949.19,377836.37,1887.18,264205.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','79978',1594942,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79978',1594943,'1718','237',362313.22,362313.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79978',1594944,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79978',1594945,'1720','237',333310.92,335245.56,1934.64,270849.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79978',1594946,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79978',1594947,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79978',1594948,'1723','237',222095.78,222095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79978',1594949,'1724','237',156272.06,156272.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79978',1594950,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79978',1594951,'1726','237',252150.15,252847.18,697.03,97584.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','79978',1594952,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79978',1594953,'1728','237',186608.20,187559.86,951.66,133232.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','79978',1594954,'1729','238',108074.34,108450.42,376.08,95900.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','79978',1594955,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79978',1594956,'1731','239',38430.74,38461.49,30.75,8456.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','79982',1595015,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79982',1595016,'1714','237',391309.90,391965.53,655.63,91788.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','79982',1595017,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','79982',1595018,'1716','237',377836.37,378592.15,755.78,105809.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','79982',1595019,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79982',1595020,'1718','237',362313.22,363508.73,1195.51,167371.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','79982',1595021,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','79982',1595022,'1720','237',335245.56,336086.09,840.53,117674.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','79982',1595023,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79982',1595024,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79982',1595025,'1723','237',222095.78,222095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','79982',1595026,'1724','237',156272.06,156914.20,642.14,89899.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','79982',1595027,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79982',1595028,'1726','237',252847.18,253285.48,438.30,61362.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79982',1595029,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','79982',1595030,'1728','237',187559.86,187993.70,433.84,60737.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','79982',1595031,'1729','238',108450.42,108533.40,82.98,21159.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','79982',1595032,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','79982',1595033,'1731','239',38461.49,38494.62,33.13,9110.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','80257',1600176,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80257',1600177,'1714','237',391965.53,393204.79,1239.26,173496.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','80257',1600178,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80257',1600179,'1716','237',378592.15,379719.82,1127.67,157873.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','80257',1600180,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80257',1600181,'1718','237',363508.73,364433.63,924.90,129486.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80257',1600182,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80257',1600183,'1720','237',336086.09,337382.39,1296.30,181482.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80257',1600184,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80257',1600185,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80257',1600186,'1723','237',222095.78,222095.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80257',1600187,'1724','237',156914.20,157832.77,918.57,128599.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','80257',1600188,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80257',1600189,'1726','237',253285.48,254678.40,1392.92,195008.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','80257',1600190,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80257',1600191,'1728','237',187993.70,188698.64,704.94,98691.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','80257',1600192,'1729','238',108533.40,108586.72,53.32,13596.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','80257',1600193,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80257',1600194,'1731','239',38494.62,38499.32,4.70,1292.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','80260',1600242,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80260',1600243,'1714','237',393204.79,394021.99,817.20,114408.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80260',1600244,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80260',1600245,'1716','237',379719.82,380526.55,806.73,112942.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','80260',1600246,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80260',1600247,'1718','237',364433.63,365860.98,1427.35,199829.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80260',1600248,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80260',1600249,'1720','237',337382.39,338684.96,1302.57,182359.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','80260',1600250,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80260',1600251,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80260',1600252,'1723','237',222095.78,222848.73,752.95,105413.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80260',1600253,'1724','237',157832.77,157832.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80260',1600254,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80260',1600255,'1726','237',254678.40,254678.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80260',1600256,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80260',1600257,'1728','237',188698.64,188698.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80260',1600258,'1729','238',108586.72,108707.49,120.77,30796.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','80260',1600259,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80260',1600260,'1731','239',38499.32,38512.92,13.60,3740.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80261',1600261,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80261',1600262,'1714','237',394021.99,395355.56,1333.57,186699.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','80261',1600263,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80261',1600264,'1716','237',380526.55,381643.30,1116.75,156345.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80261',1600265,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80261',1600266,'1718','237',365860.98,367424.70,1563.72,218920.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','80261',1600267,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80261',1600268,'1720','237',338684.96,340193.82,1508.86,211240.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','80261',1600269,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80261',1600270,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80261',1600271,'1723','237',222848.73,222848.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80261',1600272,'1724','237',157832.77,157832.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80261',1600273,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80261',1600274,'1726','237',254678.40,255571.82,893.42,125078.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','80261',1600275,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80261',1600276,'1728','237',188698.64,189662.92,964.28,134999.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','80261',1600277,'1729','238',108707.49,108707.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80261',1600278,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80261',1600279,'1731','239',38512.92,38512.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80263',1600294,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80263',1600295,'1714','237',395355.56,396097.89,742.33,103926.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','80263',1600296,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80263',1600297,'1716','237',381643.30,382269.88,626.58,87721.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','80263',1600298,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80263',1600299,'1718','237',367424.70,368180.53,755.83,105816.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','80263',1600300,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80263',1600301,'1720','237',340193.82,341297.00,1103.18,154445.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','80263',1600302,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80263',1600303,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80263',1600304,'1723','237',222848.73,223356.10,507.37,71031.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','80263',1600305,'1724','237',157832.77,157832.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80263',1600306,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80263',1600307,'1726','237',255571.82,255571.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80263',1600308,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80263',1600309,'1728','237',189662.92,189662.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80263',1600310,'1729','238',108707.49,108815.47,107.98,27534.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','80263',1600311,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80263',1600312,'1731','239',38512.92,38544.62,31.70,8717.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','80534',1605469,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80534',1605470,'1714','237',396097.89,397867.01,1769.12,247676.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','80534',1605471,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80534',1605472,'1716','237',382269.88,383236.49,966.61,135325.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','80534',1605473,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80534',1605474,'1718','237',368180.53,369716.06,1535.53,214974.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','80534',1605475,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80534',1605476,'1720','237',341297.00,342605.19,1308.19,183146.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','80534',1605477,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80534',1605478,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80534',1605479,'1723','237',223356.10,223356.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80534',1605480,'1724','237',157832.77,159308.47,1475.70,206598.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80534',1605481,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80534',1605482,'1726','237',255571.82,256313.43,741.61,103825.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','80534',1605483,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80534',1605484,'1728','237',189662.92,189662.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80534',1605485,'1729','238',108815.47,108848.21,32.74,8348.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','80534',1605486,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80534',1605487,'1731','239',38544.62,38559.05,14.43,3968.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','80536',1605542,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80536',1605543,'1714','237',397867.01,398992.31,1125.30,157542.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80536',1605544,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80536',1605545,'1716','237',383236.49,384599.53,1363.04,190825.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','80536',1605546,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80536',1605547,'1718','237',369716.06,369716.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80536',1605548,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80536',1605549,'1720','237',342605.19,344182.63,1577.44,220841.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','80536',1605550,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80536',1605551,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80536',1605552,'1723','237',223356.10,224641.41,1285.31,179943.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','80536',1605553,'1724','237',159308.47,159623.84,315.37,44151.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','80536',1605554,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80536',1605555,'1726','237',256313.43,256845.27,531.84,74457.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','80536',1605556,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80536',1605557,'1728','237',189662.92,189662.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80536',1605558,'1729','238',108848.21,108992.31,144.10,36745.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','80536',1605559,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80536',1605560,'1731','239',38559.05,38578.54,19.49,5359.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','80537',1605561,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80537',1605562,'1714','237',398992.31,401091.75,2099.44,293921.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','80537',1605563,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80537',1605564,'1716','237',384599.53,384599.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80537',1605565,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80537',1605566,'1718','237',369716.06,371586.49,1870.43,261860.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','80537',1605567,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80537',1605568,'1720','237',344182.63,346352.94,2170.31,303843.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','80537',1605569,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80537',1605570,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80537',1605571,'1723','237',224641.41,225903.60,1262.19,176706.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','80537',1605572,'1724','237',159623.84,160346.30,722.46,101144.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','80537',1605573,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80537',1605574,'1726','237',256845.27,258070.14,1224.87,171481.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','80537',1605575,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80537',1605576,'1728','237',189662.92,189662.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80537',1605577,'1729','238',108992.31,109001.85,9.54,2432.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','80537',1605578,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80537',1605579,'1731','239',38578.54,38617.20,38.66,10631.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','80539',1605597,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80539',1605598,'1714','237',401091.75,402476.45,1384.70,193858.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80539',1605599,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80539',1605600,'1716','237',384599.53,386179.45,1579.92,221188.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','80539',1605601,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80539',1605602,'1718','237',371586.49,372071.93,485.44,67961.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','80539',1605603,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80539',1605604,'1720','237',346352.94,347940.56,1587.62,222266.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','80539',1605605,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80539',1605606,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80539',1605607,'1723','237',225903.60,225903.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80539',1605608,'1724','237',160346.30,160346.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80539',1605609,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80539',1605610,'1726','237',258070.14,258866.57,796.43,111500.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','80539',1605611,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80539',1605612,'1728','237',189662.92,191070.67,1407.75,197085.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80539',1605613,'1729','238',109001.85,109389.13,387.28,98756.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','80539',1605614,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80539',1605615,'1731','239',38617.20,38638.89,21.69,5964.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','80665',1608053,'1713','237',92120.01,92120.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80665',1608054,'1714','237',402476.45,403342.37,865.92,121228.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','80665',1608055,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80665',1608056,'1716','237',386179.45,388344.74,2165.29,303140.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','80665',1608057,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80665',1608058,'1718','237',372071.93,373492.03,1420.10,198814.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80665',1608059,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80665',1608060,'1720','237',347940.56,347940.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80665',1608061,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80665',1608062,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80665',1608063,'1723','237',225903.60,225903.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80665',1608064,'1724','237',160346.30,163485.93,3139.63,439548.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','80665',1608065,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80665',1608066,'1726','237',258866.57,258968.82,102.25,14315.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80665',1608067,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80665',1608068,'1728','237',191070.67,191070.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80665',1608069,'1729','238',109389.13,109389.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80665',1608070,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80665',1608071,'1731','239',38638.89,38638.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80676',1608267,'1713','237',92120.01,94687.99,2567.98,359517.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','80676',1608268,'1714','237',403342.37,403342.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80676',1608269,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80676',1608270,'1716','237',388344.74,389680.59,1335.85,187019.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80676',1608271,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80676',1608272,'1718','237',373492.03,373492.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80676',1608273,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80676',1608274,'1720','237',347940.56,347940.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80676',1608275,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80676',1608276,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80676',1608277,'1723','237',225903.60,225903.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80676',1608278,'1724','237',163485.93,163485.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80676',1608279,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80676',1608280,'1726','237',258968.82,262513.54,3544.72,496260.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','80676',1608281,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80676',1608282,'1728','237',191070.67,191070.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80676',1608283,'1729','238',109389.13,109564.63,175.50,44752.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','80676',1608284,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80676',1608285,'1731','239',38638.89,38647.65,8.76,2409.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80742',1609556,'1713','237',94687.99,97133.11,2445.12,342316.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','80742',1609557,'1714','237',403342.37,403380.31,37.94,5311.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','80742',1609558,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80742',1609559,'1716','237',389680.59,391110.92,1430.33,200246.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','80742',1609560,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80742',1609561,'1718','237',373492.03,373492.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80742',1609562,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80742',1609563,'1720','237',347940.56,350092.09,2151.53,301214.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','80742',1609564,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80742',1609565,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80742',1609566,'1723','237',225903.60,225903.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80742',1609567,'1724','237',163485.93,163485.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80742',1609568,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80742',1609569,'1726','237',262513.54,264235.91,1722.37,241131.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','80742',1609570,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80742',1609571,'1728','237',191070.67,191070.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80742',1609572,'1729','238',109564.63,109612.50,47.87,12206.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','80742',1609573,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80742',1609574,'1731','239',38647.65,38651.78,4.13,1135.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','80950',1613632,'1713','237',97133.11,97133.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80950',1613633,'1714','237',403380.31,404640.21,1259.90,176386.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80950',1613634,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80950',1613635,'1716','237',391110.92,392182.47,1071.55,150017.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80950',1613636,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80950',1613637,'1718','237',373492.03,376541.70,3049.67,426953.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','80950',1613638,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80950',1613639,'1720','237',350092.09,351192.68,1100.59,154082.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','80950',1613640,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80950',1613641,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80950',1613642,'1723','237',225903.60,225910.74,7.14,999.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','80950',1613643,'1724','237',163485.93,163485.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80950',1613644,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80950',1613645,'1726','237',264235.91,264933.66,697.75,97685.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80950',1613646,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80950',1613647,'1728','237',191070.67,191070.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80950',1613648,'1729','238',109612.50,109700.83,88.33,22524.15,0.00,0.00,0.00,0.00,0.00),('5','97','618','80950',1613649,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80950',1613650,'1731','239',38651.78,38652.14,0.36,99.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80951',1613651,'1713','237',97133.11,97955.24,822.13,115098.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','80951',1613652,'1714','237',404640.21,404640.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80951',1613653,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80951',1613654,'1716','237',392182.47,393613.68,1431.21,200369.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','80951',1613655,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80951',1613656,'1718','237',376541.70,376541.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80951',1613657,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80951',1613658,'1720','237',351192.68,351916.32,723.64,101309.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','80951',1613659,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80951',1613660,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80951',1613661,'1723','237',225910.74,225910.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80951',1613662,'1724','237',163485.93,163485.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80951',1613663,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80951',1613664,'1726','237',264933.66,264933.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80951',1613665,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80951',1613666,'1728','237',191070.67,192328.78,1258.11,176135.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','80951',1613667,'1729','238',109700.83,109719.77,18.94,4829.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','80951',1613668,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80951',1613669,'1731','239',38652.14,38705.38,53.24,14641.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80952',1613670,'1713','237',97955.24,97955.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80952',1613671,'1714','237',404640.21,405301.39,661.18,92565.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','80952',1613672,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80952',1613673,'1716','237',393613.68,394147.12,533.44,74681.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','80952',1613674,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80952',1613675,'1718','237',376541.70,377705.34,1163.64,162909.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','80952',1613676,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80952',1613677,'1720','237',351916.32,352831.77,915.45,128163.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80952',1613678,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80952',1613679,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80952',1613680,'1723','237',225910.74,227419.96,1509.22,211290.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','80952',1613681,'1724','237',163485.93,165366.13,1880.20,263228.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80952',1613682,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80952',1613683,'1726','237',264933.66,265570.98,637.32,89224.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','80952',1613684,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80952',1613685,'1728','237',192328.78,192328.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','80952',1613686,'1729','238',109719.77,109792.45,72.68,18533.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','80952',1613687,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80952',1613688,'1731','239',38705.38,38730.81,25.43,6993.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','80957',1613763,'1713','237',97955.24,97955.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80957',1613764,'1714','237',405301.39,405301.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80957',1613765,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','80957',1613766,'1716','237',394147.12,394147.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80957',1613767,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80957',1613768,'1718','237',377705.34,379476.48,1771.14,247959.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','80957',1613769,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','80957',1613770,'1720','237',352831.77,353970.30,1138.53,159394.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','80957',1613771,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80957',1613772,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80957',1613773,'1723','237',227419.96,227419.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80957',1613774,'1724','237',165366.13,165832.18,466.05,65247.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','80957',1613775,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80957',1613776,'1726','237',265570.98,265789.02,218.04,30525.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','80957',1613777,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','80957',1613778,'1728','237',192328.78,192850.92,522.14,73099.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','80957',1613779,'1729','238',109792.45,109806.92,14.47,3689.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','80957',1613780,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','80957',1613781,'1731','239',38730.81,38746.06,15.25,4193.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','81899',1632076,'1713','237',97955.24,97955.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81899',1632077,'1714','237',405301.39,406535.57,1234.18,172785.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','81899',1632078,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81899',1632079,'1716','237',394147.12,396161.82,2014.70,282058.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81899',1632080,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81899',1632081,'1718','237',379476.48,382213.72,2737.24,383213.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','81899',1632082,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81899',1632083,'1720','237',353970.30,357322.67,3352.37,469331.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','81899',1632084,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81899',1632085,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81899',1632086,'1723','237',227419.96,228977.57,1557.61,218065.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','81899',1632087,'1724','237',165832.18,165832.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81899',1632088,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81899',1632089,'1726','237',265789.02,266885.07,1096.05,153447.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81899',1632090,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81899',1632091,'1728','237',192850.92,192850.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','81899',1632092,'1729','238',109806.92,109970.01,163.09,41587.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','81899',1632093,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81899',1632094,'1731','239',38746.06,38762.96,16.90,4647.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','81905',1632218,'1713','237',97955.24,97955.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81905',1632219,'1714','237',406535.57,407656.06,1120.49,156868.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','81905',1632220,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81905',1632221,'1716','237',396161.82,396631.85,470.03,65804.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','81905',1632222,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81905',1632223,'1718','237',382213.72,383503.88,1290.16,180622.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','81905',1632224,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81905',1632225,'1720','237',357322.67,359217.51,1894.84,265277.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','81905',1632226,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81905',1632227,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81905',1632228,'1723','237',228977.57,229842.37,864.80,121072.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81905',1632229,'1724','237',165832.18,165832.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81905',1632230,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81905',1632231,'1726','237',266885.07,267760.77,875.70,122598.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81905',1632232,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81905',1632233,'1728','237',192850.92,192850.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','81905',1632234,'1729','238',109970.01,110010.62,40.61,10355.55,0.00,0.00,0.00,0.00,0.00),('5','97','618','81905',1632235,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81905',1632236,'1731','239',38762.96,38774.22,11.26,3096.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','81907',1632243,'1713','237',97955.24,99853.44,1898.20,265748.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81907',1632244,'1714','237',407656.06,407656.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81907',1632245,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81907',1632246,'1716','237',396631.85,397885.06,1253.21,175449.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','81907',1632247,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81907',1632248,'1718','237',383503.88,384941.30,1437.42,201238.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','81907',1632249,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81907',1632250,'1720','237',359217.51,360058.84,841.33,117786.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','81907',1632251,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81907',1632252,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81907',1632253,'1723','237',229842.37,229842.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81907',1632254,'1724','237',165832.18,165832.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81907',1632255,'1725','237',58155.17,58155.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81907',1632256,'1726','237',267760.77,269068.80,1308.03,183124.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','81907',1632257,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81907',1632258,'1728','237',192850.92,193953.23,1102.31,154323.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','81907',1632259,'1729','238',110010.62,110208.51,197.89,50461.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','81907',1632260,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81907',1632261,'1731','239',38774.22,38802.25,28.03,7708.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','81910',1632295,'1713','237',99853.44,99853.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81910',1632296,'1714','237',407656.06,409885.54,2229.48,312127.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','81910',1632297,'1715','237',160973.39,160973.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81910',1632298,'1716','237',397885.06,399857.52,1972.46,276144.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','81910',1632299,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81910',1632300,'1718','237',384941.30,387512.72,2571.42,359998.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','81910',1632301,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81910',1632302,'1720','237',360058.84,362905.54,2846.70,398538.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81910',1632303,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81910',1632304,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81910',1632305,'1723','237',229842.37,231278.30,1435.93,201030.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','81910',1632306,'1724','237',165832.18,165832.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81910',1632307,'1725','237',58155.17,58566.52,411.35,57589.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81910',1632308,'1726','237',269068.80,269522.84,454.04,63565.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','81910',1632309,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81910',1632310,'1728','237',193953.23,193953.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','81910',1632311,'1729','238',110208.51,110630.01,421.50,107482.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','81910',1632312,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81910',1632313,'1731','239',38802.25,38937.48,135.23,37188.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','81914',1632366,'1713','237',99853.44,101126.40,1272.96,178214.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','81914',1632367,'1714','237',409885.54,411431.12,1545.58,216381.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','81914',1632368,'1715','237',160973.39,162525.44,1552.05,217287.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81914',1632369,'1716','237',399857.52,400585.73,728.21,101949.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','81914',1632370,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81914',1632371,'1718','237',387512.72,390294.98,2782.26,389516.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','81914',1632372,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81914',1632373,'1720','237',362905.54,365404.83,2499.29,349900.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','81914',1632374,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81914',1632375,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81914',1632376,'1723','237',231278.30,232879.32,1601.02,224142.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','81914',1632377,'1724','237',165832.18,166023.73,191.55,26817.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81914',1632378,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81914',1632379,'1726','237',269522.84,270297.63,774.79,108470.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','81914',1632380,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81914',1632381,'1728','237',193953.23,193953.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','81914',1632382,'1729','238',110630.01,110797.36,167.35,42674.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','81914',1632383,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81914',1632384,'1731','239',38937.48,39022.86,85.38,23479.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','81915',1632385,'1713','237',101126.40,101126.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81915',1632386,'1714','237',411431.12,414671.21,3240.09,453612.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','81915',1632387,'1715','237',162525.44,164098.22,1572.78,220189.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','81915',1632388,'1716','237',400585.73,402215.43,1629.70,228158.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81915',1632389,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81915',1632390,'1718','237',390294.98,393920.78,3625.80,507612.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81915',1632391,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81915',1632392,'1720','237',365404.83,367583.41,2178.58,305001.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','81915',1632393,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81915',1632394,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81915',1632395,'1723','237',232879.32,234586.02,1706.70,238938.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81915',1632396,'1724','237',166023.73,166023.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81915',1632397,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81915',1632398,'1726','237',270297.63,270297.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81915',1632399,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81915',1632400,'1728','237',193953.23,193953.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','81915',1632401,'1729','238',110797.36,110836.55,39.19,9993.45,0.00,0.00,0.00,0.00,0.00),('5','97','618','81915',1632402,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81915',1632403,'1731','239',39022.86,39060.18,37.32,10263.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81919',1632441,'1713','237',101126.40,101126.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81919',1632442,'1714','237',414671.21,417271.06,2599.85,363979.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81919',1632443,'1715','237',164098.22,166129.43,2031.21,284369.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','81919',1632444,'1716','237',402215.43,404490.93,2275.50,318570.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81919',1632445,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81919',1632446,'1718','237',393920.78,395031.49,1110.71,155499.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','81919',1632447,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81919',1632448,'1720','237',367583.41,367596.36,12.95,1813.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81919',1632449,'1721','237',27503.87,27503.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81919',1632450,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81919',1632451,'1723','237',234586.02,234586.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81919',1632452,'1724','237',166023.73,166023.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81919',1632453,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81919',1632454,'1726','237',270297.63,272484.38,2186.75,306145.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81919',1632455,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81919',1632456,'1728','237',193953.23,196838.49,2885.26,403936.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','81919',1632457,'1729','238',110836.55,111596.55,760.00,193800.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','81919',1632458,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81919',1632459,'1731','239',39060.18,39078.01,17.83,4903.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','81920',1632460,'1713','237',101126.40,102755.05,1628.65,228011.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81920',1632461,'1714','237',417271.06,418480.52,1209.46,169324.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','81920',1632462,'1715','237',166129.43,167594.53,1465.10,205114.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81920',1632463,'1716','237',404490.93,406266.29,1775.36,248550.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','81920',1632464,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81920',1632465,'1718','237',395031.49,397978.52,2947.03,412584.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','81920',1632466,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81920',1632467,'1720','237',367596.36,369420.22,1823.86,255340.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','81920',1632468,'1721','237',27503.87,28769.39,1265.52,177172.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','81920',1632469,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81920',1632470,'1723','237',234586.02,234586.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81920',1632471,'1724','237',166023.73,166023.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81920',1632472,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81920',1632473,'1726','237',272484.38,273524.50,1040.12,145616.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','81920',1632474,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81920',1632475,'1728','237',196838.49,197578.83,740.34,103647.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','81920',1632476,'1729','238',111596.55,112175.98,579.43,147754.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','81920',1632477,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81920',1632478,'1731','239',39078.01,39128.20,50.19,13802.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','81925',1632560,'1713','237',102755.05,102755.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81925',1632561,'1714','237',418480.52,419894.33,1413.81,197933.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','81925',1632562,'1715','237',167594.53,168289.76,695.23,97332.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','81925',1632563,'1716','237',406266.29,406600.60,334.31,46803.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','81925',1632564,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81925',1632565,'1718','237',397978.52,399348.30,1369.78,191769.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','81925',1632566,'1719','237',98455.02,98455.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81925',1632567,'1720','237',369420.22,371344.64,1924.42,269418.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','81925',1632568,'1721','237',28769.39,28769.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81925',1632569,'1722','237',85865.01,85865.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81925',1632570,'1723','237',234586.02,235571.38,985.36,137950.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','81925',1632571,'1724','237',166023.73,166023.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81925',1632572,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81925',1632573,'1726','237',273524.50,273524.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81925',1632574,'1727','237',35070.19,35070.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81925',1632575,'1728','237',197578.83,197589.96,11.13,1558.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','81925',1632576,'1729','238',112175.98,112311.80,135.82,34634.10,0.00,0.00,0.00,0.00,0.00),('5','97','618','81925',1632577,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81925',1632578,'1731','239',39128.20,39138.09,9.89,2719.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','81990',1633696,'1713','237',102755.05,102755.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81990',1633697,'1714','237',419894.33,419894.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81990',1633698,'1715','237',168289.76,168289.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','81990',1633699,'1716','237',406600.60,406600.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81990',1633700,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81990',1633701,'1718','237',399348.30,400573.23,1224.93,171490.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','81990',1633702,'1719','237',98455.02,100376.67,1921.65,269031.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','81990',1633703,'1720','237',371344.64,371344.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81990',1633704,'1721','237',28769.39,28769.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81990',1633705,'1722','237',85865.01,86276.63,411.62,57626.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','81990',1633706,'1723','237',235571.38,235571.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','81990',1633707,'1724','237',166023.73,167104.56,1080.83,151316.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','81990',1633708,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','81990',1633709,'1726','237',273524.50,274598.81,1074.31,150403.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','81990',1633710,'1727','237',35070.19,35575.20,505.01,70701.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','81990',1633711,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','81990',1633712,'1729','238',112311.80,113064.25,752.45,191874.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','81990',1633713,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','81990',1633714,'1731','239',39138.09,39218.05,79.96,21989.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','82535',1644359,'1713','237',102755.05,102755.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','82535',1644360,'1714','237',419894.33,419894.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','82535',1644361,'1715','237',168289.76,168289.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','82535',1644362,'1716','237',406600.60,406607.11,6.51,911.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','82535',1644363,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','82535',1644364,'1718','237',400573.23,404407.25,3834.02,536762.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','82535',1644365,'1719','237',100376.67,102192.69,1816.02,254242.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','82535',1644366,'1720','237',371344.64,373809.91,2465.27,345137.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','82535',1644367,'1721','237',28769.39,28769.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','82535',1644368,'1722','237',86276.63,87983.31,1706.68,238935.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','82535',1644369,'1723','237',235571.38,237136.97,1565.59,219182.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','82535',1644370,'1724','237',167104.56,167435.54,330.98,46337.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','82535',1644371,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','82535',1644372,'1726','237',274598.81,277580.29,2981.48,417407.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','82535',1644373,'1727','237',35575.20,37853.99,2278.79,319030.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','82535',1644374,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','82535',1644375,'1729','238',113064.25,113196.33,132.08,33680.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','82535',1644376,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','82535',1644377,'1731','239',39218.05,39273.67,55.62,15295.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','83148',1656429,'1713','237',102755.05,102755.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83148',1656430,'1714','237',419894.33,419894.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83148',1656431,'1715','237',168289.76,168289.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83148',1656432,'1716','237',406607.11,406607.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83148',1656433,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83148',1656434,'1718','237',404407.25,408011.42,3604.17,504583.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','83148',1656435,'1719','237',102192.69,105499.60,3306.91,462967.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83148',1656436,'1720','237',373809.91,373816.69,6.78,949.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83148',1656437,'1721','237',28769.39,28769.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83148',1656438,'1722','237',87983.31,87983.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83148',1656439,'1723','237',237136.97,238012.85,875.88,122623.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83148',1656440,'1724','237',167435.54,169811.14,2375.60,332584.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83148',1656441,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83148',1656442,'1726','237',277580.29,279649.84,2069.55,289737.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83148',1656443,'1727','237',37853.99,40082.92,2228.93,312050.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','83148',1656444,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83148',1656445,'1729','238',113196.33,113222.56,26.23,6688.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','83148',1656446,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83148',1656447,'1731','239',39273.67,39287.07,13.40,3685.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83149',1656448,'1713','237',102755.05,102755.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83149',1656449,'1714','237',419894.33,420500.20,605.87,84821.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','83149',1656450,'1715','237',168289.76,168289.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83149',1656451,'1716','237',406607.11,407426.68,819.57,114739.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','83149',1656452,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83149',1656453,'1718','237',408011.42,410915.39,2903.97,406555.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','83149',1656454,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83149',1656455,'1720','237',373816.69,376533.59,2716.90,380366.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83149',1656456,'1721','237',28769.39,28769.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83149',1656457,'1722','237',87983.31,88492.47,509.16,71282.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','83149',1656458,'1723','237',238012.85,238012.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83149',1656459,'1724','237',169811.14,170706.52,895.38,125353.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83149',1656460,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83149',1656461,'1726','237',279649.84,280777.33,1127.49,157848.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','83149',1656462,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83149',1656463,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83149',1656464,'1729','238',113222.56,113435.44,212.88,54284.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','83149',1656465,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83149',1656466,'1731','239',39287.07,39357.31,70.24,19316.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83154',1656570,'1713','237',102755.05,103633.23,878.18,122945.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','83154',1656571,'1714','237',420500.20,421269.45,769.25,107695.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83154',1656572,'1715','237',168289.76,168949.82,660.06,92408.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','83154',1656573,'1716','237',407426.68,408445.11,1018.43,142580.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','83154',1656574,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83154',1656575,'1718','237',410915.39,412949.10,2033.71,284719.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83154',1656576,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83154',1656577,'1720','237',376533.59,378454.69,1921.10,268954.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83154',1656578,'1721','237',28769.39,28769.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83154',1656579,'1722','237',88492.47,89182.98,690.51,96671.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','83154',1656580,'1723','237',238012.85,238012.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83154',1656581,'1724','237',170706.52,171153.98,447.46,62644.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','83154',1656582,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83154',1656583,'1726','237',280777.33,280777.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83154',1656584,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83154',1656585,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83154',1656586,'1729','238',113435.44,113610.90,175.46,44742.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','83154',1656587,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83154',1656588,'1731','239',39357.31,39476.08,118.77,32661.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','83592',1664961,'1713','237',103633.23,103633.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83592',1664962,'1714','237',421269.45,423238.89,1969.44,275721.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','83592',1664963,'1715','237',168949.82,170461.74,1511.92,211668.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','83592',1664964,'1716','237',408445.11,409642.22,1197.11,167595.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83592',1664965,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83592',1664966,'1718','237',412949.10,416639.76,3690.66,516692.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83592',1664967,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83592',1664968,'1720','237',378454.69,378454.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83592',1664969,'1721','237',28769.39,29733.46,964.07,134969.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','83592',1664970,'1722','237',89182.98,89378.39,195.41,27357.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','83592',1664971,'1723','237',238012.85,238012.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83592',1664972,'1724','237',171153.98,172042.60,888.62,124406.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','83592',1664973,'1725','237',58566.52,58566.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83592',1664974,'1726','237',280777.33,282290.85,1513.52,211892.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','83592',1664975,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83592',1664976,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83592',1664977,'1729','238',113610.90,114360.06,749.16,191035.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','83592',1664978,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83592',1664979,'1731','239',39476.08,39527.29,51.21,14082.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','83594',1664990,'1713','237',103633.23,103633.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83594',1664991,'1714','237',423238.89,425667.65,2428.76,340026.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','83594',1664992,'1715','237',170461.74,171468.65,1006.91,140967.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','83594',1664993,'1716','237',409642.22,411463.29,1821.07,254949.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','83594',1664994,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83594',1664995,'1718','237',416639.76,419589.97,2950.21,413029.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83594',1664996,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83594',1664997,'1720','237',378454.69,379170.24,715.55,100177.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83594',1664998,'1721','237',29733.46,30383.76,650.30,91042.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83594',1664999,'1722','237',89378.39,89528.77,150.38,21053.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83594',1665000,'1723','237',238012.85,238012.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83594',1665001,'1724','237',172042.60,172948.57,905.97,126835.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','83594',1665002,'1725','237',58566.52,60529.52,1963.00,274820.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83594',1665003,'1726','237',282290.85,283474.66,1183.81,165733.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','83594',1665004,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83594',1665005,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83594',1665006,'1729','238',114360.06,114925.04,564.98,144069.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','83594',1665007,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83594',1665008,'1731','239',39527.29,39550.10,22.81,6272.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','83595',1665009,'1713','237',103633.23,105038.01,1404.78,196669.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','83595',1665010,'1714','237',425667.65,426766.09,1098.44,153781.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','83595',1665011,'1715','237',171468.65,171468.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83595',1665012,'1716','237',411463.29,415093.07,3629.78,508169.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','83595',1665013,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83595',1665014,'1718','237',419589.97,421400.15,1810.18,253425.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','83595',1665015,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83595',1665016,'1720','237',379170.24,379170.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83595',1665017,'1721','237',30383.76,30383.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83595',1665018,'1722','237',89528.77,91781.75,2252.98,315417.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83595',1665019,'1723','237',238012.85,238012.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83595',1665020,'1724','237',172948.57,174868.09,1919.52,268732.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','83595',1665021,'1725','237',60529.52,61855.34,1325.82,185614.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','83595',1665022,'1726','237',283474.66,285476.40,2001.74,280243.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','83595',1665023,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83595',1665024,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83595',1665025,'1729','238',114925.04,115033.58,108.54,27677.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','83595',1665026,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83595',1665027,'1731','239',39550.10,39629.15,79.05,21738.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','83598',1665052,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83598',1665053,'1714','237',426766.09,428447.48,1681.39,235394.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','83598',1665054,'1715','237',171468.65,173437.07,1968.42,275578.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','83598',1665055,'1716','237',415093.07,416154.43,1061.36,148590.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83598',1665056,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83598',1665057,'1718','237',421400.15,424900.69,3500.54,490075.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','83598',1665058,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83598',1665059,'1720','237',379170.24,379170.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83598',1665060,'1721','237',30383.76,30383.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83598',1665061,'1722','237',91781.75,92616.48,834.73,116862.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83598',1665062,'1723','237',238012.85,239191.48,1178.63,165008.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83598',1665063,'1724','237',174868.09,177196.43,2328.34,325967.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','83598',1665064,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83598',1665065,'1726','237',285476.40,286214.44,738.04,103325.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','83598',1665066,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83598',1665067,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83598',1665068,'1729','238',115033.58,115196.66,163.08,41585.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','83598',1665069,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83598',1665070,'1731','239',39629.15,39672.79,43.64,12001.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83601',1665112,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83601',1665113,'1714','237',428447.48,431005.44,2557.96,358114.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','83601',1665114,'1715','237',173437.07,175126.63,1689.56,236538.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','83601',1665115,'1716','237',416154.43,417887.72,1733.29,242660.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','83601',1665116,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83601',1665117,'1718','237',424900.69,428523.84,3623.15,507241.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83601',1665118,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83601',1665119,'1720','237',379170.24,379170.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83601',1665120,'1721','237',30383.76,31682.36,1298.60,181804.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83601',1665121,'1722','237',92616.48,93484.76,868.28,121559.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83601',1665122,'1723','237',239191.48,239191.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83601',1665123,'1724','237',177196.43,180303.79,3107.36,435030.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','83601',1665124,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83601',1665125,'1726','237',286214.44,286948.44,734.00,102760.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83601',1665126,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83601',1665127,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83601',1665128,'1729','238',115196.66,115379.54,182.88,46634.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','83601',1665129,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83601',1665130,'1731','239',39672.79,39698.29,25.50,7012.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','83602',1665131,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83602',1665132,'1714','237',431005.44,434423.89,3418.45,478583.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83602',1665133,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83602',1665134,'1716','237',417887.72,421114.26,3226.54,451715.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','83602',1665135,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83602',1665136,'1718','237',428523.84,431442.66,2918.82,408634.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','83602',1665137,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83602',1665138,'1720','237',379170.24,379170.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83602',1665139,'1721','237',31682.36,31682.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83602',1665140,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83602',1665141,'1723','237',239191.48,242017.95,2826.47,395705.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','83602',1665142,'1724','237',180303.79,182066.77,1762.98,246817.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83602',1665143,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83602',1665144,'1726','237',286948.44,287625.40,676.96,94774.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','83602',1665145,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83602',1665146,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83602',1665147,'1729','238',115379.54,115611.19,231.65,59070.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','83602',1665148,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83602',1665149,'1731','239',39698.29,39737.72,39.43,10843.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','83608',1665288,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83608',1665289,'1714','237',434423.89,437395.90,2972.01,416081.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','83608',1665290,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83608',1665291,'1716','237',421114.26,423587.32,2473.06,346228.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83608',1665292,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83608',1665293,'1718','237',431442.66,435326.50,3883.84,543737.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','83608',1665294,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83608',1665295,'1720','237',379170.24,379170.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83608',1665296,'1721','237',31682.36,31682.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83608',1665297,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83608',1665298,'1723','237',242017.95,243837.38,1819.43,254720.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83608',1665299,'1724','237',182066.77,184459.30,2392.53,334954.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83608',1665300,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83608',1665301,'1726','237',287625.40,288905.39,1279.99,179198.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','83608',1665302,'1727','237',40082.92,40082.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83608',1665303,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83608',1665304,'1729','238',115611.19,116726.64,1115.45,284439.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','83608',1665305,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83608',1665306,'1731','239',39737.72,39782.87,45.15,12416.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','83609',1665307,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83609',1665308,'1714','237',437395.90,440512.50,3116.60,436324.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83609',1665309,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83609',1665310,'1716','237',423587.32,426848.05,3260.73,456502.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','83609',1665311,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83609',1665312,'1718','237',435326.50,439715.43,4388.93,614450.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','83609',1665313,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83609',1665314,'1720','237',379170.24,379170.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83609',1665315,'1721','237',31682.36,31682.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83609',1665316,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83609',1665317,'1723','237',243837.38,244285.54,448.16,62742.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','83609',1665318,'1724','237',184459.30,185102.25,642.95,90013.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83609',1665319,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83609',1665320,'1726','237',288905.39,290652.25,1746.86,244560.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','83609',1665321,'1727','237',40082.92,40888.82,805.90,112826.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83609',1665322,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83609',1665323,'1729','238',116726.64,116846.21,119.57,30490.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','83609',1665324,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83609',1665325,'1731','239',39782.87,39828.60,45.73,12575.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','83610',1665326,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83610',1665327,'1714','237',440512.50,443462.81,2950.31,413043.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','83610',1665328,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83610',1665329,'1716','237',426848.05,430361.07,3513.02,491822.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','83610',1665330,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83610',1665331,'1718','237',439715.43,442959.63,3244.20,454188.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83610',1665332,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83610',1665333,'1720','237',379170.24,379170.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83610',1665334,'1721','237',31682.36,31682.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83610',1665335,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83610',1665336,'1723','237',244285.54,244285.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83610',1665337,'1724','237',185102.25,185102.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83610',1665338,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83610',1665339,'1726','237',290652.25,291866.58,1214.33,170006.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','83610',1665340,'1727','237',40888.82,42970.41,2081.59,291422.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','83610',1665341,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83610',1665342,'1729','238',116846.21,117167.37,321.16,81895.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','83610',1665343,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83610',1665344,'1731','239',39828.60,39858.25,29.65,8153.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','83612',1665375,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83612',1665376,'1714','237',443462.81,446079.93,2617.12,366396.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','83612',1665377,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83612',1665378,'1716','237',430361.07,434128.74,3767.67,527473.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','83612',1665379,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83612',1665380,'1718','237',442959.63,446565.76,3606.13,504858.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','83612',1665381,'1719','237',105499.60,105499.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83612',1665382,'1720','237',379170.24,379170.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83612',1665383,'1721','237',31682.36,33428.64,1746.28,244479.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','83612',1665384,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83612',1665385,'1723','237',244285.54,244285.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83612',1665386,'1724','237',185102.25,185102.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83612',1665387,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83612',1665388,'1726','237',291866.58,292744.79,878.21,122949.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','83612',1665389,'1727','237',42970.41,45260.01,2289.60,320544.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83612',1665390,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83612',1665391,'1729','238',117167.37,118297.80,1130.43,288259.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','83612',1665392,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83612',1665393,'1731','239',39858.25,39858.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83613',1665394,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83613',1665395,'1714','237',446079.93,447756.45,1676.52,234712.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','83613',1665396,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','83613',1665397,'1716','237',434128.74,437953.75,3825.01,535501.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83613',1665398,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83613',1665399,'1718','237',446565.76,450695.41,4129.65,578151.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','83613',1665400,'1719','237',105499.60,106467.26,967.66,135472.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','83613',1665401,'1720','237',379170.24,380260.30,1090.06,152608.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','83613',1665402,'1721','237',33428.64,33428.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83613',1665403,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83613',1665404,'1723','237',244285.54,244285.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83613',1665405,'1724','237',185102.25,185102.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','83613',1665406,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83613',1665407,'1726','237',292744.79,295805.54,3060.75,428505.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','83613',1665408,'1727','237',45260.01,45795.55,535.54,74975.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','83613',1665409,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','83613',1665410,'1729','238',118297.80,118446.38,148.58,37887.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','83613',1665411,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','83613',1665412,'1731','239',39858.25,39900.91,42.66,11731.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','84465',1681675,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84465',1681676,'1714','237',447756.45,449615.45,1859.00,260260.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84465',1681677,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84465',1681678,'1716','237',437953.75,440981.19,3027.44,423841.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','84465',1681679,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84465',1681680,'1718','237',450695.41,452680.49,1985.08,277911.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','84465',1681681,'1719','237',106467.26,106467.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84465',1681682,'1720','237',380260.30,380260.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84465',1681683,'1721','237',33428.64,33428.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84465',1681684,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84465',1681685,'1723','237',244285.54,244600.38,314.84,44077.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','84465',1681686,'1724','237',185102.25,185102.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84465',1681687,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84465',1681688,'1726','237',295805.54,297636.95,1831.41,256397.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','84465',1681689,'1727','237',45795.55,45795.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84465',1681690,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','84465',1681691,'1729','238',118446.38,118679.24,232.86,59379.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','84465',1681692,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','84465',1681693,'1731','239',39900.91,39981.68,80.77,22211.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','84466',1681694,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84466',1681695,'1714','237',449615.45,451530.07,1914.62,268046.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','84466',1681696,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84466',1681697,'1716','237',440981.19,443592.59,2611.40,365596.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84466',1681698,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84466',1681699,'1718','237',452680.49,455031.43,2350.94,329131.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','84466',1681700,'1719','237',106467.26,106467.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84466',1681701,'1720','237',380260.30,381511.48,1251.18,175165.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','84466',1681702,'1721','237',33428.64,34129.63,700.99,98138.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','84466',1681703,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84466',1681704,'1723','237',244600.38,244600.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84466',1681705,'1724','237',185102.25,185102.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84466',1681706,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84466',1681707,'1726','237',297636.95,299203.59,1566.64,219329.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','84466',1681708,'1727','237',45795.55,45795.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84466',1681709,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','84466',1681710,'1729','238',118679.24,118679.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','84466',1681711,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','84466',1681712,'1731','239',39981.68,40031.09,49.41,13587.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','84467',1681713,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84467',1681714,'1714','237',451530.07,453728.47,2198.40,307776.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84467',1681715,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84467',1681716,'1716','237',443592.59,445636.75,2044.16,286182.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','84467',1681717,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84467',1681718,'1718','237',455031.43,456660.93,1629.50,228130.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84467',1681719,'1719','237',106467.26,106467.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84467',1681720,'1720','237',381511.48,383069.37,1557.89,218104.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','84467',1681721,'1721','237',34129.63,34129.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84467',1681722,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84467',1681723,'1723','237',244600.38,244600.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84467',1681724,'1724','237',185102.25,185102.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84467',1681725,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84467',1681726,'1726','237',299203.59,302345.94,3142.35,439929.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84467',1681727,'1727','237',45795.55,48676.62,2881.07,403349.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','84467',1681728,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','84467',1681729,'1729','238',118679.24,118679.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','84467',1681730,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','84467',1681731,'1731','239',40031.09,40106.08,74.99,20622.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','84468',1681732,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84468',1681733,'1714','237',453728.47,453728.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84468',1681734,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84468',1681735,'1716','237',445636.75,445636.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84468',1681736,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84468',1681737,'1718','237',456660.93,460168.82,3507.89,491104.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','84468',1681738,'1719','237',106467.26,109060.92,2593.66,363112.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','84468',1681739,'1720','237',383069.37,384476.66,1407.29,197020.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','84468',1681740,'1721','237',34129.63,34129.94,0.31,43.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','84468',1681741,'1722','237',93484.76,93484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84468',1681742,'1723','237',244600.38,244850.92,250.54,35075.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','84468',1681743,'1724','237',185102.25,185102.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84468',1681744,'1725','237',61855.34,61855.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84468',1681745,'1726','237',302345.94,304596.39,2250.45,315063.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84468',1681746,'1727','237',48676.62,50833.91,2157.29,302020.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','84468',1681747,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','84468',1681748,'1729','238',118679.24,118679.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','84468',1681749,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','84468',1681750,'1731','239',40106.08,40167.43,61.35,16871.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','84471',1681800,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84471',1681801,'1714','237',453728.47,453728.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84471',1681802,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','84471',1681803,'1716','237',445636.75,445636.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84471',1681804,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84471',1681805,'1718','237',460168.82,465431.17,5262.35,736729.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84471',1681806,'1719','237',109060.92,110892.52,1831.60,256424.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','84471',1681807,'1720','237',384476.66,387317.81,2841.15,397761.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84471',1681808,'1721','237',34129.94,34129.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','84471',1681809,'1722','237',93484.76,93535.15,50.39,7054.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','84471',1681810,'1723','237',244850.92,245661.44,810.52,113472.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','84471',1681811,'1724','237',185102.25,187031.01,1928.76,270026.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','84471',1681812,'1725','237',61855.34,63593.21,1737.87,243301.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','84471',1681813,'1726','237',304596.39,304596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84471',1681814,'1727','237',50833.91,50833.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','84471',1681815,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','84471',1681816,'1729','238',118679.24,121960.94,3281.70,836833.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','84471',1681817,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','84471',1681818,'1731','239',40167.43,40226.74,59.31,16310.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','88864',1768548,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88864',1768549,'1714','237',453728.47,454968.56,1240.09,174852.69,0.00,0.00,0.00,0.00,0.00),('5','97','614','88864',1768550,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88864',1768551,'1716','237',445636.75,448435.53,2798.78,394627.98,0.00,0.00,0.00,0.00,0.00),('5','97','615','88864',1768552,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88864',1768553,'1718','237',465431.17,466446.22,1015.05,143122.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','88864',1768554,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88864',1768555,'1720','237',387317.81,388526.40,1208.59,170411.19,0.00,0.00,0.00,0.00,0.00),('5','97','616','88864',1768556,'1721','237',34129.94,34129.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88864',1768557,'1722','237',93535.15,95361.08,1825.93,257456.13,0.00,0.00,0.00,0.00,0.00),('5','97','616','88864',1768558,'1723','237',245661.44,247544.85,1883.41,265560.81,0.00,0.00,0.00,0.00,0.00),('5','97','616','88864',1768559,'1724','237',187031.01,188555.61,1524.60,214968.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','88864',1768560,'1725','237',63593.21,64873.36,1280.15,180501.15,0.00,0.00,0.00,0.00,0.00),('5','97','617','88864',1768561,'1726','237',304596.39,304596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88864',1768562,'1727','237',50833.91,50833.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88864',1768563,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88864',1768564,'1729','238',121960.94,122057.11,96.17,21638.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','88864',1768565,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88864',1768566,'1731','239',40226.74,40254.72,27.98,7694.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','88866',1768585,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88866',1768586,'1714','237',454968.56,455759.06,790.50,111460.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','88866',1768587,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88866',1768588,'1716','237',448435.53,452886.79,4451.26,627627.66,0.00,0.00,0.00,0.00,0.00),('5','97','615','88866',1768589,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88866',1768590,'1718','237',466446.22,466446.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88866',1768591,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88866',1768592,'1720','237',388526.40,388526.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88866',1768593,'1721','237',34129.94,34129.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88866',1768594,'1722','237',95361.08,98900.18,3539.10,499013.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','88866',1768595,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88866',1768596,'1724','237',188555.61,191897.89,3342.28,471261.48,0.00,0.00,0.00,0.00,0.00),('5','97','616','88866',1768597,'1725','237',64873.36,66473.27,1599.91,225587.31,0.00,0.00,0.00,0.00,0.00),('5','97','617','88866',1768598,'1726','237',304596.39,304596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88866',1768599,'1727','237',50833.91,50833.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88866',1768600,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88866',1768601,'1729','238',122057.11,122537.51,480.40,108090.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88866',1768602,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88866',1768603,'1731','239',40254.72,40282.27,27.55,7576.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','88867',1768604,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88867',1768605,'1714','237',455759.06,457201.39,1442.33,203368.53,0.00,0.00,0.00,0.00,0.00),('5','97','614','88867',1768606,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88867',1768607,'1716','237',452886.79,453183.39,296.60,41820.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','88867',1768608,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88867',1768609,'1718','237',466446.22,468955.34,2509.12,353785.92,0.00,0.00,0.00,0.00,0.00),('5','97','615','88867',1768610,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88867',1768611,'1720','237',388526.40,388939.80,413.40,58289.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','88867',1768612,'1721','237',34129.94,34129.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88867',1768613,'1722','237',98900.18,102737.49,3837.31,541060.71,0.00,0.00,0.00,0.00,0.00),('5','97','616','88867',1768614,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88867',1768615,'1724','237',191897.89,193305.68,1407.79,198498.39,0.00,0.00,0.00,0.00,0.00),('5','97','616','88867',1768616,'1725','237',66473.27,69249.80,2776.53,391490.73,0.00,0.00,0.00,0.00,0.00),('5','97','617','88867',1768617,'1726','237',304596.39,304596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88867',1768618,'1727','237',50833.91,50833.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88867',1768619,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88867',1768620,'1729','238',122537.51,122635.25,97.74,21991.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','88867',1768621,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88867',1768622,'1731','239',40282.27,40330.12,47.85,13158.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','88868',1768623,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88868',1768624,'1714','237',457201.39,457838.05,636.66,89769.06,0.00,0.00,0.00,0.00,0.00),('5','97','614','88868',1768625,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88868',1768626,'1716','237',453183.39,454966.94,1783.55,251480.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','88868',1768627,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88868',1768628,'1718','237',468955.34,469356.65,401.31,56584.71,0.00,0.00,0.00,0.00,0.00),('5','97','615','88868',1768629,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88868',1768630,'1720','237',388939.80,388939.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88868',1768631,'1721','237',34129.94,34129.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88868',1768632,'1722','237',102737.49,107322.36,4584.87,646466.67,0.00,0.00,0.00,0.00,0.00),('5','97','616','88868',1768633,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88868',1768634,'1724','237',193305.68,195513.44,2207.76,311294.16,0.00,0.00,0.00,0.00,0.00),('5','97','616','88868',1768635,'1725','237',69249.80,73081.43,3831.63,540259.83,0.00,0.00,0.00,0.00,0.00),('5','97','617','88868',1768636,'1726','237',304596.39,304596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88868',1768637,'1727','237',50833.91,50833.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88868',1768638,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88868',1768639,'1729','238',122635.25,123325.50,690.25,155306.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','88868',1768640,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88868',1768641,'1731','239',40330.12,40497.41,167.29,46004.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','88878',1768813,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88878',1768814,'1714','237',457838.05,459686.91,1848.86,260689.26,0.00,0.00,0.00,0.00,0.00),('5','97','614','88878',1768815,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88878',1768816,'1716','237',454966.94,456245.62,1278.68,180293.88,0.00,0.00,0.00,0.00,0.00),('5','97','615','88878',1768817,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88878',1768818,'1718','237',469356.65,472377.18,3020.53,425894.73,0.00,0.00,0.00,0.00,0.00),('5','97','615','88878',1768819,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88878',1768820,'1720','237',388939.80,388939.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88878',1768821,'1721','237',34129.94,34129.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88878',1768822,'1722','237',107322.36,110307.41,2985.05,420892.05,0.00,0.00,0.00,0.00,0.00),('5','97','616','88878',1768823,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88878',1768824,'1724','237',195513.44,197994.51,2481.07,349830.87,0.00,0.00,0.00,0.00,0.00),('5','97','616','88878',1768825,'1725','237',73081.43,74321.49,1240.06,174848.46,0.00,0.00,0.00,0.00,0.00),('5','97','617','88878',1768826,'1726','237',304596.39,304596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88878',1768827,'1727','237',50833.91,50833.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88878',1768828,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88878',1768829,'1729','238',123325.50,123769.59,444.09,99920.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','88878',1768830,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88878',1768831,'1731','239',40497.41,40687.71,190.30,52332.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','88879',1768832,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88879',1768833,'1714','237',459686.91,461900.70,2213.79,312144.39,0.00,0.00,0.00,0.00,0.00),('5','97','614','88879',1768834,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88879',1768835,'1716','237',456245.62,458360.28,2114.66,298167.06,0.00,0.00,0.00,0.00,0.00),('5','97','615','88879',1768836,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88879',1768837,'1718','237',472377.18,476733.86,4356.68,614291.88,0.00,0.00,0.00,0.00,0.00),('5','97','615','88879',1768838,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88879',1768839,'1720','237',388939.80,391637.44,2697.64,380367.24,0.00,0.00,0.00,0.00,0.00),('5','97','616','88879',1768840,'1721','237',34129.94,35192.45,1062.51,149813.91,0.00,0.00,0.00,0.00,0.00),('5','97','616','88879',1768841,'1722','237',110307.41,110307.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88879',1768842,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88879',1768843,'1724','237',197994.51,197994.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88879',1768844,'1725','237',74321.49,74321.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88879',1768845,'1726','237',304596.39,305501.11,904.72,127565.52,0.00,0.00,0.00,0.00,0.00),('5','97','617','88879',1768846,'1727','237',50833.91,52196.08,1362.17,192065.97,0.00,0.00,0.00,0.00,0.00),('5','97','617','88879',1768847,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88879',1768848,'1729','238',123769.59,123843.05,73.46,16528.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','88879',1768849,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88879',1768850,'1731','239',40687.71,40861.84,174.13,47885.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','88881',1768868,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88881',1768869,'1714','237',461900.70,464006.90,2106.20,296974.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','88881',1768870,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88881',1768871,'1716','237',458360.28,461970.97,3610.69,509107.29,0.00,0.00,0.00,0.00,0.00),('5','97','615','88881',1768872,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88881',1768873,'1718','237',476733.86,481472.33,4738.47,668124.27,0.00,0.00,0.00,0.00,0.00),('5','97','615','88881',1768874,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88881',1768875,'1720','237',391637.44,392447.33,809.89,114194.49,0.00,0.00,0.00,0.00,0.00),('5','97','616','88881',1768876,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88881',1768877,'1722','237',110307.41,110307.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88881',1768878,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88881',1768879,'1724','237',197994.51,197994.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88881',1768880,'1725','237',74321.49,74321.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88881',1768881,'1726','237',305501.11,308304.86,2803.75,395328.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','88881',1768882,'1727','237',52196.08,52904.29,708.21,99857.61,0.00,0.00,0.00,0.00,0.00),('5','97','617','88881',1768883,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88881',1768884,'1729','238',123843.05,124630.35,787.30,177142.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','88881',1768885,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88881',1768886,'1731','239',40861.84,41158.11,296.27,81474.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','88883',1768910,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88883',1768911,'1714','237',464006.90,464006.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88883',1768912,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88883',1768913,'1716','237',461970.97,461970.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88883',1768914,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88883',1768915,'1718','237',481472.33,481472.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88883',1768916,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88883',1768917,'1720','237',392447.33,392447.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88883',1768918,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88883',1768919,'1722','237',110307.41,110307.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88883',1768920,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88883',1768921,'1724','237',197994.51,197994.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88883',1768922,'1725','237',74321.49,74321.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88883',1768923,'1726','237',308304.86,308304.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88883',1768924,'1727','237',52904.29,52904.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88883',1768925,'1728','237',197589.96,197589.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88883',1768926,'1729','238',124630.35,124630.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88883',1768927,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88883',1768928,'1731','239',41158.11,41158.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88884',1768929,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88884',1768930,'1714','237',464006.90,466424.08,2417.18,340822.38,0.00,0.00,0.00,0.00,0.00),('5','97','614','88884',1768931,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88884',1768932,'1716','237',461970.97,465504.05,3533.08,498164.28,0.00,0.00,0.00,0.00,0.00),('5','97','615','88884',1768933,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88884',1768934,'1718','237',481472.33,485525.02,4052.69,571429.29,0.00,0.00,0.00,0.00,0.00),('5','97','615','88884',1768935,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88884',1768936,'1720','237',392447.33,392447.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88884',1768937,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88884',1768938,'1722','237',110307.41,110307.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88884',1768939,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88884',1768940,'1724','237',197994.51,197994.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88884',1768941,'1725','237',74321.49,74321.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88884',1768942,'1726','237',308304.86,311045.52,2740.66,386433.06,0.00,0.00,0.00,0.00,0.00),('5','97','617','88884',1768943,'1727','237',52904.29,52904.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88884',1768944,'1728','237',197589.96,198579.22,989.26,139485.66,0.00,0.00,0.00,0.00,0.00),('5','97','618','88884',1768945,'1729','238',124630.35,125203.92,573.57,129053.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','88884',1768946,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88884',1768947,'1731','239',41158.11,41391.95,233.84,64306.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88895',1769126,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88895',1769127,'1714','237',466424.08,469738.45,3314.37,473954.91,0.00,0.00,0.00,0.00,0.00),('5','97','614','88895',1769128,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88895',1769129,'1716','237',465504.05,469738.45,4234.40,605519.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','88895',1769130,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88895',1769131,'1718','237',485525.02,487591.20,2066.18,295463.74,0.00,0.00,0.00,0.00,0.00),('5','97','615','88895',1769132,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88895',1769133,'1720','237',392447.33,392447.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88895',1769134,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88895',1769135,'1722','237',110307.41,114291.32,3983.91,569699.13,0.00,0.00,0.00,0.00,0.00),('5','97','616','88895',1769136,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88895',1769137,'1724','237',197994.51,199108.20,1113.69,159257.67,0.00,0.00,0.00,0.00,0.00),('5','97','616','88895',1769138,'1725','237',74321.49,74321.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88895',1769139,'1726','237',311045.52,313805.45,2759.93,394669.99,0.00,0.00,0.00,0.00,0.00),('5','97','617','88895',1769140,'1727','237',52904.29,52904.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88895',1769141,'1728','237',198579.22,198579.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88895',1769142,'1729','238',125203.92,126168.13,964.21,216947.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','88895',1769143,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88895',1769144,'1731','239',41391.95,41536.31,144.36,39699.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88896',1769145,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88896',1769146,'1714','237',469738.45,473827.57,4089.12,584744.16,0.00,0.00,0.00,0.00,0.00),('5','97','614','88896',1769147,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88896',1769148,'1716','237',469738.45,469738.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88896',1769149,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88896',1769150,'1718','237',487591.20,492885.16,5293.96,757036.28,0.00,0.00,0.00,0.00,0.00),('5','97','615','88896',1769151,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88896',1769152,'1720','237',392447.33,392447.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88896',1769153,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88896',1769154,'1722','237',114291.32,115524.01,1232.69,176274.67,0.00,0.00,0.00,0.00,0.00),('5','97','616','88896',1769155,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88896',1769156,'1724','237',199108.20,199108.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88896',1769157,'1725','237',74321.49,75715.89,1394.40,199399.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','88896',1769158,'1726','237',313805.45,316673.75,2868.30,410166.90,0.00,0.00,0.00,0.00,0.00),('5','97','617','88896',1769159,'1727','237',52904.29,54950.37,2046.08,292589.44,0.00,0.00,0.00,0.00,0.00),('5','97','617','88896',1769160,'1728','237',198579.22,198579.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88896',1769161,'1729','238',126168.13,126533.25,365.12,82152.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88896',1769162,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88896',1769163,'1731','239',41536.31,41776.07,239.76,65934.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88897',1769164,'1713','237',105038.01,105038.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88897',1769165,'1714','237',473827.57,473827.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88897',1769166,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88897',1769167,'1716','237',469738.45,469738.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88897',1769168,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88897',1769169,'1718','237',492885.16,498304.08,5418.92,774905.56,0.00,0.00,0.00,0.00,0.00),('5','97','615','88897',1769170,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88897',1769171,'1720','237',392447.33,392447.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88897',1769172,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88897',1769173,'1722','237',115524.01,119390.90,3866.89,552965.27,0.00,0.00,0.00,0.00,0.00),('5','97','616','88897',1769174,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88897',1769175,'1724','237',199108.20,199108.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88897',1769176,'1725','237',75715.89,78296.45,2580.56,369020.08,0.00,0.00,0.00,0.00,0.00),('5','97','617','88897',1769177,'1726','237',316673.75,317384.92,711.17,101697.31,0.00,0.00,0.00,0.00,0.00),('5','97','617','88897',1769178,'1727','237',54950.37,55863.98,913.61,130646.23,0.00,0.00,0.00,0.00,0.00),('5','97','617','88897',1769179,'1728','237',198579.22,198579.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88897',1769180,'1729','238',126533.25,126708.35,175.10,39397.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','88897',1769181,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88897',1769182,'1731','239',41776.07,41917.17,141.10,38802.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','88901',1769229,'1713','237',105038.01,106264.11,1226.10,175332.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','88901',1769230,'1714','237',473827.57,473827.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88901',1769231,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88901',1769232,'1716','237',469738.45,470710.48,972.03,139000.29,0.00,0.00,0.00,0.00,0.00),('5','97','615','88901',1769233,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88901',1769234,'1718','237',498304.08,501382.54,3078.46,440219.78,0.00,0.00,0.00,0.00,0.00),('5','97','615','88901',1769235,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88901',1769236,'1720','237',392447.33,394374.26,1926.93,275550.99,0.00,0.00,0.00,0.00,0.00),('5','97','616','88901',1769237,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88901',1769238,'1722','237',119390.90,121284.88,1893.98,270839.14,0.00,0.00,0.00,0.00,0.00),('5','97','616','88901',1769239,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88901',1769240,'1724','237',199108.20,199108.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88901',1769241,'1725','237',78296.45,79274.83,978.38,139908.34,0.00,0.00,0.00,0.00,0.00),('5','97','617','88901',1769242,'1726','237',317384.92,318318.18,933.26,133456.18,0.00,0.00,0.00,0.00,0.00),('5','97','617','88901',1769243,'1727','237',55863.98,56684.99,821.01,117404.43,0.00,0.00,0.00,0.00,0.00),('5','97','617','88901',1769244,'1728','237',198579.22,198579.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88901',1769245,'1729','238',126708.35,126822.46,114.11,25674.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','88901',1769246,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88901',1769247,'1731','239',41917.17,42086.02,168.85,46433.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','88902',1769248,'1713','237',106264.11,106264.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88902',1769249,'1714','237',473827.57,475254.02,1426.45,203982.35,0.00,0.00,0.00,0.00,0.00),('5','97','614','88902',1769250,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88902',1769251,'1716','237',470710.48,472798.28,2087.80,298555.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','88902',1769252,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88902',1769253,'1718','237',501382.54,504275.88,2893.34,413747.62,0.00,0.00,0.00,0.00,0.00),('5','97','615','88902',1769254,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88902',1769255,'1720','237',394374.26,396790.49,2416.23,345520.89,0.00,0.00,0.00,0.00,0.00),('5','97','616','88902',1769256,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88902',1769257,'1722','237',121284.88,122663.82,1378.94,197188.42,0.00,0.00,0.00,0.00,0.00),('5','97','616','88902',1769258,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88902',1769259,'1724','237',199108.20,199108.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88902',1769260,'1725','237',79274.83,80430.80,1155.97,165303.71,0.00,0.00,0.00,0.00,0.00),('5','97','617','88902',1769261,'1726','237',318318.18,318318.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88902',1769262,'1727','237',56684.99,56684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88902',1769263,'1728','237',198579.22,198579.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88902',1769264,'1729','238',126822.46,127202.50,380.04,85509.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88902',1769265,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88902',1769266,'1731','239',42086.02,42251.08,165.06,45391.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','88907',1769337,'1713','237',106264.11,106264.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88907',1769338,'1714','237',475254.02,477287.97,2033.95,290854.85,0.00,0.00,0.00,0.00,0.00),('5','97','614','88907',1769339,'1715','237',175126.63,175126.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','88907',1769340,'1716','237',472798.28,474563.26,1764.98,252392.14,0.00,0.00,0.00,0.00,0.00),('5','97','615','88907',1769341,'1717','237',107222.97,107222.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88907',1769342,'1718','237',504275.88,507463.51,3187.63,455831.09,0.00,0.00,0.00,0.00,0.00),('5','97','615','88907',1769343,'1719','237',110892.52,110892.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','88907',1769344,'1720','237',396790.49,399021.50,2231.01,319034.43,0.00,0.00,0.00,0.00,0.00),('5','97','616','88907',1769345,'1721','237',35192.45,35192.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88907',1769346,'1722','237',122663.82,124440.76,1776.94,254102.42,0.00,0.00,0.00,0.00,0.00),('5','97','616','88907',1769347,'1723','237',247544.85,247544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88907',1769348,'1724','237',199108.20,199108.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','88907',1769349,'1725','237',80430.80,82281.91,1851.11,264708.73,0.00,0.00,0.00,0.00,0.00),('5','97','617','88907',1769350,'1726','237',318318.18,318318.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88907',1769351,'1727','237',56684.99,56684.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','88907',1769352,'1728','237',198579.22,198579.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','88907',1769353,'1729','238',127202.50,127909.48,706.98,159070.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','88907',1769354,'1730','238',650.46,650.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','88907',1769355,'1731','239',42251.08,42385.36,134.28,36927.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','103336',2050663,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','103336',2050664,'1714','237',671107.78,672904.93,1797.15,251601.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','103336',2050665,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','103336',2050666,'1716','237',704747.19,707058.32,2311.13,323558.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','103336',2050667,'1717','237',149844.62,150937.83,1093.21,153049.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','103336',2050668,'1718','237',612609.69,612609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','103336',2050669,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','103336',2050670,'1720','237',564047.44,565975.94,1928.50,269990.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','103336',2050671,'1721','237',45076.81,45076.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','103336',2050672,'1722','237',234513.06,234513.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','103336',2050673,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','103336',2050674,'1724','237',265834.44,266968.20,1133.76,158726.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','103336',2050675,'1725','237',119743.77,120505.77,762.00,106680.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','103336',2050676,'1726','237',443662.99,444316.41,653.42,91478.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','103336',2050677,'1727','237',104534.90,104729.52,194.62,27246.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','103336',2050678,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','103336',2050679,'1729','238',230860.63,231071.98,211.35,47553.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','103336',2050680,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','103336',2050681,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104270',2069526,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104270',2069527,'1714','237',672904.93,674778.82,1873.89,262344.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','104270',2069528,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104270',2069529,'1716','237',707058.32,709945.79,2887.47,404245.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','104270',2069530,'1717','237',150937.83,151658.88,721.05,100947.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104270',2069531,'1718','237',612609.69,612609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104270',2069532,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104270',2069533,'1720','237',565975.94,568983.77,3007.83,421096.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','104270',2069534,'1721','237',45076.81,45076.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104270',2069535,'1722','237',234513.06,234513.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104270',2069536,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104270',2069537,'1724','237',266968.20,268092.04,1123.84,157337.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104270',2069538,'1725','237',120505.77,121058.98,553.21,77449.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','104270',2069539,'1726','237',444316.41,444585.27,268.86,37640.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','104270',2069540,'1727','237',104729.52,104729.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104270',2069541,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104270',2069542,'1729','238',231071.98,231469.14,397.16,89361.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104270',2069543,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104270',2069544,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104278',2069655,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104278',2069656,'1714','237',674778.82,675974.29,1195.47,167365.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','104278',2069657,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104278',2069658,'1716','237',709945.79,711195.33,1249.54,174935.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104278',2069659,'1717','237',151658.88,153727.79,2068.91,289647.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104278',2069660,'1718','237',612609.69,612609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104278',2069661,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104278',2069662,'1720','237',568983.77,571085.50,2101.73,294242.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','104278',2069663,'1721','237',45076.81,45076.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104278',2069664,'1722','237',254943.69,255375.79,432.10,60494.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104278',2069665,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104278',2069666,'1724','237',268092.04,269027.07,935.03,130904.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','104278',2069667,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104278',2069668,'1726','237',444585.27,444943.21,357.94,50111.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','104278',2069669,'1727','237',104729.52,105044.63,315.11,44115.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','104278',2069670,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104278',2069671,'1729','238',231469.14,231934.89,465.75,104793.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','104278',2069672,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104278',2069673,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104281',2069705,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104281',2069706,'1714','237',675974.29,677587.49,1613.20,225848.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104281',2069707,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104281',2069708,'1716','237',711195.33,712770.42,1575.09,220512.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104281',2069709,'1717','237',153727.79,154858.18,1130.39,158254.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104281',2069710,'1718','237',612609.69,612609.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104281',2069711,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104281',2069712,'1720','237',571085.50,572902.88,1817.38,254433.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','104281',2069713,'1721','237',45076.81,45076.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104281',2069714,'1722','237',255375.79,255375.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104281',2069715,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104281',2069716,'1724','237',269027.07,270053.84,1026.77,143747.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104281',2069717,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104281',2069718,'1726','237',444943.21,445615.14,671.93,94070.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','104281',2069719,'1727','237',105044.63,105044.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104281',2069720,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104281',2069721,'1729','238',231934.89,232504.14,569.25,128081.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','104281',2069722,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104281',2069723,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104285',2069773,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104285',2069774,'1714','237',677587.49,679237.60,1650.11,231015.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','104285',2069775,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104285',2069776,'1716','237',712770.42,714439.46,1669.04,233665.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104285',2069777,'1717','237',154858.18,156287.21,1429.03,200064.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104285',2069778,'1718','237',651682.65,652443.26,760.61,106485.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104285',2069779,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104285',2069780,'1720','237',572902.88,575392.23,2489.35,348509.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104285',2069781,'1721','237',52809.37,53115.32,305.95,42833.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104285',2069782,'1722','237',255375.79,255961.78,585.99,82038.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104285',2069783,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104285',2069784,'1724','237',270053.84,270773.36,719.52,100732.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104285',2069785,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104285',2069786,'1726','237',445615.14,445615.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104285',2069787,'1727','237',105044.63,105044.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104285',2069788,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104285',2069789,'1729','238',232504.14,232748.01,243.87,54870.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','104285',2069790,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104285',2069791,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104287',2069846,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104287',2069847,'1714','237',679237.60,680471.77,1234.17,172783.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','104287',2069848,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104287',2069849,'1716','237',714439.46,716829.67,2390.21,334629.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104287',2069850,'1717','237',156287.21,157305.87,1018.66,142612.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104287',2069851,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104287',2069852,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104287',2069853,'1720','237',575392.23,577239.30,1847.07,258589.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104287',2069854,'1721','237',53115.32,53115.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104287',2069855,'1722','237',255961.78,256173.39,211.61,29625.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104287',2069856,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104287',2069857,'1724','237',270773.36,271545.69,772.33,108126.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','104287',2069858,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104287',2069859,'1726','237',445615.14,446351.17,736.03,103044.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','104287',2069860,'1727','237',105044.63,105044.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104287',2069861,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104287',2069862,'1729','238',232748.01,233067.95,319.94,71986.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','104287',2069863,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104287',2069864,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104289',2069878,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104289',2069879,'1714','237',680471.77,681545.45,1073.68,150315.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','104289',2069880,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104289',2069881,'1716','237',716829.67,718466.60,1636.93,229170.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104289',2069882,'1717','237',157305.87,158560.88,1255.01,175701.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104289',2069883,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104289',2069884,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104289',2069885,'1720','237',577239.30,579274.27,2034.97,284895.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104289',2069886,'1721','237',53115.32,53115.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104289',2069887,'1722','237',256173.39,256775.33,601.94,84271.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104289',2069888,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104289',2069889,'1724','237',271545.69,272994.39,1448.70,202818.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104289',2069890,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104289',2069891,'1726','237',446351.17,446606.74,255.57,35779.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','104289',2069892,'1727','237',105044.63,105044.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104289',2069893,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104289',2069894,'1729','238',233067.95,233470.56,402.61,90587.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','104289',2069895,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104289',2069896,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104292',2069952,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104292',2069953,'1714','237',681545.45,682758.33,1212.88,169803.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','104292',2069954,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104292',2069955,'1716','237',718466.60,720791.14,2324.54,325435.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104292',2069956,'1717','237',158560.88,159091.29,530.41,74257.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104292',2069957,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104292',2069958,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104292',2069959,'1720','237',579274.27,582042.16,2767.89,387504.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104292',2069960,'1721','237',53115.32,53115.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104292',2069961,'1722','237',256775.33,257854.00,1078.67,151013.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104292',2069962,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104292',2069963,'1724','237',272994.39,274243.05,1248.66,174812.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104292',2069964,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104292',2069965,'1726','237',446606.74,446606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104292',2069966,'1727','237',105044.63,105044.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104292',2069967,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104292',2069968,'1729','238',233470.56,237741.96,4271.40,961065.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104292',2069969,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104292',2069970,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104294',2069976,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104294',2069977,'1714','237',682758.33,684322.99,1564.66,219052.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','104294',2069978,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104294',2069979,'1716','237',720791.14,722152.60,1361.46,190604.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104294',2069980,'1717','237',159091.29,161205.41,2114.12,295976.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','104294',2069981,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104294',2069982,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104294',2069983,'1720','237',582042.16,584164.08,2121.92,297068.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104294',2069984,'1721','237',53115.32,53115.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104294',2069985,'1722','237',257854.00,257854.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104294',2069986,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104294',2069987,'1724','237',274243.05,274943.45,700.40,98056.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104294',2069988,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104294',2069989,'1726','237',446606.74,446606.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104294',2069990,'1727','237',105044.63,105044.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104294',2069991,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104294',2069992,'1729','238',237741.96,248007.55,10265.59,2309757.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','104294',2069993,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104294',2069994,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104297',2070027,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104297',2070028,'1714','237',684322.99,685644.70,1321.71,185039.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','104297',2070029,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104297',2070030,'1716','237',722152.60,724377.95,2225.35,311549.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104297',2070031,'1717','237',161205.41,161404.65,199.24,27893.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104297',2070032,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104297',2070033,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104297',2070034,'1720','237',584164.08,584512.85,348.77,48827.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104297',2070035,'1721','237',53115.32,53115.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104297',2070036,'1722','237',257854.00,259133.50,1279.50,179130.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104297',2070037,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104297',2070038,'1724','237',274943.45,274943.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104297',2070039,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104297',2070040,'1726','237',446606.74,446807.34,200.60,28084.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104297',2070041,'1727','237',105044.63,105539.45,494.82,69274.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','104297',2070042,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104297',2070043,'1729','238',248007.55,248175.99,168.44,37899.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104297',2070044,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104297',2070045,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104298',2070046,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104298',2070047,'1714','237',685644.70,686921.19,1276.49,178708.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','104298',2070048,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104298',2070049,'1716','237',724377.95,725602.81,1224.86,171480.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104298',2070050,'1717','237',161404.65,163538.04,2133.39,298674.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104298',2070051,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104298',2070052,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104298',2070053,'1720','237',584512.85,584512.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104298',2070054,'1721','237',53115.32,53971.61,856.29,119880.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104298',2070055,'1722','237',259133.50,259578.03,444.53,62234.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','104298',2070056,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104298',2070057,'1724','237',274943.45,276779.46,1836.01,257041.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104298',2070058,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104298',2070059,'1726','237',446807.34,446807.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104298',2070060,'1727','237',105539.45,105539.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104298',2070061,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104298',2070062,'1729','238',248175.99,248787.83,611.84,137664.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104298',2070063,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104298',2070064,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104302',2070171,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104302',2070172,'1714','237',686921.19,687839.86,918.67,128613.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','104302',2070173,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104302',2070174,'1716','237',725602.81,727362.12,1759.31,246303.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104302',2070175,'1717','237',163538.04,165737.70,2199.66,307952.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104302',2070176,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104302',2070177,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104302',2070178,'1720','237',584512.85,584512.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104302',2070179,'1721','237',53971.61,53971.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104302',2070180,'1722','237',259578.03,260586.81,1008.78,141229.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','104302',2070181,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104302',2070182,'1724','237',276779.46,278021.01,1241.55,173817.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104302',2070183,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104302',2070184,'1726','237',446807.34,447601.38,794.04,111165.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','104302',2070185,'1727','237',105539.45,105539.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104302',2070186,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104302',2070187,'1729','238',248787.83,253873.32,5085.49,1144235.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','104302',2070188,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104302',2070189,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104311',2070388,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104311',2070389,'1714','237',687839.86,689526.01,1686.15,236061.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104311',2070390,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104311',2070391,'1716','237',727362.12,729118.67,1756.55,245917.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104311',2070392,'1717','237',165737.70,167758.45,2020.75,282905.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104311',2070393,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104311',2070394,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104311',2070395,'1720','237',584512.85,584512.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104311',2070396,'1721','237',53971.61,54652.46,680.85,95319.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104311',2070397,'1722','237',260586.81,261646.06,1059.25,148295.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104311',2070398,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104311',2070399,'1724','237',278021.01,279128.15,1107.14,154999.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104311',2070400,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104311',2070401,'1726','237',447601.38,447601.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104311',2070402,'1727','237',105539.45,105539.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104311',2070403,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104311',2070404,'1729','238',253873.32,254135.44,262.12,58977.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104311',2070405,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104311',2070406,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104312',2070407,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104312',2070408,'1714','237',689526.01,691256.11,1730.10,242214.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104312',2070409,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104312',2070410,'1716','237',729118.67,730796.15,1677.48,234847.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104312',2070411,'1717','237',167758.45,170539.03,2780.58,389281.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104312',2070412,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104312',2070413,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104312',2070414,'1720','237',584512.85,584512.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104312',2070415,'1721','237',54652.46,54652.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104312',2070416,'1722','237',261646.06,262336.16,690.10,96614.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104312',2070417,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104312',2070418,'1724','237',279128.15,279774.94,646.79,90550.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104312',2070419,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104312',2070420,'1726','237',447601.38,448996.10,1394.72,195260.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','104312',2070421,'1727','237',105539.45,105539.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104312',2070422,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104312',2070423,'1729','238',254135.44,254339.35,203.91,45879.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','104312',2070424,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104312',2070425,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104313',2070426,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104313',2070427,'1714','237',691256.11,693662.94,2406.83,336956.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','104313',2070428,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104313',2070429,'1716','237',730796.15,730796.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104313',2070430,'1717','237',170539.03,173533.41,2994.38,419213.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104313',2070431,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104313',2070432,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104313',2070433,'1720','237',584512.85,584512.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104313',2070434,'1721','237',54652.46,55336.98,684.52,95832.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104313',2070435,'1722','237',262336.16,263319.16,983.00,137620.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104313',2070436,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104313',2070437,'1724','237',279774.94,279774.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104313',2070438,'1725','237',121058.98,121058.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104313',2070439,'1726','237',448996.10,448996.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104313',2070440,'1727','237',105539.45,105539.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104313',2070441,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104313',2070442,'1729','238',254339.35,254616.77,277.42,62419.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','104313',2070443,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104313',2070444,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104804',2080406,'1713','237',110010.81,110010.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104804',2080407,'1714','237',693662.94,695331.01,1668.07,233529.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','104804',2080408,'1715','237',175195.89,175195.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104804',2080409,'1716','237',731577.54,733626.46,2048.92,286848.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','104804',2080410,'1717','237',173533.41,175650.04,2116.63,296328.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104804',2080411,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104804',2080412,'1719','237',175043.06,175043.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104804',2080413,'1720','237',584512.85,584512.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104804',2080414,'1721','237',55336.98,55664.67,327.69,45876.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104804',2080415,'1722','237',263319.16,263939.41,620.25,86835.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104804',2080416,'1723','237',247544.21,247544.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104804',2080417,'1724','237',279774.94,279774.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104804',2080418,'1725','237',122345.09,122910.12,565.03,79104.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','104804',2080419,'1726','237',449604.14,450099.02,494.88,69283.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','104804',2080420,'1727','237',105539.45,105539.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104804',2080421,'1728','237',199304.85,199304.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104804',2080422,'1729','238',254616.77,255201.98,585.21,131672.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','104804',2080423,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104804',2080424,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104813',2080601,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104813',2080602,'1714','237',695331.01,695436.96,105.95,14833.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104813',2080603,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104813',2080604,'1716','237',733626.46,733652.53,26.07,3649.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','104813',2080605,'1717','237',175650.04,178438.17,2788.13,390338.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104813',2080606,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104813',2080607,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104813',2080608,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104813',2080609,'1721','237',55664.67,56798.86,1134.19,158786.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104813',2080610,'1722','237',263939.41,264944.97,1005.56,140778.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104813',2080611,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104813',2080612,'1724','237',280070.01,281590.46,1520.45,212863.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104813',2080613,'1725','237',122910.12,122910.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104813',2080614,'1726','237',450099.02,450099.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104813',2080615,'1727','237',105539.45,106745.92,1206.47,168905.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','104813',2080616,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104813',2080617,'1729','238',255201.98,260534.49,5332.51,1199814.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','104813',2080618,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104813',2080619,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104906',2082533,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104906',2082534,'1714','237',695436.96,695436.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104906',2082535,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104906',2082536,'1716','237',733652.53,734484.13,831.60,116424.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104906',2082537,'1717','237',178438.17,179861.61,1423.44,199281.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104906',2082538,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104906',2082539,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104906',2082540,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104906',2082541,'1721','237',56798.86,57137.72,338.86,47440.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104906',2082542,'1722','237',264944.97,265382.45,437.48,61247.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','104906',2082543,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104906',2082544,'1724','237',281590.46,282320.40,729.94,102191.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104906',2082545,'1725','237',122910.12,122910.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104906',2082546,'1726','237',450099.02,450099.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104906',2082547,'1727','237',106745.92,107053.29,307.37,43031.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','104906',2082548,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104906',2082549,'1729','238',260534.49,260609.62,75.13,16904.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','104906',2082550,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104906',2082551,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104924',2083048,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104924',2083049,'1714','237',695436.96,696585.69,1148.73,160822.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','104924',2083050,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104924',2083051,'1716','237',734484.13,735506.89,1022.76,143186.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104924',2083052,'1717','237',179861.61,181216.11,1354.50,189630.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104924',2083053,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104924',2083054,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104924',2083055,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104924',2083056,'1721','237',57137.72,57137.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104924',2083057,'1722','237',265382.45,265382.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104924',2083058,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104924',2083059,'1724','237',282320.40,283324.01,1003.61,140505.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104924',2083060,'1725','237',122910.12,122910.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104924',2083061,'1726','237',450099.02,450099.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104924',2083062,'1727','237',107053.29,107053.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104924',2083063,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104924',2083064,'1729','238',260609.62,260705.93,96.31,21669.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','104924',2083065,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104924',2083066,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104926',2083095,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104926',2083096,'1714','237',696585.69,697401.02,815.33,114146.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','104926',2083097,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104926',2083098,'1716','237',735506.89,736078.47,571.58,80021.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104926',2083099,'1717','237',181216.11,182351.63,1135.52,158972.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','104926',2083100,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104926',2083101,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104926',2083102,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104926',2083103,'1721','237',57137.72,57374.39,236.67,33133.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104926',2083104,'1722','237',265382.45,265382.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104926',2083105,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104926',2083106,'1724','237',283324.01,283708.22,384.21,53789.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104926',2083107,'1725','237',122910.12,122910.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104926',2083108,'1726','237',450099.02,450099.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104926',2083109,'1727','237',107053.29,107292.22,238.93,33450.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','104926',2083110,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104926',2083111,'1729','238',260705.93,260737.81,31.88,7173.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104926',2083112,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104926',2083113,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104927',2083114,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104927',2083115,'1714','237',697401.02,698413.18,1012.16,141702.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','104927',2083116,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104927',2083117,'1716','237',736078.47,736738.30,659.83,92376.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','104927',2083118,'1717','237',182351.63,183622.73,1271.10,177954.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104927',2083119,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104927',2083120,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104927',2083121,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104927',2083122,'1721','237',57374.39,57699.70,325.31,45543.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104927',2083123,'1722','237',265382.45,266092.49,710.04,99405.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','104927',2083124,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104927',2083125,'1724','237',283708.22,284619.59,911.37,127591.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104927',2083126,'1725','237',122910.12,122910.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104927',2083127,'1726','237',450099.02,450099.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104927',2083128,'1727','237',107292.22,107292.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104927',2083129,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104927',2083130,'1729','238',260737.81,260791.23,53.42,12019.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','104927',2083131,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104927',2083132,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104928',2083133,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104928',2083134,'1714','237',698413.18,698959.61,546.43,76500.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','104928',2083135,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104928',2083136,'1716','237',736738.30,737771.45,1033.15,144641.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104928',2083137,'1717','237',183622.73,184740.57,1117.84,156497.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104928',2083138,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104928',2083139,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104928',2083140,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104928',2083141,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104928',2083142,'1722','237',266092.49,266347.45,254.96,35694.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104928',2083143,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104928',2083144,'1724','237',284619.59,285088.96,469.37,65711.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104928',2083145,'1725','237',122910.12,122910.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104928',2083146,'1726','237',450099.02,450366.16,267.14,37399.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','104928',2083147,'1727','237',107292.22,107292.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104928',2083148,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104928',2083149,'1729','238',260791.23,260963.77,172.54,38821.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','104928',2083150,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104928',2083151,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104937',2083353,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104937',2083354,'1714','237',698959.61,699790.37,830.76,116306.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','104937',2083355,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104937',2083356,'1716','237',737771.45,738351.96,580.51,81271.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104937',2083357,'1717','237',184740.57,185370.06,629.49,88128.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','104937',2083358,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104937',2083359,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104937',2083360,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104937',2083361,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104937',2083362,'1722','237',266347.45,267273.91,926.46,129704.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','104937',2083363,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104937',2083364,'1724','237',285088.96,285862.33,773.37,108271.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','104937',2083365,'1725','237',122910.12,122910.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104937',2083366,'1726','237',450366.16,450787.86,421.70,59038.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104937',2083367,'1727','237',107292.22,107361.45,69.23,9692.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','104937',2083368,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104937',2083369,'1729','238',260963.77,265239.29,4275.52,961992.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104937',2083370,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104937',2083371,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104950',2083651,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104950',2083652,'1714','237',699790.37,700555.56,765.19,107126.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','104950',2083653,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','104950',2083654,'1716','237',738351.96,738986.43,634.47,88825.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','104950',2083655,'1717','237',185370.06,186657.57,1287.51,180251.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','104950',2083656,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104950',2083657,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','104950',2083658,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104950',2083659,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104950',2083660,'1722','237',267273.91,267449.26,175.35,24549.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104950',2083661,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104950',2083662,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','104950',2083663,'1725','237',122910.12,122910.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104950',2083664,'1726','237',450787.86,451151.05,363.19,50846.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','104950',2083665,'1727','237',107361.45,107361.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','104950',2083666,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','104950',2083667,'1729','238',265239.29,265692.90,453.61,102062.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','104950',2083668,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','104950',2083669,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105002',2084536,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105002',2084537,'1714','237',700555.56,701334.63,779.07,109069.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','105002',2084538,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105002',2084539,'1716','237',738986.43,739916.79,930.36,130250.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','105002',2084540,'1717','237',186657.57,188252.19,1594.62,223246.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','105002',2084541,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105002',2084542,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105002',2084543,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105002',2084544,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105002',2084545,'1722','237',267449.26,268021.32,572.06,80088.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','105002',2084546,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105002',2084547,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105002',2084548,'1725','237',122910.12,124393.47,1483.35,207669.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105002',2084549,'1726','237',451151.05,451562.81,411.76,57646.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','105002',2084550,'1727','237',107361.45,107662.81,301.36,42190.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','105002',2084551,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105002',2084552,'1729','238',265692.90,265739.76,46.86,10543.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','105002',2084553,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105002',2084554,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105040',2085486,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105040',2085487,'1714','237',701334.63,702095.39,760.76,106506.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','105040',2085488,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105040',2085489,'1716','237',739916.79,740336.83,420.04,58805.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','105040',2085490,'1717','237',188252.19,189886.23,1634.04,228765.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','105040',2085491,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105040',2085492,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105040',2085493,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105040',2085494,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105040',2085495,'1722','237',268021.32,268489.78,468.46,65584.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','105040',2085496,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105040',2085497,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105040',2085498,'1725','237',124393.47,125681.58,1288.11,180335.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','105040',2085499,'1726','237',451562.81,452269.34,706.53,98914.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','105040',2085500,'1727','237',107662.81,107912.45,249.64,34949.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','105040',2085501,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105040',2085502,'1729','238',265739.76,265834.81,95.05,21386.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','105040',2085503,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105040',2085504,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105449',2093371,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105449',2093372,'1714','237',702095.39,703022.74,927.35,129829.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105449',2093373,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105449',2093374,'1716','237',740336.83,741234.07,897.24,125613.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','105449',2093375,'1717','237',189886.23,191134.78,1248.55,174797.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105449',2093376,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105449',2093377,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105449',2093378,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105449',2093379,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105449',2093380,'1722','237',268489.78,268489.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105449',2093381,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105449',2093382,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105449',2093383,'1725','237',125681.58,126304.85,623.27,87257.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','105449',2093384,'1726','237',452269.34,452627.70,358.36,50170.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','105449',2093385,'1727','237',107912.45,107912.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105449',2093386,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105449',2093387,'1729','238',265834.81,265897.96,63.15,14208.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','105449',2093388,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105449',2093389,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105501',2094338,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105501',2094339,'1714','237',703022.39,703746.46,724.07,101369.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','105501',2094340,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105501',2094341,'1716','237',741234.07,742487.94,1253.87,175541.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','105501',2094342,'1717','237',191134.78,191898.94,764.16,106982.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','105501',2094343,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105501',2094344,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105501',2094345,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105501',2094346,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105501',2094347,'1722','237',268489.78,269049.83,560.05,78407.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105501',2094348,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105501',2094349,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105501',2094350,'1725','237',126304.85,127142.87,838.02,117322.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','105501',2094351,'1726','237',452627.70,452627.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105501',2094352,'1727','237',107912.45,107912.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105501',2094353,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105501',2094354,'1729','238',265897.96,266107.04,209.08,47043.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105501',2094355,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105501',2094356,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105505',2094406,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105505',2094407,'1714','237',703746.46,704465.02,718.56,100598.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','105505',2094408,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105505',2094409,'1716','237',742487.94,743265.62,777.68,108875.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','105505',2094410,'1717','237',191898.94,193119.15,1220.21,170829.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','105505',2094411,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105505',2094412,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105505',2094413,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105505',2094414,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105505',2094415,'1722','237',269049.83,269595.12,545.29,76340.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','105505',2094416,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105505',2094417,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105505',2094418,'1725','237',127142.87,127952.85,809.98,113397.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','105505',2094419,'1726','237',452627.70,453128.52,500.82,70114.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','105505',2094420,'1727','237',107912.45,107912.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105505',2094421,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105505',2094422,'1729','238',266107.04,266393.44,286.40,64440.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105505',2094423,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105505',2094424,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105561',2095554,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105561',2095555,'1714','237',704465.02,705295.13,830.11,116215.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','105561',2095556,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105561',2095557,'1716','237',743265.62,744298.39,1032.77,144587.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','105561',2095558,'1717','237',193119.15,194408.17,1289.02,180462.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','105561',2095559,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105561',2095560,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105561',2095561,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105561',2095562,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105561',2095563,'1722','237',269595.12,270097.94,502.82,70394.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','105561',2095564,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105561',2095565,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105561',2095566,'1725','237',127952.85,128596.84,643.99,90158.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','105561',2095567,'1726','237',453128.52,453407.80,279.28,39099.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','105561',2095568,'1727','237',107912.45,107912.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105561',2095569,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105561',2095570,'1729','238',266393.44,266542.52,149.08,33543.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105561',2095571,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105561',2095572,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105562',2095573,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105562',2095574,'1714','237',705295.13,706025.22,730.09,102212.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','105562',2095575,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105562',2095576,'1716','237',744298.39,745017.71,719.32,100704.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','105562',2095577,'1717','237',194408.17,195390.12,981.95,137473.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105562',2095578,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105562',2095579,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105562',2095580,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105562',2095581,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105562',2095582,'1722','237',270097.94,270339.51,241.57,33819.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','105562',2095583,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105562',2095584,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105562',2095585,'1725','237',128596.84,129333.07,736.23,103072.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','105562',2095586,'1726','237',453407.80,453407.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105562',2095587,'1727','237',107912.45,107912.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105562',2095588,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105562',2095589,'1729','238',266542.52,266562.51,19.99,4497.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','105562',2095590,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105562',2095591,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105563',2095592,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105563',2095593,'1714','237',706025.22,707176.86,1151.64,161229.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','105563',2095594,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105563',2095595,'1716','237',745017.71,746142.96,1125.25,157535.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105563',2095596,'1717','237',195390.12,195491.29,101.17,14163.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','105563',2095597,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105563',2095598,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105563',2095599,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105563',2095600,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105563',2095601,'1722','237',270339.51,271221.22,881.71,123439.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','105563',2095602,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105563',2095603,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105563',2095604,'1725','237',129333.07,130119.51,786.44,110101.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','105563',2095605,'1726','237',453407.80,453407.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105563',2095606,'1727','237',107912.45,108362.69,450.24,63033.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','105563',2095607,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105563',2095608,'1729','238',266562.51,266654.52,92.01,20702.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','105563',2095609,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105563',2095610,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105564',2095611,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105564',2095612,'1714','237',707176.86,707973.73,796.87,111561.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','105564',2095613,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105564',2095614,'1716','237',746142.96,747251.91,1108.95,155253.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105564',2095615,'1717','237',195491.29,195491.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105564',2095616,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105564',2095617,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105564',2095618,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105564',2095619,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105564',2095620,'1722','237',271221.22,271750.64,529.42,74118.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','105564',2095621,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105564',2095622,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105564',2095623,'1725','237',130119.51,131031.23,911.72,127640.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','105564',2095624,'1726','237',453407.80,453610.17,202.37,28331.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','105564',2095625,'1727','237',108362.69,108585.93,223.24,31253.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','105564',2095626,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105564',2095627,'1729','238',266654.52,271905.00,5250.48,1181358.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105564',2095628,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105564',2095629,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105565',2095630,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105565',2095631,'1714','237',707973.73,709043.93,1070.20,149828.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105565',2095632,'1715','237',175203.69,175203.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105565',2095633,'1716','237',747251.91,747795.19,543.28,76059.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','105565',2095634,'1717','237',195491.29,195491.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105565',2095635,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105565',2095636,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105565',2095637,'1720','237',585408.48,585408.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105565',2095638,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105565',2095639,'1722','237',271750.64,272456.91,706.27,98877.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','105565',2095640,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105565',2095641,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105565',2095642,'1725','237',131031.23,132233.67,1202.44,168341.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','105565',2095643,'1726','237',453610.17,453770.51,160.34,22447.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','105565',2095644,'1727','237',108585.93,109080.87,494.94,69291.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','105565',2095645,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105565',2095646,'1729','238',271905.00,271966.95,61.95,13938.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','105565',2095647,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105565',2095648,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105589',2096139,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105589',2096140,'1714','237',709043.93,710183.05,1139.12,159476.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','105589',2096141,'1715','237',175203.69,175206.44,2.75,385.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105589',2096142,'1716','237',747795.19,747942.25,147.06,20588.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','105589',2096143,'1717','237',195491.29,195491.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105589',2096144,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105589',2096145,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105589',2096146,'1720','237',585408.48,586435.04,1026.56,143718.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','105589',2096147,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105589',2096148,'1722','237',272456.91,273264.37,807.46,113044.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','105589',2096149,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105589',2096150,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105589',2096151,'1725','237',132233.67,133030.24,796.57,111519.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','105589',2096152,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105589',2096153,'1727','237',109080.87,109080.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105589',2096154,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105589',2096155,'1729','238',271966.95,272107.34,140.39,31587.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','105589',2096156,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105589',2096157,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105737',2098702,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105737',2098703,'1714','237',710183.05,710748.50,565.45,79163.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105737',2098704,'1715','237',175206.44,175910.67,704.23,98592.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','105737',2098705,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105737',2098706,'1717','237',195491.29,196317.94,826.65,115731.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105737',2098707,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105737',2098708,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105737',2098709,'1720','237',586435.04,586974.57,539.53,75534.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','105737',2098710,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105737',2098711,'1722','237',273264.37,273660.19,395.82,55414.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','105737',2098712,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105737',2098713,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105737',2098714,'1725','237',133030.24,133030.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105737',2098715,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105737',2098716,'1727','237',109080.87,109080.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105737',2098717,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105737',2098718,'1729','238',272107.34,272180.09,72.75,16368.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','105737',2098719,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105737',2098720,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105738',2098721,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105738',2098722,'1714','237',710748.50,710748.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105738',2098723,'1715','237',175910.67,177102.15,1191.48,166807.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','105738',2098724,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105738',2098725,'1717','237',196317.94,197277.22,959.28,134299.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','105738',2098726,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105738',2098727,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105738',2098728,'1720','237',586974.57,587940.70,966.13,135258.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','105738',2098729,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105738',2098730,'1722','237',273660.19,273660.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105738',2098731,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105738',2098732,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105738',2098733,'1725','237',133030.24,133775.76,745.52,104372.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','105738',2098734,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105738',2098735,'1727','237',109080.87,109080.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105738',2098736,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105738',2098737,'1729','238',272180.09,272213.96,33.87,7620.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','105738',2098738,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105738',2098739,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105927',2102499,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105927',2102500,'1714','237',710748.50,711527.35,778.85,109039.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','105927',2102501,'1715','237',177102.15,178132.58,1030.43,144260.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','105927',2102502,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105927',2102503,'1717','237',197277.22,198638.30,1361.08,190551.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','105927',2102504,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105927',2102505,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','105927',2102506,'1720','237',587940.70,590385.65,2444.95,342293.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105927',2102507,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105927',2102508,'1722','237',273660.19,274889.49,1229.30,172102.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105927',2102509,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105927',2102510,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','105927',2102511,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105927',2102512,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105927',2102513,'1727','237',109080.87,109614.77,533.90,74746.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','105927',2102514,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105927',2102515,'1729','238',272213.96,279341.40,7127.44,1603674.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','105927',2102516,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','105927',2102517,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106104',2105956,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106104',2105957,'1714','237',711527.35,712566.90,1039.55,145537.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106104',2105958,'1715','237',178132.58,179143.97,1011.39,141594.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','106104',2105959,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106104',2105960,'1717','237',198638.30,199752.69,1114.39,156014.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','106104',2105961,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106104',2105962,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106104',2105963,'1720','237',590385.65,591442.08,1056.43,147900.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','106104',2105964,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106104',2105965,'1722','237',274889.49,275462.01,572.52,80152.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106104',2105966,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106104',2105967,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106104',2105968,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106104',2105969,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106104',2105970,'1727','237',109614.77,109614.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106104',2105971,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106104',2105972,'1729','238',279341.40,279418.38,76.98,17320.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','106104',2105973,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106104',2105974,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106105',2105975,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106105',2105976,'1714','237',712566.90,713886.13,1319.23,184692.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','106105',2105977,'1715','237',179143.97,180169.11,1025.14,143519.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','106105',2105978,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106105',2105979,'1717','237',199752.69,200367.43,614.74,86063.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','106105',2105980,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106105',2105981,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106105',2105982,'1720','237',591442.08,592850.94,1408.86,197240.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','106105',2105983,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106105',2105984,'1722','237',275462.01,275462.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106105',2105985,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106105',2105986,'1724','237',285862.33,285862.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106105',2105987,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106105',2105988,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106105',2105989,'1727','237',109614.77,109614.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106105',2105990,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106105',2105991,'1729','238',279418.38,279555.38,137.00,30825.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106105',2105992,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106105',2105993,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106106',2105994,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106106',2105995,'1714','237',713886.13,714651.47,765.34,107147.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','106106',2105996,'1715','237',180169.11,181254.71,1085.60,151984.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106106',2105997,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106106',2105998,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106106',2105999,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106106',2106000,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106106',2106001,'1720','237',592850.94,594358.67,1507.73,211082.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','106106',2106002,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106106',2106003,'1722','237',275462.01,275462.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106106',2106004,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106106',2106005,'1724','237',285862.33,287007.75,1145.42,160358.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106106',2106006,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106106',2106007,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106106',2106008,'1727','237',109614.77,109614.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106106',2106009,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106106',2106010,'1729','238',279555.38,279623.91,68.53,15419.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','106106',2106011,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106106',2106012,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106112',2106113,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106112',2106114,'1714','237',714651.47,714996.93,345.46,48364.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','106112',2106115,'1715','237',181254.71,182490.19,1235.48,172967.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','106112',2106116,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106112',2106117,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106112',2106118,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106112',2106119,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106112',2106120,'1720','237',594358.67,595596.00,1237.33,173226.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','106112',2106121,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106112',2106122,'1722','237',275462.01,275872.46,410.45,57463.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106112',2106123,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106112',2106124,'1724','237',287007.75,287721.26,713.51,99891.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','106112',2106125,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106112',2106126,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106112',2106127,'1727','237',109614.77,110023.49,408.72,57220.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','106112',2106128,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106112',2106129,'1729','238',279623.91,279721.45,97.54,21946.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','106112',2106130,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106112',2106131,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106410',2111685,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106410',2111686,'1714','237',714996.93,715905.76,908.83,127236.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','106410',2111687,'1715','237',182490.19,183533.78,1043.59,146102.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','106410',2111688,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106410',2111689,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106410',2111690,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106410',2111691,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106410',2111692,'1720','237',595596.00,596286.51,690.51,96671.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','106410',2111693,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106410',2111694,'1722','237',275872.46,276461.97,589.51,82531.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','106410',2111695,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106410',2111696,'1724','237',287721.26,288163.61,442.35,61929.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106410',2111697,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106410',2111698,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106410',2111699,'1727','237',110023.49,110175.30,151.81,21253.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','106410',2111700,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106410',2111701,'1729','238',279721.45,279774.77,53.32,11997.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106410',2111702,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106410',2111703,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106411',2111704,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106411',2111705,'1714','237',715905.76,716926.42,1020.66,142892.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','106411',2111706,'1715','237',183533.78,184578.54,1044.76,146266.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','106411',2111707,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106411',2111708,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106411',2111709,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106411',2111710,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106411',2111711,'1720','237',596286.51,597581.00,1294.49,181228.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','106411',2111712,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106411',2111713,'1722','237',276461.97,277025.41,563.44,78881.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','106411',2111714,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106411',2111715,'1724','237',288163.61,288517.38,353.77,49527.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106411',2111716,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106411',2111717,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106411',2111718,'1727','237',110175.30,110175.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106411',2111719,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106411',2111720,'1729','238',279774.77,280158.58,383.81,86357.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','106411',2111721,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106411',2111722,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106412',2111723,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106412',2111724,'1714','237',716926.42,717741.14,814.72,114060.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','106412',2111725,'1715','237',184578.54,185506.76,928.22,129950.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','106412',2111726,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106412',2111727,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106412',2111728,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106412',2111729,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106412',2111730,'1720','237',597581.00,598638.78,1057.78,148089.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','106412',2111731,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106412',2111732,'1722','237',277025.41,277305.59,280.18,39225.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','106412',2111733,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106412',2111734,'1724','237',288517.38,289024.40,507.02,70982.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106412',2111735,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106412',2111736,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106412',2111737,'1727','237',110175.30,110175.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106412',2111738,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106412',2111739,'1729','238',280158.58,280227.77,69.19,15567.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','106412',2111740,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106412',2111741,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106415',2111774,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106415',2111775,'1714','237',717741.14,718598.34,857.20,120008.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106415',2111776,'1715','237',185506.76,186496.91,990.15,138621.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106415',2111777,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106415',2111778,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106415',2111779,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106415',2111780,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106415',2111781,'1720','237',598638.78,599750.06,1111.28,155579.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','106415',2111782,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106415',2111783,'1722','237',277305.59,277615.81,310.22,43430.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106415',2111784,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106415',2111785,'1724','237',289024.40,289688.44,664.04,92965.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','106415',2111786,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106415',2111787,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106415',2111788,'1727','237',110175.30,110437.84,262.54,36755.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','106415',2111789,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106415',2111790,'1729','238',280227.77,280880.63,652.86,146893.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','106415',2111791,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106415',2111792,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106526',2113759,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106526',2113760,'1714','237',718598.34,719633.39,1035.05,144907.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106526',2113761,'1715','237',186496.91,187173.42,676.51,94711.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','106526',2113762,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106526',2113763,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106526',2113764,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106526',2113765,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106526',2113766,'1720','237',599750.06,600252.08,502.02,70282.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106526',2113767,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106526',2113768,'1722','237',277615.81,278098.58,482.77,67587.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106526',2113769,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106526',2113770,'1724','237',289688.44,289956.21,267.77,37487.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106526',2113771,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106526',2113772,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106526',2113773,'1727','237',110437.84,110727.31,289.47,40525.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','106526',2113774,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106526',2113775,'1729','238',280880.63,280911.06,30.43,6846.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','106526',2113776,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106526',2113777,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106571',2114715,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106571',2114716,'1714','237',719633.39,720659.36,1025.97,143635.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','106571',2114717,'1715','237',187173.42,188373.87,1200.45,168063.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106571',2114718,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106571',2114719,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106571',2114720,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106571',2114721,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106571',2114722,'1720','237',600252.08,601101.95,849.87,118981.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106571',2114723,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106571',2114724,'1722','237',278098.58,278842.84,744.26,104196.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','106571',2114725,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106571',2114726,'1724','237',289956.21,290820.86,864.65,121051.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106571',2114727,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106571',2114728,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106571',2114729,'1727','237',110727.31,110727.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106571',2114730,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106571',2114731,'1729','238',280911.06,281063.94,152.88,34398.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106571',2114732,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106571',2114733,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106725',2117625,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106725',2117626,'1714','237',720659.36,721167.21,507.85,71099.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106725',2117627,'1715','237',188373.87,189460.29,1086.42,152098.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','106725',2117628,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106725',2117629,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106725',2117630,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106725',2117631,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106725',2117632,'1720','237',601101.95,601613.79,511.84,71657.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','106725',2117633,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106725',2117634,'1722','237',278842.84,278982.18,139.34,19507.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','106725',2117635,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106725',2117636,'1724','237',290820.86,291186.43,365.57,51179.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','106725',2117637,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106725',2117638,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106725',2117639,'1727','237',110727.31,110727.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106725',2117640,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106725',2117641,'1729','238',281063.94,281068.94,5.00,1125.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106725',2117642,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106725',2117643,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106726',2117644,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','106726',2117645,'1714','237',721167.21,722121.05,953.84,133537.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','106726',2117646,'1715','237',189460.29,189919.41,459.12,64276.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','106726',2117647,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106726',2117648,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106726',2117649,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106726',2117650,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','106726',2117651,'1720','237',601613.79,602462.04,848.25,118755.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106726',2117652,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106726',2117653,'1722','237',278982.18,279243.79,261.61,36625.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','106726',2117654,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','106726',2117655,'1724','237',291186.43,291648.57,462.14,64699.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','106726',2117656,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106726',2117657,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','106726',2117658,'1727','237',110727.31,110967.10,239.79,33570.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','106726',2117659,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106726',2117660,'1729','238',281068.94,281342.34,273.40,61515.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','106726',2117661,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','106726',2117662,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107269',2128311,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107269',2128312,'1714','237',722121.05,722524.72,403.67,56513.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','107269',2128313,'1715','237',189919.41,191210.81,1291.40,180796.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107269',2128314,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107269',2128315,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107269',2128316,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107269',2128317,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107269',2128318,'1720','237',602462.04,602945.17,483.13,67638.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107269',2128319,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107269',2128320,'1722','237',279243.79,279806.80,563.01,78821.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','107269',2128321,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107269',2128322,'1724','237',291648.57,292238.41,589.84,82577.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','107269',2128323,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107269',2128324,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107269',2128325,'1727','237',110967.10,111365.57,398.47,55785.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','107269',2128326,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','107269',2128327,'1729','238',281342.34,281474.03,131.69,29630.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','107269',2128328,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','107269',2128329,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107271',2128364,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107271',2128365,'1714','237',722524.72,723142.37,617.65,86471.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107271',2128366,'1715','237',191210.81,192501.93,1291.12,180756.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','107271',2128367,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107271',2128368,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107271',2128369,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107271',2128370,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107271',2128371,'1720','237',602945.17,604042.50,1097.33,153626.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107271',2128372,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107271',2128373,'1722','237',279806.80,280237.72,430.92,60328.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','107271',2128374,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107271',2128375,'1724','237',292238.41,292238.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107271',2128376,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107271',2128377,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107271',2128378,'1727','237',111365.57,111799.32,433.75,60725.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107271',2128379,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','107271',2128380,'1729','238',281474.03,281494.58,20.55,4623.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','107271',2128381,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','107271',2128382,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107272',2128383,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107272',2128384,'1714','237',723142.37,724061.17,918.80,128632.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107272',2128385,'1715','237',192501.93,193737.67,1235.74,173003.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','107272',2128386,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107272',2128387,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107272',2128388,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107272',2128389,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107272',2128390,'1720','237',604042.50,605369.48,1326.98,185777.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107272',2128391,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107272',2128392,'1722','237',280237.72,280544.30,306.58,42921.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107272',2128393,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107272',2128394,'1724','237',292238.41,292722.55,484.14,67779.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','107272',2128395,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107272',2128396,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107272',2128397,'1727','237',111799.32,112060.35,261.03,36544.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','107272',2128398,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','107272',2128399,'1729','238',281494.58,281559.00,64.42,14494.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','107272',2128400,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','107272',2128401,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107274',2128407,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107274',2128408,'1714','237',724061.17,725165.28,1104.11,154575.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','107274',2128409,'1715','237',193737.67,195016.59,1278.92,179048.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','107274',2128410,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107274',2128411,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107274',2128412,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107274',2128413,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107274',2128414,'1720','237',605369.48,606623.76,1254.28,175599.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107274',2128415,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107274',2128416,'1722','237',280544.30,280628.13,83.83,11736.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107274',2128417,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107274',2128418,'1724','237',292722.55,293301.91,579.36,81110.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','107274',2128419,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107274',2128420,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107274',2128421,'1727','237',112060.35,112060.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107274',2128422,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','107274',2128423,'1729','238',281559.00,281712.27,153.27,34485.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','107274',2128424,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','107274',2128425,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107427',2131361,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107427',2131362,'1714','237',725165.28,725405.29,240.01,33601.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','107427',2131363,'1715','237',195016.59,196426.72,1410.13,197418.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','107427',2131364,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107427',2131365,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107427',2131366,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107427',2131367,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107427',2131368,'1720','237',606623.76,607791.85,1168.09,163532.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','107427',2131369,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107427',2131370,'1722','237',280628.13,281071.60,443.47,62085.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','107427',2131371,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107427',2131372,'1724','237',293301.91,293301.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107427',2131373,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107427',2131374,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107427',2131375,'1727','237',112060.35,112158.11,97.76,13686.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','107427',2131376,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','107427',2131377,'1729','238',281712.27,281809.00,96.73,21764.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','107427',2131378,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','107427',2131379,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107429',2131402,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107429',2131403,'1714','237',725405.29,726344.82,939.53,131534.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','107429',2131404,'1715','237',196426.72,197590.38,1163.66,162912.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','107429',2131405,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107429',2131406,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107429',2131407,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107429',2131408,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107429',2131409,'1720','237',607791.85,608918.18,1126.33,157686.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107429',2131410,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107429',2131411,'1722','237',281071.60,281612.79,541.19,75766.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','107429',2131412,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107429',2131413,'1724','237',293301.91,293864.24,562.33,78726.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107429',2131414,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107429',2131415,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107429',2131416,'1727','237',112158.11,112434.89,276.78,38749.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','107429',2131417,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','107429',2131418,'1729','238',281809.00,282028.03,219.03,49281.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','107429',2131419,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','107429',2131420,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107433',2131496,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107433',2131497,'1714','237',726344.82,726577.32,232.50,32550.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107433',2131498,'1715','237',197590.38,198718.19,1127.81,157893.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','107433',2131499,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107433',2131500,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107433',2131501,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107433',2131502,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107433',2131503,'1720','237',608918.18,610063.09,1144.91,160287.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','107433',2131504,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107433',2131505,'1722','237',281612.79,281808.58,195.79,27410.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','107433',2131506,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107433',2131507,'1724','237',293864.24,294221.65,357.41,50037.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','107433',2131508,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107433',2131509,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107433',2131510,'1727','237',112434.89,112595.56,160.67,22493.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','107433',2131511,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','107433',2131512,'1729','238',282028.03,282197.08,169.05,38036.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','107433',2131513,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','107433',2131514,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107435',2131537,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107435',2131538,'1714','237',726577.32,727220.87,643.55,90097.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','107435',2131539,'1715','237',198718.19,199797.90,1079.71,151159.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','107435',2131540,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107435',2131541,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107435',2131542,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107435',2131543,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','107435',2131544,'1720','237',610063.09,610796.77,733.68,102715.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107435',2131545,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107435',2131546,'1722','237',281808.58,282064.61,256.03,35844.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','107435',2131547,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','107435',2131548,'1724','237',294221.65,294785.69,564.04,78965.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','107435',2131549,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107435',2131550,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','107435',2131551,'1727','237',112595.56,112833.24,237.68,33275.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','107435',2131552,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','107435',2131553,'1729','238',282197.08,282318.59,121.51,27339.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','107435',2131554,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','107435',2131555,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108643',2154678,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108643',2154679,'1714','237',727220.87,727811.33,590.46,82664.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','108643',2154680,'1715','237',199797.90,200735.16,937.26,131216.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','108643',2154681,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108643',2154682,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108643',2154683,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108643',2154684,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108643',2154685,'1720','237',610796.77,611372.75,575.98,80637.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','108643',2154686,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108643',2154687,'1722','237',282064.61,282372.48,307.87,43101.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','108643',2154688,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108643',2154689,'1724','237',294785.69,294977.50,191.81,26853.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','108643',2154690,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108643',2154691,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108643',2154692,'1727','237',112833.24,113025.26,192.02,26882.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','108643',2154693,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108643',2154694,'1729','238',282318.59,282395.24,76.65,17246.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','108643',2154695,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108643',2154696,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108645',2154707,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108645',2154708,'1714','237',727811.33,728238.97,427.64,59869.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','108645',2154709,'1715','237',200735.16,200816.55,81.39,11394.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','108645',2154710,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108645',2154711,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108645',2154712,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108645',2154713,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108645',2154714,'1720','237',611372.75,612757.26,1384.51,193831.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','108645',2154715,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108645',2154716,'1722','237',282372.48,282661.87,289.39,40514.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','108645',2154717,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108645',2154718,'1724','237',294977.50,296086.82,1109.32,155304.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','108645',2154719,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108645',2154720,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108645',2154721,'1727','237',113025.26,113576.85,551.59,77222.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','108645',2154722,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108645',2154723,'1729','238',282395.24,282539.54,144.30,32467.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','108645',2154724,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108645',2154725,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108671',2155195,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108671',2155196,'1714','237',728238.97,728238.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108671',2155197,'1715','237',200816.55,200816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108671',2155198,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108671',2155199,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108671',2155200,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108671',2155201,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108671',2155202,'1720','237',612757.26,613942.29,1185.03,165904.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','108671',2155203,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108671',2155204,'1722','237',282661.87,283479.16,817.29,114420.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','108671',2155205,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108671',2155206,'1724','237',296086.82,297026.86,940.04,131605.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','108671',2155207,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108671',2155208,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108671',2155209,'1727','237',113576.85,114182.94,606.09,84852.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','108671',2155210,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108671',2155211,'1729','238',282539.54,282696.62,157.08,35343.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108671',2155212,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108671',2155213,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108679',2155386,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108679',2155387,'1714','237',728238.97,728238.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108679',2155388,'1715','237',200816.55,200816.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108679',2155389,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108679',2155390,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108679',2155391,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108679',2155392,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108679',2155393,'1720','237',613942.29,614931.60,989.31,138503.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','108679',2155394,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108679',2155395,'1722','237',283479.16,284919.97,1440.81,201713.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','108679',2155396,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108679',2155397,'1724','237',297026.86,298316.91,1290.05,180607.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108679',2155398,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108679',2155399,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108679',2155400,'1727','237',114182.94,115174.97,992.03,138884.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','108679',2155401,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108679',2155402,'1729','238',282696.62,282978.35,281.73,63389.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','108679',2155403,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108679',2155404,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108726',2156441,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108726',2156442,'1714','237',728238.97,728964.79,725.82,101614.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','108726',2156443,'1715','237',200816.55,202181.66,1365.11,191115.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','108726',2156444,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108726',2156445,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108726',2156446,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108726',2156447,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108726',2156448,'1720','237',614931.60,615645.16,713.56,99898.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','108726',2156449,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108726',2156450,'1722','237',284919.97,285566.70,646.73,90542.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','108726',2156451,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108726',2156452,'1724','237',298316.91,298793.04,476.13,66658.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','108726',2156453,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108726',2156454,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108726',2156455,'1727','237',115174.97,115488.87,313.90,43946.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108726',2156456,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108726',2156457,'1729','238',282978.35,283042.22,63.87,14370.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','108726',2156458,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108726',2156459,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108966',2161346,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108966',2161347,'1714','237',728964.79,729856.45,891.66,124832.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','108966',2161348,'1715','237',202181.66,203120.04,938.38,131373.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','108966',2161349,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108966',2161350,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108966',2161351,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108966',2161352,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108966',2161353,'1720','237',615645.16,616689.56,1044.40,146216.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108966',2161354,'1721','237',57699.70,57699.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108966',2161355,'1722','237',285566.70,286134.40,567.70,79478.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108966',2161356,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108966',2161357,'1724','237',298793.04,299481.22,688.18,96345.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','108966',2161358,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108966',2161359,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108966',2161360,'1727','237',115488.87,115488.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108966',2161361,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108966',2161362,'1729','238',283042.22,283469.55,427.33,96149.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','108966',2161363,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108966',2161364,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108968',2161375,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108968',2161376,'1714','237',729856.45,730754.72,898.27,125757.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','108968',2161377,'1715','237',203120.04,204126.20,1006.16,140862.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','108968',2161378,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108968',2161379,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108968',2161380,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108968',2161381,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108968',2161382,'1720','237',616689.56,617704.54,1014.98,142097.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','108968',2161383,'1721','237',57699.70,57709.70,10.00,1400.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108968',2161384,'1722','237',286134.40,286535.46,401.06,56148.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','108968',2161385,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108968',2161386,'1724','237',299481.22,300170.66,689.44,96521.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','108968',2161387,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108968',2161388,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108968',2161389,'1727','237',115488.87,115488.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108968',2161390,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108968',2161391,'1729','238',283469.55,283588.85,119.30,26842.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','108968',2161392,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108968',2161393,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108969',2161394,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108969',2161395,'1714','237',730754.72,731595.78,841.06,117748.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','108969',2161396,'1715','237',204126.20,205624.22,1498.02,209722.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','108969',2161397,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108969',2161398,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108969',2161399,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108969',2161400,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108969',2161401,'1720','237',617704.54,619020.21,1315.67,184193.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','108969',2161402,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108969',2161403,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108969',2161404,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108969',2161405,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108969',2161406,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108969',2161407,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108969',2161408,'1727','237',115488.87,116346.78,857.91,120107.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','108969',2161409,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108969',2161410,'1729','238',283588.85,283713.04,124.19,27942.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','108969',2161411,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108969',2161412,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108971',2161436,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108971',2161437,'1714','237',731595.78,732657.86,1062.08,148691.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','108971',2161438,'1715','237',205624.22,206923.36,1299.14,181879.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','108971',2161439,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108971',2161440,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108971',2161441,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108971',2161442,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108971',2161443,'1720','237',619020.21,620553.18,1532.97,214615.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','108971',2161444,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108971',2161445,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108971',2161446,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108971',2161447,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108971',2161448,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108971',2161449,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108971',2161450,'1727','237',116346.78,116951.59,604.81,84673.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','108971',2161451,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108971',2161452,'1729','238',283713.04,283765.59,52.55,11823.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','108971',2161453,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108971',2161454,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108974',2161500,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','108974',2161501,'1714','237',732657.86,733766.03,1108.17,155143.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','108974',2161502,'1715','237',206923.36,208174.62,1251.26,175176.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','108974',2161503,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108974',2161504,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108974',2161505,'1718','237',652443.26,652443.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108974',2161506,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','108974',2161507,'1720','237',620553.18,621834.83,1281.65,179431.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108974',2161508,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108974',2161509,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108974',2161510,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108974',2161511,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','108974',2161512,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108974',2161513,'1726','237',453770.51,453770.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108974',2161514,'1727','237',116951.59,117543.44,591.85,82859.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','108974',2161515,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','108974',2161516,'1729','238',283765.59,284047.76,282.17,63488.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','108974',2161517,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','108974',2161518,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109000',2161989,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109000',2161990,'1714','237',733766.03,734569.48,803.45,112483.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109000',2161991,'1715','237',208174.62,209387.44,1212.82,169794.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109000',2161992,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109000',2161993,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109000',2161994,'1718','237',652443.26,652444.46,1.20,168.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109000',2161995,'1719','237',175043.76,175843.76,800.00,112000.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109000',2161996,'1720','237',621834.83,623327.28,1492.45,208943.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109000',2161997,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109000',2161998,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109000',2161999,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109000',2162000,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109000',2162001,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109000',2162002,'1726','237',458031.87,460053.91,2022.04,283085.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','109000',2162003,'1727','237',117543.44,117543.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109000',2162004,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109000',2162005,'1729','238',284047.76,284417.76,370.00,83250.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109000',2162006,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109000',2162007,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109003',2162029,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109003',2162030,'1714','237',734569.48,735182.08,612.60,85764.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109003',2162031,'1715','237',209387.44,211102.31,1714.87,240081.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109003',2162032,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109003',2162033,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109003',2162034,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109003',2162035,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109003',2162036,'1720','237',623327.28,624626.82,1299.54,181935.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','109003',2162037,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109003',2162038,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109003',2162039,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109003',2162040,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109003',2162041,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109003',2162042,'1726','237',460053.91,460053.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109003',2162043,'1727','237',117543.44,118605.98,1062.54,148755.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','109003',2162044,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109003',2162045,'1729','238',284417.76,284611.05,193.29,43490.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','109003',2162046,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109003',2162047,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109009',2162133,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109009',2162134,'1714','237',735182.08,736334.20,1152.12,161296.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109009',2162135,'1715','237',211102.31,212143.20,1040.89,145724.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','109009',2162136,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109009',2162137,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109009',2162138,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109009',2162139,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109009',2162140,'1720','237',624626.82,625690.13,1063.31,148863.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','109009',2162141,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109009',2162142,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109009',2162143,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109009',2162144,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109009',2162145,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109009',2162146,'1726','237',460053.91,460053.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109009',2162147,'1727','237',118605.98,119126.82,520.84,72917.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','109009',2162148,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109009',2162149,'1729','238',284611.05,284716.61,105.56,23751.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109009',2162150,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109009',2162151,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109013',2162246,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109013',2162247,'1714','237',736334.20,736334.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109013',2162248,'1715','237',212143.20,213462.93,1319.73,184762.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','109013',2162249,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109013',2162250,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109013',2162251,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109013',2162252,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109013',2162253,'1720','237',625690.13,627510.94,1820.81,254913.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','109013',2162254,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109013',2162255,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109013',2162256,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109013',2162257,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109013',2162258,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109013',2162259,'1726','237',460053.91,460053.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109013',2162260,'1727','237',119126.82,119963.91,837.09,117192.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','109013',2162261,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109013',2162262,'1729','238',284716.61,284955.03,238.42,53644.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','109013',2162263,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109013',2162264,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109018',2162379,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109018',2162380,'1714','237',736334.20,737072.17,737.97,103315.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109018',2162381,'1715','237',213462.93,214413.88,950.95,133133.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109018',2162382,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109018',2162383,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109018',2162384,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109018',2162385,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109018',2162386,'1720','237',627510.94,628874.99,1364.05,190967.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109018',2162387,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109018',2162388,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109018',2162389,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109018',2162390,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109018',2162391,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109018',2162392,'1726','237',460053.91,460053.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109018',2162393,'1727','237',119963.91,120574.09,610.18,85425.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','109018',2162394,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109018',2162395,'1729','238',284955.03,285086.11,131.08,29493.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109018',2162396,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109018',2162397,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109019',2162398,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109019',2162399,'1714','237',737072.17,738353.87,1281.70,179438.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109019',2162400,'1715','237',214413.88,215631.81,1217.93,170510.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','109019',2162401,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109019',2162402,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109019',2162403,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109019',2162404,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109019',2162405,'1720','237',628874.99,630201.75,1326.76,185746.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','109019',2162406,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109019',2162407,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109019',2162408,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109019',2162409,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109019',2162410,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109019',2162411,'1726','237',460053.91,461699.04,1645.13,230318.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','109019',2162412,'1727','237',120574.09,121038.71,464.62,65046.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','109019',2162413,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109019',2162414,'1729','238',285086.11,285113.66,27.55,6198.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','109019',2162415,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109019',2162416,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109034',2162763,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109034',2162764,'1714','237',738353.87,739061.74,707.87,99101.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109034',2162765,'1715','237',215631.81,216470.63,838.82,117434.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109034',2162766,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109034',2162767,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109034',2162768,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109034',2162769,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109034',2162770,'1720','237',630201.75,631527.82,1326.07,185649.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','109034',2162771,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109034',2162772,'1722','237',286535.46,286535.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109034',2162773,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109034',2162774,'1724','237',300170.66,300170.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109034',2162775,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109034',2162776,'1726','237',461699.04,461699.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109034',2162777,'1727','237',121038.71,121349.10,310.39,43454.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','109034',2162778,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109034',2162779,'1729','238',285113.66,285339.59,225.93,50834.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','109034',2162780,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109034',2162781,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109037',2162826,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109037',2162827,'1714','237',739061.74,739972.10,910.36,127450.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','109037',2162828,'1715','237',216470.63,217423.18,952.55,133357.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109037',2162829,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109037',2162830,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109037',2162831,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109037',2162832,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109037',2162833,'1720','237',631527.82,632579.29,1051.47,147205.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','109037',2162834,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109037',2162835,'1722','237',286535.46,286998.96,463.50,64890.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109037',2162836,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109037',2162837,'1724','237',300170.66,300994.13,823.47,115285.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','109037',2162838,'1725','237',133775.76,133775.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109037',2162839,'1726','237',461699.04,461699.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109037',2162840,'1727','237',121349.10,121505.76,156.66,21932.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','109037',2162841,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109037',2162842,'1729','238',285339.59,285483.65,144.06,32413.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','109037',2162843,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109037',2162844,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109039',2162873,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109039',2162874,'1714','237',739972.10,740757.77,785.67,109993.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109039',2162875,'1715','237',217423.18,218256.15,832.97,116615.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109039',2162876,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109039',2162877,'1717','237',200367.43,200367.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109039',2162878,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109039',2162879,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109039',2162880,'1720','237',632579.29,633361.99,782.70,109578.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109039',2162881,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109039',2162882,'1722','237',286998.96,287464.85,465.89,65224.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','109039',2162883,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109039',2162884,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109039',2162885,'1725','237',133775.76,134306.30,530.54,74275.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','109039',2162886,'1726','237',461699.04,461699.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109039',2162887,'1727','237',121505.76,121505.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109039',2162888,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109039',2162889,'1729','238',285483.65,285674.96,191.31,43044.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','109039',2162890,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109039',2162891,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109041',2162902,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109041',2162903,'1714','237',740757.77,742019.56,1261.79,176650.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','109041',2162904,'1715','237',218256.15,219663.00,1406.85,196959.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109041',2162905,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109041',2162906,'1717','237',200367.43,200397.53,30.10,4214.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109041',2162907,'1718','237',652444.46,652444.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109041',2162908,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109041',2162909,'1720','237',633361.99,634425.87,1063.88,148943.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','109041',2162910,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109041',2162911,'1722','237',287464.85,287464.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109041',2162912,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109041',2162913,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109041',2162914,'1725','237',134306.30,135241.27,934.97,130895.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','109041',2162915,'1726','237',461699.04,461699.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109041',2162916,'1727','237',121505.76,121505.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109041',2162917,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109041',2162918,'1729','238',285674.96,285693.51,18.55,4173.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','109041',2162919,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109041',2162920,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109045',2162970,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109045',2162971,'1714','237',742019.56,743149.33,1129.77,158167.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','109045',2162972,'1715','237',219663.00,221029.74,1366.74,191343.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','109045',2162973,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109045',2162974,'1717','237',200397.53,200407.53,10.00,1400.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109045',2162975,'1718','237',652444.46,652455.39,10.93,1530.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','109045',2162976,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109045',2162977,'1720','237',634425.87,635721.54,1295.67,181393.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','109045',2162978,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109045',2162979,'1722','237',287464.85,287464.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109045',2162980,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109045',2162981,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109045',2162982,'1725','237',135241.27,135695.13,453.86,63540.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','109045',2162983,'1726','237',461699.04,461699.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109045',2162984,'1727','237',121505.76,121505.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109045',2162985,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109045',2162986,'1729','238',285693.51,285756.05,62.54,14071.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','109045',2162987,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109045',2162988,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109046',2162989,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109046',2162990,'1714','237',743149.33,743907.27,757.94,106111.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','109046',2162991,'1715','237',221029.74,221860.84,831.10,116354.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109046',2162992,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109046',2162993,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109046',2162994,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109046',2162995,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109046',2162996,'1720','237',635721.54,636969.22,1247.68,174675.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','109046',2162997,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109046',2162998,'1722','237',287464.85,287738.06,273.21,38249.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','109046',2162999,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109046',2163000,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109046',2163001,'1725','237',135695.13,136573.45,878.32,122964.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','109046',2163002,'1726','237',461699.04,461699.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109046',2163003,'1727','237',121505.76,121941.17,435.41,60957.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','109046',2163004,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109046',2163005,'1729','238',285756.05,285873.27,117.22,26374.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','109046',2163006,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109046',2163007,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109051',2163082,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109051',2163083,'1714','237',743907.27,745062.87,1155.60,161784.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109051',2163084,'1715','237',221860.84,222760.72,899.88,125983.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','109051',2163085,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109051',2163086,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109051',2163087,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109051',2163088,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109051',2163089,'1720','237',636969.22,638275.54,1306.32,182884.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','109051',2163090,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109051',2163091,'1722','237',287738.06,287952.44,214.38,30013.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','109051',2163092,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109051',2163093,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109051',2163094,'1725','237',136573.45,137209.27,635.82,89014.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','109051',2163095,'1726','237',462453.64,463078.75,625.11,87515.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','109051',2163096,'1727','237',121941.17,121941.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109051',2163097,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109051',2163098,'1729','238',285873.27,285964.79,91.52,20592.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109051',2163099,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109051',2163100,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109053',2163117,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109053',2163118,'1714','237',745062.87,745289.05,226.18,31665.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','109053',2163119,'1715','237',222760.72,222760.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109053',2163120,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109053',2163121,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109053',2163122,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109053',2163123,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109053',2163124,'1720','237',638275.54,639606.40,1330.86,186320.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','109053',2163125,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109053',2163126,'1722','237',287952.44,288742.32,789.88,110583.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','109053',2163127,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109053',2163128,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109053',2163129,'1725','237',137209.27,138369.77,1160.50,162470.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109053',2163130,'1726','237',463078.75,463078.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109053',2163131,'1727','237',121941.17,123078.75,1137.58,159261.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','109053',2163132,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109053',2163133,'1729','238',285964.79,286003.01,38.22,8599.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','109053',2163134,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109053',2163135,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109092',2163985,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109092',2163986,'1714','237',745289.05,745289.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109092',2163987,'1715','237',222760.72,222760.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109092',2163988,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109092',2163989,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109092',2163990,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109092',2163991,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109092',2163992,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109092',2163993,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109092',2163994,'1722','237',288742.32,290267.19,1524.87,213481.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','109092',2163995,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109092',2163996,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109092',2163997,'1725','237',138369.77,139039.39,669.62,93746.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','109092',2163998,'1726','237',463078.75,464398.18,1319.43,184720.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','109092',2163999,'1727','237',123078.75,123637.30,558.55,78197.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109092',2164000,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109092',2164001,'1729','238',286003.01,286306.75,303.74,68341.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','109092',2164002,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109092',2164003,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109095',2164037,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109095',2164038,'1714','237',745289.05,745289.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109095',2164039,'1715','237',222760.72,222760.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109095',2164040,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109095',2164041,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109095',2164042,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109095',2164043,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109095',2164044,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109095',2164045,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109095',2164046,'1722','237',290267.19,291857.57,1590.38,227424.34,0.00,0.00,0.00,0.00,0.00),('5','97','616','109095',2164047,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109095',2164048,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109095',2164049,'1725','237',139039.39,140681.33,1641.94,234797.42,0.00,0.00,0.00,0.00,0.00),('5','97','617','109095',2164050,'1726','237',464398.18,465055.16,656.98,93948.14,0.00,0.00,0.00,0.00,0.00),('5','97','617','109095',2164051,'1727','237',123637.30,124345.24,707.94,101235.42,0.00,0.00,0.00,0.00,0.00),('5','97','617','109095',2164052,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109095',2164053,'1729','238',286306.75,286581.37,274.62,59043.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','109095',2164054,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109095',2164055,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109097',2164073,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109097',2164074,'1714','237',745289.05,746141.23,852.18,121861.74,0.00,0.00,0.00,0.00,0.00),('5','97','614','109097',2164075,'1715','237',222760.72,223778.42,1017.70,145531.10,0.00,0.00,0.00,0.00,0.00),('5','97','614','109097',2164076,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109097',2164077,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109097',2164078,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109097',2164079,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109097',2164080,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109097',2164081,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109097',2164082,'1722','237',291857.57,292265.77,408.20,58372.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','109097',2164083,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109097',2164084,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109097',2164085,'1725','237',140681.33,141439.97,758.64,108485.52,0.00,0.00,0.00,0.00,0.00),('5','97','617','109097',2164086,'1726','237',465055.16,465055.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109097',2164087,'1727','237',124345.24,124345.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109097',2164088,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109097',2164089,'1729','238',286581.37,286640.54,59.17,12721.55,0.00,0.00,0.00,0.00,0.00),('5','97','618','109097',2164090,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109097',2164091,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109107',2164158,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109107',2164159,'1714','237',746141.23,747354.86,1213.63,173549.09,0.00,0.00,0.00,0.00,0.00),('5','97','614','109107',2164160,'1715','237',223778.42,225240.47,1462.05,209073.15,0.00,0.00,0.00,0.00,0.00),('5','97','614','109107',2164161,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109107',2164162,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109107',2164163,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109107',2164164,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109107',2164165,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109107',2164166,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109107',2164167,'1722','237',292265.77,292265.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109107',2164168,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109107',2164169,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109107',2164170,'1725','237',141439.97,142712.27,1272.30,181938.90,0.00,0.00,0.00,0.00,0.00),('5','97','617','109107',2164171,'1726','237',465055.16,465055.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109107',2164172,'1727','237',124345.24,124345.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109107',2164173,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109107',2164174,'1729','238',286640.54,287256.41,615.87,132412.05,0.00,0.00,0.00,0.00,0.00),('5','97','618','109107',2164175,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109107',2164176,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109236',2166635,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109236',2166636,'1714','237',747354.86,748782.87,1428.01,204205.43,0.00,0.00,0.00,0.00,0.00),('5','97','614','109236',2166637,'1715','237',225240.47,226467.77,1227.30,175503.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','109236',2166638,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109236',2166639,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109236',2166640,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109236',2166641,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109236',2166642,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109236',2166643,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109236',2166644,'1722','237',292265.77,292265.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109236',2166645,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109236',2166646,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109236',2166647,'1725','237',142712.27,143875.61,1163.34,166357.62,0.00,0.00,0.00,0.00,0.00),('5','97','617','109236',2166648,'1726','237',465055.16,465055.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109236',2166649,'1727','237',124345.24,124345.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109236',2166650,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109236',2166651,'1729','238',287256.41,287710.86,454.45,97706.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','109236',2166652,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109236',2166653,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109258',2167144,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109258',2167145,'1714','237',748782.87,749981.93,1199.06,171465.58,0.00,0.00,0.00,0.00,0.00),('5','97','614','109258',2167146,'1715','237',226467.77,228248.10,1780.33,254587.19,0.00,0.00,0.00,0.00,0.00),('5','97','614','109258',2167147,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109258',2167148,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109258',2167149,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109258',2167150,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109258',2167151,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109258',2167152,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109258',2167153,'1722','237',292265.77,292265.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109258',2167154,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109258',2167155,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109258',2167156,'1725','237',143875.61,144885.16,1009.55,144365.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','109258',2167157,'1726','237',465055.16,465055.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109258',2167158,'1727','237',124345.24,124345.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109258',2167159,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109258',2167160,'1729','238',287710.86,288343.60,632.74,136039.10,0.00,0.00,0.00,0.00,0.00),('5','97','618','109258',2167161,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109258',2167162,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109331',2168621,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109331',2168622,'1714','237',749981.93,750959.19,977.26,139748.18,0.00,0.00,0.00,0.00,0.00),('5','97','614','109331',2168623,'1715','237',228248.10,229270.71,1022.61,146233.23,0.00,0.00,0.00,0.00,0.00),('5','97','614','109331',2168624,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109331',2168625,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109331',2168626,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109331',2168627,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109331',2168628,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109331',2168629,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109331',2168630,'1722','237',292265.77,292305.77,40.00,5720.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109331',2168631,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109331',2168632,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109331',2168633,'1725','237',144885.16,145752.03,866.87,123962.41,0.00,0.00,0.00,0.00,0.00),('5','97','617','109331',2168634,'1726','237',465055.16,465517.67,462.51,66138.93,0.00,0.00,0.00,0.00,0.00),('5','97','617','109331',2168635,'1727','237',124345.24,124850.89,505.65,72307.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','109331',2168636,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109331',2168637,'1729','238',288343.60,288615.57,271.97,58473.55,0.00,0.00,0.00,0.00,0.00),('5','97','618','109331',2168638,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109331',2168639,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109389',2169737,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109389',2169738,'1714','237',750959.19,751702.45,743.26,106286.18,0.00,0.00,0.00,0.00,0.00),('5','97','614','109389',2169739,'1715','237',229270.71,230913.82,1643.11,234964.73,0.00,0.00,0.00,0.00,0.00),('5','97','614','109389',2169740,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109389',2169741,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109389',2169742,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109389',2169743,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109389',2169744,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109389',2169745,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109389',2169746,'1722','237',292305.77,293066.76,760.99,108821.57,0.00,0.00,0.00,0.00,0.00),('5','97','616','109389',2169747,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109389',2169748,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109389',2169749,'1725','237',145752.03,146885.26,1133.23,162051.89,0.00,0.00,0.00,0.00,0.00),('5','97','617','109389',2169750,'1726','237',465517.67,465517.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109389',2169751,'1727','237',124850.89,125596.35,745.46,106600.78,0.00,0.00,0.00,0.00,0.00),('5','97','617','109389',2169752,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109389',2169753,'1729','238',288615.57,288776.44,160.87,34587.05,0.00,0.00,0.00,0.00,0.00),('5','97','618','109389',2169754,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109389',2169755,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109472',2171392,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109472',2171393,'1714','237',751702.45,752190.02,487.57,69722.51,0.00,0.00,0.00,0.00,0.00),('5','97','614','109472',2171394,'1715','237',230913.82,232422.51,1508.69,215742.67,0.00,0.00,0.00,0.00,0.00),('5','97','614','109472',2171395,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109472',2171396,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109472',2171397,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109472',2171398,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109472',2171399,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109472',2171400,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109472',2171401,'1722','237',293066.76,293852.99,786.23,112430.89,0.00,0.00,0.00,0.00,0.00),('5','97','616','109472',2171402,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109472',2171403,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109472',2171404,'1725','237',146885.26,147710.88,825.62,118063.66,0.00,0.00,0.00,0.00,0.00),('5','97','617','109472',2171405,'1726','237',465517.67,466338.31,820.64,117351.52,0.00,0.00,0.00,0.00,0.00),('5','97','617','109472',2171406,'1727','237',125596.35,125596.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109472',2171407,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109472',2171408,'1729','238',288776.44,288937.92,161.48,34718.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','109472',2171409,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109472',2171410,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109537',2172588,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109537',2172589,'1714','237',752190.02,753357.60,1167.58,166963.94,0.00,0.00,0.00,0.00,0.00),('5','97','614','109537',2172590,'1715','237',232422.51,233598.19,1175.68,168122.24,0.00,0.00,0.00,0.00,0.00),('5','97','614','109537',2172591,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109537',2172592,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109537',2172593,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109537',2172594,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109537',2172595,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109537',2172596,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109537',2172597,'1722','237',293852.99,294474.48,621.49,88873.07,0.00,0.00,0.00,0.00,0.00),('5','97','616','109537',2172598,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109537',2172599,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109537',2172600,'1725','237',147710.88,148670.36,959.48,137205.64,0.00,0.00,0.00,0.00,0.00),('5','97','617','109537',2172601,'1726','237',466338.31,466338.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109537',2172602,'1727','237',125596.35,125596.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109537',2172603,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109537',2172604,'1729','238',288937.92,289342.57,404.65,86999.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','109537',2172605,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109537',2172606,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109644',2174773,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109644',2174774,'1714','237',753357.60,754204.56,846.96,121115.28,0.00,0.00,0.00,0.00,0.00),('5','97','614','109644',2174775,'1715','237',233598.19,235000.12,1401.93,200475.99,0.00,0.00,0.00,0.00,0.00),('5','97','614','109644',2174776,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109644',2174777,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109644',2174778,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109644',2174779,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109644',2174780,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109644',2174781,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109644',2174782,'1722','237',294474.48,295151.25,676.77,96778.11,0.00,0.00,0.00,0.00,0.00),('5','97','616','109644',2174783,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109644',2174784,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109644',2174785,'1725','237',148670.36,149761.64,1091.28,156053.04,0.00,0.00,0.00,0.00,0.00),('5','97','617','109644',2174786,'1726','237',466338.31,466575.72,237.41,33949.63,0.00,0.00,0.00,0.00,0.00),('5','97','617','109644',2174787,'1727','237',125596.35,125596.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109644',2174788,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109644',2174789,'1729','238',289342.57,289550.52,207.95,44709.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','109644',2174790,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109644',2174791,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109645',2174792,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109645',2174793,'1714','237',754204.56,755276.57,1072.01,153297.43,0.00,0.00,0.00,0.00,0.00),('5','97','614','109645',2174794,'1715','237',235000.12,236438.23,1438.11,205649.73,0.00,0.00,0.00,0.00,0.00),('5','97','614','109645',2174795,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109645',2174796,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109645',2174797,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109645',2174798,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109645',2174799,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109645',2174800,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109645',2174801,'1722','237',295151.25,295517.81,366.56,52418.08,0.00,0.00,0.00,0.00,0.00),('5','97','616','109645',2174802,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109645',2174803,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109645',2174804,'1725','237',149761.64,150663.45,901.81,128958.83,0.00,0.00,0.00,0.00,0.00),('5','97','617','109645',2174805,'1726','237',466575.72,467267.97,692.25,98991.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','109645',2174806,'1727','237',125596.35,125596.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109645',2174807,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109645',2174808,'1729','238',289550.52,289605.37,54.85,11792.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','109645',2174809,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109645',2174810,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109685',2175577,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109685',2175578,'1714','237',755276.57,756609.65,1333.08,190630.44,0.00,0.00,0.00,0.00,0.00),('5','97','614','109685',2175579,'1715','237',236438.23,238099.44,1661.21,237553.03,0.00,0.00,0.00,0.00,0.00),('5','97','614','109685',2175580,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109685',2175581,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109685',2175582,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109685',2175583,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109685',2175584,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109685',2175585,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109685',2175586,'1722','237',295517.81,296657.93,1140.12,163037.16,0.00,0.00,0.00,0.00,0.00),('5','97','616','109685',2175587,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109685',2175588,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109685',2175589,'1725','237',150663.45,151647.40,983.95,140704.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','109685',2175590,'1726','237',467267.97,467267.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109685',2175591,'1727','237',125596.35,125596.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109685',2175592,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109685',2175593,'1729','238',289605.37,289755.30,149.93,32234.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','109685',2175594,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109685',2175595,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109744',2176858,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109744',2176859,'1714','237',756609.65,757578.80,969.15,138588.45,0.00,0.00,0.00,0.00,0.00),('5','97','614','109744',2176860,'1715','237',238099.44,239914.11,1814.67,259497.81,0.00,0.00,0.00,0.00,0.00),('5','97','614','109744',2176861,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109744',2176862,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109744',2176863,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109744',2176864,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109744',2176865,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109744',2176866,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109744',2176867,'1722','237',296657.93,296657.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109744',2176868,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109744',2176869,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109744',2176870,'1725','237',151647.40,152405.25,757.85,108372.55,0.00,0.00,0.00,0.00,0.00),('5','97','617','109744',2176871,'1726','237',467267.97,468140.72,872.75,124803.25,0.00,0.00,0.00,0.00,0.00),('5','97','617','109744',2176872,'1727','237',125596.35,125596.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109744',2176873,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109744',2176874,'1729','238',289755.30,289976.22,220.92,47497.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','109744',2176875,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109744',2176876,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109838',2178619,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109838',2178620,'1714','237',757578.80,758342.80,764.00,109252.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109838',2178621,'1715','237',239914.11,241509.24,1595.13,228103.59,0.00,0.00,0.00,0.00,0.00),('5','97','614','109838',2178622,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109838',2178623,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109838',2178624,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109838',2178625,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109838',2178626,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109838',2178627,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109838',2178628,'1722','237',296657.93,297335.35,677.42,96871.06,0.00,0.00,0.00,0.00,0.00),('5','97','616','109838',2178629,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109838',2178630,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109838',2178631,'1725','237',152405.25,153249.58,844.33,120739.19,0.00,0.00,0.00,0.00,0.00),('5','97','617','109838',2178632,'1726','237',468140.72,468931.27,790.55,113048.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','109838',2178633,'1727','237',125596.35,125596.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109838',2178634,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109838',2178635,'1729','238',289976.22,290192.46,216.24,46491.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','109838',2178636,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109838',2178637,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109876',2179466,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109876',2179467,'1714','237',758342.80,759267.63,924.83,132250.69,0.00,0.00,0.00,0.00,0.00),('5','97','614','109876',2179468,'1715','237',241509.24,242804.12,1294.88,185167.84,0.00,0.00,0.00,0.00,0.00),('5','97','614','109876',2179469,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109876',2179470,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109876',2179471,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109876',2179472,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109876',2179473,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109876',2179474,'1721','237',57709.70,57709.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109876',2179475,'1722','237',297335.35,297335.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109876',2179476,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109876',2179477,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109876',2179478,'1725','237',153249.58,153832.58,583.00,83369.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109876',2179479,'1726','237',468931.27,469860.82,929.55,132925.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','109876',2179480,'1727','237',125596.35,125596.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109876',2179481,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109876',2179482,'1729','238',290192.46,290484.88,292.42,62870.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','109876',2179483,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109876',2179484,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109987',2181712,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','109987',2181713,'1714','237',759267.63,760162.92,895.29,128026.47,0.00,0.00,0.00,0.00,0.00),('5','97','614','109987',2181714,'1715','237',242804.12,243979.82,1175.70,168125.10,0.00,0.00,0.00,0.00,0.00),('5','97','614','109987',2181715,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109987',2181716,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109987',2181717,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109987',2181718,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','109987',2181719,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109987',2181720,'1721','237',57709.70,58072.95,363.25,51944.75,0.00,0.00,0.00,0.00,0.00),('5','97','616','109987',2181721,'1722','237',297335.35,297335.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109987',2181722,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109987',2181723,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','109987',2181724,'1725','237',153832.58,153832.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109987',2181725,'1726','237',469860.82,469860.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','109987',2181726,'1727','237',125596.35,126219.06,622.71,89047.53,0.00,0.00,0.00,0.00,0.00),('5','97','617','109987',2181727,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','109987',2181728,'1729','238',290484.88,291224.50,739.62,159018.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','109987',2181729,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','109987',2181730,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110095',2183878,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110095',2183879,'1714','237',760162.92,760857.47,694.55,99320.65,0.00,0.00,0.00,0.00,0.00),('5','97','614','110095',2183880,'1715','237',243979.82,245340.73,1360.91,194610.13,0.00,0.00,0.00,0.00,0.00),('5','97','614','110095',2183881,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110095',2183882,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110095',2183883,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110095',2183884,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110095',2183885,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110095',2183886,'1721','237',58072.95,58379.02,306.07,43768.01,0.00,0.00,0.00,0.00,0.00),('5','97','616','110095',2183887,'1722','237',297335.35,297335.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110095',2183888,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110095',2183889,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110095',2183890,'1725','237',153832.58,154568.90,736.32,105293.76,0.00,0.00,0.00,0.00,0.00),('5','97','617','110095',2183891,'1726','237',469860.82,469860.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110095',2183892,'1727','237',126219.06,126890.15,671.09,95965.87,0.00,0.00,0.00,0.00,0.00),('5','97','617','110095',2183893,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','110095',2183894,'1729','238',291224.50,292174.89,950.39,204333.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','110095',2183895,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','110095',2183896,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110116',2184324,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110116',2184325,'1714','237',760857.47,762986.85,2129.38,304501.34,0.00,0.00,0.00,0.00,0.00),('5','97','614','110116',2184326,'1715','237',245340.73,247850.86,2510.13,358948.59,0.00,0.00,0.00,0.00,0.00),('5','97','614','110116',2184327,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110116',2184328,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110116',2184329,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110116',2184330,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110116',2184331,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110116',2184332,'1721','237',58379.02,58379.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110116',2184333,'1722','237',297335.35,298508.96,1173.61,167826.23,0.00,0.00,0.00,0.00,0.00),('5','97','616','110116',2184334,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110116',2184335,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110116',2184336,'1725','237',154568.90,154568.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110116',2184337,'1726','237',469860.82,471043.89,1183.07,169179.01,0.00,0.00,0.00,0.00,0.00),('5','97','617','110116',2184338,'1727','237',126890.15,126890.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110116',2184339,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','110116',2184340,'1729','238',292174.89,293080.15,905.26,194630.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','110116',2184341,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','110116',2184342,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110208',2186039,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110208',2186040,'1714','237',762986.85,763827.68,840.83,120238.69,0.00,0.00,0.00,0.00,0.00),('5','97','614','110208',2186041,'1715','237',247850.86,248524.47,673.61,96326.23,0.00,0.00,0.00,0.00,0.00),('5','97','614','110208',2186042,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110208',2186043,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110208',2186044,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110208',2186045,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110208',2186046,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110208',2186047,'1721','237',58379.02,58684.93,305.91,43745.13,0.00,0.00,0.00,0.00,0.00),('5','97','616','110208',2186048,'1722','237',298508.96,299031.00,522.04,74651.72,0.00,0.00,0.00,0.00,0.00),('5','97','616','110208',2186049,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110208',2186050,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110208',2186051,'1725','237',154568.90,155052.70,483.80,69183.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','110208',2186052,'1726','237',471043.89,471043.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110208',2186053,'1727','237',126890.15,127568.06,677.91,96941.13,0.00,0.00,0.00,0.00,0.00),('5','97','617','110208',2186054,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','110208',2186055,'1729','238',293080.15,293207.79,127.64,27442.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','110208',2186056,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','110208',2186057,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110281',2187536,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110281',2187537,'1714','237',763827.68,763827.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110281',2187538,'1715','237',248524.47,248524.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110281',2187539,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110281',2187540,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110281',2187541,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110281',2187542,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110281',2187543,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110281',2187544,'1721','237',58684.93,58684.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110281',2187545,'1722','237',299031.00,299153.04,122.04,17451.72,0.00,0.00,0.00,0.00,0.00),('5','97','616','110281',2187546,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110281',2187547,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110281',2187548,'1725','237',155052.70,156397.55,1344.85,192313.55,0.00,0.00,0.00,0.00,0.00),('5','97','617','110281',2187549,'1726','237',471043.89,472617.73,1573.84,225059.12,0.00,0.00,0.00,0.00,0.00),('5','97','617','110281',2187550,'1727','237',127568.06,128579.05,1010.99,144571.57,0.00,0.00,0.00,0.00,0.00),('5','97','617','110281',2187551,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','110281',2187552,'1729','238',293207.79,293585.99,378.20,81313.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','110281',2187553,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','110281',2187554,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110448',2190627,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110448',2190628,'1714','237',763827.68,763827.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110448',2190629,'1715','237',248524.47,248524.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110448',2190630,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110448',2190631,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110448',2190632,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110448',2190633,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110448',2190634,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110448',2190635,'1721','237',58684.93,59966.98,1282.05,183333.15,0.00,0.00,0.00,0.00,0.00),('5','97','616','110448',2190636,'1722','237',299153.04,299153.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110448',2190637,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110448',2190638,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110448',2190639,'1725','237',156397.55,156397.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110448',2190640,'1726','237',472617.73,472617.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110448',2190641,'1727','237',128579.05,129958.54,1379.49,197267.07,0.00,0.00,0.00,0.00,0.00),('5','97','617','110448',2190642,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','110448',2190643,'1729','238',293585.99,293803.94,217.95,46859.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','110448',2190644,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','110448',2190645,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110451',2190714,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110451',2190715,'1714','237',763827.68,763827.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110451',2190716,'1715','237',248524.47,248524.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110451',2190717,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110451',2190718,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110451',2190719,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110451',2190720,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110451',2190721,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110451',2190722,'1721','237',59966.98,59966.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110451',2190723,'1722','237',299153.04,299153.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110451',2190724,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110451',2190725,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110451',2190726,'1725','237',156397.55,157230.55,833.00,119119.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110451',2190727,'1726','237',472617.73,473920.05,1302.32,186231.76,0.00,0.00,0.00,0.00,0.00),('5','97','617','110451',2190728,'1727','237',129958.54,130811.54,853.00,121979.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110451',2190729,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','110451',2190730,'1729','238',293803.94,294068.04,264.10,56781.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','110451',2190731,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','110451',2190732,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110453',2190755,'1713','237',110014.52,110014.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110453',2190756,'1714','237',763827.68,763827.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110453',2190757,'1715','237',248524.47,248524.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','110453',2190758,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110453',2190759,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110453',2190760,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110453',2190761,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','110453',2190762,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110453',2190763,'1721','237',59966.98,59966.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110453',2190764,'1722','237',299153.04,299153.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110453',2190765,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110453',2190766,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','110453',2190767,'1725','237',157230.55,157230.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','110453',2190768,'1726','237',473920.05,476369.61,2449.56,350287.08,0.00,0.00,0.00,0.00,0.00),('5','97','617','110453',2190769,'1727','237',130811.54,132830.03,2018.49,288644.07,0.00,0.00,0.00,0.00,0.00),('5','97','617','110453',2190770,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','110453',2190771,'1729','238',294068.04,294199.56,131.52,28276.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','110453',2190772,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','110453',2190773,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118707',2359638,'1713','237',110014.52,112214.51,2199.99,314598.57,0.00,0.00,0.00,0.00,0.00),('5','97','614','118707',2359639,'1714','237',763827.68,763827.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118707',2359640,'1715','237',248524.47,249524.56,1000.09,143012.87,0.00,0.00,0.00,0.00,0.00),('5','97','614','118707',2359641,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118707',2359642,'1717','237',200407.53,200524.00,116.47,16655.21,0.00,0.00,0.00,0.00,0.00),('5','97','615','118707',2359643,'1718','237',652455.39,652455.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118707',2359644,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118707',2359645,'1720','237',639606.40,639606.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118707',2359646,'1721','237',59966.98,59966.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118707',2359647,'1722','237',299153.04,299153.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118707',2359648,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118707',2359649,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118707',2359650,'1725','237',157230.55,157230.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118707',2359651,'1726','237',476369.61,476369.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118707',2359652,'1727','237',132830.03,132830.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118707',2359653,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','118707',2359654,'1729','238',294199.56,294299.00,99.44,21876.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','118707',2359655,'1730','238',1418.56,1418.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','118707',2359656,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118721',2359862,'1713','237',112214.51,112214.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118721',2359863,'1714','237',763827.68,763827.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118721',2359864,'1715','237',249524.56,249524.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118721',2359865,'1716','237',747942.25,747942.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118721',2359866,'1717','237',200524.00,200524.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118721',2359867,'1718','237',652455.39,652655.39,200.00,28600.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118721',2359868,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118721',2359869,'1720','237',639606.40,639806.40,200.00,28600.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118721',2359870,'1721','237',59966.98,59966.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118721',2359871,'1722','237',299153.04,299953.04,800.00,114400.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118721',2359872,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118721',2359873,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118721',2359874,'1725','237',157230.55,157230.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118721',2359875,'1726','237',476369.61,476369.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118721',2359876,'1727','237',132830.03,132830.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118721',2359877,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','118721',2359878,'1729','238',294299.00,294299.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','118721',2359879,'1730','238',1418.56,1618.56,200.00,44000.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','118721',2359880,'1731','239',42385.36,42385.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118732',2360041,'1713','237',112214.51,112214.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118732',2360042,'1714','237',763827.68,764827.68,1000.00,143000.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118732',2360043,'1715','237',249524.56,249524.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','118732',2360044,'1716','237',747942.25,748222.28,280.03,40044.29,0.00,0.00,0.00,0.00,0.00),('5','97','615','118732',2360045,'1717','237',200524.00,201524.85,1000.85,143121.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','118732',2360046,'1718','237',652655.39,652655.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118732',2360047,'1719','237',175843.76,175843.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','118732',2360048,'1720','237',639806.40,639816.45,10.05,1437.15,0.00,0.00,0.00,0.00,0.00),('5','97','616','118732',2360049,'1721','237',59966.98,59966.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118732',2360050,'1722','237',299953.04,299962.84,9.80,1401.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','118732',2360051,'1723','237',247545.15,247545.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118732',2360052,'1724','237',300994.13,300994.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','118732',2360053,'1725','237',157230.55,157230.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118732',2360054,'1726','237',476369.61,476369.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118732',2360055,'1727','237',132830.03,132830.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','118732',2360056,'1728','237',199308.11,199308.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','118732',2360057,'1729','238',294299.00,294299.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','118732',2360058,'1730','238',1618.56,1618.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','118732',2360059,'1731','239',42385.36,42481.38,96.02,26405.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','123895',2468484,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','123895',2468485,'1714','237',925854.24,926395.13,540.89,77347.27,0.00,0.00,0.00,0.00,0.00),('5','97','614','123895',2468486,'1715','237',472315.96,472955.10,639.14,91397.02,0.00,0.00,0.00,0.00,0.00),('5','97','614','123895',2468487,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','123895',2468488,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','123895',2468489,'1718','237',721699.77,722946.12,1246.35,178228.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','123895',2468490,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','123895',2468491,'1720','237',721168.07,721872.69,704.62,100760.66,0.00,0.00,0.00,0.00,0.00),('5','97','616','123895',2468492,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','123895',2468493,'1722','237',435843.00,436126.08,283.08,40480.44,0.00,0.00,0.00,0.00,0.00),('5','97','616','123895',2468494,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','123895',2468495,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','123895',2468496,'1725','237',295817.28,296192.54,375.26,53662.18,0.00,0.00,0.00,0.00,0.00),('5','97','617','123895',2468497,'1726','237',561078.38,561078.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','123895',2468498,'1727','237',234298.00,234537.17,239.17,34201.31,0.00,0.00,0.00,0.00,0.00),('5','97','617','123895',2468499,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','123895',2468500,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','123895',2468501,'1730','238',377614.50,377853.21,238.71,52516.20,0.00,0.00,0.00,0.00,0.00),('5','97','619','123895',2468502,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124062',2471726,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124062',2471727,'1714','237',926395.13,927012.72,617.59,88315.37,0.00,0.00,0.00,0.00,0.00),('5','97','614','124062',2471728,'1715','237',472955.10,474211.94,1256.84,179728.12,0.00,0.00,0.00,0.00,0.00),('5','97','614','124062',2471729,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124062',2471730,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124062',2471731,'1718','237',722946.12,723518.09,571.97,81791.71,0.00,0.00,0.00,0.00,0.00),('5','97','615','124062',2471732,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124062',2471733,'1720','237',721872.69,722659.06,786.37,112450.91,0.00,0.00,0.00,0.00,0.00),('5','97','616','124062',2471734,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124062',2471735,'1722','237',436126.08,436126.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124062',2471736,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124062',2471737,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124062',2471738,'1725','237',296192.54,296910.10,717.56,102611.08,0.00,0.00,0.00,0.00,0.00),('5','97','617','124062',2471739,'1726','237',561078.38,561078.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124062',2471740,'1727','237',234537.17,234814.92,277.75,39718.25,0.00,0.00,0.00,0.00,0.00),('5','97','617','124062',2471741,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124062',2471742,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124062',2471743,'1730','238',377853.21,378556.21,703.00,158175.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','124062',2471744,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124520',2481549,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124520',2481550,'1714','237',927012.72,928098.31,1085.59,155239.37,0.00,0.00,0.00,0.00,0.00),('5','97','614','124520',2481551,'1715','237',474211.94,475194.61,982.67,140521.81,0.00,0.00,0.00,0.00,0.00),('5','97','614','124520',2481552,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124520',2481553,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124520',2481554,'1718','237',723518.09,724381.08,862.99,123407.57,0.00,0.00,0.00,0.00,0.00),('5','97','615','124520',2481555,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124520',2481556,'1720','237',722659.06,723416.09,757.03,108255.29,0.00,0.00,0.00,0.00,0.00),('5','97','616','124520',2481557,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124520',2481558,'1722','237',436126.08,436210.10,84.02,12014.86,0.00,0.00,0.00,0.00,0.00),('5','97','616','124520',2481559,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124520',2481560,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124520',2481561,'1725','237',296910.10,297491.19,581.09,83095.87,0.00,0.00,0.00,0.00,0.00),('5','97','617','124520',2481562,'1726','237',561078.38,561078.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124520',2481563,'1727','237',234814.92,234814.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124520',2481564,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124520',2481565,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124520',2481566,'1730','238',378556.21,378705.62,149.41,33617.25,0.00,0.00,0.00,0.00,0.00),('5','97','619','124520',2481567,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124524',2481643,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124524',2481644,'1714','237',928098.31,928675.12,576.81,82483.83,0.00,0.00,0.00,0.00,0.00),('5','97','614','124524',2481645,'1715','237',475194.61,476269.87,1075.26,153762.18,0.00,0.00,0.00,0.00,0.00),('5','97','614','124524',2481646,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124524',2481647,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124524',2481648,'1718','237',724381.08,725348.53,967.45,138345.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','124524',2481649,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124524',2481650,'1720','237',723416.09,724556.18,1140.09,163032.87,0.00,0.00,0.00,0.00,0.00),('5','97','616','124524',2481651,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124524',2481652,'1722','237',436210.10,436210.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124524',2481653,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124524',2481654,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124524',2481655,'1725','237',297491.19,298475.15,983.96,140706.28,0.00,0.00,0.00,0.00,0.00),('5','97','617','124524',2481656,'1726','237',561078.38,561078.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124524',2481657,'1727','237',234814.92,234814.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124524',2481658,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124524',2481659,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124524',2481660,'1730','238',378705.62,379337.09,631.47,142080.75,0.00,0.00,0.00,0.00,0.00),('5','97','619','124524',2481661,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124755',2486189,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124755',2486190,'1714','237',928675.12,930013.86,1338.74,191439.82,0.00,0.00,0.00,0.00,0.00),('5','97','614','124755',2486191,'1715','237',476269.87,477755.93,1486.06,212506.58,0.00,0.00,0.00,0.00,0.00),('5','97','614','124755',2486192,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124755',2486193,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124755',2486194,'1718','237',725348.53,727304.75,1956.22,279739.46,0.00,0.00,0.00,0.00,0.00),('5','97','615','124755',2486195,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124755',2486196,'1720','237',724556.18,725414.39,858.21,122724.03,0.00,0.00,0.00,0.00,0.00),('5','97','616','124755',2486197,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124755',2486198,'1722','237',436210.10,436904.75,694.65,99334.95,0.00,0.00,0.00,0.00,0.00),('5','97','616','124755',2486199,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124755',2486200,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124755',2486201,'1725','237',298475.15,299754.47,1279.32,182942.76,0.00,0.00,0.00,0.00,0.00),('5','97','617','124755',2486202,'1726','237',561078.38,561078.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124755',2486203,'1727','237',234814.92,234814.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124755',2486204,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124755',2486205,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124755',2486206,'1730','238',379337.09,380354.94,1017.85,229016.25,0.00,0.00,0.00,0.00,0.00),('5','97','619','124755',2486207,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124758',2486232,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124758',2486233,'1714','237',930013.86,930013.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124758',2486234,'1715','237',477755.93,478948.59,1192.66,170550.38,0.00,0.00,0.00,0.00,0.00),('5','97','614','124758',2486235,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124758',2486236,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124758',2486237,'1718','237',727304.75,728895.42,1590.67,227465.81,0.00,0.00,0.00,0.00,0.00),('5','97','615','124758',2486238,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124758',2486239,'1720','237',725414.39,726803.33,1388.94,198618.42,0.00,0.00,0.00,0.00,0.00),('5','97','616','124758',2486240,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124758',2486241,'1722','237',436904.75,437568.19,663.44,94871.92,0.00,0.00,0.00,0.00,0.00),('5','97','616','124758',2486242,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124758',2486243,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124758',2486244,'1725','237',299754.47,300182.70,428.23,61236.89,0.00,0.00,0.00,0.00,0.00),('5','97','617','124758',2486245,'1726','237',561078.38,561078.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124758',2486246,'1727','237',234814.92,234814.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124758',2486247,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124758',2486248,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124758',2486249,'1730','238',380354.94,381090.76,735.82,165559.50,0.00,0.00,0.00,0.00,0.00),('5','97','619','124758',2486250,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124761',2486278,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124761',2486279,'1714','237',930013.86,931019.56,1005.70,143815.10,0.00,0.00,0.00,0.00,0.00),('5','97','614','124761',2486280,'1715','237',478948.59,480071.95,1123.36,160640.48,0.00,0.00,0.00,0.00,0.00),('5','97','614','124761',2486281,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124761',2486282,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124761',2486283,'1718','237',728895.42,728895.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124761',2486284,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124761',2486285,'1720','237',726803.33,726803.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124761',2486286,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124761',2486287,'1722','237',437568.19,438641.19,1073.00,153439.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124761',2486288,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124761',2486289,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124761',2486290,'1725','237',300182.70,301426.08,1243.38,177803.34,0.00,0.00,0.00,0.00,0.00),('5','97','617','124761',2486291,'1726','237',561078.38,561078.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124761',2486292,'1727','237',234814.92,234814.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','124761',2486293,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124761',2486294,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124761',2486295,'1730','238',381090.76,381260.50,169.74,38191.50,0.00,0.00,0.00,0.00,0.00),('5','97','619','124761',2486296,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124815',2487422,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','124815',2487423,'1714','237',931019.56,932554.50,1534.94,219496.42,0.00,0.00,0.00,0.00,0.00),('5','97','614','124815',2487424,'1715','237',480071.95,482410.04,2338.09,334346.87,0.00,0.00,0.00,0.00,0.00),('5','97','614','124815',2487425,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124815',2487426,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124815',2487427,'1718','237',728895.42,728895.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124815',2487428,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','124815',2487429,'1720','237',726803.33,728171.31,1367.98,195621.14,0.00,0.00,0.00,0.00,0.00),('5','97','616','124815',2487430,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124815',2487431,'1722','237',438641.19,439893.97,1252.78,179147.54,0.00,0.00,0.00,0.00,0.00),('5','97','616','124815',2487432,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124815',2487433,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','124815',2487434,'1725','237',301426.08,302966.27,1540.19,220247.17,0.00,0.00,0.00,0.00,0.00),('5','97','617','124815',2487435,'1726','237',561431.83,562051.53,619.70,88617.10,0.00,0.00,0.00,0.00,0.00),('5','97','617','124815',2487436,'1727','237',234814.92,235507.96,693.04,99104.72,0.00,0.00,0.00,0.00,0.00),('5','97','617','124815',2487437,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124815',2487438,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','124815',2487439,'1730','238',381260.50,382030.77,770.27,173310.75,0.00,0.00,0.00,0.00,0.00),('5','97','619','124815',2487440,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','125500',2500552,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','125500',2500553,'1714','237',932554.50,934559.87,2005.37,286767.91,0.00,0.00,0.00,0.00,0.00),('5','97','614','125500',2500554,'1715','237',482410.04,482410.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','125500',2500555,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125500',2500556,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125500',2500557,'1718','237',728895.42,731333.18,2437.76,348599.68,0.00,0.00,0.00,0.00,0.00),('5','97','615','125500',2500558,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125500',2500559,'1720','237',728171.31,731048.58,2877.27,411449.61,0.00,0.00,0.00,0.00,0.00),('5','97','616','125500',2500560,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125500',2500561,'1722','237',439893.97,440459.52,565.55,80873.65,0.00,0.00,0.00,0.00,0.00),('5','97','616','125500',2500562,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125500',2500563,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125500',2500564,'1725','237',302966.27,304688.81,1722.54,246323.22,0.00,0.00,0.00,0.00,0.00),('5','97','617','125500',2500565,'1726','237',562051.53,562051.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','125500',2500566,'1727','237',235507.96,235507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','125500',2500567,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','125500',2500568,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','125500',2500569,'1730','238',382030.77,383360.39,1329.62,299164.50,0.00,0.00,0.00,0.00,0.00),('5','97','619','125500',2500570,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','125501',2500571,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','125501',2500572,'1714','237',934559.87,936109.25,1549.38,221561.34,0.00,0.00,0.00,0.00,0.00),('5','97','614','125501',2500573,'1715','237',482410.04,484013.63,1603.59,229313.37,0.00,0.00,0.00,0.00,0.00),('5','97','614','125501',2500574,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125501',2500575,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125501',2500576,'1718','237',731333.18,731333.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125501',2500577,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125501',2500578,'1720','237',731048.58,732749.48,1700.90,243228.70,0.00,0.00,0.00,0.00,0.00),('5','97','616','125501',2500579,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125501',2500580,'1722','237',440459.52,441569.55,1110.03,158734.29,0.00,0.00,0.00,0.00,0.00),('5','97','616','125501',2500581,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125501',2500582,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125501',2500583,'1725','237',304688.81,305612.97,924.16,132154.88,0.00,0.00,0.00,0.00,0.00),('5','97','617','125501',2500584,'1726','237',562051.53,562791.45,739.92,105808.56,0.00,0.00,0.00,0.00,0.00),('5','97','617','125501',2500585,'1727','237',235507.96,235507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','125501',2500586,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','125501',2500587,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','125501',2500588,'1730','238',383360.39,384597.37,1236.98,278320.50,0.00,0.00,0.00,0.00,0.00),('5','97','619','125501',2500589,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','125622',2502894,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','125622',2502895,'1714','237',936109.25,937664.08,1554.83,222340.69,0.00,0.00,0.00,0.00,0.00),('5','97','614','125622',2502896,'1715','237',484013.63,485843.57,1829.94,261681.42,0.00,0.00,0.00,0.00,0.00),('5','97','614','125622',2502897,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125622',2502898,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125622',2502899,'1718','237',731333.18,731816.19,483.01,69070.43,0.00,0.00,0.00,0.00,0.00),('5','97','615','125622',2502900,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','125622',2502901,'1720','237',732749.48,734412.69,1663.21,237839.03,0.00,0.00,0.00,0.00,0.00),('5','97','616','125622',2502902,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125622',2502903,'1722','237',441569.55,442642.96,1073.41,153497.63,0.00,0.00,0.00,0.00,0.00),('5','97','616','125622',2502904,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125622',2502905,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','125622',2502906,'1725','237',305612.97,306505.49,892.52,127630.36,0.00,0.00,0.00,0.00,0.00),('5','97','617','125622',2502907,'1726','237',562791.45,563133.37,341.92,48894.56,0.00,0.00,0.00,0.00,0.00),('5','97','617','125622',2502908,'1727','237',235507.96,235507.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','125622',2502909,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','125622',2502910,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','125622',2502911,'1730','238',384597.37,385223.17,625.80,140805.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','125622',2502912,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','128605',2562908,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','128605',2562909,'1714','237',937664.08,939668.25,2004.17,286596.31,0.00,0.00,0.00,0.00,0.00),('5','97','614','128605',2562910,'1715','237',485843.57,488326.53,2482.96,355063.28,0.00,0.00,0.00,0.00,0.00),('5','97','614','128605',2562911,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128605',2562912,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128605',2562913,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128605',2562914,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128605',2562915,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128605',2562916,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128605',2562917,'1722','237',442642.96,443276.37,633.41,90577.63,0.00,0.00,0.00,0.00,0.00),('5','97','616','128605',2562918,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128605',2562919,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128605',2562920,'1725','237',306505.49,308154.27,1648.78,235775.54,0.00,0.00,0.00,0.00,0.00),('5','97','617','128605',2562921,'1726','237',563133.37,564178.44,1045.07,149445.01,0.00,0.00,0.00,0.00,0.00),('5','97','617','128605',2562922,'1727','237',235507.96,235738.51,230.55,32968.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','128605',2562923,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','128605',2562924,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','128605',2562925,'1730','238',385223.17,385684.37,461.20,103770.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','128605',2562926,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','128610',2563045,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','128610',2563046,'1714','237',939668.25,941320.74,1652.49,236306.07,0.00,0.00,0.00,0.00,0.00),('5','97','614','128610',2563047,'1715','237',488326.53,490364.09,2037.56,291371.08,0.00,0.00,0.00,0.00,0.00),('5','97','614','128610',2563048,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128610',2563049,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128610',2563050,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128610',2563051,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128610',2563052,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128610',2563053,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128610',2563054,'1722','237',443276.37,443703.94,427.57,61142.51,0.00,0.00,0.00,0.00,0.00),('5','97','616','128610',2563055,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128610',2563056,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128610',2563057,'1725','237',308154.27,309961.10,1806.83,258376.69,0.00,0.00,0.00,0.00,0.00),('5','97','617','128610',2563058,'1726','237',564178.44,564588.87,410.43,58691.49,0.00,0.00,0.00,0.00,0.00),('5','97','617','128610',2563059,'1727','237',235738.51,236290.44,551.93,78925.99,0.00,0.00,0.00,0.00,0.00),('5','97','617','128610',2563060,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','128610',2563061,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','128610',2563062,'1730','238',385684.37,386674.51,990.14,222781.50,0.00,0.00,0.00,0.00,0.00),('5','97','619','128610',2563063,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','128619',2563253,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','128619',2563254,'1714','237',941320.74,942577.54,1256.80,179722.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','128619',2563255,'1715','237',490364.09,492495.63,2131.54,304810.22,0.00,0.00,0.00,0.00,0.00),('5','97','614','128619',2563256,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128619',2563257,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128619',2563258,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128619',2563259,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','128619',2563260,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128619',2563261,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128619',2563262,'1722','237',443703.94,444431.69,727.75,104068.25,0.00,0.00,0.00,0.00,0.00),('5','97','616','128619',2563263,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128619',2563264,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','128619',2563265,'1725','237',309961.10,312755.10,2794.00,399542.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','128619',2563266,'1726','237',564588.87,565189.61,600.74,85905.82,0.00,0.00,0.00,0.00,0.00),('5','97','617','128619',2563267,'1727','237',236290.44,237892.85,1602.41,229144.63,0.00,0.00,0.00,0.00,0.00),('5','97','617','128619',2563268,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','128619',2563269,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','128619',2563270,'1730','238',386674.51,387207.72,533.21,119972.25,0.00,0.00,0.00,0.00,0.00),('5','97','619','128619',2563271,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129022',2571498,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129022',2571499,'1714','237',942577.54,942577.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129022',2571500,'1715','237',492495.63,492495.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129022',2571501,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129022',2571502,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129022',2571503,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129022',2571504,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129022',2571505,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129022',2571506,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129022',2571507,'1722','237',444431.69,446760.84,2329.15,333068.45,0.00,0.00,0.00,0.00,0.00),('5','97','616','129022',2571508,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129022',2571509,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129022',2571510,'1725','237',312755.10,315356.68,2601.58,372025.94,0.00,0.00,0.00,0.00,0.00),('5','97','617','129022',2571511,'1726','237',565189.61,567902.13,2712.52,387890.36,0.00,0.00,0.00,0.00,0.00),('5','97','617','129022',2571512,'1727','237',237892.85,239653.98,1761.13,251841.59,0.00,0.00,0.00,0.00,0.00),('5','97','617','129022',2571513,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129022',2571514,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129022',2571515,'1730','238',387207.72,387635.76,428.04,92028.60,0.00,0.00,0.00,0.00,0.00),('5','97','619','129022',2571516,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129029',2571588,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129029',2571589,'1714','237',942577.54,942577.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129029',2571590,'1715','237',492495.63,492495.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129029',2571591,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129029',2571592,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129029',2571593,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129029',2571594,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129029',2571595,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129029',2571596,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129029',2571597,'1722','237',446760.84,448817.83,2056.99,294149.57,0.00,0.00,0.00,0.00,0.00),('5','97','616','129029',2571598,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129029',2571599,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129029',2571600,'1725','237',315356.68,317625.17,2268.49,324394.07,0.00,0.00,0.00,0.00,0.00),('5','97','617','129029',2571601,'1726','237',567902.13,569486.15,1584.02,226514.86,0.00,0.00,0.00,0.00,0.00),('5','97','617','129029',2571602,'1727','237',239653.98,241067.39,1413.41,202117.63,0.00,0.00,0.00,0.00,0.00),('5','97','617','129029',2571603,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129029',2571604,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129029',2571605,'1730','238',387635.76,388664.32,1028.56,221140.40,0.00,0.00,0.00,0.00,0.00),('5','97','619','129029',2571606,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129150',2574121,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129150',2574122,'1714','237',942577.54,942577.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129150',2574123,'1715','237',492495.63,492495.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129150',2574124,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129150',2574125,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129150',2574126,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129150',2574127,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129150',2574128,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129150',2574129,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129150',2574130,'1722','237',448817.83,450569.57,1751.74,250498.82,0.00,0.00,0.00,0.00,0.00),('5','97','616','129150',2574131,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129150',2574132,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129150',2574133,'1725','237',317625.17,319897.48,2272.31,324940.33,0.00,0.00,0.00,0.00,0.00),('5','97','617','129150',2574134,'1726','237',569486.15,571236.70,1750.55,250328.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','129150',2574135,'1727','237',241067.39,242651.38,1583.99,226510.57,0.00,0.00,0.00,0.00,0.00),('5','97','617','129150',2574136,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129150',2574137,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129150',2574138,'1730','238',388664.32,389079.45,415.13,93404.25,0.00,0.00,0.00,0.00,0.00),('5','97','619','129150',2574139,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129152',2574155,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129152',2574156,'1714','237',942577.54,942577.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129152',2574157,'1715','237',492495.63,492495.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129152',2574158,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129152',2574159,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129152',2574160,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129152',2574161,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129152',2574162,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129152',2574163,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129152',2574164,'1722','237',450569.57,452635.31,2065.74,295400.82,0.00,0.00,0.00,0.00,0.00),('5','97','616','129152',2574165,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129152',2574166,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129152',2574167,'1725','237',319897.48,322483.79,2586.31,369842.33,0.00,0.00,0.00,0.00,0.00),('5','97','617','129152',2574168,'1726','237',571236.70,572637.73,1401.03,200347.29,0.00,0.00,0.00,0.00,0.00),('5','97','617','129152',2574169,'1727','237',242651.38,244100.64,1449.26,207244.18,0.00,0.00,0.00,0.00,0.00),('5','97','617','129152',2574170,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129152',2574171,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129152',2574172,'1730','238',389079.45,389420.67,341.22,76774.50,0.00,0.00,0.00,0.00,0.00),('5','97','619','129152',2574173,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129153',2574174,'1713','237',115894.82,115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129153',2574175,'1714','237',942577.54,942577.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129153',2574176,'1715','237',492495.63,492495.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129153',2574177,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129153',2574178,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129153',2574179,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129153',2574180,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129153',2574181,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129153',2574182,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129153',2574183,'1722','237',452635.31,454627.28,1991.97,284851.71,0.00,0.00,0.00,0.00,0.00),('5','97','616','129153',2574184,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129153',2574185,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129153',2574186,'1725','237',322483.79,324999.90,2516.11,359803.73,0.00,0.00,0.00,0.00,0.00),('5','97','617','129153',2574187,'1726','237',572637.73,574727.78,2090.05,298877.15,0.00,0.00,0.00,0.00,0.00),('5','97','617','129153',2574188,'1727','237',244100.64,245354.39,1253.75,179286.25,0.00,0.00,0.00,0.00,0.00),('5','97','617','129153',2574189,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129153',2574190,'1729','238',294706.00,294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129153',2574191,'1730','238',389420.67,390171.40,750.73,168914.25,0.00,0.00,0.00,0.00,0.00),('5','97','619','129153',2574192,'1731','239',42481.38,42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129154',2574193,'1713','237',115894.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129154',2574194,'1714','237',942577.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129154',2574195,'1715','237',492495.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','129154',2574196,'1716','237',747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129154',2574197,'1717','237',200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129154',2574198,'1718','237',731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129154',2574199,'1719','237',175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','129154',2574200,'1720','237',734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129154',2574201,'1721','237',76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129154',2574202,'1722','237',454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129154',2574203,'1723','237',247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129154',2574204,'1724','237',323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','129154',2574205,'1725','237',324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','129154',2574206,'1726','237',574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','129154',2574207,'1727','237',245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','129154',2574208,'1728','237',199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129154',2574209,'1729','238',294706.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','129154',2574210,'1730','238',390171.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','129154',2574211,'1731','239',42481.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','176806',3476044,'1713','237',115894.82,117994.82,2090.00,298870.00,0.00,0.00,10.00,0.00,0.00),('5','97','614','176806',3476045,'1714','237',942577.54,945877.54,3300.00,471900.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','176806',3476046,'1715','237',492495.63,492495.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','176806',3476047,'1716','237',747944.55,747944.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','176806',3476048,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','176806',3476049,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','176806',3476050,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','176806',3476051,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176806',3476052,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176806',3476053,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176806',3476054,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176806',3476055,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176806',3476056,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','176806',3476057,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','176806',3476058,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','176806',3476059,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','176806',3476060,'1729','238',294706.00,297906.00,3190.00,717750.00,0.00,0.00,10.00,0.00,0.00),('5','97','618','176806',3476061,'1730','238',390171.40,390171.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','176806',3476062,'1731','239',42481.38,45981.38,3490.00,959750.00,0.00,0.00,10.00,0.00,0.00),('5','97','614','176842',3476832,'1713','237',117994.82,117994.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','176842',3476833,'1714','237',945877.54,948577.54,2700.00,386100.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','176842',3476834,'1715','237',492495.63,492495.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','176842',3476835,'1716','237',747944.55,749954.55,2010.00,287430.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','176842',3476836,'1717','237',200407.53,200407.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','176842',3476837,'1718','237',731816.19,731816.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','176842',3476838,'1719','237',175043.76,175043.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','176842',3476839,'1720','237',734412.69,734412.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176842',3476840,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176842',3476841,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176842',3476842,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176842',3476843,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','176842',3476844,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','176842',3476845,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','176842',3476846,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','176842',3476847,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','176842',3476848,'1729','238',297906.00,298906.00,1000.00,225000.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','176842',3476849,'1730','238',390171.40,390171.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','176842',3476850,'1731','239',45981.38,45981.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','177656',3492772,'1713','237',1377181.59,1378970.68,1789.09,289832.58,0.00,0.00,0.00,0.00,0.00),('5','97','614','177656',3492773,'1714','237',1025289.94,1026631.43,1341.49,217321.38,0.00,0.00,0.00,0.00,0.00),('5','97','614','177656',3492774,'1715','237',1160167.25,1162363.81,2196.56,355842.72,0.00,0.00,0.00,0.00,0.00),('5','97','614','177656',3492775,'1716','237',1298487.63,1299813.60,1325.97,214807.14,0.00,0.00,0.00,0.00,0.00),('5','97','615','177656',3492776,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177656',3492777,'1718','237',605073.16,606580.91,1507.75,244255.50,0.00,0.00,0.00,0.00,0.00),('5','97','615','177656',3492778,'1719','237',411078.63,412069.05,990.42,160448.04,0.00,0.00,0.00,0.00,0.00),('5','97','615','177656',3492779,'1720','237',788649.94,788899.02,249.08,40350.96,0.00,0.00,0.00,0.00,0.00),('5','97','616','177656',3492780,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177656',3492781,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177656',3492782,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177656',3492783,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177656',3492784,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177656',3492785,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177656',3492786,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177656',3492787,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','177656',3492788,'1729','238',672101.08,672441.60,340.52,76617.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','177656',3492789,'1730','238',390171.40,390171.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','177656',3492790,'1731','239',45981.38,45981.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','177687',3493346,'1713','237',1378970.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','177687',3493347,'1714','237',1026631.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','177687',3493348,'1715','237',1162363.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','177687',3493349,'1716','237',1299813.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177687',3493350,'1717','237',410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177687',3493351,'1718','237',606580.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177687',3493352,'1719','237',412069.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177687',3493353,'1720','237',788899.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177687',3493354,'1721','237',76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177687',3493355,'1722','237',454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177687',3493356,'1723','237',247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177687',3493357,'1724','237',323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177687',3493358,'1725','237',324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177687',3493359,'1726','237',574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177687',3493360,'1727','237',245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177687',3493361,'1728','237',199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','177687',3493362,'1729','238',672441.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','177687',3493363,'1730','238',390171.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','177687',3493364,'1731','239',45981.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','177691',3493441,'1713','237',1378970.68,1379679.90,709.22,114893.64,0.00,0.00,0.00,0.00,0.00),('5','97','614','177691',3493442,'1714','237',1026631.43,1027941.30,1309.87,212198.94,0.00,0.00,0.00,0.00,0.00),('5','97','614','177691',3493443,'1715','237',1162363.81,1163470.00,1106.19,179202.78,0.00,0.00,0.00,0.00,0.00),('5','97','614','177691',3493444,'1716','237',1299813.60,1299813.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177691',3493445,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177691',3493446,'1718','237',606580.91,607554.55,973.64,157729.68,0.00,0.00,0.00,0.00,0.00),('5','97','615','177691',3493447,'1719','237',412069.05,412483.18,414.13,67089.06,0.00,0.00,0.00,0.00,0.00),('5','97','615','177691',3493448,'1720','237',788899.02,788899.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177691',3493449,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177691',3493450,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177691',3493451,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177691',3493452,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177691',3493453,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177691',3493454,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177691',3493455,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177691',3493456,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','177691',3493457,'1729','238',672441.60,672597.84,156.24,35935.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','177691',3493458,'1730','238',390171.40,390171.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','177691',3493459,'1731','239',45981.38,45981.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','177698',3493600,'1713','237',1379679.90,1380262.87,582.97,94441.14,0.00,0.00,0.00,0.00,0.00),('5','97','614','177698',3493601,'1714','237',1027941.30,1028771.31,830.01,134461.62,0.00,0.00,0.00,0.00,0.00),('5','97','614','177698',3493602,'1715','237',1163470.00,1165009.66,1539.66,249424.92,0.00,0.00,0.00,0.00,0.00),('5','97','614','177698',3493603,'1716','237',1299813.60,1299813.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177698',3493604,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177698',3493605,'1718','237',607554.55,608934.72,1380.17,223587.54,0.00,0.00,0.00,0.00,0.00),('5','97','615','177698',3493606,'1719','237',412483.18,412483.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','177698',3493607,'1720','237',788899.02,788899.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177698',3493608,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177698',3493609,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177698',3493610,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177698',3493611,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','177698',3493612,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177698',3493613,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177698',3493614,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','177698',3493615,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','177698',3493616,'1729','238',672597.84,673362.34,764.50,175835.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','177698',3493617,'1730','238',390171.40,390171.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','177698',3493618,'1731','239',45981.38,45981.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','179606',3528978,'1713','237',1380262.87,1389799.87,9537.00,1544994.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','179606',3528979,'1714','237',1028771.31,1039891.31,11120.00,1801440.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','179606',3528980,'1715','237',1165009.66,1165009.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','179606',3528981,'1716','237',1299813.60,1299813.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','179606',3528982,'1717','237',410698.91,413998.91,3300.00,534600.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','179606',3528983,'1718','237',608934.72,608934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','179606',3528984,'1719','237',412483.18,417983.18,5500.00,891000.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','179606',3528985,'1720','237',788899.02,788899.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179606',3528986,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179606',3528987,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179606',3528988,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179606',3528989,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179606',3528990,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','179606',3528991,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','179606',3528992,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','179606',3528993,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','179606',3528994,'1729','238',673362.34,673362.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','179606',3528995,'1730','238',390171.40,395771.40,5600.00,1288000.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','179606',3528996,'1731','239',45981.38,47991.38,2010.00,462300.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','179627',3529386,'1713','237',1389799.87,1389799.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','179627',3529387,'1714','237',1039891.31,1039891.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','179627',3529388,'1715','237',1165009.66,1165009.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','179627',3529389,'1716','237',1299813.60,1299813.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','179627',3529390,'1717','237',413998.91,413998.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','179627',3529391,'1718','237',608934.72,608934.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','179627',3529392,'1719','237',417983.18,417983.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','179627',3529393,'1720','237',788899.02,788899.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179627',3529394,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179627',3529395,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179627',3529396,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179627',3529397,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','179627',3529398,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','179627',3529399,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','179627',3529400,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','179627',3529401,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','179627',3529402,'1729','238',673362.34,673362.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','179627',3529403,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','179627',3529404,'1731','239',47991.38,47991.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','181695',3568043,'1713','237',1402981.53,1402981.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','181695',3568044,'1714','237',1061344.35,1061344.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','181695',3568045,'1715','237',1206006.65,1206006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','181695',3568046,'1716','237',1320043.62,1320043.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','181695',3568047,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','181695',3568048,'1718','237',635402.72,642804.32,7401.60,1206460.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','181695',3568049,'1719','237',425134.01,429882.40,4748.39,773987.57,0.00,0.00,0.00,0.00,0.00),('5','97','615','181695',3568050,'1720','237',799244.99,805504.36,6259.37,1020277.31,0.00,0.00,0.00,0.00,0.00),('5','97','616','181695',3568051,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','181695',3568052,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','181695',3568053,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','181695',3568054,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','181695',3568055,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','181695',3568056,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','181695',3568057,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','181695',3568058,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','181695',3568059,'1729','238',686633.03,687533.27,900.24,225060.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','181695',3568060,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','181695',3568061,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','181895',3571451,'1713','237',1402981.53,1402981.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','181895',3571452,'1714','237',1061344.35,1061344.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','181895',3571453,'1715','237',1206006.65,1206006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','181895',3571454,'1716','237',1320043.62,1320043.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','181895',3571455,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','181895',3571456,'1718','237',642804.32,653052.75,10248.43,1660245.66,0.00,0.00,0.00,0.00,0.00),('5','97','615','181895',3571457,'1719','237',429882.40,430611.92,729.52,118182.24,0.00,0.00,0.00,0.00,0.00),('5','97','615','181895',3571458,'1720','237',805504.36,807544.89,2040.53,330565.86,0.00,0.00,0.00,0.00,0.00),('5','97','616','181895',3571459,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','181895',3571460,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','181895',3571461,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','181895',3571462,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','181895',3571463,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','181895',3571464,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','181895',3571465,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','181895',3571466,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','181895',3571467,'1729','238',687533.27,687894.89,361.62,83172.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','181895',3571468,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','181895',3571469,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','182219',3577426,'1713','237',1402981.53,1408623.50,5641.97,919641.11,0.00,0.00,0.00,0.00,0.00),('5','97','614','182219',3577427,'1714','237',1061344.35,1070147.43,8803.08,1434902.04,0.00,0.00,0.00,0.00,0.00),('5','97','614','182219',3577428,'1715','237',1206006.65,1206006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','182219',3577429,'1716','237',1320043.62,1320043.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182219',3577430,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182219',3577431,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182219',3577432,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182219',3577433,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182219',3577434,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182219',3577435,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182219',3577436,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182219',3577437,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182219',3577438,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182219',3577439,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182219',3577440,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182219',3577441,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','182219',3577442,'1729','238',687894.89,688358.09,463.20,115800.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','182219',3577443,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','182219',3577444,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','182297',3578803,'1713','237',1408623.50,1413684.02,5060.52,824864.76,0.00,0.00,0.00,0.00,0.00),('5','97','614','182297',3578804,'1714','237',1070147.43,1076950.15,6802.72,1108843.36,0.00,0.00,0.00,0.00,0.00),('5','97','614','182297',3578805,'1715','237',1206006.65,1206006.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','182297',3578806,'1716','237',1320043.62,1320043.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182297',3578807,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182297',3578808,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182297',3578809,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182297',3578810,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182297',3578811,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182297',3578812,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182297',3578813,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182297',3578814,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182297',3578815,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182297',3578816,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182297',3578817,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182297',3578818,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','182297',3578819,'1729','238',688358.09,689203.06,844.97,211242.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','182297',3578820,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','182297',3578821,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','182914',3590106,'1713','237',1413684.02,1415380.82,1696.80,276578.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','182914',3590107,'1714','237',1076950.15,1078444.49,1494.34,243577.42,0.00,0.00,0.00,0.00,0.00),('5','97','614','182914',3590108,'1715','237',1206006.65,1210961.24,4954.59,807598.17,0.00,0.00,0.00,0.00,0.00),('5','97','614','182914',3590109,'1716','237',1320043.62,1324438.17,4394.55,716311.65,0.00,0.00,0.00,0.00,0.00),('5','97','615','182914',3590110,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182914',3590111,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182914',3590112,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182914',3590113,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182914',3590114,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182914',3590115,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182914',3590116,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182914',3590117,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182914',3590118,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182914',3590119,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182914',3590120,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182914',3590121,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','182914',3590122,'1729','238',689203.06,689585.97,382.91,95727.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','182914',3590123,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','182914',3590124,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','182978',3591362,'1713','237',1415380.82,1418669.33,3288.51,536027.13,0.00,0.00,0.00,0.00,0.00),('5','97','614','182978',3591363,'1714','237',1078444.49,1081771.87,3327.38,542362.94,0.00,0.00,0.00,0.00,0.00),('5','97','614','182978',3591364,'1715','237',1210961.24,1213456.34,2495.10,406701.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','182978',3591365,'1716','237',1324438.17,1327584.22,3146.05,512806.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','182978',3591366,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182978',3591367,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182978',3591368,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','182978',3591369,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182978',3591370,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182978',3591371,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182978',3591372,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182978',3591373,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','182978',3591374,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182978',3591375,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182978',3591376,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','182978',3591377,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','182978',3591378,'1729','238',689585.97,690316.82,730.85,182712.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','182978',3591379,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','182978',3591380,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','183151',3594397,'1713','237',1418669.33,1421260.09,2590.76,419703.12,0.00,0.00,0.00,0.00,0.00),('5','97','614','183151',3594398,'1714','237',1081771.87,1084366.85,2594.98,420386.76,0.00,0.00,0.00,0.00,0.00),('5','97','614','183151',3594399,'1715','237',1213456.34,1217997.42,4541.08,735654.96,0.00,0.00,0.00,0.00,0.00),('5','97','614','183151',3594400,'1716','237',1327584.22,1330686.76,3102.54,502611.48,0.00,0.00,0.00,0.00,0.00),('5','97','615','183151',3594401,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183151',3594402,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183151',3594403,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183151',3594404,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183151',3594405,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183151',3594406,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183151',3594407,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183151',3594408,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183151',3594409,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183151',3594410,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183151',3594411,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183151',3594412,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','183151',3594413,'1729','238',690316.82,690681.08,364.26,83779.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','183151',3594414,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','183151',3594415,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','183523',3600966,'1713','237',1421260.09,1425002.86,3742.77,610071.51,0.00,0.00,0.00,0.00,0.00),('5','97','614','183523',3600967,'1714','237',1084366.85,1089322.53,4955.68,807775.84,0.00,0.00,0.00,0.00,0.00),('5','97','614','183523',3600968,'1715','237',1217997.42,1222432.05,4434.63,722844.69,0.00,0.00,0.00,0.00,0.00),('5','97','614','183523',3600969,'1716','237',1330686.76,1333250.07,2563.31,417819.53,0.00,0.00,0.00,0.00,0.00),('5','97','615','183523',3600970,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183523',3600971,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183523',3600972,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183523',3600973,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183523',3600974,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183523',3600975,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183523',3600976,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183523',3600977,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183523',3600978,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183523',3600979,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183523',3600980,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183523',3600981,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','183523',3600982,'1729','238',690681.08,691203.87,522.79,138539.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','183523',3600983,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','183523',3600984,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','183632',3603218,'1713','237',1425002.86,1427639.31,2636.45,429741.35,0.00,0.00,0.00,0.00,0.00),('5','97','614','183632',3603219,'1714','237',1089322.53,1093264.19,3941.66,642490.58,0.00,0.00,0.00,0.00,0.00),('5','97','614','183632',3603220,'1715','237',1222432.05,1225372.01,2939.96,479213.48,0.00,0.00,0.00,0.00,0.00),('5','97','614','183632',3603221,'1716','237',1333250.07,1336184.57,2934.50,478323.50,0.00,0.00,0.00,0.00,0.00),('5','97','615','183632',3603222,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183632',3603223,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183632',3603224,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','183632',3603225,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183632',3603226,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183632',3603227,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183632',3603228,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183632',3603229,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','183632',3603230,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183632',3603231,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183632',3603232,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','183632',3603233,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','183632',3603234,'1729','238',691203.87,691516.15,312.28,82754.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','183632',3603235,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','183632',3603236,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','184445',3617732,'1713','237',1427639.31,1427639.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','184445',3617733,'1714','237',1093264.19,1093264.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','184445',3617734,'1715','237',1225372.01,1225372.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','184445',3617735,'1716','237',1336184.57,1336184.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184445',3617736,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184445',3617737,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184445',3617738,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184445',3617739,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184445',3617740,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184445',3617741,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184445',3617742,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184445',3617743,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184445',3617744,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184445',3617745,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184445',3617746,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184445',3617747,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','184445',3617748,'1729','238',691516.15,691969.50,453.35,120137.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','184445',3617749,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','184445',3617750,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','184446',3617751,'1713','237',1427639.31,1430746.35,3107.04,506447.52,0.00,0.00,0.00,0.00,0.00),('5','97','614','184446',3617752,'1714','237',1093264.19,1097021.40,3757.21,612425.23,0.00,0.00,0.00,0.00,0.00),('5','97','614','184446',3617753,'1715','237',1225372.01,1229069.33,3697.32,602663.16,0.00,0.00,0.00,0.00,0.00),('5','97','614','184446',3617754,'1716','237',1336184.57,1338768.45,2583.88,421172.44,0.00,0.00,0.00,0.00,0.00),('5','97','615','184446',3617755,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184446',3617756,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184446',3617757,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184446',3617758,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184446',3617759,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184446',3617760,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184446',3617761,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184446',3617762,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184446',3617763,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184446',3617764,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184446',3617765,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184446',3617766,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','184446',3617767,'1729','238',691969.50,692530.72,561.22,148723.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','184446',3617768,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','184446',3617769,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','184619',3620973,'1713','237',1430746.35,1434546.41,3800.06,619409.78,0.00,0.00,0.00,0.00,0.00),('5','97','614','184619',3620974,'1714','237',1097021.40,1102255.69,5234.29,853189.27,0.00,0.00,0.00,0.00,0.00),('5','97','614','184619',3620975,'1715','237',1229069.33,1234211.43,5142.10,838162.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','184619',3620976,'1716','237',1338768.45,1343145.03,4376.58,713382.54,0.00,0.00,0.00,0.00,0.00),('5','97','615','184619',3620977,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184619',3620978,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184619',3620979,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','184619',3620980,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184619',3620981,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184619',3620982,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184619',3620983,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184619',3620984,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','184619',3620985,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184619',3620986,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184619',3620987,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','184619',3620988,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','184619',3620989,'1729','238',692530.72,705958.03,13427.31,3423964.05,0.00,0.00,0.00,0.00,0.00),('5','97','618','184619',3620990,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','184619',3620991,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185223',3631402,'1713','237',1434546.41,1439755.92,5209.51,849150.13,0.00,0.00,0.00,0.00,0.00),('5','97','614','185223',3631403,'1714','237',1102255.69,1109718.37,7462.68,1216416.84,0.00,0.00,0.00,0.00,0.00),('5','97','614','185223',3631404,'1715','237',1234211.43,1234211.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185223',3631405,'1716','237',1343145.03,1343145.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185223',3631406,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185223',3631407,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185223',3631408,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185223',3631409,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185223',3631410,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185223',3631411,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185223',3631412,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185223',3631413,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185223',3631414,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185223',3631415,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185223',3631416,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185223',3631417,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','185223',3631418,'1729','238',705958.03,707231.00,1272.97,324607.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','185223',3631419,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','185223',3631420,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185283',3632183,'1713','237',1439755.92,1442258.02,2502.10,407842.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','185283',3632184,'1714','237',1109718.37,1113877.90,4159.53,678003.39,0.00,0.00,0.00,0.00,0.00),('5','97','614','185283',3632185,'1715','237',1234211.43,1234895.81,684.38,111553.94,0.00,0.00,0.00,0.00,0.00),('5','97','614','185283',3632186,'1716','237',1343145.03,1343724.38,579.35,94434.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','185283',3632187,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185283',3632188,'1718','237',653052.75,653052.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185283',3632189,'1719','237',430611.92,430611.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185283',3632190,'1720','237',807544.89,807544.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185283',3632191,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185283',3632192,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185283',3632193,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185283',3632194,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185283',3632195,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185283',3632196,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185283',3632197,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185283',3632198,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','185283',3632199,'1729','238',707231.00,707723.61,492.61,125615.55,0.00,0.00,0.00,0.00,0.00),('5','97','618','185283',3632200,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','185283',3632201,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185336',3633198,'1713','237',1442258.02,1444439.57,2181.55,355592.65,0.00,0.00,0.00,0.00,0.00),('5','97','614','185336',3633199,'1714','237',1113877.90,1118075.58,4197.68,684221.84,0.00,0.00,0.00,0.00,0.00),('5','97','614','185336',3633200,'1715','237',1234895.81,1239170.85,4275.04,696831.52,0.00,0.00,0.00,0.00,0.00),('5','97','614','185336',3633201,'1716','237',1343724.38,1346104.89,2380.51,388023.13,0.00,0.00,0.00,0.00,0.00),('5','97','615','185336',3633202,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185336',3633203,'1718','237',653052.75,654498.84,1446.09,235712.67,0.00,0.00,0.00,0.00,0.00),('5','97','615','185336',3633204,'1719','237',430611.92,432310.86,1698.94,276927.22,0.00,0.00,0.00,0.00,0.00),('5','97','615','185336',3633205,'1720','237',807544.89,808999.65,1454.76,237125.88,0.00,0.00,0.00,0.00,0.00),('5','97','616','185336',3633206,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185336',3633207,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185336',3633208,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185336',3633209,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185336',3633210,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185336',3633211,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185336',3633212,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185336',3633213,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','185336',3633214,'1729','238',707723.61,708675.47,951.86,242724.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','185336',3633215,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','185336',3633216,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185343',3633387,'1713','237',1444439.57,1444544.85,105.28,17160.64,0.00,0.00,0.00,0.00,0.00),('5','97','614','185343',3633388,'1714','237',1118075.58,1119697.99,1622.41,264452.83,0.00,0.00,0.00,0.00,0.00),('5','97','614','185343',3633389,'1715','237',1239170.85,1243884.23,4713.38,768280.94,0.00,0.00,0.00,0.00,0.00),('5','97','614','185343',3633390,'1716','237',1346104.89,1351384.06,5279.17,860504.71,0.00,0.00,0.00,0.00,0.00),('5','97','615','185343',3633391,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185343',3633392,'1718','237',654498.84,658321.28,3822.44,623057.72,0.00,0.00,0.00,0.00,0.00),('5','97','615','185343',3633393,'1719','237',432310.86,433901.99,1591.13,259354.19,0.00,0.00,0.00,0.00,0.00),('5','97','615','185343',3633394,'1720','237',808999.65,811672.41,2672.76,435659.88,0.00,0.00,0.00,0.00,0.00),('5','97','616','185343',3633395,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185343',3633396,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185343',3633397,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185343',3633398,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185343',3633399,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185343',3633400,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185343',3633401,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185343',3633402,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','185343',3633403,'1729','238',708675.47,710144.41,1468.94,374579.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','185343',3633404,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','185343',3633405,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185963',3644672,'1713','237',1444544.85,1444544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185963',3644673,'1714','237',1119697.99,1119697.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185963',3644674,'1715','237',1243884.23,1249261.53,5377.30,876499.90,0.00,0.00,0.00,0.00,0.00),('5','97','615','185963',3644675,'1716','237',1351384.06,1355811.11,4427.05,721609.15,0.00,0.00,0.00,0.00,0.00),('5','97','616','185963',3644676,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185963',3644677,'1718','237',658321.28,661422.04,3100.76,505423.88,0.00,0.00,0.00,0.00,0.00),('5','97','617','185963',3644678,'1719','237',433901.99,436010.90,2108.91,343752.33,0.00,0.00,0.00,0.00,0.00),('5','97','617','185963',3644679,'1720','237',811672.41,815275.14,3602.73,587244.99,0.00,0.00,0.00,0.00,0.00),('5','97','616','185963',3644680,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185963',3644681,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185963',3644682,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185963',3644683,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185963',3644684,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185963',3644685,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185963',3644686,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185963',3644687,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','185963',3644688,'1729','238',710144.41,711903.64,1759.23,448603.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','185963',3644689,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','185963',3644690,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185978',3644958,'1713','237',1444544.85,1444544.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','185978',3644959,'1714','237',1119697.99,1119697.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','185978',3644960,'1715','237',1249261.53,1252795.63,3534.10,576058.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','185978',3644961,'1716','237',1355811.11,1360019.30,4208.19,685934.97,0.00,0.00,0.00,0.00,0.00),('5','97','616','185978',3644962,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185978',3644963,'1718','237',661422.04,663614.23,2192.19,357326.97,0.00,0.00,0.00,0.00,0.00),('5','97','617','185978',3644964,'1719','237',436010.90,438050.62,2039.72,332474.36,0.00,0.00,0.00,0.00,0.00),('5','97','617','185978',3644965,'1720','237',815275.14,816920.92,1645.78,268262.14,0.00,0.00,0.00,0.00,0.00),('5','97','616','185978',3644966,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185978',3644967,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185978',3644968,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185978',3644969,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','185978',3644970,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185978',3644971,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185978',3644972,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','185978',3644973,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','185978',3644974,'1729','238',711903.64,712787.93,884.29,234336.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','185978',3644975,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','185978',3644976,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186021',3645689,'1713','237',1444544.85,1446687.39,2142.54,347091.48,0.00,0.00,0.00,0.00,0.00),('5','97','614','186021',3645690,'1714','237',1119697.99,1122367.84,2669.85,432515.70,0.00,0.00,0.00,0.00,0.00),('5','97','615','186021',3645691,'1715','237',1252795.63,1256963.34,4167.71,675169.02,0.00,0.00,0.00,0.00,0.00),('5','97','615','186021',3645692,'1716','237',1360019.30,1364061.05,4041.75,654763.50,0.00,0.00,0.00,0.00,0.00),('5','97','616','186021',3645693,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186021',3645694,'1718','237',663614.23,664361.05,746.82,120984.84,0.00,0.00,0.00,0.00,0.00),('5','97','617','186021',3645695,'1719','237',438050.62,438050.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186021',3645696,'1720','237',816920.92,818473.75,1552.83,251558.46,0.00,0.00,0.00,0.00,0.00),('5','97','616','186021',3645697,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186021',3645698,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186021',3645699,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186021',3645700,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186021',3645701,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186021',3645702,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186021',3645703,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186021',3645704,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186021',3645705,'1729','238',712787.93,714823.64,2035.71,539463.15,0.00,0.00,0.00,0.00,0.00),('5','97','618','186021',3645706,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186021',3645707,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186035',3645893,'1713','237',1446687.39,1450152.48,3465.09,561344.58,0.00,0.00,0.00,0.00,0.00),('5','97','614','186035',3645894,'1714','237',1122367.84,1126347.65,3979.81,644729.22,0.00,0.00,0.00,0.00,0.00),('5','97','615','186035',3645895,'1715','237',1256963.34,1257598.16,634.82,102840.84,0.00,0.00,0.00,0.00,0.00),('5','97','615','186035',3645896,'1716','237',1364061.05,1364061.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186035',3645897,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186035',3645898,'1718','237',664361.05,666340.03,1978.98,320594.76,0.00,0.00,0.00,0.00,0.00),('5','97','617','186035',3645899,'1719','237',438050.62,439679.62,1629.00,263898.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186035',3645900,'1720','237',818473.75,819377.61,903.86,146425.32,0.00,0.00,0.00,0.00,0.00),('5','97','616','186035',3645901,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186035',3645902,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186035',3645903,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186035',3645904,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186035',3645905,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186035',3645906,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186035',3645907,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186035',3645908,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186035',3645909,'1729','238',714823.64,715532.10,708.46,187741.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','186035',3645910,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186035',3645911,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186123',3647434,'1713','237',1450152.48,1453831.63,3679.15,596022.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','186123',3647435,'1714','237',1126347.65,1131599.89,5252.24,850862.88,0.00,0.00,0.00,0.00,0.00),('5','97','615','186123',3647436,'1715','237',1257598.16,1257598.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','186123',3647437,'1716','237',1364061.05,1364061.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186123',3647438,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186123',3647439,'1718','237',666340.03,667795.23,1455.20,235742.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','186123',3647440,'1719','237',439679.62,442689.12,3009.50,487539.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186123',3647441,'1720','237',819377.61,821707.33,2329.72,377414.64,0.00,0.00,0.00,0.00,0.00),('5','97','616','186123',3647442,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186123',3647443,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186123',3647444,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186123',3647445,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186123',3647446,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186123',3647447,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186123',3647448,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186123',3647449,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186123',3647450,'1729','238',715532.10,716947.74,1415.64,375144.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','186123',3647451,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186123',3647452,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186137',3647660,'1713','237',1453831.63,1459957.54,6125.91,992397.42,0.00,0.00,0.00,0.00,0.00),('5','97','614','186137',3647661,'1714','237',1131599.89,1138167.10,6567.21,1063888.02,0.00,0.00,0.00,0.00,0.00),('5','97','615','186137',3647662,'1715','237',1257598.16,1257598.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','186137',3647663,'1716','237',1364061.05,1364061.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186137',3647664,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186137',3647665,'1718','237',667795.23,667795.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186137',3647666,'1719','237',442689.12,443804.65,1115.53,180715.86,0.00,0.00,0.00,0.00,0.00),('5','97','617','186137',3647667,'1720','237',821707.33,823855.19,2147.86,347953.32,0.00,0.00,0.00,0.00,0.00),('5','97','616','186137',3647668,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186137',3647669,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186137',3647670,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186137',3647671,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186137',3647672,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186137',3647673,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186137',3647674,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186137',3647675,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186137',3647676,'1729','238',716947.74,718224.12,1276.38,338240.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','186137',3647677,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186137',3647678,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186212',3648933,'1713','237',1459957.54,1464654.13,4696.59,760847.58,0.00,0.00,0.00,0.00,0.00),('5','97','614','186212',3648934,'1714','237',1138167.10,1143654.09,5486.99,888892.38,0.00,0.00,0.00,0.00,0.00),('5','97','615','186212',3648935,'1715','237',1257598.16,1257598.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','186212',3648936,'1716','237',1364061.05,1364061.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186212',3648937,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186212',3648938,'1718','237',667795.23,667795.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186212',3648939,'1719','237',443804.65,443804.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186212',3648940,'1720','237',823855.19,823855.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186212',3648941,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186212',3648942,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186212',3648943,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186212',3648944,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186212',3648945,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186212',3648946,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186212',3648947,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186212',3648948,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186212',3648949,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186212',3648950,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186212',3648951,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186303',3650544,'1713','237',1464654.13,1467591.84,2937.71,475909.02,0.00,0.00,0.00,0.00,0.00),('5','97','614','186303',3650545,'1714','237',1143654.09,1147324.82,3670.73,594658.26,0.00,0.00,0.00,0.00,0.00),('5','97','615','186303',3650546,'1715','237',1257598.16,1260181.09,2582.93,418434.66,0.00,0.00,0.00,0.00,0.00),('5','97','615','186303',3650547,'1716','237',1364061.05,1367305.63,3244.58,525621.96,0.00,0.00,0.00,0.00,0.00),('5','97','616','186303',3650548,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186303',3650549,'1718','237',667795.23,667795.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186303',3650550,'1719','237',443804.65,443804.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186303',3650551,'1720','237',823855.19,823855.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186303',3650552,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186303',3650553,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186303',3650554,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186303',3650555,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186303',3650556,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186303',3650557,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186303',3650558,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186303',3650559,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186303',3650560,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186303',3650561,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186303',3650562,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186609',3655712,'1713','237',1467591.84,1469815.82,2223.98,360284.76,0.00,0.00,0.00,0.00,0.00),('5','97','614','186609',3655713,'1714','237',1147324.82,1150323.67,2998.85,485813.70,0.00,0.00,0.00,0.00,0.00),('5','97','615','186609',3655714,'1715','237',1260181.09,1262770.15,2589.06,419427.72,0.00,0.00,0.00,0.00,0.00),('5','97','615','186609',3655715,'1716','237',1367305.63,1370053.30,2747.67,445122.54,0.00,0.00,0.00,0.00,0.00),('5','97','616','186609',3655716,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186609',3655717,'1718','237',667795.23,667795.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186609',3655718,'1719','237',443804.65,444373.42,568.77,92140.74,0.00,0.00,0.00,0.00,0.00),('5','97','617','186609',3655719,'1720','237',823855.19,824920.81,1065.62,172630.44,0.00,0.00,0.00,0.00,0.00),('5','97','616','186609',3655720,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186609',3655721,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186609',3655722,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186609',3655723,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186609',3655724,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186609',3655725,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186609',3655726,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186609',3655727,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186609',3655728,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186609',3655729,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186609',3655730,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186811',3659110,'1713','237',1469815.82,1471514.04,1698.22,275111.64,0.00,0.00,0.00,0.00,0.00),('5','97','614','186811',3659111,'1714','237',1150323.67,1154572.36,4248.69,688287.78,0.00,0.00,0.00,0.00,0.00),('5','97','615','186811',3659112,'1715','237',1262770.15,1266427.11,3656.96,592427.52,0.00,0.00,0.00,0.00,0.00),('5','97','615','186811',3659113,'1716','237',1370053.30,1371495.64,1442.34,233659.08,0.00,0.00,0.00,0.00,0.00),('5','97','616','186811',3659114,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186811',3659115,'1718','237',667795.23,667795.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186811',3659116,'1719','237',444373.42,445854.32,1480.90,239905.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','186811',3659117,'1720','237',824920.81,826565.99,1645.18,266519.16,0.00,0.00,0.00,0.00,0.00),('5','97','616','186811',3659118,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186811',3659119,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186811',3659120,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186811',3659121,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186811',3659122,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186811',3659123,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186811',3659124,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186811',3659125,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186811',3659126,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186811',3659127,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186811',3659128,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','186963',3661711,'1713','237',1471514.04,1474641.37,3127.33,506627.46,0.00,0.00,0.00,0.00,0.00),('5','97','614','186963',3661712,'1714','237',1154572.36,1157582.65,3010.29,487666.98,0.00,0.00,0.00,0.00,0.00),('5','97','615','186963',3661713,'1715','237',1266427.11,1268815.08,2387.97,386851.14,0.00,0.00,0.00,0.00,0.00),('5','97','615','186963',3661714,'1716','237',1371495.64,1371495.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186963',3661715,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186963',3661716,'1718','237',667795.23,669238.61,1443.38,233827.56,0.00,0.00,0.00,0.00,0.00),('5','97','617','186963',3661717,'1719','237',445854.32,448038.52,2184.20,353840.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','186963',3661718,'1720','237',826565.99,828036.17,1470.18,238169.16,0.00,0.00,0.00,0.00,0.00),('5','97','616','186963',3661719,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186963',3661720,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186963',3661721,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186963',3661722,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','186963',3661723,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186963',3661724,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186963',3661725,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','186963',3661726,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186963',3661727,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','186963',3661728,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','186963',3661729,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','187471',3670693,'1713','237',1474641.37,1475158.65,517.28,83799.36,0.00,0.00,0.00,0.00,0.00),('5','97','614','187471',3670694,'1714','237',1157582.65,1161052.44,3469.79,562105.98,0.00,0.00,0.00,0.00,0.00),('5','97','615','187471',3670695,'1715','237',1268815.08,1273284.13,4469.05,723986.10,0.00,0.00,0.00,0.00,0.00),('5','97','615','187471',3670696,'1716','237',1371495.64,1371495.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187471',3670697,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187471',3670698,'1718','237',669238.61,672417.71,3179.10,515014.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','187471',3670699,'1719','237',448038.52,448038.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187471',3670700,'1720','237',828036.17,828833.82,797.65,129219.30,0.00,0.00,0.00,0.00,0.00),('5','97','616','187471',3670701,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187471',3670702,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187471',3670703,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187471',3670704,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187471',3670705,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187471',3670706,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187471',3670707,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187471',3670708,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187471',3670709,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187471',3670710,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','187471',3670711,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','187490',3670985,'1713','237',1475158.65,1476522.37,1363.72,220922.64,0.00,0.00,0.00,0.00,0.00),('5','97','614','187490',3670986,'1714','237',1161052.44,1161052.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','187490',3670987,'1715','237',1273284.13,1278450.61,5166.48,836969.76,0.00,0.00,0.00,0.00,0.00),('5','97','615','187490',3670988,'1716','237',1371495.64,1371495.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187490',3670989,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187490',3670990,'1718','237',672417.71,675683.30,3265.59,529025.58,0.00,0.00,0.00,0.00,0.00),('5','97','617','187490',3670991,'1719','237',448038.52,450209.08,2170.56,351630.72,0.00,0.00,0.00,0.00,0.00),('5','97','617','187490',3670992,'1720','237',828833.82,832205.37,3371.55,546191.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','187490',3670993,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187490',3670994,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187490',3670995,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187490',3670996,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187490',3670997,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187490',3670998,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187490',3670999,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187490',3671000,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187490',3671001,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187490',3671002,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','187490',3671003,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','187555',3672209,'1713','237',1476522.37,1476522.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','187555',3672210,'1714','237',1161052.44,1161052.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','187555',3672211,'1715','237',1278450.61,1283661.09,5210.48,844097.76,0.00,0.00,0.00,0.00,0.00),('5','97','615','187555',3672212,'1716','237',1371495.64,1371495.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187555',3672213,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187555',3672214,'1718','237',675683.30,679685.40,4002.10,648340.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','187555',3672215,'1719','237',450209.08,452045.30,1836.22,297467.64,0.00,0.00,0.00,0.00,0.00),('5','97','617','187555',3672216,'1720','237',832205.37,835097.22,2891.85,468479.70,0.00,0.00,0.00,0.00,0.00),('5','97','616','187555',3672217,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187555',3672218,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187555',3672219,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187555',3672220,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187555',3672221,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187555',3672222,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187555',3672223,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187555',3672224,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187555',3672225,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187555',3672226,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','187555',3672227,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','187620',3673173,'1713','237',1476522.37,1477598.35,1075.98,174308.76,0.00,0.00,0.00,0.00,0.00),('5','97','614','187620',3673174,'1714','237',1161052.44,1161052.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','187620',3673175,'1715','237',1283661.09,1288707.11,5046.02,817455.24,0.00,0.00,0.00,0.00,0.00),('5','97','615','187620',3673176,'1716','237',1371495.64,1371495.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187620',3673177,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187620',3673178,'1718','237',679685.40,682149.74,2464.34,399223.08,0.00,0.00,0.00,0.00,0.00),('5','97','617','187620',3673179,'1719','237',452045.30,453648.36,1603.06,259695.72,0.00,0.00,0.00,0.00,0.00),('5','97','617','187620',3673180,'1720','237',835097.22,836962.08,1864.86,302107.32,0.00,0.00,0.00,0.00,0.00),('5','97','616','187620',3673181,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187620',3673182,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187620',3673183,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187620',3673184,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187620',3673185,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187620',3673186,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187620',3673187,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187620',3673188,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187620',3673189,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187620',3673190,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','187620',3673191,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','187814',3676617,'1713','237',1477598.35,1479963.82,2365.47,383206.14,0.00,0.00,0.00,0.00,0.00),('5','97','614','187814',3676618,'1714','237',1161052.44,1164342.72,3290.28,533025.36,0.00,0.00,0.00,0.00,0.00),('5','97','615','187814',3676619,'1715','237',1288707.11,1292460.94,3753.83,608120.46,0.00,0.00,0.00,0.00,0.00),('5','97','615','187814',3676620,'1716','237',1371495.64,1372745.95,1250.31,202550.22,0.00,0.00,0.00,0.00,0.00),('5','97','616','187814',3676621,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187814',3676622,'1718','237',682149.74,682487.39,337.65,54699.30,0.00,0.00,0.00,0.00,0.00),('5','97','617','187814',3676623,'1719','237',453648.36,454411.55,763.19,123636.78,0.00,0.00,0.00,0.00,0.00),('5','97','617','187814',3676624,'1720','237',836962.08,838260.81,1298.73,210394.26,0.00,0.00,0.00,0.00,0.00),('5','97','616','187814',3676625,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187814',3676626,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187814',3676627,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187814',3676628,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','187814',3676629,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187814',3676630,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187814',3676631,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','187814',3676632,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187814',3676633,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','187814',3676634,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','187814',3676635,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','188005',3680109,'1713','237',1479963.82,1483279.57,3315.75,537151.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','188005',3680110,'1714','237',1164342.72,1169177.55,4834.83,783242.46,0.00,0.00,0.00,0.00,0.00),('5','97','615','188005',3680111,'1715','237',1292460.94,1296535.85,4074.91,660135.42,0.00,0.00,0.00,0.00,0.00),('5','97','615','188005',3680112,'1716','237',1372745.95,1375610.44,2864.49,464047.38,0.00,0.00,0.00,0.00,0.00),('5','97','616','188005',3680113,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188005',3680114,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188005',3680115,'1719','237',454411.55,455988.18,1576.63,255414.06,0.00,0.00,0.00,0.00,0.00),('5','97','617','188005',3680116,'1720','237',838260.81,840853.38,2592.57,419996.34,0.00,0.00,0.00,0.00,0.00),('5','97','616','188005',3680117,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188005',3680118,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188005',3680119,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188005',3680120,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188005',3680121,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188005',3680122,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188005',3680123,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188005',3680124,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','188005',3680125,'1729','238',718224.12,718224.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','188005',3680126,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','188005',3680127,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','188225',3683759,'1713','237',1483279.57,1486603.30,3323.73,538444.26,0.00,0.00,0.00,0.00,0.00),('5','97','614','188225',3683760,'1714','237',1169177.55,1172533.93,3356.38,543733.56,0.00,0.00,0.00,0.00,0.00),('5','97','615','188225',3683761,'1715','237',1296535.85,1300622.13,4086.28,661977.36,0.00,0.00,0.00,0.00,0.00),('5','97','615','188225',3683762,'1716','237',1375610.44,1375610.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188225',3683763,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188225',3683764,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188225',3683765,'1719','237',455988.18,455988.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188225',3683766,'1720','237',840853.38,843583.00,2729.62,442198.44,0.00,0.00,0.00,0.00,0.00),('5','97','616','188225',3683767,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188225',3683768,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188225',3683769,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188225',3683770,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188225',3683771,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188225',3683772,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188225',3683773,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188225',3683774,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','188225',3683775,'1729','238',718224.12,718344.33,120.21,31855.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','188225',3683776,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','188225',3683777,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','188422',3687167,'1713','237',1486603.30,1490765.78,4162.48,674321.76,0.00,0.00,0.00,0.00,0.00),('5','97','614','188422',3687168,'1714','237',1172533.93,1174988.51,2454.58,397641.96,0.00,0.00,0.00,0.00,0.00),('5','97','615','188422',3687169,'1715','237',1300622.13,1305202.61,4580.48,742037.76,0.00,0.00,0.00,0.00,0.00),('5','97','615','188422',3687170,'1716','237',1375610.44,1375610.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188422',3687171,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188422',3687172,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188422',3687173,'1719','237',455988.18,457104.04,1115.86,180769.32,0.00,0.00,0.00,0.00,0.00),('5','97','617','188422',3687174,'1720','237',843583.00,846942.67,3359.67,544266.54,0.00,0.00,0.00,0.00,0.00),('5','97','616','188422',3687175,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188422',3687176,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188422',3687177,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188422',3687178,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188422',3687179,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188422',3687180,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188422',3687181,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188422',3687182,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','188422',3687183,'1729','238',718344.33,718895.62,551.29,146091.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','188422',3687184,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','188422',3687185,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','188625',3690679,'1713','237',1490765.78,1493445.96,2680.18,434189.16,0.00,0.00,0.00,0.00,0.00),('5','97','614','188625',3690680,'1714','237',1174988.51,1178045.54,3057.03,495238.86,0.00,0.00,0.00,0.00,0.00),('5','97','615','188625',3690681,'1715','237',1305202.61,1309654.03,4451.42,721130.04,0.00,0.00,0.00,0.00,0.00),('5','97','615','188625',3690682,'1716','237',1375610.44,1375620.44,10.00,1620.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188625',3690683,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188625',3690684,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188625',3690685,'1719','237',457104.04,459353.61,2249.57,364430.34,0.00,0.00,0.00,0.00,0.00),('5','97','617','188625',3690686,'1720','237',846942.67,850027.30,3084.63,499710.06,0.00,0.00,0.00,0.00,0.00),('5','97','616','188625',3690687,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188625',3690688,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188625',3690689,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188625',3690690,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188625',3690691,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188625',3690692,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188625',3690693,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188625',3690694,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','188625',3690695,'1729','238',718895.62,719936.40,1040.78,275806.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','188625',3690696,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','188625',3690697,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','188836',3694336,'1713','237',1493445.96,1496358.85,2912.89,471888.18,0.00,0.00,0.00,0.00,0.00),('5','97','614','188836',3694337,'1714','237',1178045.54,1181803.20,3757.66,608740.92,0.00,0.00,0.00,0.00,0.00),('5','97','615','188836',3694338,'1715','237',1309654.03,1314359.37,4705.34,762265.08,0.00,0.00,0.00,0.00,0.00),('5','97','615','188836',3694339,'1716','237',1375620.44,1376697.67,1077.23,174511.26,0.00,0.00,0.00,0.00,0.00),('5','97','616','188836',3694340,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188836',3694341,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188836',3694342,'1719','237',459353.61,460515.04,1161.43,188151.66,0.00,0.00,0.00,0.00,0.00),('5','97','617','188836',3694343,'1720','237',850027.30,851495.74,1468.44,237887.28,0.00,0.00,0.00,0.00,0.00),('5','97','616','188836',3694344,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188836',3694345,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188836',3694346,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188836',3694347,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','188836',3694348,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188836',3694349,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188836',3694350,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','188836',3694351,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','188836',3694352,'1729','238',719936.40,720591.70,655.30,173654.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','188836',3694353,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','188836',3694354,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189062',3698444,'1713','237',1496358.85,1497898.46,1539.61,249416.82,0.00,0.00,0.00,0.00,0.00),('5','97','614','189062',3698445,'1714','237',1181803.20,1183678.37,1875.17,303777.54,0.00,0.00,0.00,0.00,0.00),('5','97','615','189062',3698446,'1715','237',1314359.37,1319868.18,5508.81,892427.22,0.00,0.00,0.00,0.00,0.00),('5','97','615','189062',3698447,'1716','237',1376697.67,1380704.42,4006.75,649093.50,0.00,0.00,0.00,0.00,0.00),('5','97','616','189062',3698448,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189062',3698449,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189062',3698450,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189062',3698451,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189062',3698452,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189062',3698453,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189062',3698454,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189062',3698455,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189062',3698456,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189062',3698457,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189062',3698458,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189062',3698459,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','189062',3698460,'1729','238',720591.70,721403.87,812.17,215225.05,0.00,0.00,0.00,0.00,0.00),('5','97','618','189062',3698461,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','189062',3698462,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189228',3701342,'1713','237',1497898.46,1497898.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189228',3701343,'1714','237',1183678.37,1183678.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','189228',3701344,'1715','237',1319868.18,1326973.18,7105.00,1151010.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','189228',3701345,'1716','237',1380704.42,1387077.54,6373.12,1032445.44,0.00,0.00,0.00,0.00,0.00),('5','97','616','189228',3701346,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189228',3701347,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189228',3701348,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189228',3701349,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189228',3701350,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189228',3701351,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189228',3701352,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189228',3701353,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189228',3701354,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189228',3701355,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189228',3701356,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189228',3701357,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','189228',3701358,'1729','238',721403.87,722099.91,696.04,184450.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','189228',3701359,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','189228',3701360,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189451',3705432,'1713','237',1497898.46,1497898.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189451',3705433,'1714','237',1183678.37,1183678.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','189451',3705434,'1715','237',1326973.18,1333905.83,6932.65,1123089.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','189451',3705435,'1716','237',1387077.54,1392075.54,4998.00,809676.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189451',3705436,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189451',3705437,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189451',3705438,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189451',3705439,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189451',3705440,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189451',3705441,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189451',3705442,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189451',3705443,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189451',3705444,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189451',3705445,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189451',3705446,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189451',3705447,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','189451',3705448,'1729','238',722099.91,722654.35,554.44,146926.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','189451',3705449,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','189451',3705450,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189801',3711809,'1713','237',1497898.46,1497898.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189801',3711810,'1714','237',1183678.37,1183678.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','189801',3711811,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','189801',3711812,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189801',3711813,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189801',3711814,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189801',3711815,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189801',3711816,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189801',3711817,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189801',3711818,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189801',3711819,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189801',3711820,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189801',3711821,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189801',3711822,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189801',3711823,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189801',3711824,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','189801',3711825,'1729','238',722654.35,723732.25,1077.90,285643.50,0.00,0.00,0.00,0.00,0.00),('5','97','618','189801',3711826,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','189801',3711827,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189860',3712537,'1713','237',1497898.46,1497898.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','189860',3712538,'1714','237',1183678.37,1183678.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','189860',3712539,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','189860',3712540,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189860',3712541,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189860',3712542,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189860',3712543,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189860',3712544,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189860',3712545,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189860',3712546,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189860',3712547,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189860',3712548,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','189860',3712549,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189860',3712550,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189860',3712551,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','189860',3712552,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','189860',3712553,'1729','238',723732.25,724428.93,696.68,184620.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','189860',3712554,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','189860',3712555,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','190077',3716997,'1713','237',1497898.46,1504758.82,6860.36,1111378.32,0.00,0.00,0.00,0.00,0.00),('5','97','614','190077',3716998,'1714','237',1183678.37,1191598.20,7919.83,1283012.46,0.00,0.00,0.00,0.00,0.00),('5','97','615','190077',3716999,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','190077',3717000,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190077',3717001,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190077',3717002,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190077',3717003,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190077',3717004,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190077',3717005,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190077',3717006,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190077',3717007,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190077',3717008,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190077',3717009,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190077',3717010,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190077',3717011,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190077',3717012,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','190077',3717013,'1729','238',724428.93,724738.22,309.29,81961.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','190077',3717014,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','190077',3717015,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','190291',3720941,'1713','237',1504758.82,1504758.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','190291',3720942,'1714','237',1191598.20,1191598.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','190291',3720943,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','190291',3720944,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190291',3720945,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190291',3720946,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190291',3720947,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190291',3720948,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190291',3720949,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190291',3720950,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190291',3720951,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190291',3720952,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190291',3720953,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190291',3720954,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190291',3720955,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190291',3720956,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','190291',3720957,'1729','238',724738.22,725155.14,416.92,110483.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','190291',3720958,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','190291',3720959,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','190460',3724089,'1713','237',1504758.82,1505884.92,1126.10,185806.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','190460',3724090,'1714','237',1191598.20,1192795.95,1197.75,197628.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','190460',3724091,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','190460',3724092,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190460',3724093,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190460',3724094,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190460',3724095,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190460',3724096,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190460',3724097,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190460',3724098,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190460',3724099,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190460',3724100,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190460',3724101,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190460',3724102,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190460',3724103,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190460',3724104,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','190460',3724105,'1729','238',725155.14,726492.83,1337.69,354487.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','190460',3724106,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','190460',3724107,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','190702',3728657,'1713','237',1505884.92,1512158.99,6274.07,1035221.55,0.00,0.00,0.00,0.00,0.00),('5','97','614','190702',3728658,'1714','237',1192795.95,1199048.17,6252.22,1031616.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','190702',3728659,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','190702',3728660,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190702',3728661,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190702',3728662,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190702',3728663,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190702',3728664,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190702',3728665,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190702',3728666,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190702',3728667,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190702',3728668,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190702',3728669,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190702',3728670,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190702',3728671,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190702',3728672,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','190702',3728673,'1729','238',726492.83,727393.61,900.78,238706.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','190702',3728674,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','190702',3728675,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','190936',3732812,'1713','237',1512158.99,1515389.25,3230.26,532992.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','190936',3732813,'1714','237',1199048.17,1202888.01,3839.84,633573.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','190936',3732814,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','190936',3732815,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190936',3732816,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190936',3732817,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190936',3732818,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190936',3732819,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190936',3732820,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190936',3732821,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190936',3732822,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190936',3732823,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','190936',3732824,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190936',3732825,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190936',3732826,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','190936',3732827,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','190936',3732828,'1729','238',727393.61,728166.39,772.78,204786.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','190936',3732829,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','190936',3732830,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','191183',3737246,'1713','237',1515389.25,1519923.79,4534.54,748199.10,0.00,0.00,0.00,0.00,0.00),('5','97','614','191183',3737247,'1714','237',1202888.01,1207534.87,4646.86,766731.90,0.00,0.00,0.00,0.00,0.00),('5','97','615','191183',3737248,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','191183',3737249,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191183',3737250,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191183',3737251,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191183',3737252,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191183',3737253,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191183',3737254,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191183',3737255,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191183',3737256,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191183',3737257,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191183',3737258,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191183',3737259,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191183',3737260,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191183',3737261,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','191183',3737262,'1729','238',728166.39,728578.01,411.62,109079.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','191183',3737263,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','191183',3737264,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','191481',3742804,'1713','237',1519923.79,1519923.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','191481',3742805,'1714','237',1207534.87,1207534.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','191481',3742806,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','191481',3742807,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191481',3742808,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191481',3742809,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191481',3742810,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191481',3742811,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191481',3742812,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191481',3742813,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191481',3742814,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191481',3742815,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191481',3742816,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191481',3742817,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191481',3742818,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191481',3742819,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','191481',3742820,'1729','238',728578.01,729595.02,1017.01,269507.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','191481',3742821,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','191481',3742822,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','191556',3743848,'1713','237',1519923.79,1519923.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','191556',3743849,'1714','237',1207534.87,1207534.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','191556',3743850,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','191556',3743851,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191556',3743852,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191556',3743853,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191556',3743854,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191556',3743855,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191556',3743856,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191556',3743857,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191556',3743858,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191556',3743859,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191556',3743860,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191556',3743861,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191556',3743862,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191556',3743863,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','191556',3743864,'1729','238',729595.02,729792.22,197.20,52258.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','191556',3743865,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','191556',3743866,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','191788',3748591,'1713','237',1519923.79,1519923.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','191788',3748592,'1714','237',1207534.87,1207534.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','191788',3748593,'1715','237',1333905.83,1333905.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','191788',3748594,'1716','237',1392075.54,1392075.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191788',3748595,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191788',3748596,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191788',3748597,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191788',3748598,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191788',3748599,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191788',3748600,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191788',3748601,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191788',3748602,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191788',3748603,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191788',3748604,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191788',3748605,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191788',3748606,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','191788',3748607,'1729','238',729792.22,730075.21,282.99,74992.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','191788',3748608,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','191788',3748609,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','191983',3752155,'1713','237',1519923.79,1521179.76,1255.97,207235.05,0.00,0.00,0.00,0.00,0.00),('5','97','614','191983',3752156,'1714','237',1207534.87,1209053.42,1518.55,250560.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','191983',3752157,'1715','237',1333905.83,1335692.45,1786.62,294792.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','191983',3752158,'1716','237',1392075.54,1393161.33,1085.79,179155.35,0.00,0.00,0.00,0.00,0.00),('5','97','616','191983',3752159,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191983',3752160,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191983',3752161,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191983',3752162,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191983',3752163,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191983',3752164,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191983',3752165,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191983',3752166,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','191983',3752167,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191983',3752168,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191983',3752169,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','191983',3752170,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','191983',3752171,'1729','238',730075.21,731022.01,946.80,250902.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','191983',3752172,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','191983',3752173,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','192214',3756397,'1713','237',1521179.76,1523138.82,1959.06,323244.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','192214',3756398,'1714','237',1209053.42,1211871.34,2817.92,464956.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','192214',3756399,'1715','237',1335692.45,1339327.62,3635.17,599803.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','192214',3756400,'1716','237',1393161.33,1395214.38,2053.05,338753.25,0.00,0.00,0.00,0.00,0.00),('5','97','616','192214',3756401,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192214',3756402,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192214',3756403,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192214',3756404,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192214',3756405,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192214',3756406,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192214',3756407,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192214',3756408,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192214',3756409,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192214',3756410,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192214',3756411,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192214',3756412,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','192214',3756413,'1729','238',731022.01,732638.17,1616.16,428282.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','192214',3756414,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','192214',3756415,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','192404',3759652,'1713','237',1523138.82,1525552.42,2413.60,398244.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','192404',3759653,'1714','237',1211871.34,1213919.70,2048.36,337979.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','192404',3759654,'1715','237',1339327.62,1342508.79,3181.17,524893.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','192404',3759655,'1716','237',1395214.38,1397662.94,2448.56,404012.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','192404',3759656,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192404',3759657,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192404',3759658,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192404',3759659,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192404',3759660,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192404',3759661,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192404',3759662,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192404',3759663,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192404',3759664,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192404',3759665,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192404',3759666,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192404',3759667,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','192404',3759668,'1729','238',732638.17,734207.04,1568.87,415750.55,0.00,0.00,0.00,0.00,0.00),('5','97','618','192404',3759669,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','192404',3759670,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','192625',3763762,'1713','237',1525552.42,1527177.46,1625.04,268131.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','192625',3763763,'1714','237',1213919.70,1216374.13,2454.43,404980.95,0.00,0.00,0.00,0.00,0.00),('5','97','615','192625',3763764,'1715','237',1342508.79,1344393.75,1884.96,311018.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','192625',3763765,'1716','237',1397662.94,1400126.87,2463.93,406548.45,0.00,0.00,0.00,0.00,0.00),('5','97','616','192625',3763766,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192625',3763767,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192625',3763768,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192625',3763769,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192625',3763770,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192625',3763771,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192625',3763772,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192625',3763773,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192625',3763774,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192625',3763775,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192625',3763776,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192625',3763777,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','192625',3763778,'1729','238',734207.04,734715.42,508.38,134720.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','192625',3763779,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','192625',3763780,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','192790',3766638,'1713','237',1527177.46,1528967.41,1789.95,295341.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','192790',3766639,'1714','237',1216374.13,1219756.13,3382.00,558030.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','192790',3766640,'1715','237',1344393.75,1348133.72,3739.97,617095.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','192790',3766641,'1716','237',1400126.87,1401318.57,1191.70,196630.50,0.00,0.00,0.00,0.00,0.00),('5','97','616','192790',3766642,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192790',3766643,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192790',3766644,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192790',3766645,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192790',3766646,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192790',3766647,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192790',3766648,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192790',3766649,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','192790',3766650,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192790',3766651,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192790',3766652,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','192790',3766653,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','192790',3766654,'1729','238',734715.42,735202.71,487.29,129131.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','192790',3766655,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','192790',3766656,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','193047',3771531,'1713','237',1528967.41,1532133.26,3165.85,522365.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','193047',3771532,'1714','237',1219756.13,1223362.58,3606.45,595064.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','193047',3771533,'1715','237',1348133.72,1350130.02,1996.30,329389.50,0.00,0.00,0.00,0.00,0.00),('5','97','615','193047',3771534,'1716','237',1401318.57,1402254.55,935.98,154436.70,0.00,0.00,0.00,0.00,0.00),('5','97','616','193047',3771535,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193047',3771536,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193047',3771537,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193047',3771538,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193047',3771539,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193047',3771540,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193047',3771541,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193047',3771542,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193047',3771543,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193047',3771544,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193047',3771545,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193047',3771546,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','193047',3771547,'1729','238',735202.71,735791.50,588.79,156029.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','193047',3771548,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','193047',3771549,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','193227',3774896,'1713','237',1532133.26,1532939.09,805.83,132961.95,0.00,0.00,0.00,0.00,0.00),('5','97','614','193227',3774897,'1714','237',1223362.58,1224088.23,725.65,119732.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','193227',3774898,'1715','237',1350130.02,1350130.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','193227',3774899,'1716','237',1402254.55,1402254.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193227',3774900,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193227',3774901,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193227',3774902,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193227',3774903,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193227',3774904,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193227',3774905,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193227',3774906,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193227',3774907,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193227',3774908,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193227',3774909,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193227',3774910,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193227',3774911,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','193227',3774912,'1729','238',735791.50,736031.05,239.55,63480.75,0.00,0.00,0.00,0.00,0.00),('5','97','618','193227',3774913,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','193227',3774914,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','193432',3779089,'1713','237',1532939.09,1532939.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','193432',3779090,'1714','237',1224088.23,1224088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','193432',3779091,'1715','237',1350130.02,1350130.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','193432',3779092,'1716','237',1402254.55,1402254.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193432',3779093,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193432',3779094,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193432',3779095,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193432',3779096,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193432',3779097,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193432',3779098,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193432',3779099,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193432',3779100,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193432',3779101,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193432',3779102,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193432',3779103,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193432',3779104,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','193432',3779105,'1729','238',736031.05,736875.44,844.39,223763.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','193432',3779106,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','193432',3779107,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','193728',3784709,'1713','237',1532939.09,1532939.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','193728',3784710,'1714','237',1224088.23,1224088.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','193728',3784711,'1715','237',1350130.02,1350130.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','193728',3784712,'1716','237',1402254.55,1402254.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193728',3784713,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193728',3784714,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193728',3784715,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193728',3784716,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193728',3784717,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193728',3784718,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193728',3784719,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193728',3784720,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193728',3784721,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193728',3784722,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193728',3784723,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193728',3784724,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','193728',3784725,'1729','238',736875.44,737321.47,446.03,118197.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','193728',3784726,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','193728',3784727,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','193936',3788280,'1713','237',1532939.09,1534673.90,1734.81,286243.65,0.00,0.00,0.00,0.00,0.00),('5','97','614','193936',3788281,'1714','237',1224088.23,1226703.94,2615.71,431592.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','193936',3788282,'1715','237',1350130.02,1353425.19,3295.17,543703.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','193936',3788283,'1716','237',1402254.55,1405419.70,3165.15,522249.75,0.00,0.00,0.00,0.00,0.00),('5','97','616','193936',3788284,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193936',3788285,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193936',3788286,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193936',3788287,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193936',3788288,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193936',3788289,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193936',3788290,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193936',3788291,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','193936',3788292,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193936',3788293,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193936',3788294,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','193936',3788295,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','193936',3788296,'1729','238',737321.47,738233.43,911.96,241669.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','193936',3788297,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','193936',3788298,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','194180',3792639,'1713','237',1534673.90,1536037.92,1364.02,225063.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','194180',3792640,'1714','237',1226703.94,1228776.62,2072.68,341992.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','194180',3792641,'1715','237',1353425.19,1355750.18,2324.99,383623.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','194180',3792642,'1716','237',1405419.70,1407632.37,2212.67,365090.55,0.00,0.00,0.00,0.00,0.00),('5','97','616','194180',3792643,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194180',3792644,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194180',3792645,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194180',3792646,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194180',3792647,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194180',3792648,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194180',3792649,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194180',3792650,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194180',3792651,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194180',3792652,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194180',3792653,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194180',3792654,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','194180',3792655,'1729','238',738233.43,739027.36,793.93,210391.45,0.00,0.00,0.00,0.00,0.00),('5','97','618','194180',3792656,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','194180',3792657,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','194414',3797011,'1713','237',1536037.92,1537904.89,1866.97,308050.05,0.00,0.00,0.00,0.00,0.00),('5','97','614','194414',3797012,'1714','237',1228776.62,1231431.11,2654.49,437990.85,0.00,0.00,0.00,0.00,0.00),('5','97','615','194414',3797013,'1715','237',1355750.18,1358994.00,3243.82,535230.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','194414',3797014,'1716','237',1407632.37,1408225.26,592.89,97826.85,0.00,0.00,0.00,0.00,0.00),('5','97','616','194414',3797015,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194414',3797016,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194414',3797017,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194414',3797018,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194414',3797019,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194414',3797020,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194414',3797021,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194414',3797022,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194414',3797023,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194414',3797024,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194414',3797025,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194414',3797026,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','194414',3797027,'1729','238',739027.36,739643.38,616.02,163245.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','194414',3797028,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','194414',3797029,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','194553',3799337,'1713','237',1537904.89,1539485.09,1580.20,260733.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','194553',3799338,'1714','237',1231431.11,1232371.62,940.51,155184.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','194553',3799339,'1715','237',1358994.00,1363581.66,4587.66,756963.90,0.00,0.00,0.00,0.00,0.00),('5','97','615','194553',3799340,'1716','237',1408225.26,1410404.33,2179.07,359546.55,0.00,0.00,0.00,0.00,0.00),('5','97','616','194553',3799341,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194553',3799342,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194553',3799343,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194553',3799344,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194553',3799345,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194553',3799346,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194553',3799347,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194553',3799348,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194553',3799349,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194553',3799350,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194553',3799351,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194553',3799352,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','194553',3799353,'1729','238',739643.38,747426.67,7783.29,2062571.85,0.00,0.00,0.00,0.00,0.00),('5','97','618','194553',3799354,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','194553',3799355,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','194789',3803927,'1713','237',1539485.09,1539485.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','194789',3803928,'1714','237',1232371.62,1232371.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','194789',3803929,'1715','237',1363581.66,1367862.56,4280.90,706348.50,0.00,0.00,0.00,0.00,0.00),('5','97','615','194789',3803930,'1716','237',1410404.33,1414622.56,4218.23,696007.95,0.00,0.00,0.00,0.00,0.00),('5','97','616','194789',3803931,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194789',3803932,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194789',3803933,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194789',3803934,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194789',3803935,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194789',3803936,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194789',3803937,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194789',3803938,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','194789',3803939,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194789',3803940,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194789',3803941,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','194789',3803942,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','194789',3803943,'1729','238',747426.67,748073.08,646.41,171298.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','194789',3803944,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','194789',3803945,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','195201',3811486,'1713','237',1539485.09,1542270.95,2785.86,459666.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','195201',3811487,'1714','237',1232371.62,1232415.84,44.22,7296.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','195201',3811488,'1715','237',1367862.56,1371902.47,4039.91,666585.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','195201',3811489,'1716','237',1414622.56,1417613.27,2990.71,493467.15,0.00,0.00,0.00,0.00,0.00),('5','97','616','195201',3811490,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195201',3811491,'1718','237',682487.39,682487.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195201',3811492,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195201',3811493,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195201',3811494,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195201',3811495,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195201',3811496,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195201',3811497,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195201',3811498,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195201',3811499,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195201',3811500,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195201',3811501,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','195201',3811502,'1729','238',748073.08,749509.67,1436.59,380696.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','195201',3811503,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','195201',3811504,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','195360',3814173,'1713','237',1542270.95,1543908.37,1637.42,270174.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','195360',3814174,'1714','237',1232415.84,1235090.92,2675.08,441388.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','195360',3814175,'1715','237',1371902.47,1374489.54,2587.07,426866.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','195360',3814176,'1716','237',1417613.27,1419517.69,1904.42,314229.30,0.00,0.00,0.00,0.00,0.00),('5','97','616','195360',3814177,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195360',3814178,'1718','237',682487.39,682797.85,310.46,51225.90,0.00,0.00,0.00,0.00,0.00),('5','97','617','195360',3814179,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195360',3814180,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195360',3814181,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195360',3814182,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195360',3814183,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195360',3814184,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195360',3814185,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195360',3814186,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195360',3814187,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195360',3814188,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','195360',3814189,'1729','238',749509.67,751542.72,2033.05,538758.25,0.00,0.00,0.00,0.00,0.00),('5','97','618','195360',3814190,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','195360',3814191,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','195430',3815416,'1713','237',1543908.37,1545906.95,1998.58,329765.70,0.00,0.00,0.00,0.00,0.00),('5','97','614','195430',3815417,'1714','237',1235090.92,1236667.64,1576.72,260158.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','195430',3815418,'1715','237',1374489.54,1377971.16,3481.62,574467.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','195430',3815419,'1716','237',1419517.69,1420065.83,548.14,90443.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','195430',3815420,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195430',3815421,'1718','237',682797.85,685510.34,2712.49,447560.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','195430',3815422,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195430',3815423,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195430',3815424,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195430',3815425,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195430',3815426,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195430',3815427,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195430',3815428,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195430',3815429,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195430',3815430,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195430',3815431,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','195430',3815432,'1729','238',751542.72,752294.64,751.92,199258.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','195430',3815433,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','195430',3815434,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','195733',3820734,'1713','237',1545906.95,1547366.18,1459.23,240772.95,0.00,0.00,0.00,0.00,0.00),('5','97','614','195733',3820735,'1714','237',1236667.64,1238761.06,2093.42,345414.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','195733',3820736,'1715','237',1377971.16,1381456.04,3484.88,575005.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','195733',3820737,'1716','237',1420065.83,1420746.22,680.39,112264.35,0.00,0.00,0.00,0.00,0.00),('5','97','616','195733',3820738,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195733',3820739,'1718','237',685510.34,687630.78,2120.44,349872.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','195733',3820740,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195733',3820741,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195733',3820742,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195733',3820743,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195733',3820744,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195733',3820745,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195733',3820746,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195733',3820747,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195733',3820748,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195733',3820749,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','195733',3820750,'1729','238',752294.64,753375.23,1080.59,286356.35,0.00,0.00,0.00,0.00,0.00),('5','97','618','195733',3820751,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','195733',3820752,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','195894',3823500,'1713','237',1547366.18,1549058.56,1692.38,279242.70,0.00,0.00,0.00,0.00,0.00),('5','97','614','195894',3823501,'1714','237',1238761.06,1242208.57,3447.51,568839.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','195894',3823502,'1715','237',1381456.04,1385965.49,4509.45,744059.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','195894',3823503,'1716','237',1420746.22,1420746.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195894',3823504,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195894',3823505,'1718','237',687630.78,689537.40,1906.62,314592.30,0.00,0.00,0.00,0.00,0.00),('5','97','617','195894',3823506,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195894',3823507,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195894',3823508,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195894',3823509,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195894',3823510,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195894',3823511,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','195894',3823512,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195894',3823513,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195894',3823514,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','195894',3823515,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','195894',3823516,'1729','238',753375.23,756227.44,2852.21,755835.65,0.00,0.00,0.00,0.00,0.00),('5','97','618','195894',3823517,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','195894',3823518,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','196125',3827808,'1713','237',1549058.56,1551670.29,2611.73,430935.45,0.00,0.00,0.00,0.00,0.00),('5','97','614','196125',3827809,'1714','237',1242208.57,1243543.77,1335.20,220308.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','196125',3827810,'1715','237',1385965.49,1389826.27,3860.78,637028.70,0.00,0.00,0.00,0.00,0.00),('5','97','615','196125',3827811,'1716','237',1420746.22,1423002.34,2256.12,372259.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','196125',3827812,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196125',3827813,'1718','237',689537.40,691625.24,2087.84,344493.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','196125',3827814,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196125',3827815,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196125',3827816,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196125',3827817,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196125',3827818,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196125',3827819,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196125',3827820,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196125',3827821,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196125',3827822,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196125',3827823,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','196125',3827824,'1729','238',756227.44,757002.21,774.77,205314.05,0.00,0.00,0.00,0.00,0.00),('5','97','618','196125',3827825,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','196125',3827826,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','196325',3831565,'1713','237',1551670.29,1554479.65,2809.36,463544.40,0.00,0.00,0.00,0.00,0.00),('5','97','614','196325',3831566,'1714','237',1243543.77,1246117.16,2573.39,424609.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','196325',3831567,'1715','237',1389826.27,1392484.76,2658.49,438650.85,0.00,0.00,0.00,0.00,0.00),('5','97','615','196325',3831568,'1716','237',1423002.34,1424193.51,1191.17,196543.05,0.00,0.00,0.00,0.00,0.00),('5','97','616','196325',3831569,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196325',3831570,'1718','237',691625.24,695226.85,3601.61,594265.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','196325',3831571,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196325',3831572,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196325',3831573,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196325',3831574,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196325',3831575,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196325',3831576,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196325',3831577,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196325',3831578,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196325',3831579,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196325',3831580,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','196325',3831581,'1729','238',757002.21,757714.17,711.96,188669.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','196325',3831582,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','196325',3831583,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','196517',3835014,'1713','237',1554479.65,1554479.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','196517',3835015,'1714','237',1246117.16,1246117.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','196517',3835016,'1715','237',1392484.76,1392484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','196517',3835017,'1716','237',1424193.51,1424193.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196517',3835018,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196517',3835019,'1718','237',695226.85,695226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196517',3835020,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196517',3835021,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196517',3835022,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196517',3835023,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196517',3835024,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196517',3835025,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196517',3835026,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196517',3835027,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196517',3835028,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196517',3835029,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','196517',3835030,'1729','238',757714.17,758213.00,498.83,132189.95,0.00,0.00,0.00,0.00,0.00),('5','97','618','196517',3835031,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','196517',3835032,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','196756',3839203,'1713','237',1554479.65,1558446.73,3967.08,654568.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','196756',3839204,'1714','237',1246117.16,1250871.73,4754.57,784504.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','196756',3839205,'1715','237',1392484.76,1392484.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','196756',3839206,'1716','237',1424193.51,1424193.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196756',3839207,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196756',3839208,'1718','237',695226.85,695226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196756',3839209,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196756',3839210,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196756',3839211,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196756',3839212,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196756',3839213,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196756',3839214,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196756',3839215,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196756',3839216,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196756',3839217,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196756',3839218,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','196756',3839219,'1729','238',758213.00,758585.58,372.58,98733.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','196756',3839220,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','196756',3839221,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','196934',3842364,'1713','237',1558446.73,1561974.71,3527.98,582116.70,0.00,0.00,0.00,0.00,0.00),('5','97','614','196934',3842365,'1714','237',1250871.73,1252700.80,1829.07,301796.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','196934',3842366,'1715','237',1392484.76,1395586.07,3101.31,511716.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','196934',3842367,'1716','237',1424193.51,1424193.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196934',3842368,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196934',3842369,'1718','237',695226.85,695226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196934',3842370,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196934',3842371,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196934',3842372,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196934',3842373,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196934',3842374,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196934',3842375,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','196934',3842376,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196934',3842377,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196934',3842378,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','196934',3842379,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','196934',3842380,'1729','238',758585.58,758778.62,193.04,51155.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','196934',3842381,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','196934',3842382,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','197686',3855486,'1713','237',1561974.71,1564808.62,2833.91,467595.15,0.00,0.00,0.00,0.00,0.00),('5','97','614','197686',3855487,'1714','237',1252700.80,1252794.03,93.23,15382.95,0.00,0.00,0.00,0.00,0.00),('5','97','615','197686',3855488,'1715','237',1395586.07,1398952.72,3366.65,555497.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','197686',3855489,'1716','237',1424193.51,1426906.51,2713.00,447645.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197686',3855490,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197686',3855491,'1718','237',695226.85,695226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197686',3855492,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197686',3855493,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197686',3855494,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197686',3855495,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197686',3855496,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197686',3855497,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197686',3855498,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197686',3855499,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197686',3855500,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197686',3855501,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','197686',3855502,'1729','238',758778.62,759095.82,317.20,84058.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','197686',3855503,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','197686',3855504,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','197846',3858426,'1713','237',1564808.62,1567253.07,2444.45,403334.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','197846',3858427,'1714','237',1252794.03,1254006.70,1212.67,200090.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','197846',3858428,'1715','237',1398952.72,1402442.68,3489.96,575843.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','197846',3858429,'1716','237',1426906.51,1428369.85,1463.34,241451.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','197846',3858430,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197846',3858431,'1718','237',695226.85,695226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197846',3858432,'1719','237',460515.04,460515.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197846',3858433,'1720','237',851495.74,851495.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197846',3858434,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197846',3858435,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197846',3858436,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197846',3858437,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197846',3858438,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197846',3858439,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197846',3858440,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197846',3858441,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','197846',3858442,'1729','238',759095.82,760762.44,1666.62,441654.30,0.00,0.00,0.00,0.00,0.00),('5','97','618','197846',3858443,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','197846',3858444,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','197897',3859136,'1713','237',1567253.07,1569807.02,2553.95,421401.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','197897',3859137,'1714','237',1254006.70,1255096.83,1090.13,179871.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','197897',3859138,'1715','237',1402442.68,1405834.75,3392.07,559691.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','197897',3859139,'1716','237',1428369.85,1430514.64,2144.79,353890.35,0.00,0.00,0.00,0.00,0.00),('5','97','616','197897',3859140,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197897',3859141,'1718','237',695226.85,695226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197897',3859142,'1719','237',460515.04,461569.94,1054.90,174058.50,0.00,0.00,0.00,0.00,0.00),('5','97','617','197897',3859143,'1720','237',851495.74,851497.06,1.32,217.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','197897',3859144,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197897',3859145,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197897',3859146,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197897',3859147,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197897',3859148,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197897',3859149,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197897',3859150,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197897',3859151,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','197897',3859152,'1729','238',760762.44,760762.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','197897',3859153,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','197897',3859154,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','197993',3861003,'1713','237',1569807.02,1573256.27,3449.25,569126.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','197993',3861004,'1714','237',1255096.83,1256127.48,1030.65,170057.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','197993',3861005,'1715','237',1405834.75,1408652.41,2817.66,464913.90,0.00,0.00,0.00,0.00,0.00),('5','97','615','197993',3861006,'1716','237',1430514.64,1430950.20,435.56,71867.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','197993',3861007,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197993',3861008,'1718','237',695226.85,695226.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197993',3861009,'1719','237',461569.94,463212.66,1642.72,271048.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','197993',3861010,'1720','237',851497.06,852012.13,515.07,84986.55,0.00,0.00,0.00,0.00,0.00),('5','97','616','197993',3861011,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197993',3861012,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197993',3861013,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197993',3861014,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','197993',3861015,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197993',3861016,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197993',3861017,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','197993',3861018,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','197993',3861019,'1729','238',760762.44,762207.42,1444.98,382919.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','197993',3861020,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','197993',3861021,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','198021',3861519,'1713','237',1573256.27,1575822.08,2565.81,423358.65,0.00,0.00,0.00,0.00,0.00),('5','97','614','198021',3861520,'1714','237',1256127.48,1256127.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','198021',3861521,'1715','237',1408652.41,1412432.60,3780.19,623731.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','198021',3861522,'1716','237',1430950.20,1432453.82,1503.62,248097.30,0.00,0.00,0.00,0.00,0.00),('5','97','616','198021',3861523,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198021',3861524,'1718','237',695226.85,697815.12,2588.27,427064.55,0.00,0.00,0.00,0.00,0.00),('5','97','617','198021',3861525,'1719','237',463212.66,463212.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198021',3861526,'1720','237',852012.13,852012.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198021',3861527,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198021',3861528,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198021',3861529,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198021',3861530,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198021',3861531,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198021',3861532,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198021',3861533,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198021',3861534,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','198021',3861535,'1729','238',762207.42,763330.54,1123.12,303242.40,0.00,0.00,0.00,0.00,0.00),('5','97','618','198021',3861536,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','198021',3861537,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','198216',3864641,'1713','237',1575822.08,1576537.39,715.31,118026.15,0.00,0.00,0.00,0.00,0.00),('5','97','614','198216',3864642,'1714','237',1256127.48,1258860.95,2733.47,451022.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','198216',3864643,'1715','237',1412432.60,1415297.72,2865.12,472744.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','198216',3864644,'1716','237',1432453.82,1433941.63,1487.81,245488.65,0.00,0.00,0.00,0.00,0.00),('5','97','616','198216',3864645,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198216',3864646,'1718','237',697815.12,698880.66,1065.54,175814.10,0.00,0.00,0.00,0.00,0.00),('5','97','617','198216',3864647,'1719','237',463212.66,463805.62,592.96,97838.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','198216',3864648,'1720','237',852012.13,852012.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198216',3864649,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198216',3864650,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198216',3864651,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198216',3864652,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198216',3864653,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198216',3864654,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198216',3864655,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198216',3864656,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','198216',3864657,'1729','238',763330.54,764222.62,892.08,240861.60,0.00,0.00,0.00,0.00,0.00),('5','97','618','198216',3864658,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','198216',3864659,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','198430',3868406,'1713','237',1576537.39,1579058.41,2521.02,415968.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','198430',3868407,'1714','237',1258860.95,1261440.08,2579.13,425556.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','198430',3868408,'1715','237',1415297.72,1418502.53,3204.81,528793.65,0.00,0.00,0.00,0.00,0.00),('5','97','615','198430',3868409,'1716','237',1433941.63,1435508.15,1566.52,258475.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','198430',3868410,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198430',3868411,'1718','237',698880.66,700671.77,1791.11,295533.15,0.00,0.00,0.00,0.00,0.00),('5','97','617','198430',3868412,'1719','237',463805.62,463805.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198430',3868413,'1720','237',852012.13,852730.87,718.74,118592.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','198430',3868414,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198430',3868415,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198430',3868416,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198430',3868417,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198430',3868418,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198430',3868419,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198430',3868420,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198430',3868421,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','198430',3868422,'1729','238',764222.62,765752.66,1530.04,413110.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','198430',3868423,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','198430',3868424,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','198710',3873527,'1713','237',1579058.41,1580282.72,1224.31,202011.15,0.00,0.00,0.00,0.00,0.00),('5','97','614','198710',3873528,'1714','237',1261440.08,1263243.76,1803.68,297607.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','198710',3873529,'1715','237',1418502.53,1421166.87,2664.34,439616.10,0.00,0.00,0.00,0.00,0.00),('5','97','615','198710',3873530,'1716','237',1435508.15,1437042.91,1534.76,253235.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','198710',3873531,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198710',3873532,'1718','237',700671.77,702389.34,1717.57,283399.05,0.00,0.00,0.00,0.00,0.00),('5','97','617','198710',3873533,'1719','237',463805.62,464021.79,216.17,35668.05,0.00,0.00,0.00,0.00,0.00),('5','97','617','198710',3873534,'1720','237',852730.87,853379.23,648.36,106979.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','198710',3873535,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198710',3873536,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198710',3873537,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198710',3873538,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198710',3873539,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198710',3873540,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198710',3873541,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198710',3873542,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','198710',3873543,'1729','238',765752.66,768771.27,3018.61,815024.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','198710',3873544,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','198710',3873545,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','198888',3876139,'1713','237',1580282.72,1581911.89,1629.17,268813.05,0.00,0.00,0.00,0.00,0.00),('5','97','614','198888',3876140,'1714','237',1263243.76,1265832.75,2588.99,427183.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','198888',3876141,'1715','237',1421166.87,1424132.83,2965.96,489383.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','198888',3876142,'1716','237',1437042.91,1438598.96,1556.05,256748.25,0.00,0.00,0.00,0.00,0.00),('5','97','616','198888',3876143,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198888',3876144,'1718','237',702389.34,703663.32,1273.98,210206.70,0.00,0.00,0.00,0.00,0.00),('5','97','617','198888',3876145,'1719','237',464021.79,464021.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198888',3876146,'1720','237',853379.23,854559.86,1180.63,194803.95,0.00,0.00,0.00,0.00,0.00),('5','97','616','198888',3876147,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198888',3876148,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198888',3876149,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198888',3876150,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','198888',3876151,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198888',3876152,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198888',3876153,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','198888',3876154,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','198888',3876155,'1729','238',768771.27,769370.30,599.03,161738.10,0.00,0.00,0.00,0.00,0.00),('5','97','618','198888',3876156,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','198888',3876157,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','199034',3878718,'1713','237',1581911.89,1583319.51,1407.62,232257.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','199034',3878719,'1714','237',1265832.75,1266957.67,1124.92,185611.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','199034',3878720,'1715','237',1424132.83,1427773.15,3640.32,600652.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','199034',3878721,'1716','237',1438598.96,1438598.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199034',3878722,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199034',3878723,'1718','237',703663.32,706003.28,2339.96,386093.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','199034',3878724,'1719','237',464021.79,465583.46,1561.67,257675.55,0.00,0.00,0.00,0.00,0.00),('5','97','617','199034',3878725,'1720','237',854559.86,857030.62,2470.76,407675.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','199034',3878726,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199034',3878727,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199034',3878728,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199034',3878729,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199034',3878730,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199034',3878731,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199034',3878732,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199034',3878733,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','199034',3878734,'1729','238',769370.30,777142.40,7772.10,2098467.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','199034',3878735,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','199034',3878736,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','199309',3883265,'1713','237',1583319.51,1584208.39,888.88,146665.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','199309',3883266,'1714','237',1266957.67,1269430.83,2473.16,408071.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','199309',3883267,'1715','237',1427773.15,1430947.87,3174.72,523828.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','199309',3883268,'1716','237',1438598.96,1440230.11,1631.15,269139.75,0.00,0.00,0.00,0.00,0.00),('5','97','616','199309',3883269,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199309',3883270,'1718','237',706003.28,706658.28,655.00,108075.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199309',3883271,'1719','237',465583.46,465605.56,22.10,3646.50,0.00,0.00,0.00,0.00,0.00),('5','97','617','199309',3883272,'1720','237',857030.62,858922.89,1892.27,312224.55,0.00,0.00,0.00,0.00,0.00),('5','97','616','199309',3883273,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199309',3883274,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199309',3883275,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199309',3883276,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199309',3883277,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199309',3883278,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199309',3883279,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199309',3883280,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','199309',3883281,'1729','238',777142.40,777770.86,628.46,169684.20,0.00,0.00,0.00,0.00,0.00),('5','97','618','199309',3883282,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','199309',3883283,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','199496',3886348,'1713','237',1584208.39,1585978.62,1770.23,292087.95,0.00,0.00,0.00,0.00,0.00),('5','97','614','199496',3886349,'1714','237',1269430.83,1271839.86,2409.03,397489.95,0.00,0.00,0.00,0.00,0.00),('5','97','615','199496',3886350,'1715','237',1430947.87,1434002.49,3054.62,504012.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','199496',3886351,'1716','237',1440230.11,1440230.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199496',3886352,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199496',3886353,'1718','237',706658.28,707206.69,548.41,90487.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','199496',3886354,'1719','237',465605.56,465605.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199496',3886355,'1720','237',858922.89,860609.75,1686.86,278331.90,0.00,0.00,0.00,0.00,0.00),('5','97','616','199496',3886356,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199496',3886357,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199496',3886358,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199496',3886359,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199496',3886360,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199496',3886361,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199496',3886362,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199496',3886363,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','199496',3886364,'1729','238',777770.86,778699.96,929.10,250857.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','199496',3886365,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','199496',3886366,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','199772',3890882,'1713','237',1585978.62,1588276.33,2297.71,379122.15,0.00,0.00,0.00,0.00,0.00),('5','97','614','199772',3890883,'1714','237',1271839.86,1273171.42,1331.56,219707.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','199772',3890884,'1715','237',1434002.49,1437479.04,3476.55,573630.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','199772',3890885,'1716','237',1440230.11,1440230.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199772',3890886,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199772',3890887,'1718','237',707206.69,708906.13,1699.44,280407.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','199772',3890888,'1719','237',465605.56,466266.72,661.16,109091.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','199772',3890889,'1720','237',860609.75,861162.50,552.75,91203.75,0.00,0.00,0.00,0.00,0.00),('5','97','616','199772',3890890,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199772',3890891,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199772',3890892,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199772',3890893,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199772',3890894,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199772',3890895,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199772',3890896,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199772',3890897,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','199772',3890898,'1729','238',778699.96,780361.00,1661.04,448480.80,0.00,0.00,0.00,0.00,0.00),('5','97','618','199772',3890899,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','199772',3890900,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','199934',3893528,'1713','237',1588276.33,1590214.83,1938.50,319852.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','199934',3893529,'1714','237',1273171.42,1276188.38,3016.96,497798.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','199934',3893530,'1715','237',1437479.04,1440612.67,3133.63,517048.95,0.00,0.00,0.00,0.00,0.00),('5','97','615','199934',3893531,'1716','237',1440230.11,1441234.81,1004.70,165775.50,0.00,0.00,0.00,0.00,0.00),('5','97','616','199934',3893532,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199934',3893533,'1718','237',708906.13,710698.53,1792.40,295746.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199934',3893534,'1719','237',466266.72,466958.61,691.89,114161.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','199934',3893535,'1720','237',861162.50,861786.22,623.72,102913.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','199934',3893536,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199934',3893537,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199934',3893538,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199934',3893539,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','199934',3893540,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199934',3893541,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199934',3893542,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','199934',3893543,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','199934',3893544,'1729','238',780361.00,781140.11,779.11,210359.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','199934',3893545,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','199934',3893546,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','200113',3896898,'1713','237',1590214.83,1591512.47,1297.64,214110.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','200113',3896899,'1714','237',1276188.38,1277720.72,1532.34,252836.10,0.00,0.00,0.00,0.00,0.00),('5','97','615','200113',3896900,'1715','237',1440612.67,1443205.74,2593.07,427856.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','200113',3896901,'1716','237',1441234.81,1443662.63,2427.82,400590.30,0.00,0.00,0.00,0.00,0.00),('5','97','616','200113',3896902,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200113',3896903,'1718','237',710698.53,712063.16,1364.63,225163.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','200113',3896904,'1719','237',466958.61,466958.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200113',3896905,'1720','237',861786.22,862560.08,773.86,127686.90,0.00,0.00,0.00,0.00,0.00),('5','97','616','200113',3896906,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200113',3896907,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200113',3896908,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200113',3896909,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200113',3896910,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200113',3896911,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200113',3896912,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200113',3896913,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','200113',3896914,'1729','238',781140.11,782214.72,1074.61,290144.70,0.00,0.00,0.00,0.00,0.00),('5','97','618','200113',3896915,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','200113',3896916,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','200322',3900580,'1713','237',1591512.47,1594045.10,2532.63,417883.95,0.00,0.00,0.00,0.00,0.00),('5','97','614','200322',3900581,'1714','237',1277720.72,1277720.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','200322',3900582,'1715','237',1443205.74,1447740.30,4534.56,748202.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','200322',3900583,'1716','237',1443662.63,1443662.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200322',3900584,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200322',3900585,'1718','237',712063.16,713541.73,1478.57,243964.05,0.00,0.00,0.00,0.00,0.00),('5','97','617','200322',3900586,'1719','237',466958.61,467611.58,652.97,107740.05,0.00,0.00,0.00,0.00,0.00),('5','97','617','200322',3900587,'1720','237',862560.08,865441.89,2881.81,475498.65,0.00,0.00,0.00,0.00,0.00),('5','97','616','200322',3900588,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200322',3900589,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200322',3900590,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200322',3900591,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200322',3900592,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200322',3900593,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200322',3900594,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200322',3900595,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','200322',3900596,'1729','238',782214.72,785830.29,3615.57,976203.90,0.00,0.00,0.00,0.00,0.00),('5','97','618','200322',3900597,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','200322',3900598,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','200566',3905068,'1713','237',1594045.10,1597369.72,3324.62,548562.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','200566',3905069,'1714','237',1277720.72,1277720.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','200566',3905070,'1715','237',1447740.30,1451206.09,3465.79,571855.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','200566',3905071,'1716','237',1443662.63,1443662.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200566',3905072,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200566',3905073,'1718','237',713541.73,716032.13,2490.40,410916.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200566',3905074,'1719','237',467611.58,467611.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200566',3905075,'1720','237',865441.89,867917.54,2475.65,408482.25,0.00,0.00,0.00,0.00,0.00),('5','97','616','200566',3905076,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200566',3905077,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200566',3905078,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200566',3905079,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200566',3905080,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200566',3905081,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200566',3905082,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200566',3905083,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','200566',3905084,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','200566',3905085,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','200566',3905086,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','200769',3908735,'1713','237',1597369.72,1599612.58,2242.86,370071.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','200769',3908736,'1714','237',1277720.72,1279046.25,1325.53,218712.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','200769',3908737,'1715','237',1451206.09,1454056.39,2850.30,470299.50,0.00,0.00,0.00,0.00,0.00),('5','97','615','200769',3908738,'1716','237',1443662.63,1446001.82,2339.19,385966.35,0.00,0.00,0.00,0.00,0.00),('5','97','616','200769',3908739,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200769',3908740,'1718','237',716032.13,716746.08,713.95,117801.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','200769',3908741,'1719','237',467611.58,467971.19,359.61,59335.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','200769',3908742,'1720','237',867917.54,869057.48,1139.94,188090.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','200769',3908743,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200769',3908744,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200769',3908745,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200769',3908746,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200769',3908747,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200769',3908748,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200769',3908749,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200769',3908750,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','200769',3908751,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','200769',3908752,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','200769',3908753,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','200998',3912638,'1713','237',1599612.58,1601380.24,1767.66,291663.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','200998',3912639,'1714','237',1279046.25,1279929.80,883.55,145785.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','200998',3912640,'1715','237',1454056.39,1456716.82,2660.43,438970.95,0.00,0.00,0.00,0.00,0.00),('5','97','615','200998',3912641,'1716','237',1446001.82,1447328.76,1326.94,218945.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','200998',3912642,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200998',3912643,'1718','237',716746.08,718323.56,1577.48,260284.20,0.00,0.00,0.00,0.00,0.00),('5','97','617','200998',3912644,'1719','237',467971.19,467974.22,3.03,499.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','200998',3912645,'1720','237',869057.48,870427.02,1369.54,225974.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','200998',3912646,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200998',3912647,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200998',3912648,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200998',3912649,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','200998',3912650,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200998',3912651,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200998',3912652,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','200998',3912653,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','200998',3912654,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','200998',3912655,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','200998',3912656,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','201157',3915204,'1713','237',1601380.24,1603340.97,1960.73,323520.45,0.00,0.00,0.00,0.00,0.00),('5','97','614','201157',3915205,'1714','237',1279929.80,1280906.61,976.81,161173.65,0.00,0.00,0.00,0.00,0.00),('5','97','615','201157',3915206,'1715','237',1456716.82,1459251.07,2534.25,418151.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','201157',3915207,'1716','237',1447328.76,1449381.68,2052.92,338731.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','201157',3915208,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201157',3915209,'1718','237',718323.56,719231.99,908.43,149890.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','201157',3915210,'1719','237',467974.22,467974.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201157',3915211,'1720','237',870427.02,871472.42,1045.40,172491.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201157',3915212,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201157',3915213,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201157',3915214,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201157',3915215,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201157',3915216,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201157',3915217,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201157',3915218,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201157',3915219,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','201157',3915220,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','201157',3915221,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','201157',3915222,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','201406',3919673,'1713','237',1603340.97,1605521.75,2180.78,359828.70,0.00,0.00,0.00,0.00,0.00),('5','97','614','201406',3919674,'1714','237',1280906.61,1282801.41,1894.80,312642.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','201406',3919675,'1715','237',1459251.07,1461437.25,2186.18,360719.70,0.00,0.00,0.00,0.00,0.00),('5','97','615','201406',3919676,'1716','237',1449381.68,1452477.07,3095.39,510739.35,0.00,0.00,0.00,0.00,0.00),('5','97','616','201406',3919677,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201406',3919678,'1718','237',719231.99,720426.76,1194.77,197137.05,0.00,0.00,0.00,0.00,0.00),('5','97','617','201406',3919679,'1719','237',467974.22,467974.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201406',3919680,'1720','237',871472.42,873036.67,1564.25,258101.25,0.00,0.00,0.00,0.00,0.00),('5','97','616','201406',3919681,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201406',3919682,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201406',3919683,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201406',3919684,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201406',3919685,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201406',3919686,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201406',3919687,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201406',3919688,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','201406',3919689,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','201406',3919690,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','201406',3919691,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','201551',3922228,'1713','237',1605521.75,1607185.01,1663.26,274437.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','201551',3922229,'1714','237',1282801.41,1285351.75,2550.34,420806.10,0.00,0.00,0.00,0.00,0.00),('5','97','615','201551',3922230,'1715','237',1461437.25,1463178.06,1740.81,287233.65,0.00,0.00,0.00,0.00,0.00),('5','97','615','201551',3922231,'1716','237',1452477.07,1454348.44,1871.37,308776.05,0.00,0.00,0.00,0.00,0.00),('5','97','616','201551',3922232,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201551',3922233,'1718','237',720426.76,721529.30,1102.54,181919.10,0.00,0.00,0.00,0.00,0.00),('5','97','617','201551',3922234,'1719','237',467974.22,468197.26,223.04,36801.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','201551',3922235,'1720','237',873036.67,873387.86,351.19,57946.35,0.00,0.00,0.00,0.00,0.00),('5','97','616','201551',3922236,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201551',3922237,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201551',3922238,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201551',3922239,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201551',3922240,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201551',3922241,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201551',3922242,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201551',3922243,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','201551',3922244,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','201551',3922245,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','201551',3922246,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','201785',3926869,'1713','237',1607185.01,1608462.87,1277.86,210846.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','201785',3926870,'1714','237',1285351.75,1287787.23,2435.48,401854.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','201785',3926871,'1715','237',1463178.06,1466660.79,3482.73,574650.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','201785',3926872,'1716','237',1454348.44,1455148.99,800.55,132090.75,0.00,0.00,0.00,0.00,0.00),('5','97','616','201785',3926873,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201785',3926874,'1718','237',721529.30,723908.59,2379.29,392582.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','201785',3926875,'1719','237',468197.26,468197.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201785',3926876,'1720','237',873387.86,873387.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201785',3926877,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201785',3926878,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201785',3926879,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201785',3926880,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','201785',3926881,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201785',3926882,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201785',3926883,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','201785',3926884,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','201785',3926885,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','201785',3926886,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','201785',3926887,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202080',3932419,'1713','237',1608462.87,1610892.71,2429.84,400923.60,0.00,0.00,0.00,0.00,0.00),('5','97','614','202080',3932420,'1714','237',1287787.23,1289214.38,1427.15,235479.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','202080',3932421,'1715','237',1466660.79,1470728.98,4068.19,671251.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','202080',3932422,'1716','237',1455148.99,1455148.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202080',3932423,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202080',3932424,'1718','237',723908.59,726150.97,2242.38,369992.70,0.00,0.00,0.00,0.00,0.00),('5','97','617','202080',3932425,'1719','237',468197.26,469003.83,806.57,133084.05,0.00,0.00,0.00,0.00,0.00),('5','97','617','202080',3932426,'1720','237',873387.86,874554.59,1166.73,192510.45,0.00,0.00,0.00,0.00,0.00),('5','97','616','202080',3932427,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202080',3932428,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202080',3932429,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202080',3932430,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202080',3932431,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202080',3932432,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202080',3932433,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202080',3932434,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202080',3932435,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202080',3932436,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','202080',3932437,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202213',3934659,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202213',3934660,'1714','237',1289214.38,1290886.59,1672.21,275914.65,0.00,0.00,0.00,0.00,0.00),('5','97','615','202213',3934661,'1715','237',1470728.98,1474218.15,3489.17,575713.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','202213',3934662,'1716','237',1455148.99,1456121.85,972.86,160521.90,0.00,0.00,0.00,0.00,0.00),('5','97','616','202213',3934663,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202213',3934664,'1718','237',726150.97,728300.92,2149.95,354741.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','202213',3934665,'1719','237',469003.83,469995.81,991.98,163676.70,0.00,0.00,0.00,0.00,0.00),('5','97','617','202213',3934666,'1720','237',874554.59,876179.80,1625.21,268159.65,0.00,0.00,0.00,0.00,0.00),('5','97','616','202213',3934667,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202213',3934668,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202213',3934669,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202213',3934670,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202213',3934671,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202213',3934672,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202213',3934673,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202213',3934674,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202213',3934675,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202213',3934676,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','202213',3934677,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202426',3938419,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202426',3938420,'1714','237',1290886.59,1293112.47,2225.88,367270.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','202426',3938421,'1715','237',1474218.15,1477709.34,3491.19,576046.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','202426',3938422,'1716','237',1456121.85,1456121.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202426',3938423,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202426',3938424,'1718','237',728300.92,730579.70,2278.78,375998.70,0.00,0.00,0.00,0.00,0.00),('5','97','617','202426',3938425,'1719','237',469995.81,470941.70,945.89,156071.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','202426',3938426,'1720','237',876179.80,876789.96,610.16,100676.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','202426',3938427,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202426',3938428,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202426',3938429,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202426',3938430,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202426',3938431,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202426',3938432,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202426',3938433,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202426',3938434,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202426',3938435,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202426',3938436,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','202426',3938437,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202642',3942154,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202642',3942155,'1714','237',1293112.47,1295825.43,2712.96,447638.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','202642',3942156,'1715','237',1477709.34,1480620.55,2911.21,480349.65,0.00,0.00,0.00,0.00,0.00),('5','97','615','202642',3942157,'1716','237',1456121.85,1456121.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202642',3942158,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202642',3942159,'1718','237',730579.70,733008.86,2429.16,400811.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','202642',3942160,'1719','237',470941.70,471620.68,678.98,112031.70,0.00,0.00,0.00,0.00,0.00),('5','97','617','202642',3942161,'1720','237',876789.96,877540.88,750.92,123901.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','202642',3942162,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202642',3942163,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202642',3942164,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202642',3942165,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202642',3942166,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202642',3942167,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202642',3942168,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202642',3942169,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202642',3942170,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202642',3942171,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','202642',3942172,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202843',3945821,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','202843',3945822,'1714','237',1295825.43,1299294.04,3468.61,572320.65,0.00,0.00,0.00,0.00,0.00),('5','97','615','202843',3945823,'1715','237',1480620.55,1482106.42,1485.87,245168.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','202843',3945824,'1716','237',1456121.85,1458799.92,2678.07,441881.55,0.00,0.00,0.00,0.00,0.00),('5','97','616','202843',3945825,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202843',3945826,'1718','237',733008.86,734290.17,1281.31,211416.15,0.00,0.00,0.00,0.00,0.00),('5','97','617','202843',3945827,'1719','237',471620.68,472706.59,1085.91,179175.15,0.00,0.00,0.00,0.00,0.00),('5','97','617','202843',3945828,'1720','237',877540.88,878879.12,1338.24,220809.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','202843',3945829,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202843',3945830,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202843',3945831,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202843',3945832,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','202843',3945833,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202843',3945834,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202843',3945835,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','202843',3945836,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202843',3945837,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','202843',3945838,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','202843',3945839,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203131',3951062,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203131',3951063,'1714','237',1299294.04,1301847.52,2553.48,421324.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','203131',3951064,'1715','237',1482106.42,1483976.40,1869.98,308546.70,0.00,0.00,0.00,0.00,0.00),('5','97','615','203131',3951065,'1716','237',1458799.92,1460929.00,2129.08,351298.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','203131',3951066,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203131',3951067,'1718','237',734290.17,735245.89,955.72,157693.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','203131',3951068,'1719','237',472706.59,473781.36,1074.77,177337.05,0.00,0.00,0.00,0.00,0.00),('5','97','617','203131',3951069,'1720','237',878879.12,879402.85,523.73,86415.45,0.00,0.00,0.00,0.00,0.00),('5','97','616','203131',3951070,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203131',3951071,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203131',3951072,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203131',3951073,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203131',3951074,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203131',3951075,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203131',3951076,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203131',3951077,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203131',3951078,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203131',3951079,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','203131',3951080,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203305',3954467,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203305',3954468,'1714','237',1301847.52,1304842.87,2995.35,494232.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','203305',3954469,'1715','237',1483976.40,1484967.96,991.56,163607.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','203305',3954470,'1716','237',1460929.00,1464088.61,3159.61,521335.65,0.00,0.00,0.00,0.00,0.00),('5','97','616','203305',3954471,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203305',3954472,'1718','237',735245.89,737063.34,1817.45,299879.25,0.00,0.00,0.00,0.00,0.00),('5','97','617','203305',3954473,'1719','237',473781.36,473781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203305',3954474,'1720','237',879402.85,880455.28,1052.43,173650.95,0.00,0.00,0.00,0.00,0.00),('5','97','616','203305',3954475,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203305',3954476,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203305',3954477,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203305',3954478,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203305',3954479,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203305',3954480,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203305',3954481,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203305',3954482,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203305',3954483,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203305',3954484,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','203305',3954485,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203526',3958325,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203526',3958326,'1714','237',1304842.87,1307091.31,2248.44,370992.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','203526',3958327,'1715','237',1484967.96,1487400.90,2432.94,401435.10,0.00,0.00,0.00,0.00,0.00),('5','97','615','203526',3958328,'1716','237',1464088.61,1466647.89,2559.28,422281.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','203526',3958329,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203526',3958330,'1718','237',737063.34,738173.90,1110.56,183242.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','203526',3958331,'1719','237',473781.36,473781.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203526',3958332,'1720','237',880455.28,881611.20,1155.92,190726.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','203526',3958333,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203526',3958334,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203526',3958335,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203526',3958336,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203526',3958337,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203526',3958338,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203526',3958339,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203526',3958340,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203526',3958341,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203526',3958342,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','203526',3958343,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203719',3961912,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203719',3961913,'1714','237',1307091.31,1309743.78,2652.47,437657.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','203719',3961914,'1715','237',1487400.90,1489237.48,1836.58,303035.70,0.00,0.00,0.00,0.00,0.00),('5','97','615','203719',3961915,'1716','237',1466647.89,1470073.88,3425.99,565288.35,0.00,0.00,0.00,0.00,0.00),('5','97','616','203719',3961916,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203719',3961917,'1718','237',738173.90,738173.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203719',3961918,'1719','237',473781.36,475311.55,1530.19,252481.35,0.00,0.00,0.00,0.00,0.00),('5','97','617','203719',3961919,'1720','237',881611.20,882581.32,970.12,160069.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','203719',3961920,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203719',3961921,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203719',3961922,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203719',3961923,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203719',3961924,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203719',3961925,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203719',3961926,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203719',3961927,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203719',3961928,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203719',3961929,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','203719',3961930,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203956',3966044,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','203956',3966045,'1714','237',1309743.78,1311804.49,2060.71,340017.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','203956',3966046,'1715','237',1489237.48,1491929.63,2692.15,444204.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','203956',3966047,'1716','237',1470073.88,1472160.31,2086.43,344260.95,0.00,0.00,0.00,0.00,0.00),('5','97','616','203956',3966048,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203956',3966049,'1718','237',738173.90,739171.45,997.55,164595.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','203956',3966050,'1719','237',475311.55,476094.24,782.69,129143.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','203956',3966051,'1720','237',882581.32,883221.89,640.57,105694.05,0.00,0.00,0.00,0.00,0.00),('5','97','616','203956',3966052,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203956',3966053,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203956',3966054,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203956',3966055,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','203956',3966056,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203956',3966057,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203956',3966058,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','203956',3966059,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203956',3966060,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','203956',3966061,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','203956',3966062,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','204179',3970272,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','204179',3970273,'1714','237',1311804.49,1313286.92,1482.43,244600.95,0.00,0.00,0.00,0.00,0.00),('5','97','615','204179',3970274,'1715','237',1491929.63,1493631.80,1702.17,280858.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','204179',3970275,'1716','237',1472160.31,1474091.19,1930.88,318595.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','204179',3970276,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204179',3970277,'1718','237',739171.45,740698.37,1526.92,251941.80,0.00,0.00,0.00,0.00,0.00),('5','97','617','204179',3970278,'1719','237',476094.24,476818.89,724.65,119567.25,0.00,0.00,0.00,0.00,0.00),('5','97','617','204179',3970279,'1720','237',883221.89,884048.27,826.38,136352.70,0.00,0.00,0.00,0.00,0.00),('5','97','616','204179',3970280,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204179',3970281,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204179',3970282,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204179',3970283,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204179',3970284,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204179',3970285,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204179',3970286,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204179',3970287,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','204179',3970288,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','204179',3970289,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','204179',3970290,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','204385',3973911,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','204385',3973912,'1714','237',1313286.92,1315589.82,2302.90,379978.50,0.00,0.00,0.00,0.00,0.00),('5','97','615','204385',3973913,'1715','237',1493631.80,1496622.47,2990.67,493460.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','204385',3973914,'1716','237',1474091.19,1476772.56,2681.37,442426.05,0.00,0.00,0.00,0.00,0.00),('5','97','616','204385',3973915,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204385',3973916,'1718','237',740698.37,742711.53,2013.16,332171.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','204385',3973917,'1719','237',476818.89,476818.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204385',3973918,'1720','237',884048.27,884647.97,599.70,98950.50,0.00,0.00,0.00,0.00,0.00),('5','97','616','204385',3973919,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204385',3973920,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204385',3973921,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204385',3973922,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204385',3973923,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204385',3973924,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204385',3973925,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204385',3973926,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','204385',3973927,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','204385',3973928,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','204385',3973929,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','204616',3978030,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','204616',3978031,'1714','237',1315589.82,1317469.02,1879.20,310068.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','204616',3978032,'1715','237',1496622.47,1499129.43,2506.96,413648.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','204616',3978033,'1716','237',1476772.56,1476772.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204616',3978034,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204616',3978035,'1718','237',742711.53,744922.53,2211.00,364815.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204616',3978036,'1719','237',476818.89,478193.98,1375.09,226889.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','204616',3978037,'1720','237',884647.97,884660.09,12.12,1999.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','204616',3978038,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204616',3978039,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204616',3978040,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204616',3978041,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204616',3978042,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204616',3978043,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204616',3978044,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204616',3978045,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','204616',3978046,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','204616',3978047,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','204616',3978048,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','204860',3981871,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','204860',3981872,'1714','237',1317469.02,1319571.13,2102.11,346848.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','204860',3981873,'1715','237',1499129.43,1501810.68,2681.25,442406.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','204860',3981874,'1716','237',1476772.56,1476824.07,51.51,8499.15,0.00,0.00,0.00,0.00,0.00),('5','97','616','204860',3981875,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204860',3981876,'1718','237',744922.53,747498.91,2576.38,425102.70,0.00,0.00,0.00,0.00,0.00),('5','97','617','204860',3981877,'1719','237',478193.98,478919.76,725.78,119753.70,0.00,0.00,0.00,0.00,0.00),('5','97','617','204860',3981878,'1720','237',884660.09,884660.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204860',3981879,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204860',3981880,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204860',3981881,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204860',3981882,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','204860',3981883,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204860',3981884,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204860',3981885,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','204860',3981886,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','204860',3981887,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','204860',3981888,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','204860',3981889,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205036',3985176,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205036',3985177,'1714','237',1319571.13,1321024.41,1453.28,239791.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','205036',3985178,'1715','237',1501810.68,1504625.13,2814.45,464384.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','205036',3985179,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205036',3985180,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205036',3985181,'1718','237',747498.91,750204.94,2706.03,446494.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','205036',3985182,'1719','237',478919.76,480655.87,1736.11,286458.15,0.00,0.00,0.00,0.00,0.00),('5','97','617','205036',3985183,'1720','237',884660.09,885675.06,1014.97,167470.05,0.00,0.00,0.00,0.00,0.00),('5','97','616','205036',3985184,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205036',3985185,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205036',3985186,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205036',3985187,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205036',3985188,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205036',3985189,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205036',3985190,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205036',3985191,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205036',3985192,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205036',3985193,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','205036',3985194,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205309',3989934,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205309',3989935,'1714','237',1321024.41,1323202.76,2178.35,359427.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','205309',3989936,'1715','237',1504625.13,1507520.26,2895.13,477696.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','205309',3989937,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205309',3989938,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205309',3989939,'1718','237',750204.94,751975.17,1770.23,292087.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','205309',3989940,'1719','237',480655.87,481848.62,1192.75,196803.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','205309',3989941,'1720','237',885675.06,886798.46,1123.40,185361.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205309',3989942,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205309',3989943,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205309',3989944,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205309',3989945,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205309',3989946,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205309',3989947,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205309',3989948,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205309',3989949,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205309',3989950,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205309',3989951,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','205309',3989952,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205491',3993270,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205491',3993271,'1714','237',1323202.76,1325066.05,1863.29,307442.85,0.00,0.00,0.00,0.00,0.00),('5','97','615','205491',3993272,'1715','237',1507520.26,1509679.77,2159.51,356319.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','205491',3993273,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205491',3993274,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205491',3993275,'1718','237',751975.17,754548.07,2572.90,424528.50,0.00,0.00,0.00,0.00,0.00),('5','97','617','205491',3993276,'1719','237',481848.62,482829.91,981.29,161912.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','205491',3993277,'1720','237',886798.46,887739.30,940.84,155238.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','205491',3993278,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205491',3993279,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205491',3993280,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205491',3993281,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205491',3993282,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205491',3993283,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205491',3993284,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205491',3993285,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205491',3993286,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205491',3993287,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','205491',3993288,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205717',3997655,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205717',3997656,'1714','237',1325066.05,1326761.28,1695.23,279712.95,0.00,0.00,0.00,0.00,0.00),('5','97','615','205717',3997657,'1715','237',1509679.77,1512756.81,3077.04,507711.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','205717',3997658,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205717',3997659,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205717',3997660,'1718','237',754548.07,756377.16,1829.09,301799.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','205717',3997661,'1719','237',482829.91,483915.07,1085.16,179051.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','205717',3997662,'1720','237',887739.30,888728.02,988.72,163138.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','205717',3997663,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205717',3997664,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205717',3997665,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205717',3997666,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205717',3997667,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205717',3997668,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205717',3997669,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205717',3997670,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205717',3997671,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205717',3997672,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','205717',3997673,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205932',4001454,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','205932',4001455,'1714','237',1326761.28,1329290.90,2529.62,417387.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','205932',4001456,'1715','237',1512756.81,1515289.96,2533.15,417969.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','205932',4001457,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205932',4001458,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205932',4001459,'1718','237',756377.16,758689.85,2312.69,381593.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','205932',4001460,'1719','237',483915.07,484528.08,613.01,101146.65,0.00,0.00,0.00,0.00,0.00),('5','97','617','205932',4001461,'1720','237',888728.02,889926.55,1198.53,197757.45,0.00,0.00,0.00,0.00,0.00),('5','97','616','205932',4001462,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205932',4001463,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205932',4001464,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205932',4001465,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','205932',4001466,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205932',4001467,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205932',4001468,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','205932',4001469,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205932',4001470,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','205932',4001471,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','205932',4001472,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','206152',4005273,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','206152',4005274,'1714','237',1329290.90,1331460.12,2169.22,357921.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','206152',4005275,'1715','237',1515289.96,1518055.62,2765.66,456333.90,0.00,0.00,0.00,0.00,0.00),('5','97','615','206152',4005276,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206152',4005277,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206152',4005278,'1718','237',758689.85,760110.88,1421.03,234469.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','206152',4005279,'1719','237',484528.08,485426.15,898.07,148181.55,0.00,0.00,0.00,0.00,0.00),('5','97','617','206152',4005280,'1720','237',889926.55,890847.21,920.66,151908.90,0.00,0.00,0.00,0.00,0.00),('5','97','616','206152',4005281,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206152',4005282,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206152',4005283,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206152',4005284,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206152',4005285,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206152',4005286,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206152',4005287,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206152',4005288,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','206152',4005289,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','206152',4005290,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','206152',4005291,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','206463',4010559,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','206463',4010560,'1714','237',1331460.12,1332649.40,1189.28,196231.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','206463',4010561,'1715','237',1518055.62,1521593.86,3538.24,583809.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','206463',4010562,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206463',4010563,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206463',4010564,'1718','237',760110.88,762294.11,2183.23,360232.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','206463',4010565,'1719','237',485426.15,485881.28,455.13,75096.45,0.00,0.00,0.00,0.00,0.00),('5','97','617','206463',4010566,'1720','237',890847.21,892398.55,1551.34,255971.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','206463',4010567,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206463',4010568,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206463',4010569,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206463',4010570,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206463',4010571,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206463',4010572,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206463',4010573,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206463',4010574,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','206463',4010575,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','206463',4010576,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','206463',4010577,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','206577',4012572,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','206577',4012573,'1714','237',1332649.40,1334697.76,2048.36,337979.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','206577',4012574,'1715','237',1521593.86,1525265.63,3671.77,605842.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','206577',4012575,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206577',4012576,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206577',4012577,'1718','237',762294.11,764292.80,1998.69,329783.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','206577',4012578,'1719','237',485881.28,485881.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206577',4012579,'1720','237',892398.55,894231.78,1833.23,302482.95,0.00,0.00,0.00,0.00,0.00),('5','97','616','206577',4012580,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206577',4012581,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206577',4012582,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206577',4012583,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206577',4012584,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206577',4012585,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206577',4012586,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206577',4012587,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','206577',4012588,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','206577',4012589,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','206577',4012590,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','206802',4016549,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','206802',4016550,'1714','237',1334697.76,1336259.52,1561.76,257690.40,0.00,0.00,0.00,0.00,0.00),('5','97','615','206802',4016551,'1715','237',1525265.63,1528419.15,3153.52,520330.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','206802',4016552,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206802',4016553,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206802',4016554,'1718','237',764292.80,766094.03,1801.23,297202.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','206802',4016555,'1719','237',485881.28,486968.23,1086.95,179346.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','206802',4016556,'1720','237',894231.78,895203.14,971.36,160274.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','206802',4016557,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206802',4016558,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206802',4016559,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206802',4016560,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','206802',4016561,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206802',4016562,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206802',4016563,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','206802',4016564,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','206802',4016565,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','206802',4016566,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','206802',4016567,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','207012',4020544,'1713','237',1610892.71,1610892.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','207012',4020545,'1714','237',1336259.52,1340387.35,4127.83,681091.95,0.00,0.00,0.00,0.00,0.00),('5','97','615','207012',4020546,'1715','237',1528419.15,1528708.09,288.94,47675.10,0.00,0.00,0.00,0.00,0.00),('5','97','615','207012',4020547,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207012',4020548,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207012',4020549,'1718','237',766094.03,769309.97,3215.94,530630.10,0.00,0.00,0.00,0.00,0.00),('5','97','617','207012',4020550,'1719','237',486968.23,486968.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207012',4020551,'1720','237',895203.14,895310.78,107.64,17760.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','207012',4020552,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207012',4020553,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207012',4020554,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207012',4020555,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207012',4020556,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207012',4020557,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207012',4020558,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207012',4020559,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207012',4020560,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207012',4020561,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','207012',4020562,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','207257',4024763,'1713','237',1610892.71,1612434.59,1541.88,254410.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','207257',4024764,'1714','237',1340387.35,1344696.26,4308.91,710970.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','207257',4024765,'1715','237',1528708.09,1528708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','207257',4024766,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207257',4024767,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207257',4024768,'1718','237',769309.97,772329.37,3019.40,498201.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207257',4024769,'1719','237',486968.23,486968.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207257',4024770,'1720','237',895310.78,895310.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207257',4024771,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207257',4024772,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207257',4024773,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207257',4024774,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207257',4024775,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207257',4024776,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207257',4024777,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207257',4024778,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207257',4024779,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207257',4024780,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','207257',4024781,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','207484',4028856,'1713','237',1612434.59,1614928.69,2494.10,411526.50,0.00,0.00,0.00,0.00,0.00),('5','97','614','207484',4028857,'1714','237',1344696.26,1347698.30,3002.04,495336.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','207484',4028858,'1715','237',1528708.09,1528708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','207484',4028859,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207484',4028860,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207484',4028861,'1718','237',772329.37,774954.57,2625.20,433158.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207484',4028862,'1719','237',486968.23,486968.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207484',4028863,'1720','237',895310.78,895310.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207484',4028864,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207484',4028865,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207484',4028866,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207484',4028867,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207484',4028868,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207484',4028869,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207484',4028870,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207484',4028871,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207484',4028872,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207484',4028873,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','207484',4028874,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','207712',4032676,'1713','237',1614928.69,1617654.71,2726.02,449793.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','207712',4032677,'1714','237',1347698.30,1350964.35,3266.05,538898.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','207712',4032678,'1715','237',1528708.09,1528708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','207712',4032679,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207712',4032680,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207712',4032681,'1718','237',774954.57,777410.01,2455.44,405147.60,0.00,0.00,0.00,0.00,0.00),('5','97','617','207712',4032682,'1719','237',486968.23,486968.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207712',4032683,'1720','237',895310.78,895310.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207712',4032684,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207712',4032685,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207712',4032686,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207712',4032687,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207712',4032688,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207712',4032689,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207712',4032690,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207712',4032691,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207712',4032692,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207712',4032693,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','207712',4032694,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','207915',4036111,'1713','237',1617654.71,1621632.17,3977.46,656280.90,0.00,0.00,0.00,0.00,0.00),('5','97','614','207915',4036112,'1714','237',1350964.35,1356326.84,5362.49,884810.85,0.00,0.00,0.00,0.00,0.00),('5','97','615','207915',4036113,'1715','237',1528708.09,1528708.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','207915',4036114,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207915',4036115,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207915',4036116,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207915',4036117,'1719','237',486968.23,486968.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207915',4036118,'1720','237',895310.78,895310.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207915',4036119,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207915',4036120,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207915',4036121,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207915',4036122,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','207915',4036123,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207915',4036124,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207915',4036125,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','207915',4036126,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207915',4036127,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','207915',4036128,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','207915',4036129,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','208123',4039765,'1713','237',1621632.17,1624385.74,2753.57,454339.05,0.00,0.00,0.00,0.00,0.00),('5','97','614','208123',4039766,'1714','237',1356326.84,1359329.76,3002.92,495481.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','208123',4039767,'1715','237',1528708.09,1531719.82,3011.73,496935.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','208123',4039768,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208123',4039769,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208123',4039770,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208123',4039771,'1719','237',486968.23,486968.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208123',4039772,'1720','237',895310.78,897104.76,1793.98,296006.70,0.00,0.00,0.00,0.00,0.00),('5','97','616','208123',4039773,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208123',4039774,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208123',4039775,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208123',4039776,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208123',4039777,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208123',4039778,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208123',4039779,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208123',4039780,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','208123',4039781,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','208123',4039782,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','208123',4039783,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','208490',4046330,'1713','237',1624385.74,1626505.41,2119.67,349745.55,0.00,0.00,0.00,0.00,0.00),('5','97','614','208490',4046331,'1714','237',1359329.76,1361310.60,1980.84,326838.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','208490',4046332,'1715','237',1531719.82,1535141.72,3421.90,564613.50,0.00,0.00,0.00,0.00,0.00),('5','97','615','208490',4046333,'1716','237',1476824.07,1476824.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208490',4046334,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208490',4046335,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208490',4046336,'1719','237',486968.23,486968.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208490',4046337,'1720','237',897104.76,898337.73,1232.97,203440.05,0.00,0.00,0.00,0.00,0.00),('5','97','616','208490',4046338,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208490',4046339,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208490',4046340,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208490',4046341,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208490',4046342,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208490',4046343,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208490',4046344,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208490',4046345,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','208490',4046346,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','208490',4046347,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','208490',4046348,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','208591',4047981,'1713','237',1626505.41,1627725.28,1219.87,201278.55,0.00,0.00,0.00,0.00,0.00),('5','97','614','208591',4047982,'1714','237',1361310.60,1363306.33,1995.73,329295.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','208591',4047983,'1715','237',1535141.72,1537711.85,2570.13,424071.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','208591',4047984,'1716','237',1476824.07,1477848.76,1024.69,169073.85,0.00,0.00,0.00,0.00,0.00),('5','97','616','208591',4047985,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208591',4047986,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208591',4047987,'1719','237',486968.23,487517.54,549.31,90636.15,0.00,0.00,0.00,0.00,0.00),('5','97','617','208591',4047988,'1720','237',898337.73,899456.75,1119.02,184638.30,0.00,0.00,0.00,0.00,0.00),('5','97','616','208591',4047989,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208591',4047990,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208591',4047991,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208591',4047992,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208591',4047993,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208591',4047994,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208591',4047995,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208591',4047996,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','208591',4047997,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','208591',4047998,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','208591',4047999,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','208755',4051043,'1713','237',1627725.28,1629793.33,2068.05,341228.25,0.00,0.00,0.00,0.00,0.00),('5','97','614','208755',4051044,'1714','237',1363306.33,1364641.59,1335.26,220317.90,0.00,0.00,0.00,0.00,0.00),('5','97','615','208755',4051045,'1715','237',1537711.85,1540286.24,2574.39,424774.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','208755',4051046,'1716','237',1477848.76,1478566.02,717.26,118347.90,0.00,0.00,0.00,0.00,0.00),('5','97','616','208755',4051047,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208755',4051048,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208755',4051049,'1719','237',487517.54,488022.64,505.10,83341.50,0.00,0.00,0.00,0.00,0.00),('5','97','617','208755',4051050,'1720','237',899456.75,899456.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208755',4051051,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208755',4051052,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208755',4051053,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208755',4051054,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','208755',4051055,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208755',4051056,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208755',4051057,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','208755',4051058,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','208755',4051059,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','208755',4051060,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','208755',4051061,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','209001',4055140,'1713','237',1629793.33,1632088.44,2295.11,378693.15,0.00,0.00,0.00,0.00,0.00),('5','97','614','209001',4055141,'1714','237',1364641.59,1367134.16,2492.57,411274.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','209001',4055142,'1715','237',1540286.24,1541447.63,1161.39,191629.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','209001',4055143,'1716','237',1478566.02,1482358.95,3792.93,625833.45,0.00,0.00,0.00,0.00,0.00),('5','97','616','209001',4055144,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209001',4055145,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209001',4055146,'1719','237',488022.64,488400.50,377.86,62346.90,0.00,0.00,0.00,0.00,0.00),('5','97','617','209001',4055147,'1720','237',899456.75,899456.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209001',4055148,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209001',4055149,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209001',4055150,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209001',4055151,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209001',4055152,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209001',4055153,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209001',4055154,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209001',4055155,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209001',4055156,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209001',4055157,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','209001',4055158,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','209204',4058880,'1713','237',1632088.44,1633813.66,1725.22,284661.30,0.00,0.00,0.00,0.00,0.00),('5','97','614','209204',4058881,'1714','237',1367134.16,1369453.48,2319.32,382687.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','209204',4058882,'1715','237',1541447.63,1544685.85,3238.22,534306.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','209204',4058883,'1716','237',1482358.95,1482358.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209204',4058884,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209204',4058885,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209204',4058886,'1719','237',488400.50,488400.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209204',4058887,'1720','237',899456.75,899456.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209204',4058888,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209204',4058889,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209204',4058890,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209204',4058891,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209204',4058892,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209204',4058893,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209204',4058894,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209204',4058895,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209204',4058896,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209204',4058897,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','209204',4058898,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','209425',4062771,'1713','237',1633813.66,1637046.18,3232.52,533365.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','209425',4062772,'1714','237',1369453.48,1369453.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','209425',4062773,'1715','237',1544685.85,1548390.00,3704.15,611184.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','209425',4062774,'1716','237',1482358.95,1482358.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209425',4062775,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209425',4062776,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209425',4062777,'1719','237',488400.50,490183.44,1782.94,294185.10,0.00,0.00,0.00,0.00,0.00),('5','97','617','209425',4062778,'1720','237',899456.75,899456.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209425',4062779,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209425',4062780,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209425',4062781,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209425',4062782,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209425',4062783,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209425',4062784,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209425',4062785,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209425',4062786,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209425',4062787,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209425',4062788,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','209425',4062789,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','209748',4068433,'1713','237',1637046.18,1640366.90,3320.72,547918.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','209748',4068434,'1714','237',1369453.48,1371860.40,2406.92,397141.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','209748',4068435,'1715','237',1548390.00,1549664.22,1274.22,210246.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','209748',4068436,'1716','237',1482358.95,1482358.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209748',4068437,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209748',4068438,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209748',4068439,'1719','237',490183.44,493118.00,2934.56,484202.40,0.00,0.00,0.00,0.00,0.00),('5','97','617','209748',4068440,'1720','237',899456.75,899456.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209748',4068441,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209748',4068442,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209748',4068443,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209748',4068444,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209748',4068445,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209748',4068446,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209748',4068447,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209748',4068448,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209748',4068449,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209748',4068450,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','209748',4068451,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','209865',4070453,'1713','237',1640366.90,1642780.59,2413.69,398258.85,0.00,0.00,0.00,0.00,0.00),('5','97','614','209865',4070454,'1714','237',1371860.40,1375196.54,3336.14,550463.10,0.00,0.00,0.00,0.00,0.00),('5','97','615','209865',4070455,'1715','237',1549664.22,1549664.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','209865',4070456,'1716','237',1482358.95,1483956.51,1597.56,263597.40,0.00,0.00,0.00,0.00,0.00),('5','97','616','209865',4070457,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209865',4070458,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209865',4070459,'1719','237',493118.00,494242.15,1124.15,185484.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','209865',4070460,'1720','237',899456.75,900168.54,711.79,117445.35,0.00,0.00,0.00,0.00,0.00),('5','97','616','209865',4070461,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209865',4070462,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209865',4070463,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209865',4070464,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','209865',4070465,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209865',4070466,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209865',4070467,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','209865',4070468,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209865',4070469,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','209865',4070470,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','209865',4070471,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','210093',4074677,'1713','237',1642780.59,1644158.34,1377.75,227328.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','210093',4074678,'1714','237',1375196.54,1377087.76,1891.22,312051.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','210093',4074679,'1715','237',1549664.22,1552092.43,2428.21,400654.65,0.00,0.00,0.00,0.00,0.00),('5','97','615','210093',4074680,'1716','237',1483956.51,1486888.03,2931.52,483700.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','210093',4074681,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210093',4074682,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210093',4074683,'1719','237',494242.15,494444.50,202.35,33387.75,0.00,0.00,0.00,0.00,0.00),('5','97','617','210093',4074684,'1720','237',900168.54,900168.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210093',4074685,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210093',4074686,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210093',4074687,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210093',4074688,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210093',4074689,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210093',4074690,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210093',4074691,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210093',4074692,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','210093',4074693,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','210093',4074694,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','210093',4074695,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','210296',4078225,'1713','237',1644158.34,1645762.29,1603.95,264651.75,0.00,0.00,0.00,0.00,0.00),('5','97','614','210296',4078226,'1714','237',1377087.76,1379003.83,1916.07,316151.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','210296',4078227,'1715','237',1552092.43,1555093.67,3001.24,495204.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','210296',4078228,'1716','237',1486888.03,1489880.27,2992.24,493719.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','210296',4078229,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210296',4078230,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210296',4078231,'1719','237',494444.50,494444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210296',4078232,'1720','237',900168.54,900168.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210296',4078233,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210296',4078234,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210296',4078235,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210296',4078236,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210296',4078237,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210296',4078238,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210296',4078239,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210296',4078240,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','210296',4078241,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','210296',4078242,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','210296',4078243,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','210503',4082061,'1713','237',1645762.29,1647824.72,2062.43,340300.95,0.00,0.00,0.00,0.00,0.00),('5','97','614','210503',4082062,'1714','237',1379003.83,1381705.25,2701.42,445734.30,0.00,0.00,0.00,0.00,0.00),('5','97','615','210503',4082063,'1715','237',1555093.67,1557880.52,2786.85,459830.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','210503',4082064,'1716','237',1489880.27,1493137.39,3257.12,537424.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','210503',4082065,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210503',4082066,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210503',4082067,'1719','237',494444.50,494444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210503',4082068,'1720','237',900168.54,900168.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210503',4082069,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210503',4082070,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210503',4082071,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210503',4082072,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210503',4082073,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210503',4082074,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210503',4082075,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210503',4082076,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','210503',4082077,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','210503',4082078,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','210503',4082079,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','210717',4085827,'1713','237',1647824.72,1648269.70,444.98,73421.70,0.00,0.00,0.00,0.00,0.00),('5','97','614','210717',4085828,'1714','237',1381705.25,1382107.42,402.17,66358.05,0.00,0.00,0.00,0.00,0.00),('5','97','615','210717',4085829,'1715','237',1557880.52,1562003.24,4122.72,680248.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','210717',4085830,'1716','237',1493137.39,1497700.72,4563.33,752949.45,0.00,0.00,0.00,0.00,0.00),('5','97','616','210717',4085831,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210717',4085832,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210717',4085833,'1719','237',494444.50,494444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210717',4085834,'1720','237',900168.54,900168.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210717',4085835,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210717',4085836,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210717',4085837,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210717',4085838,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','210717',4085839,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210717',4085840,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210717',4085841,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','210717',4085842,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','210717',4085843,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','210717',4085844,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','210717',4085845,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','211049',4091316,'1713','237',1648269.70,1650138.57,1868.87,308363.55,0.00,0.00,0.00,0.00,0.00),('5','97','614','211049',4091317,'1714','237',1382107.42,1385273.55,3166.13,522411.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','211049',4091318,'1715','237',1562003.24,1565507.99,3504.75,578283.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','211049',4091319,'1716','237',1497700.72,1501603.17,3902.45,643904.25,0.00,0.00,0.00,0.00,0.00),('5','97','616','211049',4091320,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211049',4091321,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211049',4091322,'1719','237',494444.50,494444.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211049',4091323,'1720','237',900168.54,900168.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211049',4091324,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211049',4091325,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211049',4091326,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211049',4091327,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211049',4091328,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211049',4091329,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211049',4091330,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211049',4091331,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211049',4091332,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211049',4091333,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','211049',4091334,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','211236',4094732,'1713','237',1650138.57,1653061.20,2922.63,482233.95,0.00,0.00,0.00,0.00,0.00),('5','97','614','211236',4094733,'1714','237',1385273.55,1388426.66,3153.11,520263.15,0.00,0.00,0.00,0.00,0.00),('5','97','615','211236',4094734,'1715','237',1565507.99,1568794.03,3286.04,542196.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','211236',4094735,'1716','237',1501603.17,1505432.69,3829.52,631870.80,0.00,0.00,0.00,0.00,0.00),('5','97','616','211236',4094736,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211236',4094737,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211236',4094738,'1719','237',494444.50,495994.37,1549.87,255728.55,0.00,0.00,0.00,0.00,0.00),('5','97','617','211236',4094739,'1720','237',900168.54,900168.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211236',4094740,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211236',4094741,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211236',4094742,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211236',4094743,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211236',4094744,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211236',4094745,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211236',4094746,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211236',4094747,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211236',4094748,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211236',4094749,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','211236',4094750,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','211357',4097086,'1713','237',1653061.20,1657175.51,4114.31,678861.15,0.00,0.00,0.00,0.00,0.00),('5','97','614','211357',4097087,'1714','237',1388426.66,1393402.06,4975.40,820941.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','211357',4097088,'1715','237',1568794.03,1570322.90,1528.87,252263.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','211357',4097089,'1716','237',1505432.69,1505432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211357',4097090,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211357',4097091,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211357',4097092,'1719','237',495994.37,498253.28,2258.91,372720.15,0.00,0.00,0.00,0.00,0.00),('5','97','617','211357',4097093,'1720','237',900168.54,902063.54,1895.00,312675.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211357',4097094,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211357',4097095,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211357',4097096,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211357',4097097,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211357',4097098,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211357',4097099,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211357',4097100,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211357',4097101,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211357',4097102,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211357',4097103,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','211357',4097104,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','211618',4101435,'1713','237',1657175.51,1659740.62,2565.11,423243.15,0.00,0.00,0.00,0.00,0.00),('5','97','614','211618',4101436,'1714','237',1393402.06,1397181.99,3779.93,623688.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','211618',4101437,'1715','237',1570322.90,1570322.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','211618',4101438,'1716','237',1505432.69,1505432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211618',4101439,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211618',4101440,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211618',4101441,'1719','237',498253.28,498253.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211618',4101442,'1720','237',902063.54,904021.22,1957.68,323017.20,0.00,0.00,0.00,0.00,0.00),('5','97','616','211618',4101443,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211618',4101444,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211618',4101445,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211618',4101446,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211618',4101447,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211618',4101448,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211618',4101449,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211618',4101450,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211618',4101451,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211618',4101452,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','211618',4101453,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','211766',4103990,'1713','237',1659740.62,1661891.10,2150.48,354829.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','211766',4103991,'1714','237',1397181.99,1399865.79,2683.80,442827.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','211766',4103992,'1715','237',1570322.90,1570322.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','211766',4103993,'1716','237',1505432.69,1505432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211766',4103994,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211766',4103995,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211766',4103996,'1719','237',498253.28,500065.57,1812.29,299027.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','211766',4103997,'1720','237',904021.22,905317.44,1296.22,213876.30,0.00,0.00,0.00,0.00,0.00),('5','97','616','211766',4103998,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211766',4103999,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211766',4104000,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211766',4104001,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','211766',4104002,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211766',4104003,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211766',4104004,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','211766',4104005,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211766',4104006,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','211766',4104007,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','211766',4104008,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','212167',4111011,'1713','237',1661891.10,1663527.33,1636.23,269977.95,0.00,0.00,0.00,0.00,0.00),('5','97','614','212167',4111012,'1714','237',1399865.79,1402573.04,2707.25,446696.25,0.00,0.00,0.00,0.00,0.00),('5','97','615','212167',4111013,'1715','237',1570322.90,1570322.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','212167',4111014,'1716','237',1505432.69,1505432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212167',4111015,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212167',4111016,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212167',4111017,'1719','237',500065.57,502404.17,2338.60,385869.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212167',4111018,'1720','237',905317.44,906653.07,1335.63,220378.95,0.00,0.00,0.00,0.00,0.00),('5','97','616','212167',4111019,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212167',4111020,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212167',4111021,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212167',4111022,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212167',4111023,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212167',4111024,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212167',4111025,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212167',4111026,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212167',4111027,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212167',4111028,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','212167',4111029,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','212213',4111958,'1713','237',1663527.33,1666061.25,2533.92,418096.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','212213',4111959,'1714','237',1402573.04,1402573.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','212213',4111960,'1715','237',1570322.90,1573318.63,2995.73,494295.45,0.00,0.00,0.00,0.00,0.00),('5','97','615','212213',4111961,'1716','237',1505432.69,1505432.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212213',4111962,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212213',4111963,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212213',4111964,'1719','237',502404.17,503602.60,1198.43,197740.95,0.00,0.00,0.00,0.00,0.00),('5','97','617','212213',4111965,'1720','237',906653.07,908505.32,1852.25,305621.25,0.00,0.00,0.00,0.00,0.00),('5','97','616','212213',4111966,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212213',4111967,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212213',4111968,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212213',4111969,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212213',4111970,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212213',4111971,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212213',4111972,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212213',4111973,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212213',4111974,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212213',4111975,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','212213',4111976,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','212475',4116531,'1713','237',1666061.25,1666322.18,260.93,43053.45,0.00,0.00,0.00,0.00,0.00),('5','97','614','212475',4116532,'1714','237',1402573.04,1402573.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','212475',4116533,'1715','237',1573318.63,1576903.67,3585.04,591531.60,0.00,0.00,0.00,0.00,0.00),('5','97','615','212475',4116534,'1716','237',1505432.69,1508828.02,3395.33,560229.45,0.00,0.00,0.00,0.00,0.00),('5','97','616','212475',4116535,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212475',4116536,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212475',4116537,'1719','237',503602.60,504351.45,748.85,123560.25,0.00,0.00,0.00,0.00,0.00),('5','97','617','212475',4116538,'1720','237',908505.32,910174.16,1668.84,275358.60,0.00,0.00,0.00,0.00,0.00),('5','97','616','212475',4116539,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212475',4116540,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212475',4116541,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212475',4116542,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212475',4116543,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212475',4116544,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212475',4116545,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212475',4116546,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212475',4116547,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212475',4116548,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','212475',4116549,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','212652',4119928,'1713','237',1666322.18,1666322.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','212652',4119929,'1714','237',1402573.04,1402573.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','212652',4119930,'1715','237',1576903.67,1581095.46,4191.79,691645.35,0.00,0.00,0.00,0.00,0.00),('5','97','615','212652',4119931,'1716','237',1508828.02,1512469.80,3641.78,600893.70,0.00,0.00,0.00,0.00,0.00),('5','97','616','212652',4119932,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212652',4119933,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212652',4119934,'1719','237',504351.45,506870.44,2518.99,415633.35,0.00,0.00,0.00,0.00,0.00),('5','97','617','212652',4119935,'1720','237',910174.16,910174.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212652',4119936,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212652',4119937,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212652',4119938,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212652',4119939,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212652',4119940,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212652',4119941,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212652',4119942,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212652',4119943,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212652',4119944,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212652',4119945,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','212652',4119946,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','212857',4123483,'1713','237',1666322.18,1666322.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','212857',4123484,'1714','237',1402573.04,1402573.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','212857',4123485,'1715','237',1581095.46,1584334.58,3239.12,534454.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','212857',4123486,'1716','237',1512469.80,1513772.45,1302.65,214937.25,0.00,0.00,0.00,0.00,0.00),('5','97','616','212857',4123487,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212857',4123488,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212857',4123489,'1719','237',506870.44,508070.13,1199.69,197948.85,0.00,0.00,0.00,0.00,0.00),('5','97','617','212857',4123490,'1720','237',910174.16,911380.45,1206.29,199037.85,0.00,0.00,0.00,0.00,0.00),('5','97','616','212857',4123491,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212857',4123492,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212857',4123493,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212857',4123494,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','212857',4123495,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212857',4123496,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212857',4123497,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','212857',4123498,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212857',4123499,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','212857',4123500,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','212857',4123501,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','213233',4129770,'1713','237',1666322.18,1666322.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','213233',4129771,'1714','237',1402573.04,1402573.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','213233',4129772,'1715','237',1584334.58,1588209.66,3875.08,639388.20,0.00,0.00,0.00,0.00,0.00),('5','97','615','213233',4129773,'1716','237',1513772.45,1517116.99,3344.54,551849.10,0.00,0.00,0.00,0.00,0.00),('5','97','616','213233',4129774,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213233',4129775,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213233',4129776,'1719','237',508070.13,508556.93,486.80,80322.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213233',4129777,'1720','237',911380.45,913233.35,1852.90,305728.50,0.00,0.00,0.00,0.00,0.00),('5','97','616','213233',4129778,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213233',4129779,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213233',4129780,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213233',4129781,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213233',4129782,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213233',4129783,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213233',4129784,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213233',4129785,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','213233',4129786,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','213233',4129787,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','213233',4129788,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','213371',4132180,'1713','237',1666322.18,1666322.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','213371',4132181,'1714','237',1402573.04,1402573.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','213371',4132182,'1715','237',1588209.66,1591616.58,3406.92,562141.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','213371',4132183,'1716','237',1517116.99,1520371.69,3254.70,537025.50,0.00,0.00,0.00,0.00,0.00),('5','97','616','213371',4132184,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213371',4132185,'1718','237',777410.01,777410.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213371',4132186,'1719','237',508556.93,509696.73,1139.80,188067.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213371',4132187,'1720','237',913233.35,914716.62,1483.27,244739.55,0.00,0.00,0.00,0.00,0.00),('5','97','616','213371',4132188,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213371',4132189,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213371',4132190,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213371',4132191,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213371',4132192,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213371',4132193,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213371',4132194,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213371',4132195,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','213371',4132196,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','213371',4132197,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','213371',4132198,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','213626',4136372,'1713','237',1666322.18,1668503.70,2181.52,359950.80,0.00,0.00,0.00,0.00,0.00),('5','97','614','213626',4136373,'1714','237',1402573.04,1405271.42,2698.38,445232.70,0.00,0.00,0.00,0.00,0.00),('5','97','615','213626',4136374,'1715','237',1591616.58,1593090.85,1474.27,243254.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','213626',4136375,'1716','237',1520371.69,1522507.07,2135.38,352337.70,0.00,0.00,0.00,0.00,0.00),('5','97','616','213626',4136376,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213626',4136377,'1718','237',777410.01,778537.35,1127.34,186011.10,0.00,0.00,0.00,0.00,0.00),('5','97','617','213626',4136378,'1719','237',509696.73,509696.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213626',4136379,'1720','237',914716.62,914716.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213626',4136380,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213626',4136381,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213626',4136382,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213626',4136383,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213626',4136384,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213626',4136385,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213626',4136386,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213626',4136387,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','213626',4136388,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','213626',4136389,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','213626',4136390,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','213866',4140394,'1713','237',1668503.70,1669986.48,1482.78,244658.70,0.00,0.00,0.00,0.00,0.00),('5','97','614','213866',4140395,'1714','237',1405271.42,1407582.42,2311.00,381315.00,0.00,0.00,0.00,0.00,0.00),('5','97','615','213866',4140396,'1715','237',1593090.85,1595659.32,2568.47,423797.55,0.00,0.00,0.00,0.00,0.00),('5','97','615','213866',4140397,'1716','237',1522507.07,1522507.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213866',4140398,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213866',4140399,'1718','237',778537.35,780116.49,1579.14,260558.10,0.00,0.00,0.00,0.00,0.00),('5','97','617','213866',4140400,'1719','237',509696.73,509696.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213866',4140401,'1720','237',914716.62,914716.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213866',4140402,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213866',4140403,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213866',4140404,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213866',4140405,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','213866',4140406,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213866',4140407,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213866',4140408,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','213866',4140409,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','213866',4140410,'1729','238',785830.29,785830.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','618','213866',4140411,'1730','238',395771.40,395771.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','619','213866',4140412,'1731','239',88667.56,88667.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','614','214128',4144579,'1713','237',1669986.48,1672814.56,2828.08,466633.20,0.00,0.00,0.00,0.00,0.00),('5','97','614','214128',4144580,'1714','237',1407582.42,1410281.54,2699.12,445354.80,0.00,0.00,0.00,0.00,0.00),('5','97','615','214128',4144581,'1715','237',1595659.32,1597295.47,1636.15,269964.75,0.00,0.00,0.00,0.00,0.00),('5','97','615','214128',4144582,'1716','237',1522507.07,1522507.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','214128',4144583,'1717','237',410698.91,410698.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','214128',4144584,'1718','237',780116.49,781845.43,1728.94,285275.10,0.00,0.00,0.00,0.00,0.00),('5','97','617','214128',4144585,'1719','237',509696.73,509696.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','214128',4144586,'1720','237',914716.62,915604.63,888.01,146521.65,0.00,0.00,0.00,0.00,0.00),('5','97','616','214128',4144587,'1721','237',76690.22,76690.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','214128',4144588,'1722','237',454627.28,454627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','214128',4144589,'1723','237',247545.47,247545.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','214128',4144590,'1724','237',323981.33,323981.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','616','214128',4144591,'1725','237',324999.90,324999.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','214128',4144592,'1726','237',574727.78,574727.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','214128',4144593,'1727','237',245354.39,245354.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','97','617','214128',4144594,'1728','237',199309.14,199309.14,0.00,0.00,0.00,0.00,0.0