-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_96
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_96`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_96` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_96`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3237 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1837,4000,'',0,'2','5','96','UBA 1019882661','','2019-03-13 12:13:55',5,0.00,0.00,'','390','2019-03-13 12:13:55','390',0,1),(1868,3000,'',0,'24','5','96','PURCHASES','','2019-03-15 14:22:06',5,0.00,0.00,'','390','2019-03-15 14:22:06','390',0,1),(1869,3001,'',0,'24','5','96','PRINTING & STATIONARY','','2019-03-15 14:22:31',5,0.00,0.00,'','390','2019-03-15 14:22:31','390',0,1),(1870,3003,'',0,'6.1','5','96','CASH','','2019-03-15 14:22:56',5,0.00,0.00,'','390','2019-03-15 14:22:56','390',0,1),(1871,3004,'',0,'24','5','96','DIESEL INTERNAL CONSUPTION(GEN','','2019-03-15 14:23:17',5,0.00,0.00,'','390','2019-03-15 14:23:17','390',0,1),(1872,3005,'',0,'24','5','96','CLEANING & SANITARY ITEMS','','2019-03-15 14:23:50',5,0.00,0.00,'','390','2019-03-15 14:23:50','390',0,1),(1873,3006,'',0,'24','5','96','OTHER OPERATING EXPENSES','','2019-03-15 14:24:52',5,0.00,0.00,'','390','2019-03-15 14:24:52','390',0,1),(1874,3007,'',0,'24','5','96','TRANSPORT FARE','','2019-03-15 14:25:06',5,0.00,0.00,'','390','2019-03-15 14:25:06','390',0,1),(1875,3009,'',0,'24','5','96','GENERATOR REPAIRS & MAINTAINAN','','2019-03-15 14:25:29',5,0.00,0.00,'','390','2019-03-15 14:25:29','390',0,1),(1876,3010,'',0,'24','5','96','PUMP  REPAIRS & MAINTAINANCE','','2019-03-15 14:25:50',5,0.00,0.00,'','390','2019-03-15 14:25:50','390',0,1),(1877,3011,'',0,'24','5','96','WEIGHT AND MEASURE','','2019-03-15 14:26:11',5,0.00,0.00,'','390','2019-03-15 14:26:11','390',0,1),(1878,3012,'',0,'24','5','96','DPR EXPENSES','','2019-03-15 14:26:57',5,0.00,0.00,'','390','2019-03-15 14:26:57','390',0,1),(1879,3013,'',0,'24','5','96','WATER & ELECTRICITY BILL','','2019-03-15 14:29:26',5,0.00,0.00,'','390','2019-03-15 14:29:26','390',0,1),(1880,4001,'',0,'20','5','96','SALES','','2019-03-15 14:29:55',5,0.00,0.00,'','390','2019-03-15 14:29:55','390',0,1),(1881,3002,'',0,'24','5','96','SALARIES AND WAGES','','2019-03-15 14:57:57',5,0.00,0.00,'','390','2019-03-15 14:57:57','390',0,1),(3233,4020,'',0,'2','5','96','UBA-1020261147','','2021-03-06 01:27:34',5,0.00,0.00,'','600','2021-03-06 01:27:34','600',0,1),(3234,4021,'',0,'2','5','96','UBA-1022244715','','2021-03-06 01:28:18',5,0.00,0.00,'','600','2021-03-06 01:28:18','600',0,1),(3235,4022,'',0,'2','5','96','JA\'IZ-0010037957','','2022-03-01 20:44:24',5,0.00,0.00,'','600','2022-03-01 20:44:24','600',0,0),(3236,2000,'',0,'6','5','96','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:33:27',5,0.00,0.00,'','600','2023-02-06 10:33:27','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','96','0000-00-00','2023-02-07 15:28:33',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'5','96','0000-00-00','2023-02-22 12:45:12',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','96','0000-00-00','2023-02-22 12:50:19',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','96','1','3236','6',0.00,'Pms price increase from 185 to 220 on 20/1/2023  660 ×35 = 23,100',23100.00,'2023-01-21'),(2,'5','96','1','97','supplier',23100.00,'Pms price increase from 185 to 220 on 20/1/2023  660ltrs ×35 = 23,100',0.00,'2023-01-20'),(3,'5','96','2','97','supplier',0.00,'Pms price decrease from 220 to 210 on 19/2/2023  660ltrs ×10 = 6,600',6600.00,'2023-02-19'),(4,'5','96','2','3236','6',6600.00,'Pms price decrease from 220 to 210 on 19/2/2023  6600ltrs ×10 = 6,600',0.00,'2023-02-19'),(5,'5','96','3','97','supplier',0.00,'Ago price decrease from 830 to 820 on 20/2/2023 Dipping 1,150 × 10 11,500',11500.00,'2023-02-20'),(6,'5','96','3','3236','6',11500.00,'Ago price decrease from 830 to 820 on 20/2/2023 Dipping 1,150 × 10 11,500',0.00,'2023-02-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18408 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','96',17681,'583',1792.65,2050.00,'2021-11-17','','2021-11-17 20:30:25','390','390',2021,'390','2021-11-17 20:30:25',5),('5','96',17719,'584',1194.55,600.00,'2021-11-21','','2021-11-21 20:29:11','390','390',2021,'390','2021-11-21 20:29:11',5),('5','96',17777,'586',499.45,950.00,'2021-11-26','','2021-11-26 08:59:10','390','390',2021,'390','2021-11-26 08:59:10',5),('5','96',17967,'583',71.71,200.00,'2021-12-10','','2021-12-10 10:45:05','390','390',2021,'390','2021-12-10 10:45:05',5),('5','96',17968,'584',621.76,300.00,'2021-12-10','','2021-12-10 10:45:32','390','390',2021,'390','2021-12-10 10:45:32',5),('5','96',18394,'583',2165.46,2416.00,'2022-01-09','','2022-01-09 19:46:49','390','390',2022,'390','2022-01-09 19:46:49',5),('5','96',18395,'584',636.60,400.00,'2022-02-07','','2022-02-07 23:28:56','390','390',2022,'390','2022-02-07 23:28:56',5),('5','96',18396,'583',291.27,200.00,'2022-02-09','','2022-02-09 19:16:47','390','390',2022,'390','2022-02-09 19:16:47',5),('5','96',18397,'584',11569.00,400.00,'2022-02-17','','2022-02-17 10:45:43','600','600',2022,'600','2022-02-17 10:45:43',5),('5','96',18398,'583',3186.97,30030.00,'2022-05-10','','2022-05-10 10:59:28','390','390',2022,'390','2022-05-10 10:59:28',5),('5','96',18399,'583',2316.69,2434.00,'2022-05-19','','2022-05-19 21:04:16','390','390',2022,'390','2022-05-19 21:04:16',5),('5','96',18400,'583',353.86,373.00,'2022-06-25','','2022-06-25 23:14:59','390','390',2022,'390','2022-06-25 23:14:59',5),('5','96',18401,'583',5233.33,5321.00,'2022-07-21','','2022-07-21 23:10:19','390','390',2022,'390','2022-07-21 23:10:19',5),('5','96',18402,'583',3894.27,4018.00,'2022-07-28','','2022-07-28 23:19:23','390','390',2022,'390','2022-07-28 23:19:23',5),('5','96',18403,'583',18086.98,2169.00,'2022-09-06','','2022-09-06 14:06:20','390','390',2022,'390','2022-09-06 14:06:20',5),('5','96',18404,'583',0.70,17975.00,'2022-09-06','','2022-09-06 15:29:32','600','600',2022,'600','2022-09-06 15:29:32',5),('5','96',18405,'584',37799.88,36875.00,'2022-09-06','','2022-09-06 15:29:57','600','600',2022,'600','2022-09-06 15:29:57',5),('5','96',18406,'586',2733.48,2950.00,'2022-11-02','','2022-11-02 23:02:44','390','390',2022,'390','2022-11-02 23:02:44',5),('5','96',18407,'586',2950.00,2950.00,'2022-11-02','','2022-11-02 23:11:49','390','390',2022,'390','2022-11-02 23:11:49',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1649 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','96','583',1640,'5','PUMP 1',3214831.05,'PMS PUMP 1','',NULL,NULL,'',5,'2022-03-31 18:03:13','600'),('5','96','584',1641,'5','PUMP 6',1623090.67,'PMS PUMP 6','',NULL,NULL,'',5,'2021-10-13 08:10:25','600'),('5','96','584',1642,'5','PUMP 3',4156272.63,'PMS PUMP 3','',NULL,NULL,'',5,'2021-10-10 07:57:33','600'),('5','96','585',1643,'5','PUMP 4',1230919.39,'PMS PUMP 4','',NULL,NULL,'',5,'2021-03-01 13:47:22','600'),('5','96','585',1644,'5','PUMP 5',957490.44,'PMS PUMP 5','',NULL,NULL,'',5,'2021-03-01 13:48:40','600'),('5','96','586',1645,'5','PUMP 2',3115338.98,'PMS PUMP 2','',NULL,NULL,'',5,'2021-10-10 08:03:52','600'),('5','96','587',1646,'5','PUMP 7',1404383.06,'AGO PUMP 7','',NULL,NULL,'',5,'2021-10-10 08:05:56','600'),('5','96','589',1648,'5','PUMP 8',0.00,'DPK PUMP 8',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258085 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','96',83353,'MORNING','2019-03-02','2019-03-02 00:00:00',NULL,'390',1644129.40,1644129.40,'390','2019-03-20 12:20:09','390','2019-03-20 12:21:06',10,0),('5','96',83355,'MORNING','2019-03-03','2019-03-03 00:00:00',NULL,'390',1500359.60,1500359.60,'390','2019-03-20 12:26:24','390','2019-03-20 12:27:09',10,0),('5','96',83358,'MORNING','2019-03-04','2019-03-04 00:00:00',NULL,'390',1713415.80,1713415.80,'390','2019-03-20 12:36:36','390','2019-03-20 12:37:18',10,0),('5','96',83363,'MORNING','2019-03-05','2019-03-05 00:00:00',NULL,'390',1697970.60,1697970.60,'390','2019-03-20 12:41:58','390','2019-03-20 12:42:41',10,0),('5','96',83366,'MORNING','2019-03-06','2019-03-06 00:00:00',NULL,'390',1749760.40,1749760.40,'390','2019-03-20 12:50:54','390','2019-03-20 12:51:53',10,0),('5','96',83374,'MORNING','2019-03-07','2019-03-07 00:00:00',NULL,'390',1895400.80,1895400.80,'390','2019-03-20 13:30:04','390','2019-03-20 13:30:53',10,0),('5','96',83435,'MORNING','2019-03-08','2019-03-08 00:00:00',NULL,'390',2436218.40,2436218.40,'390','2019-03-20 20:56:34','390','2019-03-21 21:14:27',10,0),('5','96',83566,'MORNING','2019-03-09','2019-03-09 00:00:00',NULL,'390',417717.40,417717.40,'390','2019-03-21 21:20:05','390','2019-03-21 21:20:31',10,0),('5','96',83916,'MORNING','2019-03-10','2019-03-10 00:00:00',NULL,'390',0.00,0.00,'390','2019-03-26 12:16:53','390','2019-03-26 12:17:40',10,0),('5','96',84227,'MORNING','2019-03-10','2019-03-10 00:00:00',NULL,'390',0.00,0.00,'390','2019-03-27 13:34:47','390','2019-03-27 13:36:17',10,0),('5','96',84235,'MORNING','2019-03-10','2019-03-10 00:00:00',NULL,'390',1775444.80,1775444.80,'390','2019-03-28 13:03:39','390','2019-03-28 13:04:18',10,0),('5','96',84358,'MORNING','2019-03-11','2019-03-11 00:00:00',NULL,'390',1554733.00,1554733.00,'390','2019-03-28 13:13:38','390','2019-03-28 13:14:15',10,0),('5','96',84362,'MORNING','2019-03-12','2019-03-12 00:00:00',NULL,'390',1529451.80,1529451.80,'390','2019-03-28 13:18:46','390','2019-03-28 13:19:12',10,0),('5','96',84962,'MORNING','2019-04-13','2019-04-13 00:00:00',NULL,'390',1656546.60,1656546.60,'390','2019-04-02 13:29:14','390','2019-04-02 13:30:09',10,0),('5','96',84964,'MORNING','2019-04-14','2019-04-14 00:00:00',NULL,'390',1711129.20,1711129.20,'390','2019-04-02 13:36:55','390','2019-04-02 13:37:19',10,0),('5','96',102981,'MORNING','2019-08-18','2019-08-18 00:00:00',NULL,'390',1364574.55,1364574.55,'390','2019-08-23 13:48:55','390','2019-08-23 13:49:43',10,0),('5','96',102984,'MORNING','2019-08-19','2019-08-19 00:00:00',NULL,'390',1038930.85,1038930.85,'390','2019-08-23 13:53:28','390','2019-08-23 13:54:24',10,0),('5','96',102985,'MORNING','2019-08-20','2019-08-20 00:00:00',NULL,'390',1381480.00,1381480.00,'390','2019-08-23 14:05:38','390','2019-08-23 14:06:25',10,0),('5','96',102991,'MORNING','2019-08-21','2019-08-21 00:00:00',NULL,'390',906651.80,906651.80,'390','2019-08-23 14:10:11','390','2019-08-23 14:10:34',10,0),('5','96',102993,'MORNING','2019-08-22','2019-08-22 00:00:00',NULL,'390',1385985.90,1385985.90,'390','2019-08-23 14:13:39','390','2019-08-24 09:37:09',10,0),('5','96',103064,'MORNING','2019-08-24','2019-08-24 00:00:00',NULL,'390',1757722.90,1757722.90,'390','2019-08-24 09:41:44','390','2019-08-24 12:09:36',10,0),('5','96',103304,'MORNING','2019-08-24','2019-08-24 00:00:00',NULL,'390',1181755.40,1181755.40,'390','2019-08-26 11:50:11','390','2019-08-26 11:50:45',10,0),('5','96',103307,'MORNING','2019-08-25','2019-08-25 00:00:00',NULL,'390',1392393.80,1392393.80,'390','2019-08-26 11:53:48','390','2019-08-28 21:36:09',10,0),('5','96',103709,'MORNING','2019-08-26','2019-08-26 00:00:00',NULL,'390',0.00,0.00,'390','2019-09-01 17:30:21','390','2019-09-01 17:31:08',10,0),('5','96',105595,'MORNING','2019-08-26','2019-08-26 00:00:00',NULL,'390',1322942.60,1322942.60,'390','2019-09-13 10:35:20','390','2019-09-13 10:36:21',10,0),('5','96',105606,'MORNING','2019-08-27','2019-08-27 00:00:00',NULL,'390',1086006.55,1086006.55,'390','2019-09-15 11:19:12','390','2019-09-15 11:19:43',10,0),('5','96',105854,'MORNING','2019-08-28','2019-08-28 00:00:00',NULL,'390',1528594.80,1528594.80,'390','2019-09-15 11:23:00','390','2019-09-15 11:23:28',10,0),('5','96',105855,'MORNING','2019-08-29','2019-08-29 00:00:00',NULL,'390',1131168.05,1131168.05,'390','2019-09-15 11:26:53','390','2019-09-15 11:27:28',10,0),('5','96',105857,'MORNING','2019-08-30','2019-08-30 00:00:00',NULL,'390',4482219.20,4482219.20,'390','2019-09-15 11:30:15','390','2019-09-15 11:30:36',10,0),('5','96',106350,'MORNING','2019-08-31','2019-08-31 00:00:00',NULL,'390',1301415.70,1301415.70,'390','2019-09-18 15:16:52','390','2019-09-18 15:20:45',10,0),('5','96',106450,'MORNING','2019-09-01','2019-09-01 00:00:00',NULL,'390',1253627.60,1253627.60,'390','2019-09-19 12:40:08','390','2019-09-19 12:40:31',10,0),('5','96',106451,'MORNING','2019-09-02','2019-09-02 00:00:00',NULL,'390',1454536.50,1454536.50,'390','2019-09-19 12:45:01','390','2019-09-19 12:47:29',10,0),('5','96',106453,'MORNING','2019-09-03','2019-09-03 00:00:00',NULL,'390',1292360.50,1292360.50,'390','2019-09-19 12:52:48','390','2019-09-19 12:53:57',10,0),('5','96',106454,'MORNING','2019-09-04','2019-09-04 00:00:00',NULL,'390',1305504.70,1305504.70,'390','2019-09-19 12:57:51','390','2019-09-19 12:58:11',10,0),('5','96',106458,'MORNING','2019-09-05','2019-09-05 00:00:00',NULL,'390',1450676.30,1450676.30,'390','2019-09-19 13:01:10','390','2019-09-19 13:01:39',10,0),('5','96',106459,'MORNING','2019-09-06','2019-09-06 00:00:00',NULL,'390',1890234.55,1890234.55,'390','2019-09-19 13:05:35','390','2019-09-19 13:05:57',10,0),('5','96',106460,'MORNING','2019-09-07','2019-09-07 00:00:00',NULL,'390',1337636.25,1337636.25,'390','2019-09-19 13:09:29','390','2019-09-19 13:09:56',10,0),('5','96',106461,'MORNING','2019-09-08','2019-09-08 00:00:00',NULL,'390',1167823.15,1167823.15,'390','2019-09-25 10:57:21','390','2019-09-25 10:57:49',10,0),('5','96',107437,'MORNING','2019-09-09','2019-09-09 00:00:00',NULL,'390',990349.95,990349.95,'390','2019-09-26 10:01:05','390','2019-09-26 10:01:32',10,0),('5','96',107441,'MORNING','2019-09-10','2019-09-10 00:00:00',NULL,'390',1728623.70,1728623.70,'390','2019-09-26 10:05:02','390','2019-09-26 10:05:26',10,0),('5','96',107442,'MORNING','2019-09-11','2019-09-11 00:00:00',NULL,'390',1375713.20,1375713.20,'390','2019-09-26 10:08:14','390','2019-09-26 10:08:37',10,0),('5','96',107443,'MORNING','2019-09-12','2019-09-12 00:00:00',NULL,'390',1523080.20,1523080.20,'390','2019-09-26 10:11:36','390','2019-09-26 10:12:06',10,0),('5','96',107444,'MORNING','2019-09-13','2019-09-13 00:00:00',NULL,'390',1831814.15,1831814.15,'390','2019-09-26 10:15:16','390','2019-09-26 10:15:52',10,0),('5','96',107445,'MORNING','2019-09-14','2019-09-14 00:00:00',NULL,'390',1310321.55,1310321.55,'390','2019-09-26 10:18:25','390','2019-09-26 10:18:59',10,0),('5','96',107446,'MORNING','2019-09-15','2019-09-15 00:00:00',NULL,'390',1284638.05,1284638.05,'390','2019-09-26 10:31:25','390','2019-09-26 10:31:47',10,0),('5','96',107448,'MORNING','2019-09-16','2019-09-16 00:00:00',NULL,'390',1292039.90,1292039.90,'390','2019-09-26 10:34:18','390','2019-09-26 10:34:46',10,0),('5','96',107450,'MORNING','2019-09-17','2019-09-17 00:00:00',NULL,'390',1436294.60,1436294.60,'390','2019-09-26 10:37:37','390','2019-09-26 10:38:02',10,0),('5','96',107451,'MORNING','2019-09-18','2019-09-18 00:00:00',NULL,'390',1395606.75,1395606.75,'390','2019-09-26 10:40:44','390','2019-09-26 10:41:26',10,0),('5','96',107452,'MORNING','2019-09-19','2019-09-19 00:00:00',NULL,'390',1555441.10,1555441.10,'390','2019-09-26 10:44:26','390','2019-09-26 10:44:47',10,0),('5','96',107453,'MORNING','2019-09-20','2019-09-20 00:00:00',NULL,'390',1933652.95,1933652.95,'390','2019-09-26 10:48:28','390','2019-09-26 10:48:59',10,0),('5','96',107854,'MORNING','2019-09-21','2019-09-21 00:00:00',NULL,'390',1478392.85,1478392.85,'390','2019-10-03 19:40:27','390','2019-10-03 19:41:02',10,0),('5','96',108433,'MORNING','2019-09-22','2019-09-22 00:00:00',NULL,'390',1674659.40,1688245.80,'390','2019-10-03 19:44:00','390','2019-10-03 19:44:22',10,0),('5','96',108434,'MORNING','2019-09-23','2019-09-23 00:00:00',NULL,'390',1657695.15,1665301.25,'390','2019-10-04 10:34:09','390','2019-10-04 10:34:55',10,0),('5','96',108473,'MORNING','2019-09-24','2019-09-24 00:00:00',NULL,'390',1217469.10,1226635.70,'390','2019-10-04 10:39:37','390','2019-10-04 10:40:04',10,0),('5','96',108475,'MORNING','2019-09-25','2019-09-25 00:00:00',NULL,'390',1134681.80,1142090.60,'390','2019-10-04 10:42:41','390','2019-10-04 10:43:06',10,0),('5','96',108478,'MORNING','2019-09-26','2019-09-26 00:00:00',NULL,'390',1423322.85,1431889.95,'390','2019-10-04 10:51:20','390','2019-10-04 10:51:49',10,0),('5','96',108481,'MORNING','2019-09-27','2019-09-27 00:00:00',NULL,'390',1898164.15,1905396.65,'390','2019-10-04 10:59:50','390','2019-10-04 11:00:09',10,0),('5','96',108483,'MORNING','2019-09-28','2019-09-28 00:00:00',NULL,'390',1980898.45,1986251.95,'390','2019-10-04 11:10:24','390','2019-10-04 11:10:45',10,0),('5','96',108487,'MORNING','2019-09-29','2019-09-29 00:00:00',NULL,'390',1786300.55,1791131.85,'390','2019-10-04 11:15:28','390','2019-10-04 11:15:50',10,0),('5','96',108489,'MORNING','2019-09-30','2019-09-30 00:00:00',NULL,'390',1562703.00,1571423.40,'390','2019-10-04 11:18:11','390','2019-10-04 11:18:41',10,0),('5','96',108490,'MORNING','2019-10-01','2019-10-01 00:00:00',NULL,'390',1707700.40,1714482.00,'390','2019-10-04 11:22:03','390','2019-10-04 11:22:22',10,0),('5','96',108491,'MORNING','2019-10-02','2019-10-02 00:00:00',NULL,'390',1164359.00,1164359.00,'390','2019-10-05 08:38:06','390','2019-10-05 08:40:48',10,0),('5','96',108608,'MORNING','2019-10-03','2019-10-03 00:00:00',NULL,'390',1913088.90,1928517.10,'390','2019-10-05 08:45:21','390','2019-10-05 08:45:54',10,0),('5','96',108611,'MORNING','2019-10-04','2019-10-04 00:00:00',NULL,'390',2338727.90,2345612.90,'390','2019-10-05 09:03:47','390','2019-10-05 09:04:11',10,0),('5','96',108723,'MORNING','2019-10-05','2019-10-05 00:00:00',NULL,'390',2143898.95,2154387.45,'390','2019-10-05 20:32:26','390','2019-10-05 20:32:48',10,0),('5','96',108821,'MORNING','2019-10-06','2019-10-06 00:00:00',NULL,'390',1606038.45,1616031.15,'390','2019-10-07 09:30:27','390','2019-10-07 09:30:49',10,0),('5','96',109105,'MORNING','2019-10-07','2019-10-07 00:00:00',NULL,'390',1859579.40,1867996.20,'390','2019-10-08 19:48:55','390','2019-10-08 19:49:18',10,0),('5','96',109106,'MORNING','2019-10-08','2019-10-08 00:00:00',NULL,'390',1468700.25,1473765.75,'390','2019-10-12 17:13:22','390','2019-10-12 17:13:50',10,0),('5','96',109610,'MORNING','2019-10-09','2019-10-09 00:00:00',NULL,'390',1786001.14,1758942.70,'390','2019-10-12 17:18:18','390','2019-10-12 17:18:39',10,0),('5','96',109611,'MORNING','2019-10-10','2019-10-10 00:00:00',NULL,'390',1951383.67,1933621.85,'390','2019-10-12 17:21:21','390','2019-10-12 17:21:44',10,0),('5','96',109612,'MORNING','2019-10-11','2019-10-11 00:00:00',NULL,'390',2385335.32,2350302.10,'390','2019-10-12 17:26:40','390','2019-10-12 17:27:04',10,0),('5','96',109629,'MORNING','2019-10-12','2019-10-12 00:00:00',NULL,'390',1750144.29,1730531.20,'390','2019-10-13 07:15:54','390','2019-10-13 07:17:21',10,0),('5','96',110134,'MORNING','2019-10-14','2019-10-14 00:00:00',NULL,'390',1824932.25,1804653.75,'390','2019-10-19 09:30:36','390','2019-10-19 09:30:58',10,0),('5','96',110396,'MORNING','2019-10-14','2019-10-14 00:00:00',NULL,'390',2286949.64,2263248.45,'390','2019-10-19 09:34:16','390','2019-10-19 09:34:39',10,0),('5','96',110398,'MORNING','2019-10-15','2019-10-15 00:00:00',NULL,'390',2320413.73,2291174.15,'390','2019-10-19 10:01:56','390','2019-10-19 10:02:18',10,0),('5','96',110407,'MORNING','2019-10-16','2019-10-16 00:00:00',NULL,'390',2289746.76,2259929.05,'390','2019-10-19 10:05:53','390','2019-10-19 10:06:24',10,0),('5','96',110408,'MORNING','2019-10-17','2019-10-17 00:00:00',NULL,'390',0.00,0.00,'390','2021-03-01 13:36:44','390','2021-03-01 13:38:01',10,0),('5','96',181802,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'390',0.00,0.00,'600','2021-03-01 13:41:13','600','2021-03-01 13:41:39',10,0),('5','96',181810,'DAILY SHIFT','2021-02-28','2021-02-28 00:00:00',NULL,'390',1075807.90,1229298.05,'390','2021-03-01 14:32:14','390','2021-03-01 14:44:05',10,0),('5','96',181816,'DAILY SHIFT','2021-03-01','2021-03-01 00:00:00',NULL,'390',138195.55,160692.50,'390','2021-03-01 19:18:12','390','2021-03-02 21:00:54',10,0),('5','96',182096,'Daily shift','2021-03-02','2021-03-02 00:00:00',NULL,'390',0.00,0.00,'600','2021-03-03 20:06:00','600','2021-03-03 20:07:30',10,0),('5','96',182296,'DAILY SHIFT','2021-03-02','2021-03-02 00:00:00',NULL,'390',332108.92,378557.72,'390','2021-03-06 10:31:41','606','2021-03-06 10:54:29',10,0),('5','96',182775,'Daily shift','2021-03-06','2021-03-06 00:00:00',NULL,'390',2035475.54,1785723.94,'390','2021-03-06 13:30:37','606','2021-03-07 06:19:16',10,0),('5','96',182834,'Daily shift','2021-03-04','2021-03-04 00:00:00',NULL,'390',2550701.68,2550701.68,'390','2021-03-09 08:28:11','606','2021-03-09 08:53:07',10,0),('5','96',183244,'DAILY SHIFT','2021-03-05','2021-03-05 00:00:00',NULL,'390',2562515.58,2562515.58,'390','2021-03-09 09:00:33','606','2021-03-09 10:36:44',10,0),('5','96',183280,'Daily shift','2021-03-06','2021-03-06 00:00:00',NULL,'390',0.00,0.00,'390','2021-03-09 10:54:27','606','2021-03-09 19:30:13',10,0),('5','96',183423,'Daily shift','2021-03-10','2021-03-10 00:00:00',NULL,'390',1933563.05,1933563.05,'390','2021-03-10 05:35:31','606','2021-03-10 06:37:45',10,0),('5','96',183471,'Daily shift','2021-03-10','2021-03-10 00:00:00',NULL,'390',0.00,0.00,'390','2021-03-10 19:56:40','606','2021-03-11 07:19:37',10,0),('5','96',183750,'Daily shift','2021-03-11','2021-03-11 00:00:00',NULL,'390',1604666.54,1604666.54,'390','2021-03-12 09:39:19','606','2021-03-12 14:03:16',10,0),('5','96',184020,'Daily shift','2021-03-08','2021-03-08 00:00:00',NULL,'390',1197841.36,1197841.36,'390','2021-03-12 14:41:08','606','2021-03-13 10:09:12',10,0),('5','96',184115,'Daily shift','2021-03-09','2021-03-09 00:00:00',NULL,'390',2339183.66,2339183.66,'390','2021-03-13 11:14:06','606','2021-03-13 18:44:52',10,0),('5','96',184251,'Daily shift','2021-03-10','2021-03-10 00:00:00',NULL,'390',2002502.27,2002502.27,'390','2021-03-13 20:45:42','606','2021-03-14 08:11:19',10,0),('5','96',184484,'Daily shift','2021-03-14','2021-03-14 00:00:00',NULL,'390',4499028.20,4499028.20,'390','2021-03-15 07:35:52','606','2021-03-15 14:41:42',10,0),('5','96',184639,'Daily shift','2021-03-15','2021-03-15 00:00:00',NULL,'390',1989113.45,1989113.45,'390','2021-03-16 12:26:47','606','2021-03-16 16:32:09',10,0),('5','96',184841,'Daily shift','2021-03-16','2021-03-16 00:00:00',NULL,'390',1680609.87,1680609.87,'390','2021-03-16 21:00:09','606','2021-03-17 07:04:12',10,0),('5','96',184909,'Daily shift','2021-03-17','2021-03-17 00:00:00',NULL,'390',1895095.05,1895095.05,'390','2021-03-18 05:16:22','606','2021-03-18 06:59:17',10,0),('5','96',185117,'Daily shift','2021-03-18','2021-03-18 00:00:00',NULL,'390',1987822.49,1987822.49,'390','2021-03-18 20:47:03','606','2021-03-19 07:07:29',10,0),('5','96',185273,'Daily shift','2021-03-19','2021-03-19 00:00:00',NULL,'390',2387951.63,2387951.63,'390','2021-03-19 21:26:27','606','2021-03-20 08:27:47',10,0),('5','96',185496,'Daily shift','2021-03-20','2021-03-20 00:00:00',NULL,'390',2250565.45,2250565.45,'390','2021-03-20 20:52:55','606','2021-03-21 05:38:03',10,0),('5','96',185683,'Daily shift','2021-03-21','2021-03-21 00:00:00',NULL,'390',2219791.05,2219791.05,'390','2021-03-21 20:54:04','606','2021-03-22 05:30:06',10,0),('5','96',185877,'Daily shift','2021-03-22','2021-03-22 00:00:00',NULL,'390',2427034.14,2427034.14,'390','2021-03-22 20:43:27','606','2021-03-22 21:00:12',10,0),('5','96',186081,'Daily shift','2021-03-23','2021-03-23 00:00:00',NULL,'390',2225073.88,2225073.88,'390','2021-03-23 20:43:37','606','2021-03-24 05:32:19',10,0),('5','96',186313,'Daily shift','2021-03-24','2021-03-24 00:00:00',NULL,'390',1790830.47,1790830.47,'390','2021-03-25 05:56:37','606','2021-03-25 06:45:47',10,0),('5','96',186550,'Daily shift','2021-03-25','2021-03-25 00:00:00',NULL,'390',1944166.20,1944166.20,'390','2021-03-25 21:01:53','606','2021-03-26 05:40:32',10,0),('5','96',186743,'Daily shift','2021-03-26','2021-03-26 00:00:00',NULL,'390',2529389.99,2529389.99,'390','2021-03-27 06:33:31','606','2021-03-27 07:08:01',10,0),('5','96',187020,'Daily shift','2021-03-27','2021-03-27 00:00:00',NULL,'390',2140119.91,2140119.91,'390','2021-03-28 08:07:35','606','2021-03-28 09:56:39',10,0),('5','96',187328,'Daily shift','2021-03-28','2021-03-28 00:00:00',NULL,'390',1865248.12,1865248.12,'390','2021-03-28 21:41:42','604','2021-03-29 01:23:59',10,0),('5','96',187337,'Daily shift','2021-03-29','2021-03-29 00:00:00',NULL,'390',2062706.32,2062706.32,'390','2021-03-29 20:47:33','604','2021-03-30 03:45:54',10,0),('5','96',187559,'Daily shift','2021-03-30','2021-03-30 00:00:00',NULL,'390',1928824.64,1928824.64,'390','2021-03-30 21:02:16','604','2021-03-31 01:57:05',10,0),('5','96',187783,'Daily shift','2021-03-31','2021-03-31 00:00:00',NULL,'390',2164582.95,2164582.95,'390','2021-03-31 20:51:19','606','2021-04-01 05:29:16',10,0),('5','96',188017,'Daily shift','2021-04-01','2021-04-01 00:00:00',NULL,'390',2117024.44,2117024.44,'390','2021-04-01 21:02:23','606','2021-04-02 05:21:00',10,0),('5','96',188224,'Daily shift','2021-04-02','2021-04-02 00:00:00',NULL,'390',2384388.45,2384388.45,'390','2021-04-02 20:11:20','606','2021-04-02 22:42:23',10,0),('5','96',188404,'Daily shift','2021-04-03','2021-04-03 00:00:00',NULL,'390',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',188547,'Daily shift','2021-04-03','2021-04-03 00:00:00',NULL,'390',2253863.04,2254488.18,'390','2021-04-03 20:52:39','606','2021-04-04 05:29:14',10,0),('5','96',188606,'Daily shift','2021-04-04','2021-04-04 00:00:00',NULL,'390',2219530.25,2219530.25,'390','2021-04-04 20:56:46','606','2021-04-04 21:16:38',10,0),('5','96',188794,'Daily shift','2021-04-05','2021-04-05 00:00:00',NULL,'390',2220798.95,2220798.95,'390','2021-04-05 21:34:43','606','2021-04-05 21:43:54',10,0),('5','96',188994,'Daily shift','2021-04-06','2021-04-06 00:00:00',NULL,'390',1922663.30,1922663.30,'390','2021-04-06 20:56:06','606','2021-04-07 03:05:09',10,0),('5','96',189211,'Daily shift','2021-04-07','2021-04-07 00:00:00',NULL,'390',1779989.24,1779989.24,'390','2021-04-07 21:43:35','606','2021-04-08 04:29:50',10,0),('5','96',189402,'Daily shift','2021-04-08','2021-04-08 00:00:00',NULL,'390',1170120.78,1170120.78,'390','2021-04-08 20:09:41','606','2021-04-08 21:00:07',10,0),('5','96',189610,'Daily shift','2021-04-09','2021-04-09 00:00:00',NULL,'390',810906.17,810906.17,'390','2021-04-09 19:48:34','606','2021-04-09 21:08:01',10,0),('5','96',189806,'Daily shift','2021-04-10','2021-04-10 00:00:00',NULL,'390',310768.15,310768.15,'390','2021-04-10 19:42:17','606','2021-04-11 05:35:31',10,0),('5','96',190050,'Daily shift','2021-04-11','2021-04-11 00:00:00',NULL,'390',203684.30,203684.30,'390','2021-04-11 21:07:17','606','2021-04-12 05:16:36',10,0),('5','96',190220,'Daily shift','2021-04-12','2021-04-12 00:00:00',NULL,'390',228750.65,228750.65,'390','2021-04-12 20:01:29','606','2021-04-13 02:02:27',10,0),('5','96',190424,'Daily shift','2021-04-13','2021-04-13 00:00:00',NULL,'390',945396.16,954827.60,'390','2021-04-13 22:01:32','606','2021-04-14 02:49:19',10,0),('5','96',190694,'Daily shift','2021-04-14','2021-04-14 00:00:00',NULL,'390',888791.15,888791.15,'390','2021-04-14 21:33:10','606','2021-04-15 06:52:39',10,0),('5','96',190902,'Daily shift','2021-04-15','2021-04-15 00:00:00',NULL,'390',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',191023,'Morning','2021-04-15','2021-04-15 00:00:00',NULL,'600',869776.40,869776.40,'390','2021-04-15 20:56:55','606','2021-04-16 05:10:20',10,0),('5','96',191070,'Daily shift','2021-04-16','2021-04-16 00:00:00',NULL,'390',348838.15,348838.15,'390','2021-04-17 04:39:21','606','2021-04-17 05:19:39',10,0),('5','96',191309,'Daily shift','2021-04-17','2021-04-17 00:00:00',NULL,'390',98224.90,98224.90,'390','2021-04-17 20:43:18','606','2021-04-18 04:46:37',10,0),('5','96',191502,'Daily shift','2021-04-18','2021-04-18 00:00:00',NULL,'390',100713.25,100713.25,'390','2021-04-18 20:16:16','606','2021-04-19 03:48:08',10,0),('5','96',191730,'Daily shift','2021-04-19','2021-04-19 00:00:00',NULL,'390',106166.95,106166.95,'390','2021-04-20 05:49:51','606','2021-04-20 06:56:01',10,0),('5','96',192116,'Daily shift','2021-04-20','2021-04-20 00:00:00',NULL,'390',73084.35,73084.35,'390','2021-04-20 21:19:05','606','2021-04-21 05:36:53',10,0),('5','96',192179,'Daily shift','2021-04-21','2021-04-21 00:00:00',NULL,'390',895877.75,895877.75,'390','2021-04-22 09:56:45','606','2021-04-22 10:09:34',10,0),('5','96',192421,'Daily shift','2021-04-22','2021-04-22 00:00:00',NULL,'390',1040747.85,1040747.85,'390','2021-04-22 20:29:50','606','2021-04-23 05:28:26',10,0),('5','96',192581,'Daily shift','2021-04-23','2021-04-23 00:00:00',NULL,'390',1236924.30,1236924.30,'390','2021-04-23 20:06:11','606','2021-04-24 07:23:44',10,0),('5','96',192938,'Daily shift','2021-04-24','2021-04-24 00:00:00',NULL,'390',1114890.60,1114890.60,'390','2021-04-24 19:40:08','606','2021-04-25 06:19:03',10,0),('5','96',192982,'Daily shift','2021-04-25','2021-04-25 00:00:00',NULL,'390',650268.15,650268.15,'390','2021-04-25 20:19:40','606','2021-04-26 04:59:36',10,0),('5','96',193260,'Daily shift','2021-04-26','2021-04-26 00:00:00',NULL,'390',203610.10,203610.10,'390','2021-04-26 22:04:52','606','2021-04-27 05:32:53',10,0),('5','96',193467,'Daily shift','2021-04-27','2021-04-27 00:00:00',NULL,'390',85666.55,85666.55,'390','2021-04-27 19:58:21','606','2021-04-28 05:37:10',10,0),('5','96',193630,'Daily shift','2021-04-28','2021-04-28 00:00:00',NULL,'390',134938.00,134938.00,'390','2021-04-29 07:23:27','606','2021-04-29 08:12:46',10,0),('5','96',193942,'Daily shift','2021-04-29','2021-04-29 00:00:00',NULL,'390',1245116.85,1245116.85,'390','2021-04-29 20:22:19','606','2021-04-29 23:31:06',10,0),('5','96',194071,'Daily shift','2021-04-30','2021-04-30 00:00:00',NULL,'390',1704992.15,1704992.15,'390','2021-05-01 07:57:30','606','2021-05-01 10:58:53',10,0),('5','96',194374,'Daily shift','2021-05-01','2021-05-01 00:00:00',NULL,'390',1500661.80,1500661.80,'390','2021-05-01 20:10:13','606','2021-05-01 21:09:32',10,0),('5','96',194488,'Daily shift','2021-05-02','2021-05-02 00:00:00',NULL,'390',1770806.95,1770806.95,'390','2021-05-03 04:26:27','606','2021-05-03 07:20:37',10,0),('5','96',194722,'Daily shift','2021-05-03','2021-05-03 00:00:00',NULL,'390',1205605.90,1205605.90,'390','2021-05-03 21:09:22','606','2021-05-04 05:33:49',10,0),('5','96',194877,'DAILY SHIFT','2021-05-04','2021-05-04 00:00:00',NULL,'390',1187631.25,1187631.25,'390','2021-05-05 02:04:44','606','2021-05-05 03:02:23',10,0),('5','96',195068,'Daily Shift','2021-05-05','2021-05-05 00:00:00',NULL,'390',1785925.85,1785925.85,'390','2021-05-05 20:46:34','606','2021-05-06 04:55:50',10,0),('5','96',195302,'Daily shift','2021-05-06','2021-05-06 00:00:00',NULL,'390',1588982.45,1588982.45,'390','2021-05-06 22:22:08','606','2021-05-07 05:45:37',10,0),('5','96',195514,'Daily shift','2021-05-07','2021-05-07 00:00:00',NULL,'390',940082.95,940082.95,'390','2021-05-07 20:09:12','606','2021-05-08 06:19:01',10,0),('5','96',195797,'Daily shift','2021-05-08','2021-05-08 00:00:00',NULL,'390',475479.85,475479.85,'390','2021-05-08 20:17:06','606','2021-05-09 05:27:58',10,0),('5','96',196019,'Daily shift','2021-05-09','2021-05-09 00:00:00',NULL,'390',98263.95,98263.95,'390','2021-05-09 21:01:47','606','2021-05-10 05:44:24',10,0),('5','96',196234,'Daily shift','2021-05-10','2021-05-10 00:00:00',NULL,'390',1128999.35,1128999.35,'390','2021-05-11 07:14:30','606','2021-05-11 07:19:16',10,0),('5','96',196476,'Daily shift','2021-05-11','2021-05-11 00:00:00',NULL,'390',1866117.85,1866117.85,'390','2021-05-11 20:44:35','606','2021-05-11 21:28:07',10,0),('5','96',196649,'Daily shift','2021-05-12','2021-05-12 00:00:00',NULL,'390',1831680.70,1831680.70,'390','2021-05-12 20:45:25','606','2021-05-12 21:45:59',10,0),('5','96',196857,'Daily shift','2021-05-13','2021-05-13 00:00:00',NULL,'390',1862595.65,1862595.65,'390','2021-05-13 20:05:37','606','2021-05-13 21:34:50',10,0),('5','96',197016,'Daily shift','2021-05-14','2021-05-14 00:00:00',NULL,'390',906218.20,906218.20,'390','2021-05-14 20:47:41','606','2021-05-16 17:21:27',10,0),('5','96',197598,'Daily shift','2021-05-15','2021-05-15 00:00:00',NULL,'390',2797507.25,2797507.25,'390','2021-05-18 07:52:19','606','2021-05-18 14:13:33',10,0),('5','96',198042,'Daily shift','2021-05-16','2021-05-16 00:00:00',NULL,'390',2950512.20,2950512.20,'390','2021-05-18 15:52:59','606','2021-05-18 17:24:57',10,0),('5','96',198109,'Daily shift','2021-05-17','2021-05-17 00:00:00',NULL,'390',2144325.90,1852877.07,'390','2021-05-19 05:55:44','606','2021-05-19 07:00:03',10,0),('5','96',198145,'Daily shift','2021-05-19','2021-05-19 00:00:00',NULL,'390',2414250.15,15923037.30,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',198234,'Daily shift','2021-05-18','2021-05-18 00:00:00',NULL,'390',2414250.15,2417757.30,'390','2021-05-19 13:13:03','606','2021-05-19 13:36:51',10,0),('5','96',198247,'Daily Shift','2021-05-19','2021-05-19 00:00:00',NULL,'390',2373228.30,2376255.90,'390','2021-05-20 04:39:14','606','2021-05-20 04:53:40',10,0),('5','96',198340,'Daily shift','2021-05-20','2021-05-20 00:00:00',NULL,'390',2419207.20,2421885.00,'390','2021-05-21 05:03:39','606','2021-05-21 05:11:06',10,0),('5','96',198557,'Daily shift','2021-05-21','2021-05-21 00:00:00',NULL,'390',2315419.20,2315419.20,'390','2021-05-21 21:21:09','606','2021-05-22 06:01:07',10,0),('5','96',198775,'Daily shift','2021-05-22','2021-05-22 00:00:00',NULL,'390',2436677.25,2436677.25,'390','2021-05-22 20:55:48','606','2021-05-23 05:21:50',10,0),('5','96',198988,'Daily shift','2021-05-23','2021-05-23 00:00:00',NULL,'390',2077704.75,2077704.75,'390','2021-05-23 21:21:43','606','2021-05-24 04:44:28',10,0),('5','96',199192,'Daily shift','2021-05-24','2021-05-24 00:00:00',NULL,'390',2328277.05,2328277.05,'390','2021-05-24 22:00:07','606','2021-05-25 05:06:24',10,0),('5','96',199456,'Daily shift','2021-05-25','2021-05-25 00:00:00',NULL,'390',2556743.40,2556743.40,'390','2021-05-25 21:01:53','606','2021-05-26 04:52:28',10,0),('5','96',199633,'Daily shift','2021-05-26','2021-05-26 00:00:00',NULL,'390',2487088.35,2487088.35,'390','2021-05-26 20:57:10','606','2021-05-27 05:14:33',10,0),('5','96',199873,'Daily shift','2021-05-27','2021-05-27 00:00:00',NULL,'390',2366380.05,2366380.05,'390','2021-05-27 20:58:21','606','2021-05-28 05:39:21',10,0),('5','96',200093,'Daily shift','2021-05-28','2021-05-28 00:00:00',NULL,'390',2345463.90,2345463.90,'390','2021-05-28 20:19:57','606','2021-05-29 06:32:58',10,0),('5','96',200302,'Daily shift','2021-05-29','2021-05-29 00:00:00',NULL,'390',2351556.15,2351556.15,'390','2021-05-29 21:15:08','606','2021-05-30 04:40:51',10,0),('5','96',200495,'Daily shift','2021-05-30','2021-05-30 00:00:00',NULL,'390',2620207.65,2620207.65,'390','2021-05-30 20:39:31','606','2021-05-31 05:21:11',10,0),('5','96',200693,'Daily shift','2021-05-31','2021-05-31 00:00:00',NULL,'390',2460497.85,2460497.85,'390','2021-06-01 03:51:34','606','2021-06-01 05:15:18',10,0),('5','96',200928,'Daily shift','2021-06-01','2021-06-01 00:00:00',NULL,'390',2422900.80,2422900.80,'390','2021-06-01 21:13:22','606','2021-06-02 05:28:43',10,0),('5','96',201102,'Daily shift','2021-06-02','2021-06-02 00:00:00',NULL,'390',1809651.00,1809651.00,'390','2021-06-02 20:27:50','606','2021-06-03 05:21:36',10,0),('5','96',201317,'Daily shift','2021-06-03','2021-06-03 00:00:00',NULL,'390',1713516.90,1713516.90,'390','2021-06-03 20:58:34','606','2021-06-04 05:08:06',10,0),('5','96',201494,'Daily shift','2021-06-04','2021-06-04 00:00:00',NULL,'390',2646738.45,2646738.45,'390','2021-06-04 20:29:22','606','2021-06-05 05:42:33',10,0),('5','96',201761,'Daily shift','2021-06-05','2021-06-05 00:00:00',NULL,'390',2688630.30,2694027.60,'390','2021-06-05 20:35:44','606','2021-06-06 05:22:40',10,0),('5','96',202039,'Daily shift','2021-06-06','2021-06-06 00:00:00',NULL,'390',2379720.15,2384003.05,'390','2021-06-06 20:38:35','606','2021-06-07 05:18:29',10,0),('5','96',202203,'Daily shift','2021-06-07','2021-06-07 00:00:00',NULL,'390',2519703.00,2525890.95,'390','2021-06-07 20:44:30','606','2021-06-08 05:26:35',10,0),('5','96',202424,'Daily shift','2021-06-08','2021-06-08 00:00:00',NULL,'390',1960754.95,1960754.95,'390','2021-06-08 20:49:23','606','2021-06-09 01:02:00',10,0),('5','96',202629,'Daily shift','2021-06-09','2021-06-09 00:00:00',NULL,'390',2098675.70,2098675.70,'390','2021-06-09 21:24:03','606','2021-06-10 05:50:12',10,0),('5','96',202853,'Daily shift','2021-06-10','2021-06-10 00:00:00',NULL,'390',2439379.80,2439379.80,'390','2021-06-10 20:47:23','606','2021-06-11 05:52:05',10,0),('5','96',203116,'Daily shift','2021-06-11','2021-06-11 00:00:00',NULL,'390',2641680.25,2641680.25,'390','2021-06-11 20:51:11','606','2021-06-12 04:46:37',10,0),('5','96',203327,'Daily shift','2021-06-12','2021-06-12 00:00:00',NULL,'390',1789537.20,1789537.20,'390','2021-06-13 04:42:16','606','2021-06-13 05:11:17',10,0),('5','96',203523,'Daily shift','2021-06-13','2021-06-13 00:00:00',NULL,'390',2019733.65,2019733.65,'390','2021-06-13 22:19:02','606','2021-06-14 06:20:40',10,0),('5','96',203818,'Daily shift','2021-06-14','2021-06-14 00:00:00',NULL,'390',2308609.60,2308609.60,'390','2021-06-14 20:47:55','606','2021-06-15 05:06:16',10,0),('5','96',203982,'Daily shift','2021-06-15','2021-06-15 00:00:00',NULL,'390',2000491.35,2000491.35,'390','2021-06-15 19:24:30','606','2021-06-16 05:49:51',10,0),('5','96',204197,'Daily shift','2021-06-16','2021-06-16 00:00:00',NULL,'390',1704858.10,1704858.10,'390','2021-06-16 20:36:16','606','2021-06-17 06:11:19',10,0),('5','96',204420,'Daily shift','2021-06-17','2021-06-17 00:00:00',NULL,'390',1995831.75,1995831.75,'390','2021-06-17 20:26:34','606','2021-06-18 05:47:51',10,0),('5','96',204610,'Daily shift','2021-06-18','2021-06-18 00:00:00',NULL,'390',2497361.35,2497361.35,'390','2021-06-18 21:19:30','606','2021-06-19 06:08:48',10,0),('5','96',204841,'Daily shift','2021-06-19','2021-06-19 00:00:00',NULL,'390',1756451.95,1756451.95,'390','2021-06-19 20:43:14','606','2021-06-19 21:58:26',10,0),('5','96',205038,'Daily shift','2021-06-20','2021-06-20 00:00:00',NULL,'390',1559345.70,1559345.70,'390','2021-06-20 20:43:12','606','2021-06-21 05:30:17',10,0),('5','96',205223,'Daily shift','2021-06-21','2021-06-21 00:00:00',NULL,'390',1931232.60,1931232.60,'390','2021-06-21 20:48:21','606','2021-06-22 05:15:49',10,0),('5','96',205498,'Daily shift','2021-06-22','2021-06-22 00:00:00',NULL,'390',1225038.10,1413505.50,'390','2021-06-22 20:48:32','606','2021-06-23 05:39:02',10,0),('5','96',205720,'Daily shift','2021-06-23','2021-06-23 00:00:00',NULL,'390',1766677.77,2038474.35,'390','2021-06-23 20:27:45','606','2021-06-24 05:45:52',10,0),('5','96',205982,'Daily shift','2021-06-24','2021-06-24 00:00:00',NULL,'390',1654838.90,1909429.50,'390','2021-06-24 20:44:54','606','2021-06-25 05:17:22',10,0),('5','96',206136,'Daily shift','2021-06-25','2021-06-25 00:00:00',NULL,'390',1870139.70,2157853.50,'390','2021-06-25 20:38:27','606','2021-06-26 06:59:50',10,0),('5','96',206374,'Daily shift','2021-06-26','2021-06-26 00:00:00',NULL,'390',1525207.97,1759855.35,'390','2021-06-26 21:34:51','606','2021-06-27 05:53:33',10,0),('5','96',206575,'Daily shift','2021-06-27','2021-06-27 00:00:00',NULL,'390',1893134.10,1893134.10,'390','2021-06-27 20:44:28','606','2021-06-28 05:38:37',10,0),('5','96',206788,'Daily shift','2021-06-28','2021-06-28 00:00:00',NULL,'390',1792924.65,1792924.65,'390','2021-06-28 20:53:31','606','2021-06-29 05:50:03',10,0),('5','96',207018,'Daily shift','2021-06-29','2021-06-29 00:00:00',NULL,'390',2029188.15,2029188.15,'390','2021-06-29 20:47:04','606','2021-06-30 05:36:22',10,0),('5','96',207241,'Daily shift','2021-06-30','2021-06-30 00:00:00',NULL,'390',1692335.70,1692335.70,'390','2021-07-01 00:17:57','606','2021-07-01 05:42:58',10,0),('5','96',207488,'Daily shift','2021-07-01','2021-07-01 00:00:00',NULL,'390',1574187.45,1574187.45,'390','2021-07-01 20:43:32','606','2021-07-02 05:38:27',10,0),('5','96',207699,'Daily shift','2021-07-02','2021-07-02 00:00:00',NULL,'390',2071616.25,2071616.25,'390','2021-07-02 21:08:04','606','2021-07-03 06:27:47',10,0),('5','96',207918,'Daily shift','2021-07-03','2021-07-03 00:00:00',NULL,'390',1842931.20,1842931.20,'390','2021-07-03 20:56:36','606','2021-07-04 05:43:37',10,0),('5','96',208119,'Daily shift','2021-07-04','2021-07-04 00:00:00',NULL,'390',1702725.75,1702725.75,'390','2021-07-04 20:46:53','606','2021-07-05 05:20:41',10,0),('5','96',208320,'Daily shift','2021-07-05','2021-07-05 00:00:00',NULL,'390',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',208445,'Daily shift','2021-07-05','2021-07-05 00:00:00',NULL,'390',1176194.25,1176194.25,'390','2021-07-05 20:33:14','606','2021-07-06 07:03:58',10,0),('5','96',208560,'Daily shift','2021-07-06','2021-07-06 00:00:00',NULL,'390',1459311.15,1459311.15,'390','2021-07-07 04:22:44','606','2021-07-07 05:59:03',10,0),('5','96',208754,'Daily shift','2021-07-07','2021-07-07 00:00:00',NULL,'390',1988740.05,1988740.05,'390','2021-07-07 21:44:35','606','2021-07-08 04:59:08',10,0),('5','96',208979,'Daily shift','2021-07-08','2021-07-08 00:00:00',NULL,'390',1901186.10,1901186.10,'390','2021-07-08 21:01:07','606','2021-07-09 06:18:52',10,0),('5','96',209227,'Daily shift','2021-07-09','2021-07-09 00:00:00',NULL,'390',2205284.40,2205284.40,'390','2021-07-09 21:02:35','606','2021-07-10 06:35:04',10,0),('5','96',209445,'Daily shift','2021-07-10','2021-07-10 00:00:00',NULL,'390',1916554.20,1916554.20,'390','2021-07-11 04:24:11','606','2021-07-11 05:46:43',10,0),('5','96',209650,'Daily shift','2021-07-11','2021-07-11 00:00:00',NULL,'390',1395588.15,1395588.15,'390','2021-07-11 20:36:48','606','2021-07-12 06:21:26',10,0),('5','96',209876,'Daily shift','2021-07-12','2021-07-12 00:00:00',NULL,'390',341460.90,341460.90,'390','2021-07-12 21:23:35','606','2021-07-13 04:28:36',10,0),('5','96',210110,'Daily shift','2021-07-13','2021-07-13 00:00:00',NULL,'390',1739062.05,1739062.05,'390','2021-07-13 20:47:10','606','2021-07-14 06:22:39',10,0),('5','96',210317,'Daily shift','2021-07-14','2021-07-14 00:00:00',NULL,'390',1939863.75,1939863.75,'390','2021-07-14 20:41:09','606','2021-07-15 06:13:06',10,0),('5','96',210612,'Daily shift','2021-07-15','2021-07-15 00:00:00',NULL,'390',1655370.75,1655370.75,'390','2021-07-15 20:51:10','606','2021-07-16 05:39:20',10,0),('5','96',210741,'Daily shift','2021-07-16','2021-07-16 00:00:00',NULL,'390',2011460.55,2011460.55,'390','2021-07-16 20:54:23','606','2021-07-17 06:06:38',10,0),('5','96',210948,'Daily shift','2021-07-17','2021-07-17 00:00:00',NULL,'390',1877249.55,1877249.55,'390','2021-07-18 11:35:40','606','2021-07-18 12:19:04',10,0),('5','96',211287,'Daily shift','2021-07-18','2021-07-18 00:00:00',NULL,'390',1943586.15,1943586.15,'390','2021-07-18 21:11:41','606','2021-07-19 06:35:14',10,0),('5','96',211401,'Daily shift','2021-07-19','2021-07-19 00:00:00',NULL,'390',2180671.35,2180671.35,'390','2021-07-19 21:03:18','606','2021-07-20 05:48:16',10,0),('5','96',211599,'Daily shift','2021-07-20','2021-07-20 00:00:00',NULL,'390',2030544.45,2030544.45,'390','2021-07-20 20:51:16','606','2021-07-21 06:24:18',10,0),('5','96',211784,'Daily shift','2021-07-21','2021-07-21 00:00:00',NULL,'390',1784001.45,1784001.45,'390','2021-07-21 21:14:24','606','2021-07-22 06:28:09',10,0),('5','96',211993,'Daily shift','2021-07-22','2021-07-22 00:00:00',NULL,'390',1684796.85,1684796.85,'390','2021-07-22 21:16:49','606','2021-07-23 04:37:47',10,0),('5','96',212229,'Daily shift','2021-07-23','2021-07-23 00:00:00',NULL,'390',1991424.60,1991424.60,'390','2021-07-23 21:29:11','606','2021-07-24 04:43:32',10,0),('5','96',212456,'Daily shift','2021-07-24','2021-07-24 00:00:00',NULL,'390',1717778.70,1717778.70,'390','2021-07-24 20:48:53','606','2021-07-24 20:49:38',10,0),('5','96',212655,'Daily shift','2021-07-25','2021-07-25 00:00:00',NULL,'390',2056932.90,2056932.90,'390','2021-07-25 21:43:50','606','2021-07-26 05:45:23',10,0),('5','96',212876,'Daily shift','2021-07-26','2021-07-26 00:00:00',NULL,'390',959570.70,959570.70,'390','2021-07-26 20:43:26','606','2021-07-27 05:57:35',10,0),('5','96',213155,'Daily shift','2021-07-27','2021-07-27 00:00:00',NULL,'390',1666039.65,1666039.65,'390','2021-07-28 05:52:41','606','2021-07-28 06:04:31',10,0),('5','96',213388,'Daily shipt','2021-07-28','2021-07-28 00:00:00',NULL,'390',1750704.45,1750704.45,'390','2021-07-29 08:02:43','606','2021-07-29 08:35:35',10,0),('5','96',213692,'Daily shipt','2021-07-29','2021-07-29 00:00:00',NULL,'390',1875662.25,1875662.25,'390','2021-07-29 21:06:00','606','2021-07-30 04:28:32',10,0),('5','96',213869,'Daily shipt','2021-07-30','2021-07-30 00:00:00',NULL,'390',1914212.85,1914212.85,'390','2021-07-30 21:53:11','606','2021-07-31 08:46:05',10,0),('5','96',214134,'Daily shipt','2021-07-31','2021-07-31 00:00:00',NULL,'390',1730477.10,1730477.10,'390','2021-07-31 21:15:41','606','2021-08-01 05:22:16',10,0),('5','96',214335,'Daily shift','2021-08-01','2021-08-01 00:00:00',NULL,'390',1854864.00,1854864.00,'390','2021-08-01 20:42:26','606','2021-08-02 05:37:24',10,0),('5','96',214520,'Daily shift','2021-08-02','2021-08-02 00:00:00',NULL,'390',1800572.40,1800572.40,'390','2021-08-03 03:49:07','606','2021-08-03 04:34:58',10,0),('5','96',214789,'Daily shift','2021-08-03','2021-08-03 00:00:00',NULL,'390',1719328.05,1719328.05,'390','2021-08-03 20:57:29','606','2021-08-04 05:56:19',10,0),('5','96',215011,'Daily shift','2021-08-04','2021-08-04 00:00:00',NULL,'390',1687984.65,1687984.65,'390','2021-08-05 04:46:16','606','2021-08-05 05:34:13',10,0),('5','96',215237,'Daily shift','2021-08-05','2021-08-05 00:00:00',NULL,'390',1703910.45,1703910.45,'390','2021-08-05 21:34:13','606','2021-08-06 01:19:40',10,0),('5','96',215454,'Daily shift','2021-08-06','2021-08-06 00:00:00',NULL,'390',2086476.15,2086476.15,'390','2021-08-06 20:56:45','606','2021-08-07 05:46:49',10,0),('5','96',215678,'Daily shift','2021-08-07','2021-08-07 00:00:00',NULL,'390',1551971.85,1551971.85,'390','2021-08-07 21:51:53','606','2021-08-08 03:42:31',10,0),('5','96',215919,'Daily shift','2021-08-08','2021-08-08 00:00:00',NULL,'390',1364276.10,1366008.90,'390','2021-08-09 07:18:18','606','2021-08-09 07:33:23',10,0),('5','96',216137,'Daily shift','2021-08-09','2021-08-09 00:00:00',NULL,'390',2078946.15,2078946.15,'390','2021-08-10 09:35:56','606','2021-08-10 09:39:08',10,0),('5','96',216400,'Daily shift','2021-08-10','2021-08-10 00:00:00',NULL,'390',1889242.00,1889242.00,'390','2021-08-10 21:26:27','606','2021-08-11 05:55:50',10,0),('5','96',216551,'Daily shift','2021-08-11','2021-08-11 00:00:00',NULL,'390',1600574.60,1600574.60,'390','2021-08-11 22:33:49','606','2021-08-12 05:43:06',10,0),('5','96',216787,'Daily shift','2021-08-12','2021-08-12 00:00:00',NULL,'390',1748120.90,1748120.90,'390','2021-08-12 20:56:20','606','2021-08-13 05:48:08',10,0),('5','96',217015,'Daily shift','2021-08-13','2021-08-13 00:00:00',NULL,'390',2029575.80,2029575.80,'390','2021-08-13 21:24:16','606','2021-08-14 05:54:47',10,0),('5','96',217290,'Daily shift','2021-08-14','2021-08-14 00:00:00',NULL,'390',1653762.75,1653762.75,'390','2021-08-14 20:55:48','606','2021-08-15 18:58:59',10,0),('5','96',217661,'Daily shift','2021-08-15','2021-08-15 00:00:00',NULL,'390',1446002.75,1446002.75,'390','2021-08-15 20:48:04','606','2021-08-16 06:15:47',10,0),('5','96',217965,'Daily shift','2021-08-16','2021-08-16 00:00:00',NULL,'390',1604871.05,1604871.05,'390','2021-08-16 22:10:37','606','2021-08-17 05:50:22',10,0),('5','96',217981,'Daily shift','2021-08-17','2021-08-17 00:00:00',NULL,'390',1453443.35,1453443.35,'390','2021-08-18 04:26:41','606','2021-08-18 06:05:36',10,0),('5','96',218245,'Daily shift','2021-08-18','2021-08-18 00:00:00',NULL,'390',1311586.15,1311586.15,'390','2021-08-18 20:51:42','606','2021-08-19 05:54:45',10,0),('5','96',218450,'Daily shift','2021-08-19','2021-08-19 00:00:00',NULL,'390',1112516.90,1112516.90,'390','2021-08-19 21:01:52','606','2021-08-20 05:54:24',10,0),('5','96',218885,'Daily shift','2021-08-20','2021-08-20 00:00:00',NULL,'390',907627.30,907627.30,'390','2021-08-20 20:59:46','606','2021-08-21 06:22:48',10,0),('5','96',218926,'Daily shift','2021-08-21','2021-08-21 00:00:00',NULL,'390',279607.85,279607.85,'390','2021-08-21 20:50:55','606','2021-08-22 06:07:52',10,0),('5','96',219150,'Daily shift','2021-08-22','2021-08-22 00:00:00',NULL,'390',663377.20,663377.20,'390','2021-08-22 21:27:58','606','2021-08-23 05:51:44',10,0),('5','96',219344,'Daily shift','2021-08-23','2021-08-23 00:00:00',NULL,'390',1398580.95,1398580.95,'390','2021-08-23 20:41:04','606','2021-08-24 05:46:57',10,0),('5','96',219592,'Daily shift','2021-08-24','2021-08-24 00:00:00',NULL,'390',1579760.45,1579760.45,'390','2021-08-24 20:58:52','606','2021-08-25 05:43:55',10,0),('5','96',219827,'Daily shift','2021-08-25','2021-08-25 00:00:00',NULL,'390',1483108.05,1483108.05,'390','2021-08-25 20:37:28','606','2021-08-26 05:12:31',10,0),('5','96',220027,'Daily shift','2021-08-26','2021-08-26 00:00:00',NULL,'390',1778570.90,1778570.90,'390','2021-08-26 20:45:17','606','2021-08-27 06:20:21',10,0),('5','96',220259,'Daily shift','2021-08-27','2021-08-27 00:00:00',NULL,'390',2117716.00,2117716.00,'390','2021-08-27 20:53:02','606','2021-08-28 05:27:09',10,0),('5','96',220475,'Daily shift','2021-08-28','2021-08-28 00:00:00',NULL,'390',1445159.80,1445159.80,'390','2021-08-28 20:44:52','606','2021-08-29 06:00:22',10,0),('5','96',220685,'Daily shift','2021-08-29','2021-08-29 00:00:00',NULL,'390',1606150.45,1606150.45,'390','2021-08-29 20:29:51','606','2021-08-30 05:43:13',10,0),('5','96',220918,'Daily shift','2021-08-30','2021-08-30 00:00:00',NULL,'390',1775755.00,1775755.00,'390','2021-08-30 21:27:35','606','2021-08-31 05:56:18',10,0),('5','96',221137,'Daily shift','2021-08-31','2021-08-31 00:00:00',NULL,'390',1755506.00,1755506.00,'390','2021-08-31 21:52:36','606','2021-09-01 06:00:56',10,0),('5','96',221409,'Daily shift','2021-09-01','2021-09-01 00:00:00',NULL,'390',1666542.35,1666542.35,'390','2021-09-01 20:27:45','606','2021-09-02 05:49:42',10,0),('5','96',221616,'Daily shift','2021-09-02','2021-09-02 00:00:00',NULL,'390',2068285.00,2068285.00,'390','2021-09-02 21:21:05','606','2021-09-03 05:53:15',10,0),('5','96',221842,'Daily shift','2021-09-03','2021-09-03 00:00:00',NULL,'390',1876945.95,1876945.95,'390','2021-09-04 06:37:45','606','2021-09-04 07:13:19',10,0),('5','96',222073,'Daily shift3','2021-09-04','2021-09-04 00:00:00',NULL,'390',1881498.30,1881498.30,'390','2021-09-04 21:40:00','606','2021-09-05 06:01:24',10,0),('5','96',222275,'Daily shift','2021-09-05','2021-09-05 00:00:00',NULL,'390',1616250.55,1616250.55,'390','2021-09-05 21:35:23','606','2021-09-06 06:07:06',10,0),('5','96',222507,'Daily shift','2021-09-06','2021-09-06 00:00:00',NULL,'390',1685559.25,1685559.25,'390','2021-09-06 20:23:23','606','2021-09-07 06:44:54',10,0),('5','96',222731,'Daily shift','2021-09-07','2021-09-07 00:00:00',NULL,'390',983300.40,983300.40,'390','2021-09-08 04:07:19','606','2021-09-08 06:10:05',10,0),('5','96',222938,'Daily shift','2021-09-08','2021-09-08 00:00:00',NULL,'390',1855425.40,1855425.40,'390','2021-09-08 21:17:05','606','2021-09-09 05:17:48',10,0),('5','96',223169,'Daily shift','2021-09-09','2021-09-09 00:00:00',NULL,'390',799172.15,799172.15,'390','2021-09-10 04:52:16','606','2021-09-10 05:58:42',10,0),('5','96',223616,'Daily shift','2021-09-10','2021-09-10 00:00:00',NULL,'390',237882.10,237882.10,'390','2021-09-10 20:47:50','606','2021-09-11 06:02:07',10,0),('5','96',223648,'Daily shift','2021-09-11','2021-09-11 00:00:00',NULL,'390',142007.10,142007.10,'390','2021-09-11 20:13:47','606','2021-09-12 06:06:10',10,0),('5','96',223918,'Daily shift','2021-09-12','2021-09-12 00:00:00',NULL,'390',839113.35,839113.35,'390','2021-09-12 21:06:46','606','2021-09-13 05:46:45',10,0),('5','96',224080,'Daily shift','2021-09-13','2021-09-13 00:00:00',NULL,'390',1492055.15,1492055.15,'390','2021-09-13 20:48:31','606','2021-09-14 06:35:24',10,0),('5','96',224322,'Daily shift','2021-09-14','2021-09-14 00:00:00',NULL,'390',1441001.55,1441001.55,'390','2021-09-14 20:59:19','606','2021-09-15 06:21:08',10,0),('5','96',224558,'Daily shift','2021-09-15','2021-09-15 00:00:00',NULL,'390',1369175.00,1369175.00,'390','2021-09-15 20:24:32','606','2021-09-16 06:09:56',10,0),('5','96',224817,'Daily shift','2021-09-16','2021-09-16 00:00:00',NULL,'390',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',224862,'Daily shift','2021-09-16','2021-09-16 00:00:00',NULL,'390',1661204.27,1661204.27,'390','2021-09-16 21:42:11','606','2021-09-17 05:53:31',10,0),('5','96',225029,'Daily shift','2021-09-17','2021-09-17 00:00:00',NULL,'390',1974201.85,1974201.85,'390','2021-09-17 20:33:20','606','2021-09-18 05:56:54',10,0),('5','96',225303,'Daily shift','2021-09-18','2021-09-18 00:00:00',NULL,'390',1451079.05,1451079.05,'390','2021-09-18 21:04:37','606','2021-09-19 06:02:29',10,0),('5','96',225496,'Daily shift','2021-09-19','2021-09-19 00:00:00',NULL,'390',1639647.86,1639647.86,'390','2021-09-20 06:28:11','606','2021-09-20 06:31:13',10,0),('5','96',225715,'Daily shift','2021-09-20','2021-09-20 00:00:00',NULL,'390',1765293.93,1765293.93,'390','2021-09-20 20:42:51','606','2021-09-21 05:38:54',10,0),('5','96',225970,'Daily shift','2021-09-21','2021-09-21 00:00:00',NULL,'390',1674786.27,1674786.27,'390','2021-09-21 20:31:46','606','2021-09-22 08:39:21',10,0),('5','96',226292,'Daily shift','2021-09-22','2021-09-22 00:00:00',NULL,'390',1473029.37,1473029.37,'390','2021-09-22 20:50:34','606','2021-09-23 05:42:13',10,0),('5','96',226503,'Daily shift','2021-09-23','2021-09-23 00:00:00',NULL,'390',1703214.71,1703214.71,'390','2021-09-23 20:58:57','606','2021-09-24 06:11:20',10,0),('5','96',226785,'Daily shift','2021-09-24','2021-09-24 00:00:00',NULL,'390',1947706.56,1947706.56,'390','2021-09-24 21:24:24','606','2021-09-25 05:53:51',10,0),('5','96',227073,'Daily shift','2021-09-25','2021-09-25 00:00:00',NULL,'390',189705.92,189705.92,'390','2021-09-25 18:28:44','606','2021-09-26 05:53:38',10,0),('5','96',227188,'Daily shift','2021-09-26','2021-09-26 00:00:00',NULL,'390',1740670.48,1740670.48,'390','2021-09-26 21:50:20','606','2021-09-27 05:43:42',10,0),('5','96',227369,'Daily shift','2021-09-27','2021-09-27 00:00:00',NULL,'390',2041804.83,2041804.83,'390','2021-09-27 21:02:14','606','2021-09-28 05:52:24',10,0),('5','96',227607,'Daily shift','2021-09-28','2021-09-28 00:00:00',NULL,'390',2373897.77,2373897.77,'390','2021-09-28 20:51:42','606','2021-09-29 05:57:59',10,0),('5','96',227901,'Daily shift','2021-09-29','2021-09-29 00:00:00',NULL,'390',2295251.90,2295251.90,'390','2021-09-29 20:56:21','606','2021-10-05 11:56:58',10,0),('5','96',230326,'Daily shift','2021-10-01','2021-10-01 00:00:00',NULL,'390',1474196.45,1474196.45,'390','2021-10-10 08:24:45','606','2021-10-11 14:15:41',10,0),('5','96',230697,'Daily shift','2021-10-11','2021-10-11 00:00:00',NULL,'390',1487746.64,1487746.64,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',230844,'Daily shift','2021-10-02','2021-10-02 00:00:00',NULL,'390',1487746.64,1487746.64,'390','2021-10-12 10:08:47','606','2021-10-12 10:15:00',10,0),('5','96',230853,'Daily shift','2021-10-12','2021-10-12 00:00:00',NULL,'390',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',230857,'Daily shift','2021-10-03','2021-10-03 00:00:00',NULL,'390',791135.17,791135.17,'390','2021-10-12 10:31:44','606','2021-10-12 10:37:27',10,0),('5','96',230871,'Daily shift','2021-10-04','2021-10-04 00:00:00',NULL,'390',174025.32,174025.32,'390','2021-10-12 10:45:21','606','2021-10-12 11:47:56',10,0),('5','96',230919,'Daily shift','2021-10-05','2021-10-05 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-12 12:14:47','606','2021-10-12 12:15:24',10,0),('5','96',230920,'Daily shift','2021-10-06','2021-10-06 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-12 12:16:40','606','2021-10-12 12:20:56',10,0),('5','96',230923,'Daily shift','2021-10-07','2021-10-07 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-12 12:23:20','606','2021-10-12 12:27:31',10,0),('5','96',230928,'Daily shift','2021-10-08','2021-10-08 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-12 12:29:01','606','2021-10-12 12:33:27',10,0),('5','96',231020,'Daily shift','2021-10-09','2021-10-09 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-12 16:58:31','606','2021-10-12 17:04:46',10,0),('5','96',231032,'Daily shift','2021-10-10','2021-10-10 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-12 19:41:29','606','2021-10-12 19:45:20',10,0),('5','96',231033,'Daily shift','2021-10-11','2021-10-11 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-12 19:49:16','606','2021-10-12 19:53:02',10,0),('5','96',231034,'Daily shift','2021-10-12','2021-10-12 00:00:00',NULL,'390',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',231166,'Daily shift','2021-10-12','2021-10-12 00:00:00',NULL,'390',1693936.75,1693936.75,'390','2021-10-13 11:04:41','606','2021-10-13 11:07:28',10,0),('5','96',231354,'Daily shift','2021-10-13','2021-10-13 00:00:00',NULL,'390',1734038.01,1734038.01,'390','2021-10-14 04:48:39','606','2021-10-14 07:21:44',10,0),('5','96',231456,'Daily shift','2021-10-14','2021-10-14 00:00:00',NULL,'390',1962806.88,1962806.88,'390','2021-10-14 22:17:05','606','2021-10-15 06:04:45',10,0),('5','96',231639,'Daily shift','2021-10-15','2021-10-15 00:00:00',NULL,'390',2489816.85,2489816.85,'390','2021-10-16 04:56:15','606','2021-10-16 06:22:22',10,0),('5','96',231914,'Daily shift','2021-10-16','2021-10-16 00:00:00',NULL,'390',1717447.87,1717447.87,'390','2021-10-17 04:59:35','606','2021-10-17 06:52:46',10,0),('5','96',232116,'Daily shift','2021-10-17','2021-10-17 00:00:00',NULL,'390',1827070.26,1827070.26,'390','2021-10-17 20:46:40','606','2021-10-18 06:15:20',10,0),('5','96',232343,'Daily shift','2021-10-18','2021-10-18 00:00:00',NULL,'390',1585036.45,1585036.45,'390','2021-10-18 21:55:19','606','2021-10-19 05:55:45',10,0),('5','96',232620,'Daily shift','2021-10-19','2021-10-19 00:00:00',NULL,'390',1347648.14,1347648.14,'390','2021-10-19 20:46:14','606','2021-10-20 05:53:53',10,0),('5','96',232844,'Daily shift','2021-10-20','2021-10-20 00:00:00',NULL,'390',943840.09,943840.09,'390','2021-10-20 21:41:37','606','2021-10-21 06:06:49',10,0),('5','96',233263,'Daily shift','2021-10-21','2021-10-21 00:00:00',NULL,'390',1019799.72,1019799.72,'390','2021-10-22 04:40:40','606','2021-10-22 06:01:43',10,0),('5','96',233384,'Daily shift','2021-10-22','2021-10-22 00:00:00',NULL,'390',408823.56,408823.56,'390','2021-10-22 20:26:04','606','2021-10-23 06:19:51',10,0),('5','96',233616,'Daily shift','2021-10-23','2021-10-23 00:00:00',NULL,'390',268030.68,268030.68,'390','2021-10-23 21:15:37','606','2021-10-24 06:17:50',10,0),('5','96',234007,'Daily shift','2021-10-24','2021-10-24 00:00:00',NULL,'390',924327.36,924327.36,'390','2021-10-25 09:58:28','606','2021-10-25 09:59:07',10,0),('5','96',234159,'Daily shift','2021-10-25','2021-10-25 00:00:00',NULL,'390',768227.15,768227.15,'390','2021-10-26 04:45:50','606','2021-10-26 05:42:43',10,0),('5','96',234316,'Daily shift','2021-10-26','2021-10-26 00:00:00',NULL,'390',258786.95,261962.25,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',234702,'Daily shift','2021-10-26','2021-10-26 00:00:00',NULL,'390',261962.25,261962.25,'390','2021-10-27 11:36:39','606','2021-10-28 07:23:01',10,0),('5','96',234908,'Daily shift','2021-10-28','2021-10-28 00:00:00',NULL,'390',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','96',234912,'Daily shift','2021-10-27','2021-10-27 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-28 09:18:46','606','2021-10-28 09:24:47',10,0),('5','96',234916,'Daily shift','2021-10-28','2021-10-28 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-28 15:19:07','606','2021-10-29 06:10:23',10,0),('5','96',235107,'Daily shift','2021-10-29','2021-10-29 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-29 18:35:51','606','2021-10-30 07:16:39',10,0),('5','96',235406,'Daily shift','2021-10-30','2021-10-30 00:00:00',NULL,'390',0.00,0.00,'390','2021-10-30 20:26:53','606','2021-10-31 06:14:41',10,0),('5','96',235650,'Daily shift','2021-10-31','2021-10-31 00:00:00',NULL,'390',1445388.45,1445388.45,'390','2021-11-01 04:57:52','606','2021-11-01 07:27:14',10,0),('5','96',235803,'Daily shift','2021-11-01','2021-11-01 00:00:00',NULL,'390',1751461.80,1751461.80,'390','2021-11-02 08:44:00','606','2021-11-02 09:06:18',10,0),('5','96',236101,'Daily shift','2021-11-02','2021-11-02 00:00:00',NULL,'390',1770413.70,1770413.70,'390','2021-11-03 10:20:32','606','2021-11-03 10:25:03',10,0),('5','96',236351,'Daily shift','2021-11-03','2021-11-03 00:00:00',NULL,'390',2742818.10,2742818.10,'390','2021-11-03 20:29:31','606','2021-11-04 06:18:46',10,0),('5','96',236529,'Daily shift','2021-11-04','2021-11-04 00:00:00',NULL,'390',2963985.75,2963985.75,'390','2021-11-04 20:27:49','606','2021-11-05 06:36:27',10,0),('5','96',236760,'Daily shift','2021-11-05','2021-11-05 00:00:00',NULL,'390',1678744.65,1678744.65,'390','2021-11-05 20:44:57','606','2021-11-06 07:07:28',10,0),('5','96',237014,'Daily shift','2021-11-06','2021-11-06 00:00:00',NULL,'390',1674858.90,1674858.90,'390','2021-11-06 21:21:37','606','2021-11-07 06:29:49',10,0),('5','96',237230,'Daily shift','2021-11-07','2021-11-07 00:00:00',NULL,'390',480555.90,480555.90,'390','2021-11-08 05:19:45','606','2021-11-08 06:34:02',10,0),('5','96',237402,'Daily shift','2021-11-08','2021-11-08 00:00:00',NULL,'390',261077.85,261077.85,'390','2021-11-08 19:42:32','606','2021-11-09 06:17:31',10,0),('5','96',237676,'Daily shift','2021-11-09','2021-11-09 00:00:00',NULL,'390',0.00,0.00,'390','2021-11-09 19:46:22','606','2021-11-10 05:53:48',10,0),('5','96',237908,'Daily shift','2021-11-10','2021-11-10 00:00:00',NULL,'390',870290.85,870290.85,'390','2021-11-10 21:13:42','606','2021-11-11 05:50:56',10,0),('5','96',238131,'Daily shift','2021-11-11','2021-11-11 00:00:00',NULL,'390',1547429.40,1547429.40,'390','2021-11-11 20:41:44','606','2021-11-12 07:30:18',10,0),('5','96',238434,'Daily shift','2021-11-12','2021-11-12 00:00:00',NULL,'390',1756132.95,1756132.95,'390','2021-11-12 21:13:55','606','2021-11-13 07:08:21',10,0),('5','96',238704,'Daily shift','2021-11-13','2021-11-13 00:00:00',NULL,'390',1638517.65,1638517.65,'390','2021-11-13 21:05:35','606','2021-11-14 05:56:18',10,0),('5','96',238839,'Daily shift','2021-11-14','2021-11-14 00:00:00',NULL,'390',1707540.45,1707540.45,'390','2021-11-14 21:47:27','606','2021-11-15 06:27:35',10,0),('5','96',239128,'Daily shift','2021-11-15','2021-11-15 00:00:00',NULL,'390',1774187.25,1774187.25,'390','2021-11-16 06:27:58','606','2021-11-16 07:19:10',10,0),('5','96',239347,'Daily shift','2021-11-16','2021-11-16 00:00:00',NULL,'390',1769956.65,1769956.65,'390','2021-11-17 03:53:57','606','2021-11-17 05:48:54',10,0),('5','96',239605,'Daily shift','2021-11-17','2021-11-17 00:00:00',NULL,'390',1815047.85,1815047.85,'390','2021-11-17 20:31:18','606','2021-11-18 06:09:05',10,0),('5','96',239789,'Daily shift','2021-11-18','2021-11-18 00:00:00',NULL,'390',1831714.50,1831714.50,'390','2021-11-18 21:01:53','606','2021-11-19 07:29:10',10,0),('5','96',240051,'Daily shift','2021-11-19','2021-11-19 00:00:00',NULL,'390',2235609.75,2235609.75,'390','2021-11-20 05:18:03','606','2021-11-20 07:10:42',10,0),('5','96',240411,'Daily shift','2021-11-20','2021-11-20 00:00:00',NULL,'390',1912658.55,1912658.55,'390','2021-11-20 20:59:27','606','2021-11-21 06:41:30',10,0),('5','96',240539,'Daily shift','2021-11-21','2021-11-21 00:00:00',NULL,'390',1761122.55,1761122.55,'390','2021-11-21 20:28:17','606','2021-11-22 06:23:25',10,0),('5','96',240707,'Daily shift','2021-11-22','2021-11-22 00:00:00',NULL,'390',1685887.50,1685887.50,'390','2021-11-23 04:02:48','606','2021-11-23 07:04:18',10,0),('5','96',241042,'Daily shift','2021-11-23','2021-11-23 00:00:00',NULL,'390',1546081.35,1546081.35,'390','2021-11-24 06:14:46','606','2021-11-24 06:23:53',10,0),('5','96',241310,'Daily shift','2021-11-24','2021-11-24 00:00:00',NULL,'390',1093766.85,1093766.85,'390','2021-11-24 21:10:49','606','2021-11-25 06:58:31',10,0),('5','96',241548,'Daily shift','2021-11-25','2021-11-25 00:00:00',NULL,'390',567362.40,567362.40,'390','2021-11-25 19:33:12','606','2021-11-26 06:12:44',10,0),('5','96',241814,'Daily shift','2021-11-26','2021-11-26 00:00:00',NULL,'390',125055.15,125055.15,'390','2021-11-26 18:49:15','606','2021-11-27 07:12:10',10,0),('5','96',242002,'Daily shift','2021-11-27','2021-11-27 00:00:00',NULL,'390',1928716.35,1928716.35,'390','2021-11-27 20:51:21','606','2021-11-28 06:50:36',10,0),('5','96',242224,'Daily shift','2021-11-28','2021-11-28 00:00:00',NULL,'390',2082039.30,2082039.30,'390','2021-11-28 20:37:53','606','2021-11-29 06:00:25',10,0),('5','96',242446,'Daily shift','2021-11-29','2021-11-29 00:00:00',NULL,'390',365879.25,365879.25,'390','2021-11-29 19:16:30','606','2021-11-30 06:04:21',10,0),('5','96',242696,'Daily shift','2021-11-30','2021-11-30 00:00:00',NULL,'390',0.00,0.00,'390','2021-11-30 17:31:09','606','2021-12-01 07:54:50',10,0),('5','96',242992,'Daily shift','2021-12-01','2021-12-01 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-01 19:22:26','606','2021-12-02 07:22:37',10,0),('5','96',243224,'Daily shift','2021-12-02','2021-12-02 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-02 18:40:43','606','2021-12-03 06:59:05',10,0),('5','96',243433,'Daily shift','2021-12-03','2021-12-03 00:00:00',NULL,'390',738804.00,738804.00,'390','2021-12-05 05:58:29','606','2021-12-05 06:07:23',10,0),('5','96',243840,'Daily shift','2021-12-04','2021-12-04 00:00:00',NULL,'390',2152526.40,2152526.40,'390','2021-12-05 06:31:57','606','2021-12-05 06:35:40',10,0),('5','96',243874,'Daily shift','2021-12-05','2021-12-05 00:00:00',NULL,'390',1841596.40,1841596.40,'390','2021-12-05 20:37:21','606','2021-12-06 06:31:28',10,0),('5','96',244127,'Daily shift','2021-12-06','2021-12-06 00:00:00',NULL,'390',2043933.80,2043933.80,'390','2021-12-07 04:53:33','606','2021-12-07 06:53:47',10,0),('5','96',244343,'Daily shift','2021-12-07','2021-12-07 00:00:00',NULL,'390',2174497.20,2174497.20,'390','2021-12-07 20:38:56','606','2021-12-08 07:19:46',10,0),('5','96',244557,'Daily shift','2021-12-08','2021-12-08 00:00:00',NULL,'390',1530783.70,1530783.70,'390','2021-12-09 06:21:51','606','2021-12-09 06:49:18',10,0),('5','96',244786,'Daily shift','2021-12-09','2021-12-09 00:00:00',NULL,'390',1423685.40,1423685.40,'390','2021-12-09 21:05:27','606','2021-12-10 06:18:20',10,0),('5','96',245000,'Daily shift','2021-12-10','2021-12-10 00:00:00',NULL,'390',605019.80,605019.80,'390','2021-12-10 19:46:18','606','2021-12-11 07:02:06',10,0),('5','96',245276,'Daily shift','2021-12-11','2021-12-11 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-11 19:19:35','606','2021-12-12 07:01:21',10,0),('5','96',245468,'Daily shift','2021-12-12','2021-12-12 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-12 17:55:35','606','2021-12-13 06:02:44',10,0),('5','96',245687,'Daily shift','2021-12-13','2021-12-13 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-13 20:43:09','606','2021-12-14 06:09:56',10,0),('5','96',246000,'Daily shift','2021-12-14','2021-12-14 00:00:00',NULL,'390',1092637.60,1092637.60,'390','2021-12-14 20:36:46','606','2021-12-15 06:41:21',10,0),('5','96',246213,'Daily shift','2021-12-15','2021-12-15 00:00:00',NULL,'390',1044901.60,1044901.60,'390','2021-12-15 21:49:02','606','2021-12-16 06:53:07',10,0),('5','96',246480,'Daily shift','2021-12-16','2021-12-16 00:00:00',NULL,'390',1084576.20,1084576.20,'390','2021-12-17 04:57:30','606','2021-12-17 06:17:11',10,0),('5','96',246717,'Daily shift','2021-12-17','2021-12-17 00:00:00',NULL,'390',999450.40,999450.40,'390','2021-12-18 05:08:51','606','2021-12-18 07:05:09',10,0),('5','96',246967,'Daily shift','2021-12-18','2021-12-18 00:00:00',NULL,'390',582624.00,582624.00,'390','2021-12-19 04:46:04','606','2021-12-19 07:14:39',10,0),('5','96',247201,'Daily shift','2021-12-19','2021-12-19 00:00:00',NULL,'390',290688.10,290688.10,'390','2021-12-19 18:54:41','606','2021-12-20 06:58:18',10,0),('5','96',247496,'Daily shift','2021-12-20','2021-12-20 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-20 19:24:15','600','2021-12-21 09:19:22',10,0),('5','96',247738,'Daily shift','2021-12-21','2021-12-21 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-21 18:58:19','600','2021-12-22 06:39:59',10,0),('5','96',247969,'Daily shift','2021-12-22','2021-12-22 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-22 19:13:50','606','2021-12-23 06:35:23',10,0),('5','96',248177,'Daily shift','2021-12-23','2021-12-23 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-23 20:34:46','606','2021-12-24 07:23:01',10,0),('5','96',248578,'Daily shift','2021-12-24','2021-12-24 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-24 18:39:23','606','2021-12-25 14:11:04',10,0),('5','96',248817,'Daily shift','2021-12-25','2021-12-25 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-25 17:53:49','606','2021-12-26 07:33:55',10,0),('5','96',248920,'Daily shift','2021-12-26','2021-12-26 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-26 19:04:24','606','2021-12-27 07:44:25',10,0),('5','96',249181,'Daily shift','2021-12-27','2021-12-27 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-27 18:13:21','606','2021-12-28 07:38:29',10,0),('5','96',249441,'Daily shipt ','2021-12-28','2021-12-28 00:00:00',NULL,'390',0.00,0.00,'390','2021-12-29 03:29:37','606','2021-12-29 06:48:10',10,0),('5','96',249660,'Daily shipt','2021-12-29','2021-12-29 00:00:00',NULL,'390',606646.70,606646.70,'390','2021-12-29 21:22:35','606','2021-12-30 07:00:24',10,0),('5','96',249915,'Daily shift','2021-12-30','2021-12-30 00:00:00',NULL,'390',1052347.60,1052347.60,'390','2021-12-30 21:46:12','606','2021-12-31 06:49:08',10,0),('5','96',250163,'Daily shift','2021-12-31','2021-12-31 00:00:00',NULL,'390',992448.10,992448.10,'390','2022-01-01 05:08:42','606','2022-01-01 07:51:30',10,0),('5','96',250399,'Daily shift','2022-01-01','2022-01-01 00:00:00',NULL,'390',1092219.40,1092219.40,'390','2022-01-02 04:20:42','606','2022-01-02 06:48:50',10,0),('5','96',250588,'Daily shift','2022-01-02','2022-01-02 00:00:00',NULL,'390',1405884.70,1405884.70,'390','2022-01-02 21:01:55','606','2022-01-03 14:07:17',10,0),('5','96',250928,'Daily shift','2022-01-03','2022-01-03 00:00:00',NULL,'390',2009544.50,2009544.50,'390','2022-01-03 20:57:25','606','2022-01-04 07:07:47',10,0),('5','96',251069,'Daily shift','2022-01-04','2022-01-04 00:00:00',NULL,'390',1587024.80,1540347.60,'390','2022-01-05 05:23:18','606','2022-01-05 07:38:08',10,0),('5','96',251346,'Daily shift','2022-01-05','2022-01-05 00:00:00',NULL,'390',1719735.30,1669154.85,'390','2022-01-05 22:44:28','606','2022-01-06 07:52:06',10,0),('5','96',251594,'Daily shift','2022-01-06','2022-01-06 00:00:00',NULL,'390',1899095.50,1843239.75,'390','2022-01-06 23:03:41','606','2022-01-07 09:13:33',10,0),('5','96',251817,'Daily shift','2022-01-07','2022-01-07 00:00:00',NULL,'390',1477225.20,1433777.40,'390','2022-01-08 06:31:26','606','2022-01-08 08:00:31',10,0),('5','96',252095,'Daily shift','2022-01-08','2022-01-08 00:00:00',NULL,'390',1014310.10,984477.45,'390','2022-01-09 06:05:50','606','2022-01-09 08:05:28',10,0),('5','96',252388,'Daily shift','2022-01-09','2022-01-09 00:00:00',NULL,'390',376779.50,365697.75,'390','2022-01-09 19:47:42','606','2022-01-10 07:04:18',10,0),('5','96',252486,'Daily shift','2022-01-10','2022-01-10 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-10 21:34:42','606','2022-01-11 05:39:00',10,0),('5','96',252761,'Daily shift','2022-01-11','2022-01-11 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-12 06:18:32','606','2022-01-12 07:51:37',10,0),('5','96',252999,'Daily shift','2022-01-12','2022-01-12 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-12 18:51:22','606','2022-01-13 07:43:34',10,0),('5','96',253248,'Daily shift','2022-01-13','2022-01-13 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-13 19:28:50','606','2022-01-14 09:44:16',10,0),('5','96',253553,'Daily shift','2022-01-14','2022-01-14 00:00:00',NULL,'390',180625.00,175312.50,'390','2022-01-15 11:45:02','606','2022-01-15 11:47:53',10,0),('5','96',253807,'Daily shift','2022-01-15','2022-01-15 00:00:00',NULL,'390',1678295.85,1678295.85,'390','2022-01-15 21:46:07','606','2022-01-16 07:24:41',10,0),('5','96',253992,'Daily shift','2022-01-16','2022-01-16 00:00:00',NULL,'390',1698909.30,1698909.30,'390','2022-01-16 21:31:21','606','2022-01-17 07:16:08',10,0),('5','96',254218,'Daily shift','2022-01-17','2022-01-17 00:00:00',NULL,'390',2022386.85,2022386.85,'390','2022-01-17 21:40:50','606','2022-01-18 08:50:17',10,0),('5','96',254533,'Daily shift','2022-01-18','2022-01-18 00:00:00',NULL,'390',740249.40,740249.40,'390','2022-01-19 06:14:08','606','2022-01-19 10:07:56',10,0),('5','96',254791,'Daily shift','2022-01-19','2022-01-19 00:00:00',NULL,'390',165820.05,165820.05,'390','2022-01-19 19:13:25','606','2022-01-20 08:10:00',10,0),('5','96',254988,'Daily shift','2022-01-20','2022-01-20 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-20 19:09:51','606','2022-01-21 08:38:10',10,0),('5','96',255251,'Daily shift','2022-01-21','2022-01-21 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-22 08:02:37','606','2022-01-22 08:09:39',10,0),('5','96',255503,'Daily shift','2022-01-22','2022-01-22 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-22 17:31:21','606','2022-01-23 07:25:32',10,0),('5','96',255810,'Daily shift','2022-01-23','2022-01-23 00:00:00',NULL,'390',633992.70,633992.70,'390','2022-01-23 22:24:08','606','2022-01-24 08:34:54',10,0),('5','96',256046,'Daily shift','2022-01-24','2022-01-24 00:00:00',NULL,'390',1190550.90,1190550.90,'390','2022-01-25 06:01:35','606','2022-01-25 07:36:09',10,0),('5','96',256292,'Daily shift','2022-01-25','2022-01-25 00:00:00',NULL,'390',948659.25,948659.25,'390','2022-01-26 06:15:09','606','2022-01-26 08:10:35',10,0),('5','96',256552,'Daily shift','2022-01-26','2022-01-26 00:00:00',NULL,'390',1181268.00,1181268.00,'390','2022-01-26 21:55:35','606','2022-01-27 07:59:06',10,0),('5','96',256794,'Daily shift','2022-01-27','2022-01-27 00:00:00',NULL,'390',637845.45,637845.45,'390','2022-01-28 06:14:44','606','2022-01-28 07:25:08',10,0),('5','96',257061,'Daily shift','2022-01-28','2022-01-28 00:00:00',NULL,'390',204040.65,204040.65,'390','2022-01-29 06:10:09','606','2022-01-29 07:53:24',10,0),('5','96',257428,'Daily shift','2022-01-29','2022-01-29 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-29 19:43:34','606','2022-01-30 07:46:48',10,0),('5','96',257669,'Daily shift','2022-01-30','2022-01-30 00:00:00',NULL,'390',0.00,0.00,'390','2022-01-30 19:24:37','606','2022-01-31 09:32:15',10,0),('5','96',257670,'Daily shift','2022-01-31','2022-01-31 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-01 12:44:30','606','2022-02-01 12:57:09',10,0),('5','96',257671,'Daily shift','2022-02-01','2022-02-01 00:00:00',NULL,'390',141758.10,141758.10,'390','2022-02-02 11:06:46','606','2022-02-02 11:34:20',10,0),('5','96',257672,'Daily shift','2022-02-02','2022-02-02 00:00:00',NULL,'390',911504.55,911504.55,'390','2022-02-03 02:18:17','606','2022-02-03 06:43:26',10,0),('5','96',257673,'Daily shift','2022-02-03','2022-02-03 00:00:00',NULL,'390',1218102.60,1218102.60,'390','2022-02-04 09:44:43','606','2022-02-04 09:50:48',10,0),('5','96',257674,'Daily shift','2022-02-04','2022-02-04 00:00:00',NULL,'390',1725893.40,1725893.40,'390','2022-02-04 21:56:28','606','2022-02-05 07:53:22',10,0),('5','96',257675,'Daily shift','2022-02-05','2022-02-05 00:00:00',NULL,'390',1339435.35,1339435.35,'390','2022-02-06 06:33:28','606','2022-02-06 07:49:12',10,0),('5','96',257676,'Daily shift','2022-02-06','2022-02-06 00:00:00',NULL,'390',780227.25,780227.25,'390','2022-02-07 06:07:37','606','2022-02-07 07:18:21',10,0),('5','96',257677,'Daily shift','2022-02-07','2022-02-07 00:00:00',NULL,'390',742434.00,742434.00,'390','2022-02-07 23:27:21','606','2022-02-08 07:44:15',10,0),('5','96',257678,'Daily shift','2022-02-08','2022-02-08 00:00:00',NULL,'390',342551.55,342551.55,'390','2022-02-08 19:30:05','606','2022-02-09 08:20:35',10,0),('5','96',257679,'Daily shift','2022-02-09','2022-02-09 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-09 19:17:19','606','2022-02-09 21:22:20',10,0),('5','96',257680,'Daily shift','2022-02-10','2022-02-10 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-10 21:15:12','606','2022-02-11 08:13:44',10,0),('5','96',257681,'Daily shift','2022-02-11','2022-02-11 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-11 20:42:38','606','2022-02-12 08:14:33',10,0),('5','96',257682,'Daily shift','2022-02-12','2022-02-12 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-12 19:32:51','606','2022-02-13 07:31:43',10,0),('5','96',257683,'Daily shift','2022-02-13','2022-02-13 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-13 19:12:46','606','2022-02-14 07:22:31',10,0),('5','96',257684,'Daily shift','2022-02-14','2022-02-14 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-14 19:14:56','606','2022-02-15 08:12:08',10,0),('5','96',257685,'Daily shift','2022-02-15','2022-02-15 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-15 20:39:32','606','2022-02-16 07:34:04',10,0),('5','96',257686,'Daily shift','2022-02-16','2022-02-16 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-16 21:08:39','606','2022-02-17 07:11:05',10,0),('5','96',257687,'Daily shift','2022-02-17','2022-02-17 00:00:00',NULL,'390',261077.85,261077.85,'390','2022-02-18 08:12:43','606','2022-02-18 08:18:29',10,0),('5','96',257688,'Daily shift','2022-02-18','2022-02-18 00:00:00',NULL,'390',1992104.40,1992104.40,'390','2022-02-18 23:37:29','606','2022-02-19 07:34:15',10,0),('5','96',257689,'Daily shift','2022-02-19','2022-02-19 00:00:00',NULL,'390',311574.45,311574.45,'390','2022-02-19 20:54:02','606','2022-02-20 07:24:15',10,0),('5','96',257690,'Daily shift','2022-02-20','2022-02-20 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-20 20:17:22','606','2022-02-21 07:27:09',10,0),('5','96',257691,'Daily shift','2022-02-21','2022-02-21 00:00:00',NULL,'390',0.00,0.00,'390','2022-02-21 21:07:57','606','2022-02-22 06:46:28',10,0),('5','96',257692,'Daily shift','2022-02-22','2022-02-22 08:21:55','2022-02-23 08:21:55','390',191622.75,191622.75,'390','2022-02-23 11:40:16','606','2022-02-23 12:36:27',10,0),('5','96',257693,'Daily shift','2022-02-23','2022-02-23 13:14:37','2022-02-24 13:14:37','390',1525905.15,1525905.15,'390','2022-02-23 21:07:28','606','2022-02-24 09:39:52',10,0),('5','96',257694,'Daily shift','2022-02-24','2022-02-24 09:41:23','2022-02-25 09:41:23','390',1838578.50,1838578.50,'390','2022-02-24 21:46:17','606','2022-02-25 08:13:45',10,0),('5','96',257695,'Daily shift','2022-02-24','2022-02-25 14:46:46','2022-02-26 14:46:46','390',646956.75,646956.75,'390','2022-02-25 14:48:46','606','2022-02-25 15:04:07',10,0),('5','96',257696,'Daily shift','2022-02-25','2022-02-25 20:09:16','2022-02-26 20:09:16','390',899566.80,899566.80,'390','2022-02-25 22:01:59','606','2022-02-26 07:22:21',10,0),('5','96',257697,'Daily shift','2022-02-26','2022-02-26 09:32:17','2022-02-27 09:32:17','390',799476.15,799476.15,'390','2022-02-27 10:19:58','606','2022-02-28 07:19:44',10,0),('5','96',257698,'Daily ','2022-02-28','2022-02-28 09:31:50','2022-03-01 09:31:50','390',1773745.05,1773745.05,'390','2022-02-28 09:39:28','606','2022-02-28 14:12:46',10,0),('5','96',257699,'Daily ','2022-02-28','2022-02-28 18:31:22','2022-03-01 18:31:22','390',2101143.00,2101143.00,'390','2022-03-01 09:04:50','606','2022-03-01 09:18:29',10,0),('5','96',257700,'Daily','2022-03-01','2022-03-02 06:03:23','2022-03-03 06:03:23','390',2708610.30,2708610.30,'390','2022-03-02 06:05:16','606','2022-03-02 08:22:23',10,0),('5','96',257701,'Daily','2022-03-02','2022-03-02 11:56:52','2022-03-03 11:56:52','390',0.00,0.00,'390','2022-03-03 06:25:13','606','2022-03-03 10:22:56',10,0),('5','96',257702,'Daily','2022-03-03','2022-03-03 12:10:11','2022-03-04 12:10:11','390',0.00,0.00,'390','2022-03-04 06:08:44','606','2022-03-04 09:15:04',10,0),('5','96',257703,'Daily shift','2022-03-04','2022-03-05 06:44:07','2022-03-06 06:44:07','390',0.00,0.00,'390','2022-03-05 06:46:33','606','2022-03-05 07:35:28',10,0),('5','96',257704,'Daily shift','2022-03-05','2022-03-07 07:53:49','2022-03-08 07:53:49','390',0.00,0.00,'390','2022-03-07 07:56:04','606','2022-03-07 08:00:37',10,0),('5','96',257705,'Daily ','2022-03-06','2022-03-07 10:04:31','2022-03-08 10:04:31','390',802159.05,802159.05,'390','2022-03-08 07:20:41','600','2022-03-08 07:22:33',10,0),('5','96',257706,'Daily','2022-03-07','2022-03-08 08:45:01','2022-03-09 08:45:01','390',696174.60,696174.60,'390','2022-03-08 08:50:37','600','2022-03-08 09:46:33',10,0),('5','96',257707,'Daily','2022-03-08','2022-03-08 10:14:31','2022-03-09 10:14:31','390',643074.30,643074.30,'390','2022-03-09 06:23:17','606','2022-03-09 07:59:21',10,0),('5','96',257708,'Daily','2022-03-09','2022-03-09 09:19:01','2022-03-10 09:19:01','390',198173.25,198173.25,'390','2022-03-09 21:47:27','606','2022-03-10 06:42:04',10,0),('5','96',257709,'Daily','2022-03-10','2022-03-10 09:41:16','2022-03-11 09:41:16','390',0.00,0.00,'390','2022-03-10 20:22:20','606','2022-03-11 08:27:01',10,0),('5','96',257710,'Daily','2022-03-11','2022-03-11 09:42:24','2022-03-12 09:42:24','390',305814.30,305814.30,'390','2022-03-12 15:04:02','600','2022-03-12 15:06:31',10,0),('5','96',257711,'Daily','2022-03-12','2022-03-12 20:51:18','2022-03-13 20:51:18','390',1485598.95,1485598.95,'390','2022-03-12 20:52:31','606','2022-03-13 08:08:40',10,0),('5','96',257712,'Daily','2022-03-13','2022-03-13 08:52:05','2022-03-14 08:52:05','390',1186897.80,1186897.80,'390','2022-03-13 22:05:40','606','2022-03-14 07:08:27',10,0),('5','96',257713,'Daily','2022-03-14','2022-03-14 10:50:06','2022-03-15 10:50:06','390',963045.60,963045.60,'390','2022-03-14 22:28:31','606','2022-03-15 07:10:25',10,0),('5','96',257714,'Daily','2022-03-15','2022-03-15 09:09:30','2022-03-16 09:09:30','390',1102622.40,1102622.40,'390','2022-03-15 20:56:42','606','2022-03-16 08:13:07',10,0),('5','96',257715,'daily sales','2022-03-16','2022-03-16 09:36:10','2022-03-17 09:36:10','390',904516.80,904516.80,'390','2022-03-16 20:31:55','606','2022-03-17 10:24:08',10,0),('5','96',257716,'daily sales','2022-03-17','2022-03-17 10:43:39','2022-03-18 10:43:39','390',779461.65,779461.65,'390','2022-03-18 06:07:08','606','2022-03-18 07:49:04',10,0),('5','96',257717,'Daily sales','2022-03-18','2022-03-18 10:00:24','2022-03-19 10:00:24','390',778880.85,778880.85,'390','2022-03-18 21:34:00','606','2022-03-19 07:03:49',10,0),('5','96',257718,'daily sales','2022-03-19','2022-03-19 07:23:18','2022-03-20 07:23:18','390',603636.00,603636.00,'390','2022-03-20 06:27:36','606','2022-03-20 07:33:53',10,0),('5','96',257719,'Daily sales','2022-03-20','2022-03-20 10:49:46','2022-03-21 10:49:46','390',226645.65,226645.65,'390','2022-03-20 21:57:39','606','2022-03-21 06:35:15',10,0),('5','96',257720,'Daily sales','2022-03-21','2022-03-21 08:07:56','2022-03-22 08:07:56','390',0.00,0.00,'390','2022-03-22 06:04:18','606','2022-03-22 07:08:33',10,0),('5','96',257721,'Daily sales','2022-03-22','2022-03-22 09:20:09','2022-03-23 09:20:09','390',0.00,0.00,'390','2022-03-22 20:51:15','606','2022-03-23 06:34:57',10,0),('5','96',257722,'Daily sales','2022-03-23','2022-03-23 10:28:28','2022-03-24 10:28:28','390',0.00,0.00,'390','2022-03-31 13:38:45','797','2022-03-31 13:44:02',10,0),('5','96',257723,'Daly shift','2022-03-24','2022-03-31 13:49:43','2022-04-01 13:49:43','390',0.00,0.00,'390','2022-03-31 13:51:16','797','2022-03-31 13:53:43',10,0),('5','96',257724,'Dally shift','2022-03-25','2022-03-31 17:39:52','2022-04-01 17:39:52','390',0.00,0.00,'600','2022-03-31 18:02:19','600','2022-03-31 18:02:48',10,0),('5','96',257725,'Dally shift','2022-03-25','2022-03-31 18:09:46','2022-04-01 18:09:46','390',766288.05,766288.05,'390','2022-03-31 18:11:40','797','2022-03-31 18:14:24',10,0),('5','96',257726,'Dally shift','2022-03-26','2022-03-31 18:21:01','2022-04-01 18:21:01','390',826529.55,826529.55,'390','2022-03-31 18:22:46','797','2022-03-31 19:03:55',10,0),('5','96',257727,'Daly shift','2022-03-27','2022-03-31 19:08:53','2022-04-01 19:08:53','390',686134.35,686134.35,'390','2022-03-31 19:10:26','797','2022-03-31 19:14:09',10,0),('5','96',257728,'Daly shift','2022-03-28','2022-03-31 19:15:36','2022-04-01 19:15:36','390',0.00,0.00,'390','2022-03-31 19:16:32','797','2022-03-31 19:16:55',10,0),('5','96',257729,'Daly shift','2022-03-29','2022-03-31 19:24:19','2022-04-01 19:24:19','390',0.00,0.00,'390','2022-03-31 19:25:13','797','2022-03-31 19:26:22',10,0),('5','96',257730,'Dally shift','2022-03-30','2022-03-31 19:27:49','2022-04-01 19:27:49','390',0.00,0.00,'390','2022-03-31 19:28:33','797','2022-03-31 19:29:41',10,0),('5','96',257731,'Daly shift','2022-03-31','2022-03-31 19:31:26','2022-04-01 19:31:26','390',0.00,0.00,'390','2022-03-31 19:32:12','797','2022-03-31 19:41:44',10,0),('5','96',257732,'Daly shift','2022-04-01','2022-04-01 12:03:53','2022-04-02 12:03:53','390',0.00,0.00,'390','2022-04-02 17:05:14','600','2022-04-02 17:09:28',10,0),('5','96',257733,'Daly shift','2022-04-02','2022-04-02 20:39:04','2022-04-03 20:39:04','390',0.00,0.00,'390','2022-04-02 20:40:04','797','2022-04-02 21:17:58',10,0),('5','96',257734,'Daly shift','2022-04-03','2022-04-03 16:04:38','2022-04-04 16:04:38','390',0.00,0.00,'390','2022-04-03 20:51:40','606','2022-04-03 22:02:07',10,0),('5','96',257735,'Dally shift','2022-04-04','2022-04-04 11:12:46','2022-04-05 11:12:46','390',0.00,0.00,'390','2022-04-04 22:31:34','797','2022-04-05 10:30:25',10,0),('5','96',257736,'Dally shift','2022-04-05','2022-04-05 16:47:50','2022-04-06 16:47:50','390',0.00,0.00,'390','2022-04-05 19:28:58','797','2022-04-06 09:50:16',10,0),('5','96',257737,'Daly shift','2022-04-06','2022-04-06 10:09:16','2022-04-07 10:09:16','390',0.00,0.00,'390','2022-04-06 22:58:47','606','2022-04-07 06:11:55',10,0),('5','96',257738,'Daly shift','2022-04-07','2022-04-07 07:59:41','2022-04-08 07:59:41','390',0.00,0.00,'390','2022-04-07 20:15:46','797','2022-04-08 10:32:03',10,0),('5','96',257739,'Daly shift','2022-04-08','2022-04-08 10:47:56','2022-04-09 10:47:56','390',0.00,0.00,'390','2022-04-08 19:43:33','797','2022-04-09 12:53:01',10,0),('5','96',257740,'Dally shift ','2022-04-09','2022-04-09 13:23:05','2022-04-10 13:23:05','390',932172.45,932172.45,'390','2022-04-09 22:58:13','797','2022-04-10 14:59:01',10,0),('5','96',257741,'Dally shift','2022-04-10','2022-04-10 15:08:36','2022-04-11 15:08:36','390',764992.80,764992.80,'390','2022-04-10 23:40:33','797','2022-04-11 08:59:12',10,0),('5','96',257742,'Dally shift','2022-04-11','2022-04-11 14:53:12','2022-04-12 14:53:12','390',932466.15,932466.15,'390','2022-04-11 23:45:39','797','2022-04-12 07:18:21',10,0),('5','96',257743,'Dally shift ','2022-04-12','2022-04-12 13:02:01','2022-04-13 13:02:01','390',915718.65,915718.65,'390','2022-04-12 23:04:24','797','2022-04-13 09:56:04',10,0),('5','96',257744,'Dally shift','2022-04-13','2022-04-13 12:42:08','2022-04-14 12:42:08','390',1030563.60,1030563.60,'390','2022-04-14 00:10:29','797','2022-04-14 08:26:15',10,0),('5','96',257745,'Dally shift','2022-04-14','2022-04-14 16:45:36','2022-04-15 16:45:36','390',1533937.35,1533937.35,'390','2022-04-15 00:08:09','797','2022-04-15 15:16:55',10,0),('5','96',257746,'Dally shift1','2022-04-15','2022-04-15 15:35:34','2022-04-16 15:35:34','390',1271707.80,1271707.80,'390','2022-04-15 23:37:05','797','2022-04-16 11:32:28',10,0),('5','96',257747,'Dally shift ','2022-04-16','2022-04-16 14:19:19','2022-04-17 14:19:19','390',692740.95,692740.95,'390','2022-04-16 23:39:01','797','2022-04-17 07:08:54',10,0),('5','96',257748,'Dally shift1','2022-04-17','2022-04-17 13:52:25','2022-04-18 13:52:25','390',996580.20,996580.20,'390','2022-04-17 23:27:24','797','2022-04-18 10:38:44',10,0),('5','96',257749,'Dally shift ','2022-04-18','2022-04-18 15:52:16','2022-04-19 15:52:16','390',718768.05,718768.05,'390','2022-04-19 00:34:39','797','2022-04-19 04:32:01',10,0),('5','96',257750,'Dally shift ','2022-04-19','2022-04-19 10:27:45','2022-04-20 10:27:45','390',742061.10,742061.10,'390','2022-04-19 23:24:23','797','2022-04-20 09:32:11',10,0),('5','96',257751,'Dally shift ','2022-04-20','2022-04-20 09:50:21','2022-04-21 09:50:21','390',1006904.25,1006904.25,'390','2022-04-20 23:46:31','797','2022-04-21 08:55:50',10,0),('5','96',257752,'Dally shift','2022-04-21','2022-04-21 22:17:17','2022-04-22 22:17:17','390',772642.20,772642.20,'390','2022-04-21 22:19:47','797','2022-04-22 09:27:18',10,0),('5','96',257753,'Dally shift ','2022-04-22','2022-04-22 11:11:22','2022-04-23 11:11:22','390',806599.20,806599.20,'390','2022-04-22 20:50:15','797','2022-04-23 09:27:30',10,0),('5','96',257754,'Dally shift ','2022-04-23','2022-04-23 21:41:42','2022-04-24 21:41:42','390',325787.55,325787.55,'390','2022-04-23 21:43:25','797','2022-04-23 22:09:03',10,0),('5','96',257755,'Dally shift ','2022-04-24','2022-04-24 10:18:47','2022-04-25 10:18:47','390',961832.85,961832.85,'390','2022-04-24 20:50:58','797','2022-04-25 04:55:07',10,0),('5','96',257756,'Daly shift','2022-04-25','2022-04-25 09:17:54','2022-04-26 09:17:54','390',835498.95,835498.95,'390','2022-04-25 19:32:57','797','2022-04-26 07:36:24',10,0),('5','96',257757,'Dally shift ','2022-04-26','2022-04-26 08:26:24','2022-04-27 08:26:24','390',977989.65,977989.65,'390','2022-04-26 22:42:27','797','2022-04-27 05:41:04',10,0),('5','96',257758,'Dally shift ','2022-04-27','2022-04-27 17:19:50','2022-04-28 17:19:50','390',963601.65,963601.65,'390','2022-04-27 23:16:04','797','2022-04-28 07:34:30',10,0),('5','96',257759,'Dally shift ','2022-04-28','2022-04-28 09:17:44','2022-04-29 09:17:44','390',926237.40,926237.40,'390','2022-04-28 20:19:25','797','2022-04-28 20:50:49',10,0),('5','96',257760,'Daly shift','2022-04-29','2022-04-29 22:23:32','2022-04-30 22:23:32','390',854167.05,854167.05,'390','2022-04-29 22:26:15','797','2022-05-09 10:24:18',10,0),('5','96',257761,'Dally shift ','2022-04-30','2022-05-09 14:09:02','2022-05-10 14:09:02','390',1047365.55,1047365.55,'390','2022-05-09 14:15:29','797','2022-05-09 14:58:52',10,0),('5','96',257762,'Dally shift','2022-05-03','2022-05-09 20:20:12','2022-05-10 20:20:12','390',915222.00,915222.00,'390','2022-05-09 22:25:49','797','2022-05-10 08:58:23',10,0),('5','96',257763,'Dally shift','2022-05-04','2022-05-10 10:29:07','2022-05-11 10:29:07','390',881525.70,881525.70,'390','2022-05-10 10:32:15','797','2022-05-10 10:33:57',10,0),('5','96',257764,'Dally shift ','2022-05-05','2022-05-10 10:41:45','2022-05-11 10:41:45','390',926994.75,926994.75,'390','2022-05-10 10:43:07','797','2022-05-10 10:43:37',10,0),('5','96',257765,'Daly shift','2022-05-06','2022-05-10 10:46:40','2022-05-11 10:46:40','390',885891.60,885891.60,'390','2022-05-10 10:48:12','797','2022-05-10 10:49:53',10,0),('5','96',257766,'Dally shift','2022-05-07','2022-05-10 10:51:31','2022-05-11 10:51:31','390',849198.90,849198.90,'390','2022-05-10 10:52:37','797','2022-05-10 10:53:27',10,0),('5','96',257767,'Daly shift','2022-05-08','2022-05-10 10:56:59','2022-05-11 10:56:59','390',501565.35,501565.35,'390','2022-05-10 11:02:01','797','2022-05-10 11:03:08',10,0),('5','96',257768,'Dally shift ','2022-05-09','2022-05-10 11:05:18','2022-05-11 11:05:18','390',0.00,0.00,'390','2022-05-10 11:06:12','797','2022-05-10 11:06:36',10,0),('5','96',257769,'Dally shift','2022-05-10','2022-05-10 11:08:46','2022-05-11 11:08:46','390',0.00,0.00,'390','2022-05-10 22:58:41','797','2022-05-11 05:35:54',10,0),('5','96',257770,'Daly shift','2022-05-11','2022-05-11 18:33:29','2022-05-12 18:33:29','390',0.00,0.00,'390','2022-05-11 19:42:22','797','2022-05-12 08:29:40',10,0),('5','96',257771,'Dally shift','2022-05-12','2022-05-12 20:18:57','2022-05-13 20:18:57','390',0.00,0.00,'390','2022-05-12 20:21:52','797','2022-05-13 09:55:16',10,0),('5','96',257772,'Daly shift','2022-05-13','2022-05-13 19:42:02','2022-05-14 19:42:02','390',0.00,0.00,'390','2022-05-14 09:37:29','797','2022-05-14 14:29:48',10,0),('5','96',257773,'Dally shift ','2022-05-14','2022-05-14 14:46:42','2022-05-15 14:46:42','390',922681.65,922681.65,'390','2022-05-14 23:36:37','797','2022-05-15 06:10:27',10,0),('5','96',257774,'Dally shift ','2022-05-15','2022-05-15 10:18:50','2022-05-16 10:18:50','390',976847.85,976847.85,'390','2022-05-15 23:34:53','797','2022-05-16 06:20:09',10,0),('5','96',257775,'Dally shift','2022-05-16','2022-05-16 12:18:26','2022-05-17 12:18:26','390',978814.65,978814.65,'390','2022-05-16 22:25:38','797','2022-05-17 06:54:26',10,0),('5','96',257776,'Daly shift','2022-05-17','2022-05-17 10:38:03','2022-05-18 10:38:03','390',827541.00,827541.00,'390','2022-05-17 20:59:16','797','2022-05-18 07:13:31',10,0),('5','96',257777,'Dally shift 63','2022-05-18','2022-05-18 07:59:48','2022-05-19 07:59:48','390',861895.65,861895.65,'390','2022-05-18 20:43:44','797','2022-05-19 06:19:14',10,0),('5','96',257778,'Dally shift ','2022-05-19','2022-05-19 09:13:39','2022-05-20 09:13:39','390',401558.85,401558.85,'390','2022-05-19 21:07:41','797','2022-05-19 22:32:39',10,0),('5','96',257779,'Dally shift','2022-05-20','2022-05-20 09:14:02','2022-05-21 09:14:02','390',0.00,0.00,'390','2022-05-20 23:06:23','797','2022-05-21 05:50:27',10,0),('5','96',257780,'Dally shift','2022-05-21','2022-05-21 07:20:43','2022-05-22 07:20:43','390',993798.30,993798.30,'390','2022-05-21 22:59:26','797','2022-05-22 06:31:23',10,0),('5','96',257781,'Dally shift1','2022-05-22','2022-05-22 08:22:11','2022-05-23 08:22:11','390',885817.35,885817.35,'390','2022-05-22 20:45:04','797','2022-05-23 05:42:37',10,0),('5','96',257782,'Daly shift','2022-05-23','2022-05-23 10:26:35','2022-05-24 10:26:35','390',893215.95,893215.95,'390','2022-05-23 23:32:35','797','2022-05-24 06:27:58',10,0),('5','96',257783,'Dally shift ','2022-05-24','2022-05-24 07:41:13','2022-05-25 07:41:13','390',835668.90,835668.90,'390','2022-05-24 23:29:37','797','2022-05-25 07:30:26',10,0),('5','96',257784,'Dally shift1','2022-05-25','2022-05-25 07:48:22','2022-05-26 07:48:22','390',898466.25,898466.25,'390','2022-05-25 23:01:22','797','2022-05-26 05:40:59',10,0),('5','96',257785,'Dally shift','2022-05-26','2022-05-26 08:12:56','2022-05-27 08:12:56','390',433347.75,433347.75,'390','2022-05-26 23:35:23','797','2022-05-27 05:53:12',10,0),('5','96',257786,'Daly shift','2022-05-27','2022-05-27 07:49:25','2022-05-28 07:49:25','390',874945.50,874945.50,'390','2022-05-27 21:31:51','797','2022-05-28 06:58:35',10,0),('5','96',257787,'Daly shift','2022-05-28','2022-05-28 09:02:44','2022-05-29 09:02:44','390',890422.50,890422.50,'390','2022-05-28 19:38:01','797','2022-05-29 09:42:14',10,0),('5','96',257788,'Dally shift ','2022-05-29','2022-05-29 11:35:13','2022-05-30 11:35:13','390',859480.05,859480.05,'390','2022-05-29 22:34:07','797','2022-05-30 06:25:48',10,0),('5','96',257789,'Dally shift ','2022-05-30','2022-05-30 09:22:01','2022-05-31 09:22:01','390',872130.60,872130.60,'390','2022-05-30 22:38:28','797','2022-05-31 05:39:06',10,0),('5','96',257790,'Dally shift','2022-05-31','2022-05-31 22:46:02','2022-06-01 22:46:02','390',434562.15,434562.15,'390','2022-05-31 22:48:16','797','2022-06-01 05:58:15',10,0),('5','96',257791,'Daly shift','2022-06-01','2022-06-01 12:05:26','2022-06-02 12:05:26','390',0.00,0.00,'390','2022-06-01 23:17:30','797','2022-06-02 05:40:22',10,0),('5','96',257792,'Dally shift','2022-06-02','2022-06-02 08:07:40','2022-06-03 08:07:40','390',0.00,0.00,'390','2022-06-02 21:03:00','797','2022-06-03 05:47:28',10,0),('5','96',257793,'Dally shift ','2022-06-03','2022-06-03 09:21:23','2022-06-04 09:21:23','390',0.00,0.00,'390','2022-06-03 23:53:18','797','2022-06-04 07:49:11',10,0),('5','96',257794,'Dally shift','2022-06-04','2022-06-04 09:45:35','2022-06-05 09:45:35','390',0.00,0.00,'390','2022-06-04 20:39:13','797','2022-06-05 08:10:40',10,0),('5','96',257795,'Daly shift','2022-06-05','2022-06-05 09:11:10','2022-06-06 09:11:10','390',0.00,0.00,'390','2022-06-05 23:25:35','797','2022-06-06 09:47:07',10,0),('5','96',257796,'Daly shift','2022-06-06','2022-06-06 11:11:58','2022-06-07 11:11:58','390',1060141.50,1060141.50,'390','2022-06-06 22:28:53','797','2022-06-07 06:51:04',10,0),('5','96',257797,'Dally shift','2022-06-07','2022-06-07 09:32:10','2022-06-08 09:32:10','390',991986.60,991986.60,'390','2022-06-07 22:11:42','797','2022-06-08 09:05:26',10,0),('5','96',257798,'Dally shift ','2022-06-08','2022-06-08 10:17:18','2022-06-09 10:17:18','390',957532.95,957532.95,'390','2022-06-08 20:12:24','797','2022-06-08 23:04:41',10,0),('5','96',257799,'Dally shift ','2022-06-09','2022-06-09 11:35:14','2022-06-10 11:35:14','390',934008.90,934008.90,'390','2022-06-09 22:48:16','797','2022-06-10 05:46:25',10,0),('5','96',257800,'Dally shift ','2022-06-10','2022-06-10 09:05:30','2022-06-11 09:05:30','390',948390.30,948390.30,'390','2022-06-10 23:12:21','797','2022-06-11 05:52:36',10,0),('5','96',257801,'Dally shift ','2022-06-11','2022-06-11 09:53:48','2022-06-12 09:53:48','390',1040602.20,1040602.20,'390','2022-06-11 22:35:07','797','2022-06-12 12:34:43',10,0),('5','96',257802,'Dally shift1','2022-06-12','2022-06-12 15:38:58','2022-06-13 15:38:58','390',976831.35,976831.35,'390','2022-06-12 22:50:18','797','2022-06-13 07:03:30',10,0),('5','96',257803,'Dally shift1','2022-06-13','2022-06-13 22:48:53','2022-06-14 22:48:53','390',399293.40,399293.40,'390','2022-06-13 22:52:02','797','2022-06-14 06:49:36',10,0),('5','96',257804,'Dally shift ','2022-06-14','2022-06-14 11:00:17','2022-06-15 11:00:17','390',0.00,0.00,'390','2022-06-14 23:42:08','797','2022-06-15 09:32:40',10,0),('5','96',257805,'Daly shift','2022-06-15','2022-06-15 14:21:59','2022-06-16 14:21:59','390',0.00,0.00,'390','2022-06-15 20:36:10','797','2022-06-16 06:58:31',10,0),('5','96',257806,'Daly shift','2022-06-16','2022-06-16 08:13:45','2022-06-17 08:13:45','390',0.00,0.00,'390','2022-06-16 20:12:41','797','2022-06-17 07:09:18',10,0),('5','96',257807,'Dally shift ','2022-06-17','2022-06-17 09:36:11','2022-06-18 09:36:11','390',0.00,0.00,'390','2022-06-17 22:39:30','797','2022-06-18 07:32:48',10,0),('5','96',257808,'Daly shift','2022-06-18','2022-06-18 11:54:58','2022-06-19 11:54:58','390',0.00,0.00,'390','2022-06-18 23:56:40','797','2022-06-19 15:51:24',10,0),('5','96',257809,'Dally shift','2022-06-19','2022-06-19 15:58:26','2022-06-20 15:58:26','390',995874.00,995874.00,'390','2022-06-19 22:40:03','797','2022-06-20 06:06:58',10,0),('5','96',257810,'Dally shift1','2022-06-20','2022-06-20 10:34:10','2022-06-21 10:34:10','390',974536.20,974536.20,'390','2022-06-20 23:31:59','797','2022-06-21 06:19:01',10,0),('5','96',257811,'Dally shift1','2022-06-21','2022-06-21 11:35:10','2022-06-22 11:35:10','390',865306.20,865306.20,'390','2022-06-21 23:18:41','797','2022-06-23 05:36:48',10,0),('5','96',257812,'Daly shift','2022-06-22','2022-06-23 08:25:45','2022-06-24 08:25:45','390',934952.70,934952.70,'390','2022-06-23 08:30:19','797','2022-06-23 09:13:20',10,0),('5','96',257813,'Dally shift1','2022-06-23','2022-06-23 09:34:51','2022-06-24 09:34:51','390',779639.85,779639.85,'390','2022-06-23 23:57:48','797','2022-06-24 07:04:03',10,0),('5','96',257814,'Daly shift','2022-06-24','2022-06-24 13:10:13','2022-06-25 13:10:13','390',0.00,0.00,'390','2022-06-24 22:35:03','797','2022-06-25 07:55:21',10,0),('5','96',257815,'Dally shift','2022-06-25','2022-06-25 18:05:18','2022-06-26 18:05:18','390',61515.30,61515.30,'390','2022-06-25 23:16:50','797','2022-06-26 09:01:22',10,0),('5','96',257816,'Dally shift ','2022-06-26','2022-06-26 10:22:16','2022-06-27 10:22:16','390',0.00,0.00,'390','2022-06-26 22:59:03','797','2022-06-27 09:40:55',10,0),('5','96',257817,'Dally shift','2022-06-27','2022-06-27 13:58:29','2022-06-28 13:58:29','390',0.00,0.00,'390','2022-06-27 19:51:35','797','2022-06-28 09:38:10',10,0),('5','96',257818,'Dally shift1','2022-06-28','2022-06-28 14:49:18','2022-06-29 14:49:18','390',0.00,0.00,'390','2022-06-28 21:03:05','797','2022-06-29 09:29:08',10,0),('5','96',257819,'Dally shift ','2022-06-29','2022-06-29 09:50:23','2022-06-30 09:50:23','390',0.00,0.00,'390','2022-06-29 22:59:00','797','2022-06-30 07:18:33',10,0),('5','96',257820,'Dally shift','2022-06-30','2022-06-30 11:50:31','2022-07-01 11:50:31','390',0.00,0.00,'390','2022-06-30 19:48:32','797','2022-07-01 07:31:45',10,0),('5','96',257821,'Dally shift','2022-07-01','2022-07-01 14:36:07','2022-07-02 14:36:07','390',0.00,0.00,'390','2022-07-01 22:49:46','797','2022-07-02 09:06:19',10,0),('5','96',257822,'Daly shift1313','2022-07-02','2022-07-02 09:16:59','2022-07-03 09:16:59','390',0.00,0.00,'390','2022-07-02 22:45:20','797','2022-07-03 09:07:32',10,0),('5','96',257823,'Daly shift','2022-07-03','2022-07-03 12:08:15','2022-07-04 12:08:15','390',0.00,0.00,'390','2022-07-03 23:25:31','797','2022-07-04 07:00:58',10,0),('5','96',257824,'Dally shift ','2022-07-04','2022-07-04 12:34:42','2022-07-05 12:34:42','390',0.00,0.00,'390','2022-07-04 23:33:31','797','2022-07-05 06:32:45',10,0),('5','96',257825,'Daly shift','2022-07-05','2022-07-05 08:47:28','2022-07-06 08:47:28','390',0.00,0.00,'390','2022-07-05 20:33:23','797','2022-07-06 06:27:32',10,0),('5','96',257826,'Dally shift','2022-07-06','2022-07-06 09:55:24','2022-07-07 09:55:24','390',0.00,0.00,'390','2022-07-06 22:56:30','797','2022-07-07 06:52:07',10,0),('5','96',257827,'Daly shift','2022-07-07','2022-07-07 09:45:36','2022-07-08 09:45:36','390',0.00,0.00,'390','2022-07-07 19:43:04','797','2022-07-08 03:56:08',10,0),('5','96',257828,'Dally shift','2022-07-08','2022-07-08 09:33:13','2022-07-09 09:33:13','390',0.00,0.00,'390','2022-07-08 20:42:31','797','2022-07-09 10:57:15',10,0),('5','96',257829,'Dally shift','2022-07-09','2022-07-09 11:24:05','2022-07-10 11:24:05','390',0.00,0.00,'390','2022-07-09 23:41:38','797','2022-07-10 06:54:46',10,0),('5','96',257830,'Daly shift','2022-07-10','2022-07-10 08:49:25','2022-07-11 08:49:25','390',0.00,0.00,'390','2022-07-10 20:13:48','797','2022-07-11 07:40:13',10,0),('5','96',257831,'Daly shift','2022-07-11','2022-07-11 08:25:43','2022-07-12 08:25:43','390',0.00,0.00,'390','2022-07-11 22:38:04','797','2022-07-12 08:42:28',10,0),('5','96',257832,'Dally shift ','2022-07-12','2022-07-12 11:13:26','2022-07-13 11:13:26','390',0.00,0.00,'390','2022-07-12 19:44:17','797','2022-07-13 06:52:30',10,0),('5','96',257833,'Dally shift1','2022-07-13','2022-07-13 23:20:37','2022-07-14 23:20:37','390',0.00,0.00,'390','2022-07-13 23:21:22','797','2022-07-14 06:26:20',10,0),('5','96',257834,'Dally shift','2022-07-14','2022-07-14 12:01:27','2022-07-15 12:01:27','390',1006953.15,1006953.15,'390','2022-07-14 23:09:59','797','2022-07-15 06:42:37',10,0),('5','96',257835,'Dally shift ','2022-07-15','2022-07-15 07:50:57','2022-07-16 07:50:57','390',1039054.35,1039054.35,'390','2022-07-15 22:27:58','797','2022-07-16 05:46:49',10,0),('5','96',257836,'Dally shift','2022-07-16','2022-07-16 09:31:36','2022-07-17 09:31:36','390',951525.30,951525.30,'390','2022-07-16 23:24:39','797','2022-07-17 06:05:14',10,0),('5','96',257837,'Daly shift','2022-07-17','2022-07-17 08:15:50','2022-07-18 08:15:50','390',949573.55,949573.55,'390','2022-07-17 23:26:06','797','2022-07-18 07:34:14',10,0),('5','96',257838,'Dally shift ','2022-07-18','2022-07-18 09:20:52','2022-07-19 09:20:52','390',973370.10,973370.10,'390','2022-07-18 23:43:19','797','2022-07-19 05:52:04',10,0),('5','96',257839,'Dally shift1','2022-07-19','2022-07-19 08:56:42','2022-07-20 08:56:42','390',984100.10,984100.10,'390','2022-07-19 23:19:11','797','2022-07-20 06:46:23',10,0),('5','96',257840,'Daly shift','2022-07-20','2022-07-20 08:09:02','2022-07-21 08:09:02','390',1030333.45,1030333.45,'390','2022-07-20 20:10:21','797','2022-07-21 07:46:22',10,0),('5','96',257841,'Dally shift ','2022-07-21','2022-07-21 08:52:06','2022-07-22 08:52:06','390',1000690.90,1000690.90,'390','2022-07-21 23:13:55','797','2022-07-21 23:22:32',10,0),('5','96',257842,'Dally shift','2022-07-22','2022-07-22 08:42:09','2022-07-23 08:42:09','390',1140419.55,1140419.55,'390','2022-07-22 22:54:12','797','2022-07-23 07:30:35',10,0),('5','96',257843,'Dally shift','2022-07-23','2022-07-23 09:07:55','2022-07-24 09:07:55','390',1531032.25,1531032.25,'390','2022-07-23 23:49:28','797','2022-07-24 06:57:48',10,0),('5','96',257844,'Daly shift','2022-07-24','2022-07-24 08:52:04','2022-07-25 08:52:04','390',1210392.10,1210392.10,'390','2022-07-24 23:13:02','797','2022-07-25 06:42:50',10,0),('5','96',257845,'Dally shift1','2022-07-25','2022-07-25 07:08:04','2022-07-26 07:08:04','390',1159300.65,1159300.65,'390','2022-07-25 22:37:27','797','2022-07-26 07:42:53',10,0),('5','96',257846,'Dally shift1','2022-07-26','2022-07-26 08:57:02','2022-07-27 08:57:02','390',1110125.80,1110125.80,'390','2022-07-26 22:47:27','797','2022-07-27 06:57:49',10,0),('5','96',257847,'Daly shift','2022-07-27','2022-07-27 20:12:07','2022-07-28 20:12:07','390',1005290.00,1005290.00,'390','2022-07-27 20:14:22','797','2022-07-28 08:59:23',10,0),('5','96',257848,'Dally shift1','2022-07-28','2022-07-28 10:20:44','2022-07-29 10:20:44','390',743202.35,743202.35,'390','2022-07-28 23:20:55','797','2022-07-29 06:58:30',10,0),('5','96',257849,'Dally shift ','2022-07-29','2022-07-29 07:35:31','2022-07-30 07:35:31','390',0.00,0.00,'390','2022-07-29 23:25:11','797','2022-07-30 07:01:30',10,0),('5','96',257850,'Dally shift','2022-07-30','2022-07-30 11:00:56','2022-07-31 11:00:56','390',0.00,0.00,'390','2022-07-30 21:39:31','797','2022-07-31 05:59:43',10,0),('5','96',257851,'Dally shift ','2022-07-31','2022-07-31 08:25:09','2022-08-01 08:25:09','390',0.00,0.00,'390','2022-07-31 21:04:37','797','2022-08-01 06:49:38',10,0),('5','96',257852,'Dally shift','2022-08-01','2022-08-01 07:37:38','2022-08-02 07:37:38','390',0.00,0.00,'390','2022-08-01 22:50:40','797','2022-08-02 07:34:03',10,0),('5','96',257853,'Dally shift1','2022-08-02','2022-08-02 09:20:57','2022-08-03 09:20:57','390',971612.60,971612.60,'390','2022-08-02 21:42:14','797','2022-08-03 06:37:06',10,0),('5','96',257854,'Dally shift ','2022-08-03','2022-08-03 09:27:04','2022-08-04 09:27:04','390',842987.65,842987.65,'390','2022-08-03 22:16:32','797','2022-08-04 06:52:33',10,0),('5','96',257855,'Daly shift','2022-08-04','2022-08-04 22:36:38','2022-08-05 22:36:38','390',948030.65,948030.65,'390','2022-08-04 22:40:29','797','2022-08-05 06:38:16',10,0),('5','96',257856,'Dally shift','2022-08-05','2022-08-05 08:38:00','2022-08-06 08:38:00','390',1325717.40,1325717.40,'390','2022-08-05 20:01:36','797','2022-08-06 09:12:01',10,0),('5','96',257857,'Daly shift','2022-08-06','2022-08-06 10:31:51','2022-08-07 10:31:51','390',1065614.80,1065614.80,'390','2022-08-06 22:18:46','797','2022-08-07 07:13:41',10,0),('5','96',257858,'Dally shift ','2022-08-07','2022-08-07 10:49:30','2022-08-08 10:49:30','390',996271.25,996271.25,'390','2022-09-03 22:40:53','797','2022-09-05 11:12:41',10,0),('5','96',257859,'Dally shift','2022-08-08','2022-09-05 13:44:14','2022-09-06 13:44:14','390',1039392.90,1039392.90,'390','2022-09-05 14:21:09','797','2022-09-05 14:27:25',10,0),('5','96',257860,'Dally shift','2022-08-09','2022-09-05 14:37:55','2022-09-06 14:37:55','390',1075466.05,1075466.05,'390','2022-09-05 14:39:44','797','2022-09-05 14:48:25',10,0),('5','96',257861,'Dally shift','2022-08-10','2022-09-05 15:00:42','2022-09-06 15:00:42','390',0.00,0.00,'390','2022-09-05 15:01:20','797','2022-09-05 15:02:21',10,0),('5','96',257862,'Dally shift','2022-08-11','2022-09-05 15:04:32','2022-09-06 15:04:32','390',0.00,0.00,'390','2022-09-05 15:05:10','797','2022-09-05 15:10:31',10,0),('5','96',257863,'Dally shift','2022-08-12','2022-09-05 15:11:42','2022-09-06 15:11:42','390',0.00,0.00,'390','2022-09-05 15:12:12','797','2022-09-05 15:15:27',10,0),('5','96',257864,'Dally shift','2022-08-13','2022-09-05 15:17:00','2022-09-06 15:17:00','390',0.00,0.00,'390','2022-09-05 15:17:32','797','2022-09-05 15:18:18',10,0),('5','96',257865,'Dally shift','2022-08-14','2022-09-05 15:19:20','2022-09-06 15:19:20','390',0.00,0.00,'390','2022-09-05 15:19:53','797','2022-09-05 15:26:39',10,0),('5','96',257866,'Dally shift','2022-08-15','2022-09-05 15:27:34','2022-09-06 15:27:34','390',0.00,0.00,'390','2022-09-05 15:28:06','797','2022-09-05 15:33:41',10,0),('5','96',257867,'Dally shift','2022-08-16','2022-09-05 15:35:01','2022-09-06 15:35:01','390',0.00,0.00,'390','2022-09-05 15:35:31','797','2022-09-05 15:36:33',10,0),('5','96',257868,'Dally shift','2022-08-17','2022-09-05 15:37:33','2022-09-06 15:37:33','390',0.00,0.00,'390','2022-09-05 15:38:46','797','2022-09-05 15:40:35',10,0),('5','96',257869,'Dally shift','2022-08-18','2022-09-05 15:41:23','2022-09-06 15:41:23','390',0.00,0.00,'390','2022-09-05 15:41:56','797','2022-09-05 15:45:19',10,0),('5','96',257870,'Dally shift','2022-08-19','2022-09-05 15:46:35','2022-09-06 15:46:35','390',0.00,0.00,'390','2022-09-05 15:47:06','797','2022-09-05 15:51:40',10,0),('5','96',257871,'Dally shift','2022-08-20','2022-09-05 15:52:59','2022-09-06 15:52:59','390',0.00,0.00,'390','2022-09-05 15:57:47','797','2022-09-05 16:06:51',10,0),('5','96',257872,'Dally shift','2022-08-19','2022-09-05 16:15:56','2022-09-06 16:15:56','390',385947.00,385947.00,'390','2022-09-05 16:17:11','797','2022-09-05 16:18:27',10,0),('5','96',257873,'Dally shift','2022-08-20','2022-09-05 16:19:58','2022-09-06 16:19:58','390',957484.15,957484.15,'390','2022-09-05 16:21:20','797','2022-09-05 16:22:51',10,0),('5','96',257874,'Dally shift','2022-08-21','2022-09-05 16:26:29','2022-09-06 16:26:29','390',968249.30,968249.30,'390','2022-09-05 16:28:08','797','2022-09-05 16:31:00',10,0),('5','96',257875,'Dally shift','2022-08-22','2022-09-05 16:32:11','2022-09-06 16:32:11','390',958189.00,958189.00,'390','2022-09-05 16:33:51','797','2022-09-05 16:36:25',10,0),('5','96',257876,'Dally shift','2022-08-23','2022-09-05 16:37:37','2022-09-06 16:37:37','390',969999.40,969999.40,'390','2022-09-05 16:46:30','797','2022-09-05 16:47:52',10,0),('5','96',257877,'Dally shift','2022-08-24','2022-09-05 16:49:19','2022-09-06 16:49:19','390',715117.50,715117.50,'390','2022-09-05 16:50:40','797','2022-09-05 16:54:00',10,0),('5','96',257878,'Dally shift','2022-08-25','2022-09-06 13:52:09','2022-09-07 13:52:09','390',1033134.35,1033134.35,'390','2022-09-06 14:28:28','797','2022-09-06 14:30:28',10,0),('5','96',257879,'Dally shift','2022-08-26','2022-09-06 15:37:15','2022-09-07 15:37:15','390',1353402.65,1353402.65,'390','2022-09-06 15:40:39','797','2022-09-06 15:44:15',10,0),('5','96',257880,'Dally shift','2022-08-27','2022-09-06 15:49:10','2022-09-07 15:49:10','390',1211130.25,1211130.25,'390','2022-09-06 15:51:45','797','2022-09-06 16:09:47',10,0),('5','96',257881,'Dally shift','2022-08-28','2022-09-06 16:15:51','2022-09-07 16:15:51','390',1068282.50,1068282.50,'390','2022-09-06 16:21:48','797','2022-09-06 16:25:29',10,0),('5','96',257882,'Dally shift','2022-08-29','2022-09-06 16:26:40','2022-09-07 16:26:40','390',1007667.25,1007667.25,'390','2022-09-06 16:28:43','797','2022-09-06 16:30:34',10,0),('5','96',257883,'Dally shift','2022-08-30','2022-09-06 16:31:29','2022-09-07 16:31:29','390',1394855.60,1394855.60,'390','2022-09-06 16:34:57','797','2022-09-06 16:38:44',10,0),('5','96',257884,'Dally shift','2022-08-31','2022-09-06 16:39:42','2022-09-07 16:39:42','390',1249702.75,1249702.75,'390','2022-09-06 16:41:59','797','2022-09-06 16:43:44',10,0),('5','96',257885,'Dally shift','2022-09-01','2022-09-06 16:44:49','2022-09-07 16:44:49','390',1378305.50,1378305.50,'390','2022-09-06 16:46:48','797','2022-09-06 16:48:56',10,0),('5','96',257886,'Dally shift','2022-09-02','2022-09-06 16:50:11','2022-09-07 16:50:11','390',1030894.00,1030894.00,'390','2022-09-06 16:52:15','797','2022-09-06 16:53:41',10,0),('5','96',257887,'Dally shift','2022-09-03','2022-09-06 16:55:03','2022-09-07 16:55:03','390',0.00,0.00,'390','2022-09-06 16:55:35','797','2022-09-06 16:57:02',10,0),('5','96',257888,'Dally shift','2022-09-05','2022-09-06 16:58:04','2022-09-07 16:58:04','390',0.00,0.00,'390','2022-09-06 16:58:36','797','2022-09-06 16:59:39',10,0),('5','96',257889,'Dally shift','2022-09-06','2022-09-06 17:01:55','2022-09-07 17:01:55','390',752581.85,752581.85,'390','2022-09-06 22:14:48','797','2022-09-07 09:43:11',10,0),('5','96',257890,'Dally shift','2022-09-07','2022-09-07 09:53:16','2022-09-08 09:53:16','390',1049244.15,1049244.15,'390','2022-09-07 23:14:35','797','2022-09-08 09:04:57',10,0),('5','96',257891,'Dally shift','2022-09-08','2022-09-08 10:48:10','2022-09-09 10:48:10','390',1231765.15,1231765.15,'390','2022-09-08 22:25:18','797','2022-09-09 07:16:28',10,0),('5','96',257892,'Dally shift','2022-09-09','2022-09-09 11:30:20','2022-09-10 11:30:20','390',1004570.35,1004570.35,'390','2022-09-09 22:57:11','797','2022-09-10 10:18:07',10,0),('5','96',257893,'Dally shift','2022-09-10','2022-09-10 12:40:38','2022-09-11 12:40:38','390',1012392.15,1012392.15,'390','2022-09-10 22:54:25','797','2022-09-11 11:05:41',10,0),('5','96',257894,'Dally shift','2022-09-11','2022-09-11 11:33:08','2022-09-12 11:33:08','390',929432.60,929432.60,'390','2022-09-11 23:54:01','797','2022-09-12 06:28:15',10,0),('5','96',257895,'Dally shift','2022-09-12','2022-09-12 10:12:41','2022-09-13 10:12:41','390',956836.65,956836.65,'390','2022-09-12 23:04:33','797','2022-09-13 07:01:25',10,0),('5','96',257896,'Dally shift','2022-09-13','2022-09-13 10:31:15','2022-09-14 10:31:15','390',997303.55,997303.55,'390','2022-09-13 23:29:29','797','2022-09-14 09:17:21',10,0),('5','96',257897,'Dally shift','2022-09-14','2022-09-14 10:40:12','2022-09-15 10:40:12','390',225899.80,225899.80,'390','2022-09-15 00:29:50','797','2022-09-15 10:06:52',10,0),('5','96',257898,'Dally shift','2022-09-15','2022-09-15 11:11:12','2022-09-16 11:11:12','390',754929.50,754929.50,'390','2022-09-15 22:27:46','797','2022-09-16 09:35:49',10,0),('5','96',257899,'Dally shift','2022-09-16','2022-09-16 09:53:14','2022-09-17 09:53:14','390',933715.35,933715.35,'390','2022-09-16 22:32:50','797','2022-09-17 07:56:41',10,0),('5','96',257900,'Dally shift','2022-09-17','2022-09-17 10:11:39','2022-09-18 10:11:39','390',1149621.45,1149621.45,'390','2022-09-17 21:43:20','797','2022-09-18 10:39:34',10,0),('5','96',257901,'Dally shift','2022-09-18','2022-09-18 12:13:11','2022-09-19 12:13:11','390',962316.35,962316.35,'390','2022-09-18 22:46:55','797','2022-09-19 10:44:33',10,0),('5','96',257902,'Dally shift','2022-09-19','2022-09-19 16:11:39','2022-09-20 16:11:39','390',1025904.55,1025904.55,'390','2022-09-19 22:32:17','797','2022-09-20 09:00:16',10,0),('5','96',257903,'Dally shift','2022-09-20','2022-09-20 10:15:06','2022-09-21 10:15:06','390',962055.50,962055.50,'390','2022-09-20 22:05:03','797','2022-09-21 07:09:52',10,0),('5','96',257904,'Dally shift','2022-09-21','2022-09-21 10:40:59','2022-09-22 10:40:59','390',888136.90,888136.90,'390','2022-09-21 23:48:46','797','2022-09-22 09:16:23',10,0),('5','96',257905,'Dally shift','2022-09-22','2022-09-22 09:45:40','2022-09-23 09:45:40','390',1048720.60,1048720.60,'390','2022-09-22 22:57:54','797','2022-09-23 10:19:42',10,0),('5','96',257906,'Dally shift','2022-09-23','2022-09-23 12:06:31','2022-09-24 12:06:31','390',929599.10,929599.10,'390','2022-09-23 20:17:13','797','2022-09-24 08:51:22',10,0),('5','96',257907,'Dally shift','2022-09-24','2022-09-24 11:45:21','2022-09-25 11:45:21','390',935287.85,935287.85,'390','2022-09-24 23:04:46','797','2022-09-25 07:04:01',10,0),('5','96',257908,'Dally shift','2022-09-25','2022-09-25 12:09:57','2022-09-26 12:09:57','390',571918.25,571918.25,'390','2022-09-25 23:12:23','797','2022-09-26 10:05:44',10,0),('5','96',257909,'Dally shift','2022-09-26','2022-09-26 11:09:45','2022-09-27 11:09:45','390',1228333.40,1228333.40,'390','2022-09-26 23:10:27','797','2022-09-27 08:10:40',10,0),('5','96',257910,'Dally shift','2022-09-27','2022-09-27 10:41:19','2022-09-28 10:41:19','390',871849.50,871849.50,'390','2022-09-28 00:45:47','797','2022-09-28 06:41:01',10,0),('5','96',257911,'Dally shift','2022-09-28','2022-09-28 10:02:38','2022-09-29 10:02:38','390',812111.15,812111.15,'390','2022-09-28 23:36:12','797','2022-09-29 07:13:55',10,0),('5','96',257912,'Dally shift','2022-09-29','2022-09-29 22:12:47','2022-09-30 22:12:47','390',1203589.65,1203589.65,'390','2022-09-29 22:15:56','797','2022-09-30 07:23:16',10,0),('5','96',257913,'Dally shift','2022-09-30','2022-09-30 10:32:37','2022-10-01 10:32:37','390',1299051.50,1299051.50,'390','2022-09-30 23:45:29','797','2022-10-01 07:33:34',10,0),('5','96',257914,'Dally shift','2022-10-01','2022-10-01 23:11:56','2022-10-02 23:11:56','390',1310478.95,1310478.95,'390','2022-10-01 23:23:23','797','2022-10-02 06:58:01',10,0),('5','96',257915,'Dally shift','2022-10-02','2022-10-02 18:12:46','2022-10-03 18:12:46','390',1166338.05,1166338.05,'390','2022-10-03 04:25:34','797','2022-10-03 09:47:48',10,0),('5','96',257916,'Dally shift','2022-10-03','2022-10-03 23:41:40','2022-10-04 23:41:40','390',1330577.35,1330577.35,'390','2022-10-03 23:48:57','797','2022-10-04 07:12:36',10,0),('5','96',257917,'Dally shift','2022-10-04','2022-10-04 10:47:52','2022-10-05 10:47:52','390',1254140.90,1254140.90,'390','2022-10-04 23:06:17','797','2022-10-05 10:05:19',10,0),('5','96',257918,'Dally shift','2022-10-05','2022-10-05 12:46:05','2022-10-06 12:46:05','390',1304651.45,1304651.45,'390','2022-10-05 23:43:04','797','2022-10-06 06:58:09',10,0),('5','96',257919,'Dally shift','2022-10-06','2022-10-06 11:22:28','2022-10-07 11:22:28','390',1370435.60,1370435.60,'390','2022-10-06 23:17:59','797','2022-10-07 06:57:40',10,0),('5','96',257920,'Dally shift','2022-10-07','2022-10-07 11:16:23','2022-10-08 11:16:23','390',463987.40,463987.40,'390','2022-10-07 23:44:13','797','2022-10-08 11:35:50',10,0),('5','96',257921,'Dally shift','2022-10-08','2022-10-08 22:38:33','2022-10-09 22:38:33','390',0.00,0.00,'390','2022-10-08 22:39:22','797','2022-10-09 07:01:46',10,0),('5','96',257922,'Dally shift','2022-10-09','2022-10-09 10:55:31','2022-10-10 10:55:31','390',0.00,0.00,'390','2022-10-09 22:38:54','797','2022-10-10 08:58:24',10,0),('5','96',257923,'Dally shift','2022-10-10','2022-10-10 19:24:59','2022-10-11 19:24:59','390',0.00,0.00,'390','2022-10-10 19:25:56','797','2022-10-11 12:14:35',10,0),('5','96',257924,'Dally shift','2022-10-11','2022-10-11 22:47:41','2022-10-12 22:47:41','390',0.00,0.00,'390','2022-10-11 22:48:23','797','2022-10-12 12:30:47',10,0),('5','96',257925,'Dally shift','2022-10-12','2022-10-12 22:41:00','2022-10-13 22:41:00','390',0.00,0.00,'390','2022-10-12 22:41:39','797','2022-10-13 04:23:51',10,0),('5','96',257926,'Dally shift','2022-10-13','2022-10-13 11:55:50','2022-10-14 11:55:50','390',0.00,0.00,'390','2022-10-13 19:41:40','797','2022-10-14 10:20:58',10,0),('5','96',257927,'Dally shift','2022-10-14','2022-10-14 15:18:06','2022-10-15 15:18:06','390',0.00,0.00,'390','2022-10-14 19:50:28','797','2022-10-15 14:09:27',10,0),('5','96',257928,'Dally shift','2022-10-15','2022-10-15 19:04:32','2022-10-16 19:04:32','390',0.00,0.00,'390','2022-10-15 19:05:15','797','2022-10-16 07:01:05',10,0),('5','96',257929,'Dally shift','2022-10-16','2022-10-16 20:55:14','2022-10-17 20:55:14','390',0.00,0.00,'390','2022-10-16 20:55:54','797','2022-10-17 20:09:13',10,0),('5','96',257930,'Dally shift','2022-10-17','2022-10-17 22:07:54','2022-10-18 22:07:54','390',0.00,0.00,'390','2022-10-17 22:08:24','797','2022-10-18 09:37:47',10,0),('5','96',257931,'Dally shift','2022-10-18','2022-10-18 10:54:12','2022-10-19 10:54:12','390',0.00,0.00,'390','2022-10-18 21:34:29','797','2022-10-19 09:46:01',10,0),('5','96',257932,'Dally shift','2022-10-19','2022-10-19 10:38:56','2022-10-20 10:38:56','390',0.00,0.00,'390','2022-10-19 22:27:45','797','2022-10-20 09:02:03',10,0),('5','96',257933,'Dally shift','2022-10-20','2022-10-20 13:23:50','2022-10-21 13:23:50','390',0.00,0.00,'390','2022-10-20 20:54:42','797','2022-10-21 09:33:24',10,0),('5','96',257934,'Dally shift','2022-10-21','2022-10-21 23:13:14','2022-10-22 23:13:14','390',0.00,0.00,'390','2022-10-21 23:13:48','797','2022-10-22 10:05:23',10,0),('5','96',257935,'Dally shift','2022-10-22','2022-10-22 22:52:45','2022-10-23 22:52:45','390',0.00,0.00,'390','2022-10-22 22:53:25','797','2022-10-23 07:41:36',10,0),('5','96',257936,'Dally shift','2022-10-23','2022-10-23 12:18:49','2022-10-24 12:18:49','390',0.00,0.00,'390','2022-10-23 22:11:01','797','2022-10-24 07:32:19',10,0),('5','96',257937,'Dally shift','2022-10-24','2022-10-24 22:46:22','2022-10-25 22:46:22','390',0.00,0.00,'390','2022-10-24 22:47:04','797','2022-10-25 09:25:54',10,0),('5','96',257938,'Dally shift','2022-10-25','2022-10-26 00:12:25','2022-10-27 00:12:25','390',0.00,0.00,'390','2022-10-26 00:13:18','797','2022-10-26 06:08:57',10,0),('5','96',257939,'Dally shift','2022-10-26','2022-10-26 22:51:40','2022-10-27 22:51:40','390',0.00,0.00,'390','2022-10-26 22:52:16','797','2022-10-27 07:02:45',10,0),('5','96',257940,'Dally shift','2022-10-27','2022-10-27 23:40:14','2022-10-28 23:40:14','390',0.00,0.00,'390','2022-10-27 23:40:50','797','2022-10-28 06:55:18',10,0),('5','96',257941,'Dally shift','2022-10-28','2022-10-28 10:53:06','2022-10-29 10:53:06','390',1247438.35,1247438.35,'390','2022-10-28 22:25:48','797','2022-10-29 08:38:38',10,0),('5','96',257942,'Dally shift','2022-10-29','2022-10-29 11:46:45','2022-10-30 11:46:45','390',1206257.35,1206257.35,'390','2022-10-29 23:09:16','797','2022-10-30 06:57:21',10,0),('5','96',257943,'Dally shift','2022-10-30','2022-10-30 09:38:17','2022-10-31 09:38:17','390',1187256.00,1187256.00,'390','2022-10-30 23:34:02','797','2022-10-31 07:04:09',10,0),('5','96',257944,'Dally shift','2022-10-31','2022-10-31 08:05:08','2022-11-01 08:05:08','390',1943848.65,1943848.65,'390','2022-11-01 05:51:58','797','2022-11-01 07:04:43',10,0),('5','96',257945,'Dally shift','2022-11-01','2022-11-01 16:18:52','2022-11-02 16:18:52','390',1997964.85,1997964.85,'390','2022-11-01 22:57:24','797','2022-11-02 07:07:20',10,0),('5','96',257946,'Dally shift','2022-11-02','2022-11-02 08:53:26','2022-11-03 08:53:26','390',1651030.65,1651030.65,'390','2022-11-03 08:45:12','797','2022-11-03 09:15:25',10,0),('5','96',257947,'Dally shift','2022-11-03','2022-11-03 10:36:35','2022-11-04 10:36:35','390',1141209.50,1141209.50,'390','2022-11-03 22:50:07','797','2022-11-04 07:02:46',10,0),('5','96',257948,'Dally shift','2022-11-04','2022-11-04 23:39:32','2022-11-05 23:39:32','390',1140732.20,1140732.20,'390','2022-11-04 23:41:53','797','2022-11-05 07:25:49',10,0),('5','96',257949,'Dally shift','2022-11-05','2022-11-05 23:22:57','2022-11-06 23:22:57','390',1025693.65,1025693.65,'390','2022-11-05 23:24:07','797','2022-11-06 08:19:08',10,0),('5','96',257950,'Dally shift','2022-11-06','2022-11-06 11:39:53','2022-11-07 11:39:53','390',1224045.10,1224045.10,'390','2022-11-06 20:46:53','797','2022-11-07 14:42:06',10,0),('5','96',257951,'Dally shift','2022-11-07','2022-11-07 16:16:03','2022-11-08 16:16:03','390',1039592.70,1039592.70,'390','2022-11-07 22:38:39','797','2022-11-08 07:48:56',10,0),('5','96',257952,'Dally shift','2022-11-08','2022-11-08 10:15:46','2022-11-09 10:15:46','390',682526.05,682526.05,'390','2022-11-09 04:10:52','797','2022-11-09 08:37:24',10,0),('5','96',257953,'Dally shift','2022-11-09','2022-11-09 13:35:01','2022-11-10 13:35:01','390',0.00,0.00,'390','2022-11-09 21:46:47','797','2022-11-10 10:46:01',10,0),('5','96',257954,'Dally shift','2022-11-10','2022-11-10 23:55:46','2022-11-11 23:55:46','390',0.00,0.00,'390','2022-11-10 23:56:25','797','2022-11-11 11:28:08',10,0),('5','96',257955,'Dally shift','2022-11-11','2022-11-11 22:32:51','2022-11-12 22:32:51','390',0.00,0.00,'390','2022-11-11 22:33:25','797','2022-11-12 10:05:21',10,0),('5','96',257956,'Dally shift','2022-11-12','2022-11-12 11:34:53','2022-11-13 11:34:53','390',0.00,0.00,'390','2022-11-12 22:29:06','797','2022-11-12 23:51:10',10,0),('5','96',257957,'Dally shift','2022-11-13','2022-11-13 10:40:14','2022-11-14 10:40:14','390',0.00,0.00,'390','2022-11-13 21:52:06','797','2022-11-14 07:23:10',10,0),('5','96',257958,'Dally shift','2022-11-14','2022-11-14 16:32:45','2022-11-15 16:32:45','390',0.00,0.00,'390','2022-11-14 21:04:30','797','2022-11-14 23:44:19',10,0),('5','96',257959,'Dally shift','2022-11-15','2022-11-15 21:01:15','2022-11-16 21:01:15','390',0.00,0.00,'390','2022-11-15 21:02:09','797','2022-11-16 07:52:55',10,0),('5','96',257960,'Dally shift','2022-11-16','2022-11-16 20:01:13','2022-11-17 20:01:13','390',0.00,0.00,'390','2022-11-16 20:01:53','797','2022-11-17 09:37:23',10,0),('5','96',257961,'Dally shift','2022-11-17','2022-11-17 22:32:56','2022-11-18 22:32:56','390',0.00,0.00,'390','2022-11-17 22:33:45','797','2022-11-18 08:21:40',10,0),('5','96',257962,'Dally shift','2022-11-18','2022-11-18 10:25:04','2022-11-19 10:25:04','390',0.00,0.00,'390','2022-11-19 07:20:22','797','2022-11-19 09:17:13',10,0),('5','96',257963,'Dally shift','2022-11-19','2022-11-19 23:10:51','2022-11-20 23:10:51','390',0.00,0.00,'390','2022-11-19 23:11:29','797','2022-11-20 07:29:47',10,0),('5','96',257964,'Dally shift','2022-11-20','2022-11-21 07:38:54','2022-11-22 07:38:54','390',0.00,0.00,'390','2022-11-21 07:39:33','797','2022-11-21 09:37:22',10,0),('5','96',257965,'Dally shift','2022-11-21','2022-11-21 19:52:40','2022-11-22 19:52:40','390',0.00,0.00,'390','2022-11-21 19:59:17','797','2022-11-22 09:03:18',10,0),('5','96',257966,'Dally shift','2022-11-22','2022-11-22 22:09:56','2022-11-23 22:09:56','390',0.00,0.00,'390','2022-11-22 22:12:21','797','2022-11-23 09:39:09',10,0),('5','96',257967,'Dally shift','2022-11-23','2022-11-23 18:52:53','2022-11-24 18:52:53','390',0.00,0.00,'390','2022-11-23 18:58:32','797','2022-11-24 09:01:14',10,0),('5','96',257968,'Dally shift','2022-11-24','2022-11-24 12:10:02','2022-11-25 12:10:02','390',0.00,0.00,'390','2022-11-24 22:36:22','797','2022-11-25 11:14:01',10,0),('5','96',257969,'Dally shift','2022-11-25','2022-11-25 12:06:31','2022-11-26 12:06:31','390',0.00,0.00,'390','2022-11-25 22:54:43','797','2022-11-26 07:46:26',10,0),('5','96',257970,'Dally shift','2022-11-26','2022-11-26 10:39:36','2022-11-27 10:39:36','390',0.00,0.00,'390','2022-11-26 19:22:21','797','2022-11-27 08:59:51',10,0),('5','96',257971,'Dally shift','2022-11-27','2022-11-27 16:56:59','2022-11-28 16:56:59','390',0.00,0.00,'390','2022-11-27 22:24:37','797','2022-11-28 09:47:25',10,0),('5','96',257972,'Dally shift','2022-11-28','2022-11-28 10:40:46','2022-11-29 10:40:46','390',0.00,0.00,'390','2022-11-28 18:28:04','797','2022-11-29 09:45:30',10,0),('5','96',257973,'Dally shift','2022-11-29','2022-11-29 18:33:31','2022-11-30 18:33:31','390',0.00,0.00,'390','2022-11-29 18:34:06','797','2022-11-30 06:43:39',10,0),('5','96',257974,'Dally shift','2022-11-30','2022-11-30 11:59:44','2022-12-01 11:59:44','390',0.00,0.00,'390','2022-11-30 20:10:11','797','2022-12-01 10:44:04',10,0),('5','96',257975,'Dally shift','2022-12-01','2022-12-01 14:13:58','2022-12-02 14:13:58','390',0.00,0.00,'390','2022-12-01 23:02:47','797','2022-12-02 09:58:43',10,0),('5','96',257976,'Dally shift','2022-12-02','2022-12-02 23:52:36','2022-12-03 23:52:36','390',0.00,0.00,'390','2022-12-02 23:53:06','797','2022-12-03 10:11:47',10,0),('5','96',257977,'Dally shift','2022-12-03','2022-12-03 12:27:30','2022-12-04 12:27:30','390',670419.65,670419.65,'390','2022-12-04 01:09:57','797','2022-12-04 09:48:17',10,0),('5','96',257978,'Dally shift','2022-12-04','2022-12-04 11:29:16','2022-12-05 11:29:16','390',905047.75,905047.75,'390','2022-12-05 00:11:40','797','2022-12-05 09:01:39',10,0),('5','96',257979,'Dally shift','2022-12-05','2022-12-05 09:46:30','2022-12-06 09:46:30','390',1155929.95,1155929.95,'390','2022-12-05 22:56:17','797','2022-12-06 09:23:03',10,0),('5','96',257980,'Dally shift','2022-12-06','2022-12-06 09:48:06','2022-12-07 09:48:06','390',1048961.10,1048961.10,'390','2022-12-06 23:19:50','797','2022-12-07 09:10:21',10,0),('5','96',257981,'Dally shift','2022-12-07','2022-12-07 09:38:38','2022-12-08 09:38:38','390',1184769.60,1184769.60,'390','2022-12-07 22:17:14','797','2022-12-08 09:26:33',10,0),('5','96',257982,'Dally shift','2022-12-08','2022-12-08 11:18:28','2022-12-09 11:18:28','390',1091947.70,1091947.70,'390','2022-12-08 23:01:25','797','2022-12-09 09:16:25',10,0),('5','96',257983,'Dally shift','2022-12-09','2022-12-09 11:55:04','2022-12-10 11:55:04','390',968380.65,968380.65,'390','2022-12-09 23:45:12','797','2022-12-10 08:52:19',10,0),('5','96',257984,'Dally shift','2022-12-10','2022-12-10 20:01:40','2022-12-11 20:01:40','390',304846.70,304846.70,'390','2022-12-10 20:03:16','797','2022-12-11 12:26:45',10,0),('5','96',257985,'Dally shift','2022-12-11','2022-12-11 19:28:46','2022-12-12 19:28:46','390',0.00,0.00,'390','2022-12-11 19:38:56','797','2022-12-12 11:06:16',10,0),('5','96',257986,'Dally shift','2022-12-12','2022-12-12 15:57:02','2022-12-13 15:57:02','390',0.00,0.00,'390','2022-12-12 23:06:00','797','2022-12-13 09:54:31',10,0),('5','96',257987,'Dally shift','2022-12-13','2022-12-13 13:02:20','2022-12-14 13:02:20','390',0.00,0.00,'390','2022-12-13 20:49:08','797','2022-12-14 09:39:37',10,0),('5','96',257988,'Dally shift','2022-12-14','2022-12-14 12:13:03','2022-12-15 12:13:03','390',0.00,0.00,'390','2022-12-14 22:41:23','797','2022-12-15 09:51:08',10,0),('5','96',257989,'Dally shift','2022-12-15','2022-12-15 10:49:53','2022-12-16 10:49:53','390',0.00,0.00,'390','2022-12-15 20:39:10','797','2022-12-16 09:59:59',10,0),('5','96',257990,'Dally shift','2022-12-16','2022-12-16 11:24:17','2022-12-17 11:24:17','390',0.00,0.00,'390','2022-12-16 21:07:09','797','2022-12-17 12:18:33',10,0),('5','96',257991,'Dally shift','2022-12-17','2022-12-17 18:33:51','2022-12-18 18:33:51','390',0.00,0.00,'390','2022-12-17 18:34:31','797','2022-12-18 12:33:47',10,0),('5','96',257992,'Dally shift','2022-12-18','2022-12-18 22:25:54','2022-12-19 22:25:54','390',0.00,0.00,'390','2022-12-18 22:26:38','797','2022-12-19 08:58:22',10,0),('5','96',257993,'Dally shift','2022-12-19','2022-12-19 10:30:13','2022-12-20 10:30:13','390',0.00,0.00,'390','2022-12-19 20:37:32','797','2022-12-20 09:02:20',10,0),('5','96',257994,'Dally shift','2022-12-20','2022-12-20 18:55:55','2022-12-21 18:55:55','390',0.00,0.00,'390','2022-12-20 18:56:32','797','2022-12-21 09:19:10',10,0),('5','96',257995,'Dally shift','2022-12-21','2022-12-21 10:04:50','2022-12-22 10:04:50','390',0.00,0.00,'390','2022-12-21 22:18:57','797','2022-12-22 09:29:01',10,0),('5','96',257996,'Dally shift','2022-12-22','2022-12-22 09:31:24','2022-12-23 09:31:24','390',0.00,0.00,'390','2022-12-22 20:16:22','797','2022-12-23 10:47:11',10,0),('5','96',257997,'Dally shift','2022-12-23','2022-12-23 14:21:36','2022-12-24 14:21:36','390',0.00,0.00,'390','2022-12-23 22:42:26','797','2022-12-24 19:16:46',10,0),('5','96',257998,'Dally shift','2022-12-24','2022-12-24 22:54:11','2022-12-25 22:54:11','390',0.00,0.00,'390','2022-12-24 22:55:16','797','2022-12-25 07:20:43',10,0),('5','96',257999,'Dally shift','2022-12-25','2022-12-25 11:14:58','2022-12-26 11:14:58','390',0.00,0.00,'390','2022-12-25 19:09:24','797','2022-12-26 08:25:07',10,0),('5','96',258000,'Dally shift','2022-12-26','2022-12-26 11:03:35','2022-12-27 11:03:35','390',0.00,0.00,'390','2022-12-26 21:31:06','797','2022-12-27 10:50:27',10,0),('5','96',258001,'Dally shift','2022-12-27','2022-12-27 14:16:22','2022-12-28 14:16:22','390',0.00,0.00,'390','2022-12-27 18:47:38','797','2022-12-28 09:14:37',10,0),('5','96',258002,'Dally shift','2022-12-28','2022-12-28 13:58:52','2022-12-29 13:58:52','390',0.00,0.00,'390','2022-12-28 22:30:46','797','2022-12-29 10:18:42',10,0),('5','96',258003,'Dally shift','2022-12-29','2022-12-29 11:23:26','2022-12-30 11:23:26','390',0.00,0.00,'390','2022-12-29 22:59:02','797','2022-12-30 09:02:12',10,0),('5','96',258004,'Dally shift','2022-12-30','2022-12-30 09:49:16','2022-12-31 09:49:16','390',0.00,0.00,'390','2022-12-30 21:56:49','797','2022-12-31 07:07:01',10,0),('5','96',258005,'Dally shift','2022-12-31','2022-12-31 13:16:50','2023-01-01 13:16:50','390',0.00,0.00,'390','2022-12-31 21:20:52','797','2023-01-01 08:53:24',10,0),('5','96',258006,'Dally shift','2023-01-01','2023-01-01 09:18:07','2023-01-02 09:18:07','390',0.00,0.00,'390','2023-01-01 22:37:47','797','2023-01-02 08:21:56',10,0),('5','96',258007,'Dally shift','2023-01-02','2023-01-02 11:09:38','2023-01-03 11:09:38','390',0.00,0.00,'390','2023-01-02 21:06:08','797','2023-01-03 10:34:49',10,0),('5','96',258008,'Dally shift','2023-01-03','2023-01-03 10:46:26','2023-01-04 10:46:26','390',0.00,0.00,'390','2023-01-03 21:16:32','797','2023-01-04 11:25:30',10,0),('5','96',258009,'Dally shift','2023-01-04','2023-01-04 11:33:32','2023-01-05 11:33:32','390',0.00,0.00,'390','2023-01-04 22:44:50','797','2023-01-05 08:57:32',10,0),('5','96',258010,'Dally shift','2023-01-05','2023-01-05 12:03:09','2023-01-06 12:03:09','390',0.00,0.00,'390','2023-01-05 23:50:36','797','2023-01-06 15:05:39',10,0),('5','96',258011,'Dally shift','2023-01-06','2023-01-06 20:45:15','2023-01-07 20:45:15','390',0.00,0.00,'390','2023-01-06 20:45:48','797','2023-01-07 05:45:56',10,0),('5','96',258012,'Dally shift','2023-01-07','2023-01-07 21:36:14','2023-01-08 21:36:14','390',0.00,0.00,'390','2023-01-07 21:37:18','797','2023-01-08 09:46:24',10,0),('5','96',258013,'Dally shift','2023-01-08','2023-01-08 12:34:01','2023-01-09 12:34:01','390',0.00,0.00,'390','2023-01-08 22:45:09','797','2023-01-09 09:48:01',10,0),('5','96',258014,'Dally shift','2023-01-09','2023-01-09 10:53:47','2023-01-10 10:53:47','390',0.00,0.00,'390','2023-01-09 19:54:12','797','2023-01-10 09:21:19',10,0),('5','96',258015,'Dally shift','2023-01-10','2023-01-10 10:28:07','2023-01-11 10:28:07','390',0.00,0.00,'390','2023-01-10 23:25:11','797','2023-01-11 09:45:04',10,0),('5','96',258016,'Dally shift','2023-01-11','2023-01-11 10:49:30','2023-01-12 10:49:30','390',0.00,0.00,'390','2023-01-11 22:21:00','797','2023-01-12 09:32:47',10,0),('5','96',258017,'Dally shift','2023-01-12','2023-01-12 12:22:50','2023-01-13 12:22:50','390',0.00,0.00,'390','2023-01-12 21:24:47','797','2023-01-13 09:22:54',10,0),('5','96',258018,'Dally shift','2023-01-13','2023-01-13 11:33:55','2023-01-14 11:33:55','390',0.00,0.00,'390','2023-01-13 21:09:16','797','2023-01-14 16:55:41',10,0),('5','96',258019,'Dally shift','2023-01-14','2023-01-14 17:50:14','2023-01-15 17:50:14','390',0.00,0.00,'390','2023-01-14 23:22:17','797','2023-01-15 07:57:36',10,0),('5','96',258020,'Dally shift','2023-01-15','2023-01-15 19:13:47','2023-01-16 19:13:47','390',0.00,0.00,'390','2023-01-15 19:14:22','797','2023-01-16 10:13:57',10,0),('5','96',258021,'Dally shift','2023-01-16','2023-01-16 10:39:12','2023-01-17 10:39:12','390',0.00,0.00,'390','2023-01-16 21:59:50','797','2023-01-17 10:16:09',10,0),('5','96',258022,'Dally shift','2023-01-17','2023-01-17 12:25:57','2023-01-18 12:25:57','390',0.00,0.00,'390','2023-01-17 23:06:54','797','2023-01-18 09:17:13',10,0),('5','96',258023,'Dally shift','2023-01-18','2023-01-18 09:19:01','2023-01-19 09:19:01','390',0.00,0.00,'390','2023-01-18 21:37:57','797','2023-01-19 09:20:57',10,0),('5','96',258024,'Dally shift','2023-01-19','2023-01-19 09:42:07','2023-01-20 09:42:07','390',0.00,0.00,'390','2023-01-19 22:57:19','797','2023-01-20 09:27:23',10,0),('5','96',258025,'Dally shift','2023-01-20','2023-01-20 12:58:56','2023-01-21 12:58:56','390',0.00,0.00,'390','2023-01-20 23:19:25','797','2023-01-21 06:54:25',10,0),('5','96',258026,'Dally shift','2023-01-21','2023-01-21 12:14:08','2023-01-22 12:14:08','390',0.00,0.00,'390','2023-01-21 19:48:03','797','2023-01-22 10:45:36',10,0),('5','96',258027,'Dally shift','2023-01-22','2023-01-22 11:52:48','2023-01-23 11:52:48','390',0.00,0.00,'390','2023-01-22 21:12:19','797','2023-01-23 09:08:34',10,0),('5','96',258028,'Dally shift','2023-01-23','2023-01-23 11:49:45','2023-01-24 11:49:45','390',0.00,0.00,'390','2023-01-23 23:36:11','797','2023-01-24 07:24:04',10,0),('5','96',258029,'Dally shift','2023-01-24','2023-01-24 09:27:07','2023-01-25 09:27:07','390',0.00,0.00,'390','2023-01-24 21:39:15','797','2023-01-25 09:33:08',10,0),('5','96',258030,'Dally shift','2023-01-25','2023-01-25 11:24:51','2023-01-26 11:24:51','390',0.00,0.00,'390','2023-01-25 22:58:50','797','2023-01-26 09:23:45',10,0),('5','96',258031,'Dally shift','2023-01-26','2023-01-26 09:49:00','2023-01-27 09:49:00','390',0.00,0.00,'390','2023-01-26 22:30:50','797','2023-01-27 09:45:41',10,0),('5','96',258032,'Dally shift','2023-01-27','2023-01-27 18:53:20','2023-01-28 18:53:20','390',0.00,0.00,'390','2023-01-27 18:54:00','797','2023-01-28 09:47:20',10,0),('5','96',258033,'Dally shift','2023-01-28','2023-01-28 14:09:09','2023-01-29 14:09:09','390',0.00,0.00,'390','2023-01-28 23:14:48','797','2023-01-29 11:04:02',10,0),('5','96',258034,'Dally shift','2023-01-29','2023-01-29 11:09:26','2023-01-30 11:09:26','390',0.00,0.00,'390','2023-01-29 21:14:27','797','2023-01-30 09:24:15',10,0),('5','96',258035,'Dally shift','2023-01-30','2023-01-30 09:52:19','2023-01-31 09:52:19','390',0.00,0.00,'390','2023-01-30 20:49:57','797','2023-01-31 09:09:51',10,0),('5','96',258036,'Dally shift','2023-01-31','2023-01-31 09:36:29','2023-02-01 09:36:29','390',0.00,0.00,'390','2023-02-01 00:05:21','797','2023-02-01 13:54:58',10,0),('5','96',258037,'Dally shift','2023-02-01','2023-02-02 00:31:48','2023-02-03 00:31:48','390',0.00,0.00,'390','2023-02-02 00:32:34','797','2023-02-02 11:31:58',10,0),('5','96',258038,'Dally shift','2023-02-02','2023-02-02 12:04:19','2023-02-03 12:04:19','390',0.00,0.00,'390','2023-02-02 22:01:43','797','2023-02-03 10:03:37',10,0),('5','96',258039,'Dally shift','2023-02-03','2023-02-03 11:15:19','2023-02-04 11:15:19','390',0.00,0.00,'390','2023-02-03 21:35:41','797','2023-02-04 13:21:18',10,0),('5','96',258040,'Dally shift','2023-02-04','2023-02-04 22:00:31','2023-02-05 22:00:31','390',0.00,0.00,'390','2023-02-04 22:02:35','797','2023-02-05 11:52:28',10,0),('5','96',258041,'Dally shift','2023-02-05','2023-02-05 12:38:48','2023-02-06 12:38:48','390',0.00,0.00,'390','2023-02-05 23:42:04','797','2023-02-06 09:09:16',10,0),('5','96',258042,'Dally shift','2023-02-06','2023-02-06 10:38:43','2023-02-07 10:38:43','390',0.00,0.00,'390','2023-02-06 21:56:17','797','2023-02-07 09:10:07',10,0),('5','96',258043,'Dally shift','2023-02-07','2023-02-07 11:57:04','2023-02-08 11:57:04','390',0.00,0.00,'390','2023-02-07 22:59:27','797','2023-02-08 09:25:56',10,0),('5','96',258044,'Dally shift','2023-02-08','2023-02-08 12:34:30','2023-02-09 12:34:30','390',0.00,0.00,'390','2023-02-08 20:57:36','797','2023-02-09 09:25:45',10,0),('5','96',258045,'Dally shift','2023-02-09','2023-02-09 11:20:03','2023-02-10 11:20:03','390',0.00,0.00,'390','2023-02-09 22:44:09','797','2023-02-10 09:04:13',10,0),('5','96',258046,'Dally shift','2023-02-10','2023-02-10 11:25:00','2023-02-11 11:25:00','390',0.00,0.00,'390','2023-02-10 23:07:54','797','2023-02-11 09:43:08',10,0),('5','96',258047,'Dally shift','2023-02-11','2023-02-11 19:18:50','2023-02-12 19:18:50','390',0.00,0.00,'390','2023-02-11 21:58:58','797','2023-02-12 07:38:22',10,0),('5','96',258048,'Dally shift','2023-02-12','2023-02-12 23:48:29','2023-02-13 23:48:29','390',0.00,0.00,'390','2023-02-12 23:49:18','797','2023-02-13 09:14:48',10,0),('5','96',258049,'Dally shift','2023-02-13','2023-02-13 12:53:07','2023-02-14 12:53:07','390',0.00,0.00,'390','2023-02-13 19:31:00','797','2023-02-14 09:37:53',10,0),('5','96',258050,'Dally shift','2023-02-14','2023-02-14 12:47:56','2023-02-15 12:47:56','390',0.00,0.00,'390','2023-02-14 22:32:44','797','2023-02-15 09:25:43',10,0),('5','96',258051,'Dally shift','2023-02-15','2023-02-15 12:16:51','2023-02-16 12:16:51','390',0.00,0.00,'390','2023-02-15 21:58:10','797','2023-02-16 08:48:42',10,0),('5','96',258052,'Dally shift','2023-02-16','2023-02-16 12:44:17','2023-02-17 12:44:17','390',0.00,0.00,'390','2023-02-16 22:00:25','797','2023-02-17 12:23:15',10,0),('5','96',258053,'Dally shift','2023-02-17','2023-02-17 12:45:31','2023-02-18 12:45:31','390',0.00,0.00,'390','2023-02-17 22:30:06','797','2023-02-18 16:31:37',10,0),('5','96',258054,'Dally shift','2023-02-18','2023-02-18 20:36:38','2023-02-19 20:36:38','390',0.00,0.00,'390','2023-02-18 20:37:16','797','2023-02-19 08:34:38',10,0),('5','96',258055,'Dally shift','2023-02-19','2023-02-19 21:24:22','2023-02-20 21:24:22','390',0.00,0.00,'390','2023-02-19 21:24:57','797','2023-02-20 09:20:21',10,0),('5','96',258056,'Dally shift','2023-02-20','2023-02-20 10:48:27','2023-02-21 10:48:27','390',0.00,0.00,'390','2023-02-20 19:22:27','797','2023-02-21 08:53:59',10,0),('5','96',258057,'Dally shift','2023-02-21','2023-02-21 11:37:09','2023-02-22 11:37:09','390',0.00,0.00,'390','2023-02-21 19:19:27','797','2023-02-22 09:51:15',10,0),('5','96',258058,'Dally shift','2023-02-22','2023-02-22 19:36:30','2023-02-23 19:36:30','390',0.00,0.00,'390','2023-02-22 19:36:58','797','2023-02-23 07:01:14',10,0),('5','96',258059,'Dally shift','2023-02-23','2023-02-23 13:29:33','2023-02-24 13:29:33','390',0.00,0.00,'390','2023-02-23 22:47:50','797','2023-02-24 18:53:54',10,0),('5','96',258060,'Dally shift','2023-02-24','2023-02-24 18:55:30','2023-02-25 18:55:30','390',0.00,0.00,'390','2023-02-24 18:56:01','797','2023-02-25 10:28:20',10,0),('5','96',258061,'Dally shift','2023-02-25','2023-02-25 12:07:44','2023-02-26 12:07:44','390',0.00,0.00,'390','2023-02-26 10:43:45','797','2023-02-26 11:14:00',10,0),('5','96',258062,'Dally shift','2023-02-26','2023-02-26 12:06:11','2023-02-27 12:06:11','390',1309652.40,1309652.40,'390','2023-02-26 22:16:38','797','2023-02-27 15:40:42',10,0),('5','96',258063,'Dally shift','2023-02-27','2023-02-27 22:55:00','2023-02-28 22:55:00','390',1143460.50,1143460.50,'390','2023-02-27 22:56:46','797','2023-02-28 10:23:17',10,0),('5','96',258064,'Dally shift','2023-02-28','2023-02-28 11:55:52','2023-03-01 11:55:52','390',1442767.20,1442767.20,'390','2023-02-28 23:09:12','797','2023-03-01 09:35:17',10,0),('5','96',258065,'Dally shift','2023-03-01','2023-03-01 16:19:18','2023-03-02 16:19:18','390',1204975.80,1204975.80,'390','2023-03-01 23:37:35','797','2023-03-02 10:09:13',10,0),('5','96',258066,'Dally shift','2023-03-02','2023-03-02 10:48:15','2023-03-03 10:48:15','390',2063798.10,2063798.10,'390','2023-03-03 06:52:38','797','2023-03-03 09:22:04',10,0),('5','96',258067,'Dally shift','2023-03-03','2023-03-03 22:40:31','2023-03-04 22:40:31','390',1819767.60,1819767.60,'390','2023-03-03 22:43:36','797','2023-03-04 08:47:47',10,0),('5','96',258068,'Dally shift','2023-03-04','2023-03-04 15:49:58','2023-03-05 15:49:58','390',2366784.00,2366784.00,'390','2023-03-05 09:18:59','797','2023-03-05 09:46:09',10,0),('5','96',258069,'Dally shift','2023-03-05','2023-03-05 11:41:41','2023-03-06 11:41:41','390',1875411.30,1875411.30,'390','2023-03-05 23:11:54','797','2023-03-06 09:01:52',10,0),('5','96',258070,'Dally shift','2023-03-06','2023-03-06 10:30:55','2023-03-07 10:30:55','390',1556102.10,1556102.10,'390','2023-03-07 07:09:51','797','2023-03-07 09:26:40',10,0),('5','96',258071,'Dally shift','2023-03-07','2023-03-07 10:07:13','2023-03-08 10:07:13','390',1323029.40,1323029.40,'390','2023-03-07 23:14:15','797','2023-03-08 09:52:24',10,0),('5','96',258072,'Dally shift','2023-03-08','2023-03-08 10:04:06','2023-03-09 10:04:06','390',2420686.80,2420686.80,'390','2023-03-09 07:21:06','797','2023-03-09 09:49:41',10,0),('5','96',258073,'Dally shift','2023-03-09','2023-03-10 05:06:20','2023-03-11 05:06:20','390',2255941.80,2255941.80,'390','2023-03-10 05:09:48','797','2023-03-10 09:18:38',10,0),('5','96',258074,'Dally shift','2023-03-10','2023-03-11 08:03:28','2023-03-12 08:03:28','390',2048281.20,2048281.20,'390','2023-03-11 08:10:49','797','2023-03-11 10:35:33',10,0),('5','96',258075,'Dally shift','2023-03-11','2023-03-11 14:41:34','2023-03-12 14:41:34','390',2062956.00,2062956.00,'390','2023-03-12 06:06:29','797','2023-03-12 09:00:13',10,0),('5','96',258076,'Dally shift','2023-03-12','2023-03-13 07:10:58','2023-03-14 07:10:58','390',1772519.70,1772519.70,'390','2023-03-13 07:18:58','797','2023-03-13 10:02:08',10,0),('5','96',258077,'Dally shift','2023-03-13','2023-03-13 16:40:33','2023-03-14 16:40:33','390',977930.10,977930.10,'390','2023-03-14 06:35:27','797','2023-03-14 08:31:06',10,0),('5','96',258078,'Dally shift','2023-03-14','2023-03-14 14:03:16','2023-03-15 14:03:16','390',1107304.80,1107304.80,'390','2023-03-14 23:09:52','797','2023-03-15 08:27:29',10,0),('5','96',258079,'Dally shift','2023-03-15','2023-03-15 11:57:22','2023-03-16 11:57:22','390',241380.30,241380.30,'390','2023-03-16 06:39:39','797','2023-03-16 09:34:04',10,0),('5','96',258080,'Dally shift','2023-03-16','2023-03-16 21:43:26','2023-03-17 21:43:26','390',0.00,0.00,'390','2023-03-16 21:44:31','797','2023-03-17 07:57:21',10,0),('5','96',258081,'Dally shift','2023-03-17','2023-03-17 10:33:29','2023-03-18 10:33:29','390',0.00,0.00,'390','2023-03-17 19:25:16','797','2023-03-18 11:03:05',10,0),('5','96',258082,'Dally shift','2023-03-18','2023-03-18 13:28:02','2023-03-19 13:28:02','390',0.00,0.00,'390','2023-03-18 22:13:03','797','2023-03-19 11:36:43',10,0),('5','96',258083,'Dally shift','2023-03-19','2023-03-19 21:33:54','2023-03-20 21:33:54','390',0.00,0.00,'390','2023-03-19 21:34:48','797','2023-03-20 12:21:41',10,0),('5','96',258084,'Dally shift','2023-03-20','2023-03-20 13:05:56','2023-03-21 13:05:56','390',0.00,0.00,'390','2023-03-20 19:22:59','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4910213 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','96','583','83353',1660511,'1640','222',393907.21,394614.22,707.01,98981.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','83353',1660512,'1641','222',741982.63,744867.02,2884.39,403814.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','83353',1660513,'1642','222',806359.17,810002.95,3643.78,510129.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','83353',1660514,'1643','222',796093.83,796780.11,686.28,96079.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','83353',1660515,'1644','222',614484.70,615450.55,965.85,135219.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','83353',1660516,'1645','222',659208.87,661314.57,2105.70,294798.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','83353',1660517,'1646','223',203989.92,204427.87,437.95,105108.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','83353',1660518,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','83355',1660536,'1640','222',394614.22,395290.87,676.65,94731.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83355',1660537,'1641','222',744867.02,746369.82,1502.80,210392.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83355',1660538,'1642','222',810002.95,811818.31,1815.36,254150.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','83355',1660539,'1643','222',796780.11,799397.14,2617.03,366384.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','83355',1660540,'1644','222',615450.55,616622.22,1171.67,164033.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','83355',1660541,'1645','222',661314.57,663444.12,2129.55,298137.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','83355',1660542,'1646','223',204427.87,204896.75,468.88,112531.20,0.00,0.00,0.00,0.00,0.00),('5','96','589','83355',1660543,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','83358',1660585,'1640','222',395290.87,397073.42,1782.55,249557.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83358',1660586,'1641','222',746369.82,749128.24,2758.42,386178.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','83358',1660587,'1642','222',811818.31,814554.01,2735.70,382998.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83358',1660588,'1643','222',799397.14,800484.21,1087.07,152189.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','83358',1660589,'1644','222',616622.22,616622.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','83358',1660590,'1645','222',663444.12,666322.79,2878.67,403013.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','83358',1660591,'1646','223',204896.75,205477.91,581.16,139478.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','83358',1660592,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','83363',1660649,'1640','222',397073.42,398403.27,1329.85,186179.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83363',1660650,'1641','222',749128.24,750546.72,1418.48,198587.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','83363',1660651,'1642','222',814554.01,817620.50,3066.49,429308.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','83363',1660652,'1643','222',800484.21,800484.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83363',1660653,'1644','222',616622.22,618269.93,1647.71,230679.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','83363',1660654,'1645','222',666322.79,669727.73,3404.94,476691.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','83363',1660655,'1646','223',205477.91,206213.43,735.52,176524.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','83363',1660656,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','83366',1660687,'1640','222',398403.27,400346.54,1943.27,272057.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','83366',1660688,'1641','222',750546.72,750546.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83366',1660689,'1642','222',817620.50,817620.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83366',1660690,'1643','222',800484.21,802988.66,2504.45,350623.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83366',1660691,'1644','222',618269.93,621743.30,3473.37,486271.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','83366',1660692,'1645','222',669727.73,672504.26,2776.53,388714.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','83366',1660693,'1646','223',206213.43,207263.82,1050.39,252093.60,0.00,0.00,0.00,0.00,0.00),('5','96','589','83366',1660694,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','83374',1660807,'1640','222',400346.54,403193.49,2846.95,398573.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83374',1660808,'1641','222',750546.72,750546.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83374',1660809,'1642','222',817620.50,817620.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83374',1660810,'1643','222',802988.66,806615.91,3627.25,507815.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83374',1660811,'1644','222',621743.30,623863.08,2119.78,296769.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','83374',1660812,'1645','222',672504.26,676746.24,4241.98,593877.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','83374',1660813,'1646','223',207263.82,207673.68,409.86,98366.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','83374',1660814,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','83435',1661985,'1640','222',403193.49,407519.62,4326.13,605658.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','83435',1661986,'1641','222',750546.72,750546.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83435',1661987,'1642','222',817620.50,817620.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83435',1661988,'1643','222',806615.91,810530.48,3914.57,548039.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','83435',1661989,'1644','222',623863.08,628331.53,4468.45,625583.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','83435',1661990,'1645','222',676746.24,680437.73,3691.49,516808.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','83435',1661991,'1646','223',207673.68,208257.55,583.87,140128.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','83435',1661992,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','83566',1664537,'1640','222',407519.62,408060.13,540.51,75671.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','83566',1664538,'1641','222',750546.72,750546.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83566',1664539,'1642','222',817620.50,817620.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83566',1664540,'1643','222',810530.48,810530.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83566',1664541,'1644','222',628331.53,629695.96,1364.43,191020.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','83566',1664542,'1645','222',680437.73,681313.60,875.87,122621.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','83566',1664543,'1646','223',208257.55,208375.90,118.35,28404.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','83566',1664544,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','83916',1671544,'1640','222',408060.13,408060.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83916',1671545,'1641','222',750546.72,750546.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','83916',1671546,'1642','222',817620.50,817620.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83916',1671547,'1643','222',810530.48,810530.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','83916',1671548,'1644','222',629695.96,629695.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','83916',1671549,'1645','222',681313.60,681313.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','83916',1671550,'1646','223',208375.90,208375.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','83916',1671551,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','84227',1677274,'1640','222',408060.13,408060.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','84227',1677275,'1641','222',750546.72,750546.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','84227',1677276,'1642','222',817620.50,817620.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','84227',1677277,'1643','222',810530.48,810530.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','84227',1677278,'1644','222',629695.96,629695.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','84227',1677279,'1645','222',681313.60,681313.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','84227',1677280,'1646','223',208375.90,208375.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','84227',1677281,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','84235',1677361,'1640','222',408060.13,411219.48,3159.35,442309.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','84235',1677362,'1641','222',750546.72,750546.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','84235',1677363,'1642','222',817620.50,817620.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','84235',1677364,'1643','222',810530.48,813021.01,2490.53,348674.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','84235',1677365,'1644','222',629695.96,633545.79,3849.83,538976.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','84235',1677366,'1645','222',681313.60,683940.33,2626.73,367742.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','84235',1677367,'1646','223',208375.90,208699.83,323.93,77743.20,0.00,0.00,0.00,0.00,0.00),('5','96','589','84235',1677368,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','84358',1679610,'1640','222',411219.48,414437.04,3217.56,450458.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','84358',1679611,'1641','222',750546.72,750546.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','84358',1679612,'1642','222',817620.50,817620.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','84358',1679613,'1643','222',813021.01,816312.23,3291.22,460770.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','84358',1679614,'1644','222',633545.79,637573.00,4027.21,563809.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','84358',1679615,'1645','222',683940.33,683940.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','84358',1679616,'1646','223',208699.83,209031.89,332.06,79694.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','84358',1679617,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','84362',1679661,'1640','222',414437.04,415420.73,983.69,137716.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','84362',1679662,'1641','222',750546.72,752208.29,1661.57,232619.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','84362',1679663,'1642','222',817620.50,818816.16,1195.66,167392.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','84362',1679664,'1643','222',816312.23,817769.54,1457.31,204023.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','84362',1679665,'1644','222',637573.00,640094.93,2521.93,353070.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','84362',1679666,'1645','222',683940.33,686732.74,2792.41,390937.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','84362',1679667,'1646','223',209031.89,209213.94,182.05,43692.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','84362',1679668,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','84962',1691265,'1640','222',415420.73,417142.74,1722.01,241081.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','84962',1691266,'1641','222',752208.29,753219.50,1011.21,141569.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','84962',1691267,'1642','222',818816.16,820520.66,1704.50,238630.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','84962',1691268,'1643','222',817769.54,821063.47,3293.93,461150.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','84962',1691269,'1644','222',640094.93,641790.77,1695.84,237417.60,0.00,0.00,0.00,0.00,0.00),('5','96','586','84962',1691270,'1645','222',686732.74,688366.88,1634.14,228779.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','84962',1691271,'1646','223',209213.94,209663.60,449.66,107918.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','84962',1691272,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','84964',1691283,'1640','222',417142.74,418335.56,1192.82,166994.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','84964',1691284,'1641','222',753219.50,754787.32,1567.82,219494.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','84964',1691285,'1642','222',820520.66,822478.18,1957.52,274052.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','84964',1691286,'1643','222',821063.47,822605.57,1542.10,215894.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','84964',1691287,'1644','222',641790.77,645809.10,4018.33,562566.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','84964',1691288,'1645','222',688366.88,688809.63,442.75,61985.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','84964',1691289,'1646','223',209663.60,210539.19,875.59,210141.60,0.00,0.00,0.00,0.00,0.00),('5','96','589','84964',1691290,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','102981',2043515,'1640','222',640811.39,641643.60,832.21,116509.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','102981',2043516,'1641','222',1031954.20,1034308.90,2354.70,329658.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','102981',2043517,'1642','222',1246074.27,1248859.74,2785.47,389965.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','102981',2043518,'1643','222',1114354.54,1114354.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','102981',2043519,'1644','222',771523.31,771523.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','102981',2043520,'1645','222',1025989.26,1028979.25,2989.99,418598.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','102981',2043521,'1646','223',290983.87,291472.06,488.19,109842.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','102981',2043522,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','102984',2043543,'1640','222',641643.60,642862.99,1219.39,170714.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','102984',2043544,'1641','222',1034308.90,1035913.49,1604.59,224642.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','102984',2043545,'1642','222',1248859.74,1251690.34,2830.60,396284.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','102984',2043546,'1643','222',1114354.54,1114728.92,374.38,52413.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','102984',2043547,'1644','222',771523.31,771523.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','102984',2043548,'1645','222',1028979.25,1029860.33,881.08,123351.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','102984',2043549,'1646','223',291472.06,291789.95,317.89,71525.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','102984',2043550,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','102985',2043551,'1640','222',642862.99,644237.59,1374.60,192444.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','102985',2043552,'1641','222',1035913.49,1037999.68,2086.19,292066.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','102985',2043553,'1642','222',1251690.34,1253913.79,2223.45,311283.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','102985',2043554,'1643','222',1114728.92,1116044.47,1315.55,184177.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','102985',2043555,'1644','222',771523.31,771523.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','102985',2043556,'1645','222',1029860.33,1031813.79,1953.46,273484.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','102985',2043557,'1646','223',291789.95,292358.95,569.00,128025.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','102985',2043558,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','102991',2043628,'1640','222',644237.59,645122.33,884.74,123863.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','102991',2043629,'1641','222',1037999.68,1039574.25,1574.57,220439.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','102991',2043630,'1642','222',1253913.79,1255681.94,1768.15,247541.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','102991',2043631,'1643','222',1116044.47,1116115.86,71.39,9994.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','102991',2043632,'1644','222',771523.31,771523.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','102991',2043633,'1645','222',1031813.79,1033488.76,1674.97,234495.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','102991',2043634,'1646','223',292358.95,292671.47,312.52,70317.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','102991',2043635,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','102993',2043652,'1640','222',645122.33,646586.55,1464.22,204990.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','102993',2043653,'1641','222',1039574.25,1041935.83,2361.58,330621.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','102993',2043654,'1642','222',1255681.94,1258424.52,2742.58,383961.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','102993',2043655,'1643','222',1116115.86,1116115.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','102993',2043656,'1644','222',771523.31,771523.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','102993',2043657,'1645','222',1033488.76,1036055.89,2567.13,359398.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','102993',2043658,'1646','223',292671.47,293147.09,475.62,107014.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','102993',2043659,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','103064',2045138,'1640','222',646586.55,650533.82,3947.27,552617.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','103064',2045139,'1641','222',1041935.83,1044919.78,2983.95,417753.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','103064',2045140,'1642','222',1258424.52,1261331.33,2906.81,406953.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','103064',2045141,'1643','222',1116115.86,1116115.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','103064',2045142,'1644','222',771523.31,771523.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','103064',2045143,'1645','222',1036055.89,1038573.77,2517.88,352503.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','103064',2045144,'1646','223',293147.09,293271.07,123.98,27895.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','103064',2045145,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','103304',2050098,'1640','222',650533.82,652351.66,1817.84,254497.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','103304',2050099,'1641','222',1044919.78,1047178.00,2258.22,316150.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','103304',2050100,'1642','222',1261331.33,1265528.31,4196.98,587577.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','103304',2050101,'1643','222',1116115.86,1116283.93,168.07,23529.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','103304',2050102,'1644','222',771523.31,771523.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','103304',2050103,'1645','222',1038573.77,1038573.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','103304',2050104,'1646','223',293271.07,293271.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','103304',2050105,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','103307',2050190,'1640','222',652351.66,654766.98,2415.32,338144.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','103307',2050191,'1641','222',1047178.00,1049570.13,2392.13,334898.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','103307',2050192,'1642','222',1265528.31,1268675.45,3147.14,440599.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','103307',2050193,'1643','222',1116283.93,1116283.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','103307',2050194,'1644','222',771523.31,773514.39,1991.08,278751.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','103307',2050195,'1645','222',1038573.77,1038573.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','103307',2050196,'1646','223',293271.07,293271.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','103307',2050197,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','103709',2058034,'1640','222',654766.98,654766.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','103709',2058035,'1641','222',1049570.13,1049570.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','103709',2058036,'1642','222',1268675.45,1268675.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','103709',2058037,'1643','222',1116283.93,1116283.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','103709',2058038,'1644','222',773514.39,773514.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','103709',2058039,'1645','222',1038573.77,1038573.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','103709',2058040,'1646','223',293271.07,293271.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','103709',2058041,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','105595',2096254,'1640','222',654766.98,656763.97,1996.99,279578.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','105595',2096255,'1641','222',1049570.13,1051865.38,2295.25,321335.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','105595',2096256,'1642','222',1268675.45,1271748.67,3073.22,430250.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','105595',2096257,'1643','222',1116283.93,1116283.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','105595',2096258,'1644','222',773514.39,775598.52,2084.13,291778.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','105595',2096259,'1645','222',1038573.77,1038573.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','105595',2096260,'1646','223',293271.07,293271.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','105595',2096261,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','105606',2096442,'1640','222',656763.97,657920.06,1156.09,161852.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','105606',2096443,'1641','222',1051865.38,1053648.41,1783.03,249624.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','105606',2096444,'1642','222',1271748.67,1274273.57,2524.90,353486.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','105606',2096445,'1643','222',1116283.93,1117089.76,805.83,112816.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','105606',2096446,'1644','222',775598.52,776723.69,1125.17,157523.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','105606',2096447,'1645','222',1038573.77,1038573.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','105606',2096448,'1646','223',293271.07,293496.42,225.35,50703.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','105606',2096449,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','105854',2101038,'1640','222',657920.06,659101.79,1181.73,165442.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','105854',2101039,'1641','222',1053648.41,1055554.92,1906.51,266911.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','105854',2101040,'1642','222',1274273.57,1277395.25,3121.68,437035.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','105854',2101041,'1643','222',1117089.76,1118779.96,1690.20,236628.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','105854',2101042,'1644','222',776723.69,778154.76,1431.07,200349.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','105854',2101043,'1645','222',1038573.77,1039530.60,956.83,133956.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','105854',2101044,'1646','223',293496.42,293888.74,392.32,88272.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','105854',2101045,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','105855',2101046,'1640','222',659101.79,659522.24,420.45,58863.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','105855',2101047,'1641','222',1055554.92,1057182.08,1627.16,227802.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','105855',2101048,'1642','222',1277395.25,1279188.27,1793.02,251022.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','105855',2101049,'1643','222',1118779.96,1119486.86,706.90,98966.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','105855',2101050,'1644','222',778154.76,779629.62,1474.86,206480.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','105855',2101051,'1645','222',1039530.60,1041161.88,1631.28,228379.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','105855',2101052,'1646','223',293888.74,294153.87,265.13,59654.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','105855',2101053,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','105857',2101071,'1640','222',659522.24,660217.71,695.47,97365.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','105857',2101072,'1641','222',1057182.08,1057807.70,625.62,87586.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','105857',2101073,'1642','222',1279188.27,1282004.73,2816.46,394304.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','105857',2101074,'1643','222',1119486.86,1141619.99,22133.13,3098638.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','105857',2101075,'1644','222',779629.62,782365.51,2735.89,383024.60,0.00,0.00,0.00,0.00,0.00),('5','96','586','105857',2101076,'1645','222',1041161.88,1043559.29,2397.41,335637.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','105857',2101077,'1646','223',294153.87,294534.59,380.72,85662.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','105857',2101078,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106350',2110473,'1640','222',660217.71,661879.27,1661.56,232618.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','106350',2110474,'1641','222',1057807.70,1059212.02,1404.32,196604.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','106350',2110475,'1642','222',1282004.73,1283370.12,1365.39,191154.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','106350',2110476,'1643','222',1121619.99,1121619.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','106350',2110477,'1644','222',782365.51,785464.59,3099.08,433871.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','106350',2110478,'1645','222',1043559.29,1044770.72,1211.43,169600.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','106350',2110479,'1646','223',294534.59,294879.33,344.74,77566.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','106350',2110480,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106450',2112503,'1640','222',661879.27,663262.44,1383.17,193643.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','106450',2112504,'1641','222',1059212.02,1059221.88,9.86,1380.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','106450',2112505,'1642','222',1283370.12,1284853.54,1483.42,207678.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','106450',2112506,'1643','222',1121619.99,1122490.98,870.99,121938.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','106450',2112507,'1644','222',785464.59,787816.93,2352.34,329327.60,0.00,0.00,0.00,0.00,0.00),('5','96','586','106450',2112508,'1645','222',1044770.72,1046898.93,2128.21,297949.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','106450',2112509,'1646','223',294879.33,295331.37,452.04,101709.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','106450',2112510,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106451',2112511,'1640','222',663262.44,663262.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','106451',2112512,'1641','222',1059221.88,1060064.66,842.78,117989.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','106451',2112513,'1642','222',1284853.54,1287731.05,2877.51,402851.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','106451',2112514,'1643','222',1122490.98,1124517.71,2026.73,283742.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','106451',2112515,'1644','222',787816.93,789905.96,2089.03,292464.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','106451',2112516,'1645','222',1046898.93,1048513.18,1614.25,225995.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','106451',2112517,'1646','223',295331.37,295915.79,584.42,131494.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','106451',2112518,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106453',2112530,'1640','222',663262.44,664821.03,1558.59,218202.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','106453',2112531,'1641','222',1060064.66,1060861.36,796.70,111538.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','106453',2112532,'1642','222',1287731.05,1291121.32,3390.27,474637.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','106453',2112533,'1643','222',1124517.71,1124594.94,77.23,10812.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','106453',2112534,'1644','222',789905.96,789905.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','106453',2112535,'1645','222',1048513.18,1051247.34,2734.16,382782.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','106453',2112536,'1646','223',295915.79,296335.29,419.50,94387.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','106453',2112537,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106454',2112538,'1640','222',664821.03,666489.42,1668.39,233574.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','106454',2112539,'1641','222',1060861.36,1061659.71,798.35,111769.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','106454',2112540,'1642','222',1291121.32,1294152.89,3031.57,424419.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','106454',2112541,'1643','222',1124594.94,1124594.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','106454',2112542,'1644','222',789905.96,789905.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','106454',2112543,'1645','222',1051247.34,1054564.76,3317.42,464438.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','106454',2112544,'1646','223',296335.29,296652.19,316.90,71302.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','106454',2112545,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106458',2112616,'1640','222',666489.42,667664.54,1175.12,164516.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','106458',2112617,'1641','222',1061659.71,1064550.27,2890.56,404678.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','106458',2112618,'1642','222',1294152.89,1298147.70,3994.81,559273.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','106458',2112619,'1643','222',1124594.94,1124594.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','106458',2112620,'1644','222',789905.96,789905.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','106458',2112621,'1645','222',1054564.76,1055912.79,1348.03,188724.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','106458',2112622,'1646','223',296652.19,297245.45,593.26,133483.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','106458',2112623,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106459',2112624,'1640','222',667664.54,670164.30,2499.76,349966.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','106459',2112625,'1641','222',1064550.27,1067463.59,2913.32,407864.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','106459',2112626,'1642','222',1298147.70,1302030.32,3882.62,543566.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','106459',2112627,'1643','222',1124594.94,1124636.20,41.26,5776.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','106459',2112628,'1644','222',789905.96,790904.07,998.11,139735.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','106459',2112629,'1645','222',1055912.79,1058137.69,2224.90,311486.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','106459',2112630,'1646','223',297245.45,297831.40,585.95,131838.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','106459',2112631,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106460',2112632,'1640','222',670164.30,671416.63,1252.33,175326.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','106460',2112633,'1641','222',1067463.59,1069896.18,2432.59,340562.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','106460',2112634,'1642','222',1302030.32,1304000.21,1969.89,275784.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','106460',2112635,'1643','222',1124636.20,1125348.76,712.56,99758.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','106460',2112636,'1644','222',790904.07,792786.15,1882.08,263491.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','106460',2112637,'1645','222',1058137.69,1058791.04,653.35,91469.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','106460',2112638,'1646','223',297831.40,298236.93,405.53,91244.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','106460',2112639,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','106461',2112640,'1640','222',671416.63,672586.49,1169.86,163780.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','106461',2112641,'1641','222',1069896.18,1070776.99,880.81,123313.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','106461',2112642,'1642','222',1304000.21,1306416.34,2416.13,338258.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','106461',2112643,'1643','222',1125348.76,1126318.59,969.83,135776.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','106461',2112644,'1644','222',792786.15,794076.86,1290.71,180699.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','106461',2112645,'1645','222',1058791.04,1059689.36,898.32,125764.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','106461',2112646,'1646','223',298236.93,298682.40,445.47,100230.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','106461',2112647,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107437',2131585,'1640','222',672586.49,673678.31,1091.82,152854.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','107437',2131586,'1641','222',1070776.99,1071887.09,1110.10,155414.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','107437',2131587,'1642','222',1306416.34,1306416.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107437',2131588,'1643','222',1126318.59,1127689.86,1371.27,191977.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','107437',2131589,'1644','222',794076.86,796097.54,2020.68,282895.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','107437',2131590,'1645','222',1059689.36,1060493.02,803.66,112512.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','107437',2131591,'1646','223',298682.40,299103.27,420.87,94695.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','107437',2131592,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107441',2131652,'1640','222',673678.31,675423.22,1744.91,244287.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107441',2131653,'1641','222',1071887.09,1073909.95,2022.86,283200.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107441',2131654,'1642','222',1306416.34,1308978.27,2561.93,358670.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','107441',2131655,'1643','222',1127689.86,1128827.30,1137.44,159241.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','107441',2131656,'1644','222',796097.54,798928.86,2831.32,396384.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','107441',2131657,'1645','222',1060493.02,1061828.14,1335.12,186916.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','107441',2131658,'1646','223',299103.27,299547.37,444.10,99922.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','107441',2131659,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107442',2131660,'1640','222',675423.22,675987.78,564.56,79038.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107442',2131661,'1641','222',1073909.95,1075799.90,1889.95,264593.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','107442',2131662,'1642','222',1308978.27,1312150.82,3172.55,444157.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107442',2131663,'1643','222',1128827.30,1129923.97,1096.67,153533.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','107442',2131664,'1644','222',798928.86,800142.12,1213.26,169856.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','107442',2131665,'1645','222',1061828.14,1062938.08,1109.94,155391.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','107442',2131666,'1646','223',299547.37,300032.45,485.08,109143.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','107442',2131667,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107443',2131668,'1640','222',675987.78,678296.72,2308.94,323251.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','107443',2131669,'1641','222',1075799.90,1075829.29,29.39,4114.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','107443',2131670,'1642','222',1312150.82,1312150.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107443',2131671,'1643','222',1129923.97,1131382.45,1458.48,204187.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','107443',2131672,'1644','222',800142.12,802838.89,2696.77,377547.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','107443',2131673,'1645','222',1062938.08,1066544.63,3606.55,504917.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','107443',2131674,'1646','223',300032.45,300517.17,484.72,109062.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','107443',2131675,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107444',2131676,'1640','222',678296.72,680839.63,2542.91,356007.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107444',2131677,'1641','222',1075829.29,1078269.05,2439.76,341566.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107444',2131678,'1642','222',1312150.82,1315125.16,2974.34,416407.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','107444',2131679,'1643','222',1131382.45,1131382.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107444',2131680,'1644','222',802838.89,804186.30,1347.41,188637.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','107444',2131681,'1645','222',1066544.63,1069132.82,2588.19,362346.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','107444',2131682,'1646','223',300517.17,301258.72,741.55,166848.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','107444',2131683,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107445',2131684,'1640','222',680839.63,681680.78,841.15,117761.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','107445',2131685,'1641','222',1078269.05,1080358.27,2089.22,292490.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','107445',2131686,'1642','222',1315125.16,1318258.49,3133.33,438666.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','107445',2131687,'1643','222',1131382.45,1131465.20,82.75,11585.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107445',2131688,'1644','222',804186.30,805501.16,1314.86,184080.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','107445',2131689,'1645','222',1069132.82,1070524.33,1391.51,194811.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','107445',2131690,'1646','223',301258.72,301573.95,315.23,70926.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','107445',2131691,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107446',2131692,'1640','222',681680.78,682790.64,1109.86,155380.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107446',2131693,'1641','222',1080358.27,1082127.79,1769.52,247732.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','107446',2131694,'1642','222',1318258.49,1320955.44,2696.95,377573.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107446',2131695,'1643','222',1131465.20,1131465.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107446',2131696,'1644','222',805501.16,807473.48,1972.32,276124.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','107446',2131697,'1645','222',1070524.33,1071398.80,874.47,122425.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','107446',2131698,'1646','223',301573.95,302042.40,468.45,105401.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','107446',2131699,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107448',2131730,'1640','222',682790.64,684543.75,1753.11,245435.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107448',2131731,'1641','222',1082127.79,1084812.26,2684.47,375825.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','107448',2131732,'1642','222',1320955.44,1323001.62,2046.18,286465.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','107448',2131733,'1643','222',1131465.20,1131465.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107448',2131734,'1644','222',807473.48,807473.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','107448',2131735,'1645','222',1071398.80,1073429.65,2030.85,284319.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','107448',2131736,'1646','223',302042.40,302486.82,444.42,99994.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','107448',2131737,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107450',2131755,'1640','222',684543.75,685989.24,1445.49,202368.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','107450',2131756,'1641','222',1084812.26,1086834.10,2021.84,283057.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','107450',2131757,'1642','222',1323001.62,1325083.54,2081.92,291468.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','107450',2131758,'1643','222',1131465.20,1132790.87,1325.67,185593.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','107450',2131759,'1644','222',807473.48,807473.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','107450',2131760,'1645','222',1073429.65,1076010.92,2581.27,361377.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','107450',2131761,'1646','223',302486.82,302986.50,499.68,112428.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','107450',2131762,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107451',2131763,'1640','222',685989.24,687115.40,1126.16,157662.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107451',2131764,'1641','222',1086834.10,1088910.59,2076.49,290708.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','107451',2131765,'1642','222',1325083.54,1327418.75,2335.21,326929.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','107451',2131766,'1643','222',1132790.87,1134066.61,1275.74,178603.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','107451',2131767,'1644','222',807473.48,807473.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','107451',2131768,'1645','222',1076010.92,1078368.62,2357.70,330078.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','107451',2131769,'1646','223',302986.50,303482.61,496.11,111624.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','107451',2131770,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107452',2131771,'1640','222',687115.40,688106.19,990.79,138710.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','107452',2131772,'1641','222',1088910.59,1090791.20,1880.61,263285.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','107452',2131773,'1642','222',1327418.75,1329910.52,2491.77,348847.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','107452',2131774,'1643','222',1134066.61,1135746.20,1679.59,235142.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','107452',2131775,'1644','222',807473.48,807473.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','107452',2131776,'1645','222',1078368.62,1081072.30,2703.68,378515.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','107452',2131777,'1646','223',303482.61,304331.23,848.62,190939.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','107452',2131778,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107453',2131779,'1640','222',688106.19,690846.32,2740.13,383618.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','107453',2131780,'1641','222',1090791.20,1093474.14,2682.94,375611.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','107453',2131781,'1642','222',1329910.52,1333954.47,4043.95,566153.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107453',2131782,'1643','222',1135746.20,1136117.91,371.71,52039.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','107453',2131783,'1644','222',807473.48,807473.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','107453',2131784,'1645','222',1081072.30,1083998.05,2925.75,409605.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','107453',2131785,'1646','223',304331.23,304982.90,651.67,146625.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','107453',2131786,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','107854',2139408,'1640','222',690846.32,692704.11,1857.79,260090.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','107854',2139409,'1641','222',1093474.14,1093474.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','107854',2139410,'1642','222',1333954.47,1333954.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107854',2139411,'1643','222',1136117.91,1137774.61,1656.70,231938.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','107854',2139412,'1644','222',807473.48,809978.56,2505.08,350711.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','107854',2139413,'1645','222',1083998.05,1087560.37,3562.32,498724.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','107854',2139414,'1646','223',304982.90,305591.47,608.57,136928.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','107854',2139415,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108433',2151105,'1640','222',692704.11,694386.95,1682.84,235597.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','108433',2151106,'1641','222',1093474.14,1093474.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108433',2151107,'1642','222',1333954.47,1333954.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108433',2151108,'1643','222',1137774.61,1140188.05,2413.44,337881.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','108433',2151109,'1644','222',809978.56,812699.78,2721.22,380970.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','108433',2151110,'1645','222',1087560.37,1090618.24,3057.87,428101.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','108433',2151111,'1646','223',305591.47,306950.11,1358.64,305694.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','108433',2151112,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108434',2151113,'1640','222',694386.95,696867.07,2480.12,347216.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','108434',2151114,'1641','222',1093474.14,1093474.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108434',2151115,'1642','222',1333954.47,1333954.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108434',2151116,'1643','222',1140188.05,1142915.31,2727.26,381816.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','108434',2151117,'1644','222',812699.78,816044.08,3344.30,468202.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','108434',2151118,'1645','222',1090618.24,1092739.16,2120.92,296928.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','108434',2151119,'1646','223',306950.11,307710.72,760.61,171137.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','108434',2151120,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108473',2151829,'1640','222',696867.07,703511.72,6644.65,930251.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108473',2151830,'1641','222',1093474.14,1093474.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108473',2151831,'1642','222',1333954.47,1333954.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108473',2151832,'1643','222',1142915.31,1143204.78,289.47,40525.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','108473',2151833,'1644','222',816044.08,816398.44,354.36,49610.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','108473',2151834,'1645','222',1092739.16,1092739.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108473',2151835,'1646','223',307710.72,308627.38,916.66,206248.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','108473',2151836,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108475',2151861,'1640','222',703511.72,710478.81,6967.09,975392.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','108475',2151862,'1641','222',1093474.14,1093474.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108475',2151863,'1642','222',1333954.47,1333954.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108475',2151864,'1643','222',1143204.78,1143204.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108475',2151865,'1644','222',816398.44,816398.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','108475',2151866,'1645','222',1092739.16,1092739.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108475',2151867,'1646','223',308627.38,309368.26,740.88,166698.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','108475',2151868,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108478',2151921,'1640','222',710478.81,717027.71,6548.90,916846.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108478',2151922,'1641','222',1093474.14,1093474.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108478',2151923,'1642','222',1333954.47,1333954.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108478',2151924,'1643','222',1143204.78,1144391.13,1186.35,166089.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108478',2151925,'1644','222',816398.44,817514.12,1115.68,156195.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','108478',2151926,'1645','222',1092739.16,1092739.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108478',2151927,'1646','223',309368.26,310224.97,856.71,192759.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','108478',2151928,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108481',2151981,'1640','222',717027.71,720784.51,3756.80,525952.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108481',2151982,'1641','222',1093474.14,1093474.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108481',2151983,'1642','222',1333954.47,1333954.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108481',2151984,'1643','222',1144391.13,1149002.13,4611.00,645540.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108481',2151985,'1644','222',817514.12,821593.93,4079.81,571173.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','108481',2151986,'1645','222',1092739.16,1092739.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108481',2151987,'1646','223',310224.97,310948.22,723.25,162731.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','108481',2151988,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108483',2152011,'1640','222',720784.51,722223.31,1438.80,201432.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108483',2152012,'1641','222',1093474.14,1094729.34,1255.20,175728.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108483',2152013,'1642','222',1333954.47,1336814.62,2860.15,400421.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108483',2152014,'1643','222',1149002.13,1152300.51,3298.38,461773.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','108483',2152015,'1644','222',821593.93,826068.53,4474.60,626444.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','108483',2152016,'1645','222',1092739.16,1092739.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108483',2152017,'1646','223',310948.22,311483.57,535.35,120453.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','108483',2152018,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108487',2152099,'1640','222',722223.31,722223.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108487',2152100,'1641','222',1094729.34,1096309.33,1579.99,221198.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','108487',2152101,'1642','222',1336814.62,1341100.08,4285.46,599964.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','108487',2152102,'1643','222',1152300.51,1154801.27,2500.76,350106.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','108487',2152103,'1644','222',826068.53,829719.66,3651.13,511158.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','108487',2152104,'1645','222',1092739.16,1092739.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108487',2152105,'1646','223',311483.57,311966.70,483.13,108704.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','108487',2152106,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108489',2152137,'1640','222',722223.31,722223.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108489',2152138,'1641','222',1096309.33,1098255.90,1946.57,272519.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','108489',2152139,'1642','222',1341100.08,1344199.77,3099.69,433956.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','108489',2152140,'1643','222',1154801.27,1156556.91,1755.64,245789.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','108489',2152141,'1644','222',829719.66,832740.72,3021.06,422948.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','108489',2152142,'1645','222',1092739.16,1092739.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108489',2152143,'1646','223',311966.70,312838.74,872.04,196209.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','108489',2152144,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108490',2152145,'1640','222',722223.31,722223.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108490',2152146,'1641','222',1098255.90,1101070.47,2814.57,394039.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','108490',2152147,'1642','222',1344199.77,1348068.41,3868.64,541609.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','108490',2152148,'1643','222',1156556.91,1156635.93,79.02,11062.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','108490',2152149,'1644','222',832740.72,833101.49,360.77,50507.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','108490',2152150,'1645','222',1092739.16,1096772.56,4033.40,564676.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108490',2152151,'1646','223',312838.74,313516.90,678.16,152586.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','108490',2152152,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108491',2152153,'1640','222',722223.31,722223.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108491',2152154,'1641','222',1101070.47,1102470.50,1400.03,196004.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','108491',2152155,'1642','222',1348068.41,1351689.65,3621.24,506973.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','108491',2152156,'1643','222',1156635.93,1156635.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108491',2152157,'1644','222',833101.49,833101.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','108491',2152158,'1645','222',1096772.56,1100068.14,3295.58,461381.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','108491',2152159,'1646','223',313516.90,313516.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','108491',2152160,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108608',2154068,'1640','222',722223.31,723480.31,1257.00,175980.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','108608',2154069,'1641','222',1102470.50,1105574.84,3104.34,434607.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','108608',2154070,'1642','222',1351689.65,1353523.98,1834.33,256806.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','108608',2154071,'1643','222',1156635.93,1158529.25,1893.32,265064.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','108608',2154072,'1644','222',833101.49,836308.09,3206.60,448924.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','108608',2154073,'1645','222',1100068.14,1100068.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108608',2154074,'1646','223',313516.90,315059.72,1542.82,347134.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','108608',2154075,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108611',2154133,'1640','222',723480.31,724904.53,1424.22,199390.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','108611',2154134,'1641','222',1105574.84,1108732.70,3157.86,442100.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','108611',2154135,'1642','222',1353523.98,1356692.54,3168.56,443598.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','108611',2154136,'1643','222',1158529.25,1162150.51,3621.26,506976.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','108611',2154137,'1644','222',836308.09,840584.05,4275.96,598634.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','108611',2154138,'1645','222',1100068.14,1100068.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108611',2154139,'1646','223',315059.72,315748.22,688.50,154912.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','108611',2154140,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108723',2156366,'1640','222',724904.53,725714.60,810.07,113409.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','108723',2156367,'1641','222',1108732.70,1111105.13,2372.43,332140.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','108723',2156368,'1642','222',1356692.54,1359237.65,2545.11,356315.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','108723',2156369,'1643','222',1162150.51,1163716.99,1566.48,219307.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','108723',2156370,'1644','222',840584.05,843763.44,3179.39,445114.60,0.00,0.00,0.00,0.00,0.00),('5','96','586','108723',2156371,'1645','222',1100068.14,1103297.49,3229.35,452109.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','108723',2156372,'1646','223',315748.22,316797.07,1048.85,235991.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','108723',2156373,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','108821',2158247,'1640','222',725714.60,726324.24,609.64,85349.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','108821',2158248,'1641','222',1111105.13,1113002.95,1897.82,265694.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','108821',2158249,'1642','222',1359237.65,1361247.50,2009.85,281379.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','108821',2158250,'1643','222',1163716.99,1164734.52,1017.53,142454.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','108821',2158251,'1644','222',843763.44,846189.34,2425.90,339626.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','108821',2158252,'1645','222',1103297.49,1105273.86,1976.37,276691.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','108821',2158253,'1646','223',316797.07,317796.34,999.27,224835.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','108821',2158254,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','109105',2164142,'1640','222',726324.24,728131.27,1807.03,252984.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','109105',2164143,'1641','222',1113002.95,1114899.69,1896.74,265543.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','109105',2164144,'1642','222',1361247.50,1364271.53,3024.03,423364.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','109105',2164145,'1643','222',1164734.52,1165411.95,677.43,94840.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','109105',2164146,'1644','222',846189.34,848605.36,2416.02,338242.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','109105',2164147,'1645','222',1105273.86,1107442.74,2168.88,303643.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','109105',2164148,'1646','223',317796.34,318638.02,841.68,189378.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','109105',2164149,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','109106',2164150,'1640','222',728131.27,729097.81,966.54,135315.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','109106',2164151,'1641','222',1114899.69,1116627.38,1727.69,241876.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','109106',2164152,'1642','222',1364271.53,1366394.19,2122.66,297172.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','109106',2164153,'1643','222',1165411.95,1166465.24,1053.29,147460.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','109106',2164154,'1644','222',848605.36,850958.21,2352.85,329399.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','109106',2164155,'1645','222',1107442.74,1108932.51,1489.77,208567.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','109106',2164156,'1646','223',318638.02,319144.57,506.55,113973.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','109106',2164157,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','109610',2174104,'1640','222',729097.81,729617.84,520.03,72804.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','109610',2174105,'1641','222',1116627.38,1118379.02,1751.64,245229.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','109610',2174106,'1642','222',1366394.19,1369195.99,2801.80,392252.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','109610',2174107,'1643','222',1166465.24,1166950.94,485.70,67998.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','109610',2174108,'1644','222',850958.21,854087.80,3129.59,438142.60,0.00,0.00,0.00,0.00,0.00),('5','96','586','109610',2174109,'1645','222',1108932.51,1111654.63,2722.12,381096.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','109610',2174110,'1646','223',319144.57,319861.99,717.42,161419.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','109610',2174111,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','109611',2174112,'1640','222',729617.84,730161.44,543.60,76104.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','109611',2174113,'1641','222',1118379.02,1120224.19,1845.17,258323.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','109611',2174114,'1642','222',1369195.99,1371144.61,1948.62,272806.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','109611',2174115,'1643','222',1166950.94,1167792.50,841.56,117818.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','109611',2174116,'1644','222',854087.80,857708.63,3620.83,506916.20,0.00,0.00,0.00,0.00,0.00),('5','96','586','109611',2174117,'1645','222',1111654.63,1114099.49,2444.86,342280.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','109611',2174118,'1646','223',319861.99,321459.20,1597.21,359372.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','109611',2174119,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','109612',2174120,'1640','222',730161.44,730792.86,631.42,88398.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','109612',2174121,'1641','222',1120224.19,1122858.68,2634.49,368828.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','109612',2174122,'1642','222',1371144.61,1374504.91,3360.30,470442.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','109612',2174123,'1643','222',1167792.50,1169627.90,1835.40,256956.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','109612',2174124,'1644','222',857708.63,860722.88,3014.25,421995.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','109612',2174125,'1645','222',1114099.49,1117749.17,3649.68,510955.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','109612',2174126,'1646','223',321459.20,322493.54,1034.34,232726.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','109612',2174127,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','109629',2174531,'1640','222',730792.86,731698.25,905.39,126754.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','109629',2174532,'1641','222',1122858.68,1124062.68,1204.00,168560.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','109629',2174533,'1642','222',1374504.91,1376091.39,1586.48,222107.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','109629',2174534,'1643','222',1169627.90,1170308.57,680.67,95293.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','109629',2174535,'1644','222',860722.88,863939.72,3216.84,450357.60,0.00,0.00,0.00,0.00,0.00),('5','96','586','109629',2174536,'1645','222',1117749.17,1120622.42,2873.25,402255.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','109629',2174537,'1646','223',322493.54,323672.22,1178.68,265203.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','109629',2174538,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','110134',2184641,'1640','222',731698.25,732717.49,1019.24,142693.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','110134',2184642,'1641','222',1124062.68,1127396.59,3333.91,466747.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','110134',2184643,'1642','222',1376091.39,1378515.00,2423.61,339305.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','110134',2184644,'1643','222',1170308.57,1171432.68,1124.11,157375.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','110134',2184645,'1644','222',863939.72,865840.46,1900.74,266103.60,0.00,0.00,0.00,0.00,0.00),('5','96','586','110134',2184646,'1645','222',1120622.42,1121716.81,1094.39,153214.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','110134',2184647,'1646','223',323672.22,324913.17,1240.95,279213.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','110134',2184648,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','110396',2189725,'1640','222',732717.49,733418.20,700.71,98099.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','110396',2189726,'1641','222',1127396.59,1130020.56,2623.97,367355.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','110396',2189727,'1642','222',1378515.00,1382216.76,3701.76,518246.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','110396',2189728,'1643','222',1171432.68,1173980.28,2547.60,356664.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','110396',2189729,'1644','222',865840.46,868971.33,3130.87,438321.80,0.00,0.00,0.00,0.00,0.00),('5','96','586','110396',2189730,'1645','222',1121716.81,1122489.13,772.32,108124.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','110396',2189731,'1646','223',324913.17,326586.22,1673.05,376436.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','110396',2189732,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','110398',2189746,'1640','222',733418.20,733951.93,533.73,74722.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','110398',2189747,'1641','222',1130020.56,1132652.19,2631.63,368428.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','110398',2189748,'1642','222',1382216.76,1385545.46,3328.70,466018.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','110398',2189749,'1643','222',1173980.28,1174748.99,768.71,107619.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','110398',2189750,'1644','222',868971.33,872788.59,3817.26,534416.40,0.00,0.00,0.00,0.00,0.00),('5','96','586','110398',2189751,'1645','222',1122489.13,1125621.46,3132.33,438526.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','110398',2189752,'1646','223',326586.22,327925.97,1339.75,301443.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','110398',2189753,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','110407',2189859,'1640','222',733951.93,735517.79,1565.86,219220.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','110407',2189860,'1641','222',1132652.19,1135606.35,2954.16,413582.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','110407',2189861,'1642','222',1385545.46,1387819.62,2274.16,318382.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','110407',2189862,'1643','222',1174748.99,1175872.07,1123.08,157231.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','110407',2189863,'1644','222',872788.59,875946.29,3157.70,442078.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','110407',2189864,'1645','222',1125621.46,1128670.97,3049.51,426931.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','110407',2189865,'1646','223',327925.97,329181.54,1255.57,282503.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','110407',2189866,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','110408',2189867,'1640','222',735517.79,735517.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','110408',2189868,'1641','222',1135606.35,1135606.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','110408',2189869,'1642','222',1387819.62,1387819.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','110408',2189870,'1643','222',1175872.07,1175872.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','110408',2189871,'1644','222',875946.29,875946.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','110408',2189872,'1645','222',1128670.97,1128670.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','110408',2189873,'1646','223',329181.54,329181.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','110408',2189874,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','181802',3569831,'1640','222',735517.79,735517.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','181802',3569832,'1641','222',1135606.35,1135606.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','181802',3569833,'1642','222',1387819.62,1387819.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','181802',3569834,'1643','222',1175872.07,1175872.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','181802',3569835,'1644','222',875946.29,875946.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','181802',3569836,'1645','222',1128670.97,1128670.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','181802',3569837,'1646','223',329181.54,329181.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','181802',3569838,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','181810',3569935,'1640','222',1845229.10,1845229.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','181810',3569936,'1641','222',2252098.01,2254352.77,2254.76,367525.88,0.00,0.00,0.00,0.00,0.00),('5','96','584','181810',3569937,'1642','222',2978385.19,2982730.28,4345.09,708249.67,0.00,0.00,0.00,0.00,0.00),('5','96','585','181810',3569938,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','181810',3569939,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','181810',3569940,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','181810',3569941,'1646','223',858558.79,859172.88,614.09,153522.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','181810',3569942,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','181816',3570029,'1640','222',1845229.10,1845229.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','181816',3570030,'1641','222',2254352.77,2254352.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','181816',3570031,'1642','222',2982730.28,2982730.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','181816',3570032,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','181816',3570033,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','181816',3570034,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','181816',3570035,'1646','223',859172.88,859815.65,642.77,160692.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','181816',3570036,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','182096',3575394,'1640','222',1845229.10,1845229.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','182096',3575395,'1641','222',2254352.77,2254352.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','182096',3575396,'1642','222',2982730.28,2982730.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','182096',3575397,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','182096',3575398,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','182096',3575399,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','182096',3575400,'1646','223',859815.65,859815.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','182096',3575401,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','182296',3578795,'1640','222',1845229.01,1847551.45,2322.44,378557.72,0.00,0.00,0.00,0.00,0.00),('5','96','584','182296',3578796,'1641','222',2254352.77,2254352.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','182296',3578797,'1642','222',2982730.28,2982730.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','182296',3578798,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','182296',3578799,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','182296',3578800,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','182296',3578801,'1646','223',859815.65,859815.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','182296',3578802,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','182775',3587460,'1640','222',1847551.45,1851906.55,4355.10,622779.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','182775',3587461,'1641','222',2254352.77,2258616.01,4263.24,609643.32,0.00,0.00,0.00,0.00,0.00),('5','96','584','182775',3587462,'1642','222',2982730.28,2986599.52,3869.24,553301.32,0.00,0.00,0.00,0.00,0.00),('5','96','585','182775',3587463,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','182775',3587464,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','182775',3587465,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','182775',3587466,'1646','223',859815.65,859815.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','182775',3587467,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','182834',3588673,'1640','222',1851906.55,1856467.78,4561.23,743480.49,0.00,0.00,0.00,0.00,0.00),('5','96','584','182834',3588674,'1641','222',2258616.01,2261350.75,2734.74,445762.62,0.00,0.00,0.00,0.00,0.00),('5','96','584','182834',3588675,'1642','222',2986599.52,2990084.91,3485.39,568118.57,0.00,0.00,0.00,0.00,0.00),('5','96','585','182834',3588676,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','182834',3588677,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','182834',3588678,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','182834',3588679,'1646','223',859815.65,862989.01,3173.36,793340.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','182834',3588680,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','183244',3595910,'1640','222',1856467.78,1858655.85,2188.07,356655.41,0.00,0.00,0.00,0.00,0.00),('5','96','584','183244',3595911,'1641','222',2261350.75,2266963.03,5612.28,914801.64,0.00,0.00,0.00,0.00,0.00),('5','96','584','183244',3595912,'1642','222',2990084.91,2996318.72,6233.81,1016111.03,0.00,0.00,0.00,0.00,0.00),('5','96','585','183244',3595913,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','183244',3595914,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','183244',3595915,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','183244',3595916,'1646','223',862989.01,864088.80,1099.79,274947.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','183244',3595917,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','183280',3596573,'1640','222',1858655.85,1858655.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','183280',3596574,'1641','222',2266963.03,2266963.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','183280',3596575,'1642','222',2996318.72,2996318.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','183280',3596576,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','183280',3596577,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','183280',3596578,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','183280',3596579,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','183280',3596580,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','183423',3599382,'1640','222',1858655.85,1858655.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','183423',3599383,'1641','222',2266963.03,2271940.79,4977.76,811374.88,0.00,0.00,0.00,0.00,0.00),('5','96','584','183423',3599384,'1642','222',2996318.72,3003203.31,6884.59,1122188.17,0.00,0.00,0.00,0.00,0.00),('5','96','585','183423',3599385,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','183423',3599386,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','183423',3599387,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','183423',3599388,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','183423',3599389,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','183471',3599971,'1640','222',1858655.85,1858655.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','183471',3599972,'1641','222',2271940.79,2271940.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','183471',3599973,'1642','222',3003203.31,3003203.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','183471',3599974,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','183471',3599975,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','183471',3599976,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','183471',3599977,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','183471',3599978,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','183750',3605277,'1640','222',1858655.85,1858655.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','183750',3605278,'1641','222',2271940.79,2276054.35,4113.56,670510.28,0.00,0.00,0.00,0.00,0.00),('5','96','584','183750',3605279,'1642','222',3003203.31,3008934.33,5731.02,934156.26,0.00,0.00,0.00,0.00,0.00),('5','96','585','183750',3605280,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','183750',3605281,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','183750',3605282,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','183750',3605283,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','183750',3605284,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','184020',3610126,'1640','222',1858655.85,1858655.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','184020',3610127,'1641','222',2276054.35,2279310.25,3255.90,530711.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','184020',3610128,'1642','222',3008934.33,3013027.15,4092.82,667129.66,0.00,0.00,0.00,0.00,0.00),('5','96','585','184020',3610129,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','184020',3610130,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','184020',3610131,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','184020',3610132,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','184020',3610133,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','184115',3611901,'1640','222',1858655.85,1867594.89,8939.04,1457063.52,0.00,0.00,0.00,0.00,0.00),('5','96','584','184115',3611902,'1641','222',2279310.25,2281669.89,2359.64,384621.32,0.00,0.00,0.00,0.00,0.00),('5','96','584','184115',3611903,'1642','222',3013027.15,3016079.29,3052.14,497498.82,0.00,0.00,0.00,0.00,0.00),('5','96','585','184115',3611904,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','184115',3611905,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','184115',3611906,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','184115',3611907,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','184115',3611908,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','184251',3614336,'1640','222',1867594.89,1871022.48,3427.59,558697.17,0.00,0.00,0.00,0.00,0.00),('5','96','584','184251',3614337,'1641','222',2281669.89,2284831.96,3162.07,515417.41,0.00,0.00,0.00,0.00,0.00),('5','96','584','184251',3614338,'1642','222',3016079.29,3021774.92,5695.63,928387.69,0.00,0.00,0.00,0.00,0.00),('5','96','585','184251',3614339,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','184251',3614340,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','184251',3614341,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','184251',3614342,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','184251',3614343,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','184484',3618265,'1640','222',1871022.48,1877183.46,6160.98,1004239.74,0.00,0.00,0.00,0.00,0.00),('5','96','584','184484',3618266,'1641','222',2284831.96,2294906.33,10074.37,1642122.31,0.00,0.00,0.00,0.00,0.00),('5','96','584','184484',3618267,'1642','222',3021774.92,3033140.97,11366.05,1852666.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','184484',3618268,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','184484',3618269,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','184484',3618270,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','184484',3618271,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','184484',3618272,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','184639',3621349,'1640','222',1877183.46,1881254.58,4071.12,663592.56,0.00,0.00,0.00,0.00,0.00),('5','96','584','184639',3621350,'1641','222',2294906.33,2298370.03,3463.70,564583.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','184639',3621351,'1642','222',3033140.97,3037809.30,4668.33,760937.79,0.00,0.00,0.00,0.00,0.00),('5','96','585','184639',3621352,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','184639',3621353,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','184639',3621354,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','184639',3621355,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','184639',3621356,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','184841',3625015,'1640','222',1881254.58,1884727.85,3473.27,566143.01,0.00,0.00,0.00,0.00,0.00),('5','96','584','184841',3625016,'1641','222',2298370.03,2301104.60,2734.57,445734.91,0.00,0.00,0.00,0.00,0.00),('5','96','584','184841',3625017,'1642','222',3037809.30,3041911.95,4102.65,668731.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','184841',3625018,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','184841',3625019,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','184841',3625020,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','184841',3625021,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','184841',3625022,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','184909',3626022,'1640','222',1884727.85,1888382.25,3654.40,595667.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','184909',3626023,'1641','222',2301104.60,2304447.36,3342.76,544869.88,0.00,0.00,0.00,0.00,0.00),('5','96','584','184909',3626024,'1642','222',3041911.95,3046541.14,4629.19,754557.97,0.00,0.00,0.00,0.00,0.00),('5','96','585','184909',3626025,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','184909',3626026,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','184909',3626027,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','184909',3626028,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','184909',3626029,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','185117',3629597,'1640','222',1888382.25,1892149.20,3766.95,614012.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','185117',3629598,'1641','222',2304447.36,2308107.88,3660.52,596664.76,0.00,0.00,0.00,0.00,0.00),('5','96','584','185117',3629599,'1642','222',3046541.14,3051308.90,4767.76,777144.88,0.00,0.00,0.00,0.00,0.00),('5','96','585','185117',3629600,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','185117',3629601,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','185117',3629602,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','185117',3629603,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','185117',3629604,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','185273',3632013,'1640','222',1892149.20,1896639.67,4490.47,731946.61,0.00,0.00,0.00,0.00,0.00),('5','96','584','185273',3632014,'1641','222',2308107.88,2312333.73,4225.85,688813.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','185273',3632015,'1642','222',3051308.90,3057242.59,5933.69,967191.47,0.00,0.00,0.00,0.00,0.00),('5','96','585','185273',3632016,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','185273',3632017,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','185273',3632018,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','185273',3632019,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','185273',3632020,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','185496',3636240,'1640','222',1896639.67,1901120.07,4480.40,730305.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','185496',3636241,'1641','222',2312333.73,2316595.92,4262.19,694736.97,0.00,0.00,0.00,0.00,0.00),('5','96','584','185496',3636242,'1642','222',3057242.59,3062307.15,5064.56,825523.28,0.00,0.00,0.00,0.00,0.00),('5','96','585','185496',3636243,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','185496',3636244,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','185496',3636245,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','185496',3636246,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','185496',3636247,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','185683',3639608,'1640','222',1901120.07,1905182.82,4062.75,662228.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','185683',3639609,'1641','222',2316595.92,2320812.74,4216.82,687341.66,0.00,0.00,0.00,0.00,0.00),('5','96','584','185683',3639610,'1642','222',3062307.15,3067645.93,5338.78,870221.14,0.00,0.00,0.00,0.00,0.00),('5','96','585','185683',3639611,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','185683',3639612,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','185683',3639613,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','185683',3639614,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','185683',3639615,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','185877',3643093,'1640','222',1905182.82,1910472.25,5289.43,862177.09,0.00,0.00,0.00,0.00,0.00),('5','96','584','185877',3643094,'1641','222',2320812.74,2325300.11,4487.37,731441.31,0.00,0.00,0.00,0.00,0.00),('5','96','584','185877',3643095,'1642','222',3067645.93,3072758.91,5112.98,833415.74,0.00,0.00,0.00,0.00,0.00),('5','96','585','185877',3643096,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','185877',3643097,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','185877',3643098,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','185877',3643099,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','185877',3643100,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','186081',3646858,'1640','222',1910472.25,1914458.19,3985.94,649708.22,0.00,0.00,0.00,0.00,0.00),('5','96','584','186081',3646859,'1641','222',2325300.11,2328996.74,3696.63,602550.69,0.00,0.00,0.00,0.00,0.00),('5','96','584','186081',3646860,'1642','222',3072758.91,3078727.10,5968.19,972814.97,0.00,0.00,0.00,0.00,0.00),('5','96','585','186081',3646861,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','186081',3646862,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','186081',3646863,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','186081',3646864,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','186081',3646865,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','186313',3650658,'1640','222',1914458.19,1919326.42,4868.23,793521.49,0.00,0.00,0.00,0.00,0.00),('5','96','584','186313',3650659,'1641','222',2328996.74,2331294.55,2297.81,374543.03,0.00,0.00,0.00,0.00,0.00),('5','96','584','186313',3650660,'1642','222',3078727.10,3082547.75,3820.65,622765.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','186313',3650661,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','186313',3650662,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','186313',3650663,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','186313',3650664,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','186313',3650665,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','186550',3654594,'1640','222',1919326.42,1923368.45,4042.03,658850.89,0.00,0.00,0.00,0.00,0.00),('5','96','584','186550',3654595,'1641','222',2331294.55,2334812.86,3518.31,573484.53,0.00,0.00,0.00,0.00,0.00),('5','96','584','186550',3654596,'1642','222',3082547.75,3086914.81,4367.06,711830.78,0.00,0.00,0.00,0.00,0.00),('5','96','585','186550',3654597,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','186550',3654598,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','186550',3654599,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','186550',3654600,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','186550',3654601,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','186743',3658061,'1640','222',1923368.45,1928399.12,5030.67,819999.21,0.00,0.00,0.00,0.00,0.00),('5','96','584','186743',3658062,'1641','222',2334812.86,2339601.46,4788.60,780541.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','186743',3658063,'1642','222',3086914.81,3092613.27,5698.46,928848.98,0.00,0.00,0.00,0.00,0.00),('5','96','585','186743',3658064,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','186743',3658065,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','186743',3658066,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','186743',3658067,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','186743',3658068,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','187020',3662452,'1640','222',1928399.12,1932611.92,4212.80,686686.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','187020',3662453,'1641','222',2339601.46,2343244.33,3642.87,593787.81,0.00,0.00,0.00,0.00,0.00),('5','96','584','187020',3662454,'1642','222',3092613.27,3097887.17,5273.90,859645.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','187020',3662455,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','187020',3662456,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','187020',3662457,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','187020',3662458,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','187020',3662459,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','187328',3668148,'1640','222',1932611.92,1937012.98,4401.06,717372.78,0.00,0.00,0.00,0.00,0.00),('5','96','584','187328',3668149,'1641','222',2343244.33,2345052.07,1807.74,294661.62,0.00,0.00,0.00,0.00,0.00),('5','96','584','187328',3668150,'1642','222',3097887.17,3103121.61,5234.44,853213.72,0.00,0.00,0.00,0.00,0.00),('5','96','585','187328',3668151,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','187328',3668152,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','187328',3668153,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','187328',3668154,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','187328',3668155,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','187337',3668282,'1640','222',1937012.98,1941259.95,4246.97,692256.11,0.00,0.00,0.00,0.00,0.00),('5','96','584','187337',3668283,'1641','222',2345052.07,2348397.99,3345.92,545384.96,0.00,0.00,0.00,0.00,0.00),('5','96','584','187337',3668284,'1642','222',3103121.61,3108183.36,5061.75,825065.25,0.00,0.00,0.00,0.00,0.00),('5','96','585','187337',3668285,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','187337',3668286,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','187337',3668287,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','187337',3668288,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','187337',3668289,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','187559',3672280,'1640','222',1941259.95,1946089.67,4829.72,787244.36,0.00,0.00,0.00,0.00,0.00),('5','96','584','187559',3672281,'1641','222',2348397.99,2350422.69,2024.70,330026.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','187559',3672282,'1642','222',3108183.36,3113162.22,4978.86,811554.18,0.00,0.00,0.00,0.00,0.00),('5','96','585','187559',3672283,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','187559',3672284,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','187559',3672285,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','187559',3672286,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','187559',3672287,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','187783',3676265,'1640','222',1946089.67,1950588.56,4498.89,733319.07,0.00,0.00,0.00,0.00,0.00),('5','96','584','187783',3676266,'1641','222',2350422.69,2353701.35,3278.66,534421.58,0.00,0.00,0.00,0.00,0.00),('5','96','584','187783',3676267,'1642','222',3113162.22,3118664.32,5502.10,896842.30,0.00,0.00,0.00,0.00,0.00),('5','96','585','187783',3676268,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','187783',3676269,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','187783',3676270,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','187783',3676271,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','187783',3676272,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','188017',3680259,'1640','222',1950588.56,1956135.26,5546.70,904112.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','188017',3680260,'1641','222',2353701.35,2353704.68,3.33,542.79,0.00,0.00,0.00,0.00,0.00),('5','96','584','188017',3680261,'1642','222',3118664.32,3126102.17,7437.85,1212369.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','188017',3680262,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188017',3680263,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','188017',3680264,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','188017',3680265,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','188017',3680266,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','188224',3683751,'1640','222',1956135.26,1961715.11,5579.85,909515.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','188224',3683752,'1641','222',2353704.68,2355540.73,1836.05,299276.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','188224',3683753,'1642','222',3126102.17,3133314.42,7212.25,1175596.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','188224',3683754,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188224',3683755,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','188224',3683756,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','188224',3683757,'1646','223',864088.80,864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','188224',3683758,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','188404',3687031,'1640','222',1961715.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','188404',3687032,'1641','222',2355540.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','188404',3687033,'1642','222',3133314.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188404',3687034,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188404',3687035,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','188404',3687036,'1645','222',2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','188404',3687037,'1646','223',864088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','188404',3687038,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','188547',3689494,'1640','222',1961715.11,1963404.00,1688.89,275289.07,0.00,0.00,0.00,0.00,0.00),('5','96','584','188547',3689495,'1641','222',2355540.73,2360752.24,5211.51,849476.13,0.00,0.00,0.00,0.00,0.00),('5','96','584','188547',3689496,'1642','222',3133314.42,3140081.60,6767.18,1103050.34,0.00,0.00,0.00,0.00,0.00),('5','96','585','188547',3689497,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188547',3689498,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','188547',3689499,'1645','222',2309119.55,2309119.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','188547',3689500,'1646','223',865406.41,865510.60,104.19,26672.64,0.00,0.00,0.00,0.00,0.00),('5','96','589','188547',3689501,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','188606',3690377,'1640','222',1963404.00,1966325.28,2921.28,476168.64,0.00,0.00,0.00,0.00,0.00),('5','96','584','188606',3690378,'1641','222',2360752.24,2362684.97,1932.73,315034.99,0.00,0.00,0.00,0.00,0.00),('5','96','584','188606',3690379,'1642','222',3140081.60,3145093.02,5011.42,816861.46,0.00,0.00,0.00,0.00,0.00),('5','96','585','188606',3690380,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188606',3690381,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','188606',3690382,'1645','222',2309119.55,2312870.87,3751.32,611465.16,0.00,0.00,0.00,0.00,0.00),('5','96','587','188606',3690383,'1646','223',865510.60,865510.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','188606',3690384,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','188794',3693880,'1640','222',1966325.28,1971582.88,5257.60,856988.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','188794',3693881,'1641','222',2362684.97,2362921.47,236.50,38549.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','188794',3693882,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188794',3693883,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188794',3693884,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','188794',3693885,'1645','222',2312870.87,2319133.72,6262.85,1020844.55,0.00,0.00,0.00,0.00,0.00),('5','96','587','188794',3693886,'1646','223',865510.60,866659.34,1148.74,304416.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','188794',3693887,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','188994',3697439,'1640','222',1971582.88,1976991.80,5408.92,881653.96,0.00,0.00,0.00,0.00,0.00),('5','96','584','188994',3697440,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','188994',3697441,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188994',3697442,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','188994',3697443,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','188994',3697444,'1645','222',2319133.72,2324822.55,5688.83,927279.29,0.00,0.00,0.00,0.00,0.00),('5','96','587','188994',3697445,'1646','223',866659.34,867088.51,429.17,113730.05,0.00,0.00,0.00,0.00,0.00),('5','96','589','188994',3697446,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','189211',3701130,'1640','222',1976991.80,1982685.17,5693.37,928019.31,0.00,0.00,0.00,0.00,0.00),('5','96','584','189211',3701131,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','189211',3701132,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','189211',3701133,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','189211',3701134,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','189211',3701135,'1645','222',2324822.55,2328897.91,4075.36,664283.68,0.00,0.00,0.00,0.00,0.00),('5','96','587','189211',3701136,'1646','223',867088.51,867796.76,708.25,187686.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','189211',3701137,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','189402',3704871,'1640','222',1982685.17,1988888.43,6203.26,1011131.38,0.00,0.00,0.00,0.00,0.00),('5','96','584','189402',3704872,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','189402',3704873,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','189402',3704874,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','189402',3704875,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','189402',3704876,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','189402',3704877,'1646','223',867796.76,868396.72,599.96,158989.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','189402',3704878,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','189610',3708405,'1640','222',1988888.43,1992425.47,3537.04,576537.52,0.00,0.00,0.00,0.00,0.00),('5','96','584','189610',3708406,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','189610',3708407,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','189610',3708408,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','189610',3708409,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','189610',3708410,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','189610',3708411,'1646','223',868396.72,869281.13,884.41,234368.65,0.00,0.00,0.00,0.00,0.00),('5','96','589','189610',3708412,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','189806',3711836,'1640','222',1992425.47,1992425.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','189806',3711837,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','189806',3711838,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','189806',3711839,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','189806',3711840,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','189806',3711841,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','189806',3711842,'1646','223',869281.13,870453.84,1172.71,310768.15,0.00,0.00,0.00,0.00,0.00),('5','96','589','189806',3711843,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','190050',3716452,'1640','222',1992425.47,1992425.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','190050',3716453,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','190050',3716454,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190050',3716455,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190050',3716456,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','190050',3716457,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','190050',3716458,'1646','223',870453.84,871222.46,768.62,203684.30,0.00,0.00,0.00,0.00,0.00),('5','96','589','190050',3716459,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','190220',3719806,'1640','222',1992425.47,1992425.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','190220',3719807,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','190220',3719808,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190220',3719809,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190220',3719810,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','190220',3719811,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','190220',3719812,'1646','223',871222.46,872085.67,863.21,228750.65,0.00,0.00,0.00,0.00,0.00),('5','96','589','190220',3719813,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','190424',3723689,'1640','222',1992425.47,1997141.19,4715.72,778093.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','190424',3723690,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','190424',3723691,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190424',3723692,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190424',3723693,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','190424',3723694,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','190424',3723695,'1646','223',872085.67,872752.59,666.92,176733.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','190424',3723696,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','190694',3728483,'1640','222',1997141.19,2001808.32,4667.13,770076.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','190694',3728484,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','190694',3728485,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190694',3728486,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190694',3728487,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','190694',3728488,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','190694',3728489,'1646','223',872752.59,873200.57,447.98,118714.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','190694',3728490,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','190902',3732319,'1640','222',2001808.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','190902',3732320,'1641','222',2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','190902',3732321,'1642','222',3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190902',3732322,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','190902',3732323,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','190902',3732324,'1645','222',2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','190902',3732325,'1646','223',873200.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','190902',3732326,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','191023',3734518,'1640','222',2001808.32,2006275.65,4467.33,737109.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','191023',3734519,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','191023',3734520,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191023',3734521,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191023',3734522,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','191023',3734523,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','191023',3734524,'1646','223',873200.57,873701.20,500.63,132666.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','191023',3734525,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','191070',3735428,'1640','222',2006275.65,2007817.79,1542.14,254453.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','191070',3735429,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','191070',3735430,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191070',3735431,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191070',3735432,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','191070',3735433,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','191070',3735434,'1646','223',873701.20,874057.37,356.17,94385.05,0.00,0.00,0.00,0.00,0.00),('5','96','589','191070',3735435,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','191309',3739450,'1640','222',2007817.79,2007817.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','191309',3739451,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','191309',3739452,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191309',3739453,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191309',3739454,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','191309',3739455,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','191309',3739456,'1646','223',874057.37,874428.03,370.66,98224.90,0.00,0.00,0.00,0.00,0.00),('5','96','589','191309',3739457,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','191502',3743002,'1640','222',2007817.79,2007817.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','191502',3743003,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','191502',3743004,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191502',3743005,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191502',3743006,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','191502',3743007,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','191502',3743008,'1646','223',874428.03,874808.08,380.05,100713.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','191502',3743009,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','191730',3747378,'1640','222',2007817.79,2007817.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','191730',3747379,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','191730',3747380,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191730',3747381,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','191730',3747382,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','191730',3747383,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','191730',3747384,'1646','223',874808.08,875208.71,400.63,106166.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','191730',3747385,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','192116',3754761,'1640','222',2007817.79,2007817.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','192116',3754762,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','192116',3754763,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192116',3754764,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192116',3754765,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','192116',3754766,'1645','222',2328897.91,2328897.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','192116',3754767,'1646','223',875208.71,875484.50,275.79,73084.35,0.00,0.00,0.00,0.00,0.00),('5','96','589','192116',3754768,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','192179',3755674,'1640','222',2007817.79,2011519.98,3702.19,610861.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','192179',3755675,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','192179',3755676,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192179',3755677,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192179',3755678,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','192179',3755679,'1645','222',2328897.91,2329758.70,860.79,142030.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','192179',3755680,'1646','223',875484.50,876024.07,539.57,142986.05,0.00,0.00,0.00,0.00,0.00),('5','96','589','192179',3755681,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','192421',3759996,'1640','222',2011519.98,2013740.40,2220.42,366369.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','192421',3759997,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','192421',3759998,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192421',3759999,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192421',3760000,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','192421',3760001,'1645','222',2329758.70,2333216.54,3457.84,570543.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','192421',3760002,'1646','223',876024.07,876415.90,391.83,103834.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','192421',3760003,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','192581',3762999,'1640','222',2013740.40,2016602.91,2862.51,472314.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','192581',3763000,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','192581',3763001,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192581',3763002,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192581',3763003,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','192581',3763004,'1645','222',2333216.54,2337372.77,4156.23,685777.95,0.00,0.00,0.00,0.00,0.00),('5','96','587','192581',3763005,'1646','223',876415.90,876713.38,297.48,78832.20,0.00,0.00,0.00,0.00,0.00),('5','96','589','192581',3763006,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','192938',3769763,'1640','222',2016602.91,2018725.00,2122.09,350144.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','192938',3769764,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','192938',3769765,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192938',3769766,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192938',3769767,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','192938',3769768,'1645','222',2337372.77,2340685.05,3312.28,546526.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','192938',3769769,'1646','223',876713.38,877536.85,823.47,218219.55,0.00,0.00,0.00,0.00,0.00),('5','96','589','192938',3769770,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','192982',3770319,'1640','222',2018725.00,2021183.34,2458.34,405626.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','192982',3770320,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','192982',3770321,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192982',3770322,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','192982',3770323,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','192982',3770324,'1645','222',2340685.05,2341759.87,1074.82,177345.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','192982',3770325,'1646','223',877536.85,877790.80,253.95,67296.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','192982',3770326,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','193260',3775620,'1640','222',2021183.34,2021183.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','193260',3775621,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','193260',3775622,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','193260',3775623,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','193260',3775624,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','193260',3775625,'1645','222',2341759.87,2341759.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','193260',3775626,'1646','223',877790.80,878559.14,768.34,203610.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','193260',3775627,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','193467',3779772,'1640','222',2021183.34,2021183.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','193467',3779773,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','193467',3779774,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','193467',3779775,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','193467',3779776,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','193467',3779777,'1645','222',2341759.87,2341759.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','193467',3779778,'1646','223',878559.14,878882.41,323.27,85666.55,0.00,0.00,0.00,0.00,0.00),('5','96','589','193467',3779779,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','193630',3782890,'1640','222',2021183.34,2021183.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','193630',3782891,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','193630',3782892,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','193630',3782893,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','193630',3782894,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','193630',3782895,'1645','222',2341759.87,2341759.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','193630',3782896,'1646','223',878882.41,879391.61,509.20,134938.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','193630',3782897,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','193942',3788405,'1640','222',2021183.34,2023777.08,2593.74,427967.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','193942',3788406,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','193942',3788407,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','193942',3788408,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','193942',3788409,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','193942',3788410,'1645','222',2341759.87,2346211.78,4451.91,734565.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','193942',3788411,'1646','223',879391.61,879703.25,311.64,82584.60,0.00,0.00,0.00,0.00,0.00),('5','96','589','193942',3788412,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','194071',3790832,'1640','222',2023777.08,2027680.76,3903.68,644107.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','194071',3790833,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','194071',3790834,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194071',3790835,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194071',3790836,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','194071',3790837,'1645','222',2346211.78,2352214.80,6003.02,990498.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','194071',3790838,'1646','223',879703.25,879968.86,265.61,70386.65,0.00,0.00,0.00,0.00,0.00),('5','96','589','194071',3790839,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','194374',3796226,'1640','222',2027680.76,2031140.31,3459.55,570825.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','194374',3796227,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','194374',3796228,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194374',3796229,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194374',3796230,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','194374',3796231,'1645','222',2352214.80,2357850.17,5635.37,929836.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','194374',3796232,'1646','223',879968.86,879968.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','194374',3796233,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','194488',3798335,'1640','222',2031140.31,2033092.75,1952.44,322152.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','194488',3798336,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','194488',3798337,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194488',3798338,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194488',3798339,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','194488',3798340,'1645','222',2357850.17,2365587.03,7736.86,1276581.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','194488',3798341,'1646','223',879968.86,880618.19,649.33,172072.45,0.00,0.00,0.00,0.00,0.00),('5','96','589','194488',3798342,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','194722',3802417,'1640','222',2033092.75,2033092.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','194722',3802418,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','194722',3802419,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194722',3802420,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194722',3802421,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','194722',3802422,'1645','222',2365587.03,2372039.26,6452.23,1064617.95,0.00,0.00,0.00,0.00,0.00),('5','96','587','194722',3802423,'1646','223',880618.19,881150.22,532.03,140987.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','194722',3802424,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','194877',3805798,'1640','222',2033092.75,2035873.72,2780.97,458860.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','194877',3805799,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','194877',3805800,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194877',3805801,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','194877',3805802,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','194877',3805803,'1645','222',2372039.26,2375965.50,3926.24,647829.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','194877',3805804,'1646','223',881150.22,881455.66,305.44,80941.60,0.00,0.00,0.00,0.00,0.00),('5','96','589','194877',3805805,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','195068',3809263,'1640','222',2035873.72,2039769.51,3895.79,642805.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','195068',3809264,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','195068',3809265,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','195068',3809266,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','195068',3809267,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','195068',3809268,'1645','222',2375965.50,2382293.27,6327.77,1044082.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','195068',3809269,'1646','223',881455.66,881829.39,373.73,99038.45,0.00,0.00,0.00,0.00,0.00),('5','96','589','195068',3809270,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','195302',3813349,'1640','222',2039769.51,2045173.94,5404.43,891730.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','195302',3813350,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','195302',3813351,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','195302',3813352,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','195302',3813353,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','195302',3813354,'1645','222',2382293.27,2385711.14,3417.87,563948.55,0.00,0.00,0.00,0.00,0.00),('5','96','587','195302',3813355,'1646','223',881829.39,882332.42,503.03,133302.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','195302',3813356,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','195514',3817100,'1640','222',2045173.94,2049926.91,4752.97,784240.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','195514',3817101,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','195514',3817102,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','195514',3817103,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','195514',3817104,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','195514',3817105,'1645','222',2385711.14,2386009.46,298.32,49222.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','195514',3817106,'1646','223',882332.42,882734.76,402.34,106620.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','195514',3817107,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','195797',3821605,'1640','222',2049926.91,2050770.57,843.66,139203.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','195797',3821606,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','195797',3821607,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','195797',3821608,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','195797',3821609,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','195797',3821610,'1645','222',2386009.46,2387327.21,1317.75,217428.75,0.00,0.00,0.00,0.00,0.00),('5','96','587','195797',3821611,'1646','223',882734.76,883183.24,448.48,118847.20,0.00,0.00,0.00,0.00,0.00),('5','96','589','195797',3821612,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','196019',3825801,'1640','222',2050770.57,2050789.18,18.61,3070.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','196019',3825802,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','196019',3825803,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196019',3825804,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196019',3825805,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','196019',3825806,'1645','222',2387327.21,2387327.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','196019',3825807,'1646','223',883183.24,883542.46,359.22,95193.30,0.00,0.00,0.00,0.00,0.00),('5','96','589','196019',3825808,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','196234',3829963,'1640','222',2050789.18,2052491.42,1702.24,280869.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','196234',3829964,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','196234',3829965,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196234',3829966,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196234',3829967,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','196234',3829968,'1645','222',2387327.21,2391758.17,4430.96,731108.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','196234',3829969,'1646','223',883542.46,883984.05,441.59,117021.35,0.00,0.00,0.00,0.00,0.00),('5','96','589','196234',3829970,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','196476',3834163,'1640','222',2052491.42,2057352.46,4861.04,802071.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','196476',3834164,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','196476',3834165,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196476',3834166,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196476',3834167,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','196476',3834168,'1645','222',2391758.17,2397480.00,5721.83,944101.95,0.00,0.00,0.00,0.00,0.00),('5','96','587','196476',3834169,'1646','223',883984.05,884436.67,452.62,119944.30,0.00,0.00,0.00,0.00,0.00),('5','96','589','196476',3834170,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','196649',3837522,'1640','222',2057352.46,2060291.31,2938.85,484910.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','196649',3837523,'1641','222',2362921.47,2362921.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','196649',3837524,'1642','222',3145093.02,3145093.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196649',3837525,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196649',3837526,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','196649',3837527,'1645','222',2397480.00,2404622.22,7142.22,1178466.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','196649',3837528,'1646','223',884436.67,885071.78,635.11,168304.15,0.00,0.00,0.00,0.00,0.00),('5','96','589','196649',3837529,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','196857',3841146,'1640','222',2060291.31,2061319.89,1028.58,169715.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','196857',3841147,'1641','222',2362921.47,2367142.92,4221.45,696539.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','196857',3841148,'1642','222',3145093.02,3149687.14,4594.12,758029.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','196857',3841149,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','196857',3841150,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','196857',3841151,'1645','222',2404622.22,2405510.43,888.21,146554.65,0.00,0.00,0.00,0.00,0.00),('5','96','587','196857',3841152,'1646','223',885071.78,885418.03,346.25,91756.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','196857',3841153,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','197016',3844130,'1640','222',2061319.89,2062279.25,959.36,158294.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','197016',3844131,'1641','222',2367142.92,2370967.84,3824.92,631111.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','197016',3844132,'1642','222',3149687.14,3149687.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','197016',3844133,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','197016',3844134,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','197016',3844135,'1645','222',2405510.43,2405510.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','197016',3844136,'1646','223',885418.03,885858.83,440.80,116812.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','197016',3844137,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','197598',3853822,'1640','222',2062279.25,2063264.18,984.93,162513.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','197598',3853823,'1641','222',2370967.84,2374397.78,3429.94,565940.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','197598',3853824,'1642','222',3149687.14,3161416.65,11729.51,1935369.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','197598',3853825,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','197598',3853826,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','197598',3853827,'1645','222',2405510.43,2405510.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','197598',3853828,'1646','223',885858.83,886363.30,504.47,133684.55,0.00,0.00,0.00,0.00,0.00),('5','96','589','197598',3853829,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198042',3861869,'1640','222',2063264.18,2069367.41,6103.23,1007032.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','198042',3861870,'1641','222',2374397.78,2375336.40,938.62,154872.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','198042',3861871,'1642','222',3161416.65,3162949.22,1532.57,252874.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','198042',3861872,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198042',3861873,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198042',3861874,'1645','222',2405510.43,2414080.64,8570.21,1414084.65,0.00,0.00,0.00,0.00,0.00),('5','96','587','198042',3861875,'1646','223',886363.30,886822.35,459.05,121648.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','198042',3861876,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198109',3863028,'1640','222',2069367.41,2075028.22,5660.81,809495.83,0.00,0.00,0.00,0.00,0.00),('5','96','584','198109',3863029,'1641','222',2375336.40,2375336.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','198109',3863030,'1642','222',3162949.22,3162949.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198109',3863031,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198109',3863032,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198109',3863033,'1645','222',2414080.64,2420495.52,6414.88,917327.84,0.00,0.00,0.00,0.00,0.00),('5','96','587','198109',3863034,'1646','223',886822.35,887395.32,572.97,126053.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','198109',3863035,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198145',3863477,'1640','222',2075028.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','198145',3863478,'1641','222',2375336.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','198145',3863479,'1642','222',3162949.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198145',3863480,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198145',3863481,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198145',3863482,'1645','222',2420495.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','198145',3863483,'1646','223',887395.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','198145',3863484,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198234',3864935,'1640','222',2075028.22,2078593.29,3565.07,588236.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','198234',3864936,'1641','222',2375336.40,2376682.66,1346.26,222132.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','198234',3864937,'1642','222',3162949.22,3164687.93,1738.71,286887.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','198234',3864938,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198234',3864939,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198234',3864940,'1645','222',2420495.52,2427350.76,6855.24,1131114.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','198234',3864941,'1646','223',887395.32,888096.75,701.43,189386.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','198234',3864942,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198247',3865138,'1640','222',2078593.29,2078593.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','198247',3865139,'1641','222',2376682.66,2380427.05,3744.39,617824.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','198247',3865140,'1642','222',3164687.93,3169241.00,4553.07,751256.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','198247',3865141,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198247',3865142,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198247',3865143,'1645','222',2427350.76,2432464.00,5113.24,843684.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','198247',3865144,'1646','223',888096.75,888702.27,605.52,163490.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','198247',3865145,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198340',3866944,'1640','222',2078593.29,2078593.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','198340',3866945,'1641','222',2380427.05,2386064.57,5637.52,930190.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','198340',3866946,'1642','222',3169241.00,3175467.98,6226.98,1027451.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','198340',3866947,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198340',3866948,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198340',3866949,'1645','222',2432464.00,2434401.22,1937.22,319641.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','198340',3866950,'1646','223',888702.27,889237.83,535.56,144601.20,0.00,0.00,0.00,0.00,0.00),('5','96','589','198340',3866951,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198557',3870700,'1640','222',2078593.29,2078593.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','198557',3870701,'1641','222',2386064.57,2391579.32,5514.75,909933.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','198557',3870702,'1642','222',3175467.98,3182831.93,7363.95,1215051.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','198557',3870703,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198557',3870704,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198557',3870705,'1645','222',2434401.22,2434401.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','198557',3870706,'1646','223',889237.83,889943.14,705.31,190433.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','198557',3870707,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198775',3874279,'1640','222',2078593.29,2081697.69,3104.40,512226.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','198775',3874280,'1641','222',2391579.32,2393654.73,2075.41,342442.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','198775',3874281,'1642','222',3182831.93,3184878.91,2046.98,337751.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','198775',3874282,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198775',3874283,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198775',3874284,'1645','222',2434401.22,2441379.54,6978.32,1151422.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','198775',3874285,'1646','223',889943.14,890286.97,343.83,92834.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','198775',3874286,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','198988',3877925,'1640','222',2081697.69,2086393.29,4695.60,774774.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','198988',3877926,'1641','222',2393654.73,2394658.60,1003.87,165638.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','198988',3877927,'1642','222',3184878.91,3186480.06,1601.15,264189.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','198988',3877928,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','198988',3877929,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','198988',3877930,'1645','222',2441379.54,2446671.07,5291.53,873102.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','198988',3877931,'1646','223',890286.97,890286.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','198988',3877932,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','199192',3881698,'1640','222',2086393.29,2086908.70,515.41,85042.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','199192',3881699,'1641','222',2394658.60,2398234.60,3576.00,590040.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','199192',3881700,'1642','222',3186480.06,3190514.85,4034.79,665740.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','199192',3881701,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','199192',3881702,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','199192',3881703,'1645','222',2446671.07,2452655.64,5984.57,987454.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','199192',3881704,'1646','223',890286.97,890286.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','199192',3881705,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','199456',3885704,'1640','222',2086908.70,2087846.00,937.30,154654.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','199456',3885705,'1641','222',2398234.60,2402044.16,3809.56,628577.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','199456',3885706,'1642','222',3190514.85,3195471.01,4956.16,817766.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','199456',3885707,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','199456',3885708,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','199456',3885709,'1645','222',2452655.64,2457301.68,4646.04,766596.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','199456',3885710,'1646','223',890286.97,890987.52,700.55,189148.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','199456',3885711,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','199633',3889094,'1640','222',2087846.00,2088605.47,759.47,125312.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','199633',3889095,'1641','222',2402044.16,2405909.40,3865.24,637764.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','199633',3889096,'1642','222',3195471.01,3200312.14,4841.13,798786.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','199633',3889097,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','199633',3889098,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','199633',3889099,'1645','222',2457301.68,2462199.33,4897.65,808112.25,0.00,0.00,0.00,0.00,0.00),('5','96','587','199633',3889100,'1646','223',890987.52,891421.27,433.75,117112.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','199633',3889101,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','199873',3892571,'1640','222',2088605.47,2088605.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','199873',3892572,'1641','222',2405909.40,2410356.47,4447.07,733766.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','199873',3892573,'1642','222',3200312.14,3205613.98,5301.84,874803.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','199873',3892574,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','199873',3892575,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','199873',3892576,'1645','222',2462199.33,2466132.27,3932.94,648935.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','199873',3892577,'1646','223',891421.27,891824.51,403.24,108874.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','199873',3892578,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','200093',3896753,'1640','222',2088605.47,2093358.62,4753.15,784269.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','200093',3896754,'1641','222',2410356.47,2411326.04,969.57,159979.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','200093',3896755,'1642','222',3205613.98,3206661.65,1047.67,172865.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','200093',3896756,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','200093',3896757,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','200093',3896758,'1645','222',2466132.27,2472867.58,6735.31,1111326.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','200093',3896759,'1646','223',891824.51,892257.93,433.42,117023.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','200093',3896760,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','200302',3900304,'1640','222',2093358.62,2096230.48,2871.86,473856.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','200302',3900305,'1641','222',2411326.04,2412904.24,1578.20,260403.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','200302',3900306,'1642','222',3206661.65,3208469.32,1807.67,298265.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','200302',3900307,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','200302',3900308,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','200302',3900309,'1645','222',2472867.58,2479749.78,6882.20,1135563.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','200302',3900310,'1646','223',892257.93,892937.44,679.51,183467.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','200302',3900311,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','200495',3904002,'1640','222',2096230.48,2098938.32,2707.84,446793.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','200495',3904003,'1641','222',2412904.24,2416443.75,3539.51,584019.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','200495',3904004,'1642','222',3208469.32,3213107.31,4637.99,765268.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','200495',3904005,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','200495',3904006,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','200495',3904007,'1645','222',2479749.78,2483497.25,3747.47,618332.55,0.00,0.00,0.00,0.00,0.00),('5','96','587','200495',3904008,'1646','223',892937.44,893699.64,762.20,205794.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','200495',3904009,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','200693',3907493,'1640','222',2098938.32,2101543.38,2605.06,429834.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','200693',3907494,'1641','222',2416443.75,2419555.40,3111.65,513422.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','200693',3907495,'1642','222',3213107.31,3217491.81,4384.50,723442.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','200693',3907496,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','200693',3907497,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','200693',3907498,'1645','222',2483497.25,2487611.63,4114.38,678872.70,0.00,0.00,0.00,0.00,0.00),('5','96','587','200693',3907499,'1646','223',893699.64,894125.29,425.65,114925.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','200693',3907500,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','200928',3911603,'1640','222',2101543.38,2104274.83,2731.45,450689.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','200928',3911604,'1641','222',2419555.40,2421134.02,1578.62,260472.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','200928',3911605,'1642','222',3217491.81,3221354.41,3862.60,637329.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','200928',3911606,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','200928',3911607,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','200928',3911608,'1645','222',2487611.63,2491342.42,3730.79,615580.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','200928',3911609,'1646','223',894125.29,895824.66,1699.37,458829.90,0.00,0.00,0.00,0.00,0.00),('5','96','589','200928',3911610,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','201102',3914543,'1640','222',2104274.83,2108219.16,3944.33,650814.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','201102',3914544,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','201102',3914545,'1642','222',3221354.41,3223806.84,2452.43,404650.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','201102',3914546,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','201102',3914547,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','201102',3914548,'1645','222',2491342.42,2495133.94,3791.52,625600.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','201102',3914549,'1646','223',895824.66,896300.90,476.24,128584.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','201102',3914550,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','201317',3918094,'1640','222',2108219.16,2110281.72,2062.56,340322.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','201317',3918095,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','201317',3918096,'1642','222',3223806.84,3227974.14,4167.30,687604.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','201317',3918097,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','201317',3918098,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','201317',3918099,'1645','222',2495133.94,2498442.00,3308.06,545829.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','201317',3918100,'1646','223',896300.90,896818.53,517.63,139760.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','201317',3918101,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','201494',3921442,'1640','222',2110281.72,2114827.29,4545.57,750019.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','201494',3921443,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','201494',3921444,'1642','222',3227974.14,3233540.60,5566.46,918465.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','201494',3921445,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','201494',3921446,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','201494',3921447,'1645','222',2498442.00,2503465.90,5023.90,828943.50,0.00,0.00,0.00,0.00,0.00),('5','96','587','201494',3921448,'1646','223',896818.53,897371.53,553.00,149310.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','201494',3921449,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','201761',3926590,'1640','222',2114827.29,2118699.03,3871.74,638837.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','201761',3926591,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','201761',3926592,'1642','222',3233540.60,3239542.89,6002.29,990377.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','201761',3926593,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','201761',3926594,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','201761',3926595,'1645','222',2503465.90,2508120.21,4654.31,767961.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','201761',3926596,'1646','223',897371.53,898450.99,1079.46,296851.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','201761',3926597,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','202039',3931719,'1640','222',2118699.03,2121652.26,2953.23,487282.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','202039',3931720,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','202039',3931721,'1642','222',3239542.89,3245241.08,5698.19,940201.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','202039',3931722,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','202039',3931723,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','202039',3931724,'1645','222',2508120.21,2512489.66,4369.45,720959.25,0.00,0.00,0.00,0.00,0.00),('5','96','587','202039',3931725,'1646','223',898450.99,899307.57,856.58,235559.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','202039',3931726,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','202203',3934541,'1640','222',2121652.26,2125912.75,4260.49,702980.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','202203',3934542,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','202203',3934543,'1642','222',3245241.08,3249957.15,4716.07,778151.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','202203',3934544,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','202203',3934545,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','202203',3934546,'1645','222',2512489.66,2516758.88,4269.22,704421.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','202203',3934547,'1646','223',899307.57,900545.16,1237.59,340337.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','202203',3934548,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','202424',3938395,'1640','222',2125912.75,2129042.53,3129.78,516413.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','202424',3938396,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','202424',3938397,'1642','222',3249957.15,3254001.27,4044.12,667279.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','202424',3938398,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','202424',3938399,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','202424',3938400,'1645','222',2516758.88,2520521.81,3762.93,620883.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','202424',3938401,'1646','223',900545.16,901113.08,567.92,156178.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','202424',3938402,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','202629',3942032,'1640','222',2129042.53,2132041.80,2999.27,494879.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','202629',3942033,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','202629',3942034,'1642','222',3254001.27,3258354.22,4352.95,718236.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','202629',3942035,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','202629',3942036,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','202629',3942037,'1645','222',2520521.81,2525019.07,4497.26,742047.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','202629',3942038,'1646','223',901113.08,901634.94,521.86,143511.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','202629',3942039,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','202853',3945935,'1640','222',2132041.80,2135708.22,3666.42,604959.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','202853',3945936,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','202853',3945937,'1642','222',3258354.22,3263777.83,5423.61,894895.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','202853',3945938,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','202853',3945939,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','202853',3945940,'1645','222',2525019.07,2529249.46,4230.39,698014.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','202853',3945941,'1646','223',901634.94,902513.16,878.22,241510.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','202853',3945942,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','203116',3950901,'1640','222',2135708.22,2139916.80,4208.58,694415.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','203116',3950902,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','203116',3950903,'1642','222',3263777.83,3268849.34,5071.51,836799.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','203116',3950904,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','203116',3950905,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','203116',3950906,'1645','222',2529249.46,2534658.97,5409.51,892569.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','203116',3950907,'1646','223',902513.16,903305.51,792.35,217896.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','203116',3950908,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','203327',3954653,'1640','222',2139916.80,2142149.61,2232.81,368413.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','203327',3954654,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','203327',3954655,'1642','222',3268849.34,3272790.27,3940.93,650253.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','203327',3954656,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','203327',3954657,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','203327',3954658,'1645','222',2534658.97,2538044.46,3385.49,558605.85,0.00,0.00,0.00,0.00,0.00),('5','96','587','203327',3954659,'1646','223',903305.51,904077.38,771.87,212264.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','203327',3954660,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','203523',3958286,'1640','222',2142149.61,2145189.68,3040.07,501611.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','203523',3958287,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','203523',3958288,'1642','222',3272790.27,3277925.03,5134.76,847235.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','203523',3958289,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','203523',3958290,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','203523',3958291,'1645','222',2538044.46,2541060.54,3016.08,497653.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','203523',3958292,'1646','223',904077.38,904707.32,629.94,173233.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','203523',3958293,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','203818',3963536,'1640','222',2145189.68,2148833.06,3643.38,601157.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','203818',3963537,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','203818',3963538,'1642','222',3277925.03,3282216.22,4291.19,708046.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','203818',3963539,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','203818',3963540,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','203818',3963541,'1645','222',2541060.54,2545492.16,4431.62,731217.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','203818',3963542,'1646','223',904707.32,905682.55,975.23,268188.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','203818',3963543,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','203982',3966281,'1640','222',2148833.06,2150949.53,2116.47,349217.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','203982',3966282,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','203982',3966283,'1642','222',3282216.22,3286838.81,4622.59,762727.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','203982',3966284,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','203982',3966285,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','203982',3966286,'1645','222',2545492.16,2550317.49,4825.33,796179.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','203982',3966287,'1646','223',905682.55,906018.43,335.88,92367.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','203982',3966288,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','204197',3970392,'1640','222',2150949.53,2153323.08,2373.55,391635.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','204197',3970393,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','204197',3970394,'1642','222',3286838.81,3291210.94,4372.13,721401.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','204197',3970395,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','204197',3970396,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','204197',3970397,'1645','222',2550317.49,2553690.80,3373.31,556596.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','204197',3970398,'1646','223',906018.43,906146.52,128.09,35224.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','204197',3970399,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','204420',3974268,'1640','222',2153323.08,2156410.41,3087.33,509409.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','204420',3974269,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','204420',3974270,'1642','222',3291210.94,3295856.66,4645.72,766543.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','204420',3974271,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','204420',3974272,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','204420',3974273,'1645','222',2553690.80,2557697.35,4006.55,661080.75,0.00,0.00,0.00,0.00,0.00),('5','96','587','204420',3974274,'1646','223',906146.52,906360.33,213.81,58797.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','204420',3974275,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','204610',3977968,'1640','222',2156410.41,2160844.87,4434.46,731685.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','204610',3977969,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','204610',3977970,'1642','222',3295856.66,3301687.26,5830.60,962049.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','204610',3977971,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','204610',3977972,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','204610',3977973,'1645','222',2557697.35,2562494.33,4796.98,791501.70,0.00,0.00,0.00,0.00,0.00),('5','96','587','204610',3977974,'1646','223',906360.33,906404.42,44.09,12124.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','204610',3977975,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','204841',3981605,'1640','222',2160844.87,2163726.29,2881.42,475434.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','204841',3981606,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','204841',3981607,'1642','222',3301687.26,3305586.99,3899.73,643455.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','204841',3981608,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','204841',3981609,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','204841',3981610,'1645','222',2562494.33,2566316.06,3821.73,630585.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','204841',3981611,'1646','223',906404.42,906429.79,25.37,6976.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','204841',3981612,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','205038',3985197,'1640','222',2163726.29,2167590.61,3864.32,637612.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','205038',3985198,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','205038',3985199,'1642','222',3305586.99,3305616.58,29.59,4882.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','205038',3985200,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','205038',3985201,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','205038',3985202,'1645','222',2566316.06,2571819.88,5503.82,908130.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','205038',3985203,'1646','223',906429.79,906461.50,31.71,8720.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','205038',3985204,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','205223',3988622,'1640','222',2167590.61,2172750.94,5160.33,851454.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','205223',3988623,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','205223',3988624,'1642','222',3305616.58,3306626.40,1009.82,166620.30,0.00,0.00,0.00,0.00,0.00),('5','96','585','205223',3988625,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','205223',3988626,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','205223',3988627,'1645','222',2571819.88,2577354.17,5534.29,913157.85,0.00,0.00,0.00,0.00,0.00),('5','96','587','205223',3988628,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','205223',3988629,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','205498',3993376,'1640','222',2172750.94,2174721.59,1970.65,325157.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','205498',3993377,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','205498',3993378,'1642','222',3306626.40,3309907.31,3280.91,541350.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','205498',3993379,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','205498',3993380,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','205498',3993381,'1645','222',2577354.17,2580669.31,3315.14,546998.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','205498',3993382,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','205498',3993383,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','205720',3997681,'1640','222',2174721.59,2177796.31,3074.72,507328.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','205720',3997682,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','205720',3997683,'1642','222',3309907.31,3314985.39,5078.08,837883.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','205720',3997684,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','205720',3997685,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','205720',3997686,'1645','222',2580669.31,2584870.90,4201.59,693262.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','205720',3997687,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','205720',3997688,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','205982',4002107,'1640','222',2177796.31,2180827.52,3031.21,500149.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','205982',4002108,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','205982',4002109,'1642','222',3314985.39,3319387.12,4401.73,726285.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','205982',4002110,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','205982',4002111,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','205982',4002112,'1645','222',2584870.90,2589010.26,4139.36,682994.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','205982',4002113,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','205982',4002114,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','206136',4005068,'1640','222',2180827.52,2184006.03,3178.51,524454.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','206136',4005069,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','206136',4005070,'1642','222',3319387.12,3324346.15,4959.03,818239.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','206136',4005071,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','206136',4005072,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','206136',4005073,'1645','222',2589010.26,2593950.62,4940.36,815159.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','206136',4005074,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','206136',4005075,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','206374',4009003,'1640','222',2184006.03,2186546.64,2540.61,419200.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','206374',4009004,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','206374',4009005,'1642','222',3324346.15,3329668.10,5321.95,878121.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','206374',4009006,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','206374',4009007,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','206374',4009008,'1645','222',2593950.62,2596753.85,2803.23,462532.95,0.00,0.00,0.00,0.00,0.00),('5','96','587','206374',4009009,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','206374',4009010,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','206575',4012562,'1640','222',2186546.64,2189450.98,2904.34,479216.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','206575',4012563,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','206575',4012564,'1642','222',3329668.10,3334432.90,4764.80,786192.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','206575',4012565,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','206575',4012566,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','206575',4012567,'1645','222',2596753.85,2600558.25,3804.40,627726.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','206575',4012568,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','206575',4012569,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','206788',4016438,'1640','222',2189450.98,2191646.25,2195.27,362219.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','206788',4016439,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','206788',4016440,'1642','222',3334432.90,3338826.89,4393.99,725008.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','206788',4016441,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','206788',4016442,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','206788',4016443,'1645','222',2600558.25,2604835.20,4276.95,705696.75,0.00,0.00,0.00,0.00,0.00),('5','96','587','206788',4016444,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','206788',4016445,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','207018',4020602,'1640','222',2191646.25,2193985.19,2338.94,385925.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','207018',4020603,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','207018',4020604,'1642','222',3338826.89,3344782.20,5955.31,982626.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','207018',4020605,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','207018',4020606,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','207018',4020607,'1645','222',2604835.20,2608839.06,4003.86,660636.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','207018',4020608,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','207018',4020609,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','207241',4024644,'1640','222',2193985.19,2195539.23,1554.04,256416.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','207241',4024645,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','207241',4024646,'1642','222',3344782.20,3349247.80,4465.60,736824.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','207241',4024647,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','207241',4024648,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','207241',4024649,'1645','222',2608839.06,2613076.00,4236.94,699095.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','207241',4024650,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','207241',4024651,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','207488',4028898,'1640','222',2195539.23,2199309.39,3770.16,622076.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','207488',4028899,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','207488',4028900,'1642','222',3349247.80,3355017.99,5770.19,952081.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','207488',4028901,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','207488',4028902,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','207488',4028903,'1645','222',2613076.00,2613076.18,0.18,29.70,0.00,0.00,0.00,0.00,0.00),('5','96','587','207488',4028904,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','207488',4028905,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','207699',4032548,'1640','222',2199309.39,2204005.65,4696.26,774882.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','207699',4032549,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','207699',4032550,'1642','222',3355017.99,3362815.71,7797.72,1286623.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','207699',4032551,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','207699',4032552,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','207699',4032553,'1645','222',2613076.18,2613137.45,61.27,10109.55,0.00,0.00,0.00,0.00,0.00),('5','96','587','207699',4032554,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','207699',4032555,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','207918',4036162,'1640','222',2204005.65,2207788.29,3782.64,624135.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','207918',4036163,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','207918',4036164,'1642','222',3362815.71,3370202.35,7386.64,1218795.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','207918',4036165,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','207918',4036166,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','207918',4036167,'1645','222',2613137.45,2613137.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','207918',4036168,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','207918',4036169,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','208119',4039679,'1640','222',2207788.29,2211402.30,3614.01,596311.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','208119',4039680,'1641','222',2421134.02,2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','208119',4039681,'1642','222',3370202.35,3376907.89,6705.54,1106414.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','208119',4039682,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','208119',4039683,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','208119',4039684,'1645','222',2613137.45,2613137.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','208119',4039685,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','208119',4039686,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','208320',4043439,'1640','222',2211402.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','208320',4043440,'1641','222',2421134.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','208320',4043441,'1642','222',3376907.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','208320',4043442,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','208320',4043443,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','208320',4043444,'1645','222',2613137.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','208320',4043445,'1646','223',906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','208320',4043446,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','208445',4045455,'1640','222',2211402.30,2211402.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','208445',4045456,'1641','222',1230920.20,1231159.72,239.52,39520.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','208445',4045457,'1642','222',3376907.89,3378895.94,1988.05,328028.25,0.00,0.00,0.00,0.00,0.00),('5','96','585','208445',4045458,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','208445',4045459,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','208445',4045460,'1645','222',2613137.45,2618038.33,4900.88,808645.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','208445',4045461,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','208445',4045462,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','208560',4047562,'1640','222',2211402.30,2211402.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','208560',4047563,'1641','222',1231159.72,1232801.97,1642.25,270971.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','208560',4047564,'1642','222',3378895.94,3381126.72,2230.78,368078.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','208560',4047565,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','208560',4047566,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','208560',4047567,'1645','222',2618038.33,2623009.61,4971.28,820261.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','208560',4047568,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','208560',4047569,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','208754',4051035,'1640','222',2211402.30,2213502.31,2100.01,346501.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','208754',4051036,'1641','222',1232801.97,1235452.75,2650.78,437378.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','208754',4051037,'1642','222',3381126.72,3385610.39,4483.67,739805.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','208754',4051038,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','208754',4051039,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','208754',4051040,'1645','222',2623009.61,2625828.12,2818.51,465054.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','208754',4051041,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','208754',4051042,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','208979',4054970,'1640','222',2213502.31,2216299.67,2797.36,461564.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','208979',4054971,'1641','222',1235452.75,1239378.25,3925.50,647707.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','208979',4054972,'1642','222',3385610.39,3389434.10,3823.71,630912.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','208979',4054973,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','208979',4054974,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','208979',4054975,'1645','222',2625828.12,2626803.89,975.77,161002.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','208979',4054976,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','208979',4054977,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','209227',4059088,'1640','222',2216299.67,2220416.40,4116.73,679260.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','209227',4059089,'1641','222',1239378.25,1243587.18,4208.93,694473.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','209227',4059090,'1642','222',3389434.10,3394473.80,5039.70,831550.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','209227',4059091,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','209227',4059092,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','209227',4059093,'1645','222',2626803.89,2626803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','209227',4059094,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','209227',4059095,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','209445',4062949,'1640','222',2220416.40,2222055.79,1639.39,270499.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','209445',4062950,'1641','222',1243587.18,1247453.57,3866.39,637954.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','209445',4062951,'1642','222',3394473.80,3400583.50,6109.70,1008100.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','209445',4062952,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','209445',4062953,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','209445',4062954,'1645','222',2626803.89,2626803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','209445',4062955,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','209445',4062956,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','209650',4066650,'1640','222',2222055.79,2225138.16,3082.37,508591.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','209650',4066651,'1641','222',1247453.57,1250005.91,2552.34,421136.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','209650',4066652,'1642','222',3400583.50,3403406.90,2823.40,465861.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','209650',4066653,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','209650',4066654,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','209650',4066655,'1645','222',2626803.89,2626803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','209650',4066656,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','209650',4066657,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','209876',4070604,'1640','222',2225138.16,2226367.43,1229.27,202829.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','209876',4070605,'1641','222',1250005.91,1250005.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','209876',4070606,'1642','222',3403406.90,3404247.09,840.19,138631.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','209876',4070607,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','209876',4070608,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','209876',4070609,'1645','222',2626803.89,2626803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','209876',4070610,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','209876',4070611,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','210110',4074842,'1640','222',2226367.43,2230767.69,4400.26,726042.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','210110',4074843,'1641','222',1250005.91,1250481.89,475.98,78536.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','210110',4074844,'1642','222',3404247.09,3409910.62,5663.53,934482.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','210110',4074845,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','210110',4074846,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','210110',4074847,'1645','222',2626803.89,2626803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','210110',4074848,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','210110',4074849,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','210317',4078477,'1640','222',2230767.69,2235408.56,4640.87,765743.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','210317',4078478,'1641','222',1250481.89,1250481.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','210317',4078479,'1642','222',3409910.62,3417026.50,7115.88,1174120.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','210317',4078480,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','210317',4078481,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','210317',4078482,'1645','222',2626803.89,2626803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','210317',4078483,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','210317',4078484,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','210612',4083883,'1640','222',2235408.56,2238570.87,3162.31,521781.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','210612',4083884,'1641','222',1250481.89,1253084.48,2602.59,429427.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','210612',4083885,'1642','222',3417026.50,3421294.15,4267.65,704162.25,0.00,0.00,0.00,0.00,0.00),('5','96','585','210612',4083886,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','210612',4083887,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','210612',4083888,'1645','222',2626803.89,2626803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','210612',4083889,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','210612',4083890,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','210741',4086097,'1640','222',2238570.87,2239003.51,432.64,71385.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','210741',4086098,'1641','222',1253084.48,1258564.26,5479.78,904163.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','210741',4086099,'1642','222',3421294.15,3427572.40,6278.25,1035911.25,0.00,0.00,0.00,0.00,0.00),('5','96','585','210741',4086100,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','210741',4086101,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','210741',4086102,'1645','222',2626803.89,2626803.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','210741',4086103,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','210741',4086104,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','210948',4089631,'1640','222',2239003.51,2240281.54,1278.03,210874.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','210948',4089632,'1641','222',1258564.26,1261678.88,3114.62,513912.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','210948',4089633,'1642','222',3427572.40,3432620.41,5048.01,832921.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','210948',4089634,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','210948',4089635,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','210948',4089636,'1645','222',2626803.89,2628740.50,1936.61,319540.65,0.00,0.00,0.00,0.00,0.00),('5','96','587','210948',4089637,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','210948',4089638,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','211287',4095663,'1640','222',2240281.54,2242291.11,2009.57,331579.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','211287',4095664,'1641','222',1261678.88,1265936.03,4257.15,702429.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','211287',4095665,'1642','222',3432620.41,3437575.00,4954.59,817507.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','211287',4095666,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','211287',4095667,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','211287',4095668,'1645','222',2628740.50,2629298.50,558.00,92070.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','211287',4095669,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','211287',4095670,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','211401',4097636,'1640','222',2242291.11,2246786.43,4495.32,741727.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','211401',4097637,'1641','222',1265936.03,1269449.40,3513.37,579706.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','211401',4097638,'1642','222',3437575.00,3442306.30,4731.30,780664.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','211401',4097639,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','211401',4097640,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','211401',4097641,'1645','222',2629298.50,2629774.70,476.20,78573.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','211401',4097642,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','211401',4097643,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','211599',4101236,'1640','222',2246786.43,2249363.81,2577.38,425267.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','211599',4101237,'1641','222',1269449.40,1273222.80,3773.40,622611.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','211599',4101238,'1642','222',3442306.30,3446628.82,4322.52,713215.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','211599',4101239,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','211599',4101240,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','211599',4101241,'1645','222',2629774.70,2631407.73,1633.03,269449.95,0.00,0.00,0.00,0.00,0.00),('5','96','587','211599',4101242,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','211599',4101243,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','211784',4104131,'1640','222',2249363.81,2251824.72,2460.91,406050.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','211784',4104132,'1641','222',1273222.80,1273604.25,381.45,62939.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','211784',4104133,'1642','222',3446628.82,3449925.50,3296.68,543952.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','211784',4104134,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','211784',4104135,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','211784',4104136,'1645','222',2631407.73,2636080.82,4673.09,771059.85,0.00,0.00,0.00,0.00,0.00),('5','96','587','211784',4104137,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','211784',4104138,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','211993',4107908,'1640','222',2251824.72,2254104.11,2279.39,376099.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','211993',4107909,'1641','222',1273604.25,1273839.64,235.39,38839.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','211993',4107910,'1642','222',3449925.50,3453820.39,3894.89,642656.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','211993',4107911,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','211993',4107912,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','211993',4107913,'1645','222',2636080.82,2639882.04,3801.22,627201.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','211993',4107914,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','211993',4107915,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','212229',4112114,'1640','222',2254104.11,2257687.15,3583.04,591201.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','212229',4112115,'1641','222',1273839.64,1273839.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','212229',4112116,'1642','222',3453820.39,3454930.48,1110.09,183164.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','212229',4112117,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','212229',4112118,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','212229',4112119,'1645','222',2639882.04,2647258.15,7376.11,1217058.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','212229',4112120,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','212229',4112121,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','212456',4116296,'1640','222',2257687.15,2261057.06,3369.91,556035.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','212456',4116297,'1641','222',1273839.64,1274958.82,1119.18,184664.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','212456',4116298,'1642','222',3454930.48,3455609.15,678.67,111980.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','212456',4116299,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','212456',4116300,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','212456',4116301,'1645','222',2647258.15,2652501.17,5243.02,865098.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','212456',4116302,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','212456',4116303,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','212655',4119965,'1640','222',2261057.06,2265498.48,4441.42,732834.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','212655',4119966,'1641','222',1274958.82,1274958.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','212655',4119967,'1642','222',3455609.15,3459877.86,4268.71,704337.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','212655',4119968,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','212655',4119969,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','212655',4119970,'1645','222',2652501.17,2656257.30,3756.13,619761.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','212655',4119971,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','212655',4119972,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','212876',4123709,'1640','222',2265498.48,2267664.02,2165.54,357314.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','212876',4123710,'1641','222',1274958.82,1274958.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','212876',4123711,'1642','222',3459877.86,3462246.30,2368.44,390792.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','212876',4123712,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','212876',4123713,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','212876',4123714,'1645','222',2656257.30,2657538.90,1281.60,211464.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','212876',4123715,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','212876',4123716,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','213155',4128467,'1640','222',2267664.02,2270505.66,2841.64,468870.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','213155',4128468,'1641','222',1274958.82,1275470.99,512.17,84508.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','213155',4128469,'1642','222',3462246.30,3465602.50,3356.20,553773.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','213155',4128470,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','213155',4128471,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','213155',4128472,'1645','222',2657538.90,2660926.10,3387.20,558888.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','213155',4128473,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','213155',4128474,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','213388',4132368,'1640','222',2270505.66,2273396.16,2890.50,476932.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','213388',4132369,'1641','222',1275470.99,1275470.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','213388',4132370,'1642','222',3465602.50,3469921.81,4319.31,712686.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','213388',4132371,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','213388',4132372,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','213388',4132373,'1645','222',2660926.10,2664326.62,3400.52,561085.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','213388',4132374,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','213388',4132375,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','213692',4137398,'1640','222',2273396.16,2276498.90,3102.74,511952.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','213692',4137399,'1641','222',1275470.99,1276922.24,1451.25,239456.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','213692',4137400,'1642','222',3469921.81,3474547.70,4625.89,763271.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','213692',4137401,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','213692',4137402,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','213692',4137403,'1645','222',2664326.62,2666514.39,2187.77,360982.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','213692',4137404,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','213692',4137405,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','213869',4140433,'1640','222',2276498.90,2279751.18,3252.28,536626.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','213869',4140434,'1641','222',1276922.24,1280640.15,3717.91,613455.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','213869',4140435,'1642','222',3474547.70,3479178.80,4631.10,764131.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','213869',4140436,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','213869',4140437,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','213869',4140438,'1645','222',2666514.39,2666514.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','213869',4140439,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','213869',4140440,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','214134',4144671,'1640','222',2279751.18,2281701.99,1950.81,321883.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','214134',4144672,'1641','222',1280640.15,1283742.07,3101.92,511816.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','214134',4144673,'1642','222',3479178.80,3483135.09,3956.29,652787.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','214134',4144674,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','214134',4144675,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','214134',4144676,'1645','222',2666514.39,2667993.11,1478.72,243988.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','214134',4144677,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','214134',4144678,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','214335',4148306,'1640','222',2281701.99,2282102.53,400.54,66089.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','214335',4148307,'1641','222',1283742.07,1286871.56,3129.49,516365.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','214335',4148308,'1642','222',3483135.09,3487194.55,4059.46,669810.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','214335',4148309,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','214335',4148310,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','214335',4148311,'1645','222',2667993.11,2671645.22,3652.11,602598.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','214335',4148312,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','214335',4148313,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','214520',4151515,'1640','222',2282102.53,2285361.35,3258.82,537705.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','214520',4151516,'1641','222',1286871.56,1289825.70,2954.14,487433.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','214520',4151517,'1642','222',3487194.55,3491538.67,4344.12,716779.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','214520',4151518,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','214520',4151519,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','214520',4151520,'1645','222',2671645.22,2672000.70,355.48,58654.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','214520',4151521,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','214520',4151522,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','214789',4156026,'1640','222',2285361.35,2289658.38,4297.03,709009.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','214789',4156027,'1641','222',1289825.70,1291055.73,1230.03,202954.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','214789',4156028,'1642','222',3491538.67,3494074.14,2535.47,418352.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','214789',4156029,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','214789',4156030,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','214789',4156031,'1645','222',2672000.70,2674358.34,2357.64,389010.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','214789',4156032,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','214789',4156033,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','215011',4159749,'1640','222',2289658.38,2290795.41,1137.03,187609.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','215011',4159750,'1641','222',1291055.73,1292353.28,1297.55,214095.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','215011',4159751,'1642','222',3494074.14,3498226.40,4152.26,685122.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','215011',4159752,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','215011',4159753,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','215011',4159754,'1645','222',2674358.34,2678001.71,3643.37,601156.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','215011',4159755,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','215011',4159756,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','215237',4163595,'1640','222',2290795.41,2292155.35,1359.94,224390.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','215237',4163596,'1641','222',1292353.28,1293756.00,1402.72,231448.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','215237',4163597,'1642','222',3498226.40,3502103.92,3877.52,639790.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','215237',4163598,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','215237',4163599,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','215237',4163600,'1645','222',2678001.71,2681688.26,3686.55,608280.75,0.00,0.00,0.00,0.00,0.00),('5','96','587','215237',4163601,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','215237',4163602,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','215454',4167140,'1640','222',2292155.35,2293745.79,1590.44,262422.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','215454',4167141,'1641','222',1293756.00,1296042.56,2286.56,377282.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','215454',4167142,'1642','222',3502103.92,3506589.29,4485.37,740086.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','215454',4167143,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','215454',4167144,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','215454',4167145,'1645','222',2681688.26,2685971.20,4282.94,706685.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','215454',4167146,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','215454',4167147,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','215678',4171121,'1640','222',2293745.79,2297575.93,3830.14,631973.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','215678',4171122,'1641','222',1296042.56,1296042.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','215678',4171123,'1642','222',3506589.29,3510976.79,4387.50,723937.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','215678',4171124,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','215678',4171125,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','215678',4171126,'1645','222',2685971.20,2687159.45,1188.25,196061.25,0.00,0.00,0.00,0.00,0.00),('5','96','587','215678',4171127,'1646','223',906461.50,906461.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','215678',4171128,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','215919',4175232,'1640','222',2297575.93,2297575.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','215919',4175233,'1641','222',1296042.56,1296606.86,564.30,93109.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','215919',4175234,'1642','222',3510976.79,3511335.37,358.58,59165.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','215919',4175235,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','215919',4175236,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','215919',4175237,'1645','222',2687159.45,2694360.51,7201.06,1188174.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','215919',4175238,'1646','223',906461.50,906548.14,86.64,25558.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','215919',4175239,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','216137',4178924,'1640','222',2297575.93,2297575.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','216137',4178925,'1641','222',1296606.86,1300469.00,3862.14,637253.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','216137',4178926,'1642','222',3511335.37,3515419.71,4084.34,673916.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','216137',4178927,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','216137',4178928,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','216137',4178929,'1645','222',2694360.51,2698835.47,4474.96,738368.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','216137',4178930,'1646','223',906548.14,906647.83,99.69,29408.55,0.00,0.00,0.00,0.00,0.00),('5','96','589','216137',4178931,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','216400',4183410,'1640','222',2297575.93,2297575.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','216400',4183411,'1641','222',1300469.00,1303589.84,3120.84,514938.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','216400',4183412,'1642','222',3515419.71,3519984.67,4564.96,753218.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','216400',4183413,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','216400',4183414,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','216400',4183415,'1645','222',2698835.47,2702376.53,3541.06,584274.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','216400',4183416,'1646','223',906647.83,906772.61,124.78,36810.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','216400',4183417,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','216551',4186257,'1640','222',2297575.93,2297575.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','216551',4186258,'1641','222',1303589.84,1306494.19,2904.35,479217.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','216551',4186259,'1642','222',3519984.67,3523238.50,3253.83,536881.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','216551',4186260,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','216551',4186261,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','216551',4186262,'1645','222',2702376.53,2705524.70,3148.17,519448.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','216551',4186263,'1646','223',906772.61,906993.04,220.43,65026.85,0.00,0.00,0.00,0.00,0.00),('5','96','589','216551',4186264,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','216787',4190493,'1640','222',2297575.93,2297575.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','216787',4190494,'1641','222',1306494.19,1309229.26,2735.07,451286.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','216787',4190495,'1642','222',3523238.50,3527676.21,4437.71,732222.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','216787',4190496,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','216787',4190497,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','216787',4190498,'1645','222',2705524.70,2708518.86,2994.16,494036.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','216787',4190499,'1646','223',906993.04,907232.28,239.24,70575.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','216787',4190500,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','217015',4194440,'1640','222',2297575.93,2297575.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','217015',4194441,'1641','222',1309229.26,1312859.09,3629.83,598921.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','217015',4194442,'1642','222',3527676.21,3532000.47,4324.26,713502.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','217015',4194443,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','217015',4194444,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','217015',4194445,'1645','222',2708518.86,2712509.96,3991.10,658531.50,0.00,0.00,0.00,0.00,0.00),('5','96','587','217015',4194446,'1646','223',907232.28,907430.99,198.71,58619.45,0.00,0.00,0.00,0.00,0.00),('5','96','589','217015',4194447,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','217290',4199520,'1640','222',2297575.93,2297900.34,324.41,53527.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','217290',4199521,'1641','222',1312859.09,1315501.85,2642.76,436055.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','217290',4199522,'1642','222',3532000.47,3536167.55,4167.08,687568.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','217290',4199523,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','217290',4199524,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','217290',4199525,'1645','222',2712509.96,2714929.84,2419.88,399280.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','217290',4199526,'1646','223',907430.99,907693.13,262.14,77331.30,0.00,0.00,0.00,0.00,0.00),('5','96','589','217290',4199527,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','217661',4206083,'1640','222',2297900.34,2302053.24,4152.90,685228.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','217661',4206084,'1641','222',1315501.85,1315729.46,227.61,37555.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','217661',4206085,'1642','222',3536167.55,3536636.13,468.58,77315.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','217661',4206086,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','217661',4206087,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','217661',4206088,'1645','222',2714929.84,2718536.87,3607.03,595159.95,0.00,0.00,0.00,0.00,0.00),('5','96','587','217661',4206089,'1646','223',907693.13,907865.14,172.01,50742.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','217661',4206090,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','217965',4211547,'1640','222',2302053.24,2306640.72,4587.48,756934.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','217965',4211548,'1641','222',1315729.46,1315729.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','217965',4211549,'1642','222',3536636.13,3536636.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','217965',4211550,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','217965',4211551,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','217965',4211552,'1645','222',2718536.87,2723094.91,4558.04,752076.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','217965',4211553,'1646','223',907865.14,908190.09,324.95,95860.25,0.00,0.00,0.00,0.00,0.00),('5','96','589','217965',4211554,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','217981',4211718,'1640','222',2306640.72,2311131.72,4491.00,741015.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','217981',4211719,'1641','222',1315729.46,1315729.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','217981',4211720,'1642','222',3536636.13,3536636.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','217981',4211721,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','217981',4211722,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','217981',4211723,'1645','222',2723094.91,2727193.41,4098.50,676252.50,0.00,0.00,0.00,0.00,0.00),('5','96','587','217981',4211724,'1646','223',908190.09,908312.72,122.63,36175.85,0.00,0.00,0.00,0.00,0.00),('5','96','589','217981',4211725,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','218245',4216079,'1640','222',2311131.72,2316239.78,5108.06,842829.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','218245',4216080,'1641','222',1315729.46,1315729.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','218245',4216081,'1642','222',3536636.13,3536636.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','218245',4216082,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','218245',4216083,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','218245',4216084,'1645','222',2727193.41,2729654.54,2461.13,406086.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','218245',4216085,'1646','223',908312.72,908525.16,212.44,62669.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','218245',4216086,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','218450',4219850,'1640','222',2316239.78,2322232.81,5993.03,988849.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','218450',4219851,'1641','222',1315729.46,1315729.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','218450',4219852,'1642','222',3536636.13,3536636.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','218450',4219853,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','218450',4219854,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','218450',4219855,'1645','222',2729654.54,2729654.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','218450',4219856,'1646','223',908525.16,908944.37,419.21,123666.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','218450',4219857,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','218885',4227727,'1640','222',2322232.81,2327295.73,5062.92,835381.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','218885',4227728,'1641','222',1315729.46,1315729.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','218885',4227729,'1642','222',3536636.13,3536636.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','218885',4227730,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','218885',4227731,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','218885',4227732,'1645','222',2729654.54,2729654.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','218885',4227733,'1646','223',908944.37,909189.27,244.90,72245.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','218885',4227734,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','218926',4228207,'1640','222',2327295.73,2328623.79,1328.06,219129.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','218926',4228208,'1641','222',1315729.46,1315729.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','218926',4228209,'1642','222',3536636.13,3536636.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','218926',4228210,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','218926',4228211,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','218926',4228212,'1645','222',2729654.54,2729654.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','218926',4228213,'1646','223',909189.27,909394.28,205.01,60477.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','218926',4228214,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','219150',4231940,'1640','222',2328623.79,2328623.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','219150',4231941,'1641','222',1315729.46,1315729.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','219150',4231942,'1642','222',3536636.13,3540201.10,3564.97,588220.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','219150',4231943,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','219150',4231944,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','219150',4231945,'1645','222',2729654.54,2729654.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','219150',4231946,'1646','223',909394.28,909649.05,254.77,75157.15,0.00,0.00,0.00,0.00,0.00),('5','96','589','219150',4231947,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','219344',4235384,'1640','222',2328623.79,2328623.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','219344',4235385,'1641','222',1315729.46,1315729.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','219344',4235386,'1642','222',3540201.10,3547835.15,7634.05,1259618.25,0.00,0.00,0.00,0.00,0.00),('5','96','585','219344',4235387,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','219344',4235388,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','219344',4235389,'1645','222',2729654.54,2729654.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','219344',4235390,'1646','223',909649.05,910120.11,471.06,138962.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','219344',4235391,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','219592',4239759,'1640','222',2328623.79,2328623.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','219592',4239760,'1641','222',1315729.46,1316765.33,1035.87,170918.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','219592',4239761,'1642','222',3547835.15,3553946.46,6111.31,1008366.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','219592',4239762,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','219592',4239763,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','219592',4239764,'1645','222',2729654.54,2731635.00,1980.46,326775.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','219592',4239765,'1646','223',910120.11,910369.94,249.83,73699.85,0.00,0.00,0.00,0.00,0.00),('5','96','589','219592',4239766,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','219827',4243843,'1640','222',2328623.79,2328623.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','219827',4243844,'1641','222',1316765.33,1318873.38,2108.05,347828.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','219827',4243845,'1642','222',3553946.46,3557272.24,3325.78,548753.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','219827',4243846,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','219827',4243847,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','219827',4243848,'1645','222',2731635.00,2734696.41,3061.41,505132.65,0.00,0.00,0.00,0.00,0.00),('5','96','587','219827',4243849,'1646','223',910369.94,910645.85,275.91,81393.45,0.00,0.00,0.00,0.00,0.00),('5','96','589','219827',4243850,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','220027',4247776,'1640','222',2328623.79,2328623.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','220027',4247777,'1641','222',1318873.38,1321542.21,2668.83,440356.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','220027',4247778,'1642','222',3557272.24,3560981.10,3708.86,611961.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','220027',4247779,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','220027',4247780,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','220027',4247781,'1645','222',2734696.41,2738423.80,3727.39,615019.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','220027',4247782,'1646','223',910645.85,911022.91,377.06,111232.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','220027',4247783,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','220259',4251628,'1640','222',2328623.79,2328623.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','220259',4251629,'1641','222',1321542.21,1324806.27,3264.06,538569.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','220259',4251630,'1642','222',3560981.10,3565292.40,4311.30,711364.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','220259',4251631,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','220259',4251632,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','220259',4251633,'1645','222',2738423.80,2743085.77,4661.97,769225.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','220259',4251634,'1646','223',911022.91,911357.00,334.09,98556.55,0.00,0.00,0.00,0.00,0.00),('5','96','589','220259',4251635,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','220475',4255628,'1640','222',2328623.79,2329397.91,774.12,127729.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','220475',4255629,'1641','222',1324806.27,1326057.83,1251.56,206507.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','220475',4255630,'1642','222',3565292.40,3568502.57,3210.17,529678.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','220475',4255631,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','220475',4255632,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','220475',4255633,'1645','222',2743085.77,2745994.31,2908.54,479909.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','220475',4255634,'1646','223',911357.00,911700.51,343.51,101335.45,0.00,0.00,0.00,0.00,0.00),('5','96','589','220475',4255635,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','220685',4259280,'1640','222',2329397.91,2332424.41,3026.50,499372.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','220685',4259281,'1641','222',1326057.83,1326057.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','220685',4259282,'1642','222',3568502.57,3571083.26,2580.69,425813.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','220685',4259283,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','220685',4259284,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','220685',4259285,'1645','222',2745994.31,2749518.26,3523.95,581451.75,0.00,0.00,0.00,0.00,0.00),('5','96','587','220685',4259286,'1646','223',911700.51,912037.84,337.33,99512.35,0.00,0.00,0.00,0.00,0.00),('5','96','589','220685',4259287,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','220918',4263346,'1640','222',2332424.41,2337478.69,5054.28,833956.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','220918',4263347,'1641','222',1326057.83,1326299.25,241.42,39834.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','220918',4263348,'1642','222',3571083.26,3571083.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','220918',4263349,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','220918',4263350,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','220918',4263351,'1645','222',2749518.26,2754349.21,4830.95,797106.75,0.00,0.00,0.00,0.00,0.00),('5','96','587','220918',4263352,'1646','223',912037.84,912393.29,355.45,104857.75,0.00,0.00,0.00,0.00,0.00),('5','96','589','220918',4263353,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','221137',4267324,'1640','222',2337478.69,2342042.49,4563.80,753027.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','221137',4267325,'1641','222',1326299.25,1326299.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','221137',4267326,'1642','222',3571083.26,3571083.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','221137',4267327,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','221137',4267328,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','221137',4267329,'1645','222',2754349.21,2759898.90,5549.69,915698.85,0.00,0.00,0.00,0.00,0.00),('5','96','587','221137',4267330,'1646','223',912393.29,912687.46,294.17,86780.15,0.00,0.00,0.00,0.00,0.00),('5','96','589','221137',4267331,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','221409',4272028,'1640','222',2342042.49,2346663.49,4621.00,762465.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','221409',4272029,'1641','222',1326299.25,1326299.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','221409',4272030,'1642','222',3571083.26,3571083.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','221409',4272031,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','221409',4272032,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','221409',4272033,'1645','222',2759898.90,2764710.67,4811.77,793942.05,0.00,0.00,0.00,0.00,0.00),('5','96','587','221409',4272034,'1646','223',912687.46,913060.80,373.34,110135.30,0.00,0.00,0.00,0.00,0.00),('5','96','589','221409',4272035,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','221616',4276069,'1640','222',2346663.49,2352510.24,5846.75,964713.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','221616',4276070,'1641','222',1326299.25,1326299.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','221616',4276071,'1642','222',3571083.26,3571083.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','221616',4276072,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','221616',4276073,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','221616',4276074,'1645','222',2764710.67,2769555.32,4844.65,799367.25,0.00,0.00,0.00,0.00,0.00),('5','96','587','221616',4276075,'1646','223',913060.80,914092.00,1031.20,304204.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','221616',4276076,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','221842',4279873,'1640','222',2352510.24,2356212.33,3702.09,610844.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','221842',4279874,'1641','222',1326299.25,1330202.38,3903.13,644016.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','221842',4279875,'1642','222',3571083.26,3571085.27,2.01,331.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','221842',4279876,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','221842',4279877,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','221842',4279878,'1645','222',2769555.32,2773323.52,3768.20,621753.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','221842',4279879,'1646','223',914092.00,914092.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','221842',4279880,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','222073',4284165,'1640','222',2356212.33,2359879.83,3667.50,605137.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','222073',4284166,'1641','222',1330202.38,1332911.68,2709.30,447034.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','222073',4284167,'1642','222',3571085.27,3574119.21,3033.94,500600.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','222073',4284168,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','222073',4284169,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','222073',4284170,'1645','222',2773323.52,2774448.50,1124.98,185621.70,0.00,0.00,0.00,0.00,0.00),('5','96','587','222073',4284171,'1646','223',914092.00,914577.10,485.10,143104.50,0.00,0.00,0.00,0.00,0.00),('5','96','589','222073',4284172,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','222275',4287558,'1640','222',2359879.83,2362725.84,2846.01,469591.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','222275',4287559,'1641','222',1332911.68,1335322.20,2410.52,397735.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','222275',4287560,'1642','222',3574119.21,3577952.48,3833.27,632489.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','222275',4287561,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','222275',4287562,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','222275',4287563,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','222275',4287564,'1646','223',914577.10,914971.79,394.69,116433.55,0.00,0.00,0.00,0.00,0.00),('5','96','589','222275',4287565,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','222507',4291524,'1640','222',2362725.84,2365524.37,2798.53,461757.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','222507',4291525,'1641','222',1335322.20,1338438.14,3115.94,514130.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','222507',4291526,'1642','222',3577952.48,3581792.23,3839.75,633558.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','222507',4291527,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','222507',4291528,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','222507',4291529,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','222507',4291530,'1646','223',914971.79,915229.80,258.01,76112.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','222507',4291531,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','222731',4295764,'1640','222',2365524.37,2366894.99,1370.62,226152.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','222731',4295765,'1641','222',1338438.14,1340504.70,2066.56,340982.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','222731',4295766,'1642','222',3581792.23,3583976.43,2184.20,360393.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','222731',4295767,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','222731',4295768,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','222731',4295769,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','222731',4295770,'1646','223',915229.80,915418.86,189.06,55772.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','222731',4295771,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','222938',4299657,'1640','222',2366894.99,2368558.04,1663.05,274403.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','222938',4299658,'1641','222',1340504.70,1344312.94,3808.24,628359.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','222938',4299659,'1642','222',3583976.43,3589226.58,5250.15,866274.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','222938',4299660,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','222938',4299661,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','222938',4299662,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','222938',4299663,'1646','223',915418.86,915711.70,292.84,86387.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','222938',4299664,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','223169',4303692,'1640','222',2368558.04,2368775.38,217.34,35861.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','223169',4303693,'1641','222',1344312.94,1345600.23,1287.29,212402.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','223169',4303694,'1642','222',3589226.58,3591547.90,2321.32,383017.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','223169',4303695,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','223169',4303696,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','223169',4303697,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','223169',4303698,'1646','223',915711.70,916280.82,569.12,167890.40,0.00,0.00,0.00,0.00,0.00),('5','96','589','223169',4303699,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','223616',4311753,'1640','222',2368775.38,2368775.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','223616',4311754,'1641','222',1345600.23,1345600.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','223616',4311755,'1642','222',3591547.90,3591547.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','223616',4311756,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','223616',4311757,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','223616',4311758,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','223616',4311759,'1646','223',916280.82,917087.20,806.38,237882.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','223616',4311760,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','223648',4312106,'1640','222',2368775.38,2368775.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','223648',4312107,'1641','222',1345600.23,1345600.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','223648',4312108,'1642','222',3591547.90,3591547.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','223648',4312109,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','223648',4312110,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','223648',4312111,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','223648',4312112,'1646','223',917087.20,917568.58,481.38,142007.10,0.00,0.00,0.00,0.00,0.00),('5','96','589','223648',4312113,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','223918',4316936,'1640','222',2368775.38,2368775.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','223918',4316937,'1641','222',1345600.23,1347574.87,1974.64,325815.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','223918',4316938,'1642','222',3591547.90,3593947.47,2399.57,395929.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','223918',4316939,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','223918',4316940,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','223918',4316941,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','223918',4316942,'1646','223',917568.58,917966.44,397.86,117368.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','223918',4316943,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','224080',4319941,'1640','222',2368775.38,2368775.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','224080',4319942,'1641','222',1347574.87,1351162.03,3587.16,591881.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','224080',4319943,'1642','222',3593947.47,3598314.59,4367.12,720574.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','224080',4319944,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','224080',4319945,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','224080',4319946,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','224080',4319947,'1646','223',917966.44,918575.25,608.81,179598.95,0.00,0.00,0.00,0.00,0.00),('5','96','589','224080',4319948,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','224322',4324224,'1640','222',2368775.38,2368775.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','224322',4324225,'1641','222',1351162.03,1354404.19,3242.16,534956.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','224322',4324226,'1642','222',3598314.59,3603029.44,4714.85,777950.25,0.00,0.00,0.00,0.00,0.00),('5','96','585','224322',4324227,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','224322',4324228,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','224322',4324229,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','224322',4324230,'1646','223',918575.25,919009.47,434.22,128094.90,0.00,0.00,0.00,0.00,0.00),('5','96','589','224322',4324231,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','224558',4328268,'1640','222',2368775.38,2368775.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','224558',4328269,'1641','222',1354404.19,1357691.54,3287.35,542412.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','224558',4328270,'1642','222',3603029.44,3607151.92,4122.48,680209.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','224558',4328271,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','224558',4328272,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','224558',4328273,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','224558',4328274,'1646','223',919009.47,919506.26,496.79,146553.05,0.00,0.00,0.00,0.00,0.00),('5','96','589','224558',4328275,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','224817',4332754,'1640','222',2368775.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','224817',4332755,'1641','222',1357691.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','224817',4332756,'1642','222',3607151.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','224817',4332757,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','224817',4332758,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','224817',4332759,'1645','222',2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','224817',4332760,'1646','223',919506.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','224817',4332761,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','224862',4333582,'1640','222',2368775.38,2370908.84,2133.46,347753.98,0.00,0.00,0.00,0.00,0.00),('5','96','584','224862',4333583,'1641','222',1357691.54,1360531.56,2840.02,462923.26,0.00,0.00,0.00,0.00,0.00),('5','96','584','224862',4333584,'1642','222',3607151.92,3611357.43,4205.51,685498.13,0.00,0.00,0.00,0.00,0.00),('5','96','585','224862',4333585,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','224862',4333586,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','224862',4333587,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','224862',4333588,'1646','223',919506.26,920065.68,559.42,165028.90,0.00,0.00,0.00,0.00,0.00),('5','96','589','224862',4333589,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','225029',4336634,'1640','222',2370908.84,2374934.26,4025.42,656143.46,0.00,0.00,0.00,0.00,0.00),('5','96','584','225029',4336635,'1641','222',1360531.56,1363475.77,2944.21,479906.23,0.00,0.00,0.00,0.00,0.00),('5','96','584','225029',4336636,'1642','222',3611357.43,3615881.85,4524.42,737480.46,0.00,0.00,0.00,0.00,0.00),('5','96','585','225029',4336637,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','225029',4336638,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','225029',4336639,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','225029',4336640,'1646','223',920065.68,920406.94,341.26,100671.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','225029',4336641,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','225303',4341548,'1640','222',2374934.26,2378455.23,3520.97,573918.11,0.00,0.00,0.00,0.00,0.00),('5','96','584','225303',4341549,'1641','222',1363475.77,1365437.36,1961.59,319739.17,0.00,0.00,0.00,0.00,0.00),('5','96','584','225303',4341550,'1642','222',3615881.85,3618636.49,2754.64,449006.32,0.00,0.00,0.00,0.00,0.00),('5','96','585','225303',4341551,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','225303',4341552,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','225303',4341553,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','225303',4341554,'1646','223',920406.94,920774.45,367.51,108415.45,0.00,0.00,0.00,0.00,0.00),('5','96','589','225303',4341555,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','225496',4345217,'1640','222',2378455.23,2381663.86,3208.63,523006.69,0.00,0.00,0.00,0.00,0.00),('5','96','584','225496',4345218,'1641','222',1365437.36,1367782.22,2344.86,382212.18,0.00,0.00,0.00,0.00,0.00),('5','96','584','225496',4345219,'1642','222',3618636.49,3622441.32,3804.83,620187.29,0.00,0.00,0.00,0.00,0.00),('5','96','585','225496',4345220,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','225496',4345221,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','225496',4345222,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','225496',4345223,'1646','223',920774.45,921161.71,387.26,114241.70,0.00,0.00,0.00,0.00,0.00),('5','96','589','225496',4345224,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','225715',4348862,'1640','222',2381663.86,2384553.47,2889.61,471006.43,0.00,0.00,0.00,0.00,0.00),('5','96','584','225715',4348863,'1641','222',1367782.22,1371133.00,3350.78,546177.14,0.00,0.00,0.00,0.00,0.00),('5','96','584','225715',4348864,'1642','222',3622441.32,3626595.44,4154.12,677121.56,0.00,0.00,0.00,0.00,0.00),('5','96','585','225715',4348865,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','225715',4348866,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','225715',4348867,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','225715',4348868,'1646','223',921161.71,921402.35,240.64,70988.80,0.00,0.00,0.00,0.00,0.00),('5','96','589','225715',4348869,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','225970',4353348,'1640','222',2384553.47,2387613.27,3059.80,498747.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','225970',4353349,'1641','222',1371133.00,1374055.92,2922.92,476435.96,0.00,0.00,0.00,0.00,0.00),('5','96','584','225970',4353350,'1642','222',3626595.44,3630872.66,4277.22,697186.86,0.00,0.00,0.00,0.00,0.00),('5','96','585','225970',4353351,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','225970',4353352,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','225970',4353353,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','225970',4353354,'1646','223',921402.35,921410.54,8.19,2416.05,0.00,0.00,0.00,0.00,0.00),('5','96','589','225970',4353355,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','226292',4359137,'1640','222',2387613.27,2390167.99,2554.72,416419.36,0.00,0.00,0.00,0.00,0.00),('5','96','584','226292',4359138,'1641','222',1374055.92,1377105.70,3049.78,497114.14,0.00,0.00,0.00,0.00,0.00),('5','96','584','226292',4359139,'1642','222',3630872.66,3634305.15,3432.49,559495.87,0.00,0.00,0.00,0.00,0.00),('5','96','585','226292',4359140,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','226292',4359141,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','226292',4359142,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','226292',4359143,'1646','223',921410.54,921410.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','226292',4359144,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','226503',4362940,'1640','222',2390167.99,2393223.39,3055.40,498030.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','226503',4362941,'1641','222',1377105.70,1379991.26,2885.56,470346.28,0.00,0.00,0.00,0.00,0.00),('5','96','584','226503',4362942,'1642','222',3634305.15,3638813.36,4508.21,734838.23,0.00,0.00,0.00,0.00,0.00),('5','96','585','226503',4362943,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','226503',4362944,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','226503',4362945,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','226503',4362946,'1646','223',921410.54,921410.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','226503',4362947,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','226785',4368015,'1640','222',2393223.39,2397162.30,3938.91,642042.33,0.00,0.00,0.00,0.00,0.00),('5','96','584','226785',4368016,'1641','222',1379991.26,1383579.13,3587.87,584822.81,0.00,0.00,0.00,0.00,0.00),('5','96','584','226785',4368017,'1642','222',3638813.36,3643235.70,4422.34,720841.42,0.00,0.00,0.00,0.00,0.00),('5','96','585','226785',4368018,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','226785',4368019,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','226785',4368020,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','226785',4368021,'1646','223',921410.54,921410.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','226785',4368022,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','227073',4373112,'1640','222',2397162.30,2397947.17,784.87,127933.81,0.00,0.00,0.00,0.00,0.00),('5','96','584','227073',4373113,'1641','222',1383579.13,1383958.10,378.97,61772.11,0.00,0.00,0.00,0.00,0.00),('5','96','584','227073',4373114,'1642','222',3643235.70,3643235.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','227073',4373115,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','227073',4373116,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','227073',4373117,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','227073',4373118,'1646','223',921410.54,921410.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','227073',4373119,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','227188',4375272,'1640','222',2397947.17,2401409.90,3462.73,564424.99,0.00,0.00,0.00,0.00,0.00),('5','96','584','227188',4375273,'1641','222',1383958.10,1387094.01,3135.91,511153.33,0.00,0.00,0.00,0.00,0.00),('5','96','584','227188',4375274,'1642','222',3643235.70,3647316.02,4080.32,665092.16,0.00,0.00,0.00,0.00,0.00),('5','96','585','227188',4375275,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','227188',4375276,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','227188',4375277,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','227188',4375278,'1646','223',921410.54,921410.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','227188',4375279,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','227369',4378520,'1640','222',2401409.90,2405479.73,4069.83,663382.29,0.00,0.00,0.00,0.00,0.00),('5','96','584','227369',4378521,'1641','222',1387094.01,1391108.00,4013.99,654280.37,0.00,0.00,0.00,0.00,0.00),('5','96','584','227369',4378522,'1642','222',3647316.02,3651758.61,4442.59,724142.17,0.00,0.00,0.00,0.00,0.00),('5','96','585','227369',4378523,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','227369',4378524,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','227369',4378525,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','227369',4378526,'1646','223',921410.54,921410.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','227369',4378527,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','227607',4382560,'1640','222',2405479.73,2408997.20,3517.47,573347.61,0.00,0.00,0.00,0.00,0.00),('5','96','584','227607',4382561,'1641','222',1391108.00,1396229.02,5121.02,834726.26,0.00,0.00,0.00,0.00,0.00),('5','96','584','227607',4382562,'1642','222',3651758.61,3657683.91,5925.30,965823.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','227607',4382563,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','227607',4382564,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','227607',4382565,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','227607',4382566,'1646','223',921410.54,921410.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','227607',4382567,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','227901',4387781,'1640','222',2408997.20,2413031.35,4034.15,657566.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','227901',4387782,'1641','222',1396229.02,1400720.69,4491.67,732142.21,0.00,0.00,0.00,0.00,0.00),('5','96','584','227901',4387783,'1642','222',3657683.91,3663239.39,5555.48,905543.24,0.00,0.00,0.00,0.00,0.00),('5','96','585','227901',4387784,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','227901',4387785,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','227901',4387786,'1645','222',2774448.50,2774448.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','227901',4387787,'1646','223',921410.54,921410.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','227901',4387788,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230326',4433605,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230326',4433606,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230326',4433607,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230326',4433608,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230326',4433609,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230326',4433610,'1645','222',2780236.35,2789280.50,9044.15,1474196.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','230326',4433611,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230326',4433612,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230697',4440945,'1640','222',2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230697',4440946,'1641','222',2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230697',4440947,'1642','222',3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230697',4440948,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230697',4440949,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230697',4440950,'1645','222',2789280.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','230697',4440951,'1646','223',1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230697',4440952,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230844',4443183,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230844',4443184,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230844',4443185,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230844',4443186,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230844',4443187,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230844',4443188,'1645','222',2789280.50,2798407.78,9127.28,1487746.64,0.00,0.00,0.00,0.00,0.00),('5','96','587','230844',4443189,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230844',4443190,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230853',4443267,'1640','222',2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230853',4443268,'1641','222',2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230853',4443269,'1642','222',3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230853',4443270,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230853',4443271,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230853',4443272,'1645','222',2798407.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','230853',4443273,'1646','223',1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230853',4443274,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230857',4443298,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230857',4443299,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230857',4443300,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230857',4443301,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230857',4443302,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230857',4443303,'1645','222',2798407.78,2803261.37,4853.59,791135.17,0.00,0.00,0.00,0.00,0.00),('5','96','587','230857',4443304,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230857',4443305,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230871',4443536,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230871',4443537,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230871',4443538,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230871',4443539,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230871',4443540,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230871',4443541,'1645','222',2803261.37,2804329.01,1067.64,174025.32,0.00,0.00,0.00,0.00,0.00),('5','96','587','230871',4443542,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230871',4443543,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230919',4444378,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230919',4444379,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230919',4444380,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230919',4444381,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230919',4444382,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230919',4444383,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','230919',4444384,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230919',4444385,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230920',4444386,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230920',4444387,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230920',4444388,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230920',4444389,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230920',4444390,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230920',4444391,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','230920',4444392,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230920',4444393,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230923',4444447,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230923',4444448,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230923',4444449,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230923',4444450,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230923',4444451,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230923',4444452,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','230923',4444453,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230923',4444454,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','230928',4444522,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230928',4444523,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','230928',4444524,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230928',4444525,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','230928',4444526,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','230928',4444527,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','230928',4444528,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','230928',4444529,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231020',4446354,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','231020',4446355,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','231020',4446356,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231020',4446357,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231020',4446358,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231020',4446359,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','231020',4446360,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231020',4446361,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231032',4446577,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','231032',4446578,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','231032',4446579,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231032',4446580,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231032',4446581,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231032',4446582,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','231032',4446583,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231032',4446584,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231033',4446585,'1640','222',2413613.09,2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','231033',4446586,'1641','222',2421134.00,2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','231033',4446587,'1642','222',3667666.04,3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231033',4446588,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231033',4446589,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231033',4446590,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','231033',4446591,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231033',4446592,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231034',4446593,'1640','222',2413613.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','231034',4446594,'1641','222',2421134.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','231034',4446595,'1642','222',3667666.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231034',4446596,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231034',4446597,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231034',4446598,'1645','222',2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','231034',4446599,'1646','223',1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231034',4446600,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231166',4448700,'1640','222',2413613.09,2416115.65,2502.56,407917.28,0.00,0.00,0.00,0.00,0.00),('5','96','584','231166',4448701,'1641','222',1404383.06,1407016.86,2633.80,429309.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','231166',4448702,'1642','222',3667666.04,3672921.93,5255.89,856710.07,0.00,0.00,0.00,0.00,0.00),('5','96','585','231166',4448703,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231166',4448704,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231166',4448705,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','231166',4448706,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231166',4448707,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231354',4451686,'1640','222',2416115.65,2418715.44,2599.79,423765.77,0.00,0.00,0.00,0.00,0.00),('5','96','584','231354',4451687,'1641','222',1407016.86,1410286.27,3269.41,532913.83,0.00,0.00,0.00,0.00,0.00),('5','96','584','231354',4451688,'1642','222',3672921.93,3677691.00,4769.07,777358.41,0.00,0.00,0.00,0.00,0.00),('5','96','585','231354',4451689,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231354',4451690,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231354',4451691,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','231354',4451692,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231354',4451693,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231456',4453101,'1640','222',2418715.44,2421348.60,2633.16,429205.08,0.00,0.00,0.00,0.00,0.00),('5','96','584','231456',4453102,'1641','222',1410286.27,1414478.69,4192.42,683364.46,0.00,0.00,0.00,0.00,0.00),('5','96','584','231456',4453103,'1642','222',3677691.00,3682907.18,5216.18,850237.34,0.00,0.00,0.00,0.00,0.00),('5','96','585','231456',4453104,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231456',4453105,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231456',4453106,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','231456',4453107,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231456',4453108,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231639',4456423,'1640','222',2421348.60,2425589.35,4240.75,691242.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','231639',4456424,'1641','222',1414478.69,1420143.72,5665.03,923399.89,0.00,0.00,0.00,0.00,0.00),('5','96','584','231639',4456425,'1642','222',3682907.18,3688276.35,5369.17,875174.71,0.00,0.00,0.00,0.00,0.00),('5','96','585','231639',4456426,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231639',4456427,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231639',4456428,'1645','222',2804329.01,2804329.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','231639',4456429,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231639',4456430,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','231914',4461293,'1640','222',2425589.35,2425955.21,365.86,59635.18,0.00,0.00,0.00,0.00,0.00),('5','96','584','231914',4461294,'1641','222',1420143.72,1424112.10,3968.38,646845.94,0.00,0.00,0.00,0.00,0.00),('5','96','584','231914',4461295,'1642','222',3688276.35,3692553.29,4276.94,697141.22,0.00,0.00,0.00,0.00,0.00),('5','96','585','231914',4461296,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','231914',4461297,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','231914',4461298,'1645','222',2804329.01,2806254.32,1925.31,313825.53,0.00,0.00,0.00,0.00,0.00),('5','96','587','231914',4461299,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','231914',4461300,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','232116',4465035,'1640','222',2425955.21,2430896.10,4940.89,805365.07,0.00,0.00,0.00,0.00,0.00),('5','96','584','232116',4465036,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','232116',4465037,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','232116',4465038,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','232116',4465039,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','232116',4465040,'1645','222',2806254.32,2812522.45,6268.13,1021705.19,0.00,0.00,0.00,0.00,0.00),('5','96','587','232116',4465041,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','232116',4465042,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','232343',4469040,'1640','222',2430896.10,2432019.86,1123.76,183172.88,0.00,0.00,0.00,0.00,0.00),('5','96','584','232343',4469041,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','232343',4469042,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','232343',4469043,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','232343',4469044,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','232343',4469045,'1645','222',2812522.45,2821122.84,8600.39,1401863.57,0.00,0.00,0.00,0.00,0.00),('5','96','587','232343',4469046,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','232343',4469047,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','232620',4474021,'1640','222',2432019.86,2432019.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','232620',4474022,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','232620',4474023,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','232620',4474024,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','232620',4474025,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','232620',4474026,'1645','222',2821122.84,2829390.62,8267.78,1347648.14,0.00,0.00,0.00,0.00,0.00),('5','96','587','232620',4474027,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','232620',4474028,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','232844',4478207,'1640','222',2432019.86,2433292.19,1272.33,207389.79,0.00,0.00,0.00,0.00,0.00),('5','96','584','232844',4478208,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','232844',4478209,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','232844',4478210,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','232844',4478211,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','232844',4478212,'1645','222',2829390.62,2833908.72,4518.10,736450.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','232844',4478213,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','232844',4478214,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','233263',4485687,'1640','222',2433292.19,2439548.63,6256.44,1019799.72,0.00,0.00,0.00,0.00,0.00),('5','96','584','233263',4485688,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','233263',4485689,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','233263',4485690,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','233263',4485691,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','233263',4485692,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','233263',4485693,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','233263',4485694,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','233384',4487900,'1640','222',2439548.63,2442056.75,2508.12,408823.56,0.00,0.00,0.00,0.00,0.00),('5','96','584','233384',4487901,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','233384',4487902,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','233384',4487903,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','233384',4487904,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','233384',4487905,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','233384',4487906,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','233384',4487907,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','233616',4492143,'1640','222',2442056.75,2443701.11,1644.36,268030.68,0.00,0.00,0.00,0.00,0.00),('5','96','584','233616',4492144,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','233616',4492145,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','233616',4492146,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','233616',4492147,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','233616',4492148,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','233616',4492149,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','233616',4492150,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','234007',4499267,'1640','222',2443701.11,2449371.83,5670.72,924327.36,0.00,0.00,0.00,0.00,0.00),('5','96','584','234007',4499268,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234007',4499269,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234007',4499270,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234007',4499271,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','234007',4499272,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','234007',4499273,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','234007',4499274,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','234159',4501999,'1640','222',2449371.83,2454084.88,4713.05,768227.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','234159',4502000,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234159',4502001,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234159',4502002,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234159',4502003,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','234159',4502004,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','234159',4502005,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','234159',4502006,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','234316',4504727,'1640','222',2454084.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234316',4504728,'1641','222',1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234316',4504729,'1642','222',3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234316',4504730,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234316',4504731,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','234316',4504732,'1645','222',2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','234316',4504733,'1646','223',1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','234316',4504734,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','234702',4511613,'1640','222',2454084.88,2455672.53,1587.65,261962.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','234702',4511614,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234702',4511615,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234702',4511616,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234702',4511617,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','234702',4511618,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','234702',4511619,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','234702',4511620,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','234908',4515424,'1640','222',2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234908',4515425,'1641','222',1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234908',4515426,'1642','222',3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234908',4515427,'1643','222',1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234908',4515428,'1644','222',957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','234908',4515429,'1645','222',2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','234908',4515430,'1646','223',1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','234908',4515431,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','234912',4515487,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234912',4515488,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234912',4515489,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234912',4515490,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234912',4515491,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','234912',4515492,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','234912',4515493,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','234912',4515494,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','234916',4515549,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234916',4515550,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','234916',4515551,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234916',4515552,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','234916',4515553,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','234916',4515554,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','234916',4515555,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','234916',4515556,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','235107',4518749,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','235107',4518750,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','235107',4518751,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','235107',4518752,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','235107',4518753,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','235107',4518754,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','235107',4518755,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','235107',4518756,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','235406',4524048,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','235406',4524049,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','235406',4524050,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','235406',4524051,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','235406',4524052,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','235406',4524053,'1645','222',2833908.72,2833908.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','235406',4524054,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','235406',4524055,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','235650',4528173,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','235650',4528174,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','235650',4528175,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','235650',4528176,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','235650',4528177,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','235650',4528178,'1645','222',2833908.72,2842668.65,8759.93,1445388.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','235650',4528179,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','235650',4528180,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','235803',4530946,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','235803',4530947,'1641','222',1424112.10,1424112.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','235803',4530948,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','235803',4530949,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','235803',4530950,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','235803',4530951,'1645','222',2842668.65,2853283.57,10614.92,1751461.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','235803',4530952,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','235803',4530953,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','236101',4536215,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','236101',4536216,'1641','222',1424112.10,1425041.97,929.87,153428.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','236101',4536217,'1642','222',3692553.29,3692553.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','236101',4536218,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','236101',4536219,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','236101',4536220,'1645','222',2853283.57,2863083.48,9799.91,1616985.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','236101',4536221,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','236101',4536222,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','236351',4540730,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','236351',4540731,'1641','222',1425041.97,1435670.18,10628.21,1753654.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','236351',4540732,'1642','222',3692553.29,3697702.10,5148.81,849553.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','236351',4540733,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','236351',4540734,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','236351',4540735,'1645','222',2863083.48,2863929.60,846.12,139609.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','236351',4540736,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','236351',4540737,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','236529',4543717,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','236529',4543718,'1641','222',1435670.18,1441350.02,5679.84,937173.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','236529',4543719,'1642','222',3697702.10,3703944.98,6242.88,1030075.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','236529',4543720,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','236529',4543721,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','236529',4543722,'1645','222',2863929.60,2869970.43,6040.83,996736.95,0.00,0.00,0.00,0.00,0.00),('5','96','587','236529',4543723,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','236529',4543724,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','236760',4547534,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','236760',4547535,'1641','222',1441350.02,1441350.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','236760',4547536,'1642','222',3703944.98,3704963.15,1018.17,167998.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','236760',4547537,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','236760',4547538,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','236760',4547539,'1645','222',2869970.43,2879126.47,9156.04,1510746.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','236760',4547540,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','236760',4547541,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','237014',4552189,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','237014',4552190,'1641','222',1441350.02,1441350.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','237014',4552191,'1642','222',3704963.15,3704963.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237014',4552192,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237014',4552193,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','237014',4552194,'1645','222',2879126.47,2889277.13,10150.66,1674858.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','237014',4552195,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','237014',4552196,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','237230',4555916,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','237230',4555917,'1641','222',1441350.02,1441350.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','237230',4555918,'1642','222',3704963.15,3704963.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237230',4555919,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237230',4555920,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','237230',4555921,'1645','222',2889277.13,2892189.59,2912.46,480555.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','237230',4555922,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','237230',4555923,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','237402',4559153,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','237402',4559154,'1641','222',1441350.02,1441571.59,221.57,36559.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','237402',4559155,'1642','222',3704963.15,3704963.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237402',4559156,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237402',4559157,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','237402',4559158,'1645','222',2892189.59,2893550.31,1360.72,224518.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','237402',4559159,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','237402',4559160,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','237676',4563864,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','237676',4563865,'1641','222',1441571.59,1441571.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','237676',4563866,'1642','222',3704963.15,3704963.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237676',4563867,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237676',4563868,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','237676',4563869,'1645','222',2893550.31,2893550.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','237676',4563870,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','237676',4563871,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','237908',4567610,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','237908',4567611,'1641','222',1441571.59,1446846.08,5274.49,870290.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','237908',4567612,'1642','222',3704963.15,3704963.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237908',4567613,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','237908',4567614,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','237908',4567615,'1645','222',2893550.31,2893550.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','237908',4567616,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','237908',4567617,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','238131',4571209,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','238131',4571210,'1641','222',1446846.08,1453832.67,6986.59,1152787.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','238131',4571211,'1642','222',3704963.15,3707354.92,2391.77,394642.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','238131',4571212,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','238131',4571213,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','238131',4571214,'1645','222',2893550.31,2893550.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','238131',4571215,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','238131',4571216,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','238434',4576600,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','238434',4576601,'1641','222',1453832.67,1458863.61,5030.94,830105.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','238434',4576602,'1642','222',3707354.92,3712967.21,5612.29,926027.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','238434',4576603,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','238434',4576604,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','238434',4576605,'1645','222',2893550.31,2893550.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','238434',4576606,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','238434',4576607,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','238704',4581217,'1640','222',2455672.53,2455672.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','238704',4581218,'1641','222',1458863.61,1463324.60,4460.99,736063.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','238704',4581219,'1642','222',3712967.21,3718436.63,5469.42,902454.30,0.00,0.00,0.00,0.00,0.00),('5','96','585','238704',4581220,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','238704',4581221,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','238704',4581222,'1645','222',2893550.31,2893550.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','238704',4581223,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','238704',4581224,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','238839',4583508,'1640','222',2455672.53,2458398.67,2726.14,449813.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','238839',4583509,'1641','222',1463324.60,1466486.26,3161.66,521673.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','238839',4583510,'1642','222',3718436.63,3722897.56,4460.93,736053.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','238839',4583511,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','238839',4583512,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','238839',4583513,'1645','222',2893550.31,2893550.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','238839',4583514,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','238839',4583515,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','239128',4588736,'1640','222',2458398.67,2462560.82,4162.15,686754.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','239128',4588737,'1641','222',1466486.26,1467637.27,1151.01,189916.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','239128',4588738,'1642','222',3722897.56,3723980.49,1082.93,178683.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','239128',4588739,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','239128',4588740,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','239128',4588741,'1645','222',2893550.31,2897906.87,4356.56,718832.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','239128',4588742,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','239128',4588743,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','239347',4592415,'1640','222',2462560.82,2467020.44,4459.62,735837.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','239347',4592416,'1641','222',1467637.27,1467637.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','239347',4592417,'1642','222',3723980.49,3723980.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','239347',4592418,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','239347',4592419,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','239347',4592420,'1645','222',2897906.87,2904174.26,6267.39,1034119.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','239347',4592421,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','239347',4592422,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','239605',4596878,'1640','222',2467020.44,2468926.53,1906.09,314504.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','239605',4596879,'1641','222',1467637.27,1472120.24,4482.97,739690.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','239605',4596880,'1642','222',3723980.49,3723980.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','239605',4596881,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','239605',4596882,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','239605',4596883,'1645','222',2904174.26,2908785.49,4611.23,760852.95,0.00,0.00,0.00,0.00,0.00),('5','96','587','239605',4596884,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','239605',4596885,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','239789',4600003,'1640','222',2468926.53,2468926.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','239789',4600004,'1641','222',1472120.24,1475646.96,3526.72,581908.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','239789',4600005,'1642','222',3723980.49,3727931.18,3950.69,651863.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','239789',4600006,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','239789',4600007,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','239789',4600008,'1645','222',2908785.49,2912409.38,3623.89,597941.85,0.00,0.00,0.00,0.00,0.00),('5','96','587','239789',4600009,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','239789',4600010,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','240051',4604623,'1640','222',2468926.53,2470645.50,1718.97,283630.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','240051',4604624,'1641','222',1475646.96,1479908.24,4261.28,703111.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','240051',4604625,'1642','222',3727931.18,3732906.32,4975.14,820898.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','240051',4604626,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','240051',4604627,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','240051',4604628,'1645','222',2912409.38,2915003.14,2593.76,427970.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','240051',4604629,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','240051',4604630,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','240411',4610869,'1640','222',2470645.50,2474197.38,3551.88,586060.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','240411',4610870,'1641','222',1479908.24,1483577.87,3669.63,605488.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','240411',4610871,'1642','222',3732906.32,3737276.68,4370.36,721109.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','240411',4610872,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','240411',4610873,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','240411',4610874,'1645','222',2915003.14,2915003.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','240411',4610875,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','240411',4610876,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','240539',4612781,'1640','222',2474197.38,2478884.03,4686.65,773297.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','240539',4612782,'1641','222',1483577.87,1483881.41,303.54,50084.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','240539',4612783,'1642','222',3737276.68,3737276.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','240539',4612784,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','240539',4612785,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','240539',4612786,'1645','222',2915003.14,2920686.42,5683.28,937741.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','240539',4612787,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','240539',4612788,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','240707',4615185,'1640','222',2478884.03,2483369.39,4485.36,740084.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','240707',4615186,'1641','222',1483881.41,1483881.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','240707',4615187,'1642','222',3737276.68,3737276.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','240707',4615188,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','240707',4615189,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','240707',4615190,'1645','222',2920686.42,2926418.56,5732.14,945803.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','240707',4615191,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','240707',4615192,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','241042',4621130,'1640','222',2483369.39,2488921.24,5551.85,916055.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','241042',4621131,'1641','222',1483881.41,1483881.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','241042',4621132,'1642','222',3737276.68,3737276.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','241042',4621133,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','241042',4621134,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','241042',4621135,'1645','222',2926418.56,2930236.90,3818.34,630026.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','241042',4621136,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','241042',4621137,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','241310',4625897,'1640','222',2488921.24,2495550.13,6628.89,1093766.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','241310',4625898,'1641','222',1483881.41,1483881.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','241310',4625899,'1642','222',3737276.68,3737276.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','241310',4625900,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','241310',4625901,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','241310',4625902,'1645','222',2930236.90,2930236.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','241310',4625903,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','241310',4625904,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','241548',4629987,'1640','222',2495550.13,2498988.69,3438.56,567362.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','241548',4629988,'1641','222',1483881.41,1483881.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','241548',4629989,'1642','222',3737276.68,3737276.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','241548',4629990,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','241548',4629991,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','241548',4629992,'1645','222',2930236.90,2930236.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','241548',4629993,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','241548',4629994,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','241814',4634562,'1640','222',2498988.69,2498988.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','241814',4634563,'1641','222',1483881.41,1483881.41,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','241814',4634564,'1642','222',3737276.68,3737276.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','241814',4634565,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','241814',4634566,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','241814',4634567,'1645','222',2930236.90,2930994.81,757.91,125055.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','241814',4634568,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','241814',4634569,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','242002',4637742,'1640','222',2498988.69,2498988.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','242002',4637743,'1641','222',1483881.41,1489448.37,5566.96,918548.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','242002',4637744,'1642','222',3737276.68,3743398.91,6122.23,1010167.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','242002',4637745,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','242002',4637746,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','242002',4637747,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','242002',4637748,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','242002',4637749,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','242224',4641786,'1640','222',2498988.69,2498988.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','242224',4641787,'1641','222',1489448.37,1495607.99,6159.62,1016337.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','242224',4641788,'1642','222',3743398.91,3749857.71,6458.80,1065702.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','242224',4641789,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','242224',4641790,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','242224',4641791,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','242224',4641792,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','242224',4641793,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','242446',4645615,'1640','222',2498988.69,2498988.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','242446',4645616,'1641','222',1495607.99,1496826.63,1218.64,201075.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','242446',4645617,'1642','222',3749857.71,3750856.52,998.81,164803.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','242446',4645618,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','242446',4645619,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','242446',4645620,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','242446',4645621,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','242446',4645622,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','242696',4650060,'1640','222',2498988.69,2498988.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','242696',4650061,'1641','222',1496826.63,1496826.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','242696',4650062,'1642','222',3750856.52,3750856.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','242696',4650063,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','242696',4650064,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','242696',4650065,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','242696',4650066,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','242696',4650067,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','242992',4655129,'1640','222',2498988.69,2498988.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','242992',4655130,'1641','222',1496826.63,1496826.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','242992',4655131,'1642','222',3750856.52,3750856.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','242992',4655132,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','242992',4655133,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','242992',4655134,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','242992',4655135,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','242992',4655136,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','243224',4659271,'1640','222',2498988.69,2498988.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','243224',4659272,'1641','222',1496826.63,1496826.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','243224',4659273,'1642','222',3750856.52,3750856.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','243224',4659274,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','243224',4659275,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','243224',4659276,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','243224',4659277,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','243224',4659278,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','243433',4662867,'1640','222',2498988.69,2503466.29,4477.60,738804.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','243433',4662868,'1641','222',1496826.63,1496826.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','243433',4662869,'1642','222',3750856.52,3750856.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','243433',4662870,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','243433',4662871,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','243433',4662872,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','243433',4662873,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','243433',4662874,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','243840',4669979,'1640','222',2503466.29,2506873.26,3406.97,579184.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','243840',4669980,'1641','222',1496826.63,1501326.90,4500.27,765045.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','243840',4669981,'1642','222',3750856.52,3755611.20,4754.68,808295.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','243840',4669982,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','243840',4669983,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','243840',4669984,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','243840',4669985,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','243840',4669986,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','243874',4670500,'1640','222',2506873.26,2509846.21,2972.95,505401.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','243874',4670501,'1641','222',1501326.90,1504744.37,3417.47,580969.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','243874',4670502,'1642','222',3755611.20,3760053.70,4442.50,755225.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','243874',4670503,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','243874',4670504,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','243874',4670505,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','243874',4670506,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','243874',4670507,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','244127',4674905,'1640','222',2509846.21,2513299.81,3453.60,587112.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','244127',4674906,'1641','222',1504744.37,1508451.80,3707.43,630263.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','244127',4674907,'1642','222',3760053.70,3764915.81,4862.11,826558.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','244127',4674908,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','244127',4674909,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','244127',4674910,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','244127',4674911,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','244127',4674912,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','244343',4678481,'1640','222',2513299.81,2517103.00,3803.19,646542.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','244343',4678482,'1641','222',1508451.80,1512157.80,3706.00,630020.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','244343',4678483,'1642','222',3764915.81,3770197.78,5281.97,897934.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','244343',4678484,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','244343',4678485,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','244343',4678486,'1645','222',2930994.81,2930994.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','244343',4678487,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','244343',4678488,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','244557',4682204,'1640','222',2517103.00,2520891.16,3788.16,643987.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','244557',4682205,'1641','222',1512157.80,1513318.68,1160.88,197349.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','244557',4682206,'1642','222',3770197.78,3771114.11,916.33,155776.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','244557',4682207,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','244557',4682208,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','244557',4682209,'1645','222',2930994.81,2934134.05,3139.24,533670.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','244557',4682210,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','244557',4682211,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','244786',4686098,'1640','222',2520891.16,2522998.73,2107.57,358286.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','244786',4686099,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','244786',4686100,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','244786',4686101,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','244786',4686102,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','244786',4686103,'1645','222',2934134.05,2940401.10,6267.05,1065398.50,0.00,0.00,0.00,0.00,0.00),('5','96','587','244786',4686104,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','244786',4686105,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','245000',4689916,'1640','222',2522998.73,2522998.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','245000',4689917,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','245000',4689918,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','245000',4689919,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','245000',4689920,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','245000',4689921,'1645','222',2940401.10,2943960.04,3558.94,605019.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','245000',4689922,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','245000',4689923,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','245276',4694738,'1640','222',2522998.73,2522998.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','245276',4694739,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','245276',4694740,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','245276',4694741,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','245276',4694742,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','245276',4694743,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','245276',4694744,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','245276',4694745,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','245468',4698076,'1640','222',2522998.73,2522998.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','245468',4698077,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','245468',4698078,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','245468',4698079,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','245468',4698080,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','245468',4698081,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','245468',4698082,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','245468',4698083,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','245687',4701939,'1640','222',2522998.73,2522998.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','245687',4701940,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','245687',4701941,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','245687',4701942,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','245687',4701943,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','245687',4701944,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','245687',4701945,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','245687',4701946,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','246000',4706777,'1640','222',2522998.73,2529426.01,6427.28,1092637.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','246000',4706778,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','246000',4706779,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246000',4706780,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246000',4706781,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','246000',4706782,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','246000',4706783,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','246000',4706784,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','246213',4710380,'1640','222',2529426.01,2535572.49,6146.48,1044901.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','246213',4710381,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','246213',4710382,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246213',4710383,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246213',4710384,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','246213',4710385,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','246213',4710386,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','246213',4710387,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','246480',4714944,'1640','222',2535572.49,2541952.35,6379.86,1084576.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','246480',4714945,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','246480',4714946,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246480',4714947,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246480',4714948,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','246480',4714949,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','246480',4714950,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','246480',4714951,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','246717',4718937,'1640','222',2541952.35,2547831.47,5879.12,999450.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','246717',4718938,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','246717',4718939,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246717',4718940,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246717',4718941,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','246717',4718942,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','246717',4718943,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','246717',4718944,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','246967',4723368,'1640','222',2547831.47,2551258.67,3427.20,582624.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','246967',4723369,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','246967',4723370,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246967',4723371,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','246967',4723372,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','246967',4723373,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','246967',4723374,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','246967',4723375,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','247201',4727308,'1640','222',2551258.67,2552968.60,1709.93,290688.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','247201',4727309,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','247201',4727310,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','247201',4727311,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','247201',4727312,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','247201',4727313,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','247201',4727314,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','247201',4727315,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','247496',4732658,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','247496',4732659,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','247496',4732660,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','247496',4732661,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','247496',4732662,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','247496',4732663,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','247496',4732664,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','247496',4732665,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','247738',4736774,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','247738',4736775,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','247738',4736776,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','247738',4736777,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','247738',4736778,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','247738',4736779,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','247738',4736780,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','247738',4736781,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','247969',4740521,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','247969',4740522,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','247969',4740523,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','247969',4740524,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','247969',4740525,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','247969',4740526,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','247969',4740527,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','247969',4740528,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','248177',4744081,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','248177',4744082,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','248177',4744083,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','248177',4744084,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','248177',4744085,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','248177',4744086,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','248177',4744087,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','248177',4744088,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','248578',4750977,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','248578',4750978,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','248578',4750979,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','248578',4750980,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','248578',4750981,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','248578',4750982,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','248578',4750983,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','248578',4750984,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','248817',4755162,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','248817',4755163,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','248817',4755164,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','248817',4755165,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','248817',4755166,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','248817',4755167,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','248817',4755168,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','248817',4755169,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','248920',4756554,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','248920',4756555,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','248920',4756556,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','248920',4756557,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','248920',4756558,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','248920',4756559,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','248920',4756560,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','248920',4756561,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','249181',4760956,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','249181',4760957,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','249181',4760958,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','249181',4760959,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','249181',4760960,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','249181',4760961,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','249181',4760962,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','249181',4760963,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','249441',4765472,'1640','222',2552968.60,2552968.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','249441',4765473,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','249441',4765474,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','249441',4765475,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','249441',4765476,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','249441',4765477,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','249441',4765478,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','249441',4765479,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','249660',4769122,'1640','222',2552968.60,2556537.11,3568.51,606646.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','249660',4769123,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','249660',4769124,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','249660',4769125,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','249660',4769126,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','249660',4769127,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','249660',4769128,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','249660',4769129,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','249915',4773477,'1640','222',2556537.11,2562727.39,6190.28,1052347.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','249915',4773478,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','249915',4773479,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','249915',4773480,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','249915',4773481,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','249915',4773482,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','249915',4773483,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','249915',4773484,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','250163',4777601,'1640','222',2562727.39,2568565.32,5837.93,992448.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','250163',4777602,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','250163',4777603,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','250163',4777604,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','250163',4777605,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','250163',4777606,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','250163',4777607,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','250163',4777608,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','250399',4781475,'1640','222',2568565.32,2574990.14,6424.82,1092219.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','250399',4781476,'1641','222',1513318.68,1513318.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','250399',4781477,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','250399',4781478,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','250399',4781479,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','250399',4781480,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','250399',4781481,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','250399',4781482,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','250588',4784641,'1640','222',2574990.14,2579658.78,4668.64,793668.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','250588',4784642,'1641','222',1513318.68,1516919.95,3601.27,612215.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','250588',4784643,'1642','222',3771114.11,3771114.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','250588',4784644,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','250588',4784645,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','250588',4784646,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','250588',4784647,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','250588',4784648,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','250928',4790911,'1640','222',2579658.78,2583217.79,3559.01,605031.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','250928',4790912,'1641','222',1516919.95,1520773.57,3853.62,655115.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','250928',4790913,'1642','222',3771114.11,3775522.33,4408.22,749397.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','250928',4790914,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','250928',4790915,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','250928',4790916,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','250928',4790917,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','250928',4790918,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','251069',4793136,'1640','222',2583217.79,2585733.34,2515.55,415065.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','251069',4793137,'1641','222',1520773.57,1524204.77,3431.20,566148.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','251069',4793138,'1642','222',3775522.33,3778911.02,3388.69,559133.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','251069',4793139,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','251069',4793140,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','251069',4793141,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','251069',4793142,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','251069',4793143,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','251346',4798043,'1640','222',2585733.34,2588981.46,3248.12,535939.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','251346',4798044,'1641','222',1524204.77,1527292.04,3087.27,509399.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','251346',4798045,'1642','222',3778911.02,3782691.72,3780.70,623815.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','251346',4798046,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','251346',4798047,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','251346',4798048,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','251346',4798049,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','251346',4798050,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','251594',4802213,'1640','222',2588981.46,2592118.65,3137.19,517636.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','251594',4802214,'1641','222',1527292.04,1530646.33,3354.29,553457.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','251594',4802215,'1642','222',3782691.72,3787371.39,4679.67,772145.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','251594',4802216,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','251594',4802217,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','251594',4802218,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','251594',4802219,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','251594',4802220,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','251817',4806170,'1640','222',2592118.65,2592118.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','251817',4806171,'1641','222',1530646.33,1534935.01,4288.68,707632.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','251817',4806172,'1642','222',3787371.39,3791772.27,4400.88,726145.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','251817',4806173,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','251817',4806174,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','251817',4806175,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','251817',4806176,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','251817',4806177,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','252095',4811095,'1640','222',2592118.65,2596033.27,3914.62,645912.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','252095',4811096,'1641','222',1534935.01,1536080.08,1145.07,188936.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','252095',4811097,'1642','222',3791772.27,3792679.11,906.84,149628.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','252095',4811098,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252095',4811099,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','252095',4811100,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','252095',4811101,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','252095',4811102,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','252388',4816316,'1640','222',2596033.27,2598249.62,2216.35,365697.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','252388',4816317,'1641','222',1536080.08,1536080.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','252388',4816318,'1642','222',3792679.11,3792679.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252388',4816319,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252388',4816320,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','252388',4816321,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','252388',4816322,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','252388',4816323,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','252486',4818061,'1640','222',2598249.62,2598249.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','252486',4818062,'1641','222',1536080.08,1536080.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','252486',4818063,'1642','222',3792679.11,3792679.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252486',4818064,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252486',4818065,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','252486',4818066,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','252486',4818067,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','252486',4818068,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','252761',4822553,'1640','222',2598249.62,2598249.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','252761',4822554,'1641','222',1536080.08,1536080.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','252761',4822555,'1642','222',3792679.11,3792679.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252761',4822556,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252761',4822557,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','252761',4822558,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','252761',4822559,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','252761',4822560,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','252999',4826458,'1640','222',2598249.62,2598249.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','252999',4826459,'1641','222',1536080.08,1536080.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','252999',4826460,'1642','222',3792679.11,3792679.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252999',4826461,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','252999',4826462,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','252999',4826463,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','252999',4826464,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','252999',4826465,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','253248',4830728,'1640','222',2598249.62,2598249.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','253248',4830729,'1641','222',1536080.08,1536080.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','253248',4830730,'1642','222',3792679.11,3792679.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','253248',4830731,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','253248',4830732,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','253248',4830733,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','253248',4830734,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','253248',4830735,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','253553',4835954,'1640','222',2598249.62,2598306.78,57.16,9431.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','253553',4835955,'1641','222',1536080.08,1536080.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','253553',4835956,'1642','222',3792679.11,3793684.45,1005.34,165881.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','253553',4835957,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','253553',4835958,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','253553',4835959,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','253553',4835960,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','253553',4835961,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','253807',4840463,'1640','222',2598306.78,2598306.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','253807',4840464,'1641','222',1536080.08,1540915.09,4835.01,797776.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','253807',4840465,'1642','222',3793684.45,3799020.93,5336.48,880519.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','253807',4840466,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','253807',4840467,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','253807',4840468,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','253807',4840469,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','253807',4840470,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','253992',4843443,'1640','222',2598306.78,2598306.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','253992',4843444,'1641','222',1540915.09,1545854.54,4939.45,815009.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','253992',4843445,'1642','222',3799020.93,3804377.90,5356.97,883900.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','253992',4843446,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','253992',4843447,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','253992',4843448,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','253992',4843449,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','253992',4843450,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','254218',4847647,'1640','222',2598306.78,2598306.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','254218',4847648,'1641','222',1545854.54,1551838.64,5984.10,987376.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','254218',4847649,'1642','222',3804377.90,3810650.69,6272.79,1035010.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','254218',4847650,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','254218',4847651,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','254218',4847652,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','254218',4847653,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','254218',4847654,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','254533',4853113,'1640','222',2598306.78,2598306.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','254533',4853114,'1641','222',1551838.64,1553701.45,1862.81,307363.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','254533',4853115,'1642','222',3810650.69,3813274.24,2623.55,432885.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','254533',4853116,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','254533',4853117,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','254533',4853118,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','254533',4853119,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','254533',4853120,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','254791',4857525,'1640','222',2598306.78,2598306.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','254791',4857526,'1641','222',1553701.45,1554706.42,1004.97,165820.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','254791',4857527,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','254791',4857528,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','254791',4857529,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','254791',4857530,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','254791',4857531,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','254791',4857532,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','254988',4860777,'1640','222',2598306.78,2598306.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','254988',4860778,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','254988',4860779,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','254988',4860780,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','254988',4860781,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','254988',4860782,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','254988',4860783,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','254988',4860784,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','255251',4865280,'1640','222',2598306.78,2598306.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','255251',4865281,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','255251',4865282,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','255251',4865283,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','255251',4865284,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','255251',4865285,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','255251',4865286,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','255251',4865287,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','255503',4869599,'1640','222',2598306.78,2598306.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','255503',4869600,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','255503',4869601,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','255503',4869602,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','255503',4869603,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','255503',4869604,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','255503',4869605,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','255503',4869606,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','255810',4874710,'1640','222',2598306.78,2602149.16,3842.38,633992.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','255810',4874711,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','255810',4874712,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','255810',4874713,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','255810',4874714,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','255810',4874715,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','255810',4874716,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','255810',4874717,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','256046',4878790,'1640','222',2602149.16,2609364.62,7215.46,1190550.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','256046',4878791,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','256046',4878792,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','256046',4878793,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','256046',4878794,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','256046',4878795,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','256046',4878796,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','256046',4878797,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','256292',4882478,'1640','222',2609364.62,2615114.07,5749.45,948659.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','256292',4882479,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','256292',4882480,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','256292',4882481,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','256292',4882482,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','256292',4882483,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','256292',4882484,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','256292',4882485,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','256552',4886982,'1640','222',2615114.07,2622273.27,7159.20,1181268.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','256552',4886983,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','256552',4886984,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','256552',4886985,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','256552',4886986,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','256552',4886987,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','256552',4886988,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','256552',4886989,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','256794',4891047,'1640','222',2622273.27,2626139.00,3865.73,637845.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','256794',4891048,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','256794',4891049,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','256794',4891050,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','256794',4891051,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','256794',4891052,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','256794',4891053,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','256794',4891054,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257061',4895914,'1640','222',2626139.00,2627375.61,1236.61,204040.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257061',4895915,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257061',4895916,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257061',4895917,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257061',4895918,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257061',4895919,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257061',4895920,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257061',4895921,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257428',4902686,'1640','222',2627375.61,2627375.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257428',4902687,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257428',4902688,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257428',4902689,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257428',4902690,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257428',4902691,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257428',4902692,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257428',4902693,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257669',4906885,'1640','222',2627375.61,2627375.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257669',4906886,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257669',4906887,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257669',4906888,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257669',4906889,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257669',4906890,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257669',4906891,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257669',4906892,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257670',4906893,'1640','222',2627375.61,2627375.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257670',4906894,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257670',4906895,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257670',4906896,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257670',4906897,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257670',4906898,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257670',4906899,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257670',4906900,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257671',4906901,'1640','222',2627375.61,2628234.75,859.14,141758.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','257671',4906902,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257671',4906903,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257671',4906904,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257671',4906905,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257671',4906906,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257671',4906907,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257671',4906908,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257672',4906909,'1640','222',2628234.75,2633759.02,5524.27,911504.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257672',4906910,'1641','222',1554706.42,1554706.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257672',4906911,'1642','222',3813274.24,3813274.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257672',4906912,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257672',4906913,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257672',4906914,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257672',4906915,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257672',4906916,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257673',4906917,'1640','222',2633759.02,2638564.43,4805.41,792892.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257673',4906918,'1641','222',1554706.42,1555963.05,1256.63,207343.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','257673',4906919,'1642','222',3813274.24,3814594.64,1320.40,217866.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257673',4906920,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257673',4906921,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257673',4906922,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257673',4906923,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257673',4906924,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257674',4906925,'1640','222',2638564.43,2641489.80,2925.37,482686.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','257674',4906926,'1641','222',1555963.05,1559429.30,3466.25,571931.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','257674',4906927,'1642','222',3814594.64,3818662.98,4068.34,671276.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','257674',4906928,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257674',4906929,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257674',4906930,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257674',4906931,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257674',4906932,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257675',4906933,'1640','222',2641489.80,2645853.68,4363.88,720040.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257675',4906934,'1641','222',1559429.30,1559675.58,246.28,40636.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257675',4906935,'1642','222',3818662.98,3822170.61,3507.63,578758.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','257675',4906936,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257675',4906937,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257675',4906938,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257675',4906939,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257675',4906940,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257676',4906941,'1640','222',2645853.68,2650582.33,4728.65,780227.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','257676',4906942,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257676',4906943,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257676',4906944,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257676',4906945,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257676',4906946,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257676',4906947,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257676',4906948,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257677',4906949,'1640','222',2650582.33,2655081.93,4499.60,742434.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257677',4906950,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257677',4906951,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257677',4906952,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257677',4906953,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257677',4906954,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257677',4906955,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257677',4906956,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257678',4906957,'1640','222',2655081.93,2657158.00,2076.07,342551.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257678',4906958,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257678',4906959,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257678',4906960,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257678',4906961,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257678',4906962,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257678',4906963,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257678',4906964,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257679',4906965,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257679',4906966,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257679',4906967,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257679',4906968,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257679',4906969,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257679',4906970,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257679',4906971,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257679',4906972,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257680',4906973,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257680',4906974,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257680',4906975,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257680',4906976,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257680',4906977,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257680',4906978,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257680',4906979,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257680',4906980,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257681',4906981,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257681',4906982,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257681',4906983,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257681',4906984,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257681',4906985,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257681',4906986,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257681',4906987,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257681',4906988,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257682',4906989,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257682',4906990,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257682',4906991,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257682',4906992,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257682',4906993,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257682',4906994,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257682',4906995,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257682',4906996,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257683',4906997,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257683',4906998,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257683',4906999,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257683',4907000,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257683',4907001,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257683',4907002,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257683',4907003,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257683',4907004,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257684',4907005,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257684',4907006,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257684',4907007,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257684',4907008,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257684',4907009,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257684',4907010,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257684',4907011,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257684',4907012,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257685',4907013,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257685',4907014,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257685',4907015,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257685',4907016,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257685',4907017,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257685',4907018,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257685',4907019,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257685',4907020,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257686',4907021,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257686',4907022,'1641','222',1559675.58,1559675.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257686',4907023,'1642','222',3822170.61,3822170.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257686',4907024,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257686',4907025,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257686',4907026,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257686',4907027,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257686',4907028,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257687',4907029,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257687',4907030,'1641','222',1559675.58,1560391.47,715.89,118121.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257687',4907031,'1642','222',3822170.61,3823037.01,866.40,142956.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257687',4907032,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257687',4907033,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257687',4907034,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257687',4907035,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257687',4907036,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257688',4907037,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257688',4907038,'1641','222',1560391.47,1566395.04,6003.57,990589.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','257688',4907039,'1642','222',3823037.01,3829106.80,6069.79,1001515.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','257688',4907040,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257688',4907041,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257688',4907042,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257688',4907043,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257688',4907044,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257689',4907045,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257689',4907046,'1641','222',1566395.04,1567482.82,1087.78,179483.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257689',4907047,'1642','222',3829106.80,3829907.35,800.55,132090.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','257689',4907048,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257689',4907049,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257689',4907050,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257689',4907051,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257689',4907052,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257690',4907053,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257690',4907054,'1641','222',1567482.82,1567482.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257690',4907055,'1642','222',3829907.35,3829907.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257690',4907056,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257690',4907057,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257690',4907058,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257690',4907059,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257690',4907060,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257691',4907061,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257691',4907062,'1641','222',1567482.82,1567482.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257691',4907063,'1642','222',3829907.35,3829907.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257691',4907064,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257691',4907065,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257691',4907066,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257691',4907067,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257691',4907068,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257692',4907069,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257692',4907070,'1641','222',1567482.82,1567482.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257692',4907071,'1642','222',3829907.35,3831068.70,1161.35,191622.75,0.00,0.00,0.00,0.00,0.00),('5','96','585','257692',4907072,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257692',4907073,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257692',4907074,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257692',4907075,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257692',4907076,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257693',4907077,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257693',4907078,'1641','222',1567482.82,1567482.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257693',4907079,'1642','222',3831068.70,3840316.61,9247.91,1525905.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','257693',4907080,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257693',4907081,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257693',4907082,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257693',4907083,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257693',4907084,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257694',4907085,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257694',4907086,'1641','222',1567482.82,1567482.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257694',4907087,'1642','222',3840316.61,3851459.51,11142.90,1838578.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','257694',4907088,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257694',4907089,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257694',4907090,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257694',4907091,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257694',4907092,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257695',4907093,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257695',4907094,'1641','222',1567482.82,1567556.44,73.62,12147.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257695',4907095,'1642','222',3851459.51,3855306.84,3847.33,634809.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','257695',4907096,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257695',4907097,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257695',4907098,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257695',4907099,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257695',4907100,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257696',4907101,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257696',4907102,'1641','222',1567556.44,1567708.99,152.55,25170.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','257696',4907103,'1642','222',3855306.84,3860606.21,5299.37,874396.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','257696',4907104,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257696',4907105,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257696',4907106,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257696',4907107,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257696',4907108,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257697',4907109,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257697',4907110,'1641','222',1567708.99,1567708.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257697',4907111,'1642','222',3860606.21,3865451.52,4845.31,799476.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','257697',4907112,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257697',4907113,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257697',4907114,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257697',4907115,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257697',4907116,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257698',4907117,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257698',4907118,'1641','222',1567708.99,1567728.06,19.07,3146.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257698',4907119,'1642','222',3865451.52,3876182.42,10730.90,1770598.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','257698',4907120,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257698',4907121,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257698',4907122,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257698',4907123,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257698',4907124,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257699',4907125,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257699',4907126,'1642','222',3876182.42,3888105.44,11923.02,1967298.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257699',4907127,'1641','222',1567728.06,1568539.24,811.18,133844.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','257699',4907128,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257699',4907129,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257699',4907130,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257699',4907131,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257699',4907132,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257700',4907133,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257700',4907134,'1642','222',3888105.44,3897651.62,9546.18,1575119.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257700',4907135,'1641','222',1568539.24,1575408.88,6869.64,1133490.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','257700',4907136,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257700',4907137,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257700',4907138,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257700',4907139,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257700',4907140,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257701',4907141,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257701',4907142,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257701',4907143,'1642','222',3897651.62,3897651.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257701',4907144,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257701',4907145,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257701',4907146,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257701',4907147,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257701',4907148,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257702',4907149,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257702',4907150,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257702',4907151,'1642','222',3897651.62,3897651.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257702',4907152,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257702',4907153,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257702',4907154,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257702',4907155,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257702',4907156,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257703',4907157,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257703',4907158,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257703',4907159,'1642','222',3897651.62,3897651.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257703',4907160,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257703',4907161,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257703',4907162,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257703',4907163,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257703',4907164,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257704',4907165,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257704',4907166,'1642','222',3897651.62,3897651.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257704',4907167,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257704',4907168,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257704',4907169,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257704',4907170,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257704',4907171,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257704',4907172,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257705',4907173,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257705',4907174,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257705',4907175,'1642','222',3897651.62,3902513.19,4861.57,802159.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','257705',4907176,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257705',4907177,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257705',4907178,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257705',4907179,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257705',4907180,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257706',4907181,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257706',4907182,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257706',4907183,'1642','222',3902513.19,3906732.43,4219.24,696174.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','257706',4907184,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257706',4907185,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257706',4907186,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257706',4907187,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257706',4907188,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257707',4907189,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257707',4907190,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257707',4907191,'1642','222',3906732.43,3910629.85,3897.42,643074.30,0.00,0.00,0.00,0.00,0.00),('5','96','585','257707',4907192,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257707',4907193,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257707',4907194,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257707',4907195,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257707',4907196,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257708',4907197,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257708',4907198,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257708',4907199,'1642','222',3910629.85,3911830.90,1201.05,198173.25,0.00,0.00,0.00,0.00,0.00),('5','96','585','257708',4907200,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257708',4907201,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257708',4907202,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257708',4907203,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257708',4907204,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257709',4907205,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257709',4907206,'1641','222',1575408.88,1575408.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257709',4907207,'1642','222',3911830.90,3911830.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257709',4907208,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257709',4907209,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257709',4907210,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257709',4907211,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257709',4907212,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257710',4907213,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257710',4907214,'1641','222',1575408.88,1575614.99,206.11,34008.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257710',4907215,'1642','222',3911830.90,3913478.21,1647.31,271806.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','257710',4907216,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257710',4907217,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257710',4907218,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257710',4907219,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257710',4907220,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257711',4907221,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257711',4907222,'1642','222',3913478.21,3922481.84,9003.63,1485598.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','257711',4907223,'1641','222',1575614.99,1575614.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257711',4907224,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257711',4907225,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257711',4907226,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257711',4907227,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257711',4907228,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257712',4907229,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257712',4907230,'1641','222',1575614.99,1575614.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257712',4907231,'1642','222',3922481.84,3929675.16,7193.32,1186897.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','257712',4907232,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257712',4907233,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257712',4907234,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257712',4907235,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257712',4907236,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257713',4907237,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257713',4907238,'1641','222',1575614.99,1575614.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257713',4907239,'1642','222',3929675.16,3935511.80,5836.64,963045.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','257713',4907240,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257713',4907241,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257713',4907242,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257713',4907243,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257713',4907244,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257714',4907245,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257714',4907246,'1641','222',1575614.99,1575614.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257714',4907247,'1642','222',3935511.80,3942194.36,6682.56,1102622.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','257714',4907248,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257714',4907249,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257714',4907250,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257714',4907251,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257714',4907252,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257715',4907253,'1640','222',2657158.00,2657158.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257715',4907254,'1641','222',1575614.99,1575674.94,59.95,9891.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','257715',4907255,'1642','222',3942194.36,3947616.33,5421.97,894625.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','257715',4907256,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257715',4907257,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257715',4907258,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257715',4907259,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257715',4907260,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257716',4907261,'1640','222',2657158.00,2661843.13,4685.13,773046.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','257716',4907262,'1641','222',1575674.94,1575713.82,38.88,6415.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257716',4907263,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257716',4907264,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257716',4907265,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257716',4907266,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257716',4907267,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257716',4907268,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257717',4907269,'1640','222',2661843.13,2666563.62,4720.49,778880.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257717',4907270,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257717',4907271,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257717',4907272,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257717',4907273,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257717',4907274,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257717',4907275,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257717',4907276,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257718',4907277,'1640','222',2666563.62,2670222.02,3658.40,603636.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257718',4907278,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257718',4907279,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257718',4907280,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257718',4907281,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257718',4907282,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257718',4907283,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257718',4907284,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257719',4907285,'1640','222',2670222.02,2671595.63,1373.61,226645.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257719',4907286,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257719',4907287,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257719',4907288,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257719',4907289,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257719',4907290,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257719',4907291,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257719',4907292,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257720',4907293,'1640','222',2671595.63,2671595.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257720',4907294,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257720',4907295,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257720',4907296,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257720',4907297,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257720',4907298,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257720',4907299,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257720',4907300,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257721',4907301,'1640','222',2671595.63,2671595.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257721',4907302,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257721',4907303,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257721',4907304,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257721',4907305,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257721',4907306,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257721',4907307,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257721',4907308,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257722',4907309,'1640','222',2671595.63,2671595.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257722',4907310,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257722',4907311,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257722',4907312,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257722',4907313,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257722',4907314,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257722',4907315,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257722',4907316,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257723',4907317,'1640','222',2671595.63,2671595.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257723',4907318,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257723',4907319,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257723',4907320,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257723',4907321,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257723',4907322,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257723',4907323,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257723',4907324,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257724',4907325,'1640','222',2671595.63,2671595.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257724',4907326,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257724',4907327,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257724',4907328,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257724',4907329,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257724',4907330,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257724',4907331,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257724',4907332,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257725',4907333,'1640','222',2671881.78,2676525.95,4644.17,766288.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','257725',4907334,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257725',4907335,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257725',4907336,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257725',4907337,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257725',4907338,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257725',4907339,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257725',4907340,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257726',4907341,'1640','222',2676525.95,2681535.22,5009.27,826529.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257726',4907342,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257726',4907343,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257726',4907344,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257726',4907345,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257726',4907346,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257726',4907347,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257726',4907348,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257727',4907349,'1640','222',2681535.22,2685693.61,4158.39,686134.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257727',4907350,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257727',4907351,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257727',4907352,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257727',4907353,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257727',4907354,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257727',4907355,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257727',4907356,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257728',4907357,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257728',4907358,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257728',4907359,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257728',4907360,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257728',4907361,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257728',4907362,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257728',4907363,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257728',4907364,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257729',4907365,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257729',4907366,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257729',4907367,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257729',4907368,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257729',4907369,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257729',4907370,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257729',4907371,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257729',4907372,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257730',4907373,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257730',4907374,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257730',4907375,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257730',4907376,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257730',4907377,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257730',4907378,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257730',4907379,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257730',4907380,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257731',4907381,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257731',4907382,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257731',4907383,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257731',4907384,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257731',4907385,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257731',4907386,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257731',4907387,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257731',4907388,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257732',4907389,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257732',4907390,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257732',4907391,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257732',4907392,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257732',4907393,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257732',4907394,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257732',4907395,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257732',4907396,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257733',4907397,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257733',4907398,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257733',4907399,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257733',4907400,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257733',4907401,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257733',4907402,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257733',4907403,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257733',4907404,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257734',4907405,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257734',4907406,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257734',4907407,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257734',4907408,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257734',4907409,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257734',4907410,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257734',4907411,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257734',4907412,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257735',4907413,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257735',4907414,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257735',4907415,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257735',4907416,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257735',4907417,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257735',4907418,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257735',4907419,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257735',4907420,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257736',4907421,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257736',4907422,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257736',4907423,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257736',4907424,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257736',4907425,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257736',4907426,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257736',4907427,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257736',4907428,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257737',4907429,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257737',4907430,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257737',4907431,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257737',4907432,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257737',4907433,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257737',4907434,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257737',4907435,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257737',4907436,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257738',4907437,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257738',4907438,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257738',4907439,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257738',4907440,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257738',4907441,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257738',4907442,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257738',4907443,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257738',4907444,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257739',4907445,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257739',4907446,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257739',4907447,'1642','222',3947616.33,3947616.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257739',4907448,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257739',4907449,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257739',4907450,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257739',4907451,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257739',4907452,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257740',4907453,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257740',4907454,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257740',4907455,'1642','222',3947616.33,3953265.86,5649.53,932172.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','257740',4907456,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257740',4907457,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257740',4907458,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257740',4907459,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257740',4907460,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257741',4907461,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257741',4907462,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257741',4907463,'1642','222',3953265.86,3957902.18,4636.32,764992.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','257741',4907464,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257741',4907465,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257741',4907466,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257741',4907467,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257741',4907468,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257742',4907469,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257742',4907470,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257742',4907471,'1642','222',3957902.18,3963553.49,5651.31,932466.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','257742',4907472,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257742',4907473,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257742',4907474,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257742',4907475,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257742',4907476,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257743',4907477,'1640','222',2685693.61,2685693.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257743',4907478,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257743',4907479,'1642','222',3963553.49,3969103.30,5549.81,915718.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','257743',4907480,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257743',4907481,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257743',4907482,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257743',4907483,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257743',4907484,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257744',4907485,'1640','222',2685693.61,2688584.20,2890.59,476947.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257744',4907486,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257744',4907487,'1642','222',3969103.30,3972458.55,3355.25,553616.25,0.00,0.00,0.00,0.00,0.00),('5','96','585','257744',4907488,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257744',4907489,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257744',4907490,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257744',4907491,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257744',4907492,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257745',4907493,'1640','222',2688584.20,2692266.17,3681.97,607525.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','257745',4907494,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257745',4907495,'1642','222',3972458.55,3978073.17,5614.62,926412.30,0.00,0.00,0.00,0.00,0.00),('5','96','585','257745',4907496,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257745',4907497,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257745',4907498,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257745',4907499,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257745',4907500,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257746',4907501,'1640','222',2692266.17,2696296.61,4030.44,665022.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','257746',4907502,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257746',4907503,'1642','222',3978073.17,3981750.05,3676.88,606685.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','257746',4907504,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257746',4907505,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257746',4907506,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257746',4907507,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257746',4907508,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257747',4907509,'1640','222',2696296.61,2700495.04,4198.43,692740.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','257747',4907510,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257747',4907511,'1642','222',3981750.05,3981750.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257747',4907512,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257747',4907513,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257747',4907514,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257747',4907515,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257747',4907516,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257748',4907517,'1640','222',2700495.04,2702751.40,2256.36,372299.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','257748',4907518,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257748',4907519,'1642','222',3981750.05,3985533.57,3783.52,624280.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','257748',4907520,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257748',4907521,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257748',4907522,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257748',4907523,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257748',4907524,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257749',4907525,'1640','222',2702751.40,2705486.18,2734.78,451238.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257749',4907526,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257749',4907527,'1642','222',3985533.57,3987154.96,1621.39,267529.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','257749',4907528,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257749',4907529,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257749',4907530,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257749',4907531,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257749',4907532,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257750',4907533,'1640','222',2705486.18,2705486.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257750',4907534,'1641','222',1575713.82,1575713.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257750',4907535,'1642','222',3987154.96,3991652.30,4497.34,742061.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','257750',4907536,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257750',4907537,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257750',4907538,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257750',4907539,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257750',4907540,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257751',4907541,'1640','222',2705486.18,2711171.07,5684.89,938006.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257751',4907542,'1641','222',1575713.82,1575731.12,17.30,2854.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257751',4907543,'1642','222',3991652.30,3992052.56,400.26,66042.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','257751',4907544,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257751',4907545,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257751',4907546,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257751',4907547,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257751',4907548,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257752',4907549,'1640','222',2711171.07,2715853.75,4682.68,772642.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257752',4907550,'1641','222',1575731.12,1575731.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257752',4907551,'1642','222',3992052.56,3992052.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257752',4907552,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257752',4907553,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257752',4907554,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257752',4907555,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257752',4907556,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257753',4907557,'1640','222',2715853.75,2720601.48,4747.73,783375.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','257753',4907558,'1641','222',1575731.12,1575871.87,140.75,23223.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','257753',4907559,'1642','222',3992052.56,3992052.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257753',4907560,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257753',4907561,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257753',4907562,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257753',4907563,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257753',4907564,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257754',4907565,'1640','222',2720601.48,2722575.95,1974.47,325787.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257754',4907566,'1641','222',1575871.87,1575871.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257754',4907567,'1642','222',3992052.56,3992052.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257754',4907568,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257754',4907569,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257754',4907570,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257754',4907571,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257754',4907572,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257755',4907573,'1640','222',2722575.95,2722575.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257755',4907574,'1641','222',1575871.87,1575871.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257755',4907575,'1642','222',3992052.56,3997881.85,5829.29,961832.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','257755',4907576,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257755',4907577,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257755',4907578,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257755',4907579,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257755',4907580,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257756',4907581,'1640','222',2722575.95,2722575.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257756',4907582,'1641','222',1575871.87,1575871.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257756',4907583,'1642','222',3997881.85,4002945.48,5063.63,835498.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','257756',4907584,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257756',4907585,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257756',4907586,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257756',4907587,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257756',4907588,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257757',4907589,'1640','222',2722575.95,2722575.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257757',4907590,'1641','222',1575871.87,1575871.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257757',4907591,'1642','222',4002945.48,4008872.69,5927.21,977989.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','257757',4907592,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257757',4907593,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257757',4907594,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257757',4907595,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257757',4907596,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257758',4907597,'1640','222',2722575.95,2722575.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257758',4907598,'1641','222',1575871.87,1575871.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257758',4907599,'1642','222',4008872.69,4014712.70,5840.01,963601.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','257758',4907600,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257758',4907601,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257758',4907602,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257758',4907603,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257758',4907604,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257759',4907605,'1640','222',2722575.95,2722575.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257759',4907606,'1641','222',1575871.87,1575871.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257759',4907607,'1642','222',4014712.70,4020326.26,5613.56,926237.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','257759',4907608,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257759',4907609,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257759',4907610,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257759',4907611,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257759',4907612,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257760',4907613,'1640','222',2722575.95,2722575.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257760',4907614,'1641','222',1575871.87,1575871.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257760',4907615,'1642','222',4020326.26,4025503.03,5176.77,854167.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','257760',4907616,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257760',4907617,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257760',4907618,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257760',4907619,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257760',4907620,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257761',4907621,'1640','222',2722575.95,2722575.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257761',4907622,'1641','222',1575871.87,1578352.58,2480.71,409317.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257761',4907623,'1642','222',4025503.03,4029369.99,3866.96,638048.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','257761',4907624,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257761',4907625,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257761',4907626,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257761',4907627,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257761',4907628,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257762',4907629,'1640','222',2722575.95,2728122.75,5546.80,915222.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257762',4907630,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257762',4907631,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257762',4907632,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257762',4907633,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257762',4907634,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257762',4907635,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257762',4907636,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257763',4907637,'1640','222',2728122.75,2733465.33,5342.58,881525.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257763',4907638,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257763',4907639,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257763',4907640,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257763',4907641,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257763',4907642,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257763',4907643,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257763',4907644,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257764',4907645,'1640','222',2733465.33,2739083.48,5618.15,926994.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','257764',4907646,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257764',4907647,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257764',4907648,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257764',4907649,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257764',4907650,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257764',4907651,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257764',4907652,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257765',4907653,'1640','222',2739083.48,2744452.52,5369.04,885891.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','257765',4907654,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257765',4907655,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257765',4907656,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257765',4907657,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257765',4907658,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257765',4907659,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257765',4907660,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257766',4907661,'1640','222',2744452.52,2749599.18,5146.66,849198.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','257766',4907662,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257766',4907663,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257766',4907664,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257766',4907665,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257766',4907666,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257766',4907667,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257766',4907668,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257767',4907669,'1640','222',2749599.18,2752638.97,3039.79,501565.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257767',4907670,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257767',4907671,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257767',4907672,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257767',4907673,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257767',4907674,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257767',4907675,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257767',4907676,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257768',4907677,'1640','222',2752638.97,2752638.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257768',4907678,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257768',4907679,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257768',4907680,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257768',4907681,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257768',4907682,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257768',4907683,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257768',4907684,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257769',4907685,'1640','222',2752638.97,2752638.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257769',4907686,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257769',4907687,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257769',4907688,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257769',4907689,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257769',4907690,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257769',4907691,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257769',4907692,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257770',4907693,'1640','222',2752638.97,2752638.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257770',4907694,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257770',4907695,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257770',4907696,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257770',4907697,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257770',4907698,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257770',4907699,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257770',4907700,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257771',4907701,'1640','222',2752638.97,2752638.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257771',4907702,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257771',4907703,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257771',4907704,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257771',4907705,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257771',4907706,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257771',4907707,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257771',4907708,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257772',4907709,'1640','222',2752638.97,2752638.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257772',4907710,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257772',4907711,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257772',4907712,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257772',4907713,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257772',4907714,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257772',4907715,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257772',4907716,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257773',4907717,'1640','222',2752638.97,2758230.98,5592.01,922681.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257773',4907718,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257773',4907719,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257773',4907720,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257773',4907721,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257773',4907722,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257773',4907723,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257773',4907724,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257774',4907725,'1640','222',2758230.98,2764151.27,5920.29,976847.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257774',4907726,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257774',4907727,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257774',4907728,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257774',4907729,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257774',4907730,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257774',4907731,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257774',4907732,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257775',4907733,'1640','222',2764151.27,2770083.48,5932.21,978814.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257775',4907734,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257775',4907735,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257775',4907736,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257775',4907737,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257775',4907738,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257775',4907739,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257775',4907740,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257776',4907741,'1640','222',2770083.48,2775098.88,5015.40,827541.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257776',4907742,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257776',4907743,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257776',4907744,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257776',4907745,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257776',4907746,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257776',4907747,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257776',4907748,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257777',4907749,'1640','222',2775098.88,2780322.49,5223.61,861895.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257777',4907750,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257777',4907751,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257777',4907752,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257777',4907753,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257777',4907754,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257777',4907755,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257777',4907756,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257778',4907757,'1640','222',2780322.49,2782756.18,2433.69,401558.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257778',4907758,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257778',4907759,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257778',4907760,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257778',4907761,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257778',4907762,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257778',4907763,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257778',4907764,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257779',4907765,'1640','222',2782756.18,2782756.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257779',4907766,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257779',4907767,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257779',4907768,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257779',4907769,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257779',4907770,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257779',4907771,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257779',4907772,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257780',4907773,'1640','222',2782756.18,2788779.20,6023.02,993798.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257780',4907774,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257780',4907775,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257780',4907776,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257780',4907777,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257780',4907778,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257780',4907779,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257780',4907780,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257781',4907781,'1640','222',2788779.20,2794147.79,5368.59,885817.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257781',4907782,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257781',4907783,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257781',4907784,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257781',4907785,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257781',4907786,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257781',4907787,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257781',4907788,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257782',4907789,'1640','222',2794147.79,2799561.22,5413.43,893215.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','257782',4907790,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257782',4907791,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257782',4907792,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257782',4907793,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257782',4907794,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257782',4907795,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257782',4907796,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257783',4907797,'1640','222',2799561.22,2804625.88,5064.66,835668.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','257783',4907798,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257783',4907799,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257783',4907800,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257783',4907801,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257783',4907802,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257783',4907803,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257783',4907804,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257784',4907805,'1640','222',2804625.88,2810071.13,5445.25,898466.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','257784',4907806,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257784',4907807,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257784',4907808,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257784',4907809,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257784',4907810,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257784',4907811,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257784',4907812,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257785',4907813,'1640','222',2810071.13,2812697.48,2626.35,433347.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','257785',4907814,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257785',4907815,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257785',4907816,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257785',4907817,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257785',4907818,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257785',4907819,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257785',4907820,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257786',4907821,'1640','222',2812697.48,2818000.18,5302.70,874945.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257786',4907822,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257786',4907823,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257786',4907824,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257786',4907825,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257786',4907826,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257786',4907827,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257786',4907828,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257787',4907829,'1640','222',2818000.18,2823396.68,5396.50,890422.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257787',4907830,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257787',4907831,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257787',4907832,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257787',4907833,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257787',4907834,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257787',4907835,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257787',4907836,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257788',4907837,'1640','222',2823396.68,2828605.65,5208.97,859480.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','257788',4907838,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257788',4907839,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257788',4907840,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257788',4907841,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257788',4907842,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257788',4907843,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257788',4907844,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257789',4907845,'1640','222',2828605.65,2833891.29,5285.64,872130.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','257789',4907846,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257789',4907847,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257789',4907848,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257789',4907849,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257789',4907850,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257789',4907851,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257789',4907852,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257790',4907853,'1640','222',2833891.29,2836525.00,2633.71,434562.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257790',4907854,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257790',4907855,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257790',4907856,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257790',4907857,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257790',4907858,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257790',4907859,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257790',4907860,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257791',4907861,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257791',4907862,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257791',4907863,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257791',4907864,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257791',4907865,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257791',4907866,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257791',4907867,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257791',4907868,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257792',4907869,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257792',4907870,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257792',4907871,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257792',4907872,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257792',4907873,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257792',4907874,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257792',4907875,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257792',4907876,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257793',4907877,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257793',4907878,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257793',4907879,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257793',4907880,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257793',4907881,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257793',4907882,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257793',4907883,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257793',4907884,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257794',4907885,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257794',4907886,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257794',4907887,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257794',4907888,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257794',4907889,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257794',4907890,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257794',4907891,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257794',4907892,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257795',4907893,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257795',4907894,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257795',4907895,'1642','222',4029369.99,4029369.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257795',4907896,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257795',4907897,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257795',4907898,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257795',4907899,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257795',4907900,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257796',4907901,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257796',4907902,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257796',4907903,'1642','222',4029369.99,4035795.09,6425.10,1060141.50,0.00,0.00,0.00,0.00,0.00),('5','96','585','257796',4907904,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257796',4907905,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257796',4907906,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257796',4907907,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257796',4907908,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257797',4907909,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257797',4907910,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257797',4907911,'1642','222',4035795.09,4041807.13,6012.04,991986.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','257797',4907912,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257797',4907913,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257797',4907914,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257797',4907915,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257797',4907916,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257798',4907917,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257798',4907918,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257798',4907919,'1642','222',4041807.13,4047610.36,5803.23,957532.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','257798',4907920,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257798',4907921,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257798',4907922,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257798',4907923,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257798',4907924,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257799',4907925,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257799',4907926,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257799',4907927,'1642','222',4047610.36,4053271.02,5660.66,934008.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','257799',4907928,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257799',4907929,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257799',4907930,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257799',4907931,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257799',4907932,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257800',4907933,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257800',4907934,'1641','222',1578352.58,1578352.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257800',4907935,'1642','222',4053271.02,4059018.84,5747.82,948390.30,0.00,0.00,0.00,0.00,0.00),('5','96','585','257800',4907936,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257800',4907937,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257800',4907938,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257800',4907939,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257800',4907940,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257801',4907941,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257801',4907942,'1641','222',1578352.58,1578649.62,297.04,49011.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','257801',4907943,'1642','222',4059018.84,4065028.48,6009.64,991590.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','257801',4907944,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257801',4907945,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257801',4907946,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257801',4907947,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257801',4907948,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257802',4907949,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257802',4907950,'1641','222',1578649.62,1578680.23,30.61,5050.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257802',4907951,'1642','222',4065028.48,4070918.06,5889.58,971780.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','257802',4907952,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257802',4907953,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257802',4907954,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257802',4907955,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257802',4907956,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257803',4907957,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257803',4907958,'1641','222',1578680.23,1578902.53,222.30,36679.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257803',4907959,'1642','222',4070918.06,4073115.72,2197.66,362613.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','257803',4907960,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257803',4907961,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257803',4907962,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257803',4907963,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257803',4907964,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257804',4907965,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257804',4907966,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257804',4907967,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257804',4907968,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257804',4907969,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257804',4907970,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257804',4907971,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257804',4907972,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257805',4907973,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257805',4907974,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257805',4907975,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257805',4907976,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257805',4907977,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257805',4907978,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257805',4907979,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257805',4907980,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257806',4907981,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257806',4907982,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257806',4907983,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257806',4907984,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257806',4907985,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257806',4907986,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257806',4907987,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257806',4907988,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257807',4907989,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257807',4907990,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257807',4907991,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257807',4907992,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257807',4907993,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257807',4907994,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257807',4907995,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257807',4907996,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257808',4907997,'1640','222',2836525.00,2836525.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257808',4907998,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257808',4907999,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257808',4908000,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257808',4908001,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257808',4908002,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257808',4908003,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257808',4908004,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257809',4908005,'1640','222',2836525.00,2842560.60,6035.60,995874.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257809',4908006,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257809',4908007,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257809',4908008,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257809',4908009,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257809',4908010,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257809',4908011,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257809',4908012,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257810',4908013,'1640','222',2842560.60,2848466.88,5906.28,974536.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257810',4908014,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257810',4908015,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257810',4908016,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257810',4908017,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257810',4908018,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257810',4908019,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257810',4908020,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257811',4908021,'1640','222',2848466.88,2853711.16,5244.28,865306.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257811',4908022,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257811',4908023,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257811',4908024,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257811',4908025,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257811',4908026,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257811',4908027,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257811',4908028,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257812',4908029,'1640','222',2853711.16,2859377.54,5666.38,934952.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257812',4908030,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257812',4908031,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257812',4908032,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257812',4908033,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257812',4908034,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257812',4908035,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257812',4908036,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257813',4908037,'1640','222',2859377.54,2864102.63,4725.09,779639.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257813',4908038,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257813',4908039,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257813',4908040,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257813',4908041,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257813',4908042,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257813',4908043,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257813',4908044,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257814',4908045,'1640','222',2864102.63,2864102.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257814',4908046,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257814',4908047,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257814',4908048,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257814',4908049,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257814',4908050,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257814',4908051,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257814',4908052,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257815',4908053,'1640','222',2864102.63,2864475.45,372.82,61515.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257815',4908054,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257815',4908055,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257815',4908056,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257815',4908057,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257815',4908058,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257815',4908059,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257815',4908060,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257816',4908061,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257816',4908062,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257816',4908063,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257816',4908064,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257816',4908065,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257816',4908066,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257816',4908067,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257816',4908068,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257817',4908069,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257817',4908070,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257817',4908071,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257817',4908072,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257817',4908073,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257817',4908074,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257817',4908075,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257817',4908076,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257818',4908077,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257818',4908078,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257818',4908079,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257818',4908080,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257818',4908081,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257818',4908082,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257818',4908083,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257818',4908084,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257819',4908085,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257819',4908086,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257819',4908087,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257819',4908088,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257819',4908089,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257819',4908090,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257819',4908091,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257819',4908092,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257820',4908093,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257820',4908094,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257820',4908095,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257820',4908096,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257820',4908097,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257820',4908098,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257820',4908099,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257820',4908100,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257821',4908101,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257821',4908102,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257821',4908103,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257821',4908104,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257821',4908105,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257821',4908106,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257821',4908107,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257821',4908108,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257822',4908109,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257822',4908110,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257822',4908111,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257822',4908112,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257822',4908113,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257822',4908114,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257822',4908115,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257822',4908116,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257823',4908117,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257823',4908118,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257823',4908119,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257823',4908120,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257823',4908121,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257823',4908122,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257823',4908123,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257823',4908124,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257824',4908125,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257824',4908126,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257824',4908127,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257824',4908128,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257824',4908129,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257824',4908130,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257824',4908131,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257824',4908132,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257825',4908133,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257825',4908134,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257825',4908135,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257825',4908136,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257825',4908137,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257825',4908138,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257825',4908139,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257825',4908140,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257826',4908141,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257826',4908142,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257826',4908143,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257826',4908144,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257826',4908145,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257826',4908146,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257826',4908147,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257826',4908148,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257827',4908149,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257827',4908150,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257827',4908151,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257827',4908152,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257827',4908153,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257827',4908154,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257827',4908155,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257827',4908156,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257828',4908157,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257828',4908158,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257828',4908159,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257828',4908160,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257828',4908161,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257828',4908162,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257828',4908163,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257828',4908164,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257829',4908165,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257829',4908166,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257829',4908167,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257829',4908168,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257829',4908169,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257829',4908170,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257829',4908171,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257829',4908172,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257830',4908173,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257830',4908174,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257830',4908175,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257830',4908176,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257830',4908177,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257830',4908178,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257830',4908179,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257830',4908180,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257831',4908181,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257831',4908182,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257831',4908183,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257831',4908184,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257831',4908185,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257831',4908186,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257831',4908187,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257831',4908188,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257832',4908189,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257832',4908190,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257832',4908191,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257832',4908192,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257832',4908193,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257832',4908194,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257832',4908195,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257832',4908196,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257833',4908197,'1640','222',2864475.45,2864475.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257833',4908198,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257833',4908199,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257833',4908200,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257833',4908201,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257833',4908202,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257833',4908203,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257833',4908204,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257834',4908205,'1640','222',2864475.45,2869918.44,5442.99,1006953.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257834',4908206,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257834',4908207,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257834',4908208,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257834',4908209,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257834',4908210,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257834',4908211,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257834',4908212,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257835',4908213,'1640','222',2869918.44,2875534.95,5616.51,1039054.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257835',4908214,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257835',4908215,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257835',4908216,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257835',4908217,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257835',4908218,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257835',4908219,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257835',4908220,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257836',4908221,'1640','222',2875534.95,2880678.33,5143.38,951525.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257836',4908222,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257836',4908223,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257836',4908224,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257836',4908225,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257836',4908226,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257836',4908227,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257836',4908228,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257837',4908229,'1640','222',2880678.33,2885811.16,5132.83,949573.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257837',4908230,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257837',4908231,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257837',4908232,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257837',4908233,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257837',4908234,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257837',4908235,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257837',4908236,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257838',4908237,'1640','222',2885811.16,2891072.62,5261.46,973370.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','257838',4908238,'1641','222',1578902.53,1578902.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257838',4908239,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257838',4908240,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257838',4908241,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257838',4908242,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257838',4908243,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257838',4908244,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257839',4908245,'1640','222',2891072.62,2895624.76,4552.14,842145.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','257839',4908246,'1641','222',1578902.53,1579669.85,767.32,141954.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257839',4908247,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257839',4908248,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257839',4908249,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257839',4908250,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257839',4908251,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257839',4908252,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257840',4908253,'1640','222',2895624.76,2898842.30,3217.54,595244.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','257840',4908254,'1641','222',1579669.85,1582021.68,2351.83,435088.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257840',4908255,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257840',4908256,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257840',4908257,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257840',4908258,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257840',4908259,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257840',4908260,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257841',4908261,'1640','222',2898842.30,2904163.03,5320.73,984335.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','257841',4908262,'1641','222',1582021.68,1582110.09,88.41,16355.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257841',4908263,'1642','222',4073115.72,4073115.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257841',4908264,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257841',4908265,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257841',4908266,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257841',4908267,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257841',4908268,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257842',4908269,'1640','222',2904163.03,2904163.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257842',4908270,'1641','222',1582110.09,1586897.24,4787.15,885622.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','257842',4908271,'1642','222',4073115.72,4074493.00,1377.28,254796.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','257842',4908272,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257842',4908273,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257842',4908274,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257842',4908275,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257842',4908276,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257843',4908277,'1640','222',2904163.03,2906025.20,1862.17,344501.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','257843',4908278,'1641','222',1586897.24,1589962.40,3065.16,567054.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','257843',4908279,'1642','222',4074493.00,4077841.52,3348.52,619476.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','257843',4908280,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257843',4908281,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257843',4908282,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257843',4908283,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257843',4908284,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257844',4908285,'1640','222',2906025.20,2912567.86,6542.66,1210392.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','257844',4908286,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257844',4908287,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257844',4908288,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257844',4908289,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257844',4908290,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257844',4908291,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257844',4908292,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257845',4908293,'1640','222',2912567.86,2918834.35,6266.49,1159300.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257845',4908294,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257845',4908295,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257845',4908296,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257845',4908297,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257845',4908298,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257845',4908299,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257845',4908300,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257846',4908301,'1640','222',2918834.35,2924835.03,6000.68,1110125.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','257846',4908302,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257846',4908303,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257846',4908304,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257846',4908305,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257846',4908306,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257846',4908307,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257846',4908308,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257847',4908309,'1640','222',2924835.03,2930269.03,5434.00,1005290.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257847',4908310,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257847',4908311,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257847',4908312,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257847',4908313,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257847',4908314,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257847',4908315,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257847',4908316,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257848',4908317,'1640','222',2930269.03,2934286.34,4017.31,743202.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257848',4908318,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257848',4908319,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257848',4908320,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257848',4908321,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257848',4908322,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257848',4908323,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257848',4908324,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257849',4908325,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257849',4908326,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257849',4908327,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257849',4908328,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257849',4908329,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257849',4908330,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257849',4908331,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257849',4908332,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257850',4908333,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257850',4908334,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257850',4908335,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257850',4908336,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257850',4908337,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257850',4908338,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257850',4908339,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257850',4908340,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257851',4908341,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257851',4908342,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257851',4908343,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257851',4908344,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257851',4908345,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257851',4908346,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257851',4908347,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257851',4908348,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257852',4908349,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257852',4908350,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257852',4908351,'1642','222',4077841.52,4077841.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257852',4908352,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257852',4908353,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257852',4908354,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257852',4908355,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257852',4908356,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257853',4908357,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257853',4908358,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257853',4908359,'1642','222',4077841.52,4083093.48,5251.96,971612.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','257853',4908360,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257853',4908361,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257853',4908362,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257853',4908363,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257853',4908364,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257854',4908365,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257854',4908366,'1641','222',1589962.40,1589962.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257854',4908367,'1642','222',4083093.48,4087650.17,4556.69,842987.65,0.00,0.00,0.00,0.00,0.00),('5','96','585','257854',4908368,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257854',4908369,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257854',4908370,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257854',4908371,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257854',4908372,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257855',4908373,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257855',4908374,'1641','222',1589962.40,1591552.78,1590.38,294220.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257855',4908375,'1642','222',4087650.17,4091184.28,3534.11,653810.35,0.00,0.00,0.00,0.00,0.00),('5','96','585','257855',4908376,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257855',4908377,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257855',4908378,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257855',4908379,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257855',4908380,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257856',4908381,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257856',4908382,'1641','222',1591552.78,1595202.79,3650.01,675251.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257856',4908383,'1642','222',4091184.28,4094700.31,3516.03,650465.55,0.00,0.00,0.00,0.00,0.00),('5','96','585','257856',4908384,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257856',4908385,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257856',4908386,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257856',4908387,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257856',4908388,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257857',4908389,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257857',4908390,'1641','222',1595202.79,1597541.49,2338.70,432659.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257857',4908391,'1642','222',4094700.31,4098121.69,3421.38,632955.30,0.00,0.00,0.00,0.00,0.00),('5','96','585','257857',4908392,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257857',4908393,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257857',4908394,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257857',4908395,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257857',4908396,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257858',4908397,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257858',4908398,'1641','222',1597541.49,1599691.37,2149.88,397727.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','257858',4908399,'1642','222',4098121.69,4101357.06,3235.37,598543.45,0.00,0.00,0.00,0.00,0.00),('5','96','585','257858',4908400,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257858',4908401,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257858',4908402,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257858',4908403,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257858',4908404,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257859',4908405,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257859',4908406,'1641','222',1599691.37,1602491.45,2800.08,518014.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','257859',4908407,'1642','222',4101357.06,4104175.32,2818.26,521378.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','257859',4908408,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257859',4908409,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257859',4908410,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257859',4908411,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257859',4908412,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257860',4908413,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257860',4908414,'1641','222',1602491.45,1605529.74,3038.29,562083.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257860',4908415,'1642','222',4104175.32,4106950.36,2775.04,513382.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','257860',4908416,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257860',4908417,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257860',4908418,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257860',4908419,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257860',4908420,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257861',4908421,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257861',4908422,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257861',4908423,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257861',4908424,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257861',4908425,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257861',4908426,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257861',4908427,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257861',4908428,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257862',4908429,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257862',4908430,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257862',4908431,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257862',4908432,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257862',4908433,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257862',4908434,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257862',4908435,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257862',4908436,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257863',4908437,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257863',4908438,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257863',4908439,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257863',4908440,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257863',4908441,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257863',4908442,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257863',4908443,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257863',4908444,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257864',4908445,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257864',4908446,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257864',4908447,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257864',4908448,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257864',4908449,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257864',4908450,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257864',4908451,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257864',4908452,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257865',4908453,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257865',4908454,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257865',4908455,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257865',4908456,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257865',4908457,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257865',4908458,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257865',4908459,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257865',4908460,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257866',4908461,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257866',4908462,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257866',4908463,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257866',4908464,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257866',4908465,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257866',4908466,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257866',4908467,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257866',4908468,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257867',4908469,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257867',4908470,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257867',4908471,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257867',4908472,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257867',4908473,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257867',4908474,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257867',4908475,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257867',4908476,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257868',4908477,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257868',4908478,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257868',4908479,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257868',4908480,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257868',4908481,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257868',4908482,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257868',4908483,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257868',4908484,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257869',4908485,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257869',4908486,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257869',4908487,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257869',4908488,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257869',4908489,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257869',4908490,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257869',4908491,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257869',4908492,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257870',4908493,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257870',4908494,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257870',4908495,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257870',4908496,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257870',4908497,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257870',4908498,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257870',4908499,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257870',4908500,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257871',4908501,'1640','222',2934286.34,2934286.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257871',4908502,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257871',4908503,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257871',4908504,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257871',4908505,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257871',4908506,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257871',4908507,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257871',4908508,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257872',4908509,'1640','222',2934286.34,2936372.54,2086.20,385947.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257872',4908510,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257872',4908511,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257872',4908512,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257872',4908513,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257872',4908514,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257872',4908515,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257872',4908516,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257873',4908517,'1640','222',2936372.54,2941548.13,5175.59,957484.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257873',4908518,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257873',4908519,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257873',4908520,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257873',4908521,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257873',4908522,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257873',4908523,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257873',4908524,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257874',4908525,'1640','222',2941548.13,2946781.91,5233.78,968249.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257874',4908526,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257874',4908527,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257874',4908528,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257874',4908529,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257874',4908530,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257874',4908531,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257874',4908532,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257875',4908533,'1640','222',2946781.91,2951961.31,5179.40,958189.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257875',4908534,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257875',4908535,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257875',4908536,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257875',4908537,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257875',4908538,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257875',4908539,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257875',4908540,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257876',4908541,'1640','222',2951961.31,2957204.55,5243.24,969999.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','257876',4908542,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257876',4908543,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257876',4908544,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257876',4908545,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257876',4908546,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257876',4908547,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257876',4908548,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257877',4908549,'1640','222',2957204.55,2961070.05,3865.50,715117.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257877',4908550,'1641','222',1605529.74,1605529.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257877',4908551,'1642','222',4106950.36,4106950.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257877',4908552,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257877',4908553,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257877',4908554,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257877',4908555,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257877',4908556,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257878',4908557,'1640','222',2961070.05,2963238.35,2168.30,401135.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257878',4908558,'1641','222',1605529.74,1606848.54,1318.80,243978.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257878',4908559,'1642','222',4106950.36,4109047.77,2097.41,388020.85,0.00,0.00,0.00,0.00,0.00),('5','96','585','257878',4908560,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257878',4908561,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257878',4908562,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257878',4908563,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257878',4908564,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257879',4908565,'1640','222',2963238.35,2965436.53,2198.18,406663.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257879',4908566,'1641','222',1606848.54,1609232.17,2383.63,440971.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257879',4908567,'1642','222',4109047.77,4111781.65,2733.88,505767.80,0.00,0.00,0.00,0.00,0.00),('5','96','585','257879',4908568,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257879',4908569,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257879',4908570,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257879',4908571,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257879',4908572,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257880',4908573,'1640','222',2965436.53,2967428.03,1991.50,368427.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257880',4908574,'1641','222',1609232.17,1611367.76,2135.59,395084.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257880',4908575,'1642','222',4111781.65,4114201.21,2419.56,447618.60,0.00,0.00,0.00,0.00,0.00),('5','96','585','257880',4908576,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257880',4908577,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257880',4908578,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257880',4908579,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257880',4908580,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257881',4908581,'1640','222',2967428.03,2967701.61,273.58,50612.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257881',4908582,'1641','222',1611367.76,1613977.64,2609.88,482827.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','257881',4908583,'1642','222',4114201.21,4117092.25,2891.04,534842.40,0.00,0.00,0.00,0.00,0.00),('5','96','585','257881',4908584,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257881',4908585,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257881',4908586,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257881',4908587,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257881',4908588,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257882',4908589,'1640','222',2967701.61,2968560.83,859.22,158955.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257882',4908590,'1641','222',1613977.64,1615770.54,1792.90,331686.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257882',4908591,'1642','222',4117092.25,4119886.98,2794.73,517025.05,0.00,0.00,0.00,0.00,0.00),('5','96','585','257882',4908592,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257882',4908593,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257882',4908594,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257882',4908595,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257882',4908596,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257883',4908597,'1640','222',2968560.83,2970471.34,1910.51,353444.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257883',4908598,'1641','222',1615770.54,1618358.57,2588.03,478785.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257883',4908599,'1642','222',4119886.98,4122928.20,3041.22,562625.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','257883',4908600,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257883',4908601,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257883',4908602,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257883',4908603,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257883',4908604,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257884',4908605,'1640','222',2970471.34,2972327.64,1856.30,343415.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257884',4908606,'1641','222',1618358.57,1620582.36,2223.79,411401.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257884',4908607,'1642','222',4122928.20,4125603.26,2675.06,494886.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','257884',4908608,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257884',4908609,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257884',4908610,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257884',4908611,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257884',4908612,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257885',4908613,'1640','222',2972327.64,2975079.56,2751.92,509105.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257885',4908614,'1641','222',1620582.36,1622485.60,1903.24,352099.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','257885',4908615,'1642','222',4125603.26,4128398.40,2795.14,517100.90,0.00,0.00,0.00,0.00,0.00),('5','96','585','257885',4908616,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257885',4908617,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257885',4908618,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257885',4908619,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257885',4908620,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257886',4908621,'1640','222',2975079.56,2979212.98,4133.42,764682.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257886',4908622,'1641','222',1622485.60,1622715.51,229.91,42533.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257886',4908623,'1642','222',4128398.40,4129607.47,1209.07,223677.95,0.00,0.00,0.00,0.00,0.00),('5','96','585','257886',4908624,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257886',4908625,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257886',4908626,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257886',4908627,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257886',4908628,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257887',4908629,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257887',4908630,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257887',4908631,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257887',4908632,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257887',4908633,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257887',4908634,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257887',4908635,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257887',4908636,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257888',4908637,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257888',4908638,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257888',4908639,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257888',4908640,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257888',4908641,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257888',4908642,'1645','222',2943960.04,2943960.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257888',4908643,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257888',4908644,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257889',4908645,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257889',4908646,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257889',4908647,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257889',4908648,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257889',4908649,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257889',4908650,'1645','222',2943960.04,2948028.05,4068.01,752581.85,0.00,0.00,0.00,0.00,0.00),('5','96','587','257889',4908651,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257889',4908652,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257890',4908653,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257890',4908654,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257890',4908655,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257890',4908656,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257890',4908657,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257890',4908658,'1645','222',2948028.05,2953699.64,5671.59,1049244.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','257890',4908659,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257890',4908660,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257891',4908661,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257891',4908662,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257891',4908663,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257891',4908664,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257891',4908665,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257891',4908666,'1645','222',2953699.64,2960357.83,6658.19,1231765.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','257891',4908667,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257891',4908668,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257892',4908669,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257892',4908670,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257892',4908671,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257892',4908672,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257892',4908673,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257892',4908674,'1645','222',2960357.83,2965787.94,5430.11,1004570.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','257892',4908675,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257892',4908676,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257893',4908677,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257893',4908678,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257893',4908679,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257893',4908680,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257893',4908681,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257893',4908682,'1645','222',2965787.94,2971260.33,5472.39,1012392.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','257893',4908683,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257893',4908684,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257894',4908685,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257894',4908686,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257894',4908687,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257894',4908688,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257894',4908689,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257894',4908690,'1645','222',2971260.33,2976284.29,5023.96,929432.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','257894',4908691,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257894',4908692,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257895',4908693,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257895',4908694,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257895',4908695,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257895',4908696,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257895',4908697,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257895',4908698,'1645','222',2976284.29,2981456.38,5172.09,956836.65,0.00,0.00,0.00,0.00,0.00),('5','96','587','257895',4908699,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257895',4908700,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257896',4908701,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257896',4908702,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257896',4908703,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257896',4908704,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257896',4908705,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257896',4908706,'1645','222',2981456.38,2986847.21,5390.83,997303.55,0.00,0.00,0.00,0.00,0.00),('5','96','587','257896',4908707,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257896',4908708,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257897',4908709,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257897',4908710,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257897',4908711,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257897',4908712,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257897',4908713,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257897',4908714,'1645','222',2986847.21,2988068.29,1221.08,225899.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','257897',4908715,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257897',4908716,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257898',4908717,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257898',4908718,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257898',4908719,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257898',4908720,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257898',4908721,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257898',4908722,'1645','222',2988068.29,2992148.99,4080.70,754929.50,0.00,0.00,0.00,0.00,0.00),('5','96','587','257898',4908723,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257898',4908724,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257899',4908725,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257899',4908726,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257899',4908727,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257899',4908728,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257899',4908729,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257899',4908730,'1645','222',2992148.99,2997196.10,5047.11,933715.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','257899',4908731,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257899',4908732,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257900',4908733,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257900',4908734,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257900',4908735,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257900',4908736,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257900',4908737,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257900',4908738,'1645','222',2997196.10,3003410.27,6214.17,1149621.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','257900',4908739,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257900',4908740,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257901',4908741,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257901',4908742,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257901',4908743,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257901',4908744,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257901',4908745,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257901',4908746,'1645','222',3003410.27,3008611.98,5201.71,962316.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','257901',4908747,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257901',4908748,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257902',4908749,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257902',4908750,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257902',4908751,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257902',4908752,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257902',4908753,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257902',4908754,'1645','222',3008611.98,3014157.41,5545.43,1025904.55,0.00,0.00,0.00,0.00,0.00),('5','96','587','257902',4908755,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257902',4908756,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257903',4908757,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257903',4908758,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257903',4908759,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257903',4908760,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257903',4908761,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257903',4908762,'1645','222',3014157.41,3019357.71,5200.30,962055.50,0.00,0.00,0.00,0.00,0.00),('5','96','587','257903',4908763,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257903',4908764,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257904',4908765,'1640','222',2979212.98,2979212.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257904',4908766,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257904',4908767,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257904',4908768,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257904',4908769,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257904',4908770,'1645','222',3019357.71,3024158.45,4800.74,888136.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','257904',4908771,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257904',4908772,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257905',4908773,'1640','222',2979212.98,2981994.17,2781.19,514520.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257905',4908774,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257905',4908775,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257905',4908776,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257905',4908777,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257905',4908778,'1645','222',3024158.45,3027046.02,2887.57,534200.45,0.00,0.00,0.00,0.00,0.00),('5','96','587','257905',4908779,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257905',4908780,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257906',4908781,'1640','222',2981994.17,2986721.35,4727.18,874528.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257906',4908782,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257906',4908783,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257906',4908784,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257906',4908785,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257906',4908786,'1645','222',3027046.02,3027343.70,297.68,55070.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','257906',4908787,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257906',4908788,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257907',4908789,'1640','222',2986721.35,2991776.96,5055.61,935287.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257907',4908790,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257907',4908791,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257907',4908792,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257907',4908793,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257907',4908794,'1645','222',3027343.70,3027343.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257907',4908795,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257907',4908796,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257908',4908797,'1640','222',2991776.96,2994868.41,3091.45,571918.25,0.00,0.00,0.00,0.00,0.00),('5','96','584','257908',4908798,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257908',4908799,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257908',4908800,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257908',4908801,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257908',4908802,'1645','222',3027343.70,3027343.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257908',4908803,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257908',4908804,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257909',4908805,'1640','222',2994868.41,3001508.05,6639.64,1228333.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','257909',4908806,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257909',4908807,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257909',4908808,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257909',4908809,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257909',4908810,'1645','222',3027343.70,3027343.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257909',4908811,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257909',4908812,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257910',4908813,'1640','222',3001508.05,3006220.75,4712.70,871849.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257910',4908814,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257910',4908815,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257910',4908816,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257910',4908817,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257910',4908818,'1645','222',3027343.70,3027343.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257910',4908819,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257910',4908820,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257911',4908821,'1640','222',3006220.75,3010610.54,4389.79,812111.15,0.00,0.00,0.00,0.00,0.00),('5','96','584','257911',4908822,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257911',4908823,'1642','222',4129607.47,4129607.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257911',4908824,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257911',4908825,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257911',4908826,'1645','222',3027343.70,3027343.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257911',4908827,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257911',4908828,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257912',4908829,'1640','222',3010610.54,3011901.11,1290.57,238755.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','257912',4908830,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257912',4908831,'1642','222',4129607.47,4131561.67,1954.20,361527.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257912',4908832,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257912',4908833,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257912',4908834,'1645','222',3027343.70,3030604.82,3261.12,603307.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','257912',4908835,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257912',4908836,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257913',4908837,'1640','222',3011901.11,3012934.82,1033.71,191236.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257913',4908838,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257913',4908839,'1642','222',4131561.67,4135166.06,3604.39,666812.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','257913',4908840,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257913',4908841,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257913',4908842,'1645','222',3030604.82,3032988.62,2383.80,441003.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257913',4908843,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257913',4908844,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257914',4908845,'1640','222',3012934.82,3013688.40,753.58,139412.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','257914',4908846,'1642','222',4135166.06,4138667.49,3501.43,647764.55,0.00,0.00,0.00,0.00,0.00),('5','96','584','257914',4908847,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257914',4908848,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257914',4908849,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257914',4908850,'1645','222',3032988.62,3035817.28,2828.66,523302.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','257914',4908851,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257914',4908852,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257915',4908853,'1640','222',3013688.40,3013688.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257915',4908854,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257915',4908855,'1642','222',4138667.49,4141869.91,3202.42,592447.70,0.00,0.00,0.00,0.00,0.00),('5','96','585','257915',4908856,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257915',4908857,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257915',4908858,'1645','222',3035817.28,3038919.39,3102.11,573890.35,0.00,0.00,0.00,0.00,0.00),('5','96','587','257915',4908859,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257915',4908860,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257916',4908861,'1640','222',3013688.40,3014768.93,1080.53,199898.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','257916',4908862,'1641','222',1622715.51,1622715.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257916',4908863,'1642','222',4141869.91,4144233.10,2363.19,437190.15,0.00,0.00,0.00,0.00,0.00),('5','96','585','257916',4908864,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257916',4908865,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257916',4908866,'1645','222',3038919.39,3042667.98,3748.59,693489.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','257916',4908867,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257916',4908868,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257917',4908869,'1640','222',3014768.93,3016855.74,2086.81,386059.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257917',4908870,'1641','222',1622715.51,1622911.65,196.14,36285.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','257917',4908871,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257917',4908872,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257917',4908873,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257917',4908874,'1645','222',3042667.98,3047164.17,4496.19,831795.15,0.00,0.00,0.00,0.00,0.00),('5','96','587','257917',4908875,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257917',4908876,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257918',4908877,'1640','222',3016855.74,3019708.28,2852.54,527719.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','257918',4908878,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257918',4908879,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257918',4908880,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257918',4908881,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257918',4908882,'1645','222',3047164.17,3051363.80,4199.63,776931.55,0.00,0.00,0.00,0.00,0.00),('5','96','587','257918',4908883,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257918',4908884,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257919',4908885,'1640','222',3019708.28,3022715.78,3007.50,556387.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257919',4908886,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257919',4908887,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257919',4908888,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257919',4908889,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257919',4908890,'1645','222',3051363.80,3055764.06,4400.26,814048.10,0.00,0.00,0.00,0.00,0.00),('5','96','587','257919',4908891,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257919',4908892,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257920',4908893,'1640','222',3022715.78,3023850.39,1134.61,209902.85,0.00,0.00,0.00,0.00,0.00),('5','96','584','257920',4908894,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257920',4908895,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257920',4908896,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257920',4908897,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257920',4908898,'1645','222',3055764.06,3057137.49,1373.43,254084.55,0.00,0.00,0.00,0.00,0.00),('5','96','587','257920',4908899,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257920',4908900,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257921',4908901,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257921',4908902,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257921',4908903,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257921',4908904,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257921',4908905,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257921',4908906,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257921',4908907,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257921',4908908,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257922',4908909,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257922',4908910,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257922',4908911,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257922',4908912,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257922',4908913,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257922',4908914,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257922',4908915,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257922',4908916,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257923',4908917,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257923',4908918,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257923',4908919,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257923',4908920,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257923',4908921,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257923',4908922,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257923',4908923,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257923',4908924,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257924',4908925,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257924',4908926,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257924',4908927,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257924',4908928,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257924',4908929,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257924',4908930,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257924',4908931,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257924',4908932,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257925',4908933,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257925',4908934,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257925',4908935,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257925',4908936,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257925',4908937,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257925',4908938,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257925',4908939,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257925',4908940,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257926',4908941,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257926',4908942,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257926',4908943,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257926',4908944,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257926',4908945,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257926',4908946,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257926',4908947,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257926',4908948,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257927',4908949,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257927',4908950,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257927',4908951,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257927',4908952,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257927',4908953,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257927',4908954,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257927',4908955,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257927',4908956,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257928',4908957,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257928',4908958,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257928',4908959,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257928',4908960,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257928',4908961,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257928',4908962,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257928',4908963,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257928',4908964,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257929',4908965,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257929',4908966,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257929',4908967,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257929',4908968,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257929',4908969,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257929',4908970,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257929',4908971,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257929',4908972,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257930',4908973,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257930',4908974,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257930',4908975,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257930',4908976,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257930',4908977,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257930',4908978,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257930',4908979,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257930',4908980,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257931',4908981,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257931',4908982,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257931',4908983,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257931',4908984,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257931',4908985,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257931',4908986,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257931',4908987,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257931',4908988,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257932',4908989,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257932',4908990,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257932',4908991,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257932',4908992,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257932',4908993,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257932',4908994,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257932',4908995,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257932',4908996,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257933',4908997,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257933',4908998,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257933',4908999,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257933',4909000,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257933',4909001,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257933',4909002,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257933',4909003,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257933',4909004,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257934',4909005,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257934',4909006,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257934',4909007,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257934',4909008,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257934',4909009,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257934',4909010,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257934',4909011,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257934',4909012,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257935',4909013,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257935',4909014,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257935',4909015,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257935',4909016,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257935',4909017,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257935',4909018,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257935',4909019,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257935',4909020,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257936',4909021,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257936',4909022,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257936',4909023,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257936',4909024,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257936',4909025,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257936',4909026,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257936',4909027,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257936',4909028,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257937',4909029,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257937',4909030,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257937',4909031,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257937',4909032,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257937',4909033,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257937',4909034,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257937',4909035,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257937',4909036,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257938',4909037,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257938',4909038,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257938',4909039,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257938',4909040,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257938',4909041,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257938',4909042,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257938',4909043,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257938',4909044,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257939',4909045,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257939',4909046,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257939',4909047,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257939',4909048,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257939',4909049,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257939',4909050,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257939',4909051,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257939',4909052,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257940',4909053,'1640','222',3023850.39,3023850.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257940',4909054,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257940',4909055,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257940',4909056,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257940',4909057,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257940',4909058,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257940',4909059,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257940',4909060,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257941',4909061,'1640','222',3023850.39,3030593.30,6742.91,1247438.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257941',4909062,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257941',4909063,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257941',4909064,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257941',4909065,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257941',4909066,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257941',4909067,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257941',4909068,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257942',4909069,'1640','222',3030593.30,3037113.61,6520.31,1206257.35,0.00,0.00,0.00,0.00,0.00),('5','96','584','257942',4909070,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257942',4909071,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257942',4909072,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257942',4909073,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257942',4909074,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257942',4909075,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257942',4909076,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257943',4909077,'1640','222',3037113.61,3043531.21,6417.60,1187256.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257943',4909078,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257943',4909079,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257943',4909080,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257943',4909081,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257943',4909082,'1645','222',3057137.49,3057137.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257943',4909083,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257943',4909084,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257944',4909085,'1640','222',3043531.21,3048303.98,4772.77,882962.45,0.00,0.00,0.00,0.00,0.00),('5','96','584','257944',4909086,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257944',4909087,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257944',4909088,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257944',4909089,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257944',4909090,'1645','222',3057137.49,3062872.01,5734.52,1060886.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','257944',4909091,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257944',4909092,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257945',4909093,'1640','222',3048303.98,3053668.38,5364.40,992414.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257945',4909094,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257945',4909095,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257945',4909096,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257945',4909097,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257945',4909098,'1645','222',3062872.01,3068307.42,5435.41,1005550.85,0.00,0.00,0.00,0.00,0.00),('5','96','587','257945',4909099,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257945',4909100,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257946',4909101,'1640','222',3053668.38,3059642.87,5974.49,1105280.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257946',4909102,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257946',4909103,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257946',4909104,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257946',4909105,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257946',4909106,'1645','222',3068307.42,3071257.42,2950.00,545750.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257946',4909107,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257946',4909108,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257947',4909109,'1640','222',3059642.87,3065811.57,6168.70,1141209.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','257947',4909110,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257947',4909111,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257947',4909112,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257947',4909113,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257947',4909114,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257947',4909115,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257947',4909116,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257948',4909117,'1640','222',3065811.57,3071977.69,6166.12,1140732.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','257948',4909118,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257948',4909119,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257948',4909120,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257948',4909121,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257948',4909122,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257948',4909123,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257948',4909124,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257949',4909125,'1640','222',3071977.69,3077521.98,5544.29,1025693.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257949',4909126,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257949',4909127,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257949',4909128,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257949',4909129,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257949',4909130,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257949',4909131,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257949',4909132,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257950',4909133,'1640','222',3077521.98,3084138.44,6616.46,1224045.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','257950',4909134,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257950',4909135,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257950',4909136,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257950',4909137,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257950',4909138,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257950',4909139,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257950',4909140,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257951',4909141,'1640','222',3084138.44,3089757.86,5619.42,1039592.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257951',4909142,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257951',4909143,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257951',4909144,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257951',4909145,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257951',4909146,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257951',4909147,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257951',4909148,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257952',4909149,'1640','222',3089757.86,3093447.19,3689.33,682526.05,0.00,0.00,0.00,0.00,0.00),('5','96','584','257952',4909150,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257952',4909151,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257952',4909152,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257952',4909153,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257952',4909154,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257952',4909155,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257952',4909156,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257953',4909157,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257953',4909158,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257953',4909159,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257953',4909160,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257953',4909161,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257953',4909162,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257953',4909163,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257953',4909164,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257954',4909165,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257954',4909166,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257954',4909167,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257954',4909168,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257954',4909169,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257954',4909170,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257954',4909171,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257954',4909172,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257955',4909173,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257955',4909174,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257955',4909175,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257955',4909176,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257955',4909177,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257955',4909178,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257955',4909179,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257955',4909180,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257956',4909181,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257956',4909182,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257956',4909183,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257956',4909184,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257956',4909185,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257956',4909186,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257956',4909187,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257956',4909188,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257957',4909189,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257957',4909190,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257957',4909191,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257957',4909192,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257957',4909193,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257957',4909194,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257957',4909195,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257957',4909196,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257958',4909197,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257958',4909198,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257958',4909199,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257958',4909200,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257958',4909201,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257958',4909202,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257958',4909203,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257958',4909204,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257959',4909205,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257959',4909206,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257959',4909207,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257959',4909208,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257959',4909209,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257959',4909210,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257959',4909211,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257959',4909212,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257960',4909213,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257960',4909214,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257960',4909215,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257960',4909216,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257960',4909217,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257960',4909218,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257960',4909219,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257960',4909220,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257961',4909221,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257961',4909222,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257961',4909223,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257961',4909224,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257961',4909225,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257961',4909226,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257961',4909227,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257961',4909228,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257962',4909229,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257962',4909230,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257962',4909231,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257962',4909232,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257962',4909233,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257962',4909234,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257962',4909235,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257962',4909236,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257963',4909237,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257963',4909238,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257963',4909239,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257963',4909240,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257963',4909241,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257963',4909242,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257963',4909243,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257963',4909244,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257964',4909245,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257964',4909246,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257964',4909247,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257964',4909248,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257964',4909249,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257964',4909250,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257964',4909251,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257964',4909252,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257965',4909253,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257965',4909254,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257965',4909255,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257965',4909256,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257965',4909257,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257965',4909258,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257965',4909259,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257965',4909260,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257966',4909261,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257966',4909262,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257966',4909263,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257966',4909264,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257966',4909265,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257966',4909266,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257966',4909267,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257966',4909268,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257967',4909269,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257967',4909270,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257967',4909271,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257967',4909272,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257967',4909273,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257967',4909274,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257967',4909275,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257967',4909276,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257968',4909277,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257968',4909278,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257968',4909279,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257968',4909280,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257968',4909281,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257968',4909282,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257968',4909283,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257968',4909284,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257969',4909285,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257969',4909286,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257969',4909287,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257969',4909288,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257969',4909289,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257969',4909290,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257969',4909291,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257969',4909292,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257970',4909293,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257970',4909294,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257970',4909295,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257970',4909296,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257970',4909297,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257970',4909298,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257970',4909299,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257970',4909300,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257971',4909301,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257971',4909302,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257971',4909303,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257971',4909304,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257971',4909305,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257971',4909306,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257971',4909307,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257971',4909308,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257972',4909309,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257972',4909310,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257972',4909311,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257972',4909312,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257972',4909313,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257972',4909314,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257972',4909315,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257972',4909316,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257973',4909317,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257973',4909318,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257973',4909319,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257973',4909320,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257973',4909321,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257973',4909322,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257973',4909323,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257973',4909324,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257974',4909325,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257974',4909326,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257974',4909327,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257974',4909328,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257974',4909329,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257974',4909330,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257974',4909331,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257974',4909332,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257975',4909333,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257975',4909334,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257975',4909335,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257975',4909336,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257975',4909337,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257975',4909338,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257975',4909339,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257975',4909340,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257976',4909341,'1640','222',3093447.19,3093447.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257976',4909342,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257976',4909343,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257976',4909344,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257976',4909345,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257976',4909346,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257976',4909347,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257976',4909348,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257977',4909349,'1640','222',3093447.19,3097071.08,3623.89,670419.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257977',4909350,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257977',4909351,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257977',4909352,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257977',4909353,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257977',4909354,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257977',4909355,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257977',4909356,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257978',4909357,'1640','222',3097071.08,3101963.23,4892.15,905047.75,0.00,0.00,0.00,0.00,0.00),('5','96','584','257978',4909358,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257978',4909359,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257978',4909360,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257978',4909361,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257978',4909362,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257978',4909363,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257978',4909364,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257979',4909365,'1640','222',3101963.23,3108211.50,6248.27,1155929.95,0.00,0.00,0.00,0.00,0.00),('5','96','584','257979',4909366,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257979',4909367,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257979',4909368,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257979',4909369,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257979',4909370,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257979',4909371,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257979',4909372,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257980',4909373,'1640','222',3108211.50,3113881.56,5670.06,1048961.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','257980',4909374,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257980',4909375,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257980',4909376,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257980',4909377,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257980',4909378,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257980',4909379,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257980',4909380,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257981',4909381,'1640','222',3113881.56,3120285.72,6404.16,1184769.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','257981',4909382,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257981',4909383,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257981',4909384,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257981',4909385,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257981',4909386,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257981',4909387,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257981',4909388,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257982',4909389,'1640','222',3120285.72,3126188.14,5902.42,1091947.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257982',4909390,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257982',4909391,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257982',4909392,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257982',4909393,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257982',4909394,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257982',4909395,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257982',4909396,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257983',4909397,'1640','222',3126188.14,3131422.63,5234.49,968380.65,0.00,0.00,0.00,0.00,0.00),('5','96','584','257983',4909398,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257983',4909399,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257983',4909400,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257983',4909401,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257983',4909402,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257983',4909403,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257983',4909404,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257984',4909405,'1640','222',3131422.63,3133070.45,1647.82,304846.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','257984',4909406,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257984',4909407,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257984',4909408,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257984',4909409,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257984',4909410,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257984',4909411,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257984',4909412,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257985',4909413,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257985',4909414,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257985',4909415,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257985',4909416,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257985',4909417,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257985',4909418,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257985',4909419,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257985',4909420,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257986',4909421,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257986',4909422,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257986',4909423,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257986',4909424,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257986',4909425,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257986',4909426,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257986',4909427,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257986',4909428,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257987',4909429,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257987',4909430,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257987',4909431,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257987',4909432,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257987',4909433,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257987',4909434,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257987',4909435,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257987',4909436,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257988',4909437,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257988',4909438,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257988',4909439,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257988',4909440,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257988',4909441,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257988',4909442,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257988',4909443,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257988',4909444,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257989',4909445,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257989',4909446,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257989',4909447,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257989',4909448,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257989',4909449,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257989',4909450,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257989',4909451,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257989',4909452,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257990',4909453,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257990',4909454,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257990',4909455,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257990',4909456,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257990',4909457,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257990',4909458,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257990',4909459,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257990',4909460,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257991',4909461,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257991',4909462,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257991',4909463,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257991',4909464,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257991',4909465,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257991',4909466,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257991',4909467,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257991',4909468,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257992',4909469,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257992',4909470,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257992',4909471,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257992',4909472,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257992',4909473,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257992',4909474,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257992',4909475,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257992',4909476,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257993',4909477,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257993',4909478,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257993',4909479,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257993',4909480,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257993',4909481,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257993',4909482,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257993',4909483,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257993',4909484,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257994',4909485,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257994',4909486,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257994',4909487,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257994',4909488,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257994',4909489,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257994',4909490,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257994',4909491,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257994',4909492,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257995',4909493,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257995',4909494,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257995',4909495,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257995',4909496,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257995',4909497,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257995',4909498,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257995',4909499,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257995',4909500,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257996',4909501,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257996',4909502,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257996',4909503,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257996',4909504,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257996',4909505,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257996',4909506,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257996',4909507,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257996',4909508,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257997',4909509,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257997',4909510,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257997',4909511,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257997',4909512,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257997',4909513,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257997',4909514,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257997',4909515,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257997',4909516,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257998',4909517,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257998',4909518,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257998',4909519,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257998',4909520,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257998',4909521,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257998',4909522,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257998',4909523,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257998',4909524,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','257999',4909525,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257999',4909526,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','257999',4909527,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257999',4909528,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','257999',4909529,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','257999',4909530,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','257999',4909531,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','257999',4909532,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258000',4909533,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258000',4909534,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258000',4909535,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258000',4909536,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258000',4909537,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258000',4909538,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258000',4909539,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258000',4909540,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258001',4909541,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258001',4909542,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258001',4909543,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258001',4909544,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258001',4909545,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258001',4909546,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258001',4909547,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258001',4909548,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258002',4909549,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258002',4909550,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258002',4909551,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258002',4909552,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258002',4909553,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258002',4909554,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258002',4909555,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258002',4909556,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258003',4909557,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258003',4909558,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258003',4909559,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258003',4909560,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258003',4909561,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258003',4909562,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258003',4909563,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258003',4909564,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258004',4909565,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258004',4909566,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258004',4909567,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258004',4909568,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258004',4909569,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258004',4909570,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258004',4909571,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258004',4909572,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258005',4909573,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258005',4909574,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258005',4909575,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258005',4909576,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258005',4909577,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258005',4909578,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258005',4909579,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258005',4909580,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258006',4909581,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258006',4909582,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258006',4909583,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258006',4909584,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258006',4909585,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258006',4909586,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258006',4909587,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258006',4909588,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258007',4909589,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258007',4909590,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258007',4909591,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258007',4909592,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258007',4909593,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258007',4909594,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258007',4909595,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258007',4909596,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258008',4909597,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258008',4909598,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258008',4909599,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258008',4909600,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258008',4909601,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258008',4909602,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258008',4909603,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258008',4909604,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258009',4909605,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258009',4909606,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258009',4909607,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258009',4909608,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258009',4909609,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258009',4909610,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258009',4909611,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258009',4909612,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258010',4909613,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258010',4909614,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258010',4909615,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258010',4909616,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258010',4909617,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258010',4909618,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258010',4909619,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258010',4909620,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258011',4909621,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258011',4909622,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258011',4909623,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258011',4909624,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258011',4909625,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258011',4909626,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258011',4909627,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258011',4909628,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258012',4909629,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258012',4909630,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258012',4909631,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258012',4909632,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258012',4909633,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258012',4909634,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258012',4909635,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258012',4909636,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258013',4909637,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258013',4909638,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258013',4909639,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258013',4909640,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258013',4909641,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258013',4909642,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258013',4909643,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258013',4909644,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258014',4909645,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258014',4909646,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258014',4909647,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258014',4909648,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258014',4909649,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258014',4909650,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258014',4909651,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258014',4909652,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258015',4909653,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258015',4909654,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258015',4909655,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258015',4909656,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258015',4909657,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258015',4909658,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258015',4909659,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258015',4909660,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258016',4909661,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258016',4909662,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258016',4909663,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258016',4909664,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258016',4909665,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258016',4909666,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258016',4909667,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258016',4909668,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258017',4909669,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258017',4909670,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258017',4909671,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258017',4909672,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258017',4909673,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258017',4909674,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258017',4909675,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258017',4909676,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258018',4909677,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258018',4909678,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258018',4909679,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258018',4909680,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258018',4909681,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258018',4909682,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258018',4909683,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258018',4909684,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258019',4909685,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258019',4909686,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258019',4909687,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258019',4909688,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258019',4909689,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258019',4909690,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258019',4909691,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258019',4909692,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258020',4909693,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258020',4909694,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258020',4909695,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258020',4909696,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258020',4909697,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258020',4909698,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258020',4909699,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258020',4909700,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258021',4909701,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258021',4909702,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258021',4909703,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258021',4909704,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258021',4909705,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258021',4909706,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258021',4909707,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258021',4909708,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258022',4909709,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258022',4909710,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258022',4909711,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258022',4909712,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258022',4909713,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258022',4909714,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258022',4909715,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258022',4909716,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258023',4909717,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258023',4909718,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258023',4909719,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258023',4909720,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258023',4909721,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258023',4909722,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258023',4909723,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258023',4909724,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258024',4909725,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258024',4909726,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258024',4909727,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258024',4909728,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258024',4909729,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258024',4909730,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258024',4909731,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258024',4909732,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258025',4909733,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258025',4909734,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258025',4909735,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258025',4909736,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258025',4909737,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258025',4909738,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258025',4909739,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258025',4909740,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258026',4909741,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258026',4909742,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258026',4909743,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258026',4909744,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258026',4909745,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258026',4909746,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258026',4909747,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258026',4909748,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258027',4909749,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258027',4909750,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258027',4909751,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258027',4909752,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258027',4909753,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258027',4909754,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258027',4909755,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258027',4909756,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258028',4909757,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258028',4909758,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258028',4909759,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258028',4909760,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258028',4909761,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258028',4909762,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258028',4909763,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258028',4909764,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258029',4909765,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258029',4909766,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258029',4909767,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258029',4909768,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258029',4909769,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258029',4909770,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258029',4909771,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258029',4909772,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258030',4909773,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258030',4909774,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258030',4909775,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258030',4909776,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258030',4909777,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258030',4909778,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258030',4909779,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258030',4909780,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258031',4909781,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258031',4909782,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258031',4909783,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258031',4909784,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258031',4909785,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258031',4909786,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258031',4909787,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258031',4909788,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258032',4909789,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258032',4909790,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258032',4909791,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258032',4909792,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258032',4909793,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258032',4909794,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258032',4909795,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258032',4909796,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258033',4909797,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258033',4909798,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258033',4909799,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258033',4909800,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258033',4909801,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258033',4909802,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258033',4909803,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258033',4909804,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258034',4909805,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258034',4909806,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258034',4909807,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258034',4909808,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258034',4909809,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258034',4909810,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258034',4909811,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258034',4909812,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258035',4909813,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258035',4909814,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258035',4909815,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258035',4909816,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258035',4909817,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258035',4909818,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258035',4909819,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258035',4909820,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258036',4909821,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258036',4909822,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258036',4909823,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258036',4909824,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258036',4909825,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258036',4909826,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258036',4909827,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258036',4909828,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258037',4909829,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258037',4909830,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258037',4909831,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258037',4909832,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258037',4909833,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258037',4909834,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258037',4909835,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258037',4909836,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258038',4909837,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258038',4909838,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258038',4909839,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258038',4909840,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258038',4909841,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258038',4909842,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258038',4909843,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258038',4909844,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258039',4909845,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258039',4909846,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258039',4909847,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258039',4909848,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258039',4909849,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258039',4909850,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258039',4909851,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258039',4909852,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258040',4909853,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258040',4909854,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258040',4909855,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258040',4909856,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258040',4909857,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258040',4909858,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258040',4909859,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258040',4909860,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258041',4909861,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258041',4909862,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258041',4909863,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258041',4909864,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258041',4909865,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258041',4909866,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258041',4909867,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258041',4909868,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258042',4909869,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258042',4909870,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258042',4909871,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258042',4909872,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258042',4909873,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258042',4909874,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258042',4909875,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258042',4909876,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258043',4909877,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258043',4909878,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258043',4909879,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258043',4909880,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258043',4909881,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258043',4909882,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258043',4909883,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258043',4909884,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258044',4909885,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258044',4909886,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258044',4909887,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258044',4909888,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258044',4909889,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258044',4909890,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258044',4909891,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258044',4909892,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258045',4909893,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258045',4909894,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258045',4909895,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258045',4909896,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258045',4909897,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258045',4909898,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258045',4909899,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258045',4909900,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258046',4909901,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258046',4909902,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258046',4909903,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258046',4909904,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258046',4909905,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258046',4909906,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258046',4909907,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258046',4909908,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258047',4909909,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258047',4909910,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258047',4909911,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258047',4909912,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258047',4909913,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258047',4909914,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258047',4909915,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258047',4909916,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258048',4909917,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258048',4909918,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258048',4909919,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258048',4909920,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258048',4909921,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258048',4909922,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258048',4909923,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258048',4909924,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258049',4909925,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258049',4909926,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258049',4909927,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258049',4909928,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258049',4909929,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258049',4909930,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258049',4909931,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258049',4909932,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258050',4909933,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258050',4909934,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258050',4909935,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258050',4909936,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258050',4909937,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258050',4909938,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258050',4909939,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258050',4909940,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258051',4909941,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258051',4909942,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258051',4909943,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258051',4909944,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258051',4909945,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258051',4909946,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258051',4909947,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258051',4909948,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258052',4909949,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258052',4909950,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258052',4909951,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258052',4909952,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258052',4909953,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258052',4909954,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258052',4909955,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258052',4909956,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258053',4909957,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258053',4909958,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258053',4909959,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258053',4909960,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258053',4909961,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258053',4909962,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258053',4909963,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258053',4909964,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258054',4909965,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258054',4909966,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258054',4909967,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258054',4909968,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258054',4909969,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258054',4909970,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258054',4909971,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258054',4909972,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258055',4909973,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258055',4909974,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258055',4909975,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258055',4909976,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258055',4909977,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258055',4909978,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258055',4909979,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258055',4909980,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258056',4909981,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258056',4909982,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258056',4909983,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258056',4909984,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258056',4909985,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258056',4909986,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258056',4909987,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258056',4909988,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258057',4909989,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258057',4909990,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258057',4909991,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258057',4909992,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258057',4909993,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258057',4909994,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258057',4909995,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258057',4909996,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258058',4909997,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258058',4909998,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258058',4909999,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258058',4910000,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258058',4910001,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258058',4910002,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258058',4910003,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258058',4910004,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258059',4910005,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258059',4910006,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258059',4910007,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258059',4910008,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258059',4910009,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258059',4910010,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258059',4910011,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258059',4910012,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258060',4910013,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258060',4910014,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258060',4910015,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258060',4910016,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258060',4910017,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258060',4910018,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258060',4910019,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258060',4910020,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258061',4910021,'1640','222',3133070.45,3133070.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258061',4910022,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258061',4910023,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258061',4910024,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258061',4910025,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258061',4910026,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258061',4910027,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258061',4910028,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258062',4910029,'1640','222',3133070.45,3139306.89,6236.44,1309652.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','258062',4910030,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258062',4910031,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258062',4910032,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258062',4910033,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258062',4910034,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258062',4910035,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258062',4910036,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258063',4910037,'1640','222',3139306.89,3144751.94,5445.05,1143460.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','258063',4910038,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258063',4910039,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258063',4910040,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258063',4910041,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258063',4910042,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258063',4910043,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258063',4910044,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258064',4910045,'1640','222',3144751.94,3151622.26,6870.32,1442767.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','258064',4910046,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258064',4910047,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258064',4910048,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258064',4910049,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258064',4910050,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258064',4910051,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258064',4910052,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258065',4910053,'1640','222',3151622.26,3157360.24,5737.98,1204975.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','258065',4910054,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258065',4910055,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258065',4910056,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258065',4910057,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258065',4910058,'1645','222',3071257.42,3071257.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258065',4910059,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258065',4910060,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258066',4910061,'1640','222',3157360.24,3161979.69,4619.45,970084.50,0.00,0.00,0.00,0.00,0.00),('5','96','584','258066',4910062,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258066',4910063,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258066',4910064,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258066',4910065,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258066',4910066,'1645','222',3071257.42,3076465.58,5208.16,1093713.60,0.00,0.00,0.00,0.00,0.00),('5','96','587','258066',4910067,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258066',4910068,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258067',4910069,'1640','222',3161979.69,3166452.25,4472.56,939237.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','258067',4910070,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258067',4910071,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258067',4910072,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258067',4910073,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258067',4910074,'1645','222',3076465.58,3080658.58,4193.00,880530.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258067',4910075,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258067',4910076,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258068',4910077,'1640','222',3166452.25,3171333.23,4880.98,1025005.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','258068',4910078,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258068',4910079,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258068',4910080,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258068',4910081,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258068',4910082,'1645','222',3080658.58,3087048.00,6389.42,1341778.20,0.00,0.00,0.00,0.00,0.00),('5','96','587','258068',4910083,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258068',4910084,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258069',4910085,'1640','222',3171333.23,3175035.77,3702.54,777533.40,0.00,0.00,0.00,0.00,0.00),('5','96','584','258069',4910086,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258069',4910087,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258069',4910088,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258069',4910089,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258069',4910090,'1645','222',3087048.00,3092275.99,5227.99,1097877.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','258069',4910091,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258069',4910092,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258070',4910093,'1640','222',3175035.77,3177424.83,2389.06,501702.60,0.00,0.00,0.00,0.00,0.00),('5','96','584','258070',4910094,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258070',4910095,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258070',4910096,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258070',4910097,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258070',4910098,'1645','222',3092275.99,3097296.94,5020.95,1054399.50,0.00,0.00,0.00,0.00,0.00),('5','96','587','258070',4910099,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258070',4910100,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258071',4910101,'1640','222',3177424.83,3177424.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258071',4910102,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258071',4910103,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258071',4910104,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258071',4910105,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258071',4910106,'1645','222',3097296.94,3103597.08,6300.14,1323029.40,0.00,0.00,0.00,0.00,0.00),('5','96','587','258071',4910107,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258071',4910108,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258072',4910109,'1640','222',3177424.83,3183118.22,5693.39,1195611.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','258072',4910110,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258072',4910111,'1642','222',4144233.10,4144233.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258072',4910112,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258072',4910113,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258072',4910114,'1645','222',3103597.08,3109430.77,5833.69,1225074.90,0.00,0.00,0.00,0.00,0.00),('5','96','587','258072',4910115,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258072',4910116,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258073',4910117,'1640','222',3183118.22,3188900.61,5782.39,1214301.90,0.00,0.00,0.00,0.00,0.00),('5','96','584','258073',4910118,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258073',4910119,'1642','222',4144233.10,4148484.31,4251.21,892754.10,0.00,0.00,0.00,0.00,0.00),('5','96','585','258073',4910120,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258073',4910121,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258073',4910122,'1645','222',3109430.77,3110139.75,708.98,148885.80,0.00,0.00,0.00,0.00,0.00),('5','96','587','258073',4910123,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258073',4910124,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258074',4910125,'1640','222',3188900.61,3193757.93,4857.32,1020037.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','258074',4910126,'1641','222',1622911.65,1622911.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258074',4910127,'1642','222',4148484.31,4153380.71,4896.40,1028244.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258074',4910128,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258074',4910129,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258074',4910130,'1645','222',3110139.75,3110139.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258074',4910131,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258074',4910132,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258075',4910133,'1640','222',3193757.93,3198957.76,5199.83,1091964.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','258075',4910134,'1641','222',1622911.65,1623090.67,179.02,37594.20,0.00,0.00,0.00,0.00,0.00),('5','96','584','258075',4910135,'1642','222',4153380.71,4156272.63,2891.92,607303.20,0.00,0.00,0.00,0.00,0.00),('5','96','585','258075',4910136,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258075',4910137,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258075',4910138,'1645','222',3110139.75,3111692.58,1552.83,326094.30,0.00,0.00,0.00,0.00,0.00),('5','96','587','258075',4910139,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258075',4910140,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258076',4910141,'1640','222',3198957.76,3203751.93,4794.17,1006775.70,0.00,0.00,0.00,0.00,0.00),('5','96','584','258076',4910142,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258076',4910143,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258076',4910144,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258076',4910145,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258076',4910146,'1645','222',3111692.58,3115338.98,3646.40,765744.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258076',4910147,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258076',4910148,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258077',4910149,'1640','222',3203751.93,3208408.74,4656.81,977930.10,0.00,0.00,0.00,0.00,0.00),('5','96','584','258077',4910150,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258077',4910151,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258077',4910152,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258077',4910153,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258077',4910154,'1645','222',3115338.98,3115338.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258077',4910155,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258077',4910156,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258078',4910157,'1640','222',3208408.74,3213681.62,5272.88,1107304.80,0.00,0.00,0.00,0.00,0.00),('5','96','584','258078',4910158,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258078',4910159,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258078',4910160,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258078',4910161,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258078',4910162,'1645','222',3115338.98,3115338.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258078',4910163,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258078',4910164,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258079',4910165,'1640','222',3213681.62,3214831.05,1149.43,241380.30,0.00,0.00,0.00,0.00,0.00),('5','96','584','258079',4910166,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258079',4910167,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258079',4910168,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258079',4910169,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258079',4910170,'1645','222',3115338.98,3115338.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258079',4910171,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258079',4910172,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258080',4910173,'1640','222',3214831.05,3214831.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258080',4910174,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258080',4910175,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258080',4910176,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258080',4910177,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258080',4910178,'1645','222',3115338.98,3115338.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258080',4910179,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258080',4910180,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258081',4910181,'1640','222',3214831.05,3214831.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258081',4910182,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258081',4910183,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258081',4910184,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258081',4910185,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258081',4910186,'1645','222',3115338.98,3115338.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258081',4910187,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258081',4910188,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258082',4910189,'1640','222',3214831.05,3214831.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258082',4910190,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258082',4910191,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258082',4910192,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258082',4910193,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258082',4910194,'1645','222',3115338.98,3115338.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258082',4910195,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258082',4910196,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258083',4910197,'1640','222',3214831.05,3214831.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258083',4910198,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258083',4910199,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258083',4910200,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258083',4910201,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258083',4910202,'1645','222',3115338.98,3115338.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258083',4910203,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258083',4910204,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','583','258084',4910205,'1640','222',3214831.05,3214831.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258084',4910206,'1641','222',1623090.67,1623090.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','584','258084',4910207,'1642','222',4156272.63,4156272.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258084',4910208,'1643','222',1230919.39,1230919.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','585','258084',4910209,'1644','222',957490.44,957490.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','586','258084',4910210,'1645','222',3115338.98,3115338.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','587','258084',4910211,'1646','223',1404383.06,1404383.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','96','589','258084',4910212,'1648','224',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=731344 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','96','83353','222',140.00,140.00,10993.01,0.00,0.00,0.00,0.00,251125),('5','96','83353','223',240.00,240.00,437.95,0.00,0.00,0.00,0.00,251126),('5','96','83353','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251127),('5','96','83355','222',140.00,140.00,9913.06,0.00,0.00,0.00,0.00,251131),('5','96','83355','223',240.00,240.00,468.88,0.00,0.00,0.00,0.00,251132),('5','96','83355','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251133),('5','96','83358','222',140.00,140.00,11242.41,0.00,0.00,0.00,0.00,251140),('5','96','83358','223',240.00,240.00,581.16,0.00,0.00,0.00,0.00,251141),('5','96','83358','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251142),('5','96','83363','222',140.00,140.00,10867.47,0.00,0.00,0.00,0.00,251155),('5','96','83363','223',240.00,240.00,735.52,0.00,0.00,0.00,0.00,251156),('5','96','83363','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251157),('5','96','83366','222',140.00,140.00,10697.62,0.00,0.00,0.00,0.00,251164),('5','96','83366','223',240.00,240.00,1050.39,0.00,0.00,0.00,0.00,251165),('5','96','83366','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251166),('5','96','83374','222',140.00,140.00,12835.96,0.00,0.00,0.00,0.00,251188),('5','96','83374','223',240.00,240.00,409.86,0.00,0.00,0.00,0.00,251189),('5','96','83374','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251190),('5','96','83435','222',140.00,140.00,16400.64,0.00,0.00,0.00,0.00,251373),('5','96','83435','223',240.00,240.00,583.87,0.00,0.00,0.00,0.00,251374),('5','96','83435','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251375),('5','96','83566','222',140.00,140.00,2780.81,0.00,0.00,0.00,0.00,251767),('5','96','83566','223',240.00,240.00,118.35,0.00,0.00,0.00,0.00,251768),('5','96','83566','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251769),('5','96','83916','222',140.00,140.00,0.00,0.00,0.00,0.00,0.00,252820),('5','96','83916','223',240.00,240.00,0.00,0.00,0.00,0.00,0.00,252821),('5','96','83916','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,252822),('5','96','84227','222',140.00,140.00,0.00,0.00,0.00,0.00,0.00,253755),('5','96','84227','223',240.00,240.00,0.00,0.00,0.00,0.00,0.00,253756),('5','96','84227','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,253757),('5','96','84235','222',140.00,140.00,12126.44,0.00,0.00,0.00,0.00,253779),('5','96','84235','223',240.00,240.00,323.93,0.00,0.00,0.00,0.00,253780),('5','96','84235','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,253781),('5','96','84358','222',140.00,140.00,10535.99,0.00,0.00,0.00,0.00,254149),('5','96','84358','223',240.00,240.00,332.06,0.00,0.00,0.00,0.00,254150),('5','96','84358','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,254151),('5','96','84362','222',140.00,140.00,10612.57,0.00,0.00,0.00,0.00,254161),('5','96','84362','223',240.00,240.00,182.05,0.00,0.00,0.00,0.00,254162),('5','96','84362','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,254163),('5','96','84962','222',140.00,140.00,11061.63,0.00,0.00,0.00,0.00,255966),('5','96','84962','223',240.00,240.00,449.66,0.00,0.00,0.00,0.00,255967),('5','96','84962','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,255968),('5','96','84964','222',140.00,140.00,10721.34,0.00,0.00,0.00,0.00,255972),('5','96','84964','223',240.00,240.00,875.59,0.00,0.00,0.00,0.00,255973),('5','96','84964','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,255974),('5','96','102981','222',140.00,140.00,8962.37,0.00,0.00,0.00,0.00,310088),('5','96','102981','223',225.00,225.00,488.19,0.00,0.00,0.00,0.00,310089),('5','96','102981','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310090),('5','96','102984','222',140.00,140.00,6910.04,0.00,0.00,0.00,0.00,310097),('5','96','102984','223',225.00,225.00,317.89,0.00,0.00,0.00,0.00,310098),('5','96','102984','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310099),('5','96','102985','222',140.00,140.00,8953.25,0.00,0.00,0.00,0.00,310100),('5','96','102985','223',225.00,225.00,569.00,0.00,0.00,0.00,0.00,310101),('5','96','102985','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310102),('5','96','102991','222',140.00,140.00,5973.82,0.00,0.00,0.00,0.00,310118),('5','96','102991','223',225.00,225.00,312.52,0.00,0.00,0.00,0.00,310119),('5','96','102991','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310120),('5','96','102993','222',140.00,140.00,9135.51,0.00,0.00,0.00,0.00,310124),('5','96','102993','223',225.00,225.00,475.62,0.00,0.00,0.00,0.00,310125),('5','96','102993','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310126),('5','96','103064','222',140.00,140.00,12355.91,0.00,0.00,0.00,0.00,310337),('5','96','103064','223',225.00,225.00,123.98,0.00,0.00,0.00,0.00,310338),('5','96','103064','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310339),('5','96','103304','222',140.00,140.00,8441.11,0.00,0.00,0.00,0.00,311057),('5','96','103304','223',225.00,225.00,0.00,0.00,0.00,0.00,0.00,311058),('5','96','103304','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,311059),('5','96','103307','222',140.00,140.00,9945.67,0.00,0.00,0.00,0.00,311066),('5','96','103307','223',225.00,225.00,0.00,0.00,0.00,0.00,0.00,311067),('5','96','103307','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,311068),('5','96','103709','222',140.00,140.00,0.00,0.00,0.00,0.00,0.00,312272),('5','96','103709','223',225.00,225.00,0.00,0.00,0.00,0.00,0.00,312273),('5','96','103709','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,312274),('5','96','105595','222',140.00,140.00,9449.59,0.00,0.00,0.00,0.00,317930),('5','96','105595','223',225.00,225.00,0.00,0.00,0.00,0.00,0.00,317931),('5','96','105595','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317932),('5','96','105606','222',140.00,140.00,7395.02,0.00,0.00,0.00,0.00,317963),('5','96','105606','223',225.00,225.00,225.35,0.00,0.00,0.00,0.00,317964),('5','96','105606','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317965),('5','96','105854','222',140.00,140.00,10288.02,0.00,0.00,0.00,0.00,318707),('5','96','105854','223',225.00,225.00,392.32,0.00,0.00,0.00,0.00,318708),('5','96','105854','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318709),('5','96','105855','222',140.00,140.00,7653.67,0.00,0.00,0.00,0.00,318710),('5','96','105855','223',225.00,225.00,265.13,0.00,0.00,0.00,0.00,318711),('5','96','105855','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318712),('5','96','105857','222',140.00,140.00,31403.98,0.00,0.00,0.00,0.00,318716),('5','96','105857','223',225.00,225.00,380.72,0.00,0.00,0.00,0.00,318717),('5','96','105857','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318718),('5','96','106350','222',140.00,140.00,8741.78,0.00,0.00,0.00,0.00,320195),('5','96','106350','223',225.00,225.00,344.74,0.00,0.00,0.00,0.00,320196),('5','96','106350','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320197),('5','96','106450','222',140.00,140.00,8227.99,0.00,0.00,0.00,0.00,320495),('5','96','106450','223',225.00,225.00,452.04,0.00,0.00,0.00,0.00,320496),('5','96','106450','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320497),('5','96','106451','222',140.00,140.00,9450.30,0.00,0.00,0.00,0.00,320498),('5','96','106451','223',225.00,225.00,584.42,0.00,0.00,0.00,0.00,320499),('5','96','106451','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320500),('5','96','106453','222',140.00,140.00,8556.95,0.00,0.00,0.00,0.00,320504),('5','96','106453','223',225.00,225.00,419.50,0.00,0.00,0.00,0.00,320505),('5','96','106453','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320506),('5','96','106454','222',140.00,140.00,8815.73,0.00,0.00,0.00,0.00,320507),('5','96','106454','223',225.00,225.00,316.90,0.00,0.00,0.00,0.00,320508),('5','96','106454','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320509),('5','96','106458','222',140.00,140.00,9408.52,0.00,0.00,0.00,0.00,320519),('5','96','106458','223',225.00,225.00,593.26,0.00,0.00,0.00,0.00,320520),('5','96','106458','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320521),('5','96','106459','222',140.00,140.00,12559.97,0.00,0.00,0.00,0.00,320522),('5','96','106459','223',225.00,225.00,585.95,0.00,0.00,0.00,0.00,320523),('5','96','106459','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320524),('5','96','106460','222',140.00,140.00,8902.80,0.00,0.00,0.00,0.00,320525),('5','96','106460','223',225.00,225.00,405.53,0.00,0.00,0.00,0.00,320526),('5','96','106460','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320527),('5','96','106461','222',140.00,140.00,7625.66,0.00,0.00,0.00,0.00,320528),('5','96','106461','223',225.00,225.00,445.47,0.00,0.00,0.00,0.00,320529),('5','96','106461','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320530),('5','96','107437','222',140.00,140.00,6397.53,0.00,0.00,0.00,0.00,323475),('5','96','107437','223',225.00,225.00,420.87,0.00,0.00,0.00,0.00,323476),('5','96','107437','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323477),('5','96','107441','222',140.00,140.00,11633.58,0.00,0.00,0.00,0.00,323487),('5','96','107441','223',225.00,225.00,444.10,0.00,0.00,0.00,0.00,323488),('5','96','107441','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323489),('5','96','107442','222',140.00,140.00,9046.93,0.00,0.00,0.00,0.00,323490),('5','96','107442','223',225.00,225.00,485.08,0.00,0.00,0.00,0.00,323491),('5','96','107442','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323492),('5','96','107443','222',140.00,140.00,10100.13,0.00,0.00,0.00,0.00,323493),('5','96','107443','223',225.00,225.00,484.72,0.00,0.00,0.00,0.00,323494),('5','96','107443','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323495),('5','96','107444','222',140.00,140.00,11892.61,0.00,0.00,0.00,0.00,323496),('5','96','107444','223',225.00,225.00,741.55,0.00,0.00,0.00,0.00,323497),('5','96','107444','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323498),('5','96','107445','222',140.00,140.00,8852.82,0.00,0.00,0.00,0.00,323499),('5','96','107445','223',225.00,225.00,315.23,0.00,0.00,0.00,0.00,323500),('5','96','107445','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323501),('5','96','107446','222',140.00,140.00,8423.12,0.00,0.00,0.00,0.00,323502),('5','96','107446','223',225.00,225.00,468.45,0.00,0.00,0.00,0.00,323503),('5','96','107446','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323504),('5','96','107448','222',140.00,140.00,8514.61,0.00,0.00,0.00,0.00,323508),('5','96','107448','223',225.00,225.00,444.42,0.00,0.00,0.00,0.00,323509),('5','96','107448','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323510),('5','96','107450','222',140.00,140.00,9456.19,0.00,0.00,0.00,0.00,323514),('5','96','107450','223',225.00,225.00,499.68,0.00,0.00,0.00,0.00,323515),('5','96','107450','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323516),('5','96','107451','222',140.00,140.00,9171.30,0.00,0.00,0.00,0.00,323517),('5','96','107451','223',225.00,225.00,496.11,0.00,0.00,0.00,0.00,323518),('5','96','107451','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323519),('5','96','107452','222',140.00,140.00,9746.44,0.00,0.00,0.00,0.00,323520),('5','96','107452','223',225.00,225.00,848.62,0.00,0.00,0.00,0.00,323521),('5','96','107452','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323522),('5','96','107453','222',140.00,140.00,12764.48,0.00,0.00,0.00,0.00,323523),('5','96','107453','223',225.00,225.00,651.67,0.00,0.00,0.00,0.00,323524),('5','96','107453','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,323525),('5','96','107854','222',140.00,140.00,9581.89,0.00,0.00,0.00,0.00,324733),('5','96','107854','223',225.00,225.00,608.57,0.00,0.00,0.00,0.00,324734),('5','96','107854','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,324735),('5','96','108433','222',140.00,140.00,9875.37,0.00,0.00,0.00,0.00,326480),('5','96','108433','223',215.00,225.00,1358.64,0.00,0.00,0.00,0.00,326481),('5','96','108433','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326482),('5','96','108434','222',140.00,140.00,10672.60,0.00,0.00,0.00,0.00,326483),('5','96','108434','223',215.00,225.00,760.61,0.00,0.00,0.00,0.00,326484),('5','96','108434','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326485),('5','96','108473','222',140.00,140.00,7288.48,0.00,0.00,0.00,0.00,326600),('5','96','108473','223',215.00,225.00,916.66,0.00,0.00,0.00,0.00,326601),('5','96','108473','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326602),('5','96','108475','222',140.00,140.00,6967.09,0.00,0.00,0.00,0.00,326606),('5','96','108475','223',215.00,225.00,740.88,0.00,0.00,0.00,0.00,326607),('5','96','108475','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326608),('5','96','108478','222',140.00,140.00,8850.93,0.00,0.00,0.00,0.00,326615),('5','96','108478','223',215.00,225.00,856.71,0.00,0.00,0.00,0.00,326616),('5','96','108478','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326617),('5','96','108481','222',140.00,140.00,12447.61,0.00,0.00,0.00,0.00,326624),('5','96','108481','223',215.00,225.00,723.25,0.00,0.00,0.00,0.00,326625),('5','96','108481','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326626),('5','96','108483','222',140.00,140.00,13327.13,0.00,0.00,0.00,0.00,326630),('5','96','108483','223',215.00,225.00,535.35,0.00,0.00,0.00,0.00,326631),('5','96','108483','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326632),('5','96','108487','222',140.00,140.00,12017.34,0.00,0.00,0.00,0.00,326642),('5','96','108487','223',215.00,225.00,483.13,0.00,0.00,0.00,0.00,326643),('5','96','108487','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326644),('5','96','108489','222',140.00,140.00,9822.96,0.00,0.00,0.00,0.00,326648),('5','96','108489','223',215.00,225.00,872.04,0.00,0.00,0.00,0.00,326649),('5','96','108489','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326650),('5','96','108490','222',140.00,140.00,11156.40,0.00,0.00,0.00,0.00,326651),('5','96','108490','223',215.00,225.00,678.16,0.00,0.00,0.00,0.00,326652),('5','96','108490','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326653),('5','96','108491','222',140.00,140.00,8316.85,0.00,0.00,0.00,0.00,326654),('5','96','108491','223',215.00,225.00,0.00,0.00,0.00,0.00,0.00,326655),('5','96','108491','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326656),('5','96','108608','222',140.00,140.00,11295.59,0.00,0.00,0.00,0.00,327006),('5','96','108608','223',215.00,225.00,1542.82,0.00,0.00,0.00,0.00,327007),('5','96','108608','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,327008),('5','96','108611','222',140.00,140.00,15647.86,0.00,0.00,0.00,0.00,327015),('5','96','108611','223',215.00,225.00,688.50,0.00,0.00,0.00,0.00,327016),('5','96','108611','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,327017),('5','96','108723','222',140.00,140.00,13702.83,0.00,0.00,0.00,0.00,327354),('5','96','108723','223',215.00,225.00,1048.85,0.00,0.00,0.00,0.00,327355),('5','96','108723','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,327356),('5','96','108821','222',140.00,140.00,9937.11,0.00,0.00,0.00,0.00,327648),('5','96','108821','223',215.00,225.00,999.27,0.00,0.00,0.00,0.00,327649),('5','96','108821','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,327650),('5','96','109105','222',140.00,140.00,11990.13,0.00,0.00,0.00,0.00,328507),('5','96','109105','223',215.00,225.00,841.68,0.00,0.00,0.00,0.00,328508),('5','96','109105','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,328509),('5','96','109106','222',140.00,140.00,9712.80,0.00,0.00,0.00,0.00,328510),('5','96','109106','223',215.00,225.00,506.55,0.00,0.00,0.00,0.00,328511),('5','96','109106','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,328512),('5','96','109610','222',143.00,140.00,11410.88,0.00,0.00,0.00,0.00,330031),('5','96','109610','223',215.00,225.00,717.42,0.00,0.00,0.00,0.00,330032),('5','96','109610','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,330033),('5','96','109611','222',143.00,140.00,11244.64,0.00,0.00,0.00,0.00,330034),('5','96','109611','223',215.00,225.00,1597.21,0.00,0.00,0.00,0.00,330035),('5','96','109611','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,330036),('5','96','109612','222',143.00,140.00,15125.54,0.00,0.00,0.00,0.00,330037),('5','96','109612','223',215.00,225.00,1034.34,0.00,0.00,0.00,0.00,330038),('5','96','109612','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,330039),('5','96','109629','222',143.00,140.00,10466.63,0.00,0.00,0.00,0.00,330088),('5','96','109629','223',215.00,225.00,1178.68,0.00,0.00,0.00,0.00,330089),('5','96','109629','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,330090),('5','96','110134','222',143.00,140.00,10896.00,0.00,0.00,0.00,0.00,331611),('5','96','110134','223',215.00,225.00,1240.95,0.00,0.00,0.00,0.00,331612),('5','96','110134','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,331613),('5','96','110396','222',143.00,140.00,13477.23,0.00,0.00,0.00,0.00,332388),('5','96','110396','223',215.00,225.00,1673.05,0.00,0.00,0.00,0.00,332389),('5','96','110396','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,332390),('5','96','110398','222',143.00,140.00,14212.36,0.00,0.00,0.00,0.00,332394),('5','96','110398','223',215.00,225.00,1339.75,0.00,0.00,0.00,0.00,332395),('5','96','110398','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,332396),('5','96','110407','222',143.00,140.00,14124.47,0.00,0.00,0.00,0.00,332421),('5','96','110407','223',215.00,225.00,1255.57,0.00,0.00,0.00,0.00,332422),('5','96','110407','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,332423),('5','96','110408','222',143.00,140.00,0.00,0.00,0.00,0.00,0.00,332424),('5','96','110408','223',215.00,225.00,0.00,0.00,0.00,0.00,0.00,332425),('5','96','110408','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,332426),('5','96','181802','222',143.00,163.00,0.00,0.00,0.00,0.00,0.00,533220),('5','96','181802','223',215.00,250.00,0.00,0.00,0.00,0.00,0.00,533221),('5','96','181802','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,533222),('5','96','181810','222',143.00,163.00,6599.85,0.00,0.00,0.00,0.00,533240),('5','96','181810','223',215.00,250.00,614.09,0.00,0.00,0.00,0.00,533241),('5','96','181810','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,533242),('5','96','181816','222',143.00,163.00,0.00,0.00,0.00,0.00,0.00,533258),('5','96','181816','223',215.00,250.00,642.77,0.00,0.00,0.00,0.00,533259),('5','96','181816','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,533260),('5','96','182096','222',143.00,163.00,0.00,0.00,0.00,0.00,0.00,534024),('5','96','182096','223',250.00,250.00,0.00,0.00,0.00,0.00,0.00,534025),('5','96','182096','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,534026),('5','96','182296','222',143.00,163.00,2322.44,0.00,0.00,0.00,0.00,534535),('5','96','182296','223',250.00,250.00,0.00,0.00,0.00,0.00,0.00,534536),('5','96','182296','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,534537),('5','96','182775','222',163.00,143.00,12487.58,0.00,0.00,0.00,0.00,535809),('5','96','182775','223',250.00,220.00,0.00,0.00,0.00,0.00,0.00,535810),('5','96','182775','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,535811),('5','96','182834','222',163.00,163.00,10781.36,0.00,0.00,0.00,0.00,535970),('5','96','182834','223',250.00,250.00,3173.36,0.00,0.00,0.00,0.00,535971),('5','96','182834','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,535972),('5','96','183244','222',163.00,163.00,14034.16,0.00,0.00,0.00,0.00,537033),('5','96','183244','223',250.00,250.00,1099.79,0.00,0.00,0.00,0.00,537034),('5','96','183244','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,537035),('5','96','183280','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,537128),('5','96','183280','223',250.00,250.00,0.00,0.00,0.00,0.00,0.00,537129),('5','96','183280','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,537130),('5','96','183423','222',163.00,163.00,11862.35,0.00,0.00,0.00,0.00,537510),('5','96','183423','223',250.00,250.00,0.00,0.00,0.00,0.00,0.00,537511),('5','96','183423','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,537512),('5','96','183471','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,537623),('5','96','183471','223',250.00,250.00,0.00,0.00,0.00,0.00,0.00,537624),('5','96','183471','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,537625),('5','96','183750','222',163.00,163.00,9844.58,0.00,0.00,0.00,0.00,538373),('5','96','183750','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,538374),('5','96','183750','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,538375),('5','96','184020','222',163.00,163.00,7348.72,0.00,0.00,0.00,0.00,539094),('5','96','184020','223',250.00,250.00,0.00,0.00,0.00,0.00,0.00,539095),('5','96','184020','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,539096),('5','96','184115','222',163.00,163.00,14350.82,0.00,0.00,0.00,0.00,539342),('5','96','184115','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,539343),('5','96','184115','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,539344),('5','96','184251','222',163.00,163.00,12285.29,0.00,0.00,0.00,0.00,539715),('5','96','184251','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,539716),('5','96','184251','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,539717),('5','96','184484','222',163.00,163.00,27601.40,0.00,0.00,0.00,0.00,540300),('5','96','184484','223',250.00,255.00,0.00,0.00,0.00,0.00,0.00,540301),('5','96','184484','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,540302),('5','96','184639','222',163.00,163.00,12203.15,0.00,0.00,0.00,0.00,540740),('5','96','184639','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,540741),('5','96','184639','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,540742),('5','96','184841','222',163.00,163.00,10310.49,0.00,0.00,0.00,0.00,541282),('5','96','184841','223',250.00,255.00,0.00,0.00,0.00,0.00,0.00,541283),('5','96','184841','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,541284),('5','96','184909','222',163.00,163.00,11626.35,0.00,0.00,0.00,0.00,541445),('5','96','184909','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,541446),('5','96','184909','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,541447),('5','96','185117','222',163.00,163.00,12195.23,0.00,0.00,0.00,0.00,541980),('5','96','185117','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,541981),('5','96','185117','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,541982),('5','96','185273','222',163.00,163.00,14650.01,0.00,0.00,0.00,0.00,542362),('5','96','185273','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,542363),('5','96','185273','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,542364),('5','96','185496','222',163.00,163.00,13807.15,0.00,0.00,0.00,0.00,542956),('5','96','185496','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,542957),('5','96','185496','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,542958),('5','96','185683','222',163.00,163.00,13618.35,0.00,0.00,0.00,0.00,543459),('5','96','185683','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,543460),('5','96','185683','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,543461),('5','96','185877','222',163.00,163.00,14889.78,0.00,0.00,0.00,0.00,543978),('5','96','185877','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,543979),('5','96','185877','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,543980),('5','96','186081','222',163.00,163.00,13650.76,0.00,0.00,0.00,0.00,544521),('5','96','186081','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,544522),('5','96','186081','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,544523),('5','96','186313','222',163.00,163.00,10986.69,0.00,0.00,0.00,0.00,545126),('5','96','186313','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,545127),('5','96','186313','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,545128),('5','96','186550','222',163.00,163.00,11927.40,0.00,0.00,0.00,0.00,545744),('5','96','186550','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,545745),('5','96','186550','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,545746),('5','96','186743','222',163.00,163.00,15517.73,0.00,0.00,0.00,0.00,546258),('5','96','186743','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,546259),('5','96','186743','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,546260),('5','96','187020','222',163.00,163.00,13129.57,0.00,0.00,0.00,0.00,546942),('5','96','187020','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,546943),('5','96','187020','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,546944),('5','96','187328','222',163.00,163.00,11443.24,0.00,0.00,0.00,0.00,547776),('5','96','187328','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547777),('5','96','187328','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,547778),('5','96','187337','222',163.00,163.00,12654.64,0.00,0.00,0.00,0.00,547797),('5','96','187337','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547798),('5','96','187337','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,547799),('5','96','187559','222',163.00,163.00,11833.28,0.00,0.00,0.00,0.00,548388),('5','96','187559','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,548389),('5','96','187559','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,548390),('5','96','187783','222',163.00,163.00,13279.65,0.00,0.00,0.00,0.00,548982),('5','96','187783','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,548983),('5','96','187783','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,548984),('5','96','188017','222',163.00,163.00,12987.88,0.00,0.00,0.00,0.00,549584),('5','96','188017','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,549585),('5','96','188017','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,549586),('5','96','188224','222',163.00,163.00,14628.15,0.00,0.00,0.00,0.00,550117),('5','96','188224','223',250.00,264.00,0.00,0.00,0.00,0.00,0.00,550118),('5','96','188224','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,550119),('5','96','188404','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,550600),('5','96','188404','223',250.00,265.00,0.00,0.00,0.00,0.00,0.00,550601),('5','96','188404','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,550602),('5','96','188547','222',163.00,163.00,13667.58,0.00,0.00,0.00,0.00,550954),('5','96','188547','223',250.00,256.00,104.19,0.00,0.00,0.00,0.00,550955),('5','96','188547','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,550956),('5','96','188606','222',163.00,163.00,13616.75,0.00,0.00,0.00,0.00,551098),('5','96','188606','223',265.00,265.00,0.00,0.00,0.00,0.00,0.00,551099),('5','96','188606','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,551100),('5','96','188794','222',163.00,163.00,11756.95,0.00,0.00,0.00,0.00,551610),('5','96','188794','223',265.00,265.00,1148.74,0.00,0.00,0.00,0.00,551611),('5','96','188794','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,551612),('5','96','188994','222',163.00,163.00,11097.75,0.00,0.00,0.00,0.00,552132),('5','96','188994','223',265.00,265.00,429.17,0.00,0.00,0.00,0.00,552133),('5','96','188994','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,552134),('5','96','189211','222',163.00,163.00,9768.73,0.00,0.00,0.00,0.00,552687),('5','96','189211','223',265.00,265.00,708.25,0.00,0.00,0.00,0.00,552688),('5','96','189211','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,552689),('5','96','189402','222',163.00,163.00,6203.26,0.00,0.00,0.00,0.00,553206),('5','96','189402','223',265.00,265.00,599.96,0.00,0.00,0.00,0.00,553207),('5','96','189402','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,553208),('5','96','189610','222',163.00,163.00,3537.04,0.00,0.00,0.00,0.00,553739),('5','96','189610','223',265.00,265.00,884.41,0.00,0.00,0.00,0.00,553740),('5','96','189610','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,553741),('5','96','189806','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,554241),('5','96','189806','223',265.00,265.00,1172.71,0.00,0.00,0.00,0.00,554242),('5','96','189806','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,554243),('5','96','190050','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,554865),('5','96','190050','223',265.00,265.00,768.62,0.00,0.00,0.00,0.00,554866),('5','96','190050','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,554867),('5','96','190220','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555318),('5','96','190220','223',265.00,265.00,863.21,0.00,0.00,0.00,0.00,555319),('5','96','190220','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,555320),('5','96','190424','222',163.00,165.00,4715.72,0.00,0.00,0.00,0.00,555860),('5','96','190424','223',265.00,265.00,666.92,0.00,0.00,0.00,0.00,555861),('5','96','190424','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,555862),('5','96','190694','222',165.00,165.00,4667.13,0.00,0.00,0.00,0.00,556557),('5','96','190694','223',265.00,265.00,447.98,0.00,0.00,0.00,0.00,556558),('5','96','190694','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,556559),('5','96','190902','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,557110),('5','96','190902','223',265.00,265.00,0.00,0.00,0.00,0.00,0.00,557111),('5','96','190902','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,557112),('5','96','191023','222',165.00,165.00,4467.33,0.00,0.00,0.00,0.00,557436),('5','96','191023','223',265.00,265.00,500.63,0.00,0.00,0.00,0.00,557437),('5','96','191023','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,557438),('5','96','191070','222',165.00,165.00,1542.14,0.00,0.00,0.00,0.00,557558),('5','96','191070','223',265.00,265.00,356.17,0.00,0.00,0.00,0.00,557559),('5','96','191070','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,557560),('5','96','191309','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,558174),('5','96','191309','223',265.00,265.00,370.66,0.00,0.00,0.00,0.00,558175),('5','96','191309','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,558176),('5','96','191502','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,558689),('5','96','191502','223',265.00,265.00,380.05,0.00,0.00,0.00,0.00,558690),('5','96','191502','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,558691),('5','96','191730','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,559287),('5','96','191730','223',265.00,265.00,400.63,0.00,0.00,0.00,0.00,559288),('5','96','191730','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,559289),('5','96','192116','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,560342),('5','96','192116','223',265.00,265.00,275.79,0.00,0.00,0.00,0.00,560343),('5','96','192116','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,560344),('5','96','192179','222',165.00,165.00,4562.98,0.00,0.00,0.00,0.00,560493),('5','96','192179','223',265.00,265.00,539.57,0.00,0.00,0.00,0.00,560494),('5','96','192179','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,560495),('5','96','192421','222',165.00,165.00,5678.26,0.00,0.00,0.00,0.00,561120),('5','96','192421','223',265.00,265.00,391.83,0.00,0.00,0.00,0.00,561121),('5','96','192421','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,561122),('5','96','192581','222',165.00,165.00,7018.74,0.00,0.00,0.00,0.00,561534),('5','96','192581','223',265.00,265.00,297.48,0.00,0.00,0.00,0.00,561535),('5','96','192581','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,561536),('5','96','192938','222',165.00,165.00,5434.37,0.00,0.00,0.00,0.00,562491),('5','96','192938','223',265.00,265.00,823.47,0.00,0.00,0.00,0.00,562492),('5','96','192938','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,562493),('5','96','192982','222',165.00,165.00,3533.16,0.00,0.00,0.00,0.00,562586),('5','96','192982','223',265.00,265.00,253.95,0.00,0.00,0.00,0.00,562587),('5','96','192982','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,562588),('5','96','193260','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,563333),('5','96','193260','223',265.00,265.00,768.34,0.00,0.00,0.00,0.00,563334),('5','96','193260','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,563335),('5','96','193467','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,563866),('5','96','193467','223',265.00,265.00,323.27,0.00,0.00,0.00,0.00,563867),('5','96','193467','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,563868),('5','96','193630','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,564293),('5','96','193630','223',265.00,265.00,509.20,0.00,0.00,0.00,0.00,564294),('5','96','193630','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,564295),('5','96','193942','222',165.00,165.00,7045.65,0.00,0.00,0.00,0.00,565068),('5','96','193942','223',265.00,265.00,311.64,0.00,0.00,0.00,0.00,565069),('5','96','193942','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,565070),('5','96','194071','222',165.00,165.00,9906.70,0.00,0.00,0.00,0.00,565402),('5','96','194071','223',265.00,265.00,265.61,0.00,0.00,0.00,0.00,565403),('5','96','194071','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,565404),('5','96','194374','222',165.00,165.00,9094.92,0.00,0.00,0.00,0.00,566175),('5','96','194374','223',265.00,265.00,0.00,0.00,0.00,0.00,0.00,566176),('5','96','194374','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,566177),('5','96','194488','222',165.00,165.00,9689.30,0.00,0.00,0.00,0.00,566464),('5','96','194488','223',265.00,265.00,649.33,0.00,0.00,0.00,0.00,566465),('5','96','194488','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,566466),('5','96','194722','222',165.00,165.00,6452.23,0.00,0.00,0.00,0.00,567055),('5','96','194722','223',265.00,265.00,532.03,0.00,0.00,0.00,0.00,567056),('5','96','194722','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,567057),('5','96','194877','222',165.00,165.00,6707.21,0.00,0.00,0.00,0.00,567482),('5','96','194877','223',265.00,265.00,305.44,0.00,0.00,0.00,0.00,567483),('5','96','194877','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,567484),('5','96','195068','222',165.00,165.00,10223.56,0.00,0.00,0.00,0.00,567985),('5','96','195068','223',265.00,265.00,373.73,0.00,0.00,0.00,0.00,567986),('5','96','195068','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,567987),('5','96','195302','222',165.00,165.00,8822.30,0.00,0.00,0.00,0.00,568583),('5','96','195302','223',265.00,265.00,503.03,0.00,0.00,0.00,0.00,568584),('5','96','195302','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,568585),('5','96','195514','222',165.00,165.00,5051.29,0.00,0.00,0.00,0.00,569129),('5','96','195514','223',265.00,265.00,402.34,0.00,0.00,0.00,0.00,569130),('5','96','195514','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,569131),('5','96','195797','222',165.00,165.00,2161.41,0.00,0.00,0.00,0.00,569818),('5','96','195797','223',265.00,265.00,448.48,0.00,0.00,0.00,0.00,569819),('5','96','195797','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,569820),('5','96','196019','222',165.00,165.00,18.61,0.00,0.00,0.00,0.00,570390),('5','96','196019','223',265.00,265.00,359.22,0.00,0.00,0.00,0.00,570391),('5','96','196019','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,570392),('5','96','196234','222',165.00,165.00,6133.20,0.00,0.00,0.00,0.00,570930),('5','96','196234','223',265.00,265.00,441.59,0.00,0.00,0.00,0.00,570931),('5','96','196234','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,570932),('5','96','196476','222',165.00,165.00,10582.87,0.00,0.00,0.00,0.00,571551),('5','96','196476','223',265.00,265.00,452.62,0.00,0.00,0.00,0.00,571552),('5','96','196476','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,571553),('5','96','196649','222',165.00,165.00,10081.07,0.00,0.00,0.00,0.00,572012),('5','96','196649','223',265.00,265.00,635.11,0.00,0.00,0.00,0.00,572013),('5','96','196649','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,572014),('5','96','196857','222',165.00,165.00,10732.36,0.00,0.00,0.00,0.00,572553),('5','96','196857','223',265.00,265.00,346.25,0.00,0.00,0.00,0.00,572554),('5','96','196857','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,572555),('5','96','197016','222',165.00,165.00,4784.28,0.00,0.00,0.00,0.00,572968),('5','96','197016','223',265.00,265.00,440.80,0.00,0.00,0.00,0.00,572969),('5','96','197016','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,572970),('5','96','197598','222',165.00,165.00,16144.38,0.00,0.00,0.00,0.00,574377),('5','96','197598','223',265.00,265.00,504.47,0.00,0.00,0.00,0.00,574378),('5','96','197598','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,574379),('5','96','198042','222',165.00,165.00,17144.63,0.00,0.00,0.00,0.00,575564),('5','96','198042','223',265.00,265.00,459.05,0.00,0.00,0.00,0.00,575565),('5','96','198042','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,575566),('5','96','198109','222',165.00,143.00,12075.69,0.00,0.00,0.00,0.00,575732),('5','96','198109','223',265.00,220.00,572.97,0.00,0.00,0.00,0.00,575733),('5','96','198109','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,575734),('5','96','198145','222',165.00,1165.00,0.00,0.00,0.00,0.00,0.00,575812),('5','96','198145','223',265.00,270.00,0.00,0.00,0.00,0.00,0.00,575813),('5','96','198145','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,575814),('5','96','198234','222',165.00,165.00,13505.28,0.00,0.00,0.00,0.00,576041),('5','96','198234','223',265.00,270.00,701.43,0.00,0.00,0.00,0.00,576042),('5','96','198234','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,576043),('5','96','198247','222',165.00,165.00,13410.70,0.00,0.00,0.00,0.00,576077),('5','96','198247','223',265.00,270.00,605.52,0.00,0.00,0.00,0.00,576078),('5','96','198247','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,576079),('5','96','198340','222',165.00,165.00,13801.72,0.00,0.00,0.00,0.00,576334),('5','96','198340','223',265.00,270.00,535.56,0.00,0.00,0.00,0.00,576335),('5','96','198340','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,576336),('5','96','198557','222',165.00,165.00,12878.70,0.00,0.00,0.00,0.00,576905),('5','96','198557','223',270.00,270.00,705.31,0.00,0.00,0.00,0.00,576906),('5','96','198557','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,576907),('5','96','198775','222',165.00,165.00,14205.11,0.00,0.00,0.00,0.00,577432),('5','96','198775','223',270.00,270.00,343.83,0.00,0.00,0.00,0.00,577433),('5','96','198775','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,577434),('5','96','198988','222',165.00,165.00,12592.15,0.00,0.00,0.00,0.00,577985),('5','96','198988','223',270.00,270.00,0.00,0.00,0.00,0.00,0.00,577986),('5','96','198988','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,577987),('5','96','199192','222',165.00,165.00,14110.77,0.00,0.00,0.00,0.00,578496),('5','96','199192','223',270.00,270.00,0.00,0.00,0.00,0.00,0.00,578497),('5','96','199192','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,578498),('5','96','199456','222',165.00,165.00,14349.06,0.00,0.00,0.00,0.00,579137),('5','96','199456','223',270.00,270.00,700.55,0.00,0.00,0.00,0.00,579138),('5','96','199456','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,579139),('5','96','199633','222',165.00,165.00,14363.49,0.00,0.00,0.00,0.00,579609),('5','96','199633','223',270.00,270.00,433.75,0.00,0.00,0.00,0.00,579610),('5','96','199633','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,579611),('5','96','199873','222',165.00,165.00,13681.85,0.00,0.00,0.00,0.00,580168),('5','96','199873','223',270.00,270.00,403.24,0.00,0.00,0.00,0.00,580169),('5','96','199873','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,580170),('5','96','200093','222',165.00,165.00,13505.70,0.00,0.00,0.00,0.00,580754),('5','96','200093','223',270.00,270.00,433.42,0.00,0.00,0.00,0.00,580755),('5','96','200093','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,580756),('5','96','200302','222',165.00,165.00,13139.93,0.00,0.00,0.00,0.00,581290),('5','96','200302','223',270.00,270.00,679.51,0.00,0.00,0.00,0.00,581291),('5','96','200302','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,581292),('5','96','200495','222',165.00,165.00,14632.81,0.00,0.00,0.00,0.00,581793),('5','96','200495','223',270.00,270.00,762.20,0.00,0.00,0.00,0.00,581794),('5','96','200495','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,581795),('5','96','200693','222',165.00,165.00,14215.59,0.00,0.00,0.00,0.00,582317),('5','96','200693','223',270.00,270.00,425.65,0.00,0.00,0.00,0.00,582318),('5','96','200693','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,582319),('5','96','200928','222',165.00,165.00,11903.46,0.00,0.00,0.00,0.00,582910),('5','96','200928','223',270.00,270.00,1699.37,0.00,0.00,0.00,0.00,582911),('5','96','200928','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,582912),('5','96','201102','222',165.00,165.00,10188.28,0.00,0.00,0.00,0.00,583359),('5','96','201102','223',270.00,270.00,476.24,0.00,0.00,0.00,0.00,583360),('5','96','201102','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,583361),('5','96','201317','222',165.00,165.00,9537.92,0.00,0.00,0.00,0.00,583908),('5','96','201317','223',270.00,270.00,517.63,0.00,0.00,0.00,0.00,583909),('5','96','201317','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,583910),('5','96','201494','222',165.00,165.00,15135.93,0.00,0.00,0.00,0.00,584373),('5','96','201494','223',270.00,270.00,553.00,0.00,0.00,0.00,0.00,584374),('5','96','201494','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,584375),('5','96','201761','222',165.00,165.00,14528.34,0.00,0.00,0.00,0.00,585081),('5','96','201761','223',270.00,275.00,1079.46,0.00,0.00,0.00,0.00,585082),('5','96','201761','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,585083),('5','96','202039','222',165.00,165.00,13020.87,0.00,0.00,0.00,0.00,585809),('5','96','202039','223',270.00,275.00,856.58,0.00,0.00,0.00,0.00,585810),('5','96','202039','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,585811),('5','96','202203','222',165.00,165.00,13245.78,0.00,0.00,0.00,0.00,586232),('5','96','202203','223',270.00,275.00,1237.59,0.00,0.00,0.00,0.00,586233),('5','96','202203','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,586234),('5','96','202424','222',165.00,165.00,10936.83,0.00,0.00,0.00,0.00,586798),('5','96','202424','223',275.00,275.00,567.92,0.00,0.00,0.00,0.00,586799),('5','96','202424','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,586800),('5','96','202629','222',165.00,165.00,11849.48,0.00,0.00,0.00,0.00,587327),('5','96','202629','223',275.00,275.00,521.86,0.00,0.00,0.00,0.00,587328),('5','96','202629','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,587329),('5','96','202853','222',165.00,165.00,13320.42,0.00,0.00,0.00,0.00,587899),('5','96','202853','223',275.00,275.00,878.22,0.00,0.00,0.00,0.00,587900),('5','96','202853','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,587901),('5','96','203116','222',165.00,165.00,14689.60,0.00,0.00,0.00,0.00,588580),('5','96','203116','223',275.00,275.00,792.35,0.00,0.00,0.00,0.00,588581),('5','96','203116','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,588582),('5','96','203327','222',165.00,165.00,9559.23,0.00,0.00,0.00,0.00,589133),('5','96','203327','223',275.00,275.00,771.87,0.00,0.00,0.00,0.00,589134),('5','96','203327','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,589135),('5','96','203523','222',165.00,165.00,11190.91,0.00,0.00,0.00,0.00,589629),('5','96','203523','223',275.00,275.00,629.94,0.00,0.00,0.00,0.00,589630),('5','96','203523','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,589631),('5','96','203818','222',165.00,165.00,12366.19,0.00,0.00,0.00,0.00,590393),('5','96','203818','223',275.00,275.00,975.23,0.00,0.00,0.00,0.00,590394),('5','96','203818','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,590395),('5','96','203982','222',165.00,165.00,11564.39,0.00,0.00,0.00,0.00,590805),('5','96','203982','223',275.00,275.00,335.88,0.00,0.00,0.00,0.00,590806),('5','96','203982','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,590807),('5','96','204197','222',165.00,165.00,10118.99,0.00,0.00,0.00,0.00,591379),('5','96','204197','223',275.00,275.00,128.09,0.00,0.00,0.00,0.00,591380),('5','96','204197','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,591381),('5','96','204420','222',165.00,165.00,11739.60,0.00,0.00,0.00,0.00,591948),('5','96','204420','223',275.00,275.00,213.81,0.00,0.00,0.00,0.00,591949),('5','96','204420','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,591950),('5','96','204610','222',165.00,165.00,15062.04,0.00,0.00,0.00,0.00,592450),('5','96','204610','223',275.00,275.00,44.09,0.00,0.00,0.00,0.00,592451),('5','96','204610','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,592452),('5','96','204841','222',165.00,165.00,10602.88,0.00,0.00,0.00,0.00,592995),('5','96','204841','223',275.00,275.00,25.37,0.00,0.00,0.00,0.00,592996),('5','96','204841','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,592997),('5','96','205038','222',165.00,165.00,9397.73,0.00,0.00,0.00,0.00,593508),('5','96','205038','223',275.00,275.00,31.71,0.00,0.00,0.00,0.00,593509),('5','96','205038','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,593510),('5','96','205223','222',165.00,165.00,11704.44,0.00,0.00,0.00,0.00,593993),('5','96','205223','223',275.00,280.00,0.00,0.00,0.00,0.00,0.00,593994),('5','96','205223','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,593995),('5','96','205498','222',143.00,165.00,8566.70,0.00,0.00,0.00,0.00,594682),('5','96','205498','223',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594683),('5','96','205498','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,594684),('5','96','205720','222',143.00,165.00,12354.39,0.00,0.00,0.00,0.00,595277),('5','96','205720','223',275.00,280.00,0.00,0.00,0.00,0.00,0.00,595278),('5','96','205720','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,595279),('5','96','205982','222',143.00,165.00,11572.30,0.00,0.00,0.00,0.00,595940),('5','96','205982','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,595941),('5','96','205982','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,595942),('5','96','206136','222',143.00,165.00,13077.90,0.00,0.00,0.00,0.00,596344),('5','96','206136','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596345),('5','96','206136','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,596346),('5','96','206374','222',143.00,165.00,10665.79,0.00,0.00,0.00,0.00,596940),('5','96','206374','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596941),('5','96','206374','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,596942),('5','96','206575','222',165.00,165.00,11473.54,0.00,0.00,0.00,0.00,597453),('5','96','206575','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,597454),('5','96','206575','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,597455),('5','96','206788','222',165.00,165.00,10866.21,0.00,0.00,0.00,0.00,598013),('5','96','206788','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598014),('5','96','206788','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,598015),('5','96','207018','222',165.00,165.00,12298.11,0.00,0.00,0.00,0.00,598610),('5','96','207018','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598611),('5','96','207018','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,598612),('5','96','207241','222',165.00,165.00,10256.58,0.00,0.00,0.00,0.00,599189),('5','96','207241','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,599190),('5','96','207241','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,599191),('5','96','207488','222',165.00,165.00,9540.53,0.00,0.00,0.00,0.00,599817),('5','96','207488','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,599818),('5','96','207488','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,599819),('5','96','207699','222',165.00,165.00,12555.25,0.00,0.00,0.00,0.00,600353),('5','96','207699','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600354),('5','96','207699','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,600355),('5','96','207918','222',165.00,165.00,11169.28,0.00,0.00,0.00,0.00,600903),('5','96','207918','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600904),('5','96','207918','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,600905),('5','96','208119','222',165.00,165.00,10319.55,0.00,0.00,0.00,0.00,601422),('5','96','208119','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,601423),('5','96','208119','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,601424),('5','96','208320','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,601941),('5','96','208320','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,601942),('5','96','208320','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,601943),('5','96','208445','222',165.00,165.00,7128.45,0.00,0.00,0.00,0.00,602263),('5','96','208445','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,602264),('5','96','208445','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,602265),('5','96','208560','222',165.00,165.00,8844.31,0.00,0.00,0.00,0.00,602555),('5','96','208560','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,602556),('5','96','208560','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,602557),('5','96','208754','222',165.00,165.00,12052.97,0.00,0.00,0.00,0.00,603065),('5','96','208754','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,603066),('5','96','208754','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,603067),('5','96','208979','222',165.00,165.00,11522.34,0.00,0.00,0.00,0.00,603633),('5','96','208979','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,603634),('5','96','208979','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,603635),('5','96','209227','222',165.00,165.00,13365.36,0.00,0.00,0.00,0.00,604255),('5','96','209227','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,604256),('5','96','209227','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,604257),('5','96','209445','222',165.00,165.00,11615.48,0.00,0.00,0.00,0.00,604804),('5','96','209445','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,604805),('5','96','209445','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,604806),('5','96','209650','222',165.00,165.00,8458.11,0.00,0.00,0.00,0.00,605333),('5','96','209650','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,605334),('5','96','209650','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,605335),('5','96','209876','222',165.00,165.00,2069.46,0.00,0.00,0.00,0.00,605917),('5','96','209876','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,605918),('5','96','209876','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,605919),('5','96','210110','222',165.00,165.00,10539.77,0.00,0.00,0.00,0.00,606532),('5','96','210110','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,606533),('5','96','210110','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,606534),('5','96','210317','222',165.00,165.00,11756.75,0.00,0.00,0.00,0.00,607064),('5','96','210317','223',275.00,290.00,0.00,0.00,0.00,0.00,0.00,607065),('5','96','210317','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,607066),('5','96','210612','222',165.00,165.00,10032.55,0.00,0.00,0.00,0.00,607841),('5','96','210612','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,607842),('5','96','210612','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,607843),('5','96','210741','222',165.00,165.00,12190.67,0.00,0.00,0.00,0.00,608183),('5','96','210741','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,608184),('5','96','210741','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,608185),('5','96','210948','222',165.00,165.00,11377.27,0.00,0.00,0.00,0.00,608715),('5','96','210948','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,608716),('5','96','210948','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,608717),('5','96','211287','222',165.00,165.00,11779.31,0.00,0.00,0.00,0.00,609587),('5','96','211287','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,609588),('5','96','211287','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,609589),('5','96','211401','222',165.00,165.00,13216.19,0.00,0.00,0.00,0.00,609883),('5','96','211401','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,609884),('5','96','211401','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,609885),('5','96','211599','222',165.00,165.00,12306.33,0.00,0.00,0.00,0.00,610408),('5','96','211599','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,610409),('5','96','211599','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,610410),('5','96','211784','222',165.00,165.00,10812.13,0.00,0.00,0.00,0.00,610862),('5','96','211784','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,610863),('5','96','211784','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,610864),('5','96','211993','222',165.00,165.00,10210.89,0.00,0.00,0.00,0.00,611408),('5','96','211993','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,611409),('5','96','211993','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,611410),('5','96','212229','222',165.00,165.00,12069.24,0.00,0.00,0.00,0.00,612029),('5','96','212229','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,612030),('5','96','212229','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,612031),('5','96','212456','222',165.00,165.00,10410.78,0.00,0.00,0.00,0.00,612628),('5','96','212456','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,612629),('5','96','212456','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,612630),('5','96','212655','222',165.00,165.00,12466.26,0.00,0.00,0.00,0.00,613169),('5','96','212655','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,613170),('5','96','212655','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,613171),('5','96','212876','222',165.00,165.00,5815.58,0.00,0.00,0.00,0.00,613731),('5','96','212876','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,613732),('5','96','212876','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,613733),('5','96','213155','222',165.00,165.00,10097.21,0.00,0.00,0.00,0.00,614455),('5','96','213155','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,614456),('5','96','213155','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,614457),('5','96','213388','222',165.00,165.00,10610.33,0.00,0.00,0.00,0.00,615062),('5','96','213388','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,615063),('5','96','213388','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,615064),('5','96','213692','222',165.00,165.00,11367.65,0.00,0.00,0.00,0.00,615866),('5','96','213692','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,615867),('5','96','213692','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,615868),('5','96','213869','222',165.00,165.00,11601.29,0.00,0.00,0.00,0.00,616339),('5','96','213869','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,616340),('5','96','213869','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,616341),('5','96','214134','222',165.00,165.00,10487.74,0.00,0.00,0.00,0.00,617010),('5','96','214134','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,617011),('5','96','214134','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,617012),('5','96','214335','222',165.00,165.00,11241.60,0.00,0.00,0.00,0.00,617539),('5','96','214335','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,617540),('5','96','214335','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,617541),('5','96','214520','222',165.00,165.00,10912.56,0.00,0.00,0.00,0.00,618021),('5','96','214520','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,618022),('5','96','214520','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,618023),('5','96','214789','222',165.00,165.00,10420.17,0.00,0.00,0.00,0.00,618714),('5','96','214789','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,618715),('5','96','214789','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,618716),('5','96','215011','222',165.00,165.00,10230.21,0.00,0.00,0.00,0.00,619297),('5','96','215011','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,619298),('5','96','215011','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,619299),('5','96','215237','222',165.00,165.00,10326.73,0.00,0.00,0.00,0.00,619867),('5','96','215237','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,619868),('5','96','215237','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,619869),('5','96','215454','222',165.00,165.00,12645.31,0.00,0.00,0.00,0.00,620422),('5','96','215454','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,620423),('5','96','215454','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,620424),('5','96','215678','222',165.00,165.00,9405.89,0.00,0.00,0.00,0.00,621014),('5','96','215678','223',275.00,295.00,0.00,0.00,0.00,0.00,0.00,621015),('5','96','215678','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,621016),('5','96','215919','222',165.00,165.00,8123.94,0.00,0.00,0.00,0.00,621623),('5','96','215919','223',275.00,295.00,86.64,0.00,0.00,0.00,0.00,621624),('5','96','215919','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,621625),('5','96','216137','222',165.00,165.00,12421.44,0.00,0.00,0.00,0.00,622186),('5','96','216137','223',295.00,295.00,99.69,0.00,0.00,0.00,0.00,622187),('5','96','216137','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,622188),('5','96','216400','222',165.00,165.00,11226.86,0.00,0.00,0.00,0.00,622884),('5','96','216400','223',295.00,295.00,124.78,0.00,0.00,0.00,0.00,622885),('5','96','216400','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,622886),('5','96','216551','222',165.00,165.00,9306.35,0.00,0.00,0.00,0.00,623288),('5','96','216551','223',295.00,295.00,220.43,0.00,0.00,0.00,0.00,623289),('5','96','216551','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,623290),('5','96','216787','222',165.00,165.00,10166.94,0.00,0.00,0.00,0.00,623910),('5','96','216787','223',295.00,295.00,239.24,0.00,0.00,0.00,0.00,623911),('5','96','216787','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,623912),('5','96','217015','222',165.00,165.00,11945.19,0.00,0.00,0.00,0.00,624504),('5','96','217015','223',295.00,295.00,198.71,0.00,0.00,0.00,0.00,624505),('5','96','217015','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,624506),('5','96','217290','222',165.00,165.00,9554.13,0.00,0.00,0.00,0.00,625217),('5','96','217290','223',295.00,295.00,262.14,0.00,0.00,0.00,0.00,625218),('5','96','217290','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,625219),('5','96','217661','222',165.00,165.00,8456.12,0.00,0.00,0.00,0.00,626203),('5','96','217661','223',295.00,295.00,172.01,0.00,0.00,0.00,0.00,626204),('5','96','217661','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,626205),('5','96','217965','222',165.00,165.00,9145.52,0.00,0.00,0.00,0.00,627005),('5','96','217965','223',295.00,295.00,324.95,0.00,0.00,0.00,0.00,627006),('5','96','217965','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,627007),('5','96','217981','222',165.00,165.00,8589.50,0.00,0.00,0.00,0.00,627036),('5','96','217981','223',295.00,295.00,122.63,0.00,0.00,0.00,0.00,627037),('5','96','217981','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,627038),('5','96','218245','222',165.00,165.00,7569.19,0.00,0.00,0.00,0.00,627718),('5','96','218245','223',295.00,295.00,212.44,0.00,0.00,0.00,0.00,627719),('5','96','218245','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,627720),('5','96','218450','222',165.00,165.00,5993.03,0.00,0.00,0.00,0.00,628269),('5','96','218450','223',295.00,295.00,419.21,0.00,0.00,0.00,0.00,628270),('5','96','218450','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,628271),('5','96','218885','222',165.00,165.00,5062.92,0.00,0.00,0.00,0.00,629412),('5','96','218885','223',295.00,295.00,244.90,0.00,0.00,0.00,0.00,629413),('5','96','218885','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,629414),('5','96','218926','222',165.00,165.00,1328.06,0.00,0.00,0.00,0.00,629501),('5','96','218926','223',295.00,295.00,205.01,0.00,0.00,0.00,0.00,629502),('5','96','218926','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,629503),('5','96','219150','222',165.00,165.00,3564.97,0.00,0.00,0.00,0.00,630082),('5','96','219150','223',295.00,295.00,254.77,0.00,0.00,0.00,0.00,630083),('5','96','219150','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,630084),('5','96','219344','222',165.00,165.00,7634.05,0.00,0.00,0.00,0.00,630591),('5','96','219344','223',295.00,295.00,471.06,0.00,0.00,0.00,0.00,630592),('5','96','219344','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,630593),('5','96','219592','222',165.00,165.00,9127.64,0.00,0.00,0.00,0.00,631250),('5','96','219592','223',295.00,295.00,249.83,0.00,0.00,0.00,0.00,631251),('5','96','219592','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,631252),('5','96','219827','222',165.00,165.00,8495.24,0.00,0.00,0.00,0.00,631857),('5','96','219827','223',295.00,295.00,275.91,0.00,0.00,0.00,0.00,631858),('5','96','219827','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,631859),('5','96','220027','222',165.00,165.00,10105.08,0.00,0.00,0.00,0.00,632415),('5','96','220027','223',295.00,295.00,377.06,0.00,0.00,0.00,0.00,632416),('5','96','220027','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,632417),('5','96','220259','222',165.00,165.00,12237.33,0.00,0.00,0.00,0.00,633014),('5','96','220259','223',295.00,295.00,334.09,0.00,0.00,0.00,0.00,633015),('5','96','220259','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,633016),('5','96','220475','222',165.00,165.00,8144.39,0.00,0.00,0.00,0.00,633574),('5','96','220475','223',295.00,295.00,343.51,0.00,0.00,0.00,0.00,633575),('5','96','220475','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,633576),('5','96','220685','222',165.00,165.00,9131.14,0.00,0.00,0.00,0.00,634125),('5','96','220685','223',295.00,295.00,337.33,0.00,0.00,0.00,0.00,634126),('5','96','220685','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,634127),('5','96','220918','222',165.00,165.00,10126.65,0.00,0.00,0.00,0.00,634728),('5','96','220918','223',295.00,295.00,355.45,0.00,0.00,0.00,0.00,634729),('5','96','220918','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,634730),('5','96','221137','222',165.00,165.00,10113.49,0.00,0.00,0.00,0.00,635301),('5','96','221137','223',295.00,295.00,294.17,0.00,0.00,0.00,0.00,635302),('5','96','221137','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,635303),('5','96','221409','222',165.00,165.00,9432.77,0.00,0.00,0.00,0.00,636001),('5','96','221409','223',295.00,295.00,373.34,0.00,0.00,0.00,0.00,636002),('5','96','221409','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,636003),('5','96','221616','222',165.00,165.00,10691.40,0.00,0.00,0.00,0.00,636552),('5','96','221616','223',295.00,295.00,1031.20,0.00,0.00,0.00,0.00,636553),('5','96','221616','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,636554),('5','96','221842','222',165.00,165.00,11375.43,0.00,0.00,0.00,0.00,637131),('5','96','221842','223',295.00,295.00,0.00,0.00,0.00,0.00,0.00,637132),('5','96','221842','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,637133),('5','96','222073','222',165.00,165.00,10535.72,0.00,0.00,0.00,0.00,637738),('5','96','222073','223',295.00,295.00,485.10,0.00,0.00,0.00,0.00,637739),('5','96','222073','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,637740),('5','96','222275','222',165.00,165.00,9089.80,0.00,0.00,0.00,0.00,638252),('5','96','222275','223',295.00,295.00,394.69,0.00,0.00,0.00,0.00,638253),('5','96','222275','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,638254),('5','96','222507','222',165.00,165.00,9754.22,0.00,0.00,0.00,0.00,638846),('5','96','222507','223',295.00,295.00,258.01,0.00,0.00,0.00,0.00,638847),('5','96','222507','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,638848),('5','96','222731','222',165.00,165.00,5621.38,0.00,0.00,0.00,0.00,639444),('5','96','222731','223',295.00,295.00,189.06,0.00,0.00,0.00,0.00,639445),('5','96','222731','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,639446),('5','96','222938','222',165.00,165.00,10721.44,0.00,0.00,0.00,0.00,640001),('5','96','222938','223',295.00,295.00,292.84,0.00,0.00,0.00,0.00,640002),('5','96','222938','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,640003),('5','96','223169','222',165.00,165.00,3825.95,0.00,0.00,0.00,0.00,640606),('5','96','223169','223',295.00,295.00,569.12,0.00,0.00,0.00,0.00,640607),('5','96','223169','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,640608),('5','96','223616','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,641721),('5','96','223616','223',295.00,295.00,806.38,0.00,0.00,0.00,0.00,641722),('5','96','223616','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,641723),('5','96','223648','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,641792),('5','96','223648','223',295.00,295.00,481.38,0.00,0.00,0.00,0.00,641793),('5','96','223648','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,641794),('5','96','223918','222',165.00,165.00,4374.21,0.00,0.00,0.00,0.00,642485),('5','96','223918','223',295.00,295.00,397.86,0.00,0.00,0.00,0.00,642486),('5','96','223918','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,642487),('5','96','224080','222',165.00,165.00,7954.28,0.00,0.00,0.00,0.00,642916),('5','96','224080','223',295.00,295.00,608.81,0.00,0.00,0.00,0.00,642917),('5','96','224080','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,642918),('5','96','224322','222',165.00,165.00,7957.01,0.00,0.00,0.00,0.00,643533),('5','96','224322','223',295.00,295.00,434.22,0.00,0.00,0.00,0.00,643534),('5','96','224322','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,643535),('5','96','224558','222',165.00,165.00,7409.83,0.00,0.00,0.00,0.00,644158),('5','96','224558','223',295.00,295.00,496.79,0.00,0.00,0.00,0.00,644159),('5','96','224558','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,644160),('5','96','224817','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,644810),('5','96','224817','223',295.00,295.00,0.00,0.00,0.00,0.00,0.00,644811),('5','96','224817','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,644812),('5','96','224862','222',163.00,163.00,9178.99,0.00,0.00,0.00,0.00,644939),('5','96','224862','223',295.00,295.00,559.42,0.00,0.00,0.00,0.00,644940),('5','96','224862','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,644941),('5','96','225029','222',163.00,163.00,11494.05,0.00,0.00,0.00,0.00,645359),('5','96','225029','223',295.00,295.00,341.26,0.00,0.00,0.00,0.00,645360),('5','96','225029','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,645361),('5','96','225303','222',163.00,163.00,8237.20,0.00,0.00,0.00,0.00,646060),('5','96','225303','223',295.00,295.00,367.51,0.00,0.00,0.00,0.00,646061),('5','96','225303','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,646062),('5','96','225496','222',163.00,163.00,9358.32,0.00,0.00,0.00,0.00,646569),('5','96','225496','223',295.00,295.00,387.26,0.00,0.00,0.00,0.00,646570),('5','96','225496','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,646571),('5','96','225715','222',163.00,163.00,10394.51,0.00,0.00,0.00,0.00,647135),('5','96','225715','223',295.00,295.00,240.64,0.00,0.00,0.00,0.00,647136),('5','96','225715','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,647137),('5','96','225970','222',163.00,163.00,10259.94,0.00,0.00,0.00,0.00,647810),('5','96','225970','223',295.00,295.00,8.19,0.00,0.00,0.00,0.00,647811),('5','96','225970','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,647812),('5','96','226292','222',163.00,163.00,9036.99,0.00,0.00,0.00,0.00,648642),('5','96','226292','223',295.00,295.00,0.00,0.00,0.00,0.00,0.00,648643),('5','96','226292','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,648644),('5','96','226503','222',163.00,163.00,10449.17,0.00,0.00,0.00,0.00,649168),('5','96','226503','223',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649169),('5','96','226503','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,649170),('5','96','226785','222',163.00,163.00,11949.12,0.00,0.00,0.00,0.00,649905),('5','96','226785','223',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649906),('5','96','226785','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,649907),('5','96','227073','222',163.00,163.00,1163.84,0.00,0.00,0.00,0.00,650665),('5','96','227073','223',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650666),('5','96','227073','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,650667),('5','96','227188','222',163.00,163.00,10678.96,0.00,0.00,0.00,0.00,650962),('5','96','227188','223',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650963),('5','96','227188','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,650964),('5','96','227369','222',163.00,163.00,12526.41,0.00,0.00,0.00,0.00,651423),('5','96','227369','223',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651424),('5','96','227369','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,651425),('5','96','227607','222',163.00,163.00,14563.79,0.00,0.00,0.00,0.00,652040),('5','96','227607','223',295.00,300.00,0.00,0.00,0.00,0.00,0.00,652041),('5','96','227607','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,652042),('5','96','227901','222',163.00,163.00,14081.30,0.00,0.00,0.00,0.00,652798),('5','96','227901','223',295.00,300.00,0.00,0.00,0.00,0.00,0.00,652799),('5','96','227901','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,652800),('5','96','230326','222',163.00,163.00,9044.15,0.00,0.00,0.00,0.00,659058),('5','96','230326','223',300.00,300.00,0.00,0.00,0.00,0.00,0.00,659059),('5','96','230326','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,659060),('5','96','230697','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660043),('5','96','230697','223',300.00,300.00,0.00,0.00,0.00,0.00,0.00,660044),('5','96','230697','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660045),('5','96','230844','222',163.00,163.00,9127.28,0.00,0.00,0.00,0.00,660399),('5','96','230844','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660400),('5','96','230844','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660401),('5','96','230853','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660419),('5','96','230853','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660420),('5','96','230853','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660421),('5','96','230857','222',163.00,163.00,4853.59,0.00,0.00,0.00,0.00,660430),('5','96','230857','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660431),('5','96','230857','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660432),('5','96','230871','222',163.00,163.00,1067.64,0.00,0.00,0.00,0.00,660466),('5','96','230871','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660467),('5','96','230871','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660468),('5','96','230919','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660600),('5','96','230919','223',300.00,300.00,0.00,0.00,0.00,0.00,0.00,660601),('5','96','230919','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660602),('5','96','230920','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660603),('5','96','230920','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660604),('5','96','230920','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660605),('5','96','230923','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660611),('5','96','230923','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660612),('5','96','230923','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660613),('5','96','230928','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660625),('5','96','230928','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660626),('5','96','230928','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660627),('5','96','231020','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660890),('5','96','231020','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660891),('5','96','231020','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660892),('5','96','231032','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660926),('5','96','231032','223',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660927),('5','96','231032','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660928),('5','96','231033','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660929),('5','96','231033','223',300.00,320.00,0.00,0.00,0.00,0.00,0.00,660930),('5','96','231033','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660931),('5','96','231034','222',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660932),('5','96','231034','223',300.00,320.00,0.00,0.00,0.00,0.00,0.00,660933),('5','96','231034','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,660934),('5','96','231166','222',163.00,163.00,10392.25,0.00,0.00,0.00,0.00,661259),('5','96','231166','223',300.00,320.00,0.00,0.00,0.00,0.00,0.00,661260),('5','96','231166','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,661261),('5','96','231354','222',163.00,163.00,10638.27,0.00,0.00,0.00,0.00,661785),('5','96','231354','223',300.00,320.00,0.00,0.00,0.00,0.00,0.00,661786),('5','96','231354','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,661787),('5','96','231456','222',163.00,163.00,12041.76,0.00,0.00,0.00,0.00,662034),('5','96','231456','223',300.00,320.00,0.00,0.00,0.00,0.00,0.00,662035),('5','96','231456','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,662036),('5','96','231639','222',163.00,163.00,15274.95,0.00,0.00,0.00,0.00,662514),('5','96','231639','223',300.00,320.00,0.00,0.00,0.00,0.00,0.00,662515),('5','96','231639','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,662516),('5','96','231914','222',163.00,163.00,10536.49,0.00,0.00,0.00,0.00,663255),('5','96','231914','223',300.00,327.00,0.00,0.00,0.00,0.00,0.00,663256),('5','96','231914','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,663257),('5','96','232116','222',163.00,163.00,11209.02,0.00,0.00,0.00,0.00,663795),('5','96','232116','223',300.00,327.00,0.00,0.00,0.00,0.00,0.00,663796),('5','96','232116','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,663797),('5','96','232343','222',163.00,163.00,9724.15,0.00,0.00,0.00,0.00,664377),('5','96','232343','223',300.00,327.00,0.00,0.00,0.00,0.00,0.00,664378),('5','96','232343','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,664379),('5','96','232620','222',163.00,163.00,8267.78,0.00,0.00,0.00,0.00,665106),('5','96','232620','223',300.00,327.00,0.00,0.00,0.00,0.00,0.00,665107),('5','96','232620','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,665108),('5','96','232844','222',163.00,163.00,5790.43,0.00,0.00,0.00,0.00,665716),('5','96','232844','223',300.00,330.00,0.00,0.00,0.00,0.00,0.00,665717),('5','96','232844','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,665718),('5','96','233263','222',163.00,163.00,6256.44,0.00,0.00,0.00,0.00,666815),('5','96','233263','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,666816),('5','96','233263','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,666817),('5','96','233384','222',163.00,163.00,2508.12,0.00,0.00,0.00,0.00,667124),('5','96','233384','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667125),('5','96','233384','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,667126),('5','96','233616','222',163.00,163.00,1644.36,0.00,0.00,0.00,0.00,667728),('5','96','233616','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667729),('5','96','233616','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,667730),('5','96','234007','222',163.00,163.00,5670.72,0.00,0.00,0.00,0.00,668774),('5','96','234007','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,668775),('5','96','234007','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,668776),('5','96','234159','222',163.00,163.00,4713.05,0.00,0.00,0.00,0.00,669162),('5','96','234159','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669163),('5','96','234159','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669164),('5','96','234316','222',163.00,165.00,0.00,0.00,0.00,0.00,0.00,669574),('5','96','234316','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,669575),('5','96','234316','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669576),('5','96','234702','222',165.00,165.00,1587.65,0.00,0.00,0.00,0.00,670597),('5','96','234702','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,670598),('5','96','234702','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,670599),('5','96','234908','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671145),('5','96','234908','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671146),('5','96','234908','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671147),('5','96','234912','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671157),('5','96','234912','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671158),('5','96','234912','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671159),('5','96','234916','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671169),('5','96','234916','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671170),('5','96','234916','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671171),('5','96','235107','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671682),('5','96','235107','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671683),('5','96','235107','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671684),('5','96','235406','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,672455),('5','96','235406','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672456),('5','96','235406','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,672457),('5','96','235650','222',165.00,165.00,8759.93,0.00,0.00,0.00,0.00,673087),('5','96','235650','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673088),('5','96','235650','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,673089),('5','96','235803','222',165.00,165.00,10614.92,0.00,0.00,0.00,0.00,673476),('5','96','235803','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673477),('5','96','235803','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,673478),('5','96','236101','222',165.00,165.00,10729.78,0.00,0.00,0.00,0.00,674267),('5','96','236101','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674268),('5','96','236101','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,674269),('5','96','236351','222',165.00,165.00,16623.14,0.00,0.00,0.00,0.00,674934),('5','96','236351','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,674935),('5','96','236351','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,674936),('5','96','236529','222',165.00,165.00,17963.55,0.00,0.00,0.00,0.00,675396),('5','96','236529','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675397),('5','96','236529','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,675398),('5','96','236760','222',165.00,165.00,10174.21,0.00,0.00,0.00,0.00,675985),('5','96','236760','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675986),('5','96','236760','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,675987),('5','96','237014','222',165.00,165.00,10150.66,0.00,0.00,0.00,0.00,676644),('5','96','237014','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,676645),('5','96','237014','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,676646),('5','96','237230','222',165.00,165.00,2912.46,0.00,0.00,0.00,0.00,677203),('5','96','237230','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677204),('5','96','237230','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,677205),('5','96','237402','222',165.00,165.00,1582.29,0.00,0.00,0.00,0.00,677645),('5','96','237402','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,677646),('5','96','237402','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,677647),('5','96','237676','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678356),('5','96','237676','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678357),('5','96','237676','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,678358),('5','96','237908','222',165.00,165.00,5274.49,0.00,0.00,0.00,0.00,678953),('5','96','237908','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,678954),('5','96','237908','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,678955),('5','96','238131','222',165.00,165.00,9378.36,0.00,0.00,0.00,0.00,679543),('5','96','238131','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679544),('5','96','238131','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,679545),('5','96','238434','222',165.00,165.00,10643.23,0.00,0.00,0.00,0.00,680321),('5','96','238434','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680322),('5','96','238434','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,680323),('5','96','238704','222',165.00,165.00,9930.41,0.00,0.00,0.00,0.00,681030),('5','96','238704','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681031),('5','96','238704','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,681032),('5','96','238839','222',165.00,165.00,10348.73,0.00,0.00,0.00,0.00,681378),('5','96','238839','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681379),('5','96','238839','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,681380),('5','96','239128','222',165.00,165.00,10752.65,0.00,0.00,0.00,0.00,682120),('5','96','239128','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682121),('5','96','239128','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,682122),('5','96','239347','222',165.00,165.00,10727.01,0.00,0.00,0.00,0.00,682693),('5','96','239347','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,682694),('5','96','239347','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,682695),('5','96','239605','222',165.00,165.00,11000.29,0.00,0.00,0.00,0.00,683369),('5','96','239605','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683370),('5','96','239605','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,683371),('5','96','239789','222',165.00,165.00,11101.30,0.00,0.00,0.00,0.00,683846),('5','96','239789','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,683847),('5','96','239789','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,683848),('5','96','240051','222',165.00,165.00,13549.15,0.00,0.00,0.00,0.00,684523),('5','96','240051','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684524),('5','96','240051','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,684525),('5','96','240411','222',165.00,165.00,11591.87,0.00,0.00,0.00,0.00,685478),('5','96','240411','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685479),('5','96','240411','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,685480),('5','96','240539','222',165.00,165.00,10673.47,0.00,0.00,0.00,0.00,685792),('5','96','240539','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685793),('5','96','240539','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,685794),('5','96','240707','222',165.00,165.00,10217.50,0.00,0.00,0.00,0.00,686187),('5','96','240707','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686188),('5','96','240707','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,686189),('5','96','241042','222',165.00,165.00,9370.19,0.00,0.00,0.00,0.00,687082),('5','96','241042','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687083),('5','96','241042','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,687084),('5','96','241310','222',165.00,165.00,6628.89,0.00,0.00,0.00,0.00,687785),('5','96','241310','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687786),('5','96','241310','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,687787),('5','96','241548','222',165.00,165.00,3438.56,0.00,0.00,0.00,0.00,688422),('5','96','241548','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688423),('5','96','241548','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,688424),('5','96','241814','222',165.00,165.00,757.91,0.00,0.00,0.00,0.00,689119),('5','96','241814','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689120),('5','96','241814','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,689121),('5','96','242002','222',165.00,165.00,11689.19,0.00,0.00,0.00,0.00,689607),('5','96','242002','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689608),('5','96','242002','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,689609),('5','96','242224','222',165.00,165.00,12618.42,0.00,0.00,0.00,0.00,690190),('5','96','242224','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690191),('5','96','242224','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,690192),('5','96','242446','222',165.00,165.00,2217.45,0.00,0.00,0.00,0.00,690751),('5','96','242446','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690752),('5','96','242446','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,690753),('5','96','242696','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691404),('5','96','242696','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691405),('5','96','242696','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,691406),('5','96','242992','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692177),('5','96','242992','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692178),('5','96','242992','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,692179),('5','96','243224','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692787),('5','96','243224','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692788),('5','96','243224','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,692789),('5','96','243433','222',165.00,165.00,4477.60,0.00,0.00,0.00,0.00,693332),('5','96','243433','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693333),('5','96','243433','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,693334),('5','96','243840','222',170.00,170.00,12661.92,0.00,0.00,0.00,0.00,694389),('5','96','243840','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694390),('5','96','243840','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,694391),('5','96','243874','222',170.00,170.00,10832.92,0.00,0.00,0.00,0.00,694478),('5','96','243874','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694479),('5','96','243874','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,694480),('5','96','244127','222',170.00,170.00,12023.14,0.00,0.00,0.00,0.00,695122),('5','96','244127','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695123),('5','96','244127','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,695124),('5','96','244343','222',170.00,170.00,12791.16,0.00,0.00,0.00,0.00,695688),('5','96','244343','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695689),('5','96','244343','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,695690),('5','96','244557','222',170.00,170.00,9004.61,0.00,0.00,0.00,0.00,696238),('5','96','244557','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696239),('5','96','244557','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,696240),('5','96','244786','222',170.00,170.00,8374.62,0.00,0.00,0.00,0.00,696841),('5','96','244786','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696842),('5','96','244786','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,696843),('5','96','245000','222',170.00,170.00,3558.94,0.00,0.00,0.00,0.00,697399),('5','96','245000','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697400),('5','96','245000','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,697401),('5','96','245276','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,698104),('5','96','245276','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698105),('5','96','245276','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,698106),('5','96','245468','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,698598),('5','96','245468','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698599),('5','96','245468','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,698600),('5','96','245687','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,699168),('5','96','245687','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699169),('5','96','245687','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,699170),('5','96','246000','222',170.00,170.00,6427.28,0.00,0.00,0.00,0.00,699985),('5','96','246000','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699986),('5','96','246000','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,699987),('5','96','246213','222',170.00,170.00,6146.48,0.00,0.00,0.00,0.00,700528),('5','96','246213','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700529),('5','96','246213','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,700530),('5','96','246480','222',170.00,170.00,6379.86,0.00,0.00,0.00,0.00,701241),('5','96','246480','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701242),('5','96','246480','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,701243),('5','96','246717','222',170.00,170.00,5879.12,0.00,0.00,0.00,0.00,701862),('5','96','246717','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701863),('5','96','246717','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,701864),('5','96','246967','222',170.00,170.00,3427.20,0.00,0.00,0.00,0.00,702497),('5','96','246967','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702498),('5','96','246967','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,702499),('5','96','247201','222',170.00,170.00,1709.93,0.00,0.00,0.00,0.00,703106),('5','96','247201','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703107),('5','96','247201','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,703108),('5','96','247496','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,703856),('5','96','247496','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703857),('5','96','247496','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,703858),('5','96','247738','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,704492),('5','96','247738','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704493),('5','96','247738','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,704494),('5','96','247969','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,705080),('5','96','247969','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705081),('5','96','247969','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,705082),('5','96','248177','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,705629),('5','96','248177','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705630),('5','96','248177','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,705631),('5','96','248578','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,706673),('5','96','248578','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706674),('5','96','248578','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,706675),('5','96','248817','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,707290),('5','96','248817','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707291),('5','96','248817','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,707292),('5','96','248920','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,707536),('5','96','248920','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707537),('5','96','248920','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,707538),('5','96','249181','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,708197),('5','96','249181','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708198),('5','96','249181','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,708199),('5','96','249441','222',170.00,170.00,0.00,0.00,0.00,0.00,0.00,708868),('5','96','249441','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708869),('5','96','249441','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,708870),('5','96','249660','222',170.00,170.00,3568.51,0.00,0.00,0.00,0.00,709429),('5','96','249660','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709430),('5','96','249660','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,709431),('5','96','249915','222',170.00,170.00,6190.28,0.00,0.00,0.00,0.00,710085),('5','96','249915','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710086),('5','96','249915','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,710087),('5','96','250163','222',170.00,170.00,5837.93,0.00,0.00,0.00,0.00,710714),('5','96','250163','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710715),('5','96','250163','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,710716),('5','96','250399','222',170.00,170.00,6424.82,0.00,0.00,0.00,0.00,711310),('5','96','250399','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711311),('5','96','250399','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,711312),('5','96','250588','222',170.00,170.00,8269.91,0.00,0.00,0.00,0.00,711795),('5','96','250588','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711796),('5','96','250588','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,711797),('5','96','250928','222',170.00,170.00,11820.85,0.00,0.00,0.00,0.00,712694),('5','96','250928','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712695),('5','96','250928','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,712696),('5','96','251069','222',170.00,165.00,9335.44,0.00,0.00,0.00,0.00,713043),('5','96','251069','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713044),('5','96','251069','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,713045),('5','96','251346','222',170.00,165.00,10116.09,0.00,0.00,0.00,0.00,713771),('5','96','251346','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713772),('5','96','251346','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,713773),('5','96','251594','222',170.00,165.00,11171.15,0.00,0.00,0.00,0.00,714418),('5','96','251594','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714419),('5','96','251594','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,714420),('5','96','251817','222',170.00,165.00,8689.56,0.00,0.00,0.00,0.00,714999),('5','96','251817','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715000),('5','96','251817','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,715001),('5','96','252095','222',170.00,165.00,5966.53,0.00,0.00,0.00,0.00,715726),('5','96','252095','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715727),('5','96','252095','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,715728),('5','96','252388','222',170.00,165.00,2216.35,0.00,0.00,0.00,0.00,716508),('5','96','252388','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716509),('5','96','252388','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,716510),('5','96','252486','222',170.00,165.00,0.00,0.00,0.00,0.00,0.00,716754),('5','96','252486','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716755),('5','96','252486','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,716756),('5','96','252761','222',170.00,165.00,0.00,0.00,0.00,0.00,0.00,717446),('5','96','252761','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717447),('5','96','252761','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,717448),('5','96','252999','222',170.00,165.00,0.00,0.00,0.00,0.00,0.00,718074),('5','96','252999','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718075),('5','96','252999','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,718076),('5','96','253248','222',170.00,165.00,0.00,0.00,0.00,0.00,0.00,718728),('5','96','253248','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718729),('5','96','253248','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,718730),('5','96','253553','222',170.00,165.00,1062.50,0.00,0.00,0.00,0.00,719517),('5','96','253553','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719518),('5','96','253553','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,719519),('5','96','253807','222',165.00,165.00,10171.49,0.00,0.00,0.00,0.00,720180),('5','96','253807','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720181),('5','96','253807','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,720182),('5','96','253992','222',165.00,165.00,10296.42,0.00,0.00,0.00,0.00,720657),('5','96','253992','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720658),('5','96','253992','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,720659),('5','96','254218','222',165.00,165.00,12256.89,0.00,0.00,0.00,0.00,721247),('5','96','254218','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721248),('5','96','254218','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,721249),('5','96','254533','222',165.00,165.00,4486.36,0.00,0.00,0.00,0.00,722062),('5','96','254533','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722063),('5','96','254533','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,722064),('5','96','254791','222',165.00,165.00,1004.97,0.00,0.00,0.00,0.00,722700),('5','96','254791','223',345.00,350.00,0.00,0.00,0.00,0.00,0.00,722701),('5','96','254791','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,722702),('5','96','254988','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723205),('5','96','254988','223',345.00,350.00,0.00,0.00,0.00,0.00,0.00,723206),('5','96','254988','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,723207),('5','96','255251','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723878),('5','96','255251','223',345.00,350.00,0.00,0.00,0.00,0.00,0.00,723879),('5','96','255251','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,723880),('5','96','255503','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724505),('5','96','255503','223',345.00,350.00,0.00,0.00,0.00,0.00,0.00,724506),('5','96','255503','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,724507),('5','96','255810','222',165.00,165.00,3842.38,0.00,0.00,0.00,0.00,725277),('5','96','255810','223',345.00,350.00,0.00,0.00,0.00,0.00,0.00,725278),('5','96','255810','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,725279),('5','96','256046','222',165.00,165.00,7215.46,0.00,0.00,0.00,0.00,725883),('5','96','256046','223',345.00,355.00,0.00,0.00,0.00,0.00,0.00,725884),('5','96','256046','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,725885),('5','96','256292','222',165.00,165.00,5749.45,0.00,0.00,0.00,0.00,726475),('5','96','256292','223',345.00,355.00,0.00,0.00,0.00,0.00,0.00,726476),('5','96','256292','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,726477),('5','96','256552','222',165.00,165.00,7159.20,0.00,0.00,0.00,0.00,727164),('5','96','256552','223',345.00,355.00,0.00,0.00,0.00,0.00,0.00,727165),('5','96','256552','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,727166),('5','96','256794','222',165.00,165.00,3865.73,0.00,0.00,0.00,0.00,727781),('5','96','256794','223',345.00,355.00,0.00,0.00,0.00,0.00,0.00,727782),('5','96','256794','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,727783),('5','96','257061','222',165.00,165.00,1236.61,0.00,0.00,0.00,0.00,728484),('5','96','257061','223',345.00,360.00,0.00,0.00,0.00,0.00,0.00,728485),('5','96','257061','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,728486),('5','96','257428','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729463),('5','96','257428','223',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729464),('5','96','257428','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,729465),('5','96','257669','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730096),('5','96','257669','223',345.00,360.00,0.00,0.00,0.00,0.00,0.00,730097),('5','96','257669','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730098),('5','96','257670','223',345.00,360.00,0.00,0.00,0.00,0.00,0.00,730099),('5','96','257670','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','96','257670','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730101),('5','96','257671','223',345.00,360.00,0.00,0.00,0.00,0.00,0.00,730102),('5','96','257671','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','96','257671','222',165.00,165.00,859.14,0.00,0.00,0.00,0.00,730104),('5','96','257672','223',345.00,360.00,0.00,0.00,0.00,0.00,0.00,730105),('5','96','257672','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','96','257672','222',165.00,165.00,5524.27,0.00,0.00,0.00,0.00,730107),('5','96','257673','223',345.00,365.00,0.00,0.00,0.00,0.00,0.00,730108),('5','96','257673','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','96','257673','222',165.00,165.00,7382.44,0.00,0.00,0.00,0.00,730110),('5','96','257674','223',345.00,365.00,0.00,0.00,0.00,0.00,0.00,730111),('5','96','257674','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730112),('5','96','257674','222',165.00,165.00,10459.96,0.00,0.00,0.00,0.00,730113),('5','96','257675','223',345.00,390.00,0.00,0.00,0.00,0.00,0.00,730114),('5','96','257675','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730115),('5','96','257675','222',165.00,165.00,8117.79,0.00,0.00,0.00,0.00,730116),('5','96','257676','223',345.00,390.00,0.00,0.00,0.00,0.00,0.00,730117),('5','96','257676','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730118),('5','96','257676','222',165.00,165.00,4728.65,0.00,0.00,0.00,0.00,730119),('5','96','257677','223',345.00,390.00,0.00,0.00,0.00,0.00,0.00,730120),('5','96','257677','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730121),('5','96','257677','222',165.00,165.00,4499.60,0.00,0.00,0.00,0.00,730122),('5','96','257678','223',345.00,390.00,0.00,0.00,0.00,0.00,0.00,730123),('5','96','257678','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','96','257678','222',165.00,165.00,2076.07,0.00,0.00,0.00,0.00,730125),('5','96','257679','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730126),('5','96','257679','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','96','257679','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730128),('5','96','257680','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730129),('5','96','257680','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730130),('5','96','257680','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730131),('5','96','257681','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730132),('5','96','257681','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','96','257681','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730134),('5','96','257682','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730135),('5','96','257682','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','96','257682','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730137),('5','96','257683','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730138),('5','96','257683','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730139),('5','96','257683','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730140),('5','96','257684','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730141),('5','96','257684','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','96','257684','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730143),('5','96','257685','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730144),('5','96','257685','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730145),('5','96','257685','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730146),('5','96','257686','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730147),('5','96','257686','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','96','257686','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730149),('5','96','257687','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730150),('5','96','257687','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','96','257687','222',165.00,165.00,1582.29,0.00,0.00,0.00,0.00,730152),('5','96','257688','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730153),('5','96','257688','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','96','257688','222',165.00,165.00,12073.36,0.00,0.00,0.00,0.00,730155),('5','96','257689','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730156),('5','96','257689','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730157),('5','96','257689','222',165.00,165.00,1888.33,0.00,0.00,0.00,0.00,730158),('5','96','257690','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730159),('5','96','257690','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730160),('5','96','257690','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730161),('5','96','257691','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730162),('5','96','257691','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','96','257691','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730164),('5','96','257692','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730165),('5','96','257692','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730166),('5','96','257692','222',165.00,165.00,1161.35,0.00,0.00,0.00,0.00,730167),('5','96','257693','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730168),('5','96','257693','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','96','257693','222',165.00,165.00,9247.91,0.00,0.00,0.00,0.00,730170),('5','96','257694','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730171),('5','96','257694','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730172),('5','96','257694','222',165.00,165.00,11142.90,0.00,0.00,0.00,0.00,730173),('5','96','257695','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730174),('5','96','257695','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730175),('5','96','257695','222',165.00,165.00,3920.95,0.00,0.00,0.00,0.00,730176),('5','96','257696','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730177),('5','96','257696','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730178),('5','96','257696','222',165.00,165.00,5451.92,0.00,0.00,0.00,0.00,730179),('5','96','257697','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730180),('5','96','257697','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730181),('5','96','257697','222',165.00,165.00,4845.31,0.00,0.00,0.00,0.00,730182),('5','96','257698','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730183),('5','96','257698','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730184),('5','96','257698','222',165.00,165.00,10749.97,0.00,0.00,0.00,0.00,730185),('5','96','257699','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730186),('5','96','257699','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','96','257699','222',165.00,165.00,12734.20,0.00,0.00,0.00,0.00,730188),('5','96','257700','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730189),('5','96','257700','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730190),('5','96','257700','222',165.00,165.00,16415.82,0.00,0.00,0.00,0.00,730191),('5','96','257701','223',345.00,415.00,0.00,0.00,0.00,0.00,0.00,730192),('5','96','257701','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730193),('5','96','257701','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730194),('5','96','257702','223',345.00,425.00,0.00,0.00,0.00,0.00,0.00,730195),('5','96','257702','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730196),('5','96','257702','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730197),('5','96','257703','223',345.00,440.00,0.00,0.00,0.00,0.00,0.00,730198),('5','96','257703','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730199),('5','96','257703','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730200),('5','96','257704','223',345.00,500.00,0.00,0.00,0.00,0.00,0.00,730201),('5','96','257704','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730202),('5','96','257704','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730203),('5','96','257705','223',345.00,500.00,0.00,0.00,0.00,0.00,0.00,730204),('5','96','257705','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730205),('5','96','257705','222',165.00,165.00,4861.57,0.00,0.00,0.00,0.00,730206),('5','96','257706','223',345.00,500.00,0.00,0.00,0.00,0.00,0.00,730207),('5','96','257706','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730208),('5','96','257706','222',165.00,165.00,4219.24,0.00,0.00,0.00,0.00,730209),('5','96','257707','222',165.00,165.00,3897.42,0.00,0.00,0.00,0.00,730210),('5','96','257707','223',345.00,500.00,0.00,0.00,0.00,0.00,0.00,730211),('5','96','257707','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730212),('5','96','257708','223',345.00,600.00,0.00,0.00,0.00,0.00,0.00,730213),('5','96','257708','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730214),('5','96','257708','222',165.00,165.00,1201.05,0.00,0.00,0.00,0.00,730215),('5','96','257709','223',345.00,600.00,0.00,0.00,0.00,0.00,0.00,730216),('5','96','257709','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','96','257709','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730218),('5','96','257710','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730219),('5','96','257710','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730220),('5','96','257710','222',165.00,165.00,1853.42,0.00,0.00,0.00,0.00,730221),('5','96','257711','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730222),('5','96','257711','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','96','257711','222',165.00,165.00,9003.63,0.00,0.00,0.00,0.00,730224),('5','96','257712','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730225),('5','96','257712','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730226),('5','96','257712','222',165.00,165.00,7193.32,0.00,0.00,0.00,0.00,730227),('5','96','257713','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730228),('5','96','257713','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730229),('5','96','257713','222',165.00,165.00,5836.64,0.00,0.00,0.00,0.00,730230),('5','96','257714','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730231),('5','96','257714','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730232),('5','96','257714','222',165.00,165.00,6682.56,0.00,0.00,0.00,0.00,730233),('5','96','257715','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730234),('5','96','257715','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730235),('5','96','257715','222',165.00,165.00,5481.92,0.00,0.00,0.00,0.00,730236),('5','96','257716','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730237),('5','96','257716','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730238),('5','96','257716','222',165.00,165.00,4724.01,0.00,0.00,0.00,0.00,730239),('5','96','257717','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730240),('5','96','257717','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730241),('5','96','257717','222',165.00,165.00,4720.49,0.00,0.00,0.00,0.00,730242),('5','96','257718','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730243),('5','96','257718','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730244),('5','96','257718','222',165.00,165.00,3658.40,0.00,0.00,0.00,0.00,730245),('5','96','257719','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730246),('5','96','257719','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730247),('5','96','257719','222',165.00,165.00,1373.61,0.00,0.00,0.00,0.00,730248),('5','96','257720','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730249),('5','96','257720','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730250),('5','96','257720','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730251),('5','96','257721','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730252),('5','96','257721','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730253),('5','96','257721','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730254),('5','96','257722','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730255),('5','96','257722','224',275.00,0.00,0.00,0.00,0.00,0.00,0.00,730256),('5','96','257722','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730257),('5','96','257723','223',345.00,640.00,0.00,0.00,0.00,0.00,0.00,730258),('5','96','257723','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730259),('5','96','257723','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730260),('5','96','257724','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730261),('5','96','257724','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730262),('5','96','257724','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730263),('5','96','257725','222',165.00,165.00,4644.17,0.00,0.00,0.00,0.00,730264),('5','96','257725','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730265),('5','96','257725','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730266),('5','96','257726','222',165.00,165.00,5009.27,0.00,0.00,0.00,0.00,730267),('5','96','257726','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730268),('5','96','257726','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730269),('5','96','257727','222',165.00,165.00,4158.39,0.00,0.00,0.00,0.00,730270),('5','96','257727','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730271),('5','96','257727','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730272),('5','96','257728','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730273),('5','96','257728','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730274),('5','96','257728','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730275),('5','96','257729','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730276),('5','96','257729','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730277),('5','96','257729','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730278),('5','96','257730','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730279),('5','96','257730','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730280),('5','96','257730','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730281),('5','96','257731','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730282),('5','96','257731','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730283),('5','96','257731','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730284),('5','96','257732','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730285),('5','96','257732','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730286),('5','96','257732','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730287),('5','96','257733','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730288),('5','96','257733','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730289),('5','96','257733','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730290),('5','96','257734','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730291),('5','96','257734','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730292),('5','96','257734','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730293),('5','96','257735','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730294),('5','96','257735','223',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730295),('5','96','257735','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730296),('5','96','257736','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730297),('5','96','257736','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730298),('5','96','257736','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730299),('5','96','257737','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730300),('5','96','257737','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730301),('5','96','257737','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730302),('5','96','257738','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730303),('5','96','257738','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730304),('5','96','257738','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730305),('5','96','257739','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730306),('5','96','257739','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730307),('5','96','257739','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730308),('5','96','257740','222',165.00,165.00,5649.53,0.00,0.00,0.00,0.00,730309),('5','96','257740','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730310),('5','96','257740','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730311),('5','96','257741','222',165.00,165.00,4636.32,0.00,0.00,0.00,0.00,730312),('5','96','257741','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730313),('5','96','257741','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730314),('5','96','257742','222',165.00,165.00,5651.31,0.00,0.00,0.00,0.00,730315),('5','96','257742','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730316),('5','96','257742','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730317),('5','96','257743','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730318),('5','96','257743','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730319),('5','96','257743','222',165.00,165.00,5549.81,0.00,0.00,0.00,0.00,730320),('5','96','257744','222',165.00,165.00,6245.84,0.00,0.00,0.00,0.00,730321),('5','96','257744','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730322),('5','96','257744','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730323),('5','96','257745','222',165.00,165.00,9296.59,0.00,0.00,0.00,0.00,730324),('5','96','257745','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730325),('5','96','257745','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730326),('5','96','257746','222',165.00,165.00,7707.32,0.00,0.00,0.00,0.00,730327),('5','96','257746','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730328),('5','96','257746','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730329),('5','96','257747','222',165.00,165.00,4198.43,0.00,0.00,0.00,0.00,730330),('5','96','257747','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730331),('5','96','257747','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730332),('5','96','257748','222',165.00,165.00,6039.88,0.00,0.00,0.00,0.00,730333),('5','96','257748','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730334),('5','96','257748','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730335),('5','96','257749','222',165.00,165.00,4356.17,0.00,0.00,0.00,0.00,730336),('5','96','257749','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730337),('5','96','257749','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730338),('5','96','257750','222',165.00,165.00,4497.34,0.00,0.00,0.00,0.00,730339),('5','96','257750','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730340),('5','96','257750','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730341),('5','96','257751','222',165.00,165.00,6102.45,0.00,0.00,0.00,0.00,730342),('5','96','257751','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730343),('5','96','257751','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730344),('5','96','257752','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730345),('5','96','257752','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730346),('5','96','257752','222',165.00,165.00,4682.68,0.00,0.00,0.00,0.00,730347),('5','96','257753','222',165.00,165.00,4888.48,0.00,0.00,0.00,0.00,730348),('5','96','257753','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730349),('5','96','257753','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730350),('5','96','257754','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730351),('5','96','257754','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730352),('5','96','257754','222',165.00,165.00,1974.47,0.00,0.00,0.00,0.00,730353),('5','96','257755','222',165.00,165.00,5829.29,0.00,0.00,0.00,0.00,730354),('5','96','257755','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730355),('5','96','257755','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730356),('5','96','257756','222',165.00,165.00,5063.63,0.00,0.00,0.00,0.00,730357),('5','96','257756','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730358),('5','96','257756','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730359),('5','96','257757','222',165.00,165.00,5927.21,0.00,0.00,0.00,0.00,730360),('5','96','257757','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730361),('5','96','257757','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730362),('5','96','257758','222',165.00,165.00,5840.01,0.00,0.00,0.00,0.00,730363),('5','96','257758','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730364),('5','96','257758','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730365),('5','96','257759','222',165.00,165.00,5613.56,0.00,0.00,0.00,0.00,730366),('5','96','257759','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730367),('5','96','257759','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730368),('5','96','257760','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730369),('5','96','257760','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730370),('5','96','257760','222',165.00,165.00,5176.77,0.00,0.00,0.00,0.00,730371),('5','96','257761','222',165.00,165.00,6347.67,0.00,0.00,0.00,0.00,730372),('5','96','257761','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730373),('5','96','257761','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730374),('5','96','257762','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730375),('5','96','257762','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730376),('5','96','257762','222',165.00,165.00,5546.80,0.00,0.00,0.00,0.00,730377),('5','96','257763','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730378),('5','96','257763','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730379),('5','96','257763','222',165.00,165.00,5342.58,0.00,0.00,0.00,0.00,730380),('5','96','257764','222',165.00,165.00,5618.15,0.00,0.00,0.00,0.00,730381),('5','96','257764','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730382),('5','96','257764','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730383),('5','96','257765','222',165.00,165.00,5369.04,0.00,0.00,0.00,0.00,730384),('5','96','257765','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730385),('5','96','257765','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730386),('5','96','257766','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730387),('5','96','257766','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730388),('5','96','257766','222',165.00,165.00,5146.66,0.00,0.00,0.00,0.00,730389),('5','96','257767','222',165.00,165.00,3039.79,0.00,0.00,0.00,0.00,730390),('5','96','257767','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730391),('5','96','257767','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730392),('5','96','257768','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730393),('5','96','257768','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730394),('5','96','257768','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730395),('5','96','257769','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730396),('5','96','257769','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730397),('5','96','257769','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730398),('5','96','257770','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730399),('5','96','257770','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730400),('5','96','257770','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730401),('5','96','257771','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730402),('5','96','257771','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730403),('5','96','257771','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730404),('5','96','257772','223',660.00,660.00,0.00,0.00,0.00,0.00,0.00,730405),('5','96','257772','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730406),('5','96','257772','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730407),('5','96','257773','222',165.00,165.00,5592.01,0.00,0.00,0.00,0.00,730408),('5','96','257773','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730409),('5','96','257773','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730410),('5','96','257774','222',165.00,165.00,5920.29,0.00,0.00,0.00,0.00,730411),('5','96','257774','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730412),('5','96','257774','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730413),('5','96','257775','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730414),('5','96','257775','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730415),('5','96','257775','222',165.00,165.00,5932.21,0.00,0.00,0.00,0.00,730416),('5','96','257776','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730417),('5','96','257776','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730418),('5','96','257776','222',165.00,165.00,5015.40,0.00,0.00,0.00,0.00,730419),('5','96','257777','222',165.00,165.00,5223.61,0.00,0.00,0.00,0.00,730420),('5','96','257777','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730421),('5','96','257777','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730422),('5','96','257778','222',165.00,165.00,2433.69,0.00,0.00,0.00,0.00,730423),('5','96','257778','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730424),('5','96','257778','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730425),('5','96','257779','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730426),('5','96','257779','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730427),('5','96','257779','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730428),('5','96','257780','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730429),('5','96','257780','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730430),('5','96','257780','222',165.00,165.00,6023.02,0.00,0.00,0.00,0.00,730431),('5','96','257781','222',165.00,165.00,5368.59,0.00,0.00,0.00,0.00,730432),('5','96','257781','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730433),('5','96','257781','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730434),('5','96','257782','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730435),('5','96','257782','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730436),('5','96','257782','222',165.00,165.00,5413.43,0.00,0.00,0.00,0.00,730437),('5','96','257783','222',165.00,165.00,5064.66,0.00,0.00,0.00,0.00,730438),('5','96','257783','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730439),('5','96','257783','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730440),('5','96','257784','222',165.00,165.00,5445.25,0.00,0.00,0.00,0.00,730441),('5','96','257784','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730442),('5','96','257784','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730443),('5','96','257785','222',165.00,165.00,2626.35,0.00,0.00,0.00,0.00,730444),('5','96','257785','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730445),('5','96','257785','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730446),('5','96','257786','222',165.00,165.00,5302.70,0.00,0.00,0.00,0.00,730447),('5','96','257786','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730448),('5','96','257786','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730449),('5','96','257787','222',165.00,165.00,5396.50,0.00,0.00,0.00,0.00,730450),('5','96','257787','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730451),('5','96','257787','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730452),('5','96','257788','222',165.00,165.00,5208.97,0.00,0.00,0.00,0.00,730453),('5','96','257788','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730454),('5','96','257788','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730455),('5','96','257789','222',165.00,165.00,5285.64,0.00,0.00,0.00,0.00,730456),('5','96','257789','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730457),('5','96','257789','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730458),('5','96','257790','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730459),('5','96','257790','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730460),('5','96','257790','222',165.00,165.00,2633.71,0.00,0.00,0.00,0.00,730461),('5','96','257791','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730462),('5','96','257791','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730463),('5','96','257791','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730464),('5','96','257792','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730465),('5','96','257792','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730466),('5','96','257792','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730467),('5','96','257793','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730468),('5','96','257793','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730469),('5','96','257793','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730470),('5','96','257794','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730471),('5','96','257794','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730472),('5','96','257794','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730473),('5','96','257795','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730474),('5','96','257795','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730475),('5','96','257795','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730476),('5','96','257796','222',165.00,165.00,6425.10,0.00,0.00,0.00,0.00,730477),('5','96','257796','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730478),('5','96','257796','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730479),('5','96','257797','222',165.00,165.00,6012.04,0.00,0.00,0.00,0.00,730480),('5','96','257797','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730481),('5','96','257797','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730482),('5','96','257798','222',165.00,165.00,5803.23,0.00,0.00,0.00,0.00,730483),('5','96','257798','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730484),('5','96','257798','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730485),('5','96','257799','222',165.00,165.00,5660.66,0.00,0.00,0.00,0.00,730486),('5','96','257799','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730487),('5','96','257799','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730488),('5','96','257800','222',165.00,165.00,5747.82,0.00,0.00,0.00,0.00,730489),('5','96','257800','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730490),('5','96','257800','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730491),('5','96','257801','222',165.00,165.00,6306.68,0.00,0.00,0.00,0.00,730492),('5','96','257801','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730493),('5','96','257801','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730494),('5','96','257802','222',165.00,165.00,5920.19,0.00,0.00,0.00,0.00,730495),('5','96','257802','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730496),('5','96','257802','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730497),('5','96','257803','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730498),('5','96','257803','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730499),('5','96','257803','222',165.00,165.00,2419.96,0.00,0.00,0.00,0.00,730500),('5','96','257804','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730501),('5','96','257804','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730502),('5','96','257804','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730503),('5','96','257805','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730504),('5','96','257805','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730505),('5','96','257805','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730506),('5','96','257806','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730507),('5','96','257806','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730508),('5','96','257806','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730509),('5','96','257807','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730510),('5','96','257807','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730511),('5','96','257807','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730512),('5','96','257808','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730513),('5','96','257808','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730514),('5','96','257808','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730515),('5','96','257809','222',165.00,165.00,6035.60,0.00,0.00,0.00,0.00,730516),('5','96','257809','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730517),('5','96','257809','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730518),('5','96','257810','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730519),('5','96','257810','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730520),('5','96','257810','222',165.00,165.00,5906.28,0.00,0.00,0.00,0.00,730521),('5','96','257811','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730522),('5','96','257811','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730523),('5','96','257811','222',165.00,165.00,5244.28,0.00,0.00,0.00,0.00,730524),('5','96','257812','222',165.00,165.00,5666.38,0.00,0.00,0.00,0.00,730525),('5','96','257812','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730526),('5','96','257812','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730527),('5','96','257813','222',165.00,165.00,4725.09,0.00,0.00,0.00,0.00,730528),('5','96','257813','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730529),('5','96','257813','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730530),('5','96','257814','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730531),('5','96','257814','223',700.00,700.00,0.00,0.00,0.00,0.00,0.00,730532),('5','96','257814','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730533),('5','96','257815','222',165.00,165.00,372.82,0.00,0.00,0.00,0.00,730534),('5','96','257815','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730535),('5','96','257815','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730536),('5','96','257816','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730537),('5','96','257816','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730538),('5','96','257816','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730539),('5','96','257817','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730540),('5','96','257817','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730541),('5','96','257817','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730542),('5','96','257818','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730543),('5','96','257818','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730544),('5','96','257818','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730545),('5','96','257819','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730546),('5','96','257819','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730547),('5','96','257819','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730548),('5','96','257820','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730549),('5','96','257820','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730550),('5','96','257820','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730551),('5','96','257821','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730552),('5','96','257821','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730553),('5','96','257821','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730554),('5','96','257822','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730555),('5','96','257822','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730556),('5','96','257822','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730557),('5','96','257823','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730558),('5','96','257823','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730559),('5','96','257823','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730560),('5','96','257824','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730561),('5','96','257824','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730562),('5','96','257824','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730563),('5','96','257825','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730564),('5','96','257825','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730565),('5','96','257825','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730566),('5','96','257826','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730567),('5','96','257826','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730568),('5','96','257826','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730569),('5','96','257827','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730570),('5','96','257827','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730571),('5','96','257827','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730572),('5','96','257828','222',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730573),('5','96','257828','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730574),('5','96','257828','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730575),('5','96','257829','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730576),('5','96','257829','223',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730577),('5','96','257829','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730578),('5','96','257830','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730579),('5','96','257830','223',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730580),('5','96','257830','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730581),('5','96','257831','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730582),('5','96','257831','223',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730583),('5','96','257831','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730584),('5','96','257832','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730585),('5','96','257832','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730586),('5','96','257832','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730587),('5','96','257833','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730588),('5','96','257833','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730589),('5','96','257833','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730590),('5','96','257834','222',185.00,185.00,5442.99,0.00,0.00,0.00,0.00,730591),('5','96','257834','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730592),('5','96','257834','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730593),('5','96','257835','222',185.00,185.00,5616.51,0.00,0.00,0.00,0.00,730594),('5','96','257835','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730595),('5','96','257835','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730596),('5','96','257836','222',185.00,185.00,5143.38,0.00,0.00,0.00,0.00,730597),('5','96','257836','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730598),('5','96','257836','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730599),('5','96','257837','222',185.00,185.00,5132.83,0.00,0.00,0.00,0.00,730600),('5','96','257837','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730601),('5','96','257837','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730602),('5','96','257838','222',185.00,185.00,5261.46,0.00,0.00,0.00,0.00,730603),('5','96','257838','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730604),('5','96','257838','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730605),('5','96','257839','222',185.00,185.00,5319.46,0.00,0.00,0.00,0.00,730606),('5','96','257839','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730607),('5','96','257839','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730608),('5','96','257840','222',185.00,185.00,5569.37,0.00,0.00,0.00,0.00,730609),('5','96','257840','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730610),('5','96','257840','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730611),('5','96','257841','222',185.00,185.00,5409.14,0.00,0.00,0.00,0.00,730612),('5','96','257841','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730613),('5','96','257841','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730614),('5','96','257842','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730615),('5','96','257842','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730616),('5','96','257842','222',185.00,185.00,6164.43,0.00,0.00,0.00,0.00,730617),('5','96','257843','222',185.00,185.00,8275.85,0.00,0.00,0.00,0.00,730618),('5','96','257843','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730619),('5','96','257843','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730620),('5','96','257844','222',185.00,185.00,6542.66,0.00,0.00,0.00,0.00,730621),('5','96','257844','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730622),('5','96','257844','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730623),('5','96','257845','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730624),('5','96','257845','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730625),('5','96','257845','222',185.00,185.00,6266.49,0.00,0.00,0.00,0.00,730626),('5','96','257846','222',185.00,185.00,6000.68,0.00,0.00,0.00,0.00,730627),('5','96','257846','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730628),('5','96','257846','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730629),('5','96','257847','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730630),('5','96','257847','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730631),('5','96','257847','222',185.00,185.00,5434.00,0.00,0.00,0.00,0.00,730632),('5','96','257848','222',185.00,185.00,4017.31,0.00,0.00,0.00,0.00,730633),('5','96','257848','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730634),('5','96','257848','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730635),('5','96','257849','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730636),('5','96','257849','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730637),('5','96','257849','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730638),('5','96','257850','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730639),('5','96','257850','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730640),('5','96','257850','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730641),('5','96','257851','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730642),('5','96','257851','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730643),('5','96','257851','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730644),('5','96','257852','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730645),('5','96','257852','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730646),('5','96','257852','222',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730647),('5','96','257853','222',185.00,185.00,5251.96,0.00,0.00,0.00,0.00,730648),('5','96','257853','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730649),('5','96','257853','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730650),('5','96','257854','222',185.00,185.00,4556.69,0.00,0.00,0.00,0.00,730651),('5','96','257854','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730652),('5','96','257854','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730653),('5','96','257855','223',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730654),('5','96','257855','224',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730655),('5','96','257855','222',185.00,185.00,5124.49,0.00,0.00,0.00,0.00,730656),('5','96','257856','222',185.00,185.00,7166.04,0.0