-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_95
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_95`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_95` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_95`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3236 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1836,4000,'',0,'2','5','95','UBA 1019882661','','2019-03-13 12:12:58',5,0.00,0.00,'','389','2019-03-13 12:12:58','389',0,1),(1853,3000,'',0,'24','5','95','PURCHASES','','2019-03-15 14:09:52',5,0.00,0.00,'','389','2019-03-15 14:09:52','389',0,1),(1854,3002,'',0,'24','5','95','SALARIES AND WAGES','','2019-03-15 14:10:20',5,0.00,0.00,'','389','2019-03-15 14:10:20','389',0,1),(1855,3003,'',0,'6.1','5','95','CASH','','2019-03-15 14:10:38',5,0.00,0.00,'','389','2019-03-15 14:10:38','389',0,1),(1856,3004,'',0,'24','5','95','DIESEL INTERNAL CONSUPTION(GEN','','2019-03-15 14:10:59',5,0.00,0.00,'','389','2019-03-15 14:10:59','389',0,1),(1857,3005,'',0,'24','5','95','CLEANING & SANITARY ITEMS','','2019-03-15 14:14:19',5,0.00,0.00,'','389','2019-03-15 14:14:19','389',0,1),(1858,3007,'',0,'24','5','95','TRANSPORT FARE','','2019-03-15 14:14:52',5,0.00,0.00,'','389','2019-03-15 14:14:52','389',0,1),(1859,3008,'',0,'24','5','95','OTHER OPERATING EXPENSES','','2019-03-15 14:15:21',5,0.00,0.00,'','389','2019-03-15 14:15:21','389',0,1),(1860,3009,'',0,'24','5','95','GENERATOR REPAIRS & MAINTAINAN','','2019-03-15 14:15:47',5,0.00,0.00,'','389','2019-03-15 14:15:47','389',0,1),(1861,3010,'',0,'24','5','95','PUMP  REPAIRS & MAINTAINANCE','','2019-03-15 14:16:06',5,0.00,0.00,'','389','2019-03-15 14:16:06','389',0,1),(1862,3011,'',0,'24','5','95','WEIGHT AND MEASURE','','2019-03-15 14:16:29',5,0.00,0.00,'','389','2019-03-15 14:16:29','389',0,1),(1863,3006,'',0,'24','5','95','WATER & ELECTRICITY BILL','','2019-03-15 14:16:47',5,0.00,0.00,'','389','2019-03-15 14:16:47','389',0,1),(1864,3012,'',0,'24','5','95','DPR EXPENSES','','2019-03-15 14:17:04',5,0.00,0.00,'','389','2019-03-15 14:17:04','389',0,1),(1865,3014,'',0,'24','5','95','MEDICAL EXPENSES','','2019-03-15 14:17:43',5,0.00,0.00,'','389','2019-03-15 14:17:43','389',0,1),(1866,3001,'',0,'24','5','95','PRINTING & STATIONARY','','2019-03-15 14:19:36',5,0.00,0.00,'','389','2019-03-15 14:19:36','389',0,1),(1867,4001,'',0,'20','5','95','SALES','','2019-03-15 14:20:22',5,0.00,0.00,'','389','2019-03-15 14:20:22','389',0,1),(3232,4019,'',0,'2','5','95','UBA-1023852634','','2021-03-06 01:25:29',5,0.00,0.00,'','600','2021-03-06 01:25:29','600',0,1),(3233,4020,'',0,'2','5','95','JA\'IZ- 0010037957','','2022-03-01 20:43:12',5,0.00,0.00,'','600','2022-03-01 20:43:12','600',0,0),(3234,4021,'',0,'2','5','95','JA\'IZ-0010037957','','2022-03-02 19:09:34',5,0.00,0.00,'','600','2022-03-02 19:09:34','600',0,0),(3235,2000,'',0,'6','5','95','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:27:56',5,0.00,0.00,'','600','2023-02-06 10:27:56','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','95','0000-00-00','2023-02-07 15:23:16',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','95','1','3235','6',0.00,'Pms price increase from 185 to 220 on 20/1/2023  350ltrs ×35 = 12,250',12250.00,'2023-01-20'),(2,'5','95','1','96','supplier',12250.00,'Pms price increase from 185 to 220 on 20/1/2023  350 ×35 = 12,250',0.00,'2023-01-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=3216 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (1535,'','5','95','ADO UMAR','ADO 3 GALON','08087493613','sa.umar004@gmail.com','BUNKURE','KANO','KUMURYA, BUNKURE L.G.','Nigeria',260000.00,0.00,0.00,'0000-00-00','2020-03-10 12:16:42',5,'389','2020-03-10 12:16:42','389'),(2343,'','5','95','KANO STATE PRIMARY HEALTH CARE','BILYAMIN G. ZUBAIRU','08063361454','biyaminu23@gmail.com','RANO','KANO','KANO STATE PRIMARY HEALTH CARE MANGEMENT BOARD RANO ZONAL OFFICE, RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-16 16:17:21',5,'600','2021-03-16 16:17:21','600'),(2344,'','5','95','GAUFF CONSULTANT','ENG. ADESOJI, EGN. BAMIDELE','08064268419,08035831294','crownty2000@yahoo.com','KANO','KANO','BEHIND ZAKI BROTHERS USMANIYYA LINK OFF ABDULLAHI BAYERO ROAD, KANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-16 16:21:27',5,'600','2021-03-16 16:21:27','600'),(2650,'','5','95','Hamisu Aliyu Rano','Hamisu Aliyu rano','08038868232','haliyurano@gmail.com','Rano','Kano','SABUWAR UNGUWA, RANO','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-04 15:59:33',5,'600','2021-05-04 15:59:33','600'),(2651,'','5','95','Alhaji Baba kibiya','Alaji Baba kibiya','08066590496','alasansale3@gmail.com','Kibiya','Kano','Kibiya town','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-05-04 16:01:51',5,'600','2021-05-04 16:01:51','600'),(3215,'','5','95','SINO HYDRO LTD','Jesse','0816 816 4631','sinohydro@gmail.com','Kano','Kano','Rano','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-09-09 20:38:35',5,'600','2021-09-09 20:38:35','600');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17760 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','95',16801,'578',100.00,8500.00,'2021-10-14','','2021-10-14 11:36:06','389','389',2021,'389','2021-10-14 11:36:06',5),('5','95',16802,'579',8500.00,100.00,'2021-10-14','','2021-10-14 11:36:38','389','389',2021,'389','2021-10-14 11:36:38',5),('5','95',17479,'578',823.83,1000.00,'2021-11-05','','2021-11-05 11:54:44','389','389',2021,'389','2021-11-05 11:54:44',5),('5','95',17579,'579',100.00,22500.00,'2021-11-11','I recieved 22500 litres of pms with no short','2021-11-11 17:03:55','389','389',2021,'389','2021-11-11 17:03:55',5),('5','95',17598,'578',25.00,22500.00,'2021-11-13','','2021-11-13 13:56:21','389','389',2021,'389','2021-11-13 13:56:21',5),('5','95',17600,'579',22500.00,100.00,'2021-11-13','','2021-11-13 13:59:41','389','389',2021,'389','2021-11-13 13:59:41',5),('5','95',17750,'579',3301.10,4800.00,'2021-11-24','','2021-11-24 13:52:46','389','389',2021,'389','2021-11-24 13:52:46',5),('5','95',17751,'578',211.01,4200.00,'2021-11-24','','2021-11-24 13:57:30','389','389',2021,'389','2021-11-24 13:57:30',5),('5','95',17752,'579',4800.00,10600.00,'2021-11-24','','2021-11-24 14:01:34','389','389',2021,'389','2021-11-24 14:01:34',5),('5','95',17753,'578',4200.00,200.00,'2021-11-24','','2021-11-24 14:05:36','389','389',2021,'389','2021-11-24 14:05:36',5),('5','95',17754,'578',296.61,200.00,'2022-06-01','','2022-06-03 21:03:00','600','600',2022,'600','2022-06-03 21:03:00',5),('5','95',17755,'579',10111.47,150.00,'2022-06-01','','2022-06-03 21:03:49','600','600',2022,'600','2022-06-03 21:03:49',5),('5','95',17756,'581',834.88,500.00,'2022-06-01','','2022-06-03 21:04:21','600','600',2022,'600','2022-06-03 21:04:21',5),('5','95',17757,'578',132.11,15200.00,'2022-10-02','','2022-10-02 08:11:55','600','600',2022,'600','2022-10-02 08:11:55',5),('5','95',17758,'579',21409.48,30150.00,'2022-10-02','','2022-10-02 08:12:23','600','600',2022,'600','2022-10-02 08:12:23',5),('5','95',17759,'579',18567.79,150.00,'2022-10-31','','2022-10-31 06:07:57','600','600',2022,'600','2022-10-31 06:07:57',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1640 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','95','578',1632,'5','PUMP 1',26868.91,'PMS PUMP 1','',NULL,NULL,'',5,'2022-06-03 14:44:48','600'),('5','95','578',1633,'5','PUMP 2',522835.75,'PMS PUMP 2','',NULL,NULL,'',5,'2022-07-07 18:30:17','600'),('5','95','578',1634,'5','PUMP 3',879784.54,'PMS PUMP 3','',NULL,NULL,'',5,'2022-06-03 14:46:20','600'),('5','95','579',1635,'5','PUMP 5',1183390.18,'PMS PUMP 5','',NULL,NULL,'',5,'2022-07-07 18:31:15','600'),('5','95','579',1636,'5','PUMP 6',3480606.69,'PMS PUMP 6','',NULL,NULL,'',5,'2022-07-07 18:32:30','600'),('5','95','579',1637,'5','PUMP 4',3970170.49,'PMS PUMP 4','',NULL,NULL,'',5,'2022-06-03 14:48:11','600'),('5','95','581',1638,'5','PUMP 7',500564.16,'AGO PUMP 7','',NULL,NULL,'',5,'2021-10-07 14:12:12','600'),('5','95','582',1639,'5','PUMP 8',0.00,'DPK PUMP 8',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (12,'5','95','1637','579','Merging of Pump 2 & 3','2019-09-25 16:14:36',0,'446'),(117,'5','95','1637','580','misplacing','2021-02-28 15:50:21',0,'600'),(118,'5','95','1637','579','Tank connection ','2022-10-31 13:15:14',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257711 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','95',229926,'Daily shift','2021-10-08','2021-10-08 00:00:00',NULL,'389',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','95',231376,'Daily shift','2021-10-01','2021-10-01 00:00:00',NULL,'389',479408.78,479408.78,'389','2021-10-14 11:37:47','606','2021-10-14 11:41:40',10,0),('5','95',231499,'Daily shipt','2021-10-02','2021-10-02 00:00:00',NULL,'389',1149912.65,1149912.65,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','95',231560,'Daily shipt','2021-10-02','2021-10-02 00:00:00',NULL,'389',1082032.33,1082032.33,'389','2021-10-14 14:52:16','606','2021-10-14 14:54:56',10,0),('5','95',231642,'Daily shift','2021-10-03','2021-10-03 00:00:00',NULL,'389',1023258.00,1023258.00,'389','2021-10-15 10:24:39','606','2021-10-15 10:31:07',10,0),('5','95',231750,'Daily shift','2021-10-11','2021-10-11 00:00:00',NULL,'389',127500.00,127500.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','95',232464,'Daily shipt','2021-10-11','2021-10-11 00:00:00',NULL,'389',127500.00,127500.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','95',232468,'Daily shipt','2021-10-04','2021-10-04 00:00:00',NULL,'389',127500.00,127500.00,'389','2021-10-18 13:05:09','606','2021-10-18 13:11:15',10,0),('5','95',232470,'Daily shipt','2021-10-05','2021-10-05 00:00:00',NULL,'389',94995.00,94995.00,'389','2021-10-18 13:12:55','606','2021-10-18 13:14:41',10,0),('5','95',232471,'Daily shipt','2021-10-06','2021-10-06 00:00:00',NULL,'389',64815.00,66975.50,'389','2021-10-18 13:20:27','606','2021-10-18 13:24:00',10,0),('5','95',232473,'Daily shipt','2021-10-07','2021-10-07 00:00:00',NULL,'389',41850.00,43245.00,'389','2021-10-18 13:39:55','606','2021-10-18 13:45:46',10,0),('5','95',232480,'Daily shipt','2021-10-08','2021-10-08 00:00:00',NULL,'389',0.00,0.00,'389','2021-10-18 13:49:22','606','2021-10-18 13:50:34',10,0),('5','95',232482,'Daily shipt','2021-10-13','2021-10-13 00:00:00',NULL,'389',275256.47,275256.47,'389','2021-10-20 14:35:37','606','2021-10-21 17:05:41',10,0),('5','95',233768,'Daily shipt','2021-10-14','2021-10-14 00:00:00',NULL,'389',349181.86,349181.86,'389','2021-10-23 15:27:35','606','2021-10-23 15:34:10',10,0),('5','95',233772,'Daily shipt','2021-10-15','2021-10-15 00:00:00',NULL,'389',473270.50,473270.50,'389','2021-10-23 15:45:40','606','2021-10-23 15:48:57',10,0),('5','95',234220,'Daily shipt','2021-10-16','2021-10-16 00:00:00',NULL,'389',351822.46,351822.46,'389','2021-10-25 14:44:39','606','2021-10-25 14:55:20',10,0),('5','95',234225,'Daily shipt','2021-10-17','2021-10-17 00:00:00',NULL,'389',342552.65,342552.65,'389','2021-10-25 15:05:27','606','2021-10-25 15:07:42',10,0),('5','95',234226,'Daily shipt','2021-10-25','2021-10-25 00:00:00',NULL,'389',582575.04,582575.04,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','95',234230,'Daily shipt','2021-10-18','2021-10-18 00:00:00',NULL,'389',582575.04,582575.04,'389','2021-10-25 15:16:38','606','2021-10-25 15:17:31',10,0),('5','95',234232,'Daily shipt','2021-10-19','2021-10-19 00:00:00',NULL,'389',743956.45,743956.45,'389','2021-10-25 15:20:04','606','2021-10-25 15:21:25',10,0),('5','95',234233,'Daily shipt','2021-10-20','2021-10-20 00:00:00',NULL,'389',1086329.80,1086329.80,'389','2021-10-25 15:23:24','606','2021-10-25 15:24:20',10,0),('5','95',234234,'Daily shipt','2021-10-21','2021-10-21 00:00:00',NULL,'389',866861.71,866861.71,'389','2021-10-25 15:28:21','606','2021-10-25 15:28:47',10,0),('5','95',234236,'Daily shipt','2021-10-22','2021-10-22 00:00:00',NULL,'389',1240503.35,1240503.35,'389','2021-10-25 15:30:30','606','2021-10-25 15:31:18',10,0),('5','95',234237,'Daily shipt','2021-10-23','2021-10-23 00:00:00',NULL,'389',181192.43,181192.43,'389','2021-10-25 15:33:52','606','2021-10-25 15:35:22',10,0),('5','95',234986,'Daily shift','2021-10-24','2021-10-24 00:00:00',NULL,'389',0.00,0.00,'389','2021-10-28 14:54:45','606','2021-10-28 15:09:38',10,0),('5','95',234989,'Daily shift','2021-10-25','2021-10-25 00:00:00',NULL,'389',0.00,0.00,'389','2021-10-28 15:21:08','606','2021-10-28 15:23:33',10,0),('5','95',234991,'Daily shift','2021-10-26','2021-10-26 00:00:00',NULL,'389',0.00,0.00,'389','2021-10-28 15:24:43','606','2021-10-28 15:25:34',10,0),('5','95',234992,'Daily shift','2021-10-27','2021-10-27 00:00:00',NULL,'389',0.00,0.00,'389','2021-10-28 15:30:18','606','2021-10-28 15:32:39',10,0),('5','95',234994,'Daily shift','2021-10-28','2021-10-28 00:00:00',NULL,'389',0.00,0.00,'389','2021-10-28 20:22:18','606','2021-10-29 06:09:34',10,0),('5','95',235160,'Daily shift','2021-10-29','2021-10-29 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-01 05:12:51','606','2021-11-01 07:29:53',10,0),('5','95',236368,'Daily shipt','2021-10-30','2021-10-30 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-03 11:42:20','606','2021-11-03 11:49:09',10,0),('5','95',236371,'Daily shipt','2021-10-31','2021-10-31 00:00:00',NULL,'389',1048521.95,1061387.25,'389','2021-11-03 13:42:04','606','2021-11-03 13:44:10',10,0),('5','95',236405,'Daily shipt','2021-11-01','2021-11-01 00:00:00',NULL,'389',1327986.00,1327986.00,'389','2021-11-03 13:46:17','606','2021-11-03 13:59:14',10,0),('5','95',236409,'Daily shift','2021-11-02','2021-11-02 00:00:00',NULL,'389',86625.00,86625.00,'389','2021-11-03 16:26:27','606','2021-11-03 16:27:23',10,0),('5','95',236443,'Daily shipt','2021-11-03','2021-11-03 00:00:00',NULL,'389',1282254.60,1282254.60,'389','2021-11-03 19:00:39','606','2021-11-04 06:18:10',10,0),('5','95',236626,'Daily shift','2021-11-04','2021-11-04 00:00:00',NULL,'389',1061687.55,1061687.55,'389','2021-11-04 18:00:33','606','2021-11-04 18:03:51',10,0),('5','95',236843,'Daily shipt','2021-11-05','2021-11-05 00:00:00',NULL,'389',160875.00,160875.00,'389','2021-11-05 11:55:44','606','2021-11-06 07:07:00',10,0),('5','95',237781,'Daily shipt','2021-11-06','2021-11-06 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-09 15:52:19','606','2021-11-09 15:55:28',10,0),('5','95',237784,'Daily shipt','2021-11-07','2021-11-07 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-09 15:57:56','606','2021-11-09 16:09:37',10,0),('5','95',237833,'Daily shift','2021-11-08','2021-11-08 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-09 20:43:30','606','2021-11-10 05:53:24',10,0),('5','95',237964,'Daily shift','2021-11-09','2021-11-09 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-10 09:55:42','606','2021-11-10 10:11:12',10,0),('5','95',237990,'Daily shipt','2021-11-10','2021-11-10 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-10 21:16:49','606','2021-11-11 05:49:23',10,0),('5','95',238266,'Daily shift','2021-11-11','2021-11-11 00:00:00',NULL,'389',460592.55,460592.55,'389','2021-11-13 13:58:07','606','2021-11-13 20:00:34',10,0),('5','95',238815,'Daily shipt','2021-11-14','2021-11-14 00:00:00',NULL,'389',702810.90,694291.98,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','95',238991,'Daily shipt','2021-11-12','2021-11-12 00:00:00',NULL,'389',702810.90,702810.90,'389','2021-11-14 18:03:31','606','2021-11-14 18:08:21',10,0),('5','95',238993,'Daily shipt','2021-11-13','2021-11-13 00:00:00',NULL,'389',517997.70,517997.70,'389','2021-11-14 18:13:12','606','2021-11-14 18:14:35',10,0),('5','95',238994,'Daily shipt','2021-11-14','2021-11-14 00:00:00',NULL,'389',630032.70,630032.70,'389','2021-11-14 21:02:49','606','2021-11-15 09:06:57',10,0),('5','95',239171,'Daily shipt','2021-11-15','2021-11-15 00:00:00',NULL,'389',1179438.15,1179438.15,'389','2021-11-15 21:32:29','606','2021-11-16 07:18:49',10,0),('5','95',239360,'Daily shipt','2021-11-16','2021-11-16 00:00:00',NULL,'389',711621.90,711621.90,'389','2021-11-17 15:14:48','606','2021-11-17 15:39:43',10,0),('5','95',239693,'Daily shipt','2021-11-17','2021-11-17 00:00:00',NULL,'389',781636.35,772161.97,'389','2021-11-18 14:50:22','606','2021-11-18 15:02:59',10,0),('5','95',239963,'Daily shipt','2021-11-18','2021-11-18 00:00:00',NULL,'389',865283.10,854794.82,'389','2021-11-18 21:55:33','606','2021-11-19 07:28:27',10,0),('5','95',240078,'Daily shipt','2021-11-19','2021-11-19 00:00:00',NULL,'389',861106.95,861106.95,'389','2021-11-20 08:44:32','606','2021-11-20 13:51:21',10,0),('5','95',240344,'Daily shipt','2021-11-20','2021-11-20 00:00:00',NULL,'389',992252.25,992252.25,'389','2021-11-20 22:48:35','606','2021-11-21 06:41:03',10,0),('5','95',240481,'Daily shipt','2021-11-21','2021-11-21 00:00:00',NULL,'389',792924.00,783312.80,'389','2021-11-21 22:38:45','606','2021-11-22 06:23:00',10,0),('5','95',240762,'Daily shipt','2021-11-22','2021-11-22 00:00:00',NULL,'389',841305.30,831107.66,'389','2021-11-22 22:39:21','606','2021-11-23 07:03:51',10,0),('5','95',241172,'Daily shipt','2021-11-23','2021-11-23 00:00:00',NULL,'389',1025343.00,1025343.00,'389','2021-11-24 14:04:22','600','2021-11-24 14:07:21',10,0),('5','95',241414,'Daily shipt','2021-11-24','2021-11-24 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-25 14:23:18','606','2021-11-26 06:12:14',10,0),('5','95',241769,'Daily shipt','2021-11-24','2021-11-24 00:00:00',NULL,'389',544318.50,544318.50,'389','2021-11-26 07:15:54','606','2021-11-26 07:32:34',10,0),('5','95',241794,'Daily shipt','2021-11-25','2021-11-25 00:00:00',NULL,'389',152280.15,152280.15,'389','2021-11-26 08:10:12','600','2021-11-26 09:18:19',10,0),('5','95',241822,'Daily shift','2021-11-26','2021-11-26 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-27 05:59:18','606','2021-11-27 07:11:45',10,0),('5','95',242076,'Daily shift','2021-11-27','2021-11-27 00:00:00',NULL,'389',839346.75,839346.75,'389','2021-11-28 11:59:01','606','2021-11-28 14:02:35',10,0),('5','95',242391,'Daily shipt','2021-11-28','2021-11-28 00:00:00',NULL,'389',673581.15,673581.15,'389','2021-11-28 21:10:02','606','2021-11-29 05:59:59',10,0),('5','95',242452,'Daily shipt','2021-11-29','2021-11-29 00:00:00',NULL,'389',608277.45,608277.45,'389','2021-11-30 06:36:25','606','2021-11-30 07:08:18',10,0),('5','95',242725,'Daily shipt','2021-11-30','2021-11-30 00:00:00',NULL,'389',0.00,0.00,'389','2021-11-30 21:28:43','606','2021-12-01 07:54:25',10,0),('5','95',243058,'Daily shipt','2021-12-01','2021-12-01 00:00:00',NULL,'389',0.00,0.00,'389','2021-12-01 21:45:39','606','2021-12-02 07:22:17',10,0),('5','95',243339,'Daily shipt','2021-12-02','2021-12-02 00:00:00',NULL,'389',0.00,0.00,'389','2021-12-03 03:38:57','606','2021-12-03 06:58:43',10,0),('5','95',243471,'Daily shipt','2021-12-03','2021-12-03 00:00:00',NULL,'389',0.00,0.00,'389','2021-12-03 18:15:31','606','2021-12-04 06:57:16',10,0),('5','95',243670,'Daily shipt','2021-12-04','2021-12-04 00:00:00',NULL,'389',0.00,0.00,'389','2021-12-04 22:37:46','606','2021-12-05 05:48:20',10,0),('5','95',243833,'Daily shipt','2021-12-05','2021-12-05 00:00:00',NULL,'389',660396.00,680408.00,'389','2021-12-06 10:51:17','600','2021-12-06 11:13:01',10,0),('5','95',244163,'Daily shipt ','2021-12-05','2021-12-05 00:00:00',NULL,'389',683646.50,683646.50,'389','2021-12-06 20:27:08','606','2021-12-07 06:53:26',10,0),('5','95',244385,'Daily shipt','2021-12-07','2021-12-07 00:00:00',NULL,'389',858656.40,858656.40,'389','2021-12-07 21:35:24','606','2021-12-08 07:19:18',10,0),('5','95',244550,'Daily shipt','2021-12-08','2021-12-08 00:00:00',NULL,'389',575254.50,575254.50,'389','2021-12-08 19:58:15','606','2021-12-09 05:43:50',10,0),('5','95',244773,'Daily shipt','2021-12-09','2021-12-09 00:00:00',NULL,'389',542024.60,542024.60,'389','2021-12-09 20:18:24','606','2021-12-10 06:17:22',10,0),('5','95',245012,'Daily shipt','2021-12-10','2021-12-10 00:00:00',NULL,'389',650341.80,650341.80,'389','2021-12-10 21:48:51','606','2021-12-11 07:01:44',10,0),('5','95',245266,'Daily shipt','2021-12-11','2021-12-11 00:00:00',NULL,'389',0.00,0.00,'389','2021-12-11 16:56:58','606','2021-12-12 06:51:48',10,0),('5','95',245762,'Daily shipt','2021-12-12','2021-12-12 00:00:00',NULL,'389',0.00,0.00,'389','2021-12-13 10:35:53','600','2021-12-13 10:53:44',10,0),('5','95',245770,'Daily shipt','2021-12-13','2021-12-13 00:00:00',NULL,'389',0.00,0.00,'389','2021-12-13 22:54:04','606','2021-12-14 06:09:08',10,0),('5','95',246016,'Daily shipt','2021-12-14','2021-12-14 00:00:00',NULL,'389',616823.50,619152.25,'389','2021-12-14 21:31:16','606','2021-12-15 06:40:59',10,0),('5','95',246277,'Daily shipt','2021-12-15','2021-12-15 00:00:00',NULL,'389',610688.05,610688.05,'389','2021-12-15 22:29:53','606','2021-12-16 06:52:43',10,0),('5','95',246548,'Daily shipt','2021-12-16','2021-12-16 00:00:00',NULL,'389',658088.90,658088.90,'389','2021-12-17 02:25:57','606','2021-12-17 06:13:02',10,0),('5','95',246733,'Daily shipt','2021-12-17','2021-12-17 00:00:00',NULL,'389',736174.85,736174.85,'389','2021-12-17 20:17:08','606','2021-12-18 07:04:40',10,0),('5','95',247003,'Daily shipt','2021-12-18','2021-12-18 00:00:00',NULL,'389',248842.00,248842.00,'389','2021-12-19 05:34:27','606','2021-12-19 07:14:12',10,0),('5','95',247205,'Daily shipt ','2021-12-19','2021-12-19 00:00:00',NULL,'389',74185.35,64509.00,'389','2021-12-20 05:46:44','606','2021-12-20 06:57:50',10,0),('5','95',247481,'Daily shipt ','2021-12-20','2021-12-20 00:00:00',NULL,'389',150085.35,150085.35,'389','2021-12-20 21:50:55','600','2021-12-21 09:19:45',10,0),('5','95',247816,'Daily shipt','2021-12-21','2021-12-21 00:00:00',NULL,'389',70038.45,70038.45,'389','2021-12-22 05:14:00','600','2021-12-22 06:38:06',10,0),('5','95',248017,'Daily shipt ','2021-12-22','2021-12-22 00:00:00',NULL,'389',42790.35,42790.35,'389','2021-12-23 05:12:56','606','2021-12-23 06:34:32',10,0),('5','95',248195,'Daily shipt','2021-12-23','2021-12-23 00:00:00',NULL,'389',52467.60,52467.60,'389','2021-12-24 06:20:01','606','2021-12-24 07:22:31',10,0),('5','95',248482,'Daily shipt','2021-12-24','2021-12-24 00:00:00',NULL,'389',46616.40,46616.40,'389','2021-12-25 09:27:29','606','2021-12-25 14:10:38',10,0),('5','95',248795,'Daily shipt ','2021-12-25','2021-12-25 00:00:00',NULL,'389',91469.85,91469.85,'389','2021-12-26 13:54:42','606','2021-12-26 16:12:58',10,0),('5','95',249080,'Daily shipt','2021-12-26','2021-12-26 00:00:00',NULL,'389',167366.40,167366.40,'389','2021-12-26 21:38:06','606','2021-12-27 07:43:49',10,0),('5','95',249187,'Daily shipt','2021-12-27','2021-12-27 00:00:00',NULL,'389',184340.40,184340.40,'389','2021-12-28 03:14:12','606','2021-12-28 07:38:03',10,0),('5','95',249428,'Daily shipt','2021-12-28','2021-12-28 00:00:00',NULL,'389',139076.40,139076.40,'389','2021-12-29 03:34:41','606','2021-12-29 06:47:47',10,0),('5','95',249658,'Daily shipt','2021-12-29','2021-12-29 00:00:00',NULL,'389',298373.25,298373.25,'389','2021-12-29 21:12:30','606','2021-12-30 06:59:45',10,0),('5','95',249904,'Daily shipt','2021-12-30','2021-12-30 00:00:00',NULL,'389',0.00,0.00,'389','2021-12-30 20:44:43','606','2021-12-31 06:48:42',10,0),('5','95',250169,'Daily shipt','2021-12-31','2021-12-31 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-01 02:35:39','606','2022-01-01 07:51:02',10,0),('5','95',250642,'Daily shipt','2022-01-01','2022-01-01 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-02 10:18:13','606','2022-01-02 17:20:56',10,0),('5','95',250752,'Daily shipt ','2022-01-02','2022-01-02 00:00:00',NULL,'389',856606.20,856606.20,'389','2022-01-04 10:23:30','606','2022-01-04 11:03:32',10,0),('5','95',251198,'Daily shipt ','2022-01-04','2022-01-04 00:00:00',NULL,'389',1373972.30,1373972.30,'389','2022-01-04 16:41:46','606','2022-01-04 16:56:18',10,0),('5','95',251441,'Daily shipt','2022-01-03','2022-01-03 00:00:00',NULL,'389',914436.80,914436.80,'389','2022-01-05 17:54:32','600','2022-01-05 18:03:30',10,0),('5','95',251491,'Daily shipt','2022-01-05','2022-01-05 00:00:00',NULL,'389',766932.90,744376.05,'389','2022-01-05 22:19:10','606','2022-01-06 07:51:38',10,0),('5','95',251627,'Daily shipt','2022-01-06','2022-01-06 00:00:00',NULL,'389',884299.20,858290.40,'389','2022-01-07 08:59:13','606','2022-01-07 09:11:10',10,0),('5','95',251818,'Daily shipt','2022-01-07','2022-01-07 00:00:00',NULL,'389',896549.40,870180.30,'389','2022-01-08 06:21:24','606','2022-01-08 08:00:04',10,0),('5','95',252228,'Daily shipt','2022-01-08','2022-01-08 00:00:00',NULL,'389',823376.30,799159.35,'389','2022-01-09 06:34:22','606','2022-01-09 08:05:06',10,0),('5','95',252428,'Daily shipt','2022-01-09','2022-01-09 00:00:00',NULL,'389',257835.60,250252.20,'389','2022-01-09 21:19:08','606','2022-01-10 07:03:50',10,0),('5','95',252705,'Daily shipt ','2022-01-10','2022-01-10 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-11 06:25:57','606','2022-01-11 19:01:45',10,0),('5','95',252911,'Daily shipt','2022-01-11','2022-01-11 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-11 19:07:00','606','2022-01-12 07:51:15',10,0),('5','95',253013,'Daily shipt','2022-01-12','2022-01-12 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-12 20:22:23','606','2022-01-13 07:42:08',10,0),('5','95',253330,'Daily shipt','2022-01-13','2022-01-13 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-14 06:11:51','606','2022-01-14 09:43:08',10,0),('5','95',253870,'Daily shipt ','2022-01-14','2022-01-14 00:00:00',NULL,'389',820191.90,820191.90,'389','2022-01-15 17:29:00','606','2022-01-15 18:20:45',10,0),('5','95',253886,'Daily shipt','2022-01-15','2022-01-15 00:00:00',NULL,'389',839520.00,839520.00,'389','2022-01-15 21:16:02','606','2022-01-16 07:23:42',10,0),('5','95',253974,'Daily shipt','2022-01-16','2022-01-16 00:00:00',NULL,'389',862956.60,862956.60,'389','2022-01-17 02:08:30','606','2022-01-17 07:15:45',10,0),('5','95',254355,'Daily shipt','2022-01-17','2022-01-17 00:00:00',NULL,'389',842009.85,842009.85,'389','2022-01-17 21:21:45','606','2022-01-18 08:41:30',10,0),('5','95',254554,'Daily shipt','2022-01-18','2022-01-18 00:00:00',NULL,'389',767616.30,767616.30,'389','2022-01-18 20:06:20','606','2022-01-19 10:07:34',10,0),('5','95',254825,'Daily shipt','2022-01-19','2022-01-19 00:00:00',NULL,'389',132366.30,130761.86,'389','2022-01-20 06:14:35','606','2022-01-20 08:09:35',10,0),('5','95',254985,'Daily shipt','2022-01-20','2022-01-20 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-20 15:50:55','606','2022-01-21 08:37:44',10,0),('5','95',255443,'Daily shipt','2022-01-21','2022-01-21 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-21 23:23:34','606','2022-01-22 08:09:07',10,0),('5','95',255705,'Daily shipt','2022-01-22','2022-01-22 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-23 06:36:58','606','2022-01-23 07:25:02',10,0),('5','95',256044,'Daily shipt','2022-01-23','2022-01-23 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-24 10:35:35','606','2022-01-24 11:04:28',10,0),('5','95',256101,'Daily shipt','2022-01-23','2022-01-23 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-24 18:53:09','606','2022-01-25 07:35:15',10,0),('5','95',256230,'Daily shipt','2022-01-25','2022-01-25 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-25 19:01:57','606','2022-01-26 08:10:11',10,0),('5','95',256522,'Daily shipt','2022-01-26','2022-01-26 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-26 23:31:18','606','2022-01-27 07:58:43',10,0),('5','95',256787,'Daily shipt','2022-01-27','2022-01-27 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-28 06:57:08','606','2022-01-28 07:24:25',10,0),('5','95',257163,'Daily shipt','2022-01-28','2022-01-28 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-28 17:33:32','606','2022-01-29 07:52:56',10,0),('5','95',257381,'Daily shipt','2022-01-29','2022-01-29 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-29 18:07:17','606','2022-01-30 07:46:25',10,0),('5','95',257382,'Daily shift','2022-01-31','2022-01-31 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-31 12:38:21','606','2022-01-31 13:19:02',10,0),('5','95',257383,'Daily shipt','2022-01-31','2022-01-31 00:00:00',NULL,'389',0.00,0.00,'389','2022-01-31 22:37:46','606','2022-02-01 08:31:50',10,0),('5','95',257384,'Daily shipt','2022-02-01','2022-02-01 00:00:00',NULL,'389',202044.15,202044.15,'389','2022-02-02 12:08:40','606','2022-02-02 13:04:00',10,0),('5','95',257385,'Daily shift','2022-02-02','2022-02-02 00:00:00',NULL,'389',827021.25,827021.25,'389','2022-02-03 07:02:46','606','2022-02-03 08:11:26',10,0),('5','95',257386,'Daily','2022-02-03','2022-02-03 00:00:00',NULL,'389',866335.80,866335.80,'389','2022-02-04 04:21:56','606','2022-02-04 06:29:12',10,0),('5','95',257387,'Daily shift','2022-02-04','2022-02-04 00:00:00',NULL,'389',857176.65,857176.65,'389','2022-02-04 22:09:36','606','2022-02-05 07:52:54',10,0),('5','95',257388,'Daily shift','2022-02-05','2022-02-05 00:00:00',NULL,'389',945387.30,945387.30,'389','2022-02-05 22:53:06','606','2022-02-06 07:48:42',10,0),('5','95',257389,'Daily shift','2022-02-07','2022-02-07 00:00:00',NULL,'389',660415.80,660415.80,'389','2022-02-07 06:37:00','606','2022-02-07 07:17:57',10,0),('5','95',257390,'Daily shift','2022-02-07','2022-02-07 00:00:00',NULL,'389',365333.10,365333.10,'389','2022-02-09 23:05:41','606','2022-02-10 08:02:34',10,0),('5','95',257391,'Daily shift','2022-02-08','2022-02-08 00:00:00',NULL,'389',143880.00,143880.00,'389','2022-02-10 08:47:51','606','2022-02-11 08:13:19',10,0),('5','95',257392,'Daily shift','2022-02-09','2022-02-09 00:00:00',NULL,'389',0.00,0.00,'389','2022-02-11 08:37:10','606','2022-02-12 08:14:08',10,0),('5','95',257393,'Daily shift','2022-02-12','2022-02-12 00:00:00',NULL,'389',0.00,0.00,'389','2022-02-12 12:42:12','606','2022-02-13 07:31:09',10,0),('5','95',257394,'Daily shift','2022-02-13','2022-02-13 00:00:00',NULL,'389',0.00,0.00,'389','2022-02-14 04:06:32','606','2022-02-14 07:22:09',10,0),('5','95',257395,'Daily shift','2022-02-14','2022-02-14 00:00:00',NULL,'389',0.00,0.00,'389','2022-02-15 07:58:54','606','2022-02-15 08:11:42',10,0),('5','95',257396,'Daily','2022-02-15','2022-02-15 00:00:00',NULL,'389',0.00,0.00,'389','2022-02-15 20:29:15','606','2022-02-16 07:33:39',10,0),('5','95',257397,'Daily shift','2022-02-17','2022-02-17 00:00:00',NULL,'389',0.00,0.00,'389','2022-02-17 07:32:03','606','2022-02-17 22:56:02',10,0),('5','95',257398,'Daily shift','2022-02-17','2022-02-17 00:00:00',NULL,'389',185997.65,185997.65,'389','2022-02-18 11:00:45','606','2022-02-18 11:29:21',10,0),('5','95',257399,'Daily shift','2022-02-18','2022-02-18 00:00:00',NULL,'389',895191.00,895191.00,'389','2022-02-19 07:06:47','606','2022-02-19 07:33:48',10,0),('5','95',257400,'Daily shift','2022-02-19','2022-02-19 00:00:00',NULL,'389',1179915.00,1179915.00,'389','2022-02-19 20:27:21','606','2022-02-20 07:23:48',10,0),('5','95',257401,'Daily shift','2022-02-20','2022-02-20 00:00:00',NULL,'389',167158.20,167158.20,'389','2022-02-21 06:22:53','606','2022-02-21 07:26:36',10,0),('5','95',257402,'Daily shift','2022-02-21','2022-02-21 00:00:00',NULL,'389',0.00,0.00,'389','2022-02-21 22:31:32','606','2022-02-22 06:45:58',10,0),('5','95',257403,'Daily shift ','2022-02-22','2022-02-22 23:28:04','2022-02-23 23:28:04','389',217973.25,217973.25,'389','2022-02-24 06:50:54','606','2022-02-24 09:39:35',10,0),('5','95',257404,'Daily shift','2022-02-23','2022-02-25 19:04:59','2022-02-26 19:04:59','389',1175161.35,1175161.35,'389','2022-02-25 19:07:44','606','2022-02-25 21:02:39',10,0),('5','95',257405,'Daily shift','2022-02-24','2022-02-25 22:35:53','2022-02-26 22:35:53','389',779625.00,779625.00,'389','2022-02-25 22:39:46','606','2022-02-26 07:21:59',10,0),('5','95',257406,'Daily shift','2022-02-25','2022-02-26 08:50:29','2022-02-27 08:50:29','389',102469.83,102469.83,'389','2022-02-26 08:54:50','606','2022-02-27 07:04:48',10,0),('5','95',257407,'Daily shift','2022-03-02','2022-03-02 16:48:06','2022-03-03 16:48:06','389',252124.95,252124.95,'389','2022-03-02 16:52:10','606','2022-03-02 16:55:51',10,0),('5','95',257408,'Daily shift','2022-02-27','2022-03-02 17:03:09','2022-03-03 17:03:09','389',1736504.55,1736504.55,'389','2022-03-02 17:06:29','606','2022-03-03 10:22:39',10,0),('5','95',257409,'Daily shift','2022-02-28','2022-03-03 15:18:32','2022-03-04 15:18:32','389',1854905.25,1854905.25,'389','2022-03-03 15:20:49','606','2022-03-03 15:38:57',10,0),('5','95',257410,'Daily','2022-03-01','2022-03-03 23:00:03','2022-03-04 23:00:03','389',780803.10,780803.10,'389','2022-03-03 23:08:44','606','2022-03-04 09:14:43',10,0),('5','95',257411,'Daily shift','2022-03-02','2022-03-04 15:13:28','2022-03-05 15:13:28','389',0.00,0.00,'389','2022-03-04 15:15:30','606','2022-03-05 07:35:02',10,0),('5','95',257412,'Daily shift','2022-03-03','2022-03-06 06:49:58','2022-03-07 06:49:58','389',0.00,0.00,'389','2022-03-06 06:51:06','606','2022-03-06 07:43:54',10,0),('5','95',257413,'Daily shift','2022-03-06','2022-03-06 23:30:52','2022-03-07 23:30:52','389',449760.30,449760.30,'389','2022-03-08 07:23:40','600','2022-03-08 07:56:34',10,0),('5','95',257414,'Daily shift','2022-03-07','2022-03-09 06:59:49','2022-03-10 06:59:49','389',882918.30,882918.30,'389','2022-03-09 07:05:53','606','2022-03-09 07:58:57',10,0),('5','95',257415,'Daily shift','2022-03-08','2022-03-10 05:53:19','2022-03-11 05:53:19','389',682342.65,682342.65,'389','2022-03-10 06:24:09','606','2022-03-10 06:41:42',10,0),('5','95',257416,'Daily shift','2022-03-09','2022-03-10 14:48:20','2022-03-11 14:48:20','389',354301.20,354301.20,'389','2022-03-10 14:50:36','606','2022-03-11 08:26:37',10,0),('5','95',257417,'Daily shift','2022-03-10','2022-03-11 11:31:59','2022-03-12 11:31:59','389',137798.10,137798.10,'389','2022-03-11 11:35:46','606','2022-03-12 07:58:24',10,0),('5','95',257418,'Daily shift','2022-03-11','2022-03-13 16:19:02','2022-03-14 16:19:02','389',437550.30,437550.30,'389','2022-03-13 16:27:16','600','2022-03-13 17:32:41',10,0),('5','95',257419,'Daily shift','2022-03-12','2022-03-13 17:40:39','2022-03-14 17:40:39','389',1409302.95,1409302.95,'389','2022-03-13 17:43:42','600','2022-03-13 18:03:22',10,0),('5','95',257420,'Daily shift','2022-03-13','2022-03-13 18:41:54','2022-03-14 18:41:54','389',1191003.00,1191003.00,'389','2022-03-14 06:39:28','606','2022-03-14 07:07:59',10,0),('5','95',257421,'Daily shift','2022-03-14','2022-03-14 16:23:03','2022-03-15 16:23:03','389',780750.30,780750.30,'389','2022-03-15 00:07:57','606','2022-03-15 07:09:59',10,0),('5','95',257422,'Daily shift','2022-03-15','2022-03-16 06:12:09','2022-03-17 06:12:09','389',679829.70,679829.70,'389','2022-03-16 06:16:40','606','2022-03-16 08:12:30',10,0),('5','95',257423,'Daily shift','2022-03-16','2022-03-18 09:53:41','2022-03-19 09:53:41','389',893021.25,893021.25,'389','2022-03-18 19:14:23','600','2022-03-18 19:19:58',10,0),('5','95',257424,'Daily shift','2022-03-17','2022-03-18 19:24:25','2022-03-19 19:24:25','389',713011.20,713011.20,'389','2022-03-18 19:29:18','600','2022-03-18 19:54:33',10,0),('5','95',257425,'Daily shift','2022-03-18','2022-03-18 20:25:15','2022-03-19 20:25:15','389',690130.65,690130.65,'389','2022-03-18 20:27:17','606','2022-03-19 07:03:07',10,0),('5','95',257426,'Daily shift','2022-03-19','2022-03-19 15:46:50','2022-03-20 15:46:50','389',388004.10,388004.10,'389','2022-03-19 22:13:34','606','2022-03-20 07:33:21',10,0),('5','95',257427,'Daily shift','2022-03-20','2022-03-20 23:57:32','2022-03-21 23:57:32','389',209355.30,209355.30,'389','2022-03-21 00:00:41','606','2022-03-21 06:34:45',10,0),('5','95',257428,'Daily shift','2022-03-21','2022-03-21 10:34:54','2022-03-22 10:34:54','389',0.00,0.00,'389','2022-03-22 06:23:43','606','2022-03-22 07:08:08',10,0),('5','95',257429,'Daily shift','2022-03-22','2022-03-22 11:17:30','2022-03-23 11:17:30','389',0.00,0.00,'389','2022-03-22 22:39:27','606','2022-03-23 06:34:34',10,0),('5','95',257430,'Daily shift ','2022-03-23','2022-03-23 07:08:58','2022-03-24 07:08:58','389',0.00,0.00,'389','2022-03-24 01:21:41','606','2022-03-24 20:36:21',10,0),('5','95',257431,'Daily shift','2022-03-24','2022-03-26 05:59:48','2022-03-27 05:59:48','389',268263.60,268263.60,'389','2022-03-26 06:15:01','606','2022-03-26 08:07:19',10,0),('5','95',257432,'Daily shift','2022-03-25','2022-03-27 00:17:20','2022-03-28 00:17:20','389',847855.80,847855.80,'389','2022-03-27 00:20:40','606','2022-03-27 07:07:04',10,0),('5','95',257433,'Daily shift','2022-03-26','2022-03-27 21:58:24','2022-03-28 21:58:24','389',1092303.30,1092303.30,'389','2022-03-27 22:01:59','606','2022-03-28 09:22:38',10,0),('5','95',257434,'DAILY','2022-06-01','2022-06-01 14:44:05','2022-06-02 14:44:05','389',1486.65,1468.63,'389','2022-06-01 14:55:39','600','2022-06-02 10:57:36',10,0),('5','95',257435,' DAILY SHIFT','2022-06-02','2022-06-02 12:15:58','2022-06-03 12:15:58','389',1978.35,1954.37,'389','2022-06-02 12:19:40','600','2022-06-03 14:43:11',10,0),('5','95',257436,' DAILY SHIFT','2022-06-01','2022-06-04 06:57:05','2022-06-05 06:57:05','389',0.00,0.00,'389','2022-06-04 09:10:30','797','2022-06-04 09:12:35',10,0),('5','95',257437,' DAILY SHIFT','2022-06-02','2022-06-04 09:14:51','2022-06-05 09:14:51','389',0.00,0.00,'389','2022-06-04 09:15:37','797','2022-06-04 09:18:54',10,0),('5','95',257438,' DAILY SHIFT','2022-06-03','2022-06-04 09:20:26','2022-06-05 09:20:26','389',0.00,0.00,'389','2022-06-04 09:21:39','797','2022-06-04 09:23:39',10,0),('5','95',257439,' DAILY SHIFT','2022-06-04','2022-06-04 09:27:31','2022-06-05 09:27:31','389',0.00,0.00,'389','2022-06-04 20:29:10','797','2022-06-05 08:10:13',10,0),('5','95',257440,' DAILY SHIFT','2022-06-05','2022-06-05 08:26:45','2022-06-06 08:26:45','389',0.00,0.00,'389','2022-06-05 21:06:54','797','2022-06-06 09:46:31',10,0),('5','95',257441,'DAILY SHIFT','2022-06-06','2022-06-06 09:50:40','2022-06-07 09:50:40','389',0.00,0.00,'389','2022-06-06 21:07:37','797','2022-06-07 06:50:27',10,0),('5','95',257442,'DAILY SHIFT','2022-06-07','2022-06-07 09:39:01','2022-06-08 09:39:01','389',0.00,0.00,'389','2022-06-07 19:35:28','797','2022-06-08 09:04:56',10,0),('5','95',257443,'DAILY SHIFT','2022-06-08','2022-06-08 09:45:44','2022-06-09 09:45:44','389',0.00,0.00,'389','2022-06-08 18:31:51','797','2022-06-08 23:04:11',10,0),('5','95',257444,'DAILY SHIFT','2022-06-09','2022-06-09 08:23:18','2022-06-10 08:23:18','389',0.00,0.00,'389','2022-06-09 18:38:27','797','2022-06-10 05:45:39',10,0),('5','95',257445,'DAILY SHIFT','2022-06-10','2022-06-10 09:11:58','2022-06-11 09:11:58','389',0.00,0.00,'389','2022-06-10 18:23:55','797','2022-06-11 05:51:49',10,0),('5','95',257446,'DAILY SHIFT','2022-06-11','2022-06-11 09:11:24','2022-06-12 09:11:24','389',0.00,0.00,'389','2022-06-11 17:35:52','797','2022-06-12 12:34:09',10,0),('5','95',257447,'DAILY SHIFT','2022-06-12','2022-06-12 12:43:25','2022-06-13 12:43:25','389',0.00,0.00,'389','2022-06-12 20:10:44','797','2022-06-13 07:02:47',10,0),('5','95',257448,'DAILY SHIFT','2022-06-13','2022-06-13 08:51:34','2022-06-14 08:51:34','389',0.00,0.00,'389','2022-06-13 19:41:34','797','2022-06-14 06:48:39',10,0),('5','95',257449,'DAILY SHIFT','2022-06-14','2022-06-14 09:33:28','2022-06-15 09:33:28','389',0.00,0.00,'389','2022-06-14 18:34:16','797','2022-06-15 09:32:14',10,0),('5','95',257450,'DAILY SHIFT','2022-06-15','2022-06-15 09:37:53','2022-06-16 09:37:53','389',0.00,0.00,'389','2022-06-15 19:28:05','797','2022-06-16 06:57:35',10,0),('5','95',257451,'DAILY SHIFT','2022-06-16','2022-06-16 09:09:35','2022-06-17 09:09:35','389',0.00,0.00,'389','2022-06-16 19:57:37','797','2022-06-17 07:08:52',10,0),('5','95',257452,'DAILY SHIFT','2022-06-17','2022-06-17 09:11:21','2022-06-18 09:11:21','389',0.00,0.00,'389','2022-06-17 18:06:04','797','2022-06-18 07:31:59',10,0),('5','95',257453,'DAILY SHIFT','2022-06-18','2022-06-18 08:59:20','2022-06-19 08:59:20','389',0.00,0.00,'389','2022-06-18 19:16:17','797','2022-06-18 23:04:44',10,0),('5','95',257454,'DAILY SHIFT','2022-06-19','2022-06-19 08:25:44','2022-06-20 08:25:44','389',0.00,0.00,'389','2022-06-19 18:22:27','797','2022-06-20 06:06:19',10,0),('5','95',257455,'DAILY SHIFT','2022-06-20','2022-06-20 08:42:36','2022-06-21 08:42:36','389',0.00,0.00,'389','2022-06-20 19:49:54','797','2022-06-21 06:18:24',10,0),('5','95',257456,'DAILY SHIFT','2022-06-21','2022-06-21 08:32:49','2022-06-22 08:32:49','389',0.00,0.00,'389','2022-06-21 18:28:53','797','2022-06-21 20:34:07',10,0),('5','95',257457,'DAILY SHIFT','2022-06-22','2022-06-22 08:32:27','2022-06-23 08:32:27','389',0.00,0.00,'389','2022-06-22 18:18:30','797','2022-06-23 05:36:16',10,0),('5','95',257458,'DAILY SHIFT','2022-06-23','2022-06-23 08:46:53','2022-06-24 08:46:53','389',0.00,0.00,'389','2022-06-23 22:10:36','797','2022-06-24 07:03:14',10,0),('5','95',257459,'DAILY SHIFT','2022-06-24','2022-06-24 11:06:16','2022-06-25 11:06:16','389',0.00,0.00,'389','2022-06-24 21:43:42','797','2022-06-25 07:54:51',10,0),('5','95',257460,'DAILY SHIFT','2022-06-25','2022-06-25 08:53:22','2022-06-26 08:53:22','389',0.00,0.00,'389','2022-06-25 20:32:48','797','2022-06-26 09:00:53',10,0),('5','95',257461,'DAILY SHIFT','2022-06-26','2022-06-26 09:04:10','2022-06-27 09:04:10','389',0.00,0.00,'389','2022-06-26 22:57:47','797','2022-06-27 09:38:11',10,0),('5','95',257462,'DAILY SHIFT','2022-06-27','2022-06-27 09:43:45','2022-06-28 09:43:45','389',0.00,0.00,'389','2022-06-27 18:53:10','797','2022-06-28 09:37:40',10,0),('5','95',257463,'DAILY SHIFT','2022-06-28','2022-06-28 10:48:21','2022-06-29 10:48:21','389',0.00,0.00,'389','2022-06-28 19:49:03','797','2022-06-29 09:28:43',10,0),('5','95',257464,'DAILY SHIFT','2022-06-29','2022-06-29 09:46:46','2022-06-30 09:46:46','389',0.00,0.00,'389','2022-06-29 19:50:35','797','2022-06-30 07:17:57',10,0),('5','95',257465,'DAILY SHIFT','2022-06-30','2022-06-30 08:40:09','2022-07-01 08:40:09','389',0.00,0.00,'389','2022-06-30 20:57:34','797','2022-07-01 07:30:53',10,0),('5','95',257466,'DAILY SHIFT','2022-07-01','2022-07-01 07:32:05','2022-07-02 07:32:05','389',0.00,0.00,'389','2022-07-01 18:05:04','797','2022-07-02 09:05:52',10,0),('5','95',257467,'DAILY SHIFT','2022-07-02','2022-07-02 09:48:45','2022-07-03 09:48:45','389',0.00,0.00,'389','2022-07-02 20:25:28','797','2022-07-03 09:06:51',10,0),('5','95',257468,'DAILY SHIFT','2022-07-03','2022-07-03 12:02:47','2022-07-04 12:02:47','389',0.00,0.00,'389','2022-07-03 18:01:50','797','2022-07-04 07:00:20',10,0),('5','95',257469,'DAILY SHIFT','2022-07-04','2022-07-04 09:07:10','2022-07-05 09:07:10','389',0.00,0.00,'389','2022-07-04 20:25:42','797','2022-07-05 06:32:16',10,0),('5','95',257470,'DAILY SHIFT','2022-07-05','2022-07-05 08:41:08','2022-07-06 08:41:08','389',0.00,0.00,'389','2022-07-05 18:21:51','797','2022-07-06 06:27:03',10,0),('5','95',257471,'DAILY SHIFT','2022-07-06','2022-07-06 08:39:43','2022-07-07 08:39:43','389',0.00,0.00,'389','2022-07-06 22:01:14','797','2022-07-07 06:50:25',10,0),('5','95',257472,'DAILY SHIFT','2022-07-07','2022-07-07 07:12:46','2022-07-08 07:12:46','389',0.00,0.00,'600','2022-07-07 18:29:18','600','2022-07-07 18:29:32',10,0),('5','95',257473,'DAILY','2022-07-07','2022-07-07 18:33:34','2022-07-08 18:33:34','600',940179.90,940179.90,'389','2022-07-07 21:07:28','797','2022-07-08 03:55:33',10,0),('5','95',257474,' DAILY SHIFT','2022-07-08','2022-07-08 07:35:38','2022-07-09 07:35:38','389',614707.50,614707.50,'389','2022-07-08 18:44:44','797','2022-07-09 10:56:23',10,0),('5','95',257475,'DAILY SHIFT','2022-07-09','2022-07-09 11:01:53','2022-07-10 11:01:53','389',38509.60,38509.60,'389','2022-07-09 13:28:33','797','2022-07-09 13:38:23',10,0),('5','95',257476,'DAILY SHIFT','2022-07-09','2022-07-09 13:47:01','2022-07-10 13:47:01','389',492410.80,492410.80,'389','2022-07-09 18:56:50','797','2022-07-10 06:54:14',10,0),('5','95',257477,'DAILY SHIFT','2022-07-10','2022-07-10 07:16:51','2022-07-11 07:16:51','389',465428.55,465428.55,'389','2022-07-10 19:21:43','797','2022-07-11 07:39:42',10,0),('5','95',257478,'DAILY SHIFT','2022-07-11','2022-07-11 07:51:44','2022-07-12 07:51:44','389',544221.90,544221.90,'389','2022-07-11 19:59:18','797','2022-07-12 08:41:53',10,0),('5','95',257479,'DAILY SHIFT','2022-07-12','2022-07-12 11:38:55','2022-07-13 11:38:55','389',490238.90,490238.90,'389','2022-07-12 20:43:25','797','2022-07-13 06:51:58',10,0),('5','95',257480,'DAILY SHIFT','2022-07-13','2022-07-13 07:03:00','2022-07-14 07:03:00','389',379227.80,379227.80,'389','2022-07-13 21:06:24','797','2022-07-14 06:25:49',10,0),('5','95',257481,'DAILY SHIFT','2022-07-14','2022-07-14 09:06:09','2022-07-15 09:06:09','389',410638.95,410638.95,'389','2022-07-15 07:54:56','797','2022-07-15 07:57:20',10,0),('5','95',257482,'DAILY SHIFT','2022-07-15','2022-07-15 08:42:05','2022-07-16 08:42:05','389',501827.30,501827.30,'389','2022-07-15 21:20:04','797','2022-07-16 05:46:11',10,0),('5','95',257483,'DAILY SHIFT','2022-07-16','2022-07-16 06:51:30','2022-07-17 06:51:30','389',427039.20,427039.20,'389','2022-07-16 19:40:55','797','2022-07-17 06:04:46',10,0),('5','95',257484,'DAILY SHIFT','2022-07-17','2022-07-17 07:42:02','2022-07-18 07:42:02','389',600532.20,600532.20,'389','2022-07-17 20:23:11','797','2022-07-18 07:33:43',10,0),('5','95',257485,'DAILY SHIFT','2022-07-18','2022-07-18 08:16:57','2022-07-19 08:16:57','389',437610.10,437610.10,'389','2022-07-18 21:26:28','797','2022-07-19 05:51:19',10,0),('5','95',257486,'DAILY SHIFT','2022-07-19','2022-07-19 08:04:44','2022-07-20 08:04:44','389',534139.40,534139.40,'389','2022-07-19 19:28:35','797','2022-07-20 06:44:38',10,0),('5','95',257487,'DAILY SHIFT','2022-07-20','2022-07-20 08:49:43','2022-07-21 08:49:43','389',803342.15,803342.15,'389','2022-07-20 18:47:13','797','2022-07-21 07:45:48',10,0),('5','95',257488,'DAILY SHIFT','2022-07-21','2022-07-21 08:53:41','2022-07-22 08:53:41','389',469234.00,469234.00,'389','2022-07-21 20:20:37','797','2022-07-21 23:21:59',10,0),('5','95',257489,'DAILY SHIFT','2022-07-22','2022-07-22 08:57:00','2022-07-23 08:57:00','389',796006.90,796006.90,'389','2022-07-22 19:34:01','797','2022-07-23 07:30:08',10,0),('5','95',257490,'DAILY SHIFT','2022-07-23','2022-07-23 08:44:50','2022-07-24 08:44:50','389',871943.85,871943.85,'389','2022-07-24 07:22:05','797','2022-07-24 09:27:43',10,0),('5','95',257491,'DAILY SHIFT','2022-07-24','2022-07-24 09:31:19','2022-07-25 09:31:19','389',1053031.10,1053031.10,'389','2022-07-24 19:33:01','797','2022-07-25 06:42:15',10,0),('5','95',257492,'DAILY SHIFT','2022-07-25','2022-07-25 11:16:39','2022-07-26 11:16:39','389',946365.65,946365.65,'389','2022-07-25 20:59:53','797','2022-07-26 07:42:01',10,0),('5','95',257493,'DAILY SHIFT','2022-07-26','2022-07-26 07:47:08','2022-07-27 07:47:08','389',407786.25,407786.25,'389','2022-07-26 19:20:02','797','2022-07-27 06:57:19',10,0),('5','95',257494,'DAILY SHIFT ','2022-07-27','2022-07-27 07:02:06','2022-07-28 07:02:06','389',0.00,0.00,'389','2022-07-27 17:49:00','797','2022-07-28 08:58:18',10,0),('5','95',257495,'DAILY SHIFT','2022-07-28','2022-07-28 09:23:47','2022-07-29 09:23:47','389',0.00,0.00,'389','2022-07-28 18:02:51','797','2022-07-29 06:57:45',10,0),('5','95',257496,'DAILY SHIFT','2022-07-29','2022-07-29 08:59:59','2022-07-30 08:59:59','389',0.00,0.00,'389','2022-07-29 18:56:29','797','2022-07-30 07:01:02',10,0),('5','95',257497,'DAILY SHIFT','2022-07-30','2022-07-30 08:12:54','2022-07-31 08:12:54','389',0.00,0.00,'389','2022-07-31 05:56:30','797','2022-07-31 05:59:03',10,0),('5','95',257498,'DAILY SHIFT','2022-07-31','2022-07-31 10:23:30','2022-08-01 10:23:30','389',0.00,0.00,'389','2022-07-31 18:51:13','797','2022-08-01 06:49:08',10,0),('5','95',257499,'DAILY SHIFT','2022-08-01','2022-08-01 08:16:05','2022-08-02 08:16:05','389',0.00,0.00,'389','2022-08-01 18:53:39','797','2022-08-02 07:35:24',10,0),('5','95',257500,'DAILY SHIFT','2022-08-02','2022-08-02 08:19:19','2022-08-03 08:19:19','389',0.00,0.00,'389','2022-08-02 18:07:24','797','2022-08-03 06:36:37',10,0),('5','95',257501,'DAILY SHIFT','2022-08-03','2022-08-03 08:36:20','2022-08-04 08:36:20','389',0.00,0.00,'389','2022-08-03 18:50:31','797','2022-08-04 06:50:56',10,0),('5','95',257502,'DAILY SHIFT','2022-08-04','2022-08-04 09:15:55','2022-08-05 09:15:55','389',0.00,0.00,'389','2022-08-04 19:42:38','797','2022-08-05 06:37:47',10,0),('5','95',257503,'DAILY SHIFT','2022-08-05','2022-08-05 09:36:36','2022-08-06 09:36:36','389',0.00,0.00,'389','2022-08-05 17:50:19','797','2022-08-06 09:11:29',10,0),('5','95',257504,'DAILY SHIFT','2022-08-06','2022-08-06 09:12:46','2022-08-07 09:12:46','389',0.00,0.00,'389','2022-08-06 19:07:06','797','2022-08-07 07:13:07',10,0),('5','95',257505,'DAILY SHIFT','2022-08-07','2022-08-07 08:24:28','2022-08-08 08:24:28','389',0.00,0.00,'389','2022-08-07 20:50:11','797','2022-09-03 08:16:50',10,0),('5','95',257506,'DAILY SHIFT ','2022-08-08','2022-09-03 12:55:00','2022-09-04 12:55:00','389',0.00,0.00,'389','2022-09-03 18:02:34','797','2022-09-04 15:23:05',10,0),('5','95',257507,'DAILY SHIFT ','2022-08-09','2022-09-04 15:33:00','2022-09-05 15:33:00','389',489040.10,489040.10,'389','2022-09-05 14:58:11','797','2022-09-05 15:09:59',10,0),('5','95',257508,'DAILY SHIFT','2022-08-10','2022-09-05 15:14:30','2022-09-06 15:14:30','389',601044.65,601044.65,'389','2022-09-05 15:16:23','797','2022-09-05 15:17:50',10,0),('5','95',257509,'DAILY SHIFT','2022-08-11','2022-09-05 15:24:23','2022-09-06 15:24:23','389',590973.25,590973.25,'389','2022-09-05 15:26:03','797','2022-09-05 15:27:07',10,0),('5','95',257510,'DAILY SHIFT','2022-08-12','2022-09-05 15:37:13','2022-09-06 15:37:13','389',599085.50,599085.50,'389','2022-09-05 15:40:30','797','2022-09-05 16:08:28',10,0),('5','95',257511,'DAILY SHIFT','2022-08-13','2022-09-05 16:33:12','2022-09-06 16:33:12','389',489839.30,489839.30,'389','2022-09-05 17:15:12','797','2022-09-06 10:28:14',10,0),('5','95',257512,'DAILY SHIFT','2022-08-14','2022-09-06 10:57:52','2022-09-07 10:57:52','389',0.00,0.00,'389','2022-09-06 10:59:22','797','2022-09-06 11:03:39',10,0),('5','95',257513,'DAILY SHIFT ','2022-08-15','2022-09-06 14:40:28','2022-09-07 14:40:28','389',0.00,0.00,'389','2022-09-06 14:40:56','797','2022-09-06 15:22:51',10,0),('5','95',257514,'DAILY SHIFT ','2022-08-16','2022-09-06 16:11:34','2022-09-07 16:11:34','389',486192.95,486192.95,'389','2022-09-06 16:48:59','797','2022-09-06 17:30:01',10,0),('5','95',257515,'DAILY SHIFT','2022-08-17','2022-09-06 17:43:40','2022-09-07 17:43:40','389',540140.80,540140.80,'389','2022-09-06 17:45:32','797','2022-09-06 18:53:46',10,0),('5','95',257516,'DAILY SHIFT ','2022-08-18','2022-09-06 19:01:30','2022-09-07 19:01:30','389',653068.50,653068.50,'389','2022-09-06 19:42:10','797','2022-09-07 09:42:28',10,0),('5','95',257517,'DAILY SHIFT ','2022-08-19','2022-09-07 09:54:57','2022-09-08 09:54:57','389',573648.00,573648.00,'389','2022-09-07 09:58:12','797','2022-09-07 10:02:24',10,0),('5','95',257518,'DAILY SHIFT ','2022-08-20','2022-09-07 10:03:15','2022-09-08 10:03:15','389',513589.60,513589.60,'389','2022-09-07 10:05:11','797','2022-09-07 10:09:29',10,0),('5','95',257519,'DAILY SHIFT','2022-08-21','2022-09-07 10:15:05','2022-09-08 10:15:05','389',517679.95,517679.95,'389','2022-09-07 10:20:43','797','2022-09-07 10:22:51',10,0),('5','95',257520,'DAILY SHIFT ','2022-08-22','2022-09-07 10:23:45','2022-09-08 10:23:45','389',488416.65,488416.65,'389','2022-09-07 10:24:58','797','2022-09-07 10:27:10',10,0),('5','95',257521,'DAILY SHIFT','2022-08-23','2022-09-07 10:28:27','2022-09-08 10:28:27','389',571620.40,571620.40,'389','2022-09-07 10:30:11','797','2022-09-07 10:33:03',10,0),('5','95',257522,'DAILY SHIFT','2022-08-24','2022-09-07 10:34:22','2022-09-08 10:34:22','389',572595.35,572595.35,'389','2022-09-07 10:35:52','797','2022-09-07 10:37:29',10,0),('5','95',257523,'DAILY SHIFT','2022-08-25','2022-09-07 10:39:59','2022-09-08 10:39:59','389',452510.00,452510.00,'389','2022-09-07 13:33:14','797','2022-09-07 13:35:08',10,0),('5','95',257524,'DAILY SHIFT ','2022-08-26','2022-09-07 13:36:41','2022-09-08 13:36:41','389',600064.15,600064.15,'389','2022-09-07 13:38:59','797','2022-09-07 13:42:57',10,0),('5','95',257525,'DAILY SHIFT ','2022-08-27','2022-09-07 13:44:18','2022-09-08 13:44:18','389',609121.75,609121.75,'389','2022-09-07 13:47:27','797','2022-09-07 13:50:47',10,0),('5','95',257526,'DAILY SHIFT ','2022-08-28','2022-09-07 13:54:20','2022-09-08 13:54:20','389',534054.30,534054.30,'389','2022-09-07 13:56:29','797','2022-09-07 13:59:27',10,0),('5','95',257527,'DAILY SHIFT ','2022-08-29','2022-09-07 14:01:56','2022-09-08 14:01:56','389',439036.45,439036.45,'389','2022-09-07 14:04:34','797','2022-09-07 14:08:13',10,0),('5','95',257528,'DAILY SHIFT ','2022-08-30','2022-09-07 14:09:38','2022-09-08 14:09:38','389',660686.80,660686.80,'389','2022-09-07 14:11:47','797','2022-09-07 14:14:37',10,0),('5','95',257529,'DAILY SHIFT ','2022-08-31','2022-09-07 14:15:53','2022-09-08 14:15:53','389',673128.05,673128.05,'389','2022-09-07 14:17:42','797','2022-09-07 14:21:19',10,0),('5','95',257530,'DAILY SHIFT ','2022-09-01','2022-09-07 14:22:01','2022-09-08 14:22:01','389',656022.95,656022.95,'389','2022-09-07 14:24:28','797','2022-09-07 14:25:18',10,0),('5','95',257531,'DAILY SHIFT ','2022-09-02','2022-09-07 14:26:31','2022-09-08 14:26:31','389',707510.30,707510.30,'389','2022-09-07 14:28:30','797','2022-09-07 14:29:28',10,0),('5','95',257532,'DAILY SHIFT ','2022-09-03','2022-09-07 14:30:17','2022-09-08 14:30:17','389',850043.55,850043.55,'389','2022-09-07 14:32:03','797','2022-09-07 14:32:39',10,0),('5','95',257533,'DAILY SHIFT ','2022-09-04','2022-09-07 14:33:43','2022-09-08 14:33:43','389',908925.35,908925.35,'389','2022-09-07 14:36:02','797','2022-09-07 14:37:28',10,0),('5','95',257534,'DAILY SHIFT ','2022-09-05','2022-09-07 14:39:43','2022-09-08 14:39:43','389',885450.70,885450.70,'389','2022-09-07 14:46:16','797','2022-09-07 14:47:22',10,0),('5','95',257535,'DAILY SHIFT ','2022-09-06','2022-09-07 14:49:01','2022-09-08 14:49:01','389',647968.05,647968.05,'389','2022-09-07 14:50:32','797','2022-09-07 14:51:13',10,0),('5','95',257536,'DAILY SHIFT','2022-09-07','2022-09-07 14:59:03','2022-09-08 14:59:03','389',556278.35,556278.35,'389','2022-09-07 19:50:28','797','2022-09-08 09:04:02',10,0),('5','95',257537,'DAILY SHIFT','2022-09-08','2022-09-08 12:04:49','2022-09-09 12:04:49','389',621766.50,621766.50,'389','2022-09-09 05:53:44','797','2022-09-09 07:15:55',10,0),('5','95',257538,'DAILY SHIFT ','2022-09-09','2022-09-09 08:28:56','2022-09-10 08:28:56','389',545907.25,545907.25,'389','2022-09-10 07:02:12','797','2022-09-10 10:17:37',10,0),('5','95',257539,'DAILY SHIFT ','2022-09-10','2022-09-10 11:28:50','2022-09-11 11:28:50','389',501488.75,501488.75,'389','2022-09-10 20:36:26','797','2022-09-11 11:05:05',10,0),('5','95',257540,'DAILY SHIFT ','2022-09-11','2022-09-11 13:12:40','2022-09-12 13:12:40','389',414734.85,414734.85,'389','2022-09-12 05:38:52','797','2022-09-12 06:27:39',10,0),('5','95',257541,'DAILY SHIFT','2022-09-12','2022-09-12 08:44:34','2022-09-13 08:44:34','389',0.00,0.00,'389','2022-09-13 02:37:42','797','2022-09-13 07:00:18',10,0),('5','95',257542,'DAILY SHIFT','2022-09-13','2022-09-13 09:38:19','2022-09-14 09:38:19','389',129024.55,129024.55,'389','2022-09-13 23:06:51','797','2022-09-14 09:16:39',10,0),('5','95',257543,'DAILY SHIFT','2022-09-14','2022-09-14 10:07:41','2022-09-15 10:07:41','389',0.00,0.00,'389','2022-09-14 20:10:12','797','2022-09-14 21:55:05',10,0),('5','95',257544,'DAILY SHIFT ','2022-09-15','2022-09-15 15:47:10','2022-09-16 15:47:10','389',0.00,0.00,'389','2022-09-15 20:07:32','797','2022-09-16 09:35:13',10,0),('5','95',257545,'DAILY SHIFT','2022-09-16','2022-09-16 10:08:07','2022-09-17 10:08:07','389',0.00,0.00,'389','2022-09-16 20:13:06','797','2022-09-17 07:56:10',10,0),('5','95',257546,'DAILY SHIFT ','2022-09-17','2022-09-17 09:12:26','2022-09-18 09:12:26','389',0.00,0.00,'389','2022-09-17 20:35:11','797','2022-09-18 10:38:49',10,0),('5','95',257547,'DAILY SHIFT 1','2022-09-18','2022-09-18 10:48:01','2022-09-19 10:48:01','389',0.00,0.00,'389','2022-09-18 18:37:54','797','2022-09-19 10:44:07',10,0),('5','95',257548,'DAILY SHIFT ','2022-09-19','2022-09-19 17:28:38','2022-09-20 17:28:38','389',0.00,0.00,'389','2022-09-20 05:04:31','797','2022-09-20 08:59:48',10,0),('5','95',257549,'DAILY SHIFT ','2022-09-20','2022-09-20 09:43:46','2022-09-21 09:43:46','389',0.00,0.00,'389','2022-09-20 19:27:08','797','2022-09-21 07:08:48',10,0),('5','95',257550,'DAILY SHIFT ','2022-09-21','2022-09-21 10:44:25','2022-09-22 10:44:25','389',485066.30,485066.30,'389','2022-09-22 06:36:55','797','2022-09-22 09:15:57',10,0),('5','95',257551,'DAILY SHIFT ','2022-09-22','2022-09-22 09:25:36','2022-09-23 09:25:36','389',679845.40,679845.40,'389','2022-09-22 21:16:00','797','2022-09-23 10:19:08',10,0),('5','95',257552,'DAILY SHIFT ','2022-09-23','2022-09-23 13:12:46','2022-09-24 13:12:46','389',764999.05,764999.05,'389','2022-09-23 19:37:32','797','2022-09-24 08:50:47',10,0),('5','95',257553,'DAILY SHIFT ','2022-09-24','2022-09-24 10:18:29','2022-09-25 10:18:29','389',744044.10,744044.10,'389','2022-09-24 20:16:56','797','2022-09-25 07:05:02',10,0),('5','95',257554,'DAILY SHIFT ','2022-09-25','2022-09-25 08:08:53','2022-09-26 08:08:53','389',823638.50,823638.50,'389','2022-09-25 21:44:21','797','2022-09-26 10:05:14',10,0),('5','95',257555,'DAILY SHIFT ','2022-09-26','2022-09-26 13:52:19','2022-09-27 13:52:19','389',858566.50,858566.50,'389','2022-09-26 19:02:49','797','2022-09-27 08:09:39',10,0),('5','95',257556,'DAILY SHIFT ','2022-09-27','2022-09-27 08:38:28','2022-09-28 08:38:28','389',628060.20,628060.20,'389','2022-09-27 19:22:21','797','2022-09-28 06:40:31',10,0),('5','95',257557,'DAILY SHIFT ','2022-09-28','2022-09-28 08:54:01','2022-09-29 08:54:01','389',617315.40,617315.40,'389','2022-09-28 19:28:26','797','2022-09-29 07:13:09',10,0),('5','95',257558,'DAILY SHIFT ','2022-09-29','2022-09-29 09:05:47','2022-09-30 09:05:47','389',622060.65,622060.65,'389','2022-09-29 19:51:33','797','2022-09-30 07:22:40',10,0),('5','95',257559,'DAILY SHIFT ','2022-09-30','2022-09-30 07:36:06','2022-10-01 07:36:06','389',793265.20,793265.20,'389','2022-09-30 20:01:01','797','2022-10-01 07:32:49',10,0),('5','95',257560,'DAILY SHIFT ','2022-10-01','2022-10-01 10:19:11','2022-10-02 10:19:11','389',257255.45,257255.45,'389','2022-10-01 20:27:36','797','2022-10-02 06:57:32',10,0),('5','95',257561,'DAILY SHIFT ','2022-10-02','2022-10-02 08:52:28','2022-10-03 08:52:28','389',695925.60,695925.60,'389','2022-10-03 08:25:25','797','2022-10-03 09:46:42',10,0),('5','95',257562,'DAILY SHIFT','2022-10-03','2022-10-03 12:49:23','2022-10-04 12:49:23','389',850733.60,850733.60,'389','2022-10-04 07:30:08','797','2022-10-04 16:11:24',10,0),('5','95',257563,'DAILY SHIFT ','2022-10-04','2022-10-04 16:29:26','2022-10-05 16:29:26','389',1042280.75,1042280.75,'389','2022-10-04 20:52:06','797','2022-10-05 10:04:48',10,0),('5','95',257564,'DAILY SHIFT ','2022-10-05','2022-10-05 13:02:09','2022-10-06 13:02:09','389',1067442.60,1067442.60,'389','2022-10-05 20:46:01','797','2022-10-06 06:57:39',10,0),('5','95',257565,'DAILY SHIFT ','2022-10-06','2022-10-06 08:55:54','2022-10-07 08:55:54','389',1024674.30,1024674.30,'389','2022-10-07 04:21:16','797','2022-10-07 06:57:08',10,0),('5','95',257566,'DAILY SHIFT ','2022-10-07','2022-10-07 08:54:07','2022-10-08 08:54:07','389',750282.30,750282.30,'389','2022-10-07 23:06:25','797','2022-10-08 11:35:16',10,0),('5','95',257567,'DAILY SHIFT ','2022-10-08','2022-10-08 15:09:16','2022-10-09 15:09:16','389',933826.35,933826.35,'389','2022-10-08 22:58:34','797','2022-10-09 07:01:08',10,0),('5','95',257568,'DAILY SHIFT ','2022-10-09','2022-10-09 09:18:19','2022-10-10 09:18:19','389',773544.20,773544.20,'389','2022-10-09 21:49:53','797','2022-10-10 08:57:55',10,0),('5','95',257569,'DAILY SHIFT ','2022-10-10','2022-10-10 15:55:41','2022-10-11 15:55:41','389',429891.90,429891.90,'389','2022-10-10 21:05:04','797','2022-10-11 12:14:11',10,0),('5','95',257570,'DAILY SHIFT ','2022-10-11','2022-10-11 13:22:01','2022-10-12 13:22:01','389',247652.10,247652.10,'389','2022-10-11 19:41:46','797','2022-10-12 12:30:19',10,0),('5','95',257571,'DAILY SHIFT ','2022-10-12','2022-10-12 16:52:59','2022-10-13 16:52:59','389',289482.45,289482.45,'389','2022-10-12 23:48:35','797','2022-10-13 04:23:09',10,0),('5','95',257572,'DAILY SHIFT ','2022-10-13','2022-10-13 10:07:12','2022-10-14 10:07:12','389',219126.95,219126.95,'389','2022-10-13 19:22:37','797','2022-10-14 10:20:27',10,0),('5','95',257573,'DAILY SHIFT ','2022-10-14','2022-10-14 10:43:07','2022-10-15 10:43:07','389',0.00,0.00,'389','2022-10-14 20:46:40','797','2022-10-15 14:08:56',10,0),('5','95',257574,'DAILY SHIFT ','2022-10-15','2022-10-15 16:49:07','2022-10-16 16:49:07','389',0.00,0.00,'389','2022-10-15 19:27:06','797','2022-10-16 07:00:30',10,0),('5','95',257575,'DAILY SHIFT ','2022-10-16','2022-10-16 16:47:06','2022-10-17 16:47:06','389',0.00,0.00,'389','2022-10-16 20:46:03','797','2022-10-17 20:08:26',10,0),('5','95',257576,'DAILY SHIFT ','2022-10-17','2022-10-17 20:24:15','2022-10-18 20:24:15','389',0.00,0.00,'389','2022-10-18 05:07:59','797','2022-10-18 09:37:20',10,0),('5','95',257577,'DAILY SHIFT','2022-10-18','2022-10-18 12:08:13','2022-10-19 12:08:13','389',0.00,0.00,'389','2022-10-18 19:53:28','797','2022-10-19 09:45:24',10,0),('5','95',257578,'DAILY SHIFT ','2022-10-19','2022-10-19 18:08:01','2022-10-20 18:08:01','389',0.00,0.00,'389','2022-10-19 21:49:23','797','2022-10-20 08:58:26',10,0),('5','95',257579,'DAILY SHIFT ','2022-10-20','2022-10-20 20:09:25','2022-10-21 20:09:25','389',0.00,0.00,'389','2022-10-21 06:52:03','797','2022-10-21 09:32:31',10,0),('5','95',257580,'DAILY SHIFT ','2022-10-21','2022-10-21 12:06:35','2022-10-22 12:06:35','389',0.00,0.00,'389','2022-10-21 20:12:58','797','2022-10-22 10:04:31',10,0),('5','95',257581,'DAILY SHIFT ','2022-10-22','2022-10-22 20:19:09','2022-10-23 20:19:09','389',0.00,0.00,'389','2022-10-23 00:22:22','797','2022-10-23 07:41:04',10,0),('5','95',257582,'DAILY SHIFT ','2022-10-23','2022-10-23 09:21:04','2022-10-24 09:21:04','389',0.00,0.00,'389','2022-10-23 22:46:23','797','2022-10-24 07:31:25',10,0),('5','95',257583,'DAILY SHIFT ','2022-10-24','2022-10-24 09:28:03','2022-10-25 09:28:03','389',0.00,0.00,'389','2022-10-24 21:07:29','797','2022-10-25 09:24:41',10,0),('5','95',257584,'DAILY SHIFT ','2022-10-25','2022-10-25 09:31:49','2022-10-26 09:31:49','389',0.00,0.00,'389','2022-10-26 01:06:08','797','2022-10-26 06:12:46',10,0),('5','95',257585,'DAILY SHIFT','2022-10-26','2022-10-26 10:25:46','2022-10-27 10:25:46','389',0.00,0.00,'389','2022-10-26 22:39:20','797','2022-10-27 07:02:08',10,0),('5','95',257586,'DAILY SHIFT','2022-10-27','2022-10-27 09:52:58','2022-10-28 09:52:58','389',0.00,0.00,'389','2022-10-27 23:38:40','797','2022-10-28 06:54:42',10,0),('5','95',257587,'DAILY SHIFT ','2022-10-28','2022-10-28 09:02:59','2022-10-29 09:02:59','389',0.00,0.00,'389','2022-10-28 22:56:26','797','2022-10-29 08:37:38',10,0),('5','95',257588,'DAILY SHIFT ','2022-10-29','2022-10-29 10:05:49','2022-10-30 10:05:49','389',0.00,0.00,'389','2022-10-29 22:58:41','797','2022-10-30 06:55:31',10,0),('5','95',257589,'DAILY SHIFT ','2022-10-30','2022-10-30 09:56:08','2022-10-31 09:56:08','389',0.00,0.00,'389','2022-10-30 21:54:46','797','2022-10-31 07:02:23',10,0),('5','95',257590,'DAILY SHIFT ','2022-10-31','2022-10-31 10:26:11','2022-11-01 10:26:11','389',1282786.30,1282786.30,'389','2022-11-01 06:34:09','797','2022-11-01 06:59:10',10,0),('5','95',257591,'DAILY SHIFT ','2022-11-01','2022-11-01 08:58:25','2022-11-02 08:58:25','389',1366711.55,1366711.55,'389','2022-11-01 20:51:56','797','2022-11-02 07:06:49',10,0),('5','95',257592,'DAILY SHIFT ','2022-11-02','2022-11-02 08:21:52','2022-11-03 08:21:52','389',1557276.35,1557276.35,'389','2022-11-02 19:22:29','797','2022-11-03 06:33:36',10,0),('5','95',257593,'DAILY SHIFT ','2022-11-03','2022-11-03 11:16:17','2022-11-04 11:16:17','389',1758554.50,1758554.50,'389','2022-11-03 22:40:33','797','2022-11-04 07:02:15',10,0),('5','95',257594,'DAILY SHIFT ','2022-11-04','2022-11-04 09:20:08','2022-11-05 09:20:08','389',1426285.25,1426285.25,'389','2022-11-04 20:29:52','797','2022-11-05 07:25:05',10,0),('5','95',257595,'DAILY SHIFT ','2022-11-05','2022-11-05 12:58:05','2022-11-06 12:58:05','389',1498753.45,1498753.45,'389','2022-11-05 20:55:35','797','2022-11-06 08:16:56',10,0),('5','95',257596,'DAILY SHIFT ','2022-11-06','2022-11-06 10:19:53','2022-11-07 10:19:53','389',1277992.95,1277992.95,'389','2022-11-07 06:41:37','797','2022-11-07 14:41:18',10,0),('5','95',257597,'DAILY SHIFT ','2022-11-07','2022-11-07 15:02:04','2022-11-08 15:02:04','389',1513037.30,1513037.30,'389','2022-11-08 06:43:42','797','2022-11-08 07:47:19',10,0),('5','95',257598,'DAILY SHIFT ','2022-11-08','2022-11-08 10:25:34','2022-11-09 10:25:34','389',896143.70,896143.70,'389','2022-11-08 19:32:40','797','2022-11-09 08:36:41',10,0),('5','95',257599,'DAILY SHIFT ','2022-11-09','2022-11-09 08:59:37','2022-11-10 08:59:37','389',1022454.30,1022454.30,'389','2022-11-09 20:28:05','797','2022-11-10 10:44:20',10,0),('5','95',257600,'DAILY SHIFT ','2022-11-10','2022-11-10 12:25:38','2022-11-11 12:25:38','389',823679.20,823679.20,'389','2022-11-11 02:40:25','797','2022-11-11 11:27:20',10,0),('5','95',257601,'DAILY SHIFT ','2022-11-11','2022-11-11 11:32:45','2022-11-12 11:32:45','389',619352.25,619352.25,'389','2022-11-11 21:00:48','797','2022-11-12 10:02:41',10,0),('5','95',257602,'DAILY SHIFT ','2022-11-12','2022-11-12 16:34:07','2022-11-13 16:34:07','389',0.00,0.00,'389','2022-11-13 04:25:29','797','2022-11-13 15:35:33',10,0),('5','95',257603,'DAILY SHIFT ','2022-11-13','2022-11-13 18:14:01','2022-11-14 18:14:01','389',0.00,0.00,'389','2022-11-13 23:35:00','797','2022-11-14 07:22:26',10,0),('5','95',257604,'DAILY SHIFT ','2022-11-14','2022-11-14 12:55:49','2022-11-15 12:55:49','389',0.00,0.00,'389','2022-11-14 20:17:58','797','2022-11-14 23:43:21',10,0),('5','95',257605,'DAILY SHIFT ','2022-11-15','2022-11-15 09:57:16','2022-11-16 09:57:16','389',0.00,0.00,'389','2022-11-15 20:00:01','797','2022-11-16 07:52:24',10,0),('5','95',257606,'DAILY SHIFT ','2022-11-16','2022-11-16 16:59:01','2022-11-17 16:59:01','389',0.00,0.00,'389','2022-11-17 06:35:28','797','2022-11-17 09:36:53',10,0),('5','95',257607,'DAILY SHIFT ','2022-11-17','2022-11-17 19:17:18','2022-11-18 19:17:18','389',0.00,0.00,'389','2022-11-18 04:06:23','797','2022-11-18 08:21:08',10,0),('5','95',257608,'DAILY SHIFT','2022-11-18','2022-11-18 09:03:57','2022-11-19 09:03:57','389',0.00,0.00,'389','2022-11-18 20:31:19','797','2022-11-19 09:16:36',10,0),('5','95',257609,'DAILY SHIFT ','2022-11-19','2022-11-19 17:52:01','2022-11-20 17:52:01','389',0.00,0.00,'389','2022-11-19 21:28:49','797','2022-11-20 07:29:16',10,0),('5','95',257610,'DAILY SHIFT ','2022-11-20','2022-11-20 09:15:34','2022-11-21 09:15:34','389',0.00,0.00,'389','2022-11-20 20:50:12','797','2022-11-21 09:35:59',10,0),('5','95',257611,'DAILY SHIFT ','2022-11-21','2022-11-21 10:34:36','2022-11-22 10:34:36','389',0.00,0.00,'389','2022-11-21 21:28:36','797','2022-11-22 09:02:50',10,0),('5','95',257612,'DAILY SHIFT','2022-11-22','2022-11-22 09:07:00','2022-11-23 09:07:00','389',0.00,0.00,'389','2022-11-22 19:38:19','797','2022-11-23 09:38:40',10,0),('5','95',257613,'DAILY SHIFT ','2022-11-23','2022-11-23 16:08:55','2022-11-24 16:08:55','389',0.00,0.00,'389','2022-11-23 21:04:30','797','2022-11-24 09:00:49',10,0),('5','95',257614,'DAILY SHIFT','2022-11-24','2022-11-24 09:20:41','2022-11-25 09:20:41','389',0.00,0.00,'389','2022-11-24 20:37:25','797','2022-11-25 11:13:25',10,0),('5','95',257615,'DAILY SHIFT ','2022-11-25','2022-11-25 19:19:42','2022-11-26 19:19:42','389',0.00,0.00,'389','2022-11-25 19:22:05','797','2022-11-26 07:45:51',10,0),('5','95',257616,'DAILY SHIFT','2022-11-26','2022-11-26 09:48:18','2022-11-27 09:48:18','389',0.00,0.00,'389','2022-11-26 21:37:43','797','2022-11-27 08:59:16',10,0),('5','95',257617,'DAILY SHIFT ','2022-11-27','2022-11-27 12:37:25','2022-11-28 12:37:25','389',0.00,0.00,'389','2022-11-27 20:33:31','797','2022-11-28 09:46:59',10,0),('5','95',257618,'DAILY SHIFT','2022-11-28','2022-11-28 10:38:46','2022-11-29 10:38:46','389',0.00,0.00,'389','2022-11-28 19:06:50','797','2022-11-29 09:44:57',10,0),('5','95',257619,'DAILY SHIFT','2022-11-29','2022-11-29 16:25:02','2022-11-30 16:25:02','389',0.00,0.00,'389','2022-11-29 20:58:35','797','2022-11-30 06:43:09',10,0),('5','95',257620,'DAILY SHIFT','2022-11-30','2022-11-30 09:20:13','2022-12-01 09:20:13','389',0.00,0.00,'389','2022-11-30 21:25:36','797','2022-12-01 10:43:36',10,0),('5','95',257621,'DAILY SHIFT','2022-12-01','2022-12-01 17:01:41','2022-12-02 17:01:41','389',0.00,0.00,'389','2022-12-01 20:15:07','797','2022-12-02 09:58:18',10,0),('5','95',257622,'DAILY SHIFT','2022-12-02','2022-12-02 10:05:35','2022-12-03 10:05:35','389',0.00,0.00,'389','2022-12-02 21:43:56','797','2022-12-03 10:11:18',10,0),('5','95',257623,'DAILY SHIFT ','2022-12-03','2022-12-03 12:56:33','2022-12-04 12:56:33','389',0.00,0.00,'389','2022-12-03 20:04:26','797','2022-12-04 09:47:39',10,0),('5','95',257624,'DAILY SHIFT','2022-12-04','2022-12-04 16:31:48','2022-12-05 16:31:48','389',0.00,0.00,'389','2022-12-04 20:53:48','797','2022-12-05 09:02:10',10,0),('5','95',257625,'DAILY SHIFT ','2022-12-05','2022-12-05 09:30:51','2022-12-06 09:30:51','389',0.00,0.00,'389','2022-12-05 20:01:40','797','2022-12-06 09:22:26',10,0),('5','95',257626,'DAILY SHIFT ','2022-12-06','2022-12-06 10:27:07','2022-12-07 10:27:07','389',0.00,0.00,'389','2022-12-06 21:50:59','797','2022-12-07 09:09:55',10,0),('5','95',257627,'DAILY SHIFT','2022-12-07','2022-12-07 09:11:19','2022-12-08 09:11:19','389',0.00,0.00,'389','2022-12-07 20:54:47','797','2022-12-08 09:25:55',10,0),('5','95',257628,'DAILY SHIFT','2022-12-08','2022-12-08 09:38:22','2022-12-09 09:38:22','389',0.00,0.00,'389','2022-12-08 20:50:48','797','2022-12-09 09:15:58',10,0),('5','95',257629,'DAILY SHIFT','2022-12-09','2022-12-09 09:59:18','2022-12-10 09:59:18','389',0.00,0.00,'389','2022-12-09 19:20:53','797','2022-12-10 08:51:52',10,0),('5','95',257630,'DAILY SHIFT ','2022-12-10','2022-12-10 09:24:10','2022-12-11 09:24:10','389',0.00,0.00,'389','2022-12-10 20:55:55','797','2022-12-11 12:26:07',10,0),('5','95',257631,'DAILY SHIFT','2022-12-11','2022-12-11 13:05:01','2022-12-12 13:05:01','389',0.00,0.00,'389','2022-12-11 22:21:43','797','2022-12-12 11:05:47',10,0),('5','95',257632,'DAILY SHIFT ','2022-12-12','2022-12-12 19:55:59','2022-12-13 19:55:59','389',0.00,0.00,'389','2022-12-12 22:08:06','797','2022-12-13 09:53:53',10,0),('5','95',257633,'DAILY SHIFT ','2022-12-13','2022-12-13 12:22:37','2022-12-14 12:22:37','389',0.00,0.00,'389','2022-12-13 20:14:47','797','2022-12-14 09:39:05',10,0),('5','95',257634,'DAILY SHIFT','2022-12-14','2022-12-14 16:48:33','2022-12-15 16:48:33','389',0.00,0.00,'389','2022-12-15 06:01:55','797','2022-12-15 09:50:35',10,0),('5','95',257635,'DAILY SHIFT ','2022-12-15','2022-12-15 10:51:00','2022-12-16 10:51:00','389',0.00,0.00,'389','2022-12-15 20:26:13','797','2022-12-16 09:59:33',10,0),('5','95',257636,'DAILY SHIFT','2022-12-16','2022-12-16 16:40:18','2022-12-17 16:40:18','389',0.00,0.00,'389','2022-12-16 21:30:50','797','2022-12-17 12:16:54',10,0),('5','95',257637,'DAILY SHIFT ','2022-12-17','2022-12-17 14:23:20','2022-12-18 14:23:20','389',0.00,0.00,'389','2022-12-17 19:56:49','797','2022-12-18 12:33:01',10,0),('5','95',257638,'DAILY SHIFT','2022-12-18','2022-12-18 18:27:30','2022-12-19 18:27:30','389',0.00,0.00,'389','2022-12-18 21:55:37','797','2022-12-19 08:57:37',10,0),('5','95',257639,'DAILY SHIFT','2022-12-19','2022-12-19 09:27:41','2022-12-20 09:27:41','389',0.00,0.00,'389','2022-12-19 19:18:16','797','2022-12-20 09:01:55',10,0),('5','95',257640,'DAILY SHIFT ','2022-12-20','2022-12-20 16:54:08','2022-12-21 16:54:08','389',0.00,0.00,'389','2022-12-20 22:05:56','797','2022-12-21 09:18:43',10,0),('5','95',257641,'DAILY SHIFT ','2022-12-21','2022-12-21 09:46:04','2022-12-22 09:46:04','389',0.00,0.00,'389','2022-12-21 22:37:00','797','2022-12-22 09:28:30',10,0),('5','95',257642,'DAILY SHIFT','2022-12-22','2022-12-22 09:52:02','2022-12-23 09:52:02','389',0.00,0.00,'389','2022-12-22 22:01:24','797','2022-12-23 10:46:44',10,0),('5','95',257643,'DAILY SHIFT ','2022-12-23','2022-12-23 11:11:57','2022-12-24 11:11:57','389',0.00,0.00,'389','2022-12-23 21:20:24','797','2022-12-24 19:16:06',10,0),('5','95',257644,'DAILY SHIFT','2022-12-24','2022-12-24 20:53:18','2022-12-25 20:53:18','389',0.00,0.00,'389','2022-12-24 22:33:46','797','2022-12-25 07:20:05',10,0),('5','95',257645,'DAILY SHIFT ','2022-12-25','2022-12-25 09:26:58','2022-12-26 09:26:58','389',0.00,0.00,'389','2022-12-25 22:55:04','797','2022-12-26 08:24:07',10,0),('5','95',257646,'DAILY SHIFT','2022-12-26','2022-12-26 14:05:37','2022-12-27 14:05:37','389',0.00,0.00,'389','2022-12-26 20:47:33','797','2022-12-27 10:48:29',10,0),('5','95',257647,'DAILY SHIFT ','2022-12-27','2022-12-27 10:51:35','2022-12-28 10:51:35','389',0.00,0.00,'389','2022-12-27 22:22:37','797','2022-12-28 09:14:10',10,0),('5','95',257648,'DAILY SHIFT','2022-12-28','2022-12-28 10:11:02','2022-12-29 10:11:02','389',0.00,0.00,'389','2022-12-28 20:04:10','797','2022-12-29 10:18:08',10,0),('5','95',257649,'DAILY SHIFT ','2022-12-29','2022-12-29 10:35:48','2022-12-30 10:35:48','389',0.00,0.00,'389','2022-12-29 20:05:25','797','2022-12-30 09:01:45',10,0),('5','95',257650,'DAILY SHIFT','2022-12-30','2022-12-30 09:26:20','2022-12-31 09:26:20','389',0.00,0.00,'389','2022-12-30 20:05:46','797','2022-12-31 07:06:28',10,0),('5','95',257651,'DAILY SHIFT ','2022-12-31','2022-12-31 10:49:23','2023-01-01 10:49:23','389',0.00,0.00,'389','2023-01-01 03:04:08','797','2023-01-01 08:52:56',10,0),('5','95',257652,'DAILY SHIFT','2023-01-01','2023-01-01 12:08:06','2023-01-02 12:08:06','389',0.00,0.00,'389','2023-01-01 20:51:16','797','2023-01-02 08:21:24',10,0),('5','95',257653,'DAILY SHIFT','2023-01-02','2023-01-02 10:45:44','2023-01-03 10:45:44','389',0.00,0.00,'389','2023-01-03 06:53:29','797','2023-01-03 10:34:18',10,0),('5','95',257654,'DAILY SHIFT ','2023-01-03','2023-01-03 13:46:06','2023-01-04 13:46:06','389',0.00,0.00,'389','2023-01-03 21:36:50','797','2023-01-04 11:25:04',10,0),('5','95',257655,'DAILY SHIFT','2023-01-04','2023-01-04 11:27:04','2023-01-05 11:27:04','389',0.00,0.00,'389','2023-01-04 20:52:30','797','2023-01-05 08:57:03',10,0),('5','95',257656,'DAILY SHIFT ','2023-01-05','2023-01-05 09:20:55','2023-01-06 09:20:55','389',0.00,0.00,'389','2023-01-05 20:58:07','797','2023-01-06 15:05:03',10,0),('5','95',257657,'DAILY SHIFT','2023-01-06','2023-01-06 20:14:40','2023-01-07 20:14:40','389',0.00,0.00,'389','2023-01-06 20:15:53','797','2023-01-07 05:46:29',10,0),('5','95',257658,'DAILY SHIFT ','2023-01-07','2023-01-07 17:59:05','2023-01-08 17:59:05','389',0.00,0.00,'389','2023-01-07 23:05:17','797','2023-01-08 09:37:10',10,0),('5','95',257659,'DAILY SHIFT','2023-01-08','2023-01-08 17:00:09','2023-01-09 17:00:09','389',0.00,0.00,'389','2023-01-08 21:01:06','797','2023-01-09 09:47:23',10,0),('5','95',257660,'DAILY SHIFT ','2023-01-09','2023-01-09 10:10:43','2023-01-10 10:10:43','389',0.00,0.00,'389','2023-01-09 19:51:25','797','2023-01-10 09:20:51',10,0),('5','95',257661,'DAILY SHIFT','2023-01-10','2023-01-10 18:34:36','2023-01-11 18:34:36','389',0.00,0.00,'389','2023-01-10 21:13:09','797','2023-01-11 09:44:27',10,0),('5','95',257662,'DAILY SHIFT ','2023-01-11','2023-01-11 10:22:06','2023-01-12 10:22:06','389',0.00,0.00,'389','2023-01-11 20:54:09','797','2023-01-12 09:32:17',10,0),('5','95',257663,'DAILY SHIFT','2023-01-12','2023-01-12 17:31:35','2023-01-13 17:31:35','389',0.00,0.00,'389','2023-01-12 20:40:11','797','2023-01-13 09:22:25',10,0),('5','95',257664,'DAILY SHIFT ','2023-01-13','2023-01-13 11:01:32','2023-01-14 11:01:32','389',0.00,0.00,'389','2023-01-13 20:03:11','797','2023-01-14 16:53:53',10,0),('5','95',257665,'DAILY SHIFT','2023-01-14','2023-01-14 18:18:26','2023-01-15 18:18:26','389',0.00,0.00,'389','2023-01-14 22:04:28','797','2023-01-15 07:56:50',10,0),('5','95',257666,'DAILY SHIFT ','2023-01-15','2023-01-15 10:15:26','2023-01-16 10:15:26','389',0.00,0.00,'389','2023-01-15 22:01:00','797','2023-01-16 10:13:13',10,0),('5','95',257667,'DAILY SHIFT','2023-01-16','2023-01-16 17:43:21','2023-01-17 17:43:21','389',0.00,0.00,'389','2023-01-16 23:07:25','797','2023-01-17 10:15:42',10,0),('5','95',257668,'DAILY SHIFT ','2023-01-17','2023-01-17 10:34:10','2023-01-18 10:34:10','389',0.00,0.00,'389','2023-01-18 05:35:49','797','2023-01-18 09:16:48',10,0),('5','95',257669,'DAILY SHIFT','2023-01-18','2023-01-18 11:50:22','2023-01-19 11:50:22','389',0.00,0.00,'389','2023-01-18 21:19:28','797','2023-01-19 09:20:30',10,0),('5','95',257670,'DAILY SHIFT ','2023-01-19','2023-01-19 12:34:24','2023-01-20 12:34:24','389',0.00,0.00,'389','2023-01-19 21:44:16','797','2023-01-20 09:26:57',10,0),('5','95',257671,'DAILY SHIFT','2023-01-20','2023-01-20 11:18:11','2023-01-21 11:18:11','389',0.00,0.00,'389','2023-01-20 20:08:11','797','2023-01-21 06:53:46',10,0),('5','95',257672,'DAILY SHIFT ','2023-01-21','2023-01-21 08:41:03','2023-01-22 08:41:03','389',0.00,0.00,'389','2023-01-21 21:22:38','797','2023-01-22 10:44:55',10,0),('5','95',257673,'DAILY SHIFT','2023-01-22','2023-01-22 11:20:24','2023-01-23 11:20:24','389',0.00,0.00,'389','2023-01-22 20:39:47','797','2023-01-23 09:08:07',10,0),('5','95',257674,'DAILY SHIFT ','2023-01-23','2023-01-23 10:10:02','2023-01-24 10:10:02','389',0.00,0.00,'389','2023-01-23 21:22:36','797','2023-01-24 07:23:06',10,0),('5','95',257675,'DAILY SHIFT','2023-01-24','2023-01-24 18:14:22','2023-01-25 18:14:22','389',0.00,0.00,'389','2023-01-24 21:09:47','797','2023-01-25 09:32:41',10,0),('5','95',257676,'DAILY SHIFT ','2023-01-25','2023-01-25 10:04:53','2023-01-26 10:04:53','389',0.00,0.00,'389','2023-01-25 21:03:06','797','2023-01-26 09:23:12',10,0),('5','95',257677,'DAILY SHIFT','2023-01-26','2023-01-26 10:39:27','2023-01-27 10:39:27','389',0.00,0.00,'389','2023-01-26 21:23:34','797','2023-01-27 09:45:15',10,0),('5','95',257678,'DAILY SHIFT ','2023-01-27','2023-01-27 11:16:12','2023-01-28 11:16:12','389',0.00,0.00,'389','2023-01-27 21:04:26','797','2023-01-28 09:46:35',10,0),('5','95',257679,'DAILY SHIFT','2023-01-28','2023-01-28 10:13:04','2023-01-29 10:13:04','389',0.00,0.00,'389','2023-01-28 21:57:51','797','2023-01-29 11:01:50',10,0),('5','95',257680,'DAILY SHIFT ','2023-01-29','2023-01-29 11:12:31','2023-01-30 11:12:31','389',0.00,0.00,'389','2023-01-29 20:15:42','797','2023-01-30 09:23:39',10,0),('5','95',257681,'DAILY SHIFT','2023-01-30','2023-01-30 12:27:14','2023-01-31 12:27:14','389',0.00,0.00,'389','2023-01-30 21:56:35','797','2023-01-31 09:09:23',10,0),('5','95',257682,'DAILY SHIFT ','2023-01-31','2023-01-31 09:34:44','2023-02-01 09:34:44','389',0.00,0.00,'389','2023-01-31 21:03:27','797','2023-02-01 13:54:32',10,0),('5','95',257683,'DAILY SHIFT','2023-02-01','2023-02-01 19:15:21','2023-02-02 19:15:21','389',0.00,0.00,'389','2023-02-01 20:29:07','797','2023-02-02 11:31:25',10,0),('5','95',257684,'DAILY SHIFT ','2023-02-02','2023-02-02 14:24:27','2023-02-03 14:24:27','389',0.00,0.00,'389','2023-02-02 20:12:20','797','2023-02-03 10:03:09',10,0),('5','95',257685,'DAILY SHIFT','2023-02-03','2023-02-03 18:46:28','2023-02-04 18:46:28','389',0.00,0.00,'389','2023-02-03 20:12:46','797','2023-02-04 13:20:49',10,0),('5','95',257686,'DAILY SHIFT ','2023-02-04','2023-02-04 13:38:27','2023-02-05 13:38:27','389',0.00,0.00,'389','2023-02-04 19:20:25','797','2023-02-05 11:52:00',10,0),('5','95',257687,'DAILY SHIFT','2023-02-05','2023-02-05 19:00:18','2023-02-06 19:00:18','389',0.00,0.00,'389','2023-02-05 21:22:34','797','2023-02-06 09:08:44',10,0),('5','95',257688,'DAILY SHIFT ','2023-02-06','2023-02-06 13:48:36','2023-02-07 13:48:36','389',0.00,0.00,'389','2023-02-07 06:59:42','797','2023-02-07 09:09:12',10,0),('5','95',257689,'DAILY SHIFT','2023-02-07','2023-02-07 16:43:17','2023-02-08 16:43:17','389',0.00,0.00,'389','2023-02-07 22:33:29','797','2023-02-08 09:25:25',10,0),('5','95',257690,'DAILY SHIFT ','2023-02-08','2023-02-08 09:50:28','2023-02-09 09:50:28','389',0.00,0.00,'389','2023-02-08 20:52:44','797','2023-02-09 09:25:16',10,0),('5','95',257691,'DAILY SHIFT','2023-02-09','2023-02-09 11:13:58','2023-02-10 11:13:58','389',0.00,0.00,'389','2023-02-09 21:19:56','797','2023-02-10 09:03:48',10,0),('5','95',257692,'DAILY SHIFT ','2023-02-10','2023-02-10 09:39:34','2023-02-11 09:39:34','389',0.00,0.00,'389','2023-02-10 21:33:57','797','2023-02-11 09:42:40',10,0),('5','95',257693,' DAILY SHIFT','2023-02-11','2023-02-11 09:56:30','2023-02-12 09:56:30','389',0.00,0.00,'389','2023-02-11 22:37:20','797','2023-02-12 07:37:55',10,0),('5','95',257694,'DAILY SHIFT ','2023-02-12','2023-02-12 10:13:46','2023-02-13 10:13:46','389',0.00,0.00,'389','2023-02-12 22:11:34','797','2023-02-13 09:14:21',10,0),('5','95',257695,'DAILY SHIFT','2023-02-13','2023-02-13 11:12:17','2023-02-14 11:12:17','389',0.00,0.00,'389','2023-02-13 23:34:10','797','2023-02-14 09:37:17',10,0),('5','95',257696,'DAILY SHIFT ','2023-02-14','2023-02-14 10:23:18','2023-02-15 10:23:18','389',0.00,0.00,'389','2023-02-14 21:30:12','797','2023-02-15 09:25:14',10,0),('5','95',257697,'DAILY SHIFT','2023-02-15','2023-02-15 10:39:07','2023-02-16 10:39:07','389',0.00,0.00,'389','2023-02-15 23:41:02','797','2023-02-16 08:46:20',10,0),('5','95',257698,'DAILY SHIFT','2023-02-16','2023-02-16 15:52:52','2023-02-17 15:52:52','389',0.00,0.00,'389','2023-02-17 07:53:57','797','2023-02-17 12:22:50',10,0),('5','95',257699,'DAILY SHIFT ','2023-02-17','2023-02-17 14:40:55','2023-02-18 14:40:55','389',0.00,0.00,'389','2023-02-17 21:15:02','797','2023-02-18 16:31:06',10,0),('5','95',257700,'DAILY SHIFT ','2023-02-18','2023-02-18 19:23:56','2023-02-19 19:23:56','389',0.00,0.00,'389','2023-02-18 20:36:55','797','2023-02-19 08:34:05',10,0),('5','95',257701,'DAILY SHIFT','2023-02-19','2023-02-19 15:44:06','2023-02-20 15:44:06','389',0.00,0.00,'389','2023-02-19 20:22:57','797','2023-02-20 09:19:52',10,0),('5','95',257702,'DAILY SHIFT ','2023-02-20','2023-02-20 11:43:09','2023-02-21 11:43:09','389',0.00,0.00,'389','2023-02-20 22:51:17','797','2023-02-21 08:53:30',10,0),('5','95',257703,'DAILY SHIFT ','2023-02-21','2023-02-21 16:10:37','2023-02-22 16:10:37','389',0.00,0.00,'389','2023-02-22 07:27:10','797','2023-02-22 09:50:46',10,0),('5','95',257704,'DAILY SHIFT ','2023-02-22','2023-02-22 15:16:06','2023-02-23 15:16:06','389',0.00,0.00,'389','2023-02-22 20:42:53','797','2023-02-23 07:00:41',10,0),('5','95',257705,'DAILY SHIFT ','2023-02-23','2023-02-23 13:56:36','2023-02-24 13:56:36','389',0.00,0.00,'389','2023-02-23 21:14:38','797','2023-02-24 18:53:28',10,0),('5','95',257706,'DAILY SHIFT','2023-02-24','2023-02-24 19:05:38','2023-02-25 19:05:38','389',0.00,0.00,'389','2023-02-24 22:15:43','797','2023-02-25 10:29:42',10,0),('5','95',257707,'DAILY SHIFT','2023-02-25','2023-02-25 16:48:18','2023-02-26 16:48:18','389',0.00,0.00,'389','2023-02-25 21:29:20','797','2023-02-26 11:13:34',10,0),('5','95',257708,'DAILY SHIFT','2023-02-26','2023-02-26 13:56:46','2023-02-27 13:56:46','389',0.00,0.00,'389','2023-02-26 22:58:24','797','2023-02-27 15:40:10',10,0),('5','95',257709,'DAILY SHIFT','2023-02-27','2023-02-27 23:04:38','2023-02-28 23:04:38','389',0.00,0.00,'389','2023-02-27 23:05:03','797','2023-02-28 10:22:46',10,0),('5','95',257710,'DAILY SHIFT','2023-02-28','2023-03-01 09:01:08','2023-03-02 09:01:08','389',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',3,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4904345 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','95','578','83239',1658210,'1632','219',139138.43,139138.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83239',1658211,'1633','219',188671.70,191432.85,2761.15,386561.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83239',1658212,'1634','219',166486.51,167967.07,1480.56,207278.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','83239',1658213,'1635','219',374884.85,374884.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','83239',1658214,'1636','219',2391378.38,2391378.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','83239',1658215,'1637','219',3780793.98,3782688.46,1894.48,265227.20,0.00,0.00,0.00,0.00,0.00),('5','95','581','83239',1658216,'1638','220',50132.83,50230.63,97.80,23472.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','83239',1658217,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83245',1658307,'1632','219',139138.43,139138.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83245',1658308,'1633','219',191432.85,193704.41,2271.56,318018.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','83245',1658309,'1634','219',167967.07,170933.74,2966.67,415333.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','83245',1658310,'1635','219',374884.85,374884.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','83245',1658311,'1636','219',2391378.38,2391378.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','83245',1658312,'1637','219',3782688.46,3784328.65,1640.19,229626.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','83245',1658313,'1638','220',50230.63,50939.40,708.77,170104.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','83245',1658314,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83249',1658396,'1632','219',139138.43,139138.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83249',1658397,'1633','219',193704.41,195844.79,2140.38,299653.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','83249',1658398,'1634','219',170933.74,173227.60,2293.86,321140.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','83249',1658399,'1635','219',374884.85,374884.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','83249',1658400,'1636','219',2391378.38,2391378.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','83249',1658401,'1637','219',3784328.65,3784818.46,489.81,68573.40,0.00,0.00,0.00,0.00,0.00),('5','95','581','83249',1658402,'1638','220',50939.40,51037.23,97.83,23479.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','83249',1658403,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83383',1660934,'1632','219',139138.43,140270.78,1132.35,158529.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83383',1660935,'1633','219',195844.79,197807.69,1962.90,274806.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','83383',1660936,'1634','219',173227.60,176187.40,2959.80,414372.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','83383',1660937,'1635','219',374884.85,374884.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','83383',1660938,'1636','219',2391378.38,2391378.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','83383',1660939,'1637','219',3784818.46,3785279.75,461.29,64580.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','83383',1660940,'1638','220',51037.23,51143.98,106.75,25620.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','83383',1660941,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102553',2035002,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102553',2035003,'1633','219',360194.82,360194.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102553',2035004,'1634','219',384574.76,384574.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','102553',2035005,'1635','219',542696.50,544275.47,1578.97,221055.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','102553',2035006,'1636','219',2556143.37,2557762.78,1619.41,226717.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','102553',2035007,'1637','219',3825397.38,3825992.10,594.72,83260.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','102553',2035008,'1638','220',100869.24,101040.33,171.09,38495.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','102553',2035009,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102554',2035010,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102554',2035011,'1633','219',360194.82,360687.75,492.93,69010.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','102554',2035012,'1634','219',384574.76,385479.71,904.95,126693.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','102554',2035013,'1635','219',544275.47,544622.67,347.20,48608.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','102554',2035014,'1636','219',2557762.78,2559059.60,1296.82,181554.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','102554',2035015,'1637','219',3825992.10,3826829.95,837.85,117299.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','102554',2035016,'1638','220',101040.33,101262.87,222.54,50071.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','102554',2035017,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102962',2043096,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102962',2043097,'1633','219',360687.75,362063.09,1375.34,192547.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','102962',2043098,'1634','219',385479.71,387797.13,2317.42,324438.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','102962',2043099,'1635','219',544622.67,544622.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','102962',2043100,'1636','219',2559059.60,2559059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','102962',2043101,'1637','219',3826829.95,3827660.88,830.93,116330.20,0.00,0.00,0.00,0.00,0.00),('5','95','581','102962',2043102,'1638','220',101262.87,101429.36,166.49,37460.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','102962',2043103,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102982',2043523,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102982',2043524,'1633','219',362063.09,362884.08,820.99,114938.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','102982',2043525,'1634','219',387797.13,388777.61,980.48,137267.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','102982',2043526,'1635','219',544622.67,544938.38,315.71,44199.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','102982',2043527,'1636','219',2559059.60,2559059.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','102982',2043528,'1637','219',3827660.88,3827821.85,160.97,22535.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','102982',2043529,'1638','220',101429.36,101577.11,147.75,33243.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','102982',2043530,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102987',2043568,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','102987',2043569,'1633','219',362884.08,364381.29,1497.21,209609.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','102987',2043570,'1634','219',388777.61,390780.31,2002.70,280378.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','102987',2043571,'1635','219',544938.38,545008.25,69.87,9781.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','102987',2043572,'1636','219',2559059.60,2559243.80,184.20,25788.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','102987',2043573,'1637','219',3827821.85,3827920.71,98.86,13840.40,0.00,0.00,0.00,0.00,0.00),('5','95','581','102987',2043574,'1638','220',101577.11,101745.52,168.41,37892.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','102987',2043575,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105333',2091262,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105333',2091263,'1633','219',364381.29,365236.53,855.24,119733.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105333',2091264,'1634','219',390780.31,391420.70,640.39,89654.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','105333',2091265,'1635','219',545008.25,545364.68,356.43,49900.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105333',2091266,'1636','219',2559243.80,2559725.00,481.20,67368.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105333',2091267,'1637','219',3827920.71,3827920.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105333',2091268,'1638','220',101745.52,101872.66,127.14,28606.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105333',2091269,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105603',2096410,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105603',2096411,'1633','219',365236.53,365831.32,594.79,83270.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105603',2096412,'1634','219',391420.70,391907.83,487.13,68198.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105603',2096413,'1635','219',545364.68,545364.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105603',2096414,'1636','219',2559725.00,2559725.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105603',2096415,'1637','219',3827920.71,3827920.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105603',2096416,'1638','220',101872.66,101872.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105603',2096417,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105608',2096493,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105608',2096494,'1633','219',365831.32,366807.11,975.79,136610.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105608',2096495,'1634','219',391907.83,392896.45,988.62,138406.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105608',2096496,'1635','219',545364.68,545562.39,197.71,27679.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','105608',2096497,'1636','219',2559725.00,2559842.64,117.64,16469.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','105608',2096498,'1637','219',3827920.71,3828110.10,189.39,26514.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','105608',2096499,'1638','220',101872.66,102000.24,127.58,28705.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105608',2096500,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105609',2096501,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105609',2096502,'1633','219',366807.11,367262.51,455.40,63756.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105609',2096503,'1634','219',392896.45,393129.78,233.33,32666.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105609',2096504,'1635','219',545562.39,545562.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105609',2096505,'1636','219',2559842.64,2559842.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105609',2096506,'1637','219',3828110.10,3828110.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105609',2096507,'1638','220',102000.24,102078.23,77.99,17547.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105609',2096508,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105612',2096577,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105612',2096578,'1633','219',367262.51,368214.45,951.94,133271.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105612',2096579,'1634','219',393129.78,394051.78,922.00,129080.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105612',2096580,'1635','219',545562.39,545562.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105612',2096581,'1636','219',2559842.64,2559842.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105612',2096582,'1637','219',3828110.10,3828755.50,645.40,90356.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105612',2096583,'1638','220',102078.23,102376.65,298.42,67144.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105612',2096584,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105615',2096661,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105615',2096662,'1633','219',368214.45,368837.69,623.24,87253.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105615',2096663,'1634','219',394051.78,394698.85,647.07,90589.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105615',2096664,'1635','219',545562.39,545562.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105615',2096665,'1636','219',2559842.64,2559842.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105615',2096666,'1637','219',3828755.50,3829146.99,391.49,54808.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','105615',2096667,'1638','220',102376.65,102482.35,105.70,23782.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105615',2096668,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105616',2096669,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105616',2096670,'1633','219',368837.69,370394.99,1557.30,218022.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105616',2096671,'1634','219',394698.85,395652.37,953.52,133492.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105616',2096672,'1635','219',545562.39,545963.83,401.44,56201.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','105616',2096673,'1636','219',2559842.64,2559842.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105616',2096674,'1637','219',3829146.99,3829449.65,302.66,42372.40,0.00,0.00,0.00,0.00,0.00),('5','95','581','105616',2096675,'1638','220',102482.35,102872.26,389.91,87729.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105616',2096676,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105620',2096736,'1632','219',170689.08,170689.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105620',2096737,'1633','219',370394.99,370394.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105620',2096738,'1634','219',395652.37,396318.63,666.26,93276.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','105620',2096739,'1635','219',545963.83,546196.56,232.73,32582.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105620',2096740,'1636','219',2559842.64,2559842.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105620',2096741,'1637','219',3829449.65,3829632.99,183.34,25667.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','105620',2096742,'1638','220',102872.26,102914.91,42.65,9596.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','105620',2096743,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105621',2096744,'1632','219',170689.08,170748.36,59.28,8299.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','105621',2096745,'1633','219',370394.99,371175.29,780.30,109242.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105621',2096746,'1634','219',396318.63,397386.82,1068.19,149546.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','105621',2096747,'1635','219',546196.56,546250.14,53.58,7501.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105621',2096748,'1636','219',2559842.64,2559843.35,0.71,99.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','105621',2096749,'1637','219',3829632.99,3829960.56,327.57,45859.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','105621',2096750,'1638','220',102914.91,103175.52,260.61,58637.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','105621',2096751,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105623',2096776,'1632','219',170748.36,170748.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105623',2096777,'1633','219',371175.29,371305.17,129.88,18183.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','105623',2096778,'1634','219',397386.82,397698.42,311.60,43624.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105623',2096779,'1635','219',546250.14,546250.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105623',2096780,'1636','219',2559843.35,2559935.45,92.10,12894.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105623',2096781,'1637','219',3829960.56,3829960.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105623',2096782,'1638','220',103175.52,103223.36,47.84,10764.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105623',2096783,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105637',2096985,'1632','219',170748.36,171118.15,369.79,51770.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105637',2096986,'1633','219',371305.17,372112.51,807.34,113027.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105637',2096987,'1634','219',397698.42,398366.11,667.69,93476.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','105637',2096988,'1635','219',546250.14,546250.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105637',2096989,'1636','219',2559935.45,2559935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105637',2096990,'1637','219',3829960.56,3830239.31,278.75,39025.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105637',2096991,'1638','220',103223.36,103449.68,226.32,50922.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105637',2096992,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105639',2097009,'1632','219',171118.15,171357.43,239.28,33499.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','105639',2097010,'1633','219',372112.51,372503.77,391.26,54776.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105639',2097011,'1634','219',398366.11,398846.54,480.43,67260.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105639',2097012,'1635','219',546250.14,546250.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105639',2097013,'1636','219',2559935.45,2559935.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105639',2097014,'1637','219',3830239.31,3830239.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105639',2097015,'1638','220',103449.68,103461.00,11.32,2547.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105639',2097016,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105641',2097030,'1632','219',171357.43,172329.34,971.91,136067.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105641',2097031,'1633','219',372503.77,373249.28,745.51,104371.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105641',2097032,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105641',2097033,'1635','219',546250.14,546406.60,156.46,21904.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','105641',2097034,'1636','219',2559935.45,2560388.96,453.51,63491.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','105641',2097035,'1637','219',3830239.31,3830239.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105641',2097036,'1638','220',103461.00,103786.97,325.97,73343.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','105641',2097037,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105643',2097069,'1632','219',172329.34,172774.99,445.65,62391.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105643',2097070,'1633','219',373249.28,373643.73,394.45,55223.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105643',2097071,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105643',2097072,'1635','219',546406.60,546406.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105643',2097073,'1636','219',2560388.96,2560388.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105643',2097074,'1637','219',3830239.31,3830239.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105643',2097075,'1638','220',103786.97,103906.64,119.67,26925.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105643',2097076,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105644',2097077,'1632','219',172774.99,173368.88,593.89,83144.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105644',2097078,'1633','219',373643.73,374492.13,848.40,118776.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105644',2097079,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105644',2097080,'1635','219',546406.60,546815.03,408.43,57180.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105644',2097081,'1636','219',2560388.96,2560388.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105644',2097082,'1637','219',3830239.31,3830584.76,345.45,48363.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105644',2097083,'1638','220',103906.64,104103.95,197.31,44394.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105644',2097084,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105645',2097085,'1632','219',173368.88,173917.11,548.23,76752.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','105645',2097086,'1633','219',374492.13,375169.40,677.27,94817.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','105645',2097087,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105645',2097088,'1635','219',546815.03,547187.50,372.47,52145.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105645',2097089,'1636','219',2560388.96,2560388.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105645',2097090,'1637','219',3830584.76,3830584.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105645',2097091,'1638','220',104103.95,104167.70,63.75,14343.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105645',2097092,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105646',2097093,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105646',2097094,'1633','219',375169.40,375444.64,275.24,38533.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105646',2097095,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105646',2097096,'1635','219',547187.50,547931.78,744.28,104199.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105646',2097097,'1636','219',2560388.96,2561259.30,870.34,121847.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','105646',2097098,'1637','219',3830584.76,3830872.76,288.00,40320.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105646',2097099,'1638','220',104167.70,104327.92,160.22,36049.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105646',2097100,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105648',2097117,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105648',2097118,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105648',2097119,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105648',2097120,'1635','219',547931.78,548365.10,433.32,60664.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105648',2097121,'1636','219',2561259.30,2561690.01,430.71,60299.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','105648',2097122,'1637','219',3830872.76,3831191.31,318.55,44597.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105648',2097123,'1638','220',104327.92,104409.51,81.59,18357.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105648',2097124,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105649',2097125,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105649',2097126,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105649',2097127,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105649',2097128,'1635','219',548365.10,549189.48,824.38,115413.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105649',2097129,'1636','219',2561690.01,2562618.52,928.51,129991.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','105649',2097130,'1637','219',3831191.31,3831862.04,670.73,93902.20,0.00,0.00,0.00,0.00,0.00),('5','95','581','105649',2097131,'1638','220',104409.51,104519.70,110.19,24792.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105649',2097132,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105650',2097133,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105650',2097134,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105650',2097135,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105650',2097136,'1635','219',549189.48,549606.81,417.33,58426.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105650',2097137,'1636','219',2562618.52,2562984.36,365.84,51217.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','105650',2097138,'1637','219',3831862.04,3832056.67,194.63,27248.20,0.00,0.00,0.00,0.00,0.00),('5','95','581','105650',2097139,'1638','220',104519.70,104585.43,65.73,14789.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','105650',2097140,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105652',2097159,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105652',2097160,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105652',2097161,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105652',2097162,'1635','219',549606.81,550765.81,1159.00,162260.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105652',2097163,'1636','219',2562984.36,2564897.05,1912.69,267776.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','105652',2097164,'1637','219',3832056.67,3832767.81,711.14,99559.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','105652',2097165,'1638','220',104585.43,104660.17,74.74,16816.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105652',2097166,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105654',2097185,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105654',2097186,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105654',2097187,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105654',2097188,'1635','219',550765.81,551241.23,475.42,66558.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105654',2097189,'1636','219',2564897.05,2565287.63,390.58,54681.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','105654',2097190,'1637','219',3832767.81,3832967.38,199.57,27939.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','105654',2097191,'1638','220',104660.17,104772.33,112.16,25236.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105654',2097192,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105656',2097202,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105656',2097203,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105656',2097204,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105656',2097205,'1635','219',551241.23,552220.99,979.76,137166.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','105656',2097206,'1636','219',2565287.63,2566552.38,1264.75,177065.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105656',2097207,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105656',2097208,'1638','220',104772.33,104825.75,53.42,12019.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105656',2097209,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105658',2097219,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105658',2097220,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105658',2097221,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105658',2097222,'1635','219',552220.99,553066.84,845.85,118419.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105658',2097223,'1636','219',2566552.38,2567108.30,555.92,77828.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','105658',2097224,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105658',2097225,'1638','220',104825.75,104859.50,33.75,7593.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105658',2097226,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105660',2097239,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105660',2097240,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105660',2097241,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105660',2097242,'1635','219',553066.84,554283.67,1216.83,170356.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105660',2097243,'1636','219',2567108.30,2569462.19,2353.89,329544.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','105660',2097244,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105660',2097245,'1638','220',104859.50,104905.80,46.30,10417.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105660',2097246,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105662',2097263,'1632','219',173917.11,173917.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105662',2097264,'1633','219',375444.64,375444.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105662',2097265,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105662',2097266,'1635','219',554283.67,554777.61,493.94,69151.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','105662',2097267,'1636','219',2569462.19,2570154.49,692.30,96922.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105662',2097268,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105662',2097269,'1638','220',104905.80,104970.93,65.13,14654.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','105662',2097270,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105665',2097319,'1632','219',173917.11,174015.82,98.71,13819.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105665',2097320,'1633','219',375444.64,375790.87,346.23,48472.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','105665',2097321,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105665',2097322,'1635','219',554777.61,555729.62,952.01,133281.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','105665',2097323,'1636','219',2570154.49,2571259.15,1104.66,154652.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','105665',2097324,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105665',2097325,'1638','220',104970.93,105120.15,149.22,33574.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105665',2097326,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105666',2097327,'1632','219',174015.82,174015.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105666',2097328,'1633','219',375790.87,376193.58,402.71,56379.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105666',2097329,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105666',2097330,'1635','219',555729.62,556044.98,315.36,44150.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','105666',2097331,'1636','219',2571259.15,2571778.91,519.76,72766.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','105666',2097332,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105666',2097333,'1638','220',105120.15,105142.62,22.47,5055.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105666',2097334,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105668',2097363,'1632','219',174015.82,174015.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105668',2097364,'1633','219',376193.58,377259.00,1065.42,149158.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','105668',2097365,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105668',2097366,'1635','219',556044.98,556674.95,629.97,88195.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105668',2097367,'1636','219',2571778.91,2572256.87,477.96,66914.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','105668',2097368,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105668',2097369,'1638','220',105142.62,105200.93,58.31,13119.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105668',2097370,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105669',2097371,'1632','219',174015.82,174015.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105669',2097372,'1633','219',377259.00,377747.74,488.74,68423.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105669',2097373,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105669',2097374,'1635','219',556674.95,557001.12,326.17,45663.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105669',2097375,'1636','219',2572256.87,2572493.74,236.87,33161.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','105669',2097376,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105669',2097377,'1638','220',105200.93,105309.19,108.26,24358.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105669',2097378,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105676',2097511,'1632','219',174015.82,174015.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105676',2097512,'1633','219',377747.74,378617.81,870.07,121809.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','105676',2097513,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105676',2097514,'1635','219',557001.12,557868.47,867.35,121429.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105676',2097515,'1636','219',2572493.74,2573618.83,1125.09,157512.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','105676',2097516,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105676',2097517,'1638','220',105309.19,105587.83,278.64,62694.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105676',2097518,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105678',2097526,'1632','219',174015.82,174015.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105678',2097527,'1633','219',378617.81,379052.67,434.86,60880.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105678',2097528,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105678',2097529,'1635','219',557868.47,558160.02,291.55,40817.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105678',2097530,'1636','219',2573618.83,2573843.20,224.37,31411.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','105678',2097531,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105678',2097532,'1638','220',105587.83,105601.07,13.24,2979.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105678',2097533,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105684',2097626,'1632','219',174015.82,174632.32,616.50,86310.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105684',2097627,'1633','219',379052.67,380435.48,1382.81,193593.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105684',2097628,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105684',2097629,'1635','219',558160.02,558644.25,484.23,67792.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','105684',2097630,'1636','219',2573843.20,2574376.64,533.44,74681.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','105684',2097631,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105684',2097632,'1638','220',105601.07,105623.16,22.09,4970.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','105684',2097633,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105689',2097701,'1632','219',174632.32,174731.37,99.05,13867.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105689',2097702,'1633','219',380435.48,380878.54,443.06,62028.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105689',2097703,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105689',2097704,'1635','219',558644.25,558864.07,219.82,30774.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105689',2097705,'1636','219',2574376.64,2574479.41,102.77,14387.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','105689',2097706,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105689',2097707,'1638','220',105623.16,105634.70,11.54,2596.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105689',2097708,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105692',2097754,'1632','219',174731.37,175490.78,759.41,106317.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105692',2097755,'1633','219',380878.54,381983.71,1105.17,154723.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','105692',2097756,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105692',2097757,'1635','219',558864.07,558864.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105692',2097758,'1636','219',2574479.41,2575602.61,1123.20,157248.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105692',2097759,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105692',2097760,'1638','220',105634.70,105686.69,51.99,11697.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105692',2097761,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105703',2098018,'1632','219',175490.78,175944.14,453.36,63470.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105703',2098019,'1633','219',381983.71,382471.72,488.01,68321.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105703',2098020,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105703',2098021,'1635','219',558864.07,558864.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105703',2098022,'1636','219',2575602.61,2575849.14,246.53,34514.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','105703',2098023,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105703',2098024,'1638','220',105686.69,105734.22,47.53,10694.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','105703',2098025,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105706',2098036,'1632','219',175944.14,176658.61,714.47,100025.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','105706',2098037,'1633','219',382471.72,383508.14,1036.42,145098.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','105706',2098038,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105706',2098039,'1635','219',558864.07,558864.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105706',2098040,'1636','219',2575849.14,2576368.84,519.70,72758.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105706',2098041,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105706',2098042,'1638','220',105734.22,105863.45,129.23,29076.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105706',2098043,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105709',2098063,'1632','219',176658.61,176990.05,331.44,46401.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105709',2098064,'1633','219',383508.14,384065.90,557.76,78086.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105709',2098065,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105709',2098066,'1635','219',558864.07,558864.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105709',2098067,'1636','219',2576368.84,2576368.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105709',2098068,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105709',2098069,'1638','220',105863.45,105869.57,6.12,1377.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105709',2098070,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105711',2098105,'1632','219',176990.05,178190.44,1200.39,168054.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105711',2098106,'1633','219',384065.90,385319.99,1254.09,175572.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105711',2098107,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105711',2098108,'1635','219',558864.07,558864.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105711',2098109,'1636','219',2576368.84,2576368.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105711',2098110,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105711',2098111,'1638','220',105869.57,105923.17,53.60,12060.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105711',2098112,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105712',2098113,'1632','219',178190.44,178643.63,453.19,63446.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105712',2098114,'1633','219',385319.99,386103.95,783.96,109754.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105712',2098115,'1634','219',398846.54,398846.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105712',2098116,'1635','219',558864.07,558864.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105712',2098117,'1636','219',2576368.84,2576368.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105712',2098118,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105712',2098119,'1638','220',105923.17,106047.83,124.66,28048.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105712',2098120,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105713',2098121,'1632','219',178643.63,179596.70,953.07,133429.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','105713',2098122,'1633','219',386103.95,387093.94,989.99,138598.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105713',2098123,'1634','219',398846.54,399227.56,381.02,53342.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','105713',2098124,'1635','219',558864.07,559211.81,347.74,48683.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','105713',2098125,'1636','219',2576368.84,2576368.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105713',2098126,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105713',2098127,'1638','220',106047.83,106206.06,158.23,35601.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','105713',2098128,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105715',2098146,'1632','219',179596.70,180024.62,427.92,59908.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','105715',2098147,'1633','219',387093.94,387215.05,121.11,16955.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','105715',2098148,'1634','219',399227.56,399706.40,478.84,67037.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','105715',2098149,'1635','219',559211.81,559211.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105715',2098150,'1636','219',2576368.84,2576368.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105715',2098151,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105715',2098152,'1638','220',106206.06,107065.92,859.86,193468.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','105715',2098153,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','105978',2103375,'1632','219',180024.62,180632.36,607.74,85083.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105978',2103376,'1633','219',387215.05,387971.84,756.79,105950.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','105978',2103377,'1634','219',399706.40,400097.95,391.55,54817.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','105978',2103378,'1635','219',559211.81,559564.45,352.64,49369.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','105978',2103379,'1636','219',2576368.84,2576368.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','105978',2103380,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','105978',2103381,'1638','220',107065.92,107196.04,130.12,29277.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','105978',2103382,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106538',2114053,'1632','219',180632.36,180980.25,347.89,48704.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','106538',2114054,'1633','219',387971.84,388289.30,317.46,44444.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','106538',2114055,'1634','219',400097.95,400563.44,465.49,65168.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','106538',2114056,'1635','219',559564.45,559579.44,14.99,2098.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','106538',2114057,'1636','219',2576368.84,2576447.36,78.52,10992.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','106538',2114058,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106538',2114059,'1638','220',107196.04,107224.02,27.98,6295.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','106538',2114060,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106540',2114085,'1632','219',180980.25,181586.42,606.17,84863.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','106540',2114086,'1633','219',388289.30,389107.20,817.90,114506.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106540',2114087,'1634','219',400563.44,401965.22,1401.78,196249.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','106540',2114088,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106540',2114089,'1636','219',2576447.36,2576447.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','106540',2114090,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106540',2114091,'1638','220',107224.02,107291.56,67.54,15196.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','106540',2114092,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106542',2114134,'1632','219',181586.42,181969.25,382.83,53596.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','106542',2114135,'1633','219',389107.20,389423.14,315.94,44231.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','106542',2114136,'1634','219',401965.22,402382.35,417.13,58398.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','106542',2114137,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106542',2114138,'1636','219',2576447.36,2576520.01,72.65,10171.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','106542',2114139,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106542',2114140,'1638','220',107291.56,107323.99,32.43,7296.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','106542',2114141,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106543',2114142,'1632','219',181969.25,182665.49,696.24,97473.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','106543',2114143,'1633','219',389423.14,389892.73,469.59,65742.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','106543',2114144,'1634','219',402382.35,402525.09,142.74,19983.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','106543',2114145,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106543',2114146,'1636','219',2576520.01,2577070.56,550.55,77077.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','106543',2114147,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106543',2114148,'1638','220',107323.99,107380.08,56.09,12620.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','106543',2114149,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106545',2114191,'1632','219',182665.49,182665.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106545',2114192,'1633','219',389892.73,390268.39,375.66,52592.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','106545',2114193,'1634','219',402525.09,403037.43,512.34,71727.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','106545',2114194,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106545',2114195,'1636','219',2577070.56,2577252.01,181.45,25403.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','106545',2114196,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106545',2114197,'1638','220',107380.08,107422.29,42.21,9497.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','106545',2114198,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106546',2114199,'1632','219',182665.49,183186.20,520.71,72899.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','106546',2114200,'1633','219',390268.39,390984.03,715.64,100189.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','106546',2114201,'1634','219',403037.43,403827.72,790.29,110640.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','106546',2114202,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106546',2114203,'1636','219',2577252.01,2577656.63,404.62,56646.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','106546',2114204,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106546',2114205,'1638','220',107422.29,107473.92,51.63,11616.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','106546',2114206,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106548',2114248,'1632','219',183186.20,183384.62,198.42,27778.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','106548',2114249,'1633','219',390984.03,391485.34,501.31,70183.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','106548',2114250,'1634','219',403827.72,404226.28,398.56,55798.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','106548',2114251,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106548',2114252,'1636','219',2577656.63,2577656.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','106548',2114253,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106548',2114254,'1638','220',107473.92,107549.90,75.98,17095.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','106548',2114255,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106549',2114256,'1632','219',183384.62,183869.75,485.13,67918.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','106549',2114257,'1633','219',391485.34,392387.28,901.94,126271.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','106549',2114258,'1634','219',404226.28,404958.55,732.27,102517.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','106549',2114259,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106549',2114260,'1636','219',2577656.63,2577656.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','106549',2114261,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106549',2114262,'1638','220',107549.90,107615.43,65.53,14744.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','106549',2114263,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106550',2114264,'1632','219',183869.75,184099.71,229.96,32194.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','106550',2114265,'1633','219',392387.28,392716.14,328.86,46040.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','106550',2114266,'1634','219',404958.55,405291.14,332.59,46562.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','106550',2114267,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106550',2114268,'1636','219',2577656.63,2577833.17,176.54,24715.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','106550',2114269,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106550',2114270,'1638','220',107615.43,107760.42,144.99,32622.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','106550',2114271,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106551',2114272,'1632','219',184099.71,184766.49,666.78,93349.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','106551',2114273,'1633','219',392716.14,393368.71,652.57,91359.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','106551',2114274,'1634','219',405291.14,405803.09,511.95,71673.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106551',2114275,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106551',2114276,'1636','219',2577833.17,2577833.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','106551',2114277,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106551',2114278,'1638','220',107760.42,107908.58,148.16,33336.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','106551',2114279,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','106552',2114280,'1632','219',184766.49,185127.75,361.26,50576.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','106552',2114281,'1633','219',393368.71,393659.02,290.31,40643.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','106552',2114282,'1634','219',405803.09,406031.03,227.94,31911.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','106552',2114283,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','106552',2114284,'1636','219',2577833.17,2577833.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','106552',2114285,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','106552',2114286,'1638','220',107908.58,107919.81,11.23,2526.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','106552',2114287,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','107966',2141710,'1632','219',185127.75,185948.43,820.68,114895.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','107966',2141711,'1633','219',393659.02,394450.32,791.30,110782.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','107966',2141712,'1634','219',406031.03,406445.41,414.38,58013.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','107966',2141713,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','107966',2141714,'1636','219',2577833.17,2577833.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','107966',2141715,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','107966',2141716,'1638','220',107919.81,108063.07,143.26,32233.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','107966',2141717,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','107970',2141777,'1632','219',185948.43,186195.10,246.67,34533.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','107970',2141778,'1633','219',394450.32,394755.10,304.78,42669.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','107970',2141779,'1634','219',406445.41,406633.86,188.45,26383.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','107970',2141780,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','107970',2141781,'1636','219',2577833.17,2577833.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','107970',2141782,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','107970',2141783,'1638','220',108063.07,108236.89,173.82,39109.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','107970',2141784,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','107975',2141860,'1632','219',186195.10,186544.12,349.02,48862.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','107975',2141861,'1633','219',394755.10,395270.51,515.41,72157.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','107975',2141862,'1634','219',406633.86,407272.55,638.69,89416.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','107975',2141863,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','107975',2141864,'1636','219',2577833.17,2578194.42,361.25,50575.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','107975',2141865,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','107975',2141866,'1638','220',108236.89,108347.64,110.75,24918.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','107975',2141867,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108496',2152246,'1632','219',186544.12,187246.51,702.39,98334.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','108496',2152247,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108496',2152248,'1634','219',407272.55,407689.94,417.39,58434.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','108496',2152249,'1635','219',559579.44,559579.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108496',2152250,'1636','219',2578194.42,2578429.61,235.19,32926.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','108496',2152251,'1637','219',3832967.38,3832967.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','108496',2152252,'1638','220',108347.64,108406.15,58.51,13164.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108496',2152253,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108499',2152310,'1632','219',187246.51,187478.10,231.59,32422.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','108499',2152311,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108499',2152312,'1634','219',407689.94,408035.19,345.25,48335.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108499',2152313,'1635','219',559579.44,560024.31,444.87,62281.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','108499',2152314,'1636','219',2578429.61,2579409.77,980.16,137222.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','108499',2152315,'1637','219',3832967.38,3833743.26,775.88,108623.20,0.00,0.00,0.00,0.00,0.00),('5','95','581','108499',2152316,'1638','220',108406.15,108486.03,79.88,17973.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','108499',2152317,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108503',2152363,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108503',2152364,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108503',2152365,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108503',2152366,'1635','219',560024.31,560514.49,490.18,68625.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','108503',2152367,'1636','219',2579409.77,2579802.56,392.79,54990.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','108503',2152368,'1637','219',3833743.26,3834098.38,355.12,49716.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','108503',2152369,'1638','220',108486.03,108612.26,126.23,28401.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108503',2152370,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108505',2152382,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108505',2152383,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108505',2152384,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108505',2152385,'1635','219',560514.49,561242.32,727.83,101896.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','108505',2152386,'1636','219',2579802.56,2581102.27,1299.71,181959.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','108505',2152387,'1637','219',3834098.38,3834752.44,654.06,91568.40,0.00,0.00,0.00,0.00,0.00),('5','95','581','108505',2152388,'1638','220',108612.26,108645.81,33.55,7548.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108505',2152389,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108509',2152427,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108509',2152428,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108509',2152429,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108509',2152430,'1635','219',561242.32,561381.52,139.20,19488.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108509',2152431,'1636','219',2581102.27,2581596.39,494.12,69176.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','108509',2152432,'1637','219',3834752.44,3835083.65,331.21,46369.40,0.00,0.00,0.00,0.00,0.00),('5','95','581','108509',2152433,'1638','220',108645.81,109171.22,525.41,118217.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','108509',2152434,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108514',2152494,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108514',2152495,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108514',2152496,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108514',2152497,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108514',2152498,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108514',2152499,'1637','219',3835083.65,3837040.26,1956.61,273925.40,0.00,0.00,0.00,0.00,0.00),('5','95','581','108514',2152500,'1638','220',109171.22,109303.98,132.76,29871.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','108514',2152501,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108516',2152520,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108516',2152521,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108516',2152522,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108516',2152523,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108516',2152524,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108516',2152525,'1637','219',3837040.26,3837932.20,891.94,124871.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','108516',2152526,'1638','220',109303.98,109440.31,136.33,30674.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','108516',2152527,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108517',2152528,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108517',2152529,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108517',2152530,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108517',2152531,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108517',2152532,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108517',2152533,'1637','219',3837932.20,3839783.64,1851.44,259201.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','108517',2152534,'1638','220',109440.31,109644.86,204.55,46023.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108517',2152535,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108518',2152536,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108518',2152537,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108518',2152538,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108518',2152539,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108518',2152540,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108518',2152541,'1637','219',3839783.64,3841204.99,1421.35,198989.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','108518',2152542,'1638','220',109644.86,109685.72,40.86,9193.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','108518',2152543,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108519',2152544,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108519',2152545,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108519',2152546,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108519',2152547,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108519',2152548,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108519',2152549,'1637','219',3841204.99,3843531.49,2326.50,325710.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','108519',2152550,'1638','220',109685.72,109839.10,153.38,34510.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','108519',2152551,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108521',2152565,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108521',2152566,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108521',2152567,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108521',2152568,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108521',2152569,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108521',2152570,'1637','219',3843531.49,3844677.13,1145.64,160389.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','108521',2152571,'1638','220',109839.10,110027.53,188.43,42396.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108521',2152572,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108522',2152573,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108522',2152574,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108522',2152575,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108522',2152576,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108522',2152577,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108522',2152578,'1637','219',3844677.13,3847205.48,2528.35,353969.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','108522',2152579,'1638','220',110027.53,110178.72,151.19,34017.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108522',2152580,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108523',2152581,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108523',2152582,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108523',2152583,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108523',2152584,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108523',2152585,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108523',2152586,'1637','219',3847205.48,3848069.47,863.99,120958.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','108523',2152587,'1638','220',110178.72,110227.15,48.43,10896.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108523',2152588,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108525',2152598,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108525',2152599,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108525',2152600,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108525',2152601,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108525',2152602,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108525',2152603,'1637','219',3848069.47,3852310.41,4240.94,593731.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','108525',2152604,'1638','220',110227.15,110377.90,150.75,33918.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108525',2152605,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108527',2152615,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108527',2152616,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108527',2152617,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108527',2152618,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108527',2152619,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108527',2152620,'1637','219',3852310.41,3852594.49,284.08,39771.20,0.00,0.00,0.00,0.00,0.00),('5','95','581','108527',2152621,'1638','220',110377.90,110418.78,40.88,9198.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','108527',2152622,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108534',2152701,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108534',2152702,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108534',2152703,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108534',2152704,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108534',2152705,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108534',2152706,'1637','219',3852594.49,3854709.89,2115.40,296156.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','108534',2152707,'1638','220',110418.78,110878.18,459.40,103365.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','108534',2152708,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108535',2152709,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108535',2152710,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108535',2152711,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108535',2152712,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108535',2152713,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108535',2152714,'1637','219',3854709.89,3855543.83,833.94,116751.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','108535',2152715,'1638','220',110878.18,111174.04,295.86,66568.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','108535',2152716,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108539',2152743,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108539',2152744,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108539',2152745,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108539',2152746,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108539',2152747,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108539',2152748,'1637','219',3855543.83,3857692.06,2148.23,300752.20,0.00,0.00,0.00,0.00,0.00),('5','95','581','108539',2152749,'1638','220',111174.04,111363.07,189.03,42531.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108539',2152750,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108543',2152794,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108543',2152795,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108543',2152796,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108543',2152797,'1635','219',561381.52,561381.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108543',2152798,'1636','219',2581596.39,2581596.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108543',2152799,'1637','219',3857692.06,3858557.51,865.45,121163.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','108543',2152800,'1638','220',111363.07,111491.31,128.24,28854.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','108543',2152801,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108545',2152811,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108545',2152812,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108545',2152813,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108545',2152814,'1635','219',561381.52,561879.17,497.65,69671.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108545',2152815,'1636','219',2581596.39,2582389.43,793.04,111025.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','108545',2152816,'1637','219',3858557.51,3859721.18,1163.67,162913.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','108545',2152817,'1638','220',111491.31,111545.99,54.68,12303.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','108545',2152818,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108553',2152960,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108553',2152961,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108553',2152962,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108553',2152963,'1635','219',561879.17,562268.76,389.59,54542.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','108553',2152964,'1636','219',2582389.43,2582775.94,386.51,54111.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','108553',2152965,'1637','219',3859721.18,3860068.28,347.10,48594.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','108553',2152966,'1638','220',111545.99,111687.68,141.69,31880.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','108553',2152967,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108557',2153048,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108557',2153049,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108557',2153050,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108557',2153051,'1635','219',562268.76,562705.95,437.19,61206.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','108557',2153052,'1636','219',2582775.94,2583249.83,473.89,66344.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','108557',2153053,'1637','219',3860068.28,3860776.45,708.17,99143.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','108557',2153054,'1638','220',111687.68,111917.75,230.07,51765.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108557',2153055,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108559',2153078,'1632','219',187478.10,187478.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108559',2153079,'1633','219',395270.51,395270.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','108559',2153080,'1634','219',408035.19,408035.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108559',2153081,'1635','219',562705.95,563118.60,412.65,57771.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','108559',2153082,'1636','219',2583249.83,2583582.31,332.48,46547.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','108559',2153083,'1637','219',3860776.45,3861039.61,263.16,36842.40,0.00,0.00,0.00,0.00,0.00),('5','95','581','108559',2153084,'1638','220',111917.75,112318.98,401.23,90276.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','108559',2153085,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124218',2475371,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124218',2475372,'1633','219',521090.75,521912.63,821.88,117528.84,0.00,0.00,0.00,0.00,0.00),('5','95','578','124218',2475373,'1634','219',565534.14,566985.42,1451.28,207533.04,0.00,0.00,0.00,0.00,0.00),('5','95','579','124218',2475374,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124218',2475375,'1636','219',2720241.31,2720891.13,649.82,92924.26,0.00,0.00,0.00,0.00,0.00),('5','95','579','124218',2475376,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124218',2475377,'1638','220',189501.38,189632.34,130.96,30120.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','124218',2475378,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124221',2475407,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124221',2475408,'1633','219',521912.63,522567.34,654.71,93623.53,0.00,0.00,0.00,0.00,0.00),('5','95','578','124221',2475409,'1634','219',566985.42,567440.85,455.43,65126.49,0.00,0.00,0.00,0.00,0.00),('5','95','579','124221',2475410,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124221',2475411,'1636','219',2720891.13,2720891.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124221',2475412,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124221',2475413,'1638','220',189632.34,189632.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','124221',2475414,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124223',2475445,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124223',2475446,'1633','219',522567.34,523387.36,820.02,117262.86,0.00,0.00,0.00,0.00,0.00),('5','95','578','124223',2475447,'1634','219',567440.85,568468.59,1027.74,146966.82,0.00,0.00,0.00,0.00,0.00),('5','95','579','124223',2475448,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124223',2475449,'1636','219',2720891.13,2721443.44,552.31,78980.33,0.00,0.00,0.00,0.00,0.00),('5','95','579','124223',2475450,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124223',2475451,'1638','220',189632.34,189772.20,139.86,32167.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','124223',2475452,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124226',2475489,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124226',2475490,'1633','219',523387.36,523982.39,595.03,85089.29,0.00,0.00,0.00,0.00,0.00),('5','95','578','124226',2475491,'1634','219',568468.59,568964.73,496.14,70948.02,0.00,0.00,0.00,0.00,0.00),('5','95','579','124226',2475492,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124226',2475493,'1636','219',2721443.44,2721443.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124226',2475494,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124226',2475495,'1638','220',189772.20,190285.29,513.09,118010.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','124226',2475496,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124249',2476004,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124249',2476005,'1633','219',523982.39,524650.53,668.14,95544.02,0.00,0.00,0.00,0.00,0.00),('5','95','578','124249',2476006,'1634','219',568964.73,570186.88,1222.15,174767.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','124249',2476007,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124249',2476008,'1636','219',2721443.44,2721443.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124249',2476009,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124249',2476010,'1638','220',190285.29,190793.89,508.60,114435.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','124249',2476011,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124250',2476012,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124250',2476013,'1633','219',524650.53,525474.12,823.59,117773.37,0.00,0.00,0.00,0.00,0.00),('5','95','578','124250',2476014,'1634','219',570186.88,570594.14,407.26,58238.18,0.00,0.00,0.00,0.00,0.00),('5','95','579','124250',2476015,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124250',2476016,'1636','219',2721443.44,2722058.33,614.89,87929.27,0.00,0.00,0.00,0.00,0.00),('5','95','579','124250',2476017,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124250',2476018,'1638','220',190793.89,191392.22,598.33,134624.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','124250',2476019,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124251',2476020,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124251',2476021,'1633','219',525474.12,526523.03,1048.91,149994.13,0.00,0.00,0.00,0.00,0.00),('5','95','578','124251',2476022,'1634','219',570594.14,571347.99,753.85,107800.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','124251',2476023,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124251',2476024,'1636','219',2722058.33,2722558.07,499.74,71462.82,0.00,0.00,0.00,0.00,0.00),('5','95','579','124251',2476025,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124251',2476026,'1638','220',191392.22,191425.98,33.76,7596.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','124251',2476027,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124252',2476028,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124252',2476029,'1633','219',526523.03,527129.64,606.61,86745.23,0.00,0.00,0.00,0.00,0.00),('5','95','578','124252',2476030,'1634','219',571347.99,571798.56,450.57,64431.51,0.00,0.00,0.00,0.00,0.00),('5','95','579','124252',2476031,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124252',2476032,'1636','219',2722558.07,2722793.45,235.38,33659.34,0.00,0.00,0.00,0.00,0.00),('5','95','579','124252',2476033,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124252',2476034,'1638','220',191425.98,191444.71,18.73,4214.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','124252',2476035,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124324',2477444,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124324',2477445,'1633','219',527129.64,528069.94,940.30,134462.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','124324',2477446,'1634','219',571798.56,572738.64,940.08,134431.44,0.00,0.00,0.00,0.00,0.00),('5','95','579','124324',2477447,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124324',2477448,'1636','219',2722793.45,2723515.52,722.07,103256.01,0.00,0.00,0.00,0.00,0.00),('5','95','579','124324',2477449,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124324',2477450,'1638','220',191444.71,192097.03,652.32,146772.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','124324',2477451,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124326',2477468,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124326',2477469,'1633','219',528069.94,528124.45,54.51,7794.93,0.00,0.00,0.00,0.00,0.00),('5','95','578','124326',2477470,'1634','219',572738.64,573677.77,939.13,134295.59,0.00,0.00,0.00,0.00,0.00),('5','95','579','124326',2477471,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124326',2477472,'1636','219',2723515.52,2724085.81,570.29,81551.47,0.00,0.00,0.00,0.00,0.00),('5','95','579','124326',2477473,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124326',2477474,'1638','220',192097.03,192097.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','124326',2477475,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124330',2477527,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124330',2477528,'1633','219',528124.45,528985.17,860.72,123082.96,0.00,0.00,0.00,0.00,0.00),('5','95','578','124330',2477529,'1634','219',573677.77,574904.79,1227.02,175463.86,0.00,0.00,0.00,0.00,0.00),('5','95','579','124330',2477530,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124330',2477531,'1636','219',2724085.81,2724267.49,181.68,25980.24,0.00,0.00,0.00,0.00,0.00),('5','95','579','124330',2477532,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124330',2477533,'1638','220',192097.03,192214.10,117.07,26340.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','124330',2477534,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124335',2477618,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124335',2477619,'1633','219',528985.17,529488.00,502.83,71904.69,0.00,0.00,0.00,0.00,0.00),('5','95','578','124335',2477620,'1634','219',574904.79,575345.12,440.33,62967.19,0.00,0.00,0.00,0.00,0.00),('5','95','579','124335',2477621,'1635','219',642645.38,642645.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124335',2477622,'1636','219',2724267.49,2724462.02,194.53,27817.79,0.00,0.00,0.00,0.00,0.00),('5','95','579','124335',2477623,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124335',2477624,'1638','220',192214.10,192530.18,316.08,71118.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','124335',2477625,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124393',2478902,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124393',2478903,'1633','219',529488.00,529749.85,261.85,37444.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','124393',2478904,'1634','219',575345.12,576225.12,880.00,125840.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124393',2478905,'1635','219',642645.38,642661.17,15.79,2257.97,0.00,0.00,0.00,0.00,0.00),('5','95','579','124393',2478906,'1636','219',2724462.02,2725356.17,894.15,127863.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','124393',2478907,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124393',2478908,'1638','220',192530.18,192530.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','124393',2478909,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124610',2483408,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124610',2483409,'1633','219',529749.85,529749.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124610',2483410,'1634','219',576225.12,576731.65,506.53,72433.79,0.00,0.00,0.00,0.00,0.00),('5','95','579','124610',2483411,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124610',2483412,'1636','219',2725356.17,2725742.54,386.37,55250.91,0.00,0.00,0.00,0.00,0.00),('5','95','579','124610',2483413,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124610',2483414,'1638','220',192530.18,192608.04,77.86,17518.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','124610',2483415,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124611',2483416,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','124611',2483417,'1633','219',529749.85,530471.81,721.96,103240.28,0.00,0.00,0.00,0.00,0.00),('5','95','578','124611',2483418,'1634','219',576731.65,577863.47,1131.82,161850.26,0.00,0.00,0.00,0.00,0.00),('5','95','579','124611',2483419,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','124611',2483420,'1636','219',2725742.54,2727742.39,1999.85,285978.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','124611',2483421,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','124611',2483422,'1638','220',192608.04,193334.73,726.69,163505.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','124611',2483423,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126287',2516741,'1632','219',961.50,961.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126287',2516742,'1633','219',530471.81,531416.92,945.11,135150.73,0.00,0.00,0.00,0.00,0.00),('5','95','578','126287',2516743,'1634','219',577863.47,578323.40,459.93,65769.99,0.00,0.00,0.00,0.00,0.00),('5','95','579','126287',2516744,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126287',2516745,'1636','219',2727742.39,2727799.64,57.25,8186.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','126287',2516746,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126287',2516747,'1638','220',193334.73,193411.14,76.41,17192.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','126287',2516748,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126288',2516749,'1632','219',961.50,990.95,29.45,4211.35,0.00,0.00,0.00,0.00,0.00),('5','95','578','126288',2516750,'1633','219',531416.92,531920.94,504.02,72074.86,0.00,0.00,0.00,0.00,0.00),('5','95','578','126288',2516751,'1634','219',578323.40,579051.93,728.53,104179.79,0.00,0.00,0.00,0.00,0.00),('5','95','579','126288',2516752,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126288',2516753,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126288',2516754,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126288',2516755,'1638','220',193411.14,193444.89,33.75,7593.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126288',2516756,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126293',2516757,'1632','219',990.95,990.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126293',2516758,'1633','219',531920.94,531920.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126293',2516759,'1634','219',579051.93,579051.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126293',2516760,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126293',2516761,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126293',2516762,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126293',2516763,'1638','220',193444.89,193837.38,392.49,88310.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','126293',2516764,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126294',2516765,'1632','219',990.95,990.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126294',2516766,'1633','219',531920.94,531920.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126294',2516767,'1634','219',579051.93,579051.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126294',2516768,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126294',2516769,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126294',2516770,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126294',2516771,'1638','220',193837.38,194412.54,575.16,129411.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126294',2516772,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126295',2516773,'1632','219',990.95,990.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126295',2516774,'1633','219',531920.94,531920.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126295',2516775,'1634','219',579051.93,579051.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126295',2516776,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126295',2516777,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126295',2516778,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126295',2516779,'1638','220',194412.54,194468.82,56.28,12663.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126295',2516780,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126297',2516789,'1632','219',990.95,1722.30,731.35,104583.05,0.00,0.00,0.00,0.00,0.00),('5','95','578','126297',2516790,'1633','219',531920.94,532584.09,663.15,94830.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','126297',2516791,'1634','219',579051.93,579646.09,594.16,84964.88,0.00,0.00,0.00,0.00,0.00),('5','95','579','126297',2516792,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126297',2516793,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126297',2516794,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126297',2516795,'1638','220',194468.82,194510.24,41.42,9319.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','126297',2516796,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126298',2516797,'1632','219',1722.30,1964.86,242.56,34686.08,0.00,0.00,0.00,0.00,0.00),('5','95','578','126298',2516798,'1633','219',532584.09,532761.16,177.07,25321.01,0.00,0.00,0.00,0.00,0.00),('5','95','578','126298',2516799,'1634','219',579646.09,580095.32,449.23,64239.89,0.00,0.00,0.00,0.00,0.00),('5','95','579','126298',2516800,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126298',2516801,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126298',2516802,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126298',2516803,'1638','220',194510.24,195054.19,543.95,122388.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126298',2516804,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126299',2516805,'1632','219',1964.86,2677.16,712.30,101858.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','126299',2516806,'1633','219',532761.16,533522.43,761.27,108861.61,0.00,0.00,0.00,0.00,0.00),('5','95','578','126299',2516807,'1634','219',580095.32,580741.55,646.23,92410.89,0.00,0.00,0.00,0.00,0.00),('5','95','579','126299',2516808,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126299',2516809,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126299',2516810,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126299',2516811,'1638','220',195054.19,195346.54,292.35,65778.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126299',2516812,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126451',2519739,'1632','219',2677.16,3183.08,505.92,72346.56,0.00,0.00,0.00,0.00,0.00),('5','95','578','126451',2519740,'1633','219',533522.43,534154.19,631.76,90341.68,0.00,0.00,0.00,0.00,0.00),('5','95','578','126451',2519741,'1634','219',580741.55,581364.27,622.72,89048.96,0.00,0.00,0.00,0.00,0.00),('5','95','579','126451',2519742,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126451',2519743,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126451',2519744,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126451',2519745,'1638','220',195346.54,195406.45,59.91,13479.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126451',2519746,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126455',2519747,'1632','219',3183.08,3376.91,193.83,27717.69,0.00,0.00,0.00,0.00,0.00),('5','95','578','126455',2519748,'1633','219',534154.19,535472.04,1317.85,188452.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','126455',2519749,'1634','219',581364.27,582396.63,1032.36,147627.48,0.00,0.00,0.00,0.00,0.00),('5','95','579','126455',2519750,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126455',2519751,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126455',2519752,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126455',2519753,'1638','220',195406.45,195651.92,245.47,55230.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126455',2519754,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126456',2519755,'1632','219',3376.91,3376.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126456',2519756,'1633','219',535472.04,535787.25,315.21,45075.03,0.00,0.00,0.00,0.00,0.00),('5','95','578','126456',2519757,'1634','219',582396.63,583259.69,863.06,123417.58,0.00,0.00,0.00,0.00,0.00),('5','95','579','126456',2519758,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126456',2519759,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126456',2519760,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126456',2519761,'1638','220',195651.92,195763.43,111.51,25089.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126456',2519762,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126457',2519763,'1632','219',3376.91,3473.21,96.30,13770.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','126457',2519764,'1633','219',535787.25,536545.43,758.18,108419.74,0.00,0.00,0.00,0.00,0.00),('5','95','578','126457',2519765,'1634','219',583259.69,584325.26,1065.57,152376.51,0.00,0.00,0.00,0.00,0.00),('5','95','579','126457',2519766,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126457',2519767,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126457',2519768,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126457',2519769,'1638','220',195763.43,195919.07,155.64,35019.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126457',2519770,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126458',2519771,'1632','219',3473.21,3473.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126458',2519772,'1633','219',536545.43,537071.95,526.52,75292.36,0.00,0.00,0.00,0.00,0.00),('5','95','578','126458',2519773,'1634','219',584325.26,585018.94,693.68,99196.24,0.00,0.00,0.00,0.00,0.00),('5','95','579','126458',2519774,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126458',2519775,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126458',2519776,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126458',2519777,'1638','220',195919.07,196201.14,282.07,63465.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126458',2519778,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126459',2519779,'1632','219',3473.21,3473.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126459',2519780,'1633','219',537071.95,538206.26,1134.31,162206.33,0.00,0.00,0.00,0.00,0.00),('5','95','578','126459',2519781,'1634','219',585018.94,586012.90,993.96,142136.28,0.00,0.00,0.00,0.00,0.00),('5','95','579','126459',2519782,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126459',2519783,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126459',2519784,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126459',2519785,'1638','220',196201.14,196256.23,55.09,12395.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','126459',2519786,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126460',2519787,'1632','219',3473.21,3473.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126460',2519788,'1633','219',538206.26,538741.75,535.49,76575.07,0.00,0.00,0.00,0.00,0.00),('5','95','578','126460',2519789,'1634','219',586012.90,586467.09,454.19,64949.17,0.00,0.00,0.00,0.00,0.00),('5','95','579','126460',2519790,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126460',2519791,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126460',2519792,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126460',2519793,'1638','220',196256.23,196435.31,179.08,40293.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126460',2519794,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126595',2522428,'1632','219',3473.21,3473.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126595',2522429,'1633','219',538741.75,539539.48,797.73,114075.39,0.00,0.00,0.00,0.00,0.00),('5','95','578','126595',2522430,'1634','219',586467.09,587443.82,976.73,139672.39,0.00,0.00,0.00,0.00,0.00),('5','95','579','126595',2522431,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126595',2522432,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126595',2522433,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126595',2522434,'1638','220',196435.31,196556.38,121.07,27240.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126595',2522435,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126597',2522453,'1632','219',3473.21,3473.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126597',2522454,'1633','219',539539.48,540242.51,703.03,100533.29,0.00,0.00,0.00,0.00,0.00),('5','95','578','126597',2522455,'1634','219',587443.82,587958.25,514.43,73563.49,0.00,0.00,0.00,0.00,0.00),('5','95','579','126597',2522456,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126597',2522457,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126597',2522458,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126597',2522459,'1638','220',196556.38,196697.68,141.30,31792.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','126597',2522460,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126598',2522461,'1632','219',3473.21,3679.72,206.51,29530.93,0.00,0.00,0.00,0.00,0.00),('5','95','578','126598',2522462,'1633','219',540242.51,541835.80,1593.29,227840.47,0.00,0.00,0.00,0.00,0.00),('5','95','578','126598',2522463,'1634','219',587958.25,590024.31,2066.06,295446.58,0.00,0.00,0.00,0.00,0.00),('5','95','579','126598',2522464,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126598',2522465,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126598',2522466,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126598',2522467,'1638','220',196697.68,197127.95,430.27,96810.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126598',2522468,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126599',2522469,'1632','219',3679.72,3679.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126599',2522470,'1633','219',541835.80,541835.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126599',2522471,'1634','219',590024.31,590024.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126599',2522472,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126599',2522473,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126599',2522474,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126599',2522475,'1638','220',197127.95,197127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126599',2522476,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126600',2522477,'1632','219',3679.72,3679.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126600',2522478,'1633','219',541835.80,542207.33,371.53,53128.79,0.00,0.00,0.00,0.00,0.00),('5','95','578','126600',2522479,'1634','219',590024.31,590853.70,829.39,118602.77,0.00,0.00,0.00,0.00,0.00),('5','95','579','126600',2522480,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126600',2522481,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126600',2522482,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126600',2522483,'1638','220',197127.95,197127.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126600',2522484,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126601',2522485,'1632','219',3679.72,3789.19,109.47,15654.21,0.00,0.00,0.00,0.00,0.00),('5','95','578','126601',2522486,'1633','219',542207.33,543260.67,1053.34,150627.62,0.00,0.00,0.00,0.00,0.00),('5','95','578','126601',2522487,'1634','219',590853.70,591570.28,716.58,102470.94,0.00,0.00,0.00,0.00,0.00),('5','95','579','126601',2522488,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126601',2522489,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126601',2522490,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126601',2522491,'1638','220',197127.95,197220.90,92.95,20913.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126601',2522492,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126602',2522493,'1632','219',3789.19,3863.30,74.11,10597.73,0.00,0.00,0.00,0.00,0.00),('5','95','578','126602',2522494,'1633','219',543260.67,543698.51,437.84,62611.12,0.00,0.00,0.00,0.00,0.00),('5','95','578','126602',2522495,'1634','219',591570.28,592309.52,739.24,105711.32,0.00,0.00,0.00,0.00,0.00),('5','95','579','126602',2522496,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126602',2522497,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126602',2522498,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126602',2522499,'1638','220',197220.90,197267.10,46.20,10395.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126602',2522500,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126603',2522501,'1632','219',3863.30,3886.87,23.57,3370.51,0.00,0.00,0.00,0.00,0.00),('5','95','578','126603',2522502,'1633','219',543698.51,545125.98,1427.47,204128.21,0.00,0.00,0.00,0.00,0.00),('5','95','578','126603',2522503,'1634','219',592309.52,594102.41,1792.89,256383.27,0.00,0.00,0.00,0.00,0.00),('5','95','579','126603',2522504,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126603',2522505,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126603',2522506,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126603',2522507,'1638','220',197267.10,197324.69,57.59,12957.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126603',2522508,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126604',2522509,'1632','219',3886.87,4207.31,320.44,45822.92,0.00,0.00,0.00,0.00,0.00),('5','95','578','126604',2522510,'1633','219',545125.98,546859.42,1733.44,247881.92,0.00,0.00,0.00,0.00,0.00),('5','95','578','126604',2522511,'1634','219',594102.41,596734.40,2631.99,376374.57,0.00,0.00,0.00,0.00,0.00),('5','95','579','126604',2522512,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126604',2522513,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126604',2522514,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126604',2522515,'1638','220',197324.69,197374.21,49.52,11142.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126604',2522516,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126847',2527566,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126847',2527567,'1633','219',546859.42,548559.19,1699.77,243067.11,0.00,0.00,0.00,0.00,0.00),('5','95','578','126847',2527568,'1634','219',596734.40,598828.97,2094.57,299523.51,0.00,0.00,0.00,0.00,0.00),('5','95','579','126847',2527569,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126847',2527570,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126847',2527571,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126847',2527572,'1638','220',197374.21,197374.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126847',2527573,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126848',2527574,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126848',2527575,'1633','219',548559.19,548559.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126848',2527576,'1634','219',598828.97,598828.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126848',2527577,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126848',2527578,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126848',2527579,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126848',2527580,'1638','220',197374.21,197693.93,319.72,71937.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126848',2527581,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126849',2527582,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126849',2527583,'1633','219',548559.19,549275.22,716.03,102392.29,0.00,0.00,0.00,0.00,0.00),('5','95','578','126849',2527584,'1634','219',598828.97,599200.27,371.30,53095.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','126849',2527585,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126849',2527586,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126849',2527587,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126849',2527588,'1638','220',197693.93,197815.22,121.29,27290.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','126849',2527589,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126977',2529979,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126977',2529980,'1633','219',549275.22,549275.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126977',2529981,'1634','219',599200.27,599200.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126977',2529982,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126977',2529983,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126977',2529984,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126977',2529985,'1638','220',197815.22,198151.63,336.41,75692.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','126977',2529986,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126978',2529987,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126978',2529988,'1633','219',549275.22,550321.70,1046.48,149646.64,0.00,0.00,0.00,0.00,0.00),('5','95','578','126978',2529989,'1634','219',599200.27,600530.47,1330.20,190218.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','126978',2529990,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126978',2529991,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126978',2529992,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126978',2529993,'1638','220',198151.63,198267.76,116.13,26129.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','126978',2529994,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126979',2529995,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126979',2529996,'1633','219',550321.70,550868.36,546.66,78172.38,0.00,0.00,0.00,0.00,0.00),('5','95','578','126979',2529997,'1634','219',600530.47,600990.44,459.97,65775.71,0.00,0.00,0.00,0.00,0.00),('5','95','579','126979',2529998,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126979',2529999,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126979',2530000,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126979',2530001,'1638','220',198267.76,198382.22,114.46,25753.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','126979',2530002,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126980',2530003,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126980',2530004,'1633','219',550868.36,551690.44,822.08,117557.44,0.00,0.00,0.00,0.00,0.00),('5','95','578','126980',2530005,'1634','219',600990.44,601966.01,975.57,139506.51,0.00,0.00,0.00,0.00,0.00),('5','95','579','126980',2530006,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126980',2530007,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126980',2530008,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126980',2530009,'1638','220',198382.22,198416.63,34.41,7742.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','126980',2530010,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126981',2530011,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126981',2530012,'1633','219',551690.44,552166.69,476.25,68103.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','126981',2530013,'1634','219',601966.01,602372.26,406.25,58093.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','126981',2530014,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126981',2530015,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126981',2530016,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126981',2530017,'1638','220',198416.63,199379.62,962.99,216672.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','126981',2530018,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126982',2530019,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126982',2530020,'1633','219',552166.69,553265.82,1099.13,157175.59,0.00,0.00,0.00,0.00,0.00),('5','95','578','126982',2530021,'1634','219',602372.26,603436.05,1063.79,152121.97,0.00,0.00,0.00,0.00,0.00),('5','95','579','126982',2530022,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126982',2530023,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126982',2530024,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126982',2530025,'1638','220',199379.62,199790.75,411.13,92504.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','126982',2530026,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126983',2530027,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','126983',2530028,'1633','219',553265.82,553807.67,541.85,77484.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','126983',2530029,'1634','219',603436.05,603838.78,402.73,57590.39,0.00,0.00,0.00,0.00,0.00),('5','95','579','126983',2530030,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126983',2530031,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','126983',2530032,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','126983',2530033,'1638','220',199790.75,199808.23,17.48,3933.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','126983',2530034,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127115',2532182,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127115',2532183,'1633','219',553807.67,555058.21,1250.54,178827.22,0.00,0.00,0.00,0.00,0.00),('5','95','578','127115',2532184,'1634','219',603838.78,604982.88,1144.10,163606.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','127115',2532185,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127115',2532186,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127115',2532187,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127115',2532188,'1638','220',199808.23,199862.51,54.28,11670.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','127115',2532189,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127144',2532463,'1632','219',4207.31,4207.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127144',2532464,'1633','219',555058.21,555380.92,322.71,46147.53,0.00,0.00,0.00,0.00,0.00),('5','95','578','127144',2532465,'1634','219',604982.88,605652.48,669.60,95752.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','127144',2532466,'1635','219',642661.17,642661.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127144',2532467,'1636','219',2727799.64,2727799.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127144',2532468,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127144',2532469,'1638','220',199862.51,199956.11,93.60,20124.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','127144',2532470,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127195',2533434,'1632','219',4207.31,4237.85,30.54,4367.22,0.00,0.00,0.00,0.00,0.00),('5','95','578','127195',2533435,'1633','219',555380.92,556504.12,1123.20,160617.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','127195',2533436,'1634','219',605652.48,606840.87,1188.39,169939.77,0.00,0.00,0.00,0.00,0.00),('5','95','579','127195',2533437,'1635','219',642661.17,642684.26,23.09,3301.87,0.00,0.00,0.00,0.00,0.00),('5','95','579','127195',2533438,'1636','219',2727799.64,2729272.79,1473.15,210660.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','127195',2533439,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127195',2533440,'1638','220',199956.11,200797.46,841.35,180890.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','127195',2533441,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127236',2534300,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127236',2534301,'1633','219',556504.12,557013.10,508.98,72784.14,0.00,0.00,0.00,0.00,0.00),('5','95','578','127236',2534302,'1634','219',606840.87,607436.93,596.06,85236.58,0.00,0.00,0.00,0.00,0.00),('5','95','579','127236',2534303,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127236',2534304,'1636','219',2729272.79,2729854.55,581.76,83191.68,0.00,0.00,0.00,0.00,0.00),('5','95','579','127236',2534305,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127236',2534306,'1638','220',200797.46,200827.97,30.51,6559.65,0.00,0.00,0.00,0.00,0.00),('5','95','582','127236',2534307,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127237',2534308,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127237',2534309,'1633','219',557013.10,558018.36,1005.26,143752.18,0.00,0.00,0.00,0.00,0.00),('5','95','578','127237',2534310,'1634','219',607436.93,608391.65,954.72,136524.96,0.00,0.00,0.00,0.00,0.00),('5','95','579','127237',2534311,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127237',2534312,'1636','219',2729854.55,2730218.63,364.08,52063.44,0.00,0.00,0.00,0.00,0.00),('5','95','579','127237',2534313,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127237',2534314,'1638','220',200827.97,200945.82,117.85,25337.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','127237',2534315,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127238',2534316,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127238',2534317,'1633','219',558018.36,558387.88,369.52,52841.36,0.00,0.00,0.00,0.00,0.00),('5','95','578','127238',2534318,'1634','219',608391.65,609013.32,621.67,88898.81,0.00,0.00,0.00,0.00,0.00),('5','95','579','127238',2534319,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127238',2534320,'1636','219',2730218.63,2730450.32,231.69,33131.67,0.00,0.00,0.00,0.00,0.00),('5','95','579','127238',2534321,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127238',2534322,'1638','220',200945.82,200945.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','127238',2534323,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127239',2534324,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127239',2534325,'1633','219',558387.88,559062.50,674.62,96470.66,0.00,0.00,0.00,0.00,0.00),('5','95','578','127239',2534326,'1634','219',609013.32,609934.59,921.27,131741.61,0.00,0.00,0.00,0.00,0.00),('5','95','579','127239',2534327,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127239',2534328,'1636','219',2730450.32,2731259.12,808.80,115658.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','127239',2534329,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127239',2534330,'1638','220',200945.82,201066.42,120.60,25929.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','127239',2534331,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127240',2534332,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127240',2534333,'1633','219',559062.50,559406.68,344.18,49217.74,0.00,0.00,0.00,0.00,0.00),('5','95','578','127240',2534334,'1634','219',609934.59,610060.27,125.68,17972.24,0.00,0.00,0.00,0.00,0.00),('5','95','579','127240',2534335,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127240',2534336,'1636','219',2731259.12,2731558.72,299.60,42842.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','127240',2534337,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127240',2534338,'1638','220',201066.42,201150.12,83.70,17995.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','127240',2534339,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127241',2534340,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127241',2534341,'1633','219',559406.68,560553.87,1147.19,164048.17,0.00,0.00,0.00,0.00,0.00),('5','95','578','127241',2534342,'1634','219',610060.27,610946.62,886.35,126748.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','127241',2534343,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127241',2534344,'1636','219',2731558.72,2732002.33,443.61,63436.23,0.00,0.00,0.00,0.00,0.00),('5','95','579','127241',2534345,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127241',2534346,'1638','220',201150.12,201317.26,167.14,35935.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','127241',2534347,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127351',2536449,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127351',2536450,'1633','219',560553.87,560750.25,196.38,28082.34,0.00,0.00,0.00,0.00,0.00),('5','95','578','127351',2536451,'1634','219',610946.62,611530.37,583.75,83476.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','127351',2536452,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127351',2536453,'1636','219',2732002.33,2732399.84,397.51,56843.93,0.00,0.00,0.00,0.00,0.00),('5','95','579','127351',2536454,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127351',2536455,'1638','220',201317.26,201317.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','127351',2536456,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127457',2538707,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127457',2538708,'1633','219',560750.25,561466.74,716.49,102458.07,0.00,0.00,0.00,0.00,0.00),('5','95','578','127457',2538709,'1634','219',611530.37,612622.76,1092.39,156211.77,0.00,0.00,0.00,0.00,0.00),('5','95','579','127457',2538710,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127457',2538711,'1636','219',2732399.84,2732399.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127457',2538712,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127457',2538713,'1638','220',201317.26,201435.04,117.78,25322.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','127457',2538714,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127469',2538893,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127469',2538894,'1633','219',561466.74,561929.63,462.89,66193.27,0.00,0.00,0.00,0.00,0.00),('5','95','578','127469',2538895,'1634','219',612622.76,612921.03,298.27,42652.61,0.00,0.00,0.00,0.00,0.00),('5','95','579','127469',2538896,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127469',2538897,'1636','219',2732399.84,2733128.11,728.27,104142.61,0.00,0.00,0.00,0.00,0.00),('5','95','579','127469',2538898,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127469',2538899,'1638','220',201435.04,201457.81,22.77,4895.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','127469',2538900,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127546',2540536,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127546',2540537,'1633','219',561929.63,562909.15,979.52,140071.36,0.00,0.00,0.00,0.00,0.00),('5','95','578','127546',2540538,'1634','219',612921.03,614028.59,1107.56,158381.08,0.00,0.00,0.00,0.00,0.00),('5','95','579','127546',2540539,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127546',2540540,'1636','219',2733128.11,2733520.95,392.84,56176.12,0.00,0.00,0.00,0.00,0.00),('5','95','579','127546',2540541,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127546',2540542,'1638','220',201457.81,201457.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','127546',2540543,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127596',2541497,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127596',2541498,'1633','219',562909.15,563434.37,525.22,75106.46,0.00,0.00,0.00,0.00,0.00),('5','95','578','127596',2541499,'1634','219',614028.59,614321.89,293.30,41941.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','127596',2541500,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127596',2541501,'1636','219',2733520.95,2733657.30,136.35,19498.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','127596',2541502,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127596',2541503,'1638','220',201457.81,201832.49,374.68,80556.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','127596',2541504,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127718',2544349,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127718',2544350,'1633','219',563434.37,564419.05,984.68,140809.24,0.00,0.00,0.00,0.00,0.00),('5','95','578','127718',2544351,'1634','219',614321.89,615415.32,1093.43,156360.49,0.00,0.00,0.00,0.00,0.00),('5','95','579','127718',2544352,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127718',2544353,'1636','219',2733657.30,2734230.95,573.65,82031.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','127718',2544354,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127718',2544355,'1638','220',201832.49,204293.86,2461.37,529194.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','127718',2544356,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127721',2544424,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127721',2544425,'1633','219',564419.05,564965.86,546.81,78193.83,0.00,0.00,0.00,0.00,0.00),('5','95','578','127721',2544426,'1634','219',615415.32,615670.94,255.62,36553.66,0.00,0.00,0.00,0.00,0.00),('5','95','579','127721',2544427,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127721',2544428,'1636','219',2734230.95,2734698.92,467.97,66919.71,0.00,0.00,0.00,0.00,0.00),('5','95','579','127721',2544429,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127721',2544430,'1638','220',204293.86,205212.70,918.84,197550.60,0.00,0.00,0.00,0.00,0.00),('5','95','582','127721',2544431,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127945',2548933,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127945',2548934,'1633','219',564965.86,565314.75,348.89,49891.27,0.00,0.00,0.00,0.00,0.00),('5','95','578','127945',2548935,'1634','219',615670.94,616010.19,339.25,48512.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','127945',2548936,'1635','219',642684.26,642684.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127945',2548937,'1636','219',2734698.92,2735648.73,949.81,135822.83,0.00,0.00,0.00,0.00,0.00),('5','95','579','127945',2548938,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127945',2548939,'1638','220',205212.70,205391.44,178.74,38429.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','127945',2548940,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127946',2548941,'1632','219',4237.85,4237.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127946',2548942,'1633','219',565314.75,565314.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127946',2548943,'1634','219',616010.19,616010.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127946',2548944,'1635','219',642684.26,644253.71,1569.45,224431.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','127946',2548945,'1636','219',2735648.73,2736287.04,638.31,91278.33,0.00,0.00,0.00,0.00,0.00),('5','95','579','127946',2548946,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127946',2548947,'1638','220',205391.44,205391.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','127946',2548948,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127947',2548949,'1632','219',4237.85,4331.53,93.68,13396.24,0.00,0.00,0.00,0.00,0.00),('5','95','578','127947',2548950,'1633','219',565314.75,565314.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127947',2548951,'1634','219',616010.19,616721.08,710.89,101657.27,0.00,0.00,0.00,0.00,0.00),('5','95','579','127947',2548952,'1635','219',644253.71,645213.25,959.54,137214.22,0.00,0.00,0.00,0.00,0.00),('5','95','579','127947',2548953,'1636','219',2736287.04,2739016.37,2729.33,390294.19,0.00,0.00,0.00,0.00,0.00),('5','95','579','127947',2548954,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127947',2548955,'1638','220',205391.44,205721.86,330.42,71040.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','127947',2548956,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127948',2548957,'1632','219',4331.53,4331.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','127948',2548958,'1633','219',565314.75,565723.03,408.28,58384.04,0.00,0.00,0.00,0.00,0.00),('5','95','578','127948',2548959,'1634','219',616721.08,617372.12,651.04,93098.72,0.00,0.00,0.00,0.00,0.00),('5','95','579','127948',2548960,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127948',2548961,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','127948',2548962,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','127948',2548963,'1638','220',205721.86,205784.17,62.31,13396.65,0.00,0.00,0.00,0.00,0.00),('5','95','582','127948',2548964,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128044',2550910,'1632','219',4331.53,4524.30,192.77,27566.11,0.00,0.00,0.00,0.00,0.00),('5','95','578','128044',2550911,'1633','219',565723.03,566466.99,743.96,106386.28,0.00,0.00,0.00,0.00,0.00),('5','95','578','128044',2550912,'1634','219',617372.12,618481.63,1109.51,158659.93,0.00,0.00,0.00,0.00,0.00),('5','95','579','128044',2550913,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128044',2550914,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128044',2550915,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128044',2550916,'1638','220',205784.17,206520.55,736.38,158321.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','128044',2550917,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128228',2554911,'1632','219',4524.30,4524.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128228',2554912,'1633','219',566466.99,566914.65,447.66,64015.38,0.00,0.00,0.00,0.00,0.00),('5','95','578','128228',2554913,'1634','219',618481.63,618957.00,475.37,67977.91,0.00,0.00,0.00,0.00,0.00),('5','95','579','128228',2554914,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128228',2554915,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128228',2554916,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128228',2554917,'1638','220',206520.55,206520.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','128228',2554918,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128230',2554932,'1632','219',4524.30,4534.42,10.12,1447.16,0.00,0.00,0.00,0.00,0.00),('5','95','578','128230',2554933,'1633','219',566914.65,568127.85,1213.20,173487.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','128230',2554934,'1634','219',618957.00,620172.73,1215.73,173849.39,0.00,0.00,0.00,0.00,0.00),('5','95','579','128230',2554935,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128230',2554936,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128230',2554937,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128230',2554938,'1638','220',206520.55,206723.76,203.21,43690.15,0.00,0.00,0.00,0.00,0.00),('5','95','582','128230',2554939,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128231',2554940,'1632','219',4534.42,4534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128231',2554941,'1633','219',568127.85,568752.63,624.78,89343.54,0.00,0.00,0.00,0.00,0.00),('5','95','578','128231',2554942,'1634','219',620172.73,620711.05,538.32,76979.76,0.00,0.00,0.00,0.00,0.00),('5','95','579','128231',2554943,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128231',2554944,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128231',2554945,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128231',2554946,'1638','220',206723.76,207331.64,607.88,130694.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','128231',2554947,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128232',2554948,'1632','219',4534.42,4534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128232',2554949,'1633','219',568752.63,569521.39,768.76,109932.68,0.00,0.00,0.00,0.00,0.00),('5','95','578','128232',2554950,'1634','219',620711.05,621511.87,800.82,114517.26,0.00,0.00,0.00,0.00,0.00),('5','95','579','128232',2554951,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128232',2554952,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128232',2554953,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128232',2554954,'1638','220',207331.64,207425.59,93.95,20199.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','128232',2554955,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128275',2555709,'1632','219',4534.42,4534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128275',2555710,'1633','219',569521.39,570006.32,484.93,69344.99,0.00,0.00,0.00,0.00,0.00),('5','95','578','128275',2555711,'1634','219',621511.87,621975.72,463.85,66330.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','128275',2555712,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128275',2555713,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128275',2555714,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128275',2555715,'1638','220',207425.59,207485.22,59.63,12820.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','128275',2555716,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128891',2569036,'1632','219',4534.42,4534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128891',2569037,'1633','219',570006.32,570992.74,986.42,141058.06,0.00,0.00,0.00,0.00,0.00),('5','95','578','128891',2569038,'1634','219',621975.72,623142.72,1167.00,166881.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128891',2569039,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128891',2569040,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128891',2569041,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128891',2569042,'1638','220',207485.22,207526.15,40.93,8799.95,0.00,0.00,0.00,0.00,0.00),('5','95','582','128891',2569043,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128896',2569163,'1632','219',4534.42,4534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128896',2569164,'1633','219',570992.74,570992.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128896',2569165,'1634','219',623142.72,623142.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128896',2569166,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128896',2569167,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128896',2569168,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128896',2569169,'1638','220',207526.15,207526.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','128896',2569170,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128921',2569574,'1632','219',4534.42,4534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','128921',2569575,'1633','219',570992.74,571597.04,604.30,86414.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','128921',2569576,'1634','219',623142.72,623702.39,559.67,80032.81,0.00,0.00,0.00,0.00,0.00),('5','95','579','128921',2569577,'1635','219',645213.25,645213.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128921',2569578,'1636','219',2739016.37,2739016.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','128921',2569579,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','128921',2569580,'1638','220',207526.15,207578.78,52.63,11315.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','128921',2569581,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','129629',2583392,'1632','219',4534.42,4534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','129629',2583393,'1633','219',571597.04,572311.76,714.72,102204.96,0.00,0.00,0.00,0.00,0.00),('5','95','578','129629',2583394,'1634','219',623702.39,624030.40,328.01,46905.43,0.00,0.00,0.00,0.00,0.00),('5','95','579','129629',2583395,'1635','219',645213.25,645771.25,558.00,79794.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','129629',2583396,'1636','219',2739016.37,2740815.36,1798.99,257255.57,0.00,0.00,0.00,0.00,0.00),('5','95','579','129629',2583397,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','129629',2583398,'1638','220',207578.78,207654.54,75.76,16288.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','129629',2583399,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181548',3565352,'1632','219',4534.42,4534.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181548',3565353,'1633','219',572311.76,572311.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181548',3565354,'1634','219',624030.40,624030.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181548',3565355,'1635','219',645771.25,645771.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181548',3565356,'1636','219',2740815.36,2740815.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181548',3565357,'1637','219',3875878.58,3875878.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','181548',3565358,'1638','220',207654.54,207654.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','181548',3565359,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181637',3566861,'1632','219',253436.34,253436.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181637',3566862,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181637',3566863,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181637',3566864,'1635','219',897546.38,897546.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181637',3566865,'1636','219',3072579.37,3072579.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181637',3566866,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','181637',3566867,'1638','220',410128.40,410128.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','181637',3566868,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181662',3567381,'1632','219',253436.34,253436.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181662',3567382,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181662',3567383,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181662',3567384,'1635','219',897546.38,902054.81,4508.43,734874.09,0.00,0.00,0.00,0.00,0.00),('5','95','579','181662',3567385,'1636','219',3072579.37,3076920.23,4340.86,707560.18,0.00,0.00,0.00,0.00,0.00),('5','95','580','181662',3567386,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','181662',3567387,'1638','220',410128.40,410255.23,126.83,31707.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','181662',3567388,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181814',3569991,'1632','219',253436.34,253436.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181814',3569992,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181814',3569993,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181814',3569994,'1635','219',902054.81,902054.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181814',3569995,'1636','219',3076920.23,3076920.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','181814',3569996,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','181814',3569997,'1638','220',410255.23,410255.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','181814',3569998,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181890',3571321,'1632','219',253436.34,253436.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181890',3571322,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','181890',3571323,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','181890',3571324,'1635','219',902054.81,903681.02,1626.21,265072.23,0.00,0.00,0.00,0.00,0.00),('5','95','579','181890',3571325,'1636','219',3076920.23,3079064.64,2144.41,349538.83,0.00,0.00,0.00,0.00,0.00),('5','95','580','181890',3571326,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','181890',3571327,'1638','220',410255.23,410585.23,330.00,82500.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','181890',3571328,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182041',3574182,'1632','219',253436.34,253436.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182041',3574183,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182041',3574184,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','182041',3574185,'1635','219',903681.02,905335.25,1654.23,269639.49,0.00,0.00,0.00,0.00,0.00),('5','95','579','182041',3574186,'1636','219',3079064.64,3081224.03,2159.39,351980.57,0.00,0.00,0.00,0.00,0.00),('5','95','580','182041',3574187,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','182041',3574188,'1638','220',410585.23,410799.57,214.34,53585.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','182041',3574189,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182180',3576663,'1632','219',253436.34,255765.54,2329.20,379659.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','182180',3576664,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182180',3576665,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','182180',3576666,'1635','219',905335.25,907576.88,2241.63,365385.69,0.00,0.00,0.00,0.00,0.00),('5','95','579','182180',3576667,'1636','219',3081224.03,3084448.82,3224.79,525640.77,0.00,0.00,0.00,0.00,0.00),('5','95','580','182180',3576668,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','182180',3576669,'1638','220',410799.57,411779.16,979.59,244897.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','182180',3576670,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182436',3581280,'1632','219',255765.54,257870.93,2105.39,343178.57,0.00,0.00,0.00,0.00,0.00),('5','95','578','182436',3581281,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182436',3581282,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','182436',3581283,'1635','219',907576.88,909055.69,1478.81,241046.03,0.00,0.00,0.00,0.00,0.00),('5','95','579','182436',3581284,'1636','219',3084448.82,3085951.51,1502.69,244938.47,0.00,0.00,0.00,0.00,0.00),('5','95','580','182436',3581285,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','182436',3581286,'1638','220',411779.16,412265.80,486.64,121660.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','182436',3581287,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182568',3583548,'1632','219',257870.93,261053.37,3182.44,518737.72,0.00,0.00,0.00,0.00,0.00),('5','95','578','182568',3583549,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182568',3583550,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','182568',3583551,'1635','219',909055.69,911357.73,2302.04,375232.52,0.00,0.00,0.00,0.00,0.00),('5','95','579','182568',3583552,'1636','219',3085951.51,3088529.98,2578.47,420290.61,0.00,0.00,0.00,0.00,0.00),('5','95','580','182568',3583553,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','182568',3583554,'1638','220',412265.80,412863.47,597.67,149417.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','182568',3583555,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182759',3587217,'1632','219',261053.37,263758.43,2705.06,440924.78,0.00,0.00,0.00,0.00,0.00),('5','95','578','182759',3587218,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182759',3587219,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','182759',3587220,'1635','219',911357.73,914052.04,2694.31,439172.53,0.00,0.00,0.00,0.00,0.00),('5','95','579','182759',3587221,'1636','219',3088529.98,3090486.13,1956.15,318852.45,0.00,0.00,0.00,0.00,0.00),('5','95','580','182759',3587222,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','182759',3587223,'1638','220',412863.47,413712.77,849.30,212325.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','182759',3587224,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182865',3589164,'1632','219',263758.43,265618.33,1859.90,303163.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','182865',3589165,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','182865',3589166,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','182865',3589167,'1635','219',914052.04,915508.24,1456.20,237360.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','182865',3589168,'1636','219',3090486.13,3091664.83,1178.70,192128.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','182865',3589169,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','182865',3589170,'1638','220',413712.77,413913.50,200.73,53193.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','182865',3589171,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','183083',3593339,'1632','219',265618.33,268177.12,2558.79,417082.77,0.00,0.00,0.00,0.00,0.00),('5','95','578','183083',3593340,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','183083',3593341,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','183083',3593342,'1635','219',915508.24,917373.11,1864.87,303973.81,0.00,0.00,0.00,0.00,0.00),('5','95','579','183083',3593343,'1636','219',3091664.83,3092862.65,1197.82,195244.66,0.00,0.00,0.00,0.00,0.00),('5','95','580','183083',3593344,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','183083',3593345,'1638','220',413913.50,414208.81,295.31,78257.15,0.00,0.00,0.00,0.00,0.00),('5','95','582','183083',3593346,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','183378',3598623,'1632','219',268177.12,270712.26,2535.14,413227.82,0.00,0.00,0.00,0.00,0.00),('5','95','578','183378',3598624,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','183378',3598625,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','183378',3598626,'1635','219',917373.11,919928.55,2555.44,416536.72,0.00,0.00,0.00,0.00,0.00),('5','95','579','183378',3598627,'1636','219',3092862.65,3092862.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','183378',3598628,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','183378',3598629,'1638','220',414208.81,414562.73,353.92,93788.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','183378',3598630,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','183629',3603182,'1632','219',270712.26,274089.60,3377.34,550506.42,0.00,0.00,0.00,0.00,0.00),('5','95','578','183629',3603183,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','183629',3603184,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','183629',3603185,'1635','219',919928.55,922102.54,2173.99,354360.37,0.00,0.00,0.00,0.00,0.00),('5','95','579','183629',3603186,'1636','219',3092862.65,3092862.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','183629',3603187,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','183629',3603188,'1638','220',414562.73,415369.80,807.07,213873.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','183629',3603189,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','183859',3607421,'1632','219',274089.60,276558.39,2468.79,402412.77,0.00,0.00,0.00,0.00,0.00),('5','95','578','183859',3607422,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','183859',3607423,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','183859',3607424,'1635','219',922102.54,924179.89,2077.35,338608.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','183859',3607425,'1636','219',3092862.65,3094632.12,1769.47,288423.61,0.00,0.00,0.00,0.00,0.00),('5','95','580','183859',3607426,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','183859',3607427,'1638','220',415369.80,415736.53,366.73,97183.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','183859',3607428,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184016',3610074,'1632','219',276558.39,281125.99,4567.60,744518.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','184016',3610075,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184016',3610076,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','184016',3610077,'1635','219',924179.89,927380.95,3201.06,521772.78,0.00,0.00,0.00,0.00,0.00),('5','95','579','184016',3610078,'1636','219',3094632.12,3098021.55,3389.43,552477.09,0.00,0.00,0.00,0.00,0.00),('5','95','580','184016',3610079,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','184016',3610080,'1638','220',415736.53,416098.77,362.24,92371.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','184016',3610081,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184116',3611909,'1632','219',281125.99,286834.05,5708.06,930413.78,0.00,0.00,0.00,0.00,0.00),('5','95','578','184116',3611910,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184116',3611911,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','184116',3611912,'1635','219',927380.95,927380.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','184116',3611913,'1636','219',3098021.55,3098478.68,457.13,74512.19,0.00,0.00,0.00,0.00,0.00),('5','95','580','184116',3611914,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','184116',3611915,'1638','220',416098.77,416868.78,770.01,196352.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','184116',3611916,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184388',3616622,'1632','219',286834.05,290760.85,3926.80,640068.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','184388',3616623,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184388',3616624,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','184388',3616625,'1635','219',927380.95,927851.35,470.40,76675.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','184388',3616626,'1636','219',3098478.68,3099198.07,719.39,117260.57,0.00,0.00,0.00,0.00,0.00),('5','95','580','184388',3616627,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','184388',3616628,'1638','220',416868.78,417985.02,1116.24,284641.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','184388',3616629,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184630',3621214,'1632','219',290760.85,292738.42,1977.57,322343.91,0.00,0.00,0.00,0.00,0.00),('5','95','578','184630',3621215,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184630',3621216,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','184630',3621217,'1635','219',927851.35,929245.19,1393.84,227195.92,0.00,0.00,0.00,0.00,0.00),('5','95','579','184630',3621218,'1636','219',3099198.07,3100950.86,1752.79,285704.77,0.00,0.00,0.00,0.00,0.00),('5','95','580','184630',3621219,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','184630',3621220,'1638','220',417985.02,418560.82,575.80,146829.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','184630',3621221,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184760',3623388,'1632','219',292738.42,294474.65,1736.23,283005.49,0.00,0.00,0.00,0.00,0.00),('5','95','578','184760',3623389,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','184760',3623390,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','184760',3623391,'1635','219',929245.19,930563.47,1318.28,214879.64,0.00,0.00,0.00,0.00,0.00),('5','95','579','184760',3623392,'1636','219',3100950.86,3102854.65,1903.79,310317.77,0.00,0.00,0.00,0.00,0.00),('5','95','580','184760',3623393,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','184760',3623394,'1638','220',418560.82,419735.87,1175.05,299637.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','184760',3623395,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185001',3627603,'1632','219',294474.65,295773.47,1298.82,211707.66,0.00,0.00,0.00,0.00,0.00),('5','95','578','185001',3627604,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185001',3627605,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','185001',3627606,'1635','219',930563.47,932096.62,1533.15,249903.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','185001',3627607,'1636','219',3102854.65,3104332.95,1478.30,240962.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','185001',3627608,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','185001',3627609,'1638','220',419735.87,422979.96,3244.09,859683.85,0.00,0.00,0.00,0.00,0.00),('5','95','582','185001',3627610,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185166',3630420,'1632','219',295773.47,295773.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185166',3630421,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185166',3630422,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','185166',3630423,'1635','219',932096.62,933916.16,1819.54,296585.02,0.00,0.00,0.00,0.00,0.00),('5','95','579','185166',3630424,'1636','219',3104332.95,3106400.47,2067.52,337005.76,0.00,0.00,0.00,0.00,0.00),('5','95','580','185166',3630425,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','185166',3630426,'1638','220',422979.96,423318.94,338.98,89829.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','185166',3630427,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185307',3632652,'1632','219',295773.47,295773.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185307',3632653,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185307',3632654,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','185307',3632655,'1635','219',933916.16,933916.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','185307',3632656,'1636','219',3106400.47,3106974.78,574.31,93612.53,0.00,0.00,0.00,0.00,0.00),('5','95','580','185307',3632657,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','185307',3632658,'1638','220',423318.94,423705.45,386.51,102425.15,0.00,0.00,0.00,0.00,0.00),('5','95','582','185307',3632659,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185606',3638394,'1632','219',295773.47,295773.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185606',3638395,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185606',3638396,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','185606',3638397,'1635','219',933916.16,933916.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','185606',3638398,'1636','219',3106974.78,3106974.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','185606',3638399,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','185606',3638400,'1638','220',423705.45,424194.94,489.49,129714.85,0.00,0.00,0.00,0.00,0.00),('5','95','582','185606',3638401,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185701',3639874,'1632','219',295773.47,297390.01,1616.54,263496.02,0.00,0.00,0.00,0.00,0.00),('5','95','578','185701',3639875,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185701',3639876,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','185701',3639877,'1635','219',933916.16,934806.03,889.87,145048.81,0.00,0.00,0.00,0.00,0.00),('5','95','579','185701',3639878,'1636','219',3106974.78,3107981.05,1006.27,164022.01,0.00,0.00,0.00,0.00,0.00),('5','95','580','185701',3639879,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','185701',3639880,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','185701',3639881,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185999',3645331,'1632','219',297390.01,299090.95,1700.94,277253.22,0.00,0.00,0.00,0.00,0.00),('5','95','578','185999',3645332,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','185999',3645333,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','185999',3645334,'1635','219',934806.03,935623.63,817.60,133268.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','185999',3645335,'1636','219',3107981.05,3109264.67,1283.62,209230.06,0.00,0.00,0.00,0.00,0.00),('5','95','580','185999',3645336,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','185999',3645337,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','185999',3645338,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','186192',3648542,'1632','219',299090.95,300472.19,1381.24,225142.12,0.00,0.00,0.00,0.00,0.00),('5','95','578','186192',3648543,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','186192',3648544,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','186192',3648545,'1635','219',935623.63,936825.95,1202.32,195978.16,0.00,0.00,0.00,0.00,0.00),('5','95','579','186192',3648546,'1636','219',3109264.67,3110389.71,1125.04,183381.52,0.00,0.00,0.00,0.00,0.00),('5','95','580','186192',3648547,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','186192',3648548,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','186192',3648549,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','186382',3651653,'1632','219',300472.19,302367.11,1894.92,308871.96,0.00,0.00,0.00,0.00,0.00),('5','95','578','186382',3651654,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','186382',3651655,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','186382',3651656,'1635','219',936825.95,938060.79,1234.84,201278.92,0.00,0.00,0.00,0.00,0.00),('5','95','579','186382',3651657,'1636','219',3110389.71,3111303.31,913.60,148916.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','186382',3651658,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','186382',3651659,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','186382',3651660,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','186597',3655470,'1632','219',302367.11,304429.25,2062.14,336128.82,0.00,0.00,0.00,0.00,0.00),('5','95','578','186597',3655471,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','186597',3655472,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','186597',3655473,'1635','219',938060.79,939123.78,1062.99,173267.37,0.00,0.00,0.00,0.00,0.00),('5','95','579','186597',3655474,'1636','219',3111303.31,3112583.29,1279.98,208636.74,0.00,0.00,0.00,0.00,0.00),('5','95','580','186597',3655475,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','186597',3655476,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','186597',3655477,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','186931',3661077,'1632','219',304429.25,306137.55,1708.30,278452.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','186931',3661078,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','186931',3661079,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','186931',3661080,'1635','219',939123.78,940426.89,1303.11,212406.93,0.00,0.00,0.00,0.00,0.00),('5','95','579','186931',3661081,'1636','219',3112583.29,3114691.96,2108.67,343713.21,0.00,0.00,0.00,0.00,0.00),('5','95','580','186931',3661082,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','186931',3661083,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','186931',3661084,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187122',3664488,'1632','219',306137.55,308016.32,1878.77,306239.51,0.00,0.00,0.00,0.00,0.00),('5','95','578','187122',3664489,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187122',3664490,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','187122',3664491,'1635','219',940426.89,941154.56,727.67,118610.21,0.00,0.00,0.00,0.00,0.00),('5','95','579','187122',3664492,'1636','219',3114691.96,3115879.43,1187.47,193557.61,0.00,0.00,0.00,0.00,0.00),('5','95','580','187122',3664493,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','187122',3664494,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','187122',3664495,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187157',3665008,'1632','219',308016.32,309409.88,1393.56,227150.28,0.00,0.00,0.00,0.00,0.00),('5','95','578','187157',3665009,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187157',3665010,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','187157',3665011,'1635','219',941154.56,942504.74,1350.18,220079.34,0.00,0.00,0.00,0.00,0.00),('5','95','579','187157',3665012,'1636','219',3115879.43,3118555.43,2676.00,436188.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','187157',3665013,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','187157',3665014,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','187157',3665015,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187525',3671661,'1632','219',309409.88,310868.11,1458.23,237691.49,0.00,0.00,0.00,0.00,0.00),('5','95','578','187525',3671662,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187525',3671663,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','187525',3671664,'1635','219',942504.74,943754.80,1250.06,203759.78,0.00,0.00,0.00,0.00,0.00),('5','95','579','187525',3671665,'1636','219',3118555.43,3121271.64,2716.21,442742.23,0.00,0.00,0.00,0.00,0.00),('5','95','580','187525',3671666,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','187525',3671667,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','187525',3671668,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187628',3673302,'1632','219',310868.11,310932.60,64.49,10511.87,0.00,0.00,0.00,0.00,0.00),('5','95','578','187628',3673303,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187628',3673304,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','187628',3673305,'1635','219',943754.80,945622.75,1867.95,304475.85,0.00,0.00,0.00,0.00,0.00),('5','95','579','187628',3673306,'1636','219',3121271.64,3122600.34,1328.70,216578.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','187628',3673307,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','187628',3673308,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','187628',3673309,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187832',3676867,'1632','219',310932.60,311907.92,975.32,158977.16,0.00,0.00,0.00,0.00,0.00),('5','95','578','187832',3676868,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','187832',3676869,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','187832',3676870,'1635','219',945622.75,947378.85,1756.10,286244.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','187832',3676871,'1636','219',3122600.34,3124477.14,1876.80,305918.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','187832',3676872,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','187832',3676873,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','187832',3676874,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188073',3681092,'1632','219',311907.92,313697.52,1789.60,291704.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','188073',3681093,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188073',3681094,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188073',3681095,'1635','219',947378.85,948923.06,1544.21,251706.23,0.00,0.00,0.00,0.00,0.00),('5','95','579','188073',3681096,'1636','219',3124477.14,3126246.06,1768.92,288333.96,0.00,0.00,0.00,0.00,0.00),('5','95','580','188073',3681097,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','188073',3681098,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','188073',3681099,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188220',3683687,'1632','219',313697.52,319164.13,5466.61,891057.43,0.00,0.00,0.00,0.00,0.00),('5','95','578','188220',3683688,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188220',3683689,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188220',3683690,'1635','219',948923.06,949856.05,932.99,152077.37,0.00,0.00,0.00,0.00,0.00),('5','95','579','188220',3683691,'1636','219',3126246.06,3128344.32,2098.26,342016.38,0.00,0.00,0.00,0.00,0.00),('5','95','580','188220',3683692,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','188220',3683693,'1638','220',424194.94,424194.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','188220',3683694,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188467',3687899,'1632','219',319164.13,325277.85,6113.72,996536.36,0.00,0.00,0.00,0.00,0.00),('5','95','578','188467',3687900,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188467',3687901,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188467',3687902,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188467',3687903,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','188467',3687904,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','188467',3687905,'1638','220',424194.94,424205.04,10.10,2676.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','188467',3687906,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188763',3693202,'1632','219',325277.85,330147.18,4869.33,793700.79,0.00,0.00,0.00,0.00,0.00),('5','95','578','188763',3693203,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188763',3693204,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188763',3693205,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188763',3693206,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','188763',3693207,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','188763',3693208,'1638','220',424205.04,424330.75,125.71,33313.15,0.00,0.00,0.00,0.00,0.00),('5','95','582','188763',3693209,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188798',3693897,'1632','219',330147.18,335616.50,5469.32,891499.16,0.00,0.00,0.00,0.00,0.00),('5','95','578','188798',3693898,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188798',3693899,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188798',3693900,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188798',3693901,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','188798',3693902,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','188798',3693903,'1638','220',424330.75,424532.51,201.76,53466.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','188798',3693904,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188993',3697431,'1632','219',335616.50,340436.81,4820.31,785710.53,0.00,0.00,0.00,0.00,0.00),('5','95','578','188993',3697432,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','188993',3697433,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188993',3697434,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','188993',3697435,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','188993',3697436,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','188993',3697437,'1638','220',424532.51,424717.94,185.43,49138.95,0.00,0.00,0.00,0.00,0.00),('5','95','582','188993',3697438,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189290',3702648,'1632','219',340436.81,345245.19,4808.38,783765.94,0.00,0.00,0.00,0.00,0.00),('5','95','578','189290',3702649,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189290',3702650,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','189290',3702651,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','189290',3702652,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','189290',3702653,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','189290',3702654,'1638','220',424717.94,427061.53,2343.59,621051.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','189290',3702655,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189416',3705025,'1632','219',345245.19,350282.68,5037.49,821110.87,0.00,0.00,0.00,0.00,0.00),('5','95','578','189416',3705026,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189416',3705027,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','189416',3705028,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','189416',3705029,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','189416',3705030,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','189416',3705031,'1638','220',427061.53,427897.88,836.35,221632.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','189416',3705032,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189662',3709132,'1632','219',350282.68,350282.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189662',3709133,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189662',3709134,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','189662',3709135,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','189662',3709136,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','189662',3709137,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','189662',3709138,'1638','220',427897.88,429559.60,1661.72,440355.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','189662',3709139,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189859',3712529,'1632','219',350282.68,350282.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189859',3712530,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','189859',3712531,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','189859',3712532,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','189859',3712533,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','189859',3712534,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','189859',3712535,'1638','220',429559.60,429700.78,141.18,37412.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','189859',3712536,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190194',3719528,'1632','219',350282.68,350282.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190194',3719529,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190194',3719530,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190194',3719531,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190194',3719532,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','190194',3719533,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','190194',3719534,'1638','220',429700.78,430912.30,1211.52,321052.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','190194',3719535,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190250',3720223,'1632','219',350282.68,350282.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190250',3720224,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190250',3720225,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190250',3720226,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190250',3720227,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','190250',3720228,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','190250',3720229,'1638','220',430912.30,433804.62,2892.32,766464.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','190250',3720230,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190511',3724951,'1632','219',350282.68,352775.20,2492.52,411265.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','190511',3724952,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190511',3724953,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190511',3724954,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190511',3724955,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','190511',3724956,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','190511',3724957,'1638','220',433804.62,437966.46,4161.84,1102887.60,0.00,0.00,0.00,0.00,0.00),('5','95','582','190511',3724958,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190767',3729984,'1632','219',352775.20,355655.75,2880.55,475290.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','190767',3729985,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190767',3729986,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190767',3729987,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190767',3729988,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','190767',3729989,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','190767',3729990,'1638','220',437966.46,441748.05,3781.59,1002121.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','190767',3729991,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190970',3733467,'1632','219',355655.75,358826.48,3170.73,523170.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','190970',3733468,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','190970',3733469,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190970',3733470,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','190970',3733471,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','190970',3733472,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','190970',3733473,'1638','220',441748.05,445664.42,3916.37,1037838.05,0.00,0.00,0.00,0.00,0.00),('5','95','582','190970',3733474,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191126',3736207,'1632','219',358826.48,362346.73,3520.25,580841.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','191126',3736208,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191126',3736209,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191126',3736210,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191126',3736211,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','191126',3736212,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','191126',3736213,'1638','220',445664.42,448222.69,2558.27,677941.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','191126',3736214,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191301',3739350,'1632','219',362346.73,364826.02,2479.29,409082.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','191301',3739351,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191301',3739352,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191301',3739353,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191301',3739354,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','191301',3739355,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','191301',3739356,'1638','220',448222.69,448859.26,636.57,168691.05,0.00,0.00,0.00,0.00,0.00),('5','95','582','191301',3739357,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191579',3744389,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191579',3744390,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191579',3744391,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191579',3744392,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191579',3744393,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','191579',3744394,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','191579',3744395,'1638','220',448859.26,449433.05,573.79,152054.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','191579',3744396,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191917',3751330,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191917',3751331,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191917',3751332,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191917',3751333,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191917',3751334,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','191917',3751335,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','191917',3751336,'1638','220',449433.05,449973.18,540.13,143134.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','191917',3751337,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191972',3751979,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191972',3751980,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','191972',3751981,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191972',3751982,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','191972',3751983,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','191972',3751984,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','191972',3751985,'1638','220',449973.18,451489.56,1516.38,401840.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','191972',3751986,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192176',3755634,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192176',3755635,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192176',3755636,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','192176',3755637,'1635','219',949856.05,949856.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','192176',3755638,'1636','219',3128344.32,3128344.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','192176',3755639,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','192176',3755640,'1638','220',451489.56,451519.34,29.78,7891.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','192176',3755641,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192368',3759187,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192368',3759188,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192368',3759189,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','192368',3759190,'1635','219',949856.05,950957.55,1101.50,181747.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','192368',3759191,'1636','219',3128344.32,3129418.59,1074.27,177254.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','192368',3759192,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','192368',3759193,'1638','220',451519.34,452328.74,809.40,214491.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','192368',3759194,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192632',3763924,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192632',3763925,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192632',3763926,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','192632',3763927,'1635','219',950957.55,952306.88,1349.33,222639.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','192632',3763928,'1636','219',3129418.59,3130598.35,1179.76,194660.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','192632',3763929,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','192632',3763930,'1638','220',452328.74,453510.42,1181.68,313145.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','192632',3763931,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192784',3766579,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192784',3766580,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','192784',3766581,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','192784',3766582,'1635','219',952306.88,953565.55,1258.67,207680.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','192784',3766583,'1636','219',3130598.35,3131720.19,1121.84,185103.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','192784',3766584,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','192784',3766585,'1638','220',453510.42,454775.80,1265.38,335325.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','192784',3766586,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193033',3771291,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193033',3771292,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193033',3771293,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','193033',3771294,'1635','219',953565.55,954673.82,1108.27,182864.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','193033',3771295,'1636','219',3131720.19,3132470.07,749.88,123730.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','193033',3771296,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','193033',3771297,'1638','220',454775.80,455867.60,1091.80,289327.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','193033',3771298,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193240',3775166,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193240',3775167,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193240',3775168,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','193240',3775169,'1635','219',954673.82,956902.21,2228.39,367684.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','193240',3775170,'1636','219',3132470.07,3136701.41,4231.34,698171.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','193240',3775171,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','193240',3775172,'1638','220',455867.60,457645.20,1777.60,471064.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','193240',3775173,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193558',3781657,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193558',3781658,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193558',3781659,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','193558',3781660,'1635','219',956902.21,958963.15,2060.94,340055.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','193558',3781661,'1636','219',3136701.41,3138845.51,2144.10,353776.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','193558',3781662,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','193558',3781663,'1638','220',457645.20,459031.99,1386.79,367499.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','193558',3781664,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193731',3784758,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193731',3784759,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193731',3784760,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','193731',3784761,'1635','219',958963.15,959806.30,843.15,139119.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','193731',3784762,'1636','219',3138845.51,3141238.79,2393.28,394891.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','193731',3784763,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','193731',3784764,'1638','220',459031.99,460000.42,968.43,256633.95,0.00,0.00,0.00,0.00,0.00),('5','95','582','193731',3784765,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193973',3789056,'1632','219',364826.02,364826.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193973',3789057,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','193973',3789058,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','193973',3789059,'1635','219',959806.30,961662.94,1856.64,306345.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','193973',3789060,'1636','219',3141238.79,3141914.06,675.27,111419.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','193973',3789061,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','193973',3789062,'1638','220',460000.42,460808.55,808.13,214154.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','193973',3789063,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','194178',3792607,'1632','219',364826.02,367155.53,2329.51,384369.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','194178',3792608,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','194178',3792609,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','194178',3792610,'1635','219',961662.94,962392.47,729.53,120372.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','194178',3792611,'1636','219',3141914.06,3142274.88,360.82,59535.30,0.00,0.00,0.00,0.00,0.00),('5','95','580','194178',3792612,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','194178',3792613,'1638','220',460808.55,460884.18,75.63,20041.95,0.00,0.00,0.00,0.00,0.00),('5','95','582','194178',3792614,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','194464',3798039,'1632','219',367155.53,369806.89,2651.36,437474.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','194464',3798040,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','194464',3798041,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','194464',3798042,'1635','219',962392.47,962392.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','194464',3798043,'1636','219',3142274.88,3142573.19,298.31,49221.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','194464',3798044,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','194464',3798045,'1638','220',460884.18,462404.64,1520.46,402921.90,0.00,0.00,0.00,0.00,0.00),('5','95','582','194464',3798046,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','194473',3798191,'1632','219',369806.89,372776.01,2969.12,489904.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','194473',3798192,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','194473',3798193,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','194473',3798194,'1635','219',962392.47,962392.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','194473',3798195,'1636','219',3142573.19,3142573.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','194473',3798196,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','194473',3798197,'1638','220',462404.64,463119.83,715.19,189525.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','194473',3798198,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','194867',3805670,'1632','219',372776.01,376036.33,3260.32,537952.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','194867',3805671,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','194867',3805672,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','194867',3805673,'1635','219',962392.47,962392.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','194867',3805674,'1636','219',3142573.19,3142573.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','194867',3805675,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','194867',3805676,'1638','220',463119.83,464232.02,1112.19,294730.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','194867',3805677,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195064',3809170,'1632','219',376036.33,379903.91,3867.58,638150.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','195064',3809171,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195064',3809172,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','195064',3809173,'1635','219',962392.47,962392.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','195064',3809174,'1636','219',3142573.19,3142573.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','195064',3809175,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','195064',3809176,'1638','220',464232.02,465226.88,994.86,263637.90,0.00,0.00,0.00,0.00,0.00),('5','95','582','195064',3809177,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195147',3810518,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195147',3810519,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195147',3810520,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','195147',3810521,'1635','219',962392.47,964997.71,2605.24,429864.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','195147',3810522,'1636','219',3142573.19,3145023.41,2450.22,404286.30,0.00,0.00,0.00,0.00,0.00),('5','95','580','195147',3810523,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','195147',3810524,'1638','220',465226.88,465326.68,99.80,26447.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','195147',3810525,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195422',3815287,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195422',3815288,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195422',3815289,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','195422',3815290,'1635','219',964997.71,964998.61,0.90,148.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','195422',3815291,'1636','219',3145023.41,3149577.09,4553.68,751357.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','195422',3815292,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','195422',3815293,'1638','220',465326.68,465540.33,213.65,56617.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','195422',3815294,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195568',3817780,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195568',3817781,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195568',3817782,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','195568',3817783,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','195568',3817784,'1636','219',3149577.09,3154669.89,5092.80,840312.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','195568',3817785,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','195568',3817786,'1638','220',465540.33,466068.98,528.65,140092.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','195568',3817787,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195985',3825394,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195985',3825395,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','195985',3825396,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','195985',3825397,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','195985',3825398,'1636','219',3154669.89,3154927.17,257.28,42451.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','195985',3825399,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','195985',3825400,'1638','220',466068.98,466330.65,261.67,69342.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','195985',3825401,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196072',3826616,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196072',3826617,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196072',3826618,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','196072',3826619,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','196072',3826620,'1636','219',3154927.17,3154927.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','196072',3826621,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','196072',3826622,'1638','220',466330.65,466801.59,470.94,124799.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','196072',3826623,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196365',3832331,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196365',3832332,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196365',3832333,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','196365',3832334,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','196365',3832335,'1636','219',3154927.17,3154927.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','196365',3832336,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','196365',3832337,'1638','220',466801.59,467256.60,455.01,120577.65,0.00,0.00,0.00,0.00,0.00),('5','95','582','196365',3832338,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196508',3834821,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196508',3834822,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196508',3834823,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','196508',3834824,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','196508',3834825,'1636','219',3154927.17,3158634.86,3707.69,611768.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','196508',3834826,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','196508',3834827,'1638','220',467256.60,467597.44,340.84,90322.60,0.00,0.00,0.00,0.00,0.00),('5','95','582','196508',3834828,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196852',3841082,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196852',3841083,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','196852',3841084,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','196852',3841085,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','196852',3841086,'1636','219',3158634.86,3162040.38,3405.52,561910.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','196852',3841087,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','196852',3841088,'1638','220',467597.44,467667.26,69.82,18502.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','196852',3841089,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197010',3844000,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197010',3844001,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197010',3844002,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197010',3844003,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197010',3844004,'1636','219',3162040.38,3166092.91,4052.53,668667.45,0.00,0.00,0.00,0.00,0.00),('5','95','580','197010',3844005,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','197010',3844006,'1638','220',467667.26,467963.88,296.62,78604.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','197010',3844007,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197084',3845036,'1632','219',379903.91,379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197084',3845037,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197084',3845038,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197084',3845039,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197084',3845040,'1636','219',3166092.91,3168409.81,2316.90,382288.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','197084',3845041,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','197084',3845042,'1638','220',467963.88,468028.01,64.13,16994.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','197084',3845043,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197697',3855672,'1632','219',379903.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197697',3855673,'1633','219',721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197697',3855674,'1634','219',722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197697',3855675,'1635','219',964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197697',3855676,'1636','219',3168409.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','197697',3855677,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','197697',3855678,'1638','220',468028.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','197697',3855679,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197733',3856209,'1632','219',379903.91,380703.02,799.11,131853.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','197733',3856210,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197733',3856211,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197733',3856212,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197733',3856213,'1636','219',3168409.81,3169745.48,1335.67,220385.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','197733',3856214,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','197733',3856215,'1638','220',468028.01,468148.71,120.70,31985.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','197733',3856216,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197802',3857603,'1632','219',380703.02,383867.22,3164.20,522093.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197802',3857604,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197802',3857605,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197802',3857606,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197802',3857607,'1636','219',3169745.48,3169745.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','197802',3857608,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','197802',3857609,'1638','220',468148.71,468215.99,67.28,17829.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','197802',3857610,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197810',3857820,'1632','219',383867.22,387500.54,3633.32,599497.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','197810',3857821,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','197810',3857822,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197810',3857823,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','197810',3857824,'1636','219',3169745.48,3169745.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','197810',3857825,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','197810',3857826,'1638','220',468215.99,469854.40,1638.41,434178.65,0.00,0.00,0.00,0.00,0.00),('5','95','582','197810',3857827,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198046',3861935,'1632','219',387500.54,392613.82,5113.28,843691.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','198046',3861936,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198046',3861937,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198046',3861938,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198046',3861939,'1636','219',3169745.48,3169745.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','198046',3861940,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','198046',3861941,'1638','220',469854.40,471225.39,1370.99,370167.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','198046',3861942,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198327',3866759,'1632','219',392613.82,396203.42,3589.60,592284.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198327',3866760,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198327',3866761,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198327',3866762,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198327',3866763,'1636','219',3169745.48,3169745.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','198327',3866764,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','198327',3866765,'1638','220',471225.39,471333.79,108.40,29268.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','198327',3866766,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198549',3870588,'1632','219',396203.42,400048.02,3844.60,634359.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198549',3870589,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198549',3870590,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198549',3870591,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198549',3870592,'1636','219',3169745.48,3169745.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','198549',3870593,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','198549',3870594,'1638','220',471333.79,472206.69,872.90,235683.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','198549',3870595,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198674',3872651,'1632','219',400048.02,404851.92,4803.90,792643.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','198674',3872652,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198674',3872653,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198674',3872654,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198674',3872655,'1636','219',3169745.48,3169745.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','198674',3872656,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','198674',3872657,'1638','220',472206.69,472626.88,420.19,113451.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','198674',3872658,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198880',3876001,'1632','219',404851.92,407463.48,2611.56,430907.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','198880',3876002,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','198880',3876003,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198880',3876004,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','198880',3876005,'1636','219',3169745.48,3170277.24,531.76,87740.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','198880',3876006,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','198880',3876007,'1638','220',472626.88,472783.23,156.35,42214.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','198880',3876008,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199101',3880040,'1632','219',407463.48,409547.35,2083.87,343838.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','199101',3880041,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199101',3880042,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199101',3880043,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199101',3880044,'1636','219',3170277.24,3171676.48,1399.24,230874.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','199101',3880045,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','199101',3880046,'1638','220',472783.23,474040.76,1257.53,339533.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','199101',3880047,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199232',3882182,'1632','219',409547.35,409623.09,75.74,12497.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','199232',3882183,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199232',3882184,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199232',3882185,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199232',3882186,'1636','219',3171676.48,3175127.77,3451.29,569462.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','199232',3882187,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','199232',3882188,'1638','220',474040.76,474233.61,192.85,52069.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','199232',3882189,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199424',3885414,'1632','219',409623.09,409623.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199424',3885415,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199424',3885416,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199424',3885417,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199424',3885418,'1636','219',3175127.77,3177861.00,2733.23,450982.95,0.00,0.00,0.00,0.00,0.00),('5','95','580','199424',3885419,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','199424',3885420,'1638','220',474233.61,475055.01,821.40,221778.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','199424',3885421,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199667',3889338,'1632','219',409623.09,409623.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199667',3889339,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199667',3889340,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199667',3889341,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199667',3889342,'1636','219',3177861.00,3180329.61,2468.61,407320.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','199667',3889343,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','199667',3889344,'1638','220',475055.01,476173.44,1118.43,301976.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','199667',3889345,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199927',3893398,'1632','219',409623.09,409623.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199927',3893399,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','199927',3893400,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199927',3893401,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','199927',3893402,'1636','219',3180329.61,3182882.81,2553.20,421278.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','199927',3893403,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','199927',3893404,'1638','220',476173.44,476835.46,662.02,178745.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','199927',3893405,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200148',3897586,'1632','219',409623.09,411623.34,2000.25,330041.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','200148',3897587,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200148',3897588,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200148',3897589,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200148',3897590,'1636','219',3182882.81,3184718.15,1835.34,302831.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','200148',3897591,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','200148',3897592,'1638','220',476835.46,477752.81,917.35,247684.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','200148',3897593,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200297',3900229,'1632','219',411623.34,415689.16,4065.82,670860.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','200297',3900230,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200297',3900231,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200297',3900232,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200297',3900233,'1636','219',3184718.15,3186750.28,2032.13,335301.45,0.00,0.00,0.00,0.00,0.00),('5','95','580','200297',3900234,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','200297',3900235,'1638','220',477752.81,478249.14,496.33,134009.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','200297',3900236,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200674',3907302,'1632','219',415689.16,418038.85,2349.69,387698.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','200674',3907303,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200674',3907304,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200674',3907305,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200674',3907306,'1636','219',3186750.28,3188020.01,1269.73,209505.45,0.00,0.00,0.00,0.00,0.00),('5','95','580','200674',3907307,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','200674',3907308,'1638','220',478249.14,478306.52,57.38,15492.60,0.00,0.00,0.00,0.00,0.00),('5','95','582','200674',3907309,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200688',3907446,'1632','219',418038.85,420014.15,1975.30,325924.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','200688',3907447,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200688',3907448,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200688',3907449,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200688',3907450,'1636','219',3188020.01,3189521.72,1501.71,247782.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','200688',3907451,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','200688',3907452,'1638','220',478306.52,478646.01,339.49,91662.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','200688',3907453,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200983',3912392,'1632','219',420014.15,421572.37,1558.22,257106.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','200983',3912393,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','200983',3912394,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200983',3912395,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','200983',3912396,'1636','219',3189521.72,3190929.57,1407.85,232295.25,0.00,0.00,0.00,0.00,0.00),('5','95','580','200983',3912397,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','200983',3912398,'1638','220',478646.01,478757.27,111.26,30040.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','200983',3912399,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','201229',3916570,'1632','219',421572.37,423818.04,2245.67,370535.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','201229',3916571,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','201229',3916572,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','201229',3916573,'1635','219',964998.61,964998.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','201229',3916574,'1636','219',3190929.57,3192059.67,1130.10,186466.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','201229',3916575,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','201229',3916576,'1638','220',478757.27,479236.30,479.03,129338.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','201229',3916577,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','201354',3918550,'1632','219',423818.04,424811.71,993.67,163955.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','201354',3918551,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','201354',3918552,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','201354',3918553,'1635','219',964998.61,965878.43,879.82,145170.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','201354',3918554,'1636','219',3192059.67,3193229.25,1169.58,192980.70,0.00,0.00,0.00,0.00,0.00),('5','95','580','201354',3918555,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','201354',3918556,'1638','220',479236.30,479752.81,516.51,139457.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','201354',3918557,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','201505',3921551,'1632','219',424811.71,426503.10,1691.39,279079.35,0.00,0.00,0.00,0.00,0.00),('5','95','578','201505',3921552,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','201505',3921553,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','201505',3921554,'1635','219',965878.43,966834.50,956.07,157751.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','201505',3921555,'1636','219',3193229.25,3194616.09,1386.84,228828.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','201505',3921556,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','201505',3921557,'1638','220',479752.81,480190.20,437.39,118095.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','201505',3921558,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','201775',3926740,'1632','219',426503.10,428527.49,2024.39,334024.35,0.00,0.00,0.00,0.00,0.00),('5','95','578','201775',3926741,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','201775',3926742,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','201775',3926743,'1635','219',966834.50,968189.50,1355.00,223575.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','201775',3926744,'1636','219',3194616.09,3196507.37,1891.28,312061.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','201775',3926745,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','201775',3926746,'1638','220',480190.20,480603.50,413.30,113657.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','201775',3926747,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202023',3931507,'1632','219',428527.49,429195.00,667.51,110139.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','202023',3931508,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202023',3931509,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','202023',3931510,'1635','219',968189.50,969687.56,1498.06,247179.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','202023',3931511,'1636','219',3196507.37,3198447.95,1940.58,320195.70,0.00,0.00,0.00,0.00,0.00),('5','95','580','202023',3931512,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','202023',3931513,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','202023',3931514,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202218',3934726,'1632','219',429195.00,429195.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202218',3934727,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202218',3934728,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','202218',3934729,'1635','219',969687.56,971204.31,1516.75,250263.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','202218',3934730,'1636','219',3198447.95,3200928.32,2480.37,409261.05,0.00,0.00,0.00,0.00,0.00),('5','95','580','202218',3934731,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','202218',3934732,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','202218',3934733,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202486',3939332,'1632','219',429195.00,430460.56,1265.56,208817.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','202486',3939333,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202486',3939334,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','202486',3939335,'1635','219',971204.31,971757.34,553.03,91249.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','202486',3939336,'1636','219',3200928.32,3202168.08,1239.76,204560.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','202486',3939337,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','202486',3939338,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','202486',3939339,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202708',3943090,'1632','219',430460.56,431724.36,1263.80,208527.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202708',3943091,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202708',3943092,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','202708',3943093,'1635','219',971757.34,972440.98,683.64,112800.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','202708',3943094,'1636','219',3202168.08,3202867.94,699.86,115476.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','202708',3943095,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','202708',3943096,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','202708',3943097,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202852',3945927,'1632','219',431724.36,432848.68,1124.32,185512.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','202852',3945928,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','202852',3945929,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','202852',3945930,'1635','219',972440.98,973185.41,744.43,122830.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','202852',3945931,'1636','219',3202867.94,3203874.95,1007.01,166156.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','202852',3945932,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','202852',3945933,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','202852',3945934,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','203151',3951429,'1632','219',432848.68,434829.43,1980.75,326823.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','203151',3951430,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','203151',3951431,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','203151',3951432,'1635','219',973185.41,974194.74,1009.33,166539.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','203151',3951433,'1636','219',3203874.95,3205013.79,1138.84,187908.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','203151',3951434,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','203151',3951435,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','203151',3951436,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','203331',3954693,'1632','219',434829.43,435769.18,939.75,155058.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','203331',3954694,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','203331',3954695,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','203331',3954696,'1635','219',974194.74,975071.40,876.66,144648.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','203331',3954697,'1636','219',3205013.79,3205810.64,796.85,131480.25,0.00,0.00,0.00,0.00,0.00),('5','95','580','203331',3954698,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','203331',3954699,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','203331',3954700,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','203705',3961744,'1632','219',435769.18,436695.29,926.11,152808.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','203705',3961745,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','203705',3961746,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','203705',3961747,'1635','219',975071.40,975701.22,629.82,103920.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','203705',3961748,'1636','219',3205810.64,3206333.74,523.10,86311.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','203705',3961749,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','203705',3961750,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','203705',3961751,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','203734',3962095,'1632','219',436695.29,438335.37,1640.08,270613.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','203734',3962096,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','203734',3962097,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','203734',3962098,'1635','219',975701.22,976366.70,665.48,109804.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','203734',3962099,'1636','219',3206333.74,3207108.53,774.79,127840.35,0.00,0.00,0.00,0.00,0.00),('5','95','580','203734',3962100,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','203734',3962101,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','203734',3962102,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204031',3967178,'1632','219',438335.37,441981.78,3646.41,601657.65,0.00,0.00,0.00,0.00,0.00),('5','95','578','204031',3967179,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204031',3967180,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','204031',3967181,'1635','219',976366.70,977128.12,761.42,125634.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','204031',3967182,'1636','219',3207108.53,3208426.22,1317.69,217418.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','204031',3967183,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','204031',3967184,'1638','220',480603.50,480603.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','204031',3967185,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204187',3970320,'1632','219',441981.78,442708.97,727.19,119986.35,0.00,0.00,0.00,0.00,0.00),('5','95','578','204187',3970321,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204187',3970322,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','204187',3970323,'1635','219',977128.12,977770.76,642.64,106035.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','204187',3970324,'1636','219',3208426.22,3208680.94,254.72,42028.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','204187',3970325,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','204187',3970326,'1638','220',480603.50,480743.50,140.00,38500.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','204187',3970327,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204459',3975019,'1632','219',442708.97,443824.87,1115.90,184123.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','204459',3975020,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204459',3975021,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','204459',3975022,'1635','219',977770.76,978262.29,491.53,81102.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','204459',3975023,'1636','219',3208680.94,3209500.15,819.21,135169.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','204459',3975024,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','204459',3975025,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','204459',3975026,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204609',3977960,'1632','219',443824.87,445538.58,1713.71,282762.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','204609',3977961,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204609',3977962,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','204609',3977963,'1635','219',978262.29,979221.21,958.92,158221.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','204609',3977964,'1636','219',3209500.15,3210708.28,1208.13,199341.45,0.00,0.00,0.00,0.00,0.00),('5','95','580','204609',3977965,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','204609',3977966,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','204609',3977967,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204904',3982642,'1632','219',445538.58,446823.50,1284.92,212011.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','204904',3982643,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','204904',3982644,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','204904',3982645,'1635','219',979221.21,980239.64,1018.43,168040.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','204904',3982646,'1636','219',3210708.28,3211454.22,745.94,123080.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','204904',3982647,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','204904',3982648,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','204904',3982649,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205034',3985166,'1632','219',446823.50,447607.51,784.01,129361.65,0.00,0.00,0.00,0.00,0.00),('5','95','578','205034',3985167,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205034',3985168,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','205034',3985169,'1635','219',980239.64,980684.94,445.30,73474.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','205034',3985170,'1636','219',3211454.22,3212267.53,813.31,134196.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','205034',3985171,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','205034',3985172,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','205034',3985173,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205232',3988719,'1632','219',447607.51,448652.67,1045.16,172451.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','205232',3988720,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205232',3988721,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','205232',3988722,'1635','219',980684.94,981396.72,711.78,117443.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','205232',3988723,'1636','219',3212267.53,3213364.33,1096.80,180972.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','205232',3988724,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','205232',3988725,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','205232',3988726,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205482',3993163,'1632','219',448652.67,449074.05,421.38,69527.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','205482',3993164,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205482',3993165,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','205482',3993166,'1635','219',981396.72,981917.28,520.56,85892.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','205482',3993167,'1636','219',3213364.33,3213976.85,612.52,101065.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','205482',3993168,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','205482',3993169,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','205482',3993170,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205722',3997690,'1632','219',449074.05,450044.81,970.76,160175.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','205722',3997691,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205722',3997692,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','205722',3997693,'1635','219',981917.28,982332.49,415.21,68509.65,0.00,0.00,0.00,0.00,0.00),('5','95','579','205722',3997694,'1636','219',3213976.85,3214663.00,686.15,113214.75,0.00,0.00,0.00,0.00,0.00),('5','95','580','205722',3997695,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','205722',3997696,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','205722',3997697,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205944',4001563,'1632','219',450044.81,451069.84,1025.03,169129.95,0.00,0.00,0.00,0.00,0.00),('5','95','578','205944',4001564,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','205944',4001565,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','205944',4001566,'1635','219',982332.49,983012.15,679.66,112143.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','205944',4001567,'1636','219',3214663.00,3215377.07,714.07,117821.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','205944',4001568,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','205944',4001569,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','205944',4001570,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','206159',4005360,'1632','219',451069.84,452258.89,1189.05,196193.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','206159',4005361,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','206159',4005362,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','206159',4005363,'1635','219',983012.15,983881.27,869.12,143404.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','206159',4005364,'1636','219',3215377.07,3216419.36,1042.29,171977.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','206159',4005365,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','206159',4005366,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','206159',4005367,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','206372',4008989,'1632','219',452258.89,453497.82,1238.93,204423.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','206372',4008990,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','206372',4008991,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','206372',4008992,'1635','219',983881.27,984602.63,721.36,119024.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','206372',4008993,'1636','219',3216419.36,3217184.54,765.18,126254.70,0.00,0.00,0.00,0.00,0.00),('5','95','580','206372',4008994,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','206372',4008995,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','206372',4008996,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','206567',4012524,'1632','219',453497.82,454893.63,1395.81,230308.65,0.00,0.00,0.00,0.00,0.00),('5','95','578','206567',4012525,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','206567',4012526,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','206567',4012527,'1635','219',984602.63,985218.86,616.23,101677.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','206567',4012528,'1636','219',3217184.54,3217713.17,528.63,87223.95,0.00,0.00,0.00,0.00,0.00),('5','95','580','206567',4012529,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','206567',4012530,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','206567',4012531,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','206791',4016478,'1632','219',454893.63,456063.24,1169.61,192985.65,0.00,0.00,0.00,0.00,0.00),('5','95','578','206791',4016479,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','206791',4016480,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','206791',4016481,'1635','219',985218.86,985832.61,613.75,101268.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','206791',4016482,'1636','219',3217713.17,3218393.68,680.51,112284.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','206791',4016483,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','206791',4016484,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','206791',4016485,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207017',4020594,'1632','219',456063.24,457094.51,1031.27,170159.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','207017',4020595,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207017',4020596,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','207017',4020597,'1635','219',985832.61,986373.04,540.43,89170.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','207017',4020598,'1636','219',3218393.68,3219268.55,874.87,144353.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','207017',4020599,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','207017',4020600,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','207017',4020601,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207374',4026754,'1632','219',457094.51,457402.00,307.49,50735.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','207374',4026755,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207374',4026756,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','207374',4026757,'1635','219',986373.04,986931.84,558.80,92202.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','207374',4026758,'1636','219',3219268.55,3219705.13,436.58,72035.70,0.00,0.00,0.00,0.00,0.00),('5','95','580','207374',4026759,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','207374',4026760,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','207374',4026761,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207585',4030610,'1632','219',457402.00,460512.17,3110.17,513178.05,0.00,0.00,0.00,0.00,0.00),('5','95','578','207585',4030611,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207585',4030612,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','207585',4030613,'1635','219',986931.84,987615.79,683.95,112851.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','207585',4030614,'1636','219',3219705.13,3220232.05,526.92,86941.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','207585',4030615,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','207585',4030616,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','207585',4030617,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207711',4032668,'1632','219',460512.17,460512.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207711',4032669,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207711',4032670,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','207711',4032671,'1635','219',987615.79,988900.44,1284.65,211967.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','207711',4032672,'1636','219',3220232.05,3221708.40,1476.35,243597.75,0.00,0.00,0.00,0.00,0.00),('5','95','580','207711',4032673,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','207711',4032674,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','207711',4032675,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207923',4036267,'1632','219',460512.17,461147.74,635.57,104869.05,0.00,0.00,0.00,0.00,0.00),('5','95','578','207923',4036268,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','207923',4036269,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','207923',4036270,'1635','219',988900.44,989964.61,1064.17,175588.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','207923',4036271,'1636','219',3221708.40,3223217.14,1508.74,248942.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','207923',4036272,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','207923',4036273,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','207923',4036274,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','208131',4039934,'1632','219',461147.74,462601.56,1453.82,239880.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','208131',4039935,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','208131',4039936,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','208131',4039937,'1635','219',989964.61,989966.12,1.51,249.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','208131',4039938,'1636','219',3223217.14,3223696.80,479.66,79143.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','208131',4039939,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','208131',4039940,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','208131',4039941,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','208364',4044136,'1632','219',462601.56,462773.47,171.91,28365.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','208364',4044137,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','208364',4044138,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','208364',4044139,'1635','219',989966.12,989966.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','208364',4044140,'1636','219',3223696.80,3223696.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','208364',4044141,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','208364',4044142,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','208364',4044143,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','208557',4047524,'1632','219',462773.47,463733.21,959.74,158357.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','208557',4047525,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','208557',4047526,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','208557',4047527,'1635','219',989966.12,989966.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','208557',4047528,'1636','219',3223696.80,3223696.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','208557',4047529,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','208557',4047530,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','208557',4047531,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','208802',4051506,'1632','219',463733.21,467848.08,4114.87,678953.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','208802',4051507,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','208802',4051508,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','208802',4051509,'1635','219',989966.12,989966.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','208802',4051510,'1636','219',3223696.80,3223696.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','208802',4051511,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','208802',4051512,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','208802',4051513,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209109',4056956,'1632','219',467848.08,469646.96,1728.88,285265.20,0.00,0.00,70.00,0.00,0.00),('5','95','578','209109',4056957,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209109',4056958,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','209109',4056959,'1635','219',989966.12,989966.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','209109',4056960,'1636','219',3223696.80,3223696.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','209109',4056961,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','209109',4056962,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','209109',4056963,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209232',4059160,'1632','219',469646.96,470472.21,825.25,136166.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','209232',4059161,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209232',4059162,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','209232',4059163,'1635','219',989966.12,989966.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','209232',4059164,'1636','219',3223696.80,3223696.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','209232',4059165,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','209232',4059166,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','209232',4059167,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209442',4062916,'1632','219',470472.21,471184.64,712.43,117550.95,0.00,0.00,0.00,0.00,0.00),('5','95','578','209442',4062917,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209442',4062918,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','209442',4062919,'1635','219',989966.12,989966.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','209442',4062920,'1636','219',3223696.80,3223696.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','209442',4062921,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','209442',4062922,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','209442',4062923,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209764',4068752,'1632','219',471184.64,471485.91,301.27,49709.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','209764',4068753,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209764',4068754,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','209764',4068755,'1635','219',989966.12,991974.33,2008.21,331354.65,0.00,0.00,0.00,0.00,0.00),('5','95','579','209764',4068756,'1636','219',3223696.80,3225413.56,1716.76,283265.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','209764',4068757,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','209764',4068758,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','209764',4068759,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209921',4071466,'1632','219',471485.91,471485.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209921',4071467,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','209921',4071468,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','209921',4071469,'1635','219',991974.33,994254.00,2279.67,376145.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','209921',4071470,'1636','219',3225413.56,3227294.07,1880.51,310284.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','209921',4071471,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','209921',4071472,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','209921',4071473,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210111',4074850,'1632','219',471485.91,471485.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210111',4074851,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210111',4074852,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','210111',4074853,'1635','219',994254.00,995487.18,1233.18,80156.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','210111',4074854,'1636','219',3227294.07,3229095.48,1801.41,117091.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','210111',4074855,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','210111',4074856,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','210111',4074857,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210366',4079242,'1632','219',471485.91,471485.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210366',4079243,'1633','219',721518.54,721518.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210366',4079244,'1634','219',722410.47,722410.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','210366',4079245,'1635','219',995487.18,997343.03,1855.85,306215.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','210366',4079246,'1636','219',3229095.48,3230410.43,1314.95,216966.75,0.00,0.00,0.00,0.00,0.00),('5','95','580','210366',4079247,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','210366',4079248,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','210366',4079249,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210514',4082192,'1632','219',471485.91,471608.60,122.69,20243.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','210514',4082193,'1633','219',721518.54,721576.96,58.42,9639.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','210514',4082194,'1634','219',722410.47,722621.88,211.41,34882.65,0.00,0.00,0.00,0.00,0.00),('5','95','579','210514',4082195,'1635','219',997343.03,999228.01,1884.98,311021.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','210514',4082196,'1636','219',3230410.43,3231886.57,1476.14,243563.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','210514',4082197,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','210514',4082198,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','210514',4082199,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210748',4086156,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210748',4086157,'1633','219',721576.96,721576.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210748',4086158,'1634','219',722621.88,722925.74,303.86,50136.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','210748',4086159,'1635','219',999228.01,1001003.77,1775.76,293000.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','210748',4086160,'1636','219',3231886.57,3234215.23,2328.66,384228.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','210748',4086161,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','210748',4086162,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','210748',4086163,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210950',4089652,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210950',4089653,'1633','219',721576.96,721576.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','210950',4089654,'1634','219',722925.74,723616.14,690.40,113916.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','210950',4089655,'1635','219',1001003.77,1002404.77,1401.00,231165.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','210950',4089656,'1636','219',3234215.23,3235892.32,1677.09,276719.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','210950',4089657,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','210950',4089658,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','210950',4089659,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211307',4096076,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211307',4096077,'1633','219',721576.96,721576.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211307',4096078,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','211307',4096079,'1635','219',1002404.77,1003743.52,1338.75,220893.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','211307',4096080,'1636','219',3235892.32,3236942.11,1049.79,173215.35,0.00,0.00,0.00,0.00,0.00),('5','95','580','211307',4096081,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','211307',4096082,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','211307',4096083,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211392',4097497,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211392',4097498,'1633','219',721576.96,721576.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211392',4097499,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','211392',4097500,'1635','219',1003743.52,1005254.86,1511.34,249371.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','211392',4097501,'1636','219',3236942.11,3238238.68,1296.57,213934.05,0.00,0.00,0.00,0.00,0.00),('5','95','580','211392',4097502,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','211392',4097503,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','211392',4097504,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211595',4101190,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211595',4101191,'1633','219',721576.96,721576.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211595',4101192,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','211595',4101193,'1635','219',1005254.86,1006278.39,1023.53,168882.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','211595',4101194,'1636','219',3238238.68,3239658.85,1420.17,234328.05,0.00,0.00,0.00,0.00,0.00),('5','95','580','211595',4101195,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','211595',4101196,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','211595',4101197,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211809',4104554,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211809',4104555,'1633','219',721576.96,721576.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','211809',4104556,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','211809',4104557,'1635','219',1006278.39,1007331.71,1053.32,173797.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','211809',4104558,'1636','219',3239658.85,3240780.43,1121.58,185060.70,0.00,0.00,0.00,0.00,0.00),('5','95','580','211809',4104559,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','211809',4104560,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','211809',4104561,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212094',4109769,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212094',4109770,'1633','219',721576.96,721576.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212094',4109771,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','212094',4109772,'1635','219',1007331.71,1008384.36,1052.65,173687.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','212094',4109773,'1636','219',3240780.43,3242031.74,1251.31,206466.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','212094',4109774,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','212094',4109775,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','212094',4109776,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212366',4114589,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212366',4114590,'1633','219',721576.96,721576.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212366',4114591,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','212366',4114592,'1635','219',1008384.36,1009464.03,1079.67,178145.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','212366',4114593,'1636','219',3242031.74,3244070.01,2038.27,336314.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','212366',4114594,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','212366',4114595,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','212366',4114596,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212486',4116698,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212486',4116699,'1633','219',721576.96,721996.61,419.65,69242.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','212486',4116700,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','212486',4116701,'1635','219',1009464.03,1009464.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','212486',4116702,'1636','219',3244070.01,3244073.49,3.48,574.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','212486',4116703,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','212486',4116704,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','212486',4116705,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212848',4123325,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212848',4123326,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212848',4123327,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','212848',4123328,'1635','219',1009464.03,1010699.82,1235.79,203905.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','212848',4123329,'1636','219',3244073.49,3245161.80,1088.31,179571.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','212848',4123330,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','212848',4123331,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','212848',4123332,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212868',4123613,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212868',4123614,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','212868',4123615,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','212868',4123616,'1635','219',1010699.82,1011244.68,544.86,89901.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','212868',4123617,'1636','219',3245161.80,3245980.93,819.13,135156.45,0.00,0.00,0.00,0.00,0.00),('5','95','580','212868',4123618,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','212868',4123619,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','212868',4123620,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213132',4128155,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213132',4128156,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213132',4128157,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','213132',4128158,'1635','219',1011244.68,1012969.69,1725.01,284626.65,0.00,0.00,0.00,0.00,0.00),('5','95','579','213132',4128159,'1636','219',3245980.93,3246863.23,882.30,145579.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','213132',4128160,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','213132',4128161,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','213132',4128162,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213518',4134478,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213518',4134479,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213518',4134480,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','213518',4134481,'1635','219',1012969.69,1013790.13,820.44,135372.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','213518',4134482,'1636','219',3246863.23,3247624.69,761.46,125640.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','213518',4134483,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','213518',4134484,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','213518',4134485,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213682',4137200,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213682',4137201,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213682',4137202,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','213682',4137203,'1635','219',1013790.13,1014872.82,1082.69,178643.85,0.00,0.00,0.00,0.00,0.00),('5','95','579','213682',4137204,'1636','219',3247624.69,3249273.38,1648.69,272033.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','213682',4137205,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','213682',4137206,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','213682',4137207,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213925',4141080,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213925',4141081,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','213925',4141082,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','213925',4141083,'1635','219',1014872.82,1016012.25,1139.43,188005.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','213925',4141084,'1636','219',3249273.38,3250452.97,1179.59,194632.35,0.00,0.00,0.00,0.00,0.00),('5','95','580','213925',4141085,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','213925',4141086,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','213925',4141087,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214305',4147941,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214305',4147942,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214305',4147943,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','214305',4147944,'1635','219',1016012.25,1017356.05,1343.80,221727.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','214305',4147945,'1636','219',3250452.97,3251203.01,750.04,123756.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','214305',4147946,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','214305',4147947,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','214305',4147948,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214332',4148295,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214332',4148296,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214332',4148297,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','214332',4148298,'1635','219',1017356.05,1018395.88,1039.83,171571.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','214332',4148299,'1636','219',3251203.01,3254813.41,3610.40,595716.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','214332',4148300,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','214332',4148301,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','214332',4148302,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214600',4152673,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214600',4152674,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214600',4152675,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','214600',4152676,'1635','219',1018395.88,1019411.94,1016.06,167649.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','214600',4152677,'1636','219',3254813.41,3255802.46,989.05,163193.25,0.00,0.00,0.00,0.00,0.00),('5','95','580','214600',4152678,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','214600',4152679,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','214600',4152680,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214850',4157133,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214850',4157134,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','214850',4157135,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','214850',4157136,'1635','219',1019411.94,1020457.42,1045.48,172504.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','214850',4157137,'1636','219',3255802.46,3256572.72,770.26,127092.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','214850',4157138,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','214850',4157139,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','214850',4157140,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215018',4159815,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215018',4159816,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215018',4159817,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','215018',4159818,'1635','219',1020457.42,1021441.21,983.79,162325.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','215018',4159819,'1636','219',3256572.72,3257485.68,912.96,150638.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','215018',4159820,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','215018',4159821,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','215018',4159822,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215298',4164639,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215298',4164640,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215298',4164641,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','215298',4164642,'1635','219',1021441.21,1022360.75,919.54,151724.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','215298',4164643,'1636','219',3257485.68,3258630.86,1145.18,188954.70,0.00,0.00,0.00,0.00,0.00),('5','95','580','215298',4164644,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','215298',4164645,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','215298',4164646,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215567',4169035,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215567',4169036,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215567',4169037,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','215567',4169038,'1635','219',1022360.75,1023958.68,1597.93,263658.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','215567',4169039,'1636','219',3258630.86,3260674.39,2043.53,337182.45,0.00,0.00,0.00,0.00,0.00),('5','95','580','215567',4169040,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','215567',4169041,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','215567',4169042,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215696',4171304,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215696',4171305,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215696',4171306,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','215696',4171307,'1635','219',1023958.68,1025318.58,1359.90,224383.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','215696',4171308,'1636','219',3260674.39,3261571.78,897.39,148069.35,0.00,0.00,0.00,0.00,0.00),('5','95','580','215696',4171309,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','215696',4171310,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','215696',4171311,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215896',4174971,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215896',4174972,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','215896',4174973,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','215896',4174974,'1635','219',1025318.58,1027059.06,1740.48,287179.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','215896',4174975,'1636','219',3261571.78,3263924.85,2353.07,388256.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','215896',4174976,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','215896',4174977,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','215896',4174978,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216170',4179481,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216170',4179482,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216170',4179483,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','216170',4179484,'1635','219',1027059.06,1027678.05,618.99,102133.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','216170',4179485,'1636','219',3263924.85,3265608.74,1683.89,277841.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','216170',4179486,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','216170',4179487,'1638','220',480743.50,480743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','216170',4179488,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216324',4182273,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216324',4182274,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216324',4182275,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','216324',4182276,'1635','219',1027678.05,1027678.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','216324',4182277,'1636','219',3265608.74,3265608.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','216324',4182278,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','216324',4182279,'1638','220',480743.50,481008.53,265.03,78183.85,0.00,0.00,0.00,0.00,0.00),('5','95','582','216324',4182280,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216607',4186993,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216607',4186994,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216607',4186995,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','216607',4186996,'1635','219',1027678.05,1028388.79,710.74,117272.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','216607',4186997,'1636','219',3265608.74,3266283.08,674.34,111266.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','216607',4186998,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','216607',4186999,'1638','220',481008.53,481172.78,164.25,48453.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','216607',4187000,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216844',4191286,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216844',4191287,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','216844',4191288,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','216844',4191289,'1635','219',1028388.79,1029728.36,1339.57,221029.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','216844',4191290,'1636','219',3266283.08,3267903.50,1620.42,267369.30,0.00,0.00,0.00,0.00,0.00),('5','95','580','216844',4191291,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','216844',4191292,'1638','220',481172.78,481199.72,26.94,7947.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','216844',4191293,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217052',4194890,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217052',4194891,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217052',4194892,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','217052',4194893,'1635','219',1029728.36,1031600.38,1872.02,308883.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','217052',4194894,'1636','219',3267903.50,3269952.58,2049.08,338098.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','217052',4194895,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','217052',4194896,'1638','220',481199.72,481413.02,213.30,62923.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','217052',4194897,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217322',4199976,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217322',4199977,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217322',4199978,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','217322',4199979,'1635','219',1031600.38,1033130.67,1530.29,252497.85,0.00,0.00,0.00,0.00,0.00),('5','95','579','217322',4199980,'1636','219',3269952.58,3271398.54,1445.96,238583.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','217322',4199981,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','217322',4199982,'1638','220',481413.02,481494.38,81.36,24001.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','217322',4199983,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217664',4206123,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217664',4206124,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217664',4206125,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','217664',4206126,'1635','219',1033130.67,1034140.14,1009.47,166562.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','217664',4206127,'1636','219',3271398.54,3272195.29,796.75,131463.75,0.00,0.00,0.00,0.00,0.00),('5','95','580','217664',4206128,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','217664',4206129,'1638','220',481494.38,481570.63,76.25,22493.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','217664',4206130,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217710',4206697,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217710',4206698,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','217710',4206699,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','217710',4206700,'1635','219',1034140.14,1035128.25,988.11,163038.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','217710',4206701,'1636','219',3272195.29,3273017.37,822.08,135643.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','217710',4206702,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','217710',4206703,'1638','220',481570.63,481601.96,31.33,9242.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','217710',4206704,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218109',4213712,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218109',4213713,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218109',4213714,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','218109',4213715,'1635','219',1035128.25,1036127.60,999.35,164892.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','218109',4213716,'1636','219',3273017.37,3273943.63,926.26,152832.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','218109',4213717,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','218109',4213718,'1638','220',481601.96,481634.32,32.36,9546.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','218109',4213719,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218290',4216951,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218290',4216952,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218290',4216953,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','218290',4216954,'1635','219',1036127.60,1036861.61,734.01,121111.65,0.00,0.00,0.00,0.00,0.00),('5','95','579','218290',4216955,'1636','219',3273943.63,3274651.65,708.02,116823.30,0.00,0.00,0.00,0.00,0.00),('5','95','580','218290',4216956,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','218290',4216957,'1638','220',481634.32,481715.47,81.15,23939.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','218290',4216958,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218534',4221365,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218534',4221366,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218534',4221367,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','218534',4221368,'1635','219',1036861.61,1038232.74,1371.13,226236.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','218534',4221369,'1636','219',3274651.65,3276326.14,1674.49,276290.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','218534',4221370,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','218534',4221371,'1638','220',481715.47,481917.47,202.00,59590.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','218534',4221372,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218674',4223987,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218674',4223988,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218674',4223989,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','218674',4223990,'1635','219',1038232.74,1039556.59,1323.85,218435.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','218674',4223991,'1636','219',3276326.14,3277823.44,1497.30,247054.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','218674',4223992,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','218674',4223993,'1638','220',481917.47,482003.87,86.40,25488.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','218674',4223994,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218951',4228615,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218951',4228616,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','218951',4228617,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','218951',4228618,'1635','219',1039556.59,1040498.70,942.11,155448.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','218951',4228619,'1636','219',3277823.44,3278897.33,1073.89,177191.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','218951',4228620,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','218951',4228621,'1638','220',482003.87,482057.43,53.56,15800.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','218951',4228622,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219121',4231579,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219121',4231580,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219121',4231581,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','219121',4231582,'1635','219',1040498.70,1041491.06,992.36,163739.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','219121',4231583,'1636','219',3278897.33,3280156.14,1258.81,207703.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','219121',4231584,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','219121',4231585,'1638','220',482057.43,482074.84,17.41,5135.95,0.00,0.00,0.00,0.00,0.00),('5','95','582','219121',4231586,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219404',4236369,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219404',4236370,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219404',4236371,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','219404',4236372,'1635','219',1041491.06,1042010.69,519.63,85738.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','219404',4236373,'1636','219',3280156.14,3281339.41,1183.27,195239.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','219404',4236374,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','219404',4236375,'1638','220',482074.84,482432.41,357.57,105483.15,0.00,0.00,0.00,0.00,0.00),('5','95','582','219404',4236376,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219689',4241404,'1632','219',471608.60,471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219689',4241405,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219689',4241406,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','219689',4241407,'1635','219',1042010.69,1042310.27,299.58,49430.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','219689',4241408,'1636','219',3281339.41,3281893.18,553.77,91372.05,0.00,0.00,0.00,0.00,0.00),('5','95','580','219689',4241409,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','219689',4241410,'1638','220',482432.41,482460.70,28.29,8345.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','219689',4241411,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219856',4244369,'1632','219',471608.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219856',4244370,'1633','219',721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219856',4244371,'1634','219',723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','219856',4244372,'1635','219',1042310.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','219856',4244373,'1636','219',3281893.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','219856',4244374,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','219856',4244375,'1638','220',482460.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','219856',4244376,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219972',4246700,'1632','219',118.83,394.84,276.01,39469.43,0.00,0.00,0.00,0.00,0.00),('5','95','578','219972',4246701,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','219972',4246702,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','219972',4246703,'1635','219',1042310.27,1042741.67,431.40,61690.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','219972',4246704,'1636','219',3281893.18,3282961.88,1068.70,152824.10,0.00,0.00,0.00,0.00,0.00),('5','95','580','219972',4246705,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','219972',4246706,'1638','220',482460.70,482585.32,124.62,34270.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','219972',4246707,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220117',4249147,'1632','219',394.84,444.84,50.00,8250.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220117',4249148,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220117',4249149,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','220117',4249150,'1635','219',1042741.67,1043615.39,873.72,144163.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','220117',4249151,'1636','219',3282961.88,3284005.40,1043.52,172180.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','220117',4249152,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','220117',4249153,'1638','220',482585.32,483067.78,482.46,142325.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','220117',4249154,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220283',4251950,'1632','219',444.84,444.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220283',4251951,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220283',4251952,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','220283',4251953,'1635','219',1043615.39,1044677.51,1062.12,175249.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','220283',4251954,'1636','219',3284005.40,3285190.52,1185.12,195544.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','220283',4251955,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','220283',4251956,'1638','220',483067.78,483973.99,906.21,267331.95,0.00,0.00,0.00,0.00,0.00),('5','95','582','220283',4251957,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220508',4256037,'1632','219',444.84,444.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220508',4256038,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220508',4256039,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','220508',4256040,'1635','219',1044677.51,1045499.43,821.92,135616.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','220508',4256041,'1636','219',3285190.52,3286387.42,1196.90,197488.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','220508',4256042,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','220508',4256043,'1638','220',483973.99,484040.92,66.93,19744.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','220508',4256044,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220723',4259705,'1632','219',444.84,444.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220723',4259706,'1633','219',721996.61,721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220723',4259707,'1634','219',723616.14,723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','220723',4259708,'1635','219',1045499.43,1046427.02,927.59,153052.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','220723',4259709,'1636','219',3286387.42,3286986.54,599.12,98854.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','220723',4259710,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','220723',4259711,'1638','220',484040.92,484119.58,78.66,23204.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','220723',4259712,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220987',4264593,'1632','219',444.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220987',4264594,'1633','219',721996.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','220987',4264595,'1634','219',723616.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','220987',4264596,'1635','219',1046427.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','220987',4264597,'1636','219',3286986.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','220987',4264598,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','220987',4264599,'1638','220',484119.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','220987',4264600,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','221236',4268850,'1632','219',444.84,695.00,250.16,41276.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','221236',4268851,'1633','219',136579.52,136579.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','221236',4268852,'1634','219',722109.03,722244.94,135.91,22425.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','221236',4268853,'1635','219',1046427.02,1047674.13,1247.11,205773.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','221236',4268854,'1636','219',3286986.54,3288381.10,1394.56,230102.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','221236',4268855,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','221236',4268856,'1638','220',484119.58,484743.99,624.41,184200.95,0.00,0.00,0.00,0.00,0.00),('5','95','582','221236',4268857,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','221241',4268913,'1632','219',695.00,726.86,31.86,5256.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','221241',4268914,'1633','219',136579.52,137505.81,926.29,152837.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','221241',4268915,'1634','219',722244.94,722799.97,555.03,91579.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','221241',4268916,'1635','219',1047674.13,1048060.93,386.80,63822.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','221241',4268917,'1636','219',3288381.10,3288381.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','221241',4268918,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','221241',4268919,'1638','220',484743.99,485287.17,543.18,160238.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','221241',4268920,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','221411',4272044,'1632','219',726.86,1068.74,341.88,56410.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','221411',4272045,'1633','219',137505.81,138918.69,1412.88,233125.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','221411',4272046,'1634','219',722799.97,724420.13,1620.16,267326.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','221411',4272047,'1635','219',1048060.93,1049236.01,1175.08,193888.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','221411',4272048,'1636','219',3288381.10,3289033.18,652.08,107593.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','221411',4272049,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','221411',4272050,'1638','220',485287.17,485829.88,542.71,160099.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','221411',4272051,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','221618',4276082,'1632','219',1068.74,1774.66,705.92,116476.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','221618',4276083,'1633','219',138918.69,139107.98,189.29,31232.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','221618',4276084,'1634','219',724420.13,725552.15,1132.02,186783.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','221618',4276085,'1635','219',1049236.01,1049627.28,391.27,64559.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','221618',4276086,'1636','219',3289033.18,3289134.03,100.85,16640.25,0.00,0.00,0.00,0.00,0.00),('5','95','580','221618',4276087,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','221618',4276088,'1638','220',485829.88,486208.05,378.17,111560.15,0.00,0.00,0.00,0.00,0.00),('5','95','582','221618',4276089,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','221843',4279881,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','221843',4279882,'1633','219',139107.98,140118.91,1010.93,166803.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','221843',4279883,'1634','219',725552.15,726172.60,620.45,102374.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','221843',4279884,'1635','219',1049627.28,1049627.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','221843',4279885,'1636','219',3289134.03,3289858.07,724.04,119466.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','221843',4279886,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','221843',4279887,'1638','220',486208.05,486732.49,524.44,154709.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','221843',4279888,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222244',4287216,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222244',4287217,'1633','219',140118.91,140996.24,877.33,144759.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','222244',4287218,'1634','219',726172.60,726971.43,798.83,131806.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','222244',4287219,'1635','219',1049627.28,1049844.16,216.88,35785.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','222244',4287220,'1636','219',3289858.07,3290100.36,242.29,39977.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','222244',4287221,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','222244',4287222,'1638','220',486732.49,487246.36,513.87,151591.65,0.00,0.00,0.00,0.00,0.00),('5','95','582','222244',4287223,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222276',4287566,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222276',4287567,'1633','219',140996.24,141914.96,918.72,151588.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','222276',4287568,'1634','219',726971.43,727528.86,557.43,91975.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','222276',4287569,'1635','219',1049844.16,1049844.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','222276',4287570,'1636','219',3290100.36,3290320.17,219.81,36268.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','222276',4287571,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','222276',4287572,'1638','220',487246.36,487288.45,42.09,12416.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','222276',4287573,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222508',4291532,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222508',4291533,'1633','219',141914.96,142903.93,988.97,163180.05,0.00,0.00,0.00,0.00,0.00),('5','95','578','222508',4291534,'1634','219',727528.86,728008.71,479.85,79175.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','222508',4291535,'1635','219',1049844.16,1049844.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','222508',4291536,'1636','219',3290320.17,3291039.05,718.88,118615.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','222508',4291537,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','222508',4291538,'1638','220',487288.45,487864.61,576.16,169967.20,0.00,0.00,0.00,0.00,0.00),('5','95','582','222508',4291539,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222732',4295772,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222732',4295773,'1633','219',142903.93,143321.76,417.83,68941.95,0.00,0.00,0.00,0.00,0.00),('5','95','578','222732',4295774,'1634','219',728008.71,728456.05,447.34,73811.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','222732',4295775,'1635','219',1049844.16,1050140.03,295.87,48818.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','222732',4295776,'1636','219',3291039.05,3291039.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','222732',4295777,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','222732',4295778,'1638','220',487864.61,487900.05,35.44,10454.80,0.00,0.00,0.00,0.00,0.00),('5','95','582','222732',4295779,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222947',4299802,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','222947',4299803,'1633','219',143321.76,143728.88,407.12,67174.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','222947',4299804,'1634','219',728456.05,728753.61,297.56,49097.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','222947',4299805,'1635','219',1050140.03,1050706.28,566.25,93431.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','222947',4299806,'1636','219',3291039.05,3292023.60,984.55,162450.75,0.00,0.00,0.00,0.00,0.00),('5','95','580','222947',4299807,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','222947',4299808,'1638','220',487900.05,487957.92,57.87,17071.65,0.00,0.00,0.00,0.00,0.00),('5','95','582','222947',4299809,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223170',4303700,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223170',4303701,'1633','219',143728.88,143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223170',4303702,'1634','219',728753.61,728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','223170',4303703,'1635','219',1050706.28,1051911.87,1205.59,198922.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','223170',4303704,'1636','219',3292023.60,3293475.01,1451.41,239482.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','223170',4303705,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','223170',4303706,'1638','220',487957.92,488033.12,75.20,22184.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','223170',4303707,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223509',4309394,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223509',4309395,'1633','219',143728.88,143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223509',4309396,'1634','219',728753.61,728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','223509',4309397,'1635','219',1051911.87,1053292.53,1380.66,227808.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','223509',4309398,'1636','219',3293475.01,3294533.69,1058.68,174682.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','223509',4309399,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','223509',4309400,'1638','220',488033.12,488170.70,137.58,40586.10,0.00,0.00,0.00,0.00,0.00),('5','95','582','223509',4309401,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223651',4312129,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223651',4312130,'1633','219',143728.88,143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223651',4312131,'1634','219',728753.61,728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','223651',4312132,'1635','219',1053292.53,1054419.11,1126.58,185885.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','223651',4312133,'1636','219',3294533.69,3296064.60,1530.91,252600.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','223651',4312134,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','223651',4312135,'1638','220',488170.70,488196.72,26.02,7675.90,0.00,0.00,0.00,0.00,0.00),('5','95','582','223651',4312136,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223920',4316972,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223920',4316973,'1633','219',143728.88,143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','223920',4316974,'1634','219',728753.61,728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','223920',4316975,'1635','219',1054419.11,1055215.30,796.19,131371.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','223920',4316976,'1636','219',3296064.60,3296802.80,738.20,121803.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','223920',4316977,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','223920',4316978,'1638','220',488196.72,488302.86,106.14,31311.30,0.00,0.00,0.00,0.00,0.00),('5','95','582','223920',4316979,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224082',4319957,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224082',4319958,'1633','219',143728.88,143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224082',4319959,'1634','219',728753.61,728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','224082',4319960,'1635','219',1055215.30,1056449.20,1233.90,203593.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','224082',4319961,'1636','219',3296802.80,3297985.40,1182.60,195129.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','224082',4319962,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','224082',4319963,'1638','220',488302.86,488358.75,55.89,16487.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','224082',4319964,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224325',4324250,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224325',4324251,'1633','219',143728.88,143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224325',4324252,'1634','219',728753.61,728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','224325',4324253,'1635','219',1056449.20,1057468.00,1018.80,168102.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','224325',4324254,'1636','219',3297985.40,3298935.20,949.80,156717.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','224325',4324255,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','224325',4324256,'1638','220',488358.75,488381.80,23.05,6799.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','224325',4324257,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224571',4328447,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224571',4328448,'1633','219',143728.88,143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224571',4328449,'1634','219',728753.61,728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','224571',4328450,'1635','219',1057468.00,1058301.80,833.80,137577.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','224571',4328451,'1636','219',3298935.20,3300621.60,1686.40,278256.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','224571',4328452,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','224571',4328453,'1638','220',488381.80,488408.89,27.09,7991.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','224571',4328454,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224819',4332773,'1632','219',1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224819',4332774,'1633','219',143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224819',4332775,'1634','219',728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','224819',4332776,'1635','219',1058301.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','224819',4332777,'1636','219',3300621.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','224819',4332778,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','224819',4332779,'1638','220',488408.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','224819',4332780,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224864',4333606,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224864',4333607,'1633','219',143728.88,143728.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','224864',4333608,'1634','219',728753.61,728753.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','224864',4333609,'1635','219',1058301.80,1059525.90,1224.10,199528.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','224864',4333610,'1636','219',3300621.60,3301652.90,1031.30,168101.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','224864',4333611,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','224864',4333612,'1638','220',488408.89,488427.35,18.46,5445.70,0.00,0.00,0.00,0.00,0.00),('5','95','582','224864',4333613,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225031',4336668,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225031',4336669,'1633','219',143728.88,144630.97,902.09,147040.67,0.00,0.00,0.00,0.00,0.00),('5','95','578','225031',4336670,'1634','219',728753.61,728766.99,13.38,2180.94,0.00,0.00,0.00,0.00,0.00),('5','95','579','225031',4336671,'1635','219',1059525.90,1060167.60,641.70,104597.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','225031',4336672,'1636','219',3301652.90,3302653.70,1000.80,163130.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','225031',4336673,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','225031',4336674,'1638','220',488427.35,488427.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','225031',4336675,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225493',4345170,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225493',4345171,'1633','219',144630.97,145592.06,961.09,156657.67,0.00,0.00,0.00,0.00,0.00),('5','95','578','225493',4345172,'1634','219',728766.99,729429.40,662.41,107972.83,0.00,0.00,0.00,0.00,0.00),('5','95','579','225493',4345173,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','225493',4345174,'1636','219',3302653.70,3303090.70,437.00,71231.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','225493',4345175,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','225493',4345176,'1638','220',488427.35,488530.00,102.65,30281.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','225493',4345177,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225575',4346652,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225575',4346653,'1633','219',145592.06,146383.78,791.72,129050.36,0.00,0.00,0.00,0.00,0.00),('5','95','578','225575',4346654,'1634','219',729429.40,730137.34,707.94,115394.22,0.00,0.00,0.00,0.00,0.00),('5','95','579','225575',4346655,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','225575',4346656,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','225575',4346657,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','225575',4346658,'1638','220',488530.00,488558.97,28.97,8546.15,0.00,0.00,0.00,0.00,0.00),('5','95','582','225575',4346659,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225692',4348685,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225692',4348686,'1633','219',146383.78,147550.31,1166.53,190144.39,0.00,0.00,0.00,0.00,0.00),('5','95','578','225692',4348687,'1634','219',730137.34,731364.34,1227.00,200001.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','225692',4348688,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','225692',4348689,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','225692',4348690,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','225692',4348691,'1638','220',488558.97,488708.47,149.50,44102.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','225692',4348692,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225971',4353356,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','225971',4353357,'1633','219',147550.31,148536.99,986.68,160828.84,0.00,0.00,0.00,0.00,0.00),('5','95','578','225971',4353358,'1634','219',731364.34,732275.07,910.73,148448.99,0.00,0.00,0.00,0.00,0.00),('5','95','579','225971',4353359,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','225971',4353360,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','225971',4353361,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','225971',4353362,'1638','220',488708.47,488981.44,272.97,80526.15,0.00,0.00,0.00,0.00,0.00),('5','95','582','225971',4353363,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','226303',4359305,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','226303',4359306,'1633','219',148536.99,149402.09,865.10,141011.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','226303',4359307,'1634','219',732275.07,733594.87,1319.80,215127.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','226303',4359308,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','226303',4359309,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','226303',4359310,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','226303',4359311,'1638','220',488981.44,489143.19,161.75,47716.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','226303',4359312,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','226505',4362960,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','226505',4362961,'1633','219',149402.09,150870.22,1468.13,239305.19,0.00,0.00,0.00,0.00,0.00),('5','95','578','226505',4362962,'1634','219',733594.87,734935.92,1341.05,218591.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','226505',4362963,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','226505',4362964,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','226505',4362965,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','226505',4362966,'1638','220',489143.19,489287.88,144.69,42683.55,0.00,0.00,0.00,0.00,0.00),('5','95','582','226505',4362967,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','226789',4368070,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','226789',4368071,'1633','219',150870.22,152422.74,1552.52,253060.76,0.00,0.00,0.00,0.00,0.00),('5','95','578','226789',4368072,'1634','219',734935.92,736429.37,1493.45,243432.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','226789',4368073,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','226789',4368074,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','226789',4368075,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','226789',4368076,'1638','220',489287.88,489370.20,82.32,24284.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','226789',4368077,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227074',4373120,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227074',4373121,'1633','219',152422.74,153355.46,932.72,152033.36,0.00,0.00,0.00,0.00,0.00),('5','95','578','227074',4373122,'1634','219',736429.37,737482.76,1053.39,171702.57,0.00,0.00,0.00,0.00,0.00),('5','95','579','227074',4373123,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','227074',4373124,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','227074',4373125,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','227074',4373126,'1638','220',489370.20,489595.72,225.52,66528.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','227074',4373127,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227210',4375510,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227210',4375511,'1633','219',153355.46,154580.72,1225.26,199717.38,0.00,0.00,0.00,0.00,0.00),('5','95','578','227210',4375512,'1634','219',737482.76,738545.33,1062.57,173198.91,0.00,0.00,0.00,0.00,0.00),('5','95','579','227210',4375513,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','227210',4375514,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','227210',4375515,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','227210',4375516,'1638','220',489595.72,489729.42,133.70,39441.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','227210',4375517,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227370',4378528,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227370',4378529,'1633','219',154580.72,155839.38,1258.66,205161.58,0.00,0.00,0.00,0.00,0.00),('5','95','578','227370',4378530,'1634','219',738545.33,739641.89,1096.56,178739.28,0.00,0.00,0.00,0.00,0.00),('5','95','579','227370',4378531,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','227370',4378532,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','227370',4378533,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','227370',4378534,'1638','220',489729.42,489785.83,56.41,16640.95,0.00,0.00,0.00,0.00,0.00),('5','95','582','227370',4378535,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227608',4382568,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227608',4382569,'1633','219',155839.38,157413.48,1574.10,256578.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','227608',4382570,'1634','219',739641.89,740619.70,977.81,159383.03,0.00,0.00,0.00,0.00,0.00),('5','95','579','227608',4382571,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','227608',4382572,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','227608',4382573,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','227608',4382574,'1638','220',489785.83,490069.86,284.03,85209.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','227608',4382575,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227902',4387789,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','227902',4387790,'1633','219',157413.48,158636.07,1222.59,199282.17,0.00,0.00,0.00,0.00,0.00),('5','95','578','227902',4387791,'1634','219',740619.70,742069.68,1449.98,236346.74,0.00,0.00,0.00,0.00,0.00),('5','95','579','227902',4387792,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','227902',4387793,'1636','219',3303090.70,3303090.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','227902',4387794,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','227902',4387795,'1638','220',490069.86,490399.17,329.31,98793.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','227902',4387796,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','229926',4426202,'1632','219',1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','229926',4426203,'1633','219',160122.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','229926',4426204,'1634','219',743477.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','229926',4426205,'1635','219',1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','229926',4426206,'1636','219',3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','229926',4426207,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','229926',4426208,'1638','220',490499.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','229926',4426209,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231376',4451834,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231376',4451835,'1633','219',160122.40,161354.47,1232.07,200827.41,0.00,0.00,0.00,0.00,0.00),('5','95','578','231376',4451836,'1634','219',743477.68,744845.67,1367.99,222982.37,0.00,0.00,0.00,0.00,0.00),('5','95','579','231376',4451837,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','231376',4451838,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','231376',4451839,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','231376',4451840,'1638','220',490499.04,490684.37,185.33,55599.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','231376',4451841,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231499',4453842,'1632','219',1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231499',4453843,'1633','219',161354.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231499',4453844,'1634','219',744845.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','231499',4453845,'1635','219',1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','231499',4453846,'1636','219',3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','231499',4453847,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','231499',4453848,'1638','220',490684.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','231499',4453849,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231560',4455160,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231560',4455161,'1633','219',161354.47,164770.96,3416.49,556887.87,0.00,0.00,0.00,0.00,0.00),('5','95','578','231560',4455162,'1634','219',744845.67,746956.09,2110.42,343998.46,0.00,0.00,0.00,0.00,0.00),('5','95','579','231560',4455163,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','231560',4455164,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','231560',4455165,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','231560',4455166,'1638','220',490684.37,491288.19,603.82,181146.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','231560',4455167,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231642',4456442,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231642',4456443,'1633','219',164770.96,164770.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231642',4456444,'1634','219',746956.09,746956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','231642',4456445,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','231642',4456446,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','231642',4456447,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','231642',4456448,'1638','220',491288.19,494699.05,3410.86,1023258.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','231642',4456449,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231750',4458479,'1632','219',1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231750',4458480,'1633','219',164770.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','231750',4458481,'1634','219',746956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','231750',4458482,'1635','219',1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','231750',4458483,'1636','219',3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','231750',4458484,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','231750',4458485,'1638','220',494699.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','231750',4458486,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232464',4471355,'1632','219',1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232464',4471356,'1633','219',164770.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232464',4471357,'1634','219',746956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232464',4471358,'1635','219',1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232464',4471359,'1636','219',3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','232464',4471360,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','232464',4471361,'1638','220',494699.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','232464',4471362,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232468',4471432,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232468',4471433,'1633','219',164770.96,164770.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232468',4471434,'1634','219',746956.09,746956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232468',4471435,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232468',4471436,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','232468',4471437,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','232468',4471438,'1638','220',494699.05,495124.05,425.00,127500.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','232468',4471439,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232470',4471455,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232470',4471456,'1633','219',164770.96,164770.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232470',4471457,'1634','219',746956.09,746956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232470',4471458,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232470',4471459,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','232470',4471460,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','232470',4471461,'1638','220',495124.05,495440.70,316.65,94995.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','232470',4471462,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232471',4471463,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232471',4471464,'1633','219',164770.96,164770.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232471',4471465,'1634','219',746956.09,746956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232471',4471466,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232471',4471467,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','232471',4471468,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','232471',4471469,'1638','220',495440.70,495656.75,216.05,66975.50,0.00,0.00,0.00,0.00,0.00),('5','95','582','232471',4471470,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232473',4471497,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232473',4471498,'1633','219',164770.96,164770.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232473',4471499,'1634','219',746956.09,746956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232473',4471500,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232473',4471501,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','232473',4471502,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','232473',4471503,'1638','220',495656.75,495796.25,139.50,43245.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','232473',4471504,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232480',4471585,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232480',4471586,'1633','219',164770.96,164770.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232480',4471587,'1634','219',746956.09,746956.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232480',4471588,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232480',4471589,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','232480',4471590,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','232480',4471591,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','232480',4471592,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232482',4471647,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','232482',4471648,'1633','219',164770.96,165847.29,1076.33,175441.79,0.00,0.00,0.00,0.00,0.00),('5','95','578','232482',4471649,'1634','219',746956.09,747568.45,612.36,99814.68,0.00,0.00,0.00,0.00,0.00),('5','95','579','232482',4471650,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','232482',4471651,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','232482',4471652,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','232482',4471653,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','232482',4471654,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','233768',4494962,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','233768',4494963,'1633','219',165847.29,166894.40,1047.11,170678.93,0.00,0.00,0.00,0.00,0.00),('5','95','578','233768',4494964,'1634','219',747568.45,748663.56,1095.11,178502.93,0.00,0.00,0.00,0.00,0.00),('5','95','579','233768',4494965,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','233768',4494966,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','233768',4494967,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','233768',4494968,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','233768',4494969,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','233772',4495031,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','233772',4495032,'1633','219',166894.40,168799.97,1905.57,310607.91,0.00,0.00,0.00,0.00,0.00),('5','95','578','233772',4495033,'1634','219',748663.56,749661.49,997.93,162662.59,0.00,0.00,0.00,0.00,0.00),('5','95','579','233772',4495034,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','233772',4495035,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','233772',4495036,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','233772',4495037,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','233772',4495038,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234220',4503144,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234220',4503145,'1633','219',168799.97,169797.61,997.64,162615.32,0.00,0.00,0.00,0.00,0.00),('5','95','578','234220',4503146,'1634','219',749661.49,750822.27,1160.78,189207.14,0.00,0.00,0.00,0.00,0.00),('5','95','579','234220',4503147,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234220',4503148,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234220',4503149,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234220',4503150,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234220',4503151,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234225',4503236,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234225',4503237,'1633','219',169797.61,170922.63,1125.02,183378.26,0.00,0.00,0.00,0.00,0.00),('5','95','578','234225',4503238,'1634','219',750822.27,751798.80,976.53,159174.39,0.00,0.00,0.00,0.00,0.00),('5','95','579','234225',4503239,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234225',4503240,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234225',4503241,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234225',4503242,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234225',4503243,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234226',4503244,'1632','219',1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234226',4503245,'1633','219',170922.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234226',4503246,'1634','219',751798.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234226',4503247,'1635','219',1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234226',4503248,'1636','219',3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234226',4503249,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234226',4503250,'1638','220',495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234226',4503251,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234230',4503362,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234230',4503363,'1633','219',170922.63,172543.81,1621.18,264252.34,0.00,0.00,0.00,0.00,0.00),('5','95','578','234230',4503364,'1634','219',751798.80,753751.70,1952.90,318322.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','234230',4503365,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234230',4503366,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234230',4503367,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234230',4503368,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234230',4503369,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234232',4503386,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234232',4503387,'1633','219',172543.81,174903.11,2359.30,384565.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','234232',4503388,'1634','219',753751.70,755956.55,2204.85,359390.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','234232',4503389,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234232',4503390,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234232',4503391,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234232',4503392,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234232',4503393,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234233',4503394,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234233',4503395,'1633','219',174903.11,178038.81,3135.70,511119.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','234233',4503396,'1634','219',755956.55,759485.45,3528.90,575210.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','234233',4503397,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234233',4503398,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234233',4503399,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234233',4503400,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234233',4503401,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234234',4503402,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234234',4503403,'1633','219',178038.81,180480.98,2442.17,398073.71,0.00,0.00,0.00,0.00,0.00),('5','95','578','234234',4503404,'1634','219',759485.45,762361.45,2876.00,468788.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234234',4503405,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234234',4503406,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234234',4503407,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234234',4503408,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234234',4503409,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234236',4503434,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234236',4503435,'1633','219',180480.98,184437.02,3956.04,644834.52,0.00,0.00,0.00,0.00,0.00),('5','95','578','234236',4503436,'1634','219',762361.45,766015.86,3654.41,595668.83,0.00,0.00,0.00,0.00,0.00),('5','95','579','234236',4503437,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234236',4503438,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234236',4503439,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234236',4503440,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234236',4503441,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234237',4503442,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234237',4503443,'1633','219',184437.02,184918.01,480.99,78401.37,0.00,0.00,0.00,0.00,0.00),('5','95','578','234237',4503444,'1634','219',766015.86,766646.48,630.62,102791.06,0.00,0.00,0.00,0.00,0.00),('5','95','579','234237',4503445,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234237',4503446,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234237',4503447,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234237',4503448,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234237',4503449,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234986',4516834,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234986',4516835,'1633','219',184918.01,184918.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234986',4516836,'1634','219',766646.48,766646.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234986',4516837,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234986',4516838,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234986',4516839,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234986',4516840,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234986',4516841,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234989',4516887,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234989',4516888,'1633','219',184918.01,184918.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234989',4516889,'1634','219',766646.48,766646.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234989',4516890,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234989',4516891,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234989',4516892,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234989',4516893,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234989',4516894,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234991',4516935,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234991',4516936,'1633','219',184918.01,184918.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234991',4516937,'1634','219',766646.48,766646.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234991',4516938,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234991',4516939,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234991',4516940,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234991',4516941,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234991',4516942,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234992',4516943,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234992',4516944,'1633','219',184918.01,184918.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234992',4516945,'1634','219',766646.48,766646.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234992',4516946,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234992',4516947,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234992',4516948,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234992',4516949,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234992',4516950,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234994',4516975,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234994',4516976,'1633','219',184918.01,184918.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','234994',4516977,'1634','219',766646.48,766646.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234994',4516978,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','234994',4516979,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','234994',4516980,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','234994',4516981,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','234994',4516982,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','235160',4519841,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','235160',4519842,'1633','219',184918.01,184918.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','235160',4519843,'1634','219',766646.48,766646.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','235160',4519844,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','235160',4519845,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','235160',4519846,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','235160',4519847,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','235160',4519848,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236368',4541010,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236368',4541011,'1633','219',184918.01,184918.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236368',4541012,'1634','219',766646.48,766646.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236368',4541013,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236368',4541014,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','236368',4541015,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','236368',4541016,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','236368',4541017,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236371',4541047,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236371',4541048,'1633','219',184918.01,187975.13,3057.12,504424.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','236371',4541049,'1634','219',766646.48,770022.01,3375.53,556962.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','236371',4541050,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236371',4541051,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','236371',4541052,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','236371',4541053,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','236371',4541054,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236405',4541680,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236405',4541681,'1633','219',187975.13,192059.22,4084.09,673874.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','236405',4541682,'1634','219',770022.01,773986.32,3964.31,654111.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','236405',4541683,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236405',4541684,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','236405',4541685,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','236405',4541686,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','236405',4541687,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236409',4541737,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236409',4541738,'1633','219',192059.22,192059.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236409',4541739,'1634','219',773986.32,774511.32,525.00,86625.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236409',4541740,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236409',4541741,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','236409',4541742,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','236409',4541743,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','236409',4541744,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236443',4542413,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236443',4542414,'1633','219',192059.22,192603.35,544.13,89781.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','236443',4542415,'1634','219',774511.32,781738.43,7227.11,1192473.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','236443',4542416,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236443',4542417,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','236443',4542418,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','236443',4542419,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','236443',4542420,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236626',4545395,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236626',4545396,'1633','219',192603.35,195523.50,2920.15,481824.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','236626',4545397,'1634','219',781738.43,785252.75,3514.32,579862.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','236626',4545398,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236626',4545399,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','236626',4545400,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','236626',4545401,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','236626',4545402,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236843',4549183,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','236843',4549184,'1633','219',195523.50,195998.37,474.87,78353.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','236843',4549185,'1634','219',785252.75,785752.88,500.13,82521.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','236843',4549186,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','236843',4549187,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','236843',4549188,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','236843',4549189,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','236843',4549190,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237781',4565627,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237781',4565628,'1633','219',195998.37,195998.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237781',4565629,'1634','219',785752.88,785752.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237781',4565630,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237781',4565631,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','237781',4565632,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','237781',4565633,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','237781',4565634,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237784',4565689,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237784',4565690,'1633','219',195998.37,195998.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237784',4565691,'1634','219',785752.88,785752.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237784',4565692,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237784',4565693,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','237784',4565694,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','237784',4565695,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','237784',4565696,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237833',4566631,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237833',4566632,'1633','219',195998.37,195998.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237833',4566633,'1634','219',785752.88,785752.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237833',4566634,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237833',4566635,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','237833',4566636,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','237833',4566637,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','237833',4566638,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237964',4568673,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237964',4568674,'1633','219',195998.37,195998.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237964',4568675,'1634','219',785752.88,785752.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237964',4568676,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237964',4568677,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','237964',4568678,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','237964',4568679,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','237964',4568680,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237990',4568978,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237990',4568979,'1633','219',195998.37,195998.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','237990',4568980,'1634','219',785752.88,785752.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237990',4568981,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','237990',4568982,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','237990',4568983,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','237990',4568984,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','237990',4568985,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238266',4573699,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238266',4573700,'1633','219',195998.37,197546.36,1547.99,255418.35,0.00,0.00,0.00,0.00,0.00),('5','95','578','238266',4573701,'1634','219',785752.88,786996.36,1243.48,205174.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','238266',4573702,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','238266',4573703,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','238266',4573704,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','238266',4573705,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','238266',4573706,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238815',4583276,'1632','219',1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238815',4583277,'1633','219',197546.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238815',4583278,'1634','219',786996.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','238815',4583279,'1635','219',1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','238815',4583280,'1636','219',3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','238815',4583281,'1637','219',3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','238815',4583282,'1638','220',495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','238815',4583283,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238991',4586433,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238991',4586434,'1633','219',197546.36,199485.32,1938.96,319928.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','238991',4586435,'1634','219',786996.36,789316.86,2320.50,382882.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','238991',4586436,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','238991',4586437,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','238991',4586438,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','238991',4586439,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','238991',4586440,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238993',4586458,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238993',4586459,'1633','219',199485.32,200784.06,1298.74,214292.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','238993',4586460,'1634','219',789316.86,791157.50,1840.64,303705.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','238993',4586461,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','238993',4586462,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','238993',4586463,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','238993',4586464,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','238993',4586465,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238994',4586466,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','238994',4586467,'1633','219',200784.06,202619.44,1835.38,302837.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','238994',4586468,'1634','219',791157.50,793140.50,1983.00,327195.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','238994',4586469,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','238994',4586470,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','238994',4586471,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','238994',4586472,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','238994',4586473,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239171',4589444,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239171',4589445,'1633','219',202619.44,206332.06,3712.62,612582.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','239171',4589446,'1634','219',793140.50,796575.99,3435.49,566855.85,0.00,0.00,0.00,0.00,0.00),('5','95','579','239171',4589447,'1635','219',1060167.60,1060167.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','239171',4589448,'1636','219',3303141.00,3303141.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','239171',4589449,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','239171',4589450,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','239171',4589451,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239360',4592578,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239360',4592579,'1633','219',206332.06,206914.96,582.90,96178.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','239360',4592580,'1634','219',796575.99,797048.75,472.76,78005.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','239360',4592581,'1635','219',1060167.60,1061864.00,1696.40,279906.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','239360',4592582,'1636','219',3303141.00,3304701.80,1560.80,257532.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','239360',4592583,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','239360',4592584,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','239360',4592585,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239693',4598497,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239693',4598498,'1633','219',206914.96,206914.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239693',4598499,'1634','219',797048.75,798729.34,1680.59,273936.17,0.00,0.00,0.00,0.00,0.00),('5','95','579','239693',4598500,'1635','219',1061864.00,1063403.00,1539.00,250857.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','239693',4598501,'1636','219',3304701.80,3306219.40,1517.60,247368.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','239693',4598502,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','239693',4598503,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','239693',4598504,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239963',4603219,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','239963',4603220,'1633','219',206914.96,207477.00,562.04,91612.52,0.00,0.00,0.00,0.00,0.00),('5','95','578','239963',4603221,'1634','219',798729.34,800857.14,2127.80,346831.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','239963',4603222,'1635','219',1063403.00,1064437.00,1034.00,168542.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','239963',4603223,'1636','219',3306219.40,3307739.70,1520.30,247808.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','239963',4603224,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','239963',4603225,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','239963',4603226,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240078',4605121,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240078',4605122,'1633','219',207477.00,209529.01,2052.01,338581.65,0.00,0.00,0.00,0.00,0.00),('5','95','578','240078',4605123,'1634','219',800857.14,802436.51,1579.37,260596.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','240078',4605124,'1635','219',1064437.00,1064437.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','240078',4605125,'1636','219',3307739.70,3309327.15,1587.45,261929.25,0.00,0.00,0.00,0.00,0.00),('5','95','580','240078',4605126,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','240078',4605127,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','240078',4605128,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240344',4609762,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240344',4609763,'1633','219',209529.01,213054.90,3525.89,581771.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','240344',4609764,'1634','219',802436.51,804857.72,2421.21,399499.65,0.00,0.00,0.00,0.00,0.00),('5','95','579','240344',4609765,'1635','219',1064437.00,1064437.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','240344',4609766,'1636','219',3309327.15,3309393.70,66.55,10980.75,0.00,0.00,0.00,0.00,0.00),('5','95','580','240344',4609767,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','240344',4609768,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','240344',4609769,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240481',4611682,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240481',4611683,'1633','219',213054.90,213565.60,510.70,83244.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','240481',4611684,'1634','219',804857.72,805474.64,616.92,100557.96,0.00,0.00,0.00,0.00,0.00),('5','95','579','240481',4611685,'1635','219',1064437.00,1065672.74,1235.74,201425.62,0.00,0.00,0.00,0.00,0.00),('5','95','579','240481',4611686,'1636','219',3309393.70,3311835.94,2442.24,398085.12,0.00,0.00,0.00,0.00,0.00),('5','95','580','240481',4611687,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','240481',4611688,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','240481',4611689,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240762',4616177,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240762',4616178,'1633','219',213565.60,213565.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','240762',4616179,'1634','219',805474.64,805474.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','240762',4616180,'1635','219',1065672.74,1067942.80,2270.06,370019.78,0.00,0.00,0.00,0.00,0.00),('5','95','579','240762',4616181,'1636','219',3311835.94,3314664.70,2828.76,461087.88,0.00,0.00,0.00,0.00,0.00),('5','95','580','240762',4616182,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','240762',4616183,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','240762',4616184,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241172',4623726,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241172',4623727,'1633','219',213565.60,213565.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241172',4623728,'1634','219',805474.64,805474.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','241172',4623729,'1635','219',1067942.80,1070591.80,2649.00,437085.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','241172',4623730,'1636','219',3314664.70,3318229.90,3565.20,588258.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','241172',4623731,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','241172',4623732,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','241172',4623733,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241414',4627838,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241414',4627839,'1633','219',213565.60,213565.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241414',4627840,'1634','219',805474.64,805474.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','241414',4627841,'1635','219',1070591.80,1070591.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','241414',4627842,'1636','219',3318229.90,3318229.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','241414',4627843,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','241414',4627844,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','241414',4627845,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241769',4633862,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241769',4633863,'1633','219',213565.60,213565.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241769',4633864,'1634','219',805474.64,805474.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','241769',4633865,'1635','219',1070591.80,1071823.30,1231.50,203197.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','241769',4633866,'1636','219',3318229.90,3320297.30,2067.40,341121.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','241769',4633867,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','241769',4633868,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','241769',4633869,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241794',4634308,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241794',4634309,'1633','219',213565.60,213565.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241794',4634310,'1634','219',805474.64,805474.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','241794',4634311,'1635','219',1071823.30,1071954.01,130.71,21567.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','241794',4634312,'1636','219',3320297.30,3321089.50,792.20,130713.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','241794',4634313,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','241794',4634314,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','241794',4634315,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241822',4634702,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241822',4634703,'1633','219',213565.60,213565.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','241822',4634704,'1634','219',805474.64,805474.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','241822',4634705,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','241822',4634706,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','241822',4634707,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','241822',4634708,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','241822',4634709,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242076',4639216,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242076',4639217,'1633','219',213565.60,215881.30,2315.70,382090.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','242076',4639218,'1634','219',805474.64,808245.89,2771.25,457256.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','242076',4639219,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','242076',4639220,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','242076',4639221,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','242076',4639222,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','242076',4639223,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242391',4644962,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242391',4644963,'1633','219',215881.30,217877.97,1996.67,329450.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','242391',4644964,'1634','219',808245.89,810331.53,2085.64,344130.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','242391',4644965,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','242391',4644966,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','242391',4644967,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','242391',4644968,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','242391',4644969,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242452',4645668,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242452',4645669,'1633','219',217877.97,219401.02,1523.05,251303.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','242452',4645670,'1634','219',810331.53,812495.01,2163.48,356974.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','242452',4645671,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','242452',4645672,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','242452',4645673,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','242452',4645674,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','242452',4645675,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242725',4650543,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242725',4650544,'1633','219',219401.02,219401.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','242725',4650545,'1634','219',812495.01,812495.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','242725',4650546,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','242725',4650547,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','242725',4650548,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','242725',4650549,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','242725',4650550,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243058',4656412,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243058',4656413,'1633','219',219401.02,219401.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243058',4656414,'1634','219',812495.01,812495.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243058',4656415,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243058',4656416,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','243058',4656417,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','243058',4656418,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','243058',4656419,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243339',4661544,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243339',4661545,'1633','219',219401.02,219401.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243339',4661546,'1634','219',812495.01,812495.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243339',4661547,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243339',4661548,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','243339',4661549,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','243339',4661550,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','243339',4661551,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243471',4663644,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243471',4663645,'1633','219',219401.02,219401.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243471',4663646,'1634','219',812495.01,812495.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243471',4663647,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243471',4663648,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','243471',4663649,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','243471',4663650,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','243471',4663651,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243670',4666909,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243670',4666910,'1633','219',219401.02,219401.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243670',4666911,'1634','219',812495.01,812495.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243670',4666912,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243670',4666913,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','243670',4666914,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','243670',4666915,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','243670',4666916,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243833',4669878,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','243833',4669879,'1633','219',219401.02,221670.33,2269.31,385782.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','243833',4669880,'1634','219',812495.01,814228.10,1733.09,294625.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','243833',4669881,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','243833',4669882,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','243833',4669883,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','243833',4669884,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','243833',4669885,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','244163',4675528,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','244163',4675529,'1633','219',221670.33,223748.10,2077.77,353220.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','244163',4675530,'1634','219',814228.10,816171.78,1943.68,330425.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','244163',4675531,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','244163',4675532,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','244163',4675533,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','244163',4675534,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','244163',4675535,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','244385',4679449,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','244385',4679450,'1633','219',223748.10,225821.99,2073.89,352561.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','244385',4679451,'1634','219',816171.78,819148.81,2977.03,506095.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','244385',4679452,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','244385',4679453,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','244385',4679454,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','244385',4679455,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','244385',4679456,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','244550',4682119,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','244550',4682120,'1633','219',225821.99,227709.90,1887.91,320944.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','244550',4682121,'1634','219',819148.81,820644.75,1495.94,254309.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','244550',4682122,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','244550',4682123,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','244550',4682124,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','244550',4682125,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','244550',4682126,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','244773',4685849,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','244773',4685850,'1633','219',227709.90,229064.61,1354.71,230300.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','244773',4685851,'1634','219',820644.75,822478.42,1833.67,311723.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','244773',4685852,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','244773',4685853,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','244773',4685854,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','244773',4685855,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','244773',4685856,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245012',4690026,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245012',4690027,'1633','219',229064.61,230900.93,1836.32,312174.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','245012',4690028,'1634','219',822478.42,824467.64,1989.22,338167.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','245012',4690029,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','245012',4690030,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','245012',4690031,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','245012',4690032,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','245012',4690033,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245266',4694493,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245266',4694494,'1633','219',230900.93,230900.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245266',4694495,'1634','219',824467.64,824467.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','245266',4694496,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','245266',4694497,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','245266',4694498,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','245266',4694499,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','245266',4694500,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245762',4703373,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245762',4703374,'1633','219',230900.93,230900.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245762',4703375,'1634','219',824467.64,824467.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','245762',4703376,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','245762',4703377,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','245762',4703378,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','245762',4703379,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','245762',4703380,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245770',4703538,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245770',4703539,'1633','219',230900.93,230900.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','245770',4703540,'1634','219',824467.64,824467.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','245770',4703541,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','245770',4703542,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','245770',4703543,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','245770',4703544,'1638','220',495796.25,495796.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','245770',4703545,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246016',4707135,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246016',4707136,'1633','219',230900.93,232439.53,1538.60,261562.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246016',4707137,'1634','219',824467.64,826466.09,1998.45,339736.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','246016',4707138,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','246016',4707139,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','246016',4707140,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','246016',4707141,'1638','220',495796.25,495848.00,51.75,17853.75,0.00,0.00,0.00,0.00,0.00),('5','95','582','246016',4707142,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246277',4711537,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246277',4711538,'1633','219',232439.53,233689.01,1249.48,212411.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','246277',4711539,'1634','219',826466.09,828291.21,1825.12,310270.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','246277',4711540,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','246277',4711541,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','246277',4711542,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','246277',4711543,'1638','220',495848.00,496103.09,255.09,88006.05,0.00,0.00,0.00,0.00,0.00),('5','95','582','246277',4711544,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246548',4716222,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246548',4716223,'1633','219',233689.01,235605.01,1916.00,325720.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246548',4716224,'1634','219',828291.21,829441.01,1149.80,195466.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','246548',4716225,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','246548',4716226,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','246548',4716227,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','246548',4716228,'1638','220',496103.09,496499.91,396.82,136902.90,0.00,0.00,0.00,0.00,0.00),('5','95','582','246548',4716229,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246733',4719152,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','246733',4719153,'1633','219',235605.01,237252.76,1647.75,280117.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','246733',4719154,'1634','219',829441.01,831875.28,2434.27,413825.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','246733',4719155,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','246733',4719156,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','246733',4719157,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','246733',4719158,'1638','220',496499.91,496622.32,122.41,42231.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','246733',4719159,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247003',4724038,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247003',4724039,'1633','219',237252.76,237901.15,648.39,110226.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','247003',4724040,'1634','219',831875.28,832436.99,561.71,95490.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','247003',4724041,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','247003',4724042,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','247003',4724043,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','247003',4724044,'1638','220',496622.32,496747.32,125.00,43125.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','247003',4724045,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247205',4727350,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247205',4727351,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247205',4727352,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','247205',4727353,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','247205',4727354,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','247205',4727355,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','247205',4727356,'1638','220',496747.32,496962.35,215.03,64509.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','247205',4727357,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247481',4732463,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247481',4732464,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247481',4732465,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','247481',4732466,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','247481',4732467,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','247481',4732468,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','247481',4732469,'1638','220',496962.35,497397.38,435.03,150085.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','247481',4732470,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247816',4738044,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247816',4738045,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','247816',4738046,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','247816',4738047,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','247816',4738048,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','247816',4738049,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','247816',4738050,'1638','220',497397.38,497600.39,203.01,70038.45,0.00,0.00,0.00,0.00,0.00),('5','95','582','247816',4738051,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248017',4741366,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248017',4741367,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248017',4741368,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','248017',4741369,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','248017',4741370,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','248017',4741371,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','248017',4741372,'1638','220',497600.39,497724.42,124.03,42790.35,0.00,0.00,0.00,0.00,0.00),('5','95','582','248017',4741373,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248195',4744403,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248195',4744404,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248195',4744405,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','248195',4744406,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','248195',4744407,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','248195',4744408,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','248195',4744409,'1638','220',497724.42,497876.50,152.08,52467.60,0.00,0.00,0.00,0.00,0.00),('5','95','582','248195',4744410,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248482',4749243,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248482',4749244,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248482',4749245,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','248482',4749246,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','248482',4749247,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','248482',4749248,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','248482',4749249,'1638','220',497876.50,498011.62,135.12,46616.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','248482',4749250,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248795',4754683,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248795',4754684,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','248795',4754685,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','248795',4754686,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','248795',4754687,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','248795',4754688,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','248795',4754689,'1638','220',498011.62,498276.75,265.13,91469.85,0.00,0.00,0.00,0.00,0.00),('5','95','582','248795',4754690,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249080',4759528,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249080',4759529,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249080',4759530,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249080',4759531,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249080',4759532,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','249080',4759533,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','249080',4759534,'1638','220',498276.75,498761.87,485.12,167366.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','249080',4759535,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249187',4761067,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249187',4761068,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249187',4761069,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249187',4761070,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249187',4761071,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','249187',4761072,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','249187',4761073,'1638','220',498761.87,499296.19,534.32,184340.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','249187',4761074,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249428',4765301,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249428',4765302,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249428',4765303,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249428',4765304,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249428',4765305,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','249428',4765306,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','249428',4765307,'1638','220',499296.19,499699.31,403.12,139076.40,0.00,0.00,0.00,0.00,0.00),('5','95','582','249428',4765308,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249658',4769112,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249658',4769113,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249658',4769114,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249658',4769115,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249658',4769116,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','249658',4769117,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','249658',4769118,'1638','220',499699.31,500564.16,864.85,298373.25,0.00,0.00,0.00,0.00,0.00),('5','95','582','249658',4769119,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249904',4773221,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249904',4773222,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','249904',4773223,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249904',4773224,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','249904',4773225,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','249904',4773226,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','249904',4773227,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','249904',4773228,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','250169',4777760,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','250169',4777761,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','250169',4777762,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','250169',4777763,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','250169',4777764,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','250169',4777765,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','250169',4777766,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','250169',4777767,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','250642',4785549,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','250642',4785550,'1633','219',237901.15,237901.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','250642',4785551,'1634','219',832436.99,832436.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','250642',4785552,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','250642',4785553,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','250642',4785554,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','250642',4785555,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','250642',4785556,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','250752',4787747,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','250752',4787748,'1633','219',237901.15,240308.26,2407.11,409208.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','250752',4787749,'1634','219',832436.99,835068.74,2631.75,447397.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','250752',4787750,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','250752',4787751,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','250752',4787752,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','250752',4787753,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','250752',4787754,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251198',4795588,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251198',4795589,'1633','219',240308.26,244188.72,3880.46,659678.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','251198',4795590,'1634','219',835068.74,839270.47,4201.73,714294.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','251198',4795591,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','251198',4795592,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','251198',4795593,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','251198',4795594,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','251198',4795595,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251441',4799714,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251441',4799715,'1633','219',244188.72,246631.99,2443.27,415355.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','251441',4799716,'1634','219',839270.47,842206.24,2935.77,499080.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','251441',4799717,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','251441',4799718,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','251441',4799719,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','251441',4799720,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','251441',4799721,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251491',4800654,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251491',4800655,'1633','219',246631.99,248771.54,2139.55,353025.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','251491',4800656,'1634','219',842206.24,844578.06,2371.82,391350.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','251491',4800657,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','251491',4800658,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','251491',4800659,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','251491',4800660,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','251491',4800661,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251627',4802915,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251627',4802916,'1633','219',248771.54,251357.84,2586.30,426739.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','251627',4802917,'1634','219',844578.06,847193.52,2615.46,431550.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','251627',4802918,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','251627',4802919,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','251627',4802920,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','251627',4802921,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','251627',4802922,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251818',4806178,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','251818',4806179,'1633','219',251357.84,253702.77,2344.93,386913.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','251818',4806180,'1634','219',847193.52,850122.41,2928.89,483266.85,0.00,0.00,0.00,0.00,0.00),('5','95','579','251818',4806181,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','251818',4806182,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','251818',4806183,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','251818',4806184,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','251818',4806185,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252228',4813479,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252228',4813480,'1633','219',253702.77,255915.29,2212.52,365065.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','252228',4813481,'1634','219',850122.41,852753.28,2630.87,434093.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','252228',4813482,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','252228',4813483,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','252228',4813484,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','252228',4813485,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','252228',4813486,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252428',4817098,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252428',4817099,'1633','219',255915.29,256755.11,839.82,138570.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','252428',4817100,'1634','219',852753.28,853430.14,676.86,111681.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','252428',4817101,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','252428',4817102,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','252428',4817103,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','252428',4817104,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','252428',4817105,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252705',4821923,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252705',4821924,'1633','219',256755.11,256755.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252705',4821925,'1634','219',853430.14,853430.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','252705',4821926,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','252705',4821927,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','252705',4821928,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','252705',4821929,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','252705',4821930,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252911',4825231,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252911',4825232,'1633','219',256755.11,256755.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','252911',4825233,'1634','219',853430.14,853430.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','252911',4825234,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','252911',4825235,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','252911',4825236,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','252911',4825237,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','252911',4825238,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253013',4826636,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253013',4826637,'1633','219',256755.11,256755.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253013',4826638,'1634','219',853430.14,853430.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','253013',4826639,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','253013',4826640,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','253013',4826641,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','253013',4826642,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','253013',4826643,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253330',4832143,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253330',4832144,'1633','219',256755.11,256755.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253330',4832145,'1634','219',853430.14,853430.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','253330',4832146,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','253330',4832147,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','253330',4832148,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','253330',4832149,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','253330',4832150,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253870',4841735,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253870',4841736,'1633','219',256755.11,259447.00,2691.89,444161.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','253870',4841737,'1634','219',853430.14,855709.11,2278.97,376030.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','253870',4841738,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','253870',4841739,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','253870',4841740,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','253870',4841741,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','253870',4841742,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253886',4842074,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253886',4842075,'1633','219',259447.00,262197.58,2750.58,453845.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','253886',4842076,'1634','219',855709.11,858046.53,2337.42,385674.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','253886',4842077,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','253886',4842078,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','253886',4842079,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','253886',4842080,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','253886',4842081,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253974',4843208,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','253974',4843209,'1633','219',262197.58,264885.62,2688.04,443526.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','253974',4843210,'1634','219',858046.53,860588.53,2542.00,419430.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','253974',4843211,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','253974',4843212,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','253974',4843213,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','253974',4843214,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','253974',4843215,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254355',4850125,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254355',4850126,'1633','219',264885.62,267052.51,2166.89,357536.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','254355',4850127,'1634','219',860588.53,863524.73,2936.20,484473.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','254355',4850128,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','254355',4850129,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','254355',4850130,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','254355',4850131,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','254355',4850132,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254554',4853439,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254554',4853440,'1633','219',267052.51,268853.20,1800.69,297113.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','254554',4853441,'1634','219',863524.73,866376.26,2851.53,470502.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','254554',4853442,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','254554',4853443,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','254554',4853444,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','254554',4853445,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','254554',4853446,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254825',4858191,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254825',4858192,'1633','219',268853.20,269655.42,802.22,130761.86,0.00,0.00,0.00,0.00,0.00),('5','95','578','254825',4858193,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','254825',4858194,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','254825',4858195,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','254825',4858196,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','254825',4858197,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','254825',4858198,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254985',4860729,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254985',4860730,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','254985',4860731,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','254985',4860732,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','254985',4860733,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','254985',4860734,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','254985',4860735,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','254985',4860736,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','255443',4868974,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','255443',4868975,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','255443',4868976,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','255443',4868977,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','255443',4868978,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','255443',4868979,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','255443',4868980,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','255443',4868981,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','255705',4873210,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','255705',4873211,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','255705',4873212,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','255705',4873213,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','255705',4873214,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','255705',4873215,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','255705',4873216,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','255705',4873217,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256044',4878759,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256044',4878760,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256044',4878761,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256044',4878762,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256044',4878763,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','256044',4878764,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','256044',4878765,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','256044',4878766,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256101',4879697,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256101',4879698,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256101',4879699,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256101',4879700,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256101',4879701,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','256101',4879702,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','256101',4879703,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','256101',4879704,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256230',4881437,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256230',4881438,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256230',4881439,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256230',4881440,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256230',4881441,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','256230',4881442,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','256230',4881443,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','256230',4881444,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256522',4886517,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256522',4886518,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256522',4886519,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256522',4886520,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256522',4886521,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','256522',4886522,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','256522',4886523,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','256522',4886524,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256787',4890888,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256787',4890889,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','256787',4890890,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256787',4890891,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','256787',4890892,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','256787',4890893,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','256787',4890894,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','256787',4890895,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257163',4897892,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257163',4897893,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257163',4897894,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257163',4897895,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257163',4897896,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257163',4897897,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257163',4897898,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257163',4897899,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257381',4901705,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257381',4901706,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257381',4901707,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257381',4901708,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257381',4901709,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257381',4901710,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257381',4901711,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257381',4901712,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257382',4901713,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257382',4901714,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257382',4901715,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257382',4901716,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257382',4901717,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257382',4901718,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257382',4901719,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257382',4901720,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257383',4901721,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257383',4901722,'1633','219',269655.42,269655.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257383',4901723,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257383',4901724,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257383',4901725,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257383',4901726,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257383',4901727,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257383',4901728,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257384',4901729,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257384',4901730,'1633','219',269655.42,270879.93,1224.51,202044.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','257384',4901731,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257384',4901732,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257384',4901733,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257384',4901734,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257384',4901735,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257384',4901736,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257385',4901737,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257385',4901738,'1633','219',270879.93,275892.18,5012.25,827021.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','257385',4901739,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257385',4901740,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257385',4901741,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257385',4901742,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257385',4901743,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257385',4901744,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257386',4901745,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257386',4901746,'1633','219',275892.18,281142.70,5250.52,866335.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','257386',4901747,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257386',4901748,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257386',4901749,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257386',4901750,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257386',4901751,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257386',4901752,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257387',4901753,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257387',4901754,'1633','219',281142.70,286337.71,5195.01,857176.65,0.00,0.00,0.00,0.00,0.00),('5','95','578','257387',4901755,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257387',4901756,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257387',4901757,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257387',4901758,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257387',4901759,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257387',4901760,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257388',4901761,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257388',4901762,'1633','219',286337.71,292067.33,5729.62,945387.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','257388',4901763,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257388',4901764,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257388',4901765,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257388',4901766,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257388',4901767,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257388',4901768,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257389',4901769,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257389',4901770,'1633','219',292067.33,296069.85,4002.52,660415.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','257389',4901771,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257389',4901772,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257389',4901773,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257389',4901774,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257389',4901775,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257389',4901776,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257390',4901777,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257390',4901778,'1633','219',296069.85,298283.99,2214.14,365333.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','257390',4901779,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257390',4901780,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257390',4901781,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257390',4901782,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257390',4901783,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257390',4901784,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257391',4901785,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257391',4901786,'1633','219',298283.99,299155.99,872.00,143880.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257391',4901787,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257391',4901788,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257391',4901789,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257391',4901790,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257391',4901791,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257391',4901792,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257392',4901793,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257392',4901794,'1633','219',299155.99,299155.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257392',4901795,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257392',4901796,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257392',4901797,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257392',4901798,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257392',4901799,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257392',4901800,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257393',4901801,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257393',4901802,'1633','219',299155.99,299155.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257393',4901803,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257393',4901804,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257393',4901805,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257393',4901806,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257393',4901807,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257393',4901808,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257394',4901809,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257394',4901810,'1633','219',299155.99,299155.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257394',4901811,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257394',4901812,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257394',4901813,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257394',4901814,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257394',4901815,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257394',4901816,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257395',4901817,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257395',4901818,'1633','219',299155.99,299155.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257395',4901819,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257395',4901820,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257395',4901821,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257395',4901822,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257395',4901823,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257395',4901824,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257396',4901825,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257396',4901826,'1633','219',299155.99,299155.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257396',4901827,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257396',4901828,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257396',4901829,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257396',4901830,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257396',4901831,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257396',4901832,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257397',4901833,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257397',4901834,'1633','219',299155.99,299155.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257397',4901835,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257397',4901836,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257397',4901837,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257397',4901838,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257397',4901839,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257397',4901840,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257398',4901841,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257398',4901842,'1633','219',299155.99,300283.25,1127.26,185997.65,0.00,0.00,0.00,0.00,0.00),('5','95','578','257398',4901843,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257398',4901844,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257398',4901845,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257398',4901846,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257398',4901847,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257398',4901848,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257399',4901849,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257399',4901850,'1633','219',300283.25,305708.65,5425.40,895191.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257399',4901851,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257399',4901852,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257399',4901853,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257399',4901854,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257399',4901855,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257399',4901856,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257400',4901857,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257400',4901858,'1633','219',305708.65,312859.65,7151.00,1179915.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257400',4901859,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257400',4901860,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257400',4901861,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257400',4901862,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257400',4901863,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257400',4901864,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257401',4901865,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257401',4901866,'1633','219',312859.65,313872.73,1013.08,167158.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','257401',4901867,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257401',4901868,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257401',4901869,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257401',4901870,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257401',4901871,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257401',4901872,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257402',4901873,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257402',4901874,'1633','219',313872.73,313872.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257402',4901875,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257402',4901876,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257402',4901877,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257402',4901878,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257402',4901879,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257402',4901880,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257403',4901881,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257403',4901882,'1633','219',313872.73,315193.78,1321.05,217973.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','257403',4901883,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257403',4901884,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257403',4901885,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257403',4901886,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257403',4901887,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257403',4901888,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257404',4901889,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257404',4901890,'1633','219',315193.78,322315.97,7122.19,1175161.35,0.00,0.00,0.00,0.00,0.00),('5','95','578','257404',4901891,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257404',4901892,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257404',4901893,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257404',4901894,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257404',4901895,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257404',4901896,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257405',4901897,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257405',4901898,'1633','219',322315.97,327040.97,4725.00,779625.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257405',4901899,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257405',4901900,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257405',4901901,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257405',4901902,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257405',4901903,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257405',4901904,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257406',4901905,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257406',4901906,'1633','219',327040.97,327662.00,621.03,102469.83,0.00,0.00,0.00,0.00,0.00),('5','95','578','257406',4901907,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257406',4901908,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257406',4901909,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257406',4901910,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257406',4901911,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257406',4901912,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257407',4901913,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257407',4901914,'1633','219',327662.00,329190.03,1528.03,252124.95,0.00,0.00,0.00,0.00,0.00),('5','95','578','257407',4901915,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257407',4901916,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257407',4901917,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257407',4901918,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257407',4901919,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257407',4901920,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257408',4901921,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257408',4901922,'1633','219',329190.03,339714.30,10524.27,1736504.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','257408',4901923,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257408',4901924,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257408',4901925,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257408',4901926,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257408',4901927,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257408',4901928,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257409',4901929,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257409',4901930,'1633','219',339714.30,350956.15,11241.85,1854905.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','257409',4901931,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257409',4901932,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257409',4901933,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257409',4901934,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257409',4901935,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257409',4901936,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257410',4901937,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257410',4901938,'1633','219',350956.15,355688.29,4732.14,780803.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','257410',4901939,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257410',4901940,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257410',4901941,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257410',4901942,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257410',4901943,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257410',4901944,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257411',4901945,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257411',4901946,'1633','219',355688.29,355688.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257411',4901947,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257411',4901948,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257411',4901949,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257411',4901950,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257411',4901951,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257411',4901952,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257412',4901953,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257412',4901954,'1633','219',355688.29,355688.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257412',4901955,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257412',4901956,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257412',4901957,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257412',4901958,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257412',4901959,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257412',4901960,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257413',4901961,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257413',4901962,'1633','219',355688.29,358414.11,2725.82,449760.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','257413',4901963,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257413',4901964,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257413',4901965,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257413',4901966,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257413',4901967,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257413',4901968,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257414',4901969,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257414',4901970,'1633','219',358414.11,363765.13,5351.02,882918.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','257414',4901971,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257414',4901972,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257414',4901973,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257414',4901974,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257414',4901975,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257414',4901976,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257415',4901977,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257415',4901978,'1633','219',363765.13,367900.54,4135.41,682342.65,0.00,0.00,0.00,0.00,0.00),('5','95','578','257415',4901979,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257415',4901980,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257415',4901981,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257415',4901982,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257415',4901983,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257415',4901984,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257416',4901985,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257416',4901986,'1633','219',367900.54,370047.82,2147.28,354301.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','257416',4901987,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257416',4901988,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257416',4901989,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257416',4901990,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257416',4901991,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257416',4901992,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257417',4901993,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257417',4901994,'1633','219',370047.82,370882.96,835.14,137798.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','257417',4901995,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257417',4901996,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257417',4901997,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257417',4901998,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257417',4901999,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257417',4902000,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257418',4902001,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257418',4902002,'1633','219',370882.96,373534.78,2651.82,437550.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','257418',4902003,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257418',4902004,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257418',4902005,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257418',4902006,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257418',4902007,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257418',4902008,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257419',4902009,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257419',4902010,'1633','219',373534.78,382076.01,8541.23,1409302.95,0.00,0.00,0.00,0.00,0.00),('5','95','578','257419',4902011,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257419',4902012,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257419',4902013,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257419',4902014,'1637','219',3903057.60,3903057.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257419',4902015,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257419',4902016,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257420',4902017,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257420',4902018,'1633','219',382076.01,382076.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257420',4902019,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257420',4902020,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257420',4902021,'1636','219',3321089.50,3321089.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257420',4902022,'1637','219',3903057.60,3910275.80,7218.20,1191003.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257420',4902023,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257420',4902024,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257421',4902025,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257421',4902026,'1633','219',382076.01,382076.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257421',4902027,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257421',4902028,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257421',4902029,'1636','219',3321089.50,3325821.32,4731.82,780750.30,0.00,0.00,0.00,0.00,0.00),('5','95','580','257421',4902030,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257421',4902031,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257421',4902032,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257422',4902033,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257422',4902034,'1633','219',382076.01,382076.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257422',4902035,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257422',4902036,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257422',4902037,'1636','219',3325821.32,3329941.50,4120.18,679829.70,0.00,0.00,0.00,0.00,0.00),('5','95','580','257422',4902038,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257422',4902039,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257422',4902040,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257423',4902041,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257423',4902042,'1633','219',382076.01,382076.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257423',4902043,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257423',4902044,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257423',4902045,'1636','219',3329941.50,3335353.75,5412.25,893021.25,0.00,0.00,0.00,0.00,0.00),('5','95','580','257423',4902046,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257423',4902047,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257423',4902048,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257424',4902049,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257424',4902050,'1633','219',382076.01,382076.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257424',4902051,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257424',4902052,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257424',4902053,'1636','219',3335353.75,3339675.03,4321.28,713011.20,0.00,0.00,0.00,0.00,0.00),('5','95','580','257424',4902054,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257424',4902055,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257424',4902056,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257425',4902057,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257425',4902058,'1633','219',382076.01,382076.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257425',4902059,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257425',4902060,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257425',4902061,'1636','219',3339675.03,3343857.64,4182.61,690130.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','257425',4902062,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257425',4902063,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257425',4902064,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257426',4902065,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257426',4902066,'1633','219',382076.01,384427.55,2351.54,388004.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','257426',4902067,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257426',4902068,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257426',4902069,'1636','219',3343857.64,3343857.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257426',4902070,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257426',4902071,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257426',4902072,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257427',4902073,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257427',4902074,'1633','219',384427.55,385696.37,1268.82,209355.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','257427',4902075,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257427',4902076,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257427',4902077,'1636','219',3343857.64,3343857.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257427',4902078,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257427',4902079,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257427',4902080,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257428',4902081,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257428',4902082,'1633','219',385696.37,385696.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257428',4902083,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257428',4902084,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257428',4902085,'1636','219',3343857.64,3343857.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257428',4902086,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257428',4902087,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257428',4902088,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257429',4902089,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257429',4902090,'1633','219',385696.37,385696.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257429',4902091,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257429',4902092,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257429',4902093,'1636','219',3343857.64,3343857.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257429',4902094,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257429',4902095,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257429',4902096,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257430',4902097,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257430',4902098,'1633','219',385696.37,385696.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257430',4902099,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257430',4902100,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257430',4902101,'1636','219',3343857.64,3343857.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257430',4902102,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257430',4902103,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257430',4902104,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257431',4902105,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257431',4902106,'1633','219',385696.37,385696.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257431',4902107,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257431',4902108,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257431',4902109,'1636','219',3343857.64,3345483.48,1625.84,268263.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','257431',4902110,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257431',4902111,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257431',4902112,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257432',4902113,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257432',4902114,'1633','219',385696.37,385696.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257432',4902115,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257432',4902116,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257432',4902117,'1636','219',3345483.48,3350622.00,5138.52,847855.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','257432',4902118,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257432',4902119,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257432',4902120,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257433',4902121,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257433',4902122,'1633','219',385696.37,385696.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257433',4902123,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257433',4902124,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257433',4902125,'1636','219',3350622.00,3357242.02,6620.02,1092303.30,0.00,0.00,0.00,0.00,0.00),('5','95','580','257433',4902126,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257433',4902127,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257433',4902128,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257434',4902129,'1632','219',1774.66,1783.67,9.01,1468.63,0.00,0.00,0.00,0.00,0.00),('5','95','578','257434',4902130,'1633','219',385696.37,385696.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257434',4902131,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257434',4902132,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257434',4902133,'1636','219',3357242.02,3357242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257434',4902134,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257434',4902135,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257434',4902136,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257435',4902137,'1632','219',1783.67,1795.66,11.99,1954.37,0.00,0.00,0.00,0.00,0.00),('5','95','578','257435',4902138,'1633','219',385696.37,385696.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257435',4902139,'1634','219',866376.26,866376.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257435',4902140,'1635','219',1071954.01,1071954.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257435',4902141,'1636','219',3357242.02,3357242.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257435',4902142,'1637','219',3910275.80,3910275.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257435',4902143,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257435',4902144,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257436',4902145,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257436',4902146,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257436',4902147,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257436',4902148,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257436',4902149,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257436',4902150,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257436',4902151,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257436',4902152,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257437',4902153,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257437',4902154,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257437',4902155,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257437',4902156,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257437',4902157,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257437',4902158,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257437',4902159,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257437',4902160,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257438',4902161,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257438',4902162,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257438',4902163,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257438',4902164,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257438',4902165,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257438',4902166,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257438',4902167,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257438',4902168,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257439',4902169,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257439',4902170,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257439',4902171,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257439',4902172,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257439',4902173,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257439',4902174,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257439',4902175,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257439',4902176,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257440',4902177,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257440',4902178,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257440',4902179,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257440',4902180,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257440',4902181,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257440',4902182,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257440',4902183,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257440',4902184,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257441',4902185,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257441',4902186,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257441',4902187,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257441',4902188,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257441',4902189,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257441',4902190,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257441',4902191,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257441',4902192,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257442',4902193,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257442',4902194,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257442',4902195,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257442',4902196,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257442',4902197,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257442',4902198,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257442',4902199,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257442',4902200,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257443',4902201,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257443',4902202,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257443',4902203,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257443',4902204,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257443',4902205,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257443',4902206,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257443',4902207,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257443',4902208,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257444',4902209,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257444',4902210,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257444',4902211,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257444',4902212,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257444',4902213,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257444',4902214,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257444',4902215,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257444',4902216,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257445',4902217,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257445',4902218,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257445',4902219,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257445',4902220,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257445',4902221,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257445',4902222,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257445',4902223,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257445',4902224,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257446',4902225,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257446',4902226,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257446',4902227,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257446',4902228,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257446',4902229,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257446',4902230,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257446',4902231,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257446',4902232,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257447',4902233,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257447',4902234,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257447',4902235,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257447',4902236,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257447',4902237,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257447',4902238,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257447',4902239,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257447',4902240,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257448',4902241,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257448',4902242,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257448',4902243,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257448',4902244,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257448',4902245,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257448',4902246,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257448',4902247,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257448',4902248,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257449',4902249,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257449',4902250,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257449',4902251,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257449',4902252,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257449',4902253,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257449',4902254,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257449',4902255,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257449',4902256,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257450',4902257,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257450',4902258,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257450',4902259,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257450',4902260,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257450',4902261,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257450',4902262,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257450',4902263,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257450',4902264,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257451',4902265,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257451',4902266,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257451',4902267,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257451',4902268,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257451',4902269,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257451',4902270,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257451',4902271,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257451',4902272,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257452',4902273,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257452',4902274,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257452',4902275,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257452',4902276,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257452',4902277,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257452',4902278,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257452',4902279,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257452',4902280,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257453',4902281,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257453',4902282,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257453',4902283,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257453',4902284,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257453',4902285,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257453',4902286,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257453',4902287,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257453',4902288,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257454',4902289,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257454',4902290,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257454',4902291,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257454',4902292,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257454',4902293,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257454',4902294,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257454',4902295,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257454',4902296,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257455',4902297,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257455',4902298,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257455',4902299,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257455',4902300,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257455',4902301,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257455',4902302,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257455',4902303,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257455',4902304,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257456',4902305,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257456',4902306,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257456',4902307,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257456',4902308,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257456',4902309,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257456',4902310,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257456',4902311,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257456',4902312,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257457',4902313,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257457',4902314,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257457',4902315,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257457',4902316,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257457',4902317,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257457',4902318,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257457',4902319,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257457',4902320,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257458',4902321,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257458',4902322,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257458',4902323,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257458',4902324,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257458',4902325,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257458',4902326,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257458',4902327,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257458',4902328,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257459',4902329,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257459',4902330,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257459',4902331,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257459',4902332,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257459',4902333,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257459',4902334,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257459',4902335,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257459',4902336,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257460',4902337,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257460',4902338,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257460',4902339,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257460',4902340,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257460',4902341,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257460',4902342,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257460',4902343,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257460',4902344,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257461',4902345,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257461',4902346,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257461',4902347,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257461',4902348,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257461',4902349,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257461',4902350,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257461',4902351,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257461',4902352,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257462',4902353,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257462',4902354,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257462',4902355,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257462',4902356,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257462',4902357,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257462',4902358,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257462',4902359,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257462',4902360,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257463',4902361,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257463',4902362,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257463',4902363,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257463',4902364,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257463',4902365,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257463',4902366,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257463',4902367,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257463',4902368,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257464',4902369,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257464',4902370,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257464',4902371,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257464',4902372,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257464',4902373,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257464',4902374,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257464',4902375,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257464',4902376,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257465',4902377,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257465',4902378,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257465',4902379,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257465',4902380,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257465',4902381,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257465',4902382,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257465',4902383,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257465',4902384,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257466',4902385,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257466',4902386,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257466',4902387,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257466',4902388,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257466',4902389,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257466',4902390,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257466',4902391,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257466',4902392,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257467',4902393,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257467',4902394,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257467',4902395,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257467',4902396,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257467',4902397,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257467',4902398,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257467',4902399,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257467',4902400,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257468',4902401,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257468',4902402,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257468',4902403,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257468',4902404,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257468',4902405,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257468',4902406,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257468',4902407,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257468',4902408,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257469',4902409,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257469',4902410,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257469',4902411,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257469',4902412,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257469',4902413,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257469',4902414,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257469',4902415,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257469',4902416,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257470',4902417,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257470',4902418,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257470',4902419,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257470',4902420,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257470',4902421,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257470',4902422,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257470',4902423,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257470',4902424,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257471',4902425,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257471',4902426,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257471',4902427,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257471',4902428,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257471',4902429,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257471',4902430,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257471',4902431,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257471',4902432,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257472',4902433,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257472',4902434,'1633','219',429756.57,429756.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257472',4902435,'1634','219',866476.49,866476.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257472',4902436,'1635','219',1089268.76,1089268.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257472',4902437,'1636','219',3431619.23,3431619.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257472',4902438,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257472',4902439,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257472',4902440,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257473',4902441,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257473',4902442,'1633','219',430617.74,436302.09,5684.35,937917.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','257473',4902443,'1634','219',866476.49,866490.20,13.71,2262.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','257473',4902444,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257473',4902445,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257473',4902446,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257473',4902447,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257473',4902448,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257474',4902449,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257474',4902450,'1633','219',436302.09,440027.59,3725.50,614707.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','257474',4902451,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257474',4902452,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257474',4902453,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257474',4902454,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257474',4902455,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257474',4902456,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257475',4902457,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257475',4902458,'1633','219',440027.59,440235.75,208.16,38509.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','257475',4902459,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257475',4902460,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257475',4902461,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257475',4902462,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257475',4902463,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257475',4902464,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257476',4902465,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257476',4902466,'1633','219',440235.75,442897.43,2661.68,492410.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','257476',4902467,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257476',4902468,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257476',4902469,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257476',4902470,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257476',4902471,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257476',4902472,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257477',4902473,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257477',4902474,'1633','219',442897.43,445413.26,2515.83,465428.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','257477',4902475,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257477',4902476,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257477',4902477,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257477',4902478,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257477',4902479,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257477',4902480,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257478',4902481,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257478',4902482,'1633','219',445413.26,448355.00,2941.74,544221.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','257478',4902483,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257478',4902484,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257478',4902485,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257478',4902486,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257478',4902487,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257478',4902488,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257479',4902489,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257479',4902490,'1633','219',448355.00,451004.94,2649.94,490238.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','257479',4902491,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257479',4902492,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257479',4902493,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257479',4902494,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257479',4902495,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257479',4902496,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257480',4902497,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257480',4902498,'1633','219',451004.94,453054.82,2049.88,379227.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','257480',4902499,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257480',4902500,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257480',4902501,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257480',4902502,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257480',4902503,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257480',4902504,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257481',4902505,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257481',4902506,'1633','219',453054.82,455274.49,2219.67,410638.95,0.00,0.00,0.00,0.00,0.00),('5','95','578','257481',4902507,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257481',4902508,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257481',4902509,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257481',4902510,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257481',4902511,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257481',4902512,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257482',4902513,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257482',4902514,'1633','219',455274.49,457987.07,2712.58,501827.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','257482',4902515,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257482',4902516,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257482',4902517,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257482',4902518,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257482',4902519,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257482',4902520,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257483',4902521,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257483',4902522,'1633','219',457987.07,460295.39,2308.32,427039.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','257483',4902523,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257483',4902524,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257483',4902525,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257483',4902526,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257483',4902527,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257483',4902528,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257484',4902529,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257484',4902530,'1633','219',460295.39,463541.51,3246.12,600532.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','257484',4902531,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257484',4902532,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257484',4902533,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257484',4902534,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257484',4902535,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257484',4902536,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257485',4902537,'1632','219',1774.66,1774.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257485',4902538,'1633','219',463541.51,465906.97,2365.46,437610.10,0.00,0.00,0.00,0.00,0.00),('5','95','578','257485',4902539,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257485',4902540,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257485',4902541,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257485',4902542,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257485',4902543,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257485',4902544,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257486',4902545,'1632','219',1774.66,3627.03,1852.37,342688.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','257486',4902546,'1633','219',465906.97,466941.84,1034.87,191450.95,0.00,0.00,0.00,0.00,0.00),('5','95','578','257486',4902547,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257486',4902548,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257486',4902549,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257486',4902550,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257486',4902551,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257486',4902552,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257487',4902553,'1632','219',3627.03,7969.42,4342.39,803342.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','257487',4902554,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257487',4902555,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257487',4902556,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257487',4902557,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257487',4902558,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257487',4902559,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257487',4902560,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257488',4902561,'1632','219',7969.42,10505.82,2536.40,469234.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257488',4902562,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257488',4902563,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257488',4902564,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257488',4902565,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257488',4902566,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257488',4902567,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257488',4902568,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257489',4902569,'1632','219',10505.82,14808.56,4302.74,796006.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','257489',4902570,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257489',4902571,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257489',4902572,'1635','219',1093074.37,1093074.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257489',4902573,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257489',4902574,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257489',4902575,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257489',4902576,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257490',4902577,'1632','219',14808.56,17557.38,2748.82,508531.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','257490',4902578,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257490',4902579,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257490',4902580,'1635','219',1093074.37,1095038.76,1964.39,363412.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','257490',4902581,'1636','219',3432787.68,3432787.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257490',4902582,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257490',4902583,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257490',4902584,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257491',4902585,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257491',4902586,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257491',4902587,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257491',4902588,'1635','219',1095038.76,1097720.92,2682.16,496199.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','257491',4902589,'1636','219',3432787.68,3435797.58,3009.90,556831.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','257491',4902590,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257491',4902591,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257491',4902592,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257492',4902593,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257492',4902594,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257492',4902595,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257492',4902596,'1635','219',1097720.92,1099996.38,2275.46,420960.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','257492',4902597,'1636','219',3435797.58,3438637.61,2840.03,525405.55,0.00,0.00,0.00,0.00,0.00),('5','95','580','257492',4902598,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257492',4902599,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257492',4902600,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257493',4902601,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257493',4902602,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257493',4902603,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257493',4902604,'1635','219',1099996.38,1100562.73,566.35,104774.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','257493',4902605,'1636','219',3438637.61,3440275.51,1637.90,303011.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','257493',4902606,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257493',4902607,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257493',4902608,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257494',4902609,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257494',4902610,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257494',4902611,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257494',4902612,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257494',4902613,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257494',4902614,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257494',4902615,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257494',4902616,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257495',4902617,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257495',4902618,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257495',4902619,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257495',4902620,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257495',4902621,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257495',4902622,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257495',4902623,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257495',4902624,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257496',4902625,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257496',4902626,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257496',4902627,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257496',4902628,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257496',4902629,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257496',4902630,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257496',4902631,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257496',4902632,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257497',4902633,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257497',4902634,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257497',4902635,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257497',4902636,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257497',4902637,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257497',4902638,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257497',4902639,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257497',4902640,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257498',4902641,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257498',4902642,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257498',4902643,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257498',4902644,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257498',4902645,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257498',4902646,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257498',4902647,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257498',4902648,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257499',4902649,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257499',4902650,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257499',4902651,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257499',4902652,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257499',4902653,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257499',4902654,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257499',4902655,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257499',4902656,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257500',4902657,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257500',4902658,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257500',4902659,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257500',4902660,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257500',4902661,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257500',4902662,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257500',4902663,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257500',4902664,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257501',4902665,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257501',4902666,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257501',4902667,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257501',4902668,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257501',4902669,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257501',4902670,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257501',4902671,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257501',4902672,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257502',4902673,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257502',4902674,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257502',4902675,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257502',4902676,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257502',4902677,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257502',4902678,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257502',4902679,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257502',4902680,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257503',4902681,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257503',4902682,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257503',4902683,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257503',4902684,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257503',4902685,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257503',4902686,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257503',4902687,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257503',4902688,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257504',4902689,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257504',4902690,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257504',4902691,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257504',4902692,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257504',4902693,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257504',4902694,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257504',4902695,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257504',4902696,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257505',4902697,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257505',4902698,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257505',4902699,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257505',4902700,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257505',4902701,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257505',4902702,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257505',4902703,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257505',4902704,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257506',4902705,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257506',4902706,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257506',4902707,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257506',4902708,'1635','219',1100562.73,1100562.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257506',4902709,'1636','219',3440275.51,3440275.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257506',4902710,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257506',4902711,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257506',4902712,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257507',4902713,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257507',4902714,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257507',4902715,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257507',4902716,'1635','219',1100562.73,1101793.52,1230.79,227696.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','257507',4902717,'1636','219',3440275.51,3441688.18,1412.67,261343.95,0.00,0.00,0.00,0.00,0.00),('5','95','580','257507',4902718,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257507',4902719,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257507',4902720,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257508',4902721,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257508',4902722,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257508',4902723,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257508',4902724,'1635','219',1101793.52,1103296.26,1502.74,278006.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','257508',4902725,'1636','219',3441688.18,3443434.33,1746.15,323037.75,0.00,0.00,0.00,0.00,0.00),('5','95','580','257508',4902726,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257508',4902727,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257508',4902728,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257509',4902729,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257509',4902730,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257509',4902731,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257509',4902732,'1635','219',1103296.26,1104729.51,1433.25,265151.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','257509',4902733,'1636','219',3443434.33,3445195.53,1761.20,325822.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257509',4902734,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257509',4902735,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257509',4902736,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257510',4902737,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257510',4902738,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257510',4902739,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257510',4902740,'1635','219',1104729.51,1106155.62,1426.11,263830.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','257510',4902741,'1636','219',3445195.53,3447007.72,1812.19,335255.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','257510',4902742,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257510',4902743,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257510',4902744,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257511',4902745,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257511',4902746,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257511',4902747,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257511',4902748,'1635','219',1106155.62,1107129.51,973.89,180169.65,0.00,0.00,0.00,0.00,0.00),('5','95','579','257511',4902749,'1636','219',3447007.72,3448681.61,1673.89,309669.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','257511',4902750,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257511',4902751,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257511',4902752,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257512',4902753,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257512',4902754,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257512',4902755,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257512',4902756,'1635','219',1107129.51,1107129.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257512',4902757,'1636','219',3448681.61,3448681.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257512',4902758,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257512',4902759,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257512',4902760,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257513',4902761,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257513',4902762,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257513',4902763,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257513',4902764,'1635','219',1107129.51,1107129.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257513',4902765,'1636','219',3448681.61,3448681.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257513',4902766,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257513',4902767,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257513',4902768,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257514',4902769,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257514',4902770,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257514',4902771,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257514',4902772,'1635','219',1107129.51,1107509.36,379.85,70272.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','257514',4902773,'1636','219',3448681.61,3450929.83,2248.22,415920.70,0.00,0.00,0.00,0.00,0.00),('5','95','580','257514',4902774,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257514',4902775,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257514',4902776,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257515',4902777,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257515',4902778,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257515',4902779,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257515',4902780,'1635','219',1107509.36,1108713.33,1203.97,222734.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','257515',4902781,'1636','219',3450929.83,3452645.54,1715.71,317406.35,0.00,0.00,0.00,0.00,0.00),('5','95','580','257515',4902782,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257515',4902783,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257515',4902784,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257516',4902785,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257516',4902786,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257516',4902787,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257516',4902788,'1635','219',1108713.33,1110179.74,1466.41,271285.85,0.00,0.00,0.00,0.00,0.00),('5','95','579','257516',4902789,'1636','219',3452645.54,3454709.23,2063.69,381782.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','257516',4902790,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257516',4902791,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257516',4902792,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257517',4902793,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257517',4902794,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257517',4902795,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257517',4902796,'1635','219',1110179.74,1111375.95,1196.21,221298.85,0.00,0.00,0.00,0.00,0.00),('5','95','579','257517',4902797,'1636','219',3454709.23,3456613.82,1904.59,352349.15,0.00,0.00,0.00,0.00,0.00),('5','95','580','257517',4902798,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257517',4902799,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257517',4902800,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257518',4902801,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257518',4902802,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257518',4902803,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257518',4902804,'1635','219',1111375.95,1112133.04,757.09,140061.65,0.00,0.00,0.00,0.00,0.00),('5','95','579','257518',4902805,'1636','219',3456613.82,3458632.89,2019.07,373527.95,0.00,0.00,0.00,0.00,0.00),('5','95','580','257518',4902806,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257518',4902807,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257518',4902808,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257519',4902809,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257519',4902810,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257519',4902811,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257519',4902812,'1635','219',1112133.04,1113411.34,1278.30,236485.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','257519',4902813,'1636','219',3458632.89,3460152.86,1519.97,281194.45,0.00,0.00,0.00,0.00,0.00),('5','95','580','257519',4902814,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257519',4902815,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257519',4902816,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257520',4902817,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257520',4902818,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257520',4902819,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257520',4902820,'1635','219',1113411.34,1113411.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257520',4902821,'1636','219',3460152.86,3462792.95,2640.09,488416.65,0.00,0.00,0.00,0.00,0.00),('5','95','580','257520',4902822,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257520',4902823,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257520',4902824,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257521',4902825,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257521',4902826,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257521',4902827,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257521',4902828,'1635','219',1113411.34,1113800.48,389.14,71990.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','257521',4902829,'1636','219',3462792.95,3465493.65,2700.70,499629.50,0.00,0.00,0.00,0.00,0.00),('5','95','580','257521',4902830,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257521',4902831,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257521',4902832,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257522',4902833,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257522',4902834,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257522',4902835,'1634','219',866490.20,866490.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257522',4902836,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257522',4902837,'1636','219',3465493.65,3468588.76,3095.11,572595.35,0.00,0.00,0.00,0.00,0.00),('5','95','580','257522',4902838,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257522',4902839,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257522',4902840,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257523',4902841,'1632','219',17557.38,17557.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257523',4902842,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257523',4902843,'1634','219',866490.20,867591.66,1101.46,203770.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','257523',4902844,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257523',4902845,'1636','219',3468588.76,3469933.30,1344.54,248739.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','257523',4902846,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257523',4902847,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257523',4902848,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257524',4902849,'1632','219',17557.38,18474.72,917.34,169707.90,0.00,0.00,0.00,0.00,0.00),('5','95','578','257524',4902850,'1633','219',466941.84,466941.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257524',4902851,'1634','219',867591.66,868952.60,1360.94,251773.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','257524',4902852,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257524',4902853,'1636','219',3469933.30,3470898.61,965.31,178582.35,0.00,0.00,0.00,0.00,0.00),('5','95','580','257524',4902854,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257524',4902855,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257524',4902856,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257525',4902857,'1632','219',18474.72,19648.52,1173.80,217153.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257525',4902858,'1633','219',466941.84,468060.25,1118.41,206905.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','257525',4902859,'1634','219',868952.60,868952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257525',4902860,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257525',4902861,'1636','219',3470898.61,3471898.95,1000.34,185062.90,0.00,0.00,0.00,0.00,0.00),('5','95','580','257525',4902862,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257525',4902863,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257525',4902864,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257526',4902865,'1632','219',19648.52,20463.92,815.40,150849.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257526',4902866,'1633','219',468060.25,469121.88,1061.63,196401.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','257526',4902867,'1634','219',868952.60,868952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257526',4902868,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257526',4902869,'1636','219',3471898.95,3472908.70,1009.75,186803.75,0.00,0.00,0.00,0.00,0.00),('5','95','580','257526',4902870,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257526',4902871,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257526',4902872,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257527',4902873,'1632','219',20463.92,21398.30,934.38,172860.30,0.00,0.00,0.00,0.00,0.00),('5','95','578','257527',4902874,'1633','219',469121.88,469841.59,719.71,133146.35,0.00,0.00,0.00,0.00,0.00),('5','95','578','257527',4902875,'1634','219',868952.60,868952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257527',4902876,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257527',4902877,'1636','219',3472908.70,3473627.78,719.08,133029.80,0.00,0.00,0.00,0.00,0.00),('5','95','580','257527',4902878,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257527',4902879,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257527',4902880,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257528',4902881,'1632','219',21398.30,22335.49,937.19,173380.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','257528',4902882,'1633','219',469841.59,471190.44,1348.85,249537.25,0.00,0.00,0.00,0.00,0.00),('5','95','578','257528',4902883,'1634','219',868952.60,868952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257528',4902884,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257528',4902885,'1636','219',3473627.78,3474913.02,1285.24,237769.40,0.00,0.00,0.00,0.00,0.00),('5','95','580','257528',4902886,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257528',4902887,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257528',4902888,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257529',4902889,'1632','219',22335.49,23328.02,992.53,183618.05,0.00,0.00,0.00,0.00,0.00),('5','95','578','257529',4902890,'1633','219',471190.44,472651.59,1461.15,270312.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','257529',4902891,'1634','219',868952.60,868952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257529',4902892,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257529',4902893,'1636','219',3474913.02,3476097.87,1184.85,219197.25,0.00,0.00,0.00,0.00,0.00),('5','95','580','257529',4902894,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257529',4902895,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257529',4902896,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257530',4902897,'1632','219',23328.02,24308.54,980.52,181396.20,0.00,0.00,0.00,0.00,0.00),('5','95','578','257530',4902898,'1633','219',472651.59,474007.89,1356.30,250915.50,0.00,0.00,0.00,0.00,0.00),('5','95','578','257530',4902899,'1634','219',868952.60,868952.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257530',4902900,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257530',4902901,'1636','219',3476097.87,3477307.12,1209.25,223711.25,0.00,0.00,0.00,0.00,0.00),('5','95','580','257530',4902902,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257530',4902903,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257530',4902904,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257531',4902905,'1632','219',24308.54,24308.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257531',4902906,'1633','219',474007.89,476024.00,2016.11,372980.35,0.00,0.00,0.00,0.00,0.00),('5','95','578','257531',4902907,'1634','219',868952.60,869017.71,65.11,12045.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','257531',4902908,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257531',4902909,'1636','219',3477307.12,3479050.28,1743.16,322484.60,0.00,0.00,0.00,0.00,0.00),('5','95','580','257531',4902910,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257531',4902911,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257531',4902912,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257532',4902913,'1632','219',24308.54,24308.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257532',4902914,'1633','219',476024.00,477665.60,1641.60,303696.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257532',4902915,'1634','219',869017.71,870414.53,1396.82,258411.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','257532',4902916,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257532',4902917,'1636','219',3479050.28,3480606.69,1556.41,287935.85,0.00,0.00,0.00,0.00,0.00),('5','95','580','257532',4902918,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257532',4902919,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257532',4902920,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257533',4902921,'1632','219',24308.54,25691.54,1383.00,255855.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257533',4902922,'1633','219',477665.60,479415.44,1749.84,323720.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','257533',4902923,'1634','219',870414.53,872194.80,1780.27,329349.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','257533',4902924,'1635','219',1113800.48,1113800.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257533',4902925,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257533',4902926,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257533',4902927,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257533',4902928,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257534',4902929,'1632','219',25691.54,26862.30,1170.76,216590.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','257534',4902930,'1633','219',479415.44,480491.92,1076.48,199148.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','257534',4902931,'1634','219',872194.80,873062.56,867.76,160535.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','257534',4902932,'1635','219',1113800.48,1115471.70,1671.22,309175.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','257534',4902933,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257534',4902934,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257534',4902935,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257534',4902936,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257535',4902937,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257535',4902938,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257535',4902939,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257535',4902940,'1635','219',1115471.70,1118974.23,3502.53,647968.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','257535',4902941,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257535',4902942,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257535',4902943,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257535',4902944,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257536',4902945,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257536',4902946,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257536',4902947,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257536',4902948,'1635','219',1118974.23,1121981.14,3006.91,556278.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','257536',4902949,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257536',4902950,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257536',4902951,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257536',4902952,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257537',4902953,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257537',4902954,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257537',4902955,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257537',4902956,'1635','219',1121981.14,1125342.04,3360.90,621766.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','257537',4902957,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257537',4902958,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257537',4902959,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257537',4902960,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257538',4902961,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257538',4902962,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257538',4902963,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257538',4902964,'1635','219',1125342.04,1128292.89,2950.85,545907.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','257538',4902965,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257538',4902966,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257538',4902967,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257538',4902968,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257539',4902969,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257539',4902970,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257539',4902971,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257539',4902972,'1635','219',1128292.89,1131003.64,2710.75,501488.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','257539',4902973,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257539',4902974,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257539',4902975,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257539',4902976,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257540',4902977,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257540',4902978,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257540',4902979,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257540',4902980,'1635','219',1131003.64,1133245.45,2241.81,414734.85,0.00,0.00,0.00,0.00,0.00),('5','95','579','257540',4902981,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257540',4902982,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257540',4902983,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257540',4902984,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257541',4902985,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257541',4902986,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257541',4902987,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257541',4902988,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257541',4902989,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257541',4902990,'1637','219',3903057.74,3903057.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257541',4902991,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257541',4902992,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257542',4902993,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257542',4902994,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257542',4902995,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257542',4902996,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257542',4902997,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257542',4902998,'1637','219',3903057.74,3903755.17,697.43,129024.55,0.00,0.00,0.00,0.00,0.00),('5','95','581','257542',4902999,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257542',4903000,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257543',4903001,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257543',4903002,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257543',4903003,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257543',4903004,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257543',4903005,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257543',4903006,'1637','219',3903755.17,3903755.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257543',4903007,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257543',4903008,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257544',4903009,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257544',4903010,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257544',4903011,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257544',4903012,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257544',4903013,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257544',4903014,'1637','219',3903755.17,3903755.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257544',4903015,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257544',4903016,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257545',4903017,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257545',4903018,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257545',4903019,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257545',4903020,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257545',4903021,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257545',4903022,'1637','219',3903755.17,3903755.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257545',4903023,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257545',4903024,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257546',4903025,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257546',4903026,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257546',4903027,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257546',4903028,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257546',4903029,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257546',4903030,'1637','219',3903755.17,3903755.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257546',4903031,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257546',4903032,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257547',4903033,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257547',4903034,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257547',4903035,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257547',4903036,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257547',4903037,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257547',4903038,'1637','219',3903755.17,3903755.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257547',4903039,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257547',4903040,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257548',4903041,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257548',4903042,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257548',4903043,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257548',4903044,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257548',4903045,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257548',4903046,'1637','219',3903755.17,3903755.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257548',4903047,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257548',4903048,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257549',4903049,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257549',4903050,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257549',4903051,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257549',4903052,'1635','219',1133245.45,1133245.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257549',4903053,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257549',4903054,'1637','219',3903755.17,3903755.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257549',4903055,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257549',4903056,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257550',4903057,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257550',4903058,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257550',4903059,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257550',4903060,'1635','219',1133245.45,1134701.91,1456.46,269445.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','257550',4903061,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257550',4903062,'1637','219',3903755.17,3904920.69,1165.52,215621.20,0.00,0.00,0.00,0.00,0.00),('5','95','581','257550',4903063,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257550',4903064,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257551',4903065,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257551',4903066,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257551',4903067,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257551',4903068,'1635','219',1134701.91,1136794.34,2092.43,387099.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','257551',4903069,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257551',4903070,'1637','219',3904920.69,3906503.10,1582.41,292745.85,0.00,0.00,0.00,0.00,0.00),('5','95','581','257551',4903071,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257551',4903072,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257552',4903073,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257552',4903074,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257552',4903075,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257552',4903076,'1635','219',1136794.34,1138664.39,1870.05,345959.25,0.00,0.00,0.00,0.00,0.00),('5','95','579','257552',4903077,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257552',4903078,'1637','219',3906503.10,3908768.18,2265.08,419039.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','257552',4903079,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257552',4903080,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257553',4903081,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257553',4903082,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257553',4903083,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257553',4903084,'1635','219',1138664.39,1140480.98,1816.59,336069.15,0.00,0.00,0.00,0.00,0.00),('5','95','579','257553',4903085,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257553',4903086,'1637','219',3908768.18,3910973.45,2205.27,407974.95,0.00,0.00,0.00,0.00,0.00),('5','95','581','257553',4903087,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257553',4903088,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257554',4903089,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257554',4903090,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257554',4903091,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257554',4903092,'1635','219',1140480.98,1142755.20,2274.22,420730.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','257554',4903093,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257554',4903094,'1637','219',3910973.45,3913151.33,2177.88,402907.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','257554',4903095,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257554',4903096,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257555',4903097,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257555',4903098,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257555',4903099,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257555',4903100,'1635','219',1142755.20,1144904.46,2149.26,397613.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','257555',4903101,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257555',4903102,'1637','219',3913151.33,3915642.97,2491.64,460953.40,0.00,0.00,0.00,0.00,0.00),('5','95','581','257555',4903103,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257555',4903104,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257556',4903105,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257556',4903106,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257556',4903107,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257556',4903108,'1635','219',1144904.46,1146729.12,1824.66,337562.10,0.00,0.00,0.00,0.00,0.00),('5','95','579','257556',4903109,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257556',4903110,'1637','219',3915642.97,3917213.23,1570.26,290498.10,0.00,0.00,0.00,0.00,0.00),('5','95','581','257556',4903111,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257556',4903112,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257557',4903113,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257557',4903114,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257557',4903115,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257557',4903116,'1635','219',1146729.12,1148440.99,1711.87,316695.95,0.00,0.00,0.00,0.00,0.00),('5','95','579','257557',4903117,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257557',4903118,'1637','219',3917213.23,3918838.20,1624.97,300619.45,0.00,0.00,0.00,0.00,0.00),('5','95','581','257557',4903119,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257557',4903120,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257558',4903121,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257558',4903122,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257558',4903123,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257558',4903124,'1635','219',1148440.99,1149984.54,1543.55,285556.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','257558',4903125,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257558',4903126,'1637','219',3918838.20,3920657.14,1818.94,336503.90,0.00,0.00,0.00,0.00,0.00),('5','95','581','257558',4903127,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257558',4903128,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257559',4903129,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257559',4903130,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257559',4903131,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257559',4903132,'1635','219',1149984.54,1151885.78,1901.24,351729.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','257559',4903133,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257559',4903134,'1637','219',3920657.14,3923043.82,2386.68,441535.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','257559',4903135,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257559',4903136,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257560',4903137,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257560',4903138,'1633','219',480491.92,480491.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257560',4903139,'1634','219',873062.56,873062.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257560',4903140,'1635','219',1151885.78,1152095.88,210.10,38868.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','257560',4903141,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257560',4903142,'1637','219',3923043.82,3924224.29,1180.47,218386.95,0.00,0.00,0.00,0.00,0.00),('5','95','581','257560',4903143,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257560',4903144,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257561',4903145,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257561',4903146,'1633','219',480491.92,482099.68,1607.76,297435.60,0.00,0.00,0.00,0.00,0.00),('5','95','578','257561',4903147,'1634','219',873062.56,873936.59,874.03,161695.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','257561',4903148,'1635','219',1152095.88,1152095.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257561',4903149,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257561',4903150,'1637','219',3924224.29,3925504.26,1279.97,236794.45,0.00,0.00,0.00,0.00,0.00),('5','95','581','257561',4903151,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257561',4903152,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257562',4903153,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257562',4903154,'1633','219',482099.68,484208.28,2108.60,390091.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257562',4903155,'1634','219',873936.59,875318.75,1382.16,255699.60,0.00,0.00,0.00,0.00,0.00),('5','95','579','257562',4903156,'1635','219',1152095.88,1152095.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257562',4903157,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257562',4903158,'1637','219',3925504.26,3926612.06,1107.80,204943.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257562',4903159,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257562',4903160,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257563',4903161,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257563',4903162,'1633','219',484208.28,486008.12,1799.84,332970.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','257563',4903163,'1634','219',875318.75,877558.46,2239.71,414346.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','257563',4903164,'1635','219',1152095.88,1152095.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257563',4903165,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257563',4903166,'1637','219',3926612.06,3928206.46,1594.40,294964.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257563',4903167,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257563',4903168,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257564',4903169,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257564',4903170,'1633','219',486008.12,488227.29,2219.17,410546.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','257564',4903171,'1634','219',877558.46,879248.99,1690.53,312748.05,0.00,0.00,0.00,0.00,0.00),('5','95','579','257564',4903172,'1635','219',1152095.88,1152095.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257564',4903173,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257564',4903174,'1637','219',3928206.46,3930066.72,1860.26,344148.10,0.00,0.00,0.00,0.00,0.00),('5','95','581','257564',4903175,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257564',4903176,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257565',4903177,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257565',4903178,'1633','219',488227.29,489193.84,966.55,178811.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','257565',4903179,'1634','219',879248.99,879331.71,82.72,15303.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','257565',4903180,'1635','219',1152095.88,1153982.06,1886.18,348943.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','257565',4903181,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257565',4903182,'1637','219',3930066.72,3932670.05,2603.33,481616.05,0.00,0.00,0.00,0.00,0.00),('5','95','581','257565',4903183,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257565',4903184,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257566',4903185,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257566',4903186,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257566',4903187,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257566',4903188,'1635','219',1153982.06,1155655.76,1673.70,309634.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','257566',4903189,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257566',4903190,'1637','219',3932670.05,3935051.93,2381.88,440647.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','257566',4903191,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257566',4903192,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257567',4903193,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257567',4903194,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257567',4903195,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257567',4903196,'1635','219',1155655.76,1160054.53,4398.77,813772.45,0.00,0.00,0.00,0.00,0.00),('5','95','579','257567',4903197,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257567',4903198,'1637','219',3935051.93,3935700.87,648.94,120053.90,0.00,0.00,0.00,0.00,0.00),('5','95','581','257567',4903199,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257567',4903200,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257568',4903201,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257568',4903202,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257568',4903203,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257568',4903204,'1635','219',1160054.53,1162823.17,2768.64,512198.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','257568',4903205,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257568',4903206,'1637','219',3935700.87,3937113.55,1412.68,261345.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','257568',4903207,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257568',4903208,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257569',4903209,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257569',4903210,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257569',4903211,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257569',4903212,'1635','219',1162823.17,1163678.09,854.92,158160.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','257569',4903213,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257569',4903214,'1637','219',3937113.55,3938582.37,1468.82,271731.70,0.00,0.00,0.00,0.00,0.00),('5','95','581','257569',4903215,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257569',4903216,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257570',4903217,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257570',4903218,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257570',4903219,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257570',4903220,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257570',4903221,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257570',4903222,'1637','219',3938582.37,3939921.03,1338.66,247652.10,0.00,0.00,0.00,0.00,0.00),('5','95','581','257570',4903223,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257570',4903224,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257571',4903225,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257571',4903226,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257571',4903227,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257571',4903228,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257571',4903229,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257571',4903230,'1637','219',3939921.03,3941485.80,1564.77,289482.45,0.00,0.00,0.00,0.00,0.00),('5','95','581','257571',4903231,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257571',4903232,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257572',4903233,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257572',4903234,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257572',4903235,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257572',4903236,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257572',4903237,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257572',4903238,'1637','219',3941485.80,3942670.27,1184.47,219126.95,0.00,0.00,0.00,0.00,0.00),('5','95','581','257572',4903239,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257572',4903240,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257573',4903241,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257573',4903242,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257573',4903243,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257573',4903244,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257573',4903245,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257573',4903246,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257573',4903247,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257573',4903248,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257574',4903249,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257574',4903250,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257574',4903251,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257574',4903252,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257574',4903253,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257574',4903254,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257574',4903255,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257574',4903256,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257575',4903257,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257575',4903258,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257575',4903259,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257575',4903260,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257575',4903261,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257575',4903262,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257575',4903263,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257575',4903264,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257576',4903265,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257576',4903266,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257576',4903267,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257576',4903268,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257576',4903269,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257576',4903270,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257576',4903271,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257576',4903272,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257577',4903273,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257577',4903274,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257577',4903275,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257577',4903276,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257577',4903277,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257577',4903278,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257577',4903279,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257577',4903280,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257578',4903281,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257578',4903282,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257578',4903283,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257578',4903284,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257578',4903285,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257578',4903286,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257578',4903287,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257578',4903288,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257579',4903289,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257579',4903290,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257579',4903291,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257579',4903292,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257579',4903293,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257579',4903294,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257579',4903295,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257579',4903296,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257580',4903297,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257580',4903298,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257580',4903299,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257580',4903300,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257580',4903301,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257580',4903302,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257580',4903303,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257580',4903304,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257581',4903305,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257581',4903306,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257581',4903307,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257581',4903308,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257581',4903309,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257581',4903310,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257581',4903311,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257581',4903312,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257582',4903313,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257582',4903314,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257582',4903315,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257582',4903316,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257582',4903317,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257582',4903318,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257582',4903319,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257582',4903320,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257583',4903321,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257583',4903322,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257583',4903323,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257583',4903324,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257583',4903325,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257583',4903326,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257583',4903327,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257583',4903328,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257584',4903329,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257584',4903330,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257584',4903331,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257584',4903332,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257584',4903333,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257584',4903334,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257584',4903335,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257584',4903336,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257585',4903337,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257585',4903338,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257585',4903339,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257585',4903340,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257585',4903341,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257585',4903342,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257585',4903343,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257585',4903344,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257586',4903345,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257586',4903346,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257586',4903347,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257586',4903348,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257586',4903349,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257586',4903350,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257586',4903351,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257586',4903352,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257587',4903353,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257587',4903354,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257587',4903355,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257587',4903356,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257587',4903357,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257587',4903358,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257587',4903359,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257587',4903360,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257588',4903361,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257588',4903362,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257588',4903363,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257588',4903364,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257588',4903365,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257588',4903366,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257588',4903367,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257588',4903368,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257589',4903369,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257589',4903370,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257589',4903371,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257589',4903372,'1635','219',1163678.09,1163678.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257589',4903373,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257589',4903374,'1637','219',3942670.27,3942670.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257589',4903375,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257589',4903376,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257590',4903377,'1632','219',26862.30,26862.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257590',4903378,'1633','219',489193.84,489193.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257590',4903379,'1634','219',879331.71,879331.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257590',4903380,'1635','219',1163678.09,1167559.44,3881.35,718049.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','257590',4903381,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','580','257590',4903382,'1637','219',3942670.27,3945722.90,3052.63,564736.55,0.00,0.00,0.00,0.00,0.00),('5','95','581','257590',4903383,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257590',4903384,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257591',4903385,'1632','219',26862.30,26868.91,6.61,1222.85,0.00,0.00,0.00,0.00,0.00),('5','95','578','257591',4903386,'1633','219',489193.84,489538.07,344.23,63682.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','257591',4903387,'1634','219',879331.71,879784.54,452.83,83773.55,0.00,0.00,0.00,0.00,0.00),('5','95','579','257591',4903388,'1635','219',1167559.44,1170795.52,3236.08,598674.80,0.00,0.00,0.00,0.00,0.00),('5','95','579','257591',4903389,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257591',4903390,'1637','219',3945722.90,3949070.78,3347.88,619357.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','257591',4903391,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257591',4903392,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257592',4903393,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257592',4903394,'1633','219',489538.07,494328.20,4790.13,886174.05,0.00,0.00,0.00,0.00,0.00),('5','95','578','257592',4903395,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257592',4903396,'1635','219',1170795.52,1170871.50,75.98,14056.30,0.00,0.00,0.00,0.00,0.00),('5','95','579','257592',4903397,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257592',4903398,'1637','219',3949070.78,3952622.38,3551.60,657046.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257592',4903399,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257592',4903400,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257593',4903401,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257593',4903402,'1633','219',494328.20,497234.04,2905.84,537580.40,0.00,0.00,0.00,0.00,0.00),('5','95','578','257593',4903403,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257593',4903404,'1635','219',1170871.50,1172946.60,2075.10,383893.50,0.00,0.00,0.00,0.00,0.00),('5','95','579','257593',4903405,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257593',4903406,'1637','219',3952622.38,3957147.14,4524.76,837080.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','257593',4903407,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257593',4903408,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257594',4903409,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257594',4903410,'1633','219',497234.04,501446.39,4212.35,779284.75,0.00,0.00,0.00,0.00,0.00),('5','95','578','257594',4903411,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257594',4903412,'1635','219',1172946.60,1173354.95,408.35,75544.75,0.00,0.00,0.00,0.00,0.00),('5','95','579','257594',4903413,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257594',4903414,'1637','219',3957147.14,3960236.09,3088.95,571455.75,0.00,0.00,0.00,0.00,0.00),('5','95','581','257594',4903415,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257594',4903416,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257595',4903417,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257595',4903418,'1633','219',501446.39,505081.36,3634.97,672469.45,0.00,0.00,0.00,0.00,0.00),('5','95','578','257595',4903419,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257595',4903420,'1635','219',1173354.95,1176807.97,3453.02,638808.70,0.00,0.00,0.00,0.00,0.00),('5','95','579','257595',4903421,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257595',4903422,'1637','219',3960236.09,3961249.47,1013.38,187475.30,0.00,0.00,0.00,0.00,0.00),('5','95','581','257595',4903423,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257595',4903424,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257596',4903425,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257596',4903426,'1633','219',505081.36,508116.43,3035.07,561487.95,0.00,0.00,0.00,0.00,0.00),('5','95','578','257596',4903427,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257596',4903428,'1635','219',1176807.97,1179420.61,2612.64,483338.40,0.00,0.00,0.00,0.00,0.00),('5','95','579','257596',4903429,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257596',4903430,'1637','219',3961249.47,3962509.83,1260.36,233166.60,0.00,0.00,0.00,0.00,0.00),('5','95','581','257596',4903431,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257596',4903432,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257597',4903433,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257597',4903434,'1633','219',508116.43,512705.31,4588.88,848942.80,0.00,0.00,0.00,0.00,0.00),('5','95','578','257597',4903435,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257597',4903436,'1635','219',1179420.61,1181881.12,2460.51,455194.35,0.00,0.00,0.00,0.00,0.00),('5','95','579','257597',4903437,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257597',4903438,'1637','219',3962509.83,3963639.02,1129.19,208900.15,0.00,0.00,0.00,0.00,0.00),('5','95','581','257597',4903439,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257597',4903440,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257598',4903441,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257598',4903442,'1633','219',512705.31,516393.73,3688.42,682357.70,0.00,0.00,0.00,0.00,0.00),('5','95','578','257598',4903443,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257598',4903444,'1635','219',1181881.12,1182521.24,640.12,118422.20,0.00,0.00,0.00,0.00,0.00),('5','95','579','257598',4903445,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257598',4903446,'1637','219',3963639.02,3964154.50,515.48,95363.80,0.00,0.00,0.00,0.00,0.00),('5','95','581','257598',4903447,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257598',4903448,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257599',4903449,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257599',4903450,'1633','219',516393.73,520686.16,4292.43,794099.55,0.00,0.00,0.00,0.00,0.00),('5','95','578','257599',4903451,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257599',4903452,'1635','219',1182521.24,1182521.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257599',4903453,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257599',4903454,'1637','219',3964154.50,3965388.85,1234.35,228354.75,0.00,0.00,0.00,0.00,0.00),('5','95','581','257599',4903455,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257599',4903456,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257600',4903457,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257600',4903458,'1633','219',520686.16,522835.75,2149.59,397674.15,0.00,0.00,0.00,0.00,0.00),('5','95','578','257600',4903459,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257600',4903460,'1635','219',1182521.24,1182521.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257600',4903461,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257600',4903462,'1637','219',3965388.85,3967691.58,2302.73,426005.05,0.00,0.00,0.00,0.00,0.00),('5','95','581','257600',4903463,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257600',4903464,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257601',4903465,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257601',4903466,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257601',4903467,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257601',4903468,'1635','219',1182521.24,1183390.18,868.94,160753.90,0.00,0.00,0.00,0.00,0.00),('5','95','579','257601',4903469,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257601',4903470,'1637','219',3967691.58,3970170.49,2478.91,458598.35,0.00,0.00,0.00,0.00,0.00),('5','95','581','257601',4903471,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257601',4903472,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257602',4903473,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257602',4903474,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257602',4903475,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257602',4903476,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257602',4903477,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257602',4903478,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257602',4903479,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257602',4903480,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257603',4903481,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257603',4903482,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257603',4903483,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257603',4903484,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257603',4903485,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257603',4903486,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257603',4903487,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257603',4903488,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257604',4903489,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257604',4903490,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257604',4903491,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257604',4903492,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257604',4903493,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257604',4903494,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257604',4903495,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257604',4903496,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257605',4903497,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257605',4903498,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257605',4903499,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257605',4903500,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257605',4903501,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257605',4903502,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257605',4903503,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257605',4903504,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257606',4903505,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257606',4903506,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257606',4903507,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257606',4903508,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257606',4903509,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257606',4903510,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257606',4903511,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257606',4903512,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257607',4903513,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257607',4903514,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257607',4903515,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257607',4903516,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257607',4903517,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257607',4903518,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257607',4903519,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257607',4903520,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257608',4903521,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257608',4903522,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257608',4903523,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257608',4903524,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257608',4903525,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257608',4903526,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257608',4903527,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257608',4903528,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257609',4903529,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257609',4903530,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257609',4903531,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257609',4903532,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257609',4903533,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257609',4903534,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257609',4903535,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257609',4903536,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257610',4903537,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257610',4903538,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257610',4903539,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257610',4903540,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257610',4903541,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257610',4903542,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257610',4903543,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257610',4903544,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257611',4903545,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257611',4903546,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257611',4903547,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257611',4903548,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257611',4903549,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257611',4903550,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257611',4903551,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257611',4903552,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257612',4903553,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257612',4903554,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257612',4903555,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257612',4903556,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257612',4903557,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257612',4903558,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257612',4903559,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257612',4903560,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257613',4903561,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257613',4903562,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257613',4903563,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257613',4903564,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257613',4903565,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257613',4903566,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257613',4903567,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257613',4903568,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257614',4903569,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257614',4903570,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257614',4903571,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257614',4903572,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257614',4903573,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257614',4903574,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257614',4903575,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257614',4903576,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257615',4903577,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257615',4903578,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257615',4903579,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257615',4903580,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257615',4903581,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257615',4903582,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257615',4903583,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257615',4903584,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257616',4903585,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257616',4903586,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257616',4903587,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257616',4903588,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257616',4903589,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257616',4903590,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257616',4903591,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257616',4903592,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257617',4903593,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257617',4903594,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257617',4903595,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257617',4903596,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257617',4903597,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257617',4903598,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257617',4903599,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257617',4903600,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257618',4903601,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257618',4903602,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257618',4903603,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257618',4903604,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257618',4903605,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257618',4903606,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257618',4903607,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257618',4903608,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257619',4903609,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257619',4903610,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257619',4903611,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257619',4903612,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257619',4903613,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257619',4903614,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257619',4903615,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257619',4903616,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257620',4903617,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257620',4903618,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257620',4903619,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257620',4903620,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257620',4903621,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257620',4903622,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257620',4903623,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257620',4903624,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257621',4903625,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257621',4903626,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257621',4903627,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257621',4903628,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257621',4903629,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257621',4903630,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257621',4903631,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257621',4903632,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257622',4903633,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257622',4903634,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257622',4903635,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257622',4903636,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257622',4903637,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257622',4903638,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257622',4903639,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257622',4903640,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257623',4903641,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257623',4903642,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257623',4903643,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257623',4903644,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257623',4903645,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257623',4903646,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257623',4903647,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257623',4903648,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257624',4903649,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257624',4903650,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257624',4903651,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257624',4903652,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257624',4903653,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257624',4903654,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257624',4903655,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257624',4903656,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257625',4903657,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257625',4903658,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257625',4903659,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257625',4903660,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257625',4903661,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257625',4903662,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257625',4903663,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257625',4903664,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257626',4903665,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257626',4903666,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257626',4903667,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257626',4903668,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257626',4903669,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257626',4903670,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257626',4903671,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257626',4903672,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257627',4903673,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257627',4903674,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257627',4903675,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257627',4903676,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257627',4903677,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257627',4903678,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257627',4903679,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257627',4903680,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257628',4903681,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257628',4903682,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257628',4903683,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257628',4903684,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257628',4903685,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257628',4903686,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257628',4903687,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257628',4903688,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257629',4903689,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257629',4903690,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257629',4903691,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257629',4903692,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257629',4903693,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257629',4903694,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257629',4903695,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257629',4903696,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257630',4903697,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257630',4903698,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257630',4903699,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257630',4903700,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257630',4903701,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257630',4903702,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257630',4903703,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257630',4903704,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257631',4903705,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257631',4903706,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257631',4903707,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257631',4903708,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257631',4903709,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257631',4903710,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257631',4903711,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257631',4903712,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257632',4903713,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257632',4903714,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257632',4903715,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257632',4903716,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257632',4903717,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257632',4903718,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257632',4903719,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257632',4903720,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257633',4903721,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257633',4903722,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257633',4903723,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257633',4903724,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257633',4903725,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257633',4903726,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257633',4903727,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257633',4903728,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257634',4903729,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257634',4903730,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257634',4903731,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257634',4903732,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257634',4903733,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257634',4903734,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257634',4903735,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257634',4903736,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257635',4903737,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257635',4903738,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257635',4903739,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257635',4903740,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257635',4903741,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257635',4903742,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257635',4903743,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257635',4903744,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257636',4903745,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257636',4903746,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257636',4903747,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257636',4903748,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257636',4903749,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257636',4903750,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257636',4903751,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257636',4903752,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257637',4903753,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257637',4903754,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257637',4903755,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257637',4903756,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257637',4903757,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257637',4903758,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257637',4903759,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257637',4903760,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257638',4903761,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257638',4903762,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257638',4903763,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257638',4903764,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257638',4903765,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257638',4903766,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257638',4903767,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257638',4903768,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257639',4903769,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257639',4903770,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257639',4903771,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257639',4903772,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257639',4903773,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257639',4903774,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257639',4903775,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257639',4903776,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257640',4903777,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257640',4903778,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257640',4903779,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257640',4903780,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257640',4903781,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257640',4903782,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257640',4903783,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257640',4903784,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257641',4903785,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257641',4903786,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257641',4903787,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257641',4903788,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257641',4903789,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257641',4903790,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257641',4903791,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257641',4903792,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257642',4903793,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257642',4903794,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257642',4903795,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257642',4903796,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257642',4903797,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257642',4903798,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257642',4903799,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257642',4903800,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257643',4903801,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257643',4903802,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257643',4903803,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257643',4903804,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257643',4903805,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257643',4903806,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257643',4903807,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257643',4903808,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257644',4903809,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257644',4903810,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257644',4903811,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257644',4903812,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257644',4903813,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257644',4903814,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257644',4903815,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257644',4903816,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257645',4903817,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257645',4903818,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257645',4903819,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257645',4903820,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257645',4903821,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257645',4903822,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257645',4903823,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257645',4903824,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257646',4903825,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257646',4903826,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257646',4903827,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257646',4903828,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257646',4903829,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257646',4903830,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257646',4903831,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257646',4903832,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257647',4903833,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257647',4903834,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257647',4903835,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257647',4903836,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257647',4903837,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257647',4903838,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257647',4903839,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257647',4903840,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257648',4903841,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257648',4903842,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257648',4903843,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257648',4903844,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257648',4903845,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257648',4903846,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257648',4903847,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257648',4903848,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257649',4903849,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257649',4903850,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257649',4903851,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257649',4903852,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257649',4903853,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257649',4903854,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257649',4903855,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257649',4903856,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257650',4903857,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257650',4903858,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257650',4903859,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257650',4903860,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257650',4903861,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257650',4903862,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257650',4903863,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257650',4903864,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257651',4903865,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257651',4903866,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257651',4903867,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257651',4903868,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257651',4903869,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257651',4903870,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257651',4903871,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257651',4903872,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257652',4903873,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257652',4903874,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257652',4903875,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257652',4903876,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257652',4903877,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257652',4903878,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257652',4903879,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257652',4903880,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257653',4903881,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257653',4903882,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257653',4903883,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257653',4903884,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257653',4903885,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257653',4903886,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257653',4903887,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257653',4903888,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257654',4903889,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257654',4903890,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257654',4903891,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257654',4903892,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257654',4903893,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257654',4903894,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257654',4903895,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257654',4903896,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257655',4903897,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257655',4903898,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257655',4903899,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257655',4903900,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257655',4903901,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257655',4903902,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257655',4903903,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257655',4903904,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257656',4903905,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257656',4903906,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257656',4903907,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257656',4903908,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257656',4903909,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257656',4903910,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257656',4903911,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257656',4903912,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257657',4903913,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257657',4903914,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257657',4903915,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257657',4903916,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257657',4903917,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257657',4903918,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257657',4903919,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257657',4903920,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257658',4903921,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257658',4903922,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257658',4903923,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257658',4903924,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257658',4903925,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257658',4903926,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257658',4903927,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257658',4903928,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257659',4903929,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257659',4903930,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257659',4903931,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257659',4903932,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257659',4903933,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257659',4903934,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257659',4903935,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257659',4903936,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257660',4903937,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257660',4903938,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257660',4903939,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257660',4903940,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257660',4903941,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257660',4903942,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257660',4903943,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257660',4903944,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257661',4903945,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257661',4903946,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257661',4903947,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257661',4903948,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257661',4903949,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257661',4903950,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257661',4903951,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257661',4903952,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257662',4903953,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257662',4903954,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257662',4903955,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257662',4903956,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257662',4903957,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257662',4903958,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257662',4903959,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257662',4903960,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257663',4903961,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257663',4903962,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257663',4903963,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257663',4903964,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257663',4903965,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257663',4903966,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257663',4903967,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257663',4903968,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257664',4903969,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257664',4903970,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257664',4903971,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257664',4903972,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257664',4903973,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257664',4903974,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257664',4903975,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257664',4903976,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257665',4903977,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257665',4903978,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257665',4903979,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257665',4903980,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257665',4903981,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257665',4903982,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257665',4903983,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257665',4903984,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257666',4903985,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257666',4903986,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257666',4903987,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257666',4903988,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257666',4903989,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257666',4903990,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257666',4903991,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257666',4903992,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257667',4903993,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257667',4903994,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257667',4903995,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257667',4903996,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257667',4903997,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257667',4903998,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257667',4903999,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257667',4904000,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257668',4904001,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257668',4904002,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257668',4904003,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257668',4904004,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257668',4904005,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257668',4904006,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257668',4904007,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257668',4904008,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257669',4904009,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257669',4904010,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257669',4904011,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257669',4904012,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257669',4904013,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257669',4904014,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257669',4904015,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257669',4904016,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257670',4904017,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257670',4904018,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257670',4904019,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257670',4904020,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257670',4904021,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257670',4904022,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257670',4904023,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257670',4904024,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257671',4904025,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257671',4904026,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257671',4904027,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257671',4904028,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257671',4904029,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257671',4904030,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257671',4904031,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257671',4904032,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257672',4904033,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257672',4904034,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257672',4904035,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257672',4904036,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257672',4904037,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257672',4904038,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257672',4904039,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257672',4904040,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257673',4904041,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257673',4904042,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257673',4904043,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257673',4904044,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257673',4904045,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257673',4904046,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257673',4904047,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257673',4904048,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257674',4904049,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257674',4904050,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257674',4904051,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257674',4904052,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257674',4904053,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257674',4904054,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257674',4904055,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257674',4904056,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257675',4904057,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257675',4904058,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257675',4904059,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257675',4904060,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257675',4904061,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257675',4904062,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257675',4904063,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257675',4904064,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257676',4904065,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257676',4904066,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257676',4904067,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257676',4904068,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257676',4904069,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257676',4904070,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257676',4904071,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257676',4904072,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257677',4904073,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257677',4904074,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257677',4904075,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257677',4904076,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257677',4904077,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257677',4904078,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257677',4904079,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257677',4904080,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257678',4904081,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257678',4904082,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257678',4904083,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257678',4904084,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257678',4904085,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257678',4904086,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257678',4904087,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257678',4904088,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257679',4904089,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257679',4904090,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257679',4904091,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257679',4904092,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257679',4904093,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257679',4904094,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257679',4904095,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257679',4904096,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257680',4904097,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257680',4904098,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257680',4904099,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257680',4904100,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257680',4904101,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257680',4904102,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257680',4904103,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257680',4904104,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257681',4904105,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257681',4904106,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257681',4904107,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257681',4904108,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257681',4904109,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257681',4904110,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257681',4904111,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257681',4904112,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257682',4904113,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257682',4904114,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257682',4904115,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257682',4904116,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257682',4904117,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257682',4904118,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257682',4904119,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257682',4904120,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257683',4904121,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257683',4904122,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257683',4904123,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257683',4904124,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257683',4904125,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257683',4904126,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257683',4904127,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257683',4904128,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257684',4904129,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257684',4904130,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257684',4904131,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257684',4904132,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257684',4904133,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257684',4904134,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257684',4904135,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257684',4904136,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257685',4904137,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257685',4904138,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257685',4904139,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257685',4904140,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257685',4904141,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257685',4904142,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257685',4904143,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257685',4904144,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257686',4904145,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257686',4904146,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257686',4904147,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257686',4904148,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257686',4904149,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257686',4904150,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257686',4904151,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257686',4904152,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257687',4904153,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257687',4904154,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257687',4904155,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257687',4904156,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257687',4904157,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257687',4904158,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257687',4904159,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257687',4904160,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257688',4904161,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257688',4904162,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257688',4904163,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257688',4904164,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257688',4904165,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257688',4904166,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257688',4904167,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257688',4904168,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257689',4904169,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257689',4904170,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257689',4904171,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257689',4904172,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257689',4904173,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257689',4904174,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257689',4904175,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257689',4904176,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257690',4904177,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257690',4904178,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257690',4904179,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257690',4904180,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257690',4904181,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257690',4904182,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257690',4904183,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257690',4904184,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257691',4904185,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257691',4904186,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257691',4904187,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257691',4904188,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257691',4904189,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257691',4904190,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257691',4904191,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257691',4904192,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257692',4904193,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257692',4904194,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257692',4904195,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257692',4904196,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257692',4904197,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257692',4904198,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257692',4904199,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257692',4904200,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257693',4904201,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257693',4904202,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257693',4904203,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257693',4904204,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257693',4904205,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257693',4904206,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257693',4904207,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257693',4904208,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257694',4904209,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257694',4904210,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257694',4904211,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257694',4904212,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257694',4904213,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257694',4904214,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257694',4904215,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257694',4904216,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257695',4904217,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257695',4904218,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257695',4904219,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257695',4904220,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257695',4904221,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257695',4904222,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257695',4904223,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257695',4904224,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257696',4904225,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257696',4904226,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257696',4904227,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257696',4904228,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257696',4904229,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257696',4904230,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257696',4904231,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257696',4904232,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257697',4904233,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257697',4904234,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257697',4904235,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257697',4904236,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257697',4904237,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257697',4904238,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257697',4904239,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257697',4904240,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257698',4904241,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257698',4904242,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257698',4904243,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257698',4904244,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257698',4904245,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257698',4904246,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257698',4904247,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257698',4904248,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257699',4904249,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257699',4904250,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257699',4904251,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257699',4904252,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257699',4904253,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257699',4904254,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257699',4904255,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257699',4904256,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257700',4904257,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257700',4904258,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257700',4904259,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257700',4904260,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257700',4904261,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257700',4904262,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257700',4904263,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257700',4904264,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257701',4904265,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257701',4904266,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257701',4904267,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257701',4904268,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257701',4904269,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257701',4904270,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257701',4904271,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257701',4904272,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257702',4904273,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257702',4904274,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257702',4904275,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257702',4904276,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257702',4904277,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257702',4904278,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257702',4904279,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257702',4904280,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257703',4904281,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257703',4904282,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257703',4904283,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257703',4904284,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257703',4904285,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257703',4904286,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257703',4904287,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257703',4904288,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257704',4904289,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257704',4904290,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257704',4904291,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257704',4904292,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257704',4904293,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257704',4904294,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257704',4904295,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257704',4904296,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257705',4904297,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257705',4904298,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257705',4904299,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257705',4904300,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257705',4904301,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257705',4904302,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257705',4904303,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257705',4904304,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257706',4904305,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257706',4904306,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257706',4904307,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257706',4904308,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257706',4904309,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257706',4904310,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257706',4904311,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257706',4904312,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257707',4904313,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257707',4904314,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257707',4904315,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257707',4904316,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257707',4904317,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257707',4904318,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257707',4904319,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257707',4904320,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257708',4904321,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257708',4904322,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257708',4904323,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257708',4904324,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257708',4904325,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257708',4904326,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257708',4904327,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257708',4904328,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257709',4904329,'1632','219',26868.91,26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257709',4904330,'1633','219',522835.75,522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257709',4904331,'1634','219',879784.54,879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257709',4904332,'1635','219',1183390.18,1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257709',4904333,'1636','219',3480606.69,3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257709',4904334,'1637','219',3970170.49,3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257709',4904335,'1638','220',500564.16,500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257709',4904336,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257710',4904337,'1632','219',26868.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257710',4904338,'1633','219',522835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','578','257710',4904339,'1634','219',879784.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257710',4904340,'1635','219',1183390.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257710',4904341,'1636','219',3480606.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','579','257710',4904342,'1637','219',3970170.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','581','257710',4904343,'1638','220',500564.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','95','582','257710',4904344,'1639','221',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730321 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','95','83239','219',140.00,140.00,6136.19,0.00,0.00,0.00,0.00,250783),('5','95','83239','220',240.00,240.00,97.80,0.00,0.00,0.00,0.00,250784),('5','95','83239','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,250785),('5','95','83245','219',140.00,140.00,6878.42,0.00,0.00,0.00,0.00,250801),('5','95','83245','220',240.00,240.00,708.77,0.00,0.00,0.00,0.00,250802),('5','95','83245','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,250803),('5','95','83249','219',140.00,140.00,4924.05,0.00,0.00,0.00,0.00,250813),('5','95','83249','220',240.00,240.00,97.83,0.00,0.00,0.00,0.00,250814),('5','95','83249','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,250815),('5','95','83383','219',140.00,140.00,6516.34,0.00,0.00,0.00,0.00,251216),('5','95','83383','220',240.00,240.00,106.75,0.00,0.00,0.00,0.00,251217),('5','95','83383','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,251218),('5','95','102553','219',140.00,140.00,3793.10,0.00,0.00,0.00,0.00,308804),('5','95','102553','220',225.00,225.00,171.09,0.00,0.00,0.00,0.00,308805),('5','95','102553','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,308806),('5','95','102554','219',140.00,140.00,3879.75,0.00,0.00,0.00,0.00,308807),('5','95','102554','220',225.00,225.00,222.54,0.00,0.00,0.00,0.00,308808),('5','95','102554','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,308809),('5','95','102962','219',140.00,140.00,4523.69,0.00,0.00,0.00,0.00,310031),('5','95','102962','220',225.00,225.00,166.49,0.00,0.00,0.00,0.00,310032),('5','95','102962','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310033),('5','95','102982','219',140.00,140.00,2278.15,0.00,0.00,0.00,0.00,310091),('5','95','102982','220',225.00,225.00,147.75,0.00,0.00,0.00,0.00,310092),('5','95','102982','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310093),('5','95','102987','219',140.00,140.00,3852.84,0.00,0.00,0.00,0.00,310106),('5','95','102987','220',225.00,225.00,168.41,0.00,0.00,0.00,0.00,310107),('5','95','102987','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,310108),('5','95','105333','219',140.00,140.00,2333.26,0.00,0.00,0.00,0.00,317144),('5','95','105333','220',225.00,225.00,127.14,0.00,0.00,0.00,0.00,317145),('5','95','105333','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317146),('5','95','105603','219',140.00,140.00,1081.92,0.00,0.00,0.00,0.00,317954),('5','95','105603','220',225.00,225.00,0.00,0.00,0.00,0.00,0.00,317955),('5','95','105603','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317956),('5','95','105608','219',140.00,140.00,2469.15,0.00,0.00,0.00,0.00,317969),('5','95','105608','220',225.00,225.00,127.58,0.00,0.00,0.00,0.00,317970),('5','95','105608','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317971),('5','95','105609','219',140.00,140.00,688.73,0.00,0.00,0.00,0.00,317972),('5','95','105609','220',225.00,225.00,77.99,0.00,0.00,0.00,0.00,317973),('5','95','105609','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317974),('5','95','105612','219',140.00,140.00,2519.34,0.00,0.00,0.00,0.00,317981),('5','95','105612','220',225.00,225.00,298.42,0.00,0.00,0.00,0.00,317982),('5','95','105612','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317983),('5','95','105615','219',140.00,140.00,1661.80,0.00,0.00,0.00,0.00,317990),('5','95','105615','220',225.00,225.00,105.70,0.00,0.00,0.00,0.00,317991),('5','95','105615','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317992),('5','95','105616','219',140.00,140.00,3214.92,0.00,0.00,0.00,0.00,317993),('5','95','105616','220',225.00,225.00,389.91,0.00,0.00,0.00,0.00,317994),('5','95','105616','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,317995),('5','95','105620','219',140.00,140.00,1082.33,0.00,0.00,0.00,0.00,318005),('5','95','105620','220',225.00,225.00,42.65,0.00,0.00,0.00,0.00,318006),('5','95','105620','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318007),('5','95','105621','219',140.00,140.00,2289.63,0.00,0.00,0.00,0.00,318008),('5','95','105621','220',225.00,225.00,260.61,0.00,0.00,0.00,0.00,318009),('5','95','105621','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318010),('5','95','105623','219',140.00,140.00,533.58,0.00,0.00,0.00,0.00,318014),('5','95','105623','220',225.00,225.00,47.84,0.00,0.00,0.00,0.00,318015),('5','95','105623','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318016),('5','95','105637','219',140.00,140.00,2123.57,0.00,0.00,0.00,0.00,318056),('5','95','105637','220',225.00,225.00,226.32,0.00,0.00,0.00,0.00,318057),('5','95','105637','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318058),('5','95','105639','219',140.00,140.00,1110.97,0.00,0.00,0.00,0.00,318062),('5','95','105639','220',225.00,225.00,11.32,0.00,0.00,0.00,0.00,318063),('5','95','105639','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318064),('5','95','105641','219',140.00,140.00,2327.39,0.00,0.00,0.00,0.00,318068),('5','95','105641','220',225.00,225.00,325.97,0.00,0.00,0.00,0.00,318069),('5','95','105641','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318070),('5','95','105643','219',140.00,140.00,840.10,0.00,0.00,0.00,0.00,318074),('5','95','105643','220',225.00,225.00,119.67,0.00,0.00,0.00,0.00,318075),('5','95','105643','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318076),('5','95','105644','219',140.00,140.00,2196.17,0.00,0.00,0.00,0.00,318077),('5','95','105644','220',225.00,225.00,197.31,0.00,0.00,0.00,0.00,318078),('5','95','105644','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318079),('5','95','105645','219',140.00,140.00,1597.97,0.00,0.00,0.00,0.00,318080),('5','95','105645','220',225.00,225.00,63.75,0.00,0.00,0.00,0.00,318081),('5','95','105645','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318082),('5','95','105646','219',140.00,140.00,2177.86,0.00,0.00,0.00,0.00,318083),('5','95','105646','220',225.00,225.00,160.22,0.00,0.00,0.00,0.00,318084),('5','95','105646','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318085),('5','95','105648','219',140.00,140.00,1182.58,0.00,0.00,0.00,0.00,318089),('5','95','105648','220',225.00,225.00,81.59,0.00,0.00,0.00,0.00,318090),('5','95','105648','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318091),('5','95','105649','219',140.00,140.00,2423.62,0.00,0.00,0.00,0.00,318092),('5','95','105649','220',225.00,225.00,110.19,0.00,0.00,0.00,0.00,318093),('5','95','105649','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318094),('5','95','105650','219',140.00,140.00,977.80,0.00,0.00,0.00,0.00,318095),('5','95','105650','220',225.00,225.00,65.73,0.00,0.00,0.00,0.00,318096),('5','95','105650','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318097),('5','95','105652','219',140.00,140.00,3782.83,0.00,0.00,0.00,0.00,318101),('5','95','105652','220',225.00,225.00,74.74,0.00,0.00,0.00,0.00,318102),('5','95','105652','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318103),('5','95','105654','219',140.00,140.00,1065.57,0.00,0.00,0.00,0.00,318107),('5','95','105654','220',225.00,225.00,112.16,0.00,0.00,0.00,0.00,318108),('5','95','105654','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318109),('5','95','105656','219',140.00,140.00,2244.51,0.00,0.00,0.00,0.00,318113),('5','95','105656','220',225.00,225.00,53.42,0.00,0.00,0.00,0.00,318114),('5','95','105656','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318115),('5','95','105658','219',140.00,140.00,1401.77,0.00,0.00,0.00,0.00,318119),('5','95','105658','220',225.00,225.00,33.75,0.00,0.00,0.00,0.00,318120),('5','95','105658','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318121),('5','95','105660','219',140.00,140.00,3570.72,0.00,0.00,0.00,0.00,318125),('5','95','105660','220',225.00,225.00,46.30,0.00,0.00,0.00,0.00,318126),('5','95','105660','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318127),('5','95','105662','219',140.00,140.00,1186.24,0.00,0.00,0.00,0.00,318131),('5','95','105662','220',225.00,225.00,65.13,0.00,0.00,0.00,0.00,318132),('5','95','105662','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318133),('5','95','105665','219',140.00,140.00,2501.61,0.00,0.00,0.00,0.00,318140),('5','95','105665','220',225.00,225.00,149.22,0.00,0.00,0.00,0.00,318141),('5','95','105665','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318142),('5','95','105666','219',140.00,140.00,1237.83,0.00,0.00,0.00,0.00,318143),('5','95','105666','220',225.00,225.00,22.47,0.00,0.00,0.00,0.00,318144),('5','95','105666','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318145),('5','95','105668','219',140.00,140.00,2173.35,0.00,0.00,0.00,0.00,318149),('5','95','105668','220',225.00,225.00,58.31,0.00,0.00,0.00,0.00,318150),('5','95','105668','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318151),('5','95','105669','219',140.00,140.00,1051.78,0.00,0.00,0.00,0.00,318152),('5','95','105669','220',225.00,225.00,108.26,0.00,0.00,0.00,0.00,318153),('5','95','105669','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318154),('5','95','105676','219',140.00,140.00,2862.51,0.00,0.00,0.00,0.00,318173),('5','95','105676','220',225.00,225.00,278.64,0.00,0.00,0.00,0.00,318174),('5','95','105676','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318175),('5','95','105678','219',140.00,140.00,950.78,0.00,0.00,0.00,0.00,318179),('5','95','105678','220',225.00,225.00,13.24,0.00,0.00,0.00,0.00,318180),('5','95','105678','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318181),('5','95','105684','219',140.00,140.00,3016.98,0.00,0.00,0.00,0.00,318197),('5','95','105684','220',225.00,225.00,22.09,0.00,0.00,0.00,0.00,318198),('5','95','105684','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318199),('5','95','105689','219',140.00,140.00,864.70,0.00,0.00,0.00,0.00,318212),('5','95','105689','220',225.00,225.00,11.54,0.00,0.00,0.00,0.00,318213),('5','95','105689','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318214),('5','95','105692','219',140.00,140.00,2987.78,0.00,0.00,0.00,0.00,318221),('5','95','105692','220',225.00,225.00,51.99,0.00,0.00,0.00,0.00,318222),('5','95','105692','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318223),('5','95','105703','219',140.00,140.00,1187.90,0.00,0.00,0.00,0.00,318254),('5','95','105703','220',225.00,225.00,47.53,0.00,0.00,0.00,0.00,318255),('5','95','105703','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318256),('5','95','105706','219',140.00,140.00,2270.59,0.00,0.00,0.00,0.00,318263),('5','95','105706','220',225.00,225.00,129.23,0.00,0.00,0.00,0.00,318264),('5','95','105706','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318265),('5','95','105709','219',140.00,140.00,889.20,0.00,0.00,0.00,0.00,318272),('5','95','105709','220',225.00,225.00,6.12,0.00,0.00,0.00,0.00,318273),('5','95','105709','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318274),('5','95','105711','219',140.00,140.00,2454.48,0.00,0.00,0.00,0.00,318278),('5','95','105711','220',225.00,225.00,53.60,0.00,0.00,0.00,0.00,318279),('5','95','105711','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318280),('5','95','105712','219',140.00,140.00,1237.15,0.00,0.00,0.00,0.00,318281),('5','95','105712','220',225.00,225.00,124.66,0.00,0.00,0.00,0.00,318282),('5','95','105712','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318283),('5','95','105713','219',140.00,140.00,2671.82,0.00,0.00,0.00,0.00,318284),('5','95','105713','220',225.00,225.00,158.23,0.00,0.00,0.00,0.00,318285),('5','95','105713','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318286),('5','95','105715','219',140.00,140.00,1027.87,0.00,0.00,0.00,0.00,318290),('5','95','105715','220',225.00,225.00,859.86,0.00,0.00,0.00,0.00,318291),('5','95','105715','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,318292),('5','95','105978','219',140.00,140.00,2108.72,0.00,0.00,0.00,0.00,319079),('5','95','105978','220',225.00,225.00,130.12,0.00,0.00,0.00,0.00,319080),('5','95','105978','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,319081),('5','95','106538','219',140.00,140.00,1224.35,0.00,0.00,0.00,0.00,320759),('5','95','106538','220',225.00,225.00,27.98,0.00,0.00,0.00,0.00,320760),('5','95','106538','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320761),('5','95','106540','219',140.00,140.00,2825.85,0.00,0.00,0.00,0.00,320765),('5','95','106540','220',225.00,225.00,67.54,0.00,0.00,0.00,0.00,320766),('5','95','106540','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320767),('5','95','106542','219',140.00,140.00,1188.55,0.00,0.00,0.00,0.00,320771),('5','95','106542','220',225.00,225.00,32.43,0.00,0.00,0.00,0.00,320772),('5','95','106542','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320773),('5','95','106543','219',140.00,140.00,1859.12,0.00,0.00,0.00,0.00,320774),('5','95','106543','220',225.00,225.00,56.09,0.00,0.00,0.00,0.00,320775),('5','95','106543','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320776),('5','95','106545','219',140.00,140.00,1069.45,0.00,0.00,0.00,0.00,320780),('5','95','106545','220',225.00,225.00,42.21,0.00,0.00,0.00,0.00,320781),('5','95','106545','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320782),('5','95','106546','219',140.00,140.00,2431.26,0.00,0.00,0.00,0.00,320783),('5','95','106546','220',225.00,225.00,51.63,0.00,0.00,0.00,0.00,320784),('5','95','106546','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320785),('5','95','106548','219',140.00,140.00,1098.29,0.00,0.00,0.00,0.00,320789),('5','95','106548','220',225.00,225.00,75.98,0.00,0.00,0.00,0.00,320790),('5','95','106548','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320791),('5','95','106549','219',140.00,140.00,2119.34,0.00,0.00,0.00,0.00,320792),('5','95','106549','220',225.00,225.00,65.53,0.00,0.00,0.00,0.00,320793),('5','95','106549','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320794),('5','95','106550','219',140.00,140.00,1067.95,0.00,0.00,0.00,0.00,320795),('5','95','106550','220',225.00,225.00,144.99,0.00,0.00,0.00,0.00,320796),('5','95','106550','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320797),('5','95','106551','219',140.00,140.00,1831.30,0.00,0.00,0.00,0.00,320798),('5','95','106551','220',225.00,225.00,148.16,0.00,0.00,0.00,0.00,320799),('5','95','106551','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320800),('5','95','106552','219',140.00,140.00,879.51,0.00,0.00,0.00,0.00,320801),('5','95','106552','220',225.00,225.00,11.23,0.00,0.00,0.00,0.00,320802),('5','95','106552','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,320803),('5','95','107966','219',140.00,140.00,2026.36,0.00,0.00,0.00,0.00,325070),('5','95','107966','220',225.00,225.00,143.26,0.00,0.00,0.00,0.00,325071),('5','95','107966','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,325072),('5','95','107970','219',140.00,140.00,739.90,0.00,0.00,0.00,0.00,325082),('5','95','107970','220',225.00,225.00,173.82,0.00,0.00,0.00,0.00,325083),('5','95','107970','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,325084),('5','95','107975','219',140.00,140.00,1864.37,0.00,0.00,0.00,0.00,325097),('5','95','107975','220',225.00,225.00,110.75,0.00,0.00,0.00,0.00,325098),('5','95','107975','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,325099),('5','95','108496','219',140.00,140.00,1354.97,0.00,0.00,0.00,0.00,326670),('5','95','108496','220',225.00,225.00,58.51,0.00,0.00,0.00,0.00,326671),('5','95','108496','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326672),('5','95','108499','219',140.00,140.00,2777.75,0.00,0.00,0.00,0.00,326679),('5','95','108499','220',225.00,225.00,79.88,0.00,0.00,0.00,0.00,326680),('5','95','108499','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326681),('5','95','108503','219',140.00,140.00,1238.09,0.00,0.00,0.00,0.00,326691),('5','95','108503','220',225.00,225.00,126.23,0.00,0.00,0.00,0.00,326692),('5','95','108503','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326693),('5','95','108505','219',140.00,140.00,2681.60,0.00,0.00,0.00,0.00,326697),('5','95','108505','220',225.00,225.00,33.55,0.00,0.00,0.00,0.00,326698),('5','95','108505','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326699),('5','95','108509','219',140.00,140.00,964.53,0.00,0.00,0.00,0.00,326709),('5','95','108509','220',225.00,225.00,525.41,0.00,0.00,0.00,0.00,326710),('5','95','108509','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326711),('5','95','108514','219',140.00,140.00,1956.61,0.00,0.00,0.00,0.00,326724),('5','95','108514','220',225.00,225.00,132.76,0.00,0.00,0.00,0.00,326725),('5','95','108514','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326726),('5','95','108516','219',140.00,140.00,891.94,0.00,0.00,0.00,0.00,326730),('5','95','108516','220',225.00,225.00,136.33,0.00,0.00,0.00,0.00,326731),('5','95','108516','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326732),('5','95','108517','219',140.00,140.00,1851.44,0.00,0.00,0.00,0.00,326733),('5','95','108517','220',225.00,225.00,204.55,0.00,0.00,0.00,0.00,326734),('5','95','108517','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326735),('5','95','108518','219',140.00,140.00,1421.35,0.00,0.00,0.00,0.00,326736),('5','95','108518','220',225.00,225.00,40.86,0.00,0.00,0.00,0.00,326737),('5','95','108518','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326738),('5','95','108519','219',140.00,140.00,2326.50,0.00,0.00,0.00,0.00,326739),('5','95','108519','220',225.00,225.00,153.38,0.00,0.00,0.00,0.00,326740),('5','95','108519','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326741),('5','95','108521','219',140.00,140.00,1145.64,0.00,0.00,0.00,0.00,326745),('5','95','108521','220',225.00,225.00,188.43,0.00,0.00,0.00,0.00,326746),('5','95','108521','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326747),('5','95','108522','219',140.00,140.00,2528.35,0.00,0.00,0.00,0.00,326748),('5','95','108522','220',225.00,225.00,151.19,0.00,0.00,0.00,0.00,326749),('5','95','108522','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326750),('5','95','108523','219',140.00,140.00,863.99,0.00,0.00,0.00,0.00,326751),('5','95','108523','220',225.00,225.00,48.43,0.00,0.00,0.00,0.00,326752),('5','95','108523','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326753),('5','95','108525','219',140.00,140.00,4240.94,0.00,0.00,0.00,0.00,326757),('5','95','108525','220',225.00,225.00,150.75,0.00,0.00,0.00,0.00,326758),('5','95','108525','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326759),('5','95','108527','219',140.00,140.00,284.08,0.00,0.00,0.00,0.00,326763),('5','95','108527','220',225.00,225.00,40.88,0.00,0.00,0.00,0.00,326764),('5','95','108527','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326765),('5','95','108534','219',140.00,140.00,2115.40,0.00,0.00,0.00,0.00,326784),('5','95','108534','220',225.00,225.00,459.40,0.00,0.00,0.00,0.00,326785),('5','95','108534','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326786),('5','95','108535','219',140.00,140.00,833.94,0.00,0.00,0.00,0.00,326787),('5','95','108535','220',225.00,225.00,295.86,0.00,0.00,0.00,0.00,326788),('5','95','108535','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326789),('5','95','108539','219',140.00,140.00,2148.23,0.00,0.00,0.00,0.00,326799),('5','95','108539','220',225.00,225.00,189.03,0.00,0.00,0.00,0.00,326800),('5','95','108539','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326801),('5','95','108543','219',140.00,140.00,865.45,0.00,0.00,0.00,0.00,326811),('5','95','108543','220',225.00,225.00,128.24,0.00,0.00,0.00,0.00,326812),('5','95','108543','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326813),('5','95','108545','219',140.00,140.00,2454.36,0.00,0.00,0.00,0.00,326817),('5','95','108545','220',225.00,225.00,54.68,0.00,0.00,0.00,0.00,326818),('5','95','108545','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326819),('5','95','108553','219',140.00,140.00,1123.20,0.00,0.00,0.00,0.00,326841),('5','95','108553','220',225.00,225.00,141.69,0.00,0.00,0.00,0.00,326842),('5','95','108553','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326843),('5','95','108557','219',140.00,140.00,1619.25,0.00,0.00,0.00,0.00,326853),('5','95','108557','220',225.00,225.00,230.07,0.00,0.00,0.00,0.00,326854),('5','95','108557','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326855),('5','95','108559','219',140.00,140.00,1008.29,0.00,0.00,0.00,0.00,326859),('5','95','108559','220',225.00,225.00,401.23,0.00,0.00,0.00,0.00,326860),('5','95','108559','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,326861),('5','95','124218','219',143.00,143.00,2922.98,0.00,0.00,0.00,0.00,373820),('5','95','124218','220',220.00,230.00,130.96,0.00,0.00,0.00,0.00,373821),('5','95','124218','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,373822),('5','95','124221','219',143.00,143.00,1110.14,0.00,0.00,0.00,0.00,373829),('5','95','124221','220',220.00,230.00,0.00,0.00,0.00,0.00,0.00,373830),('5','95','124221','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,373831),('5','95','124223','219',143.00,143.00,2400.07,0.00,0.00,0.00,0.00,373835),('5','95','124223','220',220.00,230.00,139.86,0.00,0.00,0.00,0.00,373836),('5','95','124223','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,373837),('5','95','124226','219',143.00,143.00,1091.17,0.00,0.00,0.00,0.00,373844),('5','95','124226','220',220.00,230.00,513.09,0.00,0.00,0.00,0.00,373845),('5','95','124226','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,373846),('5','95','124249','219',143.00,143.00,1890.29,0.00,0.00,0.00,0.00,373912),('5','95','124249','220',220.00,225.00,508.60,0.00,0.00,0.00,0.00,373913),('5','95','124249','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,373914),('5','95','124250','219',143.00,143.00,1845.74,0.00,0.00,0.00,0.00,373915),('5','95','124250','220',220.00,225.00,598.33,0.00,0.00,0.00,0.00,373916),('5','95','124250','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,373917),('5','95','124251','219',143.00,143.00,2302.50,0.00,0.00,0.00,0.00,373918),('5','95','124251','220',220.00,225.00,33.76,0.00,0.00,0.00,0.00,373919),('5','95','124251','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,373920),('5','95','124252','219',143.00,143.00,1292.56,0.00,0.00,0.00,0.00,373921),('5','95','124252','220',220.00,225.00,18.73,0.00,0.00,0.00,0.00,373922),('5','95','124252','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,373923),('5','95','124324','219',143.00,143.00,2602.45,0.00,0.00,0.00,0.00,374135),('5','95','124324','220',220.00,225.00,652.32,0.00,0.00,0.00,0.00,374136),('5','95','124324','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,374137),('5','95','124326','219',143.00,143.00,1563.93,0.00,0.00,0.00,0.00,374141),('5','95','124326','220',220.00,225.00,0.00,0.00,0.00,0.00,0.00,374142),('5','95','124326','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,374143),('5','95','124330','219',143.00,143.00,2269.42,0.00,0.00,0.00,0.00,374153),('5','95','124330','220',220.00,225.00,117.07,0.00,0.00,0.00,0.00,374154),('5','95','124330','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,374155),('5','95','124335','219',143.00,143.00,1137.69,0.00,0.00,0.00,0.00,374168),('5','95','124335','220',220.00,225.00,316.08,0.00,0.00,0.00,0.00,374169),('5','95','124335','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,374170),('5','95','124393','219',143.00,143.00,2051.79,0.00,0.00,0.00,0.00,374344),('5','95','124393','220',220.00,225.00,0.00,0.00,0.00,0.00,0.00,374345),('5','95','124393','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,374346),('5','95','124610','219',143.00,143.00,892.90,0.00,0.00,0.00,0.00,374995),('5','95','124610','220',220.00,225.00,77.86,0.00,0.00,0.00,0.00,374996),('5','95','124610','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,374997),('5','95','124611','219',143.00,143.00,3853.63,0.00,0.00,0.00,0.00,374998),('5','95','124611','220',220.00,225.00,726.69,0.00,0.00,0.00,0.00,374999),('5','95','124611','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,375000),('5','95','126287','219',143.00,143.00,1462.29,0.00,0.00,0.00,0.00,380024),('5','95','126287','220',220.00,225.00,76.41,0.00,0.00,0.00,0.00,380025),('5','95','126287','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380026),('5','95','126288','219',143.00,143.00,1262.00,0.00,0.00,0.00,0.00,380027),('5','95','126288','220',220.00,225.00,33.75,0.00,0.00,0.00,0.00,380028),('5','95','126288','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380029),('5','95','126293','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,380034),('5','95','126293','220',220.00,225.00,392.49,0.00,0.00,0.00,0.00,380035),('5','95','126293','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380036),('5','95','126294','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,380037),('5','95','126294','220',220.00,225.00,575.16,0.00,0.00,0.00,0.00,380038),('5','95','126294','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380039),('5','95','126295','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,380040),('5','95','126295','220',220.00,225.00,56.28,0.00,0.00,0.00,0.00,380041),('5','95','126295','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380042),('5','95','126297','219',143.00,143.00,1988.66,0.00,0.00,0.00,0.00,380046),('5','95','126297','220',220.00,225.00,41.42,0.00,0.00,0.00,0.00,380047),('5','95','126297','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380048),('5','95','126298','219',143.00,143.00,868.86,0.00,0.00,0.00,0.00,380049),('5','95','126298','220',220.00,225.00,543.95,0.00,0.00,0.00,0.00,380050),('5','95','126298','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380051),('5','95','126299','219',143.00,143.00,2119.80,0.00,0.00,0.00,0.00,380052),('5','95','126299','220',220.00,225.00,292.35,0.00,0.00,0.00,0.00,380053),('5','95','126299','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380054),('5','95','126451','219',143.00,143.00,1760.40,0.00,0.00,0.00,0.00,380509),('5','95','126451','220',220.00,225.00,59.91,0.00,0.00,0.00,0.00,380510),('5','95','126451','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380511),('5','95','126455','219',143.00,143.00,2544.04,0.00,0.00,0.00,0.00,380515),('5','95','126455','220',220.00,225.00,245.47,0.00,0.00,0.00,0.00,380516),('5','95','126455','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380517),('5','95','126456','219',143.00,143.00,1178.27,0.00,0.00,0.00,0.00,380518),('5','95','126456','220',220.00,225.00,111.51,0.00,0.00,0.00,0.00,380519),('5','95','126456','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380520),('5','95','126457','219',143.00,143.00,1920.05,0.00,0.00,0.00,0.00,380521),('5','95','126457','220',220.00,225.00,155.64,0.00,0.00,0.00,0.00,380522),('5','95','126457','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380523),('5','95','126458','219',143.00,143.00,1220.20,0.00,0.00,0.00,0.00,380524),('5','95','126458','220',220.00,225.00,282.07,0.00,0.00,0.00,0.00,380525),('5','95','126458','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380526),('5','95','126459','219',143.00,143.00,2128.27,0.00,0.00,0.00,0.00,380527),('5','95','126459','220',220.00,225.00,55.09,0.00,0.00,0.00,0.00,380528),('5','95','126459','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380529),('5','95','126460','219',143.00,143.00,989.68,0.00,0.00,0.00,0.00,380530),('5','95','126460','220',220.00,225.00,179.08,0.00,0.00,0.00,0.00,380531),('5','95','126460','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380532),('5','95','126595','219',143.00,143.00,1774.46,0.00,0.00,0.00,0.00,380935),('5','95','126595','220',220.00,225.00,121.07,0.00,0.00,0.00,0.00,380936),('5','95','126595','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380937),('5','95','126597','219',143.00,143.00,1217.46,0.00,0.00,0.00,0.00,380941),('5','95','126597','220',220.00,225.00,141.30,0.00,0.00,0.00,0.00,380942),('5','95','126597','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380943),('5','95','126598','219',143.00,143.00,3865.86,0.00,0.00,0.00,0.00,380944),('5','95','126598','220',220.00,225.00,430.27,0.00,0.00,0.00,0.00,380945),('5','95','126598','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380946),('5','95','126599','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,380947),('5','95','126599','220',220.00,225.00,0.00,0.00,0.00,0.00,0.00,380948),('5','95','126599','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380949),('5','95','126600','219',143.00,143.00,1200.92,0.00,0.00,0.00,0.00,380950),('5','95','126600','220',220.00,225.00,0.00,0.00,0.00,0.00,0.00,380951),('5','95','126600','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380952),('5','95','126601','219',143.00,143.00,1879.39,0.00,0.00,0.00,0.00,380953),('5','95','126601','220',220.00,225.00,92.95,0.00,0.00,0.00,0.00,380954),('5','95','126601','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380955),('5','95','126602','219',143.00,143.00,1251.19,0.00,0.00,0.00,0.00,380956),('5','95','126602','220',220.00,225.00,46.20,0.00,0.00,0.00,0.00,380957),('5','95','126602','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380958),('5','95','126603','219',143.00,143.00,3243.93,0.00,0.00,0.00,0.00,380959),('5','95','126603','220',220.00,225.00,57.59,0.00,0.00,0.00,0.00,380960),('5','95','126603','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380961),('5','95','126604','219',143.00,143.00,4685.87,0.00,0.00,0.00,0.00,380962),('5','95','126604','220',220.00,225.00,49.52,0.00,0.00,0.00,0.00,380963),('5','95','126604','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,380964),('5','95','126847','219',143.00,143.00,3794.34,0.00,0.00,0.00,0.00,381691),('5','95','126847','220',225.00,225.00,0.00,0.00,0.00,0.00,0.00,381692),('5','95','126847','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,381693),('5','95','126848','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,381694),('5','95','126848','220',225.00,225.00,319.72,0.00,0.00,0.00,0.00,381695),('5','95','126848','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,381696),('5','95','126849','219',143.00,143.00,1087.33,0.00,0.00,0.00,0.00,381697),('5','95','126849','220',225.00,225.00,121.29,0.00,0.00,0.00,0.00,381698),('5','95','126849','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,381699),('5','95','126977','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,382081),('5','95','126977','220',225.00,225.00,336.41,0.00,0.00,0.00,0.00,382082),('5','95','126977','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382083),('5','95','126978','219',143.00,143.00,2376.68,0.00,0.00,0.00,0.00,382084),('5','95','126978','220',225.00,225.00,116.13,0.00,0.00,0.00,0.00,382085),('5','95','126978','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382086),('5','95','126979','219',143.00,143.00,1006.63,0.00,0.00,0.00,0.00,382087),('5','95','126979','220',225.00,225.00,114.46,0.00,0.00,0.00,0.00,382088),('5','95','126979','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382089),('5','95','126980','219',143.00,143.00,1797.65,0.00,0.00,0.00,0.00,382090),('5','95','126980','220',225.00,225.00,34.41,0.00,0.00,0.00,0.00,382091),('5','95','126980','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382092),('5','95','126981','219',143.00,143.00,882.50,0.00,0.00,0.00,0.00,382093),('5','95','126981','220',225.00,225.00,962.99,0.00,0.00,0.00,0.00,382094),('5','95','126981','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382095),('5','95','126982','219',143.00,143.00,2162.92,0.00,0.00,0.00,0.00,382096),('5','95','126982','220',225.00,225.00,411.13,0.00,0.00,0.00,0.00,382097),('5','95','126982','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382098),('5','95','126983','219',143.00,143.00,944.58,0.00,0.00,0.00,0.00,382099),('5','95','126983','220',225.00,225.00,17.48,0.00,0.00,0.00,0.00,382100),('5','95','126983','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382101),('5','95','127115','219',143.00,143.00,2394.64,0.00,0.00,0.00,0.00,382496),('5','95','127115','220',225.00,215.00,54.28,0.00,0.00,0.00,0.00,382497),('5','95','127115','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382498),('5','95','127144','219',143.00,143.00,992.31,0.00,0.00,0.00,0.00,382581),('5','95','127144','220',225.00,215.00,93.60,0.00,0.00,0.00,0.00,382582),('5','95','127144','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382583),('5','95','127195','219',143.00,143.00,3838.37,0.00,0.00,0.00,0.00,382734),('5','95','127195','220',225.00,215.00,841.35,0.00,0.00,0.00,0.00,382735),('5','95','127195','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382736),('5','95','127236','219',143.00,143.00,1686.80,0.00,0.00,0.00,0.00,382855),('5','95','127236','220',225.00,215.00,30.51,0.00,0.00,0.00,0.00,382856),('5','95','127236','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382857),('5','95','127237','219',143.00,143.00,2324.06,0.00,0.00,0.00,0.00,382858),('5','95','127237','220',225.00,215.00,117.85,0.00,0.00,0.00,0.00,382859),('5','95','127237','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382860),('5','95','127238','219',143.00,143.00,1222.88,0.00,0.00,0.00,0.00,382861),('5','95','127238','220',225.00,215.00,0.00,0.00,0.00,0.00,0.00,382862),('5','95','127238','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382863),('5','95','127239','219',143.00,143.00,2404.69,0.00,0.00,0.00,0.00,382864),('5','95','127239','220',225.00,215.00,120.60,0.00,0.00,0.00,0.00,382865),('5','95','127239','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382866),('5','95','127240','219',143.00,143.00,769.46,0.00,0.00,0.00,0.00,382867),('5','95','127240','220',225.00,215.00,83.70,0.00,0.00,0.00,0.00,382868),('5','95','127240','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382869),('5','95','127241','219',143.00,143.00,2477.15,0.00,0.00,0.00,0.00,382870),('5','95','127241','220',225.00,215.00,167.14,0.00,0.00,0.00,0.00,382871),('5','95','127241','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,382872),('5','95','127351','219',143.00,143.00,1177.64,0.00,0.00,0.00,0.00,383198),('5','95','127351','220',225.00,215.00,0.00,0.00,0.00,0.00,0.00,383199),('5','95','127351','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,383200),('5','95','127457','219',143.00,143.00,1808.88,0.00,0.00,0.00,0.00,383514),('5','95','127457','220',225.00,215.00,117.78,0.00,0.00,0.00,0.00,383515),('5','95','127457','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,383516),('5','95','127469','219',143.00,143.00,1489.43,0.00,0.00,0.00,0.00,383550),('5','95','127469','220',225.00,215.00,22.77,0.00,0.00,0.00,0.00,383551),('5','95','127469','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,383552),('5','95','127546','219',143.00,143.00,2479.92,0.00,0.00,0.00,0.00,383781),('5','95','127546','220',225.00,215.00,0.00,0.00,0.00,0.00,0.00,383782),('5','95','127546','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,383783),('5','95','127596','219',143.00,143.00,954.87,0.00,0.00,0.00,0.00,383931),('5','95','127596','220',225.00,215.00,374.68,0.00,0.00,0.00,0.00,383932),('5','95','127596','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,383933),('5','95','127718','219',143.00,143.00,2651.76,0.00,0.00,0.00,0.00,384295),('5','95','127718','220',225.00,215.00,2461.37,0.00,0.00,0.00,0.00,384296),('5','95','127718','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,384297),('5','95','127721','219',143.00,143.00,1270.40,0.00,0.00,0.00,0.00,384304),('5','95','127721','220',225.00,215.00,918.84,0.00,0.00,0.00,0.00,384305),('5','95','127721','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,384306),('5','95','127945','219',143.00,143.00,1637.95,0.00,0.00,0.00,0.00,384969),('5','95','127945','220',225.00,215.00,178.74,0.00,0.00,0.00,0.00,384970),('5','95','127945','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,384971),('5','95','127946','219',143.00,143.00,2207.76,0.00,0.00,0.00,0.00,384972),('5','95','127946','220',225.00,215.00,0.00,0.00,0.00,0.00,0.00,384973),('5','95','127946','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,384974),('5','95','127947','219',143.00,143.00,4493.44,0.00,0.00,0.00,0.00,384975),('5','95','127947','220',225.00,215.00,330.42,0.00,0.00,0.00,0.00,384976),('5','95','127947','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,384977),('5','95','127948','219',143.00,143.00,1059.32,0.00,0.00,0.00,0.00,384978),('5','95','127948','220',225.00,215.00,62.31,0.00,0.00,0.00,0.00,384979),('5','95','127948','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,384980),('5','95','128044','219',143.00,143.00,2046.24,0.00,0.00,0.00,0.00,385264),('5','95','128044','220',225.00,215.00,736.38,0.00,0.00,0.00,0.00,385265),('5','95','128044','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,385266),('5','95','128228','219',143.00,143.00,923.03,0.00,0.00,0.00,0.00,385814),('5','95','128228','220',225.00,215.00,0.00,0.00,0.00,0.00,0.00,385815),('5','95','128228','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,385816),('5','95','128230','219',143.00,143.00,2439.05,0.00,0.00,0.00,0.00,385820),('5','95','128230','220',225.00,215.00,203.21,0.00,0.00,0.00,0.00,385821),('5','95','128230','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,385822),('5','95','128231','219',143.00,143.00,1163.10,0.00,0.00,0.00,0.00,385823),('5','95','128231','220',225.00,215.00,607.88,0.00,0.00,0.00,0.00,385824),('5','95','128231','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,385825),('5','95','128232','219',143.00,143.00,1569.58,0.00,0.00,0.00,0.00,385826),('5','95','128232','220',225.00,215.00,93.95,0.00,0.00,0.00,0.00,385827),('5','95','128232','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,385828),('5','95','128275','219',143.00,143.00,948.78,0.00,0.00,0.00,0.00,385955),('5','95','128275','220',225.00,215.00,59.63,0.00,0.00,0.00,0.00,385956),('5','95','128275','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,385957),('5','95','128891','219',143.00,143.00,2153.42,0.00,0.00,0.00,0.00,387810),('5','95','128891','220',225.00,215.00,40.93,0.00,0.00,0.00,0.00,387811),('5','95','128891','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,387812),('5','95','128896','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,387825),('5','95','128896','220',225.00,215.00,0.00,0.00,0.00,0.00,0.00,387826),('5','95','128896','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,387827),('5','95','128921','219',143.00,143.00,1163.97,0.00,0.00,0.00,0.00,387906),('5','95','128921','220',225.00,215.00,52.63,0.00,0.00,0.00,0.00,387907),('5','95','128921','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,387908),('5','95','129629','219',143.00,143.00,3399.72,0.00,0.00,0.00,0.00,390036),('5','95','129629','220',225.00,215.00,75.76,0.00,0.00,0.00,0.00,390037),('5','95','129629','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,390038),('5','95','181548','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,532539),('5','95','181548','220',225.00,250.00,0.00,0.00,0.00,0.00,0.00,532540),('5','95','181548','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,532541),('5','95','181637','219',143.00,143.00,0.00,0.00,0.00,0.00,0.00,532779),('5','95','181637','220',225.00,250.00,0.00,0.00,0.00,0.00,0.00,532780),('5','95','181637','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,532781),('5','95','181662','219',143.00,163.00,8849.29,0.00,0.00,0.00,0.00,532847),('5','95','181662','220',225.00,250.00,126.83,0.00,0.00,0.00,0.00,532848),('5','95','181662','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,532849),('5','95','181814','219',143.00,163.00,0.00,0.00,0.00,0.00,0.00,533252),('5','95','181814','220',225.00,250.00,0.00,0.00,0.00,0.00,0.00,533253),('5','95','181814','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,533254),('5','95','181890','219',143.00,163.00,3770.62,0.00,0.00,0.00,0.00,533472),('5','95','181890','220',250.00,250.00,330.00,0.00,0.00,0.00,0.00,533473),('5','95','181890','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,533474),('5','95','182041','219',143.00,163.00,3813.62,0.00,0.00,0.00,0.00,533877),('5','95','182041','220',250.00,250.00,214.34,0.00,0.00,0.00,0.00,533878),('5','95','182041','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,533879),('5','95','182180','219',163.00,163.00,7795.62,0.00,0.00,0.00,0.00,534230),('5','95','182180','220',250.00,250.00,979.59,0.00,0.00,0.00,0.00,534231),('5','95','182180','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,534232),('5','95','182436','219',163.00,163.00,5086.89,0.00,0.00,0.00,0.00,534910),('5','95','182436','220',250.00,250.00,486.64,0.00,0.00,0.00,0.00,534911),('5','95','182436','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,534912),('5','95','182568','219',163.00,163.00,8062.95,0.00,0.00,0.00,0.00,535250),('5','95','182568','220',250.00,250.00,597.67,0.00,0.00,0.00,0.00,535251),('5','95','182568','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,535252),('5','95','182759','219',163.00,163.00,7355.52,0.00,0.00,0.00,0.00,535763),('5','95','182759','220',250.00,250.00,849.30,0.00,0.00,0.00,0.00,535764),('5','95','182759','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,535765),('5','95','182865','219',163.00,163.00,4494.80,0.00,0.00,0.00,0.00,536050),('5','95','182865','220',250.00,265.00,200.73,0.00,0.00,0.00,0.00,536051),('5','95','182865','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,536052),('5','95','183083','219',163.00,163.00,5621.48,0.00,0.00,0.00,0.00,536653),('5','95','183083','220',250.00,265.00,295.31,0.00,0.00,0.00,0.00,536654),('5','95','183083','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,536655),('5','95','183378','219',163.00,163.00,5090.58,0.00,0.00,0.00,0.00,537395),('5','95','183378','220',250.00,265.00,353.92,0.00,0.00,0.00,0.00,537396),('5','95','183378','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,537397),('5','95','183629','219',163.00,163.00,5551.33,0.00,0.00,0.00,0.00,538066),('5','95','183629','220',250.00,265.00,807.07,0.00,0.00,0.00,0.00,538067),('5','95','183629','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,538068),('5','95','183859','219',163.00,163.00,6315.61,0.00,0.00,0.00,0.00,538671),('5','95','183859','220',250.00,265.00,366.73,0.00,0.00,0.00,0.00,538672),('5','95','183859','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,538673),('5','95','184016','219',163.00,163.00,11158.09,0.00,0.00,0.00,0.00,539082),('5','95','184016','220',250.00,255.00,362.24,0.00,0.00,0.00,0.00,539083),('5','95','184016','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,539084),('5','95','184116','219',163.00,163.00,6165.19,0.00,0.00,0.00,0.00,539345),('5','95','184116','220',250.00,255.00,770.01,0.00,0.00,0.00,0.00,539346),('5','95','184116','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,539347),('5','95','184388','219',163.00,163.00,5116.59,0.00,0.00,0.00,0.00,540067),('5','95','184388','220',250.00,255.00,1116.24,0.00,0.00,0.00,0.00,540068),('5','95','184388','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,540069),('5','95','184630','219',163.00,163.00,5124.20,0.00,0.00,0.00,0.00,540715),('5','95','184630','220',250.00,255.00,575.80,0.00,0.00,0.00,0.00,540716),('5','95','184630','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,540717),('5','95','184760','219',163.00,163.00,4958.30,0.00,0.00,0.00,0.00,541057),('5','95','184760','220',250.00,255.00,1175.05,0.00,0.00,0.00,0.00,541058),('5','95','184760','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,541059),('5','95','185001','219',163.00,163.00,4310.27,0.00,0.00,0.00,0.00,541697),('5','95','185001','220',250.00,265.00,3244.09,0.00,0.00,0.00,0.00,541698),('5','95','185001','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,541699),('5','95','185166','219',163.00,163.00,3887.06,0.00,0.00,0.00,0.00,542112),('5','95','185166','220',250.00,265.00,338.98,0.00,0.00,0.00,0.00,542113),('5','95','185166','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,542114),('5','95','185307','219',163.00,163.00,574.31,0.00,0.00,0.00,0.00,542457),('5','95','185307','220',250.00,265.00,386.51,0.00,0.00,0.00,0.00,542458),('5','95','185307','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,542459),('5','95','185606','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,543259),('5','95','185606','220',250.00,265.00,489.49,0.00,0.00,0.00,0.00,543260),('5','95','185606','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,543261),('5','95','185701','219',163.00,163.00,3512.68,0.00,0.00,0.00,0.00,543504),('5','95','185701','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,543505),('5','95','185701','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,543506),('5','95','185999','219',163.00,163.00,3802.16,0.00,0.00,0.00,0.00,544311),('5','95','185999','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,544312),('5','95','185999','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,544313),('5','95','186192','219',163.00,163.00,3708.60,0.00,0.00,0.00,0.00,544813),('5','95','186192','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,544814),('5','95','186192','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,544815),('5','95','186382','219',163.00,163.00,4043.36,0.00,0.00,0.00,0.00,545304),('5','95','186382','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,545305),('5','95','186382','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,545306),('5','95','186597','219',163.00,163.00,4405.11,0.00,0.00,0.00,0.00,545880),('5','95','186597','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,545881),('5','95','186597','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,545882),('5','95','186931','219',163.00,163.00,5120.08,0.00,0.00,0.00,0.00,546724),('5','95','186931','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,546725),('5','95','186931','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,546726),('5','95','187122','219',163.00,163.00,3793.91,0.00,0.00,0.00,0.00,547236),('5','95','187122','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547237),('5','95','187122','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,547238),('5','95','187157','219',163.00,163.00,5419.74,0.00,0.00,0.00,0.00,547325),('5','95','187157','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,547326),('5','95','187157','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,547327),('5','95','187525','219',163.00,163.00,5424.50,0.00,0.00,0.00,0.00,548301),('5','95','187525','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,548302),('5','95','187525','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,548303),('5','95','187628','219',163.00,163.00,3261.14,0.00,0.00,0.00,0.00,548556),('5','95','187628','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,548557),('5','95','187628','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,548558),('5','95','187832','219',163.00,163.00,4608.22,0.00,0.00,0.00,0.00,549096),('5','95','187832','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,549097),('5','95','187832','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,549098),('5','95','188073','219',163.00,163.00,5102.73,0.00,0.00,0.00,0.00,549719),('5','95','188073','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,549720),('5','95','188073','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,549721),('5','95','188220','219',163.00,163.00,8497.86,0.00,0.00,0.00,0.00,550107),('5','95','188220','220',250.00,265.00,0.00,0.00,0.00,0.00,0.00,550108),('5','95','188220','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,550109),('5','95','188467','219',163.00,163.00,6113.72,0.00,0.00,0.00,0.00,550741),('5','95','188467','220',250.00,265.00,10.10,0.00,0.00,0.00,0.00,550742),('5','95','188467','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,550743),('5','95','188763','219',163.00,163.00,4869.33,0.00,0.00,0.00,0.00,551525),('5','95','188763','220',265.00,265.00,125.71,0.00,0.00,0.00,0.00,551526),('5','95','188763','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,551527),('5','95','188798','219',163.00,163.00,5469.32,0.00,0.00,0.00,0.00,551616),('5','95','188798','220',265.00,265.00,201.76,0.00,0.00,0.00,0.00,551617),('5','95','188798','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,551618),('5','95','188993','219',163.00,163.00,4820.31,0.00,0.00,0.00,0.00,552129),('5','95','188993','220',265.00,265.00,185.43,0.00,0.00,0.00,0.00,552130),('5','95','188993','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,552131),('5','95','189290','219',163.00,163.00,4808.38,0.00,0.00,0.00,0.00,552900),('5','95','189290','220',265.00,265.00,2343.59,0.00,0.00,0.00,0.00,552901),('5','95','189290','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,552902),('5','95','189416','219',163.00,163.00,5037.49,0.00,0.00,0.00,0.00,553238),('5','95','189416','220',265.00,265.00,836.35,0.00,0.00,0.00,0.00,553239),('5','95','189416','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,553240),('5','95','189662','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,553861),('5','95','189662','220',265.00,265.00,1661.72,0.00,0.00,0.00,0.00,553862),('5','95','189662','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,553863),('5','95','189859','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,554361),('5','95','189859','220',265.00,265.00,141.18,0.00,0.00,0.00,0.00,554362),('5','95','189859','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,554363),('5','95','190194','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555263),('5','95','190194','220',265.00,265.00,1211.52,0.00,0.00,0.00,0.00,555264),('5','95','190194','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,555265),('5','95','190250','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,555388),('5','95','190250','220',265.00,265.00,2892.32,0.00,0.00,0.00,0.00,555389),('5','95','190250','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,555390),('5','95','190511','219',163.00,165.00,2492.52,0.00,0.00,0.00,0.00,556076),('5','95','190511','220',265.00,265.00,4161.84,0.00,0.00,0.00,0.00,556077),('5','95','190511','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,556078),('5','95','190767','219',165.00,165.00,2880.55,0.00,0.00,0.00,0.00,556766),('5','95','190767','220',265.00,265.00,3781.59,0.00,0.00,0.00,0.00,556767),('5','95','190767','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,556768),('5','95','190970','219',165.00,165.00,3170.73,0.00,0.00,0.00,0.00,557291),('5','95','190970','220',265.00,265.00,3916.37,0.00,0.00,0.00,0.00,557292),('5','95','190970','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,557293),('5','95','191126','219',165.00,165.00,3520.25,0.00,0.00,0.00,0.00,557695),('5','95','191126','220',265.00,265.00,2558.27,0.00,0.00,0.00,0.00,557696),('5','95','191126','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,557697),('5','95','191301','219',165.00,165.00,2479.29,0.00,0.00,0.00,0.00,558155),('5','95','191301','220',265.00,265.00,636.57,0.00,0.00,0.00,0.00,558156),('5','95','191301','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,558157),('5','95','191579','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,558893),('5','95','191579','220',265.00,265.00,573.79,0.00,0.00,0.00,0.00,558894),('5','95','191579','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,558895),('5','95','191917','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,559819),('5','95','191917','220',265.00,265.00,540.13,0.00,0.00,0.00,0.00,559820),('5','95','191917','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,559821),('5','95','191972','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,559940),('5','95','191972','220',265.00,265.00,1516.38,0.00,0.00,0.00,0.00,559941),('5','95','191972','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,559942),('5','95','192176','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,560485),('5','95','192176','220',265.00,265.00,29.78,0.00,0.00,0.00,0.00,560486),('5','95','192176','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,560487),('5','95','192368','219',165.00,165.00,2175.77,0.00,0.00,0.00,0.00,560981),('5','95','192368','220',265.00,265.00,809.40,0.00,0.00,0.00,0.00,560982),('5','95','192368','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,560983),('5','95','192632','219',165.00,165.00,2529.09,0.00,0.00,0.00,0.00,561675),('5','95','192632','220',265.00,265.00,1181.68,0.00,0.00,0.00,0.00,561676),('5','95','192632','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,561677),('5','95','192784','219',165.00,165.00,2380.51,0.00,0.00,0.00,0.00,562058),('5','95','192784','220',265.00,265.00,1265.38,0.00,0.00,0.00,0.00,562059),('5','95','192784','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,562060),('5','95','193033','219',165.00,165.00,1858.15,0.00,0.00,0.00,0.00,562716),('5','95','193033','220',265.00,265.00,1091.80,0.00,0.00,0.00,0.00,562717),('5','95','193033','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,562718),('5','95','193240','219',165.00,165.00,6459.73,0.00,0.00,0.00,0.00,563277),('5','95','193240','220',265.00,265.00,1777.60,0.00,0.00,0.00,0.00,563278),('5','95','193240','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,563279),('5','95','193558','219',165.00,165.00,4205.04,0.00,0.00,0.00,0.00,564111),('5','95','193558','220',265.00,265.00,1386.79,0.00,0.00,0.00,0.00,564112),('5','95','193558','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,564113),('5','95','193731','219',165.00,165.00,3236.43,0.00,0.00,0.00,0.00,564546),('5','95','193731','220',265.00,265.00,968.43,0.00,0.00,0.00,0.00,564547),('5','95','193731','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,564548),('5','95','193973','219',165.00,165.00,2531.91,0.00,0.00,0.00,0.00,565154),('5','95','193973','220',265.00,265.00,808.13,0.00,0.00,0.00,0.00,565155),('5','95','193973','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,565156),('5','95','194178','219',165.00,165.00,3419.86,0.00,0.00,0.00,0.00,565677),('5','95','194178','220',265.00,265.00,75.63,0.00,0.00,0.00,0.00,565678),('5','95','194178','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,565679),('5','95','194464','219',165.00,165.00,2949.67,0.00,0.00,0.00,0.00,566413),('5','95','194464','220',265.00,265.00,1520.46,0.00,0.00,0.00,0.00,566414),('5','95','194464','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,566415),('5','95','194473','219',165.00,165.00,2969.12,0.00,0.00,0.00,0.00,566436),('5','95','194473','220',265.00,265.00,715.19,0.00,0.00,0.00,0.00,566437),('5','95','194473','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,566438),('5','95','194867','219',165.00,165.00,3260.32,0.00,0.00,0.00,0.00,567458),('5','95','194867','220',265.00,265.00,1112.19,0.00,0.00,0.00,0.00,567459),('5','95','194867','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,567460),('5','95','195064','219',165.00,165.00,3867.58,0.00,0.00,0.00,0.00,567975),('5','95','195064','220',265.00,265.00,994.86,0.00,0.00,0.00,0.00,567976),('5','95','195064','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,567977),('5','95','195147','219',165.00,165.00,5055.46,0.00,0.00,0.00,0.00,568177),('5','95','195147','220',265.00,265.00,99.80,0.00,0.00,0.00,0.00,568178),('5','95','195147','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,568179),('5','95','195422','219',165.00,165.00,4554.58,0.00,0.00,0.00,0.00,568880),('5','95','195422','220',265.00,265.00,213.65,0.00,0.00,0.00,0.00,568881),('5','95','195422','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,568882),('5','95','195568','219',165.00,165.00,5092.80,0.00,0.00,0.00,0.00,569243),('5','95','195568','220',265.00,265.00,528.65,0.00,0.00,0.00,0.00,569244),('5','95','195568','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,569245),('5','95','195985','219',165.00,165.00,257.28,0.00,0.00,0.00,0.00,570320),('5','95','195985','220',265.00,265.00,261.67,0.00,0.00,0.00,0.00,570321),('5','95','195985','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,570322),('5','95','196072','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,570524),('5','95','196072','220',265.00,265.00,470.94,0.00,0.00,0.00,0.00,570525),('5','95','196072','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,570526),('5','95','196365','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,571274),('5','95','196365','220',265.00,265.00,455.01,0.00,0.00,0.00,0.00,571275),('5','95','196365','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,571276),('5','95','196508','219',165.00,165.00,3707.69,0.00,0.00,0.00,0.00,571634),('5','95','196508','220',265.00,265.00,340.84,0.00,0.00,0.00,0.00,571635),('5','95','196508','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,571636),('5','95','196852','219',165.00,165.00,3405.52,0.00,0.00,0.00,0.00,572540),('5','95','196852','220',265.00,265.00,69.82,0.00,0.00,0.00,0.00,572541),('5','95','196852','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,572542),('5','95','197010','219',165.00,165.00,4052.53,0.00,0.00,0.00,0.00,572953),('5','95','197010','220',265.00,265.00,296.62,0.00,0.00,0.00,0.00,572954),('5','95','197010','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,572955),('5','95','197084','219',165.00,165.00,2316.90,0.00,0.00,0.00,0.00,573127),('5','95','197084','220',265.00,265.00,64.13,0.00,0.00,0.00,0.00,573128),('5','95','197084','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,573129),('5','95','197697','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,574648),('5','95','197697','220',265.00,265.00,0.00,0.00,0.00,0.00,0.00,574649),('5','95','197697','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,574650),('5','95','197733','219',165.00,165.00,2134.78,0.00,0.00,0.00,0.00,574736),('5','95','197733','220',265.00,265.00,120.70,0.00,0.00,0.00,0.00,574737),('5','95','197733','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,574738),('5','95','197802','219',165.00,165.00,3164.20,0.00,0.00,0.00,0.00,574935),('5','95','197802','220',265.00,265.00,67.28,0.00,0.00,0.00,0.00,574936),('5','95','197802','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,574937),('5','95','197810','219',165.00,165.00,3633.32,0.00,0.00,0.00,0.00,574960),('5','95','197810','220',265.00,265.00,1638.41,0.00,0.00,0.00,0.00,574961),('5','95','197810','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,574962),('5','95','198046','219',165.00,165.00,5113.28,0.00,0.00,0.00,0.00,575576),('5','95','198046','220',265.00,270.00,1370.99,0.00,0.00,0.00,0.00,575577),('5','95','198046','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,575578),('5','95','198327','219',165.00,165.00,3589.60,0.00,0.00,0.00,0.00,576302),('5','95','198327','220',270.00,270.00,108.40,0.00,0.00,0.00,0.00,576303),('5','95','198327','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,576304),('5','95','198549','219',165.00,165.00,3844.60,0.00,0.00,0.00,0.00,576889),('5','95','198549','220',270.00,270.00,872.90,0.00,0.00,0.00,0.00,576890),('5','95','198549','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,576891),('5','95','198674','219',165.00,165.00,4803.90,0.00,0.00,0.00,0.00,577208),('5','95','198674','220',270.00,270.00,420.19,0.00,0.00,0.00,0.00,577209),('5','95','198674','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,577210),('5','95','198880','219',165.00,165.00,3143.32,0.00,0.00,0.00,0.00,577700),('5','95','198880','220',270.00,270.00,156.35,0.00,0.00,0.00,0.00,577701),('5','95','198880','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,577702),('5','95','199101','219',165.00,165.00,3483.11,0.00,0.00,0.00,0.00,578283),('5','95','199101','220',270.00,270.00,1257.53,0.00,0.00,0.00,0.00,578284),('5','95','199101','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,578285),('5','95','199232','219',165.00,165.00,3527.03,0.00,0.00,0.00,0.00,578589),('5','95','199232','220',270.00,270.00,192.85,0.00,0.00,0.00,0.00,578590),('5','95','199232','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,578591),('5','95','199424','219',165.00,165.00,2733.23,0.00,0.00,0.00,0.00,579076),('5','95','199424','220',270.00,270.00,821.40,0.00,0.00,0.00,0.00,579077),('5','95','199424','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,579078),('5','95','199667','219',165.00,165.00,2468.61,0.00,0.00,0.00,0.00,579666),('5','95','199667','220',270.00,270.00,1118.43,0.00,0.00,0.00,0.00,579667),('5','95','199667','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,579668),('5','95','199927','219',165.00,165.00,2553.20,0.00,0.00,0.00,0.00,580308),('5','95','199927','220',270.00,270.00,662.02,0.00,0.00,0.00,0.00,580309),('5','95','199927','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,580310),('5','95','200148','219',165.00,165.00,3835.59,0.00,0.00,0.00,0.00,580890),('5','95','200148','220',270.00,270.00,917.35,0.00,0.00,0.00,0.00,580891),('5','95','200148','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,580892),('5','95','200297','219',165.00,165.00,6097.95,0.00,0.00,0.00,0.00,581277),('5','95','200297','220',270.00,270.00,496.33,0.00,0.00,0.00,0.00,581278),('5','95','200297','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,581279),('5','95','200674','219',165.00,165.00,3619.42,0.00,0.00,0.00,0.00,582276),('5','95','200674','220',270.00,270.00,57.38,0.00,0.00,0.00,0.00,582277),('5','95','200674','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,582278),('5','95','200688','219',165.00,165.00,3477.01,0.00,0.00,0.00,0.00,582304),('5','95','200688','220',270.00,270.00,339.49,0.00,0.00,0.00,0.00,582305),('5','95','200688','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,582306),('5','95','200983','219',165.00,165.00,2966.07,0.00,0.00,0.00,0.00,583045),('5','95','200983','220',270.00,270.00,111.26,0.00,0.00,0.00,0.00,583046),('5','95','200983','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,583047),('5','95','201229','219',165.00,165.00,3375.77,0.00,0.00,0.00,0.00,583682),('5','95','201229','220',270.00,270.00,479.03,0.00,0.00,0.00,0.00,583683),('5','95','201229','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,583684),('5','95','201354','219',165.00,165.00,3043.07,0.00,0.00,0.00,0.00,583991),('5','95','201354','220',270.00,270.00,516.51,0.00,0.00,0.00,0.00,583992),('5','95','201354','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,583993),('5','95','201505','219',165.00,165.00,4034.30,0.00,0.00,0.00,0.00,584396),('5','95','201505','220',270.00,270.00,437.39,0.00,0.00,0.00,0.00,584397),('5','95','201505','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,584398),('5','95','201775','219',165.00,165.00,5270.67,0.00,0.00,0.00,0.00,585109),('5','95','201775','220',270.00,275.00,413.30,0.00,0.00,0.00,0.00,585110),('5','95','201775','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,585111),('5','95','202023','219',165.00,165.00,4106.15,0.00,0.00,0.00,0.00,585771),('5','95','202023','220',270.00,275.00,0.00,0.00,0.00,0.00,0.00,585772),('5','95','202023','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,585773),('5','95','202218','219',165.00,165.00,3997.12,0.00,0.00,0.00,0.00,586265),('5','95','202218','220',270.00,275.00,0.00,0.00,0.00,0.00,0.00,586266),('5','95','202218','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,586267),('5','95','202486','219',165.00,165.00,3058.35,0.00,0.00,0.00,0.00,586956),('5','95','202486','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,586957),('5','95','202486','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,586958),('5','95','202708','219',165.00,165.00,2647.30,0.00,0.00,0.00,0.00,587513),('5','95','202708','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,587514),('5','95','202708','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,587515),('5','95','202852','219',165.00,165.00,2875.76,0.00,0.00,0.00,0.00,587896),('5','95','202852','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,587897),('5','95','202852','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,587898),('5','95','203151','219',165.00,165.00,4128.92,0.00,0.00,0.00,0.00,588665),('5','95','203151','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,588666),('5','95','203151','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,588667),('5','95','203331','219',165.00,165.00,2613.26,0.00,0.00,0.00,0.00,589142),('5','95','203331','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,589143),('5','95','203331','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,589144),('5','95','203705','219',165.00,165.00,2079.03,0.00,0.00,0.00,0.00,590113),('5','95','203705','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,590114),('5','95','203705','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,590115),('5','95','203734','219',165.00,165.00,3080.35,0.00,0.00,0.00,0.00,590176),('5','95','203734','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,590177),('5','95','203734','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,590178),('5','95','204031','219',165.00,165.00,5725.52,0.00,0.00,0.00,0.00,590934),('5','95','204031','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,590935),('5','95','204031','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,590936),('5','95','204187','219',165.00,165.00,1624.55,0.00,0.00,0.00,0.00,591360),('5','95','204187','220',275.00,275.00,140.00,0.00,0.00,0.00,0.00,591361),('5','95','204187','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,591362),('5','95','204459','219',165.00,165.00,2426.64,0.00,0.00,0.00,0.00,592056),('5','95','204459','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,592057),('5','95','204459','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,592058),('5','95','204609','219',165.00,165.00,3880.76,0.00,0.00,0.00,0.00,592447),('5','95','204609','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,592448),('5','95','204609','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,592449),('5','95','204904','219',165.00,165.00,3049.29,0.00,0.00,0.00,0.00,593157),('5','95','204904','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593158),('5','95','204904','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593159),('5','95','205034','219',165.00,165.00,2042.62,0.00,0.00,0.00,0.00,593500),('5','95','205034','220',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593501),('5','95','205034','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,593502),('5','95','205232','219',165.00,165.00,2853.74,0.00,0.00,0.00,0.00,594014),('5','95','205232','220',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594015),('5','95','205232','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,594016),('5','95','205482','219',165.00,165.00,1554.46,0.00,0.00,0.00,0.00,594639),('5','95','205482','220',275.00,280.00,0.00,0.00,0.00,0.00,0.00,594640),('5','95','205482','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,594641),('5','95','205722','219',165.00,165.00,2072.12,0.00,0.00,0.00,0.00,595281),('5','95','205722','220',275.00,280.00,0.00,0.00,0.00,0.00,0.00,595282),('5','95','205722','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,595283),('5','95','205944','219',165.00,165.00,2418.76,0.00,0.00,0.00,0.00,595848),('5','95','205944','220',275.00,280.00,0.00,0.00,0.00,0.00,0.00,595849),('5','95','205944','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,595850),('5','95','206159','219',165.00,165.00,3100.46,0.00,0.00,0.00,0.00,596397),('5','95','206159','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596398),('5','95','206159','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,596399),('5','95','206372','219',165.00,165.00,2725.47,0.00,0.00,0.00,0.00,596934),('5','95','206372','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,596935),('5','95','206372','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,596936),('5','95','206567','219',165.00,165.00,2540.67,0.00,0.00,0.00,0.00,597441),('5','95','206567','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,597442),('5','95','206567','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,597443),('5','95','206791','219',165.00,165.00,2463.87,0.00,0.00,0.00,0.00,598020),('5','95','206791','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598021),('5','95','206791','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,598022),('5','95','207017','219',165.00,165.00,2446.57,0.00,0.00,0.00,0.00,598607),('5','95','207017','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,598608),('5','95','207017','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,598609),('5','95','207374','219',165.00,165.00,1302.87,0.00,0.00,0.00,0.00,599516),('5','95','207374','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,599517),('5','95','207374','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,599518),('5','95','207585','219',165.00,165.00,4321.04,0.00,0.00,0.00,0.00,600062),('5','95','207585','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600063),('5','95','207585','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,600064),('5','95','207711','219',165.00,165.00,2761.00,0.00,0.00,0.00,0.00,600377),('5','95','207711','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600378),('5','95','207711','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,600379),('5','95','207923','219',165.00,165.00,3208.48,0.00,0.00,0.00,0.00,600918),('5','95','207923','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,600919),('5','95','207923','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,600920),('5','95','208131','219',165.00,165.00,1934.99,0.00,0.00,0.00,0.00,601454),('5','95','208131','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,601455),('5','95','208131','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,601456),('5','95','208364','219',165.00,165.00,171.91,0.00,0.00,0.00,0.00,602051),('5','95','208364','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,602052),('5','95','208364','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,602053),('5','95','208557','219',165.00,165.00,959.74,0.00,0.00,0.00,0.00,602547),('5','95','208557','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,602548),('5','95','208557','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,602549),('5','95','208802','219',165.00,165.00,4114.87,0.00,0.00,0.00,0.00,603157),('5','95','208802','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,603158),('5','95','208802','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,603159),('5','95','209109','219',165.00,165.00,1728.88,0.00,0.00,0.00,0.00,603946),('5','95','209109','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,603947),('5','95','209109','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,603948),('5','95','209232','219',165.00,165.00,825.25,0.00,0.00,0.00,0.00,604268),('5','95','209232','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,604269),('5','95','209232','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,604270),('5','95','209442','219',165.00,165.00,712.43,0.00,0.00,0.00,0.00,604797),('5','95','209442','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,604798),('5','95','209442','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,604799),('5','95','209764','219',165.00,165.00,4026.24,0.00,0.00,0.00,0.00,605638),('5','95','209764','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,605639),('5','95','209764','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,605640),('5','95','209921','219',165.00,165.00,4160.18,0.00,0.00,0.00,0.00,606044),('5','95','209921','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,606045),('5','95','209921','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,606046),('5','95','210111','219',165.00,65.00,3034.59,0.00,0.00,0.00,0.00,606535),('5','95','210111','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,606536),('5','95','210111','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,606537),('5','95','210366','219',165.00,165.00,3170.80,0.00,0.00,0.00,0.00,607183),('5','95','210366','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,607184),('5','95','210366','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,607185),('5','95','210514','219',165.00,165.00,3753.64,0.00,0.00,0.00,0.00,607591),('5','95','210514','220',275.00,290.00,0.00,0.00,0.00,0.00,0.00,607592),('5','95','210514','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,607593),('5','95','210748','219',165.00,165.00,4408.28,0.00,0.00,0.00,0.00,608198),('5','95','210748','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,608199),('5','95','210748','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,608200),('5','95','210950','219',165.00,165.00,3768.49,0.00,0.00,0.00,0.00,608721),('5','95','210950','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,608722),('5','95','210950','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,608723),('5','95','211307','219',165.00,165.00,2388.54,0.00,0.00,0.00,0.00,609642),('5','95','211307','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,609643),('5','95','211307','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,609644),('5','95','211392','219',165.00,165.00,2807.91,0.00,0.00,0.00,0.00,609858),('5','95','211392','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,609859),('5','95','211392','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,609860),('5','95','211595','219',165.00,165.00,2443.70,0.00,0.00,0.00,0.00,610399),('5','95','211595','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,610400),('5','95','211595','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,610401),('5','95','211809','219',165.00,165.00,2174.90,0.00,0.00,0.00,0.00,610924),('5','95','211809','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,610925),('5','95','211809','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,610926),('5','95','212094','219',165.00,165.00,2303.96,0.00,0.00,0.00,0.00,611678),('5','95','212094','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,611679),('5','95','212094','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,611680),('5','95','212366','219',165.00,165.00,3117.94,0.00,0.00,0.00,0.00,612389),('5','95','212366','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,612390),('5','95','212366','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,612391),('5','95','212486','219',165.00,165.00,423.13,0.00,0.00,0.00,0.00,612702),('5','95','212486','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,612703),('5','95','212486','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,612704),('5','95','212848','219',165.00,165.00,2324.10,0.00,0.00,0.00,0.00,613668),('5','95','212848','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,613669),('5','95','212848','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,613670),('5','95','212868','219',165.00,165.00,1363.99,0.00,0.00,0.00,0.00,613713),('5','95','212868','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,613714),('5','95','212868','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,613715),('5','95','213132','219',165.00,165.00,2607.31,0.00,0.00,0.00,0.00,614401),('5','95','213132','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,614402),('5','95','213132','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,614403),('5','95','213518','219',165.00,165.00,1581.90,0.00,0.00,0.00,0.00,615403),('5','95','213518','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,615404),('5','95','213518','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,615405),('5','95','213682','219',165.00,165.00,2731.38,0.00,0.00,0.00,0.00,615835),('5','95','213682','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,615836),('5','95','213682','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,615837),('5','95','213925','219',165.00,165.00,2319.02,0.00,0.00,0.00,0.00,616466),('5','95','213925','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,616467),('5','95','213925','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,616468),('5','95','214305','219',165.00,165.00,2093.84,0.00,0.00,0.00,0.00,617469),('5','95','214305','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,617470),('5','95','214305','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,617471),('5','95','214332','219',165.00,165.00,4650.23,0.00,0.00,0.00,0.00,617534),('5','95','214332','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,617535),('5','95','214332','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,617536),('5','95','214600','219',165.00,165.00,2005.11,0.00,0.00,0.00,0.00,618222),('5','95','214600','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,618223),('5','95','214600','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,618224),('5','95','214850','219',165.00,165.00,1815.74,0.00,0.00,0.00,0.00,618879),('5','95','214850','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,618880),('5','95','214850','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,618881),('5','95','215018','219',165.00,165.00,1896.75,0.00,0.00,0.00,0.00,619311),('5','95','215018','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,619312),('5','95','215018','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,619313),('5','95','215298','219',165.00,165.00,2064.72,0.00,0.00,0.00,0.00,620036),('5','95','215298','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,620037),('5','95','215298','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,620038),('5','95','215567','219',165.00,165.00,3641.46,0.00,0.00,0.00,0.00,620717),('5','95','215567','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,620718),('5','95','215567','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,620719),('5','95','215696','219',165.00,165.00,2257.29,0.00,0.00,0.00,0.00,621052),('5','95','215696','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,621053),('5','95','215696','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,621054),('5','95','215896','219',165.00,165.00,4093.55,0.00,0.00,0.00,0.00,621578),('5','95','215896','220',275.00,295.00,0.00,0.00,0.00,0.00,0.00,621579),('5','95','215896','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,621580),('5','95','216170','219',165.00,165.00,2302.88,0.00,0.00,0.00,0.00,622281),('5','95','216170','220',295.00,295.00,0.00,0.00,0.00,0.00,0.00,622282),('5','95','216170','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,622283),('5','95','216324','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,622682),('5','95','216324','220',295.00,295.00,265.03,0.00,0.00,0.00,0.00,622683),('5','95','216324','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,622684),('5','95','216607','219',165.00,165.00,1385.08,0.00,0.00,0.00,0.00,623425),('5','95','216607','220',295.00,295.00,164.25,0.00,0.00,0.00,0.00,623426),('5','95','216607','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,623427),('5','95','216844','219',165.00,165.00,2959.99,0.00,0.00,0.00,0.00,624050),('5','95','216844','220',295.00,295.00,26.94,0.00,0.00,0.00,0.00,624051),('5','95','216844','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,624052),('5','95','217052','219',165.00,165.00,3921.10,0.00,0.00,0.00,0.00,624592),('5','95','217052','220',295.00,295.00,213.30,0.00,0.00,0.00,0.00,624593),('5','95','217052','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,624594),('5','95','217322','219',165.00,165.00,2976.25,0.00,0.00,0.00,0.00,625301),('5','95','217322','220',295.00,295.00,81.36,0.00,0.00,0.00,0.00,625302),('5','95','217322','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,625303),('5','95','217664','219',165.00,165.00,1806.22,0.00,0.00,0.00,0.00,626211),('5','95','217664','220',295.00,295.00,76.25,0.00,0.00,0.00,0.00,626212),('5','95','217664','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,626213),('5','95','217710','219',165.00,165.00,1810.19,0.00,0.00,0.00,0.00,626318),('5','95','217710','220',295.00,295.00,31.33,0.00,0.00,0.00,0.00,626319),('5','95','217710','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,626320),('5','95','218109','219',165.00,165.00,1925.61,0.00,0.00,0.00,0.00,627364),('5','95','218109','220',295.00,295.00,32.36,0.00,0.00,0.00,0.00,627365),('5','95','218109','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,627366),('5','95','218290','219',165.00,165.00,1442.03,0.00,0.00,0.00,0.00,627846),('5','95','218290','220',295.00,295.00,81.15,0.00,0.00,0.00,0.00,627847),('5','95','218290','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,627848),('5','95','218534','219',165.00,165.00,3045.62,0.00,0.00,0.00,0.00,628487),('5','95','218534','220',295.00,295.00,202.00,0.00,0.00,0.00,0.00,628488),('5','95','218534','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,628489),('5','95','218674','219',165.00,165.00,2821.15,0.00,0.00,0.00,0.00,628853),('5','95','218674','220',295.00,295.00,86.40,0.00,0.00,0.00,0.00,628854),('5','95','218674','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,628855),('5','95','218951','219',165.00,165.00,2016.00,0.00,0.00,0.00,0.00,629569),('5','95','218951','220',295.00,295.00,53.56,0.00,0.00,0.00,0.00,629570),('5','95','218951','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,629571),('5','95','219121','219',165.00,165.00,2251.17,0.00,0.00,0.00,0.00,630010),('5','95','219121','220',295.00,295.00,17.41,0.00,0.00,0.00,0.00,630011),('5','95','219121','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,630012),('5','95','219404','219',165.00,165.00,1702.90,0.00,0.00,0.00,0.00,630749),('5','95','219404','220',295.00,295.00,357.57,0.00,0.00,0.00,0.00,630750),('5','95','219404','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,630751),('5','95','219689','219',165.00,165.00,853.35,0.00,0.00,0.00,0.00,631505),('5','95','219689','220',295.00,295.00,28.29,0.00,0.00,0.00,0.00,631506),('5','95','219689','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,631507),('5','95','219856','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,631936),('5','95','219856','220',295.00,295.00,0.00,0.00,0.00,0.00,0.00,631937),('5','95','219856','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,631938),('5','95','219972','219',165.00,143.00,1776.11,0.00,0.00,0.00,0.00,632268),('5','95','219972','220',295.00,275.00,124.62,0.00,0.00,0.00,0.00,632269),('5','95','219972','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,632270),('5','95','220117','219',165.00,165.00,1967.24,0.00,0.00,0.00,0.00,632639),('5','95','220117','220',295.00,295.00,482.46,0.00,0.00,0.00,0.00,632640),('5','95','220117','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,632641),('5','95','220283','219',165.00,165.00,2247.24,0.00,0.00,0.00,0.00,633062),('5','95','220283','220',295.00,295.00,906.21,0.00,0.00,0.00,0.00,633063),('5','95','220283','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,633064),('5','95','220508','219',165.00,165.00,2018.82,0.00,0.00,0.00,0.00,633663),('5','95','220508','220',295.00,295.00,66.93,0.00,0.00,0.00,0.00,633664),('5','95','220508','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,633665),('5','95','220723','219',165.00,165.00,1526.71,0.00,0.00,0.00,0.00,634216),('5','95','220723','220',295.00,295.00,78.66,0.00,0.00,0.00,0.00,634217),('5','95','220723','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,634218),('5','95','220987','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,634914),('5','95','220987','220',295.00,295.00,0.00,0.00,0.00,0.00,0.00,634915),('5','95','220987','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,634916),('5','95','221236','219',165.00,165.00,3027.74,0.00,0.00,0.00,0.00,635556),('5','95','221236','220',295.00,295.00,624.41,0.00,0.00,0.00,0.00,635557),('5','95','221236','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,635558),('5','95','221241','219',165.00,165.00,1899.98,0.00,0.00,0.00,0.00,635568),('5','95','221241','220',295.00,295.00,543.18,0.00,0.00,0.00,0.00,635569),('5','95','221241','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,635570),('5','95','221411','219',165.00,165.00,5202.08,0.00,0.00,0.00,0.00,636007),('5','95','221411','220',295.00,295.00,542.71,0.00,0.00,0.00,0.00,636008),('5','95','221411','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,636009),('5','95','221618','219',165.00,165.00,2519.35,0.00,0.00,0.00,0.00,636557),('5','95','221618','220',295.00,295.00,378.17,0.00,0.00,0.00,0.00,636558),('5','95','221618','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,636559),('5','95','221843','219',165.00,165.00,2355.42,0.00,0.00,0.00,0.00,637134),('5','95','221843','220',295.00,295.00,524.44,0.00,0.00,0.00,0.00,637135),('5','95','221843','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,637136),('5','95','222244','219',165.00,165.00,2135.33,0.00,0.00,0.00,0.00,638183),('5','95','222244','220',295.00,295.00,513.87,0.00,0.00,0.00,0.00,638184),('5','95','222244','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,638185),('5','95','222276','219',165.00,165.00,1695.96,0.00,0.00,0.00,0.00,638255),('5','95','222276','220',295.00,295.00,42.09,0.00,0.00,0.00,0.00,638256),('5','95','222276','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,638257),('5','95','222508','219',165.00,165.00,2187.70,0.00,0.00,0.00,0.00,638849),('5','95','222508','220',295.00,295.00,576.16,0.00,0.00,0.00,0.00,638850),('5','95','222508','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,638851),('5','95','222732','219',165.00,165.00,1161.04,0.00,0.00,0.00,0.00,639447),('5','95','222732','220',295.00,295.00,35.44,0.00,0.00,0.00,0.00,639448),('5','95','222732','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,639449),('5','95','222947','219',165.00,165.00,2255.48,0.00,0.00,0.00,0.00,640027),('5','95','222947','220',295.00,295.00,57.87,0.00,0.00,0.00,0.00,640028),('5','95','222947','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,640029),('5','95','223170','219',165.00,165.00,2657.00,0.00,0.00,0.00,0.00,640609),('5','95','223170','220',295.00,295.00,75.20,0.00,0.00,0.00,0.00,640610),('5','95','223170','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,640611),('5','95','223509','219',165.00,165.00,2439.34,0.00,0.00,0.00,0.00,641437),('5','95','223509','220',295.00,295.00,137.58,0.00,0.00,0.00,0.00,641438),('5','95','223509','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,641439),('5','95','223651','219',165.00,165.00,2657.49,0.00,0.00,0.00,0.00,641798),('5','95','223651','220',295.00,295.00,26.02,0.00,0.00,0.00,0.00,641799),('5','95','223651','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,641800),('5','95','223920','219',165.00,165.00,1534.39,0.00,0.00,0.00,0.00,642491),('5','95','223920','220',295.00,295.00,106.14,0.00,0.00,0.00,0.00,642492),('5','95','223920','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,642493),('5','95','224082','219',165.00,165.00,2416.50,0.00,0.00,0.00,0.00,642922),('5','95','224082','220',295.00,295.00,55.89,0.00,0.00,0.00,0.00,642923),('5','95','224082','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,642924),('5','95','224325','219',165.00,165.00,1968.60,0.00,0.00,0.00,0.00,643540),('5','95','224325','220',295.00,295.00,23.05,0.00,0.00,0.00,0.00,643541),('5','95','224325','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,643542),('5','95','224571','219',165.00,165.00,2520.20,0.00,0.00,0.00,0.00,644192),('5','95','224571','220',295.00,295.00,27.09,0.00,0.00,0.00,0.00,644193),('5','95','224571','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,644194),('5','95','224819','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,644816),('5','95','224819','220',295.00,295.00,0.00,0.00,0.00,0.00,0.00,644817),('5','95','224819','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,644818),('5','95','224864','219',163.00,163.00,2255.40,0.00,0.00,0.00,0.00,644945),('5','95','224864','220',295.00,295.00,18.46,0.00,0.00,0.00,0.00,644946),('5','95','224864','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,644947),('5','95','225031','219',163.00,163.00,2557.97,0.00,0.00,0.00,0.00,645365),('5','95','225031','220',295.00,295.00,0.00,0.00,0.00,0.00,0.00,645366),('5','95','225031','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,645367),('5','95','225493','219',163.00,163.00,2060.50,0.00,0.00,0.00,0.00,646560),('5','95','225493','220',295.00,295.00,102.65,0.00,0.00,0.00,0.00,646561),('5','95','225493','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,646562),('5','95','225575','219',163.00,163.00,1499.66,0.00,0.00,0.00,0.00,646785),('5','95','225575','220',295.00,295.00,28.97,0.00,0.00,0.00,0.00,646786),('5','95','225575','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,646787),('5','95','225692','219',163.00,163.00,2393.53,0.00,0.00,0.00,0.00,647085),('5','95','225692','220',295.00,295.00,149.50,0.00,0.00,0.00,0.00,647086),('5','95','225692','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,647087),('5','95','225971','219',163.00,163.00,1897.41,0.00,0.00,0.00,0.00,647813),('5','95','225971','220',295.00,295.00,272.97,0.00,0.00,0.00,0.00,647814),('5','95','225971','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,647815),('5','95','226303','219',163.00,163.00,2184.90,0.00,0.00,0.00,0.00,648671),('5','95','226303','220',295.00,295.00,161.75,0.00,0.00,0.00,0.00,648672),('5','95','226303','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,648673),('5','95','226505','219',163.00,163.00,2809.18,0.00,0.00,0.00,0.00,649174),('5','95','226505','220',295.00,295.00,144.69,0.00,0.00,0.00,0.00,649175),('5','95','226505','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,649176),('5','95','226789','219',163.00,163.00,3045.97,0.00,0.00,0.00,0.00,649917),('5','95','226789','220',295.00,295.00,82.32,0.00,0.00,0.00,0.00,649918),('5','95','226789','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,649919),('5','95','227074','219',163.00,163.00,1986.11,0.00,0.00,0.00,0.00,650668),('5','95','227074','220',295.00,295.00,225.52,0.00,0.00,0.00,0.00,650669),('5','95','227074','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,650670),('5','95','227210','219',163.00,163.00,2287.83,0.00,0.00,0.00,0.00,651016),('5','95','227210','220',295.00,295.00,133.70,0.00,0.00,0.00,0.00,651017),('5','95','227210','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,651018),('5','95','227370','219',163.00,163.00,2355.22,0.00,0.00,0.00,0.00,651426),('5','95','227370','220',295.00,295.00,56.41,0.00,0.00,0.00,0.00,651427),('5','95','227370','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,651428),('5','95','227608','219',163.00,163.00,2551.91,0.00,0.00,0.00,0.00,652043),('5','95','227608','220',295.00,300.00,284.03,0.00,0.00,0.00,0.00,652044),('5','95','227608','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,652045),('5','95','227902','219',163.00,163.00,2672.57,0.00,0.00,0.00,0.00,652801),('5','95','227902','220',295.00,300.00,329.31,0.00,0.00,0.00,0.00,652802),('5','95','227902','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,652803),('5','95','229926','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,658027),('5','95','229926','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,658028),('5','95','229926','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,658029),('5','95','231376','219',163.00,163.00,2600.06,0.00,0.00,0.00,0.00,661828),('5','95','231376','220',300.00,300.00,185.33,0.00,0.00,0.00,0.00,661829),('5','95','231376','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,661830),('5','95','231499','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662154),('5','95','231499','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,662155),('5','95','231499','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,662156),('5','95','231560','219',163.00,163.00,5526.91,0.00,0.00,0.00,0.00,662324),('5','95','231560','220',300.00,300.00,603.82,0.00,0.00,0.00,0.00,662325),('5','95','231560','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,662326),('5','95','231642','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662521),('5','95','231642','220',300.00,300.00,3410.86,0.00,0.00,0.00,0.00,662522),('5','95','231642','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,662523),('5','95','231750','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662816),('5','95','231750','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,662817),('5','95','231750','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,662818),('5','95','232464','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664704),('5','95','232464','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,664705),('5','95','232464','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,664706),('5','95','232468','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664716),('5','95','232468','220',300.00,300.00,425.00,0.00,0.00,0.00,0.00,664717),('5','95','232468','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,664718),('5','95','232470','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664721),('5','95','232470','220',300.00,300.00,316.65,0.00,0.00,0.00,0.00,664722),('5','95','232470','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,664723),('5','95','232471','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664724),('5','95','232471','220',300.00,310.00,216.05,0.00,0.00,0.00,0.00,664725),('5','95','232471','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,664726),('5','95','232473','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664730),('5','95','232473','220',300.00,310.00,139.50,0.00,0.00,0.00,0.00,664731),('5','95','232473','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,664732),('5','95','232480','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,664749),('5','95','232480','220',300.00,310.00,0.00,0.00,0.00,0.00,0.00,664750),('5','95','232480','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,664751),('5','95','232482','219',163.00,163.00,1688.69,0.00,0.00,0.00,0.00,664755),('5','95','232482','220',300.00,320.00,0.00,0.00,0.00,0.00,0.00,664756),('5','95','232482','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,664757),('5','95','233768','219',163.00,163.00,2142.22,0.00,0.00,0.00,0.00,668136),('5','95','233768','220',300.00,320.00,0.00,0.00,0.00,0.00,0.00,668137),('5','95','233768','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,668138),('5','95','233772','219',163.00,163.00,2903.50,0.00,0.00,0.00,0.00,668147),('5','95','233772','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,668148),('5','95','233772','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,668149),('5','95','234220','219',163.00,163.00,2158.42,0.00,0.00,0.00,0.00,669327),('5','95','234220','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,669328),('5','95','234220','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669329),('5','95','234225','219',163.00,163.00,2101.55,0.00,0.00,0.00,0.00,669342),('5','95','234225','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,669343),('5','95','234225','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669344),('5','95','234226','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669345),('5','95','234226','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,669346),('5','95','234226','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669347),('5','95','234230','219',163.00,163.00,3574.08,0.00,0.00,0.00,0.00,669357),('5','95','234230','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,669358),('5','95','234230','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669359),('5','95','234232','219',163.00,163.00,4564.15,0.00,0.00,0.00,0.00,669363),('5','95','234232','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,669364),('5','95','234232','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669365),('5','95','234233','219',163.00,163.00,6664.60,0.00,0.00,0.00,0.00,669366),('5','95','234233','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,669367),('5','95','234233','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669368),('5','95','234234','219',163.00,163.00,5318.17,0.00,0.00,0.00,0.00,669369),('5','95','234234','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,669370),('5','95','234234','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669371),('5','95','234236','219',163.00,163.00,7610.45,0.00,0.00,0.00,0.00,669374),('5','95','234236','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,669375),('5','95','234236','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669376),('5','95','234237','219',163.00,163.00,1111.61,0.00,0.00,0.00,0.00,669377),('5','95','234237','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,669378),('5','95','234237','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,669379),('5','95','234986','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671373),('5','95','234986','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,671374),('5','95','234986','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671375),('5','95','234989','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671382),('5','95','234989','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,671383),('5','95','234989','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671384),('5','95','234991','219',163.00,165.00,0.00,0.00,0.00,0.00,0.00,671388),('5','95','234991','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,671389),('5','95','234991','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671390),('5','95','234992','219',163.00,165.00,0.00,0.00,0.00,0.00,0.00,671391),('5','95','234992','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,671392),('5','95','234992','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671393),('5','95','234994','219',163.00,165.00,0.00,0.00,0.00,0.00,0.00,671397),('5','95','234994','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,671398),('5','95','234994','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671399),('5','95','235160','219',163.00,165.00,0.00,0.00,0.00,0.00,0.00,671822),('5','95','235160','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,671823),('5','95','235160','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,671824),('5','95','236368','219',163.00,163.00,0.00,0.00,0.00,0.00,0.00,674982),('5','95','236368','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,674983),('5','95','236368','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,674984),('5','95','236371','219',163.00,165.00,6432.65,0.00,0.00,0.00,0.00,674989),('5','95','236371','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,674990),('5','95','236371','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,674991),('5','95','236405','219',165.00,165.00,8048.40,0.00,0.00,0.00,0.00,675086),('5','95','236405','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,675087),('5','95','236405','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,675088),('5','95','236409','219',165.00,165.00,525.00,0.00,0.00,0.00,0.00,675096),('5','95','236409','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,675097),('5','95','236409','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,675098),('5','95','236443','219',165.00,165.00,7771.24,0.00,0.00,0.00,0.00,675191),('5','95','236443','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,675192),('5','95','236443','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,675193),('5','95','236626','219',165.00,165.00,6434.47,0.00,0.00,0.00,0.00,675649),('5','95','236626','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,675650),('5','95','236626','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,675651),('5','95','236843','219',165.00,165.00,975.00,0.00,0.00,0.00,0.00,676211),('5','95','236843','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,676212),('5','95','236843','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,676213),('5','95','237781','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678643),('5','95','237781','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,678644),('5','95','237781','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,678645),('5','95','237784','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678651),('5','95','237784','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,678652),('5','95','237784','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,678653),('5','95','237833','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678790),('5','95','237833','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,678791),('5','95','237833','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,678792),('5','95','237964','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679109),('5','95','237964','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,679110),('5','95','237964','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,679111),('5','95','237990','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679173),('5','95','237990','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,679174),('5','95','237990','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,679175),('5','95','238266','219',165.00,165.00,2791.47,0.00,0.00,0.00,0.00,679895),('5','95','238266','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,679896),('5','95','238266','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,679897),('5','95','238815','219',165.00,163.00,0.00,0.00,0.00,0.00,0.00,681328),('5','95','238815','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,681329),('5','95','238815','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,681330),('5','95','238991','219',165.00,165.00,4259.46,0.00,0.00,0.00,0.00,681777),('5','95','238991','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,681778),('5','95','238991','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,681779),('5','95','238993','219',165.00,165.00,3139.38,0.00,0.00,0.00,0.00,681783),('5','95','238993','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,681784),('5','95','238993','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,681785),('5','95','238994','219',165.00,165.00,3818.38,0.00,0.00,0.00,0.00,681786),('5','95','238994','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,681787),('5','95','238994','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,681788),('5','95','239171','219',165.00,165.00,7148.11,0.00,0.00,0.00,0.00,682242),('5','95','239171','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682243),('5','95','239171','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,682244),('5','95','239360','219',165.00,165.00,4312.86,0.00,0.00,0.00,0.00,682728),('5','95','239360','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,682729),('5','95','239360','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,682730),('5','95','239693','219',165.00,163.00,4737.19,0.00,0.00,0.00,0.00,683606),('5','95','239693','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,683607),('5','95','239693','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,683608),('5','95','239963','219',165.00,163.00,5244.14,0.00,0.00,0.00,0.00,684315),('5','95','239963','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,684316),('5','95','239963','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,684317),('5','95','240078','219',165.00,165.00,5218.83,0.00,0.00,0.00,0.00,684598),('5','95','240078','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,684599),('5','95','240078','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,684600),('5','95','240344','219',165.00,165.00,6013.65,0.00,0.00,0.00,0.00,685288),('5','95','240344','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,685289),('5','95','240344','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,685290),('5','95','240481','219',165.00,163.00,4805.60,0.00,0.00,0.00,0.00,685641),('5','95','240481','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,685642),('5','95','240481','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,685643),('5','95','240762','219',165.00,163.00,5098.82,0.00,0.00,0.00,0.00,686328),('5','95','240762','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,686329),('5','95','240762','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,686330),('5','95','241172','219',165.00,165.00,6214.20,0.00,0.00,0.00,0.00,687441),('5','95','241172','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,687442),('5','95','241172','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,687443),('5','95','241414','219',165.00,163.00,0.00,0.00,0.00,0.00,0.00,688080),('5','95','241414','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,688081),('5','95','241414','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,688082),('5','95','241769','219',165.00,165.00,3298.90,0.00,0.00,0.00,0.00,689009),('5','95','241769','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,689010),('5','95','241769','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,689011),('5','95','241794','219',165.00,165.00,922.91,0.00,0.00,0.00,0.00,689073),('5','95','241794','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,689074),('5','95','241794','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,689075),('5','95','241822','219',165.00,163.00,0.00,0.00,0.00,0.00,0.00,689141),('5','95','241822','220',300.00,300.00,0.00,0.00,0.00,0.00,0.00,689142),('5','95','241822','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,689143),('5','95','242076','219',165.00,165.00,5086.95,0.00,0.00,0.00,0.00,689795),('5','95','242076','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,689796),('5','95','242076','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,689797),('5','95','242391','219',165.00,165.00,4082.31,0.00,0.00,0.00,0.00,690631),('5','95','242391','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,690632),('5','95','242391','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,690633),('5','95','242452','219',165.00,165.00,3686.53,0.00,0.00,0.00,0.00,690765),('5','95','242452','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,690766),('5','95','242452','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,690767),('5','95','242725','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691476),('5','95','242725','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,691477),('5','95','242725','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,691478),('5','95','243058','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692363),('5','95','243058','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,692364),('5','95','243058','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,692365),('5','95','243339','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693118),('5','95','243339','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693119),('5','95','243339','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,693120),('5','95','243471','219',165.00,170.00,0.00,0.00,0.00,0.00,0.00,693433),('5','95','243471','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693434),('5','95','243471','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,693435),('5','95','243670','219',165.00,170.00,0.00,0.00,0.00,0.00,0.00,693938),('5','95','243670','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,693939),('5','95','243670','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,693940),('5','95','243833','219',165.00,170.00,4002.40,0.00,0.00,0.00,0.00,694370),('5','95','243833','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,694371),('5','95','243833','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,694372),('5','95','244163','219',170.00,170.00,4021.45,0.00,0.00,0.00,0.00,695214),('5','95','244163','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,695215),('5','95','244163','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,695216),('5','95','244385','219',170.00,170.00,5050.92,0.00,0.00,0.00,0.00,695800),('5','95','244385','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,695801),('5','95','244385','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,695802),('5','95','244550','219',170.00,170.00,3383.85,0.00,0.00,0.00,0.00,696221),('5','95','244550','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,696222),('5','95','244550','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,696223),('5','95','244773','219',170.00,170.00,3188.38,0.00,0.00,0.00,0.00,696811),('5','95','244773','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,696812),('5','95','244773','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,696813),('5','95','245012','219',170.00,170.00,3825.54,0.00,0.00,0.00,0.00,697423),('5','95','245012','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,697424),('5','95','245012','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,697425),('5','95','245266','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,698077),('5','95','245266','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,698078),('5','95','245266','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,698079),('5','95','245762','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,699359),('5','95','245762','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,699360),('5','95','245762','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,699361),('5','95','245770','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,699380),('5','95','245770','220',300.00,345.00,0.00,0.00,0.00,0.00,0.00,699381),('5','95','245770','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,699382),('5','95','246016','219',170.00,170.00,3537.05,0.00,0.00,0.00,0.00,700030),('5','95','246016','220',300.00,345.00,51.75,0.00,0.00,0.00,0.00,700031),('5','95','246016','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,700032),('5','95','246277','219',170.00,170.00,3074.60,0.00,0.00,0.00,0.00,700698),('5','95','246277','220',345.00,345.00,255.09,0.00,0.00,0.00,0.00,700699),('5','95','246277','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,700700),('5','95','246548','219',170.00,170.00,3065.80,0.00,0.00,0.00,0.00,701422),('5','95','246548','220',345.00,345.00,396.82,0.00,0.00,0.00,0.00,701423),('5','95','246548','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,701424),('5','95','246733','219',170.00,170.00,4082.02,0.00,0.00,0.00,0.00,701898),('5','95','246733','220',345.00,345.00,122.41,0.00,0.00,0.00,0.00,701899),('5','95','246733','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,701900),('5','95','247003','219',170.00,170.00,1210.10,0.00,0.00,0.00,0.00,702586),('5','95','247003','220',345.00,345.00,125.00,0.00,0.00,0.00,0.00,702587),('5','95','247003','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,702588),('5','95','247205','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,703116),('5','95','247205','220',345.00,300.00,215.03,0.00,0.00,0.00,0.00,703117),('5','95','247205','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,703118),('5','95','247481','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,703817),('5','95','247481','220',345.00,345.00,435.03,0.00,0.00,0.00,0.00,703818),('5','95','247481','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,703819),('5','95','247816','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,704697),('5','95','247816','220',345.00,345.00,203.01,0.00,0.00,0.00,0.00,704698),('5','95','247816','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,704699),('5','95','248017','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,705210),('5','95','248017','220',345.00,345.00,124.03,0.00,0.00,0.00,0.00,705211),('5','95','248017','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,705212),('5','95','248195','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,705677),('5','95','248195','220',345.00,345.00,152.08,0.00,0.00,0.00,0.00,705678),('5','95','248195','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,705679),('5','95','248482','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,706406),('5','95','248482','220',345.00,345.00,135.12,0.00,0.00,0.00,0.00,706407),('5','95','248482','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,706408),('5','95','248795','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,707228),('5','95','248795','220',345.00,345.00,265.13,0.00,0.00,0.00,0.00,707229),('5','95','248795','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,707230),('5','95','249080','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,707975),('5','95','249080','220',345.00,345.00,485.12,0.00,0.00,0.00,0.00,707976),('5','95','249080','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,707977),('5','95','249187','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,708215),('5','95','249187','220',345.00,345.00,534.32,0.00,0.00,0.00,0.00,708216),('5','95','249187','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,708217),('5','95','249428','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,708831),('5','95','249428','220',345.00,345.00,403.12,0.00,0.00,0.00,0.00,708832),('5','95','249428','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,708833),('5','95','249658','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,709425),('5','95','249658','220',345.00,345.00,864.85,0.00,0.00,0.00,0.00,709426),('5','95','249658','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,709427),('5','95','249904','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,710053),('5','95','249904','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710054),('5','95','249904','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,710055),('5','95','250169','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,710731),('5','95','250169','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710732),('5','95','250169','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,710733),('5','95','250642','219',170.00,170.00,0.00,0.00,0.00,0.00,0.00,711938),('5','95','250642','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711939),('5','95','250642','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,711940),('5','95','250752','219',170.00,170.00,5038.86,0.00,0.00,0.00,0.00,712253),('5','95','250752','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712254),('5','95','250752','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,712255),('5','95','251198','219',170.00,170.00,8082.19,0.00,0.00,0.00,0.00,713394),('5','95','251198','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713395),('5','95','251198','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,713396),('5','95','251441','219',170.00,170.00,5379.04,0.00,0.00,0.00,0.00,714031),('5','95','251441','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714032),('5','95','251441','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,714033),('5','95','251491','219',170.00,165.00,4511.37,0.00,0.00,0.00,0.00,714174),('5','95','251491','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714175),('5','95','251491','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,714176),('5','95','251627','219',170.00,165.00,5201.76,0.00,0.00,0.00,0.00,714509),('5','95','251627','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714510),('5','95','251627','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,714511),('5','95','251818','219',170.00,165.00,5273.82,0.00,0.00,0.00,0.00,715002),('5','95','251818','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715003),('5','95','251818','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,715004),('5','95','252228','219',170.00,165.00,4843.39,0.00,0.00,0.00,0.00,716102),('5','95','252228','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716103),('5','95','252228','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,716104),('5','95','252428','219',170.00,165.00,1516.68,0.00,0.00,0.00,0.00,716615),('5','95','252428','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716616),('5','95','252428','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,716617),('5','95','252705','219',170.00,165.00,0.00,0.00,0.00,0.00,0.00,717335),('5','95','252705','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717336),('5','95','252705','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,717337),('5','95','252911','219',170.00,165.00,0.00,0.00,0.00,0.00,0.00,717864),('5','95','252911','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717865),('5','95','252911','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,717866),('5','95','253013','219',170.00,165.00,0.00,0.00,0.00,0.00,0.00,718105),('5','95','253013','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718106),('5','95','253013','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,718107),('5','95','253330','219',170.00,165.00,0.00,0.00,0.00,0.00,0.00,718951),('5','95','253330','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718952),('5','95','253330','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,718953),('5','95','253870','219',165.00,165.00,4970.86,0.00,0.00,0.00,0.00,720357),('5','95','253870','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720358),('5','95','253870','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,720359),('5','95','253886','219',165.00,165.00,5088.00,0.00,0.00,0.00,0.00,720404),('5','95','253886','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720405),('5','95','253886','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,720406),('5','95','253974','219',165.00,165.00,5230.04,0.00,0.00,0.00,0.00,720614),('5','95','253974','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720615),('5','95','253974','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,720616),('5','95','254355','219',165.00,165.00,5103.09,0.00,0.00,0.00,0.00,721609),('5','95','254355','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721610),('5','95','254355','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,721611),('5','95','254554','219',165.00,165.00,4652.22,0.00,0.00,0.00,0.00,722108),('5','95','254554','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722109),('5','95','254554','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,722110),('5','95','254825','219',165.00,163.00,802.22,0.00,0.00,0.00,0.00,722799),('5','95','254825','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722800),('5','95','254825','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,722801),('5','95','254985','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723197),('5','95','254985','220',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723198),('5','95','254985','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,723199),('5','95','255443','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724386),('5','95','255443','220',345.00,350.00,0.00,0.00,0.00,0.00,0.00,724387),('5','95','255443','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,724388),('5','95','255705','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725029),('5','95','255705','220',345.00,350.00,0.00,0.00,0.00,0.00,0.00,725030),('5','95','255705','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,725031),('5','95','256044','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725877),('5','95','256044','220',345.00,350.00,0.00,0.00,0.00,0.00,0.00,725878),('5','95','256044','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,725879),('5','95','256101','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726020),('5','95','256101','220',345.00,350.00,0.00,0.00,0.00,0.00,0.00,726021),('5','95','256101','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,726022),('5','95','256230','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726325),('5','95','256230','220',345.00,350.00,0.00,0.00,0.00,0.00,0.00,726326),('5','95','256230','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,726327),('5','95','256522','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727085),('5','95','256522','220',345.00,355.00,0.00,0.00,0.00,0.00,0.00,727086),('5','95','256522','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,727087),('5','95','256787','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727760),('5','95','256787','220',345.00,350.00,0.00,0.00,0.00,0.00,0.00,727761),('5','95','256787','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,727762),('5','95','257163','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728774),('5','95','257163','220',345.00,360.00,0.00,0.00,0.00,0.00,0.00,728775),('5','95','257163','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,728776),('5','95','257381','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729331),('5','95','257381','220',345.00,3360.00,0.00,0.00,0.00,0.00,0.00,729332),('5','95','257381','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729333),('5','95','257382','220',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729334),('5','95','257382','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,729335),('5','95','257382','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729336),('5','95','257383','220',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729337),('5','95','257383','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729338),('5','95','257383','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729339),('5','95','257384','220',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729340),('5','95','257384','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729341),('5','95','257384','219',165.00,165.00,1224.51,0.00,0.00,0.00,0.00,729342),('5','95','257385','220',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729343),('5','95','257385','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729344),('5','95','257385','219',165.00,165.00,5012.25,0.00,0.00,0.00,0.00,729345),('5','95','257386','220',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729346),('5','95','257386','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729347),('5','95','257386','219',165.00,165.00,5250.52,0.00,0.00,0.00,0.00,729348),('5','95','257387','220',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729349),('5','95','257387','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729350),('5','95','257387','219',165.00,165.00,5195.01,0.00,0.00,0.00,0.00,729351),('5','95','257388','220',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729352),('5','95','257388','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729353),('5','95','257388','219',165.00,165.00,5729.62,0.00,0.00,0.00,0.00,729354),('5','95','257389','220',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729355),('5','95','257389','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729356),('5','95','257389','219',165.00,165.00,4002.52,0.00,0.00,0.00,0.00,729357),('5','95','257390','220',345.00,390.00,0.00,0.00,0.00,0.00,0.00,729358),('5','95','257390','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729359),('5','95','257390','219',165.00,165.00,2214.14,0.00,0.00,0.00,0.00,729360),('5','95','257391','219',165.00,165.00,872.00,0.00,0.00,0.00,0.00,729361),('5','95','257391','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729362),('5','95','257391','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729363),('5','95','257392','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729364),('5','95','257392','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729365),('5','95','257392','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729366),('5','95','257393','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729367),('5','95','257393','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729368),('5','95','257393','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729369),('5','95','257394','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729370),('5','95','257394','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729371),('5','95','257394','219',165.00,1165.00,0.00,0.00,0.00,0.00,0.00,729372),('5','95','257395','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729373),('5','95','257395','221',275.00,0.00,0.00,0.00,0.00,0.00,0.00,729374),('5','95','257395','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729375),('5','95','257396','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729376),('5','95','257396','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729377),('5','95','257396','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729378),('5','95','257397','220',345.00,3415.00,0.00,0.00,0.00,0.00,0.00,729379),('5','95','257397','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729380),('5','95','257397','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729381),('5','95','257398','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729382),('5','95','257398','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729383),('5','95','257398','219',165.00,165.00,1127.26,0.00,0.00,0.00,0.00,729384),('5','95','257399','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729385),('5','95','257399','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729386),('5','95','257399','219',165.00,165.00,5425.40,0.00,0.00,0.00,0.00,729387),('5','95','257400','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729388),('5','95','257400','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729389),('5','95','257400','219',165.00,165.00,7151.00,0.00,0.00,0.00,0.00,729390),('5','95','257401','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729391),('5','95','257401','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729392),('5','95','257401','219',165.00,165.00,1013.08,0.00,0.00,0.00,0.00,729393),('5','95','257402','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729394),('5','95','257402','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729395),('5','95','257402','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729396),('5','95','257403','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729397),('5','95','257403','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729398),('5','95','257403','219',165.00,165.00,1321.05,0.00,0.00,0.00,0.00,729399),('5','95','257404','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729400),('5','95','257404','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729401),('5','95','257404','219',165.00,165.00,7122.19,0.00,0.00,0.00,0.00,729402),('5','95','257405','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729403),('5','95','257405','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729404),('5','95','257405','219',165.00,165.00,4725.00,0.00,0.00,0.00,0.00,729405),('5','95','257406','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729406),('5','95','257406','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729407),('5','95','257406','219',165.00,165.00,621.03,0.00,0.00,0.00,0.00,729408),('5','95','257407','219',165.00,165.00,1528.03,0.00,0.00,0.00,0.00,729409),('5','95','257407','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729410),('5','95','257407','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729411),('5','95','257408','219',165.00,165.00,10524.27,0.00,0.00,0.00,0.00,729412),('5','95','257408','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729413),('5','95','257408','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729414),('5','95','257409','219',165.00,165.00,11241.85,0.00,0.00,0.00,0.00,729415),('5','95','257409','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729416),('5','95','257409','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729417),('5','95','257410','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729418),('5','95','257410','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729419),('5','95','257410','219',165.00,165.00,4732.14,0.00,0.00,0.00,0.00,729420),('5','95','257411','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729421),('5','95','257411','220',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729422),('5','95','257411','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729423),('5','95','257412','220',345.00,4400.00,0.00,0.00,0.00,0.00,0.00,729424),('5','95','257412','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729425),('5','95','257412','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729426),('5','95','257413','220',345.00,500.00,0.00,0.00,0.00,0.00,0.00,729427),('5','95','257413','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729428),('5','95','257413','219',165.00,165.00,2725.82,0.00,0.00,0.00,0.00,729429),('5','95','257414','220',345.00,500.00,0.00,0.00,0.00,0.00,0.00,729430),('5','95','257414','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729431),('5','95','257414','219',165.00,165.00,5351.02,0.00,0.00,0.00,0.00,729432),('5','95','257415','220',345.00,600.00,0.00,0.00,0.00,0.00,0.00,729433),('5','95','257415','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729434),('5','95','257415','219',165.00,165.00,4135.41,0.00,0.00,0.00,0.00,729435),('5','95','257416','219',165.00,165.00,2147.28,0.00,0.00,0.00,0.00,729436),('5','95','257416','220',345.00,600.00,0.00,0.00,0.00,0.00,0.00,729437),('5','95','257416','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729438),('5','95','257417','219',165.00,165.00,835.14,0.00,0.00,0.00,0.00,729439),('5','95','257417','220',345.00,600.00,0.00,0.00,0.00,0.00,0.00,729440),('5','95','257417','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729441),('5','95','257418','219',165.00,165.00,2651.82,0.00,0.00,0.00,0.00,729442),('5','95','257418','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729443),('5','95','257418','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729444),('5','95','257419','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729445),('5','95','257419','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729446),('5','95','257419','219',165.00,165.00,8541.23,0.00,0.00,0.00,0.00,729447),('5','95','257420','219',165.00,165.00,7218.20,0.00,0.00,0.00,0.00,729448),('5','95','257420','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729449),('5','95','257420','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729450),('5','95','257421','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729451),('5','95','257421','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729452),('5','95','257421','219',165.00,165.00,4731.82,0.00,0.00,0.00,0.00,729453),('5','95','257422','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729454),('5','95','257422','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729455),('5','95','257422','219',165.00,165.00,4120.18,0.00,0.00,0.00,0.00,729456),('5','95','257423','219',165.00,165.00,5412.25,0.00,0.00,0.00,0.00,729457),('5','95','257423','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729458),('5','95','257423','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729459),('5','95','257424','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729460),('5','95','257424','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729461),('5','95','257424','219',165.00,165.00,4321.28,0.00,0.00,0.00,0.00,729462),('5','95','257425','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729463),('5','95','257425','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729464),('5','95','257425','219',165.00,165.00,4182.61,0.00,0.00,0.00,0.00,729465),('5','95','257426','219',165.00,165.00,2351.54,0.00,0.00,0.00,0.00,729466),('5','95','257426','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729467),('5','95','257426','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729468),('5','95','257427','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729469),('5','95','257427','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729470),('5','95','257427','219',165.00,165.00,1268.82,0.00,0.00,0.00,0.00,729471),('5','95','257428','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729472),('5','95','257428','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729473),('5','95','257428','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729474),('5','95','257429','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729475),('5','95','257429','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729476),('5','95','257429','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729477),('5','95','257430','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729478),('5','95','257430','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729479),('5','95','257430','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729480),('5','95','257431','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729481),('5','95','257431','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729482),('5','95','257431','219',165.00,165.00,1625.84,0.00,0.00,0.00,0.00,729483),('5','95','257432','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729484),('5','95','257432','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729485),('5','95','257432','219',165.00,165.00,5138.52,0.00,0.00,0.00,0.00,729486),('5','95','257433','220',345.00,640.00,0.00,0.00,0.00,0.00,0.00,729487),('5','95','257433','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729488),('5','95','257433','219',165.00,165.00,6620.02,0.00,0.00,0.00,0.00,729489),('5','95','257434','219',165.00,163.00,9.01,0.00,0.00,0.00,0.00,729490),('5','95','257434','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729491),('5','95','257434','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729492),('5','95','257435','219',165.00,163.00,11.99,0.00,0.00,0.00,0.00,729493),('5','95','257435','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729494),('5','95','257435','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729495),('5','95','257436','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729496),('5','95','257436','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729497),('5','95','257436','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729498),('5','95','257437','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729499),('5','95','257437','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729500),('5','95','257437','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729501),('5','95','257438','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729502),('5','95','257438','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729503),('5','95','257438','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729504),('5','95','257439','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729505),('5','95','257439','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729506),('5','95','257439','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729507),('5','95','257440','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729508),('5','95','257440','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729509),('5','95','257440','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729510),('5','95','257441','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729511),('5','95','257441','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729512),('5','95','257441','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729513),('5','95','257442','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729514),('5','95','257442','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729515),('5','95','257442','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729516),('5','95','257443','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729517),('5','95','257443','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729518),('5','95','257443','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729519),('5','95','257444','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729520),('5','95','257444','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729521),('5','95','257444','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729522),('5','95','257445','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729523),('5','95','257445','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729524),('5','95','257445','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729525),('5','95','257446','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729526),('5','95','257446','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729527),('5','95','257446','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729528),('5','95','257447','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729529),('5','95','257447','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729530),('5','95','257447','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729531),('5','95','257448','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729532),('5','95','257448','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729533),('5','95','257448','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729534),('5','95','257449','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729535),('5','95','257449','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729536),('5','95','257449','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729537),('5','95','257450','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729538),('5','95','257450','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729539),('5','95','257450','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729540),('5','95','257451','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729541),('5','95','257451','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729542),('5','95','257451','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729543),('5','95','257452','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729544),('5','95','257452','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729545),('5','95','257452','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729546),('5','95','257453','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729547),('5','95','257453','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729548),('5','95','257453','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729549),('5','95','257454','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729550),('5','95','257454','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729551),('5','95','257454','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729552),('5','95','257455','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729553),('5','95','257455','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729554),('5','95','257455','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729555),('5','95','257456','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729556),('5','95','257456','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729557),('5','95','257456','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729558),('5','95','257457','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729559),('5','95','257457','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729560),('5','95','257457','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729561),('5','95','257458','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729562),('5','95','257458','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729563),('5','95','257458','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729564),('5','95','257459','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729565),('5','95','257459','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729566),('5','95','257459','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729567),('5','95','257460','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729568),('5','95','257460','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729569),('5','95','257460','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729570),('5','95','257461','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729571),('5','95','257461','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729572),('5','95','257461','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729573),('5','95','257462','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729574),('5','95','257462','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729575),('5','95','257462','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729576),('5','95','257463','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729577),('5','95','257463','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729578),('5','95','257463','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729579),('5','95','257464','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729580),('5','95','257464','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729581),('5','95','257464','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729582),('5','95','257465','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729583),('5','95','257465','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729584),('5','95','257465','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729585),('5','95','257466','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729586),('5','95','257466','220',700.00,700.00,0.00,0.00,0.00,0.00,0.00,729587),('5','95','257466','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729588),('5','95','257467','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729589),('5','95','257467','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729590),('5','95','257467','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729591),('5','95','257468','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729592),('5','95','257468','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729593),('5','95','257468','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729594),('5','95','257469','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729595),('5','95','257469','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729596),('5','95','257469','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729597),('5','95','257470','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729598),('5','95','257470','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729599),('5','95','257470','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729600),('5','95','257471','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729601),('5','95','257471','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729602),('5','95','257471','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729603),('5','95','257472','219',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729604),('5','95','257472','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729605),('5','95','257472','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729606),('5','95','257473','219',165.00,165.00,5698.06,0.00,0.00,0.00,0.00,729607),('5','95','257473','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729608),('5','95','257473','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729609),('5','95','257474','219',165.00,165.00,3725.50,0.00,0.00,0.00,0.00,729610),('5','95','257474','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,729611),('5','95','257474','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729612),('5','95','257475','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729613),('5','95','257475','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729614),('5','95','257475','219',185.00,185.00,208.16,0.00,0.00,0.00,0.00,729615),('5','95','257476','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729616),('5','95','257476','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729617),('5','95','257476','219',185.00,185.00,2661.68,0.00,0.00,0.00,0.00,729618),('5','95','257477','219',185.00,185.00,2515.83,0.00,0.00,0.00,0.00,729619),('5','95','257477','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729620),('5','95','257477','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729621),('5','95','257478','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729622),('5','95','257478','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729623),('5','95','257478','219',185.00,185.00,2941.74,0.00,0.00,0.00,0.00,729624),('5','95','257479','219',185.00,185.00,2649.94,0.00,0.00,0.00,0.00,729625),('5','95','257479','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729626),('5','95','257479','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729627),('5','95','257480','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729628),('5','95','257480','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729629),('5','95','257480','219',185.00,185.00,2049.88,0.00,0.00,0.00,0.00,729630),('5','95','257481','219',185.00,185.00,2219.67,0.00,0.00,0.00,0.00,729631),('5','95','257481','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729632),('5','95','257481','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729633),('5','95','257482','219',185.00,185.00,2712.58,0.00,0.00,0.00,0.00,729634),('5','95','257482','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729635),('5','95','257482','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729636),('5','95','257483','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729637),('5','95','257483','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729638),('5','95','257483','219',185.00,185.00,2308.32,0.00,0.00,0.00,0.00,729639),('5','95','257484','219',185.00,185.00,3246.12,0.00,0.00,0.00,0.00,729640),('5','95','257484','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729641),('5','95','257484','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729642),('5','95','257485','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729643),('5','95','257485','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729644),('5','95','257485','219',185.00,185.00,2365.46,0.00,0.00,0.00,0.00,729645),('5','95','257486','219',185.00,185.00,2887.24,0.00,0.00,0.00,0.00,729646),('5','95','257486','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729647),('5','95','257486','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729648),('5','95','257487','219',185.00,185.00,4342.39,0.00,0.00,0.00,0.00,729649),('5','95','257487','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729650),('5','95','257487','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729651),('5','95','257488','219',185.00,185.00,2536.40,0.00,0.00,0.00,0.00,729652),('5','95','257488','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729653),('5','95','257488','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729654),('5','95','257489','219',185.00,185.00,4302.74,0.00,0.00,0.00,0.00,729655),('5','95','257489','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729656),('5','95','257489','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729657),('5','95','257490','219',185.00,185.00,4713.21,0.00,0.00,0.00,0.00,729658),('5','95','257490','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729659),('5','95','257490','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729660),('5','95','257491','219',185.00,185.00,5692.06,0.00,0.00,0.00,0.00,729661),('5','95','257491','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729662),('5','95','257491','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729663),('5','95','257492','219',185.00,185.00,5115.49,0.00,0.00,0.00,0.00,729664),('5','95','257492','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729665),('5','95','257492','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729666),('5','95','257493','219',185.00,185.00,2204.25,0.00,0.00,0.00,0.00,729667),('5','95','257493','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729668),('5','95','257493','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729669),('5','95','257494','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729670),('5','95','257494','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729671),('5','95','257494','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729672),('5','95','257495','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729673),('5','95','257495','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729674),('5','95','257495','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729675),('5','95','257496','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729676),('5','95','257496','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729677),('5','95','257496','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729678),('5','95','257497','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729679),('5','95','257497','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729680),('5','95','257497','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729681),('5','95','257498','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729682),('5','95','257498','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729683),('5','95','257498','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729684),('5','95','257499','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729685),('5','95','257499','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729686),('5','95','257499','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729687),('5','95','257500','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729688),('5','95','257500','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729689),('5','95','257500','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729690),('5','95','257501','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729691),('5','95','257501','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729692),('5','95','257501','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729693),('5','95','257502','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729694),('5','95','257502','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729695),('5','95','257502','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729696),('5','95','257503','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729697),('5','95','257503','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729698),('5','95','257503','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729699),('5','95','257504','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729700),('5','95','257504','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729701),('5','95','257504','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729702),('5','95','257505','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729703),('5','95','257505','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729704),('5','95','257505','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729705),('5','95','257506','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729706),('5','95','257506','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729707),('5','95','257506','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729708),('5','95','257507','219',185.00,185.00,2643.46,0.00,0.00,0.00,0.00,729709),('5','95','257507','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729710),('5','95','257507','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729711),('5','95','257508','219',185.00,185.00,3248.89,0.00,0.00,0.00,0.00,729712),('5','95','257508','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729713),('5','95','257508','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729714),('5','95','257509','219',185.00,185.00,3194.45,0.00,0.00,0.00,0.00,729715),('5','95','257509','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729716),('5','95','257509','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729717),('5','95','257510','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729718),('5','95','257510','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729719),('5','95','257510','219',185.00,185.00,3238.30,0.00,0.00,0.00,0.00,729720),('5','95','257511','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729721),('5','95','257511','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729722),('5','95','257511','219',185.00,185.00,2647.78,0.00,0.00,0.00,0.00,729723),('5','95','257512','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729724),('5','95','257512','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729725),('5','95','257512','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729726),('5','95','257513','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729727),('5','95','257513','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729728),('5','95','257513','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729729),('5','95','257514','219',185.00,185.00,2628.07,0.00,0.00,0.00,0.00,729730),('5','95','257514','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729731),('5','95','257514','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729732),('5','95','257515','219',185.00,185.00,2919.68,0.00,0.00,0.00,0.00,729733),('5','95','257515','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729734),('5','95','257515','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729735),('5','95','257516','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729736),('5','95','257516','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729737),('5','95','257516','219',185.00,185.00,3530.10,0.00,0.00,0.00,0.00,729738),('5','95','257517','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729739),('5','95','257517','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729740),('5','95','257517','219',185.00,185.00,3100.80,0.00,0.00,0.00,0.00,729741),('5','95','257518','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729742),('5','95','257518','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729743),('5','95','257518','219',185.00,185.00,2776.16,0.00,0.00,0.00,0.00,729744),('5','95','257519','219',185.00,185.00,2798.27,0.00,0.00,0.00,0.00,729745),('5','95','257519','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729746),('5','95','257519','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729747),('5','95','257520','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729748),('5','95','257520','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729749),('5','95','257520','219',185.00,185.00,2640.09,0.00,0.00,0.00,0.00,729750),('5','95','257521','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729751),('5','95','257521','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729752),('5','95','257521','219',185.00,185.00,3089.84,0.00,0.00,0.00,0.00,729753),('5','95','257522','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729754),('5','95','257522','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729755),('5','95','257522','219',185.00,185.00,3095.11,0.00,0.00,0.00,0.00,729756),('5','95','257523','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729757),('5','95','257523','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729758),('5','95','257523','219',185.00,185.00,2446.00,0.00,0.00,0.00,0.00,729759),('5','95','257524','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729760),('5','95','257524','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729761),('5','95','257524','219',185.00,185.00,3243.59,0.00,0.00,0.00,0.00,729762),('5','95','257525','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729763),('5','95','257525','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729764),('5','95','257525','219',185.00,185.00,3292.55,0.00,0.00,0.00,0.00,729765),('5','95','257526','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729766),('5','95','257526','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729767),('5','95','257526','219',185.00,185.00,2886.78,0.00,0.00,0.00,0.00,729768),('5','95','257527','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729769),('5','95','257527','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729770),('5','95','257527','219',185.00,185.00,2373.17,0.00,0.00,0.00,0.00,729771),('5','95','257528','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729772),('5','95','257528','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729773),('5','95','257528','219',185.00,185.00,3571.28,0.00,0.00,0.00,0.00,729774),('5','95','257529','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729775),('5','95','257529','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729776),('5','95','257529','219',185.00,185.00,3638.53,0.00,0.00,0.00,0.00,729777),('5','95','257530','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729778),('5','95','257530','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729779),('5','95','257530','219',185.00,185.00,3546.07,0.00,0.00,0.00,0.00,729780),('5','95','257531','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729781),('5','95','257531','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729782),('5','95','257531','219',185.00,185.00,3824.38,0.00,0.00,0.00,0.00,729783),('5','95','257532','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729784),('5','95','257532','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729785),('5','95','257532','219',185.00,185.00,4594.83,0.00,0.00,0.00,0.00,729786),('5','95','257533','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729787),('5','95','257533','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729788),('5','95','257533','219',185.00,185.00,4913.11,0.00,0.00,0.00,0.00,729789),('5','95','257534','219',185.00,185.00,4786.22,0.00,0.00,0.00,0.00,729790),('5','95','257534','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729791),('5','95','257534','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729792),('5','95','257535','219',185.00,185.00,3502.53,0.00,0.00,0.00,0.00,729793),('5','95','257535','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729794),('5','95','257535','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729795),('5','95','257536','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729796),('5','95','257536','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729797),('5','95','257536','219',185.00,185.00,3006.91,0.00,0.00,0.00,0.00,729798),('5','95','257537','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729799),('5','95','257537','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729800),('5','95','257537','219',185.00,185.00,3360.90,0.00,0.00,0.00,0.00,729801),('5','95','257538','219',185.00,185.00,2950.85,0.00,0.00,0.00,0.00,729802),('5','95','257538','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729803),('5','95','257538','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729804),('5','95','257539','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729805),('5','95','257539','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729806),('5','95','257539','219',185.00,185.00,2710.75,0.00,0.00,0.00,0.00,729807),('5','95','257540','219',185.00,185.00,2241.81,0.00,0.00,0.00,0.00,729808),('5','95','257540','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729809),('5','95','257540','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729810),('5','95','257541','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729811),('5','95','257541','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729812),('5','95','257541','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729813),('5','95','257542','219',185.00,185.00,697.43,0.00,0.00,0.00,0.00,729814),('5','95','257542','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729815),('5','95','257542','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729816),('5','95','257543','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729817),('5','95','257543','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729818),('5','95','257543','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729819),('5','95','257544','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729820),('5','95','257544','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729821),('5','95','257544','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729822),('5','95','257545','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729823),('5','95','257545','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729824),('5','95','257545','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729825),('5','95','257546','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729826),('5','95','257546','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729827),('5','95','257546','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729828),('5','95','257547','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729829),('5','95','257547','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729830),('5','95','257547','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729831),('5','95','257548','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729832),('5','95','257548','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729833),('5','95','257548','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729834),('5','95','257549','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729835),('5','95','257549','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729836),('5','95','257549','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729837),('5','95','257550','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729838),('5','95','257550','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729839),('5','95','257550','219',185.00,185.00,2621.98,0.00,0.00,0.00,0.00,729840),('5','95','257551','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729841),('5','95','257551','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729842),('5','95','257551','219',185.00,185.00,3674.84,0.00,0.00,0.00,0.00,729843),('5','95','257552','219',185.00,185.00,4135.13,0.00,0.00,0.00,0.00,729844),('5','95','257552','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729845),('5','95','257552','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729846),('5','95','257553','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729847),('5','95','257553','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729848),('5','95','257553','219',185.00,185.00,4021.86,0.00,0.00,0.00,0.00,729849),('5','95','257554','219',185.00,185.00,4452.10,0.00,0.00,0.00,0.00,729850),('5','95','257554','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729851),('5','95','257554','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729852),('5','95','257555','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729853),('5','95','257555','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729854),('5','95','257555','219',185.00,185.00,4640.90,0.00,0.00,0.00,0.00,729855),('5','95','257556','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729856),('5','95','257556','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729857),('5','95','257556','219',185.00,185.00,3394.92,0.00,0.00,0.00,0.00,729858),('5','95','257557','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729859),('5','95','257557','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729860),('5','95','257557','219',185.00,185.00,3336.84,0.00,0.00,0.00,0.00,729861),('5','95','257558','219',185.00,185.00,3362.49,0.00,0.00,0.00,0.00,729862),('5','95','257558','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729863),('5','95','257558','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729864),('5','95','257559','219',185.00,185.00,4287.92,0.00,0.00,0.00,0.00,729865),('5','95','257559','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729866),('5','95','257559','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729867),('5','95','257560','219',185.00,185.00,1390.57,0.00,0.00,0.00,0.00,729868),('5','95','257560','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729869),('5','95','257560','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729870),('5','95','257561','219',185.00,185.00,3761.76,0.00,0.00,0.00,0.00,729871),('5','95','257561','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729872),('5','95','257561','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729873),('5','95','257562','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729874),('5','95','257562','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729875),('5','95','257562','219',185.00,185.00,4598.56,0.00,0.00,0.00,0.00,729876),('5','95','257563','219',185.00,185.00,5633.95,0.00,0.00,0.00,0.00,729877),('5','95','257563','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729878),('5','95','257563','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729879),('5','95','257564','219',185.00,185.00,5769.96,0.00,0.00,0.00,0.00,729880),('5','95','257564','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729881),('5','95','257564','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729882),('5','95','257565','219',185.00,185.00,5538.78,0.00,0.00,0.00,0.00,729883),('5','95','257565','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729884),('5','95','257565','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729885),('5','95','257566','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729886),('5','95','257566','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729887),('5','95','257566','219',185.00,185.00,4055.58,0.00,0.00,0.00,0.00,729888),('5','95','257567','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729889),('5','95','257567','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729890),('5','95','257567','219',185.00,185.00,5047.71,0.00,0.00,0.00,0.00,729891),('5','95','257568','219',185.00,185.00,4181.32,0.00,0.00,0.00,0.00,729892),('5','95','257568','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729893),('5','95','257568','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729894),('5','95','257569','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729895),('5','95','257569','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729896),('5','95','257569','219',185.00,185.00,2323.74,0.00,0.00,0.00,0.00,729897),('5','95','257570','219',185.00,185.00,1338.66,0.00,0.00,0.00,0.00,729898),('5','95','257570','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729899),('5','95','257570','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729900),('5','95','257571','219',185.00,185.00,1564.77,0.00,0.00,0.00,0.00,729901),('5','95','257571','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729902),('5','95','257571','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729903),('5','95','257572','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729904),('5','95','257572','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729905),('5','95','257572','219',185.00,185.00,1184.47,0.00,0.00,0.00,0.00,729906),('5','95','257573','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729907),('5','95','257573','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729908),('5','95','257573','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729909),('5','95','257574','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729910),('5','95','257574','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729911),('5','95','257574','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729912),('5','95','257575','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729913),('5','95','257575','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729914),('5','95','257575','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729915),('5','95','257576','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729916),('5','95','257576','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729917),('5','95','257576','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729918),('5','95','257577','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729919),('5','95','257577','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729920),('5','95','257577','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729921),('5','95','257578','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729922),('5','95','257578','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729923),('5','95','257578','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729924),('5','95','257579','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729925),('5','95','257579','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729926),('5','95','257579','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729927),('5','95','257580','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729928),('5','95','257580','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729929),('5','95','257580','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729930),('5','95','257581','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729931),('5','95','257581','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729932),('5','95','257581','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729933),('5','95','257582','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729934),('5','95','257582','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729935),('5','95','257582','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729936),('5','95','257583','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729937),('5','95','257583','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729938),('5','95','257583','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729939),('5','95','257584','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729940),('5','95','257584','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729941),('5','95','257584','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729942),('5','95','257585','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729943),('5','95','257585','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729944),('5','95','257585','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729945),('5','95','257586','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729946),('5','95','257586','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729947),('5','95','257586','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729948),('5','95','257587','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729949),('5','95','257587','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729950),('5','95','257587','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729951),('5','95','257588','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729952),('5','95','257588','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729953),('5','95','257588','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729954),('5','95','257589','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729955),('5','95','257589','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729956),('5','95','257589','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729957),('5','95','257590','219',185.00,185.00,6933.98,0.00,0.00,0.00,0.00,729958),('5','95','257590','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729959),('5','95','257590','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729960),('5','95','257591','219',185.00,185.00,7387.63,0.00,0.00,0.00,0.00,729961),('5','95','257591','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729962),('5','95','257591','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729963),('5','95','257592','219',185.00,185.00,8417.71,0.00,0.00,0.00,0.00,729964),('5','95','257592','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729965),('5','95','257592','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729966),('5','95','257593','219',185.00,185.00,9505.70,0.00,0.00,0.00,0.00,729967),('5','95','257593','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729968),('5','95','257593','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729969),('5','95','257594','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729970),('5','95','257594','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729971),('5','95','257594','219',185.00,185.00,7709.65,0.00,0.00,0.00,0.00,729972),('5','95','257595','219',185.00,185.00,8101.37,0.00,0.00,0.00,0.00,729973),('5','95','257595','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729974),('5','95','257595','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729975),('5','95','257596','219',185.00,185.00,6908.07,0.00,0.00,0.00,0.00,729976),('5','95','257596','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729977),('5','95','257596','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729978),('5','95','257597','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729979),('5','95','257597','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729980),('5','95','257597','219',185.00,185.00,8178.58,0.00,0.00,0.00,0.00,729981),('5','95','257598','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729982),('5','95','257598','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729983),('5','95','257598','219',185.00,185.00,4844.02,0.00,0.00,0.00,0.00,729984),('5','95','257599','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729985),('5','95','257599','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729986),('5','95','257599','219',185.00,185.00,5526.78,0.00,0.00,0.00,0.00,729987),('5','95','257600','220',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729988),('5','95','257600','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729989),('5','95','257600','219',185.00,185.00,4452.32,0.00,0.00,0.00,0.00,729990),('5','95','257601','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729991),('5','95','257601','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729992),('5','95','257601','219',185.00,185.00,3347.85,0.00,0.00,0.00,0.00,729993),('5','95','257602','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729994),('5','95','257602','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729995),('5','95','257602','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729996),('5','95','257603','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729997),('5','95','257603','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,729998),('5','95','257603','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,729999),('5','95','257604','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730000),('5','95','257604','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730001),('5','95','257604','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730002),('5','95','257605','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730003),('5','95','257605','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730004),('5','95','257605','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730005),('5','95','257606','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730006),('5','95','257606','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730007),('5','95','257606','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730008),('5','95','257607','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730009),('5','95','257607','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730010),('5','95','257607','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730011),('5','95','257608','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730012),('5','95','257608','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730013),('5','95','257608','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730014),('5','95','257609','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730015),('5','95','257609','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730016),('5','95','257609','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730017),('5','95','257610','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730018),('5','95','257610','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730019),('5','95','257610','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730020),('5','95','257611','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730021),('5','95','257611','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730022),('5','95','257611','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730023),('5','95','257612','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730024),('5','95','257612','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730025),('5','95','257612','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730026),('5','95','257613','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730027),('5','95','257613','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730028),('5','95','257613','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730029),('5','95','257614','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730030),('5','95','257614','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730031),('5','95','257614','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730032),('5','95','257615','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730033),('5','95','257615','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730034),('5','95','257615','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730035),('5','95','257616','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730036),('5','95','257616','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730037),('5','95','257616','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730038),('5','95','257617','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730039),('5','95','257617','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730040),('5','95','257617','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730041),('5','95','257618','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730042),('5','95','257618','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730043),('5','95','257618','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730044),('5','95','257619','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730045),('5','95','257619','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730046),('5','95','257619','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730047),('5','95','257620','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730048),('5','95','257620','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730049),('5','95','257620','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730050),('5','95','257621','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730051),('5','95','257621','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730052),('5','95','257621','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730053),('5','95','257622','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730054),('5','95','257622','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730055),('5','95','257622','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730056),('5','95','257623','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730057),('5','95','257623','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730058),('5','95','257623','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730059),('5','95','257624','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730060),('5','95','257624','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730061),('5','95','257624','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730062),('5','95','257625','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730063),('5','95','257625','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730064),('5','95','257625','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730065),('5','95','257626','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730066),('5','95','257626','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730067),('5','95','257626','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730068),('5','95','257627','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730069),('5','95','257627','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730070),('5','95','257627','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730071),('5','95','257628','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730072),('5','95','257628','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730073),('5','95','257628','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730074),('5','95','257629','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730075),('5','95','257629','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730076),('5','95','257629','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730077),('5','95','257630','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730078),('5','95','257630','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730079),('5','95','257630','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730080),('5','95','257631','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730081),('5','95','257631','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730082),('5','95','257631','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730083),('5','95','257632','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730084),('5','95','257632','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730085),('5','95','257632','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730086),('5','95','257633','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730087),('5','95','257633','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730088),('5','95','257633','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730089),('5','95','257634','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730090),('5','95','257634','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730091),('5','95','257634','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730092),('5','95','257635','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730093),('5','95','257635','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730094),('5','95','257635','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730095),('5','95','257636','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730096),('5','95','257636','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730097),('5','95','257636','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730098),('5','95','257637','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730099),('5','95','257637','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730100),('5','95','257637','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730101),('5','95','257638','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730102),('5','95','257638','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730103),('5','95','257638','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730104),('5','95','257639','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730105),('5','95','257639','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730106),('5','95','257639','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730107),('5','95','257640','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730108),('5','95','257640','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730109),('5','95','257640','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730110),('5','95','257641','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730111),('5','95','257641','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730112),('5','95','257641','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730113),('5','95','257642','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730114),('5','95','257642','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730115),('5','95','257642','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730116),('5','95','257643','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730117),('5','95','257643','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730118),('5','95','257643','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730119),('5','95','257644','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730120),('5','95','257644','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730121),('5','95','257644','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730122),('5','95','257645','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730123),('5','95','257645','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730124),('5','95','257645','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730125),('5','95','257646','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730126),('5','95','257646','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730127),('5','95','257646','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730128),('5','95','257647','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730129),('5','95','257647','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730130),('5','95','257647','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730131),('5','95','257648','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730132),('5','95','257648','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730133),('5','95','257648','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730134),('5','95','257649','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730135),('5','95','257649','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730136),('5','95','257649','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730137),('5','95','257650','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730138),('5','95','257650','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730139),('5','95','257650','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730140),('5','95','257651','220',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730141),('5','95','257651','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730142),('5','95','257651','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730143),('5','95','257652','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730144),('5','95','257652','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730145),('5','95','257652','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730146),('5','95','257653','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730147),('5','95','257653','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730148),('5','95','257653','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730149),('5','95','257654','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730150),('5','95','257654','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730151),('5','95','257654','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730152),('5','95','257655','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730153),('5','95','257655','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730154),('5','95','257655','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730155),('5','95','257656','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730156),('5','95','257656','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730157),('5','95','257656','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730158),('5','95','257657','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730159),('5','95','257657','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730160),('5','95','257657','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730161),('5','95','257658','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730162),('5','95','257658','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730163),('5','95','257658','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730164),('5','95','257659','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730165),('5','95','257659','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730166),('5','95','257659','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730167),('5','95','257660','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730168),('5','95','257660','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730169),('5','95','257660','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730170),('5','95','257661','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730171),('5','95','257661','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730172),('5','95','257661','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730173),('5','95','257662','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730174),('5','95','257662','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730175),('5','95','257662','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730176),('5','95','257663','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730177),('5','95','257663','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730178),('5','95','257663','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730179),('5','95','257664','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730180),('5','95','257664','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730181),('5','95','257664','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730182),('5','95','257665','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730183),('5','95','257665','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730184),('5','95','257665','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730185),('5','95','257666','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730186),('5','95','257666','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730187),('5','95','257666','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730188),('5','95','257667','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730189),('5','95','257667','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730190),('5','95','257667','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730191),('5','95','257668','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730192),('5','95','257668','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730193),('5','95','257668','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730194),('5','95','257669','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730195),('5','95','257669','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730196),('5','95','257669','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730197),('5','95','257670','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730198),('5','95','257670','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730199),('5','95','257670','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730200),('5','95','257671','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730201),('5','95','257671','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730202),('5','95','257671','219',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730203),('5','95','257672','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730204),('5','95','257672','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730205),('5','95','257672','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730206),('5','95','257673','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730207),('5','95','257673','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730208),('5','95','257673','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730209),('5','95','257674','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730210),('5','95','257674','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730211),('5','95','257674','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730212),('5','95','257675','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730213),('5','95','257675','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730214),('5','95','257675','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730215),('5','95','257676','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730216),('5','95','257676','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730217),('5','95','257676','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730218),('5','95','257677','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730219),('5','95','257677','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730220),('5','95','257677','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730221),('5','95','257678','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730222),('5','95','257678','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730223),('5','95','257678','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730224),('5','95','257679','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730225),('5','95','257679','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730226),('5','95','257679','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730227),('5','95','257680','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730228),('5','95','257680','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730229),('5','95','257680','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730230),('5','95','257681','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730231),('5','95','257681','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730232),('5','95','257681','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730233),('5','95','257682','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730234),('5','95','257682','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730235),('5','95','257682','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730236),('5','95','257683','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730237),('5','95','257683','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730238),('5','95','257683','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730239),('5','95','257684','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730240),('5','95','257684','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730241),('5','95','257684','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730242),('5','95','257685','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730243),('5','95','257685','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730244),('5','95','257685','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730245),('5','95','257686','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730246),('5','95','257686','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730247),('5','95','257686','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730248),('5','95','257687','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730249),('5','95','257687','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730250),('5','95','257687','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730251),('5','95','257688','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730252),('5','95','257688','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730253),('5','95','257688','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730254),('5','95','257689','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730255),('5','95','257689','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730256),('5','95','257689','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730257),('5','95','257690','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730258),('5','95','257690','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730259),('5','95','257690','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730260),('5','95','257691','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730261),('5','95','257691','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730262),('5','95','257691','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730263),('5','95','257692','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730264),('5','95','257692','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730265),('5','95','257692','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730266),('5','95','257693','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730267),('5','95','257693','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730268),('5','95','257693','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730269),('5','95','257694','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730270),('5','95','257694','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730271),('5','95','257694','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730272),('5','95','257695','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730273),('5','95','257695','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730274),('5','95','257695','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730275),('5','95','257696','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730276),('5','95','257696','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730277),('5','95','257696','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730278),('5','95','257697','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730279),('5','95','257697','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730280),('5','95','257697','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730281),('5','95','257698','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730282),('5','95','257698','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730283),('5','95','257698','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730284),('5','95','257699','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730285),('5','95','257699','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730286),('5','95','257699','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730287),('5','95','257700','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730288),('5','95','257700','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730289),('5','95','257700','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730290),('5','95','257701','219',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730291),('5','95','257701','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730292),('5','95','257701','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730293),('5','95','257702','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730294),('5','95','257702','220',860.00,860.00,0.00,0.00,0.00,0.00,0.00,730295),('5','95','257702','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730296),('5','95','257703','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730297),('5','95','257703','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730298),('5','95','257703','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730299),('5','95','257704','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730300),('5','95','257704','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730301),('5','95','257704','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730302),('5','95','257705','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730303),('5','95','257705','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730304),('5','95','257705','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730305),('5','95','257706','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730306),('5','95','257706','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730307),('5','95','257706','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730308),('5','95','257707','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730309),('5','95','257707','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730310),('5','95','257707','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730311),('5','95','257708','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730312),('5','95','257708','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730313),('5','95','257708','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730314),('5','95','257709','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730315),('5','95','257709','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730316),('5','95','257709','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730317),('5','95','257710','219',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730318),('5','95','257710','220',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730319),('5','95','257710','221',275.00,275.00,0.00,0.00,0.00,0.00,0.00,730320);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',230,'95','PMS TANKS','TANK CONTAINING PETROLEUM.'),('5',231,'95','AGO TANK','TANK CONTAINING DIESEL.'),('5',232,'95','DPK TANK','TANK CONTAINING KEROSENE.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=583 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','95','230',578,0,'219','PMS TANK 1',45000.00,1.00,3911.61,'PMS TANK 1','389','2018-10-30 16:34:34','2022-01-04 10:13:04','600',5,1),('5','95','230',579,0,'219','PMS TANK 2',40000.00,1.00,23069.71,'PMS TANK 2','389','2018-10-30 16:40:39','2021-03-01 05:13:25','389',5,1),('5','95','230',580,0,'219','PMS TANK 3',31000.00,1.00,150.00,'PMS TANK 3','389','2018-10-30 16:43:56','2021-02-28 15:37:00','600',5,1),('5','95','231',581,0,'220','AGO TANK 4',35000.00,1.00,8765.05,'AGO TANK 4','389','2018-10-30 16:45:26','2021-02-28 15:38:35','600',5,1),('5','95','232',582,0,'221','DPK TANK 5',35000.00,1.00,0.00,'DPK TANK 5','389','2018-10-30 16:48:23','2018-10-30 16:48:23','389',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','95',582,0.00,'2023-03-01 09:01:08'),(2,'5','95',581,500.00,'2023-03-01 09:01:08'),(3,'5','95',580,-49883.36,'2023-03-01 09:01:08'),(4,'5','95',579,2790.32,'2023-03-01 09:01:08'),(5,'5','95',578,127.58,'2023-03-01 09:01:08');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */