-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_92
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_92`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_92` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_92`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=2226 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2219,30021,'',0,'24','5','92','PURCHASE','','2020-02-03 11:24:22',5,0.00,0.00,'','391','2020-02-03 11:24:22','391',0,1),(2220,4004,'',0,'2','5','92','UBA1019882661','','2020-02-03 11:24:33',5,0.00,0.00,'','391','2020-02-03 11:24:33','391',0,1),(2221,3007,'',0,'6.1','5','92','CASH','','2020-02-03 11:24:57',5,0.00,0.00,'','391','2020-02-03 11:24:57','391',0,1),(2222,4005,'',0,'20','5','92','SALES','','2020-02-03 11:25:28',5,0.00,0.00,'','391','2020-02-03 11:25:28','391',0,1),(2223,30022,'',0,'24','5','92','SALARIES & WAGES','','2020-02-03 11:25:51',5,0.00,0.00,'','391','2020-02-03 11:25:51','391',0,1),(2224,4005,'',0,'2','5','92','JA\'IZ-0010037957','','2022-03-02 19:01:57',5,0.00,0.00,'','600','2022-03-02 19:01:57','600',0,0),(2225,2000,'',0,'6','5','92','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:23:12',5,0.00,0.00,'','600','2023-02-06 10:23:12','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','92','0000-00-00','2023-02-07 14:09:32',10,'795','','0000-00-00 00:00:00','606','2023-02-08 16:13:56'),(2,'5','92','0000-00-00','2023-02-22 13:02:05',5,'795','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','92','0000-00-00','2023-02-22 13:03:07',5,'795','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','92','1','2225','6',0.00,'PMS Price Increase (185 to 220, 300litres on 20/1/2023',10500.00,'2023-02-07'),(2,'5','92','1','100','supplier',10500.00,'PMS Price Increase (185 to 220, 300litres on 20/1/2023',0.00,'2023-02-07'),(3,'5','92','2','100','supplier',0.00,'PMS Price decrease( 220 to 210 300litres on 19/2/2023',3000.00,'2023-02-22'),(4,'5','92','2','100','supplier',3000.00,'PMS Price decrease 220 to 210, 300litres on 19/2/2023',0.00,'2023-02-22'),(5,'5','92','3','100','supplier',0.00,'Ago Price decrease 830 to 820 250litres on 20/2/2023',2500.00,'2023-02-20'),(6,'5','92','3','100','supplier',2500.00,'Ago Price decrease 830 to 820 250litres on 20/2/2023',0.00,'2023-02-22');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18359 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','92',17108,'598',707.99,750.00,'2021-10-29','','2021-10-29 09:08:10','600','600',2021,'600','2021-10-29 09:08:10',5),('5','92',17748,'598',1761.33,1820.00,'2021-11-24','','2021-11-24 08:43:38','391','391',2021,'391','2021-11-24 08:43:38',5),('5','92',18347,'598',2437.70,2837.00,'2022-01-04','','2022-01-04 09:16:45','600','600',2022,'600','2022-01-04 09:16:45',5),('5','92',18348,'599',717.00,317.00,'2022-01-04','','2022-01-04 09:17:01','600','600',2022,'600','2022-01-04 09:17:01',5),('5','92',18349,'598',163.73,350.00,'2022-02-09','','2022-02-09 13:43:04','600','600',2022,'600','2022-02-09 13:43:04',5),('5','92',18350,'599',317.00,15850.00,'2022-02-09','','2022-02-09 13:43:27','600','600',2022,'600','2022-02-09 13:43:27',5),('5','92',18351,'600',508.53,24650.00,'2022-02-09','','2022-02-09 13:44:42','600','600',2022,'600','2022-02-09 13:44:42',5),('5','92',18352,'598',1314.26,1500.00,'2022-03-20','','2022-03-20 21:22:50','600','600',2022,'600','2022-03-20 21:22:50',5),('5','92',18353,'598',831.76,1000.00,'2022-04-14','','2022-04-14 21:33:36','600','600',2022,'600','2022-04-14 21:33:36',5),('5','92',18354,'598',62.45,700.00,'2022-07-30','','2022-07-30 20:12:21','600','600',2022,'600','2022-07-30 20:12:21',5),('5','92',18355,'598',9344.04,10000.00,'2022-10-09','','2022-10-09 15:29:01','600','600',2022,'600','2022-10-09 15:29:01',5),('5','92',18356,'598',4046.61,1000.00,'2022-11-02','','2022-11-07 15:51:41','391','391',2022,'391','2022-11-07 15:51:41',5),('5','92',18357,'598',3000.00,4000.00,'2022-11-02','','2022-11-07 16:19:22','391','391',2022,'391','2022-11-07 16:19:22',5),('5','92',18358,'598',4000.00,7000.00,'2022-11-02','','2022-11-07 16:20:13','391','391',2022,'391','2022-11-07 16:20:13',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1668 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','92','598',1661,'5','PUMP 3',1095626.70,'PMS PUMP 3','',NULL,NULL,'',5,'2021-07-23 12:53:30','600'),('5','92','598',1662,'5','PUMP 4',59195.52,'PMS PUMP 4',NULL,NULL,NULL,NULL,5,'2020-02-03 14:27:48','391'),('5','92','598',1663,'5','PUMP 5',0.00,'PMS PUMP 5',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','92','598',1664,'5','PUMP 1',706159.83,'PMS PUMP 1','',NULL,NULL,'',5,'2022-02-01 21:04:46','600'),('5','92','599',1665,'5','PUMP 2',1074882.89,'PMS PUMP 2','',NULL,NULL,'',5,'2021-07-23 12:52:11','600'),('5','92','600',1666,'5','PUMP 6',798002.22,'AGO PUMP 6','',NULL,NULL,'',5,'2021-10-16 09:43:16','600'),('5','92','601',1667,'5','PUMP 7',0.00,'DPK PUMP 7',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (226,'5','92','1664','598','PMS TANKS CONNECTION ERROR.','2021-07-13 12:30:00',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257840 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','92',212983,'DAILY SHIFT','2021-07-23','2021-07-23 00:00:00',NULL,'391',515832.90,515832.90,'391','2021-07-26 11:55:07','605','2021-07-26 11:58:09',10,0),('5','92',212988,'DAILY SHIFT','2021-07-24','2021-07-24 00:00:00',NULL,'391',474477.30,474477.30,'391','2021-07-26 12:08:57','605','2021-07-26 12:10:49',10,0),('5','92',212990,'DAILY SHIFT','2021-07-25','2021-07-25 00:00:00',NULL,'391',636672.30,636672.30,'391','2021-07-26 12:30:56','605','2021-07-26 16:27:14',10,0),('5','92',213099,'DAILY SHIFT','2021-07-26','2021-07-26 00:00:00',NULL,'391',284197.65,284197.65,'391','2021-07-26 19:43:59','605','2021-07-27 05:20:10',10,0),('5','92',213355,'DAILY SHITF','2021-07-27','2021-07-27 00:00:00',NULL,'391',519081.75,519081.75,'391','2021-07-27 18:49:59','605','2021-07-27 22:22:18',10,0),('5','92',213600,'DAILY SHITF','2021-07-28','2021-07-28 00:00:00',NULL,'391',406360.35,406360.35,'391','2021-07-28 18:34:34','605','2021-07-29 04:52:11',10,0),('5','92',213730,'DAILY SHITF','2021-07-29','2021-07-29 00:00:00',NULL,'391',507652.20,507652.20,'391','2021-07-29 21:28:28','605','2021-07-30 06:32:16',10,0),('5','92',213979,'DAILY SHITF','2021-07-30','2021-07-30 00:00:00',NULL,'391',503317.65,503317.65,'391','2021-07-30 19:50:35','605','2021-07-31 15:17:43',10,0),('5','92',214253,'DAILY SHITF','2021-07-31','2021-07-31 00:00:00',NULL,'391',533410.35,533410.35,'391','2021-07-31 19:22:21','605','2021-08-01 06:32:21',10,0),('5','92',214434,'DAILY SHITF','2021-08-01','2021-08-01 00:00:00',NULL,'391',573952.50,573952.50,'391','2021-08-01 20:54:21','605','2021-08-02 06:20:48',10,0),('5','92',214590,'DAILY SHITF','2021-08-02','2021-08-02 00:00:00',NULL,'391',446239.20,446239.20,'391','2021-08-02 17:54:24','605','2021-08-02 20:41:35',10,0),('5','92',214883,'DAILY SHITF','2021-08-03','2021-08-03 00:00:00',NULL,'391',557483.85,557483.85,'391','2021-08-03 21:41:44','605','2021-08-04 05:28:27',10,0),('5','92',215123,'DAILY SHITF','2021-08-04','2021-08-04 00:00:00',NULL,'391',493021.65,493021.65,'391','2021-08-04 19:58:52','605','2021-08-05 05:49:22',10,0),('5','92',215331,'DAILY SHITF','2021-08-05','2021-08-05 00:00:00',NULL,'391',414486.60,414486.60,'391','2021-08-05 21:30:20','605','2021-08-06 00:18:10',10,0),('5','92',215637,'DAILY SHITF','2021-08-06','2021-08-06 00:00:00',NULL,'391',580973.25,580973.25,'391','2021-08-06 18:48:52','605','2021-08-07 05:07:38',10,0),('5','92',215857,'DAILY SHITF','2021-08-07','2021-08-07 00:00:00',NULL,'391',490523.90,490523.90,'391','2021-08-07 19:42:00','605','2021-08-08 06:27:48',10,0),('5','92',216080,'DAILY SHITF','2021-08-08','2021-08-08 00:00:00',NULL,'391',374535.50,374535.50,'391','2021-08-08 21:57:05','605','2021-08-08 22:18:10',10,0),('5','92',216294,'DAILY SHITF','2021-08-09','2021-08-09 00:00:00',NULL,'391',428956.20,428956.20,'391','2021-08-09 18:02:26','605','2021-08-10 05:49:28',10,0),('5','92',216525,'DAILY SHITF','2021-08-10','2021-08-10 00:00:00',NULL,'391',561932.25,561932.25,'391','2021-08-10 20:14:34','605','2021-08-11 05:41:03',10,0),('5','92',216767,'DAILY SHITF','2021-08-11','2021-08-11 00:00:00',NULL,'391',382687.25,382687.25,'391','2021-08-11 19:09:47','605','2021-08-12 05:25:24',10,0),('5','92',216941,'DAILY SHITF','2021-08-12','2021-08-12 00:00:00',NULL,'391',450426.25,450426.25,'391','2021-08-12 17:56:22','605','2021-08-13 06:38:42',10,0),('5','92',217132,'DAILY SHITF','2021-08-13','2021-08-13 00:00:00',NULL,'391',616303.65,616303.65,'391','2021-08-13 22:06:02','605','2021-08-14 06:58:13',10,0),('5','92',217386,'DAILY SHITF','2021-08-14','2021-08-14 00:00:00',NULL,'391',410615.10,410615.10,'391','2021-08-14 21:05:40','605','2021-08-15 18:24:42',10,0),('5','92',217651,'DAILY SHITF','2021-08-15','2021-08-15 00:00:00',NULL,'391',416622.95,416622.95,'391','2021-08-15 18:47:58','605','2021-08-15 20:59:48',10,0),('5','92',217861,'DAILY SHITF','2021-08-16','2021-08-16 00:00:00',NULL,'391',419894.60,419894.60,'391','2021-08-16 17:55:47','605','2021-08-16 22:52:22',10,0),('5','92',218069,'DAILY SHITF','2021-08-17','2021-08-17 00:00:00',NULL,'391',441277.45,441277.45,'391','2021-08-17 20:44:06','605','2021-08-18 06:00:10',10,0),('5','92',218275,'DAILY SHITF','2021-08-18','2021-08-18 00:00:00',NULL,'391',602717.95,602717.95,'391','2021-08-18 18:46:02','605','2021-08-19 04:40:27',10,0),('5','92',218635,'DAILY SHITF','2021-08-19','2021-08-19 00:00:00',NULL,'391',473658.60,473658.60,'391','2021-08-19 17:55:16','605','2021-08-19 20:53:10',10,0),('5','92',218870,'DAILY SHITF','2021-08-20','2021-08-20 00:00:00',NULL,'391',427764.70,427764.70,'391','2021-08-20 18:23:40','605','2021-08-21 05:31:42',10,0),('5','92',219093,'DAILY SHITF','2021-08-21','2021-08-21 00:00:00',NULL,'391',132185.35,132185.35,'391','2021-08-21 20:03:40','605','2021-08-22 07:02:15',10,0),('5','92',219313,'DAILY SHITF','2021-08-22','2021-08-22 00:00:00',NULL,'391',391978.85,391978.85,'391','2021-08-22 22:00:22','605','2021-08-23 06:30:05',10,0),('5','92',219439,'DAILY SHITF','2021-08-23','2021-08-23 00:00:00',NULL,'391',485287.70,485287.70,'391','2021-08-23 18:30:55','605','2021-08-23 22:48:23',10,0),('5','92',219670,'DAILY SHITF','2021-08-24','2021-08-24 00:00:00',NULL,'391',538979.70,538979.70,'391','2021-08-24 19:41:39','605','2021-08-24 22:32:29',10,0),('5','92',219884,'DAILY SHITF','2021-08-25','2021-08-25 00:00:00',NULL,'391',363483.50,363483.50,'391','2021-08-25 21:36:31','605','2021-08-26 07:02:12',10,0),('5','92',220058,'DAILY SHITF','2021-08-26','2021-08-26 00:00:00',NULL,'391',488077.95,488077.95,'391','2021-08-26 19:28:49','605','2021-08-27 07:07:04',10,0),('5','92',220301,'DAILY SHITF','2021-08-27','2021-08-27 00:00:00',NULL,'391',407864.05,407864.05,'391','2021-08-27 19:36:43','605','2021-08-28 06:44:28',10,0),('5','92',220489,'DAILY SHITF','2021-08-28','2021-08-28 00:00:00',NULL,'391',382373.75,382373.75,'391','2021-08-28 19:19:45','605','2021-08-29 07:01:30',10,0),('5','92',220694,'DAILY SHITF','2021-08-29','2021-08-29 00:00:00',NULL,'391',562349.20,562349.20,'391','2021-08-29 20:11:41','605','2021-08-30 04:47:04',10,0),('5','92',220986,'DAILY SHITF','2021-08-30','2021-08-30 00:00:00',NULL,'391',567399.00,567399.00,'391','2021-08-30 19:22:25','605','2021-08-30 21:21:49',10,0),('5','92',221127,'DAILY SHITF','2021-08-31','2021-08-31 00:00:00',NULL,'391',486222.15,486222.15,'391','2021-08-31 19:03:24','605','2021-09-01 05:05:52',10,0),('5','92',221378,'DAILY SHITF','2021-09-01','2021-09-01 00:00:00',NULL,'391',499222.10,499222.10,'391','2021-09-01 21:58:21','605','2021-09-02 06:33:43',10,0),('5','92',221697,'DAILY SHITF','2021-09-02','2021-09-02 00:00:00',NULL,'391',405766.15,405766.15,'391','2021-09-02 19:03:56','605','2021-09-03 09:35:45',10,0),('5','92',221893,'DAILY SHITF','2021-09-03','2021-09-03 00:00:00',NULL,'391',375839.25,375839.25,'391','2021-09-03 20:38:56','605','2021-09-04 11:17:29',10,0),('5','92',222251,'DAILY SHITF','2021-09-04','2021-09-04 00:00:00',NULL,'391',437573.75,437573.75,'391','2021-09-04 21:38:02','605','2021-09-05 05:44:44',10,0),('5','92',222472,'DAILY SHITF','2021-09-05','2021-09-05 00:00:00',NULL,'391',533117.65,533117.65,'391','2021-09-05 22:31:04','605','2021-09-06 04:11:30',10,0),('5','92',222566,'DAILY SHITF','2021-09-06','2021-09-06 00:00:00',NULL,'391',454964.35,454964.35,'391','2021-09-06 18:46:14','600','2021-09-07 10:45:32',10,0),('5','92',222864,'DAILY SHITF','2021-09-07','2021-09-07 00:00:00',NULL,'391',352312.15,352312.15,'391','2021-09-07 18:44:39','600','2021-09-08 09:10:51',10,0),('5','92',223016,'DAILY SHITF','2021-09-08','2021-09-08 00:00:00',NULL,'391',377119.10,377119.10,'391','2021-09-08 21:33:53','608','2021-09-09 08:44:30',10,0),('5','92',223315,'DAILY SHITF','2021-09-09','2021-09-09 00:00:00',NULL,'391',422896.90,422896.90,'391','2021-09-09 20:20:09','608','2021-09-10 08:31:21',10,0),('5','92',223615,'DAILY SHITF','2021-09-10','2021-09-10 00:00:00',NULL,'391',458702.00,458702.00,'391','2021-09-10 20:54:26','608','2021-09-11 09:26:10',10,0),('5','92',223856,'DAILY SHITF','2021-09-11','2021-09-11 00:00:00',NULL,'391',423894.00,423894.00,'391','2021-09-11 21:53:50','608','2021-09-12 14:25:10',10,0),('5','92',224041,'DAILY SHITF','2021-09-12','2021-09-12 00:00:00',NULL,'391',386874.15,386874.15,'391','2021-09-12 18:55:10','608','2021-09-13 08:29:10',10,0),('5','92',224120,'DAILY SHITF','2021-09-13','2021-09-13 00:00:00',NULL,'391',364251.00,364251.00,'391','2021-09-13 18:51:33','608','2021-09-14 08:14:30',10,0),('5','92',224510,'DAILY SHITF','2021-09-14','2021-09-14 00:00:00',NULL,'391',404841.40,404841.40,'391','2021-09-14 21:36:10','608','2021-09-15 09:30:15',10,0),('5','92',224665,'DAILY SHITF','2021-09-15','2021-09-15 00:00:00',NULL,'391',366698.30,366698.30,'391','2021-09-15 20:02:59','608','2021-09-16 08:48:25',10,0),('5','92',224835,'DAILY SHITF','2021-09-16','2021-09-16 00:00:00',NULL,'391',540785.30,534506.84,'391','2021-09-16 19:59:06','608','2021-09-17 08:31:05',10,0),('5','92',225069,'DAILY SHITF','2021-09-17','2021-09-17 00:00:00',NULL,'391',603859.21,603859.21,'391','2021-09-17 19:40:17','608','2021-09-18 08:57:35',10,0),('5','92',225465,'DAILY SHITF','2021-09-18','2021-09-18 00:00:00',NULL,'391',426888.96,426888.96,'391','2021-09-19 13:19:13','608','2021-09-19 20:40:48',10,0),('5','92',225673,'DAILY SHITF','2021-09-19','2021-09-19 00:00:00',NULL,'391',527742.73,527742.73,'391','2021-09-19 20:49:41','608','2021-09-20 08:59:21',10,0),('5','92',225841,'DAILY SHITF','2021-09-20','2021-09-20 00:00:00',NULL,'391',455994.55,455994.55,'391','2021-09-20 17:36:20','608','2021-09-20 18:50:00',10,0),('5','92',226207,'DAILY SHITF','2021-09-21','2021-09-21 00:00:00',NULL,'391',475238.54,475238.54,'391','2021-09-21 18:54:33','608','2021-09-21 19:44:40',10,0),('5','92',226345,'DAILY SHITF','2021-09-22','2021-09-22 00:00:00',NULL,'391',426269.63,426269.63,'391','2021-09-22 18:56:14','608','2021-09-22 21:16:02',10,0),('5','92',226708,'DAILY SHITF','2021-09-23','2021-09-23 00:00:00',NULL,'391',483832.43,483832.43,'391','2021-09-23 20:38:38','608','2021-09-23 20:47:53',10,0),('5','92',226848,'DAILY SHITF','2021-09-24','2021-09-24 00:00:00',NULL,'391',238872.59,238872.59,'391','2021-09-24 20:24:43','608','2021-09-24 20:48:47',10,0),('5','92',226969,'DAILY SHITF','2021-09-25','2021-09-25 00:00:00',NULL,'391',50863.90,50863.90,'391','2021-09-25 19:09:55','608','2021-09-25 20:30:26',10,0),('5','92',227356,'DAILY SHITF','2021-09-26','2021-09-26 00:00:00',NULL,'391',96167.05,96167.05,'391','2021-09-26 21:50:41','608','2021-09-27 20:41:03',10,0),('5','92',227588,'DAILY SHITF','2021-09-27','2021-09-27 00:00:00',NULL,'391',56224.05,56224.05,'391','2021-09-27 21:03:29','608','2021-09-28 08:38:46',10,0),('5','92',227820,'DAILY SHITF','2021-09-28','2021-09-28 00:00:00',NULL,'391',36149.30,36149.30,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','92',227978,'DAILY SHITF','2021-09-28','2021-09-28 00:00:00',NULL,'391',36762.00,36762.00,'391','2021-09-29 12:38:12','608','2021-10-11 14:14:56',10,0),('5','92',231944,'DAILY SHITF','2021-10-01','2021-10-01 00:00:00',NULL,'391',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','92',231947,'DAILY SHITF','2021-10-16','2021-10-16 00:00:00',NULL,'391',74391.00,74391.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','92',231954,'DAILY SHITF','2021-10-01','2021-10-01 00:00:00',NULL,'391',74391.00,74391.00,'391','2021-10-16 10:03:16','608','2021-10-16 10:24:14',10,0),('5','92',231963,'DAILY SHITF','2021-10-02','2021-10-02 00:00:00',NULL,'391',38172.00,38172.00,'391','2021-10-16 10:33:21','608','2021-10-16 10:34:22',10,0),('5','92',231964,'DAILY SHITF','2021-10-03','2021-10-03 00:00:00',NULL,'391',85611.00,85611.00,'391','2021-10-16 10:36:57','608','2021-10-16 10:37:56',10,0),('5','92',231966,'DAILY SHITF','2021-10-04','2021-10-04 00:00:00',NULL,'391',132912.00,132912.00,'391','2021-10-16 10:41:38','608','2021-10-16 10:42:20',10,0),('5','92',231972,'DAILY SHITF','2021-10-05','2021-10-05 00:00:00',NULL,'391',96627.00,96627.00,'391','2021-10-16 11:01:39','608','2021-10-16 11:06:37',10,0),('5','92',231974,'DAILY SHITF','2021-10-06','2021-10-06 00:00:00',NULL,'391',66456.00,68671.20,'391','2021-10-16 11:08:55','608','2021-10-16 11:17:20',10,0),('5','92',232069,'DAILY SHITF','2021-10-12','2021-10-12 00:00:00',NULL,'391',446523.60,448568.80,'391','2021-10-16 19:56:40','608','2021-10-20 09:14:55',10,0),('5','92',232918,'DAILY SHITF','2021-10-13','2021-10-13 00:00:00',NULL,'391',618759.49,620376.89,'391','2021-10-20 09:23:32','608','2021-10-20 09:29:13',10,0),('5','92',232924,'DAILY SHITF','2021-10-14','2021-10-14 00:00:00',NULL,'391',884245.89,884245.89,'391','2021-10-20 09:33:43','608','2021-10-20 09:36:18',10,0),('5','92',232929,'DAILY SHITF','2021-10-15','2021-10-15 00:00:00',NULL,'391',459934.45,459934.45,'391','2021-10-20 09:42:21','608','2021-10-20 09:45:04',10,0),('5','92',232934,'DAILY SHITF','2021-10-16','2021-10-16 00:00:00',NULL,'391',69677.16,69677.16,'391','2021-10-20 09:47:06','608','2021-10-20 09:49:41',10,0),('5','92',232936,'DAILY SHITF','2021-10-17','2021-10-17 00:00:00',NULL,'391',121480.50,121480.50,'391','2021-10-20 09:51:05','608','2021-10-20 09:52:26',10,0),('5','92',232940,'DAILY SHITF','2021-10-18','2021-10-18 00:00:00',NULL,'391',154141.26,154141.26,'391','2021-10-20 09:53:55','608','2021-10-20 09:56:01',10,0),('5','92',232945,'DAILY SHITF','2021-10-19','2021-10-19 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-20 10:02:28','608','2021-10-20 10:10:50',10,0),('5','92',233061,'DAILY SHITF','2021-10-20','2021-10-20 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-20 17:47:43','608','2021-10-21 08:06:49',10,0),('5','92',233312,'DAILY SHIRT','2021-10-21','2021-10-21 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-21 17:28:35','608','2021-10-22 06:30:21',10,0),('5','92',233585,'DAILY SHITF','2021-10-22','2021-10-22 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-23 04:38:02','608','2021-10-23 09:04:54',10,0),('5','92',233769,'DAILY SHITF','2021-10-23','2021-10-23 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-23 20:14:15','608','2021-10-24 13:32:19',10,0),('5','92',234026,'DAILY SHITF','2021-10-24','2021-10-24 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-24 22:12:31','608','2021-10-25 20:04:36',10,0),('5','92',234996,'DAILY SHITF','2021-10-25','2021-10-25 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-28 16:01:11','608','2021-10-28 16:02:39',10,0),('5','92',234997,'DAILY SHITF','2021-10-26','2021-10-26 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-28 16:03:45','608','2021-10-28 16:08:21',10,0),('5','92',234999,'DAILY SHITF','2021-10-27','2021-10-27 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-28 16:12:37','608','2021-10-28 16:13:27',10,0),('5','92',235000,'DAILY SHITF','2021-10-28','2021-10-28 00:00:00',NULL,'391',122830.95,122830.95,'391','2021-10-29 09:12:54','608','2021-10-29 22:15:40',10,0),('5','92',235459,'DAILY SHIRT','2021-10-29','2021-10-29 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-30 15:15:23','608','2021-10-31 18:08:37',10,0),('5','92',235696,'DAILY SHIRT','2021-10-30','2021-10-30 00:00:00',NULL,'391',0.00,0.00,'391','2021-10-31 18:31:46','608','2021-11-02 16:27:06',10,0),('5','92',236449,'DAILY SHITF','2021-11-01','2021-11-01 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-03 18:28:56','608','2021-11-04 08:46:24',10,0),('5','92',236581,'DAILY SHIRT','2021-11-02','2021-11-02 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-04 08:49:50','608','2021-11-04 08:51:34',10,0),('5','92',236584,'DAILY SHIRT','2021-11-03','2021-11-03 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-04 08:54:10','608','2021-11-04 08:55:23',10,0),('5','92',236590,'DAILY SHIRT','2021-11-04','2021-11-04 00:00:00',NULL,'391',849235.20,849235.20,'391','2021-11-04 18:14:13','608','2021-11-05 16:14:22',10,0),('5','92',236887,'DAILY SHIRT','2021-11-05','2021-11-05 00:00:00',NULL,'391',932166.90,932166.90,'391','2021-11-06 06:15:45','608','2021-11-08 14:07:59',10,0),('5','92',238212,'DAILY SHIRT','2021-11-07','2021-11-07 00:00:00',NULL,'391',310460.70,310460.70,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','92',238441,'DAILY SHITF','2021-11-06','2021-11-06 00:00:00',NULL,'391',310460.70,310460.70,'391','2021-11-12 09:09:09','608','2021-11-12 09:55:01',10,0),('5','92',238456,'DAILY SHITF','2021-11-07','2021-11-07 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-12 09:58:05','608','2021-11-12 09:59:35',10,0),('5','92',238459,'DAILY SHIRT','2021-11-08','2021-11-08 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-12 10:00:52','608','2021-11-12 10:02:02',10,0),('5','92',238461,'DAILY SHITF','2021-11-09','2021-11-09 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-12 10:03:49','608','2021-11-12 10:05:38',10,0),('5','92',238465,'DAILY SHIRT','2021-11-10','2021-11-10 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-12 10:07:32','608','2021-11-12 10:08:43',10,0),('5','92',238466,'DAILY SHIRT','2021-11-11','2021-11-11 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-12 10:10:06','608','2021-11-12 10:11:53',10,0),('5','92',238472,'DAILY SHIRT','2021-11-12','2021-11-12 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-12 18:31:50','608','2021-11-13 21:06:43',10,0),('5','92',238801,'DAILY SHITF','2021-11-13','2021-11-13 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-13 21:12:55','608','2021-11-13 21:25:10',10,0),('5','92',238938,'DAILY SHIRT','2021-11-14','2021-11-14 00:00:00',NULL,'391',1461115.80,1461115.80,'391','2021-11-14 21:20:33','608','2021-11-15 11:08:46',10,0),('5','92',239202,'DAILY SHIRT','2021-11-15','2021-11-15 00:00:00',NULL,'391',1312845.45,1312845.45,'391','2021-11-15 20:52:52','608','2021-11-16 14:14:57',10,0),('5','92',239472,'DAILY SHITF','2021-11-16','2021-11-16 00:00:00',NULL,'391',588750.75,588750.75,'391','2021-11-16 20:03:25','608','2021-11-17 18:55:38',10,0),('5','92',239727,'DAILY SHIRT','2021-11-17','2021-11-17 00:00:00',NULL,'391',245513.55,245513.55,'391','2021-11-17 20:27:17','608','2021-11-18 16:48:33',10,0),('5','92',239932,'DAILY SHIRT','2021-11-18','2021-11-18 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-18 19:42:10','608','2021-11-19 21:58:03',10,0),('5','92',240233,'DAILY SHIRT','2021-11-19','2021-11-19 00:00:00',NULL,'391',680143.20,680143.20,'391','2021-11-20 18:24:32','600','2021-11-20 18:26:03',10,0),('5','92',240377,'DAILY SHIRT','2021-11-20','2021-11-20 00:00:00',NULL,'391',1604486.40,1604486.40,'391','2021-11-20 18:34:34','600','2021-11-20 18:41:37',10,0),('5','92',240622,'DAILY SHIRT','2021-11-21','2021-11-21 00:00:00',NULL,'391',1617511.50,1617511.50,'391','2021-11-21 20:09:44','608','2021-11-22 10:41:42',10,0),('5','92',240810,'DAILY SHIRT','2021-11-22','2021-11-22 00:00:00',NULL,'391',822577.80,822577.80,'391','2021-11-22 20:52:43','608','2021-11-23 06:05:57',10,0),('5','92',241179,'DAILY SHIRT','2021-11-23','2021-11-23 00:00:00',NULL,'391',299877.60,299877.60,'391','2021-11-24 08:47:37','608','2021-11-24 20:49:19',10,0),('5','92',241446,'DAILY SHIRT','2021-11-24','2021-11-24 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-24 20:57:16','608','2021-11-26 20:49:16',10,0),('5','92',242607,'DAILY SHIRT','2021-11-25','2021-11-25 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-29 17:42:56','608','2021-11-30 11:06:41',10,0),('5','92',242786,'DAILY SHIRT','2021-11-26','2021-11-26 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-30 11:18:37','608','2021-11-30 12:03:03',10,0),('5','92',242792,'DAILY SHIRT','2021-11-27','2021-11-27 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-30 12:08:23','608','2021-11-30 12:09:07',10,0),('5','92',242794,'DAILY SHIRT','2021-11-28','2021-11-28 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-30 12:15:22','608','2021-11-30 12:15:58',10,0),('5','92',242795,'DAILY SHIRT','2021-11-29','2021-11-29 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-30 12:18:52','608','2021-11-30 12:27:11',10,0),('5','92',242808,'DAILY SHIRT','2021-11-30','2021-11-30 00:00:00',NULL,'391',0.00,0.00,'391','2021-11-30 13:32:24','608','2021-12-02 14:11:57',10,0),('5','92',243275,'DAILY SHIRT','2021-12-01','2021-12-01 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-02 14:14:41','608','2021-12-02 14:15:35',10,0),('5','92',243293,'DAILY SHIRT','2021-12-02','2021-12-02 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-02 16:54:24','608','2021-12-03 10:54:44',10,0),('5','92',243537,'DAILY SHIRT','2021-12-03','2021-12-03 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-03 17:47:57','608','2021-12-04 19:42:51',10,0),('5','92',244012,'DAILY SHIRT','2021-12-04','2021-12-04 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-05 20:57:07','608','2021-12-06 08:47:11',10,0),('5','92',244235,'DAILY SHIRT','2021-12-05','2021-12-05 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-06 19:16:03','608','2021-12-07 17:05:36',10,0),('5','92',244455,'DAILY SHIRT','2021-12-06','2021-12-06 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-07 17:35:20','608','2021-12-08 20:55:14',10,0),('5','92',245149,'DAILY SHIRT','2021-12-07','2021-12-07 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-11 18:17:45','608','2021-12-11 18:18:29',10,0),('5','92',245384,'DAILY SHITF','2021-12-08','2021-12-08 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-11 18:19:49','608','2021-12-11 18:21:05',10,0),('5','92',245386,'DAILY SHIRT','2021-12-09','2021-12-09 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-11 18:30:26','608','2021-12-11 18:36:58',10,0),('5','92',245387,'DAILY SHIRT','2021-12-10','2021-12-10 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-11 18:38:44','608','2021-12-11 18:39:19',10,0),('5','92',245389,'DAILY SHIRT','2021-12-11','2021-12-11 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-11 18:41:02','608','2021-12-11 18:41:44',10,0),('5','92',245608,'DAILY SHIRT','2021-12-12','2021-12-12 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-12 17:22:51','608','2021-12-12 21:20:25',10,0),('5','92',245876,'DAILY SHIRT','2021-12-13','2021-12-13 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-13 17:31:40','608','2021-12-14 08:37:59',10,0),('5','92',246124,'DAILY SHIRT','2021-12-14','2021-12-14 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-14 17:25:45','608','2021-12-14 22:17:04',10,0),('5','92',246393,'DAILY SHIRT','2021-12-15','2021-12-15 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-15 17:29:33','608','2021-12-16 09:03:26',10,0),('5','92',246641,'DAILY SHIRT','2021-12-16','2021-12-16 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-16 18:10:52','608','2021-12-17 16:45:17',10,0),('5','92',246873,'DAILY SHIRT','2021-12-17','2021-12-17 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-17 17:29:39','608','2021-12-18 17:39:10',10,0),('5','92',247116,'DAILY SHIRT','2021-12-18','2021-12-18 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-18 17:48:41','608','2021-12-19 18:41:40',10,0),('5','92',247353,'DAILY SHIRT','2021-12-19','2021-12-19 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-19 18:58:53','608','2021-12-20 09:14:00',10,0),('5','92',247597,'DAILY SHIRT','2021-12-20','2021-12-20 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-20 17:27:21','608','2021-12-21 15:46:45',10,0),('5','92',247845,'DAILY SHITF','2021-12-21','2021-12-21 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-21 17:47:09','608','2021-12-21 21:08:04',10,0),('5','92',248107,'DAILY SHITF','2021-12-22','2021-12-22 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-23 07:40:47','608','2021-12-25 13:01:38',10,0),('5','92',249041,'DAILY SHITF','2021-12-23','2021-12-23 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-26 17:54:16','608','2021-12-26 17:55:59',10,0),('5','92',249043,'DAILY SHIRT','2021-12-24','2021-12-24 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-26 18:00:12','608','2021-12-26 18:01:34',10,0),('5','92',249045,'DAILY SHITF','2021-12-25','2021-12-25 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-26 18:03:14','608','2021-12-26 18:04:00',10,0),('5','92',249046,'DAILY SHITF','2021-12-26','2021-12-26 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-26 18:05:20','608','2021-12-26 18:06:11',10,0),('5','92',249281,'DAILY SHITF','2021-12-27','2021-12-27 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-27 17:54:35','608','2021-12-29 10:09:58',10,0),('5','92',249782,'DAILY SHITF','2021-12-28','2021-12-28 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-29 17:31:24','608','2021-12-30 18:28:37',10,0),('5','92',250055,'DAILY SHITF','2021-12-29','2021-12-29 00:00:00',NULL,'391',0.00,0.00,'391','2021-12-30 19:59:22','608','2021-12-30 20:01:27',10,0),('5','92',250075,'DAILY SHITF','2021-12-30','2021-12-30 00:00:00',NULL,'391',128700.00,128700.00,'391','2021-12-31 09:44:11','608','2021-12-31 20:47:42',10,0),('5','92',250304,'DAILY SHITF','2021-12-31','2021-12-31 00:00:00',NULL,'391',920945.85,920945.85,'391','2021-12-31 21:24:50','600','2022-01-02 10:13:28',10,0),('5','92',250644,'DAILY SHITF','2022-01-01','2022-01-01 00:00:00',NULL,'391',901162.35,901162.35,'391','2022-01-02 10:17:51','608','2022-01-02 14:17:00',10,0),('5','92',250735,'DAILY SHITF','2022-01-02','2022-01-02 00:00:00',NULL,'391',1326893.70,1326893.70,'391','2022-01-02 21:50:20','600','2022-01-03 16:53:03',10,0),('5','92',250953,'DAILY SHITF','2022-01-03','2022-01-03 00:00:00',NULL,'391',467492.85,467492.85,'391','2022-01-04 09:55:54','608','2022-01-04 13:53:30',10,0),('5','92',251208,'DAILY SHITF','2022-01-04','2022-01-04 00:00:00',NULL,'391',2059358.40,2059358.40,'391','2022-01-04 17:38:20','608','2022-01-05 10:46:12',10,0),('5','92',251466,'DAILY SHITF','2022-01-05','2022-01-05 00:00:00',NULL,'391',1462058.40,1462058.40,'391','2022-01-05 20:22:11','608','2022-01-06 18:16:01',10,0),('5','92',251736,'DAILY SHITF','2022-01-06','2022-01-06 00:00:00',NULL,'391',1136643.75,1136643.75,'391','2022-01-06 22:31:59','608','2022-01-07 12:26:11',10,0),('5','92',251950,'DAILY SHITF','2022-01-07','2022-01-07 00:00:00',NULL,'391',239641.05,239641.05,'391','2022-01-07 21:25:04','608','2022-01-08 19:02:29',10,0),('5','92',252190,'DAILY SHITF','2022-01-08','2022-01-08 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-08 20:35:14','608','2022-01-11 14:32:48',10,0),('5','92',253144,'DAILY SHITF','2022-01-09','2022-01-09 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-12 19:00:24','608','2022-01-12 19:55:02',10,0),('5','92',253158,'DAILY SHITF','2022-01-10','2022-01-10 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-12 20:14:56','608','2022-01-12 20:18:10',10,0),('5','92',253159,'DAILY SHITF','2022-01-11','2022-01-11 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-12 20:22:24','608','2022-01-12 20:23:34',10,0),('5','92',253160,'DAILY SHITF','2022-01-12','2022-01-12 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-12 20:25:03','608','2022-01-12 20:25:53',10,0),('5','92',253301,'DAILY SHITF','2022-01-13','2022-01-13 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-13 18:40:54','608','2022-01-13 22:53:09',10,0),('5','92',253655,'DAILY SHITF','2022-01-14','2022-01-14 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-14 19:20:40','608','2022-01-15 09:35:53',10,0),('5','92',253910,'DAILY SHIRT','2022-01-15','2022-01-15 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-15 21:13:23','608','2022-01-16 10:47:22',10,0),('5','92',254134,'DAILY SHITF','2022-01-16','2022-01-16 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-16 18:45:13','608','2022-01-17 09:58:20',10,0),('5','92',254391,'DAILY SHITF','2022-01-17','2022-01-17 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-17 19:00:42','608','2022-01-18 15:53:09',10,0),('5','92',254641,'DAILY SHIRT','2022-01-18','2022-01-18 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-18 18:59:43','608','2022-01-19 10:03:01',10,0),('5','92',254890,'DAILY SHITF','2022-01-19','2022-01-19 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-19 18:47:21','608','2022-01-20 07:17:45',10,0),('5','92',255127,'DAILY SHIRT','2022-01-20','2022-01-20 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-20 18:22:42','608','2022-01-21 11:17:40',10,0),('5','92',255390,'DAILY SHIRT','2022-01-21','2022-01-21 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-21 18:06:10','608','2022-01-22 22:10:12',10,0),('5','92',255826,'DAILY SHITF','2022-01-23','2022-01-23 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-23 14:07:00','608','2022-01-24 04:02:01',10,0),('5','92',256129,'DAILY SHIRT','2022-01-24','2022-01-24 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-24 18:16:17','608','2022-01-24 21:17:05',10,0),('5','92',256419,'DAILY SHITF','2022-01-25','2022-01-25 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-25 18:56:32','608','2022-01-26 10:16:30',10,0),('5','92',256671,'DAILY SHITF','2022-01-26','2022-01-26 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-26 19:51:47','608','2022-01-27 19:00:45',10,0),('5','92',256904,'DAILY SHITF','2022-01-27','2022-01-27 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-27 19:54:49','608','2022-01-28 22:07:52',10,0),('5','92',257465,'DAILY SHITF','2022-01-28','2022-01-28 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-29 23:45:33','608','2022-01-30 13:01:02',10,0),('5','92',257466,'DAILY SHITF','2022-01-30','2022-01-30 00:00:00',NULL,'391',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','92',257467,'DAILY SHITF','2022-01-29','2022-01-29 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-31 11:56:06','600','2022-01-31 11:56:31',10,0),('5','92',257468,'DAILY SHITF','2022-01-30','2022-01-30 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-31 11:57:16','600','2022-01-31 11:57:38',10,0),('5','92',257469,'DAILY SHIRT','2022-01-31','2022-01-31 00:00:00',NULL,'391',0.00,0.00,'391','2022-01-31 19:47:56','608','2022-01-31 22:15:12',10,0),('5','92',257470,'DAILY','2022-02-01','2022-02-01 00:00:00',NULL,'600',0.00,0.00,'391','2022-02-07 21:08:01','608','2022-02-07 21:45:18',10,0),('5','92',257471,'Morning ','2022-02-02','2022-02-02 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-08 10:23:57','608','2022-02-08 10:35:35',10,0),('5','92',257472,'Morning ','2022-02-03','2022-02-03 00:00:00',NULL,'391',1084239.75,1084239.75,'391','2022-02-08 11:38:41','608','2022-02-08 11:39:48',10,0),('5','92',257473,'Morning ','2022-02-04','2022-02-04 00:00:00',NULL,'391',1217931.00,1217931.00,'391','2022-02-08 11:41:57','608','2022-02-08 11:42:51',10,0),('5','92',257474,'Morning ','2022-02-05','2022-02-05 00:00:00',NULL,'391',742650.15,742650.15,'391','2022-02-08 11:45:19','608','2022-02-08 11:46:15',10,0),('5','92',257475,'Morning ','2022-02-06','2022-02-06 00:00:00',NULL,'391',1725499.05,1725499.05,'391','2022-02-08 11:48:13','608','2022-02-08 11:49:51',10,0),('5','92',257476,'Morning ','2022-02-07','2022-02-07 00:00:00',NULL,'391',189075.15,189075.15,'391','2022-02-08 11:53:42','608','2022-02-08 11:54:34',10,0),('5','92',257477,'Morning ','2022-02-08','2022-02-08 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-08 21:56:16','608','2022-02-09 13:00:21',10,0),('5','92',257478,'Morning ','2022-02-09','2022-02-09 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-09 19:15:20','608','2022-02-10 20:27:48',10,0),('5','92',257479,'Morning ','2022-02-10','2022-02-10 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-10 21:53:03','608','2022-02-11 11:25:29',10,0),('5','92',257480,'Morning ','2022-02-11','2022-02-11 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-11 19:26:42','608','2022-02-12 21:26:06',10,0),('5','92',257481,'Morning ','2022-02-12','2022-02-12 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-13 12:42:21','608','2022-02-13 21:03:57',10,0),('5','92',257482,'Morning ','2022-02-13','2022-02-13 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-14 08:19:05','608','2022-02-14 22:30:38',10,0),('5','92',257483,'Morning ','2022-02-14','2022-02-14 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-15 07:04:53','608','2022-02-15 07:05:23',10,0),('5','92',257484,'Morning ','2022-02-15','2022-02-15 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-15 19:59:51','608','2022-02-16 09:52:18',10,0),('5','92',257485,'Morning 10','2022-02-16','2022-02-16 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-16 19:22:44','608','2022-02-17 17:52:53',10,0),('5','92',257486,'Morning ','2022-02-17','2022-02-17 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-17 19:23:31','608','2022-02-18 11:57:21',10,0),('5','92',257487,'Morning ','2022-02-18','2022-02-18 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-18 19:30:43','608','2022-02-19 22:51:03',10,0),('5','92',257488,'Morning ','2022-02-19','2022-02-19 00:00:00',NULL,'391',0.00,0.00,'391','2022-02-20 08:41:15','608','2022-02-20 09:20:45',10,0),('5','92',257489,'Morning ','2022-02-20','2022-02-20 00:00:00',NULL,'391',1789222.05,1789222.05,'391','2022-02-21 19:45:56','608','2022-02-21 20:30:26',10,0),('5','92',257490,'Morning ','2022-02-21','2022-02-21 00:00:00',NULL,'391',1555096.95,1555096.95,'391','2022-02-21 21:09:59','608','2022-02-22 07:23:19',10,0),('5','92',257491,'Morning ','2022-02-22','2022-02-22 14:01:04','2022-02-23 14:01:04','391',658402.80,658402.80,'391','2022-02-22 20:05:54','608','2022-02-23 10:23:13',10,0),('5','92',257492,'Morning ','2022-02-23','2022-02-25 08:35:35','2022-02-26 08:35:35','391',437769.75,437769.75,'391','2022-02-25 08:36:52','608','2022-02-25 23:21:06',10,0),('5','92',257493,'Morning ','2022-02-24','2022-02-27 01:47:10','2022-02-28 01:47:10','391',0.00,0.00,'391','2022-02-27 01:47:35','608','2022-02-27 09:49:30',10,0),('5','92',257494,'Morning ','2022-02-25','2022-02-27 09:50:33','2022-02-28 09:50:33','391',0.00,0.00,'391','2022-02-27 09:50:50','608','2022-02-27 09:51:53',10,0),('5','92',257495,'Morning ','2022-02-26','2022-02-27 09:54:07','2022-02-28 09:54:07','391',853267.80,853267.80,'391','2022-02-28 10:33:16','608','2022-03-01 07:05:34',10,0),('5','92',257496,'Morning ','2022-02-27','2022-03-01 11:40:32','2022-03-02 11:40:32','391',2158039.95,2158039.95,'391','2022-03-01 11:42:58','608','2022-03-01 11:55:45',10,0),('5','92',257497,'Morning ','2022-02-28','2022-03-01 11:58:44','2022-03-02 11:58:44','391',966741.60,966741.60,'391','2022-03-01 12:00:39','608','2022-03-01 22:09:26',10,0),('5','92',257498,'Morning ','2022-03-01','2022-03-02 08:44:42','2022-03-03 08:44:42','391',1007757.30,1007757.30,'391','2022-03-02 08:46:27','608','2022-03-02 09:42:25',10,0),('5','92',257499,'Morning ','2022-03-02','2022-03-03 18:31:38','2022-03-04 18:31:38','391',0.00,0.00,'391','2022-03-03 18:31:56','608','2022-03-03 21:28:18',10,0),('5','92',257500,'Morning ','2022-03-03','2022-03-05 13:02:39','2022-03-06 13:02:39','391',0.00,0.00,'391','2022-03-05 13:03:45','608','2022-03-08 10:18:47',10,0),('5','92',257501,'Morning ','2022-03-04','2022-03-08 12:20:59','2022-03-09 12:20:59','391',0.00,0.00,'391','2022-03-08 12:21:31','608','2022-03-08 13:41:01',10,0),('5','92',257502,'Morning ','2022-03-05','2022-03-08 13:42:40','2022-03-09 13:42:40','391',0.00,0.00,'391','2022-03-08 13:43:36','608','2022-03-08 13:46:12',10,0),('5','92',257503,'Morning ','2022-03-06','2022-03-08 13:47:22','2022-03-09 13:47:22','391',0.00,0.00,'391','2022-03-08 13:47:52','608','2022-03-08 13:49:34',10,0),('5','92',257504,'Morning ','2022-03-07','2022-03-08 13:50:12','2022-03-09 13:50:12','391',0.00,0.00,'391','2022-03-08 13:50:39','608','2022-03-08 13:51:43',10,0),('5','92',257505,'Morning ','2022-03-08','2022-03-08 13:52:15','2022-03-09 13:52:15','391',1042946.85,1042946.85,'391','2022-03-10 15:36:04','608','2022-03-10 15:37:59',10,0),('5','92',257506,'Morning ','2022-03-09','2022-03-10 15:38:51','2022-03-11 15:38:51','391',1216307.40,1216307.40,'391','2022-03-10 15:40:18','608','2022-03-10 15:43:22',10,0),('5','92',257507,'Morning ','2022-03-10','2022-03-10 15:44:18','2022-03-11 15:44:18','391',1082624.40,1082624.40,'391','2022-03-10 15:45:41','608','2022-03-12 10:26:58',10,0),('5','92',257508,'Morning ','2022-03-11','2022-03-12 21:39:37','2022-03-13 21:39:37','391',1369221.15,1369221.15,'391','2022-03-12 21:40:58','608','2022-03-12 21:42:14',10,0),('5','92',257509,'Morning ','2022-03-12','2022-03-12 21:42:39','2022-03-13 21:42:39','391',1187447.25,1187447.25,'391','2022-03-12 21:43:50','608','2022-03-12 22:36:27',10,0),('5','92',257510,'Morning ','2022-03-13','2022-03-13 21:20:44','2022-03-14 21:20:44','391',1178375.55,1178375.55,'391','2022-03-13 21:21:52','608','2022-03-13 23:25:39',10,0),('5','92',257511,'Morning ','2022-03-14','2022-03-14 16:51:02','2022-03-15 16:51:02','391',336623.10,336623.10,'391','2022-03-15 10:56:17','608','2022-03-15 10:58:59',10,0),('5','92',257512,'Morning ','2022-03-15','2022-03-15 20:33:03','2022-03-16 20:33:03','391',895733.85,895733.85,'391','2022-03-16 18:12:37','608','2022-03-16 22:27:42',10,0),('5','92',257513,'Morning ','2022-03-16','2022-03-17 19:41:50','2022-03-18 19:41:50','391',1449086.10,1449086.10,'391','2022-03-17 19:43:12','608','2022-03-17 22:06:41',10,0),('5','92',257514,'Morning ','2022-03-17','2022-03-19 07:38:40','2022-03-20 07:38:40','391',1875233.25,1875233.25,'391','2022-03-19 07:40:09','608','2022-03-19 22:50:51',10,0),('5','92',257515,'Morning ','2022-03-18','2022-03-20 21:03:27','2022-03-21 21:03:27','391',232095.60,232095.60,'391','2022-03-20 21:30:59','608','2022-03-20 21:33:12',10,0),('5','92',257516,'Morning ','2022-03-19','2022-03-20 21:34:51','2022-03-21 21:34:51','391',0.00,0.00,'391','2022-03-20 21:35:08','608','2022-03-20 21:36:02',10,0),('5','92',257517,'Morning ','2022-03-20','2022-03-20 21:36:54','2022-03-21 21:36:54','391',0.00,0.00,'391','2022-03-20 21:37:15','608','2022-03-20 21:43:23',10,0),('5','92',257518,'Morning ','2022-03-21','2022-03-22 08:06:21','2022-03-23 08:06:21','391',0.00,0.00,'391','2022-03-22 08:06:50','608','2022-03-22 15:46:21',10,0),('5','92',257519,'Morning ','2022-03-22','2022-03-23 09:55:52','2022-03-24 09:55:52','391',0.00,0.00,'391','2022-03-23 09:56:19','608','2022-03-23 13:58:37',10,0),('5','92',257520,'Morning ','2022-03-23','2022-03-24 09:25:44','2022-03-25 09:25:44','391',0.00,0.00,'391','2022-03-24 09:26:22','795','2022-03-28 12:04:04',10,0),('5','92',257521,'Morning ','2022-03-24','2022-03-29 11:25:33','2022-03-30 11:25:33','391',0.00,0.00,'391','2022-03-29 11:25:55','795','2022-03-29 11:28:03',10,0),('5','92',257522,'Morning ','2022-03-25','2022-03-29 11:28:39','2022-03-30 11:28:39','391',0.00,0.00,'391','2022-03-29 11:29:01','795','2022-03-29 11:29:20',10,0),('5','92',257523,'Morning ','2022-03-26','2022-03-29 11:32:38','2022-03-30 11:32:38','391',0.00,0.00,'391','2022-03-29 11:33:03','795','2022-03-29 11:33:43',10,0),('5','92',257524,'Morning ','2022-03-27','2022-03-29 11:34:21','2022-03-30 11:34:21','391',0.00,0.00,'391','2022-03-29 11:34:50','795','2022-03-29 11:35:13',10,0),('5','92',257525,'Morning ','2022-03-28','2022-03-29 11:37:05','2022-03-30 11:37:05','391',0.00,0.00,'391','2022-03-29 11:37:33','795','2022-03-29 11:38:17',10,0),('5','92',257526,'Morning ','2022-03-29','2022-03-29 11:38:53','2022-03-30 11:38:53','391',0.00,0.00,'391','2022-03-29 23:19:52','795','2022-03-30 14:10:48',10,0),('5','92',257527,'Morning ','2022-03-30','2022-03-31 10:59:08','2022-04-01 10:59:08','391',0.00,0.00,'391','2022-03-31 10:59:31','795','2022-03-31 11:01:47',10,0),('5','92',257528,'Morning ','2022-03-31','2022-03-31 13:39:06','2022-04-01 13:39:06','391',0.00,0.00,'391','2022-03-31 13:39:26','795','2022-04-02 16:17:17',10,0),('5','92',257529,'Morning ','2022-04-01','2022-04-04 09:13:03','2022-04-05 09:13:03','391',0.00,0.00,'391','2022-04-04 09:13:24','795','2022-04-04 09:44:19',10,0),('5','92',257530,'Morning ','2022-04-02','2022-04-04 09:44:48','2022-04-05 09:44:48','391',0.00,0.00,'391','2022-04-04 09:45:11','795','2022-04-04 09:45:57',10,0),('5','92',257531,'Morning ','2022-04-03','2022-04-04 09:46:36','2022-04-05 09:46:36','391',0.00,0.00,'391','2022-04-04 09:46:58','795','2022-04-04 12:28:12',10,0),('5','92',257532,'Morning ','2022-04-04','2022-04-06 10:05:53','2022-04-07 10:05:53','391',0.00,0.00,'391','2022-04-06 10:06:10','795','2022-04-06 16:17:07',10,0),('5','92',257533,'Morning ','2022-04-05','2022-04-08 12:54:06','2022-04-09 12:54:06','391',0.00,0.00,'391','2022-04-08 12:54:23','795','2022-04-08 12:59:43',10,0),('5','92',257534,'Morning ','2022-04-06','2022-04-08 13:06:20','2022-04-09 13:06:20','391',0.00,0.00,'391','2022-04-08 13:06:35','795','2022-04-08 13:08:56',10,0),('5','92',257535,'Morning ','2022-04-07','2022-04-08 13:10:26','2022-04-09 13:10:26','391',0.00,0.00,'391','2022-04-08 13:10:44','795','2022-04-08 13:11:57',10,0),('5','92',257536,'Morning ','2022-04-08','2022-04-08 13:12:39','2022-04-09 13:12:39','391',791201.40,791201.40,'391','2022-04-11 00:57:08','795','2022-04-11 09:06:30',10,0),('5','92',257537,'Morning ','2022-04-10','2022-04-11 09:09:13','2022-04-12 09:09:13','391',1605661.20,1605661.20,'391','2022-04-11 09:10:26','795','2022-04-11 09:19:13',10,0),('5','92',257538,'Morning ','2022-04-11','2022-04-11 09:21:42','2022-04-12 09:21:42','391',1296715.20,1296715.20,'391','2022-04-11 20:55:43','795','2022-04-12 11:25:48',10,0),('5','92',257539,'Morning ','2022-04-12','2022-04-13 08:04:21','2022-04-14 08:04:21','391',1134586.20,1134586.20,'391','2022-04-13 08:05:54','795','2022-04-13 09:49:39',10,0),('5','92',257540,'Morning ','2022-04-13','2022-04-13 18:31:31','2022-04-14 18:31:31','391',149014.80,149014.80,'391','2022-04-14 22:05:26','795','2022-04-15 11:05:07',10,0),('5','92',257541,'Morning ','2022-04-14','2022-04-17 18:17:32','2022-04-18 18:17:32','391',0.00,0.00,'391','2022-04-17 18:18:08','795','2022-04-17 18:19:25',10,0),('5','92',257542,'Morning ','2022-04-15','2022-04-17 18:19:59','2022-04-18 18:19:59','391',0.00,0.00,'391','2022-04-17 18:20:23','795','2022-04-17 18:20:59',10,0),('5','92',257543,'Morning ','2022-04-16','2022-04-17 18:23:05','2022-04-18 18:23:05','391',0.00,0.00,'391','2022-04-17 18:23:21','795','2022-04-17 18:24:13',10,0),('5','92',257544,'Morning ','2022-04-17','2022-04-17 18:25:08','2022-04-18 18:25:08','391',0.00,0.00,'391','2022-04-17 18:25:34','795','2022-04-17 19:20:35',10,0),('5','92',257545,'Morning ','2022-04-18','2022-04-18 16:37:02','2022-04-19 16:37:02','391',0.00,0.00,'391','2022-04-18 16:37:25','795','2022-04-18 17:25:03',10,0),('5','92',257546,'Morning ','2022-04-19','2022-04-19 10:18:23','2022-04-20 10:18:23','391',0.00,0.00,'391','2022-04-19 17:54:55','795','2022-04-19 20:36:35',10,0),('5','92',257547,'Morning ','2022-04-20','2022-04-20 09:49:53','2022-04-21 09:49:53','391',0.00,0.00,'391','2022-04-20 10:10:56','795','2022-04-20 13:18:46',10,0),('5','92',257548,'Morning ','2022-04-21','2022-04-21 15:17:23','2022-04-22 15:17:23','391',0.00,0.00,'391','2022-04-21 15:17:51','795','2022-04-21 23:56:48',10,0),('5','92',257549,'Morning ','2022-04-22','2022-04-22 15:43:31','2022-04-23 15:43:31','391',0.00,0.00,'391','2022-04-22 15:44:00','795','2022-04-22 21:05:13',10,0),('5','92',257550,'Morning ','2022-04-23','2022-04-23 16:38:01','2022-04-24 16:38:01','391',0.00,0.00,'391','2022-04-23 16:38:28','795','2022-04-24 14:42:00',10,0),('5','92',257551,'Morning ','2022-04-24','2022-04-24 20:21:09','2022-04-25 20:21:09','391',0.00,0.00,'391','2022-04-24 20:21:38','795','2022-04-25 12:05:22',10,0),('5','92',257552,'Morning ','2022-04-25','2022-04-25 18:14:24','2022-04-26 18:14:24','391',0.00,0.00,'391','2022-04-25 18:14:48','795','2022-04-26 09:13:52',10,0),('5','92',257553,'Morning','2022-04-26','2022-04-27 17:09:12','2022-04-28 17:09:12','391',261272.55,261272.55,'391','2022-04-27 17:10:26','795','2022-04-29 10:22:58',10,0),('5','92',257554,'Morning','2022-04-27','2022-05-09 22:06:32','2022-05-10 22:06:32','391',859793.55,859793.55,'391','2022-05-09 22:08:01','795','2022-05-10 10:00:56',10,0),('5','92',257555,'Morning','2022-04-28','2022-05-10 16:38:55','2022-05-11 16:38:55','391',1295979.30,1295979.30,'391','2022-05-10 16:40:48','795','2022-05-10 16:42:10',10,0),('5','92',257556,'Morning','2022-04-29','2022-05-10 16:42:48','2022-05-11 16:42:48','391',1573098.45,1573098.45,'391','2022-05-10 16:44:10','795','2022-05-10 16:44:45',10,0),('5','92',257557,'Morning','2022-04-30','2022-05-10 16:45:27','2022-05-11 16:45:27','391',188626.35,188626.35,'391','2022-05-10 16:46:42','795','2022-05-10 16:47:57',10,0),('5','92',257558,'Morning','2022-05-01','2022-05-10 16:49:58','2022-05-11 16:49:58','391',746968.20,746968.20,'391','2022-05-10 16:53:20','795','2022-05-10 16:54:00',10,0),('5','92',257559,'Morning','2022-05-02','2022-05-10 16:54:32','2022-05-11 16:54:32','391',0.00,0.00,'391','2022-05-10 16:54:49','795','2022-05-10 16:57:59',10,0),('5','92',257560,'Morning','2022-05-03','2022-05-10 16:58:49','2022-05-11 16:58:49','391',0.00,0.00,'391','2022-05-10 16:59:08','795','2022-05-10 16:59:28',10,0),('5','92',257561,'Morning','2022-05-04','2022-05-10 17:00:28','2022-05-11 17:00:28','391',0.00,0.00,'391','2022-05-10 17:00:52','795','2022-05-10 17:02:10',10,0),('5','92',257562,'Morning','2022-05-05','2022-05-10 17:02:51','2022-05-11 17:02:51','391',716783.10,716783.10,'391','2022-05-10 17:21:22','795','2022-05-10 17:22:12',10,0),('5','92',257563,'Morning','2022-05-06','2022-05-10 17:22:42','2022-05-11 17:22:42','391',918819.00,918819.00,'391','2022-05-10 17:23:47','795','2022-05-10 17:34:29',10,0),('5','92',257564,'Morning','2022-05-07','2022-05-10 17:36:09','2022-05-11 17:36:09','391',585022.35,585022.35,'391','2022-05-10 17:37:22','795','2022-05-10 17:38:12',10,0),('5','92',257565,'Morning','2022-05-08','2022-05-10 17:39:06','2022-05-11 17:39:06','391',346264.05,346264.05,'391','2022-05-10 17:40:03','795','2022-05-10 17:40:45',10,0),('5','92',257566,'Morning','2022-05-09','2022-05-10 17:41:15','2022-05-11 17:41:15','391',0.00,0.00,'391','2022-05-10 17:41:34','795','2022-05-10 17:42:21',10,0),('5','92',257567,'Morning','2022-05-10','2022-05-10 17:42:42','2022-05-11 17:42:42','391',0.00,0.00,'391','2022-05-10 17:43:01','795','2022-05-10 17:43:58',10,0),('5','92',257568,'Morning','2022-05-11','2022-05-11 15:33:52','2022-05-12 15:33:52','391',0.00,0.00,'391','2022-05-11 15:34:12','795','2022-05-12 11:24:21',10,0),('5','92',257569,'Morning','2022-05-12','2022-05-12 21:20:28','2022-05-13 21:20:28','391',0.00,0.00,'391','2022-05-12 21:20:48','795','2022-05-13 10:59:43',10,0),('5','92',257570,'Morning','2022-05-13','2022-05-13 16:04:29','2022-05-14 16:04:29','391',0.00,0.00,'391','2022-05-13 16:04:45','795','2022-05-14 15:32:30',10,0),('5','92',257571,'Morning','2022-05-14','2022-05-14 18:45:54','2022-05-15 18:45:54','391',0.00,0.00,'391','2022-05-14 18:46:09','795','2022-05-15 13:51:46',10,0),('5','92',257572,'Morning','2022-05-15','2022-05-16 08:33:02','2022-05-17 08:33:02','391',256035.45,256035.45,'391','2022-05-16 17:05:30','795','2022-05-16 18:22:55',10,0),('5','92',257573,'Morning','2022-05-16','2022-05-16 21:26:39','2022-05-17 21:26:39','391',1035992.10,1035992.10,'391','2022-05-16 21:27:56','795','2022-05-17 09:29:27',10,0),('5','92',257574,'Morning','2022-05-17','2022-05-18 08:52:51','2022-05-19 08:52:51','391',1426713.75,1426713.75,'391','2022-05-18 08:54:02','795','2022-05-18 11:39:48',10,0),('5','92',257575,'Morning','2022-05-18','2022-05-18 12:25:22','2022-05-19 12:25:22','391',1643639.25,1643639.25,'391','2022-05-18 22:35:56','795','2022-05-19 09:59:06',10,0),('5','92',257576,'Morning','2022-05-19','2022-05-19 10:04:11','2022-05-20 10:04:11','391',592475.40,592475.40,'391','2022-05-19 21:07:23','795','2022-05-20 10:08:37',10,0),('5','92',257577,'Morning','2022-05-20','2022-05-21 09:58:29','2022-05-22 09:58:29','391',0.00,0.00,'391','2022-05-21 09:59:41','795','2022-05-23 13:07:01',10,0),('5','92',257578,'Morning','2022-05-21','2022-05-23 13:09:44','2022-05-24 13:09:44','391',0.00,0.00,'391','2022-05-23 13:10:15','795','2022-05-23 13:10:50',10,0),('5','92',257579,'Morning','2022-05-22','2022-05-23 13:15:34','2022-05-24 13:15:34','391',0.00,0.00,'391','2022-05-23 13:15:49','795','2022-05-23 13:17:21',10,0),('5','92',257580,'Morning','2022-05-23','2022-05-23 13:18:43','2022-05-24 13:18:43','391',950642.55,950642.55,'391','2022-05-23 21:33:56','795','2022-05-23 21:51:28',10,0),('5','92',257581,'Morning','2022-05-24','2022-05-24 08:37:54','2022-05-25 08:37:54','391',1707103.20,1707103.20,'391','2022-05-24 21:02:20','795','2022-05-25 09:28:07',10,0),('5','92',257582,'Morning','2022-05-25','2022-05-25 09:49:02','2022-05-26 09:49:02','391',1061052.30,1061052.30,'391','2022-05-25 20:48:01','795','2022-05-26 10:34:21',10,0),('5','92',257583,'Morning','2022-05-26','2022-05-26 11:18:06','2022-05-27 11:18:06','391',724524.90,724524.90,'391','2022-05-26 22:03:52','795','2022-05-26 23:16:06',10,0),('5','92',257584,'Morning','2022-05-27','2022-05-27 11:05:21','2022-05-28 11:05:21','391',327442.50,327442.50,'391','2022-05-27 22:09:13','795','2022-05-28 22:36:33',10,0),('5','92',257585,'Morning ','2022-05-28','2022-05-30 07:04:37','2022-05-31 07:04:37','391',190213.65,190213.65,'391','2022-05-30 07:05:16','795','2022-05-30 11:09:10',10,0),('5','92',257586,'Morning ','2022-05-29','2022-05-30 12:06:24','2022-05-31 12:06:24','391',0.00,0.00,'391','2022-05-30 12:07:07','795','2022-05-30 12:27:58',10,0),('5','92',257587,'Morning ','2022-05-30','2022-05-30 20:37:30','2022-05-31 20:37:30','391',0.00,0.00,'391','2022-05-30 20:38:03','795','2022-05-31 09:44:51',10,0),('5','92',257588,'Morning ','2022-05-31','2022-05-31 11:50:06','2022-06-01 11:50:06','391',0.00,0.00,'391','2022-05-31 18:40:45','795','2022-06-02 10:19:03',10,0),('5','92',257589,'Morning ','2022-06-01','2022-06-02 21:06:20','2022-06-03 21:06:20','391',0.00,0.00,'391','2022-06-02 21:06:40','795','2022-06-03 10:00:16',10,0),('5','92',257590,'Morning ','2022-06-02','2022-06-03 13:54:37','2022-06-04 13:54:37','391',0.00,0.00,'391','2022-06-03 13:54:58','795','2022-06-03 16:12:14',10,0),('5','92',257591,'Morning ','2022-06-03','2022-06-04 13:05:10','2022-06-05 13:05:10','391',0.00,0.00,'391','2022-06-04 13:05:25','795','2022-06-04 15:15:47',10,0),('5','92',257592,'Morning ','2022-06-04','2022-06-04 15:20:07','2022-06-05 15:20:07','391',0.00,0.00,'391','2022-06-04 15:20:23','795','2022-06-04 15:21:40',10,0),('5','92',257593,'Morning ','2022-06-05','2022-06-05 21:41:01','2022-06-06 21:41:01','391',0.00,0.00,'391','2022-06-05 21:41:15','795','2022-06-05 22:06:54',10,0),('5','92',257594,'Morning ','2022-06-06','2022-06-06 09:32:15','2022-06-07 09:32:15','391',0.00,0.00,'391','2022-06-06 19:47:37','795','2022-06-07 09:09:05',10,0),('5','92',257595,'Morning ','2022-06-07','2022-06-07 09:24:29','2022-06-08 09:24:29','391',0.00,0.00,'391','2022-06-07 20:19:44','795','2022-06-08 09:45:24',10,0),('5','92',257596,'Morning ','2022-06-08','2022-06-08 11:01:19','2022-06-09 11:01:19','391',0.00,0.00,'391','2022-06-08 19:19:12','795','2022-06-09 19:35:52',10,0),('5','92',257597,'Morning ','2022-06-09','2022-06-09 21:54:40','2022-06-10 21:54:40','391',0.00,0.00,'391','2022-06-09 21:55:00','795','2022-06-10 09:24:03',10,0),('5','92',257598,'Morning ','2022-06-10','2022-06-10 11:43:55','2022-06-11 11:43:55','391',0.00,0.00,'391','2022-06-10 21:47:28','795','2022-06-11 18:03:45',10,0),('5','92',257599,'Morning ','2022-06-11','2022-06-11 20:49:03','2022-06-12 20:49:03','391',0.00,0.00,'391','2022-06-11 20:49:59','795','2022-06-12 16:21:14',10,0),('5','92',257600,'Morning ','2022-06-12','2022-06-12 18:01:53','2022-06-13 18:01:53','391',0.00,0.00,'391','2022-06-12 18:02:14','795','2022-06-13 13:03:20',10,0),('5','92',257601,'Morning ','2022-06-13','2022-06-13 21:43:01','2022-06-14 21:43:01','391',0.00,0.00,'391','2022-06-13 21:43:16','795','2022-06-13 22:05:00',10,0),('5','92',257602,'Morning ','2022-06-14','2022-06-14 09:04:32','2022-06-15 09:04:32','391',0.00,0.00,'391','2022-06-14 17:12:08','795','2022-06-15 09:30:32',10,0),('5','92',257603,'Morning ','2022-06-15','2022-06-15 14:29:04','2022-06-16 14:29:04','391',0.00,0.00,'391','2022-06-15 14:29:19','795','2022-06-15 21:29:58',10,0),('5','92',257604,'Morning ','2022-06-16','2022-06-16 09:47:54','2022-06-17 09:47:54','391',0.00,0.00,'391','2022-06-16 20:53:10','795','2022-06-17 13:17:52',10,0),('5','92',257605,'Morning ','2022-06-17','2022-06-17 15:42:38','2022-06-18 15:42:38','391',0.00,0.00,'391','2022-06-17 15:42:55','795','2022-06-17 19:36:48',10,0),('5','92',257606,'Morning ','2022-06-18','2022-06-18 18:02:02','2022-06-19 18:02:02','391',0.00,0.00,'391','2022-06-18 18:02:16','795','2022-06-18 19:25:14',10,0),('5','92',257607,'Morning ','2022-06-19','2022-06-19 14:46:18','2022-06-20 14:46:18','391',752891.70,752891.70,'391','2022-06-20 15:29:16','795','2022-06-21 08:50:56',10,0),('5','92',257608,'Morning ','2022-06-20','2022-06-21 12:14:48','2022-06-22 12:14:48','391',739384.80,739384.80,'391','2022-06-21 12:16:27','795','2022-06-21 15:07:50',10,0),('5','92',257609,'Morning ','2022-06-21','2022-06-21 21:53:48','2022-06-22 21:53:48','391',264000.00,264000.00,'391','2022-06-21 21:54:23','795','2022-06-22 12:30:05',10,0),('5','92',257610,'Morning ','2022-06-22','2022-06-22 12:37:17','2022-06-23 12:37:17','391',408074.70,408074.70,'391','2022-06-22 20:26:37','795','2022-06-23 09:45:46',10,0),('5','92',257611,'Morning ','2022-06-23','2022-06-23 10:12:43','2022-06-24 10:12:43','391',269116.65,269116.65,'391','2022-06-23 22:26:48','795','2022-06-24 10:10:30',10,0),('5','92',257612,'Morning ','2022-06-24','2022-06-24 10:38:42','2022-06-25 10:38:42','391',0.00,0.00,'391','2022-06-25 22:32:40','795','2022-06-26 19:27:54',10,0),('5','92',257613,'Morning ','2022-06-25','2022-06-26 19:30:44','2022-06-27 19:30:44','391',0.00,0.00,'391','2022-06-26 19:30:59','795','2022-06-27 09:28:46',10,0),('5','92',257614,'Morning ','2022-06-26','2022-06-27 09:31:40','2022-06-28 09:31:40','391',0.00,0.00,'391','2022-06-27 09:31:59','795','2022-06-27 09:38:35',10,0),('5','92',257615,'Morning ','2022-06-27','2022-06-28 09:32:19','2022-06-29 09:32:19','391',0.00,0.00,'391','2022-06-28 09:32:52','795','2022-06-28 10:29:57',10,0),('5','92',257616,'Morning ','2022-06-28','2022-06-28 15:44:41','2022-06-29 15:44:41','391',0.00,0.00,'391','2022-06-28 15:44:58','795','2022-06-29 09:30:34',10,0),('5','92',257617,'Morning ','2022-06-29','2022-06-29 12:39:27','2022-06-30 12:39:27','391',0.00,0.00,'391','2022-06-29 12:39:42','795','2022-06-30 11:54:13',10,0),('5','92',257618,'Morning ','2022-06-30','2022-06-30 16:41:54','2022-07-01 16:41:54','391',0.00,0.00,'391','2022-06-30 16:42:09','795','2022-07-02 20:16:10',10,0),('5','92',257619,'Morning ','2022-07-01','2022-07-02 20:18:41','2022-07-03 20:18:41','391',0.00,0.00,'391','2022-07-02 20:18:55','795','2022-07-02 20:20:02',10,0),('5','92',257620,'Morning ','2022-07-02','2022-07-02 20:20:23','2022-07-03 20:20:23','391',0.00,0.00,'391','2022-07-02 20:20:41','795','2022-07-02 20:21:27',10,0),('5','92',257621,'Morning ','2022-07-03','2022-07-03 19:19:24','2022-07-04 19:19:24','391',0.00,0.00,'391','2022-07-03 19:19:39','795','2022-07-03 21:38:01',10,0),('5','92',257622,'Morning ','2022-07-04','2022-07-04 09:41:39','2022-07-05 09:41:39','391',0.00,0.00,'391','2022-07-04 09:41:54','795','2022-07-04 13:17:57',10,0),('5','92',257623,'Morning ','2022-07-05','2022-07-05 08:05:20','2022-07-06 08:05:20','391',0.00,0.00,'391','2022-07-05 08:05:47','795','2022-07-05 10:24:21',10,0),('5','92',257624,'Morning ','2022-07-06','2022-07-06 08:25:54','2022-07-07 08:25:54','391',0.00,0.00,'391','2022-07-07 08:33:58','795','2022-07-07 09:34:14',10,0),('5','92',257625,'Morning ','2022-07-07','2022-07-07 12:36:06','2022-07-08 12:36:06','391',341182.05,341182.05,'391','2022-07-08 13:44:06','795','2022-07-09 18:59:57',10,0),('5','92',257626,'Morning ','2022-07-08','2022-07-10 21:28:57','2022-07-11 21:28:57','391',710148.45,710148.45,'391','2022-07-10 21:30:13','795','2022-07-10 21:32:07',10,0),('5','92',257627,'Morning ','2022-07-09','2022-07-10 21:33:50','2022-07-11 21:33:50','391',732560.40,732560.40,'391','2022-07-10 21:35:12','795','2022-07-10 21:38:49',10,0),('5','92',257628,'Morning ','2022-07-10','2022-07-10 21:42:09','2022-07-11 21:42:09','391',912314.70,1022898.30,'391','2022-07-10 21:43:41','795','2022-07-11 11:03:23',10,0),('5','92',257629,'Morning ','2022-07-11','2022-07-11 22:38:19','2022-07-12 22:38:19','391',739384.80,829007.20,'391','2022-07-11 22:39:22','795','2022-07-12 16:16:27',10,0),('5','92',257630,'Morning ','2022-07-12','2022-07-12 17:57:21','2022-07-13 17:57:21','391',563991.45,632354.05,'391','2022-07-12 17:58:15','795','2022-07-12 18:29:54',10,0),('5','92',257631,'Morning ','2022-07-13','2022-07-13 21:34:28','2022-07-14 21:34:28','391',559015.05,626774.45,'391','2022-07-13 21:35:26','795','2022-07-14 08:40:31',10,0),('5','92',257632,'Morning ','2022-07-14','2022-07-14 21:15:34','2022-07-15 21:15:34','391',408168.75,457643.75,'391','2022-07-17 14:19:12','795','2022-07-17 14:25:18',10,0),('5','92',257633,'Morning ','2022-07-15','2022-07-17 14:26:33','2022-07-18 14:26:33','391',978059.85,872323.65,'391','2022-07-17 14:27:54','795','2022-07-17 14:28:48',10,0),('5','92',257634,'Morning ','2022-07-16','2022-07-17 14:29:22','2022-07-18 14:29:22','391',1455015.75,1297716.75,'391','2022-07-17 14:30:43','795','2022-07-17 14:32:27',10,0),('5','92',257635,'Morning ','2022-07-17','2022-07-17 14:32:53','2022-07-18 14:32:53','391',852217.30,852217.30,'391','2022-07-17 14:34:01','795','2022-07-18 11:30:07',10,0),('5','92',257636,'Morning ','2022-07-18','2022-07-18 11:52:05','2022-07-19 11:52:05','391',845320.50,845320.50,'391','2022-07-18 23:55:21','795','2022-07-19 06:53:01',10,0),('5','92',257637,'Morning ','2022-07-19','2022-07-19 06:53:34','2022-07-20 06:53:34','391',2103183.60,2103183.60,'391','2022-07-20 09:37:31','795','2022-07-20 09:41:36',10,0),('5','92',257638,'Morning ','2022-07-20','2022-07-20 09:57:22','2022-07-21 09:57:22','391',1555428.20,1555428.20,'391','2022-07-20 19:11:29','795','2022-07-20 19:12:06',10,0),('5','92',257639,'Morning ','2022-07-21','2022-07-21 07:36:02','2022-07-22 07:36:02','391',1692798.10,1692798.10,'391','2022-07-21 20:05:20','795','2022-07-22 16:10:50',10,0),('5','92',257640,'Morning ','2022-07-22','2022-07-23 08:19:10','2022-07-24 08:19:10','391',1191844.00,1191844.00,'391','2022-07-23 08:21:21','795','2022-07-23 12:47:10',10,0),('5','92',257641,'Morning ','2022-07-23','2022-07-23 21:34:47','2022-07-24 21:34:47','391',1034956.60,1034956.60,'391','2022-07-25 06:55:50','795','2022-07-25 09:21:10',10,0),('5','92',257642,'Morning ','2022-07-24','2022-07-25 09:27:10','2022-07-26 09:27:10','391',849716.10,849716.10,'391','2022-07-25 09:28:05','795','2022-07-25 09:29:21',10,0),('5','92',257643,'Morning ','2022-07-25','2022-07-25 09:31:48','2022-07-26 09:31:48','391',1500020.70,1500020.70,'391','2022-07-25 20:41:46','795','2022-07-26 10:48:51',10,0),('5','92',257644,'Morning ','2022-07-26','2022-07-26 20:23:43','2022-07-27 20:23:43','391',997114.85,997114.85,'391','2022-07-26 20:24:49','795','2022-07-26 21:03:18',10,0),('5','92',257645,'Morning ','2022-07-27','2022-07-27 09:33:41','2022-07-28 09:33:41','391',2210133.95,2210133.95,'391','2022-07-27 21:13:05','795','2022-07-28 10:41:17',10,0),('5','92',257646,'Morning ','2022-07-28','2022-07-28 11:00:50','2022-07-29 11:00:50','391',52101.55,52101.55,'391','2022-07-31 07:44:12','795','2022-07-31 13:14:57',10,0),('5','92',257647,'Morning ','2022-07-29','2022-08-01 09:25:19','2022-08-02 09:25:19','391',0.00,0.00,'391','2022-08-01 09:25:50','795','2022-08-01 09:27:26',10,0),('5','92',257648,'Morning ','2022-07-30','2022-08-01 09:28:45','2022-08-02 09:28:45','391',0.00,0.00,'391','2022-08-01 09:29:10','795','2022-08-01 09:31:36',10,0),('5','92',257649,'Morning ','2022-07-31','2022-08-01 09:32:18','2022-08-02 09:32:18','391',0.00,0.00,'391','2022-08-01 09:32:43','795','2022-08-01 09:34:32',10,0),('5','92',257650,'Morning ','2022-08-01','2022-08-01 09:36:02','2022-08-02 09:36:02','391',0.00,0.00,'391','2022-08-01 09:36:54','795','2022-08-01 09:44:06',10,0),('5','92',257651,'Morning ','2022-08-02','2022-08-02 15:04:44','2022-08-03 15:04:44','391',921875.35,921875.35,'391','2022-08-02 15:26:56','795','2022-08-02 21:26:44',10,0),('5','92',257652,'Morning ','2022-08-03','2022-08-03 10:10:36','2022-08-04 10:10:36','391',1028538.95,1028538.95,'391','2022-08-03 18:24:06','795','2022-08-04 10:50:15',10,0),('5','92',257653,'Morning ','2022-08-04','2022-08-04 10:51:37','2022-08-05 10:51:37','391',1139448.30,1139448.30,'391','2022-08-04 20:11:52','795','2022-08-05 10:35:04',10,0),('5','92',257654,'Morning ','2022-08-05','2022-08-05 11:10:15','2022-08-06 11:10:15','391',1933566.35,1933566.35,'391','2022-08-05 19:55:38','795','2022-08-06 14:45:25',10,0),('5','92',257655,'Morning ','2022-08-06','2022-08-07 09:35:16','2022-08-08 09:35:16','391',583884.05,583884.05,'391','2022-08-07 09:36:21','795','2022-08-07 21:33:57',10,0),('5','92',257656,'Morning ','2022-08-07','2022-08-07 22:09:16','2022-08-08 22:09:16','391',0.00,0.00,'391','2022-08-07 22:09:43','795','2022-08-07 22:23:07',10,0),('5','92',257657,'Morning ','2022-08-08','2022-09-05 14:50:27','2022-09-06 14:50:27','391',0.00,0.00,'391','2022-09-05 14:51:03','795','2022-09-05 14:53:18',10,0),('5','92',257658,'Morning ','2022-08-09','2022-09-05 14:54:07','2022-09-06 14:54:07','391',0.00,0.00,'391','2022-09-05 14:54:28','795','2022-09-05 14:55:25',10,0),('5','92',257659,'Morning ','2022-08-10','2022-09-05 14:57:39','2022-09-06 14:57:39','391',237623.25,237623.25,'391','2022-09-05 14:59:06','795','2022-09-05 14:59:42',10,0),('5','92',257660,'Morning ','2022-08-11','2022-09-05 15:01:07','2022-09-06 15:01:07','391',719563.05,719563.05,'391','2022-09-05 15:02:16','795','2022-09-05 15:02:46',10,0),('5','92',257661,'Morning ','2022-08-12','2022-09-05 15:04:04','2022-09-06 15:04:04','391',928341.10,928341.10,'391','2022-09-05 15:05:11','795','2022-09-05 15:06:18',10,0),('5','92',257662,'Morning ','2022-08-13','2022-09-05 15:07:12','2022-09-06 15:07:12','391',710960.55,710960.55,'391','2022-09-05 15:08:10','795','2022-09-05 15:08:47',10,0),('5','92',257663,'Morning ','2022-08-14','2022-09-05 15:10:55','2022-09-06 15:10:55','391',993631.30,993631.30,'391','2022-09-05 15:12:00','795','2022-09-05 15:13:45',10,0),('5','92',257664,'Morning ','2022-08-15','2022-09-05 15:15:58','2022-09-06 15:15:58','391',825814.10,825814.10,'391','2022-09-05 15:16:49','795','2022-09-05 15:18:41',10,0),('5','92',257665,'Morning ','2022-08-16','2022-09-05 15:19:25','2022-09-06 15:19:25','391',745648.05,745648.05,'391','2022-09-05 15:20:26','795','2022-09-05 15:20:37',10,0),('5','92',257666,'Morning ','2022-08-17','2022-09-05 15:30:08','2022-09-06 15:30:08','391',441343.40,441343.40,'391','2022-09-05 15:31:02','795','2022-09-05 15:32:08',10,0),('5','92',257667,'Morning ','2022-08-18','2022-09-05 15:33:45','2022-09-06 15:33:45','391',867777.65,867777.65,'391','2022-09-05 15:34:34','795','2022-09-05 15:34:45',10,0),('5','92',257668,'Morning ','2022-08-19','2022-09-05 15:35:46','2022-09-06 15:35:46','391',906128.15,906128.15,'391','2022-09-05 15:36:39','795','2022-09-05 15:37:14',10,0),('5','92',257669,'Morning ','2022-08-20','2022-09-05 15:40:16','2022-09-06 15:40:16','391',373811.00,373811.00,'391','2022-09-05 15:42:25','795','2022-09-05 15:43:09',10,0),('5','92',257670,'Morning ','2022-08-21','2022-09-05 15:44:11','2022-09-06 15:44:11','391',1083837.30,1083837.30,'391','2022-09-05 15:45:37','795','2022-09-05 15:46:12',10,0),('5','92',257671,'Morning ','2022-08-22','2022-09-05 15:46:50','2022-09-06 15:46:50','391',885467.35,885467.35,'391','2022-09-06 11:50:39','795','2022-09-06 11:53:50',10,0),('5','92',257672,'Morning ','2022-08-23','2022-09-06 11:54:39','2022-09-07 11:54:39','391',670504.75,670504.75,'391','2022-09-06 11:55:49','795','2022-09-06 11:58:26',10,0),('5','92',257673,'Morning ','2022-08-24','2022-09-06 11:59:23','2022-09-07 11:59:23','391',727699.35,727699.35,'391','2022-09-06 12:00:26','795','2022-09-06 12:01:13',10,0),('5','92',257674,'Morning ','2022-08-25','2022-09-06 12:03:30','2022-09-07 12:03:30','391',925358.90,925358.90,'391','2022-09-06 12:04:29','795','2022-09-06 12:06:33',10,0),('5','92',257675,'Morning ','2022-08-26','2022-09-06 12:07:49','2022-09-07 12:07:49','391',643457.75,643457.75,'391','2022-09-06 12:08:48','795','2022-09-06 12:09:47',10,0),('5','92',257676,'Morning ','2022-08-27','2022-09-06 12:10:57','2022-09-07 12:10:57','391',447674.10,447674.10,'391','2022-09-06 12:11:58','795','2022-09-06 12:13:38',10,0),('5','92',257677,'Morning ','2022-08-28','2022-09-06 12:14:38','2022-09-07 12:14:38','391',840941.55,840941.55,'391','2022-09-06 12:15:50','795','2022-09-06 12:16:37',10,0),('5','92',257678,'Morning ','2022-08-29','2022-09-06 12:17:50','2022-09-07 12:17:50','391',462853.35,462853.35,'391','2022-09-06 12:18:35','795','2022-09-06 12:19:44',10,0),('5','92',257679,'Morning ','2022-08-30','2022-09-06 12:20:40','2022-09-07 12:20:40','391',1004481.55,1004481.55,'391','2022-09-06 12:21:50','795','2022-09-06 12:22:53',10,0),('5','92',257680,'Morning ','2022-08-31','2022-09-06 12:25:52','2022-09-07 12:25:52','391',621583.35,621583.35,'391','2022-09-06 12:28:03','795','2022-09-06 12:32:28',10,0),('5','92',257681,'Morning ','2022-09-01','2022-09-06 13:08:19','2022-09-07 13:08:19','391',1056849.50,1056849.50,'391','2022-09-06 13:09:17','795','2022-09-06 13:15:48',10,0),('5','92',257682,'Morning ','2022-09-02','2022-09-06 13:59:42','2022-09-07 13:59:42','391',778222.85,778222.85,'391','2022-09-06 14:00:40','795','2022-09-06 14:02:55',10,0),('5','92',257683,'Morning ','2022-09-03','2022-09-06 14:05:59','2022-09-07 14:05:59','391',29672.15,29672.15,'391','2022-09-06 14:06:59','795','2022-09-06 14:13:01',10,0),('5','92',257684,'Morning ','2022-09-04','2022-09-06 14:58:20','2022-09-07 14:58:20','391',0.00,0.00,'391','2022-09-06 14:58:47','795','2022-09-06 15:00:13',10,0),('5','92',257685,'Morning ','2022-09-05','2022-09-06 15:01:29','2022-09-07 15:01:29','391',526352.75,526352.75,'391','2022-09-06 15:02:24','795','2022-09-06 15:03:03',10,0),('5','92',257686,'Morning ','2022-09-06','2022-09-06 22:49:17','2022-09-07 22:49:17','391',1007128.90,1007128.90,'391','2022-09-06 22:50:24','795','2022-09-07 10:03:40',10,0),('5','92',257687,'Morning ','2022-09-07','2022-09-08 06:38:59','2022-09-09 06:38:59','391',654413.45,654413.45,'391','2022-09-08 06:39:59','795','2022-09-08 10:04:07',10,0),('5','92',257688,'Morning ','2022-09-08','2022-09-09 13:44:59','2022-09-10 13:44:59','391',1095655.10,1095655.10,'391','2022-09-10 09:04:05','795','2022-09-10 12:19:10',10,0),('5','92',257689,'Morning ','2022-09-09','2022-09-11 07:28:53','2022-09-12 07:28:53','391',576619.10,576619.10,'391','2022-09-11 07:30:17','795','2022-09-11 16:59:01',10,0),('5','92',257690,'Morning ','2022-09-10','2022-09-11 18:56:23','2022-09-12 18:56:23','391',0.00,0.00,'391','2022-09-11 18:56:43','795','2022-09-11 21:58:41',10,0),('5','92',257691,'Morning ','2022-09-11','2022-09-12 09:26:30','2022-09-13 09:26:30','391',0.00,0.00,'391','2022-09-12 09:26:57','795','2022-09-12 09:38:16',10,0),('5','92',257692,'Morning ','2022-09-12','2022-09-12 19:30:00','2022-09-13 19:30:00','391',0.00,0.00,'391','2022-09-12 19:30:24','795','2022-09-13 13:23:27',10,0),('5','92',257693,'Morning ','2022-09-13','2022-09-13 20:53:41','2022-09-14 20:53:41','391',0.00,0.00,'391','2022-09-13 20:54:00','795','2022-09-14 10:10:38',10,0),('5','92',257694,'Morning ','2022-09-14','2022-09-14 10:41:19','2022-09-15 10:41:19','391',0.00,0.00,'391','2022-09-14 10:41:40','795','2022-09-14 15:17:38',10,0),('5','92',257695,'Morning ','2022-09-15','2022-09-15 09:21:57','2022-09-16 09:21:57','391',404535.80,404535.80,'391','2022-09-16 09:38:44','795','2022-09-16 09:39:59',10,0),('5','92',257696,'Morning ','2022-09-17','2022-09-17 07:56:46','2022-09-18 07:56:46','391',0.00,0.00,'391','2022-09-17 15:26:20','795','2022-09-17 15:30:41',10,0),('5','92',257697,'Morning ','2022-09-16','2022-09-17 17:30:09','2022-09-18 17:30:09','391',784842.15,784842.15,'391','2022-09-17 17:31:15','795','2022-09-18 11:25:53',10,0),('5','92',257698,'Morning ','2022-09-17','2022-09-18 20:13:43','2022-09-19 20:13:43','391',916488.15,916488.15,'391','2022-09-18 20:15:02','795','2022-09-19 09:31:48',10,0),('5','92',257699,'Morning ','2022-09-18','2022-09-19 09:33:29','2022-09-20 09:33:29','391',687435.95,687435.95,'391','2022-09-19 09:35:36','795','2022-09-20 12:14:00',10,0),('5','92',257700,'Morning ','2022-09-19','2022-09-20 12:52:15','2022-09-21 12:52:15','391',0.00,0.00,'391','2022-09-20 12:52:31','795','2022-09-20 15:26:44',10,0),('5','92',257701,'Morning ','2022-09-20','2022-09-21 10:51:24','2022-09-22 10:51:24','391',400996.75,400996.75,'391','2022-09-21 10:52:35','795','2022-09-22 14:04:44',10,0),('5','92',257702,'Morning ','2022-09-21','2022-09-22 22:40:33','2022-09-23 22:40:33','391',498922.80,498922.80,'391','2022-09-22 22:42:09','795','2022-09-23 22:50:04',10,0),('5','92',257703,'Morning ','2022-09-22','2022-09-25 07:15:12','2022-09-26 07:15:12','391',1083578.30,1083578.30,'391','2022-09-25 07:16:17','795','2022-09-25 11:17:51',10,0),('5','92',257704,'Morning ','2022-09-23','2022-09-25 11:20:40','2022-09-26 11:20:40','391',710176.15,710176.15,'391','2022-09-25 11:22:03','795','2022-09-25 11:26:10',10,0),('5','92',257705,'Morning ','2022-09-24','2022-09-25 11:26:41','2022-09-26 11:26:41','391',916736.05,916736.05,'391','2022-09-25 11:27:53','795','2022-09-26 09:31:24',10,0),('5','92',257706,'Morning ','2022-09-25','2022-09-26 10:24:22','2022-09-27 10:24:22','391',1108253.60,1108253.60,'391','2022-09-26 10:25:38','795','2022-09-27 14:40:25',10,0),('5','92',257707,'Morning ','2022-09-26','2022-09-27 15:58:58','2022-09-28 15:58:58','391',752391.30,752391.30,'391','2022-09-27 15:59:58','795','2022-09-28 10:03:24',10,0),('5','92',257708,'Morning ','2022-09-27','2022-09-28 10:14:27','2022-09-29 10:14:27','391',0.00,0.00,'391','2022-09-28 10:14:46','795','2022-09-28 10:53:38',10,0),('5','92',257709,'Morning ','2022-09-28','2022-09-29 07:21:03','2022-09-30 07:21:03','391',0.00,0.00,'391','2022-09-29 07:21:23','795','2022-09-29 15:42:28',10,0),('5','92',257710,'Morning ','2022-09-29','2022-09-29 19:51:02','2022-09-30 19:51:02','391',0.00,0.00,'391','2022-09-29 19:51:21','795','2022-09-30 09:24:12',10,0),('5','92',257711,'Morning ','2022-09-30','2022-10-01 09:52:18','2022-10-02 09:52:18','391',393485.75,393485.75,'391','2022-10-02 07:50:02','795','2022-10-03 00:27:34',10,0),('5','92',257712,'Morning ','2022-10-01','2022-10-03 12:01:48','2022-10-04 12:01:48','391',834620.10,834620.10,'391','2022-10-03 12:03:16','795','2022-10-03 12:04:22',10,0),('5','92',257713,'Morning ','2022-10-02','2022-10-03 12:05:27','2022-10-04 12:05:27','391',843474.20,843474.20,'391','2022-10-03 12:06:32','795','2022-10-03 12:16:27',10,0),('5','92',257714,'Morning ','2022-10-03','2022-10-03 21:01:59','2022-10-04 21:01:59','391',1042811.70,1042811.70,'391','2022-10-03 21:03:04','795','2022-10-04 09:31:08',10,0),('5','92',257715,'Morning ','2022-10-04','2022-10-04 23:27:31','2022-10-05 23:27:31','391',907328.80,907328.80,'391','2022-10-04 23:29:00','795','2022-10-05 10:04:19',10,0),('5','92',257716,'Morning ','2022-10-05','2022-10-06 06:52:19','2022-10-07 06:52:19','391',1166528.60,1166528.60,'391','2022-10-06 06:53:22','795','2022-10-06 09:41:40',10,0),('5','92',257717,'Morning ','2022-10-06','2022-10-07 06:37:07','2022-10-08 06:37:07','391',1427667.20,1427667.20,'391','2022-10-07 06:38:04','795','2022-10-07 10:07:40',10,0),('5','92',257718,'Morning ','2022-10-07','2022-10-09 12:50:09','2022-10-10 12:50:09','391',1766380.00,1766380.00,'391','2022-10-09 15:31:59','795','2022-10-09 18:45:20',10,0),('5','92',257719,'Morning ','2022-10-08','2022-10-10 09:46:24','2022-10-11 09:46:24','391',0.00,0.00,'391','2022-10-10 09:46:41','795','2022-10-10 10:15:10',10,0),('5','92',257720,'Morning ','2022-10-08','2022-10-11 10:39:51','2022-10-12 10:39:51','391',0.00,0.00,'391','2022-10-11 10:40:34','795','2022-10-11 11:28:25',10,0),('5','92',257721,'Morning ','2022-10-10','2022-10-12 09:12:54','2022-10-13 09:12:54','391',0.00,0.00,'391','2022-10-12 09:13:13','795','2022-10-12 15:14:01',10,0),('5','92',257722,'Morning ','2022-10-11','2022-10-13 07:36:34','2022-10-14 07:36:34','391',0.00,0.00,'391','2022-10-13 07:36:55','795','2022-10-13 13:45:39',10,0),('5','92',257723,'Morning ','2022-10-12','2022-10-14 15:35:01','2022-10-15 15:35:01','391',0.00,0.00,'391','2022-10-14 15:35:32','795','2022-10-14 16:48:59',10,0),('5','92',257724,'Morning ','2022-10-13','2022-10-16 19:50:43','2022-10-17 19:50:43','391',0.00,0.00,'391','2022-10-16 19:51:01','795','2022-10-17 14:54:59',10,0),('5','92',257725,'Morning ','2022-10-14','2022-10-17 14:57:37','2022-10-18 14:57:37','391',0.00,0.00,'391','2022-10-17 14:57:55','795','2022-10-17 14:59:52',10,0),('5','92',257726,'Morning ','2022-10-15','2022-10-17 15:03:13','2022-10-18 15:03:13','391',0.00,0.00,'391','2022-10-17 15:03:31','795','2022-10-17 15:04:28',10,0),('5','92',257727,'Morning ','2022-10-16','2022-10-17 15:05:35','2022-10-18 15:05:35','391',0.00,0.00,'391','2022-10-17 15:05:51','795','2022-10-17 15:06:26',10,0),('5','92',257728,'Morning ','2022-10-17','2022-10-17 15:11:59','2022-10-18 15:11:59','391',0.00,0.00,'391','2022-10-17 15:12:19','795','2022-10-18 15:28:29',10,0),('5','92',257729,'Morning ','2022-10-18','2022-10-18 15:42:55','2022-10-19 15:42:55','391',0.00,0.00,'391','2022-10-18 15:43:14','795','2022-10-19 08:44:27',10,0),('5','92',257730,'Morning ','2022-10-19','2022-10-19 12:16:24','2022-10-20 12:16:24','391',0.00,0.00,'391','2022-10-19 12:16:41','795','2022-10-20 10:09:27',10,0),('5','92',257731,'Morning ','2022-10-20','2022-10-20 14:02:53','2022-10-21 14:02:53','391',0.00,0.00,'391','2022-10-20 14:03:17','795','2022-10-20 21:27:43',10,0),('5','92',257732,'Morning ','2022-10-21','2022-10-21 19:08:11','2022-10-22 19:08:11','391',0.00,0.00,'391','2022-10-21 19:08:29','606','2022-10-23 09:05:29',10,0),('5','92',257733,'Morning ','2022-10-22','2022-10-23 11:29:14','2022-10-24 11:29:14','391',0.00,0.00,'391','2022-10-23 11:29:31','795','2022-10-23 18:44:02',10,0),('5','92',257734,'Morning ','2022-10-23','2022-10-24 10:45:13','2022-10-25 10:45:13','391',0.00,0.00,'391','2022-10-24 10:47:41','795','2022-10-24 11:49:43',10,0),('5','92',257735,'Morning ','2022-10-24','2022-10-25 10:57:58','2022-10-26 10:57:58','391',0.00,0.00,'391','2022-10-25 10:58:22','795','2022-10-25 15:42:51',10,0),('5','92',257736,'Morning ','2022-10-25','2022-10-26 11:04:32','2022-10-27 11:04:32','391',0.00,0.00,'391','2022-10-26 11:04:56','795','2022-10-26 14:18:32',10,0),('5','92',257737,'Morning ','2022-10-26','2022-10-27 14:15:52','2022-10-28 14:15:52','391',0.00,0.00,'391','2022-10-27 14:16:09','795','2022-10-28 21:25:58',10,0),('5','92',257738,'Morning ','2022-10-27','2022-10-29 07:28:15','2022-10-30 07:28:15','391',0.00,0.00,'391','2022-10-29 07:28:31','795','2022-10-29 14:19:11',10,0),('5','92',257739,'Morning ','2022-10-28','2022-10-29 14:23:49','2022-10-30 14:23:49','391',474238.25,474238.25,'391','2022-10-29 14:29:50','795','2022-10-31 11:25:37',10,0),('5','92',257740,'Morning ','2022-10-29','2022-11-07 14:46:41','2022-11-08 14:46:41','391',1353743.05,1353743.05,'391','2022-11-07 14:47:50','606','2022-11-07 14:51:23',10,0),('5','92',257741,'Morning ','2022-10-30','2022-11-07 14:52:41','2022-11-08 14:52:41','391',1838015.70,1838015.70,'391','2022-11-07 14:54:01','606','2022-11-07 14:56:46',10,0),('5','92',257742,'Morning ','2022-10-31','2022-11-07 14:57:31','2022-11-08 14:57:31','391',2006090.05,2006090.05,'391','2022-11-07 14:58:25','606','2022-11-07 15:00:17',10,0),('5','92',257743,'Morning ','2022-11-01','2022-11-07 15:01:44','2022-11-08 15:01:44','391',1786992.70,1786992.70,'391','2022-11-07 15:02:57','606','2022-11-07 15:04:01',10,0),('5','92',257744,'Morning ','2022-11-02','2022-11-07 15:15:28','2022-11-08 15:15:28','391',2175945.95,2175945.95,'391','2022-11-07 15:16:27','606','2022-11-07 15:17:46',10,0),('5','92',257745,'Morning ','2022-11-03','2022-11-07 15:33:57','2022-11-08 15:33:57','391',2465852.05,2465852.05,'391','2022-11-07 15:34:55','606','2022-11-07 15:35:29',10,0),('5','92',257746,'Morning ','2022-11-04','2022-11-07 15:37:35','2022-11-08 15:37:35','391',2404119.40,2404119.40,'391','2022-11-07 15:38:37','606','2022-11-07 15:42:25',10,0),('5','92',257747,'Morning ','2022-11-05','2022-11-07 16:21:14','2022-11-08 16:21:14','391',1294631.85,1294631.85,'391','2022-11-07 16:22:12','606','2022-11-07 16:25:14',10,0),('5','92',257748,'Morning ','2022-11-06','2022-11-07 17:21:45','2022-11-08 17:21:45','391',0.00,0.00,'391','2022-11-07 17:22:03','606','2022-11-08 15:51:49',10,0),('5','92',257749,'Morning ','2022-11-07','2022-11-08 16:36:37','2022-11-09 16:36:37','391',0.00,0.00,'391','2022-11-08 16:37:38','606','2022-11-10 17:06:34',10,0),('5','92',257750,'Morning ','2022-11-08','2022-11-11 10:47:48','2022-11-12 10:47:48','391',0.00,0.00,'391','2022-11-11 10:48:06','606','2022-11-11 12:19:47',10,0),('5','92',257751,'Morning ','2022-11-09','2022-11-11 12:23:31','2022-11-12 12:23:31','391',0.00,0.00,'391','2022-11-11 12:23:52','606','2022-11-11 12:24:56',10,0),('5','92',257752,'Morning ','2022-11-10','2022-11-11 12:29:20','2022-11-12 12:29:20','391',0.00,0.00,'391','2022-11-11 12:29:38','606','2022-11-11 13:19:59',10,0),('5','92',257753,'Morning ','2022-11-11','2022-11-11 18:45:47','2022-11-12 18:45:47','391',0.00,0.00,'391','2022-11-11 18:46:44','606','2022-11-14 13:03:37',10,0),('5','92',257754,'Morning','2022-11-12','2022-11-14 13:10:56','2022-11-15 13:10:56','391',0.00,0.00,'391','2022-11-14 13:11:14','606','2022-11-14 13:45:05',10,0),('5','92',257755,'Morning','2022-11-13','2022-11-14 14:31:18','2022-11-15 14:31:18','391',0.00,0.00,'391','2022-11-14 14:31:38','606','2022-11-14 14:32:48',10,0),('5','92',257756,'Morning','2022-11-14','2022-11-14 14:34:01','2022-11-15 14:34:01','391',0.00,0.00,'391','2022-11-14 14:34:21','606','2022-11-15 11:30:42',10,0),('5','92',257757,'Morning','2022-11-15','2022-11-17 10:09:31','2022-11-18 10:09:31','391',0.00,0.00,'391','2022-11-17 10:09:47','606','2022-11-18 13:46:48',10,0),('5','92',257758,'morning ','2022-11-16','2022-11-18 14:35:52','2022-11-19 14:35:52','391',0.00,0.00,'391','2022-11-18 14:36:07','606','2022-11-18 14:37:04',10,0),('5','92',257759,'morning ','2022-11-17','2022-11-18 14:38:18','2022-11-19 14:38:18','391',0.00,0.00,'391','2022-11-18 14:38:33','606','2022-11-18 14:39:49',10,0),('5','92',257760,'morning ','2022-11-18','2022-11-18 14:40:14','2022-11-19 14:40:14','391',0.00,0.00,'391','2022-11-18 14:40:29','606','2022-11-19 18:28:46',10,0),('5','92',257761,'morning ','2022-11-19','2022-11-19 18:31:37','2022-11-20 18:31:37','391',0.00,0.00,'391','2022-11-19 18:31:51','606','2022-11-20 13:28:34',10,0),('5','92',257762,'morning ','2022-11-20','2022-11-20 13:29:35','2022-11-21 13:29:35','391',0.00,0.00,'391','2022-11-20 13:29:51','606','2022-11-22 13:39:34',10,0),('5','92',257763,'morning ','2022-11-21','2022-11-22 19:46:50','2022-11-23 19:46:50','391',0.00,0.00,'391','2022-11-22 19:47:07','606','2022-11-23 12:08:20',10,0),('5','92',257764,'morning ','2022-11-22','2022-11-24 10:13:26','2022-11-25 10:13:26','391',0.00,0.00,'391','2022-11-24 10:13:41','606','2022-11-24 13:05:11',10,0),('5','92',257765,'morning ','2022-11-23','2022-11-24 15:56:12','2022-11-25 15:56:12','391',0.00,0.00,'391','2022-11-24 15:56:36','606','2022-11-24 17:17:53',10,0),('5','92',257766,'morning ','2022-11-24','2022-11-25 12:35:59','2022-11-26 12:35:59','391',0.00,0.00,'391','2022-11-25 12:36:15','606','2022-11-25 14:54:50',10,0),('5','92',257767,'morning ','2022-11-25','2022-11-26 12:49:46','2022-11-27 12:49:46','391',0.00,0.00,'391','2022-11-26 12:50:02','606','2022-11-27 07:57:41',10,0),('5','92',257768,'morning ','2022-11-26','2022-11-27 19:30:52','2022-11-28 19:30:52','391',0.00,0.00,'391','2022-11-27 19:31:15','606','2022-11-28 07:00:40',10,0),('5','92',257769,'morning ','2022-11-27','2022-11-28 12:16:33','2022-11-29 12:16:33','391',0.00,0.00,'391','2022-11-28 12:17:00','606','2022-11-28 14:07:21',10,0),('5','92',257770,'morning ','2022-11-28','2022-11-29 13:48:31','2022-11-30 13:48:31','391',0.00,0.00,'391','2022-11-29 13:48:47','606','2022-11-30 11:34:14',10,0),('5','92',257771,'morning ','2022-11-29','2022-11-30 15:13:16','2022-12-01 15:13:16','391',0.00,0.00,'391','2022-11-30 15:13:28','606','2022-12-02 13:49:35',10,0),('5','92',257772,'Morning','2022-11-30','2022-12-04 21:13:04','2022-12-05 21:13:04','391',0.00,0.00,'391','2022-12-04 21:13:21','795','2022-12-05 08:30:35',10,0),('5','92',257773,'Morning','2022-12-01','2022-12-05 08:33:09','2022-12-06 08:33:09','391',0.00,0.00,'391','2022-12-05 08:33:25','795','2022-12-05 08:34:09',10,0),('5','92',257774,'Morning','2022-12-02','2022-12-05 08:35:37','2022-12-06 08:35:37','391',0.00,0.00,'391','2022-12-05 08:35:49','795','2022-12-05 08:37:09',10,0),('5','92',257775,'Morning','2022-12-03','2022-12-05 08:40:44','2022-12-06 08:40:44','391',0.00,0.00,'391','2022-12-05 08:41:13','795','2022-12-05 08:41:34',10,0),('5','92',257776,'Morning','2022-12-04','2022-12-05 08:42:47','2022-12-06 08:42:47','391',0.00,0.00,'391','2022-12-05 08:43:03','795','2022-12-05 08:44:51',10,0),('5','92',257777,'Morning','2022-12-05','2022-12-05 08:56:09','2022-12-06 08:56:09','391',0.00,0.00,'391','2022-12-05 08:56:24','795','2022-12-05 09:12:43',10,0),('5','92',257778,'Morning','2022-12-06','2022-12-06 10:29:50','2022-12-07 10:29:50','391',0.00,0.00,'391','2022-12-06 10:30:05','795','2022-12-06 11:54:45',10,0),('5','92',257779,'Morning','2022-12-07','2022-12-07 11:31:17','2022-12-08 11:31:17','391',0.00,0.00,'391','2022-12-07 11:31:34','795','2022-12-07 14:54:36',10,0),('5','92',257780,'Morning','2022-12-08','2022-12-08 10:41:30','2022-12-09 10:41:30','391',0.00,0.00,'391','2022-12-08 10:41:46','795','2022-12-08 15:08:25',10,0),('5','92',257781,'Morning','2022-12-09','2022-12-09 09:34:21','2022-12-10 09:34:21','391',0.00,0.00,'391','2022-12-09 09:34:36','795','2022-12-09 11:20:46',10,0),('5','92',257782,'Morning','2022-12-10','2022-12-10 18:02:38','2022-12-11 18:02:38','391',0.00,0.00,'391','2022-12-10 18:02:53','795','2022-12-10 18:17:49',10,0),('5','92',257783,'Morning','2022-12-11','2022-12-11 19:02:42','2022-12-12 19:02:42','391',0.00,0.00,'391','2022-12-11 19:02:59','795','2022-12-11 19:29:50',10,0),('5','92',257784,'Morning','2022-12-12','2022-12-12 07:52:39','2022-12-13 07:52:39','391',0.00,0.00,'391','2022-12-12 07:52:56','795','2022-12-12 09:30:17',10,0),('5','92',257785,'Morning','2022-12-13','2022-12-13 09:34:47','2022-12-14 09:34:47','391',0.00,0.00,'391','2022-12-13 09:35:02','795','2022-12-13 11:31:54',10,0),('5','92',257786,'Morning','2022-12-14','2022-12-14 13:15:17','2022-12-15 13:15:17','391',0.00,0.00,'391','2022-12-14 13:15:42','795','2022-12-14 16:23:39',10,0),('5','92',257787,'Morning','2022-12-15','2022-12-15 09:51:13','2022-12-16 09:51:13','391',0.00,0.00,'391','2022-12-15 09:51:30','795','2022-12-15 19:40:01',10,0),('5','92',257788,'Morning','2022-12-16','2022-12-16 08:43:34','2022-12-17 08:43:34','391',0.00,0.00,'391','2022-12-16 08:44:01','795','2022-12-16 09:44:12',10,0),('5','92',257789,'Morning','2022-12-17','2022-12-19 09:15:06','2022-12-20 09:15:06','391',0.00,0.00,'391','2022-12-19 09:15:24','795','2022-12-19 09:42:00',10,0),('5','92',257790,'Morning','2022-12-18','2022-12-19 19:36:56','2022-12-20 19:36:56','391',0.00,0.00,'391','2022-12-19 19:37:22','795','2022-12-20 12:15:04',10,0),('5','92',257791,'Morning','2022-12-19','2022-12-20 19:06:56','2022-12-21 19:06:56','391',0.00,0.00,'391','2022-12-20 19:07:12','795','2022-12-21 10:37:32',10,0),('5','92',257792,'Morning','2022-12-20','2022-12-22 07:31:42','2022-12-23 07:31:42','391',0.00,0.00,'391','2022-12-22 07:32:05','795','2022-12-22 18:40:25',10,0),('5','92',257793,'Morning','2022-12-23','2022-12-23 09:29:43','2022-12-24 09:29:43','391',0.00,0.00,'391','2022-12-23 09:30:03','795','2022-12-23 09:57:05',10,0),('5','92',257794,'Morning','2022-12-24','2022-12-24 08:01:34','2022-12-25 08:01:34','391',0.00,0.00,'391','2022-12-24 08:02:07','795','2022-12-24 09:00:43',10,0),('5','92',257795,'Morning','2022-12-25','2022-12-25 19:29:05','2022-12-26 19:29:05','391',0.00,0.00,'391','2022-12-25 19:29:26','795','2022-12-26 14:59:06',10,0),('5','92',257796,'Morning','2022-12-26','2022-12-26 18:52:39','2022-12-27 18:52:39','391',0.00,0.00,'391','2022-12-26 18:53:06','795','2022-12-27 12:14:17',10,0),('5','92',257797,'Morning','2022-12-28','2022-12-29 19:44:23','2022-12-30 19:44:23','391',0.00,0.00,'391','2022-12-29 19:44:50','795','2022-12-30 09:35:52',10,0),('5','92',257798,'Morning ','2022-12-29','2023-01-01 20:48:19','2023-01-02 20:48:19','391',0.00,0.00,'391','2023-01-01 20:48:45','795','2023-01-01 20:51:55',10,0),('5','92',257799,'Morning ','2022-12-30','2023-01-01 20:54:13','2023-01-02 20:54:13','391',0.00,0.00,'391','2023-01-01 20:56:47','795','2023-01-01 21:03:05',10,0),('5','92',257800,'Morning ','2022-12-31','2023-01-01 21:04:58','2023-01-02 21:04:58','391',0.00,0.00,'391','2023-01-01 21:05:51','795','2023-01-01 21:07:11',10,0),('5','92',257801,'Morning ','2023-01-01','2023-01-01 21:09:43','2023-01-02 21:09:43','391',0.00,0.00,'391','2023-01-01 21:10:23','795','2023-01-02 19:04:43',10,0),('5','92',257802,'Morning ','2023-01-02','2023-01-06 10:39:03','2023-01-07 10:39:03','391',0.00,0.00,'391','2023-01-06 10:39:40','795','2023-01-06 11:15:52',10,0),('5','92',257803,'Morning ','2023-01-03','2023-01-06 13:24:46','2023-01-07 13:24:46','391',0.00,0.00,'391','2023-01-06 13:25:10','795','2023-01-06 13:37:28',10,0),('5','92',257804,'Morning ','2023-01-04','2023-01-06 14:05:13','2023-01-07 14:05:13','391',0.00,0.00,'391','2023-01-06 14:05:38','795','2023-01-06 16:26:16',10,0),('5','92',257805,'Morning ','2023-01-05','2023-01-06 19:11:48','2023-01-07 19:11:48','391',0.00,0.00,'391','2023-01-06 19:12:05','795','2023-01-06 22:39:31',10,0),('5','92',257806,'Morning ','2023-01-06','2023-01-07 19:45:02','2023-01-08 19:45:02','391',0.00,0.00,'391','2023-01-07 19:45:20','795','2023-01-07 21:52:22',10,0),('5','92',257807,'Morning ','2023-01-07','2023-01-08 17:13:39','2023-01-09 17:13:39','391',0.00,0.00,'391','2023-01-08 17:14:00','795','2023-01-08 18:17:29',10,0),('5','92',257808,'Morning ','2023-01-08','2023-01-09 08:59:17','2023-01-10 08:59:17','391',0.00,0.00,'391','2023-01-09 09:00:16','795','2023-01-09 13:34:57',10,0),('5','92',257809,'Morning ','2023-01-09','2023-01-10 09:56:19','2023-01-11 09:56:19','391',0.00,0.00,'391','2023-01-10 09:57:34','795','2023-01-10 15:39:02',10,0),('5','92',257810,'Morning ','2023-01-10','2023-01-11 09:34:36','2023-01-12 09:34:36','391',0.00,0.00,'391','2023-01-11 09:35:01','795','2023-01-11 14:04:35',10,0),('5','92',257811,'Morning ','2023-01-11','2023-01-12 09:59:17','2023-01-13 09:59:17','391',0.00,0.00,'391','2023-01-12 09:59:38','795','2023-01-13 09:41:12',10,0),('5','92',257812,'Morning ','2023-01-12','2023-01-13 10:02:27','2023-01-14 10:02:27','391',0.00,0.00,'391','2023-01-13 10:02:46','795','2023-01-14 13:41:06',10,0),('5','92',257813,'Morning ','2023-01-13','2023-01-14 20:10:09','2023-01-15 20:10:09','391',0.00,0.00,'391','2023-01-14 20:10:34','795','2023-01-15 13:44:35',10,0),('5','92',257814,'Morning ','2023-01-14','2023-01-15 20:27:35','2023-01-16 20:27:35','391',0.00,0.00,'391','2023-01-15 20:28:06','795','2023-01-16 09:34:48',10,0),('5','92',257815,'Morning ','2023-01-15','2023-01-16 19:19:14','2023-01-17 19:19:14','391',0.00,0.00,'391','2023-01-16 19:19:39','795','2023-01-17 09:13:03',10,0),('5','92',257816,'Morning ','2023-01-16','2023-01-17 19:16:45','2023-01-18 19:16:45','391',0.00,0.00,'391','2023-01-17 19:17:12','795','2023-01-18 09:22:33',10,0),('5','92',257817,'Morning ','2023-01-17','2023-01-18 09:54:53','2023-01-19 09:54:53','391',0.00,0.00,'391','2023-01-18 09:55:11','795','2023-01-19 09:35:03',10,0),('5','92',257818,'Morning ','2023-01-18','2023-01-22 20:44:04','2023-01-23 20:44:04','391',0.00,0.00,'391','2023-01-22 20:44:28','795','2023-01-23 09:44:06',10,0),('5','92',257819,'Morning ','2023-01-19','2023-01-23 15:15:12','2023-01-24 15:15:12','391',0.00,0.00,'391','2023-01-23 15:15:30','795','2023-01-23 15:17:53',10,0),('5','92',257820,'Morning ','2023-01-20','2023-01-23 15:18:30','2023-01-24 15:18:30','391',0.00,0.00,'391','2023-01-23 15:18:51','795','2023-01-23 15:19:58',10,0),('5','92',257821,'Morning ','2023-01-21','2023-01-23 15:21:10','2023-01-24 15:21:10','391',0.00,0.00,'391','2023-01-23 15:21:37','795','2023-01-23 15:22:43',10,0),('5','92',257822,'Morning ','2023-01-22','2023-01-23 15:27:32','2023-01-24 15:27:32','391',0.00,0.00,'391','2023-01-23 15:27:59','795','2023-01-24 10:27:12',10,0),('5','92',257823,'Morning ','2023-01-23','2023-01-24 17:18:13','2023-01-25 17:18:13','391',0.00,0.00,'391','2023-01-24 17:18:37','795','2023-01-25 09:39:19',10,0),('5','92',257824,'Morning ','2023-01-24','2023-01-25 20:26:31','2023-01-26 20:26:31','391',0.00,0.00,'391','2023-01-25 20:26:50','795','2023-01-25 21:11:00',10,0),('5','92',257825,'Morning ','2023-01-25','2023-01-26 19:41:38','2023-01-27 19:41:38','391',0.00,0.00,'391','2023-01-26 19:42:13','795','2023-01-27 08:22:24',10,0),('5','92',257826,'Morning ','2023-01-26','2023-01-27 15:07:28','2023-01-28 15:07:28','391',0.00,0.00,'391','2023-01-27 15:07:48','795','2023-01-28 23:53:44',10,0),('5','92',257827,'Morning ','2023-01-27','2023-01-29 18:48:55','2023-01-30 18:48:55','391',0.00,0.00,'391','2023-01-29 18:49:20','795','2023-01-29 21:10:30',10,0),('5','92',257828,'Morning ','2023-01-28','2023-01-31 08:01:28','2023-02-01 08:01:28','391',0.00,0.00,'391','2023-01-31 08:01:51','795','2023-01-31 09:53:34',10,0),('5','92',257829,'Morning ','2023-01-29','2023-02-01 12:59:17','2023-02-02 12:59:17','391',0.00,0.00,'391','2023-02-01 12:59:39','795','2023-02-02 09:26:19',10,0),('5','92',257830,'Morning ','2023-01-30','2023-02-02 13:50:58','2023-02-03 13:50:58','391',0.00,0.00,'391','2023-02-02 13:51:17','795','2023-02-03 09:18:26',10,0),('5','92',257831,'Morning ','2023-01-31','2023-02-03 19:20:47','2023-02-04 19:20:47','391',0.00,0.00,'391','2023-02-03 19:21:14','795','2023-02-04 18:10:42',10,0),('5','92',257832,'Morning ','2023-02-01','2023-02-04 23:08:55','2023-02-05 23:08:55','391',0.00,0.00,'391','2023-02-04 23:09:26','795','2023-02-05 20:46:05',10,0),('5','92',257833,'Morning ','2023-02-02','2023-02-06 20:23:59','2023-02-07 20:23:59','391',0.00,0.00,'391','2023-02-06 20:24:17','795','2023-02-07 10:13:34',10,0),('5','92',257834,'Morning ','2023-02-03','2023-02-07 23:55:45','2023-02-08 23:55:45','391',0.00,0.00,'391','2023-02-07 23:56:19','795','2023-02-08 10:29:42',10,0),('5','92',257835,'Morning ','2023-02-04','2023-02-08 19:54:27','2023-02-09 19:54:27','391',0.00,0.00,'391','2023-02-08 19:54:44','795','2023-02-09 09:25:23',10,0),('5','92',257836,'morning','2023-02-05','2023-02-10 10:25:31','2023-02-11 10:25:31','391',0.00,0.00,'391','2023-02-10 10:25:52','795','2023-02-11 12:40:03',10,0),('5','92',257837,'Morning ','2023-02-06','2023-02-13 07:19:08','2023-02-14 07:19:08','391',0.00,0.00,'391','2023-02-13 07:19:31','795','2023-02-14 09:30:15',10,0),('5','92',257838,'Morning ','2023-02-07','2023-02-14 11:09:18','2023-02-15 11:09:18','391',0.00,0.00,'391','2023-02-14 11:09:37','795','2023-02-16 12:31:44',10,0),('5','92',257839,'Morning ','2023-02-08','2023-02-17 19:36:09','2023-02-18 19:36:09','391',0.00,0.00,'391','2023-02-17 19:36:26','795','2023-02-20 09:19:48',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4905920 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','92','598','212983',4125664,'1661','231',669245.15,670621.28,1376.13,227061.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','212983',4125665,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','212983',4125666,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','212983',4125667,'1664','231',127841.76,129591.89,1750.13,288771.45,0.00,0.00,0.00,0.00,0.00),('5','92','599','212983',4125668,'1665','231',1030027.58,1030027.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','212983',4125669,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','212983',4125670,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','212988',4125779,'1661','231',670621.28,671715.07,1093.79,180475.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','212988',4125780,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','212988',4125781,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','212988',4125782,'1664','231',129591.89,131373.72,1781.83,294001.95,0.00,0.00,0.00,0.00,0.00),('5','92','599','212988',4125783,'1665','231',1030027.58,1030027.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','212988',4125784,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','212988',4125785,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','212990',4125816,'1661','231',671715.07,673910.41,2195.34,362231.10,0.00,0.00,0.00,0.00,0.00),('5','92','598','212990',4125817,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','212990',4125818,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','212990',4125819,'1664','231',131373.72,133037.00,1663.28,274441.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','212990',4125820,'1665','231',1030027.58,1030027.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','212990',4125821,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','212990',4125822,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213099',4127710,'1661','231',673910.41,674665.88,755.47,124652.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','213099',4127711,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213099',4127712,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213099',4127713,'1664','231',133037.00,134003.94,966.94,159545.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','213099',4127714,'1665','231',1030027.58,1030027.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','213099',4127715,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','213099',4127716,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213355',4131889,'1661','231',674665.88,676168.01,1502.13,247851.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','213355',4131890,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213355',4131891,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213355',4131892,'1664','231',134003.94,135647.76,1643.82,271230.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','213355',4131893,'1665','231',1030027.58,1030027.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','213355',4131894,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','213355',4131895,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213600',4135927,'1661','231',676168.01,677387.39,1219.38,201197.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','213600',4135928,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213600',4135929,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213600',4135930,'1664','231',135647.76,136891.17,1243.41,205162.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','213600',4135931,'1665','231',1030027.58,1030027.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','213600',4135932,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','213600',4135933,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213730',4138062,'1661','231',677387.39,678337.69,950.30,156799.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','213730',4138063,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213730',4138064,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213730',4138065,'1664','231',136891.17,139017.55,2126.38,350852.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','213730',4138066,'1665','231',1030027.58,1030027.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','213730',4138067,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','213730',4138068,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213979',4142143,'1661','231',678337.69,679671.49,1333.80,220077.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213979',4142144,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213979',4142145,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','213979',4142146,'1664','231',139017.55,140734.16,1716.61,283240.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','213979',4142147,'1665','231',1030027.58,1030027.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','213979',4142148,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','213979',4142149,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214253',4147006,'1661','231',679671.49,680808.95,1137.46,187680.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','214253',4147007,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214253',4147008,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214253',4147009,'1664','231',140734.16,142064.04,1329.88,219430.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','214253',4147010,'1665','231',1030027.58,1030793.03,765.45,126299.25,0.00,0.00,0.00,0.00,0.00),('5','92','600','214253',4147011,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','214253',4147012,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214434',4149891,'1661','231',680808.95,681384.49,575.54,94964.10,0.00,0.00,0.00,0.00,0.00),('5','92','598','214434',4149892,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214434',4149893,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214434',4149894,'1664','231',142064.04,142529.29,465.25,76766.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','214434',4149895,'1665','231',1030793.03,1033230.74,2437.71,402222.15,0.00,0.00,0.00,0.00,0.00),('5','92','600','214434',4149896,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','214434',4149897,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214590',4152485,'1661','231',681384.49,681384.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214590',4152486,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214590',4152487,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214590',4152488,'1664','231',142529.29,142529.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','214590',4152489,'1665','231',1033230.74,1035935.22,2704.48,446239.20,0.00,0.00,0.00,0.00,0.00),('5','92','600','214590',4152490,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','214590',4152491,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214883',4157635,'1661','231',681384.49,681384.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214883',4157636,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214883',4157637,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','214883',4157638,'1664','231',142529.29,142529.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','214883',4157639,'1665','231',1035935.22,1039313.91,3378.69,557483.85,0.00,0.00,0.00,0.00,0.00),('5','92','600','214883',4157640,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','214883',4157641,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215123',4161648,'1661','231',681384.49,681384.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215123',4161649,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215123',4161650,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215123',4161651,'1664','231',142529.29,142529.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','215123',4161652,'1665','231',1039313.91,1042301.92,2988.01,493021.65,0.00,0.00,0.00,0.00,0.00),('5','92','600','215123',4161653,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','215123',4161654,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215331',4165245,'1661','231',681384.49,681384.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215331',4165246,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215331',4165247,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215331',4165248,'1664','231',142529.29,142529.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','215331',4165249,'1665','231',1042301.92,1044813.96,2512.04,414486.60,0.00,0.00,0.00,0.00,0.00),('5','92','600','215331',4165250,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','215331',4165251,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215637',4170461,'1661','231',681384.49,682668.13,1283.64,211800.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','215637',4170462,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215637',4170463,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215637',4170464,'1664','231',142529.29,144525.83,1996.54,329429.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','215637',4170465,'1665','231',1044813.96,1045054.83,240.87,39743.55,0.00,0.00,0.00,0.00,0.00),('5','92','600','215637',4170466,'1666','232',784622.80,784622.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','215637',4170467,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215857',4174313,'1661','231',682668.13,684025.63,1357.50,223987.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','215857',4174314,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215857',4174315,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','215857',4174316,'1664','231',144525.83,145945.34,1419.51,234219.15,0.00,0.00,0.00,0.00,0.00),('5','92','599','215857',4174317,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','215857',4174318,'1666','232',784622.80,784732.35,109.55,32317.25,0.00,0.00,0.00,0.00,0.00),('5','92','601','215857',4174319,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216080',4178193,'1661','231',684025.63,684871.30,845.67,139535.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','216080',4178194,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216080',4178195,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216080',4178196,'1664','231',145945.34,146963.09,1017.75,167928.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','216080',4178197,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','216080',4178198,'1666','232',784732.35,784959.71,227.36,67071.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','216080',4178199,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216294',4181930,'1661','231',684871.30,686036.53,1165.23,192262.95,0.00,0.00,0.00,0.00,0.00),('5','92','598','216294',4181931,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216294',4181932,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216294',4181933,'1664','231',146963.09,148247.52,1284.43,211930.95,0.00,0.00,0.00,0.00,0.00),('5','92','599','216294',4181934,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','216294',4181935,'1666','232',784959.71,785043.65,83.94,24762.30,0.00,0.00,0.00,0.00,0.00),('5','92','601','216294',4181936,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216525',4185874,'1661','231',686036.53,687997.32,1960.79,323530.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','216525',4185875,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216525',4185876,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216525',4185877,'1664','231',148247.52,149576.74,1329.22,219321.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','216525',4185878,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','216525',4185879,'1666','232',785043.65,785108.33,64.68,19080.60,0.00,0.00,0.00,0.00,0.00),('5','92','601','216525',4185880,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216767',4190272,'1661','231',687997.32,688824.22,826.90,136438.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','216767',4190273,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216767',4190274,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216767',4190275,'1664','231',149576.74,150957.45,1380.71,227817.15,0.00,0.00,0.00,0.00,0.00),('5','92','599','216767',4190276,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','216767',4190277,'1666','232',785108.33,785170.81,62.48,18431.60,0.00,0.00,0.00,0.00,0.00),('5','92','601','216767',4190278,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216941',4193071,'1661','231',688824.22,689566.94,742.72,122548.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','216941',4193072,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216941',4193073,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','216941',4193074,'1664','231',150957.45,152549.59,1592.14,262703.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','216941',4193075,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','216941',4193076,'1666','232',785170.81,785391.74,220.93,65174.35,0.00,0.00,0.00,0.00,0.00),('5','92','601','216941',4193077,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217132',4196358,'1661','231',689566.94,690716.81,1149.87,189728.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','217132',4196359,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217132',4196360,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217132',4196361,'1664','231',152549.59,153649.81,1100.22,181536.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','217132',4196362,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','217132',4196363,'1666','232',785391.74,786222.38,830.64,245038.80,0.00,0.00,0.00,0.00,0.00),('5','92','601','217132',4196364,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217386',4201050,'1661','231',690716.81,691538.80,821.99,135628.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','217386',4201051,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217386',4201052,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217386',4201053,'1664','231',153649.81,155132.37,1482.56,244622.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','217386',4201054,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','217386',4201055,'1666','232',786222.38,786325.31,102.93,30364.35,0.00,0.00,0.00,0.00,0.00),('5','92','601','217386',4201056,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217651',4205934,'1661','231',691538.80,692526.38,987.58,162950.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','217651',4205935,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217651',4205936,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217651',4205937,'1664','231',155132.37,156549.65,1417.28,233851.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','217651',4205938,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','217651',4205939,'1666','232',786325.31,786392.50,67.19,19821.05,0.00,0.00,0.00,0.00,0.00),('5','92','601','217651',4205940,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217861',4209603,'1661','231',692526.38,693613.63,1087.25,179396.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','217861',4209604,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217861',4209605,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','217861',4209606,'1664','231',156549.65,157844.34,1294.69,213623.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','217861',4209607,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','217861',4209608,'1666','232',786392.50,786483.60,91.10,26874.50,0.00,0.00,0.00,0.00,0.00),('5','92','601','217861',4209609,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218069',4213092,'1661','231',693613.63,694951.31,1337.68,220717.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','218069',4213093,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218069',4213094,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218069',4213095,'1664','231',157844.34,158903.00,1058.66,174678.90,0.00,0.00,0.00,0.00,0.00),('5','92','599','218069',4213096,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','218069',4213097,'1666','232',786483.60,786639.13,155.53,45881.35,0.00,0.00,0.00,0.00,0.00),('5','92','601','218069',4213098,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218275',4216669,'1661','231',694951.31,695940.54,989.23,163222.95,0.00,0.00,0.00,0.00,0.00),('5','92','598','218275',4216670,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218275',4216671,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218275',4216672,'1664','231',158903.00,159906.65,1003.65,165602.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','218275',4216673,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','218275',4216674,'1666','232',786639.13,787567.58,928.45,273892.75,0.00,0.00,0.00,0.00,0.00),('5','92','601','218275',4216675,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218635',4223315,'1661','231',695940.54,697253.05,1312.51,216564.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','218635',4223316,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218635',4223317,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218635',4223318,'1664','231',159906.65,161164.81,1258.16,207596.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','218635',4223319,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','218635',4223320,'1666','232',787567.58,787735.37,167.79,49498.05,0.00,0.00,0.00,0.00,0.00),('5','92','601','218635',4223321,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218870',4227380,'1661','231',697253.05,698030.32,777.27,128249.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','218870',4227381,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218870',4227382,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','218870',4227383,'1664','231',161164.81,162660.47,1495.66,246783.90,0.00,0.00,0.00,0.00,0.00),('5','92','599','218870',4227384,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','218870',4227385,'1666','232',787735.37,787914.12,178.75,52731.25,0.00,0.00,0.00,0.00,0.00),('5','92','601','218870',4227386,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219093',4231260,'1661','231',698030.32,698046.80,16.48,2719.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','219093',4231261,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219093',4231262,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219093',4231263,'1664','231',162660.47,163178.04,517.57,85399.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','219093',4231264,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','219093',4231265,'1666','232',787914.12,788063.50,149.38,44067.10,0.00,0.00,0.00,0.00,0.00),('5','92','601','219093',4231266,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219313',4235112,'1661','231',698046.80,698655.74,608.94,100475.10,0.00,0.00,0.00,0.00,0.00),('5','92','598','219313',4235113,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219313',4235114,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219313',4235115,'1664','231',163178.04,164050.79,872.75,144003.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','219313',4235116,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','219313',4235117,'1666','232',788063.50,788563.50,500.00,147500.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','219313',4235118,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219439',4236991,'1661','231',698655.74,699747.49,1091.75,180138.75,0.00,0.00,0.00,0.00,0.00),('5','92','598','219439',4236992,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219439',4236993,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219439',4236994,'1664','231',164050.79,165086.80,1036.01,170941.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','219439',4236995,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','219439',4236996,'1666','232',788563.50,789018.44,454.94,134207.30,0.00,0.00,0.00,0.00,0.00),('5','92','601','219439',4236997,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219670',4240970,'1661','231',699747.49,701161.52,1414.03,233314.95,0.00,0.00,0.00,0.00,0.00),('5','92','598','219670',4240971,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219670',4240972,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219670',4240973,'1664','231',165086.80,166767.57,1680.77,277327.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','219670',4240974,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','219670',4240975,'1666','232',789018.44,789114.50,96.06,28337.70,0.00,0.00,0.00,0.00,0.00),('5','92','601','219670',4240976,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219884',4244850,'1661','231',701161.52,702110.79,949.27,156629.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','219884',4244851,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219884',4244852,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','219884',4244853,'1664','231',166767.57,167780.26,1012.69,167093.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','219884',4244854,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','219884',4244855,'1666','232',789114.50,789249.28,134.78,39760.10,0.00,0.00,0.00,0.00,0.00),('5','92','601','219884',4244856,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220058',4248059,'1661','231',702110.79,703254.76,1143.97,188755.05,0.00,0.00,0.00,0.00,0.00),('5','92','598','220058',4248060,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220058',4248061,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220058',4248062,'1664','231',167780.26,169314.41,1534.15,253134.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','220058',4248063,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','220058',4248064,'1666','232',789249.28,789405.85,156.57,46188.15,0.00,0.00,0.00,0.00,0.00),('5','92','601','220058',4248065,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220301',4252228,'1661','231',703254.76,704052.53,797.77,131632.05,0.00,0.00,0.00,0.00,0.00),('5','92','598','220301',4252229,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220301',4252230,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220301',4252231,'1664','231',169314.41,170705.54,1391.13,229536.45,0.00,0.00,0.00,0.00,0.00),('5','92','599','220301',4252232,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','220301',4252233,'1666','232',789405.85,789564.14,158.29,46695.55,0.00,0.00,0.00,0.00,0.00),('5','92','601','220301',4252234,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220489',4255776,'1661','231',704052.53,704876.40,823.87,135938.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','220489',4255777,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220489',4255778,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220489',4255779,'1664','231',170705.54,171876.16,1170.62,193152.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','220489',4255780,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','220489',4255781,'1666','232',789564.14,789744.76,180.62,53282.90,0.00,0.00,0.00,0.00,0.00),('5','92','601','220489',4255782,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220694',4259358,'1661','231',704876.40,706290.50,1414.10,233326.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','220694',4259359,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220694',4259360,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220694',4259361,'1664','231',171876.16,173724.06,1847.90,304903.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','220694',4259362,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','220694',4259363,'1666','232',789744.76,789826.52,81.76,24119.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','220694',4259364,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220986',4264586,'1661','231',706290.50,707635.75,1345.25,221966.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','220986',4264587,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220986',4264588,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','220986',4264589,'1664','231',173724.06,175447.93,1723.87,284438.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','220986',4264590,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','220986',4264591,'1666','232',789826.52,790033.28,206.76,60994.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','220986',4264592,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221127',4267271,'1661','231',707635.75,709000.91,1365.16,225251.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','221127',4267272,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221127',4267273,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221127',4267274,'1664','231',175447.93,176873.65,1425.72,235243.80,0.00,0.00,0.00,0.00,0.00),('5','92','599','221127',4267275,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','221127',4267276,'1666','232',790033.28,790120.49,87.21,25726.95,0.00,0.00,0.00,0.00,0.00),('5','92','601','221127',4267277,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221378',4271703,'1661','231',709000.91,710207.84,1206.93,199143.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','221378',4271704,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221378',4271705,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221378',4271706,'1664','231',176873.65,178423.34,1549.69,255698.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','221378',4271707,'1665','231',1045054.83,1045054.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','221378',4271708,'1666','232',790120.49,790270.93,150.44,44379.80,0.00,0.00,0.00,0.00,0.00),('5','92','601','221378',4271709,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221697',4277384,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221697',4277385,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221697',4277386,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221697',4277387,'1664','231',178423.34,179589.45,1166.11,192408.15,0.00,0.00,0.00,0.00,0.00),('5','92','599','221697',4277388,'1665','231',1045054.83,1046078.10,1023.27,168839.55,0.00,0.00,0.00,0.00,0.00),('5','92','600','221697',4277389,'1666','232',790270.93,790421.84,150.91,44518.45,0.00,0.00,0.00,0.00,0.00),('5','92','601','221697',4277390,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221893',4280707,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221893',4280708,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221893',4280709,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','221893',4280710,'1664','231',179589.45,180704.54,1115.09,183989.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','221893',4280711,'1665','231',1046078.10,1046947.54,869.44,143457.60,0.00,0.00,0.00,0.00,0.00),('5','92','600','221893',4280712,'1666','232',790421.84,790585.88,164.04,48391.80,0.00,0.00,0.00,0.00,0.00),('5','92','601','221893',4280713,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222251',4287336,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222251',4287337,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222251',4287338,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222251',4287339,'1664','231',180704.54,182011.14,1306.60,215589.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','222251',4287340,'1665','231',1046947.54,1048176.10,1228.56,202712.40,0.00,0.00,0.00,0.00,0.00),('5','92','600','222251',4287341,'1666','232',790585.88,790651.21,65.33,19272.35,0.00,0.00,0.00,0.00,0.00),('5','92','601','222251',4287342,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222472',4291143,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222472',4291144,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222472',4291145,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222472',4291146,'1664','231',182011.14,183374.94,1363.80,225027.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','222472',4291147,'1665','231',1048176.10,1049781.07,1604.97,264820.05,0.00,0.00,0.00,0.00,0.00),('5','92','600','222472',4291148,'1666','232',790651.21,790797.89,146.68,43270.60,0.00,0.00,0.00,0.00,0.00),('5','92','601','222472',4291149,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222566',4292460,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222566',4292461,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222566',4292462,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222566',4292463,'1664','231',183374.94,184987.99,1613.05,266153.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','222566',4292464,'1665','231',1049781.07,1050798.19,1017.12,167824.80,0.00,0.00,0.00,0.00,0.00),('5','92','600','222566',4292465,'1666','232',790797.89,790869.03,71.14,20986.30,0.00,0.00,0.00,0.00,0.00),('5','92','601','222566',4292466,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222864',4298249,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222864',4298250,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222864',4298251,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','222864',4298252,'1664','231',184987.99,186068.31,1080.32,178252.80,0.00,0.00,0.00,0.00,0.00),('5','92','599','222864',4298253,'1665','231',1050798.19,1051651.78,853.59,140842.35,0.00,0.00,0.00,0.00,0.00),('5','92','600','222864',4298254,'1666','232',790869.03,790981.63,112.60,33217.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','222864',4298255,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223016',4300988,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223016',4300989,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223016',4300990,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223016',4300991,'1664','231',186068.31,187334.00,1265.69,208838.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','223016',4300992,'1665','231',1051651.78,1052549.87,898.09,148184.85,0.00,0.00,0.00,0.00,0.00),('5','92','600','223016',4300993,'1666','232',790981.63,791049.75,68.12,20095.40,0.00,0.00,0.00,0.00,0.00),('5','92','601','223016',4300994,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223315',4305811,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223315',4305812,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223315',4305813,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223315',4305814,'1664','231',187334.00,188692.31,1358.31,224121.15,0.00,0.00,0.00,0.00,0.00),('5','92','599','223315',4305815,'1665','231',1052549.87,1053597.56,1047.69,172868.85,0.00,0.00,0.00,0.00,0.00),('5','92','600','223315',4305816,'1666','232',791049.75,791137.57,87.82,25906.90,0.00,0.00,0.00,0.00,0.00),('5','92','601','223315',4305817,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223615',4311746,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223615',4311747,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223615',4311748,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223615',4311749,'1664','231',188692.31,190124.00,1431.69,236228.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','223615',4311750,'1665','231',1053597.56,1054788.96,1191.40,196581.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','223615',4311751,'1666','232',791137.57,791225.34,87.77,25892.15,0.00,0.00,0.00,0.00,0.00),('5','92','601','223615',4311752,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223856',4316187,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223856',4316188,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223856',4316189,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','223856',4316190,'1664','231',190124.00,191120.77,996.77,164467.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','223856',4316191,'1665','231',1054788.96,1056247.75,1458.79,240700.35,0.00,0.00,0.00,0.00,0.00),('5','92','600','223856',4316192,'1666','232',791225.34,791288.82,63.48,18726.60,0.00,0.00,0.00,0.00,0.00),('5','92','601','223856',4316193,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224041',4319383,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224041',4319384,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224041',4319385,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224041',4319386,'1664','231',191120.77,191206.78,86.01,14191.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','224041',4319387,'1665','231',1056247.75,1058399.91,2152.16,355106.40,0.00,0.00,0.00,0.00,0.00),('5','92','600','224041',4319388,'1666','232',791288.82,791348.40,59.58,17576.10,0.00,0.00,0.00,0.00,0.00),('5','92','601','224041',4319389,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224120',4320490,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224120',4320491,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224120',4320492,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224120',4320493,'1664','231',191206.78,191206.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','224120',4320494,'1665','231',1058399.91,1060440.20,2040.29,336647.85,0.00,0.00,0.00,0.00,0.00),('5','92','600','224120',4320495,'1666','232',791348.40,791441.97,93.57,27603.15,0.00,0.00,0.00,0.00,0.00),('5','92','601','224120',4320496,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224510',4327737,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224510',4327738,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224510',4327739,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224510',4327740,'1664','231',191206.78,191206.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','224510',4327741,'1665','231',1060440.20,1062751.04,2310.84,381288.60,0.00,0.00,0.00,0.00,0.00),('5','92','600','224510',4327742,'1666','232',791441.97,791521.81,79.84,23552.80,0.00,0.00,0.00,0.00,0.00),('5','92','601','224510',4327743,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224665',4330221,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224665',4330222,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224665',4330223,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224665',4330224,'1664','231',191206.78,191206.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','224665',4330225,'1665','231',1062751.04,1064810.90,2059.86,339876.90,0.00,0.00,0.00,0.00,0.00),('5','92','600','224665',4330226,'1666','232',791521.81,791612.73,90.92,26821.40,0.00,0.00,0.00,0.00,0.00),('5','92','601','224665',4330227,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224835',4333048,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224835',4333049,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224835',4333050,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','224835',4333051,'1664','231',191206.78,192512.00,1305.22,212750.86,0.00,0.00,0.00,0.00,0.00),('5','92','599','224835',4333052,'1665','231',1064810.90,1066644.91,1834.01,298943.63,0.00,0.00,0.00,0.00,0.00),('5','92','600','224835',4333053,'1666','232',791612.73,791690.06,77.33,22812.35,0.00,0.00,0.00,0.00,0.00),('5','92','601','224835',4333054,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225069',4337323,'1661','231',710207.84,710207.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225069',4337324,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225069',4337325,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225069',4337326,'1664','231',192512.00,194230.90,1718.90,280180.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','225069',4337327,'1665','231',1066644.91,1068081.28,1436.37,234128.31,0.00,0.00,0.00,0.00,0.00),('5','92','600','225069',4337328,'1666','232',791690.06,791993.62,303.56,89550.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','225069',4337329,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225465',4344882,'1661','231',710207.84,710253.70,45.86,7475.18,0.00,0.00,0.00,0.00,0.00),('5','92','598','225465',4344883,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225465',4344884,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225465',4344885,'1664','231',194230.90,194741.85,510.95,83284.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','225465',4344886,'1665','231',1068081.28,1069622.99,1541.71,251298.73,0.00,0.00,0.00,0.00,0.00),('5','92','600','225465',4344887,'1666','232',791993.62,792281.18,287.56,84830.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','225465',4344888,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225673',4348543,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225673',4348544,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225673',4348545,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225673',4348546,'1664','231',194741.85,196303.15,1561.30,254491.90,0.00,0.00,0.00,0.00,0.00),('5','92','599','225673',4348547,'1665','231',1069622.99,1070944.00,1321.01,215324.63,0.00,0.00,0.00,0.00,0.00),('5','92','600','225673',4348548,'1666','232',792281.18,792477.54,196.36,57926.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','225673',4348549,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225841',4351197,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225841',4351198,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225841',4351199,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','225841',4351200,'1664','231',196303.15,197587.94,1284.79,209420.77,0.00,0.00,0.00,0.00,0.00),('5','92','599','225841',4351201,'1665','231',1070944.00,1072293.26,1349.26,219929.38,0.00,0.00,0.00,0.00,0.00),('5','92','600','225841',4351202,'1666','232',792477.54,792567.86,90.32,26644.40,0.00,0.00,0.00,0.00,0.00),('5','92','601','225841',4351203,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226207',4358011,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226207',4358012,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226207',4358013,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226207',4358014,'1664','231',197587.94,199147.03,1559.09,254131.67,0.00,0.00,0.00,0.00,0.00),('5','92','599','226207',4358015,'1665','231',1072293.26,1073504.85,1211.59,197489.17,0.00,0.00,0.00,0.00,0.00),('5','92','600','226207',4358016,'1666','232',792567.86,792647.92,80.06,23617.70,0.00,0.00,0.00,0.00,0.00),('5','92','601','226207',4358017,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226345',4360189,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226345',4360190,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226345',4360191,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226345',4360192,'1664','231',199147.03,200266.52,1119.49,182476.87,0.00,0.00,0.00,0.00,0.00),('5','92','599','226345',4360193,'1665','231',1073504.85,1074645.57,1140.72,185937.36,0.00,0.00,0.00,0.00,0.00),('5','92','600','226345',4360194,'1666','232',792647.92,792844.04,196.12,57855.40,0.00,0.00,0.00,0.00,0.00),('5','92','601','226345',4360195,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226708',4366954,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226708',4366955,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226708',4366956,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226708',4366957,'1664','231',200266.52,202714.46,2447.94,399014.22,0.00,0.00,0.00,0.00,0.00),('5','92','599','226708',4366958,'1665','231',1074645.57,1074882.89,237.32,38683.16,0.00,0.00,0.00,0.00,0.00),('5','92','600','226708',4366959,'1666','232',792844.04,793000.43,156.39,46135.05,0.00,0.00,0.00,0.00,0.00),('5','92','601','226708',4366960,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226848',4369286,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226848',4369287,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226848',4369288,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226848',4369289,'1664','231',202714.46,203847.69,1133.23,184716.49,0.00,0.00,0.00,0.00,0.00),('5','92','599','226848',4369290,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','226848',4369291,'1666','232',793000.43,793184.01,183.58,54156.10,0.00,0.00,0.00,0.00,0.00),('5','92','601','226848',4369292,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226969',4371391,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226969',4371392,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226969',4371393,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','226969',4371394,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','226969',4371395,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','226969',4371396,'1666','232',793184.01,793356.43,172.42,50863.90,0.00,0.00,0.00,0.00,0.00),('5','92','601','226969',4371397,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227356',4378451,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227356',4378452,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227356',4378453,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227356',4378454,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','227356',4378455,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','227356',4378456,'1666','232',793356.43,793682.42,325.99,96167.05,0.00,0.00,0.00,0.00,0.00),('5','92','601','227356',4378457,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227588',4382369,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227588',4382370,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227588',4382371,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227588',4382372,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','227588',4382373,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','227588',4382374,'1666','232',793682.42,793873.01,190.59,56224.05,0.00,0.00,0.00,0.00,0.00),('5','92','601','227588',4382375,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227820',4386512,'1661','231',710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227820',4386513,'1662','231',59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227820',4386514,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227820',4386515,'1664','231',203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','227820',4386516,'1665','231',1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','227820',4386517,'1666','232',793873.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','227820',4386518,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227978',4389251,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227978',4389252,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227978',4389253,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','227978',4389254,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','227978',4389255,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','227978',4389256,'1666','232',793873.01,793995.55,122.54,36762.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','227978',4389257,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231944',4461965,'1661','231',710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231944',4461966,'1662','231',59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231944',4461967,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231944',4461968,'1664','231',203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','231944',4461969,'1665','231',1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','231944',4461970,'1666','232',793995.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','231944',4461971,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231947',4462012,'1661','231',710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231947',4462013,'1662','231',59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231947',4462014,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231947',4462015,'1664','231',203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','231947',4462016,'1665','231',1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','231947',4462017,'1666','232',794280.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','231947',4462018,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231954',4462128,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231954',4462129,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231954',4462130,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231954',4462131,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','231954',4462132,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','231954',4462133,'1666','232',794280.29,794528.26,247.97,74391.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','231954',4462134,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231963',4462312,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231963',4462313,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231963',4462314,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231963',4462315,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','231963',4462316,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','231963',4462317,'1666','232',794528.26,794655.50,127.24,38172.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','231963',4462318,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231964',4462319,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231964',4462320,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231964',4462321,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231964',4462322,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','231964',4462323,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','231964',4462324,'1666','232',794655.50,794940.87,285.37,85611.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','231964',4462325,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231966',4462368,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231966',4462369,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231966',4462370,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231966',4462371,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','231966',4462372,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','231966',4462373,'1666','232',794940.87,795383.91,443.04,132912.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','231966',4462374,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231972',4462565,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231972',4462566,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231972',4462567,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231972',4462568,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','231972',4462569,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','231972',4462570,'1666','232',795383.91,795706.00,322.09,96627.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','231972',4462571,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231974',4462582,'1661','231',710253.70,710253.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231974',4462583,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231974',4462584,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','231974',4462585,'1664','231',203847.69,203847.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','231974',4462586,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','231974',4462587,'1666','232',795706.00,795927.52,221.52,68671.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','231974',4462588,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232069',4464521,'1661','231',710253.70,710800.35,546.65,89103.95,0.00,0.00,0.00,0.00,0.00),('5','92','598','232069',4464522,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232069',4464523,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232069',4464524,'1664','231',203847.69,205852.24,2004.55,326741.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','232069',4464525,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','232069',4464526,'1666','232',795927.52,796029.78,102.26,32723.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','232069',4464527,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232918',4479471,'1661','231',710800.35,712001.29,1200.94,195753.22,0.00,0.00,0.00,0.00,0.00),('5','92','598','232918',4479472,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232918',4479473,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232918',4479474,'1664','231',205852.24,208298.53,2446.29,398745.27,0.00,0.00,0.00,0.00,0.00),('5','92','599','232918',4479475,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','232918',4479476,'1666','232',796029.78,796110.65,80.87,25878.40,0.00,0.00,0.00,0.00,0.00),('5','92','601','232918',4479477,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232924',4479557,'1661','231',712001.29,714022.02,2020.73,329378.99,0.00,0.00,0.00,0.00,0.00),('5','92','598','232924',4479558,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232924',4479559,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232924',4479560,'1664','231',208298.53,211194.43,2895.90,472031.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','232924',4479561,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','232924',4479562,'1666','232',796110.65,796369.51,258.86,82835.20,0.00,0.00,0.00,0.00,0.00),('5','92','601','232924',4479563,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232929',4479634,'1661','231',714022.02,714840.66,818.64,133438.32,0.00,0.00,0.00,0.00,0.00),('5','92','598','232929',4479635,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232929',4479636,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232929',4479637,'1664','231',211194.43,212662.74,1468.31,239334.53,0.00,0.00,0.00,0.00,0.00),('5','92','599','232929',4479638,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','232929',4479639,'1666','232',796369.51,796641.89,272.38,87161.60,0.00,0.00,0.00,0.00,0.00),('5','92','601','232929',4479640,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232934',4479707,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232934',4479708,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232934',4479709,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232934',4479710,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','232934',4479711,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','232934',4479712,'1666','232',796641.89,796854.97,213.08,69677.16,0.00,0.00,0.00,0.00,0.00),('5','92','601','232934',4479713,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232936',4479742,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232936',4479743,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232936',4479744,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232936',4479745,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','232936',4479746,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','232936',4479747,'1666','232',796854.97,797226.47,371.50,121480.50,0.00,0.00,0.00,0.00,0.00),('5','92','601','232936',4479748,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232940',4479825,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232940',4479826,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232940',4479827,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232940',4479828,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','232940',4479829,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','232940',4479830,'1666','232',797226.47,797697.85,471.38,154141.26,0.00,0.00,0.00,0.00,0.00),('5','92','601','232940',4479831,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232945',4479913,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232945',4479914,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232945',4479915,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','232945',4479916,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','232945',4479917,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','232945',4479918,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','232945',4479919,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233061',4482247,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233061',4482248,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233061',4482249,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233061',4482250,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','233061',4482251,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','233061',4482252,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','233061',4482253,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233312',4486848,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233312',4486849,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233312',4486850,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233312',4486851,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','233312',4486852,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','233312',4486853,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','233312',4486854,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233585',4491841,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233585',4491842,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233585',4491843,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233585',4491844,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','233585',4491845,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','233585',4491846,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','233585',4491847,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233769',4494970,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233769',4494971,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233769',4494972,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','233769',4494973,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','233769',4494974,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','233769',4494975,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','233769',4494976,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234026',4499611,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234026',4499612,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234026',4499613,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234026',4499614,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','234026',4499615,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','234026',4499616,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','234026',4499617,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234996',4516994,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234996',4516995,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234996',4516996,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234996',4516997,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','234996',4516998,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','234996',4516999,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','234996',4517000,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234997',4517001,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234997',4517002,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234997',4517003,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234997',4517004,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','234997',4517005,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','234997',4517006,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','234997',4517007,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234999',4517024,'1661','231',714840.66,714840.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234999',4517025,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234999',4517026,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','234999',4517027,'1664','231',212662.74,212662.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','234999',4517028,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','234999',4517029,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','234999',4517030,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235000',4517031,'1661','231',714840.66,715540.64,699.98,115496.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','235000',4517032,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235000',4517033,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235000',4517034,'1664','231',212662.74,212707.19,44.45,7334.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','235000',4517035,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','235000',4517036,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','235000',4517037,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235459',4525063,'1661','231',715540.64,715540.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235459',4525064,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235459',4525065,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235459',4525066,'1664','231',212707.19,212707.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','235459',4525067,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','235459',4525068,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','235459',4525069,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235696',4529205,'1661','231',715540.64,715540.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235696',4529206,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235696',4529207,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','235696',4529208,'1664','231',212707.19,212707.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','235696',4529209,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','235696',4529210,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','235696',4529211,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236449',4542506,'1661','231',715540.64,715540.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236449',4542507,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236449',4542508,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236449',4542509,'1664','231',212707.19,212707.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','236449',4542510,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','236449',4542511,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','236449',4542512,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236581',4544660,'1661','231',715540.64,715540.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236581',4544661,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236581',4544662,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236581',4544663,'1664','231',212707.19,212707.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','236581',4544664,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','236581',4544665,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','236581',4544666,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236584',4544703,'1661','231',715540.64,715540.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236584',4544704,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236584',4544705,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236584',4544706,'1664','231',212707.19,212707.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','236584',4544707,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','236584',4544708,'1666','232',797697.85,797697.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','236584',4544709,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236590',4544809,'1661','231',715540.64,717081.10,1540.46,254175.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','236590',4544810,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236590',4544811,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236590',4544812,'1664','231',212707.19,216217.47,3510.28,579196.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','236590',4544813,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','236590',4544814,'1666','232',797697.85,797743.83,45.98,15863.10,0.00,0.00,0.00,0.00,0.00),('5','92','601','236590',4544815,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236887',4549928,'1661','231',717081.10,719482.43,2401.33,396219.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','236887',4549929,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236887',4549930,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','236887',4549931,'1664','231',216217.47,219414.43,3196.96,527498.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','236887',4549932,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','236887',4549933,'1666','232',797743.83,797768.32,24.49,8449.05,0.00,0.00,0.00,0.00,0.00),('5','92','601','236887',4549934,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238212',4572797,'1661','231',719482.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238212',4572798,'1662','231',59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238212',4572799,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238212',4572800,'1664','231',219414.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','238212',4572801,'1665','231',1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238212',4572802,'1666','232',797768.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','238212',4572803,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238441',4576735,'1661','231',719482.43,719744.52,262.09,43244.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','238441',4576736,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238441',4576737,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238441',4576738,'1664','231',219414.43,220973.89,1559.46,257310.90,0.00,0.00,0.00,0.00,0.00),('5','92','599','238441',4576739,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238441',4576740,'1666','232',797768.32,797797.03,28.71,9904.95,0.00,0.00,0.00,0.00,0.00),('5','92','601','238441',4576741,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238456',4576914,'1661','231',719744.52,719744.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238456',4576915,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238456',4576916,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238456',4576917,'1664','231',220973.89,220973.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','238456',4576918,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238456',4576919,'1666','232',797797.03,797797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','238456',4576920,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238459',4576929,'1661','231',719744.52,719744.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238459',4576930,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238459',4576931,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238459',4576932,'1664','231',220973.89,220973.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','238459',4576933,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238459',4576934,'1666','232',797797.03,797797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','238459',4576935,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238461',4576964,'1661','231',719744.52,719744.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238461',4576965,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238461',4576966,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238461',4576967,'1664','231',220973.89,220973.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','238461',4576968,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238461',4576969,'1666','232',797797.03,797797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','238461',4576970,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238465',4577010,'1661','231',719744.52,719744.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238465',4577011,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238465',4577012,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238465',4577013,'1664','231',220973.89,220973.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','238465',4577014,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238465',4577015,'1666','232',797797.03,797797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','238465',4577016,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238466',4577017,'1661','231',719744.52,719744.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238466',4577018,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238466',4577019,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238466',4577020,'1664','231',220973.89,220973.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','238466',4577021,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238466',4577022,'1666','232',797797.03,797797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','238466',4577023,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238472',4577103,'1661','231',719744.52,719744.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238472',4577104,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238472',4577105,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238472',4577106,'1664','231',220973.89,220973.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','238472',4577107,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238472',4577108,'1666','232',797797.03,797797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','238472',4577109,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238801',4583071,'1661','231',719744.52,719744.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238801',4583072,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238801',4583073,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238801',4583074,'1664','231',220973.89,220973.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','238801',4583075,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238801',4583076,'1666','232',797797.03,797797.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','238801',4583077,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238938',4585360,'1661','231',719744.52,723034.24,3289.72,542803.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','238938',4585361,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238938',4585362,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','238938',4585363,'1664','231',220973.89,226459.90,5486.01,905191.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','238938',4585364,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','238938',4585365,'1666','232',797797.03,797835.06,38.03,13120.35,0.00,0.00,0.00,0.00,0.00),('5','92','601','238938',4585366,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239202',4589907,'1661','231',723034.24,725018.12,1983.88,327340.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','239202',4589908,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239202',4589909,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239202',4589910,'1664','231',226459.90,232393.58,5933.68,979057.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','239202',4589911,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','239202',4589912,'1666','232',797835.06,797853.75,18.69,6448.05,0.00,0.00,0.00,0.00,0.00),('5','92','601','239202',4589913,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239472',4594662,'1661','231',725018.12,725637.60,619.48,102214.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','239472',4594663,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239472',4594664,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239472',4594665,'1664','231',232393.58,235125.94,2732.36,450839.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','239472',4594666,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','239472',4594667,'1666','232',797853.75,797957.22,103.47,35697.15,0.00,0.00,0.00,0.00,0.00),('5','92','601','239472',4594668,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239727',4599142,'1661','231',725637.60,726314.08,676.48,111619.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','239727',4599143,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239727',4599144,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239727',4599145,'1664','231',235125.94,235843.33,717.39,118369.35,0.00,0.00,0.00,0.00,0.00),('5','92','599','239727',4599146,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','239727',4599147,'1666','232',797957.22,798002.22,45.00,15525.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','239727',4599148,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239932',4602604,'1661','231',726314.08,726314.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239932',4602605,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239932',4602606,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','239932',4602607,'1664','231',235843.33,235843.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','239932',4602608,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','239932',4602609,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','239932',4602610,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240233',4607767,'1661','231',726314.08,728507.18,2193.10,361861.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','240233',4607768,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240233',4607769,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240233',4607770,'1664','231',235843.33,237772.31,1928.98,318281.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','240233',4607771,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','240233',4607772,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','240233',4607773,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240377',4610290,'1661','231',728507.18,732311.27,3804.09,627674.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','240377',4610291,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240377',4610292,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240377',4610293,'1664','231',237772.31,243692.38,5920.07,976811.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','240377',4610294,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','240377',4610295,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','240377',4610296,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240622',4614288,'1661','231',732311.27,736239.07,3927.80,648087.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240622',4614289,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240622',4614290,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240622',4614291,'1664','231',243692.38,249567.68,5875.30,969424.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','240622',4614292,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','240622',4614293,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','240622',4614294,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240810',4616944,'1661','231',736239.07,738413.58,2174.51,358794.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','240810',4616945,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240810',4616946,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','240810',4616947,'1664','231',249567.68,252378.49,2810.81,463783.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','240810',4616948,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','240810',4616949,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','240810',4616950,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','241179',4623894,'1661','231',738413.58,739471.78,1058.20,174603.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','241179',4623895,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','241179',4623896,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','241179',4623897,'1664','231',252378.49,253137.73,759.24,125274.60,0.00,0.00,0.00,0.00,0.00),('5','92','599','241179',4623898,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','241179',4623899,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','241179',4623900,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','241446',4628438,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','241446',4628439,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','241446',4628440,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','241446',4628441,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','241446',4628442,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','241446',4628443,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','241446',4628444,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242607',4648630,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242607',4648631,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242607',4648632,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242607',4648633,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','242607',4648634,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','242607',4648635,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','242607',4648636,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242786',4651639,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242786',4651640,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242786',4651641,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242786',4651642,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','242786',4651643,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','242786',4651644,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','242786',4651645,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242792',4651689,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242792',4651690,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242792',4651691,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242792',4651692,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','242792',4651693,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','242792',4651694,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','242792',4651695,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242794',4651698,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242794',4651699,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242794',4651700,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242794',4651701,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','242794',4651702,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','242794',4651703,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','242794',4651704,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242795',4651705,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242795',4651706,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242795',4651707,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242795',4651708,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','242795',4651709,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','242795',4651710,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','242795',4651711,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242808',4651933,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242808',4651934,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242808',4651935,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','242808',4651936,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','242808',4651937,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','242808',4651938,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','242808',4651939,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243275',4660188,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243275',4660189,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243275',4660190,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243275',4660191,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','243275',4660192,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','243275',4660193,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','243275',4660194,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243293',4660589,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243293',4660590,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243293',4660591,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243293',4660592,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','243293',4660593,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','243293',4660594,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','243293',4660595,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243537',4664785,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243537',4664786,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243537',4664787,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','243537',4664788,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','243537',4664789,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','243537',4664790,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','243537',4664791,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244012',4673186,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244012',4673187,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244012',4673188,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244012',4673189,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','244012',4673190,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','244012',4673191,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','244012',4673192,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244235',4676936,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244235',4676937,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244235',4676938,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244235',4676939,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','244235',4676940,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','244235',4676941,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','244235',4676942,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244455',4680670,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244455',4680671,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244455',4680672,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','244455',4680673,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','244455',4680674,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','244455',4680675,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','244455',4680676,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245149',4692829,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245149',4692830,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245149',4692831,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245149',4692832,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','245149',4692833,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','245149',4692834,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','245149',4692835,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245384',4696953,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245384',4696954,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245384',4696955,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245384',4696956,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','245384',4696957,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','245384',4696958,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','245384',4696959,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245386',4696974,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245386',4696975,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245386',4696976,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245386',4696977,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','245386',4696978,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','245386',4696979,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','245386',4696980,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245387',4696981,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245387',4696982,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245387',4696983,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245387',4696984,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','245387',4696985,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','245387',4696986,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','245387',4696987,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245389',4697003,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245389',4697004,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245389',4697005,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245389',4697006,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','245389',4697007,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','245389',4697008,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','245389',4697009,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245608',4700858,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245608',4700859,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245608',4700860,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245608',4700861,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','245608',4700862,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','245608',4700863,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','245608',4700864,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245876',4704974,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245876',4704975,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245876',4704976,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','245876',4704977,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','245876',4704978,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','245876',4704979,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','245876',4704980,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246124',4709105,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246124',4709106,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246124',4709107,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246124',4709108,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','246124',4709109,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','246124',4709110,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','246124',4709111,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246393',4713483,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246393',4713484,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246393',4713485,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246393',4713486,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','246393',4713487,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','246393',4713488,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','246393',4713489,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246641',4717895,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246641',4717896,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246641',4717897,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246641',4717898,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','246641',4717899,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','246641',4717900,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','246641',4717901,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246873',4721983,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246873',4721984,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246873',4721985,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','246873',4721986,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','246873',4721987,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','246873',4721988,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','246873',4721989,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247116',4726137,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247116',4726138,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247116',4726139,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247116',4726140,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','247116',4726141,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','247116',4726142,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','247116',4726143,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247353',4730454,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247353',4730455,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247353',4730456,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247353',4730457,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','247353',4730458,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','247353',4730459,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','247353',4730460,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247597',4734325,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247597',4734326,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247597',4734327,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247597',4734328,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','247597',4734329,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','247597',4734330,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','247597',4734331,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247845',4738585,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247845',4738586,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247845',4738587,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','247845',4738588,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','247845',4738589,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','247845',4738590,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','247845',4738591,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','248107',4743103,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','248107',4743104,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','248107',4743105,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','248107',4743106,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','248107',4743107,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','248107',4743108,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','248107',4743109,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249041',4758927,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249041',4758928,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249041',4758929,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249041',4758930,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','249041',4758931,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','249041',4758932,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','249041',4758933,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249043',4758951,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249043',4758952,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249043',4758953,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249043',4758954,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','249043',4758955,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','249043',4758956,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','249043',4758957,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249045',4758976,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249045',4758977,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249045',4758978,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249045',4758979,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','249045',4758980,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','249045',4758981,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','249045',4758982,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249046',4758983,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249046',4758984,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249046',4758985,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249046',4758986,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','249046',4758987,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','249046',4758988,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','249046',4758989,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249281',4762910,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249281',4762911,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249281',4762912,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249281',4762913,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','249281',4762914,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','249281',4762915,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','249281',4762916,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249782',4771406,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249782',4771407,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249782',4771408,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','249782',4771409,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','249782',4771410,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','249782',4771411,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','249782',4771412,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250055',4775954,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250055',4775955,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250055',4775956,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250055',4775957,'1664','231',253137.73,253137.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','250055',4775958,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','250055',4775959,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','250055',4775960,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250075',4776317,'1661','231',739471.78,739471.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250075',4776318,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250075',4776319,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250075',4776320,'1664','231',253137.73,253917.73,780.00,128700.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','250075',4776321,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','250075',4776322,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','250075',4776323,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250304',4780248,'1661','231',739471.78,741723.31,2251.53,371502.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','250304',4780249,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250304',4780250,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250304',4780251,'1664','231',253917.73,257247.69,3329.96,549443.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','250304',4780252,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','250304',4780253,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','250304',4780254,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250644',4785573,'1661','231',741723.31,743873.53,2150.22,354786.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','250644',4785574,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250644',4785575,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250644',4785576,'1664','231',257247.69,260559.06,3311.37,546376.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','250644',4785577,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','250644',4785578,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','250644',4785579,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250735',4787437,'1661','231',743873.53,747843.16,3969.63,654988.95,0.00,0.00,0.00,0.00,0.00),('5','92','598','250735',4787438,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250735',4787439,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250735',4787440,'1664','231',260559.06,264631.21,4072.15,671904.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','250735',4787441,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','250735',4787442,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','250735',4787443,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250953',4791378,'1661','231',747843.16,749053.96,1210.80,199782.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250953',4791379,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250953',4791380,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','250953',4791381,'1664','231',264631.21,266253.70,1622.49,267710.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','250953',4791382,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','250953',4791383,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','250953',4791384,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251208',4795796,'1661','231',749053.96,755060.90,6006.94,991145.10,0.00,0.00,0.00,0.00,0.00),('5','92','598','251208',4795797,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251208',4795798,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251208',4795799,'1664','231',266253.70,272727.72,6474.02,1068213.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','251208',4795800,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','251208',4795801,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','251208',4795802,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251466',4800218,'1661','231',755060.90,759281.62,4220.72,696418.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','251466',4800219,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251466',4800220,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251466',4800221,'1664','231',272727.72,277367.96,4640.24,765639.60,0.00,0.00,0.00,0.00,0.00),('5','92','599','251466',4800222,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','251466',4800223,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','251466',4800224,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251736',4805100,'1661','231',759281.62,762766.35,3484.73,574980.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','251736',4805101,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251736',4805102,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251736',4805103,'1664','231',277367.96,280771.98,3404.02,561663.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','251736',4805104,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','251736',4805105,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','251736',4805106,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251950',4808658,'1661','231',762766.35,763190.54,424.19,69991.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','251950',4808659,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251950',4808660,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','251950',4808661,'1664','231',280771.98,281800.16,1028.18,169649.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','251950',4808662,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','251950',4808663,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','251950',4808664,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','252190',4812900,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','252190',4812901,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','252190',4812902,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','252190',4812903,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','252190',4812904,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','252190',4812905,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','252190',4812906,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253144',4829313,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253144',4829314,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253144',4829315,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253144',4829316,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','253144',4829317,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','253144',4829318,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','253144',4829319,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253158',4829504,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253158',4829505,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253158',4829506,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253158',4829507,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','253158',4829508,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','253158',4829509,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','253158',4829510,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253159',4829511,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253159',4829512,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253159',4829513,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253159',4829514,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','253159',4829515,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','253159',4829516,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','253159',4829517,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253160',4829518,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253160',4829519,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253160',4829520,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253160',4829521,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','253160',4829522,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','253160',4829523,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','253160',4829524,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253301',4831687,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253301',4831688,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253301',4831689,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253301',4831690,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','253301',4831691,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','253301',4831692,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','253301',4831693,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253655',4837898,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253655',4837899,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253655',4837900,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253655',4837901,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','253655',4837902,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','253655',4837903,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','253655',4837904,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253910',4842498,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253910',4842499,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253910',4842500,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','253910',4842501,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','253910',4842502,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','253910',4842503,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','253910',4842504,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254134',4846435,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254134',4846436,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254134',4846437,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254134',4846438,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','254134',4846439,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','254134',4846440,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','254134',4846441,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254391',4850762,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254391',4850763,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254391',4850764,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254391',4850765,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','254391',4850766,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','254391',4850767,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','254391',4850768,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254641',4855215,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254641',4855216,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254641',4855217,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254641',4855218,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','254641',4855219,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','254641',4855220,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','254641',4855221,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254890',4859379,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254890',4859380,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254890',4859381,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','254890',4859382,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','254890',4859383,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','254890',4859384,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','254890',4859385,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255127',4863435,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255127',4863436,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255127',4863437,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255127',4863438,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','255127',4863439,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','255127',4863440,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','255127',4863441,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255390',4868060,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255390',4868061,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255390',4868062,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255390',4868063,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','255390',4868064,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','255390',4868065,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','255390',4868066,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255826',4875006,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255826',4875007,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255826',4875008,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','255826',4875009,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','255826',4875010,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','255826',4875011,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','255826',4875012,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256129',4880137,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256129',4880138,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256129',4880139,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256129',4880140,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','256129',4880141,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','256129',4880142,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','256129',4880143,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256419',4885045,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256419',4885046,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256419',4885047,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256419',4885048,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','256419',4885049,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','256419',4885050,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','256419',4885051,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256671',4889232,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256671',4889233,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256671',4889234,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256671',4889235,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','256671',4889236,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','256671',4889237,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','256671',4889238,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256904',4893229,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256904',4893230,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256904',4893231,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','256904',4893232,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','256904',4893233,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','256904',4893234,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','256904',4893235,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257465',4903295,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257465',4903296,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257465',4903297,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257465',4903298,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257465',4903299,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257465',4903300,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257465',4903301,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257466',4903302,'1661','231',763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257466',4903303,'1662','231',59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257466',4903304,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257466',4903305,'1664','231',281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257466',4903306,'1665','231',1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257466',4903307,'1666','232',798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257466',4903308,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257467',4903309,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257467',4903310,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257467',4903311,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257467',4903312,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257467',4903313,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257467',4903314,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257467',4903315,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257468',4903316,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257468',4903317,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257468',4903318,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257468',4903319,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257468',4903320,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257468',4903321,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257468',4903322,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257469',4903323,'1664','231',281800.16,281800.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257469',4903324,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257469',4903325,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257469',4903326,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257469',4903327,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257469',4903328,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257469',4903329,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257470',4903330,'1664','231',281890.16,281890.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257470',4903331,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257470',4903332,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257470',4903333,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257470',4903334,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257470',4903335,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257470',4903336,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257471',4903337,'1661','231',763190.54,763190.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257471',4903338,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257471',4903339,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257471',4903340,'1664','231',281890.16,281890.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257471',4903341,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257471',4903342,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257471',4903343,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257472',4903344,'1661','231',763190.54,765838.39,2647.85,436895.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257472',4903345,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257472',4903346,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257472',4903347,'1664','231',281890.16,285813.46,3923.30,647344.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','257472',4903348,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257472',4903349,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257472',4903350,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257473',4903351,'1661','231',765838.39,769924.45,4086.06,674199.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257473',4903352,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257473',4903353,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257473',4903354,'1664','231',285813.46,289108.80,3295.34,543731.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257473',4903355,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257473',4903356,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257473',4903357,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257474',4903358,'1664','231',289108.80,291266.24,2157.44,355977.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257474',4903359,'1661','231',769924.45,772267.92,2343.47,386672.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','257474',4903360,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257474',4903361,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257474',4903362,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257474',4903363,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257474',4903364,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257475',4903365,'1664','231',291266.24,296497.49,5231.25,863156.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257475',4903366,'1661','231',772267.92,777494.24,5226.32,862342.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','257475',4903367,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257475',4903368,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257475',4903369,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257475',4903370,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257475',4903371,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257476',4903372,'1664','231',296497.49,297244.92,747.43,123325.95,0.00,0.00,0.00,0.00,0.00),('5','92','598','257476',4903373,'1661','231',777494.24,777892.72,398.48,65749.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','257476',4903374,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257476',4903375,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257476',4903376,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257476',4903377,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257476',4903378,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257477',4903379,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257477',4903380,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257477',4903381,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257477',4903382,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257477',4903383,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257477',4903384,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257477',4903385,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257478',4903386,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257478',4903387,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257478',4903388,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257478',4903389,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257478',4903390,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257478',4903391,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257478',4903392,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257479',4903393,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257479',4903394,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257479',4903395,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257479',4903396,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257479',4903397,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257479',4903398,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257479',4903399,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257480',4903400,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257480',4903401,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257480',4903402,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257480',4903403,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257480',4903404,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257480',4903405,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257480',4903406,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257481',4903407,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257481',4903408,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257481',4903409,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257481',4903410,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257481',4903411,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257481',4903412,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257481',4903413,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257482',4903414,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257482',4903415,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257482',4903416,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257482',4903417,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257482',4903418,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257482',4903419,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257482',4903420,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257483',4903421,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257483',4903422,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257483',4903423,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257483',4903424,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257483',4903425,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257483',4903426,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257483',4903427,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257484',4903428,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257484',4903429,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257484',4903430,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257484',4903431,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257484',4903432,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257484',4903433,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257484',4903434,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257485',4903435,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257485',4903436,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257485',4903437,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257485',4903438,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257485',4903439,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257485',4903440,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257485',4903441,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257486',4903442,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257486',4903443,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257486',4903444,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257486',4903445,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257486',4903446,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257486',4903447,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257486',4903448,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257487',4903449,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257487',4903450,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257487',4903451,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257487',4903452,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257487',4903453,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257487',4903454,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257487',4903455,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257488',4903456,'1661','231',777892.72,777892.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257488',4903457,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257488',4903458,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257488',4903459,'1664','231',297244.92,297244.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257488',4903460,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257488',4903461,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257488',4903462,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257489',4903463,'1661','231',777892.72,783687.93,5795.21,956209.65,0.00,0.00,0.00,0.00,0.00),('5','92','598','257489',4903464,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257489',4903465,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257489',4903466,'1664','231',297244.92,302293.48,5048.56,833012.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','257489',4903467,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257489',4903468,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257489',4903469,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257490',4903470,'1661','231',783687.93,786850.08,3162.15,521754.75,0.00,0.00,0.00,0.00,0.00),('5','92','598','257490',4903471,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257490',4903472,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257490',4903473,'1664','231',302293.48,308556.16,6262.68,1033342.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','257490',4903474,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257490',4903475,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257490',4903476,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257491',4903477,'1661','231',786850.08,787989.21,1139.13,187956.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','257491',4903478,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257491',4903479,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257491',4903480,'1664','231',308556.16,311407.35,2851.19,470446.35,0.00,0.00,0.00,0.00,0.00),('5','92','599','257491',4903481,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257491',4903482,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257491',4903483,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257492',4903484,'1661','231',787989.21,789049.03,1059.82,174870.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257492',4903485,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257492',4903486,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257492',4903487,'1664','231',311407.35,313000.68,1593.33,262899.45,0.00,0.00,0.00,0.00,0.00),('5','92','599','257492',4903488,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257492',4903489,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257492',4903490,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257493',4903491,'1661','231',789049.03,789049.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257493',4903492,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257493',4903493,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257493',4903494,'1664','231',313000.68,313000.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257493',4903495,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257493',4903496,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257493',4903497,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257494',4903498,'1661','231',789049.03,789049.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257494',4903499,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257494',4903500,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257494',4903501,'1664','231',313000.68,313000.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257494',4903502,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257494',4903503,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257494',4903504,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257495',4903505,'1661','231',789049.03,790548.68,1499.65,247442.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257495',4903506,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257495',4903507,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257495',4903508,'1664','231',313000.68,316672.35,3671.67,605825.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','257495',4903509,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257495',4903510,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257495',4903511,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257496',4903512,'1661','231',790548.68,798037.31,7488.63,1235623.95,0.00,0.00,0.00,0.00,0.00),('5','92','598','257496',4903513,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257496',4903514,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257496',4903515,'1664','231',316672.35,322262.75,5590.40,922416.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257496',4903516,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257496',4903517,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257496',4903518,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257497',4903519,'1661','231',798037.31,799623.60,1586.29,261737.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','257497',4903520,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257497',4903521,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257497',4903522,'1664','231',322262.75,326535.50,4272.75,705003.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','257497',4903523,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257497',4903524,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257497',4903525,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257498',4903526,'1664','231',326535.50,329652.36,3116.86,514281.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257498',4903527,'1661','231',799623.60,802614.36,2990.76,493475.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257498',4903528,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257498',4903529,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257498',4903530,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257498',4903531,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257498',4903532,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257499',4903533,'1661','231',802614.36,802614.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257499',4903534,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257499',4903535,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257499',4903536,'1664','231',329652.36,329652.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257499',4903537,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257499',4903538,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257499',4903539,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257500',4903540,'1661','231',802614.36,802614.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257500',4903541,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257500',4903542,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257500',4903543,'1664','231',329652.36,329652.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257500',4903544,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257500',4903545,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257500',4903546,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257501',4903547,'1661','231',802614.36,802614.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257501',4903548,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257501',4903549,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257501',4903550,'1664','231',329652.36,329652.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257501',4903551,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257501',4903552,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257501',4903553,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257502',4903554,'1661','231',802614.36,802614.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257502',4903555,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257502',4903556,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257502',4903557,'1664','231',329652.36,329652.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257502',4903558,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257502',4903559,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257502',4903560,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257503',4903561,'1664','231',329652.36,329652.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257503',4903562,'1661','231',802614.36,802614.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257503',4903563,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257503',4903564,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257503',4903565,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257503',4903566,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257503',4903567,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257504',4903568,'1664','231',329652.36,329652.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257504',4903569,'1661','231',802614.36,802614.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257504',4903570,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257504',4903571,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257504',4903572,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257504',4903573,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257504',4903574,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257505',4903575,'1664','231',329652.36,332880.87,3228.51,532704.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','257505',4903576,'1661','231',802614.36,805706.74,3092.38,510242.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257505',4903577,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257505',4903578,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257505',4903579,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257505',4903580,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257505',4903581,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257506',4903582,'1664','231',332880.87,336418.52,3537.65,583712.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257506',4903583,'1661','231',805706.74,809540.65,3833.91,632595.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','257506',4903584,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257506',4903585,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257506',4903586,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257506',4903587,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257506',4903588,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257507',4903589,'1664','231',336418.52,339824.84,3406.32,562042.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','257507',4903590,'1661','231',809540.65,812695.69,3155.04,520581.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257507',4903591,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257507',4903592,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257507',4903593,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257507',4903594,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257507',4903595,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257508',4903596,'1664','231',339824.84,344194.29,4369.45,720959.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257508',4903597,'1661','231',812695.69,816624.55,3928.86,648261.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257508',4903598,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257508',4903599,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257508',4903600,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257508',4903601,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257508',4903602,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257509',4903603,'1664','231',344194.29,347790.89,3596.60,593439.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257509',4903604,'1661','231',816624.55,820224.60,3600.05,594008.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257509',4903605,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257509',4903606,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257509',4903607,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257509',4903608,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257509',4903609,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257510',4903610,'1661','231',820224.60,823752.26,3527.66,582063.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257510',4903611,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257510',4903612,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257510',4903613,'1664','231',347790.89,351404.90,3614.01,596311.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257510',4903614,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257510',4903615,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257510',4903616,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257511',4903617,'1661','231',823752.26,824301.79,549.53,90672.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','257511',4903618,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257511',4903619,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257511',4903620,'1664','231',351404.90,352895.51,1490.61,245950.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257511',4903621,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257511',4903622,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257511',4903623,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257512',4903624,'1661','231',824301.79,826956.89,2655.10,438091.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','257512',4903625,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257512',4903626,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257512',4903627,'1664','231',352895.51,355669.10,2773.59,457642.35,0.00,0.00,0.00,0.00,0.00),('5','92','599','257512',4903628,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257512',4903629,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257512',4903630,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257513',4903631,'1661','231',826956.89,830844.09,3887.20,641388.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257513',4903632,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257513',4903633,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257513',4903634,'1664','231',355669.10,360564.24,4895.14,807698.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257513',4903635,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257513',4903636,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257513',4903637,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257514',4903638,'1661','231',830844.09,836090.13,5246.04,865596.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257514',4903639,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257514',4903640,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257514',4903641,'1664','231',360564.24,366683.25,6119.01,1009636.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257514',4903642,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257514',4903643,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257514',4903644,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257515',4903645,'1661','231',836090.13,836638.64,548.51,90504.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','257515',4903646,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257515',4903647,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257515',4903648,'1664','231',366683.25,367541.38,858.13,141591.45,0.00,0.00,0.00,0.00,0.00),('5','92','599','257515',4903649,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257515',4903650,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257515',4903651,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257516',4903652,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257516',4903653,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257516',4903654,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257516',4903655,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257516',4903656,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257516',4903657,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257516',4903658,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257517',4903659,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257517',4903660,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257517',4903661,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257517',4903662,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257517',4903663,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257517',4903664,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257517',4903665,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257518',4903666,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257518',4903667,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257518',4903668,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257518',4903669,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257518',4903670,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257518',4903671,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257518',4903672,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257519',4903673,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257519',4903674,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257519',4903675,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257519',4903676,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257519',4903677,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257519',4903678,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257519',4903679,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257520',4903680,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257520',4903681,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257520',4903682,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257520',4903683,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257520',4903684,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257520',4903685,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257520',4903686,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257521',4903687,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257521',4903688,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257521',4903689,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257521',4903690,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257521',4903691,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257521',4903692,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257521',4903693,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257522',4903694,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257522',4903695,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257522',4903696,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257522',4903697,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257522',4903698,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257522',4903699,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257522',4903700,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257523',4903701,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257523',4903702,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257523',4903703,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257523',4903704,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257523',4903705,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257523',4903706,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257523',4903707,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257524',4903708,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257524',4903709,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257524',4903710,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257524',4903711,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257524',4903712,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257524',4903713,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257524',4903714,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257525',4903715,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257525',4903716,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257525',4903717,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257525',4903718,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257525',4903719,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257525',4903720,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257525',4903721,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257526',4903722,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257526',4903723,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257526',4903724,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257526',4903725,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257526',4903726,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257526',4903727,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257526',4903728,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257527',4903729,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257527',4903730,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257527',4903731,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257527',4903732,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257527',4903733,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257527',4903734,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257527',4903735,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257528',4903736,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257528',4903737,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257528',4903738,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257528',4903739,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257528',4903740,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257528',4903741,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257528',4903742,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257529',4903743,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257529',4903744,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257529',4903745,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257529',4903746,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257529',4903747,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257529',4903748,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257529',4903749,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257530',4903750,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257530',4903751,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257530',4903752,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257530',4903753,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257530',4903754,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257530',4903755,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257530',4903756,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257531',4903757,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257531',4903758,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257531',4903759,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257531',4903760,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257531',4903761,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257531',4903762,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257531',4903763,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257532',4903764,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257532',4903765,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257532',4903766,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257532',4903767,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257532',4903768,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257532',4903769,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257532',4903770,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257533',4903771,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257533',4903772,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257533',4903773,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257533',4903774,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257533',4903775,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257533',4903776,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257533',4903777,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257534',4903778,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257534',4903779,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257534',4903780,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257534',4903781,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257534',4903782,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257534',4903783,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257534',4903784,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257535',4903785,'1664','231',367541.38,367541.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257535',4903786,'1661','231',836638.64,836638.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257535',4903787,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257535',4903788,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257535',4903789,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257535',4903790,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257535',4903791,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257536',4903792,'1661','231',836638.64,838457.09,1818.45,300044.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257536',4903793,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257536',4903794,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257536',4903795,'1664','231',367541.38,370518.09,2976.71,491157.15,0.00,0.00,0.00,0.00,0.00),('5','92','599','257536',4903796,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257536',4903797,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257536',4903798,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257537',4903799,'1661','231',838457.09,841977.73,3520.64,580905.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257537',4903800,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257537',4903801,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257537',4903802,'1664','231',370518.09,376728.73,6210.64,1024755.60,0.00,0.00,0.00,0.00,0.00),('5','92','599','257537',4903803,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257537',4903804,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257537',4903805,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257538',4903806,'1661','231',841977.73,845581.71,3603.98,594656.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257538',4903807,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257538',4903808,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257538',4903809,'1664','231',376728.73,380983.63,4254.90,702058.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','257538',4903810,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257538',4903811,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257538',4903812,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257539',4903813,'1661','231',845581.71,848786.39,3204.68,528772.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','257539',4903814,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257539',4903815,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257539',4903816,'1664','231',380983.63,384655.23,3671.60,605814.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257539',4903817,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257539',4903818,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257539',4903819,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257540',4903820,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257540',4903821,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257540',4903822,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257540',4903823,'1664','231',384655.23,385558.35,903.12,149014.80,0.00,0.00,0.00,0.00,0.00),('5','92','599','257540',4903824,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257540',4903825,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257540',4903826,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257541',4903827,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257541',4903828,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257541',4903829,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257541',4903830,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257541',4903831,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257541',4903832,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257541',4903833,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257542',4903834,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257542',4903835,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257542',4903836,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257542',4903837,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257542',4903838,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257542',4903839,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257542',4903840,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257543',4903841,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257543',4903842,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257543',4903843,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257543',4903844,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257543',4903845,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257543',4903846,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257543',4903847,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257544',4903848,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257544',4903849,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257544',4903850,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257544',4903851,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257544',4903852,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257544',4903853,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257544',4903854,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257545',4903855,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257545',4903856,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257545',4903857,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257545',4903858,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257545',4903859,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257545',4903860,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257545',4903861,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257546',4903862,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257546',4903863,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257546',4903864,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257546',4903865,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257546',4903866,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257546',4903867,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257546',4903868,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257547',4903869,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257547',4903870,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257547',4903871,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257547',4903872,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257547',4903873,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257547',4903874,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257547',4903875,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257548',4903876,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257548',4903877,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257548',4903878,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257548',4903879,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257548',4903880,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257548',4903881,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257548',4903882,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257549',4903883,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257549',4903884,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257549',4903885,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257549',4903886,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257549',4903887,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257549',4903888,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257549',4903889,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257550',4903890,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257550',4903891,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257550',4903892,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257550',4903893,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257550',4903894,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257550',4903895,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257550',4903896,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257551',4903897,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257551',4903898,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257551',4903899,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257551',4903900,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257551',4903901,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257551',4903902,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257551',4903903,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257552',4903904,'1661','231',848786.39,848786.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257552',4903905,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257552',4903906,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257552',4903907,'1664','231',385558.35,385558.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257552',4903908,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257552',4903909,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257552',4903910,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257553',4903911,'1661','231',848786.39,849231.41,445.02,73428.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257553',4903912,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257553',4903913,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257553',4903914,'1664','231',385558.35,386696.80,1138.45,187844.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','257553',4903915,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257553',4903916,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257553',4903917,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257554',4903918,'1664','231',386696.80,389884.08,3187.28,525901.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','257554',4903919,'1661','231',849231.41,851255.00,2023.59,333892.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257554',4903920,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257554',4903921,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257554',4903922,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257554',4903923,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257554',4903924,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257555',4903925,'1661','231',851255.00,854347.57,3092.57,510274.05,0.00,0.00,0.00,0.00,0.00),('5','92','598','257555',4903926,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257555',4903927,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257555',4903928,'1664','231',389884.08,394645.93,4761.85,785705.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','257555',4903929,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257555',4903930,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257555',4903931,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257556',4903932,'1661','231',854347.57,857453.96,3106.39,512554.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257556',4903933,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257556',4903934,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257556',4903935,'1664','231',394645.93,401073.47,6427.54,1060544.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257556',4903936,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257556',4903937,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257556',4903938,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257557',4903939,'1664','231',401073.47,402216.66,1143.19,188626.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257557',4903940,'1661','231',857453.96,857453.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257557',4903941,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257557',4903942,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257557',4903943,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257557',4903944,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257557',4903945,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257558',4903946,'1661','231',857453.96,859010.69,1556.73,256860.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','257558',4903947,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257558',4903948,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257558',4903949,'1664','231',402216.66,405187.01,2970.35,490107.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','257558',4903950,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257558',4903951,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257558',4903952,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257559',4903953,'1661','231',859010.69,859010.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257559',4903954,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257559',4903955,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257559',4903956,'1664','231',405187.01,405187.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257559',4903957,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257559',4903958,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257559',4903959,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257560',4903960,'1661','231',859010.69,859010.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257560',4903961,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257560',4903962,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257560',4903963,'1664','231',405187.01,405187.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257560',4903964,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257560',4903965,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257560',4903966,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257561',4903967,'1661','231',859010.69,859010.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257561',4903968,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257561',4903969,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257561',4903970,'1664','231',405187.01,405187.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257561',4903971,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257561',4903972,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257561',4903973,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257562',4903974,'1661','231',859010.69,860986.58,1975.89,326021.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','257562',4903975,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257562',4903976,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257562',4903977,'1664','231',405187.01,407555.26,2368.25,390761.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','257562',4903978,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257562',4903979,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257562',4903980,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257563',4903981,'1664','231',407555.26,410691.28,3136.02,517443.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257563',4903982,'1661','231',860986.58,863419.16,2432.58,401375.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257563',4903983,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257563',4903984,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257563',4903985,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257563',4903986,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257563',4903987,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257564',4903988,'1661','231',863419.16,865241.91,1822.75,300753.75,0.00,0.00,0.00,0.00,0.00),('5','92','598','257564',4903989,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257564',4903990,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257564',4903991,'1664','231',410691.28,412414.12,1722.84,284268.60,0.00,0.00,0.00,0.00,0.00),('5','92','599','257564',4903992,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257564',4903993,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257564',4903994,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257565',4903995,'1661','231',865241.91,866186.80,944.89,155906.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','257565',4903996,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257565',4903997,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257565',4903998,'1664','231',412414.12,413567.80,1153.68,190357.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','257565',4903999,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257565',4904000,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257565',4904001,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257566',4904002,'1661','231',866186.80,866186.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257566',4904003,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257566',4904004,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257566',4904005,'1664','231',413567.80,413567.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257566',4904006,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257566',4904007,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257566',4904008,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257567',4904009,'1664','231',413567.80,413567.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257567',4904010,'1661','231',866186.80,866186.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257567',4904011,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257567',4904012,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257567',4904013,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257567',4904014,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257567',4904015,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257568',4904016,'1661','231',866186.80,866186.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257568',4904017,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257568',4904018,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257568',4904019,'1664','231',413567.80,413567.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257568',4904020,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257568',4904021,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257568',4904022,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257569',4904023,'1661','231',866186.80,866186.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257569',4904024,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257569',4904025,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257569',4904026,'1664','231',413567.80,413567.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257569',4904027,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257569',4904028,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257569',4904029,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257570',4904030,'1661','231',866186.80,866186.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257570',4904031,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257570',4904032,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257570',4904033,'1664','231',413567.80,413567.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257570',4904034,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257570',4904035,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257570',4904036,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257571',4904037,'1661','231',866186.80,866186.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257571',4904038,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257571',4904039,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257571',4904040,'1664','231',413567.80,413567.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257571',4904041,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257571',4904042,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257571',4904043,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257572',4904044,'1661','231',866186.80,867092.58,905.78,149453.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257572',4904045,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257572',4904046,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257572',4904047,'1664','231',413567.80,414213.75,645.95,106581.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','257572',4904048,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257572',4904049,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257572',4904050,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257573',4904051,'1661','231',867092.58,870074.49,2981.91,492015.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','257573',4904052,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257573',4904053,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257573',4904054,'1664','231',414213.75,417510.58,3296.83,543976.95,0.00,0.00,0.00,0.00,0.00),('5','92','599','257573',4904055,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257573',4904056,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257573',4904057,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257574',4904058,'1661','231',870074.49,874237.91,4163.42,686964.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257574',4904059,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257574',4904060,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257574',4904061,'1664','231',417510.58,421993.91,4483.33,739749.45,0.00,0.00,0.00,0.00,0.00),('5','92','599','257574',4904062,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257574',4904063,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257574',4904064,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257575',4904065,'1661','231',874237.91,879312.03,5074.12,837229.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','257575',4904066,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257575',4904067,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257575',4904068,'1664','231',421993.91,426881.24,4887.33,806409.45,0.00,0.00,0.00,0.00,0.00),('5','92','599','257575',4904069,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257575',4904070,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257575',4904071,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257576',4904072,'1661','231',879312.03,880320.82,1008.79,166450.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257576',4904073,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257576',4904074,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257576',4904075,'1664','231',426881.24,429463.21,2581.97,426025.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','257576',4904076,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257576',4904077,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257576',4904078,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257577',4904079,'1661','231',880320.82,880320.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257577',4904080,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257577',4904081,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257577',4904082,'1664','231',429463.21,429463.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257577',4904083,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257577',4904084,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257577',4904085,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257578',4904086,'1661','231',880320.82,880320.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257578',4904087,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257578',4904088,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257578',4904089,'1664','231',429463.21,429463.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257578',4904090,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257578',4904091,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257578',4904092,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257579',4904093,'1661','231',880320.82,880320.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257579',4904094,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257579',4904095,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257579',4904096,'1664','231',429463.21,429463.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257579',4904097,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257579',4904098,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257579',4904099,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257580',4904100,'1661','231',880320.82,882599.24,2278.42,375939.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257580',4904101,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257580',4904102,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257580',4904103,'1664','231',429463.21,432946.26,3483.05,574703.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','257580',4904104,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257580',4904105,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257580',4904106,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257581',4904107,'1661','231',882599.24,887272.64,4673.40,771111.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257581',4904108,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257581',4904109,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257581',4904110,'1664','231',432946.26,438618.94,5672.68,935992.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','257581',4904111,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257581',4904112,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257581',4904113,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257582',4904114,'1661','231',887272.64,890035.08,2762.44,455802.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257582',4904115,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257582',4904116,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257582',4904117,'1664','231',438618.94,442287.12,3668.18,605249.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','257582',4904118,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257582',4904119,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257582',4904120,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257583',4904121,'1661','231',890035.08,892638.77,2603.69,429608.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','257583',4904122,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257583',4904123,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257583',4904124,'1664','231',442287.12,444074.49,1787.37,294916.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','257583',4904125,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257583',4904126,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257583',4904127,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257584',4904128,'1661','231',892638.77,892638.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257584',4904129,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257584',4904130,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257584',4904131,'1664','231',444074.49,446058.99,1984.50,327442.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','257584',4904132,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257584',4904133,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257584',4904134,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257585',4904135,'1661','231',892638.77,893791.58,1152.81,190213.65,0.00,0.00,0.00,0.00,0.00),('5','92','598','257585',4904136,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257585',4904137,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257585',4904138,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257585',4904139,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257585',4904140,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257585',4904141,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257586',4904142,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257586',4904143,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257586',4904144,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257586',4904145,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257586',4904146,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257586',4904147,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257586',4904148,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257587',4904149,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257587',4904150,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257587',4904151,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257587',4904152,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257587',4904153,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257587',4904154,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257587',4904155,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257588',4904156,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257588',4904157,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257588',4904158,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257588',4904159,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257588',4904160,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257588',4904161,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257588',4904162,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257589',4904163,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257589',4904164,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257589',4904165,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257589',4904166,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257589',4904167,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257589',4904168,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257589',4904169,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257590',4904170,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257590',4904171,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257590',4904172,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257590',4904173,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257590',4904174,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257590',4904175,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257590',4904176,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257591',4904177,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257591',4904178,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257591',4904179,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257591',4904180,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257591',4904181,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257591',4904182,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257591',4904183,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257592',4904184,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257592',4904185,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257592',4904186,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257592',4904187,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257592',4904188,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257592',4904189,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257592',4904190,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257593',4904191,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257593',4904192,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257593',4904193,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257593',4904194,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257593',4904195,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257593',4904196,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257593',4904197,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257594',4904198,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257594',4904199,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257594',4904200,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257594',4904201,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257594',4904202,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257594',4904203,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257594',4904204,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257595',4904205,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257595',4904206,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257595',4904207,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257595',4904208,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257595',4904209,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257595',4904210,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257595',4904211,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257596',4904212,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257596',4904213,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257596',4904214,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257596',4904215,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257596',4904216,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257596',4904217,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257596',4904218,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257597',4904219,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257597',4904220,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257597',4904221,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257597',4904222,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257597',4904223,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257597',4904224,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257597',4904225,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257598',4904226,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257598',4904227,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257598',4904228,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257598',4904229,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257598',4904230,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257598',4904231,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257598',4904232,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257599',4904233,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257599',4904234,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257599',4904235,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257599',4904236,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257599',4904237,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257599',4904238,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257599',4904239,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257600',4904240,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257600',4904241,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257600',4904242,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257600',4904243,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257600',4904244,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257600',4904245,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257600',4904246,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257601',4904247,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257601',4904248,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257601',4904249,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257601',4904250,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257601',4904251,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257601',4904252,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257601',4904253,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257602',4904254,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257602',4904255,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257602',4904256,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257602',4904257,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257602',4904258,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257602',4904259,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257602',4904260,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257603',4904261,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257603',4904262,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257603',4904263,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257603',4904264,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257603',4904265,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257603',4904266,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257603',4904267,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257604',4904268,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257604',4904269,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257604',4904270,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257604',4904271,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257604',4904272,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257604',4904273,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257604',4904274,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257605',4904275,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257605',4904276,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257605',4904277,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257605',4904278,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257605',4904279,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257605',4904280,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257605',4904281,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257606',4904282,'1661','231',893791.58,893791.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257606',4904283,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257606',4904284,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257606',4904285,'1664','231',446058.99,446058.99,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257606',4904286,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257606',4904287,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257606',4904288,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257607',4904289,'1661','231',893791.58,895704.55,1912.97,315640.05,0.00,0.00,0.00,0.00,0.00),('5','92','598','257607',4904290,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257607',4904291,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257607',4904292,'1664','231',446058.99,448709.00,2650.01,437251.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257607',4904293,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257607',4904294,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257607',4904295,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257608',4904296,'1661','231',895704.55,897922.81,2218.26,366012.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257608',4904297,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257608',4904298,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257608',4904299,'1664','231',448709.00,450971.86,2262.86,373371.90,0.00,0.00,0.00,0.00,0.00),('5','92','599','257608',4904300,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257608',4904301,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257608',4904302,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257609',4904303,'1661','231',897922.81,897922.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257609',4904304,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257609',4904305,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257609',4904306,'1664','231',450971.86,452571.86,1600.00,264000.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257609',4904307,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257609',4904308,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257609',4904309,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257610',4904310,'1661','231',897922.81,899620.11,1697.30,280054.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','257610',4904311,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257610',4904312,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257610',4904313,'1664','231',452571.86,453347.74,775.88,128020.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','257610',4904314,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257610',4904315,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257610',4904316,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257611',4904317,'1661','231',899620.11,900665.76,1045.65,172532.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257611',4904318,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257611',4904319,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257611',4904320,'1664','231',453347.74,453933.10,585.36,96584.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','257611',4904321,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257611',4904322,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257611',4904323,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257612',4904324,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257612',4904325,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257612',4904326,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257612',4904327,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257612',4904328,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257612',4904329,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257612',4904330,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257613',4904331,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257613',4904332,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257613',4904333,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257613',4904334,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257613',4904335,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257613',4904336,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257613',4904337,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257614',4904338,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257614',4904339,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257614',4904340,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257614',4904341,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257614',4904342,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257614',4904343,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257614',4904344,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257615',4904345,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257615',4904346,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257615',4904347,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257615',4904348,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257615',4904349,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257615',4904350,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257615',4904351,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257616',4904352,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257616',4904353,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257616',4904354,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257616',4904355,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257616',4904356,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257616',4904357,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257616',4904358,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257617',4904359,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257617',4904360,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257617',4904361,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257617',4904362,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257617',4904363,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257617',4904364,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257617',4904365,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257618',4904366,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257618',4904367,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257618',4904368,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257618',4904369,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257618',4904370,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257618',4904371,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257618',4904372,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257619',4904373,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257619',4904374,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257619',4904375,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257619',4904376,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257619',4904377,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257619',4904378,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257619',4904379,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257620',4904380,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257620',4904381,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257620',4904382,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257620',4904383,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257620',4904384,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257620',4904385,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257620',4904386,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257621',4904387,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257621',4904388,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257621',4904389,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257621',4904390,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257621',4904391,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257621',4904392,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257621',4904393,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257622',4904394,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257622',4904395,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257622',4904396,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257622',4904397,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257622',4904398,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257622',4904399,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257622',4904400,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257623',4904401,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257623',4904402,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257623',4904403,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257623',4904404,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257623',4904405,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257623',4904406,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257623',4904407,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257624',4904408,'1661','231',900665.76,900665.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257624',4904409,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257624',4904410,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257624',4904411,'1664','231',453933.10,453933.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257624',4904412,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257624',4904413,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257624',4904414,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257625',4904415,'1661','231',900665.76,901825.24,1159.48,191314.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','257625',4904416,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257625',4904417,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257625',4904418,'1664','231',453933.10,454841.39,908.29,149867.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','257625',4904419,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257625',4904420,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257625',4904421,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257626',4904422,'1661','231',901825.24,903985.23,2159.99,356398.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257626',4904423,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257626',4904424,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257626',4904425,'1664','231',454841.39,456985.33,2143.94,353750.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257626',4904426,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257626',4904427,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257626',4904428,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257627',4904429,'1664','231',456985.33,460365.34,3380.01,557701.65,0.00,0.00,0.00,0.00,0.00),('5','92','598','257627',4904430,'1661','231',903985.23,905044.98,1059.75,174858.75,0.00,0.00,0.00,0.00,0.00),('5','92','598','257627',4904431,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257627',4904432,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257627',4904433,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257627',4904434,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257627',4904435,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257628',4904436,'1664','231',460365.34,463397.88,3032.54,561019.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257628',4904437,'1661','231',905044.98,907541.62,2496.64,461878.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257628',4904438,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257628',4904439,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257628',4904440,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257628',4904441,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257628',4904442,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257629',4904443,'1661','231',907541.62,909811.87,2270.25,419996.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257629',4904444,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257629',4904445,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257629',4904446,'1664','231',463397.88,465608.75,2210.87,409010.95,0.00,0.00,0.00,0.00,0.00),('5','92','599','257629',4904447,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257629',4904448,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257629',4904449,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257630',4904450,'1661','231',909811.87,911667.51,1855.64,343293.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257630',4904451,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257630',4904452,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257630',4904453,'1664','231',465608.75,467171.24,1562.49,289060.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257630',4904454,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257630',4904455,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257630',4904456,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257631',4904457,'1661','231',911667.51,912857.85,1190.34,220212.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257631',4904458,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257631',4904459,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257631',4904460,'1664','231',467171.24,469368.87,2197.63,406561.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','257631',4904461,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257631',4904462,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257631',4904463,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257632',4904464,'1661','231',912857.85,913176.81,318.96,59007.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257632',4904465,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257632',4904466,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257632',4904467,'1664','231',469368.87,471523.66,2154.79,398636.15,0.00,0.00,0.00,0.00,0.00),('5','92','599','257632',4904468,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257632',4904469,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257632',4904470,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257633',4904471,'1661','231',913176.81,914792.47,1615.66,266583.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257633',4904472,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257633',4904473,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257633',4904474,'1664','231',471523.66,475194.81,3671.15,605739.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','257633',4904475,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257633',4904476,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257633',4904477,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257634',4904478,'1661','231',914792.47,917118.25,2325.78,383753.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257634',4904479,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257634',4904480,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257634',4904481,'1664','231',475194.81,480733.98,5539.17,913963.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','257634',4904482,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257634',4904483,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257634',4904484,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257635',4904485,'1661','231',917118.25,919531.14,2412.89,446384.65,0.00,0.00,0.00,0.00,0.00),('5','92','598','257635',4904486,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257635',4904487,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257635',4904488,'1664','231',480733.98,482927.67,2193.69,405832.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257635',4904489,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257635',4904490,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257635',4904491,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257636',4904492,'1661','231',919531.14,920983.18,1452.04,268627.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257636',4904493,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257636',4904494,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257636',4904495,'1664','231',482927.67,486044.93,3117.26,576693.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257636',4904496,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257636',4904497,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257636',4904498,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257637',4904499,'1664','231',486044.93,492956.27,6911.34,1278597.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257637',4904500,'1661','231',920983.18,925440.40,4457.22,824585.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257637',4904501,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257637',4904502,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257637',4904503,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257637',4904504,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257637',4904505,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257638',4904506,'1661','231',925440.40,928157.50,2717.10,502663.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','257638',4904507,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257638',4904508,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257638',4904509,'1664','231',492956.27,498646.89,5690.62,1052764.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','257638',4904510,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257638',4904511,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257638',4904512,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257639',4904513,'1661','231',928157.50,931747.87,3590.37,664218.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','257639',4904514,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257639',4904515,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257639',4904516,'1664','231',498646.89,504206.78,5559.89,1028579.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257639',4904517,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257639',4904518,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257639',4904519,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257640',4904520,'1661','231',931747.87,934330.76,2582.89,477834.65,0.00,0.00,0.00,0.00,0.00),('5','92','598','257640',4904521,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257640',4904522,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257640',4904523,'1664','231',504206.78,508066.29,3859.51,714009.35,0.00,0.00,0.00,0.00,0.00),('5','92','599','257640',4904524,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257640',4904525,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257640',4904526,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257641',4904527,'1664','231',508066.29,511247.32,3181.03,588490.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','257641',4904528,'1661','231',934330.76,936744.09,2413.33,446466.05,0.00,0.00,0.00,0.00,0.00),('5','92','598','257641',4904529,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257641',4904530,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257641',4904531,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257641',4904532,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257641',4904533,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257642',4904534,'1661','231',936744.09,938674.32,1930.23,357092.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','257642',4904535,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257642',4904536,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257642',4904537,'1664','231',511247.32,513910.15,2662.83,492623.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','257642',4904538,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257642',4904539,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257642',4904540,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257643',4904541,'1661','231',938674.32,941614.25,2939.93,543887.05,0.00,0.00,0.00,0.00,0.00),('5','92','598','257643',4904542,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257643',4904543,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257643',4904544,'1664','231',513910.15,519078.44,5168.29,956133.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257643',4904545,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257643',4904546,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257643',4904547,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257644',4904548,'1661','231',941614.25,944390.16,2775.91,513543.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257644',4904549,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257644',4904550,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257644',4904551,'1664','231',519078.44,521692.34,2613.90,483571.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','257644',4904552,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257644',4904553,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257644',4904554,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257645',4904555,'1661','231',944390.16,949466.70,5076.54,939159.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257645',4904556,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257645',4904557,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257645',4904558,'1664','231',521692.34,528562.47,6870.13,1270974.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','257645',4904559,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257645',4904560,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257645',4904561,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257646',4904562,'1661','231',949466.70,949566.49,99.79,18461.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','257646',4904563,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257646',4904564,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257646',4904565,'1664','231',528562.47,528744.31,181.84,33640.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','257646',4904566,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257646',4904567,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257646',4904568,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257647',4904569,'1661','231',949566.49,949566.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257647',4904570,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257647',4904571,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257647',4904572,'1664','231',528744.31,528744.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257647',4904573,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257647',4904574,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257647',4904575,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257648',4904576,'1661','231',949566.49,949566.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257648',4904577,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257648',4904578,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257648',4904579,'1664','231',528744.31,528744.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257648',4904580,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257648',4904581,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257648',4904582,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257649',4904583,'1664','231',528744.31,528744.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257649',4904584,'1661','231',949566.49,949566.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257649',4904585,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257649',4904586,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257649',4904587,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257649',4904588,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257649',4904589,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257650',4904590,'1661','231',949566.49,949566.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257650',4904591,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257650',4904592,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257650',4904593,'1664','231',528744.31,528744.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257650',4904594,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257650',4904595,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257650',4904596,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257651',4904597,'1661','231',949566.49,951852.70,2286.21,422948.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','257651',4904598,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257651',4904599,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257651',4904600,'1664','231',528744.31,531441.21,2696.90,498926.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','257651',4904601,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257651',4904602,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257651',4904603,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257652',4904604,'1661','231',951852.70,953805.11,1952.41,361195.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','257652',4904605,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257652',4904606,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257652',4904607,'1664','231',531441.21,535048.47,3607.26,667343.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257652',4904608,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257652',4904609,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257652',4904610,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257653',4904611,'1661','231',953805.11,956670.46,2865.35,530089.75,0.00,0.00,0.00,0.00,0.00),('5','92','598','257653',4904612,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257653',4904613,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257653',4904614,'1664','231',535048.47,538342.30,3293.83,609358.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','257653',4904615,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257653',4904616,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257653',4904617,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257654',4904618,'1661','231',956670.46,961582.16,4911.70,908664.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','257654',4904619,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257654',4904620,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257654',4904621,'1664','231',538342.30,543882.31,5540.01,1024901.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','257654',4904622,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257654',4904623,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257654',4904624,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257655',4904625,'1661','231',961582.16,963092.80,1510.64,279468.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257655',4904626,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257655',4904627,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257655',4904628,'1664','231',543882.31,545527.80,1645.49,304415.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257655',4904629,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257655',4904630,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257655',4904631,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257656',4904632,'1664','231',545527.80,545527.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257656',4904633,'1661','231',963092.80,963092.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257656',4904634,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257656',4904635,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257656',4904636,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257656',4904637,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257656',4904638,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257657',4904639,'1661','231',963092.80,963092.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257657',4904640,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257657',4904641,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257657',4904642,'1664','231',545527.80,545527.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257657',4904643,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257657',4904644,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257657',4904645,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257658',4904646,'1661','231',963092.80,963092.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257658',4904647,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257658',4904648,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257658',4904649,'1664','231',545527.80,545527.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257658',4904650,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257658',4904651,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257658',4904652,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257659',4904653,'1661','231',963092.80,963861.82,769.02,142268.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257659',4904654,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257659',4904655,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257659',4904656,'1664','231',545527.80,546043.23,515.43,95354.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','257659',4904657,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257659',4904658,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257659',4904659,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257660',4904660,'1661','231',963861.82,965201.52,1339.70,247844.50,0.00,0.00,0.00,0.00,0.00),('5','92','598','257660',4904661,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257660',4904662,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257660',4904663,'1664','231',546043.23,548593.06,2549.83,471718.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','257660',4904664,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257660',4904665,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257660',4904666,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257661',4904667,'1661','231',965201.52,967641.28,2439.76,451355.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257661',4904668,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257661',4904669,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257661',4904670,'1664','231',548593.06,551171.36,2578.30,476985.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','257661',4904671,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257661',4904672,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257661',4904673,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257662',4904674,'1661','231',967641.28,969502.84,1861.56,344388.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257662',4904675,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257662',4904676,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257662',4904677,'1664','231',551171.36,553152.83,1981.47,366571.95,0.00,0.00,0.00,0.00,0.00),('5','92','599','257662',4904678,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257662',4904679,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257662',4904680,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257663',4904681,'1661','231',969502.84,971597.38,2094.54,387489.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257663',4904682,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257663',4904683,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257663',4904684,'1664','231',553152.83,556429.27,3276.44,606141.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','257663',4904685,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257663',4904686,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257663',4904687,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257664',4904688,'1661','231',971597.38,973486.56,1889.18,349498.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257664',4904689,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257664',4904690,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257664',4904691,'1664','231',556429.27,559003.95,2574.68,476315.80,0.00,0.00,0.00,0.00,0.00),('5','92','599','257664',4904692,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257664',4904693,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257664',4904694,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257665',4904695,'1664','231',559003.95,561347.19,2343.24,433499.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257665',4904696,'1661','231',973486.56,975173.85,1687.29,312148.65,0.00,0.00,0.00,0.00,0.00),('5','92','598','257665',4904697,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257665',4904698,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257665',4904699,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257665',4904700,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257665',4904701,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257666',4904702,'1661','231',975173.85,975873.03,699.18,129348.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257666',4904703,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257666',4904704,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257666',4904705,'1664','231',561347.19,563033.65,1686.46,311995.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257666',4904706,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257666',4904707,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257666',4904708,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257667',4904709,'1661','231',975873.03,978008.20,2135.17,395006.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','257667',4904710,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257667',4904711,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257667',4904712,'1664','231',563033.65,565589.17,2555.52,472771.20,0.00,0.00,0.00,0.00,0.00),('5','92','599','257667',4904713,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257667',4904714,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257667',4904715,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257668',4904716,'1661','231',978008.20,979895.18,1886.98,349091.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257668',4904717,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257668',4904718,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257668',4904719,'1664','231',565589.17,568600.18,3011.01,557036.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','257668',4904720,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257668',4904721,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257668',4904722,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257669',4904723,'1661','231',979895.18,980787.42,892.24,165064.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257669',4904724,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257669',4904725,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257669',4904726,'1664','231',568600.18,569728.54,1128.36,208746.60,0.00,0.00,0.00,0.00,0.00),('5','92','599','257669',4904727,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257669',4904728,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257669',4904729,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257670',4904730,'1661','231',980787.42,983118.13,2330.71,431181.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257670',4904731,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257670',4904732,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257670',4904733,'1664','231',569728.54,573256.41,3527.87,652655.95,0.00,0.00,0.00,0.00,0.00),('5','92','599','257670',4904734,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257670',4904735,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257670',4904736,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257671',4904737,'1661','231',983118.13,984749.70,1631.57,301840.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','257671',4904738,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257671',4904739,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257671',4904740,'1664','231',573256.41,576411.15,3154.74,583626.90,0.00,0.00,0.00,0.00,0.00),('5','92','599','257671',4904741,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257671',4904742,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257671',4904743,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257672',4904744,'1661','231',984749.70,986148.19,1398.49,258720.65,0.00,0.00,0.00,0.00,0.00),('5','92','598','257672',4904745,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257672',4904746,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257672',4904747,'1664','231',576411.15,578637.01,2225.86,411784.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257672',4904748,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257672',4904749,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257672',4904750,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257673',4904751,'1661','231',986148.19,987841.47,1693.28,313256.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','257673',4904752,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257673',4904753,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257673',4904754,'1664','231',578637.01,580877.24,2240.23,414442.55,0.00,0.00,0.00,0.00,0.00),('5','92','599','257673',4904755,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257673',4904756,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257673',4904757,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257674',4904758,'1661','231',987841.47,989752.46,1910.99,353533.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','257674',4904759,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257674',4904760,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257674',4904761,'1664','231',580877.24,583968.19,3090.95,571825.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','257674',4904762,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257674',4904763,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257674',4904764,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257675',4904765,'1661','231',989752.46,991430.64,1678.18,310463.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257675',4904766,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257675',4904767,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257675',4904768,'1664','231',583968.19,585768.16,1799.97,332994.45,0.00,0.00,0.00,0.00,0.00),('5','92','599','257675',4904769,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257675',4904770,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257675',4904771,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257676',4904772,'1661','231',991430.64,993850.50,2419.86,447674.10,0.00,0.00,0.00,0.00,0.00),('5','92','598','257676',4904773,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257676',4904774,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257676',4904775,'1664','231',585768.16,585768.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257676',4904776,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257676',4904777,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257676',4904778,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257677',4904779,'1661','231',993850.50,996675.57,2825.07,522637.95,0.00,0.00,0.00,0.00,0.00),('5','92','598','257677',4904780,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257677',4904781,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257677',4904782,'1664','231',585768.16,587488.72,1720.56,318303.60,0.00,0.00,0.00,0.00,0.00),('5','92','599','257677',4904783,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257677',4904784,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257677',4904785,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257678',4904786,'1661','231',996675.57,999177.48,2501.91,462853.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257678',4904787,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257678',4904788,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257678',4904789,'1664','231',587488.72,587488.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257678',4904790,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257678',4904791,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257678',4904792,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257679',4904793,'1661','231',999177.48,1002102.93,2925.45,541208.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257679',4904794,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257679',4904795,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257679',4904796,'1664','231',587488.72,589992.90,2504.18,463273.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','257679',4904797,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257679',4904798,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257679',4904799,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257680',4904800,'1661','231',1002102.93,1005153.33,3050.40,564324.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257680',4904801,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257680',4904802,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257680',4904803,'1664','231',589992.90,590302.41,309.51,57259.35,0.00,0.00,0.00,0.00,0.00),('5','92','599','257680',4904804,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257680',4904805,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257680',4904806,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257681',4904807,'1661','231',1005153.33,1007744.02,2590.69,479277.65,0.00,0.00,0.00,0.00,0.00),('5','92','598','257681',4904808,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257681',4904809,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257681',4904810,'1664','231',590302.41,593424.42,3122.01,577571.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','257681',4904811,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257681',4904812,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257681',4904813,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257682',4904814,'1661','231',1007744.02,1009109.22,1365.20,252562.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257682',4904815,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257682',4904816,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257682',4904817,'1664','231',593424.42,596265.83,2841.41,525660.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','257682',4904818,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257682',4904819,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257682',4904820,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257683',4904821,'1661','231',1009109.22,1009109.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257683',4904822,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257683',4904823,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257683',4904824,'1664','231',596265.83,596426.22,160.39,29672.15,0.00,0.00,0.00,0.00,0.00),('5','92','599','257683',4904825,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257683',4904826,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257683',4904827,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257684',4904828,'1661','231',1009109.22,1009109.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257684',4904829,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257684',4904830,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257684',4904831,'1664','231',596426.22,596426.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257684',4904832,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257684',4904833,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257684',4904834,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257685',4904835,'1661','231',1009109.22,1010047.44,938.22,173570.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257685',4904836,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257685',4904837,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257685',4904838,'1664','231',596426.22,598333.15,1906.93,352782.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','257685',4904839,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257685',4904840,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257685',4904841,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257686',4904842,'1661','231',1010047.44,1012580.29,2532.85,468577.25,0.00,0.00,0.00,0.00,0.00),('5','92','598','257686',4904843,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257686',4904844,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257686',4904845,'1664','231',598333.15,601244.24,2911.09,538551.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257686',4904846,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257686',4904847,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257686',4904848,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257687',4904849,'1661','231',1012580.29,1014204.41,1624.12,300462.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','257687',4904850,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257687',4904851,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257687',4904852,'1664','231',601244.24,603157.49,1913.25,353951.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','257687',4904853,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257687',4904854,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257687',4904855,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257688',4904856,'1661','231',1014204.41,1016488.01,2283.60,422466.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257688',4904857,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257688',4904858,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257688',4904859,'1664','231',603157.49,606796.35,3638.86,673189.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257688',4904860,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257688',4904861,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257688',4904862,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257689',4904863,'1661','231',1016488.01,1017570.45,1082.44,200251.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257689',4904864,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257689',4904865,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257689',4904866,'1664','231',606796.35,608830.77,2034.42,376367.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','257689',4904867,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257689',4904868,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257689',4904869,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257690',4904870,'1661','231',1017570.45,1017570.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257690',4904871,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257690',4904872,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257690',4904873,'1664','231',608830.77,608830.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257690',4904874,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257690',4904875,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257690',4904876,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257691',4904877,'1661','231',1017570.45,1017570.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257691',4904878,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257691',4904879,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257691',4904880,'1664','231',608830.77,608830.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257691',4904881,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257691',4904882,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257691',4904883,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257692',4904884,'1661','231',1017570.45,1017570.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257692',4904885,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257692',4904886,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257692',4904887,'1664','231',608830.77,608830.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257692',4904888,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257692',4904889,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257692',4904890,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257693',4904891,'1661','231',1017570.45,1017570.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257693',4904892,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257693',4904893,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257693',4904894,'1664','231',608830.77,608830.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257693',4904895,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257693',4904896,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257693',4904897,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257694',4904898,'1661','231',1017570.45,1017570.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257694',4904899,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257694',4904900,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257694',4904901,'1664','231',608830.77,608830.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257694',4904902,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257694',4904903,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257694',4904904,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257695',4904905,'1661','231',1017570.45,1018453.44,882.99,163353.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','257695',4904906,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257695',4904907,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257695',4904908,'1664','231',608830.77,610134.46,1303.69,241182.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257695',4904909,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257695',4904910,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257695',4904911,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257696',4904912,'1661','231',1018453.44,1018453.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257696',4904913,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257696',4904914,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257696',4904915,'1664','231',610134.46,610134.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257696',4904916,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257696',4904917,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257696',4904918,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257697',4904919,'1661','231',1018453.44,1019934.18,1480.74,273936.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257697',4904920,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257697',4904921,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257697',4904922,'1664','231',610134.46,612896.11,2761.65,510905.25,0.00,0.00,0.00,0.00,0.00),('5','92','599','257697',4904923,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257697',4904924,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257697',4904925,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257698',4904926,'1661','231',1019934.18,1021481.96,1547.78,286339.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257698',4904927,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257698',4904928,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257698',4904929,'1664','231',612896.11,616302.32,3406.21,630148.85,0.00,0.00,0.00,0.00,0.00),('5','92','599','257698',4904930,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257698',4904931,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257698',4904932,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257699',4904933,'1661','231',1021481.96,1022675.12,1193.16,220734.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257699',4904934,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257699',4904935,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257699',4904936,'1664','231',616302.32,618825.03,2522.71,466701.35,0.00,0.00,0.00,0.00,0.00),('5','92','599','257699',4904937,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257699',4904938,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257699',4904939,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257700',4904940,'1661','231',1022675.12,1022675.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257700',4904941,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257700',4904942,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257700',4904943,'1664','231',618825.03,618825.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257700',4904944,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257700',4904945,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257700',4904946,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257701',4904947,'1661','231',1022675.12,1023066.98,391.86,72494.10,0.00,0.00,0.00,0.00,0.00),('5','92','598','257701',4904948,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257701',4904949,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257701',4904950,'1664','231',618825.03,620600.72,1775.69,328502.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257701',4904951,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257701',4904952,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257701',4904953,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257702',4904954,'1661','231',1023066.98,1023917.60,850.62,157364.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257702',4904955,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257702',4904956,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257702',4904957,'1664','231',620600.72,622446.98,1846.26,341558.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257702',4904958,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257702',4904959,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257702',4904960,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257703',4904961,'1661','231',1023917.60,1026212.58,2294.98,424571.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257703',4904962,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257703',4904963,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257703',4904964,'1664','231',622446.98,626009.18,3562.20,659007.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257703',4904965,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257703',4904966,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257703',4904967,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257704',4904968,'1661','231',1026212.58,1027842.44,1629.86,301524.10,0.00,0.00,0.00,0.00,0.00),('5','92','598','257704',4904969,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257704',4904970,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257704',4904971,'1664','231',626009.18,628218.11,2208.93,408652.05,0.00,0.00,0.00,0.00,0.00),('5','92','599','257704',4904972,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257704',4904973,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257704',4904974,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257705',4904975,'1664','231',628218.11,631766.25,3548.14,656405.90,0.00,0.00,0.00,0.00,0.00),('5','92','598','257705',4904976,'1661','231',1027842.44,1029249.63,1407.19,260330.15,0.00,0.00,0.00,0.00,0.00),('5','92','598','257705',4904977,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257705',4904978,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257705',4904979,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257705',4904980,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257705',4904981,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257706',4904982,'1661','231',1029249.63,1031805.21,2555.58,472782.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257706',4904983,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257706',4904984,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257706',4904985,'1664','231',631766.25,635201.23,3434.98,635471.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','257706',4904986,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257706',4904987,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257706',4904988,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257707',4904989,'1661','231',1031805.21,1033267.24,1462.03,270475.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','257707',4904990,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257707',4904991,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257707',4904992,'1664','231',635201.23,637806.18,2604.95,481915.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','257707',4904993,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257707',4904994,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257707',4904995,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257708',4904996,'1661','231',1033267.24,1033267.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257708',4904997,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257708',4904998,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257708',4904999,'1664','231',637806.18,637806.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257708',4905000,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257708',4905001,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257708',4905002,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257709',4905003,'1661','231',1033267.24,1033267.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257709',4905004,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257709',4905005,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257709',4905006,'1664','231',637806.18,637806.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257709',4905007,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257709',4905008,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257709',4905009,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257710',4905010,'1661','231',1033267.24,1033267.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257710',4905011,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257710',4905012,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257710',4905013,'1664','231',637806.18,637806.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257710',4905014,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257710',4905015,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257710',4905016,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257711',4905017,'1661','231',1033267.24,1034129.41,862.17,159501.45,0.00,0.00,0.00,0.00,0.00),('5','92','598','257711',4905018,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257711',4905019,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257711',4905020,'1664','231',637806.18,639070.96,1264.78,233984.30,0.00,0.00,0.00,0.00,0.00),('5','92','599','257711',4905021,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257711',4905022,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257711',4905023,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257712',4905024,'1661','231',1034129.41,1035494.63,1365.22,252565.70,0.00,0.00,0.00,0.00,0.00),('5','92','598','257712',4905025,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257712',4905026,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257712',4905027,'1664','231',639070.96,642217.20,3146.24,582054.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','257712',4905028,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257712',4905029,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257712',4905030,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257713',4905031,'1661','231',1035494.63,1037242.59,1747.96,323372.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257713',4905032,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257713',4905033,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257713',4905034,'1664','231',642217.20,645028.56,2811.36,520101.60,0.00,0.00,0.00,0.00,0.00),('5','92','599','257713',4905035,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257713',4905036,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257713',4905037,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257714',4905038,'1661','231',1037242.59,1039370.11,2127.52,393591.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','257714',4905039,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257714',4905040,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257714',4905041,'1664','231',645028.56,648537.86,3509.30,649220.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','257714',4905042,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257714',4905043,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257714',4905044,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257715',4905045,'1661','231',1039370.11,1041671.99,2301.88,425847.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','257715',4905046,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257715',4905047,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257715',4905048,'1664','231',648537.86,651140.46,2602.60,481481.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257715',4905049,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257715',4905050,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257715',4905051,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257716',4905052,'1661','231',1041671.99,1043762.11,2090.12,386672.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','257716',4905053,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257716',4905054,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257716',4905055,'1664','231',651140.46,655355.90,4215.44,779856.40,0.00,0.00,0.00,0.00,0.00),('5','92','599','257716',4905056,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257716',4905057,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257716',4905058,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257717',4905059,'1661','231',1043762.11,1047132.95,3370.84,623605.40,0.00,0.00,0.00,0.00,0.00),('5','92','598','257717',4905060,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257717',4905061,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257717',4905062,'1664','231',655355.90,659702.18,4346.28,804061.80,0.00,0.00,0.00,0.00,0.00),('5','92','599','257717',4905063,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257717',4905064,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257717',4905065,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257718',4905066,'1661','231',1047132.95,1050963.96,3831.01,708736.85,0.00,0.00,0.00,0.00,0.00),('5','92','598','257718',4905067,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257718',4905068,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257718',4905069,'1664','231',659702.18,665419.17,5716.99,1057643.15,0.00,0.00,0.00,0.00,0.00),('5','92','599','257718',4905070,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257718',4905071,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257718',4905072,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257719',4905073,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257719',4905074,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257719',4905075,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257719',4905076,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257719',4905077,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257719',4905078,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257719',4905079,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257720',4905080,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257720',4905081,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257720',4905082,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257720',4905083,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257720',4905084,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257720',4905085,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257720',4905086,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257721',4905087,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257721',4905088,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257721',4905089,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257721',4905090,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257721',4905091,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257721',4905092,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257721',4905093,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257722',4905094,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257722',4905095,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257722',4905096,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257722',4905097,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257722',4905098,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257722',4905099,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257722',4905100,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257723',4905101,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257723',4905102,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257723',4905103,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257723',4905104,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257723',4905105,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257723',4905106,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257723',4905107,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257724',4905108,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257724',4905109,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257724',4905110,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257724',4905111,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257724',4905112,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257724',4905113,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257724',4905114,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257725',4905115,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257725',4905116,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257725',4905117,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257725',4905118,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257725',4905119,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257725',4905120,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257725',4905121,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257726',4905122,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257726',4905123,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257726',4905124,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257726',4905125,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257726',4905126,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257726',4905127,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257726',4905128,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257727',4905129,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257727',4905130,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257727',4905131,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257727',4905132,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257727',4905133,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257727',4905134,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257727',4905135,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257728',4905136,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257728',4905137,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257728',4905138,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257728',4905139,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257728',4905140,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257728',4905141,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257728',4905142,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257729',4905143,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257729',4905144,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257729',4905145,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257729',4905146,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257729',4905147,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257729',4905148,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257729',4905149,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257730',4905150,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257730',4905151,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257730',4905152,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257730',4905153,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257730',4905154,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257730',4905155,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257730',4905156,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257731',4905157,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257731',4905158,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257731',4905159,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257731',4905160,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257731',4905161,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257731',4905162,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257731',4905163,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257732',4905164,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257732',4905165,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257732',4905166,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257732',4905167,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257732',4905168,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257732',4905169,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257732',4905170,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257733',4905171,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257733',4905172,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257733',4905173,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257733',4905174,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257733',4905175,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257733',4905176,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257733',4905177,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257734',4905178,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257734',4905179,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257734',4905180,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257734',4905181,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257734',4905182,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257734',4905183,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257734',4905184,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257735',4905185,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257735',4905186,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257735',4905187,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257735',4905188,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257735',4905189,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257735',4905190,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257735',4905191,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257736',4905192,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257736',4905193,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257736',4905194,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257736',4905195,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257736',4905196,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257736',4905197,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257736',4905198,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257737',4905199,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257737',4905200,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257737',4905201,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257737',4905202,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257737',4905203,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257737',4905204,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257737',4905205,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257738',4905206,'1661','231',1050963.96,1050963.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257738',4905207,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257738',4905208,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257738',4905209,'1664','231',665419.17,665419.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257738',4905210,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257738',4905211,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257738',4905212,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257739',4905213,'1661','231',1050963.96,1052655.19,1691.23,312877.55,0.00,0.00,0.00,0.00,0.00),('5','92','598','257739',4905214,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257739',4905215,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257739',4905216,'1664','231',665419.17,666291.39,872.22,161360.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','257739',4905217,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257739',4905218,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257739',4905219,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257740',4905220,'1661','231',1052655.19,1056898.17,4242.98,784951.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257740',4905221,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257740',4905222,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257740',4905223,'1664','231',666291.39,669365.94,3074.55,568791.75,0.00,0.00,0.00,0.00,0.00),('5','92','599','257740',4905224,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257740',4905225,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257740',4905226,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257741',4905227,'1661','231',1056898.17,1061719.90,4821.73,892020.05,0.00,0.00,0.00,0.00,0.00),('5','92','598','257741',4905228,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257741',4905229,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257741',4905230,'1664','231',669365.94,674479.43,5113.49,945995.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257741',4905231,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257741',4905232,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257741',4905233,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257742',4905234,'1661','231',1061719.90,1067844.06,6124.16,1132969.60,0.00,0.00,0.00,0.00,0.00),('5','92','598','257742',4905235,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257742',4905236,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257742',4905237,'1664','231',674479.43,679199.00,4719.57,873120.45,0.00,0.00,0.00,0.00,0.00),('5','92','599','257742',4905238,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257742',4905239,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257742',4905240,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257743',4905241,'1661','231',1067844.06,1072678.58,4834.52,894386.20,0.00,0.00,0.00,0.00,0.00),('5','92','598','257743',4905242,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257743',4905243,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257743',4905244,'1664','231',679199.00,684023.90,4824.90,892606.50,0.00,0.00,0.00,0.00,0.00),('5','92','599','257743',4905245,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257743',4905246,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257743',4905247,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257744',4905248,'1661','231',1072678.58,1078393.36,5714.78,1057234.30,0.00,0.00,0.00,0.00,0.00),('5','92','598','257744',4905249,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257744',4905250,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257744',4905251,'1664','231',684023.90,690070.99,6047.09,1118711.65,0.00,0.00,0.00,0.00,0.00),('5','92','599','257744',4905252,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257744',4905253,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257744',4905254,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257745',4905255,'1661','231',1078393.36,1085410.67,7017.31,1298202.35,0.00,0.00,0.00,0.00,0.00),('5','92','598','257745',4905256,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257745',4905257,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257745',4905258,'1664','231',690070.99,696382.61,6311.62,1167649.70,0.00,0.00,0.00,0.00,0.00),('5','92','599','257745',4905259,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257745',4905260,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257745',4905261,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257746',4905262,'1661','231',1085410.67,1092245.55,6834.88,1264452.80,0.00,0.00,0.00,0.00,0.00),('5','92','598','257746',4905263,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257746',4905264,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257746',4905265,'1664','231',696382.61,702542.97,6160.36,1139666.60,0.00,0.00,0.00,0.00,0.00),('5','92','599','257746',4905266,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257746',4905267,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257746',4905268,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257747',4905269,'1661','231',1092245.55,1095626.70,3381.15,625512.75,0.00,0.00,0.00,0.00,0.00),('5','92','598','257747',4905270,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257747',4905271,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257747',4905272,'1664','231',702542.97,706159.83,3616.86,669119.10,0.00,0.00,0.00,0.00,0.00),('5','92','599','257747',4905273,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257747',4905274,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257747',4905275,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257748',4905276,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257748',4905277,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257748',4905278,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257748',4905279,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257748',4905280,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257748',4905281,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257748',4905282,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257749',4905283,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257749',4905284,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257749',4905285,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257749',4905286,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257749',4905287,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257749',4905288,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257749',4905289,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257750',4905290,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257750',4905291,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257750',4905292,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257750',4905293,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257750',4905294,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257750',4905295,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257750',4905296,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257751',4905297,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257751',4905298,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257751',4905299,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257751',4905300,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257751',4905301,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257751',4905302,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257751',4905303,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257752',4905304,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257752',4905305,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257752',4905306,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257752',4905307,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257752',4905308,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257752',4905309,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257752',4905310,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257753',4905311,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257753',4905312,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257753',4905313,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257753',4905314,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257753',4905315,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257753',4905316,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257753',4905317,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257754',4905318,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257754',4905319,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257754',4905320,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257754',4905321,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257754',4905322,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257754',4905323,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257754',4905324,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257755',4905325,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257755',4905326,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257755',4905327,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257755',4905328,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257755',4905329,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257755',4905330,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257755',4905331,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257756',4905332,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257756',4905333,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257756',4905334,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257756',4905335,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257756',4905336,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257756',4905337,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257756',4905338,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257757',4905339,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257757',4905340,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257757',4905341,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257757',4905342,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257757',4905343,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257757',4905344,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257757',4905345,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257758',4905346,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257758',4905347,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257758',4905348,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257758',4905349,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257758',4905350,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257758',4905351,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257758',4905352,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257759',4905353,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257759',4905354,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257759',4905355,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257759',4905356,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257759',4905357,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257759',4905358,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257759',4905359,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257760',4905360,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257760',4905361,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257760',4905362,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257760',4905363,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257760',4905364,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257760',4905365,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257760',4905366,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257761',4905367,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257761',4905368,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257761',4905369,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257761',4905370,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257761',4905371,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257761',4905372,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257761',4905373,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257762',4905374,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257762',4905375,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257762',4905376,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257762',4905377,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257762',4905378,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257762',4905379,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257762',4905380,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257763',4905381,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257763',4905382,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257763',4905383,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257763',4905384,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257763',4905385,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257763',4905386,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257763',4905387,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257764',4905388,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257764',4905389,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257764',4905390,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257764',4905391,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257764',4905392,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257764',4905393,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257764',4905394,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257765',4905395,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257765',4905396,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257765',4905397,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257765',4905398,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257765',4905399,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257765',4905400,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257765',4905401,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257766',4905402,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257766',4905403,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257766',4905404,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257766',4905405,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257766',4905406,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257766',4905407,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257766',4905408,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257767',4905409,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257767',4905410,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257767',4905411,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257767',4905412,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257767',4905413,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257767',4905414,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257767',4905415,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257768',4905416,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257768',4905417,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257768',4905418,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257768',4905419,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257768',4905420,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257768',4905421,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257768',4905422,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257769',4905423,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257769',4905424,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257769',4905425,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257769',4905426,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257769',4905427,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257769',4905428,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257769',4905429,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257770',4905430,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257770',4905431,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257770',4905432,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257770',4905433,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257770',4905434,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257770',4905435,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257770',4905436,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257771',4905437,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257771',4905438,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257771',4905439,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257771',4905440,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257771',4905441,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257771',4905442,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257771',4905443,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257772',4905444,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257772',4905445,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257772',4905446,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257772',4905447,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257772',4905448,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257772',4905449,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257772',4905450,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257773',4905451,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257773',4905452,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257773',4905453,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257773',4905454,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257773',4905455,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257773',4905456,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257773',4905457,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257774',4905458,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257774',4905459,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257774',4905460,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257774',4905461,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257774',4905462,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257774',4905463,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257774',4905464,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257775',4905465,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257775',4905466,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257775',4905467,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257775',4905468,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257775',4905469,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257775',4905470,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257775',4905471,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257776',4905472,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257776',4905473,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257776',4905474,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257776',4905475,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257776',4905476,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257776',4905477,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257776',4905478,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257777',4905479,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257777',4905480,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257777',4905481,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257777',4905482,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257777',4905483,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257777',4905484,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257777',4905485,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257778',4905486,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257778',4905487,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257778',4905488,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257778',4905489,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257778',4905490,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257778',4905491,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257778',4905492,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257779',4905493,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257779',4905494,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257779',4905495,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257779',4905496,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257779',4905497,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257779',4905498,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257779',4905499,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257780',4905500,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257780',4905501,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257780',4905502,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257780',4905503,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257780',4905504,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257780',4905505,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257780',4905506,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257781',4905507,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257781',4905508,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257781',4905509,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257781',4905510,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257781',4905511,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257781',4905512,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257781',4905513,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257782',4905514,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257782',4905515,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257782',4905516,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257782',4905517,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257782',4905518,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257782',4905519,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257782',4905520,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257783',4905521,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257783',4905522,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257783',4905523,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257783',4905524,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257783',4905525,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257783',4905526,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257783',4905527,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257784',4905528,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257784',4905529,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257784',4905530,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257784',4905531,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257784',4905532,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257784',4905533,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257784',4905534,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257785',4905535,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257785',4905536,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257785',4905537,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257785',4905538,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257785',4905539,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257785',4905540,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257785',4905541,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257786',4905542,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257786',4905543,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257786',4905544,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257786',4905545,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257786',4905546,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257786',4905547,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257786',4905548,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257787',4905549,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257787',4905550,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257787',4905551,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257787',4905552,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257787',4905553,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257787',4905554,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257787',4905555,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257788',4905556,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257788',4905557,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257788',4905558,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257788',4905559,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257788',4905560,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257788',4905561,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257788',4905562,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257789',4905563,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257789',4905564,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257789',4905565,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257789',4905566,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257789',4905567,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257789',4905568,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257789',4905569,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257790',4905570,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257790',4905571,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257790',4905572,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257790',4905573,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257790',4905574,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257790',4905575,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257790',4905576,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257791',4905577,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257791',4905578,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257791',4905579,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257791',4905580,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257791',4905581,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257791',4905582,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257791',4905583,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257792',4905584,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257792',4905585,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257792',4905586,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257792',4905587,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257792',4905588,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257792',4905589,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257792',4905590,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257793',4905591,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257793',4905592,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257793',4905593,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257793',4905594,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257793',4905595,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257793',4905596,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257793',4905597,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257794',4905598,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257794',4905599,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257794',4905600,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257794',4905601,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257794',4905602,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257794',4905603,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257794',4905604,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257795',4905605,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257795',4905606,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257795',4905607,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257795',4905608,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257795',4905609,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257795',4905610,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257795',4905611,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257796',4905612,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257796',4905613,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257796',4905614,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257796',4905615,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257796',4905616,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257796',4905617,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257796',4905618,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257797',4905619,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257797',4905620,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257797',4905621,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257797',4905622,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257797',4905623,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257797',4905624,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257797',4905625,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257798',4905626,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257798',4905627,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257798',4905628,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257798',4905629,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257798',4905630,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257798',4905631,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257798',4905632,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257799',4905633,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257799',4905634,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257799',4905635,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257799',4905636,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257799',4905637,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257799',4905638,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257799',4905639,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257800',4905640,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257800',4905641,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257800',4905642,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257800',4905643,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257800',4905644,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257800',4905645,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257800',4905646,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257801',4905647,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257801',4905648,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257801',4905649,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257801',4905650,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257801',4905651,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257801',4905652,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257801',4905653,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257802',4905654,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257802',4905655,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257802',4905656,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257802',4905657,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257802',4905658,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257802',4905659,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257802',4905660,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257803',4905661,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257803',4905662,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257803',4905663,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257803',4905664,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257803',4905665,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257803',4905666,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257803',4905667,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257804',4905668,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257804',4905669,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257804',4905670,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257804',4905671,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257804',4905672,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257804',4905673,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257804',4905674,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257805',4905675,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257805',4905676,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257805',4905677,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257805',4905678,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257805',4905679,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257805',4905680,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257805',4905681,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257806',4905682,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257806',4905683,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257806',4905684,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257806',4905685,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257806',4905686,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257806',4905687,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257806',4905688,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257807',4905689,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257807',4905690,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257807',4905691,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257807',4905692,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257807',4905693,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257807',4905694,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257807',4905695,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257808',4905696,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257808',4905697,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257808',4905698,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257808',4905699,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257808',4905700,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257808',4905701,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257808',4905702,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257809',4905703,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257809',4905704,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257809',4905705,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257809',4905706,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257809',4905707,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257809',4905708,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257809',4905709,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257810',4905710,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257810',4905711,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257810',4905712,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257810',4905713,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257810',4905714,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257810',4905715,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257810',4905716,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257811',4905717,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257811',4905718,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257811',4905719,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257811',4905720,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257811',4905721,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257811',4905722,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257811',4905723,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257812',4905724,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257812',4905725,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257812',4905726,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257812',4905727,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257812',4905728,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257812',4905729,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257812',4905730,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257813',4905731,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257813',4905732,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257813',4905733,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257813',4905734,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257813',4905735,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257813',4905736,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257813',4905737,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257814',4905738,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257814',4905739,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257814',4905740,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257814',4905741,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257814',4905742,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257814',4905743,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257814',4905744,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257815',4905745,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257815',4905746,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257815',4905747,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257815',4905748,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257815',4905749,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257815',4905750,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257815',4905751,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257816',4905752,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257816',4905753,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257816',4905754,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257816',4905755,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257816',4905756,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257816',4905757,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257816',4905758,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257817',4905759,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257817',4905760,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257817',4905761,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257817',4905762,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257817',4905763,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257817',4905764,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257817',4905765,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257818',4905766,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257818',4905767,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257818',4905768,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257818',4905769,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257818',4905770,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257818',4905771,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257818',4905772,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257819',4905773,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257819',4905774,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257819',4905775,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257819',4905776,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257819',4905777,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257819',4905778,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257819',4905779,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257820',4905780,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257820',4905781,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257820',4905782,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257820',4905783,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257820',4905784,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257820',4905785,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257820',4905786,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257821',4905787,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257821',4905788,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257821',4905789,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257821',4905790,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257821',4905791,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257821',4905792,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257821',4905793,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257822',4905794,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257822',4905795,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257822',4905796,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257822',4905797,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257822',4905798,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257822',4905799,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257822',4905800,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257823',4905801,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257823',4905802,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257823',4905803,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257823',4905804,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257823',4905805,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257823',4905806,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257823',4905807,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257824',4905808,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257824',4905809,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257824',4905810,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257824',4905811,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257824',4905812,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257824',4905813,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257824',4905814,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257825',4905815,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257825',4905816,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257825',4905817,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257825',4905818,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257825',4905819,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257825',4905820,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257825',4905821,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257826',4905822,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257826',4905823,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257826',4905824,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257826',4905825,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257826',4905826,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257826',4905827,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257826',4905828,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257827',4905829,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257827',4905830,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257827',4905831,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257827',4905832,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257827',4905833,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257827',4905834,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257827',4905835,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257828',4905836,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257828',4905837,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257828',4905838,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257828',4905839,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257828',4905840,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257828',4905841,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257828',4905842,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257829',4905843,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257829',4905844,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257829',4905845,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257829',4905846,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257829',4905847,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257829',4905848,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257829',4905849,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257830',4905850,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257830',4905851,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257830',4905852,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257830',4905853,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257830',4905854,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257830',4905855,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257830',4905856,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257831',4905857,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257831',4905858,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257831',4905859,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257831',4905860,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257831',4905861,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257831',4905862,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257831',4905863,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257832',4905864,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257832',4905865,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257832',4905866,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257832',4905867,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257832',4905868,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257832',4905869,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257832',4905870,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257833',4905871,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257833',4905872,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257833',4905873,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257833',4905874,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257833',4905875,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257833',4905876,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257833',4905877,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257834',4905878,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257834',4905879,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257834',4905880,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257834',4905881,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257834',4905882,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257834',4905883,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257834',4905884,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257835',4905885,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257835',4905886,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257835',4905887,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257835',4905888,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257835',4905889,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257835',4905890,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257835',4905891,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257836',4905892,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257836',4905893,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257836',4905894,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257836',4905895,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257836',4905896,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257836',4905897,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257836',4905898,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257837',4905899,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257837',4905900,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257837',4905901,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257837',4905902,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257837',4905903,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257837',4905904,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257837',4905905,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257838',4905906,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257838',4905907,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257838',4905908,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257838',4905909,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257838',4905910,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257838',4905911,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257838',4905912,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257839',4905913,'1661','231',1095626.70,1095626.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257839',4905914,'1662','231',59195.52,59195.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257839',4905915,'1663','231',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','598','257839',4905916,'1664','231',706159.83,706159.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','599','257839',4905917,'1665','231',1074882.89,1074882.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','600','257839',4905918,'1666','232',798002.22,798002.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','92','601','257839',4905919,'1667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730690 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','92','212983','231',165.00,165.00,3126.26,0.00,0.00,0.00,0.00,614015),('5','92','212983','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614016),('5','92','212983','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614017),('5','92','212988','231',165.00,165.00,2875.62,0.00,0.00,0.00,0.00,614030),('5','92','212988','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614031),('5','92','212988','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614032),('5','92','212990','231',165.00,165.00,3858.62,0.00,0.00,0.00,0.00,614036),('5','92','212990','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614037),('5','92','212990','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614038),('5','92','213099','231',165.00,165.00,1722.41,0.00,0.00,0.00,0.00,614325),('5','92','213099','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614326),('5','92','213099','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614327),('5','92','213355','231',165.00,165.00,3145.95,0.00,0.00,0.00,0.00,614984),('5','92','213355','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614985),('5','92','213355','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614986),('5','92','213600','231',165.00,165.00,2462.79,0.00,0.00,0.00,0.00,615634),('5','92','213600','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615635),('5','92','213600','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615636),('5','92','213730','231',165.00,165.00,3076.68,0.00,0.00,0.00,0.00,615964),('5','92','213730','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615965),('5','92','213730','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615966),('5','92','213979','231',165.00,165.00,3050.41,0.00,0.00,0.00,0.00,616617),('5','92','213979','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616618),('5','92','213979','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616619),('5','92','214253','231',165.00,165.00,3232.79,0.00,0.00,0.00,0.00,617331),('5','92','214253','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617332),('5','92','214253','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617333),('5','92','214434','231',165.00,165.00,3478.50,0.00,0.00,0.00,0.00,617797),('5','92','214434','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617798),('5','92','214434','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617799),('5','92','214590','231',165.00,165.00,2704.48,0.00,0.00,0.00,0.00,618192),('5','92','214590','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618193),('5','92','214590','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618194),('5','92','214883','231',165.00,165.00,3378.69,0.00,0.00,0.00,0.00,618964),('5','92','214883','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618965),('5','92','214883','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618966),('5','92','215123','231',165.00,165.00,2988.01,0.00,0.00,0.00,0.00,619591),('5','92','215123','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619592),('5','92','215123','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619593),('5','92','215331','231',165.00,165.00,2512.04,0.00,0.00,0.00,0.00,620124),('5','92','215331','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620125),('5','92','215331','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620126),('5','92','215637','231',165.00,165.00,3521.05,0.00,0.00,0.00,0.00,620912),('5','92','215637','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620913),('5','92','215637','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620914),('5','92','215857','231',165.00,165.00,2777.01,0.00,0.00,0.00,0.00,621470),('5','92','215857','232',295.00,295.00,109.55,0.00,0.00,0.00,0.00,621471),('5','92','215857','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621472),('5','92','216080','231',165.00,165.00,1863.42,0.00,0.00,0.00,0.00,622061),('5','92','216080','232',295.00,295.00,227.36,0.00,0.00,0.00,0.00,622062),('5','92','216080','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622063),('5','92','216294','231',165.00,165.00,2449.66,0.00,0.00,0.00,0.00,622617),('5','92','216294','232',295.00,295.00,83.94,0.00,0.00,0.00,0.00,622618),('5','92','216294','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622619),('5','92','216525','231',165.00,165.00,3290.01,0.00,0.00,0.00,0.00,623231),('5','92','216525','232',295.00,295.00,64.68,0.00,0.00,0.00,0.00,623232),('5','92','216525','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623233),('5','92','216767','231',165.00,165.00,2207.61,0.00,0.00,0.00,0.00,623860),('5','92','216767','232',295.00,295.00,62.48,0.00,0.00,0.00,0.00,623861),('5','92','216767','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623862),('5','92','216941','231',165.00,165.00,2334.86,0.00,0.00,0.00,0.00,624318),('5','92','216941','232',295.00,295.00,220.93,0.00,0.00,0.00,0.00,624319),('5','92','216941','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624320),('5','92','217132','231',165.00,165.00,2250.09,0.00,0.00,0.00,0.00,624806),('5','92','217132','232',295.00,295.00,830.64,0.00,0.00,0.00,0.00,624807),('5','92','217132','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624808),('5','92','217386','231',165.00,165.00,2304.55,0.00,0.00,0.00,0.00,625475),('5','92','217386','232',295.00,295.00,102.93,0.00,0.00,0.00,0.00,625476),('5','92','217386','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625477),('5','92','217651','231',165.00,165.00,2404.86,0.00,0.00,0.00,0.00,626175),('5','92','217651','232',295.00,295.00,67.19,0.00,0.00,0.00,0.00,626176),('5','92','217651','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626177),('5','92','217861','231',165.00,165.00,2381.94,0.00,0.00,0.00,0.00,626722),('5','92','217861','232',295.00,295.00,91.10,0.00,0.00,0.00,0.00,626723),('5','92','217861','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626724),('5','92','218069','231',165.00,165.00,2396.34,0.00,0.00,0.00,0.00,627263),('5','92','218069','232',295.00,295.00,155.53,0.00,0.00,0.00,0.00,627264),('5','92','218069','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627265),('5','92','218275','231',165.00,165.00,1992.88,0.00,0.00,0.00,0.00,627804),('5','92','218275','232',295.00,295.00,928.45,0.00,0.00,0.00,0.00,627805),('5','92','218275','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627806),('5','92','218635','231',165.00,165.00,2570.67,0.00,0.00,0.00,0.00,628752),('5','92','218635','232',295.00,295.00,167.79,0.00,0.00,0.00,0.00,628753),('5','92','218635','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628754),('5','92','218870','231',165.00,165.00,2272.93,0.00,0.00,0.00,0.00,629369),('5','92','218870','232',295.00,295.00,178.75,0.00,0.00,0.00,0.00,629370),('5','92','218870','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629371),('5','92','219093','231',165.00,165.00,534.05,0.00,0.00,0.00,0.00,629947),('5','92','219093','232',295.00,295.00,149.38,0.00,0.00,0.00,0.00,629948),('5','92','219093','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629949),('5','92','219313','231',165.00,165.00,1481.69,0.00,0.00,0.00,0.00,630527),('5','92','219313','232',295.00,295.00,500.00,0.00,0.00,0.00,0.00,630528),('5','92','219313','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630529),('5','92','219439','231',165.00,165.00,2127.76,0.00,0.00,0.00,0.00,630845),('5','92','219439','232',295.00,295.00,454.94,0.00,0.00,0.00,0.00,630846),('5','92','219439','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630847),('5','92','219670','231',165.00,165.00,3094.80,0.00,0.00,0.00,0.00,631453),('5','92','219670','232',295.00,295.00,96.06,0.00,0.00,0.00,0.00,631454),('5','92','219670','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631455),('5','92','219884','231',165.00,165.00,1961.96,0.00,0.00,0.00,0.00,632017),('5','92','219884','232',295.00,295.00,134.78,0.00,0.00,0.00,0.00,632018),('5','92','219884','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632019),('5','92','220058','231',165.00,165.00,2678.12,0.00,0.00,0.00,0.00,632478),('5','92','220058','232',295.00,295.00,156.57,0.00,0.00,0.00,0.00,632479),('5','92','220058','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632480),('5','92','220301','231',165.00,165.00,2188.90,0.00,0.00,0.00,0.00,633115),('5','92','220301','232',295.00,295.00,158.29,0.00,0.00,0.00,0.00,633116),('5','92','220301','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633117),('5','92','220489','231',165.00,165.00,1994.49,0.00,0.00,0.00,0.00,633610),('5','92','220489','232',295.00,295.00,180.62,0.00,0.00,0.00,0.00,633611),('5','92','220489','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633612),('5','92','220694','231',165.00,165.00,3262.00,0.00,0.00,0.00,0.00,634144),('5','92','220694','232',295.00,295.00,81.76,0.00,0.00,0.00,0.00,634145),('5','92','220694','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634146),('5','92','220986','231',165.00,165.00,3069.12,0.00,0.00,0.00,0.00,634911),('5','92','220986','232',295.00,295.00,206.76,0.00,0.00,0.00,0.00,634912),('5','92','220986','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634913),('5','92','221127','231',165.00,165.00,2790.88,0.00,0.00,0.00,0.00,635283),('5','92','221127','232',295.00,295.00,87.21,0.00,0.00,0.00,0.00,635284),('5','92','221127','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635285),('5','92','221378','231',165.00,165.00,2756.62,0.00,0.00,0.00,0.00,635936),('5','92','221378','232',295.00,295.00,150.44,0.00,0.00,0.00,0.00,635937),('5','92','221378','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635938),('5','92','221697','231',165.00,165.00,2189.38,0.00,0.00,0.00,0.00,636763),('5','92','221697','232',295.00,295.00,150.91,0.00,0.00,0.00,0.00,636764),('5','92','221697','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636765),('5','92','221893','231',165.00,165.00,1984.53,0.00,0.00,0.00,0.00,637263),('5','92','221893','232',295.00,295.00,164.04,0.00,0.00,0.00,0.00,637264),('5','92','221893','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637265),('5','92','222251','231',165.00,165.00,2535.16,0.00,0.00,0.00,0.00,638200),('5','92','222251','232',295.00,295.00,65.33,0.00,0.00,0.00,0.00,638201),('5','92','222251','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638202),('5','92','222472','231',165.00,165.00,2968.77,0.00,0.00,0.00,0.00,638771),('5','92','222472','232',295.00,295.00,146.68,0.00,0.00,0.00,0.00,638772),('5','92','222472','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638773),('5','92','222566','231',165.00,165.00,2630.17,0.00,0.00,0.00,0.00,639001),('5','92','222566','232',295.00,295.00,71.14,0.00,0.00,0.00,0.00,639002),('5','92','222566','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639003),('5','92','222864','231',165.00,165.00,1933.91,0.00,0.00,0.00,0.00,639802),('5','92','222864','232',295.00,295.00,112.60,0.00,0.00,0.00,0.00,639803),('5','92','222864','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639804),('5','92','223016','231',165.00,165.00,2163.78,0.00,0.00,0.00,0.00,640208),('5','92','223016','232',295.00,295.00,68.12,0.00,0.00,0.00,0.00,640209),('5','92','223016','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640210),('5','92','223315','231',165.00,165.00,2406.00,0.00,0.00,0.00,0.00,640949),('5','92','223315','232',295.00,295.00,87.82,0.00,0.00,0.00,0.00,640950),('5','92','223315','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640951),('5','92','223615','231',165.00,165.00,2623.09,0.00,0.00,0.00,0.00,641718),('5','92','223615','232',295.00,295.00,87.77,0.00,0.00,0.00,0.00,641719),('5','92','223615','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641720),('5','92','223856','231',165.00,165.00,2455.56,0.00,0.00,0.00,0.00,642338),('5','92','223856','232',295.00,295.00,63.48,0.00,0.00,0.00,0.00,642339),('5','92','223856','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642340),('5','92','224041','231',165.00,165.00,2238.17,0.00,0.00,0.00,0.00,642821),('5','92','224041','232',295.00,295.00,59.58,0.00,0.00,0.00,0.00,642822),('5','92','224041','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642823),('5','92','224120','231',165.00,165.00,2040.29,0.00,0.00,0.00,0.00,643011),('5','92','224120','232',295.00,295.00,93.57,0.00,0.00,0.00,0.00,643012),('5','92','224120','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643013),('5','92','224510','231',165.00,165.00,2310.84,0.00,0.00,0.00,0.00,644054),('5','92','224510','232',295.00,295.00,79.84,0.00,0.00,0.00,0.00,644055),('5','92','224510','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644056),('5','92','224665','231',165.00,165.00,2059.86,0.00,0.00,0.00,0.00,644444),('5','92','224665','232',295.00,295.00,90.92,0.00,0.00,0.00,0.00,644445),('5','92','224665','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644446),('5','92','224835','231',165.00,163.00,3139.23,0.00,0.00,0.00,0.00,644864),('5','92','224835','232',295.00,295.00,77.33,0.00,0.00,0.00,0.00,644865),('5','92','224835','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644866),('5','92','225069','231',163.00,163.00,3155.27,0.00,0.00,0.00,0.00,645465),('5','92','225069','232',295.00,295.00,303.56,0.00,0.00,0.00,0.00,645466),('5','92','225069','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645467),('5','92','225465','231',163.00,163.00,2098.52,0.00,0.00,0.00,0.00,646507),('5','92','225465','232',295.00,295.00,287.56,0.00,0.00,0.00,0.00,646508),('5','92','225465','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646509),('5','92','225673','231',163.00,163.00,2882.31,0.00,0.00,0.00,0.00,647047),('5','92','225673','232',295.00,295.00,196.36,0.00,0.00,0.00,0.00,647048),('5','92','225673','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647049),('5','92','225841','231',163.00,163.00,2634.05,0.00,0.00,0.00,0.00,647478),('5','92','225841','232',295.00,295.00,90.32,0.00,0.00,0.00,0.00,647479),('5','92','225841','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647480),('5','92','226207','231',163.00,163.00,2770.68,0.00,0.00,0.00,0.00,648438),('5','92','226207','232',295.00,295.00,80.06,0.00,0.00,0.00,0.00,648439),('5','92','226207','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648440),('5','92','226345','231',163.00,163.00,2260.21,0.00,0.00,0.00,0.00,648787),('5','92','226345','232',295.00,295.00,196.12,0.00,0.00,0.00,0.00,648788),('5','92','226345','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648789),('5','92','226708','231',163.00,163.00,2685.26,0.00,0.00,0.00,0.00,649723),('5','92','226708','232',295.00,295.00,156.39,0.00,0.00,0.00,0.00,649724),('5','92','226708','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649725),('5','92','226848','231',163.00,163.00,1133.23,0.00,0.00,0.00,0.00,650083),('5','92','226848','232',295.00,295.00,183.58,0.00,0.00,0.00,0.00,650084),('5','92','226848','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650085),('5','92','226969','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,650395),('5','92','226969','232',295.00,295.00,172.42,0.00,0.00,0.00,0.00,650396),('5','92','226969','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650397),('5','92','227356','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,651404),('5','92','227356','232',295.00,295.00,325.99,0.00,0.00,0.00,0.00,651405),('5','92','227356','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651406),('5','92','227588','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,652003),('5','92','227588','232',295.00,295.00,190.59,0.00,0.00,0.00,0.00,652004),('5','92','227588','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652005),('5','92','227820','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,652605),('5','92','227820','232',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652606),('5','92','227820','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652607),('5','92','227978','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,653009),('5','92','227978','232',300.00,300.00,122.54,0.00,0.00,0.00,0.00,653010),('5','92','227978','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,653011),('5','92','231944','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663336),('5','92','231944','232',300.00,300.00,0.00,0.00,0.00,0.00,0.00,663337),('5','92','231944','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663338),('5','92','231947','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663345),('5','92','231947','232',300.00,300.00,0.00,0.00,0.00,0.00,0.00,663346),('5','92','231947','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663347),('5','92','231954','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663366),('5','92','231954','232',300.00,300.00,247.97,0.00,0.00,0.00,0.00,663367),('5','92','231954','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663368),('5','92','231963','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663392),('5','92','231963','232',300.00,300.00,127.24,0.00,0.00,0.00,0.00,663393),('5','92','231963','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663394),('5','92','231964','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663395),('5','92','231964','232',300.00,300.00,285.37,0.00,0.00,0.00,0.00,663396),('5','92','231964','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663397),('5','92','231966','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663400),('5','92','231966','232',300.00,300.00,443.04,0.00,0.00,0.00,0.00,663401),('5','92','231966','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663402),('5','92','231972','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663418),('5','92','231972','232',300.00,300.00,322.09,0.00,0.00,0.00,0.00,663419),('5','92','231972','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663420),('5','92','231974','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,663424),('5','92','231974','232',300.00,310.00,221.52,0.00,0.00,0.00,0.00,663425),('5','92','231974','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663426),('5','92','232069','231',163.00,163.00,2551.20,0.00,0.00,0.00,0.00,663687),('5','92','232069','232',300.00,320.00,102.26,0.00,0.00,0.00,0.00,663688),('5','92','232069','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663689),('5','92','232918','231',163.00,163.00,3647.23,0.00,0.00,0.00,0.00,665905),('5','92','232918','232',300.00,320.00,80.87,0.00,0.00,0.00,0.00,665906),('5','92','232918','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665907),('5','92','232924','231',163.00,163.00,4916.63,0.00,0.00,0.00,0.00,665924),('5','92','232924','232',320.00,320.00,258.86,0.00,0.00,0.00,0.00,665925),('5','92','232924','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665926),('5','92','232929','231',163.00,163.00,2286.95,0.00,0.00,0.00,0.00,665939),('5','92','232929','232',320.00,320.00,272.38,0.00,0.00,0.00,0.00,665940),('5','92','232929','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665941),('5','92','232934','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,665954),('5','92','232934','232',327.00,327.00,213.08,0.00,0.00,0.00,0.00,665955),('5','92','232934','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665956),('5','92','232936','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,665960),('5','92','232936','232',327.00,327.00,371.50,0.00,0.00,0.00,0.00,665961),('5','92','232936','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665962),('5','92','232940','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,665972),('5','92','232940','232',327.00,327.00,471.38,0.00,0.00,0.00,0.00,665973),('5','92','232940','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665974),('5','92','232945','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,665986),('5','92','232945','232',327.00,327.00,0.00,0.00,0.00,0.00,0.00,665987),('5','92','232945','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665988),('5','92','233061','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,666288),('5','92','233061','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,666289),('5','92','233061','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666290),('5','92','233312','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,666947),('5','92','233312','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,666948),('5','92','233312','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666949),('5','92','233585','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,667661),('5','92','233585','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,667662),('5','92','233585','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667663),('5','92','233769','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,668139),('5','92','233769','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,668140),('5','92','233769','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668141),('5','92','234026','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,668826),('5','92','234026','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,668827),('5','92','234026','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668828),('5','92','234996','231',163.00,163.00,0.00,0.00,0.00,0.00,0.00,671403),('5','92','234996','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671404),('5','92','234996','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671405),('5','92','234997','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671406),('5','92','234997','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671407),('5','92','234997','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671408),('5','92','234999','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671412),('5','92','234999','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671413),('5','92','234999','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671414),('5','92','235000','231',165.00,165.00,744.43,0.00,0.00,0.00,0.00,671415),('5','92','235000','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,671416),('5','92','235000','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671417),('5','92','235459','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,672603),('5','92','235459','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,672604),('5','92','235459','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672605),('5','92','235696','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,673216),('5','92','235696','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,673217),('5','92','235696','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673218),('5','92','236449','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675209),('5','92','236449','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675210),('5','92','236449','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675211),('5','92','236581','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675527),('5','92','236581','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675528),('5','92','236581','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675529),('5','92','236584','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,675536),('5','92','236584','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,675537),('5','92','236584','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675538),('5','92','236590','231',165.00,165.00,5050.74,0.00,0.00,0.00,0.00,675551),('5','92','236590','232',345.00,345.00,45.98,0.00,0.00,0.00,0.00,675552),('5','92','236590','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675553),('5','92','236887','231',165.00,165.00,5598.29,0.00,0.00,0.00,0.00,676332),('5','92','236887','232',345.00,345.00,24.49,0.00,0.00,0.00,0.00,676333),('5','92','236887','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676334),('5','92','238212','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679747),('5','92','238212','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,679748),('5','92','238212','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679749),('5','92','238441','231',165.00,165.00,1821.55,0.00,0.00,0.00,0.00,680342),('5','92','238441','232',345.00,345.00,28.71,0.00,0.00,0.00,0.00,680343),('5','92','238441','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680344),('5','92','238456','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680383),('5','92','238456','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680384),('5','92','238456','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680385),('5','92','238459','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680390),('5','92','238459','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680391),('5','92','238459','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680392),('5','92','238461','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680396),('5','92','238461','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680397),('5','92','238461','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680398),('5','92','238465','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680408),('5','92','238465','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680409),('5','92','238465','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680410),('5','92','238466','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680411),('5','92','238466','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680412),('5','92','238466','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680413),('5','92','238472','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680429),('5','92','238472','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680430),('5','92','238472','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680431),('5','92','238801','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,681290),('5','92','238801','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,681291),('5','92','238801','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681292),('5','92','238938','231',165.00,165.00,8775.73,0.00,0.00,0.00,0.00,681632),('5','92','238938','232',345.00,345.00,38.03,0.00,0.00,0.00,0.00,681633),('5','92','238938','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681634),('5','92','239202','231',165.00,165.00,7917.56,0.00,0.00,0.00,0.00,682329),('5','92','239202','232',345.00,345.00,18.69,0.00,0.00,0.00,0.00,682330),('5','92','239202','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682331),('5','92','239472','231',165.00,165.00,3351.84,0.00,0.00,0.00,0.00,683035),('5','92','239472','232',345.00,345.00,103.47,0.00,0.00,0.00,0.00,683036),('5','92','239472','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683037),('5','92','239727','231',165.00,165.00,1393.87,0.00,0.00,0.00,0.00,683700),('5','92','239727','232',345.00,345.00,45.00,0.00,0.00,0.00,0.00,683701),('5','92','239727','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683702),('5','92','239932','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,684232),('5','92','239932','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684233),('5','92','239932','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684234),('5','92','240233','231',165.00,165.00,4122.08,0.00,0.00,0.00,0.00,684991),('5','92','240233','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684992),('5','92','240233','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684993),('5','92','240377','231',165.00,165.00,9724.16,0.00,0.00,0.00,0.00,685380),('5','92','240377','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685381),('5','92','240377','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685382),('5','92','240622','231',165.00,165.00,9803.10,0.00,0.00,0.00,0.00,686026),('5','92','240622','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686027),('5','92','240622','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686028),('5','92','240810','231',165.00,165.00,4985.32,0.00,0.00,0.00,0.00,686454),('5','92','240810','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686455),('5','92','240810','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686456),('5','92','241179','231',165.00,165.00,1817.44,0.00,0.00,0.00,0.00,687461),('5','92','241179','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687462),('5','92','241179','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687463),('5','92','241446','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688169),('5','92','241446','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688170),('5','92','241446','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688171),('5','92','242607','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691190),('5','92','242607','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691191),('5','92','242607','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691192),('5','92','242786','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691644),('5','92','242786','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691645),('5','92','242786','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691646),('5','92','242792','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691658),('5','92','242792','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691659),('5','92','242792','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691660),('5','92','242794','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691662),('5','92','242794','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691663),('5','92','242794','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691664),('5','92','242795','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691665),('5','92','242795','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691666),('5','92','242795','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691667),('5','92','242808','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691702),('5','92','242808','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691703),('5','92','242808','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691704),('5','92','243275','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692930),('5','92','243275','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692931),('5','92','243275','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692932),('5','92','243293','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692983),('5','92','243293','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692984),('5','92','243293','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692985),('5','92','243537','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693616),('5','92','243537','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693617),('5','92','243537','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693618),('5','92','244012','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694845),('5','92','244012','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694846),('5','92','244012','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694847),('5','92','244235','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695426),('5','92','244235','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695427),('5','92','244235','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695428),('5','92','244455','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695991),('5','92','244455','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695992),('5','92','244455','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695993),('5','92','245149','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697794),('5','92','245149','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697795),('5','92','245149','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697796),('5','92','245384','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698399),('5','92','245384','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698400),('5','92','245384','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698401),('5','92','245386','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698405),('5','92','245386','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698406),('5','92','245386','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698407),('5','92','245387','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698408),('5','92','245387','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698409),('5','92','245387','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698410),('5','92','245389','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698414),('5','92','245389','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698415),('5','92','245389','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698416),('5','92','245608','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698982),('5','92','245608','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698983),('5','92','245608','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698984),('5','92','245876','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699675),('5','92','245876','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699676),('5','92','245876','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699677),('5','92','246124','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,700319),('5','92','246124','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700320),('5','92','246124','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700321),('5','92','246393','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701035),('5','92','246393','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701036),('5','92','246393','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701037),('5','92','246641','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701682),('5','92','246641','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701683),('5','92','246641','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701684),('5','92','246873','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702276),('5','92','246873','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702277),('5','92','246873','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702278),('5','92','247116','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702905),('5','92','247116','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702906),('5','92','247116','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702907),('5','92','247353','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703513),('5','92','247353','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703514),('5','92','247353','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703515),('5','92','247597','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704144),('5','92','247597','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704145),('5','92','247597','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704146),('5','92','247845','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704775),('5','92','247845','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704776),('5','92','247845','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704777),('5','92','248107','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705467),('5','92','248107','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705468),('5','92','248107','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705469),('5','92','249041','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707871),('5','92','249041','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707872),('5','92','249041','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707873),('5','92','249043','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707877),('5','92','249043','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707878),('5','92','249043','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707879),('5','92','249045','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707883),('5','92','249045','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707884),('5','92','249045','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707885),('5','92','249046','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707886),('5','92','249046','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707887),('5','92','249046','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707888),('5','92','249281','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708474),('5','92','249281','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708475),('5','92','249281','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708476),('5','92','249782','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709766),('5','92','249782','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709767),('5','92','249782','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709768),('5','92','250055','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710463),('5','92','250055','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710464),('5','92','250055','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710465),('5','92','250075','231',165.00,165.00,780.00,0.00,0.00,0.00,0.00,710516),('5','92','250075','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710517),('5','92','250075','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710518),('5','92','250304','231',165.00,165.00,5581.49,0.00,0.00,0.00,0.00,711099),('5','92','250304','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711100),('5','92','250304','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711101),('5','92','250644','231',165.00,165.00,5461.59,0.00,0.00,0.00,0.00,711944),('5','92','250644','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711945),('5','92','250644','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711946),('5','92','250735','231',165.00,165.00,8041.78,0.00,0.00,0.00,0.00,712205),('5','92','250735','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712206),('5','92','250735','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712207),('5','92','250953','231',165.00,165.00,2833.29,0.00,0.00,0.00,0.00,712762),('5','92','250953','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712763),('5','92','250953','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712764),('5','92','251208','231',165.00,165.00,12480.96,0.00,0.00,0.00,0.00,713424),('5','92','251208','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713425),('5','92','251208','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713426),('5','92','251466','231',165.00,165.00,8860.96,0.00,0.00,0.00,0.00,714103),('5','92','251466','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714104),('5','92','251466','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714105),('5','92','251736','231',165.00,165.00,6888.75,0.00,0.00,0.00,0.00,714816),('5','92','251736','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714817),('5','92','251736','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714818),('5','92','251950','231',165.00,165.00,1452.37,0.00,0.00,0.00,0.00,715371),('5','92','251950','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715372),('5','92','251950','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715373),('5','92','252190','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715992),('5','92','252190','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715993),('5','92','252190','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715994),('5','92','253144','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718472),('5','92','253144','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718473),('5','92','253144','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718474),('5','92','253158','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718512),('5','92','253158','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718513),('5','92','253158','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718514),('5','92','253159','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718515),('5','92','253159','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718516),('5','92','253159','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718517),('5','92','253160','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718518),('5','92','253160','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718519),('5','92','253160','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718520),('5','92','253301','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718871),('5','92','253301','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718872),('5','92','253301','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718873),('5','92','253655','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719805),('5','92','253655','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719806),('5','92','253655','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719807),('5','92','253910','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720469),('5','92','253910','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720470),('5','92','253910','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720471),('5','92','254134','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721050),('5','92','254134','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721051),('5','92','254134','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721052),('5','92','254391','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721710),('5','92','254391','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721711),('5','92','254391','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721712),('5','92','254641','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722351),('5','92','254641','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722352),('5','92','254641','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722353),('5','92','254890','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722978),('5','92','254890','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722979),('5','92','254890','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722980),('5','92','255127','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723584),('5','92','255127','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723585),('5','92','255127','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723586),('5','92','255390','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724247),('5','92','255390','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724248),('5','92','255390','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724249),('5','92','255826','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725322),('5','92','255826','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725323),('5','92','255826','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725324),('5','92','256129','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726097),('5','92','256129','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726098),('5','92','256129','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726099),('5','92','256419','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726833),('5','92','256419','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726834),('5','92','256419','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726835),('5','92','256671','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727486),('5','92','256671','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727487),('5','92','256671','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727488),('5','92','256904','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728099),('5','92','256904','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728100),('5','92','256904','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728101),('5','92','257465','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729565),('5','92','257465','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729566),('5','92','257465','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729567),('5','92','257466','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729568),('5','92','257466','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729569),('5','92','257466','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729570),('5','92','257467','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729571),('5','92','257467','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729572),('5','92','257467','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729573),('5','92','257468','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729574),('5','92','257468','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729575),('5','92','257468','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729576),('5','92','257469','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729577),('5','92','257469','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729578),('5','92','257469','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729579),('5','92','257470','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729580),('5','92','257470','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729581),('5','92','257470','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729582),('5','92','257471','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729583),('5','92','257471','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729584),('5','92','257471','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729585),('5','92','257472','231',165.00,165.00,6571.15,0.00,0.00,0.00,0.00,729586),('5','92','257472','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729587),('5','92','257472','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729588),('5','92','257473','231',165.00,165.00,7381.40,0.00,0.00,0.00,0.00,729589),('5','92','257473','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729590),('5','92','257473','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729591),('5','92','257474','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729592),('5','92','257474','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729593),('5','92','257474','231',165.00,165.00,4500.91,0.00,0.00,0.00,0.00,729594),('5','92','257475','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729595),('5','92','257475','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729596),('5','92','257475','231',165.00,165.00,10457.57,0.00,0.00,0.00,0.00,729597),('5','92','257476','231',165.00,165.00,1145.91,0.00,0.00,0.00,0.00,729598),('5','92','257476','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729599),('5','92','257476','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729600),('5','92','257477','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729601),('5','92','257477','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729602),('5','92','257477','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729603),('5','92','257478','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729604),('5','92','257478','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729605),('5','92','257478','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729606),('5','92','257479','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729607),('5','92','257479','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729608),('5','92','257479','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729609),('5','92','257480','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729610),('5','92','257480','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729611),('5','92','257480','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729612),('5','92','257481','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729613),('5','92','257481','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729614),('5','92','257481','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729615),('5','92','257482','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729616),('5','92','257482','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729617),('5','92','257482','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729618),('5','92','257483','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729619),('5','92','257483','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729620),('5','92','257483','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729621),('5','92','257484','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729622),('5','92','257484','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729623),('5','92','257484','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729624),('5','92','257485','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729625),('5','92','257485','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729626),('5','92','257485','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729627),('5','92','257486','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729628),('5','92','257486','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729629),('5','92','257486','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729630),('5','92','257487','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729631),('5','92','257487','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729632),('5','92','257487','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729633),('5','92','257488','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729634),('5','92','257488','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729635),('5','92','257488','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729636),('5','92','257489','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729637),('5','92','257489','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729638),('5','92','257489','231',165.00,165.00,10843.77,0.00,0.00,0.00,0.00,729639),('5','92','257490','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729640),('5','92','257490','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729641),('5','92','257490','231',165.00,165.00,9424.83,0.00,0.00,0.00,0.00,729642),('5','92','257491','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729643),('5','92','257491','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729644),('5','92','257491','231',165.00,165.00,3990.32,0.00,0.00,0.00,0.00,729645),('5','92','257492','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729646),('5','92','257492','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729647),('5','92','257492','231',165.00,165.00,2653.15,0.00,0.00,0.00,0.00,729648),('5','92','257493','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729649),('5','92','257493','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729650),('5','92','257493','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729651),('5','92','257494','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729652),('5','92','257494','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729653),('5','92','257494','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729654),('5','92','257495','231',165.00,165.00,5171.32,0.00,0.00,0.00,0.00,729655),('5','92','257495','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729656),('5','92','257495','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729657),('5','92','257496','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729658),('5','92','257496','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729659),('5','92','257496','231',165.00,165.00,13079.03,0.00,0.00,0.00,0.00,729660),('5','92','257497','231',165.00,165.00,5859.04,0.00,0.00,0.00,0.00,729661),('5','92','257497','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729662),('5','92','257497','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729663),('5','92','257498','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729664),('5','92','257498','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729665),('5','92','257498','231',165.00,165.00,6107.62,0.00,0.00,0.00,0.00,729666),('5','92','257499','232',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729667),('5','92','257499','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729668),('5','92','257499','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729669),('5','92','257500','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729670),('5','92','257500','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729671),('5','92','257500','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729672),('5','92','257501','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729673),('5','92','257501','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729674),('5','92','257501','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729675),('5','92','257502','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729676),('5','92','257502','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729677),('5','92','257502','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729678),('5','92','257503','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729679),('5','92','257503','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729680),('5','92','257503','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729681),('5','92','257504','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729682),('5','92','257504','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729683),('5','92','257504','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729684),('5','92','257505','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729685),('5','92','257505','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729686),('5','92','257505','231',165.00,165.00,6320.89,0.00,0.00,0.00,0.00,729687),('5','92','257506','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729688),('5','92','257506','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729689),('5','92','257506','231',165.00,165.00,7371.56,0.00,0.00,0.00,0.00,729690),('5','92','257507','231',165.00,165.00,6561.36,0.00,0.00,0.00,0.00,729691),('5','92','257507','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729692),('5','92','257507','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729693),('5','92','257508','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729694),('5','92','257508','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729695),('5','92','257508','231',165.00,165.00,8298.31,0.00,0.00,0.00,0.00,729696),('5','92','257509','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729697),('5','92','257509','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729698),('5','92','257509','231',165.00,165.00,7196.65,0.00,0.00,0.00,0.00,729699),('5','92','257510','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729700),('5','92','257510','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729701),('5','92','257510','231',165.00,165.00,7141.67,0.00,0.00,0.00,0.00,729702),('5','92','257511','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729703),('5','92','257511','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729704),('5','92','257511','231',165.00,165.00,2040.14,0.00,0.00,0.00,0.00,729705),('5','92','257512','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729706),('5','92','257512','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729707),('5','92','257512','231',165.00,165.00,5428.69,0.00,0.00,0.00,0.00,729708),('5','92','257513','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729709),('5','92','257513','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729710),('5','92','257513','231',165.00,165.00,8782.34,0.00,0.00,0.00,0.00,729711),('5','92','257514','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729712),('5','92','257514','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729713),('5','92','257514','231',165.00,165.00,11365.05,0.00,0.00,0.00,0.00,729714),('5','92','257515','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729715),('5','92','257515','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729716),('5','92','257515','231',165.00,165.00,1406.64,0.00,0.00,0.00,0.00,729717),('5','92','257516','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729718),('5','92','257516','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729719),('5','92','257516','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729720),('5','92','257517','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729721),('5','92','257517','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729722),('5','92','257517','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729723),('5','92','257518','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729724),('5','92','257518','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729725),('5','92','257518','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729726),('5','92','257519','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729727),('5','92','257519','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729728),('5','92','257519','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729729),('5','92','257520','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729730),('5','92','257520','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729731),('5','92','257520','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729732),('5','92','257521','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729733),('5','92','257521','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729734),('5','92','257521','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729735),('5','92','257522','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729736),('5','92','257522','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729737),('5','92','257522','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729738),('5','92','257523','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729739),('5','92','257523','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729740),('5','92','257523','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729741),('5','92','257524','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729742),('5','92','257524','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729743),('5','92','257524','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729744),('5','92','257525','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729745),('5','92','257525','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729746),('5','92','257525','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729747),('5','92','257526','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729748),('5','92','257526','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729749),('5','92','257526','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729750),('5','92','257527','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729751),('5','92','257527','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729752),('5','92','257527','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729753),('5','92','257528','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729754),('5','92','257528','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729755),('5','92','257528','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729756),('5','92','257529','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729757),('5','92','257529','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729758),('5','92','257529','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729759),('5','92','257530','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729760),('5','92','257530','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729761),('5','92','257530','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729762),('5','92','257531','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729763),('5','92','257531','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729764),('5','92','257531','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729765),('5','92','257532','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729766),('5','92','257532','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729767),('5','92','257532','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729768),('5','92','257533','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729769),('5','92','257533','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729770),('5','92','257533','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729771),('5','92','257534','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729772),('5','92','257534','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729773),('5','92','257534','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729774),('5','92','257535','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729775),('5','92','257535','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729776),('5','92','257535','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729777),('5','92','257536','231',165.00,165.00,4795.16,0.00,0.00,0.00,0.00,729778),('5','92','257536','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729779),('5','92','257536','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729780),('5','92','257537','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729781),('5','92','257537','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729782),('5','92','257537','231',165.00,165.00,9731.28,0.00,0.00,0.00,0.00,729783),('5','92','257538','231',165.00,165.00,7858.88,0.00,0.00,0.00,0.00,729784),('5','92','257538','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729785),('5','92','257538','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729786),('5','92','257539','231',165.00,165.00,6876.28,0.00,0.00,0.00,0.00,729787),('5','92','257539','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729788),('5','92','257539','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729789),('5','92','257540','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729790),('5','92','257540','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729791),('5','92','257540','231',165.00,165.00,903.12,0.00,0.00,0.00,0.00,729792),('5','92','257541','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729793),('5','92','257541','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729794),('5','92','257541','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729795),('5','92','257542','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729796),('5','92','257542','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729797),('5','92','257542','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729798),('5','92','257543','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729799),('5','92','257543','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729800),('5','92','257543','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729801),('5','92','257544','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729802),('5','92','257544','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729803),('5','92','257544','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729804),('5','92','257545','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729805),('5','92','257545','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729806),('5','92','257545','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729807),('5','92','257546','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729808),('5','92','257546','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729809),('5','92','257546','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729810),('5','92','257547','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729811),('5','92','257547','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729812),('5','92','257547','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729813),('5','92','257548','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729814),('5','92','257548','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729815),('5','92','257548','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729816),('5','92','257549','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729817),('5','92','257549','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729818),('5','92','257549','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729819),('5','92','257550','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729820),('5','92','257550','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729821),('5','92','257550','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729822),('5','92','257551','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729823),('5','92','257551','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729824),('5','92','257551','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729825),('5','92','257552','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729826),('5','92','257552','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729827),('5','92','257552','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729828),('5','92','257553','231',165.00,165.00,1583.47,0.00,0.00,0.00,0.00,729829),('5','92','257553','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729830),('5','92','257553','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729831),('5','92','257554','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729832),('5','92','257554','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729833),('5','92','257554','231',165.00,165.00,5210.87,0.00,0.00,0.00,0.00,729834),('5','92','257555','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729835),('5','92','257555','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729836),('5','92','257555','231',165.00,165.00,7854.42,0.00,0.00,0.00,0.00,729837),('5','92','257556','231',165.00,165.00,9533.93,0.00,0.00,0.00,0.00,729838),('5','92','257556','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729839),('5','92','257556','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729840),('5','92','257557','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729841),('5','92','257557','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729842),('5','92','257557','231',165.00,165.00,1143.19,0.00,0.00,0.00,0.00,729843),('5','92','257558','231',165.00,165.00,4527.08,0.00,0.00,0.00,0.00,729844),('5','92','257558','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729845),('5','92','257558','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729846),('5','92','257559','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729847),('5','92','257559','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729848),('5','92','257559','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729849),('5','92','257560','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729850),('5','92','257560','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729851),('5','92','257560','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729852),('5','92','257561','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729853),('5','92','257561','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729854),('5','92','257561','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729855),('5','92','257562','231',165.00,165.00,4344.14,0.00,0.00,0.00,0.00,729856),('5','92','257562','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729857),('5','92','257562','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729858),('5','92','257563','231',165.00,165.00,5568.60,0.00,0.00,0.00,0.00,729859),('5','92','257563','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729860),('5','92','257563','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729861),('5','92','257564','231',165.00,165.00,3545.59,0.00,0.00,0.00,0.00,729862),('5','92','257564','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729863),('5','92','257564','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729864),('5','92','257565','231',165.00,165.00,2098.57,0.00,0.00,0.00,0.00,729865),('5','92','257565','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729866),('5','92','257565','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729867),('5','92','257566','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729868),('5','92','257566','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729869),('5','92','257566','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729870),('5','92','257567','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729871),('5','92','257567','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729872),('5','92','257567','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729873),('5','92','257568','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729874),('5','92','257568','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729875),('5','92','257568','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729876),('5','92','257569','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729877),('5','92','257569','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729878),('5','92','257569','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729879),('5','92','257570','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729880),('5','92','257570','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729881),('5','92','257570','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729882),('5','92','257571','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729883),('5','92','257571','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729884),('5','92','257571','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729885),('5','92','257572','231',165.00,165.00,1551.73,0.00,0.00,0.00,0.00,729886),('5','92','257572','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729887),('5','92','257572','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729888),('5','92','257573','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729889),('5','92','257573','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729890),('5','92','257573','231',165.00,165.00,6278.74,0.00,0.00,0.00,0.00,729891),('5','92','257574','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729892),('5','92','257574','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729893),('5','92','257574','231',165.00,165.00,8646.75,0.00,0.00,0.00,0.00,729894),('5','92','257575','231',165.00,165.00,9961.45,0.00,0.00,0.00,0.00,729895),('5','92','257575','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729896),('5','92','257575','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729897),('5','92','257576','231',165.00,165.00,3590.76,0.00,0.00,0.00,0.00,729898),('5','92','257576','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729899),('5','92','257576','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729900),('5','92','257577','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729901),('5','92','257577','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729902),('5','92','257577','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729903),('5','92','257578','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729904),('5','92','257578','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729905),('5','92','257578','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729906),('5','92','257579','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729907),('5','92','257579','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729908),('5','92','257579','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729909),('5','92','257580','231',165.00,165.00,5761.47,0.00,0.00,0.00,0.00,729910),('5','92','257580','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729911),('5','92','257580','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729912),('5','92','257581','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729913),('5','92','257581','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729914),('5','92','257581','231',165.00,165.00,10346.08,0.00,0.00,0.00,0.00,729915),('5','92','257582','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729916),('5','92','257582','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729917),('5','92','257582','231',165.00,165.00,6430.62,0.00,0.00,0.00,0.00,729918),('5','92','257583','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729919),('5','92','257583','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729920),('5','92','257583','231',165.00,165.00,4391.06,0.00,0.00,0.00,0.00,729921),('5','92','257584','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729922),('5','92','257584','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729923),('5','92','257584','231',165.00,165.00,1984.50,0.00,0.00,0.00,0.00,729924),('5','92','257585','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729925),('5','92','257585','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729926),('5','92','257585','231',165.00,165.00,1152.81,0.00,0.00,0.00,0.00,729927),('5','92','257586','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729928),('5','92','257586','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729929),('5','92','257586','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729930),('5','92','257587','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729931),('5','92','257587','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729932),('5','92','257587','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729933),('5','92','257588','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729934),('5','92','257588','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729935),('5','92','257588','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729936),('5','92','257589','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729937),('5','92','257589','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729938),('5','92','257589','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729939),('5','92','257590','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729940),('5','92','257590','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729941),('5','92','257590','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729942),('5','92','257591','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729943),('5','92','257591','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729944),('5','92','257591','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729945),('5','92','257592','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729946),('5','92','257592','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729947),('5','92','257592','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729948),('5','92','257593','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729949),('5','92','257593','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729950),('5','92','257593','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729951),('5','92','257594','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729952),('5','92','257594','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729953),('5','92','257594','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729954),('5','92','257595','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729955),('5','92','257595','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729956),('5','92','257595','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729957),('5','92','257596','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729958),('5','92','257596','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729959),('5','92','257596','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729960),('5','92','257597','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729961),('5','92','257597','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729962),('5','92','257597','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729963),('5','92','257598','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729964),('5','92','257598','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729965),('5','92','257598','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729966),('5','92','257599','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729967),('5','92','257599','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729968),('5','92','257599','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729969),('5','92','257600','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729970),('5','92','257600','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729971),('5','92','257600','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729972),('5','92','257601','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729973),('5','92','257601','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729974),('5','92','257601','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729975),('5','92','257602','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729976),('5','92','257602','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729977),('5','92','257602','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729978),('5','92','257603','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729979),('5','92','257603','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729980),('5','92','257603','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729981),('5','92','257604','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729982),('5','92','257604','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729983),('5','92','257604','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729984),('5','92','257605','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729985),('5','92','257605','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729986),('5','92','257605','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729987),('5','92','257606','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729988),('5','92','257606','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729989),('5','92','257606','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729990),('5','92','257607','231',165.00,165.00,4562.98,0.00,0.00,0.00,0.00,729991),('5','92','257607','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729992),('5','92','257607','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729993),('5','92','257608','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729994),('5','92','257608','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729995),('5','92','257608','231',165.00,165.00,4481.12,0.00,0.00,0.00,0.00,729996),('5','92','257609','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,729997),('5','92','257609','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729998),('5','92','257609','231',165.00,165.00,1600.00,0.00,0.00,0.00,0.00,729999),('5','92','257610','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730000),('5','92','257610','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730001),('5','92','257610','231',165.00,165.00,2473.18,0.00,0.00,0.00,0.00,730002),('5','92','257611','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730003),('5','92','257611','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730004),('5','92','257611','231',165.00,165.00,1631.01,0.00,0.00,0.00,0.00,730005),('5','92','257612','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730006),('5','92','257612','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730007),('5','92','257612','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730008),('5','92','257613','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730009),('5','92','257613','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730010),('5','92','257613','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730011),('5','92','257614','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730012),('5','92','257614','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730013),('5','92','257614','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730014),('5','92','257615','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730015),('5','92','257615','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730016),('5','92','257615','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730017),('5','92','257616','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730018),('5','92','257616','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730019),('5','92','257616','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730020),('5','92','257617','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730021),('5','92','257617','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730022),('5','92','257617','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730023),('5','92','257618','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730024),('5','92','257618','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730025),('5','92','257618','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730026),('5','92','257619','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730027),('5','92','257619','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730028),('5','92','257619','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730029),('5','92','257620','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730030),('5','92','257620','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730031),('5','92','257620','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730032),('5','92','257621','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730033),('5','92','257621','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730034),('5','92','257621','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730035),('5','92','257622','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730036),('5','92','257622','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730037),('5','92','257622','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730038),('5','92','257623','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730039),('5','92','257623','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730040),('5','92','257623','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730041),('5','92','257624','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730042),('5','92','257624','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730043),('5','92','257624','231',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730044),('5','92','257625','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730045),('5','92','257625','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730046),('5','92','257625','231',165.00,165.00,2067.77,0.00,0.00,0.00,0.00,730047),('5','92','257626','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730048),('5','92','257626','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730049),('5','92','257626','231',165.00,165.00,4303.93,0.00,0.00,0.00,0.00,730050),('5','92','257627','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730051),('5','92','257627','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730052),('5','92','257627','231',165.00,165.00,4439.76,0.00,0.00,0.00,0.00,730053),('5','92','257628','232',440.00,800.00,0.00,0.00,0.00,0.00,0.00,730054),('5','92','257628','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730055),('5','92','257628','231',165.00,185.00,5529.18,0.00,0.00,0.00,0.00,730056),('5','92','257629','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730057),('5','92','257629','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730058),('5','92','257629','231',165.00,185.00,4481.12,0.00,0.00,0.00,0.00,730059),('5','92','257630','231',165.00,185.00,3418.13,0.00,0.00,0.00,0.00,730060),('5','92','257630','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730061),('5','92','257630','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730062),('5','92','257631','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730063),('5','92','257631','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730064),('5','92','257631','231',165.00,185.00,3387.97,0.00,0.00,0.00,0.00,730065),('5','92','257632','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730066),('5','92','257632','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','92','257632','231',165.00,185.00,2473.75,0.00,0.00,0.00,0.00,730068),('5','92','257633','231',185.00,165.00,5286.81,0.00,0.00,0.00,0.00,730069),('5','92','257633','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730070),('5','92','257633','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730071),('5','92','257634','231',185.00,165.00,7864.95,0.00,0.00,0.00,0.00,730072),('5','92','257634','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730073),('5','92','257634','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730074),('5','92','257635','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730075),('5','92','257635','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','92','257635','231',185.00,185.00,4606.58,0.00,0.00,0.00,0.00,730077),('5','92','257636','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730078),('5','92','257636','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730079),('5','92','257636','231',185.00,185.00,4569.30,0.00,0.00,0.00,0.00,730080),('5','92','257637','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730081),('5','92','257637','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','92','257637','231',185.00,185.00,11368.56,0.00,0.00,0.00,0.00,730083),('5','92','257638','231',185.00,185.00,8407.72,0.00,0.00,0.00,0.00,730084),('5','92','257638','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730085),('5','92','257638','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730086),('5','92','257639','231',185.00,185.00,9150.26,0.00,0.00,0.00,0.00,730087),('5','92','257639','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730088),('5','92','257639','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730089),('5','92','257640','231',185.00,185.00,6442.40,0.00,0.00,0.00,0.00,730090),('5','92','257640','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730091),('5','92','257640','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730092),('5','92','257641','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730093),('5','92','257641','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','92','257641','231',185.00,185.00,5594.36,0.00,0.00,0.00,0.00,730095),('5','92','257642','231',185.00,185.00,4593.06,0.00,0.00,0.00,0.00,730096),('5','92','257642','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730097),('5','92','257642','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730098),('5','92','257643','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730099),('5','92','257643','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','92','257643','231',185.00,185.00,8108.22,0.00,0.00,0.00,0.00,730101),('5','92','257644','231',185.00,185.00,5389.81,0.00,0.00,0.00,0.00,730102),('5','92','257644','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730103),('5','92','257644','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730104),('5','92','257645','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730105),('5','92','257645','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','92','257645','231',185.00,185.00,11946.67,0.00,0.00,0.00,0.00,730107),('5','92','257646','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730108),('5','92','257646','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','92','257646','231',185.00,185.00,281.63,0.00,0.00,0.00,0.00,730110),('5','92','257647','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730111),('5','92','257647','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730112),('5','92','257647','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730113),('5','92','257648','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730114),('5','92','257648','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730115),('5','92','257648','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730116),('5','92','257649','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730117),('5','92','257649','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730118),('5','92','257649','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730119),('5','92','257650','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730120),('5','92','257650','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730121),('5','92','257650','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730122),('5','92','257651','231',185.00,185.00,4983.11,0.00,0.00,0.00,0.00,730123),('5','92','257651','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730124),('5','92','257651','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730125),('5','92','257652','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730126),('5','92','257652','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','92','257652','231',185.00,185.00,5559.67,0.00,0.00,0.00,0.00,730128),('5','92','257653','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730129),('5','92','257653','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730130),('5','92','257653','231',185.00,185.00,6159.18,0.00,0.00,0.00,0.00,730131),('5','92','257654','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730132),('5','92','257654','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','92','257654','231',185.00,185.00,10451.71,0.00,0.00,0.00,0.00,730134),('5','92','257655','231',185.00,185.00,3156.13,0.00,0.00,0.00,0.00,730135),('5','92','257655','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730136),('5','92','257655','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730137),('5','92','257656','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730138),('5','92','257656','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','92','257656','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730140),('5','92','257657','231',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730141),('5','92','257657','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730142),('5','92','257657','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730143),('5','92','257658','231',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730144),('5','92','257658','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730145),('5','92','257658','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730146),('5','92','257659','231',185.00,185.00,1284.45,0.00,0.00,0.00,0.00,730147),('5','92','257659','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730148),('5','92','257659','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730149),('5','92','257660','231',185.00,185.00,3889.53,0.00,0.00,0.00,0.00,730150),('5','92','257660','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730151),('5','92','257660','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730152),('5','92','257661','231',185.00,185.00,5018.06,0.00,0.00,0.00,0.00,730153),('5','92','257661','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730154),('5','92','257661','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730155),('5','92','257662','231',185.00,185.00,3843.03,0.00,0.00,0.00,0.00,730156),('5','92','257662','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730157),('5','92','257662','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730158),('5','92','257663','231',185.00,185.00,5370.98,0.00,0.00,0.00,0.00,730159),('5','92','257663','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730160),('5','92','257663','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730161),('5','92','257664','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730162),('5','92','257664','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','92','257664','231',185.00,185.00,4463.86,0.00,0.00,0.00,0.00,730164),('5','92','257665','231',185.00,185.00,4030.53,0.00,0.00,0.00,0.00,730165),('5','92','257665','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730166),('5','92','257665','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730167),('5','92','257666','231',185.00,185.00,2385.64,0.00,0.00,0.00,0.00,730168),('5','92','257666','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730169),('5','92','257666','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730170),('5','92','257667','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730171),('5','92','257667','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730172),('5','92','257667','231',185.00,185.00,4690.69,0.00,0.00,0.00,0.00,730173),('5','92','257668','231',185.00,185.00,4897.99,0.00,0.00,0.00,0.00,730174),('5','92','257668','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730175),('5','92','257668','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730176),('5','92','257669','231',185.00,185.00,2020.60,0.00,0.00,0.00,0.00,730177),('5','92','257669','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730178),('5','92','257669','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730179),('5','92','257670','231',185.00,185.00,5858.58,0.00,0.00,0.00,0.00,730180),('5','92','257670','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730181),('5','92','257670','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730182),('5','92','257671','231',185.00,185.00,4786.31,0.00,0.00,0.00,0.00,730183),('5','92','257671','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730184),('5','92','257671','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730185),('5','92','257672','231',185.00,185.00,3624.35,0.00,0.00,0.00,0.00,730186),('5','92','257672','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730187),('5','92','257672','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730188),('5','92','257673','231',185.00,185.00,3933.51,0.00,0.00,0.00,0.00,730189),('5','92','257673','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730190),('5','92','257673','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730191),('5','92','257674','231',185.00,185.00,5001.94,0.00,0.00,0.00,0.00,730192),('5','92','257674','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730193),('5','92','257674','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730194),('5','92','257675','231',185.00,185.00,3478.15,0.00,0.00,0.00,0.00,730195),('5','92','257675','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730196),('5','92','257675','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730197),('5','92','257676','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730198),('5','92','257676','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730199),('5','92','257676','231',185.00,185.00,2419.86,0.00,0.00,0.00,0.00,730200),('5','92','257677','231',185.00,185.00,4545.63,0.00,0.00,0.00,0.00,730201),('5','92','257677','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730202),('5','92','257677','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730203),('5','92','257678','231',185.00,185.00,2501.91,0.00,0.00,0.00,0.00,730204),('5','92','257678','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730205),('5','92','257678','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730206),('5','92','257679','231',185.00,185.00,5429.63,0.00,0.00,0.00,0.00,730207),('5','92','257679','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730208),('5','92','257679','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730209),('5','92','257680','231',185.00,185.00,3359.91,0.00,0.00,0.00,0.00,730210),('5','92','257680','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730211),('5','92','257680','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730212),('5','92','257681','231',185.00,185.00,5712.70,0.00,0.00,0.00,0.00,730213),('5','92','257681','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730214),('5','92','257681','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730215),('5','92','257682','231',185.00,185.00,4206.61,0.00,0.00,0.00,0.00,730216),('5','92','257682','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730217),('5','92','257682','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730218),('5','92','257683','231',185.00,185.00,160.39,0.00,0.00,0.00,0.00,730219),('5','92','257683','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730220),('5','92','257683','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730221),('5','92','257684','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730222),('5','92','257684','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730223),('5','92','257684','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730224),('5','92','257685','231',185.00,185.00,2845.15,0.00,0.00,0.00,0.00,730225),('5','92','257685','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730226),('5','92','257685','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730227),('5','92','257686','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730228),('5','92','257686','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730229),('5','92','257686','231',185.00,185.00,5443.94,0.00,0.00,0.00,0.00,730230),('5','92','257687','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730231),('5','92','257687','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730232),('5','92','257687','231',185.00,185.00,3537.37,0.00,0.00,0.00,0.00,730233),('5','92','257688','231',185.00,185.00,5922.46,0.00,0.00,0.00,0.00,730234),('5','92','257688','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730235),('5','92','257688','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730236),('5','92','257689','231',185.00,185.00,3116.86,0.00,0.00,0.00,0.00,730237),('5','92','257689','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730238),('5','92','257689','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730239),('5','92','257690','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730240),('5','92','257690','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730241),('5','92','257690','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730242),('5','92','257691','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730243),('5','92','257691','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730244),('5','92','257691','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730245),('5','92','257692','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730246),('5','92','257692','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730247),('5','92','257692','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730248),('5','92','257693','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730249),('5','92','257693','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730250),('5','92','257693','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730251),('5','92','257694','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730252),('5','92','257694','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730253),('5','92','257694','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730254),('5','92','257695','231',185.00,185.00,2186.68,0.00,0.00,0.00,0.00,730255),('5','92','257695','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730256),('5','92','257695','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730257),('5','92','257696','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730258),('5','92','257696','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730259),('5','92','257696','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730260),('5','92','257697','231',185.00,185.00,4242.39,0.00,0.00,0.00,0.00,730261),('5','92','257697','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730262),('5','92','257697','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730263),('5','92','257698','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730264),('5','92','257698','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730265),('5','92','257698','231',185.00,185.00,4953.99,0.00,0.00,0.00,0.00,730266),('5','92','257699','231',185.00,185.00,3715.87,0.00,0.00,0.00,0.00,730267),('5','92','257699','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730268),('5','92','257699','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730269),('5','92','257700','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730270),('5','92','257700','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730271),('5','92','257700','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730272),('5','92','257701','231',185.00,185.00,2167.55,0.00,0.00,0.00,0.00,730273),('5','92','257701','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730274),('5','92','257701','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730275),('5','92','257702','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730276),('5','92','257702','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730277),('5','92','257702','231',185.00,185.00,2696.88,0.00,0.00,0.00,0.00,730278),('5','92','257703','231',185.00,185.00,5857.18,0.00,0.00,0.00,0.00,730279),('5','92','257703','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730280),('5','92','257703','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730281),('5','92','257704','231',185.00,185.00,3838.79,0.00,0.00,0.00,0.00,730282),('5','92','257704','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730283),('5','92','257704','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730284),('5','92','257705','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730285),('5','92','257705','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730286),('5','92','257705','231',185.00,185.00,4955.33,0.00,0.00,0.00,0.00,730287),('5','92','257706','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730288),('5','92','257706','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730289),('5','92','257706','231',185.00,185.00,5990.56,0.00,0.00,0.00,0.00,730290),('5','92','257707','231',185.00,185.00,4066.98,0.00,0.00,0.00,0.00,730291),('5','92','257707','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730292),('5','92','257707','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730293),('5','92','257708','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730294),('5','92','257708','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','92','257708','231',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730296),('5','92','257709','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730297),('5','92','257709','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730298),('5','92','257709','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730299),('5','92','257710','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730300),('5','92','257710','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730301),('5','92','257710','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730302),('5','92','257711','231',185.00,185.00,2126.95,0.00,0.00,0.00,0.00,730303),('5','92','257711','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730304),('5','92','257711','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730305),('5','92','257712','231',185.00,185.00,4511.46,0.00,0.00,0.00,0.00,730306),('5','92','257712','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730307),('5','92','257712','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730308),('5','92','257713','231',185.00,185.00,4559.32,0.00,0.00,0.00,0.00,730309),('5','92','257713','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730310),('5','92','257713','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730311),('5','92','257714','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730312),('5','92','257714','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730313),('5','92','257714','231',185.00,185.00,5636.82,0.00,0.00,0.00,0.00,730314),('5','92','257715','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730315),('5','92','257715','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730316),('5','92','257715','231',185.00,185.00,4904.48,0.00,0.00,0.00,0.00,730317),('5','92','257716','231',185.00,185.00,6305.56,0.00,0.00,0.00,0.00,730318),('5','92','257716','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730319),('5','92','257716','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730320),('5','92','257717','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730321),('5','92','257717','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730322),('5','92','257717','231',185.00,185.00,7717.12,0.00,0.00,0.00,0.00,730323),('5','92','257718','231',185.00,185.00,9548.00,0.00,0.00,0.00,0.00,730324),('5','92','257718','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730325),('5','92','257718','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730326),('5','92','257719','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730327),('5','92','257719','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730328),('5','92','257719','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730329),('5','92','257720','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730330),('5','92','257720','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730331),('5','92','257720','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730332),('5','92','257721','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730333),('5','92','257721','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730334),('5','92','257721','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730335),('5','92','257722','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730336),('5','92','257722','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730337),('5','92','257722','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730338),('5','92','257723','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730339),('5','92','257723','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730340),('5','92','257723','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730341),('5','92','257724','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730342),('5','92','257724','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730343),('5','92','257724','231',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730344),('5','92','257725','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730345),('5','92','257725','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730346),('5','92','257725','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730347),('5','92','257726','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730348),('5','92','257726','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730349),('5','92','257726','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730350),('5','92','257727','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730351),('5','92','257727','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730352),('5','92','257727','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730353),('5','92','257728','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730354),('5','92','257728','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730355),('5','92','257728','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730356),('5','92','257729','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730357),('5','92','257729','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730358),('5','92','257729','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730359),('5','92','257730','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730360),('5','92','257730','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730361),('5','92','257730','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730362),('5','92','257731','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730363),('5','92','257731','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730364),('5','92','257731','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730365),('5','92','257732','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730366),('5','92','257732','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730367),('5','92','257732','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730368),('5','92','257733','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730369),('5','92','257733','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730370),('5','92','257733','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730371),('5','92','257734','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730372),('5','92','257734','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730373),('5','92','257734','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730374),('5','92','257735','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730375),('5','92','257735','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730376),('5','92','257735','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730377),('5','92','257736','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730378),('5','92','257736','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730379),('5','92','257736','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730380),('5','92','257737','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730381),('5','92','257737','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730382),('5','92','257737','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730383),('5','92','257738','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730384),('5','92','257738','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730385),('5','92','257738','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730386),('5','92','257739','231',185.00,185.00,2563.45,0.00,0.00,0.00,0.00,730387),('5','92','257739','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730388),('5','92','257739','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730389),('5','92','257740','231',185.00,185.00,7317.53,0.00,0.00,0.00,0.00,730390),('5','92','257740','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730391),('5','92','257740','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730392),('5','92','257741','231',185.00,185.00,9935.22,0.00,0.00,0.00,0.00,730393),('5','92','257741','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730394),('5','92','257741','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730395),('5','92','257742','231',185.00,185.00,10843.73,0.00,0.00,0.00,0.00,730396),('5','92','257742','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730397),('5','92','257742','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730398),('5','92','257743','231',185.00,185.00,9659.42,0.00,0.00,0.00,0.00,730399),('5','92','257743','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730400),('5','92','257743','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730401),('5','92','257744','231',185.00,185.00,11761.87,0.00,0.00,0.00,0.00,730402),('5','92','257744','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730403),('5','92','257744','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730404),('5','92','257745','231',185.00,185.00,13328.93,0.00,0.00,0.00,0.00,730405),('5','92','257745','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730406),('5','92','257745','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730407),('5','92','257746','231',185.00,185.00,12995.24,0.00,0.00,0.00,0.00,730408),('5','92','257746','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730409),('5','92','257746','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730410),('5','92','257747','231',185.00,185.00,6998.01,0.00,0.00,0.00,0.00,730411),('5','92','257747','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730412),('5','92','257747','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730413),('5','92','257748','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730414),('5','92','257748','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730415),('5','92','257748','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730416),('5','92','257749','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730417),('5','92','257749','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730418),('5','92','257749','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730419),('5','92','257750','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730420),('5','92','257750','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730421),('5','92','257750','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730422),('5','92','257751','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730423),('5','92','257751','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730424),('5','92','257751','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730425),('5','92','257752','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730426),('5','92','257752','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730427),('5','92','257752','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730428),('5','92','257753','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730429),('5','92','257753','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730430),('5','92','257753','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730431),('5','92','257754','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730432),('5','92','257754','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730433),('5','92','257754','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730434),('5','92','257755','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730435),('5','92','257755','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730436),('5','92','257755','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730437),('5','92','257756','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730438),('5','92','257756','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730439),('5','92','257756','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730440),('5','92','257757','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730441),('5','92','257757','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730442),('5','92','257757','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730443),('5','92','257758','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730444),('5','92','257758','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730445),('5','92','257758','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730446),('5','92','257759','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730447),('5','92','257759','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730448),('5','92','257759','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730449),('5','92','257760','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730450),('5','92','257760','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730451),('5','92','257760','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730452),('5','92','257761','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730453),('5','92','257761','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730454),('5','92','257761','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730455),('5','92','257762','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730456),('5','92','257762','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730457),('5','92','257762','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730458),('5','92','257763','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730459),('5','92','257763','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730460),('5','92','257763','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730461),('5','92','257764','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730462),('5','92','257764','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730463),('5','92','257764','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730464),('5','92','257765','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730465),('5','92','257765','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730466),('5','92','257765','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730467),('5','92','257766','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730468),('5','92','257766','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730469),('5','92','257766','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730470),('5','92','257767','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730471),('5','92','257767','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730472),('5','92','257767','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730473),('5','92','257768','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730474),('5','92','257768','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730475),('5','92','257768','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730476),('5','92','257769','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730477),('5','92','257769','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730478),('5','92','257769','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730479),('5','92','257770','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730480),('5','92','257770','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730481),('5','92','257770','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730482),('5','92','257771','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730483),('5','92','257771','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730484),('5','92','257771','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730485),('5','92','257772','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730486),('5','92','257772','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730487),('5','92','257772','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730488),('5','92','257773','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730489),('5','92','257773','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730490),('5','92','257773','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730491),('5','92','257774','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730492),('5','92','257774','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730493),('5','92','257774','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730494),('5','92','257775','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730495),('5','92','257775','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730496),('5','92','257775','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730497),('5','92','257776','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730498),('5','92','257776','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730499),('5','92','257776','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730500),('5','92','257777','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730501),('5','92','257777','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730502),('5','92','257777','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730503),('5','92','257778','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730504),('5','92','257778','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730505),('5','92','257778','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730506),('5','92','257779','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730507),('5','92','257779','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730508),('5','92','257779','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730509),('5','92','257780','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730510),('5','92','257780','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730511),('5','92','257780','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730512),('5','92','257781','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730513),('5','92','257781','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730514),('5','92','257781','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730515),('5','92','257782','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730516),('5','92','257782','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730517),('5','92','257782','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730518),('5','92','257783','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730519),('5','92','257783','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730520),('5','92','257783','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730521),('5','92','257784','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730522),('5','92','257784','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730523),('5','92','257784','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730524),('5','92','257785','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730525),('5','92','257785','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730526),('5','92','257785','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730527),('5','92','257786','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730528),('5','92','257786','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730529),('5','92','257786','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730530),('5','92','257787','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730531),('5','92','257787','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730532),('5','92','257787','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730533),('5','92','257788','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730534),('5','92','257788','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730535),('5','92','257788','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730536),('5','92','257789','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730537),('5','92','257789','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730538),('5','92','257789','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730539),('5','92','257790','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730540),('5','92','257790','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730541),('5','92','257790','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730542),('5','92','257791','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730543),('5','92','257791','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730544),('5','92','257791','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730545),('5','92','257792','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730546),('5','92','257792','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730547),('5','92','257792','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730548),('5','92','257793','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730549),('5','92','257793','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730550),('5','92','257793','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730551),('5','92','257794','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730552),('5','92','257794','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730553),('5','92','257794','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730554),('5','92','257795','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730555),('5','92','257795','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730556),('5','92','257795','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730557),('5','92','257796','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730558),('5','92','257796','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730559),('5','92','257796','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730560),('5','92','257797','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730561),('5','92','257797','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730562),('5','92','257797','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730563),('5','92','257798','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730564),('5','92','257798','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730565),('5','92','257798','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730566),('5','92','257799','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730567),('5','92','257799','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730568),('5','92','257799','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730569),('5','92','257800','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730570),('5','92','257800','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730571),('5','92','257800','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730572),('5','92','257801','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730573),('5','92','257801','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730574),('5','92','257801','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730575),('5','92','257802','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730576),('5','92','257802','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730577),('5','92','257802','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730578),('5','92','257803','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730579),('5','92','257803','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730580),('5','92','257803','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730581),('5','92','257804','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730582),('5','92','257804','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730583),('5','92','257804','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730584),('5','92','257805','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730585),('5','92','257805','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730586),('5','92','257805','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730587),('5','92','257806','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730588),('5','92','257806','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730589),('5','92','257806','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730590),('5','92','257807','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730591),('5','92','257807','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730592),('5','92','257807','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730593),('5','92','257808','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730594),('5','92','257808','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730595),('5','92','257808','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730596),('5','92','257809','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730597),('5','92','257809','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730598),('5','92','257809','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730599),('5','92','257810','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730600),('5','92','257810','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730601),('5','92','257810','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730602),('5','92','257811','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730603),('5','92','257811','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730604),('5','92','257811','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730605),('5','92','257812','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730606),('5','92','257812','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730607),('5','92','257812','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730608),('5','92','257813','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730609),('5','92','257813','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730610),('5','92','257813','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730611),('5','92','257814','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730612),('5','92','257814','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730613),('5','92','257814','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730614),('5','92','257815','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730615),('5','92','257815','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730616),('5','92','257815','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730617),('5','92','257816','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730618),('5','92','257816','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730619),('5','92','257816','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730620),('5','92','257817','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730621),('5','92','257817','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730622),('5','92','257817','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730623),('5','92','257818','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730624),('5','92','257818','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730625),('5','92','257818','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730626),('5','92','257819','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730627),('5','92','257819','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730628),('5','92','257819','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730629),('5','92','257820','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730630),('5','92','257820','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730631),('5','92','257820','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730632),('5','92','257821','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730633),('5','92','257821','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730634),('5','92','257821','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730635),('5','92','257822','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730636),('5','92','257822','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730637),('5','92','257822','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730638),('5','92','257823','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730639),('5','92','257823','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730640),('5','92','257823','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730641),('5','92','257824','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730642),('5','92','257824','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730643),('5','92','257824','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730644),('5','92','257825','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730645),('5','92','257825','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730646),('5','92','257825','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730647),('5','92','257826','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730648),('5','92','257826','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730649),('5','92','257826','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730650),('5','92','257827','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730651),('5','92','257827','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730652),('5','92','257827','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730653),('5','92','257828','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730654),('5','92','257828','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730655),('5','92','257828','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730656),('5','92','257829','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730657),('5','92','257829','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730658),('5','92','257829','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730659),('5','92','257830','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730660),('5','92','257830','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730661),('5','92','257830','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730662),('5','92','257831','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730663),('5','92','257831','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730664),('5','92','257831','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730665),('5','92','257832','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730666),('5','92','257832','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730667),('5','92','257832','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730668),('5','92','257833','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730669),('5','92','257833','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730670),('5','92','257833','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730671),('5','92','257834','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730672),('5','92','257834','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730673),('5','92','257834','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730674),('5','92','257835','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730675),('5','92','257835','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730676),('5','92','257835','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730677),('5','92','257836','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730678),('5','92','257836','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730679),('5','92','257836','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730680),('5','92','257837','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730681),('5','92','257837','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730682),('5','92','257837','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730683),('5','92','257838','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730684),('5','92','257838','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730685),('5','92','257838','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730686),('5','92','257839','231',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730687),('5','92','257839','232',440.00,440.00,0.00,0.00,0.00,0.00,0.00,730688),('5','92','257839','233',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730689);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=245 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',242,'92','PMS TANKS','Tanks Containing Petroleum.'),('5',243,'92','AGO TANK','Tank Containing Diesel.'),('5',244,'92','DPK TANK','Tank Containing Kerosene.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=602 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','92','242',598,0,'231','PMS TANK 1',44000.00,1.00,7754.13,'PMS TANK 1','391','2018-11-06 14:10:27','2021-07-13 12:28:32','600',5,1),('5','92','242',599,0,'231','PMS TANK 2',43000.00,1.00,25926.51,'PMS TANK 2','391','2018-11-06 14:14:37','2021-07-13 12:29:01','600',5,1),('5','92','243',600,0,'232','AGO TANK 3',44000.00,1.00,7524.91,'AGO TANK 3','391','2018-11-06 14:17:23','2018-11-06 14:17:23','391',5,1),('5','92','244',601,0,'233','DPK TANK 4',43000.00,1.00,0.00,'DPK TANK 4','391','2018-11-06 14:18:57','2018-11-06 14:18:57','391',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','92',601,0.00,'2023-02-17 19:36:09'),(2,'5','92',600,24650.00,'2023-02-17 19:36:09'),(3,'5','92',599,15850.00,'2023-02-17 19:36:09'),(4,'5','92',598,1.99,'2023-02-17 19:36:09');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2614340 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2406839,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,3597000.00,21800.00,0.00,0.00,'2021-12-30 20:03:24','',''),(2406888,'5','92',NULL,231,'Returned purchase #88498 to SALBAS OIL & GAS NIGERIA LIMIT',3597000.00,0.00,0.00,21800.00,0.00,'2021-12-30 20:42:07','',''),(2406918,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,3679500.00,22300.00,0.00,0.00,'2021-12-30 20:53:41','',''),(2407094,'5','92',NULL,231,'Reception corrector for bridging 129281',0.00,0.00,0.00,22300.00,0.00,'2021-12-30 21:57:47','',''),(2407095,'5','92','598',231,'Received from bridging 129281',0.00,0.00,22300.00,0.00,0.00,'2021-12-30 21:57:47','',''),(2414169,'5','92','598',231,'Sale Id shift 250075',0.00,0.00,0.00,780.00,0.00,'2021-12-31 20:47:42','',''),(2414170,'5','92',NULL,231,'Sale Id shift 250075',128700.00,0.00,0.00,0.00,0.00,'2021-12-31 20:47:42','',''),(2422437,'5','92','598',231,'Sale Id shift 250304',0.00,0.00,0.00,2251.53,0.00,'2022-01-02 10:13:28','',''),(2422438,'5','92','598',231,'Sale Id shift 250304',0.00,0.00,0.00,3329.96,0.00,'2022-01-02 10:13:28','',''),(2422439,'5','92',NULL,231,'Sale Id shift 250304',920945.85,0.00,0.00,0.00,0.00,'2022-01-02 10:13:28','',''),(2424570,'5','92','598',231,'Sale Id shift 250644',0.00,0.00,0.00,2150.22,0.00,'2022-01-02 14:17:00','',''),(2424571,'5','92','598',231,'Sale Id shift 250644',0.00,0.00,0.00,3311.37,0.00,'2022-01-02 14:17:00','',''),(2424572,'5','92',NULL,231,'Sale Id shift 250644',901162.35,0.00,0.00,0.00,0.00,'2022-01-02 14:17:00','',''),(2432121,'5','92','598',231,'Sale Id shift 250735',0.00,0.00,0.00,3969.63,0.00,'2022-01-03 16:53:03','',''),(2432122,'5','92','598',231,'Sale Id shift 250735',0.00,0.00,0.00,4072.15,0.00,'2022-01-03 16:53:03','',''),(2432123,'5','92',NULL,231,'Sale Id shift 250735',1326893.70,0.00,0.00,0.00,0.00,'2022-01-03 16:53:03','',''),(2434566,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,2437.70,0.00,'2022-01-04 09:16:45','',''),(2434567,'5','92','598',0,'Inventory adjustment from tank dipping to 2837',0.00,0.00,2837.00,0.00,0.00,'2022-01-04 09:16:45','',''),(2434571,'5','92','599',0,'Tank level zero out for dipping',0.00,0.00,0.00,717.00,0.00,'2022-01-04 09:17:01','',''),(2434572,'5','92','599',0,'Inventory adjustment from tank dipping to 317',0.00,0.00,317.00,0.00,0.00,'2022-01-04 09:17:01','',''),(2437462,'5','92','598',231,'Sale Id shift 250953',0.00,0.00,0.00,1210.80,0.00,'2022-01-04 13:53:30','',''),(2437463,'5','92','598',231,'Sale Id shift 250953',0.00,0.00,0.00,1622.49,0.00,'2022-01-04 13:53:30','',''),(2437464,'5','92',NULL,231,'Sale Id shift 250953',467492.85,0.00,0.00,0.00,0.00,'2022-01-04 13:53:30','',''),(2437482,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4950000.00,30000.00,0.00,0.00,'2022-01-04 13:54:43','',''),(2438564,'5','92',NULL,231,'Reception corrector for bridging 129703',0.00,0.00,0.00,30000.00,0.00,'2022-01-04 15:18:56','',''),(2438565,'5','92','598',231,'Received from bridging 129703',0.00,0.00,30000.00,0.00,0.00,'2022-01-04 15:18:56','',''),(2442452,'5','92','598',231,'Sale Id shift 251208',0.00,0.00,0.00,6006.94,0.00,'2022-01-05 10:46:12','',''),(2442453,'5','92','598',231,'Sale Id shift 251208',0.00,0.00,0.00,6474.02,0.00,'2022-01-05 10:46:12','',''),(2442454,'5','92',NULL,231,'Sale Id shift 251208',2059358.40,0.00,0.00,0.00,0.00,'2022-01-05 10:46:12','',''),(2454886,'5','92','598',231,'Sale Id shift 251466',0.00,0.00,0.00,4220.72,0.00,'2022-01-06 18:16:01','',''),(2454887,'5','92','598',231,'Sale Id shift 251466',0.00,0.00,0.00,4640.24,0.00,'2022-01-06 18:16:01','',''),(2454888,'5','92',NULL,231,'Sale Id shift 251466',1462058.40,0.00,0.00,0.00,0.00,'2022-01-06 18:16:01','',''),(2458926,'5','92','598',231,'Sale Id shift 251736',0.00,0.00,0.00,3484.73,0.00,'2022-01-07 12:26:11','',''),(2458927,'5','92','598',231,'Sale Id shift 251736',0.00,0.00,0.00,3404.02,0.00,'2022-01-07 12:26:11','',''),(2458928,'5','92',NULL,231,'Sale Id shift 251736',1136643.75,0.00,0.00,0.00,0.00,'2022-01-07 12:26:11','',''),(2470890,'5','92','598',231,'Sale Id shift 251950',0.00,0.00,0.00,424.19,0.00,'2022-01-08 19:02:29','',''),(2470891,'5','92','598',231,'Sale Id shift 251950',0.00,0.00,0.00,1028.18,0.00,'2022-01-08 19:02:29','',''),(2470892,'5','92',NULL,231,'Sale Id shift 251950',239641.05,0.00,0.00,0.00,0.00,'2022-01-08 19:02:29','',''),(2612794,'5','92',NULL,232,'Balance from closing inventory values 2021-11-31 23:59:59',1206173.37,1305900.00,8706.00,8197.47,0.00,'2021-11-30 23:59:59','',''),(2612877,'5','92',NULL,231,'Balance from closing inventory values 2021-11-31 23:59:59',12927035.78,13026301.00,158254.00,157635.12,0.00,'2021-11-30 23:59:59','',''),(2613117,'5','92',NULL,233,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613240,'5','92','601',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613483,'5','92','598',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,80980.00,80977.44,0.00,'2021-11-30 23:59:59','',''),(2613579,'5','92','599',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,717.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613818,'5','92','600',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,4353.00,3844.47,0.00,'2021-11-30 23:59:59','',''),(2613819,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4933500.00,29900.00,0.00,0.00,'2022-02-08 10:58:44','',''),(2613820,'5','92',NULL,231,'Reception corrector for bridging 129704',0.00,0.00,0.00,29900.00,0.00,'2022-02-08 11:03:38','',''),(2613821,'5','92','598',231,'Received from bridging 129704',0.00,0.00,29900.00,0.00,0.00,'2022-02-08 11:03:38','',''),(2613822,'5','92','598',231,'Sale Id shift 257472',0.00,0.00,0.00,2647.85,0.00,'2022-02-08 11:39:48','',''),(2613823,'5','92','598',231,'Sale Id shift 257472',0.00,0.00,0.00,3923.30,0.00,'2022-02-08 11:39:48','',''),(2613824,'5','92',NULL,231,'Sale Id shift 257472',1084239.75,0.00,0.00,0.00,0.00,'2022-02-08 11:39:48','',''),(2613825,'5','92','598',231,'Sale Id shift 257473',0.00,0.00,0.00,4086.06,0.00,'2022-02-08 11:42:51','',''),(2613826,'5','92','598',231,'Sale Id shift 257473',0.00,0.00,0.00,3295.34,0.00,'2022-02-08 11:42:51','',''),(2613827,'5','92',NULL,231,'Sale Id shift 257473',1217931.00,0.00,0.00,0.00,0.00,'2022-02-08 11:42:51','',''),(2613828,'5','92','598',231,'Sale Id shift 257474',0.00,0.00,0.00,2343.47,0.00,'2022-02-08 11:46:15','',''),(2613829,'5','92','598',231,'Sale Id shift 257474',0.00,0.00,0.00,2157.44,0.00,'2022-02-08 11:46:15','',''),(2613830,'5','92',NULL,231,'Sale Id shift 257474',742650.15,0.00,0.00,0.00,0.00,'2022-02-08 11:46:15','',''),(2613831,'5','92','598',231,'Sale Id shift 257475',0.00,0.00,0.00,5226.32,0.00,'2022-02-08 11:49:51','',''),(2613832,'5','92','598',231,'Sale Id shift 257475',0.00,0.00,0.00,5231.25,0.00,'2022-02-08 11:49:51','',''),(2613833,'5','92',NULL,231,'Sale Id shift 257475',1725499.05,0.00,0.00,0.00,0.00,'2022-02-08 11:49:51','',''),(2613834,'5','92','598',231,'Sale Id shift 257476',0.00,0.00,0.00,398.48,0.00,'2022-02-08 11:54:34','',''),(2613835,'5','92','598',231,'Sale Id shift 257476',0.00,0.00,0.00,747.43,0.00,'2022-02-08 11:54:34','',''),(2613836,'5','92',NULL,231,'Sale Id shift 257476',189075.15,0.00,0.00,0.00,0.00,'2022-02-08 11:54:34','',''),(2613837,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,163.73,0.00,'2022-02-09 13:43:04','',''),(2613838,'5','92','598',0,'Inventory adjustment from tank dipping to 350',0.00,0.00,350.00,0.00,0.00,'2022-02-09 13:43:04','',''),(2613839,'5','92','599',0,'Tank level zero out for dipping',0.00,0.00,0.00,317.00,0.00,'2022-02-09 13:43:27','',''),(2613840,'5','92','599',0,'Inventory adjustment from tank dipping to 15850',0.00,0.00,15850.00,0.00,0.00,'2022-02-09 13:43:27','',''),(2613841,'5','92','600',0,'Tank level zero out for dipping',0.00,0.00,0.00,508.53,0.00,'2022-02-09 13:44:42','',''),(2613842,'5','92','600',0,'Inventory adjustment from tank dipping to 24650',0.00,0.00,24650.00,0.00,0.00,'2022-02-09 13:44:42','',''),(2613843,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4422000.00,26800.00,0.00,0.00,'2022-02-20 22:11:04','',''),(2613844,'5','92',NULL,231,'Reception corrector for bridging 129706',0.00,0.00,0.00,26800.00,0.00,'2022-02-21 19:31:00','',''),(2613845,'5','92','598',231,'Received from bridging 129706',0.00,0.00,26800.00,0.00,0.00,'2022-02-21 19:31:00','',''),(2613846,'5','92','598',231,'Sale Id shift 257489',0.00,0.00,0.00,5795.21,0.00,'2022-02-21 20:30:26','',''),(2613847,'5','92','598',231,'Sale Id shift 257489',0.00,0.00,0.00,5048.56,0.00,'2022-02-21 20:30:26','',''),(2613848,'5','92',NULL,231,'Sale Id shift 257489',1789222.05,0.00,0.00,0.00,0.00,'2022-02-21 20:30:26','',''),(2613849,'5','92','598',231,'Sale Id shift 257490',0.00,0.00,0.00,3162.15,0.00,'2022-02-22 07:23:19','',''),(2613850,'5','92','598',231,'Sale Id shift 257490',0.00,0.00,0.00,6262.68,0.00,'2022-02-22 07:23:19','',''),(2613851,'5','92',NULL,231,'Sale Id shift 257490',1555096.95,0.00,0.00,0.00,0.00,'2022-02-22 07:23:19','',''),(2613852,'5','92','598',231,'Sale Id shift 257491',0.00,0.00,0.00,1139.13,0.00,'2022-02-23 10:23:13','',''),(2613853,'5','92','598',231,'Sale Id shift 257491',0.00,0.00,0.00,2851.19,0.00,'2022-02-23 10:23:13','',''),(2613854,'5','92',NULL,231,'Sale Id shift 257491',658402.80,0.00,0.00,0.00,0.00,'2022-02-23 10:23:13','',''),(2613855,'5','92','598',231,'Sale Id shift 257492',0.00,0.00,0.00,1059.82,0.00,'2022-02-25 23:21:06','',''),(2613856,'5','92','598',231,'Sale Id shift 257492',0.00,0.00,0.00,1593.33,0.00,'2022-02-25 23:21:06','',''),(2613857,'5','92',NULL,231,'Sale Id shift 257492',437769.75,0.00,0.00,0.00,0.00,'2022-02-25 23:21:06','',''),(2613858,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-27 09:56:08','',''),(2613859,'5','92',NULL,231,'Reception corrector for bridging 129707',0.00,0.00,0.00,30000.00,0.00,'2022-02-28 10:22:56','',''),(2613860,'5','92','598',231,'Received from bridging 129707',0.00,0.00,30000.00,0.00,0.00,'2022-02-28 10:22:56','',''),(2613861,'5','92','598',231,'Sale Id shift 257495',0.00,0.00,0.00,1499.65,0.00,'2022-03-01 07:05:34','',''),(2613862,'5','92','598',231,'Sale Id shift 257495',0.00,0.00,0.00,3671.67,0.00,'2022-03-01 07:05:34','',''),(2613863,'5','92',NULL,231,'Sale Id shift 257495',853267.80,0.00,0.00,0.00,0.00,'2022-03-01 07:05:34','',''),(2613864,'5','92','598',231,'Sale Id shift 257496',0.00,0.00,0.00,7488.63,0.00,'2022-03-01 11:55:45','',''),(2613865,'5','92','598',231,'Sale Id shift 257496',0.00,0.00,0.00,5590.40,0.00,'2022-03-01 11:55:45','',''),(2613866,'5','92',NULL,231,'Sale Id shift 257496',2158039.95,0.00,0.00,0.00,0.00,'2022-03-01 11:55:45','',''),(2613867,'5','92','598',231,'Sale Id shift 257497',0.00,0.00,0.00,1586.29,0.00,'2022-03-01 22:09:26','',''),(2613868,'5','92','598',231,'Sale Id shift 257497',0.00,0.00,0.00,4272.75,0.00,'2022-03-01 22:09:26','',''),(2613869,'5','92',NULL,231,'Sale Id shift 257497',966741.60,0.00,0.00,0.00,0.00,'2022-03-01 22:09:26','',''),(2613870,'5','92','598',231,'Sale Id shift 257498',0.00,0.00,0.00,2990.76,0.00,'2022-03-02 09:42:25','',''),(2613871,'5','92','598',231,'Sale Id shift 257498',0.00,0.00,0.00,3116.86,0.00,'2022-03-02 09:42:25','',''),(2613872,'5','92',NULL,231,'Sale Id shift 257498',1007757.30,0.00,0.00,0.00,0.00,'2022-03-02 09:42:25','',''),(2613873,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,7425000.00,45000.00,0.00,0.00,'2022-03-09 09:26:48','',''),(2613874,'5','92',NULL,231,'Reception corrector for bridging 129708',0.00,0.00,0.00,43500.00,0.00,'2022-03-10 14:22:04','',''),(2613875,'5','92','598',231,'Received from bridging 129708',0.00,0.00,43500.00,0.00,0.00,'2022-03-10 14:22:04','',''),(2613876,'5','92','598',231,'Sale Id shift 257505',0.00,0.00,0.00,3092.38,0.00,'2022-03-10 15:37:59','',''),(2613877,'5','92','598',231,'Sale Id shift 257505',0.00,0.00,0.00,3228.51,0.00,'2022-03-10 15:37:59','',''),(2613878,'5','92',NULL,231,'Sale Id shift 257505',1042946.85,0.00,0.00,0.00,0.00,'2022-03-10 15:37:59','',''),(2613879,'5','92','598',231,'Sale Id shift 257506',0.00,0.00,0.00,3833.91,0.00,'2022-03-10 15:43:22','',''),(2613880,'5','92','598',231,'Sale Id shift 257506',0.00,0.00,0.00,3537.65,0.00,'2022-03-10 15:43:22','',''),(2613881,'5','92',NULL,231,'Sale Id shift 257506',1216307.40,0.00,0.00,0.00,0.00,'2022-03-10 15:43:22','',''),(2613882,'5','92','598',231,'Sale Id shift 257507',0.00,0.00,0.00,3155.04,0.00,'2022-03-12 10:26:58','',''),(2613883,'5','92','598',231,'Sale Id shift 257507',0.00,0.00,0.00,3406.32,0.00,'2022-03-12 10:26:58','',''),(2613884,'5','92',NULL,231,'Sale Id shift 257507',1082624.40,0.00,0.00,0.00,0.00,'2022-03-12 10:26:58','',''),(2613885,'5','92','598',231,'Sale Id shift 257508',0.00,0.00,0.00,3928.86,0.00,'2022-03-12 21:42:14','',''),(2613886,'5','92','598',231,'Sale Id shift 257508',0.00,0.00,0.00,4369.45,0.00,'2022-03-12 21:42:14','',''),(2613887,'5','92',NULL,231,'Sale Id shift 257508',1369221.15,0.00,0.00,0.00,0.00,'2022-03-12 21:42:14','',''),(2613888,'5','92','598',231,'Sale Id shift 257509',0.00,0.00,0.00,3600.05,0.00,'2022-03-12 22:36:27','',''),(2613889,'5','92','598',231,'Sale Id shift 257509',0.00,0.00,0.00,3596.60,0.00,'2022-03-12 22:36:27','',''),(2613890,'5','92',NULL,231,'Sale Id shift 257509',1187447.25,0.00,0.00,0.00,0.00,'2022-03-12 22:36:27','',''),(2613891,'5','92','598',231,'Sale Id shift 257510',0.00,0.00,0.00,3527.66,0.00,'2022-03-13 23:25:39','',''),(2613892,'5','92','598',231,'Sale Id shift 257510',0.00,0.00,0.00,3614.01,0.00,'2022-03-13 23:25:39','',''),(2613893,'5','92',NULL,231,'Sale Id shift 257510',1178375.55,0.00,0.00,0.00,0.00,'2022-03-13 23:25:39','',''),(2613894,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,247500.00,1500.00,0.00,0.00,'2022-03-14 17:14:48','',''),(2613895,'5','92',NULL,231,'Reception corrector for bridging 129709',0.00,0.00,0.00,1500.00,0.00,'2022-03-14 18:24:57','',''),(2613896,'5','92','598',231,'Received from bridging 129709',0.00,0.00,1500.00,0.00,0.00,'2022-03-14 18:24:57','',''),(2613897,'5','92','598',231,'Sale Id shift 257511',0.00,0.00,0.00,549.53,0.00,'2022-03-15 10:58:59','',''),(2613898,'5','92','598',231,'Sale Id shift 257511',0.00,0.00,0.00,1490.61,0.00,'2022-03-15 10:58:59','',''),(2613899,'5','92',NULL,231,'Sale Id shift 257511',336623.10,0.00,0.00,0.00,0.00,'2022-03-15 10:58:59','',''),(2613900,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4422000.00,26800.00,0.00,0.00,'2022-03-15 20:48:09','',''),(2613901,'5','92',NULL,231,'Reception corrector for bridging 129710',0.00,0.00,0.00,26800.00,0.00,'2022-03-16 16:38:41','',''),(2613902,'5','92','598',231,'Received from bridging 129710',0.00,0.00,26800.00,0.00,0.00,'2022-03-16 16:38:41','',''),(2613903,'5','92','598',231,'Sale Id shift 257512',0.00,0.00,0.00,2655.10,0.00,'2022-03-16 22:27:42','',''),(2613904,'5','92','598',231,'Sale Id shift 257512',0.00,0.00,0.00,2773.59,0.00,'2022-03-16 22:27:42','',''),(2613905,'5','92',NULL,231,'Sale Id shift 257512',895733.85,0.00,0.00,0.00,0.00,'2022-03-16 22:27:42','',''),(2613906,'5','92','598',231,'Sale Id shift 257513',0.00,0.00,0.00,3887.20,0.00,'2022-03-17 22:06:41','',''),(2613907,'5','92','598',231,'Sale Id shift 257513',0.00,0.00,0.00,4895.14,0.00,'2022-03-17 22:06:41','',''),(2613908,'5','92',NULL,231,'Sale Id shift 257513',1449086.10,0.00,0.00,0.00,0.00,'2022-03-17 22:06:41','',''),(2613909,'5','92','598',231,'Sale Id shift 257514',0.00,0.00,0.00,5246.04,0.00,'2022-03-19 22:50:51','',''),(2613910,'5','92','598',231,'Sale Id shift 257514',0.00,0.00,0.00,6119.01,0.00,'2022-03-19 22:50:51','',''),(2613911,'5','92',NULL,231,'Sale Id shift 257514',1875233.25,0.00,0.00,0.00,0.00,'2022-03-19 22:50:51','',''),(2613912,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,1314.26,0.00,'2022-03-20 21:22:50','',''),(2613913,'5','92','598',0,'Inventory adjustment from tank dipping to 1500',0.00,0.00,1500.00,0.00,0.00,'2022-03-20 21:22:50','',''),(2613914,'5','92','598',231,'Sale Id shift 257515',0.00,0.00,0.00,548.51,0.00,'2022-03-20 21:33:12','',''),(2613915,'5','92','598',231,'Sale Id shift 257515',0.00,0.00,0.00,858.13,0.00,'2022-03-20 21:33:12','',''),(2613916,'5','92',NULL,231,'Sale Id shift 257515',232095.60,0.00,0.00,0.00,0.00,'2022-03-20 21:33:12','',''),(2613917,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,6600000.00,40000.00,0.00,0.00,'2022-04-10 11:53:21','',''),(2613918,'5','92',NULL,231,'Reception corrector for bridging 129711',0.00,0.00,0.00,30000.00,0.00,'2022-04-10 14:09:57','',''),(2613919,'5','92','598',231,'Received from bridging 129711',0.00,0.00,30000.00,0.00,0.00,'2022-04-10 14:09:57','',''),(2613920,'5','92','598',231,'Sale Id shift 257536',0.00,0.00,0.00,1818.45,0.00,'2022-04-11 09:06:30','',''),(2613921,'5','92','598',231,'Sale Id shift 257536',0.00,0.00,0.00,2976.71,0.00,'2022-04-11 09:06:30','',''),(2613922,'5','92',NULL,231,'Sale Id shift 257536',791201.40,0.00,0.00,0.00,0.00,'2022-04-11 09:06:30','',''),(2613923,'5','92','598',231,'Sale Id shift 257537',0.00,0.00,0.00,3520.64,0.00,'2022-04-11 09:19:13','',''),(2613924,'5','92','598',231,'Sale Id shift 257537',0.00,0.00,0.00,6210.64,0.00,'2022-04-11 09:19:13','',''),(2613925,'5','92',NULL,231,'Sale Id shift 257537',1605661.20,0.00,0.00,0.00,0.00,'2022-04-11 09:19:13','',''),(2613926,'5','92','598',231,'Sale Id shift 257538',0.00,0.00,0.00,3603.98,0.00,'2022-04-12 11:25:48','',''),(2613927,'5','92','598',231,'Sale Id shift 257538',0.00,0.00,0.00,4254.90,0.00,'2022-04-12 11:25:48','',''),(2613928,'5','92',NULL,231,'Sale Id shift 257538',1296715.20,0.00,0.00,0.00,0.00,'2022-04-12 11:25:48','',''),(2613929,'5','92','598',231,'Sale Id shift 257539',0.00,0.00,0.00,3204.68,0.00,'2022-04-13 09:49:39','',''),(2613930,'5','92','598',231,'Sale Id shift 257539',0.00,0.00,0.00,3671.60,0.00,'2022-04-13 09:49:39','',''),(2613931,'5','92',NULL,231,'Sale Id shift 257539',1134586.20,0.00,0.00,0.00,0.00,'2022-04-13 09:49:39','',''),(2613932,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,831.76,0.00,'2022-04-14 21:33:36','',''),(2613933,'5','92','598',0,'Inventory adjustment from tank dipping to 1000',0.00,0.00,1000.00,0.00,0.00,'2022-04-14 21:33:37','',''),(2613934,'5','92','598',231,'Sale Id shift 257540',0.00,0.00,0.00,903.12,0.00,'2022-04-15 11:05:07','',''),(2613935,'5','92',NULL,231,'Sale Id shift 257540',149014.80,0.00,0.00,0.00,0.00,'2022-04-15 11:05:07','',''),(2613936,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4950000.00,30000.00,0.00,0.00,'2022-04-27 09:26:09','',''),(2613937,'5','92',NULL,231,'Reception corrector for bridging 129712',0.00,0.00,0.00,30000.00,0.00,'2022-04-27 12:09:54','',''),(2613938,'5','92','598',231,'Received from bridging 129712',0.00,0.00,30000.00,0.00,0.00,'2022-04-27 12:09:54','',''),(2613939,'5','92','598',231,'Sale Id shift 257553',0.00,0.00,0.00,445.02,0.00,'2022-04-29 10:22:58','',''),(2613940,'5','92','598',231,'Sale Id shift 257553',0.00,0.00,0.00,1138.45,0.00,'2022-04-29 10:22:58','',''),(2613941,'5','92',NULL,231,'Sale Id shift 257553',261272.55,0.00,0.00,0.00,0.00,'2022-04-29 10:22:58','',''),(2613942,'5','92','598',231,'Sale Id shift 257554',0.00,0.00,0.00,2023.59,0.00,'2022-05-10 10:00:56','',''),(2613943,'5','92','598',231,'Sale Id shift 257554',0.00,0.00,0.00,3187.28,0.00,'2022-05-10 10:00:56','',''),(2613944,'5','92',NULL,231,'Sale Id shift 257554',859793.55,0.00,0.00,0.00,0.00,'2022-05-10 10:00:56','',''),(2613945,'5','92','598',231,'Sale Id shift 257555',0.00,0.00,0.00,3092.57,0.00,'2022-05-10 16:42:10','',''),(2613946,'5','92','598',231,'Sale Id shift 257555',0.00,0.00,0.00,4761.85,0.00,'2022-05-10 16:42:10','',''),(2613947,'5','92',NULL,231,'Sale Id shift 257555',1295979.30,0.00,0.00,0.00,0.00,'2022-05-10 16:42:10','',''),(2613948,'5','92','598',231,'Sale Id shift 257556',0.00,0.00,0.00,3106.39,0.00,'2022-05-10 16:44:45','',''),(2613949,'5','92','598',231,'Sale Id shift 257556',0.00,0.00,0.00,6427.54,0.00,'2022-05-10 16:44:45','',''),(2613950,'5','92',NULL,231,'Sale Id shift 257556',1573098.45,0.00,0.00,0.00,0.00,'2022-05-10 16:44:45','',''),(2613951,'5','92','598',231,'Sale Id shift 257557',0.00,0.00,0.00,1143.19,0.00,'2022-05-10 16:47:57','',''),(2613952,'5','92',NULL,231,'Sale Id shift 257557',188626.35,0.00,0.00,0.00,0.00,'2022-05-10 16:47:57','',''),(2613953,'5','92','598',231,'Sale Id shift 257558',0.00,0.00,0.00,1556.73,0.00,'2022-05-10 16:54:00','',''),(2613954,'5','92','598',231,'Sale Id shift 257558',0.00,0.00,0.00,2970.35,0.00,'2022-05-10 16:54:00','',''),(2613955,'5','92',NULL,231,'Sale Id shift 257558',746968.20,0.00,0.00,0.00,0.00,'2022-05-10 16:54:00','',''),(2613956,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,2557500.00,15500.00,0.00,0.00,'2022-05-10 17:06:27','',''),(2613957,'5','92',NULL,231,'Reception corrector for bridging 129713',0.00,0.00,0.00,15500.00,0.00,'2022-05-10 17:19:18','',''),(2613958,'5','92','598',231,'Received from bridging 129713',0.00,0.00,15500.00,0.00,0.00,'2022-05-10 17:19:18','',''),(2613959,'5','92','598',231,'Sale Id shift 257562',0.00,0.00,0.00,1975.89,0.00,'2022-05-10 17:22:12','',''),(2613960,'5','92','598',231,'Sale Id shift 257562',0.00,0.00,0.00,2368.25,0.00,'2022-05-10 17:22:12','',''),(2613961,'5','92',NULL,231,'Sale Id shift 257562',716783.10,0.00,0.00,0.00,0.00,'2022-05-10 17:22:12','',''),(2613962,'5','92','598',231,'Sale Id shift 257563',0.00,0.00,0.00,2432.58,0.00,'2022-05-10 17:34:29','',''),(2613963,'5','92','598',231,'Sale Id shift 257563',0.00,0.00,0.00,3136.02,0.00,'2022-05-10 17:34:29','',''),(2613964,'5','92',NULL,231,'Sale Id shift 257563',918819.00,0.00,0.00,0.00,0.00,'2022-05-10 17:34:29','',''),(2613965,'5','92','598',231,'Sale Id shift 257564',0.00,0.00,0.00,1822.75,0.00,'2022-05-10 17:38:12','',''),(2613966,'5','92','598',231,'Sale Id shift 257564',0.00,0.00,0.00,1722.84,0.00,'2022-05-10 17:38:12','',''),(2613967,'5','92',NULL,231,'Sale Id shift 257564',585022.35,0.00,0.00,0.00,0.00,'2022-05-10 17:38:12','',''),(2613968,'5','92','598',231,'Sale Id shift 257565',0.00,0.00,0.00,944.89,0.00,'2022-05-10 17:40:45','',''),(2613969,'5','92','598',231,'Sale Id shift 257565',0.00,0.00,0.00,1153.68,0.00,'2022-05-10 17:40:45','',''),(2613970,'5','92',NULL,231,'Sale Id shift 257565',346264.05,0.00,0.00,0.00,0.00,'2022-05-10 17:40:45','',''),(2613971,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4950000.00,30000.00,0.00,0.00,'2022-05-16 10:58:38','',''),(2613972,'5','92',NULL,231,'Reception corrector for bridging 129714',0.00,0.00,0.00,30000.00,0.00,'2022-05-16 11:54:10','',''),(2613973,'5','92','598',231,'Received from bridging 129714',0.00,0.00,30000.00,0.00,0.00,'2022-05-16 11:54:10','',''),(2613974,'5','92','598',231,'Sale Id shift 257572',0.00,0.00,0.00,905.78,0.00,'2022-05-16 18:22:55','',''),(2613975,'5','92','598',231,'Sale Id shift 257572',0.00,0.00,0.00,645.95,0.00,'2022-05-16 18:22:55','',''),(2613976,'5','92',NULL,231,'Sale Id shift 257572',256035.45,0.00,0.00,0.00,0.00,'2022-05-16 18:22:55','',''),(2613977,'5','92','598',231,'Sale Id shift 257573',0.00,0.00,0.00,2981.91,0.00,'2022-05-17 09:29:27','',''),(2613978,'5','92','598',231,'Sale Id shift 257573',0.00,0.00,0.00,3296.83,0.00,'2022-05-17 09:29:27','',''),(2613979,'5','92',NULL,231,'Sale Id shift 257573',1035992.10,0.00,0.00,0.00,0.00,'2022-05-17 09:29:27','',''),(2613980,'5','92','598',231,'Sale Id shift 257574',0.00,0.00,0.00,4163.42,0.00,'2022-05-18 11:39:48','',''),(2613981,'5','92','598',231,'Sale Id shift 257574',0.00,0.00,0.00,4483.33,0.00,'2022-05-18 11:39:48','',''),(2613982,'5','92',NULL,231,'Sale Id shift 257574',1426713.75,0.00,0.00,0.00,0.00,'2022-05-18 11:39:48','',''),(2613983,'5','92','598',231,'Sale Id shift 257575',0.00,0.00,0.00,5074.12,0.00,'2022-05-19 09:59:06','',''),(2613984,'5','92','598',231,'Sale Id shift 257575',0.00,0.00,0.00,4887.33,0.00,'2022-05-19 09:59:06','',''),(2613985,'5','92',NULL,231,'Sale Id shift 257575',1643639.25,0.00,0.00,0.00,0.00,'2022-05-19 09:59:06','',''),(2613986,'5','92','598',231,'Sale Id shift 257576',0.00,0.00,0.00,1008.79,0.00,'2022-05-20 10:08:37','',''),(2613987,'5','92','598',231,'Sale Id shift 257576',0.00,0.00,0.00,2581.97,0.00,'2022-05-20 10:08:37','',''),(2613988,'5','92',NULL,231,'Sale Id shift 257576',592475.40,0.00,0.00,0.00,0.00,'2022-05-20 10:08:37','',''),(2613989,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4950000.00,30000.00,0.00,0.00,'2022-05-23 13:18:36','',''),(2613990,'5','92',NULL,231,'Reception corrector for bridging 129715',0.00,0.00,0.00,30000.00,0.00,'2022-05-23 13:29:50','',''),(2613991,'5','92','598',231,'Received from bridging 129715',0.00,0.00,30000.00,0.00,0.00,'2022-05-23 13:29:50','',''),(2613992,'5','92','598',231,'Sale Id shift 257580',0.00,0.00,0.00,2278.42,0.00,'2022-05-23 21:51:28','',''),(2613993,'5','92','598',231,'Sale Id shift 257580',0.00,0.00,0.00,3483.05,0.00,'2022-05-23 21:51:28','',''),(2613994,'5','92',NULL,231,'Sale Id shift 257580',950642.55,0.00,0.00,0.00,0.00,'2022-05-23 21:51:28','',''),(2613995,'5','92','598',231,'Sale Id shift 257581',0.00,0.00,0.00,4673.40,0.00,'2022-05-25 09:28:07','',''),(2613996,'5','92','598',231,'Sale Id shift 257581',0.00,0.00,0.00,5672.68,0.00,'2022-05-25 09:28:07','',''),(2613997,'5','92',NULL,231,'Sale Id shift 257581',1707103.20,0.00,0.00,0.00,0.00,'2022-05-25 09:28:07','',''),(2613998,'5','92','598',231,'Sale Id shift 257582',0.00,0.00,0.00,2762.44,0.00,'2022-05-26 10:34:21','',''),(2613999,'5','92','598',231,'Sale Id shift 257582',0.00,0.00,0.00,3668.18,0.00,'2022-05-26 10:34:22','',''),(2614000,'5','92',NULL,231,'Sale Id shift 257582',1061052.30,0.00,0.00,0.00,0.00,'2022-05-26 10:34:22','',''),(2614001,'5','92','598',231,'Sale Id shift 257583',0.00,0.00,0.00,2603.69,0.00,'2022-05-26 23:16:06','',''),(2614002,'5','92','598',231,'Sale Id shift 257583',0.00,0.00,0.00,1787.37,0.00,'2022-05-26 23:16:06','',''),(2614003,'5','92',NULL,231,'Sale Id shift 257583',724524.90,0.00,0.00,0.00,0.00,'2022-05-26 23:16:06','',''),(2614004,'5','92','598',231,'Sale Id shift 257584',0.00,0.00,0.00,1984.50,0.00,'2022-05-28 22:36:33','',''),(2614005,'5','92',NULL,231,'Sale Id shift 257584',327442.50,0.00,0.00,0.00,0.00,'2022-05-28 22:36:33','',''),(2614006,'5','92','598',231,'Sale Id shift 257585',0.00,0.00,0.00,1152.81,0.00,'2022-05-30 11:09:10','',''),(2614007,'5','92',NULL,231,'Sale Id shift 257585',190213.65,0.00,0.00,0.00,0.00,'2022-05-30 11:09:10','',''),(2614008,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,2433750.00,14750.00,0.00,0.00,'2022-06-19 14:55:51','',''),(2614009,'5','92',NULL,231,'Reception corrector for bridging 129716',0.00,0.00,0.00,14750.00,0.00,'2022-06-20 10:15:18','',''),(2614010,'5','92','598',231,'Received from bridging 129716',0.00,0.00,14750.00,0.00,0.00,'2022-06-20 10:15:18','',''),(2614011,'5','92','598',231,'Sale Id shift 257607',0.00,0.00,0.00,1912.97,0.00,'2022-06-21 08:50:56','',''),(2614012,'5','92','598',231,'Sale Id shift 257607',0.00,0.00,0.00,2650.01,0.00,'2022-06-21 08:50:56','',''),(2614013,'5','92',NULL,231,'Sale Id shift 257607',752891.70,0.00,0.00,0.00,0.00,'2022-06-21 08:50:56','',''),(2614014,'5','92','598',231,'Sale Id shift 257608',0.00,0.00,0.00,2218.26,0.00,'2022-06-21 15:07:50','',''),(2614015,'5','92','598',231,'Sale Id shift 257608',0.00,0.00,0.00,2262.86,0.00,'2022-06-21 15:07:50','',''),(2614016,'5','92',NULL,231,'Sale Id shift 257608',739384.80,0.00,0.00,0.00,0.00,'2022-06-21 15:07:50','',''),(2614017,'5','92','598',231,'Sale Id shift 257609',0.00,0.00,0.00,1600.00,0.00,'2022-06-22 12:30:05','',''),(2614018,'5','92',NULL,231,'Sale Id shift 257609',264000.00,0.00,0.00,0.00,0.00,'2022-06-22 12:30:05','',''),(2614019,'5','92','598',231,'Sale Id shift 257610',0.00,0.00,0.00,1697.30,0.00,'2022-06-23 09:45:46','',''),(2614020,'5','92','598',231,'Sale Id shift 257610',0.00,0.00,0.00,775.88,0.00,'2022-06-23 09:45:46','',''),(2614021,'5','92',NULL,231,'Sale Id shift 257610',408074.70,0.00,0.00,0.00,0.00,'2022-06-23 09:45:46','',''),(2614022,'5','92','598',231,'Sale Id shift 257611',0.00,0.00,0.00,1045.65,0.00,'2022-06-24 10:10:30','',''),(2614023,'5','92','598',231,'Sale Id shift 257611',0.00,0.00,0.00,585.36,0.00,'2022-06-24 10:10:30','',''),(2614024,'5','92',NULL,231,'Sale Id shift 257611',269116.65,0.00,0.00,0.00,0.00,'2022-06-24 10:10:30','',''),(2614025,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4950000.00,30000.00,0.00,0.00,'2022-07-08 11:23:54','',''),(2614026,'5','92',NULL,231,'Reception corrector for bridging 129717',0.00,0.00,0.00,30000.00,0.00,'2022-07-08 12:41:30','',''),(2614027,'5','92','598',231,'Received from bridging 129717',0.00,0.00,30000.00,0.00,0.00,'2022-07-08 12:41:30','',''),(2614028,'5','92','598',231,'Sale Id shift 257625',0.00,0.00,0.00,1159.48,0.00,'2022-07-09 18:59:57','',''),(2614029,'5','92','598',231,'Sale Id shift 257625',0.00,0.00,0.00,908.29,0.00,'2022-07-09 18:59:57','',''),(2614030,'5','92',NULL,231,'Sale Id shift 257625',341182.05,0.00,0.00,0.00,0.00,'2022-07-09 18:59:57','',''),(2614031,'5','92','598',231,'Sale Id shift 257626',0.00,0.00,0.00,2159.99,0.00,'2022-07-10 21:32:07','',''),(2614032,'5','92','598',231,'Sale Id shift 257626',0.00,0.00,0.00,2143.94,0.00,'2022-07-10 21:32:07','',''),(2614033,'5','92',NULL,231,'Sale Id shift 257626',710148.45,0.00,0.00,0.00,0.00,'2022-07-10 21:32:07','',''),(2614034,'5','92','598',231,'Sale Id shift 257627',0.00,0.00,0.00,1059.75,0.00,'2022-07-10 21:38:49','',''),(2614035,'5','92','598',231,'Sale Id shift 257627',0.00,0.00,0.00,3380.01,0.00,'2022-07-10 21:38:49','',''),(2614036,'5','92',NULL,231,'Sale Id shift 257627',732560.40,0.00,0.00,0.00,0.00,'2022-07-10 21:38:49','',''),(2614037,'5','92','598',231,'Sale Id shift 257628',0.00,0.00,0.00,2496.64,0.00,'2022-07-11 11:03:23','',''),(2614038,'5','92','598',231,'Sale Id shift 257628',0.00,0.00,0.00,3032.54,0.00,'2022-07-11 11:03:23','',''),(2614039,'5','92',NULL,231,'Sale Id shift 257628',912314.70,0.00,0.00,0.00,0.00,'2022-07-11 11:03:23','',''),(2614040,'5','92','598',231,'Sale Id shift 257629',0.00,0.00,0.00,2270.25,0.00,'2022-07-12 16:16:27','',''),(2614041,'5','92','598',231,'Sale Id shift 257629',0.00,0.00,0.00,2210.87,0.00,'2022-07-12 16:16:27','',''),(2614042,'5','92',NULL,231,'Sale Id shift 257629',739384.80,0.00,0.00,0.00,0.00,'2022-07-12 16:16:27','',''),(2614043,'5','92','598',231,'Sale Id shift 257630',0.00,0.00,0.00,1855.64,0.00,'2022-07-12 18:29:54','',''),(2614044,'5','92','598',231,'Sale Id shift 257630',0.00,0.00,0.00,1562.49,0.00,'2022-07-12 18:29:54','',''),(2614045,'5','92',NULL,231,'Sale Id shift 257630',563991.45,0.00,0.00,0.00,0.00,'2022-07-12 18:29:54','',''),(2614046,'5','92','598',231,'Sale Id shift 257631',0.00,0.00,0.00,1190.34,0.00,'2022-07-14 08:40:31','',''),(2614047,'5','92','598',231,'Sale Id shift 257631',0.00,0.00,0.00,2197.63,0.00,'2022-07-14 08:40:31','',''),(2614048,'5','92',NULL,231,'Sale Id shift 257631',559015.05,0.00,0.00,0.00,0.00,'2022-07-14 08:40:31','',''),(2614049,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,5550000.00,30000.00,0.00,0.00,'2022-07-16 10:45:15','',''),(2614050,'5','92',NULL,231,'Reception corrector for bridging 129718',0.00,0.00,0.00,30000.00,0.00,'2022-07-17 14:03:45','',''),(2614051,'5','92','598',231,'Received from bridging 129718',0.00,0.00,30000.00,0.00,0.00,'2022-07-17 14:03:45','',''),(2614052,'5','92','598',231,'Sale Id shift 257632',0.00,0.00,0.00,318.96,0.00,'2022-07-17 14:25:18','',''),(2614053,'5','92','598',231,'Sale Id shift 257632',0.00,0.00,0.00,2154.79,0.00,'2022-07-17 14:25:18','',''),(2614054,'5','92',NULL,231,'Sale Id shift 257632',408168.75,0.00,0.00,0.00,0.00,'2022-07-17 14:25:18','',''),(2614055,'5','92','598',231,'Sale Id shift 257633',0.00,0.00,0.00,1615.66,0.00,'2022-07-17 14:28:48','',''),(2614056,'5','92','598',231,'Sale Id shift 257633',0.00,0.00,0.00,3671.15,0.00,'2022-07-17 14:28:48','',''),(2614057,'5','92',NULL,231,'Sale Id shift 257633',978059.85,0.00,0.00,0.00,0.00,'2022-07-17 14:28:48','',''),(2614058,'5','92','598',231,'Sale Id shift 257634',0.00,0.00,0.00,2325.78,0.00,'2022-07-17 14:32:27','',''),(2614059,'5','92','598',231,'Sale Id shift 257634',0.00,0.00,0.00,5539.17,0.00,'2022-07-17 14:32:27','',''),(2614060,'5','92',NULL,231,'Sale Id shift 257634',1455015.75,0.00,0.00,0.00,0.00,'2022-07-17 14:32:27','',''),(2614061,'5','92','598',231,'Sale Id shift 257635',0.00,0.00,0.00,2412.89,0.00,'2022-07-18 11:30:07','',''),(2614062,'5','92','598',231,'Sale Id shift 257635',0.00,0.00,0.00,2193.69,0.00,'2022-07-18 11:30:07','',''),(2614063,'5','92',NULL,231,'Sale Id shift 257635',852217.30,0.00,0.00,0.00,0.00,'2022-07-18 11:30:07','',''),(2614064,'5','92','598',231,'Sale Id shift 257636',0.00,0.00,0.00,1452.04,0.00,'2022-07-19 06:53:01','',''),(2614065,'5','92','598',231,'Sale Id shift 257636',0.00,0.00,0.00,3117.26,0.00,'2022-07-19 06:53:01','',''),(2614066,'5','92',NULL,231,'Sale Id shift 257636',845320.50,0.00,0.00,0.00,0.00,'2022-07-19 06:53:01','',''),(2614067,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,6105000.00,33000.00,0.00,0.00,'2022-07-19 22:36:12','',''),(2614068,'5','92',NULL,231,'Reception corrector for bridging 129719',0.00,0.00,0.00,33000.00,0.00,'2022-07-20 08:37:08','',''),(2614069,'5','92','598',231,'Received from bridging 129719',0.00,0.00,33000.00,0.00,0.00,'2022-07-20 08:37:08','',''),(2614070,'5','92','598',231,'Sale Id shift 257637',0.00,0.00,0.00,4457.22,0.00,'2022-07-20 09:41:36','',''),(2614071,'5','92','598',231,'Sale Id shift 257637',0.00,0.00,0.00,6911.34,0.00,'2022-07-20 09:41:36','',''),(2614072,'5','92',NULL,231,'Sale Id shift 257637',2103183.60,0.00,0.00,0.00,0.00,'2022-07-20 09:41:36','',''),(2614073,'5','92','598',231,'Sale Id shift 257638',0.00,0.00,0.00,2717.10,0.00,'2022-07-20 19:12:06','',''),(2614074,'5','92','598',231,'Sale Id shift 257638',0.00,0.00,0.00,5690.62,0.00,'2022-07-20 19:12:06','',''),(2614075,'5','92',NULL,231,'Sale Id shift 257638',1555428.20,0.00,0.00,0.00,0.00,'2022-07-20 19:12:06','',''),(2614076,'5','92','598',231,'Sale Id shift 257639',0.00,0.00,0.00,3590.37,0.00,'2022-07-22 16:10:50','',''),(2614077,'5','92','598',231,'Sale Id shift 257639',0.00,0.00,0.00,5559.89,0.00,'2022-07-22 16:10:50','',''),(2614078,'5','92',NULL,231,'Sale Id shift 257639',1692798.10,0.00,0.00,0.00,0.00,'2022-07-22 16:10:50','',''),(2614079,'5','92','598',231,'Sale Id shift 257640',0.00,0.00,0.00,2582.89,0.00,'2022-07-23 12:47:10','',''),(2614080,'5','92','598',231,'Sale Id shift 257640',0.00,0.00,0.00,3859.51,0.00,'2022-07-23 12:47:10','',''),(2614081,'5','92',NULL,231,'Sale Id shift 257640',1191844.00,0.00,0.00,0.00,0.00,'2022-07-23 12:47:10','',''),(2614082,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,5624000.00,30400.00,0.00,0.00,'2022-07-23 21:47:50','',''),(2614083,'5','92',NULL,231,'Reception corrector for bridging 129721',0.00,0.00,0.00,30400.00,0.00,'2022-07-24 22:17:37','',''),(2614084,'5','92','598',231,'Received from bridging 129721',0.00,0.00,30400.00,0.00,0.00,'2022-07-24 22:17:37','',''),(2614085,'5','92','598',231,'Sale Id shift 257641',0.00,0.00,0.00,2413.33,0.00,'2022-07-25 09:21:10','',''),(2614086,'5','92','598',231,'Sale Id shift 257641',0.00,0.00,0.00,3181.03,0.00,'2022-07-25 09:21:10','',''),(2614087,'5','92',NULL,231,'Sale Id shift 257641',1034956.60,0.00,0.00,0.00,0.00,'2022-07-25 09:21:10','',''),(2614088,'5','92','598',231,'Sale Id shift 257642',0.00,0.00,0.00,1930.23,0.00,'2022-07-25 09:29:21','',''),(2614089,'5','92','598',231,'Sale Id shift 257642',0.00,0.00,0.00,2662.83,0.00,'2022-07-25 09:29:21','',''),(2614090,'5','92',NULL,231,'Sale Id shift 257642',849716.10,0.00,0.00,0.00,0.00,'2022-07-25 09:29:21','',''),(2614091,'5','92','598',231,'Sale Id shift 257643',0.00,0.00,0.00,2939.93,0.00,'2022-07-26 10:48:51','',''),(2614092,'5','92','598',231,'Sale Id shift 257643',0.00,0.00,0.00,5168.29,0.00,'2022-07-26 10:48:51','',''),(2614093,'5','92',NULL,231,'Sale Id shift 257643',1500020.70,0.00,0.00,0.00,0.00,'2022-07-26 10:48:51','',''),(2614094,'5','92','598',231,'Sale Id shift 257644',0.00,0.00,0.00,2775.91,0.00,'2022-07-26 21:03:18','',''),(2614095,'5','92','598',231,'Sale Id shift 257644',0.00,0.00,0.00,2613.90,0.00,'2022-07-26 21:03:18','',''),(2614096,'5','92',NULL,231,'Sale Id shift 257644',997114.85,0.00,0.00,0.00,0.00,'2022-07-26 21:03:18','',''),(2614097,'5','92','598',231,'Sale Id shift 257645',0.00,0.00,0.00,5076.54,0.00,'2022-07-28 10:41:17','',''),(2614098,'5','92','598',231,'Sale Id shift 257645',0.00,0.00,0.00,6870.13,0.00,'2022-07-28 10:41:17','',''),(2614099,'5','92',NULL,231,'Sale Id shift 257645',2210133.95,0.00,0.00,0.00,0.00,'2022-07-28 10:41:17','',''),(2614100,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,62.45,0.00,'2022-07-30 20:12:21','',''),(2614101,'5','92','598',0,'Inventory adjustment from tank dipping to 700',0.00,0.00,700.00,0.00,0.00,'2022-07-30 20:12:21','',''),(2614102,'5','92','598',231,'Sale Id shift 257646',0.00,0.00,0.00,99.79,0.00,'2022-07-31 13:14:57','',''),(2614103,'5','92','598',231,'Sale Id shift 257646',0.00,0.00,0.00,181.84,0.00,'2022-07-31 13:14:57','',''),(2614104,'5','92',NULL,231,'Sale Id shift 257646',52101.55,0.00,0.00,0.00,0.00,'2022-07-31 13:14:57','',''),(2614105,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,5550000.00,30000.00,0.00,0.00,'2022-08-02 14:46:11','',''),(2614106,'5','92',NULL,231,'Reception corrector for bridging 129722',0.00,0.00,0.00,30000.00,0.00,'2022-08-02 15:23:45','',''),(2614107,'5','92','598',231,'Received from bridging 129722',0.00,0.00,30000.00,0.00,0.00,'2022-08-02 15:23:45','',''),(2614108,'5','92','598',231,'Sale Id shift 257651',0.00,0.00,0.00,2286.21,0.00,'2022-08-02 21:26:44','',''),(2614109,'5','92','598',231,'Sale Id shift 257651',0.00,0.00,0.00,2696.90,0.00,'2022-08-02 21:26:44','',''),(2614110,'5','92',NULL,231,'Sale Id shift 257651',921875.35,0.00,0.00,0.00,0.00,'2022-08-02 21:26:44','',''),(2614111,'5','92','598',231,'Sale Id shift 257652',0.00,0.00,0.00,1952.41,0.00,'2022-08-04 10:50:15','',''),(2614112,'5','92','598',231,'Sale Id shift 257652',0.00,0.00,0.00,3607.26,0.00,'2022-08-04 10:50:15','',''),(2614113,'5','92',NULL,231,'Sale Id shift 257652',1028538.95,0.00,0.00,0.00,0.00,'2022-08-04 10:50:15','',''),(2614114,'5','92','598',231,'Sale Id shift 257653',0.00,0.00,0.00,2865.35,0.00,'2022-08-05 10:35:04','',''),(2614115,'5','92','598',231,'Sale Id shift 257653',0.00,0.00,0.00,3293.83,0.00,'2022-08-05 10:35:04','',''),(2614116,'5','92',NULL,231,'Sale Id shift 257653',1139448.30,0.00,0.00,0.00,0.00,'2022-08-05 10:35:04','',''),(2614117,'5','92','598',231,'Sale Id shift 257654',0.00,0.00,0.00,4911.70,0.00,'2022-08-06 14:45:25','',''),(2614118,'5','92','598',231,'Sale Id shift 257654',0.00,0.00,0.00,5540.01,0.00,'2022-08-06 14:45:25','',''),(2614119,'5','92',NULL,231,'Sale Id shift 257654',1933566.35,0.00,0.00,0.00,0.00,'2022-08-06 14:45:25','',''),(2614120,'5','92','598',231,'Sale Id shift 257655',0.00,0.00,0.00,1510.64,0.00,'2022-08-07 21:33:57','',''),(2614121,'5','92','598',231,'Sale Id shift 257655',0.00,0.00,0.00,1645.49,0.00,'2022-08-07 21:33:57','',''),(2614122,'5','92',NULL,231,'Sale Id shift 257655',583884.05,0.00,0.00,0.00,0.00,'2022-08-07 21:33:57','',''),(2614123,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,5550000.00,30000.00,0.00,0.00,'2022-09-05 14:35:27','',''),(2614124,'5','92',NULL,231,'Reception corrector for bridging 129723',0.00,0.00,0.00,30000.00,0.00,'2022-09-05 14:43:30','',''),(2614125,'5','92','598',231,'Received from bridging 129723',0.00,0.00,30000.00,0.00,0.00,'2022-09-05 14:43:30','',''),(2614126,'5','92','598',231,'Sale Id shift 257659',0.00,0.00,0.00,769.02,0.00,'2022-09-05 14:59:42','',''),(2614127,'5','92','598',231,'Sale Id shift 257659',0.00,0.00,0.00,515.43,0.00,'2022-09-05 14:59:42','',''),(2614128,'5','92',NULL,231,'Sale Id shift 257659',237623.25,0.00,0.00,0.00,0.00,'2022-09-05 14:59:42','',''),(2614129,'5','92','598',231,'Sale Id shift 257660',0.00,0.00,0.00,1339.70,0.00,'2022-09-05 15:02:46','',''),(2614130,'5','92','598',231,'Sale Id shift 257660',0.00,0.00,0.00,2549.83,0.00,'2022-09-05 15:02:46','',''),(2614131,'5','92',NULL,231,'Sale Id shift 257660',719563.05,0.00,0.00,0.00,0.00,'2022-09-05 15:02:46','',''),(2614132,'5','92','598',231,'Sale Id shift 257661',0.00,0.00,0.00,2439.76,0.00,'2022-09-05 15:06:18','',''),(2614133,'5','92','598',231,'Sale Id shift 257661',0.00,0.00,0.00,2578.30,0.00,'2022-09-05 15:06:18','',''),(2614134,'5','92',NULL,231,'Sale Id shift 257661',928341.10,0.00,0.00,0.00,0.00,'2022-09-05 15:06:18','',''),(2614135,'5','92','598',231,'Sale Id shift 257662',0.00,0.00,0.00,1861.56,0.00,'2022-09-05 15:08:47','',''),(2614136,'5','92','598',231,'Sale Id shift 257662',0.00,0.00,0.00,1981.47,0.00,'2022-09-05 15:08:47','',''),(2614137,'5','92',NULL,231,'Sale Id shift 257662',710960.55,0.00,0.00,0.00,0.00,'2022-09-05 15:08:47','',''),(2614138,'5','92','598',231,'Sale Id shift 257663',0.00,0.00,0.00,2094.54,0.00,'2022-09-05 15:13:45','',''),(2614139,'5','92','598',231,'Sale Id shift 257663',0.00,0.00,0.00,3276.44,0.00,'2022-09-05 15:13:45','',''),(2614140,'5','92',NULL,231,'Sale Id shift 257663',993631.30,0.00,0.00,0.00,0.00,'2022-09-05 15:13:45','',''),(2614141,'5','92','598',231,'Sale Id shift 257664',0.00,0.00,0.00,1889.18,0.00,'2022-09-05 15:18:41','',''),(2614142,'5','92','598',231,'Sale Id shift 257664',0.00,0.00,0.00,2574.68,0.00,'2022-09-05 15:18:41','',''),(2614143,'5','92',NULL,231,'Sale Id shift 257664',825814.10,0.00,0.00,0.00,0.00,'2022-09-05 15:18:41','',''),(2614144,'5','92','598',231,'Sale Id shift 257665',0.00,0.00,0.00,1687.29,0.00,'2022-09-05 15:20:37','',''),(2614145,'5','92','598',231,'Sale Id shift 257665',0.00,0.00,0.00,2343.24,0.00,'2022-09-05 15:20:37','',''),(2614146,'5','92',NULL,231,'Sale Id shift 257665',745648.05,0.00,0.00,0.00,0.00,'2022-09-05 15:20:37','',''),(2614147,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,4144000.00,22400.00,0.00,0.00,'2022-09-05 15:24:00','',''),(2614148,'5','92',NULL,231,'Reception corrector for bridging 129724',0.00,0.00,0.00,22400.00,0.00,'2022-09-05 15:29:17','',''),(2614149,'5','92','598',231,'Received from bridging 129724',0.00,0.00,22400.00,0.00,0.00,'2022-09-05 15:29:17','',''),(2614150,'5','92','598',231,'Sale Id shift 257666',0.00,0.00,0.00,699.18,0.00,'2022-09-05 15:32:08','',''),(2614151,'5','92','598',231,'Sale Id shift 257666',0.00,0.00,0.00,1686.46,0.00,'2022-09-05 15:32:08','',''),(2614152,'5','92',NULL,231,'Sale Id shift 257666',441343.40,0.00,0.00,0.00,0.00,'2022-09-05 15:32:08','',''),(2614153,'5','92','598',231,'Sale Id shift 257667',0.00,0.00,0.00,2135.17,0.00,'2022-09-05 15:34:46','',''),(2614154,'5','92','598',231,'Sale Id shift 257667',0.00,0.00,0.00,2555.52,0.00,'2022-09-05 15:34:46','',''),(2614155,'5','92',NULL,231,'Sale Id shift 257667',867777.65,0.00,0.00,0.00,0.00,'2022-09-05 15:34:46','',''),(2614156,'5','92','598',231,'Sale Id shift 257668',0.00,0.00,0.00,1886.98,0.00,'2022-09-05 15:37:14','',''),(2614157,'5','92','598',231,'Sale Id shift 257668',0.00,0.00,0.00,3011.01,0.00,'2022-09-05 15:37:14','',''),(2614158,'5','92',NULL,231,'Sale Id shift 257668',906128.15,0.00,0.00,0.00,0.00,'2022-09-05 15:37:14','',''),(2614159,'5','92','598',231,'Sale Id shift 257669',0.00,0.00,0.00,892.24,0.00,'2022-09-05 15:43:09','',''),(2614160,'5','92','598',231,'Sale Id shift 257669',0.00,0.00,0.00,1128.36,0.00,'2022-09-05 15:43:09','',''),(2614161,'5','92',NULL,231,'Sale Id shift 257669',373811.00,0.00,0.00,0.00,0.00,'2022-09-05 15:43:09','',''),(2614162,'5','92','598',231,'Sale Id shift 257670',0.00,0.00,0.00,2330.71,0.00,'2022-09-05 15:46:12','',''),(2614163,'5','92','598',231,'Sale Id shift 257670',0.00,0.00,0.00,3527.87,0.00,'2022-09-05 15:46:12','',''),(2614164,'5','92',NULL,231,'Sale Id shift 257670',1083837.30,0.00,0.00,0.00,0.00,'2022-09-05 15:46:12','',''),(2614165,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,8288000.00,44800.00,0.00,0.00,'2022-09-05 16:09:48','',''),(2614166,'5','92',NULL,231,'Reception corrector for bridging 129725',0.00,0.00,0.00,35000.00,0.00,'2022-09-06 09:42:02','',''),(2614167,'5','92','598',231,'Received from bridging 129725',0.00,0.00,35000.00,0.00,0.00,'2022-09-06 09:42:02','',''),(2614168,'5','92','598',231,'Sale Id shift 257671',0.00,0.00,0.00,1631.57,0.00,'2022-09-06 11:53:50','',''),(2614169,'5','92','598',231,'Sale Id shift 257671',0.00,0.00,0.00,3154.74,0.00,'2022-09-06 11:53:50','',''),(2614170,'5','92',NULL,231,'Sale Id shift 257671',885467.35,0.00,0.00,0.00,0.00,'2022-09-06 11:53:50','',''),(2614171,'5','92','598',231,'Sale Id shift 257672',0.00,0.00,0.00,1398.49,0.00,'2022-09-06 11:58:26','',''),(2614172,'5','92','598',231,'Sale Id shift 257672',0.00,0.00,0.00,2225.86,0.00,'2022-09-06 11:58:26','',''),(2614173,'5','92',NULL,231,'Sale Id shift 257672',670504.75,0.00,0.00,0.00,0.00,'2022-09-06 11:58:26','',''),(2614174,'5','92','598',231,'Sale Id shift 257673',0.00,0.00,0.00,1693.28,0.00,'2022-09-06 12:01:13','',''),(2614175,'5','92','598',231,'Sale Id shift 257673',0.00,0.00,0.00,2240.23,0.00,'2022-09-06 12:01:13','',''),(2614176,'5','92',NULL,231,'Sale Id shift 257673',727699.35,0.00,0.00,0.00,0.00,'2022-09-06 12:01:13','',''),(2614177,'5','92','598',231,'Sale Id shift 257674',0.00,0.00,0.00,1910.99,0.00,'2022-09-06 12:06:33','',''),(2614178,'5','92','598',231,'Sale Id shift 257674',0.00,0.00,0.00,3090.95,0.00,'2022-09-06 12:06:33','',''),(2614179,'5','92',NULL,231,'Sale Id shift 257674',925358.90,0.00,0.00,0.00,0.00,'2022-09-06 12:06:33','',''),(2614180,'5','92','598',231,'Sale Id shift 257675',0.00,0.00,0.00,1678.18,0.00,'2022-09-06 12:09:47','',''),(2614181,'5','92','598',231,'Sale Id shift 257675',0.00,0.00,0.00,1799.97,0.00,'2022-09-06 12:09:47','',''),(2614182,'5','92',NULL,231,'Sale Id shift 257675',643457.75,0.00,0.00,0.00,0.00,'2022-09-06 12:09:47','',''),(2614183,'5','92','598',231,'Sale Id shift 257676',0.00,0.00,0.00,2419.86,0.00,'2022-09-06 12:13:38','',''),(2614184,'5','92',NULL,231,'Sale Id shift 257676',447674.10,0.00,0.00,0.00,0.00,'2022-09-06 12:13:38','',''),(2614185,'5','92','598',231,'Sale Id shift 257677',0.00,0.00,0.00,2825.07,0.00,'2022-09-06 12:16:37','',''),(2614186,'5','92','598',231,'Sale Id shift 257677',0.00,0.00,0.00,1720.56,0.00,'2022-09-06 12:16:37','',''),(2614187,'5','92',NULL,231,'Sale Id shift 257677',840941.55,0.00,0.00,0.00,0.00,'2022-09-06 12:16:37','',''),(2614188,'5','92','598',231,'Sale Id shift 257678',0.00,0.00,0.00,2501.91,0.00,'2022-09-06 12:19:44','',''),(2614189,'5','92',NULL,231,'Sale Id shift 257678',462853.35,0.00,0.00,0.00,0.00,'2022-09-06 12:19:44','',''),(2614190,'5','92','598',231,'Sale Id shift 257679',0.00,0.00,0.00,2925.45,0.00,'2022-09-06 12:22:53','',''),(2614191,'5','92','598',231,'Sale Id shift 257679',0.00,0.00,0.00,2504.18,0.00,'2022-09-06 12:22:53','',''),(2614192,'5','92',NULL,231,'Sale Id shift 257679',1004481.55,0.00,0.00,0.00,0.00,'2022-09-06 12:22:53','',''),(2614193,'5','92','598',231,'Sale Id shift 257680',0.00,0.00,0.00,3050.40,0.00,'2022-09-06 12:32:28','',''),(2614194,'5','92','598',231,'Sale Id shift 257680',0.00,0.00,0.00,309.51,0.00,'2022-09-06 12:32:28','',''),(2614195,'5','92',NULL,231,'Sale Id shift 257680',621583.35,0.00,0.00,0.00,0.00,'2022-09-06 12:32:28','',''),(2614196,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,1813000.00,9800.00,0.00,0.00,'2022-09-06 12:32:57','',''),(2614197,'5','92',NULL,231,'Reception corrector for bridging 129726',0.00,0.00,0.00,9800.00,0.00,'2022-09-06 13:06:48','',''),(2614198,'5','92','598',231,'Received from bridging 129726',0.00,0.00,9800.00,0.00,0.00,'2022-09-06 13:06:48','',''),(2614199,'5','92','598',231,'Sale Id shift 257681',0.00,0.00,0.00,2590.69,0.00,'2022-09-06 13:15:48','',''),(2614200,'5','92','598',231,'Sale Id shift 257681',0.00,0.00,0.00,3122.01,0.00,'2022-09-06 13:15:48','',''),(2614201,'5','92',NULL,231,'Sale Id shift 257681',1056849.50,0.00,0.00,0.00,0.00,'2022-09-06 13:15:48','',''),(2614202,'5','92','598',231,'Sale Id shift 257682',0.00,0.00,0.00,1365.20,0.00,'2022-09-06 14:02:55','',''),(2614203,'5','92','598',231,'Sale Id shift 257682',0.00,0.00,0.00,2841.41,0.00,'2022-09-06 14:02:55','',''),(2614204,'5','92',NULL,231,'Sale Id shift 257682',778222.85,0.00,0.00,0.00,0.00,'2022-09-06 14:02:55','',''),(2614205,'5','92','598',231,'Sale Id shift 257683',0.00,0.00,0.00,160.39,0.00,'2022-09-06 14:13:01','',''),(2614206,'5','92',NULL,231,'Sale Id shift 257683',29672.15,0.00,0.00,0.00,0.00,'2022-09-06 14:13:01','',''),(2614207,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,3838750.00,20750.00,0.00,0.00,'2022-09-06 14:19:23','',''),(2614208,'5','92',NULL,231,'Reception corrector for bridging 129727',0.00,0.00,0.00,20750.00,0.00,'2022-09-06 14:51:18','',''),(2614209,'5','92','598',231,'Received from bridging 129727',0.00,0.00,20750.00,0.00,0.00,'2022-09-06 14:51:18','',''),(2614210,'5','92','598',231,'Sale Id shift 257685',0.00,0.00,0.00,938.22,0.00,'2022-09-06 15:03:03','',''),(2614211,'5','92','598',231,'Sale Id shift 257685',0.00,0.00,0.00,1906.93,0.00,'2022-09-06 15:03:03','',''),(2614212,'5','92',NULL,231,'Sale Id shift 257685',526352.75,0.00,0.00,0.00,0.00,'2022-09-06 15:03:03','',''),(2614213,'5','92','598',231,'Sale Id shift 257686',0.00,0.00,0.00,2532.85,0.00,'2022-09-07 10:03:40','',''),(2614214,'5','92','598',231,'Sale Id shift 257686',0.00,0.00,0.00,2911.09,0.00,'2022-09-07 10:03:40','',''),(2614215,'5','92',NULL,231,'Sale Id shift 257686',1007128.90,0.00,0.00,0.00,0.00,'2022-09-07 10:03:40','',''),(2614216,'5','92','598',231,'Sale Id shift 257687',0.00,0.00,0.00,1624.12,0.00,'2022-09-08 10:04:07','',''),(2614217,'5','92','598',231,'Sale Id shift 257687',0.00,0.00,0.00,1913.25,0.00,'2022-09-08 10:04:07','',''),(2614218,'5','92',NULL,231,'Sale Id shift 257687',654413.45,0.00,0.00,0.00,0.00,'2022-09-08 10:04:07','',''),(2614219,'5','92','598',231,'Sale Id shift 257688',0.00,0.00,0.00,2283.60,0.00,'2022-09-10 12:19:10','',''),(2614220,'5','92','598',231,'Sale Id shift 257688',0.00,0.00,0.00,3638.86,0.00,'2022-09-10 12:19:10','',''),(2614221,'5','92',NULL,231,'Sale Id shift 257688',1095655.10,0.00,0.00,0.00,0.00,'2022-09-10 12:19:10','',''),(2614222,'5','92','598',231,'Sale Id shift 257689',0.00,0.00,0.00,1082.44,0.00,'2022-09-11 16:59:01','',''),(2614223,'5','92','598',231,'Sale Id shift 257689',0.00,0.00,0.00,2034.42,0.00,'2022-09-11 16:59:01','',''),(2614224,'5','92',NULL,231,'Sale Id shift 257689',576619.10,0.00,0.00,0.00,0.00,'2022-09-11 16:59:01','',''),(2614225,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,2775000.00,15000.00,0.00,0.00,'2022-09-16 08:03:16','',''),(2614226,'5','92',NULL,231,'Reception corrector for bridging 129728',0.00,0.00,0.00,15000.00,0.00,'2022-09-16 09:26:58','',''),(2614227,'5','92','598',231,'Received from bridging 129728',0.00,0.00,15000.00,0.00,0.00,'2022-09-16 09:26:58','',''),(2614228,'5','92','598',231,'Sale Id shift 257695',0.00,0.00,0.00,882.99,0.00,'2022-09-16 09:39:59','',''),(2614229,'5','92','598',231,'Sale Id shift 257695',0.00,0.00,0.00,1303.69,0.00,'2022-09-16 09:39:59','',''),(2614230,'5','92',NULL,231,'Sale Id shift 257695',404535.80,0.00,0.00,0.00,0.00,'2022-09-16 09:39:59','',''),(2614231,'5','92','598',231,'Sale Id shift 257697',0.00,0.00,0.00,1480.74,0.00,'2022-09-18 11:25:53','',''),(2614232,'5','92','598',231,'Sale Id shift 257697',0.00,0.00,0.00,2761.65,0.00,'2022-09-18 11:25:53','',''),(2614233,'5','92',NULL,231,'Sale Id shift 257697',784842.15,0.00,0.00,0.00,0.00,'2022-09-18 11:25:53','',''),(2614234,'5','92','598',231,'Sale Id shift 257698',0.00,0.00,0.00,1547.78,0.00,'2022-09-19 09:31:48','',''),(2614235,'5','92','598',231,'Sale Id shift 257698',0.00,0.00,0.00,3406.21,0.00,'2022-09-19 09:31:48','',''),(2614236,'5','92',NULL,231,'Sale Id shift 257698',916488.15,0.00,0.00,0.00,0.00,'2022-09-19 09:31:48','',''),(2614237,'5','92','598',231,'Sale Id shift 257699',0.00,0.00,0.00,1193.16,0.00,'2022-09-20 12:14:00','',''),(2614238,'5','92','598',231,'Sale Id shift 257699',0.00,0.00,0.00,2522.71,0.00,'2022-09-20 12:14:00','',''),(2614239,'5','92',NULL,231,'Sale Id shift 257699',687435.95,0.00,0.00,0.00,0.00,'2022-09-20 12:14:00','',''),(2614240,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,5457500.00,29500.00,0.00,0.00,'2022-09-21 09:51:20','',''),(2614241,'5','92',NULL,231,'Reception corrector for bridging 129729',0.00,0.00,0.00,29500.00,0.00,'2022-09-21 10:19:05','',''),(2614242,'5','92','598',231,'Received from bridging 129729',0.00,0.00,29500.00,0.00,0.00,'2022-09-21 10:19:05','',''),(2614243,'5','92','598',231,'Sale Id shift 257701',0.00,0.00,0.00,391.86,0.00,'2022-09-22 14:04:44','',''),(2614244,'5','92','598',231,'Sale Id shift 257701',0.00,0.00,0.00,1775.69,0.00,'2022-09-22 14:04:44','',''),(2614245,'5','92',NULL,231,'Sale Id shift 257701',400996.75,0.00,0.00,0.00,0.00,'2022-09-22 14:04:44','',''),(2614246,'5','92','598',231,'Sale Id shift 257702',0.00,0.00,0.00,850.62,0.00,'2022-09-23 22:50:04','',''),(2614247,'5','92','598',231,'Sale Id shift 257702',0.00,0.00,0.00,1846.26,0.00,'2022-09-23 22:50:04','',''),(2614248,'5','92',NULL,231,'Sale Id shift 257702',498922.80,0.00,0.00,0.00,0.00,'2022-09-23 22:50:04','',''),(2614249,'5','92','598',231,'Sale Id shift 257703',0.00,0.00,0.00,2294.98,0.00,'2022-09-25 11:17:51','',''),(2614250,'5','92','598',231,'Sale Id shift 257703',0.00,0.00,0.00,3562.20,0.00,'2022-09-25 11:17:51','',''),(2614251,'5','92',NULL,231,'Sale Id shift 257703',1083578.30,0.00,0.00,0.00,0.00,'2022-09-25 11:17:51','',''),(2614252,'5','92','598',231,'Sale Id shift 257704',0.00,0.00,0.00,1629.86,0.00,'2022-09-25 11:26:10','',''),(2614253,'5','92','598',231,'Sale Id shift 257704',0.00,0.00,0.00,2208.93,0.00,'2022-09-25 11:26:10','',''),(2614254,'5','92',NULL,231,'Sale Id shift 257704',710176.15,0.00,0.00,0.00,0.00,'2022-09-25 11:26:10','',''),(2614255,'5','92','598',231,'Sale Id shift 257705',0.00,0.00,0.00,1407.19,0.00,'2022-09-26 09:31:24','',''),(2614256,'5','92','598',231,'Sale Id shift 257705',0.00,0.00,0.00,3548.14,0.00,'2022-09-26 09:31:24','',''),(2614257,'5','92',NULL,231,'Sale Id shift 257705',916736.05,0.00,0.00,0.00,0.00,'2022-09-26 09:31:24','',''),(2614258,'5','92','598',231,'Sale Id shift 257706',0.00,0.00,0.00,2555.58,0.00,'2022-09-27 14:40:25','',''),(2614259,'5','92','598',231,'Sale Id shift 257706',0.00,0.00,0.00,3434.98,0.00,'2022-09-27 14:40:25','',''),(2614260,'5','92',NULL,231,'Sale Id shift 257706',1108253.60,0.00,0.00,0.00,0.00,'2022-09-27 14:40:25','',''),(2614261,'5','92','598',231,'Sale Id shift 257707',0.00,0.00,0.00,1462.03,0.00,'2022-09-28 10:03:24','',''),(2614262,'5','92','598',231,'Sale Id shift 257707',0.00,0.00,0.00,2604.95,0.00,'2022-09-28 10:03:24','',''),(2614263,'5','92',NULL,231,'Sale Id shift 257707',752391.30,0.00,0.00,0.00,0.00,'2022-09-28 10:03:24','',''),(2614264,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,8325000.00,45000.00,0.00,0.00,'2022-10-01 09:56:31','',''),(2614265,'5','92',NULL,231,'Reception corrector for bridging 129730',0.00,0.00,0.00,40000.00,0.00,'2022-10-02 07:35:35','',''),(2614266,'5','92','598',231,'Received from bridging 129730',0.00,0.00,40000.00,0.00,0.00,'2022-10-02 07:35:35','',''),(2614267,'5','92','598',231,'Sale Id shift 257711',0.00,0.00,0.00,862.17,0.00,'2022-10-03 00:27:34','',''),(2614268,'5','92','598',231,'Sale Id shift 257711',0.00,0.00,0.00,1264.78,0.00,'2022-10-03 00:27:34','',''),(2614269,'5','92',NULL,231,'Sale Id shift 257711',393485.75,0.00,0.00,0.00,0.00,'2022-10-03 00:27:34','',''),(2614270,'5','92','598',231,'Sale Id shift 257712',0.00,0.00,0.00,1365.22,0.00,'2022-10-03 12:04:22','',''),(2614271,'5','92','598',231,'Sale Id shift 257712',0.00,0.00,0.00,3146.24,0.00,'2022-10-03 12:04:22','',''),(2614272,'5','92',NULL,231,'Sale Id shift 257712',834620.10,0.00,0.00,0.00,0.00,'2022-10-03 12:04:22','',''),(2614273,'5','92','598',231,'Sale Id shift 257713',0.00,0.00,0.00,1747.96,0.00,'2022-10-03 12:16:27','',''),(2614274,'5','92','598',231,'Sale Id shift 257713',0.00,0.00,0.00,2811.36,0.00,'2022-10-03 12:16:27','',''),(2614275,'5','92',NULL,231,'Sale Id shift 257713',843474.20,0.00,0.00,0.00,0.00,'2022-10-03 12:16:27','',''),(2614276,'5','92','598',231,'Sale Id shift 257714',0.00,0.00,0.00,2127.52,0.00,'2022-10-04 09:31:08','',''),(2614277,'5','92','598',231,'Sale Id shift 257714',0.00,0.00,0.00,3509.30,0.00,'2022-10-04 09:31:08','',''),(2614278,'5','92',NULL,231,'Sale Id shift 257714',1042811.70,0.00,0.00,0.00,0.00,'2022-10-04 09:31:08','',''),(2614279,'5','92','598',231,'Sale Id shift 257715',0.00,0.00,0.00,2301.88,0.00,'2022-10-05 10:04:19','',''),(2614280,'5','92','598',231,'Sale Id shift 257715',0.00,0.00,0.00,2602.60,0.00,'2022-10-05 10:04:19','',''),(2614281,'5','92',NULL,231,'Sale Id shift 257715',907328.80,0.00,0.00,0.00,0.00,'2022-10-05 10:04:19','',''),(2614282,'5','92','598',231,'Sale Id shift 257716',0.00,0.00,0.00,2090.12,0.00,'2022-10-06 09:41:40','',''),(2614283,'5','92','598',231,'Sale Id shift 257716',0.00,0.00,0.00,4215.44,0.00,'2022-10-06 09:41:40','',''),(2614284,'5','92',NULL,231,'Sale Id shift 257716',1166528.60,0.00,0.00,0.00,0.00,'2022-10-06 09:41:40','',''),(2614285,'5','92',NULL,231,'Reception corrector for bridging 129731',0.00,0.00,0.00,5000.00,0.00,'2022-10-07 09:17:59','',''),(2614286,'5','92','598',231,'Received from bridging 129731',0.00,0.00,5000.00,0.00,0.00,'2022-10-07 09:17:59','',''),(2614287,'5','92','598',231,'Sale Id shift 257717',0.00,0.00,0.00,3370.84,0.00,'2022-10-07 10:07:40','',''),(2614288,'5','92','598',231,'Sale Id shift 257717',0.00,0.00,0.00,4346.28,0.00,'2022-10-07 10:07:40','',''),(2614289,'5','92',NULL,231,'Sale Id shift 257717',1427667.20,0.00,0.00,0.00,0.00,'2022-10-07 10:07:40','',''),(2614290,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,9344.04,0.00,'2022-10-09 15:29:01','',''),(2614291,'5','92','598',0,'Inventory adjustment from tank dipping to 10000',0.00,0.00,10000.00,0.00,0.00,'2022-10-09 15:29:01','',''),(2614292,'5','92','598',231,'Sale Id shift 257718',0.00,0.00,0.00,3831.01,0.00,'2022-10-09 18:45:20','',''),(2614293,'5','92','598',231,'Sale Id shift 257718',0.00,0.00,0.00,5716.99,0.00,'2022-10-09 18:45:20','',''),(2614294,'5','92',NULL,231,'Sale Id shift 257718',1766380.00,0.00,0.00,0.00,0.00,'2022-10-09 18:45:20','',''),(2614295,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,7400000.00,40000.00,0.00,0.00,'2022-10-29 14:19:25','',''),(2614296,'5','92',NULL,231,'Reception corrector for bridging 129732',0.00,0.00,0.00,40000.00,0.00,'2022-10-29 14:27:39','',''),(2614297,'5','92','598',231,'Received from bridging 129732',0.00,0.00,40000.00,0.00,0.00,'2022-10-29 14:27:39','',''),(2614298,'5','92','598',231,'Sale Id shift 257739',0.00,0.00,0.00,1691.23,0.00,'2022-10-31 11:25:37','',''),(2614299,'5','92','598',231,'Sale Id shift 257739',0.00,0.00,0.00,872.22,0.00,'2022-10-31 11:25:37','',''),(2614300,'5','92',NULL,231,'Sale Id shift 257739',474238.25,0.00,0.00,0.00,0.00,'2022-10-31 11:25:37','',''),(2614301,'5','92','598',231,'Sale Id shift 257740',0.00,0.00,0.00,4242.98,0.00,'2022-11-07 14:51:23','',''),(2614302,'5','92','598',231,'Sale Id shift 257740',0.00,0.00,0.00,3074.55,0.00,'2022-11-07 14:51:23','',''),(2614303,'5','92',NULL,231,'Sale Id shift 257740',1353743.05,0.00,0.00,0.00,0.00,'2022-11-07 14:51:23','',''),(2614304,'5','92','598',231,'Sale Id shift 257741',0.00,0.00,0.00,4821.73,0.00,'2022-11-07 14:56:46','',''),(2614305,'5','92','598',231,'Sale Id shift 257741',0.00,0.00,0.00,5113.49,0.00,'2022-11-07 14:56:46','',''),(2614306,'5','92',NULL,231,'Sale Id shift 257741',1838015.70,0.00,0.00,0.00,0.00,'2022-11-07 14:56:46','',''),(2614307,'5','92','598',231,'Sale Id shift 257742',0.00,0.00,0.00,6124.16,0.00,'2022-11-07 15:00:17','',''),(2614308,'5','92','598',231,'Sale Id shift 257742',0.00,0.00,0.00,4719.57,0.00,'2022-11-07 15:00:17','',''),(2614309,'5','92',NULL,231,'Sale Id shift 257742',2006090.05,0.00,0.00,0.00,0.00,'2022-11-07 15:00:17','',''),(2614310,'5','92','598',231,'Sale Id shift 257743',0.00,0.00,0.00,4834.52,0.00,'2022-11-07 15:04:01','',''),(2614311,'5','92','598',231,'Sale Id shift 257743',0.00,0.00,0.00,4824.90,0.00,'2022-11-07 15:04:01','',''),(2614312,'5','92',NULL,231,'Sale Id shift 257743',1786992.70,0.00,0.00,0.00,0.00,'2022-11-07 15:04:01','',''),(2614313,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,8325000.00,45000.00,0.00,0.00,'2022-11-07 15:10:24','',''),(2614314,'5','92',NULL,231,'Reception corrector for bridging 129733',0.00,0.00,0.00,42000.00,0.00,'2022-11-07 15:12:34','',''),(2614315,'5','92','598',231,'Received from bridging 129733',0.00,0.00,42000.00,0.00,0.00,'2022-11-07 15:12:34','',''),(2614316,'5','92','598',231,'Sale Id shift 257744',0.00,0.00,0.00,5714.78,0.00,'2022-11-07 15:17:46','',''),(2614317,'5','92','598',231,'Sale Id shift 257744',0.00,0.00,0.00,6047.09,0.00,'2022-11-07 15:17:46','',''),(2614318,'5','92',NULL,231,'Sale Id shift 257744',2175945.95,0.00,0.00,0.00,0.00,'2022-11-07 15:17:46','',''),(2614319,'5','92','598',231,'Sale Id shift 257745',0.00,0.00,0.00,7017.31,0.00,'2022-11-07 15:35:29','',''),(2614320,'5','92','598',231,'Sale Id shift 257745',0.00,0.00,0.00,6311.62,0.00,'2022-11-07 15:35:29','',''),(2614321,'5','92',NULL,231,'Sale Id shift 257745',2465852.05,0.00,0.00,0.00,0.00,'2022-11-07 15:35:29','',''),(2614322,'5','92','598',231,'Sale Id shift 257746',0.00,0.00,0.00,6834.88,0.00,'2022-11-07 15:42:26','',''),(2614323,'5','92','598',231,'Sale Id shift 257746',0.00,0.00,0.00,6160.36,0.00,'2022-11-07 15:42:26','',''),(2614324,'5','92',NULL,231,'Sale Id shift 257746',2404119.40,0.00,0.00,0.00,0.00,'2022-11-07 15:42:26','',''),(2614325,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,370000.00,2000.00,0.00,0.00,'2022-11-07 15:44:30','',''),(2614326,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,4046.61,0.00,'2022-11-07 15:51:41','',''),(2614327,'5','92','598',0,'Inventory adjustment from tank dipping to 1000',0.00,0.00,1000.00,0.00,0.00,'2022-11-07 15:51:41','',''),(2614328,'5','92',NULL,231,'Reception corrector for bridging 129734',0.00,0.00,0.00,2000.00,0.00,'2022-11-07 15:56:39','',''),(2614329,'5','92','598',231,'Received from bridging 129734',0.00,0.00,2000.00,0.00,0.00,'2022-11-07 15:56:39','',''),(2614330,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,3000.00,0.00,'2022-11-07 16:19:22','',''),(2614331,'5','92','598',0,'Inventory adjustment from tank dipping to 4000',0.00,0.00,4000.00,0.00,0.00,'2022-11-07 16:19:22','',''),(2614332,'5','92','598',0,'Tank level zero out for dipping',0.00,0.00,0.00,4000.00,0.00,'2022-11-07 16:20:13','',''),(2614333,'5','92','598',0,'Inventory adjustment from tank dipping to 7000',0.00,0.00,7000.00,0.00,0.00,'2022-11-07 16:20:13','',''),(2614334,'5','92','598',231,'Sale Id shift 257747',0.00,0.00,0.00,3381.15,0.00,'2022-11-07 16:25:14','',''),(2614335,'5','92','598',231,'Sale Id shift 257747',0.00,0.00,0.00,3616.86,0.00,'2022-11-07 16:25:14','',''),(2614336,'5','92',NULL,231,'Sale Id shift 257747',1294631.85,0.00,0.00,0.00,0.00,'2022-11-07 16:25:14','',''),(2614337,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,149110.00,806.00,0.00,0.00,'2023-01-13 16:21:56','',''),(2614338,'5','92',NULL,231,'Returned purchase #88790 to SALBAS OIL & GAS NIGERIA LIMIT',149110.00,0.00,0.00,806.00,0.00,'2023-01-13 16:25:10','',''),(2614339,'5','92',NULL,231,'Purchased from SALBAS OIL & GAS NIGERIA LIMIT',0.00,222000.00,1200.00,0.00,0.00,'2023-01-13 16:26:21','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','92',233,0.00,'2023-02-17 19:36:09'),(2,'5','92',232,508.53,'2023-02-17 19:36:09'),(3,'5','92',231,22931.86,'2023-02-17 19:36:09');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1708086 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1030314,'5','92',231,'Sale Id shift 212983',0.00,515832.90,165.00,515832.90,0.00,'2021-07-26 11:58:09'),(1030358,'5','92',231,'Sale Id shift 212988',0.00,474477.30,165.00,474477.30,0.00,'2021-07-26 12:10:49'),(1031681,'5','92',231,'Sale Id shift 212990',0.00,636672.30,165.00,636672.30,0.00,'2021-07-26 16:27:14'),(1032115,'5','92',231,'Sale Id shift 213099',0.00,284197.65,165.00,284197.65,0.00,'2021-07-27 05:20:10'),(1036013,'5','92',231,'Sale Id shift 213355',0.00,519081.75,165.00,519081.75,0.00,'2021-07-27 22:22:18'),(1039344,'5','92',231,'Sale Id shift 213600',0.00,406360.35,165.00,406360.35,0.00,'2021-07-29 04:52:11'),(1043356,'5','92',231,'Sale Id shift 213730',0.00,507652.20,165.00,507652.20,0.00,'2021-07-30 06:32:16'),(1050477,'5','92',231,'Sale Id shift 213979',0.00,503317.65,165.00,503317.65,0.00,'2021-07-31 15:17:43'),(1051473,'5','92',231,'Sale Id shift 214253',0.00,533410.35,165.00,533410.35,0.00,'2021-08-01 06:32:21'),(1055149,'5','92',231,'Sale Id shift 214434',0.00,573952.50,165.00,573952.50,0.00,'2021-08-02 06:20:48'),(1059254,'5','92',231,'Sale Id shift 214590',0.00,446239.20,165.00,446239.20,0.00,'2021-08-02 20:41:35'),(1063762,'5','92',231,'Sale Id shift 214883',0.00,557483.85,165.00,557483.85,0.00,'2021-08-04 05:28:27'),(1067369,'5','92',231,'Sale Id shift 215123',0.00,493021.65,165.00,493021.65,0.00,'2021-08-05 05:49:22'),(1070556,'5','92',231,'Sale Id shift 215331',0.00,414486.60,165.00,414486.60,0.00,'2021-08-06 00:18:10'),(1074749,'5','92',231,'Sale Id shift 215637',0.00,580973.25,165.00,580973.25,0.00,'2021-08-07 05:07:38'),(1078893,'5','92',231,'Sale Id shift 215857',0.00,458206.65,165.00,458206.65,0.00,'2021-08-08 06:27:48'),(1078894,'5','92',232,'Sale Id shift 215857',0.00,32317.25,295.00,32317.25,0.00,'2021-08-08 06:27:48'),(1082588,'5','92',231,'Sale Id shift 216080',0.00,307464.30,165.00,307464.30,0.00,'2021-08-08 22:18:10'),(1082589,'5','92',232,'Sale Id shift 216080',0.00,67071.20,295.00,67071.20,0.00,'2021-08-08 22:18:10'),(1086680,'5','92',231,'Sale Id shift 216294',0.00,404193.90,165.00,404193.90,0.00,'2021-08-10 05:49:28'),(1086681,'5','92',232,'Sale Id shift 216294',0.00,24762.30,295.00,24762.30,0.00,'2021-08-10 05:49:28'),(1090446,'5','92',231,'Sale Id shift 216525',0.00,542851.65,165.00,542851.65,0.00,'2021-08-11 05:41:03'),(1090447,'5','92',232,'Sale Id shift 216525',0.00,19080.60,295.00,19080.60,0.00,'2021-08-11 05:41:03'),(1093623,'5','92',231,'Sale Id shift 216767',0.00,364255.65,165.00,364255.65,0.00,'2021-08-12 05:25:24'),(1093624,'5','92',232,'Sale Id shift 216767',0.00,18431.60,295.00,18431.60,0.00,'2021-08-12 05:25:24'),(1097102,'5','92',231,'Sale Id shift 216941',0.00,385251.90,165.00,385251.90,0.00,'2021-08-13 06:38:42'),(1097103,'5','92',232,'Sale Id shift 216941',0.00,65174.35,295.00,65174.35,0.00,'2021-08-13 06:38:42'),(1101388,'5','92',231,'Sale Id shift 217132',0.00,371264.85,165.00,371264.85,0.00,'2021-08-14 06:58:13'),(1101389,'5','92',232,'Sale Id shift 217132',0.00,245038.80,295.00,245038.80,0.00,'2021-08-14 06:58:13'),(1109659,'5','92',231,'Sale Id shift 217386',0.00,380250.75,165.00,380250.75,0.00,'2021-08-15 18:24:42'),(1109660,'5','92',232,'Sale Id shift 217386',0.00,30364.35,295.00,30364.35,0.00,'2021-08-15 18:24:42'),(1109757,'5','92',231,'Sale Id shift 217651',0.00,396801.90,165.00,396801.90,0.00,'2021-08-15 20:59:48'),(1109758,'5','92',232,'Sale Id shift 217651',0.00,19821.05,295.00,19821.05,0.00,'2021-08-15 20:59:48'),(1113648,'5','92',231,'Sale Id shift 217861',0.00,393020.10,165.00,393020.10,0.00,'2021-08-16 22:52:22'),(1113649,'5','92',232,'Sale Id shift 217861',0.00,26874.50,295.00,26874.50,0.00,'2021-08-16 22:52:22'),(1117556,'5','92',231,'Sale Id shift 218069',0.00,395396.10,165.00,395396.10,0.00,'2021-08-18 06:00:10'),(1117557,'5','92',232,'Sale Id shift 218069',0.00,45881.35,295.00,45881.35,0.00,'2021-08-18 06:00:10'),(1121047,'5','92',231,'Sale Id shift 218275',0.00,328825.20,165.00,328825.20,0.00,'2021-08-19 04:40:27'),(1121048,'5','92',232,'Sale Id shift 218275',0.00,273892.75,295.00,273892.75,0.00,'2021-08-19 04:40:27'),(1125152,'5','92',231,'Sale Id shift 218635',0.00,424160.55,165.00,424160.55,0.00,'2021-08-19 20:53:10'),(1125153,'5','92',232,'Sale Id shift 218635',0.00,49498.05,295.00,49498.05,0.00,'2021-08-19 20:53:10'),(1128864,'5','92',231,'Sale Id shift 218870',0.00,375033.45,165.00,375033.45,0.00,'2021-08-21 05:31:42'),(1128865,'5','92',232,'Sale Id shift 218870',0.00,52731.25,295.00,52731.25,0.00,'2021-08-21 05:31:42'),(1133358,'5','92',231,'Sale Id shift 219093',0.00,88118.25,165.00,88118.25,0.00,'2021-08-22 07:02:15'),(1133359,'5','92',232,'Sale Id shift 219093',0.00,44067.10,295.00,44067.10,0.00,'2021-08-22 07:02:15'),(1137363,'5','92',231,'Sale Id shift 219313',0.00,244478.85,165.00,244478.85,0.00,'2021-08-23 06:30:05'),(1137364,'5','92',232,'Sale Id shift 219313',0.00,147500.00,295.00,147500.00,0.00,'2021-08-23 06:30:05'),(1141235,'5','92',231,'Sale Id shift 219439',0.00,351080.40,165.00,351080.40,0.00,'2021-08-23 22:48:23'),(1141236,'5','92',232,'Sale Id shift 219439',0.00,134207.30,295.00,134207.30,0.00,'2021-08-23 22:48:23'),(1144997,'5','92',231,'Sale Id shift 219670',0.00,510642.00,165.00,510642.00,0.00,'2021-08-24 22:32:29'),(1144998,'5','92',232,'Sale Id shift 219670',0.00,28337.70,295.00,28337.70,0.00,'2021-08-24 22:32:29'),(1149013,'5','92',231,'Sale Id shift 219884',0.00,323723.40,165.00,323723.40,0.00,'2021-08-26 07:02:12'),(1149014,'5','92',232,'Sale Id shift 219884',0.00,39760.10,295.00,39760.10,0.00,'2021-08-26 07:02:12'),(1152679,'5','92',231,'Sale Id shift 220058',0.00,441889.80,165.00,441889.80,0.00,'2021-08-27 07:07:04'),(1152680,'5','92',232,'Sale Id shift 220058',0.00,46188.15,295.00,46188.15,0.00,'2021-08-27 07:07:04'),(1156033,'5','92',231,'Sale Id shift 220301',0.00,361168.50,165.00,361168.50,0.00,'2021-08-28 06:44:28'),(1156034,'5','92',232,'Sale Id shift 220301',0.00,46695.55,295.00,46695.55,0.00,'2021-08-28 06:44:28'),(1159829,'5','92',231,'Sale Id shift 220489',0.00,329090.85,165.00,329090.85,0.00,'2021-08-29 07:01:30'),(1159830,'5','92',232,'Sale Id shift 220489',0.00,53282.90,295.00,53282.90,0.00,'2021-08-29 07:01:30'),(1164026,'5','92',231,'Sale Id shift 220694',0.00,538230.00,165.00,538230.00,0.00,'2021-08-30 04:47:04'),(1164027,'5','92',232,'Sale Id shift 220694',0.00,24119.20,295.00,24119.20,0.00,'2021-08-30 04:47:04'),(1168118,'5','92',231,'Sale Id shift 220986',0.00,506404.80,165.00,506404.80,0.00,'2021-08-30 21:21:49'),(1168119,'5','92',232,'Sale Id shift 220986',0.00,60994.20,295.00,60994.20,0.00,'2021-08-30 21:21:49'),(1172056,'5','92',231,'Sale Id shift 221127',0.00,460495.20,165.00,460495.20,0.00,'2021-09-01 05:05:52'),(1172057,'5','92',232,'Sale Id shift 221127',0.00,25726.95,295.00,25726.95,0.00,'2021-09-01 05:05:52'),(1175948,'5','92',231,'Sale Id shift 221378',0.00,454842.30,165.00,454842.30,0.00,'2021-09-02 06:33:43'),(1175949,'5','92',232,'Sale Id shift 221378',0.00,44379.80,295.00,44379.80,0.00,'2021-09-02 06:33:43'),(1181163,'5','92',231,'Sale Id shift 221697',0.00,361247.70,165.00,361247.70,0.00,'2021-09-03 09:35:45'),(1181164,'5','92',232,'Sale Id shift 221697',0.00,44518.45,295.00,44518.45,0.00,'2021-09-03 09:35:45'),(1185999,'5','92',231,'Sale Id shift 221893',0.00,327447.45,165.00,327447.45,0.00,'2021-09-04 11:17:29'),(1186000,'5','92',232,'Sale Id shift 221893',0.00,48391.80,295.00,48391.80,0.00,'2021-09-04 11:17:29'),(1188321,'5','92',231,'Sale Id shift 222251',0.00,418301.40,165.00,418301.40,0.00,'2021-09-05 05:44:44'),(1188322,'5','92',232,'Sale Id shift 222251',0.00,19272.35,295.00,19272.35,0.00,'2021-09-05 05:44:44'),(1192146,'5','92',231,'Sale Id shift 222472',0.00,489847.05,165.00,489847.05,0.00,'2021-09-06 04:11:30'),(1192147,'5','92',232,'Sale Id shift 222472',0.00,43270.60,295.00,43270.60,0.00,'2021-09-06 04:11:30'),(1196025,'5','92',231,'Sale Id shift 222566',0.00,433978.05,165.00,433978.05,0.00,'2021-09-07 10:45:32'),(1196026,'5','92',232,'Sale Id shift 222566',0.00,20986.30,295.00,20986.30,0.00,'2021-09-07 10:45:32'),(1196905,'5','92',231,'Sale Id shift 222864',0.00,319095.15,165.00,319095.15,0.00,'2021-09-08 09:10:51'),(1196906,'5','92',232,'Sale Id shift 222864',0.00,33217.00,295.00,33217.00,0.00,'2021-09-08 09:10:51'),(1199083,'5','92',231,'Sale Id shift 223016',0.00,357023.70,165.00,357023.70,0.00,'2021-09-09 08:44:30'),(1199084,'5','92',232,'Sale Id shift 223016',0.00,20095.40,295.00,20095.40,0.00,'2021-09-09 08:44:30'),(1202485,'5','92',231,'Sale Id shift 223315',0.00,396990.00,165.00,396990.00,0.00,'2021-09-10 08:31:21'),(1202486,'5','92',232,'Sale Id shift 223315',0.00,25906.90,295.00,25906.90,0.00,'2021-09-10 08:31:21'),(1206179,'5','92',231,'Sale Id shift 223615',0.00,432809.85,165.00,432809.85,0.00,'2021-09-11 09:26:10'),(1206180,'5','92',232,'Sale Id shift 223615',0.00,25892.15,295.00,25892.15,0.00,'2021-09-11 09:26:10'),(1211373,'5','92',231,'Sale Id shift 223856',0.00,405167.40,165.00,405167.40,0.00,'2021-09-12 14:25:11'),(1211374,'5','92',232,'Sale Id shift 223856',0.00,18726.60,295.00,18726.60,0.00,'2021-09-12 14:25:11'),(1213099,'5','92',231,'Sale Id shift 224041',0.00,369298.05,165.00,369298.05,0.00,'2021-09-13 08:29:11'),(1213100,'5','92',232,'Sale Id shift 224041',0.00,17576.10,295.00,17576.10,0.00,'2021-09-13 08:29:11'),(1216773,'5','92',231,'Sale Id shift 224120',0.00,336647.85,165.00,336647.85,0.00,'2021-09-14 08:14:30'),(1216774,'5','92',232,'Sale Id shift 224120',0.00,27603.15,295.00,27603.15,0.00,'2021-09-14 08:14:30'),(1220828,'5','92',231,'Sale Id shift 224510',0.00,381288.60,165.00,381288.60,0.00,'2021-09-15 09:30:15'),(1220829,'5','92',232,'Sale Id shift 224510',0.00,23552.80,295.00,23552.80,0.00,'2021-09-15 09:30:15'),(1224317,'5','92',231,'Sale Id shift 224665',0.00,339876.90,165.00,339876.90,0.00,'2021-09-16 08:48:25'),(1224318,'5','92',232,'Sale Id shift 224665',0.00,26821.40,295.00,26821.40,0.00,'2021-09-16 08:48:25'),(1227965,'5','92',231,'Sale Id shift 224835',0.00,517972.95,163.00,511694.49,-6278.46,'2021-09-17 08:31:05'),(1227966,'5','92',232,'Sale Id shift 224835',0.00,22812.35,295.00,22812.35,0.00,'2021-09-17 08:31:05'),(1231339,'5','92',231,'Sale Id shift 225069',0.00,514309.01,163.00,514309.01,0.00,'2021-09-18 08:57:35'),(1231340,'5','92',232,'Sale Id shift 225069',0.00,89550.20,295.00,89550.20,0.00,'2021-09-18 08:57:35'),(1236908,'5','92',231,'Sale Id shift 225465',0.00,342058.76,163.00,342058.76,0.00,'2021-09-19 20:40:48'),(1236909,'5','92',232,'Sale Id shift 225465',0.00,84830.20,295.00,84830.20,0.00,'2021-09-19 20:40:48'),(1237814,'5','92',231,'Sale Id shift 225673',0.00,469816.53,163.00,469816.53,0.00,'2021-09-20 08:59:21'),(1237815,'5','92',232,'Sale Id shift 225673',0.00,57926.20,295.00,57926.20,0.00,'2021-09-20 08:59:21'),(1240032,'5','92',231,'Sale Id shift 225841',0.00,429350.15,163.00,429350.15,0.00,'2021-09-20 18:50:00'),(1240033,'5','92',232,'Sale Id shift 225841',0.00,26644.40,295.00,26644.40,0.00,'2021-09-20 18:50:00'),(1243446,'5','92',231,'Sale Id shift 226207',0.00,451620.84,163.00,451620.84,0.00,'2021-09-21 19:44:40'),(1243447,'5','92',232,'Sale Id shift 226207',0.00,23617.70,295.00,23617.70,0.00,'2021-09-21 19:44:40'),(1246149,'5','92',231,'Sale Id shift 226345',0.00,368414.23,163.00,368414.23,0.00,'2021-09-22 21:16:02'),(1246150,'5','92',232,'Sale Id shift 226345',0.00,57855.40,295.00,57855.40,0.00,'2021-09-22 21:16:02'),(1249610,'5','92',231,'Sale Id shift 226708',0.00,437697.38,163.00,437697.38,0.00,'2021-09-23 20:47:53'),(1249611,'5','92',232,'Sale Id shift 226708',0.00,46135.05,295.00,46135.05,0.00,'2021-09-23 20:47:53'),(1253145,'5','92',231,'Sale Id shift 226848',0.00,184716.49,163.00,184716.49,0.00,'2021-09-24 20:48:47'),(1253146,'5','92',232,'Sale Id shift 226848',0.00,54156.10,295.00,54156.10,0.00,'2021-09-24 20:48:47'),(1256603,'5','92',232,'Sale Id shift 226969',0.00,50863.90,295.00,50863.90,0.00,'2021-09-25 20:30:26'),(1262766,'5','92',232,'Sale Id shift 227356',0.00,96167.05,295.00,96167.05,0.00,'2021-09-27 20:41:03'),(1263523,'5','92',232,'Sale Id shift 227588',0.00,56224.05,295.00,56224.05,0.00,'2021-09-28 08:38:46'),(1307650,'5','92',232,'Sale Id shift 227978',0.00,36762.00,300.00,36762.00,0.00,'2021-10-11 14:14:56'),(1321942,'5','92',232,'Sale Id shift 231954',0.00,74391.00,300.00,74391.00,0.00,'2021-10-16 10:24:14'),(1321995,'5','92',232,'Sale Id shift 231963',0.00,38172.00,300.00,38172.00,0.00,'2021-10-16 10:34:22'),(1322012,'5','92',232,'Sale Id shift 231964',0.00,85611.00,300.00,85611.00,0.00,'2021-10-16 10:37:56'),(1322033,'5','92',232,'Sale Id shift 231966',0.00,132912.00,300.00,132912.00,0.00,'2021-10-16 10:42:20'),(1322151,'5','92',232,'Sale Id shift 231972',0.00,96627.00,300.00,96627.00,0.00,'2021-10-16 11:06:37'),(1322202,'5','92',232,'Sale Id shift 231974',0.00,66456.00,310.00,68671.20,2215.20,'2021-10-16 11:17:20'),(1334749,'5','92',231,'Sale Id shift 232069',0.00,415845.60,163.00,415845.60,0.00,'2021-10-20 09:14:55'),(1334750,'5','92',232,'Sale Id shift 232069',0.00,30678.00,320.00,32723.20,2045.20,'2021-10-20 09:14:55'),(1334835,'5','92',231,'Sale Id shift 232918',0.00,594498.49,163.00,594498.49,0.00,'2021-10-20 09:29:13'),(1334836,'5','92',232,'Sale Id shift 232918',0.00,24261.00,320.00,25878.40,1617.40,'2021-10-20 09:29:13'),(1334872,'5','92',231,'Sale Id shift 232924',0.00,801410.69,163.00,801410.69,0.00,'2021-10-20 09:36:18'),(1334873,'5','92',232,'Sale Id shift 232924',0.00,82835.20,320.00,82835.20,0.00,'2021-10-20 09:36:18'),(1334918,'5','92',231,'Sale Id shift 232929',0.00,372772.85,163.00,372772.85,0.00,'2021-10-20 09:45:04'),(1334919,'5','92',232,'Sale Id shift 232929',0.00,87161.60,320.00,87161.60,0.00,'2021-10-20 09:45:04'),(1334948,'5','92',232,'Sale Id shift 232934',0.00,69677.16,327.00,69677.16,0.00,'2021-10-20 09:49:41'),(1334964,'5','92',232,'Sale Id shift 232936',0.00,121480.50,327.00,121480.50,0.00,'2021-10-20 09:52:26'),(1334983,'5','92',232,'Sale Id shift 232940',0.00,154141.26,327.00,154141.26,0.00,'2021-10-20 09:56:01'),(1367579,'5','92',231,'Sale Id shift 235000',0.00,122830.95,165.00,122830.95,0.00,'2021-10-29 22:15:40'),(1391838,'5','92',231,'Sale Id shift 236590',0.00,833372.10,165.00,833372.10,0.00,'2021-11-05 16:14:22'),(1391839,'5','92',232,'Sale Id shift 236590',0.00,15863.10,345.00,15863.10,0.00,'2021-11-05 16:14:22'),(1404983,'5','92',231,'Sale Id shift 236887',0.00,923717.85,165.00,923717.85,0.00,'2021-11-08 14:07:59'),(1404984,'5','92',232,'Sale Id shift 236887',0.00,8449.05,345.00,8449.05,0.00,'2021-11-08 14:07:59'),(1422827,'5','92',231,'Sale Id shift 238441',0.00,300555.75,165.00,300555.75,0.00,'2021-11-12 09:55:01'),(1422828,'5','92',232,'Sale Id shift 238441',0.00,9904.95,345.00,9904.95,0.00,'2021-11-12 09:55:01'),(1436782,'5','92',231,'Sale Id shift 238938',0.00,1447995.45,165.00,1447995.45,0.00,'2021-11-15 11:08:46'),(1436783,'5','92',232,'Sale Id shift 238938',0.00,13120.35,345.00,13120.35,0.00,'2021-11-15 11:08:46'),(1441755,'5','92',231,'Sale Id shift 239202',0.00,1306397.40,165.00,1306397.40,0.00,'2021-11-16 14:14:57'),(1441756,'5','92',232,'Sale Id shift 239202',0.00,6448.05,345.00,6448.05,0.00,'2021-11-16 14:14:57'),(1447301,'5','92',231,'Sale Id shift 239472',0.00,553053.60,165.00,553053.60,0.00,'2021-11-17 18:55:38'),(1447302,'5','92',232,'Sale Id shift 239472',0.00,35697.15,345.00,35697.15,0.00,'2021-11-17 18:55:38'),(1451379,'5','92',231,'Sale Id shift 239727',0.00,229988.55,165.00,229988.55,0.00,'2021-11-18 16:48:33'),(1451380,'5','92',232,'Sale Id shift 239727',0.00,15525.00,345.00,15525.00,0.00,'2021-11-18 16:48:33'),(1460827,'5','92',231,'Sale Id shift 240233',0.00,680143.20,165.00,680143.20,0.00,'2021-11-20 18:26:03'),(1460835,'5','92',231,'Sale Id shift 240377',0.00,1604486.40,165.00,1604486.40,0.00,'2021-11-20 18:41:37'),(1467361,'5','92',231,'Sale Id shift 240622',0.00,1617511.50,165.00,1617511.50,0.00,'2021-11-22 10:41:42'),(1470498,'5','92',231,'Sale Id shift 240810',0.00,822577.80,165.00,822577.80,0.00,'2021-11-23 06:05:57'),(1478987,'5','92',231,'Sale Id shift 241179',0.00,299877.60,165.00,299877.60,0.00,'2021-11-24 20:49:19'),(1666336,'5','92',231,'Sale Id shift 250075',0.00,128700.00,165.00,128700.00,0.00,'2021-12-31 20:47:42'),(1672708,'5','92',231,'Sale Id shift 250304',0.00,920945.85,165.00,920945.85,0.00,'2022-01-02 10:13:28'),(1674491,'5','92',231,'Sale Id shift 250644',0.00,901162.35,165.00,901162.35,0.00,'2022-01-02 14:17:00'),(1680677,'5','92',231,'Sale Id shift 250735',0.00,1326893.70,165.00,1326893.70,0.00,'2022-01-03 16:53:03'),(1684555,'5','92',231,'Sale Id shift 250953',0.00,467492.85,165.00,467492.85,0.00,'2022-01-04 13:53:30'),(1687920,'5','92',231,'Sale Id shift 251208',0.00,2059358.40,165.00,2059358.40,0.00,'2022-01-05 10:46:12'),(1696809,'5','92',231,'Sale Id shift 251466',0.00,1462058.40,165.00,1462058.40,0.00,'2022-01-06 18:16:01'),(1699512,'5','92',231,'Sale Id shift 251736',0.00,1136643.75,165.00,1136643.75,0.00,'2022-01-07 12:26:11'),(1707945,'5','92',231,'Sale Id shift 251950',0.00,239641.05,165.00,239641.05,0.00,'2022-01-08 19:02:29'),(1707946,'5','92',231,'Sale Id shift 257472',0.00,1084239.75,165.00,1084239.75,0.00,'2022-02-08 11:39:48'),(1707947,'5','92',231,'Sale Id shift 257473',0.00,1217931.00,165.00,1217931.00,0.00,'2022-02-08 11:42:51'),(1707948,'5','92',231,'Sale Id shift 257474',0.00,742650.15,165.00,742650.15,0.00,'2022-02-08 11:46:15'),(1707949,'5','92',231,'Sale Id shift 257475',0.00,1725499.05,165.00,1725499.05,0.00,'2022-02-08 11:49:51'),(1707950,'5','92',231,'Sale Id shift 257476',0.00,189075.15,165.00,189075.15,0.00,'2022-02-08 11:54:34'),(1707951,'5','92',231,'Sale Id shift 257489',0.00,1789222.05,165.00,1789222.05,0.00,'2022-02-21 20:30:26'),(1707952,'5','92',231,'Sale Id shift 257490',0.00,1555096.95,165.00,1555096.95,0.00,'2022-02-22 07:23:19'),(1707953,'5','92',231,'Sale Id shift 257491',0.00,658402.80,165.00,658402.80,0.00,'2022-02-23 10:23:13'),(1707954,'5','92',231,'Sale Id shift 257492',0.00,437769.75,165.00,437769.75,0.00,'2022-02-25 23:21:06'),(1707955,'5','92',231,'Sale Id shift 257495',0.00,853267.80,165.00,853267.80,0.00,'2022-03-01 07:05:34'),(1707956,'5','92',231,'Sale Id shift 257496',0.00,2158039.95,165.00,2158039.95,0.00,'2022-03-01 11:55:45'),(1707957,'5','92',231,'Sale Id shift 257497',0.00,966741.60,165.00,966741.60,0.00,'2022-03-01 22:09:26'),(1707958,'5','92',231,'Sale Id shift 257498',0.00,1007757.30,165.00,1007757.30,0.00,'2022-03-02 09:42:25'),(1707959,'5','92',231,'Sale Id shift 257505',0.00,1042946.85,165.00,1042946.85,0.00,'2022-03-10 15:37:59'),(1707960,'5','92',231,'Sale Id shift 257506',0.00,1216307.40,165.00,1216307.40,0.00,'2022-03-10 15:43:22'),(1707961,'5','92',231,'Sale Id shift 257507',0.00,1082624.40,165.00,1082624.40,0.00,'2022-03-12 10:26:58'),(1707962,'5','92',231,'Sale Id shift 257508',0.00,1369221.15,165.00,1369221.15,0.00,'2022-03-12 21:42:14'),(1707963,'5','92',231,'Sale Id shift 257509',0.00,1187447.25,165.00,1187447.25,0.00,'2022-03-12 22:36:27'),(1707964,'5','92',231,'Sale Id shift 257510',0.00,1178375.55,165.00,1178375.55,0.00,'2022-03-13 23:25:39'),(1707965,'5','92',231,'Sale Id shift 257511',0.00,336623.10,165.00,336623.10,0.00,'2022-03-15 10:58:59'),(1707966,'5','92',231,'Sale Id shift 257512',0.00,895733.85,165.00,895733.85,0.00,'2022-03-16 22:27:42'),(1707967,'5','92',231,'Sale Id shift 257513',0.00,1449086.10,165.00,1449086.10,0.00,'2022-03-17 22:06:41'),(1707968,'5','92',231,'Sale Id shift 257514',0.00,1875233.25,165.00,1875233.25,0.00,'2022-03-19 22:50:51'),(1707969,'5','92',231,'Sale Id shift 257515',0.00,232095.60,165.00,232095.60,0.00,'2022-03-20 21:33:12'),(1707970,'5','92',231,'Sale Id shift 257536',0.00,791201.40,165.00,791201.40,0.00,'2022-04-11 09:06:30'),(1707971,'5','92',231,'Sale Id shift 257537',0.00,1605661.20,165.00,1605661.20,0.00,'2022-04-11 09:19:13'),(1707972,'5','92',231,'Sale Id shift 257538',0.00,1296715.20,165.00,1296715.20,0.00,'2022-04-12 11:25:48'),(1707973,'5','92',231,'Sale Id shift 257539',0.00,1134586.20,165.00,1134586.20,0.00,'2022-04-13 09:49:39'),(1707974,'5','92',231,'Sale Id shift 257540',0.00,149014.80,165.00,149014.80,0.00,'2022-04-15 11:05:07'),(1707975,'5','92',231,'Sale Id shift 257553',0.00,261272.55,165.00,261272.55,0.00,'2022-04-29 10:22:58'),(1707976,'5','92',231,'Sale Id shift 257554',0.00,859793.55,165.00,859793.55,0.00,'2022-05-10 10:00:56'),(1707977,'5','92',231,'Sale Id shift 257555',0.00,1295979.30,165.00,1295979.30,0.00,'2022-05-10 16:42:10'),(1707978,'5','92',231,'Sale Id shift 257556',0.00,1573098.45,165.00,1573098.45,0.00,'2022-05-10 16:44:45'),(1707979,'5','92',231,'Sale Id shift 257557',0.00,188626.35,165.00,188626.35,0.00,'2022-05-10 16:47:57'),(1707980,'5','92',231,'Sale Id shift 257558',0.00,746968.20,165.00,746968.20,0.00,'2022-05-10 16:54:00'),(1707981,'5','92',231,'Sale Id shift 257562',0.00,716783.10,165.00,716783.10,0.00,'2022-05-10 17:22:12'),(1707982,'5','92',231,'Sale Id shift 257563',0.00,918819.00,165.00,918819.00,0.00,'2022-05-10 17:34:29'),(1707983,'5','92',231,'Sale Id shift 257564',0.00,585022.35,165.00,585022.35,0.00,'2022-05-10 17:38:12'),(1707984,'5','92',231,'Sale Id shift 257565',0.00,346264.05,165.00,346264.05,0.00,'2022-05-10 17:40:45'),(1707985,'5','92',231,'Sale Id shift 257572',0.00,256035.45,165.00,256035.45,0.00,'2022-05-16 18:22:55'),(1707986,'5','92',231,'Sale Id shift 257573',0.00,1035992.10,165.00,1035992.10,0.00,'2022-05-17 09:29:27'),(1707987,'5','92',231,'Sale Id shift 257574',0.00,1426713.75,165.00,1426713.75,0.00,'2022-05-18 11:39:48'),(1707988,'5','92',231,'Sale Id shift 257575',0.00,1643639.25,165.00,1643639.25,0.00,'2022-05-19 09:59:06'),(1707989,'5','92',231,'Sale Id shift 257576',0.00,592475.40,165.00,592475.40,0.00,'2022-05-20 10:08:37'),(1707990,'5','92',231,'Sale Id shift 257580',0.00,950642.55,165.00,950642.55,0.00,'2022-05-23 21:51:28'),(1707991,'5','92',231,'Sale Id shift 257581',0.00,1707103.20,165.00,1707103.20,0.00,'2022-05-25 09:28:07'),(1707992,'5','92',231,'Sale Id shift 257582',0.00,1061052.30,165.00,1061052.30,0.00,'2022-05-26 10:34:22'),(1707993,'5','92',231,'Sale Id shift 257583',0.00,724524.90,165.00,724524.90,0.00,'2022-05-26 23:16:06'),(1707994,'5','92',231,'Sale Id shift 257584',0.00,327442.50,165.00,327442.50,0.00,'2022-05-28 22:36:33'),(1707995,'5','92',231,'Sale Id shift 257585',0.00,190213.65,165.00,190213.65,0.00,'2022-05-30 11:09:10'),(1707996,'5','92',231,'Sale Id shift 257607',0.00,752891.70,165.00,752891.70,0.00,'2022-06-21 08:50:56'),(1707997,'5','92',231,'Sale Id shift 257608',0.00,739384.80,165.00,739384.80,0.00,'2022-06-21 15:07:50'),(1707998,'5','92',231,'Sale Id shift 257609',0.00,264000.00,165.00,264000.00,0.00,'2022-06-22 12:30:05'),(1707999,'5','92',231,'Sale Id shift 257610',0.00,408074.70,165.00,408074.70,0.00,'2022-06-23 09:45:46'),(1708000,'5','92',231,'Sale Id shift 257611',0.00,269116.65,165.00,269116.65,0.00,'2022-06-24 10:10:30'),(1708001,'5','92',231,'Sale Id shift 257625',0.00,341182.05,165.00,341182.05,0.00,'2022-07-09 18:59:57'),(1708002,'5','92',231,'Sale Id shift 257626',0.00,710148.45,165.00,710148.45,0.00,'2022-07-10 21:32:07'),(1708003,'5','92',231,'Sale Id shift 257627',0.00,732560.40,165.00,732560.40,0.00,'2022-07-10 21:38:49'),(1708004,'5','92',231,'Sale Id shift 257628',0.00,912314.70,185.00,1022898.30,110583.60,'2022-07-11 11:03:23'),(1708005,'5','92',231,'Sale Id shift 257629',0.00,739384.80,185.00,829007.20,89622.40,'2022-07-12 16:16:27'),(1708006,'5','92',231,'Sale Id shift 257630',0.00,563991.45,185.00,632354.05,68362.60,'2022-07-12 18:29:54'),(1708007,'5','92',231,'Sale Id shift 257631',0.00,559015.05,185.00,626774.45,67759.40,'2022-07-14 08:40:31'),(1708008,'5','92',231,'Sale Id shift 257632',0.00,408168.75,185.00,457643.75,49475.00,'2022-07-17 14:25:18'),(1708009,'5','92',231,'Sale Id shift 257633',0.00,978059.85,165.00,872323.65,-105736.20,'2022-07-17 14:28:48'),(1708010,'5','92',231,'Sale Id shift 257634',0.00,1455015.75,165.00,1297716.75,-157299.00,'2022-07-17 14:32:27'),(1708011,'5','92',231,'Sale Id shift 257635',0.00,852217.30,185.00,852217.30,0.00,'2022-07-18 11:30:07'),(1708012,'5','92',231,'Sale Id shift 257636',0.00,845320.50,185.00,845320.50,0.00,'2022-07-19 06:53:01'),(1708013,'5','92',231,'Sale Id shift 257637',0.00,2103183.60,185.00,2103183.60,0.00,'2022-07-20 09:41:36'),(1708014,'5','92',231,'Sale Id shift 257638',0.00,1555428.20,185.00,1555428.20,0.00,'2022-07-20 19:12:06'),(1708015,'5','92',231,'Sale Id shift 257639',0.00,1692798.10,185.00,1692798.10,0.00,'2022-07-22 16:10:50'),(1708016,'5','92',231,'Sale Id shift 257640',0.00,1191844.00,185.00,1191844.00,0.00,'2022-07-23 12:47:10'),(1708017,'5','92',231,'Sale Id shift 257641',0.00,1034956.60,185.00,1034956.60,0.00,'2022-07-25 09:21:10'),(1708018,'5','92',231,'Sale Id shift 257642',0.00,849716.10,185.00,849716.10,0.00,'2022-07-25 09:29:21'),(1708019,'5','92',231,'Sale Id shift 257643',0.00,1500020.70,185.00,1500020.70,0.00,'2022-07-26 10:48:51'),(1708020,'5','92',231,'Sale Id shift 257644',0.00,997114.85,185.00,997114.85,0.00,'2022-07-26 21:03:18'),(1708021,'5','92',231,'Sale Id shift 257645',0.00,2210133.95,185.00,2210133.95,0.00,'2022-07-28 10:41:17'),(1708022,'5','92',231,'Sale Id shift 257646',0.00,52101.55,185.00,52101.55,0.00,'2022-07-31 13:14:57'),(1708023,'5','92',231,'Sale Id shift 257651',0.00,921875.35,185.00,921875.35,0.00,'2022-08-02 21:26:44'),(1708024,'5','92',231,'Sale Id shift 257652',0.00,1028538.95,185.00,1028538.95,0.00,'2022-08-04 10:50:15'),(1708025,'5','92',231,'Sale Id shift 257653',0.00,1139448.30,185.00,1139448.30,0.00,'2022-08-05 10:35:04'),(1708026,'5','92',231,'Sale Id shift 257654',0.00,1933566.35,185.00,1933566.35,0.00,'2022-08-06 14:45:25'),(1708027,'5','92',231,'Sale Id shift 257655',0.00,583884.05,185.00,583884.05,0.00,'2022-08-07 21:33:57'),(1708028,'5','92',231,'Sale Id shift 257659',0.00,237623.25,185.00,237623.25,0.00,'2022-09-05 14:59:42'),(1708029,'5','92',231,'Sale Id shift 257660',0.00,719563.05,185.00,719563.05,0.00,'2022-09-05 15:02:46'),(1708030,'5','92',231,'Sale Id shift 257661',0.00,928341.10,185.00,928341.10,0.00,'2022-09-05 15:06:18'),(1708031,'5','92',231,'Sale Id shift 257662',0.00,710960.55,185.00,710960.55,0.00,'2022-09-05 15:08:47'),(1708032,'5','92',231,'Sale Id shift 257663',0.00,993631.30,185.00,993631.30,0.00,'2022-09-05 15:13:45'),(1708033,'5','92',231,'Sale Id shift 257664',0.00,825814.10,185.00,825814.10,0.00,'2022-09-05 15:18:41'),(1708034,'5','92',231,'Sale Id shift 257665',0.00,745648.05,185.00,745648.05,0.00,'2022-09-05 15:20:37'),(1708035,'5','92',231,'Sale Id shift 257666',0.00,441343.40,185.00,441343.40,0.00,'2022-09-05 15:32:08'),(1708036,'5','92',231,'Sale Id shift 257667',0.00,867777.65,185.00,867777.65,0.00,'2022-09-05 15:34:46'),(1708037,'5','92',231,'Sale Id shift 257668',0.00,906128.15,185.00,906128.15,0.00,'2022-09-05 15:37:14'),(1708038,'5','92',231,'Sale Id shift 257669',0.00,373811.00,185.00,373811.00,0.00,'2022-09-05 15:43:09'),(1708039,'5','92',231,'Sale Id shift 257670',0.00,1083837.30,185.00,1083837.30,0.00,'2022-09-05 15:46:12'),(1708040,'5','92',231,'Sale Id shift 257671',0.00,885467.35,185.00,885467.35,0.00,'2022-09-06 11:53:50'),(1708041,'5','92',231,'Sale Id shift 257672',0.00,670504.75,185.00,670504.75,0.00,'2022-09-06 11:58:26'),(1708042,'5','92',231,'Sale Id shift 257673',0.00,727699.35,185.00,727699.35,0.00,'2022-09-06 12:01:13'),(1708043,'5','92',231,'Sale Id shift 257674',0.00,925358.90,185.00,925358.90,0.00,'2022-09-06 12:06:33'),(1708044,'5','92',231,'Sale Id shift 257675',0.00,643457.75,185.00,643457.75,0.00,'2022-09-06 12:09:47'),(1708045,'5','92',231,'Sale Id shift 257676',0.00,447674.10,185.00,447674.10,0.00,'2022-09-06 12:13:38'),(1708046,'5','92',231,'Sale Id shift 257677',0.00,840941.55,185.00,840941.55,0.00,'2022-09-06 12:16:37'),(1708047,'5','92',231,'Sale Id shift 257678',0.00,462853.35,185.00,462853.35,0.00,'2022-09-06 12:19:44'),(1708048,'5','92',231,'Sale Id shift 257679',0.00,1004481.55,185.00,1004481.55,0.00,'2022-09-06 12:22:53'),(1708049,'5','92',231,'Sale Id shift 257680',0.00,621583.35,185.00,621583.35,0.00,'2022-09-06 12:32:28'),(1708050,'5','92',231,'Sale Id shift 257681',0.00,1056849.50,185.00,1056849.50,0.00,'2022-09-06 13:15:48'),(1708051,'5','92',231,'Sale Id shift 257682',0.00,778222.85,185.00,778222.85,0.00,'2022-09-06 14:02:55'),(1708052,'5','92',231,'Sale Id shift 257683',0.00,29672.15,185.00,29672.15,0.00,'2022-09-06 14:13:01'),(1708053,'5','92',231,'Sale Id shift 257685',0.00,526352.75,185.00,526352.75,0.00,'2022-09-06 15:03:03'),(1708054,'5','92',231,'Sale Id shift 257686',0.00,1007128.90,185.00,1007128.90,0.00,'2022-09-07 10:03:40'),(1708055,'5','92',231,'Sale Id shift 257687',0.00,654413.45,185.00,654413.45,0.00,'2022-09-08 10:04:07'),(1708056,'5','92',231,'Sale Id shift 257688',0.00,1095655.10,185.00,1095655.10,0.00,'2022-09-10 12:19:10'),(1708057,'5','92',231,'Sale Id shift 257689',0.00,576619.10,185.00,576619.10,0.00,'2022-09-11 16:59:01'),(1708058,'5','92',231,'Sale Id shift 257695',0.00,404535.80,185.00,404535.80,0.00,'2022-09-16 09:39:59'),(1708059,'5','92',231,'Sale Id shift 257697',0.00,784842.15,185.00,784842.15,0.00,'2022-09-18 11:25:53'),(1708060,'5','92',231,'Sale Id shift 257698',0.00,916488.15,185.00,916488.15,0.00,'2022-09-19 09:31:48'),(1708061,'5','92',231,'Sale Id shift 257699',0.00,687435.95,185.00,687435.95,0.00,'2022-09-20 12:14:00'),(1708062,'5','92',231,'Sale Id shift 257701',0.00,400996.75,185.00,400996.75,0.00,'2022-09-22 14:04:44'),(1708063,'5','92',231,'Sale Id shift 257702',0.00,498922.80,185.00,498922.80,0.00,'2022-09-23 22:50:04'),(1708064,'5','92',231,'Sale Id shift 257703',0.00,1083578.30,185.00,1083578.30,0.00,'2022-09-25 11:17:51'),(1708065,'5','92',231,'Sale Id shift 257704',0.00,710176.15,185.00,710176.15,0.00,'2022-09-25 11:26:10'),(1708066,'5','92',231,'Sale Id shift 257705',0.00,916736.05,185.00,916736.05,0.00,'2022-09-26 09:31:24'),(1708067,'5','92',231,'Sale Id shift 257706',0.00,1108253.60,185.00,1108253.60,0.00,'2022-09-27 14:40:25'),(1708068,'5','92',231,'Sale Id shift 257707',0.00,752391.30,185.00,752391.30,0.00,'2022-09-28 10:03:24'),(1708069,'5','92',231,'Sale Id shift 257711',0.00,393485.75,185.00,393485.75,0.00,'2022-10-03 00:27:34'),(1708070,'5','92',231,'Sale Id shift 257712',0.00,834620.10,185.00,834620.10,0.00,'2022-10-03 12:04:22'),(1708071,'5','92',231,'Sale Id shift 257713',0.00,843474.20,185.00,843474.20,0.00,'2022-10-03 12:16:27'),(1708072,'5','92',231,'Sale Id shift 257714',0.00,1042811.70,185.00,1042811.70,0.00,'2022-10-04 09:31:08'),(1708073,'5','92',231,'Sale Id shift 257715',0.00,907328.80,185.00,907328.80,0.00,'2022-10-05 10:04:19'),(1708074,'5','92',231,'Sale Id shift 257716',0.00,1166528.60,185.00,1166528.60,0.00,'2022-10-06 09:41:40'),(1708075,'5','92',231,'Sale Id shift 257717',0.00,1427667.20,185.00,1427667.20,0.00,'2022-10-07 10:07:40'),(1708076,'5','92',231,'Sale Id shift 257718',0.00,1766380.00,185.00,1766380.00,0.00,'2022-10-09 18:45:20'),(1708077,'5','92',231,'Sale Id shift 257739',0.00,474238.25,185.00,474238.25,0.00,'2022-10-31 11:25:37'),(1708078,'5','92',231,'Sale Id shift 257740',0.00,1353743.05,185.00,1353743.05,0.00,'2022-11-07 14:51:23'),(1708079,'5','92',231,'Sale Id shift 257741',0.00,1838015.70,185.00,1838015.70,0.00,'2022-11-07 14:56:46'),(1708080,'5','92',231,'Sale Id shift 257742',0.00,2006090.05,185.00,2006090.05,0.00,'2022-11-07 15:00:17'),(1708081,'5','92',231,'Sale Id shift 257743',0.00,1786992.70,185.00,1786992.70,0.00,'2022-11-07 15:04:01'),(1708082,'5','92',231,'Sale Id shift 257744',0.00,2175945.95,185.00,2175945.95,0.00,'2022-11-07 15:17:46'),(1708083,'5','92',231,'Sale Id shift 257745',0.00,2465852.05,185.00,2465852.05,0.00,'2022-11-07 15:35:29'),(1708084,'5','92',231,'Sale Id shift 257746',0.00,2404119.40,185.00,2404119.40,0.00,'2022-11-07 15:42:26'),(1708085,'5','92',231,'Sale Id shift 257747',0.00,1294631.85,185.00,1294631.85,0.00,'2022-11-07 16:25:14');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4961327 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','92',3555392,'','20','2222',36762.00,0.00,'Sales from shift 227978 on 2021-10-11 14:14:56 ','2021-10-11 14:14:56','',''),('5','92',3555393,'','6.1','2221',0.00,36762.00,'Sales from shift 227978 on 2021-10-11 14:14:56 ','2021-10-11 14:14:56','',''),('5','92',3570640,'','24','2219',0.00,1305900.00,'Purchase Id 78182 for 4,353.00 litters of Diesel - AGO from SALBAS OIL & GAS NIGERIA LIMIT','2021-10-13 09:13:15','',''),('5','92',3570641,'','supplier','100',1305900.00,0.00,'Purchase Id 78182 for 4,353.00 litters of Diesel - AGO from SALBAS OIL & GAS NIGERIA LIMIT','2021-10-13 09:13:15','',''),('5','92',3570675,'','24','2219',0.00,257051.00,'Purchase Id 78181 for 1,577.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-10-13 09:15:22','',''),('5','92',3570676,'','supplier','100',257051.00,0.00,'Purchase Id 78181 for 1,577.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-10-13 09:15:22','',''),('5','92',3601443,'','20','2222',74391.00,0.00,'Sales from shift 231954 on 2021-10-16 10:24:14 ','2021-10-16 10:24:14','',''),('5','92',3601444,'','6.1','2221',0.00,74391.00,'Sales from shift 231954 on 2021-10-16 10:24:14 ','2021-10-16 10:24:14','',''),('5','92',3601556,'','20','2222',38172.00,0.00,'Sales from shift 231963 on 2021-10-16 10:34:22 ','2021-10-16 10:34:22','',''),('5','92',3601557,'','6.1','2221',0.00,38172.00,'Sales from shift 231963 on 2021-10-16 10:34:22 ','2021-10-16 10:34:22','',''),('5','92',3601594,'','20','2222',85611.00,0.00,'Sales from shift 231964 on 2021-10-16 10:37:56 ','2021-10-16 10:37:56','',''),('5','92',3601595,'','6.1','2221',0.00,85611.00,'Sales from shift 231964 on 2021-10-16 10:37:56 ','2021-10-16 10:37:56','',''),('5','92',3601642,'','20','2222',132912.00,0.00,'Sales from shift 231966 on 2021-10-16 10:42:20 ','2021-10-16 10:42:20','',''),('5','92',3601643,'','6.1','2221',0.00,132912.00,'Sales from shift 231966 on 2021-10-16 10:42:20 ','2021-10-16 10:42:20','',''),('5','92',3602047,'','20','2222',96627.00,0.00,'Sales from shift 231972 on 2021-10-16 11:06:37 ','2021-10-16 11:06:37','',''),('5','92',3602048,'','6.1','2221',0.00,96627.00,'Sales from shift 231972 on 2021-10-16 11:06:37 ','2021-10-16 11:06:37','',''),('5','92',3602210,'','20','2222',68671.20,0.00,'Sales from shift 231974 on 2021-10-16 11:17:20 ','2021-10-16 11:17:20','',''),('5','92',3602211,'','6.1','2221',0.00,68671.20,'Sales from shift 231974 on 2021-10-16 11:17:20 ','2021-10-16 11:17:20','',''),('5','92',3605667,'','24','2219',0.00,2159750.00,'Purchase Id 78429 for 13,250.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-10-16 15:34:20','',''),('5','92',3605668,'','supplier','100',2159750.00,0.00,'Purchase Id 78429 for 13,250.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-10-16 15:34:20','',''),('5','92',3639082,'','20','2222',448568.80,0.00,'Sales from shift 232069 on 2021-10-20 09:14:55 ','2021-10-20 09:14:55','',''),('5','92',3639083,'','6.1','2221',0.00,448568.80,'Sales from shift 232069 on 2021-10-20 09:14:55 ','2021-10-20 09:14:55','',''),('5','92',3639455,'','20','2222',620376.89,0.00,'Sales from shift 232918 on 2021-10-20 09:29:13 ','2021-10-20 09:29:13','',''),('5','92',3639456,'','6.1','2221',0.00,620376.89,'Sales from shift 232918 on 2021-10-20 09:29:13 ','2021-10-20 09:29:13','',''),('5','92',3639604,'','20','2222',884245.89,0.00,'Sales from shift 232924 on 2021-10-20 09:36:18 ','2021-10-20 09:36:18','',''),('5','92',3639605,'','6.1','2221',0.00,884245.89,'Sales from shift 232924 on 2021-10-20 09:36:18 ','2021-10-20 09:36:18','',''),('5','92',3639776,'','20','2222',459934.45,0.00,'Sales from shift 232929 on 2021-10-20 09:45:04 ','2021-10-20 09:45:04','',''),('5','92',3639777,'','6.1','2221',0.00,459934.45,'Sales from shift 232929 on 2021-10-20 09:45:04 ','2021-10-20 09:45:04','',''),('5','92',3639866,'','20','2222',69677.16,0.00,'Sales from shift 232934 on 2021-10-20 09:49:41 ','2021-10-20 09:49:41','',''),('5','92',3639867,'','6.1','2221',0.00,69677.16,'Sales from shift 232934 on 2021-10-20 09:49:41 ','2021-10-20 09:49:41','',''),('5','92',3639913,'','20','2222',121480.50,0.00,'Sales from shift 232936 on 2021-10-20 09:52:26 ','2021-10-20 09:52:26','',''),('5','92',3639914,'','6.1','2221',0.00,121480.50,'Sales from shift 232936 on 2021-10-20 09:52:26 ','2021-10-20 09:52:26','',''),('5','92',3639979,'','20','2222',154141.26,0.00,'Sales from shift 232940 on 2021-10-20 09:56:01 ','2021-10-20 09:56:01','',''),('5','92',3639980,'','6.1','2221',0.00,154141.26,'Sales from shift 232940 on 2021-10-20 09:56:01 ','2021-10-20 09:56:01','',''),('5','92',3640240,'','20','2222',0.00,0.00,'Sales from shift 232945 on 2021-10-20 10:10:50 ','2021-10-20 10:10:50','',''),('5','92',3640241,'','6.1','2221',0.00,0.00,'Sales from shift 232945 on 2021-10-20 10:10:50 ','2021-10-20 10:10:50','',''),('5','92',3641008,'','2','2220',67895.00,0.00,'Payment Id 347456 for invoice:231954, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 10:59:18','',''),('5','92',3641009,'','supplier','100',0.00,67895.00,'Payment Id 347456 for invoice:231954, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 10:59:18','',''),('5','92',3641016,'','6.1','2221',6500.00,0.00,'Payment Id 347458 for invoice:231954, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 10:59:51','',''),('5','92',3641017,'','supplier','100',0.00,6500.00,'Payment Id 347458 for invoice:231954, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 10:59:51','',''),('5','92',3641021,'','2','2220',33675.00,0.00,'Payment Id 347461 for invoice:231963, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:00:20','',''),('5','92',3641022,'','supplier','100',0.00,33675.00,'Payment Id 347461 for invoice:231963, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:00:20','',''),('5','92',3641043,'','6.1','2221',4500.00,0.00,'Payment Id 347463 for invoice:231963, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:00:37','',''),('5','92',3641044,'','supplier','100',0.00,4500.00,'Payment Id 347463 for invoice:231963, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:00:37','',''),('5','92',3641055,'','2','2220',62415.00,0.00,'Payment Id 347465 for invoice:231964, receipt: 0053 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:01:09','',''),('5','92',3641056,'','supplier','100',0.00,62415.00,'Payment Id 347465 for invoice:231964, receipt: 0053 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:01:09','',''),('5','92',3641061,'','6.1','2221',23200.00,0.00,'Payment Id 347471 for invoice:231964, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:01:35','',''),('5','92',3641062,'','supplier','100',0.00,23200.00,'Payment Id 347471 for invoice:231964, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:01:35','',''),('5','92',3641069,'','2','2220',128500.00,0.00,'Payment Id 347472 for invoice:231966, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:01:57','',''),('5','92',3641070,'','supplier','100',0.00,128500.00,'Payment Id 347472 for invoice:231966, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:01:57','',''),('5','92',3641077,'','6.1','2221',4500.00,0.00,'Payment Id 347474 for invoice:231966, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:02:10','',''),('5','92',3641078,'','supplier','100',0.00,4500.00,'Payment Id 347474 for invoice:231966, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:02:10','',''),('5','92',3641166,'','2','2220',92140.00,0.00,'Payment Id 347476 for invoice:231972, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:07:15','',''),('5','92',3641167,'','supplier','100',0.00,92140.00,'Payment Id 347476 for invoice:231972, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:07:15','',''),('5','92',3641280,'','6.1','2221',4640.00,0.00,'Payment Id 347477 for invoice:232945, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:15:17','',''),('5','92',3641281,'','supplier','100',0.00,4640.00,'Payment Id 347477 for invoice:232945, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:15:17','',''),('5','92',3641296,'','2','2220',64160.00,0.00,'Payment Id 347479 for invoice:231974, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:16:07','',''),('5','92',3641297,'','supplier','100',0.00,64160.00,'Payment Id 347479 for invoice:231974, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:16:07','',''),('5','92',3641307,'','6.1','2221',4650.00,0.00,'Payment Id 347482 for invoice:231974, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:16:28','',''),('5','92',3641308,'','supplier','100',0.00,4650.00,'Payment Id 347482 for invoice:231974, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:16:28','',''),('5','92',3641350,'','2','2220',223770.00,0.00,'Payment Id 347485 for invoice:232069, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:19:23','',''),('5','92',3641351,'','supplier','100',0.00,223770.00,'Payment Id 347485 for invoice:232069, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:19:23','',''),('5','92',3641390,'','2','2220',615580.00,0.00,'Payment Id 347496 for invoice:232918, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:21:48','',''),('5','92',3641391,'','supplier','100',0.00,615580.00,'Payment Id 347496 for invoice:232918, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:21:48','',''),('5','92',3641404,'','6.1','2221',4800.00,0.00,'Payment Id 347499 for invoice:232945, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:22:26','',''),('5','92',3641405,'','supplier','100',0.00,4800.00,'Payment Id 347499 for invoice:232945, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:22:26','',''),('5','92',3641417,'','2','2220',879445.00,0.00,'Payment Id 347502 for invoice:232924, receipt: 0018 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:23:03','',''),('5','92',3641418,'','supplier','100',0.00,879445.00,'Payment Id 347502 for invoice:232924, receipt: 0018 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:23:03','',''),('5','92',3641432,'','6.1','2221',4800.00,0.00,'Payment Id 347505 for invoice:232945, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:23:56','',''),('5','92',3641433,'','supplier','100',0.00,4800.00,'Payment Id 347505 for invoice:232945, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:23:56','',''),('5','92',3641438,'','2','2220',455135.00,0.00,'Payment Id 347506 for invoice:232929, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:24:19','',''),('5','92',3641439,'','supplier','100',0.00,455135.00,'Payment Id 347506 for invoice:232929, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:24:19','',''),('5','92',3641454,'','6.1','2221',4800.00,0.00,'Payment Id 347508 for invoice:232929, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:24:57','',''),('5','92',3641455,'','supplier','100',0.00,4800.00,'Payment Id 347508 for invoice:232929, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:24:57','',''),('5','92',3641460,'','2','2220',64775.00,0.00,'Payment Id 347510 for invoice:232934, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:25:18','',''),('5','92',3641461,'','supplier','100',0.00,64775.00,'Payment Id 347510 for invoice:232934, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:25:18','',''),('5','92',3641464,'','6.1','2221',4905.00,0.00,'Payment Id 347513 for invoice:232945, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:25:40','',''),('5','92',3641465,'','supplier','100',0.00,4905.00,'Payment Id 347513 for invoice:232945, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:25:40','',''),('5','92',3641510,'','2','2220',115175.00,0.00,'Payment Id 347515 for invoice:232936, receipt: 0137905 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:27:41','',''),('5','92',3641511,'','supplier','100',0.00,115175.00,'Payment Id 347515 for invoice:232936, receipt: 0137905 by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:27:41','',''),('5','92',3641605,'','6.1','2221',6305.00,0.00,'Payment Id 347517 for invoice:232945, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:33:24','',''),('5','92',3641606,'','supplier','100',0.00,6305.00,'Payment Id 347517 for invoice:232945, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:33:24','',''),('5','92',3641609,'','6.1','2221',224800.00,0.00,'Payment Id 347489 for invoice:232069, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:33:46','',''),('5','92',3641610,'','supplier','100',0.00,224800.00,'Payment Id 347489 for invoice:232069, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-10-20 11:33:46','',''),('5','92',3650220,'','20','2222',0.00,0.00,'Sales from shift 233061 on 2021-10-21 08:06:49 ','2021-10-21 08:06:49','',''),('5','92',3650221,'','6.1','2221',0.00,0.00,'Sales from shift 233061 on 2021-10-21 08:06:49 ','2021-10-21 08:06:49','',''),('5','92',3658225,'','20','2222',0.00,0.00,'Sales from shift 233312 on 2021-10-22 06:30:21 ','2021-10-22 06:30:21','',''),('5','92',3658226,'','6.1','2221',0.00,0.00,'Sales from shift 233312 on 2021-10-22 06:30:21 ','2021-10-22 06:30:21','',''),('5','92',3671478,'','20','2222',0.00,0.00,'Sales from shift 233585 on 2021-10-23 09:04:54 ','2021-10-23 09:04:54','',''),('5','92',3671479,'','6.1','2221',0.00,0.00,'Sales from shift 233585 on 2021-10-23 09:04:54 ','2021-10-23 09:04:54','',''),('5','92',3683972,'','20','2222',0.00,0.00,'Sales from shift 233769 on 2021-10-24 13:32:19 ','2021-10-24 13:32:19','',''),('5','92',3683973,'','6.1','2221',0.00,0.00,'Sales from shift 233769 on 2021-10-24 13:32:19 ','2021-10-24 13:32:19','',''),('5','92',3697246,'','20','2222',0.00,0.00,'Sales from shift 234026 on 2021-10-25 20:04:36 ','2021-10-25 20:04:36','',''),('5','92',3697247,'','6.1','2221',0.00,0.00,'Sales from shift 234026 on 2021-10-25 20:04:36 ','2021-10-25 20:04:36','',''),('5','92',3728407,'','20','2222',0.00,0.00,'Sales from shift 234996 on 2021-10-28 16:02:39 ','2021-10-28 16:02:39','',''),('5','92',3728408,'','6.1','2221',0.00,0.00,'Sales from shift 234996 on 2021-10-28 16:02:39 ','2021-10-28 16:02:39','',''),('5','92',3728479,'','20','2222',0.00,0.00,'Sales from shift 234997 on 2021-10-28 16:08:21 ','2021-10-28 16:08:21','',''),('5','92',3728480,'','6.1','2221',0.00,0.00,'Sales from shift 234997 on 2021-10-28 16:08:21 ','2021-10-28 16:08:21','',''),('5','92',3728521,'','20','2222',0.00,0.00,'Sales from shift 234999 on 2021-10-28 16:13:27 ','2021-10-28 16:13:27','',''),('5','92',3728522,'','6.1','2221',0.00,0.00,'Sales from shift 234999 on 2021-10-28 16:13:27 ','2021-10-28 16:13:27','',''),('5','92',3738357,'','20','2222',122830.95,0.00,'Sales from shift 235000 on 2021-10-29 22:15:40 ','2021-10-29 22:15:40','',''),('5','92',3738358,'','6.1','2221',0.00,122830.95,'Sales from shift 235000 on 2021-10-29 22:15:40 ','2021-10-29 22:15:40','',''),('5','92',3757786,'','20','2222',0.00,0.00,'Sales from shift 235459 on 2021-10-31 18:08:37 ','2021-10-31 18:08:37','',''),('5','92',3757787,'','6.1','2221',0.00,0.00,'Sales from shift 235459 on 2021-10-31 18:08:37 ','2021-10-31 18:08:37','',''),('5','92',3766614,'','20','2222',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','92',3768936,'','24','2223',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','92',3769093,'','6.1','2221',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','92',3770219,'','2','2220',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','92',3770324,'','24','2219',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','92',3776960,'','20','2222',0.00,0.00,'Sales from shift 235696 on 2021-11-02 16:27:06 ','2021-11-02 16:27:06','',''),('5','92',3776961,'','6.1','2221',0.00,0.00,'Sales from shift 235696 on 2021-11-02 16:27:06 ','2021-11-02 16:27:06','',''),('5','92',3792420,'','20','2222',0.00,0.00,'Sales from shift 236449 on 2021-11-04 08:46:24 ','2021-11-04 08:46:24','',''),('5','92',3792421,'','6.1','2221',0.00,0.00,'Sales from shift 236449 on 2021-11-04 08:46:24 ','2021-11-04 08:46:24','',''),('5','92',3792523,'','20','2222',0.00,0.00,'Sales from shift 236581 on 2021-11-04 08:51:34 ','2021-11-04 08:51:34','',''),('5','92',3792524,'','6.1','2221',0.00,0.00,'Sales from shift 236581 on 2021-11-04 08:51:34 ','2021-11-04 08:51:34','',''),('5','92',3792627,'','20','2222',0.00,0.00,'Sales from shift 236584 on 2021-11-04 08:55:23 ','2021-11-04 08:55:23','',''),('5','92',3792628,'','6.1','2221',0.00,0.00,'Sales from shift 236584 on 2021-11-04 08:55:23 ','2021-11-04 08:55:23','',''),('5','92',3792692,'','24','2219',0.00,2145000.00,'Purchase Id 79762 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-11-04 08:58:40','',''),('5','92',3792693,'','supplier','100',2145000.00,0.00,'Purchase Id 79762 for 13,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-11-04 08:58:40','',''),('5','92',3814987,'','20','2222',849235.20,0.00,'Sales from shift 236590 on 2021-11-05 16:14:22 ','2021-11-05 16:14:22','',''),('5','92',3814988,'','6.1','2221',0.00,849235.20,'Sales from shift 236590 on 2021-11-05 16:14:22 ','2021-11-05 16:14:22','',''),('5','92',3846273,'','20','2222',932166.90,0.00,'Sales from shift 236887 on 2021-11-08 14:07:59 ','2021-11-08 14:07:59','',''),('5','92',3846274,'','6.1','2221',0.00,932166.90,'Sales from shift 236887 on 2021-11-08 14:07:59 ','2021-11-08 14:07:59','',''),('5','92',3846295,'','2','2220',147840.00,0.00,'Payment Id 356387 for invoice:232940, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:09:10','',''),('5','92',3846296,'','supplier','100',0.00,147840.00,'Payment Id 356387 for invoice:232940, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:09:10','',''),('5','92',3846305,'','6.1','2221',6305.00,0.00,'Payment Id 356388 for invoice:232940, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:09:28','',''),('5','92',3846306,'','supplier','100',0.00,6305.00,'Payment Id 356388 for invoice:232940, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:09:28','',''),('5','92',3846313,'','2','2220',116300.00,0.00,'Payment Id 356389 for invoice:235000, receipt: 123 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:10:02','',''),('5','92',3846314,'','supplier','100',0.00,116300.00,'Payment Id 356389 for invoice:235000, receipt: 123 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:10:02','',''),('5','92',3846319,'','6.1','2221',6575.00,0.00,'Payment Id 356390 for invoice:23500, receipt: 123 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:10:24','',''),('5','92',3846320,'','supplier','100',0.00,6575.00,'Payment Id 356390 for invoice:23500, receipt: 123 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:10:24','',''),('5','92',3846335,'','2','2220',830660.00,0.00,'Payment Id 356391 for invoice:236590, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:10:55','',''),('5','92',3846336,'','supplier','100',0.00,830660.00,'Payment Id 356391 for invoice:236590, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:10:55','',''),('5','92',3846372,'','6.1','2221',18575.00,0.00,'Payment Id 356392 for invoice:236590, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:12:09','',''),('5','92',3846373,'','supplier','100',0.00,18575.00,'Payment Id 356392 for invoice:236590, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-08 14:12:09','',''),('5','92',3894511,'','20','2222',310460.70,0.00,'Sales from shift 238441 on 2021-11-12 09:55:01 ','2021-11-12 09:55:01','',''),('5','92',3894512,'','6.1','2221',0.00,310460.70,'Sales from shift 238441 on 2021-11-12 09:55:01 ','2021-11-12 09:55:01','',''),('5','92',3894599,'','20','2222',0.00,0.00,'Sales from shift 238456 on 2021-11-12 09:59:35 ','2021-11-12 09:59:35','',''),('5','92',3894600,'','6.1','2221',0.00,0.00,'Sales from shift 238456 on 2021-11-12 09:59:35 ','2021-11-12 09:59:35','',''),('5','92',3894640,'','20','2222',0.00,0.00,'Sales from shift 238459 on 2021-11-12 10:02:02 ','2021-11-12 10:02:02','',''),('5','92',3894641,'','6.1','2221',0.00,0.00,'Sales from shift 238459 on 2021-11-12 10:02:02 ','2021-11-12 10:02:02','',''),('5','92',3894728,'','20','2222',0.00,0.00,'Sales from shift 238461 on 2021-11-12 10:05:38 ','2021-11-12 10:05:38','',''),('5','92',3894729,'','6.1','2221',0.00,0.00,'Sales from shift 238461 on 2021-11-12 10:05:38 ','2021-11-12 10:05:38','',''),('5','92',3894793,'','20','2222',0.00,0.00,'Sales from shift 238465 on 2021-11-12 10:08:43 ','2021-11-12 10:08:43','',''),('5','92',3894794,'','6.1','2221',0.00,0.00,'Sales from shift 238465 on 2021-11-12 10:08:43 ','2021-11-12 10:08:43','',''),('5','92',3894869,'','20','2222',0.00,0.00,'Sales from shift 238466 on 2021-11-12 10:11:53 ','2021-11-12 10:11:53','',''),('5','92',3894870,'','6.1','2221',0.00,0.00,'Sales from shift 238466 on 2021-11-12 10:11:53 ','2021-11-12 10:11:53','',''),('5','92',3915279,'','20','2222',0.00,0.00,'Sales from shift 238472 on 2021-11-13 21:06:43 ','2021-11-13 21:06:43','',''),('5','92',3915280,'','6.1','2221',0.00,0.00,'Sales from shift 238472 on 2021-11-13 21:06:43 ','2021-11-13 21:06:43','',''),('5','92',3915287,'','24','2219',0.00,3514500.00,'Purchase Id 80516 for 21,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-11-13 21:24:09','',''),('5','92',3915288,'','supplier','100',3514500.00,0.00,'Purchase Id 80516 for 21,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-11-13 21:24:09','',''),('5','92',3915289,'','20','2222',0.00,0.00,'Sales from shift 238801 on 2021-11-13 21:25:10 ','2021-11-13 21:25:10','',''),('5','92',3915290,'','6.1','2221',0.00,0.00,'Sales from shift 238801 on 2021-11-13 21:25:10 ','2021-11-13 21:25:10','',''),('5','92',3931458,'','20','2222',1461115.80,0.00,'Sales from shift 238938 on 2021-11-15 11:08:46 ','2021-11-15 11:08:46','',''),('5','92',3931459,'','6.1','2221',0.00,1461115.80,'Sales from shift 238938 on 2021-11-15 11:08:46 ','2021-11-15 11:08:46','',''),('5','92',3945637,'','20','2222',1312845.45,0.00,'Sales from shift 239202 on 2021-11-16 14:14:57 ','2021-11-16 14:14:57','',''),('5','92',3945638,'','6.1','2221',0.00,1312845.45,'Sales from shift 239202 on 2021-11-16 14:14:57 ','2021-11-16 14:14:57','',''),('5','92',3945665,'','2','2220',700295.00,0.00,'Payment Id 358997 for invoice:236887, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:16:01','',''),('5','92',3945666,'','supplier','100',0.00,700295.00,'Payment Id 358997 for invoice:236887, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:16:01','',''),('5','92',3945667,'','6.1','2221',231875.00,0.00,'Payment Id 359001 for invoice:236887, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:16:19','',''),('5','92',3945668,'','supplier','100',0.00,231875.00,'Payment Id 359001 for invoice:236887, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:16:19','',''),('5','92',3945681,'','2','2220',301980.00,0.00,'Payment Id 359004 for invoice:238212, receipt: 0137905 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:16:38','',''),('5','92',3945682,'','supplier','100',0.00,301980.00,'Payment Id 359004 for invoice:238212, receipt: 0137905 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:16:38','',''),('5','92',3945766,'','6.1','2221',24575.00,0.00,'Payment Id 361134 for invoice:238938, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:21:14','',''),('5','92',3945767,'','supplier','100',0.00,24575.00,'Payment Id 361134 for invoice:238938, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:21:14','',''),('5','92',3945782,'','2','2220',1301085.00,0.00,'Payment Id 361627 for invoice:239202, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:22:18','',''),('5','92',3945783,'','supplier','100',0.00,1301085.00,'Payment Id 361627 for invoice:239202, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:22:18','',''),('5','92',3945788,'','6.1','2221',11575.00,0.00,'Payment Id 361630 for invoice:239202, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:22:50','',''),('5','92',3945789,'','supplier','100',0.00,11575.00,'Payment Id 361630 for invoice:239202, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-16 14:22:50','',''),('5','92',3961853,'','20','2222',588750.75,0.00,'Sales from shift 239472 on 2021-11-17 18:55:38 ','2021-11-17 18:55:38','',''),('5','92',3961854,'','6.1','2221',0.00,588750.75,'Sales from shift 239472 on 2021-11-17 18:55:38 ','2021-11-17 18:55:38','',''),('5','92',3973328,'','20','2222',245513.55,0.00,'Sales from shift 239727 on 2021-11-18 16:48:33 ','2021-11-18 16:48:33','',''),('5','92',3973329,'','6.1','2221',0.00,245513.55,'Sales from shift 239727 on 2021-11-18 16:48:33 ','2021-11-18 16:48:33','',''),('5','92',3985872,'','20','2222',0.00,0.00,'Sales from shift 239932 on 2021-11-19 21:58:03 ','2021-11-19 21:58:03','',''),('5','92',3985873,'','6.1','2221',0.00,0.00,'Sales from shift 239932 on 2021-11-19 21:58:03 ','2021-11-19 21:58:03','',''),('5','92',3998983,'','24','2219',0.00,4950000.00,'Purchase Id 80987 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-11-20 18:12:58','',''),('5','92',3998984,'','supplier','100',4950000.00,0.00,'Purchase Id 80987 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-11-20 18:12:58','',''),('5','92',3999046,'','20','2222',680143.20,0.00,'Sales from shift 240233 on 2021-11-20 18:26:03 ','2021-11-20 18:26:03','',''),('5','92',3999047,'','6.1','2221',0.00,680143.20,'Sales from shift 240233 on 2021-11-20 18:26:03 ','2021-11-20 18:26:03','',''),('5','92',3999086,'','20','2222',1604486.40,0.00,'Sales from shift 240377 on 2021-11-20 18:41:37 ','2021-11-20 18:41:37','',''),('5','92',3999087,'','6.1','2221',0.00,1604486.40,'Sales from shift 240377 on 2021-11-20 18:41:37 ','2021-11-20 18:41:37','',''),('5','92',4003386,'','6.1','2221',7175.00,0.00,'Payment Id 359005 for invoice:238212, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:45:26','',''),('5','92',4003387,'','supplier','100',0.00,7175.00,'Payment Id 359005 for invoice:238212, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:45:26','',''),('5','92',4003404,'','2','2220',1436640.00,0.00,'Payment Id 361131 for invoice:238938, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:46:09','',''),('5','92',4003405,'','supplier','100',0.00,1436640.00,'Payment Id 361131 for invoice:238938, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:46:09','',''),('5','92',4003421,'','2','2220',582175.00,0.00,'Payment Id 362211 for invoice:239472, receipt: 018218 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:46:36','',''),('5','92',4003422,'','supplier','100',0.00,582175.00,'Payment Id 362211 for invoice:239472, receipt: 018218 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:46:36','',''),('5','92',4003425,'','6.1','2221',6575.00,0.00,'Payment Id 362213 for invoice:239472, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:46:56','',''),('5','92',4003426,'','supplier','100',0.00,6575.00,'Payment Id 362213 for invoice:239472, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:46:56','',''),('5','92',4003433,'','2','2220',234940.00,0.00,'Payment Id 362803 for invoice:239727, receipt: 0123898 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:47:21','',''),('5','92',4003434,'','supplier','100',0.00,234940.00,'Payment Id 362803 for invoice:239727, receipt: 0123898 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:47:21','',''),('5','92',4003448,'','6.1','2221',10575.00,0.00,'Payment Id 362806 for invoice:239727, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:47:44','',''),('5','92',4003449,'','supplier','100',0.00,10575.00,'Payment Id 362806 for invoice:239727, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-21 09:47:44','',''),('5','92',4015830,'','20','2222',1617511.50,0.00,'Sales from shift 240622 on 2021-11-22 10:41:42 ','2021-11-22 10:41:42','',''),('5','92',4015831,'','6.1','2221',0.00,1617511.50,'Sales from shift 240622 on 2021-11-22 10:41:42 ','2021-11-22 10:41:42','',''),('5','92',4024174,'','20','2222',822577.80,0.00,'Sales from shift 240810 on 2021-11-23 06:05:57 ','2021-11-23 06:05:57','',''),('5','92',4024175,'','6.1','2221',0.00,822577.80,'Sales from shift 240810 on 2021-11-23 06:05:57 ','2021-11-23 06:05:57','',''),('5','92',4049281,'','20','2222',299877.60,0.00,'Sales from shift 241179 on 2021-11-24 20:49:19 ','2021-11-24 20:49:19','',''),('5','92',4049282,'','6.1','2221',0.00,299877.60,'Sales from shift 241179 on 2021-11-24 20:49:19 ','2021-11-24 20:49:19','',''),('5','92',4074740,'','20','2222',0.00,0.00,'Sales from shift 241446 on 2021-11-26 20:49:16 ','2021-11-26 20:49:16','',''),('5','92',4074741,'','6.1','2221',0.00,0.00,'Sales from shift 241446 on 2021-11-26 20:49:16 ','2021-11-26 20:49:16','',''),('5','92',4108194,'','2','2220',674970.00,0.00,'Payment Id 364632 for invoice:240233, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:22:56','',''),('5','92',4108195,'','supplier','100',0.00,674970.00,'Payment Id 364632 for invoice:240233, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:22:56','',''),('5','92',4108200,'','6.1','2221',5175.00,0.00,'Payment Id 364633 for invoice:24233, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:23:09','',''),('5','92',4108201,'','supplier','100',0.00,5175.00,'Payment Id 364633 for invoice:24233, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:23:09','',''),('5','92',4108210,'','2','2220',1597315.00,0.00,'Payment Id 364634 for invoice:240377, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:23:27','',''),('5','92',4108211,'','supplier','100',0.00,1597315.00,'Payment Id 364634 for invoice:240377, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:23:27','',''),('5','92',4108212,'','6.1','2221',7175.00,0.00,'Payment Id 364637 for invoice:240377, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:23:41','',''),('5','92',4108213,'','supplier','100',0.00,7175.00,'Payment Id 364637 for invoice:240377, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:23:41','',''),('5','92',4108214,'','6.1','2221',6575.00,0.00,'Payment Id 364642 for invoice:240622, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:24:04','',''),('5','92',4108215,'','supplier','100',0.00,6575.00,'Payment Id 364642 for invoice:240622, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:24:04','',''),('5','92',4108224,'','2','2220',1610940.00,0.00,'Payment Id 364640 for invoice:240622, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:24:21','',''),('5','92',4108225,'','supplier','100',0.00,1610940.00,'Payment Id 364640 for invoice:240622, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:24:21','',''),('5','92',4108238,'','2','2220',811010.00,0.00,'Payment Id 365299 for invoice:240810, receipt: 0010 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:24:37','',''),('5','92',4108239,'','supplier','100',0.00,811010.00,'Payment Id 365299 for invoice:240810, receipt: 0010 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:24:37','',''),('5','92',4108240,'','6.1','2221',11575.00,0.00,'Payment Id 365301 for invoice:240810, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:24:52','',''),('5','92',4108241,'','supplier','100',0.00,11575.00,'Payment Id 365301 for invoice:240810, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:24:52','',''),('5','92',4108246,'','2','2220',293350.00,0.00,'Payment Id 365840 for invoice:241179, receipt: 017862 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:25:15','',''),('5','92',4108247,'','supplier','100',0.00,293350.00,'Payment Id 365840 for invoice:241179, receipt: 017862 by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:25:15','',''),('5','92',4108254,'','6.1','2221',6575.00,0.00,'Payment Id 365842 for invoice:241179, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:25:34','',''),('5','92',4108255,'','supplier','100',0.00,6575.00,'Payment Id 365842 for invoice:241179, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2021-11-29 14:25:34','',''),('5','92',4118316,'','20','2222',0.00,0.00,'Sales from shift 242607 on 2021-11-30 11:06:41 ','2021-11-30 11:06:41','',''),('5','92',4118317,'','6.1','2221',0.00,0.00,'Sales from shift 242607 on 2021-11-30 11:06:41 ','2021-11-30 11:06:41','',''),('5','92',4119187,'','20','2222',0.00,0.00,'Sales from shift 242786 on 2021-11-30 12:03:03 ','2021-11-30 12:03:03','',''),('5','92',4119188,'','6.1','2221',0.00,0.00,'Sales from shift 242786 on 2021-11-30 12:03:03 ','2021-11-30 12:03:03','',''),('5','92',4119266,'','20','2222',0.00,0.00,'Sales from shift 242792 on 2021-11-30 12:09:07 ','2021-11-30 12:09:07','',''),('5','92',4119267,'','6.1','2221',0.00,0.00,'Sales from shift 242792 on 2021-11-30 12:09:07 ','2021-11-30 12:09:07','',''),('5','92',4119381,'','20','2222',0.00,0.00,'Sales from shift 242794 on 2021-11-30 12:15:58 ','2021-11-30 12:15:58','',''),('5','92',4119382,'','6.1','2221',0.00,0.00,'Sales from shift 242794 on 2021-11-30 12:15:58 ','2021-11-30 12:15:58','',''),('5','92',4119546,'','20','2222',0.00,0.00,'Sales from shift 242795 on 2021-11-30 12:27:11 ','2021-11-30 12:27:11','',''),('5','92',4119547,'','6.1','2221',0.00,0.00,'Sales from shift 242795 on 2021-11-30 12:27:11 ','2021-11-30 12:27:11','',''),('5','92',4148318,'','20','2222',0.00,0.00,'Sales from shift 242808 on 2021-12-02 14:11:57 ','2021-12-02 14:11:57','',''),('5','92',4148319,'','6.1','2221',0.00,0.00,'Sales from shift 242808 on 2021-12-02 14:11:57 ','2021-12-02 14:11:57','',''),('5','92',4148370,'','20','2222',0.00,0.00,'Sales from shift 243275 on 2021-12-02 14:15:35 ','2021-12-02 14:15:35','',''),('5','92',4148371,'','6.1','2221',0.00,0.00,'Sales from shift 243275 on 2021-12-02 14:15:35 ','2021-12-02 14:15:35','',''),('5','92',4159025,'','20','2222',0.00,0.00,'Sales from shift 243293 on 2021-12-03 10:54:44 ','2021-12-03 10:54:44','',''),('5','92',4159026,'','6.1','2221',0.00,0.00,'Sales from shift 243293 on 2021-12-03 10:54:44 ','2021-12-03 10:54:44','',''),('5','92',4179220,'','20','2222',0.00,0.00,'Sales from shift 243537 on 2021-12-04 19:42:51 ','2021-12-04 19:42:51','',''),('5','92',4179221,'','6.1','2221',0.00,0.00,'Sales from shift 243537 on 2021-12-04 19:42:51 ','2021-12-04 19:42:51','',''),('5','92',4194012,'','20','2222',0.00,0.00,'Sales from shift 244012 on 2021-12-06 08:47:11 ','2021-12-06 08:47:11','',''),('5','92',4194013,'','6.1','2221',0.00,0.00,'Sales from shift 244012 on 2021-12-06 08:47:11 ','2021-12-06 08:47:11','',''),('5','92',4218674,'','20','2222',0.00,0.00,'Sales from shift 244235 on 2021-12-07 17:05:36 ','2021-12-07 17:05:36','',''),('5','92',4218675,'','6.1','2221',0.00,0.00,'Sales from shift 244235 on 2021-12-07 17:05:36 ','2021-12-07 17:05:36','',''),('5','92',4231839,'','20','2222',0.00,0.00,'Sales from shift 244455 on 2021-12-08 20:55:14 ','2021-12-08 20:55:14','',''),('5','92',4231840,'','6.1','2221',0.00,0.00,'Sales from shift 244455 on 2021-12-08 20:55:14 ','2021-12-08 20:55:14','',''),('5','92',4272217,'','20','2222',0.00,0.00,'Sales from shift 245149 on 2021-12-11 18:18:29 ','2021-12-11 18:18:29','',''),('5','92',4272218,'','6.1','2221',0.00,0.00,'Sales from shift 245149 on 2021-12-11 18:18:29 ','2021-12-11 18:18:29','',''),('5','92',4272233,'','20','2222',0.00,0.00,'Sales from shift 245384 on 2021-12-11 18:21:05 ','2021-12-11 18:21:05','',''),('5','92',4272234,'','6.1','2221',0.00,0.00,'Sales from shift 245384 on 2021-12-11 18:21:05 ','2021-12-11 18:21:05','',''),('5','92',4272323,'','20','2222',0.00,0.00,'Sales from shift 245386 on 2021-12-11 18:36:58 ','2021-12-11 18:36:58','',''),('5','92',4272324,'','6.1','2221',0.00,0.00,'Sales from shift 245386 on 2021-12-11 18:36:58 ','2021-12-11 18:36:58','',''),('5','92',4272343,'','20','2222',0.00,0.00,'Sales from shift 245387 on 2021-12-11 18:39:19 ','2021-12-11 18:39:19','',''),('5','92',4272344,'','6.1','2221',0.00,0.00,'Sales from shift 245387 on 2021-12-11 18:39:19 ','2021-12-11 18:39:19','',''),('5','92',4272359,'','20','2222',0.00,0.00,'Sales from shift 245389 on 2021-12-11 18:41:44 ','2021-12-11 18:41:44','',''),('5','92',4272360,'','6.1','2221',0.00,0.00,'Sales from shift 245389 on 2021-12-11 18:41:44 ','2021-12-11 18:41:44','',''),('5','92',4284785,'','20','2222',0.00,0.00,'Sales from shift 245608 on 2021-12-12 21:20:25 ','2021-12-12 21:20:25','',''),('5','92',4284786,'','6.1','2221',0.00,0.00,'Sales from shift 245608 on 2021-12-12 21:20:25 ','2021-12-12 21:20:25','',''),('5','92',4300545,'','20','2222',0.00,0.00,'Sales from shift 245876 on 2021-12-14 08:37:59 ','2021-12-14 08:37:59','',''),('5','92',4300546,'','6.1','2221',0.00,0.00,'Sales from shift 245876 on 2021-12-14 08:37:59 ','2021-12-14 08:37:59','',''),('5','92',4309975,'','20','2222',0.00,0.00,'Sales from shift 246124 on 2021-12-14 22:17:04 ','2021-12-14 22:17:04','',''),('5','92',4309976,'','6.1','2221',0.00,0.00,'Sales from shift 246124 on 2021-12-14 22:17:04 ','2021-12-14 22:17:04','',''),('5','92',4327822,'','20','2222',0.00,0.00,'Sales from shift 246393 on 2021-12-16 09:03:26 ','2021-12-16 09:03:26','',''),('5','92',4327823,'','6.1','2221',0.00,0.00,'Sales from shift 246393 on 2021-12-16 09:03:26 ','2021-12-16 09:03:26','',''),('5','92',4350811,'','20','2222',0.00,0.00,'Sales from shift 246641 on 2021-12-17 16:45:17 ','2021-12-17 16:45:17','',''),('5','92',4350812,'','6.1','2221',0.00,0.00,'Sales from shift 246641 on 2021-12-17 16:45:17 ','2021-12-17 16:45:17','',''),('5','92',4367326,'','20','2222',0.00,0.00,'Sales from shift 246873 on 2021-12-18 17:39:10 ','2021-12-18 17:39:10','',''),('5','92',4367327,'','6.1','2221',0.00,0.00,'Sales from shift 246873 on 2021-12-18 17:39:10 ','2021-12-18 17:39:10','',''),('5','92',4382040,'','20','2222',0.00,0.00,'Sales from shift 247116 on 2021-12-19 18:41:40 ','2021-12-19 18:41:40','',''),('5','92',4382041,'','6.1','2221',0.00,0.00,'Sales from shift 247116 on 2021-12-19 18:41:40 ','2021-12-19 18:41:40','',''),('5','92',4384877,'','20','2222',0.00,0.00,'Sales from shift 247353 on 2021-12-20 09:14:00 ','2021-12-20 09:14:00','',''),('5','92',4384878,'','6.1','2221',0.00,0.00,'Sales from shift 247353 on 2021-12-20 09:14:00 ','2021-12-20 09:14:00','',''),('5','92',4406389,'','20','2222',0.00,0.00,'Sales from shift 247597 on 2021-12-21 15:46:45 ','2021-12-21 15:46:45','',''),('5','92',4406390,'','6.1','2221',0.00,0.00,'Sales from shift 247597 on 2021-12-21 15:46:45 ','2021-12-21 15:46:45','',''),('5','92',4409862,'','20','2222',0.00,0.00,'Sales from shift 247845 on 2021-12-21 21:08:04 ','2021-12-21 21:08:04','',''),('5','92',4409863,'','6.1','2221',0.00,0.00,'Sales from shift 247845 on 2021-12-21 21:08:04 ','2021-12-21 21:08:04','',''),('5','92',4467738,'','20','2222',0.00,0.00,'Sales from shift 248107 on 2021-12-25 13:01:38 ','2021-12-25 13:01:38','',''),('5','92',4467739,'','6.1','2221',0.00,0.00,'Sales from shift 248107 on 2021-12-25 13:01:38 ','2021-12-25 13:01:38','',''),('5','92',4480109,'','20','2222',0.00,0.00,'Sales from shift 249041 on 2021-12-26 17:55:59 ','2021-12-26 17:55:59','',''),('5','92',4480110,'','6.1','2221',0.00,0.00,'Sales from shift 249041 on 2021-12-26 17:55:59 ','2021-12-26 17:55:59','',''),('5','92',4480129,'','20','2222',0.00,0.00,'Sales from shift 249043 on 2021-12-26 18:01:34 ','2021-12-26 18:01:34','',''),('5','92',4480130,'','6.1','2221',0.00,0.00,'Sales from shift 249043 on 2021-12-26 18:01:34 ','2021-12-26 18:01:34','',''),('5','92',4480135,'','20','2222',0.00,0.00,'Sales from shift 249045 on 2021-12-26 18:04:00 ','2021-12-26 18:04:00','',''),('5','92',4480136,'','6.1','2221',0.00,0.00,'Sales from shift 249045 on 2021-12-26 18:04:00 ','2021-12-26 18:04:00','',''),('5','92',4480151,'','20','2222',0.00,0.00,'Sales from shift 249046 on 2021-12-26 18:06:11 ','2021-12-26 18:06:11','',''),('5','92',4480152,'','6.1','2221',0.00,0.00,'Sales from shift 249046 on 2021-12-26 18:06:11 ','2021-12-26 18:06:11','',''),('5','92',4506376,'','20','2222',0.00,0.00,'Sales from shift 249281 on 2021-12-29 10:09:58 ','2021-12-29 10:09:58','',''),('5','92',4506377,'','6.1','2221',0.00,0.00,'Sales from shift 249281 on 2021-12-29 10:09:58 ','2021-12-29 10:09:58','',''),('5','92',4529288,'','20','2222',0.00,0.00,'Sales from shift 249782 on 2021-12-30 18:28:37 ','2021-12-30 18:28:37','',''),('5','92',4529289,'','6.1','2221',0.00,0.00,'Sales from shift 249782 on 2021-12-30 18:28:37 ','2021-12-30 18:28:37','',''),('5','92',4529410,'','20','2222',0.00,0.00,'Sales from shift 250055 on 2021-12-30 20:01:27 ','2021-12-30 20:01:27','',''),('5','92',4529411,'','6.1','2221',0.00,0.00,'Sales from shift 250055 on 2021-12-30 20:01:27 ','2021-12-30 20:01:27','',''),('5','92',4529412,'','24','2219',0.00,3597000.00,'Purchase Id 88498 for 21,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-12-30 20:03:24','',''),('5','92',4529413,'','supplier','100',3597000.00,0.00,'Purchase Id 88498 for 21,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-12-30 20:03:24','',''),('5','92',4529487,'','supplier','100',0.00,3597000.00,'Purchase Id 88498 for 21,800.00 litters of Petrol - PMS returned to SALBAS OIL & GAS NIGERIA LIMIT','2021-12-30 20:42:07','',''),('5','92',4529514,'','24','2219',0.00,3679500.00,'Purchase Id 88508 for 22,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-12-30 20:53:41','',''),('5','92',4529515,'','supplier','100',3679500.00,0.00,'Purchase Id 88508 for 22,300.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2021-12-30 20:53:41','',''),('5','92',4542779,'','20','2222',128700.00,0.00,'Sales from shift 250075 on 2021-12-31 20:47:42 ','2021-12-31 20:47:42','',''),('5','92',4542780,'','6.1','2221',0.00,128700.00,'Sales from shift 250075 on 2021-12-31 20:47:42 ','2021-12-31 20:47:42','',''),('5','92',4556935,'','20','2222',920945.85,0.00,'Sales from shift 250304 on 2022-01-02 10:13:28 ','2022-01-02 10:13:28','',''),('5','92',4556936,'','6.1','2221',0.00,920945.85,'Sales from shift 250304 on 2022-01-02 10:13:28 ','2022-01-02 10:13:28','',''),('5','92',4560832,'','20','2222',901162.35,0.00,'Sales from shift 250644 on 2022-01-02 14:17:00 ','2022-01-02 14:17:00','',''),('5','92',4560833,'','6.1','2221',0.00,901162.35,'Sales from shift 250644 on 2022-01-02 14:17:00 ','2022-01-02 14:17:00','',''),('5','92',4574008,'','20','2222',1326893.70,0.00,'Sales from shift 250735 on 2022-01-03 16:53:03 ','2022-01-03 16:53:03','',''),('5','92',4574009,'','6.1','2221',0.00,1326893.70,'Sales from shift 250735 on 2022-01-03 16:53:03 ','2022-01-03 16:53:03','',''),('5','92',4584076,'','20','2222',467492.85,0.00,'Sales from shift 250953 on 2022-01-04 13:53:30 ','2022-01-04 13:53:30','',''),('5','92',4584077,'','6.1','2221',0.00,467492.85,'Sales from shift 250953 on 2022-01-04 13:53:30 ','2022-01-04 13:53:30','',''),('5','92',4584109,'','24','2219',0.00,4950000.00,'Purchase Id 88761 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-01-04 13:54:43','',''),('5','92',4584110,'','supplier','100',4950000.00,0.00,'Purchase Id 88761 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-01-04 13:54:43','',''),('5','92',4593150,'','20','2222',2059358.40,0.00,'Sales from shift 251208 on 2022-01-05 10:46:12 ','2022-01-05 10:46:12','',''),('5','92',4593151,'','6.1','2221',0.00,2059358.40,'Sales from shift 251208 on 2022-01-05 10:46:12 ','2022-01-05 10:46:12','',''),('5','92',4616248,'','20','2222',1462058.40,0.00,'Sales from shift 251466 on 2022-01-06 18:16:01 ','2022-01-06 18:16:01','',''),('5','92',4616249,'','6.1','2221',0.00,1462058.40,'Sales from shift 251466 on 2022-01-06 18:16:01 ','2022-01-06 18:16:01','',''),('5','92',4622938,'','20','2222',1136643.75,0.00,'Sales from shift 251736 on 2022-01-07 12:26:11 ','2022-01-07 12:26:11','',''),('5','92',4622939,'','6.1','2221',0.00,1136643.75,'Sales from shift 251736 on 2022-01-07 12:26:11 ','2022-01-07 12:26:11','',''),('5','92',4623177,'','2','2220',122140.00,0.00,'Payment Id 385285 for invoice:250075, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:37:59','',''),('5','92',4623178,'','supplier','100',0.00,122140.00,'Payment Id 385285 for invoice:250075, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:37:59','',''),('5','92',4623200,'','6.1','2221',6575.00,0.00,'Payment Id 385288 for invoice:250075, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:39:02','',''),('5','92',4623201,'','supplier','100',0.00,6575.00,'Payment Id 385288 for invoice:250075, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:39:02','',''),('5','92',4623212,'','2','2220',915770.00,0.00,'Payment Id 387369 for invoice:250304, receipt: 0033 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:39:28','',''),('5','92',4623213,'','supplier','100',0.00,915770.00,'Payment Id 387369 for invoice:250304, receipt: 0033 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:39:28','',''),('5','92',4623226,'','6.1','2221',5175.00,0.00,'Payment Id 387373 for invoice:250304, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:40:08','',''),('5','92',4623227,'','supplier','100',0.00,5175.00,'Payment Id 387373 for invoice:250304, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:40:08','',''),('5','92',4623234,'','2','2220',893990.00,0.00,'Payment Id 387375 for invoice:250644, receipt: 0033 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:40:33','',''),('5','92',4623235,'','supplier','100',0.00,893990.00,'Payment Id 387375 for invoice:250644, receipt: 0033 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:40:33','',''),('5','92',4623245,'','6.1','2221',7175.00,0.00,'Payment Id 387377 for invoice:25064, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:41:01','',''),('5','92',4623246,'','supplier','100',0.00,7175.00,'Payment Id 387377 for invoice:25064, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:41:01','',''),('5','92',4623260,'','2','2220',1163220.00,0.00,'Payment Id 387380 for invoice:250735, receipt: 0033 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:41:42','',''),('5','92',4623261,'','supplier','100',0.00,1163220.00,'Payment Id 387380 for invoice:250735, receipt: 0033 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:41:42','',''),('5','92',4623275,'','6.1','2221',163675.00,0.00,'Payment Id 387381 for invoice:250735, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:42:22','',''),('5','92',4623276,'','supplier','100',0.00,163675.00,'Payment Id 387381 for invoice:250735, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:42:22','',''),('5','92',4623302,'','2','2220',27220.00,0.00,'Payment Id 387383 for invoice:250953, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:43:46','',''),('5','92',4623303,'','supplier','100',0.00,27220.00,'Payment Id 387383 for invoice:250953, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:43:46','',''),('5','92',4623323,'','6.1','2221',18275.00,0.00,'Payment Id 387384 for invoice:250953, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:44:19','',''),('5','92',4623324,'','supplier','100',0.00,18275.00,'Payment Id 387384 for invoice:250953, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:44:19','',''),('5','92',4623345,'','2','2220',1837785.00,0.00,'Payment Id 387782 for invoice:251208, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:45:11','',''),('5','92',4623346,'','supplier','100',0.00,1837785.00,'Payment Id 387782 for invoice:251208, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:45:11','',''),('5','92',4623353,'','6.1','2221',221575.00,0.00,'Payment Id 387785 for invoice:251208, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:45:36','',''),('5','92',4623354,'','supplier','100',0.00,221575.00,'Payment Id 387785 for invoice:251208, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:45:36','',''),('5','92',4623364,'','2','2220',1455485.00,0.00,'Payment Id 388458 for invoice:251466, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:45:58','',''),('5','92',4623365,'','supplier','100',0.00,1455485.00,'Payment Id 388458 for invoice:251466, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:45:58','',''),('5','92',4623386,'','6.1','2221',6575.00,0.00,'Payment Id 388463 for invoice:251466, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:47:14','',''),('5','92',4623387,'','supplier','100',0.00,6575.00,'Payment Id 388463 for invoice:251466, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:47:14','',''),('5','92',4623394,'','2','2220',915070.00,0.00,'Payment Id 388928 for invoice:251736, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:47:37','',''),('5','92',4623395,'','supplier','100',0.00,915070.00,'Payment Id 388928 for invoice:251736, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:47:37','',''),('5','92',4623400,'','6.1','2221',221575.00,0.00,'Payment Id 388930 for invoice:251736, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:47:58','',''),('5','92',4623401,'','supplier','100',0.00,221575.00,'Payment Id 388930 for invoice:251736, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-07 12:47:58','',''),('5','92',4643657,'','20','2222',239641.05,0.00,'Sales from shift 251950 on 2022-01-08 19:02:29 ','2022-01-08 19:02:29','',''),('5','92',4643658,'','6.1','2221',0.00,239641.05,'Sales from shift 251950 on 2022-01-08 19:02:29 ','2022-01-08 19:02:29','',''),('5','92',4679529,'','20','2222',0.00,0.00,'Sales from shift 252190 on 2022-01-11 14:32:48 ','2022-01-11 14:32:48','',''),('5','92',4679530,'','6.1','2221',0.00,0.00,'Sales from shift 252190 on 2022-01-11 14:32:48 ','2022-01-11 14:32:48','',''),('5','92',4700364,'','20','2222',0.00,0.00,'Sales from shift 253144 on 2022-01-12 19:55:02 ','2022-01-12 19:55:02','',''),('5','92',4700365,'','6.1','2221',0.00,0.00,'Sales from shift 253144 on 2022-01-12 19:55:02 ','2022-01-12 19:55:02','',''),('5','92',4700433,'','2','2220',422000.00,0.00,'Payment Id 387866 for invoice:250953, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-12 20:08:38','',''),('5','92',4700434,'','supplier','100',0.00,422000.00,'Payment Id 387866 for invoice:250953, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-12 20:08:38','',''),('5','92',4700460,'','20','2222',0.00,0.00,'Sales from shift 253158 on 2022-01-12 20:18:10 ','2022-01-12 20:18:10','',''),('5','92',4700461,'','6.1','2221',0.00,0.00,'Sales from shift 253158 on 2022-01-12 20:18:10 ','2022-01-12 20:18:10','',''),('5','92',4700467,'','20','2222',0.00,0.00,'Sales from shift 253159 on 2022-01-12 20:23:34 ','2022-01-12 20:23:34','',''),('5','92',4700468,'','6.1','2221',0.00,0.00,'Sales from shift 253159 on 2022-01-12 20:23:34 ','2022-01-12 20:23:34','',''),('5','92',4700469,'','20','2222',0.00,0.00,'Sales from shift 253160 on 2022-01-12 20:25:53 ','2022-01-12 20:25:53','',''),('5','92',4700470,'','6.1','2221',0.00,0.00,'Sales from shift 253160 on 2022-01-12 20:25:53 ','2022-01-12 20:25:53','',''),('5','92',4702743,'','2','2220',233065.00,0.00,'Payment Id 392011 for invoice:251950, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-13 09:24:09','',''),('5','92',4702744,'','supplier','100',0.00,233065.00,'Payment Id 392011 for invoice:251950, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-13 09:24:09','',''),('5','92',4702749,'','6.1','2221',6575.00,0.00,'Payment Id 392013 for invoice:253160, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-13 09:24:32','',''),('5','92',4702750,'','supplier','100',0.00,6575.00,'Payment Id 392013 for invoice:253160, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-01-13 09:24:32','',''),('5','92',4714179,'','20','2222',0.00,0.00,'Sales from shift 253301 on 2022-01-13 22:53:09 ','2022-01-13 22:53:09','',''),('5','92',4714180,'','6.1','2221',0.00,0.00,'Sales from shift 253301 on 2022-01-13 22:53:09 ','2022-01-13 22:53:09','',''),('5','92',4730545,'','20','2222',0.00,0.00,'Sales from shift 253655 on 2022-01-15 09:35:53 ','2022-01-15 09:35:53','',''),('5','92',4730546,'','6.1','2221',0.00,0.00,'Sales from shift 253655 on 2022-01-15 09:35:53 ','2022-01-15 09:35:53','',''),('5','92',4747770,'','20','2222',0.00,0.00,'Sales from shift 253910 on 2022-01-16 10:47:22 ','2022-01-16 10:47:22','',''),('5','92',4747771,'','6.1','2221',0.00,0.00,'Sales from shift 253910 on 2022-01-16 10:47:22 ','2022-01-16 10:47:22','',''),('5','92',4760089,'','20','2222',0.00,0.00,'Sales from shift 254134 on 2022-01-17 09:58:20 ','2022-01-17 09:58:20','',''),('5','92',4760090,'','6.1','2221',0.00,0.00,'Sales from shift 254134 on 2022-01-17 09:58:20 ','2022-01-17 09:58:20','',''),('5','92',4780913,'','20','2222',0.00,0.00,'Sales from shift 254391 on 2022-01-18 15:53:09 ','2022-01-18 15:53:09','',''),('5','92',4780914,'','6.1','2221',0.00,0.00,'Sales from shift 254391 on 2022-01-18 15:53:09 ','2022-01-18 15:53:09','',''),('5','92',4788482,'','20','2222',0.00,0.00,'Sales from shift 254641 on 2022-01-19 10:03:01 ','2022-01-19 10:03:01','',''),('5','92',4788483,'','6.1','2221',0.00,0.00,'Sales from shift 254641 on 2022-01-19 10:03:01 ','2022-01-19 10:03:01','',''),('5','92',4800847,'','20','2222',0.00,0.00,'Sales from shift 254890 on 2022-01-20 07:17:45 ','2022-01-20 07:17:45','',''),('5','92',4800848,'','6.1','2221',0.00,0.00,'Sales from shift 254890 on 2022-01-20 07:17:45 ','2022-01-20 07:17:45','',''),('5','92',4820501,'','20','2222',0.00,0.00,'Sales from shift 255127 on 2022-01-21 11:17:40 ','2022-01-21 11:17:40','',''),('5','92',4820502,'','6.1','2221',0.00,0.00,'Sales from shift 255127 on 2022-01-21 11:17:40 ','2022-01-21 11:17:40','',''),('5','92',4846772,'','20','2222',0.00,0.00,'Sales from shift 255390 on 2022-01-22 22:10:12 ','2022-01-22 22:10:12','',''),('5','92',4846773,'','6.1','2221',0.00,0.00,'Sales from shift 255390 on 2022-01-22 22:10:12 ','2022-01-22 22:10:12','',''),('5','92',4860343,'','20','2222',0.00,0.00,'Sales from shift 255826 on 2022-01-24 04:02:01 ','2022-01-24 04:02:01','',''),('5','92',4860344,'','6.1','2221',0.00,0.00,'Sales from shift 255826 on 2022-01-24 04:02:01 ','2022-01-24 04:02:01','',''),('5','92',4873641,'','20','2222',0.00,0.00,'Sales from shift 256129 on 2022-01-24 21:17:05 ','2022-01-24 21:17:05','',''),('5','92',4873642,'','6.1','2221',0.00,0.00,'Sales from shift 256129 on 2022-01-24 21:17:05 ','2022-01-24 21:17:05','',''),('5','92',4893761,'','20','2222',0.00,0.00,'Sales from shift 256419 on 2022-01-26 10:16:30 ','2022-01-26 10:16:30','',''),('5','92',4893762,'','6.1','2221',0.00,0.00,'Sales from shift 256419 on 2022-01-26 10:16:30 ','2022-01-26 10:16:30','',''),('5','92',4918941,'','20','2222',0.00,0.00,'Sales from shift 256671 on 2022-01-27 19:00:45 ','2022-01-27 19:00:45','',''),('5','92',4918942,'','6.1','2221',0.00,0.00,'Sales from shift 256671 on 2022-01-27 19:00:45 ','2022-01-27 19:00:45','',''),('5','92',4935230,'','20','2222',0.00,0.00,'Sales from shift 256904 on 2022-01-28 22:07:52 ','2022-01-28 22:07:52','',''),('5','92',4935231,'','6.1','2221',0.00,0.00,'Sales from shift 256904 on 2022-01-28 22:07:52 ','2022-01-28 22:07:52','',''),('5','92',4959948,'','20','2222',0.00,0.00,'Sales from shift 257465 on 2022-01-30 13:01:02 ','2022-01-30 13:01:02','',''),('5','92',4959949,'','6.1','2221',0.00,0.00,'Sales from shift 257465 on 2022-01-30 13:01:02 ','2022-01-30 13:01:02','',''),('5','92',4959950,'','20','2222',0.00,0.00,'Sales from shift 257467 on 2022-01-31 11:56:31 ','2022-01-31 11:56:31','',''),('5','92',4959951,'','6.1','2221',0.00,0.00,'Sales from shift 257467 on 2022-01-31 11:56:31 ','2022-01-31 11:56:31','',''),('5','92',4959952,'','20','2222',0.00,0.00,'Sales from shift 257468 on 2022-01-31 11:57:38 ','2022-01-31 11:57:38','',''),('5','92',4959953,'','6.1','2221',0.00,0.00,'Sales from shift 257468 on 2022-01-31 11:57:38 ','2022-01-31 11:57:38','',''),('5','92',4959954,'','20','2222',0.00,0.00,'Sales from shift 257469 on 2022-01-31 22:15:12 ','2022-01-31 22:15:12','',''),('5','92',4959955,'','6.1','2221',0.00,0.00,'Sales from shift 257469 on 2022-01-31 22:15:12 ','2022-01-31 22:15:12','',''),('5','92',4959956,'','20','2222',0.00,0.00,'Sales from shift 257470 on 2022-02-07 21:45:18 ','2022-02-07 21:45:18','',''),('5','92',4959957,'','6.1','2221',0.00,0.00,'Sales from shift 257470 on 2022-02-07 21:45:18 ','2022-02-07 21:45:18','',''),('5','92',4959958,'','20','2222',0.00,0.00,'Sales from shift 257471 on 2022-02-08 10:35:35 ','2022-02-08 10:35:35','',''),('5','92',4959959,'','6.1','2221',0.00,0.00,'Sales from shift 257471 on 2022-02-08 10:35:35 ','2022-02-08 10:35:35','',''),('5','92',4959960,'','24','2219',0.00,4933500.00,'Purchase Id 88762 for 29,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 10:58:44','',''),('5','92',4959961,'','supplier','100',4933500.00,0.00,'Purchase Id 88762 for 29,900.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 10:58:44','',''),('5','92',4959962,'','20','2222',1084239.75,0.00,'Sales from shift 257472 on 2022-02-08 11:39:48 ','2022-02-08 11:39:48','',''),('5','92',4959963,'','6.1','2221',0.00,1084239.75,'Sales from shift 257472 on 2022-02-08 11:39:48 ','2022-02-08 11:39:48','',''),('5','92',4959964,'','20','2222',1217931.00,0.00,'Sales from shift 257473 on 2022-02-08 11:42:51 ','2022-02-08 11:42:51','',''),('5','92',4959965,'','6.1','2221',0.00,1217931.00,'Sales from shift 257473 on 2022-02-08 11:42:51 ','2022-02-08 11:42:51','',''),('5','92',4959966,'','20','2222',742650.15,0.00,'Sales from shift 257474 on 2022-02-08 11:46:15 ','2022-02-08 11:46:15','',''),('5','92',4959967,'','6.1','2221',0.00,742650.15,'Sales from shift 257474 on 2022-02-08 11:46:15 ','2022-02-08 11:46:15','',''),('5','92',4959968,'','20','2222',1725499.05,0.00,'Sales from shift 257475 on 2022-02-08 11:49:51 ','2022-02-08 11:49:51','',''),('5','92',4959969,'','6.1','2221',0.00,1725499.05,'Sales from shift 257475 on 2022-02-08 11:49:51 ','2022-02-08 11:49:51','',''),('5','92',4959970,'','20','2222',189075.15,0.00,'Sales from shift 257476 on 2022-02-08 11:54:34 ','2022-02-08 11:54:34','',''),('5','92',4959971,'','6.1','2221',0.00,189075.15,'Sales from shift 257476 on 2022-02-08 11:54:34 ','2022-02-08 11:54:34','',''),('5','92',4959972,'','2','2220',1043665.00,0.00,'Payment Id 392014 for invoice:257472, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 12:28:18','',''),('5','92',4959973,'','supplier','100',0.00,1043665.00,'Payment Id 392014 for invoice:257472, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 12:28:18','',''),('5','92',4959974,'','6.1','2221',40575.00,0.00,'Payment Id 392015 for invoice:257472, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 12:28:55','',''),('5','92',4959975,'','supplier','100',0.00,40575.00,'Payment Id 392015 for invoice:257472, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 12:28:55','',''),('5','92',4959976,'','2','2220',1211055.00,0.00,'Payment Id 392018 for invoice:257473, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:24:58','',''),('5','92',4959977,'','supplier','100',0.00,1211055.00,'Payment Id 392018 for invoice:257473, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:24:58','',''),('5','92',4959978,'','6.1','2221',6875.00,0.00,'Payment Id 392019 for invoice:257473, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:25:16','',''),('5','92',4959979,'','supplier','100',0.00,6875.00,'Payment Id 392019 for invoice:257473, receipt: 0036 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:25:16','',''),('5','92',4959980,'','2','2220',735400.00,0.00,'Payment Id 392020 for invoice:257474, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:25:37','',''),('5','92',4959981,'','supplier','100',0.00,735400.00,'Payment Id 392020 for invoice:257474, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:25:37','',''),('5','92',4959982,'','6.1','2221',7250.00,0.00,'Payment Id 392021 for invoice:257474, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:26:00','',''),('5','92',4959983,'','supplier','100',0.00,7250.00,'Payment Id 392021 for invoice:257474, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:26:00','',''),('5','92',4959984,'','2','2220',1718250.00,0.00,'Payment Id 392022 for invoice:257474, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:26:21','',''),('5','92',4959985,'','supplier','100',0.00,1718250.00,'Payment Id 392022 for invoice:257474, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:26:21','',''),('5','92',4959986,'','6.1','2221',7250.00,0.00,'Payment Id 392023 for invoice:257474, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:28:44','',''),('5','92',4959987,'','supplier','100',0.00,7250.00,'Payment Id 392023 for invoice:257474, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-08 14:28:44','',''),('5','92',4959988,'','20','2222',0.00,0.00,'Sales from shift 257477 on 2022-02-09 13:00:21 ','2022-02-09 13:00:21','',''),('5','92',4959989,'','6.1','2221',0.00,0.00,'Sales from shift 257477 on 2022-02-09 13:00:21 ','2022-02-09 13:00:21','',''),('5','92',4959990,'','20','2222',0.00,0.00,'Sales from shift 257478 on 2022-02-10 20:27:48 ','2022-02-10 20:27:48','',''),('5','92',4959991,'','6.1','2221',0.00,0.00,'Sales from shift 257478 on 2022-02-10 20:27:48 ','2022-02-10 20:27:48','',''),('5','92',4959992,'','20','2222',0.00,0.00,'Sales from shift 257479 on 2022-02-11 11:25:29 ','2022-02-11 11:25:29','',''),('5','92',4959993,'','6.1','2221',0.00,0.00,'Sales from shift 257479 on 2022-02-11 11:25:29 ','2022-02-11 11:25:29','',''),('5','92',4959994,'','20','2222',0.00,0.00,'Sales from shift 257480 on 2022-02-12 21:26:06 ','2022-02-12 21:26:06','',''),('5','92',4959995,'','6.1','2221',0.00,0.00,'Sales from shift 257480 on 2022-02-12 21:26:06 ','2022-02-12 21:26:06','',''),('5','92',4959996,'','20','2222',0.00,0.00,'Sales from shift 257481 on 2022-02-13 21:03:57 ','2022-02-13 21:03:57','',''),('5','92',4959997,'','6.1','2221',0.00,0.00,'Sales from shift 257481 on 2022-02-13 21:03:57 ','2022-02-13 21:03:57','',''),('5','92',4959998,'','20','2222',0.00,0.00,'Sales from shift 257482 on 2022-02-14 22:30:38 ','2022-02-14 22:30:38','',''),('5','92',4959999,'','6.1','2221',0.00,0.00,'Sales from shift 257482 on 2022-02-14 22:30:38 ','2022-02-14 22:30:38','',''),('5','92',4960000,'','20','2222',0.00,0.00,'Sales from shift 257483 on 2022-02-15 07:05:23 ','2022-02-15 07:05:23','',''),('5','92',4960001,'','6.1','2221',0.00,0.00,'Sales from shift 257483 on 2022-02-15 07:05:23 ','2022-02-15 07:05:23','',''),('5','92',4960002,'','20','2222',0.00,0.00,'Sales from shift 257484 on 2022-02-16 09:52:18 ','2022-02-16 09:52:18','',''),('5','92',4960003,'','6.1','2221',0.00,0.00,'Sales from shift 257484 on 2022-02-16 09:52:18 ','2022-02-16 09:52:18','',''),('5','92',4960004,'','20','2222',0.00,0.00,'Sales from shift 257485 on 2022-02-17 17:52:53 ','2022-02-17 17:52:53','',''),('5','92',4960005,'','6.1','2221',0.00,0.00,'Sales from shift 257485 on 2022-02-17 17:52:53 ','2022-02-17 17:52:53','',''),('5','92',4960006,'','20','2222',0.00,0.00,'Sales from shift 257486 on 2022-02-18 11:57:21 ','2022-02-18 11:57:21','',''),('5','92',4960007,'','6.1','2221',0.00,0.00,'Sales from shift 257486 on 2022-02-18 11:57:21 ','2022-02-18 11:57:21','',''),('5','92',4960008,'','2','2220',90448.61,0.00,'Payment Id 392024 for invoice:257486, receipt: 2780 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-18 14:38:55','',''),('5','92',4960009,'','supplier','100',0.00,90448.61,'Payment Id 392024 for invoice:257486, receipt: 2780 by SALBAS OIL & GAS NIGERIA LIMIT','2022-02-18 14:38:55','',''),('5','92',4960010,'','20','2222',0.00,0.00,'Sales from shift 257487 on 2022-02-19 22:51:03 ','2022-02-19 22:51:03','',''),('5','92',4960011,'','6.1','2221',0.00,0.00,'Sales from shift 257487 on 2022-02-19 22:51:03 ','2022-02-19 22:51:03','',''),('5','92',4960012,'','20','2222',0.00,0.00,'Sales from shift 257488 on 2022-02-20 09:20:45 ','2022-02-20 09:20:45','',''),('5','92',4960013,'','6.1','2221',0.00,0.00,'Sales from shift 257488 on 2022-02-20 09:20:45 ','2022-02-20 09:20:45','',''),('5','92',4960014,'','24','2219',0.00,4422000.00,'Purchase Id 88763 for 26,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-02-20 22:11:04','',''),('5','92',4960015,'','supplier','100',4422000.00,0.00,'Purchase Id 88763 for 26,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-02-20 22:11:04','',''),('5','92',4960016,'','20','2222',1789222.05,0.00,'Sales from shift 257489 on 2022-02-21 20:30:26 ','2022-02-21 20:30:26','',''),('5','92',4960017,'','6.1','2221',0.00,1789222.05,'Sales from shift 257489 on 2022-02-21 20:30:26 ','2022-02-21 20:30:26','',''),('5','92',4960018,'','20','2222',1555096.95,0.00,'Sales from shift 257490 on 2022-02-22 07:23:19 ','2022-02-22 07:23:19','',''),('5','92',4960019,'','6.1','2221',0.00,1555096.95,'Sales from shift 257490 on 2022-02-22 07:23:19 ','2022-02-22 07:23:19','',''),('5','92',4960020,'','20','2222',658402.80,0.00,'Sales from shift 257491 on 2022-02-23 10:23:13 ','2022-02-23 10:23:13','',''),('5','92',4960021,'','6.1','2221',0.00,658402.80,'Sales from shift 257491 on 2022-02-23 10:23:13 ','2022-02-23 10:23:13','',''),('5','92',4960022,'','20','2222',437769.75,0.00,'Sales from shift 257492 on 2022-02-25 23:21:06 ','2022-02-25 23:21:06','',''),('5','92',4960023,'','6.1','2221',0.00,437769.75,'Sales from shift 257492 on 2022-02-25 23:21:06 ','2022-02-25 23:21:06','',''),('5','92',4960024,'','20','2222',0.00,0.00,'Sales from shift 257493 on 2022-02-27 09:49:30 ','2022-02-27 09:49:30','',''),('5','92',4960025,'','6.1','2221',0.00,0.00,'Sales from shift 257493 on 2022-02-27 09:49:30 ','2022-02-27 09:49:30','',''),('5','92',4960026,'','20','2222',0.00,0.00,'Sales from shift 257494 on 2022-02-27 09:51:53 ','2022-02-27 09:51:53','',''),('5','92',4960027,'','6.1','2221',0.00,0.00,'Sales from shift 257494 on 2022-02-27 09:51:53 ','2022-02-27 09:51:53','',''),('5','92',4960028,'','24','2219',0.00,4950000.00,'Purchase Id 88764 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-02-27 09:56:08','',''),('5','92',4960029,'','supplier','100',4950000.00,0.00,'Purchase Id 88764 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-02-27 09:56:08','',''),('5','92',4960030,'','20','2222',853267.80,0.00,'Sales from shift 257495 on 2022-03-01 07:05:34 ','2022-03-01 07:05:34','',''),('5','92',4960031,'','6.1','2221',0.00,853267.80,'Sales from shift 257495 on 2022-03-01 07:05:34 ','2022-03-01 07:05:34','',''),('5','92',4960032,'','20','2222',2158039.95,0.00,'Sales from shift 257496 on 2022-03-01 11:55:45 ','2022-03-01 11:55:45','',''),('5','92',4960033,'','6.1','2221',0.00,2158039.95,'Sales from shift 257496 on 2022-03-01 11:55:45 ','2022-03-01 11:55:45','',''),('5','92',4960034,'','20','2222',966741.60,0.00,'Sales from shift 257497 on 2022-03-01 22:09:26 ','2022-03-01 22:09:26','',''),('5','92',4960035,'','6.1','2221',0.00,966741.60,'Sales from shift 257497 on 2022-03-01 22:09:26 ','2022-03-01 22:09:26','',''),('5','92',4960036,'','20','2222',1007757.30,0.00,'Sales from shift 257498 on 2022-03-02 09:42:25 ','2022-03-02 09:42:25','',''),('5','92',4960037,'','6.1','2221',0.00,1007757.30,'Sales from shift 257498 on 2022-03-02 09:42:25 ','2022-03-02 09:42:25','',''),('5','92',4960038,'','2','2220',60000.00,0.00,'Payment Id 392025 for invoice:257170, receipt: 0014 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:43:25','',''),('5','92',4960039,'','supplier','100',0.00,60000.00,'Payment Id 392025 for invoice:257170, receipt: 0014 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:43:25','',''),('5','92',4960040,'','2','2220',1761600.00,0.00,'Payment Id 392026 for invoice:25488, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:44:27','',''),('5','92',4960041,'','supplier','100',0.00,1761600.00,'Payment Id 392026 for invoice:25488, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:44:27','',''),('5','92',4960042,'','6.1','2221',27625.00,0.00,'Payment Id 392027 for invoice:257489, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:44:53','',''),('5','92',4960043,'','supplier','100',0.00,27625.00,'Payment Id 392027 for invoice:257489, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:44:53','',''),('5','92',4960044,'','2','2220',1547470.00,0.00,'Payment Id 392028 for invoice:257490, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:45:19','',''),('5','92',4960045,'','supplier','100',0.00,1547470.00,'Payment Id 392028 for invoice:257490, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:45:19','',''),('5','92',4960046,'','2','2220',650775.00,0.00,'Payment Id 392029 for invoice:257491, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:45:39','',''),('5','92',4960047,'','supplier','100',0.00,650775.00,'Payment Id 392029 for invoice:257491, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:45:39','',''),('5','92',4960048,'','2','2220',427655.00,0.00,'Payment Id 392030 for invoice:257492, receipt: 0009 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:46:50','',''),('5','92',4960049,'','supplier','100',0.00,427655.00,'Payment Id 392030 for invoice:257492, receipt: 0009 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:46:50','',''),('5','92',4960050,'','6.1','2221',10125.00,0.00,'Payment Id 392031 for invoice:257492, receipt: 0009 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:47:17','',''),('5','92',4960051,'','supplier','100',0.00,10125.00,'Payment Id 392031 for invoice:257492, receipt: 0009 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:47:17','',''),('5','92',4960052,'','2','2220',845640.00,0.00,'Payment Id 392032 for invoice:257495, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:50:34','',''),('5','92',4960053,'','supplier','100',0.00,845640.00,'Payment Id 392032 for invoice:257495, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:50:34','',''),('5','92',4960054,'','6.1','2221',7625.00,0.00,'Payment Id 392033 for invoice:257495, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:51:02','',''),('5','92',4960055,'','supplier','100',0.00,7625.00,'Payment Id 392033 for invoice:257495, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:51:02','',''),('5','92',4960056,'','2','2220',2150415.00,0.00,'Payment Id 392034 for invoice:257496, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:51:30','',''),('5','92',4960057,'','supplier','100',0.00,2150415.00,'Payment Id 392034 for invoice:257496, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:51:30','',''),('5','92',4960058,'','6.1','2221',7625.00,0.00,'Payment Id 392035 for invoice:257496, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:51:46','',''),('5','92',4960059,'','supplier','100',0.00,7625.00,'Payment Id 392035 for invoice:257496, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:51:46','',''),('5','92',4960060,'','2','2220',959115.00,0.00,'Payment Id 392036 for invoice:257497, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:52:12','',''),('5','92',4960061,'','supplier','100',0.00,959115.00,'Payment Id 392036 for invoice:257497, receipt:  by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-02 09:52:12','',''),('5','92',4960062,'','20','2222',0.00,0.00,'Sales from shift 257499 on 2022-03-03 21:28:18 ','2022-03-03 21:28:18','',''),('5','92',4960063,'','6.1','2221',0.00,0.00,'Sales from shift 257499 on 2022-03-03 21:28:18 ','2022-03-03 21:28:18','',''),('5','92',4960064,'','20','2222',0.00,0.00,'Sales from shift 257500 on 2022-03-08 10:18:47 ','2022-03-08 10:18:47','',''),('5','92',4960065,'','6.1','2221',0.00,0.00,'Sales from shift 257500 on 2022-03-08 10:18:47 ','2022-03-08 10:18:47','',''),('5','92',4960066,'','20','2222',0.00,0.00,'Sales from shift 257501 on 2022-03-08 13:41:01 ','2022-03-08 13:41:01','',''),('5','92',4960067,'','6.1','2221',0.00,0.00,'Sales from shift 257501 on 2022-03-08 13:41:01 ','2022-03-08 13:41:01','',''),('5','92',4960068,'','20','2222',0.00,0.00,'Sales from shift 257502 on 2022-03-08 13:46:12 ','2022-03-08 13:46:12','',''),('5','92',4960069,'','6.1','2221',0.00,0.00,'Sales from shift 257502 on 2022-03-08 13:46:12 ','2022-03-08 13:46:12','',''),('5','92',4960070,'','20','2222',0.00,0.00,'Sales from shift 257503 on 2022-03-08 13:49:34 ','2022-03-08 13:49:34','',''),('5','92',4960071,'','6.1','2221',0.00,0.00,'Sales from shift 257503 on 2022-03-08 13:49:34 ','2022-03-08 13:49:34','',''),('5','92',4960072,'','20','2222',0.00,0.00,'Sales from shift 257504 on 2022-03-08 13:51:43 ','2022-03-08 13:51:43','',''),('5','92',4960073,'','6.1','2221',0.00,0.00,'Sales from shift 257504 on 2022-03-08 13:51:43 ','2022-03-08 13:51:43','',''),('5','92',4960074,'','24','2219',0.00,7425000.00,'Purchase Id 88765 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-03-09 09:26:48','',''),('5','92',4960075,'','supplier','100',7425000.00,0.00,'Purchase Id 88765 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-03-09 09:26:48','',''),('5','92',4960076,'','6.1','2221',7625.00,0.00,'Payment Id 392037 for invoice:257497, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-09 09:39:32','',''),('5','92',4960077,'','supplier','100',0.00,7625.00,'Payment Id 392037 for invoice:257497, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-09 09:39:32','',''),('5','92',4960078,'','20','2222',1042946.85,0.00,'Sales from shift 257505 on 2022-03-10 15:37:59 ','2022-03-10 15:37:59','',''),('5','92',4960079,'','6.1','2221',0.00,1042946.85,'Sales from shift 257505 on 2022-03-10 15:37:59 ','2022-03-10 15:37:59','',''),('5','92',4960080,'','20','2222',1216307.40,0.00,'Sales from shift 257506 on 2022-03-10 15:43:22 ','2022-03-10 15:43:22','',''),('5','92',4960081,'','6.1','2221',0.00,1216307.40,'Sales from shift 257506 on 2022-03-10 15:43:22 ','2022-03-10 15:43:22','',''),('5','92',4960082,'','20','2222',1082624.40,0.00,'Sales from shift 257507 on 2022-03-12 10:26:58 ','2022-03-12 10:26:58','',''),('5','92',4960083,'','6.1','2221',0.00,1082624.40,'Sales from shift 257507 on 2022-03-12 10:26:58 ','2022-03-12 10:26:58','',''),('5','92',4960084,'','20','2222',1369221.15,0.00,'Sales from shift 257508 on 2022-03-12 21:42:14 ','2022-03-12 21:42:14','',''),('5','92',4960085,'','6.1','2221',0.00,1369221.15,'Sales from shift 257508 on 2022-03-12 21:42:14 ','2022-03-12 21:42:14','',''),('5','92',4960086,'','20','2222',1187447.25,0.00,'Sales from shift 257509 on 2022-03-12 22:36:27 ','2022-03-12 22:36:27','',''),('5','92',4960087,'','6.1','2221',0.00,1187447.25,'Sales from shift 257509 on 2022-03-12 22:36:27 ','2022-03-12 22:36:27','',''),('5','92',4960088,'','20','2222',1178375.55,0.00,'Sales from shift 257510 on 2022-03-13 23:25:39 ','2022-03-13 23:25:39','',''),('5','92',4960089,'','6.1','2221',0.00,1178375.55,'Sales from shift 257510 on 2022-03-13 23:25:39 ','2022-03-13 23:25:39','',''),('5','92',4960090,'','24','2219',0.00,247500.00,'Purchase Id 88766 for 1,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-03-14 17:14:48','',''),('5','92',4960091,'','supplier','100',247500.00,0.00,'Purchase Id 88766 for 1,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-03-14 17:14:48','',''),('5','92',4960092,'','20','2222',336623.10,0.00,'Sales from shift 257511 on 2022-03-15 10:58:59 ','2022-03-15 10:58:59','',''),('5','92',4960093,'','6.1','2221',0.00,336623.10,'Sales from shift 257511 on 2022-03-15 10:58:59 ','2022-03-15 10:58:59','',''),('5','92',4960094,'','24','2219',0.00,4422000.00,'Purchase Id 88767 for 26,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-03-15 20:48:09','',''),('5','92',4960095,'','supplier','100',4422000.00,0.00,'Purchase Id 88767 for 26,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-03-15 20:48:09','',''),('5','92',4960096,'','20','2222',895733.85,0.00,'Sales from shift 257512 on 2022-03-16 22:27:42 ','2022-03-16 22:27:42','',''),('5','92',4960097,'','6.1','2221',0.00,895733.85,'Sales from shift 257512 on 2022-03-16 22:27:42 ','2022-03-16 22:27:42','',''),('5','92',4960098,'','20','2222',1449086.10,0.00,'Sales from shift 257513 on 2022-03-17 22:06:41 ','2022-03-17 22:06:41','',''),('5','92',4960099,'','6.1','2221',0.00,1449086.10,'Sales from shift 257513 on 2022-03-17 22:06:41 ','2022-03-17 22:06:41','',''),('5','92',4960100,'','20','2222',1875233.25,0.00,'Sales from shift 257514 on 2022-03-19 22:50:51 ','2022-03-19 22:50:51','',''),('5','92',4960101,'','6.1','2221',0.00,1875233.25,'Sales from shift 257514 on 2022-03-19 22:50:51 ','2022-03-19 22:50:51','',''),('5','92',4960102,'','20','2222',232095.60,0.00,'Sales from shift 257515 on 2022-03-20 21:33:12 ','2022-03-20 21:33:12','',''),('5','92',4960103,'','6.1','2221',0.00,232095.60,'Sales from shift 257515 on 2022-03-20 21:33:12 ','2022-03-20 21:33:12','',''),('5','92',4960104,'','20','2222',0.00,0.00,'Sales from shift 257516 on 2022-03-20 21:36:02 ','2022-03-20 21:36:02','',''),('5','92',4960105,'','6.1','2221',0.00,0.00,'Sales from shift 257516 on 2022-03-20 21:36:02 ','2022-03-20 21:36:02','',''),('5','92',4960106,'','20','2222',0.00,0.00,'Sales from shift 257517 on 2022-03-20 21:43:23 ','2022-03-20 21:43:23','',''),('5','92',4960107,'','6.1','2221',0.00,0.00,'Sales from shift 257517 on 2022-03-20 21:43:23 ','2022-03-20 21:43:23','',''),('5','92',4960108,'','2','2220',743140.00,0.00,'Payment Id 392038 for invoice:257498, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:01:03','',''),('5','92',4960109,'','supplier','100',0.00,743140.00,'Payment Id 392038 for invoice:257498, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:01:03','',''),('5','92',4960110,'','6.1','2221',264625.00,0.00,'Payment Id 392039 for invoice:257498, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:01:44','',''),('5','92',4960111,'','supplier','100',0.00,264625.00,'Payment Id 392039 for invoice:257498, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:01:44','',''),('5','92',4960112,'','2','2220',1022340.00,0.00,'Payment Id 392040 for invoice:257505, receipt: 0007 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:02:16','',''),('5','92',4960113,'','supplier','100',0.00,1022340.00,'Payment Id 392040 for invoice:257505, receipt: 0007 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:02:16','',''),('5','92',4960114,'','6.1','2221',20600.00,0.00,'Payment Id 392041 for invoice:257505, receipt: 0007 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:02:33','',''),('5','92',4960115,'','supplier','100',0.00,20600.00,'Payment Id 392041 for invoice:257505, receipt: 0007 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:02:33','',''),('5','92',4960116,'','2','2220',1152910.00,0.00,'Payment Id 392042 for invoice:257506, receipt: 0017 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:03:02','',''),('5','92',4960117,'','supplier','100',0.00,1152910.00,'Payment Id 392042 for invoice:257506, receipt: 0017 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:03:02','',''),('5','92',4960118,'','2','2220',1358220.00,0.00,'Payment Id 392044 for invoice:257508, receipt: 0122478 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:04:40','',''),('5','92',4960119,'','supplier','100',0.00,1358220.00,'Payment Id 392044 for invoice:257508, receipt: 0122478 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:04:40','',''),('5','92',4960120,'','6.1','2221',11000.00,0.00,'Payment Id 392045 for invoice:257508, receipt: 1022478 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:05:04','',''),('5','92',4960121,'','supplier','100',0.00,11000.00,'Payment Id 392045 for invoice:257508, receipt: 1022478 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:05:04','',''),('5','92',4960122,'','2','2220',1176450.00,0.00,'Payment Id 392046 for invoice:257509, receipt: 0122630 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:05:49','',''),('5','92',4960123,'','supplier','100',0.00,1176450.00,'Payment Id 392046 for invoice:257509, receipt: 0122630 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:05:49','',''),('5','92',4960124,'','2','2220',1167375.00,0.00,'Payment Id 392048 for invoice:257510, receipt: 0121879 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:06:58','',''),('5','92',4960125,'','supplier','100',0.00,1167375.00,'Payment Id 392048 for invoice:257510, receipt: 0121879 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:06:58','',''),('5','92',4960126,'','6.1','2221',11000.00,0.00,'Payment Id 392049 for invoice:257510, receipt: 0121879 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:07:13','',''),('5','92',4960127,'','supplier','100',0.00,11000.00,'Payment Id 392049 for invoice:257510, receipt: 0121879 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-21 13:07:13','',''),('5','92',4960128,'','20','2222',0.00,0.00,'Sales from shift 257518 on 2022-03-22 15:46:21 ','2022-03-22 15:46:21','',''),('5','92',4960129,'','6.1','2221',0.00,0.00,'Sales from shift 257518 on 2022-03-22 15:46:21 ','2022-03-22 15:46:21','',''),('5','92',4960130,'','2','2220',325630.00,0.00,'Payment Id 392050 for invoice:257511, receipt: 0005 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:48:38','',''),('5','92',4960131,'','supplier','100',0.00,325630.00,'Payment Id 392050 for invoice:257511, receipt: 0005 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:48:38','',''),('5','92',4960132,'','6.1','2221',11000.00,0.00,'Payment Id 392051 for invoice:257511, receipt: 0005 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:49:09','',''),('5','92',4960133,'','supplier','100',0.00,11000.00,'Payment Id 392051 for invoice:257511, receipt: 0005 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:49:09','',''),('5','92',4960134,'','2','2220',881730.00,0.00,'Payment Id 392052 for invoice:257512, receipt: 0064 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:49:43','',''),('5','92',4960135,'','supplier','100',0.00,881730.00,'Payment Id 392052 for invoice:257512, receipt: 0064 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:49:43','',''),('5','92',4960136,'','6.1','2221',14000.00,0.00,'Payment Id 392053 for invoice:257512, receipt: 0064 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:50:07','',''),('5','92',4960137,'','supplier','100',0.00,14000.00,'Payment Id 392053 for invoice:257512, receipt: 0064 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:50:07','',''),('5','92',4960138,'','2','2220',1438175.00,0.00,'Payment Id 392054 for invoice:257513, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:50:29','',''),('5','92',4960139,'','supplier','100',0.00,1438175.00,'Payment Id 392054 for invoice:257513, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:50:29','',''),('5','92',4960140,'','6.1','2221',11000.00,0.00,'Payment Id 392055 for invoice:257513, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:50:45','',''),('5','92',4960141,'','supplier','100',0.00,11000.00,'Payment Id 392055 for invoice:257513, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:50:45','',''),('5','92',4960142,'','2','2220',1864230.00,0.00,'Payment Id 392056 for invoice:257514, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:51:08','',''),('5','92',4960143,'','supplier','100',0.00,1864230.00,'Payment Id 392056 for invoice:257514, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:51:08','',''),('5','92',4960144,'','2','2220',209095.00,0.00,'Payment Id 392057 for invoice:257515, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:51:34','',''),('5','92',4960145,'','supplier','100',0.00,209095.00,'Payment Id 392057 for invoice:257515, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:51:34','',''),('5','92',4960146,'','6.1','2221',23000.00,0.00,'Payment Id 392058 for invoice:257515, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:52:05','',''),('5','92',4960147,'','supplier','100',0.00,23000.00,'Payment Id 392058 for invoice:257515, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-03-22 15:52:05','',''),('5','92',4960148,'','20','2222',0.00,0.00,'Sales from shift 257519 on 2022-03-23 13:58:37 ','2022-03-23 13:58:37','',''),('5','92',4960149,'','6.1','2221',0.00,0.00,'Sales from shift 257519 on 2022-03-23 13:58:37 ','2022-03-23 13:58:37','',''),('5','92',4960150,'','20','2222',0.00,0.00,'Sales from shift 257520 on 2022-03-28 12:04:04 ','2022-03-28 12:04:04','',''),('5','92',4960151,'','6.1','2221',0.00,0.00,'Sales from shift 257520 on 2022-03-28 12:04:04 ','2022-03-28 12:04:04','',''),('5','92',4960152,'','20','2222',0.00,0.00,'Sales from shift 257521 on 2022-03-29 11:28:03 ','2022-03-29 11:28:03','',''),('5','92',4960153,'','6.1','2221',0.00,0.00,'Sales from shift 257521 on 2022-03-29 11:28:03 ','2022-03-29 11:28:03','',''),('5','92',4960154,'','20','2222',0.00,0.00,'Sales from shift 257522 on 2022-03-29 11:29:20 ','2022-03-29 11:29:20','',''),('5','92',4960155,'','6.1','2221',0.00,0.00,'Sales from shift 257522 on 2022-03-29 11:29:20 ','2022-03-29 11:29:20','',''),('5','92',4960156,'','20','2222',0.00,0.00,'Sales from shift 257523 on 2022-03-29 11:33:43 ','2022-03-29 11:33:43','',''),('5','92',4960157,'','6.1','2221',0.00,0.00,'Sales from shift 257523 on 2022-03-29 11:33:43 ','2022-03-29 11:33:43','',''),('5','92',4960158,'','20','2222',0.00,0.00,'Sales from shift 257524 on 2022-03-29 11:35:13 ','2022-03-29 11:35:13','',''),('5','92',4960159,'','6.1','2221',0.00,0.00,'Sales from shift 257524 on 2022-03-29 11:35:13 ','2022-03-29 11:35:13','',''),('5','92',4960160,'','20','2222',0.00,0.00,'Sales from shift 257525 on 2022-03-29 11:38:17 ','2022-03-29 11:38:17','',''),('5','92',4960161,'','6.1','2221',0.00,0.00,'Sales from shift 257525 on 2022-03-29 11:38:17 ','2022-03-29 11:38:17','',''),('5','92',4960162,'','20','2222',0.00,0.00,'Sales from shift 257526 on 2022-03-30 14:10:48 ','2022-03-30 14:10:48','',''),('5','92',4960163,'','6.1','2221',0.00,0.00,'Sales from shift 257526 on 2022-03-30 14:10:48 ','2022-03-30 14:10:48','',''),('5','92',4960164,'','20','2222',0.00,0.00,'Sales from shift 257527 on 2022-03-31 11:01:47 ','2022-03-31 11:01:47','',''),('5','92',4960165,'','6.1','2221',0.00,0.00,'Sales from shift 257527 on 2022-03-31 11:01:47 ','2022-03-31 11:01:47','',''),('5','92',4960166,'','20','2222',0.00,0.00,'Sales from shift 257528 on 2022-04-02 16:17:17 ','2022-04-02 16:17:17','',''),('5','92',4960167,'','6.1','2221',0.00,0.00,'Sales from shift 257528 on 2022-04-02 16:17:17 ','2022-04-02 16:17:17','',''),('5','92',4960168,'','20','2222',0.00,0.00,'Sales from shift 257529 on 2022-04-04 09:44:19 ','2022-04-04 09:44:19','',''),('5','92',4960169,'','6.1','2221',0.00,0.00,'Sales from shift 257529 on 2022-04-04 09:44:19 ','2022-04-04 09:44:19','',''),('5','92',4960170,'','20','2222',0.00,0.00,'Sales from shift 257530 on 2022-04-04 09:45:57 ','2022-04-04 09:45:57','',''),('5','92',4960171,'','6.1','2221',0.00,0.00,'Sales from shift 257530 on 2022-04-04 09:45:57 ','2022-04-04 09:45:57','',''),('5','92',4960172,'','20','2222',0.00,0.00,'Sales from shift 257531 on 2022-04-04 12:28:12 ','2022-04-04 12:28:12','',''),('5','92',4960173,'','6.1','2221',0.00,0.00,'Sales from shift 257531 on 2022-04-04 12:28:12 ','2022-04-04 12:28:12','',''),('5','92',4960174,'','20','2222',0.00,0.00,'Sales from shift 257532 on 2022-04-06 16:17:07 ','2022-04-06 16:17:07','',''),('5','92',4960175,'','6.1','2221',0.00,0.00,'Sales from shift 257532 on 2022-04-06 16:17:07 ','2022-04-06 16:17:07','',''),('5','92',4960176,'','20','2222',0.00,0.00,'Sales from shift 257533 on 2022-04-08 12:59:43 ','2022-04-08 12:59:43','',''),('5','92',4960177,'','6.1','2221',0.00,0.00,'Sales from shift 257533 on 2022-04-08 12:59:43 ','2022-04-08 12:59:43','',''),('5','92',4960178,'','20','2222',0.00,0.00,'Sales from shift 257534 on 2022-04-08 13:08:56 ','2022-04-08 13:08:56','',''),('5','92',4960179,'','6.1','2221',0.00,0.00,'Sales from shift 257534 on 2022-04-08 13:08:56 ','2022-04-08 13:08:56','',''),('5','92',4960180,'','20','2222',0.00,0.00,'Sales from shift 257535 on 2022-04-08 13:11:57 ','2022-04-08 13:11:57','',''),('5','92',4960181,'','6.1','2221',0.00,0.00,'Sales from shift 257535 on 2022-04-08 13:11:57 ','2022-04-08 13:11:57','',''),('5','92',4960182,'','24','2219',0.00,6600000.00,'Purchase Id 88768 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-04-10 11:53:21','',''),('5','92',4960183,'','supplier','100',6600000.00,0.00,'Purchase Id 88768 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-04-10 11:53:21','',''),('5','92',4960184,'','20','2222',791201.40,0.00,'Sales from shift 257536 on 2022-04-11 09:06:30 ','2022-04-11 09:06:30','',''),('5','92',4960185,'','6.1','2221',0.00,791201.40,'Sales from shift 257536 on 2022-04-11 09:06:30 ','2022-04-11 09:06:30','',''),('5','92',4960186,'','20','2222',1605661.20,0.00,'Sales from shift 257537 on 2022-04-11 09:19:13 ','2022-04-11 09:19:13','',''),('5','92',4960187,'','6.1','2221',0.00,1605661.20,'Sales from shift 257537 on 2022-04-11 09:19:13 ','2022-04-11 09:19:13','',''),('5','92',4960188,'','20','2222',1296715.20,0.00,'Sales from shift 257538 on 2022-04-12 11:25:48 ','2022-04-12 11:25:48','',''),('5','92',4960189,'','6.1','2221',0.00,1296715.20,'Sales from shift 257538 on 2022-04-12 11:25:48 ','2022-04-12 11:25:48','',''),('5','92',4960190,'','20','2222',1134586.20,0.00,'Sales from shift 257539 on 2022-04-13 09:49:39 ','2022-04-13 09:49:39','',''),('5','92',4960191,'','6.1','2221',0.00,1134586.20,'Sales from shift 257539 on 2022-04-13 09:49:39 ','2022-04-13 09:49:39','',''),('5','92',4960192,'','20','2222',149014.80,0.00,'Sales from shift 257540 on 2022-04-15 11:05:07 ','2022-04-15 11:05:07','',''),('5','92',4960193,'','6.1','2221',0.00,149014.80,'Sales from shift 257540 on 2022-04-15 11:05:07 ','2022-04-15 11:05:07','',''),('5','92',4960194,'','20','2222',0.00,0.00,'Sales from shift 257541 on 2022-04-17 18:19:25 ','2022-04-17 18:19:25','',''),('5','92',4960195,'','6.1','2221',0.00,0.00,'Sales from shift 257541 on 2022-04-17 18:19:25 ','2022-04-17 18:19:25','',''),('5','92',4960196,'','20','2222',0.00,0.00,'Sales from shift 257542 on 2022-04-17 18:20:59 ','2022-04-17 18:20:59','',''),('5','92',4960197,'','6.1','2221',0.00,0.00,'Sales from shift 257542 on 2022-04-17 18:20:59 ','2022-04-17 18:20:59','',''),('5','92',4960198,'','20','2222',0.00,0.00,'Sales from shift 257543 on 2022-04-17 18:24:13 ','2022-04-17 18:24:13','',''),('5','92',4960199,'','6.1','2221',0.00,0.00,'Sales from shift 257543 on 2022-04-17 18:24:13 ','2022-04-17 18:24:13','',''),('5','92',4960200,'','20','2222',0.00,0.00,'Sales from shift 257544 on 2022-04-17 19:20:35 ','2022-04-17 19:20:35','',''),('5','92',4960201,'','6.1','2221',0.00,0.00,'Sales from shift 257544 on 2022-04-17 19:20:35 ','2022-04-17 19:20:35','',''),('5','92',4960202,'','20','2222',0.00,0.00,'Sales from shift 257545 on 2022-04-18 17:25:03 ','2022-04-18 17:25:03','',''),('5','92',4960203,'','6.1','2221',0.00,0.00,'Sales from shift 257545 on 2022-04-18 17:25:03 ','2022-04-18 17:25:03','',''),('5','92',4960204,'','2','2220',768200.00,0.00,'Payment Id 392059 for invoice:257536, receipt: 6778 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:04:08','',''),('5','92',4960205,'','supplier','100',0.00,768200.00,'Payment Id 392059 for invoice:257536, receipt: 6778 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:04:08','',''),('5','92',4960206,'','6.1','2221',23000.00,0.00,'Payment Id 392060 for invoice:257536, receipt: 6778 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:04:49','',''),('5','92',4960207,'','supplier','100',0.00,23000.00,'Payment Id 392060 for invoice:257536, receipt: 6778 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:04:49','',''),('5','92',4960208,'','6.1','2221',11300.00,0.00,'Payment Id 392062 for invoice:257537, receipt: 6779 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:05:04','',''),('5','92',4960209,'','supplier','100',0.00,11300.00,'Payment Id 392062 for invoice:257537, receipt: 6779 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:05:04','',''),('5','92',4960210,'','2','2220',1285415.00,0.00,'Payment Id 392063 for invoice:257538, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:05:18','',''),('5','92',4960211,'','supplier','100',0.00,1285415.00,'Payment Id 392063 for invoice:257538, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:05:18','',''),('5','92',4960212,'','6.1','2221',11300.00,0.00,'Payment Id 392064 for invoice:257538, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:05:26','',''),('5','92',4960213,'','supplier','100',0.00,11300.00,'Payment Id 392064 for invoice:257538, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:05:26','',''),('5','92',4960214,'','2','2220',1114280.00,0.00,'Payment Id 392065 for invoice:257539, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:05:49','',''),('5','92',4960215,'','supplier','100',0.00,1114280.00,'Payment Id 392065 for invoice:257539, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:05:49','',''),('5','92',4960216,'','6.1','2221',20300.00,0.00,'Payment Id 392066 for invoice:257539, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:06:32','',''),('5','92',4960217,'','supplier','100',0.00,20300.00,'Payment Id 392066 for invoice:257539, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:06:32','',''),('5','92',4960218,'','2','2220',1594370.00,0.00,'Payment Id 392061 for invoice:257537, receipt: 6779 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:07:19','',''),('5','92',4960219,'','supplier','100',0.00,1594370.00,'Payment Id 392061 for invoice:257537, receipt: 6779 by SALBAS OIL & GAS NIGERIA LIMIT','2022-04-19 13:07:19','',''),('5','92',4960220,'','20','2222',0.00,0.00,'Sales from shift 257546 on 2022-04-19 20:36:35 ','2022-04-19 20:36:35','',''),('5','92',4960221,'','6.1','2221',0.00,0.00,'Sales from shift 257546 on 2022-04-19 20:36:35 ','2022-04-19 20:36:35','',''),('5','92',4960222,'','20','2222',0.00,0.00,'Sales from shift 257547 on 2022-04-20 13:18:46 ','2022-04-20 13:18:46','',''),('5','92',4960223,'','6.1','2221',0.00,0.00,'Sales from shift 257547 on 2022-04-20 13:18:46 ','2022-04-20 13:18:46','',''),('5','92',4960224,'','20','2222',0.00,0.00,'Sales from shift 257548 on 2022-04-21 23:56:48 ','2022-04-21 23:56:48','',''),('5','92',4960225,'','6.1','2221',0.00,0.00,'Sales from shift 257548 on 2022-04-21 23:56:48 ','2022-04-21 23:56:48','',''),('5','92',4960226,'','20','2222',0.00,0.00,'Sales from shift 257549 on 2022-04-22 21:05:13 ','2022-04-22 21:05:13','',''),('5','92',4960227,'','6.1','2221',0.00,0.00,'Sales from shift 257549 on 2022-04-22 21:05:13 ','2022-04-22 21:05:13','',''),('5','92',4960228,'','20','2222',0.00,0.00,'Sales from shift 257550 on 2022-04-24 14:42:00 ','2022-04-24 14:42:00','',''),('5','92',4960229,'','6.1','2221',0.00,0.00,'Sales from shift 257550 on 2022-04-24 14:42:00 ','2022-04-24 14:42:00','',''),('5','92',4960230,'','20','2222',0.00,0.00,'Sales from shift 257551 on 2022-04-25 12:05:22 ','2022-04-25 12:05:22','',''),('5','92',4960231,'','6.1','2221',0.00,0.00,'Sales from shift 257551 on 2022-04-25 12:05:22 ','2022-04-25 12:05:22','',''),('5','92',4960232,'','20','2222',0.00,0.00,'Sales from shift 257552 on 2022-04-26 09:13:52 ','2022-04-26 09:13:52','',''),('5','92',4960233,'','6.1','2221',0.00,0.00,'Sales from shift 257552 on 2022-04-26 09:13:52 ','2022-04-26 09:13:52','',''),('5','92',4960234,'','24','2219',0.00,4950000.00,'Purchase Id 88769 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-04-27 09:26:09','',''),('5','92',4960235,'','supplier','100',4950000.00,0.00,'Purchase Id 88769 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-04-27 09:26:09','',''),('5','92',4960236,'','20','2222',261272.55,0.00,'Sales from shift 257553 on 2022-04-29 10:22:58 ','2022-04-29 10:22:58','',''),('5','92',4960237,'','6.1','2221',0.00,261272.55,'Sales from shift 257553 on 2022-04-29 10:22:58 ','2022-04-29 10:22:58','',''),('5','92',4960238,'','20','2222',859793.55,0.00,'Sales from shift 257554 on 2022-05-10 10:00:56 ','2022-05-10 10:00:56','',''),('5','92',4960239,'','6.1','2221',0.00,859793.55,'Sales from shift 257554 on 2022-05-10 10:00:56 ','2022-05-10 10:00:56','',''),('5','92',4960240,'','20','2222',1295979.30,0.00,'Sales from shift 257555 on 2022-05-10 16:42:10 ','2022-05-10 16:42:10','',''),('5','92',4960241,'','6.1','2221',0.00,1295979.30,'Sales from shift 257555 on 2022-05-10 16:42:10 ','2022-05-10 16:42:10','',''),('5','92',4960242,'','20','2222',1573098.45,0.00,'Sales from shift 257556 on 2022-05-10 16:44:45 ','2022-05-10 16:44:45','',''),('5','92',4960243,'','6.1','2221',0.00,1573098.45,'Sales from shift 257556 on 2022-05-10 16:44:45 ','2022-05-10 16:44:45','',''),('5','92',4960244,'','20','2222',188626.35,0.00,'Sales from shift 257557 on 2022-05-10 16:47:57 ','2022-05-10 16:47:57','',''),('5','92',4960245,'','6.1','2221',0.00,188626.35,'Sales from shift 257557 on 2022-05-10 16:47:57 ','2022-05-10 16:47:57','',''),('5','92',4960246,'','20','2222',746968.20,0.00,'Sales from shift 257558 on 2022-05-10 16:54:00 ','2022-05-10 16:54:00','',''),('5','92',4960247,'','6.1','2221',0.00,746968.20,'Sales from shift 257558 on 2022-05-10 16:54:00 ','2022-05-10 16:54:00','',''),('5','92',4960248,'','20','2222',0.00,0.00,'Sales from shift 257559 on 2022-05-10 16:57:59 ','2022-05-10 16:57:59','',''),('5','92',4960249,'','6.1','2221',0.00,0.00,'Sales from shift 257559 on 2022-05-10 16:57:59 ','2022-05-10 16:57:59','',''),('5','92',4960250,'','20','2222',0.00,0.00,'Sales from shift 257560 on 2022-05-10 16:59:28 ','2022-05-10 16:59:28','',''),('5','92',4960251,'','6.1','2221',0.00,0.00,'Sales from shift 257560 on 2022-05-10 16:59:28 ','2022-05-10 16:59:28','',''),('5','92',4960252,'','20','2222',0.00,0.00,'Sales from shift 257561 on 2022-05-10 17:02:10 ','2022-05-10 17:02:10','',''),('5','92',4960253,'','6.1','2221',0.00,0.00,'Sales from shift 257561 on 2022-05-10 17:02:10 ','2022-05-10 17:02:10','',''),('5','92',4960254,'','24','2219',0.00,2557500.00,'Purchase Id 88770 for 15,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-05-10 17:06:27','',''),('5','92',4960255,'','supplier','100',2557500.00,0.00,'Purchase Id 88770 for 15,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-05-10 17:06:27','',''),('5','92',4960256,'','20','2222',716783.10,0.00,'Sales from shift 257562 on 2022-05-10 17:22:12 ','2022-05-10 17:22:12','',''),('5','92',4960257,'','6.1','2221',0.00,716783.10,'Sales from shift 257562 on 2022-05-10 17:22:12 ','2022-05-10 17:22:12','',''),('5','92',4960258,'','20','2222',918819.00,0.00,'Sales from shift 257563 on 2022-05-10 17:34:29 ','2022-05-10 17:34:29','',''),('5','92',4960259,'','6.1','2221',0.00,918819.00,'Sales from shift 257563 on 2022-05-10 17:34:29 ','2022-05-10 17:34:29','',''),('5','92',4960260,'','20','2222',585022.35,0.00,'Sales from shift 257564 on 2022-05-10 17:38:12 ','2022-05-10 17:38:12','',''),('5','92',4960261,'','6.1','2221',0.00,585022.35,'Sales from shift 257564 on 2022-05-10 17:38:12 ','2022-05-10 17:38:12','',''),('5','92',4960262,'','20','2222',346264.05,0.00,'Sales from shift 257565 on 2022-05-10 17:40:45 ','2022-05-10 17:40:45','',''),('5','92',4960263,'','6.1','2221',0.00,346264.05,'Sales from shift 257565 on 2022-05-10 17:40:45 ','2022-05-10 17:40:45','',''),('5','92',4960264,'','20','2222',0.00,0.00,'Sales from shift 257566 on 2022-05-10 17:42:21 ','2022-05-10 17:42:21','',''),('5','92',4960265,'','6.1','2221',0.00,0.00,'Sales from shift 257566 on 2022-05-10 17:42:21 ','2022-05-10 17:42:21','',''),('5','92',4960266,'','20','2222',0.00,0.00,'Sales from shift 257567 on 2022-05-10 17:43:58 ','2022-05-10 17:43:58','',''),('5','92',4960267,'','6.1','2221',0.00,0.00,'Sales from shift 257567 on 2022-05-10 17:43:58 ','2022-05-10 17:43:58','',''),('5','92',4960268,'','6.1','2221',11300.00,0.00,'Payment Id 392078 for invoice:257557, receipt: 0038 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:00:45','',''),('5','92',4960269,'','supplier','100',0.00,11300.00,'Payment Id 392078 for invoice:257557, receipt: 0038 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:00:45','',''),('5','92',4960270,'','2','2220',471470.00,0.00,'Payment Id 392079 for invoice:257558, receipt: 0039 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:00:55','',''),('5','92',4960271,'','supplier','100',0.00,471470.00,'Payment Id 392079 for invoice:257558, receipt: 0039 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:00:55','',''),('5','92',4960272,'','2','2220',705480.00,0.00,'Payment Id 392080 for invoice:257562, receipt: 0079 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:07','',''),('5','92',4960273,'','supplier','100',0.00,705480.00,'Payment Id 392080 for invoice:257562, receipt: 0079 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:07','',''),('5','92',4960274,'','6.1','2221',11300.00,0.00,'Payment Id 392081 for invoice:257562, receipt: 0079 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:18','',''),('5','92',4960275,'','supplier','100',0.00,11300.00,'Payment Id 392081 for invoice:257562, receipt: 0079 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:18','',''),('5','92',4960276,'','2','2220',907520.00,0.00,'Payment Id 392082 for invoice:257563, receipt: 0066 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:31','',''),('5','92',4960277,'','supplier','100',0.00,907520.00,'Payment Id 392082 for invoice:257563, receipt: 0066 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:31','',''),('5','92',4960278,'','6.1','2221',11300.00,0.00,'Payment Id 392083 for invoice:257563, receipt: 0066 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:40','',''),('5','92',4960279,'','supplier','100',0.00,11300.00,'Payment Id 392083 for invoice:257563, receipt: 0066 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:40','',''),('5','92',4960280,'','2','2220',573720.00,0.00,'Payment Id 392084 for invoice:257564, receipt: 0065 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:52','',''),('5','92',4960281,'','supplier','100',0.00,573720.00,'Payment Id 392084 for invoice:257564, receipt: 0065 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:01:52','',''),('5','92',4960282,'','6.1','2221',11300.00,0.00,'Payment Id 392085 for invoice:257564, receipt: 0065 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:02:03','',''),('5','92',4960283,'','supplier','100',0.00,11300.00,'Payment Id 392085 for invoice:257564, receipt: 0065 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:02:03','',''),('5','92',4960284,'','2','2220',334965.00,0.00,'Payment Id 392086 for invoice:257565, receipt: 0067 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:02:29','',''),('5','92',4960285,'','supplier','100',0.00,334965.00,'Payment Id 392086 for invoice:257565, receipt: 0067 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:02:29','',''),('5','92',4960286,'','6.1','2221',11300.00,0.00,'Payment Id 392087 for invoice:257567, receipt: 0065 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:02:39','',''),('5','92',4960287,'','supplier','100',0.00,11300.00,'Payment Id 392087 for invoice:257567, receipt: 0065 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-11 11:02:39','',''),('5','92',4960288,'','20','2222',0.00,0.00,'Sales from shift 257568 on 2022-05-12 11:24:21 ','2022-05-12 11:24:21','',''),('5','92',4960289,'','6.1','2221',0.00,0.00,'Sales from shift 257568 on 2022-05-12 11:24:21 ','2022-05-12 11:24:21','',''),('5','92',4960290,'','20','2222',0.00,0.00,'Sales from shift 257569 on 2022-05-13 10:59:43 ','2022-05-13 10:59:43','',''),('5','92',4960291,'','6.1','2221',0.00,0.00,'Sales from shift 257569 on 2022-05-13 10:59:43 ','2022-05-13 10:59:43','',''),('5','92',4960292,'','20','2222',0.00,0.00,'Sales from shift 257570 on 2022-05-14 15:32:30 ','2022-05-14 15:32:30','',''),('5','92',4960293,'','6.1','2221',0.00,0.00,'Sales from shift 257570 on 2022-05-14 15:32:30 ','2022-05-14 15:32:30','',''),('5','92',4960294,'','20','2222',0.00,0.00,'Sales from shift 257571 on 2022-05-15 13:51:46 ','2022-05-15 13:51:46','',''),('5','92',4960295,'','6.1','2221',0.00,0.00,'Sales from shift 257571 on 2022-05-15 13:51:46 ','2022-05-15 13:51:46','',''),('5','92',4960296,'','24','2219',0.00,4950000.00,'Purchase Id 88771 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-05-16 10:58:38','',''),('5','92',4960297,'','supplier','100',4950000.00,0.00,'Purchase Id 88771 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-05-16 10:58:38','',''),('5','92',4960298,'','20','2222',256035.45,0.00,'Sales from shift 257572 on 2022-05-16 18:22:55 ','2022-05-16 18:22:55','',''),('5','92',4960299,'','6.1','2221',0.00,256035.45,'Sales from shift 257572 on 2022-05-16 18:22:55 ','2022-05-16 18:22:55','',''),('5','92',4960300,'','20','2222',1035992.10,0.00,'Sales from shift 257573 on 2022-05-17 09:29:27 ','2022-05-17 09:29:27','',''),('5','92',4960301,'','6.1','2221',0.00,1035992.10,'Sales from shift 257573 on 2022-05-17 09:29:27 ','2022-05-17 09:29:27','',''),('5','92',4960302,'','2','2220',244135.00,0.00,'Payment Id 392088 for invoice:257572, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-17 18:34:30','',''),('5','92',4960303,'','supplier','100',0.00,244135.00,'Payment Id 392088 for invoice:257572, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-17 18:34:30','',''),('5','92',4960304,'','6.1','2221',11900.00,0.00,'Payment Id 392089 for invoice:257573, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-17 19:28:03','',''),('5','92',4960305,'','supplier','100',0.00,11900.00,'Payment Id 392089 for invoice:257573, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-17 19:28:03','',''),('5','92',4960306,'','6.1','2221',11900.00,0.00,'Payment Id 392090 for invoice:257573, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-17 19:28:26','',''),('5','92',4960307,'','supplier','100',0.00,11900.00,'Payment Id 392090 for invoice:257573, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-17 19:28:26','',''),('5','92',4960308,'','20','2222',1426713.75,0.00,'Sales from shift 257574 on 2022-05-18 11:39:48 ','2022-05-18 11:39:48','',''),('5','92',4960309,'','6.1','2221',0.00,1426713.75,'Sales from shift 257574 on 2022-05-18 11:39:48 ','2022-05-18 11:39:48','',''),('5','92',4960310,'','20','2222',1643639.25,0.00,'Sales from shift 257575 on 2022-05-19 09:59:06 ','2022-05-19 09:59:06','',''),('5','92',4960311,'','6.1','2221',0.00,1643639.25,'Sales from shift 257575 on 2022-05-19 09:59:06 ','2022-05-19 09:59:06','',''),('5','92',4960312,'','20','2222',592475.40,0.00,'Sales from shift 257576 on 2022-05-20 10:08:37 ','2022-05-20 10:08:37','',''),('5','92',4960313,'','6.1','2221',0.00,592475.40,'Sales from shift 257576 on 2022-05-20 10:08:37 ','2022-05-20 10:08:37','',''),('5','92',4960314,'','2','2220',1017090.00,0.00,'Payment Id 392091 for invoice:257574, receipt: 0054 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-20 10:10:08','',''),('5','92',4960315,'','supplier','100',0.00,1017090.00,'Payment Id 392091 for invoice:257574, receipt: 0054 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-20 10:10:08','',''),('5','92',4960316,'','6.1','2221',11900.00,0.00,'Payment Id 392092 for invoice:257574, receipt: 0054 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-20 10:10:23','',''),('5','92',4960317,'','supplier','100',0.00,11900.00,'Payment Id 392092 for invoice:257574, receipt: 0054 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-20 10:10:23','',''),('5','92',4960318,'','20','2222',0.00,0.00,'Sales from shift 257577 on 2022-05-23 13:07:01 ','2022-05-23 13:07:01','',''),('5','92',4960319,'','6.1','2221',0.00,0.00,'Sales from shift 257577 on 2022-05-23 13:07:01 ','2022-05-23 13:07:01','',''),('5','92',4960320,'','20','2222',0.00,0.00,'Sales from shift 257578 on 2022-05-23 13:10:50 ','2022-05-23 13:10:50','',''),('5','92',4960321,'','6.1','2221',0.00,0.00,'Sales from shift 257578 on 2022-05-23 13:10:50 ','2022-05-23 13:10:50','',''),('5','92',4960322,'','20','2222',0.00,0.00,'Sales from shift 257579 on 2022-05-23 13:17:21 ','2022-05-23 13:17:21','',''),('5','92',4960323,'','6.1','2221',0.00,0.00,'Sales from shift 257579 on 2022-05-23 13:17:21 ','2022-05-23 13:17:21','',''),('5','92',4960324,'','24','2219',0.00,4950000.00,'Purchase Id 88772 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-05-23 13:18:36','',''),('5','92',4960325,'','supplier','100',4950000.00,0.00,'Purchase Id 88772 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-05-23 13:18:36','',''),('5','92',4960326,'','20','2222',950642.55,0.00,'Sales from shift 257580 on 2022-05-23 21:51:28 ','2022-05-23 21:51:28','',''),('5','92',4960327,'','6.1','2221',0.00,950642.55,'Sales from shift 257580 on 2022-05-23 21:51:28 ','2022-05-23 21:51:28','',''),('5','92',4960328,'','20','2222',1707103.20,0.00,'Sales from shift 257581 on 2022-05-25 09:28:07 ','2022-05-25 09:28:07','',''),('5','92',4960329,'','6.1','2221',0.00,1707103.20,'Sales from shift 257581 on 2022-05-25 09:28:07 ','2022-05-25 09:28:07','',''),('5','92',4960330,'','20','2222',1061052.30,0.00,'Sales from shift 257582 on 2022-05-26 10:34:21 ','2022-05-26 10:34:21','',''),('5','92',4960331,'','6.1','2221',0.00,1061052.30,'Sales from shift 257582 on 2022-05-26 10:34:21 ','2022-05-26 10:34:21','',''),('5','92',4960332,'','20','2222',724524.90,0.00,'Sales from shift 257583 on 2022-05-26 23:16:06 ','2022-05-26 23:16:06','',''),('5','92',4960333,'','6.1','2221',0.00,724524.90,'Sales from shift 257583 on 2022-05-26 23:16:06 ','2022-05-26 23:16:06','',''),('5','92',4960334,'','2','2220',1414815.00,0.00,'Payment Id 392093 for invoice:257574, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-27 14:13:11','',''),('5','92',4960335,'','supplier','100',0.00,1414815.00,'Payment Id 392093 for invoice:257574, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-27 14:13:11','',''),('5','92',4960336,'','6.1','2221',11900.00,0.00,'Payment Id 392094 for invoice:257574, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-27 14:13:31','',''),('5','92',4960337,'','supplier','100',0.00,11900.00,'Payment Id 392094 for invoice:257574, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-27 14:13:31','',''),('5','92',4960338,'','2','2220',1631740.00,0.00,'Payment Id 392095 for invoice:257575, receipt: 0007 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-27 15:24:16','',''),('5','92',4960339,'','supplier','100',0.00,1631740.00,'Payment Id 392095 for invoice:257575, receipt: 0007 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-27 15:24:16','',''),('5','92',4960340,'','6.1','2221',11900.00,0.00,'Payment Id 392096 for invoice:257575, receipt: 0007 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-27 15:24:35','',''),('5','92',4960341,'','supplier','100',0.00,11900.00,'Payment Id 392096 for invoice:257575, receipt: 0007 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-27 15:24:35','',''),('5','92',4960342,'','20','2222',327442.50,0.00,'Sales from shift 257584 on 2022-05-28 22:36:33 ','2022-05-28 22:36:33','',''),('5','92',4960343,'','6.1','2221',0.00,327442.50,'Sales from shift 257584 on 2022-05-28 22:36:33 ','2022-05-28 22:36:33','',''),('5','92',4960344,'','20','2222',190213.65,0.00,'Sales from shift 257585 on 2022-05-30 11:09:10 ','2022-05-30 11:09:10','',''),('5','92',4960345,'','6.1','2221',0.00,190213.65,'Sales from shift 257585 on 2022-05-30 11:09:10 ','2022-05-30 11:09:10','',''),('5','92',4960346,'','2','2220',580575.00,0.00,'Payment Id 392097 for invoice:257576, receipt: 0091 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:15:28','',''),('5','92',4960347,'','supplier','100',0.00,580575.00,'Payment Id 392097 for invoice:257576, receipt: 0091 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:15:28','',''),('5','92',4960348,'','6.1','2221',11900.00,0.00,'Payment Id 392098 for invoice:257576, receipt: 0091 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:15:39','',''),('5','92',4960349,'','supplier','100',0.00,11900.00,'Payment Id 392098 for invoice:257576, receipt: 0091 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:15:39','',''),('5','92',4960350,'','2','2220',938740.00,0.00,'Payment Id 392099 for invoice:257580, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:15:51','',''),('5','92',4960351,'','supplier','100',0.00,938740.00,'Payment Id 392099 for invoice:257580, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:15:51','',''),('5','92',4960352,'','6.1','2221',11900.00,0.00,'Payment Id 392100 for invoice:257580, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:16:01','',''),('5','92',4960353,'','supplier','100',0.00,11900.00,'Payment Id 392100 for invoice:257580, receipt: 0043 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:16:01','',''),('5','92',4960354,'','2','2220',1695205.00,0.00,'Payment Id 392101 for invoice:257581, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:16:15','',''),('5','92',4960355,'','supplier','100',0.00,1695205.00,'Payment Id 392101 for invoice:257581, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:16:15','',''),('5','92',4960356,'','2','2220',1049150.00,0.00,'Payment Id 392103 for invoice:257582, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:16:23','',''),('5','92',4960357,'','supplier','100',0.00,1049150.00,'Payment Id 392103 for invoice:257582, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:16:23','',''),('5','92',4960358,'','6.1','2221',11900.00,0.00,'Payment Id 392102 for invoice:257581, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:16:37','',''),('5','92',4960359,'','supplier','100',0.00,11900.00,'Payment Id 392102 for invoice:257581, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:16:37','',''),('5','92',4960360,'','6.1','2221',11900.00,0.00,'Payment Id 392106 for invoice:257583, receipt: 0069 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:17:14','',''),('5','92',4960361,'','supplier','100',0.00,11900.00,'Payment Id 392106 for invoice:257583, receipt: 0069 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:17:14','',''),('5','92',4960362,'','2','2220',712625.00,0.00,'Payment Id 392105 for invoice:257583, receipt: 0069 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:17:33','',''),('5','92',4960363,'','supplier','100',0.00,712625.00,'Payment Id 392105 for invoice:257583, receipt: 0069 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:17:33','',''),('5','92',4960364,'','6.1','2221',11900.00,0.00,'Payment Id 392104 for invoice:257582, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:17:45','',''),('5','92',4960365,'','supplier','100',0.00,11900.00,'Payment Id 392104 for invoice:257582, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-30 11:17:45','',''),('5','92',4960366,'','20','2222',0.00,0.00,'Sales from shift 257586 on 2022-05-30 12:27:58 ','2022-05-30 12:27:58','',''),('5','92',4960367,'','6.1','2221',0.00,0.00,'Sales from shift 257586 on 2022-05-30 12:27:58 ','2022-05-30 12:27:58','',''),('5','92',4960368,'','20','2222',0.00,0.00,'Sales from shift 257587 on 2022-05-31 09:44:51 ','2022-05-31 09:44:51','',''),('5','92',4960369,'','6.1','2221',0.00,0.00,'Sales from shift 257587 on 2022-05-31 09:44:51 ','2022-05-31 09:44:51','',''),('5','92',4960370,'','2','2220',315540.00,0.00,'Payment Id 392107 for invoice:257584, receipt: 0090 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-31 09:46:14','',''),('5','92',4960371,'','supplier','100',0.00,315540.00,'Payment Id 392107 for invoice:257584, receipt: 0090 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-31 09:46:14','',''),('5','92',4960372,'','6.1','2221',11900.00,0.00,'Payment Id 392108 for invoice:257584, receipt: 0090 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-31 09:46:26','',''),('5','92',4960373,'','supplier','100',0.00,11900.00,'Payment Id 392108 for invoice:257584, receipt: 0090 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-31 09:46:26','',''),('5','92',4960374,'','6.1','2221',11900.00,0.00,'Payment Id 392110 for invoice:257585, receipt: 0067 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-31 09:46:48','',''),('5','92',4960375,'','supplier','100',0.00,11900.00,'Payment Id 392110 for invoice:257585, receipt: 0067 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-31 09:46:48','',''),('5','92',4960376,'','2','2220',178315.00,0.00,'Payment Id 392109 for invoice:257585, receipt: 0067 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-31 09:47:06','',''),('5','92',4960377,'','supplier','100',0.00,178315.00,'Payment Id 392109 for invoice:257585, receipt: 0067 by SALBAS OIL & GAS NIGERIA LIMIT','2022-05-31 09:47:06','',''),('5','92',4960378,'','20','2222',0.00,0.00,'Sales from shift 257588 on 2022-06-02 10:19:03 ','2022-06-02 10:19:03','',''),('5','92',4960379,'','6.1','2221',0.00,0.00,'Sales from shift 257588 on 2022-06-02 10:19:03 ','2022-06-02 10:19:03','',''),('5','92',4960380,'','20','2222',0.00,0.00,'Sales from shift 257589 on 2022-06-03 10:00:16 ','2022-06-03 10:00:16','',''),('5','92',4960381,'','6.1','2221',0.00,0.00,'Sales from shift 257589 on 2022-06-03 10:00:16 ','2022-06-03 10:00:16','',''),('5','92',4960382,'','20','2222',0.00,0.00,'Sales from shift 257590 on 2022-06-03 16:12:14 ','2022-06-03 16:12:14','',''),('5','92',4960383,'','6.1','2221',0.00,0.00,'Sales from shift 257590 on 2022-06-03 16:12:14 ','2022-06-03 16:12:14','',''),('5','92',4960384,'','20','2222',0.00,0.00,'Sales from shift 257591 on 2022-06-04 15:15:47 ','2022-06-04 15:15:47','',''),('5','92',4960385,'','6.1','2221',0.00,0.00,'Sales from shift 257591 on 2022-06-04 15:15:47 ','2022-06-04 15:15:47','',''),('5','92',4960386,'','20','2222',0.00,0.00,'Sales from shift 257592 on 2022-06-04 15:21:40 ','2022-06-04 15:21:40','',''),('5','92',4960387,'','6.1','2221',0.00,0.00,'Sales from shift 257592 on 2022-06-04 15:21:40 ','2022-06-04 15:21:40','',''),('5','92',4960388,'','20','2222',0.00,0.00,'Sales from shift 257593 on 2022-06-05 22:06:54 ','2022-06-05 22:06:54','',''),('5','92',4960389,'','6.1','2221',0.00,0.00,'Sales from shift 257593 on 2022-06-05 22:06:54 ','2022-06-05 22:06:54','',''),('5','92',4960390,'','20','2222',0.00,0.00,'Sales from shift 257594 on 2022-06-07 09:09:05 ','2022-06-07 09:09:05','',''),('5','92',4960391,'','6.1','2221',0.00,0.00,'Sales from shift 257594 on 2022-06-07 09:09:05 ','2022-06-07 09:09:05','',''),('5','92',4960392,'','20','2222',0.00,0.00,'Sales from shift 257595 on 2022-06-08 09:45:24 ','2022-06-08 09:45:24','',''),('5','92',4960393,'','6.1','2221',0.00,0.00,'Sales from shift 257595 on 2022-06-08 09:45:24 ','2022-06-08 09:45:24','',''),('5','92',4960394,'','20','2222',0.00,0.00,'Sales from shift 257596 on 2022-06-09 19:35:52 ','2022-06-09 19:35:52','',''),('5','92',4960395,'','6.1','2221',0.00,0.00,'Sales from shift 257596 on 2022-06-09 19:35:52 ','2022-06-09 19:35:52','',''),('5','92',4960396,'','20','2222',0.00,0.00,'Sales from shift 257597 on 2022-06-10 09:24:03 ','2022-06-10 09:24:03','',''),('5','92',4960397,'','6.1','2221',0.00,0.00,'Sales from shift 257597 on 2022-06-10 09:24:03 ','2022-06-10 09:24:03','',''),('5','92',4960398,'','20','2222',0.00,0.00,'Sales from shift 257598 on 2022-06-11 18:03:45 ','2022-06-11 18:03:45','',''),('5','92',4960399,'','6.1','2221',0.00,0.00,'Sales from shift 257598 on 2022-06-11 18:03:45 ','2022-06-11 18:03:45','',''),('5','92',4960400,'','20','2222',0.00,0.00,'Sales from shift 257599 on 2022-06-12 16:21:14 ','2022-06-12 16:21:14','',''),('5','92',4960401,'','6.1','2221',0.00,0.00,'Sales from shift 257599 on 2022-06-12 16:21:14 ','2022-06-12 16:21:14','',''),('5','92',4960402,'','20','2222',0.00,0.00,'Sales from shift 257600 on 2022-06-13 13:03:20 ','2022-06-13 13:03:20','',''),('5','92',4960403,'','6.1','2221',0.00,0.00,'Sales from shift 257600 on 2022-06-13 13:03:20 ','2022-06-13 13:03:20','',''),('5','92',4960404,'','20','2222',0.00,0.00,'Sales from shift 257601 on 2022-06-13 22:05:00 ','2022-06-13 22:05:00','',''),('5','92',4960405,'','6.1','2221',0.00,0.00,'Sales from shift 257601 on 2022-06-13 22:05:00 ','2022-06-13 22:05:00','',''),('5','92',4960406,'','20','2222',0.00,0.00,'Sales from shift 257602 on 2022-06-15 09:30:32 ','2022-06-15 09:30:32','',''),('5','92',4960407,'','6.1','2221',0.00,0.00,'Sales from shift 257602 on 2022-06-15 09:30:32 ','2022-06-15 09:30:32','',''),('5','92',4960408,'','20','2222',0.00,0.00,'Sales from shift 257603 on 2022-06-15 21:29:58 ','2022-06-15 21:29:58','',''),('5','92',4960409,'','6.1','2221',0.00,0.00,'Sales from shift 257603 on 2022-06-15 21:29:58 ','2022-06-15 21:29:58','',''),('5','92',4960410,'','20','2222',0.00,0.00,'Sales from shift 257604 on 2022-06-17 13:17:52 ','2022-06-17 13:17:52','',''),('5','92',4960411,'','6.1','2221',0.00,0.00,'Sales from shift 257604 on 2022-06-17 13:17:52 ','2022-06-17 13:17:52','',''),('5','92',4960412,'','20','2222',0.00,0.00,'Sales from shift 257605 on 2022-06-17 19:36:48 ','2022-06-17 19:36:48','',''),('5','92',4960413,'','6.1','2221',0.00,0.00,'Sales from shift 257605 on 2022-06-17 19:36:48 ','2022-06-17 19:36:48','',''),('5','92',4960414,'','20','2222',0.00,0.00,'Sales from shift 257606 on 2022-06-18 19:25:14 ','2022-06-18 19:25:14','',''),('5','92',4960415,'','6.1','2221',0.00,0.00,'Sales from shift 257606 on 2022-06-18 19:25:14 ','2022-06-18 19:25:14','',''),('5','92',4960416,'','24','2219',0.00,2433750.00,'Purchase Id 88773 for 14,750.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-06-19 14:55:51','',''),('5','92',4960417,'','supplier','100',2433750.00,0.00,'Purchase Id 88773 for 14,750.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-06-19 14:55:51','',''),('5','92',4960418,'','20','2222',752891.70,0.00,'Sales from shift 257607 on 2022-06-21 08:50:56 ','2022-06-21 08:50:56','',''),('5','92',4960419,'','6.1','2221',0.00,752891.70,'Sales from shift 257607 on 2022-06-21 08:50:56 ','2022-06-21 08:50:56','',''),('5','92',4960420,'','20','2222',739384.80,0.00,'Sales from shift 257608 on 2022-06-21 15:07:50 ','2022-06-21 15:07:50','',''),('5','92',4960421,'','6.1','2221',0.00,739384.80,'Sales from shift 257608 on 2022-06-21 15:07:50 ','2022-06-21 15:07:50','',''),('5','92',4960422,'','20','2222',264000.00,0.00,'Sales from shift 257609 on 2022-06-22 12:30:05 ','2022-06-22 12:30:05','',''),('5','92',4960423,'','6.1','2221',0.00,264000.00,'Sales from shift 257609 on 2022-06-22 12:30:05 ','2022-06-22 12:30:05','',''),('5','92',4960424,'','20','2222',408074.70,0.00,'Sales from shift 257610 on 2022-06-23 09:45:46 ','2022-06-23 09:45:46','',''),('5','92',4960425,'','6.1','2221',0.00,408074.70,'Sales from shift 257610 on 2022-06-23 09:45:46 ','2022-06-23 09:45:46','',''),('5','92',4960426,'','2','2220',729290.00,0.00,'Payment Id 392111 for invoice:257607, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:02','',''),('5','92',4960427,'','supplier','100',0.00,729290.00,'Payment Id 392111 for invoice:257607, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:02','',''),('5','92',4960428,'','6.1','2221',23600.00,0.00,'Payment Id 392112 for invoice:257607, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:20','',''),('5','92',4960429,'','supplier','100',0.00,23600.00,'Payment Id 392112 for invoice:257607, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:20','',''),('5','92',4960430,'','6.1','2221',11900.00,0.00,'Payment Id 392114 for invoice:257608, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:29','',''),('5','92',4960431,'','supplier','100',0.00,11900.00,'Payment Id 392114 for invoice:257608, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:29','',''),('5','92',4960432,'','2','2220',727485.00,0.00,'Payment Id 392113 for invoice:257608, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:43','',''),('5','92',4960433,'','supplier','100',0.00,727485.00,'Payment Id 392113 for invoice:257608, receipt: 0019 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:43','',''),('5','92',4960434,'','2','2220',252100.00,0.00,'Payment Id 392115 for invoice:257609, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:54','',''),('5','92',4960435,'','supplier','100',0.00,252100.00,'Payment Id 392115 for invoice:257609, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:46:54','',''),('5','92',4960436,'','6.1','2221',11900.00,0.00,'Payment Id 392116 for invoice:257609, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:47:10','',''),('5','92',4960437,'','supplier','100',0.00,11900.00,'Payment Id 392116 for invoice:257609, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-23 09:47:10','',''),('5','92',4960438,'','20','2222',269116.65,0.00,'Sales from shift 257611 on 2022-06-24 10:10:30 ','2022-06-24 10:10:30','',''),('5','92',4960439,'','6.1','2221',0.00,269116.65,'Sales from shift 257611 on 2022-06-24 10:10:30 ','2022-06-24 10:10:30','',''),('5','92',4960440,'','20','2222',0.00,0.00,'Sales from shift 257612 on 2022-06-26 19:27:54 ','2022-06-26 19:27:54','',''),('5','92',4960441,'','6.1','2221',0.00,0.00,'Sales from shift 257612 on 2022-06-26 19:27:54 ','2022-06-26 19:27:54','',''),('5','92',4960442,'','20','2222',0.00,0.00,'Sales from shift 257613 on 2022-06-27 09:28:46 ','2022-06-27 09:28:46','',''),('5','92',4960443,'','6.1','2221',0.00,0.00,'Sales from shift 257613 on 2022-06-27 09:28:46 ','2022-06-27 09:28:46','',''),('5','92',4960444,'','20','2222',0.00,0.00,'Sales from shift 257614 on 2022-06-27 09:38:35 ','2022-06-27 09:38:35','',''),('5','92',4960445,'','6.1','2221',0.00,0.00,'Sales from shift 257614 on 2022-06-27 09:38:35 ','2022-06-27 09:38:35','',''),('5','92',4960446,'','2','2220',396175.00,0.00,'Payment Id 392117 for invoice:257610, receipt: 0104 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-27 12:20:17','',''),('5','92',4960447,'','supplier','100',0.00,396175.00,'Payment Id 392117 for invoice:257610, receipt: 0104 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-27 12:20:17','',''),('5','92',4960448,'','6.1','2221',11900.00,0.00,'Payment Id 392118 for invoice:257610, receipt: 0104 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-27 12:20:31','',''),('5','92',4960449,'','supplier','100',0.00,11900.00,'Payment Id 392118 for invoice:257610, receipt: 0104 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-27 12:20:31','',''),('5','92',4960450,'','2','2220',243720.00,0.00,'Payment Id 392119 for invoice:257611, receipt: 0068 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-27 12:20:45','',''),('5','92',4960451,'','supplier','100',0.00,243720.00,'Payment Id 392119 for invoice:257611, receipt: 0068 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-27 12:20:45','',''),('5','92',4960452,'','6.1','2221',25400.00,0.00,'Payment Id 392120 for invoice:257611, receipt: 0068 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-27 12:21:06','',''),('5','92',4960453,'','supplier','100',0.00,25400.00,'Payment Id 392120 for invoice:257611, receipt: 0068 by SALBAS OIL & GAS NIGERIA LIMIT','2022-06-27 12:21:06','',''),('5','92',4960454,'','20','2222',0.00,0.00,'Sales from shift 257615 on 2022-06-28 10:29:57 ','2022-06-28 10:29:57','',''),('5','92',4960455,'','6.1','2221',0.00,0.00,'Sales from shift 257615 on 2022-06-28 10:29:57 ','2022-06-28 10:29:57','',''),('5','92',4960456,'','20','2222',0.00,0.00,'Sales from shift 257616 on 2022-06-29 09:30:34 ','2022-06-29 09:30:34','',''),('5','92',4960457,'','6.1','2221',0.00,0.00,'Sales from shift 257616 on 2022-06-29 09:30:34 ','2022-06-29 09:30:34','',''),('5','92',4960458,'','20','2222',0.00,0.00,'Sales from shift 257617 on 2022-06-30 11:54:13 ','2022-06-30 11:54:13','',''),('5','92',4960459,'','6.1','2221',0.00,0.00,'Sales from shift 257617 on 2022-06-30 11:54:13 ','2022-06-30 11:54:13','',''),('5','92',4960460,'','20','2222',0.00,0.00,'Sales from shift 257618 on 2022-07-02 20:16:10 ','2022-07-02 20:16:10','',''),('5','92',4960461,'','6.1','2221',0.00,0.00,'Sales from shift 257618 on 2022-07-02 20:16:10 ','2022-07-02 20:16:10','',''),('5','92',4960462,'','20','2222',0.00,0.00,'Sales from shift 257619 on 2022-07-02 20:20:02 ','2022-07-02 20:20:02','',''),('5','92',4960463,'','6.1','2221',0.00,0.00,'Sales from shift 257619 on 2022-07-02 20:20:02 ','2022-07-02 20:20:02','',''),('5','92',4960464,'','20','2222',0.00,0.00,'Sales from shift 257620 on 2022-07-02 20:21:27 ','2022-07-02 20:21:27','',''),('5','92',4960465,'','6.1','2221',0.00,0.00,'Sales from shift 257620 on 2022-07-02 20:21:27 ','2022-07-02 20:21:27','',''),('5','92',4960466,'','20','2222',0.00,0.00,'Sales from shift 257621 on 2022-07-03 21:38:01 ','2022-07-03 21:38:01','',''),('5','92',4960467,'','6.1','2221',0.00,0.00,'Sales from shift 257621 on 2022-07-03 21:38:01 ','2022-07-03 21:38:01','',''),('5','92',4960468,'','20','2222',0.00,0.00,'Sales from shift 257622 on 2022-07-04 13:17:57 ','2022-07-04 13:17:57','',''),('5','92',4960469,'','6.1','2221',0.00,0.00,'Sales from shift 257622 on 2022-07-04 13:17:57 ','2022-07-04 13:17:57','',''),('5','92',4960470,'','20','2222',0.00,0.00,'Sales from shift 257623 on 2022-07-05 10:24:21 ','2022-07-05 10:24:21','',''),('5','92',4960471,'','6.1','2221',0.00,0.00,'Sales from shift 257623 on 2022-07-05 10:24:21 ','2022-07-05 10:24:21','',''),('5','92',4960472,'','20','2222',0.00,0.00,'Sales from shift 257624 on 2022-07-07 09:34:14 ','2022-07-07 09:34:14','',''),('5','92',4960473,'','6.1','2221',0.00,0.00,'Sales from shift 257624 on 2022-07-07 09:34:14 ','2022-07-07 09:34:14','',''),('5','92',4960474,'','24','2219',0.00,4950000.00,'Purchase Id 88774 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-07-08 11:23:54','',''),('5','92',4960475,'','supplier','100',4950000.00,0.00,'Purchase Id 88774 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-07-08 11:23:54','',''),('5','92',4960476,'','20','2222',341182.05,0.00,'Sales from shift 257625 on 2022-07-09 18:59:57 ','2022-07-09 18:59:57','',''),('5','92',4960477,'','6.1','2221',0.00,341182.05,'Sales from shift 257625 on 2022-07-09 18:59:57 ','2022-07-09 18:59:57','',''),('5','92',4960478,'','20','2222',710148.45,0.00,'Sales from shift 257626 on 2022-07-10 21:32:07 ','2022-07-10 21:32:07','',''),('5','92',4960479,'','6.1','2221',0.00,710148.45,'Sales from shift 257626 on 2022-07-10 21:32:07 ','2022-07-10 21:32:07','',''),('5','92',4960480,'','20','2222',732560.40,0.00,'Sales from shift 257627 on 2022-07-10 21:38:49 ','2022-07-10 21:38:49','',''),('5','92',4960481,'','6.1','2221',0.00,732560.40,'Sales from shift 257627 on 2022-07-10 21:38:49 ','2022-07-10 21:38:49','',''),('5','92',4960482,'','20','2222',1022898.30,0.00,'Sales from shift 257628 on 2022-07-11 11:03:23 ','2022-07-11 11:03:23','',''),('5','92',4960483,'','6.1','2221',0.00,1022898.30,'Sales from shift 257628 on 2022-07-11 11:03:23 ','2022-07-11 11:03:23','',''),('5','92',4960484,'','20','2222',829007.20,0.00,'Sales from shift 257629 on 2022-07-12 16:16:27 ','2022-07-12 16:16:27','',''),('5','92',4960485,'','6.1','2221',0.00,829007.20,'Sales from shift 257629 on 2022-07-12 16:16:27 ','2022-07-12 16:16:27','',''),('5','92',4960486,'','20','2222',632354.05,0.00,'Sales from shift 257630 on 2022-07-12 18:29:54 ','2022-07-12 18:29:54','',''),('5','92',4960487,'','6.1','2221',0.00,632354.05,'Sales from shift 257630 on 2022-07-12 18:29:54 ','2022-07-12 18:29:54','',''),('5','92',4960488,'','20','2222',626774.45,0.00,'Sales from shift 257631 on 2022-07-14 08:40:31 ','2022-07-14 08:40:31','',''),('5','92',4960489,'','6.1','2221',0.00,626774.45,'Sales from shift 257631 on 2022-07-14 08:40:31 ','2022-07-14 08:40:31','',''),('5','92',4960490,'','2','2220',696450.00,0.00,'Payment Id 392123 for invoice:257626, receipt: 0055 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:41:41','',''),('5','92',4960491,'','supplier','100',0.00,696450.00,'Payment Id 392123 for invoice:257626, receipt: 0055 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:41:41','',''),('5','92',4960492,'','6.1','2221',13700.00,0.00,'Payment Id 392124 for invoice:257626, receipt: 0055 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:41:53','',''),('5','92',4960493,'','supplier','100',0.00,13700.00,'Payment Id 392124 for invoice:257626, receipt: 0055 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:41:53','',''),('5','92',4960494,'','2','2220',619160.00,0.00,'Payment Id 392125 for invoice:257627, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:05','',''),('5','92',4960495,'','supplier','100',0.00,619160.00,'Payment Id 392125 for invoice:257627, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:05','',''),('5','92',4960496,'','6.1','2221',113400.00,0.00,'Payment Id 392126 for invoice:257627, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:16','',''),('5','92',4960497,'','supplier','100',0.00,113400.00,'Payment Id 392126 for invoice:257627, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:16','',''),('5','92',4960498,'','6.1','2221',13400.00,0.00,'Payment Id 392128 for invoice:257628, receipt: 0059 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:25','',''),('5','92',4960499,'','supplier','100',0.00,13400.00,'Payment Id 392128 for invoice:257628, receipt: 0059 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:25','',''),('5','92',4960500,'','2','2220',1009500.00,0.00,'Payment Id 392127 for invoice:257628, receipt: 0059 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:38','',''),('5','92',4960501,'','supplier','100',0.00,1009500.00,'Payment Id 392127 for invoice:257628, receipt: 0059 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:38','',''),('5','92',4960502,'','2','2220',815605.00,0.00,'Payment Id 392129 for invoice:257629, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:49','',''),('5','92',4960503,'','supplier','100',0.00,815605.00,'Payment Id 392129 for invoice:257629, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:44:49','',''),('5','92',4960504,'','6.1','2221',13400.00,0.00,'Payment Id 392130 for invoice:257629, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:45:02','',''),('5','92',4960505,'','supplier','100',0.00,13400.00,'Payment Id 392130 for invoice:257629, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:45:02','',''),('5','92',4960506,'','2','2220',618955.00,0.00,'Payment Id 392131 for invoice:257630, receipt: 0054 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:45:16','',''),('5','92',4960507,'','supplier','100',0.00,618955.00,'Payment Id 392131 for invoice:257630, receipt: 0054 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:45:16','',''),('5','92',4960508,'','6.1','2221',13400.00,0.00,'Payment Id 392132 for invoice:257630, receipt: 0054 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:45:40','',''),('5','92',4960509,'','supplier','100',0.00,13400.00,'Payment Id 392132 for invoice:257630, receipt: 0054 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-14 08:45:40','',''),('5','92',4960510,'','24','2219',0.00,5550000.00,'Purchase Id 88775 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-07-16 10:45:15','',''),('5','92',4960511,'','supplier','100',5550000.00,0.00,'Purchase Id 88775 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-07-16 10:45:15','',''),('5','92',4960512,'','20','2222',457643.75,0.00,'Sales from shift 257632 on 2022-07-17 14:25:18 ','2022-07-17 14:25:18','',''),('5','92',4960513,'','6.1','2221',0.00,457643.75,'Sales from shift 257632 on 2022-07-17 14:25:18 ','2022-07-17 14:25:18','',''),('5','92',4960514,'','20','2222',872323.65,0.00,'Sales from shift 257633 on 2022-07-17 14:28:48 ','2022-07-17 14:28:48','',''),('5','92',4960515,'','6.1','2221',0.00,872323.65,'Sales from shift 257633 on 2022-07-17 14:28:48 ','2022-07-17 14:28:48','',''),('5','92',4960516,'','20','2222',1297716.75,0.00,'Sales from shift 257634 on 2022-07-17 14:32:27 ','2022-07-17 14:32:27','',''),('5','92',4960517,'','6.1','2221',0.00,1297716.75,'Sales from shift 257634 on 2022-07-17 14:32:27 ','2022-07-17 14:32:27','',''),('5','92',4960518,'','20','2222',852217.30,0.00,'Sales from shift 257635 on 2022-07-18 11:30:07 ','2022-07-18 11:30:07','',''),('5','92',4960519,'','6.1','2221',0.00,852217.30,'Sales from shift 257635 on 2022-07-18 11:30:07 ','2022-07-18 11:30:07','',''),('5','92',4960520,'','20','2222',845320.50,0.00,'Sales from shift 257636 on 2022-07-19 06:53:01 ','2022-07-19 06:53:01','',''),('5','92',4960521,'','6.1','2221',0.00,845320.50,'Sales from shift 257636 on 2022-07-19 06:53:01 ','2022-07-19 06:53:01','',''),('5','92',4960522,'','2','2220',613375.00,0.00,'Payment Id 392133 for invoice:257631, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 10:11:15','',''),('5','92',4960523,'','supplier','100',0.00,613375.00,'Payment Id 392133 for invoice:257631, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 10:11:15','',''),('5','92',4960524,'','6.1','2221',13400.00,0.00,'Payment Id 392134 for invoice:257631, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 10:11:24','',''),('5','92',4960525,'','supplier','100',0.00,13400.00,'Payment Id 392134 for invoice:257631, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 10:11:24','',''),('5','92',4960526,'','2','2220',444245.00,0.00,'Payment Id 392135 for invoice:257632, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 10:11:32','',''),('5','92',4960527,'','supplier','100',0.00,444245.00,'Payment Id 392135 for invoice:257632, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 10:11:32','',''),('5','92',4960528,'','6.1','2221',13400.00,0.00,'Payment Id 392136 for invoice:257632, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 10:11:40','',''),('5','92',4960529,'','supplier','100',0.00,13400.00,'Payment Id 392136 for invoice:257632, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 10:11:40','',''),('5','92',4960530,'','24','2219',0.00,6105000.00,'Purchase Id 88776 for 33,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 22:36:12','',''),('5','92',4960531,'','supplier','100',6105000.00,0.00,'Purchase Id 88776 for 33,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-07-19 22:36:12','',''),('5','92',4960532,'','20','2222',2103183.60,0.00,'Sales from shift 257637 on 2022-07-20 09:41:36 ','2022-07-20 09:41:36','',''),('5','92',4960533,'','6.1','2221',0.00,2103183.60,'Sales from shift 257637 on 2022-07-20 09:41:36 ','2022-07-20 09:41:36','',''),('5','92',4960534,'','20','2222',1555428.20,0.00,'Sales from shift 257638 on 2022-07-20 19:12:06 ','2022-07-20 19:12:06','',''),('5','92',4960535,'','6.1','2221',0.00,1555428.20,'Sales from shift 257638 on 2022-07-20 19:12:06 ','2022-07-20 19:12:06','',''),('5','92',4960536,'','2','2220',964660.00,0.00,'Payment Id 392137 for invoice:257633, receipt: 0048 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:12:39','',''),('5','92',4960537,'','supplier','100',0.00,964660.00,'Payment Id 392137 for invoice:257633, receipt: 0048 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:12:39','',''),('5','92',4960538,'','6.1','2221',13400.00,0.00,'Payment Id 392138 for invoice:257633, receipt: 0048 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:12:47','',''),('5','92',4960539,'','supplier','100',0.00,13400.00,'Payment Id 392138 for invoice:257633, receipt: 0048 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:12:47','',''),('5','92',4960540,'','2','2220',1206615.00,0.00,'Payment Id 392139 for invoice:257634, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:13:23','',''),('5','92',4960541,'','supplier','100',0.00,1206615.00,'Payment Id 392139 for invoice:257634, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:13:23','',''),('5','92',4960542,'','6.1','2221',248400.00,0.00,'Payment Id 392140 for invoice:257634, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:13:33','',''),('5','92',4960543,'','supplier','100',0.00,248400.00,'Payment Id 392140 for invoice:257634, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:13:33','',''),('5','92',4960544,'','2','2220',838705.00,0.00,'Payment Id 392141 for invoice:257635, receipt: 0050 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:13:42','',''),('5','92',4960545,'','supplier','100',0.00,838705.00,'Payment Id 392141 for invoice:257635, receipt: 0050 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:13:42','',''),('5','92',4960546,'','6.1','2221',13400.00,0.00,'Payment Id 392142 for invoice:257635, receipt: 0050 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:15:35','',''),('5','92',4960547,'','supplier','100',0.00,13400.00,'Payment Id 392142 for invoice:257635, receipt: 0050 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:15:35','',''),('5','92',4960548,'','2','2220',831920.00,0.00,'Payment Id 392143 for invoice:257636, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:15:47','',''),('5','92',4960549,'','supplier','100',0.00,831920.00,'Payment Id 392143 for invoice:257636, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:15:47','',''),('5','92',4960550,'','6.1','2221',13400.00,0.00,'Payment Id 392144 for invoice:257636, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:15:59','',''),('5','92',4960551,'','supplier','100',0.00,13400.00,'Payment Id 392144 for invoice:257636, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-20 19:15:59','',''),('5','92',4960552,'','2','2220',2089785.00,0.00,'Payment Id 392145 for invoice:257637, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-21 11:26:20','',''),('5','92',4960553,'','supplier','100',0.00,2089785.00,'Payment Id 392145 for invoice:257637, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-21 11:26:20','',''),('5','92',4960554,'','6.1','2221',13400.00,0.00,'Payment Id 392146 for invoice:257637, receipt: 0023 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-21 11:26:28','',''),('5','92',4960555,'','supplier','100',0.00,13400.00,'Payment Id 392146 for invoice:257637, receipt: 0023 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-21 11:26:28','',''),('5','92',4960556,'','20','2222',1692798.10,0.00,'Sales from shift 257639 on 2022-07-22 16:10:50 ','2022-07-22 16:10:50','',''),('5','92',4960557,'','6.1','2221',0.00,1692798.10,'Sales from shift 257639 on 2022-07-22 16:10:50 ','2022-07-22 16:10:50','',''),('5','92',4960558,'','2','2220',1542030.00,0.00,'Payment Id 392147 for invoice:257638, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-22 16:11:07','',''),('5','92',4960559,'','supplier','100',0.00,1542030.00,'Payment Id 392147 for invoice:257638, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-22 16:11:07','',''),('5','92',4960560,'','6.1','2221',13400.00,0.00,'Payment Id 392148 for invoice:257638, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-22 16:11:22','',''),('5','92',4960561,'','supplier','100',0.00,13400.00,'Payment Id 392148 for invoice:257638, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-22 16:11:22','',''),('5','92',4960562,'','20','2222',1191844.00,0.00,'Sales from shift 257640 on 2022-07-23 12:47:10 ','2022-07-23 12:47:10','',''),('5','92',4960563,'','6.1','2221',0.00,1191844.00,'Sales from shift 257640 on 2022-07-23 12:47:10 ','2022-07-23 12:47:10','',''),('5','92',4960564,'','24','2219',0.00,5624000.00,'Purchase Id 88777 for 30,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-07-23 21:47:50','',''),('5','92',4960565,'','supplier','100',5624000.00,0.00,'Purchase Id 88777 for 30,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-07-23 21:47:50','',''),('5','92',4960566,'','20','2222',1034956.60,0.00,'Sales from shift 257641 on 2022-07-25 09:21:10 ','2022-07-25 09:21:10','',''),('5','92',4960567,'','6.1','2221',0.00,1034956.60,'Sales from shift 257641 on 2022-07-25 09:21:10 ','2022-07-25 09:21:10','',''),('5','92',4960568,'','2','2220',1679400.00,0.00,'Payment Id 392149 for invoice:257639, receipt: 0074 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-25 09:24:01','',''),('5','92',4960569,'','supplier','100',0.00,1679400.00,'Payment Id 392149 for invoice:257639, receipt: 0074 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-25 09:24:01','',''),('5','92',4960570,'','6.1','2221',13400.00,0.00,'Payment Id 392150 for invoice:257639, receipt: 0074 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-25 09:24:09','',''),('5','92',4960571,'','supplier','100',0.00,13400.00,'Payment Id 392150 for invoice:257639, receipt: 0074 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-25 09:24:09','',''),('5','92',4960572,'','20','2222',849716.10,0.00,'Sales from shift 257642 on 2022-07-25 09:29:21 ','2022-07-25 09:29:21','',''),('5','92',4960573,'','6.1','2221',0.00,849716.10,'Sales from shift 257642 on 2022-07-25 09:29:21 ','2022-07-25 09:29:21','',''),('5','92',4960574,'','20','2222',1500020.70,0.00,'Sales from shift 257643 on 2022-07-26 10:48:51 ','2022-07-26 10:48:51','',''),('5','92',4960575,'','6.1','2221',0.00,1500020.70,'Sales from shift 257643 on 2022-07-26 10:48:51 ','2022-07-26 10:48:51','',''),('5','92',4960576,'','2','2220',1178445.00,0.00,'Payment Id 392151 for invoice:257640, receipt: 0010 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:49:15','',''),('5','92',4960577,'','supplier','100',0.00,1178445.00,'Payment Id 392151 for invoice:257640, receipt: 0010 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:49:15','',''),('5','92',4960578,'','6.1','2221',13400.00,0.00,'Payment Id 392152 for invoice:257640, receipt: 0010 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:19','',''),('5','92',4960579,'','supplier','100',0.00,13400.00,'Payment Id 392152 for invoice:257640, receipt: 0010 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:19','',''),('5','92',4960580,'','2','2220',934555.00,0.00,'Payment Id 392153 for invoice:257641, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:30','',''),('5','92',4960581,'','supplier','100',0.00,934555.00,'Payment Id 392153 for invoice:257641, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:30','',''),('5','92',4960582,'','2','2220',836315.00,0.00,'Payment Id 392155 for invoice:257642, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:38','',''),('5','92',4960583,'','supplier','100',0.00,836315.00,'Payment Id 392155 for invoice:257642, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:38','',''),('5','92',4960584,'','2','2220',836315.00,0.00,'Payment Id 392156 for invoice:257642, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:50','',''),('5','92',4960585,'','supplier','100',0.00,836315.00,'Payment Id 392156 for invoice:257642, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:50','',''),('5','92',4960586,'','6.1','2221',13400.00,0.00,'Payment Id 392157 for invoice:257642, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:58','',''),('5','92',4960587,'','supplier','100',0.00,13400.00,'Payment Id 392157 for invoice:257642, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:50:58','',''),('5','92',4960588,'','6.1','2221',100410.00,0.00,'Payment Id 392154 for invoice:257641, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:51:37','',''),('5','92',4960589,'','supplier','100',0.00,100410.00,'Payment Id 392154 for invoice:257641, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-26 10:51:37','',''),('5','92',4960590,'','20','2222',997114.85,0.00,'Sales from shift 257644 on 2022-07-26 21:03:18 ','2022-07-26 21:03:18','',''),('5','92',4960591,'','6.1','2221',0.00,997114.85,'Sales from shift 257644 on 2022-07-26 21:03:18 ','2022-07-26 21:03:18','',''),('5','92',4960592,'','2','2220',1486620.00,0.00,'Payment Id 392158 for invoice:257643, receipt: 0031 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-27 09:38:45','',''),('5','92',4960593,'','supplier','100',0.00,1486620.00,'Payment Id 392158 for invoice:257643, receipt: 0031 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-27 09:38:45','',''),('5','92',4960594,'','6.1','2221',13400.00,0.00,'Payment Id 392159 for invoice:257643, receipt: 0031 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-27 09:38:59','',''),('5','92',4960595,'','supplier','100',0.00,13400.00,'Payment Id 392159 for invoice:257643, receipt: 0031 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-27 09:38:59','',''),('5','92',4960596,'','20','2222',2210133.95,0.00,'Sales from shift 257645 on 2022-07-28 10:41:17 ','2022-07-28 10:41:17','',''),('5','92',4960597,'','6.1','2221',0.00,2210133.95,'Sales from shift 257645 on 2022-07-28 10:41:17 ','2022-07-28 10:41:17','',''),('5','92',4960598,'','2','2220',983715.00,0.00,'Payment Id 392160 for invoice:257644, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-28 11:46:21','',''),('5','92',4960599,'','supplier','100',0.00,983715.00,'Payment Id 392160 for invoice:257644, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-28 11:46:21','',''),('5','92',4960600,'','6.1','2221',13400.00,0.00,'Payment Id 392161 for invoice:257644, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-28 11:46:29','',''),('5','92',4960601,'','supplier','100',0.00,13400.00,'Payment Id 392161 for invoice:257644, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-28 11:46:29','',''),('5','92',4960602,'','20','2222',52101.55,0.00,'Sales from shift 257646 on 2022-07-31 13:14:57 ','2022-07-31 13:14:57','',''),('5','92',4960603,'','6.1','2221',0.00,52101.55,'Sales from shift 257646 on 2022-07-31 13:14:57 ','2022-07-31 13:14:57','',''),('5','92',4960604,'','2','2220',2196735.00,0.00,'Payment Id 392162 for invoice:257645, receipt: 0034 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-31 13:15:12','',''),('5','92',4960605,'','supplier','100',0.00,2196735.00,'Payment Id 392162 for invoice:257645, receipt: 0034 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-31 13:15:12','',''),('5','92',4960606,'','6.1','2221',13400.00,0.00,'Payment Id 392163 for invoice:257645, receipt: 0034 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-31 13:15:22','',''),('5','92',4960607,'','supplier','100',0.00,13400.00,'Payment Id 392163 for invoice:257645, receipt: 0034 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-31 13:15:22','',''),('5','92',4960608,'','2','2220',11200.00,0.00,'Payment Id 392164 for invoice:257646, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-31 13:15:39','',''),('5','92',4960609,'','supplier','100',0.00,11200.00,'Payment Id 392164 for invoice:257646, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-31 13:15:39','',''),('5','92',4960610,'','6.1','2221',40900.00,0.00,'Payment Id 392165 for invoice:257646, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-31 13:15:56','',''),('5','92',4960611,'','supplier','100',0.00,40900.00,'Payment Id 392165 for invoice:257646, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-07-31 13:15:56','',''),('5','92',4960612,'','20','2222',0.00,0.00,'Sales from shift 257647 on 2022-08-01 09:27:26 ','2022-08-01 09:27:26','',''),('5','92',4960613,'','6.1','2221',0.00,0.00,'Sales from shift 257647 on 2022-08-01 09:27:26 ','2022-08-01 09:27:26','',''),('5','92',4960614,'','20','2222',0.00,0.00,'Sales from shift 257648 on 2022-08-01 09:31:36 ','2022-08-01 09:31:36','',''),('5','92',4960615,'','6.1','2221',0.00,0.00,'Sales from shift 257648 on 2022-08-01 09:31:36 ','2022-08-01 09:31:36','',''),('5','92',4960616,'','20','2222',0.00,0.00,'Sales from shift 257649 on 2022-08-01 09:34:32 ','2022-08-01 09:34:32','',''),('5','92',4960617,'','6.1','2221',0.00,0.00,'Sales from shift 257649 on 2022-08-01 09:34:32 ','2022-08-01 09:34:32','',''),('5','92',4960618,'','20','2222',0.00,0.00,'Sales from shift 257650 on 2022-08-01 09:44:06 ','2022-08-01 09:44:06','',''),('5','92',4960619,'','6.1','2221',0.00,0.00,'Sales from shift 257650 on 2022-08-01 09:44:06 ','2022-08-01 09:44:06','',''),('5','92',4960620,'','24','2219',0.00,5550000.00,'Purchase Id 88778 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-08-02 14:46:11','',''),('5','92',4960621,'','supplier','100',5550000.00,0.00,'Purchase Id 88778 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-08-02 14:46:11','',''),('5','92',4960622,'','20','2222',921875.35,0.00,'Sales from shift 257651 on 2022-08-02 21:26:44 ','2022-08-02 21:26:44','',''),('5','92',4960623,'','6.1','2221',0.00,921875.35,'Sales from shift 257651 on 2022-08-02 21:26:44 ','2022-08-02 21:26:44','',''),('5','92',4960624,'','20','2222',1028538.95,0.00,'Sales from shift 257652 on 2022-08-04 10:50:15 ','2022-08-04 10:50:15','',''),('5','92',4960625,'','6.1','2221',0.00,1028538.95,'Sales from shift 257652 on 2022-08-04 10:50:15 ','2022-08-04 10:50:15','',''),('5','92',4960626,'','20','2222',1139448.30,0.00,'Sales from shift 257653 on 2022-08-05 10:35:04 ','2022-08-05 10:35:04','',''),('5','92',4960627,'','6.1','2221',0.00,1139448.30,'Sales from shift 257653 on 2022-08-05 10:35:04 ','2022-08-05 10:35:04','',''),('5','92',4960628,'','2','2220',906475.00,0.00,'Payment Id 392166 for invoice:257651, receipt: 0073 by SALBAS OIL & GAS NIGERIA LIMIT','2022-08-05 10:35:29','',''),('5','92',4960629,'','supplier','100',0.00,906475.00,'Payment Id 392166 for invoice:257651, receipt: 0073 by SALBAS OIL & GAS NIGERIA LIMIT','2022-08-05 10:35:29','',''),('5','92',4960630,'','6.1','2221',15400.00,0.00,'Payment Id 392167 for invoice:257651, receipt: 0073 by SALBAS OIL & GAS NIGERIA LIMIT','2022-08-05 10:35:43','',''),('5','92',4960631,'','supplier','100',0.00,15400.00,'Payment Id 392167 for invoice:257651, receipt: 0073 by SALBAS OIL & GAS NIGERIA LIMIT','2022-08-05 10:35:43','',''),('5','92',4960632,'','2','2220',1015140.00,0.00,'Payment Id 392168 for invoice:257652, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-08-05 10:35:51','',''),('5','92',4960633,'','supplier','100',0.00,1015140.00,'Payment Id 392168 for invoice:257652, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-08-05 10:35:51','',''),('5','92',4960634,'','6.1','2221',13400.00,0.00,'Payment Id 392169 for invoice:257652, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-08-05 10:36:01','',''),('5','92',4960635,'','supplier','100',0.00,13400.00,'Payment Id 392169 for invoice:257652, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-08-05 10:36:01','',''),('5','92',4960636,'','20','2222',1933566.35,0.00,'Sales from shift 257654 on 2022-08-06 14:45:25 ','2022-08-06 14:45:25','',''),('5','92',4960637,'','6.1','2221',0.00,1933566.35,'Sales from shift 257654 on 2022-08-06 14:45:25 ','2022-08-06 14:45:25','',''),('5','92',4960638,'','20','2222',583884.05,0.00,'Sales from shift 257655 on 2022-08-07 21:33:57 ','2022-08-07 21:33:57','',''),('5','92',4960639,'','6.1','2221',0.00,583884.05,'Sales from shift 257655 on 2022-08-07 21:33:57 ','2022-08-07 21:33:57','',''),('5','92',4960640,'','20','2222',0.00,0.00,'Sales from shift 257656 on 2022-08-07 22:23:07 ','2022-08-07 22:23:07','',''),('5','92',4960641,'','6.1','2221',0.00,0.00,'Sales from shift 257656 on 2022-08-07 22:23:07 ','2022-08-07 22:23:07','',''),('5','92',4960642,'','24','2219',0.00,5550000.00,'Purchase Id 88779 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-05 14:35:27','',''),('5','92',4960643,'','supplier','100',5550000.00,0.00,'Purchase Id 88779 for 30,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-05 14:35:27','',''),('5','92',4960644,'','20','2222',0.00,0.00,'Sales from shift 257657 on 2022-09-05 14:53:18 ','2022-09-05 14:53:18','',''),('5','92',4960645,'','6.1','2221',0.00,0.00,'Sales from shift 257657 on 2022-09-05 14:53:18 ','2022-09-05 14:53:18','',''),('5','92',4960646,'','20','2222',0.00,0.00,'Sales from shift 257658 on 2022-09-05 14:55:25 ','2022-09-05 14:55:25','',''),('5','92',4960647,'','6.1','2221',0.00,0.00,'Sales from shift 257658 on 2022-09-05 14:55:25 ','2022-09-05 14:55:25','',''),('5','92',4960648,'','20','2222',237623.25,0.00,'Sales from shift 257659 on 2022-09-05 14:59:42 ','2022-09-05 14:59:42','',''),('5','92',4960649,'','6.1','2221',0.00,237623.25,'Sales from shift 257659 on 2022-09-05 14:59:42 ','2022-09-05 14:59:42','',''),('5','92',4960650,'','20','2222',719563.05,0.00,'Sales from shift 257660 on 2022-09-05 15:02:46 ','2022-09-05 15:02:46','',''),('5','92',4960651,'','6.1','2221',0.00,719563.05,'Sales from shift 257660 on 2022-09-05 15:02:46 ','2022-09-05 15:02:46','',''),('5','92',4960652,'','20','2222',928341.10,0.00,'Sales from shift 257661 on 2022-09-05 15:06:18 ','2022-09-05 15:06:18','',''),('5','92',4960653,'','6.1','2221',0.00,928341.10,'Sales from shift 257661 on 2022-09-05 15:06:18 ','2022-09-05 15:06:18','',''),('5','92',4960654,'','20','2222',710960.55,0.00,'Sales from shift 257662 on 2022-09-05 15:08:47 ','2022-09-05 15:08:47','',''),('5','92',4960655,'','6.1','2221',0.00,710960.55,'Sales from shift 257662 on 2022-09-05 15:08:47 ','2022-09-05 15:08:47','',''),('5','92',4960656,'','20','2222',993631.30,0.00,'Sales from shift 257663 on 2022-09-05 15:13:45 ','2022-09-05 15:13:45','',''),('5','92',4960657,'','6.1','2221',0.00,993631.30,'Sales from shift 257663 on 2022-09-05 15:13:45 ','2022-09-05 15:13:45','',''),('5','92',4960658,'','20','2222',825814.10,0.00,'Sales from shift 257664 on 2022-09-05 15:18:41 ','2022-09-05 15:18:41','',''),('5','92',4960659,'','6.1','2221',0.00,825814.10,'Sales from shift 257664 on 2022-09-05 15:18:41 ','2022-09-05 15:18:41','',''),('5','92',4960660,'','20','2222',745648.05,0.00,'Sales from shift 257665 on 2022-09-05 15:20:37 ','2022-09-05 15:20:37','',''),('5','92',4960661,'','6.1','2221',0.00,745648.05,'Sales from shift 257665 on 2022-09-05 15:20:37 ','2022-09-05 15:20:37','',''),('5','92',4960662,'','24','2219',0.00,4144000.00,'Purchase Id 88780 for 22,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-05 15:24:00','',''),('5','92',4960663,'','supplier','100',4144000.00,0.00,'Purchase Id 88780 for 22,400.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-05 15:24:00','',''),('5','92',4960664,'','20','2222',441343.40,0.00,'Sales from shift 257666 on 2022-09-05 15:32:08 ','2022-09-05 15:32:08','',''),('5','92',4960665,'','6.1','2221',0.00,441343.40,'Sales from shift 257666 on 2022-09-05 15:32:08 ','2022-09-05 15:32:08','',''),('5','92',4960666,'','20','2222',867777.65,0.00,'Sales from shift 257667 on 2022-09-05 15:34:45 ','2022-09-05 15:34:45','',''),('5','92',4960667,'','6.1','2221',0.00,867777.65,'Sales from shift 257667 on 2022-09-05 15:34:45 ','2022-09-05 15:34:45','',''),('5','92',4960668,'','20','2222',906128.15,0.00,'Sales from shift 257668 on 2022-09-05 15:37:14 ','2022-09-05 15:37:14','',''),('5','92',4960669,'','6.1','2221',0.00,906128.15,'Sales from shift 257668 on 2022-09-05 15:37:14 ','2022-09-05 15:37:14','',''),('5','92',4960670,'','20','2222',373811.00,0.00,'Sales from shift 257669 on 2022-09-05 15:43:09 ','2022-09-05 15:43:09','',''),('5','92',4960671,'','6.1','2221',0.00,373811.00,'Sales from shift 257669 on 2022-09-05 15:43:09 ','2022-09-05 15:43:09','',''),('5','92',4960672,'','20','2222',1083837.30,0.00,'Sales from shift 257670 on 2022-09-05 15:46:12 ','2022-09-05 15:46:12','',''),('5','92',4960673,'','6.1','2221',0.00,1083837.30,'Sales from shift 257670 on 2022-09-05 15:46:12 ','2022-09-05 15:46:12','',''),('5','92',4960674,'','24','2219',0.00,8288000.00,'Purchase Id 88781 for 44,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-05 16:09:48','',''),('5','92',4960675,'','supplier','100',8288000.00,0.00,'Purchase Id 88781 for 44,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-05 16:09:48','',''),('5','92',4960676,'','20','2222',885467.35,0.00,'Sales from shift 257671 on 2022-09-06 11:53:50 ','2022-09-06 11:53:50','',''),('5','92',4960677,'','6.1','2221',0.00,885467.35,'Sales from shift 257671 on 2022-09-06 11:53:50 ','2022-09-06 11:53:50','',''),('5','92',4960678,'','20','2222',670504.75,0.00,'Sales from shift 257672 on 2022-09-06 11:58:26 ','2022-09-06 11:58:26','',''),('5','92',4960679,'','6.1','2221',0.00,670504.75,'Sales from shift 257672 on 2022-09-06 11:58:26 ','2022-09-06 11:58:26','',''),('5','92',4960680,'','20','2222',727699.35,0.00,'Sales from shift 257673 on 2022-09-06 12:01:13 ','2022-09-06 12:01:13','',''),('5','92',4960681,'','6.1','2221',0.00,727699.35,'Sales from shift 257673 on 2022-09-06 12:01:13 ','2022-09-06 12:01:13','',''),('5','92',4960682,'','20','2222',925358.90,0.00,'Sales from shift 257674 on 2022-09-06 12:06:33 ','2022-09-06 12:06:33','',''),('5','92',4960683,'','6.1','2221',0.00,925358.90,'Sales from shift 257674 on 2022-09-06 12:06:33 ','2022-09-06 12:06:33','',''),('5','92',4960684,'','20','2222',643457.75,0.00,'Sales from shift 257675 on 2022-09-06 12:09:47 ','2022-09-06 12:09:47','',''),('5','92',4960685,'','6.1','2221',0.00,643457.75,'Sales from shift 257675 on 2022-09-06 12:09:47 ','2022-09-06 12:09:47','',''),('5','92',4960686,'','20','2222',447674.10,0.00,'Sales from shift 257676 on 2022-09-06 12:13:38 ','2022-09-06 12:13:38','',''),('5','92',4960687,'','6.1','2221',0.00,447674.10,'Sales from shift 257676 on 2022-09-06 12:13:38 ','2022-09-06 12:13:38','',''),('5','92',4960688,'','20','2222',840941.55,0.00,'Sales from shift 257677 on 2022-09-06 12:16:37 ','2022-09-06 12:16:37','',''),('5','92',4960689,'','6.1','2221',0.00,840941.55,'Sales from shift 257677 on 2022-09-06 12:16:37 ','2022-09-06 12:16:37','',''),('5','92',4960690,'','20','2222',462853.35,0.00,'Sales from shift 257678 on 2022-09-06 12:19:44 ','2022-09-06 12:19:44','',''),('5','92',4960691,'','6.1','2221',0.00,462853.35,'Sales from shift 257678 on 2022-09-06 12:19:44 ','2022-09-06 12:19:44','',''),('5','92',4960692,'','20','2222',1004481.55,0.00,'Sales from shift 257679 on 2022-09-06 12:22:53 ','2022-09-06 12:22:53','',''),('5','92',4960693,'','6.1','2221',0.00,1004481.55,'Sales from shift 257679 on 2022-09-06 12:22:53 ','2022-09-06 12:22:53','',''),('5','92',4960694,'','20','2222',621583.35,0.00,'Sales from shift 257680 on 2022-09-06 12:32:28 ','2022-09-06 12:32:28','',''),('5','92',4960695,'','6.1','2221',0.00,621583.35,'Sales from shift 257680 on 2022-09-06 12:32:28 ','2022-09-06 12:32:28','',''),('5','92',4960696,'','24','2219',0.00,1813000.00,'Purchase Id 88782 for 9,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-06 12:32:57','',''),('5','92',4960697,'','supplier','100',1813000.00,0.00,'Purchase Id 88782 for 9,800.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-06 12:32:57','',''),('5','92',4960698,'','20','2222',1056849.50,0.00,'Sales from shift 257681 on 2022-09-06 13:15:48 ','2022-09-06 13:15:48','',''),('5','92',4960699,'','6.1','2221',0.00,1056849.50,'Sales from shift 257681 on 2022-09-06 13:15:48 ','2022-09-06 13:15:48','',''),('5','92',4960700,'','20','2222',778222.85,0.00,'Sales from shift 257682 on 2022-09-06 14:02:55 ','2022-09-06 14:02:55','',''),('5','92',4960701,'','6.1','2221',0.00,778222.85,'Sales from shift 257682 on 2022-09-06 14:02:55 ','2022-09-06 14:02:55','',''),('5','92',4960702,'','20','2222',29672.15,0.00,'Sales from shift 257683 on 2022-09-06 14:13:01 ','2022-09-06 14:13:01','',''),('5','92',4960703,'','6.1','2221',0.00,29672.15,'Sales from shift 257683 on 2022-09-06 14:13:01 ','2022-09-06 14:13:01','',''),('5','92',4960704,'','24','2219',0.00,3838750.00,'Purchase Id 88783 for 20,750.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-06 14:19:23','',''),('5','92',4960705,'','supplier','100',3838750.00,0.00,'Purchase Id 88783 for 20,750.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-06 14:19:23','',''),('5','92',4960706,'','2','2220',1101050.00,0.00,'Payment Id 392170 for invoice:257653, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-06 14:42:35','',''),('5','92',4960707,'','supplier','100',0.00,1101050.00,'Payment Id 392170 for invoice:257653, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-06 14:42:35','',''),('5','92',4960708,'','6.1','2221',38400.00,0.00,'Payment Id 392171 for invoice:257653, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-06 14:42:48','',''),('5','92',4960709,'','supplier','100',0.00,38400.00,'Payment Id 392171 for invoice:257653, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-06 14:42:48','',''),('5','92',4960710,'','20','2222',0.00,0.00,'Sales from shift 257684 on 2022-09-06 15:00:13 ','2022-09-06 15:00:13','',''),('5','92',4960711,'','6.1','2221',0.00,0.00,'Sales from shift 257684 on 2022-09-06 15:00:13 ','2022-09-06 15:00:13','',''),('5','92',4960712,'','20','2222',526352.75,0.00,'Sales from shift 257685 on 2022-09-06 15:03:03 ','2022-09-06 15:03:03','',''),('5','92',4960713,'','6.1','2221',0.00,526352.75,'Sales from shift 257685 on 2022-09-06 15:03:03 ','2022-09-06 15:03:03','',''),('5','92',4960714,'','20','2222',1007128.90,0.00,'Sales from shift 257686 on 2022-09-07 10:03:40 ','2022-09-07 10:03:40','',''),('5','92',4960715,'','6.1','2221',0.00,1007128.90,'Sales from shift 257686 on 2022-09-07 10:03:40 ','2022-09-07 10:03:40','',''),('5','92',4960716,'','2','2220',604685.00,0.00,'Payment Id 392219 for invoice:257680, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:03:58','',''),('5','92',4960717,'','supplier','100',0.00,604685.00,'Payment Id 392219 for invoice:257680, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:03:58','',''),('5','92',4960718,'','6.1','2221',16900.00,0.00,'Payment Id 392220 for invoice:257680, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:08','',''),('5','92',4960719,'','supplier','100',0.00,16900.00,'Payment Id 392220 for invoice:257680, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:08','',''),('5','92',4960720,'','2','2220',1031750.00,0.00,'Payment Id 392221 for invoice:257681, receipt: 0146730 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:17','',''),('5','92',4960721,'','supplier','100',0.00,1031750.00,'Payment Id 392221 for invoice:257681, receipt: 0146730 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:17','',''),('5','92',4960722,'','6.1','2221',25100.00,0.00,'Payment Id 392222 for invoice:257681, receipt: 0146730 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:26','',''),('5','92',4960723,'','supplier','100',0.00,25100.00,'Payment Id 392222 for invoice:257681, receipt: 0146730 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:26','',''),('5','92',4960724,'','2','2220',755820.00,0.00,'Payment Id 392223 for invoice:257682, receipt: 0032 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:37','',''),('5','92',4960725,'','supplier','100',0.00,755820.00,'Payment Id 392223 for invoice:257682, receipt: 0032 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:37','',''),('5','92',4960726,'','6.1','2221',22400.00,0.00,'Payment Id 392224 for invoice:257682, receipt: 0032 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:53','',''),('5','92',4960727,'','supplier','100',0.00,22400.00,'Payment Id 392224 for invoice:257682, receipt: 0032 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:04:53','',''),('5','92',4960728,'','2','2220',26270.00,0.00,'Payment Id 392225 for invoice:257683, receipt: 0031 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:05:04','',''),('5','92',4960729,'','supplier','100',0.00,26270.00,'Payment Id 392225 for invoice:257683, receipt: 0031 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:05:04','',''),('5','92',4960730,'','6.1','2221',3400.00,0.00,'Payment Id 392226 for invoice:257683, receipt: 0031 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:05:12','',''),('5','92',4960731,'','supplier','100',0.00,3400.00,'Payment Id 392226 for invoice:257683, receipt: 0031 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:05:12','',''),('5','92',4960732,'','2','2220',487920.00,0.00,'Payment Id 392227 for invoice:257685, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:06:17','',''),('5','92',4960733,'','supplier','100',0.00,487920.00,'Payment Id 392227 for invoice:257685, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:06:17','',''),('5','92',4960734,'','6.1','2221',38400.00,0.00,'Payment Id 392228 for invoice:257685, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:06:43','',''),('5','92',4960735,'','supplier','100',0.00,38400.00,'Payment Id 392228 for invoice:257685, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:06:43','',''),('5','92',4960736,'','2','2220',1070435.00,0.00,'Payment Id 392199 for invoice:257670, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:07:21','',''),('5','92',4960737,'','supplier','100',0.00,1070435.00,'Payment Id 392199 for invoice:257670, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:07:21','',''),('5','92',4960738,'','6.1','2221',13400.00,0.00,'Payment Id 392200 for invoice:257670, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:07:45','',''),('5','92',4960739,'','supplier','100',0.00,13400.00,'Payment Id 392200 for invoice:257670, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:07:45','',''),('5','92',4960740,'','2','2220',836030.00,0.00,'Payment Id 392201 for invoice:257671, receipt: 0068 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:08:06','',''),('5','92',4960741,'','supplier','100',0.00,836030.00,'Payment Id 392201 for invoice:257671, receipt: 0068 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:08:06','',''),('5','92',4960742,'','6.1','2221',49400.00,0.00,'Payment Id 392202 for invoice:257671, receipt: 0068 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:08:18','',''),('5','92',4960743,'','supplier','100',0.00,49400.00,'Payment Id 392202 for invoice:257671, receipt: 0068 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:08:18','',''),('5','92',4960744,'','2','2220',642105.00,0.00,'Payment Id 392203 for invoice:257672, receipt: 0023 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:08:51','',''),('5','92',4960745,'','supplier','100',0.00,642105.00,'Payment Id 392203 for invoice:257672, receipt: 0023 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:08:51','',''),('5','92',4960746,'','6.1','2221',28400.00,0.00,'Payment Id 392204 for invoice:257672, receipt: 0023 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:03','',''),('5','92',4960747,'','supplier','100',0.00,28400.00,'Payment Id 392204 for invoice:257672, receipt: 0023 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:03','',''),('5','92',4960748,'','2','2220',714300.00,0.00,'Payment Id 392205 for invoice:257673, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:11','',''),('5','92',4960749,'','supplier','100',0.00,714300.00,'Payment Id 392205 for invoice:257673, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:11','',''),('5','92',4960750,'','2','2220',911960.00,0.00,'Payment Id 392207 for invoice:257674, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:21','',''),('5','92',4960751,'','supplier','100',0.00,911960.00,'Payment Id 392207 for invoice:257674, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:21','',''),('5','92',4960752,'','6.1','2221',13400.00,0.00,'Payment Id 392206 for invoice:257673, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:35','',''),('5','92',4960753,'','supplier','100',0.00,13400.00,'Payment Id 392206 for invoice:257673, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:35','',''),('5','92',4960754,'','6.1','2221',13400.00,0.00,'Payment Id 392208 for invoice:257674, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:44','',''),('5','92',4960755,'','supplier','100',0.00,13400.00,'Payment Id 392208 for invoice:257674, receipt: 0045 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:09:44','',''),('5','92',4960756,'','6.1','2221',25400.00,0.00,'Payment Id 392179 for invoice:257660, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:12','',''),('5','92',4960757,'','supplier','100',0.00,25400.00,'Payment Id 392179 for invoice:257660, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:12','',''),('5','92',4960758,'','2','2220',914940.00,0.00,'Payment Id 392180 for invoice:257661, receipt: 0055 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:28','',''),('5','92',4960759,'','supplier','100',0.00,914940.00,'Payment Id 392180 for invoice:257661, receipt: 0055 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:28','',''),('5','92',4960760,'','6.1','2221',13400.00,0.00,'Payment Id 392181 for invoice:257661, receipt: 0055 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:37','',''),('5','92',4960761,'','supplier','100',0.00,13400.00,'Payment Id 392181 for invoice:257661, receipt: 0055 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:37','',''),('5','92',4960762,'','2','2220',697560.00,0.00,'Payment Id 392182 for invoice:257662, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:44','',''),('5','92',4960763,'','supplier','100',0.00,697560.00,'Payment Id 392182 for invoice:257662, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:44','',''),('5','92',4960764,'','6.1','2221',13400.00,0.00,'Payment Id 392183 for invoice:257662, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:53','',''),('5','92',4960765,'','supplier','100',0.00,13400.00,'Payment Id 392183 for invoice:257662, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:10:53','',''),('5','92',4960766,'','2','2220',760230.00,0.00,'Payment Id 392184 for invoice:257663, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:01','',''),('5','92',4960767,'','supplier','100',0.00,760230.00,'Payment Id 392184 for invoice:257663, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:01','',''),('5','92',4960768,'','6.1','2221',233400.00,0.00,'Payment Id 392185 for invoice:257663, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:20','',''),('5','92',4960769,'','supplier','100',0.00,233400.00,'Payment Id 392185 for invoice:257663, receipt: 0057 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:20','',''),('5','92',4960770,'','2','2220',812415.00,0.00,'Payment Id 392186 for invoice:257664, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:27','',''),('5','92',4960771,'','supplier','100',0.00,812415.00,'Payment Id 392186 for invoice:257664, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:27','',''),('5','92',4960772,'','6.1','2221',13400.00,0.00,'Payment Id 392187 for invoice:257664, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:39','',''),('5','92',4960773,'','supplier','100',0.00,13400.00,'Payment Id 392187 for invoice:257664, receipt: 0058 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:39','',''),('5','92',4960774,'','2','2220',732250.00,0.00,'Payment Id 392188 for invoice:257665, receipt: 0006 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:49','',''),('5','92',4960775,'','supplier','100',0.00,732250.00,'Payment Id 392188 for invoice:257665, receipt: 0006 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-07 10:11:49','',''),('5','92',4960776,'','20','2222',654413.45,0.00,'Sales from shift 257687 on 2022-09-08 10:04:07 ','2022-09-08 10:04:07','',''),('5','92',4960777,'','6.1','2221',0.00,654413.45,'Sales from shift 257687 on 2022-09-08 10:04:07 ','2022-09-08 10:04:07','',''),('5','92',4960778,'','20','2222',1095655.10,0.00,'Sales from shift 257688 on 2022-09-10 12:19:10 ','2022-09-10 12:19:10','',''),('5','92',4960779,'','6.1','2221',0.00,1095655.10,'Sales from shift 257688 on 2022-09-10 12:19:10 ','2022-09-10 12:19:10','',''),('5','92',4960780,'','20','2222',576619.10,0.00,'Sales from shift 257689 on 2022-09-11 16:59:01 ','2022-09-11 16:59:01','',''),('5','92',4960781,'','6.1','2221',0.00,576619.10,'Sales from shift 257689 on 2022-09-11 16:59:01 ','2022-09-11 16:59:01','',''),('5','92',4960782,'','20','2222',0.00,0.00,'Sales from shift 257690 on 2022-09-11 21:58:41 ','2022-09-11 21:58:41','',''),('5','92',4960783,'','6.1','2221',0.00,0.00,'Sales from shift 257690 on 2022-09-11 21:58:41 ','2022-09-11 21:58:41','',''),('5','92',4960784,'','20','2222',0.00,0.00,'Sales from shift 257691 on 2022-09-12 09:38:16 ','2022-09-12 09:38:16','',''),('5','92',4960785,'','6.1','2221',0.00,0.00,'Sales from shift 257691 on 2022-09-12 09:38:16 ','2022-09-12 09:38:16','',''),('5','92',4960786,'','2','2220',993730.00,0.00,'Payment Id 392229 for invoice:257686, receipt: 0034 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:55:13','',''),('5','92',4960787,'','supplier','100',0.00,993730.00,'Payment Id 392229 for invoice:257686, receipt: 0034 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:55:13','',''),('5','92',4960788,'','6.1','2221',13400.00,0.00,'Payment Id 392230 for invoice:257686, receipt: 0034 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:55:21','',''),('5','92',4960789,'','supplier','100',0.00,13400.00,'Payment Id 392230 for invoice:257686, receipt: 0034 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:55:21','',''),('5','92',4960790,'','2','2220',641015.00,0.00,'Payment Id 392231 for invoice:257687, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:55:46','',''),('5','92',4960791,'','supplier','100',0.00,641015.00,'Payment Id 392231 for invoice:257687, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:55:46','',''),('5','92',4960792,'','2','2220',1082255.00,0.00,'Payment Id 392233 for invoice:257688, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:55:54','',''),('5','92',4960793,'','supplier','100',0.00,1082255.00,'Payment Id 392233 for invoice:257688, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:55:54','',''),('5','92',4960794,'','6.1','2221',13400.00,0.00,'Payment Id 392234 for invoice:257688, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:56:01','',''),('5','92',4960795,'','supplier','100',0.00,13400.00,'Payment Id 392234 for invoice:257688, receipt: 0021 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:56:01','',''),('5','92',4960796,'','6.1','2221',13400.00,0.00,'Payment Id 392232 for invoice:257687, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:56:21','',''),('5','92',4960797,'','supplier','100',0.00,13400.00,'Payment Id 392232 for invoice:257687, receipt: 0030 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-12 13:56:21','',''),('5','92',4960798,'','20','2222',0.00,0.00,'Sales from shift 257692 on 2022-09-13 13:23:27 ','2022-09-13 13:23:27','',''),('5','92',4960799,'','6.1','2221',0.00,0.00,'Sales from shift 257692 on 2022-09-13 13:23:27 ','2022-09-13 13:23:27','',''),('5','92',4960800,'','20','2222',0.00,0.00,'Sales from shift 257693 on 2022-09-14 10:10:38 ','2022-09-14 10:10:38','',''),('5','92',4960801,'','6.1','2221',0.00,0.00,'Sales from shift 257693 on 2022-09-14 10:10:38 ','2022-09-14 10:10:38','',''),('5','92',4960802,'','20','2222',0.00,0.00,'Sales from shift 257694 on 2022-09-14 15:17:38 ','2022-09-14 15:17:38','',''),('5','92',4960803,'','6.1','2221',0.00,0.00,'Sales from shift 257694 on 2022-09-14 15:17:38 ','2022-09-14 15:17:38','',''),('5','92',4960804,'','24','2219',0.00,2775000.00,'Purchase Id 88784 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-16 08:03:16','',''),('5','92',4960805,'','supplier','100',2775000.00,0.00,'Purchase Id 88784 for 15,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-16 08:03:16','',''),('5','92',4960806,'','20','2222',404535.80,0.00,'Sales from shift 257695 on 2022-09-16 09:39:59 ','2022-09-16 09:39:59','',''),('5','92',4960807,'','6.1','2221',0.00,404535.80,'Sales from shift 257695 on 2022-09-16 09:39:59 ','2022-09-16 09:39:59','',''),('5','92',4960808,'','2','2220',328220.00,0.00,'Payment Id 392235 for invoice:257689, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-17 11:00:36','',''),('5','92',4960809,'','supplier','100',0.00,328220.00,'Payment Id 392235 for invoice:257689, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-17 11:00:36','',''),('5','92',4960810,'','6.1','2221',248400.00,0.00,'Payment Id 392236 for invoice:257689, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-17 11:00:46','',''),('5','92',4960811,'','supplier','100',0.00,248400.00,'Payment Id 392236 for invoice:257689, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-17 11:00:46','',''),('5','92',4960812,'','2','2220',379135.00,0.00,'Payment Id 392237 for invoice:257695, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-17 11:00:55','',''),('5','92',4960813,'','supplier','100',0.00,379135.00,'Payment Id 392237 for invoice:257695, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-17 11:00:55','',''),('5','92',4960814,'','6.1','2221',25400.00,0.00,'Payment Id 392238 for invoice:257695, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-17 11:01:02','',''),('5','92',4960815,'','supplier','100',0.00,25400.00,'Payment Id 392238 for invoice:257695, receipt: 0011 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-17 11:01:02','',''),('5','92',4960816,'','20','2222',0.00,0.00,'Sales from shift 257696 on 2022-09-17 15:30:41 ','2022-09-17 15:30:41','',''),('5','92',4960817,'','6.1','2221',0.00,0.00,'Sales from shift 257696 on 2022-09-17 15:30:41 ','2022-09-17 15:30:41','',''),('5','92',4960818,'','20','2222',784842.15,0.00,'Sales from shift 257697 on 2022-09-18 11:25:53 ','2022-09-18 11:25:53','',''),('5','92',4960819,'','6.1','2221',0.00,784842.15,'Sales from shift 257697 on 2022-09-18 11:25:53 ','2022-09-18 11:25:53','',''),('5','92',4960820,'','20','2222',916488.15,0.00,'Sales from shift 257698 on 2022-09-19 09:31:48 ','2022-09-19 09:31:48','',''),('5','92',4960821,'','6.1','2221',0.00,916488.15,'Sales from shift 257698 on 2022-09-19 09:31:48 ','2022-09-19 09:31:48','',''),('5','92',4960822,'','20','2222',687435.95,0.00,'Sales from shift 257699 on 2022-09-20 12:14:00 ','2022-09-20 12:14:00','',''),('5','92',4960823,'','6.1','2221',0.00,687435.95,'Sales from shift 257699 on 2022-09-20 12:14:00 ','2022-09-20 12:14:00','',''),('5','92',4960824,'','2','2220',771440.00,0.00,'Payment Id 392239 for invoice:257697, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:24:07','',''),('5','92',4960825,'','supplier','100',0.00,771440.00,'Payment Id 392239 for invoice:257697, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:24:07','',''),('5','92',4960826,'','2','2220',903085.00,0.00,'Payment Id 392241 for invoice:25798, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:24:49','',''),('5','92',4960827,'','supplier','100',0.00,903085.00,'Payment Id 392241 for invoice:25798, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:24:49','',''),('5','92',4960828,'','6.1','2221',13400.00,0.00,'Payment Id 392242 for invoice:257698, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:25:07','',''),('5','92',4960829,'','supplier','100',0.00,13400.00,'Payment Id 392242 for invoice:257698, receipt: 0041 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:25:07','',''),('5','92',4960830,'','6.1','2221',13400.00,0.00,'Payment Id 392240 for invoice:257697, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:25:23','',''),('5','92',4960831,'','supplier','100',0.00,13400.00,'Payment Id 392240 for invoice:257697, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:25:23','',''),('5','92',4960832,'','6.1','2221',13400.00,0.00,'Payment Id 392244 for invoice:257699, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:25:37','',''),('5','92',4960833,'','supplier','100',0.00,13400.00,'Payment Id 392244 for invoice:257699, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:25:37','',''),('5','92',4960834,'','2','2220',674035.00,0.00,'Payment Id 392243 for invoice:257699, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:25:55','',''),('5','92',4960835,'','supplier','100',0.00,674035.00,'Payment Id 392243 for invoice:257699, receipt: 0042 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-20 15:25:55','',''),('5','92',4960836,'','20','2222',0.00,0.00,'Sales from shift 257700 on 2022-09-20 15:26:44 ','2022-09-20 15:26:44','',''),('5','92',4960837,'','6.1','2221',0.00,0.00,'Sales from shift 257700 on 2022-09-20 15:26:44 ','2022-09-20 15:26:44','',''),('5','92',4960838,'','24','2219',0.00,5457500.00,'Purchase Id 88785 for 29,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-21 09:51:20','',''),('5','92',4960839,'','supplier','100',5457500.00,0.00,'Purchase Id 88785 for 29,500.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-09-21 09:51:20','',''),('5','92',4960840,'','20','2222',400996.75,0.00,'Sales from shift 257701 on 2022-09-22 14:04:44 ','2022-09-22 14:04:44','',''),('5','92',4960841,'','6.1','2221',0.00,400996.75,'Sales from shift 257701 on 2022-09-22 14:04:44 ','2022-09-22 14:04:44','',''),('5','92',4960842,'','20','2222',498922.80,0.00,'Sales from shift 257702 on 2022-09-23 22:50:04 ','2022-09-23 22:50:04','',''),('5','92',4960843,'','6.1','2221',0.00,498922.80,'Sales from shift 257702 on 2022-09-23 22:50:04 ','2022-09-23 22:50:04','',''),('5','92',4960844,'','20','2222',1083578.30,0.00,'Sales from shift 257703 on 2022-09-25 11:17:51 ','2022-09-25 11:17:51','',''),('5','92',4960845,'','6.1','2221',0.00,1083578.30,'Sales from shift 257703 on 2022-09-25 11:17:51 ','2022-09-25 11:17:51','',''),('5','92',4960846,'','20','2222',710176.15,0.00,'Sales from shift 257704 on 2022-09-25 11:26:10 ','2022-09-25 11:26:10','',''),('5','92',4960847,'','6.1','2221',0.00,710176.15,'Sales from shift 257704 on 2022-09-25 11:26:10 ','2022-09-25 11:26:10','',''),('5','92',4960848,'','20','2222',916736.05,0.00,'Sales from shift 257705 on 2022-09-26 09:31:24 ','2022-09-26 09:31:24','',''),('5','92',4960849,'','6.1','2221',0.00,916736.05,'Sales from shift 257705 on 2022-09-26 09:31:24 ','2022-09-26 09:31:24','',''),('5','92',4960850,'','20','2222',1108253.60,0.00,'Sales from shift 257706 on 2022-09-27 14:40:25 ','2022-09-27 14:40:25','',''),('5','92',4960851,'','6.1','2221',0.00,1108253.60,'Sales from shift 257706 on 2022-09-27 14:40:25 ','2022-09-27 14:40:25','',''),('5','92',4960852,'','20','2222',752391.30,0.00,'Sales from shift 257707 on 2022-09-28 10:03:24 ','2022-09-28 10:03:24','',''),('5','92',4960853,'','6.1','2221',0.00,752391.30,'Sales from shift 257707 on 2022-09-28 10:03:24 ','2022-09-28 10:03:24','',''),('5','92',4960854,'','2','2220',1060180.00,0.00,'Payment Id 392249 for invoice:257703, receipt: S26669797 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:03:38','',''),('5','92',4960855,'','supplier','100',0.00,1060180.00,'Payment Id 392249 for invoice:257703, receipt: S26669797 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:03:38','',''),('5','92',4960856,'','6.1','2221',23400.00,0.00,'Payment Id 392250 for invoice:257703, receipt: S26669797 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:03:46','',''),('5','92',4960857,'','supplier','100',0.00,23400.00,'Payment Id 392250 for invoice:257703, receipt: S26669797 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:03:46','',''),('5','92',4960858,'','2','2220',903335.00,0.00,'Payment Id 392251 for invoice:257704, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:03:56','',''),('5','92',4960859,'','supplier','100',0.00,903335.00,'Payment Id 392251 for invoice:257704, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:03:56','',''),('5','92',4960860,'','6.1','2221',13400.00,0.00,'Payment Id 392252 for invoice:257704, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:04:27','',''),('5','92',4960861,'','supplier','100',0.00,13400.00,'Payment Id 392252 for invoice:257704, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:04:27','',''),('5','92',4960862,'','2','2220',1094850.00,0.00,'Payment Id 392253 for invoice:257705, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:05:27','',''),('5','92',4960863,'','supplier','100',0.00,1094850.00,'Payment Id 392253 for invoice:257705, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:05:27','',''),('5','92',4960864,'','6.1','2221',13400.00,0.00,'Payment Id 392254 for invoice:257705, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:05:37','',''),('5','92',4960865,'','supplier','100',0.00,13400.00,'Payment Id 392254 for invoice:257705, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:05:37','',''),('5','92',4960866,'','2','2220',696775.00,0.00,'Payment Id 392255 for invoice:257704, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:06:30','',''),('5','92',4960867,'','supplier','100',0.00,696775.00,'Payment Id 392255 for invoice:257704, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:06:30','',''),('5','92',4960868,'','6.1','2221',13400.00,0.00,'Payment Id 392256 for invoice:257704, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:06:41','',''),('5','92',4960869,'','supplier','100',0.00,13400.00,'Payment Id 392256 for invoice:257704, receipt: 0037 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:06:41','',''),('5','92',4960870,'','2','2220',738990.00,0.00,'Payment Id 392257 for invoice:257707, receipt: 0018 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:07:15','',''),('5','92',4960871,'','supplier','100',0.00,738990.00,'Payment Id 392257 for invoice:257707, receipt: 0018 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:07:15','',''),('5','92',4960872,'','6.1','2221',13400.00,0.00,'Payment Id 392258 for invoice:257707, receipt: 0018 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:07:26','',''),('5','92',4960873,'','supplier','100',0.00,13400.00,'Payment Id 392258 for invoice:257707, receipt: 0018 by SALBAS OIL & GAS NIGERIA LIMIT','2022-09-28 10:07:26','',''),('5','92',4960874,'','20','2222',0.00,0.00,'Sales from shift 257708 on 2022-09-28 10:53:38 ','2022-09-28 10:53:38','',''),('5','92',4960875,'','6.1','2221',0.00,0.00,'Sales from shift 257708 on 2022-09-28 10:53:38 ','2022-09-28 10:53:38','',''),('5','92',4960876,'','20','2222',0.00,0.00,'Sales from shift 257709 on 2022-09-29 15:42:28 ','2022-09-29 15:42:28','',''),('5','92',4960877,'','6.1','2221',0.00,0.00,'Sales from shift 257709 on 2022-09-29 15:42:28 ','2022-09-29 15:42:28','',''),('5','92',4960878,'','20','2222',0.00,0.00,'Sales from shift 257710 on 2022-09-30 09:24:12 ','2022-09-30 09:24:12','',''),('5','92',4960879,'','6.1','2221',0.00,0.00,'Sales from shift 257710 on 2022-09-30 09:24:12 ','2022-09-30 09:24:12','',''),('5','92',4960880,'','24','2219',0.00,8325000.00,'Purchase Id 88786 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-10-01 09:56:31','',''),('5','92',4960881,'','supplier','100',8325000.00,0.00,'Purchase Id 88786 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-10-01 09:56:31','',''),('5','92',4960882,'','20','2222',393485.75,0.00,'Sales from shift 257711 on 2022-10-03 00:27:34 ','2022-10-03 00:27:34','',''),('5','92',4960883,'','6.1','2221',0.00,393485.75,'Sales from shift 257711 on 2022-10-03 00:27:34 ','2022-10-03 00:27:34','',''),('5','92',4960884,'','20','2222',834620.10,0.00,'Sales from shift 257712 on 2022-10-03 12:04:22 ','2022-10-03 12:04:22','',''),('5','92',4960885,'','6.1','2221',0.00,834620.10,'Sales from shift 257712 on 2022-10-03 12:04:22 ','2022-10-03 12:04:22','',''),('5','92',4960886,'','20','2222',843474.20,0.00,'Sales from shift 257713 on 2022-10-03 12:16:27 ','2022-10-03 12:16:27','',''),('5','92',4960887,'','6.1','2221',0.00,843474.20,'Sales from shift 257713 on 2022-10-03 12:16:27 ','2022-10-03 12:16:27','',''),('5','92',4960888,'','20','2222',1042811.70,0.00,'Sales from shift 257714 on 2022-10-04 09:31:08 ','2022-10-04 09:31:08','',''),('5','92',4960889,'','6.1','2221',0.00,1042811.70,'Sales from shift 257714 on 2022-10-04 09:31:08 ','2022-10-04 09:31:08','',''),('5','92',4960890,'','20','2222',907328.80,0.00,'Sales from shift 257715 on 2022-10-05 10:04:19 ','2022-10-05 10:04:19','',''),('5','92',4960891,'','6.1','2221',0.00,907328.80,'Sales from shift 257715 on 2022-10-05 10:04:19 ','2022-10-05 10:04:19','',''),('5','92',4960892,'','20','2222',1166528.60,0.00,'Sales from shift 257716 on 2022-10-06 09:41:40 ','2022-10-06 09:41:40','',''),('5','92',4960893,'','6.1','2221',0.00,1166528.60,'Sales from shift 257716 on 2022-10-06 09:41:40 ','2022-10-06 09:41:40','',''),('5','92',4960894,'','20','2222',1427667.20,0.00,'Sales from shift 257717 on 2022-10-07 10:07:40 ','2022-10-07 10:07:40','',''),('5','92',4960895,'','6.1','2221',0.00,1427667.20,'Sales from shift 257717 on 2022-10-07 10:07:40 ','2022-10-07 10:07:40','',''),('5','92',4960896,'','2','2220',809520.00,0.00,'Payment Id 392259 for invoice:257712, receipt: 0013 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:35:04','',''),('5','92',4960897,'','supplier','100',0.00,809520.00,'Payment Id 392259 for invoice:257712, receipt: 0013 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:35:04','',''),('5','92',4960898,'','2','2220',387595.00,0.00,'Payment Id 392245 for invoice:257701, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:35:25','',''),('5','92',4960899,'','supplier','100',0.00,387595.00,'Payment Id 392245 for invoice:257701, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:35:25','',''),('5','92',4960900,'','6.1','2221',13400.00,0.00,'Payment Id 392246 for invoice:257701, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:35:33','',''),('5','92',4960901,'','supplier','100',0.00,13400.00,'Payment Id 392246 for invoice:257701, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:35:33','',''),('5','92',4960902,'','2','2220',485520.00,0.00,'Payment Id 392247 for invoice:257702, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:35:56','',''),('5','92',4960903,'','supplier','100',0.00,485520.00,'Payment Id 392247 for invoice:257702, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:35:56','',''),('5','92',4960904,'','6.1','2221',13400.00,0.00,'Payment Id 392248 for invoice:257702, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:36:05','',''),('5','92',4960905,'','supplier','100',0.00,13400.00,'Payment Id 392248 for invoice:257702, receipt: 0012 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-07 10:36:05','',''),('5','92',4960906,'','20','2222',1766380.00,0.00,'Sales from shift 257718 on 2022-10-09 18:45:20 ','2022-10-09 18:45:20','',''),('5','92',4960907,'','6.1','2221',0.00,1766380.00,'Sales from shift 257718 on 2022-10-09 18:45:20 ','2022-10-09 18:45:20','',''),('5','92',4960908,'','20','2222',0.00,0.00,'Sales from shift 257719 on 2022-10-10 10:15:10 ','2022-10-10 10:15:10','',''),('5','92',4960909,'','6.1','2221',0.00,0.00,'Sales from shift 257719 on 2022-10-10 10:15:10 ','2022-10-10 10:15:10','',''),('5','92',4960910,'','20','2222',0.00,0.00,'Sales from shift 257720 on 2022-10-11 11:28:25 ','2022-10-11 11:28:25','',''),('5','92',4960911,'','6.1','2221',0.00,0.00,'Sales from shift 257720 on 2022-10-11 11:28:25 ','2022-10-11 11:28:25','',''),('5','92',4960912,'','20','2222',0.00,0.00,'Sales from shift 257721 on 2022-10-12 15:14:01 ','2022-10-12 15:14:01','',''),('5','92',4960913,'','6.1','2221',0.00,0.00,'Sales from shift 257721 on 2022-10-12 15:14:01 ','2022-10-12 15:14:01','',''),('5','92',4960914,'','20','2222',0.00,0.00,'Sales from shift 257722 on 2022-10-13 13:45:39 ','2022-10-13 13:45:39','',''),('5','92',4960915,'','6.1','2221',0.00,0.00,'Sales from shift 257722 on 2022-10-13 13:45:39 ','2022-10-13 13:45:39','',''),('5','92',4960916,'','20','2222',0.00,0.00,'Sales from shift 257723 on 2022-10-14 16:48:59 ','2022-10-14 16:48:59','',''),('5','92',4960917,'','6.1','2221',0.00,0.00,'Sales from shift 257723 on 2022-10-14 16:48:59 ','2022-10-14 16:48:59','',''),('5','92',4960918,'','20','2222',0.00,0.00,'Sales from shift 257724 on 2022-10-17 14:54:59 ','2022-10-17 14:54:59','',''),('5','92',4960919,'','6.1','2221',0.00,0.00,'Sales from shift 257724 on 2022-10-17 14:54:59 ','2022-10-17 14:54:59','',''),('5','92',4960920,'','20','2222',0.00,0.00,'Sales from shift 257725 on 2022-10-17 14:59:52 ','2022-10-17 14:59:52','',''),('5','92',4960921,'','6.1','2221',0.00,0.00,'Sales from shift 257725 on 2022-10-17 14:59:52 ','2022-10-17 14:59:52','',''),('5','92',4960922,'','20','2222',0.00,0.00,'Sales from shift 257726 on 2022-10-17 15:04:28 ','2022-10-17 15:04:28','',''),('5','92',4960923,'','6.1','2221',0.00,0.00,'Sales from shift 257726 on 2022-10-17 15:04:28 ','2022-10-17 15:04:28','',''),('5','92',4960924,'','20','2222',0.00,0.00,'Sales from shift 257727 on 2022-10-17 15:06:26 ','2022-10-17 15:06:26','',''),('5','92',4960925,'','6.1','2221',0.00,0.00,'Sales from shift 257727 on 2022-10-17 15:06:26 ','2022-10-17 15:06:26','',''),('5','92',4960926,'','20','2222',0.00,0.00,'Sales from shift 257728 on 2022-10-18 15:28:29 ','2022-10-18 15:28:29','',''),('5','92',4960927,'','6.1','2221',0.00,0.00,'Sales from shift 257728 on 2022-10-18 15:28:29 ','2022-10-18 15:28:29','',''),('5','92',4960928,'','20','2222',0.00,0.00,'Sales from shift 257729 on 2022-10-19 08:44:27 ','2022-10-19 08:44:27','',''),('5','92',4960929,'','6.1','2221',0.00,0.00,'Sales from shift 257729 on 2022-10-19 08:44:27 ','2022-10-19 08:44:27','',''),('5','92',4960930,'','20','2222',0.00,0.00,'Sales from shift 257730 on 2022-10-20 10:09:27 ','2022-10-20 10:09:27','',''),('5','92',4960931,'','6.1','2221',0.00,0.00,'Sales from shift 257730 on 2022-10-20 10:09:27 ','2022-10-20 10:09:27','',''),('5','92',4960932,'','6.1','2221',13400.00,0.00,'Payment Id 392278 for invoice:257718, receipt: 2516 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960933,'','supplier','100',0.00,13400.00,'Payment Id 392278 for invoice:257718, receipt: 2516 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960934,'','2','2220',1752980.00,0.00,'Payment Id 392277 for invoice:257718, receipt: 2516 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960935,'','supplier','100',0.00,1752980.00,'Payment Id 392277 for invoice:257718, receipt: 2516 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960936,'','6.1','2221',13400.00,0.00,'Payment Id 392276 for invoice:257717, receipt: 2415 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960937,'','supplier','100',0.00,13400.00,'Payment Id 392276 for invoice:257717, receipt: 2415 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960938,'','2','2220',1414270.00,0.00,'Payment Id 392275 for invoice:257717, receipt: 2415 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960939,'','supplier','100',0.00,1414270.00,'Payment Id 392275 for invoice:257717, receipt: 2415 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960940,'','6.1','2221',13400.00,0.00,'Payment Id 392274 for invoice:257716, receipt: 2314 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960941,'','supplier','100',0.00,13400.00,'Payment Id 392274 for invoice:257716, receipt: 2314 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960942,'','2','2220',1153130.00,0.00,'Payment Id 392273 for invoice:257716, receipt: 2314 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960943,'','supplier','100',0.00,1153130.00,'Payment Id 392273 for invoice:257716, receipt: 2314 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:37:19','',''),('5','92',4960944,'','6.1','2221',13400.00,0.00,'Payment Id 392272 for invoice:257715, receipt: 0020 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:38:14','',''),('5','92',4960945,'','supplier','100',0.00,13400.00,'Payment Id 392272 for invoice:257715, receipt: 0020 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:38:14','',''),('5','92',4960946,'','2','2220',893920.00,0.00,'Payment Id 392271 for invoice:257715, receipt: 0020 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:38:14','',''),('5','92',4960947,'','supplier','100',0.00,893920.00,'Payment Id 392271 for invoice:257715, receipt: 0020 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:38:14','',''),('5','92',4960948,'','6.1','2221',13400.00,0.00,'Payment Id 392270 for invoice:257716, receipt: 0016 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:38:52','',''),('5','92',4960949,'','supplier','100',0.00,13400.00,'Payment Id 392270 for invoice:257716, receipt: 0016 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:38:52','',''),('5','92',4960950,'','2','2220',1029410.00,0.00,'Payment Id 392269 for invoice:257714, receipt: 0016 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:38:52','',''),('5','92',4960951,'','supplier','100',0.00,1029410.00,'Payment Id 392269 for invoice:257714, receipt: 0016 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:38:52','',''),('5','92',4960952,'','6.1','2221',13400.00,0.00,'Payment Id 392268 for invoice:257713, receipt: 0015 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:39:26','',''),('5','92',4960953,'','supplier','100',0.00,13400.00,'Payment Id 392268 for invoice:257713, receipt: 0015 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:39:26','',''),('5','92',4960954,'','2','2220',830075.00,0.00,'Payment Id 392267 for invoice:257713, receipt: 0015 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:39:26','',''),('5','92',4960955,'','supplier','100',0.00,830075.00,'Payment Id 392267 for invoice:257713, receipt: 0015 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:39:26','',''),('5','92',4960956,'','6.1','2221',25100.00,0.00,'Payment Id 392260 for invoice:257721, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:40:02','',''),('5','92',4960957,'','supplier','100',0.00,25100.00,'Payment Id 392260 for invoice:257721, receipt: 0022 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:40:02','',''),('5','92',4960958,'','6.1','2221',25400.00,0.00,'Payment Id 392218 for invoice:257679, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960959,'','supplier','100',0.00,25400.00,'Payment Id 392218 for invoice:257679, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960960,'','2','2220',979080.00,0.00,'Payment Id 392217 for invoice:257679, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960961,'','supplier','100',0.00,979080.00,'Payment Id 392217 for invoice:257679, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960962,'','6.1','2221',24900.00,0.00,'Payment Id 392216 for invoice:257678, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960963,'','supplier','100',0.00,24900.00,'Payment Id 392216 for invoice:257678, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960964,'','6.1','2221',13400.00,0.00,'Payment Id 392214 for invoice:257677, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960965,'','supplier','100',0.00,13400.00,'Payment Id 392214 for invoice:257677, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960966,'','2','2220',827460.00,0.00,'Payment Id 392213 for invoice:257677, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960967,'','supplier','100',0.00,827460.00,'Payment Id 392213 for invoice:257677, receipt: 0044 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960968,'','6.1','2221',13400.00,0.00,'Payment Id 392212 for invoice:257676, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960969,'','supplier','100',0.00,13400.00,'Payment Id 392212 for invoice:257676, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960970,'','2','2220',434275.00,0.00,'Payment Id 392211 for invoice:257676, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960971,'','supplier','100',0.00,434275.00,'Payment Id 392211 for invoice:257676, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960972,'','6.1','2221',13400.00,0.00,'Payment Id 392210 for invoice:257675, receipt: 0046 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960973,'','supplier','100',0.00,13400.00,'Payment Id 392210 for invoice:257675, receipt: 0046 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960974,'','2','2220',630060.00,0.00,'Payment Id 392209 for invoice:257675, receipt: 0046 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960975,'','supplier','100',0.00,630060.00,'Payment Id 392209 for invoice:257675, receipt: 0046 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:53:54','',''),('5','92',4960976,'','2','2220',437955.00,0.00,'Payment Id 392215 for invoice:257678, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:22','',''),('5','92',4960977,'','supplier','100',0.00,437955.00,'Payment Id 392215 for invoice:257678, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:22','',''),('5','92',4960978,'','6.1','2221',13400.00,0.00,'Payment Id 392198 for invoice:257669, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:22','',''),('5','92',4960979,'','supplier','100',0.00,13400.00,'Payment Id 392198 for invoice:257669, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:22','',''),('5','92',4960980,'','2','2220',360410.00,0.00,'Payment Id 392197 for invoice:257669, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:22','',''),('5','92',4960981,'','supplier','100',0.00,360410.00,'Payment Id 392197 for invoice:257669, receipt: 0025 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:22','',''),('5','92',4960982,'','6.1','2221',13400.00,0.00,'Payment Id 392196 for invoice:257668, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960983,'','supplier','100',0.00,13400.00,'Payment Id 392196 for invoice:257668, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960984,'','2','2220',892770.00,0.00,'Payment Id 392195 for invoice:257668, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960985,'','supplier','100',0.00,892770.00,'Payment Id 392195 for invoice:257668, receipt: 0027 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960986,'','6.1','2221',18400.00,0.00,'Payment Id 392194 for invoice:257667, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960987,'','supplier','100',0.00,18400.00,'Payment Id 392194 for invoice:257667, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960988,'','2','2220',849380.00,0.00,'Payment Id 392193 for invoice:257667, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960989,'','supplier','100',0.00,849380.00,'Payment Id 392193 for invoice:257667, receipt: 0049 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960990,'','6.1','2221',13400.00,0.00,'Payment Id 392192 for invoice:257666, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960991,'','supplier','100',0.00,13400.00,'Payment Id 392192 for invoice:257666, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960992,'','2','2220',427945.00,0.00,'Payment Id 392191 for invoice:257666, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960993,'','supplier','100',0.00,427945.00,'Payment Id 392191 for invoice:257666, receipt: 0024 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960994,'','6.1','2221',13400.00,0.00,'Payment Id 392190 for invoice:257664, receipt: 0006 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960995,'','supplier','100',0.00,13400.00,'Payment Id 392190 for invoice:257664, receipt: 0006 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:23','',''),('5','92',4960996,'','6.1','2221',13400.00,0.00,'Payment Id 392189 for invoice:257664, receipt: 0006 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4960997,'','supplier','100',0.00,13400.00,'Payment Id 392189 for invoice:257664, receipt: 0006 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4960998,'','2','2220',694165.00,0.00,'Payment Id 392178 for invoice:257660, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4960999,'','supplier','100',0.00,694165.00,'Payment Id 392178 for invoice:257660, receipt: 0047 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961000,'','6.1','2221',25100.00,0.00,'Payment Id 392177 for invoice:257659, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961001,'','supplier','100',0.00,25100.00,'Payment Id 392177 for invoice:257659, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961002,'','2','2220',218500.00,0.00,'Payment Id 392176 for invoice:257659, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961003,'','supplier','100',0.00,218500.00,'Payment Id 392176 for invoice:257659, receipt: 0026 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961004,'','6.1','2221',13400.00,0.00,'Payment Id 392175 for invoice:257655, receipt: 0029 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961005,'','supplier','100',0.00,13400.00,'Payment Id 392175 for invoice:257655, receipt: 0029 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961006,'','2','2220',570485.00,0.00,'Payment Id 392174 for invoice:257655, receipt: 0029 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961007,'','supplier','100',0.00,570485.00,'Payment Id 392174 for invoice:257655, receipt: 0029 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961008,'','6.1','2221',13400.00,0.00,'Payment Id 392173 for invoice:257654, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961009,'','supplier','100',0.00,13400.00,'Payment Id 392173 for invoice:257654, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961010,'','2','2220',1920165.00,0.00,'Payment Id 392172 for invoice:257653, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961011,'','supplier','100',0.00,1920165.00,'Payment Id 392172 for invoice:257653, receipt: 0028 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961012,'','6.1','2221',13700.00,0.00,'Payment Id 392122 for invoice:257625, receipt: 0069 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961013,'','supplier','100',0.00,13700.00,'Payment Id 392122 for invoice:257625, receipt: 0069 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961014,'','2','2220',327480.00,0.00,'Payment Id 392121 for invoice:257625, receipt: 0069 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961015,'','supplier','100',0.00,327480.00,'Payment Id 392121 for invoice:257625, receipt: 0069 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:54:47','',''),('5','92',4961016,'','2','2220',177330.00,0.00,'Payment Id 392077 for invoice:257557, receipt: 0038 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961017,'','supplier','100',0.00,177330.00,'Payment Id 392077 for invoice:257557, receipt: 0038 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961018,'','6.1','2221',11300.00,0.00,'Payment Id 392076 for invoice:257556, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961019,'','supplier','100',0.00,11300.00,'Payment Id 392076 for invoice:257556, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961020,'','2','2220',1561800.00,0.00,'Payment Id 392075 for invoice:257556, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961021,'','supplier','100',0.00,1561800.00,'Payment Id 392075 for invoice:257556, receipt: 0040 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961022,'','6.1','2221',11300.00,0.00,'Payment Id 392074 for invoice:257555, receipt: 0089 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961023,'','supplier','100',0.00,11300.00,'Payment Id 392074 for invoice:257555, receipt: 0089 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961024,'','2','2220',1284680.00,0.00,'Payment Id 392073 for invoice:257555, receipt: 0089 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961025,'','supplier','100',0.00,1284680.00,'Payment Id 392073 for invoice:257555, receipt: 0089 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961026,'','6.1','2221',11300.00,0.00,'Payment Id 392072 for invoice:257554, receipt: 0088 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961027,'','supplier','100',0.00,11300.00,'Payment Id 392072 for invoice:257554, receipt: 0088 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961028,'','2','2220',848495.00,0.00,'Payment Id 392071 for invoice:257554, receipt: 0088 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961029,'','supplier','100',0.00,848495.00,'Payment Id 392071 for invoice:257554, receipt: 0088 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961030,'','6.1','2221',11300.00,0.00,'Payment Id 392070 for invoice:257553, receipt: 0087 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961031,'','supplier','100',0.00,11300.00,'Payment Id 392070 for invoice:257553, receipt: 0087 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961032,'','2','2220',249970.00,0.00,'Payment Id 392069 for invoice:257553, receipt: 0087 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961033,'','supplier','100',0.00,249970.00,'Payment Id 392069 for invoice:257553, receipt: 0087 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961034,'','6.1','2221',11300.00,0.00,'Payment Id 392068 for invoice:257567, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961035,'','supplier','100',0.00,11300.00,'Payment Id 392068 for invoice:257567, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:12','',''),('5','92',4961036,'','2','2220',137715.00,0.00,'Payment Id 392067 for invoice:257567, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:47','',''),('5','92',4961037,'','supplier','100',0.00,137715.00,'Payment Id 392067 for invoice:257567, receipt: 0056 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:47','',''),('5','92',4961038,'','6.1','2221',11000.00,0.00,'Payment Id 392047 for invoice:257509, receipt: 0122630 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:47','',''),('5','92',4961039,'','supplier','100',0.00,11000.00,'Payment Id 392047 for invoice:257509, receipt: 0122630 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:47','',''),('5','92',4961040,'','6.1','2221',63400.00,0.00,'Payment Id 392043 for invoice:257506, receipt: 0017 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:47','',''),('5','92',4961041,'','supplier','100',0.00,63400.00,'Payment Id 392043 for invoice:257506, receipt: 0017 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:55:47','',''),('5','92',4961042,'','6.1','2221',4104537.39,0.00,'Payment Id 392279 for invoice:257730, receipt: 4242 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:58:13','',''),('5','92',4961043,'','supplier','100',0.00,4104537.39,'Payment Id 392279 for invoice:257730, receipt: 4242 by SALBAS OIL & GAS NIGERIA LIMIT','2022-10-20 12:58:13','',''),('5','92',4961044,'','20','2222',0.00,0.00,'Sales from shift 257731 on 2022-10-20 21:27:43 ','2022-10-20 21:27:43','',''),('5','92',4961045,'','6.1','2221',0.00,0.00,'Sales from shift 257731 on 2022-10-20 21:27:43 ','2022-10-20 21:27:43','',''),('5','92',4961046,'','20','2222',0.00,0.00,'Sales from shift 257732 on 2022-10-23 09:05:29 ','2022-10-23 09:05:29','',''),('5','92',4961047,'','6.1','2221',0.00,0.00,'Sales from shift 257732 on 2022-10-23 09:05:29 ','2022-10-23 09:05:29','',''),('5','92',4961048,'','20','2222',0.00,0.00,'Sales from shift 257733 on 2022-10-23 18:44:02 ','2022-10-23 18:44:02','',''),('5','92',4961049,'','6.1','2221',0.00,0.00,'Sales from shift 257733 on 2022-10-23 18:44:02 ','2022-10-23 18:44:02','',''),('5','92',4961050,'','20','2222',0.00,0.00,'Sales from shift 257734 on 2022-10-24 11:49:43 ','2022-10-24 11:49:43','',''),('5','92',4961051,'','6.1','2221',0.00,0.00,'Sales from shift 257734 on 2022-10-24 11:49:43 ','2022-10-24 11:49:43','',''),('5','92',4961052,'','20','2222',0.00,0.00,'Sales from shift 257735 on 2022-10-25 15:42:51 ','2022-10-25 15:42:51','',''),('5','92',4961053,'','6.1','2221',0.00,0.00,'Sales from shift 257735 on 2022-10-25 15:42:51 ','2022-10-25 15:42:51','',''),('5','92',4961054,'','20','2222',0.00,0.00,'Sales from shift 257736 on 2022-10-26 14:18:32 ','2022-10-26 14:18:32','',''),('5','92',4961055,'','6.1','2221',0.00,0.00,'Sales from shift 257736 on 2022-10-26 14:18:32 ','2022-10-26 14:18:32','',''),('5','92',4961056,'','20','2222',0.00,0.00,'Sales from shift 257737 on 2022-10-28 21:25:58 ','2022-10-28 21:25:58','',''),('5','92',4961057,'','6.1','2221',0.00,0.00,'Sales from shift 257737 on 2022-10-28 21:25:58 ','2022-10-28 21:25:58','',''),('5','92',4961058,'','20','2222',0.00,0.00,'Sales from shift 257738 on 2022-10-29 14:19:11 ','2022-10-29 14:19:11','',''),('5','92',4961059,'','6.1','2221',0.00,0.00,'Sales from shift 257738 on 2022-10-29 14:19:11 ','2022-10-29 14:19:11','',''),('5','92',4961060,'','24','2219',0.00,7400000.00,'Purchase Id 88787 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-10-29 14:19:25','',''),('5','92',4961061,'','supplier','100',7400000.00,0.00,'Purchase Id 88787 for 40,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-10-29 14:19:25','',''),('5','92',4961062,'','20','2222',474238.25,0.00,'Sales from shift 257739 on 2022-10-31 11:25:37 ','2022-10-31 11:25:37','',''),('5','92',4961063,'','6.1','2221',0.00,474238.25,'Sales from shift 257739 on 2022-10-31 11:25:37 ','2022-10-31 11:25:37','',''),('5','92',4961064,'','20','2222',1353743.05,0.00,'Sales from shift 257740 on 2022-11-07 14:51:23 ','2022-11-07 14:51:23','',''),('5','92',4961065,'','6.1','2221',0.00,1353743.05,'Sales from shift 257740 on 2022-11-07 14:51:23 ','2022-11-07 14:51:23','',''),('5','92',4961066,'','20','2222',1838015.70,0.00,'Sales from shift 257741 on 2022-11-07 14:56:46 ','2022-11-07 14:56:46','',''),('5','92',4961067,'','6.1','2221',0.00,1838015.70,'Sales from shift 257741 on 2022-11-07 14:56:46 ','2022-11-07 14:56:46','',''),('5','92',4961068,'','20','2222',2006090.05,0.00,'Sales from shift 257742 on 2022-11-07 15:00:17 ','2022-11-07 15:00:17','',''),('5','92',4961069,'','6.1','2221',0.00,2006090.05,'Sales from shift 257742 on 2022-11-07 15:00:17 ','2022-11-07 15:00:17','',''),('5','92',4961070,'','20','2222',1786992.70,0.00,'Sales from shift 257743 on 2022-11-07 15:04:01 ','2022-11-07 15:04:01','',''),('5','92',4961071,'','6.1','2221',0.00,1786992.70,'Sales from shift 257743 on 2022-11-07 15:04:01 ','2022-11-07 15:04:01','',''),('5','92',4961072,'','24','2219',0.00,8325000.00,'Purchase Id 88788 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-11-07 15:10:24','',''),('5','92',4961073,'','supplier','100',8325000.00,0.00,'Purchase Id 88788 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-11-07 15:10:24','',''),('5','92',4961074,'','20','2222',2175945.95,0.00,'Sales from shift 257744 on 2022-11-07 15:17:46 ','2022-11-07 15:17:46','',''),('5','92',4961075,'','6.1','2221',0.00,2175945.95,'Sales from shift 257744 on 2022-11-07 15:17:46 ','2022-11-07 15:17:46','',''),('5','92',4961076,'','20','2222',2465852.05,0.00,'Sales from shift 257745 on 2022-11-07 15:35:29 ','2022-11-07 15:35:29','',''),('5','92',4961077,'','6.1','2221',0.00,2465852.05,'Sales from shift 257745 on 2022-11-07 15:35:29 ','2022-11-07 15:35:29','',''),('5','92',4961078,'','20','2222',2404119.40,0.00,'Sales from shift 257746 on 2022-11-07 15:42:25 ','2022-11-07 15:42:25','',''),('5','92',4961079,'','6.1','2221',0.00,2404119.40,'Sales from shift 257746 on 2022-11-07 15:42:25 ','2022-11-07 15:42:25','',''),('5','92',4961080,'','24','2219',0.00,370000.00,'Purchase Id 88789 for 2,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-11-07 15:44:30','',''),('5','92',4961081,'','supplier','100',370000.00,0.00,'Purchase Id 88789 for 2,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIGERIA LIMIT','2022-11-07 15:44:30','',''),('5','92',4961082,'','20','2222',1294631.85,0.00,'Sales from shift 257747 on 2022-11-07 16:25:14 ','2022-11-07 16:25:14','',''),('5','92',4961083,'','6.1','2221',0.00,1294631.85,'Sales from shift 257747 on 2022-11-07 16:25:14 ','2022-11-07 16:25:14','',''),('5','92',4961084,'','20','2222',0.00,0.00,'Sales from shift 257748 on 2022-11-08 15:51:49 ','2022-11-08 15:51:49','',''),('5','92',4961085,'','6.1','2221',0.00,0.00,'Sales from shift 257748 on 2022-11-08 15:51:49 ','2022-11-08 15:51:49','',''),('5','92',4961086,'','20','2222',0.00,0.00,'Sales from shift 257749 on 2022-11-10 17:06:34 ','2022-11-10 17:06:34','',''),('5','92',4961087,'','6.1','2221',0.00,0.00,'Sales from shift 257749 on 2022-11-10 17:06:34 ','2022-11-10 17:06:34','',''),('5','92',4961088,'','6.1','2221',13400.00,0.00,'Payment Id 392283 for invoice:257740, receipt: 1046362 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:38','',''),('5','92',4961089,'','supplier','100',0.00,13400.00,'Payment Id 392283 for invoice:257740, receipt: 1046362 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:38','',''),('5','92',4961090,'','2','2220',1340340.00,0.00,'Payment Id 392282 for invoice:257740, receipt: 0146362 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:38','',''),('5','92',4961091,'','supplier','100',0.00,1340340.00,'Payment Id 392282 for invoice:257740, receipt: 0146362 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:38','',''),('5','92',4961092,'','6.1','2221',13400.00,0.00,'Payment Id 392281 for invoice:257739, receipt: 0146361 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:38','',''),('5','92',4961093,'','supplier','100',0.00,13400.00,'Payment Id 392281 for invoice:257739, receipt: 0146361 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:38','',''),('5','92',4961094,'','2','2220',460840.00,0.00,'Payment Id 392280 for invoice:257739, receipt: 0146361 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:38','',''),('5','92',4961095,'','supplier','100',0.00,460840.00,'Payment Id 392280 for invoice:257739, receipt: 0146361 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:38','',''),('5','92',4961096,'','6.1','2221',13400.00,0.00,'Payment Id 392285 for invoice:257741, receipt: 1046363 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:48','',''),('5','92',4961097,'','supplier','100',0.00,13400.00,'Payment Id 392285 for invoice:257741, receipt: 1046363 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:48','',''),('5','92',4961098,'','2','2220',1824615.00,0.00,'Payment Id 392284 for invoice:257741, receipt: 1046363 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:48','',''),('5','92',4961099,'','supplier','100',0.00,1824615.00,'Payment Id 392284 for invoice:257741, receipt: 1046363 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:08:48','',''),('5','92',4961100,'','6.1','2221',13400.00,0.00,'Payment Id 392295 for invoice:257745, receipt: 1046367 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:13','',''),('5','92',4961101,'','supplier','100',0.00,13400.00,'Payment Id 392295 for invoice:257745, receipt: 1046367 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:13','',''),('5','92',4961102,'','2','2220',1281230.00,0.00,'Payment Id 392294 for invoice:257745, receipt: 0146367 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:13','',''),('5','92',4961103,'','supplier','100',0.00,1281230.00,'Payment Id 392294 for invoice:257745, receipt: 0146367 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:13','',''),('5','92',4961104,'','6.1','2221',13400.00,0.00,'Payment Id 392293 for invoice:257744, receipt: 1046366 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:13','',''),('5','92',4961105,'','supplier','100',0.00,13400.00,'Payment Id 392293 for invoice:257744, receipt: 1046366 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:13','',''),('5','92',4961106,'','2','2220',2390720.00,0.00,'Payment Id 392292 for invoice:257745, receipt: 1046366 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:13','',''),('5','92',4961107,'','supplier','100',0.00,2390720.00,'Payment Id 392292 for invoice:257745, receipt: 1046366 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:13','',''),('5','92',4961108,'','6.1','2221',13400.00,0.00,'Payment Id 392291 for invoice:257744, receipt: 1046365 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:14','',''),('5','92',4961109,'','supplier','100',0.00,13400.00,'Payment Id 392291 for invoice:257744, receipt: 1046365 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:14','',''),('5','92',4961110,'','2','2220',2452450.00,0.00,'Payment Id 392290 for invoice:257744, receipt: 1046365 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:14','',''),('5','92',4961111,'','supplier','100',0.00,2452450.00,'Payment Id 392290 for invoice:257744, receipt: 1046365 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:14','',''),('5','92',4961112,'','6.1','2221',13400.00,0.00,'Payment Id 392289 for invoice:257743, receipt: 0146364 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:14','',''),('5','92',4961113,'','supplier','100',0.00,13400.00,'Payment Id 392289 for invoice:257743, receipt: 0146364 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:14','',''),('5','92',4961114,'','2','2220',2162545.00,0.00,'Payment Id 392288 for invoice:257743, receipt: 0146364 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:14','',''),('5','92',4961115,'','supplier','100',0.00,2162545.00,'Payment Id 392288 for invoice:257743, receipt: 0146364 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 10:15:14','',''),('5','92',4961116,'','20','2222',0.00,0.00,'Sales from shift 257750 on 2022-11-11 12:19:47 ','2022-11-11 12:19:47','',''),('5','92',4961117,'','6.1','2221',0.00,0.00,'Sales from shift 257750 on 2022-11-11 12:19:47 ','2022-11-11 12:19:47','',''),('5','92',4961118,'','6.1','2221',25100.00,0.00,'Payment Id 392299 for invoice:257740, receipt: 0146369 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 12:21:57','',''),('5','92',4961119,'','supplier','100',0.00,25100.00,'Payment Id 392299 for invoice:257740, receipt: 0146369 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 12:21:57','',''),('5','92',4961120,'','2','2220',1761890.00,0.00,'Payment Id 392298 for invoice:257740, receipt: 0146369 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 12:21:57','',''),('5','92',4961121,'','supplier','100',0.00,1761890.00,'Payment Id 392298 for invoice:257740, receipt: 0146369 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 12:21:57','',''),('5','92',4961122,'','6.1','2221',255400.00,0.00,'Payment Id 392297 for invoice:257739, receipt: 0146368 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 12:21:57','',''),('5','92',4961123,'','supplier','100',0.00,255400.00,'Payment Id 392297 for invoice:257739, receipt: 0146368 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 12:21:57','',''),('5','92',4961124,'','2','2220',1750690.00,0.00,'Payment Id 392296 for invoice:257739, receipt: 0146368 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 12:21:57','',''),('5','92',4961125,'','supplier','100',0.00,1750690.00,'Payment Id 392296 for invoice:257739, receipt: 0146368 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-11 12:21:57','',''),('5','92',4961126,'','20','2222',0.00,0.00,'Sales from shift 257751 on 2022-11-11 12:24:56 ','2022-11-11 12:24:56','',''),('5','92',4961127,'','6.1','2221',0.00,0.00,'Sales from shift 257751 on 2022-11-11 12:24:56 ','2022-11-11 12:24:56','',''),('5','92',4961128,'','20','2222',0.00,0.00,'Sales from shift 257752 on 2022-11-11 13:19:59 ','2022-11-11 13:19:59','',''),('5','92',4961129,'','6.1','2221',0.00,0.00,'Sales from shift 257752 on 2022-11-11 13:19:59 ','2022-11-11 13:19:59','',''),('5','92',4961130,'','20','2222',0.00,0.00,'Sales from shift 257753 on 2022-11-14 13:03:37 ','2022-11-14 13:03:37','',''),('5','92',4961131,'','6.1','2221',0.00,0.00,'Sales from shift 257753 on 2022-11-14 13:03:37 ','2022-11-14 13:03:37','',''),('5','92',4961132,'','20','2222',0.00,0.00,'Sales from shift 257754 on 2022-11-14 13:45:05 ','2022-11-14 13:45:05','',''),('5','92',4961133,'','6.1','2221',0.00,0.00,'Sales from shift 257754 on 2022-11-14 13:45:05 ','2022-11-14 13:45:05','',''),('5','92',4961134,'','20','2222',0.00,0.00,'Sales from shift 257755 on 2022-11-14 14:32:48 ','2022-11-14 14:32:48','',''),('5','92',4961135,'','6.1','2221',0.00,0.00,'Sales from shift 257755 on 2022-11-14 14:32:48 ','2022-11-14 14:32:48','',''),('5','92',4961136,'','20','2222',0.00,0.00,'Sales from shift 257756 on 2022-11-15 11:30:42 ','2022-11-15 11:30:42','',''),('5','92',4961137,'','6.1','2221',0.00,0.00,'Sales from shift 257756 on 2022-11-15 11:30:42 ','2022-11-15 11:30:42','',''),('5','92',4961138,'','6.1','2221',13400.00,0.00,'Payment Id 392305 for invoice:257747, receipt: 0146373 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961139,'','supplier','100',0.00,13400.00,'Payment Id 392305 for invoice:257747, receipt: 0146373 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961140,'','2','2220',1281230.00,0.00,'Payment Id 392304 for invoice:257747, receipt: 0146373 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961141,'','supplier','100',0.00,1281230.00,'Payment Id 392304 for invoice:257747, receipt: 0146373 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961142,'','6.1','2221',13400.00,0.00,'Payment Id 392303 for invoice:257746, receipt: 0146372 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961143,'','supplier','100',0.00,13400.00,'Payment Id 392303 for invoice:257746, receipt: 0146372 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961144,'','2','2220',2390720.00,0.00,'Payment Id 392302 for invoice:257746, receipt: 0146372 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961145,'','supplier','100',0.00,2390720.00,'Payment Id 392302 for invoice:257746, receipt: 0146372 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961146,'','6.1','2221',13400.00,0.00,'Payment Id 392301 for invoice:257745, receipt: 0146371 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961147,'','supplier','100',0.00,13400.00,'Payment Id 392301 for invoice:257745, receipt: 0146371 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:24:59','',''),('5','92',4961148,'','2','2220',2452450.00,0.00,'Payment Id 392300 for invoice:257745, receipt: 0146371 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:25:00','',''),('5','92',4961149,'','supplier','100',0.00,2452450.00,'Payment Id 392300 for invoice:257745, receipt: 0146371 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-17 07:25:00','',''),('5','92',4961150,'','20','2222',0.00,0.00,'Sales from shift 257757 on 2022-11-18 13:46:48 ','2022-11-18 13:46:48','',''),('5','92',4961151,'','6.1','2221',0.00,0.00,'Sales from shift 257757 on 2022-11-18 13:46:48 ','2022-11-18 13:46:48','',''),('5','92',4961152,'','20','2222',0.00,0.00,'Sales from shift 257758 on 2022-11-18 14:37:04 ','2022-11-18 14:37:04','',''),('5','92',4961153,'','6.1','2221',0.00,0.00,'Sales from shift 257758 on 2022-11-18 14:37:04 ','2022-11-18 14:37:04','',''),('5','92',4961154,'','20','2222',0.00,0.00,'Sales from shift 257759 on 2022-11-18 14:39:49 ','2022-11-18 14:39:49','',''),('5','92',4961155,'','6.1','2221',0.00,0.00,'Sales from shift 257759 on 2022-11-18 14:39:49 ','2022-11-18 14:39:49','',''),('5','92',4961156,'','20','2222',0.00,0.00,'Sales from shift 257760 on 2022-11-19 18:28:46 ','2022-11-19 18:28:46','',''),('5','92',4961157,'','6.1','2221',0.00,0.00,'Sales from shift 257760 on 2022-11-19 18:28:46 ','2022-11-19 18:28:46','',''),('5','92',4961158,'','20','2222',0.00,0.00,'Sales from shift 257761 on 2022-11-20 13:28:34 ','2022-11-20 13:28:34','',''),('5','92',4961159,'','6.1','2221',0.00,0.00,'Sales from shift 257761 on 2022-11-20 13:28:34 ','2022-11-20 13:28:34','',''),('5','92',4961160,'','20','2222',0.00,0.00,'Sales from shift 257762 on 2022-11-22 13:39:34 ','2022-11-22 13:39:34','',''),('5','92',4961161,'','6.1','2221',0.00,0.00,'Sales from shift 257762 on 2022-11-22 13:39:34 ','2022-11-22 13:39:34','',''),('5','92',4961162,'','6.1','2221',0.00,4104537.39,'Payment Id 392279 for invoice:257730, receipt: 4242 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-22 13:51:02','',''),('5','92',4961163,'','supplier','100',4104537.39,0.00,'Payment Id 392279 for invoice:257730, receipt: 4242 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-22 13:51:02','',''),('5','92',4961164,'','2','2220',0.00,1547470.00,'Payment Id 392028 for invoice:257490, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-22 13:53:22','',''),('5','92',4961165,'','supplier','100',1547470.00,0.00,'Payment Id 392028 for invoice:257490, receipt: 0035 by SALBAS OIL & GAS NIGERIA LIMIT','2022-11-22 13:53:22','',''),('5','92',4961166,'','20','2222',0.00,0.00,'Sales from shift 257763 on 2022-11-23 12:08:20 ','2022-11-23 12:08:20','',''),('5','92',4961167,'','6.1','2221',0.00,0.00,'Sales from shift 257763 on 2022-11-23 12:08:20 ','2022-11-23 12:08:20','',''),('5','92',4961168,'','20','2222',0.00,0.00,'Sales from shift 257764 on 2022-11-24 13:05:11 ','2022-11-24 13:05:11','',''),('5','92',4961169,'','6.1','2221',0.00,0.00,'Sales from shift 257764 on 2022-11-24 13:05:11 ','2022-11-24 13:05:11','',''),('5','92',4961170,'','20','2222',0.00,0.00,'Sales from shift 257765 on 2022-11-24 17:17:53 ','2022-11-24 17:17:53','',''),('5','92',4961171,'','6.1','2221',0.00,0.00,'Sales from shift 257765 on 2022-11-24 17:17:53 ','2022-11-24 17:17:53','',''),('5','92',4961172,'','20','2222',0.00,0.00,'Sales from shift 257766 on 2022-11-25 14:54:50 ','2022-11-25 14:54:50','',''),('5','92',4961173,'','6.1','2221',0.00,0.00,'Sales from shift 257766 on 2022-11-25 14:54:50 ','2022-11-25 14:54:50','',''),('5','92',4961174,'','20','2222',0.00,0.00,'Sales from shift 257767 on 2022-11-27 07:57:41 ','2022-11-27 07:57:41','',''),('5','92',4961175,'','6.1','2221',0.00,0.00,'Sales from shift 257767 on 2022-11-27 07:57:41 ','2022-11-27 07:57:41','',''),('5','92',4961176,'','20','2222',0.00,0.00,'Sales from shift 257768 on 2022-11-28 07:00:40 ','2022-11-28 07:00:40','',''),('5','92',4961177,'','6.1','2221',0.00,0.00,'Sales from shift 257768 on 2022-11-28 07:00:40 ','2022-11-28 07:00:40','',''),('5','92',4961178,'','20','2222',0.00,0.00,'Sales from shift 257769 on 2022-11-28 14:07:21 ','2022-11-28 14:07:21','',''),('5','92',4961179,'','6.1','2221',0.00,0.00,'Sales from shift 257769 on 2022-11-28 14:07:21 ','2022-11-28 14:07:21','',''),('5','92',4961180,'','20','2222',0.00,0.00,'Sales from shift 257770 on 2022-11-30 11:34:14 ','2022-11-30 11:34:14','',''),('5','92',4961181,'','6.1','2221',0.00,0.00,'Sales from shift 257770 on 2022-11-30 11:34:14 ','2022-11-30 11:34:14','',''),('5','92',4961182,'','20','2222',0.00,0.00,'Sales from shift 257771 on 2022-12-02 13:49:35 ','2022-12-02 13:49:35','',''),('5','92',4961183,'','6.1','2221',0.00,0.00,'Sales from shift 257771 on 2022-12-02 13:49:35 ','2022-12-02 13:49:35','',''),('5','92',4961184,'','20','2222',0.00,0.00,'Sales from shift 257772 on 2022-12-05 08:30:35 ','2022-12-05 08:30:35','',''),('5','9