-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_91
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_91`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_91` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_91`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3530 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2316,30091,'',0,'24','5','91','PUBLIC RELATION','','2020-03-12 14:35:14',5,0.00,0.00,'','393','2020-03-12 14:35:14','393',0,1),(2317,30092,'',0,'24','5','91','PURCHASE','','2020-03-12 14:35:31',5,0.00,0.00,'','393','2020-03-12 14:35:31','393',0,1),(2318,30093,'',0,'24','5','91','SALARIES & WAGES','','2020-03-12 14:35:54',5,0.00,0.00,'','393','2020-03-12 14:35:54','393',0,1),(2319,3013,'',0,'6.1','5','91','CASH','','2020-03-12 14:36:10',5,0.00,0.00,'','393','2020-03-12 14:36:10','393',0,1),(2320,30094,'',0,'24','5','91','DIESEL INTERNAL CONSUMPTION','','2020-03-12 14:36:26',5,0.00,0.00,'','393','2020-03-12 14:36:26','393',0,1),(2321,30095,'',0,'24','5','91','CLEANING AND SANITARY','','2020-03-12 14:36:43',5,0.00,0.00,'','393','2020-03-12 14:36:43','393',0,1),(2322,30096,'',0,'24','5','91','TRANSPORT FARE','','2020-03-12 14:36:56',5,0.00,0.00,'','393','2020-03-12 14:36:56','393',0,1),(2323,30097,'',0,'24','5','91','OTHER OPERATING EXPESES','','2020-03-12 14:37:12',5,0.00,0.00,'','393','2020-03-12 14:37:12','393',0,1),(2324,30098,'',0,'24','5','91','PUMP REPAIR AND MAINTENANCE ','','2020-03-12 14:37:29',5,0.00,0.00,'','393','2020-03-12 14:37:29','393',0,1),(2325,30099,'',0,'24','5','91','GENERATOR REPAIR AND MAINTENAN','','2020-03-12 14:37:46',5,0.00,0.00,'','393','2020-03-12 14:37:46','393',0,1),(2326,30100,'',0,'24','5','91','WEIGHT AND MEASURE  ','','2020-03-12 14:41:12',5,0.00,0.00,'','393','2020-03-12 14:41:12','393',0,1),(2327,30101,'',0,'24','5','91','DPR EXPENSES','','2020-03-12 14:41:33',5,0.00,0.00,'','393','2020-03-12 14:41:33','393',0,1),(2328,30102,'',0,'24','5','91','TRAVELLING EXPENSES','','2020-03-12 14:43:40',5,0.00,0.00,'','393','2020-03-12 14:43:40','393',0,1),(2329,30103,'',0,'24','5','91','MEDICAL EXPENSES','','2020-03-12 14:43:57',5,0.00,0.00,'','393','2020-03-12 14:43:57','393',0,1),(2330,30104,'',0,'24','5','91','OFFICIAL CAR FUEL AND MAINTENA','','2020-03-12 14:44:15',5,0.00,0.00,'','393','2020-03-12 14:44:15','393',0,1),(2331,4011,'',0,'20','5','91','SALES','','2020-03-12 14:44:46',5,0.00,0.00,'','393','2020-03-12 14:44:46','393',0,1),(2332,4010,'',0,'2','5','91','UBA1019882661','','2020-03-12 14:45:04',5,0.00,0.00,'','393','2020-03-12 14:45:04','393',0,1),(3527,4046,'',0,'2','5','91','FIRST BANK E-BILLS 2009876215','','2021-07-28 15:14:34',5,0.00,0.00,'','600','2021-07-28 15:14:34','600',0,1),(3528,4047,'',0,'2','5','91','JA\'IZ-0010037957','','2022-03-02 18:59:40',5,0.00,0.00,'','600','2022-03-02 18:59:40','600',0,0),(3529,2000,'',0,'6','5','91','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:21:50',5,0.00,0.00,'','600','2023-02-06 10:21:50','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','91','0000-00-00','2023-02-07 15:16:45',10,'797','','0000-00-00 00:00:00','606','2023-02-08 15:59:00'),(2,'5','91','0000-00-00','2023-02-22 12:26:23',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','91','0000-00-00','2023-02-22 12:29:10',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','91','1','3529','6',0.00,'Pms price increase from 185 to 220 on 20/1/2023  39,988ltrs ×35 = 1,399,580',1399580.00,'2023-01-20'),(2,'5','91','1','109','supplier',1399580.00,'Pms price increase from 185 to 220 on 20/1/2023  39,988ltrs ×35 = 1,399,580',0.00,'2023-01-20'),(3,'5','91','2','109','supplier',0.00,'Ago price decrease from 830 to 820 on 20/1/2023 Dipping 140 × 10 1,400',1400.00,'2023-02-20'),(4,'5','91','2','3529','6',1400.00,'Ago price decrease from 830 to 820 on 20/1/2023 Dipping 140 × 10 1,400',0.00,'2023-02-20'),(5,'5','91','3','109','supplier',0.00,'Pms price increase from 220 to 210 on 20/1/2023  100ltrs ×10 = 1,000',1000.00,'2023-02-22'),(6,'5','91','3','3529','6',1000.00,'Pms price increase from 185 to 220 on 20/1/2023  100ltrs ×10 = 1,000',0.00,'2023-02-19');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=18209 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','91',18205,'642',30.52,500.00,'2021-12-26','','2021-12-26 15:52:53','600','600',2021,'600','2021-12-26 15:52:53',5),('5','91',18206,'643',1823.85,2000.00,'2021-12-26','','2021-12-26 15:53:24','600','600',2021,'600','2021-12-26 15:53:24',5),('5','91',18207,'644',6418.27,6500.00,'2021-12-26','','2021-12-26 15:53:46','600','600',2021,'600','2021-12-26 15:53:46',5),('5','91',18208,'644',1022.61,2000.00,'2022-07-23','','2022-07-23 17:47:15','600','600',2022,'600','2022-07-23 17:47:15',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1783 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','91','642',1775,'5','PUMP 5',3936968.28,'PMS PUMP 5','',NULL,NULL,'',5,'2021-07-26 13:07:17','600'),('5','91','642',1776,'5','PUMP 6',60985.92,'PMS PUMP 6','',NULL,NULL,'',5,'2021-07-26 16:25:27','600'),('5','91','643',1777,'5','PUMP 4',3925528.56,'PMS PUMP 4','',NULL,NULL,'',5,'2021-07-26 13:06:16','600'),('5','91','644',1778,'5','PUMP 2',1501287.38,'PMS PUMP 2','',NULL,NULL,'',5,'2021-07-26 13:04:39','600'),('5','91','644',1779,'5','PUMP 1',196104.37,'PMS PUMP 1','',NULL,NULL,'',5,'2021-07-26 13:03:59','600'),('5','91','643',1780,'5','PUMP 3',2778926.39,'PMS PUMP 3','',NULL,NULL,'',5,'2021-07-26 13:05:23','600'),('5','91','645',1781,'5','PUMP 7',1462024.69,'AGO PUMP 7','',NULL,NULL,'',5,'2021-07-26 16:24:44','600'),('5','91','646',1782,'5','PUMP 8',114285.44,'DPK PUMP 8','',NULL,NULL,'',5,'2021-07-26 16:23:35','600');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (213,'5','91','1780','643','PMS TANKS CONNECTION ERROR.','2021-07-11 08:59:01',0,'600'),(214,'5','91','1778','644','PMS TANKS CONNECTION ERROR.','2021-07-11 09:00:32',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257856 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','91',231309,'daily','2021-10-13','2021-10-13 00:00:00',NULL,'393',684075.14,684075.14,'393','2021-10-13 16:29:33','606','2021-10-13 16:41:48',10,0),('5','91',231315,'daily','2021-10-13','2021-10-13 00:00:00',NULL,'393',1129673.13,1129673.13,'393','2021-10-13 16:46:53','606','2021-10-13 16:54:16',10,0),('5','91',231317,'daily','2021-10-13','2021-10-13 00:00:00',NULL,'393',679369.33,679369.33,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','91',231421,'DAILY','2021-10-03','2021-10-03 00:00:00',NULL,'600',679369.33,679369.33,'393','2021-10-14 08:43:42','606','2021-10-14 08:48:48',10,0),('5','91',231428,'daily','2021-10-14','2021-10-14 00:00:00',NULL,'393',664373.33,664373.33,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','91',231438,'daily','2021-10-14','2021-10-14 00:00:00',NULL,'393',664373.33,664373.33,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','91',231471,'daily','2021-10-04','2021-10-04 00:00:00',NULL,'393',664373.33,664373.33,'393','2021-10-14 10:50:48','606','2021-10-14 10:59:23',10,0),('5','91',231476,'daily','2021-10-05','2021-10-05 00:00:00',NULL,'393',361313.95,361313.95,'393','2021-10-14 11:03:20','606','2021-10-14 11:09:10',10,0),('5','91',231478,'daily','2021-10-06','2021-10-06 00:00:00',NULL,'393',246133.26,246133.26,'393','2021-10-14 11:11:37','606','2021-10-14 11:19:19',10,0),('5','91',231484,'daily','2021-10-07','2021-10-07 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-14 11:21:05','606','2021-10-14 11:26:26',10,0),('5','91',231492,'daily','2021-10-08','2021-10-08 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-14 11:34:31','606','2021-10-14 11:37:29',10,0),('5','91',231493,'daily','2021-10-09','2021-10-09 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-14 11:39:48','606','2021-10-14 11:40:53',10,0),('5','91',231496,'daily','2021-10-10','2021-10-10 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-14 11:42:42','606','2021-10-14 11:43:44',10,0),('5','91',231497,'daily','2021-10-11','2021-10-11 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-14 11:45:10','606','2021-10-14 11:46:19',10,0),('5','91',231501,'daily','2021-10-12','2021-10-12 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-14 11:48:04','606','2021-10-14 11:48:53',10,0),('5','91',231502,'daily','2021-10-13','2021-10-13 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-14 11:49:47','606','2021-10-14 11:53:08',10,0),('5','91',231503,'daily','2021-10-14','2021-10-14 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-14 21:55:39','606','2021-10-15 06:03:40',10,0),('5','91',231648,'daily','2021-10-15','2021-10-15 00:00:00',NULL,'393',0.00,0.00,'393','2021-10-15 19:02:22','606','2021-10-16 06:21:41',10,0),('5','91',231934,'daily','2021-10-16','2021-10-16 00:00:00',NULL,'393',1046632.78,1046632.78,'393','2021-10-17 06:28:16','606','2021-10-17 06:51:48',10,0),('5','91',232197,'daily','2021-10-17','2021-10-17 00:00:00',NULL,'393',695654.66,695654.66,'393','2021-10-17 18:56:25','606','2021-10-18 06:14:40',10,0),('5','91',232405,'daily','2021-10-18','2021-10-18 00:00:00',NULL,'393',1380147.08,1380147.08,'393','2021-10-18 19:07:12','606','2021-10-19 05:54:54',10,0),('5','91',232698,'daily','2021-10-19','2021-10-19 00:00:00',NULL,'393',794413.10,794413.10,'393','2021-10-19 19:50:17','606','2021-10-20 05:52:23',10,0),('5','91',232859,'daily','2021-10-20','2021-10-20 00:00:00',NULL,'393',902291.39,902291.39,'393','2021-10-21 16:32:15','606','2021-10-21 17:04:59',10,0),('5','91',233309,'daily','2021-10-21','2021-10-21 00:00:00',NULL,'393',681499.74,681499.74,'393','2021-10-21 20:45:22','606','2021-10-22 06:00:59',10,0),('5','91',233428,'daily','2021-10-22','2021-10-22 00:00:00',NULL,'393',763524.60,763524.60,'393','2021-10-22 20:01:49','606','2021-10-23 06:19:22',10,0),('5','91',233641,'daily','2021-10-23','2021-10-23 00:00:00',NULL,'393',1320956.89,1320956.89,'393','2021-10-24 06:56:43','606','2021-10-24 13:05:49',10,0),('5','91',234004,'daily','2021-10-24','2021-10-24 00:00:00',NULL,'393',803875.25,803875.25,'393','2021-10-24 20:56:50','606','2021-10-25 06:06:50',10,0),('5','91',234074,'daily','2021-10-25','2021-10-25 00:00:00',NULL,'393',1020500.62,1020500.62,'393','2021-10-25 20:58:37','606','2021-10-26 05:41:57',10,0),('5','91',234367,'daily','2021-10-26','2021-10-26 00:00:00',NULL,'393',768134.24,768134.24,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','91',234648,'daily','2021-10-26','2021-10-26 00:00:00',NULL,'393',777559.20,777559.20,'393','2021-10-27 09:17:22','606','2021-10-27 10:58:03',10,0),('5','91',234732,'daily','2021-10-27','2021-10-27 00:00:00',NULL,'393',922023.30,922023.30,'393','2021-10-27 19:54:25','606','2021-10-28 07:22:15',10,0),('5','91',234901,'daily','2021-10-28','2021-10-28 00:00:00',NULL,'393',821508.60,821508.60,'393','2021-10-28 19:42:53','606','2021-10-29 06:09:10',10,0),('5','91',235129,'daily','2021-10-29','2021-10-29 00:00:00',NULL,'393',960039.30,960039.30,'393','2021-10-29 20:31:33','606','2021-10-30 07:15:57',10,0),('5','91',235449,'daily','2021-10-30','2021-10-30 00:00:00',NULL,'393',1224557.40,1224557.40,'393','2021-10-30 20:35:28','606','2021-10-31 06:14:09',10,0),('5','91',235609,'daily','2021-10-31','2021-10-31 00:00:00',NULL,'393',1158222.45,1158222.45,'393','2021-10-31 20:17:05','606','2021-11-01 07:26:16',10,0),('5','91',235896,'daily','2021-11-01','2021-11-01 00:00:00',NULL,'393',1307941.80,1307941.80,'393','2021-11-01 20:14:43','606','2021-11-02 06:20:46',10,0),('5','91',236096,'daily','2021-11-02','2021-11-02 00:00:00',NULL,'393',786152.40,786152.40,'393','2021-11-02 21:18:17','606','2021-11-03 06:25:10',10,0),('5','91',236458,'daily','2021-11-03','2021-11-03 00:00:00',NULL,'393',553050.30,553050.30,'393','2021-11-03 19:09:19','606','2021-11-04 06:15:50',10,0),('5','91',236693,'daily','2021-11-04','2021-11-04 00:00:00',NULL,'393',559350.00,559350.00,'393','2021-11-04 19:19:08','606','2021-11-05 06:35:48',10,0),('5','91',236814,'daily','2021-11-05','2021-11-05 00:00:00',NULL,'393',70827.90,70827.90,'393','2021-11-05 19:56:36','606','2021-11-06 07:06:25',10,0),('5','91',237127,'daily','2021-11-06','2021-11-06 00:00:00',NULL,'393',0.00,0.00,'393','2021-11-06 19:00:07','606','2021-11-07 06:29:20',10,0),('5','91',237253,'daily','2021-11-07','2021-11-07 00:00:00',NULL,'393',40707.00,46813.05,'393','2021-11-08 05:56:34','606','2021-11-08 06:33:27',10,0),('5','91',237494,'daily','2021-11-08','2021-11-08 00:00:00',NULL,'393',56086.65,56086.65,'393','2021-11-08 19:43:34','606','2021-11-09 06:16:44',10,0),('5','91',237689,'daily','2021-11-09','2021-11-09 00:00:00',NULL,'393',122478.45,122478.45,'393','2021-11-09 18:54:12','606','2021-11-10 05:52:54',10,0),('5','91',238065,'daily','2021-11-10','2021-11-10 00:00:00',NULL,'393',139794.00,139794.00,'393','2021-11-10 18:40:29','606','2021-11-11 05:48:48',10,0),('5','91',238182,'daily','2021-11-11','2021-11-11 00:00:00',NULL,'393',284024.70,284024.70,'393','2021-11-11 18:23:35','606','2021-11-12 07:29:18',10,0),('5','91',238573,'daily','2021-11-12','2021-11-12 00:00:00',NULL,'393',89703.45,89703.45,'393','2021-11-12 21:17:53','606','2021-11-13 07:07:07',10,0),('5','91',238701,'daily','2021-11-13','2021-11-13 00:00:00',NULL,'393',244936.20,244936.20,'393','2021-11-13 19:12:20','606','2021-11-14 05:50:53',10,0),('5','91',238884,'daily','2021-11-14','2021-11-14 00:00:00',NULL,'393',297859.20,297859.20,'393','2021-11-14 17:51:52','606','2021-11-15 06:24:08',10,0),('5','91',239244,'daily','2021-11-15','2021-11-15 00:00:00',NULL,'393',490200.15,490200.15,'393','2021-11-15 18:56:23','606','2021-11-16 07:17:56',10,0),('5','91',239479,'daily','2021-11-16','2021-11-16 00:00:00',NULL,'393',437377.20,437377.20,'393','2021-11-16 20:20:01','606','2021-11-17 05:48:20',10,0),('5','91',239699,'daily','2021-11-17','2021-11-17 00:00:00',NULL,'393',192030.45,192030.45,'393','2021-11-17 18:50:21','606','2021-11-18 06:08:29',10,0),('5','91',239943,'daily','2021-11-18','2021-11-18 00:00:00',NULL,'393',1661333.85,1661333.85,'393','2021-11-19 09:07:28','606','2021-11-19 19:29:17',10,0),('5','91',240158,'daily','2021-11-19','2021-11-19 00:00:00',NULL,'393',1195773.45,1195773.45,'393','2021-11-19 19:57:02','606','2021-11-20 07:10:08',10,0),('5','91',240387,'daily','2021-11-20','2021-11-20 00:00:00',NULL,'393',1882263.45,1882263.45,'393','2021-11-20 19:25:39','606','2021-11-21 06:40:30',10,0),('5','91',240595,'daily','2021-11-21','2021-11-21 00:00:00',NULL,'393',1499830.35,1499830.35,'393','2021-11-21 18:59:13','606','2021-11-22 06:22:35',10,0),('5','91',240778,'daily','2021-11-22','2021-11-22 00:00:00',NULL,'393',1889142.00,1889142.00,'393','2021-11-22 17:50:42','606','2021-11-23 07:02:45',10,0),('5','91',241191,'daily','2021-11-23','2021-11-23 00:00:00',NULL,'393',1058465.55,1058465.55,'393','2021-11-23 21:36:50','606','2021-11-24 06:23:09',10,0),('5','91',241431,'daily','2021-11-24','2021-11-24 00:00:00',NULL,'393',108385.20,108385.20,'393','2021-11-24 19:28:56','606','2021-11-25 06:27:33',10,0),('5','91',241592,'daily','2021-11-25','2021-11-25 00:00:00',NULL,'393',97321.05,97321.05,'393','2021-11-25 20:59:02','606','2021-11-26 06:11:49',10,0),('5','91',241919,'daily','2021-11-26','2021-11-26 00:00:00',NULL,'393',100077.60,100077.60,'393','2021-11-26 19:54:05','606','2021-11-27 07:10:58',10,0),('5','91',242149,'daily','2021-11-27','2021-11-27 00:00:00',NULL,'393',594536.25,594536.25,'393','2021-11-28 14:26:22','606','2021-11-28 15:52:22',10,0),('5','91',242362,'daily','2021-11-28','2021-11-28 00:00:00',NULL,'393',2710794.90,2710794.90,'393','2021-11-28 19:09:38','606','2021-11-29 05:59:35',10,0),('5','91',242493,'daily','2021-11-29','2021-11-29 00:00:00',NULL,'393',3219623.55,3219623.55,'393','2021-11-29 17:51:43','606','2021-11-30 06:03:23',10,0),('5','91',242833,'daily','2021-11-30','2021-11-30 00:00:00',NULL,'393',1484577.60,1484577.60,'393','2021-11-30 17:28:36','606','2021-12-01 07:54:06',10,0),('5','91',242990,'daily','2021-12-01','2021-12-01 00:00:00',NULL,'393',741996.75,741996.75,'393','2021-12-01 17:52:08','606','2021-12-02 07:21:47',10,0),('5','91',243232,'daily','2021-12-02','2021-12-02 00:00:00',NULL,'393',740087.70,740087.70,'393','2021-12-02 19:18:20','606','2021-12-03 06:58:20',10,0),('5','91',243457,'daily','2021-12-03','2021-12-03 00:00:00',NULL,'393',434072.10,434072.10,'393','2021-12-03 17:21:42','606','2021-12-04 06:56:49',10,0),('5','91',243767,'daily','2021-12-04','2021-12-04 00:00:00',NULL,'393',0.00,0.00,'393','2021-12-04 18:26:23','606','2021-12-05 05:47:35',10,0),('5','91',244029,'daily','2021-12-05','2021-12-05 00:00:00',NULL,'393',0.00,0.00,'393','2021-12-06 04:54:27','606','2021-12-06 06:30:49',10,0),('5','91',244225,'daily','2021-12-06','2021-12-06 00:00:00',NULL,'393',0.00,0.00,'393','2021-12-06 17:55:52','606','2021-12-07 06:53:03',10,0),('5','91',244463,'daily','2021-12-07','2021-12-07 00:00:00',NULL,'393',0.00,0.00,'393','2021-12-07 18:47:58','606','2021-12-08 07:18:56',10,0),('5','91',244617,'daily','2021-12-08','2021-12-08 00:00:00',NULL,'393',0.00,0.00,'393','2021-12-08 19:19:17','600','2021-12-09 14:35:33',10,0),('5','91',244923,'daily','2021-12-09','2021-12-09 00:00:00',NULL,'393',0.00,0.00,'393','2021-12-09 18:59:23','606','2021-12-10 06:16:53',10,0),('5','91',245162,'daily','2021-12-10','2021-12-10 00:00:00',NULL,'393',0.00,0.00,'393','2021-12-10 18:36:50','606','2021-12-11 07:01:12',10,0),('5','91',245381,'daily','2021-12-11','2021-12-11 00:00:00',NULL,'393',0.00,0.00,'393','2021-12-11 21:19:15','606','2021-12-12 06:51:23',10,0),('5','91',245525,'daily','2021-12-12','2021-12-12 00:00:00',NULL,'393',1052770.95,1052770.95,'393','2021-12-12 20:03:20','606','2021-12-13 06:02:04',10,0),('5','91',245764,'daily','2021-12-13','2021-12-13 00:00:00',NULL,'393',1711917.90,1711917.90,'393','2021-12-13 18:26:14','606','2021-12-14 06:08:37',10,0),('5','91',246047,'daily','2021-12-14','2021-12-14 00:00:00',NULL,'393',966688.80,966688.80,'393','2021-12-14 19:14:43','606','2021-12-15 06:40:37',10,0),('5','91',246304,'daily','2021-12-15','2021-12-15 00:00:00',NULL,'393',879068.85,879068.85,'393','2021-12-15 18:58:44','606','2021-12-16 06:52:23',10,0),('5','91',246564,'daily','2021-12-16','2021-12-16 00:00:00',NULL,'393',1357936.80,1357936.80,'393','2021-12-16 19:58:27','606','2021-12-17 06:12:36',10,0),('5','91',246795,'daily','2021-12-17','2021-12-17 00:00:00',NULL,'393',1343621.25,1343621.25,'393','2021-12-17 17:55:19','606','2021-12-18 07:04:14',10,0),('5','91',247103,'daily','2021-12-18','2021-12-18 00:00:00',NULL,'393',1469105.70,1469105.70,'393','2021-12-18 18:39:28','606','2021-12-19 07:13:51',10,0),('5','91',247233,'daily','2021-12-19','2021-12-19 00:00:00',NULL,'393',1577614.95,1577614.95,'393','2021-12-19 17:40:09','606','2021-12-20 06:57:13',10,0),('5','91',247436,'daily','2021-12-20','2021-12-20 00:00:00',NULL,'393',241569.00,241569.00,'393','2021-12-20 18:03:44','600','2021-12-21 09:20:09',10,0),('5','91',247868,'daily','2021-12-21','2021-12-21 00:00:00',NULL,'393',764586.45,764586.45,'393','2021-12-21 20:41:25','600','2021-12-22 06:35:13',10,0),('5','91',247960,'daily','2021-12-22','2021-12-22 00:00:00',NULL,'393',1117586.25,1117586.25,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','91',248104,'daily','2021-12-22','2021-12-22 00:00:00',NULL,'393',1270397.10,1270397.10,'393','2021-12-22 20:17:41','606','2021-12-23 06:33:41',10,0),('5','91',248235,'daily','2021-12-23','2021-12-23 00:00:00',NULL,'393',2232744.15,2232744.15,'393','2021-12-23 18:04:40','606','2021-12-24 07:21:40',10,0),('5','91',248455,'daily','2021-12-24','2021-12-24 00:00:00',NULL,'393',1227910.20,1227910.20,'393','2021-12-24 19:48:12','606','2021-12-25 14:10:06',10,0),('5','91',248805,'daily','2021-12-25','2021-12-25 00:00:00',NULL,'393',1270177.95,1270177.95,'393','2021-12-25 18:36:36','606','2021-12-26 07:33:11',10,0),('5','91',248911,'daily','2021-12-26','2021-12-26 00:00:00',NULL,'393',1251453.60,1251453.60,'393','2021-12-26 18:32:49','606','2021-12-27 07:42:45',10,0),('5','91',249173,'daily','2021-12-27','2021-12-27 00:00:00',NULL,'393',315193.80,315193.80,'393','2021-12-27 17:50:52','606','2021-12-28 07:37:33',10,0),('5','91',249439,'daily','2021-12-28','2021-12-28 00:00:00',NULL,'393',110406.90,110406.90,'393','2021-12-28 19:50:58','606','2021-12-29 06:47:12',10,0),('5','91',249682,'daily','2021-12-29','2021-12-29 00:00:00',NULL,'393',88251.00,88251.00,'393','2021-12-29 19:21:00','606','2021-12-30 06:59:14',10,0),('5','91',249935,'daily','2021-12-30','2021-12-30 00:00:00',NULL,'393',364420.05,364420.05,'393','2021-12-30 18:31:19','606','2021-12-31 06:48:18',10,0),('5','91',250156,'daily','2021-12-31','2021-12-31 00:00:00',NULL,'393',155260.35,155260.35,'393','2021-12-31 17:47:25','606','2022-01-01 07:50:40',10,0),('5','91',250380,'daily','2022-01-01','2022-01-01 00:00:00',NULL,'393',207179.40,207179.40,'393','2022-01-01 19:36:50','606','2022-01-02 06:48:14',10,0),('5','91',250634,'daily','2022-01-02','2022-01-02 00:00:00',NULL,'393',191499.15,191499.15,'393','2022-01-02 18:42:27','606','2022-01-03 14:06:52',10,0),('5','91',250977,'daily','2022-01-03','2022-01-03 00:00:00',NULL,'393',276693.45,276693.45,'393','2022-01-04 05:09:33','606','2022-01-04 07:06:16',10,0),('5','91',251117,'daily','2022-01-04','2022-01-04 00:00:00',NULL,'393',3488706.15,3488706.15,'393','2022-01-05 06:29:47','606','2022-01-05 07:36:32',10,0),('5','91',251434,'daily','2022-01-05','2022-01-05 00:00:00',NULL,'393',1610337.75,1610337.75,'393','2022-01-05 20:16:50','606','2022-01-06 07:50:34',10,0),('5','91',251612,'daily','2022-01-06','2022-01-06 00:00:00',NULL,'393',2404485.75,2404485.75,'393','2022-01-06 20:41:07','606','2022-01-07 09:10:44',10,0),('5','91',251936,'daily','2022-01-07','2022-01-07 00:00:00',NULL,'393',1371218.10,1371218.10,'393','2022-01-07 19:38:33','606','2022-01-08 07:59:40',10,0),('5','91',252097,'daily','2022-01-08','2022-01-08 00:00:00',NULL,'393',1950245.25,1950245.25,'393','2022-01-09 06:59:55','606','2022-01-09 08:03:46',10,0),('5','91',252323,'daily','2022-01-09','2022-01-09 00:00:00',NULL,'393',1356807.60,1356807.60,'393','2022-01-09 18:39:36','606','2022-01-10 07:03:26',10,0),('5','91',252571,'daily','2022-01-10','2022-01-10 00:00:00',NULL,'393',1274627.10,1274627.10,'393','2022-01-10 19:02:54','606','2022-01-11 05:36:00',10,0),('5','91',252809,'daily','2022-01-11','2022-01-11 00:00:00',NULL,'393',228145.95,228145.95,'393','2022-01-11 20:16:21','606','2022-01-12 07:50:49',10,0),('5','91',253068,'daily','2022-01-12','2022-01-12 00:00:00',NULL,'393',97662.60,97662.60,'393','2022-01-12 20:40:58','606','2022-01-13 07:36:16',10,0),('5','91',253332,'daily','2022-01-13','2022-01-13 00:00:00',NULL,'393',88247.55,88247.55,'393','2022-01-13 19:33:16','606','2022-01-14 09:42:21',10,0),('5','91',253561,'daily','2022-01-14','2022-01-14 00:00:00',NULL,'393',0.00,0.00,'393','2022-01-14 21:03:02','606','2022-01-15 07:16:34',10,0),('5','91',253762,'daily','2022-01-14','2022-01-14 00:00:00',NULL,'393',102140.70,102140.70,'393','2022-01-15 09:31:31','606','2022-01-15 10:31:58',10,0),('5','91',253834,'daily','2022-01-15','2022-01-15 00:00:00',NULL,'393',91235.25,91235.25,'393','2022-01-15 20:53:27','606','2022-01-16 07:23:20',10,0),('5','91',254021,'daily','2022-01-16','2022-01-16 00:00:00',NULL,'393',99629.10,99629.10,'393','2022-01-16 21:12:10','606','2022-01-17 07:15:01',10,0),('5','91',254307,'daily','2022-01-17','2022-01-17 00:00:00',NULL,'393',62113.80,62113.80,'393','2022-01-17 21:36:20','606','2022-01-18 08:40:50',10,0),('5','91',254551,'daily','2022-01-18','2022-01-18 00:00:00',NULL,'393',49831.80,49831.80,'393','2022-01-18 20:37:48','606','2022-01-19 10:07:11',10,0),('5','91',254927,'daily','2022-01-19','2022-01-19 00:00:00',NULL,'393',0.00,0.00,'393','2022-01-20 05:53:01','606','2022-01-20 08:09:13',10,0),('5','91',255051,'daily','2022-01-20','2022-01-20 00:00:00',NULL,'393',1288716.00,1288716.00,'393','2022-01-20 20:35:11','606','2022-01-21 08:37:19',10,0),('5','91',255246,'daily','2022-01-21','2022-01-21 00:00:00',NULL,'393',960986.40,960986.40,'393','2022-01-21 18:44:15','606','2022-01-22 08:08:41',10,0),('5','91',255547,'daily','2022-01-22','2022-01-22 00:00:00',NULL,'393',948289.65,948289.65,'393','2022-01-22 20:21:29','606','2022-01-23 07:24:36',10,0),('5','91',255817,'daily','2022-01-23','2022-01-23 00:00:00',NULL,'393',1092036.00,1092036.00,'393','2022-01-23 20:47:14','606','2022-01-24 08:34:22',10,0),('5','91',256038,'daily','2022-01-24','2022-01-24 00:00:00',NULL,'393',808046.25,808046.25,'393','2022-01-24 19:10:25','606','2022-01-25 07:34:33',10,0),('5','91',256310,'daily','2022-01-25','2022-01-25 00:00:00',NULL,'393',682154.55,682154.55,'393','2022-01-25 21:05:37','606','2022-01-26 08:09:48',10,0),('5','91',256678,'daily','2022-01-26','2022-01-26 00:00:00',NULL,'393',527089.20,527089.20,'393','2022-01-26 20:17:55','606','2022-01-27 07:58:20',10,0),('5','91',256820,'daily','2022-01-27','2022-01-27 00:00:00',NULL,'393',550395.45,550395.45,'393','2022-01-27 20:51:06','606','2022-01-28 07:23:58',10,0),('5','91',257149,'daily','2022-01-28','2022-01-28 00:00:00',NULL,'393',338081.70,338081.70,'393','2022-01-28 20:21:22','606','2022-01-29 07:52:13',10,0),('5','91',257438,'daily','2022-01-29','2022-01-29 00:00:00',NULL,'393',198000.00,198000.00,'393','2022-01-29 20:30:48','606','2022-01-30 07:46:00',10,0),('5','91',257439,'daily','2022-01-30','2022-01-30 00:00:00',NULL,'393',0.00,0.00,'393','2022-01-31 07:32:01','606','2022-01-31 09:30:26',10,0),('5','91',257440,'daily','2022-01-31','2022-01-31 00:00:00',NULL,'393',0.00,0.00,'393','2022-01-31 20:39:58','606','2022-02-01 08:29:25',10,0),('5','91',257441,'daily','2022-02-01','2022-02-01 00:00:00',NULL,'393',0.00,0.00,'393','2022-02-01 19:16:44','606','2022-02-02 08:33:00',10,0),('5','91',257442,'daily','2022-02-02','2022-02-02 00:00:00',NULL,'393',132820.05,132820.05,'393','2022-02-03 07:18:24','606','2022-02-03 09:47:02',10,0),('5','91',257443,'daily','2022-02-03','2022-02-03 00:00:00',NULL,'393',995501.10,995501.10,'393','2022-02-03 19:14:47','606','2022-02-04 06:27:06',10,0),('5','91',257444,'daily','2022-02-04','2022-02-04 00:00:00',NULL,'393',950934.60,950934.60,'393','2022-02-04 19:12:30','606','2022-02-05 07:50:43',10,0),('5','91',257445,'daily','2022-02-05','2022-02-05 00:00:00',NULL,'393',876107.10,876107.10,'393','2022-02-05 20:20:38','606','2022-02-06 07:46:46',10,0),('5','91',257446,'daily','2022-02-06','2022-02-06 00:00:00',NULL,'393',868545.15,868545.15,'393','2022-02-06 20:57:02','606','2022-02-07 07:16:18',10,0),('5','91',257447,'daily','2022-02-07','2022-02-07 00:00:00',NULL,'393',1101403.05,1101403.05,'393','2022-02-07 20:42:45','606','2022-02-08 07:42:22',10,0),('5','91',257448,'daily','2022-02-08','2022-02-08 00:00:00',NULL,'393',1160618.25,1160618.25,'393','2022-02-08 19:58:56','606','2022-02-09 08:17:41',10,0),('5','91',257449,'daily','2022-02-09','2022-02-09 00:00:00',NULL,'393',2092996.95,2092996.95,'393','2022-02-09 19:53:41','606','2022-02-10 07:59:51',10,0),('5','91',257450,'daily','2022-02-10','2022-02-10 00:00:00',NULL,'393',1601227.65,1601227.65,'393','2022-02-10 21:44:27','606','2022-02-11 08:11:31',10,0),('5','91',257451,'daily','2022-02-11','2022-02-11 00:00:00',NULL,'393',1198140.90,1198140.90,'393','2022-02-11 22:09:15','606','2022-02-12 08:12:35',10,0),('5','91',257452,'daily','2022-02-12','2022-02-12 00:00:00',NULL,'393',1371069.15,1371069.15,'393','2022-02-13 21:18:46','606','2022-02-13 21:52:43',10,0),('5','91',257453,'daily','2022-02-13','2022-02-13 00:00:00',NULL,'393',1385673.30,1385673.30,'393','2022-02-13 22:11:19','606','2022-02-14 07:20:21',10,0),('5','91',257454,'daily','2022-02-14','2022-02-14 00:00:00',NULL,'393',1575324.30,1575324.30,'393','2022-02-14 21:31:24','606','2022-02-15 08:09:43',10,0),('5','91',257455,'daily','2022-02-15','2022-02-15 00:00:00',NULL,'393',3322473.00,3322473.00,'393','2022-02-15 21:04:58','606','2022-02-16 07:32:16',10,0),('5','91',257456,'daily','2022-02-16','2022-02-16 00:00:00',NULL,'393',929949.90,929949.90,'393','2022-02-16 21:43:25','606','2022-02-17 07:09:05',10,0),('5','91',257457,'daily','2022-02-17','2022-02-17 00:00:00',NULL,'393',165333.30,165333.30,'393','2022-02-17 21:36:03','606','2022-02-17 23:36:03',10,0),('5','91',257458,'daily','2022-02-18','2022-02-18 00:00:00',NULL,'393',1112352.45,1112352.45,'393','2022-02-19 08:11:53','606','2022-02-19 10:59:05',10,0),('5','91',257459,'daily','2022-02-19','2022-02-19 00:00:00',NULL,'393',1457806.35,1457806.35,'393','2022-02-19 22:04:37','606','2022-02-20 07:21:18',10,0),('5','91',257460,'daily','2022-02-20','2022-02-20 00:00:00',NULL,'393',1172993.25,1172993.25,'393','2022-02-20 22:00:36','606','2022-02-21 07:24:59',10,0),('5','91',257461,'daily','2022-02-21','2022-02-21 00:00:00',NULL,'393',1100810.70,1100810.70,'393','2022-02-21 22:56:09','606','2022-02-22 06:42:50',10,0),('5','91',257462,'daily','2022-02-22','2022-02-22 23:28:34','2022-02-23 23:28:34','393',2638713.00,2638713.00,'393','2022-02-22 23:29:53','606','2022-02-23 07:02:07',10,0),('5','91',257463,'daily','2022-02-23','2022-02-23 10:51:31','2022-02-24 10:51:31','393',999350.55,999350.55,'393','2022-02-23 21:14:05','606','2022-02-24 09:37:49',10,0),('5','91',257464,'daily','2022-02-24','2022-02-24 10:17:31','2022-02-25 10:17:31','393',1103861.55,1103861.55,'393','2022-02-24 21:37:33','606','2022-02-25 08:10:48',10,0),('5','91',257465,'daily','2022-02-25','2022-02-25 12:17:35','2022-02-26 12:17:35','393',1370889.30,1370889.30,'393','2022-02-26 07:14:35','606','2022-02-26 07:19:44',10,0),('5','91',257466,'daily','2022-02-26','2022-02-26 22:17:08','2022-02-27 22:17:08','393',2624625.30,2624625.30,'393','2022-02-26 22:19:41','606','2022-02-27 07:02:17',10,0),('5','91',257467,'daily','2022-02-27','2022-02-27 18:58:00','2022-02-28 18:58:00','393',3116440.80,3116440.80,'393','2022-02-28 11:00:40','606','2022-02-28 19:59:35',10,0),('5','91',257468,'daily','2022-02-28','2022-02-28 21:44:50','2022-03-01 21:44:50','393',1547871.60,1547871.60,'393','2022-02-28 21:47:23','606','2022-03-01 06:54:28',10,0),('5','91',257469,'daily','2022-03-01','2022-03-01 22:32:48','2022-03-02 22:32:48','393',322946.25,322946.25,'393','2022-03-01 22:34:26','606','2022-03-02 08:19:06',10,0),('5','91',257470,'daily','2022-03-02','2022-03-02 17:06:50','2022-03-03 17:06:50','393',0.00,0.00,'393','2022-03-02 20:32:41','606','2022-03-03 09:44:39',10,0),('5','91',257471,'daily','2022-03-03','2022-03-03 20:27:40','2022-03-04 20:27:40','393',0.00,0.00,'393','2022-03-03 20:28:26','606','2022-03-04 09:13:14',10,0),('5','91',257472,'daily','2022-03-04','2022-03-04 20:13:11','2022-03-05 20:13:11','393',0.00,0.00,'393','2022-03-04 20:16:54','606','2022-03-05 07:33:15',10,0),('5','91',257473,'daily','2022-03-05','2022-03-05 18:25:04','2022-03-06 18:25:04','393',0.00,0.00,'393','2022-03-05 18:25:29','606','2022-03-06 07:42:40',10,0),('5','91',257474,'daily','2022-03-06','2022-03-06 22:32:40','2022-03-07 22:32:40','393',0.00,0.00,'393','2022-03-06 22:33:39','606','2022-03-07 07:58:55',10,0),('5','91',257475,'daily','2022-03-07','2022-03-07 20:31:49','2022-03-08 20:31:49','393',0.00,0.00,'393','2022-03-07 20:32:29','606','2022-03-08 07:03:23',10,0),('5','91',257476,'daily','2022-03-08','2022-03-08 21:32:19','2022-03-09 21:32:19','393',188596.65,188596.65,'393','2022-03-09 20:58:15','606','2022-03-09 21:04:17',10,0),('5','91',257477,'daily','2022-03-09','2022-03-09 21:09:30','2022-03-10 21:09:30','393',852111.15,852111.15,'393','2022-03-09 21:11:45','606','2022-03-10 06:39:19',10,0),('5','91',257478,'daily','2022-03-10','2022-03-10 12:01:03','2022-03-11 12:01:03','393',991390.95,991390.95,'393','2022-03-10 21:22:16','606','2022-03-11 08:24:49',10,0),('5','91',257479,'daily','2022-03-11','2022-03-11 20:41:17','2022-03-12 20:41:17','393',1114815.90,1114815.90,'393','2022-03-11 20:46:10','606','2022-03-12 07:56:21',10,0),('5','91',257480,'daily','2022-03-12','2022-03-12 22:13:11','2022-03-13 22:13:11','393',1264591.35,1264591.35,'393','2022-03-12 22:16:32','606','2022-03-13 08:06:47',10,0),('5','91',257481,'daily','2022-03-13','2022-03-13 18:25:24','2022-03-14 18:25:24','393',1343962.95,1343962.95,'393','2022-03-13 21:19:02','606','2022-03-14 07:06:25',10,0),('5','91',257482,'daily','2022-03-14','2022-03-14 21:20:52','2022-03-15 21:20:52','393',1293233.70,1293233.70,'393','2022-03-14 21:22:50','606','2022-03-15 07:07:50',10,0),('5','91',257483,'daily','2022-03-15','2022-03-15 17:55:09','2022-03-16 17:55:09','393',1334632.20,1334632.20,'393','2022-03-15 17:58:18','606','2022-03-16 08:09:51',10,0),('5','91',257484,'daily','2022-03-16','2022-03-16 17:54:21','2022-03-17 17:54:21','393',1539953.25,1539953.25,'393','2022-03-16 17:57:46','606','2022-03-17 10:22:24',10,0),('5','91',257485,'daily','2022-03-17','2022-03-17 20:51:15','2022-03-18 20:51:15','393',855980.40,855980.40,'393','2022-03-17 20:54:04','606','2022-03-18 07:47:19',10,0),('5','91',257486,'daily','2022-03-18','2022-03-18 19:18:32','2022-03-19 19:18:32','393',902180.40,902180.40,'393','2022-03-18 19:20:42','606','2022-03-19 07:00:41',10,0),('5','91',257487,'daily','2022-03-19','2022-03-19 15:38:00','2022-03-20 15:38:00','393',665461.50,665461.50,'393','2022-03-19 18:37:49','606','2022-03-20 07:31:00',10,0),('5','91',257488,'daily','2022-03-20','2022-03-20 12:01:01','2022-03-21 12:01:01','393',660732.60,660732.60,'393','2022-03-20 21:20:13','606','2022-03-21 06:32:57',10,0),('5','91',257489,'daily','2022-03-21','2022-03-21 06:44:32','2022-03-22 06:44:32','393',637208.55,637208.55,'393','2022-03-21 21:49:36','606','2022-03-22 07:06:25',10,0),('5','91',257490,'daily','2022-03-22','2022-03-22 21:58:00','2022-03-23 21:58:00','393',372365.40,372365.40,'393','2022-03-22 22:00:15','606','2022-03-23 06:33:06',10,0),('5','91',257491,'daily','2022-03-23','2022-03-24 04:38:58','2022-03-25 04:38:58','393',0.00,0.00,'393','2022-03-24 04:39:32','606','2022-03-24 20:33:51',10,0),('5','91',257492,'daily','2022-03-24','2022-03-24 21:55:03','2022-03-25 21:55:03','393',0.00,0.00,'393','2022-03-24 21:57:14','606','2022-03-25 08:28:13',10,0),('5','91',257493,'daily','2022-03-25','2022-03-25 21:28:24','2022-03-26 21:28:24','393',0.00,0.00,'393','2022-03-25 21:29:42','606','2022-03-26 08:05:02',10,0),('5','91',257494,'daily','2022-03-26','2022-03-26 19:53:55','2022-03-27 19:53:55','393',0.00,0.00,'393','2022-03-26 19:55:14','606','2022-03-27 07:05:39',10,0),('5','91',257495,'daily','2022-03-27','2022-03-27 19:52:45','2022-03-28 19:52:45','393',0.00,0.00,'393','2022-03-27 19:55:32','606','2022-03-28 09:20:54',10,0),('5','91',257496,'daily','2022-03-28','2022-03-28 20:59:58','2022-03-29 20:59:58','393',0.00,0.00,'393','2022-03-28 21:00:29','606','2022-03-29 07:20:21',10,0),('5','91',257497,'daily','2022-03-29','2022-03-29 17:47:52','2022-03-30 17:47:52','393',0.00,0.00,'393','2022-03-29 17:48:40','606','2022-03-30 06:41:43',10,0),('5','91',257498,'daily','2022-03-30','2022-03-30 16:30:41','2022-03-31 16:30:41','393',0.00,0.00,'393','2022-03-30 16:32:00','606','2022-03-31 08:03:14',10,0),('5','91',257499,'daily','2022-03-31','2022-03-31 13:06:21','2022-04-01 13:06:21','393',0.00,0.00,'393','2022-03-31 13:07:15','797','2022-04-01 07:33:32',10,0),('5','91',257500,'daily','2022-04-01','2022-04-01 17:28:59','2022-04-02 17:28:59','393',0.00,0.00,'393','2022-04-01 17:29:44','797','2022-04-01 19:08:07',10,0),('5','91',257501,'daily','2022-04-02','2022-04-02 20:19:38','2022-04-03 20:19:38','393',0.00,0.00,'393','2022-04-02 20:21:12','797','2022-04-02 21:17:03',10,0),('5','91',257502,'daily','2022-04-03','2022-04-03 15:07:34','2022-04-04 15:07:34','393',0.00,0.00,'393','2022-04-03 15:08:50','606','2022-04-03 22:00:11',10,0),('5','91',257503,'daily','2022-04-04','2022-04-04 13:55:30','2022-04-05 13:55:30','393',0.00,0.00,'393','2022-04-04 13:55:51','797','2022-04-05 10:28:49',10,0),('5','91',257504,'daily','2022-04-05','2022-04-05 22:02:04','2022-04-06 22:02:04','393',0.00,0.00,'393','2022-04-05 22:03:05','797','2022-04-06 09:48:14',10,0),('5','91',257505,'daily','2022-04-06','2022-04-06 19:34:59','2022-04-07 19:34:59','393',0.00,0.00,'393','2022-04-06 19:36:06','606','2022-04-07 06:09:53',10,0),('5','91',257506,'daily','2022-04-07','2022-04-07 21:39:18','2022-04-08 21:39:18','393',0.00,0.00,'393','2022-04-07 21:40:05','797','2022-04-08 10:30:29',10,0),('5','91',257507,'daily','2022-04-08','2022-04-08 19:29:52','2022-04-09 19:29:52','393',0.00,0.00,'393','2022-04-08 19:30:39','797','2022-04-09 12:51:25',10,0),('5','91',257508,'daily','2022-04-09','2022-04-09 21:29:43','2022-04-10 21:29:43','393',0.00,0.00,'393','2022-04-09 21:31:00','797','2022-04-10 15:00:01',10,0),('5','91',257509,'daily','2022-04-10','2022-04-10 20:01:10','2022-04-11 20:01:10','393',0.00,0.00,'393','2022-04-10 20:01:38','797','2022-04-11 08:57:23',10,0),('5','91',257510,'daily','2022-04-11','2022-04-11 20:26:53','2022-04-12 20:26:53','393',0.00,0.00,'393','2022-04-11 20:27:26','797','2022-04-12 07:16:36',10,0),('5','91',257511,'daily','2022-04-12','2022-04-12 22:37:07','2022-04-13 22:37:07','393',0.00,0.00,'393','2022-04-12 22:38:21','797','2022-04-13 09:54:28',10,0),('5','91',257512,'daily','2022-04-13','2022-04-13 21:12:44','2022-04-14 21:12:44','393',0.00,0.00,'393','2022-04-13 21:13:24','797','2022-04-14 08:22:37',10,0),('5','91',257513,'daily','2022-04-14','2022-04-14 19:55:37','2022-04-15 19:55:37','393',0.00,0.00,'393','2022-04-14 19:56:09','797','2022-04-15 15:17:24',10,0),('5','91',257514,'daily','2022-04-15','2022-04-15 21:40:05','2022-04-16 21:40:05','393',0.00,0.00,'393','2022-04-15 21:40:55','797','2022-04-16 11:31:16',10,0),('5','91',257515,'daily','2022-04-16','2022-04-16 15:41:24','2022-04-17 15:41:24','393',0.00,0.00,'393','2022-04-16 15:41:59','797','2022-04-17 07:07:21',10,0),('5','91',257516,'daily','2022-04-17','2022-04-17 16:03:20','2022-04-18 16:03:20','393',0.00,0.00,'393','2022-04-17 16:03:52','797','2022-04-17 22:10:32',10,0),('5','91',257517,'daily','2022-04-18','2022-04-18 17:33:50','2022-04-19 17:33:50','393',0.00,0.00,'393','2022-04-18 17:34:58','797','2022-04-18 21:07:46',10,0),('5','91',257518,'daily','2022-04-19','2022-04-19 20:46:31','2022-04-20 20:46:31','393',103129.95,103129.95,'393','2022-04-20 09:35:06','797','2022-04-20 10:10:25',10,0),('5','91',257519,'daily','2022-04-20','2022-04-20 14:25:03','2022-04-21 14:25:03','393',778966.65,778966.65,'393','2022-04-20 22:19:00','797','2022-04-21 08:54:17',10,0),('5','91',257520,'daily','2022-04-21','2022-04-21 21:55:34','2022-04-22 21:55:34','393',888843.45,888843.45,'393','2022-04-21 22:00:51','797','2022-04-22 09:25:56',10,0),('5','91',257521,'daily','2022-04-22','2022-04-22 15:18:46','2022-04-23 15:18:46','393',901563.30,901563.30,'393','2022-04-22 20:09:54','797','2022-04-23 09:25:39',10,0),('5','91',257522,'daily','2022-04-23','2022-04-23 20:14:13','2022-04-24 20:14:13','393',898392.00,898392.00,'393','2022-04-23 20:20:23','797','2022-04-23 22:07:50',10,0),('5','91',257523,'daily','2022-04-24','2022-04-24 10:53:08','2022-04-25 10:53:08','393',967056.75,967056.75,'393','2022-04-24 20:51:19','797','2022-04-25 04:53:05',10,0),('5','91',257524,'daily','2022-04-25','2022-04-25 15:03:30','2022-04-26 15:03:30','393',666090.15,666090.15,'393','2022-04-25 21:24:48','797','2022-04-26 07:34:43',10,0),('5','91',257525,'daily','2022-04-26','2022-04-26 15:10:06','2022-04-27 15:10:06','393',684241.80,684241.80,'393','2022-04-26 20:06:51','797','2022-04-27 05:39:27',10,0),('5','91',257526,'daily','2022-04-27','2022-04-27 19:54:30','2022-04-28 19:54:30','393',902284.35,902284.35,'393','2022-04-27 20:01:38','797','2022-04-28 07:33:08',10,0),('5','91',257527,'daily','2022-04-28','2022-04-28 21:39:20','2022-04-29 21:39:20','393',661283.70,661283.70,'393','2022-04-28 21:41:29','797','2022-04-29 05:58:33',10,0),('5','91',257528,'daily','2022-04-29','2022-04-29 18:43:45','2022-04-30 18:43:45','393',626472.00,626472.00,'393','2022-04-29 20:27:09','797','2022-05-09 10:22:51',10,0),('5','91',257529,'Daily','2022-04-30','2022-05-09 12:29:51','2022-05-10 12:29:51','393',174139.35,174139.35,'393','2022-05-09 12:32:20','797','2022-05-09 12:40:04',10,0),('5','91',257530,'Daily','2022-05-01','2022-05-09 12:43:56','2022-05-10 12:43:56','393',0.00,0.00,'393','2022-05-09 12:45:13','797','2022-05-09 12:46:01',10,0),('5','91',257531,'Daily','2022-05-02','2022-05-09 12:48:46','2022-05-10 12:48:46','393',0.00,0.00,'393','2022-05-09 12:49:50','797','2022-05-09 12:50:53',10,0),('5','91',257532,'Daily','2022-05-03','2022-05-09 12:53:35','2022-05-10 12:53:35','393',148504.95,148504.95,'393','2022-05-09 15:37:00','797','2022-05-09 15:39:36',10,0),('5','91',257533,'Daily','2022-05-04','2022-05-09 15:40:32','2022-05-10 15:40:32','393',793461.90,793461.90,'393','2022-05-09 15:42:05','797','2022-05-09 15:43:56',10,0),('5','91',257534,'Daily','2022-05-05','2022-05-09 15:45:07','2022-05-10 15:45:07','393',707031.60,707031.60,'393','2022-05-09 15:46:39','797','2022-05-09 15:48:20',10,0),('5','91',257535,'Daily','2022-05-06','2022-05-09 15:49:00','2022-05-10 15:49:00','393',813831.15,813831.15,'393','2022-05-09 15:50:16','797','2022-05-09 15:55:50',10,0),('5','91',257536,'Daily','2022-05-07','2022-05-09 15:57:49','2022-05-10 15:57:49','393',775242.60,775242.60,'393','2022-05-09 15:59:47','797','2022-05-09 16:17:00',10,0),('5','91',257537,'Daily','2022-05-08','2022-05-09 16:20:38','2022-05-10 16:20:38','393',828476.55,828476.55,'393','2022-05-09 16:22:05','797','2022-05-09 16:38:04',10,0),('5','91',257538,'Daily','2022-05-09','2022-05-09 17:09:09','2022-05-10 17:09:09','393',879773.40,879773.40,'393','2022-05-09 19:22:50','797','2022-05-10 08:57:12',10,0),('5','91',257539,'Daily','2022-05-10','2022-05-10 13:13:27','2022-05-11 13:13:27','393',873968.70,873968.70,'393','2022-05-10 23:06:38','797','2022-05-11 05:34:16',10,0),('5','91',257540,'Daily','2022-05-11','2022-05-11 12:21:29','2022-05-12 12:21:29','393',798857.40,798857.40,'393','2022-05-11 20:12:48','797','2022-05-12 08:27:09',10,0),('5','91',257541,'Daily','2022-05-12','2022-05-12 14:28:01','2022-05-13 14:28:01','393',867969.30,867969.30,'393','2022-05-12 19:19:41','797','2022-05-13 09:53:31',10,0),('5','91',257542,'Daily','2022-05-13','2022-05-13 21:06:12','2022-05-14 21:06:12','393',911143.20,911143.20,'393','2022-05-13 21:08:13','797','2022-05-14 14:28:06',10,0),('5','91',257543,'Daily','2022-05-14','2022-05-14 17:46:03','2022-05-15 17:46:03','393',956326.80,956326.80,'393','2022-05-14 22:22:20','797','2022-05-14 22:45:12',10,0),('5','91',257544,'Daily','2022-05-15','2022-05-15 19:48:01','2022-05-16 19:48:01','393',834749.85,834749.85,'393','2022-05-15 22:35:38','797','2022-05-15 22:50:49',10,0),('5','91',257545,'Daily','2022-05-16','2022-05-16 06:14:14','2022-05-17 06:14:14','393',924041.25,924041.25,'393','2022-05-16 19:55:33','797','2022-05-17 06:53:37',10,0),('5','91',257546,'Daily','2022-05-17','2022-05-17 07:09:20','2022-05-18 07:09:20','393',884949.45,884949.45,'393','2022-05-17 20:15:21','797','2022-05-18 07:11:59',10,0),('5','91',257547,'Daily','2022-05-18','2022-05-18 09:51:31','2022-05-19 09:51:31','393',829752.00,829752.00,'393','2022-05-18 21:26:32','797','2022-05-19 06:17:31',10,0),('5','91',257548,'Daily','2022-05-19','2022-05-19 10:50:34','2022-05-20 10:50:34','393',847824.45,847824.45,'393','2022-05-19 19:57:40','797','2022-05-19 22:35:25',10,0),('5','91',257549,'Daily','2022-05-20','2022-05-20 09:30:43','2022-05-21 09:30:43','393',853599.45,853599.45,'393','2022-05-20 22:44:55','797','2022-05-21 05:48:55',10,0),('5','91',257550,'Daily','2022-05-21','2022-05-21 07:54:22','2022-05-22 07:54:22','393',862923.60,862923.60,'393','2022-05-21 21:56:32','797','2022-05-21 22:38:39',10,0),('5','91',257551,'Daily','2022-05-22','2022-05-22 10:31:18','2022-05-23 10:31:18','393',809816.70,809816.70,'393','2022-05-22 21:25:10','797','2022-05-23 05:41:01',10,0),('5','91',257552,'Daily','2022-05-23','2022-05-23 07:25:41','2022-05-24 07:25:41','393',302882.25,302882.25,'393','2022-05-24 06:43:27','797','2022-05-24 06:46:39',10,0),('5','91',257553,'Daily','2022-05-24','2022-05-24 10:19:37','2022-05-25 10:19:37','393',0.00,0.00,'393','2022-05-24 17:30:10','797','2022-05-25 07:28:53',10,0),('5','91',257554,'Daily','2022-05-25','2022-05-25 13:46:11','2022-05-26 13:46:11','393',0.00,0.00,'393','2022-05-25 20:04:17','797','2022-05-26 05:38:37',10,0),('5','91',257555,'Daily','2022-05-26','2022-05-26 09:18:29','2022-05-27 09:18:29','393',0.00,0.00,'393','2022-05-26 20:50:24','797','2022-05-27 05:51:29',10,0),('5','91',257556,'Daily','2022-05-27','2022-05-27 10:30:29','2022-05-28 10:30:29','393',350707.50,350707.50,'393','2022-05-28 11:20:52','797','2022-05-29 09:40:40',10,0),('5','91',257557,'Daily','2022-05-28','2022-05-29 10:59:41','2022-05-30 10:59:41','393',799349.10,799349.10,'393','2022-05-29 11:02:16','797','2022-05-30 06:24:01',10,0),('5','91',257558,'Daily','2022-05-29','2022-05-30 07:00:29','2022-05-31 07:00:29','393',780563.85,780563.85,'393','2022-05-30 07:05:20','797','2022-05-30 11:07:36',10,0),('5','91',257559,'Daily','2022-05-30','2022-05-30 11:13:15','2022-05-31 11:13:15','393',769413.15,769413.15,'393','2022-05-30 22:06:26','797','2022-05-31 05:40:35',10,0),('5','91',257560,'Daily','2022-05-31','2022-05-31 11:19:10','2022-06-01 11:19:10','393',726504.90,726504.90,'393','2022-05-31 19:35:34','797','2022-05-31 22:43:39',10,0),('5','91',257561,'Daily','2022-06-01','2022-06-01 10:00:45','2022-06-02 10:00:45','393',729267.00,729267.00,'393','2022-06-01 22:17:21','797','2022-06-02 05:38:42',10,0),('5','91',257562,'Daily','2022-06-02','2022-06-02 06:46:26','2022-06-03 06:46:26','393',734365.50,734365.50,'393','2022-06-02 20:19:24','797','2022-06-03 05:45:05',10,0),('5','91',257563,'Daily','2022-06-03','2022-06-03 06:12:35','2022-06-04 06:12:35','393',679077.30,679077.30,'393','2022-06-03 21:17:40','797','2022-06-03 22:54:15',10,0),('5','91',257564,'Daily','2022-06-04','2022-06-04 08:15:32','2022-06-05 08:15:32','393',682012.65,682012.65,'393','2022-06-04 21:16:04','797','2022-06-05 08:08:12',10,0),('5','91',257565,'Daily','2022-06-05','2022-06-05 12:17:06','2022-06-06 12:17:06','393',759315.15,759315.15,'393','2022-06-05 21:42:03','797','2022-06-06 09:45:09',10,0),('5','91',257566,'Daily','2022-06-06','2022-06-06 10:30:44','2022-06-07 10:30:44','393',761616.90,761616.90,'393','2022-06-06 22:24:49','797','2022-06-07 06:48:39',10,0),('5','91',257567,'Daily','2022-06-07','2022-06-07 10:00:32','2022-06-08 10:00:32','393',487576.65,487576.65,'393','2022-06-07 21:00:52','797','2022-06-08 09:03:26',10,0),('5','91',257568,'Daily','2022-06-08','2022-06-08 14:48:34','2022-06-09 14:48:34','393',0.00,0.00,'393','2022-06-08 20:12:15','797','2022-06-08 23:01:57',10,0),('5','91',257569,'Daily','2022-06-09','2022-06-09 09:50:37','2022-06-10 09:50:37','393',0.00,0.00,'393','2022-06-09 21:43:31','797','2022-06-10 05:43:07',10,0),('5','91',257570,'Daily','2022-06-10','2022-06-10 06:18:28','2022-06-11 06:18:28','393',0.00,0.00,'393','2022-06-10 20:15:06','797','2022-06-11 05:49:41',10,0),('5','91',257571,'Daily','2022-06-11','2022-06-11 12:31:21','2022-06-12 12:31:21','393',0.00,0.00,'393','2022-06-11 21:16:02','797','2022-06-12 12:32:37',10,0),('5','91',257572,'Daily','2022-06-12','2022-06-12 12:58:55','2022-06-13 12:58:55','393',0.00,0.00,'393','2022-06-12 21:44:05','797','2022-06-13 07:00:57',10,0),('5','91',257573,'Daily','2022-06-13','2022-06-13 13:10:49','2022-06-14 13:10:49','393',0.00,0.00,'393','2022-06-13 22:08:03','797','2022-06-14 06:46:48',10,0),('5','91',257574,'Daily','2022-06-14','2022-06-14 08:30:23','2022-06-15 08:30:23','393',0.00,0.00,'393','2022-06-14 19:33:13','797','2022-06-15 09:30:43',10,0),('5','91',257575,'Daily','2022-06-15','2022-06-16 02:51:07','2022-06-17 02:51:07','393',0.00,0.00,'393','2022-06-16 02:51:59','797','2022-06-16 06:55:04',10,0),('5','91',257576,'Daily','2022-06-16','2022-06-16 16:45:05','2022-06-17 16:45:05','393',0.00,0.00,'393','2022-06-16 16:45:33','797','2022-06-17 07:07:20',10,0),('5','91',257577,'Daily','2022-06-17','2022-06-17 13:00:49','2022-06-18 13:00:49','393',0.00,0.00,'393','2022-06-17 19:30:44','797','2022-06-18 07:29:20',10,0),('5','91',257578,'Daily','2022-06-18','2022-06-18 10:42:37','2022-06-19 10:42:37','393',0.00,0.00,'393','2022-06-18 19:05:47','797','2022-06-18 23:03:33',10,0),('5','91',257579,'Daily','2022-06-19','2022-06-19 10:20:49','2022-06-20 10:20:49','393',0.00,0.00,'393','2022-06-19 22:21:03','797','2022-06-20 06:04:50',10,0),('5','91',257580,'Daily','2022-06-20','2022-06-20 06:29:00','2022-06-21 06:29:00','393',0.00,0.00,'393','2022-06-20 19:57:29','797','2022-06-21 06:16:34',10,0),('5','91',257581,'Daily','2022-06-21','2022-06-21 07:09:02','2022-06-22 07:09:02','393',0.00,0.00,'393','2022-06-21 19:09:28','797','2022-06-21 20:31:40',10,0),('5','91',257582,'Daily','2022-06-22','2022-06-22 06:11:05','2022-06-23 06:11:05','393',0.00,0.00,'393','2022-06-22 20:06:38','797','2022-06-23 05:34:23',10,0),('5','91',257583,'Daily','2022-06-23','2022-06-23 12:43:44','2022-06-24 12:43:44','393',0.00,0.00,'393','2022-06-23 21:12:30','797','2022-06-24 07:01:14',10,0),('5','91',257584,'Daily','2022-06-24','2022-06-24 11:45:27','2022-06-25 11:45:27','393',0.00,0.00,'393','2022-06-24 20:55:34','797','2022-06-25 07:52:18',10,0),('5','91',257585,'Daily','2022-06-25','2022-06-25 11:44:57','2022-06-26 11:44:57','393',0.00,0.00,'393','2022-06-25 20:37:23','797','2022-06-26 08:59:18',10,0),('5','91',257586,'Daily','2022-06-26','2022-06-26 10:57:20','2022-06-27 10:57:20','393',0.00,0.00,'393','2022-06-26 18:31:44','797','2022-06-27 09:36:25',10,0),('5','91',257587,'Daily','2022-06-27','2022-06-27 09:53:51','2022-06-28 09:53:51','393',0.00,0.00,'393','2022-06-27 19:24:45','797','2022-06-28 09:36:16',10,0),('5','91',257588,'Daily','2022-06-28','2022-06-28 21:36:03','2022-06-29 21:36:03','393',0.00,0.00,'393','2022-06-28 21:36:23','797','2022-06-29 09:27:19',10,0),('5','91',257589,'Daily','2022-06-29','2022-06-29 19:15:35','2022-06-30 19:15:35','393',0.00,0.00,'393','2022-06-29 19:15:54','797','2022-06-30 07:15:13',10,0),('5','91',257590,'Daily','2022-06-30','2022-06-30 10:18:33','2022-07-01 10:18:33','393',0.00,0.00,'393','2022-06-30 19:51:23','797','2022-07-01 07:28:28',10,0),('5','91',257591,'Daily','2022-07-01','2022-07-01 09:37:32','2022-07-02 09:37:32','393',0.00,0.00,'393','2022-07-01 20:51:30','797','2022-07-02 09:04:24',10,0),('5','91',257592,'Daily','2022-07-02','2022-07-02 10:58:02','2022-07-03 10:58:02','393',0.00,0.00,'393','2022-07-02 20:17:20','797','2022-07-03 09:05:31',10,0),('5','91',257593,'Daily','2022-07-03','2022-07-03 10:57:48','2022-07-04 10:57:48','393',0.00,0.00,'393','2022-07-03 20:33:02','797','2022-07-04 06:58:12',10,0),('5','91',257594,'Daily','2022-07-04','2022-07-04 09:47:25','2022-07-05 09:47:25','393',0.00,0.00,'393','2022-07-04 19:16:17','797','2022-07-05 06:30:59',10,0),('5','91',257595,'Daily','2022-07-05','2022-07-05 19:32:11','2022-07-06 19:32:11','393',0.00,0.00,'393','2022-07-05 19:32:39','797','2022-07-06 06:25:42',10,0),('5','91',257596,'Daily','2022-07-06','2022-07-06 10:40:25','2022-07-07 10:40:25','393',0.00,0.00,'393','2022-07-06 20:11:39','797','2022-07-07 06:48:30',10,0),('5','91',257597,'Daily','2022-07-07','2022-07-07 09:07:41','2022-07-08 09:07:41','393',0.00,0.00,'393','2022-07-07 19:51:59','797','2022-07-08 03:53:59',10,0),('5','91',257598,'Daily','2022-07-08','2022-07-08 12:14:06','2022-07-09 12:14:06','393',0.00,0.00,'393','2022-07-08 22:13:47','797','2022-07-09 10:49:51',10,0),('5','91',257599,'Daily','2022-07-09','2022-07-09 21:43:09','2022-07-10 21:43:09','393',0.00,0.00,'393','2022-07-09 21:45:20','797','2022-07-10 06:52:39',10,0),('5','91',257600,'Daily','2022-07-10','2022-07-10 10:34:14','2022-07-11 10:34:14','393',0.00,0.00,'393','2022-07-11 06:01:45','797','2022-07-11 07:37:51',10,0),('5','91',257601,'Daily','2022-07-11','2022-07-11 14:34:21','2022-07-12 14:34:21','393',380178.70,380178.70,'393','2022-07-12 10:05:55','797','2022-07-12 10:08:24',10,0),('5','91',257602,'Daily','2022-07-12','2022-07-12 10:12:04','2022-07-13 10:12:04','393',746121.65,746121.65,'393','2022-07-12 21:45:12','797','2022-07-13 06:49:49',10,0),('5','91',257603,'Daily','2022-07-13','2022-07-13 09:03:12','2022-07-14 09:03:12','393',763313.70,763313.70,'393','2022-07-13 22:02:36','797','2022-07-14 06:24:26',10,0),('5','91',257604,'Daily','2022-07-14','2022-07-14 08:19:35','2022-07-15 08:19:35','393',859376.80,859376.80,'393','2022-07-14 22:07:10','797','2022-07-15 06:38:14',10,0),('5','91',257605,'Daily','2022-07-15','2022-07-15 07:27:10','2022-07-16 07:27:10','393',825508.85,825508.85,'393','2022-07-15 22:41:12','797','2022-07-16 05:41:37',10,0),('5','91',257606,'Daily','2022-07-16','2022-07-16 09:26:04','2022-07-17 09:26:04','393',1262963.55,1262963.55,'393','2022-07-16 21:09:09','797','2022-07-17 06:03:19',10,0),('5','91',257607,'Daily','2022-07-17','2022-07-17 09:24:20','2022-07-18 09:24:20','393',1043007.80,1043007.80,'393','2022-07-17 20:32:58','797','2022-07-18 07:32:14',10,0),('5','91',257608,'Daily','2022-07-18','2022-07-18 07:56:35','2022-07-19 07:56:35','393',1247588.20,1247588.20,'393','2022-07-18 21:20:44','797','2022-07-19 05:47:33',10,0),('5','91',257609,'Daily','2022-07-19','2022-07-19 09:03:32','2022-07-20 09:03:32','393',1002738.85,1002738.85,'393','2022-07-19 21:41:29','797','2022-07-20 06:42:31',10,0),('5','91',257610,'Daily','2022-07-20','2022-07-20 11:04:58','2022-07-21 11:04:58','393',1471621.35,1471621.35,'393','2022-07-20 21:15:48','797','2022-07-21 07:43:07',10,0),('5','91',257611,'Daily','2022-07-21','2022-07-21 20:09:16','2022-07-22 20:09:16','393',1187422.50,1187422.50,'393','2022-07-21 20:32:09','797','2022-07-21 23:18:53',10,0),('5','91',257612,'Daily','2022-07-22','2022-07-22 09:33:40','2022-07-23 09:33:40','393',1170191.60,1170191.60,'393','2022-07-22 21:57:38','797','2022-07-23 07:28:24',10,0),('5','91',257613,'Daily','2022-07-23','2022-07-23 08:13:01','2022-07-24 08:13:01','393',1157952.00,1157952.00,'393','2022-07-23 21:36:27','797','2022-07-24 06:55:28',10,0),('5','91',257614,'Daily','2022-07-24','2022-07-24 10:29:43','2022-07-25 10:29:43','393',1180475.75,1180475.75,'393','2022-07-24 22:13:12','797','2022-07-25 06:40:29',10,0),('5','91',257615,'Daily','2022-07-25','2022-07-25 10:30:09','2022-07-26 10:30:09','393',995152.00,995152.00,'393','2022-07-25 22:44:46','797','2022-07-26 07:39:04',10,0),('5','91',257616,'Daily','2022-07-26','2022-07-26 11:44:02','2022-07-27 11:44:02','393',941579.70,941579.70,'393','2022-07-26 21:20:34','797','2022-07-27 06:53:36',10,0),('5','91',257617,'Daily','2022-07-27','2022-07-27 09:18:54','2022-07-28 09:18:54','393',900833.45,900833.45,'393','2022-07-27 21:42:28','797','2022-07-28 08:05:51',10,0),('5','91',257618,'Daily','2022-07-28','2022-07-28 10:43:37','2022-07-29 10:43:37','393',464418.45,464418.45,'393','2022-07-28 20:54:33','797','2022-07-29 06:55:34',10,0),('5','91',257619,'Daily','2022-07-29','2022-07-29 18:34:32','2022-07-30 18:34:32','393',0.00,0.00,'393','2022-07-29 18:35:27','797','2022-07-30 06:58:51',10,0),('5','91',257620,'Daily','2022-07-30','2022-07-30 12:46:45','2022-07-31 12:46:45','393',0.00,0.00,'393','2022-07-30 12:47:07','797','2022-07-31 05:57:46',10,0),('5','91',257621,'Daily','2022-07-31','2022-07-31 19:08:47','2022-08-01 19:08:47','393',0.00,0.00,'393','2022-07-31 19:10:34','797','2022-08-01 06:47:39',10,0),('5','91',257622,'Daily','2022-08-01','2022-08-01 11:59:28','2022-08-02 11:59:28','393',0.00,0.00,'393','2022-08-01 21:19:46','797','2022-08-02 07:37:14',10,0),('5','91',257623,'Daily','2022-08-02','2022-08-02 15:14:06','2022-08-03 15:14:06','393',0.00,0.00,'393','2022-08-02 20:15:27','797','2022-08-03 06:35:30',10,0),('5','91',257624,'Daily','2022-08-03','2022-08-03 09:34:25','2022-08-04 09:34:25','393',0.00,0.00,'393','2022-08-03 20:46:16','797','2022-08-04 06:48:59',10,0),('5','91',257625,'Daily','2022-08-04','2022-08-04 09:02:45','2022-08-05 09:02:45','393',0.00,0.00,'393','2022-08-04 21:43:36','797','2022-08-05 06:36:17',10,0),('5','91',257626,'Daily','2022-08-05','2022-08-05 09:23:31','2022-08-06 09:23:31','393',71003.00,71003.00,'393','2022-08-05 22:21:59','797','2022-08-06 09:09:34',10,0),('5','91',257627,'Daily','2022-08-06','2022-08-06 20:21:41','2022-08-07 20:21:41','393',0.00,0.00,'393','2022-08-06 20:22:13','797','2022-08-07 07:10:57',10,0),('5','91',257628,'Daily','2022-08-07','2022-08-07 17:57:40','2022-08-08 17:57:40','393',455975.05,455975.05,'393','2022-08-07 20:54:05','797','2022-09-03 08:14:26',10,0),('5','91',257629,'Daily','2022-08-08','2022-09-03 11:20:22','2022-09-04 11:20:22','393',975954.55,975954.55,'393','2022-09-03 11:22:11','797','2022-09-03 11:56:32',10,0),('5','91',257630,'Daily','2022-08-09','2022-09-03 12:07:23','2022-09-04 12:07:23','393',928030.30,928030.30,'393','2022-09-03 12:10:35','797','2022-09-03 12:12:40',10,0),('5','91',257631,'Daily','2022-08-10','2022-09-03 12:15:37','2022-09-04 12:15:37','393',1196790.90,1196790.90,'393','2022-09-03 12:17:19','797','2022-09-03 12:18:52',10,0),('5','91',257632,'Daily','2022-08-11','2022-09-03 12:24:10','2022-09-04 12:24:10','393',1177229.00,1177229.00,'393','2022-09-03 12:25:44','797','2022-09-03 19:06:06',10,0),('5','91',257633,'Daily','2022-08-12','2022-09-03 21:39:23','2022-09-04 21:39:23','393',1175210.65,1175210.65,'393','2022-09-03 21:42:23','797','2022-09-04 09:47:37',10,0),('5','91',257634,'Daily','2022-08-13','2022-09-04 11:16:27','2022-09-05 11:16:27','393',1095853.05,1095853.05,'393','2022-09-04 11:18:34','797','2022-09-04 15:21:20',10,0),('5','91',257635,'Daily','2022-08-14','2022-09-05 11:44:43','2022-09-06 11:44:43','393',1213611.10,1213611.10,'393','2022-09-05 11:46:06','797','2022-09-05 11:49:24',10,0),('5','91',257636,'Daily','2022-08-15','2022-09-05 11:52:14','2022-09-06 11:52:14','393',1207347.00,1207347.00,'393','2022-09-05 11:53:21','797','2022-09-05 11:54:31',10,0),('5','91',257637,'Daily','2022-08-16','2022-09-05 11:56:51','2022-09-06 11:56:51','393',1267390.60,1267390.60,'393','2022-09-05 11:58:01','797','2022-09-05 12:02:05',10,0),('5','91',257638,'Daily','2022-08-17','2022-09-05 12:11:10','2022-09-06 12:11:10','393',1308347.75,1308347.75,'393','2022-09-05 12:12:30','797','2022-09-05 12:15:15',10,0),('5','91',257639,'Daily','2022-08-18','2022-09-05 12:17:15','2022-09-06 12:17:15','393',1379093.60,1379093.60,'393','2022-09-05 12:18:30','797','2022-09-05 12:24:58',10,0),('5','91',257640,'Daily','2022-08-19','2022-09-05 12:26:09','2022-09-06 12:26:09','393',1242497.00,1242497.00,'393','2022-09-05 12:27:26','797','2022-09-05 12:30:08',10,0),('5','91',257641,'Daily','2022-08-20','2022-09-05 12:30:39','2022-09-06 12:30:39','393',1269914.00,1269914.00,'393','2022-09-05 13:21:52','797','2022-09-05 13:24:47',10,0),('5','91',257642,'Daily','2022-08-21','2022-09-05 13:26:39','2022-09-06 13:26:39','393',982971.60,982971.60,'393','2022-09-05 13:28:40','797','2022-09-05 13:37:06',10,0),('5','91',257643,'Daily','2022-08-22','2022-09-05 13:39:07','2022-09-06 13:39:07','393',1607925.65,1607925.65,'393','2022-09-05 13:40:44','797','2022-09-05 13:42:02',10,0),('5','91',257644,'Daily','2022-08-23','2022-09-05 13:44:07','2022-09-06 13:44:07','393',1020326.80,1020326.80,'393','2022-09-05 13:45:25','797','2022-09-05 13:46:26',10,0),('5','91',257645,'Daily','2022-08-24','2022-09-05 13:47:16','2022-09-06 13:47:16','393',1054361.25,1054361.25,'393','2022-09-05 13:48:44','797','2022-09-05 13:50:25',10,0),('5','91',257646,'Daily','2022-08-25','2022-09-05 13:51:25','2022-09-06 13:51:25','393',1338541.60,1338541.60,'393','2022-09-05 13:52:35','797','2022-09-05 13:53:56',10,0),('5','91',257647,'Daily','2022-08-26','2022-09-05 13:55:43','2022-09-06 13:55:43','393',1033811.45,1033811.45,'393','2022-09-05 13:57:10','797','2022-09-05 13:58:32',10,0),('5','91',257648,'Daily','2022-08-27','2022-09-05 14:26:47','2022-09-06 14:26:47','393',1729838.80,1729838.80,'393','2022-09-05 14:29:11','797','2022-09-05 14:31:44',10,0),('5','91',257649,'Daily','2022-08-28','2022-09-05 14:33:34','2022-09-06 14:33:34','393',1259282.05,1259282.05,'393','2022-09-05 14:34:46','797','2022-09-05 14:35:43',10,0),('5','91',257650,'Daily','2022-08-29','2022-09-05 14:36:32','2022-09-06 14:36:32','393',1927774.00,1927774.00,'393','2022-09-05 14:38:36','797','2022-09-05 14:40:50',10,0),('5','91',257651,'Daily','2022-08-30','2022-09-05 14:41:26','2022-09-06 14:41:26','393',956191.00,956191.00,'393','2022-09-05 14:43:10','797','2022-09-05 14:47:05',10,0),('5','91',257652,'Daily','2022-08-31','2022-09-05 14:47:41','2022-09-06 14:47:41','393',1351191.90,1351191.90,'393','2022-09-05 14:49:38','797','2022-09-05 14:50:51',10,0),('5','91',257653,'Daily','2022-09-01','2022-09-05 15:10:26','2022-09-06 15:10:26','393',1290247.35,1290247.35,'393','2022-09-05 15:11:34','797','2022-09-05 15:16:15',10,0),('5','91',257654,'Daily','2022-09-02','2022-09-05 15:17:00','2022-09-06 15:17:00','393',1112253.30,1112253.30,'393','2022-09-05 15:18:20','797','2022-09-05 15:19:39',10,0),('5','91',257655,'Daily','2022-09-03','2022-09-05 15:20:09','2022-09-06 15:20:09','393',1892350.20,1892350.20,'393','2022-09-05 15:21:39','797','2022-09-05 15:28:21',10,0),('5','91',257656,'Daily','2022-09-04','2022-09-05 15:30:13','2022-09-06 15:30:13','393',1378209.30,1378209.30,'393','2022-09-05 15:31:33','797','2022-09-05 15:31:54',10,0),('5','91',257657,'Daily','2022-09-05','2022-09-05 16:03:19','2022-09-06 16:03:19','393',1705894.25,1705894.25,'393','2022-09-05 20:00:47','797','2022-09-06 09:56:06',10,0),('5','91',257658,'Daily','2022-09-06','2022-09-06 18:58:23','2022-09-07 18:58:23','393',1132325.80,1132325.80,'393','2022-09-06 19:02:15','797','2022-09-07 09:40:16',10,0),('5','91',257659,'Daily','2022-09-07','2022-09-07 10:54:51','2022-09-08 10:54:51','393',1149203.35,1149203.35,'393','2022-09-07 21:22:02','797','2022-09-08 09:01:59',10,0),('5','91',257660,'Daily','2022-09-08','2022-09-08 11:24:57','2022-09-09 11:24:57','393',1543464.25,1543464.25,'393','2022-09-08 19:00:40','797','2022-09-09 07:14:06',10,0),('5','91',257661,'Daily','2022-09-09','2022-09-09 09:38:45','2022-09-10 09:38:45','393',1035012.10,1035012.10,'393','2022-09-09 18:58:32','797','2022-09-10 10:16:08',10,0),('5','91',257662,'Daily','2022-09-10','2022-09-10 14:50:39','2022-09-11 14:50:39','393',1887516.15,1887516.15,'393','2022-09-10 21:54:51','797','2022-09-11 11:03:17',10,0),('5','91',257663,'Daily','2022-09-11','2022-09-11 14:50:10','2022-09-12 14:50:10','393',1349837.70,1349837.70,'393','2022-09-11 19:30:10','797','2022-09-12 06:26:44',10,0),('5','91',257664,'Daily','2022-09-12','2022-09-12 19:52:05','2022-09-13 19:52:05','393',1706264.25,1706264.25,'393','2022-09-12 19:53:44','797','2022-09-13 06:58:33',10,0),('5','91',257665,'Daily','2022-09-13','2022-09-13 09:44:59','2022-09-14 09:44:59','393',804955.35,804955.35,'393','2022-09-13 21:24:57','797','2022-09-13 22:04:35',10,0),('5','91',257666,'Daily','2022-09-14','2022-09-14 20:05:27','2022-09-15 20:05:27','393',1074278.35,1074278.35,'393','2022-09-14 20:07:59','797','2022-09-14 21:54:06',10,0),('5','91',257667,'Daily','2022-09-15','2022-09-15 20:22:15','2022-09-16 20:22:15','393',927081.25,927081.25,'393','2022-09-15 20:24:44','797','2022-09-16 09:33:52',10,0),('5','91',257668,'Daily','2022-09-16','2022-09-16 20:23:48','2022-09-17 20:23:48','393',964558.55,964558.55,'393','2022-09-16 20:38:54','797','2022-09-17 07:54:36',10,0),('5','91',257669,'Daily','2022-09-17','2022-09-17 20:35:30','2022-09-18 20:35:30','393',1080860.65,1080860.65,'393','2022-09-17 21:03:58','797','2022-09-18 10:32:07',10,0),('5','91',257670,'Daily','2022-09-18','2022-09-18 19:10:57','2022-09-19 19:10:57','393',1350677.60,1350677.60,'393','2022-09-18 22:11:30','797','2022-09-19 10:42:17',10,0),('5','91',257671,'Daily','2022-09-19','2022-09-19 21:14:02','2022-09-20 21:14:02','393',1064103.35,1064103.35,'393','2022-09-19 21:16:32','797','2022-09-20 08:58:31',10,0),('5','91',257672,'Daily','2022-09-20','2022-09-20 13:16:28','2022-09-21 13:16:28','393',1133711.45,1133711.45,'393','2022-09-20 21:06:08','797','2022-09-21 07:06:32',10,0),('5','91',257673,'Daily','2022-09-21','2022-09-21 21:08:09','2022-09-22 21:08:09','393',1112543.75,1112543.75,'393','2022-09-21 21:09:58','797','2022-09-22 09:14:03',10,0),('5','91',257674,'Daily','2022-09-22','2022-09-22 21:38:18','2022-09-23 21:38:18','393',749348.05,749348.05,'393','2022-09-22 21:42:01','797','2022-09-23 10:17:41',10,0),('5','91',257675,'Daily','2022-09-23','2022-09-23 21:03:15','2022-09-24 21:03:15','393',457913.85,457913.85,'393','2022-09-23 21:04:08','797','2022-09-24 08:49:32',10,0),('5','91',257676,'Daily','2022-09-24','2022-09-24 19:48:49','2022-09-25 19:48:49','393',0.00,0.00,'393','2022-09-24 19:49:21','797','2022-09-25 07:06:30',10,0),('5','91',257677,'Daily','2022-09-25','2022-09-25 19:47:21','2022-09-26 19:47:21','393',0.00,0.00,'393','2022-09-25 19:47:54','797','2022-09-26 10:03:59',10,0),('5','91',257678,'Daily','2022-09-26','2022-09-26 20:02:52','2022-09-27 20:02:52','393',0.00,0.00,'393','2022-09-26 20:03:31','797','2022-09-27 08:07:32',10,0),('5','91',257679,'Daily','2022-09-27','2022-09-27 18:26:19','2022-09-28 18:26:19','393',417260.10,417260.10,'393','2022-09-28 10:13:06','797','2022-09-28 10:14:16',10,0),('5','91',257680,'Daily','2022-09-28','2022-09-28 10:47:59','2022-09-29 10:47:59','393',1341473.85,1341473.85,'393','2022-09-28 18:59:37','797','2022-09-29 07:10:59',10,0),('5','91',257681,'Daily','2022-09-29','2022-09-29 14:23:15','2022-09-30 14:23:15','393',1617952.65,1617952.65,'393','2022-09-29 18:41:25','797','2022-09-30 07:21:17',10,0),('5','91',257682,'Daily','2022-09-30','2022-09-30 18:58:58','2022-10-01 18:58:58','393',1331578.20,1331578.20,'393','2022-09-30 19:01:56','797','2022-10-01 07:31:14',10,0),('5','91',257683,'Daily','2022-10-01','2022-10-01 16:04:56','2022-10-02 16:04:56','393',1992999.45,1992999.45,'393','2022-10-01 21:03:11','797','2022-10-02 06:56:03',10,0),('5','91',257684,'Daily','2022-10-02','2022-10-02 19:10:29','2022-10-03 19:10:29','393',1401042.00,1401042.00,'393','2022-10-02 19:12:16','797','2022-10-03 09:44:18',10,0),('5','91',257685,'Daily','2022-10-03','2022-10-03 18:49:21','2022-10-04 18:49:21','393',1854147.70,1854147.70,'393','2022-10-03 18:52:02','797','2022-10-04 07:11:02',10,0),('5','91',257686,'Daily','2022-10-04','2022-10-04 09:59:49','2022-10-05 09:59:49','393',1318165.70,1318165.70,'393','2022-10-04 19:03:07','797','2022-10-05 10:03:01',10,0),('5','91',257687,'Daily','2022-10-05','2022-10-05 10:37:59','2022-10-06 10:37:59','393',1401511.90,1401511.90,'393','2022-10-05 18:54:06','797','2022-10-06 06:56:07',10,0),('5','91',257688,'Daily','2022-10-06','2022-10-06 11:39:17','2022-10-07 11:39:17','393',2068440.60,2068440.60,'393','2022-10-06 19:48:31','797','2022-10-07 06:55:43',10,0),('5','91',257689,'Daily','2022-10-07','2022-10-07 19:42:47','2022-10-08 19:42:47','393',1135857.45,1135857.45,'393','2022-10-07 19:45:18','797','2022-10-08 11:33:37',10,0),('5','91',257690,'Daily','2022-10-08','2022-10-08 20:04:48','2022-10-09 20:04:48','393',2140818.15,2140818.15,'393','2022-10-09 17:17:22','797','2022-10-09 18:17:20',10,0),('5','91',257691,'Daily','2022-10-09','2022-10-09 19:54:23','2022-10-10 19:54:23','393',1769674.85,1769674.85,'393','2022-10-09 21:36:35','797','2022-10-10 08:56:22',10,0),('5','91',257692,'Daily','2022-10-10','2022-10-10 18:56:31','2022-10-11 18:56:31','393',1614284.10,1614284.10,'393','2022-10-10 18:58:51','797','2022-10-11 12:12:58',10,0),('5','91',257693,'Daily','2022-10-11','2022-10-11 18:48:28','2022-10-12 18:48:28','393',1519197.80,1519197.80,'393','2022-10-11 18:51:08','797','2022-10-12 12:28:52',10,0),('5','91',257694,'Daily','2022-10-12','2022-10-12 19:30:46','2022-10-13 19:30:46','393',1571216.10,1571216.10,'393','2022-10-12 19:33:18','797','2022-10-13 04:21:13',10,0),('5','91',257695,'Daily','2022-10-13','2022-10-13 11:41:29','2022-10-14 11:41:29','393',908168.70,908168.70,'393','2022-10-13 19:49:21','797','2022-10-14 10:18:44',10,0),('5','91',257696,'Daily','2022-10-14','2022-10-14 19:42:34','2022-10-15 19:42:34','393',391802.25,391802.25,'393','2022-10-14 19:43:51','797','2022-10-15 14:08:00',10,0),('5','91',257697,'Daily','2022-10-15','2022-10-15 17:07:21','2022-10-16 17:07:21','393',0.00,0.00,'393','2022-10-15 17:07:51','797','2022-10-16 06:59:15',10,0),('5','91',257698,'Daily','2022-10-16','2022-10-16 16:45:19','2022-10-17 16:45:19','393',0.00,0.00,'393','2022-10-16 16:45:57','797','2022-10-17 20:05:20',10,0),('5','91',257699,'Daily','2022-10-17','2022-10-18 10:32:25','2022-10-19 10:32:25','393',0.00,0.00,'393','2022-10-18 10:32:53','797','2022-10-18 12:22:49',10,0),('5','91',257700,'Daily','2022-10-18','2022-10-18 18:59:08','2022-10-19 18:59:08','393',0.00,0.00,'393','2022-10-18 18:59:34','797','2022-10-19 09:41:10',10,0),('5','91',257701,'Daily','2022-10-19','2022-10-19 17:21:33','2022-10-20 17:21:33','393',0.00,0.00,'393','2022-10-19 17:21:57','797','2022-10-20 08:59:25',10,0),('5','91',257702,'Daily','2022-10-20','2022-10-20 18:27:39','2022-10-21 18:27:39','393',0.00,0.00,'393','2022-10-20 18:28:06','797','2022-10-21 09:30:53',10,0),('5','91',257703,'Daily','2022-10-21','2022-10-21 19:25:40','2022-10-22 19:25:40','393',0.00,0.00,'393','2022-10-21 19:26:08','797','2022-10-22 10:03:11',10,0),('5','91',257704,'Daily','2022-10-22','2022-10-22 19:27:00','2022-10-23 19:27:00','393',0.00,0.00,'393','2022-10-22 19:27:24','797','2022-10-23 07:38:35',10,0),('5','91',257705,'Daily','2022-10-23','2022-10-23 18:28:11','2022-10-24 18:28:11','393',0.00,0.00,'393','2022-10-23 18:28:31','797','2022-10-24 07:30:10',10,0),('5','91',257706,'Daily','2022-10-24','2022-10-24 18:46:03','2022-10-25 18:46:03','393',0.00,0.00,'393','2022-10-24 18:46:55','797','2022-10-25 09:22:18',10,0),('5','91',257707,'Daily','2022-10-25','2022-10-25 18:42:56','2022-10-26 18:42:56','393',0.00,0.00,'393','2022-10-25 18:43:16','797','2022-10-25 22:55:50',10,0),('5','91',257708,'Daily','2022-10-26','2022-10-26 18:22:09','2022-10-27 18:22:09','393',0.00,0.00,'393','2022-10-26 18:22:35','797','2022-10-27 07:00:19',10,0),('5','91',257709,'Daily','2022-10-27','2022-10-27 18:24:39','2022-10-28 18:24:39','393',0.00,0.00,'393','2022-10-27 18:25:28','797','2022-10-28 06:53:08',10,0),('5','91',257710,'Daily','2022-10-28','2022-10-28 18:27:07','2022-10-29 18:27:07','393',0.00,0.00,'393','2022-10-28 18:27:31','797','2022-10-29 08:34:15',10,0),('5','91',257711,'Daily','2022-10-29','2022-10-29 19:25:26','2022-10-30 19:25:26','393',0.00,0.00,'393','2022-10-29 19:26:13','797','2022-10-30 06:50:45',10,0),('5','91',257712,'Daily','2022-10-30','2022-10-30 18:22:19','2022-10-31 18:22:19','393',0.00,0.00,'393','2022-10-30 18:22:42','797','2022-10-31 06:59:21',10,0),('5','91',257713,'Daily','2022-10-31','2022-10-31 18:37:18','2022-11-01 18:37:18','393',0.00,0.00,'393','2022-10-31 18:37:39','797','2022-11-01 06:56:24',10,0),('5','91',257714,'Daily','2022-11-01','2022-11-01 18:27:16','2022-11-02 18:27:16','393',0.00,0.00,'393','2022-11-01 18:27:41','797','2022-11-02 07:04:45',10,0),('5','91',257715,'Daily','2022-11-02','2022-11-03 09:05:43','2022-11-04 09:05:43','393',0.00,0.00,'393','2022-11-03 09:06:15','797','2022-11-03 09:13:24',10,0),('5','91',257716,'Daily','2022-11-03','2022-11-03 18:33:02','2022-11-04 18:33:02','393',0.00,0.00,'393','2022-11-03 18:33:41','797','2022-11-04 07:00:54',10,0),('5','91',257717,'Daily','2022-11-04','2022-11-04 20:33:56','2022-11-05 20:33:56','393',0.00,0.00,'393','2022-11-04 20:34:43','797','2022-11-05 07:23:25',10,0),('5','91',257718,'Daily','2022-11-05','2022-11-05 18:21:08','2022-11-06 18:21:08','393',0.00,0.00,'393','2022-11-05 18:21:28','797','2022-11-06 08:12:59',10,0),('5','91',257719,'Daily','2022-11-06','2022-11-06 18:56:47','2022-11-07 18:56:47','393',0.00,0.00,'393','2022-11-06 18:57:11','797','2022-11-07 14:42:37',10,0),('5','91',257720,'Daily','2022-11-07','2022-11-07 18:32:12','2022-11-08 18:32:12','393',0.00,0.00,'393','2022-11-07 18:32:39','797','2022-11-08 07:41:25',10,0),('5','91',257721,'Daily','2022-11-08','2022-11-08 19:24:39','2022-11-09 19:24:39','393',563330.55,563330.55,'393','2022-11-09 14:01:18','797','2022-11-10 10:41:04',10,0),('5','91',257722,'Daily','2022-11-09','2022-11-10 11:52:51','2022-11-11 11:52:51','393',1702197.95,1702197.95,'393','2022-11-10 13:21:15','797','2022-11-10 19:02:29',10,0),('5','91',257723,'Daily','2022-11-10','2022-11-10 21:04:55','2022-11-11 21:04:55','393',1712748.50,1712748.50,'393','2022-11-10 23:11:11','797','2022-11-11 11:25:47',10,0),('5','91',257724,'Daily','2022-11-11','2022-11-11 17:47:21','2022-11-12 17:47:21','393',1773441.45,1773441.45,'393','2022-11-11 22:02:36','797','2022-11-12 10:00:05',10,0),('5','91',257725,'Daily','2022-11-12','2022-11-12 10:29:01','2022-11-13 10:29:01','393',1508497.40,1508497.40,'393','2022-11-12 22:10:47','797','2022-11-12 23:49:01',10,0),('5','91',257726,'Daily','2022-11-13','2022-11-13 21:45:00','2022-11-14 21:45:00','393',1309122.90,1309122.90,'393','2022-11-13 21:48:58','797','2022-11-14 07:21:03',10,0),('5','91',257727,'Daily','2022-11-14','2022-11-14 17:26:50','2022-11-15 17:26:50','393',1066621.20,1066621.20,'393','2022-11-14 22:12:33','797','2022-11-14 23:38:37',10,0),('5','91',257728,'Daily','2022-11-15','2022-11-15 21:31:24','2022-11-16 21:31:24','393',1030189.15,1030189.15,'393','2022-11-15 21:33:45','797','2022-11-16 07:50:49',10,0),('5','91',257729,'Daily','2022-11-16','2022-11-16 21:22:02','2022-11-17 21:22:02','393',451141.00,451141.00,'393','2022-11-16 21:23:20','797','2022-11-17 09:33:36',10,0),('5','91',257730,'Daily','2022-11-17','2022-11-17 18:46:18','2022-11-18 18:46:18','393',0.00,0.00,'393','2022-11-17 18:46:42','797','2022-11-18 08:17:43',10,0),('5','91',257731,'Daily','2022-11-18','2022-11-18 18:52:09','2022-11-19 18:52:09','393',0.00,0.00,'393','2022-11-18 18:52:52','797','2022-11-19 09:14:14',10,0),('5','91',257732,'Daily','2022-11-19','2022-11-19 20:27:54','2022-11-20 20:27:54','393',569801.85,569801.85,'393','2022-11-20 13:22:36','797','2022-11-20 14:50:07',10,0),('5','91',257733,'Daily','2022-11-20','2022-11-20 19:25:17','2022-11-21 19:25:17','393',1558954.30,1558954.30,'393','2022-11-20 21:27:44','797','2022-11-21 09:34:31',10,0),('5','91',257734,'Daily','2022-11-21','2022-11-21 10:56:53','2022-11-22 10:56:53','393',1669345.65,1669345.65,'393','2022-11-21 21:34:45','797','2022-11-22 09:01:25',10,0),('5','91',257735,'Daily','2022-11-22','2022-11-22 11:57:44','2022-11-23 11:57:44','393',1892605.50,1892605.50,'393','2022-11-22 20:49:51','797','2022-11-23 09:37:08',10,0),('5','91',257736,'Daily','2022-11-23','2022-11-23 10:54:23','2022-11-24 10:54:23','393',1301565.65,1301565.65,'393','2022-11-23 21:10:06','797','2022-11-24 08:55:10',10,0),('5','91',257737,'Daily','2022-11-24','2022-11-24 12:53:55','2022-11-25 12:53:55','393',1307150.80,1307150.80,'393','2022-11-24 21:16:07','797','2022-11-25 11:11:46',10,0),('5','91',257738,'Daily','2022-11-25','2022-11-25 12:53:18','2022-11-26 12:53:18','393',1215736.75,1215736.75,'393','2022-11-25 21:10:13','797','2022-11-26 07:42:38',10,0),('5','91',257739,'Daily','2022-11-26','2022-11-26 21:41:56','2022-11-27 21:41:56','393',1049451.35,1049451.35,'393','2022-11-26 21:44:15','797','2022-11-27 08:57:29',10,0),('5','91',257740,'Daily','2022-11-27','2022-11-27 20:22:52','2022-11-28 20:22:52','393',460995.95,460995.95,'393','2022-11-27 20:24:53','797','2022-11-28 09:45:31',10,0),('5','91',257741,'Daily','2022-11-28','2022-11-28 11:22:38','2022-11-29 11:22:38','393',0.00,0.00,'393','2022-11-28 21:00:48','797','2022-11-29 09:42:44',10,0),('5','91',257742,'Daily','2022-11-29','2022-11-29 18:53:04','2022-11-30 18:53:04','393',0.00,0.00,'393','2022-11-29 18:53:30','797','2022-11-30 06:41:26',10,0),('5','91',257743,'Daily','2022-11-30','2022-11-30 20:10:48','2022-12-01 20:10:48','393',0.00,0.00,'393','2022-11-30 20:11:31','797','2022-12-01 10:42:04',10,0),('5','91',257744,'Daily','2022-12-01','2022-12-01 18:54:33','2022-12-02 18:54:33','393',0.00,0.00,'393','2022-12-01 18:55:12','797','2022-12-02 09:57:06',10,0),('5','91',257745,'Daily','2022-12-02','2022-12-02 19:24:31','2022-12-03 19:24:31','393',0.00,0.00,'393','2022-12-02 19:24:53','797','2022-12-03 10:04:14',10,0),('5','91',257746,'Daily','2022-12-03','2022-12-03 19:15:31','2022-12-04 19:15:31','393',0.00,0.00,'393','2022-12-03 19:15:58','797','2022-12-04 09:45:53',10,0),('5','91',257747,'Daily','2022-12-04','2022-12-04 18:35:51','2022-12-05 18:35:51','393',0.00,0.00,'393','2022-12-04 18:36:13','797','2022-12-05 09:03:49',10,0),('5','91',257748,'Daily','2022-12-05','2022-12-05 19:19:16','2022-12-06 19:19:16','393',0.00,0.00,'393','2022-12-05 19:19:44','797','2022-12-06 09:20:40',10,0),('5','91',257749,'Daily','2022-12-06','2022-12-06 18:31:09','2022-12-07 18:31:09','393',0.00,0.00,'393','2022-12-06 18:31:31','797','2022-12-07 09:08:04',10,0),('5','91',257750,'Daily','2022-12-07','2022-12-07 21:18:47','2022-12-08 21:18:47','393',0.00,0.00,'393','2022-12-07 21:19:18','797','2022-12-08 09:24:26',10,0),('5','91',257751,'Daily','2022-12-08','2022-12-08 19:51:18','2022-12-09 19:51:18','393',0.00,0.00,'393','2022-12-08 19:51:47','797','2022-12-09 09:14:20',10,0),('5','91',257752,'Daily','2022-12-09','2022-12-09 20:36:50','2022-12-10 20:36:50','393',0.00,0.00,'393','2022-12-09 21:22:03','797','2022-12-10 08:50:08',10,0),('5','91',257753,'Daily','2022-12-10','2022-12-10 20:45:13','2022-12-11 20:45:13','393',0.00,0.00,'393','2022-12-10 20:45:39','797','2022-12-11 12:24:41',10,0),('5','91',257754,'Daily','2022-12-11','2022-12-11 19:41:50','2022-12-12 19:41:50','393',0.00,0.00,'393','2022-12-11 19:42:21','797','2022-12-12 11:04:36',10,0),('5','91',257755,'Daily','2022-12-12','2022-12-12 18:51:49','2022-12-13 18:51:49','393',0.00,0.00,'393','2022-12-12 18:53:36','797','2022-12-13 09:50:49',10,0),('5','91',257756,'Daily','2022-12-13','2022-12-13 20:01:34','2022-12-14 20:01:34','393',0.00,0.00,'393','2022-12-13 20:02:06','797','2022-12-14 09:36:55',10,0),('5','91',257757,'Daily','2022-12-14','2022-12-14 16:45:38','2022-12-15 16:45:38','393',0.00,0.00,'393','2022-12-14 16:46:02','797','2022-12-15 09:48:29',10,0),('5','91',257758,'Daily','2022-12-15','2022-12-15 15:54:26','2022-12-16 15:54:26','393',0.00,0.00,'393','2022-12-15 15:54:47','797','2022-12-16 09:57:57',10,0),('5','91',257759,'Daily','2022-12-16','2022-12-16 21:39:44','2022-12-17 21:39:44','393',0.00,0.00,'393','2022-12-16 21:40:23','797','2022-12-17 12:13:16',10,0),('5','91',257760,'Daily','2022-12-17','2022-12-17 17:37:37','2022-12-18 17:37:37','393',0.00,0.00,'393','2022-12-17 17:37:58','797','2022-12-18 12:30:16',10,0),('5','91',257761,'Daily','2022-12-18','2022-12-18 21:02:20','2022-12-19 21:02:20','393',0.00,0.00,'393','2022-12-18 21:02:50','797','2022-12-19 08:54:17',10,0),('5','91',257762,'Daily','2022-12-19','2022-12-19 16:41:07','2022-12-20 16:41:07','393',0.00,0.00,'393','2022-12-19 16:41:29','797','2022-12-20 08:59:34',10,0),('5','91',257763,'Daily','2022-12-20','2022-12-20 17:29:19','2022-12-21 17:29:19','393',0.00,0.00,'393','2022-12-20 17:29:44','797','2022-12-21 09:16:41',10,0),('5','91',257764,'Daily','2022-12-21','2022-12-21 16:51:32','2022-12-22 16:51:32','393',0.00,0.00,'393','2022-12-21 16:51:55','797','2022-12-22 09:26:10',10,0),('5','91',257765,'Daily','2022-12-22','2022-12-22 15:47:58','2022-12-23 15:47:58','393',0.00,0.00,'393','2022-12-22 15:48:23','797','2022-12-23 10:44:22',10,0),('5','91',257766,'Daily','2022-12-23','2022-12-23 17:30:16','2022-12-24 17:30:16','393',0.00,0.00,'393','2022-12-23 17:30:37','797','2022-12-24 19:13:42',10,0),('5','91',257767,'Daily','2022-12-24','2022-12-24 21:19:27','2022-12-25 21:19:27','393',0.00,0.00,'393','2022-12-24 21:19:58','797','2022-12-24 23:11:59',10,0),('5','91',257768,'Daily','2022-12-25','2022-12-25 15:40:36','2022-12-26 15:40:36','393',0.00,0.00,'393','2022-12-25 15:40:58','797','2022-12-26 08:21:11',10,0),('5','91',257769,'Daily','2022-12-26','2022-12-26 18:56:01','2022-12-27 18:56:01','393',0.00,0.00,'393','2022-12-26 18:56:21','797','2022-12-27 09:01:57',10,0),('5','91',257770,'Daily','2022-12-27','2022-12-27 14:00:31','2022-12-28 14:00:31','393',0.00,0.00,'393','2022-12-27 14:01:04','797','2022-12-28 09:12:22',10,0),('5','91',257771,'Daily','2022-12-28','2022-12-28 19:19:19','2022-12-29 19:19:19','393',0.00,0.00,'393','2022-12-28 19:19:44','797','2022-12-29 10:15:51',10,0),('5','91',257772,'Daily','2022-12-29','2022-12-29 18:41:29','2022-12-30 18:41:29','393',0.00,0.00,'393','2022-12-29 18:41:52','797','2022-12-30 08:59:36',10,0),('5','91',257773,'Daily','2022-12-30','2022-12-30 18:49:31','2022-12-31 18:49:31','393',0.00,0.00,'393','2022-12-30 18:49:56','797','2022-12-31 07:04:35',10,0),('5','91',257774,'Daily','2022-12-31','2022-12-31 17:14:45','2023-01-01 17:14:45','393',0.00,0.00,'393','2022-12-31 17:15:15','797','2023-01-01 08:50:48',10,0),('5','91',257775,'Daily','2023-01-01','2023-01-01 16:42:10','2023-01-02 16:42:10','393',0.00,0.00,'393','2023-01-01 16:43:11','797','2023-01-02 08:19:15',10,0),('5','91',257776,'Daily','2023-01-02','2023-01-02 20:09:35','2023-01-03 20:09:35','393',0.00,0.00,'393','2023-01-02 20:10:21','797','2023-01-03 10:32:18',10,0),('5','91',257777,'Daily','2023-01-03','2023-01-03 19:44:40','2023-01-04 19:44:40','393',0.00,0.00,'393','2023-01-03 19:45:30','797','2023-01-04 11:22:47',10,0),('5','91',257778,'Daily','2023-01-04','2023-01-04 15:51:46','2023-01-05 15:51:46','393',0.00,0.00,'393','2023-01-04 15:52:12','797','2023-01-04 21:46:59',10,0),('5','91',257779,'Daily','2023-01-05','2023-01-05 18:45:55','2023-01-06 18:45:55','393',0.00,0.00,'393','2023-01-05 18:46:21','797','2023-01-06 15:00:30',10,0),('5','91',257780,'Daily','2023-01-06','2023-01-06 18:31:14','2023-01-07 18:31:14','393',0.00,0.00,'393','2023-01-06 18:31:53','797','2023-01-07 05:48:39',10,0),('5','91',257781,'Daily','2023-01-07','2023-01-07 17:32:07','2023-01-08 17:32:07','393',0.00,0.00,'393','2023-01-07 17:32:40','797','2023-01-08 09:34:08',10,0),('5','91',257782,'Daily','2023-01-08','2023-01-08 19:58:09','2023-01-09 19:58:09','393',0.00,0.00,'393','2023-01-08 19:58:40','797','2023-01-09 09:44:57',10,0),('5','91',257783,'Daily','2023-01-09','2023-01-09 17:23:32','2023-01-10 17:23:32','393',0.00,0.00,'393','2023-01-09 17:24:16','797','2023-01-10 09:18:35',10,0),('5','91',257784,'Daily','2023-01-10','2023-01-10 18:47:07','2023-01-11 18:47:07','393',0.00,0.00,'393','2023-01-10 18:47:51','797','2023-01-11 09:42:38',10,0),('5','91',257785,'Daily','2023-01-11','2023-01-11 16:54:18','2023-01-12 16:54:18','393',0.00,0.00,'393','2023-01-11 16:55:01','797','2023-01-12 09:30:13',10,0),('5','91',257786,'Daily','2023-01-12','2023-01-12 17:56:46','2023-01-13 17:56:46','393',0.00,0.00,'393','2023-01-12 17:57:25','797','2023-01-13 09:20:23',10,0),('5','91',257787,'Daily','2023-01-13','2023-01-13 18:00:24','2023-01-14 18:00:24','393',0.00,0.00,'393','2023-01-13 18:00:57','797','2023-01-14 16:50:48',10,0),('5','91',257788,'Daily','2023-01-14','2023-01-14 17:27:45','2023-01-15 17:27:45','393',0.00,0.00,'393','2023-01-14 17:28:03','797','2023-01-15 07:53:46',10,0),('5','91',257789,'Daily','2023-01-15','2023-01-15 18:37:44','2023-01-16 18:37:44','393',0.00,0.00,'393','2023-01-15 18:38:11','797','2023-01-16 10:11:11',10,0),('5','91',257790,'Daily','2023-01-16','2023-01-16 18:10:39','2023-01-17 18:10:39','393',0.00,0.00,'393','2023-01-16 18:11:04','797','2023-01-17 10:09:52',10,0),('5','91',257791,'Daily','2023-01-17','2023-01-17 19:11:57','2023-01-18 19:11:57','393',0.00,0.00,'393','2023-01-17 19:12:25','797','2023-01-18 09:14:40',10,0),('5','91',257792,'Daily','2023-01-18','2023-01-18 17:40:48','2023-01-19 17:40:48','393',0.00,0.00,'393','2023-01-18 17:41:13','797','2023-01-19 09:18:16',10,0),('5','91',257793,'Daily','2023-01-19','2023-01-19 20:52:32','2023-01-20 20:52:32','393',449618.45,449618.45,'393','2023-01-20 12:27:39','797','2023-01-20 13:09:35',10,0),('5','91',257794,'Daily','2023-01-20','2023-01-20 16:08:37','2023-01-21 16:08:37','393',1374920.00,1374920.00,'393','2023-01-20 18:02:58','797','2023-01-20 23:50:10',10,0),('5','91',257795,'Daily','2023-01-20','2023-01-21 06:09:37','2023-01-22 06:09:37','393',0.00,0.00,'393','2023-01-21 06:47:07','797','2023-01-21 06:48:57',10,0),('5','91',257796,'Daily','2023-01-20','2023-01-21 06:50:16','2023-01-22 06:50:16','393',1006731.00,1006731.00,'393','2023-01-21 06:51:19','797','2023-01-21 06:55:51',10,0),('5','91',257797,'Daily','2023-01-21','2023-01-21 21:17:56','2023-01-22 21:17:56','393',2220578.80,2220578.80,'393','2023-01-21 21:19:32','797','2023-01-22 10:41:01',10,0),('5','91',257798,'Daily','2023-01-22','2023-01-22 21:18:58','2023-01-23 21:18:58','393',2796052.60,2796052.60,'393','2023-01-22 21:20:45','797','2023-01-23 09:06:34',10,0),('5','91',257799,'Daily','2023-01-23','2023-01-23 15:37:38','2023-01-24 15:37:38','393',2144219.00,2144219.00,'393','2023-01-23 22:07:16','797','2023-01-24 07:20:42',10,0),('5','91',257800,'Daily','2023-01-24','2023-01-24 21:37:34','2023-01-25 21:37:34','393',615538.00,615538.00,'393','2023-01-24 21:39:56','797','2023-01-25 09:20:48',10,0),('5','91',257801,'Daily','2023-01-25','2023-01-25 11:44:52','2023-01-26 11:44:52','393',0.00,0.00,'393','2023-01-25 18:51:48','797','2023-01-26 09:20:31',10,0),('5','91',257802,'Daily','2023-01-26','2023-01-26 18:46:50','2023-01-27 18:46:50','393',0.00,0.00,'393','2023-01-26 18:47:24','797','2023-01-27 09:43:12',10,0),('5','91',257803,'Daily','2023-01-27','2023-01-27 18:41:11','2023-01-28 18:41:11','393',0.00,0.00,'393','2023-01-27 18:41:44','797','2023-01-28 09:43:08',10,0),('5','91',257804,'Daily','2023-01-28','2023-01-28 20:53:47','2023-01-29 20:53:47','393',0.00,0.00,'393','2023-01-28 20:54:08','797','2023-01-29 10:58:55',10,0),('5','91',257805,'Daily','2023-01-29','2023-01-29 18:22:13','2023-01-30 18:22:13','393',0.00,0.00,'393','2023-01-29 18:22:33','797','2023-01-30 09:21:51',10,0),('5','91',257806,'Daily','2023-01-30','2023-01-30 18:51:28','2023-01-31 18:51:28','393',0.00,0.00,'393','2023-01-30 18:51:59','797','2023-01-31 09:07:51',10,0),('5','91',257807,'Daily','2023-01-31','2023-01-31 18:16:23','2023-02-01 18:16:23','393',0.00,0.00,'393','2023-01-31 18:16:54','797','2023-02-01 13:52:49',10,0),('5','91',257808,'Daily','2023-02-01','2023-02-01 19:06:11','2023-02-02 19:06:11','393',0.00,0.00,'393','2023-02-01 19:06:57','797','2023-02-02 11:29:13',10,0),('5','91',257809,'Daily','2023-02-02','2023-02-02 18:00:25','2023-02-03 18:00:25','393',0.00,0.00,'393','2023-02-02 18:00:54','797','2023-02-03 10:01:11',10,0),('5','91',257810,'Daily','2023-02-03','2023-02-03 18:00:34','2023-02-04 18:00:34','393',0.00,0.00,'393','2023-02-03 18:01:06','797','2023-02-04 13:18:49',10,0),('5','91',257811,'Daily','2023-02-04','2023-02-04 18:45:05','2023-02-05 18:45:05','393',0.00,0.00,'393','2023-02-04 18:45:48','797','2023-02-05 11:49:56',10,0),('5','91',257812,'Daily','2023-02-05','2023-02-05 20:15:32','2023-02-06 20:15:32','393',0.00,0.00,'393','2023-02-05 20:15:56','797','2023-02-06 09:06:29',10,0),('5','91',257813,'Daily','2023-02-06','2023-02-06 17:58:19','2023-02-07 17:58:19','393',0.00,0.00,'393','2023-02-06 17:58:59','797','2023-02-06 19:35:47',10,0),('5','91',257814,'Daily','2023-02-07','2023-02-07 18:45:39','2023-02-08 18:45:39','393',0.00,0.00,'393','2023-02-07 18:46:21','797','2023-02-08 09:23:36',10,0),('5','91',257815,'Daily','2023-02-08','2023-02-08 18:02:09','2023-02-09 18:02:09','393',0.00,0.00,'393','2023-02-08 18:03:00','797','2023-02-09 09:23:24',10,0),('5','91',257816,'Daily','2023-02-09','2023-02-09 19:25:25','2023-02-10 19:25:25','393',0.00,0.00,'393','2023-02-09 19:26:54','797','2023-02-10 09:02:10',10,0),('5','91',257817,'Daily','2023-02-10','2023-02-10 18:27:22','2023-02-11 18:27:22','393',0.00,0.00,'393','2023-02-10 18:27:57','797','2023-02-11 09:40:42',10,0),('5','91',257818,'Daily','2023-02-11','2023-02-11 19:30:30','2023-02-12 19:30:30','393',0.00,0.00,'393','2023-02-11 19:30:57','797','2023-02-12 07:36:46',10,0),('5','91',257819,'Daily','2023-02-12','2023-02-12 17:32:48','2023-02-13 17:32:48','393',0.00,0.00,'393','2023-02-12 17:33:16','797','2023-02-13 09:12:35',10,0),('5','91',257820,'Daily','2023-02-13','2023-02-13 18:16:02','2023-02-14 18:16:02','393',0.00,0.00,'393','2023-02-13 18:16:23','797','2023-02-14 09:35:10',10,0),('5','91',257821,'Daily','2023-02-14','2023-02-15 10:07:41','2023-02-16 10:07:41','393',0.00,0.00,'393','2023-02-15 10:08:05','797','2023-02-15 13:11:16',10,0),('5','91',257822,'Daily','2023-02-15','2023-02-15 17:08:10','2023-02-16 17:08:10','393',0.00,0.00,'393','2023-02-15 17:09:03','797','2023-02-16 08:42:14',10,0),('5','91',257823,'Daily','2023-02-16','2023-02-16 17:56:31','2023-02-17 17:56:31','393',0.00,0.00,'393','2023-02-16 17:56:54','797','2023-02-17 12:20:35',10,0),('5','91',257824,'Daily','2023-02-17','2023-02-17 14:22:28','2023-02-18 14:22:28','393',0.00,0.00,'393','2023-02-17 14:23:09','797','2023-02-18 16:28:54',10,0),('5','91',257825,'Daily','2023-02-18','2023-02-18 18:58:33','2023-02-19 18:58:33','393',0.00,0.00,'393','2023-02-18 18:59:11','797','2023-02-19 08:31:43',10,0),('5','91',257826,'Daily','2023-02-19','2023-02-19 17:47:40','2023-02-20 17:47:40','393',0.00,0.00,'393','2023-02-19 17:47:58','797','2023-02-20 09:18:05',10,0),('5','91',257827,'Daily','2023-02-20','2023-02-20 19:49:45','2023-02-21 19:49:45','393',0.00,0.00,'393','2023-02-20 19:50:10','797','2023-02-21 08:51:40',10,0),('5','91',257828,'Daily','2023-02-21','2023-02-21 18:55:00','2023-02-22 18:55:00','393',0.00,0.00,'393','2023-02-21 18:55:33','797','2023-02-22 09:49:02',10,0),('5','91',257829,'Daily','2023-02-22','2023-02-22 18:47:17','2023-02-23 18:47:17','393',0.00,0.00,'393','2023-02-22 18:47:42','797','2023-02-23 06:58:28',10,0),('5','91',257830,'Daily','2023-02-23','2023-02-23 20:40:26','2023-02-24 20:40:26','393',0.00,0.00,'393','2023-02-23 20:41:11','797','2023-02-24 18:50:25',10,0),('5','91',257831,'Daily','2023-02-24','2023-02-24 19:29:28','2023-02-25 19:29:28','393',0.00,0.00,'393','2023-02-24 19:29:56','797','2023-02-25 10:31:59',10,0),('5','91',257832,'Daily','2023-02-25','2023-02-25 19:36:40','2023-02-26 19:36:40','393',0.00,0.00,'393','2023-02-25 19:37:33','797','2023-02-26 11:11:41',10,0),('5','91',257833,'Daily','2023-02-26','2023-02-26 20:14:48','2023-02-27 20:14:48','393',0.00,0.00,'393','2023-02-26 20:16:09','797','2023-02-27 15:38:22',10,0),('5','91',257834,'Daily','2023-02-27','2023-02-27 18:51:04','2023-02-28 18:51:04','393',0.00,0.00,'393','2023-02-28 07:08:22','797','2023-02-28 10:21:27',10,0),('5','91',257835,'Daily','2023-02-28','2023-02-28 21:44:56','2023-03-01 21:44:56','393',901674.90,901674.90,'393','2023-03-01 11:14:24','797','2023-03-02 10:07:28',10,0),('5','91',257836,'Daily','2023-03-02','2023-03-02 12:27:44','2023-03-03 12:27:44','393',2197085.10,2197085.10,'393','2023-03-02 12:34:53','797','2023-03-02 15:15:49',10,0),('5','91',257837,'Daily','2023-03-02','2023-03-02 17:43:35','2023-03-03 17:43:35','393',2563293.60,2563293.60,'393','2023-03-02 21:31:18','797','2023-03-03 09:19:11',10,0),('5','91',257838,'Daily','2023-03-03','2023-03-03 16:17:50','2023-03-04 16:17:50','393',2101125.60,2101125.60,'393','2023-03-03 21:18:21','797','2023-03-04 08:45:13',10,0),('5','91',257839,'Daily','2023-03-04','2023-03-04 21:27:42','2023-03-05 21:27:42','393',2751004.20,2751004.20,'393','2023-03-04 21:31:06','797','2023-03-05 09:42:54',10,0),('5','91',257840,'Daily','2023-03-05','2023-03-05 21:35:39','2023-03-06 21:35:39','393',2311514.10,2311514.10,'393','2023-03-06 10:31:01','797','2023-03-06 10:33:43',10,0),('5','91',257841,'Daily','2023-03-06','2023-03-06 21:35:42','2023-03-07 21:35:42','393',2640918.00,2640918.00,'393','2023-03-06 21:40:56','797','2023-03-07 09:25:04',10,0),('5','91',257842,'Daily','2023-03-07','2023-03-07 15:11:30','2023-03-08 15:11:30','393',1962011.10,1962011.10,'393','2023-03-07 21:31:29','797','2023-03-08 09:49:46',10,0),('5','91',257843,'Daily','2023-03-08','2023-03-08 21:37:02','2023-03-09 21:37:02','393',1665165.60,1665165.60,'393','2023-03-08 21:42:20','797','2023-03-09 09:48:32',10,0),('5','91',257844,'Daily','2023-03-09','2023-03-09 21:06:45','2023-03-10 21:06:45','393',1236358.20,1236358.20,'393','2023-03-09 23:16:53','797','2023-03-10 09:17:15',10,0),('5','91',257845,'Daily','2023-03-10','2023-03-10 19:21:26','2023-03-11 19:21:26','393',625048.20,625048.20,'393','2023-03-10 19:22:39','797','2023-03-11 09:36:08',10,0),('5','91',257846,'Daily','2023-03-11','2023-03-11 18:51:50','2023-03-12 18:51:50','393',0.00,0.00,'393','2023-03-11 18:52:16','797','2023-03-12 08:58:43',10,0),('5','91',257847,'Daily','2023-03-12','2023-03-12 21:12:53','2023-03-13 21:12:53','393',0.00,0.00,'393','2023-03-12 21:13:30','797','2023-03-13 09:59:44',10,0),('5','91',257848,'Daily','2023-03-13','2023-03-13 19:12:24','2023-03-14 19:12:24','393',0.00,0.00,'393','2023-03-13 19:12:45','797','2023-03-14 08:28:47',10,0),('5','91',257849,'Daily','2023-03-14','2023-03-14 17:13:34','2023-03-15 17:13:34','393',0.00,0.00,'393','2023-03-15 12:08:52','797','2023-03-15 12:11:37',10,0),('5','91',257850,'Daily','2023-03-15','2023-03-15 20:01:24','2023-03-16 20:01:24','393',0.00,0.00,'393','2023-03-15 20:01:52','797','2023-03-16 09:32:09',10,0),('5','91',257851,'Daily','2023-03-16','2023-03-16 19:09:11','2023-03-17 19:09:11','393',0.00,0.00,'393','2023-03-16 19:09:31','797','2023-03-17 07:55:28',10,0),('5','91',257852,'Daily','2023-03-17','2023-03-17 18:58:46','2023-03-18 18:58:46','393',0.00,0.00,'393','2023-03-17 18:59:06','797','2023-03-18 11:01:20',10,0),('5','91',257853,'Daily','2023-03-18','2023-03-18 20:16:34','2023-03-19 20:16:34','393',0.00,0.00,'393','2023-03-18 20:16:56','797','2023-03-19 11:35:22',10,0),('5','91',257854,'Daily','2023-03-19','2023-03-19 20:11:35','2023-03-20 20:11:35','393',0.00,0.00,'393','2023-03-19 20:12:19','797','2023-03-20 12:19:16',10,0),('5','91',257855,'Daily','2023-03-20','2023-03-20 19:26:31','2023-03-21 19:26:31','393',0.00,0.00,'393','2023-03-20 19:26:56','','0000-00-00 00:00:00',5,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4906206 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','91','642','213070',4127161,'1775','255',3350429.19,3352442.70,2013.51,332229.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','213070',4127162,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213070',4127163,'1777','255',3215758.54,3217392.54,1634.00,269610.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','213070',4127164,'1778','255',746532.68,746642.53,109.85,18125.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','213070',4127165,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213070',4127166,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','213070',4127167,'1781','256',1422407.50,1422443.21,35.71,10534.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','213070',4127168,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','213179',4128889,'1775','255',3352442.70,3354166.05,1723.35,284352.75,0.00,0.00,0.00,0.00,0.00),('5','91','642','213179',4128890,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213179',4128891,'1777','255',3217392.54,3218406.79,1014.25,167351.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','213179',4128892,'1778','255',746642.53,746642.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','213179',4128893,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213179',4128894,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','213179',4128895,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','213179',4128896,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','213458',4133434,'1775','255',3354166.05,3355092.71,926.66,152898.90,0.00,0.00,0.00,0.00,0.00),('5','91','642','213458',4133435,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213458',4133436,'1777','255',3218406.79,3220016.29,1609.50,265567.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','213458',4133437,'1778','255',746642.53,746835.75,193.22,31881.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','213458',4133438,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213458',4133439,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','213458',4133440,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','213458',4133441,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','213655',4136721,'1775','255',3355092.71,3357200.23,2107.52,347740.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','213655',4136722,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213655',4136723,'1777','255',3220016.29,3221496.17,1479.88,244180.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','213655',4136724,'1778','255',746835.75,746835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','213655',4136725,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213655',4136726,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','213655',4136727,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','213655',4136728,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','213940',4141362,'1775','255',3357200.23,3358518.50,1318.27,217514.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','213940',4141363,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213940',4141364,'1777','255',3221496.17,3223279.69,1783.52,294280.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','213940',4141365,'1778','255',746835.75,746835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','213940',4141366,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','213940',4141367,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','213940',4141368,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','213940',4141369,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','214242',4146750,'1775','255',3358518.50,3360444.01,1925.51,317709.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','214242',4146751,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','214242',4146752,'1777','255',3223279.69,3225537.84,2258.15,372594.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','214242',4146753,'1778','255',746835.75,746835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','214242',4146754,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','214242',4146755,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','214242',4146756,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','214242',4146757,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','214376',4148889,'1775','255',3360444.01,3362464.66,2020.65,333407.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','214376',4148890,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','214376',4148891,'1777','255',3225537.84,3227057.63,1519.79,250765.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','214376',4148892,'1778','255',746835.75,746835.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','214376',4148893,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','214376',4148894,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','214376',4148895,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','214376',4148896,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','214593',4152539,'1775','255',3362464.66,3363560.04,1095.38,180737.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','214593',4152540,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','214593',4152541,'1777','255',3227057.63,3228124.99,1067.36,176114.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','214593',4152542,'1778','255',746835.75,747773.59,937.84,154743.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','214593',4152543,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','214593',4152544,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','214593',4152545,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','214593',4152546,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','214895',4157812,'1775','255',3363560.04,3364851.10,1291.06,213024.90,0.00,0.00,0.00,0.00,0.00),('5','91','642','214895',4157813,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','214895',4157814,'1777','255',3228124.99,3228856.26,731.27,120659.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','214895',4157815,'1778','255',747773.59,748648.79,875.20,144408.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','214895',4157816,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','214895',4157817,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','214895',4157818,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','214895',4157819,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','215049',4160326,'1775','255',3364851.10,3365999.56,1148.46,189495.90,0.00,0.00,0.00,0.00,0.00),('5','91','642','215049',4160327,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215049',4160328,'1777','255',3228856.26,3229666.89,810.63,133753.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','215049',4160329,'1778','255',748648.79,750047.69,1398.90,230818.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','215049',4160330,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215049',4160331,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','215049',4160332,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','215049',4160333,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','215310',4164880,'1775','255',3365999.56,3366453.91,454.35,74967.75,0.00,0.00,0.00,0.00,0.00),('5','91','642','215310',4164881,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215310',4164882,'1777','255',3229666.89,3230602.12,935.23,154312.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','215310',4164883,'1778','255',750047.69,751135.57,1087.88,179500.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','215310',4164884,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215310',4164885,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','215310',4164886,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','215310',4164887,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','215509',4168070,'1775','255',3366453.91,3367659.79,1205.88,198970.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','215509',4168071,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215509',4168072,'1777','255',3230602.12,3231042.41,440.29,72647.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','215509',4168073,'1778','255',751135.57,752508.97,1373.40,226611.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','215509',4168074,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215509',4168075,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','215509',4168076,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','215509',4168077,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','215701',4171372,'1775','255',3367659.79,3369186.33,1526.54,251879.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','215701',4171373,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215701',4171374,'1777','255',3231042.41,3232234.71,1192.30,196729.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','215701',4171375,'1778','255',752508.97,754730.20,2221.23,366502.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','215701',4171376,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215701',4171377,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','215701',4171378,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','215701',4171379,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','215938',4175464,'1775','255',3369186.33,3370878.49,1692.16,279206.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','215938',4175465,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215938',4175466,'1777','255',3232234.71,3233293.98,1059.27,174779.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','215938',4175467,'1778','255',754730.20,756420.57,1690.37,278911.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','215938',4175468,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','215938',4175469,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','215938',4175470,'1781','256',1422443.21,1422443.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','215938',4175471,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','216158',4179268,'1775','255',3370878.49,3372884.37,2005.88,330970.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','216158',4179269,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','216158',4179270,'1777','255',3233293.98,3234973.63,1679.65,277142.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','216158',4179271,'1778','255',756420.57,759276.11,2855.54,471164.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','216158',4179272,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','216158',4179273,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','216158',4179274,'1781','256',1422443.21,1424476.51,2033.30,599823.50,0.00,0.00,0.00,0.00,0.00),('5','91','646','216158',4179275,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','216353',4182649,'1775','255',3372884.37,3374530.11,1645.74,271547.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','216353',4182650,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','216353',4182651,'1777','255',3234973.63,3236205.38,1231.75,203238.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','216353',4182652,'1778','255',759276.11,760360.59,1084.48,178939.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','216353',4182653,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','216353',4182654,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','216353',4182655,'1781','256',1424476.51,1425106.32,629.81,185793.95,0.00,0.00,0.00,0.00,0.00),('5','91','646','216353',4182656,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','216577',4186487,'1775','255',3374530.11,3375502.70,972.59,160477.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','216577',4186488,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','216577',4186489,'1777','255',3236205.38,3237349.18,1143.80,188727.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','216577',4186490,'1778','255',760360.59,761803.59,1443.00,238095.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','216577',4186491,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','216577',4186492,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','216577',4186493,'1781','256',1425106.32,1425518.75,412.43,121666.85,0.00,0.00,0.00,0.00,0.00),('5','91','646','216577',4186494,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','216814',4190830,'1775','255',3375502.70,3376121.57,618.87,102113.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','216814',4190831,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','216814',4190832,'1777','255',3237349.18,3238291.85,942.67,155540.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','216814',4190833,'1778','255',761803.59,762766.14,962.55,158820.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','216814',4190834,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','216814',4190835,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','216814',4190836,'1781','256',1425518.75,1425993.28,474.53,139986.35,0.00,0.00,0.00,0.00,0.00),('5','91','646','216814',4190837,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','217035',4194608,'1775','255',3376121.57,3377108.70,987.13,162876.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','217035',4194609,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217035',4194610,'1777','255',3238291.85,3239039.35,747.50,123337.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','217035',4194611,'1778','255',762766.14,763817.51,1051.37,173476.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','217035',4194612,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217035',4194613,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','217035',4194614,'1781','256',1425993.28,1426167.79,174.51,51480.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','217035',4194615,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','217311',4199827,'1775','255',3377108.70,3378108.41,999.71,164952.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','217311',4199828,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217311',4199829,'1777','255',3239039.35,3240760.60,1721.25,284006.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','217311',4199830,'1778','255',763817.51,765235.19,1417.68,233917.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','217311',4199831,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217311',4199832,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','217311',4199833,'1781','256',1426167.79,1427182.33,1014.54,299289.30,0.00,0.00,0.00,0.00,0.00),('5','91','646','217311',4199834,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','217658',4206042,'1775','255',3378108.41,3380251.60,2143.19,353626.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','217658',4206043,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217658',4206044,'1777','255',3240760.60,3241637.77,877.17,144733.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','217658',4206045,'1778','255',765235.19,766441.04,1205.85,198965.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','217658',4206046,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217658',4206047,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','217658',4206048,'1781','256',1427182.33,1427763.77,581.44,171524.80,0.00,0.00,0.00,0.00,0.00),('5','91','646','217658',4206049,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','217751',4207318,'1775','255',3380251.60,3380536.38,284.78,46988.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','217751',4207319,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217751',4207320,'1777','255',3241637.77,3242843.69,1205.92,198976.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','217751',4207321,'1778','255',766441.04,768124.53,1683.49,277775.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','217751',4207322,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217751',4207323,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','217751',4207324,'1781','256',1427763.77,1427992.91,229.14,67596.30,0.00,0.00,0.00,0.00,0.00),('5','91','646','217751',4207325,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','217982',4211726,'1775','255',3380536.38,3380775.79,239.41,39502.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','217982',4211727,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217982',4211728,'1777','255',3242843.69,3244298.56,1454.87,240053.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','217982',4211729,'1778','255',768124.53,769721.38,1596.85,263480.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','217982',4211730,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','217982',4211731,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','217982',4211732,'1781','256',1427992.91,1428347.98,355.07,104745.65,0.00,0.00,0.00,0.00,0.00),('5','91','646','217982',4211733,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','218227',4215877,'1775','255',3380775.79,3380775.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','218227',4215878,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','218227',4215879,'1777','255',3244298.56,3245699.87,1401.31,231216.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','218227',4215880,'1778','255',769721.38,771324.17,1602.79,264460.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','218227',4215881,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','218227',4215882,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','218227',4215883,'1781','256',1428347.98,1428597.73,249.75,73676.25,0.00,0.00,0.00,0.00,0.00),('5','91','646','218227',4215884,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','218462',4219924,'1775','255',3380775.79,3380775.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','218462',4219925,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','218462',4219926,'1777','255',3245699.87,3246931.40,1231.53,203202.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','218462',4219927,'1778','255',771324.17,772644.14,1319.97,217795.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','218462',4219928,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','218462',4219929,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','218462',4219930,'1781','256',1428597.73,1429116.71,518.98,153099.10,0.00,0.00,0.00,0.00,0.00),('5','91','646','218462',4219931,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','218678',4224003,'1775','255',3380775.79,3380775.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','218678',4224004,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','218678',4224005,'1777','255',3246931.40,3248226.21,1294.81,213643.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','218678',4224006,'1778','255',772644.14,774183.34,1539.20,253968.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','218678',4224007,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','218678',4224008,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','218678',4224009,'1781','256',1429116.71,1429201.34,84.63,24965.85,0.00,0.00,0.00,0.00,0.00),('5','91','646','218678',4224010,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','218909',4228002,'1775','255',3380775.79,3380775.79,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','218909',4228003,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','218909',4228004,'1777','255',3248226.21,3250618.38,2392.17,394708.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','218909',4228005,'1778','255',774183.34,776345.02,2161.68,356677.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','218909',4228006,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','218909',4228007,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','218909',4228008,'1781','256',1429201.34,1430204.86,1003.52,296038.40,0.00,0.00,0.00,0.00,0.00),('5','91','646','218909',4228009,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','219131',4231709,'1775','255',3380775.79,3381028.97,253.18,41774.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','219131',4231710,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','219131',4231711,'1777','255',3250618.38,3252405.95,1787.57,294949.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','219131',4231712,'1778','255',776345.02,777704.28,1359.26,224277.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','219131',4231713,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','219131',4231714,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','219131',4231715,'1781','256',1430204.86,1430409.12,204.26,60256.70,0.00,0.00,0.00,0.00,0.00),('5','91','646','219131',4231716,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','219331',4235319,'1775','255',3381028.97,3381028.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','219331',4235320,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','219331',4235321,'1777','255',3252405.95,3252405.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','219331',4235322,'1778','255',777704.28,778006.28,302.00,49830.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','219331',4235323,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','219331',4235324,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','219331',4235325,'1781','256',1430409.12,1430723.22,314.10,92659.50,0.00,0.00,0.00,0.00,0.00),('5','91','646','219331',4235326,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','219593',4239767,'1775','255',3381028.97,3382257.68,1228.71,202737.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','219593',4239768,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','219593',4239769,'1777','255',3252405.95,3253087.95,682.00,112530.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','219593',4239770,'1778','255',778006.28,779444.97,1438.69,237383.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','219593',4239771,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','219593',4239772,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','219593',4239773,'1781','256',1430723.22,1431006.29,283.07,83505.65,0.00,0.00,0.00,0.00,0.00),('5','91','646','219593',4239774,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','219822',4243787,'1775','255',3382257.68,3383194.41,936.73,154560.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','219822',4243788,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','219822',4243789,'1777','255',3253087.95,3254114.82,1026.87,169433.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','219822',4243790,'1778','255',779444.97,780924.44,1479.47,244112.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','219822',4243791,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','219822',4243792,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','219822',4243793,'1781','256',1431006.29,1431156.70,150.41,44370.95,0.00,0.00,0.00,0.00,0.00),('5','91','646','219822',4243794,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','220023',4247744,'1775','255',3383194.41,3383832.33,637.92,105256.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','220023',4247745,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220023',4247746,'1777','255',3254114.82,3254983.73,868.91,143370.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','220023',4247747,'1778','255',780924.44,781935.90,1011.46,166890.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','220023',4247748,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220023',4247749,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','220023',4247750,'1781','256',1431156.70,1431282.16,125.46,37010.70,0.00,0.00,0.00,0.00,0.00),('5','91','646','220023',4247751,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','220246',4251457,'1775','255',3383832.33,3384831.58,999.25,164876.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','220246',4251458,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220246',4251459,'1777','255',3254983.73,3255711.28,727.55,120045.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','220246',4251460,'1778','255',781935.90,782899.18,963.28,158941.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','220246',4251461,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220246',4251462,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','220246',4251463,'1781','256',1431282.16,1431511.02,228.86,67513.70,0.00,0.00,0.00,0.00,0.00),('5','91','646','220246',4251464,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','220471',4255587,'1775','255',3384831.58,3385850.61,1019.03,168139.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','220471',4255588,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220471',4255589,'1777','255',3255711.28,3257096.55,1385.27,228569.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','220471',4255590,'1778','255',782899.18,785011.44,2112.26,348522.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','220471',4255591,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220471',4255592,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','220471',4255593,'1781','256',1431511.02,1431743.12,232.10,68469.50,0.00,0.00,0.00,0.00,0.00),('5','91','646','220471',4255594,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','220875',4262827,'1775','255',3385850.61,3387098.57,1247.96,205913.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','220875',4262828,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220875',4262829,'1777','255',3257096.55,3258621.75,1525.20,251658.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','220875',4262830,'1778','255',785011.44,785678.51,667.07,110066.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','220875',4262831,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220875',4262832,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','220875',4262833,'1781','256',1431743.12,1432043.32,300.20,88559.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','220875',4262834,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','220901',4263208,'1775','255',3387098.57,3388328.30,1229.73,202905.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','220901',4263209,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220901',4263210,'1777','255',3258621.75,3259972.30,1350.55,222840.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','220901',4263211,'1778','255',785678.51,787048.71,1370.20,226083.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','220901',4263212,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','220901',4263213,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','220901',4263214,'1781','256',1432043.32,1432283.23,239.91,70773.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','220901',4263215,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','221158',4267498,'1775','255',3388328.30,3389097.82,769.52,126970.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','221158',4267499,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','221158',4267500,'1777','255',3259972.30,3261817.16,1844.86,304401.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','221158',4267501,'1778','255',787048.71,787680.74,632.03,104284.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','221158',4267502,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','221158',4267503,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','221158',4267504,'1781','256',1432283.23,1433456.75,1173.52,346188.40,0.00,0.00,0.00,0.00,0.00),('5','91','646','221158',4267505,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','221410',4272036,'1775','255',3389097.82,3389919.78,821.96,135623.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','221410',4272037,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','221410',4272038,'1777','255',3261817.16,3263573.05,1755.89,289721.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','221410',4272039,'1778','255',787680.74,788755.92,1075.18,177404.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','221410',4272040,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','221410',4272041,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','221410',4272042,'1781','256',1433456.75,1433843.94,387.19,114221.05,0.00,0.00,0.00,0.00,0.00),('5','91','646','221410',4272043,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','221689',4277195,'1775','255',3389919.78,3390825.41,905.63,149428.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','221689',4277196,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','221689',4277197,'1777','255',3263573.05,3265296.14,1723.09,284309.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','221689',4277198,'1778','255',788755.92,789196.90,440.98,72761.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','221689',4277199,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','221689',4277200,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','221689',4277201,'1781','256',1433843.94,1434056.26,212.32,62634.40,0.00,0.00,0.00,0.00,0.00),('5','91','646','221689',4277202,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','221925',4281323,'1775','255',3390825.41,3391860.82,1035.41,170842.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','221925',4281324,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','221925',4281325,'1777','255',3265296.14,3265802.59,506.45,83564.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','221925',4281326,'1778','255',789196.90,791182.80,1985.90,327673.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','221925',4281327,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','221925',4281328,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','221925',4281329,'1781','256',1434056.26,1434367.85,311.59,91919.05,0.00,0.00,0.00,0.00,0.00),('5','91','646','221925',4281330,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','222248',4287286,'1775','255',3391860.82,3393166.49,1305.67,215435.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','222248',4287287,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','222248',4287288,'1777','255',3265802.59,3268185.37,2382.78,393158.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','222248',4287289,'1778','255',791182.80,793569.48,2386.68,393802.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','222248',4287290,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','222248',4287291,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','222248',4287292,'1781','256',1434367.85,1434474.50,106.65,31461.75,0.00,0.00,0.00,0.00,0.00),('5','91','646','222248',4287293,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','222351',4288760,'1775','255',3393166.49,3395121.41,1954.92,322561.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','222351',4288761,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','222351',4288762,'1777','255',3268185.37,3269294.89,1109.52,183070.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','222351',4288763,'1778','255',793569.48,795211.97,1642.49,271010.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','222351',4288764,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','222351',4288765,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','222351',4288766,'1781','256',1434474.50,1434536.58,62.08,18313.60,0.00,0.00,0.00,0.00,0.00),('5','91','646','222351',4288767,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','222528',4291775,'1775','255',3395121.41,3396641.82,1520.41,250867.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','222528',4291776,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','222528',4291777,'1777','255',3269294.89,3270391.71,1096.82,180975.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','222528',4291778,'1778','255',795211.97,797072.71,1860.74,307022.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','222528',4291779,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','222528',4291780,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','222528',4291781,'1781','256',1434536.58,1434661.34,124.76,36804.20,0.00,0.00,0.00,0.00,0.00),('5','91','646','222528',4291782,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','222802',4296837,'1775','255',3396641.82,3397709.16,1067.34,176111.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','222802',4296838,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','222802',4296839,'1777','255',3270391.71,3270995.56,603.85,99635.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','222802',4296840,'1778','255',797072.71,798277.57,1204.86,198801.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','222802',4296841,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','222802',4296842,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','222802',4296843,'1781','256',1434661.34,1434752.31,90.97,26836.15,0.00,0.00,0.00,0.00,0.00),('5','91','646','222802',4296844,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','223028',4301234,'1775','255',3397709.16,3397709.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','223028',4301235,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223028',4301236,'1777','255',3270995.56,3272460.55,1464.99,241723.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','223028',4301237,'1778','255',798277.57,800106.22,1828.65,301727.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','223028',4301238,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223028',4301239,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','223028',4301240,'1781','256',1434752.31,1434936.98,184.67,54477.65,0.00,0.00,0.00,0.00,0.00),('5','91','646','223028',4301241,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','223198',4303896,'1775','255',3397709.16,3399150.38,1441.22,237801.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','223198',4303897,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223198',4303898,'1777','255',3272460.55,3272460.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','223198',4303899,'1778','255',800106.22,801806.63,1700.41,280567.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','223198',4303900,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223198',4303901,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','223198',4303902,'1781','256',1434936.98,1435892.69,955.71,281934.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','223198',4303903,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','223469',4308765,'1775','255',3399150.38,3399686.27,535.89,88421.85,0.00,0.00,0.00,0.00,0.00),('5','91','642','223469',4308766,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223469',4308767,'1777','255',3272460.55,3273017.81,557.26,91947.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','223469',4308768,'1778','255',801806.63,803671.74,1865.11,307743.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','223469',4308769,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223469',4308770,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','223469',4308771,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','223469',4308772,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','223677',4312568,'1775','255',3399686.27,3400943.72,1257.45,207479.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','223677',4312569,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223677',4312570,'1777','255',3273017.81,3274989.63,1971.82,325350.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','223677',4312571,'1778','255',803671.74,805937.70,2265.96,373883.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','223677',4312572,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223677',4312573,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','223677',4312574,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','223677',4312575,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','223888',4316519,'1775','255',3400943.72,3402696.91,1753.19,289276.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','223888',4316520,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223888',4316521,'1777','255',3274989.63,3275276.46,286.83,47326.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','223888',4316522,'1778','255',805937.70,807627.56,1689.86,278826.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','223888',4316523,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','223888',4316524,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','223888',4316525,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','223888',4316526,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','224116',4320458,'1775','255',3402696.91,3403435.79,738.88,121915.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','224116',4320459,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','224116',4320460,'1777','255',3275276.46,3277449.69,2173.23,358582.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','224116',4320461,'1778','255',807627.56,809265.13,1637.57,270199.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','224116',4320462,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','224116',4320463,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','224116',4320464,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','224116',4320465,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','224312',4324129,'1775','255',3403435.79,3404913.46,1477.67,243815.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','224312',4324130,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','224312',4324131,'1777','255',3277449.69,3277449.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','224312',4324132,'1778','255',809265.13,810833.10,1567.97,258715.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','224312',4324133,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','224312',4324134,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','224312',4324135,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','224312',4324136,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','224603',4329012,'1775','255',3404913.46,3405943.01,1029.55,169875.75,0.00,0.00,0.00,0.00,0.00),('5','91','642','224603',4329013,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','224603',4329014,'1777','255',3277449.69,3277941.28,491.59,81112.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','224603',4329015,'1778','255',810833.10,812518.36,1685.26,278067.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','224603',4329016,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','224603',4329017,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','224603',4329018,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','224603',4329019,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','224852',4333411,'1775','255',3405943.01,3406712.42,769.41,126952.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','224852',4333412,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','224852',4333413,'1777','255',3277941.28,3278486.01,544.73,89880.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','224852',4333414,'1778','255',812518.36,814559.77,2041.41,336832.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','224852',4333415,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','224852',4333416,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','224852',4333417,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','224852',4333418,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','225059',4337132,'1775','255',3406712.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','225059',4337133,'1776','255',60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225059',4337134,'1777','255',3278486.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','225059',4337135,'1778','255',814559.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','225059',4337136,'1779','255',196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225059',4337137,'1780','255',2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','225059',4337138,'1781','256',1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','225059',4337139,'1782','257',114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','225369',4342878,'1775','255',3406712.42,3407432.63,720.21,117394.23,0.00,0.00,0.00,0.00,0.00),('5','91','642','225369',4342879,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225369',4342880,'1777','255',3278486.01,3279044.21,558.20,90986.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','225369',4342881,'1778','255',814559.77,816297.45,1737.68,283241.84,0.00,0.00,0.00,0.00,0.00),('5','91','644','225369',4342882,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225369',4342883,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','225369',4342884,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','225369',4342885,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','225431',4344284,'1775','255',3407432.63,3409159.10,1726.47,281414.61,0.00,0.00,0.00,0.00,0.00),('5','91','642','225431',4344285,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225431',4344286,'1777','255',3279044.21,3280885.14,1840.93,300071.59,0.00,0.00,0.00,0.00,0.00),('5','91','644','225431',4344287,'1778','255',816297.45,818474.39,2176.94,354841.22,0.00,0.00,0.00,0.00,0.00),('5','91','644','225431',4344288,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225431',4344289,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','225431',4344290,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','225431',4344291,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','225517',4345525,'1775','255',3409159.10,3409159.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','225517',4345526,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225517',4345527,'1777','255',3280885.14,3283328.34,2443.20,398241.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','225517',4345528,'1778','255',818474.39,820625.26,2150.87,350591.81,0.00,0.00,0.00,0.00,0.00),('5','91','644','225517',4345529,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225517',4345530,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','225517',4345531,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','225517',4345532,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','225799',4350357,'1775','255',3409159.10,3409159.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','225799',4350358,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225799',4350359,'1777','255',3283328.34,3286144.35,2816.01,459009.63,0.00,0.00,0.00,0.00,0.00),('5','91','644','225799',4350360,'1778','255',820625.26,823585.53,2960.27,482524.01,0.00,0.00,0.00,0.00,0.00),('5','91','644','225799',4350361,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','225799',4350362,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','225799',4350363,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','225799',4350364,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','226115',4355974,'1775','255',3409159.10,3409159.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','226115',4355975,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','226115',4355976,'1777','255',3286144.35,3287835.40,1691.05,275641.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','226115',4355977,'1778','255',823585.53,825612.42,2026.89,330383.07,0.00,0.00,0.00,0.00,0.00),('5','91','644','226115',4355978,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','226115',4355979,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','226115',4355980,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','226115',4355981,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','226327',4359839,'1775','255',3409159.10,3409159.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','226327',4359840,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','226327',4359841,'1777','255',3287835.40,3289841.29,2005.89,326960.07,0.00,0.00,0.00,0.00,0.00),('5','91','644','226327',4359842,'1778','255',825612.42,827700.97,2088.55,340433.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','226327',4359843,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','226327',4359844,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','226327',4359845,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','226327',4359846,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','226578',4364252,'1775','255',3409159.10,3409159.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','226578',4364253,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','226578',4364254,'1777','255',3289841.29,3291390.72,1549.43,252557.09,0.00,0.00,0.00,0.00,0.00),('5','91','644','226578',4364255,'1778','255',827700.97,829636.29,1935.32,315457.16,0.00,0.00,0.00,0.00,0.00),('5','91','644','226578',4364256,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','226578',4364257,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','226578',4364258,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','226578',4364259,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','226811',4368567,'1775','255',3409159.10,3409159.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','226811',4368568,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','226811',4368569,'1777','255',3291390.72,3293334.32,1943.60,316806.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','226811',4368570,'1778','255',829636.29,831402.87,1766.58,287952.54,0.00,0.00,0.00,0.00,0.00),('5','91','644','226811',4368571,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','226811',4368572,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','226811',4368573,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','226811',4368574,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','227018',4372173,'1775','255',3409159.10,3409159.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','227018',4372174,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227018',4372175,'1777','255',3293334.32,3293334.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','227018',4372176,'1778','255',831402.87,834519.85,3116.98,508067.74,0.00,0.00,0.00,0.00,0.00),('5','91','644','227018',4372177,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227018',4372178,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','227018',4372179,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','227018',4372180,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','227184',4375245,'1775','255',3409159.10,3409590.10,431.00,70253.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','227184',4375246,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227184',4375247,'1777','255',3293334.32,3294762.96,1428.64,232868.32,0.00,0.00,0.00,0.00,0.00),('5','91','644','227184',4375248,'1778','255',834519.85,834916.10,396.25,64588.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','227184',4375249,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227184',4375250,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','227184',4375251,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','227184',4375252,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','227416',4379202,'1775','255',3409590.10,3411223.36,1633.26,266221.38,0.00,0.00,0.00,0.00,0.00),('5','91','642','227416',4379203,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227416',4379204,'1777','255',3294762.96,3296916.85,2153.89,351084.07,0.00,0.00,0.00,0.00,0.00),('5','91','644','227416',4379205,'1778','255',834916.10,837026.95,2110.85,344068.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','227416',4379206,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227416',4379207,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','227416',4379208,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','227416',4379209,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','227646',4383127,'1775','255',3411223.36,3413086.37,1863.01,303670.63,0.00,0.00,0.00,0.00,0.00),('5','91','642','227646',4383128,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227646',4383129,'1777','255',3296916.85,3298840.78,1923.93,313600.59,0.00,0.00,0.00,0.00,0.00),('5','91','644','227646',4383130,'1778','255',837026.95,837698.46,671.51,109456.13,0.00,0.00,0.00,0.00,0.00),('5','91','644','227646',4383131,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227646',4383132,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','227646',4383133,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','227646',4383134,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','227914',4387908,'1775','255',3413086.37,3413918.90,832.53,135702.39,0.00,0.00,0.00,0.00,0.00),('5','91','642','227914',4387909,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227914',4387910,'1777','255',3298840.78,3300668.29,1827.51,297884.13,0.00,0.00,0.00,0.00,0.00),('5','91','644','227914',4387911,'1778','255',837698.46,840405.41,2706.95,441232.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','227914',4387912,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','227914',4387913,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','227914',4387914,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','227914',4387915,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','229505',4417849,'1775','255',3413918.90,3415464.83,1545.93,251986.59,0.00,0.00,0.00,0.00,0.00),('5','91','642','229505',4417850,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','229505',4417851,'1777','255',3300668.29,3302127.55,1459.26,237859.38,0.00,0.00,0.00,0.00,0.00),('5','91','644','229505',4417852,'1778','255',840405.41,842638.28,2232.87,363957.81,0.00,0.00,0.00,0.00,0.00),('5','91','644','229505',4417853,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','229505',4417854,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','229505',4417855,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','229505',4417856,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231309',4450934,'1775','255',3415464.83,3416696.60,1231.77,200778.51,0.00,0.00,0.00,0.00,0.00),('5','91','642','231309',4450935,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231309',4450936,'1777','255',3302127.55,3303645.24,1517.69,247383.47,0.00,0.00,0.00,0.00,0.00),('5','91','644','231309',4450937,'1778','255',842638.28,844085.60,1447.32,235913.16,0.00,0.00,0.00,0.00,0.00),('5','91','644','231309',4450938,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231309',4450939,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231309',4450940,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231309',4450941,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231315',4451129,'1775','255',3416696.60,3418421.53,1724.93,281163.59,0.00,0.00,0.00,0.00,0.00),('5','91','642','231315',4451130,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231315',4451131,'1777','255',3303645.24,3305949.70,2304.46,375626.98,0.00,0.00,0.00,0.00,0.00),('5','91','644','231315',4451132,'1778','255',844085.60,846986.72,2901.12,472882.56,0.00,0.00,0.00,0.00,0.00),('5','91','644','231315',4451133,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231315',4451134,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231315',4451135,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231315',4451136,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231317',4451167,'1775','255',3418421.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231317',4451168,'1776','255',60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231317',4451169,'1777','255',3305949.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231317',4451170,'1778','255',846986.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231317',4451171,'1779','255',196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231317',4451172,'1780','255',2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231317',4451173,'1781','256',1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231317',4451174,'1782','257',114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231421',4452539,'1775','255',3418421.53,3420260.75,1839.22,299792.86,0.00,0.00,0.00,0.00,0.00),('5','91','642','231421',4452540,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231421',4452541,'1777','255',3305949.70,3306973.34,1023.64,166853.32,0.00,0.00,0.00,0.00,0.00),('5','91','644','231421',4452542,'1778','255',846986.72,848291.77,1305.05,212723.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','231421',4452543,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231421',4452544,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231421',4452545,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231421',4452546,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231428',4452662,'1775','255',3420260.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231428',4452663,'1776','255',60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231428',4452664,'1777','255',3306973.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231428',4452665,'1778','255',848291.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231428',4452666,'1779','255',196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231428',4452667,'1780','255',2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231428',4452668,'1781','256',1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231428',4452669,'1782','257',114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231438',4452851,'1775','255',3420260.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231438',4452852,'1776','255',60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231438',4452853,'1777','255',3306973.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231438',4452854,'1778','255',848291.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231438',4452855,'1779','255',196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231438',4452856,'1780','255',2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231438',4452857,'1781','256',1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231438',4452858,'1782','257',114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231471',4453316,'1775','255',3420260.75,3421235.88,975.13,158946.19,0.00,0.00,0.00,0.00,0.00),('5','91','642','231471',4453317,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231471',4453318,'1777','255',3306973.34,3308716.27,1742.93,284097.59,0.00,0.00,0.00,0.00,0.00),('5','91','644','231471',4453319,'1778','255',848291.77,849649.62,1357.85,221329.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','231471',4453320,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231471',4453321,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231471',4453322,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231471',4453323,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231476',4453365,'1775','255',3421235.88,3422586.04,1350.16,220076.08,0.00,0.00,0.00,0.00,0.00),('5','91','642','231476',4453366,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231476',4453367,'1777','255',3308716.27,3308901.19,184.92,30141.96,0.00,0.00,0.00,0.00,0.00),('5','91','644','231476',4453368,'1778','255',849649.62,850331.19,681.57,111095.91,0.00,0.00,0.00,0.00,0.00),('5','91','644','231476',4453369,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231476',4453370,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231476',4453371,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231476',4453372,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231478',4453391,'1775','255',3422586.04,3424096.06,1510.02,246133.26,0.00,0.00,0.00,0.00,0.00),('5','91','642','231478',4453392,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231478',4453393,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231478',4453394,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231478',4453395,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231478',4453396,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231478',4453397,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231478',4453398,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231484',4453534,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231484',4453535,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231484',4453536,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231484',4453537,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231484',4453538,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231484',4453539,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231484',4453540,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231484',4453541,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231492',4453700,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231492',4453701,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231492',4453702,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231492',4453703,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231492',4453704,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231492',4453705,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231492',4453706,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231492',4453707,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231493',4453708,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231493',4453709,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231493',4453710,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231493',4453711,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231493',4453712,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231493',4453713,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231493',4453714,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231493',4453715,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231496',4453798,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231496',4453799,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231496',4453800,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231496',4453801,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231496',4453802,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231496',4453803,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231496',4453804,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231496',4453805,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231497',4453806,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231497',4453807,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231497',4453808,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231497',4453809,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231497',4453810,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231497',4453811,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231497',4453812,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231497',4453813,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231501',4453851,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231501',4453852,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231501',4453853,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231501',4453854,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231501',4453855,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231501',4453856,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231501',4453857,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231501',4453858,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231502',4453859,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231502',4453860,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231502',4453861,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231502',4453862,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231502',4453863,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231502',4453864,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231502',4453865,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231502',4453866,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231503',4453867,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231503',4453868,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231503',4453869,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231503',4453870,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231503',4453871,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231503',4453872,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231503',4453873,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231503',4453874,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231648',4456497,'1775','255',3424096.06,3424096.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231648',4456498,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231648',4456499,'1777','255',3308901.19,3308901.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231648',4456500,'1778','255',850331.19,850331.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','231648',4456501,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231648',4456502,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231648',4456503,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231648',4456504,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231934',4461740,'1775','255',3424096.06,3424705.06,609.00,99267.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','231934',4461741,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231934',4461742,'1777','255',3308901.19,3311890.21,2989.02,487210.26,0.00,0.00,0.00,0.00,0.00),('5','91','644','231934',4461743,'1778','255',850331.19,853154.23,2823.04,460155.52,0.00,0.00,0.00,0.00,0.00),('5','91','644','231934',4461744,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','231934',4461745,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','231934',4461746,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','231934',4461747,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','232197',4466573,'1775','255',3424705.06,3424705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','232197',4466574,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','232197',4466575,'1777','255',3311890.21,3314389.45,2499.24,407376.12,0.00,0.00,0.00,0.00,0.00),('5','91','644','232197',4466576,'1778','255',853154.23,854922.81,1768.58,288278.54,0.00,0.00,0.00,0.00,0.00),('5','91','644','232197',4466577,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','232197',4466578,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','232197',4466579,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','232197',4466580,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','232405',4470128,'1775','255',3424705.06,3424705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','232405',4470129,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','232405',4470130,'1777','255',3314389.45,3318367.79,3978.34,648469.42,0.00,0.00,0.00,0.00,0.00),('5','91','644','232405',4470131,'1778','255',854922.81,859411.63,4488.82,731677.66,0.00,0.00,0.00,0.00,0.00),('5','91','644','232405',4470132,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','232405',4470133,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','232405',4470134,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','232405',4470135,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','232698',4475661,'1775','255',3424705.06,3424705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','232698',4475662,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','232698',4475663,'1777','255',3318367.79,3321357.47,2989.68,487317.84,0.00,0.00,0.00,0.00,0.00),('5','91','644','232698',4475664,'1778','255',859411.63,861295.65,1884.02,307095.26,0.00,0.00,0.00,0.00,0.00),('5','91','644','232698',4475665,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','232698',4475666,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','232698',4475667,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','232698',4475668,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','232859',4478330,'1775','255',3424705.06,3424705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','232859',4478331,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','232859',4478332,'1777','255',3321357.47,3324168.35,2810.88,458173.44,0.00,0.00,0.00,0.00,0.00),('5','91','644','232859',4478333,'1778','255',861295.65,864020.30,2724.65,444117.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','232859',4478334,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','232859',4478335,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','232859',4478336,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','232859',4478337,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','233309',4486783,'1775','255',3424705.06,3424705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','233309',4486784,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','233309',4486785,'1777','255',3324168.35,3325918.51,1750.16,285276.08,0.00,0.00,0.00,0.00,0.00),('5','91','644','233309',4486786,'1778','255',864020.30,866451.12,2430.82,396223.66,0.00,0.00,0.00,0.00,0.00),('5','91','644','233309',4486787,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','233309',4486788,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','233309',4486789,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','233309',4486790,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','233428',4488533,'1775','255',3424705.06,3424705.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','233428',4488534,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','233428',4488535,'1777','255',3325918.51,3328161.71,2243.20,365641.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','233428',4488536,'1778','255',866451.12,868892.12,2441.00,397883.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','233428',4488537,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','233428',4488538,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','233428',4488539,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','233428',4488540,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','233641',4492422,'1775','255',3424705.06,3426622.75,1917.69,312583.47,0.00,0.00,0.00,0.00,0.00),('5','91','642','233641',4492423,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','233641',4492424,'1777','255',3328161.71,3330271.67,2109.96,343923.48,0.00,0.00,0.00,0.00,0.00),('5','91','644','233641',4492425,'1778','255',868892.12,872968.50,4076.38,664449.94,0.00,0.00,0.00,0.00,0.00),('5','91','644','233641',4492426,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','233641',4492427,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','233641',4492428,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','233641',4492429,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','234004',4499232,'1775','255',3426622.75,3430969.13,4346.38,708459.94,0.00,0.00,0.00,0.00,0.00),('5','91','642','234004',4499233,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234004',4499234,'1777','255',3330271.67,3330271.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','234004',4499235,'1778','255',872968.50,873553.87,585.37,95415.31,0.00,0.00,0.00,0.00,0.00),('5','91','644','234004',4499236,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234004',4499237,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','234004',4499238,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','234004',4499239,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','234074',4500231,'1775','255',3430969.13,3437229.87,6260.74,1020500.62,0.00,0.00,0.00,0.00,0.00),('5','91','642','234074',4500232,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234074',4500233,'1777','255',3330271.67,3330271.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','234074',4500234,'1778','255',873553.87,873553.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','234074',4500235,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234074',4500236,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','234074',4500237,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','234074',4500238,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','234367',4505621,'1775','255',3437229.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','234367',4505622,'1776','255',60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234367',4505623,'1777','255',3330271.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','234367',4505624,'1778','255',873553.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','234367',4505625,'1779','255',196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234367',4505626,'1780','255',2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','234367',4505627,'1781','256',1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','234367',4505628,'1782','257',114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','234648',4510712,'1775','255',3437229.87,3438965.31,1735.44,286347.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','234648',4510713,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234648',4510714,'1777','255',3330271.67,3333098.71,2827.04,466461.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','234648',4510715,'1778','255',873553.87,873703.87,150.00,24750.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','234648',4510716,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234648',4510717,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','234648',4510718,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','234648',4510719,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','234732',4512182,'1775','255',3438965.31,3438965.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','234732',4512183,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234732',4512184,'1777','255',3333098.71,3335352.59,2253.88,371890.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','234732',4512185,'1778','255',873703.87,877038.01,3334.14,550133.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','234732',4512186,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234732',4512187,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','234732',4512188,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','234732',4512189,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','234901',4515280,'1775','255',3438965.31,3441678.65,2713.34,447701.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','234901',4515281,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234901',4515282,'1777','255',3335352.59,3336625.80,1273.21,210079.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','234901',4515283,'1778','255',877038.01,878030.30,992.29,163727.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','234901',4515284,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','234901',4515285,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','234901',4515286,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','234901',4515287,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','235129',4519136,'1775','255',3441678.65,3442904.77,1226.12,202309.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','235129',4519137,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','235129',4519138,'1777','255',3336625.80,3339388.62,2762.82,455865.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','235129',4519139,'1778','255',878030.30,879859.78,1829.48,301864.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','235129',4519140,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','235129',4519141,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','235129',4519142,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','235129',4519143,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','235449',4524907,'1775','255',3442904.77,3443495.69,590.92,97501.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','235449',4524908,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','235449',4524909,'1777','255',3339388.62,3343036.49,3647.87,601898.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','235449',4524910,'1778','255',879859.78,883042.55,3182.77,525157.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','235449',4524911,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','235449',4524912,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','235449',4524913,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','235449',4524914,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','235609',4527493,'1775','255',3443495.69,3444785.00,1289.31,212736.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','235609',4527494,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','235609',4527495,'1777','255',3343036.49,3346427.98,3391.49,559595.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','235609',4527496,'1778','255',883042.55,885381.28,2338.73,385890.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','235609',4527497,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','235609',4527498,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','235609',4527499,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','235609',4527500,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','235896',4532486,'1775','255',3444785.00,3444919.86,134.86,22251.90,0.00,0.00,0.00,0.00,0.00),('5','91','642','235896',4532487,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','235896',4532488,'1777','255',3346427.98,3350632.21,4204.23,693697.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','235896',4532489,'1778','255',885381.28,888969.11,3587.83,591991.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','235896',4532490,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','235896',4532491,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','235896',4532492,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','235896',4532493,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','236096',4536126,'1775','255',3444919.86,3444919.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','236096',4536127,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','236096',4536128,'1777','255',3350632.21,3352561.85,1929.64,318390.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','236096',4536129,'1778','255',888969.11,891804.03,2834.92,467761.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','236096',4536130,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','236096',4536131,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','236096',4536132,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','236096',4536133,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','236458',4542593,'1775','255',3444919.86,3446434.92,1515.06,249984.90,0.00,0.00,0.00,0.00,0.00),('5','91','642','236458',4542594,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','236458',4542595,'1777','255',3352561.85,3352561.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','236458',4542596,'1778','255',891804.03,893640.79,1836.76,303065.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','236458',4542597,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','236458',4542598,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','236458',4542599,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','236458',4542600,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','236693',4546578,'1775','255',3446434.92,3447684.92,1250.00,206250.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','236693',4546579,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','236693',4546580,'1777','255',3352561.85,3352961.85,400.00,66000.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','236693',4546581,'1778','255',893640.79,895380.79,1740.00,287100.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','236693',4546582,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','236693',4546583,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','236693',4546584,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','236693',4546585,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','236814',4548671,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','236814',4548672,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','236814',4548673,'1777','255',3352961.85,3353241.87,280.02,46203.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','236814',4548674,'1778','255',895380.79,895530.03,149.24,24624.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','236814',4548675,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','236814',4548676,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','236814',4548677,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','236814',4548678,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','237127',4554337,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','237127',4554338,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','237127',4554339,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','237127',4554340,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','237127',4554341,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','237127',4554342,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','237127',4554343,'1781','256',1435892.69,1435892.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','237127',4554344,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','237253',4556334,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','237253',4556335,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','237253',4556336,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','237253',4556337,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','237253',4556338,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','237253',4556339,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','237253',4556340,'1781','256',1435892.69,1436028.38,135.69,46813.05,0.00,0.00,0.00,0.00,0.00),('5','91','646','237253',4556341,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','237494',4560852,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','237494',4560853,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','237494',4560854,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','237494',4560855,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','237494',4560856,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','237494',4560857,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','237494',4560858,'1781','256',1436028.38,1436190.95,162.57,56086.65,0.00,0.00,0.00,0.00,0.00),('5','91','646','237494',4560859,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','237689',4564169,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','237689',4564170,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','237689',4564171,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','237689',4564172,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','237689',4564173,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','237689',4564174,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','237689',4564175,'1781','256',1436190.95,1436545.96,355.01,122478.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','237689',4564176,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238065',4570304,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238065',4570305,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238065',4570306,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238065',4570307,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238065',4570308,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238065',4570309,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','238065',4570310,'1781','256',1436545.96,1436951.16,405.20,139794.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','238065',4570311,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238182',4572142,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238182',4572143,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238182',4572144,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238182',4572145,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238182',4572146,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238182',4572147,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','238182',4572148,'1781','256',1436951.16,1437774.42,823.26,284024.70,0.00,0.00,0.00,0.00,0.00),('5','91','646','238182',4572149,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238573',4579057,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238573',4579058,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238573',4579059,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238573',4579060,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238573',4579061,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238573',4579062,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','238573',4579063,'1781','256',1437774.42,1438034.43,260.01,89703.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','238573',4579064,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238701',4581189,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238701',4581190,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238701',4581191,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238701',4581192,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238701',4581193,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238701',4581194,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','238701',4581195,'1781','256',1438034.43,1438744.39,709.96,244936.20,0.00,0.00,0.00,0.00,0.00),('5','91','646','238701',4581196,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238884',4584369,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','238884',4584370,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238884',4584371,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238884',4584372,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','238884',4584373,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','238884',4584374,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','238884',4584375,'1781','256',1438744.39,1439607.75,863.36,297859.20,0.00,0.00,0.00,0.00,0.00),('5','91','646','238884',4584376,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','239244',4590731,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','239244',4590732,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','239244',4590733,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','239244',4590734,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','239244',4590735,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','239244',4590736,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','239244',4590737,'1781','256',1439607.75,1441028.62,1420.87,490200.15,0.00,0.00,0.00,0.00,0.00),('5','91','646','239244',4590738,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','239479',4594816,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','239479',4594817,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','239479',4594818,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','239479',4594819,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','239479',4594820,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','239479',4594821,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','239479',4594822,'1781','256',1441028.62,1442296.38,1267.76,437377.20,0.00,0.00,0.00,0.00,0.00),('5','91','646','239479',4594823,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','239699',4598642,'1775','255',3447684.92,3447684.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','239699',4598643,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','239699',4598644,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','239699',4598645,'1778','255',895530.03,895530.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','239699',4598646,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','239699',4598647,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','239699',4598648,'1781','256',1442296.38,1442852.99,556.61,192030.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','239699',4598649,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','239943',4602864,'1775','255',3447684.92,3450555.32,2870.40,473616.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','239943',4602865,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','239943',4602866,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','239943',4602867,'1778','255',895530.03,901504.49,5974.46,985785.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','239943',4602868,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','239943',4602869,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','239943',4602870,'1781','256',1442852.99,1443438.30,585.31,201931.95,0.00,0.00,0.00,0.00,0.00),('5','91','646','239943',4602871,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','240158',4606646,'1775','255',3450555.32,3452698.72,2143.40,353661.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','240158',4606647,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','240158',4606648,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','240158',4606649,'1778','255',901504.49,904933.30,3428.81,565753.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','240158',4606650,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','240158',4606651,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','240158',4606652,'1781','256',1443438.30,1444239.34,801.04,276358.80,0.00,0.00,0.00,0.00,0.00),('5','91','646','240158',4606653,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','240387',4610410,'1775','255',3452698.72,3456458.04,3759.32,620287.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','240387',4610411,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','240387',4610412,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','240387',4610413,'1778','255',904933.30,910906.84,5973.54,985634.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','240387',4610414,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','240387',4610415,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','240387',4610416,'1781','256',1444239.34,1445040.33,800.99,276341.55,0.00,0.00,0.00,0.00,0.00),('5','91','646','240387',4610417,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','240595',4613713,'1775','255',3456458.04,3459403.65,2945.61,486025.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','240595',4613714,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','240595',4613715,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','240595',4613716,'1778','255',910906.84,915187.86,4281.02,706368.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','240595',4613717,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','240595',4613718,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','240595',4613719,'1781','256',1445040.33,1445931.45,891.12,307436.40,0.00,0.00,0.00,0.00,0.00),('5','91','646','240595',4613720,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','240778',4616398,'1775','255',3459403.65,3461431.28,2027.63,334558.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','240778',4616399,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','240778',4616400,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','240778',4616401,'1778','255',915187.86,921996.88,6809.02,1123488.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','240778',4616402,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','240778',4616403,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','240778',4616404,'1781','256',1445931.45,1447181.00,1249.55,431094.75,0.00,0.00,0.00,0.00,0.00),('5','91','646','240778',4616405,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','241191',4624133,'1775','255',3461431.28,3462726.04,1294.76,213635.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','241191',4624134,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','241191',4624135,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','241191',4624136,'1778','255',921996.88,924357.23,2360.35,389457.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','241191',4624137,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','241191',4624138,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','241191',4624139,'1781','256',1447181.00,1448500.92,1319.92,455372.40,0.00,0.00,0.00,0.00,0.00),('5','91','646','241191',4624140,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','241431',4628141,'1775','255',3462726.04,3462726.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','241431',4628142,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','241431',4628143,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','241431',4628144,'1778','255',924357.23,924357.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','241431',4628145,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','241431',4628146,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','241431',4628147,'1781','256',1448500.92,1448815.08,314.16,108385.20,0.00,0.00,0.00,0.00,0.00),('5','91','646','241431',4628148,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','241592',4630757,'1775','255',3462726.04,3462726.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','241592',4630758,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','241592',4630759,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','241592',4630760,'1778','255',924357.23,924357.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','241592',4630761,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','241592',4630762,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','241592',4630763,'1781','256',1448815.08,1449097.17,282.09,97321.05,0.00,0.00,0.00,0.00,0.00),('5','91','646','241592',4630764,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','241919',4636554,'1775','255',3462726.04,3462726.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','241919',4636555,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','241919',4636556,'1777','255',3353241.87,3353241.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','241919',4636557,'1778','255',924357.23,924357.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','241919',4636558,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','241919',4636559,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','241919',4636560,'1781','256',1449097.17,1449387.25,290.08,100077.60,0.00,0.00,0.00,0.00,0.00),('5','91','646','241919',4636561,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','242149',4640593,'1775','255',3462726.04,3464064.53,1338.49,220850.85,0.00,0.00,0.00,0.00,0.00),('5','91','642','242149',4640594,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242149',4640595,'1777','255',3353241.87,3355506.63,2264.76,373685.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','242149',4640596,'1778','255',924357.23,924357.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','242149',4640597,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242149',4640598,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','242149',4640599,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','242149',4640600,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','242362',4644383,'1775','255',3464064.53,3470851.27,6786.74,1119812.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','242362',4644384,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242362',4644385,'1777','255',3355506.63,3359299.49,3792.86,625821.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','242362',4644386,'1778','255',924357.23,930206.69,5849.46,965160.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','242362',4644387,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242362',4644388,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','242362',4644389,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','242362',4644390,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','242493',4646456,'1775','255',3470851.27,3470851.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','242493',4646457,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242493',4646458,'1777','255',3359299.49,3368577.71,9278.22,1530906.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','242493',4646459,'1778','255',930206.69,940441.34,10234.65,1688717.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','242493',4646460,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242493',4646461,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','242493',4646462,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','242493',4646463,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','242833',4652394,'1775','255',3470851.27,3473049.78,2198.51,362754.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','242833',4652395,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242833',4652396,'1777','255',3368577.71,3368577.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','242833',4652397,'1778','255',940441.34,947240.27,6798.93,1121823.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','242833',4652398,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242833',4652399,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','242833',4652400,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','242833',4652401,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','242990',4655093,'1775','255',3473049.78,3474740.21,1690.43,278920.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','242990',4655094,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242990',4655095,'1777','255',3368577.71,3368577.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','242990',4655096,'1778','255',947240.27,950046.79,2806.52,463075.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','242990',4655097,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','242990',4655098,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','242990',4655099,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','242990',4655100,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','243232',4659376,'1775','255',3474740.21,3476249.24,1509.03,248989.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','243232',4659377,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','243232',4659378,'1777','255',3368577.71,3368577.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','243232',4659379,'1778','255',950046.79,953023.14,2976.35,491097.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','243232',4659380,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','243232',4659381,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','243232',4659382,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','243232',4659383,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','243457',4663440,'1775','255',3476249.24,3477470.75,1221.51,201549.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','243457',4663441,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','243457',4663442,'1777','255',3368577.71,3368762.71,185.00,30525.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','243457',4663443,'1778','255',953023.14,954247.37,1224.23,201997.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','243457',4663444,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','243457',4663445,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','243457',4663446,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','243457',4663447,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','243767',4668933,'1775','255',3477470.75,3477470.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','243767',4668934,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','243767',4668935,'1777','255',3368762.71,3368762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','243767',4668936,'1778','255',954247.37,954247.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','243767',4668937,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','243767',4668938,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','243767',4668939,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','243767',4668940,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244029',4673479,'1775','255',3477470.75,3477470.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244029',4673480,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244029',4673481,'1777','255',3368762.71,3368762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244029',4673482,'1778','255',954247.37,954247.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244029',4673483,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244029',4673484,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','244029',4673485,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','244029',4673486,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244225',4676747,'1775','255',3477470.75,3477470.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244225',4676748,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244225',4676749,'1777','255',3368762.71,3368762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244225',4676750,'1778','255',954247.37,954247.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244225',4676751,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244225',4676752,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','244225',4676753,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','244225',4676754,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244463',4680864,'1775','255',3477470.75,3477470.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244463',4680865,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244463',4680866,'1777','255',3368762.71,3368762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244463',4680867,'1778','255',954247.37,954247.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244463',4680868,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244463',4680869,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','244463',4680870,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','244463',4680871,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244617',4683466,'1775','255',3477470.75,3477470.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244617',4683467,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244617',4683468,'1777','255',3368762.71,3368762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244617',4683469,'1778','255',954247.37,954247.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244617',4683470,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244617',4683471,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','244617',4683472,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','244617',4683473,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244923',4688856,'1775','255',3477470.75,3477470.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','244923',4688857,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244923',4688858,'1777','255',3368762.71,3368762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244923',4688859,'1778','255',954247.37,954247.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','244923',4688860,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','244923',4688861,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','244923',4688862,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','244923',4688863,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','245162',4693058,'1775','255',3477470.75,3477470.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','245162',4693059,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','245162',4693060,'1777','255',3368762.71,3368762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','245162',4693061,'1778','255',954247.37,954247.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','245162',4693062,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','245162',4693063,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','245162',4693064,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','245162',4693065,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','245381',4696873,'1775','255',3477470.75,3477470.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','245381',4696874,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','245381',4696875,'1777','255',3368762.71,3368762.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','245381',4696876,'1778','255',954247.37,954247.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','245381',4696877,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','245381',4696878,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','245381',4696879,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','245381',4696880,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','245525',4699105,'1775','255',3477470.75,3479231.25,1760.50,290482.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','245525',4699106,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','245525',4699107,'1777','255',3368762.71,3370314.29,1551.58,256010.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','245525',4699108,'1778','255',954247.37,957315.72,3068.35,506277.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','245525',4699109,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','245525',4699110,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','245525',4699111,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','245525',4699112,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','245764',4703395,'1775','255',3479231.25,3479830.33,599.08,98848.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','245764',4703396,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','245764',4703397,'1777','255',3370314.29,3375601.72,5287.43,872425.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','245764',4703398,'1778','255',957315.72,961804.47,4488.75,740643.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','245764',4703399,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','245764',4703400,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','245764',4703401,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','245764',4703402,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','246047',4707687,'1775','255',3479830.33,3481827.85,1997.52,329590.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','246047',4707688,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','246047',4707689,'1777','255',3375601.72,3375601.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','246047',4707690,'1778','255',961804.47,965665.67,3861.20,637098.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','246047',4707691,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','246047',4707692,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','246047',4707693,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','246047',4707694,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','246304',4711976,'1775','255',3481827.85,3483246.69,1418.84,234108.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','246304',4711977,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','246304',4711978,'1777','255',3375601.72,3377053.30,1451.58,239510.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','246304',4711979,'1778','255',965665.67,968122.94,2457.27,405449.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','246304',4711980,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','246304',4711981,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','246304',4711982,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','246304',4711983,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','246564',4716499,'1775','255',3483246.69,3484580.05,1333.36,220004.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','246564',4716500,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','246564',4716501,'1777','255',3377053.30,3379885.31,2832.01,467281.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','246564',4716502,'1778','255',968122.94,972187.49,4064.55,670650.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','246564',4716503,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','246564',4716504,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','246564',4716505,'1781','256',1449387.25,1449387.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','246564',4716506,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','246795',4720452,'1775','255',3484580.05,3486812.64,2232.59,368377.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','246795',4720453,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','246795',4720454,'1777','255',3379885.31,3379936.05,50.74,8372.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','246795',4720455,'1778','255',972187.49,975478.01,3290.52,542935.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','246795',4720456,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','246795',4720457,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','246795',4720458,'1781','256',1449387.25,1450616.05,1228.80,423936.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','246795',4720459,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','247103',4725891,'1775','255',3486812.64,3489780.88,2968.24,489759.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','247103',4725892,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247103',4725893,'1777','255',3379936.05,3381427.55,1491.50,246097.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','247103',4725894,'1778','255',975478.01,979578.99,4100.98,676661.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','247103',4725895,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247103',4725896,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','247103',4725897,'1781','256',1450616.05,1450780.07,164.02,56586.90,0.00,0.00,0.00,0.00,0.00),('5','91','646','247103',4725898,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','247233',4727986,'1775','255',3489780.88,3492898.31,3117.43,514375.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','247233',4727987,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247233',4727988,'1777','255',3381427.55,3383623.47,2195.92,362326.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','247233',4727989,'1778','255',979578.99,983476.59,3897.60,643104.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','247233',4727990,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247233',4727991,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','247233',4727992,'1781','256',1450780.07,1450947.63,167.56,57808.20,0.00,0.00,0.00,0.00,0.00),('5','91','646','247233',4727993,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','247436',4731577,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','247436',4731578,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247436',4731579,'1777','255',3383623.47,3383623.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','247436',4731580,'1778','255',983476.59,983476.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','247436',4731581,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247436',4731582,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','247436',4731583,'1781','256',1450947.63,1451647.83,700.20,241569.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','247436',4731584,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','247868',4739060,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','247868',4739061,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247868',4739062,'1777','255',3383623.47,3385385.21,1761.74,290687.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','247868',4739063,'1778','255',983476.59,985749.62,2273.03,375049.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','247868',4739064,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247868',4739065,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','247868',4739066,'1781','256',1451647.83,1451934.35,286.52,98849.40,0.00,0.00,0.00,0.00,0.00),('5','91','646','247868',4739067,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','247960',4740291,'1775','255',3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','247960',4740292,'1776','255',60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247960',4740293,'1777','255',3385385.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','247960',4740294,'1778','255',985749.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','247960',4740295,'1779','255',196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','247960',4740296,'1780','255',2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','247960',4740297,'1781','256',1451934.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','247960',4740298,'1782','257',114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248104',4743059,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248104',4743060,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248104',4743061,'1777','255',3385385.21,3388138.92,2753.71,454362.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','248104',4743062,'1778','255',985749.62,989769.16,4019.54,663224.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','248104',4743063,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248104',4743064,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','248104',4743065,'1781','256',1451934.35,1452377.28,442.93,152810.85,0.00,0.00,0.00,0.00,0.00),('5','91','646','248104',4743066,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248235',4745128,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248235',4745129,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248235',4745130,'1777','255',3388138.92,3392715.62,4576.70,755155.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','248235',4745131,'1778','255',989769.16,997388.34,7619.18,1257164.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','248235',4745132,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248235',4745133,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','248235',4745134,'1781','256',1452377.28,1453016.19,638.91,220423.95,0.00,0.00,0.00,0.00,0.00),('5','91','646','248235',4745135,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248455',4748645,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248455',4748646,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248455',4748647,'1777','255',3392715.62,3395886.69,3171.07,523226.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','248455',4748648,'1778','255',997388.34,1000704.42,3316.08,547153.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','248455',4748649,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248455',4748650,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','248455',4748651,'1781','256',1453016.19,1453472.80,456.61,157530.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','248455',4748652,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248805',4754857,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248805',4754858,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248805',4754859,'1777','255',3395886.69,3396851.70,965.01,159226.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','248805',4754860,'1778','255',1000704.42,1006986.01,6281.59,1036462.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','248805',4754861,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248805',4754862,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','248805',4754863,'1781','256',1453472.80,1453688.71,215.91,74488.95,0.00,0.00,0.00,0.00,0.00),('5','91','646','248805',4754864,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248911',4756433,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','248911',4756434,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248911',4756435,'1777','255',3396851.70,3398683.78,1832.08,302293.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','248911',4756436,'1778','255',1006986.01,1012404.60,5418.59,894067.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','248911',4756437,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','248911',4756438,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','248911',4756439,'1781','256',1453688.71,1453848.40,159.69,55093.05,0.00,0.00,0.00,0.00,0.00),('5','91','646','248911',4756440,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','249173',4760759,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','249173',4760760,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','249173',4760761,'1777','255',3398683.78,3398683.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','249173',4760762,'1778','255',1012404.60,1013430.85,1026.25,169331.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','249173',4760763,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','249173',4760764,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','249173',4760765,'1781','256',1453848.40,1454271.19,422.79,145862.55,0.00,0.00,0.00,0.00,0.00),('5','91','646','249173',4760766,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','249439',4765440,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','249439',4765441,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','249439',4765442,'1777','255',3398683.78,3398683.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','249439',4765443,'1778','255',1013430.85,1013430.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','249439',4765444,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','249439',4765445,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','249439',4765446,'1781','256',1454271.19,1454591.21,320.02,110406.90,0.00,0.00,0.00,0.00,0.00),('5','91','646','249439',4765447,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','249682',4769504,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','249682',4769505,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','249682',4769506,'1777','255',3398683.78,3398683.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','249682',4769507,'1778','255',1013430.85,1013430.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','249682',4769508,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','249682',4769509,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','249682',4769510,'1781','256',1454591.21,1454847.01,255.80,88251.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','249682',4769511,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','249935',4773842,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','249935',4773843,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','249935',4773844,'1777','255',3398683.78,3398683.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','249935',4773845,'1778','255',1013430.85,1013430.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','249935',4773846,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','249935',4773847,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','249935',4773848,'1781','256',1454847.01,1455903.30,1056.29,364420.05,0.00,0.00,0.00,0.00,0.00),('5','91','646','249935',4773849,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','250156',4777443,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','250156',4777444,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','250156',4777445,'1777','255',3398683.78,3398683.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','250156',4777446,'1778','255',1013430.85,1013430.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','250156',4777447,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','250156',4777448,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','250156',4777449,'1781','256',1455903.30,1456353.33,450.03,155260.35,0.00,0.00,0.00,0.00,0.00),('5','91','646','250156',4777450,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','250380',4781182,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','250380',4781183,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','250380',4781184,'1777','255',3398683.78,3398683.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','250380',4781185,'1778','255',1013430.85,1013430.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','250380',4781186,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','250380',4781187,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','250380',4781188,'1781','256',1456353.33,1456953.85,600.52,207179.40,0.00,0.00,0.00,0.00,0.00),('5','91','646','250380',4781189,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','250634',4785373,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','250634',4785374,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','250634',4785375,'1777','255',3398683.78,3398683.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','250634',4785376,'1778','255',1013430.85,1013430.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','250634',4785377,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','250634',4785378,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','250634',4785379,'1781','256',1456953.85,1457508.92,555.07,191499.15,0.00,0.00,0.00,0.00,0.00),('5','91','646','250634',4785380,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','250977',4791827,'1775','255',3492898.31,3492898.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','250977',4791828,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','250977',4791829,'1777','255',3398683.78,3398683.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','250977',4791830,'1778','255',1013430.85,1013430.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','250977',4791831,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','250977',4791832,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','250977',4791833,'1781','256',1457508.92,1458310.93,802.01,276693.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','250977',4791834,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','251117',4794027,'1775','255',3492898.31,3498004.70,5106.39,842554.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','251117',4794028,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','251117',4794029,'1777','255',3398683.78,3403253.86,4570.08,754063.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','251117',4794030,'1778','255',1013430.85,1023340.87,9910.02,1635153.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','251117',4794031,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','251117',4794032,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','251117',4794033,'1781','256',1458310.93,1459055.67,744.74,256935.30,0.00,0.00,0.00,0.00,0.00),('5','91','646','251117',4794034,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','251434',4799624,'1775','255',3498004.70,3498004.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','251434',4799625,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','251434',4799626,'1777','255',3403253.86,3406766.56,3512.70,579595.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','251434',4799627,'1778','255',1023340.87,1029201.10,5860.23,966937.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','251434',4799628,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','251434',4799629,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','251434',4799630,'1781','256',1459055.67,1459240.61,184.94,63804.30,0.00,0.00,0.00,0.00,0.00),('5','91','646','251434',4799631,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','251612',4802645,'1775','255',3498004.70,3501799.86,3795.16,626201.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','251612',4802646,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','251612',4802647,'1777','255',3406766.56,3408335.80,1569.24,258924.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','251612',4802648,'1778','255',1029201.10,1037732.20,8531.10,1407631.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','251612',4802649,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','251612',4802650,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','251612',4802651,'1781','256',1459240.61,1459564.46,323.85,111728.25,0.00,0.00,0.00,0.00,0.00),('5','91','646','251612',4802652,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','251936',4808363,'1775','255',3501799.86,3504809.21,3009.35,496542.75,0.00,0.00,0.00,0.00,0.00),('5','91','642','251936',4808364,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','251936',4808365,'1777','255',3408335.80,3408335.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','251936',4808366,'1778','255',1037732.20,1042699.93,4967.73,819675.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','251936',4808367,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','251936',4808368,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','251936',4808369,'1781','256',1459564.46,1459723.88,159.42,54999.90,0.00,0.00,0.00,0.00,0.00),('5','91','646','251936',4808370,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','252097',4811114,'1775','255',3504809.21,3506725.85,1916.64,316245.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','252097',4811115,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','252097',4811116,'1777','255',3408335.80,3412558.89,4223.09,696809.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','252097',4811117,'1778','255',1042699.93,1048087.12,5387.19,888886.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','252097',4811118,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','252097',4811119,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','252097',4811120,'1781','256',1459723.88,1459863.89,140.01,48303.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','252097',4811121,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','252323',4814941,'1775','255',3506725.85,3506725.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','252323',4814942,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','252323',4814943,'1777','255',3412558.89,3413532.69,973.80,160677.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','252323',4814944,'1778','255',1048087.12,1055004.59,6917.47,1141382.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','252323',4814945,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','252323',4814946,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','252323',4814947,'1781','256',1459863.89,1460022.58,158.69,54748.05,0.00,0.00,0.00,0.00,0.00),('5','91','646','252323',4814948,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','252571',4819570,'1775','255',3506725.85,3506735.85,10.00,1650.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','252571',4819571,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','252571',4819572,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','252571',4819573,'1778','255',1055004.59,1062532.55,7527.96,1242113.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','252571',4819574,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','252571',4819575,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','252571',4819576,'1781','256',1460022.58,1460112.04,89.46,30863.70,0.00,0.00,0.00,0.00,0.00),('5','91','646','252571',4819577,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','252809',4823447,'1775','255',3506735.85,3507700.35,964.50,159142.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','252809',4823448,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','252809',4823449,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','252809',4823450,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','252809',4823451,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','252809',4823452,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','252809',4823453,'1781','256',1460112.04,1460312.05,200.01,69003.45,0.00,0.00,0.00,0.00,0.00),('5','91','646','252809',4823454,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253068',4827775,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253068',4827776,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253068',4827777,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253068',4827778,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253068',4827779,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253068',4827780,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','253068',4827781,'1781','256',1460312.05,1460595.13,283.08,97662.60,0.00,0.00,0.00,0.00,0.00),('5','91','646','253068',4827782,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253332',4832160,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253332',4832161,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253332',4832162,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253332',4832163,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253332',4832164,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253332',4832165,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','253332',4832166,'1781','256',1460595.13,1460850.92,255.79,88247.55,0.00,0.00,0.00,0.00,0.00),('5','91','646','253332',4832167,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253561',4836104,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253561',4836105,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253561',4836106,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253561',4836107,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253561',4836108,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253561',4836109,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','253561',4836110,'1781','256',1460850.92,1460850.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','253561',4836111,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253762',4839491,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253762',4839492,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253762',4839493,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253762',4839494,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253762',4839495,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253762',4839496,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','253762',4839497,'1781','256',1460850.92,1461146.98,296.06,102140.70,0.00,0.00,0.00,0.00,0.00),('5','91','646','253762',4839498,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253834',4840985,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','253834',4840986,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253834',4840987,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253834',4840988,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','253834',4840989,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','253834',4840990,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','253834',4840991,'1781','256',1461146.98,1461411.43,264.45,91235.25,0.00,0.00,0.00,0.00,0.00),('5','91','646','253834',4840992,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','254021',4844105,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','254021',4844106,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','254021',4844107,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','254021',4844108,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','254021',4844109,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','254021',4844110,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','254021',4844111,'1781','256',1461411.43,1461700.21,288.78,99629.10,0.00,0.00,0.00,0.00,0.00),('5','91','646','254021',4844112,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','254307',4849290,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','254307',4849291,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','254307',4849292,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','254307',4849293,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','254307',4849294,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','254307',4849295,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','254307',4849296,'1781','256',1461700.21,1461880.25,180.04,62113.80,0.00,0.00,0.00,0.00,0.00),('5','91','646','254307',4849297,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','254551',4853428,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','254551',4853429,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','254551',4853430,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','254551',4853431,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','254551',4853432,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','254551',4853433,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','254551',4853434,'1781','256',1461880.25,1462024.69,144.44,49831.80,0.00,0.00,0.00,0.00,0.00),('5','91','646','254551',4853435,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','254927',4860140,'1775','255',3507700.35,3507700.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','254927',4860141,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','254927',4860142,'1777','255',3413532.69,3413532.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','254927',4860143,'1778','255',1062532.55,1062532.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','254927',4860144,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','254927',4860145,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','254927',4860146,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','254927',4860147,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','255051',4862097,'1775','255',3507700.35,3509632.15,1931.80,318747.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','255051',4862098,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','255051',4862099,'1777','255',3413532.69,3414673.40,1140.71,188217.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','255051',4862100,'1778','255',1062532.55,1067270.44,4737.89,781751.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','255051',4862101,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','255051',4862102,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','255051',4862103,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','255051',4862104,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','255246',4865205,'1775','255',3509632.15,3511521.52,1889.37,311746.05,0.00,0.00,0.00,0.00,0.00),('5','91','642','255246',4865206,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','255246',4865207,'1777','255',3414673.40,3418608.19,3934.79,649240.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','255246',4865208,'1778','255',1067270.44,1067270.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','255246',4865209,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','255246',4865210,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','255246',4865211,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','255246',4865212,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','255547',4870202,'1775','255',3511521.52,3511521.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','255547',4870203,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','255547',4870204,'1777','255',3418608.19,3420088.26,1480.07,244211.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','255547',4870205,'1778','255',1067270.44,1071537.58,4267.14,704078.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','255547',4870206,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','255547',4870207,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','255547',4870208,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','255547',4870209,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','255817',4874820,'1775','255',3511521.52,3512111.35,589.83,97321.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','255817',4874821,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','255817',4874822,'1777','255',3420088.26,3426116.83,6028.57,994714.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','255817',4874823,'1778','255',1071537.58,1071537.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','255817',4874824,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','255817',4874825,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','255817',4874826,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','255817',4874827,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','256038',4878576,'1775','255',3512111.35,3517008.60,4897.25,808046.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','256038',4878577,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','256038',4878578,'1777','255',3426116.83,3426116.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','256038',4878579,'1778','255',1071537.58,1071537.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','256038',4878580,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','256038',4878581,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','256038',4878582,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','256038',4878583,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','256310',4882858,'1775','255',3517008.60,3520547.97,3539.37,583996.05,0.00,0.00,0.00,0.00,0.00),('5','91','642','256310',4882859,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','256310',4882860,'1777','255',3426116.83,3426116.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','256310',4882861,'1778','255',1071537.58,1072132.48,594.90,98158.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','256310',4882862,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','256310',4882863,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','256310',4882864,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','256310',4882865,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','256678',4889339,'1775','255',3520547.97,3520547.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','256678',4889340,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','256678',4889341,'1777','255',3426116.83,3428611.31,2494.48,411589.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','256678',4889342,'1778','255',1072132.48,1072832.48,700.00,115500.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','256678',4889343,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','256678',4889344,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','256678',4889345,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','256678',4889346,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','256820',4891564,'1775','255',3520547.97,3520547.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','256820',4891565,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','256820',4891566,'1777','255',3428611.31,3428611.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','256820',4891567,'1778','255',1072832.48,1076168.21,3335.73,550395.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','256820',4891568,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','256820',4891569,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','256820',4891570,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','256820',4891571,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257149',4897681,'1775','255',3520547.97,3522596.95,2048.98,338081.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257149',4897682,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257149',4897683,'1777','255',3428611.31,3428611.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257149',4897684,'1778','255',1076168.21,1076168.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257149',4897685,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257149',4897686,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257149',4897687,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257149',4897688,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257438',4902862,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257438',4902863,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257438',4902864,'1777','255',3428611.31,3428611.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257438',4902865,'1778','255',1076168.21,1077368.21,1200.00,198000.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257438',4902866,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257438',4902867,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257438',4902868,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257438',4902869,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257439',4902870,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257439',4902871,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257439',4902872,'1777','255',3428611.31,3428611.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257439',4902873,'1778','255',1077368.21,1077368.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257439',4902874,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257439',4902875,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257439',4902876,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257439',4902877,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257440',4902878,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257440',4902879,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257440',4902880,'1777','255',3428611.31,3428611.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257440',4902881,'1778','255',1077368.21,1077368.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257440',4902882,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257440',4902883,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257440',4902884,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257440',4902885,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257441',4902886,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257441',4902887,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257441',4902888,'1777','255',3428611.31,3428611.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257441',4902889,'1778','255',1077368.21,1077368.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257441',4902890,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257441',4902891,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257441',4902892,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257441',4902893,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257442',4902894,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257442',4902895,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257442',4902896,'1777','255',3428611.31,3428696.16,84.85,14000.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257442',4902897,'1778','255',1077368.21,1078088.33,720.12,118819.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257442',4902898,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257442',4902899,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257442',4902900,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257442',4902901,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257443',4902902,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257443',4902903,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257443',4902904,'1777','255',3428696.16,3432523.58,3827.42,631524.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257443',4902905,'1778','255',1078088.33,1080294.25,2205.92,363976.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257443',4902906,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257443',4902907,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257443',4902908,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257443',4902909,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257444',4902910,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257444',4902911,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257444',4902912,'1777','255',3432523.58,3434691.68,2168.10,357736.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257444',4902913,'1778','255',1080294.25,1083889.39,3595.14,593198.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257444',4902914,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257444',4902915,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257444',4902916,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257444',4902917,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257445',4902918,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257445',4902919,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257445',4902920,'1777','255',3434691.68,3437461.66,2769.98,457046.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257445',4902921,'1778','255',1083889.39,1086429.15,2539.76,419060.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257445',4902922,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257445',4902923,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257445',4902924,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257445',4902925,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257446',4902926,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257446',4902927,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257446',4902928,'1777','255',3437461.66,3439355.29,1893.63,312448.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','257446',4902929,'1778','255',1086429.15,1089799.43,3370.28,556096.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257446',4902930,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257446',4902931,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257446',4902932,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257446',4902933,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257447',4902934,'1775','255',3522596.95,3522596.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257447',4902935,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257447',4902936,'1777','255',3439355.29,3443089.26,3733.97,616105.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257447',4902937,'1778','255',1089799.43,1092740.63,2941.20,485298.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257447',4902938,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257447',4902939,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257447',4902940,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257447',4902941,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257448',4902942,'1775','255',3522596.95,3525227.46,2630.51,434034.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257448',4902943,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257448',4902944,'1777','255',3443089.26,3443349.26,260.00,42900.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257448',4902945,'1778','255',1092740.63,1096884.17,4143.54,683684.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257448',4902946,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257448',4902947,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257448',4902948,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257448',4902949,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257449',4902950,'1775','255',3525227.46,3531031.36,5803.90,957643.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257449',4902951,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257449',4902952,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257449',4902953,'1778','255',1096884.17,1103765.10,6880.93,1135353.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257449',4902954,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257449',4902955,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257449',4902956,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257449',4902957,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257450',4902958,'1775','255',3531031.36,3534221.26,3189.90,526333.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257450',4902959,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257450',4902960,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257450',4902961,'1778','255',1103765.10,1110279.61,6514.51,1074894.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257450',4902962,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257450',4902963,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257450',4902964,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257450',4902965,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257451',4902966,'1775','255',3534221.26,3537735.54,3514.28,579856.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257451',4902967,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257451',4902968,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257451',4902969,'1778','255',1110279.61,1114026.79,3747.18,618284.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257451',4902970,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257451',4902971,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257451',4902972,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257451',4902973,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257452',4902974,'1775','255',3537735.54,3540754.44,3018.90,498118.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257452',4902975,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257452',4902976,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257452',4902977,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257452',4902978,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257452',4902979,'1778','255',1114026.79,1119317.40,5290.61,872950.65,0.00,0.00,0.00,0.00,0.00),('5','91','645','257452',4902980,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257452',4902981,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257453',4902982,'1775','255',3540754.44,3545511.57,4757.13,784926.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','257453',4902983,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257453',4902984,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257453',4902985,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257453',4902986,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257453',4902987,'1778','255',1119317.40,1122958.29,3640.89,600746.85,0.00,0.00,0.00,0.00,0.00),('5','91','645','257453',4902988,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257453',4902989,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257454',4902990,'1775','255',3545511.57,3552410.47,6898.90,1138318.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257454',4902991,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257454',4902992,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257454',4902993,'1778','255',1122958.29,1125606.81,2648.52,437005.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257454',4902994,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257454',4902995,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257454',4902996,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257454',4902997,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257455',4902998,'1775','255',3552410.47,3556196.55,3786.08,624703.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257455',4902999,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257455',4903000,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257455',4903001,'1778','255',1125606.81,1141956.93,16350.12,2697769.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257455',4903002,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257455',4903003,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257455',4903004,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257455',4903005,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257456',4903006,'1775','255',3556196.55,3560374.61,4178.06,689379.90,0.00,0.00,0.00,0.00,0.00),('5','91','642','257456',4903007,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257456',4903008,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257456',4903009,'1778','255',1141956.93,1143414.93,1458.00,240570.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257456',4903010,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257456',4903011,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257456',4903012,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257456',4903013,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257457',4903014,'1775','255',3560374.61,3560374.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257457',4903015,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257457',4903016,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257457',4903017,'1778','255',1143414.93,1144416.95,1002.02,165333.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257457',4903018,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257457',4903019,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257457',4903020,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257457',4903021,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257458',4903022,'1775','255',3560374.61,3560374.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257458',4903023,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257458',4903024,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257458',4903025,'1778','255',1144416.95,1151158.48,6741.53,1112352.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257458',4903026,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257458',4903027,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257458',4903028,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257458',4903029,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257459',4903030,'1775','255',3560374.61,3560374.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257459',4903031,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257459',4903032,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257459',4903033,'1778','255',1151158.48,1159993.67,8835.19,1457806.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257459',4903034,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257459',4903035,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257459',4903036,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257459',4903037,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257460',4903038,'1775','255',3560374.61,3560374.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257460',4903039,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257460',4903040,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257460',4903041,'1778','255',1159993.67,1167102.72,7109.05,1172993.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257460',4903042,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257460',4903043,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257460',4903044,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257460',4903045,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257461',4903046,'1775','255',3560374.61,3560374.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257461',4903047,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257461',4903048,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257461',4903049,'1778','255',1167102.72,1173774.30,6671.58,1100810.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257461',4903050,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257461',4903051,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257461',4903052,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257461',4903053,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257462',4903054,'1775','255',3560374.61,3567887.86,7513.25,1239686.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','257462',4903055,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257462',4903056,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257462',4903057,'1778','255',1173774.30,1182253.25,8478.95,1399026.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','257462',4903058,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257462',4903059,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257462',4903060,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257462',4903061,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257463',4903062,'1775','255',3567887.86,3570253.79,2365.93,390378.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','257463',4903063,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257463',4903064,'1777','255',3443349.26,3443349.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257463',4903065,'1778','255',1182253.25,1185943.99,3690.74,608972.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257463',4903066,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257463',4903067,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257463',4903068,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257463',4903069,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257464',4903070,'1775','255',3570253.79,3573276.99,3023.20,498828.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257464',4903071,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257464',4903072,'1777','255',3443349.26,3445398.79,2049.53,338172.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257464',4903073,'1778','255',1185943.99,1187561.33,1617.34,266861.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257464',4903074,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257464',4903075,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257464',4903076,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257464',4903077,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257465',4903078,'1775','255',3573276.99,3574921.49,1644.50,271342.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257465',4903079,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257465',4903080,'1777','255',3445398.79,3450635.73,5236.94,864095.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257465',4903081,'1778','255',1187561.33,1188988.31,1426.98,235451.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257465',4903082,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257465',4903083,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257465',4903084,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257465',4903085,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257466',4903086,'1775','255',3574921.49,3579252.77,4331.28,714661.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257466',4903087,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257466',4903088,'1777','255',3450635.73,3455434.95,4799.22,791871.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257466',4903089,'1778','255',1188988.31,1195764.63,6776.32,1118092.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257466',4903090,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257466',4903091,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257466',4903092,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257466',4903093,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257467',4903094,'1775','255',3579252.77,3582728.76,3475.99,573538.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','257467',4903095,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257467',4903096,'1777','255',3455434.95,3462431.54,6996.59,1154437.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257467',4903097,'1778','255',1195764.63,1204179.57,8414.94,1388465.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257467',4903098,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257467',4903099,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257467',4903100,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257467',4903101,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257468',4903102,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257468',4903103,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257468',4903104,'1777','255',3462431.54,3465725.43,3293.89,543491.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257468',4903105,'1778','255',1204179.57,1210266.72,6087.15,1004379.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','257468',4903106,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257468',4903107,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257468',4903108,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257468',4903109,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257469',4903110,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257469',4903111,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257469',4903112,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257469',4903113,'1778','255',1210266.72,1212223.97,1957.25,322946.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257469',4903114,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257469',4903115,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257469',4903116,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257469',4903117,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257470',4903118,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257470',4903119,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257470',4903120,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257470',4903121,'1778','255',1212223.97,1212223.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257470',4903122,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257470',4903123,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257470',4903124,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257470',4903125,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257471',4903126,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257471',4903127,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257471',4903128,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257471',4903129,'1778','255',1212223.97,1212223.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257471',4903130,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257471',4903131,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257471',4903132,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257471',4903133,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257472',4903134,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257472',4903135,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257472',4903136,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257472',4903137,'1778','255',1212223.97,1212223.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257472',4903138,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257472',4903139,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257472',4903140,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257472',4903141,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257473',4903142,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257473',4903143,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257473',4903144,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257473',4903145,'1778','255',1212223.97,1212223.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257473',4903146,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257473',4903147,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257473',4903148,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257473',4903149,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257474',4903150,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257474',4903151,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257474',4903152,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257474',4903153,'1778','255',1212223.97,1212223.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257474',4903154,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257474',4903155,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257474',4903156,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257474',4903157,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257475',4903158,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257475',4903159,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257475',4903160,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257475',4903161,'1778','255',1212223.97,1212223.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257475',4903162,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257475',4903163,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257475',4903164,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257475',4903165,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257476',4903166,'1775','255',3582728.76,3582728.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257476',4903167,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257476',4903168,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257476',4903169,'1778','255',1212223.97,1213366.98,1143.01,188596.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257476',4903170,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257476',4903171,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257476',4903172,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257476',4903173,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257477',4903174,'1775','255',3582728.76,3584885.74,2156.98,355901.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257477',4903175,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257477',4903176,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257477',4903177,'1777','255',3465725.43,3465725.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257477',4903178,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257477',4903179,'1778','255',1213366.98,1216374.31,3007.33,496209.45,0.00,0.00,0.00,0.00,0.00),('5','91','645','257477',4903180,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257477',4903181,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257478',4903182,'1775','255',3584885.74,3586854.65,1968.91,324870.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257478',4903183,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257478',4903184,'1777','255',3465725.43,3469489.37,3763.94,621050.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257478',4903185,'1778','255',1216374.31,1216649.89,275.58,45470.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257478',4903186,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257478',4903187,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257478',4903188,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257478',4903189,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257479',4903190,'1775','255',3586854.65,3588630.36,1775.71,292992.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257479',4903191,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257479',4903192,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257479',4903193,'1777','255',3469489.37,3470423.32,933.95,154101.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','257479',4903194,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257479',4903195,'1778','255',1216649.89,1220696.69,4046.80,667722.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257479',4903196,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257479',4903197,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257480',4903198,'1775','255',3588630.36,3588630.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257480',4903199,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257480',4903200,'1777','255',3470423.32,3474143.66,3720.34,613856.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257480',4903201,'1778','255',1220696.69,1224640.54,3943.85,650735.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257480',4903202,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257480',4903203,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257480',4903204,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257480',4903205,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257481',4903206,'1775','255',3588630.36,3588630.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257481',4903207,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257481',4903208,'1777','255',3474143.66,3478049.07,3905.41,644392.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257481',4903209,'1778','255',1224640.54,1228880.36,4239.82,699570.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257481',4903210,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257481',4903211,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257481',4903212,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257481',4903213,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257482',4903214,'1775','255',3588630.36,3588630.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257482',4903215,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257482',4903216,'1777','255',3478049.07,3481575.49,3526.42,581859.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257482',4903217,'1778','255',1228880.36,1233191.72,4311.36,711374.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257482',4903218,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257482',4903219,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257482',4903220,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257482',4903221,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257483',4903222,'1775','255',3588630.36,3589009.16,378.80,62502.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257483',4903223,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257483',4903224,'1777','255',3481575.49,3484913.70,3338.21,550804.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257483',4903225,'1778','255',1233191.72,1237563.39,4371.67,721325.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257483',4903226,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257483',4903227,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257483',4903228,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257483',4903229,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257484',4903230,'1775','255',3589009.16,3589703.36,694.20,114543.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257484',4903231,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257484',4903232,'1777','255',3484913.70,3488897.16,3983.46,657270.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257484',4903233,'1778','255',1237563.39,1242218.78,4655.39,768139.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257484',4903234,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257484',4903235,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257484',4903236,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257484',4903237,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257485',4903238,'1775','255',3589703.36,3591608.52,1905.16,314351.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257485',4903239,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257485',4903240,'1777','255',3488897.16,3489435.66,538.50,88852.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257485',4903241,'1778','255',1242218.78,1244962.88,2744.10,452776.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257485',4903242,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257485',4903243,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257485',4903244,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257485',4903245,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257486',4903246,'1775','255',3591608.52,3593650.61,2042.09,336944.85,0.00,0.00,0.00,0.00,0.00),('5','91','642','257486',4903247,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257486',4903248,'1777','255',3489435.66,3490051.72,616.06,101649.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257486',4903249,'1778','255',1244962.88,1247772.49,2809.61,463585.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257486',4903250,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257486',4903251,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257486',4903252,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257486',4903253,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257487',4903254,'1775','255',3593650.61,3595182.85,1532.24,252819.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','257487',4903255,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257487',4903256,'1777','255',3490051.72,3490433.69,381.97,63025.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257487',4903257,'1778','255',1247772.49,1249891.38,2118.89,349616.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257487',4903258,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257487',4903259,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257487',4903260,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257487',4903261,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257488',4903262,'1775','255',3595182.85,3595182.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257488',4903263,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257488',4903264,'1777','255',3490433.69,3491061.99,628.30,103669.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257488',4903265,'1778','255',1249891.38,1253267.52,3376.14,557063.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257488',4903266,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257488',4903267,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257488',4903268,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257488',4903269,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257489',4903270,'1775','255',3595182.85,3595182.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257489',4903271,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257489',4903272,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257489',4903273,'1777','255',3491061.99,3494923.86,3861.87,637208.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257489',4903274,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257489',4903275,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257489',4903276,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257489',4903277,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257490',4903278,'1775','255',3595182.85,3597439.61,2256.76,372365.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257490',4903279,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257490',4903280,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257490',4903281,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257490',4903282,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257490',4903283,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257490',4903284,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257490',4903285,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257491',4903286,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257491',4903287,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257491',4903288,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257491',4903289,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257491',4903290,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257491',4903291,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257491',4903292,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257491',4903293,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257492',4903294,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257492',4903295,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257492',4903296,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257492',4903297,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257492',4903298,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257492',4903299,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257492',4903300,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257492',4903301,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257493',4903302,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257493',4903303,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257493',4903304,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257493',4903305,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257493',4903306,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257493',4903307,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257493',4903308,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257493',4903309,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257494',4903310,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257494',4903311,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257494',4903312,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257494',4903313,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257494',4903314,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257494',4903315,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257494',4903316,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257494',4903317,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257495',4903318,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257495',4903319,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257495',4903320,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257495',4903321,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257495',4903322,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257495',4903323,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257495',4903324,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257495',4903325,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257496',4903326,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257496',4903327,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257496',4903328,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257496',4903329,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257496',4903330,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257496',4903331,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257496',4903332,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257496',4903333,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257497',4903334,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257497',4903335,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257497',4903336,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257497',4903337,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257497',4903338,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257497',4903339,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257497',4903340,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257497',4903341,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257498',4903342,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257498',4903343,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257498',4903344,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257498',4903345,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257498',4903346,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257498',4903347,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257498',4903348,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257498',4903349,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257499',4903350,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257499',4903351,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257499',4903352,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257499',4903353,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257499',4903354,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257499',4903355,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257499',4903356,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257499',4903357,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257500',4903358,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257500',4903359,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257500',4903360,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257500',4903361,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257500',4903362,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257500',4903363,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257500',4903364,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257500',4903365,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257501',4903366,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257501',4903367,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257501',4903368,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257501',4903369,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257501',4903370,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257501',4903371,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257501',4903372,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257501',4903373,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257502',4903374,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257502',4903375,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257502',4903376,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257502',4903377,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257502',4903378,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257502',4903379,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257502',4903380,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257502',4903381,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257503',4903382,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257503',4903383,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257503',4903384,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257503',4903385,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257503',4903386,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257503',4903387,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257503',4903388,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257503',4903389,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257504',4903390,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257504',4903391,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257504',4903392,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257504',4903393,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257504',4903394,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257504',4903395,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257504',4903396,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257504',4903397,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257505',4903398,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257505',4903399,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257505',4903400,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257505',4903401,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257505',4903402,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257505',4903403,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257505',4903404,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257505',4903405,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257506',4903406,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257506',4903407,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257506',4903408,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257506',4903409,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257506',4903410,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257506',4903411,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257506',4903412,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257506',4903413,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257507',4903414,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257507',4903415,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257507',4903416,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257507',4903417,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257507',4903418,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257507',4903419,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257507',4903420,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257507',4903421,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257508',4903422,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257508',4903423,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257508',4903424,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257508',4903425,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257508',4903426,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257508',4903427,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257508',4903428,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257508',4903429,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257509',4903430,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257509',4903431,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257509',4903432,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257509',4903433,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257509',4903434,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257509',4903435,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257509',4903436,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257509',4903437,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257510',4903438,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257510',4903439,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257510',4903440,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257510',4903441,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257510',4903442,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257510',4903443,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257510',4903444,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257510',4903445,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257511',4903446,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257511',4903447,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257511',4903448,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257511',4903449,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257511',4903450,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257511',4903451,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257511',4903452,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257511',4903453,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257512',4903454,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257512',4903455,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257512',4903456,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257512',4903457,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257512',4903458,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257512',4903459,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257512',4903460,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257512',4903461,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257513',4903462,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257513',4903463,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257513',4903464,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257513',4903465,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257513',4903466,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257513',4903467,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257513',4903468,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257513',4903469,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257514',4903470,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257514',4903471,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257514',4903472,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257514',4903473,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257514',4903474,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257514',4903475,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257514',4903476,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257514',4903477,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257515',4903478,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257515',4903479,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257515',4903480,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257515',4903481,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257515',4903482,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257515',4903483,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257515',4903484,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257515',4903485,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257516',4903486,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257516',4903487,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257516',4903488,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257516',4903489,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257516',4903490,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257516',4903491,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257516',4903492,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257516',4903493,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257517',4903494,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257517',4903495,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257517',4903496,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257517',4903497,'1778','255',1253267.52,1253267.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257517',4903498,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257517',4903499,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257517',4903500,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257517',4903501,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257518',4903502,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257518',4903503,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257518',4903504,'1777','255',3494923.86,3494923.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257518',4903505,'1778','255',1253267.52,1253892.55,625.03,103129.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','257518',4903506,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257518',4903507,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257518',4903508,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257518',4903509,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257519',4903510,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257519',4903511,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257519',4903512,'1777','255',3494923.86,3495326.85,402.99,66493.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257519',4903513,'1778','255',1253892.55,1258210.57,4318.02,712473.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257519',4903514,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257519',4903515,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257519',4903516,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257519',4903517,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257520',4903518,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257520',4903519,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257520',4903520,'1777','255',3495326.85,3497220.31,1893.46,312420.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257520',4903521,'1778','255',1258210.57,1261704.04,3493.47,576422.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257520',4903522,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257520',4903523,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257520',4903524,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257520',4903525,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257521',4903526,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257521',4903527,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257521',4903528,'1777','255',3497220.31,3500295.13,3074.82,507345.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257521',4903529,'1778','255',1261704.04,1264093.24,2389.20,394218.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257521',4903530,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257521',4903531,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257521',4903532,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257521',4903533,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257522',4903534,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257522',4903535,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257522',4903536,'1777','255',3500295.13,3503927.40,3632.27,599324.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257522',4903537,'1778','255',1264093.24,1265905.77,1812.53,299067.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257522',4903538,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257522',4903539,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257522',4903540,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257522',4903541,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257523',4903542,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257523',4903543,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257523',4903544,'1777','255',3503927.40,3507968.06,4040.66,666708.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257523',4903545,'1778','255',1265905.77,1267726.06,1820.29,300347.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257523',4903546,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257523',4903547,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257523',4903548,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257523',4903549,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257524',4903550,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257524',4903551,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257524',4903552,'1777','255',3507968.06,3511300.53,3332.47,549857.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257524',4903553,'1778','255',1267726.06,1268430.50,704.44,116232.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257524',4903554,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257524',4903555,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257524',4903556,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257524',4903557,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257525',4903558,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257525',4903559,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257525',4903560,'1777','255',3511300.53,3512377.70,1077.17,177733.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257525',4903561,'1778','255',1268430.50,1271500.25,3069.75,506508.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','257525',4903562,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257525',4903563,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257525',4903564,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257525',4903565,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257526',4903566,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257526',4903567,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257526',4903568,'1777','255',3512377.70,3516169.83,3792.13,625701.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257526',4903569,'1778','255',1271500.25,1273176.51,1676.26,276582.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257526',4903570,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257526',4903571,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257526',4903572,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257526',4903573,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257527',4903574,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257527',4903575,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257527',4903576,'1777','255',3516169.83,3516169.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257527',4903577,'1778','255',1273176.51,1277184.29,4007.78,661283.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257527',4903578,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257527',4903579,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257527',4903580,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257527',4903581,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257528',4903582,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257528',4903583,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257528',4903584,'1777','255',3516169.83,3519150.02,2980.19,491731.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257528',4903585,'1778','255',1277184.29,1278000.90,816.61,134740.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257528',4903586,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257528',4903587,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257528',4903588,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257528',4903589,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257529',4903590,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257529',4903591,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257529',4903592,'1777','255',3519150.02,3519150.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257529',4903593,'1778','255',1278000.90,1279056.29,1055.39,174139.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257529',4903594,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257529',4903595,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257529',4903596,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257529',4903597,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257530',4903598,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257530',4903599,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257530',4903600,'1777','255',3519150.02,3519150.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257530',4903601,'1778','255',1279056.29,1279056.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257530',4903602,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257530',4903603,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257530',4903604,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257530',4903605,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257531',4903606,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257531',4903607,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257531',4903608,'1777','255',3519150.02,3519150.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257531',4903609,'1778','255',1279056.29,1279056.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257531',4903610,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257531',4903611,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257531',4903612,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257531',4903613,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257532',4903614,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257532',4903615,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257532',4903616,'1777','255',3519150.02,3519150.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257532',4903617,'1778','255',1279056.29,1279956.32,900.03,148504.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','257532',4903618,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257532',4903619,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257532',4903620,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257532',4903621,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257533',4903622,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257533',4903623,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257533',4903624,'1777','255',3519150.02,3522793.48,3643.46,601170.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257533',4903625,'1778','255',1279956.32,1281121.72,1165.40,192291.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257533',4903626,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257533',4903627,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257533',4903628,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257533',4903629,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257534',4903630,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257534',4903631,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257534',4903632,'1777','255',3522793.48,3525450.08,2656.60,438339.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257534',4903633,'1778','255',1281121.72,1282750.16,1628.44,268692.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257534',4903634,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257534',4903635,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257534',4903636,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257534',4903637,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257535',4903638,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257535',4903639,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257535',4903640,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257535',4903641,'1777','255',3525450.08,3527517.20,2067.12,341074.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257535',4903642,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257535',4903643,'1778','255',1282750.16,1285615.35,2865.19,472756.35,0.00,0.00,0.00,0.00,0.00),('5','91','645','257535',4903644,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257535',4903645,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257536',4903646,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257536',4903647,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257536',4903648,'1777','255',3527517.20,3530623.99,3106.79,512620.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257536',4903649,'1778','255',1285615.35,1287207.00,1591.65,262622.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257536',4903650,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257536',4903651,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257536',4903652,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257536',4903653,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257537',4903654,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257537',4903655,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257537',4903656,'1777','255',3530623.99,3532950.61,2326.62,383892.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257537',4903657,'1778','255',1287207.00,1289901.45,2694.45,444584.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257537',4903658,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257537',4903659,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257537',4903660,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257537',4903661,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257538',4903662,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257538',4903663,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257538',4903664,'1777','255',3532950.61,3536405.15,3454.54,569999.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257538',4903665,'1778','255',1289901.45,1291778.87,1877.42,309774.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257538',4903666,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257538',4903667,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257538',4903668,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257538',4903669,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257539',4903670,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257539',4903671,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257539',4903672,'1777','255',3536405.15,3539599.17,3194.02,527013.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257539',4903673,'1778','255',1291778.87,1293881.63,2102.76,346955.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257539',4903674,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257539',4903675,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257539',4903676,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257539',4903677,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257540',4903678,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257540',4903679,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257540',4903680,'1777','255',3539599.17,3542247.01,2647.84,436893.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257540',4903681,'1778','255',1293881.63,1296075.35,2193.72,361963.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257540',4903682,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257540',4903683,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257540',4903684,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257540',4903685,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257541',4903686,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257541',4903687,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257541',4903688,'1777','255',3542247.01,3545981.87,3734.86,616251.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257541',4903689,'1778','255',1296075.35,1297600.91,1525.56,251717.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257541',4903690,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257541',4903691,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257541',4903692,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257541',4903693,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257542',4903694,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257542',4903695,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257542',4903696,'1777','255',3545981.87,3548228.27,2246.40,370656.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257542',4903697,'1778','255',1297600.91,1300876.59,3275.68,540487.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257542',4903698,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257542',4903699,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257542',4903700,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257542',4903701,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257543',4903702,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257543',4903703,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257543',4903704,'1777','255',3548228.27,3550535.75,2307.48,380734.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257543',4903705,'1778','255',1300876.59,1304365.03,3488.44,575592.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257543',4903706,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257543',4903707,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257543',4903708,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257543',4903709,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257544',4903710,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257544',4903711,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257544',4903712,'1777','255',3550535.75,3552217.23,1681.48,277444.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257544',4903713,'1778','255',1304365.03,1307742.64,3377.61,557305.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257544',4903714,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257544',4903715,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257544',4903716,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257544',4903717,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257545',4903718,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257545',4903719,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257545',4903720,'1777','255',3552217.23,3554900.43,2683.20,442728.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257545',4903721,'1778','255',1307742.64,1310659.69,2917.05,481313.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257545',4903722,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257545',4903723,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257545',4903724,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257545',4903725,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257546',4903726,'1775','255',3597439.61,3597439.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257546',4903727,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257546',4903728,'1777','255',3554900.43,3558557.96,3657.53,603492.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257546',4903729,'1778','255',1310659.69,1312365.49,1705.80,281457.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257546',4903730,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257546',4903731,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257546',4903732,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257546',4903733,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257547',4903734,'1775','255',3597439.61,3597719.39,279.78,46163.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257547',4903735,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257547',4903736,'1777','255',3558557.96,3560407.72,1849.76,305210.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257547',4903737,'1778','255',1312365.49,1315264.75,2899.26,478377.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257547',4903738,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257547',4903739,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257547',4903740,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257547',4903741,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257548',4903742,'1775','255',3597719.39,3597719.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257548',4903743,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257548',4903744,'1777','255',3560407.72,3563643.25,3235.53,533862.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257548',4903745,'1778','255',1315264.75,1317167.55,1902.80,313962.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257548',4903746,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257548',4903747,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257548',4903748,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257548',4903749,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257549',4903750,'1775','255',3597719.39,3597911.11,191.72,31633.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','257549',4903751,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257549',4903752,'1777','255',3563643.25,3565841.82,2198.57,362764.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257549',4903753,'1778','255',1317167.55,1319950.59,2783.04,459201.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257549',4903754,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257549',4903755,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257549',4903756,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257549',4903757,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257550',4903758,'1775','255',3597911.11,3597911.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257550',4903759,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257550',4903760,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257550',4903761,'1777','255',3565841.82,3567806.32,1964.50,324142.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257550',4903762,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257550',4903763,'1778','255',1319950.59,1323215.93,3265.34,538781.10,0.00,0.00,0.00,0.00,0.00),('5','91','645','257550',4903764,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257550',4903765,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257551',4903766,'1775','255',3597911.11,3597911.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257551',4903767,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257551',4903768,'1777','255',3567806.32,3567806.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257551',4903769,'1778','255',1323215.93,1328123.91,4907.98,809816.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257551',4903770,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257551',4903771,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257551',4903772,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257551',4903773,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257552',4903774,'1775','255',3597911.11,3599356.75,1445.64,238530.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','257552',4903775,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257552',4903776,'1777','255',3567806.32,3567806.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257552',4903777,'1778','255',1328123.91,1328513.92,390.01,64351.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257552',4903778,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257552',4903779,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257552',4903780,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257552',4903781,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257553',4903782,'1775','255',3599356.75,3599356.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257553',4903783,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257553',4903784,'1777','255',3567806.32,3567806.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257553',4903785,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257553',4903786,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257553',4903787,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257553',4903788,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257553',4903789,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257554',4903790,'1775','255',3599356.75,3599356.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257554',4903791,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257554',4903792,'1777','255',3567806.32,3567806.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257554',4903793,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257554',4903794,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257554',4903795,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257554',4903796,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257554',4903797,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257555',4903798,'1775','255',3599356.75,3599356.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257555',4903799,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257555',4903800,'1777','255',3567806.32,3567806.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257555',4903801,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257555',4903802,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257555',4903803,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257555',4903804,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257555',4903805,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257556',4903806,'1775','255',3599356.75,3599356.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257556',4903807,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257556',4903808,'1777','255',3567806.32,3569931.82,2125.50,350707.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257556',4903809,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257556',4903810,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257556',4903811,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257556',4903812,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257556',4903813,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257557',4903814,'1775','255',3599356.75,3602389.91,3033.16,500471.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257557',4903815,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257557',4903816,'1777','255',3569931.82,3571743.20,1811.38,298877.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257557',4903817,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257557',4903818,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257557',4903819,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257557',4903820,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257557',4903821,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257558',4903822,'1775','255',3602389.91,3604901.63,2511.72,414433.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','257558',4903823,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257558',4903824,'1777','255',3571743.20,3573962.17,2218.97,366130.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257558',4903825,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257558',4903826,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257558',4903827,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257558',4903828,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257558',4903829,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257559',4903830,'1775','255',3604901.63,3607414.47,2512.84,414618.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','257559',4903831,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257559',4903832,'1777','255',3573962.17,3576112.44,2150.27,354794.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257559',4903833,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257559',4903834,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257559',4903835,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257559',4903836,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257559',4903837,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257560',4903838,'1775','255',3607414.47,3610116.68,2702.21,445864.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','257560',4903839,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257560',4903840,'1777','255',3576112.44,3577813.29,1700.85,280640.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257560',4903841,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257560',4903842,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257560',4903843,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257560',4903844,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257560',4903845,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257561',4903846,'1775','255',3610116.68,3611418.39,1301.71,214782.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257561',4903847,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257561',4903848,'1777','255',3577813.29,3580931.38,3118.09,514484.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257561',4903849,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257561',4903850,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257561',4903851,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257561',4903852,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257561',4903853,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257562',4903854,'1775','255',3611418.39,3613121.61,1703.22,281031.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','257562',4903855,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257562',4903856,'1777','255',3580931.38,3583678.86,2747.48,453334.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257562',4903857,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257562',4903858,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257562',4903859,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257562',4903860,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257562',4903861,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257563',4903862,'1775','255',3613121.61,3614090.86,969.25,159926.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','257563',4903863,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257563',4903864,'1777','255',3583678.86,3586825.23,3146.37,519151.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257563',4903865,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257563',4903866,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257563',4903867,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257563',4903868,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257563',4903869,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257564',4903870,'1775','255',3614090.86,3616058.24,1967.38,324617.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257564',4903871,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257564',4903872,'1777','255',3586825.23,3588991.26,2166.03,357394.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','257564',4903873,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257564',4903874,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257564',4903875,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257564',4903876,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257564',4903877,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257565',4903878,'1775','255',3616058.24,3618044.42,1986.18,327719.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257565',4903879,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257565',4903880,'1777','255',3588991.26,3591606.99,2615.73,431595.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257565',4903881,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257565',4903882,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257565',4903883,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257565',4903884,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257565',4903885,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257566',4903886,'1775','255',3618044.42,3620897.12,2852.70,470695.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257566',4903887,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257566',4903888,'1777','255',3591606.99,3593370.15,1763.16,290921.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257566',4903889,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257566',4903890,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257566',4903891,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257566',4903892,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257566',4903893,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257567',4903894,'1775','255',3620897.12,3623366.62,2469.50,407467.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257567',4903895,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257567',4903896,'1777','255',3593370.15,3593855.66,485.51,80109.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257567',4903897,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257567',4903898,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257567',4903899,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257567',4903900,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257567',4903901,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257568',4903902,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257568',4903903,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257568',4903904,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257568',4903905,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257568',4903906,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257568',4903907,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257568',4903908,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257568',4903909,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257569',4903910,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257569',4903911,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257569',4903912,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257569',4903913,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257569',4903914,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257569',4903915,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257569',4903916,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257569',4903917,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257570',4903918,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257570',4903919,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257570',4903920,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257570',4903921,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257570',4903922,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257570',4903923,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257570',4903924,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257570',4903925,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257571',4903926,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257571',4903927,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257571',4903928,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257571',4903929,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257571',4903930,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257571',4903931,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257571',4903932,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257571',4903933,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257572',4903934,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257572',4903935,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257572',4903936,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257572',4903937,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257572',4903938,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257572',4903939,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257572',4903940,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257572',4903941,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257573',4903942,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257573',4903943,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257573',4903944,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257573',4903945,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257573',4903946,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257573',4903947,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257573',4903948,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257573',4903949,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257574',4903950,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257574',4903951,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257574',4903952,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257574',4903953,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257574',4903954,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257574',4903955,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257574',4903956,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257574',4903957,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257575',4903958,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257575',4903959,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257575',4903960,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257575',4903961,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257575',4903962,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257575',4903963,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257575',4903964,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257575',4903965,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257576',4903966,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257576',4903967,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257576',4903968,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257576',4903969,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257576',4903970,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257576',4903971,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257576',4903972,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257576',4903973,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257577',4903974,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257577',4903975,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257577',4903976,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257577',4903977,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257577',4903978,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257577',4903979,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257577',4903980,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257577',4903981,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257578',4903982,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257578',4903983,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257578',4903984,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257578',4903985,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257578',4903986,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257578',4903987,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257578',4903988,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257578',4903989,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257579',4903990,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257579',4903991,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257579',4903992,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257579',4903993,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257579',4903994,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257579',4903995,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257579',4903996,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257579',4903997,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257580',4903998,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257580',4903999,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257580',4904000,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257580',4904001,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257580',4904002,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257580',4904003,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257580',4904004,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257580',4904005,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257581',4904006,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257581',4904007,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257581',4904008,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257581',4904009,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257581',4904010,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257581',4904011,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257581',4904012,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257581',4904013,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257582',4904014,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257582',4904015,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257582',4904016,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257582',4904017,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257582',4904018,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257582',4904019,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257582',4904020,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257582',4904021,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257583',4904022,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257583',4904023,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257583',4904024,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257583',4904025,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257583',4904026,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257583',4904027,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257583',4904028,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257583',4904029,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257584',4904030,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257584',4904031,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257584',4904032,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257584',4904033,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257584',4904034,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257584',4904035,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257584',4904036,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257584',4904037,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257585',4904038,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257585',4904039,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257585',4904040,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257585',4904041,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257585',4904042,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257585',4904043,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257585',4904044,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257585',4904045,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257586',4904046,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257586',4904047,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257586',4904048,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257586',4904049,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257586',4904050,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257586',4904051,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257586',4904052,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257586',4904053,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257587',4904054,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257587',4904055,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257587',4904056,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257587',4904057,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257587',4904058,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257587',4904059,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257587',4904060,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257587',4904061,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257588',4904062,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257588',4904063,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257588',4904064,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257588',4904065,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257588',4904066,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257588',4904067,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257588',4904068,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257588',4904069,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257589',4904070,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257589',4904071,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257589',4904072,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257589',4904073,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257589',4904074,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257589',4904075,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257589',4904076,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257589',4904077,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257590',4904078,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257590',4904079,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257590',4904080,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257590',4904081,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257590',4904082,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257590',4904083,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257590',4904084,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257590',4904085,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257591',4904086,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257591',4904087,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257591',4904088,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257591',4904089,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257591',4904090,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257591',4904091,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257591',4904092,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257591',4904093,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257592',4904094,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257592',4904095,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257592',4904096,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257592',4904097,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257592',4904098,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257592',4904099,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257592',4904100,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257592',4904101,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257593',4904102,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257593',4904103,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257593',4904104,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257593',4904105,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257593',4904106,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257593',4904107,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257593',4904108,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257593',4904109,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257594',4904110,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257594',4904111,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257594',4904112,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257594',4904113,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257594',4904114,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257594',4904115,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257594',4904116,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257594',4904117,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257595',4904118,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257595',4904119,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257595',4904120,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257595',4904121,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257595',4904122,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257595',4904123,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257595',4904124,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257595',4904125,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257596',4904126,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257596',4904127,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257596',4904128,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257596',4904129,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257596',4904130,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257596',4904131,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257596',4904132,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257596',4904133,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257597',4904134,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257597',4904135,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257597',4904136,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257597',4904137,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257597',4904138,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257597',4904139,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257597',4904140,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257597',4904141,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257598',4904142,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257598',4904143,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257598',4904144,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257598',4904145,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257598',4904146,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257598',4904147,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257598',4904148,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257598',4904149,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257599',4904150,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257599',4904151,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257599',4904152,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257599',4904153,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257599',4904154,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257599',4904155,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257599',4904156,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257599',4904157,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257600',4904158,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257600',4904159,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257600',4904160,'1777','255',3593855.66,3593855.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257600',4904161,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257600',4904162,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257600',4904163,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257600',4904164,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257600',4904165,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257601',4904166,'1775','255',3623366.62,3623366.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257601',4904167,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257601',4904168,'1777','255',3593855.66,3595910.68,2055.02,380178.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257601',4904169,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257601',4904170,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257601',4904171,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257601',4904172,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257601',4904173,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257602',4904174,'1775','255',3623366.62,3626664.02,3297.40,610019.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257602',4904175,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257602',4904176,'1777','255',3595910.68,3596646.37,735.69,136102.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257602',4904177,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257602',4904178,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257602',4904179,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257602',4904180,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257602',4904181,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257603',4904182,'1775','255',3626664.02,3629039.41,2375.39,439447.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257603',4904183,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257603',4904184,'1777','255',3596646.37,3598397.00,1750.63,323866.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257603',4904185,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257603',4904186,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257603',4904187,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257603',4904188,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257603',4904189,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257604',4904190,'1775','255',3629039.41,3631748.96,2709.55,501266.75,0.00,0.00,0.00,0.00,0.00),('5','91','642','257604',4904191,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257604',4904192,'1777','255',3598397.00,3600332.73,1935.73,358110.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257604',4904193,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257604',4904194,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257604',4904195,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257604',4904196,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257604',4904197,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257605',4904198,'1775','255',3631748.96,3633975.90,2226.94,411983.90,0.00,0.00,0.00,0.00,0.00),('5','91','642','257605',4904199,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257605',4904200,'1777','255',3600332.73,3602568.00,2235.27,413524.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','257605',4904201,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257605',4904202,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257605',4904203,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257605',4904204,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257605',4904205,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257606',4904206,'1775','255',3633975.90,3637980.92,4005.02,740928.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257606',4904207,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257606',4904208,'1777','255',3602568.00,3605389.81,2821.81,522034.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257606',4904209,'1778','255',1328513.92,1328513.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257606',4904210,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257606',4904211,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257606',4904212,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257606',4904213,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257607',4904214,'1775','255',3637980.92,3640541.21,2560.29,473653.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','257607',4904215,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257607',4904216,'1777','255',3605389.81,3607512.37,2122.56,392673.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257607',4904217,'1778','255',1328513.92,1329468.95,955.03,176680.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257607',4904218,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257607',4904219,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257607',4904220,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257607',4904221,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257608',4904222,'1775','255',3640541.21,3642835.41,2294.20,424427.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257608',4904223,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257608',4904224,'1777','255',3607512.37,3607512.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257608',4904225,'1778','255',1329468.95,1333918.47,4449.52,823161.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257608',4904226,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257608',4904227,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257608',4904228,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257608',4904229,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257609',4904230,'1775','255',3642835.41,3644389.01,1553.60,287416.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257609',4904231,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257609',4904232,'1777','255',3607512.37,3607647.48,135.11,24995.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257609',4904233,'1778','255',1333918.47,1337649.97,3731.50,690327.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257609',4904234,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257609',4904235,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257609',4904236,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257609',4904237,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257610',4904238,'1775','255',3644389.01,3645226.50,837.49,154935.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','257610',4904239,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257610',4904240,'1777','255',3607647.48,3610071.19,2423.71,448386.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257610',4904241,'1778','255',1337649.97,1342343.48,4693.51,868299.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257610',4904242,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257610',4904243,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257610',4904244,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257610',4904245,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257611',4904246,'1775','255',3645226.50,3647164.55,1938.05,358539.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','257611',4904247,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257611',4904248,'1777','255',3610071.19,3610257.50,186.31,34467.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257611',4904249,'1778','255',1342343.48,1346637.62,4294.14,794415.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257611',4904250,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257611',4904251,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257611',4904252,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257611',4904253,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257612',4904254,'1775','255',3647164.55,3650134.13,2969.58,549372.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','257612',4904255,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257612',4904256,'1777','255',3610257.50,3610257.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257612',4904257,'1778','255',1346637.62,1349993.40,3355.78,620819.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257612',4904258,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257612',4904259,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257612',4904260,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257612',4904261,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257613',4904262,'1775','255',3650134.13,3652989.04,2854.91,528158.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','257613',4904263,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257613',4904264,'1777','255',3610257.50,3612542.74,2285.24,422769.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257613',4904265,'1778','255',1349993.40,1351112.45,1119.05,207024.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257613',4904266,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257613',4904267,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257613',4904268,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257613',4904269,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257614',4904270,'1775','255',3652989.04,3656812.42,3823.38,707325.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','257614',4904271,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257614',4904272,'1777','255',3612542.74,3615100.31,2557.57,473150.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257614',4904273,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257614',4904274,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257614',4904275,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257614',4904276,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257614',4904277,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257615',4904278,'1775','255',3656812.42,3659887.30,3074.88,568852.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','257615',4904279,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257615',4904280,'1777','255',3615100.31,3617404.63,2304.32,426299.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257615',4904281,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257615',4904282,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257615',4904283,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257615',4904284,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257615',4904285,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257616',4904286,'1775','255',3659887.30,3663155.55,3268.25,604626.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','257616',4904287,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257616',4904288,'1777','255',3617404.63,3619226.00,1821.37,336953.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257616',4904289,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257616',4904290,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257616',4904291,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257616',4904292,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257616',4904293,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257617',4904294,'1775','255',3663155.55,3668024.92,4869.37,900833.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','257617',4904295,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257617',4904296,'1777','255',3619226.00,3619226.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257617',4904297,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257617',4904298,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257617',4904299,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257617',4904300,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257617',4904301,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257618',4904302,'1775','255',3668024.92,3670010.17,1985.25,367271.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','257618',4904303,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257618',4904304,'1777','255',3619226.00,3619751.12,525.12,97147.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257618',4904305,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257618',4904306,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257618',4904307,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257618',4904308,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257618',4904309,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257619',4904310,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257619',4904311,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257619',4904312,'1777','255',3619751.12,3619751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257619',4904313,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257619',4904314,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257619',4904315,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257619',4904316,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257619',4904317,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257620',4904318,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257620',4904319,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257620',4904320,'1777','255',3619751.12,3619751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257620',4904321,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257620',4904322,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257620',4904323,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257620',4904324,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257620',4904325,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257621',4904326,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257621',4904327,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257621',4904328,'1777','255',3619751.12,3619751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257621',4904329,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257621',4904330,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257621',4904331,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257621',4904332,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257621',4904333,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257622',4904334,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257622',4904335,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257622',4904336,'1777','255',3619751.12,3619751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257622',4904337,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257622',4904338,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257622',4904339,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257622',4904340,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257622',4904341,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257623',4904342,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257623',4904343,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257623',4904344,'1777','255',3619751.12,3619751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257623',4904345,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257623',4904346,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257623',4904347,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257623',4904348,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257623',4904349,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257624',4904350,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257624',4904351,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257624',4904352,'1777','255',3619751.12,3619751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257624',4904353,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257624',4904354,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257624',4904355,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257624',4904356,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257624',4904357,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257625',4904358,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257625',4904359,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257625',4904360,'1777','255',3619751.12,3619751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257625',4904361,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257625',4904362,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257625',4904363,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257625',4904364,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257625',4904365,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257626',4904366,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257626',4904367,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257626',4904368,'1777','255',3619751.12,3620134.92,383.80,71003.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257626',4904369,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257626',4904370,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257626',4904371,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257626',4904372,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257626',4904373,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257627',4904374,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257627',4904375,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257627',4904376,'1777','255',3620134.92,3620134.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257627',4904377,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257627',4904378,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257627',4904379,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257627',4904380,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257627',4904381,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257628',4904382,'1775','255',3670010.17,3670010.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257628',4904383,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257628',4904384,'1777','255',3620134.92,3622599.65,2464.73,455975.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257628',4904385,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257628',4904386,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257628',4904387,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257628',4904388,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257628',4904389,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257629',4904390,'1775','255',3670010.17,3671695.15,1684.98,311721.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','257629',4904391,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257629',4904392,'1777','255',3622599.65,3626190.10,3590.45,664233.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257629',4904393,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257629',4904394,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257629',4904395,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257629',4904396,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257629',4904397,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257630',4904398,'1775','255',3671695.15,3674642.83,2947.68,545320.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','257630',4904399,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257630',4904400,'1777','255',3626190.10,3628258.80,2068.70,382709.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257630',4904401,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257630',4904402,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257630',4904403,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257630',4904404,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257630',4904405,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257631',4904406,'1775','255',3674642.83,3678844.07,4201.24,777229.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257631',4904407,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257631',4904408,'1777','255',3628258.80,3630526.70,2267.90,419561.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257631',4904409,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257631',4904410,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257631',4904411,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257631',4904412,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257631',4904413,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257632',4904414,'1775','255',3678844.07,3682913.89,4069.82,752916.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257632',4904415,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257632',4904416,'1777','255',3630526.70,3632820.28,2293.58,424312.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257632',4904417,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257632',4904418,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257632',4904419,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257632',4904420,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257632',4904421,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257633',4904422,'1775','255',3682913.89,3686732.48,3818.59,706439.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257633',4904423,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257633',4904424,'1777','255',3632820.28,3635354.18,2533.90,468771.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257633',4904425,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257633',4904426,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257633',4904427,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257633',4904428,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257633',4904429,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257634',4904430,'1775','255',3686732.48,3690075.41,3342.93,618442.05,0.00,0.00,0.00,0.00,0.00),('5','91','642','257634',4904431,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257634',4904432,'1777','255',3635354.18,3637934.78,2580.60,477411.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257634',4904433,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257634',4904434,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257634',4904435,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257634',4904436,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257634',4904437,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257635',4904438,'1775','255',3690075.41,3693600.00,3524.59,652049.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257635',4904439,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257635',4904440,'1777','255',3637934.78,3640970.25,3035.47,561561.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','257635',4904441,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257635',4904442,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257635',4904443,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257635',4904444,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257635',4904445,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257636',4904446,'1775','255',3693600.00,3697705.95,4105.95,759600.75,0.00,0.00,0.00,0.00,0.00),('5','91','642','257636',4904447,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257636',4904448,'1777','255',3640970.25,3643390.50,2420.25,447746.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257636',4904449,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257636',4904450,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257636',4904451,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257636',4904452,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257636',4904453,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257637',4904454,'1775','255',3697705.95,3701909.06,4203.11,777575.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','257637',4904455,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257637',4904456,'1777','255',3643390.50,3646038.15,2647.65,489815.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257637',4904457,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257637',4904458,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257637',4904459,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257637',4904460,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257637',4904461,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257638',4904462,'1775','255',3701909.06,3704399.93,2490.87,460810.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','257638',4904463,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257638',4904464,'1777','255',3646038.15,3650619.43,4581.28,847536.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257638',4904465,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257638',4904466,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257638',4904467,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257638',4904468,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257638',4904469,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257639',4904470,'1775','255',3704399.93,3707060.40,2660.47,492186.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','257639',4904471,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257639',4904472,'1777','255',3650619.43,3655413.52,4794.09,886906.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257639',4904473,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257639',4904474,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257639',4904475,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257639',4904476,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257639',4904477,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257640',4904478,'1775','255',3707060.40,3710805.38,3744.98,692821.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','257640',4904479,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257640',4904480,'1777','255',3655413.52,3658384.74,2971.22,549675.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257640',4904481,'1778','255',1351112.45,1351112.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257640',4904482,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257640',4904483,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257640',4904484,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257640',4904485,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257641',4904486,'1775','255',3710805.38,3713461.01,2655.63,491291.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','257641',4904487,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257641',4904488,'1777','255',3658384.74,3658384.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257641',4904489,'1778','255',1351112.45,1355321.22,4208.77,778622.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257641',4904490,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257641',4904491,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257641',4904492,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257641',4904493,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257642',4904494,'1775','255',3713461.01,3715021.49,1560.48,288688.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','257642',4904495,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257642',4904496,'1777','255',3658384.74,3658384.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257642',4904497,'1778','255',1355321.22,1359074.10,3752.88,694282.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257642',4904498,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257642',4904499,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257642',4904500,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257642',4904501,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257643',4904502,'1775','255',3715021.49,3717077.33,2055.84,380330.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257643',4904503,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257643',4904504,'1777','255',3658384.74,3658916.23,531.49,98325.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257643',4904505,'1778','255',1359074.10,1365178.26,6104.16,1129269.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257643',4904506,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257643',4904507,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257643',4904508,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257643',4904509,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257644',4904510,'1775','255',3717077.33,3719959.70,2882.37,533238.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','257644',4904511,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257644',4904512,'1777','255',3658916.23,3661549.14,2632.91,487088.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257644',4904513,'1778','255',1365178.26,1365178.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257644',4904514,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257644',4904515,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257644',4904516,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257644',4904517,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257645',4904518,'1775','255',3719959.70,3722965.96,3006.26,556158.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','257645',4904519,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257645',4904520,'1777','255',3661549.14,3664242.13,2692.99,498203.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257645',4904521,'1778','255',1365178.26,1365178.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257645',4904522,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257645',4904523,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257645',4904524,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257645',4904525,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257646',4904526,'1775','255',3722965.96,3726541.23,3575.27,661424.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','257646',4904527,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257646',4904528,'1777','255',3664242.13,3667902.22,3660.09,677116.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257646',4904529,'1778','255',1365178.26,1365178.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257646',4904530,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257646',4904531,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257646',4904532,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257646',4904533,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257647',4904534,'1775','255',3726541.23,3729667.76,3126.53,578408.05,0.00,0.00,0.00,0.00,0.00),('5','91','642','257647',4904535,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257647',4904536,'1777','255',3667902.22,3670363.86,2461.64,455403.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257647',4904537,'1778','255',1365178.26,1365178.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257647',4904538,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257647',4904539,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257647',4904540,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257647',4904541,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257648',4904542,'1775','255',3729667.76,3729667.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257648',4904543,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257648',4904544,'1777','255',3670363.86,3674434.06,4070.20,752987.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257648',4904545,'1778','255',1365178.26,1370458.54,5280.28,976851.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257648',4904546,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257648',4904547,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257648',4904548,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257648',4904549,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257649',4904550,'1775','255',3729667.76,3729667.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257649',4904551,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257649',4904552,'1777','255',3674434.06,3677443.35,3009.29,556718.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257649',4904553,'1778','255',1370458.54,1374256.18,3797.64,702563.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257649',4904554,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257649',4904555,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257649',4904556,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257649',4904557,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257650',4904558,'1775','255',3729667.76,3729667.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257650',4904559,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257650',4904560,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257650',4904561,'1777','255',3677443.35,3681585.23,4141.88,766247.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257650',4904562,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257650',4904563,'1778','255',1374256.18,1380534.70,6278.52,1161526.20,0.00,0.00,0.00,0.00,0.00),('5','91','645','257650',4904564,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257650',4904565,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257651',4904566,'1775','255',3729667.76,3731830.91,2163.15,400182.75,0.00,0.00,0.00,0.00,0.00),('5','91','642','257651',4904567,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257651',4904568,'1777','255',3681585.23,3682144.29,559.06,103426.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257651',4904569,'1778','255',1380534.70,1382981.09,2446.39,452582.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257651',4904570,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257651',4904571,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257651',4904572,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257651',4904573,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257652',4904574,'1775','255',3731830.91,3732537.52,706.61,130722.85,0.00,0.00,0.00,0.00,0.00),('5','91','642','257652',4904575,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257652',4904576,'1777','255',3682144.29,3685482.83,3338.54,617629.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257652',4904577,'1778','255',1382981.09,1386239.68,3258.59,602839.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257652',4904578,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257652',4904579,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257652',4904580,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257652',4904581,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257653',4904582,'1775','255',3732537.52,3732537.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257653',4904583,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257653',4904584,'1777','255',3685482.83,3688752.42,3269.59,604874.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257653',4904585,'1778','255',1386239.68,1389944.40,3704.72,685373.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257653',4904586,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257653',4904587,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257653',4904588,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257653',4904589,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257654',4904590,'1775','255',3732537.52,3734521.57,1984.05,367049.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','257654',4904591,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257654',4904592,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257654',4904593,'1777','255',3688752.42,3688752.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257654',4904594,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257654',4904595,'1778','255',1389944.40,1393972.53,4028.13,745204.05,0.00,0.00,0.00,0.00,0.00),('5','91','645','257654',4904596,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257654',4904597,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257655',4904598,'1775','255',3734521.57,3737821.26,3299.69,610442.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','257655',4904599,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257655',4904600,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257655',4904601,'1777','255',3688752.42,3688752.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257655',4904602,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257655',4904603,'1778','255',1393972.53,1400901.76,6929.23,1281907.55,0.00,0.00,0.00,0.00,0.00),('5','91','645','257655',4904604,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257655',4904605,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257656',4904606,'1775','255',3737821.26,3740021.68,2200.42,407077.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257656',4904607,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257656',4904608,'1777','255',3688752.42,3688752.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257656',4904609,'1778','255',1400901.76,1406151.12,5249.36,971131.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257656',4904610,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257656',4904611,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257656',4904612,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257656',4904613,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257657',4904614,'1775','255',3740021.68,3742666.63,2644.95,489315.75,0.00,0.00,0.00,0.00,0.00),('5','91','642','257657',4904615,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257657',4904616,'1777','255',3688752.42,3690562.43,1810.01,334851.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257657',4904617,'1778','255',1406151.12,1410917.21,4766.09,881726.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257657',4904618,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257657',4904619,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257657',4904620,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257657',4904621,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257658',4904622,'1775','255',3742666.63,3744902.41,2235.78,413619.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','257658',4904623,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257658',4904624,'1777','255',3690562.43,3694447.33,3884.90,718706.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257658',4904625,'1778','255',1410917.21,1410917.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257658',4904626,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257658',4904627,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257658',4904628,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257658',4904629,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257659',4904630,'1775','255',3744902.41,3747772.71,2870.30,531005.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257659',4904631,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257659',4904632,'1777','255',3694447.33,3697788.94,3341.61,618197.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257659',4904633,'1778','255',1410917.21,1410917.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257659',4904634,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257659',4904635,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257659',4904636,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257659',4904637,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257660',4904638,'1775','255',3747772.71,3747772.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257660',4904639,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257660',4904640,'1777','255',3697788.94,3701623.60,3834.66,709412.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257660',4904641,'1778','255',1410917.21,1415425.60,4508.39,834052.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257660',4904642,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257660',4904643,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257660',4904644,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257660',4904645,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257661',4904646,'1775','255',3747772.71,3750099.59,2326.88,430472.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','257661',4904647,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257661',4904648,'1777','255',3701623.60,3704891.38,3267.78,604539.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257661',4904649,'1778','255',1415425.60,1415425.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257661',4904650,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257661',4904651,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257661',4904652,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257661',4904653,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257662',4904654,'1775','255',3750099.59,3751786.44,1686.85,312067.25,0.00,0.00,0.00,0.00,0.00),('5','91','642','257662',4904655,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257662',4904656,'1777','255',3704891.38,3709707.09,4815.71,890906.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257662',4904657,'1778','255',1415425.60,1419125.83,3700.23,684542.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257662',4904658,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257662',4904659,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257662',4904660,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257662',4904661,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257663',4904662,'1775','255',3751786.44,3754725.15,2938.71,543661.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','257663',4904663,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257663',4904664,'1777','255',3709707.09,3713266.89,3559.80,658563.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257663',4904665,'1778','255',1419125.83,1419923.74,797.91,147613.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257663',4904666,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257663',4904667,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257663',4904668,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257663',4904669,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257664',4904670,'1775','255',3754725.15,3756776.85,2051.70,379564.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257664',4904671,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257664',4904672,'1777','255',3713266.89,3717012.95,3746.06,693021.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257664',4904673,'1778','255',1419923.74,1423349.03,3425.29,633678.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257664',4904674,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257664',4904675,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257664',4904676,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257664',4904677,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257665',4904678,'1775','255',3756776.85,3758548.52,1771.67,327758.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','257665',4904679,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257665',4904680,'1777','255',3717012.95,3719592.39,2579.44,477196.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257665',4904681,'1778','255',1423349.03,1423349.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257665',4904682,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257665',4904683,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257665',4904684,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257665',4904685,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257666',4904686,'1775','255',3758548.52,3761006.15,2457.63,454661.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','257666',4904687,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257666',4904688,'1777','255',3719592.39,3722560.18,2967.79,549041.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257666',4904689,'1778','255',1423349.03,1423730.52,381.49,70575.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257666',4904690,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257666',4904691,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257666',4904692,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257666',4904693,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257667',4904694,'1775','255',3761006.15,3763684.22,2678.07,495442.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','257667',4904695,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257667',4904696,'1777','255',3722560.18,3722560.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257667',4904697,'1778','255',1423730.52,1426063.70,2333.18,431638.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257667',4904698,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257667',4904699,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257667',4904700,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257667',4904701,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257668',4904702,'1775','255',3763684.22,3767092.21,3407.99,630478.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257668',4904703,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257668',4904704,'1777','255',3722560.18,3722560.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257668',4904705,'1778','255',1426063.70,1427869.54,1805.84,334080.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257668',4904706,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257668',4904707,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257668',4904708,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257668',4904709,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257669',4904710,'1775','255',3767092.21,3770919.02,3826.81,707959.85,0.00,0.00,0.00,0.00,0.00),('5','91','642','257669',4904711,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257669',4904712,'1777','255',3722560.18,3722797.28,237.10,43863.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257669',4904713,'1778','255',1427869.54,1429648.12,1778.58,329037.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257669',4904714,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257669',4904715,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257669',4904716,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257669',4904717,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257670',4904718,'1775','255',3770919.02,3774147.28,3228.26,597228.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','257670',4904719,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257670',4904720,'1777','255',3722797.28,3726869.98,4072.70,753449.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257670',4904721,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257670',4904722,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257670',4904723,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257670',4904724,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257670',4904725,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257671',4904726,'1775','255',3774147.28,3776656.81,2509.53,464263.05,0.00,0.00,0.00,0.00,0.00),('5','91','642','257671',4904727,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257671',4904728,'1777','255',3726869.98,3730112.36,3242.38,599840.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257671',4904729,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257671',4904730,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257671',4904731,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257671',4904732,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257671',4904733,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257672',4904734,'1775','255',3776656.81,3779501.64,2844.83,526293.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','257672',4904735,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257672',4904736,'1777','255',3730112.36,3733395.70,3283.34,607417.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257672',4904737,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257672',4904738,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257672',4904739,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257672',4904740,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257672',4904741,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257673',4904742,'1775','255',3779501.64,3782396.84,2895.20,535612.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257673',4904743,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257673',4904744,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257673',4904745,'1777','255',3733395.70,3736514.25,3118.55,576931.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','257673',4904746,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257673',4904747,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257673',4904748,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257673',4904749,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257674',4904750,'1775','255',3782396.84,3784858.10,2461.26,455333.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','257674',4904751,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257674',4904752,'1777','255',3736514.25,3738103.52,1589.27,294014.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','257674',4904753,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257674',4904754,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257674',4904755,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257674',4904756,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257674',4904757,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257675',4904758,'1775','255',3784858.10,3787333.31,2475.21,457913.85,0.00,0.00,0.00,0.00,0.00),('5','91','642','257675',4904759,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257675',4904760,'1777','255',3738103.52,3738103.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257675',4904761,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257675',4904762,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257675',4904763,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257675',4904764,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257675',4904765,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257676',4904766,'1775','255',3787333.31,3787333.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257676',4904767,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257676',4904768,'1777','255',3738103.52,3738103.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257676',4904769,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257676',4904770,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257676',4904771,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257676',4904772,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257676',4904773,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257677',4904774,'1775','255',3787333.31,3787333.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257677',4904775,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257677',4904776,'1777','255',3738103.52,3738103.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257677',4904777,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257677',4904778,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257677',4904779,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257677',4904780,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257677',4904781,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257678',4904782,'1775','255',3787333.31,3787333.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257678',4904783,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257678',4904784,'1777','255',3738103.52,3738103.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257678',4904785,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257678',4904786,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257678',4904787,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257678',4904788,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257678',4904789,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257679',4904790,'1775','255',3787333.31,3788383.33,1050.02,194253.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257679',4904791,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257679',4904792,'1777','255',3738103.52,3739308.96,1205.44,223006.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257679',4904793,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257679',4904794,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257679',4904795,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257679',4904796,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257679',4904797,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257680',4904798,'1775','255',3788383.33,3791830.91,3447.58,637802.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','257680',4904799,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257680',4904800,'1777','255',3739308.96,3743112.59,3803.63,703671.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257680',4904801,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257680',4904802,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257680',4904803,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257680',4904804,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257680',4904805,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257681',4904806,'1775','255',3791830.91,3795363.07,3532.16,653449.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','257681',4904807,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257681',4904808,'1777','255',3743112.59,3748326.12,5213.53,964503.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257681',4904809,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257681',4904810,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257681',4904811,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257681',4904812,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257681',4904813,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257682',4904814,'1775','255',3795363.07,3798258.19,2895.12,535597.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257682',4904815,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257682',4904816,'1777','255',3748326.12,3752628.72,4302.60,795981.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257682',4904817,'1778','255',1429648.12,1429648.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257682',4904818,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257682',4904819,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257682',4904820,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257682',4904821,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257683',4904822,'1775','255',3798258.19,3801585.52,3327.33,615556.05,0.00,0.00,0.00,0.00,0.00),('5','91','642','257683',4904823,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257683',4904824,'1777','255',3752628.72,3753358.58,729.86,135024.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257683',4904825,'1778','255',1429648.12,1436363.90,6715.78,1242419.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257683',4904826,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257683',4904827,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257683',4904828,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257683',4904829,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257684',4904830,'1775','255',3801585.52,3804555.76,2970.24,549494.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257684',4904831,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257684',4904832,'1777','255',3753358.58,3757961.54,4602.96,851547.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257684',4904833,'1778','255',1436363.90,1436363.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257684',4904834,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257684',4904835,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257684',4904836,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257684',4904837,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257685',4904838,'1775','255',3804555.76,3807042.73,2486.97,460089.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','257685',4904839,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257685',4904840,'1777','255',3757961.54,3758982.96,1021.42,188962.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257685',4904841,'1778','255',1436363.90,1442877.93,6514.03,1205095.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257685',4904842,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257685',4904843,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257685',4904844,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257685',4904845,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257686',4904846,'1775','255',3807042.73,3810282.59,3239.86,599374.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','257686',4904847,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257686',4904848,'1777','255',3758982.96,3762868.32,3885.36,718791.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257686',4904849,'1778','255',1442877.93,1442877.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257686',4904850,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257686',4904851,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257686',4904852,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257686',4904853,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257687',4904854,'1775','255',3810282.59,3812312.42,2029.83,375518.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','257687',4904855,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257687',4904856,'1777','255',3762868.32,3765125.25,2256.93,417532.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257687',4904857,'1778','255',1442877.93,1446166.91,3288.98,608461.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257687',4904858,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257687',4904859,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257687',4904860,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257687',4904861,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257688',4904862,'1775','255',3812312.42,3812465.93,153.51,28399.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','257688',4904863,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257688',4904864,'1777','255',3765125.25,3769727.51,4602.26,851418.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257688',4904865,'1778','255',1446166.91,1452591.90,6424.99,1188623.15,0.00,0.00,0.00,0.00,0.00),('5','91','644','257688',4904866,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257688',4904867,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257688',4904868,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257688',4904869,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257689',4904870,'1775','255',3812465.93,3815360.45,2894.52,535486.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257689',4904871,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257689',4904872,'1777','255',3769727.51,3772034.36,2306.85,426767.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257689',4904873,'1778','255',1452591.90,1453530.30,938.40,173604.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257689',4904874,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257689',4904875,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257689',4904876,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257689',4904877,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257690',4904878,'1775','255',3815360.45,3817203.15,1842.70,340899.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257690',4904879,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257690',4904880,'1777','255',3772034.36,3775794.25,3759.89,695579.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257690',4904881,'1778','255',1453530.30,1459499.70,5969.40,1104339.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257690',4904882,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257690',4904883,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257690',4904884,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257690',4904885,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257691',4904886,'1775','255',3817203.15,3820299.17,3096.02,572763.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257691',4904887,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257691',4904888,'1777','255',3775794.25,3782076.33,6282.08,1162184.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257691',4904889,'1778','255',1459499.70,1459687.41,187.71,34726.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257691',4904890,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257691',4904891,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257691',4904892,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257691',4904893,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257692',4904894,'1775','255',3820299.17,3820799.17,500.00,92500.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257692',4904895,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257692',4904896,'1777','255',3782076.33,3785033.08,2956.75,546998.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','257692',4904897,'1778','255',1459687.41,1464956.52,5269.11,974785.35,0.00,0.00,0.00,0.00,0.00),('5','91','644','257692',4904898,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257692',4904899,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257692',4904900,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257692',4904901,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257693',4904902,'1775','255',3820799.17,3824729.04,3929.87,727025.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','257693',4904903,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257693',4904904,'1777','255',3785033.08,3789315.09,4282.01,792171.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257693',4904905,'1778','255',1464956.52,1464956.52,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257693',4904906,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257693',4904907,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257693',4904908,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257693',4904909,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257694',4904910,'1775','255',3824729.04,3824729.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257694',4904911,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257694',4904912,'1777','255',3789315.09,3794047.30,4732.21,875458.85,0.00,0.00,0.00,0.00,0.00),('5','91','644','257694',4904913,'1778','255',1464956.52,1468717.37,3760.85,695757.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257694',4904914,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257694',4904915,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257694',4904916,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257694',4904917,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257695',4904918,'1775','255',3824729.04,3824889.03,159.99,29598.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257695',4904919,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257695',4904920,'1777','255',3794047.30,3798796.33,4749.03,878570.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257695',4904921,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257695',4904922,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257695',4904923,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257695',4904924,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257695',4904925,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257696',4904926,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257696',4904927,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257696',4904928,'1777','255',3798796.33,3800914.18,2117.85,391802.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257696',4904929,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257696',4904930,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257696',4904931,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257696',4904932,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257696',4904933,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257697',4904934,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257697',4904935,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257697',4904936,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257697',4904937,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257697',4904938,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257697',4904939,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257697',4904940,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257697',4904941,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257698',4904942,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257698',4904943,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257698',4904944,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257698',4904945,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257698',4904946,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257698',4904947,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257698',4904948,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257698',4904949,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257699',4904950,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257699',4904951,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257699',4904952,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257699',4904953,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257699',4904954,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257699',4904955,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257699',4904956,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257699',4904957,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257700',4904958,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257700',4904959,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257700',4904960,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257700',4904961,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257700',4904962,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257700',4904963,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257700',4904964,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257700',4904965,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257701',4904966,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257701',4904967,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257701',4904968,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257701',4904969,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257701',4904970,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257701',4904971,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257701',4904972,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257701',4904973,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257702',4904974,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257702',4904975,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257702',4904976,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257702',4904977,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257702',4904978,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257702',4904979,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257702',4904980,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257702',4904981,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257703',4904982,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257703',4904983,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257703',4904984,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257703',4904985,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257703',4904986,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257703',4904987,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257703',4904988,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257703',4904989,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257704',4904990,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257704',4904991,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257704',4904992,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257704',4904993,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257704',4904994,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257704',4904995,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257704',4904996,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257704',4904997,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257705',4904998,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257705',4904999,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257705',4905000,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257705',4905001,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257705',4905002,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257705',4905003,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257705',4905004,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257705',4905005,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257706',4905006,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257706',4905007,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257706',4905008,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257706',4905009,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257706',4905010,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257706',4905011,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257706',4905012,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257706',4905013,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257707',4905014,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257707',4905015,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257707',4905016,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257707',4905017,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257707',4905018,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257707',4905019,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257707',4905020,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257707',4905021,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257708',4905022,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257708',4905023,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257708',4905024,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257708',4905025,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257708',4905026,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257708',4905027,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257708',4905028,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257708',4905029,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257709',4905030,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257709',4905031,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257709',4905032,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257709',4905033,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257709',4905034,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257709',4905035,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257709',4905036,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257709',4905037,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257710',4905038,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257710',4905039,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257710',4905040,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257710',4905041,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257710',4905042,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257710',4905043,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257710',4905044,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257710',4905045,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257711',4905046,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257711',4905047,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257711',4905048,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257711',4905049,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257711',4905050,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257711',4905051,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257711',4905052,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257711',4905053,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257712',4905054,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257712',4905055,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257712',4905056,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257712',4905057,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257712',4905058,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257712',4905059,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257712',4905060,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257712',4905061,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257713',4905062,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257713',4905063,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257713',4905064,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257713',4905065,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257713',4905066,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257713',4905067,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257713',4905068,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257713',4905069,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257714',4905070,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257714',4905071,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257714',4905072,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257714',4905073,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257714',4905074,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257714',4905075,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257714',4905076,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257714',4905077,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257715',4905078,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257715',4905079,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257715',4905080,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257715',4905081,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257715',4905082,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257715',4905083,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257715',4905084,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257715',4905085,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257716',4905086,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257716',4905087,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257716',4905088,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257716',4905089,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257716',4905090,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257716',4905091,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257716',4905092,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257716',4905093,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257717',4905094,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257717',4905095,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257717',4905096,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257717',4905097,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257717',4905098,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257717',4905099,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257717',4905100,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257717',4905101,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257718',4905102,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257718',4905103,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257718',4905104,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257718',4905105,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257718',4905106,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257718',4905107,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257718',4905108,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257718',4905109,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257719',4905110,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257719',4905111,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257719',4905112,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257719',4905113,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257719',4905114,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257719',4905115,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257719',4905116,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257719',4905117,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257720',4905118,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257720',4905119,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257720',4905120,'1777','255',3800914.18,3800914.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257720',4905121,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257720',4905122,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257720',4905123,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257720',4905124,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257720',4905125,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257721',4905126,'1775','255',3824889.03,3824889.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257721',4905127,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257721',4905128,'1777','255',3800914.18,3803959.21,3045.03,563330.55,0.00,0.00,0.00,0.00,0.00),('5','91','644','257721',4905129,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257721',4905130,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257721',4905131,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257721',4905132,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257721',4905133,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257722',4905134,'1775','255',3824889.03,3831604.16,6715.13,1242299.05,0.00,0.00,0.00,0.00,0.00),('5','91','642','257722',4905135,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257722',4905136,'1777','255',3803959.21,3806445.15,2485.94,459898.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257722',4905137,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257722',4905138,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257722',4905139,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257722',4905140,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257722',4905141,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257723',4905142,'1775','255',3831604.16,3836310.98,4706.82,870761.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257723',4905143,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257723',4905144,'1777','255',3806445.15,3810996.43,4551.28,841986.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257723',4905145,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257723',4905146,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257723',4905147,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257723',4905148,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257723',4905149,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257724',4905150,'1775','255',3836310.98,3840639.41,4328.43,800759.55,0.00,0.00,0.00,0.00,0.00),('5','91','642','257724',4905151,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257724',4905152,'1777','255',3810996.43,3816254.17,5257.74,972681.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257724',4905153,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257724',4905154,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257724',4905155,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257724',4905156,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257724',4905157,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257725',4905158,'1775','255',3840639.41,3842187.90,1548.49,286470.65,0.00,0.00,0.00,0.00,0.00),('5','91','642','257725',4905159,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257725',4905160,'1777','255',3816254.17,3822859.72,6605.55,1222026.75,0.00,0.00,0.00,0.00,0.00),('5','91','644','257725',4905161,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257725',4905162,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257725',4905163,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257725',4905164,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257725',4905165,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257726',4905166,'1775','255',3842187.90,3843999.07,1811.17,335066.45,0.00,0.00,0.00,0.00,0.00),('5','91','642','257726',4905167,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257726',4905168,'1777','255',3822859.72,3828124.89,5265.17,974056.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257726',4905169,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257726',4905170,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257726',4905171,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257726',4905172,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257726',4905173,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257727',4905174,'1775','255',3843999.07,3846813.14,2814.07,520602.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','257727',4905175,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257727',4905176,'1777','255',3828124.89,3831076.34,2951.45,546018.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257727',4905177,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257727',4905178,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257727',4905179,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257727',4905180,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257727',4905181,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257728',4905182,'1775','255',3846813.14,3852381.73,5568.59,1030189.15,0.00,0.00,0.00,0.00,0.00),('5','91','642','257728',4905183,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257728',4905184,'1777','255',3831076.34,3831076.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257728',4905185,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257728',4905186,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257728',4905187,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257728',4905188,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257728',4905189,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257729',4905190,'1775','255',3852381.73,3854820.33,2438.60,451141.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257729',4905191,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257729',4905192,'1777','255',3831076.34,3831076.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257729',4905193,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257729',4905194,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257729',4905195,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257729',4905196,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257729',4905197,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257730',4905198,'1775','255',3854820.33,3854820.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257730',4905199,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257730',4905200,'1777','255',3831076.34,3831076.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257730',4905201,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257730',4905202,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257730',4905203,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257730',4905204,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257730',4905205,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257731',4905206,'1775','255',3854820.33,3854820.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257731',4905207,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257731',4905208,'1777','255',3831076.34,3831076.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257731',4905209,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257731',4905210,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257731',4905211,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257731',4905212,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257731',4905213,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257732',4905214,'1775','255',3854820.33,3856520.34,1700.01,314501.85,0.00,0.00,0.00,0.00,0.00),('5','91','642','257732',4905215,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257732',4905216,'1777','255',3831076.34,3832456.34,1380.00,255300.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257732',4905217,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257732',4905218,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257732',4905219,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257732',4905220,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257732',4905221,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257733',4905222,'1775','255',3856520.34,3859176.14,2655.80,491323.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257733',4905223,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257733',4905224,'1777','255',3832456.34,3838227.32,5770.98,1067631.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257733',4905225,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257733',4905226,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257733',4905227,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257733',4905228,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257733',4905229,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257734',4905230,'1775','255',3859176.14,3862697.78,3521.64,651503.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257734',4905231,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257734',4905232,'1777','255',3838227.32,3843729.17,5501.85,1017842.25,0.00,0.00,0.00,0.00,0.00),('5','91','644','257734',4905233,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257734',4905234,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257734',4905235,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257734',4905236,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257734',4905237,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257735',4905238,'1775','255',3862697.78,3867187.42,4489.64,830583.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257735',4905239,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257735',4905240,'1777','255',3843729.17,3849469.83,5740.66,1062022.10,0.00,0.00,0.00,0.00,0.00),('5','91','644','257735',4905241,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257735',4905242,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257735',4905243,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257735',4905244,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257735',4905245,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257736',4905246,'1775','255',3867187.42,3870516.94,3329.52,615961.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257736',4905247,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257736',4905248,'1777','255',3849469.83,3853175.80,3705.97,685604.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257736',4905249,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257736',4905250,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257736',4905251,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257736',4905252,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257736',4905253,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257737',4905254,'1775','255',3870516.94,3873839.45,3322.51,614664.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','257737',4905255,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257737',4905256,'1777','255',3853175.80,3856918.97,3743.17,692486.45,0.00,0.00,0.00,0.00,0.00),('5','91','644','257737',4905257,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257737',4905258,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257737',4905259,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257737',4905260,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257737',4905261,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257738',4905262,'1775','255',3873839.45,3876835.76,2996.31,554317.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','257738',4905263,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257738',4905264,'1777','255',3856918.97,3860494.21,3575.24,661419.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257738',4905265,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257738',4905266,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257738',4905267,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257738',4905268,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257738',4905269,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257739',4905270,'1775','255',3876835.76,3881967.94,5132.18,949453.30,0.00,0.00,0.00,0.00,0.00),('5','91','642','257739',4905271,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257739',4905272,'1777','255',3860494.21,3861034.74,540.53,99998.05,0.00,0.00,0.00,0.00,0.00),('5','91','644','257739',4905273,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257739',4905274,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257739',4905275,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257739',4905276,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257739',4905277,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257740',4905278,'1775','255',3881967.94,3884459.81,2491.87,460995.95,0.00,0.00,0.00,0.00,0.00),('5','91','642','257740',4905279,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257740',4905280,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257740',4905281,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257740',4905282,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257740',4905283,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257740',4905284,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257740',4905285,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257741',4905286,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257741',4905287,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257741',4905288,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257741',4905289,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257741',4905290,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257741',4905291,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257741',4905292,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257741',4905293,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257742',4905294,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257742',4905295,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257742',4905296,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257742',4905297,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257742',4905298,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257742',4905299,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257742',4905300,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257742',4905301,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257743',4905302,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257743',4905303,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257743',4905304,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257743',4905305,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257743',4905306,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257743',4905307,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257743',4905308,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257743',4905309,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257744',4905310,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257744',4905311,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257744',4905312,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257744',4905313,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257744',4905314,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257744',4905315,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257744',4905316,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257744',4905317,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257745',4905318,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257745',4905319,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257745',4905320,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257745',4905321,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257745',4905322,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257745',4905323,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257745',4905324,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257745',4905325,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257746',4905326,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257746',4905327,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257746',4905328,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257746',4905329,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257746',4905330,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257746',4905331,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257746',4905332,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257746',4905333,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257747',4905334,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257747',4905335,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257747',4905336,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257747',4905337,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257747',4905338,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257747',4905339,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257747',4905340,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257747',4905341,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257748',4905342,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257748',4905343,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257748',4905344,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257748',4905345,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257748',4905346,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257748',4905347,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257748',4905348,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257748',4905349,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257749',4905350,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257749',4905351,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257749',4905352,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257749',4905353,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257749',4905354,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257749',4905355,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257749',4905356,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257749',4905357,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257750',4905358,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257750',4905359,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257750',4905360,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257750',4905361,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257750',4905362,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257750',4905363,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257750',4905364,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257750',4905365,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257751',4905366,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257751',4905367,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257751',4905368,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257751',4905369,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257751',4905370,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257751',4905371,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257751',4905372,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257751',4905373,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257752',4905374,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257752',4905375,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257752',4905376,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257752',4905377,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257752',4905378,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257752',4905379,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257752',4905380,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257752',4905381,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257753',4905382,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257753',4905383,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257753',4905384,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257753',4905385,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257753',4905386,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257753',4905387,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257753',4905388,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257753',4905389,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257754',4905390,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257754',4905391,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257754',4905392,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257754',4905393,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257754',4905394,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257754',4905395,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257754',4905396,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257754',4905397,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257755',4905398,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257755',4905399,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257755',4905400,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257755',4905401,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257755',4905402,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257755',4905403,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257755',4905404,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257755',4905405,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257756',4905406,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257756',4905407,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257756',4905408,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257756',4905409,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257756',4905410,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257756',4905411,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257756',4905412,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257756',4905413,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257757',4905414,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257757',4905415,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257757',4905416,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257757',4905417,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257757',4905418,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257757',4905419,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257757',4905420,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257757',4905421,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257758',4905422,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257758',4905423,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257758',4905424,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257758',4905425,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257758',4905426,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257758',4905427,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257758',4905428,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257758',4905429,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257759',4905430,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257759',4905431,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257759',4905432,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257759',4905433,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257759',4905434,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257759',4905435,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257759',4905436,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257759',4905437,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257760',4905438,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257760',4905439,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257760',4905440,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257760',4905441,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257760',4905442,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257760',4905443,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257760',4905444,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257760',4905445,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257761',4905446,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257761',4905447,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257761',4905448,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257761',4905449,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257761',4905450,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257761',4905451,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257761',4905452,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257761',4905453,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257762',4905454,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257762',4905455,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257762',4905456,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257762',4905457,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257762',4905458,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257762',4905459,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257762',4905460,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257762',4905461,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257763',4905462,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257763',4905463,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257763',4905464,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257763',4905465,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257763',4905466,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257763',4905467,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257763',4905468,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257763',4905469,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257764',4905470,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257764',4905471,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257764',4905472,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257764',4905473,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257764',4905474,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257764',4905475,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257764',4905476,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257764',4905477,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257765',4905478,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257765',4905479,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257765',4905480,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257765',4905481,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257765',4905482,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257765',4905483,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257765',4905484,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257765',4905485,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257766',4905486,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257766',4905487,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257766',4905488,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257766',4905489,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257766',4905490,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257766',4905491,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257766',4905492,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257766',4905493,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257767',4905494,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257767',4905495,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257767',4905496,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257767',4905497,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257767',4905498,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257767',4905499,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257767',4905500,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257767',4905501,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257768',4905502,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257768',4905503,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257768',4905504,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257768',4905505,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257768',4905506,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257768',4905507,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257768',4905508,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257768',4905509,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257769',4905510,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257769',4905511,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257769',4905512,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257769',4905513,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257769',4905514,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257769',4905515,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257769',4905516,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257769',4905517,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257770',4905518,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257770',4905519,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257770',4905520,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257770',4905521,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257770',4905522,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257770',4905523,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257770',4905524,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257770',4905525,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257771',4905526,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257771',4905527,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257771',4905528,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257771',4905529,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257771',4905530,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257771',4905531,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257771',4905532,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257771',4905533,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257772',4905534,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257772',4905535,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257772',4905536,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257772',4905537,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257772',4905538,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257772',4905539,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257772',4905540,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257772',4905541,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257773',4905542,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257773',4905543,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257773',4905544,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257773',4905545,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257773',4905546,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257773',4905547,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257773',4905548,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257773',4905549,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257774',4905550,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257774',4905551,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257774',4905552,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257774',4905553,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257774',4905554,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257774',4905555,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257774',4905556,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257774',4905557,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257775',4905558,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257775',4905559,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257775',4905560,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257775',4905561,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257775',4905562,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257775',4905563,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257775',4905564,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257775',4905565,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257776',4905566,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257776',4905567,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257776',4905568,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257776',4905569,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257776',4905570,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257776',4905571,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257776',4905572,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257776',4905573,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257777',4905574,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257777',4905575,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257777',4905576,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257777',4905577,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257777',4905578,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257777',4905579,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257777',4905580,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257777',4905581,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257778',4905582,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257778',4905583,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257778',4905584,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257778',4905585,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257778',4905586,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257778',4905587,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257778',4905588,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257778',4905589,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257779',4905590,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257779',4905591,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257779',4905592,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257779',4905593,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257779',4905594,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257779',4905595,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257779',4905596,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257779',4905597,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257780',4905598,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257780',4905599,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257780',4905600,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257780',4905601,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257780',4905602,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257780',4905603,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257780',4905604,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257780',4905605,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257781',4905606,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257781',4905607,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257781',4905608,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257781',4905609,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257781',4905610,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257781',4905611,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257781',4905612,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257781',4905613,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257782',4905614,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257782',4905615,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257782',4905616,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257782',4905617,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257782',4905618,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257782',4905619,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257782',4905620,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257782',4905621,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257783',4905622,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257783',4905623,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257783',4905624,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257783',4905625,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257783',4905626,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257783',4905627,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257783',4905628,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257783',4905629,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257784',4905630,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257784',4905631,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257784',4905632,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257784',4905633,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257784',4905634,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257784',4905635,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257784',4905636,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257784',4905637,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257785',4905638,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257785',4905639,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257785',4905640,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257785',4905641,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257785',4905642,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257785',4905643,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257785',4905644,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257785',4905645,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257786',4905646,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257786',4905647,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257786',4905648,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257786',4905649,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257786',4905650,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257786',4905651,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257786',4905652,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257786',4905653,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257787',4905654,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257787',4905655,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257787',4905656,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257787',4905657,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257787',4905658,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257787',4905659,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257787',4905660,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257787',4905661,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257788',4905662,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257788',4905663,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257788',4905664,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257788',4905665,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257788',4905666,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257788',4905667,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257788',4905668,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257788',4905669,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257789',4905670,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257789',4905671,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257789',4905672,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257789',4905673,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257789',4905674,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257789',4905675,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257789',4905676,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257789',4905677,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257790',4905678,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257790',4905679,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257790',4905680,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257790',4905681,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257790',4905682,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257790',4905683,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257790',4905684,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257790',4905685,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257791',4905686,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257791',4905687,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257791',4905688,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257791',4905689,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257791',4905690,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257791',4905691,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257791',4905692,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257791',4905693,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257792',4905694,'1775','255',3884459.81,3884459.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257792',4905695,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257792',4905696,'1777','255',3861034.74,3861034.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257792',4905697,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257792',4905698,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257792',4905699,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257792',4905700,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257792',4905701,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257793',4905702,'1775','255',3884459.81,3885921.31,1461.50,270377.50,0.00,0.00,0.00,0.00,0.00),('5','91','642','257793',4905703,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257793',4905704,'1777','255',3861034.74,3862003.61,968.87,179240.95,0.00,0.00,0.00,0.00,0.00),('5','91','644','257793',4905705,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257793',4905706,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257793',4905707,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257793',4905708,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257793',4905709,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257794',4905710,'1775','255',3885921.31,3889976.62,4055.31,750232.35,0.00,0.00,0.00,0.00,0.00),('5','91','642','257794',4905711,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257794',4905712,'1777','255',3862003.61,3865380.30,3376.69,624687.65,0.00,0.00,0.00,0.00,0.00),('5','91','644','257794',4905713,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257794',4905714,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257794',4905715,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257794',4905716,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257794',4905717,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257795',4905718,'1775','255',3889976.62,3889976.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257795',4905719,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257795',4905720,'1777','255',3865380.30,3865380.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257795',4905721,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257795',4905722,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257795',4905723,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257795',4905724,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257795',4905725,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257796',4905726,'1775','255',3889976.62,3890697.70,721.08,158637.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','257796',4905727,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257796',4905728,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257796',4905729,'1777','255',3865380.30,3869235.27,3854.97,848093.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257796',4905730,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257796',4905731,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257796',4905732,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257796',4905733,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257797',4905734,'1775','255',3890697.70,3894540.13,3842.43,845334.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','257797',4905735,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257797',4905736,'1777','255',3869235.27,3875486.38,6251.11,1375244.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257797',4905737,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257797',4905738,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257797',4905739,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257797',4905740,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257797',4905741,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257798',4905742,'1775','255',3894540.13,3898712.19,4172.06,917853.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257798',4905743,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257798',4905744,'1777','255',3875486.38,3884023.65,8537.27,1878199.40,0.00,0.00,0.00,0.00,0.00),('5','91','644','257798',4905745,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257798',4905746,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257798',4905747,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257798',4905748,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257798',4905749,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257799',4905750,'1775','255',3898712.19,3901470.00,2757.81,606718.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257799',4905751,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257799',4905752,'1777','255',3884023.65,3891012.29,6988.64,1537500.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257799',4905753,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257799',4905754,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257799',4905755,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257799',4905756,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257799',4905757,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257800',4905758,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257800',4905759,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257800',4905760,'1777','255',3891012.29,3893810.19,2797.90,615538.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257800',4905761,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257800',4905762,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257800',4905763,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257800',4905764,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257800',4905765,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257801',4905766,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257801',4905767,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257801',4905768,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257801',4905769,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257801',4905770,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257801',4905771,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257801',4905772,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257801',4905773,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257802',4905774,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257802',4905775,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257802',4905776,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257802',4905777,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257802',4905778,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257802',4905779,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257802',4905780,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257802',4905781,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257803',4905782,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257803',4905783,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257803',4905784,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257803',4905785,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257803',4905786,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257803',4905787,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257803',4905788,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257803',4905789,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257804',4905790,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257804',4905791,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257804',4905792,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257804',4905793,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257804',4905794,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257804',4905795,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257804',4905796,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257804',4905797,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257805',4905798,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257805',4905799,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257805',4905800,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257805',4905801,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257805',4905802,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257805',4905803,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257805',4905804,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257805',4905805,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257806',4905806,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257806',4905807,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257806',4905808,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257806',4905809,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257806',4905810,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257806',4905811,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257806',4905812,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257806',4905813,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257807',4905814,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257807',4905815,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257807',4905816,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257807',4905817,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257807',4905818,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257807',4905819,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257807',4905820,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257807',4905821,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257808',4905822,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257808',4905823,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257808',4905824,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257808',4905825,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257808',4905826,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257808',4905827,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257808',4905828,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257808',4905829,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257809',4905830,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257809',4905831,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257809',4905832,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257809',4905833,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257809',4905834,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257809',4905835,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257809',4905836,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257809',4905837,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257810',4905838,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257810',4905839,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257810',4905840,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257810',4905841,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257810',4905842,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257810',4905843,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257810',4905844,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257810',4905845,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257811',4905846,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257811',4905847,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257811',4905848,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257811',4905849,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257811',4905850,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257811',4905851,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257811',4905852,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257811',4905853,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257812',4905854,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257812',4905855,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257812',4905856,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257812',4905857,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257812',4905858,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257812',4905859,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257812',4905860,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257812',4905861,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257813',4905862,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257813',4905863,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257813',4905864,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257813',4905865,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257813',4905866,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257813',4905867,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257813',4905868,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257813',4905869,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257814',4905870,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257814',4905871,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257814',4905872,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257814',4905873,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257814',4905874,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257814',4905875,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257814',4905876,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257814',4905877,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257815',4905878,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257815',4905879,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257815',4905880,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257815',4905881,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257815',4905882,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257815',4905883,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257815',4905884,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257815',4905885,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257816',4905886,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257816',4905887,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257816',4905888,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257816',4905889,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257816',4905890,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257816',4905891,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257816',4905892,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257816',4905893,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257817',4905894,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257817',4905895,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257817',4905896,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257817',4905897,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257817',4905898,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257817',4905899,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257817',4905900,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257817',4905901,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257818',4905902,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257818',4905903,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257818',4905904,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257818',4905905,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257818',4905906,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257818',4905907,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257818',4905908,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257818',4905909,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257819',4905910,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257819',4905911,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257819',4905912,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257819',4905913,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257819',4905914,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257819',4905915,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257819',4905916,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257819',4905917,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257820',4905918,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257820',4905919,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257820',4905920,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257820',4905921,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257820',4905922,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257820',4905923,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257820',4905924,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257820',4905925,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257821',4905926,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257821',4905927,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257821',4905928,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257821',4905929,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257821',4905930,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257821',4905931,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257821',4905932,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257821',4905933,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257822',4905934,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257822',4905935,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257822',4905936,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257822',4905937,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257822',4905938,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257822',4905939,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257822',4905940,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257822',4905941,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257823',4905942,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257823',4905943,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257823',4905944,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257823',4905945,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257823',4905946,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257823',4905947,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257823',4905948,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257823',4905949,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257824',4905950,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257824',4905951,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257824',4905952,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257824',4905953,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257824',4905954,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257824',4905955,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257824',4905956,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257824',4905957,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257825',4905958,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257825',4905959,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257825',4905960,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257825',4905961,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257825',4905962,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257825',4905963,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257825',4905964,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257825',4905965,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257826',4905966,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257826',4905967,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257826',4905968,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257826',4905969,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257826',4905970,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257826',4905971,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257826',4905972,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257826',4905973,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257827',4905974,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257827',4905975,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257827',4905976,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257827',4905977,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257827',4905978,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257827',4905979,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257827',4905980,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257827',4905981,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257828',4905982,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257828',4905983,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257828',4905984,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257828',4905985,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257828',4905986,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257828',4905987,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257828',4905988,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257828',4905989,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257829',4905990,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257829',4905991,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257829',4905992,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257829',4905993,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257829',4905994,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257829',4905995,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257829',4905996,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257829',4905997,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257830',4905998,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257830',4905999,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257830',4906000,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257830',4906001,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257830',4906002,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257830',4906003,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257830',4906004,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257830',4906005,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257831',4906006,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257831',4906007,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257831',4906008,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257831',4906009,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257831',4906010,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257831',4906011,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257831',4906012,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257831',4906013,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257832',4906014,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257832',4906015,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257832',4906016,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257832',4906017,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257832',4906018,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257832',4906019,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257832',4906020,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257832',4906021,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257833',4906022,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257833',4906023,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257833',4906024,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257833',4906025,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257833',4906026,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257833',4906027,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257833',4906028,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257833',4906029,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257834',4906030,'1775','255',3901470.00,3901470.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257834',4906031,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257834',4906032,'1777','255',3893810.19,3893810.19,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257834',4906033,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257834',4906034,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257834',4906035,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257834',4906036,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257834',4906037,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257835',4906038,'1775','255',3901470.00,3903794.80,2324.80,488208.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257835',4906039,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257835',4906040,'1777','255',3893810.19,3895779.08,1968.89,413466.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257835',4906041,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257835',4906042,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257835',4906043,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257835',4906044,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257835',4906045,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257836',4906046,'1775','255',3903794.80,3909744.26,5949.46,1249386.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','257836',4906047,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257836',4906048,'1777','255',3895779.08,3900291.93,4512.85,947698.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257836',4906049,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257836',4906050,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257836',4906051,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257836',4906052,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257836',4906053,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257837',4906054,'1775','255',3909744.26,3913739.37,3995.11,838973.10,0.00,0.00,0.00,0.00,0.00),('5','91','642','257837',4906055,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257837',4906056,'1777','255',3900291.93,3908502.98,8211.05,1724320.50,0.00,0.00,0.00,0.00,0.00),('5','91','644','257837',4906057,'1778','255',1468717.37,1468717.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257837',4906058,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257837',4906059,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257837',4906060,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257837',4906061,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257838',4906062,'1775','255',3913739.37,3916525.04,2785.67,584990.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257838',4906063,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257838',4906064,'1777','255',3908502.98,3913262.10,4759.12,999415.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257838',4906065,'1778','255',1468717.37,1471177.94,2460.57,516719.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257838',4906066,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257838',4906067,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257838',4906068,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257838',4906069,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257839',4906070,'1775','255',3916525.04,3920156.88,3631.84,762686.40,0.00,0.00,0.00,0.00,0.00),('5','91','642','257839',4906071,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257839',4906072,'1777','255',3913262.10,3916770.88,3508.78,736843.80,0.00,0.00,0.00,0.00,0.00),('5','91','644','257839',4906073,'1778','255',1471177.94,1477137.34,5959.40,1251474.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257839',4906074,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257839',4906075,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257839',4906076,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257839',4906077,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257840',4906078,'1775','255',3920156.88,3923672.36,3515.48,738250.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','257840',4906079,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257840',4906080,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257840',4906081,'1777','255',3916770.88,3919525.98,2755.10,578571.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257840',4906082,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257840',4906083,'1778','255',1477137.34,1481873.97,4736.63,994692.30,0.00,0.00,0.00,0.00,0.00),('5','91','645','257840',4906084,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257840',4906085,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257841',4906086,'1775','255',3923672.36,3926573.52,2901.16,609243.60,0.00,0.00,0.00,0.00,0.00),('5','91','642','257841',4906087,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257841',4906088,'1777','255',3919525.98,3923889.70,4363.72,916381.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257841',4906089,'1778','255',1481873.97,1487184.89,5310.92,1115293.20,0.00,0.00,0.00,0.00,0.00),('5','91','644','257841',4906090,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257841',4906091,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257841',4906092,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257841',4906093,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257842',4906094,'1775','255',3926573.52,3928984.30,2410.78,506263.80,0.00,0.00,0.00,0.00,0.00),('5','91','642','257842',4906095,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257842',4906096,'1777','255',3923889.70,3925528.56,1638.86,344160.60,0.00,0.00,0.00,0.00,0.00),('5','91','644','257842',4906097,'1778','255',1487184.89,1492478.16,5293.27,1111586.70,0.00,0.00,0.00,0.00,0.00),('5','91','644','257842',4906098,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257842',4906099,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257842',4906100,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257842',4906101,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257843',4906102,'1775','255',3928984.30,3932337.97,3353.67,704270.70,0.00,0.00,0.00,0.00,0.00),('5','91','642','257843',4906103,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257843',4906104,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257843',4906105,'1778','255',1492478.16,1497053.85,4575.69,960894.90,0.00,0.00,0.00,0.00,0.00),('5','91','644','257843',4906106,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257843',4906107,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257843',4906108,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257843',4906109,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257844',4906110,'1775','255',3932337.97,3934047.49,1709.52,358999.20,0.00,0.00,0.00,0.00,0.00),('5','91','642','257844',4906111,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257844',4906112,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257844',4906113,'1778','255',1497053.85,1501231.75,4177.90,877359.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257844',4906114,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257844',4906115,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257844',4906116,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257844',4906117,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257845',4906118,'1775','255',3934047.49,3936968.28,2920.79,613365.90,0.00,0.00,0.00,0.00,0.00),('5','91','642','257845',4906119,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257845',4906120,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257845',4906121,'1778','255',1501231.75,1501287.38,55.63,11682.30,0.00,0.00,0.00,0.00,0.00),('5','91','644','257845',4906122,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257845',4906123,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257845',4906124,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257845',4906125,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257846',4906126,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257846',4906127,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257846',4906128,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257846',4906129,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257846',4906130,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257846',4906131,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257846',4906132,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257846',4906133,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257847',4906134,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257847',4906135,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257847',4906136,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257847',4906137,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257847',4906138,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257847',4906139,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257847',4906140,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257847',4906141,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257848',4906142,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257848',4906143,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257848',4906144,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257848',4906145,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257848',4906146,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257848',4906147,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257848',4906148,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257848',4906149,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257849',4906150,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257849',4906151,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257849',4906152,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257849',4906153,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257849',4906154,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257849',4906155,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257849',4906156,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257849',4906157,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257850',4906158,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257850',4906159,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257850',4906160,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257850',4906161,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257850',4906162,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257850',4906163,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257850',4906164,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257850',4906165,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257851',4906166,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257851',4906167,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257851',4906168,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257851',4906169,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257851',4906170,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257851',4906171,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257851',4906172,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257851',4906173,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257852',4906174,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257852',4906175,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257852',4906176,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257852',4906177,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257852',4906178,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257852',4906179,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257852',4906180,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257852',4906181,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257853',4906182,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257853',4906183,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257853',4906184,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257853',4906185,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257853',4906186,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257853',4906187,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257853',4906188,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257853',4906189,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257854',4906190,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257854',4906191,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257854',4906192,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257854',4906193,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257854',4906194,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257854',4906195,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257854',4906196,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257854',4906197,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257855',4906198,'1775','255',3936968.28,3936968.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','642','257855',4906199,'1776','255',60985.92,60985.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257855',4906200,'1777','255',3925528.56,3925528.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257855',4906201,'1778','255',1501287.38,1501287.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','644','257855',4906202,'1779','255',196104.37,196104.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','643','257855',4906203,'1780','255',2778926.39,2778926.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','645','257855',4906204,'1781','256',1462024.69,1462024.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','91','646','257855',4906205,'1782','257',114285.44,114285.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730746 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','91','213070','255',165.00,165.00,3757.36,0.00,0.00,0.00,0.00,614246),('5','91','213070','256',295.00,295.00,35.71,0.00,0.00,0.00,0.00,614247),('5','91','213070','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614248),('5','91','213179','255',165.00,165.00,2737.60,0.00,0.00,0.00,0.00,614519),('5','91','213179','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614520),('5','91','213179','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614521),('5','91','213458','255',165.00,165.00,2729.38,0.00,0.00,0.00,0.00,615238),('5','91','213458','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615239),('5','91','213458','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615240),('5','91','213655','255',165.00,165.00,3587.40,0.00,0.00,0.00,0.00,615761),('5','91','213655','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615762),('5','91','213655','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615763),('5','91','213940','255',165.00,165.00,3101.79,0.00,0.00,0.00,0.00,616510),('5','91','213940','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616511),('5','91','213940','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616512),('5','91','214242','255',165.00,165.00,4183.66,0.00,0.00,0.00,0.00,617299),('5','91','214242','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617300),('5','91','214242','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617301),('5','91','214376','255',165.00,165.00,3540.44,0.00,0.00,0.00,0.00,617639),('5','91','214376','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617640),('5','91','214376','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617641),('5','91','214593','255',165.00,165.00,3100.58,0.00,0.00,0.00,0.00,618201),('5','91','214593','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618202),('5','91','214593','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618203),('5','91','214895','255',165.00,165.00,2897.53,0.00,0.00,0.00,0.00,618996),('5','91','214895','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618997),('5','91','214895','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618998),('5','91','215049','255',165.00,165.00,3357.99,0.00,0.00,0.00,0.00,619398),('5','91','215049','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619399),('5','91','215049','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619400),('5','91','215310','255',165.00,165.00,2477.46,0.00,0.00,0.00,0.00,620071),('5','91','215310','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620072),('5','91','215310','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620073),('5','91','215509','255',165.00,165.00,3019.57,0.00,0.00,0.00,0.00,620572),('5','91','215509','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,620573),('5','91','215509','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620574),('5','91','215701','255',165.00,165.00,4940.07,0.00,0.00,0.00,0.00,621065),('5','91','215701','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,621066),('5','91','215701','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621067),('5','91','215938','255',165.00,165.00,4441.80,0.00,0.00,0.00,0.00,621672),('5','91','215938','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,621673),('5','91','215938','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621674),('5','91','216158','255',165.00,165.00,6541.07,0.00,0.00,0.00,0.00,622246),('5','91','216158','256',295.00,295.00,2033.30,0.00,0.00,0.00,0.00,622247),('5','91','216158','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622248),('5','91','216353','255',165.00,165.00,3961.97,0.00,0.00,0.00,0.00,622748),('5','91','216353','256',295.00,295.00,629.81,0.00,0.00,0.00,0.00,622749),('5','91','216353','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622750),('5','91','216577','255',165.00,165.00,3559.39,0.00,0.00,0.00,0.00,623344),('5','91','216577','256',295.00,295.00,412.43,0.00,0.00,0.00,0.00,623345),('5','91','216577','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623346),('5','91','216814','255',165.00,165.00,2524.09,0.00,0.00,0.00,0.00,623971),('5','91','216814','256',295.00,295.00,474.53,0.00,0.00,0.00,0.00,623972),('5','91','216814','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623973),('5','91','217035','255',165.00,165.00,2786.00,0.00,0.00,0.00,0.00,624546),('5','91','217035','256',295.00,295.00,174.51,0.00,0.00,0.00,0.00,624547),('5','91','217035','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624548),('5','91','217311','255',165.00,165.00,4138.64,0.00,0.00,0.00,0.00,625270),('5','91','217311','256',295.00,295.00,1014.54,0.00,0.00,0.00,0.00,625271),('5','91','217311','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625272),('5','91','217658','255',165.00,165.00,4226.21,0.00,0.00,0.00,0.00,626195),('5','91','217658','256',295.00,295.00,581.44,0.00,0.00,0.00,0.00,626196),('5','91','217658','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626197),('5','91','217751','255',165.00,165.00,3174.19,0.00,0.00,0.00,0.00,626418),('5','91','217751','256',295.00,295.00,229.14,0.00,0.00,0.00,0.00,626419),('5','91','217751','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626420),('5','91','217982','255',165.00,165.00,3291.13,0.00,0.00,0.00,0.00,627039),('5','91','217982','256',295.00,295.00,355.07,0.00,0.00,0.00,0.00,627040),('5','91','217982','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627041),('5','91','218227','255',165.00,165.00,3004.10,0.00,0.00,0.00,0.00,627681),('5','91','218227','256',295.00,295.00,249.75,0.00,0.00,0.00,0.00,627682),('5','91','218227','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627683),('5','91','218462','255',165.00,165.00,2551.50,0.00,0.00,0.00,0.00,628289),('5','91','218462','256',295.00,295.00,518.98,0.00,0.00,0.00,0.00,628290),('5','91','218462','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628291),('5','91','218678','255',165.00,165.00,2834.01,0.00,0.00,0.00,0.00,628861),('5','91','218678','256',295.00,295.00,84.63,0.00,0.00,0.00,0.00,628862),('5','91','218678','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628863),('5','91','218909','255',165.00,165.00,4553.85,0.00,0.00,0.00,0.00,629462),('5','91','218909','256',295.00,295.00,1003.52,0.00,0.00,0.00,0.00,629463),('5','91','218909','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629464),('5','91','219131','255',165.00,165.00,3400.01,0.00,0.00,0.00,0.00,630036),('5','91','219131','256',295.00,295.00,204.26,0.00,0.00,0.00,0.00,630037),('5','91','219131','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630038),('5','91','219331','255',165.00,165.00,302.00,0.00,0.00,0.00,0.00,630568),('5','91','219331','256',295.00,295.00,314.10,0.00,0.00,0.00,0.00,630569),('5','91','219331','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630570),('5','91','219593','255',165.00,165.00,3349.40,0.00,0.00,0.00,0.00,631253),('5','91','219593','256',295.00,295.00,283.07,0.00,0.00,0.00,0.00,631254),('5','91','219593','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631255),('5','91','219822','255',165.00,165.00,3443.07,0.00,0.00,0.00,0.00,631844),('5','91','219822','256',295.00,295.00,150.41,0.00,0.00,0.00,0.00,631845),('5','91','219822','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631846),('5','91','220023','255',165.00,165.00,2518.29,0.00,0.00,0.00,0.00,632405),('5','91','220023','256',295.00,295.00,125.46,0.00,0.00,0.00,0.00,632406),('5','91','220023','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632407),('5','91','220246','255',165.00,165.00,2690.08,0.00,0.00,0.00,0.00,632977),('5','91','220246','256',295.00,295.00,228.86,0.00,0.00,0.00,0.00,632978),('5','91','220246','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632979),('5','91','220471','255',165.00,165.00,4516.56,0.00,0.00,0.00,0.00,633564),('5','91','220471','256',295.00,295.00,232.10,0.00,0.00,0.00,0.00,633565),('5','91','220471','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633566),('5','91','220875','255',165.00,165.00,3440.23,0.00,0.00,0.00,0.00,634627),('5','91','220875','256',295.00,295.00,300.20,0.00,0.00,0.00,0.00,634628),('5','91','220875','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634629),('5','91','220901','255',165.00,165.00,3950.48,0.00,0.00,0.00,0.00,634694),('5','91','220901','256',295.00,295.00,239.91,0.00,0.00,0.00,0.00,634695),('5','91','220901','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634696),('5','91','221158','255',165.00,165.00,3246.41,0.00,0.00,0.00,0.00,635340),('5','91','221158','256',295.00,295.00,1173.52,0.00,0.00,0.00,0.00,635341),('5','91','221158','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635342),('5','91','221410','255',165.00,165.00,3653.03,0.00,0.00,0.00,0.00,636004),('5','91','221410','256',295.00,295.00,387.19,0.00,0.00,0.00,0.00,636005),('5','91','221410','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636006),('5','91','221689','255',165.00,165.00,3069.70,0.00,0.00,0.00,0.00,636739),('5','91','221689','256',295.00,295.00,212.32,0.00,0.00,0.00,0.00,636740),('5','91','221689','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636741),('5','91','221925','255',165.00,165.00,3527.76,0.00,0.00,0.00,0.00,637349),('5','91','221925','256',295.00,295.00,311.59,0.00,0.00,0.00,0.00,637350),('5','91','221925','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637351),('5','91','222248','255',165.00,165.00,6075.13,0.00,0.00,0.00,0.00,638192),('5','91','222248','256',295.00,295.00,106.65,0.00,0.00,0.00,0.00,638193),('5','91','222248','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638194),('5','91','222351','255',165.00,165.00,4706.93,0.00,0.00,0.00,0.00,638451),('5','91','222351','256',295.00,295.00,62.08,0.00,0.00,0.00,0.00,638452),('5','91','222351','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638453),('5','91','222528','255',165.00,165.00,4477.97,0.00,0.00,0.00,0.00,638894),('5','91','222528','256',295.00,295.00,124.76,0.00,0.00,0.00,0.00,638895),('5','91','222528','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638896),('5','91','222802','255',165.00,165.00,2876.05,0.00,0.00,0.00,0.00,639626),('5','91','222802','256',295.00,295.00,90.97,0.00,0.00,0.00,0.00,639627),('5','91','222802','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639628),('5','91','223028','255',165.00,165.00,3293.64,0.00,0.00,0.00,0.00,640244),('5','91','223028','256',295.00,295.00,184.67,0.00,0.00,0.00,0.00,640245),('5','91','223028','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640246),('5','91','223198','255',165.00,165.00,3141.63,0.00,0.00,0.00,0.00,640659),('5','91','223198','256',295.00,295.00,955.71,0.00,0.00,0.00,0.00,640660),('5','91','223198','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640661),('5','91','223469','255',165.00,165.00,2958.26,0.00,0.00,0.00,0.00,641335),('5','91','223469','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,641336),('5','91','223469','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641337),('5','91','223677','255',165.00,165.00,5495.23,0.00,0.00,0.00,0.00,641862),('5','91','223677','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,641863),('5','91','223677','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641864),('5','91','223888','255',165.00,165.00,3729.88,0.00,0.00,0.00,0.00,642407),('5','91','223888','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,642408),('5','91','223888','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642409),('5','91','224116','255',165.00,165.00,4549.68,0.00,0.00,0.00,0.00,643000),('5','91','224116','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,643001),('5','91','224116','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643002),('5','91','224312','255',165.00,165.00,3045.64,0.00,0.00,0.00,0.00,643511),('5','91','224312','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,643512),('5','91','224312','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643513),('5','91','224603','255',165.00,165.00,3206.40,0.00,0.00,0.00,0.00,644277),('5','91','224603','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,644278),('5','91','224603','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644279),('5','91','224852','255',165.00,165.00,3355.55,0.00,0.00,0.00,0.00,644912),('5','91','224852','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,644913),('5','91','224852','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644914),('5','91','225059','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,645435),('5','91','225059','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,645436),('5','91','225059','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645437),('5','91','225369','255',163.00,163.00,3016.09,0.00,0.00,0.00,0.00,646243),('5','91','225369','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,646244),('5','91','225369','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646245),('5','91','225431','255',163.00,163.00,5744.34,0.00,0.00,0.00,0.00,646414),('5','91','225431','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,646415),('5','91','225431','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646416),('5','91','225517','255',163.00,163.00,4594.07,0.00,0.00,0.00,0.00,646619),('5','91','225517','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,646620),('5','91','225517','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646621),('5','91','225799','255',163.00,163.00,5776.28,0.00,0.00,0.00,0.00,647366),('5','91','225799','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647367),('5','91','225799','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647368),('5','91','226115','255',163.00,163.00,3717.94,0.00,0.00,0.00,0.00,648192),('5','91','226115','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,648193),('5','91','226115','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648194),('5','91','226327','255',163.00,163.00,4094.44,0.00,0.00,0.00,0.00,648738),('5','91','226327','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,648739),('5','91','226327','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648740),('5','91','226578','255',163.00,163.00,3484.75,0.00,0.00,0.00,0.00,649375),('5','91','226578','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649376),('5','91','226578','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649377),('5','91','226811','255',163.00,163.00,3710.18,0.00,0.00,0.00,0.00,649979),('5','91','226811','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649980),('5','91','226811','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649981),('5','91','227018','255',163.00,163.00,3116.98,0.00,0.00,0.00,0.00,650522),('5','91','227018','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650523),('5','91','227018','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650524),('5','91','227184','255',163.00,163.00,2255.89,0.00,0.00,0.00,0.00,650954),('5','91','227184','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650955),('5','91','227184','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650956),('5','91','227416','255',163.00,163.00,5898.00,0.00,0.00,0.00,0.00,651542),('5','91','227416','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651543),('5','91','227416','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651544),('5','91','227646','255',163.00,163.00,4458.45,0.00,0.00,0.00,0.00,652135),('5','91','227646','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652136),('5','91','227646','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652137),('5','91','227914','255',163.00,163.00,5366.99,0.00,0.00,0.00,0.00,652830),('5','91','227914','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,652831),('5','91','227914','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652832),('5','91','229505','255',163.00,163.00,5238.06,0.00,0.00,0.00,0.00,656946),('5','91','229505','256',295.00,295.00,0.00,0.00,0.00,0.00,0.00,656947),('5','91','229505','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656948),('5','91','231309','255',163.00,163.00,4196.78,0.00,0.00,0.00,0.00,661666),('5','91','231309','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,661667),('5','91','231309','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661668),('5','91','231315','255',163.00,163.00,6930.51,0.00,0.00,0.00,0.00,661683),('5','91','231315','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,661684),('5','91','231315','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661685),('5','91','231317','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661689),('5','91','231317','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,661690),('5','91','231317','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661691),('5','91','231421','255',163.00,163.00,4167.91,0.00,0.00,0.00,0.00,661939),('5','91','231421','256',300.00,300.00,0.00,0.00,0.00,0.00,0.00,661940),('5','91','231421','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661941),('5','91','231428','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661958),('5','91','231428','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,661959),('5','91','231428','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661960),('5','91','231438','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661988),('5','91','231438','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,661989),('5','91','231438','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661990),('5','91','231471','255',163.00,163.00,4075.91,0.00,0.00,0.00,0.00,662078),('5','91','231471','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662079),('5','91','231471','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662080),('5','91','231476','255',163.00,163.00,2216.65,0.00,0.00,0.00,0.00,662091),('5','91','231476','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662092),('5','91','231476','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662093),('5','91','231478','255',163.00,163.00,1510.02,0.00,0.00,0.00,0.00,662096),('5','91','231478','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662097),('5','91','231478','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662098),('5','91','231484','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662112),('5','91','231484','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662113),('5','91','231484','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662114),('5','91','231492','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662133),('5','91','231492','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662134),('5','91','231492','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662135),('5','91','231493','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662136),('5','91','231493','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662137),('5','91','231493','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662138),('5','91','231496','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662145),('5','91','231496','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662146),('5','91','231496','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662147),('5','91','231497','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662148),('5','91','231497','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662149),('5','91','231497','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662150),('5','91','231501','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662158),('5','91','231501','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662159),('5','91','231501','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662160),('5','91','231502','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662161),('5','91','231502','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662162),('5','91','231502','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662163),('5','91','231503','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662164),('5','91','231503','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662165),('5','91','231503','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662166),('5','91','231648','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,662533),('5','91','231648','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,662534),('5','91','231648','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662535),('5','91','231934','255',163.00,163.00,6421.06,0.00,0.00,0.00,0.00,663309),('5','91','231934','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,663310),('5','91','231934','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663311),('5','91','232197','255',163.00,163.00,4267.82,0.00,0.00,0.00,0.00,664008),('5','91','232197','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,664009),('5','91','232197','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664010),('5','91','232405','255',163.00,163.00,8467.16,0.00,0.00,0.00,0.00,664540),('5','91','232405','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,664541),('5','91','232405','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664542),('5','91','232698','255',163.00,163.00,4873.70,0.00,0.00,0.00,0.00,665318),('5','91','232698','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665319),('5','91','232698','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665320),('5','91','232859','255',163.00,163.00,5535.53,0.00,0.00,0.00,0.00,665747),('5','91','232859','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,665748),('5','91','232859','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665749),('5','91','233309','255',163.00,163.00,4180.98,0.00,0.00,0.00,0.00,666938),('5','91','233309','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,666939),('5','91','233309','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666940),('5','91','233428','255',163.00,163.00,4684.20,0.00,0.00,0.00,0.00,667228),('5','91','233428','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,667229),('5','91','233428','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667230),('5','91','233641','255',163.00,163.00,8104.03,0.00,0.00,0.00,0.00,667781),('5','91','233641','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,667782),('5','91','233641','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667783),('5','91','234004','255',163.00,163.00,4931.75,0.00,0.00,0.00,0.00,668765),('5','91','234004','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,668766),('5','91','234004','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668767),('5','91','234074','255',163.00,163.00,6260.74,0.00,0.00,0.00,0.00,668931),('5','91','234074','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,668932),('5','91','234074','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668933),('5','91','234367','255',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669706),('5','91','234367','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,669707),('5','91','234367','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669708),('5','91','234648','255',165.00,165.00,4712.48,0.00,0.00,0.00,0.00,670452),('5','91','234648','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,670453),('5','91','234648','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670454),('5','91','234732','255',165.00,165.00,5588.02,0.00,0.00,0.00,0.00,670680),('5','91','234732','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,670681),('5','91','234732','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670682),('5','91','234901','255',165.00,165.00,4978.84,0.00,0.00,0.00,0.00,671126),('5','91','234901','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,671127),('5','91','234901','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671128),('5','91','235129','255',165.00,165.00,5818.42,0.00,0.00,0.00,0.00,671738),('5','91','235129','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,671739),('5','91','235129','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671740),('5','91','235449','255',165.00,165.00,7421.56,0.00,0.00,0.00,0.00,672578),('5','91','235449','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,672579),('5','91','235449','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672580),('5','91','235609','255',165.00,165.00,7019.53,0.00,0.00,0.00,0.00,672975),('5','91','235609','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,672976),('5','91','235609','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,672977),('5','91','235896','255',165.00,165.00,7926.92,0.00,0.00,0.00,0.00,673728),('5','91','235896','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,673729),('5','91','235896','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,673730),('5','91','236096','255',165.00,165.00,4764.56,0.00,0.00,0.00,0.00,674252),('5','91','236096','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,674253),('5','91','236096','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,674254),('5','91','236458','255',165.00,165.00,3351.82,0.00,0.00,0.00,0.00,675226),('5','91','236458','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,675227),('5','91','236458','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675228),('5','91','236693','255',165.00,165.00,3390.00,0.00,0.00,0.00,0.00,675838),('5','91','236693','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,675839),('5','91','236693','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675840),('5','91','236814','255',165.00,165.00,429.26,0.00,0.00,0.00,0.00,676130),('5','91','236814','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,676131),('5','91','236814','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676132),('5','91','237127','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,676952),('5','91','237127','256',300.00,295.00,0.00,0.00,0.00,0.00,0.00,676953),('5','91','237127','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676954),('5','91','237253','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,677260),('5','91','237253','256',300.00,345.00,135.69,0.00,0.00,0.00,0.00,677261),('5','91','237253','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677262),('5','91','237494','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,677891),('5','91','237494','256',345.00,345.00,162.57,0.00,0.00,0.00,0.00,677892),('5','91','237494','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677893),('5','91','237689','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678391),('5','91','237689','256',345.00,345.00,355.01,0.00,0.00,0.00,0.00,678392),('5','91','237689','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678393),('5','91','238065','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679385),('5','91','238065','256',345.00,345.00,405.20,0.00,0.00,0.00,0.00,679386),('5','91','238065','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679387),('5','91','238182','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679667),('5','91','238182','256',345.00,345.00,823.26,0.00,0.00,0.00,0.00,679668),('5','91','238182','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679669),('5','91','238573','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680709),('5','91','238573','256',345.00,345.00,260.01,0.00,0.00,0.00,0.00,680710),('5','91','238573','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680711),('5','91','238701','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,681023),('5','91','238701','256',345.00,345.00,709.96,0.00,0.00,0.00,0.00,681024),('5','91','238701','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681025),('5','91','238884','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,681491),('5','91','238884','256',345.00,345.00,863.36,0.00,0.00,0.00,0.00,681492),('5','91','238884','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681493),('5','91','239244','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,682444),('5','91','239244','256',345.00,345.00,1420.87,0.00,0.00,0.00,0.00,682445),('5','91','239244','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682446),('5','91','239479','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683054),('5','91','239479','256',345.00,345.00,1267.76,0.00,0.00,0.00,0.00,683055),('5','91','239479','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683056),('5','91','239699','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,683620),('5','91','239699','256',345.00,345.00,556.61,0.00,0.00,0.00,0.00,683621),('5','91','239699','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683622),('5','91','239943','255',165.00,165.00,8844.86,0.00,0.00,0.00,0.00,684263),('5','91','239943','256',345.00,345.00,585.31,0.00,0.00,0.00,0.00,684264),('5','91','239943','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684265),('5','91','240158','255',165.00,165.00,5572.21,0.00,0.00,0.00,0.00,684821),('5','91','240158','256',345.00,345.00,801.04,0.00,0.00,0.00,0.00,684822),('5','91','240158','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684823),('5','91','240387','255',165.00,165.00,9732.86,0.00,0.00,0.00,0.00,685409),('5','91','240387','256',345.00,345.00,800.99,0.00,0.00,0.00,0.00,685410),('5','91','240387','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685411),('5','91','240595','255',165.00,165.00,7226.63,0.00,0.00,0.00,0.00,685949),('5','91','240595','256',345.00,345.00,891.12,0.00,0.00,0.00,0.00,685950),('5','91','240595','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685951),('5','91','240778','255',165.00,165.00,8836.65,0.00,0.00,0.00,0.00,686371),('5','91','240778','256',345.00,345.00,1249.55,0.00,0.00,0.00,0.00,686372),('5','91','240778','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686373),('5','91','241191','255',165.00,165.00,3655.11,0.00,0.00,0.00,0.00,687495),('5','91','241191','256',345.00,345.00,1319.92,0.00,0.00,0.00,0.00,687496),('5','91','241191','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687497),('5','91','241431','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688127),('5','91','241431','256',345.00,345.00,314.16,0.00,0.00,0.00,0.00,688128),('5','91','241431','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688129),('5','91','241592','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688535),('5','91','241592','256',345.00,345.00,282.09,0.00,0.00,0.00,0.00,688536),('5','91','241592','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688537),('5','91','241919','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689408),('5','91','241919','256',345.00,345.00,290.08,0.00,0.00,0.00,0.00,689409),('5','91','241919','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689410),('5','91','242149','255',165.00,165.00,3603.25,0.00,0.00,0.00,0.00,690001),('5','91','242149','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690002),('5','91','242149','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690003),('5','91','242362','255',165.00,165.00,16429.06,0.00,0.00,0.00,0.00,690555),('5','91','242362','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690556),('5','91','242362','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690557),('5','91','242493','255',165.00,165.00,19512.87,0.00,0.00,0.00,0.00,690872),('5','91','242493','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690873),('5','91','242493','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690874),('5','91','242833','255',165.00,165.00,8997.44,0.00,0.00,0.00,0.00,691778),('5','91','242833','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691779),('5','91','242833','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691780),('5','91','242990','255',165.00,165.00,4496.95,0.00,0.00,0.00,0.00,692171),('5','91','242990','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692172),('5','91','242990','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692173),('5','91','243232','255',165.00,165.00,4485.38,0.00,0.00,0.00,0.00,692805),('5','91','243232','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692806),('5','91','243232','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692807),('5','91','243457','255',165.00,165.00,2630.74,0.00,0.00,0.00,0.00,693395),('5','91','243457','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693396),('5','91','243457','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693397),('5','91','243767','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694208),('5','91','243767','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694209),('5','91','243767','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694210),('5','91','244029','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694892),('5','91','244029','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694893),('5','91','244029','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694894),('5','91','244225','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695399),('5','91','244225','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695400),('5','91','244225','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695401),('5','91','244463','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696014),('5','91','244463','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696015),('5','91','244463','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696016),('5','91','244617','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696400),('5','91','244617','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696401),('5','91','244617','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696402),('5','91','244923','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697216),('5','91','244923','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697217),('5','91','244923','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697218),('5','91','245162','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697831),('5','91','245162','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697832),('5','91','245162','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697833),('5','91','245381','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,698391),('5','91','245381','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698392),('5','91','245381','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698393),('5','91','245525','255',165.00,165.00,6380.43,0.00,0.00,0.00,0.00,698748),('5','91','245525','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,698749),('5','91','245525','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,698750),('5','91','245764','255',165.00,165.00,10375.26,0.00,0.00,0.00,0.00,699364),('5','91','245764','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699365),('5','91','245764','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699366),('5','91','246047','255',165.00,165.00,5858.72,0.00,0.00,0.00,0.00,700113),('5','91','246047','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700114),('5','91','246047','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700115),('5','91','246304','255',165.00,165.00,5327.69,0.00,0.00,0.00,0.00,700779),('5','91','246304','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,700780),('5','91','246304','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,700781),('5','91','246564','255',165.00,165.00,8229.92,0.00,0.00,0.00,0.00,701465),('5','91','246564','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701466),('5','91','246564','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701467),('5','91','246795','255',165.00,165.00,5573.85,0.00,0.00,0.00,0.00,702057),('5','91','246795','256',345.00,345.00,1228.80,0.00,0.00,0.00,0.00,702058),('5','91','246795','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702059),('5','91','247103','255',165.00,165.00,8560.72,0.00,0.00,0.00,0.00,702867),('5','91','247103','256',345.00,345.00,164.02,0.00,0.00,0.00,0.00,702868),('5','91','247103','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702869),('5','91','247233','255',165.00,165.00,9210.95,0.00,0.00,0.00,0.00,703191),('5','91','247233','256',345.00,345.00,167.56,0.00,0.00,0.00,0.00,703192),('5','91','247233','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703193),('5','91','247436','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703699),('5','91','247436','256',345.00,345.00,700.20,0.00,0.00,0.00,0.00,703700),('5','91','247436','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703701),('5','91','247868','255',165.00,165.00,4034.77,0.00,0.00,0.00,0.00,704845),('5','91','247868','256',345.00,345.00,286.52,0.00,0.00,0.00,0.00,704846),('5','91','247868','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704847),('5','91','247960','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705055),('5','91','247960','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705056),('5','91','247960','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705057),('5','91','248104','255',165.00,165.00,6773.25,0.00,0.00,0.00,0.00,705458),('5','91','248104','256',345.00,345.00,442.93,0.00,0.00,0.00,0.00,705459),('5','91','248104','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705460),('5','91','248235','255',165.00,165.00,12195.88,0.00,0.00,0.00,0.00,705774),('5','91','248235','256',345.00,345.00,638.91,0.00,0.00,0.00,0.00,705775),('5','91','248235','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705776),('5','91','248455','255',165.00,165.00,6487.15,0.00,0.00,0.00,0.00,706340),('5','91','248455','256',345.00,345.00,456.61,0.00,0.00,0.00,0.00,706341),('5','91','248455','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706342),('5','91','248805','255',165.00,165.00,7246.60,0.00,0.00,0.00,0.00,707254),('5','91','248805','256',345.00,345.00,215.91,0.00,0.00,0.00,0.00,707255),('5','91','248805','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707256),('5','91','248911','255',165.00,165.00,7250.67,0.00,0.00,0.00,0.00,707514),('5','91','248911','256',345.00,345.00,159.69,0.00,0.00,0.00,0.00,707515),('5','91','248911','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707516),('5','91','249173','255',165.00,165.00,1026.25,0.00,0.00,0.00,0.00,708175),('5','91','249173','256',345.00,345.00,422.79,0.00,0.00,0.00,0.00,708176),('5','91','249173','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708177),('5','91','249439','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708863),('5','91','249439','256',345.00,345.00,320.02,0.00,0.00,0.00,0.00,708864),('5','91','249439','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708865),('5','91','249682','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709488),('5','91','249682','256',345.00,345.00,255.80,0.00,0.00,0.00,0.00,709489),('5','91','249682','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709490),('5','91','249935','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710138),('5','91','249935','256',345.00,345.00,1056.29,0.00,0.00,0.00,0.00,710139),('5','91','249935','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710140),('5','91','250156','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710697),('5','91','250156','256',345.00,345.00,450.03,0.00,0.00,0.00,0.00,710698),('5','91','250156','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710699),('5','91','250380','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711263),('5','91','250380','256',345.00,345.00,600.52,0.00,0.00,0.00,0.00,711264),('5','91','250380','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711265),('5','91','250634','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,711915),('5','91','250634','256',345.00,345.00,555.07,0.00,0.00,0.00,0.00,711916),('5','91','250634','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711917),('5','91','250977','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,712830),('5','91','250977','256',345.00,345.00,802.01,0.00,0.00,0.00,0.00,712831),('5','91','250977','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712832),('5','91','251117','255',165.00,165.00,19586.49,0.00,0.00,0.00,0.00,713168),('5','91','251117','256',345.00,345.00,744.74,0.00,0.00,0.00,0.00,713169),('5','91','251117','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713170),('5','91','251434','255',165.00,165.00,9372.93,0.00,0.00,0.00,0.00,714011),('5','91','251434','256',345.00,345.00,184.94,0.00,0.00,0.00,0.00,714012),('5','91','251434','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714013),('5','91','251612','255',165.00,165.00,13895.50,0.00,0.00,0.00,0.00,714466),('5','91','251612','256',345.00,345.00,323.85,0.00,0.00,0.00,0.00,714467),('5','91','251612','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714468),('5','91','251936','255',165.00,165.00,7977.08,0.00,0.00,0.00,0.00,715333),('5','91','251936','256',345.00,345.00,159.42,0.00,0.00,0.00,0.00,715334),('5','91','251936','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715335),('5','91','252097','255',165.00,165.00,11526.92,0.00,0.00,0.00,0.00,715732),('5','91','252097','256',345.00,345.00,140.01,0.00,0.00,0.00,0.00,715733),('5','91','252097','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715734),('5','91','252323','255',165.00,165.00,7891.27,0.00,0.00,0.00,0.00,716326),('5','91','252323','256',345.00,345.00,158.69,0.00,0.00,0.00,0.00,716327),('5','91','252323','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716328),('5','91','252571','255',165.00,165.00,7537.96,0.00,0.00,0.00,0.00,716966),('5','91','252571','256',345.00,345.00,89.46,0.00,0.00,0.00,0.00,716967),('5','91','252571','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716968),('5','91','252809','255',165.00,165.00,964.50,0.00,0.00,0.00,0.00,717580),('5','91','252809','256',345.00,345.00,200.01,0.00,0.00,0.00,0.00,717581),('5','91','252809','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717582),('5','91','253068','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718255),('5','91','253068','256',345.00,345.00,283.08,0.00,0.00,0.00,0.00,718256),('5','91','253068','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718257),('5','91','253332','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718956),('5','91','253332','256',345.00,345.00,255.79,0.00,0.00,0.00,0.00,718957),('5','91','253332','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718958),('5','91','253561','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719541),('5','91','253561','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719542),('5','91','253561','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719543),('5','91','253762','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720054),('5','91','253762','256',345.00,345.00,296.06,0.00,0.00,0.00,0.00,720055),('5','91','253762','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720056),('5','91','253834','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720253),('5','91','253834','256',345.00,345.00,264.45,0.00,0.00,0.00,0.00,720254),('5','91','253834','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720255),('5','91','254021','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720732),('5','91','254021','256',345.00,345.00,288.78,0.00,0.00,0.00,0.00,720733),('5','91','254021','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720734),('5','91','254307','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721482),('5','91','254307','256',345.00,345.00,180.04,0.00,0.00,0.00,0.00,721483),('5','91','254307','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721484),('5','91','254551','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722103),('5','91','254551','256',345.00,345.00,144.44,0.00,0.00,0.00,0.00,722104),('5','91','254551','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722105),('5','91','254927','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723082),('5','91','254927','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723083),('5','91','254927','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723084),('5','91','255051','255',165.00,165.00,7810.40,0.00,0.00,0.00,0.00,723375),('5','91','255051','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723376),('5','91','255051','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723377),('5','91','255246','255',165.00,165.00,5824.16,0.00,0.00,0.00,0.00,723865),('5','91','255246','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723866),('5','91','255246','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723867),('5','91','255547','255',165.00,165.00,5747.21,0.00,0.00,0.00,0.00,724603),('5','91','255547','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724604),('5','91','255547','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724605),('5','91','255817','255',165.00,165.00,6618.40,0.00,0.00,0.00,0.00,725295),('5','91','255817','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725296),('5','91','255817','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725297),('5','91','256038','255',165.00,165.00,4897.25,0.00,0.00,0.00,0.00,725861),('5','91','256038','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725862),('5','91','256038','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725863),('5','91','256310','255',165.00,165.00,4134.27,0.00,0.00,0.00,0.00,726528),('5','91','256310','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726529),('5','91','256310','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726530),('5','91','256678','255',165.00,165.00,3194.48,0.00,0.00,0.00,0.00,727505),('5','91','256678','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727506),('5','91','256678','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727507),('5','91','256820','255',165.00,165.00,3335.73,0.00,0.00,0.00,0.00,727857),('5','91','256820','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727858),('5','91','256820','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727859),('5','91','257149','255',165.00,165.00,2048.98,0.00,0.00,0.00,0.00,728732),('5','91','257149','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728733),('5','91','257149','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728734),('5','91','257438','255',165.00,165.00,1200.00,0.00,0.00,0.00,0.00,729492),('5','91','257438','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729493),('5','91','257438','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729494),('5','91','257439','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729495),('5','91','257439','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729496),('5','91','257439','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729497),('5','91','257440','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729498),('5','91','257440','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729499),('5','91','257440','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729500),('5','91','257441','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729501),('5','91','257441','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729502),('5','91','257441','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729503),('5','91','257442','256',345.00,360.00,0.00,0.00,0.00,0.00,0.00,729504),('5','91','257442','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729505),('5','91','257442','255',165.00,165.00,804.97,0.00,0.00,0.00,0.00,729506),('5','91','257443','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729507),('5','91','257443','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729508),('5','91','257443','255',165.00,165.00,6033.34,0.00,0.00,0.00,0.00,729509),('5','91','257444','256',345.00,365.00,0.00,0.00,0.00,0.00,0.00,729510),('5','91','257444','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729511),('5','91','257444','255',165.00,165.00,5763.24,0.00,0.00,0.00,0.00,729512),('5','91','257445','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729513),('5','91','257445','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729514),('5','91','257445','255',165.00,165.00,5309.74,0.00,0.00,0.00,0.00,729515),('5','91','257446','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729516),('5','91','257446','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729517),('5','91','257446','255',165.00,165.00,5263.91,0.00,0.00,0.00,0.00,729518),('5','91','257447','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729519),('5','91','257447','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729520),('5','91','257447','255',165.00,165.00,6675.17,0.00,0.00,0.00,0.00,729521),('5','91','257448','255',165.00,165.00,7034.05,0.00,0.00,0.00,0.00,729522),('5','91','257448','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729523),('5','91','257448','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729524),('5','91','257449','255',165.00,165.00,12684.83,0.00,0.00,0.00,0.00,729525),('5','91','257449','256',345.00,415.00,0.00,0.00,0.00,0.00,0.00,729526),('5','91','257449','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729527),('5','91','257450','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729528),('5','91','257450','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729529),('5','91','257450','255',165.00,165.00,9704.41,0.00,0.00,0.00,0.00,729530),('5','91','257451','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729531),('5','91','257451','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729532),('5','91','257451','255',165.00,165.00,7261.46,0.00,0.00,0.00,0.00,729533),('5','91','257452','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729534),('5','91','257452','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729535),('5','91','257452','255',165.00,165.00,8309.51,0.00,0.00,0.00,0.00,729536),('5','91','257453','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729537),('5','91','257453','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729538),('5','91','257453','255',165.00,165.00,8398.02,0.00,0.00,0.00,0.00,729539),('5','91','257454','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729540),('5','91','257454','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729541),('5','91','257454','255',165.00,165.00,9547.42,0.00,0.00,0.00,0.00,729542),('5','91','257455','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729543),('5','91','257455','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729544),('5','91','257455','255',165.00,165.00,20136.20,0.00,0.00,0.00,0.00,729545),('5','91','257456','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729546),('5','91','257456','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729547),('5','91','257456','255',165.00,165.00,5636.06,0.00,0.00,0.00,0.00,729548),('5','91','257457','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729549),('5','91','257457','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729550),('5','91','257457','255',165.00,165.00,1002.02,0.00,0.00,0.00,0.00,729551),('5','91','257458','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729552),('5','91','257458','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729553),('5','91','257458','255',165.00,165.00,6741.53,0.00,0.00,0.00,0.00,729554),('5','91','257459','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729555),('5','91','257459','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729556),('5','91','257459','255',165.00,165.00,8835.19,0.00,0.00,0.00,0.00,729557),('5','91','257460','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729558),('5','91','257460','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729559),('5','91','257460','255',165.00,165.00,7109.05,0.00,0.00,0.00,0.00,729560),('5','91','257461','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729561),('5','91','257461','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729562),('5','91','257461','255',165.00,165.00,6671.58,0.00,0.00,0.00,0.00,729563),('5','91','257462','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729564),('5','91','257462','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729565),('5','91','257462','255',165.00,165.00,15992.20,0.00,0.00,0.00,0.00,729566),('5','91','257463','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729567),('5','91','257463','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729568),('5','91','257463','255',165.00,165.00,6056.67,0.00,0.00,0.00,0.00,729569),('5','91','257464','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729570),('5','91','257464','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729571),('5','91','257464','255',165.00,165.00,6690.07,0.00,0.00,0.00,0.00,729572),('5','91','257465','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729573),('5','91','257465','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729574),('5','91','257465','255',165.00,165.00,8308.42,0.00,0.00,0.00,0.00,729575),('5','91','257466','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729576),('5','91','257466','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729577),('5','91','257466','255',165.00,165.00,15906.82,0.00,0.00,0.00,0.00,729578),('5','91','257467','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729579),('5','91','257467','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729580),('5','91','257467','255',165.00,165.00,18887.52,0.00,0.00,0.00,0.00,729581),('5','91','257468','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729582),('5','91','257468','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729583),('5','91','257468','255',165.00,165.00,9381.04,0.00,0.00,0.00,0.00,729584),('5','91','257469','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729585),('5','91','257469','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729586),('5','91','257469','255',165.00,165.00,1957.25,0.00,0.00,0.00,0.00,729587),('5','91','257470','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729588),('5','91','257470','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729589),('5','91','257470','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729590),('5','91','257471','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729591),('5','91','257471','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729592),('5','91','257471','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729593),('5','91','257472','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729594),('5','91','257472','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729595),('5','91','257472','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729596),('5','91','257473','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729597),('5','91','257473','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729598),('5','91','257473','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729599),('5','91','257474','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729600),('5','91','257474','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729601),('5','91','257474','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729602),('5','91','257475','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729603),('5','91','257475','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729604),('5','91','257475','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729605),('5','91','257476','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729606),('5','91','257476','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729607),('5','91','257476','255',165.00,165.00,1143.01,0.00,0.00,0.00,0.00,729608),('5','91','257477','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729609),('5','91','257477','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729610),('5','91','257477','255',165.00,165.00,5164.31,0.00,0.00,0.00,0.00,729611),('5','91','257478','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729612),('5','91','257478','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729613),('5','91','257478','255',165.00,165.00,6008.43,0.00,0.00,0.00,0.00,729614),('5','91','257479','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729615),('5','91','257479','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729616),('5','91','257479','255',165.00,165.00,6756.46,0.00,0.00,0.00,0.00,729617),('5','91','257480','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729618),('5','91','257480','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729619),('5','91','257480','255',165.00,165.00,7664.19,0.00,0.00,0.00,0.00,729620),('5','91','257481','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729621),('5','91','257481','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729622),('5','91','257481','255',165.00,165.00,8145.23,0.00,0.00,0.00,0.00,729623),('5','91','257482','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729624),('5','91','257482','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729625),('5','91','257482','255',165.00,165.00,7837.78,0.00,0.00,0.00,0.00,729626),('5','91','257483','255',165.00,165.00,8088.68,0.00,0.00,0.00,0.00,729627),('5','91','257483','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729628),('5','91','257483','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729629),('5','91','257484','255',165.00,165.00,9333.05,0.00,0.00,0.00,0.00,729630),('5','91','257484','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729631),('5','91','257484','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729632),('5','91','257485','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729633),('5','91','257485','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729634),('5','91','257485','255',165.00,165.00,5187.76,0.00,0.00,0.00,0.00,729635),('5','91','257486','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729636),('5','91','257486','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729637),('5','91','257486','255',165.00,165.00,5467.76,0.00,0.00,0.00,0.00,729638),('5','91','257487','255',165.00,165.00,4033.10,0.00,0.00,0.00,0.00,729639),('5','91','257487','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729640),('5','91','257487','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729641),('5','91','257488','255',165.00,165.00,4004.44,0.00,0.00,0.00,0.00,729642),('5','91','257488','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729643),('5','91','257488','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729644),('5','91','257489','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729645),('5','91','257489','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729646),('5','91','257489','255',165.00,165.00,3861.87,0.00,0.00,0.00,0.00,729647),('5','91','257490','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729648),('5','91','257490','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729649),('5','91','257490','255',165.00,165.00,2256.76,0.00,0.00,0.00,0.00,729650),('5','91','257491','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729651),('5','91','257491','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729652),('5','91','257491','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729653),('5','91','257492','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729654),('5','91','257492','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729655),('5','91','257492','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729656),('5','91','257493','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729657),('5','91','257493','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729658),('5','91','257493','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729659),('5','91','257494','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729660),('5','91','257494','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729661),('5','91','257494','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729662),('5','91','257495','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729663),('5','91','257495','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729664),('5','91','257495','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729665),('5','91','257496','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729666),('5','91','257496','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729667),('5','91','257496','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729668),('5','91','257497','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729669),('5','91','257497','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729670),('5','91','257497','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729671),('5','91','257498','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729672),('5','91','257498','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729673),('5','91','257498','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729674),('5','91','257499','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729675),('5','91','257499','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729676),('5','91','257499','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729677),('5','91','257500','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729678),('5','91','257500','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729679),('5','91','257500','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729680),('5','91','257501','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729681),('5','91','257501','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729682),('5','91','257501','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729683),('5','91','257502','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729684),('5','91','257502','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729685),('5','91','257502','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729686),('5','91','257503','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729687),('5','91','257503','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729688),('5','91','257503','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729689),('5','91','257504','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729690),('5','91','257504','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729691),('5','91','257504','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729692),('5','91','257505','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729693),('5','91','257505','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729694),('5','91','257505','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729695),('5','91','257506','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729696),('5','91','257506','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729697),('5','91','257506','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729698),('5','91','257507','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729699),('5','91','257507','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729700),('5','91','257507','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729701),('5','91','257508','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729702),('5','91','257508','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729703),('5','91','257508','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729704),('5','91','257509','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729705),('5','91','257509','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729706),('5','91','257509','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729707),('5','91','257510','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729708),('5','91','257510','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729709),('5','91','257510','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729710),('5','91','257511','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729711),('5','91','257511','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729712),('5','91','257511','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729713),('5','91','257512','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729714),('5','91','257512','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729715),('5','91','257512','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729716),('5','91','257513','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729717),('5','91','257513','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729718),('5','91','257513','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729719),('5','91','257514','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729720),('5','91','257514','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729721),('5','91','257514','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729722),('5','91','257515','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729723),('5','91','257515','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729724),('5','91','257515','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729725),('5','91','257516','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729726),('5','91','257516','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729727),('5','91','257516','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729728),('5','91','257517','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729729),('5','91','257517','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729730),('5','91','257517','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729731),('5','91','257518','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729732),('5','91','257518','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729733),('5','91','257518','255',165.00,165.00,625.03,0.00,0.00,0.00,0.00,729734),('5','91','257519','255',165.00,165.00,4721.01,0.00,0.00,0.00,0.00,729735),('5','91','257519','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729736),('5','91','257519','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729737),('5','91','257520','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729738),('5','91','257520','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729739),('5','91','257520','255',165.00,165.00,5386.93,0.00,0.00,0.00,0.00,729740),('5','91','257521','255',165.00,165.00,5464.02,0.00,0.00,0.00,0.00,729741),('5','91','257521','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729742),('5','91','257521','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729743),('5','91','257522','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729744),('5','91','257522','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729745),('5','91','257522','255',165.00,165.00,5444.80,0.00,0.00,0.00,0.00,729746),('5','91','257523','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729747),('5','91','257523','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729748),('5','91','257523','255',165.00,165.00,5860.95,0.00,0.00,0.00,0.00,729749),('5','91','257524','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729750),('5','91','257524','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729751),('5','91','257524','255',165.00,165.00,4036.91,0.00,0.00,0.00,0.00,729752),('5','91','257525','255',165.00,165.00,4146.92,0.00,0.00,0.00,0.00,729753),('5','91','257525','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729754),('5','91','257525','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729755),('5','91','257526','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729756),('5','91','257526','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729757),('5','91','257526','255',165.00,165.00,5468.39,0.00,0.00,0.00,0.00,729758),('5','91','257527','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729759),('5','91','257527','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729760),('5','91','257527','255',165.00,165.00,4007.78,0.00,0.00,0.00,0.00,729761),('5','91','257528','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729762),('5','91','257528','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729763),('5','91','257528','255',165.00,165.00,3796.80,0.00,0.00,0.00,0.00,729764),('5','91','257529','255',165.00,165.00,1055.39,0.00,0.00,0.00,0.00,729765),('5','91','257529','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729766),('5','91','257529','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729767),('5','91','257530','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729768),('5','91','257530','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729769),('5','91','257530','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729770),('5','91','257531','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729771),('5','91','257531','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729772),('5','91','257531','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729773),('5','91','257532','255',165.00,165.00,900.03,0.00,0.00,0.00,0.00,729774),('5','91','257532','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729775),('5','91','257532','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729776),('5','91','257533','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729777),('5','91','257533','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729778),('5','91','257533','255',165.00,165.00,4808.86,0.00,0.00,0.00,0.00,729779),('5','91','257534','255',165.00,165.00,4285.04,0.00,0.00,0.00,0.00,729780),('5','91','257534','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729781),('5','91','257534','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729782),('5','91','257535','255',165.00,165.00,4932.31,0.00,0.00,0.00,0.00,729783),('5','91','257535','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729784),('5','91','257535','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729785),('5','91','257536','255',165.00,165.00,4698.44,0.00,0.00,0.00,0.00,729786),('5','91','257536','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729787),('5','91','257536','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729788),('5','91','257537','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729789),('5','91','257537','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729790),('5','91','257537','255',165.00,165.00,5021.07,0.00,0.00,0.00,0.00,729791),('5','91','257538','255',165.00,165.00,5331.96,0.00,0.00,0.00,0.00,729792),('5','91','257538','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729793),('5','91','257538','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729794),('5','91','257539','255',165.00,165.00,5296.78,0.00,0.00,0.00,0.00,729795),('5','91','257539','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729796),('5','91','257539','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729797),('5','91','257540','255',165.00,165.00,4841.56,0.00,0.00,0.00,0.00,729798),('5','91','257540','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729799),('5','91','257540','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729800),('5','91','257541','255',165.00,165.00,5260.42,0.00,0.00,0.00,0.00,729801),('5','91','257541','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729802),('5','91','257541','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729803),('5','91','257542','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729804),('5','91','257542','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729805),('5','91','257542','255',165.00,165.00,5522.08,0.00,0.00,0.00,0.00,729806),('5','91','257543','255',165.00,165.00,5795.92,0.00,0.00,0.00,0.00,729807),('5','91','257543','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729808),('5','91','257543','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729809),('5','91','257544','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729810),('5','91','257544','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729811),('5','91','257544','255',165.00,165.00,5059.09,0.00,0.00,0.00,0.00,729812),('5','91','257545','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729813),('5','91','257545','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729814),('5','91','257545','255',165.00,165.00,5600.25,0.00,0.00,0.00,0.00,729815),('5','91','257546','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729816),('5','91','257546','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729817),('5','91','257546','255',165.00,165.00,5363.33,0.00,0.00,0.00,0.00,729818),('5','91','257547','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729819),('5','91','257547','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729820),('5','91','257547','255',165.00,165.00,5028.80,0.00,0.00,0.00,0.00,729821),('5','91','257548','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729822),('5','91','257548','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729823),('5','91','257548','255',165.00,165.00,5138.33,0.00,0.00,0.00,0.00,729824),('5','91','257549','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729825),('5','91','257549','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729826),('5','91','257549','255',165.00,165.00,5173.33,0.00,0.00,0.00,0.00,729827),('5','91','257550','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729828),('5','91','257550','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729829),('5','91','257550','255',165.00,165.00,5229.84,0.00,0.00,0.00,0.00,729830),('5','91','257551','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729831),('5','91','257551','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729832),('5','91','257551','255',165.00,165.00,4907.98,0.00,0.00,0.00,0.00,729833),('5','91','257552','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729834),('5','91','257552','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729835),('5','91','257552','255',165.00,165.00,1835.65,0.00,0.00,0.00,0.00,729836),('5','91','257553','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729837),('5','91','257553','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729838),('5','91','257553','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729839),('5','91','257554','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729840),('5','91','257554','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729841),('5','91','257554','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729842),('5','91','257555','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729843),('5','91','257555','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729844),('5','91','257555','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729845),('5','91','257556','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729846),('5','91','257556','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729847),('5','91','257556','255',165.00,165.00,2125.50,0.00,0.00,0.00,0.00,729848),('5','91','257557','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729849),('5','91','257557','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729850),('5','91','257557','255',165.00,165.00,4844.54,0.00,0.00,0.00,0.00,729851),('5','91','257558','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729852),('5','91','257558','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729853),('5','91','257558','255',165.00,165.00,4730.69,0.00,0.00,0.00,0.00,729854),('5','91','257559','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729855),('5','91','257559','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729856),('5','91','257559','255',165.00,165.00,4663.11,0.00,0.00,0.00,0.00,729857),('5','91','257560','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729858),('5','91','257560','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729859),('5','91','257560','255',165.00,165.00,4403.06,0.00,0.00,0.00,0.00,729860),('5','91','257561','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729861),('5','91','257561','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729862),('5','91','257561','255',165.00,165.00,4419.80,0.00,0.00,0.00,0.00,729863),('5','91','257562','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729864),('5','91','257562','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729865),('5','91','257562','255',165.00,165.00,4450.70,0.00,0.00,0.00,0.00,729866),('5','91','257563','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729867),('5','91','257563','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729868),('5','91','257563','255',165.00,165.00,4115.62,0.00,0.00,0.00,0.00,729869),('5','91','257564','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729870),('5','91','257564','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729871),('5','91','257564','255',165.00,165.00,4133.41,0.00,0.00,0.00,0.00,729872),('5','91','257565','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729873),('5','91','257565','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729874),('5','91','257565','255',165.00,165.00,4601.91,0.00,0.00,0.00,0.00,729875),('5','91','257566','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729876),('5','91','257566','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729877),('5','91','257566','255',165.00,165.00,4615.86,0.00,0.00,0.00,0.00,729878),('5','91','257567','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729879),('5','91','257567','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729880),('5','91','257567','255',165.00,165.00,2955.01,0.00,0.00,0.00,0.00,729881),('5','91','257568','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729882),('5','91','257568','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729883),('5','91','257568','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729884),('5','91','257569','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729885),('5','91','257569','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729886),('5','91','257569','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729887),('5','91','257570','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729888),('5','91','257570','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729889),('5','91','257570','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729890),('5','91','257571','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729891),('5','91','257571','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729892),('5','91','257571','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729893),('5','91','257572','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729894),('5','91','257572','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729895),('5','91','257572','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729896),('5','91','257573','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729897),('5','91','257573','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729898),('5','91','257573','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729899),('5','91','257574','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729900),('5','91','257574','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729901),('5','91','257574','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729902),('5','91','257575','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729903),('5','91','257575','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729904),('5','91','257575','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729905),('5','91','257576','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729906),('5','91','257576','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729907),('5','91','257576','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729908),('5','91','257577','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729909),('5','91','257577','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729910),('5','91','257577','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729911),('5','91','257578','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729912),('5','91','257578','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729913),('5','91','257578','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729914),('5','91','257579','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729915),('5','91','257579','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729916),('5','91','257579','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729917),('5','91','257580','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729918),('5','91','257580','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729919),('5','91','257580','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729920),('5','91','257581','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729921),('5','91','257581','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729922),('5','91','257581','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729923),('5','91','257582','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729924),('5','91','257582','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729925),('5','91','257582','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729926),('5','91','257583','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729927),('5','91','257583','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729928),('5','91','257583','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729929),('5','91','257584','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729930),('5','91','257584','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729931),('5','91','257584','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729932),('5','91','257585','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729933),('5','91','257585','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729934),('5','91','257585','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729935),('5','91','257586','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729936),('5','91','257586','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729937),('5','91','257586','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729938),('5','91','257587','256',345.00,820.00,0.00,0.00,0.00,0.00,0.00,729939),('5','91','257587','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729940),('5','91','257587','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729941),('5','91','257588','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729942),('5','91','257588','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729943),('5','91','257588','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729944),('5','91','257589','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729945),('5','91','257589','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729946),('5','91','257589','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729947),('5','91','257590','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729948),('5','91','257590','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729949),('5','91','257590','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729950),('5','91','257591','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729951),('5','91','257591','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729952),('5','91','257591','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729953),('5','91','257592','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729954),('5','91','257592','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729955),('5','91','257592','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729956),('5','91','257593','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729957),('5','91','257593','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729958),('5','91','257593','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729959),('5','91','257594','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729960),('5','91','257594','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729961),('5','91','257594','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729962),('5','91','257595','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729963),('5','91','257595','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729964),('5','91','257595','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729965),('5','91','257596','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729966),('5','91','257596','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729967),('5','91','257596','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729968),('5','91','257597','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729969),('5','91','257597','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729970),('5','91','257597','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729971),('5','91','257598','255',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729972),('5','91','257598','256',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729973),('5','91','257598','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729974),('5','91','257599','256',345.00,800.00,0.00,0.00,0.00,0.00,0.00,729975),('5','91','257599','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729976),('5','91','257599','255',165.00,185.00,0.00,0.00,0.00,0.00,0.00,729977),('5','91','257600','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,729978),('5','91','257600','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729979),('5','91','257600','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729980),('5','91','257601','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729981),('5','91','257601','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729982),('5','91','257601','255',185.00,185.00,2055.02,0.00,0.00,0.00,0.00,729983),('5','91','257602','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729984),('5','91','257602','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729985),('5','91','257602','255',185.00,185.00,4033.09,0.00,0.00,0.00,0.00,729986),('5','91','257603','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729987),('5','91','257603','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729988),('5','91','257603','255',185.00,185.00,4126.02,0.00,0.00,0.00,0.00,729989),('5','91','257604','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729990),('5','91','257604','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729991),('5','91','257604','255',185.00,185.00,4645.28,0.00,0.00,0.00,0.00,729992),('5','91','257605','255',185.00,185.00,4462.21,0.00,0.00,0.00,0.00,729993),('5','91','257605','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729994),('5','91','257605','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729995),('5','91','257606','255',185.00,185.00,6826.83,0.00,0.00,0.00,0.00,729996),('5','91','257606','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729997),('5','91','257606','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729998),('5','91','257607','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,729999),('5','91','257607','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730000),('5','91','257607','255',185.00,185.00,5637.88,0.00,0.00,0.00,0.00,730001),('5','91','257608','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730002),('5','91','257608','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730003),('5','91','257608','255',185.00,185.00,6743.72,0.00,0.00,0.00,0.00,730004),('5','91','257609','255',185.00,185.00,5420.21,0.00,0.00,0.00,0.00,730005),('5','91','257609','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730006),('5','91','257609','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730007),('5','91','257610','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730008),('5','91','257610','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730009),('5','91','257610','255',185.00,185.00,7954.71,0.00,0.00,0.00,0.00,730010),('5','91','257611','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730011),('5','91','257611','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730012),('5','91','257611','255',185.00,185.00,6418.50,0.00,0.00,0.00,0.00,730013),('5','91','257612','255',185.00,185.00,6325.36,0.00,0.00,0.00,0.00,730014),('5','91','257612','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730015),('5','91','257612','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730016),('5','91','257613','255',185.00,185.00,6259.20,0.00,0.00,0.00,0.00,730017),('5','91','257613','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730018),('5','91','257613','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730019),('5','91','257614','255',185.00,185.00,6380.95,0.00,0.00,0.00,0.00,730020),('5','91','257614','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730021),('5','91','257614','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730022),('5','91','257615','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730023),('5','91','257615','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730024),('5','91','257615','255',185.00,185.00,5379.20,0.00,0.00,0.00,0.00,730025),('5','91','257616','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730026),('5','91','257616','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730027),('5','91','257616','255',185.00,185.00,5089.62,0.00,0.00,0.00,0.00,730028),('5','91','257617','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730029),('5','91','257617','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730030),('5','91','257617','255',185.00,185.00,4869.37,0.00,0.00,0.00,0.00,730031),('5','91','257618','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730032),('5','91','257618','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730033),('5','91','257618','255',185.00,185.00,2510.37,0.00,0.00,0.00,0.00,730034),('5','91','257619','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730035),('5','91','257619','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730036),('5','91','257619','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730037),('5','91','257620','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730038),('5','91','257620','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730039),('5','91','257620','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730040),('5','91','257621','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730041),('5','91','257621','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730042),('5','91','257621','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730043),('5','91','257622','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730044),('5','91','257622','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730045),('5','91','257622','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730046),('5','91','257623','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730047),('5','91','257623','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730048),('5','91','257623','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730049),('5','91','257624','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730050),('5','91','257624','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730051),('5','91','257624','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730052),('5','91','257625','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730053),('5','91','257625','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730054),('5','91','257625','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730055),('5','91','257626','255',185.00,185.00,383.80,0.00,0.00,0.00,0.00,730056),('5','91','257626','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730057),('5','91','257626','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730058),('5','91','257627','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730059),('5','91','257627','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730060),('5','91','257627','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730061),('5','91','257628','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730062),('5','91','257628','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730063),('5','91','257628','255',185.00,185.00,2464.73,0.00,0.00,0.00,0.00,730064),('5','91','257629','255',185.00,185.00,5275.43,0.00,0.00,0.00,0.00,730065),('5','91','257629','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730066),('5','91','257629','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','91','257630','255',185.00,185.00,5016.38,0.00,0.00,0.00,0.00,730068),('5','91','257630','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730069),('5','91','257630','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','91','257631','255',185.00,185.00,6469.14,0.00,0.00,0.00,0.00,730071),('5','91','257631','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730072),('5','91','257631','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730073),('5','91','257632','255',185.00,185.00,6363.40,0.00,0.00,0.00,0.00,730074),('5','91','257632','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730075),('5','91','257632','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','91','257633','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730077),('5','91','257633','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730078),('5','91','257633','255',185.00,185.00,6352.49,0.00,0.00,0.00,0.00,730079),('5','91','257634','255',185.00,185.00,5923.53,0.00,0.00,0.00,0.00,730080),('5','91','257634','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730081),('5','91','257634','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730082),('5','91','257635','255',185.00,185.00,6560.06,0.00,0.00,0.00,0.00,730083),('5','91','257635','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730084),('5','91','257635','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','91','257636','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730086),('5','91','257636','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730087),('5','91','257636','255',185.00,185.00,6526.20,0.00,0.00,0.00,0.00,730088),('5','91','257637','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730089),('5','91','257637','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730090),('5','91','257637','255',185.00,185.00,6850.76,0.00,0.00,0.00,0.00,730091),('5','91','257638','255',185.00,185.00,7072.15,0.00,0.00,0.00,0.00,730092),('5','91','257638','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730093),('5','91','257638','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','91','257639','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730095),('5','91','257639','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730096),('5','91','257639','255',185.00,185.00,7454.56,0.00,0.00,0.00,0.00,730097),('5','91','257640','255',185.00,185.00,6716.20,0.00,0.00,0.00,0.00,730098),('5','91','257640','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730099),('5','91','257640','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','91','257641','255',185.00,185.00,6864.40,0.00,0.00,0.00,0.00,730101),('5','91','257641','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730102),('5','91','257641','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','91','257642','255',185.00,185.00,5313.36,0.00,0.00,0.00,0.00,730104),('5','91','257642','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730105),('5','91','257642','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','91','257643','255',185.00,185.00,8691.49,0.00,0.00,0.00,0.00,730107),('5','91','257643','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730108),('5','91','257643','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','91','257644','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730110),('5','91','257644','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730111),('5','91','257644','255',185.00,185.00,5515.28,0.00,0.00,0.00,0.00,730112),('5','91','257645','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730113),('5','91','257645','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730114),('5','91','257645','255',185.00,185.00,5699.25,0.00,0.00,0.00,0.00,730115),('5','91','257646','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730116),('5','91','257646','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730117),('5','91','257646','255',185.00,185.00,7235.36,0.00,0.00,0.00,0.00,730118),('5','91','257647','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730119),('5','91','257647','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730120),('5','91','257647','255',185.00,185.00,5588.17,0.00,0.00,0.00,0.00,730121),('5','91','257648','255',185.00,185.00,9350.48,0.00,0.00,0.00,0.00,730122),('5','91','257648','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730123),('5','91','257648','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','91','257649','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730125),('5','91','257649','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730126),('5','91','257649','255',185.00,185.00,6806.93,0.00,0.00,0.00,0.00,730127),('5','91','257650','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730128),('5','91','257650','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730129),('5','91','257650','255',185.00,185.00,10420.40,0.00,0.00,0.00,0.00,730130),('5','91','257651','255',185.00,185.00,5168.60,0.00,0.00,0.00,0.00,730131),('5','91','257651','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730132),('5','91','257651','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','91','257652','255',185.00,185.00,7303.74,0.00,0.00,0.00,0.00,730134),('5','91','257652','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730135),('5','91','257652','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','91','257653','255',185.00,185.00,6974.31,0.00,0.00,0.00,0.00,730137),('5','91','257653','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730138),('5','91','257653','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','91','257654','255',185.00,185.00,6012.18,0.00,0.00,0.00,0.00,730140),('5','91','257654','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730141),('5','91','257654','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','91','257655','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730143),('5','91','257655','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730144),('5','91','257655','255',185.00,185.00,10228.92,0.00,0.00,0.00,0.00,730145),('5','91','257656','255',185.00,185.00,7449.78,0.00,0.00,0.00,0.00,730146),('5','91','257656','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730147),('5','91','257656','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','91','257657','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730149),('5','91','257657','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730150),('5','91','257657','255',185.00,185.00,9221.05,0.00,0.00,0.00,0.00,730151),('5','91','257658','255',185.00,185.00,6120.68,0.00,0.00,0.00,0.00,730152),('5','91','257658','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730153),('5','91','257658','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','91','257659','255',185.00,185.00,6211.91,0.00,0.00,0.00,0.00,730155),('5','91','257659','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730156),('5','91','257659','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730157),('5','91','257660','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730158),('5','91','257660','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730159),('5','91','257660','255',185.00,185.00,8343.05,0.00,0.00,0.00,0.00,730160),('5','91','257661','255',185.00,185.00,5594.66,0.00,0.00,0.00,0.00,730161),('5','91','257661','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730162),('5','91','257661','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','91','257662','255',185.00,185.00,10202.79,0.00,0.00,0.00,0.00,730164),('5','91','257662','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730165),('5','91','257662','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730166),('5','91','257663','255',185.00,185.00,7296.42,0.00,0.00,0.00,0.00,730167),('5','91','257663','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730168),('5','91','257663','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730169),('5','91','257664','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730170),('5','91','257664','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730171),('5','91','257664','255',185.00,185.00,9223.05,0.00,0.00,0.00,0.00,730172),('5','91','257665','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730173),('5','91','257665','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730174),('5','91','257665','255',185.00,185.00,4351.11,0.00,0.00,0.00,0.00,730175),('5','91','257666','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730176),('5','91','257666','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730177),('5','91','257666','255',185.00,185.00,5806.91,0.00,0.00,0.00,0.00,730178),('5','91','257667','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730179),('5','91','257667','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730180),('5','91','257667','255',185.00,185.00,5011.25,0.00,0.00,0.00,0.00,730181),('5','91','257668','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730182),('5','91','257668','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730183),('5','91','257668','255',185.00,185.00,5213.83,0.00,0.00,0.00,0.00,730184),('5','91','257669','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730185),('5','91','257669','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730186),('5','91','257669','255',185.00,185.00,5842.49,0.00,0.00,0.00,0.00,730187),('5','91','257670','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730188),('5','91','257670','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730189),('5','91','257670','255',185.00,185.00,7300.96,0.00,0.00,0.00,0.00,730190),('5','91','257671','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730191),('5','91','257671','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730192),('5','91','257671','255',185.00,185.00,5751.91,0.00,0.00,0.00,0.00,730193),('5','91','257672','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730194),('5','91','257672','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730195),('5','91','257672','255',185.00,185.00,6128.17,0.00,0.00,0.00,0.00,730196),('5','91','257673','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730197),('5','91','257673','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730198),('5','91','257673','255',185.00,185.00,6013.75,0.00,0.00,0.00,0.00,730199),('5','91','257674','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730200),('5','91','257674','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730201),('5','91','257674','255',185.00,185.00,4050.53,0.00,0.00,0.00,0.00,730202),('5','91','257675','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730203),('5','91','257675','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730204),('5','91','257675','255',185.00,185.00,2475.21,0.00,0.00,0.00,0.00,730205),('5','91','257676','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730206),('5','91','257676','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730207),('5','91','257676','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730208),('5','91','257677','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730209),('5','91','257677','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730210),('5','91','257677','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730211),('5','91','257678','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730212),('5','91','257678','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730213),('5','91','257678','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730214),('5','91','257679','255',185.00,185.00,2255.46,0.00,0.00,0.00,0.00,730215),('5','91','257679','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730216),('5','91','257679','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','91','257680','255',185.00,185.00,7251.21,0.00,0.00,0.00,0.00,730218),('5','91','257680','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730219),('5','91','257680','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730220),('5','91','257681','255',185.00,185.00,8745.69,0.00,0.00,0.00,0.00,730221),('5','91','257681','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730222),('5','91','257681','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730223),('5','91','257682','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730224),('5','91','257682','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730225),('5','91','257682','255',185.00,185.00,7197.72,0.00,0.00,0.00,0.00,730226),('5','91','257683','255',185.00,185.00,10772.97,0.00,0.00,0.00,0.00,730227),('5','91','257683','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730228),('5','91','257683','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730229),('5','91','257684','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730230),('5','91','257684','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730231),('5','91','257684','255',185.00,185.00,7573.20,0.00,0.00,0.00,0.00,730232),('5','91','257685','255',185.00,185.00,10022.42,0.00,0.00,0.00,0.00,730233),('5','91','257685','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730234),('5','91','257685','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730235),('5','91','257686','255',185.00,185.00,7125.22,0.00,0.00,0.00,0.00,730236),('5','91','257686','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730237),('5','91','257686','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730238),('5','91','257687','255',185.00,185.00,7575.74,0.00,0.00,0.00,0.00,730239),('5','91','257687','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730240),('5','91','257687','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730241),('5','91','257688','255',185.00,185.00,11180.76,0.00,0.00,0.00,0.00,730242),('5','91','257688','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730243),('5','91','257688','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730244),('5','91','257689','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730245),('5','91','257689','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730246),('5','91','257689','255',185.00,185.00,6139.77,0.00,0.00,0.00,0.00,730247),('5','91','257690','255',185.00,185.00,11571.99,0.00,0.00,0.00,0.00,730248),('5','91','257690','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730249),('5','91','257690','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730250),('5','91','257691','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730251),('5','91','257691','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730252),('5','91','257691','255',185.00,185.00,9565.81,0.00,0.00,0.00,0.00,730253),('5','91','257692','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730254),('5','91','257692','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730255),('5','91','257692','255',185.00,185.00,8725.86,0.00,0.00,0.00,0.00,730256),('5','91','257693','255',185.00,185.00,8211.88,0.00,0.00,0.00,0.00,730257),('5','91','257693','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730258),('5','91','257693','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730259),('5','91','257694','255',185.00,185.00,8493.06,0.00,0.00,0.00,0.00,730260),('5','91','257694','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730261),('5','91','257694','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730262),('5','91','257695','255',185.00,185.00,4909.02,0.00,0.00,0.00,0.00,730263),('5','91','257695','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730264),('5','91','257695','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730265),('5','91','257696','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730266),('5','91','257696','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730267),('5','91','257696','255',185.00,185.00,2117.85,0.00,0.00,0.00,0.00,730268),('5','91','257697','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730269),('5','91','257697','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730270),('5','91','257697','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730271),('5','91','257698','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730272),('5','91','257698','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730273),('5','91','257698','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730274),('5','91','257699','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730275),('5','91','257699','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730276),('5','91','257699','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730277),('5','91','257700','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730278),('5','91','257700','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730279),('5','91','257700','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730280),('5','91','257701','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730281),('5','91','257701','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730282),('5','91','257701','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730283),('5','91','257702','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730284),('5','91','257702','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730285),('5','91','257702','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730286),('5','91','257703','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730287),('5','91','257703','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730288),('5','91','257703','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730289),('5','91','257704','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730290),('5','91','257704','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730291),('5','91','257704','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730292),('5','91','257705','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730293),('5','91','257705','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730294),('5','91','257705','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730295),('5','91','257706','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730296),('5','91','257706','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730297),('5','91','257706','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730298),('5','91','257707','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730299),('5','91','257707','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730300),('5','91','257707','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730301),('5','91','257708','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730302),('5','91','257708','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730303),('5','91','257708','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730304),('5','91','257709','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730305),('5','91','257709','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730306),('5','91','257709','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730307),('5','91','257710','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730308),('5','91','257710','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730309),('5','91','257710','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730310),('5','91','257711','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730311),('5','91','257711','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730312),('5','91','257711','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730313),('5','91','257712','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730314),('5','91','257712','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730315),('5','91','257712','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730316),('5','91','257713','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730317),('5','91','257713','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730318),('5','91','257713','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730319),('5','91','257714','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730320),('5','91','257714','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730321),('5','91','257714','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730322),('5','91','257715','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730323),('5','91','257715','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730324),('5','91','257715','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730325),('5','91','257716','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730326),('5','91','257716','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730327),('5','91','257716','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730328),('5','91','257717','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730329),('5','91','257717','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730330),('5','91','257717','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730331),('5','91','257718','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730332),('5','91','257718','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730333),('5','91','257718','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730334),('5','91','257719','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730335),('5','91','257719','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730336),('5','91','257719','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730337),('5','91','257720','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730338),('5','91','257720','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730339),('5','91','257720','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730340),('5','91','257721','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730341),('5','91','257721','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730342),('5','91','257721','255',185.00,185.00,3045.03,0.00,0.00,0.00,0.00,730343),('5','91','257722','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730344),('5','91','257722','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730345),('5','91','257722','255',185.00,185.00,9201.07,0.00,0.00,0.00,0.00,730346),('5','91','257723','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730347),('5','91','257723','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730348),('5','91','257723','255',185.00,185.00,9258.10,0.00,0.00,0.00,0.00,730349),('5','91','257724','255',185.00,185.00,9586.17,0.00,0.00,0.00,0.00,730350),('5','91','257724','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730351),('5','91','257724','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730352),('5','91','257725','255',185.00,185.00,8154.04,0.00,0.00,0.00,0.00,730353),('5','91','257725','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730354),('5','91','257725','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730355),('5','91','257726','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730356),('5','91','257726','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730357),('5','91','257726','255',185.00,185.00,7076.34,0.00,0.00,0.00,0.00,730358),('5','91','257727','255',185.00,185.00,5765.52,0.00,0.00,0.00,0.00,730359),('5','91','257727','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730360),('5','91','257727','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730361),('5','91','257728','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730362),('5','91','257728','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730363),('5','91','257728','255',185.00,185.00,5568.59,0.00,0.00,0.00,0.00,730364),('5','91','257729','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730365),('5','91','257729','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730366),('5','91','257729','255',185.00,185.00,2438.60,0.00,0.00,0.00,0.00,730367),('5','91','257730','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730368),('5','91','257730','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730369),('5','91','257730','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730370),('5','91','257731','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730371),('5','91','257731','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730372),('5','91','257731','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730373),('5','91','257732','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730374),('5','91','257732','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730375),('5','91','257732','255',185.00,185.00,3080.01,0.00,0.00,0.00,0.00,730376),('5','91','257733','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730377),('5','91','257733','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730378),('5','91','257733','255',185.00,185.00,8426.78,0.00,0.00,0.00,0.00,730379),('5','91','257734','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730380),('5','91','257734','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730381),('5','91','257734','255',185.00,185.00,9023.49,0.00,0.00,0.00,0.00,730382),('5','91','257735','255',185.00,185.00,10230.30,0.00,0.00,0.00,0.00,730383),('5','91','257735','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730384),('5','91','257735','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730385),('5','91','257736','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730386),('5','91','257736','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730387),('5','91','257736','255',185.00,185.00,7035.49,0.00,0.00,0.00,0.00,730388),('5','91','257737','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730389),('5','91','257737','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730390),('5','91','257737','255',185.00,185.00,7065.68,0.00,0.00,0.00,0.00,730391),('5','91','257738','255',185.00,185.00,6571.55,0.00,0.00,0.00,0.00,730392),('5','91','257738','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730393),('5','91','257738','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730394),('5','91','257739','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730395),('5','91','257739','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730396),('5','91','257739','255',185.00,185.00,5672.71,0.00,0.00,0.00,0.00,730397),('5','91','257740','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730398),('5','91','257740','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730399),('5','91','257740','255',185.00,185.00,2491.87,0.00,0.00,0.00,0.00,730400),('5','91','257741','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730401),('5','91','257741','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730402),('5','91','257741','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730403),('5','91','257742','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730404),('5','91','257742','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730405),('5','91','257742','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','91','257743','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730407),('5','91','257743','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730408),('5','91','257743','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730409),('5','91','257744','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730410),('5','91','257744','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730411),('5','91','257744','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730412),('5','91','257745','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730413),('5','91','257745','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730414),('5','91','257745','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730415),('5','91','257746','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730416),('5','91','257746','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730417),('5','91','257746','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730418),('5','91','257747','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730419),('5','91','257747','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730420),('5','91','257747','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730421),('5','91','257748','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730422),('5','91','257748','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730423),('5','91','257748','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730424),('5','91','257749','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730425),('5','91','257749','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730426),('5','91','257749','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730427),('5','91','257750','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730428),('5','91','257750','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730429),('5','91','257750','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730430),('5','91','257751','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730431),('5','91','257751','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730432),('5','91','257751','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730433),('5','91','257752','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730434),('5','91','257752','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730435),('5','91','257752','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730436),('5','91','257753','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730437),('5','91','257753','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730438),('5','91','257753','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730439),('5','91','257754','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730440),('5','91','257754','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730441),('5','91','257754','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730442),('5','91','257755','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730443),('5','91','257755','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730444),('5','91','257755','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730445),('5','91','257756','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730446),('5','91','257756','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730447),('5','91','257756','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730448),('5','91','257757','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730449),('5','91','257757','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730450),('5','91','257757','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730451),('5','91','257758','256',800.00,800.00,0.00,0.00,0.00,0.00,0.00,730452),('5','91','257758','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730453),('5','91','257758','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730454),('5','91','257759','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730455),('5','91','257759','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730456),('5','91','257759','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730457),('5','91','257760','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730458),('5','91','257760','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730459),('5','91','257760','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730460),('5','91','257761','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730461),('5','91','257761','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730462),('5','91','257761','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730463),('5','91','257762','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730464),('5','91','257762','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730465),('5','91','257762','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730466),('5','91','257763','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730467),('5','91','257763','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730468),('5','91','257763','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730469),('5','91','257764','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730470),('5','91','257764','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730471),('5','91','257764','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730472),('5','91','257765','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730473),('5','91','257765','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730474),('5','91','257765','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730475),('5','91','257766','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730476),('5','91','257766','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730477),('5','91','257766','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730478),('5','91','257767','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730479),('5','91','257767','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730480),('5','91','257767','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730481),('5','91','257768','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730482),('5','91','257768','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730483),('5','91','257768','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730484),('5','91','257769','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730485),('5','91','257769','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730486),('5','91','257769','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730487),('5','91','257770','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730488),('5','91','257770','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730489),('5','91','257770','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730490),('5','91','257771','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730491),('5','91','257771','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730492),('5','91','257771','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730493),('5','91','257772','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730494),('5','91','257772','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730495),('5','91','257772','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730496),('5','91','257773','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730497),('5','91','257773','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730498),('5','91','257773','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730499),('5','91','257774','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730500),('5','91','257774','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730501),('5','91','257774','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730502),('5','91','257775','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730503),('5','91','257775','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730504),('5','91','257775','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730505),('5','91','257776','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730506),('5','91','257776','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730507),('5','91','257776','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730508),('5','91','257777','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730509),('5','91','257777','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730510),('5','91','257777','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730511),('5','91','257778','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730512),('5','91','257778','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730513),('5','91','257778','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730514),('5','91','257779','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730515),('5','91','257779','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730516),('5','91','257779','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730517),('5','91','257780','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730518),('5','91','257780','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730519),('5','91','257780','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730520),('5','91','257781','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730521),('5','91','257781','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730522),('5','91','257781','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730523),('5','91','257782','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730524),('5','91','257782','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730525),('5','91','257782','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730526),('5','91','257783','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730527),('5','91','257783','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730528),('5','91','257783','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730529),('5','91','257784','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730530),('5','91','257784','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730531),('5','91','257784','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730532),('5','91','257785','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730533),('5','91','257785','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730534),('5','91','257785','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730535),('5','91','257786','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730536),('5','91','257786','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730537),('5','91','257786','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730538),('5','91','257787','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730539),('5','91','257787','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730540),('5','91','257787','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730541),('5','91','257788','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730542),('5','91','257788','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730543),('5','91','257788','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730544),('5','91','257789','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730545),('5','91','257789','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730546),('5','91','257789','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730547),('5','91','257790','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730548),('5','91','257790','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730549),('5','91','257790','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730550),('5','91','257791','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730551),('5','91','257791','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730552),('5','91','257791','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730553),('5','91','257792','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730554),('5','91','257792','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730555),('5','91','257792','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730556),('5','91','257793','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730557),('5','91','257793','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730558),('5','91','257793','255',185.00,185.00,2430.37,0.00,0.00,0.00,0.00,730559),('5','91','257794','255',185.00,185.00,7432.00,0.00,0.00,0.00,0.00,730560),('5','91','257794','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730561),('5','91','257794','257',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730562),('5','91','257795','256',870.00,870.00,0.00,0.00,0.00,0.00,0.00,730563),('5','91','257795','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730564),('5','91','257795','255',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730565),('5','91','257796','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730566),('5','91','257796','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730567),('5','91','257796','255',220.00,220.00,4576.05,0.00,0.00,0.00,0.00,730568),('5','91','257797','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730569),('5','91','257797','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730570),('5','91','257797','255',220.00,220.00,10093.54,0.00,0.00,0.00,0.00,730571),('5','91','257798','255',220.00,220.00,12709.33,0.00,0.00,0.00,0.00,730572),('5','91','257798','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730573),('5','91','257798','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730574),('5','91','257799','255',220.00,220.00,9746.45,0.00,0.00,0.00,0.00,730575),('5','91','257799','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730576),('5','91','257799','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730577),('5','91','257800','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730578),('5','91','257800','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730579),('5','91','257800','255',220.00,220.00,2797.90,0.00,0.00,0.00,0.00,730580),('5','91','257801','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730581),('5','91','257801','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730582),('5','91','257801','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730583),('5','91','257802','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730584),('5','91','257802','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730585),('5','91','257802','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730586),('5','91','257803','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730587),('5','91','257803','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730588),('5','91','257803','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730589),('5','91','257804','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730590),('5','91','257804','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730591),('5','91','257804','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730592),('5','91','257805','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730593),('5','91','257805','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730594),('5','91','257805','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730595),('5','91','257806','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730596),('5','91','257806','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730597),('5','91','257806','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730598),('5','91','257807','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730599),('5','91','257807','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730600),('5','91','257807','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730601),('5','91','257808','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730602),('5','91','257808','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730603),('5','91','257808','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730604),('5','91','257809','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730605),('5','91','257809','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730606),('5','91','257809','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730607),('5','91','257810','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730608),('5','91','257810','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730609),('5','91','257810','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730610),('5','91','257811','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730611),('5','91','257811','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730612),('5','91','257811','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730613),('5','91','257812','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730614),('5','91','257812','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730615),('5','91','257812','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730616),('5','91','257813','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730617),('5','91','257813','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730618),('5','91','257813','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730619),('5','91','257814','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730620),('5','91','257814','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730621),('5','91','257814','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730622),('5','91','257815','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730623),('5','91','257815','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730624),('5','91','257815','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730625),('5','91','257816','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730626),('5','91','257816','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730627),('5','91','257816','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730628),('5','91','257817','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730629),('5','91','257817','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730630),('5','91','257817','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730631),('5','91','257818','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730632),('5','91','257818','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730633),('5','91','257818','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730634),('5','91','257819','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730635),('5','91','257819','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730636),('5','91','257819','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730637),('5','91','257820','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730638),('5','91','257820','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730639),('5','91','257820','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730640),('5','91','257821','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730641),('5','91','257821','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730642),('5','91','257821','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730643),('5','91','257822','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730644),('5','91','257822','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730645),('5','91','257822','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730646),('5','91','257823','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730647),('5','91','257823','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730648),('5','91','257823','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730649),('5','91','257824','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730650),('5','91','257824','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730651),('5','91','257824','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730652),('5','91','257825','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730653),('5','91','257825','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730654),('5','91','257825','255',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730655),('5','91','257826','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730656),('5','91','257826','256',830.00,830.00,0.00,0.00,0.00,0.00,0.00,730657),('5','91','257826','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730658),('5','91','257827','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730659),('5','91','257827','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730660),('5','91','257827','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730661),('5','91','257828','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730662),('5','91','257828','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730663),('5','91','257828','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730664),('5','91','257829','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730665),('5','91','257829','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730666),('5','91','257829','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730667),('5','91','257830','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730668),('5','91','257830','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730669),('5','91','257830','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730670),('5','91','257831','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730671),('5','91','257831','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730672),('5','91','257831','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730673),('5','91','257832','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730674),('5','91','257832','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730675),('5','91','257832','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730676),('5','91','257833','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730677),('5','91','257833','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730678),('5','91','257833','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730679),('5','91','257834','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730680),('5','91','257834','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730681),('5','91','257834','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730682),('5','91','257835','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730683),('5','91','257835','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730684),('5','91','257835','255',210.00,210.00,4293.69,0.00,0.00,0.00,0.00,730685),('5','91','257836','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730686),('5','91','257836','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730687),('5','91','257836','255',210.00,210.00,10462.31,0.00,0.00,0.00,0.00,730688),('5','91','257837','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730689),('5','91','257837','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730690),('5','91','257837','255',210.00,210.00,12206.16,0.00,0.00,0.00,0.00,730691),('5','91','257838','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730692),('5','91','257838','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730693),('5','91','257838','255',210.00,210.00,10005.36,0.00,0.00,0.00,0.00,730694),('5','91','257839','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730695),('5','91','257839','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730696),('5','91','257839','255',210.00,210.00,13100.02,0.00,0.00,0.00,0.00,730697),('5','91','257840','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730698),('5','91','257840','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730699),('5','91','257840','255',210.00,210.00,11007.21,0.00,0.00,0.00,0.00,730700),('5','91','257841','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730701),('5','91','257841','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730702),('5','91','257841','255',210.00,210.00,12575.80,0.00,0.00,0.00,0.00,730703),('5','91','257842','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730704),('5','91','257842','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730705),('5','91','257842','255',210.00,210.00,9342.91,0.00,0.00,0.00,0.00,730706),('5','91','257843','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730707),('5','91','257843','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730708),('5','91','257843','255',210.00,210.00,7929.36,0.00,0.00,0.00,0.00,730709),('5','91','257844','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730710),('5','91','257844','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730711),('5','91','257844','255',210.00,210.00,5887.42,0.00,0.00,0.00,0.00,730712),('5','91','257845','255',210.00,210.00,2976.42,0.00,0.00,0.00,0.00,730713),('5','91','257845','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730714),('5','91','257845','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730715),('5','91','257846','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730716),('5','91','257846','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730717),('5','91','257846','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730718),('5','91','257847','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730719),('5','91','257847','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730720),('5','91','257847','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730721),('5','91','257848','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730722),('5','91','257848','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730723),('5','91','257848','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730724),('5','91','257849','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730725),('5','91','257849','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730726),('5','91','257849','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730727),('5','91','257850','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730728),('5','91','257850','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730729),('5','91','257850','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730730),('5','91','257851','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730731),('5','91','257851','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730732),('5','91','257851','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730733),('5','91','257852','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730734),('5','91','257852','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730735),('5','91','257852','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730736),('5','91','257853','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730737),('5','91','257853','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730738),('5','91','257853','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730739),('5','91','257854','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730740),('5','91','257854','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730741),('5','91','257854','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730742),('5','91','257855','255',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730743),('5','91','257855','256',820.00,820.00,0.00,0.00,0.00,0.00,0.00,730744),('5','91','257855','257',220.00,220.00,0.00,0.00,0.00,0.00,0.00,730745);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',258,'91','PRODUCT TANKS','TANK CONTAINING PETROLEUM.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=647 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','91','258',642,0,'255','PMS TANK 1',33000.00,1.00,14410.78,'TANK CONTAINING PMS','393','2019-02-23 23:59:28','2019-02-23 23:59:28','393',5,1),('5','91','258',643,0,'255','PMS TANK 2',33000.00,1.00,11537.65,'TANK CONTAINING PMS','393','2019-02-24 00:01:45','2019-02-24 00:01:45','393',5,1),('5','91','258',644,0,'255','PMS TANK 3',33000.00,1.00,26283.71,'TANK CONTAINING PMS','393','2019-02-24 00:03:33','2019-02-24 00:03:33','393',5,1),('5','91','258',645,0,'256','AGO TANK',33000.00,1.00,1400.92,'TANK CONTAINING AGO','393','2019-02-24 00:05:24','2019-02-24 00:05:24','393',5,1),('5','91','258',646,0,'257','DPK TANK',32000.00,1.00,0.00,'TANK CONTAINING DPK','393','2019-02-24 00:06:40','2019-02-24 00:06:40','393',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','91',646,0.00,'2023-03-20 19:26:31'),(2,'5','91',645,102.00,'2023-03-20 19:26:31'),(3,'5','91',644,1356.02,'2023-03-20 19:26:31'),(4,'5','91',643,4065.14,'2023-03-20 19:26:31'),(5,'5','91',642,230.03,'2023-03-20 19:26:31');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2641695 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2109843,'5','91','642',255,'Sale Id shift 242833',0.00,0.00,0.00,2198.51,0.00,'2021-12-01 07:54:06','',''),(2109844,'5','91','644',255,'Sale Id shift 242833',0.00,0.00,0.00,6798.93,0.00,'2021-12-01 07:54:06','',''),(2109845,'5','91',NULL,255,'Sale Id shift 242833',1484577.60,0.00,0.00,0.00,0.00,'2021-12-01 07:54:06','',''),(2121700,'5','91','642',255,'Sale Id shift 242990',0.00,0.00,0.00,1690.43,0.00,'2021-12-02 07:21:47','',''),(2121701,'5','91','644',255,'Sale Id shift 242990',0.00,0.00,0.00,2806.52,0.00,'2021-12-02 07:21:47','',''),(2121702,'5','91',NULL,255,'Sale Id shift 242990',741996.75,0.00,0.00,0.00,0.00,'2021-12-02 07:21:47','',''),(2134702,'5','91','642',255,'Sale Id shift 243232',0.00,0.00,0.00,1509.03,0.00,'2021-12-03 06:58:20','',''),(2134703,'5','91','644',255,'Sale Id shift 243232',0.00,0.00,0.00,2976.35,0.00,'2021-12-03 06:58:20','',''),(2134704,'5','91',NULL,255,'Sale Id shift 243232',740087.70,0.00,0.00,0.00,0.00,'2021-12-03 06:58:20','',''),(2147502,'5','91','642',255,'Sale Id shift 243457',0.00,0.00,0.00,1221.51,0.00,'2021-12-04 06:56:49','',''),(2147503,'5','91','643',255,'Sale Id shift 243457',0.00,0.00,0.00,185.00,0.00,'2021-12-04 06:56:49','',''),(2147504,'5','91','644',255,'Sale Id shift 243457',0.00,0.00,0.00,1224.23,0.00,'2021-12-04 06:56:49','',''),(2147505,'5','91',NULL,255,'Sale Id shift 243457',434072.10,0.00,0.00,0.00,0.00,'2021-12-04 06:56:49','',''),(2263157,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9834000.00,59600.00,0.00,0.00,'2021-12-12 16:13:17','',''),(2264682,'5','91',NULL,255,'Reception corrector for bridging 127178',0.00,0.00,0.00,15450.00,0.00,'2021-12-12 18:57:43','',''),(2264683,'5','91','642',255,'Received from bridging 127178',0.00,0.00,15450.00,0.00,0.00,'2021-12-12 18:57:43','',''),(2264684,'5','91',NULL,255,'Reception corrector for bridging 127179',0.00,0.00,0.00,14850.00,0.00,'2021-12-12 18:58:08','',''),(2264685,'5','91','643',255,'Received from bridging 127179',0.00,0.00,14850.00,0.00,0.00,'2021-12-12 18:58:08','',''),(2264686,'5','91',NULL,255,'Reception corrector for bridging 127180',0.00,0.00,0.00,29300.00,0.00,'2021-12-12 18:58:25','',''),(2264687,'5','91','644',255,'Received from bridging 127180',0.00,0.00,29300.00,0.00,0.00,'2021-12-12 18:58:25','',''),(2265315,'5','91','642',255,'Sale Id shift 245525',0.00,0.00,0.00,1760.50,0.00,'2021-12-13 06:02:04','',''),(2265316,'5','91','643',255,'Sale Id shift 245525',0.00,0.00,0.00,1551.58,0.00,'2021-12-13 06:02:04','',''),(2265317,'5','91','644',255,'Sale Id shift 245525',0.00,0.00,0.00,3068.35,0.00,'2021-12-13 06:02:04','',''),(2265318,'5','91',NULL,255,'Sale Id shift 245525',1052770.95,0.00,0.00,0.00,0.00,'2021-12-13 06:02:04','',''),(2276981,'5','91','642',255,'Sale Id shift 245764',0.00,0.00,0.00,599.08,0.00,'2021-12-14 06:08:37','',''),(2276982,'5','91','643',255,'Sale Id shift 245764',0.00,0.00,0.00,5287.43,0.00,'2021-12-14 06:08:37','',''),(2276983,'5','91','644',255,'Sale Id shift 245764',0.00,0.00,0.00,4488.75,0.00,'2021-12-14 06:08:37','',''),(2276984,'5','91',NULL,255,'Sale Id shift 245764',1711917.90,0.00,0.00,0.00,0.00,'2021-12-14 06:08:37','',''),(2286166,'5','91','642',255,'Sale Id shift 246047',0.00,0.00,0.00,1997.52,0.00,'2021-12-15 06:40:37','',''),(2286167,'5','91','644',255,'Sale Id shift 246047',0.00,0.00,0.00,3861.20,0.00,'2021-12-15 06:40:37','',''),(2286168,'5','91',NULL,255,'Sale Id shift 246047',966688.80,0.00,0.00,0.00,0.00,'2021-12-15 06:40:37','',''),(2293402,'5','91','642',255,'Sale Id shift 246304',0.00,0.00,0.00,1418.84,0.00,'2021-12-16 06:52:23','',''),(2293403,'5','91','643',255,'Sale Id shift 246304',0.00,0.00,0.00,1451.58,0.00,'2021-12-16 06:52:23','',''),(2293404,'5','91','644',255,'Sale Id shift 246304',0.00,0.00,0.00,2457.27,0.00,'2021-12-16 06:52:23','',''),(2293405,'5','91',NULL,255,'Sale Id shift 246304',879068.85,0.00,0.00,0.00,0.00,'2021-12-16 06:52:23','',''),(2301025,'5','91',NULL,256,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4364250.00,12650.00,0.00,0.00,'2021-12-16 21:27:48','',''),(2301324,'5','91','642',255,'Sale Id shift 246564',0.00,0.00,0.00,1333.36,0.00,'2021-12-17 06:12:36','',''),(2301325,'5','91','643',255,'Sale Id shift 246564',0.00,0.00,0.00,2832.01,0.00,'2021-12-17 06:12:36','',''),(2301326,'5','91','644',255,'Sale Id shift 246564',0.00,0.00,0.00,4064.55,0.00,'2021-12-17 06:12:36','',''),(2301327,'5','91',NULL,255,'Sale Id shift 246564',1357936.80,0.00,0.00,0.00,0.00,'2021-12-17 06:12:36','',''),(2307498,'5','91',NULL,256,'Reception corrector for bridging 127714',0.00,0.00,0.00,12650.00,0.00,'2021-12-17 16:28:55','',''),(2307499,'5','91','645',256,'Received from bridging 127714',0.00,0.00,12650.00,0.00,0.00,'2021-12-17 16:28:55','',''),(2309521,'5','91','642',255,'Sale Id shift 246795',0.00,0.00,0.00,2232.59,0.00,'2021-12-18 07:04:14','',''),(2309522,'5','91','643',255,'Sale Id shift 246795',0.00,0.00,0.00,50.74,0.00,'2021-12-18 07:04:14','',''),(2309523,'5','91','644',255,'Sale Id shift 246795',0.00,0.00,0.00,3290.52,0.00,'2021-12-18 07:04:14','',''),(2309524,'5','91','645',256,'Sale Id shift 246795',0.00,0.00,0.00,1228.80,0.00,'2021-12-18 07:04:14','',''),(2309525,'5','91',NULL,255,'Sale Id shift 246795',919685.25,0.00,0.00,0.00,0.00,'2021-12-18 07:04:14','',''),(2309526,'5','91',NULL,256,'Sale Id shift 246795',423936.00,0.00,0.00,0.00,0.00,'2021-12-18 07:04:14','',''),(2318419,'5','91','642',255,'Sale Id shift 247103',0.00,0.00,0.00,2968.24,0.00,'2021-12-19 07:13:51','',''),(2318420,'5','91','643',255,'Sale Id shift 247103',0.00,0.00,0.00,1491.50,0.00,'2021-12-19 07:13:51','',''),(2318421,'5','91','644',255,'Sale Id shift 247103',0.00,0.00,0.00,4100.98,0.00,'2021-12-19 07:13:51','',''),(2318422,'5','91','645',256,'Sale Id shift 247103',0.00,0.00,0.00,164.02,0.00,'2021-12-19 07:13:51','',''),(2318423,'5','91',NULL,255,'Sale Id shift 247103',1412518.80,0.00,0.00,0.00,0.00,'2021-12-19 07:13:51','',''),(2318424,'5','91',NULL,256,'Sale Id shift 247103',56586.90,0.00,0.00,0.00,0.00,'2021-12-19 07:13:51','',''),(2326477,'5','91','642',255,'Sale Id shift 247233',0.00,0.00,0.00,3117.43,0.00,'2021-12-20 06:57:13','',''),(2326478,'5','91','643',255,'Sale Id shift 247233',0.00,0.00,0.00,2195.92,0.00,'2021-12-20 06:57:13','',''),(2326479,'5','91','644',255,'Sale Id shift 247233',0.00,0.00,0.00,3897.60,0.00,'2021-12-20 06:57:13','',''),(2326480,'5','91','645',256,'Sale Id shift 247233',0.00,0.00,0.00,167.56,0.00,'2021-12-20 06:57:13','',''),(2326481,'5','91',NULL,255,'Sale Id shift 247233',1519806.75,0.00,0.00,0.00,0.00,'2021-12-20 06:57:13','',''),(2326482,'5','91',NULL,256,'Sale Id shift 247233',57808.20,0.00,0.00,0.00,0.00,'2021-12-20 06:57:13','',''),(2334969,'5','91','645',256,'Sale Id shift 247436',0.00,0.00,0.00,700.20,0.00,'2021-12-21 09:20:09','',''),(2334970,'5','91',NULL,256,'Sale Id shift 247436',241569.00,0.00,0.00,0.00,0.00,'2021-12-21 09:20:09','',''),(2339258,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7408500.00,44900.00,0.00,0.00,'2021-12-21 16:02:27','',''),(2340139,'5','91',NULL,255,'Reception corrector for bridging 128238',0.00,0.00,0.00,15050.00,0.00,'2021-12-21 17:17:46','',''),(2340140,'5','91','643',255,'Received from bridging 128238',0.00,0.00,15050.00,0.00,0.00,'2021-12-21 17:17:46','',''),(2340142,'5','91',NULL,255,'Reception corrector for bridging 128239',0.00,0.00,0.00,29850.00,0.00,'2021-12-21 17:18:10','',''),(2340143,'5','91','644',255,'Received from bridging 128239',0.00,0.00,29850.00,0.00,0.00,'2021-12-21 17:18:10','',''),(2341351,'5','91','643',255,'Sale Id shift 247868',0.00,0.00,0.00,1761.74,0.00,'2021-12-22 06:35:13','',''),(2341352,'5','91','644',255,'Sale Id shift 247868',0.00,0.00,0.00,2273.03,0.00,'2021-12-22 06:35:13','',''),(2341353,'5','91','645',256,'Sale Id shift 247868',0.00,0.00,0.00,286.52,0.00,'2021-12-22 06:35:13','',''),(2341354,'5','91',NULL,255,'Sale Id shift 247868',665737.05,0.00,0.00,0.00,0.00,'2021-12-22 06:35:13','',''),(2341355,'5','91',NULL,256,'Sale Id shift 247868',98849.40,0.00,0.00,0.00,0.00,'2021-12-22 06:35:13','',''),(2349682,'5','91','643',255,'Sale Id shift 248104',0.00,0.00,0.00,2753.71,0.00,'2021-12-23 06:33:41','',''),(2349683,'5','91','644',255,'Sale Id shift 248104',0.00,0.00,0.00,4019.54,0.00,'2021-12-23 06:33:41','',''),(2349684,'5','91','645',256,'Sale Id shift 248104',0.00,0.00,0.00,442.93,0.00,'2021-12-23 06:33:41','',''),(2349685,'5','91',NULL,255,'Sale Id shift 248104',1117586.25,0.00,0.00,0.00,0.00,'2021-12-23 06:33:41','',''),(2349686,'5','91',NULL,256,'Sale Id shift 248104',152810.85,0.00,0.00,0.00,0.00,'2021-12-23 06:33:41','',''),(2359082,'5','91','643',255,'Sale Id shift 248235',0.00,0.00,0.00,4576.70,0.00,'2021-12-24 07:21:40','',''),(2359083,'5','91','644',255,'Sale Id shift 248235',0.00,0.00,0.00,7619.18,0.00,'2021-12-24 07:21:40','',''),(2359084,'5','91','645',256,'Sale Id shift 248235',0.00,0.00,0.00,638.91,0.00,'2021-12-24 07:21:40','',''),(2359085,'5','91',NULL,255,'Sale Id shift 248235',2012320.20,0.00,0.00,0.00,0.00,'2021-12-24 07:21:40','',''),(2359086,'5','91',NULL,256,'Sale Id shift 248235',220423.95,0.00,0.00,0.00,0.00,'2021-12-24 07:21:40','',''),(2373050,'5','91','643',255,'Sale Id shift 248455',0.00,0.00,0.00,3171.07,0.00,'2021-12-25 14:10:07','',''),(2373051,'5','91','644',255,'Sale Id shift 248455',0.00,0.00,0.00,3316.08,0.00,'2021-12-25 14:10:07','',''),(2373052,'5','91','645',256,'Sale Id shift 248455',0.00,0.00,0.00,456.61,0.00,'2021-12-25 14:10:07','',''),(2373053,'5','91',NULL,255,'Sale Id shift 248455',1070379.75,0.00,0.00,0.00,0.00,'2021-12-25 14:10:07','',''),(2373054,'5','91',NULL,256,'Sale Id shift 248455',157530.45,0.00,0.00,0.00,0.00,'2021-12-25 14:10:07','',''),(2375223,'5','91','643',255,'Sale Id shift 248805',0.00,0.00,0.00,965.01,0.00,'2021-12-26 07:33:11','',''),(2375224,'5','91','644',255,'Sale Id shift 248805',0.00,0.00,0.00,6281.59,0.00,'2021-12-26 07:33:11','',''),(2375225,'5','91','645',256,'Sale Id shift 248805',0.00,0.00,0.00,215.91,0.00,'2021-12-26 07:33:11','',''),(2375226,'5','91',NULL,255,'Sale Id shift 248805',1195689.00,0.00,0.00,0.00,0.00,'2021-12-26 07:33:11','',''),(2375227,'5','91',NULL,256,'Sale Id shift 248805',74488.95,0.00,0.00,0.00,0.00,'2021-12-26 07:33:11','',''),(2379554,'5','91','642',0,'Tank level zero out for dipping',0.00,0.00,0.00,30.52,0.00,'2021-12-26 15:52:53','',''),(2379555,'5','91','642',0,'Inventory adjustment from tank dipping to 500',0.00,0.00,500.00,0.00,0.00,'2021-12-26 15:52:53','',''),(2379560,'5','91','643',0,'Tank level zero out for dipping',0.00,0.00,0.00,1823.85,0.00,'2021-12-26 15:53:24','',''),(2379561,'5','91','643',0,'Inventory adjustment from tank dipping to 2000',0.00,0.00,2000.00,0.00,0.00,'2021-12-26 15:53:24','',''),(2379564,'5','91','644',0,'Tank level zero out for dipping',0.00,0.00,0.00,6418.27,0.00,'2021-12-26 15:53:46','',''),(2379565,'5','91','644',0,'Inventory adjustment from tank dipping to 6500',0.00,0.00,6500.00,0.00,0.00,'2021-12-26 15:53:46','',''),(2381051,'5','91','643',255,'Sale Id shift 248911',0.00,0.00,0.00,1832.08,0.00,'2021-12-27 07:42:45','',''),(2381052,'5','91','644',255,'Sale Id shift 248911',0.00,0.00,0.00,5418.59,0.00,'2021-12-27 07:42:45','',''),(2381053,'5','91','645',256,'Sale Id shift 248911',0.00,0.00,0.00,159.69,0.00,'2021-12-27 07:42:45','',''),(2381054,'5','91',NULL,255,'Sale Id shift 248911',1196360.55,0.00,0.00,0.00,0.00,'2021-12-27 07:42:45','',''),(2381055,'5','91',NULL,256,'Sale Id shift 248911',55093.05,0.00,0.00,0.00,0.00,'2021-12-27 07:42:45','',''),(2387039,'5','91','644',255,'Sale Id shift 249173',0.00,0.00,0.00,1026.25,0.00,'2021-12-28 07:37:33','',''),(2387040,'5','91','645',256,'Sale Id shift 249173',0.00,0.00,0.00,422.79,0.00,'2021-12-28 07:37:33','',''),(2387041,'5','91',NULL,255,'Sale Id shift 249173',169331.25,0.00,0.00,0.00,0.00,'2021-12-28 07:37:33','',''),(2387042,'5','91',NULL,256,'Sale Id shift 249173',145862.55,0.00,0.00,0.00,0.00,'2021-12-28 07:37:33','',''),(2393541,'5','91','645',256,'Sale Id shift 249439',0.00,0.00,0.00,320.02,0.00,'2021-12-29 06:47:12','',''),(2393542,'5','91',NULL,256,'Sale Id shift 249439',110406.90,0.00,0.00,0.00,0.00,'2021-12-29 06:47:12','',''),(2400407,'5','91','645',256,'Sale Id shift 249682',0.00,0.00,0.00,255.80,0.00,'2021-12-30 06:59:14','',''),(2400408,'5','91',NULL,256,'Sale Id shift 249682',88251.00,0.00,0.00,0.00,0.00,'2021-12-30 06:59:14','',''),(2407564,'5','91','645',256,'Sale Id shift 249935',0.00,0.00,0.00,1056.29,0.00,'2021-12-31 06:48:18','',''),(2407565,'5','91',NULL,256,'Sale Id shift 249935',364420.05,0.00,0.00,0.00,0.00,'2021-12-31 06:48:18','',''),(2415224,'5','91','645',256,'Sale Id shift 250156',0.00,0.00,0.00,450.03,0.00,'2022-01-01 07:50:40','',''),(2415225,'5','91',NULL,256,'Sale Id shift 250156',155260.35,0.00,0.00,0.00,0.00,'2022-01-01 07:50:40','',''),(2420893,'5','91','645',256,'Sale Id shift 250380',0.00,0.00,0.00,600.52,0.00,'2022-01-02 06:48:14','',''),(2420894,'5','91',NULL,256,'Sale Id shift 250380',207179.40,0.00,0.00,0.00,0.00,'2022-01-02 06:48:14','',''),(2430359,'5','91','645',256,'Sale Id shift 250634',0.00,0.00,0.00,555.07,0.00,'2022-01-03 14:06:52','',''),(2430360,'5','91',NULL,256,'Sale Id shift 250634',191499.15,0.00,0.00,0.00,0.00,'2022-01-03 14:06:52','',''),(2432723,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9825750.00,59550.00,0.00,0.00,'2022-01-03 21:16:21','',''),(2433272,'5','91','645',256,'Sale Id shift 250977',0.00,0.00,0.00,802.01,0.00,'2022-01-04 07:06:16','',''),(2433273,'5','91',NULL,256,'Sale Id shift 250977',276693.45,0.00,0.00,0.00,0.00,'2022-01-04 07:06:16','',''),(2440392,'5','91',NULL,255,'Reception corrector for bridging 129694',0.00,0.00,0.00,14850.00,0.00,'2022-01-05 05:55:58','',''),(2440393,'5','91','642',255,'Received from bridging 129694',0.00,0.00,14850.00,0.00,0.00,'2022-01-05 05:55:58','',''),(2440394,'5','91',NULL,255,'Reception corrector for bridging 129695',0.00,0.00,0.00,14850.00,0.00,'2022-01-05 05:56:08','',''),(2440395,'5','91','643',255,'Received from bridging 129695',0.00,0.00,14850.00,0.00,0.00,'2022-01-05 05:56:08','',''),(2440396,'5','91',NULL,255,'Reception corrector for bridging 129696',0.00,0.00,0.00,29850.00,0.00,'2022-01-05 05:56:19','',''),(2440397,'5','91','644',255,'Received from bridging 129696',0.00,0.00,29850.00,0.00,0.00,'2022-01-05 05:56:19','',''),(2440955,'5','91','642',255,'Sale Id shift 251117',0.00,0.00,0.00,5106.39,0.00,'2022-01-05 07:36:32','',''),(2440956,'5','91','643',255,'Sale Id shift 251117',0.00,0.00,0.00,4570.08,0.00,'2022-01-05 07:36:32','',''),(2440957,'5','91','644',255,'Sale Id shift 251117',0.00,0.00,0.00,9910.02,0.00,'2022-01-05 07:36:32','',''),(2440958,'5','91','645',256,'Sale Id shift 251117',0.00,0.00,0.00,744.74,0.00,'2022-01-05 07:36:32','',''),(2440959,'5','91',NULL,255,'Sale Id shift 251117',3231770.85,0.00,0.00,0.00,0.00,'2022-01-05 07:36:32','',''),(2440960,'5','91',NULL,256,'Sale Id shift 251117',256935.30,0.00,0.00,0.00,0.00,'2022-01-05 07:36:32','',''),(2448402,'5','91','643',255,'Sale Id shift 251434',0.00,0.00,0.00,3512.70,0.00,'2022-01-06 07:50:34','',''),(2448403,'5','91','644',255,'Sale Id shift 251434',0.00,0.00,0.00,5860.23,0.00,'2022-01-06 07:50:34','',''),(2448404,'5','91','645',256,'Sale Id shift 251434',0.00,0.00,0.00,184.94,0.00,'2022-01-06 07:50:34','',''),(2448405,'5','91',NULL,255,'Sale Id shift 251434',1546533.45,0.00,0.00,0.00,0.00,'2022-01-06 07:50:34','',''),(2448406,'5','91',NULL,256,'Sale Id shift 251434',63804.30,0.00,0.00,0.00,0.00,'2022-01-06 07:50:34','',''),(2456986,'5','91','642',255,'Sale Id shift 251612',0.00,0.00,0.00,3795.16,0.00,'2022-01-07 09:10:44','',''),(2456987,'5','91','643',255,'Sale Id shift 251612',0.00,0.00,0.00,1569.24,0.00,'2022-01-07 09:10:44','',''),(2456988,'5','91','644',255,'Sale Id shift 251612',0.00,0.00,0.00,8531.10,0.00,'2022-01-07 09:10:44','',''),(2456989,'5','91','645',256,'Sale Id shift 251612',0.00,0.00,0.00,323.85,0.00,'2022-01-07 09:10:44','',''),(2456990,'5','91',NULL,255,'Sale Id shift 251612',2292757.50,0.00,0.00,0.00,0.00,'2022-01-07 09:10:44','',''),(2456991,'5','91',NULL,256,'Sale Id shift 251612',111728.25,0.00,0.00,0.00,0.00,'2022-01-07 09:10:44','',''),(2463425,'5','91','642',255,'Sale Id shift 251936',0.00,0.00,0.00,3009.35,0.00,'2022-01-08 07:59:40','',''),(2463426,'5','91','644',255,'Sale Id shift 251936',0.00,0.00,0.00,4967.73,0.00,'2022-01-08 07:59:40','',''),(2463427,'5','91','645',256,'Sale Id shift 251936',0.00,0.00,0.00,159.42,0.00,'2022-01-08 07:59:40','',''),(2463428,'5','91',NULL,255,'Sale Id shift 251936',1316218.20,0.00,0.00,0.00,0.00,'2022-01-08 07:59:40','',''),(2463429,'5','91',NULL,256,'Sale Id shift 251936',54999.90,0.00,0.00,0.00,0.00,'2022-01-08 07:59:40','',''),(2471101,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3168000.00,19200.00,0.00,0.00,'2022-01-08 20:33:11','',''),(2471121,'5','91',NULL,255,'Reception corrector for bridging 130232',0.00,0.00,0.00,19200.00,0.00,'2022-01-08 21:19:08','',''),(2471122,'5','91','644',255,'Received from bridging 130232',0.00,0.00,19200.00,0.00,0.00,'2022-01-08 21:19:08','',''),(2471757,'5','91','642',255,'Sale Id shift 252097',0.00,0.00,0.00,1916.64,0.00,'2022-01-09 08:03:46','',''),(2471758,'5','91','643',255,'Sale Id shift 252097',0.00,0.00,0.00,4223.09,0.00,'2022-01-09 08:03:46','',''),(2471759,'5','91','644',255,'Sale Id shift 252097',0.00,0.00,0.00,5387.19,0.00,'2022-01-09 08:03:46','',''),(2471760,'5','91','645',256,'Sale Id shift 252097',0.00,0.00,0.00,140.01,0.00,'2022-01-09 08:03:46','',''),(2471761,'5','91',NULL,255,'Sale Id shift 252097',1901941.80,0.00,0.00,0.00,0.00,'2022-01-09 08:03:46','',''),(2471762,'5','91',NULL,256,'Sale Id shift 252097',48303.45,0.00,0.00,0.00,0.00,'2022-01-09 08:03:46','',''),(2479490,'5','91','643',255,'Sale Id shift 252323',0.00,0.00,0.00,973.80,0.00,'2022-01-10 07:03:26','',''),(2479491,'5','91','644',255,'Sale Id shift 252323',0.00,0.00,0.00,6917.47,0.00,'2022-01-10 07:03:26','',''),(2479492,'5','91','645',256,'Sale Id shift 252323',0.00,0.00,0.00,158.69,0.00,'2022-01-10 07:03:26','',''),(2479493,'5','91',NULL,255,'Sale Id shift 252323',1302059.55,0.00,0.00,0.00,0.00,'2022-01-10 07:03:26','',''),(2479494,'5','91',NULL,256,'Sale Id shift 252323',54748.05,0.00,0.00,0.00,0.00,'2022-01-10 07:03:26','',''),(2486317,'5','91','642',255,'Sale Id shift 252571',0.00,0.00,0.00,10.00,0.00,'2022-01-11 05:36:00','',''),(2486318,'5','91','644',255,'Sale Id shift 252571',0.00,0.00,0.00,7527.96,0.00,'2022-01-11 05:36:00','',''),(2486319,'5','91','645',256,'Sale Id shift 252571',0.00,0.00,0.00,89.46,0.00,'2022-01-11 05:36:00','',''),(2486320,'5','91',NULL,255,'Sale Id shift 252571',1243763.40,0.00,0.00,0.00,0.00,'2022-01-11 05:36:00','',''),(2486321,'5','91',NULL,256,'Sale Id shift 252571',30863.70,0.00,0.00,0.00,0.00,'2022-01-11 05:36:00','',''),(2494265,'5','91','642',255,'Sale Id shift 252809',0.00,0.00,0.00,964.50,0.00,'2022-01-12 07:50:49','',''),(2494266,'5','91','645',256,'Sale Id shift 252809',0.00,0.00,0.00,200.01,0.00,'2022-01-12 07:50:49','',''),(2494267,'5','91',NULL,255,'Sale Id shift 252809',159142.50,0.00,0.00,0.00,0.00,'2022-01-12 07:50:49','',''),(2494268,'5','91',NULL,256,'Sale Id shift 252809',69003.45,0.00,0.00,0.00,0.00,'2022-01-12 07:50:49','',''),(2501785,'5','91','645',256,'Sale Id shift 253068',0.00,0.00,0.00,283.08,0.00,'2022-01-13 07:36:16','',''),(2501786,'5','91',NULL,256,'Sale Id shift 253068',97662.60,0.00,0.00,0.00,0.00,'2022-01-13 07:36:16','',''),(2510835,'5','91','645',256,'Sale Id shift 253332',0.00,0.00,0.00,255.79,0.00,'2022-01-14 09:42:21','',''),(2510836,'5','91',NULL,256,'Sale Id shift 253332',88247.55,0.00,0.00,0.00,0.00,'2022-01-14 09:42:21','',''),(2519001,'5','91','645',256,'Sale Id shift 253762',0.00,0.00,0.00,296.06,0.00,'2022-01-15 10:31:58','',''),(2519002,'5','91',NULL,256,'Sale Id shift 253762',102140.70,0.00,0.00,0.00,0.00,'2022-01-15 10:31:58','',''),(2525860,'5','91','645',256,'Sale Id shift 253834',0.00,0.00,0.00,264.45,0.00,'2022-01-16 07:23:20','',''),(2525861,'5','91',NULL,256,'Sale Id shift 253834',91235.25,0.00,0.00,0.00,0.00,'2022-01-16 07:23:20','',''),(2534167,'5','91','645',256,'Sale Id shift 254021',0.00,0.00,0.00,288.78,0.00,'2022-01-17 07:15:01','',''),(2534168,'5','91',NULL,256,'Sale Id shift 254021',99629.10,0.00,0.00,0.00,0.00,'2022-01-17 07:15:01','',''),(2541598,'5','91','645',256,'Sale Id shift 254307',0.00,0.00,0.00,180.04,0.00,'2022-01-18 08:40:50','',''),(2541599,'5','91',NULL,256,'Sale Id shift 254307',62113.80,0.00,0.00,0.00,0.00,'2022-01-18 08:40:50','',''),(2550215,'5','91','645',256,'Sale Id shift 254551',0.00,0.00,0.00,144.44,0.00,'2022-01-19 10:07:11','',''),(2550216,'5','91',NULL,256,'Sale Id shift 254551',49831.80,0.00,0.00,0.00,0.00,'2022-01-19 10:07:11','',''),(2560503,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7383750.00,44750.00,0.00,0.00,'2022-01-20 14:07:57','',''),(2563971,'5','91',NULL,255,'Reception corrector for bridging 131498',0.00,0.00,0.00,14950.00,0.00,'2022-01-20 19:16:14','',''),(2563972,'5','91','643',255,'Received from bridging 131498',0.00,0.00,14950.00,0.00,0.00,'2022-01-20 19:16:14','',''),(2563973,'5','91',NULL,255,'Reception corrector for bridging 131497',0.00,0.00,0.00,14850.00,0.00,'2022-01-20 19:16:31','',''),(2563974,'5','91','642',255,'Received from bridging 131497',0.00,0.00,14850.00,0.00,0.00,'2022-01-20 19:16:31','',''),(2563975,'5','91',NULL,255,'Reception corrector for bridging 131499',0.00,0.00,0.00,14950.00,0.00,'2022-01-20 19:16:40','',''),(2563976,'5','91','644',255,'Received from bridging 131499',0.00,0.00,14950.00,0.00,0.00,'2022-01-20 19:16:40','',''),(2565311,'5','91','642',255,'Sale Id shift 255051',0.00,0.00,0.00,1931.80,0.00,'2022-01-21 08:37:19','',''),(2565312,'5','91','643',255,'Sale Id shift 255051',0.00,0.00,0.00,1140.71,0.00,'2022-01-21 08:37:19','',''),(2565313,'5','91','644',255,'Sale Id shift 255051',0.00,0.00,0.00,4737.89,0.00,'2022-01-21 08:37:19','',''),(2565314,'5','91',NULL,255,'Sale Id shift 255051',1288716.00,0.00,0.00,0.00,0.00,'2022-01-21 08:37:19','',''),(2573317,'5','91','642',255,'Sale Id shift 255246',0.00,0.00,0.00,1889.37,0.00,'2022-01-22 08:08:41','',''),(2573318,'5','91','643',255,'Sale Id shift 255246',0.00,0.00,0.00,3934.79,0.00,'2022-01-22 08:08:41','',''),(2573319,'5','91',NULL,255,'Sale Id shift 255246',960986.40,0.00,0.00,0.00,0.00,'2022-01-22 08:08:41','',''),(2581877,'5','91','643',255,'Sale Id shift 255547',0.00,0.00,0.00,1480.07,0.00,'2022-01-23 07:24:36','',''),(2581878,'5','91','644',255,'Sale Id shift 255547',0.00,0.00,0.00,4267.14,0.00,'2022-01-23 07:24:36','',''),(2581879,'5','91',NULL,255,'Sale Id shift 255547',948289.65,0.00,0.00,0.00,0.00,'2022-01-23 07:24:36','',''),(2590601,'5','91','642',255,'Sale Id shift 255817',0.00,0.00,0.00,589.83,0.00,'2022-01-24 08:34:22','',''),(2590602,'5','91','643',255,'Sale Id shift 255817',0.00,0.00,0.00,6028.57,0.00,'2022-01-24 08:34:22','',''),(2590603,'5','91',NULL,255,'Sale Id shift 255817',1092036.00,0.00,0.00,0.00,0.00,'2022-01-24 08:34:22','',''),(2597155,'5','91','642',255,'Sale Id shift 256038',0.00,0.00,0.00,4897.25,0.00,'2022-01-25 07:34:33','',''),(2597156,'5','91',NULL,255,'Sale Id shift 256038',808046.25,0.00,0.00,0.00,0.00,'2022-01-25 07:34:33','',''),(2606187,'5','91','642',255,'Sale Id shift 256310',0.00,0.00,0.00,3539.37,0.00,'2022-01-26 08:09:48','',''),(2606188,'5','91','644',255,'Sale Id shift 256310',0.00,0.00,0.00,594.90,0.00,'2022-01-26 08:09:48','',''),(2606189,'5','91',NULL,255,'Sale Id shift 256310',682154.55,0.00,0.00,0.00,0.00,'2022-01-26 08:09:48','',''),(2612777,'5','91',NULL,257,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2612819,'5','91',NULL,255,'Balance from closing inventory values 2021-11-31 23:59:59',36078894.40,39463214.00,480556.00,459917.66,0.00,'2021-11-30 23:59:59','',''),(2613098,'5','91',NULL,256,'Balance from closing inventory values 2021-11-31 23:59:59',4649517.15,4682700.00,27168.00,27078.56,0.00,'2021-11-30 23:59:59','',''),(2613190,'5','91','644',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,111616.00,97803.06,0.00,'2021-11-30 23:59:59','',''),(2613281,'5','91','643',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,66648.00,66450.16,0.00,'2021-11-30 23:59:59','',''),(2613675,'5','91','645',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,13584.00,13494.56,0.00,'2021-11-30 23:59:59','',''),(2613727,'5','91','646',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613865,'5','91','642',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,62014.00,55386.44,0.00,'2021-11-30 23:59:59','',''),(2614392,'5','91','643',255,'Sale Id shift 256678',0.00,0.00,0.00,2494.48,0.00,'2022-01-27 07:58:20','',''),(2614393,'5','91','644',255,'Sale Id shift 256678',0.00,0.00,0.00,700.00,0.00,'2022-01-27 07:58:20','',''),(2614394,'5','91',NULL,255,'Sale Id shift 256678',527089.20,0.00,0.00,0.00,0.00,'2022-01-27 07:58:20','',''),(2622921,'5','91','644',255,'Sale Id shift 256820',0.00,0.00,0.00,3335.73,0.00,'2022-01-28 07:23:58','',''),(2622922,'5','91',NULL,255,'Sale Id shift 256820',550395.45,0.00,0.00,0.00,0.00,'2022-01-28 07:23:58','',''),(2631621,'5','91','642',255,'Sale Id shift 257149',0.00,0.00,0.00,2048.98,0.00,'2022-01-29 07:52:13','',''),(2631622,'5','91',NULL,255,'Sale Id shift 257149',338081.70,0.00,0.00,0.00,0.00,'2022-01-29 07:52:13','',''),(2640888,'5','91','644',255,'Sale Id shift 257438',0.00,0.00,0.00,1200.00,0.00,'2022-01-30 07:46:00','',''),(2640889,'5','91',NULL,255,'Sale Id shift 257438',198000.00,0.00,0.00,0.00,0.00,'2022-01-30 07:46:00','',''),(2640890,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-02 21:48:56','',''),(2640891,'5','91',NULL,255,'Reception corrector for bridging 131500',0.00,0.00,0.00,14700.00,0.00,'2022-02-02 22:47:43','',''),(2640892,'5','91','643',255,'Received from bridging 131500',0.00,0.00,14700.00,0.00,0.00,'2022-02-02 22:47:43','',''),(2640893,'5','91',NULL,255,'Reception corrector for bridging 131501',0.00,0.00,0.00,15300.00,0.00,'2022-02-02 22:47:57','',''),(2640894,'5','91','644',255,'Received from bridging 131501',0.00,0.00,15300.00,0.00,0.00,'2022-02-02 22:47:57','',''),(2640895,'5','91','643',255,'Sale Id shift 257442',0.00,0.00,0.00,84.85,0.00,'2022-02-03 09:47:02','',''),(2640896,'5','91','644',255,'Sale Id shift 257442',0.00,0.00,0.00,720.12,0.00,'2022-02-03 09:47:02','',''),(2640897,'5','91',NULL,255,'Sale Id shift 257442',132820.05,0.00,0.00,0.00,0.00,'2022-02-03 09:47:02','',''),(2640898,'5','91','643',255,'Sale Id shift 257443',0.00,0.00,0.00,3827.42,0.00,'2022-02-04 06:27:06','',''),(2640899,'5','91','644',255,'Sale Id shift 257443',0.00,0.00,0.00,2205.92,0.00,'2022-02-04 06:27:06','',''),(2640900,'5','91',NULL,255,'Sale Id shift 257443',995501.10,0.00,0.00,0.00,0.00,'2022-02-04 06:27:06','',''),(2640901,'5','91','643',255,'Sale Id shift 257444',0.00,0.00,0.00,2168.10,0.00,'2022-02-05 07:50:43','',''),(2640902,'5','91','644',255,'Sale Id shift 257444',0.00,0.00,0.00,3595.14,0.00,'2022-02-05 07:50:43','',''),(2640903,'5','91',NULL,255,'Sale Id shift 257444',950934.60,0.00,0.00,0.00,0.00,'2022-02-05 07:50:43','',''),(2640904,'5','91','643',255,'Sale Id shift 257445',0.00,0.00,0.00,2769.98,0.00,'2022-02-06 07:46:46','',''),(2640905,'5','91','644',255,'Sale Id shift 257445',0.00,0.00,0.00,2539.76,0.00,'2022-02-06 07:46:46','',''),(2640906,'5','91',NULL,255,'Sale Id shift 257445',876107.10,0.00,0.00,0.00,0.00,'2022-02-06 07:46:46','',''),(2640907,'5','91','643',255,'Sale Id shift 257446',0.00,0.00,0.00,1893.63,0.00,'2022-02-07 07:16:18','',''),(2640908,'5','91','644',255,'Sale Id shift 257446',0.00,0.00,0.00,3370.28,0.00,'2022-02-07 07:16:18','',''),(2640909,'5','91',NULL,255,'Sale Id shift 257446',868545.15,0.00,0.00,0.00,0.00,'2022-02-07 07:16:18','',''),(2640910,'5','91','643',255,'Sale Id shift 257447',0.00,0.00,0.00,3733.97,0.00,'2022-02-08 07:42:22','',''),(2640911,'5','91','644',255,'Sale Id shift 257447',0.00,0.00,0.00,2941.20,0.00,'2022-02-08 07:42:22','',''),(2640912,'5','91',NULL,255,'Sale Id shift 257447',1101403.05,0.00,0.00,0.00,0.00,'2022-02-08 07:42:22','',''),(2640913,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7408500.00,44900.00,0.00,0.00,'2022-02-08 13:24:20','',''),(2640914,'5','91',NULL,255,'Reception corrector for bridging 131502',0.00,0.00,0.00,22500.00,0.00,'2022-02-08 17:57:28','',''),(2640915,'5','91','642',255,'Received from bridging 131502',0.00,0.00,22500.00,0.00,0.00,'2022-02-08 17:57:28','',''),(2640916,'5','91',NULL,255,'Reception corrector for bridging 131503',0.00,0.00,0.00,22400.00,0.00,'2022-02-08 17:57:42','',''),(2640917,'5','91','644',255,'Received from bridging 131503',0.00,0.00,22400.00,0.00,0.00,'2022-02-08 17:57:42','',''),(2640918,'5','91','642',255,'Sale Id shift 257448',0.00,0.00,0.00,2630.51,0.00,'2022-02-09 08:17:41','',''),(2640919,'5','91','643',255,'Sale Id shift 257448',0.00,0.00,0.00,260.00,0.00,'2022-02-09 08:17:41','',''),(2640920,'5','91','644',255,'Sale Id shift 257448',0.00,0.00,0.00,4143.54,0.00,'2022-02-09 08:17:41','',''),(2640921,'5','91',NULL,255,'Sale Id shift 257448',1160618.25,0.00,0.00,0.00,0.00,'2022-02-09 08:17:41','',''),(2640922,'5','91','642',255,'Sale Id shift 257449',0.00,0.00,0.00,5803.90,0.00,'2022-02-10 07:59:51','',''),(2640923,'5','91','644',255,'Sale Id shift 257449',0.00,0.00,0.00,6880.93,0.00,'2022-02-10 07:59:51','',''),(2640924,'5','91',NULL,255,'Sale Id shift 257449',2092996.95,0.00,0.00,0.00,0.00,'2022-02-10 07:59:51','',''),(2640925,'5','91','642',255,'Sale Id shift 257450',0.00,0.00,0.00,3189.90,0.00,'2022-02-11 08:11:31','',''),(2640926,'5','91','644',255,'Sale Id shift 257450',0.00,0.00,0.00,6514.51,0.00,'2022-02-11 08:11:31','',''),(2640927,'5','91',NULL,255,'Sale Id shift 257450',1601227.65,0.00,0.00,0.00,0.00,'2022-02-11 08:11:31','',''),(2640928,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7367250.00,44650.00,0.00,0.00,'2022-02-11 17:38:42','',''),(2640929,'5','91','642',255,'Sale Id shift 257451',0.00,0.00,0.00,3514.28,0.00,'2022-02-12 08:12:35','',''),(2640930,'5','91','644',255,'Sale Id shift 257451',0.00,0.00,0.00,3747.18,0.00,'2022-02-12 08:12:35','',''),(2640931,'5','91',NULL,255,'Sale Id shift 257451',1198140.90,0.00,0.00,0.00,0.00,'2022-02-12 08:12:35','',''),(2640932,'5','91',NULL,255,'Reception corrector for bridging 131505',0.00,0.00,0.00,29650.00,0.00,'2022-02-13 18:51:31','',''),(2640933,'5','91','644',255,'Received from bridging 131505',0.00,0.00,29650.00,0.00,0.00,'2022-02-13 18:51:31','',''),(2640934,'5','91',NULL,255,'Reception corrector for bridging 131504',0.00,0.00,0.00,15000.00,0.00,'2022-02-13 18:51:57','',''),(2640935,'5','91','642',255,'Received from bridging 131504',0.00,0.00,15000.00,0.00,0.00,'2022-02-13 18:51:57','',''),(2640936,'5','91','642',255,'Sale Id shift 257452',0.00,0.00,0.00,3018.90,0.00,'2022-02-13 21:52:43','',''),(2640937,'5','91','644',255,'Sale Id shift 257452',0.00,0.00,0.00,5290.61,0.00,'2022-02-13 21:52:43','',''),(2640938,'5','91',NULL,255,'Sale Id shift 257452',1371069.15,0.00,0.00,0.00,0.00,'2022-02-13 21:52:43','',''),(2640939,'5','91','642',255,'Sale Id shift 257453',0.00,0.00,0.00,4757.13,0.00,'2022-02-14 07:20:21','',''),(2640940,'5','91','644',255,'Sale Id shift 257453',0.00,0.00,0.00,3640.89,0.00,'2022-02-14 07:20:21','',''),(2640941,'5','91',NULL,255,'Sale Id shift 257453',1385673.30,0.00,0.00,0.00,0.00,'2022-02-14 07:20:21','',''),(2640942,'5','91','642',255,'Sale Id shift 257454',0.00,0.00,0.00,6898.90,0.00,'2022-02-15 08:09:43','',''),(2640943,'5','91','644',255,'Sale Id shift 257454',0.00,0.00,0.00,2648.52,0.00,'2022-02-15 08:09:43','',''),(2640944,'5','91',NULL,255,'Sale Id shift 257454',1575324.30,0.00,0.00,0.00,0.00,'2022-02-15 08:09:43','',''),(2640945,'5','91','642',255,'Sale Id shift 257455',0.00,0.00,0.00,3786.08,0.00,'2022-02-16 07:32:16','',''),(2640946,'5','91','644',255,'Sale Id shift 257455',0.00,0.00,0.00,16350.12,0.00,'2022-02-16 07:32:16','',''),(2640947,'5','91',NULL,255,'Sale Id shift 257455',3322473.00,0.00,0.00,0.00,0.00,'2022-02-16 07:32:16','',''),(2640948,'5','91','642',255,'Sale Id shift 257456',0.00,0.00,0.00,4178.06,0.00,'2022-02-17 07:09:05','',''),(2640949,'5','91','644',255,'Sale Id shift 257456',0.00,0.00,0.00,1458.00,0.00,'2022-02-17 07:09:05','',''),(2640950,'5','91',NULL,255,'Sale Id shift 257456',929949.90,0.00,0.00,0.00,0.00,'2022-02-17 07:09:05','',''),(2640951,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,779130.00,4722.00,0.00,0.00,'2022-02-17 16:49:02','',''),(2640952,'5','91',NULL,255,'Reception corrector for bridging 131506',0.00,0.00,0.00,4722.00,0.00,'2022-02-17 16:49:58','',''),(2640953,'5','91','643',255,'Received from bridging 131506',0.00,0.00,4722.00,0.00,0.00,'2022-02-17 16:49:58','',''),(2640954,'5','91','644',255,'Sale Id shift 257457',0.00,0.00,0.00,1002.02,0.00,'2022-02-17 23:36:03','',''),(2640955,'5','91',NULL,255,'Sale Id shift 257457',165333.30,0.00,0.00,0.00,0.00,'2022-02-17 23:36:03','',''),(2640956,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-18 07:22:42','',''),(2640957,'5','91',NULL,255,'Reception corrector for bridging 131507',0.00,0.00,0.00,30000.00,0.00,'2022-02-18 23:14:31','',''),(2640958,'5','91','644',255,'Received from bridging 131507',0.00,0.00,30000.00,0.00,0.00,'2022-02-18 23:14:31','',''),(2640959,'5','91','644',255,'Sale Id shift 257458',0.00,0.00,0.00,6741.53,0.00,'2022-02-19 10:59:05','',''),(2640960,'5','91',NULL,255,'Sale Id shift 257458',1112352.45,0.00,0.00,0.00,0.00,'2022-02-19 10:59:05','',''),(2640961,'5','91','644',255,'Sale Id shift 257459',0.00,0.00,0.00,8835.19,0.00,'2022-02-20 07:21:18','',''),(2640962,'5','91',NULL,255,'Sale Id shift 257459',1457806.35,0.00,0.00,0.00,0.00,'2022-02-20 07:21:18','',''),(2640963,'5','91','644',255,'Sale Id shift 257460',0.00,0.00,0.00,7109.05,0.00,'2022-02-21 07:24:59','',''),(2640964,'5','91',NULL,255,'Sale Id shift 257460',1172993.25,0.00,0.00,0.00,0.00,'2022-02-21 07:24:59','',''),(2640965,'5','91','644',255,'Sale Id shift 257461',0.00,0.00,0.00,6671.58,0.00,'2022-02-22 06:42:50','',''),(2640966,'5','91',NULL,255,'Sale Id shift 257461',1100810.70,0.00,0.00,0.00,0.00,'2022-02-22 06:42:50','',''),(2640967,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7425000.00,45000.00,0.00,0.00,'2022-02-22 15:50:26','',''),(2640968,'5','91',NULL,255,'Reception corrector for bridging 131508',0.00,0.00,0.00,22150.00,0.00,'2022-02-22 20:12:35','',''),(2640969,'5','91','642',255,'Received from bridging 131508',0.00,0.00,22150.00,0.00,0.00,'2022-02-22 20:12:35','',''),(2640970,'5','91',NULL,255,'Reception corrector for bridging 131509',0.00,0.00,0.00,22850.00,0.00,'2022-02-22 20:12:51','',''),(2640971,'5','91','644',255,'Received from bridging 131509',0.00,0.00,22850.00,0.00,0.00,'2022-02-22 20:12:51','',''),(2640972,'5','91','642',255,'Sale Id shift 257462',0.00,0.00,0.00,7513.25,0.00,'2022-02-23 07:02:07','',''),(2640973,'5','91','644',255,'Sale Id shift 257462',0.00,0.00,0.00,8478.95,0.00,'2022-02-23 07:02:07','',''),(2640974,'5','91',NULL,255,'Sale Id shift 257462',2638713.00,0.00,0.00,0.00,0.00,'2022-02-23 07:02:07','',''),(2640975,'5','91','642',255,'Sale Id shift 257463',0.00,0.00,0.00,2365.93,0.00,'2022-02-24 09:37:49','',''),(2640976,'5','91','644',255,'Sale Id shift 257463',0.00,0.00,0.00,3690.74,0.00,'2022-02-24 09:37:49','',''),(2640977,'5','91',NULL,255,'Sale Id shift 257463',999350.55,0.00,0.00,0.00,0.00,'2022-02-24 09:37:49','',''),(2640978,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3712500.00,22500.00,0.00,0.00,'2022-02-24 15:27:02','',''),(2640979,'5','91','642',255,'Sale Id shift 257464',0.00,0.00,0.00,3023.20,0.00,'2022-02-25 08:10:48','',''),(2640980,'5','91','643',255,'Sale Id shift 257464',0.00,0.00,0.00,2049.53,0.00,'2022-02-25 08:10:48','',''),(2640981,'5','91','644',255,'Sale Id shift 257464',0.00,0.00,0.00,1617.34,0.00,'2022-02-25 08:10:48','',''),(2640982,'5','91',NULL,255,'Sale Id shift 257464',1103861.55,0.00,0.00,0.00,0.00,'2022-02-25 08:10:48','',''),(2640983,'5','91',NULL,255,'Reception corrector for bridging 131510',0.00,0.00,0.00,22500.00,0.00,'2022-02-25 22:39:45','',''),(2640984,'5','91','643',255,'Received from bridging 131510',0.00,0.00,22500.00,0.00,0.00,'2022-02-25 22:39:45','',''),(2640985,'5','91','642',255,'Sale Id shift 257465',0.00,0.00,0.00,1644.50,0.00,'2022-02-26 07:19:44','',''),(2640986,'5','91','643',255,'Sale Id shift 257465',0.00,0.00,0.00,5236.94,0.00,'2022-02-26 07:19:44','',''),(2640987,'5','91','644',255,'Sale Id shift 257465',0.00,0.00,0.00,1426.98,0.00,'2022-02-26 07:19:44','',''),(2640988,'5','91',NULL,255,'Sale Id shift 257465',1370889.30,0.00,0.00,0.00,0.00,'2022-02-26 07:19:44','',''),(2640989,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2466750.00,14950.00,0.00,0.00,'2022-02-26 22:44:03','',''),(2640990,'5','91','642',255,'Sale Id shift 257466',0.00,0.00,0.00,4331.28,0.00,'2022-02-27 07:02:17','',''),(2640991,'5','91','643',255,'Sale Id shift 257466',0.00,0.00,0.00,4799.22,0.00,'2022-02-27 07:02:17','',''),(2640992,'5','91','644',255,'Sale Id shift 257466',0.00,0.00,0.00,6776.32,0.00,'2022-02-27 07:02:17','',''),(2640993,'5','91',NULL,255,'Sale Id shift 257466',2624625.30,0.00,0.00,0.00,0.00,'2022-02-27 07:02:17','',''),(2640994,'5','91',NULL,255,'Reception corrector for bridging 131511',0.00,0.00,0.00,14950.00,0.00,'2022-02-28 10:19:44','',''),(2640995,'5','91','644',255,'Received from bridging 131511',0.00,0.00,14950.00,0.00,0.00,'2022-02-28 10:19:44','',''),(2640996,'5','91','642',255,'Sale Id shift 257467',0.00,0.00,0.00,3475.99,0.00,'2022-02-28 19:59:35','',''),(2640997,'5','91','643',255,'Sale Id shift 257467',0.00,0.00,0.00,6996.59,0.00,'2022-02-28 19:59:35','',''),(2640998,'5','91','644',255,'Sale Id shift 257467',0.00,0.00,0.00,8414.94,0.00,'2022-02-28 19:59:35','',''),(2640999,'5','91',NULL,255,'Sale Id shift 257467',3116440.80,0.00,0.00,0.00,0.00,'2022-02-28 19:59:35','',''),(2641000,'5','91','643',255,'Sale Id shift 257468',0.00,0.00,0.00,3293.89,0.00,'2022-03-01 06:54:28','',''),(2641001,'5','91','644',255,'Sale Id shift 257468',0.00,0.00,0.00,6087.15,0.00,'2022-03-01 06:54:28','',''),(2641002,'5','91',NULL,255,'Sale Id shift 257468',1547871.60,0.00,0.00,0.00,0.00,'2022-03-01 06:54:28','',''),(2641003,'5','91','644',255,'Sale Id shift 257469',0.00,0.00,0.00,1957.25,0.00,'2022-03-02 08:19:06','',''),(2641004,'5','91',NULL,255,'Sale Id shift 257469',322946.25,0.00,0.00,0.00,0.00,'2022-03-02 08:19:06','',''),(2641005,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7400250.00,44850.00,0.00,0.00,'2022-03-09 13:01:48','',''),(2641006,'5','91',NULL,255,'Reception corrector for bridging 131514',0.00,0.00,0.00,15050.00,0.00,'2022-03-09 20:09:53','',''),(2641007,'5','91','644',255,'Received from bridging 131514',0.00,0.00,15050.00,0.00,0.00,'2022-03-09 20:09:53','',''),(2641008,'5','91',NULL,255,'Reception corrector for bridging 131512',0.00,0.00,0.00,14750.00,0.00,'2022-03-09 20:10:06','',''),(2641009,'5','91','642',255,'Received from bridging 131512',0.00,0.00,14750.00,0.00,0.00,'2022-03-09 20:10:06','',''),(2641010,'5','91',NULL,255,'Reception corrector for bridging 131513',0.00,0.00,0.00,15050.00,0.00,'2022-03-09 20:10:49','',''),(2641011,'5','91','643',255,'Received from bridging 131513',0.00,0.00,15050.00,0.00,0.00,'2022-03-09 20:10:49','',''),(2641012,'5','91','644',255,'Sale Id shift 257476',0.00,0.00,0.00,1143.01,0.00,'2022-03-09 21:04:17','',''),(2641013,'5','91',NULL,255,'Sale Id shift 257476',188596.65,0.00,0.00,0.00,0.00,'2022-03-09 21:04:17','',''),(2641014,'5','91','642',255,'Sale Id shift 257477',0.00,0.00,0.00,2156.98,0.00,'2022-03-10 06:39:19','',''),(2641015,'5','91','644',255,'Sale Id shift 257477',0.00,0.00,0.00,3007.33,0.00,'2022-03-10 06:39:19','',''),(2641016,'5','91',NULL,255,'Sale Id shift 257477',852111.15,0.00,0.00,0.00,0.00,'2022-03-10 06:39:19','',''),(2641017,'5','91','642',255,'Sale Id shift 257478',0.00,0.00,0.00,1968.91,0.00,'2022-03-11 08:24:49','',''),(2641018,'5','91','643',255,'Sale Id shift 257478',0.00,0.00,0.00,3763.94,0.00,'2022-03-11 08:24:49','',''),(2641019,'5','91','644',255,'Sale Id shift 257478',0.00,0.00,0.00,275.58,0.00,'2022-03-11 08:24:49','',''),(2641020,'5','91',NULL,255,'Sale Id shift 257478',991390.95,0.00,0.00,0.00,0.00,'2022-03-11 08:24:49','',''),(2641021,'5','91','642',255,'Sale Id shift 257479',0.00,0.00,0.00,1775.71,0.00,'2022-03-12 07:56:21','',''),(2641022,'5','91','643',255,'Sale Id shift 257479',0.00,0.00,0.00,933.95,0.00,'2022-03-12 07:56:21','',''),(2641023,'5','91','644',255,'Sale Id shift 257479',0.00,0.00,0.00,4046.80,0.00,'2022-03-12 07:56:21','',''),(2641024,'5','91',NULL,255,'Sale Id shift 257479',1114815.90,0.00,0.00,0.00,0.00,'2022-03-12 07:56:21','',''),(2641025,'5','91','643',255,'Sale Id shift 257480',0.00,0.00,0.00,3720.34,0.00,'2022-03-13 08:06:47','',''),(2641026,'5','91','644',255,'Sale Id shift 257480',0.00,0.00,0.00,3943.85,0.00,'2022-03-13 08:06:47','',''),(2641027,'5','91',NULL,255,'Sale Id shift 257480',1264591.35,0.00,0.00,0.00,0.00,'2022-03-13 08:06:47','',''),(2641028,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,6600000.00,40000.00,0.00,0.00,'2022-03-13 14:03:27','',''),(2641029,'5','91',NULL,255,'Reception corrector for bridging 131515',0.00,0.00,0.00,14020.00,0.00,'2022-03-13 19:04:54','',''),(2641030,'5','91','643',255,'Received from bridging 131515',0.00,0.00,14020.00,0.00,0.00,'2022-03-13 19:04:54','',''),(2641031,'5','91',NULL,255,'Reception corrector for bridging 131516',0.00,0.00,0.00,25980.00,0.00,'2022-03-13 19:05:07','',''),(2641032,'5','91','644',255,'Received from bridging 131516',0.00,0.00,25980.00,0.00,0.00,'2022-03-13 19:05:07','',''),(2641033,'5','91','643',255,'Sale Id shift 257481',0.00,0.00,0.00,3905.41,0.00,'2022-03-14 07:06:25','',''),(2641034,'5','91','644',255,'Sale Id shift 257481',0.00,0.00,0.00,4239.82,0.00,'2022-03-14 07:06:25','',''),(2641035,'5','91',NULL,255,'Sale Id shift 257481',1343962.95,0.00,0.00,0.00,0.00,'2022-03-14 07:06:25','',''),(2641036,'5','91','643',255,'Sale Id shift 257482',0.00,0.00,0.00,3526.42,0.00,'2022-03-15 07:07:50','',''),(2641037,'5','91','644',255,'Sale Id shift 257482',0.00,0.00,0.00,4311.36,0.00,'2022-03-15 07:07:50','',''),(2641038,'5','91',NULL,255,'Sale Id shift 257482',1293233.70,0.00,0.00,0.00,0.00,'2022-03-15 07:07:50','',''),(2641039,'5','91','642',255,'Sale Id shift 257483',0.00,0.00,0.00,378.80,0.00,'2022-03-16 08:09:51','',''),(2641040,'5','91','643',255,'Sale Id shift 257483',0.00,0.00,0.00,3338.21,0.00,'2022-03-16 08:09:51','',''),(2641041,'5','91','644',255,'Sale Id shift 257483',0.00,0.00,0.00,4371.67,0.00,'2022-03-16 08:09:51','',''),(2641042,'5','91',NULL,255,'Sale Id shift 257483',1334632.20,0.00,0.00,0.00,0.00,'2022-03-16 08:09:51','',''),(2641043,'5','91','642',255,'Sale Id shift 257484',0.00,0.00,0.00,694.20,0.00,'2022-03-17 10:22:24','',''),(2641044,'5','91','643',255,'Sale Id shift 257484',0.00,0.00,0.00,3983.46,0.00,'2022-03-17 10:22:24','',''),(2641045,'5','91','644',255,'Sale Id shift 257484',0.00,0.00,0.00,4655.39,0.00,'2022-03-17 10:22:24','',''),(2641046,'5','91',NULL,255,'Sale Id shift 257484',1539953.25,0.00,0.00,0.00,0.00,'2022-03-17 10:22:24','',''),(2641047,'5','91','642',255,'Sale Id shift 257485',0.00,0.00,0.00,1905.16,0.00,'2022-03-18 07:47:19','',''),(2641048,'5','91','643',255,'Sale Id shift 257485',0.00,0.00,0.00,538.50,0.00,'2022-03-18 07:47:19','',''),(2641049,'5','91','644',255,'Sale Id shift 257485',0.00,0.00,0.00,2744.10,0.00,'2022-03-18 07:47:19','',''),(2641050,'5','91',NULL,255,'Sale Id shift 257485',855980.40,0.00,0.00,0.00,0.00,'2022-03-18 07:47:19','',''),(2641051,'5','91','642',255,'Sale Id shift 257486',0.00,0.00,0.00,2042.09,0.00,'2022-03-19 07:00:41','',''),(2641052,'5','91','643',255,'Sale Id shift 257486',0.00,0.00,0.00,616.06,0.00,'2022-03-19 07:00:41','',''),(2641053,'5','91','644',255,'Sale Id shift 257486',0.00,0.00,0.00,2809.61,0.00,'2022-03-19 07:00:41','',''),(2641054,'5','91',NULL,255,'Sale Id shift 257486',902180.40,0.00,0.00,0.00,0.00,'2022-03-19 07:00:41','',''),(2641055,'5','91','642',255,'Sale Id shift 257487',0.00,0.00,0.00,1532.24,0.00,'2022-03-20 07:31:00','',''),(2641056,'5','91','643',255,'Sale Id shift 257487',0.00,0.00,0.00,381.97,0.00,'2022-03-20 07:31:00','',''),(2641057,'5','91','644',255,'Sale Id shift 257487',0.00,0.00,0.00,2118.89,0.00,'2022-03-20 07:31:00','',''),(2641058,'5','91',NULL,255,'Sale Id shift 257487',665461.50,0.00,0.00,0.00,0.00,'2022-03-20 07:31:00','',''),(2641059,'5','91','643',255,'Sale Id shift 257488',0.00,0.00,0.00,628.30,0.00,'2022-03-21 06:32:57','',''),(2641060,'5','91','644',255,'Sale Id shift 257488',0.00,0.00,0.00,3376.14,0.00,'2022-03-21 06:32:57','',''),(2641061,'5','91',NULL,255,'Sale Id shift 257488',660732.60,0.00,0.00,0.00,0.00,'2022-03-21 06:32:57','',''),(2641062,'5','91','643',255,'Sale Id shift 257489',0.00,0.00,0.00,3861.87,0.00,'2022-03-22 07:06:25','',''),(2641063,'5','91',NULL,255,'Sale Id shift 257489',637208.55,0.00,0.00,0.00,0.00,'2022-03-22 07:06:25','',''),(2641064,'5','91','642',255,'Sale Id shift 257490',0.00,0.00,0.00,2256.76,0.00,'2022-03-23 06:33:06','',''),(2641065,'5','91',NULL,255,'Sale Id shift 257490',372365.40,0.00,0.00,0.00,0.00,'2022-03-23 06:33:06','',''),(2641066,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-04-19 22:44:12','',''),(2641067,'5','91',NULL,255,'Reception corrector for bridging 131517',0.00,0.00,0.00,24000.00,0.00,'2022-04-20 07:26:19','',''),(2641068,'5','91','643',255,'Received from bridging 131517',0.00,0.00,24000.00,0.00,0.00,'2022-04-20 07:26:19','',''),(2641069,'5','91',NULL,255,'Reception corrector for bridging 131518',0.00,0.00,0.00,26000.00,0.00,'2022-04-20 07:26:30','',''),(2641070,'5','91','644',255,'Received from bridging 131518',0.00,0.00,26000.00,0.00,0.00,'2022-04-20 07:26:30','',''),(2641071,'5','91','644',255,'Sale Id shift 257518',0.00,0.00,0.00,625.03,0.00,'2022-04-20 10:10:25','',''),(2641072,'5','91',NULL,255,'Sale Id shift 257518',103129.95,0.00,0.00,0.00,0.00,'2022-04-20 10:10:25','',''),(2641073,'5','91','643',255,'Sale Id shift 257519',0.00,0.00,0.00,402.99,0.00,'2022-04-21 08:54:17','',''),(2641074,'5','91','644',255,'Sale Id shift 257519',0.00,0.00,0.00,4318.02,0.00,'2022-04-21 08:54:17','',''),(2641075,'5','91',NULL,255,'Sale Id shift 257519',778966.65,0.00,0.00,0.00,0.00,'2022-04-21 08:54:17','',''),(2641076,'5','91','643',255,'Sale Id shift 257520',0.00,0.00,0.00,1893.46,0.00,'2022-04-22 09:25:56','',''),(2641077,'5','91','644',255,'Sale Id shift 257520',0.00,0.00,0.00,3493.47,0.00,'2022-04-22 09:25:56','',''),(2641078,'5','91',NULL,255,'Sale Id shift 257520',888843.45,0.00,0.00,0.00,0.00,'2022-04-22 09:25:56','',''),(2641079,'5','91','643',255,'Sale Id shift 257521',0.00,0.00,0.00,3074.82,0.00,'2022-04-23 09:25:39','',''),(2641080,'5','91','644',255,'Sale Id shift 257521',0.00,0.00,0.00,2389.20,0.00,'2022-04-23 09:25:39','',''),(2641081,'5','91',NULL,255,'Sale Id shift 257521',901563.30,0.00,0.00,0.00,0.00,'2022-04-23 09:25:39','',''),(2641082,'5','91','643',255,'Sale Id shift 257522',0.00,0.00,0.00,3632.27,0.00,'2022-04-23 22:07:50','',''),(2641083,'5','91','644',255,'Sale Id shift 257522',0.00,0.00,0.00,1812.53,0.00,'2022-04-23 22:07:50','',''),(2641084,'5','91',NULL,255,'Sale Id shift 257522',898392.00,0.00,0.00,0.00,0.00,'2022-04-23 22:07:50','',''),(2641085,'5','91','643',255,'Sale Id shift 257523',0.00,0.00,0.00,4040.66,0.00,'2022-04-25 04:53:05','',''),(2641086,'5','91','644',255,'Sale Id shift 257523',0.00,0.00,0.00,1820.29,0.00,'2022-04-25 04:53:05','',''),(2641087,'5','91',NULL,255,'Sale Id shift 257523',967056.75,0.00,0.00,0.00,0.00,'2022-04-25 04:53:05','',''),(2641088,'5','91','643',255,'Sale Id shift 257524',0.00,0.00,0.00,3332.47,0.00,'2022-04-26 07:34:43','',''),(2641089,'5','91','644',255,'Sale Id shift 257524',0.00,0.00,0.00,704.44,0.00,'2022-04-26 07:34:43','',''),(2641090,'5','91',NULL,255,'Sale Id shift 257524',666090.15,0.00,0.00,0.00,0.00,'2022-04-26 07:34:43','',''),(2641091,'5','91','643',255,'Sale Id shift 257525',0.00,0.00,0.00,1077.17,0.00,'2022-04-27 05:39:27','',''),(2641092,'5','91','644',255,'Sale Id shift 257525',0.00,0.00,0.00,3069.75,0.00,'2022-04-27 05:39:27','',''),(2641093,'5','91',NULL,255,'Sale Id shift 257525',684241.80,0.00,0.00,0.00,0.00,'2022-04-27 05:39:27','',''),(2641094,'5','91','643',255,'Sale Id shift 257526',0.00,0.00,0.00,3792.13,0.00,'2022-04-28 07:33:08','',''),(2641095,'5','91','644',255,'Sale Id shift 257526',0.00,0.00,0.00,1676.26,0.00,'2022-04-28 07:33:08','',''),(2641096,'5','91',NULL,255,'Sale Id shift 257526',902284.35,0.00,0.00,0.00,0.00,'2022-04-28 07:33:08','',''),(2641097,'5','91','644',255,'Sale Id shift 257527',0.00,0.00,0.00,4007.78,0.00,'2022-04-29 05:58:33','',''),(2641098,'5','91',NULL,255,'Sale Id shift 257527',661283.70,0.00,0.00,0.00,0.00,'2022-04-29 05:58:33','',''),(2641099,'5','91','643',255,'Sale Id shift 257528',0.00,0.00,0.00,2980.19,0.00,'2022-05-09 10:22:52','',''),(2641100,'5','91','644',255,'Sale Id shift 257528',0.00,0.00,0.00,816.61,0.00,'2022-05-09 10:22:52','',''),(2641101,'5','91',NULL,255,'Sale Id shift 257528',626472.00,0.00,0.00,0.00,0.00,'2022-05-09 10:22:52','',''),(2641102,'5','91','644',255,'Sale Id shift 257529',0.00,0.00,0.00,1055.39,0.00,'2022-05-09 12:40:04','',''),(2641103,'5','91',NULL,255,'Sale Id shift 257529',174139.35,0.00,0.00,0.00,0.00,'2022-05-09 12:40:04','',''),(2641104,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-09 13:58:23','',''),(2641105,'5','91',NULL,255,'Reception corrector for bridging 131520',0.00,0.00,0.00,26000.00,0.00,'2022-05-09 15:27:42','',''),(2641106,'5','91','644',255,'Received from bridging 131520',0.00,0.00,26000.00,0.00,0.00,'2022-05-09 15:27:42','',''),(2641107,'5','91',NULL,255,'Reception corrector for bridging 131519',0.00,0.00,0.00,24000.00,0.00,'2022-05-09 15:27:52','',''),(2641108,'5','91','643',255,'Received from bridging 131519',0.00,0.00,24000.00,0.00,0.00,'2022-05-09 15:27:52','',''),(2641109,'5','91','644',255,'Sale Id shift 257532',0.00,0.00,0.00,900.03,0.00,'2022-05-09 15:39:36','',''),(2641110,'5','91',NULL,255,'Sale Id shift 257532',148504.95,0.00,0.00,0.00,0.00,'2022-05-09 15:39:36','',''),(2641111,'5','91','643',255,'Sale Id shift 257533',0.00,0.00,0.00,3643.46,0.00,'2022-05-09 15:43:56','',''),(2641112,'5','91','644',255,'Sale Id shift 257533',0.00,0.00,0.00,1165.40,0.00,'2022-05-09 15:43:56','',''),(2641113,'5','91',NULL,255,'Sale Id shift 257533',793461.90,0.00,0.00,0.00,0.00,'2022-05-09 15:43:56','',''),(2641114,'5','91','643',255,'Sale Id shift 257534',0.00,0.00,0.00,2656.60,0.00,'2022-05-09 15:48:20','',''),(2641115,'5','91','644',255,'Sale Id shift 257534',0.00,0.00,0.00,1628.44,0.00,'2022-05-09 15:48:20','',''),(2641116,'5','91',NULL,255,'Sale Id shift 257534',707031.60,0.00,0.00,0.00,0.00,'2022-05-09 15:48:20','',''),(2641117,'5','91','643',255,'Sale Id shift 257535',0.00,0.00,0.00,2067.12,0.00,'2022-05-09 15:55:50','',''),(2641118,'5','91','644',255,'Sale Id shift 257535',0.00,0.00,0.00,2865.19,0.00,'2022-05-09 15:55:50','',''),(2641119,'5','91',NULL,255,'Sale Id shift 257535',813831.15,0.00,0.00,0.00,0.00,'2022-05-09 15:55:50','',''),(2641120,'5','91','643',255,'Sale Id shift 257536',0.00,0.00,0.00,3106.79,0.00,'2022-05-09 16:17:00','',''),(2641121,'5','91','644',255,'Sale Id shift 257536',0.00,0.00,0.00,1591.65,0.00,'2022-05-09 16:17:00','',''),(2641122,'5','91',NULL,255,'Sale Id shift 257536',775242.60,0.00,0.00,0.00,0.00,'2022-05-09 16:17:00','',''),(2641123,'5','91','643',255,'Sale Id shift 257537',0.00,0.00,0.00,2326.62,0.00,'2022-05-09 16:38:04','',''),(2641124,'5','91','644',255,'Sale Id shift 257537',0.00,0.00,0.00,2694.45,0.00,'2022-05-09 16:38:04','',''),(2641125,'5','91',NULL,255,'Sale Id shift 257537',828476.55,0.00,0.00,0.00,0.00,'2022-05-09 16:38:04','',''),(2641126,'5','91','643',255,'Sale Id shift 257538',0.00,0.00,0.00,3454.54,0.00,'2022-05-10 08:57:12','',''),(2641127,'5','91','644',255,'Sale Id shift 257538',0.00,0.00,0.00,1877.42,0.00,'2022-05-10 08:57:12','',''),(2641128,'5','91',NULL,255,'Sale Id shift 257538',879773.40,0.00,0.00,0.00,0.00,'2022-05-10 08:57:12','',''),(2641129,'5','91','643',255,'Sale Id shift 257539',0.00,0.00,0.00,3194.02,0.00,'2022-05-11 05:34:16','',''),(2641130,'5','91','644',255,'Sale Id shift 257539',0.00,0.00,0.00,2102.76,0.00,'2022-05-11 05:34:16','',''),(2641131,'5','91',NULL,255,'Sale Id shift 257539',873968.70,0.00,0.00,0.00,0.00,'2022-05-11 05:34:16','',''),(2641132,'5','91','643',255,'Sale Id shift 257540',0.00,0.00,0.00,2647.84,0.00,'2022-05-12 08:27:09','',''),(2641133,'5','91','644',255,'Sale Id shift 257540',0.00,0.00,0.00,2193.72,0.00,'2022-05-12 08:27:09','',''),(2641134,'5','91',NULL,255,'Sale Id shift 257540',798857.40,0.00,0.00,0.00,0.00,'2022-05-12 08:27:09','',''),(2641135,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-13 09:53:14','',''),(2641136,'5','91','643',255,'Sale Id shift 257541',0.00,0.00,0.00,3734.86,0.00,'2022-05-13 09:53:31','',''),(2641137,'5','91','644',255,'Sale Id shift 257541',0.00,0.00,0.00,1525.56,0.00,'2022-05-13 09:53:31','',''),(2641138,'5','91',NULL,255,'Sale Id shift 257541',867969.30,0.00,0.00,0.00,0.00,'2022-05-13 09:53:31','',''),(2641139,'5','91',NULL,255,'Reception corrector for bridging 131521',0.00,0.00,0.00,2200.00,0.00,'2022-05-13 11:58:37','',''),(2641140,'5','91','642',255,'Received from bridging 131521',0.00,0.00,2200.00,0.00,0.00,'2022-05-13 11:58:37','',''),(2641141,'5','91',NULL,255,'Reception corrector for bridging 131522',0.00,0.00,0.00,24950.00,0.00,'2022-05-13 11:58:45','',''),(2641142,'5','91','643',255,'Received from bridging 131522',0.00,0.00,24950.00,0.00,0.00,'2022-05-13 11:58:45','',''),(2641143,'5','91',NULL,255,'Reception corrector for bridging 131523',0.00,0.00,0.00,22850.00,0.00,'2022-05-13 11:58:54','',''),(2641144,'5','91','644',255,'Received from bridging 131523',0.00,0.00,22850.00,0.00,0.00,'2022-05-13 11:58:54','',''),(2641145,'5','91','643',255,'Sale Id shift 257542',0.00,0.00,0.00,2246.40,0.00,'2022-05-14 14:28:06','',''),(2641146,'5','91','644',255,'Sale Id shift 257542',0.00,0.00,0.00,3275.68,0.00,'2022-05-14 14:28:06','',''),(2641147,'5','91',NULL,255,'Sale Id shift 257542',911143.20,0.00,0.00,0.00,0.00,'2022-05-14 14:28:06','',''),(2641148,'5','91','643',255,'Sale Id shift 257543',0.00,0.00,0.00,2307.48,0.00,'2022-05-14 22:45:13','',''),(2641149,'5','91','644',255,'Sale Id shift 257543',0.00,0.00,0.00,3488.44,0.00,'2022-05-14 22:45:13','',''),(2641150,'5','91',NULL,255,'Sale Id shift 257543',956326.80,0.00,0.00,0.00,0.00,'2022-05-14 22:45:13','',''),(2641151,'5','91','643',255,'Sale Id shift 257544',0.00,0.00,0.00,1681.48,0.00,'2022-05-15 22:50:49','',''),(2641152,'5','91','644',255,'Sale Id shift 257544',0.00,0.00,0.00,3377.61,0.00,'2022-05-15 22:50:49','',''),(2641153,'5','91',NULL,255,'Sale Id shift 257544',834749.85,0.00,0.00,0.00,0.00,'2022-05-15 22:50:49','',''),(2641154,'5','91','643',255,'Sale Id shift 257545',0.00,0.00,0.00,2683.20,0.00,'2022-05-17 06:53:37','',''),(2641155,'5','91','644',255,'Sale Id shift 257545',0.00,0.00,0.00,2917.05,0.00,'2022-05-17 06:53:37','',''),(2641156,'5','91',NULL,255,'Sale Id shift 257545',924041.25,0.00,0.00,0.00,0.00,'2022-05-17 06:53:37','',''),(2641157,'5','91','643',255,'Sale Id shift 257546',0.00,0.00,0.00,3657.53,0.00,'2022-05-18 07:11:59','',''),(2641158,'5','91','644',255,'Sale Id shift 257546',0.00,0.00,0.00,1705.80,0.00,'2022-05-18 07:11:59','',''),(2641159,'5','91',NULL,255,'Sale Id shift 257546',884949.45,0.00,0.00,0.00,0.00,'2022-05-18 07:11:59','',''),(2641160,'5','91','642',255,'Sale Id shift 257547',0.00,0.00,0.00,279.78,0.00,'2022-05-19 06:17:31','',''),(2641161,'5','91','643',255,'Sale Id shift 257547',0.00,0.00,0.00,1849.76,0.00,'2022-05-19 06:17:31','',''),(2641162,'5','91','644',255,'Sale Id shift 257547',0.00,0.00,0.00,2899.26,0.00,'2022-05-19 06:17:31','',''),(2641163,'5','91',NULL,255,'Sale Id shift 257547',829752.00,0.00,0.00,0.00,0.00,'2022-05-19 06:17:31','',''),(2641164,'5','91','643',255,'Sale Id shift 257548',0.00,0.00,0.00,3235.53,0.00,'2022-05-19 22:35:25','',''),(2641165,'5','91','644',255,'Sale Id shift 257548',0.00,0.00,0.00,1902.80,0.00,'2022-05-19 22:35:25','',''),(2641166,'5','91',NULL,255,'Sale Id shift 257548',847824.45,0.00,0.00,0.00,0.00,'2022-05-19 22:35:25','',''),(2641167,'5','91','642',255,'Sale Id shift 257549',0.00,0.00,0.00,191.72,0.00,'2022-05-21 05:48:55','',''),(2641168,'5','91','643',255,'Sale Id shift 257549',0.00,0.00,0.00,2198.57,0.00,'2022-05-21 05:48:55','',''),(2641169,'5','91','644',255,'Sale Id shift 257549',0.00,0.00,0.00,2783.04,0.00,'2022-05-21 05:48:55','',''),(2641170,'5','91',NULL,255,'Sale Id shift 257549',853599.45,0.00,0.00,0.00,0.00,'2022-05-21 05:48:55','',''),(2641171,'5','91','643',255,'Sale Id shift 257550',0.00,0.00,0.00,1964.50,0.00,'2022-05-21 22:38:39','',''),(2641172,'5','91','644',255,'Sale Id shift 257550',0.00,0.00,0.00,3265.34,0.00,'2022-05-21 22:38:39','',''),(2641173,'5','91',NULL,255,'Sale Id shift 257550',862923.60,0.00,0.00,0.00,0.00,'2022-05-21 22:38:39','',''),(2641174,'5','91','644',255,'Sale Id shift 257551',0.00,0.00,0.00,4907.98,0.00,'2022-05-23 05:41:01','',''),(2641175,'5','91',NULL,255,'Sale Id shift 257551',809816.70,0.00,0.00,0.00,0.00,'2022-05-23 05:41:01','',''),(2641176,'5','91','642',255,'Sale Id shift 257552',0.00,0.00,0.00,1445.64,0.00,'2022-05-24 06:46:39','',''),(2641177,'5','91','644',255,'Sale Id shift 257552',0.00,0.00,0.00,390.01,0.00,'2022-05-24 06:46:39','',''),(2641178,'5','91',NULL,255,'Sale Id shift 257552',302882.25,0.00,0.00,0.00,0.00,'2022-05-24 06:46:39','',''),(2641179,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8250000.00,50000.00,0.00,0.00,'2022-05-28 06:55:54','',''),(2641180,'5','91',NULL,255,'Reception corrector for bridging 131524',0.00,0.00,0.00,24200.00,0.00,'2022-05-28 10:36:50','',''),(2641181,'5','91','642',255,'Received from bridging 131524',0.00,0.00,24200.00,0.00,0.00,'2022-05-28 10:36:50','',''),(2641182,'5','91',NULL,255,'Reception corrector for bridging 131525',0.00,0.00,0.00,25800.00,0.00,'2022-05-28 10:37:51','',''),(2641183,'5','91','643',255,'Received from bridging 131525',0.00,0.00,25800.00,0.00,0.00,'2022-05-28 10:37:51','',''),(2641184,'5','91','643',255,'Sale Id shift 257556',0.00,0.00,0.00,2125.50,0.00,'2022-05-29 09:40:40','',''),(2641185,'5','91',NULL,255,'Sale Id shift 257556',350707.50,0.00,0.00,0.00,0.00,'2022-05-29 09:40:40','',''),(2641186,'5','91','642',255,'Sale Id shift 257557',0.00,0.00,0.00,3033.16,0.00,'2022-05-30 06:24:01','',''),(2641187,'5','91','643',255,'Sale Id shift 257557',0.00,0.00,0.00,1811.38,0.00,'2022-05-30 06:24:01','',''),(2641188,'5','91',NULL,255,'Sale Id shift 257557',799349.10,0.00,0.00,0.00,0.00,'2022-05-30 06:24:01','',''),(2641189,'5','91','642',255,'Sale Id shift 257558',0.00,0.00,0.00,2511.72,0.00,'2022-05-30 11:07:36','',''),(2641190,'5','91','643',255,'Sale Id shift 257558',0.00,0.00,0.00,2218.97,0.00,'2022-05-30 11:07:36','',''),(2641191,'5','91',NULL,255,'Sale Id shift 257558',780563.85,0.00,0.00,0.00,0.00,'2022-05-30 11:07:36','',''),(2641192,'5','91','642',255,'Sale Id shift 257559',0.00,0.00,0.00,2512.84,0.00,'2022-05-31 05:40:35','',''),(2641193,'5','91','643',255,'Sale Id shift 257559',0.00,0.00,0.00,2150.27,0.00,'2022-05-31 05:40:35','',''),(2641194,'5','91',NULL,255,'Sale Id shift 257559',769413.15,0.00,0.00,0.00,0.00,'2022-05-31 05:40:35','',''),(2641195,'5','91','642',255,'Sale Id shift 257560',0.00,0.00,0.00,2702.21,0.00,'2022-05-31 22:43:39','',''),(2641196,'5','91','643',255,'Sale Id shift 257560',0.00,0.00,0.00,1700.85,0.00,'2022-05-31 22:43:39','',''),(2641197,'5','91',NULL,255,'Sale Id shift 257560',726504.90,0.00,0.00,0.00,0.00,'2022-05-31 22:43:39','',''),(2641198,'5','91','642',255,'Sale Id shift 257561',0.00,0.00,0.00,1301.71,0.00,'2022-06-02 05:38:42','',''),(2641199,'5','91','643',255,'Sale Id shift 257561',0.00,0.00,0.00,3118.09,0.00,'2022-06-02 05:38:42','',''),(2641200,'5','91',NULL,255,'Sale Id shift 257561',729267.00,0.00,0.00,0.00,0.00,'2022-06-02 05:38:42','',''),(2641201,'5','91','642',255,'Sale Id shift 257562',0.00,0.00,0.00,1703.22,0.00,'2022-06-03 05:45:05','',''),(2641202,'5','91','643',255,'Sale Id shift 257562',0.00,0.00,0.00,2747.48,0.00,'2022-06-03 05:45:05','',''),(2641203,'5','91',NULL,255,'Sale Id shift 257562',734365.50,0.00,0.00,0.00,0.00,'2022-06-03 05:45:05','',''),(2641204,'5','91','642',255,'Sale Id shift 257563',0.00,0.00,0.00,969.25,0.00,'2022-06-03 22:54:15','',''),(2641205,'5','91','643',255,'Sale Id shift 257563',0.00,0.00,0.00,3146.37,0.00,'2022-06-03 22:54:15','',''),(2641206,'5','91',NULL,255,'Sale Id shift 257563',679077.30,0.00,0.00,0.00,0.00,'2022-06-03 22:54:15','',''),(2641207,'5','91','642',255,'Sale Id shift 257564',0.00,0.00,0.00,1967.38,0.00,'2022-06-05 08:08:12','',''),(2641208,'5','91','643',255,'Sale Id shift 257564',0.00,0.00,0.00,2166.03,0.00,'2022-06-05 08:08:12','',''),(2641209,'5','91',NULL,255,'Sale Id shift 257564',682012.65,0.00,0.00,0.00,0.00,'2022-06-05 08:08:12','',''),(2641210,'5','91','642',255,'Sale Id shift 257565',0.00,0.00,0.00,1986.18,0.00,'2022-06-06 09:45:09','',''),(2641211,'5','91','643',255,'Sale Id shift 257565',0.00,0.00,0.00,2615.73,0.00,'2022-06-06 09:45:09','',''),(2641212,'5','91',NULL,255,'Sale Id shift 257565',759315.15,0.00,0.00,0.00,0.00,'2022-06-06 09:45:09','',''),(2641213,'5','91','642',255,'Sale Id shift 257566',0.00,0.00,0.00,2852.70,0.00,'2022-06-07 06:48:39','',''),(2641214,'5','91','643',255,'Sale Id shift 257566',0.00,0.00,0.00,1763.16,0.00,'2022-06-07 06:48:39','',''),(2641215,'5','91',NULL,255,'Sale Id shift 257566',761616.90,0.00,0.00,0.00,0.00,'2022-06-07 06:48:39','',''),(2641216,'5','91','642',255,'Sale Id shift 257567',0.00,0.00,0.00,2469.50,0.00,'2022-06-08 09:03:26','',''),(2641217,'5','91','643',255,'Sale Id shift 257567',0.00,0.00,0.00,485.51,0.00,'2022-06-08 09:03:26','',''),(2641218,'5','91',NULL,255,'Sale Id shift 257567',487576.65,0.00,0.00,0.00,0.00,'2022-06-08 09:03:26','',''),(2641219,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9250000.00,50000.00,0.00,0.00,'2022-07-12 08:58:00','',''),(2641220,'5','91',NULL,255,'Reception corrector for bridging 131527',0.00,0.00,0.00,25900.00,0.00,'2022-07-12 09:56:23','',''),(2641221,'5','91','643',255,'Received from bridging 131527',0.00,0.00,25900.00,0.00,0.00,'2022-07-12 09:56:23','',''),(2641222,'5','91',NULL,255,'Reception corrector for bridging 131526',0.00,0.00,0.00,24100.00,0.00,'2022-07-12 09:56:34','',''),(2641223,'5','91','642',255,'Received from bridging 131526',0.00,0.00,24100.00,0.00,0.00,'2022-07-12 09:56:34','',''),(2641224,'5','91','643',255,'Sale Id shift 257601',0.00,0.00,0.00,2055.02,0.00,'2022-07-12 10:08:24','',''),(2641225,'5','91',NULL,255,'Sale Id shift 257601',380178.70,0.00,0.00,0.00,0.00,'2022-07-12 10:08:24','',''),(2641226,'5','91','642',255,'Sale Id shift 257602',0.00,0.00,0.00,3297.40,0.00,'2022-07-13 06:49:49','',''),(2641227,'5','91','643',255,'Sale Id shift 257602',0.00,0.00,0.00,735.69,0.00,'2022-07-13 06:49:49','',''),(2641228,'5','91',NULL,255,'Sale Id shift 257602',746121.65,0.00,0.00,0.00,0.00,'2022-07-13 06:49:49','',''),(2641229,'5','91','642',255,'Sale Id shift 257603',0.00,0.00,0.00,2375.39,0.00,'2022-07-14 06:24:26','',''),(2641230,'5','91','643',255,'Sale Id shift 257603',0.00,0.00,0.00,1750.63,0.00,'2022-07-14 06:24:26','',''),(2641231,'5','91',NULL,255,'Sale Id shift 257603',763313.70,0.00,0.00,0.00,0.00,'2022-07-14 06:24:26','',''),(2641232,'5','91','642',255,'Sale Id shift 257604',0.00,0.00,0.00,2709.55,0.00,'2022-07-15 06:38:14','',''),(2641233,'5','91','643',255,'Sale Id shift 257604',0.00,0.00,0.00,1935.73,0.00,'2022-07-15 06:38:14','',''),(2641234,'5','91',NULL,255,'Sale Id shift 257604',859376.80,0.00,0.00,0.00,0.00,'2022-07-15 06:38:14','',''),(2641235,'5','91','642',255,'Sale Id shift 257605',0.00,0.00,0.00,2226.94,0.00,'2022-07-16 05:41:37','',''),(2641236,'5','91','643',255,'Sale Id shift 257605',0.00,0.00,0.00,2235.27,0.00,'2022-07-16 05:41:37','',''),(2641237,'5','91',NULL,255,'Sale Id shift 257605',825508.85,0.00,0.00,0.00,0.00,'2022-07-16 05:41:37','',''),(2641238,'5','91','642',255,'Sale Id shift 257606',0.00,0.00,0.00,4005.02,0.00,'2022-07-17 06:03:19','',''),(2641239,'5','91','643',255,'Sale Id shift 257606',0.00,0.00,0.00,2821.81,0.00,'2022-07-17 06:03:19','',''),(2641240,'5','91',NULL,255,'Sale Id shift 257606',1262963.55,0.00,0.00,0.00,0.00,'2022-07-17 06:03:19','',''),(2641241,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-07-17 11:37:37','',''),(2641242,'5','91',NULL,255,'Reception corrector for bridging 131529',0.00,0.00,0.00,22500.00,0.00,'2022-07-17 12:57:59','',''),(2641243,'5','91','644',255,'Received from bridging 131529',0.00,0.00,22500.00,0.00,0.00,'2022-07-17 12:57:59','',''),(2641244,'5','91',NULL,255,'Reception corrector for bridging 131528',0.00,0.00,0.00,22500.00,0.00,'2022-07-17 12:58:13','',''),(2641245,'5','91','642',255,'Received from bridging 131528',0.00,0.00,22500.00,0.00,0.00,'2022-07-17 12:58:13','',''),(2641246,'5','91','642',255,'Sale Id shift 257607',0.00,0.00,0.00,2560.29,0.00,'2022-07-18 07:32:14','',''),(2641247,'5','91','643',255,'Sale Id shift 257607',0.00,0.00,0.00,2122.56,0.00,'2022-07-18 07:32:14','',''),(2641248,'5','91','644',255,'Sale Id shift 257607',0.00,0.00,0.00,955.03,0.00,'2022-07-18 07:32:14','',''),(2641249,'5','91',NULL,255,'Sale Id shift 257607',1043007.80,0.00,0.00,0.00,0.00,'2022-07-18 07:32:14','',''),(2641250,'5','91','642',255,'Sale Id shift 257608',0.00,0.00,0.00,2294.20,0.00,'2022-07-19 05:47:33','',''),(2641251,'5','91','644',255,'Sale Id shift 257608',0.00,0.00,0.00,4449.52,0.00,'2022-07-19 05:47:33','',''),(2641252,'5','91',NULL,255,'Sale Id shift 257608',1247588.20,0.00,0.00,0.00,0.00,'2022-07-19 05:47:33','',''),(2641253,'5','91','642',255,'Sale Id shift 257609',0.00,0.00,0.00,1553.60,0.00,'2022-07-20 06:42:31','',''),(2641254,'5','91','643',255,'Sale Id shift 257609',0.00,0.00,0.00,135.11,0.00,'2022-07-20 06:42:31','',''),(2641255,'5','91','644',255,'Sale Id shift 257609',0.00,0.00,0.00,3731.50,0.00,'2022-07-20 06:42:31','',''),(2641256,'5','91',NULL,255,'Sale Id shift 257609',1002738.85,0.00,0.00,0.00,0.00,'2022-07-20 06:42:31','',''),(2641257,'5','91','642',255,'Sale Id shift 257610',0.00,0.00,0.00,837.49,0.00,'2022-07-21 07:43:07','',''),(2641258,'5','91','643',255,'Sale Id shift 257610',0.00,0.00,0.00,2423.71,0.00,'2022-07-21 07:43:07','',''),(2641259,'5','91','644',255,'Sale Id shift 257610',0.00,0.00,0.00,4693.51,0.00,'2022-07-21 07:43:07','',''),(2641260,'5','91',NULL,255,'Sale Id shift 257610',1471621.35,0.00,0.00,0.00,0.00,'2022-07-21 07:43:07','',''),(2641261,'5','91','642',255,'Sale Id shift 257611',0.00,0.00,0.00,1938.05,0.00,'2022-07-21 23:18:53','',''),(2641262,'5','91','643',255,'Sale Id shift 257611',0.00,0.00,0.00,186.31,0.00,'2022-07-21 23:18:53','',''),(2641263,'5','91','644',255,'Sale Id shift 257611',0.00,0.00,0.00,4294.14,0.00,'2022-07-21 23:18:53','',''),(2641264,'5','91',NULL,255,'Sale Id shift 257611',1187422.50,0.00,0.00,0.00,0.00,'2022-07-21 23:18:53','',''),(2641265,'5','91','642',255,'Sale Id shift 257612',0.00,0.00,0.00,2969.58,0.00,'2022-07-23 07:28:24','',''),(2641266,'5','91','644',255,'Sale Id shift 257612',0.00,0.00,0.00,3355.78,0.00,'2022-07-23 07:28:24','',''),(2641267,'5','91',NULL,255,'Sale Id shift 257612',1170191.60,0.00,0.00,0.00,0.00,'2022-07-23 07:28:24','',''),(2641268,'5','91','644',0,'Tank level zero out for dipping',0.00,0.00,0.00,1022.61,0.00,'2022-07-23 17:47:15','',''),(2641269,'5','91','644',0,'Inventory adjustment from tank dipping to 2000',0.00,0.00,2000.00,0.00,0.00,'2022-07-23 17:47:15','',''),(2641270,'5','91','642',255,'Sale Id shift 257613',0.00,0.00,0.00,2854.91,0.00,'2022-07-24 06:55:28','',''),(2641271,'5','91','643',255,'Sale Id shift 257613',0.00,0.00,0.00,2285.24,0.00,'2022-07-24 06:55:28','',''),(2641272,'5','91','644',255,'Sale Id shift 257613',0.00,0.00,0.00,1119.05,0.00,'2022-07-24 06:55:28','',''),(2641273,'5','91',NULL,255,'Sale Id shift 257613',1157952.00,0.00,0.00,0.00,0.00,'2022-07-24 06:55:28','',''),(2641274,'5','91','642',255,'Sale Id shift 257614',0.00,0.00,0.00,3823.38,0.00,'2022-07-25 06:40:29','',''),(2641275,'5','91','643',255,'Sale Id shift 257614',0.00,0.00,0.00,2557.57,0.00,'2022-07-25 06:40:29','',''),(2641276,'5','91',NULL,255,'Sale Id shift 257614',1180475.75,0.00,0.00,0.00,0.00,'2022-07-25 06:40:29','',''),(2641277,'5','91','642',255,'Sale Id shift 257615',0.00,0.00,0.00,3074.88,0.00,'2022-07-26 07:39:04','',''),(2641278,'5','91','643',255,'Sale Id shift 257615',0.00,0.00,0.00,2304.32,0.00,'2022-07-26 07:39:04','',''),(2641279,'5','91',NULL,255,'Sale Id shift 257615',995152.00,0.00,0.00,0.00,0.00,'2022-07-26 07:39:04','',''),(2641280,'5','91','642',255,'Sale Id shift 257616',0.00,0.00,0.00,3268.25,0.00,'2022-07-27 06:53:36','',''),(2641281,'5','91','643',255,'Sale Id shift 257616',0.00,0.00,0.00,1821.37,0.00,'2022-07-27 06:53:36','',''),(2641282,'5','91',NULL,255,'Sale Id shift 257616',941579.70,0.00,0.00,0.00,0.00,'2022-07-27 06:53:36','',''),(2641283,'5','91','642',255,'Sale Id shift 257617',0.00,0.00,0.00,4869.37,0.00,'2022-07-28 08:05:51','',''),(2641284,'5','91',NULL,255,'Sale Id shift 257617',900833.45,0.00,0.00,0.00,0.00,'2022-07-28 08:05:51','',''),(2641285,'5','91','642',255,'Sale Id shift 257618',0.00,0.00,0.00,1985.25,0.00,'2022-07-29 06:55:34','',''),(2641286,'5','91','643',255,'Sale Id shift 257618',0.00,0.00,0.00,525.12,0.00,'2022-07-29 06:55:34','',''),(2641287,'5','91',NULL,255,'Sale Id shift 257618',464418.45,0.00,0.00,0.00,0.00,'2022-07-29 06:55:34','',''),(2641288,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-08-05 16:48:10','',''),(2641289,'5','91','643',255,'Sale Id shift 257626',0.00,0.00,0.00,383.80,0.00,'2022-08-06 09:09:34','',''),(2641290,'5','91',NULL,255,'Sale Id shift 257626',71003.00,0.00,0.00,0.00,0.00,'2022-08-06 09:09:34','',''),(2641291,'5','91',NULL,255,'Reception corrector for bridging 131530',0.00,0.00,0.00,14750.00,0.00,'2022-08-07 19:06:46','',''),(2641292,'5','91','642',255,'Received from bridging 131530',0.00,0.00,14750.00,0.00,0.00,'2022-08-07 19:06:46','',''),(2641293,'5','91',NULL,255,'Reception corrector for bridging 131531',0.00,0.00,0.00,15250.00,0.00,'2022-08-07 19:07:00','',''),(2641294,'5','91','643',255,'Received from bridging 131531',0.00,0.00,15250.00,0.00,0.00,'2022-08-07 19:07:00','',''),(2641295,'5','91','643',255,'Sale Id shift 257628',0.00,0.00,0.00,2464.73,0.00,'2022-09-03 08:14:26','',''),(2641296,'5','91',NULL,255,'Sale Id shift 257628',455975.05,0.00,0.00,0.00,0.00,'2022-09-03 08:14:26','',''),(2641297,'5','91','642',255,'Sale Id shift 257629',0.00,0.00,0.00,1684.98,0.00,'2022-09-03 11:56:32','',''),(2641298,'5','91','643',255,'Sale Id shift 257629',0.00,0.00,0.00,3590.45,0.00,'2022-09-03 11:56:32','',''),(2641299,'5','91',NULL,255,'Sale Id shift 257629',975954.55,0.00,0.00,0.00,0.00,'2022-09-03 11:56:32','',''),(2641300,'5','91','642',255,'Sale Id shift 257630',0.00,0.00,0.00,2947.68,0.00,'2022-09-03 12:12:40','',''),(2641301,'5','91','643',255,'Sale Id shift 257630',0.00,0.00,0.00,2068.70,0.00,'2022-09-03 12:12:40','',''),(2641302,'5','91',NULL,255,'Sale Id shift 257630',928030.30,0.00,0.00,0.00,0.00,'2022-09-03 12:12:40','',''),(2641303,'5','91','642',255,'Sale Id shift 257631',0.00,0.00,0.00,4201.24,0.00,'2022-09-03 12:18:52','',''),(2641304,'5','91','643',255,'Sale Id shift 257631',0.00,0.00,0.00,2267.90,0.00,'2022-09-03 12:18:52','',''),(2641305,'5','91',NULL,255,'Sale Id shift 257631',1196790.90,0.00,0.00,0.00,0.00,'2022-09-03 12:18:52','',''),(2641306,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,11063000.00,59800.00,0.00,0.00,'2022-09-03 19:05:14','',''),(2641307,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9166750.00,49550.00,0.00,0.00,'2022-09-03 19:05:20','',''),(2641308,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-03 19:05:28','',''),(2641309,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9250000.00,50000.00,0.00,0.00,'2022-09-03 19:05:42','',''),(2641310,'5','91','642',255,'Sale Id shift 257632',0.00,0.00,0.00,4069.82,0.00,'2022-09-03 19:06:06','',''),(2641311,'5','91','643',255,'Sale Id shift 257632',0.00,0.00,0.00,2293.58,0.00,'2022-09-03 19:06:06','',''),(2641312,'5','91',NULL,255,'Sale Id shift 257632',1177229.00,0.00,0.00,0.00,0.00,'2022-09-03 19:06:06','',''),(2641313,'5','91',NULL,255,'Reception corrector for bridging 131532',0.00,0.00,0.00,29950.00,0.00,'2022-09-03 20:34:15','',''),(2641314,'5','91','642',255,'Received from bridging 131532',0.00,0.00,29950.00,0.00,0.00,'2022-09-03 20:34:15','',''),(2641315,'5','91','642',255,'Sale Id shift 257633',0.00,0.00,0.00,3818.59,0.00,'2022-09-04 09:47:37','',''),(2641316,'5','91','643',255,'Sale Id shift 257633',0.00,0.00,0.00,2533.90,0.00,'2022-09-04 09:47:37','',''),(2641317,'5','91',NULL,255,'Sale Id shift 257633',1175210.65,0.00,0.00,0.00,0.00,'2022-09-04 09:47:37','',''),(2641318,'5','91','642',255,'Sale Id shift 257634',0.00,0.00,0.00,3342.93,0.00,'2022-09-04 15:21:20','',''),(2641319,'5','91','643',255,'Sale Id shift 257634',0.00,0.00,0.00,2580.60,0.00,'2022-09-04 15:21:20','',''),(2641320,'5','91',NULL,255,'Sale Id shift 257634',1095853.05,0.00,0.00,0.00,0.00,'2022-09-04 15:21:20','',''),(2641321,'5','91',NULL,255,'Reception corrector for bridging 131533',0.00,0.00,0.00,29850.00,0.00,'2022-09-05 09:23:22','',''),(2641322,'5','91','643',255,'Received from bridging 131533',0.00,0.00,29850.00,0.00,0.00,'2022-09-05 09:23:22','',''),(2641323,'5','91','642',255,'Sale Id shift 257635',0.00,0.00,0.00,3524.59,0.00,'2022-09-05 11:49:24','',''),(2641324,'5','91','643',255,'Sale Id shift 257635',0.00,0.00,0.00,3035.47,0.00,'2022-09-05 11:49:24','',''),(2641325,'5','91',NULL,255,'Sale Id shift 257635',1213611.10,0.00,0.00,0.00,0.00,'2022-09-05 11:49:24','',''),(2641326,'5','91','642',255,'Sale Id shift 257636',0.00,0.00,0.00,4105.95,0.00,'2022-09-05 11:54:31','',''),(2641327,'5','91','643',255,'Sale Id shift 257636',0.00,0.00,0.00,2420.25,0.00,'2022-09-05 11:54:31','',''),(2641328,'5','91',NULL,255,'Sale Id shift 257636',1207347.00,0.00,0.00,0.00,0.00,'2022-09-05 11:54:31','',''),(2641329,'5','91','642',255,'Sale Id shift 257637',0.00,0.00,0.00,4203.11,0.00,'2022-09-05 12:02:05','',''),(2641330,'5','91','643',255,'Sale Id shift 257637',0.00,0.00,0.00,2647.65,0.00,'2022-09-05 12:02:05','',''),(2641331,'5','91',NULL,255,'Sale Id shift 257637',1267390.60,0.00,0.00,0.00,0.00,'2022-09-05 12:02:05','',''),(2641332,'5','91','642',255,'Sale Id shift 257638',0.00,0.00,0.00,2490.87,0.00,'2022-09-05 12:15:15','',''),(2641333,'5','91','643',255,'Sale Id shift 257638',0.00,0.00,0.00,4581.28,0.00,'2022-09-05 12:15:15','',''),(2641334,'5','91',NULL,255,'Sale Id shift 257638',1308347.75,0.00,0.00,0.00,0.00,'2022-09-05 12:15:15','',''),(2641335,'5','91','642',255,'Sale Id shift 257639',0.00,0.00,0.00,2660.47,0.00,'2022-09-05 12:24:58','',''),(2641336,'5','91','643',255,'Sale Id shift 257639',0.00,0.00,0.00,4794.09,0.00,'2022-09-05 12:24:58','',''),(2641337,'5','91',NULL,255,'Sale Id shift 257639',1379093.60,0.00,0.00,0.00,0.00,'2022-09-05 12:24:58','',''),(2641338,'5','91','642',255,'Sale Id shift 257640',0.00,0.00,0.00,3744.98,0.00,'2022-09-05 12:30:08','',''),(2641339,'5','91','643',255,'Sale Id shift 257640',0.00,0.00,0.00,2971.22,0.00,'2022-09-05 12:30:08','',''),(2641340,'5','91',NULL,255,'Sale Id shift 257640',1242497.00,0.00,0.00,0.00,0.00,'2022-09-05 12:30:08','',''),(2641341,'5','91',NULL,255,'Reception corrector for bridging 131534',0.00,0.00,0.00,18050.00,0.00,'2022-09-05 12:54:50','',''),(2641342,'5','91','642',255,'Received from bridging 131534',0.00,0.00,18050.00,0.00,0.00,'2022-09-05 12:54:50','',''),(2641343,'5','91',NULL,255,'Reception corrector for bridging 131535',0.00,0.00,0.00,17350.00,0.00,'2022-09-05 12:54:58','',''),(2641344,'5','91','643',255,'Received from bridging 131535',0.00,0.00,17350.00,0.00,0.00,'2022-09-05 12:54:58','',''),(2641345,'5','91',NULL,255,'Reception corrector for bridging 131536',0.00,0.00,0.00,14150.00,0.00,'2022-09-05 12:55:06','',''),(2641346,'5','91','644',255,'Received from bridging 131536',0.00,0.00,14150.00,0.00,0.00,'2022-09-05 12:55:06','',''),(2641347,'5','91','642',255,'Sale Id shift 257641',0.00,0.00,0.00,2655.63,0.00,'2022-09-05 13:24:47','',''),(2641348,'5','91','644',255,'Sale Id shift 257641',0.00,0.00,0.00,4208.77,0.00,'2022-09-05 13:24:47','',''),(2641349,'5','91',NULL,255,'Sale Id shift 257641',1269914.00,0.00,0.00,0.00,0.00,'2022-09-05 13:24:47','',''),(2641350,'5','91','642',255,'Sale Id shift 257642',0.00,0.00,0.00,1560.48,0.00,'2022-09-05 13:37:06','',''),(2641351,'5','91','644',255,'Sale Id shift 257642',0.00,0.00,0.00,3752.88,0.00,'2022-09-05 13:37:06','',''),(2641352,'5','91',NULL,255,'Sale Id shift 257642',982971.60,0.00,0.00,0.00,0.00,'2022-09-05 13:37:06','',''),(2641353,'5','91','642',255,'Sale Id shift 257643',0.00,0.00,0.00,2055.84,0.00,'2022-09-05 13:42:02','',''),(2641354,'5','91','643',255,'Sale Id shift 257643',0.00,0.00,0.00,531.49,0.00,'2022-09-05 13:42:02','',''),(2641355,'5','91','644',255,'Sale Id shift 257643',0.00,0.00,0.00,6104.16,0.00,'2022-09-05 13:42:02','',''),(2641356,'5','91',NULL,255,'Sale Id shift 257643',1607925.65,0.00,0.00,0.00,0.00,'2022-09-05 13:42:02','',''),(2641357,'5','91','642',255,'Sale Id shift 257644',0.00,0.00,0.00,2882.37,0.00,'2022-09-05 13:46:26','',''),(2641358,'5','91','643',255,'Sale Id shift 257644',0.00,0.00,0.00,2632.91,0.00,'2022-09-05 13:46:26','',''),(2641359,'5','91',NULL,255,'Sale Id shift 257644',1020326.80,0.00,0.00,0.00,0.00,'2022-09-05 13:46:26','',''),(2641360,'5','91','642',255,'Sale Id shift 257645',0.00,0.00,0.00,3006.26,0.00,'2022-09-05 13:50:25','',''),(2641361,'5','91','643',255,'Sale Id shift 257645',0.00,0.00,0.00,2692.99,0.00,'2022-09-05 13:50:25','',''),(2641362,'5','91',NULL,255,'Sale Id shift 257645',1054361.25,0.00,0.00,0.00,0.00,'2022-09-05 13:50:25','',''),(2641363,'5','91','642',255,'Sale Id shift 257646',0.00,0.00,0.00,3575.27,0.00,'2022-09-05 13:53:56','',''),(2641364,'5','91','643',255,'Sale Id shift 257646',0.00,0.00,0.00,3660.09,0.00,'2022-09-05 13:53:56','',''),(2641365,'5','91',NULL,255,'Sale Id shift 257646',1338541.60,0.00,0.00,0.00,0.00,'2022-09-05 13:53:56','',''),(2641366,'5','91','642',255,'Sale Id shift 257647',0.00,0.00,0.00,3126.53,0.00,'2022-09-05 13:58:32','',''),(2641367,'5','91','643',255,'Sale Id shift 257647',0.00,0.00,0.00,2461.64,0.00,'2022-09-05 13:58:32','',''),(2641368,'5','91',NULL,255,'Sale Id shift 257647',1033811.45,0.00,0.00,0.00,0.00,'2022-09-05 13:58:32','',''),(2641369,'5','91',NULL,255,'Reception corrector for bridging 131538',0.00,0.00,0.00,25500.00,0.00,'2022-09-05 14:24:52','',''),(2641370,'5','91','644',255,'Received from bridging 131538',0.00,0.00,25500.00,0.00,0.00,'2022-09-05 14:24:52','',''),(2641371,'5','91',NULL,255,'Reception corrector for bridging 131537',0.00,0.00,0.00,24500.00,0.00,'2022-09-05 14:25:00','',''),(2641372,'5','91','642',255,'Received from bridging 131537',0.00,0.00,24500.00,0.00,0.00,'2022-09-05 14:25:00','',''),(2641373,'5','91','643',255,'Sale Id shift 257648',0.00,0.00,0.00,4070.20,0.00,'2022-09-05 14:31:44','',''),(2641374,'5','91','644',255,'Sale Id shift 257648',0.00,0.00,0.00,5280.28,0.00,'2022-09-05 14:31:44','',''),(2641375,'5','91',NULL,255,'Sale Id shift 257648',1729838.80,0.00,0.00,0.00,0.00,'2022-09-05 14:31:44','',''),(2641376,'5','91','643',255,'Sale Id shift 257649',0.00,0.00,0.00,3009.29,0.00,'2022-09-05 14:35:43','',''),(2641377,'5','91','644',255,'Sale Id shift 257649',0.00,0.00,0.00,3797.64,0.00,'2022-09-05 14:35:43','',''),(2641378,'5','91',NULL,255,'Sale Id shift 257649',1259282.05,0.00,0.00,0.00,0.00,'2022-09-05 14:35:43','',''),(2641379,'5','91','643',255,'Sale Id shift 257650',0.00,0.00,0.00,4141.88,0.00,'2022-09-05 14:40:50','',''),(2641380,'5','91','644',255,'Sale Id shift 257650',0.00,0.00,0.00,6278.52,0.00,'2022-09-05 14:40:50','',''),(2641381,'5','91',NULL,255,'Sale Id shift 257650',1927774.00,0.00,0.00,0.00,0.00,'2022-09-05 14:40:50','',''),(2641382,'5','91','642',255,'Sale Id shift 257651',0.00,0.00,0.00,2163.15,0.00,'2022-09-05 14:47:05','',''),(2641383,'5','91','643',255,'Sale Id shift 257651',0.00,0.00,0.00,559.06,0.00,'2022-09-05 14:47:05','',''),(2641384,'5','91','644',255,'Sale Id shift 257651',0.00,0.00,0.00,2446.39,0.00,'2022-09-05 14:47:05','',''),(2641385,'5','91',NULL,255,'Sale Id shift 257651',956191.00,0.00,0.00,0.00,0.00,'2022-09-05 14:47:05','',''),(2641386,'5','91','642',255,'Sale Id shift 257652',0.00,0.00,0.00,706.61,0.00,'2022-09-05 14:50:51','',''),(2641387,'5','91','643',255,'Sale Id shift 257652',0.00,0.00,0.00,3338.54,0.00,'2022-09-05 14:50:51','',''),(2641388,'5','91','644',255,'Sale Id shift 257652',0.00,0.00,0.00,3258.59,0.00,'2022-09-05 14:50:51','',''),(2641389,'5','91',NULL,255,'Sale Id shift 257652',1351191.90,0.00,0.00,0.00,0.00,'2022-09-05 14:50:51','',''),(2641390,'5','91',NULL,255,'Reception corrector for bridging 131540',0.00,0.00,0.00,24000.00,0.00,'2022-09-05 15:08:05','',''),(2641391,'5','91','644',255,'Received from bridging 131540',0.00,0.00,24000.00,0.00,0.00,'2022-09-05 15:08:05','',''),(2641392,'5','91',NULL,255,'Reception corrector for bridging 131539',0.00,0.00,0.00,26000.00,0.00,'2022-09-05 15:08:12','',''),(2641393,'5','91','643',255,'Received from bridging 131539',0.00,0.00,26000.00,0.00,0.00,'2022-09-05 15:08:12','',''),(2641394,'5','91','643',255,'Sale Id shift 257653',0.00,0.00,0.00,3269.59,0.00,'2022-09-05 15:16:15','',''),(2641395,'5','91','644',255,'Sale Id shift 257653',0.00,0.00,0.00,3704.72,0.00,'2022-09-05 15:16:15','',''),(2641396,'5','91',NULL,255,'Sale Id shift 257653',1290247.35,0.00,0.00,0.00,0.00,'2022-09-05 15:16:15','',''),(2641397,'5','91','642',255,'Sale Id shift 257654',0.00,0.00,0.00,1984.05,0.00,'2022-09-05 15:19:39','',''),(2641398,'5','91','644',255,'Sale Id shift 257654',0.00,0.00,0.00,4028.13,0.00,'2022-09-05 15:19:39','',''),(2641399,'5','91',NULL,255,'Sale Id shift 257654',1112253.30,0.00,0.00,0.00,0.00,'2022-09-05 15:19:39','',''),(2641400,'5','91','642',255,'Sale Id shift 257655',0.00,0.00,0.00,3299.69,0.00,'2022-09-05 15:28:21','',''),(2641401,'5','91','644',255,'Sale Id shift 257655',0.00,0.00,0.00,6929.23,0.00,'2022-09-05 15:28:21','',''),(2641402,'5','91',NULL,255,'Sale Id shift 257655',1892350.20,0.00,0.00,0.00,0.00,'2022-09-05 15:28:21','',''),(2641403,'5','91','642',255,'Sale Id shift 257656',0.00,0.00,0.00,2200.42,0.00,'2022-09-05 15:31:54','',''),(2641404,'5','91','644',255,'Sale Id shift 257656',0.00,0.00,0.00,5249.36,0.00,'2022-09-05 15:31:54','',''),(2641405,'5','91',NULL,255,'Sale Id shift 257656',1378209.30,0.00,0.00,0.00,0.00,'2022-09-05 15:31:54','',''),(2641406,'5','91','642',255,'Sale Id shift 257657',0.00,0.00,0.00,2644.95,0.00,'2022-09-06 09:56:06','',''),(2641407,'5','91','643',255,'Sale Id shift 257657',0.00,0.00,0.00,1810.01,0.00,'2022-09-06 09:56:06','',''),(2641408,'5','91','644',255,'Sale Id shift 257657',0.00,0.00,0.00,4766.09,0.00,'2022-09-06 09:56:06','',''),(2641409,'5','91',NULL,255,'Sale Id shift 257657',1705894.25,0.00,0.00,0.00,0.00,'2022-09-06 09:56:06','',''),(2641410,'5','91','642',255,'Sale Id shift 257658',0.00,0.00,0.00,2235.78,0.00,'2022-09-07 09:40:16','',''),(2641411,'5','91','643',255,'Sale Id shift 257658',0.00,0.00,0.00,3884.90,0.00,'2022-09-07 09:40:16','',''),(2641412,'5','91',NULL,255,'Sale Id shift 257658',1132325.80,0.00,0.00,0.00,0.00,'2022-09-07 09:40:16','',''),(2641413,'5','91','642',255,'Sale Id shift 257659',0.00,0.00,0.00,2870.30,0.00,'2022-09-08 09:01:59','',''),(2641414,'5','91','643',255,'Sale Id shift 257659',0.00,0.00,0.00,3341.61,0.00,'2022-09-08 09:01:59','',''),(2641415,'5','91',NULL,255,'Sale Id shift 257659',1149203.35,0.00,0.00,0.00,0.00,'2022-09-08 09:01:59','',''),(2641416,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8269500.00,44700.00,0.00,0.00,'2022-09-08 12:59:09','',''),(2641417,'5','91','643',255,'Sale Id shift 257660',0.00,0.00,0.00,3834.66,0.00,'2022-09-09 07:14:06','',''),(2641418,'5','91','644',255,'Sale Id shift 257660',0.00,0.00,0.00,4508.39,0.00,'2022-09-09 07:14:06','',''),(2641419,'5','91',NULL,255,'Sale Id shift 257660',1543464.25,0.00,0.00,0.00,0.00,'2022-09-09 07:14:06','',''),(2641420,'5','91','642',255,'Sale Id shift 257661',0.00,0.00,0.00,2326.88,0.00,'2022-09-10 10:16:08','',''),(2641421,'5','91','643',255,'Sale Id shift 257661',0.00,0.00,0.00,3267.78,0.00,'2022-09-10 10:16:08','',''),(2641422,'5','91',NULL,255,'Sale Id shift 257661',1035012.10,0.00,0.00,0.00,0.00,'2022-09-10 10:16:08','',''),(2641423,'5','91',NULL,255,'Reception corrector for bridging 131543',0.00,0.00,0.00,14650.00,0.00,'2022-09-10 21:33:11','',''),(2641424,'5','91','644',255,'Received from bridging 131543',0.00,0.00,14650.00,0.00,0.00,'2022-09-10 21:33:11','',''),(2641425,'5','91',NULL,255,'Reception corrector for bridging 131542',0.00,0.00,0.00,15100.00,0.00,'2022-09-10 21:33:24','',''),(2641426,'5','91','643',255,'Received from bridging 131542',0.00,0.00,15100.00,0.00,0.00,'2022-09-10 21:33:24','',''),(2641427,'5','91',NULL,255,'Reception corrector for bridging 131541',0.00,0.00,0.00,14950.00,0.00,'2022-09-10 21:34:47','',''),(2641428,'5','91','642',255,'Received from bridging 131541',0.00,0.00,14950.00,0.00,0.00,'2022-09-10 21:34:47','',''),(2641429,'5','91','642',255,'Sale Id shift 257662',0.00,0.00,0.00,1686.85,0.00,'2022-09-11 11:03:17','',''),(2641430,'5','91','643',255,'Sale Id shift 257662',0.00,0.00,0.00,4815.71,0.00,'2022-09-11 11:03:17','',''),(2641431,'5','91','644',255,'Sale Id shift 257662',0.00,0.00,0.00,3700.23,0.00,'2022-09-11 11:03:17','',''),(2641432,'5','91',NULL,255,'Sale Id shift 257662',1887516.15,0.00,0.00,0.00,0.00,'2022-09-11 11:03:17','',''),(2641433,'5','91','642',255,'Sale Id shift 257663',0.00,0.00,0.00,2938.71,0.00,'2022-09-12 06:26:44','',''),(2641434,'5','91','643',255,'Sale Id shift 257663',0.00,0.00,0.00,3559.80,0.00,'2022-09-12 06:26:44','',''),(2641435,'5','91','644',255,'Sale Id shift 257663',0.00,0.00,0.00,797.91,0.00,'2022-09-12 06:26:44','',''),(2641436,'5','91',NULL,255,'Sale Id shift 257663',1349837.70,0.00,0.00,0.00,0.00,'2022-09-12 06:26:44','',''),(2641437,'5','91','642',255,'Sale Id shift 257664',0.00,0.00,0.00,2051.70,0.00,'2022-09-13 06:58:33','',''),(2641438,'5','91','643',255,'Sale Id shift 257664',0.00,0.00,0.00,3746.06,0.00,'2022-09-13 06:58:33','',''),(2641439,'5','91','644',255,'Sale Id shift 257664',0.00,0.00,0.00,3425.29,0.00,'2022-09-13 06:58:33','',''),(2641440,'5','91',NULL,255,'Sale Id shift 257664',1706264.25,0.00,0.00,0.00,0.00,'2022-09-13 06:58:33','',''),(2641441,'5','91','642',255,'Sale Id shift 257665',0.00,0.00,0.00,1771.67,0.00,'2022-09-13 22:04:35','',''),(2641442,'5','91','643',255,'Sale Id shift 257665',0.00,0.00,0.00,2579.44,0.00,'2022-09-13 22:04:35','',''),(2641443,'5','91',NULL,255,'Sale Id shift 257665',804955.35,0.00,0.00,0.00,0.00,'2022-09-13 22:04:35','',''),(2641444,'5','91','642',255,'Sale Id shift 257666',0.00,0.00,0.00,2457.63,0.00,'2022-09-14 21:54:06','',''),(2641445,'5','91','643',255,'Sale Id shift 257666',0.00,0.00,0.00,2967.79,0.00,'2022-09-14 21:54:06','',''),(2641446,'5','91','644',255,'Sale Id shift 257666',0.00,0.00,0.00,381.49,0.00,'2022-09-14 21:54:06','',''),(2641447,'5','91',NULL,255,'Sale Id shift 257666',1074278.35,0.00,0.00,0.00,0.00,'2022-09-14 21:54:06','',''),(2641448,'5','91','642',255,'Sale Id shift 257667',0.00,0.00,0.00,2678.07,0.00,'2022-09-16 09:33:52','',''),(2641449,'5','91','644',255,'Sale Id shift 257667',0.00,0.00,0.00,2333.18,0.00,'2022-09-16 09:33:52','',''),(2641450,'5','91',NULL,255,'Sale Id shift 257667',927081.25,0.00,0.00,0.00,0.00,'2022-09-16 09:33:52','',''),(2641451,'5','91','642',255,'Sale Id shift 257668',0.00,0.00,0.00,3407.99,0.00,'2022-09-17 07:54:36','',''),(2641452,'5','91','644',255,'Sale Id shift 257668',0.00,0.00,0.00,1805.84,0.00,'2022-09-17 07:54:36','',''),(2641453,'5','91',NULL,255,'Sale Id shift 257668',964558.55,0.00,0.00,0.00,0.00,'2022-09-17 07:54:36','',''),(2641454,'5','91','642',255,'Sale Id shift 257669',0.00,0.00,0.00,3826.81,0.00,'2022-09-18 10:32:07','',''),(2641455,'5','91','643',255,'Sale Id shift 257669',0.00,0.00,0.00,237.10,0.00,'2022-09-18 10:32:07','',''),(2641456,'5','91','644',255,'Sale Id shift 257669',0.00,0.00,0.00,1778.58,0.00,'2022-09-18 10:32:07','',''),(2641457,'5','91',NULL,255,'Sale Id shift 257669',1080860.65,0.00,0.00,0.00,0.00,'2022-09-18 10:32:07','',''),(2641458,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-09-18 10:32:56','',''),(2641459,'5','91',NULL,255,'Reception corrector for bridging 131545',0.00,0.00,0.00,15300.00,0.00,'2022-09-18 21:04:18','',''),(2641460,'5','91','643',255,'Received from bridging 131545',0.00,0.00,15300.00,0.00,0.00,'2022-09-18 21:04:18','',''),(2641461,'5','91',NULL,255,'Reception corrector for bridging 131544',0.00,0.00,0.00,14700.00,0.00,'2022-09-18 21:04:30','',''),(2641462,'5','91','642',255,'Received from bridging 131544',0.00,0.00,14700.00,0.00,0.00,'2022-09-18 21:04:30','',''),(2641463,'5','91','642',255,'Sale Id shift 257670',0.00,0.00,0.00,3228.26,0.00,'2022-09-19 10:42:17','',''),(2641464,'5','91','643',255,'Sale Id shift 257670',0.00,0.00,0.00,4072.70,0.00,'2022-09-19 10:42:17','',''),(2641465,'5','91',NULL,255,'Sale Id shift 257670',1350677.60,0.00,0.00,0.00,0.00,'2022-09-19 10:42:17','',''),(2641466,'5','91','642',255,'Sale Id shift 257671',0.00,0.00,0.00,2509.53,0.00,'2022-09-20 08:58:31','',''),(2641467,'5','91','643',255,'Sale Id shift 257671',0.00,0.00,0.00,3242.38,0.00,'2022-09-20 08:58:31','',''),(2641468,'5','91',NULL,255,'Sale Id shift 257671',1064103.35,0.00,0.00,0.00,0.00,'2022-09-20 08:58:31','',''),(2641469,'5','91','642',255,'Sale Id shift 257672',0.00,0.00,0.00,2844.83,0.00,'2022-09-21 07:06:32','',''),(2641470,'5','91','643',255,'Sale Id shift 257672',0.00,0.00,0.00,3283.34,0.00,'2022-09-21 07:06:32','',''),(2641471,'5','91',NULL,255,'Sale Id shift 257672',1133711.45,0.00,0.00,0.00,0.00,'2022-09-21 07:06:32','',''),(2641472,'5','91','642',255,'Sale Id shift 257673',0.00,0.00,0.00,2895.20,0.00,'2022-09-22 09:14:03','',''),(2641473,'5','91','643',255,'Sale Id shift 257673',0.00,0.00,0.00,3118.55,0.00,'2022-09-22 09:14:03','',''),(2641474,'5','91',NULL,255,'Sale Id shift 257673',1112543.75,0.00,0.00,0.00,0.00,'2022-09-22 09:14:03','',''),(2641475,'5','91','642',255,'Sale Id shift 257674',0.00,0.00,0.00,2461.26,0.00,'2022-09-23 10:17:41','',''),(2641476,'5','91','643',255,'Sale Id shift 257674',0.00,0.00,0.00,1589.27,0.00,'2022-09-23 10:17:41','',''),(2641477,'5','91',NULL,255,'Sale Id shift 257674',749348.05,0.00,0.00,0.00,0.00,'2022-09-23 10:17:41','',''),(2641478,'5','91','642',255,'Sale Id shift 257675',0.00,0.00,0.00,2475.21,0.00,'2022-09-24 08:49:32','',''),(2641479,'5','91',NULL,255,'Sale Id shift 257675',457913.85,0.00,0.00,0.00,0.00,'2022-09-24 08:49:32','',''),(2641480,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9203750.00,49750.00,0.00,0.00,'2022-09-27 19:22:04','',''),(2641481,'5','91',NULL,255,'Reception corrector for bridging 131546',0.00,0.00,0.00,17000.00,0.00,'2022-09-28 09:50:20','',''),(2641482,'5','91','642',255,'Received from bridging 131546',0.00,0.00,17000.00,0.00,0.00,'2022-09-28 09:50:20','',''),(2641483,'5','91','642',255,'Sale Id shift 257679',0.00,0.00,0.00,1050.02,0.00,'2022-09-28 10:14:16','',''),(2641484,'5','91','643',255,'Sale Id shift 257679',0.00,0.00,0.00,1205.44,0.00,'2022-09-28 10:14:16','',''),(2641485,'5','91',NULL,255,'Sale Id shift 257679',417260.10,0.00,0.00,0.00,0.00,'2022-09-28 10:14:16','',''),(2641486,'5','91','642',255,'Sale Id shift 257680',0.00,0.00,0.00,3447.58,0.00,'2022-09-29 07:10:59','',''),(2641487,'5','91','643',255,'Sale Id shift 257680',0.00,0.00,0.00,3803.63,0.00,'2022-09-29 07:10:59','',''),(2641488,'5','91',NULL,255,'Sale Id shift 257680',1341473.85,0.00,0.00,0.00,0.00,'2022-09-29 07:10:59','',''),(2641489,'5','91',NULL,255,'Reception corrector for bridging 131547',0.00,0.00,0.00,32750.00,0.00,'2022-09-29 14:53:23','',''),(2641490,'5','91','643',255,'Received from bridging 131547',0.00,0.00,32750.00,0.00,0.00,'2022-09-29 14:53:23','',''),(2641491,'5','91','642',255,'Sale Id shift 257681',0.00,0.00,0.00,3532.16,0.00,'2022-09-30 07:21:17','',''),(2641492,'5','91','643',255,'Sale Id shift 257681',0.00,0.00,0.00,5213.53,0.00,'2022-09-30 07:21:17','',''),(2641493,'5','91',NULL,255,'Sale Id shift 257681',1617952.65,0.00,0.00,0.00,0.00,'2022-09-30 07:21:17','',''),(2641494,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8251000.00,44600.00,0.00,0.00,'2022-09-30 12:23:37','',''),(2641495,'5','91','642',255,'Sale Id shift 257682',0.00,0.00,0.00,2895.12,0.00,'2022-10-01 07:31:14','',''),(2641496,'5','91','643',255,'Sale Id shift 257682',0.00,0.00,0.00,4302.60,0.00,'2022-10-01 07:31:14','',''),(2641497,'5','91',NULL,255,'Sale Id shift 257682',1331578.20,0.00,0.00,0.00,0.00,'2022-10-01 07:31:14','',''),(2641498,'5','91',NULL,255,'Reception corrector for bridging 131548',0.00,0.00,0.00,20500.00,0.00,'2022-10-01 20:48:03','',''),(2641499,'5','91','642',255,'Received from bridging 131548',0.00,0.00,20500.00,0.00,0.00,'2022-10-01 20:48:03','',''),(2641500,'5','91',NULL,255,'Reception corrector for bridging 131549',0.00,0.00,0.00,24100.00,0.00,'2022-10-01 20:48:15','',''),(2641501,'5','91','644',255,'Received from bridging 131549',0.00,0.00,24100.00,0.00,0.00,'2022-10-01 20:48:15','',''),(2641502,'5','91','642',255,'Sale Id shift 257683',0.00,0.00,0.00,3327.33,0.00,'2022-10-02 06:56:03','',''),(2641503,'5','91','643',255,'Sale Id shift 257683',0.00,0.00,0.00,729.86,0.00,'2022-10-02 06:56:03','',''),(2641504,'5','91','644',255,'Sale Id shift 257683',0.00,0.00,0.00,6715.78,0.00,'2022-10-02 06:56:03','',''),(2641505,'5','91',NULL,255,'Sale Id shift 257683',1992999.45,0.00,0.00,0.00,0.00,'2022-10-02 06:56:03','',''),(2641506,'5','91','642',255,'Sale Id shift 257684',0.00,0.00,0.00,2970.24,0.00,'2022-10-03 09:44:18','',''),(2641507,'5','91','643',255,'Sale Id shift 257684',0.00,0.00,0.00,4602.96,0.00,'2022-10-03 09:44:18','',''),(2641508,'5','91',NULL,255,'Sale Id shift 257684',1401042.00,0.00,0.00,0.00,0.00,'2022-10-03 09:44:18','',''),(2641509,'5','91','642',255,'Sale Id shift 257685',0.00,0.00,0.00,2486.97,0.00,'2022-10-04 07:11:02','',''),(2641510,'5','91','643',255,'Sale Id shift 257685',0.00,0.00,0.00,1021.42,0.00,'2022-10-04 07:11:02','',''),(2641511,'5','91','644',255,'Sale Id shift 257685',0.00,0.00,0.00,6514.03,0.00,'2022-10-04 07:11:02','',''),(2641512,'5','91',NULL,255,'Sale Id shift 257685',1854147.70,0.00,0.00,0.00,0.00,'2022-10-04 07:11:02','',''),(2641513,'5','91','642',255,'Sale Id shift 257686',0.00,0.00,0.00,3239.86,0.00,'2022-10-05 10:03:01','',''),(2641514,'5','91','643',255,'Sale Id shift 257686',0.00,0.00,0.00,3885.36,0.00,'2022-10-05 10:03:01','',''),(2641515,'5','91',NULL,255,'Sale Id shift 257686',1318165.70,0.00,0.00,0.00,0.00,'2022-10-05 10:03:01','',''),(2641516,'5','91','642',255,'Sale Id shift 257687',0.00,0.00,0.00,2029.83,0.00,'2022-10-06 06:56:07','',''),(2641517,'5','91','643',255,'Sale Id shift 257687',0.00,0.00,0.00,2256.93,0.00,'2022-10-06 06:56:07','',''),(2641518,'5','91','644',255,'Sale Id shift 257687',0.00,0.00,0.00,3288.98,0.00,'2022-10-06 06:56:07','',''),(2641519,'5','91',NULL,255,'Sale Id shift 257687',1401511.90,0.00,0.00,0.00,0.00,'2022-10-06 06:56:07','',''),(2641520,'5','91','642',255,'Sale Id shift 257688',0.00,0.00,0.00,153.51,0.00,'2022-10-07 06:55:43','',''),(2641521,'5','91','643',255,'Sale Id shift 257688',0.00,0.00,0.00,4602.26,0.00,'2022-10-07 06:55:43','',''),(2641522,'5','91','644',255,'Sale Id shift 257688',0.00,0.00,0.00,6424.99,0.00,'2022-10-07 06:55:43','',''),(2641523,'5','91',NULL,255,'Sale Id shift 257688',2068440.60,0.00,0.00,0.00,0.00,'2022-10-07 06:55:43','',''),(2641524,'5','91','642',255,'Sale Id shift 257689',0.00,0.00,0.00,2894.52,0.00,'2022-10-08 11:33:37','',''),(2641525,'5','91','643',255,'Sale Id shift 257689',0.00,0.00,0.00,2306.85,0.00,'2022-10-08 11:33:37','',''),(2641526,'5','91','644',255,'Sale Id shift 257689',0.00,0.00,0.00,938.40,0.00,'2022-10-08 11:33:37','',''),(2641527,'5','91',NULL,255,'Sale Id shift 257689',1135857.45,0.00,0.00,0.00,0.00,'2022-10-08 11:33:37','',''),(2641528,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-10-09 11:17:09','',''),(2641529,'5','91',NULL,255,'Reception corrector for bridging 131551',0.00,0.00,0.00,15250.00,0.00,'2022-10-09 15:27:22','',''),(2641530,'5','91','644',255,'Received from bridging 131551',0.00,0.00,15250.00,0.00,0.00,'2022-10-09 15:27:22','',''),(2641531,'5','91','642',255,'Sale Id shift 257690',0.00,0.00,0.00,1842.70,0.00,'2022-10-09 18:17:20','',''),(2641532,'5','91','643',255,'Sale Id shift 257690',0.00,0.00,0.00,3759.89,0.00,'2022-10-09 18:17:20','',''),(2641533,'5','91','644',255,'Sale Id shift 257690',0.00,0.00,0.00,5969.40,0.00,'2022-10-09 18:17:20','',''),(2641534,'5','91',NULL,255,'Sale Id shift 257690',2140818.15,0.00,0.00,0.00,0.00,'2022-10-09 18:17:20','',''),(2641535,'5','91',NULL,255,'Reception corrector for bridging 131550',0.00,0.00,0.00,29750.00,0.00,'2022-10-09 20:09:35','',''),(2641536,'5','91','643',255,'Received from bridging 131550',0.00,0.00,29750.00,0.00,0.00,'2022-10-09 20:09:35','',''),(2641537,'5','91','642',255,'Sale Id shift 257691',0.00,0.00,0.00,3096.02,0.00,'2022-10-10 08:56:22','',''),(2641538,'5','91','643',255,'Sale Id shift 257691',0.00,0.00,0.00,6282.08,0.00,'2022-10-10 08:56:22','',''),(2641539,'5','91','644',255,'Sale Id shift 257691',0.00,0.00,0.00,187.71,0.00,'2022-10-10 08:56:22','',''),(2641540,'5','91',NULL,255,'Sale Id shift 257691',1769674.85,0.00,0.00,0.00,0.00,'2022-10-10 08:56:22','',''),(2641541,'5','91','642',255,'Sale Id shift 257692',0.00,0.00,0.00,500.00,0.00,'2022-10-11 12:12:58','',''),(2641542,'5','91','643',255,'Sale Id shift 257692',0.00,0.00,0.00,2956.75,0.00,'2022-10-11 12:12:58','',''),(2641543,'5','91','644',255,'Sale Id shift 257692',0.00,0.00,0.00,5269.11,0.00,'2022-10-11 12:12:58','',''),(2641544,'5','91',NULL,255,'Sale Id shift 257692',1614284.10,0.00,0.00,0.00,0.00,'2022-10-11 12:12:58','',''),(2641545,'5','91','642',255,'Sale Id shift 257693',0.00,0.00,0.00,3929.87,0.00,'2022-10-12 12:28:52','',''),(2641546,'5','91','643',255,'Sale Id shift 257693',0.00,0.00,0.00,4282.01,0.00,'2022-10-12 12:28:52','',''),(2641547,'5','91',NULL,255,'Sale Id shift 257693',1519197.80,0.00,0.00,0.00,0.00,'2022-10-12 12:28:52','',''),(2641548,'5','91','643',255,'Sale Id shift 257694',0.00,0.00,0.00,4732.21,0.00,'2022-10-13 04:21:13','',''),(2641549,'5','91','644',255,'Sale Id shift 257694',0.00,0.00,0.00,3760.85,0.00,'2022-10-13 04:21:13','',''),(2641550,'5','91',NULL,255,'Sale Id shift 257694',1571216.10,0.00,0.00,0.00,0.00,'2022-10-13 04:21:13','',''),(2641551,'5','91','642',255,'Sale Id shift 257695',0.00,0.00,0.00,159.99,0.00,'2022-10-14 10:18:44','',''),(2641552,'5','91','643',255,'Sale Id shift 257695',0.00,0.00,0.00,4749.03,0.00,'2022-10-14 10:18:44','',''),(2641553,'5','91',NULL,255,'Sale Id shift 257695',908168.70,0.00,0.00,0.00,0.00,'2022-10-14 10:18:44','',''),(2641554,'5','91','643',255,'Sale Id shift 257696',0.00,0.00,0.00,2117.85,0.00,'2022-10-15 14:08:00','',''),(2641555,'5','91',NULL,255,'Sale Id shift 257696',391802.25,0.00,0.00,0.00,0.00,'2022-10-15 14:08:00','',''),(2641556,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,11100000.00,60000.00,0.00,0.00,'2022-11-08 22:32:18','',''),(2641557,'5','91',NULL,255,'Reception corrector for bridging 131552',0.00,0.00,0.00,30100.00,0.00,'2022-11-09 22:07:20','',''),(2641558,'5','91','642',255,'Received from bridging 131552',0.00,0.00,30100.00,0.00,0.00,'2022-11-09 22:07:20','',''),(2641559,'5','91','643',255,'Sale Id shift 257721',0.00,0.00,0.00,3045.03,0.00,'2022-11-10 10:41:04','',''),(2641560,'5','91',NULL,255,'Sale Id shift 257721',563330.55,0.00,0.00,0.00,0.00,'2022-11-10 10:41:04','',''),(2641561,'5','91',NULL,255,'Reception corrector for bridging 131553',0.00,0.00,0.00,29900.00,0.00,'2022-11-10 12:31:57','',''),(2641562,'5','91','643',255,'Received from bridging 131553',0.00,0.00,29900.00,0.00,0.00,'2022-11-10 12:31:57','',''),(2641563,'5','91','642',255,'Sale Id shift 257722',0.00,0.00,0.00,6715.13,0.00,'2022-11-10 19:02:29','',''),(2641564,'5','91','643',255,'Sale Id shift 257722',0.00,0.00,0.00,2485.94,0.00,'2022-11-10 19:02:29','',''),(2641565,'5','91',NULL,255,'Sale Id shift 257722',1702197.95,0.00,0.00,0.00,0.00,'2022-11-10 19:02:29','',''),(2641566,'5','91','642',255,'Sale Id shift 257723',0.00,0.00,0.00,4706.82,0.00,'2022-11-11 11:25:47','',''),(2641567,'5','91','643',255,'Sale Id shift 257723',0.00,0.00,0.00,4551.28,0.00,'2022-11-11 11:25:47','',''),(2641568,'5','91',NULL,255,'Sale Id shift 257723',1712748.50,0.00,0.00,0.00,0.00,'2022-11-11 11:25:47','',''),(2641569,'5','91','642',255,'Sale Id shift 257724',0.00,0.00,0.00,4328.43,0.00,'2022-11-12 10:00:05','',''),(2641570,'5','91','643',255,'Sale Id shift 257724',0.00,0.00,0.00,5257.74,0.00,'2022-11-12 10:00:05','',''),(2641571,'5','91',NULL,255,'Sale Id shift 257724',1773441.45,0.00,0.00,0.00,0.00,'2022-11-12 10:00:05','',''),(2641572,'5','91','642',255,'Sale Id shift 257725',0.00,0.00,0.00,1548.49,0.00,'2022-11-12 23:49:01','',''),(2641573,'5','91','643',255,'Sale Id shift 257725',0.00,0.00,0.00,6605.55,0.00,'2022-11-12 23:49:01','',''),(2641574,'5','91',NULL,255,'Sale Id shift 257725',1508497.40,0.00,0.00,0.00,0.00,'2022-11-12 23:49:01','',''),(2641575,'5','91','642',255,'Sale Id shift 257726',0.00,0.00,0.00,1811.17,0.00,'2022-11-14 07:21:03','',''),(2641576,'5','91','643',255,'Sale Id shift 257726',0.00,0.00,0.00,5265.17,0.00,'2022-11-14 07:21:03','',''),(2641577,'5','91',NULL,255,'Sale Id shift 257726',1309122.90,0.00,0.00,0.00,0.00,'2022-11-14 07:21:03','',''),(2641578,'5','91','642',255,'Sale Id shift 257727',0.00,0.00,0.00,2814.07,0.00,'2022-11-14 23:38:37','',''),(2641579,'5','91','643',255,'Sale Id shift 257727',0.00,0.00,0.00,2951.45,0.00,'2022-11-14 23:38:37','',''),(2641580,'5','91',NULL,255,'Sale Id shift 257727',1066621.20,0.00,0.00,0.00,0.00,'2022-11-14 23:38:37','',''),(2641581,'5','91','642',255,'Sale Id shift 257728',0.00,0.00,0.00,5568.59,0.00,'2022-11-16 07:50:49','',''),(2641582,'5','91',NULL,255,'Sale Id shift 257728',1030189.15,0.00,0.00,0.00,0.00,'2022-11-16 07:50:49','',''),(2641583,'5','91','642',255,'Sale Id shift 257729',0.00,0.00,0.00,2438.60,0.00,'2022-11-17 09:33:36','',''),(2641584,'5','91',NULL,255,'Sale Id shift 257729',451141.00,0.00,0.00,0.00,0.00,'2022-11-17 09:33:36','',''),(2641585,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,11026000.00,59600.00,0.00,0.00,'2022-11-20 07:33:03','',''),(2641586,'5','91',NULL,255,'Reception corrector for bridging 131554',0.00,0.00,0.00,29800.00,0.00,'2022-11-20 13:13:19','',''),(2641587,'5','91','642',255,'Received from bridging 131554',0.00,0.00,29800.00,0.00,0.00,'2022-11-20 13:13:19','',''),(2641588,'5','91',NULL,255,'Reception corrector for bridging 131555',0.00,0.00,0.00,29800.00,0.00,'2022-11-20 13:13:34','',''),(2641589,'5','91','643',255,'Received from bridging 131555',0.00,0.00,29800.00,0.00,0.00,'2022-11-20 13:13:34','',''),(2641590,'5','91','642',255,'Sale Id shift 257732',0.00,0.00,0.00,1700.01,0.00,'2022-11-20 14:50:07','',''),(2641591,'5','91','643',255,'Sale Id shift 257732',0.00,0.00,0.00,1380.00,0.00,'2022-11-20 14:50:07','',''),(2641592,'5','91',NULL,255,'Sale Id shift 257732',569801.85,0.00,0.00,0.00,0.00,'2022-11-20 14:50:07','',''),(2641593,'5','91','642',255,'Sale Id shift 257733',0.00,0.00,0.00,2655.80,0.00,'2022-11-21 09:34:31','',''),(2641594,'5','91','643',255,'Sale Id shift 257733',0.00,0.00,0.00,5770.98,0.00,'2022-11-21 09:34:31','',''),(2641595,'5','91',NULL,255,'Sale Id shift 257733',1558954.30,0.00,0.00,0.00,0.00,'2022-11-21 09:34:31','',''),(2641596,'5','91','642',255,'Sale Id shift 257734',0.00,0.00,0.00,3521.64,0.00,'2022-11-22 09:01:25','',''),(2641597,'5','91','643',255,'Sale Id shift 257734',0.00,0.00,0.00,5501.85,0.00,'2022-11-22 09:01:25','',''),(2641598,'5','91',NULL,255,'Sale Id shift 257734',1669345.65,0.00,0.00,0.00,0.00,'2022-11-22 09:01:25','',''),(2641599,'5','91','642',255,'Sale Id shift 257735',0.00,0.00,0.00,4489.64,0.00,'2022-11-23 09:37:08','',''),(2641600,'5','91','643',255,'Sale Id shift 257735',0.00,0.00,0.00,5740.66,0.00,'2022-11-23 09:37:08','',''),(2641601,'5','91',NULL,255,'Sale Id shift 257735',1892605.50,0.00,0.00,0.00,0.00,'2022-11-23 09:37:08','',''),(2641602,'5','91','642',255,'Sale Id shift 257736',0.00,0.00,0.00,3329.52,0.00,'2022-11-24 08:55:10','',''),(2641603,'5','91','643',255,'Sale Id shift 257736',0.00,0.00,0.00,3705.97,0.00,'2022-11-24 08:55:10','',''),(2641604,'5','91',NULL,255,'Sale Id shift 257736',1301565.65,0.00,0.00,0.00,0.00,'2022-11-24 08:55:10','',''),(2641605,'5','91','642',255,'Sale Id shift 257737',0.00,0.00,0.00,3322.51,0.00,'2022-11-25 11:11:46','',''),(2641606,'5','91','643',255,'Sale Id shift 257737',0.00,0.00,0.00,3743.17,0.00,'2022-11-25 11:11:46','',''),(2641607,'5','91',NULL,255,'Sale Id shift 257737',1307150.80,0.00,0.00,0.00,0.00,'2022-11-25 11:11:46','',''),(2641608,'5','91','642',255,'Sale Id shift 257738',0.00,0.00,0.00,2996.31,0.00,'2022-11-26 07:42:38','',''),(2641609,'5','91','643',255,'Sale Id shift 257738',0.00,0.00,0.00,3575.24,0.00,'2022-11-26 07:42:38','',''),(2641610,'5','91',NULL,255,'Sale Id shift 257738',1215736.75,0.00,0.00,0.00,0.00,'2022-11-26 07:42:38','',''),(2641611,'5','91','642',255,'Sale Id shift 257739',0.00,0.00,0.00,5132.18,0.00,'2022-11-27 08:57:29','',''),(2641612,'5','91','643',255,'Sale Id shift 257739',0.00,0.00,0.00,540.53,0.00,'2022-11-27 08:57:29','',''),(2641613,'5','91',NULL,255,'Sale Id shift 257739',1049451.35,0.00,0.00,0.00,0.00,'2022-11-27 08:57:29','',''),(2641614,'5','91','642',255,'Sale Id shift 257740',0.00,0.00,0.00,2491.87,0.00,'2022-11-28 09:45:31','',''),(2641615,'5','91',NULL,255,'Sale Id shift 257740',460995.95,0.00,0.00,0.00,0.00,'2022-11-28 09:45:31','',''),(2641616,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9203750.00,49750.00,0.00,0.00,'2023-01-19 22:46:58','',''),(2641617,'5','91',NULL,255,'Reception corrector for bridging 131556',0.00,0.00,0.00,17000.00,0.00,'2023-01-20 11:14:59','',''),(2641618,'5','91','642',255,'Received from bridging 131556',0.00,0.00,17000.00,0.00,0.00,'2023-01-20 11:14:59','',''),(2641619,'5','91','642',255,'Sale Id shift 257793',0.00,0.00,0.00,1461.50,0.00,'2023-01-20 13:09:35','',''),(2641620,'5','91','643',255,'Sale Id shift 257793',0.00,0.00,0.00,968.87,0.00,'2023-01-20 13:09:35','',''),(2641621,'5','91',NULL,255,'Sale Id shift 257793',449618.45,0.00,0.00,0.00,0.00,'2023-01-20 13:09:35','',''),(2641622,'5','91',NULL,255,'Reception corrector for bridging 131558',0.00,0.00,0.00,25000.00,0.00,'2023-01-20 16:46:55','',''),(2641623,'5','91','643',255,'Received from bridging 131558',0.00,0.00,25000.00,0.00,0.00,'2023-01-20 16:46:55','',''),(2641624,'5','91','642',255,'Sale Id shift 257794',0.00,0.00,0.00,4055.31,0.00,'2023-01-20 23:50:10','',''),(2641625,'5','91','643',255,'Sale Id shift 257794',0.00,0.00,0.00,3376.69,0.00,'2023-01-20 23:50:10','',''),(2641626,'5','91',NULL,255,'Sale Id shift 257794',1374920.00,0.00,0.00,0.00,0.00,'2023-01-20 23:50:10','',''),(2641627,'5','91','642',255,'Sale Id shift 257796',0.00,0.00,0.00,721.08,0.00,'2023-01-21 06:55:51','',''),(2641628,'5','91','643',255,'Sale Id shift 257796',0.00,0.00,0.00,3854.97,0.00,'2023-01-21 06:55:51','',''),(2641629,'5','91',NULL,255,'Sale Id shift 257796',1006731.00,0.00,0.00,0.00,0.00,'2023-01-21 06:55:51','',''),(2641630,'5','91','642',255,'Sale Id shift 257797',0.00,0.00,0.00,3842.43,0.00,'2023-01-22 10:41:01','',''),(2641631,'5','91','643',255,'Sale Id shift 257797',0.00,0.00,0.00,6251.11,0.00,'2023-01-22 10:41:01','',''),(2641632,'5','91',NULL,255,'Sale Id shift 257797',2220578.80,0.00,0.00,0.00,0.00,'2023-01-22 10:41:01','',''),(2641633,'5','91','642',255,'Sale Id shift 257798',0.00,0.00,0.00,4172.06,0.00,'2023-01-23 09:06:34','',''),(2641634,'5','91','643',255,'Sale Id shift 257798',0.00,0.00,0.00,8537.27,0.00,'2023-01-23 09:06:34','',''),(2641635,'5','91',NULL,255,'Sale Id shift 257798',2796052.60,0.00,0.00,0.00,0.00,'2023-01-23 09:06:34','',''),(2641636,'5','91',NULL,255,'Reception corrector for bridging 131559',0.00,0.00,0.00,7750.00,0.00,'2023-01-23 17:41:17','',''),(2641637,'5','91','643',255,'Received from bridging 131559',0.00,0.00,7750.00,0.00,0.00,'2023-01-23 17:41:17','',''),(2641638,'5','91','642',255,'Sale Id shift 257799',0.00,0.00,0.00,2757.81,0.00,'2023-01-24 07:20:42','',''),(2641639,'5','91','643',255,'Sale Id shift 257799',0.00,0.00,0.00,6988.64,0.00,'2023-01-24 07:20:42','',''),(2641640,'5','91',NULL,255,'Sale Id shift 257799',2144219.00,0.00,0.00,0.00,0.00,'2023-01-24 07:20:42','',''),(2641641,'5','91','643',255,'Sale Id shift 257800',0.00,0.00,0.00,2797.90,0.00,'2023-01-25 09:20:48','',''),(2641642,'5','91',NULL,255,'Sale Id shift 257800',615538.00,0.00,0.00,0.00,0.00,'2023-01-25 09:20:48','',''),(2641643,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,10479000.00,49900.00,0.00,0.00,'2023-03-01 07:30:27','',''),(2641644,'5','91',NULL,255,'Reception corrector for bridging 131560',0.00,0.00,0.00,18400.00,0.00,'2023-03-01 09:53:22','',''),(2641645,'5','91','642',255,'Received from bridging 131560',0.00,0.00,18400.00,0.00,0.00,'2023-03-01 09:53:22','',''),(2641646,'5','91',NULL,255,'Reception corrector for bridging 131562',0.00,0.00,0.00,25000.00,0.00,'2023-03-01 10:24:45','',''),(2641647,'5','91','643',255,'Received from bridging 131562',0.00,0.00,25000.00,0.00,0.00,'2023-03-01 10:24:45','',''),(2641648,'5','91','642',255,'Sale Id shift 257835',0.00,0.00,0.00,2324.80,0.00,'2023-03-02 10:07:28','',''),(2641649,'5','91','643',255,'Sale Id shift 257835',0.00,0.00,0.00,1968.89,0.00,'2023-03-02 10:07:28','',''),(2641650,'5','91',NULL,255,'Sale Id shift 257835',901674.90,0.00,0.00,0.00,0.00,'2023-03-02 10:07:28','',''),(2641651,'5','91','642',255,'Sale Id shift 257836',0.00,0.00,0.00,5949.46,0.00,'2023-03-02 15:15:49','',''),(2641652,'5','91','643',255,'Sale Id shift 257836',0.00,0.00,0.00,4512.85,0.00,'2023-03-02 15:15:49','',''),(2641653,'5','91',NULL,255,'Sale Id shift 257836',2197085.10,0.00,0.00,0.00,0.00,'2023-03-02 15:15:49','',''),(2641654,'5','91','642',255,'Sale Id shift 257837',0.00,0.00,0.00,3995.11,0.00,'2023-03-03 09:19:11','',''),(2641655,'5','91','643',255,'Sale Id shift 257837',0.00,0.00,0.00,8211.05,0.00,'2023-03-03 09:19:11','',''),(2641656,'5','91',NULL,255,'Sale Id shift 257837',2563293.60,0.00,0.00,0.00,0.00,'2023-03-03 09:19:11','',''),(2641657,'5','91',NULL,255,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,10500000.00,50000.00,0.00,0.00,'2023-03-03 09:19:47','',''),(2641658,'5','91',NULL,255,'Reception corrector for bridging 131563',0.00,0.00,0.00,25000.00,0.00,'2023-03-03 17:39:19','',''),(2641659,'5','91','644',255,'Received from bridging 131563',0.00,0.00,25000.00,0.00,0.00,'2023-03-03 17:39:19','',''),(2641660,'5','91','642',255,'Sale Id shift 257838',0.00,0.00,0.00,2785.67,0.00,'2023-03-04 08:45:13','',''),(2641661,'5','91','643',255,'Sale Id shift 257838',0.00,0.00,0.00,4759.12,0.00,'2023-03-04 08:45:13','',''),(2641662,'5','91','644',255,'Sale Id shift 257838',0.00,0.00,0.00,2460.57,0.00,'2023-03-04 08:45:13','',''),(2641663,'5','91',NULL,255,'Sale Id shift 257838',2101125.60,0.00,0.00,0.00,0.00,'2023-03-04 08:45:13','',''),(2641664,'5','91','642',255,'Sale Id shift 257839',0.00,0.00,0.00,3631.84,0.00,'2023-03-05 09:42:54','',''),(2641665,'5','91','643',255,'Sale Id shift 257839',0.00,0.00,0.00,3508.78,0.00,'2023-03-05 09:42:54','',''),(2641666,'5','91','644',255,'Sale Id shift 257839',0.00,0.00,0.00,5959.40,0.00,'2023-03-05 09:42:54','',''),(2641667,'5','91',NULL,255,'Sale Id shift 257839',2751004.20,0.00,0.00,0.00,0.00,'2023-03-05 09:42:54','',''),(2641668,'5','91',NULL,255,'Reception corrector for bridging 131564',0.00,0.00,0.00,6500.00,0.00,'2023-03-05 16:48:23','',''),(2641669,'5','91','643',255,'Received from bridging 131564',0.00,0.00,6500.00,0.00,0.00,'2023-03-05 16:48:23','',''),(2641670,'5','91',NULL,255,'Reception corrector for bridging 131565',0.00,0.00,0.00,17000.00,0.00,'2023-03-06 09:40:18','',''),(2641671,'5','91','642',255,'Received from bridging 131565',0.00,0.00,17000.00,0.00,0.00,'2023-03-06 09:40:18','',''),(2641672,'5','91','642',255,'Sale Id shift 257840',0.00,0.00,0.00,3515.48,0.00,'2023-03-06 10:33:43','',''),(2641673,'5','91','643',255,'Sale Id shift 257840',0.00,0.00,0.00,2755.10,0.00,'2023-03-06 10:33:43','',''),(2641674,'5','91','644',255,'Sale Id shift 257840',0.00,0.00,0.00,4736.63,0.00,'2023-03-06 10:33:43','',''),(2641675,'5','91',NULL,255,'Sale Id shift 257840',2311514.10,0.00,0.00,0.00,0.00,'2023-03-06 10:33:43','',''),(2641676,'5','91','642',255,'Sale Id shift 257841',0.00,0.00,0.00,2901.16,0.00,'2023-03-07 09:25:04','',''),(2641677,'5','91','643',255,'Sale Id shift 257841',0.00,0.00,0.00,4363.72,0.00,'2023-03-07 09:25:04','',''),(2641678,'5','91','644',255,'Sale Id shift 257841',0.00,0.00,0.00,5310.92,0.00,'2023-03-07 09:25:04','',''),(2641679,'5','91',NULL,255,'Sale Id shift 257841',2640918.00,0.00,0.00,0.00,0.00,'2023-03-07 09:25:04','',''),(2641680,'5','91',NULL,255,'Reception corrector for bridging 131566',0.00,0.00,0.00,8000.00,0.00,'2023-03-07 15:40:01','',''),(2641681,'5','91','644',255,'Received from bridging 131566',0.00,0.00,8000.00,0.00,0.00,'2023-03-07 15:40:01','',''),(2641682,'5','91','642',255,'Sale Id shift 257842',0.00,0.00,0.00,2410.78,0.00,'2023-03-08 09:49:46','',''),(2641683,'5','91','643',255,'Sale Id shift 257842',0.00,0.00,0.00,1638.86,0.00,'2023-03-08 09:49:46','',''),(2641684,'5','91','644',255,'Sale Id shift 257842',0.00,0.00,0.00,5293.27,0.00,'2023-03-08 09:49:46','',''),(2641685,'5','91',NULL,255,'Sale Id shift 257842',1962011.10,0.00,0.00,0.00,0.00,'2023-03-08 09:49:46','',''),(2641686,'5','91','642',255,'Sale Id shift 257843',0.00,0.00,0.00,3353.67,0.00,'2023-03-09 09:48:32','',''),(2641687,'5','91','644',255,'Sale Id shift 257843',0.00,0.00,0.00,4575.69,0.00,'2023-03-09 09:48:32','',''),(2641688,'5','91',NULL,255,'Sale Id shift 257843',1665165.60,0.00,0.00,0.00,0.00,'2023-03-09 09:48:32','',''),(2641689,'5','91','642',255,'Sale Id shift 257844',0.00,0.00,0.00,1709.52,0.00,'2023-03-10 09:17:15','',''),(2641690,'5','91','644',255,'Sale Id shift 257844',0.00,0.00,0.00,4177.90,0.00,'2023-03-10 09:17:15','',''),(2641691,'5','91',NULL,255,'Sale Id shift 257844',1236358.20,0.00,0.00,0.00,0.00,'2023-03-10 09:17:15','',''),(2641692,'5','91','642',255,'Sale Id shift 257845',0.00,0.00,0.00,2920.79,0.00,'2023-03-11 09:36:08','',''),(2641693,'5','91','644',255,'Sale Id shift 257845',0.00,0.00,0.00,55.63,0.00,'2023-03-11 09:36:08','',''),(2641694,'5','91',NULL,255,'Sale Id shift 257845',625048.20,0.00,0.00,0.00,0.00,'2023-03-11 09:36:08','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','91',257,0.00,'2023-03-20 19:26:31'),(2,'5','91',256,102.00,'2023-03-20 19:26:31'),(3,'5','91',255,3946.44,'2023-03-20 19:26:31');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1826187 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1314381,'5','91',255,'Sale Id shift 231309',0.00,684075.14,163.00,684075.14,0.00,'2021-10-13 16:41:48'),(1314442,'5','91',255,'Sale Id shift 231315',0.00,1129673.13,163.00,1129673.13,0.00,'2021-10-13 16:54:17'),(1315394,'5','91',255,'Sale Id shift 231421',0.00,679369.33,163.00,679369.33,0.00,'2021-10-14 08:48:48'),(1315885,'5','91',255,'Sale Id shift 231471',0.00,664373.33,163.00,664373.33,0.00,'2021-10-14 10:59:23'),(1315939,'5','91',255,'Sale Id shift 231476',0.00,361313.95,163.00,361313.95,0.00,'2021-10-14 11:09:10'),(1315990,'5','91',255,'Sale Id shift 231478',0.00,246133.26,163.00,246133.26,0.00,'2021-10-14 11:19:19'),(1324193,'5','91',255,'Sale Id shift 231934',0.00,1046632.78,163.00,1046632.78,0.00,'2021-10-17 06:51:48'),(1327151,'5','91',255,'Sale Id shift 232197',0.00,695654.66,163.00,695654.66,0.00,'2021-10-18 06:14:40'),(1330833,'5','91',255,'Sale Id shift 232405',0.00,1380147.08,163.00,1380147.08,0.00,'2021-10-19 05:54:54'),(1333965,'5','91',255,'Sale Id shift 232698',0.00,794413.10,163.00,794413.10,0.00,'2021-10-20 05:52:23'),(1340653,'5','91',255,'Sale Id shift 232859',0.00,902291.39,163.00,902291.39,0.00,'2021-10-21 17:04:59'),(1340927,'5','91',255,'Sale Id shift 233309',0.00,681499.74,163.00,681499.74,0.00,'2021-10-22 06:00:59'),(1344372,'5','91',255,'Sale Id shift 233428',0.00,763524.60,163.00,763524.60,0.00,'2021-10-23 06:19:22'),(1350021,'5','91',255,'Sale Id shift 233641',0.00,1320956.89,163.00,1320956.89,0.00,'2021-10-24 13:05:49'),(1351407,'5','91',255,'Sale Id shift 234004',0.00,803875.25,163.00,803875.25,0.00,'2021-10-25 06:06:50'),(1354750,'5','91',255,'Sale Id shift 234074',0.00,1020500.62,163.00,1020500.62,0.00,'2021-10-26 05:41:57'),(1359454,'5','91',255,'Sale Id shift 234648',0.00,777559.20,165.00,777559.20,0.00,'2021-10-27 10:58:03'),(1361841,'5','91',255,'Sale Id shift 234732',0.00,922023.30,165.00,922023.30,0.00,'2021-10-28 07:22:15'),(1364845,'5','91',255,'Sale Id shift 234901',0.00,821508.60,165.00,821508.60,0.00,'2021-10-29 06:09:10'),(1367899,'5','91',255,'Sale Id shift 235129',0.00,960039.30,165.00,960039.30,0.00,'2021-10-30 07:15:57'),(1371096,'5','91',255,'Sale Id shift 235449',0.00,1224557.40,165.00,1224557.40,0.00,'2021-10-31 06:14:09'),(1374368,'5','91',255,'Sale Id shift 235609',0.00,1158222.45,165.00,1158222.45,0.00,'2021-11-01 07:26:16'),(1376952,'5','91',255,'Sale Id shift 235896',0.00,1307941.80,165.00,1307941.80,0.00,'2021-11-02 06:20:46'),(1379207,'5','91',255,'Sale Id shift 236096',0.00,786152.40,165.00,786152.40,0.00,'2021-11-03 06:25:10'),(1382896,'5','91',255,'Sale Id shift 236458',0.00,553050.30,165.00,553050.30,0.00,'2021-11-04 06:15:50'),(1387973,'5','91',255,'Sale Id shift 236693',0.00,559350.00,165.00,559350.00,0.00,'2021-11-05 06:35:48'),(1392892,'5','91',255,'Sale Id shift 236814',0.00,70827.90,165.00,70827.90,0.00,'2021-11-06 07:06:25'),(1402436,'5','91',256,'Sale Id shift 237253',0.00,40707.00,345.00,46813.05,6106.05,'2021-11-08 06:33:27'),(1406636,'5','91',256,'Sale Id shift 237494',0.00,56086.65,345.00,56086.65,0.00,'2021-11-09 06:16:44'),(1411051,'5','91',256,'Sale Id shift 237689',0.00,122478.45,345.00,122478.45,0.00,'2021-11-10 05:52:54'),(1416010,'5','91',256,'Sale Id shift 238065',0.00,139794.00,345.00,139794.00,0.00,'2021-11-11 05:48:48'),(1421818,'5','91',256,'Sale Id shift 238182',0.00,284024.70,345.00,284024.70,0.00,'2021-11-12 07:29:18'),(1426224,'5','91',256,'Sale Id shift 238573',0.00,89703.45,345.00,89703.45,0.00,'2021-11-13 07:07:07'),(1430607,'5','91',256,'Sale Id shift 238701',0.00,244936.20,345.00,244936.20,0.00,'2021-11-14 05:50:53'),(1435267,'5','91',256,'Sale Id shift 238884',0.00,297859.20,345.00,297859.20,0.00,'2021-11-15 06:24:08'),(1439694,'5','91',256,'Sale Id shift 239244',0.00,490200.15,345.00,490200.15,0.00,'2021-11-16 07:17:56'),(1443112,'5','91',256,'Sale Id shift 239479',0.00,437377.20,345.00,437377.20,0.00,'2021-11-17 05:48:20'),(1447496,'5','91',256,'Sale Id shift 239699',0.00,192030.45,345.00,192030.45,0.00,'2021-11-18 06:08:29'),(1455809,'5','91',255,'Sale Id shift 239943',0.00,1459401.90,165.00,1459401.90,0.00,'2021-11-19 19:29:17'),(1455810,'5','91',256,'Sale Id shift 239943',0.00,201931.95,345.00,201931.95,0.00,'2021-11-19 19:29:17'),(1456356,'5','91',255,'Sale Id shift 240158',0.00,919414.65,165.00,919414.65,0.00,'2021-11-20 07:10:08'),(1456357,'5','91',256,'Sale Id shift 240158',0.00,276358.80,345.00,276358.80,0.00,'2021-11-20 07:10:08'),(1461115,'5','91',255,'Sale Id shift 240387',0.00,1605921.90,165.00,1605921.90,0.00,'2021-11-21 06:40:30'),(1461116,'5','91',256,'Sale Id shift 240387',0.00,276341.55,345.00,276341.55,0.00,'2021-11-21 06:40:30'),(1465789,'5','91',255,'Sale Id shift 240595',0.00,1192393.95,165.00,1192393.95,0.00,'2021-11-22 06:22:35'),(1465790,'5','91',256,'Sale Id shift 240595',0.00,307436.40,345.00,307436.40,0.00,'2021-11-22 06:22:35'),(1470778,'5','91',255,'Sale Id shift 240778',0.00,1458047.25,165.00,1458047.25,0.00,'2021-11-23 07:02:45'),(1470779,'5','91',256,'Sale Id shift 240778',0.00,431094.75,345.00,431094.75,0.00,'2021-11-23 07:02:45'),(1475240,'5','91',255,'Sale Id shift 241191',0.00,603093.15,165.00,603093.15,0.00,'2021-11-24 06:23:09'),(1475241,'5','91',256,'Sale Id shift 241191',0.00,455372.40,345.00,455372.40,0.00,'2021-11-24 06:23:09'),(1479204,'5','91',256,'Sale Id shift 241431',0.00,108385.20,345.00,108385.20,0.00,'2021-11-25 06:27:33'),(1483448,'5','91',256,'Sale Id shift 241592',0.00,97321.05,345.00,97321.05,0.00,'2021-11-26 06:11:49'),(1488094,'5','91',256,'Sale Id shift 241919',0.00,100077.60,345.00,100077.60,0.00,'2021-11-27 07:10:58'),(1496602,'5','91',255,'Sale Id shift 242149',0.00,594536.25,165.00,594536.25,0.00,'2021-11-28 15:52:22'),(1497419,'5','91',255,'Sale Id shift 242362',0.00,2710794.90,165.00,2710794.90,0.00,'2021-11-29 05:59:35'),(1502259,'5','91',255,'Sale Id shift 242493',0.00,3219623.55,165.00,3219623.55,0.00,'2021-11-30 06:03:23'),(1507793,'5','91',255,'Sale Id shift 242833',0.00,1484577.60,165.00,1484577.60,0.00,'2021-12-01 07:54:06'),(1512292,'5','91',255,'Sale Id shift 242990',0.00,741996.75,165.00,741996.75,0.00,'2021-12-02 07:21:47'),(1517321,'5','91',255,'Sale Id shift 243232',0.00,740087.70,165.00,740087.70,0.00,'2021-12-03 06:58:20'),(1522122,'5','91',255,'Sale Id shift 243457',0.00,434072.10,165.00,434072.10,0.00,'2021-12-04 06:56:49'),(1568417,'5','91',255,'Sale Id shift 245525',0.00,1052770.95,165.00,1052770.95,0.00,'2021-12-13 06:02:04'),(1573777,'5','91',255,'Sale Id shift 245764',0.00,1711917.90,165.00,1711917.90,0.00,'2021-12-14 06:08:37'),(1578639,'5','91',255,'Sale Id shift 246047',0.00,966688.80,165.00,966688.80,0.00,'2021-12-15 06:40:37'),(1583526,'5','91',255,'Sale Id shift 246304',0.00,879068.85,165.00,879068.85,0.00,'2021-12-16 06:52:23'),(1588686,'5','91',255,'Sale Id shift 246564',0.00,1357936.80,165.00,1357936.80,0.00,'2021-12-17 06:12:36'),(1593953,'5','91',255,'Sale Id shift 246795',0.00,919685.25,165.00,919685.25,0.00,'2021-12-18 07:04:14'),(1593954,'5','91',256,'Sale Id shift 246795',0.00,423936.00,345.00,423936.00,0.00,'2021-12-18 07:04:14'),(1599894,'5','91',255,'Sale Id shift 247103',0.00,1412518.80,165.00,1412518.80,0.00,'2021-12-19 07:13:51'),(1599895,'5','91',256,'Sale Id shift 247103',0.00,56586.90,345.00,56586.90,0.00,'2021-12-19 07:13:51'),(1604957,'5','91',255,'Sale Id shift 247233',0.00,1519806.75,165.00,1519806.75,0.00,'2021-12-20 06:57:13'),(1604958,'5','91',256,'Sale Id shift 247233',0.00,57808.20,345.00,57808.20,0.00,'2021-12-20 06:57:13'),(1611245,'5','91',256,'Sale Id shift 247436',0.00,241569.00,345.00,241569.00,0.00,'2021-12-21 09:20:09'),(1615425,'5','91',255,'Sale Id shift 247868',0.00,665737.05,165.00,665737.05,0.00,'2021-12-22 06:35:13'),(1615426,'5','91',256,'Sale Id shift 247868',0.00,98849.40,345.00,98849.40,0.00,'2021-12-22 06:35:13'),(1621063,'5','91',255,'Sale Id shift 248104',0.00,1117586.25,165.00,1117586.25,0.00,'2021-12-23 06:33:41'),(1621064,'5','91',256,'Sale Id shift 248104',0.00,152810.85,345.00,152810.85,0.00,'2021-12-23 06:33:41'),(1627122,'5','91',255,'Sale Id shift 248235',0.00,2012320.20,165.00,2012320.20,0.00,'2021-12-24 07:21:40'),(1627123,'5','91',256,'Sale Id shift 248235',0.00,220423.95,345.00,220423.95,0.00,'2021-12-24 07:21:40'),(1636748,'5','91',255,'Sale Id shift 248455',0.00,1070379.75,165.00,1070379.75,0.00,'2021-12-25 14:10:07'),(1636749,'5','91',256,'Sale Id shift 248455',0.00,157530.45,345.00,157530.45,0.00,'2021-12-25 14:10:07'),(1638188,'5','91',255,'Sale Id shift 248805',0.00,1195689.00,165.00,1195689.00,0.00,'2021-12-26 07:33:11'),(1638189,'5','91',256,'Sale Id shift 248805',0.00,74488.95,345.00,74488.95,0.00,'2021-12-26 07:33:11'),(1642255,'5','91',255,'Sale Id shift 248911',0.00,1196360.55,165.00,1196360.55,0.00,'2021-12-27 07:42:45'),(1642256,'5','91',256,'Sale Id shift 248911',0.00,55093.05,345.00,55093.05,0.00,'2021-12-27 07:42:45'),(1646745,'5','91',255,'Sale Id shift 249173',0.00,169331.25,165.00,169331.25,0.00,'2021-12-28 07:37:33'),(1646746,'5','91',256,'Sale Id shift 249173',0.00,145862.55,345.00,145862.55,0.00,'2021-12-28 07:37:33'),(1651407,'5','91',256,'Sale Id shift 249439',0.00,110406.90,345.00,110406.90,0.00,'2021-12-29 06:47:12'),(1656126,'5','91',256,'Sale Id shift 249682',0.00,88251.00,345.00,88251.00,0.00,'2021-12-30 06:59:14'),(1661419,'5','91',256,'Sale Id shift 249935',0.00,364420.05,345.00,364420.05,0.00,'2021-12-31 06:48:18'),(1667042,'5','91',256,'Sale Id shift 250156',0.00,155260.35,345.00,155260.35,0.00,'2022-01-01 07:50:40'),(1671552,'5','91',256,'Sale Id shift 250380',0.00,207179.40,345.00,207179.40,0.00,'2022-01-02 06:48:14'),(1679241,'5','91',256,'Sale Id shift 250634',0.00,191499.15,345.00,191499.15,0.00,'2022-01-03 14:06:52'),(1681281,'5','91',256,'Sale Id shift 250977',0.00,276693.45,345.00,276693.45,0.00,'2022-01-04 07:06:16'),(1686859,'5','91',255,'Sale Id shift 251117',0.00,3231770.85,165.00,3231770.85,0.00,'2022-01-05 07:36:32'),(1686860,'5','91',256,'Sale Id shift 251117',0.00,256935.30,345.00,256935.30,0.00,'2022-01-05 07:36:32'),(1692055,'5','91',255,'Sale Id shift 251434',0.00,1546533.45,165.00,1546533.45,0.00,'2022-01-06 07:50:34'),(1692056,'5','91',256,'Sale Id shift 251434',0.00,63804.30,345.00,63804.30,0.00,'2022-01-06 07:50:34'),(1697977,'5','91',255,'Sale Id shift 251612',0.00,2292757.50,165.00,2292757.50,0.00,'2022-01-07 09:10:44'),(1697978,'5','91',256,'Sale Id shift 251612',0.00,111728.25,345.00,111728.25,0.00,'2022-01-07 09:10:44'),(1702503,'5','91',255,'Sale Id shift 251936',0.00,1316218.20,165.00,1316218.20,0.00,'2022-01-08 07:59:40'),(1702504,'5','91',256,'Sale Id shift 251936',0.00,54999.90,345.00,54999.90,0.00,'2022-01-08 07:59:40'),(1708351,'5','91',255,'Sale Id shift 252097',0.00,1901941.80,165.00,1901941.80,0.00,'2022-01-09 08:03:46'),(1708352,'5','91',256,'Sale Id shift 252097',0.00,48303.45,345.00,48303.45,0.00,'2022-01-09 08:03:46'),(1713462,'5','91',255,'Sale Id shift 252323',0.00,1302059.55,165.00,1302059.55,0.00,'2022-01-10 07:03:26'),(1713463,'5','91',256,'Sale Id shift 252323',0.00,54748.05,345.00,54748.05,0.00,'2022-01-10 07:03:26'),(1718790,'5','91',255,'Sale Id shift 252571',0.00,1243763.40,165.00,1243763.40,0.00,'2022-01-11 05:36:00'),(1718791,'5','91',256,'Sale Id shift 252571',0.00,30863.70,345.00,30863.70,0.00,'2022-01-11 05:36:00'),(1723991,'5','91',255,'Sale Id shift 252809',0.00,159142.50,165.00,159142.50,0.00,'2022-01-12 07:50:49'),(1723992,'5','91',256,'Sale Id shift 252809',0.00,69003.45,345.00,69003.45,0.00,'2022-01-12 07:50:49'),(1729164,'5','91',256,'Sale Id shift 253068',0.00,97662.60,345.00,97662.60,0.00,'2022-01-13 07:36:16'),(1735200,'5','91',256,'Sale Id shift 253332',0.00,88247.55,345.00,88247.55,0.00,'2022-01-14 09:42:21'),(1740493,'5','91',256,'Sale Id shift 253762',0.00,102140.70,345.00,102140.70,0.00,'2022-01-15 10:31:58'),(1744991,'5','91',256,'Sale Id shift 253834',0.00,91235.25,345.00,91235.25,0.00,'2022-01-16 07:23:20'),(1749701,'5','91',256,'Sale Id shift 254021',0.00,99629.10,345.00,99629.10,0.00,'2022-01-17 07:15:01'),(1755924,'5','91',256,'Sale Id shift 254307',0.00,62113.80,345.00,62113.80,0.00,'2022-01-18 08:40:50'),(1762727,'5','91',256,'Sale Id shift 254551',0.00,49831.80,345.00,49831.80,0.00,'2022-01-19 10:07:11'),(1774305,'5','91',255,'Sale Id shift 255051',0.00,1288716.00,165.00,1288716.00,0.00,'2022-01-21 08:37:19'),(1779965,'5','91',255,'Sale Id shift 255246',0.00,960986.40,165.00,960986.40,0.00,'2022-01-22 08:08:41'),(1785772,'5','91',255,'Sale Id shift 255547',0.00,948289.65,165.00,948289.65,0.00,'2022-01-23 07:24:36'),(1791507,'5','91',255,'Sale Id shift 255817',0.00,1092036.00,165.00,1092036.00,0.00,'2022-01-24 08:34:22'),(1796681,'5','91',255,'Sale Id shift 256038',0.00,808046.25,165.00,808046.25,0.00,'2022-01-25 07:34:33'),(1802858,'5','91',255,'Sale Id shift 256310',0.00,682154.55,165.00,682154.55,0.00,'2022-01-26 08:09:48'),(1807527,'5','91',255,'Sale Id shift 256678',0.00,527089.20,165.00,527089.20,0.00,'2022-01-27 07:58:20'),(1813616,'5','91',255,'Sale Id shift 256820',0.00,550395.45,165.00,550395.45,0.00,'2022-01-28 07:23:58'),(1819772,'5','91',255,'Sale Id shift 257149',0.00,338081.70,165.00,338081.70,0.00,'2022-01-29 07:52:13'),(1825977,'5','91',255,'Sale Id shift 257438',0.00,198000.00,165.00,198000.00,0.00,'2022-01-30 07:46:00'),(1825978,'5','91',255,'Sale Id shift 257442',0.00,132820.05,165.00,132820.05,0.00,'2022-02-03 09:47:02'),(1825979,'5','91',255,'Sale Id shift 257443',0.00,995501.10,165.00,995501.10,0.00,'2022-02-04 06:27:06'),(1825980,'5','91',255,'Sale Id shift 257444',0.00,950934.60,165.00,950934.60,0.00,'2022-02-05 07:50:43'),(1825981,'5','91',255,'Sale Id shift 257445',0.00,876107.10,165.00,876107.10,0.00,'2022-02-06 07:46:46'),(1825982,'5','91',255,'Sale Id shift 257446',0.00,868545.15,165.00,868545.15,0.00,'2022-02-07 07:16:18'),(1825983,'5','91',255,'Sale Id shift 257447',0.00,1101403.05,165.00,1101403.05,0.00,'2022-02-08 07:42:22'),(1825984,'5','91',255,'Sale Id shift 257448',0.00,1160618.25,165.00,1160618.25,0.00,'2022-02-09 08:17:41'),(1825985,'5','91',255,'Sale Id shift 257449',0.00,2092996.95,165.00,2092996.95,0.00,'2022-02-10 07:59:51'),(1825986,'5','91',255,'Sale Id shift 257450',0.00,1601227.65,165.00,1601227.65,0.00,'2022-02-11 08:11:31'),(1825987,'5','91',255,'Sale Id shift 257451',0.00,1198140.90,165.00,1198140.90,0.00,'2022-02-12 08:12:35'),(1825988,'5','91',255,'Sale Id shift 257452',0.00,1371069.15,165.00,1371069.15,0.00,'2022-02-13 21:52:43'),(1825989,'5','91',255,'Sale Id shift 257453',0.00,1385673.30,165.00,1385673.30,0.00,'2022-02-14 07:20:21'),(1825990,'5','91',255,'Sale Id shift 257454',0.00,1575324.30,165.00,1575324.30,0.00,'2022-02-15 08:09:43'),(1825991,'5','91',255,'Sale Id shift 257455',0.00,3322473.00,165.00,3322473.00,0.00,'2022-02-16 07:32:16'),(1825992,'5','91',255,'Sale Id shift 257456',0.00,929949.90,165.00,929949.90,0.00,'2022-02-17 07:09:05'),(1825993,'5','91',255,'Sale Id shift 257457',0.00,165333.30,165.00,165333.30,0.00,'2022-02-17 23:36:03'),(1825994,'5','91',255,'Sale Id shift 257458',0.00,1112352.45,165.00,1112352.45,0.00,'2022-02-19 10:59:05'),(1825995,'5','91',255,'Sale Id shift 257459',0.00,1457806.35,165.00,1457806.35,0.00,'2022-02-20 07:21:18'),(1825996,'5','91',255,'Sale Id shift 257460',0.00,1172993.25,165.00,1172993.25,0.00,'2022-02-21 07:24:59'),(1825997,'5','91',255,'Sale Id shift 257461',0.00,1100810.70,165.00,1100810.70,0.00,'2022-02-22 06:42:50'),(1825998,'5','91',255,'Sale Id shift 257462',0.00,2638713.00,165.00,2638713.00,0.00,'2022-02-23 07:02:07'),(1825999,'5','91',255,'Sale Id shift 257463',0.00,999350.55,165.00,999350.55,0.00,'2022-02-24 09:37:49'),(1826000,'5','91',255,'Sale Id shift 257464',0.00,1103861.55,165.00,1103861.55,0.00,'2022-02-25 08:10:48'),(1826001,'5','91',255,'Sale Id shift 257465',0.00,1370889.30,165.00,1370889.30,0.00,'2022-02-26 07:19:44'),(1826002,'5','91',255,'Sale Id shift 257466',0.00,2624625.30,165.00,2624625.30,0.00,'2022-02-27 07:02:17'),(1826003,'5','91',255,'Sale Id shift 257467',0.00,3116440.80,165.00,3116440.80,0.00,'2022-02-28 19:59:35'),(1826004,'5','91',255,'Sale Id shift 257468',0.00,1547871.60,165.00,1547871.60,0.00,'2022-03-01 06:54:28'),(1826005,'5','91',255,'Sale Id shift 257469',0.00,322946.25,165.00,322946.25,0.00,'2022-03-02 08:19:06'),(1826006,'5','91',255,'Sale Id shift 257476',0.00,188596.65,165.00,188596.65,0.00,'2022-03-09 21:04:17'),(1826007,'5','91',255,'Sale Id shift 257477',0.00,852111.15,165.00,852111.15,0.00,'2022-03-10 06:39:19'),(1826008,'5','91',255,'Sale Id shift 257478',0.00,991390.95,165.00,991390.95,0.00,'2022-03-11 08:24:49'),(1826009,'5','91',255,'Sale Id shift 257479',0.00,1114815.90,165.00,1114815.90,0.00,'2022-03-12 07:56:21'),(1826010,'5','91',255,'Sale Id shift 257480',0.00,1264591.35,165.00,1264591.35,0.00,'2022-03-13 08:06:47'),(1826011,'5','91',255,'Sale Id shift 257481',0.00,1343962.95,165.00,1343962.95,0.00,'2022-03-14 07:06:25'),(1826012,'5','91',255,'Sale Id shift 257482',0.00,1293233.70,165.00,1293233.70,0.00,'2022-03-15 07:07:50'),(1826013,'5','91',255,'Sale Id shift 257483',0.00,1334632.20,165.00,1334632.20,0.00,'2022-03-16 08:09:51'),(1826014,'5','91',255,'Sale Id shift 257484',0.00,1539953.25,165.00,1539953.25,0.00,'2022-03-17 10:22:24'),(1826015,'5','91',255,'Sale Id shift 257485',0.00,855980.40,165.00,855980.40,0.00,'2022-03-18 07:47:19'),(1826016,'5','91',255,'Sale Id shift 257486',0.00,902180.40,165.00,902180.40,0.00,'2022-03-19 07:00:41'),(1826017,'5','91',255,'Sale Id shift 257487',0.00,665461.50,165.00,665461.50,0.00,'2022-03-20 07:31:00'),(1826018,'5','91',255,'Sale Id shift 257488',0.00,660732.60,165.00,660732.60,0.00,'2022-03-21 06:32:57'),(1826019,'5','91',255,'Sale Id shift 257489',0.00,637208.55,165.00,637208.55,0.00,'2022-03-22 07:06:25'),(1826020,'5','91',255,'Sale Id shift 257490',0.00,372365.40,165.00,372365.40,0.00,'2022-03-23 06:33:06'),(1826021,'5','91',255,'Sale Id shift 257518',0.00,103129.95,165.00,103129.95,0.00,'2022-04-20 10:10:25'),(1826022,'5','91',255,'Sale Id shift 257519',0.00,778966.65,165.00,778966.65,0.00,'2022-04-21 08:54:17'),(1826023,'5','91',255,'Sale Id shift 257520',0.00,888843.45,165.00,888843.45,0.00,'2022-04-22 09:25:56'),(1826024,'5','91',255,'Sale Id shift 257521',0.00,901563.30,165.00,901563.30,0.00,'2022-04-23 09:25:39'),(1826025,'5','91',255,'Sale Id shift 257522',0.00,898392.00,165.00,898392.00,0.00,'2022-04-23 22:07:50'),(1826026,'5','91',255,'Sale Id shift 257523',0.00,967056.75,165.00,967056.75,0.00,'2022-04-25 04:53:05'),(1826027,'5','91',255,'Sale Id shift 257524',0.00,666090.15,165.00,666090.15,0.00,'2022-04-26 07:34:43'),(1826028,'5','91',255,'Sale Id shift 257525',0.00,684241.80,165.00,684241.80,0.00,'2022-04-27 05:39:27'),(1826029,'5','91',255,'Sale Id shift 257526',0.00,902284.35,165.00,902284.35,0.00,'2022-04-28 07:33:08'),(1826030,'5','91',255,'Sale Id shift 257527',0.00,661283.70,165.00,661283.70,0.00,'2022-04-29 05:58:33'),(1826031,'5','91',255,'Sale Id shift 257528',0.00,626472.00,165.00,626472.00,0.00,'2022-05-09 10:22:52'),(1826032,'5','91',255,'Sale Id shift 257529',0.00,174139.35,165.00,174139.35,0.00,'2022-05-09 12:40:04'),(1826033,'5','91',255,'Sale Id shift 257532',0.00,148504.95,165.00,148504.95,0.00,'2022-05-09 15:39:36'),(1826034,'5','91',255,'Sale Id shift 257533',0.00,793461.90,165.00,793461.90,0.00,'2022-05-09 15:43:56'),(1826035,'5','91',255,'Sale Id shift 257534',0.00,707031.60,165.00,707031.60,0.00,'2022-05-09 15:48:20'),(1826036,'5','91',255,'Sale Id shift 257535',0.00,813831.15,165.00,813831.15,0.00,'2022-05-09 15:55:50'),(1826037,'5','91',255,'Sale Id shift 257536',0.00,775242.60,165.00,775242.60,0.00,'2022-05-09 16:17:00'),(1826038,'5','91',255,'Sale Id shift 257537',0.00,828476.55,165.00,828476.55,0.00,'2022-05-09 16:38:04'),(1826039,'5','91',255,'Sale Id shift 257538',0.00,879773.40,165.00,879773.40,0.00,'2022-05-10 08:57:12'),(1826040,'5','91',255,'Sale Id shift 257539',0.00,873968.70,165.00,873968.70,0.00,'2022-05-11 05:34:16'),(1826041,'5','91',255,'Sale Id shift 257540',0.00,798857.40,165.00,798857.40,0.00,'2022-05-12 08:27:09'),(1826042,'5','91',255,'Sale Id shift 257541',0.00,867969.30,165.00,867969.30,0.00,'2022-05-13 09:53:31'),(1826043,'5','91',255,'Sale Id shift 257542',0.00,911143.20,165.00,911143.20,0.00,'2022-05-14 14:28:06'),(1826044,'5','91',255,'Sale Id shift 257543',0.00,956326.80,165.00,956326.80,0.00,'2022-05-14 22:45:13'),(1826045,'5','91',255,'Sale Id shift 257544',0.00,834749.85,165.00,834749.85,0.00,'2022-05-15 22:50:49'),(1826046,'5','91',255,'Sale Id shift 257545',0.00,924041.25,165.00,924041.25,0.00,'2022-05-17 06:53:37'),(1826047,'5','91',255,'Sale Id shift 257546',0.00,884949.45,165.00,884949.45,0.00,'2022-05-18 07:11:59'),(1826048,'5','91',255,'Sale Id shift 257547',0.00,829752.00,165.00,829752.00,0.00,'2022-05-19 06:17:31'),(1826049,'5','91',255,'Sale Id shift 257548',0.00,847824.45,165.00,847824.45,0.00,'2022-05-19 22:35:25'),(1826050,'5','91',255,'Sale Id shift 257549',0.00,853599.45,165.00,853599.45,0.00,'2022-05-21 05:48:55'),(1826051,'5','91',255,'Sale Id shift 257550',0.00,862923.60,165.00,862923.60,0.00,'2022-05-21 22:38:39'),(1826052,'5','91',255,'Sale Id shift 257551',0.00,809816.70,165.00,809816.70,0.00,'2022-05-23 05:41:01'),(1826053,'5','91',255,'Sale Id shift 257552',0.00,302882.25,165.00,302882.25,0.00,'2022-05-24 06:46:39'),(1826054,'5','91',255,'Sale Id shift 257556',0.00,350707.50,165.00,350707.50,0.00,'2022-05-29 09:40:40'),(1826055,'5','91',255,'Sale Id shift 257557',0.00,799349.10,165.00,799349.10,0.00,'2022-05-30 06:24:01'),(1826056,'5','91',255,'Sale Id shift 257558',0.00,780563.85,165.00,780563.85,0.00,'2022-05-30 11:07:36'),(1826057,'5','91',255,'Sale Id shift 257559',0.00,769413.15,165.00,769413.15,0.00,'2022-05-31 05:40:35'),(1826058,'5','91',255,'Sale Id shift 257560',0.00,726504.90,165.00,726504.90,0.00,'2022-05-31 22:43:39'),(1826059,'5','91',255,'Sale Id shift 257561',0.00,729267.00,165.00,729267.00,0.00,'2022-06-02 05:38:42'),(1826060,'5','91',255,'Sale Id shift 257562',0.00,734365.50,165.00,734365.50,0.00,'2022-06-03 05:45:05'),(1826061,'5','91',255,'Sale Id shift 257563',0.00,679077.30,165.00,679077.30,0.00,'2022-06-03 22:54:15'),(1826062,'5','91',255,'Sale Id shift 257564',0.00,682012.65,165.00,682012.65,0.00,'2022-06-05 08:08:12'),(1826063,'5','91',255,'Sale Id shift 257565',0.00,759315.15,165.00,759315.15,0.00,'2022-06-06 09:45:09'),(1826064,'5','91',255,'Sale Id shift 257566',0.00,761616.90,165.00,761616.90,0.00,'2022-06-07 06:48:39'),(1826065,'5','91',255,'Sale Id shift 257567',0.00,487576.65,165.00,487576.65,0.00,'2022-06-08 09:03:26'),(1826066,'5','91',255,'Sale Id shift 257601',0.00,380178.70,185.00,380178.70,0.00,'2022-07-12 10:08:24'),(1826067,'5','91',255,'Sale Id shift 257602',0.00,746121.65,185.00,746121.65,0.00,'2022-07-13 06:49:49'),(1826068,'5','91',255,'Sale Id shift 257603',0.00,763313.70,185.00,763313.70,0.00,'2022-07-14 06:24:26'),(1826069,'5','91',255,'Sale Id shift 257604',0.00,859376.80,185.00,859376.80,0.00,'2022-07-15 06:38:14'),(1826070,'5','91',255,'Sale Id shift 257605',0.00,825508.85,185.00,825508.85,0.00,'2022-07-16 05:41:37'),(1826071,'5','91',255,'Sale Id shift 257606',0.00,1262963.55,185.00,1262963.55,0.00,'2022-07-17 06:03:19'),(1826072,'5','91',255,'Sale Id shift 257607',0.00,1043007.80,185.00,1043007.80,0.00,'2022-07-18 07:32:14'),(1826073,'5','91',255,'Sale Id shift 257608',0.00,1247588.20,185.00,1247588.20,0.00,'2022-07-19 05:47:33'),(1826074,'5','91',255,'Sale Id shift 257609',0.00,1002738.85,185.00,1002738.85,0.00,'2022-07-20 06:42:31'),(1826075,'5','91',255,'Sale Id shift 257610',0.00,1471621.35,185.00,1471621.35,0.00,'2022-07-21 07:43:07'),(1826076,'5','91',255,'Sale Id shift 257611',0.00,1187422.50,185.00,1187422.50,0.00,'2022-07-21 23:18:53'),(1826077,'5','91',255,'Sale Id shift 257612',0.00,1170191.60,185.00,1170191.60,0.00,'2022-07-23 07:28:24'),(1826078,'5','91',255,'Sale Id shift 257613',0.00,1157952.00,185.00,1157952.00,0.00,'2022-07-24 06:55:28'),(1826079,'5','91',255,'Sale Id shift 257614',0.00,1180475.75,185.00,1180475.75,0.00,'2022-07-25 06:40:29'),(1826080,'5','91',255,'Sale Id shift 257615',0.00,995152.00,185.00,995152.00,0.00,'2022-07-26 07:39:04'),(1826081,'5','91',255,'Sale Id shift 257616',0.00,941579.70,185.00,941579.70,0.00,'2022-07-27 06:53:36'),(1826082,'5','91',255,'Sale Id shift 257617',0.00,900833.45,185.00,900833.45,0.00,'2022-07-28 08:05:51'),(1826083,'5','91',255,'Sale Id shift 257618',0.00,464418.45,185.00,464418.45,0.00,'2022-07-29 06:55:34'),(1826084,'5','91',255,'Sale Id shift 257626',0.00,71003.00,185.00,71003.00,0.00,'2022-08-06 09:09:34'),(1826085,'5','91',255,'Sale Id shift 257628',0.00,455975.05,185.00,455975.05,0.00,'2022-09-03 08:14:26'),(1826086,'5','91',255,'Sale Id shift 257629',0.00,975954.55,185.00,975954.55,0.00,'2022-09-03 11:56:32'),(1826087,'5','91',255,'Sale Id shift 257630',0.00,928030.30,185.00,928030.30,0.00,'2022-09-03 12:12:40'),(1826088,'5','91',255,'Sale Id shift 257631',0.00,1196790.90,185.00,1196790.90,0.00,'2022-09-03 12:18:52'),(1826089,'5','91',255,'Sale Id shift 257632',0.00,1177229.00,185.00,1177229.00,0.00,'2022-09-03 19:06:06'),(1826090,'5','91',255,'Sale Id shift 257633',0.00,1175210.65,185.00,1175210.65,0.00,'2022-09-04 09:47:37'),(1826091,'5','91',255,'Sale Id shift 257634',0.00,1095853.05,185.00,1095853.05,0.00,'2022-09-04 15:21:20'),(1826092,'5','91',255,'Sale Id shift 257635',0.00,1213611.10,185.00,1213611.10,0.00,'2022-09-05 11:49:24'),(1826093,'5','91',255,'Sale Id shift 257636',0.00,1207347.00,185.00,1207347.00,0.00,'2022-09-05 11:54:31'),(1826094,'5','91',255,'Sale Id shift 257637',0.00,1267390.60,185.00,1267390.60,0.00,'2022-09-05 12:02:05'),(1826095,'5','91',255,'Sale Id shift 257638',0.00,1308347.75,185.00,1308347.75,0.00,'2022-09-05 12:15:15'),(1826096,'5','91',255,'Sale Id shift 257639',0.00,1379093.60,185.00,1379093.60,0.00,'2022-09-05 12:24:58'),(1826097,'5','91',255,'Sale Id shift 257640',0.00,1242497.00,185.00,1242497.00,0.00,'2022-09-05 12:30:08'),(1826098,'5','91',255,'Sale Id shift 257641',0.00,1269914.00,185.00,1269914.00,0.00,'2022-09-05 13:24:47'),(1826099,'5','91',255,'Sale Id shift 257642',0.00,982971.60,185.00,982971.60,0.00,'2022-09-05 13:37:06'),(1826100,'5','91',255,'Sale Id shift 257643',0.00,1607925.65,185.00,1607925.65,0.00,'2022-09-05 13:42:02'),(1826101,'5','91',255,'Sale Id shift 257644',0.00,1020326.80,185.00,1020326.80,0.00,'2022-09-05 13:46:26'),(1826102,'5','91',255,'Sale Id shift 257645',0.00,1054361.25,185.00,1054361.25,0.00,'2022-09-05 13:50:25'),(1826103,'5','91',255,'Sale Id shift 257646',0.00,1338541.60,185.00,1338541.60,0.00,'2022-09-05 13:53:56'),(1826104,'5','91',255,'Sale Id shift 257647',0.00,1033811.45,185.00,1033811.45,0.00,'2022-09-05 13:58:32'),(1826105,'5','91',255,'Sale Id shift 257648',0.00,1729838.80,185.00,1729838.80,0.00,'2022-09-05 14:31:44'),(1826106,'5','91',255,'Sale Id shift 257649',0.00,1259282.05,185.00,1259282.05,0.00,'2022-09-05 14:35:43'),(1826107,'5','91',255,'Sale Id shift 257650',0.00,1927774.00,185.00,1927774.00,0.00,'2022-09-05 14:40:50'),(1826108,'5','91',255,'Sale Id shift 257651',0.00,956191.00,185.00,956191.00,0.00,'2022-09-05 14:47:05'),(1826109,'5','91',255,'Sale Id shift 257652',0.00,1351191.90,185.00,1351191.90,0.00,'2022-09-05 14:50:51'),(1826110,'5','91',255,'Sale Id shift 257653',0.00,1290247.35,185.00,1290247.35,0.00,'2022-09-05 15:16:15'),(1826111,'5','91',255,'Sale Id shift 257654',0.00,1112253.30,185.00,1112253.30,0.00,'2022-09-05 15:19:39'),(1826112,'5','91',255,'Sale Id shift 257655',0.00,1892350.20,185.00,1892350.20,0.00,'2022-09-05 15:28:21'),(1826113,'5','91',255,'Sale Id shift 257656',0.00,1378209.30,185.00,1378209.30,0.00,'2022-09-05 15:31:54'),(1826114,'5','91',255,'Sale Id shift 257657',0.00,1705894.25,185.00,1705894.25,0.00,'2022-09-06 09:56:06'),(1826115,'5','91',255,'Sale Id shift 257658',0.00,1132325.80,185.00,1132325.80,0.00,'2022-09-07 09:40:16'),(1826116,'5','91',255,'Sale Id shift 257659',0.00,1149203.35,185.00,1149203.35,0.00,'2022-09-08 09:01:59'),(1826117,'5','91',255,'Sale Id shift 257660',0.00,1543464.25,185.00,1543464.25,0.00,'2022-09-09 07:14:06'),(1826118,'5','91',255,'Sale Id shift 257661',0.00,1035012.10,185.00,1035012.10,0.00,'2022-09-10 10:16:08'),(1826119,'5','91',255,'Sale Id shift 257662',0.00,1887516.15,185.00,1887516.15,0.00,'2022-09-11 11:03:17'),(1826120,'5','91',255,'Sale Id shift 257663',0.00,1349837.70,185.00,1349837.70,0.00,'2022-09-12 06:26:44'),(1826121,'5','91',255,'Sale Id shift 257664',0.00,1706264.25,185.00,1706264.25,0.00,'2022-09-13 06:58:33'),(1826122,'5','91',255,'Sale Id shift 257665',0.00,804955.35,185.00,804955.35,0.00,'2022-09-13 22:04:35'),(1826123,'5','91',255,'Sale Id shift 257666',0.00,1074278.35,185.00,1074278.35,0.00,'2022-09-14 21:54:06'),(1826124,'5','91',255,'Sale Id shift 257667',0.00,927081.25,185.00,927081.25,0.00,'2022-09-16 09:33:52'),(1826125,'5','91',255,'Sale Id shift 257668',0.00,964558.55,185.00,964558.55,0.00,'2022-09-17 07:54:36'),(1826126,'5','91',255,'Sale Id shift 257669',0.00,1080860.65,185.00,1080860.65,0.00,'2022-09-18 10:32:07'),(1826127,'5','91',255,'Sale Id shift 257670',0.00,1350677.60,185.00,1350677.60,0.00,'2022-09-19 10:42:17'),(1826128,'5','91',255,'Sale Id shift 257671',0.00,1064103.35,185.00,1064103.35,0.00,'2022-09-20 08:58:31'),(1826129,'5','91',255,'Sale Id shift 257672',0.00,1133711.45,185.00,1133711.45,0.00,'2022-09-21 07:06:32'),(1826130,'5','91',255,'Sale Id shift 257673',0.00,1112543.75,185.00,1112543.75,0.00,'2022-09-22 09:14:03'),(1826131,'5','91',255,'Sale Id shift 257674',0.00,749348.05,185.00,749348.05,0.00,'2022-09-23 10:17:41'),(1826132,'5','91',255,'Sale Id shift 257675',0.00,457913.85,185.00,457913.85,0.00,'2022-09-24 08:49:32'),(1826133,'5','91',255,'Sale Id shift 257679',0.00,417260.10,185.00,417260.10,0.00,'2022-09-28 10:14:16'),(1826134,'5','91',255,'Sale Id shift 257680',0.00,1341473.85,185.00,1341473.85,0.00,'2022-09-29 07:10:59'),(1826135,'5','91',255,'Sale Id shift 257681',0.00,1617952.65,185.00,1617952.65,0.00,'2022-09-30 07:21:17'),(1826136,'5','91',255,'Sale Id shift 257682',0.00,1331578.20,185.00,1331578.20,0.00,'2022-10-01 07:31:14'),(1826137,'5','91',255,'Sale Id shift 257683',0.00,1992999.45,185.00,1992999.45,0.00,'2022-10-02 06:56:03'),(1826138,'5','91',255,'Sale Id shift 257684',0.00,1401042.00,185.00,1401042.00,0.00,'2022-10-03 09:44:18'),(1826139,'5','91',255,'Sale Id shift 257685',0.00,1854147.70,185.00,1854147.70,0.00,'2022-10-04 07:11:02'),(1826140,'5','91',255,'Sale Id shift 257686',0.00,1318165.70,185.00,1318165.70,0.00,'2022-10-05 10:03:01'),(1826141,'5','91',255,'Sale Id shift 257687',0.00,1401511.90,185.00,1401511.90,0.00,'2022-10-06 06:56:07'),(1826142,'5','91',255,'Sale Id shift 257688',0.00,2068440.60,185.00,2068440.60,0.00,'2022-10-07 06:55:43'),(1826143,'5','91',255,'Sale Id shift 257689',0.00,1135857.45,185.00,1135857.45,0.00,'2022-10-08 11:33:37'),(1826144,'5','91',255,'Sale Id shift 257690',0.00,2140818.15,185.00,2140818.15,0.00,'2022-10-09 18:17:20'),(1826145,'5','91',255,'Sale Id shift 257691',0.00,1769674.85,185.00,1769674.85,0.00,'2022-10-10 08:56:22'),(1826146,'5','91',255,'Sale Id shift 257692',0.00,1614284.10,185.00,1614284.10,0.00,'2022-10-11 12:12:58'),(1826147,'5','91',255,'Sale Id shift 257693',0.00,1519197.80,185.00,1519197.80,0.00,'2022-10-12 12:28:52'),(1826148,'5','91',255,'Sale Id shift 257694',0.00,1571216.10,185.00,1571216.10,0.00,'2022-10-13 04:21:13'),(1826149,'5','91',255,'Sale Id shift 257695',0.00,908168.70,185.00,908168.70,0.00,'2022-10-14 10:18:44'),(1826150,'5','91',255,'Sale Id shift 257696',0.00,391802.25,185.00,391802.25,0.00,'2022-10-15 14:08:00'),(1826151,'5','91',255,'Sale Id shift 257721',0.00,563330.55,185.00,563330.55,0.00,'2022-11-10 10:41:04'),(1826152,'5','91',255,'Sale Id shift 257722',0.00,1702197.95,185.00,1702197.95,0.00,'2022-11-10 19:02:29'),(1826153,'5','91',255,'Sale Id shift 257723',0.00,1712748.50,185.00,1712748.50,0.00,'2022-11-11 11:25:47'),(1826154,'5','91',255,'Sale Id shift 257724',0.00,1773441.45,185.00,1773441.45,0.00,'2022-11-12 10:00:05'),(1826155,'5','91',255,'Sale Id shift 257725',0.00,1508497.40,185.00,1508497.40,0.00,'2022-11-12 23:49:01'),(1826156,'5','91',255,'Sale Id shift 257726',0.00,1309122.90,185.00,1309122.90,0.00,'2022-11-14 07:21:03'),(1826157,'5','91',255,'Sale Id shift 257727',0.00,1066621.20,185.00,1066621.20,0.00,'2022-11-14 23:38:37'),(1826158,'5','91',255,'Sale Id shift 257728',0.00,1030189.15,185.00,1030189.15,0.00,'2022-11-16 07:50:49'),(1826159,'5','91',255,'Sale Id shift 257729',0.00,451141.00,185.00,451141.00,0.00,'2022-11-17 09:33:36'),(1826160,'5','91',255,'Sale Id shift 257732',0.00,569801.85,185.00,569801.85,0.00,'2022-11-20 14:50:07'),(1826161,'5','91',255,'Sale Id shift 257733',0.00,1558954.30,185.00,1558954.30,0.00,'2022-11-21 09:34:31'),(1826162,'5','91',255,'Sale Id shift 257734',0.00,1669345.65,185.00,1669345.65,0.00,'2022-11-22 09:01:25'),(1826163,'5','91',255,'Sale Id shift 257735',0.00,1892605.50,185.00,1892605.50,0.00,'2022-11-23 09:37:08'),(1826164,'5','91',255,'Sale Id shift 257736',0.00,1301565.65,185.00,1301565.65,0.00,'2022-11-24 08:55:10'),(1826165,'5','91',255,'Sale Id shift 257737',0.00,1307150.80,185.00,1307150.80,0.00,'2022-11-25 11:11:46'),(1826166,'5','91',255,'Sale Id shift 257738',0.00,1215736.75,185.00,1215736.75,0.00,'2022-11-26 07:42:38'),(1826167,'5','91',255,'Sale Id shift 257739',0.00,1049451.35,185.00,1049451.35,0.00,'2022-11-27 08:57:29'),(1826168,'5','91',255,'Sale Id shift 257740',0.00,460995.95,185.00,460995.95,0.00,'2022-11-28 09:45:31'),(1826169,'5','91',255,'Sale Id shift 257793',0.00,449618.45,185.00,449618.45,0.00,'2023-01-20 13:09:35'),(1826170,'5','91',255,'Sale Id shift 257794',0.00,1374920.00,185.00,1374920.00,0.00,'2023-01-20 23:50:10'),(1826171,'5','91',255,'Sale Id shift 257796',0.00,1006731.00,220.00,1006731.00,0.00,'2023-01-21 06:55:51'),(1826172,'5','91',255,'Sale Id shift 257797',0.00,2220578.80,220.00,2220578.80,0.00,'2023-01-22 10:41:01'),(1826173,'5','91',255,'Sale Id shift 257798',0.00,2796052.60,220.00,2796052.60,0.00,'2023-01-23 09:06:34'),(1826174,'5','91',255,'Sale Id shift 257799',0.00,2144219.00,220.00,2144219.00,0.00,'2023-01-24 07:20:42'),(1826175,'5','91',255,'Sale Id shift 257800',0.00,615538.00,220.00,615538.00,0.00,'2023-01-25 09:20:48'),(1826176,'5','91',255,'Sale Id shift 257835',0.00,901674.90,210.00,901674.90,0.00,'2023-03-02 10:07:28'),(1826177,'5','91',255,'Sale Id shift 257836',0.00,2197085.10,210.00,2197085.10,0.00,'2023-03-02 15:15:49'),(1826178,'5','91',255,'Sale Id shift 257837',0.00,2563293.60,210.00,2563293.60,0.00,'2023-03-03 09:19:11'),(1826179,'5','91',255,'Sale Id shift 257838',0.00,2101125.60,210.00,2101125.60,0.00,'2023-03-04 08:45:13'),(1826180,'5','91',255,'Sale Id shift 257839',0.00,2751004.20,210.00,2751004.20,0.00,'2023-03-05 09:42:54'),(1826181,'5','91',255,'Sale Id shift 257840',0.00,2311514.10,210.00,2311514.10,0.00,'2023-03-06 10:33:43'),(1826182,'5','91',255,'Sale Id shift 257841',0.00,2640918.00,210.00,2640918.00,0.00,'2023-03-07 09:25:04'),(1826183,'5','91',255,'Sale Id shift 257842',0.00,1962011.10,210.00,1962011.10,0.00,'2023-03-08 09:49:46'),(1826184,'5','91',255,'Sale Id shift 257843',0.00,1665165.60,210.00,1665165.60,0.00,'2023-03-09 09:48:32'),(1826185,'5','91',255,'Sale Id shift 257844',0.00,1236358.20,210.00,1236358.20,0.00,'2023-03-10 09:17:15'),(1826186,'5','91',255,'Sale Id shift 257845',0.00,625048.20,210.00,625048.20,0.00,'2023-03-11 09:36:08');
/*!40000 ALTER TABLE `inventory_costs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `expirydate` date NOT NULL,
  `notes` text,
  `status` int NOT NULL DEFAULT '0',
  `email` varchar(200) DEFAULT NULL,
  `email_sent_at` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_method` varchar(50) DEFAULT NULL,
  `payment_details` text,
  `payment_status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `status` (`status`,`company_id`,`station_id`),
  KEY `email_sent_at` (`email_sent_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices`
--

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoices_items`
--

DROP TABLE IF EXISTS `invoices_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `item_type` varchar(50) NOT NULL,
  `item_id` varchar(100) NOT NULL,
  `item_details` longtext,
  PRIMARY KEY (`id`),
  KEY `name` (`name`,`invoice_id`,`station_id`),
  KEY `companycode` (`company_id`),
  KEY `status` (`status`,`item_type`,`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoices_items`
--

LOCK TABLES `invoices_items` WRITE;
/*!40000 ALTER TABLE `invoices_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ledgers`
--

DROP TABLE IF EXISTS `ledgers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ledgers` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `code` int NOT NULL AUTO_INCREMENT,
  `ledgertype` varchar(10) NOT NULL,
  `accounttype` varchar(50) NOT NULL,
  `accountid` varchar(50) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `details` varchar(1000) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `accounttype` (`accounttype`,`accountid`,`credit`,`debit`,`thedate`),
  KEY `cooperative` (`company_id`),
  KEY `depot_id` (`station_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=4953268 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ledgers`
--

LOCK TABLES `ledgers` WRITE;
/*!40000 ALTER TABLE `ledgers` DISABLE KEYS */;
INSERT INTO `ledgers` VALUES ('5','91',3570410,'','24','2317',0.00,3875814.00,'Purchase Id 78177 for 23,778.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 08:58:42','',''),('5','91',3570411,'','supplier','109',3875814.00,0.00,'Purchase Id 78177 for 23,778.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 08:58:42','',''),('5','91',3570438,'','24','2317',0.00,25200.00,'Purchase Id 78176 for 84.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 09:00:27','',''),('5','91',3570439,'','supplier','109',25200.00,0.00,'Purchase Id 78176 for 84.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-10-13 09:00:27','',''),('5','91',3577061,'','20','2331',684075.14,0.00,'Sales from shift 231309 on 2021-10-13 16:41:48 ','2021-10-13 16:41:48','',''),('5','91',3577062,'','6.1','2319',0.00,684075.14,'Sales from shift 231309 on 2021-10-13 16:41:48 ','2021-10-13 16:41:48','',''),('5','91',3577271,'','20','2331',1129673.13,0.00,'Sales from shift 231315 on 2021-10-13 16:54:16 ','2021-10-13 16:54:16','',''),('5','91',3577272,'','6.1','2319',0.00,1129673.13,'Sales from shift 231315 on 2021-10-13 16:54:16 ','2021-10-13 16:54:16','',''),('5','91',3580367,'','20','2331',679369.33,0.00,'Sales from shift 231421 on 2021-10-14 08:48:48 ','2021-10-14 08:48:48','',''),('5','91',3580368,'','6.1','2319',0.00,679369.33,'Sales from shift 231421 on 2021-10-14 08:48:48 ','2021-10-14 08:48:48','',''),('5','91',3582095,'','20','2331',664373.33,0.00,'Sales from shift 231471 on 2021-10-14 10:59:23 ','2021-10-14 10:59:23','',''),('5','91',3582096,'','6.1','2319',0.00,664373.33,'Sales from shift 231471 on 2021-10-14 10:59:23 ','2021-10-14 10:59:23','',''),('5','91',3582257,'','20','2331',361313.95,0.00,'Sales from shift 231476 on 2021-10-14 11:09:10 ','2021-10-14 11:09:10','',''),('5','91',3582258,'','6.1','2319',0.00,361313.95,'Sales from shift 231476 on 2021-10-14 11:09:10 ','2021-10-14 11:09:10','',''),('5','91',3582373,'','20','2331',246133.26,0.00,'Sales from shift 231478 on 2021-10-14 11:19:19 ','2021-10-14 11:19:19','',''),('5','91',3582374,'','6.1','2319',0.00,246133.26,'Sales from shift 231478 on 2021-10-14 11:19:19 ','2021-10-14 11:19:19','',''),('5','91',3582473,'','20','2331',0.00,0.00,'Sales from shift 231484 on 2021-10-14 11:26:26 ','2021-10-14 11:26:26','',''),('5','91',3582474,'','6.1','2319',0.00,0.00,'Sales from shift 231484 on 2021-10-14 11:26:26 ','2021-10-14 11:26:26','',''),('5','91',3582615,'','20','2331',0.00,0.00,'Sales from shift 231492 on 2021-10-14 11:37:29 ','2021-10-14 11:37:29','',''),('5','91',3582616,'','6.1','2319',0.00,0.00,'Sales from shift 231492 on 2021-10-14 11:37:29 ','2021-10-14 11:37:29','',''),('5','91',3582664,'','20','2331',0.00,0.00,'Sales from shift 231493 on 2021-10-14 11:40:53 ','2021-10-14 11:40:53','',''),('5','91',3582665,'','6.1','2319',0.00,0.00,'Sales from shift 231493 on 2021-10-14 11:40:53 ','2021-10-14 11:40:53','',''),('5','91',3582695,'','20','2331',0.00,0.00,'Sales from shift 231496 on 2021-10-14 11:43:44 ','2021-10-14 11:43:44','',''),('5','91',3582696,'','6.1','2319',0.00,0.00,'Sales from shift 231496 on 2021-10-14 11:43:44 ','2021-10-14 11:43:44','',''),('5','91',3582729,'','20','2331',0.00,0.00,'Sales from shift 231497 on 2021-10-14 11:46:19 ','2021-10-14 11:46:19','',''),('5','91',3582730,'','6.1','2319',0.00,0.00,'Sales from shift 231497 on 2021-10-14 11:46:19 ','2021-10-14 11:46:19','',''),('5','91',3582762,'','20','2331',0.00,0.00,'Sales from shift 231501 on 2021-10-14 11:48:53 ','2021-10-14 11:48:53','',''),('5','91',3582763,'','6.1','2319',0.00,0.00,'Sales from shift 231501 on 2021-10-14 11:48:53 ','2021-10-14 11:48:53','',''),('5','91',3582824,'','20','2331',0.00,0.00,'Sales from shift 231502 on 2021-10-14 11:53:08 ','2021-10-14 11:53:08','',''),('5','91',3582825,'','6.1','2319',0.00,0.00,'Sales from shift 231502 on 2021-10-14 11:53:08 ','2021-10-14 11:53:08','',''),('5','91',3583022,'','6.1','2319',6100.00,0.00,'Payment Id 343917 for invoice:231317, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583023,'','supplier','109',0.00,6100.00,'Payment Id 343917 for invoice:231317, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583024,'','2','3527',673270.00,0.00,'Payment Id 343914 for invoice:231317, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583025,'','supplier','109',0.00,673270.00,'Payment Id 343914 for invoice:231317, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583026,'','6.1','2319',5100.00,0.00,'Payment Id 343911 for invoice:231315, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583027,'','supplier','109',0.00,5100.00,'Payment Id 343911 for invoice:231315, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583028,'','2','3527',1124600.00,0.00,'Payment Id 343910 for invoice:231315, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583029,'','supplier','109',0.00,1124600.00,'Payment Id 343910 for invoice:231315, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583030,'','6.1','2319',5100.00,0.00,'Payment Id 343899 for invoice:231309, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583031,'','supplier','109',0.00,5100.00,'Payment Id 343899 for invoice:231309, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583032,'','2','3527',678950.00,0.00,'Payment Id 343898 for invoice:231309, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583033,'','supplier','109',0.00,678950.00,'Payment Id 343898 for invoice:231309, receipt: 16377 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:11:29','',''),('5','91',3583094,'','6.1','2319',6270.00,0.00,'Payment Id 344247 for invoice:231478, receipt: 20084 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583095,'','supplier','109',0.00,6270.00,'Payment Id 344247 for invoice:231478, receipt: 20084 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583098,'','2','3527',239860.00,0.00,'Payment Id 344246 for invoice:231478, receipt: 20084 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583099,'','supplier','109',0.00,239860.00,'Payment Id 344246 for invoice:231478, receipt: 20084 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583100,'','6.1','2319',6100.00,0.00,'Payment Id 344241 for invoice:231476, receipt: 84224 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583101,'','supplier','109',0.00,6100.00,'Payment Id 344241 for invoice:231476, receipt: 84224 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583102,'','2','3527',355150.00,0.00,'Payment Id 344240 for invoice:231476, receipt: 84224 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583103,'','supplier','109',0.00,355150.00,'Payment Id 344240 for invoice:231476, receipt: 84224 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583104,'','6.1','2319',16200.00,0.00,'Payment Id 344100 for invoice:231428, receipt: 33786 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583105,'','supplier','109',0.00,16200.00,'Payment Id 344100 for invoice:231428, receipt: 33786 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583106,'','2','3527',648175.00,0.00,'Payment Id 344098 for invoice:231428, receipt: 33786 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3583107,'','supplier','109',0.00,648175.00,'Payment Id 344098 for invoice:231428, receipt: 33786 by SALBAS OIL & GAS NIG. LIMITED','2021-10-14 12:16:26','',''),('5','91',3588278,'','20','2331',0.00,0.00,'Sales from shift 231503 on 2021-10-15 06:03:40 ','2021-10-15 06:03:40','',''),('5','91',3588279,'','6.1','2319',0.00,0.00,'Sales from shift 231503 on 2021-10-15 06:03:40 ','2021-10-15 06:03:40','',''),('5','91',3598547,'','20','2331',0.00,0.00,'Sales from shift 231648 on 2021-10-16 06:21:41 ','2021-10-16 06:21:41','',''),('5','91',3598548,'','6.1','2319',0.00,0.00,'Sales from shift 231648 on 2021-10-16 06:21:41 ','2021-10-16 06:21:41','',''),('5','91',3602567,'','24','2317',0.00,7261650.00,'Purchase Id 78430 for 44,550.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-16 11:44:51','',''),('5','91',3602568,'','supplier','109',7261650.00,0.00,'Purchase Id 78430 for 44,550.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-16 11:44:51','',''),('5','91',3608703,'','20','2331',1046632.78,0.00,'Sales from shift 231934 on 2021-10-17 06:51:48 ','2021-10-17 06:51:48','',''),('5','91',3608704,'','6.1','2319',0.00,1046632.78,'Sales from shift 231934 on 2021-10-17 06:51:48 ','2021-10-17 06:51:48','',''),('5','91',3618085,'','20','2331',695654.66,0.00,'Sales from shift 232197 on 2021-10-18 06:14:40 ','2021-10-18 06:14:40','',''),('5','91',3618086,'','6.1','2319',0.00,695654.66,'Sales from shift 232197 on 2021-10-18 06:14:40 ','2021-10-18 06:14:40','',''),('5','91',3627926,'','20','2331',1380147.08,0.00,'Sales from shift 232405 on 2021-10-19 05:54:54 ','2021-10-19 05:54:54','',''),('5','91',3627927,'','6.1','2319',0.00,1380147.08,'Sales from shift 232405 on 2021-10-19 05:54:54 ','2021-10-19 05:54:54','',''),('5','91',3634770,'','2','3527',689100.00,0.00,'Payment Id 346637 for invoice:232197, receipt: 66364 by SALBAS OIL & GAS NIG. LIMITED','2021-10-19 15:02:40','',''),('5','91',3634771,'','supplier','109',0.00,689100.00,'Payment Id 346637 for invoice:232197, receipt: 66364 by SALBAS OIL & GAS NIG. LIMITED','2021-10-19 15:02:40','',''),('5','91',3634772,'','2','3527',653700.00,0.00,'Payment Id 346627 for invoice:231934, receipt: 66364 by SALBAS OIL & GAS NIG. LIMITED','2021-10-19 15:02:40','',''),('5','91',3634773,'','supplier','109',0.00,653700.00,'Payment Id 346627 for invoice:231934, receipt: 66364 by SALBAS OIL & GAS NIG. LIMITED','2021-10-19 15:02:40','',''),('5','91',3634774,'','2','3527',67630.00,0.00,'Payment Id 346621 for invoice:231484, receipt: 78274 by SALBAS OIL & GAS NIG. LIMITED','2021-10-19 15:02:40','',''),('5','91',3634775,'','supplier','109',0.00,67630.00,'Payment Id 346621 for invoice:231484, receipt: 78274 by SALBAS OIL & GAS NIG. LIMITED','2021-10-19 15:02:40','',''),('5','91',3636999,'','20','2331',794413.10,0.00,'Sales from shift 232698 on 2021-10-20 05:52:23 ','2021-10-20 05:52:23','',''),('5','91',3637000,'','6.1','2319',0.00,794413.10,'Sales from shift 232698 on 2021-10-20 05:52:23 ','2021-10-20 05:52:23','',''),('5','91',3650436,'','2','3527',787755.00,0.00,'Payment Id 347773 for invoice:232698, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:20:46','',''),('5','91',3650437,'','supplier','109',0.00,787755.00,'Payment Id 347773 for invoice:232698, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:20:46','',''),('5','91',3650451,'','2','3527',0.00,787755.00,'Payment Id 347773 for invoice:232698, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:04','',''),('5','91',3650452,'','supplier','109',787755.00,0.00,'Payment Id 347773 for invoice:232698, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:04','',''),('5','91',3650456,'','6.1','2319',6559.00,0.00,'Payment Id 347774 for invoice:232698, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:20','',''),('5','91',3650457,'','supplier','109',0.00,6559.00,'Payment Id 347774 for invoice:232698, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:20','',''),('5','91',3650458,'','2','3527',787755.00,0.00,'Payment Id 347772 for invoice:232698, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:20','',''),('5','91',3650459,'','supplier','109',0.00,787755.00,'Payment Id 347772 for invoice:232698, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:20','',''),('5','91',3650460,'','6.1','2319',17259.00,0.00,'Payment Id 347771 for invoice:232405, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:20','',''),('5','91',3650461,'','supplier','109',0.00,17259.00,'Payment Id 347771 for invoice:232405, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:20','',''),('5','91',3650462,'','2','3527',1362890.00,0.00,'Payment Id 347769 for invoice:232405, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:20','',''),('5','91',3650463,'','supplier','109',0.00,1362890.00,'Payment Id 347769 for invoice:232405, receipt: 21533 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:21:20','',''),('5','91',3650798,'','6.1','2319',6659.00,0.00,'Payment Id 346639 for invoice:232197, receipt: 66364 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:44:44','',''),('5','91',3650799,'','supplier','109',0.00,6659.00,'Payment Id 346639 for invoice:232197, receipt: 66364 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:44:44','',''),('5','91',3650812,'','6.1','2319',318824.00,0.00,'Payment Id 346635 for invoice:231484, receipt: 66364 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:45:51','',''),('5','91',3650813,'','supplier','109',0.00,318824.00,'Payment Id 346635 for invoice:231484, receipt: 66364 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:45:51','',''),('5','91',3650818,'','6.1','2319',6370.00,0.00,'Payment Id 346624 for invoice:231484, receipt: 78274 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:46:27','',''),('5','91',3650819,'','supplier','109',0.00,6370.00,'Payment Id 346624 for invoice:231484, receipt: 78274 by SALBAS OIL & GAS NIG. LIMITED','2021-10-21 08:46:27','',''),('5','91',3657263,'','20','2331',902291.39,0.00,'Sales from shift 232859 on 2021-10-21 17:04:59 ','2021-10-21 17:04:59','',''),('5','91',3657264,'','6.1','2319',0.00,902291.39,'Sales from shift 232859 on 2021-10-21 17:04:59 ','2021-10-21 17:04:59','',''),('5','91',3657964,'','20','2331',681499.74,0.00,'Sales from shift 233309 on 2021-10-22 06:00:59 ','2021-10-22 06:00:59','',''),('5','91',3657965,'','6.1','2319',0.00,681499.74,'Sales from shift 233309 on 2021-10-22 06:00:59 ','2021-10-22 06:00:59','',''),('5','91',3660326,'','2','3527',895580.00,0.00,'Payment Id 348380 for invoice:232859, receipt: 11108 by SALBAS OIL & GAS NIG. LIMITED','2021-10-22 09:18:42','',''),('5','91',3660327,'','supplier','109',0.00,895580.00,'Payment Id 348380 for invoice:232859, receipt: 11108 by SALBAS OIL & GAS NIG. LIMITED','2021-10-22 09:18:42','',''),('5','91',3669115,'','20','2331',763524.60,0.00,'Sales from shift 233428 on 2021-10-23 06:19:22 ','2021-10-23 06:19:22','',''),('5','91',3669116,'','6.1','2319',0.00,763524.60,'Sales from shift 233428 on 2021-10-23 06:19:22 ','2021-10-23 06:19:22','',''),('5','91',3677363,'','24','2317',0.00,3749000.00,'Purchase Id 78942 for 23,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-23 15:49:21','',''),('5','91',3677364,'','supplier','109',3749000.00,0.00,'Purchase Id 78942 for 23,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-23 15:49:21','',''),('5','91',3683673,'','20','2331',1320956.89,0.00,'Sales from shift 233641 on 2021-10-24 13:05:49 ','2021-10-24 13:05:49','',''),('5','91',3683674,'','6.1','2319',0.00,1320956.89,'Sales from shift 233641 on 2021-10-24 13:05:49 ','2021-10-24 13:05:49','',''),('5','91',3686676,'','2','3527',674535.00,0.00,'Payment Id 348917 for invoice:23309, receipt: 64605 by SALBAS OIL & GAS NIG. LIMITED','2021-10-24 17:25:20','',''),('5','91',3686677,'','supplier','109',0.00,674535.00,'Payment Id 348917 for invoice:23309, receipt: 64605 by SALBAS OIL & GAS NIG. LIMITED','2021-10-24 17:25:20','',''),('5','91',3687425,'','20','2331',803875.25,0.00,'Sales from shift 234004 on 2021-10-25 06:06:50 ','2021-10-25 06:06:50','',''),('5','91',3687426,'','6.1','2319',0.00,803875.25,'Sales from shift 234004 on 2021-10-25 06:06:50 ','2021-10-25 06:06:50','',''),('5','91',3690956,'','6.1','2319',6865.00,0.00,'Payment Id 348918 for invoice:233309, receipt: 64605 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 11:03:17','',''),('5','91',3690957,'','supplier','109',0.00,6865.00,'Payment Id 348918 for invoice:233309, receipt: 64605 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 11:03:17','',''),('5','91',3695375,'','6.1','2319',6865.00,0.00,'Payment Id 350468 for invoice:234004, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:20','',''),('5','91',3695376,'','supplier','109',0.00,6865.00,'Payment Id 350468 for invoice:234004, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:20','',''),('5','91',3695377,'','2','3527',797005.00,0.00,'Payment Id 350467 for invoice:234004, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695378,'','supplier','109',0.00,797005.00,'Payment Id 350467 for invoice:234004, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695379,'','6.1','2319',5865.00,0.00,'Payment Id 350464 for invoice:233641, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695380,'','supplier','109',0.00,5865.00,'Payment Id 350464 for invoice:233641, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695381,'','2','3527',1315085.00,0.00,'Payment Id 350462 for invoice:233641, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695382,'','supplier','109',0.00,1315085.00,'Payment Id 350462 for invoice:233641, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695383,'','6.1','2319',5865.00,0.00,'Payment Id 350459 for invoice:233428, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695384,'','supplier','109',0.00,5865.00,'Payment Id 350459 for invoice:233428, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695385,'','2','3527',757675.00,0.00,'Payment Id 350457 for invoice:233428, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3695386,'','supplier','109',0.00,757675.00,'Payment Id 350457 for invoice:233428, receipt: 27031 by SALBAS OIL & GAS NIG. LIMITED','2021-10-25 15:48:21','',''),('5','91',3697459,'','20','2331',1020500.62,0.00,'Sales from shift 234074 on 2021-10-26 05:41:57 ','2021-10-26 05:41:57','',''),('5','91',3697460,'','6.1','2319',0.00,1020500.62,'Sales from shift 234074 on 2021-10-26 05:41:57 ','2021-10-26 05:41:57','',''),('5','91',3708747,'','24','2317',0.00,7425000.00,'Purchase Id 79158 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-26 19:29:07','',''),('5','91',3708748,'','supplier','109',7425000.00,0.00,'Purchase Id 79158 for 45,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-10-26 19:29:07','',''),('5','91',3711123,'','6.1','2319',18865.00,0.00,'Payment Id 351093 for invoice:234074, receipt: 74407 by SALBAS OIL & GAS NIG. LIMITED','2021-10-27 09:02:19','',''),('5','91',3711124,'','supplier','109',0.00,18865.00,'Payment Id 351093 for invoice:234074, receipt: 74407 by SALBAS OIL & GAS NIG. LIMITED','2021-10-27 09:02:19','',''),('5','91',3711125,'','2','3527',1001635.00,0.00,'Payment Id 351090 for invoice:234074, receipt: 74407 by SALBAS OIL & GAS NIG. LIMITED','2021-10-27 09:02:19','',''),('5','91',3711126,'','supplier','109',0.00,1001635.00,'Payment Id 351090 for invoice:234074, receipt: 74407 by SALBAS OIL & GAS NIG. LIMITED','2021-10-27 09:02:19','',''),('5','91',3713020,'','20','2331',777559.20,0.00,'Sales from shift 234648 on 2021-10-27 10:58:03 ','2021-10-27 10:58:03','',''),('5','91',3713021,'','6.1','2319',0.00,777559.20,'Sales from shift 234648 on 2021-10-27 10:58:03 ','2021-10-27 10:58:03','',''),('5','91',3720610,'','20','2331',922023.30,0.00,'Sales from shift 234732 on 2021-10-28 07:22:15 ','2021-10-28 07:22:15','',''),('5','91',3720611,'','6.1','2319',0.00,922023.30,'Sales from shift 234732 on 2021-10-28 07:22:15 ','2021-10-28 07:22:15','',''),('5','91',3724675,'','6.1','2319',6865.00,0.00,'Payment Id 351534 for invoice:234648, receipt: 58850 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 11:13:32','',''),('5','91',3724676,'','supplier','109',0.00,6865.00,'Payment Id 351534 for invoice:234648, receipt: 58850 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 11:13:32','',''),('5','91',3724677,'','2','3527',770559.00,0.00,'Payment Id 351530 for invoice:234648, receipt: 58850 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 11:13:32','',''),('5','91',3724678,'','supplier','109',0.00,770559.00,'Payment Id 351530 for invoice:234648, receipt: 58850 by SALBAS OIL & GAS NIG. LIMITED','2021-10-28 11:13:32','',''),('5','91',3729848,'','20','2331',821508.60,0.00,'Sales from shift 234901 on 2021-10-29 06:09:10 ','2021-10-29 06:09:10','',''),('5','91',3729849,'','6.1','2319',0.00,821508.60,'Sales from shift 234901 on 2021-10-29 06:09:10 ','2021-10-29 06:09:10','',''),('5','91',3733278,'','2','3527',905160.00,0.00,'Payment Id 352184 for invoice:234732, receipt: 62123 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 10:24:42','',''),('5','91',3733279,'','supplier','109',0.00,905160.00,'Payment Id 352184 for invoice:234732, receipt: 62123 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 10:24:42','',''),('5','91',3733280,'','6.1','2319',16865.00,0.00,'Payment Id 352183 for invoice:234732, receipt: 62123 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 10:24:42','',''),('5','91',3733281,'','supplier','109',0.00,16865.00,'Payment Id 352183 for invoice:234732, receipt: 62123 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 10:24:42','',''),('5','91',3733282,'','2','3527',902160.00,0.00,'Payment Id 352181 for invoice:234732, receipt: 62123 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 10:24:48','',''),('5','91',3733283,'','supplier','109',0.00,902160.00,'Payment Id 352181 for invoice:234732, receipt: 62123 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 10:24:48','',''),('5','91',3733284,'','2','3527',0.00,902160.00,'Payment Id 352181 for invoice:234732, receipt: 62123 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 10:25:01','',''),('5','91',3733285,'','supplier','109',902160.00,0.00,'Payment Id 352181 for invoice:234732, receipt: 62123 by SALBAS OIL & GAS NIG. LIMITED','2021-10-29 10:25:01','',''),('5','91',3739121,'','20','2331',960039.30,0.00,'Sales from shift 235129 on 2021-10-30 07:15:57 ','2021-10-30 07:15:57','',''),('5','91',3739122,'','6.1','2319',0.00,960039.30,'Sales from shift 235129 on 2021-10-30 07:15:57 ','2021-10-30 07:15:57','',''),('5','91',3748749,'','20','2331',1224557.40,0.00,'Sales from shift 235449 on 2021-10-31 06:14:09 ','2021-10-31 06:14:09','',''),('5','91',3748750,'','6.1','2319',0.00,1224557.40,'Sales from shift 235449 on 2021-10-31 06:14:09 ','2021-10-31 06:14:09','',''),('5','91',3758897,'','20','2331',1158222.45,0.00,'Sales from shift 235609 on 2021-11-01 07:26:16 ','2021-11-01 07:26:16','',''),('5','91',3758898,'','6.1','2319',0.00,1158222.45,'Sales from shift 235609 on 2021-11-01 07:26:16 ','2021-11-01 07:26:16','',''),('5','91',3766717,'','24','2328',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3766826,'','24','2316',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3766931,'','24','2322',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3766962,'','24','2323',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3767039,'','24','2320',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3767163,'','2','3527',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3767336,'','24','2324',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3767470,'','24','2325',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3767663,'','24','2326',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3767927,'','24','2318',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3768373,'','24','2330',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3768521,'','6.1','2319',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3769118,'','24','2327',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3769505,'','2','2332',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3769881,'','24','2321',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3769933,'','24','2329',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3770232,'','20','2331',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3770349,'','24','2317',0.00,0.00,'Balances from closing values 20211101','2020-12-31 23:59:59','',''),('5','91',3770511,'','20','2331',1307941.80,0.00,'Sales from shift 235896 on 2021-11-02 06:20:46 ','2021-11-02 06:20:46','',''),('5','91',3770512,'','6.1','2319',0.00,1307941.80,'Sales from shift 235896 on 2021-11-02 06:20:46 ','2021-11-02 06:20:46','',''),('5','91',3776492,'','6.1','2319',6865.00,0.00,'Payment Id 354183 for invoice:235609, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:10','',''),('5','91',3776493,'','supplier','109',0.00,6865.00,'Payment Id 354183 for invoice:235609, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:10','',''),('5','91',3776494,'','2','3527',1151275.00,0.00,'Payment Id 354181 for invoice:235609, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:10','',''),('5','91',3776495,'','supplier','109',0.00,1151275.00,'Payment Id 354181 for invoice:235609, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:10','',''),('5','91',3776496,'','6.1','2319',5865.00,0.00,'Payment Id 354180 for invoice:235449, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:10','',''),('5','91',3776497,'','supplier','109',0.00,5865.00,'Payment Id 354180 for invoice:235449, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:10','',''),('5','91',3776498,'','2','3527',1218695.00,0.00,'Payment Id 354179 for invoice:235449, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:10','',''),('5','91',3776499,'','supplier','109',0.00,1218695.00,'Payment Id 354179 for invoice:235449, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:10','',''),('5','91',3776500,'','6.1','2319',5865.00,0.00,'Payment Id 354177 for invoice:235129, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:11','',''),('5','91',3776501,'','supplier','109',0.00,5865.00,'Payment Id 354177 for invoice:235129, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:11','',''),('5','91',3776502,'','2','3527',954175.00,0.00,'Payment Id 354176 for invoice:235129, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:11','',''),('5','91',3776503,'','supplier','109',0.00,954175.00,'Payment Id 354176 for invoice:235129, receipt: 75768 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:11','',''),('5','91',3776504,'','6.1','2319',6865.00,0.00,'Payment Id 352691 for invoice:234901, receipt: 58080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:11','',''),('5','91',3776505,'','supplier','109',0.00,6865.00,'Payment Id 352691 for invoice:234901, receipt: 58080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:11','',''),('5','91',3776506,'','2','3527',814645.00,0.00,'Payment Id 352689 for invoice:234901, receipt: 58080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:11','',''),('5','91',3776507,'','supplier','109',0.00,814645.00,'Payment Id 352689 for invoice:234901, receipt: 58080 by SALBAS OIL & GAS NIG. LIMITED','2021-11-02 15:34:11','',''),('5','91',3778469,'','20','2331',786152.40,0.00,'Sales from shift 236096 on 2021-11-03 06:25:10 ','2021-11-03 06:25:10','',''),('5','91',3778470,'','6.1','2319',0.00,786152.40,'Sales from shift 236096 on 2021-11-03 06:25:10 ','2021-11-03 06:25:10','',''),('5','91',3790015,'','20','2331',553050.30,0.00,'Sales from shift 236458 on 2021-11-04 06:15:50 ','2021-11-04 06:15:50','',''),('5','91',3790016,'','6.1','2319',0.00,553050.30,'Sales from shift 236458 on 2021-11-04 06:15:50 ','2021-11-04 06:15:50','',''),('5','91',3805805,'','20','2331',559350.00,0.00,'Sales from shift 236693 on 2021-11-05 06:35:48 ','2021-11-05 06:35:48','',''),('5','91',3805806,'','6.1','2319',0.00,559350.00,'Sales from shift 236693 on 2021-11-05 06:35:48 ','2021-11-05 06:35:48','',''),('5','91',3813264,'','6.1','2319',6865.00,0.00,'Payment Id 355845 for invoice:236458, receipt: 21584 by SALBAS OIL & GAS NIG. LIMITED','2021-11-05 14:52:02','',''),('5','91',3813265,'','supplier','109',0.00,6865.00,'Payment Id 355845 for invoice:236458, receipt: 21584 by SALBAS OIL & GAS NIG. LIMITED','2021-11-05 14:52:02','',''),('5','91',3813266,'','2','3527',546185.00,0.00,'Payment Id 355844 for invoice:236458, receipt: 21584 by SALBAS OIL & GAS NIG. LIMITED','2021-11-05 14:52:02','',''),('5','91',3813267,'','supplier','109',0.00,546185.00,'Payment Id 355844 for invoice:236458, receipt: 21584 by SALBAS OIL & GAS NIG. LIMITED','2021-11-05 14:52:02','',''),('5','91',3813268,'','6.1','2319',6865.00,0.00,'Payment Id 355327 for invoice:236096, receipt: 36070 by SALBAS OIL & GAS NIG. LIMITED','2021-11-05 14:52:02','',''),('5','91',3813269,'','supplier','109',0.00,6865.00,'Payment Id 355327 for invoice:236096, receipt: 36070 by SALBAS OIL & GAS NIG. LIMITED','2021-11-05 14:52:02','',''),('5','91',3813270,'','2','3527',779290.00,0.00,'Payment Id 355326 for invoice:236096, receipt: 36070 by SALBAS OIL & GAS NIG. LIMITED','2021-11-05 14:52:02','',''),('5','91',3813271,'','supplier','109',0.00,779290.00,'Payment Id 355326 for invoice:236096, receipt: 36070 by SALBAS OIL & GAS NIG. LIMITED','2021-11-05 14:52:02','',''),('5','91',3817456,'','20','2331',70827.90,0.00,'Sales from shift 236814 on 2021-11-06 07:06:25 ','2021-11-06 07:06:25','',''),('5','91',3817457,'','6.1','2319',0.00,70827.90,'Sales from shift 236814 on 2021-11-06 07:06:25 ','2021-11-06 07:06:25','',''),('5','91',3828098,'','20','2331',0.00,0.00,'Sales from shift 237127 on 2021-11-07 06:29:20 ','2021-11-07 06:29:20','',''),('5','91',3828099,'','6.1','2319',0.00,0.00,'Sales from shift 237127 on 2021-11-07 06:29:20 ','2021-11-07 06:29:20','',''),('5','91',3838792,'','24','2317',0.00,4657500.00,'Purchase Id 80001 for 13,500.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-11-07 16:35:03','',''),('5','91',3838793,'','supplier','109',4657500.00,0.00,'Purchase Id 80001 for 13,500.00 litters of Diesel - AGO from SALBAS OIL & GAS NIG. LIMITED','2021-11-07 16:35:03','',''),('5','91',3840264,'','20','2331',46813.05,0.00,'Sales from shift 237253 on 2021-11-08 06:33:27 ','2021-11-08 06:33:27','',''),('5','91',3840265,'','6.1','2319',0.00,46813.05,'Sales from shift 237253 on 2021-11-08 06:33:27 ','2021-11-08 06:33:27','',''),('5','91',3850316,'','20','2331',56086.65,0.00,'Sales from shift 237494 on 2021-11-09 06:16:44 ','2021-11-09 06:16:44','',''),('5','91',3850317,'','6.1','2319',0.00,56086.65,'Sales from shift 237494 on 2021-11-09 06:16:44 ','2021-11-09 06:16:44','',''),('5','91',3863691,'','20','2331',122478.45,0.00,'Sales from shift 237689 on 2021-11-10 05:52:54 ','2021-11-10 05:52:54','',''),('5','91',3863692,'','6.1','2319',0.00,122478.45,'Sales from shift 237689 on 2021-11-10 05:52:54 ','2021-11-10 05:52:54','',''),('5','91',3866512,'','6.1','2319',261865.00,0.00,'Payment Id 356306 for invoice:236693, receipt: 82243 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:14:19','',''),('5','91',3866513,'','supplier','109',0.00,261865.00,'Payment Id 356306 for invoice:236693, receipt: 82243 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:14:19','',''),('5','91',3866514,'','2','3527',297485.00,0.00,'Payment Id 356304 for invoice:236693, receipt: 82243 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:14:19','',''),('5','91',3866515,'','supplier','109',0.00,297485.00,'Payment Id 356304 for invoice:236693, receipt: 82243 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:14:19','',''),('5','91',3866520,'','6.1','2319',17565.00,0.00,'Payment Id 357549 for invoice:236814, receipt: 40167 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:14:50','',''),('5','91',3866521,'','supplier','109',0.00,17565.00,'Payment Id 357549 for invoice:236814, receipt: 40167 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:14:50','',''),('5','91',3866522,'','2','3527',53400.00,0.00,'Payment Id 357548 for invoice:236814, receipt: 40167 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:14:50','',''),('5','91',3866523,'','supplier','109',0.00,53400.00,'Payment Id 357548 for invoice:236814, receipt: 40167 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:14:50','',''),('5','91',3866533,'','6.1','2319',6865.00,0.00,'Payment Id 357554 for invoice:237253, receipt: 40167 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:15:26','',''),('5','91',3866534,'','supplier','109',0.00,6865.00,'Payment Id 357554 for invoice:237253, receipt: 40167 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:15:26','',''),('5','91',3866535,'','2','3527',39950.00,0.00,'Payment Id 357552 for invoice:237253, receipt: 40167 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:15:26','',''),('5','91',3866536,'','supplier','109',0.00,39950.00,'Payment Id 357552 for invoice:237253, receipt: 40167 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:15:26','',''),('5','91',3866537,'','6.1','2319',6865.00,0.00,'Payment Id 358244 for invoice:237494, receipt: 44265 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:15:46','',''),('5','91',3866538,'','supplier','109',0.00,6865.00,'Payment Id 358244 for invoice:237494, receipt: 44265 by SALBAS OIL & GAS NIG. LIMITED','2021-11-10 09:15:46','',''),('5','91',3876176,'','20','2331',139794.00,0.00,'Sales from shift 238065 on 2021-11-11 05:48:48 ','2021-11-11 05:48:48','',''),('5','91',3876177,'','6.1','2319',0.00,139794.00,'Sales from shift 238065 on 2021-11-11 05:48:48 ','2021-11-11 05:48:48','',''),('5','91',3880776,'','6.1','2319',6865.00,0.00,'Payment Id 358764 for invoice:237689, receipt: 45460 by SALBAS OIL & GAS NIG. LIMITED','2021-11-11 10:26:12','',''),('5','91',3880777,'','supplier','109',0.00,6865.00,'Payment Id 358764 for invoice:237689, receipt: 45460 by SALBAS OIL & GAS NIG. LIMITED','2021-11-11 10:26:12','',''),('5','91',3880778,'','2','3527',115600.00,0.00,'Payment Id 358763 for invoice:237689, receipt: 45460 by SALBAS OIL & GAS NIG. LIMITED','2021-11-11 10:26:12','',''),('5','91',3880779,'','supplier','109',0.00,115600.00,'Payment Id 358763 for invoice:237689, receipt: 45460 by SALBAS OIL & GAS NIG. LIMITED','2021-11-11 10:26:12','',''),('5','91',3891858,'','20','2331',284024.70,0.00,'Sales from shift 238182 on 2021-11-12 07:29:18 ','2021-11-12 07:29:18','',''),('5','91',3891859,'','6.1','2319',0.00,284024.70,'Sales from shift 238182 on 2021-11-12 07:29:18 ','2021-11-12 07:29:18','',''),('5','91',3898324,'','6.1','2319',6865.00,0.00,'Payment Id 359275 for invoice:238065, receipt: 53856 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:25:38','',''),('5','91',3898325,'','supplier','109',0.00,6865.00,'Payment Id 359275 for invoice:238065, receipt: 53856 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:25:38','',''),('5','91',3898326,'','2','3527',132800.00,0.00,'Payment Id 359274 for invoice:238065, receipt: 53856 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:25:38','',''),('5','91',3898327,'','supplier','109',0.00,132800.00,'Payment Id 359274 for invoice:238065, receipt: 53856 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:25:38','',''),('5','91',3898363,'','2','3527',49225.00,0.00,'Payment Id 358242 for invoice:237494, receipt: 44265 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:26:11','',''),('5','91',3898364,'','supplier','109',0.00,49225.00,'Payment Id 358242 for invoice:237494, receipt: 44265 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:26:11','',''),('5','91',3898394,'','6.1','2319',62800.00,0.00,'Payment Id 355325 for invoice:236458, receipt: 23513 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:27:56','',''),('5','91',3898395,'','supplier','109',0.00,62800.00,'Payment Id 355325 for invoice:236458, receipt: 23513 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:27:56','',''),('5','91',3898396,'','2','3527',1245225.00,0.00,'Payment Id 355322 for invoice:236458, receipt: 23513 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:27:56','',''),('5','91',3898397,'','supplier','109',0.00,1245225.00,'Payment Id 355322 for invoice:236458, receipt: 23513 by SALBAS OIL & GAS NIG. LIMITED','2021-11-12 14:27:56','',''),('5','91',3903676,'','20','2331',89703.45,0.00,'Sales from shift 238573 on 2021-11-13 07:07:07 ','2021-11-13 07:07:07','',''),('5','91',3903677,'','6.1','2319',0.00,89703.45,'Sales from shift 238573 on 2021-11-13 07:07:07 ','2021-11-13 07:07:07','',''),('5','91',3915391,'','20','2331',244936.20,0.00,'Sales from shift 238701 on 2021-11-14 05:50:53 ','2021-11-14 05:50:53','',''),('5','91',3915392,'','6.1','2319',0.00,244936.20,'Sales from shift 238701 on 2021-11-14 05:50:53 ','2021-11-14 05:50:53','',''),('5','91',3927850,'','20','2331',297859.20,0.00,'Sales from shift 238884 on 2021-11-15 06:24:08 ','2021-11-15 06:24:08','',''),('5','91',3927851,'','6.1','2319',0.00,297859.20,'Sales from shift 238884 on 2021-11-15 06:24:08 ','2021-11-15 06:24:08','',''),('5','91',3939440,'','20','2331',490200.15,0.00,'Sales from shift 239244 on 2021-11-16 07:17:56 ','2021-11-16 07:17:56','',''),('5','91',3939441,'','6.1','2319',0.00,490200.15,'Sales from shift 239244 on 2021-11-16 07:17:56 ','2021-11-16 07:17:56','',''),('5','91',3946339,'','6.1','2319',6865.00,0.00,'Payment Id 360092 for invoice:238182, receipt: 200186 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:51:19','',''),('5','91',3946340,'','supplier','109',0.00,6865.00,'Payment Id 360092 for invoice:238182, receipt: 200186 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:51:19','',''),('5','91',3946341,'','2','3527',277160.00,0.00,'Payment Id 360090 for invoice:238182, receipt: 200186 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:51:19','',''),('5','91',3946342,'','supplier','109',0.00,277160.00,'Payment Id 360090 for invoice:238182, receipt: 200186 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:51:19','',''),('5','91',3946351,'','6.1','2319',5865.00,0.00,'Payment Id 361414 for invoice:238573, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:51:49','',''),('5','91',3946352,'','supplier','109',0.00,5865.00,'Payment Id 361414 for invoice:238573, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:51:49','',''),('5','91',3946353,'','2','3527',83840.00,0.00,'Payment Id 361412 for invoice:238573, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:51:49','',''),('5','91',3946354,'','supplier','109',0.00,83840.00,'Payment Id 361412 for invoice:238573, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:51:49','',''),('5','91',3946359,'','2','3527',239070.00,0.00,'Payment Id 361419 for invoice:238701, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:52:16','',''),('5','91',3946360,'','supplier','109',0.00,239070.00,'Payment Id 361419 for invoice:238701, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:52:16','',''),('5','91',3946361,'','2','3527',239070.00,0.00,'Payment Id 361417 for invoice:238701, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:52:16','',''),('5','91',3946362,'','supplier','109',0.00,239070.00,'Payment Id 361417 for invoice:238701, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:52:16','',''),('5','91',3946370,'','2','3527',0.00,239070.00,'Payment Id 361419 for invoice:238701, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:52:42','',''),('5','91',3946371,'','supplier','109',239070.00,0.00,'Payment Id 361419 for invoice:238701, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:52:42','',''),('5','91',3946380,'','6.1','2319',6865.00,0.00,'Payment Id 361426 for invoice:238884, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:53:22','',''),('5','91',3946381,'','supplier','109',0.00,6865.00,'Payment Id 361426 for invoice:238884, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:53:22','',''),('5','91',3946382,'','2','3527',290995.00,0.00,'Payment Id 361424 for invoice:238884, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:53:22','',''),('5','91',3946383,'','supplier','109',0.00,290995.00,'Payment Id 361424 for invoice:238884, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:53:22','',''),('5','91',3946384,'','6.1','2319',5865.00,0.00,'Payment Id 361421 for invoice:238701, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:53:22','',''),('5','91',3946385,'','supplier','109',0.00,5865.00,'Payment Id 361421 for invoice:238701, receipt: 00413 by SALBAS OIL & GAS NIG. LIMITED','2021-11-16 14:53:22','',''),('5','91',3950214,'','20','2331',437377.20,0.00,'Sales from shift 239479 on 2021-11-17 05:48:20 ','2021-11-17 05:48:20','',''),('5','91',3950215,'','6.1','2319',0.00,437377.20,'Sales from shift 239479 on 2021-11-17 05:48:20 ','2021-11-17 05:48:20','',''),('5','91',3961489,'','24','2317',0.00,7260000.00,'Purchase Id 80801 for 44,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-17 17:34:20','',''),('5','91',3961490,'','supplier','109',7260000.00,0.00,'Purchase Id 80801 for 44,000.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-17 17:34:20','',''),('5','91',3962377,'','20','2331',192030.45,0.00,'Sales from shift 239699 on 2021-11-18 06:08:29 ','2021-11-18 06:08:29','',''),('5','91',3962378,'','6.1','2319',0.00,192030.45,'Sales from shift 239699 on 2021-11-18 06:08:29 ','2021-11-18 06:08:29','',''),('5','91',3985710,'','20','2331',1661333.85,0.00,'Sales from shift 239943 on 2021-11-19 19:29:17 ','2021-11-19 19:29:17','',''),('5','91',3985711,'','6.1','2319',0.00,1661333.85,'Sales from shift 239943 on 2021-11-19 19:29:17 ','2021-11-19 19:29:17','',''),('5','91',3987063,'','20','2331',1195773.45,0.00,'Sales from shift 240158 on 2021-11-20 07:10:08 ','2021-11-20 07:10:08','',''),('5','91',3987064,'','6.1','2319',0.00,1195773.45,'Sales from shift 240158 on 2021-11-20 07:10:08 ','2021-11-20 07:10:08','',''),('5','91',3999852,'','20','2331',1882263.45,0.00,'Sales from shift 240387 on 2021-11-21 06:40:30 ','2021-11-21 06:40:30','',''),('5','91',3999853,'','6.1','2319',0.00,1882263.45,'Sales from shift 240387 on 2021-11-21 06:40:30 ','2021-11-21 06:40:30','',''),('5','91',4012395,'','20','2331',1499830.35,0.00,'Sales from shift 240595 on 2021-11-22 06:22:35 ','2021-11-22 06:22:35','',''),('5','91',4012396,'','6.1','2319',0.00,1499830.35,'Sales from shift 240595 on 2021-11-22 06:22:35 ','2021-11-22 06:22:35','',''),('5','91',4024944,'','20','2331',1889142.00,0.00,'Sales from shift 240778 on 2021-11-23 07:02:45 ','2021-11-23 07:02:45','',''),('5','91',4024945,'','6.1','2319',0.00,1889142.00,'Sales from shift 240778 on 2021-11-23 07:02:45 ','2021-11-23 07:02:45','',''),('5','91',4028907,'','6.1','2319',6865.00,0.00,'Payment Id 361937 for invoice:239244, receipt: 54671 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:28:17','',''),('5','91',4028908,'','supplier','109',0.00,6865.00,'Payment Id 361937 for invoice:239244, receipt: 54671 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:28:17','',''),('5','91',4028909,'','2','3527',483340.00,0.00,'Payment Id 361930 for invoice:239244, receipt: 54671 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:28:17','',''),('5','91',4028910,'','supplier','109',0.00,483340.00,'Payment Id 361930 for invoice:239244, receipt: 54671 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:28:17','',''),('5','91',4028921,'','6.1','2319',6865.00,0.00,'Payment Id 363059 for invoice:239479, receipt: 24344 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:28:49','',''),('5','91',4028922,'','supplier','109',0.00,6865.00,'Payment Id 363059 for invoice:239479, receipt: 24344 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:28:49','',''),('5','91',4028923,'','2','3527',430520.00,0.00,'Payment Id 363058 for invoice:239479, receipt: 24344 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:28:49','',''),('5','91',4028924,'','supplier','109',0.00,430520.00,'Payment Id 363058 for invoice:239479, receipt: 24344 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:28:49','',''),('5','91',4028925,'','6.1','2319',6865.00,0.00,'Payment Id 363061 for invoice:239699, receipt: 20131 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:29:16','',''),('5','91',4028926,'','supplier','109',0.00,6865.00,'Payment Id 363061 for invoice:239699, receipt: 20131 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:29:16','',''),('5','91',4028927,'','2','3527',185160.00,0.00,'Payment Id 363060 for invoice:239699, receipt: 20131 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:29:16','',''),('5','91',4028928,'','supplier','109',0.00,185160.00,'Payment Id 363060 for invoice:239699, receipt: 20131 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:29:16','',''),('5','91',4028958,'','2','3527',5865.00,0.00,'Payment Id 364504 for invoice:240158, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:31:53','',''),('5','91',4028959,'','supplier','109',0.00,5865.00,'Payment Id 364504 for invoice:240158, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:31:53','',''),('5','91',4028960,'','2','3527',1189990.00,0.00,'Payment Id 364503 for invoice:240158, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:31:53','',''),('5','91',4028961,'','supplier','109',0.00,1189990.00,'Payment Id 364503 for invoice:240158, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:31:53','',''),('5','91',4028976,'','6.1','2319',16865.00,0.00,'Payment Id 363258 for invoice:239943, receipt: 64683 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:33:13','',''),('5','91',4028977,'','supplier','109',0.00,16865.00,'Payment Id 363258 for invoice:239943, receipt: 64683 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:33:13','',''),('5','91',4028978,'','2','3527',1644340.00,0.00,'Payment Id 363256 for invoice:239943, receipt: 64683 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:33:13','',''),('5','91',4028979,'','supplier','109',0.00,1644340.00,'Payment Id 363256 for invoice:239943, receipt: 64683 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:33:13','',''),('5','91',4028988,'','6.1','2319',6865.00,0.00,'Payment Id 364511 for invoice:240595, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:34:04','',''),('5','91',4028989,'','supplier','109',0.00,6865.00,'Payment Id 364511 for invoice:240595, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:34:04','',''),('5','91',4028990,'','2','3527',1492960.00,0.00,'Payment Id 364510 for invoice:240595, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:34:04','',''),('5','91',4028991,'','supplier','109',0.00,1492960.00,'Payment Id 364510 for invoice:240595, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:34:04','',''),('5','91',4028992,'','6.1','2319',5865.00,0.00,'Payment Id 364508 for invoice:240387, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:34:04','',''),('5','91',4028993,'','supplier','109',0.00,5865.00,'Payment Id 364508 for invoice:240387, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:34:04','',''),('5','91',4028994,'','2','3527',1876320.00,0.00,'Payment Id 364507 for invoice:240387, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:34:04','',''),('5','91',4028995,'','supplier','109',0.00,1876320.00,'Payment Id 364507 for invoice:240387, receipt: 48056 by SALBAS OIL & GAS NIG. LIMITED','2021-11-23 10:34:04','',''),('5','91',4037977,'','20','2331',1058465.55,0.00,'Sales from shift 241191 on 2021-11-24 06:23:09 ','2021-11-24 06:23:09','',''),('5','91',4037978,'','6.1','2319',0.00,1058465.55,'Sales from shift 241191 on 2021-11-24 06:23:09 ','2021-11-24 06:23:09','',''),('5','91',4049925,'','20','2331',108385.20,0.00,'Sales from shift 241431 on 2021-11-25 06:27:33 ','2021-11-25 06:27:33','',''),('5','91',4049926,'','6.1','2319',0.00,108385.20,'Sales from shift 241431 on 2021-11-25 06:27:33 ','2021-11-25 06:27:33','',''),('5','91',4053881,'','6.1','2319',6865.00,0.00,'Payment Id 366472 for invoice:240778, receipt: 470075 by SALBAS OIL & GAS NIG. LIMITED','2021-11-25 10:21:18','',''),('5','91',4053882,'','supplier','109',0.00,6865.00,'Payment Id 366472 for invoice:240778, receipt: 470075 by SALBAS OIL & GAS NIG. LIMITED','2021-11-25 10:21:18','',''),('5','91',4053883,'','2','3527',1882345.00,0.00,'Payment Id 366471 for invoice:240778, receipt: 470075 by SALBAS OIL & GAS NIG. LIMITED','2021-11-25 10:21:18','',''),('5','91',4053884,'','supplier','109',0.00,1882345.00,'Payment Id 366471 for invoice:240778, receipt: 470075 by SALBAS OIL & GAS NIG. LIMITED','2021-11-25 10:21:18','',''),('5','91',4057825,'','6.1','2319',16865.00,0.00,'Payment Id 366477 for invoice:241191, receipt: 64834 by SALBAS OIL & GAS NIG. LIMITED','2021-11-25 13:55:14','',''),('5','91',4057826,'','supplier','109',0.00,16865.00,'Payment Id 366477 for invoice:241191, receipt: 64834 by SALBAS OIL & GAS NIG. LIMITED','2021-11-25 13:55:14','',''),('5','91',4057827,'','2','3527',1041260.00,0.00,'Payment Id 366475 for invoice:241191, receipt: 64834 by SALBAS OIL & GAS NIG. LIMITED','2021-11-25 13:55:14','',''),('5','91',4057828,'','supplier','109',0.00,1041260.00,'Payment Id 366475 for invoice:241191, receipt: 64834 by SALBAS OIL & GAS NIG. LIMITED','2021-11-25 13:55:14','',''),('5','91',4062974,'','20','2331',97321.05,0.00,'Sales from shift 241592 on 2021-11-26 06:11:49 ','2021-11-26 06:11:49','',''),('5','91',4062975,'','6.1','2319',0.00,97321.05,'Sales from shift 241592 on 2021-11-26 06:11:49 ','2021-11-26 06:11:49','',''),('5','91',4065801,'','6.1','2319',6865.00,0.00,'Payment Id 366685 for invoice:241431, receipt: 01414 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 09:09:47','',''),('5','91',4065802,'','supplier','109',0.00,6865.00,'Payment Id 366685 for invoice:241431, receipt: 01414 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 09:09:47','',''),('5','91',4065803,'','2','3527',101820.00,0.00,'Payment Id 366683 for invoice:241431, receipt: 01414 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 09:09:47','',''),('5','91',4065804,'','supplier','109',0.00,101820.00,'Payment Id 366683 for invoice:241431, receipt: 01414 by SALBAS OIL & GAS NIG. LIMITED','2021-11-26 09:09:47','',''),('5','91',4075589,'','20','2331',100077.60,0.00,'Sales from shift 241919 on 2021-11-27 07:10:58 ','2021-11-27 07:10:58','',''),('5','91',4075590,'','6.1','2319',0.00,100077.60,'Sales from shift 241919 on 2021-11-27 07:10:58 ','2021-11-27 07:10:58','',''),('5','91',4087521,'','6.1','2319',18865.00,0.00,'Payment Id 367352 for invoice:241592, receipt: 40313 by SALBAS OIL & GAS NIG. LIMITED','2021-11-27 18:39:56','',''),('5','91',4087522,'','supplier','109',0.00,18865.00,'Payment Id 367352 for invoice:241592, receipt: 40313 by SALBAS OIL & GAS NIG. LIMITED','2021-11-27 18:39:56','',''),('5','91',4087523,'','2','3527',78460.00,0.00,'Payment Id 367348 for invoice:241592, receipt: 40313 by SALBAS OIL & GAS NIG. LIMITED','2021-11-27 18:39:56','',''),('5','91',4087524,'','supplier','109',0.00,78460.00,'Payment Id 367348 for invoice:241592, receipt: 40313 by SALBAS OIL & GAS NIG. LIMITED','2021-11-27 18:39:56','',''),('5','91',4087744,'','24','2317',0.00,9891750.00,'Purchase Id 85904 for 59,950.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-27 20:46:29','',''),('5','91',4087745,'','supplier','109',9891750.00,0.00,'Purchase Id 85904 for 59,950.00 litters of Petrol - PMS from SALBAS OIL & GAS NIG. LIMITED','2021-11-27 20:46:29','',''),('5','91',4098484,'','20','2331',594536.25,0.00,'Sales from shift 242149 on 2021-11-28 15:52:22 ','2021-11-28 15:52:22','',''),('5','91',4098485,'','6.1','2319',0.00,594536.25,'Sales from shift 242149 on 2021-11-28 15:52:22 ','2021-11-28 15:52:22','',''),('5','91',4100680,'','20','2331',2710794.90,0.00,'Sales from shift 242362 on 2021-11-29 05:59:35 ','2021-11-29 05:59:35','',''),('5','91',4100681,'','6.1','2319',0.00,2710794.90,'Sales from shift 242362 on 2021-11-29 05:59:35 ','2021-11-29 05:59:35','',''),('5','91',4112857,'','20','2331',3219623.55,0.00,'Sales from shift 242493 on 2021-11-30 06:03:23 ','2021-11-30 06:03:23','',''),('5','91',4112858,'','6.1','2319',0.00,3219623.55,'Sales from shift 242493 on 2021-11-30 06:03:2