-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_90
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_90`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_90` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_90`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3533 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2299,30077,'',0,'24','5','90','PUBLIC RELATION','','2020-03-11 11:41:57',5,0.00,0.00,'','398','2020-03-11 11:41:57','398',0,1),(2300,30078,'',0,'24','5','90','PURCHASE','','2020-03-11 11:42:13',5,0.00,0.00,'','398','2020-03-11 11:42:13','398',0,1),(2301,30079,'',0,'24','5','90','SALARIES & WAGES','','2020-03-11 11:42:30',5,0.00,0.00,'','398','2020-03-11 11:42:30','398',0,1),(2302,3012,'',0,'6.1','5','90','CASH','','2020-03-11 11:43:20',5,0.00,0.00,'','398','2020-03-11 11:43:20','398',0,1),(2303,30080,'',0,'24','5','90','DIESEL INTERNAL CONSUMPTION','','2020-03-11 11:43:46',5,0.00,0.00,'','398','2020-03-11 11:43:46','398',0,1),(2304,30081,'',0,'24','5','90','CLEANING AND SANITARY','','2020-03-11 11:43:59',5,0.00,0.00,'','398','2020-03-11 11:43:59','398',0,1),(2305,30082,'',0,'24','5','90','TRANSPORT FARE','','2020-03-11 11:44:15',5,0.00,0.00,'','398','2020-03-11 11:44:15','398',0,1),(2306,30083,'',0,'24','5','90','OTHER OPERATING EXPESES','','2020-03-11 11:44:42',5,0.00,0.00,'','398','2020-03-11 11:44:42','398',0,1),(2307,30084,'',0,'24','5','90','PUMP REPAIR AND MAINTENANCE ','','2020-03-11 11:45:02',5,0.00,0.00,'','398','2020-03-11 11:45:02','398',0,1),(2308,30085,'',0,'24','5','90','GENERATOR REPAIR AND MAINTENAN','','2020-03-11 11:47:01',5,0.00,0.00,'','398','2020-03-11 11:47:01','398',0,1),(2309,30086,'',0,'24','5','90','WEIGHT AND MEASURE  ','','2020-03-11 11:47:25',5,0.00,0.00,'','398','2020-03-11 11:47:25','398',0,1),(2310,30087,'',0,'24','5','90','DPR EXPENSES','','2020-03-11 11:47:42',5,0.00,0.00,'','398','2020-03-11 11:47:42','398',0,1),(2311,30088,'',0,'24','5','90','TRAVELLING EXPENSES','','2020-03-11 11:48:14',5,0.00,0.00,'','398','2020-03-11 11:48:14','398',0,1),(2312,30089,'',0,'24','5','90','MEDICAL EXPENSES','','2020-03-11 11:48:33',5,0.00,0.00,'','398','2020-03-11 11:48:33','398',0,1),(2313,30090,'',0,'24','5','90','OFFICIAL CAR FUEL AND MAINTENA','','2020-03-11 11:48:54',5,0.00,0.00,'','398','2020-03-11 11:48:54','398',0,1),(2314,4010,'',0,'20','5','90','SALES','','2020-03-11 11:49:21',5,0.00,0.00,'','398','2020-03-11 11:49:21','398',0,1),(2315,4009,'',0,'2','5','90','UBA1019882661','','2020-03-11 11:49:38',5,0.00,0.00,'','398','2020-03-11 11:49:38','398',0,1),(3528,4047,'',0,'2','5','90','ZENITH BANK E-BILLS: 101665030','','2021-07-30 10:29:51',5,0.00,0.00,'2021-07-30','600','2021-07-30 10:50:09','600',0,1),(3529,4048,'',0,'2','5','90','ZENITH BANK E-BILLS: 101665030','','2021-07-30 10:53:39',5,0.00,0.00,'','600','2021-07-30 10:53:39','600',0,1),(3530,4049,'',0,'2','5','90','ZENITH E-BILLS: 1016650302','','2021-07-30 10:55:40',5,0.00,0.00,'','600','2021-07-30 10:55:40','600',0,1),(3531,4050,'',0,'2','5','90','JA\'IZ-0010037957','','2022-03-02 19:01:08',5,0.00,0.00,'','600','2022-03-02 19:01:08','600',0,0),(3532,2000,'',0,'6','5','90','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:22:23',5,0.00,0.00,'','600','2023-02-06 10:22:23','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (1,'5','90','0000-00-00','2023-02-07 15:19:28',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(2,'5','90','0000-00-00','2023-02-22 12:32:09',5,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(3,'5','90','0000-00-00','2023-02-22 12:34:21',0,'797','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (1,'5','90','1','3532','6',0.00,'Pms price increase from 185 to 220 on 20/1/2023  2,050ltrs ×35 = 71,750',71750.00,'2023-01-20'),(2,'5','90','1','112','supplier',71750.00,'Pms price increase from 185 to 220 on 20/1/2023  2,050 ×35 = 71,750',0.00,'2023-01-20'),(3,'5','90','2','112','supplier',0.00,'Pms price increase from 220 to 210 on 19/2/2023  2,050trs × 10 = 20,500',20500.00,'2023-02-19'),(4,'5','90','2','3532','6',20500.00,'Pms price increase from 220 to 210 on 19/2/2023  2,050ltrs ×10 = 20,500',0.00,'2023-02-19'),(5,'5','90','3','3532','6',20500.00,'Pms price increase from 220 to 210 on 19/2/2023  2,050ltrs ×10 = 20,500',0.00,'2023-02-19'),(6,'5','90','3','112','supplier',0.00,'Ago price decrease from 830 to 820 on 20/2/2023 Dipping 250 × 10 2,500',2500.00,'2023-02-20');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','90',1,'669',3912.07,1150.00,'2022-02-17','','2022-02-17 10:08:27','600','600',2022,'600','2022-02-17 10:08:27',5),('5','90',2,'670',10752.78,7550.00,'2022-09-13','','2022-09-13 11:01:26','600','600',2022,'600','2022-09-13 11:01:26',5),('5','90',3,'669',32488.98,31600.00,'2022-09-13','','2022-09-13 11:01:58','600','600',2022,'600','2022-09-13 11:01:58',5),('5','90',4,'671',500.00,4500.00,'2022-09-13','','2022-09-13 11:03:34','600','600',2022,'600','2022-09-13 11:03:34',5),('5','90',5,'668',1300.64,2000.00,'2022-09-13','','2022-09-13 11:33:03','600','600',2022,'600','2022-09-13 11:33:03',5),('5','90',6,'669',31600.00,31600.00,'2022-09-13','','2022-09-13 11:33:26','600','600',2022,'600','2022-09-13 11:33:26',5),('5','90',7,'670',7550.00,10050.00,'2022-09-13','','2022-09-13 11:34:25','600','600',2022,'600','2022-09-13 11:34:25',5),('5','90',8,'670',7230.64,8700.00,'2022-10-07','','2022-10-07 08:20:41','600','600',2022,'600','2022-10-07 08:20:41',5),('5','90',9,'668',9230.55,8000.00,'2022-10-09','','2022-10-09 09:01:33','398','398',2022,'398','2022-10-09 09:01:33',5),('5','90',10,'669',1748.81,10000.00,'2022-10-09','','2022-10-09 09:01:58','398','398',2022,'398','2022-10-09 09:01:58',5),('5','90',11,'668',8000.00,15000.00,'2022-10-09','','2022-10-09 09:02:47','398','398',2022,'398','2022-10-09 09:02:47',5),('5','90',12,'668',15000.00,8000.00,'2022-10-09','','2022-10-09 09:11:37','398','398',2022,'398','2022-10-09 09:11:37',5),('5','90',13,'669',10000.00,26000.00,'2022-10-09','','2022-10-09 09:12:12','398','398',2022,'398','2022-10-09 09:12:12',5),('5','90',14,'668',3501.41,4000.00,'2022-10-12','','2022-10-12 23:51:57','398','398',2022,'398','2022-10-12 23:51:57',5),('5','90',15,'669',6068.22,4000.00,'2022-10-14','','2022-10-14 11:53:52','398','398',2022,'398','2022-10-14 11:53:52',5),('5','90',16,'668',457.95,2000.00,'2022-10-14','','2022-10-14 11:58:14','398','398',2022,'398','2022-10-14 11:58:14',5),('5','90',17,'669',4000.00,12000.00,'2022-10-16','','2022-10-16 10:18:27','600','600',2022,'600','2022-10-16 10:18:27',5),('5','90',18,'670',30824.90,950.00,'2022-10-16','','2022-10-16 13:57:39','398','398',2022,'398','2022-10-16 13:57:39',5),('5','90',19,'668',1408.71,13900.00,'2022-10-28','','2022-10-29 05:10:27','398','398',2022,'398','2022-10-29 05:10:27',5),('5','90',20,'668',22121.94,9000.00,'2022-10-30','','2022-10-31 23:36:56','398','398',2022,'398','2022-10-31 23:36:56',5),('5','90',21,'668',3065.25,4000.00,'2022-11-05','','2022-11-06 04:52:28','398','398',2022,'398','2022-11-06 04:52:28',5),('5','90',22,'670',5696.98,5700.00,'2022-11-05','','2022-11-06 04:53:28','398','398',2022,'398','2022-11-06 04:53:28',5),('5','90',23,'668',533.52,13500.00,'2022-11-05','','2022-11-06 22:42:52','398','398',2022,'398','2022-11-06 22:42:52',5),('5','90',24,'670',3295.57,4000.00,'2022-11-09','','2022-11-10 07:39:06','398','398',2022,'398','2022-11-10 07:39:06',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1834 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','90','671',1824,'5','PUMP 4',50.00,'PMS PUMP 4','',NULL,NULL,'',5,'2021-07-23 13:29:47','600'),('5','90','669',1825,'5','PUMP 3',403918.56,'PMS PUMP 3','',NULL,NULL,'',5,'2021-07-23 13:29:06','600'),('5','90','671',1826,'5','PUMP 8',1052510.23,'PMS PUMP 8','',NULL,NULL,'',5,'2021-07-23 13:33:43','600'),('5','90','668',1827,'5','PUMP 1',2673623.76,'PMS PUMP 1','',NULL,NULL,'',5,'2021-07-23 13:26:31','600'),('5','90','669',1828,'5','PUMP 2',562162.14,'PMS PUMP 2','',NULL,NULL,'',5,'2021-07-23 13:27:39','600'),('5','90','670',1829,'5','PUMP 5',822687.90,'PMS PUMP 5','',NULL,NULL,'',5,'2021-07-23 13:30:25','600'),('5','90','672',1830,'5','PUMP 6',53.94,'PMS PUMP 6','',NULL,NULL,'',5,'2021-07-23 13:31:14','600'),('5','90','670',1831,'5','PUMP 7',2393185.59,'PMS PUMP 7','',NULL,NULL,'',5,'2021-07-23 13:32:06','600'),('5','90','673',1832,'5','PUMP 9',650093.73,'AGO PUMP 9','',NULL,NULL,'',5,'2021-07-23 13:34:51','600'),('5','90','674',1833,'5','PUMP 10',40567.00,'DPK PUMP 10',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=222 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (215,'5','90','1827','668','PMS TANKS CONNECTION ERROR.','2021-07-11 09:02:53',0,'600'),(216,'5','90','1826','671','PMS TANKS CONNECTION ERROR.','2021-07-11 09:04:32',0,'600'),(217,'5','90','1824','671','PMS TANKS CONNECTION ERROR.','2021-07-11 09:05:34',0,'600'),(218,'5','90','1828','669','PMS TANKS CONNECTION ERROR.','2021-07-11 09:06:34',0,'600'),(219,'5','90','1829','670','PMS TANKS CONNECTION ERROR.','2021-07-11 09:07:30',0,'600'),(220,'5','90','1830','672','PMS TANKS GROUPING ERROR.','2021-07-11 09:09:09',0,'600'),(221,'5','90','1831','670','PMS TANKS CONNECTION ERROR.','2021-07-11 09:09:57',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=257951 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','90',212839,'Daily Sales','2021-07-23','2021-07-23 00:00:00',NULL,'398',350735.55,350735.55,'398','2021-07-26 17:00:56','606','2021-07-26 17:03:56',10,0),('5','90',213087,'Daily shift','2021-07-24','2021-07-24 00:00:00',NULL,'398',399788.40,399788.40,'398','2021-07-26 18:17:02','606','2021-07-26 18:30:53',10,0),('5','90',213090,'Daily shift','2021-07-25','2021-07-25 00:00:00',NULL,'398',406946.10,406946.10,'398','2021-07-27 09:47:38','606','2021-07-27 09:51:56',10,0),('5','90',213229,'Daily shift','2021-07-26','2021-07-26 00:00:00',NULL,'398',220834.35,220834.35,'398','2021-07-27 10:27:10','606','2021-07-27 10:42:17',10,0),('5','90',213495,'Daily shift','2021-07-27','2021-07-27 00:00:00',NULL,'398',0.00,0.00,'398','2021-07-28 11:32:04','606','2021-07-28 11:37:14',10,0),('5','90',213498,'Daily shift','2021-07-27','2021-07-27 00:00:00',NULL,'398',439083.15,439083.15,'398','2021-07-28 15:02:22','606','2021-07-28 15:33:52',10,0),('5','90',213599,'Daily shift','2021-07-28','2021-07-28 00:00:00',NULL,'398',465672.90,465672.90,'398','2021-07-28 18:33:07','606','2021-07-29 08:44:07',10,0),('5','90',213862,'Daily shift','2021-07-29','2021-07-29 00:00:00',NULL,'398',1219107.45,1219107.45,'398','2021-07-29 22:17:57','606','2021-07-30 07:10:28',10,0),('5','90',213977,'Daily shift','2021-07-30','2021-07-30 00:00:00',NULL,'398',371786.25,371786.25,'398','2021-07-30 20:49:57','606','2021-07-30 21:06:11',10,0),('5','90',214125,'Daily shift','2021-07-31','2021-07-31 00:00:00',NULL,'398',331130.25,331130.25,'398','2021-07-31 21:32:07','606','2021-08-01 05:20:19',10,0),('5','90',214345,'Daily shift','2021-08-01','2021-08-01 00:00:00',NULL,'398',363462.00,363462.00,'398','2021-08-01 21:24:10','606','2021-08-02 05:34:30',10,0),('5','90',214595,'Daily shift','2021-08-02','2021-08-02 00:00:00',NULL,'398',482474.85,482474.85,'398','2021-08-02 20:29:08','606','2021-08-03 04:32:57',10,0),('5','90',214779,'Daily shift','2021-08-03','2021-08-03 00:00:00',NULL,'398',576011.70,576011.70,'398','2021-08-03 19:20:36','606','2021-08-04 05:54:50',10,0),('5','90',214995,'Daily shift','2021-08-04','2021-08-04 00:00:00',NULL,'398',360597.60,360597.60,'398','2021-08-04 18:53:14','606','2021-08-05 05:31:03',10,0),('5','90',215231,'Daily shift','2021-08-05','2021-08-05 00:00:00',NULL,'398',1283439.30,1283439.30,'398','2021-08-05 21:50:28','606','2021-08-06 01:18:13',10,0),('5','90',215505,'Daily shift','2021-08-06','2021-08-06 00:00:00',NULL,'398',516494.65,516494.65,'398','2021-08-06 21:30:49','606','2021-08-07 05:41:31',10,0),('5','90',215680,'Daily shift','2021-08-07','2021-08-07 00:00:00',NULL,'398',488998.85,488998.85,'398','2021-08-07 20:43:42','606','2021-08-08 03:38:45',10,0),('5','90',215895,'Daily shift','2021-08-08','2021-08-08 00:00:00',NULL,'398',357805.90,357805.90,'398','2021-08-08 21:41:43','606','2021-08-09 06:22:40',10,0),('5','90',216114,'Daily shift','2021-08-09','2021-08-09 00:00:00',NULL,'398',422585.10,422585.10,'398','2021-08-09 18:42:59','606','2021-08-10 05:40:31',10,0),('5','90',216330,'Daily shift','2021-08-10','2021-08-10 00:00:00',NULL,'398',425347.75,425347.75,'398','2021-08-10 20:56:12','606','2021-08-11 05:52:55',10,0),('5','90',216552,'Daly shift','2021-08-11','2021-08-11 00:00:00',NULL,'398',314229.20,314229.20,'398','2021-08-11 21:33:48','606','2021-08-12 05:38:38',10,0),('5','90',216790,'Daly shift','2021-08-12','2021-08-12 00:00:00',NULL,'398',1291808.40,1291808.40,'398','2021-08-12 22:15:39','606','2021-08-13 05:45:45',10,0),('5','90',217076,'Daly shift','2021-08-13','2021-08-13 00:00:00',NULL,'398',363261.10,363261.10,'398','2021-08-13 21:52:22','606','2021-08-14 05:52:49',10,0),('5','90',217292,'Daly shift','2021-08-14','2021-08-14 00:00:00',NULL,'398',341357.75,341357.75,'398','2021-08-14 23:17:54','606','2021-08-15 18:57:14',10,0),('5','90',217690,'Daly shift','2021-08-15','2021-08-15 00:00:00',NULL,'398',400722.50,400722.50,'398','2021-08-15 22:22:44','606','2021-08-16 06:13:41',10,0),('5','90',217853,'Daly shift','2021-08-16','2021-08-16 00:00:00',NULL,'398',378865.05,378865.05,'398','2021-08-16 20:21:57','606','2021-08-17 05:48:32',10,0),('5','90',218105,'Daly shift','2021-08-17','2021-08-17 00:00:00',NULL,'398',406287.45,406287.45,'398','2021-08-17 20:30:53','606','2021-08-18 00:58:13',10,0),('5','90',218221,'Daly shift','2021-08-18','2021-08-18 00:00:00',NULL,'398',292376.30,292376.30,'398','2021-08-18 19:38:36','606','2021-08-19 05:52:45',10,0),('5','90',218457,'Daly shift','2021-08-19','2021-08-19 00:00:00',NULL,'398',640417.80,640417.80,'398','2021-08-19 22:58:29','606','2021-08-20 05:51:25',10,0),('5','90',218841,'Daly shift','2021-08-20','2021-08-20 00:00:00',NULL,'398',65584.40,65584.40,'398','2021-08-21 13:56:56','606','2021-08-21 16:34:00',10,0),('5','90',219098,'Daly shift','2021-08-21','2021-08-21 00:00:00',NULL,'398',15599.60,15599.60,'398','2021-08-22 05:39:28','606','2021-08-22 06:04:47',10,0),('5','90',219119,'Daly shift','2021-08-22','2021-08-22 00:00:00',NULL,'398',337879.95,337879.95,'398','2021-08-22 21:03:07','606','2021-08-23 05:49:43',10,0),('5','90',219420,'Daly shift','2021-08-23','2021-08-23 00:00:00',NULL,'398',338847.45,338847.45,'398','2021-08-23 23:19:12','606','2021-08-24 05:42:30',10,0),('5','90',219655,'Daly shift','2021-08-24','2021-08-24 00:00:00',NULL,'398',366800.65,366800.65,'398','2021-08-24 20:36:43','606','2021-08-25 05:42:33',10,0),('5','90',219852,'Daly shift','2021-08-25','2021-08-25 00:00:00',NULL,'398',235536.60,235536.60,'398','2021-08-25 19:08:35','606','2021-08-26 04:44:16',10,0),('5','90',220019,'Daly shift','2021-08-26','2021-08-26 00:00:00',NULL,'398',1212995.20,1212995.20,'398','2021-08-26 20:55:25','606','2021-08-27 06:17:54',10,0),('5','90',220248,'Daly shift','2021-08-27','2021-08-27 00:00:00',NULL,'398',366135.80,366135.80,'398','2021-08-27 22:19:51','606','2021-08-28 05:25:09',10,0),('5','90',220490,'Daly shift','2021-08-28','2021-08-28 00:00:00',NULL,'398',242970.75,242970.75,'398','2021-08-28 20:09:22','606','2021-08-29 05:57:56',10,0),('5','90',220706,'Daly shift','2021-08-29','2021-08-29 00:00:00',NULL,'398',325911.15,325911.15,'398','2021-08-29 22:15:48','606','2021-08-30 05:38:47',10,0),('5','90',220939,'Daly shift','2021-08-30','2021-08-30 00:00:00',NULL,'398',330883.95,330883.95,'398','2021-08-30 21:56:07','606','2021-08-31 06:02:37',10,0),('5','90',221160,'Daly shift','2021-08-31','2021-08-31 00:00:00',NULL,'398',383389.40,383389.40,'398','2021-08-31 21:53:17','606','2021-09-01 05:59:21',10,0),('5','90',221416,'Daly shift','2021-09-01','2021-09-01 00:00:00',NULL,'398',453265.95,453265.95,'398','2021-09-01 21:34:39','606','2021-09-02 05:47:45',10,0),('5','90',221638,'Daly shift','2021-09-02','2021-09-02 00:00:00',NULL,'398',1230186.15,1230186.15,'398','2021-09-02 23:22:47','606','2021-09-03 05:48:02',10,0),('5','90',221913,'Daly shift','2021-09-03','2021-09-03 00:00:00',NULL,'398',443951.75,443951.75,'398','2021-09-03 21:51:37','606','2021-09-04 06:07:09',10,0),('5','90',222059,'Daly shift','2021-09-04','2021-09-04 00:00:00',NULL,'398',321828.90,321828.90,'398','2021-09-04 22:28:38','606','2021-09-05 05:59:55',10,0),('5','90',222267,'Daly shift','2021-09-05','2021-09-05 00:00:00',NULL,'398',346810.30,346810.30,'398','2021-09-05 22:14:16','606','2021-09-06 06:04:49',10,0),('5','90',222494,'Daly shift','2021-09-06','2021-09-06 00:00:00',NULL,'398',346542.65,346542.65,'398','2021-09-06 20:04:17','606','2021-09-07 06:42:54',10,0),('5','90',222846,'Dally shift','2021-09-07','2021-09-07 00:00:00',NULL,'398',221635.40,221635.40,'398','2021-09-07 21:45:52','606','2021-09-08 06:08:26',10,0),('5','90',222953,'Dally shift ','2021-09-08','2021-09-08 00:00:00',NULL,'398',295286.85,295286.85,'398','2021-09-08 21:08:19','606','2021-09-09 05:16:22',10,0),('5','90',223237,'Dally shift ','2021-09-09','2021-09-09 00:00:00',NULL,'398',1228786.15,1228786.15,'398','2021-09-10 05:03:55','606','2021-09-10 05:57:29',10,0),('5','90',223625,'Dally shift ','2021-09-10','2021-09-10 00:00:00',NULL,'398',312562.45,312562.45,'398','2021-09-11 06:26:51','606','2021-09-11 07:09:42',10,0),('5','90',223857,'Dally shift ','2021-09-11','2021-09-11 00:00:00',NULL,'398',313665.60,313665.60,'398','2021-09-11 22:55:19','606','2021-09-12 06:03:15',10,0),('5','90',223877,'Dally shift','2021-09-12','2021-09-12 00:00:00',NULL,'398',326145.40,326145.40,'398','2021-09-13 06:13:30','606','2021-09-13 07:16:48',10,0),('5','90',224121,'Dally shift 47','2021-09-13','2021-09-13 00:00:00',NULL,'398',26136.30,26136.30,'398','2021-09-13 22:14:12','606','2021-09-14 06:29:57',10,0),('5','90',224320,'Dally shift ','2021-09-14','2021-09-14 00:00:00',NULL,'398',19319.55,19319.55,'398','2021-09-14 20:35:43','606','2021-09-15 06:19:29',10,0),('5','90',224554,'Dally shift ','2021-09-15','2021-09-15 00:00:00',NULL,'398',0.00,0.00,'398','2021-09-16 06:24:51','606','2021-09-16 20:07:36',10,0),('5','90',224994,'Dally shift ','2021-09-16','2021-09-16 00:00:00',NULL,'398',399438.75,394657.57,'398','2021-09-16 20:16:13','606','2021-09-17 05:49:38',10,0),('5','90',225022,'Dally shift ','2021-09-17','2021-09-17 00:00:00',NULL,'398',394974.40,390484.12,'398','2021-09-17 22:42:35','606','2021-09-18 05:49:54',10,0),('5','90',225296,'Dally shift','2021-09-18','2021-09-18 00:00:00',NULL,'398',370165.40,366126.16,'398','2021-09-18 22:34:45','606','2021-09-19 06:00:55',10,0),('5','90',225481,'Dally shift','2021-09-19','2021-09-19 00:00:00',NULL,'398',327269.85,323575.63,'398','2021-09-19 21:21:26','606','2021-09-20 05:45:41',10,0),('5','90',225718,'Dally shift','2021-09-20','2021-09-20 00:00:00',NULL,'398',67607.10,66787.62,'398','2021-09-20 22:41:55','606','2021-09-21 05:36:58',10,0),('5','90',226000,'Dally shift','2021-09-21','2021-09-21 00:00:00',NULL,'398',371225.25,366725.55,'398','2021-09-22 09:11:22','606','2021-09-22 13:42:41',10,0),('5','90',226382,'Dally shift','2021-09-22','2021-09-22 00:00:00',NULL,'398',343652.10,339486.62,'398','2021-09-22 22:47:35','606','2021-09-23 05:40:28',10,0),('5','90',226547,'Dally shift','2021-09-23','2021-09-23 00:00:00',NULL,'398',1131357.15,1117643.73,'398','2021-09-23 20:56:31','606','2021-09-24 06:09:43',10,0),('5','90',226840,'Dally shift','2021-09-24','2021-09-24 00:00:00',NULL,'398',342536.70,338384.74,'398','2021-09-25 07:43:35','606','2021-09-25 11:35:37',10,0),('5','90',227059,'Dally shift','2021-09-25','2021-09-25 00:00:00',NULL,'398',359818.80,355457.36,'398','2021-09-25 22:08:24','606','2021-09-26 05:51:16',10,0),('5','90',227200,'Dally shift','2021-09-26','2021-09-26 00:00:00',NULL,'398',278041.50,274671.30,'398','2021-09-26 21:25:28','606','2021-09-27 05:40:56',10,0),('5','90',227394,'Dally shift','2021-09-27','2021-09-27 00:00:00',NULL,'398',89225.40,88143.88,'398','2021-09-27 20:36:51','606','2021-09-28 05:50:20',10,0),('5','90',227670,'Dally shift','2021-09-28','2021-09-28 00:00:00',NULL,'398',0.00,0.00,'398','2021-09-29 07:55:29','606','2021-09-29 12:29:02',10,0),('5','90',229380,'Dally shift','2021-10-04','2021-10-04 00:00:00',NULL,'398',26287.45,26733.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','90',230664,'Dally shift','2021-10-11','2021-10-11 00:00:00',NULL,'398',26733.00,26733.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','90',230704,'Dally shift','2021-10-04','2021-10-04 00:00:00',NULL,'398',26733.00,26733.00,'398','2021-10-11 15:33:17','606','2021-10-11 15:36:25',10,0),('5','90',230706,'Dally shift','2021-10-05','2021-10-05 00:00:00',NULL,'398',92760.00,95852.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','90',230766,'Dally shift','2021-10-06','2021-10-06 00:00:00',NULL,'398',0.00,0.00,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','90',231139,'Dally shift','2021-10-05','2021-10-05 00:00:00',NULL,'398',95852.00,95852.00,'398','2021-10-13 09:50:49','606','2021-10-13 09:54:38',10,0),('5','90',231142,'Dally shift','2021-10-06','2021-10-06 00:00:00',NULL,'398',130162.80,130162.80,'398','2021-10-13 10:00:55','606','2021-10-13 10:02:20',10,0),('5','90',231152,'Dally shift','2021-10-07','2021-10-07 00:00:00',NULL,'398',186359.60,186359.60,'398','2021-10-13 10:17:53','606','2021-10-13 10:23:45',10,0),('5','90',231156,'Dally shift','2021-10-08','2021-10-08 00:00:00',NULL,'398',96530.90,96530.90,'398','2021-10-13 10:27:14','606','2021-10-13 10:29:13',10,0),('5','90',231158,'Dally shift','2021-10-09','2021-10-09 00:00:00',NULL,'398',44144.00,44144.00,'398','2021-10-13 10:32:10','606','2021-10-13 10:35:02',10,0),('5','90',231161,'Dally shift','2021-10-10','2021-10-10 00:00:00',NULL,'398',29865.40,29865.40,'398','2021-10-13 10:44:54','606','2021-10-13 10:47:03',10,0),('5','90',231163,'Dally shift ','2021-10-11','2021-10-11 00:00:00',NULL,'398',45154.60,46611.20,'398','2021-10-13 10:49:42','606','2021-10-13 10:53:45',10,0),('5','90',231165,'Dally shift','2021-10-12','2021-10-12 00:00:00',NULL,'398',527719.45,532520.55,'398','2021-10-13 14:01:07','606','2021-10-13 14:06:57',10,0),('5','90',231243,'Dally shift','2021-10-13','2021-10-13 00:00:00',NULL,'398',564867.60,567385.40,'398','2021-10-13 20:54:39','606','2021-10-14 07:23:03',10,0),('5','90',231422,'Dally shift','2021-10-14','2021-10-14 00:00:00',NULL,'398',1397401.81,1399685.11,'398','2021-10-14 21:59:40','606','2021-10-15 06:03:10',10,0),('5','90',231640,'Dally shift','2021-10-15','2021-10-15 00:00:00',NULL,'398',361994.48,362733.58,'398','2021-10-16 01:19:06','606','2021-10-16 06:21:14',10,0),('5','90',232075,'Dally shift','2021-10-16','2021-10-16 00:00:00',NULL,'398',409281.75,412495.94,'398','2021-10-16 21:24:06','606','2021-10-17 11:36:18',10,0),('5','90',232314,'Dally shift','2021-10-18','2021-10-18 00:00:00',NULL,'398',462797.54,462797.54,'398','2021-10-18 00:05:38','606','2021-10-18 06:13:42',10,0),('5','90',232368,'Dally shift','2021-10-18','2021-10-18 00:00:00',NULL,'398',410348.37,410348.37,'398','2021-10-18 21:08:42','606','2021-10-19 05:54:11',10,0),('5','90',232823,'Dally shift','2021-10-19','2021-10-19 00:00:00',NULL,'398',256068.77,256068.77,'398','2021-10-19 23:18:04','606','2021-10-20 05:51:51',10,0),('5','90',232858,'Dally shift','2021-10-20','2021-10-20 00:00:00',NULL,'398',367178.60,367892.27,'398','2021-10-20 22:35:46','606','2021-10-21 06:05:17',10,0),('5','90',233307,'Dally shift','2021-10-21','2021-10-21 00:00:00',NULL,'398',170323.26,170323.26,'398','2021-10-21 22:54:36','606','2021-10-22 06:00:31',10,0),('5','90',233450,'Dally shift','2021-10-22','2021-10-22 00:00:00',NULL,'398',44242.80,44242.80,'398','2021-10-22 21:45:39','606','2021-10-23 06:18:57',10,0),('5','90',233671,'Dally shift','2021-10-23','2021-10-23 00:00:00',NULL,'398',29725.20,29725.20,'398','2021-10-24 03:07:14','606','2021-10-24 06:16:41',10,0),('5','90',233851,'Dally shift','2021-10-24','2021-10-24 00:00:00',NULL,'398',32992.35,32992.35,'398','2021-10-25 01:35:37','606','2021-10-25 06:06:24',10,0),('5','90',234283,'Dally shift','2021-10-25','2021-10-25 00:00:00',NULL,'398',28051.95,28051.95,'398','2021-10-25 21:28:56','606','2021-10-26 05:41:22',10,0),('5','90',234380,'Dally shift','2021-10-26','2021-10-26 00:00:00',NULL,'398',30991.35,30991.35,'398','2021-10-27 06:43:13','606','2021-10-27 08:44:11',10,0),('5','90',234695,'Dally shift','2021-10-27','2021-10-27 00:00:00',NULL,'398',60947.70,60947.70,'398','2021-10-27 18:34:26','606','2021-10-28 07:21:31',10,0),('5','90',234875,'Dally shift','2021-10-28','2021-10-28 00:00:00',NULL,'398',22466.40,22466.40,'398','2021-10-28 22:22:55','606','2021-10-29 06:08:41',10,0),('5','90',236546,'Dally shift','2021-11-04','2021-11-04 00:00:00',NULL,'398',1737783.60,1737783.60,'398','2021-11-05 06:04:44','606','2021-11-05 06:35:25',10,0),('5','90',236932,'Daly shift','2021-11-05','2021-11-05 00:00:00',NULL,'398',837363.00,837363.00,'398','2021-11-05 23:29:30','606','2021-11-06 07:05:49',10,0),('5','90',237057,'Dally shift','2021-11-06','2021-11-06 00:00:00',NULL,'398',701885.40,701885.40,'398','2021-11-06 22:39:55','606','2021-11-07 06:28:28',10,0),('5','90',237186,'Dally shift','2021-11-07','2021-11-07 00:00:00',NULL,'398',736699.65,736699.65,'398','2021-11-07 22:26:25','606','2021-11-08 06:33:00',10,0),('5','90',237450,'Dally shift','2021-11-08','2021-11-08 00:00:00',NULL,'398',785921.85,785921.85,'398','2021-11-08 21:40:42','606','2021-11-09 06:16:14',10,0),('5','90',237837,'Dally shift','2021-11-09','2021-11-09 00:00:00',NULL,'398',154887.75,154887.75,'398','2021-11-09 21:49:58','606','2021-11-10 05:52:13',10,0),('5','90',237901,'Dally shift','2021-11-10','2021-11-10 00:00:00',NULL,'398',110627.70,110627.70,'398','2021-11-10 18:48:21','606','2021-11-11 05:47:56',10,0),('5','90',238142,'Dally shift','2021-11-11','2021-11-11 00:00:00',NULL,'398',44111.70,44111.70,'398','2021-11-11 20:24:52','606','2021-11-12 07:28:49',10,0),('5','90',238432,'Dally shift','2021-11-12','2021-11-12 00:00:00',NULL,'398',89703.45,89703.45,'398','2021-11-12 21:15:10','606','2021-11-13 07:06:27',10,0),('5','90',238634,'Dally shift','2021-11-13','2021-11-13 00:00:00',NULL,'398',0.00,0.00,'398','2021-11-13 23:20:50','606','2021-11-14 05:48:55',10,0),('5','90',238935,'Dally shift','2021-11-14','2021-11-14 00:00:00',NULL,'398',523769.70,523769.70,'398','2021-11-15 05:37:13','606','2021-11-15 06:21:55',10,0),('5','90',239073,'Dally shift','2021-11-15','2021-11-15 00:00:00',NULL,'398',961630.35,961630.35,'398','2021-11-15 23:05:12','606','2021-11-16 07:17:11',10,0),('5','90',239339,'Dally shift','2021-11-16','2021-11-16 00:00:00',NULL,'398',545700.45,545700.45,'398','2021-11-17 02:41:35','606','2021-11-17 05:47:57',10,0),('5','90',239557,'Dally shift','2021-11-17','2021-11-17 00:00:00',NULL,'398',668129.10,668129.10,'398','2021-11-17 21:34:57','606','2021-11-18 06:08:01',10,0),('5','90',239809,'Dally shift','2021-11-18','2021-11-18 00:00:00',NULL,'398',1590727.80,1590727.80,'398','2021-11-18 22:11:26','606','2021-11-19 07:27:37',10,0),('5','90',240080,'Dally shift','2021-11-19','2021-11-19 00:00:00',NULL,'398',499639.80,499639.80,'398','2021-11-20 05:44:38','606','2021-11-20 07:09:46',10,0),('5','90',240268,'Daly shift','2021-11-20','2021-11-20 00:00:00',NULL,'398',617034.00,617034.00,'398','2021-11-20 20:50:01','606','2021-11-21 06:39:41',10,0),('5','90',240486,'Dally shift','2021-11-21','2021-11-21 00:00:00',NULL,'398',664270.20,664270.20,'398','2021-11-21 21:05:09','606','2021-11-22 06:22:12',10,0),('5','90',240704,'Dally shift','2021-11-22','2021-11-22 00:00:00',NULL,'398',547054.20,547054.20,'398','2021-11-22 23:49:53','606','2021-11-23 07:02:24',10,0),('5','90',240998,'Dally shift','2021-11-23','2021-11-23 00:00:00',NULL,'398',178373.25,178373.25,'398','2021-11-23 20:20:47','606','2021-11-24 06:22:36',10,0),('5','90',241230,'Dally shift','2021-11-24','2021-11-24 00:00:00',NULL,'398',0.00,0.00,'398','2021-11-24 19:38:37','606','2021-11-25 06:26:51',10,0),('5','90',241569,'Dally shift','2021-11-25','2021-11-25 00:00:00',NULL,'398',0.00,0.00,'398','2021-11-26 05:56:18','606','2021-11-26 06:11:25',10,0),('5','90',241807,'Dally shift','2021-11-26','2021-11-26 00:00:00',NULL,'398',0.00,0.00,'398','2021-11-26 20:09:35','606','2021-11-27 07:10:14',10,0),('5','90',242152,'Dally shift','2021-11-27','2021-11-27 00:00:00',NULL,'398',0.00,0.00,'398','2021-11-27 19:35:01','606','2021-11-28 06:49:51',10,0),('5','90',242389,'Dally shifts and 6363','2021-11-28','2021-11-28 00:00:00',NULL,'398',0.00,0.00,'398','2021-11-28 20:59:12','606','2021-11-29 05:59:11',10,0),('5','90',242519,'Dally shift','2021-11-29','2021-11-29 00:00:00',NULL,'398',0.00,0.00,'398','2021-11-29 21:12:23','606','2021-11-30 06:02:52',10,0),('5','90',242781,'Dally shift','2021-11-30','2021-11-30 00:00:00',NULL,'398',0.00,0.00,'398','2021-11-30 22:00:08','606','2021-12-01 07:53:44',10,0),('5','90',242986,'Dally shift','2021-12-01','2021-12-01 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-01 19:45:42','606','2021-12-02 07:21:25',10,0),('5','90',243277,'Dally shift','2021-12-02','2021-12-02 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-02 20:35:32','606','2021-12-03 06:57:59',10,0),('5','90',243454,'Dally shift','2021-12-03','2021-12-03 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-04 05:18:17','606','2021-12-04 06:56:15',10,0),('5','90',243791,'Dally shift','2021-12-04','2021-12-04 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-04 20:35:43','606','2021-12-05 05:47:10',10,0),('5','90',243977,'Dally shift','2021-12-05','2021-12-05 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-05 18:04:54','606','2021-12-06 06:30:22',10,0),('5','90',244155,'Dally shift','2021-12-06','2021-12-06 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-06 22:34:52','606','2021-12-07 06:52:41',10,0),('5','90',244440,'Dally shift','2021-12-07','2021-12-07 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-07 20:14:22','606','2021-12-08 07:18:32',10,0),('5','90',244706,'Dally shift28','2021-12-08','2021-12-08 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-08 20:29:09','606','2021-12-09 05:43:22',10,0),('5','90',244881,'Dally shift','2021-12-09','2021-12-09 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-10 01:07:34','606','2021-12-10 06:16:33',10,0),('5','90',245089,'Dally shift','2021-12-10','2021-12-10 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-10 20:41:53','606','2021-12-11 07:00:49',10,0),('5','90',245621,'Dally shift ','2021-12-12','2021-12-12 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-12 19:03:21','606','2021-12-13 06:01:19',10,0),('5','90',245901,'Dally shift','2021-12-13','2021-12-13 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-13 20:44:40','606','2021-12-14 06:08:13',10,0),('5','90',245970,'Dally shift','2021-12-14','2021-12-14 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-16 06:09:36','606','2021-12-16 06:51:59',10,0),('5','90',246635,'Dally shift','2021-12-16','2021-12-16 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-16 17:35:08','606','2021-12-17 06:11:55',10,0),('5','90',246724,'Dally shift','2021-12-17','2021-12-17 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-17 18:08:27','606','2021-12-18 07:03:48',10,0),('5','90',247048,'Dally shift','2021-12-18','2021-12-18 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-18 21:15:56','606','2021-12-19 07:13:27',10,0),('5','90',247245,'Dally shift','2021-12-19','2021-12-19 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-19 20:48:49','606','2021-12-20 06:56:47',10,0),('5','90',247599,'Dally shift','2021-12-20','2021-12-20 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-20 17:43:39','600','2021-12-21 09:22:22',10,0),('5','90',247849,'Dally shift','2021-12-21','2021-12-21 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-21 17:56:28','606','2021-12-22 18:06:45',10,0),('5','90',248117,'Dally shift','2021-12-22','2021-12-22 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-22 21:18:43','606','2021-12-23 06:33:19',10,0),('5','90',248520,'Dally shift','2021-12-23','2021-12-23 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-24 13:46:12','606','2021-12-24 19:39:13',10,0),('5','90',248613,'Dally shift','2021-12-24','2021-12-24 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-24 21:58:51','606','2021-12-25 14:09:41',10,0),('5','90',248818,'Dally shift','2021-12-25','2021-12-25 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-25 17:59:55','606','2021-12-26 07:32:45',10,0),('5','90',248934,'Dally shift','2021-12-26','2021-12-26 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-27 09:22:47','606','2021-12-27 09:39:35',10,0),('5','90',249198,'Dally shift','2021-12-27','2021-12-27 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-27 17:58:24','606','2021-12-28 07:37:09',10,0),('5','90',249399,'Dally shift','2021-12-28','2021-12-28 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-28 19:16:34','606','2021-12-29 06:46:33',10,0),('5','90',249714,'Dally shift','2021-12-29','2021-12-29 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-29 19:54:31','606','2021-12-30 06:58:52',10,0),('5','90',249959,'Dally shift','2021-12-30','2021-12-30 00:00:00',NULL,'398',0.00,0.00,'398','2021-12-30 20:43:24','606','2021-12-31 06:45:35',10,0),('5','90',250180,'Dally shift','2021-12-31','2021-12-31 00:00:00',NULL,'398',464565.75,464565.75,'398','2021-12-31 21:05:55','606','2022-01-01 07:50:19',10,0),('5','90',250412,'Dally shift','2022-01-01','2022-01-01 00:00:00',NULL,'398',598697.55,598697.55,'398','2022-01-01 21:49:58','606','2022-01-02 06:47:50',10,0),('5','90',250600,'Dally shift','2022-01-02','2022-01-02 00:00:00',NULL,'398',751040.40,751040.40,'398','2022-01-02 21:10:21','606','2022-01-03 14:06:33',10,0),('5','90',250993,'Dally shift','2022-01-03','2022-01-03 00:00:00',NULL,'398',1700869.50,1700869.50,'398','2022-01-03 21:44:06','606','2022-01-04 07:05:48',10,0),('5','90',251061,'Dally shift','2022-01-04','2022-01-04 00:00:00',NULL,'398',1413622.65,1413622.65,'398','2022-01-04 22:03:53','606','2022-01-05 07:35:58',10,0),('5','90',251365,'Dally shift','2022-01-05','2022-01-05 00:00:00',NULL,'398',1572727.20,1572727.20,'398','2022-01-05 21:50:55','606','2022-01-06 07:49:59',10,0),('5','90',251587,'Dally shift','2022-01-06','2022-01-06 00:00:00',NULL,'398',1526672.40,1526672.40,'398','2022-01-06 22:51:39','606','2022-01-07 09:10:19',10,0),('5','90',251915,'Dally shift','2022-01-07','2022-01-07 00:00:00',NULL,'398',649877.25,649877.25,'398','2022-01-08 00:18:15','606','2022-01-08 07:59:04',10,0),('5','90',252157,'Dally shift','2022-01-08','2022-01-08 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-08 20:40:31','606','2022-01-09 08:02:58',10,0),('5','90',252372,'Dally shift','2022-01-09','2022-01-09 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-09 21:31:01','606','2022-01-10 07:03:00',10,0),('5','90',252525,'Dally shift','2022-01-10','2022-01-10 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-10 19:58:33','606','2022-01-11 05:35:22',10,0),('5','90',252752,'Dally shift','2022-01-11','2022-01-11 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-11 21:27:20','606','2022-01-12 07:50:26',10,0),('5','90',253067,'Dally shift','2022-01-12','2022-01-12 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-12 21:50:22','606','2022-01-13 07:35:53',10,0),('5','90',253249,'Dally shift','2022-01-13','2022-01-13 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-13 20:52:26','606','2022-01-14 09:41:34',10,0),('5','90',253542,'Dally shift','2022-01-14','2022-01-14 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-14 20:19:18','606','2022-01-15 07:16:12',10,0),('5','90',253836,'Dally shift','2022-01-15','2022-01-15 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-15 22:08:09','606','2022-01-16 07:22:56',10,0),('5','90',254138,'Dally shift','2022-01-16','2022-01-16 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-16 19:09:59','606','2022-01-17 07:14:37',10,0),('5','90',254237,'Dally shift','2022-01-17','2022-01-17 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-17 21:18:11','606','2022-01-18 08:40:14',10,0),('5','90',254669,'Dally shift','2022-01-18','2022-01-18 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-18 21:14:19','606','2022-01-19 10:06:52',10,0),('5','90',254843,'Dally shift','2022-01-19','2022-01-19 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-20 11:18:55','606','2022-01-20 11:32:23',10,0),('5','90',255049,'Dally shift','2022-01-20','2022-01-20 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-20 21:59:41','606','2022-01-21 08:36:53',10,0),('5','90',255272,'Dally shift','2022-01-21','2022-01-21 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-21 21:16:57','606','2022-01-22 08:08:13',10,0),('5','90',255604,'Dally shift','2022-01-22','2022-01-22 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-22 21:20:19','606','2022-01-23 07:24:12',10,0),('5','90',255921,'Dally shift','2022-01-23','2022-01-23 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-23 22:45:18','606','2022-01-24 08:34:00',10,0),('5','90',256142,'Dally shift','2022-01-24','2022-01-24 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-24 19:40:41','606','2022-01-25 07:34:03',10,0),('5','90',256586,'Dally shift37375','2022-01-26','2022-01-26 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-26 20:23:33','606','2022-01-27 07:57:56',10,0),('5','90',256915,'Dally shift','2022-01-27','2022-01-27 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-27 20:49:38','606','2022-01-28 07:23:19',10,0),('5','90',257080,'Dally shift','2022-01-28','2022-01-28 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-28 21:17:45','606','2022-01-29 07:51:48',10,0),('5','90',257470,'Dally shift','2022-01-29','2022-01-29 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-30 02:47:45','606','2022-01-30 07:45:37',10,0),('5','90',257523,'Dally shift','2022-01-30','2022-01-30 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-31 07:49:38','606','2022-01-31 09:30:51',10,0),('5','90',257524,'Dally shift ','2022-01-31','2022-01-31 00:00:00',NULL,'398',0.00,0.00,'398','2022-01-31 22:13:46','606','2022-02-01 08:30:07',10,0),('5','90',257525,'Dally shift','2022-02-01','2022-02-01 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-03 09:49:47','606','2022-02-03 09:52:25',10,0),('5','90',257526,'Dally shift','2022-02-02','2022-02-02 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-03 09:55:17','606','2022-02-03 09:57:41',10,0),('5','90',257527,'Dally shift','2022-02-03','2022-02-03 00:00:00',NULL,'398',1093648.05,1093648.05,'398','2022-02-03 21:42:12','606','2022-02-04 06:27:40',10,0),('5','90',257528,'Dally shift','2022-02-04','2022-02-04 00:00:00',NULL,'398',594217.80,594217.80,'398','2022-02-04 22:00:20','606','2022-02-05 07:51:07',10,0),('5','90',257529,'Dally shift','2022-02-05','2022-02-05 00:00:00',NULL,'398',874655.10,874655.10,'398','2022-02-05 23:04:59','606','2022-02-06 07:47:29',10,0),('5','90',257530,'Dally shift','2022-02-06','2022-02-06 00:00:00',NULL,'398',815395.35,815395.35,'398','2022-02-06 21:22:57','606','2022-02-07 07:16:43',10,0),('5','90',257531,'Dally shift ','2022-02-07','2022-02-07 00:00:00',NULL,'398',887119.20,887119.20,'398','2022-02-07 23:30:47','606','2022-02-08 07:42:45',10,0),('5','90',257532,'Dally shift','2022-02-08','2022-02-08 00:00:00',NULL,'398',501963.00,501963.00,'398','2022-02-09 01:58:13','606','2022-02-09 08:18:38',10,0),('5','90',257533,'Dally shift','2022-02-09','2022-02-09 00:00:00',NULL,'398',176787.60,176787.60,'398','2022-02-09 22:16:15','606','2022-02-10 08:00:56',10,0),('5','90',257534,'Dally shift','2022-02-10','2022-02-10 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-10 21:37:26','606','2022-02-11 08:11:56',10,0),('5','90',257535,'Dally shift','2022-02-11','2022-02-11 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-11 20:16:16','606','2022-02-12 08:13:02',10,0),('5','90',257536,'Dally shift','2022-02-12','2022-02-12 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-12 20:51:41','606','2022-02-13 07:29:56',10,0),('5','90',257537,'Dally shift','2022-02-13','2022-02-13 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-14 06:04:01','606','2022-02-14 07:20:47',10,0),('5','90',257538,'Dally shift','2022-02-14','2022-02-14 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-14 18:39:12','606','2022-02-15 08:10:25',10,0),('5','90',257539,'Dally shift','2022-02-15','2022-02-15 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-15 21:31:59','606','2022-02-16 07:32:40',10,0),('5','90',257540,'Dally shift','2022-02-16','2022-02-16 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-16 20:59:07','606','2022-02-17 07:09:32',10,0),('5','90',257541,'Dally shift','2022-02-17','2022-02-17 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-17 22:00:45','606','2022-02-18 07:23:32',10,0),('5','90',257542,'Dally shift','2022-02-18','2022-02-18 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-18 18:47:48','606','2022-02-19 07:31:41',10,0),('5','90',257543,'Dally shift','2022-02-19','2022-02-19 00:00:00',NULL,'398',0.00,0.00,'398','2022-02-19 20:40:57','606','2022-02-20 07:21:43',10,0),('5','90',257544,'Dally shift','2022-02-20','2022-02-20 00:00:00',NULL,'398',851494.05,851494.05,'398','2022-02-21 06:59:14','606','2022-02-21 07:25:21',10,0),('5','90',257545,'Dally shift','2022-02-21','2022-02-21 00:00:00',NULL,'398',1242214.05,1242214.05,'398','2022-02-21 22:56:19','606','2022-02-22 06:43:16',10,0),('5','90',257546,'Dally shift','2022-02-22','2022-02-22 15:30:05','2022-02-23 15:30:05','398',45891.45,45891.45,'398','2022-02-22 21:18:22','606','2022-02-23 07:02:33',10,0),('5','90',257547,'Dally shift','2022-02-23','2022-02-23 20:53:09','2022-02-24 20:53:09','398',0.00,0.00,'398','2022-02-23 20:53:31','606','2022-02-24 09:38:31',10,0),('5','90',257548,'Dally shift','2022-02-24','2022-02-24 10:59:42','2022-02-25 10:59:42','398',0.00,0.00,'398','2022-02-25 00:35:59','606','2022-02-25 08:11:10',10,0),('5','90',257549,'Dally shift','2022-02-25','2022-02-25 09:25:52','2022-02-26 09:25:52','398',0.00,0.00,'398','2022-02-25 21:04:06','606','2022-02-26 07:20:10',10,0),('5','90',257550,'Dally shift','2022-02-26','2022-02-26 23:48:17','2022-02-27 23:48:17','398',148496.70,148496.70,'398','2022-02-27 07:33:34','606','2022-02-27 23:05:38',10,0),('5','90',257551,'Dally shift','2022-02-27','2022-02-28 08:31:38','2022-03-01 08:31:38','398',2238611.10,2238611.10,'398','2022-02-28 08:49:44','606','2022-03-01 06:54:53',10,0),('5','90',257552,'Dally shift','2022-02-28','2022-03-01 08:46:22','2022-03-02 08:46:22','398',1802039.25,1802039.25,'398','2022-03-01 08:47:45','606','2022-03-01 09:24:50',10,0),('5','90',257553,'Dally shift','2022-03-01','2022-03-01 09:44:23','2022-03-02 09:44:23','398',898202.25,898202.25,'398','2022-03-01 22:31:48','606','2022-03-02 08:19:56',10,0),('5','90',257554,'Dally shift','2022-03-02','2022-03-02 12:01:10','2022-03-03 12:01:10','398',0.00,0.00,'398','2022-03-02 21:25:48','606','2022-03-03 10:21:42',10,0),('5','90',257555,'Dally shift ','2022-03-03','2022-03-03 23:24:34','2022-03-04 23:24:34','398',0.00,0.00,'398','2022-03-03 23:25:01','606','2022-03-04 09:13:39',10,0),('5','90',257556,'Dally shift','2022-03-04','2022-03-04 10:12:05','2022-03-05 10:12:05','398',0.00,0.00,'398','2022-03-04 22:55:05','606','2022-03-05 07:33:40',10,0),('5','90',257557,'Dally shift','2022-03-05','2022-03-05 18:08:13','2022-03-06 18:08:13','398',0.00,0.00,'398','2022-03-05 23:08:09','606','2022-03-06 07:43:05',10,0),('5','90',257558,'Dally shift','2022-03-06','2022-03-06 21:43:32','2022-03-07 21:43:32','398',0.00,0.00,'398','2022-03-06 21:43:48','606','2022-03-07 07:59:18',10,0),('5','90',257559,'Dally shift','2022-03-07','2022-03-07 22:03:54','2022-03-08 22:03:54','398',0.00,0.00,'398','2022-03-07 22:04:11','606','2022-03-08 07:03:48',10,0),('5','90',257560,'Dally shift','2022-03-08','2022-03-08 13:04:16','2022-03-09 13:04:16','398',0.00,0.00,'398','2022-03-09 00:43:06','606','2022-03-09 07:57:47',10,0),('5','90',257561,'Dally shift','2022-03-09','2022-03-09 22:20:24','2022-03-10 22:20:24','398',0.00,0.00,'398','2022-03-09 22:20:42','606','2022-03-10 06:39:47',10,0),('5','90',257562,'Dally shift','2022-03-10','2022-03-10 14:03:36','2022-03-11 14:03:36','398',0.00,0.00,'398','2022-03-10 19:00:57','606','2022-03-11 08:25:17',10,0),('5','90',257563,'Dally shifted','2022-03-11','2022-03-11 23:11:57','2022-03-12 23:11:57','398',0.00,0.00,'398','2022-03-11 23:12:22','606','2022-03-12 07:56:45',10,0),('5','90',257564,'Dally shift','2022-03-12','2022-03-12 22:04:02','2022-03-13 22:04:02','398',0.00,0.00,'398','2022-03-12 22:04:18','606','2022-03-13 08:07:12',10,0),('5','90',257565,'Dally shift','2022-03-13','2022-03-13 20:31:43','2022-03-14 20:31:43','398',0.00,0.00,'398','2022-03-13 20:32:01','606','2022-03-14 07:06:47',10,0),('5','90',257566,'Dally shift','2022-03-14','2022-03-14 22:14:15','2022-03-15 22:14:15','398',0.00,0.00,'398','2022-03-14 22:14:52','606','2022-03-15 07:08:13',10,0),('5','90',257567,'Dally shift','2022-03-15','2022-03-16 04:57:34','2022-03-17 04:57:34','398',0.00,0.00,'398','2022-03-16 04:58:00','606','2022-03-16 08:10:14',10,0),('5','90',257568,'Dally shift','2022-03-16','2022-03-16 11:59:32','2022-03-17 11:59:32','398',66000.00,66000.00,'398','2022-03-17 10:14:57','606','2022-03-17 10:22:46',10,0),('5','90',257569,'Dally shift','2022-03-17','2022-03-17 23:53:47','2022-03-18 23:53:47','398',1341253.65,1341253.65,'398','2022-03-17 23:55:08','606','2022-03-18 07:47:40',10,0),('5','90',257570,'Dally shift','2022-03-18','2022-03-18 10:53:46','2022-03-19 10:53:46','398',720571.50,720571.50,'398','2022-03-18 22:33:16','606','2022-03-19 07:01:58',10,0),('5','90',257571,'Dally shift','2022-03-19','2022-03-19 18:50:59','2022-03-20 18:50:59','398',0.00,0.00,'398','2022-03-19 21:43:43','606','2022-03-20 07:31:28',10,0),('5','90',257572,'Dally shift','2022-03-20','2022-03-20 19:22:52','2022-03-21 19:22:52','398',0.00,0.00,'398','2022-03-20 19:23:19','606','2022-03-21 06:33:23',10,0),('5','90',257573,'Dally shift','2022-03-21','2022-03-21 19:49:41','2022-03-22 19:49:41','398',0.00,0.00,'398','2022-03-21 19:49:58','606','2022-03-22 07:06:50',10,0),('5','90',257574,'Dally shift','2022-03-22','2022-03-22 13:52:43','2022-03-23 13:52:43','398',0.00,0.00,'398','2022-03-22 19:51:56','606','2022-03-23 06:33:34',10,0),('5','90',257575,'Dally shift','2022-03-23','2022-03-23 21:50:42','2022-03-24 21:50:42','398',0.00,0.00,'398','2022-03-23 21:50:59','606','2022-03-24 20:34:25',10,0),('5','90',257576,'Dally shift','2022-03-24','2022-03-24 22:30:41','2022-03-25 22:30:41','398',0.00,0.00,'398','2022-03-24 22:30:56','606','2022-03-25 08:28:57',10,0),('5','90',257577,'Dally shift','2022-03-25','2022-03-25 08:47:30','2022-03-26 08:47:30','398',0.00,0.00,'398','2022-03-25 23:41:25','606','2022-03-26 08:05:30',10,0),('5','90',257578,'Dally shift','2022-03-26','2022-03-27 06:14:14','2022-03-28 06:14:14','398',0.00,0.00,'398','2022-03-27 06:14:33','606','2022-03-27 07:06:02',10,0),('5','90',257579,'Dally shift','2022-03-27','2022-03-27 18:38:41','2022-03-28 18:38:41','398',0.00,0.00,'398','2022-03-27 18:39:03','606','2022-03-28 09:21:18',10,0),('5','90',257580,'Dally shift','2022-03-28','2022-03-28 22:59:16','2022-03-29 22:59:16','398',0.00,0.00,'398','2022-03-28 22:59:35','606','2022-03-29 07:21:09',10,0),('5','90',257581,'Dally shift','2022-03-29','2022-03-30 11:58:26','2022-03-31 11:58:26','398',0.00,0.00,'398','2022-03-30 11:58:41','606','2022-03-30 12:07:37',10,0),('5','90',257582,'Dally shift','2022-03-30','2022-03-30 14:38:16','2022-03-31 14:38:16','398',0.00,0.00,'398','2022-03-30 21:21:21','606','2022-03-31 08:03:38',10,0),('5','90',257583,'Dally shift','2022-03-31','2022-03-31 22:30:30','2022-04-01 22:30:30','398',0.00,0.00,'398','2022-03-31 22:30:51','797','2022-04-01 07:34:08',10,0),('5','90',257584,'Dally shift','2022-04-01','2022-04-01 19:17:59','2022-04-02 19:17:59','398',0.00,0.00,'398','2022-04-01 19:18:25','797','2022-04-02 17:01:00',10,0),('5','90',257585,'Dally shift','2022-04-02','2022-04-02 19:30:48','2022-04-03 19:30:48','398',0.00,0.00,'398','2022-04-02 19:31:16','797','2022-04-02 21:16:23',10,0),('5','90',257586,'Dally shift','2022-04-03','2022-04-03 22:28:08','2022-04-04 22:28:08','398',0.00,0.00,'398','2022-04-03 22:28:42','797','2022-04-04 09:06:34',10,0),('5','90',257587,'Dally shift','2022-04-04','2022-04-04 09:11:10','2022-04-05 09:11:10','398',0.00,0.00,'398','2022-04-04 19:07:29','797','2022-04-05 10:29:20',10,0),('5','90',257588,'Dally shift','2022-04-05','2022-04-05 22:34:04','2022-04-06 22:34:04','398',0.00,0.00,'398','2022-04-05 22:34:21','797','2022-04-06 09:48:48',10,0),('5','90',257589,'Dally shift','2022-04-06','2022-04-06 22:41:29','2022-04-07 22:41:29','398',0.00,0.00,'398','2022-04-06 22:41:45','606','2022-04-07 06:10:26',10,0),('5','90',257590,'Dally shift','2022-04-07','2022-04-07 23:31:10','2022-04-08 23:31:10','398',0.00,0.00,'398','2022-04-07 23:31:42','797','2022-04-08 10:31:01',10,0),('5','90',257591,'Dally shift','2022-04-08','2022-04-08 11:46:37','2022-04-09 11:46:37','398',0.00,0.00,'398','2022-04-09 16:08:29','797','2022-04-09 16:12:43',10,0),('5','90',257592,'Dally shift','2022-04-09','2022-04-09 17:27:45','2022-04-10 17:27:45','398',518882.10,518882.10,'398','2022-04-10 01:39:59','797','2022-04-10 15:00:29',10,0),('5','90',257593,'Dally shift','2022-04-11','2022-04-11 00:31:24','2022-04-12 00:31:24','398',984723.30,984723.30,'398','2022-04-11 00:33:28','797','2022-04-11 08:58:12',10,0),('5','90',257594,'Dally shift','2022-04-11','2022-04-11 16:28:18','2022-04-12 16:28:18','398',523393.20,523393.20,'398','2022-04-12 04:18:19','797','2022-04-12 07:17:08',10,0),('5','90',257595,'Dally shift','2022-04-12','2022-04-12 14:47:10','2022-04-13 14:47:10','398',450522.60,450522.60,'398','2022-04-12 23:09:49','797','2022-04-13 09:55:00',10,0),('5','90',257596,'Dally shift','2022-04-13','2022-04-13 12:07:33','2022-04-14 12:07:33','398',0.00,0.00,'398','2022-04-14 00:23:43','797','2022-04-14 08:23:31',10,0),('5','90',257597,'Dally shift','2022-04-14','2022-04-14 21:22:04','2022-04-15 21:22:04','398',0.00,0.00,'398','2022-04-14 21:22:30','797','2022-04-15 15:17:53',10,0),('5','90',257598,'Dally shift','2022-04-15','2022-04-15 17:10:08','2022-04-16 17:10:08','398',0.00,0.00,'398','2022-04-16 18:33:36','797','2022-04-16 20:40:23',10,0),('5','90',257599,'Dally shift','2022-04-16','2022-04-16 20:46:05','2022-04-17 20:46:05','398',0.00,0.00,'398','2022-04-16 20:46:31','797','2022-04-17 07:07:53',10,0),('5','90',257600,'Dally shift','2022-04-17','2022-04-17 08:10:47','2022-04-18 08:10:47','398',0.00,0.00,'398','2022-04-17 18:14:51','797','2022-04-17 22:11:15',10,0),('5','90',257601,'Dally shift','2022-04-18','2022-04-18 19:56:34','2022-04-19 19:56:34','398',0.00,0.00,'398','2022-04-18 19:56:50','797','2022-04-18 21:08:23',10,0),('5','90',257602,'Dally shift','2022-04-19','2022-04-19 10:08:30','2022-04-20 10:08:30','398',0.00,0.00,'398','2022-04-19 21:03:49','797','2022-04-19 22:45:26',10,0),('5','90',257603,'Dally shift','2022-04-20','2022-04-20 19:23:05','2022-04-21 19:23:05','398',0.00,0.00,'398','2022-04-20 19:23:21','797','2022-04-21 08:52:36',10,0),('5','90',257604,'Dally shift','2022-04-21','2022-04-21 10:41:29','2022-04-22 10:41:29','398',0.00,0.00,'398','2022-04-22 08:02:14','797','2022-04-22 09:26:33',10,0),('5','90',257605,'Dally shift','2022-04-22','2022-04-22 20:40:09','2022-04-23 20:40:09','398',0.00,0.00,'398','2022-04-22 20:40:25','797','2022-04-23 09:26:33',10,0),('5','90',257606,'Dally shift','2022-04-23','2022-04-23 22:45:52','2022-04-24 22:45:52','398',0.00,0.00,'398','2022-04-23 22:46:09','797','2022-04-24 05:37:57',10,0),('5','90',257607,'Dally shift','2022-04-24','2022-04-27 09:14:28','2022-04-28 09:14:28','398',0.00,0.00,'398','2022-04-27 09:14:56','797','2022-04-27 09:16:51',10,0),('5','90',257608,'Dally shift','2022-04-25','2022-04-27 09:26:51','2022-04-28 09:26:51','398',0.00,0.00,'398','2022-04-27 09:27:18','797','2022-04-27 09:29:18',10,0),('5','90',257609,'Dally shift','2022-04-26','2022-04-27 09:36:33','2022-04-28 09:36:33','398',0.00,0.00,'398','2022-04-27 09:37:44','797','2022-04-27 09:38:51',10,0),('5','90',257610,'Dally shift','2022-04-26','2022-04-27 10:11:38','2022-04-28 10:11:38','398',267900.60,267900.60,'398','2022-04-27 11:03:07','797','2022-04-27 11:12:21',10,0),('5','90',257611,'Dally shift','2022-04-27','2022-04-28 08:27:54','2022-04-29 08:27:54','398',971142.15,971142.15,'398','2022-04-28 08:30:51','797','2022-04-28 08:34:44',10,0),('5','90',257612,'Dally shift','2022-04-28','2022-04-28 08:49:44','2022-04-29 08:49:44','398',885517.05,885517.05,'398','2022-04-28 18:02:24','797','2022-04-28 20:49:32',10,0),('5','90',257613,'Dally shift','2022-05-09','2022-05-09 15:27:43','2022-05-10 15:27:43','398',0.00,0.00,'398','2022-05-09 15:46:19','797','2022-05-09 15:47:49',10,0),('5','90',257614,'Dally shift','2022-04-29','2022-05-09 16:05:52','2022-05-10 16:05:52','398',328348.35,328348.35,'398','2022-05-09 16:07:44','797','2022-05-09 16:15:42',10,0),('5','90',257615,'Dally shift','2022-04-30','2022-05-09 16:18:20','2022-05-10 16:18:20','398',0.00,0.00,'398','2022-05-09 16:19:33','797','2022-05-09 16:20:32',10,0),('5','90',257616,'Dally shift','2022-05-01','2022-05-09 16:21:11','2022-05-10 16:21:11','398',0.00,0.00,'398','2022-05-09 16:21:46','797','2022-05-09 16:23:15',10,0),('5','90',257617,'Dally shift','2022-05-02','2022-05-09 16:24:17','2022-05-10 16:24:17','398',0.00,0.00,'398','2022-05-09 16:24:44','797','2022-05-09 16:25:02',10,0),('5','90',257618,'Dally shift','2022-05-03','2022-05-09 16:26:09','2022-05-10 16:26:09','398',0.00,0.00,'398','2022-05-09 16:26:40','797','2022-05-09 16:27:00',10,0),('5','90',257619,'Dally shift','2022-05-04','2022-05-09 16:28:42','2022-05-10 16:28:42','398',0.00,0.00,'398','2022-05-09 16:29:13','797','2022-05-09 16:30:56',10,0),('5','90',257620,'Dally shift','2022-05-05','2022-05-09 16:31:29','2022-05-10 16:31:29','398',977550.75,977550.75,'398','2022-05-09 17:01:07','797','2022-05-09 17:01:34',10,0),('5','90',257621,'Dally shift','2022-05-06','2022-05-09 17:04:20','2022-05-10 17:04:20','398',881636.25,881636.25,'398','2022-05-09 17:07:28','797','2022-05-09 17:07:49',10,0),('5','90',257622,'Dally shift','2022-05-07','2022-05-09 17:09:04','2022-05-10 17:09:04','398',968944.35,968944.35,'398','2022-05-09 17:10:54','797','2022-05-09 17:11:46',10,0),('5','90',257623,'Dally shift','2022-05-08','2022-05-09 17:12:39','2022-05-10 17:12:39','398',755498.70,755498.70,'398','2022-05-09 17:14:00','797','2022-05-09 17:15:14',10,0),('5','90',257624,'Dally shift','2022-05-09','2022-05-09 17:17:06','2022-05-10 17:17:06','398',615530.85,615530.85,'398','2022-05-09 17:27:45','797','2022-05-10 08:57:38',10,0),('5','90',257625,'Shift dally','2022-05-10','2022-05-12 11:09:07','2022-05-13 11:09:07','398',567303.00,567303.00,'398','2022-05-12 11:15:09','797','2022-05-12 11:16:12',10,0),('5','90',257626,'Shift dally','2022-05-11','2022-05-12 11:27:50','2022-05-13 11:27:50','398',158340.60,158340.60,'398','2022-05-12 11:29:31','797','2022-05-12 11:33:38',10,0),('5','90',257627,'Shift dally','2022-05-12','2022-05-12 15:32:30','2022-05-13 15:32:30','398',0.00,0.00,'398','2022-05-12 20:37:50','797','2022-05-13 09:53:58',10,0),('5','90',257628,'Dally shift','2022-05-13','2022-05-14 20:51:12','2022-05-15 20:51:12','398',0.00,0.00,'398','2022-05-14 20:51:48','797','2022-05-14 20:57:23',10,0),('5','90',257629,'Dally shift','2022-05-14','2022-05-14 21:00:49','2022-05-15 21:00:49','398',0.00,0.00,'398','2022-05-14 21:01:10','797','2022-05-14 21:07:45',10,0),('5','90',257630,'Dally shift if','2022-05-15','2022-05-15 07:03:00','2022-05-16 07:03:00','398',252450.00,252450.00,'398','2022-05-16 08:39:32','797','2022-05-16 09:18:05',10,0),('5','90',257631,'Dally shift','2022-05-16','2022-05-16 12:14:25','2022-05-17 12:14:25','398',678844.65,678844.65,'398','2022-05-16 23:10:48','797','2022-05-17 06:52:58',10,0),('5','90',257632,'Dally shift','2022-05-17','2022-05-17 08:32:38','2022-05-18 08:32:38','398',967972.50,967972.50,'398','2022-05-17 22:29:28','797','2022-05-18 07:12:29',10,0),('5','90',257633,'Dally shift','2022-05-18','2022-05-18 09:55:37','2022-05-19 09:55:37','398',542633.85,542633.85,'398','2022-05-18 23:13:57','797','2022-05-19 06:18:05',10,0),('5','90',257634,'Dally shift','2022-05-19','2022-05-19 07:49:21','2022-05-20 07:49:21','398',0.00,0.00,'398','2022-05-19 20:26:06','797','2022-05-19 22:34:33',10,0),('5','90',257635,'Dally shift','2022-05-20','2022-05-20 05:06:28','2022-05-21 05:06:28','398',0.00,0.00,'398','2022-05-20 21:55:09','797','2022-05-20 22:33:14',10,0),('5','90',257636,'Dally shift','2022-05-21','2022-05-21 07:10:58','2022-05-22 07:10:58','398',0.00,0.00,'398','2022-05-21 19:37:51','797','2022-05-21 22:39:10',10,0),('5','90',257637,'Dally shift','2022-05-22','2022-05-22 21:43:36','2022-05-23 21:43:36','398',0.00,0.00,'398','2022-05-22 21:43:58','797','2022-05-23 05:41:31',10,0),('5','90',257638,'Dally shift','2022-05-23','2022-05-23 09:50:59','2022-05-24 09:50:59','398',749725.35,749725.35,'398','2022-05-23 23:42:53','797','2022-05-24 06:26:38',10,0),('5','90',257639,'Dally shift','2022-05-24','2022-05-24 11:50:12','2022-05-25 11:50:12','398',734032.20,734032.20,'398','2022-05-24 20:52:31','797','2022-05-25 07:29:25',10,0),('5','90',257640,'Dally shift','2022-05-25','2022-05-25 11:53:14','2022-05-26 11:53:14','398',628626.90,628626.90,'398','2022-05-25 21:53:29','797','2022-05-26 05:39:22',10,0),('5','90',257641,'Dally shift','2022-05-26','2022-05-26 06:57:18','2022-05-27 06:57:18','398',381483.30,381483.30,'398','2022-05-26 23:04:26','797','2022-05-27 05:52:05',10,0),('5','90',257642,'Dally shift','2022-05-27','2022-05-27 20:31:06','2022-05-28 20:31:06','398',0.00,0.00,'398','2022-05-27 20:31:31','797','2022-05-28 06:57:23',10,0),('5','90',257643,'Dally shift','2022-05-28','2022-05-28 06:59:52','2022-05-29 06:59:52','398',0.00,0.00,'398','2022-05-28 20:13:11','797','2022-05-29 09:41:07',10,0),('5','90',257644,'Dally shift','2022-05-29','2022-05-29 21:17:15','2022-05-30 21:17:15','398',0.00,0.00,'398','2022-05-29 21:17:48','797','2022-05-30 06:24:38',10,0),('5','90',257645,'Dally shift','2022-05-30','2022-05-30 08:19:34','2022-05-31 08:19:34','398',0.00,0.00,'398','2022-05-31 08:01:01','797','2022-05-31 10:05:30',10,0),('5','90',257646,'Dally shift','2022-05-31','2022-06-01 07:35:34','2022-06-02 07:35:34','398',0.00,0.00,'398','2022-06-01 07:35:57','797','2022-06-01 11:50:22',10,0),('5','90',257647,'Dally shift','2022-06-01','2022-06-01 22:11:35','2022-06-02 22:11:35','398',0.00,0.00,'398','2022-06-01 22:11:55','797','2022-06-02 05:39:16',10,0),('5','90',257648,'Dally shift ','2022-06-02','2022-06-02 08:06:03','2022-06-03 08:06:03','398',0.00,0.00,'398','2022-06-02 20:41:24','797','2022-06-03 05:45:48',10,0),('5','90',257649,'Dally shift','2022-06-03','2022-06-03 11:24:54','2022-06-04 11:24:54','398',0.00,0.00,'398','2022-06-03 19:17:44','797','2022-06-03 22:54:58',10,0),('5','90',257650,'Dally shift','2022-06-04','2022-06-04 21:50:13','2022-06-05 21:50:13','398',0.00,0.00,'398','2022-06-04 21:50:34','797','2022-06-05 08:08:50',10,0),('5','90',257651,'Dally shift','2022-06-05','2022-06-05 19:37:27','2022-06-06 19:37:27','398',0.00,0.00,'398','2022-06-05 19:39:08','797','2022-06-06 09:45:37',10,0),('5','90',257652,'Dally shift','2022-06-06','2022-06-07 13:26:59','2022-06-08 13:26:59','398',0.00,0.00,'398','2022-06-07 13:27:17','797','2022-06-07 13:28:35',10,0),('5','90',257653,'Dally shift','2022-06-07','2022-06-07 13:43:01','2022-06-08 13:43:01','398',0.00,0.00,'398','2022-06-07 20:05:49','797','2022-06-08 09:03:57',10,0),('5','90',257654,'Dally shift','2022-06-08','2022-06-08 13:20:23','2022-06-09 13:20:23','398',0.00,0.00,'398','2022-06-08 20:12:36','797','2022-06-08 23:02:29',10,0),('5','90',257655,'Dally shift','2022-06-09','2022-06-09 14:06:34','2022-06-10 14:06:34','398',0.00,0.00,'398','2022-06-09 21:28:24','797','2022-06-10 05:44:08',10,0),('5','90',257656,'Dally shift','2022-06-10','2022-06-10 10:15:53','2022-06-11 10:15:53','398',0.00,0.00,'398','2022-06-10 22:48:20','797','2022-06-11 05:50:25',10,0),('5','90',257657,'Dally shift ','2022-06-11','2022-06-11 23:19:08','2022-06-12 23:19:08','398',0.00,0.00,'398','2022-06-11 23:20:02','797','2022-06-12 12:33:07',10,0),('5','90',257658,'Dally shift','2022-06-12','2022-06-12 23:13:45','2022-06-13 23:13:45','398',0.00,0.00,'398','2022-06-12 23:14:24','797','2022-06-13 07:01:45',10,0),('5','90',257659,'Dally shift','2022-06-13','2022-06-13 09:05:41','2022-06-14 09:05:41','398',0.00,0.00,'398','2022-06-13 19:42:24','797','2022-06-14 06:47:34',10,0),('5','90',257660,'Dally shift','2022-06-14','2022-06-14 11:47:46','2022-06-15 11:47:46','398',0.00,0.00,'398','2022-06-14 23:22:17','797','2022-06-15 09:31:10',10,0),('5','90',257661,'Dally shift','2022-06-15','2022-06-15 18:52:26','2022-06-16 18:52:26','398',0.00,0.00,'398','2022-06-15 18:52:43','797','2022-06-16 06:56:01',10,0),('5','90',257662,'Dally shift','2022-06-16','2022-06-16 20:10:45','2022-06-17 20:10:45','398',0.00,0.00,'398','2022-06-16 20:11:00','797','2022-06-17 07:07:50',10,0),('5','90',257663,'Dally shift','2022-06-17','2022-06-17 13:01:32','2022-06-18 13:01:32','398',0.00,0.00,'398','2022-06-18 00:01:54','797','2022-06-18 07:30:04',10,0),('5','90',257664,'Dally shift','2022-06-18','2022-06-18 08:59:23','2022-06-19 08:59:23','398',0.00,0.00,'398','2022-06-18 23:10:48','797','2022-06-19 07:00:14',10,0),('5','90',257665,'Dally shift','2022-06-19','2022-06-19 10:52:26','2022-06-20 10:52:26','398',837340.35,837340.35,'398','2022-06-19 22:08:18','797','2022-06-20 06:05:22',10,0),('5','90',257666,'Dally shift','2022-06-20','2022-06-20 09:36:15','2022-06-21 09:36:15','398',937907.85,937907.85,'398','2022-06-20 19:46:17','797','2022-06-21 06:17:21',10,0),('5','90',257667,'Dally shift','2022-06-21','2022-06-21 13:45:13','2022-06-22 13:45:13','398',650014.20,650014.20,'398','2022-06-21 22:30:44','797','2022-06-23 05:33:41',10,0),('5','90',257668,'Dally shift','2022-06-22','2022-06-23 10:26:33','2022-06-24 10:26:33','398',675909.30,675909.30,'398','2022-06-23 10:27:59','797','2022-06-23 10:34:50',10,0),('5','90',257669,'Dally shift','2022-06-23','2022-06-23 10:37:43','2022-06-24 10:37:43','398',1180147.65,1180147.65,'398','2022-06-23 23:57:20','797','2022-06-24 07:01:47',10,0),('5','90',257670,'Dally shift','2022-06-24','2022-06-24 09:35:19','2022-06-25 09:35:19','398',354193.95,354193.95,'398','2022-06-24 23:55:54','797','2022-06-25 07:52:51',10,0),('5','90',257671,'Dally shift','2022-06-25','2022-06-25 23:12:51','2022-06-26 23:12:51','398',181358.10,181358.10,'398','2022-06-25 23:13:40','797','2022-06-26 08:59:53',10,0),('5','90',257672,'Dally shift','2022-06-26','2022-06-26 22:27:51','2022-06-27 22:27:51','398',0.00,0.00,'398','2022-06-26 22:28:07','797','2022-06-27 09:37:01',10,0),('5','90',257673,'Dally shift','2022-06-27','2022-06-27 14:45:05','2022-06-28 14:45:05','398',0.00,0.00,'398','2022-06-27 19:21:23','797','2022-06-28 09:36:49',10,0),('5','90',257674,'Dally shift','2022-06-28','2022-06-28 21:47:43','2022-06-29 21:47:43','398',0.00,0.00,'398','2022-06-28 21:47:59','797','2022-06-29 09:27:46',10,0),('5','90',257675,'Dally shift','2022-06-29','2022-06-29 10:20:14','2022-06-30 10:20:14','398',0.00,0.00,'398','2022-06-29 18:56:41','797','2022-06-30 07:16:00',10,0),('5','90',257676,'Dally shift','2022-06-30','2022-06-30 18:08:23','2022-07-01 18:08:23','398',0.00,0.00,'398','2022-06-30 18:08:38','797','2022-07-01 07:29:24',10,0),('5','90',257677,'Dally shift','2022-07-01','2022-07-01 07:37:53','2022-07-02 07:37:53','398',0.00,0.00,'398','2022-07-01 22:47:13','797','2022-07-02 09:04:53',10,0),('5','90',257678,'Dally shift','2022-07-02','2022-07-02 13:43:04','2022-07-03 13:43:04','398',0.00,0.00,'398','2022-07-03 09:18:16','797','2022-07-03 09:49:50',10,0),('5','90',257679,'Dally shift','2022-07-03','2022-07-03 19:36:13','2022-07-04 19:36:13','398',0.00,0.00,'398','2022-07-03 19:36:30','797','2022-07-04 06:58:48',10,0),('5','90',257680,'Dally shift','2022-07-04','2022-07-04 21:48:31','2022-07-05 21:48:31','398',0.00,0.00,'398','2022-07-04 21:48:48','797','2022-07-05 06:31:26',10,0),('5','90',257681,'Dally shift','2022-07-05','2022-07-05 17:46:33','2022-07-06 17:46:33','398',0.00,0.00,'398','2022-07-05 17:46:56','797','2022-07-06 06:26:15',10,0),('5','90',257682,'Dally shift','2022-07-06','2022-07-06 10:51:37','2022-07-07 10:51:37','398',0.00,0.00,'398','2022-07-06 22:39:23','797','2022-07-07 06:49:12',10,0),('5','90',257683,'Dally shift','2022-07-07','2022-07-07 13:05:06','2022-07-08 13:05:06','398',385349.25,385349.25,'398','2022-07-08 10:27:11','797','2022-07-08 10:29:01',10,0),('5','90',257684,'Dally shift','2022-07-08','2022-07-08 21:33:26','2022-07-09 21:33:26','398',532024.35,532024.35,'398','2022-07-08 21:35:02','797','2022-07-09 10:52:20',10,0),('5','90',257685,'Dally shift','2022-07-09','2022-07-09 13:45:35','2022-07-10 13:45:35','398',698809.65,698809.65,'398','2022-07-09 13:47:24','797','2022-07-09 13:49:27',10,0),('5','90',257686,'Dally shift','2022-07-09','2022-07-09 15:10:08','2022-07-10 15:10:08','398',533291.55,597932.95,'398','2022-07-09 23:30:37','797','2022-07-10 06:53:11',10,0),('5','90',257687,'Dally shift','2022-07-10','2022-07-10 22:32:07','2022-07-11 22:32:07','398',240068.40,269167.60,'398','2022-07-10 22:33:22','797','2022-07-11 07:38:37',10,0),('5','90',257688,'Dally shift ','2022-07-11','2022-07-11 11:01:43','2022-07-12 11:01:43','398',0.00,0.00,'398','2022-07-11 21:49:16','797','2022-07-12 08:40:20',10,0),('5','90',257689,'Dally shift','2022-07-12','2022-07-12 22:33:17','2022-07-13 22:33:17','398',0.00,0.00,'398','2022-07-12 22:33:43','797','2022-07-13 06:50:24',10,0),('5','90',257690,'Dally shift ','2022-07-13','2022-07-13 14:12:55','2022-07-14 14:12:55','398',0.00,0.00,'398','2022-07-13 23:32:01','797','2022-07-14 06:25:01',10,0),('5','90',257691,'Dally shift','2022-07-14','2022-07-14 14:03:40','2022-07-15 14:03:40','398',0.00,0.00,'398','2022-07-14 22:36:16','797','2022-07-15 06:39:12',10,0),('5','90',257692,'Dally shifted ','2022-07-15','2022-07-15 11:56:53','2022-07-16 11:56:53','398',831086.85,931824.65,'398','2022-07-16 07:58:19','797','2022-07-16 08:22:20',10,0),('5','90',257693,'Dally shift','2022-07-16','2022-07-16 21:31:22','2022-07-17 21:31:22','398',1026281.95,1026281.95,'398','2022-07-16 21:32:31','797','2022-07-17 06:03:49',10,0),('5','90',257694,'Dally shift','2022-07-17','2022-07-17 09:55:38','2022-07-18 09:55:38','398',1136514.20,1136514.20,'398','2022-07-17 22:24:25','797','2022-07-18 07:32:44',10,0),('5','90',257695,'Dally shift','2022-07-18','2022-07-18 11:57:17','2022-07-19 11:57:17','398',891059.90,891059.90,'398','2022-07-19 01:39:17','797','2022-07-19 05:49:41',10,0),('5','90',257696,'Dally shift','2022-07-19','2022-07-19 09:44:27','2022-07-20 09:44:27','398',1900070.25,1900070.25,'398','2022-07-19 22:06:12','797','2022-07-20 06:43:10',10,0),('5','90',257697,'Dally shift','2022-07-19','2022-07-20 22:04:41','2022-07-21 22:04:41','398',642580.85,642580.85,'398','2022-07-20 22:10:33','797','2022-07-21 07:43:50',10,0),('5','90',257698,'Dally shift','2022-07-21','2022-07-21 22:24:28','2022-07-22 22:24:28','398',1337120.80,1337120.80,'398','2022-07-21 22:25:56','797','2022-07-21 23:19:26',10,0),('5','90',257699,'Dally shift ','2022-07-22','2022-07-22 10:44:01','2022-07-23 10:44:01','398',913061.95,913061.95,'398','2022-07-22 20:20:17','797','2022-07-23 07:28:58',10,0),('5','90',257700,'Dally shift','2022-07-23','2022-07-23 16:29:16','2022-07-24 16:29:16','398',755743.50,755743.50,'398','2022-07-23 22:05:26','797','2022-07-24 06:56:01',10,0),('5','90',257701,'Dally shift','2022-07-24','2022-07-24 22:44:41','2022-07-25 22:44:41','398',969692.30,969692.30,'398','2022-07-24 22:45:50','797','2022-07-25 06:41:07',10,0),('5','90',257702,'Dally shift','2022-07-25','2022-07-25 18:21:38','2022-07-26 18:21:38','398',787363.70,787363.70,'398','2022-07-25 21:11:53','797','2022-07-26 07:40:28',10,0),('5','90',257703,'Dally shift','2022-07-26','2022-07-26 14:00:19','2022-07-27 14:00:19','398',140013.55,140013.55,'398','2022-07-26 22:39:42','797','2022-07-27 06:54:46',10,0),('5','90',257704,'Dally shift','2022-07-27','2022-07-27 10:14:44','2022-07-28 10:14:44','398',0.00,0.00,'398','2022-07-27 21:08:42','797','2022-07-28 08:08:14',10,0),('5','90',257705,'Dally shift','2022-07-28','2022-07-28 09:03:42','2022-07-29 09:03:42','398',0.00,0.00,'398','2022-07-28 22:16:34','797','2022-07-29 06:56:11',10,0),('5','90',257706,'Dally shift','2022-07-29','2022-07-29 11:46:23','2022-07-30 11:46:23','398',0.00,0.00,'398','2022-07-29 23:34:00','797','2022-07-30 06:59:22',10,0),('5','90',257707,'Dally shift','2022-07-30','2022-07-31 06:34:17','2022-08-01 06:34:17','398',0.00,0.00,'398','2022-07-31 06:34:40','797','2022-07-31 10:25:02',10,0),('5','90',257708,'Dally shift','2022-07-31','2022-07-31 21:22:50','2022-08-01 21:22:50','398',0.00,0.00,'398','2022-07-31 21:23:18','797','2022-08-01 06:48:06',10,0),('5','90',257709,'Dally shift','2022-08-01','2022-08-01 09:42:17','2022-08-02 09:42:17','398',0.00,0.00,'398','2022-08-01 22:47:52','797','2022-08-02 07:36:38',10,0),('5','90',257710,'Dally shift','2022-08-02','2022-08-02 10:12:50','2022-08-03 10:12:50','398',599605.35,599605.35,'398','2022-08-02 21:18:34','797','2022-08-03 06:36:00',10,0),('5','90',257711,'Dally shift','2022-08-03','2022-08-03 21:05:24','2022-08-04 21:05:24','398',558823.95,558823.95,'398','2022-08-03 21:18:23','797','2022-08-04 06:49:34',10,0),('5','90',257712,'Dally shift','2022-08-04','2022-08-04 21:08:52','2022-08-05 21:08:52','398',734599.85,734599.85,'398','2022-08-04 21:47:34','797','2022-08-05 06:36:47',10,0),('5','90',257713,'Dally shift','2022-08-05','2022-08-06 07:47:07','2022-08-07 07:47:07','398',545888.75,545888.75,'398','2022-08-06 07:48:31','797','2022-08-06 09:10:06',10,0),('5','90',257714,'Dally shift','2022-08-06','2022-08-06 22:01:13','2022-08-07 22:01:13','398',329932.70,329932.70,'398','2022-08-06 22:02:41','797','2022-08-07 07:11:49',10,0),('5','90',257715,'Dally shift','2022-08-07','2022-08-07 23:07:04','2022-08-08 23:07:04','398',0.00,0.00,'398','2022-08-07 23:07:33','797','2022-09-03 08:15:22',10,0),('5','90',257716,'Dally shift','2022-09-03','2022-09-03 10:41:01','2022-09-04 10:41:01','398',0.00,0.00,'600','2022-09-05 11:15:19','600','2022-09-05 11:15:33',10,0),('5','90',257717,'Dally shift','2022-08-07','2022-09-05 11:37:03','2022-09-06 11:37:03','398',0.00,0.00,'398','2022-09-05 11:37:41','797','2022-09-05 11:39:56',10,0),('5','90',257718,'Dally shift','2022-08-08','2022-09-05 11:41:13','2022-09-06 11:41:13','398',0.00,0.00,'398','2022-09-05 11:41:34','797','2022-09-05 11:43:11',10,0),('5','90',257719,'Dally shift','2022-08-09','2022-09-05 11:44:39','2022-09-06 11:44:39','398',0.00,0.00,'398','2022-09-05 11:45:00','797','2022-09-05 11:45:20',10,0),('5','90',257720,'Dally shift','2022-08-10','2022-09-05 11:46:34','2022-09-06 11:46:34','398',0.00,0.00,'398','2022-09-05 11:46:50','797','2022-09-05 11:47:40',10,0),('5','90',257721,'Dally shift','2022-08-11','2022-09-05 11:49:19','2022-09-06 11:49:19','398',770907.95,770907.95,'398','2022-09-05 12:41:17','797','2022-09-05 12:51:33',10,0),('5','90',257722,'Dally shift','2022-08-12','2022-09-05 13:35:58','2022-09-06 13:35:58','398',755684.30,755684.30,'398','2022-09-05 13:37:28','797','2022-09-05 13:39:15',10,0),('5','90',257723,'Dally shift','2022-08-13','2022-09-05 13:41:16','2022-09-06 13:41:16','398',452789.35,452789.35,'398','2022-09-05 13:42:16','797','2022-09-05 13:43:28',10,0),('5','90',257724,'Dally shift','2022-08-14','2022-09-05 13:45:03','2022-09-06 13:45:03','398',391924.35,391924.35,'398','2022-09-05 13:46:03','797','2022-09-05 13:47:06',10,0),('5','90',257725,'Dally shift','2022-08-15','2022-09-05 13:48:29','2022-09-06 13:48:29','398',404733.75,404733.75,'398','2022-09-05 13:49:17','797','2022-09-05 13:49:59',10,0),('5','90',257726,'Dally shift','2022-08-16','2022-09-05 13:56:47','2022-09-06 13:56:47','398',302597.10,302597.10,'398','2022-09-05 14:46:07','797','2022-09-05 14:47:40',10,0),('5','90',257727,'Dally shift','2022-08-17','2022-09-05 14:48:32','2022-09-06 14:48:32','398',444900.95,444900.95,'398','2022-09-05 14:49:33','797','2022-09-05 14:51:31',10,0),('5','90',257728,'Dally shift','2022-08-18','2022-09-05 14:53:04','2022-09-06 14:53:04','398',1153998.55,1153998.55,'398','2022-09-05 14:54:12','797','2022-09-05 14:57:01',10,0),('5','90',257729,'Dally shift','2022-08-19','2022-09-05 15:29:54','2022-09-06 15:29:54','398',531728.85,531728.85,'398','2022-09-05 15:30:46','797','2022-09-05 15:32:31',10,0),('5','90',257730,'Dally shift','2022-08-20','2022-09-05 15:37:36','2022-09-06 15:37:36','398',600226.95,600226.95,'398','2022-09-05 15:38:32','797','2022-09-05 15:39:04',10,0),('5','90',257731,'Dally shift','2022-08-21','2022-09-05 15:40:56','2022-09-06 15:40:56','398',566803.00,566803.00,'398','2022-09-05 15:41:56','797','2022-09-05 15:42:26',10,0),('5','90',257732,'Dally shift','2022-08-22','2022-09-06 10:31:49','2022-09-07 10:31:49','398',805769.35,805769.35,'398','2022-09-06 10:35:14','797','2022-09-06 10:39:06',10,0),('5','90',257733,'Dally shift','2022-08-23','2022-09-06 10:45:58','2022-09-07 10:45:58','398',813792.80,813792.80,'398','2022-09-06 10:48:15','797','2022-09-06 10:56:41',10,0),('5','90',257734,'Dally shift','2022-08-24','2022-09-06 11:08:44','2022-09-07 11:08:44','398',901342.20,901342.20,'398','2022-09-06 11:09:49','797','2022-09-06 11:13:00',10,0),('5','90',257735,'Dally shift','2022-08-25','2022-09-06 11:20:18','2022-09-07 11:20:18','398',1282717.85,1282717.85,'398','2022-09-06 11:23:06','797','2022-09-06 11:26:18',10,0),('5','90',257736,'Dally shift','2022-08-26','2022-09-06 11:30:26','2022-09-07 11:30:26','398',657826.70,657826.70,'398','2022-09-06 11:31:54','797','2022-09-06 11:33:24',10,0),('5','90',257737,'Dally shift','2022-08-27','2022-09-06 11:34:50','2022-09-07 11:34:50','398',783606.35,783606.35,'398','2022-09-06 11:35:46','797','2022-09-06 11:36:52',10,0),('5','90',257738,'Dally shift','2022-08-28','2022-09-06 11:38:05','2022-09-07 11:38:05','398',526500.75,526500.75,'398','2022-09-06 11:39:46','797','2022-09-06 11:42:31',10,0),('5','90',257739,'Dally shift','2022-08-29','2022-09-06 11:43:37','2022-09-07 11:43:37','398',0.00,0.00,'398','2022-09-06 11:43:55','797','2022-09-06 11:45:24',10,0),('5','90',257740,'Dally shift','2022-08-30','2022-09-06 12:05:55','2022-09-07 12:05:55','398',436237.40,436237.40,'398','2022-09-06 12:06:47','797','2022-09-06 12:09:19',10,0),('5','90',257741,'Dally shift','2022-08-31','2022-09-06 12:14:15','2022-09-07 12:14:15','398',673226.10,673226.10,'398','2022-09-06 12:14:59','797','2022-09-06 12:16:36',10,0),('5','90',257742,'Dally shiftl','2022-09-01','2022-09-06 12:37:44','2022-09-07 12:37:44','398',1148320.90,1148320.90,'398','2022-09-06 12:46:55','797','2022-09-06 13:07:14',10,0),('5','90',257743,'Dally shift','2022-09-02','2022-09-06 13:29:28','2022-09-07 13:29:28','398',661356.50,661356.50,'398','2022-09-06 13:30:39','797','2022-09-06 13:31:56',10,0),('5','90',257744,'Dally shift','2022-09-03','2022-09-06 13:32:43','2022-09-07 13:32:43','398',581985.95,581985.95,'398','2022-09-06 13:33:48','797','2022-09-06 13:35:41',10,0),('5','90',257745,'Dally shift','2022-09-04','2022-09-06 13:36:41','2022-09-07 13:36:41','398',636089.20,636089.20,'398','2022-09-06 13:38:00','797','2022-09-06 13:38:47',10,0),('5','90',257746,'Dally shift','2022-09-05','2022-09-06 13:40:24','2022-09-07 13:40:24','398',720249.40,720249.40,'398','2022-09-06 13:41:53','797','2022-09-06 13:43:59',10,0),('5','90',257747,'Dally shift','2022-09-06','2022-09-06 13:46:20','2022-09-07 13:46:20','398',651163.00,651163.00,'398','2022-09-06 23:23:01','797','2022-09-07 09:40:54',10,0),('5','90',257748,'Dally shift','2022-09-07','2022-09-07 11:54:20','2022-09-08 11:54:20','398',668808.30,668808.30,'398','2022-09-07 19:16:03','797','2022-09-08 09:02:33',10,0),('5','90',257749,'Dally shift','2022-09-08','2022-09-08 23:05:21','2022-09-09 23:05:21','398',1581250.50,1581250.50,'398','2022-09-08 23:06:56','797','2022-09-09 07:14:48',10,0),('5','90',257750,'Dally shift','2022-09-09','2022-09-09 21:26:48','2022-09-10 21:26:48','398',696956.05,696956.05,'398','2022-09-09 21:27:58','797','2022-09-10 10:16:44',10,0),('5','90',257754,'Dally shift','2022-09-10','2022-09-10 22:49:34','2022-09-11 22:49:34','398',582809.20,582809.20,'398','2022-09-10 22:50:39','797','2022-09-11 11:03:53',10,0),('5','90',257755,'Dally shift','2022-09-12','2022-09-12 01:43:33','2022-09-13 01:43:33','398',0.00,0.00,'398','2022-09-12 15:08:36','797','2022-09-12 15:10:23',10,0),('5','90',257756,'Dally shift','2022-09-11','2022-09-12 15:18:06','2022-09-13 15:18:06','398',761171.40,761171.40,'398','2022-09-12 15:19:06','797','2022-09-12 15:20:09',10,0),('5','90',257757,'Dally shift','2022-09-12','2022-09-12 21:13:29','2022-09-13 21:13:29','398',877863.85,877863.85,'398','2022-09-13 11:40:56','797','2022-09-13 11:42:52',10,0),('5','90',257758,'Dally shift','2022-09-13','2022-09-13 21:04:29','2022-09-14 21:04:29','398',760355.55,760355.55,'398','2022-09-13 21:05:50','797','2022-09-14 09:15:42',10,0),('5','90',257759,'Dally shift','2022-09-14','2022-09-14 14:13:24','2022-09-15 14:13:24','398',931580.45,931580.45,'398','2022-09-14 23:02:38','797','2022-09-15 10:05:28',10,0),('5','90',257760,'Dally shift','2022-09-15','2022-09-15 23:37:45','2022-09-16 23:37:45','398',1598967.95,1598967.95,'398','2022-09-16 10:48:10','797','2022-09-16 11:01:48',10,0),('5','90',257761,'Dally shift','2022-09-16','2022-09-16 22:08:27','2022-09-17 22:08:27','398',767483.60,767483.60,'398','2022-09-16 22:09:51','797','2022-09-17 07:55:07',10,0),('5','90',257762,'Dally shift','2022-09-17','2022-09-17 22:33:54','2022-09-18 22:33:54','398',634272.50,634272.50,'398','2022-09-17 22:35:01','797','2022-09-18 10:36:13',10,0),('5','90',257763,'Dally shift','2022-09-18','2022-09-18 23:55:23','2022-09-19 23:55:23','398',716906.45,716906.45,'398','2022-09-18 23:56:39','797','2022-09-19 10:42:54',10,0),('5','90',257764,'Dally shift','2022-09-19','2022-09-19 15:43:28','2022-09-20 15:43:28','398',759234.45,759234.45,'398','2022-09-20 05:54:12','797','2022-09-20 08:58:58',10,0),('5','90',257765,'Dally shift','2022-09-20','2022-09-20 11:51:53','2022-09-21 11:51:53','398',829577.00,829577.00,'398','2022-09-20 23:04:33','797','2022-09-21 07:07:19',10,0),('5','90',257766,'Dally shift ','2022-09-21','2022-09-21 11:54:04','2022-09-22 11:54:04','398',847046.55,847046.55,'398','2022-09-21 21:03:59','797','2022-09-22 09:14:44',10,0),('5','90',257767,'Dally shift','2022-09-22','2022-09-22 11:19:55','2022-09-23 11:19:55','398',1694799.80,1694799.80,'398','2022-09-22 20:29:20','797','2022-09-23 10:18:09',10,0),('5','90',257768,'Dally shift','2022-09-23','2022-09-23 23:08:39','2022-09-24 23:08:39','398',695490.85,695490.85,'398','2022-09-26 10:26:56','797','2022-09-26 10:29:46',10,0),('5','90',257769,'Dally shift','2022-09-04','2022-09-26 10:33:49','2022-09-27 10:33:49','398',687628.35,687628.35,'398','2022-09-26 10:35:50','797','2022-09-26 10:38:46',10,0),('5','90',257770,'Dally shift','2022-09-25','2022-09-26 10:42:11','2022-09-27 10:42:11','398',754553.95,754553.95,'398','2022-09-26 10:44:13','797','2022-09-26 10:45:48',10,0),('5','90',257771,'Dally shift','2022-09-26','2022-09-27 05:58:12','2022-09-28 05:58:12','398',804087.70,804087.70,'398','2022-09-27 06:00:30','797','2022-09-27 08:08:30',10,0),('5','90',257772,'Dally shift','2022-09-27','2022-09-27 20:42:00','2022-09-28 20:42:00','398',805745.30,805745.30,'398','2022-09-27 20:43:13','797','2022-09-28 06:39:33',10,0),('5','90',257773,'Dally shift','2022-09-28','2022-09-28 21:30:40','2022-09-29 21:30:40','398',838033.35,838033.35,'398','2022-09-28 21:32:03','797','2022-09-29 07:11:35',10,0),('5','90',257774,'Dally shift','2022-09-29','2022-09-30 04:11:53','2022-10-01 04:11:53','398',1765984.10,1765984.10,'398','2022-09-30 04:13:39','797','2022-09-30 07:21:46',10,0),('5','90',257775,'Dally shift ','2022-09-30','2022-09-30 11:21:37','2022-10-01 11:21:37','398',758357.55,758357.55,'398','2022-09-30 22:41:42','797','2022-10-01 07:30:02',10,0),('5','90',257776,'Dally shift','2022-10-01','2022-10-01 23:36:16','2022-10-02 23:36:16','398',852239.50,852239.50,'398','2022-10-01 23:37:36','797','2022-10-02 06:56:29',10,0),('5','90',257779,'Dally shift','2022-10-02','2022-10-03 03:58:58','2022-10-04 03:58:58','398',809698.75,809698.75,'398','2022-10-03 04:00:02','797','2022-10-03 09:44:58',10,0),('5','90',257780,'Dally shift','2022-10-03','2022-10-03 23:31:53','2022-10-04 23:31:53','398',1094245.40,1094245.40,'398','2022-10-03 23:33:00','797','2022-10-04 07:11:29',10,0),('5','90',257781,'Dally shift','2022-10-04','2022-10-04 23:35:06','2022-10-05 23:35:06','398',1073453.25,1073453.25,'398','2022-10-04 23:36:16','797','2022-10-05 10:03:42',10,0),('5','90',257782,'Dally shift','2022-10-05','2022-10-05 21:41:47','2022-10-06 21:41:47','398',1012133.15,1012133.15,'398','2022-10-05 21:43:03','797','2022-10-06 06:56:36',10,0),('5','90',257783,'Dally shift','2022-10-06','2022-10-06 22:53:47','2022-10-07 22:53:47','398',2182894.55,2182894.55,'398','2022-10-07 08:50:53','797','2022-10-07 10:51:06',10,0),('5','90',257784,'Dally shift','2022-10-07','2022-10-07 22:44:59','2022-10-08 22:44:59','398',887659.60,887659.60,'398','2022-10-07 22:56:11','797','2022-10-08 11:34:13',10,0),('5','90',257785,'Dally shift','2022-10-08','2022-10-08 23:13:39','2022-10-09 23:13:39','398',1356671.60,1356671.60,'398','2022-10-09 09:13:27','797','2022-10-10 08:56:52',10,0),('5','90',257786,'Dally shift','2022-10-10','2022-10-10 13:30:23','2022-10-11 13:30:23','398',1121460.75,1121460.75,'398','2022-10-10 13:34:21','797','2022-10-11 12:13:25',10,0),('5','90',257787,'Dally shift','2022-10-10','2022-10-11 14:23:47','2022-10-12 14:23:47','398',1076814.70,1076814.70,'398','2022-10-11 14:25:33','797','2022-10-12 12:29:17',10,0),('5','90',257788,'Dally shift','2022-10-12','2022-10-12 23:44:07','2022-10-13 23:44:07','398',1619950.65,1619950.65,'398','2022-10-12 23:56:09','797','2022-10-13 04:21:56',10,0),('5','90',257789,'Dally shift','2022-10-12','2022-10-14 11:49:09','2022-10-15 11:49:09','398',1281637.45,1281637.45,'398','2022-10-16 14:22:46','797','2022-10-16 14:27:35',10,0),('5','90',257790,'Dally shift','2022-10-13','2022-10-16 14:30:32','2022-10-17 14:30:32','398',796001.35,796001.35,'398','2022-10-16 14:31:51','797','2022-10-16 14:36:46',10,0),('5','90',257791,'Dally shift','2022-10-14','2022-10-16 14:46:18','2022-10-17 14:46:18','398',0.00,0.00,'398','2022-10-16 14:47:08','797','2022-10-16 14:50:22',10,0),('5','90',257792,'Dally shift4','2022-10-15','2022-10-16 14:52:41','2022-10-17 14:52:41','398',0.00,0.00,'398','2022-10-16 14:52:59','797','2022-10-16 15:00:14',10,0),('5','90',257793,'Dally shift','2022-10-16','2022-10-16 15:04:51','2022-10-17 15:04:51','398',0.00,0.00,'398','2022-10-17 06:11:53','797','2022-10-17 20:06:07',10,0),('5','90',257794,'Dally shift','2022-10-17','2022-10-18 07:01:34','2022-10-19 07:01:34','398',0.00,0.00,'398','2022-10-18 07:01:54','797','2022-10-18 09:34:16',10,0),('5','90',257795,'Dally shift','2022-10-18','2022-10-18 14:24:24','2022-10-19 14:24:24','398',0.00,0.00,'398','2022-10-18 21:26:56','797','2022-10-19 09:41:42',10,0),('5','90',257796,'Dally shift','2022-10-19','2022-10-19 22:56:06','2022-10-20 22:56:06','398',0.00,0.00,'398','2022-10-19 22:56:29','797','2022-10-20 09:00:11',10,0),('5','90',257797,'Dally shift','2022-10-20','2022-10-21 06:06:58','2022-10-22 06:06:58','398',0.00,0.00,'398','2022-10-21 06:07:24','797','2022-10-21 09:31:24',10,0),('5','90',257798,'Dally shift','2022-10-21','2022-10-21 22:11:29','2022-10-22 22:11:29','398',0.00,0.00,'398','2022-10-21 22:12:03','797','2022-10-22 10:03:45',10,0),('5','90',257801,'Dally shift','2022-10-22','2022-10-23 00:12:43','2022-10-24 00:12:43','398',0.00,0.00,'398','2022-10-23 00:13:09','797','2022-10-23 07:39:19',10,0),('5','90',257802,'Dally shift','2022-10-23','2022-10-24 00:15:10','2022-10-25 00:15:10','398',0.00,0.00,'398','2022-10-24 00:15:38','797','2022-10-24 07:30:43',10,0),('5','90',257803,'Dally shift','2022-10-24','2022-10-24 22:03:30','2022-10-25 22:03:30','398',0.00,0.00,'398','2022-10-24 22:04:11','797','2022-10-25 09:22:53',10,0),('5','90',257804,'Dally shift','2022-10-25','2022-10-25 18:04:55','2022-10-26 18:04:55','398',0.00,0.00,'398','2022-10-25 18:05:12','797','2022-10-25 22:56:18',10,0),('5','90',257805,'Dally shift','2022-10-26','2022-10-27 00:57:27','2022-10-28 00:57:27','398',0.00,0.00,'398','2022-10-27 00:57:43','797','2022-10-27 07:01:02',10,0),('5','90',257806,'Dally shift','2022-10-27','2022-10-27 23:39:02','2022-10-28 23:39:02','398',0.00,0.00,'398','2022-10-27 23:39:25','797','2022-10-28 06:53:41',10,0),('5','90',257807,'Dally shift','2022-10-28','2022-10-29 05:11:13','2022-10-30 05:11:13','398',472010.85,472010.85,'398','2022-10-29 13:59:49','797','2022-10-29 16:02:17',10,0),('5','90',257808,'Dally shift','2022-10-29','2022-10-30 04:16:01','2022-10-31 04:16:01','398',2617696.35,2617696.35,'398','2022-10-30 04:18:26','797','2022-10-30 06:51:32',10,0),('5','90',257809,'Dally shift','2022-10-30','2022-10-31 05:24:14','2022-11-01 05:24:14','398',1993539.65,1993539.65,'398','2022-10-31 05:25:46','797','2022-10-31 07:00:34',10,0),('5','90',257810,'Dally shift','2022-10-31','2022-10-31 23:38:37','2022-11-01 23:38:37','398',1907546.10,1907546.10,'398','2022-10-31 23:40:39','797','2022-11-01 06:57:03',10,0),('5','90',257811,'Dally shift','2022-11-01','2022-11-01 23:05:09','2022-11-02 23:05:09','398',4408209.60,4408209.60,'398','2022-11-02 08:23:44','797','2022-11-02 11:46:22',10,0),('5','90',257812,'Dally shift','2022-11-02','2022-11-03 02:05:11','2022-11-04 02:05:11','398',1984189.75,1984189.75,'398','2022-11-03 02:06:52','797','2022-11-03 06:32:27',10,0),('5','90',257813,'Dally shift','2022-11-03','2022-11-04 05:07:58','2022-11-05 05:07:58','398',2144346.10,2144346.10,'398','2022-11-04 05:09:29','797','2022-11-04 07:01:23',10,0),('5','90',257814,'Dally shift','2022-11-04','2022-11-05 06:24:37','2022-11-06 06:24:37','398',1486140.15,1486140.15,'398','2022-11-05 06:25:25','797','2022-11-05 07:23:58',10,0),('5','90',257815,'Dally shift ','2022-11-05','2022-11-06 03:17:51','2022-11-07 03:17:51','398',1617634.45,1442755.05,'398','2022-11-06 04:55:06','797','2022-11-06 08:14:27',10,0),('5','90',257816,'Dally shift','2022-11-06','2022-11-06 22:44:30','2022-11-07 22:44:30','398',1719652.70,1719652.70,'398','2022-11-06 22:47:32','797','2022-11-07 14:43:11',10,0),('5','90',257817,'Dally shift56','2022-11-07','2022-11-08 04:41:08','2022-11-09 04:41:08','398',2611528.45,2611528.45,'398','2022-11-08 04:43:40','797','2022-11-08 07:41:59',10,0),('5','90',257818,'Dally shift','2022-11-08','2022-11-08 22:53:05','2022-11-09 22:53:05','398',2609506.40,2609506.40,'398','2022-11-08 22:55:06','797','2022-11-09 08:35:21',10,0),('5','90',257819,'Dally shift','2022-11-09','2022-11-09 22:00:51','2022-11-10 22:00:51','398',474247.50,474247.50,'398','2022-11-10 07:47:59','797','2022-11-10 10:42:14',10,0),('5','90',257820,'Dally shift','2022-11-10','2022-11-10 21:38:40','2022-11-11 21:38:40','398',0.00,0.00,'398','2022-11-10 21:39:01','797','2022-11-11 11:26:20',10,0),('5','90',257821,'Dally shift','2022-11-11','2022-11-11 18:45:39','2022-11-12 18:45:39','398',0.00,0.00,'398','2022-11-11 18:46:05','797','2022-11-12 10:01:03',10,0),('5','90',257822,'Dally shift','2022-11-12','2022-11-12 22:37:46','2022-11-13 22:37:46','398',0.00,0.00,'398','2022-11-12 22:38:10','797','2022-11-12 23:49:43',10,0),('5','90',257823,'Dally shift','2022-11-13','2022-11-13 21:16:31','2022-11-14 21:16:31','398',0.00,0.00,'398','2022-11-13 21:16:54','797','2022-11-14 07:21:36',10,0),('5','90',257824,'Dally shift','2022-11-14','2022-11-14 21:19:40','2022-11-15 21:19:40','398',0.00,0.00,'398','2022-11-14 21:19:59','797','2022-11-14 23:42:23',10,0),('5','90',257825,'Dally shift','2022-11-15','2022-11-15 21:13:30','2022-11-16 21:13:30','398',0.00,0.00,'398','2022-11-15 21:14:00','797','2022-11-16 07:51:17',10,0),('5','90',257826,'Dally shift','2022-11-16','2022-11-17 07:39:21','2022-11-18 07:39:21','398',0.00,0.00,'398','2022-11-17 07:40:05','797','2022-11-17 09:35:37',10,0),('5','90',257827,'Dally shift','2022-11-17','2022-11-17 21:49:39','2022-11-18 21:49:39','398',0.00,0.00,'398','2022-11-17 21:50:00','797','2022-11-18 08:18:39',10,0),('5','90',257828,'Dally shift','2022-11-18','2022-11-18 22:05:54','2022-11-19 22:05:54','398',0.00,0.00,'398','2022-11-18 22:06:25','797','2022-11-19 09:15:12',10,0),('5','90',257829,'Dally shift','2022-11-19','2022-11-19 21:14:37','2022-11-20 21:14:37','398',0.00,0.00,'398','2022-11-19 21:14:55','797','2022-11-20 07:25:05',10,0),('5','90',257830,'Dally shift','2022-11-20','2022-11-20 20:25:41','2022-11-21 20:25:41','398',0.00,0.00,'398','2022-11-20 20:25:58','797','2022-11-21 09:34:57',10,0),('5','90',257831,'Dally shift','2022-11-21','2022-11-21 19:03:41','2022-11-22 19:03:41','398',0.00,0.00,'398','2022-11-21 19:04:00','797','2022-11-22 09:01:52',10,0),('5','90',257832,'Dally shift','2022-11-22','2022-11-22 23:39:22','2022-11-23 23:39:22','398',0.00,0.00,'398','2022-11-22 23:39:37','797','2022-11-23 09:37:40',10,0),('5','90',257833,'Dally shift','2022-11-23','2022-11-23 21:23:08','2022-11-24 21:23:08','398',0.00,0.00,'398','2022-11-23 21:23:46','797','2022-11-24 08:56:19',10,0),('5','90',257834,'Dally shift','2022-11-24','2022-11-24 21:04:05','2022-11-25 21:04:05','398',0.00,0.00,'398','2022-11-24 21:19:56','797','2022-11-25 11:12:18',10,0),('5','90',257835,'Dally shift','2022-11-25','2022-11-25 21:05:54','2022-11-26 21:05:54','398',0.00,0.00,'398','2022-11-25 21:06:18','797','2022-11-26 07:43:38',10,0),('5','90',257836,'Dally shift','2022-11-26','2022-11-26 22:22:54','2022-11-27 22:22:54','398',0.00,0.00,'398','2022-11-26 22:23:14','797','2022-11-27 08:58:05',10,0),('5','90',257837,'Dally shift','2022-11-27','2022-11-27 20:56:29','2022-11-28 20:56:29','398',0.00,0.00,'398','2022-11-27 20:56:54','797','2022-11-28 09:46:02',10,0),('5','90',257838,'Dally shift','2022-11-28','2022-11-28 22:00:31','2022-11-29 22:00:31','398',0.00,0.00,'398','2022-11-28 22:00:52','797','2022-11-29 09:43:36',10,0),('5','90',257839,'Dally shift','2022-11-29','2022-11-29 21:06:19','2022-11-30 21:06:19','398',0.00,0.00,'398','2022-11-29 21:06:43','797','2022-11-30 06:42:03',10,0),('5','90',257840,'Dally shift','2022-11-30','2022-11-30 15:37:09','2022-12-01 15:37:09','398',0.00,0.00,'398','2022-11-30 15:37:39','797','2022-12-01 10:42:35',10,0),('5','90',257841,'Dally shift','2022-12-01','2022-12-01 21:37:43','2022-12-02 21:37:43','398',0.00,0.00,'398','2022-12-01 21:38:06','797','2022-12-02 09:57:38',10,0),('5','90',257842,'Dally shift','2022-12-02','2022-12-02 21:16:13','2022-12-03 21:16:13','398',0.00,0.00,'398','2022-12-02 21:16:52','797','2022-12-03 10:10:08',10,0),('5','90',257843,'Dally shift','2022-12-03','2022-12-04 06:55:49','2022-12-05 06:55:49','398',0.00,0.00,'398','2022-12-04 06:56:21','797','2022-12-04 09:46:28',10,0),('5','90',257844,'Dally shift','2022-12-04','2022-12-05 10:24:17','2022-12-06 10:24:17','398',0.00,0.00,'398','2022-12-05 10:24:33','797','2022-12-05 10:37:59',10,0),('5','90',257845,'Dally shift','2022-12-05','2022-12-05 22:05:46','2022-12-06 22:05:46','398',0.00,0.00,'398','2022-12-05 22:06:15','797','2022-12-06 09:21:15',10,0),('5','90',257846,'Dally shift','2022-12-06','2022-12-07 09:23:21','2022-12-08 09:23:21','398',0.00,0.00,'398','2022-12-07 09:23:43','797','2022-12-07 10:34:27',10,0),('5','90',257847,'Dally shift','2022-12-07','2022-12-08 04:33:54','2022-12-09 04:33:54','398',0.00,0.00,'398','2022-12-08 04:34:34','797','2022-12-08 09:24:57',10,0),('5','90',257848,'Dally shift','2022-12-08','2022-12-08 21:36:28','2022-12-09 21:36:28','398',0.00,0.00,'398','2022-12-08 21:36:50','797','2022-12-09 09:14:49',10,0),('5','90',257849,'Dally shift','2022-12-09','2022-12-10 07:21:21','2022-12-11 07:21:21','398',0.00,0.00,'398','2022-12-10 07:21:44','797','2022-12-10 08:50:40',10,0),('5','90',257850,'Dally shift','2022-12-10','2022-12-10 19:05:05','2022-12-11 19:05:05','398',0.00,0.00,'398','2022-12-10 19:05:24','797','2022-12-11 12:25:10',10,0),('5','90',257851,'Dally shift','2022-12-11','2022-12-11 22:50:59','2022-12-12 22:50:59','398',0.00,0.00,'398','2022-12-11 22:51:26','797','2022-12-12 11:05:03',10,0),('5','90',257852,'Dally shift','2022-12-12','2022-12-13 06:10:59','2022-12-14 06:10:59','398',0.00,0.00,'398','2022-12-13 06:11:24','797','2022-12-13 09:51:16',10,0),('5','90',257853,'Dally shift','2022-12-13','2022-12-13 21:42:32','2022-12-14 21:42:32','398',0.00,0.00,'398','2022-12-13 21:43:00','797','2022-12-14 09:37:24',10,0),('5','90',257854,'Dally shift','2022-12-14','2022-12-15 09:49:26','2022-12-16 09:49:26','398',0.00,0.00,'398','2022-12-15 09:49:58','797','2022-12-15 09:52:36',10,0),('5','90',257855,'Dally shift','2022-12-15','2022-12-15 22:31:21','2022-12-16 22:31:21','398',0.00,0.00,'398','2022-12-15 22:31:42','797','2022-12-16 09:58:23',10,0),('5','90',257856,'Dally shift','2022-12-16','2022-12-16 21:29:14','2022-12-17 21:29:14','398',0.00,0.00,'398','2022-12-16 21:29:34','797','2022-12-17 12:14:15',10,0),('5','90',257857,'Dally shift','2022-12-17','2022-12-17 21:43:30','2022-12-18 21:43:30','398',0.00,0.00,'398','2022-12-17 21:43:51','797','2022-12-18 12:30:58',10,0),('5','90',257858,'Dally shift','2022-12-18','2022-12-18 21:18:30','2022-12-19 21:18:30','398',0.00,0.00,'398','2022-12-18 21:19:02','797','2022-12-19 08:54:50',10,0),('5','90',257859,'Dally shift','2022-12-19','2022-12-19 21:55:09','2022-12-20 21:55:09','398',0.00,0.00,'398','2022-12-19 21:55:32','797','2022-12-20 09:00:04',10,0),('5','90',257860,'Dally shift','2022-12-20','2022-12-21 05:58:59','2022-12-22 05:58:59','398',0.00,0.00,'398','2022-12-21 05:59:30','797','2022-12-21 09:17:05',10,0),('5','90',257861,'Dally shift','2022-12-21','2022-12-21 21:25:30','2022-12-22 21:25:30','398',0.00,0.00,'398','2022-12-21 21:25:51','797','2022-12-22 09:26:40',10,0),('5','90',257862,'Dally shift','2022-12-22','2022-12-23 05:56:15','2022-12-24 05:56:15','398',0.00,0.00,'398','2022-12-23 05:56:41','797','2022-12-23 10:44:49',10,0),('5','90',257863,'Dally shift','2022-12-23','2022-12-23 21:50:20','2022-12-24 21:50:20','398',0.00,0.00,'398','2022-12-23 21:50:45','797','2022-12-24 19:14:19',10,0),('5','90',257864,'Dally shift','2022-12-25','2022-12-25 08:04:53','2022-12-26 08:04:53','398',0.00,0.00,'398','2022-12-25 08:05:15','797','2022-12-25 11:27:01',10,0),('5','90',257865,'Dally shift','2022-12-25','2022-12-26 08:49:06','2022-12-27 08:49:06','398',0.00,0.00,'398','2022-12-26 08:49:33','797','2022-12-27 09:02:45',10,0),('5','90',257866,'Dally shift','2022-12-26','2022-12-27 15:02:47','2022-12-28 15:02:47','398',0.00,0.00,'398','2022-12-27 15:06:10','797','2022-12-27 15:42:26',10,0),('5','90',257867,'Dally shift','2022-12-27','2022-12-27 22:31:11','2022-12-28 22:31:11','398',0.00,0.00,'398','2022-12-27 22:31:46','797','2022-12-28 09:12:49',10,0),('5','90',257868,'Dally shift','2022-12-28','2022-12-28 22:58:39','2022-12-29 22:58:39','398',0.00,0.00,'398','2022-12-28 22:58:57','797','2022-12-29 10:16:26',10,0),('5','90',257869,'Dally shift','2022-12-29','2022-12-30 09:21:34','2022-12-31 09:21:34','398',0.00,0.00,'398','2022-12-30 09:21:51','797','2022-12-30 10:03:53',10,0),('5','90',257870,'Dally shift','2022-12-30','2022-12-30 20:31:07','2022-12-31 20:31:07','398',0.00,0.00,'398','2022-12-30 20:31:29','797','2022-12-31 07:05:14',10,0),('5','90',257871,'Dally shift','2022-12-31','2022-12-31 23:22:54','2023-01-01 23:22:54','398',0.00,0.00,'398','2022-12-31 23:23:23','797','2023-01-01 08:51:19',10,0),('5','90',257872,'Dally shift','2023-01-01','2023-01-01 18:30:15','2023-01-02 18:30:15','398',0.00,0.00,'398','2023-01-01 18:31:05','797','2023-01-02 08:19:47',10,0),('5','90',257873,'Dally shift','2023-01-02','2023-01-02 21:41:38','2023-01-03 21:41:38','398',0.00,0.00,'398','2023-01-02 21:42:12','797','2023-01-03 10:32:49',10,0),('5','90',257874,'Dally shift','2023-01-03','2023-01-03 18:46:10','2023-01-04 18:46:10','398',0.00,0.00,'398','2023-01-03 18:46:26','797','2023-01-04 11:23:14',10,0),('5','90',257875,'Dally shift','2023-01-04','2023-01-04 22:30:33','2023-01-05 22:30:33','398',0.00,0.00,'398','2023-01-04 22:30:58','797','2023-01-05 08:55:45',10,0),('5','90',257876,'Dally shift','2023-01-05','2023-01-06 19:05:20','2023-01-07 19:05:20','398',0.00,0.00,'398','2023-01-06 19:05:51','797','2023-01-07 05:47:55',10,0),('5','90',257877,'Dally shift','2023-01-07','2023-01-07 14:28:25','2023-01-08 14:28:25','398',0.00,0.00,'398','2023-01-07 14:29:09','797','2023-01-07 17:09:12',10,0),('5','90',257878,'Dally shift','2023-01-08','2023-01-08 20:03:10','2023-01-09 20:03:10','398',0.00,0.00,'398','2023-01-08 20:04:23','797','2023-01-09 09:45:38',10,0),('5','90',257879,'Dally shift','2023-01-09','2023-01-10 06:31:01','2023-01-11 06:31:01','398',0.00,0.00,'398','2023-01-10 06:32:02','797','2023-01-10 09:19:01',10,0),('5','90',257880,'Dally shift','2023-01-10','2023-01-11 06:13:07','2023-01-12 06:13:07','398',0.00,0.00,'398','2023-01-11 06:13:28','797','2023-01-11 09:43:07',10,0),('5','90',257881,'Dally shift','2023-01-11','2023-01-12 07:37:38','2023-01-13 07:37:38','398',0.00,0.00,'398','2023-01-12 07:38:01','797','2023-01-12 09:30:49',10,0),('5','90',257882,'Dally shift','2023-01-12','2023-01-13 06:25:33','2023-01-14 06:25:33','398',0.00,0.00,'398','2023-01-13 06:25:49','797','2023-01-13 09:20:56',10,0),('5','90',257883,'Dally shift','2023-01-13','2023-01-14 06:09:09','2023-01-15 06:09:09','398',0.00,0.00,'398','2023-01-14 06:09:30','797','2023-01-14 16:51:28',10,0),('5','90',257884,'Dally shift','2023-01-14','2023-01-15 06:36:51','2023-01-16 06:36:51','398',0.00,0.00,'398','2023-01-15 06:37:14','797','2023-01-15 07:54:18',10,0),('5','90',257885,'Dally shift','2023-01-15','2023-01-15 22:06:20','2023-01-16 22:06:20','398',0.00,0.00,'398','2023-01-15 22:06:57','797','2023-01-16 10:11:41',10,0),('5','90',257889,'Dally shift','2023-01-16','2023-01-17 07:07:23','2023-01-18 07:07:23','398',0.00,0.00,'398','2023-01-17 07:07:39','797','2023-01-17 10:10:18',10,0),('5','90',257890,'Dally shift','2023-01-17','2023-01-17 22:18:43','2023-01-18 22:18:43','398',0.00,0.00,'398','2023-01-17 22:19:20','797','2023-01-18 09:15:06',10,0),('5','90',257892,'Dally shift','2023-01-18','2023-01-19 06:38:18','2023-01-20 06:38:18','398',0.00,0.00,'398','2023-01-19 06:38:37','797','2023-01-19 09:18:46',10,0),('5','90',257893,'Dally shift','2023-01-19','2023-01-20 07:47:38','2023-01-21 07:47:38','398',0.00,0.00,'398','2023-01-20 07:47:54','797','2023-01-20 09:25:29',10,0),('5','90',257894,'Dally shift','2023-01-20','2023-01-21 00:43:11','2023-01-22 00:43:11','398',0.00,0.00,'398','2023-01-21 00:43:32','797','2023-01-21 06:50:46',10,0),('5','90',257895,'Dally shift','2023-01-21','2023-01-21 21:55:45','2023-01-22 21:55:45','398',0.00,0.00,'398','2023-01-21 21:56:10','797','2023-01-22 10:41:46',10,0),('5','90',257896,'Dally shift','2023-01-22','2023-01-23 00:28:29','2023-01-24 00:28:29','398',0.00,0.00,'398','2023-01-23 00:28:50','797','2023-01-23 09:07:01',10,0),('5','90',257897,'Dally shift ','2023-01-23','2023-01-23 17:05:37','2023-01-24 17:05:37','398',0.00,0.00,'398','2023-01-23 17:05:53','797','2023-01-24 07:21:25',10,0),('5','90',257898,'Dally shift','2023-01-24','2023-01-25 09:36:18','2023-01-26 09:36:18','398',0.00,0.00,'398','2023-01-25 09:36:35','797','2023-01-25 16:49:05',10,0),('5','90',257899,'Dally shift','2023-01-25','2023-01-26 07:14:04','2023-01-27 07:14:04','398',0.00,0.00,'398','2023-01-26 07:14:32','797','2023-01-26 09:21:11',10,0),('5','90',257900,'Dally shift','2023-01-26','2023-01-27 05:33:06','2023-01-28 05:33:06','398',0.00,0.00,'398','2023-01-27 05:33:31','797','2023-01-27 09:43:40',10,0),('5','90',257901,'Dally shift','2023-01-27','2023-01-28 07:50:25','2023-01-29 07:50:25','398',0.00,0.00,'398','2023-01-28 07:50:43','797','2023-01-28 09:43:54',10,0),('5','90',257902,'Dally shift','2023-01-28','2023-01-28 23:21:48','2023-01-29 23:21:48','398',0.00,0.00,'398','2023-01-28 23:22:51','797','2023-01-29 10:59:39',10,0),('5','90',257903,'Dally shift','2023-01-29','2023-01-30 07:28:39','2023-01-31 07:28:39','398',0.00,0.00,'398','2023-01-30 07:28:57','797','2023-01-30 09:22:16',10,0),('5','90',257904,'Dally shift','2023-01-30','2023-01-31 08:14:08','2023-02-01 08:14:08','398',0.00,0.00,'398','2023-01-31 08:14:27','797','2023-01-31 09:08:17',10,0),('5','90',257905,'Dally shift','2023-01-31','2023-02-01 07:36:52','2023-02-02 07:36:52','398',0.00,0.00,'398','2023-02-01 07:37:18','797','2023-02-01 13:53:11',10,0),('5','90',257906,'Dally shift','2023-02-01','2023-02-02 19:04:57','2023-02-03 19:04:57','398',0.00,0.00,'398','2023-02-02 19:05:15','797','2023-02-03 10:01:38',10,0),('5','90',257907,'Dally shift','2023-02-02','2023-02-04 16:33:35','2023-02-05 16:33:35','398',0.00,0.00,'398','2023-02-04 16:33:52','797','2023-02-05 11:50:26',10,0),('5','90',257908,'Dally shift','2023-02-03','2023-02-05 15:21:58','2023-02-06 15:21:58','398',0.00,0.00,'398','2023-02-05 15:22:13','797','2023-02-05 15:49:05',10,0),('5','90',257909,'Dally shift','2023-02-04','2023-02-05 17:28:46','2023-02-06 17:28:46','398',0.00,0.00,'398','2023-02-05 17:29:05','797','2023-02-05 18:35:58',10,0),('5','90',257910,'Dally shift','2023-02-05','2023-02-05 22:27:37','2023-02-06 22:27:37','398',0.00,0.00,'398','2023-02-05 22:28:20','797','2023-02-06 09:07:04',10,0),('5','90',257911,'Dally shift','2023-02-06','2023-02-07 07:03:41','2023-02-08 07:03:41','398',0.00,0.00,'398','2023-02-07 07:04:02','797','2023-02-07 09:07:33',10,0),('5','90',257912,'Dally shift','2023-02-07','2023-02-08 23:05:30','2023-02-09 23:05:30','398',0.00,0.00,'398','2023-02-08 23:05:49','797','2023-02-09 09:23:50',10,0),('5','90',257913,'Dally shift','2023-02-08','2023-02-09 22:52:14','2023-02-10 22:52:14','398',0.00,0.00,'398','2023-02-09 22:52:37','797','2023-02-10 09:02:37',10,0),('5','90',257914,'Dally shift','2023-02-09','2023-02-11 01:33:05','2023-02-12 01:33:05','398',0.00,0.00,'398','2023-02-11 01:33:36','797','2023-02-11 09:41:12',10,0),('5','90',257915,'Dally shift','2023-02-10','2023-02-12 08:33:05','2023-02-13 08:33:05','398',0.00,0.00,'398','2023-02-12 08:33:29','797','2023-02-12 13:24:46',10,0),('5','90',257916,'Dally shift','2023-02-11','2023-02-12 17:10:31','2023-02-13 17:10:31','398',0.00,0.00,'398','2023-02-12 17:10:50','797','2023-02-12 19:07:34',10,0),('5','90',257917,'Dally shift','2023-02-11','2023-02-12 22:00:58','2023-02-13 22:00:58','398',0.00,0.00,'398','2023-02-12 22:05:24','797','2023-02-13 09:13:07',10,0),('5','90',257918,'Dally shift','2023-02-12','2023-02-13 23:02:12','2023-02-14 23:02:12','398',0.00,0.00,'398','2023-02-13 23:02:37','797','2023-02-14 09:35:40',10,0),('5','90',257919,'Dally shift','2023-02-13','2023-02-15 08:31:46','2023-02-16 08:31:46','398',0.00,0.00,'398','2023-02-15 08:32:48','797','2023-02-15 09:23:07',10,0),('5','90',257920,'Dally shift','2023-02-14','2023-02-15 10:06:43','2023-02-16 10:06:43','398',0.00,0.00,'398','2023-02-15 10:07:06','797','2023-02-15 13:11:51',10,0),('5','90',257921,'Dally shift','2023-02-15','2023-02-15 20:36:10','2023-02-16 20:36:10','398',0.00,0.00,'398','2023-02-15 20:36:26','797','2023-02-16 08:43:03',10,0),('5','90',257922,'Dally shift','2023-02-16','2023-02-17 13:09:29','2023-02-18 13:09:29','398',0.00,0.00,'398','2023-02-17 13:09:53','797','2023-02-18 16:29:43',10,0),('5','90',257923,'Dally shift','2023-02-17','2023-02-19 16:30:20','2023-02-20 16:30:20','398',0.00,0.00,'398','2023-02-19 16:30:35','797','2023-02-19 19:00:12',10,0),('5','90',257924,'Dally shift','2023-02-18','2023-02-19 19:01:27','2023-02-20 19:01:27','398',0.00,0.00,'398','2023-02-19 19:01:46','797','2023-02-19 19:28:39',10,0),('5','90',257925,'Dally shift','2023-02-19','2023-02-20 02:40:19','2023-02-21 02:40:19','398',0.00,0.00,'398','2023-02-20 02:40:35','797','2023-02-20 09:18:30',10,0),('5','90',257926,'Dally shift','2023-02-20','2023-02-20 22:31:39','2023-02-21 22:31:39','398',0.00,0.00,'398','2023-02-20 22:32:01','797','2023-02-21 08:52:12',10,0),('5','90',257927,'Dally shift','2023-02-21','2023-02-22 22:49:44','2023-02-23 22:49:44','398',0.00,0.00,'398','2023-02-22 22:50:20','797','2023-02-23 06:58:55',10,0),('5','90',257928,'Dally shift','2023-02-22','2023-02-23 11:04:44','2023-02-24 11:04:44','398',0.00,0.00,'398','2023-02-23 11:05:05','797','2023-02-23 11:07:17',10,0),('5','90',257929,'Dally shift','2023-02-23','2023-02-24 06:08:25','2023-02-25 06:08:25','398',0.00,0.00,'398','2023-02-24 06:08:44','797','2023-02-24 18:51:02',10,0),('5','90',257930,'Dally shift','2023-02-24','2023-02-25 07:09:07','2023-02-26 07:09:07','398',0.00,0.00,'398','2023-02-25 07:09:26','797','2023-02-25 10:31:28',10,0),('5','90',257931,'Dally shift','2023-02-25','2023-02-26 07:54:35','2023-02-27 07:54:35','398',0.00,0.00,'398','2023-02-26 07:55:17','797','2023-02-26 11:12:23',10,0),('5','90',257932,'Dally shift','2023-02-26','2023-02-27 15:47:08','2023-02-28 15:47:08','398',0.00,0.00,'398','2023-02-27 15:47:32','797','2023-02-28 10:21:54',10,0),('5','90',257933,'Dally shift','2023-02-28','2023-03-01 06:15:01','2023-03-02 06:15:01','398',0.00,0.00,'398','2023-03-01 06:15:34','797','2023-03-01 09:33:31',10,0),('5','90',257934,'Dally shift','2023-03-01','2023-03-02 06:09:00','2023-03-03 06:09:00','398',0.00,0.00,'398','2023-03-02 06:09:19','797','2023-03-02 10:08:06',10,0),('5','90',257935,'Dally shift','2023-03-02','2023-03-04 13:33:08','2023-03-05 13:33:08','398',0.00,0.00,'398','2023-03-04 13:33:36','797','2023-03-04 16:40:49',10,0),('5','90',257936,'Dally shift','2023-03-03','2023-03-04 23:10:12','2023-03-05 23:10:12','398',0.00,0.00,'398','2023-03-04 23:10:31','797','2023-03-05 09:43:38',10,0),('5','90',257937,'Dally shift','2023-03-04','2023-03-05 19:14:38','2023-03-06 19:14:38','398',1877891.40,1475486.10,'398','2023-03-06 01:32:18','797','2023-03-06 08:58:06',10,0),('5','90',257938,'Dally shift','2023-03-05','2023-03-06 10:12:42','2023-03-07 10:12:42','398',2680702.50,2680702.50,'398','2023-03-06 10:19:18','797','2023-03-06 10:34:56',10,0),('5','90',257939,'Dally shift','2023-03-06','2023-03-07 04:27:55','2023-03-08 04:27:55','398',1793855.70,1409458.05,'398','2023-03-07 04:31:34','797','2023-03-07 09:25:30',10,0),('5','90',257940,'Dally shift','2023-03-07','2023-03-08 05:14:02','2023-03-09 05:14:02','398',1097819.10,1097819.10,'398','2023-03-08 05:15:47','797','2023-03-08 09:50:28',10,0),('5','90',257941,'Dally shift','2023-03-08','2023-03-08 23:51:35','2023-03-09 23:51:35','398',1592484.60,1592484.60,'398','2023-03-09 02:56:10','797','2023-03-09 09:49:00',10,0),('5','90',257942,'Dally shift','2023-03-09','2023-03-10 06:23:05','2023-03-11 06:23:05','398',359950.50,359950.50,'398','2023-03-10 06:25:12','797','2023-03-10 09:17:40',10,0),('5','90',257943,'Dally shift','2023-03-10','2023-03-11 11:23:23','2023-03-12 11:23:23','398',0.00,0.00,'398','2023-03-11 11:23:42','797','2023-03-11 12:11:30',10,0),('5','90',257944,'Dally shift','2023-03-11','2023-03-11 19:16:01','2023-03-12 19:16:01','398',0.00,0.00,'398','2023-03-11 19:16:22','797','2023-03-12 08:59:16',10,0),('5','90',257945,'Dally shift','2023-03-12','2023-03-12 20:11:54','2023-03-13 20:11:54','398',0.00,0.00,'398','2023-03-12 20:12:16','797','2023-03-13 10:00:11',10,0),('5','90',257946,'Dally shift','2023-03-13','2023-03-13 22:31:13','2023-03-14 22:31:13','398',0.00,0.00,'398','2023-03-13 22:32:06','797','2023-03-14 08:29:29',10,0),('5','90',257947,'Dally shift','2023-03-14','2023-03-14 23:35:25','2023-03-15 23:35:25','398',0.00,0.00,'398','2023-03-14 23:35:53','797','2023-03-15 08:26:22',10,0),('5','90',257948,'Dally shift','2023-03-15','2023-03-15 22:40:09','2023-03-16 22:40:09','398',0.00,0.00,'398','2023-03-15 22:40:28','797','2023-03-16 09:32:46',10,0),('5','90',257949,'Dally shift','2023-03-16','2023-03-16 22:41:09','2023-03-17 22:41:09','398',0.00,0.00,'398','2023-03-16 22:41:37','797','2023-03-17 07:56:12',10,0),('5','90',257950,'Dally shift','2023-03-17','2023-03-17 20:14:30','2023-03-18 20:14:30','398',0.00,0.00,'398','2023-03-17 20:14:49','797','2023-03-18 11:01:57',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4908024 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','90','671','212839',4123145,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','212839',4123146,'1825','270',282353.37,283989.00,1635.63,269878.95,0.00,0.00,0.00,0.00,0.00),('5','90','671','212839',4123147,'1826','270',1051560.47,1051575.59,15.12,2494.80,0.00,0.00,0.00,0.00,0.00),('5','90','668','212839',4123148,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','212839',4123149,'1828','270',529964.67,530439.59,474.92,78361.80,0.00,0.00,0.00,0.00,0.00),('5','90','670','212839',4123150,'1829','270',390946.09,390946.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','212839',4123151,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','212839',4123152,'1831','270',2040913.62,2040913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','212839',4123153,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','212839',4123154,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213087',4127492,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213087',4127493,'1825','270',283989.00,285469.87,1480.87,244343.55,0.00,0.00,0.00,0.00,0.00),('5','90','671','213087',4127494,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','213087',4127495,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213087',4127496,'1828','270',530439.59,531381.68,942.09,155444.85,0.00,0.00,0.00,0.00,0.00),('5','90','670','213087',4127497,'1829','270',390946.09,390946.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','213087',4127498,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213087',4127499,'1831','270',2040913.62,2040913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','213087',4127500,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','213087',4127501,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213090',4127538,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213090',4127539,'1825','270',285469.87,286630.13,1160.26,191442.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','213090',4127540,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','213090',4127541,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213090',4127542,'1828','270',531381.68,532687.76,1306.08,215503.20,0.00,0.00,0.00,0.00,0.00),('5','90','670','213090',4127543,'1829','270',390946.09,390946.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','213090',4127544,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213090',4127545,'1831','270',2040913.62,2040913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','213090',4127546,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','213090',4127547,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213229',4129723,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213229',4129724,'1825','270',286630.13,287623.88,993.75,163968.75,0.00,0.00,0.00,0.00,0.00),('5','90','671','213229',4129725,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','213229',4129726,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213229',4129727,'1828','270',532687.76,533032.40,344.64,56865.60,0.00,0.00,0.00,0.00,0.00),('5','90','670','213229',4129728,'1829','270',390946.09,390946.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','213229',4129729,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213229',4129730,'1831','270',2040913.62,2040913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','213229',4129731,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','213229',4129732,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213495',4134165,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213495',4134166,'1825','270',287623.88,287623.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213495',4134167,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','213495',4134168,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213495',4134169,'1828','270',533032.40,533032.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213495',4134170,'1829','270',390946.09,390946.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','213495',4134171,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213495',4134172,'1831','270',2040913.62,2040913.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','213495',4134173,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','213495',4134174,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213498',4134200,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213498',4134201,'1825','270',287623.88,288388.17,764.29,126107.85,0.00,0.00,0.00,0.00,0.00),('5','90','671','213498',4134202,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','213498',4134203,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213498',4134204,'1828','270',533032.40,533737.13,704.73,116280.45,0.00,0.00,0.00,0.00,0.00),('5','90','670','213498',4134205,'1829','270',390946.09,391657.97,711.88,117460.20,0.00,0.00,0.00,0.00,0.00),('5','90','672','213498',4134206,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213498',4134207,'1831','270',2040913.62,2041393.83,480.21,79234.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','213498',4134208,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','213498',4134209,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213599',4135917,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213599',4135918,'1825','270',288388.17,289239.19,851.02,140418.30,0.00,0.00,0.00,0.00,0.00),('5','90','671','213599',4135919,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','213599',4135920,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213599',4135921,'1828','270',533737.13,533737.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213599',4135922,'1829','270',391657.97,392538.78,880.81,145333.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','213599',4135923,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213599',4135924,'1831','270',2041393.83,2042484.26,1090.43,179920.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','213599',4135925,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','213599',4135926,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213862',4140311,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213862',4140312,'1825','270',289239.19,291476.64,2237.45,369179.25,0.00,0.00,0.00,0.00,0.00),('5','90','671','213862',4140313,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','213862',4140314,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213862',4140315,'1828','270',533737.13,534495.15,758.02,125073.30,0.00,0.00,0.00,0.00,0.00),('5','90','670','213862',4140316,'1829','270',392538.78,394586.59,2047.81,337888.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','213862',4140317,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213862',4140318,'1831','270',2042484.26,2044829.51,2345.25,386966.25,0.00,0.00,0.00,0.00,0.00),('5','90','673','213862',4140319,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','213862',4140320,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','213977',4142117,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213977',4142118,'1825','270',291476.64,292038.97,562.33,92784.45,0.00,0.00,0.00,0.00,0.00),('5','90','671','213977',4142119,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','213977',4142120,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','213977',4142121,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213977',4142122,'1829','270',394586.59,395163.78,577.19,95236.35,0.00,0.00,0.00,0.00,0.00),('5','90','672','213977',4142123,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','213977',4142124,'1831','270',2044829.51,2045943.24,1113.73,183765.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','213977',4142125,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','213977',4142126,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','214125',4144542,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214125',4144543,'1825','270',292038.97,292360.78,321.81,53098.65,0.00,0.00,0.00,0.00,0.00),('5','90','671','214125',4144544,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','214125',4144545,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214125',4144546,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214125',4144547,'1829','270',395163.78,395715.05,551.27,90959.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','214125',4144548,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214125',4144549,'1831','270',2045943.24,2047077.01,1133.77,187072.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','214125',4144550,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','214125',4144551,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','214345',4148424,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214345',4148425,'1825','270',292360.78,292880.41,519.63,85738.95,0.00,0.00,0.00,0.00,0.00),('5','90','671','214345',4148426,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','214345',4148427,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214345',4148428,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214345',4148429,'1829','270',395715.05,396401.55,686.50,113272.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','214345',4148430,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214345',4148431,'1831','270',2047077.01,2048073.68,996.67,164450.55,0.00,0.00,0.00,0.00,0.00),('5','90','673','214345',4148432,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','214345',4148433,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','214595',4152581,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214595',4152582,'1825','270',292880.41,293592.30,711.89,117461.85,0.00,0.00,0.00,0.00,0.00),('5','90','671','214595',4152583,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','214595',4152584,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214595',4152585,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214595',4152586,'1829','270',396401.55,397308.05,906.50,149572.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','214595',4152587,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214595',4152588,'1831','270',2048073.68,2049379.38,1305.70,215440.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','214595',4152589,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','214595',4152590,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','214779',4155880,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214779',4155881,'1825','270',293592.30,294595.10,1002.80,165462.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','214779',4155882,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','214779',4155883,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214779',4155884,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214779',4155885,'1829','270',397308.05,398250.69,942.64,155535.60,0.00,0.00,0.00,0.00,0.00),('5','90','672','214779',4155886,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214779',4155887,'1831','270',2049379.38,2050924.92,1545.54,255014.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','214779',4155888,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','214779',4155889,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','214995',4159508,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214995',4159509,'1825','270',294595.10,295253.42,658.32,108622.80,0.00,0.00,0.00,0.00,0.00),('5','90','671','214995',4159510,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','214995',4159511,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','214995',4159512,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214995',4159513,'1829','270',398250.69,398735.33,484.64,79965.60,0.00,0.00,0.00,0.00,0.00),('5','90','672','214995',4159514,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','214995',4159515,'1831','270',2050924.92,2051967.40,1042.48,172009.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','214995',4159516,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','214995',4159517,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','215231',4163556,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','215231',4163557,'1825','270',295253.42,297616.98,2363.56,389987.40,0.00,0.00,0.00,0.00,0.00),('5','90','671','215231',4163558,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','215231',4163559,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','215231',4163560,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','215231',4163561,'1829','270',398735.33,401346.61,2611.28,430861.20,0.00,0.00,0.00,0.00,0.00),('5','90','672','215231',4163562,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','215231',4163563,'1831','270',2051967.40,2054770.98,2803.58,462590.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','215231',4163564,'1832','271',637061.75,637061.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','215231',4163565,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','215505',4168020,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','215505',4168021,'1825','270',297616.98,298432.36,815.38,134537.70,0.00,0.00,0.00,0.00,0.00),('5','90','671','215505',4168022,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','215505',4168023,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','215505',4168024,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','215505',4168025,'1829','270',401346.61,402100.36,753.75,124368.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','215505',4168026,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','215505',4168027,'1831','270',2054770.98,2056014.79,1243.81,205228.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','215505',4168028,'1832','271',637061.75,637239.24,177.49,52359.55,0.00,0.00,0.00,0.00,0.00),('5','90','674','215505',4168029,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','215680',4171131,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','215680',4171132,'1825','270',298432.36,298873.07,440.71,72717.15,0.00,0.00,0.00,0.00,0.00),('5','90','671','215680',4171133,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','215680',4171134,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','215680',4171135,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','215680',4171136,'1829','270',402100.36,402840.94,740.58,122195.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','215680',4171137,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','215680',4171138,'1831','270',2056014.79,2057474.90,1460.11,240918.15,0.00,0.00,0.00,0.00,0.00),('5','90','673','215680',4171139,'1832','271',637239.24,637419.47,180.23,53167.85,0.00,0.00,0.00,0.00,0.00),('5','90','674','215680',4171140,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','215895',4174961,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','215895',4174962,'1825','270',298873.07,299351.33,478.26,78912.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','215895',4174963,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','215895',4174964,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','215895',4174965,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','215895',4174966,'1829','270',402840.94,403484.77,643.83,106231.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','215895',4174967,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','215895',4174968,'1831','270',2057474.90,2058451.80,976.90,161188.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','215895',4174969,'1832','271',637419.47,637458.36,38.89,11472.55,0.00,0.00,0.00,0.00,0.00),('5','90','674','215895',4174970,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','216114',4178608,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','216114',4178609,'1825','270',299351.33,299793.46,442.13,72951.45,0.00,0.00,0.00,0.00,0.00),('5','90','671','216114',4178610,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','216114',4178611,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','216114',4178612,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','216114',4178613,'1829','270',403484.77,404176.49,691.72,114133.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','216114',4178614,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','216114',4178615,'1831','270',2058451.80,2059773.73,1321.93,218118.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','216114',4178616,'1832','271',637458.36,637517.28,58.92,17381.40,0.00,0.00,0.00,0.00,0.00),('5','90','674','216114',4178617,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','216330',4182352,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','216330',4182353,'1825','270',299793.46,300222.21,428.75,70743.75,0.00,0.00,0.00,0.00,0.00),('5','90','671','216330',4182354,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','216330',4182355,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','216330',4182356,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','216330',4182357,'1829','270',404176.49,405109.16,932.67,153890.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','216330',4182358,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','216330',4182359,'1831','270',2059773.73,2060934.00,1160.27,191444.55,0.00,0.00,0.00,0.00,0.00),('5','90','673','216330',4182360,'1832','271',637517.28,637548.70,31.42,9268.90,0.00,0.00,0.00,0.00,0.00),('5','90','674','216330',4182361,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','216552',4186265,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','216552',4186266,'1825','270',300222.21,300617.85,395.64,65280.60,0.00,0.00,0.00,0.00,0.00),('5','90','671','216552',4186267,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','216552',4186268,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','216552',4186269,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','216552',4186270,'1829','270',405109.16,405626.56,517.40,85371.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','216552',4186271,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','216552',4186272,'1831','270',2060934.00,2061876.32,942.32,155482.80,0.00,0.00,0.00,0.00,0.00),('5','90','673','216552',4186273,'1832','271',637548.70,637576.14,27.44,8094.80,0.00,0.00,0.00,0.00,0.00),('5','90','674','216552',4186274,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','216790',4190522,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','216790',4190523,'1825','270',300617.85,303253.70,2635.85,434915.25,0.00,0.00,0.00,0.00,0.00),('5','90','671','216790',4190524,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','216790',4190525,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','216790',4190526,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','216790',4190527,'1829','270',405626.56,408612.61,2986.05,492698.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','216790',4190528,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','216790',4190529,'1831','270',2061876.32,2063740.45,1864.13,307581.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','216790',4190530,'1832','271',637576.14,637768.05,191.91,56613.45,0.00,0.00,0.00,0.00,0.00),('5','90','674','216790',4190531,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','217076',4195309,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','217076',4195310,'1825','270',303253.70,303661.77,408.07,67331.55,0.00,0.00,0.00,0.00,0.00),('5','90','671','217076',4195311,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','217076',4195312,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','217076',4195313,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','217076',4195314,'1829','270',408612.61,409444.22,831.61,137215.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','217076',4195315,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','217076',4195316,'1831','270',2063740.45,2064641.94,901.49,148745.85,0.00,0.00,0.00,0.00,0.00),('5','90','673','217076',4195317,'1832','271',637768.05,637801.84,33.79,9968.05,0.00,0.00,0.00,0.00,0.00),('5','90','674','217076',4195318,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','217292',4199529,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','217292',4199530,'1825','270',303661.77,304108.14,446.37,73651.05,0.00,0.00,0.00,0.00,0.00),('5','90','671','217292',4199531,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','217292',4199532,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','217292',4199533,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','217292',4199534,'1829','270',409444.22,409959.11,514.89,84956.85,0.00,0.00,0.00,0.00,0.00),('5','90','672','217292',4199535,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','217292',4199536,'1831','270',2064641.94,2065636.36,994.42,164079.30,0.00,0.00,0.00,0.00,0.00),('5','90','673','217292',4199537,'1832','271',637801.84,637865.13,63.29,18670.55,0.00,0.00,0.00,0.00,0.00),('5','90','674','217292',4199538,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','217690',4206536,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','217690',4206537,'1825','270',304108.14,304654.34,546.20,90123.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','217690',4206538,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','217690',4206539,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','217690',4206540,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','217690',4206541,'1829','270',409959.11,410572.71,613.60,101244.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','217690',4206542,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','217690',4206543,'1831','270',2065636.36,2066736.62,1100.26,181542.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','217690',4206544,'1832','271',637865.13,637959.41,94.28,27812.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','217690',4206545,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','217853',4209458,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','217853',4209459,'1825','270',304654.34,305128.81,474.47,78287.55,0.00,0.00,0.00,0.00,0.00),('5','90','671','217853',4209460,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','217853',4209461,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','217853',4209462,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','217853',4209463,'1829','270',410572.71,411369.64,796.93,131493.45,0.00,0.00,0.00,0.00,0.00),('5','90','672','217853',4209464,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','217853',4209465,'1831','270',2066736.62,2067500.27,763.65,126002.25,0.00,0.00,0.00,0.00,0.00),('5','90','673','217853',4209466,'1832','271',637959.41,638105.45,146.04,43081.80,0.00,0.00,0.00,0.00,0.00),('5','90','674','217853',4209467,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','218105',4213636,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','218105',4213637,'1825','270',305128.81,305897.39,768.58,126815.70,0.00,0.00,0.00,0.00,0.00),('5','90','671','218105',4213638,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','218105',4213639,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','218105',4213640,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','218105',4213641,'1829','270',411369.64,411987.61,617.97,101965.05,0.00,0.00,0.00,0.00,0.00),('5','90','672','218105',4213642,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','218105',4213643,'1831','270',2067500.27,2068469.60,969.33,159939.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','218105',4213644,'1832','271',638105.45,638165.00,59.55,17567.25,0.00,0.00,0.00,0.00,0.00),('5','90','674','218105',4213645,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','218221',4215804,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','218221',4215805,'1825','270',305897.39,306461.31,563.92,93046.80,0.00,0.00,0.00,0.00,0.00),('5','90','671','218221',4215806,'1826','270',1051575.59,1051575.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','218221',4215807,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','218221',4215808,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','218221',4215809,'1829','270',411987.61,412483.14,495.53,81762.45,0.00,0.00,0.00,0.00,0.00),('5','90','672','218221',4215810,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','218221',4215811,'1831','270',2068469.60,2068979.40,509.80,84117.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','218221',4215812,'1832','271',638165.00,638278.39,113.39,33450.05,0.00,0.00,0.00,0.00,0.00),('5','90','674','218221',4215813,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','218457',4219868,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','218457',4219869,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','218457',4219870,'1826','270',1051575.59,1052510.23,934.64,154215.60,0.00,0.00,0.00,0.00,0.00),('5','90','668','218457',4219871,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','218457',4219872,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','218457',4219873,'1829','270',412483.14,414053.76,1570.62,259152.30,0.00,0.00,0.00,0.00,0.00),('5','90','672','218457',4219874,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','218457',4219875,'1831','270',2068979.40,2070355.46,1376.06,227049.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','218457',4219876,'1832','271',638278.39,638278.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','218457',4219877,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','218841',4226849,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','218841',4226850,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','218841',4226851,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','218841',4226852,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','218841',4226853,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','218841',4226854,'1829','270',414053.76,414053.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','218841',4226855,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','218841',4226856,'1831','270',2070355.46,2070355.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','218841',4226857,'1832','271',638278.39,638500.71,222.32,65584.40,0.00,0.00,0.00,0.00,0.00),('5','90','674','218841',4226858,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219098',4231368,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219098',4231369,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219098',4231370,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','219098',4231371,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219098',4231372,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219098',4231373,'1829','270',414053.76,414053.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','219098',4231374,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219098',4231375,'1831','270',2070355.46,2070355.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','219098',4231376,'1832','271',638500.71,638553.59,52.88,15599.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','219098',4231377,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219119',4231568,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219119',4231569,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219119',4231570,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','219119',4231571,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219119',4231572,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219119',4231573,'1829','270',414053.76,414752.88,699.12,115354.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','219119',4231574,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219119',4231575,'1831','270',2070355.46,2071503.98,1148.52,189505.80,0.00,0.00,0.00,0.00,0.00),('5','90','673','219119',4231576,'1832','271',638553.59,638665.52,111.93,33019.35,0.00,0.00,0.00,0.00,0.00),('5','90','674','219119',4231577,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219420',4236653,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219420',4236654,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219420',4236655,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','219420',4236656,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219420',4236657,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219420',4236658,'1829','270',414752.88,415668.29,915.41,151042.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','219420',4236659,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219420',4236660,'1831','270',2071503.98,2072452.64,948.66,156528.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','219420',4236661,'1832','271',638665.52,638771.54,106.02,31275.90,0.00,0.00,0.00,0.00,0.00),('5','90','674','219420',4236662,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219655',4240739,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219655',4240740,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219655',4240741,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','219655',4240742,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219655',4240743,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219655',4240744,'1829','270',415668.29,416492.66,824.37,136021.05,0.00,0.00,0.00,0.00,0.00),('5','90','672','219655',4240745,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219655',4240746,'1831','270',2072452.64,2073435.98,983.34,162251.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','219655',4240747,'1832','271',638771.54,639003.84,232.30,68528.50,0.00,0.00,0.00,0.00,0.00),('5','90','674','219655',4240748,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219852',4244288,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219852',4244289,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','219852',4244290,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','219852',4244291,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','219852',4244292,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219852',4244293,'1829','270',416492.66,417116.64,623.98,102956.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','219852',4244294,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','219852',4244295,'1831','270',2073435.98,2074101.81,665.83,109861.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','219852',4244296,'1832','271',639003.84,639080.85,77.01,22717.95,0.00,0.00,0.00,0.00,0.00),('5','90','674','219852',4244297,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220019',4247714,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220019',4247715,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220019',4247716,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','220019',4247717,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220019',4247718,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220019',4247719,'1829','270',417116.64,420905.42,3788.78,625148.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','220019',4247720,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220019',4247721,'1831','270',2074101.81,2077088.98,2987.17,492883.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','220019',4247722,'1832','271',639080.85,639402.76,321.91,94963.45,0.00,0.00,0.00,0.00,0.00),('5','90','674','220019',4247723,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220248',4251481,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220248',4251482,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220248',4251483,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','220248',4251484,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220248',4251485,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220248',4251486,'1829','270',420905.42,422144.80,1239.38,204497.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','220248',4251487,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220248',4251488,'1831','270',2077088.98,2077932.44,843.46,139170.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','220248',4251489,'1832','271',639402.76,639478.92,76.16,22467.20,0.00,0.00,0.00,0.00,0.00),('5','90','674','220248',4251490,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220490',4255783,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220490',4255784,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220490',4255785,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','220490',4255786,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220490',4255787,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220490',4255788,'1829','270',422144.80,422909.71,764.91,126210.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','220490',4255789,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220490',4255790,'1831','270',2077932.44,2078593.47,661.03,109069.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','220490',4255791,'1832','271',639478.92,639504.99,26.07,7690.65,0.00,0.00,0.00,0.00,0.00),('5','90','674','220490',4255792,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220706',4259493,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220706',4259494,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220706',4259495,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','220706',4259496,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220706',4259497,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220706',4259498,'1829','270',422909.71,423804.06,894.35,147567.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','220706',4259499,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220706',4259500,'1831','270',2078593.47,2079564.17,970.70,160165.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','220706',4259501,'1832','271',639504.99,639566.61,61.62,18177.90,0.00,0.00,0.00,0.00,0.00),('5','90','674','220706',4259502,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220939',4263609,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220939',4263610,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','220939',4263611,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','220939',4263612,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','220939',4263613,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220939',4263614,'1829','270',423804.06,424774.41,970.35,160107.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','220939',4263615,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','220939',4263616,'1831','270',2079564.17,2080525.32,961.15,158589.75,0.00,0.00,0.00,0.00,0.00),('5','90','673','220939',4263617,'1832','271',639566.61,639607.92,41.31,12186.45,0.00,0.00,0.00,0.00,0.00),('5','90','674','220939',4263618,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','221160',4267518,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','221160',4267519,'1825','270',306461.31,306461.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','221160',4267520,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','221160',4267521,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','221160',4267522,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','221160',4267523,'1829','270',424774.41,426027.06,1252.65,206687.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','221160',4267524,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','221160',4267525,'1831','270',2080525.32,2081409.23,883.91,145845.15,0.00,0.00,0.00,0.00,0.00),('5','90','673','221160',4267526,'1832','271',639607.92,639712.52,104.60,30857.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','221160',4267527,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','221416',4272137,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','221416',4272138,'1825','270',306461.31,307734.86,1273.55,210135.75,0.00,0.00,0.00,0.00,0.00),('5','90','671','221416',4272139,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','221416',4272140,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','221416',4272141,'1828','270',534495.15,534495.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','221416',4272142,'1829','270',426027.06,426671.44,644.38,106322.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','221416',4272143,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','221416',4272144,'1831','270',2081409.23,2082113.93,704.70,116275.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','221416',4272145,'1832','271',639712.52,639782.12,69.60,20532.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','221416',4272146,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','221638',4276249,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','221638',4276250,'1825','270',307734.86,309534.63,1799.77,296962.05,0.00,0.00,0.00,0.00,0.00),('5','90','671','221638',4276251,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','221638',4276252,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','221638',4276253,'1828','270',534495.15,535567.10,1071.95,176871.75,0.00,0.00,0.00,0.00,0.00),('5','90','670','221638',4276254,'1829','270',426671.44,428288.76,1617.32,266857.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','221638',4276255,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','221638',4276256,'1831','270',2082113.93,2084408.50,2294.57,378604.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','221638',4276257,'1832','271',639782.12,640158.02,375.90,110890.50,0.00,0.00,0.00,0.00,0.00),('5','90','674','221638',4276258,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','221913',4281072,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','221913',4281073,'1825','270',309534.63,309981.96,447.33,73809.45,0.00,0.00,0.00,0.00,0.00),('5','90','671','221913',4281074,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','221913',4281075,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','221913',4281076,'1828','270',535567.10,535567.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','221913',4281077,'1829','270',428288.76,429149.00,860.24,141939.60,0.00,0.00,0.00,0.00,0.00),('5','90','672','221913',4281078,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','221913',4281079,'1831','270',2084408.50,2085500.48,1091.98,180176.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','221913',4281080,'1832','271',640158.02,640320.82,162.80,48026.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','221913',4281081,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','222059',4284007,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222059',4284008,'1825','270',309981.96,310614.14,632.18,104309.70,0.00,0.00,0.00,0.00,0.00),('5','90','671','222059',4284009,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','222059',4284010,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222059',4284011,'1828','270',535567.10,535567.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222059',4284012,'1829','270',429149.00,429553.32,404.32,66712.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','222059',4284013,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222059',4284014,'1831','270',2085500.48,2086356.96,856.48,141319.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','222059',4284015,'1832','271',640320.82,640352.98,32.16,9487.20,0.00,0.00,0.00,0.00,0.00),('5','90','674','222059',4284016,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','222267',4287469,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222267',4287470,'1825','270',310614.14,311203.20,589.06,97194.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','222267',4287471,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','222267',4287472,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222267',4287473,'1828','270',535567.10,535567.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222267',4287474,'1829','270',429553.32,429982.07,428.75,70743.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','222267',4287475,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222267',4287476,'1831','270',2086356.96,2087251.73,894.77,147637.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','222267',4287477,'1832','271',640352.98,640458.86,105.88,31234.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','222267',4287478,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','222494',4291338,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222494',4291339,'1825','270',311203.20,311728.06,524.86,86601.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','222494',4291340,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','222494',4291341,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222494',4291342,'1828','270',535567.10,535567.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222494',4291343,'1829','270',429982.07,430262.65,280.58,46295.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','222494',4291344,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222494',4291345,'1831','270',2087251.73,2088449.27,1197.54,197594.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','222494',4291346,'1832','271',640458.86,640513.27,54.41,16050.95,0.00,0.00,0.00,0.00,0.00),('5','90','674','222494',4291347,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','222846',4297824,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222846',4297825,'1825','270',311728.06,312253.52,525.46,86700.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','222846',4297826,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','222846',4297827,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222846',4297828,'1828','270',535567.10,535567.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222846',4297829,'1829','270',430262.65,430487.59,224.94,37115.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','222846',4297830,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222846',4297831,'1831','270',2088449.27,2088860.52,411.25,67856.25,0.00,0.00,0.00,0.00,0.00),('5','90','673','222846',4297832,'1832','271',640513.27,640614.84,101.57,29963.15,0.00,0.00,0.00,0.00,0.00),('5','90','674','222846',4297833,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','222953',4299895,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222953',4299896,'1825','270',312253.52,312691.51,437.99,72268.35,0.00,0.00,0.00,0.00,0.00),('5','90','671','222953',4299897,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','222953',4299898,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','222953',4299899,'1828','270',535567.10,535567.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222953',4299900,'1829','270',430487.59,430973.84,486.25,80231.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','222953',4299901,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','222953',4299902,'1831','270',2088860.52,2089567.08,706.56,116582.40,0.00,0.00,0.00,0.00,0.00),('5','90','673','222953',4299903,'1832','271',640614.84,640703.67,88.83,26204.85,0.00,0.00,0.00,0.00,0.00),('5','90','674','222953',4299904,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','223237',4304536,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','223237',4304537,'1825','270',312691.51,313942.07,1250.56,206342.40,0.00,0.00,0.00,0.00,0.00),('5','90','671','223237',4304538,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','223237',4304539,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','223237',4304540,'1828','270',535567.10,536432.10,865.00,142725.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','223237',4304541,'1829','270',430973.84,433081.45,2107.61,347755.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','223237',4304542,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','223237',4304543,'1831','270',2089567.08,2092204.46,2637.38,435167.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','223237',4304544,'1832','271',640703.67,641031.79,328.12,96795.40,0.00,0.00,0.00,0.00,0.00),('5','90','674','223237',4304545,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','223625',4311905,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','223625',4311906,'1825','270',313942.07,315284.65,1342.58,221525.70,0.00,0.00,0.00,0.00,0.00),('5','90','671','223625',4311907,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','223625',4311908,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','223625',4311909,'1828','270',536432.10,536898.86,466.76,77015.40,0.00,0.00,0.00,0.00,0.00),('5','90','670','223625',4311910,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','223625',4311911,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','223625',4311912,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','223625',4311913,'1832','271',641031.79,641079.32,47.53,14021.35,0.00,0.00,0.00,0.00,0.00),('5','90','674','223625',4311914,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','223857',4316194,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','223857',4316195,'1825','270',315284.65,316236.98,952.33,157134.45,0.00,0.00,0.00,0.00,0.00),('5','90','671','223857',4316196,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','223857',4316197,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','223857',4316198,'1828','270',536898.86,537735.38,836.52,138025.80,0.00,0.00,0.00,0.00,0.00),('5','90','670','223857',4316199,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','223857',4316200,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','223857',4316201,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','223857',4316202,'1832','271',641079.32,641142.05,62.73,18505.35,0.00,0.00,0.00,0.00,0.00),('5','90','674','223857',4316203,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','223877',4316420,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','223877',4316421,'1825','270',316236.98,317062.37,825.39,136189.35,0.00,0.00,0.00,0.00,0.00),('5','90','671','223877',4316422,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','223877',4316423,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','223877',4316424,'1828','270',537735.38,538806.80,1071.42,176784.30,0.00,0.00,0.00,0.00,0.00),('5','90','670','223877',4316425,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','223877',4316426,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','223877',4316427,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','223877',4316428,'1832','271',641142.05,641186.70,44.65,13171.75,0.00,0.00,0.00,0.00,0.00),('5','90','674','223877',4316429,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','224121',4320497,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','224121',4320498,'1825','270',317062.37,317062.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','224121',4320499,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','224121',4320500,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','224121',4320501,'1828','270',538806.80,538901.16,94.36,15569.40,0.00,0.00,0.00,0.00,0.00),('5','90','670','224121',4320502,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','224121',4320503,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','224121',4320504,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','224121',4320505,'1832','271',641186.70,641222.52,35.82,10566.90,0.00,0.00,0.00,0.00,0.00),('5','90','674','224121',4320506,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','224320',4324212,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','224320',4324213,'1825','270',317062.37,317062.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','224320',4324214,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','224320',4324215,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','224320',4324216,'1828','270',538901.16,538901.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','224320',4324217,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','224320',4324218,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','224320',4324219,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','224320',4324220,'1832','271',641222.52,641288.01,65.49,19319.55,0.00,0.00,0.00,0.00,0.00),('5','90','674','224320',4324221,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','224554',4328216,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','224554',4328217,'1825','270',317062.37,317062.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','224554',4328218,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','224554',4328219,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','224554',4328220,'1828','270',538901.16,538901.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','224554',4328221,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','224554',4328222,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','224554',4328223,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','224554',4328224,'1832','271',641288.01,641288.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','224554',4328225,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','224994',4336309,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','224994',4336310,'1825','270',317062.37,318547.36,1484.99,242053.37,0.00,0.00,0.00,0.00,0.00),('5','90','671','224994',4336311,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','224994',4336312,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','224994',4336313,'1828','270',538901.16,539806.76,905.60,147612.80,0.00,0.00,0.00,0.00,0.00),('5','90','670','224994',4336314,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','224994',4336315,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','224994',4336316,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','224994',4336317,'1832','271',641288.01,641304.93,16.92,4991.40,0.00,0.00,0.00,0.00,0.00),('5','90','674','224994',4336318,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','225022',4336597,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','225022',4336598,'1825','270',318547.36,319961.53,1414.17,230509.71,0.00,0.00,0.00,0.00,0.00),('5','90','671','225022',4336599,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','225022',4336600,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','225022',4336601,'1828','270',539806.76,540637.73,830.97,135448.11,0.00,0.00,0.00,0.00,0.00),('5','90','670','225022',4336602,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','225022',4336603,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','225022',4336604,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','225022',4336605,'1832','271',641304.93,641388.07,83.14,24526.30,0.00,0.00,0.00,0.00,0.00),('5','90','674','225022',4336606,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','225296',4341445,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','225296',4341446,'1825','270',319961.53,321138.53,1177.00,191851.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','225296',4341447,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','225296',4341448,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','225296',4341449,'1828','270',540637.73,541480.35,842.62,137347.06,0.00,0.00,0.00,0.00,0.00),('5','90','670','225296',4341450,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','225296',4341451,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','225296',4341452,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','225296',4341453,'1832','271',641388.07,641513.25,125.18,36928.10,0.00,0.00,0.00,0.00,0.00),('5','90','674','225296',4341454,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','225481',4345067,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','225481',4345068,'1825','270',321138.53,322147.15,1008.62,164405.06,0.00,0.00,0.00,0.00,0.00),('5','90','671','225481',4345069,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','225481',4345070,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','225481',4345071,'1828','270',541480.35,542318.84,838.49,136673.87,0.00,0.00,0.00,0.00,0.00),('5','90','670','225481',4345072,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','225481',4345073,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','225481',4345074,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','225481',4345075,'1832','271',641513.25,641589.51,76.26,22496.70,0.00,0.00,0.00,0.00,0.00),('5','90','674','225481',4345076,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','225718',4348913,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','225718',4348914,'1825','270',322147.15,322147.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','225718',4348915,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','225718',4348916,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','225718',4348917,'1828','270',542318.84,542728.58,409.74,66787.62,0.00,0.00,0.00,0.00,0.00),('5','90','670','225718',4348918,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','225718',4348919,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','225718',4348920,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','225718',4348921,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','225718',4348922,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','226000',4353760,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','226000',4353761,'1825','270',322147.15,322147.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','226000',4353762,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','226000',4353763,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','226000',4353764,'1828','270',542728.58,544978.43,2249.85,366725.55,0.00,0.00,0.00,0.00,0.00),('5','90','670','226000',4353765,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','226000',4353766,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','226000',4353767,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','226000',4353768,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','226000',4353769,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','226382',4360864,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','226382',4360865,'1825','270',322147.15,322147.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','226382',4360866,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','226382',4360867,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','226382',4360868,'1828','270',544978.43,547061.17,2082.74,339486.62,0.00,0.00,0.00,0.00,0.00),('5','90','670','226382',4360869,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','226382',4360870,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','226382',4360871,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','226382',4360872,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','226382',4360873,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','226547',4363601,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','226547',4363602,'1825','270',322147.15,325437.97,3290.82,536403.66,0.00,0.00,0.00,0.00,0.00),('5','90','671','226547',4363603,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','226547',4363604,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','226547',4363605,'1828','270',547061.17,550627.06,3565.89,581240.07,0.00,0.00,0.00,0.00,0.00),('5','90','670','226547',4363606,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','226547',4363607,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','226547',4363608,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','226547',4363609,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','226547',4363610,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','226840',4369099,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','226840',4369100,'1825','270',325437.97,326624.51,1186.54,193406.02,0.00,0.00,0.00,0.00,0.00),('5','90','671','226840',4369101,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','226840',4369102,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','226840',4369103,'1828','270',550627.06,551516.50,889.44,144978.72,0.00,0.00,0.00,0.00,0.00),('5','90','670','226840',4369104,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','226840',4369105,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','226840',4369106,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','226840',4369107,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','226840',4369108,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','227059',4372863,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','227059',4372864,'1825','270',326624.51,327868.10,1243.59,202705.17,0.00,0.00,0.00,0.00,0.00),('5','90','671','227059',4372865,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','227059',4372866,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','227059',4372867,'1828','270',551516.50,552453.63,937.13,152752.19,0.00,0.00,0.00,0.00,0.00),('5','90','670','227059',4372868,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','227059',4372869,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','227059',4372870,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','227059',4372871,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','227059',4372872,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','227200',4375385,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','227200',4375386,'1825','270',327868.10,328870.79,1002.69,163438.47,0.00,0.00,0.00,0.00,0.00),('5','90','671','227200',4375387,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','227200',4375388,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','227200',4375389,'1828','270',552453.63,553136.04,682.41,111232.83,0.00,0.00,0.00,0.00,0.00),('5','90','670','227200',4375390,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','227200',4375391,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','227200',4375392,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','227200',4375393,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','227200',4375394,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','227394',4378787,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','227394',4378788,'1825','270',328870.79,329411.55,540.76,88143.88,0.00,0.00,0.00,0.00,0.00),('5','90','671','227394',4378789,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','227394',4378790,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','227394',4378791,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','227394',4378792,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','227394',4378793,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','227394',4378794,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','227394',4378795,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','227394',4378796,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','227670',4383631,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','227670',4383632,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','227670',4383633,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','227670',4383634,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','227670',4383635,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','227670',4383636,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','227670',4383637,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','227670',4383638,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','227670',4383639,'1832','271',641589.51,641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','227670',4383640,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','229380',4415846,'1824','270',50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','229380',4415847,'1825','270',329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','229380',4415848,'1826','270',1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','229380',4415849,'1827','270',2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','229380',4415850,'1828','270',553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','229380',4415851,'1829','270',433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','229380',4415852,'1830','270',53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','229380',4415853,'1831','270',2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','229380',4415854,'1832','271',641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','229380',4415855,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','230664',4440220,'1824','270',50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','230664',4440221,'1825','270',329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','230664',4440222,'1826','270',1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','230664',4440223,'1827','270',2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','230664',4440224,'1828','270',553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','230664',4440225,'1829','270',433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','230664',4440226,'1830','270',53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','230664',4440227,'1831','270',2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','230664',4440228,'1832','271',641589.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','230664',4440229,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','230704',4441047,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','230704',4441048,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','230704',4441049,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','230704',4441050,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','230704',4441051,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','230704',4441052,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','230704',4441053,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','230704',4441054,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','230704',4441055,'1832','271',641589.51,641678.62,89.11,26733.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','230704',4441056,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','230706',4441083,'1824','270',50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','230706',4441084,'1825','270',329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','230706',4441085,'1826','270',1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','230706',4441086,'1827','270',2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','230706',4441087,'1828','270',553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','230706',4441088,'1829','270',433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','230706',4441089,'1830','270',53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','230706',4441090,'1831','270',2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','230706',4441091,'1832','271',641678.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','230706',4441092,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','230766',4442021,'1824','270',50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','230766',4442022,'1825','270',329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','230766',4442023,'1826','270',1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','230766',4442024,'1827','270',2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','230766',4442025,'1828','270',553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','230766',4442026,'1829','270',433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','230766',4442027,'1830','270',53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','230766',4442028,'1831','270',2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','230766',4442029,'1832','271',641678.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','230766',4442030,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231139',4448176,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231139',4448177,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231139',4448178,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231139',4448179,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231139',4448180,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231139',4448181,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','231139',4448182,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231139',4448183,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','231139',4448184,'1832','271',641678.62,641987.82,309.20,95852.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','231139',4448185,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231142',4448219,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231142',4448220,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231142',4448221,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231142',4448222,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231142',4448223,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231142',4448224,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','231142',4448225,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231142',4448226,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','231142',4448227,'1832','271',641987.82,642407.70,419.88,130162.80,0.00,0.00,0.00,0.00,0.00),('5','90','674','231142',4448228,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231152',4448451,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231152',4448452,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231152',4448453,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231152',4448454,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231152',4448455,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231152',4448456,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','231152',4448457,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231152',4448458,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','231152',4448459,'1832','271',642407.70,643008.86,601.16,186359.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','231152',4448460,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231156',4448521,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231156',4448522,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231156',4448523,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231156',4448524,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231156',4448525,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231156',4448526,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','231156',4448527,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231156',4448528,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','231156',4448529,'1832','271',643008.86,643320.25,311.39,96530.90,0.00,0.00,0.00,0.00,0.00),('5','90','674','231156',4448530,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231158',4448533,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231158',4448534,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231158',4448535,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231158',4448536,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231158',4448537,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231158',4448538,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','231158',4448539,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231158',4448540,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','231158',4448541,'1832','271',643320.25,643462.65,142.40,44144.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','231158',4448542,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231161',4448606,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231161',4448607,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231161',4448608,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231161',4448609,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231161',4448610,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231161',4448611,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','231161',4448612,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231161',4448613,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','231161',4448614,'1832','271',643462.65,643558.99,96.34,29865.40,0.00,0.00,0.00,0.00,0.00),('5','90','674','231161',4448615,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231163',4448670,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231163',4448671,'1825','270',329411.55,329411.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231163',4448672,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231163',4448673,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231163',4448674,'1828','270',553136.04,553136.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231163',4448675,'1829','270',433081.45,433081.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','231163',4448676,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231163',4448677,'1831','270',2092204.46,2092204.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','231163',4448678,'1832','271',643558.99,643704.65,145.66,46611.20,0.00,0.00,0.00,0.00,0.00),('5','90','674','231163',4448679,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231165',4448690,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231165',4448691,'1825','270',329411.55,330437.14,1025.59,167171.17,0.00,0.00,0.00,0.00,0.00),('5','90','671','231165',4448692,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231165',4448693,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231165',4448694,'1828','270',553136.04,553377.21,241.17,39310.71,0.00,0.00,0.00,0.00,0.00),('5','90','670','231165',4448695,'1829','270',433081.45,433557.28,475.83,77560.29,0.00,0.00,0.00,0.00,0.00),('5','90','672','231165',4448696,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231165',4448697,'1831','270',2092204.46,2092786.32,581.86,94843.18,0.00,0.00,0.00,0.00,0.00),('5','90','673','231165',4448698,'1832','271',643704.65,644184.76,480.11,153635.20,0.00,0.00,0.00,0.00,0.00),('5','90','674','231165',4448699,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231243',4449887,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231243',4449888,'1825','270',330437.14,331389.32,952.18,155205.34,0.00,0.00,0.00,0.00,0.00),('5','90','671','231243',4449889,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231243',4449890,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231243',4449891,'1828','270',553377.21,553377.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231243',4449892,'1829','270',433557.28,434304.00,746.72,121715.36,0.00,0.00,0.00,0.00,0.00),('5','90','672','231243',4449893,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231243',4449894,'1831','270',2092786.32,2094074.02,1287.70,209895.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','231243',4449895,'1832','271',644184.76,644436.54,251.78,80569.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','231243',4449896,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231422',4452547,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231422',4452548,'1825','270',331389.32,333512.73,2123.41,346115.83,0.00,0.00,0.00,0.00,0.00),('5','90','671','231422',4452549,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231422',4452550,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231422',4452551,'1828','270',553377.21,553377.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231422',4452552,'1829','270',434304.00,437585.92,3281.92,534952.96,0.00,0.00,0.00,0.00,0.00),('5','90','672','231422',4452553,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231422',4452554,'1831','270',2094074.02,2096807.46,2733.44,445550.72,0.00,0.00,0.00,0.00,0.00),('5','90','673','231422',4452555,'1832','271',644436.54,644664.87,228.33,73065.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','231422',4452556,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231640',4456431,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231640',4456432,'1825','270',333512.73,334328.73,816.00,133008.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','231640',4456433,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','231640',4456434,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','231640',4456435,'1828','270',553377.21,553377.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231640',4456436,'1829','270',437585.92,438168.68,582.76,94989.88,0.00,0.00,0.00,0.00,0.00),('5','90','672','231640',4456437,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','231640',4456438,'1831','270',2096807.46,2097488.96,681.50,111084.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','231640',4456439,'1832','271',644664.87,644738.78,73.91,23651.20,0.00,0.00,0.00,0.00,0.00),('5','90','674','231640',4456440,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','232075',4464572,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232075',4464573,'1825','270',334328.73,334978.78,650.05,105958.15,0.00,0.00,0.00,0.00,0.00),('5','90','671','232075',4464574,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','232075',4464575,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232075',4464576,'1828','270',553377.21,553377.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232075',4464577,'1829','270',438168.68,438811.06,642.38,104707.94,0.00,0.00,0.00,0.00,0.00),('5','90','672','232075',4464578,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232075',4464579,'1831','270',2097488.96,2098347.88,858.92,140003.96,0.00,0.00,0.00,0.00,0.00),('5','90','673','232075',4464580,'1832','271',644738.78,644927.85,189.07,61825.89,0.00,0.00,0.00,0.00,0.00),('5','90','674','232075',4464581,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','232314',4468746,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232314',4468747,'1825','270',334978.78,335527.36,548.58,89418.54,0.00,0.00,0.00,0.00,0.00),('5','90','671','232314',4468748,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','232314',4468749,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232314',4468750,'1828','270',553377.21,553377.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232314',4468751,'1829','270',438811.06,439522.88,711.82,116026.66,0.00,0.00,0.00,0.00,0.00),('5','90','672','232314',4468752,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232314',4468753,'1831','270',2098347.88,2099462.81,1114.93,181733.59,0.00,0.00,0.00,0.00,0.00),('5','90','673','232314',4468754,'1832','271',644927.85,645159.10,231.25,75618.75,0.00,0.00,0.00,0.00,0.00),('5','90','674','232314',4468755,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','232368',4469456,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232368',4469457,'1825','270',335527.36,337439.74,1912.38,311717.94,0.00,0.00,0.00,0.00,0.00),('5','90','671','232368',4469458,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','232368',4469459,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232368',4469460,'1828','270',553377.21,553575.30,198.09,32288.67,0.00,0.00,0.00,0.00,0.00),('5','90','670','232368',4469461,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','232368',4469462,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232368',4469463,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','232368',4469464,'1832','271',645159.10,645361.98,202.88,66341.76,0.00,0.00,0.00,0.00,0.00),('5','90','674','232368',4469465,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','232823',4478021,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232823',4478022,'1825','270',337439.74,338881.86,1442.12,235065.56,0.00,0.00,0.00,0.00,0.00),('5','90','671','232823',4478023,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','232823',4478024,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232823',4478025,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232823',4478026,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','232823',4478027,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232823',4478028,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','232823',4478029,'1832','271',645361.98,645426.21,64.23,21003.21,0.00,0.00,0.00,0.00,0.00),('5','90','674','232823',4478030,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','232858',4478320,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232858',4478321,'1825','270',338881.86,340657.25,1775.39,289388.57,0.00,0.00,0.00,0.00,0.00),('5','90','671','232858',4478322,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','232858',4478323,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','232858',4478324,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232858',4478325,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','232858',4478326,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','232858',4478327,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','232858',4478328,'1832','271',645426.21,645664.10,237.89,78503.70,0.00,0.00,0.00,0.00,0.00),('5','90','674','232858',4478329,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','233307',4486755,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','233307',4486756,'1825','270',340657.25,341422.22,764.97,124690.11,0.00,0.00,0.00,0.00,0.00),('5','90','671','233307',4486757,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','233307',4486758,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','233307',4486759,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','233307',4486760,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','233307',4486761,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','233307',4486762,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','233307',4486763,'1832','271',645664.10,645796.37,132.27,45633.15,0.00,0.00,0.00,0.00,0.00),('5','90','674','233307',4486764,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','233450',4488953,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','233450',4488954,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','233450',4488955,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','233450',4488956,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','233450',4488957,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','233450',4488958,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','233450',4488959,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','233450',4488960,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','233450',4488961,'1832','271',645796.37,645924.61,128.24,44242.80,0.00,0.00,0.00,0.00,0.00),('5','90','674','233450',4488962,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','233671',4492983,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','233671',4492984,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','233671',4492985,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','233671',4492986,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','233671',4492987,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','233671',4492988,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','233671',4492989,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','233671',4492990,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','233671',4492991,'1832','271',645924.61,646010.77,86.16,29725.20,0.00,0.00,0.00,0.00,0.00),('5','90','674','233671',4492992,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','233851',4496298,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','233851',4496299,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','233851',4496300,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','233851',4496301,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','233851',4496302,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','233851',4496303,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','233851',4496304,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','233851',4496305,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','233851',4496306,'1832','271',646010.77,646106.40,95.63,32992.35,0.00,0.00,0.00,0.00,0.00),('5','90','674','233851',4496307,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','234283',4504345,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','234283',4504346,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','234283',4504347,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','234283',4504348,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','234283',4504349,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','234283',4504350,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','234283',4504351,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','234283',4504352,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','234283',4504353,'1832','271',646106.40,646187.71,81.31,28051.95,0.00,0.00,0.00,0.00,0.00),('5','90','674','234283',4504354,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','234380',4505898,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','234380',4505899,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','234380',4505900,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','234380',4505901,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','234380',4505902,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','234380',4505903,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','234380',4505904,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','234380',4505905,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','234380',4505906,'1832','271',646187.71,646277.54,89.83,30991.35,0.00,0.00,0.00,0.00,0.00),('5','90','674','234380',4505907,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','234695',4511506,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','234695',4511507,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','234695',4511508,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','234695',4511509,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','234695',4511510,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','234695',4511511,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','234695',4511512,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','234695',4511513,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','234695',4511514,'1832','271',646277.54,646454.20,176.66,60947.70,0.00,0.00,0.00,0.00,0.00),('5','90','674','234695',4511515,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','234875',4514711,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','234875',4514712,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','234875',4514713,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','234875',4514714,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','234875',4514715,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','234875',4514716,'1829','270',439522.88,439522.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','234875',4514717,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','234875',4514718,'1831','270',2099462.81,2099462.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','234875',4514719,'1832','271',646454.20,646519.32,65.12,22466.40,0.00,0.00,0.00,0.00,0.00),('5','90','674','234875',4514720,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','236546',4543945,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','236546',4543946,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','236546',4543947,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','236546',4543948,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','236546',4543949,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','236546',4543950,'1829','270',439522.88,443812.64,4289.76,707810.40,0.00,0.00,0.00,0.00,0.00),('5','90','672','236546',4543951,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','236546',4543952,'1831','270',2099462.81,2104763.18,5300.37,874561.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','236546',4543953,'1832','271',646519.32,646969.79,450.47,155412.15,0.00,0.00,0.00,0.00,0.00),('5','90','674','236546',4543954,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','236932',4550907,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','236932',4550908,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','236932',4550909,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','236932',4550910,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','236932',4550911,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','236932',4550912,'1829','270',443812.64,446587.73,2775.09,457889.85,0.00,0.00,0.00,0.00,0.00),('5','90','672','236932',4550913,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','236932',4550914,'1831','270',2104763.18,2106694.39,1931.21,318649.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','236932',4550915,'1832','271',646969.79,647146.09,176.30,60823.50,0.00,0.00,0.00,0.00,0.00),('5','90','674','236932',4550916,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237057',4552850,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237057',4552851,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237057',4552852,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','237057',4552853,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237057',4552854,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237057',4552855,'1829','270',446587.73,448740.91,2153.18,355274.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','237057',4552856,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237057',4552857,'1831','270',2106694.39,2108561.59,1867.20,308088.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','237057',4552858,'1832','271',647146.09,647257.75,111.66,38522.70,0.00,0.00,0.00,0.00,0.00),('5','90','674','237057',4552859,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237186',4555088,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237186',4555089,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237186',4555090,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','237186',4555091,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237186',4555092,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237186',4555093,'1829','270',448740.91,451095.81,2354.90,388558.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','237186',4555094,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237186',4555095,'1831','270',2108561.59,2110374.46,1812.87,299123.55,0.00,0.00,0.00,0.00,0.00),('5','90','673','237186',4555096,'1832','271',647257.75,647399.83,142.08,49017.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','237186',4555097,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237450',4560116,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237450',4560117,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237450',4560118,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','237450',4560119,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237450',4560120,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237450',4560121,'1829','270',451095.81,454436.93,3341.12,551284.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','237450',4560122,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237450',4560123,'1831','270',2110374.46,2111594.96,1220.50,201382.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','237450',4560124,'1832','271',647399.83,647496.22,96.39,33254.55,0.00,0.00,0.00,0.00,0.00),('5','90','674','237450',4560125,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237837',4566695,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237837',4566696,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237837',4566697,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','237837',4566698,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237837',4566699,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237837',4566700,'1829','270',454436.93,454436.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','237837',4566701,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237837',4566702,'1831','270',2111594.96,2111594.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','237837',4566703,'1832','271',647496.22,647945.17,448.95,154887.75,0.00,0.00,0.00,0.00,0.00),('5','90','674','237837',4566704,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237901',4567490,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237901',4567491,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','237901',4567492,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','237901',4567493,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','237901',4567494,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237901',4567495,'1829','270',454436.93,454436.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','237901',4567496,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','237901',4567497,'1831','270',2111594.96,2111594.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','237901',4567498,'1832','271',647945.17,648265.83,320.66,110627.70,0.00,0.00,0.00,0.00,0.00),('5','90','674','237901',4567499,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','238142',4571384,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','238142',4571385,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','238142',4571386,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','238142',4571387,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','238142',4571388,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','238142',4571389,'1829','270',454436.93,454436.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','238142',4571390,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','238142',4571391,'1831','270',2111594.96,2111594.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','238142',4571392,'1832','271',648265.83,648393.69,127.86,44111.70,0.00,0.00,0.00,0.00,0.00),('5','90','674','238142',4571393,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','238432',4576580,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','238432',4576581,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','238432',4576582,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','238432',4576583,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','238432',4576584,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','238432',4576585,'1829','270',454436.93,454436.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','238432',4576586,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','238432',4576587,'1831','270',2111594.96,2111594.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','238432',4576588,'1832','271',648393.69,648653.70,260.01,89703.45,0.00,0.00,0.00,0.00,0.00),('5','90','674','238432',4576589,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','238634',4579820,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','238634',4579821,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','238634',4579822,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','238634',4579823,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','238634',4579824,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','238634',4579825,'1829','270',454436.93,454436.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','238634',4579826,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','238634',4579827,'1831','270',2111594.96,2111594.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','238634',4579828,'1832','271',648653.70,648653.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','238634',4579829,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','238935',4585330,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','238935',4585331,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','238935',4585332,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','238935',4585333,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','238935',4585334,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','238935',4585335,'1829','270',454436.93,456975.07,2538.14,418793.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','238935',4585336,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','238935',4585337,'1831','270',2111594.96,2111594.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','238935',4585338,'1832','271',648653.70,648957.98,304.28,104976.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','238935',4585339,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','239073',4587698,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','239073',4587699,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','239073',4587700,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','239073',4587701,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','239073',4587702,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','239073',4587703,'1829','270',456975.07,459858.73,2883.66,475803.90,0.00,0.00,0.00,0.00,0.00),('5','90','672','239073',4587704,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','239073',4587705,'1831','270',2111594.96,2113911.86,2316.90,382288.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','239073',4587706,'1832','271',648957.98,649258.09,300.11,103537.95,0.00,0.00,0.00,0.00,0.00),('5','90','674','239073',4587707,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','239339',4592302,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','239339',4592303,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','239339',4592304,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','239339',4592305,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','239339',4592306,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','239339',4592307,'1829','270',459858.73,461187.36,1328.63,219223.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','239339',4592308,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','239339',4592309,'1831','270',2113911.86,2115747.09,1835.23,302812.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','239339',4592310,'1832','271',649258.09,649326.68,68.59,23663.55,0.00,0.00,0.00,0.00,0.00),('5','90','674','239339',4592311,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','239557',4595880,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','239557',4595881,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','239557',4595882,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','239557',4595883,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','239557',4595884,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','239557',4595885,'1829','270',461187.36,462985.34,1797.98,296666.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','239557',4595886,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','239557',4595887,'1831','270',2115747.09,2117497.04,1749.95,288741.75,0.00,0.00,0.00,0.00,0.00),('5','90','673','239557',4595888,'1832','271',649326.68,649566.45,239.77,82720.65,0.00,0.00,0.00,0.00,0.00),('5','90','674','239557',4595889,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','239809',4600343,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','239809',4600344,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','239809',4600345,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','239809',4600346,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','239809',4600347,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','239809',4600348,'1829','270',462985.34,466714.78,3729.44,615357.60,0.00,0.00,0.00,0.00,0.00),('5','90','672','239809',4600349,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','239809',4600350,'1831','270',2117497.04,2122305.88,4808.84,793458.60,0.00,0.00,0.00,0.00,0.00),('5','90','673','239809',4600351,'1832','271',649566.45,650093.73,527.28,181911.60,0.00,0.00,0.00,0.00,0.00),('5','90','674','239809',4600352,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240080',4605134,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240080',4605135,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240080',4605136,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','240080',4605137,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240080',4605138,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240080',4605139,'1829','270',466714.78,468486.91,1772.13,292401.45,0.00,0.00,0.00,0.00,0.00),('5','90','672','240080',4605140,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240080',4605141,'1831','270',2122305.88,2123561.87,1255.99,207238.35,0.00,0.00,0.00,0.00,0.00),('5','90','673','240080',4605142,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','240080',4605143,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240268',4608550,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240268',4608551,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240268',4608552,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','240268',4608553,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240268',4608554,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240268',4608555,'1829','270',468486.91,470433.19,1946.28,321136.20,0.00,0.00,0.00,0.00,0.00),('5','90','672','240268',4608556,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240268',4608557,'1831','270',2123561.87,2125355.19,1793.32,295897.80,0.00,0.00,0.00,0.00,0.00),('5','90','673','240268',4608558,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','240268',4608559,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240486',4611764,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240486',4611765,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240486',4611766,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','240486',4611767,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240486',4611768,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240486',4611769,'1829','270',470433.19,473143.94,2710.75,447273.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','240486',4611770,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240486',4611771,'1831','270',2125355.19,2126670.32,1315.13,216996.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','240486',4611772,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','240486',4611773,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240704',4615147,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240704',4615148,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240704',4615149,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','240704',4615150,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240704',4615151,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240704',4615152,'1829','270',473143.94,474862.98,1719.04,283641.60,0.00,0.00,0.00,0.00,0.00),('5','90','672','240704',4615153,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240704',4615154,'1831','270',2126670.32,2128266.76,1596.44,263412.60,0.00,0.00,0.00,0.00,0.00),('5','90','673','240704',4615155,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','240704',4615156,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240998',4620325,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240998',4620326,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','240998',4620327,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','240998',4620328,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','240998',4620329,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240998',4620330,'1829','270',474862.98,475322.97,459.99,75898.35,0.00,0.00,0.00,0.00,0.00),('5','90','672','240998',4620331,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','240998',4620332,'1831','270',2128266.76,2128887.82,621.06,102474.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','240998',4620333,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','240998',4620334,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','241230',4624591,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','241230',4624592,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','241230',4624593,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','241230',4624594,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','241230',4624595,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','241230',4624596,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','241230',4624597,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','241230',4624598,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','241230',4624599,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','241230',4624600,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','241569',4630360,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','241569',4630361,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','241569',4630362,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','241569',4630363,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','241569',4630364,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','241569',4630365,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','241569',4630366,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','241569',4630367,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','241569',4630368,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','241569',4630369,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','241807',4634432,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','241807',4634433,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','241807',4634434,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','241807',4634435,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','241807',4634436,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','241807',4634437,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','241807',4634438,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','241807',4634439,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','241807',4634440,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','241807',4634441,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242152',4640690,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242152',4640691,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242152',4640692,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','242152',4640693,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242152',4640694,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242152',4640695,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','242152',4640696,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242152',4640697,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','242152',4640698,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','242152',4640699,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242389',4644911,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242389',4644912,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242389',4644913,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','242389',4644914,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242389',4644915,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242389',4644916,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','242389',4644917,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242389',4644918,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','242389',4644919,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','242389',4644920,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242519',4646979,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242519',4646980,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242519',4646981,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','242519',4646982,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242519',4646983,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242519',4646984,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','242519',4646985,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242519',4646986,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','242519',4646987,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','242519',4646988,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242781',4651579,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242781',4651580,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242781',4651581,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','242781',4651582,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242781',4651583,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242781',4651584,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','242781',4651585,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242781',4651586,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','242781',4651587,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','242781',4651588,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242986',4654987,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242986',4654988,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','242986',4654989,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','242986',4654990,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','242986',4654991,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242986',4654992,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','242986',4654993,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','242986',4654994,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','242986',4654995,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','242986',4654996,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','243277',4660225,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','243277',4660226,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','243277',4660227,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','243277',4660228,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','243277',4660229,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','243277',4660230,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','243277',4660231,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','243277',4660232,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','243277',4660233,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','243277',4660234,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','243454',4663355,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','243454',4663356,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','243454',4663357,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','243454',4663358,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','243454',4663359,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','243454',4663360,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','243454',4663361,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','243454',4663362,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','243454',4663363,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','243454',4663364,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','243791',4669390,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','243791',4669391,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','243791',4669392,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','243791',4669393,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','243791',4669394,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','243791',4669395,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','243791',4669396,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','243791',4669397,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','243791',4669398,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','243791',4669399,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','243977',4672498,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','243977',4672499,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','243977',4672500,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','243977',4672501,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','243977',4672502,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','243977',4672503,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','243977',4672504,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','243977',4672505,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','243977',4672506,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','243977',4672507,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','244155',4675402,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','244155',4675403,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','244155',4675404,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','244155',4675405,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','244155',4675406,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','244155',4675407,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','244155',4675408,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','244155',4675409,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','244155',4675410,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','244155',4675411,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','244440',4680420,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','244440',4680421,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','244440',4680422,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','244440',4680423,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','244440',4680424,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','244440',4680425,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','244440',4680426,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','244440',4680427,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','244440',4680428,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','244440',4680429,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','244706',4685037,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','244706',4685038,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','244706',4685039,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','244706',4685040,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','244706',4685041,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','244706',4685042,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','244706',4685043,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','244706',4685044,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','244706',4685045,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','244706',4685046,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','244881',4688049,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','244881',4688050,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','244881',4688051,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','244881',4688052,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','244881',4688053,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','244881',4688054,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','244881',4688055,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','244881',4688056,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','244881',4688057,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','244881',4688058,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','245089',4691653,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','245089',4691654,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','245089',4691655,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','245089',4691656,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','245089',4691657,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','245089',4691658,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','245089',4691659,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','245089',4691660,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','245089',4691661,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','245089',4691662,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','245621',4701112,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','245621',4701113,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','245621',4701114,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','245621',4701115,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','245621',4701116,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','245621',4701117,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','245621',4701118,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','245621',4701119,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','245621',4701120,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','245621',4701121,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','245901',4705456,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','245901',4705457,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','245901',4705458,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','245901',4705459,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','245901',4705460,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','245901',4705461,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','245901',4705462,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','245901',4705463,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','245901',4705464,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','245901',4705465,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','245970',4706247,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','245970',4706248,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','245970',4706249,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','245970',4706250,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','245970',4706251,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','245970',4706252,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','245970',4706253,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','245970',4706254,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','245970',4706255,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','245970',4706256,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','246635',4717821,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','246635',4717822,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','246635',4717823,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','246635',4717824,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','246635',4717825,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','246635',4717826,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','246635',4717827,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','246635',4717828,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','246635',4717829,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','246635',4717830,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','246724',4719038,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','246724',4719039,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','246724',4719040,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','246724',4719041,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','246724',4719042,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','246724',4719043,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','246724',4719044,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','246724',4719045,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','246724',4719046,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','246724',4719047,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','247048',4724758,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','247048',4724759,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','247048',4724760,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','247048',4724761,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','247048',4724762,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','247048',4724763,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','247048',4724764,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','247048',4724765,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','247048',4724766,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','247048',4724767,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','247245',4728203,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','247245',4728204,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','247245',4728205,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','247245',4728206,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','247245',4728207,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','247245',4728208,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','247245',4728209,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','247245',4728210,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','247245',4728211,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','247245',4728212,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','247599',4734345,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','247599',4734346,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','247599',4734347,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','247599',4734348,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','247599',4734349,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','247599',4734350,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','247599',4734351,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','247599',4734352,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','247599',4734353,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','247599',4734354,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','247849',4738638,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','247849',4738639,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','247849',4738640,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','247849',4738641,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','247849',4738642,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','247849',4738643,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','247849',4738644,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','247849',4738645,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','247849',4738646,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','247849',4738647,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248117',4743285,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248117',4743286,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248117',4743287,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','248117',4743288,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248117',4743289,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248117',4743290,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','248117',4743291,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248117',4743292,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','248117',4743293,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','248117',4743294,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248520',4750076,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248520',4750077,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248520',4750078,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','248520',4750079,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248520',4750080,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248520',4750081,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','248520',4750082,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248520',4750083,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','248520',4750084,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','248520',4750085,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248613',4751591,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248613',4751592,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248613',4751593,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','248613',4751594,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248613',4751595,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248613',4751596,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','248613',4751597,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248613',4751598,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','248613',4751599,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','248613',4751600,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248818',4755170,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248818',4755171,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248818',4755172,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','248818',4755173,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248818',4755174,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248818',4755175,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','248818',4755176,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248818',4755177,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','248818',4755178,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','248818',4755179,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248934',4756833,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248934',4756834,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','248934',4756835,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','248934',4756836,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','248934',4756837,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248934',4756838,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','248934',4756839,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','248934',4756840,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','248934',4756841,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','248934',4756842,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','249198',4761243,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','249198',4761244,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','249198',4761245,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','249198',4761246,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','249198',4761247,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','249198',4761248,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','249198',4761249,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','249198',4761250,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','249198',4761251,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','249198',4761252,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','249399',4764591,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','249399',4764592,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','249399',4764593,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','249399',4764594,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','249399',4764595,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','249399',4764596,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','249399',4764597,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','249399',4764598,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','249399',4764599,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','249399',4764600,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','249714',4770014,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','249714',4770015,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','249714',4770016,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','249714',4770017,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','249714',4770018,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','249714',4770019,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','249714',4770020,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','249714',4770021,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','249714',4770022,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','249714',4770023,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','249959',4774339,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','249959',4774340,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','249959',4774341,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','249959',4774342,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','249959',4774343,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','249959',4774344,'1829','270',475322.97,475322.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','249959',4774345,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','249959',4774346,'1831','270',2128887.82,2128887.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','249959',4774347,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','249959',4774348,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','250180',4777958,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','250180',4777959,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','250180',4777960,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','250180',4777961,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','250180',4777962,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','250180',4777963,'1829','270',475322.97,477120.68,1797.71,296622.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','250180',4777964,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','250180',4777965,'1831','270',2128887.82,2129905.66,1017.84,167943.60,0.00,0.00,0.00,0.00,0.00),('5','90','673','250180',4777966,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','250180',4777967,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','250412',4781661,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','250412',4781662,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','250412',4781663,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','250412',4781664,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','250412',4781665,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','250412',4781666,'1829','270',477120.68,479013.91,1893.23,312382.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','250412',4781667,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','250412',4781668,'1831','270',2129905.66,2131640.90,1735.24,286314.60,0.00,0.00,0.00,0.00,0.00),('5','90','673','250412',4781669,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','250412',4781670,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','250600',4784853,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','250600',4784854,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','250600',4784855,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','250600',4784856,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','250600',4784857,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','250600',4784858,'1829','270',479013.91,481071.49,2057.58,339500.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','250600',4784859,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','250600',4784860,'1831','270',2131640.90,2134135.08,2494.18,411539.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','250600',4784861,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','250600',4784862,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','250993',4792105,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','250993',4792106,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','250993',4792107,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','250993',4792108,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','250993',4792109,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','250993',4792110,'1829','270',481071.49,486275.22,5203.73,858615.45,0.00,0.00,0.00,0.00,0.00),('5','90','672','250993',4792111,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','250993',4792112,'1831','270',2134135.08,2139239.65,5104.57,842254.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','250993',4792113,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','250993',4792114,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','251061',4793008,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','251061',4793009,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','251061',4793010,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','251061',4793011,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','251061',4793012,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','251061',4793013,'1829','270',486275.22,490770.61,4495.39,741739.35,0.00,0.00,0.00,0.00,0.00),('5','90','672','251061',4793014,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','251061',4793015,'1831','270',2139239.65,2143311.67,4072.02,671883.30,0.00,0.00,0.00,0.00,0.00),('5','90','673','251061',4793016,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','251061',4793017,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','251365',4798325,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','251365',4798326,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','251365',4798327,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','251365',4798328,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','251365',4798329,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','251365',4798330,'1829','270',490770.61,495473.41,4702.80,775962.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','251365',4798331,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','251365',4798332,'1831','270',2143311.67,2148140.55,4828.88,796765.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','251365',4798333,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','251365',4798334,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','251587',4802045,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','251587',4802046,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','251587',4802047,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','251587',4802048,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','251587',4802049,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','251587',4802050,'1829','270',495473.41,500272.69,4799.28,791881.20,0.00,0.00,0.00,0.00,0.00),('5','90','672','251587',4802051,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','251587',4802052,'1831','270',2148140.55,2152593.83,4453.28,734791.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','251587',4802053,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','251587',4802054,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','251915',4808031,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','251915',4808032,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','251915',4808033,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','251915',4808034,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','251915',4808035,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','251915',4808036,'1829','270',500272.69,502236.80,1964.11,324078.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','251915',4808037,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','251915',4808038,'1831','270',2152593.83,2154568.37,1974.54,325799.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','251915',4808039,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','251915',4808040,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','252157',4812240,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','252157',4812241,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','252157',4812242,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','252157',4812243,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','252157',4812244,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','252157',4812245,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','252157',4812246,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','252157',4812247,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','252157',4812248,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','252157',4812249,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','252372',4815976,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','252372',4815977,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','252372',4815978,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','252372',4815979,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','252372',4815980,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','252372',4815981,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','252372',4815982,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','252372',4815983,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','252372',4815984,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','252372',4815985,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','252525',4818627,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','252525',4818628,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','252525',4818629,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','252525',4818630,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','252525',4818631,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','252525',4818632,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','252525',4818633,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','252525',4818634,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','252525',4818635,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','252525',4818636,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','252752',4822496,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','252752',4822497,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','252752',4822498,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','252752',4822499,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','252752',4822500,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','252752',4822501,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','252752',4822502,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','252752',4822503,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','252752',4822504,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','252752',4822505,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','253067',4827765,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','253067',4827766,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','253067',4827767,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','253067',4827768,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','253067',4827769,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','253067',4827770,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','253067',4827771,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','253067',4827772,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','253067',4827773,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','253067',4827774,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','253249',4830736,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','253249',4830737,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','253249',4830738,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','253249',4830739,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','253249',4830740,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','253249',4830741,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','253249',4830742,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','253249',4830743,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','253249',4830744,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','253249',4830745,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','253542',4835715,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','253542',4835716,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','253542',4835717,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','253542',4835718,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','253542',4835719,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','253542',4835720,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','253542',4835721,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','253542',4835722,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','253542',4835723,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','253542',4835724,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','253836',4841017,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','253836',4841018,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','253836',4841019,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','253836',4841020,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','253836',4841021,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','253836',4841022,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','253836',4841023,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','253836',4841024,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','253836',4841025,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','253836',4841026,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','254138',4846493,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','254138',4846494,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','254138',4846495,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','254138',4846496,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','254138',4846497,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','254138',4846498,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','254138',4846499,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','254138',4846500,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','254138',4846501,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','254138',4846502,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','254237',4847908,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','254237',4847909,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','254237',4847910,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','254237',4847911,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','254237',4847912,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','254237',4847913,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','254237',4847914,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','254237',4847915,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','254237',4847916,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','254237',4847917,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','254669',4855763,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','254669',4855764,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','254669',4855765,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','254669',4855766,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','254669',4855767,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','254669',4855768,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','254669',4855769,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','254669',4855770,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','254669',4855771,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','254669',4855772,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','254843',4858482,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','254843',4858483,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','254843',4858484,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','254843',4858485,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','254843',4858486,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','254843',4858487,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','254843',4858488,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','254843',4858489,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','254843',4858490,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','254843',4858491,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','255049',4862074,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','255049',4862075,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','255049',4862076,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','255049',4862077,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','255049',4862078,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','255049',4862079,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','255049',4862080,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','255049',4862081,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','255049',4862082,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','255049',4862083,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','255272',4865882,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','255272',4865883,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','255272',4865884,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','255272',4865885,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','255272',4865886,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','255272',4865887,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','255272',4865888,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','255272',4865889,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','255272',4865890,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','255272',4865891,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','255604',4871326,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','255604',4871327,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','255604',4871328,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','255604',4871329,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','255604',4871330,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','255604',4871331,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','255604',4871332,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','255604',4871333,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','255604',4871334,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','255604',4871335,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','255921',4876786,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','255921',4876787,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','255921',4876788,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','255921',4876789,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','255921',4876790,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','255921',4876791,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','255921',4876792,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','255921',4876793,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','255921',4876794,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','255921',4876795,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','256142',4880391,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','256142',4880392,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','256142',4880393,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','256142',4880394,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','256142',4880395,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','256142',4880396,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','256142',4880397,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','256142',4880398,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','256142',4880399,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','256142',4880400,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','256586',4887677,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','256586',4887678,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','256586',4887679,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','256586',4887680,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','256586',4887681,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','256586',4887682,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','256586',4887683,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','256586',4887684,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','256586',4887685,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','256586',4887686,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','256915',4893415,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','256915',4893416,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','256915',4893417,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','256915',4893418,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','256915',4893419,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','256915',4893420,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','256915',4893421,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','256915',4893422,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','256915',4893423,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','256915',4893424,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257080',4896218,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257080',4896219,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257080',4896220,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257080',4896221,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257080',4896222,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257080',4896223,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257080',4896224,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257080',4896225,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257080',4896226,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257080',4896227,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257470',4903347,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257470',4903348,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257470',4903349,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257470',4903350,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257470',4903351,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257470',4903352,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257470',4903353,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257470',4903354,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257470',4903355,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257470',4903356,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257523',4903854,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257523',4903855,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257523',4903856,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257523',4903857,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257523',4903858,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257523',4903859,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257523',4903860,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257523',4903861,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257523',4903862,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257523',4903863,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257524',4903864,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257524',4903865,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257524',4903866,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257524',4903867,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257524',4903868,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257524',4903869,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257524',4903870,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257524',4903871,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257524',4903872,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257524',4903873,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257525',4903874,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257525',4903875,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257525',4903876,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257525',4903877,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257525',4903878,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257525',4903879,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257525',4903880,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257525',4903881,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257525',4903882,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257525',4903883,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257526',4903884,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257526',4903885,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257526',4903886,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257526',4903887,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257526',4903888,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257526',4903889,'1829','270',502236.80,502236.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257526',4903890,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257526',4903891,'1831','270',2154568.37,2154568.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257526',4903892,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257526',4903893,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257527',4903894,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257527',4903895,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257527',4903896,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257527',4903897,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257527',4903898,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257527',4903899,'1829','270',502236.80,505715.16,3478.36,573929.40,0.00,0.00,0.00,0.00,0.00),('5','90','672','257527',4903900,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257527',4903901,'1831','270',2154568.37,2157718.18,3149.81,519718.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257527',4903902,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257527',4903903,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257528',4903904,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257528',4903905,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257528',4903906,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257528',4903907,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257528',4903908,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257528',4903909,'1829','270',505715.16,507917.27,2202.11,363348.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257528',4903910,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257528',4903911,'1831','270',2157718.18,2159117.39,1399.21,230869.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257528',4903912,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257528',4903913,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257529',4903914,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257529',4903915,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257529',4903916,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257529',4903917,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257529',4903918,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257529',4903919,'1829','270',507917.27,510744.36,2827.09,466469.85,0.00,0.00,0.00,0.00,0.00),('5','90','672','257529',4903920,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257529',4903921,'1831','270',2159117.39,2161591.24,2473.85,408185.25,0.00,0.00,0.00,0.00,0.00),('5','90','673','257529',4903922,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257529',4903923,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257530',4903924,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257530',4903925,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257530',4903926,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257530',4903927,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257530',4903928,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257530',4903929,'1829','270',510744.36,513148.83,2404.47,396737.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257530',4903930,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257530',4903931,'1831','270',2161591.24,2164128.56,2537.32,418657.80,0.00,0.00,0.00,0.00,0.00),('5','90','673','257530',4903932,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257530',4903933,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257531',4903934,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257531',4903935,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257531',4903936,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257531',4903937,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257531',4903938,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257531',4903939,'1829','270',513148.83,515662.68,2513.85,414785.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','257531',4903940,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257531',4903941,'1831','270',2164128.56,2166991.19,2862.63,472333.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','257531',4903942,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257531',4903943,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257532',4903944,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257532',4903945,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257532',4903946,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257532',4903947,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257532',4903948,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257532',4903949,'1829','270',515662.68,517144.38,1481.70,244480.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','257532',4903950,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257532',4903951,'1831','270',2166991.19,2168551.69,1560.50,257482.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','257532',4903952,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257532',4903953,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257533',4903954,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257533',4903955,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257533',4903956,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257533',4903957,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257533',4903958,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257533',4903959,'1829','270',517144.38,517683.46,539.08,88948.20,0.00,0.00,0.00,0.00,0.00),('5','90','672','257533',4903960,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257533',4903961,'1831','270',2168551.69,2169084.05,532.36,87839.40,0.00,0.00,0.00,0.00,0.00),('5','90','673','257533',4903962,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257533',4903963,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257534',4903964,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257534',4903965,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257534',4903966,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257534',4903967,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257534',4903968,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257534',4903969,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257534',4903970,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257534',4903971,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257534',4903972,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257534',4903973,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257535',4903974,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257535',4903975,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257535',4903976,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257535',4903977,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257535',4903978,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257535',4903979,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257535',4903980,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257535',4903981,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257535',4903982,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257535',4903983,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257536',4903984,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257536',4903985,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257536',4903986,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257536',4903987,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257536',4903988,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257536',4903989,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257536',4903990,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257536',4903991,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257536',4903992,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257536',4903993,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257537',4903994,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257537',4903995,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257537',4903996,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257537',4903997,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257537',4903998,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257537',4903999,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257537',4904000,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257537',4904001,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257537',4904002,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257537',4904003,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257538',4904004,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257538',4904005,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257538',4904006,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257538',4904007,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257538',4904008,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257538',4904009,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257538',4904010,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257538',4904011,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257538',4904012,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257538',4904013,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257539',4904014,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257539',4904015,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257539',4904016,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257539',4904017,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257539',4904018,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257539',4904019,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257539',4904020,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257539',4904021,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257539',4904022,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257539',4904023,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257540',4904024,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257540',4904025,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257540',4904026,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257540',4904027,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257540',4904028,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257540',4904029,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257540',4904030,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257540',4904031,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257540',4904032,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257540',4904033,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257541',4904034,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257541',4904035,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257541',4904036,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257541',4904037,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257541',4904038,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257541',4904039,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257541',4904040,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257541',4904041,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257541',4904042,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257541',4904043,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257542',4904044,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257542',4904045,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257542',4904046,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257542',4904047,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257542',4904048,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257542',4904049,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257542',4904050,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257542',4904051,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257542',4904052,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257542',4904053,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257543',4904054,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257543',4904055,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257543',4904056,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257543',4904057,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257543',4904058,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257543',4904059,'1829','270',517683.46,517683.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257543',4904060,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257543',4904061,'1831','270',2169084.05,2169084.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257543',4904062,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257543',4904063,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257544',4904064,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257544',4904065,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257544',4904066,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257544',4904067,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257544',4904068,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257544',4904069,'1829','270',517683.46,520018.13,2334.67,385220.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257544',4904070,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257544',4904071,'1831','270',2169084.05,2171909.95,2825.90,466273.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','257544',4904072,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257544',4904073,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257545',4904074,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257545',4904075,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257545',4904076,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257545',4904077,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257545',4904078,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257545',4904079,'1829','270',520018.13,524026.93,4008.80,661452.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257545',4904080,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257545',4904081,'1831','270',2171909.95,2175429.72,3519.77,580762.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','257545',4904082,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257545',4904083,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257546',4904084,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257546',4904085,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257546',4904086,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257546',4904087,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257546',4904088,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257546',4904089,'1829','270',524026.93,524305.06,278.13,45891.45,0.00,0.00,0.00,0.00,0.00),('5','90','672','257546',4904090,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257546',4904091,'1831','270',2175429.72,2175429.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257546',4904092,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257546',4904093,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257547',4904094,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257547',4904095,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257547',4904096,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257547',4904097,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257547',4904098,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257547',4904099,'1829','270',524305.06,524305.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257547',4904100,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257547',4904101,'1831','270',2175429.72,2175429.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257547',4904102,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257547',4904103,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257548',4904104,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257548',4904105,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257548',4904106,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257548',4904107,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257548',4904108,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257548',4904109,'1829','270',524305.06,524305.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257548',4904110,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257548',4904111,'1831','270',2175429.72,2175429.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257548',4904112,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257548',4904113,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257549',4904114,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257549',4904115,'1825','270',341422.22,341422.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257549',4904116,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257549',4904117,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257549',4904118,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257549',4904119,'1829','270',524305.06,524305.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257549',4904120,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257549',4904121,'1831','270',2175429.72,2175429.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257549',4904122,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257549',4904123,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257550',4904124,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257550',4904125,'1825','270',341422.22,342056.93,634.71,104727.15,0.00,0.00,0.00,0.00,0.00),('5','90','671','257550',4904126,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257550',4904127,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257550',4904128,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257550',4904129,'1829','270',524305.06,524305.06,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257550',4904130,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257550',4904131,'1831','270',2175429.72,2175694.99,265.27,43769.55,0.00,0.00,0.00,0.00,0.00),('5','90','673','257550',4904132,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257550',4904133,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257551',4904134,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257551',4904135,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257551',4904136,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257551',4904137,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257551',4904138,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257551',4904139,'1829','270',524305.06,531548.81,7243.75,1195218.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','257551',4904140,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257551',4904141,'1831','270',2175694.99,2182018.58,6323.59,1043392.35,0.00,0.00,0.00,0.00,0.00),('5','90','673','257551',4904142,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257551',4904143,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257552',4904144,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257552',4904145,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257552',4904146,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257552',4904147,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257552',4904148,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257552',4904149,'1829','270',531548.81,539373.66,7824.85,1291100.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','257552',4904150,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257552',4904151,'1831','270',2182018.58,2185115.18,3096.60,510939.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257552',4904152,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257552',4904153,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257553',4904154,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257553',4904155,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257553',4904156,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257553',4904157,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257553',4904158,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257553',4904159,'1829','270',539373.66,539400.53,26.87,4433.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257553',4904160,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257553',4904161,'1831','270',2185115.18,2190531.96,5416.78,893768.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','257553',4904162,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257553',4904163,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257554',4904164,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257554',4904165,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257554',4904166,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257554',4904167,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257554',4904168,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257554',4904169,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257554',4904170,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257554',4904171,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257554',4904172,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257554',4904173,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257555',4904174,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257555',4904175,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257555',4904176,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257555',4904177,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257555',4904178,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257555',4904179,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257555',4904180,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257555',4904181,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257555',4904182,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257555',4904183,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257556',4904184,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257556',4904185,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257556',4904186,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257556',4904187,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257556',4904188,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257556',4904189,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257556',4904190,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257556',4904191,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257556',4904192,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257556',4904193,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257557',4904194,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257557',4904195,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257557',4904196,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257557',4904197,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257557',4904198,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257557',4904199,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257557',4904200,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257557',4904201,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257557',4904202,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257557',4904203,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257558',4904204,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257558',4904205,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257558',4904206,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257558',4904207,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257558',4904208,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257558',4904209,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257558',4904210,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257558',4904211,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257558',4904212,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257558',4904213,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257559',4904214,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257559',4904215,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257559',4904216,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257559',4904217,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257559',4904218,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257559',4904219,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257559',4904220,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257559',4904221,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257559',4904222,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257559',4904223,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257560',4904224,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257560',4904225,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257560',4904226,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257560',4904227,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257560',4904228,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257560',4904229,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257560',4904230,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257560',4904231,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257560',4904232,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257560',4904233,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257561',4904234,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257561',4904235,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257561',4904236,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257561',4904237,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257561',4904238,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257561',4904239,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257561',4904240,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257561',4904241,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257561',4904242,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257561',4904243,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257562',4904244,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257562',4904245,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257562',4904246,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257562',4904247,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257562',4904248,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257562',4904249,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257562',4904250,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257562',4904251,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257562',4904252,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257562',4904253,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257563',4904254,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257563',4904255,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257563',4904256,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257563',4904257,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257563',4904258,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257563',4904259,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257563',4904260,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257563',4904261,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257563',4904262,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257563',4904263,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257564',4904264,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257564',4904265,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257564',4904266,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257564',4904267,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257564',4904268,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257564',4904269,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257564',4904270,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257564',4904271,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257564',4904272,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257564',4904273,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257565',4904274,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257565',4904275,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257565',4904276,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257565',4904277,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257565',4904278,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257565',4904279,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257565',4904280,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257565',4904281,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257565',4904282,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257565',4904283,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257566',4904284,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257566',4904285,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257566',4904286,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257566',4904287,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257566',4904288,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257566',4904289,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257566',4904290,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257566',4904291,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257566',4904292,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257566',4904293,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257567',4904294,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257567',4904295,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257567',4904296,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257567',4904297,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257567',4904298,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257567',4904299,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257567',4904300,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257567',4904301,'1831','270',2190531.96,2190531.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257567',4904302,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257567',4904303,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257568',4904304,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257568',4904305,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257568',4904306,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257568',4904307,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257568',4904308,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257568',4904309,'1829','270',539400.53,539400.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257568',4904310,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257568',4904311,'1831','270',2190531.96,2190931.96,400.00,66000.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257568',4904312,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257568',4904313,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257569',4904314,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257569',4904315,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257569',4904316,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257569',4904317,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257569',4904318,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257569',4904319,'1829','270',539400.53,544063.80,4663.27,769439.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257569',4904320,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257569',4904321,'1831','270',2190931.96,2194397.50,3465.54,571814.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','257569',4904322,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257569',4904323,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257570',4904324,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257570',4904325,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257570',4904326,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257570',4904327,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257570',4904328,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257570',4904329,'1829','270',544063.80,547436.24,3372.44,556452.60,0.00,0.00,0.00,0.00,0.00),('5','90','672','257570',4904330,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257570',4904331,'1831','270',2194397.50,2195392.16,994.66,164118.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','257570',4904332,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257570',4904333,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257571',4904334,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257571',4904335,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257571',4904336,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257571',4904337,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257571',4904338,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257571',4904339,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257571',4904340,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257571',4904341,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257571',4904342,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257571',4904343,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257572',4904344,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257572',4904345,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257572',4904346,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257572',4904347,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257572',4904348,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257572',4904349,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257572',4904350,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257572',4904351,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257572',4904352,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257572',4904353,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257573',4904354,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257573',4904355,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257573',4904356,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257573',4904357,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257573',4904358,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257573',4904359,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257573',4904360,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257573',4904361,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257573',4904362,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257573',4904363,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257574',4904364,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257574',4904365,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257574',4904366,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257574',4904367,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257574',4904368,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257574',4904369,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257574',4904370,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257574',4904371,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257574',4904372,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257574',4904373,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257575',4904374,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257575',4904375,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257575',4904376,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257575',4904377,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257575',4904378,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257575',4904379,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257575',4904380,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257575',4904381,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257575',4904382,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257575',4904383,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257576',4904384,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257576',4904385,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257576',4904386,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257576',4904387,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257576',4904388,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257576',4904389,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257576',4904390,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257576',4904391,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257576',4904392,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257576',4904393,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257577',4904394,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257577',4904395,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257577',4904396,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257577',4904397,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257577',4904398,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257577',4904399,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257577',4904400,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257577',4904401,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257577',4904402,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257577',4904403,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257578',4904404,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257578',4904405,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257578',4904406,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257578',4904407,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257578',4904408,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257578',4904409,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257578',4904410,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257578',4904411,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257578',4904412,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257578',4904413,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257579',4904414,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257579',4904415,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257579',4904416,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257579',4904417,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257579',4904418,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257579',4904419,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257579',4904420,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257579',4904421,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257579',4904422,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257579',4904423,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257580',4904424,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257580',4904425,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257580',4904426,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257580',4904427,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257580',4904428,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257580',4904429,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257580',4904430,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257580',4904431,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257580',4904432,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257580',4904433,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257581',4904434,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257581',4904435,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257581',4904436,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257581',4904437,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257581',4904438,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257581',4904439,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257581',4904440,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257581',4904441,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257581',4904442,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257581',4904443,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257582',4904444,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257582',4904445,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257582',4904446,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257582',4904447,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257582',4904448,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257582',4904449,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257582',4904450,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257582',4904451,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257582',4904452,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257582',4904453,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257583',4904454,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257583',4904455,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257583',4904456,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257583',4904457,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257583',4904458,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257583',4904459,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257583',4904460,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257583',4904461,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257583',4904462,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257583',4904463,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257584',4904464,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257584',4904465,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257584',4904466,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257584',4904467,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257584',4904468,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257584',4904469,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257584',4904470,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257584',4904471,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257584',4904472,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257584',4904473,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257585',4904474,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257585',4904475,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257585',4904476,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257585',4904477,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257585',4904478,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257585',4904479,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257585',4904480,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257585',4904481,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257585',4904482,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257585',4904483,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257586',4904484,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257586',4904485,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257586',4904486,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257586',4904487,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257586',4904488,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257586',4904489,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257586',4904490,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257586',4904491,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257586',4904492,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257586',4904493,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257587',4904494,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257587',4904495,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257587',4904496,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257587',4904497,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257587',4904498,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257587',4904499,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257587',4904500,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257587',4904501,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257587',4904502,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257587',4904503,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257588',4904504,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257588',4904505,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257588',4904506,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257588',4904507,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257588',4904508,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257588',4904509,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257588',4904510,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257588',4904511,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257588',4904512,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257588',4904513,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257589',4904514,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257589',4904515,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257589',4904516,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257589',4904517,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257589',4904518,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257589',4904519,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257589',4904520,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257589',4904521,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257589',4904522,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257589',4904523,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257590',4904524,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257590',4904525,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257590',4904526,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257590',4904527,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257590',4904528,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257590',4904529,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257590',4904530,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257590',4904531,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257590',4904532,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257590',4904533,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257591',4904534,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257591',4904535,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257591',4904536,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257591',4904537,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257591',4904538,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257591',4904539,'1829','270',547436.24,547436.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257591',4904540,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257591',4904541,'1831','270',2195392.16,2195392.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257591',4904542,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257591',4904543,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257592',4904544,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257592',4904545,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257592',4904546,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257592',4904547,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257592',4904548,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257592',4904549,'1829','270',547436.24,548807.87,1371.63,226318.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','257592',4904550,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257592',4904551,'1831','270',2195392.16,2197165.27,1773.11,292563.15,0.00,0.00,0.00,0.00,0.00),('5','90','673','257592',4904552,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257592',4904553,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257593',4904554,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257593',4904555,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257593',4904556,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257593',4904557,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257593',4904558,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257593',4904559,'1829','270',548807.87,552416.67,3608.80,595452.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257593',4904560,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257593',4904561,'1831','270',2197165.27,2199524.49,2359.22,389271.30,0.00,0.00,0.00,0.00,0.00),('5','90','673','257593',4904562,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257593',4904563,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257594',4904564,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257594',4904565,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257594',4904566,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257594',4904567,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257594',4904568,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257594',4904569,'1829','270',552416.67,554231.38,1814.71,299427.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257594',4904570,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257594',4904571,'1831','270',2199524.49,2200881.86,1357.37,223966.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','257594',4904572,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257594',4904573,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257595',4904574,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257595',4904575,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257595',4904576,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257595',4904577,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257595',4904578,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257595',4904579,'1829','270',554231.38,556141.07,1909.69,315098.85,0.00,0.00,0.00,0.00,0.00),('5','90','672','257595',4904580,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257595',4904581,'1831','270',2200881.86,2201702.61,820.75,135423.75,0.00,0.00,0.00,0.00,0.00),('5','90','673','257595',4904582,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257595',4904583,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257596',4904584,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257596',4904585,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257596',4904586,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257596',4904587,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257596',4904588,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257596',4904589,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257596',4904590,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257596',4904591,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257596',4904592,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257596',4904593,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257597',4904594,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257597',4904595,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257597',4904596,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257597',4904597,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257597',4904598,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257597',4904599,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257597',4904600,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257597',4904601,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257597',4904602,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257597',4904603,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257598',4904604,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257598',4904605,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257598',4904606,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257598',4904607,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257598',4904608,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257598',4904609,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257598',4904610,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257598',4904611,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257598',4904612,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257598',4904613,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257599',4904614,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257599',4904615,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257599',4904616,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257599',4904617,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257599',4904618,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257599',4904619,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257599',4904620,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257599',4904621,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257599',4904622,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257599',4904623,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257600',4904624,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257600',4904625,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257600',4904626,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257600',4904627,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257600',4904628,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257600',4904629,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257600',4904630,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257600',4904631,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257600',4904632,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257600',4904633,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257601',4904634,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257601',4904635,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257601',4904636,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257601',4904637,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257601',4904638,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257601',4904639,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257601',4904640,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257601',4904641,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257601',4904642,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257601',4904643,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257602',4904644,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257602',4904645,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257602',4904646,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257602',4904647,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257602',4904648,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257602',4904649,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257602',4904650,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257602',4904651,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257602',4904652,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257602',4904653,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257603',4904654,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257603',4904655,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257603',4904656,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257603',4904657,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257603',4904658,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257603',4904659,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257603',4904660,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257603',4904661,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257603',4904662,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257603',4904663,'1833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257604',4904664,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257604',4904665,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257604',4904666,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257604',4904667,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257604',4904668,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257604',4904669,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257604',4904670,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257604',4904671,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257604',4904672,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257604',4904673,'1833','272',0.00,40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257605',4904674,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257605',4904675,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257605',4904676,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257605',4904677,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257605',4904678,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257605',4904679,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257605',4904680,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257605',4904681,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257605',4904682,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257605',4904683,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257606',4904684,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257606',4904685,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257606',4904686,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257606',4904687,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257606',4904688,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257606',4904689,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257606',4904690,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257606',4904691,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257606',4904692,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257606',4904693,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257607',4904694,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257607',4904695,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257607',4904696,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257607',4904697,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257607',4904698,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257607',4904699,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257607',4904700,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257607',4904701,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257607',4904702,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257607',4904703,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257608',4904704,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257608',4904705,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257608',4904706,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257608',4904707,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257608',4904708,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257608',4904709,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257608',4904710,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257608',4904711,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257608',4904712,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257608',4904713,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257609',4904714,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257609',4904715,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257609',4904716,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257609',4904717,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257609',4904718,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257609',4904719,'1829','270',556141.07,556141.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257609',4904720,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257609',4904721,'1831','270',2201702.61,2201702.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257609',4904722,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257609',4904723,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257610',4904724,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257610',4904725,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257610',4904726,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257610',4904727,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257610',4904728,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257610',4904729,'1829','270',556141.07,557558.34,1417.27,233849.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257610',4904730,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257610',4904731,'1831','270',2201702.61,2201908.98,206.37,34051.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','257610',4904732,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257610',4904733,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257611',4904734,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257611',4904735,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257611',4904736,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257611',4904737,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257611',4904738,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257611',4904739,'1829','270',557558.34,561113.08,3554.74,586532.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257611',4904740,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257611',4904741,'1831','270',2201908.98,2204239.95,2330.97,384610.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','257611',4904742,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257611',4904743,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257612',4904744,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257612',4904745,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257612',4904746,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257612',4904747,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257612',4904748,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257612',4904749,'1829','270',561113.08,564325.02,3211.94,529970.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257612',4904750,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257612',4904751,'1831','270',2204239.95,2206394.78,2154.83,355546.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','257612',4904752,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257612',4904753,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257613',4904754,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257613',4904755,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257613',4904756,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257613',4904757,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257613',4904758,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257613',4904759,'1829','270',564325.02,564325.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257613',4904760,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257613',4904761,'1831','270',2206394.78,2206394.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257613',4904762,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257613',4904763,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257614',4904764,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257614',4904765,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257614',4904766,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257614',4904767,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257614',4904768,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257614',4904769,'1829','270',564325.02,565505.40,1180.38,194762.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','257614',4904770,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257614',4904771,'1831','270',2206394.78,2207204.39,809.61,133585.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257614',4904772,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257614',4904773,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257615',4904774,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257615',4904775,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257615',4904776,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257615',4904777,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257615',4904778,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257615',4904779,'1829','270',565505.40,565505.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257615',4904780,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257615',4904781,'1831','270',2207204.39,2207204.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257615',4904782,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257615',4904783,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257616',4904784,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257616',4904785,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257616',4904786,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257616',4904787,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257616',4904788,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257616',4904789,'1829','270',565505.40,565505.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257616',4904790,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257616',4904791,'1831','270',2207204.39,2207204.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257616',4904792,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257616',4904793,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257617',4904794,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257617',4904795,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257617',4904796,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257617',4904797,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257617',4904798,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257617',4904799,'1829','270',565505.40,565505.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257617',4904800,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257617',4904801,'1831','270',2207204.39,2207204.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257617',4904802,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257617',4904803,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257618',4904804,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257618',4904805,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257618',4904806,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257618',4904807,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257618',4904808,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257618',4904809,'1829','270',565505.40,565505.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257618',4904810,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257618',4904811,'1831','270',2207204.39,2207204.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257618',4904812,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257618',4904813,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257619',4904814,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257619',4904815,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257619',4904816,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257619',4904817,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257619',4904818,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257619',4904819,'1829','270',565505.40,565505.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257619',4904820,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257619',4904821,'1831','270',2207204.39,2207204.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257619',4904822,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257619',4904823,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257620',4904824,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257620',4904825,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257620',4904826,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257620',4904827,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257620',4904828,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257620',4904829,'1829','270',565505.40,568557.25,3051.85,503555.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','257620',4904830,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257620',4904831,'1831','270',2207204.39,2210077.09,2872.70,473995.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','257620',4904832,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257620',4904833,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257621',4904834,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257621',4904835,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257621',4904836,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257621',4904837,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257621',4904838,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257621',4904839,'1829','270',568557.25,571839.79,3282.54,541619.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257621',4904840,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257621',4904841,'1831','270',2210077.09,2212137.80,2060.71,340017.15,0.00,0.00,0.00,0.00,0.00),('5','90','673','257621',4904842,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257621',4904843,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257622',4904844,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257622',4904845,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257622',4904846,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257622',4904847,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257622',4904848,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257622',4904849,'1829','270',571839.79,575298.91,3459.12,570754.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','257622',4904850,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257622',4904851,'1831','270',2212137.80,2214551.07,2413.27,398189.55,0.00,0.00,0.00,0.00,0.00),('5','90','673','257622',4904852,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257622',4904853,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257623',4904854,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257623',4904855,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257623',4904856,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257623',4904857,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257623',4904858,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257623',4904859,'1829','270',575298.91,577493.26,2194.35,362067.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','257623',4904860,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257623',4904861,'1831','270',2214551.07,2216935.50,2384.43,393430.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','257623',4904862,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257623',4904863,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257624',4904864,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257624',4904865,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257624',4904866,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257624',4904867,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257624',4904868,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257624',4904869,'1829','270',577493.26,579566.97,2073.71,342162.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257624',4904870,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257624',4904871,'1831','270',2216935.50,2218592.28,1656.78,273368.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','257624',4904872,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257624',4904873,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257625',4904874,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257625',4904875,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257625',4904876,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257625',4904877,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257625',4904878,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257625',4904879,'1829','270',579566.97,581111.39,1544.42,254829.30,0.00,0.00,0.00,0.00,0.00),('5','90','672','257625',4904880,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257625',4904881,'1831','270',2218592.28,2220486.06,1893.78,312473.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','257625',4904882,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257625',4904883,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257626',4904884,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257626',4904885,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257626',4904886,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257626',4904887,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257626',4904888,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257626',4904889,'1829','270',581111.39,581627.98,516.59,85237.35,0.00,0.00,0.00,0.00,0.00),('5','90','672','257626',4904890,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257626',4904891,'1831','270',2220486.06,2220929.11,443.05,73103.25,0.00,0.00,0.00,0.00,0.00),('5','90','673','257626',4904892,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257626',4904893,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257627',4904894,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257627',4904895,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257627',4904896,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257627',4904897,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257627',4904898,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257627',4904899,'1829','270',581627.98,581627.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257627',4904900,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257627',4904901,'1831','270',2220929.11,2220929.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257627',4904902,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257627',4904903,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257628',4904904,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257628',4904905,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257628',4904906,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257628',4904907,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257628',4904908,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257628',4904909,'1829','270',581627.98,581627.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257628',4904910,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257628',4904911,'1831','270',2220929.11,2220929.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257628',4904912,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257628',4904913,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257629',4904914,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257629',4904915,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257629',4904916,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257629',4904917,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257629',4904918,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257629',4904919,'1829','270',581627.98,581627.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257629',4904920,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257629',4904921,'1831','270',2220929.11,2220929.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257629',4904922,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257629',4904923,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257630',4904924,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257630',4904925,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257630',4904926,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257630',4904927,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257630',4904928,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257630',4904929,'1829','270',581627.98,583157.98,1530.00,252450.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257630',4904930,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257630',4904931,'1831','270',2220929.11,2220929.11,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257630',4904932,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257630',4904933,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257631',4904934,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257631',4904935,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257631',4904936,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257631',4904937,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257631',4904938,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257631',4904939,'1829','270',583157.98,583157.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257631',4904940,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257631',4904941,'1831','270',2220929.11,2225043.32,4114.21,678844.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257631',4904942,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257631',4904943,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257632',4904944,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257632',4904945,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257632',4904946,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257632',4904947,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257632',4904948,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257632',4904949,'1829','270',583157.98,586386.38,3228.40,532686.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257632',4904950,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257632',4904951,'1831','270',2225043.32,2227681.42,2638.10,435286.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','257632',4904952,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257632',4904953,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257633',4904954,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257633',4904955,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257633',4904956,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257633',4904957,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257633',4904958,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257633',4904959,'1829','270',586386.38,589675.07,3288.69,542633.85,0.00,0.00,0.00,0.00,0.00),('5','90','672','257633',4904960,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257633',4904961,'1831','270',2227681.42,2227681.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257633',4904962,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257633',4904963,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257634',4904964,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257634',4904965,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257634',4904966,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257634',4904967,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257634',4904968,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257634',4904969,'1829','270',589675.07,589675.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257634',4904970,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257634',4904971,'1831','270',2227681.42,2227681.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257634',4904972,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257634',4904973,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257635',4904974,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257635',4904975,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257635',4904976,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257635',4904977,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257635',4904978,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257635',4904979,'1829','270',589675.07,589675.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257635',4904980,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257635',4904981,'1831','270',2227681.42,2227681.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257635',4904982,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257635',4904983,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257636',4904984,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257636',4904985,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257636',4904986,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257636',4904987,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257636',4904988,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257636',4904989,'1829','270',589675.07,589675.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257636',4904990,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257636',4904991,'1831','270',2227681.42,2227681.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257636',4904992,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257636',4904993,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257637',4904994,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257637',4904995,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257637',4904996,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257637',4904997,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257637',4904998,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257637',4904999,'1829','270',589675.07,589675.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257637',4905000,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257637',4905001,'1831','270',2227681.42,2227681.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257637',4905002,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257637',4905003,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257638',4905004,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257638',4905005,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257638',4905006,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257638',4905007,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257638',4905008,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257638',4905009,'1829','270',589675.07,592928.07,3253.00,536745.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257638',4905010,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257638',4905011,'1831','270',2227681.42,2228972.21,1290.79,212980.35,0.00,0.00,0.00,0.00,0.00),('5','90','673','257638',4905012,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257638',4905013,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257639',4905014,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257639',4905015,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257639',4905016,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257639',4905017,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257639',4905018,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257639',4905019,'1829','270',592928.07,595271.05,2342.98,386591.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','257639',4905020,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257639',4905021,'1831','270',2228972.21,2231077.91,2105.70,347440.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','257639',4905022,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257639',4905023,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257640',4905024,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257640',4905025,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257640',4905026,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257640',4905027,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257640',4905028,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257640',4905029,'1829','270',595271.05,597081.81,1810.76,298775.40,0.00,0.00,0.00,0.00,0.00),('5','90','672','257640',4905030,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257640',4905031,'1831','270',2231077.91,2233077.01,1999.10,329851.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','257640',4905032,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257640',4905033,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257641',4905034,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257641',4905035,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257641',4905036,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257641',4905037,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257641',4905038,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257641',4905039,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257641',4905040,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257641',4905041,'1831','270',2233077.01,2235389.03,2312.02,381483.30,0.00,0.00,0.00,0.00,0.00),('5','90','673','257641',4905042,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257641',4905043,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257642',4905044,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257642',4905045,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257642',4905046,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257642',4905047,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257642',4905048,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257642',4905049,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257642',4905050,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257642',4905051,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257642',4905052,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257642',4905053,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257643',4905054,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257643',4905055,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257643',4905056,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257643',4905057,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257643',4905058,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257643',4905059,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257643',4905060,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257643',4905061,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257643',4905062,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257643',4905063,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257644',4905064,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257644',4905065,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257644',4905066,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257644',4905067,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257644',4905068,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257644',4905069,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257644',4905070,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257644',4905071,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257644',4905072,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257644',4905073,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257645',4905074,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257645',4905075,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257645',4905076,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257645',4905077,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257645',4905078,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257645',4905079,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257645',4905080,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257645',4905081,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257645',4905082,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257645',4905083,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257646',4905084,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257646',4905085,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257646',4905086,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257646',4905087,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257646',4905088,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257646',4905089,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257646',4905090,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257646',4905091,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257646',4905092,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257646',4905093,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257647',4905094,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257647',4905095,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257647',4905096,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257647',4905097,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257647',4905098,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257647',4905099,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257647',4905100,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257647',4905101,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257647',4905102,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257647',4905103,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257648',4905104,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257648',4905105,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257648',4905106,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257648',4905107,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257648',4905108,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257648',4905109,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257648',4905110,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257648',4905111,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257648',4905112,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257648',4905113,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257649',4905114,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257649',4905115,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257649',4905116,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257649',4905117,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257649',4905118,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257649',4905119,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257649',4905120,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257649',4905121,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257649',4905122,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257649',4905123,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257650',4905124,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257650',4905125,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257650',4905126,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257650',4905127,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257650',4905128,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257650',4905129,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257650',4905130,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257650',4905131,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257650',4905132,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257650',4905133,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257651',4905134,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257651',4905135,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257651',4905136,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257651',4905137,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257651',4905138,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257651',4905139,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257651',4905140,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257651',4905141,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257651',4905142,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257651',4905143,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257652',4905144,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257652',4905145,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257652',4905146,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257652',4905147,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257652',4905148,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257652',4905149,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257652',4905150,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257652',4905151,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257652',4905152,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257652',4905153,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257653',4905154,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257653',4905155,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257653',4905156,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257653',4905157,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257653',4905158,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257653',4905159,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257653',4905160,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257653',4905161,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257653',4905162,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257653',4905163,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257654',4905164,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257654',4905165,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257654',4905166,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257654',4905167,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257654',4905168,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257654',4905169,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257654',4905170,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257654',4905171,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257654',4905172,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257654',4905173,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257655',4905174,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257655',4905175,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257655',4905176,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257655',4905177,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257655',4905178,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257655',4905179,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257655',4905180,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257655',4905181,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257655',4905182,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257655',4905183,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257656',4905184,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257656',4905185,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257656',4905186,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257656',4905187,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257656',4905188,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257656',4905189,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257656',4905190,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257656',4905191,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257656',4905192,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257656',4905193,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257657',4905194,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257657',4905195,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257657',4905196,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257657',4905197,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257657',4905198,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257657',4905199,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257657',4905200,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257657',4905201,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257657',4905202,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257657',4905203,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257658',4905204,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257658',4905205,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257658',4905206,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257658',4905207,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257658',4905208,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257658',4905209,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257658',4905210,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257658',4905211,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257658',4905212,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257658',4905213,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257659',4905214,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257659',4905215,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257659',4905216,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257659',4905217,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257659',4905218,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257659',4905219,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257659',4905220,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257659',4905221,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257659',4905222,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257659',4905223,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257660',4905224,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257660',4905225,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257660',4905226,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257660',4905227,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257660',4905228,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257660',4905229,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257660',4905230,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257660',4905231,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257660',4905232,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257660',4905233,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257661',4905234,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257661',4905235,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257661',4905236,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257661',4905237,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257661',4905238,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257661',4905239,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257661',4905240,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257661',4905241,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257661',4905242,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257661',4905243,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257662',4905244,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257662',4905245,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257662',4905246,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257662',4905247,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257662',4905248,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257662',4905249,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257662',4905250,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257662',4905251,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257662',4905252,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257662',4905253,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257663',4905254,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257663',4905255,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257663',4905256,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257663',4905257,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257663',4905258,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257663',4905259,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257663',4905260,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257663',4905261,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257663',4905262,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257663',4905263,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257664',4905264,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257664',4905265,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257664',4905266,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257664',4905267,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257664',4905268,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257664',4905269,'1829','270',597081.81,597081.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257664',4905270,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257664',4905271,'1831','270',2235389.03,2235389.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257664',4905272,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257664',4905273,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257665',4905274,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257665',4905275,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257665',4905276,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257665',4905277,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257665',4905278,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257665',4905279,'1829','270',597081.81,600892.32,3810.51,628734.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257665',4905280,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257665',4905281,'1831','270',2235389.03,2236653.31,1264.28,208606.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','257665',4905282,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257665',4905283,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257666',4905284,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257666',4905285,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257666',4905286,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257666',4905287,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257666',4905288,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257666',4905289,'1829','270',600892.32,602759.38,1867.06,308064.90,0.00,0.00,0.00,0.00,0.00),('5','90','672','257666',4905290,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257666',4905291,'1831','270',2236653.31,2240470.54,3817.23,629842.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','257666',4905292,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257666',4905293,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257667',4905294,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257667',4905295,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257667',4905296,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257667',4905297,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257667',4905298,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257667',4905299,'1829','270',602759.38,605414.93,2655.55,438165.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','257667',4905300,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257667',4905301,'1831','270',2240470.54,2241754.47,1283.93,211848.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','257667',4905302,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257667',4905303,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257668',4905304,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257668',4905305,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257668',4905306,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257668',4905307,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257668',4905308,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257668',4905309,'1829','270',605414.93,606334.67,919.74,151757.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257668',4905310,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257668',4905311,'1831','270',2241754.47,2244931.15,3176.68,524152.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','257668',4905312,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257668',4905313,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257669',4905314,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257669',4905315,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257669',4905316,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257669',4905317,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257669',4905318,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257669',4905319,'1829','270',606334.67,610999.00,4664.33,769614.45,0.00,0.00,0.00,0.00,0.00),('5','90','672','257669',4905320,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257669',4905321,'1831','270',2244931.15,2247419.23,2488.08,410533.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','257669',4905322,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257669',4905323,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257670',4905324,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257670',4905325,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257670',4905326,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257670',4905327,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257670',4905328,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257670',4905329,'1829','270',610999.00,613145.63,2146.63,354193.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','257670',4905330,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257670',4905331,'1831','270',2247419.23,2247419.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257670',4905332,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257670',4905333,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257671',4905334,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257671',4905335,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257671',4905336,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257671',4905337,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257671',4905338,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257671',4905339,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257671',4905340,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257671',4905341,'1831','270',2247419.23,2248518.37,1099.14,181358.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','257671',4905342,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257671',4905343,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257672',4905344,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257672',4905345,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257672',4905346,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257672',4905347,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257672',4905348,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257672',4905349,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257672',4905350,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257672',4905351,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257672',4905352,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257672',4905353,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257673',4905354,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257673',4905355,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257673',4905356,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257673',4905357,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257673',4905358,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257673',4905359,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257673',4905360,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257673',4905361,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257673',4905362,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257673',4905363,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257674',4905364,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257674',4905365,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257674',4905366,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257674',4905367,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257674',4905368,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257674',4905369,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257674',4905370,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257674',4905371,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257674',4905372,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257674',4905373,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257675',4905374,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257675',4905375,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257675',4905376,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257675',4905377,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257675',4905378,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257675',4905379,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257675',4905380,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257675',4905381,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257675',4905382,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257675',4905383,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257676',4905384,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257676',4905385,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257676',4905386,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257676',4905387,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257676',4905388,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257676',4905389,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257676',4905390,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257676',4905391,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257676',4905392,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257676',4905393,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257677',4905394,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257677',4905395,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257677',4905396,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257677',4905397,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257677',4905398,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257677',4905399,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257677',4905400,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257677',4905401,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257677',4905402,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257677',4905403,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257678',4905404,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257678',4905405,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257678',4905406,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257678',4905407,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257678',4905408,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257678',4905409,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257678',4905410,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257678',4905411,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257678',4905412,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257678',4905413,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257679',4905414,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257679',4905415,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257679',4905416,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257679',4905417,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257679',4905418,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257679',4905419,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257679',4905420,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257679',4905421,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257679',4905422,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257679',4905423,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257680',4905424,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257680',4905425,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257680',4905426,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257680',4905427,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257680',4905428,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257680',4905429,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257680',4905430,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257680',4905431,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257680',4905432,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257680',4905433,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257681',4905434,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257681',4905435,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257681',4905436,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257681',4905437,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257681',4905438,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257681',4905439,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257681',4905440,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257681',4905441,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257681',4905442,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257681',4905443,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257682',4905444,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257682',4905445,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257682',4905446,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257682',4905447,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257682',4905448,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257682',4905449,'1829','270',613145.63,613145.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257682',4905450,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257682',4905451,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257682',4905452,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257682',4905453,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257683',4905454,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257683',4905455,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257683',4905456,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257683',4905457,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257683',4905458,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257683',4905459,'1829','270',613145.63,615481.08,2335.45,385349.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','257683',4905460,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257683',4905461,'1831','270',2248518.37,2248518.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257683',4905462,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257683',4905463,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257684',4905464,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257684',4905465,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257684',4905466,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257684',4905467,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257684',4905468,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257684',4905469,'1829','270',615481.08,615710.10,229.02,37788.30,0.00,0.00,0.00,0.00,0.00),('5','90','672','257684',4905470,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257684',4905471,'1831','270',2248518.37,2251513.74,2995.37,494236.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','257684',4905472,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257684',4905473,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257685',4905474,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257685',4905475,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257685',4905476,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257685',4905477,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257685',4905478,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257685',4905479,'1829','270',615710.10,619757.67,4047.57,667849.05,0.00,0.00,0.00,0.00,0.00),('5','90','672','257685',4905480,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257685',4905481,'1831','270',2251513.74,2251701.38,187.64,30960.60,0.00,0.00,0.00,0.00,0.00),('5','90','673','257685',4905482,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257685',4905483,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257686',4905484,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257686',4905485,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257686',4905486,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257686',4905487,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257686',4905488,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257686',4905489,'1829','270',619757.67,620730.25,972.58,179927.30,0.00,0.00,0.00,0.00,0.00),('5','90','672','257686',4905490,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257686',4905491,'1831','270',2251701.38,2253960.87,2259.49,418005.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257686',4905492,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257686',4905493,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257687',4905494,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257687',4905495,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257687',4905496,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257687',4905497,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257687',4905498,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257687',4905499,'1829','270',620730.25,621625.44,895.19,165610.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257687',4905500,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257687',4905501,'1831','270',2253960.87,2254520.64,559.77,103557.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','257687',4905502,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257687',4905503,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257688',4905504,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257688',4905505,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257688',4905506,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257688',4905507,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257688',4905508,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257688',4905509,'1829','270',621625.44,621625.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257688',4905510,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257688',4905511,'1831','270',2254520.64,2254520.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257688',4905512,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257688',4905513,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257689',4905514,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257689',4905515,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257689',4905516,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257689',4905517,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257689',4905518,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257689',4905519,'1829','270',621625.44,621625.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257689',4905520,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257689',4905521,'1831','270',2254520.64,2254520.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257689',4905522,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257689',4905523,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257690',4905524,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257690',4905525,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257690',4905526,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257690',4905527,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257690',4905528,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257690',4905529,'1829','270',621625.44,621625.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257690',4905530,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257690',4905531,'1831','270',2254520.64,2254520.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257690',4905532,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257690',4905533,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257691',4905534,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257691',4905535,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257691',4905536,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257691',4905537,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257691',4905538,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257691',4905539,'1829','270',621625.44,621625.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257691',4905540,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257691',4905541,'1831','270',2254520.64,2254520.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257691',4905542,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257691',4905543,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257692',4905544,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257692',4905545,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257692',4905546,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257692',4905547,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257692',4905548,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257692',4905549,'1829','270',621625.44,624412.42,2786.98,515591.30,0.00,0.00,0.00,0.00,0.00),('5','90','672','257692',4905550,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257692',4905551,'1831','270',2254520.64,2256770.55,2249.91,416233.35,0.00,0.00,0.00,0.00,0.00),('5','90','673','257692',4905552,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257692',4905553,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257693',4905554,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257693',4905555,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257693',4905556,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257693',4905557,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257693',4905558,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257693',4905559,'1829','270',624412.42,627442.69,3030.27,560599.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','257693',4905560,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257693',4905561,'1831','270',2256770.55,2259287.75,2517.20,465682.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257693',4905562,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257693',4905563,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257694',4905564,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257694',4905565,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257694',4905566,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257694',4905567,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257694',4905568,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257694',4905569,'1829','270',627442.69,631089.36,3646.67,674633.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','257694',4905570,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257694',4905571,'1831','270',2259287.75,2261784.40,2496.65,461880.25,0.00,0.00,0.00,0.00,0.00),('5','90','673','257694',4905572,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257694',4905573,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257695',4905574,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257695',4905575,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257695',4905576,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257695',4905577,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257695',4905578,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257695',4905579,'1829','270',631089.36,633826.46,2737.10,506363.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','257695',4905580,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257695',4905581,'1831','270',2261784.40,2263863.84,2079.44,384696.40,0.00,0.00,0.00,0.00,0.00),('5','90','673','257695',4905582,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257695',4905583,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257696',4905584,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257696',4905585,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257696',4905586,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257696',4905587,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257696',4905588,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257696',4905589,'1829','270',633826.46,639539.09,5712.63,1056836.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257696',4905590,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257696',4905591,'1831','270',2263863.84,2268421.86,4558.02,843233.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','257696',4905592,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257696',4905593,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257697',4905594,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257697',4905595,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257697',4905596,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257697',4905597,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257697',4905598,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257697',4905599,'1829','270',639539.09,641412.12,1873.03,346510.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257697',4905600,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257697',4905601,'1831','270',2268421.86,2270022.24,1600.38,296070.30,0.00,0.00,0.00,0.00,0.00),('5','90','673','257697',4905602,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257697',4905603,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257698',4905604,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257698',4905605,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257698',4905606,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257698',4905607,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257698',4905608,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257698',4905609,'1829','270',641412.12,645464.14,4052.02,749623.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','257698',4905610,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257698',4905611,'1831','270',2270022.24,2273197.90,3175.66,587497.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','257698',4905612,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257698',4905613,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257699',4905614,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257699',4905615,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257699',4905616,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257699',4905617,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257699',4905618,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257699',4905619,'1829','270',645464.14,647785.63,2321.49,429475.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','257699',4905620,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257699',4905621,'1831','270',2273197.90,2275811.88,2613.98,483586.30,0.00,0.00,0.00,0.00,0.00),('5','90','673','257699',4905622,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257699',4905623,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257700',4905624,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257700',4905625,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257700',4905626,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257700',4905627,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257700',4905628,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257700',4905629,'1829','270',647785.63,649863.58,2077.95,384420.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','257700',4905630,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257700',4905631,'1831','270',2275811.88,2277819.03,2007.15,371322.75,0.00,0.00,0.00,0.00,0.00),('5','90','673','257700',4905632,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257700',4905633,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257701',4905634,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257701',4905635,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257701',4905636,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257701',4905637,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257701',4905638,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257701',4905639,'1829','270',649863.58,652906.65,3043.07,562967.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','257701',4905640,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257701',4905641,'1831','270',2277819.03,2280017.54,2198.51,406724.35,0.00,0.00,0.00,0.00,0.00),('5','90','673','257701',4905642,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257701',4905643,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257702',4905644,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257702',4905645,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257702',4905646,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257702',4905647,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257702',4905648,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257702',4905649,'1829','270',652906.65,655140.95,2234.30,413345.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','257702',4905650,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257702',4905651,'1831','270',2280017.54,2282039.26,2021.72,374018.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','257702',4905652,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257702',4905653,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257703',4905654,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257703',4905655,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257703',4905656,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257703',4905657,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257703',4905658,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257703',4905659,'1829','270',655140.95,655140.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257703',4905660,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257703',4905661,'1831','270',2282039.26,2282796.09,756.83,140013.55,0.00,0.00,0.00,0.00,0.00),('5','90','673','257703',4905662,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257703',4905663,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257704',4905664,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257704',4905665,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257704',4905666,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257704',4905667,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257704',4905668,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257704',4905669,'1829','270',655140.95,655140.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257704',4905670,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257704',4905671,'1831','270',2282796.09,2282796.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257704',4905672,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257704',4905673,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257705',4905674,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257705',4905675,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257705',4905676,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257705',4905677,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257705',4905678,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257705',4905679,'1829','270',655140.95,655140.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257705',4905680,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257705',4905681,'1831','270',2282796.09,2282796.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257705',4905682,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257705',4905683,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257706',4905684,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257706',4905685,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257706',4905686,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257706',4905687,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257706',4905688,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257706',4905689,'1829','270',655140.95,655140.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257706',4905690,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257706',4905691,'1831','270',2282796.09,2282796.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257706',4905692,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257706',4905693,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257707',4905694,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257707',4905695,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257707',4905696,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257707',4905697,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257707',4905698,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257707',4905699,'1829','270',655140.95,655140.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257707',4905700,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257707',4905701,'1831','270',2282796.09,2282796.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257707',4905702,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257707',4905703,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257708',4905704,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257708',4905705,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257708',4905706,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257708',4905707,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257708',4905708,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257708',4905709,'1829','270',655140.95,655140.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257708',4905710,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257708',4905711,'1831','270',2282796.09,2282796.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257708',4905712,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257708',4905713,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257709',4905714,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257709',4905715,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257709',4905716,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257709',4905717,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257709',4905718,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257709',4905719,'1829','270',655140.95,655140.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257709',4905720,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257709',4905721,'1831','270',2282796.09,2282796.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257709',4905722,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257709',4905723,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257710',4905724,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257710',4905725,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257710',4905726,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257710',4905727,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257710',4905728,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257710',4905729,'1829','270',655140.95,656768.00,1627.05,301004.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','257710',4905730,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257710',4905731,'1831','270',2282796.09,2284410.15,1614.06,298601.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','257710',4905732,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257710',4905733,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257711',4905734,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257711',4905735,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257711',4905736,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257711',4905737,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257711',4905738,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257711',4905739,'1829','270',656768.00,658719.28,1951.28,360986.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','257711',4905740,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257711',4905741,'1831','270',2284410.15,2285479.54,1069.39,197837.15,0.00,0.00,0.00,0.00,0.00),('5','90','673','257711',4905742,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257711',4905743,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257712',4905744,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257712',4905745,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257712',4905746,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257712',4905747,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257712',4905748,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257712',4905749,'1829','270',658719.28,661870.35,3151.07,582947.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','257712',4905750,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257712',4905751,'1831','270',2285479.54,2286299.28,819.74,151651.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','257712',4905752,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257712',4905753,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257713',4905754,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257713',4905755,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257713',4905756,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257713',4905757,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257713',4905758,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257713',4905759,'1829','270',661870.35,664821.10,2950.75,545888.75,0.00,0.00,0.00,0.00,0.00),('5','90','672','257713',4905760,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257713',4905761,'1831','270',2286299.28,2286299.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257713',4905762,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257713',4905763,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257714',4905764,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257714',4905765,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257714',4905766,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257714',4905767,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257714',4905768,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257714',4905769,'1829','270',664821.10,665241.54,420.44,77781.40,0.00,0.00,0.00,0.00,0.00),('5','90','672','257714',4905770,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257714',4905771,'1831','270',2286299.28,2287662.26,1362.98,252151.30,0.00,0.00,0.00,0.00,0.00),('5','90','673','257714',4905772,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257714',4905773,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257715',4905774,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257715',4905775,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257715',4905776,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257715',4905777,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257715',4905778,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257715',4905779,'1829','270',665241.54,665241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257715',4905780,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257715',4905781,'1831','270',2287662.26,2287662.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257715',4905782,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257715',4905783,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257716',4905784,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257716',4905785,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257716',4905786,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257716',4905787,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257716',4905788,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257716',4905789,'1829','270',665241.54,665241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257716',4905790,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257716',4905791,'1831','270',2287662.26,2287662.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257716',4905792,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257716',4905793,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257717',4905794,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257717',4905795,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257717',4905796,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257717',4905797,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257717',4905798,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257717',4905799,'1829','270',665241.54,665241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257717',4905800,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257717',4905801,'1831','270',2287662.26,2287662.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257717',4905802,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257717',4905803,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257718',4905804,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257718',4905805,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257718',4905806,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257718',4905807,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257718',4905808,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257718',4905809,'1829','270',665241.54,665241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257718',4905810,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257718',4905811,'1831','270',2287662.26,2287662.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257718',4905812,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257718',4905813,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257719',4905814,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257719',4905815,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257719',4905816,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257719',4905817,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257719',4905818,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257719',4905819,'1829','270',665241.54,665241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257719',4905820,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257719',4905821,'1831','270',2287662.26,2287662.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257719',4905822,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257719',4905823,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257720',4905824,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257720',4905825,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257720',4905826,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257720',4905827,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257720',4905828,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257720',4905829,'1829','270',665241.54,665241.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257720',4905830,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257720',4905831,'1831','270',2287662.26,2287662.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257720',4905832,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257720',4905833,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257721',4905834,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257721',4905835,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257721',4905836,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257721',4905837,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257721',4905838,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257721',4905839,'1829','270',665241.54,667631.91,2390.37,442218.45,0.00,0.00,0.00,0.00,0.00),('5','90','672','257721',4905840,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257721',4905841,'1831','270',2287662.26,2289438.96,1776.70,328689.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','257721',4905842,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257721',4905843,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257722',4905844,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257722',4905845,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257722',4905846,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257722',4905847,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257722',4905848,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257722',4905849,'1829','270',667631.91,671410.42,3778.51,699024.35,0.00,0.00,0.00,0.00,0.00),('5','90','672','257722',4905850,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257722',4905851,'1831','270',2289438.96,2289745.23,306.27,56659.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','257722',4905852,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257722',4905853,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257723',4905854,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257723',4905855,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257723',4905856,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257723',4905857,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257723',4905858,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257723',4905859,'1829','270',671410.42,672961.85,1551.43,287014.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257723',4905860,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257723',4905861,'1831','270',2289745.23,2290641.31,896.08,165774.80,0.00,0.00,0.00,0.00,0.00),('5','90','673','257723',4905862,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257723',4905863,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257724',4905864,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257724',4905865,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257724',4905866,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257724',4905867,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257724',4905868,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257724',4905869,'1829','270',672961.85,674912.45,1950.60,360861.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257724',4905870,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257724',4905871,'1831','270',2290641.31,2290809.22,167.91,31063.35,0.00,0.00,0.00,0.00,0.00),('5','90','673','257724',4905872,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257724',4905873,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257725',4905874,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257725',4905875,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257725',4905876,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257725',4905877,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257725',4905878,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257725',4905879,'1829','270',674912.45,676069.11,1156.66,213982.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257725',4905880,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257725',4905881,'1831','270',2290809.22,2291840.31,1031.09,190751.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257725',4905882,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257725',4905883,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257726',4905884,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257726',4905885,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257726',4905886,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257726',4905887,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257726',4905888,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257726',4905889,'1829','270',676069.11,677224.17,1155.06,213686.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257726',4905890,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257726',4905891,'1831','270',2291840.31,2292320.91,480.60,88911.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257726',4905892,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257726',4905893,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257727',4905894,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257727',4905895,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257727',4905896,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257727',4905897,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257727',4905898,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257727',4905899,'1829','270',677224.17,678415.76,1191.59,220444.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257727',4905900,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257727',4905901,'1831','270',2292320.91,2293534.19,1213.28,224456.80,0.00,0.00,0.00,0.00,0.00),('5','90','673','257727',4905902,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257727',4905903,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257728',4905904,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257728',4905905,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257728',4905906,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257728',4905907,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257728',4905908,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257728',4905909,'1829','270',678415.76,681614.55,3198.79,591776.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257728',4905910,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257728',4905911,'1831','270',2293534.19,2296573.23,3039.04,562222.40,0.00,0.00,0.00,0.00,0.00),('5','90','673','257728',4905912,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257728',4905913,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257729',4905914,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257729',4905915,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257729',4905916,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257729',4905917,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257729',4905918,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257729',4905919,'1829','270',681614.55,683586.99,1972.44,364901.40,0.00,0.00,0.00,0.00,0.00),('5','90','672','257729',4905920,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257729',4905921,'1831','270',2296573.23,2297475.00,901.77,166827.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','257729',4905922,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257729',4905923,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257730',4905924,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257730',4905925,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257730',4905926,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257730',4905927,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257730',4905928,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257730',4905929,'1829','270',683586.99,684806.84,1219.85,225672.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','257730',4905930,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257730',4905931,'1831','270',2297475.00,2299499.62,2024.62,374554.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','257730',4905932,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257730',4905933,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257731',4905934,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257731',4905935,'1825','270',342056.93,342056.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257731',4905936,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257731',4905937,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257731',4905938,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257731',4905939,'1829','270',684806.84,686661.91,1855.07,343187.95,0.00,0.00,0.00,0.00,0.00),('5','90','672','257731',4905940,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257731',4905941,'1831','270',2299499.62,2300708.35,1208.73,223615.05,0.00,0.00,0.00,0.00,0.00),('5','90','673','257731',4905942,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257731',4905943,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257732',4905944,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257732',4905945,'1825','270',342056.93,342089.56,32.63,6036.55,0.00,0.00,0.00,0.00,0.00),('5','90','671','257732',4905946,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257732',4905947,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257732',4905948,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257732',4905949,'1829','270',686661.91,689096.30,2434.39,450362.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257732',4905950,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257732',4905951,'1831','270',2300708.35,2302596.84,1888.49,349370.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257732',4905952,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257732',4905953,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257733',4905954,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257733',4905955,'1825','270',342089.56,342089.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257733',4905956,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257733',4905957,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257733',4905958,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257733',4905959,'1829','270',689096.30,691808.58,2712.28,501771.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','257733',4905960,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257733',4905961,'1831','270',2302596.84,2304283.44,1686.60,312021.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257733',4905962,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257733',4905963,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257734',4905964,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257734',4905965,'1825','270',342089.56,342089.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257734',4905966,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257734',4905967,'1827','270',2526123.61,2526123.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257734',4905968,'1828','270',553575.30,553575.30,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257734',4905969,'1829','270',691808.58,694549.59,2741.01,507086.85,0.00,0.00,0.00,0.00,0.00),('5','90','672','257734',4905970,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257734',4905971,'1831','270',2304283.44,2306414.55,2131.11,394255.35,0.00,0.00,0.00,0.00,0.00),('5','90','673','257734',4905972,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257734',4905973,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257735',4905974,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257735',4905975,'1825','270',342089.56,342089.69,0.13,24.05,0.00,0.00,0.00,0.00,0.00),('5','90','671','257735',4905976,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257735',4905977,'1827','270',2526123.61,2526126.95,3.34,617.90,0.00,0.00,0.00,0.00,0.00),('5','90','669','257735',4905978,'1828','270',553575.30,553584.00,8.70,1609.50,0.00,0.00,0.00,0.00,0.00),('5','90','670','257735',4905979,'1829','270',694549.59,698518.01,3968.42,734157.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','257735',4905980,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257735',4905981,'1831','270',2306414.55,2309367.57,2953.02,546308.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','257735',4905982,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257735',4905983,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257736',4905984,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257736',4905985,'1825','270',342089.69,342089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257736',4905986,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257736',4905987,'1827','270',2526126.95,2526126.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257736',4905988,'1828','270',553584.00,553584.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257736',4905989,'1829','270',698518.01,700451.09,1933.08,357619.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','257736',4905990,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257736',4905991,'1831','270',2309367.57,2310990.31,1622.74,300206.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','257736',4905992,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257736',4905993,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257737',4905994,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257737',4905995,'1825','270',342089.69,342089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257737',4905996,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257737',4905997,'1827','270',2526126.95,2526126.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257737',4905998,'1828','270',553584.00,553584.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257737',4905999,'1829','270',700451.09,702497.69,2046.60,378621.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257737',4906000,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257737',4906001,'1831','270',2310990.31,2313179.42,2189.11,404985.35,0.00,0.00,0.00,0.00,0.00),('5','90','673','257737',4906002,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257737',4906003,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257738',4906004,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257738',4906005,'1825','270',342089.69,342089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257738',4906006,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257738',4906007,'1827','270',2526126.95,2526583.02,456.07,84372.95,0.00,0.00,0.00,0.00,0.00),('5','90','669','257738',4906008,'1828','270',553584.00,553727.73,143.73,26590.05,0.00,0.00,0.00,0.00,0.00),('5','90','670','257738',4906009,'1829','270',702497.69,703737.55,1239.86,229374.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257738',4906010,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257738',4906011,'1831','270',2313179.42,2314185.71,1006.29,186163.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257738',4906012,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257738',4906013,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257739',4906014,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257739',4906015,'1825','270',342089.69,342089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257739',4906016,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257739',4906017,'1827','270',2526583.02,2526583.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257739',4906018,'1828','270',553727.73,553727.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257739',4906019,'1829','270',703737.55,703737.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257739',4906020,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257739',4906021,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257739',4906022,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257739',4906023,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257740',4906024,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257740',4906025,'1825','270',342089.69,342089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257740',4906026,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257740',4906027,'1827','270',2526583.02,2528398.31,1815.29,335828.65,0.00,0.00,0.00,0.00,0.00),('5','90','669','257740',4906028,'1828','270',553727.73,554270.48,542.75,100408.75,0.00,0.00,0.00,0.00,0.00),('5','90','670','257740',4906029,'1829','270',703737.55,703737.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257740',4906030,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257740',4906031,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257740',4906032,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257740',4906033,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257741',4906034,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257741',4906035,'1825','270',342089.69,342089.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257741',4906036,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257741',4906037,'1827','270',2528398.31,2532037.37,3639.06,673226.10,0.00,0.00,0.00,0.00,0.00),('5','90','669','257741',4906038,'1828','270',554270.48,554270.48,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257741',4906039,'1829','270',703737.55,703737.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257741',4906040,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257741',4906041,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257741',4906042,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257741',4906043,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257742',4906044,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257742',4906045,'1825','270',342089.69,344034.27,1944.58,359747.30,0.00,0.00,0.00,0.00,0.00),('5','90','671','257742',4906046,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257742',4906047,'1827','270',2532037.37,2536209.60,4172.23,771862.55,0.00,0.00,0.00,0.00,0.00),('5','90','669','257742',4906048,'1828','270',554270.48,554360.81,90.33,16711.05,0.00,0.00,0.00,0.00,0.00),('5','90','670','257742',4906049,'1829','270',703737.55,703737.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257742',4906050,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257742',4906051,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257742',4906052,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257742',4906053,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257743',4906054,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257743',4906055,'1825','270',344034.27,345850.67,1816.40,336034.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257743',4906056,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257743',4906057,'1827','270',2536209.60,2537968.10,1758.50,325322.50,0.00,0.00,0.00,0.00,0.00),('5','90','669','257743',4906058,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257743',4906059,'1829','270',703737.55,703737.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257743',4906060,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257743',4906061,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257743',4906062,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257743',4906063,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257744',4906064,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257744',4906065,'1825','270',345850.67,347433.21,1582.54,292769.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','257744',4906066,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257744',4906067,'1827','270',2537968.10,2539531.43,1563.33,289216.05,0.00,0.00,0.00,0.00,0.00),('5','90','669','257744',4906068,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257744',4906069,'1829','270',703737.55,703737.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257744',4906070,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257744',4906071,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257744',4906072,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257744',4906073,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257745',4906074,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257745',4906075,'1825','270',347433.21,348803.37,1370.16,253479.60,0.00,0.00,0.00,0.00,0.00),('5','90','671','257745',4906076,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257745',4906077,'1827','270',2539531.43,2541599.59,2068.16,382609.60,0.00,0.00,0.00,0.00,0.00),('5','90','669','257745',4906078,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257745',4906079,'1829','270',703737.55,703737.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257745',4906080,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257745',4906081,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257745',4906082,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257745',4906083,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257746',4906084,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257746',4906085,'1825','270',348803.37,350728.17,1924.80,356088.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257746',4906086,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257746',4906087,'1827','270',2541599.59,2543568.03,1968.44,364161.40,0.00,0.00,0.00,0.00,0.00),('5','90','669','257746',4906088,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257746',4906089,'1829','270',703737.55,703737.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257746',4906090,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257746',4906091,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257746',4906092,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257746',4906093,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257747',4906094,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257747',4906095,'1825','270',350728.17,351297.73,569.56,105368.60,0.00,0.00,0.00,0.00,0.00),('5','90','671','257747',4906096,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257747',4906097,'1827','270',2543568.03,2545252.86,1684.83,311693.55,0.00,0.00,0.00,0.00,0.00),('5','90','669','257747',4906098,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257747',4906099,'1829','270',703737.55,705002.96,1265.41,234100.85,0.00,0.00,0.00,0.00,0.00),('5','90','672','257747',4906100,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257747',4906101,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257747',4906102,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257747',4906103,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257748',4906104,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257748',4906105,'1825','270',351297.73,351297.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257748',4906106,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257748',4906107,'1827','270',2545252.86,2546927.34,1674.48,309778.80,0.00,0.00,0.00,0.00,0.00),('5','90','669','257748',4906108,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257748',4906109,'1829','270',705002.96,706943.66,1940.70,359029.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','257748',4906110,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257748',4906111,'1831','270',2314185.71,2314185.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257748',4906112,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257748',4906113,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257749',4906114,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257749',4906115,'1825','270',351297.73,351297.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257749',4906116,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257749',4906117,'1827','270',2546927.34,2550193.31,3265.97,604204.45,0.00,0.00,0.00,0.00,0.00),('5','90','669','257749',4906118,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257749',4906119,'1829','270',706943.66,709678.37,2734.71,505921.35,0.00,0.00,0.00,0.00,0.00),('5','90','672','257749',4906120,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257749',4906121,'1831','270',2314185.71,2316732.33,2546.62,471124.70,0.00,0.00,0.00,0.00,0.00),('5','90','673','257749',4906122,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257749',4906123,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257750',4906124,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257750',4906125,'1825','270',351297.73,351297.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257750',4906126,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257750',4906127,'1827','270',2550193.31,2552076.61,1883.30,348410.50,0.00,0.00,0.00,0.00,0.00),('5','90','669','257750',4906128,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257750',4906129,'1829','270',709678.37,711562.40,1884.03,348545.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257750',4906130,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257750',4906131,'1831','270',2316732.33,2316732.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257750',4906132,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257750',4906133,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257754',4906134,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257754',4906135,'1825','270',351297.73,351297.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257754',4906136,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257754',4906137,'1827','270',2552076.61,2553499.51,1422.90,263236.50,0.00,0.00,0.00,0.00,0.00),('5','90','669','257754',4906138,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257754',4906139,'1829','270',711562.40,713289.82,1727.42,319572.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','257754',4906140,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257754',4906141,'1831','270',2316732.33,2316732.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257754',4906142,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257754',4906143,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257755',4906144,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257755',4906145,'1825','270',351297.73,351297.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257755',4906146,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257755',4906147,'1827','270',2553499.51,2553499.51,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257755',4906148,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257755',4906149,'1829','270',713289.82,713289.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257755',4906150,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257755',4906151,'1831','270',2316732.33,2316732.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257755',4906152,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257755',4906153,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257756',4906154,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257756',4906155,'1825','270',351297.73,351297.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257756',4906156,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257756',4906157,'1827','270',2553499.51,2555122.97,1623.46,300340.10,0.00,0.00,0.00,0.00,0.00),('5','90','669','257756',4906158,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257756',4906159,'1829','270',713289.82,715780.80,2490.98,460831.30,0.00,0.00,0.00,0.00,0.00),('5','90','672','257756',4906160,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257756',4906161,'1831','270',2316732.33,2316732.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257756',4906162,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257756',4906163,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257757',4906164,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257757',4906165,'1825','270',351297.73,351364.92,67.19,12430.15,0.00,0.00,0.00,0.00,0.00),('5','90','671','257757',4906166,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257757',4906167,'1827','270',2555122.97,2556825.94,1702.97,315049.45,0.00,0.00,0.00,0.00,0.00),('5','90','669','257757',4906168,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257757',4906169,'1829','270',715780.80,718376.80,2596.00,480260.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257757',4906170,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257757',4906171,'1831','270',2316732.33,2317111.38,379.05,70124.25,0.00,0.00,0.00,0.00,0.00),('5','90','673','257757',4906172,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257757',4906173,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257758',4906174,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257758',4906175,'1825','270',351364.92,353353.06,1988.14,367805.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','257758',4906176,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257758',4906177,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257758',4906178,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257758',4906179,'1829','270',718376.80,720498.69,2121.89,392549.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','257758',4906180,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257758',4906181,'1831','270',2317111.38,2317111.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257758',4906182,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257758',4906183,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257759',4906184,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257759',4906185,'1825','270',353353.06,355892.01,2538.95,469705.75,0.00,0.00,0.00,0.00,0.00),('5','90','671','257759',4906186,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257759',4906187,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257759',4906188,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257759',4906189,'1829','270',720498.69,722995.31,2496.62,461874.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','257759',4906190,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257759',4906191,'1831','270',2317111.38,2317111.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257759',4906192,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257759',4906193,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257760',4906194,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257760',4906195,'1825','270',355892.01,359410.42,3518.41,650905.85,0.00,0.00,0.00,0.00,0.00),('5','90','671','257760',4906196,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257760',4906197,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257760',4906198,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257760',4906199,'1829','270',722995.31,725694.51,2699.20,499352.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257760',4906200,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257760',4906201,'1831','270',2317111.38,2319536.84,2425.46,448710.10,0.00,0.00,0.00,0.00,0.00),('5','90','673','257760',4906202,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257760',4906203,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257761',4906204,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257761',4906205,'1825','270',359410.42,361298.42,1888.00,349280.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257761',4906206,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257761',4906207,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257761',4906208,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257761',4906209,'1829','270',725694.51,727955.07,2260.56,418203.60,0.00,0.00,0.00,0.00,0.00),('5','90','672','257761',4906210,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257761',4906211,'1831','270',2319536.84,2319536.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257761',4906212,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257761',4906213,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257762',4906214,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257762',4906215,'1825','270',361298.42,363021.22,1722.80,318718.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257762',4906216,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257762',4906217,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257762',4906218,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257762',4906219,'1829','270',727955.07,729660.77,1705.70,315554.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','257762',4906220,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257762',4906221,'1831','270',2319536.84,2319536.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257762',4906222,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257762',4906223,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257763',4906224,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257763',4906225,'1825','270',363021.22,364831.50,1810.28,334901.80,0.00,0.00,0.00,0.00,0.00),('5','90','671','257763',4906226,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257763',4906227,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257763',4906228,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257763',4906229,'1829','270',729660.77,731725.66,2064.89,382004.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','257763',4906230,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257763',4906231,'1831','270',2319536.84,2319536.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257763',4906232,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257763',4906233,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257764',4906234,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257764',4906235,'1825','270',364831.50,364837.44,5.94,1098.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','257764',4906236,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257764',4906237,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257764',4906238,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257764',4906239,'1829','270',731725.66,734342.72,2617.06,484156.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257764',4906240,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257764',4906241,'1831','270',2319536.84,2321017.81,1480.97,273979.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','257764',4906242,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257764',4906243,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257765',4906244,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257765',4906245,'1825','270',364837.44,364837.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257765',4906246,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257765',4906247,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257765',4906248,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257765',4906249,'1829','270',734342.72,736740.80,2398.08,443644.80,0.00,0.00,0.00,0.00,0.00),('5','90','672','257765',4906250,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257765',4906251,'1831','270',2321017.81,2323103.93,2086.12,385932.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','257765',4906252,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257765',4906253,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257766',4906254,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257766',4906255,'1825','270',364837.44,364837.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257766',4906256,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257766',4906257,'1827','270',2556825.94,2556825.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257766',4906258,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257766',4906259,'1829','270',736740.80,738991.31,2250.51,416344.35,0.00,0.00,0.00,0.00,0.00),('5','90','672','257766',4906260,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257766',4906261,'1831','270',2323103.93,2325432.05,2328.12,430702.20,0.00,0.00,0.00,0.00,0.00),('5','90','673','257766',4906262,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257766',4906263,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257767',4906264,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257767',4906265,'1825','270',364837.44,364837.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257767',4906266,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257767',4906267,'1827','270',2556825.94,2559846.55,3020.61,558812.85,0.00,0.00,0.00,0.00,0.00),('5','90','669','257767',4906268,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257767',4906269,'1829','270',738991.31,742028.94,3037.63,561961.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257767',4906270,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257767',4906271,'1831','270',2325432.05,2328534.89,3102.84,574025.40,0.00,0.00,0.00,0.00,0.00),('5','90','673','257767',4906272,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257767',4906273,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257768',4906274,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257768',4906275,'1825','270',364837.44,365800.86,963.42,178232.70,0.00,0.00,0.00,0.00,0.00),('5','90','671','257768',4906276,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257768',4906277,'1827','270',2559846.55,2560855.98,1009.43,186744.55,0.00,0.00,0.00,0.00,0.00),('5','90','669','257768',4906278,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257768',4906279,'1829','270',742028.94,743175.13,1146.19,212045.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257768',4906280,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257768',4906281,'1831','270',2328534.89,2329175.26,640.37,118468.45,0.00,0.00,0.00,0.00,0.00),('5','90','673','257768',4906282,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257768',4906283,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257769',4906284,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257769',4906285,'1825','270',365800.86,368220.29,2419.43,447594.55,0.00,0.00,0.00,0.00,0.00),('5','90','671','257769',4906286,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257769',4906287,'1827','270',2560855.98,2562153.46,1297.48,240033.80,0.00,0.00,0.00,0.00,0.00),('5','90','669','257769',4906288,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257769',4906289,'1829','270',743175.13,743175.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257769',4906290,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257769',4906291,'1831','270',2329175.26,2329175.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257769',4906292,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257769',4906293,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257770',4906294,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257770',4906295,'1825','270',368220.29,369848.85,1628.56,301283.60,0.00,0.00,0.00,0.00,0.00),('5','90','671','257770',4906296,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257770',4906297,'1827','270',2562153.46,2564603.57,2450.11,453270.35,0.00,0.00,0.00,0.00,0.00),('5','90','669','257770',4906298,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257770',4906299,'1829','270',743175.13,743175.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257770',4906300,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257770',4906301,'1831','270',2329175.26,2329175.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257770',4906302,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257770',4906303,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257771',4906304,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257771',4906305,'1825','270',369848.85,371941.44,2092.59,387129.15,0.00,0.00,0.00,0.00,0.00),('5','90','671','257771',4906306,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257771',4906307,'1827','270',2564603.57,2566857.40,2253.83,416958.55,0.00,0.00,0.00,0.00,0.00),('5','90','669','257771',4906308,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257771',4906309,'1829','270',743175.13,743175.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257771',4906310,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257771',4906311,'1831','270',2329175.26,2329175.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257771',4906312,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257771',4906313,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257772',4906314,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257772',4906315,'1825','270',371941.44,373989.34,2047.90,378861.50,0.00,0.00,0.00,0.00,0.00),('5','90','671','257772',4906316,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257772',4906317,'1827','270',2566857.40,2569164.88,2307.48,426883.80,0.00,0.00,0.00,0.00,0.00),('5','90','669','257772',4906318,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257772',4906319,'1829','270',743175.13,743175.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257772',4906320,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257772',4906321,'1831','270',2329175.26,2329175.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257772',4906322,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257772',4906323,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257773',4906324,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257773',4906325,'1825','270',373989.34,376350.76,2361.42,436862.70,0.00,0.00,0.00,0.00,0.00),('5','90','671','257773',4906326,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257773',4906327,'1827','270',2569164.88,2571333.37,2168.49,401170.65,0.00,0.00,0.00,0.00,0.00),('5','90','669','257773',4906328,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257773',4906329,'1829','270',743175.13,743175.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257773',4906330,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257773',4906331,'1831','270',2329175.26,2329175.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257773',4906332,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257773',4906333,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257774',4906334,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257774',4906335,'1825','270',376350.76,376350.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257774',4906336,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257774',4906337,'1827','270',2571333.37,2574494.39,3161.02,584788.70,0.00,0.00,0.00,0.00,0.00),('5','90','669','257774',4906338,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257774',4906339,'1829','270',743175.13,746729.17,3554.04,657497.40,0.00,0.00,0.00,0.00,0.00),('5','90','672','257774',4906340,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257774',4906341,'1831','270',2329175.26,2332006.06,2830.80,523698.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257774',4906342,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257774',4906343,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257775',4906344,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257775',4906345,'1825','270',376350.76,376350.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257775',4906346,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257775',4906347,'1827','270',2574494.39,2575960.37,1465.98,271206.30,0.00,0.00,0.00,0.00,0.00),('5','90','669','257775',4906348,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257775',4906349,'1829','270',746729.17,748734.87,2005.70,371054.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','257775',4906350,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257775',4906351,'1831','270',2332006.06,2332633.61,627.55,116096.75,0.00,0.00,0.00,0.00,0.00),('5','90','673','257775',4906352,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257775',4906353,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257776',4906354,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257776',4906355,'1825','270',376350.76,376350.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257776',4906356,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257776',4906357,'1827','270',2575960.37,2578049.73,2089.36,386531.60,0.00,0.00,0.00,0.00,0.00),('5','90','669','257776',4906358,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257776',4906359,'1829','270',748734.87,751252.21,2517.34,465707.90,0.00,0.00,0.00,0.00,0.00),('5','90','672','257776',4906360,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257776',4906361,'1831','270',2332633.61,2332633.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257776',4906362,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257776',4906363,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257779',4906364,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257779',4906365,'1825','270',376350.76,376350.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257779',4906366,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257779',4906367,'1827','270',2578049.73,2580104.18,2054.45,380073.25,0.00,0.00,0.00,0.00,0.00),('5','90','669','257779',4906368,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257779',4906369,'1829','270',751252.21,753574.51,2322.30,429625.50,0.00,0.00,0.00,0.00,0.00),('5','90','672','257779',4906370,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257779',4906371,'1831','270',2332633.61,2332633.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257779',4906372,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257779',4906373,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257780',4906374,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257780',4906375,'1825','270',376350.76,376350.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257780',4906376,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257780',4906377,'1827','270',2580104.18,2582892.96,2788.78,515924.30,0.00,0.00,0.00,0.00,0.00),('5','90','669','257780',4906378,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257780',4906379,'1829','270',753574.51,756700.57,3126.06,578321.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257780',4906380,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257780',4906381,'1831','270',2332633.61,2332633.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257780',4906382,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257780',4906383,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257781',4906384,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257781',4906385,'1825','270',376350.76,376350.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257781',4906386,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257781',4906387,'1827','270',2582892.96,2585994.42,3101.46,573770.10,0.00,0.00,0.00,0.00,0.00),('5','90','669','257781',4906388,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257781',4906389,'1829','270',756700.57,759401.56,2700.99,499683.15,0.00,0.00,0.00,0.00,0.00),('5','90','672','257781',4906390,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257781',4906391,'1831','270',2332633.61,2332633.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257781',4906392,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257781',4906393,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257782',4906394,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257782',4906395,'1825','270',376350.76,376350.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257782',4906396,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257782',4906397,'1827','270',2585994.42,2588468.09,2473.67,457628.95,0.00,0.00,0.00,0.00,0.00),('5','90','669','257782',4906398,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257782',4906399,'1829','270',759401.56,762398.88,2997.32,554504.20,0.00,0.00,0.00,0.00,0.00),('5','90','672','257782',4906400,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257782',4906401,'1831','270',2332633.61,2332633.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257782',4906402,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257782',4906403,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257783',4906404,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257783',4906405,'1825','270',376350.76,376350.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257783',4906406,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257783',4906407,'1827','270',2588468.09,2592392.42,3924.33,726001.05,0.00,0.00,0.00,0.00,0.00),('5','90','669','257783',4906408,'1828','270',554360.81,554360.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257783',4906409,'1829','270',762398.88,766450.33,4051.45,749518.25,0.00,0.00,0.00,0.00,0.00),('5','90','672','257783',4906410,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257783',4906411,'1831','270',2332633.61,2336457.26,3823.65,707375.25,0.00,0.00,0.00,0.00,0.00),('5','90','673','257783',4906412,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257783',4906413,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257784',4906414,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257784',4906415,'1825','270',376350.76,380159.18,3808.42,704557.70,0.00,0.00,0.00,0.00,0.00),('5','90','671','257784',4906416,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257784',4906417,'1827','270',2592392.42,2592392.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257784',4906418,'1828','270',554360.81,555350.55,989.74,183101.90,0.00,0.00,0.00,0.00,0.00),('5','90','670','257784',4906419,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257784',4906420,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257784',4906421,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257784',4906422,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257784',4906423,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257785',4906424,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257785',4906425,'1825','270',380159.18,383772.32,3613.14,668430.90,0.00,0.00,0.00,0.00,0.00),('5','90','671','257785',4906426,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257785',4906427,'1827','270',2592392.42,2596112.64,3720.22,688240.70,0.00,0.00,0.00,0.00,0.00),('5','90','669','257785',4906428,'1828','270',555350.55,555350.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257785',4906429,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257785',4906430,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257785',4906431,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257785',4906432,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257785',4906433,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257786',4906434,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257786',4906435,'1825','270',383772.32,387527.82,3755.50,694767.50,0.00,0.00,0.00,0.00,0.00),('5','90','671','257786',4906436,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257786',4906437,'1827','270',2596112.64,2596405.89,293.25,54251.25,0.00,0.00,0.00,0.00,0.00),('5','90','669','257786',4906438,'1828','270',555350.55,557363.75,2013.20,372442.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257786',4906439,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257786',4906440,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257786',4906441,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257786',4906442,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257786',4906443,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257787',4906444,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257787',4906445,'1825','270',387527.82,392863.32,5335.50,987067.50,0.00,0.00,0.00,0.00,0.00),('5','90','671','257787',4906446,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257787',4906447,'1827','270',2596405.89,2596891.01,485.12,89747.20,0.00,0.00,0.00,0.00,0.00),('5','90','669','257787',4906448,'1828','270',557363.75,557363.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257787',4906449,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257787',4906450,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257787',4906451,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257787',4906452,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257787',4906453,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257788',4906454,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257788',4906455,'1825','270',392863.32,398077.76,5214.44,964671.40,0.00,0.00,0.00,0.00,0.00),('5','90','671','257788',4906456,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257788',4906457,'1827','270',2596891.01,2600433.06,3542.05,655279.25,0.00,0.00,0.00,0.00,0.00),('5','90','669','257788',4906458,'1828','270',557363.75,557363.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257788',4906459,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257788',4906460,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257788',4906461,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257788',4906462,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257788',4906463,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257789',4906464,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257789',4906465,'1825','270',398077.76,402550.17,4472.41,827395.85,0.00,0.00,0.00,0.00,0.00),('5','90','671','257789',4906466,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257789',4906467,'1827','270',2600433.06,2601024.35,591.29,109388.65,0.00,0.00,0.00,0.00,0.00),('5','90','669','257789',4906468,'1828','270',557363.75,559227.82,1864.07,344852.95,0.00,0.00,0.00,0.00,0.00),('5','90','670','257789',4906469,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257789',4906470,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257789',4906471,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257789',4906472,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257789',4906473,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257790',4906474,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257790',4906475,'1825','270',402550.17,403918.56,1368.39,253152.15,0.00,0.00,0.00,0.00,0.00),('5','90','671','257790',4906476,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257790',4906477,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257790',4906478,'1828','270',559227.82,562162.14,2934.32,542849.20,0.00,0.00,0.00,0.00,0.00),('5','90','670','257790',4906479,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257790',4906480,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257790',4906481,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257790',4906482,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257790',4906483,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257791',4906484,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257791',4906485,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257791',4906486,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257791',4906487,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257791',4906488,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257791',4906489,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257791',4906490,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257791',4906491,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257791',4906492,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257791',4906493,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257792',4906494,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257792',4906495,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257792',4906496,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257792',4906497,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257792',4906498,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257792',4906499,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257792',4906500,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257792',4906501,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257792',4906502,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257792',4906503,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257793',4906504,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257793',4906505,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257793',4906506,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257793',4906507,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257793',4906508,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257793',4906509,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257793',4906510,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257793',4906511,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257793',4906512,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257793',4906513,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257794',4906514,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257794',4906515,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257794',4906516,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257794',4906517,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257794',4906518,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257794',4906519,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257794',4906520,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257794',4906521,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257794',4906522,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257794',4906523,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257795',4906524,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257795',4906525,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257795',4906526,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257795',4906527,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257795',4906528,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257795',4906529,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257795',4906530,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257795',4906531,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257795',4906532,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257795',4906533,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257796',4906534,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257796',4906535,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257796',4906536,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257796',4906537,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257796',4906538,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257796',4906539,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257796',4906540,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257796',4906541,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257796',4906542,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257796',4906543,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257797',4906544,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257797',4906545,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257797',4906546,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257797',4906547,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257797',4906548,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257797',4906549,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257797',4906550,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257797',4906551,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257797',4906552,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257797',4906553,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257798',4906554,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257798',4906555,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257798',4906556,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257798',4906557,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257798',4906558,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257798',4906559,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257798',4906560,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257798',4906561,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257798',4906562,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257798',4906563,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257801',4906564,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257801',4906565,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257801',4906566,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257801',4906567,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257801',4906568,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257801',4906569,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257801',4906570,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257801',4906571,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257801',4906572,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257801',4906573,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257802',4906574,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257802',4906575,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257802',4906576,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257802',4906577,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257802',4906578,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257802',4906579,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257802',4906580,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257802',4906581,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257802',4906582,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257802',4906583,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257803',4906584,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257803',4906585,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257803',4906586,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257803',4906587,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257803',4906588,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257803',4906589,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257803',4906590,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257803',4906591,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257803',4906592,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257803',4906593,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257804',4906594,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257804',4906595,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257804',4906596,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257804',4906597,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257804',4906598,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257804',4906599,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257804',4906600,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257804',4906601,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257804',4906602,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257804',4906603,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257805',4906604,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257805',4906605,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257805',4906606,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257805',4906607,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257805',4906608,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257805',4906609,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257805',4906610,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257805',4906611,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257805',4906612,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257805',4906613,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257806',4906614,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257806',4906615,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257806',4906616,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257806',4906617,'1827','270',2601024.35,2601024.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257806',4906618,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257806',4906619,'1829','270',766450.33,766450.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257806',4906620,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257806',4906621,'1831','270',2336457.26,2336457.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257806',4906622,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257806',4906623,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257807',4906624,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257807',4906625,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257807',4906626,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257807',4906627,'1827','270',2601024.35,2601403.85,379.50,70207.50,0.00,0.00,0.00,0.00,0.00),('5','90','669','257807',4906628,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257807',4906629,'1829','270',766450.33,767873.50,1423.17,263286.45,0.00,0.00,0.00,0.00,0.00),('5','90','672','257807',4906630,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257807',4906631,'1831','270',2336457.26,2337206.00,748.74,138516.90,0.00,0.00,0.00,0.00,0.00),('5','90','673','257807',4906632,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257807',4906633,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257808',4906634,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257808',4906635,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257808',4906636,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257808',4906637,'1827','270',2601403.85,2604404.16,3000.31,555057.35,0.00,0.00,0.00,0.00,0.00),('5','90','669','257808',4906638,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257808',4906639,'1829','270',767873.50,774261.41,6387.91,1181763.35,0.00,0.00,0.00,0.00,0.00),('5','90','672','257808',4906640,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257808',4906641,'1831','270',2337206.00,2341967.49,4761.49,880875.65,0.00,0.00,0.00,0.00,0.00),('5','90','673','257808',4906642,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257808',4906643,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257809',4906644,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257809',4906645,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257809',4906646,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257809',4906647,'1827','270',2604404.16,2605802.41,1398.25,258676.25,0.00,0.00,0.00,0.00,0.00),('5','90','669','257809',4906648,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257809',4906649,'1829','270',774261.41,779427.95,5166.54,955809.90,0.00,0.00,0.00,0.00,0.00),('5','90','672','257809',4906650,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257809',4906651,'1831','270',2341967.49,2346178.59,4211.10,779053.50,0.00,0.00,0.00,0.00,0.00),('5','90','673','257809',4906652,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257809',4906653,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257810',4906654,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257810',4906655,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257810',4906656,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257810',4906657,'1827','270',2605802.41,2614113.47,8311.06,1537546.10,0.00,0.00,0.00,0.00,0.00),('5','90','669','257810',4906658,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257810',4906659,'1829','270',779427.95,779427.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257810',4906660,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257810',4906661,'1831','270',2346178.59,2348178.59,2000.00,370000.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257810',4906662,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257810',4906663,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257811',4906664,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257811',4906665,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257811',4906666,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257811',4906667,'1827','270',2614113.47,2623491.95,9378.48,1735018.80,0.00,0.00,0.00,0.00,0.00),('5','90','669','257811',4906668,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257811',4906669,'1829','270',779427.95,784930.59,5502.64,1017988.40,0.00,0.00,0.00,0.00,0.00),('5','90','672','257811',4906670,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257811',4906671,'1831','270',2348178.59,2357125.63,8947.04,1655202.40,0.00,0.00,0.00,0.00,0.00),('5','90','673','257811',4906672,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257811',4906673,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257812',4906674,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257812',4906675,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257812',4906676,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257812',4906677,'1827','270',2623491.95,2628121.80,4629.85,856522.25,0.00,0.00,0.00,0.00,0.00),('5','90','669','257812',4906678,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257812',4906679,'1829','270',784930.59,785994.88,1064.29,196893.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','257812',4906680,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257812',4906681,'1831','270',2357125.63,2362156.84,5031.21,930773.85,0.00,0.00,0.00,0.00,0.00),('5','90','673','257812',4906682,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257812',4906683,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257813',4906684,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257813',4906685,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257813',4906686,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257813',4906687,'1827','270',2628121.80,2633703.97,5582.17,1032701.45,0.00,0.00,0.00,0.00,0.00),('5','90','669','257813',4906688,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257813',4906689,'1829','270',785994.88,792003.77,6008.89,1111644.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','257813',4906690,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257813',4906691,'1831','270',2362156.84,2362156.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257813',4906692,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257813',4906693,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257814',4906694,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257814',4906695,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257814',4906696,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257814',4906697,'1827','270',2633703.97,2641737.16,8033.19,1486140.15,0.00,0.00,0.00,0.00,0.00),('5','90','669','257814',4906698,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257814',4906699,'1829','270',792003.77,792003.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257814',4906700,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257814',4906701,'1831','270',2362156.84,2362156.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257814',4906702,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257814',4906703,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257815',4906704,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257815',4906705,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257815',4906706,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257815',4906707,'1827','270',2641737.16,2645203.64,3466.48,571969.20,0.00,0.00,0.00,0.00,0.00),('5','90','669','257815',4906708,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257815',4906709,'1829','270',792003.77,792003.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257815',4906710,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257815',4906711,'1831','270',2362156.84,2367434.33,5277.49,870785.85,0.00,0.00,0.00,0.00,0.00),('5','90','673','257815',4906712,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257815',4906713,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257816',4906714,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257816',4906715,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257816',4906716,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257816',4906717,'1827','270',2645203.64,2647691.78,2488.14,460305.90,0.00,0.00,0.00,0.00,0.00),('5','90','669','257816',4906718,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257816',4906719,'1829','270',792003.77,795533.61,3529.84,653020.40,0.00,0.00,0.00,0.00,0.00),('5','90','672','257816',4906720,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257816',4906721,'1831','270',2367434.33,2370711.77,3277.44,606326.40,0.00,0.00,0.00,0.00,0.00),('5','90','673','257816',4906722,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257816',4906723,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257817',4906724,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257817',4906725,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257817',4906726,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257817',4906727,'1827','270',2647691.78,2652496.33,4804.55,888841.75,0.00,0.00,0.00,0.00,0.00),('5','90','669','257817',4906728,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257817',4906729,'1829','270',795533.61,799864.84,4331.23,801277.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257817',4906730,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257817',4906731,'1831','270',2370711.77,2375692.36,4980.59,921409.15,0.00,0.00,0.00,0.00,0.00),('5','90','673','257817',4906732,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257817',4906733,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257818',4906734,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257818',4906735,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257818',4906736,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257818',4906737,'1827','270',2652496.33,2658593.93,6097.60,1128056.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257818',4906738,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257818',4906739,'1829','270',799864.84,803625.05,3760.21,695638.85,0.00,0.00,0.00,0.00,0.00),('5','90','672','257818',4906740,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257818',4906741,'1831','270',2375692.36,2379939.99,4247.63,785811.55,0.00,0.00,0.00,0.00,0.00),('5','90','673','257818',4906742,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257818',4906743,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257819',4906744,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257819',4906745,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257819',4906746,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257819',4906747,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257819',4906748,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257819',4906749,'1829','270',803625.05,805198.54,1573.49,291095.65,0.00,0.00,0.00,0.00,0.00),('5','90','672','257819',4906750,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257819',4906751,'1831','270',2379939.99,2380930.00,990.01,183151.85,0.00,0.00,0.00,0.00,0.00),('5','90','673','257819',4906752,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257819',4906753,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257820',4906754,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257820',4906755,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257820',4906756,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257820',4906757,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257820',4906758,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257820',4906759,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257820',4906760,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257820',4906761,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257820',4906762,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257820',4906763,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257821',4906764,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257821',4906765,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257821',4906766,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257821',4906767,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257821',4906768,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257821',4906769,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257821',4906770,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257821',4906771,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257821',4906772,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257821',4906773,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257822',4906774,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257822',4906775,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257822',4906776,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257822',4906777,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257822',4906778,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257822',4906779,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257822',4906780,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257822',4906781,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257822',4906782,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257822',4906783,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257823',4906784,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257823',4906785,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257823',4906786,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257823',4906787,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257823',4906788,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257823',4906789,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257823',4906790,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257823',4906791,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257823',4906792,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257823',4906793,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257824',4906794,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257824',4906795,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257824',4906796,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257824',4906797,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257824',4906798,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257824',4906799,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257824',4906800,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257824',4906801,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257824',4906802,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257824',4906803,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257825',4906804,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257825',4906805,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257825',4906806,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257825',4906807,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257825',4906808,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257825',4906809,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257825',4906810,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257825',4906811,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257825',4906812,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257825',4906813,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257826',4906814,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257826',4906815,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257826',4906816,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257826',4906817,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257826',4906818,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257826',4906819,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257826',4906820,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257826',4906821,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257826',4906822,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257826',4906823,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257827',4906824,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257827',4906825,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257827',4906826,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257827',4906827,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257827',4906828,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257827',4906829,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257827',4906830,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257827',4906831,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257827',4906832,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257827',4906833,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257828',4906834,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257828',4906835,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257828',4906836,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257828',4906837,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257828',4906838,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257828',4906839,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257828',4906840,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257828',4906841,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257828',4906842,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257828',4906843,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257829',4906844,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257829',4906845,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257829',4906846,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257829',4906847,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257829',4906848,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257829',4906849,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257829',4906850,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257829',4906851,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257829',4906852,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257829',4906853,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257830',4906854,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257830',4906855,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257830',4906856,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257830',4906857,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257830',4906858,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257830',4906859,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257830',4906860,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257830',4906861,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257830',4906862,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257830',4906863,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257831',4906864,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257831',4906865,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257831',4906866,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257831',4906867,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257831',4906868,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257831',4906869,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257831',4906870,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257831',4906871,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257831',4906872,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257831',4906873,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257832',4906874,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257832',4906875,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257832',4906876,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257832',4906877,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257832',4906878,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257832',4906879,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257832',4906880,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257832',4906881,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257832',4906882,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257832',4906883,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257833',4906884,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257833',4906885,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257833',4906886,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257833',4906887,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257833',4906888,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257833',4906889,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257833',4906890,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257833',4906891,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257833',4906892,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257833',4906893,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257834',4906894,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257834',4906895,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257834',4906896,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257834',4906897,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257834',4906898,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257834',4906899,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257834',4906900,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257834',4906901,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257834',4906902,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257834',4906903,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257835',4906904,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257835',4906905,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257835',4906906,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257835',4906907,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257835',4906908,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257835',4906909,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257835',4906910,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257835',4906911,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257835',4906912,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257835',4906913,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257836',4906914,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257836',4906915,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257836',4906916,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257836',4906917,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257836',4906918,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257836',4906919,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257836',4906920,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257836',4906921,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257836',4906922,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257836',4906923,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257837',4906924,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257837',4906925,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257837',4906926,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257837',4906927,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257837',4906928,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257837',4906929,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257837',4906930,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257837',4906931,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257837',4906932,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257837',4906933,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257838',4906934,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257838',4906935,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257838',4906936,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257838',4906937,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257838',4906938,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257838',4906939,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257838',4906940,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257838',4906941,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257838',4906942,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257838',4906943,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257839',4906944,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257839',4906945,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257839',4906946,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257839',4906947,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257839',4906948,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257839',4906949,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257839',4906950,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257839',4906951,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257839',4906952,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257839',4906953,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257840',4906954,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257840',4906955,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257840',4906956,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257840',4906957,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257840',4906958,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257840',4906959,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257840',4906960,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257840',4906961,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257840',4906962,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257840',4906963,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257841',4906964,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257841',4906965,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257841',4906966,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257841',4906967,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257841',4906968,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257841',4906969,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257841',4906970,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257841',4906971,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257841',4906972,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257841',4906973,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257842',4906974,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257842',4906975,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257842',4906976,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257842',4906977,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257842',4906978,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257842',4906979,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257842',4906980,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257842',4906981,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257842',4906982,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257842',4906983,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257843',4906984,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257843',4906985,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257843',4906986,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257843',4906987,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257843',4906988,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257843',4906989,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257843',4906990,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257843',4906991,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257843',4906992,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257843',4906993,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257844',4906994,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257844',4906995,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257844',4906996,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257844',4906997,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257844',4906998,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257844',4906999,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257844',4907000,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257844',4907001,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257844',4907002,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257844',4907003,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257845',4907004,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257845',4907005,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257845',4907006,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257845',4907007,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257845',4907008,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257845',4907009,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257845',4907010,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257845',4907011,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257845',4907012,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257845',4907013,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257846',4907014,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257846',4907015,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257846',4907016,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257846',4907017,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257846',4907018,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257846',4907019,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257846',4907020,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257846',4907021,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257846',4907022,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257846',4907023,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257847',4907024,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257847',4907025,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257847',4907026,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257847',4907027,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257847',4907028,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257847',4907029,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257847',4907030,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257847',4907031,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257847',4907032,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257847',4907033,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257848',4907034,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257848',4907035,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257848',4907036,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257848',4907037,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257848',4907038,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257848',4907039,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257848',4907040,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257848',4907041,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257848',4907042,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257848',4907043,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257849',4907044,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257849',4907045,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257849',4907046,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257849',4907047,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257849',4907048,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257849',4907049,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257849',4907050,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257849',4907051,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257849',4907052,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257849',4907053,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257850',4907054,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257850',4907055,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257850',4907056,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257850',4907057,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257850',4907058,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257850',4907059,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257850',4907060,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257850',4907061,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257850',4907062,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257850',4907063,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257851',4907064,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257851',4907065,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257851',4907066,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257851',4907067,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257851',4907068,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257851',4907069,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257851',4907070,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257851',4907071,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257851',4907072,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257851',4907073,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257852',4907074,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257852',4907075,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257852',4907076,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257852',4907077,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257852',4907078,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257852',4907079,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257852',4907080,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257852',4907081,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257852',4907082,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257852',4907083,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257853',4907084,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257853',4907085,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257853',4907086,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257853',4907087,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257853',4907088,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257853',4907089,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257853',4907090,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257853',4907091,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257853',4907092,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257853',4907093,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257854',4907094,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257854',4907095,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257854',4907096,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257854',4907097,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257854',4907098,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257854',4907099,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257854',4907100,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257854',4907101,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257854',4907102,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257854',4907103,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257855',4907104,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257855',4907105,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257855',4907106,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257855',4907107,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257855',4907108,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257855',4907109,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257855',4907110,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257855',4907111,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257855',4907112,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257855',4907113,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257856',4907114,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257856',4907115,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257856',4907116,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257856',4907117,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257856',4907118,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257856',4907119,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257856',4907120,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257856',4907121,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257856',4907122,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257856',4907123,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257857',4907124,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257857',4907125,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257857',4907126,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257857',4907127,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257857',4907128,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257857',4907129,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257857',4907130,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257857',4907131,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257857',4907132,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257857',4907133,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257858',4907134,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257858',4907135,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257858',4907136,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257858',4907137,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257858',4907138,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257858',4907139,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257858',4907140,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257858',4907141,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257858',4907142,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257858',4907143,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257859',4907144,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257859',4907145,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257859',4907146,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257859',4907147,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257859',4907148,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257859',4907149,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257859',4907150,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257859',4907151,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257859',4907152,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257859',4907153,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257860',4907154,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257860',4907155,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257860',4907156,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257860',4907157,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257860',4907158,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257860',4907159,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257860',4907160,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257860',4907161,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257860',4907162,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257860',4907163,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257861',4907164,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257861',4907165,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257861',4907166,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257861',4907167,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257861',4907168,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257861',4907169,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257861',4907170,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257861',4907171,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257861',4907172,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257861',4907173,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257862',4907174,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257862',4907175,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257862',4907176,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257862',4907177,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257862',4907178,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257862',4907179,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257862',4907180,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257862',4907181,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257862',4907182,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257862',4907183,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257863',4907184,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257863',4907185,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257863',4907186,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257863',4907187,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257863',4907188,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257863',4907189,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257863',4907190,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257863',4907191,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257863',4907192,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257863',4907193,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257864',4907194,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257864',4907195,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257864',4907196,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257864',4907197,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257864',4907198,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257864',4907199,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257864',4907200,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257864',4907201,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257864',4907202,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257864',4907203,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257865',4907204,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257865',4907205,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257865',4907206,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257865',4907207,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257865',4907208,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257865',4907209,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257865',4907210,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257865',4907211,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257865',4907212,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257865',4907213,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257866',4907214,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257866',4907215,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257866',4907216,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257866',4907217,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257866',4907218,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257866',4907219,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257866',4907220,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257866',4907221,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257866',4907222,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257866',4907223,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257867',4907224,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257867',4907225,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257867',4907226,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257867',4907227,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257867',4907228,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257867',4907229,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257867',4907230,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257867',4907231,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257867',4907232,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257867',4907233,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257868',4907234,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257868',4907235,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257868',4907236,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257868',4907237,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257868',4907238,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257868',4907239,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257868',4907240,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257868',4907241,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257868',4907242,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257868',4907243,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257869',4907244,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257869',4907245,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257869',4907246,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257869',4907247,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257869',4907248,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257869',4907249,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257869',4907250,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257869',4907251,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257869',4907252,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257869',4907253,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257870',4907254,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257870',4907255,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257870',4907256,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257870',4907257,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257870',4907258,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257870',4907259,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257870',4907260,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257870',4907261,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257870',4907262,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257870',4907263,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257871',4907264,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257871',4907265,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257871',4907266,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257871',4907267,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257871',4907268,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257871',4907269,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257871',4907270,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257871',4907271,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257871',4907272,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257871',4907273,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257872',4907274,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257872',4907275,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257872',4907276,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257872',4907277,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257872',4907278,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257872',4907279,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257872',4907280,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257872',4907281,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257872',4907282,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257872',4907283,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257873',4907284,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257873',4907285,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257873',4907286,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257873',4907287,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257873',4907288,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257873',4907289,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257873',4907290,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257873',4907291,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257873',4907292,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257873',4907293,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257874',4907294,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257874',4907295,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257874',4907296,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257874',4907297,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257874',4907298,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257874',4907299,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257874',4907300,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257874',4907301,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257874',4907302,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257874',4907303,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257875',4907304,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257875',4907305,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257875',4907306,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257875',4907307,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257875',4907308,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257875',4907309,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257875',4907310,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257875',4907311,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257875',4907312,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257875',4907313,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257876',4907314,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257876',4907315,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257876',4907316,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257876',4907317,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257876',4907318,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257876',4907319,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257876',4907320,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257876',4907321,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257876',4907322,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257876',4907323,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257877',4907324,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257877',4907325,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257877',4907326,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257877',4907327,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257877',4907328,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257877',4907329,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257877',4907330,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257877',4907331,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257877',4907332,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257877',4907333,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257878',4907334,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257878',4907335,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257878',4907336,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257878',4907337,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257878',4907338,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257878',4907339,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257878',4907340,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257878',4907341,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257878',4907342,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257878',4907343,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257879',4907344,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257879',4907345,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257879',4907346,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257879',4907347,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257879',4907348,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257879',4907349,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257879',4907350,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257879',4907351,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257879',4907352,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257879',4907353,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257880',4907354,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257880',4907355,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257880',4907356,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257880',4907357,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257880',4907358,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257880',4907359,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257880',4907360,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257880',4907361,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257880',4907362,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257880',4907363,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257881',4907364,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257881',4907365,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257881',4907366,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257881',4907367,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257881',4907368,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257881',4907369,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257881',4907370,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257881',4907371,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257881',4907372,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257881',4907373,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257882',4907374,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257882',4907375,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257882',4907376,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257882',4907377,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257882',4907378,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257882',4907379,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257882',4907380,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257882',4907381,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257882',4907382,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257882',4907383,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257883',4907384,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257883',4907385,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257883',4907386,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257883',4907387,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257883',4907388,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257883',4907389,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257883',4907390,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257883',4907391,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257883',4907392,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257883',4907393,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257884',4907394,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257884',4907395,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257884',4907396,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257884',4907397,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257884',4907398,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257884',4907399,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257884',4907400,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257884',4907401,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257884',4907402,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257884',4907403,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257885',4907404,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257885',4907405,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257885',4907406,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257885',4907407,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257885',4907408,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257885',4907409,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257885',4907410,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257885',4907411,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257885',4907412,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257885',4907413,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257889',4907414,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257889',4907415,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257889',4907416,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257889',4907417,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257889',4907418,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257889',4907419,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257889',4907420,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257889',4907421,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257889',4907422,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257889',4907423,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257890',4907424,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257890',4907425,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257890',4907426,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257890',4907427,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257890',4907428,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257890',4907429,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257890',4907430,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257890',4907431,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257890',4907432,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257890',4907433,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257892',4907434,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257892',4907435,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257892',4907436,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257892',4907437,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257892',4907438,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257892',4907439,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257892',4907440,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257892',4907441,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257892',4907442,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257892',4907443,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257893',4907444,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257893',4907445,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257893',4907446,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257893',4907447,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257893',4907448,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257893',4907449,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257893',4907450,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257893',4907451,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257893',4907452,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257893',4907453,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257894',4907454,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257894',4907455,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257894',4907456,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257894',4907457,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257894',4907458,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257894',4907459,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257894',4907460,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257894',4907461,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257894',4907462,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257894',4907463,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257895',4907464,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257895',4907465,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257895',4907466,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257895',4907467,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257895',4907468,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257895',4907469,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257895',4907470,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257895',4907471,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257895',4907472,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257895',4907473,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257896',4907474,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257896',4907475,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257896',4907476,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257896',4907477,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257896',4907478,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257896',4907479,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257896',4907480,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257896',4907481,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257896',4907482,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257896',4907483,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257897',4907484,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257897',4907485,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257897',4907486,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257897',4907487,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257897',4907488,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257897',4907489,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257897',4907490,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257897',4907491,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257897',4907492,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257897',4907493,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257898',4907494,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257898',4907495,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257898',4907496,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257898',4907497,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257898',4907498,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257898',4907499,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257898',4907500,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257898',4907501,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257898',4907502,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257898',4907503,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257899',4907504,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257899',4907505,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257899',4907506,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257899',4907507,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257899',4907508,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257899',4907509,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257899',4907510,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257899',4907511,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257899',4907512,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257899',4907513,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257900',4907514,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257900',4907515,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257900',4907516,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257900',4907517,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257900',4907518,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257900',4907519,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257900',4907520,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257900',4907521,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257900',4907522,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257900',4907523,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257901',4907524,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257901',4907525,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257901',4907526,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257901',4907527,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257901',4907528,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257901',4907529,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257901',4907530,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257901',4907531,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257901',4907532,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257901',4907533,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257902',4907534,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257902',4907535,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257902',4907536,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257902',4907537,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257902',4907538,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257902',4907539,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257902',4907540,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257902',4907541,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257902',4907542,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257902',4907543,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257903',4907544,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257903',4907545,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257903',4907546,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257903',4907547,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257903',4907548,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257903',4907549,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257903',4907550,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257903',4907551,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257903',4907552,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257903',4907553,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257904',4907554,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257904',4907555,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257904',4907556,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257904',4907557,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257904',4907558,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257904',4907559,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257904',4907560,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257904',4907561,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257904',4907562,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257904',4907563,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257905',4907564,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257905',4907565,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257905',4907566,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257905',4907567,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257905',4907568,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257905',4907569,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257905',4907570,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257905',4907571,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257905',4907572,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257905',4907573,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257906',4907574,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257906',4907575,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257906',4907576,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257906',4907577,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257906',4907578,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257906',4907579,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257906',4907580,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257906',4907581,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257906',4907582,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257906',4907583,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257907',4907584,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257907',4907585,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257907',4907586,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257907',4907587,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257907',4907588,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257907',4907589,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257907',4907590,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257907',4907591,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257907',4907592,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257907',4907593,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257908',4907594,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257908',4907595,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257908',4907596,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257908',4907597,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257908',4907598,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257908',4907599,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257908',4907600,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257908',4907601,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257908',4907602,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257908',4907603,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257909',4907604,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257909',4907605,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257909',4907606,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257909',4907607,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257909',4907608,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257909',4907609,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257909',4907610,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257909',4907611,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257909',4907612,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257909',4907613,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257910',4907614,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257910',4907615,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257910',4907616,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257910',4907617,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257910',4907618,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257910',4907619,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257910',4907620,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257910',4907621,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257910',4907622,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257910',4907623,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257911',4907624,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257911',4907625,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257911',4907626,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257911',4907627,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257911',4907628,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257911',4907629,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257911',4907630,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257911',4907631,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257911',4907632,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257911',4907633,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257912',4907634,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257912',4907635,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257912',4907636,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257912',4907637,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257912',4907638,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257912',4907639,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257912',4907640,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257912',4907641,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257912',4907642,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257912',4907643,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257913',4907644,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257913',4907645,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257913',4907646,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257913',4907647,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257913',4907648,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257913',4907649,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257913',4907650,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257913',4907651,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257913',4907652,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257913',4907653,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257914',4907654,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257914',4907655,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257914',4907656,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257914',4907657,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257914',4907658,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257914',4907659,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257914',4907660,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257914',4907661,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257914',4907662,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257914',4907663,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257915',4907664,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257915',4907665,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257915',4907666,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257915',4907667,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257915',4907668,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257915',4907669,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257915',4907670,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257915',4907671,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257915',4907672,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257915',4907673,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257916',4907674,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257916',4907675,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257916',4907676,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257916',4907677,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257916',4907678,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257916',4907679,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257916',4907680,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257916',4907681,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257916',4907682,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257916',4907683,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257917',4907684,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257917',4907685,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257917',4907686,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257917',4907687,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257917',4907688,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257917',4907689,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257917',4907690,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257917',4907691,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257917',4907692,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257917',4907693,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257918',4907694,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257918',4907695,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257918',4907696,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257918',4907697,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257918',4907698,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257918',4907699,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257918',4907700,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257918',4907701,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257918',4907702,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257918',4907703,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257919',4907704,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257919',4907705,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257919',4907706,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257919',4907707,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257919',4907708,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257919',4907709,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257919',4907710,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257919',4907711,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257919',4907712,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257919',4907713,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257920',4907714,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257920',4907715,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257920',4907716,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257920',4907717,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257920',4907718,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257920',4907719,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257920',4907720,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257920',4907721,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257920',4907722,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257920',4907723,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257921',4907724,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257921',4907725,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257921',4907726,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257921',4907727,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257921',4907728,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257921',4907729,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257921',4907730,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257921',4907731,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257921',4907732,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257921',4907733,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257922',4907734,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257922',4907735,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257922',4907736,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257922',4907737,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257922',4907738,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257922',4907739,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257922',4907740,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257922',4907741,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257922',4907742,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257922',4907743,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257923',4907744,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257923',4907745,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257923',4907746,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257923',4907747,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257923',4907748,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257923',4907749,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257923',4907750,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257923',4907751,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257923',4907752,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257923',4907753,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257924',4907754,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257924',4907755,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257924',4907756,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257924',4907757,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257924',4907758,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257924',4907759,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257924',4907760,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257924',4907761,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257924',4907762,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257924',4907763,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257925',4907764,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257925',4907765,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257925',4907766,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257925',4907767,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257925',4907768,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257925',4907769,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257925',4907770,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257925',4907771,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257925',4907772,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257925',4907773,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257926',4907774,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257926',4907775,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257926',4907776,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257926',4907777,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257926',4907778,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257926',4907779,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257926',4907780,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257926',4907781,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257926',4907782,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257926',4907783,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257927',4907784,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257927',4907785,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257927',4907786,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257927',4907787,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257927',4907788,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257927',4907789,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257927',4907790,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257927',4907791,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257927',4907792,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257927',4907793,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257928',4907794,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257928',4907795,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257928',4907796,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257928',4907797,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257928',4907798,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257928',4907799,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257928',4907800,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257928',4907801,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257928',4907802,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257928',4907803,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257929',4907804,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257929',4907805,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257929',4907806,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257929',4907807,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257929',4907808,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257929',4907809,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257929',4907810,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257929',4907811,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257929',4907812,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257929',4907813,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257930',4907814,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257930',4907815,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257930',4907816,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257930',4907817,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257930',4907818,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257930',4907819,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257930',4907820,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257930',4907821,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257930',4907822,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257930',4907823,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257931',4907824,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257931',4907825,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257931',4907826,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257931',4907827,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257931',4907828,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257931',4907829,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257931',4907830,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257931',4907831,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257931',4907832,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257931',4907833,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257932',4907834,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257932',4907835,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257932',4907836,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257932',4907837,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257932',4907838,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257932',4907839,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257932',4907840,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257932',4907841,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257932',4907842,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257932',4907843,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257933',4907844,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257933',4907845,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257933',4907846,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257933',4907847,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257933',4907848,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257933',4907849,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257933',4907850,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257933',4907851,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257933',4907852,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257933',4907853,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257934',4907854,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257934',4907855,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257934',4907856,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257934',4907857,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257934',4907858,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257934',4907859,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257934',4907860,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257934',4907861,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257934',4907862,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257934',4907863,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257935',4907864,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257935',4907865,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257935',4907866,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257935',4907867,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257935',4907868,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257935',4907869,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257935',4907870,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257935',4907871,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257935',4907872,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257935',4907873,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257936',4907874,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257936',4907875,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257936',4907876,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257936',4907877,'1827','270',2658593.93,2658593.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257936',4907878,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257936',4907879,'1829','270',805198.54,805198.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257936',4907880,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257936',4907881,'1831','270',2380930.00,2380930.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257936',4907882,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257936',4907883,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257937',4907884,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257937',4907885,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257937',4907886,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257937',4907887,'1827','270',2658593.93,2661378.10,2784.17,459388.05,0.00,0.00,0.00,0.00,0.00),('5','90','669','257937',4907888,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257937',4907889,'1829','270',805198.54,807142.88,1944.34,320816.10,0.00,0.00,0.00,0.00,0.00),('5','90','672','257937',4907890,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257937',4907891,'1831','270',2380930.00,2385143.83,4213.83,695281.95,0.00,0.00,0.00,0.00,0.00),('5','90','673','257937',4907892,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257937',4907893,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257938',4907894,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257938',4907895,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257938',4907896,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257938',4907897,'1827','270',2661378.10,2665282.46,3904.36,819915.60,0.00,0.00,0.00,0.00,0.00),('5','90','669','257938',4907898,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257938',4907899,'1829','270',807142.88,813044.57,5901.69,1239354.90,0.00,0.00,0.00,0.00,0.00),('5','90','672','257938',4907900,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257938',4907901,'1831','270',2385143.83,2388103.03,2959.20,621432.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257938',4907902,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257938',4907903,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257939',4907904,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257939',4907905,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257939',4907906,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257939',4907907,'1827','270',2665282.46,2667727.96,2445.50,403507.50,0.00,0.00,0.00,0.00,0.00),('5','90','669','257939',4907908,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257939',4907909,'1829','270',813044.57,817004.24,3959.67,653345.55,0.00,0.00,0.00,0.00,0.00),('5','90','672','257939',4907910,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257939',4907911,'1831','270',2388103.03,2390240.03,2137.00,352605.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257939',4907912,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257939',4907913,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257940',4907914,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257940',4907915,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257940',4907916,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257940',4907917,'1827','270',2667727.96,2667864.40,136.44,28652.40,0.00,0.00,0.00,0.00,0.00),('5','90','669','257940',4907918,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257940',4907919,'1829','270',817004.24,821463.33,4459.09,936408.90,0.00,0.00,0.00,0.00,0.00),('5','90','672','257940',4907920,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257940',4907921,'1831','270',2390240.03,2390872.21,632.18,132757.80,0.00,0.00,0.00,0.00,0.00),('5','90','673','257940',4907922,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257940',4907923,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257941',4907924,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257941',4907925,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257941',4907926,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257941',4907927,'1827','270',2667864.40,2671909.71,4045.31,849515.10,0.00,0.00,0.00,0.00,0.00),('5','90','669','257941',4907928,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257941',4907929,'1829','270',821463.33,822687.90,1224.57,257159.70,0.00,0.00,0.00,0.00,0.00),('5','90','672','257941',4907930,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257941',4907931,'1831','270',2390872.21,2393185.59,2313.38,485809.80,0.00,0.00,0.00,0.00,0.00),('5','90','673','257941',4907932,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257941',4907933,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257942',4907934,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257942',4907935,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257942',4907936,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257942',4907937,'1827','270',2671909.71,2673623.76,1714.05,359950.50,0.00,0.00,0.00,0.00,0.00),('5','90','669','257942',4907938,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257942',4907939,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257942',4907940,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257942',4907941,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257942',4907942,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257942',4907943,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257943',4907944,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257943',4907945,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257943',4907946,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257943',4907947,'1827','270',2673623.76,2673623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257943',4907948,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257943',4907949,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257943',4907950,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257943',4907951,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257943',4907952,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257943',4907953,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257944',4907954,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257944',4907955,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257944',4907956,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257944',4907957,'1827','270',2673623.76,2673623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257944',4907958,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257944',4907959,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257944',4907960,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257944',4907961,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257944',4907962,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257944',4907963,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257945',4907964,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257945',4907965,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257945',4907966,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257945',4907967,'1827','270',2673623.76,2673623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257945',4907968,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257945',4907969,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257945',4907970,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257945',4907971,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257945',4907972,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257945',4907973,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257946',4907974,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257946',4907975,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257946',4907976,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257946',4907977,'1827','270',2673623.76,2673623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257946',4907978,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257946',4907979,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257946',4907980,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257946',4907981,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257946',4907982,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257946',4907983,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257947',4907984,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257947',4907985,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257947',4907986,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257947',4907987,'1827','270',2673623.76,2673623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257947',4907988,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257947',4907989,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257947',4907990,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257947',4907991,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257947',4907992,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257947',4907993,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257948',4907994,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257948',4907995,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257948',4907996,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257948',4907997,'1827','270',2673623.76,2673623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257948',4907998,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257948',4907999,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257948',4908000,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257948',4908001,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257948',4908002,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257948',4908003,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257949',4908004,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257949',4908005,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257949',4908006,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257949',4908007,'1827','270',2673623.76,2673623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257949',4908008,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257949',4908009,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257949',4908010,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257949',4908011,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257949',4908012,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257949',4908013,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257950',4908014,'1824','270',50.00,50.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257950',4908015,'1825','270',403918.56,403918.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','671','257950',4908016,'1826','270',1052510.23,1052510.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','668','257950',4908017,'1827','270',2673623.76,2673623.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','669','257950',4908018,'1828','270',562162.14,562162.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257950',4908019,'1829','270',822687.90,822687.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','672','257950',4908020,'1830','270',53.94,53.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','670','257950',4908021,'1831','270',2393185.59,2393185.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','673','257950',4908022,'1832','271',650093.73,650093.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','90','674','257950',4908023,'1833','272',40567.00,40567.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
/*!40000 ALTER TABLE `depots_shifts_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_products`
--

DROP TABLE IF EXISTS `depots_shifts_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_products` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `selling` decimal(20,2) DEFAULT '0.00',
  `sold` decimal(20,2) DEFAULT '0.00',
  `retail_sold` decimal(20,2) DEFAULT '0.00',
  `retail_cost` decimal(20,2) DEFAULT '0.00',
  `retail_revenue` decimal(20,2) DEFAULT '0.00',
  `retail_profit` decimal(20,2) DEFAULT '0.00',
  `id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `companycode` (`company_id`,`shift_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=730961 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_products`
--

LOCK TABLES `depots_shifts_products` WRITE;
/*!40000 ALTER TABLE `depots_shifts_products` DISABLE KEYS */;
INSERT INTO `depots_shifts_products` VALUES ('5','90','212839','270',165.00,165.00,2125.67,0.00,0.00,0.00,0.00,613641),('5','90','212839','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,613642),('5','90','212839','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,613643),('5','90','213087','270',165.00,165.00,2422.96,0.00,0.00,0.00,0.00,614294),('5','90','213087','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614295),('5','90','213087','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614296),('5','90','213090','270',165.00,165.00,2466.34,0.00,0.00,0.00,0.00,614302),('5','90','213090','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614303),('5','90','213090','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614304),('5','90','213229','270',165.00,165.00,1338.39,0.00,0.00,0.00,0.00,614652),('5','90','213229','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,614653),('5','90','213229','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,614654),('5','90','213495','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,615342),('5','90','213495','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615343),('5','90','213495','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615344),('5','90','213498','270',165.00,165.00,2661.11,0.00,0.00,0.00,0.00,615349),('5','90','213498','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615350),('5','90','213498','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615351),('5','90','213599','270',165.00,165.00,2822.26,0.00,0.00,0.00,0.00,615631),('5','90','213599','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,615632),('5','90','213599','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,615633),('5','90','213862','270',165.00,165.00,7388.53,0.00,0.00,0.00,0.00,616321),('5','90','213862','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616322),('5','90','213862','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616323),('5','90','213977','270',165.00,165.00,2253.25,0.00,0.00,0.00,0.00,616611),('5','90','213977','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616612),('5','90','213977','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616613),('5','90','214125','270',165.00,165.00,2006.85,0.00,0.00,0.00,0.00,616986),('5','90','214125','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,616987),('5','90','214125','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,616988),('5','90','214345','270',165.00,165.00,2202.80,0.00,0.00,0.00,0.00,617560),('5','90','214345','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,617561),('5','90','214345','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,617562),('5','90','214595','270',165.00,165.00,2924.09,0.00,0.00,0.00,0.00,618207),('5','90','214595','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618208),('5','90','214595','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618209),('5','90','214779','270',165.00,165.00,3490.98,0.00,0.00,0.00,0.00,618689),('5','90','214779','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,618690),('5','90','214779','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,618691),('5','90','214995','270',165.00,165.00,2185.44,0.00,0.00,0.00,0.00,619260),('5','90','214995','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619261),('5','90','214995','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619262),('5','90','215231','270',165.00,165.00,7778.42,0.00,0.00,0.00,0.00,619856),('5','90','215231','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,619857),('5','90','215231','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,619858),('5','90','215505','270',165.00,165.00,2812.94,0.00,0.00,0.00,0.00,620560),('5','90','215505','271',295.00,295.00,177.49,0.00,0.00,0.00,0.00,620561),('5','90','215505','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,620562),('5','90','215680','270',165.00,165.00,2641.40,0.00,0.00,0.00,0.00,621018),('5','90','215680','271',295.00,295.00,180.23,0.00,0.00,0.00,0.00,621019),('5','90','215680','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621020),('5','90','215895','270',165.00,165.00,2098.99,0.00,0.00,0.00,0.00,621575),('5','90','215895','271',295.00,295.00,38.89,0.00,0.00,0.00,0.00,621576),('5','90','215895','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,621577),('5','90','216114','270',165.00,165.00,2455.78,0.00,0.00,0.00,0.00,622134),('5','90','216114','271',295.00,295.00,58.92,0.00,0.00,0.00,0.00,622135),('5','90','216114','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622136),('5','90','216330','270',165.00,165.00,2521.69,0.00,0.00,0.00,0.00,622696),('5','90','216330','271',295.00,295.00,31.42,0.00,0.00,0.00,0.00,622697),('5','90','216330','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,622698),('5','90','216552','270',165.00,165.00,1855.36,0.00,0.00,0.00,0.00,623291),('5','90','216552','271',295.00,295.00,27.44,0.00,0.00,0.00,0.00,623292),('5','90','216552','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623293),('5','90','216790','270',165.00,165.00,7486.03,0.00,0.00,0.00,0.00,623916),('5','90','216790','271',295.00,295.00,191.91,0.00,0.00,0.00,0.00,623917),('5','90','216790','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,623918),('5','90','217076','270',165.00,165.00,2141.17,0.00,0.00,0.00,0.00,624656),('5','90','217076','271',295.00,295.00,33.79,0.00,0.00,0.00,0.00,624657),('5','90','217076','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,624658),('5','90','217292','270',165.00,165.00,1955.68,0.00,0.00,0.00,0.00,625221),('5','90','217292','271',295.00,295.00,63.29,0.00,0.00,0.00,0.00,625222),('5','90','217292','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,625223),('5','90','217690','270',165.00,165.00,2260.06,0.00,0.00,0.00,0.00,626281),('5','90','217690','271',295.00,295.00,94.28,0.00,0.00,0.00,0.00,626282),('5','90','217690','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626283),('5','90','217853','270',165.00,165.00,2035.05,0.00,0.00,0.00,0.00,626701),('5','90','217853','271',295.00,295.00,146.04,0.00,0.00,0.00,0.00,626702),('5','90','217853','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,626703),('5','90','218105','270',165.00,165.00,2355.88,0.00,0.00,0.00,0.00,627353),('5','90','218105','271',295.00,295.00,59.55,0.00,0.00,0.00,0.00,627354),('5','90','218105','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627355),('5','90','218221','270',165.00,165.00,1569.25,0.00,0.00,0.00,0.00,627666),('5','90','218221','271',295.00,295.00,113.39,0.00,0.00,0.00,0.00,627667),('5','90','218221','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,627668),('5','90','218457','270',165.00,165.00,3881.32,0.00,0.00,0.00,0.00,628278),('5','90','218457','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,628279),('5','90','218457','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,628280),('5','90','218841','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,629287),('5','90','218841','271',295.00,295.00,222.32,0.00,0.00,0.00,0.00,629288),('5','90','218841','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629289),('5','90','219098','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,629961),('5','90','219098','271',295.00,295.00,52.88,0.00,0.00,0.00,0.00,629962),('5','90','219098','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,629963),('5','90','219119','270',165.00,165.00,1847.64,0.00,0.00,0.00,0.00,630006),('5','90','219119','271',295.00,295.00,111.93,0.00,0.00,0.00,0.00,630007),('5','90','219119','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630008),('5','90','219420','270',165.00,165.00,1864.07,0.00,0.00,0.00,0.00,630790),('5','90','219420','271',295.00,295.00,106.02,0.00,0.00,0.00,0.00,630791),('5','90','219420','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,630792),('5','90','219655','270',165.00,165.00,1807.71,0.00,0.00,0.00,0.00,631409),('5','90','219655','271',295.00,295.00,232.30,0.00,0.00,0.00,0.00,631410),('5','90','219655','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631411),('5','90','219852','270',165.00,165.00,1289.81,0.00,0.00,0.00,0.00,631924),('5','90','219852','271',295.00,295.00,77.01,0.00,0.00,0.00,0.00,631925),('5','90','219852','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,631926),('5','90','220019','270',165.00,165.00,6775.95,0.00,0.00,0.00,0.00,632395),('5','90','220019','271',295.00,295.00,321.91,0.00,0.00,0.00,0.00,632396),('5','90','220019','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632397),('5','90','220248','270',165.00,165.00,2082.84,0.00,0.00,0.00,0.00,632983),('5','90','220248','271',295.00,295.00,76.16,0.00,0.00,0.00,0.00,632984),('5','90','220248','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,632985),('5','90','220490','270',165.00,165.00,1425.94,0.00,0.00,0.00,0.00,633613),('5','90','220490','271',295.00,295.00,26.07,0.00,0.00,0.00,0.00,633614),('5','90','220490','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,633615),('5','90','220706','270',165.00,165.00,1865.05,0.00,0.00,0.00,0.00,634171),('5','90','220706','271',295.00,295.00,61.62,0.00,0.00,0.00,0.00,634172),('5','90','220706','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634173),('5','90','220939','270',165.00,165.00,1931.50,0.00,0.00,0.00,0.00,634778),('5','90','220939','271',295.00,295.00,41.31,0.00,0.00,0.00,0.00,634779),('5','90','220939','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,634780),('5','90','221160','270',165.00,165.00,2136.56,0.00,0.00,0.00,0.00,635346),('5','90','221160','271',295.00,295.00,104.60,0.00,0.00,0.00,0.00,635347),('5','90','221160','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,635348),('5','90','221416','270',165.00,165.00,2622.63,0.00,0.00,0.00,0.00,636019),('5','90','221416','271',295.00,295.00,69.60,0.00,0.00,0.00,0.00,636020),('5','90','221416','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636021),('5','90','221638','270',165.00,165.00,6783.61,0.00,0.00,0.00,0.00,636599),('5','90','221638','271',295.00,295.00,375.90,0.00,0.00,0.00,0.00,636600),('5','90','221638','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,636601),('5','90','221913','270',165.00,165.00,2399.55,0.00,0.00,0.00,0.00,637316),('5','90','221913','271',295.00,295.00,162.80,0.00,0.00,0.00,0.00,637317),('5','90','221913','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637318),('5','90','222059','270',165.00,165.00,1892.98,0.00,0.00,0.00,0.00,637708),('5','90','222059','271',295.00,295.00,32.16,0.00,0.00,0.00,0.00,637709),('5','90','222059','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,637710),('5','90','222267','270',165.00,165.00,1912.58,0.00,0.00,0.00,0.00,638233),('5','90','222267','271',295.00,295.00,105.88,0.00,0.00,0.00,0.00,638234),('5','90','222267','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638235),('5','90','222494','270',165.00,165.00,2002.98,0.00,0.00,0.00,0.00,638814),('5','90','222494','271',295.00,295.00,54.41,0.00,0.00,0.00,0.00,638815),('5','90','222494','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,638816),('5','90','222846','270',165.00,165.00,1161.65,0.00,0.00,0.00,0.00,639750),('5','90','222846','271',295.00,295.00,101.57,0.00,0.00,0.00,0.00,639751),('5','90','222846','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,639752),('5','90','222953','270',165.00,165.00,1630.80,0.00,0.00,0.00,0.00,640041),('5','90','222953','271',295.00,295.00,88.83,0.00,0.00,0.00,0.00,640042),('5','90','222953','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640043),('5','90','223237','270',165.00,165.00,6860.55,0.00,0.00,0.00,0.00,640756),('5','90','223237','271',295.00,295.00,328.12,0.00,0.00,0.00,0.00,640757),('5','90','223237','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,640758),('5','90','223625','270',165.00,165.00,1809.34,0.00,0.00,0.00,0.00,641748),('5','90','223625','271',295.00,295.00,47.53,0.00,0.00,0.00,0.00,641749),('5','90','223625','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,641750),('5','90','223857','270',165.00,165.00,1788.85,0.00,0.00,0.00,0.00,642341),('5','90','223857','271',295.00,295.00,62.73,0.00,0.00,0.00,0.00,642342),('5','90','223857','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642343),('5','90','223877','270',165.00,165.00,1896.81,0.00,0.00,0.00,0.00,642385),('5','90','223877','271',295.00,295.00,44.65,0.00,0.00,0.00,0.00,642386),('5','90','223877','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,642387),('5','90','224121','270',165.00,165.00,94.36,0.00,0.00,0.00,0.00,643014),('5','90','224121','271',295.00,295.00,35.82,0.00,0.00,0.00,0.00,643015),('5','90','224121','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643016),('5','90','224320','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,643529),('5','90','224320','271',295.00,295.00,65.49,0.00,0.00,0.00,0.00,643530),('5','90','224320','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,643531),('5','90','224554','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,644145),('5','90','224554','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,644146),('5','90','224554','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,644147),('5','90','224994','270',165.00,163.00,2390.59,0.00,0.00,0.00,0.00,645296),('5','90','224994','271',295.00,295.00,16.92,0.00,0.00,0.00,0.00,645297),('5','90','224994','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645298),('5','90','225022','270',165.00,163.00,2245.14,0.00,0.00,0.00,0.00,645347),('5','90','225022','271',295.00,295.00,83.14,0.00,0.00,0.00,0.00,645348),('5','90','225022','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,645349),('5','90','225296','270',165.00,163.00,2019.62,0.00,0.00,0.00,0.00,646041),('5','90','225296','271',295.00,295.00,125.18,0.00,0.00,0.00,0.00,646042),('5','90','225296','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646043),('5','90','225481','270',165.00,163.00,1847.11,0.00,0.00,0.00,0.00,646537),('5','90','225481','271',295.00,295.00,76.26,0.00,0.00,0.00,0.00,646538),('5','90','225481','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,646539),('5','90','225718','270',165.00,163.00,409.74,0.00,0.00,0.00,0.00,647144),('5','90','225718','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647145),('5','90','225718','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647146),('5','90','226000','270',165.00,163.00,2249.85,0.00,0.00,0.00,0.00,647877),('5','90','226000','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,647878),('5','90','226000','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,647879),('5','90','226382','270',165.00,163.00,2082.74,0.00,0.00,0.00,0.00,648889),('5','90','226382','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,648890),('5','90','226382','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,648891),('5','90','226547','270',165.00,163.00,6856.71,0.00,0.00,0.00,0.00,649286),('5','90','226547','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,649287),('5','90','226547','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,649288),('5','90','226840','270',165.00,163.00,2075.98,0.00,0.00,0.00,0.00,650062),('5','90','226840','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650063),('5','90','226840','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650064),('5','90','227059','270',165.00,163.00,2180.72,0.00,0.00,0.00,0.00,650631),('5','90','227059','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650632),('5','90','227059','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650633),('5','90','227200','270',165.00,163.00,1685.10,0.00,0.00,0.00,0.00,650989),('5','90','227200','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,650990),('5','90','227200','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,650991),('5','90','227394','270',165.00,163.00,540.76,0.00,0.00,0.00,0.00,651483),('5','90','227394','271',295.00,295.00,0.00,0.00,0.00,0.00,0.00,651484),('5','90','227394','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,651485),('5','90','227670','270',165.00,163.00,0.00,0.00,0.00,0.00,0.00,652198),('5','90','227670','271',295.00,300.00,0.00,0.00,0.00,0.00,0.00,652199),('5','90','227670','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,652200),('5','90','229380','270',165.00,163.00,0.00,0.00,0.00,0.00,0.00,656642),('5','90','229380','271',295.00,300.00,0.00,0.00,0.00,0.00,0.00,656643),('5','90','229380','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,656644),('5','90','230664','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,659947),('5','90','230664','271',300.00,300.00,0.00,0.00,0.00,0.00,0.00,659948),('5','90','230664','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,659949),('5','90','230704','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660060),('5','90','230704','271',300.00,300.00,89.11,0.00,0.00,0.00,0.00,660061),('5','90','230704','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660062),('5','90','230706','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660065),('5','90','230706','271',300.00,310.00,0.00,0.00,0.00,0.00,0.00,660066),('5','90','230706','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660067),('5','90','230766','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,660222),('5','90','230766','271',310.00,310.00,0.00,0.00,0.00,0.00,0.00,660223),('5','90','230766','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,660224),('5','90','231139','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661186),('5','90','231139','271',310.00,310.00,309.20,0.00,0.00,0.00,0.00,661187),('5','90','231139','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661188),('5','90','231142','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661195),('5','90','231142','271',310.00,310.00,419.88,0.00,0.00,0.00,0.00,661196),('5','90','231142','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661197),('5','90','231152','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661221),('5','90','231152','271',310.00,310.00,601.16,0.00,0.00,0.00,0.00,661222),('5','90','231152','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661223),('5','90','231156','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661231),('5','90','231156','271',310.00,310.00,311.39,0.00,0.00,0.00,0.00,661232),('5','90','231156','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661233),('5','90','231158','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661235),('5','90','231158','271',310.00,310.00,142.40,0.00,0.00,0.00,0.00,661236),('5','90','231158','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661237),('5','90','231161','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661244),('5','90','231161','271',310.00,310.00,96.34,0.00,0.00,0.00,0.00,661245),('5','90','231161','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661246),('5','90','231163','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,661250),('5','90','231163','271',310.00,320.00,145.66,0.00,0.00,0.00,0.00,661251),('5','90','231163','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661252),('5','90','231165','270',163.00,163.00,2324.45,0.00,0.00,0.00,0.00,661256),('5','90','231165','271',310.00,320.00,480.11,0.00,0.00,0.00,0.00,661257),('5','90','231165','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661258),('5','90','231243','270',163.00,163.00,2986.60,0.00,0.00,0.00,0.00,661478),('5','90','231243','271',310.00,320.00,251.78,0.00,0.00,0.00,0.00,661479),('5','90','231243','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661480),('5','90','231422','270',163.00,163.00,8138.77,0.00,0.00,0.00,0.00,661942),('5','90','231422','271',310.00,320.00,228.33,0.00,0.00,0.00,0.00,661943),('5','90','231422','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,661944),('5','90','231640','270',163.00,163.00,2080.26,0.00,0.00,0.00,0.00,662517),('5','90','231640','271',310.00,320.00,73.91,0.00,0.00,0.00,0.00,662518),('5','90','231640','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,662519),('5','90','232075','270',163.00,163.00,2151.35,0.00,0.00,0.00,0.00,663701),('5','90','232075','271',310.00,327.00,189.07,0.00,0.00,0.00,0.00,663702),('5','90','232075','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,663703),('5','90','232314','270',163.00,163.00,2375.33,0.00,0.00,0.00,0.00,664318),('5','90','232314','271',327.00,327.00,231.25,0.00,0.00,0.00,0.00,664319),('5','90','232314','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664320),('5','90','232368','270',163.00,163.00,2110.47,0.00,0.00,0.00,0.00,664439),('5','90','232368','271',327.00,327.00,202.88,0.00,0.00,0.00,0.00,664440),('5','90','232368','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,664441),('5','90','232823','270',163.00,163.00,1442.12,0.00,0.00,0.00,0.00,665672),('5','90','232823','271',327.00,327.00,64.23,0.00,0.00,0.00,0.00,665673),('5','90','232823','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665674),('5','90','232858','270',163.00,163.00,1775.39,0.00,0.00,0.00,0.00,665744),('5','90','232858','271',327.00,330.00,237.89,0.00,0.00,0.00,0.00,665745),('5','90','232858','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,665746),('5','90','233307','270',163.00,163.00,764.97,0.00,0.00,0.00,0.00,666932),('5','90','233307','271',345.00,345.00,132.27,0.00,0.00,0.00,0.00,666933),('5','90','233307','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,666934),('5','90','233450','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,667292),('5','90','233450','271',345.00,345.00,128.24,0.00,0.00,0.00,0.00,667293),('5','90','233450','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667294),('5','90','233671','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,667865),('5','90','233671','271',345.00,345.00,86.16,0.00,0.00,0.00,0.00,667866),('5','90','233671','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,667867),('5','90','233851','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,668342),('5','90','233851','271',345.00,345.00,95.63,0.00,0.00,0.00,0.00,668343),('5','90','233851','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,668344),('5','90','234283','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,669502),('5','90','234283','271',345.00,345.00,81.31,0.00,0.00,0.00,0.00,669503),('5','90','234283','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669504),('5','90','234380','270',163.00,165.00,0.00,0.00,0.00,0.00,0.00,669744),('5','90','234380','271',345.00,345.00,89.83,0.00,0.00,0.00,0.00,669745),('5','90','234380','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,669746),('5','90','234695','270',163.00,163.00,0.00,0.00,0.00,0.00,0.00,670579),('5','90','234695','271',345.00,345.00,176.66,0.00,0.00,0.00,0.00,670580),('5','90','234695','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,670581),('5','90','234875','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,671048),('5','90','234875','271',345.00,345.00,65.12,0.00,0.00,0.00,0.00,671049),('5','90','234875','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,671050),('5','90','236546','270',165.00,165.00,9590.13,0.00,0.00,0.00,0.00,675436),('5','90','236546','271',345.00,345.00,450.47,0.00,0.00,0.00,0.00,675437),('5','90','236546','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,675438),('5','90','236932','270',165.00,165.00,4706.30,0.00,0.00,0.00,0.00,676455),('5','90','236932','271',345.00,345.00,176.30,0.00,0.00,0.00,0.00,676456),('5','90','236932','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676457),('5','90','237057','270',165.00,165.00,4020.38,0.00,0.00,0.00,0.00,676759),('5','90','237057','271',345.00,345.00,111.66,0.00,0.00,0.00,0.00,676760),('5','90','237057','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,676761),('5','90','237186','270',165.00,165.00,4167.77,0.00,0.00,0.00,0.00,677082),('5','90','237186','271',345.00,345.00,142.08,0.00,0.00,0.00,0.00,677083),('5','90','237186','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677084),('5','90','237450','270',165.00,165.00,4561.62,0.00,0.00,0.00,0.00,677774),('5','90','237450','271',345.00,345.00,96.39,0.00,0.00,0.00,0.00,677775),('5','90','237450','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,677776),('5','90','237837','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678802),('5','90','237837','271',345.00,345.00,448.95,0.00,0.00,0.00,0.00,678803),('5','90','237837','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678804),('5','90','237901','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,678937),('5','90','237901','271',345.00,345.00,320.66,0.00,0.00,0.00,0.00,678938),('5','90','237901','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,678939),('5','90','238142','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,679568),('5','90','238142','271',345.00,345.00,127.86,0.00,0.00,0.00,0.00,679569),('5','90','238142','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,679570),('5','90','238432','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680315),('5','90','238432','271',345.00,345.00,260.01,0.00,0.00,0.00,0.00,680316),('5','90','238432','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680317),('5','90','238634','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,680846),('5','90','238634','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,680847),('5','90','238634','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,680848),('5','90','238935','270',165.00,165.00,2538.14,0.00,0.00,0.00,0.00,681625),('5','90','238935','271',345.00,345.00,304.28,0.00,0.00,0.00,0.00,681626),('5','90','238935','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681627),('5','90','239073','270',165.00,165.00,5200.56,0.00,0.00,0.00,0.00,681981),('5','90','239073','271',345.00,345.00,300.11,0.00,0.00,0.00,0.00,681982),('5','90','239073','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,681983),('5','90','239339','270',165.00,165.00,3163.86,0.00,0.00,0.00,0.00,682672),('5','90','239339','271',345.00,345.00,68.59,0.00,0.00,0.00,0.00,682673),('5','90','239339','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,682674),('5','90','239557','270',165.00,165.00,3547.93,0.00,0.00,0.00,0.00,683238),('5','90','239557','271',345.00,345.00,239.77,0.00,0.00,0.00,0.00,683239),('5','90','239557','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683240),('5','90','239809','270',165.00,165.00,8538.28,0.00,0.00,0.00,0.00,683901),('5','90','239809','271',345.00,345.00,527.28,0.00,0.00,0.00,0.00,683902),('5','90','239809','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,683903),('5','90','240080','270',165.00,165.00,3028.12,0.00,0.00,0.00,0.00,684603),('5','90','240080','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,684604),('5','90','240080','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,684605),('5','90','240268','270',165.00,165.00,3739.60,0.00,0.00,0.00,0.00,685086),('5','90','240268','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685087),('5','90','240268','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685088),('5','90','240486','270',165.00,165.00,4025.88,0.00,0.00,0.00,0.00,685655),('5','90','240486','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,685656),('5','90','240486','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,685657),('5','90','240704','270',165.00,165.00,3315.48,0.00,0.00,0.00,0.00,686180),('5','90','240704','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686181),('5','90','240704','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686182),('5','90','240998','270',165.00,165.00,1081.05,0.00,0.00,0.00,0.00,686963),('5','90','240998','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,686964),('5','90','240998','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,686965),('5','90','241230','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,687576),('5','90','241230','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,687577),('5','90','241230','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,687578),('5','90','241569','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,688477),('5','90','241569','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,688478),('5','90','241569','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,688479),('5','90','241807','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,689101),('5','90','241807','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,689102),('5','90','241807','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,689103),('5','90','242152','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690010),('5','90','242152','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690011),('5','90','242152','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690012),('5','90','242389','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690625),('5','90','242389','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690626),('5','90','242389','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690627),('5','90','242519','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,690941),('5','90','242519','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,690942),('5','90','242519','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,690943),('5','90','242781','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,691629),('5','90','242781','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,691630),('5','90','242781','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,691631),('5','90','242986','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692159),('5','90','242986','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692160),('5','90','242986','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692161),('5','90','243277','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,692936),('5','90','243277','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,692937),('5','90','243277','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,692938),('5','90','243454','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,693387),('5','90','243454','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,693388),('5','90','243454','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,693389),('5','90','243791','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694277),('5','90','243791','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694278),('5','90','243791','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694279),('5','90','243977','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,694750),('5','90','243977','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,694751),('5','90','243977','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,694752),('5','90','244155','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695191),('5','90','244155','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695192),('5','90','244155','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695193),('5','90','244440','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,695951),('5','90','244440','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,695952),('5','90','244440','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,695953),('5','90','244706','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,696651),('5','90','244706','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,696652),('5','90','244706','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,696653),('5','90','244881','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697106),('5','90','244881','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697107),('5','90','244881','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697108),('5','90','245089','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,697626),('5','90','245089','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,697627),('5','90','245089','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,697628),('5','90','245621','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699015),('5','90','245621','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699016),('5','90','245621','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699017),('5','90','245901','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699745),('5','90','245901','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699746),('5','90','245901','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699747),('5','90','245970','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,699913),('5','90','245970','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,699914),('5','90','245970','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,699915),('5','90','246635','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701668),('5','90','246635','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701669),('5','90','246635','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701670),('5','90','246724','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,701879),('5','90','246724','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,701880),('5','90','246724','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,701881),('5','90','247048','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,702708),('5','90','247048','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,702709),('5','90','247048','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,702710),('5','90','247245','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,703221),('5','90','247245','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,703222),('5','90','247245','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,703223),('5','90','247599','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704150),('5','90','247599','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704151),('5','90','247599','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704152),('5','90','247849','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,704787),('5','90','247849','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,704788),('5','90','247849','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,704789),('5','90','248117','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,705495),('5','90','248117','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,705496),('5','90','248117','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,705497),('5','90','248520','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706511),('5','90','248520','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706512),('5','90','248520','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706513),('5','90','248613','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,706767),('5','90','248613','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,706768),('5','90','248613','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,706769),('5','90','248818','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707293),('5','90','248818','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707294),('5','90','248818','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707295),('5','90','248934','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,707574),('5','90','248934','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,707575),('5','90','248934','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,707576),('5','90','249198','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708248),('5','90','249198','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708249),('5','90','249198','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708250),('5','90','249399','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,708749),('5','90','249399','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,708750),('5','90','249399','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,708751),('5','90','249714','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,709581),('5','90','249714','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,709582),('5','90','249714','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,709583),('5','90','249959','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,710206),('5','90','249959','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710207),('5','90','249959','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710208),('5','90','250180','270',165.00,165.00,2815.55,0.00,0.00,0.00,0.00,710762),('5','90','250180','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,710763),('5','90','250180','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,710764),('5','90','250412','270',165.00,165.00,3628.47,0.00,0.00,0.00,0.00,711345),('5','90','250412','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711346),('5','90','250412','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711347),('5','90','250600','270',165.00,165.00,4551.76,0.00,0.00,0.00,0.00,711826),('5','90','250600','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,711827),('5','90','250600','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,711828),('5','90','250993','270',165.00,165.00,10308.30,0.00,0.00,0.00,0.00,712873),('5','90','250993','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,712874),('5','90','250993','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,712875),('5','90','251061','270',165.00,165.00,8567.41,0.00,0.00,0.00,0.00,713023),('5','90','251061','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713024),('5','90','251061','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713025),('5','90','251365','270',165.00,165.00,9531.68,0.00,0.00,0.00,0.00,713824),('5','90','251365','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,713825),('5','90','251365','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,713826),('5','90','251587','270',165.00,165.00,9252.56,0.00,0.00,0.00,0.00,714399),('5','90','251587','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,714400),('5','90','251587','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,714401),('5','90','251915','270',165.00,165.00,3938.65,0.00,0.00,0.00,0.00,715270),('5','90','251915','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715271),('5','90','251915','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715272),('5','90','252157','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,715897),('5','90','252157','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,715898),('5','90','252157','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,715899),('5','90','252372','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716466),('5','90','252372','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716467),('5','90','252372','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716468),('5','90','252525','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,716836),('5','90','252525','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,716837),('5','90','252525','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,716838),('5','90','252752','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,717429),('5','90','252752','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,717430),('5','90','252752','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,717431),('5','90','253067','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718252),('5','90','253067','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718253),('5','90','253067','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718254),('5','90','253249','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,718731),('5','90','253249','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,718732),('5','90','253249','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,718733),('5','90','253542','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,719486),('5','90','253542','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,719487),('5','90','253542','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,719488),('5','90','253836','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,720259),('5','90','253836','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,720260),('5','90','253836','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,720261),('5','90','254138','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721062),('5','90','254138','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721063),('5','90','254138','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721064),('5','90','254237','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,721289),('5','90','254237','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,721290),('5','90','254237','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,721291),('5','90','254669','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722426),('5','90','254669','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722427),('5','90','254669','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722428),('5','90','254843','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,722847),('5','90','254843','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,722848),('5','90','254843','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,722849),('5','90','255049','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723369),('5','90','255049','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723370),('5','90','255049','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723371),('5','90','255272','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,723940),('5','90','255272','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,723941),('5','90','255272','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,723942),('5','90','255604','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,724751),('5','90','255604','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,724752),('5','90','255604','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,724753),('5','90','255921','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,725583),('5','90','255921','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,725584),('5','90','255921','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,725585),('5','90','256142','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,726135),('5','90','256142','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,726136),('5','90','256142','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,726137),('5','90','256586','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,727252),('5','90','256586','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,727253),('5','90','256586','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,727254),('5','90','256915','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728127),('5','90','256915','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728128),('5','90','256915','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728129),('5','90','257080','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,728538),('5','90','257080','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,728539),('5','90','257080','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,728540),('5','90','257470','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729582),('5','90','257470','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729583),('5','90','257470','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729584),('5','90','257523','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729694),('5','90','257523','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729695),('5','90','257523','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729696),('5','90','257524','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729697),('5','90','257524','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729698),('5','90','257524','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729699),('5','90','257525','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729700),('5','90','257525','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729701),('5','90','257525','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729702),('5','90','257526','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729703),('5','90','257526','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729704),('5','90','257526','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729705),('5','90','257527','270',165.00,165.00,6628.17,0.00,0.00,0.00,0.00,729706),('5','90','257527','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729707),('5','90','257527','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729708),('5','90','257528','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729709),('5','90','257528','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729710),('5','90','257528','270',165.00,165.00,3601.32,0.00,0.00,0.00,0.00,729711),('5','90','257529','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729712),('5','90','257529','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729713),('5','90','257529','270',165.00,165.00,5300.94,0.00,0.00,0.00,0.00,729714),('5','90','257530','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729715),('5','90','257530','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729716),('5','90','257530','270',165.00,165.00,4941.79,0.00,0.00,0.00,0.00,729717),('5','90','257531','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729718),('5','90','257531','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729719),('5','90','257531','270',165.00,165.00,5376.48,0.00,0.00,0.00,0.00,729720),('5','90','257532','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729721),('5','90','257532','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729722),('5','90','257532','270',165.00,165.00,3042.20,0.00,0.00,0.00,0.00,729723),('5','90','257533','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729724),('5','90','257533','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729725),('5','90','257533','270',165.00,165.00,1071.44,0.00,0.00,0.00,0.00,729726),('5','90','257534','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729727),('5','90','257534','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729728),('5','90','257534','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729729),('5','90','257535','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729730),('5','90','257535','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729731),('5','90','257535','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729732),('5','90','257536','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729733),('5','90','257536','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729734),('5','90','257536','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729735),('5','90','257537','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729736),('5','90','257537','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729737),('5','90','257537','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729738),('5','90','257538','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729739),('5','90','257538','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729740),('5','90','257538','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729741),('5','90','257539','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729742),('5','90','257539','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729743),('5','90','257539','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729744),('5','90','257540','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729745),('5','90','257540','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729746),('5','90','257540','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729747),('5','90','257541','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729748),('5','90','257541','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729749),('5','90','257541','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729750),('5','90','257542','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729751),('5','90','257542','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729752),('5','90','257542','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729753),('5','90','257543','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729754),('5','90','257543','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729755),('5','90','257543','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729756),('5','90','257544','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729757),('5','90','257544','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729758),('5','90','257544','270',165.00,165.00,5160.57,0.00,0.00,0.00,0.00,729759),('5','90','257545','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729760),('5','90','257545','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729761),('5','90','257545','270',165.00,165.00,7528.57,0.00,0.00,0.00,0.00,729762),('5','90','257546','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729763),('5','90','257546','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729764),('5','90','257546','270',165.00,165.00,278.13,0.00,0.00,0.00,0.00,729765),('5','90','257547','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729766),('5','90','257547','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729767),('5','90','257547','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729768),('5','90','257548','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729769),('5','90','257548','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729770),('5','90','257548','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729771),('5','90','257549','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729772),('5','90','257549','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729773),('5','90','257549','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729774),('5','90','257550','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729775),('5','90','257550','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729776),('5','90','257550','270',165.00,165.00,899.98,0.00,0.00,0.00,0.00,729777),('5','90','257551','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729778),('5','90','257551','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729779),('5','90','257551','270',165.00,165.00,13567.34,0.00,0.00,0.00,0.00,729780),('5','90','257552','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729781),('5','90','257552','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729782),('5','90','257552','270',165.00,165.00,10921.45,0.00,0.00,0.00,0.00,729783),('5','90','257553','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729784),('5','90','257553','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729785),('5','90','257553','270',165.00,165.00,5443.65,0.00,0.00,0.00,0.00,729786),('5','90','257554','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729787),('5','90','257554','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729788),('5','90','257554','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729789),('5','90','257555','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729790),('5','90','257555','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729791),('5','90','257555','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729792),('5','90','257556','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729793),('5','90','257556','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729794),('5','90','257556','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729795),('5','90','257557','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729796),('5','90','257557','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729797),('5','90','257557','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729798),('5','90','257558','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729799),('5','90','257558','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729800),('5','90','257558','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729801),('5','90','257559','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729802),('5','90','257559','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729803),('5','90','257559','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729804),('5','90','257560','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729805),('5','90','257560','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729806),('5','90','257560','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729807),('5','90','257561','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729808),('5','90','257561','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729809),('5','90','257561','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729810),('5','90','257562','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729811),('5','90','257562','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729812),('5','90','257562','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729813),('5','90','257563','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729814),('5','90','257563','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729815),('5','90','257563','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729816),('5','90','257564','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729817),('5','90','257564','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729818),('5','90','257564','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729819),('5','90','257565','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729820),('5','90','257565','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729821),('5','90','257565','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729822),('5','90','257566','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729823),('5','90','257566','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729824),('5','90','257566','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729825),('5','90','257567','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729826),('5','90','257567','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729827),('5','90','257567','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729828),('5','90','257568','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729829),('5','90','257568','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729830),('5','90','257568','270',165.00,165.00,400.00,0.00,0.00,0.00,0.00,729831),('5','90','257569','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729832),('5','90','257569','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729833),('5','90','257569','270',165.00,165.00,8128.81,0.00,0.00,0.00,0.00,729834),('5','90','257570','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729835),('5','90','257570','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729836),('5','90','257570','270',165.00,165.00,4367.10,0.00,0.00,0.00,0.00,729837),('5','90','257571','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729838),('5','90','257571','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729839),('5','90','257571','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729840),('5','90','257572','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729841),('5','90','257572','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729842),('5','90','257572','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729843),('5','90','257573','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729844),('5','90','257573','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729845),('5','90','257573','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729846),('5','90','257574','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729847),('5','90','257574','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729848),('5','90','257574','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729849),('5','90','257575','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729850),('5','90','257575','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729851),('5','90','257575','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729852),('5','90','257576','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729853),('5','90','257576','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729854),('5','90','257576','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729855),('5','90','257577','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729856),('5','90','257577','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729857),('5','90','257577','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729858),('5','90','257578','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729859),('5','90','257578','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729860),('5','90','257578','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729861),('5','90','257579','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729862),('5','90','257579','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729863),('5','90','257579','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729864),('5','90','257580','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729865),('5','90','257580','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729866),('5','90','257580','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729867),('5','90','257581','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729868),('5','90','257581','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729869),('5','90','257581','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729870),('5','90','257582','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729871),('5','90','257582','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729872),('5','90','257582','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729873),('5','90','257583','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729874),('5','90','257583','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729875),('5','90','257583','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729876),('5','90','257584','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729877),('5','90','257584','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729878),('5','90','257584','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729879),('5','90','257585','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729880),('5','90','257585','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729881),('5','90','257585','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729882),('5','90','257586','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729883),('5','90','257586','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729884),('5','90','257586','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729885),('5','90','257587','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729886),('5','90','257587','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729887),('5','90','257587','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729888),('5','90','257588','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729889),('5','90','257588','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729890),('5','90','257588','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729891),('5','90','257589','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729892),('5','90','257589','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729893),('5','90','257589','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729894),('5','90','257590','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729895),('5','90','257590','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729896),('5','90','257590','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729897),('5','90','257591','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729898),('5','90','257591','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729899),('5','90','257591','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729900),('5','90','257592','270',165.00,165.00,3144.74,0.00,0.00,0.00,0.00,729901),('5','90','257592','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729902),('5','90','257592','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729903),('5','90','257593','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729904),('5','90','257593','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729905),('5','90','257593','270',165.00,165.00,5968.02,0.00,0.00,0.00,0.00,729906),('5','90','257594','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729907),('5','90','257594','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729908),('5','90','257594','270',165.00,165.00,3172.08,0.00,0.00,0.00,0.00,729909),('5','90','257595','270',165.00,165.00,2730.44,0.00,0.00,0.00,0.00,729910),('5','90','257595','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729911),('5','90','257595','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729912),('5','90','257596','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729913),('5','90','257596','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729914),('5','90','257596','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729915),('5','90','257597','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729916),('5','90','257597','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729917),('5','90','257597','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729918),('5','90','257598','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729919),('5','90','257598','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729920),('5','90','257598','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729921),('5','90','257599','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729922),('5','90','257599','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729923),('5','90','257599','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729924),('5','90','257600','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729925),('5','90','257600','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729926),('5','90','257600','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729927),('5','90','257601','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729928),('5','90','257601','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729929),('5','90','257601','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729930),('5','90','257602','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729931),('5','90','257602','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729932),('5','90','257602','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729933),('5','90','257603','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729934),('5','90','257603','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729935),('5','90','257603','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729936),('5','90','257604','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729937),('5','90','257604','272',0.00,0.00,40567.00,0.00,0.00,0.00,0.00,729938),('5','90','257604','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729939),('5','90','257605','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729940),('5','90','257605','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729941),('5','90','257605','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729942),('5','90','257606','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729943),('5','90','257606','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729944),('5','90','257606','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729945),('5','90','257607','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729946),('5','90','257607','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729947),('5','90','257607','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729948),('5','90','257608','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729949),('5','90','257608','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729950),('5','90','257608','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729951),('5','90','257609','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729952),('5','90','257609','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729953),('5','90','257609','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729954),('5','90','257610','270',165.00,165.00,1623.64,0.00,0.00,0.00,0.00,729955),('5','90','257610','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729956),('5','90','257610','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729957),('5','90','257611','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729958),('5','90','257611','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729959),('5','90','257611','270',165.00,165.00,5885.71,0.00,0.00,0.00,0.00,729960),('5','90','257612','270',165.00,165.00,5366.77,0.00,0.00,0.00,0.00,729961),('5','90','257612','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729962),('5','90','257612','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729963),('5','90','257613','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729964),('5','90','257613','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729965),('5','90','257613','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729966),('5','90','257614','270',165.00,165.00,1989.99,0.00,0.00,0.00,0.00,729967),('5','90','257614','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729968),('5','90','257614','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729969),('5','90','257615','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729970),('5','90','257615','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729971),('5','90','257615','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729972),('5','90','257616','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729973),('5','90','257616','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729974),('5','90','257616','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729975),('5','90','257617','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729976),('5','90','257617','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729977),('5','90','257617','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729978),('5','90','257618','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729979),('5','90','257618','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729980),('5','90','257618','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729981),('5','90','257619','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729982),('5','90','257619','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729983),('5','90','257619','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,729984),('5','90','257620','270',165.00,165.00,5924.55,0.00,0.00,0.00,0.00,729985),('5','90','257620','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729986),('5','90','257620','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729987),('5','90','257621','270',165.00,165.00,5343.25,0.00,0.00,0.00,0.00,729988),('5','90','257621','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729989),('5','90','257621','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729990),('5','90','257622','270',165.00,165.00,5872.39,0.00,0.00,0.00,0.00,729991),('5','90','257622','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729992),('5','90','257622','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729993),('5','90','257623','270',165.00,165.00,4578.78,0.00,0.00,0.00,0.00,729994),('5','90','257623','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729995),('5','90','257623','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729996),('5','90','257624','270',165.00,165.00,3730.49,0.00,0.00,0.00,0.00,729997),('5','90','257624','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,729998),('5','90','257624','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,729999),('5','90','257625','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730000),('5','90','257625','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730001),('5','90','257625','270',165.00,165.00,3438.20,0.00,0.00,0.00,0.00,730002),('5','90','257626','270',165.00,165.00,959.64,0.00,0.00,0.00,0.00,730003),('5','90','257626','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730004),('5','90','257626','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730005),('5','90','257627','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730006),('5','90','257627','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730007),('5','90','257627','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730008),('5','90','257628','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730009),('5','90','257628','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730010),('5','90','257628','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730011),('5','90','257629','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730012),('5','90','257629','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730013),('5','90','257629','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730014),('5','90','257630','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730015),('5','90','257630','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730016),('5','90','257630','270',165.00,165.00,1530.00,0.00,0.00,0.00,0.00,730017),('5','90','257631','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730018),('5','90','257631','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730019),('5','90','257631','270',165.00,165.00,4114.21,0.00,0.00,0.00,0.00,730020),('5','90','257632','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730021),('5','90','257632','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730022),('5','90','257632','270',165.00,165.00,5866.50,0.00,0.00,0.00,0.00,730023),('5','90','257633','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730024),('5','90','257633','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730025),('5','90','257633','270',165.00,165.00,3288.69,0.00,0.00,0.00,0.00,730026),('5','90','257634','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730027),('5','90','257634','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730028),('5','90','257634','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730029),('5','90','257635','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730030),('5','90','257635','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730031),('5','90','257635','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730032),('5','90','257636','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730033),('5','90','257636','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730034),('5','90','257636','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730035),('5','90','257637','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730036),('5','90','257637','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730037),('5','90','257637','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730038),('5','90','257638','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730039),('5','90','257638','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730040),('5','90','257638','270',165.00,165.00,4543.79,0.00,0.00,0.00,0.00,730041),('5','90','257639','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730042),('5','90','257639','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730043),('5','90','257639','270',165.00,165.00,4448.68,0.00,0.00,0.00,0.00,730044),('5','90','257640','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730045),('5','90','257640','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730046),('5','90','257640','270',165.00,165.00,3809.86,0.00,0.00,0.00,0.00,730047),('5','90','257641','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730048),('5','90','257641','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730049),('5','90','257641','270',165.00,165.00,2312.02,0.00,0.00,0.00,0.00,730050),('5','90','257642','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730051),('5','90','257642','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730052),('5','90','257642','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730053),('5','90','257643','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730054),('5','90','257643','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730055),('5','90','257643','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730056),('5','90','257644','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730057),('5','90','257644','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730058),('5','90','257644','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730059),('5','90','257645','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730060),('5','90','257645','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730061),('5','90','257645','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730062),('5','90','257646','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730063),('5','90','257646','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730064),('5','90','257646','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730065),('5','90','257647','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730066),('5','90','257647','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730067),('5','90','257647','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730068),('5','90','257648','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730069),('5','90','257648','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730070),('5','90','257648','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730071),('5','90','257649','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730072),('5','90','257649','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730073),('5','90','257649','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730074),('5','90','257650','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730075),('5','90','257650','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730076),('5','90','257650','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730077),('5','90','257651','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730078),('5','90','257651','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730079),('5','90','257651','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730080),('5','90','257652','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730081),('5','90','257652','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730082),('5','90','257652','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730083),('5','90','257653','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730084),('5','90','257653','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730085),('5','90','257653','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730086),('5','90','257654','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730087),('5','90','257654','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730088),('5','90','257654','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730089),('5','90','257655','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730090),('5','90','257655','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730091),('5','90','257655','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730092),('5','90','257656','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730093),('5','90','257656','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730094),('5','90','257656','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730095),('5','90','257657','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730096),('5','90','257657','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730097),('5','90','257657','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730098),('5','90','257658','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730099),('5','90','257658','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730100),('5','90','257658','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730101),('5','90','257659','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730102),('5','90','257659','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730103),('5','90','257659','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730104),('5','90','257660','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730105),('5','90','257660','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730106),('5','90','257660','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730107),('5','90','257661','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730108),('5','90','257661','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730109),('5','90','257661','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730110),('5','90','257662','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730111),('5','90','257662','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730112),('5','90','257662','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730113),('5','90','257663','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730114),('5','90','257663','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730115),('5','90','257663','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730116),('5','90','257664','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730117),('5','90','257664','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730118),('5','90','257664','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730119),('5','90','257665','270',165.00,165.00,5074.79,0.00,0.00,0.00,0.00,730120),('5','90','257665','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730121),('5','90','257665','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730122),('5','90','257666','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730123),('5','90','257666','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730124),('5','90','257666','270',165.00,165.00,5684.29,0.00,0.00,0.00,0.00,730125),('5','90','257667','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730126),('5','90','257667','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730127),('5','90','257667','270',165.00,165.00,3939.48,0.00,0.00,0.00,0.00,730128),('5','90','257668','270',165.00,165.00,4096.42,0.00,0.00,0.00,0.00,730129),('5','90','257668','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730130),('5','90','257668','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730131),('5','90','257669','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730132),('5','90','257669','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730133),('5','90','257669','270',165.00,165.00,7152.41,0.00,0.00,0.00,0.00,730134),('5','90','257670','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730135),('5','90','257670','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730136),('5','90','257670','270',165.00,165.00,2146.63,0.00,0.00,0.00,0.00,730137),('5','90','257671','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730138),('5','90','257671','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730139),('5','90','257671','270',165.00,165.00,1099.14,0.00,0.00,0.00,0.00,730140),('5','90','257672','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730141),('5','90','257672','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730142),('5','90','257672','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730143),('5','90','257673','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730144),('5','90','257673','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730145),('5','90','257673','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730146),('5','90','257674','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730147),('5','90','257674','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730148),('5','90','257674','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730149),('5','90','257675','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730150),('5','90','257675','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730151),('5','90','257675','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730152),('5','90','257676','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730153),('5','90','257676','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730154),('5','90','257676','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730155),('5','90','257677','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730156),('5','90','257677','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730157),('5','90','257677','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730158),('5','90','257678','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730159),('5','90','257678','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730160),('5','90','257678','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730161),('5','90','257679','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730162),('5','90','257679','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730163),('5','90','257679','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730164),('5','90','257680','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730165),('5','90','257680','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730166),('5','90','257680','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730167),('5','90','257681','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730168),('5','90','257681','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730169),('5','90','257681','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730170),('5','90','257682','270',165.00,165.00,0.00,0.00,0.00,0.00,0.00,730171),('5','90','257682','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730172),('5','90','257682','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730173),('5','90','257683','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730174),('5','90','257683','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730175),('5','90','257683','270',165.00,165.00,2335.45,0.00,0.00,0.00,0.00,730176),('5','90','257684','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730177),('5','90','257684','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730178),('5','90','257684','270',165.00,165.00,3224.39,0.00,0.00,0.00,0.00,730179),('5','90','257685','270',165.00,165.00,4235.21,0.00,0.00,0.00,0.00,730180),('5','90','257685','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730181),('5','90','257685','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730182),('5','90','257686','270',165.00,185.00,3232.07,0.00,0.00,0.00,0.00,730183),('5','90','257686','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730184),('5','90','257686','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730185),('5','90','257687','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730186),('5','90','257687','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730187),('5','90','257687','270',165.00,185.00,1454.96,0.00,0.00,0.00,0.00,730188),('5','90','257688','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730189),('5','90','257688','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730190),('5','90','257688','270',165.00,185.00,0.00,0.00,0.00,0.00,0.00,730191),('5','90','257689','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730192),('5','90','257689','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730193),('5','90','257689','270',165.00,185.00,0.00,0.00,0.00,0.00,0.00,730194),('5','90','257690','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730195),('5','90','257690','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730196),('5','90','257690','270',165.00,185.00,0.00,0.00,0.00,0.00,0.00,730197),('5','90','257691','270',165.00,185.00,0.00,0.00,0.00,0.00,0.00,730198),('5','90','257691','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730199),('5','90','257691','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730200),('5','90','257692','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730201),('5','90','257692','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730202),('5','90','257692','270',165.00,185.00,5036.89,0.00,0.00,0.00,0.00,730203),('5','90','257693','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730204),('5','90','257693','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730205),('5','90','257693','270',185.00,185.00,5547.47,0.00,0.00,0.00,0.00,730206),('5','90','257694','270',185.00,185.00,6143.32,0.00,0.00,0.00,0.00,730207),('5','90','257694','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730208),('5','90','257694','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730209),('5','90','257695','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730210),('5','90','257695','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730211),('5','90','257695','270',185.00,185.00,4816.54,0.00,0.00,0.00,0.00,730212),('5','90','257696','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730213),('5','90','257696','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730214),('5','90','257696','270',185.00,185.00,10270.65,0.00,0.00,0.00,0.00,730215),('5','90','257697','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730216),('5','90','257697','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730217),('5','90','257697','270',185.00,185.00,3473.41,0.00,0.00,0.00,0.00,730218),('5','90','257698','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730219),('5','90','257698','272',0.00,820.00,0.00,0.00,0.00,0.00,0.00,730220),('5','90','257698','270',185.00,185.00,7227.68,0.00,0.00,0.00,0.00,730221),('5','90','257699','270',185.00,185.00,4935.47,0.00,0.00,0.00,0.00,730222),('5','90','257699','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730223),('5','90','257699','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730224),('5','90','257700','270',185.00,185.00,4085.10,0.00,0.00,0.00,0.00,730225),('5','90','257700','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730226),('5','90','257700','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730227),('5','90','257701','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730228),('5','90','257701','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730229),('5','90','257701','270',185.00,185.00,5241.58,0.00,0.00,0.00,0.00,730230),('5','90','257702','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730231),('5','90','257702','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730232),('5','90','257702','270',185.00,185.00,4256.02,0.00,0.00,0.00,0.00,730233),('5','90','257703','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730234),('5','90','257703','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730235),('5','90','257703','270',185.00,185.00,756.83,0.00,0.00,0.00,0.00,730236),('5','90','257704','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730237),('5','90','257704','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730238),('5','90','257704','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730239),('5','90','257705','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730240),('5','90','257705','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730241),('5','90','257705','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730242),('5','90','257706','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730243),('5','90','257706','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730244),('5','90','257706','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730245),('5','90','257707','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730246),('5','90','257707','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730247),('5','90','257707','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730248),('5','90','257708','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730249),('5','90','257708','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730250),('5','90','257708','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730251),('5','90','257709','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730252),('5','90','257709','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730253),('5','90','257709','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730254),('5','90','257710','271',345.00,820.00,0.00,0.00,0.00,0.00,0.00,730255),('5','90','257710','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730256),('5','90','257710','270',185.00,185.00,3241.11,0.00,0.00,0.00,0.00,730257),('5','90','257711','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730258),('5','90','257711','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730259),('5','90','257711','270',185.00,185.00,3020.67,0.00,0.00,0.00,0.00,730260),('5','90','257712','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730261),('5','90','257712','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730262),('5','90','257712','270',185.00,185.00,3970.81,0.00,0.00,0.00,0.00,730263),('5','90','257713','270',185.00,185.00,2950.75,0.00,0.00,0.00,0.00,730264),('5','90','257713','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730265),('5','90','257713','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730266),('5','90','257714','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730267),('5','90','257714','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730268),('5','90','257714','270',185.00,185.00,1783.42,0.00,0.00,0.00,0.00,730269),('5','90','257715','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730270),('5','90','257715','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730271),('5','90','257715','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730272),('5','90','257716','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730273),('5','90','257716','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730274),('5','90','257716','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730275),('5','90','257717','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730276),('5','90','257717','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730277),('5','90','257717','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730278),('5','90','257718','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730279),('5','90','257718','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730280),('5','90','257718','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730281),('5','90','257719','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730282),('5','90','257719','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730283),('5','90','257719','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730284),('5','90','257720','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730285),('5','90','257720','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730286),('5','90','257720','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730287),('5','90','257721','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730288),('5','90','257721','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730289),('5','90','257721','270',185.00,185.00,4167.07,0.00,0.00,0.00,0.00,730290),('5','90','257722','270',185.00,185.00,4084.78,0.00,0.00,0.00,0.00,730291),('5','90','257722','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730292),('5','90','257722','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730293),('5','90','257723','270',185.00,185.00,2447.51,0.00,0.00,0.00,0.00,730294),('5','90','257723','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730295),('5','90','257723','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730296),('5','90','257724','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730297),('5','90','257724','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730298),('5','90','257724','270',185.00,185.00,2118.51,0.00,0.00,0.00,0.00,730299),('5','90','257725','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730300),('5','90','257725','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730301),('5','90','257725','270',185.00,185.00,2187.75,0.00,0.00,0.00,0.00,730302),('5','90','257726','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730303),('5','90','257726','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730304),('5','90','257726','270',185.00,185.00,1635.66,0.00,0.00,0.00,0.00,730305),('5','90','257727','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730306),('5','90','257727','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730307),('5','90','257727','270',185.00,185.00,2404.87,0.00,0.00,0.00,0.00,730308),('5','90','257728','270',185.00,185.00,6237.83,0.00,0.00,0.00,0.00,730309),('5','90','257728','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730310),('5','90','257728','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730311),('5','90','257729','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730312),('5','90','257729','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730313),('5','90','257729','270',185.00,185.00,2874.21,0.00,0.00,0.00,0.00,730314),('5','90','257730','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730315),('5','90','257730','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730316),('5','90','257730','270',185.00,185.00,3244.47,0.00,0.00,0.00,0.00,730317),('5','90','257731','270',185.00,185.00,3063.80,0.00,0.00,0.00,0.00,730318),('5','90','257731','271',345.00,850.00,0.00,0.00,0.00,0.00,0.00,730319),('5','90','257731','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730320),('5','90','257732','270',185.00,185.00,4355.51,0.00,0.00,0.00,0.00,730321),('5','90','257732','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730322),('5','90','257732','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730323),('5','90','257733','270',185.00,185.00,4398.88,0.00,0.00,0.00,0.00,730324),('5','90','257733','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730325),('5','90','257733','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730326),('5','90','257734','270',185.00,185.00,4872.12,0.00,0.00,0.00,0.00,730327),('5','90','257734','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730328),('5','90','257734','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730329),('5','90','257735','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730330),('5','90','257735','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730331),('5','90','257735','270',185.00,185.00,6933.61,0.00,0.00,0.00,0.00,730332),('5','90','257736','270',185.00,185.00,3555.82,0.00,0.00,0.00,0.00,730333),('5','90','257736','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730334),('5','90','257736','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730335),('5','90','257737','270',185.00,185.00,4235.71,0.00,0.00,0.00,0.00,730336),('5','90','257737','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730337),('5','90','257737','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730338),('5','90','257738','270',185.00,185.00,2845.95,0.00,0.00,0.00,0.00,730339),('5','90','257738','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730340),('5','90','257738','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730341),('5','90','257739','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730342),('5','90','257739','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730343),('5','90','257739','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730344),('5','90','257740','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730345),('5','90','257740','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730346),('5','90','257740','270',185.00,185.00,2358.04,0.00,0.00,0.00,0.00,730347),('5','90','257741','270',185.00,185.00,3639.06,0.00,0.00,0.00,0.00,730348),('5','90','257741','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730349),('5','90','257741','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730350),('5','90','257742','270',185.00,185.00,6207.14,0.00,0.00,0.00,0.00,730351),('5','90','257742','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730352),('5','90','257742','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730353),('5','90','257743','270',185.00,185.00,3574.90,0.00,0.00,0.00,0.00,730354),('5','90','257743','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730355),('5','90','257743','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730356),('5','90','257744','270',185.00,185.00,3145.87,0.00,0.00,0.00,0.00,730357),('5','90','257744','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730358),('5','90','257744','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730359),('5','90','257745','270',185.00,185.00,3438.32,0.00,0.00,0.00,0.00,730360),('5','90','257745','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730361),('5','90','257745','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730362),('5','90','257746','270',185.00,185.00,3893.24,0.00,0.00,0.00,0.00,730363),('5','90','257746','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730364),('5','90','257746','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730365),('5','90','257747','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730366),('5','90','257747','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730367),('5','90','257747','270',185.00,185.00,3519.80,0.00,0.00,0.00,0.00,730368),('5','90','257748','270',185.00,185.00,3615.18,0.00,0.00,0.00,0.00,730369),('5','90','257748','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730370),('5','90','257748','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730371),('5','90','257749','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730372),('5','90','257749','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730373),('5','90','257749','270',185.00,185.00,8547.30,0.00,0.00,0.00,0.00,730374),('5','90','257750','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730375),('5','90','257750','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730376),('5','90','257750','270',185.00,185.00,3767.33,0.00,0.00,0.00,0.00,730377),('5','90','257754','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730384),('5','90','257754','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730385),('5','90','257754','270',185.00,185.00,3150.32,0.00,0.00,0.00,0.00,730386),('5','90','257755','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730387),('5','90','257755','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730388),('5','90','257755','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730389),('5','90','257756','270',185.00,185.00,4114.44,0.00,0.00,0.00,0.00,730390),('5','90','257756','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730391),('5','90','257756','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730392),('5','90','257757','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730393),('5','90','257757','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730394),('5','90','257757','270',185.00,185.00,4745.21,0.00,0.00,0.00,0.00,730395),('5','90','257758','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730396),('5','90','257758','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730397),('5','90','257758','270',185.00,185.00,4110.03,0.00,0.00,0.00,0.00,730398),('5','90','257759','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730399),('5','90','257759','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730400),('5','90','257759','270',185.00,185.00,5035.57,0.00,0.00,0.00,0.00,730401),('5','90','257760','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730402),('5','90','257760','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730403),('5','90','257760','270',185.00,185.00,8643.07,0.00,0.00,0.00,0.00,730404),('5','90','257761','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730405),('5','90','257761','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730406),('5','90','257761','270',185.00,185.00,4148.56,0.00,0.00,0.00,0.00,730407),('5','90','257762','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730408),('5','90','257762','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730409),('5','90','257762','270',185.00,185.00,3428.50,0.00,0.00,0.00,0.00,730410),('5','90','257763','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730411),('5','90','257763','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730412),('5','90','257763','270',185.00,185.00,3875.17,0.00,0.00,0.00,0.00,730413),('5','90','257764','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730414),('5','90','257764','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730415),('5','90','257764','270',185.00,185.00,4103.97,0.00,0.00,0.00,0.00,730416),('5','90','257765','270',185.00,185.00,4484.20,0.00,0.00,0.00,0.00,730417),('5','90','257765','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730418),('5','90','257765','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730419),('5','90','257766','270',185.00,185.00,4578.63,0.00,0.00,0.00,0.00,730420),('5','90','257766','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730421),('5','90','257766','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730422),('5','90','257767','270',185.00,185.00,9161.08,0.00,0.00,0.00,0.00,730423),('5','90','257767','271',345.00,800.00,0.00,0.00,0.00,0.00,0.00,730424),('5','90','257767','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730425),('5','90','257768','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730426),('5','90','257768','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730427),('5','90','257768','270',185.00,185.00,3759.41,0.00,0.00,0.00,0.00,730428),('5','90','257769','271',345.00,800.00,0.00,0.00,0.00,0.00,0.00,730429),('5','90','257769','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730430),('5','90','257769','270',185.00,185.00,3716.91,0.00,0.00,0.00,0.00,730431),('5','90','257770','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730432),('5','90','257770','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730433),('5','90','257770','270',185.00,185.00,4078.67,0.00,0.00,0.00,0.00,730434),('5','90','257771','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730435),('5','90','257771','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730436),('5','90','257771','270',185.00,185.00,4346.42,0.00,0.00,0.00,0.00,730437),('5','90','257772','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730438),('5','90','257772','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730439),('5','90','257772','270',185.00,185.00,4355.38,0.00,0.00,0.00,0.00,730440),('5','90','257773','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730441),('5','90','257773','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730442),('5','90','257773','270',185.00,185.00,4529.91,0.00,0.00,0.00,0.00,730443),('5','90','257774','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730444),('5','90','257774','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730445),('5','90','257774','270',185.00,185.00,9545.86,0.00,0.00,0.00,0.00,730446),('5','90','257775','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730447),('5','90','257775','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730448),('5','90','257775','270',185.00,185.00,4099.23,0.00,0.00,0.00,0.00,730449),('5','90','257776','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730450),('5','90','257776','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730451),('5','90','257776','270',185.00,185.00,4606.70,0.00,0.00,0.00,0.00,730452),('5','90','257779','271',345.00,800.00,0.00,0.00,0.00,0.00,0.00,730457),('5','90','257779','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730458),('5','90','257779','270',185.00,185.00,4376.75,0.00,0.00,0.00,0.00,730459),('5','90','257780','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730460),('5','90','257780','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730461),('5','90','257780','270',185.00,185.00,5914.84,0.00,0.00,0.00,0.00,730462),('5','90','257781','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730463),('5','90','257781','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730464),('5','90','257781','270',185.00,185.00,5802.45,0.00,0.00,0.00,0.00,730465),('5','90','257782','271',345.00,800.00,0.00,0.00,0.00,0.00,0.00,730466),('5','90','257782','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730467),('5','90','257782','270',185.00,185.00,5470.99,0.00,0.00,0.00,0.00,730468),('5','90','257783','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730469),('5','90','257783','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730470),('5','90','257783','270',185.00,185.00,11799.43,0.00,0.00,0.00,0.00,730471),('5','90','257784','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730472),('5','90','257784','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730473),('5','90','257784','270',185.00,185.00,4798.16,0.00,0.00,0.00,0.00,730474),('5','90','257785','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730475),('5','90','257785','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730476),('5','90','257785','270',185.00,185.00,7333.36,0.00,0.00,0.00,0.00,730477),('5','90','257786','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730478),('5','90','257786','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730479),('5','90','257786','270',185.00,185.00,6061.95,0.00,0.00,0.00,0.00,730480),('5','90','257787','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730481),('5','90','257787','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730482),('5','90','257787','270',185.00,185.00,5820.62,0.00,0.00,0.00,0.00,730483),('5','90','257788','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730484),('5','90','257788','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730485),('5','90','257788','270',185.00,185.00,8756.49,0.00,0.00,0.00,0.00,730486),('5','90','257789','270',185.00,185.00,6927.77,0.00,0.00,0.00,0.00,730487),('5','90','257789','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730488),('5','90','257789','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730489),('5','90','257790','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730490),('5','90','257790','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730491),('5','90','257790','270',185.00,185.00,4302.71,0.00,0.00,0.00,0.00,730492),('5','90','257791','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730493),('5','90','257791','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730494),('5','90','257791','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730495),('5','90','257792','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730496),('5','90','257792','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730497),('5','90','257792','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730498),('5','90','257793','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730499),('5','90','257793','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730500),('5','90','257793','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730501),('5','90','257794','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730502),('5','90','257794','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730503),('5','90','257794','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730504),('5','90','257795','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730505),('5','90','257795','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730506),('5','90','257795','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730507),('5','90','257796','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730508),('5','90','257796','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730509),('5','90','257796','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730510),('5','90','257797','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730511),('5','90','257797','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730512),('5','90','257797','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730513),('5','90','257798','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730514),('5','90','257798','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730515),('5','90','257798','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730516),('5','90','257801','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730521),('5','90','257801','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730522),('5','90','257801','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730523),('5','90','257802','271',345.00,800.00,0.00,0.00,0.00,0.00,0.00,730524),('5','90','257802','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730525),('5','90','257802','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730526),('5','90','257803','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730527),('5','90','257803','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730528),('5','90','257803','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730529),('5','90','257804','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730530),('5','90','257804','271',345.00,800.00,0.00,0.00,0.00,0.00,0.00,730531),('5','90','257804','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730532),('5','90','257805','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730533),('5','90','257805','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730534),('5','90','257805','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730535),('5','90','257806','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730536),('5','90','257806','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730537),('5','90','257806','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730538),('5','90','257807','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730539),('5','90','257807','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730540),('5','90','257807','270',185.00,185.00,2551.41,0.00,0.00,0.00,0.00,730541),('5','90','257808','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730542),('5','90','257808','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730543),('5','90','257808','270',185.00,185.00,14149.71,0.00,0.00,0.00,0.00,730544),('5','90','257809','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730545),('5','90','257809','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730546),('5','90','257809','270',185.00,185.00,10775.89,0.00,0.00,0.00,0.00,730547),('5','90','257810','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730548),('5','90','257810','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730549),('5','90','257810','270',185.00,185.00,10311.06,0.00,0.00,0.00,0.00,730550),('5','90','257811','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730551),('5','90','257811','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730552),('5','90','257811','270',185.00,185.00,23828.16,0.00,0.00,0.00,0.00,730553),('5','90','257812','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730554),('5','90','257812','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730555),('5','90','257812','270',185.00,185.00,10725.35,0.00,0.00,0.00,0.00,730556),('5','90','257813','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730557),('5','90','257813','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730558),('5','90','257813','270',185.00,185.00,11591.06,0.00,0.00,0.00,0.00,730559),('5','90','257814','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730560),('5','90','257814','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730561),('5','90','257814','270',185.00,185.00,8033.19,0.00,0.00,0.00,0.00,730562),('5','90','257815','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730563),('5','90','257815','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730564),('5','90','257815','270',185.00,165.00,8743.97,0.00,0.00,0.00,0.00,730565),('5','90','257816','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730566),('5','90','257816','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730567),('5','90','257816','270',185.00,185.00,9295.42,0.00,0.00,0.00,0.00,730568),('5','90','257817','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730569),('5','90','257817','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730570),('5','90','257817','270',185.00,185.00,14116.37,0.00,0.00,0.00,0.00,730571),('5','90','257818','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730572),('5','90','257818','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730573),('5','90','257818','270',185.00,185.00,14105.44,0.00,0.00,0.00,0.00,730574),('5','90','257819','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730575),('5','90','257819','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730576),('5','90','257819','270',185.00,185.00,2563.50,0.00,0.00,0.00,0.00,730577),('5','90','257820','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730578),('5','90','257820','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730579),('5','90','257820','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730580),('5','90','257821','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730581),('5','90','257821','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730582),('5','90','257821','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730583),('5','90','257822','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730584),('5','90','257822','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730585),('5','90','257822','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730586),('5','90','257823','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730587),('5','90','257823','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730588),('5','90','257823','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730589),('5','90','257824','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730590),('5','90','257824','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730591),('5','90','257824','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730592),('5','90','257825','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730593),('5','90','257825','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730594),('5','90','257825','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730595),('5','90','257826','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730596),('5','90','257826','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730597),('5','90','257826','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730598),('5','90','257827','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730599),('5','90','257827','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730600),('5','90','257827','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730601),('5','90','257828','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730602),('5','90','257828','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730603),('5','90','257828','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730604),('5','90','257829','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730605),('5','90','257829','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730606),('5','90','257829','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730607),('5','90','257830','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730608),('5','90','257830','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730609),('5','90','257830','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730610),('5','90','257831','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730611),('5','90','257831','271',345.00,800.00,0.00,0.00,0.00,0.00,0.00,730612),('5','90','257831','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730613),('5','90','257832','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730614),('5','90','257832','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730615),('5','90','257832','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730616),('5','90','257833','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730617),('5','90','257833','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730618),('5','90','257833','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730619),('5','90','257834','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730620),('5','90','257834','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730621),('5','90','257834','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730622),('5','90','257835','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730623),('5','90','257835','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730624),('5','90','257835','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730625),('5','90','257836','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730626),('5','90','257836','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730627),('5','90','257836','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730628),('5','90','257837','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730629),('5','90','257837','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730630),('5','90','257837','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730631),('5','90','257838','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730632),('5','90','257838','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730633),('5','90','257838','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730634),('5','90','257839','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730635),('5','90','257839','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730636),('5','90','257839','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730637),('5','90','257840','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730638),('5','90','257840','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730639),('5','90','257840','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730640),('5','90','257841','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730641),('5','90','257841','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730642),('5','90','257841','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730643),('5','90','257842','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730644),('5','90','257842','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730645),('5','90','257842','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730646),('5','90','257843','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730647),('5','90','257843','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730648),('5','90','257843','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730649),('5','90','257844','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730650),('5','90','257844','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730651),('5','90','257844','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730652),('5','90','257845','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730653),('5','90','257845','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730654),('5','90','257845','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730655),('5','90','257846','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730656),('5','90','257846','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730657),('5','90','257846','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730658),('5','90','257847','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730659),('5','90','257847','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730660),('5','90','257847','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730661),('5','90','257848','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730662),('5','90','257848','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730663),('5','90','257848','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730664),('5','90','257849','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730665),('5','90','257849','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730666),('5','90','257849','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730667),('5','90','257850','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730668),('5','90','257850','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730669),('5','90','257850','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730670),('5','90','257851','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730671),('5','90','257851','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730672),('5','90','257851','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730673),('5','90','257852','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730674),('5','90','257852','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730675),('5','90','257852','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730676),('5','90','257853','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730677),('5','90','257853','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730678),('5','90','257853','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730679),('5','90','257854','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730680),('5','90','257854','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730681),('5','90','257854','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730682),('5','90','257855','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730683),('5','90','257855','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730684),('5','90','257855','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730685),('5','90','257856','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730686),('5','90','257856','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730687),('5','90','257856','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730688),('5','90','257857','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730689),('5','90','257857','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730690),('5','90','257857','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730691),('5','90','257858','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730692),('5','90','257858','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730693),('5','90','257858','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730694),('5','90','257859','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730695),('5','90','257859','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730696),('5','90','257859','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730697),('5','90','257860','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730698),('5','90','257860','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730699),('5','90','257860','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730700),('5','90','257861','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730701),('5','90','257861','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730702),('5','90','257861','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730703),('5','90','257862','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730704),('5','90','257862','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730705),('5','90','257862','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730706),('5','90','257863','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730707),('5','90','257863','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730708),('5','90','257863','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730709),('5','90','257864','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730710),('5','90','257864','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730711),('5','90','257864','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730712),('5','90','257865','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730713),('5','90','257865','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730714),('5','90','257865','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730715),('5','90','257866','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730716),('5','90','257866','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730717),('5','90','257866','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730718),('5','90','257867','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730719),('5','90','257867','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730720),('5','90','257867','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730721),('5','90','257868','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730722),('5','90','257868','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730723),('5','90','257868','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730724),('5','90','257869','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730725),('5','90','257869','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730726),('5','90','257869','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730727),('5','90','257870','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730728),('5','90','257870','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730729),('5','90','257870','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730730),('5','90','257871','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730731),('5','90','257871','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730732),('5','90','257871','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730733),('5','90','257872','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730734),('5','90','257872','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730735),('5','90','257872','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730736),('5','90','257873','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730737),('5','90','257873','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730738),('5','90','257873','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730739),('5','90','257874','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730740),('5','90','257874','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730741),('5','90','257874','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730742),('5','90','257875','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730743),('5','90','257875','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730744),('5','90','257875','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730745),('5','90','257876','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730746),('5','90','257876','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730747),('5','90','257876','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730748),('5','90','257877','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730749),('5','90','257877','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730750),('5','90','257877','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730751),('5','90','257878','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730752),('5','90','257878','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730753),('5','90','257878','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730754),('5','90','257879','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730755),('5','90','257879','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730756),('5','90','257879','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730757),('5','90','257880','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730758),('5','90','257880','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730759),('5','90','257880','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730760),('5','90','257881','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730761),('5','90','257881','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730762),('5','90','257881','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730763),('5','90','257882','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730764),('5','90','257882','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730765),('5','90','257882','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730766),('5','90','257883','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730767),('5','90','257883','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730768),('5','90','257883','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730769),('5','90','257884','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730770),('5','90','257884','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730771),('5','90','257884','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730772),('5','90','257885','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730773),('5','90','257885','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730774),('5','90','257885','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730775),('5','90','257889','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730776),('5','90','257889','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730777),('5','90','257889','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730778),('5','90','257890','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730779),('5','90','257890','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730780),('5','90','257890','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730781),('5','90','257892','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730784),('5','90','257892','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730785),('5','90','257892','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730786),('5','90','257893','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730787),('5','90','257893','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730788),('5','90','257893','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730789),('5','90','257894','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730790),('5','90','257894','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730791),('5','90','257894','270',185.00,185.00,0.00,0.00,0.00,0.00,0.00,730792),('5','90','257895','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730793),('5','90','257895','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730794),('5','90','257895','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730795),('5','90','257896','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730796),('5','90','257896','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730797),('5','90','257896','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730798),('5','90','257897','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730799),('5','90','257897','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730800),('5','90','257897','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730801),('5','90','257898','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730802),('5','90','257898','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730803),('5','90','257898','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730804),('5','90','257899','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730805),('5','90','257899','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730806),('5','90','257899','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730807),('5','90','257900','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730808),('5','90','257900','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730809),('5','90','257900','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730810),('5','90','257901','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730811),('5','90','257901','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730812),('5','90','257901','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730813),('5','90','257902','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730814),('5','90','257902','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730815),('5','90','257902','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730816),('5','90','257903','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730817),('5','90','257903','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730818),('5','90','257903','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730819),('5','90','257904','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730820),('5','90','257904','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730821),('5','90','257904','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730822),('5','90','257905','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730823),('5','90','257905','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730824),('5','90','257905','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730825),('5','90','257906','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730826),('5','90','257906','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730827),('5','90','257906','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730828),('5','90','257907','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730829),('5','90','257907','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730830),('5','90','257907','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730831),('5','90','257908','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730832),('5','90','257908','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730833),('5','90','257908','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730834),('5','90','257909','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730835),('5','90','257909','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730836),('5','90','257909','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730837),('5','90','257910','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730838),('5','90','257910','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730839),('5','90','257910','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730840),('5','90','257911','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730841),('5','90','257911','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730842),('5','90','257911','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730843),('5','90','257912','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730844),('5','90','257912','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730845),('5','90','257912','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730846),('5','90','257913','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730847),('5','90','257913','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730848),('5','90','257913','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730849),('5','90','257914','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730850),('5','90','257914','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730851),('5','90','257914','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730852),('5','90','257915','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730853),('5','90','257915','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730854),('5','90','257915','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730855),('5','90','257916','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730856),('5','90','257916','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730857),('5','90','257916','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730858),('5','90','257917','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730859),('5','90','257917','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730860),('5','90','257917','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730861),('5','90','257918','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730862),('5','90','257918','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730863),('5','90','257918','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730864),('5','90','257919','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730865),('5','90','257919','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730866),('5','90','257919','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730867),('5','90','257920','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730868),('5','90','257920','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730869),('5','90','257920','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730870),('5','90','257921','270',185.00,220.00,0.00,0.00,0.00,0.00,0.00,730871),('5','90','257921','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730872),('5','90','257921','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730873),('5','90','257922','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730874),('5','90','257922','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730875),('5','90','257922','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730876),('5','90','257923','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730877),('5','90','257923','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730878),('5','90','257923','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730879),('5','90','257924','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730880),('5','90','257924','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730881),('5','90','257924','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730882),('5','90','257925','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730883),('5','90','257925','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730884),('5','90','257925','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730885),('5','90','257926','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730886),('5','90','257926','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730887),('5','90','257926','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730888),('5','90','257927','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730889),('5','90','257927','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730890),('5','90','257927','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730891),('5','90','257928','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730892),('5','90','257928','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730893),('5','90','257928','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730894),('5','90','257929','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730895),('5','90','257929','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730896),('5','90','257929','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730897),('5','90','257930','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730898),('5','90','257930','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730899),('5','90','257930','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730900),('5','90','257931','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730901),('5','90','257931','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730902),('5','90','257931','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730903),('5','90','257932','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730904),('5','90','257932','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730905),('5','90','257932','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730906),('5','90','257933','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730907),('5','90','257933','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730908),('5','90','257933','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730909),('5','90','257934','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730910),('5','90','257934','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730911),('5','90','257934','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730912),('5','90','257935','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730913),('5','90','257935','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730914),('5','90','257935','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730915),('5','90','257936','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730916),('5','90','257936','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730917),('5','90','257936','270',185.00,165.00,0.00,0.00,0.00,0.00,0.00,730918),('5','90','257937','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730919),('5','90','257937','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730920),('5','90','257937','270',210.00,165.00,8942.34,0.00,0.00,0.00,0.00,730921),('5','90','257938','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730922),('5','90','257938','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730923),('5','90','257938','270',210.00,210.00,12765.25,0.00,0.00,0.00,0.00,730924),('5','90','257939','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730925),('5','90','257939','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730926),('5','90','257939','270',210.00,165.00,8542.17,0.00,0.00,0.00,0.00,730927),('5','90','257940','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730928),('5','90','257940','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730929),('5','90','257940','270',210.00,210.00,5227.71,0.00,0.00,0.00,0.00,730930),('5','90','257941','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730931),('5','90','257941','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730932),('5','90','257941','270',210.00,210.00,7583.26,0.00,0.00,0.00,0.00,730933),('5','90','257942','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730934),('5','90','257942','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730935),('5','90','257942','270',210.00,210.00,1714.05,0.00,0.00,0.00,0.00,730936),('5','90','257943','270',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730937),('5','90','257943','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730938),('5','90','257943','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730939),('5','90','257944','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730940),('5','90','257944','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730941),('5','90','257944','270',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730942),('5','90','257945','270',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730943),('5','90','257945','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730944),('5','90','257945','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730945),('5','90','257946','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730946),('5','90','257946','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730947),('5','90','257946','270',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730948),('5','90','257947','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730949),('5','90','257947','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730950),('5','90','257947','270',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730951),('5','90','257948','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730952),('5','90','257948','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730953),('5','90','257948','270',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730954),('5','90','257949','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730955),('5','90','257949','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730956),('5','90','257949','270',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730957),('5','90','257950','270',210.00,210.00,0.00,0.00,0.00,0.00,0.00,730958),('5','90','257950','271',345.00,345.00,0.00,0.00,0.00,0.00,0.00,730959),('5','90','257950','272',0.00,0.00,0.00,0.00,0.00,0.00,0.00,730960);
/*!40000 ALTER TABLE `depots_shifts_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_stocklevels`
--

DROP TABLE IF EXISTS `depots_shifts_stocklevels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_stocklevels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `product_id` varchar(20) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  UNIQUE KEY `shift_id` (`id`),
  KEY `companycode` (`company_id`,`station_id`,`shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_stocklevels`
--

LOCK TABLES `depots_shifts_stocklevels` WRITE;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_shifts_stocklevels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tankgroups`
--

DROP TABLE IF EXISTS `depots_tankgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tankgroups` (
  `company_id` varchar(20) DEFAULT NULL,
  `group_id` int NOT NULL AUTO_INCREMENT,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=264 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tankgroups`
--

LOCK TABLES `depots_tankgroups` WRITE;
/*!40000 ALTER TABLE `depots_tankgroups` DISABLE KEYS */;
INSERT INTO `depots_tankgroups` VALUES ('5',263,'90','PRODUCT TANKS','TANKS CONTAINING PETROLEUM.');
/*!40000 ALTER TABLE `depots_tankgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks`
--

DROP TABLE IF EXISTS `depots_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `group_id` varchar(20) NOT NULL,
  `tank_id` int NOT NULL AUTO_INCREMENT,
  `tank_type` int NOT NULL DEFAULT '0',
  `product_id` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `capacity` decimal(20,2) NOT NULL,
  `content` decimal(20,2) NOT NULL,
  `content_backup` decimal(20,2) DEFAULT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`tank_id`),
  KEY `companycode` (`company_id`,`group_id`,`product_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `content` (`content`),
  KEY `tank_type` (`tank_type`),
  KEY `content_backup` (`content_backup`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=675 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks`
--

LOCK TABLES `depots_tanks` WRITE;
/*!40000 ALTER TABLE `depots_tanks` DISABLE KEYS */;
INSERT INTO `depots_tanks` VALUES ('5','90','263',668,0,'270','PMS TANK 1',44000.00,1.00,250.00,'TANK CONTAINING PMS','398','2019-02-24 01:45:07','2019-02-24 01:45:07','398',5,1),('5','90','263',669,0,'270','PMS TANK 2',44000.00,1.00,10347.74,'TANK CONTAINING PMS','398','2019-02-24 01:46:24','2019-02-24 01:46:24','398',5,1),('5','90','263',670,0,'270','PMS TANK 3',36000.00,1.00,8975.91,'TANK CONTAINING PMS','398','2019-02-24 01:48:01','2021-10-11 15:20:55','600',5,1),('5','90','263',671,0,'270','PMS TANK 4',36000.00,1.00,1250.24,'TANK CONTAINING PMS','398','2019-02-24 01:49:40','2019-02-24 01:49:40','398',5,1),('5','90','263',672,0,'270','PMS TANK 7',44000.00,1.00,600.00,'TANK CONTAINING PMS','398','2019-02-24 01:51:22','2019-02-24 01:51:22','398',5,1),('5','90','263',673,0,'271','AGO TANK',36000.00,1.00,9852.89,'TANK CONTAINING AGO','398','2019-02-24 01:52:26','2019-02-24 01:52:26','398',5,1),('5','90','263',674,0,'272','DPK TANK',36000.00,1.00,0.00,'TANK CONTAINING DPK','398','2019-02-24 01:53:44','2019-02-24 01:53:44','398',5,1);
/*!40000 ALTER TABLE `depots_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_balances`
--

DROP TABLE IF EXISTS `depots_tanks_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`tank_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_balances`
--

LOCK TABLES `depots_tanks_balances` WRITE;
/*!40000 ALTER TABLE `depots_tanks_balances` DISABLE KEYS */;
INSERT INTO `depots_tanks_balances` VALUES (1,'5','90',674,-40567.00,'2023-03-17 20:14:30'),(2,'5','90',673,445.78,'2023-03-17 20:14:30'),(3,'5','90',672,600.00,'2023-03-17 20:14:30'),(4,'5','90',671,4500.00,'2023-03-17 20:14:30'),(5,'5','90',670,1691.55,'2023-03-17 20:14:30'),(6,'5','90',669,1360.81,'2023-03-17 20:14:30'),(7,'5','90',668,79.88,'2023-03-17 20:14:30');
/*!40000 ALTER TABLE `depots_tanks_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_tanks_transfers`
--

DROP TABLE IF EXISTS `depots_tanks_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_tanks_transfers` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `company_id` bigint unsigned NOT NULL,
  `station_id` bigint unsigned NOT NULL,
  `source_tank` bigint unsigned NOT NULL,
  `destination_tank` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`,`station_id`,`source_tank`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_tanks_transfers`
--

LOCK TABLES `depots_tanks_transfers` WRITE;
/*!40000 ALTER TABLE `depots_tanks_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_tanks_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_drivers`
--

DROP TABLE IF EXISTS `fleets_drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_drivers` (
  `driver_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `surname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(6) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` varchar(30) NOT NULL,
  `medical` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`driver_id`),
  KEY `companycode` (`company_id`,`surname`,`othernames`,`gender`,`phone`,`email`,`city`,`state`,`thedate`,`createdby`,`modifiedon`,`modifiedby`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_drivers`
--

LOCK TABLES `fleets_drivers` WRITE;
/*!40000 ALTER TABLE `fleets_drivers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_providers`
--

DROP TABLE IF EXISTS `fleets_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_providers` (
  `provider_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`provider_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_providers`
--

LOCK TABLES `fleets_providers` WRITE;
/*!40000 ALTER TABLE `fleets_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks`
--

DROP TABLE IF EXISTS `fleets_trucks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks` (
  `truck_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `regno` varchar(20) NOT NULL,
  `manufacturer` varchar(30) NOT NULL,
  `model` varchar(30) NOT NULL,
  `capacity` double(10,2) NOT NULL,
  `purchased` datetime NOT NULL,
  `provider_id` int NOT NULL,
  `driver_id` int NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`truck_id`),
  UNIQUE KEY `regno` (`regno`),
  KEY `companycode` (`company_id`,`manufacturer`,`capacity`,`provider_id`,`driver_id`,`status`,`thedate`,`createdby`,`modifiedon`,`modifiedby`),
  KEY `purchased` (`purchased`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks`
--

LOCK TABLES `fleets_trucks` WRITE;
/*!40000 ALTER TABLE `fleets_trucks` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_activities`
--

DROP TABLE IF EXISTS `fleets_trucks_activities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_activities` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `driver_id` int NOT NULL,
  `truck_id` int NOT NULL,
  `from` varchar(100) NOT NULL,
  `destination` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`driver_id`,`truck_id`,`thedate`,`createdby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_activities`
--

LOCK TABLES `fleets_trucks_activities` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_activities` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_activities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_trucks_movements`
--

DROP TABLE IF EXISTS `fleets_trucks_movements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_trucks_movements` (
  `movement_id` int NOT NULL AUTO_INCREMENT,
  `truck_id` int NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `movementdate` date NOT NULL,
  `voucher` varchar(30) NOT NULL,
  `source` varchar(30) NOT NULL,
  `destination` varchar(30) NOT NULL,
  `quantity` int NOT NULL,
  `houlage` decimal(10,2) NOT NULL,
  `fuelqty` int NOT NULL,
  `fuelrate` decimal(10,2) NOT NULL,
  `repairs` decimal(20,2) NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `description` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `account_debit` varchar(20) NOT NULL,
  `account_credit` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `testingcoo` varchar(20) NOT NULL,
  PRIMARY KEY (`movement_id`),
  KEY `truck_id` (`truck_id`,`company_id`,`thedate`,`createdby`),
  KEY `movementdate` (`movementdate`),
  KEY `status` (`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_trucks_movements`
--

LOCK TABLES `fleets_trucks_movements` WRITE;
/*!40000 ALTER TABLE `fleets_trucks_movements` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_trucks_movements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `fleets_waybills`
--

DROP TABLE IF EXISTS `fleets_waybills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fleets_waybills` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `waybill_id` int NOT NULL AUTO_INCREMENT,
  `loadingdate` date NOT NULL,
  `truck_id` int NOT NULL,
  `depotfrom` int NOT NULL,
  `depotto` int NOT NULL,
  `product_id` int NOT NULL,
  `quantity` decimal(20,2) NOT NULL,
  `waybill` varchar(30) NOT NULL,
  `mt` varchar(30) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`waybill_id`),
  KEY `companycode` (`company_id`,`loadingdate`,`truck_id`,`depotfrom`,`depotto`,`product_id`,`waybill`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fleets_waybills`
--

LOCK TABLES `fleets_waybills` WRITE;
/*!40000 ALTER TABLE `fleets_waybills` DISABLE KEYS */;
/*!40000 ALTER TABLE `fleets_waybills` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_attendance`
--

DROP TABLE IF EXISTS `hr_attendance`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_attendance` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendance_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `workdate` date NOT NULL,
  `hourfrom` int NOT NULL,
  `hourto` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendance_id`),
  UNIQUE KEY `companycode` (`company_id`,`employee_id`,`workdate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_attendance`
--

LOCK TABLES `hr_attendance` WRITE;
/*!40000 ALTER TABLE `hr_attendance` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_attendance` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_departments`
--

DROP TABLE IF EXISTS `hr_departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_departments` (
  `department_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`department_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_departments`
--

LOCK TABLES `hr_departments` WRITE;
/*!40000 ALTER TABLE `hr_departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees`
--

DROP TABLE IF EXISTS `hr_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `gender` varchar(1) NOT NULL,
  `dateofbirth` date NOT NULL,
  `qualification` varchar(100) NOT NULL,
  `address` varchar(150) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `employer` varchar(30) NOT NULL,
  `tax_id` varchar(30) NOT NULL,
  `refferee1` varchar(50) NOT NULL,
  `refferee2` varchar(50) NOT NULL,
  `workexperience` text NOT NULL,
  `department_id` int NOT NULL,
  `level_id` varchar(20) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `employedon` date NOT NULL,
  `status` int NOT NULL,
  `type` varchar(5) NOT NULL,
  `dischargedon` date NOT NULL,
  `dischargereason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`employee_id`),
  KEY `companycode` (`company_id`,`surname`,`firstname`,`othernames`,`gender`,`dateofbirth`,`qualification`,`city`,`state`,`country`,`email`,`phone`),
  KEY `tax_id` (`tax_id`,`department_id`,`employedon`,`status`),
  KEY `level_id` (`level_id`),
  KEY `type` (`type`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees`
--

LOCK TABLES `hr_employees` WRITE;
/*!40000 ALTER TABLE `hr_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries`
--

DROP TABLE IF EXISTS `hr_employees_salaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` varchar(20) NOT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` int NOT NULL AUTO_INCREMENT,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `periodworked` int NOT NULL,
  `overtimerate` int NOT NULL,
  `overtimeperiod` int NOT NULL,
  `overtimeworked` int NOT NULL,
  `basicamount` decimal(20,2) NOT NULL,
  `overtimeamount` decimal(20,2) NOT NULL,
  `allowances` decimal(20,2) NOT NULL,
  `deductions` decimal(20,2) NOT NULL,
  `datefrom` date NOT NULL,
  `dateto` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `paidby` varchar(20) NOT NULL,
  `status` int NOT NULL,
  PRIMARY KEY (`salary_id`),
  KEY `companycode` (`company_id`,`employee_id`,`thedate`,`status`),
  KEY `sheet_id` (`sheet_id`),
  KEY `paidby` (`paidby`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries`
--

LOCK TABLES `hr_employees_salaries` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_employees_salaries_items`
--

DROP TABLE IF EXISTS `hr_employees_salaries_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_employees_salaries_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `employee_id` varchar(20) NOT NULL,
  `salary_id` varchar(20) NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `type` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`employee_id`,`salary_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_employees_salaries_items`
--

LOCK TABLES `hr_employees_salaries_items` WRITE;
/*!40000 ALTER TABLE `hr_employees_salaries_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_employees_salaries_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_holidays`
--

DROP TABLE IF EXISTS `hr_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_holidays` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `holiday_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `holiday` date NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`holiday_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_holidays`
--

LOCK TABLES `hr_holidays` WRITE;
/*!40000 ALTER TABLE `hr_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels`
--

DROP TABLE IF EXISTS `hr_levels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `basicrate` decimal(20,2) NOT NULL,
  `basicperiod` int NOT NULL,
  `overtimerate` decimal(20,2) NOT NULL,
  `overtimeperiod` int NOT NULL,
  `description` varchar(250) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`level_id`),
  KEY `companycode` (`company_id`,`name`,`basicrate`,`basicperiod`,`overtimerate`,`overtimeperiod`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels`
--

LOCK TABLES `hr_levels` WRITE;
/*!40000 ALTER TABLE `hr_levels` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_benefits`
--

DROP TABLE IF EXISTS `hr_levels_benefits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_benefits` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `benefit_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`benefit_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_benefits`
--

LOCK TABLES `hr_levels_benefits` WRITE;
/*!40000 ALTER TABLE `hr_levels_benefits` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_benefits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_levels_items`
--

DROP TABLE IF EXISTS `hr_levels_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_levels_items` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `level_id` int NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` int NOT NULL,
  `amounttype` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `showonslip` int NOT NULL,
  `item_id` int NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`level_id`,`name`,`type`,`amount`,`showonslip`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_levels_items`
--

LOCK TABLES `hr_levels_items` WRITE;
/*!40000 ALTER TABLE `hr_levels_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_levels_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_loans`
--

DROP TABLE IF EXISTS `hr_loans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_loans` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `loan_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `interest` decimal(20,2) NOT NULL,
  `payable` decimal(20,2) NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `repayment` int NOT NULL,
  `deduction` decimal(20,2) NOT NULL,
  `paid` decimal(20,2) NOT NULL,
  `details` varchar(200) NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` int NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`loan_id`),
  KEY `companycode` (`company_id`,`employee_id`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_loans`
--

LOCK TABLES `hr_loans` WRITE;
/*!40000 ALTER TABLE `hr_loans` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_loans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_payslips`
--

DROP TABLE IF EXISTS `hr_payslips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_payslips` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `sheet_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `startdate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  PRIMARY KEY (`sheet_id`),
  KEY `companycode` (`company_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_payslips`
--

LOCK TABLES `hr_payslips` WRITE;
/*!40000 ALTER TABLE `hr_payslips` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_payslips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `hr_vacations`
--

DROP TABLE IF EXISTS `hr_vacations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `hr_vacations` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `vacation_id` int NOT NULL AUTO_INCREMENT,
  `employee_id` int NOT NULL,
  `startdate` date NOT NULL,
  `enddate` date NOT NULL,
  `allowance` decimal(20,2) NOT NULL,
  `details` text NOT NULL,
  `status` int NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  PRIMARY KEY (`vacation_id`),
  KEY `companycode` (`company_id`,`employee_id`,`startdate`,`enddate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hr_vacations`
--

LOCK TABLES `hr_vacations` WRITE;
/*!40000 ALTER TABLE `hr_vacations` DISABLE KEYS */;
/*!40000 ALTER TABLE `hr_vacations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory`
--

DROP TABLE IF EXISTS `inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `product_id` int DEFAULT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `qtyin` decimal(20,2) NOT NULL,
  `qtyout` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `companycode_old` varchar(100) NOT NULL,
  `depot_id_old` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`qtyin`,`qtyout`),
  KEY `profit` (`profit`),
  KEY `depot_id` (`station_id`,`tank_id`),
  KEY `companycode_old` (`companycode_old`,`depot_id_old`)
) ENGINE=InnoDB AUTO_INCREMENT=2614503 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory`
--

LOCK TABLES `inventory` WRITE;
/*!40000 ALTER TABLE `inventory` DISABLE KEYS */;
INSERT INTO `inventory` VALUES (2410394,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3712500.00,22500.00,0.00,0.00,'2021-12-31 11:22:23','',''),(2411074,'5','90',NULL,270,'Reception corrector for bridging 129314',0.00,0.00,0.00,22500.00,0.00,'2021-12-31 12:55:24','',''),(2411075,'5','90','670',270,'Received from bridging 129314',0.00,0.00,22500.00,0.00,0.00,'2021-12-31 12:55:24','',''),(2415197,'5','90','670',270,'Sale Id shift 250180',0.00,0.00,0.00,1797.71,0.00,'2022-01-01 07:50:19','',''),(2415198,'5','90','670',270,'Sale Id shift 250180',0.00,0.00,0.00,1017.84,0.00,'2022-01-01 07:50:19','',''),(2415199,'5','90',NULL,270,'Sale Id shift 250180',464565.75,0.00,0.00,0.00,0.00,'2022-01-01 07:50:19','',''),(2420888,'5','90','670',270,'Sale Id shift 250412',0.00,0.00,0.00,1893.23,0.00,'2022-01-02 06:47:50','',''),(2420889,'5','90','670',270,'Sale Id shift 250412',0.00,0.00,0.00,1735.24,0.00,'2022-01-02 06:47:50','',''),(2420890,'5','90',NULL,270,'Sale Id shift 250412',598697.55,0.00,0.00,0.00,0.00,'2022-01-02 06:47:50','',''),(2430355,'5','90','670',270,'Sale Id shift 250600',0.00,0.00,0.00,2057.58,0.00,'2022-01-03 14:06:33','',''),(2430356,'5','90','670',270,'Sale Id shift 250600',0.00,0.00,0.00,2494.18,0.00,'2022-01-03 14:06:33','',''),(2430357,'5','90',NULL,270,'Sale Id shift 250600',751040.40,0.00,0.00,0.00,0.00,'2022-01-03 14:06:33','',''),(2433267,'5','90','670',270,'Sale Id shift 250993',0.00,0.00,0.00,5203.73,0.00,'2022-01-04 07:05:48','',''),(2433268,'5','90','670',270,'Sale Id shift 250993',0.00,0.00,0.00,5104.57,0.00,'2022-01-04 07:05:48','',''),(2433269,'5','90',NULL,270,'Sale Id shift 250993',1700869.50,0.00,0.00,0.00,0.00,'2022-01-04 07:05:48','',''),(2433692,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4867500.00,29500.00,0.00,0.00,'2022-01-04 07:56:36','',''),(2435229,'5','90',NULL,270,'Reception corrector for bridging 129650',0.00,0.00,0.00,29500.00,0.00,'2022-01-04 10:18:36','',''),(2435230,'5','90','670',270,'Received from bridging 129650',0.00,0.00,29500.00,0.00,0.00,'2022-01-04 10:18:36','',''),(2440937,'5','90','670',270,'Sale Id shift 251061',0.00,0.00,0.00,4495.39,0.00,'2022-01-05 07:35:58','',''),(2440938,'5','90','670',270,'Sale Id shift 251061',0.00,0.00,0.00,4072.02,0.00,'2022-01-05 07:35:58','',''),(2440939,'5','90',NULL,270,'Sale Id shift 251061',1413622.65,0.00,0.00,0.00,0.00,'2022-01-05 07:35:58','',''),(2448393,'5','90','670',270,'Sale Id shift 251365',0.00,0.00,0.00,4702.80,0.00,'2022-01-06 07:49:59','',''),(2448394,'5','90','670',270,'Sale Id shift 251365',0.00,0.00,0.00,4828.88,0.00,'2022-01-06 07:49:59','',''),(2448395,'5','90',NULL,270,'Sale Id shift 251365',1572727.20,0.00,0.00,0.00,0.00,'2022-01-06 07:49:59','',''),(2456975,'5','90','670',270,'Sale Id shift 251587',0.00,0.00,0.00,4799.28,0.00,'2022-01-07 09:10:19','',''),(2456976,'5','90','670',270,'Sale Id shift 251587',0.00,0.00,0.00,4453.28,0.00,'2022-01-07 09:10:19','',''),(2456977,'5','90',NULL,270,'Sale Id shift 251587',1526672.40,0.00,0.00,0.00,0.00,'2022-01-07 09:10:19','',''),(2463418,'5','90','670',270,'Sale Id shift 251915',0.00,0.00,0.00,1964.11,0.00,'2022-01-08 07:59:04','',''),(2463419,'5','90','670',270,'Sale Id shift 251915',0.00,0.00,0.00,1974.54,0.00,'2022-01-08 07:59:04','',''),(2463420,'5','90',NULL,270,'Sale Id shift 251915',649877.25,0.00,0.00,0.00,0.00,'2022-01-08 07:59:04','',''),(2612841,'5','90',NULL,270,'Balance from closing inventory values 2021-11-31 23:59:59',15024544.23,15702390.00,191060.00,186904.81,0.00,'2021-11-30 23:59:59','',''),(2613082,'5','90',NULL,272,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613118,'5','90',NULL,271,'Balance from closing inventory values 2021-11-31 23:59:59',2802970.40,2685000.00,17900.00,17454.22,0.00,'2021-11-30 23:59:59','',''),(2613229,'5','90','674',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,0.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613410,'5','90','672',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,600.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613472,'5','90','673',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,8950.00,8504.22,0.00,'2021-11-30 23:59:59','',''),(2613597,'5','90','671',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,500.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613613,'5','90','668',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,300.00,0.00,0.00,'2021-11-30 23:59:59','',''),(2613707,'5','90','670',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,80530.00,78924.88,0.00,'2021-11-30 23:59:59','',''),(2613876,'5','90','669',0,'Balance from closing inventory values 2021-11-31 23:59:59',0.00,0.00,13600.00,12449.93,0.00,'2021-11-30 23:59:59','',''),(2613877,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4917000.00,29800.00,0.00,0.00,'2022-02-03 15:40:09','',''),(2613878,'5','90',NULL,270,'Reception corrector for bridging 129651',0.00,0.00,0.00,29800.00,0.00,'2022-02-03 16:34:53','',''),(2613879,'5','90','670',270,'Received from bridging 129651',0.00,0.00,29800.00,0.00,0.00,'2022-02-03 16:34:53','',''),(2613880,'5','90','670',270,'Sale Id shift 257527',0.00,0.00,0.00,3478.36,0.00,'2022-02-04 06:27:40','',''),(2613881,'5','90','670',270,'Sale Id shift 257527',0.00,0.00,0.00,3149.81,0.00,'2022-02-04 06:27:40','',''),(2613882,'5','90',NULL,270,'Sale Id shift 257527',1093648.05,0.00,0.00,0.00,0.00,'2022-02-04 06:27:40','',''),(2613883,'5','90','670',270,'Sale Id shift 257528',0.00,0.00,0.00,2202.11,0.00,'2022-02-05 07:51:07','',''),(2613884,'5','90','670',270,'Sale Id shift 257528',0.00,0.00,0.00,1399.21,0.00,'2022-02-05 07:51:07','',''),(2613885,'5','90',NULL,270,'Sale Id shift 257528',594217.80,0.00,0.00,0.00,0.00,'2022-02-05 07:51:07','',''),(2613886,'5','90','670',270,'Sale Id shift 257529',0.00,0.00,0.00,2827.09,0.00,'2022-02-06 07:47:29','',''),(2613887,'5','90','670',270,'Sale Id shift 257529',0.00,0.00,0.00,2473.85,0.00,'2022-02-06 07:47:29','',''),(2613888,'5','90',NULL,270,'Sale Id shift 257529',874655.10,0.00,0.00,0.00,0.00,'2022-02-06 07:47:29','',''),(2613889,'5','90','670',270,'Sale Id shift 257530',0.00,0.00,0.00,2404.47,0.00,'2022-02-07 07:16:43','',''),(2613890,'5','90','670',270,'Sale Id shift 257530',0.00,0.00,0.00,2537.32,0.00,'2022-02-07 07:16:43','',''),(2613891,'5','90',NULL,270,'Sale Id shift 257530',815395.35,0.00,0.00,0.00,0.00,'2022-02-07 07:16:43','',''),(2613892,'5','90','670',270,'Sale Id shift 257531',0.00,0.00,0.00,2513.85,0.00,'2022-02-08 07:42:45','',''),(2613893,'5','90','670',270,'Sale Id shift 257531',0.00,0.00,0.00,2862.63,0.00,'2022-02-08 07:42:45','',''),(2613894,'5','90',NULL,270,'Sale Id shift 257531',887119.20,0.00,0.00,0.00,0.00,'2022-02-08 07:42:45','',''),(2613895,'5','90','670',270,'Sale Id shift 257532',0.00,0.00,0.00,1481.70,0.00,'2022-02-09 08:18:38','',''),(2613896,'5','90','670',270,'Sale Id shift 257532',0.00,0.00,0.00,1560.50,0.00,'2022-02-09 08:18:38','',''),(2613897,'5','90',NULL,270,'Sale Id shift 257532',501963.00,0.00,0.00,0.00,0.00,'2022-02-09 08:18:38','',''),(2613898,'5','90','670',270,'Sale Id shift 257533',0.00,0.00,0.00,539.08,0.00,'2022-02-10 08:00:56','',''),(2613899,'5','90','670',270,'Sale Id shift 257533',0.00,0.00,0.00,532.36,0.00,'2022-02-10 08:00:56','',''),(2613900,'5','90',NULL,270,'Sale Id shift 257533',176787.60,0.00,0.00,0.00,0.00,'2022-02-10 08:00:56','',''),(2613901,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,455730.00,2762.00,0.00,0.00,'2022-02-17 10:06:21','',''),(2613902,'5','90',NULL,270,'Reception corrector for bridging 129652',0.00,0.00,0.00,2762.00,0.00,'2022-02-17 10:08:08','',''),(2613903,'5','90','669',270,'Received from bridging 129652',0.00,0.00,2762.00,0.00,0.00,'2022-02-17 10:08:08','',''),(2613904,'5','90','669',0,'Tank level zero out for dipping',0.00,0.00,0.00,3912.07,0.00,'2022-02-17 10:08:27','',''),(2613905,'5','90','669',0,'Inventory adjustment from tank dipping to 1150',0.00,0.00,1150.00,0.00,0.00,'2022-02-17 10:08:27','',''),(2613906,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2178000.00,13200.00,0.00,0.00,'2022-02-20 21:20:11','',''),(2613907,'5','90',NULL,270,'Reception corrector for bridging 129653',0.00,0.00,0.00,13200.00,0.00,'2022-02-20 22:44:45','',''),(2613908,'5','90','670',270,'Received from bridging 129653',0.00,0.00,13200.00,0.00,0.00,'2022-02-20 22:44:45','',''),(2613909,'5','90','670',270,'Sale Id shift 257544',0.00,0.00,0.00,2334.67,0.00,'2022-02-21 07:25:21','',''),(2613910,'5','90','670',270,'Sale Id shift 257544',0.00,0.00,0.00,2825.90,0.00,'2022-02-21 07:25:21','',''),(2613911,'5','90',NULL,270,'Sale Id shift 257544',851494.05,0.00,0.00,0.00,0.00,'2022-02-21 07:25:21','',''),(2613912,'5','90','670',270,'Sale Id shift 257545',0.00,0.00,0.00,4008.80,0.00,'2022-02-22 06:43:16','',''),(2613913,'5','90','670',270,'Sale Id shift 257545',0.00,0.00,0.00,3519.77,0.00,'2022-02-22 06:43:16','',''),(2613914,'5','90',NULL,270,'Sale Id shift 257545',1242214.05,0.00,0.00,0.00,0.00,'2022-02-22 06:43:16','',''),(2613915,'5','90','670',270,'Sale Id shift 257546',0.00,0.00,0.00,278.13,0.00,'2022-02-23 07:02:33','',''),(2613916,'5','90',NULL,270,'Sale Id shift 257546',45891.45,0.00,0.00,0.00,0.00,'2022-02-23 07:02:33','',''),(2613917,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4950000.00,30000.00,0.00,0.00,'2022-02-27 07:02:43','',''),(2613918,'5','90',NULL,270,'Reception corrector for bridging 129654',0.00,0.00,0.00,30000.00,0.00,'2022-02-27 07:24:54','',''),(2613919,'5','90','670',270,'Received from bridging 129654',0.00,0.00,30000.00,0.00,0.00,'2022-02-27 07:24:54','',''),(2613920,'5','90','669',270,'Sale Id shift 257550',0.00,0.00,0.00,634.71,0.00,'2022-02-27 23:05:38','',''),(2613921,'5','90','670',270,'Sale Id shift 257550',0.00,0.00,0.00,265.27,0.00,'2022-02-27 23:05:38','',''),(2613922,'5','90',NULL,270,'Sale Id shift 257550',148496.70,0.00,0.00,0.00,0.00,'2022-02-27 23:05:38','',''),(2613923,'5','90','670',270,'Sale Id shift 257551',0.00,0.00,0.00,7243.75,0.00,'2022-03-01 06:54:53','',''),(2613924,'5','90','670',270,'Sale Id shift 257551',0.00,0.00,0.00,6323.59,0.00,'2022-03-01 06:54:53','',''),(2613925,'5','90',NULL,270,'Sale Id shift 257551',2238611.10,0.00,0.00,0.00,0.00,'2022-03-01 06:54:53','',''),(2613926,'5','90','670',270,'Sale Id shift 257552',0.00,0.00,0.00,7824.85,0.00,'2022-03-01 09:24:50','',''),(2613927,'5','90','670',270,'Sale Id shift 257552',0.00,0.00,0.00,3096.60,0.00,'2022-03-01 09:24:50','',''),(2613928,'5','90',NULL,270,'Sale Id shift 257552',1802039.25,0.00,0.00,0.00,0.00,'2022-03-01 09:24:50','',''),(2613929,'5','90','670',270,'Sale Id shift 257553',0.00,0.00,0.00,26.87,0.00,'2022-03-02 08:19:56','',''),(2613930,'5','90','670',270,'Sale Id shift 257553',0.00,0.00,0.00,5416.78,0.00,'2022-03-02 08:19:56','',''),(2613931,'5','90',NULL,270,'Sale Id shift 257553',898202.25,0.00,0.00,0.00,0.00,'2022-03-02 08:19:56','',''),(2613932,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2145000.00,13000.00,0.00,0.00,'2022-03-17 02:24:22','',''),(2613933,'5','90',NULL,270,'Reception corrector for bridging 129655',0.00,0.00,0.00,13000.00,0.00,'2022-03-17 06:55:21','',''),(2613934,'5','90','670',270,'Received from bridging 129655',0.00,0.00,13000.00,0.00,0.00,'2022-03-17 06:55:21','',''),(2613935,'5','90','670',270,'Sale Id shift 257568',0.00,0.00,0.00,400.00,0.00,'2022-03-17 10:22:46','',''),(2613936,'5','90',NULL,270,'Sale Id shift 257568',66000.00,0.00,0.00,0.00,0.00,'2022-03-17 10:22:46','',''),(2613937,'5','90','670',270,'Sale Id shift 257569',0.00,0.00,0.00,4663.27,0.00,'2022-03-18 07:47:40','',''),(2613938,'5','90','670',270,'Sale Id shift 257569',0.00,0.00,0.00,3465.54,0.00,'2022-03-18 07:47:40','',''),(2613939,'5','90',NULL,270,'Sale Id shift 257569',1341253.65,0.00,0.00,0.00,0.00,'2022-03-18 07:47:40','',''),(2613940,'5','90','670',270,'Sale Id shift 257570',0.00,0.00,0.00,3372.44,0.00,'2022-03-19 07:01:58','',''),(2613941,'5','90','670',270,'Sale Id shift 257570',0.00,0.00,0.00,994.66,0.00,'2022-03-19 07:01:58','',''),(2613942,'5','90',NULL,270,'Sale Id shift 257570',720571.50,0.00,0.00,0.00,0.00,'2022-03-19 07:01:58','',''),(2613943,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-09 16:12:50','',''),(2613944,'5','90',NULL,270,'Reception corrector for bridging 129656',0.00,0.00,0.00,15000.00,0.00,'2022-04-09 18:30:54','',''),(2613945,'5','90','670',270,'Received from bridging 129656',0.00,0.00,15000.00,0.00,0.00,'2022-04-09 18:30:54','',''),(2613946,'5','90','670',270,'Sale Id shift 257592',0.00,0.00,0.00,1371.63,0.00,'2022-04-10 15:00:29','',''),(2613947,'5','90','670',270,'Sale Id shift 257592',0.00,0.00,0.00,1773.11,0.00,'2022-04-10 15:00:29','',''),(2613948,'5','90',NULL,270,'Sale Id shift 257592',518882.10,0.00,0.00,0.00,0.00,'2022-04-10 15:00:29','',''),(2613949,'5','90','670',270,'Sale Id shift 257593',0.00,0.00,0.00,3608.80,0.00,'2022-04-11 08:58:12','',''),(2613950,'5','90','670',270,'Sale Id shift 257593',0.00,0.00,0.00,2359.22,0.00,'2022-04-11 08:58:12','',''),(2613951,'5','90',NULL,270,'Sale Id shift 257593',984723.30,0.00,0.00,0.00,0.00,'2022-04-11 08:58:12','',''),(2613952,'5','90','670',270,'Sale Id shift 257594',0.00,0.00,0.00,1814.71,0.00,'2022-04-12 07:17:08','',''),(2613953,'5','90','670',270,'Sale Id shift 257594',0.00,0.00,0.00,1357.37,0.00,'2022-04-12 07:17:08','',''),(2613954,'5','90',NULL,270,'Sale Id shift 257594',523393.20,0.00,0.00,0.00,0.00,'2022-04-12 07:17:08','',''),(2613955,'5','90','670',270,'Sale Id shift 257595',0.00,0.00,0.00,1909.69,0.00,'2022-04-13 09:55:00','',''),(2613956,'5','90','670',270,'Sale Id shift 257595',0.00,0.00,0.00,820.75,0.00,'2022-04-13 09:55:00','',''),(2613957,'5','90',NULL,270,'Sale Id shift 257595',450522.60,0.00,0.00,0.00,0.00,'2022-04-13 09:55:00','',''),(2613958,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2178000.00,13200.00,0.00,0.00,'2022-04-19 10:17:16','',''),(2613959,'5','90','674',272,'Sale Id shift 257604',0.00,0.00,0.00,40567.00,0.00,'2022-04-22 09:26:33','',''),(2613960,'5','90',NULL,272,'Sale Id shift 257604',0.00,0.00,0.00,0.00,0.00,'2022-04-22 09:26:33','',''),(2613961,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-04-27 09:39:06','',''),(2613962,'5','90',NULL,270,'Reception corrector for bridging 129657',0.00,0.00,0.00,15000.00,0.00,'2022-04-27 10:47:15','',''),(2613963,'5','90','670',270,'Received from bridging 129657',0.00,0.00,15000.00,0.00,0.00,'2022-04-27 10:47:15','',''),(2613964,'5','90','670',270,'Sale Id shift 257610',0.00,0.00,0.00,1417.27,0.00,'2022-04-27 11:12:21','',''),(2613965,'5','90','670',270,'Sale Id shift 257610',0.00,0.00,0.00,206.37,0.00,'2022-04-27 11:12:21','',''),(2613966,'5','90',NULL,270,'Sale Id shift 257610',267900.60,0.00,0.00,0.00,0.00,'2022-04-27 11:12:21','',''),(2613967,'5','90','670',270,'Sale Id shift 257611',0.00,0.00,0.00,3554.74,0.00,'2022-04-28 08:34:44','',''),(2613968,'5','90','670',270,'Sale Id shift 257611',0.00,0.00,0.00,2330.97,0.00,'2022-04-28 08:34:44','',''),(2613969,'5','90',NULL,270,'Sale Id shift 257611',971142.15,0.00,0.00,0.00,0.00,'2022-04-28 08:34:44','',''),(2613970,'5','90','670',270,'Sale Id shift 257612',0.00,0.00,0.00,3211.94,0.00,'2022-04-28 20:49:32','',''),(2613971,'5','90','670',270,'Sale Id shift 257612',0.00,0.00,0.00,2154.83,0.00,'2022-04-28 20:49:32','',''),(2613972,'5','90',NULL,270,'Sale Id shift 257612',885517.05,0.00,0.00,0.00,0.00,'2022-04-28 20:49:32','',''),(2613973,'5','90','670',270,'Sale Id shift 257614',0.00,0.00,0.00,1180.38,0.00,'2022-05-09 16:15:42','',''),(2613974,'5','90','670',270,'Sale Id shift 257614',0.00,0.00,0.00,809.61,0.00,'2022-05-09 16:15:42','',''),(2613975,'5','90',NULL,270,'Sale Id shift 257614',328348.35,0.00,0.00,0.00,0.00,'2022-05-09 16:15:42','',''),(2613976,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4867500.00,29500.00,0.00,0.00,'2022-05-09 16:40:54','',''),(2613977,'5','90',NULL,270,'Reception corrector for bridging 129658',0.00,0.00,0.00,29500.00,0.00,'2022-05-09 16:47:55','',''),(2613978,'5','90','670',270,'Received from bridging 129658',0.00,0.00,29500.00,0.00,0.00,'2022-05-09 16:47:55','',''),(2613979,'5','90','670',270,'Sale Id shift 257620',0.00,0.00,0.00,3051.85,0.00,'2022-05-09 17:01:34','',''),(2613980,'5','90','670',270,'Sale Id shift 257620',0.00,0.00,0.00,2872.70,0.00,'2022-05-09 17:01:34','',''),(2613981,'5','90',NULL,270,'Sale Id shift 257620',977550.75,0.00,0.00,0.00,0.00,'2022-05-09 17:01:34','',''),(2613982,'5','90','670',270,'Sale Id shift 257621',0.00,0.00,0.00,3282.54,0.00,'2022-05-09 17:07:49','',''),(2613983,'5','90','670',270,'Sale Id shift 257621',0.00,0.00,0.00,2060.71,0.00,'2022-05-09 17:07:49','',''),(2613984,'5','90',NULL,270,'Sale Id shift 257621',881636.25,0.00,0.00,0.00,0.00,'2022-05-09 17:07:49','',''),(2613985,'5','90','670',270,'Sale Id shift 257622',0.00,0.00,0.00,3459.12,0.00,'2022-05-09 17:11:46','',''),(2613986,'5','90','670',270,'Sale Id shift 257622',0.00,0.00,0.00,2413.27,0.00,'2022-05-09 17:11:46','',''),(2613987,'5','90',NULL,270,'Sale Id shift 257622',968944.35,0.00,0.00,0.00,0.00,'2022-05-09 17:11:46','',''),(2613988,'5','90','670',270,'Sale Id shift 257623',0.00,0.00,0.00,2194.35,0.00,'2022-05-09 17:15:14','',''),(2613989,'5','90','670',270,'Sale Id shift 257623',0.00,0.00,0.00,2384.43,0.00,'2022-05-09 17:15:14','',''),(2613990,'5','90',NULL,270,'Sale Id shift 257623',755498.70,0.00,0.00,0.00,0.00,'2022-05-09 17:15:14','',''),(2613991,'5','90','670',270,'Sale Id shift 257624',0.00,0.00,0.00,2073.71,0.00,'2022-05-10 08:57:38','',''),(2613992,'5','90','670',270,'Sale Id shift 257624',0.00,0.00,0.00,1656.78,0.00,'2022-05-10 08:57:38','',''),(2613993,'5','90',NULL,270,'Sale Id shift 257624',615530.85,0.00,0.00,0.00,0.00,'2022-05-10 08:57:38','',''),(2613994,'5','90','670',270,'Sale Id shift 257625',0.00,0.00,0.00,1544.42,0.00,'2022-05-12 11:16:12','',''),(2613995,'5','90','670',270,'Sale Id shift 257625',0.00,0.00,0.00,1893.78,0.00,'2022-05-12 11:16:12','',''),(2613996,'5','90',NULL,270,'Sale Id shift 257625',567303.00,0.00,0.00,0.00,0.00,'2022-05-12 11:16:12','',''),(2613997,'5','90','670',270,'Sale Id shift 257626',0.00,0.00,0.00,516.59,0.00,'2022-05-12 11:33:38','',''),(2613998,'5','90','670',270,'Sale Id shift 257626',0.00,0.00,0.00,443.05,0.00,'2022-05-12 11:33:38','',''),(2613999,'5','90',NULL,270,'Sale Id shift 257626',158340.60,0.00,0.00,0.00,0.00,'2022-05-12 11:33:38','',''),(2614000,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2458500.00,14900.00,0.00,0.00,'2022-05-16 08:05:44','',''),(2614001,'5','90',NULL,270,'Reception corrector for bridging 129659',0.00,0.00,0.00,14900.00,0.00,'2022-05-16 08:33:00','',''),(2614002,'5','90','670',270,'Received from bridging 129659',0.00,0.00,14900.00,0.00,0.00,'2022-05-16 08:33:00','',''),(2614003,'5','90','670',270,'Sale Id shift 257630',0.00,0.00,0.00,1530.00,0.00,'2022-05-16 09:18:05','',''),(2614004,'5','90',NULL,270,'Sale Id shift 257630',252450.00,0.00,0.00,0.00,0.00,'2022-05-16 09:18:05','',''),(2614005,'5','90','670',270,'Sale Id shift 257631',0.00,0.00,0.00,4114.21,0.00,'2022-05-17 06:52:58','',''),(2614006,'5','90',NULL,270,'Sale Id shift 257631',678844.65,0.00,0.00,0.00,0.00,'2022-05-17 06:52:58','',''),(2614007,'5','90','670',270,'Sale Id shift 257632',0.00,0.00,0.00,3228.40,0.00,'2022-05-18 07:12:29','',''),(2614008,'5','90','670',270,'Sale Id shift 257632',0.00,0.00,0.00,2638.10,0.00,'2022-05-18 07:12:29','',''),(2614009,'5','90',NULL,270,'Sale Id shift 257632',967972.50,0.00,0.00,0.00,0.00,'2022-05-18 07:12:29','',''),(2614010,'5','90','670',270,'Sale Id shift 257633',0.00,0.00,0.00,3288.69,0.00,'2022-05-19 06:18:05','',''),(2614011,'5','90',NULL,270,'Sale Id shift 257633',542633.85,0.00,0.00,0.00,0.00,'2022-05-19 06:18:05','',''),(2614012,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-05-23 10:06:24','',''),(2614013,'5','90',NULL,270,'Reception corrector for bridging 129660',0.00,0.00,0.00,15000.00,0.00,'2022-05-23 11:31:57','',''),(2614014,'5','90','670',270,'Received from bridging 129660',0.00,0.00,15000.00,0.00,0.00,'2022-05-23 11:31:57','',''),(2614015,'5','90','670',270,'Sale Id shift 257638',0.00,0.00,0.00,3253.00,0.00,'2022-05-24 06:26:38','',''),(2614016,'5','90','670',270,'Sale Id shift 257638',0.00,0.00,0.00,1290.79,0.00,'2022-05-24 06:26:38','',''),(2614017,'5','90',NULL,270,'Sale Id shift 257638',749725.35,0.00,0.00,0.00,0.00,'2022-05-24 06:26:38','',''),(2614018,'5','90','670',270,'Sale Id shift 257639',0.00,0.00,0.00,2342.98,0.00,'2022-05-25 07:29:25','',''),(2614019,'5','90','670',270,'Sale Id shift 257639',0.00,0.00,0.00,2105.70,0.00,'2022-05-25 07:29:25','',''),(2614020,'5','90',NULL,270,'Sale Id shift 257639',734032.20,0.00,0.00,0.00,0.00,'2022-05-25 07:29:25','',''),(2614021,'5','90','670',270,'Sale Id shift 257640',0.00,0.00,0.00,1810.76,0.00,'2022-05-26 05:39:22','',''),(2614022,'5','90','670',270,'Sale Id shift 257640',0.00,0.00,0.00,1999.10,0.00,'2022-05-26 05:39:22','',''),(2614023,'5','90',NULL,270,'Sale Id shift 257640',628626.90,0.00,0.00,0.00,0.00,'2022-05-26 05:39:22','',''),(2614024,'5','90','670',270,'Sale Id shift 257641',0.00,0.00,0.00,2312.02,0.00,'2022-05-27 05:52:05','',''),(2614025,'5','90',NULL,270,'Sale Id shift 257641',381483.30,0.00,0.00,0.00,0.00,'2022-05-27 05:52:05','',''),(2614026,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4752000.00,28800.00,0.00,0.00,'2022-06-19 12:54:21','',''),(2614027,'5','90',NULL,270,'Reception corrector for bridging 129661',0.00,0.00,0.00,28800.00,0.00,'2022-06-19 13:02:39','',''),(2614028,'5','90','670',270,'Received from bridging 129661',0.00,0.00,28800.00,0.00,0.00,'2022-06-19 13:02:39','',''),(2614029,'5','90','670',270,'Sale Id shift 257665',0.00,0.00,0.00,3810.51,0.00,'2022-06-20 06:05:22','',''),(2614030,'5','90','670',270,'Sale Id shift 257665',0.00,0.00,0.00,1264.28,0.00,'2022-06-20 06:05:22','',''),(2614031,'5','90',NULL,270,'Sale Id shift 257665',837340.35,0.00,0.00,0.00,0.00,'2022-06-20 06:05:22','',''),(2614032,'5','90','670',270,'Sale Id shift 257666',0.00,0.00,0.00,1867.06,0.00,'2022-06-21 06:17:21','',''),(2614033,'5','90','670',270,'Sale Id shift 257666',0.00,0.00,0.00,3817.23,0.00,'2022-06-21 06:17:21','',''),(2614034,'5','90',NULL,270,'Sale Id shift 257666',937907.85,0.00,0.00,0.00,0.00,'2022-06-21 06:17:21','',''),(2614035,'5','90','670',270,'Sale Id shift 257667',0.00,0.00,0.00,2655.55,0.00,'2022-06-23 05:33:41','',''),(2614036,'5','90','670',270,'Sale Id shift 257667',0.00,0.00,0.00,1283.93,0.00,'2022-06-23 05:33:41','',''),(2614037,'5','90',NULL,270,'Sale Id shift 257667',650014.20,0.00,0.00,0.00,0.00,'2022-06-23 05:33:41','',''),(2614038,'5','90','670',270,'Sale Id shift 257668',0.00,0.00,0.00,919.74,0.00,'2022-06-23 10:34:50','',''),(2614039,'5','90','670',270,'Sale Id shift 257668',0.00,0.00,0.00,3176.68,0.00,'2022-06-23 10:34:50','',''),(2614040,'5','90',NULL,270,'Sale Id shift 257668',675909.30,0.00,0.00,0.00,0.00,'2022-06-23 10:34:50','',''),(2614041,'5','90','670',270,'Sale Id shift 257669',0.00,0.00,0.00,4664.33,0.00,'2022-06-24 07:01:47','',''),(2614042,'5','90','670',270,'Sale Id shift 257669',0.00,0.00,0.00,2488.08,0.00,'2022-06-24 07:01:47','',''),(2614043,'5','90',NULL,270,'Sale Id shift 257669',1180147.65,0.00,0.00,0.00,0.00,'2022-06-24 07:01:47','',''),(2614044,'5','90','670',270,'Sale Id shift 257670',0.00,0.00,0.00,2146.63,0.00,'2022-06-25 07:52:51','',''),(2614045,'5','90',NULL,270,'Sale Id shift 257670',354193.95,0.00,0.00,0.00,0.00,'2022-06-25 07:52:51','',''),(2614046,'5','90','670',270,'Sale Id shift 257671',0.00,0.00,0.00,1099.14,0.00,'2022-06-26 08:59:53','',''),(2614047,'5','90',NULL,270,'Sale Id shift 257671',181358.10,0.00,0.00,0.00,0.00,'2022-06-26 08:59:53','',''),(2614048,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2475000.00,15000.00,0.00,0.00,'2022-07-08 09:11:03','',''),(2614049,'5','90',NULL,270,'Reception corrector for bridging 129662',0.00,0.00,0.00,15000.00,0.00,'2022-07-08 10:07:44','',''),(2614050,'5','90','670',270,'Received from bridging 129662',0.00,0.00,15000.00,0.00,0.00,'2022-07-08 10:07:44','',''),(2614051,'5','90','670',270,'Sale Id shift 257683',0.00,0.00,0.00,2335.45,0.00,'2022-07-08 10:29:01','',''),(2614052,'5','90',NULL,270,'Sale Id shift 257683',385349.25,0.00,0.00,0.00,0.00,'2022-07-08 10:29:01','',''),(2614053,'5','90','670',270,'Sale Id shift 257684',0.00,0.00,0.00,229.02,0.00,'2022-07-09 10:52:20','',''),(2614054,'5','90','670',270,'Sale Id shift 257684',0.00,0.00,0.00,2995.37,0.00,'2022-07-09 10:52:20','',''),(2614055,'5','90',NULL,270,'Sale Id shift 257684',532024.35,0.00,0.00,0.00,0.00,'2022-07-09 10:52:20','',''),(2614056,'5','90','670',270,'Sale Id shift 257685',0.00,0.00,0.00,4047.57,0.00,'2022-07-09 13:49:27','',''),(2614057,'5','90','670',270,'Sale Id shift 257685',0.00,0.00,0.00,187.64,0.00,'2022-07-09 13:49:27','',''),(2614058,'5','90',NULL,270,'Sale Id shift 257685',698809.65,0.00,0.00,0.00,0.00,'2022-07-09 13:49:27','',''),(2614059,'5','90','670',270,'Sale Id shift 257686',0.00,0.00,0.00,972.58,0.00,'2022-07-10 06:53:11','',''),(2614060,'5','90','670',270,'Sale Id shift 257686',0.00,0.00,0.00,2259.49,0.00,'2022-07-10 06:53:11','',''),(2614061,'5','90',NULL,270,'Sale Id shift 257686',533291.55,0.00,0.00,0.00,0.00,'2022-07-10 06:53:11','',''),(2614062,'5','90','670',270,'Sale Id shift 257687',0.00,0.00,0.00,895.19,0.00,'2022-07-11 07:38:37','',''),(2614063,'5','90','670',270,'Sale Id shift 257687',0.00,0.00,0.00,559.77,0.00,'2022-07-11 07:38:37','',''),(2614064,'5','90',NULL,270,'Sale Id shift 257687',240068.40,0.00,0.00,0.00,0.00,'2022-07-11 07:38:37','',''),(2614065,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-07-15 12:15:57','',''),(2614066,'5','90',NULL,270,'Reception corrector for bridging 129663',0.00,0.00,0.00,30000.00,0.00,'2022-07-15 22:43:02','',''),(2614067,'5','90','670',270,'Received from bridging 129663',0.00,0.00,30000.00,0.00,0.00,'2022-07-15 22:43:02','',''),(2614068,'5','90','670',270,'Sale Id shift 257692',0.00,0.00,0.00,2786.98,0.00,'2022-07-16 08:22:20','',''),(2614069,'5','90','670',270,'Sale Id shift 257692',0.00,0.00,0.00,2249.91,0.00,'2022-07-16 08:22:20','',''),(2614070,'5','90',NULL,270,'Sale Id shift 257692',831086.85,0.00,0.00,0.00,0.00,'2022-07-16 08:22:20','',''),(2614071,'5','90','670',270,'Sale Id shift 257693',0.00,0.00,0.00,3030.27,0.00,'2022-07-17 06:03:49','',''),(2614072,'5','90','670',270,'Sale Id shift 257693',0.00,0.00,0.00,2517.20,0.00,'2022-07-17 06:03:49','',''),(2614073,'5','90',NULL,270,'Sale Id shift 257693',1026281.95,0.00,0.00,0.00,0.00,'2022-07-17 06:03:49','',''),(2614074,'5','90','670',270,'Sale Id shift 257694',0.00,0.00,0.00,3646.67,0.00,'2022-07-18 07:32:44','',''),(2614075,'5','90','670',270,'Sale Id shift 257694',0.00,0.00,0.00,2496.65,0.00,'2022-07-18 07:32:44','',''),(2614076,'5','90',NULL,270,'Sale Id shift 257694',1136514.20,0.00,0.00,0.00,0.00,'2022-07-18 07:32:44','',''),(2614077,'5','90','670',270,'Sale Id shift 257695',0.00,0.00,0.00,2737.10,0.00,'2022-07-19 05:49:41','',''),(2614078,'5','90','670',270,'Sale Id shift 257695',0.00,0.00,0.00,2079.44,0.00,'2022-07-19 05:49:41','',''),(2614079,'5','90',NULL,270,'Sale Id shift 257695',891059.90,0.00,0.00,0.00,0.00,'2022-07-19 05:49:41','',''),(2614080,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,3145000.00,17000.00,0.00,0.00,'2022-07-19 09:36:09','',''),(2614081,'5','90',NULL,270,'Reception corrector for bridging 129664',0.00,0.00,0.00,17000.00,0.00,'2022-07-19 12:00:42','',''),(2614082,'5','90','670',270,'Received from bridging 129664',0.00,0.00,17000.00,0.00,0.00,'2022-07-19 12:00:42','',''),(2614083,'5','90','670',270,'Sale Id shift 257696',0.00,0.00,0.00,5712.63,0.00,'2022-07-20 06:43:10','',''),(2614084,'5','90','670',270,'Sale Id shift 257696',0.00,0.00,0.00,4558.02,0.00,'2022-07-20 06:43:10','',''),(2614085,'5','90',NULL,270,'Sale Id shift 257696',1900070.25,0.00,0.00,0.00,0.00,'2022-07-20 06:43:10','',''),(2614086,'5','90','670',270,'Sale Id shift 257697',0.00,0.00,0.00,1873.03,0.00,'2022-07-21 07:43:50','',''),(2614087,'5','90','670',270,'Sale Id shift 257697',0.00,0.00,0.00,1600.38,0.00,'2022-07-21 07:43:50','',''),(2614088,'5','90',NULL,270,'Sale Id shift 257697',642580.85,0.00,0.00,0.00,0.00,'2022-07-21 07:43:50','',''),(2614089,'5','90','670',270,'Sale Id shift 257698',0.00,0.00,0.00,4052.02,0.00,'2022-07-21 23:19:26','',''),(2614090,'5','90','670',270,'Sale Id shift 257698',0.00,0.00,0.00,3175.66,0.00,'2022-07-21 23:19:26','',''),(2614091,'5','90',NULL,270,'Sale Id shift 257698',1337120.80,0.00,0.00,0.00,0.00,'2022-07-21 23:19:26','',''),(2614092,'5','90','670',270,'Sale Id shift 257699',0.00,0.00,0.00,2321.49,0.00,'2022-07-23 07:28:58','',''),(2614093,'5','90','670',270,'Sale Id shift 257699',0.00,0.00,0.00,2613.98,0.00,'2022-07-23 07:28:58','',''),(2614094,'5','90',NULL,270,'Sale Id shift 257699',913061.95,0.00,0.00,0.00,0.00,'2022-07-23 07:28:58','',''),(2614095,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2682500.00,14500.00,0.00,0.00,'2022-07-23 17:10:12','',''),(2614096,'5','90',NULL,270,'Reception corrector for bridging 129665',0.00,0.00,0.00,14500.00,0.00,'2022-07-23 18:42:55','',''),(2614097,'5','90','670',270,'Received from bridging 129665',0.00,0.00,14500.00,0.00,0.00,'2022-07-23 18:42:55','',''),(2614098,'5','90','670',270,'Sale Id shift 257700',0.00,0.00,0.00,2077.95,0.00,'2022-07-24 06:56:01','',''),(2614099,'5','90','670',270,'Sale Id shift 257700',0.00,0.00,0.00,2007.15,0.00,'2022-07-24 06:56:01','',''),(2614100,'5','90',NULL,270,'Sale Id shift 257700',755743.50,0.00,0.00,0.00,0.00,'2022-07-24 06:56:01','',''),(2614101,'5','90','670',270,'Sale Id shift 257701',0.00,0.00,0.00,3043.07,0.00,'2022-07-25 06:41:07','',''),(2614102,'5','90','670',270,'Sale Id shift 257701',0.00,0.00,0.00,2198.51,0.00,'2022-07-25 06:41:07','',''),(2614103,'5','90',NULL,270,'Sale Id shift 257701',969692.30,0.00,0.00,0.00,0.00,'2022-07-25 06:41:07','',''),(2614104,'5','90','670',270,'Sale Id shift 257702',0.00,0.00,0.00,2234.30,0.00,'2022-07-26 07:40:28','',''),(2614105,'5','90','670',270,'Sale Id shift 257702',0.00,0.00,0.00,2021.72,0.00,'2022-07-26 07:40:28','',''),(2614106,'5','90',NULL,270,'Sale Id shift 257702',787363.70,0.00,0.00,0.00,0.00,'2022-07-26 07:40:28','',''),(2614107,'5','90','670',270,'Sale Id shift 257703',0.00,0.00,0.00,756.83,0.00,'2022-07-27 06:54:46','',''),(2614108,'5','90',NULL,270,'Sale Id shift 257703',140013.55,0.00,0.00,0.00,0.00,'2022-07-27 06:54:46','',''),(2614109,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2775000.00,15000.00,0.00,0.00,'2022-08-02 10:16:30','',''),(2614110,'5','90',NULL,270,'Reception corrector for bridging 129666',0.00,0.00,0.00,15000.00,0.00,'2022-08-02 10:52:33','',''),(2614111,'5','90','670',270,'Received from bridging 129666',0.00,0.00,15000.00,0.00,0.00,'2022-08-02 10:52:33','',''),(2614112,'5','90','670',270,'Sale Id shift 257710',0.00,0.00,0.00,1627.05,0.00,'2022-08-03 06:36:00','',''),(2614113,'5','90','670',270,'Sale Id shift 257710',0.00,0.00,0.00,1614.06,0.00,'2022-08-03 06:36:00','',''),(2614114,'5','90',NULL,270,'Sale Id shift 257710',599605.35,0.00,0.00,0.00,0.00,'2022-08-03 06:36:00','',''),(2614115,'5','90','670',270,'Sale Id shift 257711',0.00,0.00,0.00,1951.28,0.00,'2022-08-04 06:49:34','',''),(2614116,'5','90','670',270,'Sale Id shift 257711',0.00,0.00,0.00,1069.39,0.00,'2022-08-04 06:49:34','',''),(2614117,'5','90',NULL,270,'Sale Id shift 257711',558823.95,0.00,0.00,0.00,0.00,'2022-08-04 06:49:34','',''),(2614118,'5','90','670',270,'Sale Id shift 257712',0.00,0.00,0.00,3151.07,0.00,'2022-08-05 06:36:47','',''),(2614119,'5','90','670',270,'Sale Id shift 257712',0.00,0.00,0.00,819.74,0.00,'2022-08-05 06:36:47','',''),(2614120,'5','90',NULL,270,'Sale Id shift 257712',734599.85,0.00,0.00,0.00,0.00,'2022-08-05 06:36:47','',''),(2614121,'5','90','670',270,'Sale Id shift 257713',0.00,0.00,0.00,2950.75,0.00,'2022-08-06 09:10:06','',''),(2614122,'5','90',NULL,270,'Sale Id shift 257713',545888.75,0.00,0.00,0.00,0.00,'2022-08-06 09:10:06','',''),(2614123,'5','90','670',270,'Sale Id shift 257714',0.00,0.00,0.00,420.44,0.00,'2022-08-07 07:11:49','',''),(2614124,'5','90','670',270,'Sale Id shift 257714',0.00,0.00,0.00,1362.98,0.00,'2022-08-07 07:11:49','',''),(2614125,'5','90',NULL,270,'Sale Id shift 257714',329932.70,0.00,0.00,0.00,0.00,'2022-08-07 07:11:49','',''),(2614126,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2775000.00,15000.00,0.00,0.00,'2022-09-05 11:55:31','',''),(2614127,'5','90',NULL,270,'Reception corrector for bridging 129667',0.00,0.00,0.00,15000.00,0.00,'2022-09-05 12:28:11','',''),(2614128,'5','90','670',270,'Received from bridging 129667',0.00,0.00,15000.00,0.00,0.00,'2022-09-05 12:28:11','',''),(2614129,'5','90','670',270,'Sale Id shift 257721',0.00,0.00,0.00,2390.37,0.00,'2022-09-05 12:51:34','',''),(2614130,'5','90','670',270,'Sale Id shift 257721',0.00,0.00,0.00,1776.70,0.00,'2022-09-05 12:51:34','',''),(2614131,'5','90',NULL,270,'Sale Id shift 257721',770907.95,0.00,0.00,0.00,0.00,'2022-09-05 12:51:34','',''),(2614132,'5','90','670',270,'Sale Id shift 257722',0.00,0.00,0.00,3778.51,0.00,'2022-09-05 13:39:15','',''),(2614133,'5','90','670',270,'Sale Id shift 257722',0.00,0.00,0.00,306.27,0.00,'2022-09-05 13:39:15','',''),(2614134,'5','90',NULL,270,'Sale Id shift 257722',755684.30,0.00,0.00,0.00,0.00,'2022-09-05 13:39:15','',''),(2614135,'5','90','670',270,'Sale Id shift 257723',0.00,0.00,0.00,1551.43,0.00,'2022-09-05 13:43:28','',''),(2614136,'5','90','670',270,'Sale Id shift 257723',0.00,0.00,0.00,896.08,0.00,'2022-09-05 13:43:28','',''),(2614137,'5','90',NULL,270,'Sale Id shift 257723',452789.35,0.00,0.00,0.00,0.00,'2022-09-05 13:43:28','',''),(2614138,'5','90','670',270,'Sale Id shift 257724',0.00,0.00,0.00,1950.60,0.00,'2022-09-05 13:47:06','',''),(2614139,'5','90','670',270,'Sale Id shift 257724',0.00,0.00,0.00,167.91,0.00,'2022-09-05 13:47:06','',''),(2614140,'5','90',NULL,270,'Sale Id shift 257724',391924.35,0.00,0.00,0.00,0.00,'2022-09-05 13:47:06','',''),(2614141,'5','90','670',270,'Sale Id shift 257725',0.00,0.00,0.00,1156.66,0.00,'2022-09-05 13:49:59','',''),(2614142,'5','90','670',270,'Sale Id shift 257725',0.00,0.00,0.00,1031.09,0.00,'2022-09-05 13:49:59','',''),(2614143,'5','90',NULL,270,'Sale Id shift 257725',404733.75,0.00,0.00,0.00,0.00,'2022-09-05 13:49:59','',''),(2614144,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4162500.00,22500.00,0.00,0.00,'2022-09-05 14:01:24','',''),(2614145,'5','90',NULL,270,'Reception corrector for bridging 129668',0.00,0.00,0.00,22500.00,0.00,'2022-09-05 14:43:17','',''),(2614146,'5','90','670',270,'Received from bridging 129668',0.00,0.00,22500.00,0.00,0.00,'2022-09-05 14:43:17','',''),(2614147,'5','90','670',270,'Sale Id shift 257726',0.00,0.00,0.00,1155.06,0.00,'2022-09-05 14:47:40','',''),(2614148,'5','90','670',270,'Sale Id shift 257726',0.00,0.00,0.00,480.60,0.00,'2022-09-05 14:47:40','',''),(2614149,'5','90',NULL,270,'Sale Id shift 257726',302597.10,0.00,0.00,0.00,0.00,'2022-09-05 14:47:40','',''),(2614150,'5','90','670',270,'Sale Id shift 257727',0.00,0.00,0.00,1191.59,0.00,'2022-09-05 14:51:31','',''),(2614151,'5','90','670',270,'Sale Id shift 257727',0.00,0.00,0.00,1213.28,0.00,'2022-09-05 14:51:31','',''),(2614152,'5','90',NULL,270,'Sale Id shift 257727',444900.95,0.00,0.00,0.00,0.00,'2022-09-05 14:51:31','',''),(2614153,'5','90','670',270,'Sale Id shift 257728',0.00,0.00,0.00,3198.79,0.00,'2022-09-05 14:57:01','',''),(2614154,'5','90','670',270,'Sale Id shift 257728',0.00,0.00,0.00,3039.04,0.00,'2022-09-05 14:57:01','',''),(2614155,'5','90',NULL,270,'Sale Id shift 257728',1153998.55,0.00,0.00,0.00,0.00,'2022-09-05 14:57:01','',''),(2614156,'5','90','670',270,'Sale Id shift 257729',0.00,0.00,0.00,1972.44,0.00,'2022-09-05 15:32:31','',''),(2614157,'5','90','670',270,'Sale Id shift 257729',0.00,0.00,0.00,901.77,0.00,'2022-09-05 15:32:31','',''),(2614158,'5','90',NULL,270,'Sale Id shift 257729',531728.85,0.00,0.00,0.00,0.00,'2022-09-05 15:32:31','',''),(2614159,'5','90','670',270,'Sale Id shift 257730',0.00,0.00,0.00,1219.85,0.00,'2022-09-05 15:39:04','',''),(2614160,'5','90','670',270,'Sale Id shift 257730',0.00,0.00,0.00,2024.62,0.00,'2022-09-05 15:39:04','',''),(2614161,'5','90',NULL,270,'Sale Id shift 257730',600226.95,0.00,0.00,0.00,0.00,'2022-09-05 15:39:04','',''),(2614162,'5','90','670',270,'Sale Id shift 257731',0.00,0.00,0.00,1855.07,0.00,'2022-09-05 15:42:26','',''),(2614163,'5','90','670',270,'Sale Id shift 257731',0.00,0.00,0.00,1208.73,0.00,'2022-09-05 15:42:26','',''),(2614164,'5','90',NULL,270,'Sale Id shift 257731',566803.00,0.00,0.00,0.00,0.00,'2022-09-05 15:42:26','',''),(2614165,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7400000.00,40000.00,0.00,0.00,'2022-09-05 15:50:40','',''),(2614166,'5','90',NULL,270,'Reception corrector for bridging 129670',0.00,0.00,0.00,28000.00,0.00,'2022-09-06 09:40:46','',''),(2614167,'5','90','670',270,'Received from bridging 129670',0.00,0.00,28000.00,0.00,0.00,'2022-09-06 09:40:46','',''),(2614168,'5','90',NULL,270,'Reception corrector for bridging 129669',0.00,0.00,0.00,12000.00,0.00,'2022-09-06 09:40:54','',''),(2614169,'5','90','669',270,'Received from bridging 129669',0.00,0.00,12000.00,0.00,0.00,'2022-09-06 09:40:54','',''),(2614170,'5','90','669',270,'Sale Id shift 257732',0.00,0.00,0.00,32.63,0.00,'2022-09-06 10:39:06','',''),(2614171,'5','90','670',270,'Sale Id shift 257732',0.00,0.00,0.00,2434.39,0.00,'2022-09-06 10:39:06','',''),(2614172,'5','90','670',270,'Sale Id shift 257732',0.00,0.00,0.00,1888.49,0.00,'2022-09-06 10:39:06','',''),(2614173,'5','90',NULL,270,'Sale Id shift 257732',805769.35,0.00,0.00,0.00,0.00,'2022-09-06 10:39:06','',''),(2614174,'5','90','670',270,'Sale Id shift 257733',0.00,0.00,0.00,2712.28,0.00,'2022-09-06 10:56:41','',''),(2614175,'5','90','670',270,'Sale Id shift 257733',0.00,0.00,0.00,1686.60,0.00,'2022-09-06 10:56:41','',''),(2614176,'5','90',NULL,270,'Sale Id shift 257733',813792.80,0.00,0.00,0.00,0.00,'2022-09-06 10:56:41','',''),(2614177,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,11100000.00,60000.00,0.00,0.00,'2022-09-06 10:57:18','',''),(2614178,'5','90',NULL,270,'Reception corrector for bridging 129672',0.00,0.00,0.00,30000.00,0.00,'2022-09-06 11:12:45','',''),(2614179,'5','90','669',270,'Received from bridging 129672',0.00,0.00,30000.00,0.00,0.00,'2022-09-06 11:12:45','',''),(2614180,'5','90',NULL,270,'Reception corrector for bridging 129671',0.00,0.00,0.00,30000.00,0.00,'2022-09-06 11:12:55','',''),(2614181,'5','90','668',270,'Received from bridging 129671',0.00,0.00,30000.00,0.00,0.00,'2022-09-06 11:12:55','',''),(2614182,'5','90','670',270,'Sale Id shift 257734',0.00,0.00,0.00,2741.01,0.00,'2022-09-06 11:13:00','',''),(2614183,'5','90','670',270,'Sale Id shift 257734',0.00,0.00,0.00,2131.11,0.00,'2022-09-06 11:13:00','',''),(2614184,'5','90',NULL,270,'Sale Id shift 257734',901342.20,0.00,0.00,0.00,0.00,'2022-09-06 11:13:00','',''),(2614185,'5','90','669',270,'Sale Id shift 257735',0.00,0.00,0.00,0.13,0.00,'2022-09-06 11:26:18','',''),(2614186,'5','90','668',270,'Sale Id shift 257735',0.00,0.00,0.00,3.34,0.00,'2022-09-06 11:26:18','',''),(2614187,'5','90','669',270,'Sale Id shift 257735',0.00,0.00,0.00,8.70,0.00,'2022-09-06 11:26:18','',''),(2614188,'5','90','670',270,'Sale Id shift 257735',0.00,0.00,0.00,3968.42,0.00,'2022-09-06 11:26:18','',''),(2614189,'5','90','670',270,'Sale Id shift 257735',0.00,0.00,0.00,2953.02,0.00,'2022-09-06 11:26:18','',''),(2614190,'5','90',NULL,270,'Sale Id shift 257735',1282717.85,0.00,0.00,0.00,0.00,'2022-09-06 11:26:18','',''),(2614191,'5','90','670',270,'Sale Id shift 257736',0.00,0.00,0.00,1933.08,0.00,'2022-09-06 11:33:24','',''),(2614192,'5','90','670',270,'Sale Id shift 257736',0.00,0.00,0.00,1622.74,0.00,'2022-09-06 11:33:24','',''),(2614193,'5','90',NULL,270,'Sale Id shift 257736',657826.70,0.00,0.00,0.00,0.00,'2022-09-06 11:33:24','',''),(2614194,'5','90','670',270,'Sale Id shift 257737',0.00,0.00,0.00,2046.60,0.00,'2022-09-06 11:36:52','',''),(2614195,'5','90','670',270,'Sale Id shift 257737',0.00,0.00,0.00,2189.11,0.00,'2022-09-06 11:36:52','',''),(2614196,'5','90',NULL,270,'Sale Id shift 257737',783606.35,0.00,0.00,0.00,0.00,'2022-09-06 11:36:52','',''),(2614197,'5','90','668',270,'Sale Id shift 257738',0.00,0.00,0.00,456.07,0.00,'2022-09-06 11:42:31','',''),(2614198,'5','90','669',270,'Sale Id shift 257738',0.00,0.00,0.00,143.73,0.00,'2022-09-06 11:42:31','',''),(2614199,'5','90','670',270,'Sale Id shift 257738',0.00,0.00,0.00,1239.86,0.00,'2022-09-06 11:42:31','',''),(2614200,'5','90','670',270,'Sale Id shift 257738',0.00,0.00,0.00,1006.29,0.00,'2022-09-06 11:42:31','',''),(2614201,'5','90',NULL,270,'Sale Id shift 257738',526500.75,0.00,0.00,0.00,0.00,'2022-09-06 11:42:31','',''),(2614202,'5','90','668',270,'Sale Id shift 257740',0.00,0.00,0.00,1815.29,0.00,'2022-09-06 12:09:20','',''),(2614203,'5','90','669',270,'Sale Id shift 257740',0.00,0.00,0.00,542.75,0.00,'2022-09-06 12:09:20','',''),(2614204,'5','90',NULL,270,'Sale Id shift 257740',436237.40,0.00,0.00,0.00,0.00,'2022-09-06 12:09:20','',''),(2614205,'5','90','668',270,'Sale Id shift 257741',0.00,0.00,0.00,3639.06,0.00,'2022-09-06 12:16:36','',''),(2614206,'5','90',NULL,270,'Sale Id shift 257741',673226.10,0.00,0.00,0.00,0.00,'2022-09-06 12:16:36','',''),(2614207,'5','90','669',270,'Sale Id shift 257742',0.00,0.00,0.00,1944.58,0.00,'2022-09-06 13:07:14','',''),(2614208,'5','90','668',270,'Sale Id shift 257742',0.00,0.00,0.00,4172.23,0.00,'2022-09-06 13:07:14','',''),(2614209,'5','90','669',270,'Sale Id shift 257742',0.00,0.00,0.00,90.33,0.00,'2022-09-06 13:07:14','',''),(2614210,'5','90',NULL,270,'Sale Id shift 257742',1148320.90,0.00,0.00,0.00,0.00,'2022-09-06 13:07:14','',''),(2614211,'5','90','669',270,'Sale Id shift 257743',0.00,0.00,0.00,1816.40,0.00,'2022-09-06 13:31:56','',''),(2614212,'5','90','668',270,'Sale Id shift 257743',0.00,0.00,0.00,1758.50,0.00,'2022-09-06 13:31:56','',''),(2614213,'5','90',NULL,270,'Sale Id shift 257743',661356.50,0.00,0.00,0.00,0.00,'2022-09-06 13:31:56','',''),(2614214,'5','90','669',270,'Sale Id shift 257744',0.00,0.00,0.00,1582.54,0.00,'2022-09-06 13:35:41','',''),(2614215,'5','90','668',270,'Sale Id shift 257744',0.00,0.00,0.00,1563.33,0.00,'2022-09-06 13:35:41','',''),(2614216,'5','90',NULL,270,'Sale Id shift 257744',581985.95,0.00,0.00,0.00,0.00,'2022-09-06 13:35:41','',''),(2614217,'5','90','669',270,'Sale Id shift 257745',0.00,0.00,0.00,1370.16,0.00,'2022-09-06 13:38:47','',''),(2614218,'5','90','668',270,'Sale Id shift 257745',0.00,0.00,0.00,2068.16,0.00,'2022-09-06 13:38:47','',''),(2614219,'5','90',NULL,270,'Sale Id shift 257745',636089.20,0.00,0.00,0.00,0.00,'2022-09-06 13:38:47','',''),(2614220,'5','90','669',270,'Sale Id shift 257746',0.00,0.00,0.00,1924.80,0.00,'2022-09-06 13:43:59','',''),(2614221,'5','90','668',270,'Sale Id shift 257746',0.00,0.00,0.00,1968.44,0.00,'2022-09-06 13:43:59','',''),(2614222,'5','90',NULL,270,'Sale Id shift 257746',720249.40,0.00,0.00,0.00,0.00,'2022-09-06 13:43:59','',''),(2614223,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,4486250.00,24250.00,0.00,0.00,'2022-09-06 13:46:19','',''),(2614224,'5','90',NULL,270,'Reception corrector for bridging 129673',0.00,0.00,0.00,24250.00,0.00,'2022-09-06 13:52:42','',''),(2614225,'5','90','670',270,'Received from bridging 129673',0.00,0.00,24250.00,0.00,0.00,'2022-09-06 13:52:42','',''),(2614226,'5','90','669',270,'Sale Id shift 257747',0.00,0.00,0.00,569.56,0.00,'2022-09-07 09:40:54','',''),(2614227,'5','90','668',270,'Sale Id shift 257747',0.00,0.00,0.00,1684.83,0.00,'2022-09-07 09:40:54','',''),(2614228,'5','90','670',270,'Sale Id shift 257747',0.00,0.00,0.00,1265.41,0.00,'2022-09-07 09:40:54','',''),(2614229,'5','90',NULL,270,'Sale Id shift 257747',651163.00,0.00,0.00,0.00,0.00,'2022-09-07 09:40:54','',''),(2614230,'5','90','668',270,'Sale Id shift 257748',0.00,0.00,0.00,1674.48,0.00,'2022-09-08 09:02:33','',''),(2614231,'5','90','670',270,'Sale Id shift 257748',0.00,0.00,0.00,1940.70,0.00,'2022-09-08 09:02:33','',''),(2614232,'5','90',NULL,270,'Sale Id shift 257748',668808.30,0.00,0.00,0.00,0.00,'2022-09-08 09:02:33','',''),(2614233,'5','90','668',270,'Sale Id shift 257749',0.00,0.00,0.00,3265.97,0.00,'2022-09-09 07:14:48','',''),(2614234,'5','90','670',270,'Sale Id shift 257749',0.00,0.00,0.00,2734.71,0.00,'2022-09-09 07:14:48','',''),(2614235,'5','90','670',270,'Sale Id shift 257749',0.00,0.00,0.00,2546.62,0.00,'2022-09-09 07:14:48','',''),(2614236,'5','90',NULL,270,'Sale Id shift 257749',1581250.50,0.00,0.00,0.00,0.00,'2022-09-09 07:14:48','',''),(2614237,'5','90','668',270,'Sale Id shift 257750',0.00,0.00,0.00,1883.30,0.00,'2022-09-10 10:16:44','',''),(2614238,'5','90','670',270,'Sale Id shift 257750',0.00,0.00,0.00,1884.03,0.00,'2022-09-10 10:16:44','',''),(2614239,'5','90',NULL,270,'Sale Id shift 257750',696956.05,0.00,0.00,0.00,0.00,'2022-09-10 10:16:44','',''),(2614240,'5','90','668',270,'Sale Id shift 257754',0.00,0.00,0.00,1422.90,0.00,'2022-09-11 11:03:53','',''),(2614241,'5','90','670',270,'Sale Id shift 257754',0.00,0.00,0.00,1727.42,0.00,'2022-09-11 11:03:53','',''),(2614242,'5','90',NULL,270,'Sale Id shift 257754',582809.20,0.00,0.00,0.00,0.00,'2022-09-11 11:03:53','',''),(2614243,'5','90','668',270,'Sale Id shift 257756',0.00,0.00,0.00,1623.46,0.00,'2022-09-12 15:20:09','',''),(2614244,'5','90','670',270,'Sale Id shift 257756',0.00,0.00,0.00,2490.98,0.00,'2022-09-12 15:20:09','',''),(2614245,'5','90',NULL,270,'Sale Id shift 257756',761171.40,0.00,0.00,0.00,0.00,'2022-09-12 15:20:09','',''),(2614246,'5','90','670',0,'Tank level zero out for dipping',0.00,0.00,0.00,10752.78,0.00,'2022-09-13 11:01:26','',''),(2614247,'5','90','670',0,'Inventory adjustment from tank dipping to 7550',0.00,0.00,7550.00,0.00,0.00,'2022-09-13 11:01:26','',''),(2614248,'5','90','669',0,'Tank level zero out for dipping',0.00,0.00,0.00,32488.98,0.00,'2022-09-13 11:01:58','',''),(2614249,'5','90','669',0,'Inventory adjustment from tank dipping to 31600',0.00,0.00,31600.00,0.00,0.00,'2022-09-13 11:01:58','',''),(2614250,'5','90','671',0,'Tank level zero out for dipping',0.00,0.00,0.00,500.00,0.00,'2022-09-13 11:03:34','',''),(2614251,'5','90','671',0,'Inventory adjustment from tank dipping to 4500',0.00,0.00,4500.00,0.00,0.00,'2022-09-13 11:03:34','',''),(2614252,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,1300.64,0.00,'2022-09-13 11:33:03','',''),(2614253,'5','90','668',0,'Inventory adjustment from tank dipping to 2000',0.00,0.00,2000.00,0.00,0.00,'2022-09-13 11:33:03','',''),(2614254,'5','90','669',0,'Tank level zero out for dipping',0.00,0.00,0.00,31600.00,0.00,'2022-09-13 11:33:26','',''),(2614255,'5','90','669',0,'Inventory adjustment from tank dipping to 31600',0.00,0.00,31600.00,0.00,0.00,'2022-09-13 11:33:26','',''),(2614256,'5','90','670',0,'Tank level zero out for dipping',0.00,0.00,0.00,7550.00,0.00,'2022-09-13 11:34:25','',''),(2614257,'5','90','670',0,'Inventory adjustment from tank dipping to 10050',0.00,0.00,10050.00,0.00,0.00,'2022-09-13 11:34:25','',''),(2614258,'5','90','669',270,'Sale Id shift 257757',0.00,0.00,0.00,67.19,0.00,'2022-09-13 11:42:52','',''),(2614259,'5','90','668',270,'Sale Id shift 257757',0.00,0.00,0.00,1702.97,0.00,'2022-09-13 11:42:52','',''),(2614260,'5','90','670',270,'Sale Id shift 257757',0.00,0.00,0.00,2596.00,0.00,'2022-09-13 11:42:52','',''),(2614261,'5','90','670',270,'Sale Id shift 257757',0.00,0.00,0.00,379.05,0.00,'2022-09-13 11:42:52','',''),(2614262,'5','90',NULL,270,'Sale Id shift 257757',877863.85,0.00,0.00,0.00,0.00,'2022-09-13 11:42:52','',''),(2614263,'5','90','669',270,'Sale Id shift 257758',0.00,0.00,0.00,1988.14,0.00,'2022-09-14 09:15:42','',''),(2614264,'5','90','670',270,'Sale Id shift 257758',0.00,0.00,0.00,2121.89,0.00,'2022-09-14 09:15:42','',''),(2614265,'5','90',NULL,270,'Sale Id shift 257758',760355.55,0.00,0.00,0.00,0.00,'2022-09-14 09:15:42','',''),(2614266,'5','90','669',270,'Sale Id shift 257759',0.00,0.00,0.00,2538.95,0.00,'2022-09-15 10:05:28','',''),(2614267,'5','90','670',270,'Sale Id shift 257759',0.00,0.00,0.00,2496.62,0.00,'2022-09-15 10:05:28','',''),(2614268,'5','90',NULL,270,'Sale Id shift 257759',931580.45,0.00,0.00,0.00,0.00,'2022-09-15 10:05:28','',''),(2614269,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5494500.00,29700.00,0.00,0.00,'2022-09-16 06:59:52','',''),(2614270,'5','90',NULL,270,'Reception corrector for bridging 129674',0.00,0.00,0.00,29700.00,0.00,'2022-09-16 08:05:16','',''),(2614271,'5','90','670',270,'Received from bridging 129674',0.00,0.00,29700.00,0.00,0.00,'2022-09-16 08:05:16','',''),(2614272,'5','90','669',270,'Sale Id shift 257760',0.00,0.00,0.00,3518.41,0.00,'2022-09-16 11:01:48','',''),(2614273,'5','90','670',270,'Sale Id shift 257760',0.00,0.00,0.00,2699.20,0.00,'2022-09-16 11:01:48','',''),(2614274,'5','90','670',270,'Sale Id shift 257760',0.00,0.00,0.00,2425.46,0.00,'2022-09-16 11:01:48','',''),(2614275,'5','90',NULL,270,'Sale Id shift 257760',1598967.95,0.00,0.00,0.00,0.00,'2022-09-16 11:01:48','',''),(2614276,'5','90','669',270,'Sale Id shift 257761',0.00,0.00,0.00,1888.00,0.00,'2022-09-17 07:55:07','',''),(2614277,'5','90','670',270,'Sale Id shift 257761',0.00,0.00,0.00,2260.56,0.00,'2022-09-17 07:55:07','',''),(2614278,'5','90',NULL,270,'Sale Id shift 257761',767483.60,0.00,0.00,0.00,0.00,'2022-09-17 07:55:07','',''),(2614279,'5','90','669',270,'Sale Id shift 257762',0.00,0.00,0.00,1722.80,0.00,'2022-09-18 10:36:13','',''),(2614280,'5','90','670',270,'Sale Id shift 257762',0.00,0.00,0.00,1705.70,0.00,'2022-09-18 10:36:13','',''),(2614281,'5','90',NULL,270,'Sale Id shift 257762',634272.50,0.00,0.00,0.00,0.00,'2022-09-18 10:36:13','',''),(2614282,'5','90','669',270,'Sale Id shift 257763',0.00,0.00,0.00,1810.28,0.00,'2022-09-19 10:42:54','',''),(2614283,'5','90','670',270,'Sale Id shift 257763',0.00,0.00,0.00,2064.89,0.00,'2022-09-19 10:42:54','',''),(2614284,'5','90',NULL,270,'Sale Id shift 257763',716906.45,0.00,0.00,0.00,0.00,'2022-09-19 10:42:54','',''),(2614285,'5','90','669',270,'Sale Id shift 257764',0.00,0.00,0.00,5.94,0.00,'2022-09-20 08:58:58','',''),(2614286,'5','90','670',270,'Sale Id shift 257764',0.00,0.00,0.00,2617.06,0.00,'2022-09-20 08:58:58','',''),(2614287,'5','90','670',270,'Sale Id shift 257764',0.00,0.00,0.00,1480.97,0.00,'2022-09-20 08:58:58','',''),(2614288,'5','90',NULL,270,'Sale Id shift 257764',759234.45,0.00,0.00,0.00,0.00,'2022-09-20 08:58:58','',''),(2614289,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,2756500.00,14900.00,0.00,0.00,'2022-09-20 18:33:59','',''),(2614290,'5','90',NULL,270,'Reception corrector for bridging 129675',0.00,0.00,0.00,14900.00,0.00,'2022-09-20 20:26:45','',''),(2614291,'5','90','668',270,'Received from bridging 129675',0.00,0.00,14900.00,0.00,0.00,'2022-09-20 20:26:45','',''),(2614292,'5','90','670',270,'Sale Id shift 257765',0.00,0.00,0.00,2398.08,0.00,'2022-09-21 07:07:19','',''),(2614293,'5','90','670',270,'Sale Id shift 257765',0.00,0.00,0.00,2086.12,0.00,'2022-09-21 07:07:19','',''),(2614294,'5','90',NULL,270,'Sale Id shift 257765',829577.00,0.00,0.00,0.00,0.00,'2022-09-21 07:07:19','',''),(2614295,'5','90','670',270,'Sale Id shift 257766',0.00,0.00,0.00,2250.51,0.00,'2022-09-22 09:14:44','',''),(2614296,'5','90','670',270,'Sale Id shift 257766',0.00,0.00,0.00,2328.12,0.00,'2022-09-22 09:14:44','',''),(2614297,'5','90',NULL,270,'Sale Id shift 257766',847046.55,0.00,0.00,0.00,0.00,'2022-09-22 09:14:44','',''),(2614298,'5','90','668',270,'Sale Id shift 257767',0.00,0.00,0.00,3020.61,0.00,'2022-09-23 10:18:09','',''),(2614299,'5','90','670',270,'Sale Id shift 257767',0.00,0.00,0.00,3037.63,0.00,'2022-09-23 10:18:09','',''),(2614300,'5','90','670',270,'Sale Id shift 257767',0.00,0.00,0.00,3102.84,0.00,'2022-09-23 10:18:09','',''),(2614301,'5','90',NULL,270,'Sale Id shift 257767',1694799.80,0.00,0.00,0.00,0.00,'2022-09-23 10:18:09','',''),(2614302,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8251000.00,44600.00,0.00,0.00,'2022-09-25 23:08:48','',''),(2614303,'5','90',NULL,270,'Reception corrector for bridging 129677',0.00,0.00,0.00,30000.00,0.00,'2022-09-26 09:09:10','',''),(2614304,'5','90','670',270,'Received from bridging 129677',0.00,0.00,30000.00,0.00,0.00,'2022-09-26 09:09:10','',''),(2614305,'5','90',NULL,270,'Reception corrector for bridging 129676',0.00,0.00,0.00,14600.00,0.00,'2022-09-26 09:09:21','',''),(2614306,'5','90','668',270,'Received from bridging 129676',0.00,0.00,14600.00,0.00,0.00,'2022-09-26 09:09:21','',''),(2614307,'5','90','669',270,'Sale Id shift 257768',0.00,0.00,0.00,963.42,0.00,'2022-09-26 10:29:46','',''),(2614308,'5','90','668',270,'Sale Id shift 257768',0.00,0.00,0.00,1009.43,0.00,'2022-09-26 10:29:46','',''),(2614309,'5','90','670',270,'Sale Id shift 257768',0.00,0.00,0.00,1146.19,0.00,'2022-09-26 10:29:46','',''),(2614310,'5','90','670',270,'Sale Id shift 257768',0.00,0.00,0.00,640.37,0.00,'2022-09-26 10:29:46','',''),(2614311,'5','90',NULL,270,'Sale Id shift 257768',695490.85,0.00,0.00,0.00,0.00,'2022-09-26 10:29:46','',''),(2614312,'5','90','669',270,'Sale Id shift 257769',0.00,0.00,0.00,2419.43,0.00,'2022-09-26 10:38:46','',''),(2614313,'5','90','668',270,'Sale Id shift 257769',0.00,0.00,0.00,1297.48,0.00,'2022-09-26 10:38:46','',''),(2614314,'5','90',NULL,270,'Sale Id shift 257769',687628.35,0.00,0.00,0.00,0.00,'2022-09-26 10:38:46','',''),(2614315,'5','90','669',270,'Sale Id shift 257770',0.00,0.00,0.00,1628.56,0.00,'2022-09-26 10:45:48','',''),(2614316,'5','90','668',270,'Sale Id shift 257770',0.00,0.00,0.00,2450.11,0.00,'2022-09-26 10:45:48','',''),(2614317,'5','90',NULL,270,'Sale Id shift 257770',754553.95,0.00,0.00,0.00,0.00,'2022-09-26 10:45:48','',''),(2614318,'5','90','669',270,'Sale Id shift 257771',0.00,0.00,0.00,2092.59,0.00,'2022-09-27 08:08:30','',''),(2614319,'5','90','668',270,'Sale Id shift 257771',0.00,0.00,0.00,2253.83,0.00,'2022-09-27 08:08:30','',''),(2614320,'5','90',NULL,270,'Sale Id shift 257771',804087.70,0.00,0.00,0.00,0.00,'2022-09-27 08:08:30','',''),(2614321,'5','90','669',270,'Sale Id shift 257772',0.00,0.00,0.00,2047.90,0.00,'2022-09-28 06:39:33','',''),(2614322,'5','90','668',270,'Sale Id shift 257772',0.00,0.00,0.00,2307.48,0.00,'2022-09-28 06:39:33','',''),(2614323,'5','90',NULL,270,'Sale Id shift 257772',805745.30,0.00,0.00,0.00,0.00,'2022-09-28 06:39:33','',''),(2614324,'5','90','669',270,'Sale Id shift 257773',0.00,0.00,0.00,2361.42,0.00,'2022-09-29 07:11:35','',''),(2614325,'5','90','668',270,'Sale Id shift 257773',0.00,0.00,0.00,2168.49,0.00,'2022-09-29 07:11:35','',''),(2614326,'5','90',NULL,270,'Sale Id shift 257773',838033.35,0.00,0.00,0.00,0.00,'2022-09-29 07:11:35','',''),(2614327,'5','90','668',270,'Sale Id shift 257774',0.00,0.00,0.00,3161.02,0.00,'2022-09-30 07:21:46','',''),(2614328,'5','90','670',270,'Sale Id shift 257774',0.00,0.00,0.00,3554.04,0.00,'2022-09-30 07:21:46','',''),(2614329,'5','90','670',270,'Sale Id shift 257774',0.00,0.00,0.00,2830.80,0.00,'2022-09-30 07:21:46','',''),(2614330,'5','90',NULL,270,'Sale Id shift 257774',1765984.10,0.00,0.00,0.00,0.00,'2022-09-30 07:21:46','',''),(2614331,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,8325000.00,45000.00,0.00,0.00,'2022-10-01 07:29:38','',''),(2614332,'5','90','668',270,'Sale Id shift 257775',0.00,0.00,0.00,1465.98,0.00,'2022-10-01 07:30:02','',''),(2614333,'5','90','670',270,'Sale Id shift 257775',0.00,0.00,0.00,2005.70,0.00,'2022-10-01 07:30:02','',''),(2614334,'5','90','670',270,'Sale Id shift 257775',0.00,0.00,0.00,627.55,0.00,'2022-10-01 07:30:02','',''),(2614335,'5','90',NULL,270,'Sale Id shift 257775',758357.55,0.00,0.00,0.00,0.00,'2022-10-01 07:30:02','',''),(2614336,'5','90','668',270,'Sale Id shift 257776',0.00,0.00,0.00,2089.36,0.00,'2022-10-02 06:56:29','',''),(2614337,'5','90','670',270,'Sale Id shift 257776',0.00,0.00,0.00,2517.34,0.00,'2022-10-02 06:56:29','',''),(2614338,'5','90',NULL,270,'Sale Id shift 257776',852239.50,0.00,0.00,0.00,0.00,'2022-10-02 06:56:29','',''),(2614339,'5','90',NULL,270,'Reception corrector for bridging 129678',0.00,0.00,0.00,15000.00,0.00,'2022-10-02 07:35:12','',''),(2614340,'5','90','668',270,'Received from bridging 129678',0.00,0.00,15000.00,0.00,0.00,'2022-10-02 07:35:12','',''),(2614341,'5','90','668',270,'Sale Id shift 257779',0.00,0.00,0.00,2054.45,0.00,'2022-10-03 09:44:59','',''),(2614342,'5','90','670',270,'Sale Id shift 257779',0.00,0.00,0.00,2322.30,0.00,'2022-10-03 09:44:59','',''),(2614343,'5','90',NULL,270,'Sale Id shift 257779',809698.75,0.00,0.00,0.00,0.00,'2022-10-03 09:44:59','',''),(2614344,'5','90','668',270,'Sale Id shift 257780',0.00,0.00,0.00,2788.78,0.00,'2022-10-04 07:11:29','',''),(2614345,'5','90','670',270,'Sale Id shift 257780',0.00,0.00,0.00,3126.06,0.00,'2022-10-04 07:11:29','',''),(2614346,'5','90',NULL,270,'Sale Id shift 257780',1094245.40,0.00,0.00,0.00,0.00,'2022-10-04 07:11:29','',''),(2614347,'5','90','668',270,'Sale Id shift 257781',0.00,0.00,0.00,3101.46,0.00,'2022-10-05 10:03:42','',''),(2614348,'5','90','670',270,'Sale Id shift 257781',0.00,0.00,0.00,2700.99,0.00,'2022-10-05 10:03:42','',''),(2614349,'5','90',NULL,270,'Sale Id shift 257781',1073453.25,0.00,0.00,0.00,0.00,'2022-10-05 10:03:42','',''),(2614350,'5','90','668',270,'Sale Id shift 257782',0.00,0.00,0.00,2473.67,0.00,'2022-10-06 06:56:36','',''),(2614351,'5','90','670',270,'Sale Id shift 257782',0.00,0.00,0.00,2997.32,0.00,'2022-10-06 06:56:36','',''),(2614352,'5','90',NULL,270,'Sale Id shift 257782',1012133.15,0.00,0.00,0.00,0.00,'2022-10-06 06:56:36','',''),(2614353,'5','90','670',0,'Tank level zero out for dipping',0.00,0.00,0.00,7230.64,0.00,'2022-10-07 08:20:41','',''),(2614354,'5','90','670',0,'Inventory adjustment from tank dipping to 8700',0.00,0.00,8700.00,0.00,0.00,'2022-10-07 08:20:41','',''),(2614355,'5','90','668',270,'Sale Id shift 257783',0.00,0.00,0.00,3924.33,0.00,'2022-10-07 10:51:06','',''),(2614356,'5','90','670',270,'Sale Id shift 257783',0.00,0.00,0.00,4051.45,0.00,'2022-10-07 10:51:06','',''),(2614357,'5','90','670',270,'Sale Id shift 257783',0.00,0.00,0.00,3823.65,0.00,'2022-10-07 10:51:06','',''),(2614358,'5','90',NULL,270,'Sale Id shift 257783',2182894.55,0.00,0.00,0.00,0.00,'2022-10-07 10:51:06','',''),(2614359,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,5550000.00,30000.00,0.00,0.00,'2022-10-07 11:57:06','',''),(2614360,'5','90',NULL,270,'Reception corrector for bridging 129680',0.00,0.00,0.00,30000.00,0.00,'2022-10-07 12:51:04','',''),(2614361,'5','90','670',270,'Received from bridging 129680',0.00,0.00,30000.00,0.00,0.00,'2022-10-07 12:51:04','',''),(2614362,'5','90','669',270,'Sale Id shift 257784',0.00,0.00,0.00,3808.42,0.00,'2022-10-08 11:34:13','',''),(2614363,'5','90','669',270,'Sale Id shift 257784',0.00,0.00,0.00,989.74,0.00,'2022-10-08 11:34:13','',''),(2614364,'5','90',NULL,270,'Sale Id shift 257784',887659.60,0.00,0.00,0.00,0.00,'2022-10-08 11:34:13','',''),(2614365,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,9230.55,0.00,'2022-10-09 09:01:33','',''),(2614366,'5','90','668',0,'Inventory adjustment from tank dipping to 8000',0.00,0.00,8000.00,0.00,0.00,'2022-10-09 09:01:33','',''),(2614367,'5','90','669',0,'Tank level zero out for dipping',0.00,0.00,0.00,1748.81,0.00,'2022-10-09 09:01:58','',''),(2614368,'5','90','669',0,'Inventory adjustment from tank dipping to 10000',0.00,0.00,10000.00,0.00,0.00,'2022-10-09 09:01:58','',''),(2614369,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,8000.00,0.00,'2022-10-09 09:02:47','',''),(2614370,'5','90','668',0,'Inventory adjustment from tank dipping to 15000',0.00,0.00,15000.00,0.00,0.00,'2022-10-09 09:02:47','',''),(2614371,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,15000.00,0.00,'2022-10-09 09:11:37','',''),(2614372,'5','90','668',0,'Inventory adjustment from tank dipping to 8000',0.00,0.00,8000.00,0.00,0.00,'2022-10-09 09:11:37','',''),(2614373,'5','90','669',0,'Tank level zero out for dipping',0.00,0.00,0.00,10000.00,0.00,'2022-10-09 09:12:12','',''),(2614374,'5','90','669',0,'Inventory adjustment from tank dipping to 26000',0.00,0.00,26000.00,0.00,0.00,'2022-10-09 09:12:12','',''),(2614375,'5','90','669',270,'Sale Id shift 257785',0.00,0.00,0.00,3613.14,0.00,'2022-10-10 08:56:52','',''),(2614376,'5','90','668',270,'Sale Id shift 257785',0.00,0.00,0.00,3720.22,0.00,'2022-10-10 08:56:52','',''),(2614377,'5','90',NULL,270,'Sale Id shift 257785',1356671.60,0.00,0.00,0.00,0.00,'2022-10-10 08:56:52','',''),(2614378,'5','90','669',270,'Sale Id shift 257786',0.00,0.00,0.00,3755.50,0.00,'2022-10-11 12:13:25','',''),(2614379,'5','90','668',270,'Sale Id shift 257786',0.00,0.00,0.00,293.25,0.00,'2022-10-11 12:13:25','',''),(2614380,'5','90','669',270,'Sale Id shift 257786',0.00,0.00,0.00,2013.20,0.00,'2022-10-11 12:13:25','',''),(2614381,'5','90',NULL,270,'Sale Id shift 257786',1121460.75,0.00,0.00,0.00,0.00,'2022-10-11 12:13:25','',''),(2614382,'5','90','669',270,'Sale Id shift 257787',0.00,0.00,0.00,5335.50,0.00,'2022-10-12 12:29:17','',''),(2614383,'5','90','668',270,'Sale Id shift 257787',0.00,0.00,0.00,485.12,0.00,'2022-10-12 12:29:17','',''),(2614384,'5','90',NULL,270,'Sale Id shift 257787',1076814.70,0.00,0.00,0.00,0.00,'2022-10-12 12:29:17','',''),(2614385,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,3501.41,0.00,'2022-10-12 23:51:57','',''),(2614386,'5','90','668',0,'Inventory adjustment from tank dipping to 4000',0.00,0.00,4000.00,0.00,0.00,'2022-10-12 23:51:57','',''),(2614387,'5','90','669',270,'Sale Id shift 257788',0.00,0.00,0.00,5214.44,0.00,'2022-10-13 04:21:56','',''),(2614388,'5','90','668',270,'Sale Id shift 257788',0.00,0.00,0.00,3542.05,0.00,'2022-10-13 04:21:56','',''),(2614389,'5','90',NULL,270,'Sale Id shift 257788',1619950.65,0.00,0.00,0.00,0.00,'2022-10-13 04:21:56','',''),(2614390,'5','90','669',0,'Tank level zero out for dipping',0.00,0.00,0.00,6068.22,0.00,'2022-10-14 11:53:52','',''),(2614391,'5','90','669',0,'Inventory adjustment from tank dipping to 4000',0.00,0.00,4000.00,0.00,0.00,'2022-10-14 11:53:52','',''),(2614392,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,457.95,0.00,'2022-10-14 11:58:14','',''),(2614393,'5','90','668',0,'Inventory adjustment from tank dipping to 2000',0.00,0.00,2000.00,0.00,0.00,'2022-10-14 11:58:14','',''),(2614394,'5','90','669',0,'Tank level zero out for dipping',0.00,0.00,0.00,4000.00,0.00,'2022-10-16 10:18:27','',''),(2614395,'5','90','669',0,'Inventory adjustment from tank dipping to 12000',0.00,0.00,12000.00,0.00,0.00,'2022-10-16 10:18:27','',''),(2614396,'5','90','670',0,'Tank level zero out for dipping',0.00,0.00,0.00,30824.90,0.00,'2022-10-16 13:57:39','',''),(2614397,'5','90','670',0,'Inventory adjustment from tank dipping to 950',0.00,0.00,950.00,0.00,0.00,'2022-10-16 13:57:39','',''),(2614398,'5','90','669',270,'Sale Id shift 257789',0.00,0.00,0.00,4472.41,0.00,'2022-10-16 14:27:35','',''),(2614399,'5','90','668',270,'Sale Id shift 257789',0.00,0.00,0.00,591.29,0.00,'2022-10-16 14:27:35','',''),(2614400,'5','90','669',270,'Sale Id shift 257789',0.00,0.00,0.00,1864.07,0.00,'2022-10-16 14:27:35','',''),(2614401,'5','90',NULL,270,'Sale Id shift 257789',1281637.45,0.00,0.00,0.00,0.00,'2022-10-16 14:27:35','',''),(2614402,'5','90','669',270,'Sale Id shift 257790',0.00,0.00,0.00,1368.39,0.00,'2022-10-16 14:36:46','',''),(2614403,'5','90','669',270,'Sale Id shift 257790',0.00,0.00,0.00,2934.32,0.00,'2022-10-16 14:36:46','',''),(2614404,'5','90',NULL,270,'Sale Id shift 257790',796001.35,0.00,0.00,0.00,0.00,'2022-10-16 14:36:46','',''),(2614405,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,1408.71,0.00,'2022-10-29 05:10:27','',''),(2614406,'5','90','668',0,'Inventory adjustment from tank dipping to 13900',0.00,0.00,13900.00,0.00,0.00,'2022-10-29 05:10:27','',''),(2614407,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7215000.00,39000.00,0.00,0.00,'2022-10-29 08:31:59','',''),(2614408,'5','90',NULL,270,'Reception corrector for bridging 129682',0.00,0.00,0.00,26000.00,0.00,'2022-10-29 13:30:42','',''),(2614409,'5','90','670',270,'Received from bridging 129682',0.00,0.00,26000.00,0.00,0.00,'2022-10-29 13:30:42','',''),(2614410,'5','90',NULL,270,'Reception corrector for bridging 129681',0.00,0.00,0.00,13000.00,0.00,'2022-10-29 13:30:58','',''),(2614411,'5','90','668',270,'Received from bridging 129681',0.00,0.00,13000.00,0.00,0.00,'2022-10-29 13:30:58','',''),(2614412,'5','90','668',270,'Sale Id shift 257807',0.00,0.00,0.00,379.50,0.00,'2022-10-29 16:02:17','',''),(2614413,'5','90','670',270,'Sale Id shift 257807',0.00,0.00,0.00,1423.17,0.00,'2022-10-29 16:02:17','',''),(2614414,'5','90','670',270,'Sale Id shift 257807',0.00,0.00,0.00,748.74,0.00,'2022-10-29 16:02:17','',''),(2614415,'5','90',NULL,270,'Sale Id shift 257807',472010.85,0.00,0.00,0.00,0.00,'2022-10-29 16:02:17','',''),(2614416,'5','90','668',270,'Sale Id shift 257808',0.00,0.00,0.00,3000.31,0.00,'2022-10-30 06:51:32','',''),(2614417,'5','90','670',270,'Sale Id shift 257808',0.00,0.00,0.00,6387.91,0.00,'2022-10-30 06:51:32','',''),(2614418,'5','90','670',270,'Sale Id shift 257808',0.00,0.00,0.00,4761.49,0.00,'2022-10-30 06:51:32','',''),(2614419,'5','90',NULL,270,'Sale Id shift 257808',2617696.35,0.00,0.00,0.00,0.00,'2022-10-30 06:51:32','',''),(2614420,'5','90','668',270,'Sale Id shift 257809',0.00,0.00,0.00,1398.25,0.00,'2022-10-31 07:00:34','',''),(2614421,'5','90','670',270,'Sale Id shift 257809',0.00,0.00,0.00,5166.54,0.00,'2022-10-31 07:00:34','',''),(2614422,'5','90','670',270,'Sale Id shift 257809',0.00,0.00,0.00,4211.10,0.00,'2022-10-31 07:00:34','',''),(2614423,'5','90',NULL,270,'Sale Id shift 257809',1993539.65,0.00,0.00,0.00,0.00,'2022-10-31 07:00:34','',''),(2614424,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,22121.94,0.00,'2022-10-31 23:36:56','',''),(2614425,'5','90','668',0,'Inventory adjustment from tank dipping to 9000',0.00,0.00,9000.00,0.00,0.00,'2022-10-31 23:36:56','',''),(2614426,'5','90','668',270,'Sale Id shift 257810',0.00,0.00,0.00,8311.06,0.00,'2022-11-01 06:57:03','',''),(2614427,'5','90','670',270,'Sale Id shift 257810',0.00,0.00,0.00,2000.00,0.00,'2022-11-01 06:57:03','',''),(2614428,'5','90',NULL,270,'Sale Id shift 257810',1907546.10,0.00,0.00,0.00,0.00,'2022-11-01 06:57:03','',''),(2614429,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,11100000.00,60000.00,0.00,0.00,'2022-11-02 07:04:01','',''),(2614430,'5','90',NULL,270,'Reception corrector for bridging 129683',0.00,0.00,0.00,30000.00,0.00,'2022-11-02 07:52:21','',''),(2614431,'5','90','668',270,'Received from bridging 129683',0.00,0.00,30000.00,0.00,0.00,'2022-11-02 07:52:21','',''),(2614432,'5','90',NULL,270,'Reception corrector for bridging 129684',0.00,0.00,0.00,30000.00,0.00,'2022-11-02 07:52:32','',''),(2614433,'5','90','670',270,'Received from bridging 129684',0.00,0.00,30000.00,0.00,0.00,'2022-11-02 07:52:32','',''),(2614434,'5','90','668',270,'Sale Id shift 257811',0.00,0.00,0.00,9378.48,0.00,'2022-11-02 11:46:22','',''),(2614435,'5','90','670',270,'Sale Id shift 257811',0.00,0.00,0.00,5502.64,0.00,'2022-11-02 11:46:22','',''),(2614436,'5','90','670',270,'Sale Id shift 257811',0.00,0.00,0.00,8947.04,0.00,'2022-11-02 11:46:22','',''),(2614437,'5','90',NULL,270,'Sale Id shift 257811',4408209.60,0.00,0.00,0.00,0.00,'2022-11-02 11:46:22','',''),(2614438,'5','90','668',270,'Sale Id shift 257812',0.00,0.00,0.00,4629.85,0.00,'2022-11-03 06:32:27','',''),(2614439,'5','90','670',270,'Sale Id shift 257812',0.00,0.00,0.00,1064.29,0.00,'2022-11-03 06:32:27','',''),(2614440,'5','90','670',270,'Sale Id shift 257812',0.00,0.00,0.00,5031.21,0.00,'2022-11-03 06:32:27','',''),(2614441,'5','90',NULL,270,'Sale Id shift 257812',1984189.75,0.00,0.00,0.00,0.00,'2022-11-03 06:32:27','',''),(2614442,'5','90','668',270,'Sale Id shift 257813',0.00,0.00,0.00,5582.17,0.00,'2022-11-04 07:01:23','',''),(2614443,'5','90','670',270,'Sale Id shift 257813',0.00,0.00,0.00,6008.89,0.00,'2022-11-04 07:01:23','',''),(2614444,'5','90',NULL,270,'Sale Id shift 257813',2144346.10,0.00,0.00,0.00,0.00,'2022-11-04 07:01:23','',''),(2614445,'5','90','668',270,'Sale Id shift 257814',0.00,0.00,0.00,8033.19,0.00,'2022-11-05 07:23:58','',''),(2614446,'5','90',NULL,270,'Sale Id shift 257814',1486140.15,0.00,0.00,0.00,0.00,'2022-11-05 07:23:58','',''),(2614447,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,3065.25,0.00,'2022-11-06 04:52:28','',''),(2614448,'5','90','668',0,'Inventory adjustment from tank dipping to 4000',0.00,0.00,4000.00,0.00,0.00,'2022-11-06 04:52:28','',''),(2614449,'5','90','670',0,'Tank level zero out for dipping',0.00,0.00,0.00,5696.98,0.00,'2022-11-06 04:53:28','',''),(2614450,'5','90','670',0,'Inventory adjustment from tank dipping to 5700',0.00,0.00,5700.00,0.00,0.00,'2022-11-06 04:53:28','',''),(2614451,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,7326000.00,39600.00,0.00,0.00,'2022-11-06 08:13:45','',''),(2614452,'5','90','668',270,'Sale Id shift 257815',0.00,0.00,0.00,3466.48,0.00,'2022-11-06 08:14:27','',''),(2614453,'5','90','670',270,'Sale Id shift 257815',0.00,0.00,0.00,5277.49,0.00,'2022-11-06 08:14:27','',''),(2614454,'5','90',NULL,270,'Sale Id shift 257815',1617634.45,0.00,0.00,0.00,0.00,'2022-11-06 08:14:27','',''),(2614455,'5','90',NULL,270,'Reception corrector for bridging 129686',0.00,0.00,0.00,27000.00,0.00,'2022-11-06 18:07:47','',''),(2614456,'5','90','670',270,'Received from bridging 129686',0.00,0.00,27000.00,0.00,0.00,'2022-11-06 18:07:47','',''),(2614457,'5','90','668',0,'Tank level zero out for dipping',0.00,0.00,0.00,533.52,0.00,'2022-11-06 22:42:52','',''),(2614458,'5','90','668',0,'Inventory adjustment from tank dipping to 13500',0.00,0.00,13500.00,0.00,0.00,'2022-11-06 22:42:52','',''),(2614459,'5','90','668',270,'Sale Id shift 257816',0.00,0.00,0.00,2488.14,0.00,'2022-11-07 14:43:11','',''),(2614460,'5','90','670',270,'Sale Id shift 257816',0.00,0.00,0.00,3529.84,0.00,'2022-11-07 14:43:11','',''),(2614461,'5','90','670',270,'Sale Id shift 257816',0.00,0.00,0.00,3277.44,0.00,'2022-11-07 14:43:11','',''),(2614462,'5','90',NULL,270,'Sale Id shift 257816',1719652.70,0.00,0.00,0.00,0.00,'2022-11-07 14:43:11','',''),(2614463,'5','90','668',270,'Sale Id shift 257817',0.00,0.00,0.00,4804.55,0.00,'2022-11-08 07:41:59','',''),(2614464,'5','90','670',270,'Sale Id shift 257817',0.00,0.00,0.00,4331.23,0.00,'2022-11-08 07:41:59','',''),(2614465,'5','90','670',270,'Sale Id shift 257817',0.00,0.00,0.00,4980.59,0.00,'2022-11-08 07:41:59','',''),(2614466,'5','90',NULL,270,'Sale Id shift 257817',2611528.45,0.00,0.00,0.00,0.00,'2022-11-08 07:41:59','',''),(2614467,'5','90','668',270,'Sale Id shift 257818',0.00,0.00,0.00,6097.60,0.00,'2022-11-09 08:35:21','',''),(2614468,'5','90','670',270,'Sale Id shift 257818',0.00,0.00,0.00,3760.21,0.00,'2022-11-09 08:35:21','',''),(2614469,'5','90','670',270,'Sale Id shift 257818',0.00,0.00,0.00,4247.63,0.00,'2022-11-09 08:35:21','',''),(2614470,'5','90',NULL,270,'Sale Id shift 257818',2609506.40,0.00,0.00,0.00,0.00,'2022-11-09 08:35:21','',''),(2614471,'5','90','670',0,'Tank level zero out for dipping',0.00,0.00,0.00,3295.57,0.00,'2022-11-10 07:39:06','',''),(2614472,'5','90','670',0,'Inventory adjustment from tank dipping to 4000',0.00,0.00,4000.00,0.00,0.00,'2022-11-10 07:39:06','',''),(2614473,'5','90','670',270,'Sale Id shift 257819',0.00,0.00,0.00,1573.49,0.00,'2022-11-10 10:42:14','',''),(2614474,'5','90','670',270,'Sale Id shift 257819',0.00,0.00,0.00,990.01,0.00,'2022-11-10 10:42:14','',''),(2614475,'5','90',NULL,270,'Sale Id shift 257819',474247.50,0.00,0.00,0.00,0.00,'2022-11-10 10:42:14','',''),(2614476,'5','90',NULL,270,'Purchased from SALBAS OIL & GAS NIG. LIMITED',0.00,9450000.00,45000.00,0.00,0.00,'2023-03-05 09:44:14','',''),(2614477,'5','90',NULL,270,'Reception corrector for bridging 129687',0.00,0.00,0.00,15000.00,0.00,'2023-03-05 20:23:51','',''),(2614478,'5','90','668',270,'Received from bridging 129687',0.00,0.00,15000.00,0.00,0.00,'2023-03-05 20:23:51','',''),(2614479,'5','90',NULL,270,'Reception corrector for bridging 129688',0.00,0.00,0.00,30000.00,0.00,'2023-03-05 20:24:18','',''),(2614480,'5','90','670',270,'Received from bridging 129688',0.00,0.00,30000.00,0.00,0.00,'2023-03-05 20:24:18','',''),(2614481,'5','90','668',270,'Sale Id shift 257937',0.00,0.00,0.00,2784.17,0.00,'2023-03-06 08:58:06','',''),(2614482,'5','90','670',270,'Sale Id shift 257937',0.00,0.00,0.00,1944.34,0.00,'2023-03-06 08:58:06','',''),(2614483,'5','90','670',270,'Sale Id shift 257937',0.00,0.00,0.00,4213.83,0.00,'2023-03-06 08:58:06','',''),(2614484,'5','90',NULL,270,'Sale Id shift 257937',1877891.40,0.00,0.00,0.00,0.00,'2023-03-06 08:58:06','',''),(2614485,'5','90','668',270,'Sale Id shift 257938',0.00,0.00,0.00,3904.36,0.00,'2023-03-06 10:34:56','',''),(2614486,'5','90','670',270,'Sale Id shift 257938',0.00,0.00,0.00,5901.69,0.00,'2023-03-06 10:34:56','',''),(2614487,'5','90','670',270,'Sale Id shift 257938',0.00,0.00,0.00,2959.20,0.00,'2023-03-06 10:34:56','',''),(2614488,'5','90',NULL,270,'Sale Id shift 257938',2680702.50,0.00,0.00,0.00,0.00,'2023-03-06 10:34:56','',''),(2614489,'5','90','668',270,'Sale Id shift 257939',0.00,0.00,0.00,2445.50,0.00,'2023-03-07 09:25:30','',''),(2614490,'5','90','670',270,'Sale Id shift 257939',0.00,0.00,0.00,3959.67,0.00,'2023-03-07 09:25:30','',''),(2614491,'5','90','670',270,'Sale Id shift 257939',0.00,0.00,0.00,2137.00,0.00,'2023-03-07 09:25:30','',''),(2614492,'5','90',NULL,270,'Sale Id shift 257939',1793855.70,0.00,0.00,0.00,0.00,'2023-03-07 09:25:30','',''),(2614493,'5','90','668',270,'Sale Id shift 257940',0.00,0.00,0.00,136.44,0.00,'2023-03-08 09:50:28','',''),(2614494,'5','90','670',270,'Sale Id shift 257940',0.00,0.00,0.00,4459.09,0.00,'2023-03-08 09:50:28','',''),(2614495,'5','90','670',270,'Sale Id shift 257940',0.00,0.00,0.00,632.18,0.00,'2023-03-08 09:50:28','',''),(2614496,'5','90',NULL,270,'Sale Id shift 257940',1097819.10,0.00,0.00,0.00,0.00,'2023-03-08 09:50:28','',''),(2614497,'5','90','668',270,'Sale Id shift 257941',0.00,0.00,0.00,4045.31,0.00,'2023-03-09 09:49:00','',''),(2614498,'5','90','670',270,'Sale Id shift 257941',0.00,0.00,0.00,1224.57,0.00,'2023-03-09 09:49:00','',''),(2614499,'5','90','670',270,'Sale Id shift 257941',0.00,0.00,0.00,2313.38,0.00,'2023-03-09 09:49:00','',''),(2614500,'5','90',NULL,270,'Sale Id shift 257941',1592484.60,0.00,0.00,0.00,0.00,'2023-03-09 09:49:00','',''),(2614501,'5','90','668',270,'Sale Id shift 257942',0.00,0.00,0.00,1714.05,0.00,'2023-03-10 09:17:40','',''),(2614502,'5','90',NULL,270,'Sale Id shift 257942',359950.50,0.00,0.00,0.00,0.00,'2023-03-10 09:17:40','','');
/*!40000 ALTER TABLE `inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_balances`
--

DROP TABLE IF EXISTS `inventory_balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_balances` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`balance`),
  KEY `thedate` (`thedate`),
  KEY `station_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_balances`
--

LOCK TABLES `inventory_balances` WRITE;
/*!40000 ALTER TABLE `inventory_balances` DISABLE KEYS */;
INSERT INTO `inventory_balances` VALUES (1,'5','90',272,-40567.00,'2023-03-17 20:14:30'),(2,'5','90',271,445.78,'2023-03-17 20:14:30'),(3,'5','90',270,47121.16,'2023-03-17 20:14:30');
/*!40000 ALTER TABLE `inventory_balances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `inventory_costs`
--

DROP TABLE IF EXISTS `inventory_costs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `inventory_costs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `details` varchar(100) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `rate` decimal(20,2) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `profit` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`product_id`,`details`,`credit`,`debit`),
  KEY `thedate` (`thedate`),
  KEY `cost` (`rate`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1702651 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventory_costs`
--

LOCK TABLES `inventory_costs` WRITE;
/*!40000 ALTER TABLE `inventory_costs` DISABLE KEYS */;
INSERT INTO `inventory_costs` VALUES (1031878,'5','90',270,'Sale Id shift 212839',0.00,350735.55,165.00,350735.55,0.00,'2021-07-26 17:03:56'),(1032016,'5','90',270,'Sale Id shift 213087',0.00,399788.40,165.00,399788.40,0.00,'2021-07-26 18:30:53'),(1033099,'5','90',270,'Sale Id shift 213090',0.00,406946.10,165.00,406946.10,0.00,'2021-07-27 09:51:56'),(1033402,'5','90',270,'Sale Id shift 213229',0.00,220834.35,165.00,220834.35,0.00,'2021-07-27 10:42:17'),(1038674,'5','90',270,'Sale Id shift 213498',0.00,439083.15,165.00,439083.15,0.00,'2021-07-28 15:33:52'),(1040092,'5','90',270,'Sale Id shift 213599',0.00,465672.90,165.00,465672.90,0.00,'2021-07-29 08:44:07'),(1043468,'5','90',270,'Sale Id shift 213862',0.00,1219107.45,165.00,1219107.45,0.00,'2021-07-30 07:10:28'),(1047132,'5','90',270,'Sale Id shift 213977',0.00,371786.25,165.00,371786.25,0.00,'2021-07-30 21:06:11'),(1051413,'5','90',270,'Sale Id shift 214125',0.00,331130.25,165.00,331130.25,0.00,'2021-08-01 05:20:19'),(1055086,'5','90',270,'Sale Id shift 214345',0.00,363462.00,165.00,363462.00,0.00,'2021-08-02 05:34:30'),(1059289,'5','90',270,'Sale Id shift 214595',0.00,482474.85,165.00,482474.85,0.00,'2021-08-03 04:32:57'),(1063791,'5','90',270,'Sale Id shift 214779',0.00,576011.70,165.00,576011.70,0.00,'2021-08-04 05:54:50'),(1067356,'5','90',270,'Sale Id shift 214995',0.00,360597.60,165.00,360597.60,0.00,'2021-08-05 05:31:03'),(1070562,'5','90',270,'Sale Id shift 215231',0.00,1283439.30,165.00,1283439.30,0.00,'2021-08-06 01:18:13'),(1074762,'5','90',270,'Sale Id shift 215505',0.00,464135.10,165.00,464135.10,0.00,'2021-08-07 05:41:31'),(1074763,'5','90',271,'Sale Id shift 215505',0.00,52359.55,295.00,52359.55,0.00,'2021-08-07 05:41:31'),(1078815,'5','90',270,'Sale Id shift 215680',0.00,435831.00,165.00,435831.00,0.00,'2021-08-08 03:38:45'),(1078816,'5','90',271,'Sale Id shift 215680',0.00,53167.85,295.00,53167.85,0.00,'2021-08-08 03:38:45'),(1082664,'5','90',270,'Sale Id shift 215895',0.00,346333.35,165.00,346333.35,0.00,'2021-08-09 06:22:40'),(1082665,'5','90',271,'Sale Id shift 215895',0.00,11472.55,295.00,11472.55,0.00,'2021-08-09 06:22:40'),(1086657,'5','90',270,'Sale Id shift 216114',0.00,405203.70,165.00,405203.70,0.00,'2021-08-10 05:40:31'),(1086658,'5','90',271,'Sale Id shift 216114',0.00,17381.40,295.00,17381.40,0.00,'2021-08-10 05:40:31'),(1090458,'5','90',270,'Sale Id shift 216330',0.00,416078.85,165.00,416078.85,0.00,'2021-08-11 05:52:55'),(1090459,'5','90',271,'Sale Id shift 216330',0.00,9268.90,295.00,9268.90,0.00,'2021-08-11 05:52:55'),(1093635,'5','90',270,'Sale Id shift 216552',0.00,306134.40,165.00,306134.40,0.00,'2021-08-12 05:38:38'),(1093636,'5','90',271,'Sale Id shift 216552',0.00,8094.80,295.00,8094.80,0.00,'2021-08-12 05:38:38'),(1097024,'5','90',270,'Sale Id shift 216790',0.00,1235194.95,165.00,1235194.95,0.00,'2021-08-13 05:45:45'),(1097025,'5','90',271,'Sale Id shift 216790',0.00,56613.45,295.00,56613.45,0.00,'2021-08-13 05:45:45'),(1101145,'5','90',270,'Sale Id shift 217076',0.00,353293.05,165.00,353293.05,0.00,'2021-08-14 05:52:49'),(1101146,'5','90',271,'Sale Id shift 217076',0.00,9968.05,295.00,9968.05,0.00,'2021-08-14 05:52:49'),(1109686,'5','90',270,'Sale Id shift 217292',0.00,322687.20,165.00,322687.20,0.00,'2021-08-15 18:57:14'),(1109687,'5','90',271,'Sale Id shift 217292',0.00,18670.55,295.00,18670.55,0.00,'2021-08-15 18:57:14'),(1109832,'5','90',270,'Sale Id shift 217690',0.00,372909.90,165.00,372909.90,0.00,'2021-08-16 06:13:41'),(1109833,'5','90',271,'Sale Id shift 217690',0.00,27812.60,295.00,27812.60,0.00,'2021-08-16 06:13:41'),(1113692,'5','90',270,'Sale Id shift 217853',0.00,335783.25,165.00,335783.25,0.00,'2021-08-17 05:48:32'),(1113693,'5','90',271,'Sale Id shift 217853',0.00,43081.80,295.00,43081.80,0.00,'2021-08-17 05:48:32'),(1117530,'5','90',270,'Sale Id shift 218105',0.00,388720.20,165.00,388720.20,0.00,'2021-08-18 00:58:13'),(1117531,'5','90',271,'Sale Id shift 218105',0.00,17567.25,295.00,17567.25,0.00,'2021-08-18 00:58:13'),(1121082,'5','90',270,'Sale Id shift 218221',0.00,258926.25,165.00,258926.25,0.00,'2021-08-19 05:52:45'),(1121083,'5','90',271,'Sale Id shift 218221',0.00,33450.05,295.00,33450.05,0.00,'2021-08-19 05:52:45'),(1125192,'5','90',270,'Sale Id shift 218457',0.00,640417.80,165.00,640417.80,0.00,'2021-08-20 05:51:25'),(1132584,'5','90',271,'Sale Id shift 218841',0.00,65584.40,295.00,65584.40,0.00,'2021-08-21 16:34:00'),(1133190,'5','90',271,'Sale Id shift 219098',0.00,15599.60,295.00,15599.60,0.00,'2021-08-22 06:04:47'),(1137294,'5','90',270,'Sale Id shift 219119',0.00,304860.60,165.00,304860.60,0.00,'2021-08-23 05:49:43'),(1137295,'5','90',271,'Sale Id shift 219119',0.00,33019.35,295.00,33019.35,0.00,'2021-08-23 05:49:43'),(1141259,'5','90',270,'Sale Id shift 219420',0.00,307571.55,165.00,307571.55,0.00,'2021-08-24 05:42:30'),(1141260,'5','90',271,'Sale Id shift 219420',0.00,31275.90,295.00,31275.90,0.00,'2021-08-24 05:42:30'),(1145035,'5','90',270,'Sale Id shift 219655',0.00,298272.15,165.00,298272.15,0.00,'2021-08-25 05:42:33'),(1145036,'5','90',271,'Sale Id shift 219655',0.00,68528.50,295.00,68528.50,0.00,'2021-08-25 05:42:33'),(1148819,'5','90',270,'Sale Id shift 219852',0.00,212818.65,165.00,212818.65,0.00,'2021-08-26 04:44:16'),(1148820,'5','90',271,'Sale Id shift 219852',0.00,22717.95,295.00,22717.95,0.00,'2021-08-26 04:44:16'),(1152515,'5','90',270,'Sale Id shift 220019',0.00,1118031.75,165.00,1118031.75,0.00,'2021-08-27 06:17:54'),(1152516,'5','90',271,'Sale Id shift 220019',0.00,94963.45,295.00,94963.45,0.00,'2021-08-27 06:17:54'),(1155895,'5','90',270,'Sale Id shift 220248',0.00,343668.60,165.00,343668.60,0.00,'2021-08-28 05:25:09'),(1155896,'5','90',271,'Sale Id shift 220248',0.00,22467.20,295.00,22467.20,0.00,'2021-08-28 05:25:09'),(1159613,'5','90',270,'Sale Id shift 220490',0.00,235280.10,165.00,235280.10,0.00,'2021-08-29 05:57:56'),(1159614,'5','90',271,'Sale Id shift 220490',0.00,7690.65,295.00,7690.65,0.00,'2021-08-29 05:57:56'),(1164054,'5','90',270,'Sale Id shift 220706',0.00,307733.25,165.00,307733.25,0.00,'2021-08-30 05:38:47'),(1164055,'5','90',271,'Sale Id shift 220706',0.00,18177.90,295.00,18177.90,0.00,'2021-08-30 05:38:47'),(1168208,'5','90',270,'Sale Id shift 220939',0.00,318697.50,165.00,318697.50,0.00,'2021-08-31 06:02:37'),(1168209,'5','90',271,'Sale Id shift 220939',0.00,12186.45,295.00,12186.45,0.00,'2021-08-31 06:02:37'),(1172090,'5','90',270,'Sale Id shift 221160',0.00,352532.40,165.00,352532.40,0.00,'2021-09-01 05:59:21'),(1172091,'5','90',271,'Sale Id shift 221160',0.00,30857.00,295.00,30857.00,0.00,'2021-09-01 05:59:21'),(1175841,'5','90',270,'Sale Id shift 221416',0.00,432733.95,165.00,432733.95,0.00,'2021-09-02 05:47:45'),(1175842,'5','90',271,'Sale Id shift 221416',0.00,20532.00,295.00,20532.00,0.00,'2021-09-02 05:47:45'),(1180028,'5','90',270,'Sale Id shift 221638',0.00,1119295.65,165.00,1119295.65,0.00,'2021-09-03 05:48:02'),(1180029,'5','90',271,'Sale Id shift 221638',0.00,110890.50,295.00,110890.50,0.00,'2021-09-03 05:48:02'),(1184339,'5','90',270,'Sale Id shift 221913',0.00,395925.75,165.00,395925.75,0.00,'2021-09-04 06:07:09'),(1184340,'5','90',271,'Sale Id shift 221913',0.00,48026.00,295.00,48026.00,0.00,'2021-09-04 06:07:09'),(1188328,'5','90',270,'Sale Id shift 222059',0.00,312341.70,165.00,312341.70,0.00,'2021-09-05 05:59:55'),(1188329,'5','90',271,'Sale Id shift 222059',0.00,9487.20,295.00,9487.20,0.00,'2021-09-05 05:59:55'),(1192188,'5','90',270,'Sale Id shift 222267',0.00,315575.70,165.00,315575.70,0.00,'2021-09-06 06:04:49'),(1192189,'5','90',271,'Sale Id shift 222267',0.00,31234.60,295.00,31234.60,0.00,'2021-09-06 06:04:49'),(1195224,'5','90',270,'Sale Id shift 222494',0.00,330491.70,165.00,330491.70,0.00,'2021-09-07 06:42:54'),(1195225,'5','90',271,'Sale Id shift 222494',0.00,16050.95,295.00,16050.95,0.00,'2021-09-07 06:42:54'),(1196591,'5','90',270,'Sale Id shift 222846',0.00,191672.25,165.00,191672.25,0.00,'2021-09-08 06:08:26'),(1196592,'5','90',271,'Sale Id shift 222846',0.00,29963.15,295.00,29963.15,0.00,'2021-09-08 06:08:26'),(1198466,'5','90',270,'Sale Id shift 222953',0.00,269082.00,165.00,269082.00,0.00,'2021-09-09 05:16:22'),(1198467,'5','90',271,'Sale Id shift 222953',0.00,26204.85,295.00,26204.85,0.00,'2021-09-09 05:16:22'),(1201836,'5','90',270,'Sale Id shift 223237',0.00,1131990.75,165.00,1131990.75,0.00,'2021-09-10 05:57:29'),(1201837,'5','90',271,'Sale Id shift 223237',0.00,96795.40,295.00,96795.40,0.00,'2021-09-10 05:57:29'),(1205457,'5','90',270,'Sale Id shift 223625',0.00,298541.10,165.00,298541.10,0.00,'2021-09-11 07:09:42'),(1205458,'5','90',271,'Sale Id shift 223625',0.00,14021.35,295.00,14021.35,0.00,'2021-09-11 07:09:42'),(1208986,'5','90',270,'Sale Id shift 223857',0.00,295160.25,165.00,295160.25,0.00,'2021-09-12 06:03:15'),(1208987,'5','90',271,'Sale Id shift 223857',0.00,18505.35,295.00,18505.35,0.00,'2021-09-12 06:03:15'),(1212747,'5','90',270,'Sale Id shift 223877',0.00,312973.65,165.00,312973.65,0.00,'2021-09-13 07:16:48'),(1212748,'5','90',271,'Sale Id shift 223877',0.00,13171.75,295.00,13171.75,0.00,'2021-09-13 07:16:48'),(1216264,'5','90',270,'Sale Id shift 224121',0.00,15569.40,165.00,15569.40,0.00,'2021-09-14 06:29:57'),(1216265,'5','90',271,'Sale Id shift 224121',0.00,10566.90,295.00,10566.90,0.00,'2021-09-14 06:29:57'),(1219998,'5','90',271,'Sale Id shift 224320',0.00,19319.55,295.00,19319.55,0.00,'2021-09-15 06:19:29'),(1227256,'5','90',270,'Sale Id shift 224994',0.00,394447.35,163.00,389666.17,-4781.18,'2021-09-17 05:49:38'),(1227257,'5','90',271,'Sale Id shift 224994',0.00,4991.40,295.00,4991.40,0.00,'2021-09-17 05:49:38'),(1230464,'5','90',270,'Sale Id shift 225022',0.00,370448.10,163.00,365957.82,-4490.28,'2021-09-18 05:49:54'),(1230465,'5','90',271,'Sale Id shift 225022',0.00,24526.30,295.00,24526.30,0.00,'2021-09-18 05:49:54'),(1233653,'5','90',270,'Sale Id shift 225296',0.00,333237.30,163.00,329198.06,-4039.24,'2021-09-19 06:00:55'),(1233654,'5','90',271,'Sale Id shift 225296',0.00,36928.10,295.00,36928.10,0.00,'2021-09-19 06:00:55'),(1236955,'5','90',270,'Sale Id shift 225481',0.00,304773.15,163.00,301078.93,-3694.22,'2021-09-20 05:45:41'),(1236956,'5','90',271,'Sale Id shift 225481',0.00,22496.70,295.00,22496.70,0.00,'2021-09-20 05:45:41'),(1240121,'5','90',270,'Sale Id shift 225718',0.00,67607.10,163.00,66787.62,-819.48,'2021-09-21 05:36:58'),(1244866,'5','90',270,'Sale Id shift 226000',0.00,371225.25,163.00,366725.55,-4499.70,'2021-09-22 13:42:41'),(1246175,'5','90',270,'Sale Id shift 226382',0.00,343652.10,163.00,339486.62,-4165.48,'2021-09-23 05:40:28'),(1249723,'5','90',270,'Sale Id shift 226547',0.00,1131357.15,163.00,1117643.73,-13713.42,'2021-09-24 06:09:43'),(1254692,'5','90',270,'Sale Id shift 226840',0.00,342536.70,163.00,338384.74,-4151.96,'2021-09-25 11:35:37'),(1256662,'5','90',270,'Sale Id shift 227059',0.00,359818.80,163.00,355457.36,-4361.44,'2021-09-26 05:51:16'),(1259688,'5','90',270,'Sale Id shift 227200',0.00,278041.50,163.00,274671.30,-3370.20,'2021-09-27 05:40:56'),(1262815,'5','90',270,'Sale Id shift 227394',0.00,89225.40,163.00,88143.88,-1081.52,'2021-09-28 05:50:20'),(1308113,'5','90',271,'Sale Id shift 230704',0.00,26733.00,300.00,26733.00,0.00,'2021-10-11 15:36:25'),(1312662,'5','90',271,'Sale Id shift 231139',0.00,95852.00,310.00,95852.00,0.00,'2021-10-13 09:54:38'),(1312702,'5','90',271,'Sale Id shift 231142',0.00,130162.80,310.00,130162.80,0.00,'2021-10-13 10:02:20'),(1312803,'5','90',271,'Sale Id shift 231152',0.00,186359.60,310.00,186359.60,0.00,'2021-10-13 10:23:45'),(1312824,'5','90',271,'Sale Id shift 231156',0.00,96530.90,310.00,96530.90,0.00,'2021-10-13 10:29:13'),(1312845,'5','90',271,'Sale Id shift 231158',0.00,44144.00,310.00,44144.00,0.00,'2021-10-13 10:35:02'),(1312878,'5','90',271,'Sale Id shift 231161',0.00,29865.40,310.00,29865.40,0.00,'2021-10-13 10:47:03'),(1312907,'5','90',271,'Sale Id shift 231163',0.00,45154.60,320.00,46611.20,1456.60,'2021-10-13 10:53:45'),(1313656,'5','90',270,'Sale Id shift 231165',0.00,378885.35,163.00,378885.35,0.00,'2021-10-13 14:06:57'),(1313657,'5','90',271,'Sale Id shift 231165',0.00,148834.10,320.00,153635.20,4801.10,'2021-10-13 14:06:57'),(1315080,'5','90',270,'Sale Id shift 231243',0.00,486815.80,163.00,486815.80,0.00,'2021-10-14 07:23:03'),(1315081,'5','90',271,'Sale Id shift 231243',0.00,78051.80,320.00,80569.60,2517.80,'2021-10-14 07:23:03'),(1317649,'5','90',270,'Sale Id shift 231422',0.00,1326619.51,163.00,1326619.51,0.00,'2021-10-15 06:03:10'),(1317650,'5','90',271,'Sale Id shift 231422',0.00,70782.30,320.00,73065.60,2283.30,'2021-10-15 06:03:10'),(1320881,'5','90',270,'Sale Id shift 231640',0.00,339082.38,163.00,339082.38,0.00,'2021-10-16 06:21:14'),(1320882,'5','90',271,'Sale Id shift 231640',0.00,22912.10,320.00,23651.20,739.10,'2021-10-16 06:21:14'),(1325536,'5','90',270,'Sale Id shift 232075',0.00,350670.05,163.00,350670.05,0.00,'2021-10-17 11:36:18'),(1325537,'5','90',271,'Sale Id shift 232075',0.00,58611.70,327.00,61825.89,3214.19,'2021-10-17 11:36:18'),(1327145,'5','90',270,'Sale Id shift 232314',0.00,387178.79,163.00,387178.79,0.00,'2021-10-18 06:13:42'),(1327146,'5','90',271,'Sale Id shift 232314',0.00,75618.75,327.00,75618.75,0.00,'2021-10-18 06:13:42'),(1330828,'5','90',270,'Sale Id shift 232368',0.00,344006.61,163.00,344006.61,0.00,'2021-10-19 05:54:11'),(1330829,'5','90',271,'Sale Id shift 232368',0.00,66341.76,327.00,66341.76,0.00,'2021-10-19 05:54:11'),(1333963,'5','90',270,'Sale Id shift 232823',0.00,235065.56,163.00,235065.56,0.00,'2021-10-20 05:51:51'),(1333964,'5','90',271,'Sale Id shift 232823',0.00,21003.21,327.00,21003.21,0.00,'2021-10-20 05:51:51'),(1337458,'5','90',270,'Sale Id shift 232858',0.00,289388.57,163.00,289388.57,0.00,'2021-10-21 06:05:17'),(1337459,'5','90',271,'Sale Id shift 232858',0.00,77790.03,330.00,78503.70,713.67,'2021-10-21 06:05:17'),(1340925,'5','90',270,'Sale Id shift 233307',0.00,124690.11,163.00,124690.11,0.00,'2021-10-22 06:00:31'),(1340926,'5','90',271,'Sale Id shift 233307',0.00,45633.15,345.00,45633.15,0.00,'2021-10-22 06:00:31'),(1344370,'5','90',271,'Sale Id shift 233450',0.00,44242.80,345.00,44242.80,0.00,'2021-10-23 06:18:57'),(1348159,'5','90',271,'Sale Id shift 233671',0.00,29725.20,345.00,29725.20,0.00,'2021-10-24 06:16:41'),(1351405,'5','90',271,'Sale Id shift 233851',0.00,32992.35,345.00,32992.35,0.00,'2021-10-25 06:06:24'),(1354748,'5','90',271,'Sale Id shift 234283',0.00,28051.95,345.00,28051.95,0.00,'2021-10-26 05:41:22'),(1358866,'5','90',271,'Sale Id shift 234380',0.00,30991.35,345.00,30991.35,0.00,'2021-10-27 08:44:11'),(1361834,'5','90',271,'Sale Id shift 234695',0.00,60947.70,345.00,60947.70,0.00,'2021-10-28 07:21:31'),(1364843,'5','90',271,'Sale Id shift 234875',0.00,22466.40,345.00,22466.40,0.00,'2021-10-29 06:08:41'),(1387965,'5','90',270,'Sale Id shift 236546',0.00,1582371.45,165.00,1582371.45,0.00,'2021-11-05 06:35:25'),(1387966,'5','90',271,'Sale Id shift 236546',0.00,155412.15,345.00,155412.15,0.00,'2021-11-05 06:35:25'),(1392887,'5','90',270,'Sale Id shift 236932',0.00,776539.50,165.00,776539.50,0.00,'2021-11-06 07:05:49'),(1392888,'5','90',271,'Sale Id shift 236932',0.00,60823.50,345.00,60823.50,0.00,'2021-11-06 07:05:49'),(1397903,'5','90',270,'Sale Id shift 237057',0.00,663362.70,165.00,663362.70,0.00,'2021-11-07 06:28:28'),(1397904,'5','90',271,'Sale Id shift 237057',0.00,38522.70,345.00,38522.70,0.00,'2021-11-07 06:28:28'),(1402431,'5','90',270,'Sale Id shift 237186',0.00,687682.05,165.00,687682.05,0.00,'2021-11-08 06:33:00'),(1402432,'5','90',271,'Sale Id shift 237186',0.00,49017.60,345.00,49017.60,0.00,'2021-11-08 06:33:00'),(1406632,'5','90',270,'Sale Id shift 237450',0.00,752667.30,165.00,752667.30,0.00,'2021-11-09 06:16:14'),(1406633,'5','90',271,'Sale Id shift 237450',0.00,33254.55,345.00,33254.55,0.00,'2021-11-09 06:16:14'),(1411047,'5','90',271,'Sale Id shift 237837',0.00,154887.75,345.00,154887.75,0.00,'2021-11-10 05:52:13'),(1416008,'5','90',271,'Sale Id shift 237901',0.00,110627.70,345.00,110627.70,0.00,'2021-11-11 05:47:56'),(1421815,'5','90',271,'Sale Id shift 238142',0.00,44111.70,345.00,44111.70,0.00,'2021-11-12 07:28:49'),(1426221,'5','90',271,'Sale Id shift 238432',0.00,89703.45,345.00,89703.45,0.00,'2021-11-13 07:06:27'),(1435259,'5','90',270,'Sale Id shift 238935',0.00,418793.10,165.00,418793.10,0.00,'2021-11-15 06:21:55'),(1435260,'5','90',271,'Sale Id shift 238935',0.00,104976.60,345.00,104976.60,0.00,'2021-11-15 06:21:55'),(1439686,'5','90',270,'Sale Id shift 239073',0.00,858092.40,165.00,858092.40,0.00,'2021-11-16 07:17:11'),(1439687,'5','90',271,'Sale Id shift 239073',0.00,103537.95,345.00,103537.95,0.00,'2021-11-16 07:17:11'),(1443110,'5','90',270,'Sale Id shift 239339',0.00,522036.90,165.00,522036.90,0.00,'2021-11-17 05:47:57'),(1443111,'5','90',271,'Sale Id shift 239339',0.00,23663.55,345.00,23663.55,0.00,'2021-11-17 05:47:57'),(1447493,'5','90',270,'Sale Id shift 239557',0.00,585408.45,165.00,585408.45,0.00,'2021-11-18 06:08:01'),(1447494,'5','90',271,'Sale Id shift 239557',0.00,82720.65,345.00,82720.65,0.00,'2021-11-18 06:08:01'),(1452280,'5','90',270,'Sale Id shift 239809',0.00,1408816.20,165.00,1408816.20,0.00,'2021-11-19 07:27:37'),(1452281,'5','90',271,'Sale Id shift 239809',0.00,181911.60,345.00,181911.60,0.00,'2021-11-19 07:27:37'),(1456353,'5','90',270,'Sale Id shift 240080',0.00,499639.80,165.00,499639.80,0.00,'2021-11-20 07:09:46'),(1461109,'5','90',270,'Sale Id shift 240268',0.00,617034.00,165.00,617034.00,0.00,'2021-11-21 06:39:41'),(1465787,'5','90',270,'Sale Id shift 240486',0.00,664270.20,165.00,664270.20,0.00,'2021-11-22 06:22:12'),(1470773,'5','90',270,'Sale Id shift 240704',0.00,547054.20,165.00,547054.20,0.00,'2021-11-23 07:02:24'),(1475237,'5','90',270,'Sale Id shift 240998',0.00,178373.25,165.00,178373.25,0.00,'2021-11-24 06:22:36'),(1667038,'5','90',270,'Sale Id shift 250180',0.00,464565.75,165.00,464565.75,0.00,'2022-01-01 07:50:19'),(1671549,'5','90',270,'Sale Id shift 250412',0.00,598697.55,165.00,598697.55,0.00,'2022-01-02 06:47:50'),(1679238,'5','90',270,'Sale Id shift 250600',0.00,751040.40,165.00,751040.40,0.00,'2022-01-03 14:06:33'),(1681279,'5','90',270,'Sale Id shift 250993',0.00,1700869.50,165.00,1700869.50,0.00,'2022-01-04 07:05:48'),(1686853,'5','90',270,'Sale Id shift 251061',0.00,1413622.65,165.00,1413622.65,0.00,'2022-01-05 07:35:58'),(1692049,'5','90',270,'Sale Id shift 251365',0.00,1572727.20,165.00,1572727.20,0.00,'2022-01-06 07:49:59'),(1697968,'5','90',270,'Sale Id shift 251587',0.00,1526672.40,165.00,1526672.40,0.00,'2022-01-07 09:10:19'),(1702498,'5','90',270,'Sale Id shift 251915',0.00,649877.25,165.00,649877.25,0.00,'2022-01-08 07:59:04'),(1702499,'5','90',270,'Sale Id shift 257527',0.00,1093648.05,165.00,1093648.05,0.00,'2022-02-04 06:27:40'),(1702500,'5','90',270,'Sale Id shift 257528',0.00,594217.80,165.00,594217.80,0.00,'2022-02-05 07:51:07'),(1702501,'5','90',270,'Sale Id shift 257529',0.00,874655.10,165.00,874655.10,0.00,'2022-02-06 07:47:29'),(1702502,'5','90',270,'Sale Id shift 257530',0.00,815395.35,165.00,815395.35,0.00,'2022-02-07 07:16:43'),(1702503,'5','90',270,'Sale Id shift 257531',0.00,887119.20,165.00,887119.20,0.00,'2022-02-08 07:42:45'),(1702504,'5','90',270,'Sale Id shift 257532',0.00,501963.00,165.00,501963.00,0.00,'2022-02-09 08:18:38'),(1702505,'5','90',270,'Sale Id shift 257533',0.00,176787.60,165.00,176787.60,0.00,'2022-02-10 08:00:56'),(1702506,'5','90',270,'Sale Id shift 257544',0.00,851494.05,165.00,851494.05,0.00,'2022-02-21 07:25:21'),(1702507,'5','90',270,'Sale Id shift 257545',0.00,1242214.05,165.00,1242214.05,0.00,'2022-02-22 06:43:16'),(1702508,'5','90',270,'Sale Id shift 257546',0.00,45891.45,165.00,45891.45,0.00,'2022-02-23 07:02:33'),(1702509,'5','90',270,'Sale Id shift 257550',0.00,148496.70,165.00,148496.70,0.00,'2022-02-27 23:05:38'),(1702510,'5','90',270,'Sale Id shift 257551',0.00,2238611.10,165.00,2238611.10,0.00,'2022-03-01 06:54:53'),(1702511,'5','90',270,'Sale Id shift 257552',0.00,1802039.25,165.00,1802039.25,0.00,'2022-03-01 09:24:50'),(1702512,'5','90',270,'Sale Id shift 257553',0.00,898202.25,165.00,898202.25,0.00,'2022-03-02 08:19:56'),(1702513,'5','90',270,'Sale Id shift 257568',0.00,66000.00,165.00,66000.00,0.00,'2022-03-17 10:22:46'),(1702514,'5','90',270,'Sale Id shift 257569',0.00,1341253.65,165.00,1341253.65,0.00,'2022-03-18 07:47:40'),(1702515,'5','90',270,'Sale Id shift 257570',0.00,720571.50,165.00,720571.50,0.00,'2022-03-19 07:01:58'),(1702516,'5','90',270,'Sale Id shift 257592',0.00,518882.10,165.00,518882.10,0.00,'2022-04-10 15:00:29'),(1702517,'5','90',270,'Sale Id shift 257593',0.00,984723.30,165.00,984723.30,0.00,'2022-04-11 08:58:12'),(1702518,'5','90',270,'Sale Id shift 257594',0.00,523393.20,165.00,523393.20,0.00,'2022-04-12 07:17:08'),(1702519,'5','90',270,'Sale Id shift 257595',0.00,450522.60,165.00,450522.60,0.00,'2022-04-13 09:55:00'),(1702520,'5','90',272,'Sale Id shift 257604',0.00,0.00,0.00,0.00,0.00,'2022-04-22 09:26:33'),(1702521,'5','90',270,'Sale Id shift 257610',0.00,267900.60,165.00,267900.60,0.00,'2022-04-27 11:12:21'),(1702522,'5','90',270,'Sale Id shift 257611',0.00,971142.15,165.00,971142.15,0.00,'2022-04-28 08:34:44'),(1702523,'5','90',270,'Sale Id shift 257612',0.00,885517.05,165.00,885517.05,0.00,'2022-04-28 20:49:32'),(1702524,'5','90',270,'Sale Id shift 257614',0.00,328348.35,165.00,328348.35,0.00,'2022-05-09 16:15:42'),(1702525,'5','90',270,'Sale Id shift 257620',0.00,977550.75,165.00,977550.75,0.00,'2022-05-09 17:01:34'),(1702526,'5','90',270,'Sale Id shift 257621',0.00,881636.25,165.00,881636.25,0.00,'2022-05-09 17:07:49'),(1702527,'5','90',270,'Sale Id shift 257622',0.00,968944.35,165.00,968944.35,0.00,'2022-05-09 17:11:46'),(1702528,'5','90',270,'Sale Id shift 257623',0.00,755498.70,165.00,755498.70,0.00,'2022-05-09 17:15:14'),(1702529,'5','90',270,'Sale Id shift 257624',0.00,615530.85,165.00,615530.85,0.00,'2022-05-10 08:57:38'),(1702530,'5','90',270,'Sale Id shift 257625',0.00,567303.00,165.00,567303.00,0.00,'2022-05-12 11:16:12'),(1702531,'5','90',270,'Sale Id shift 257626',0.00,158340.60,165.00,158340.60,0.00,'2022-05-12 11:33:38'),(1702532,'5','90',270,'Sale Id shift 257630',0.00,252450.00,165.00,252450.00,0.00,'2022-05-16 09:18:05'),(1702533,'5','90',270,'Sale Id shift 257631',0.00,678844.65,165.00,678844.65,0.00,'2022-05-17 06:52:58'),(1702534,'5','90',270,'Sale Id shift 257632',0.00,967972.50,165.00,967972.50,0.00,'2022-05-18 07:12:29'),(1702535,'5','90',270,'Sale Id shift 257633',0.00,542633.85,165.00,542633.85,0.00,'2022-05-19 06:18:05'),(1702536,'5','90',270,'Sale Id shift 257638',0.00,749725.35,165.00,749725.35,0.00,'2022-05-24 06:26:38'),(1702537,'5','90',270,'Sale Id shift 257639',0.00,734032.20,165.00,734032.20,0.00,'2022-05-25 07:29:25'),(1702538,'5','90',270,'Sale Id shift 257640',0.00,628626.90,165.00,628626.90,0.00,'2022-05-26 05:39:22'),(1702539,'5','90',270,'Sale Id shift 257641',0.00,381483.30,165.00,381483.30,0.00,'2022-05-27 05:52:05'),(1702540,'5','90',270,'Sale Id shift 257665',0.00,837340.35,165.00,837340.35,0.00,'2022-06-20 06:05:22'),(1702541,'5','90',270,'Sale Id shift 257666',0.00,937907.85,165.00,937907.85,0.00,'2022-06-21 06:17:21'),(1702542,'5','90',270,'Sale Id shift 257667',0.00,650014.20,165.00,650014.20,0.00,'2022-06-23 05:33:41'),(1702543,'5','90',270,'Sale Id shift 257668',0.00,675909.30,165.00,675909.30,0.00,'2022-06-23 10:34:50'),(1702544,'5','90',270,'Sale Id shift 257669',0.00,1180147.65,165.00,1180147.65,0.00,'2022-06-24 07:01:47'),(1702545,'5','90',270,'Sale Id shift 257670',0.00,354193.95,165.00,354193.95,0.00,'2022-06-25 07:52:51'),(1702546,'5','90',270,'Sale Id shift 257671',0.00,181358.10,165.00,181358.10,0.00,'2022-06-26 08:59:53'),(1702547,'5','90',270,'Sale Id shift 257683',0.00,385349.25,165.00,385349.25,0.00,'2022-07-08 10:29:01'),(1702548,'5','90',270,'Sale Id shift 257684',0.00,532024.35,165.00,532024.35,0.00,'2022-07-09 10:52:20'),(1702549,'5','90',270,'Sale Id shift 257685',0.00,698809.65,165.00,698809.65,0.00,'2022-07-09 13:49:27'),(1702550,'5','90',270,'Sale Id shift 257686',0.00,533291.55,185.00,597932.95,64641.40,'2022-07-10 06:53:11'),(1702551,'5','90',270,'Sale Id shift 257687',0.00,240068.40,185.00,269167.60,29099.20,'2022-07-11 07:38:37'),(1702552,'5','90',270,'Sale Id shift 257692',0.00,831086.85,185.00,931824.65,100737.80,'2022-07-16 08:22:20'),(1702553,'5','90',270,'Sale Id shift 257693',0.00,1026281.95,185.00,1026281.95,0.00,'2022-07-17 06:03:49'),(1702554,'5','90',270,'Sale Id shift 257694',0.00,1136514.20,185.00,1136514.20,0.00,'2022-07-18 07:32:44'),(1702555,'5','90',270,'Sale Id shift 257695',0.00,891059.90,185.00,891059.90,0.00,'2022-07-19 05:49:41'),(1702556,'5','90',270,'Sale Id shift 257696',0.00,1900070.25,185.00,1900070.25,0.00,'2022-07-20 06:43:10'),(1702557,'5','90',270,'Sale Id shift 257697',0.00,642580.85,185.00,642580.85,0.00,'2022-07-21 07:43:50'),(1702558,'5','90',270,'Sale Id shift 257698',0.00,1337120.80,185.00,1337120.80,0.00,'2022-07-21 23:19:26'),(1702559,'5','90',270,'Sale Id shift 257699',0.00,913061.95,185.00,913061.95,0.00,'2022-07-23 07:28:58'),(1702560,'5','90',270,'Sale Id shift 257700',0.00,755743.50,185.00,755743.50,0.00,'2022-07-24 06:56:01'),(1702561,'5','90',270,'Sale Id shift 257701',0.00,969692.30,185.00,969692.30,0.00,'2022-07-25 06:41:07'),(1702562,'5','90',270,'Sale Id shift 257702',0.00,787363.70,185.00,787363.70,0.00,'2022-07-26 07:40:28'),(1702563,'5','90',270,'Sale Id shift 257