-- MySQL dump 10.13  Distrib 8.0.32, for Linux (x86_64)
--
-- Host: localhost    Database: stationmanager_company_5_station_89
-- ------------------------------------------------------
-- Server version	8.0.32-0ubuntu0.20.04.2

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `stationmanager_company_5_station_89`
--

CREATE DATABASE /*!32312 IF NOT EXISTS*/ `stationmanager_company_5_station_89` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `stationmanager_company_5_station_89`;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `account_id` int NOT NULL AUTO_INCREMENT,
  `account_code` int NOT NULL,
  `parent_id` varchar(20) NOT NULL,
  `level` int NOT NULL,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` varchar(20) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `isdefault` int NOT NULL DEFAULT '0',
  `cleanup` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`account_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`),
  KEY `cleanup` (`cleanup`)
) ENGINE=InnoDB AUTO_INCREMENT=3285 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (2178,3005,'',0,'6.1','5','89','CASH','','2020-01-08 13:42:50',5,0.00,0.00,'','397','2020-01-08 13:42:50','397',0,1),(2188,4002,'',0,'2','5','89','UBA1019882661','','2020-01-11 10:19:05',5,0.00,0.00,'','397','2020-01-11 10:19:05','397',0,1),(2189,30017,'',0,'24','5','89','PURCHASE','','2020-01-11 10:30:13',5,0.00,0.00,'','397','2020-01-11 10:30:13','397',0,1),(2211,30018,'',0,'24','5','89','SALARIES & WAGES','','2020-01-31 11:39:51',5,0.00,0.00,'','397','2020-01-31 11:39:51','397',0,1),(2212,4003,'',0,'20','5','89','SALES','','2020-01-31 11:40:45',5,0.00,0.00,'','397','2020-01-31 11:40:45','397',0,1),(3240,4027,'',0,'2','5','89','UBA-1021732970','','2021-03-06 01:39:30',5,0.00,0.00,'','600','2021-03-06 01:39:30','600',0,1),(3282,4032,'',0,'2','5','89','ZENITH BANK E-BILLS: 101665030','','2021-03-30 12:50:28',5,0.00,0.00,'','600','2021-03-30 12:50:28','600',0,1),(3283,4033,'',0,'2','5','89','JA\'IZ-0010037957','','2022-03-02 19:14:21',5,0.00,0.00,'','600','2022-03-02 19:14:21','600',0,0),(3284,2000,'',0,'6','5','89','INVENTORY VALUE ADJUSTMENT','','2023-02-06 10:39:03',5,0.00,0.00,'','600','2023-02-06 10:39:03','600',0,0);
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_status`
--

DROP TABLE IF EXISTS `accounts_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `account_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account_id` (`account_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_status`
--

LOCK TABLES `accounts_status` WRITE;
/*!40000 ALTER TABLE `accounts_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions`
--

DROP TABLE IF EXISTS `accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions` (
  `transaction_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transactiondate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `companycode` (`company_id`,`transactiondate`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions`
--

LOCK TABLES `accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounts_transactions` VALUES (2,'5','89','0000-00-00','2023-02-08 16:29:56',10,'1013','','0000-00-00 00:00:00','606','2023-02-09 15:45:14'),(3,'5','89','0000-00-00','2023-02-09 15:50:04',10,'1013','','0000-00-00 00:00:00','606','2023-02-13 16:38:22'),(4,'5','89','0000-00-00','2023-02-20 16:31:21',5,'1013','','0000-00-00 00:00:00','','0000-00-00 00:00:00'),(5,'5','89','0000-00-00','2023-02-22 13:13:22',5,'1013','','0000-00-00 00:00:00','','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_transactions_items`
--

DROP TABLE IF EXISTS `accounts_transactions_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_transactions_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `transaction_id` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `accounttype` varchar(20) NOT NULL,
  `credit` decimal(20,2) NOT NULL,
  `details` varchar(150) NOT NULL,
  `debit` decimal(20,2) NOT NULL,
  `thedate` date NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`transaction_id`,`account_id`,`debit`),
  KEY `credit` (`credit`),
  KEY `thedate` (`thedate`),
  KEY `accounttype` (`accounttype`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_transactions_items`
--

LOCK TABLES `accounts_transactions_items` WRITE;
/*!40000 ALTER TABLE `accounts_transactions_items` DISABLE KEYS */;
INSERT INTO `accounts_transactions_items` VALUES (5,'5','89','2','3284','6',16920.00,'Being AGO Price Decrease of 564 LTRS On 14/01/2023',0.00,'2023-02-08'),(6,'5','89','2','111','supplier',0.00,'Being AGO Price Decrease of 564 LTRS On 14/01/2023',16920.00,'2023-02-08'),(7,'5','89','3','3284','6',0.00,'Being PMS Price Increase of #35*1791 LTRS on 20/1/2023',62650.00,'2023-02-09'),(8,'5','89','3','111','supplier',62650.00,'Being PMS Price Increase of #35*1791 LTRS on 20/1/2023',0.00,'2023-02-09'),(9,'5','89','4','111','supplier',0.00,'Being PMS Price decrease of #10*1470 LTRS on 19/2/2023',14700.00,'2023-02-20'),(10,'5','89','4','3284','6',14700.00,'Being PMS Price decrease of #10*1470 LTRS on 19/2/2023',0.00,'2023-02-20'),(11,'5','89','5','111','supplier',0.00,'Being AGO Price Decrease of #10 * 507 LTRS  On 21/02/2023',5070.00,'2023-02-22'),(12,'5','89','5','3284','6',5070.00,'Being AGO Price Decrease of #10 * 507 LTRS  On 21/02/2023',0.00,'2023-02-22');
/*!40000 ALTER TABLE `accounts_transactions_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers`
--

DROP TABLE IF EXISTS `accounts_vouchers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers` (
  `voucher_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucherdate` date NOT NULL,
  `voucherno` varchar(20) NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  PRIMARY KEY (`voucher_id`),
  KEY `companycode` (`company_id`,`voucherdate`,`voucherno`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers`
--

LOCK TABLES `accounts_vouchers` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `accounts_vouchers_items`
--

DROP TABLE IF EXISTS `accounts_vouchers_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts_vouchers_items` (
  `item_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `voucher_id` int NOT NULL,
  `account_id` int NOT NULL,
  `description` varchar(150) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `companycode` (`company_id`,`voucher_id`,`account_id`,`amount`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts_vouchers_items`
--

LOCK TABLES `accounts_vouchers_items` WRITE;
/*!40000 ALTER TABLE `accounts_vouchers_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts_vouchers_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `asset_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `category_id` varchar(20) NOT NULL,
  `location_id` varchar(20) NOT NULL,
  `name` varchar(100) NOT NULL,
  `bought_from` varchar(300) NOT NULL,
  `serial` varchar(100) NOT NULL,
  `purchase_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `depreciation` decimal(20,2) NOT NULL,
  `period` int NOT NULL,
  `depreciation_type` int NOT NULL DEFAULT '0',
  `cost_price` decimal(20,2) NOT NULL,
  `current_price` decimal(20,2) NOT NULL,
  `replace_price` decimal(20,2) NOT NULL,
  `salvage` decimal(20,2) NOT NULL,
  `caption` varchar(100) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`asset_id`),
  KEY `companycode` (`company_id`,`category_id`,`location_id`,`name`,`serial`,`purchase_date`,`expiry_date`,`status`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_categories`
--

DROP TABLE IF EXISTS `assets_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_categories` (
  `category_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `period` int NOT NULL,
  `account_id` varchar(20) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `companycode` (`company_id`,`name`),
  KEY `account_id` (`account_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_categories`
--

LOCK TABLES `assets_categories` WRITE;
/*!40000 ALTER TABLE `assets_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assets_locations`
--

DROP TABLE IF EXISTS `assets_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_locations` (
  `location_id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `assets_locations`
--

LOCK TABLES `assets_locations` WRITE;
/*!40000 ALTER TABLE `assets_locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendants`
--

DROP TABLE IF EXISTS `attendants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendants` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `attendant_id` int NOT NULL AUTO_INCREMENT,
  `surname` varchar(30) NOT NULL,
  `firstname` varchar(30) NOT NULL,
  `othernames` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `country` varchar(30) NOT NULL,
  `nok_name` varchar(50) NOT NULL,
  `nok_phone` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(400) NOT NULL,
  `manager` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '5',
  `lastlogin` datetime NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`attendant_id`),
  KEY `companycode` (`company_id`,`station_id`,`surname`,`firstname`,`username`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendants`
--

LOCK TABLES `attendants` WRITE;
/*!40000 ALTER TABLE `attendants` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers` (
  `customer_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `companyname` varchar(30) NOT NULL,
  `contactperson` varchar(30) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `email` varchar(30) NOT NULL,
  `city` varchar(30) NOT NULL,
  `state` varchar(30) NOT NULL,
  `address` varchar(200) NOT NULL,
  `country` text NOT NULL,
  `creditlimit` decimal(20,2) NOT NULL,
  `creditbalance` decimal(20,2) NOT NULL,
  `debitbalance` decimal(20,2) NOT NULL,
  `balancedate` date NOT NULL,
  `thedate` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  `createdby` varchar(20) NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`customer_id`),
  KEY `companycode` (`company_id`,`companyname`,`contactperson`,`phone`,`email`,`city`,`state`),
  KEY `type` (`type`),
  KEY `creditlimit` (`creditlimit`),
  KEY `depot_id` (`station_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2378 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers`
--

LOCK TABLES `customers` WRITE;
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` VALUES (2345,'','5','89','SAJ FOODS LTD','HAMISU ISA','08033815272','abumusab320@gmail.com','ZARIA','KADUNA','SAJ FOOD RAILWAY BRANCH ','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-16 16:23:47',5,'600','2021-03-16 16:23:47','600'),(2377,'','5','89','ZENITH BANK PLC, ZARIA BRANCH','ABUBAKAR ABDULLAHI','07039759996','abubakar.abdullahi@zenithbank.','ZARIA','KADUNA','F3, KADUNA ROAD, PZ AREA.','Nigeria',0.00,0.00,0.00,'0000-00-00','2021-03-22 14:32:25',5,'600','2021-03-22 14:32:25','600');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customers_status`
--

DROP TABLE IF EXISTS `customers_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customers_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `customer_id` varchar(20) NOT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customers_status`
--

LOCK TABLES `customers_status` WRITE;
/*!40000 ALTER TABLE `customers_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `customers_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_dippings`
--

DROP TABLE IF EXISTS `depots_dippings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_dippings` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `dipping_id` int NOT NULL AUTO_INCREMENT,
  `tank_id` varchar(20) NOT NULL,
  `tank_reading` decimal(20,2) NOT NULL,
  `level` decimal(20,2) NOT NULL,
  `dippingdate` date NOT NULL,
  `details` text NOT NULL,
  `thedate` datetime NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `modifiedon` int NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`dipping_id`),
  KEY `companycode` (`company_id`,`station_id`,`tank_id`,`dippingdate`)
) ENGINE=InnoDB AUTO_INCREMENT=17926 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_dippings`
--

LOCK TABLES `depots_dippings` WRITE;
/*!40000 ALTER TABLE `depots_dippings` DISABLE KEYS */;
INSERT INTO `depots_dippings` VALUES ('5','89',17720,'664',8974.29,8095.00,'2021-11-21','','2021-11-21 21:49:04','397','397',2021,'397','2021-11-21 21:49:04',5),('5','89',17721,'662',370.34,750.00,'2021-11-21','','2021-11-21 21:59:45','397','397',2021,'397','2021-11-21 21:59:45',5),('5','89',17905,'662',4602.25,5128.00,'2021-12-03','','2021-12-03 21:46:13','397','397',2021,'397','2021-12-03 21:46:13',5),('5','89',17906,'663',2018.60,486.00,'2022-02-16','','2022-02-16 14:56:28','600','600',2022,'600','2022-02-16 14:56:28',5),('5','89',17907,'662',3411.46,5000.00,'2022-03-15','','2022-03-15 20:41:26','600','600',2022,'600','2022-03-15 20:41:26',5),('5','89',17908,'662',1832.59,1985.00,'2022-07-24','','2022-07-24 22:24:16','397','397',2022,'397','2022-07-24 22:24:16',5),('5','89',17909,'662',6293.72,7565.00,'2022-09-08','','2022-09-08 10:14:47','397','397',2022,'397','2022-09-08 10:14:47',5),('5','89',17910,'662',5443.83,6655.00,'2022-08-31','','2022-09-09 15:03:43','397','397',2022,'397','2022-09-09 15:03:43',5),('5','89',17911,'662',0.05,8930.00,'2022-09-11','','2022-09-11 15:16:35','600','600',2022,'600','2022-09-11 15:16:35',5),('5','89',17912,'662',2120.01,2173.00,'2022-09-02','','2022-09-11 21:20:56','397','397',2022,'397','2022-09-11 21:20:56',5),('5','89',17913,'663',11609.74,626.00,'2022-09-10','','2022-09-13 18:07:13','397','397',2022,'397','2022-09-13 18:07:13',5),('5','89',17914,'662',7227.39,7850.00,'2022-09-25','','2022-09-26 10:55:29','397','397',2022,'397','2022-09-26 10:55:29',5),('5','89',17915,'662',7024.88,7150.00,'2022-10-17','','2022-10-19 13:15:10','397','397',2022,'397','2022-10-19 13:15:10',5),('5','89',17916,'662',9012.53,9200.00,'2022-10-21','','2022-10-21 22:28:30','397','397',2022,'397','2022-10-21 22:28:30',5),('5','89',17917,'662',1358.76,2000.00,'2022-10-30','','2022-11-01 10:56:17','397','397',2022,'397','2022-11-01 10:56:17',5),('5','89',17918,'663',5524.87,6023.00,'2022-11-07','','2022-11-07 09:48:29','397','397',2022,'397','2022-11-07 09:48:29',5),('5','89',17919,'662',6426.28,7000.00,'2022-11-07','','2022-11-08 08:46:48','397','397',2022,'397','2022-11-08 08:46:48',5),('5','89',17920,'662',1280.45,1500.00,'2022-11-20','','2022-11-20 22:26:48','397','397',2022,'397','2022-11-20 22:26:48',5),('5','89',17921,'662',2587.70,3100.00,'2022-12-04','','2022-12-04 21:40:32','397','397',2022,'397','2022-12-04 21:40:32',5),('5','89',17922,'662',11940.86,12000.00,'2022-12-09','','2022-12-09 11:54:54','600','600',2022,'600','2022-12-09 11:54:54',5),('5','89',17923,'662',19155.56,5600.00,'2023-01-16','','2023-01-16 11:39:41','600','600',2023,'600','2023-01-16 11:39:41',5),('5','89',17924,'663',7273.63,20000.00,'2023-01-16','','2023-01-16 11:40:00','600','600',2023,'600','2023-01-16 11:40:00',5),('5','89',17925,'662',342.39,1700.00,'2023-03-06','','2023-03-06 11:49:20','600','600',2023,'600','2023-03-06 11:49:20',5);
/*!40000 ALTER TABLE `depots_dippings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles`
--

DROP TABLE IF EXISTS `depots_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `nozzle_id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `reading` decimal(20,2) NOT NULL,
  `description` varchar(150) NOT NULL,
  `pump_id` varchar(20) DEFAULT NULL,
  `pts_id` varchar(20) DEFAULT NULL,
  `pts_pump` varchar(20) DEFAULT NULL,
  `pts_nozzle` varchar(20) DEFAULT NULL,
  `status` int NOT NULL DEFAULT '5',
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  PRIMARY KEY (`nozzle_id`),
  KEY `companycode` (`company_id`,`tank_id`,`type`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `modifiedby` (`modifiedby`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=1824 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles`
--

LOCK TABLES `depots_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_nozzles` DISABLE KEYS */;
INSERT INTO `depots_nozzles` VALUES ('5','89','663',1809,'5','PUMP 5',2633639.69,'PMS PUMP 5','',NULL,NULL,'',5,'2021-03-01 12:56:53','600'),('5','89','663',1810,'5','PUMP 6',1164886.48,'PMS PUMP 6','',NULL,NULL,'',5,'2022-10-18 12:23:32','600'),('5','89','662',1811,'5','PUMP 3',2649750.81,'PMS PUMP 3','',NULL,NULL,'',5,'2021-03-01 12:42:22','600'),('5','89','664',1812,'5','PUMP 4',1454606.00,'PMS PUMP 4','',NULL,NULL,'',5,'2021-03-01 12:59:46','600'),('5','89','664',1813,'5','PUMP 9',609161.45,'PMS PUMP 9',NULL,NULL,NULL,NULL,5,'2020-02-06 11:42:28','397'),('5','89','664',1814,'5','PUMP 10',682633.74,'PMS PUMP 10',NULL,NULL,NULL,NULL,5,'2020-02-03 14:01:23','397'),('5','89','664',1815,'5','PUMP 11',843903.59,'PMS PUMP 11',NULL,NULL,NULL,NULL,5,'2020-02-03 14:03:36','397'),('5','89','664',1816,'5','PUMP 12',440976.92,'PMS PUMP 12',NULL,NULL,NULL,NULL,5,'2020-02-03 14:04:48','397'),('5','89','662',1817,'5','PUMP 1',1746724.49,'PMS PUMP 1','',NULL,NULL,'',5,'2022-09-07 17:08:09','600'),('5','89','662',1818,'5','PUMP 2',266154.94,'PMS PUMP 2','',NULL,NULL,'',5,'2022-09-07 16:53:05','600'),('5','89','665',1819,'5','PUMP 7',0.00,'PMS PUMP 7',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','89','665',1820,'5','PUMP 8',0.00,'PMS PUMP 8',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','89','666',1821,'5','PUMP 14',487520.22,'AGO PUMP 14','',NULL,NULL,'',5,'2021-03-01 13:01:24','600'),('5','89','666',1822,'5','PUMP 14 B',0.00,'AGO PUMP 14',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00',''),('5','89','667',1823,'5','PUMP 15',0.00,'DPK PUMP 15',NULL,NULL,NULL,NULL,5,'0000-00-00 00:00:00','');
/*!40000 ALTER TABLE `depots_nozzles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_status`
--

DROP TABLE IF EXISTS `depots_nozzles_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_status` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `status` int NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `companycode` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_status`
--

LOCK TABLES `depots_nozzles_status` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_status` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_nozzles_status` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_nozzles_tanks`
--

DROP TABLE IF EXISTS `depots_nozzles_tanks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_nozzles_tanks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `reason` text NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedby_type` int NOT NULL,
  `modifiedby_id` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dispenser_id` (`nozzle_id`),
  KEY `dispenser_id_2` (`nozzle_id`),
  KEY `depot_id` (`station_id`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_nozzles_tanks`
--

LOCK TABLES `depots_nozzles_tanks` WRITE;
/*!40000 ALTER TABLE `depots_nozzles_tanks` DISABLE KEYS */;
INSERT INTO `depots_nozzles_tanks` VALUES (118,'5','89','1817','662','misplacing','2021-03-01 12:40:21',0,'600'),(119,'5','89','1818','662','misplacing','2021-03-01 12:41:37',0,'600'),(120,'5','89','1811','662','misplacing','2021-03-01 12:42:41',0,'600'),(121,'5','89','1809','663','misplacing','2021-03-01 12:57:20',0,'600'),(122,'5','89','1810','663','misplacing','2021-03-01 12:58:35',0,'600'),(123,'5','89','1812','664','misplacing','2021-03-01 13:00:05',0,'600');
/*!40000 ALTER TABLE `depots_nozzles_tanks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_pumps`
--

DROP TABLE IF EXISTS `depots_pumps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_pumps` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `pump_id` int NOT NULL AUTO_INCREMENT,
  `manufacturer` varchar(50) NOT NULL DEFAULT '0',
  `model` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `pts_id` varchar(30) NOT NULL,
  `pts_pump` varchar(20) NOT NULL,
  `description` varchar(150) NOT NULL,
  `createdby` varchar(20) NOT NULL,
  `thedate` datetime NOT NULL,
  `modifiedon` datetime NOT NULL,
  `modifiedby` varchar(20) NOT NULL,
  `status` int NOT NULL DEFAULT '5',
  PRIMARY KEY (`pump_id`),
  KEY `companycode` (`company_id`,`model`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `tank_type` (`manufacturer`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_pumps`
--

LOCK TABLES `depots_pumps` WRITE;
/*!40000 ALTER TABLE `depots_pumps` DISABLE KEYS */;
/*!40000 ALTER TABLE `depots_pumps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts`
--

DROP TABLE IF EXISTS `depots_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `shift_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `thedate` date NOT NULL,
  `createdon` datetime DEFAULT NULL,
  `expirydate` datetime DEFAULT NULL,
  `createdby` varchar(20) NOT NULL,
  `cost` decimal(20,2) DEFAULT '0.00',
  `revenue` decimal(20,2) DEFAULT '0.00',
  `closedby` varchar(20) NOT NULL,
  `closedon` datetime NOT NULL,
  `approvedby` varchar(20) NOT NULL,
  `approvedon` datetime NOT NULL,
  `status` int NOT NULL,
  `is_remitted` int NOT NULL DEFAULT '0',
  UNIQUE KEY `shift_id` (`shift_id`),
  KEY `companycode` (`company_id`,`station_id`,`name`),
  KEY `depot_id` (`station_id`),
  KEY `createdon` (`createdon`,`expirydate`),
  KEY `is_remitted` (`is_remitted`)
) ENGINE=InnoDB AUTO_INCREMENT=258014 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts`
--

LOCK TABLES `depots_shifts` WRITE;
/*!40000 ALTER TABLE `depots_shifts` DISABLE KEYS */;
INSERT INTO `depots_shifts` VALUES ('5','89',232493,'DALY SHIFT','2021-10-02','2021-10-02 00:00:00',NULL,'397',985987.00,985987.00,'397','2021-10-18 14:30:36','608','2021-10-18 14:34:31',10,0),('5','89',232496,'DALY SHIFT','2021-10-03','2021-10-03 00:00:00',NULL,'397',1095457.80,1095457.80,'397','2021-10-18 15:02:25','608','2021-10-19 20:23:06',10,0),('5','89',232786,'DALY SHIFT','2021-10-04','2021-10-04 00:00:00',NULL,'397',1438372.31,1438372.31,'397','2021-10-19 20:38:50','608','2021-10-19 20:41:05',10,0),('5','89',232795,'DALY SHIFT','2021-10-05','2021-10-05 00:00:00',NULL,'397',1150706.65,1150706.65,'397','2021-10-19 20:49:54','608','2021-10-19 20:51:17',10,0),('5','89',232799,'DALY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'397',0.00,0.00,'397','2021-10-19 20:58:32','608','2021-10-19 21:03:18',10,0),('5','89',232802,'DALY SHIFT','2021-10-06','2021-10-06 00:00:00',NULL,'397',1206969.36,1206969.36,'397','2021-10-19 21:13:55','608','2021-10-19 21:27:41',10,0),('5','89',232805,'DALY SHIFT','2021-10-07','2021-10-07 00:00:00',NULL,'397',538406.93,538406.93,'397','2021-10-19 21:40:37','608','2021-10-19 21:50:22',10,0),('5','89',232925,'DALY SHIFT','2021-10-10','2021-10-10 00:00:00',NULL,'397',1227773.05,1227773.05,'397','2021-10-20 09:41:07','608','2021-10-20 09:42:19',10,0),('5','89',232933,'DALY SHIFT','2021-10-11','2021-10-11 00:00:00',NULL,'397',1414377.08,1414377.08,'397','2021-10-20 09:56:38','608','2021-10-20 10:09:16',10,0),('5','89',232984,'DALY SHIFT','2021-10-12','2021-10-12 00:00:00',NULL,'397',1397516.36,1397516.36,'397','2021-10-20 12:58:20','608','2021-10-20 13:00:23',10,0),('5','89',232989,'DALY SHIFT','2021-10-13','2021-10-13 00:00:00',NULL,'397',1241851.36,1241851.36,'397','2021-10-20 13:07:33','608','2021-10-20 13:09:17',10,0),('5','89',232995,'DALY SHIFT','2021-10-14','2021-10-14 00:00:00',NULL,'397',1362122.54,1362122.54,'397','2021-10-20 13:27:05','608','2021-10-20 14:11:20',10,0),('5','89',233022,'DALY SHIFT','2021-10-15','2021-10-15 00:00:00',NULL,'397',1267996.56,1267996.56,'397','2021-10-20 14:19:58','608','2021-10-20 14:21:22',10,0),('5','89',233024,'DALY SHIFT','2021-10-16','2021-10-16 00:00:00',NULL,'397',957924.92,957924.92,'397','2021-10-20 14:27:32','608','2021-10-21 09:38:35',10,0),('5','89',233194,'DALY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'397',0.00,0.00,'397','2021-10-21 09:43:02','608','2021-10-21 09:45:43',10,0),('5','89',233195,'DALY SHIFT','2021-10-17','2021-10-17 00:00:00',NULL,'397',952901.26,952901.26,'397','2021-10-21 09:51:12','608','2021-10-21 09:53:28',10,0),('5','89',233197,'DALY SHIFT','2021-10-18','2021-10-18 00:00:00',NULL,'397',1333268.28,1333268.28,'397','2021-10-21 09:59:10','608','2021-10-21 10:02:27',10,0),('5','89',233201,'DALY SHIFT','2021-10-19','2021-10-19 00:00:00',NULL,'397',1246107.29,1246107.29,'397','2021-10-21 10:36:17','608','2021-10-21 10:37:56',10,0),('5','89',233217,'DALY SHIFT','2021-10-20','2021-10-20 00:00:00',NULL,'397',1442465.24,1442465.24,'397','2021-10-21 10:44:10','608','2021-10-21 10:45:43',10,0),('5','89',233341,'DALY SHIFT','2021-10-21','2021-10-21 00:00:00',NULL,'397',1542457.59,1542457.59,'397','2021-10-21 21:52:21','608','2021-10-22 06:28:59',10,0),('5','89',233389,'DALY SHIFT','2021-10-22','2021-10-22 00:00:00',NULL,'397',1571830.19,1571830.19,'397','2021-10-22 22:11:13','608','2021-10-23 09:06:05',10,0),('5','89',233725,'DALY SHIFT','2021-10-23','2021-10-23 00:00:00',NULL,'397',1167764.60,1167764.60,'397','2021-10-23 21:05:45','608','2021-10-24 13:34:44',10,0),('5','89',233956,'DALY SHIFT','2021-10-24','2021-10-24 00:00:00',NULL,'397',1155978.07,1155978.07,'397','2021-10-24 21:44:01','608','2021-10-25 20:06:22',10,0),('5','89',234278,'DALY SHIFT','2021-10-25','2021-10-25 00:00:00',NULL,'397',1540811.29,1540811.29,'397','2021-10-25 20:36:04','608','2021-10-26 18:25:31',10,0),('5','89',234545,'DALY SHIFT','2021-10-26','2021-10-26 00:00:00',NULL,'397',1520732.95,1520732.95,'397','2021-10-26 22:49:18','608','2021-10-28 15:55:07',10,0),('5','89',235034,'DALY SHIFT','2021-10-27','2021-10-27 00:00:00',NULL,'397',643450.65,651345.75,'397','2021-10-28 21:04:29','608','2021-10-28 21:29:51',10,0),('5','89',235037,'DALY SHIFT','2021-10-28','2021-10-28 00:00:00',NULL,'397',0.00,0.00,'397','2021-10-28 21:46:30','608','2021-10-29 22:15:05',10,0),('5','89',235277,'DALY SHIFT','2021-10-29','2021-10-29 00:00:00',NULL,'397',0.00,0.00,'397','2021-10-29 22:20:04','608','2021-10-30 13:26:41',10,0),('5','89',235491,'DALY SHIFT','2021-10-30','2021-10-30 00:00:00',NULL,'397',0.00,0.00,'397','2021-10-30 20:39:42','608','2021-10-31 18:07:59',10,0),('5','89',235833,'DALY SHIFT','2021-10-31','2021-10-31 00:00:00',NULL,'397',865306.20,865306.20,'397','2021-11-01 08:44:07','608','2021-11-02 16:26:26',10,0),('5','89',236182,'DALY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'397',2653645.50,2653645.50,'','0000-00-00 00:00:00','','0000-00-00 00:00:00',1,0),('5','89',236605,'DALY SHIFT','2021-11-01','2021-11-01 00:00:00',NULL,'397',2653645.50,2653645.50,'397','2021-11-04 10:44:20','608','2021-11-04 11:21:10',10,0),('5','89',236612,'DALY SHIFT','2021-11-02','2021-11-02 00:00:00',NULL,'397',2495347.80,2495347.80,'397','2021-11-04 11:27:04','608','2021-11-04 11:42:13',10,0),('5','89',236614,'DALY SHIFT','2021-11-03','2021-11-03 00:00:00',NULL,'397',628300.20,628300.20,'397','2021-11-04 11:50:23','608','2021-11-04 11:52:48',10,0),('5','89',236620,'DALY SHIFT','2021-11-04','2021-11-04 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-04 21:52:43','608','2021-11-05 15:58:19',10,0),('5','89',236929,'DALY SHIFT','2021-11-05','2021-11-05 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-05 22:07:25','608','2021-11-08 14:15:23',10,0),('5','89',237843,'DALY SHIFT','2021-11-06','2021-11-06 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-09 23:01:52','608','2021-11-10 20:43:09',10,0),('5','89',238079,'DALY SHIFT','2021-11-07','2021-11-07 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-10 20:51:34','608','2021-11-10 20:53:37',10,0),('5','89',238080,'DALY SHIFT','2021-11-08','2021-11-08 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-10 20:56:13','608','2021-11-10 20:56:48',10,0),('5','89',238083,'DALY SHIFT','2021-11-09','2021-11-09 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-10 21:02:17','608','2021-11-10 21:06:22',10,0),('5','89',238084,'DALY SHIFT','2021-11-10','2021-11-10 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-10 21:08:51','608','2021-11-10 21:21:16',10,0),('5','89',238183,'DALY SHIFT','2021-11-11','2021-11-11 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-12 05:43:18','608','2021-11-12 09:55:59',10,0),('5','89',238579,'DALY SHIFT','2021-11-12','2021-11-12 00:00:00',NULL,'397',2066573.85,2066573.85,'397','2021-11-12 22:43:18','608','2021-11-14 11:07:06',10,0),('5','89',238919,'DALY SHIFT','2021-11-13','2021-11-13 00:00:00',NULL,'397',1625223.60,1625223.60,'397','2021-11-14 12:05:38','608','2021-11-14 19:31:11',10,0),('5','89',239038,'DALY SHIFT','2021-11-14','2021-11-14 00:00:00',NULL,'397',1054095.90,1054095.90,'397','2021-11-14 22:49:08','608','2021-11-15 11:02:28',10,0),('5','89',239222,'DALY SHIFT','2021-11-15','2021-11-15 00:00:00',NULL,'397',219991.20,219991.20,'397','2021-11-15 22:44:37','608','2021-11-16 14:54:44',10,0),('5','89',239485,'DALY SHIFT','2021-11-16','2021-11-16 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-16 20:42:47','608','2021-11-17 18:56:17',10,0),('5','89',239732,'DALY SHIFT','2021-11-17','2021-11-17 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-17 21:04:49','608','2021-11-19 21:57:21',10,0),('5','89',240204,'DALY SHIFT','2021-11-18','2021-11-18 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-20 06:23:45','608','2021-11-20 10:38:54',10,0),('5','89',240282,'DALY SHIFT','2021-11-19','2021-11-19 00:00:00',NULL,'397',1341692.55,1341692.55,'397','2021-11-20 11:51:01','608','2021-11-21 09:41:23',10,0),('5','89',240513,'DALY SHIFT','2021-11-20','2021-11-20 00:00:00',NULL,'397',1538247.15,1538247.15,'397','2021-11-21 09:52:55','608','2021-11-21 09:57:11',10,0),('5','89',240524,'DALY SHIFT','2021-11-21','2021-11-21 00:00:00',NULL,'397',1459302.90,1459302.90,'397','2021-11-21 22:03:24','608','2021-11-22 10:37:17',10,0),('5','89',240954,'DALY SHIFT','2021-11-22','2021-11-22 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-23 05:16:18','608','2021-11-23 06:06:53',10,0),('5','89',241083,'DALY SHIFT','2021-11-23','2021-11-23 00:00:00',NULL,'397',1557413.55,1557413.55,'397','2021-11-23 21:32:37','608','2021-11-24 20:50:37',10,0),('5','89',241460,'DALY SHIFT','2021-11-24','2021-11-24 00:00:00',NULL,'397',2146222.65,2146222.65,'397','2021-11-24 22:19:51','608','2021-11-26 20:49:57',10,0),('5','89',241938,'DALY SHIFT','2021-11-25','2021-11-25 00:00:00',NULL,'397',1776947.70,1776947.70,'397','2021-11-26 21:33:02','608','2021-11-29 14:28:30',10,0),('5','89',242617,'DALY SHIFT','2021-11-26','2021-11-26 00:00:00',NULL,'397',1650344.85,1650344.85,'397','2021-11-29 19:23:37','608','2021-11-30 09:24:13',10,0),('5','89',242760,'DALY SHIFT','2021-11-27','2021-11-27 00:00:00',NULL,'397',302940.00,302940.00,'397','2021-11-30 09:28:55','608','2021-11-30 09:30:08',10,0),('5','89',242764,'DALY SHIFT','2021-11-28','2021-11-28 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-30 09:37:31','608','2021-11-30 09:38:34',10,0),('5','89',242767,'DALY SHIFT','2021-11-29','2021-11-29 00:00:00',NULL,'397',0.00,0.00,'397','2021-11-30 09:41:38','608','2021-11-30 09:43:05',10,0),('5','89',242771,'DALY SHIFT','2021-11-30','2021-11-30 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-01 04:46:02','608','2021-12-02 17:44:48',10,0),('5','89',243336,'DALY SHIFT','2021-12-01','2021-12-01 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-03 00:54:13','608','2021-12-03 10:54:03',10,0),('5','89',243463,'DALY SHIFT','2021-12-02','2021-12-02 00:00:00',NULL,'397',2365275.00,2365275.00,'397','2021-12-03 11:40:21','608','2021-12-03 12:24:28',10,0),('5','89',243479,'DALY SHIFT','2021-12-03','2021-12-03 00:00:00',NULL,'397',2556564.45,2556564.45,'397','2021-12-03 21:56:09','608','2021-12-04 19:41:08',10,0),('5','89',243782,'DALY SHIFT','2021-12-04','2021-12-04 00:00:00',NULL,'397',2084319.60,2084319.60,'397','2021-12-04 22:11:40','608','2021-12-05 20:28:10',10,0),('5','89',244020,'DALY SHIFT','2021-12-05','2021-12-05 00:00:00',NULL,'397',1952669.40,1952669.40,'397','2021-12-05 22:10:54','608','2021-12-06 08:48:35',10,0),('5','89',244205,'DALY SHIFT','2021-12-06','2021-12-06 00:00:00',NULL,'397',865321.05,865321.05,'397','2021-12-07 03:13:31','608','2021-12-07 17:06:08',10,0),('5','89',244460,'DALY SHIFT','2021-12-07','2021-12-07 00:00:00',NULL,'397',764103.45,764103.45,'397','2021-12-07 21:14:55','608','2021-12-08 20:53:54',10,0),('5','89',244719,'DALY SHIFT','2021-12-08','2021-12-08 00:00:00',NULL,'397',2023795.95,2023795.95,'397','2021-12-09 00:57:36','608','2021-12-09 20:49:44',10,0),('5','89',244945,'DALY SHIFT','2021-12-09','2021-12-09 00:00:00',NULL,'397',1801232.40,1801232.40,'397','2021-12-09 21:29:09','608','2021-12-09 21:42:00',10,0),('5','89',245314,'DALY SHIFT','2021-12-10','2021-12-10 00:00:00',NULL,'397',1640370.60,1640370.60,'397','2021-12-12 13:00:53','604','2021-12-12 17:08:22',10,0),('5','89',245649,'DALY SHIFT','2021-12-11','2021-12-11 00:00:00',NULL,'397',300656.40,300656.40,'397','2021-12-12 21:19:44','608','2021-12-12 21:22:15',10,0),('5','89',245816,'DALY SHIFT','2021-12-12','2021-12-12 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-13 14:15:51','608','2021-12-14 08:38:33',10,0),('5','89',246090,'DALY SHIFT','2021-12-13','2021-12-13 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-14 14:31:07','608','2021-12-14 22:17:39',10,0),('5','89',246262,'DALY SHIFT','2021-12-14','2021-12-14 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-15 09:05:52','608','2021-12-15 09:08:06',10,0),('5','89',246266,'DALY SHIFT','2021-12-15','2021-12-15 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-16 06:37:44','608','2021-12-16 09:04:00',10,0),('5','89',246581,'DALY SHIFT','2021-12-16','2021-12-16 00:00:00',NULL,'397',1314665.55,1314665.55,'397','2021-12-16 22:15:38','608','2021-12-17 16:46:37',10,0),('5','89',246913,'DALY SHIFT','2021-12-17','2021-12-17 00:00:00',NULL,'397',1536872.70,1536872.70,'397','2021-12-18 00:32:01','608','2021-12-18 17:40:39',10,0),('5','89',247119,'DALY SHIFT','2021-12-18','2021-12-18 00:00:00',NULL,'397',2039942.85,2039942.85,'397','2021-12-19 02:06:49','608','2021-12-19 18:42:49',10,0),('5','89',247372,'DALY SHIFT','2021-12-19','2021-12-19 00:00:00',NULL,'397',1420940.40,1420940.40,'397','2021-12-19 21:39:28','608','2021-12-20 09:15:38',10,0),('5','89',247636,'DALY SHIFT','2021-12-20','2021-12-20 00:00:00',NULL,'397',836472.45,836472.45,'397','2021-12-20 22:21:47','608','2021-12-21 15:47:45',10,0),('5','89',247882,'DALY SHIFT','2021-12-21','2021-12-21 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-21 22:38:54','608','2021-12-22 10:36:29',10,0),('5','89',248217,'DALY SHIFT','2021-12-22','2021-12-22 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-23 08:10:24','608','2021-12-25 13:02:49',10,0),('5','89',248831,'DALY SHIFT','2021-12-23','2021-12-23 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-25 19:08:04','608','2021-12-26 17:54:01',10,0),('5','89',249056,'DALY SHIFT','2021-12-24','2021-12-24 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-26 19:11:31','608','2021-12-29 10:10:44',10,0),('5','89',249743,'DALY SHIFT','2021-12-25','2021-12-25 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-29 13:52:43','608','2021-12-29 13:55:53',10,0),('5','89',249762,'DALY SHIFT','2021-12-26','2021-12-26 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-29 15:12:12','608','2021-12-30 18:29:43',10,0),('5','89',250150,'DALY SHIFT','2021-12-27','2021-12-27 00:00:00',NULL,'397',0.00,0.00,'397','2021-12-31 07:52:34','608','2021-12-31 20:48:24',10,0),('5','89',250430,'DALY SHIFT','2021-12-28','2021-12-28 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-01 11:54:34','608','2022-01-02 14:18:04',10,0),('5','89',250702,'DALY SHIFT','2021-12-29','2021-12-29 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-02 14:29:28','608','2022-01-02 14:32:34',10,0),('5','89',250706,'DALY SHIFT','2021-12-30','2021-12-30 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-02 14:34:31','608','2022-01-02 14:35:27',10,0),('5','89',250708,'DALY SHIFT','2021-12-31','2021-12-31 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-02 14:37:29','608','2022-01-02 14:38:24',10,0),('5','89',250711,'DALY SHIFT','2022-01-01','2022-01-01 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-02 14:39:57','608','2022-01-02 14:40:38',10,0),('5','89',250714,'DALY SHIFT','2022-01-02','2022-01-02 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-02 17:22:37','608','2022-01-04 09:05:27',10,0),('5','89',251119,'DALY SHIFT','2022-01-03','2022-01-03 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-04 11:07:26','608','2022-01-05 10:46:59',10,0),('5','89',251439,'DALY SHIFT','2022-01-04','2022-01-04 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-05 17:21:52','608','2022-01-05 18:16:16',10,0),('5','89',251454,'DALY SHIFT','2022-01-05','2022-01-05 00:00:00',NULL,'397',982410.00,982410.00,'397','2022-01-06 08:27:20','608','2022-01-06 18:16:36',10,0),('5','89',251714,'DALY SHIFT','2022-01-06','2022-01-06 00:00:00',NULL,'397',2267753.40,2267753.40,'397','2022-01-07 00:00:28','608','2022-01-07 12:28:13',10,0),('5','89',251889,'DALY SHIFT','2022-01-07','2022-01-07 00:00:00',NULL,'397',2172904.80,2172904.80,'397','2022-01-08 00:04:50','608','2022-01-08 19:17:12',10,0),('5','89',252223,'DALY SHIFT','2022-01-08','2022-01-08 00:00:00',NULL,'397',1951387.35,1951387.35,'397','2022-01-09 05:35:08','608','2022-01-09 18:39:03',10,0),('5','89',252569,'DALY SHIFT','2022-01-09','2022-01-09 00:00:00',NULL,'397',1559256.60,1559256.60,'397','2022-01-10 12:04:26','608','2022-01-10 14:48:34',10,0),('5','89',252622,'DALY SHIFT','2022-01-10','2022-01-10 00:00:00',NULL,'397',1465254.45,1465254.45,'397','2022-01-10 20:20:53','608','2022-01-11 14:33:53',10,0),('5','89',252912,'DALY SHIFT','2022-01-11','2022-01-11 00:00:00',NULL,'397',1254767.25,1254767.25,'397','2022-01-11 23:22:51','608','2022-01-12 16:26:23',10,0),('5','89',253131,'DALY SHIFT','2022-01-12','2022-01-12 00:00:00',NULL,'397',961336.20,961336.20,'397','2022-01-12 22:25:35','608','2022-01-13 09:27:05',10,0),('5','89',253467,'DALY SHIFT','2022-01-13','2022-01-13 00:00:00',NULL,'397',1137811.95,1137811.95,'397','2022-01-14 06:36:46','608','2022-01-14 10:46:46',10,0),('5','89',253605,'DALY SHIFT','2022-01-14','2022-01-14 00:00:00',NULL,'397',1756093.35,1756093.35,'397','2022-01-15 08:01:22','608','2022-01-15 09:36:56',10,0),('5','89',253878,'DALY SHIFT','2022-01-15','2022-01-15 00:00:00',NULL,'397',1238879.40,1238879.40,'397','2022-01-15 23:13:34','608','2022-01-16 10:49:16',10,0),('5','89',254057,'DALY SHIFT','2022-01-16','2022-01-16 00:00:00',NULL,'397',1447713.30,1447713.30,'397','2022-01-16 22:53:57','608','2022-01-17 09:59:08',10,0),('5','89',254426,'DALY SHIFT','2022-01-17','2022-01-17 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-17 23:23:44','608','2022-01-18 15:53:38',10,0),('5','89',254747,'DALY SHIFT','2022-01-18','2022-01-18 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-19 08:36:01','608','2022-01-19 10:03:40',10,0),('5','89',254892,'DALY SHIFT','2022-01-19','2022-01-19 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-19 18:57:15','608','2022-01-20 07:18:23',10,0),('5','89',255182,'DALY SHIFT','2022-01-20','2022-01-20 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-21 06:27:36','608','2022-01-21 11:18:23',10,0),('5','89',255436,'DALY SHIFT','2022-01-21','2022-01-21 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-21 22:24:41','608','2022-01-22 22:11:07',10,0),('5','89',255698,'DALY SHIFT','2022-01-22','2022-01-22 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-23 09:31:23','608','2022-01-23 13:43:11',10,0),('5','89',255874,'DALY SHIFT','2022-01-23','2022-01-23 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-23 19:11:36','608','2022-01-24 04:02:44',10,0),('5','89',256190,'DALY SHIFT','2022-01-24','2022-01-24 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-24 22:54:50','608','2022-01-25 09:51:45',10,0),('5','89',256373,'DALY SHIFT','2022-01-25','2022-01-25 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-25 19:10:21','608','2022-01-26 10:17:05',10,0),('5','89',256601,'DALY SHIFT','2022-01-26','2022-01-26 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-26 22:35:41','608','2022-01-27 19:01:22',10,0),('5','89',256944,'DALY SHIFT','2022-01-27','2022-01-27 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-27 23:36:35','608','2022-01-28 22:08:23',10,0),('5','89',257210,'DALY SHIFT','2022-01-28','2022-01-28 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-28 22:16:08','608','2022-01-30 13:01:28',10,0),('5','89',257596,'DALY SHIFT','2022-01-29','2022-01-29 00:00:00',NULL,'397',0.00,0.00,'397','2022-01-30 13:03:25','608','2022-01-30 13:05:00',10,0),('5','89',257597,'DALY SHIFT','2022-01-30','2022-01-30 00:00:00',NULL,'397',1357205.85,1357205.85,'397','2022-01-31 23:07:14','608','2022-02-01 13:40:01',10,0),('5','89',257598,'DALY SHIFT','2022-01-31','2022-01-31 00:00:00',NULL,'397',1525255.05,1525255.05,'397','2022-02-01 13:54:34','608','2022-02-01 13:57:47',10,0),('5','89',257599,'DALY SHIFT','2022-02-01','2022-02-01 00:00:00',NULL,'397',850274.70,850274.70,'397','2022-02-01 21:42:34','608','2022-02-01 21:57:18',10,0),('5','89',257600,'DALY SHIFT','2022-02-02','2022-02-02 00:00:00',NULL,'397',1762287.45,1762287.45,'397','2022-02-02 23:13:58','608','2022-02-03 16:02:07',10,0),('5','89',257601,'DALY SHIFT','2022-02-03','2022-02-03 00:00:00',NULL,'397',1711545.00,1711545.00,'397','2022-02-03 20:49:13','608','2022-02-04 09:21:56',10,0),('5','89',257602,'DALY SHIFT','2022-02-04','2022-02-04 00:00:00',NULL,'397',1894770.90,1894770.90,'397','2022-02-05 10:42:13','608','2022-02-05 20:14:02',10,0),('5','89',257603,'DALY SHIFT','2022-02-05','2022-02-05 00:00:00',NULL,'397',1651514.70,1651514.70,'397','2022-02-05 23:58:26','608','2022-02-06 18:51:00',10,0),('5','89',257604,'DALY SHIFT','2022-02-06','2022-02-06 00:00:00',NULL,'397',1516782.30,1516782.30,'397','2022-02-07 00:14:50','608','2022-02-07 09:48:55',10,0),('5','89',257605,'DALY SHIFT','2022-02-07','2022-02-07 00:00:00',NULL,'397',1949215.95,1949215.95,'397','2022-02-07 20:34:46','608','2022-02-07 21:43:54',10,0),('5','89',257606,'DALY SHIFT','2022-02-08','2022-02-08 00:00:00',NULL,'397',1479782.70,1479782.70,'397','2022-02-08 23:47:21','608','2022-02-09 00:10:11',10,0),('5','89',257607,'DALY SHIFT','2022-02-09','2022-02-09 00:00:00',NULL,'397',1351510.05,1351510.05,'397','2022-02-09 23:13:20','608','2022-02-10 14:01:55',10,0),('5','89',257608,'DALY SHIFT','2022-02-10','2022-02-10 00:00:00',NULL,'397',749708.85,749708.85,'397','2022-02-10 23:40:30','608','2022-02-11 11:23:34',10,0),('5','89',257609,'DALY SHIFT','2022-02-11','2022-02-11 00:00:00',NULL,'397',0.00,0.00,'397','2022-02-11 21:35:59','608','2022-02-12 21:23:59',10,0),('5','89',257610,'DALY SHIFT','2022-02-12','2022-02-12 00:00:00',NULL,'397',0.00,0.00,'397','2022-02-12 21:45:18','608','2022-02-13 21:02:22',10,0),('5','89',257611,'DALY SHIFT','2022-02-13','2022-02-13 00:00:00',NULL,'397',0.00,0.00,'397','2022-02-13 21:06:34','608','2022-02-13 21:08:08',10,0),('5','89',257612,'DALY SHIFT','2022-02-14','2022-02-14 00:00:00',NULL,'397',0.00,0.00,'397','2022-02-14 20:25:13','608','2022-02-14 22:29:19',10,0),('5','89',257613,'DALY SHIFT','2022-02-15','2022-02-15 00:00:00',NULL,'397',0.00,0.00,'397','2022-02-15 23:28:33','608','2022-02-16 09:50:40',10,0),('5','89',257614,'DALY SHIFT','2022-02-16','2022-02-16 00:00:00',NULL,'397',1459929.90,1459929.90,'397','2022-02-16 20:40:35','608','2022-02-17 17:54:47',10,0),('5','89',257615,'DALY SHIFT','2022-02-17','2022-02-17 00:00:00',NULL,'397',1772189.10,1772189.10,'397','2022-02-18 00:02:19','608','2022-02-18 11:56:03',10,0),('5','89',257616,'DALY SHIFT','2022-02-18','2022-02-18 00:00:00',NULL,'397',1210316.25,1210316.25,'397','2022-02-18 22:22:16','608','2022-02-19 22:50:09',10,0),('5','89',257617,'DALY SHIFT','2022-02-19','2022-02-19 00:00:00',NULL,'397',0.00,0.00,'397','2022-02-19 23:03:13','608','2022-02-20 09:18:14',10,0),('5','89',257618,'DALY SHIFT','2022-02-20','2022-02-20 00:00:00',NULL,'397',2324160.30,2324160.30,'397','2022-02-21 00:17:29','608','2022-02-21 11:50:33',10,0),('5','89',257619,'DALY SHIFT','2022-02-21','2022-02-21 00:00:00',NULL,'397',2867272.65,2867272.65,'397','2022-02-21 23:46:55','608','2022-02-22 07:21:28',10,0),('5','89',257620,'DALY SHIFT','2022-02-22','2022-02-22 23:21:50','2022-02-23 23:21:50','397',3091900.35,3091900.35,'397','2022-02-22 23:34:33','608','2022-02-23 10:22:37',10,0),('5','89',257621,'DALY SHIFT','2022-02-23','2022-02-23 17:15:07','2022-02-24 17:15:07','397',2206351.95,2206351.95,'397','2022-02-23 22:32:32','608','2022-02-24 07:02:02',10,0),('5','89',257622,'DALY SHIFT','2022-02-24','2022-02-24 08:58:25','2022-02-25 08:58:25','397',2651756.25,2651756.25,'397','2022-02-24 23:49:47','608','2022-02-25 23:19:38',10,0),('5','89',257623,'DALY SHIFT','2022-02-25','2022-02-25 23:21:05','2022-02-26 23:21:05','397',2991351.00,2991351.00,'397','2022-02-25 23:28:06','608','2022-02-26 22:32:40',10,0),('5','89',257624,'DALY SHIFT','2022-02-26','2022-02-26 22:35:50','2022-02-27 22:35:50','397',2089984.05,2089984.05,'397','2022-02-26 22:42:41','608','2022-02-27 09:48:42',10,0),('5','89',257625,'DALY SHIFT','2022-02-27','2022-02-27 18:26:00','2022-02-28 18:26:00','397',2032785.15,2032785.15,'397','2022-02-28 00:08:04','608','2022-02-28 11:32:27',10,0),('5','89',257626,'DALY SHIFT','2022-02-28','2022-03-01 00:04:03','2022-03-02 00:04:03','397',1105422.45,1105422.45,'397','2022-03-01 00:09:24','608','2022-03-01 07:04:18',10,0),('5','89',257627,'DALY SHIFT','2022-03-01','2022-03-01 17:59:13','2022-03-02 17:59:13','397',1589019.30,1589019.30,'397','2022-03-02 11:58:49','608','2022-03-02 23:16:49',10,0),('5','89',257628,'DALY SHIFT','2022-03-02','2022-03-02 23:34:25','2022-03-03 23:34:25','397',1604516.10,1604516.10,'397','2022-03-02 23:41:11','608','2022-03-03 21:26:17',10,0),('5','89',257629,'DALY SHIFT','2022-03-03','2022-03-04 05:39:25','2022-03-05 05:39:25','397',2195186.40,2195186.40,'397','2022-03-04 05:44:33','608','2022-03-05 00:16:32',10,0),('5','89',257630,'DALY SHIFT','2022-03-04','2022-03-07 10:59:46','2022-03-08 10:59:46','397',0.00,0.00,'397','2022-03-07 11:01:12','608','2022-03-07 11:05:14',10,0),('5','89',257631,'DALY SHIFT','2022-03-05','2022-03-07 15:40:09','2022-03-08 15:40:09','397',0.00,0.00,'397','2022-03-07 15:41:01','608','2022-03-07 15:44:36',10,0),('5','89',257632,'DALY SHIFT','2022-03-06','2022-03-07 15:47:52','2022-03-08 15:47:52','397',0.00,0.00,'397','2022-03-07 15:50:34','608','2022-03-07 16:20:40',10,0),('5','89',257633,'DALY SHIFT','2022-03-07','2022-03-07 16:25:02','2022-03-08 16:25:02','397',1252156.95,1252156.95,'397','2022-03-08 00:14:09','608','2022-03-08 10:17:33',10,0),('5','89',257634,'DALY SHIFT','2022-03-08','2022-03-09 06:10:05','2022-03-10 06:10:05','397',1225727.25,1225727.25,'397','2022-03-09 10:05:20','608','2022-03-09 22:06:07',10,0),('5','89',257635,'Morning','2022-03-09','2022-03-09 22:41:16','2022-03-10 22:41:16','397',0.00,0.00,'397','2022-03-09 22:41:37','608','2022-03-10 13:49:35',10,0),('5','89',257636,'DALY SHIFT','2022-03-10','2022-03-10 15:57:35','2022-03-11 15:57:35','397',0.00,0.00,'397','2022-03-10 19:18:09','608','2022-03-12 10:25:46',10,0),('5','89',257637,'Morning','2022-03-11','2022-03-12 10:29:55','2022-03-13 10:29:55','397',0.00,0.00,'397','2022-03-12 10:30:13','608','2022-03-12 21:22:53',10,0),('5','89',257638,'Morning','2022-03-12','2022-03-12 21:25:30','2022-03-13 21:25:30','397',4330675.80,4330675.80,'397','2022-03-12 21:30:14','608','2022-03-13 21:39:10',10,0),('5','89',257639,'Morning ','2022-03-13','2022-03-13 21:41:20','2022-03-14 21:41:20','397',3656756.40,3656756.40,'397','2022-03-13 21:45:33','608','2022-03-13 23:24:44',10,0),('5','89',257640,'Morning','2022-03-14','2022-03-14 19:59:15','2022-03-15 19:59:15','397',4334691.90,4334691.90,'397','2022-03-14 20:38:53','608','2022-03-15 10:51:11',10,0),('5','89',257641,'Morning ','2022-03-15','2022-03-15 15:04:21','2022-03-16 15:04:21','397',2644758.60,2644758.60,'397','2022-03-15 20:43:49','608','2022-03-15 20:49:00',10,0),('5','89',257642,'Morning ','2022-03-16','2022-03-16 12:02:25','2022-03-17 12:02:25','397',0.00,0.00,'397','2022-03-16 20:09:09','608','2022-03-16 22:26:12',10,0),('5','89',257643,'Morning','2022-03-17','2022-03-18 12:43:30','2022-03-19 12:43:30','397',0.00,0.00,'397','2022-03-18 12:43:58','608','2022-03-18 20:25:18',10,0),('5','89',257644,'Morning','2022-03-18','2022-03-19 13:01:20','2022-03-20 13:01:20','397',0.00,0.00,'397','2022-03-19 13:01:49','608','2022-03-19 22:49:25',10,0),('5','89',257645,'Morning','2022-03-19','2022-03-20 14:50:01','2022-03-21 14:50:01','397',0.00,0.00,'397','2022-03-20 14:50:36','608','2022-03-20 20:33:29',10,0),('5','89',257646,'Morning','2022-03-20','2022-03-20 20:34:14','2022-03-21 20:34:14','397',0.00,0.00,'397','2022-03-20 20:34:30','608','2022-03-22 15:54:33',10,0),('5','89',257647,'Morning ','2022-03-22','2022-03-22 18:24:50','2022-03-23 18:24:50','397',0.00,0.00,'397','2022-03-22 18:25:06','608','2022-03-23 13:54:51',10,0),('5','89',257648,'Morning','2022-03-23','2022-03-24 11:01:34','2022-03-25 11:01:34','397',2780687.25,2780687.25,'397','2022-03-24 11:04:25','795','2022-03-28 12:02:08',10,0),('5','89',257649,'Daily shift ','2022-03-24','2022-04-10 06:10:13','2022-04-11 06:10:13','397',1632123.90,1632123.90,'397','2022-04-10 06:27:09','795','2022-04-10 10:44:37',10,0),('5','89',257650,'Daily shift ','2022-03-25','2022-04-10 10:50:34','2022-04-11 10:50:34','397',0.00,0.00,'397','2022-04-10 10:54:47','795','2022-04-10 11:34:43',10,0),('5','89',257651,'Daily shift ','2022-04-10','2022-04-10 12:04:47','2022-04-11 12:04:47','397',0.00,0.00,'600','2022-04-11 09:09:46','600','2022-04-11 09:09:59',10,0),('5','89',257652,'Daily shift ','2022-03-26','2022-04-11 09:55:44','2022-04-12 09:55:44','397',0.00,0.00,'397','2022-04-11 09:56:08','795','2022-04-11 10:11:58',10,0),('5','89',257653,'Daily shift ','2022-03-27','2022-04-11 10:23:07','2022-04-12 10:23:07','397',0.00,0.00,'397','2022-04-11 10:23:30','795','2022-04-11 10:25:32',10,0),('5','89',257654,'Daily shift ','2022-03-28','2022-04-11 10:28:41','2022-04-12 10:28:41','397',0.00,0.00,'397','2022-04-11 10:29:01','795','2022-04-11 10:30:13',10,0),('5','89',257655,'Daily shift ','2022-04-11','2022-04-11 10:31:55','2022-04-12 10:31:55','397',0.00,0.00,'397','2022-04-11 10:33:23','795','2022-04-11 10:48:24',10,0),('5','89',257656,'Daily shift ','2022-03-29','2022-04-11 11:03:50','2022-04-12 11:03:50','397',132000.00,132000.00,'397','2022-04-11 11:07:08','795','2022-04-11 11:26:07',10,0),('5','89',257657,'Daily shift ','2022-03-30','2022-04-11 11:28:30','2022-04-12 11:28:30','397',0.00,0.00,'397','2022-04-11 11:29:55','795','2022-04-11 11:32:06',10,0),('5','89',257658,'Daily shift ','2022-03-31','2022-04-11 11:54:25','2022-04-12 11:54:25','397',0.00,0.00,'397','2022-04-11 11:54:49','795','2022-04-11 11:56:02',10,0),('5','89',257659,'Daily shift ','2022-04-01','2022-04-11 11:59:11','2022-04-12 11:59:11','397',0.00,0.00,'397','2022-04-11 11:59:29','795','2022-04-11 12:00:51',10,0),('5','89',257660,'Daily shift ','2022-04-02','2022-04-11 12:32:50','2022-04-12 12:32:50','397',0.00,0.00,'397','2022-04-11 12:33:58','795','2022-04-11 12:35:15',10,0),('5','89',257661,'Daily shift ','2022-04-03','2022-04-11 13:48:44','2022-04-12 13:48:44','397',0.00,0.00,'397','2022-04-11 13:52:52','795','2022-04-11 16:28:42',10,0),('5','89',257662,'Daily shift ','2022-04-11','2022-04-11 17:34:04','2022-04-12 17:34:04','397',0.00,0.00,'397','2022-04-11 17:34:39','795','2022-04-11 18:19:22',10,0),('5','89',257663,'Daily shift ','2022-04-04','2022-04-11 21:39:07','2022-04-12 21:39:07','397',0.00,0.00,'397','2022-04-11 21:39:25','795','2022-04-12 11:24:54',10,0),('5','89',257664,'Daily shift ','2022-04-05','2022-04-12 11:28:35','2022-04-13 11:28:35','397',0.00,0.00,'397','2022-04-12 11:28:56','795','2022-04-12 11:39:26',10,0),('5','89',257665,'Daily shift ','2022-04-06','2022-04-12 11:41:39','2022-04-13 11:41:39','397',0.00,0.00,'397','2022-04-12 11:42:02','795','2022-04-12 11:43:14',10,0),('5','89',257666,'Daily shift ','2022-04-07','2022-04-12 11:47:19','2022-04-13 11:47:19','397',0.00,0.00,'397','2022-04-12 11:47:39','795','2022-04-12 11:48:34',10,0),('5','89',257667,'Daily shift ','2022-04-08','2022-04-12 11:51:03','2022-04-13 11:51:03','397',0.00,0.00,'397','2022-04-12 11:51:19','795','2022-04-12 11:53:53',10,0),('5','89',257668,'Daily shift ','2022-04-09','2022-04-12 11:55:18','2022-04-13 11:55:18','397',0.00,0.00,'397','2022-04-12 11:56:18','795','2022-04-12 11:57:44',10,0),('5','89',257669,'Daily shift ','2022-04-10','2022-04-12 11:59:18','2022-04-13 11:59:18','397',0.00,0.00,'397','2022-04-12 11:59:38','795','2022-04-12 12:02:29',10,0),('5','89',257670,'Daily shift ','2022-04-11','2022-04-12 12:08:55','2022-04-13 12:08:55','397',0.00,0.00,'397','2022-04-12 12:09:11','795','2022-04-12 12:10:17',10,0),('5','89',257671,'Daily shift ','2022-04-12','2022-04-12 12:18:26','2022-04-13 12:18:26','397',440784.30,440784.30,'397','2022-04-12 21:38:27','795','2022-04-13 09:50:23',10,0),('5','89',257672,'Daily shift ','2022-04-13','2022-04-13 09:57:04','2022-04-14 09:57:04','397',1893942.60,1893942.60,'397','2022-04-13 21:08:29','795','2022-04-14 20:39:47',10,0),('5','89',257673,'Daily shift ','2022-04-14','2022-04-14 21:28:57','2022-04-15 21:28:57','397',1636575.60,1636575.60,'397','2022-04-14 21:36:38','795','2022-04-15 11:04:39',10,0),('5','89',257674,'Daily shift ','2022-04-15','2022-04-15 11:48:13','2022-04-16 11:48:13','397',833601.45,833601.45,'397','2022-04-15 21:53:35','795','2022-04-16 10:49:14',10,0),('5','89',257675,'Daily shift ','2022-04-16','2022-04-16 12:29:51','2022-04-17 12:29:51','397',0.00,0.00,'397','2022-04-16 20:11:06','795','2022-04-16 20:58:51',10,0),('5','89',257676,'Daily shift ','2022-04-17','2022-04-17 10:09:37','2022-04-18 10:09:37','397',0.00,0.00,'397','2022-04-17 21:36:29','795','2022-04-18 17:26:23',10,0),('5','89',257677,'Daily shift','2022-04-18','2022-04-18 22:07:10','2022-04-19 22:07:10','397',0.00,0.00,'397','2022-04-18 22:07:30','795','2022-04-18 22:08:12',10,0),('5','89',257678,'Daily shift','2022-04-19','2022-04-19 10:14:37','2022-04-20 10:14:37','397',0.00,0.00,'397','2022-04-19 21:35:50','795','2022-04-20 09:53:18',10,0),('5','89',257679,'Daily shift','2022-04-20','2022-04-20 14:19:16','2022-04-21 14:19:16','397',1203189.90,1203189.90,'397','2022-04-20 21:32:01','795','2022-04-20 22:44:36',10,0),('5','89',257680,'Daily shift','2022-04-21','2022-04-21 07:10:39','2022-04-22 07:10:39','397',1769247.15,1769247.15,'397','2022-04-21 20:34:45','795','2022-04-21 23:57:15',10,0),('5','89',257681,'Daily shift','2022-04-22','2022-04-22 10:32:26','2022-04-23 10:32:26','397',1536432.15,1536432.15,'397','2022-04-22 23:28:12','795','2022-04-23 15:03:02',10,0),('5','89',257682,'Daily shift','2022-04-23','2022-04-23 21:11:39','2022-04-24 21:11:39','397',1460264.85,1460264.85,'397','2022-04-23 21:18:15','795','2022-04-24 14:43:01',10,0),('5','89',257683,'Daily shift','2022-04-24','2022-04-24 18:06:40','2022-04-25 18:06:40','397',600699.00,600699.00,'397','2022-04-24 21:07:15','795','2022-04-25 12:05:59',10,0),('5','89',257684,'Daily shift','2022-04-25','2022-04-25 22:10:55','2022-04-26 22:10:55','397',0.00,0.00,'397','2022-04-25 22:11:13','795','2022-04-26 09:14:47',10,0),('5','89',257685,'Daily shift','2022-04-26','2022-04-26 11:03:06','2022-04-27 11:03:06','397',1323540.90,1323540.90,'397','2022-04-26 22:50:55','795','2022-04-27 09:27:01',10,0),('5','89',257686,'Daily shift','2022-04-27','2022-04-27 10:03:33','2022-04-28 10:03:33','397',1553171.40,1553171.40,'397','2022-04-27 21:07:10','795','2022-04-29 10:23:51',10,0),('5','89',257687,'Daily shift','2022-04-29','2022-04-29 11:40:43','2022-04-30 11:40:43','397',1402483.50,1402483.50,'397','2022-04-29 11:41:51','795','2022-05-09 11:42:00',10,0),('5','89',257688,'Daily shift','2022-04-30','2022-05-09 13:44:15','2022-05-10 13:44:15','397',668023.95,668023.95,'397','2022-05-09 14:00:47','795','2022-05-09 17:30:12',10,0),('5','89',257689,'Daily shift','2022-04-30','2022-05-09 21:50:29','2022-05-10 21:50:29','397',348814.95,348814.95,'397','2022-05-10 07:18:58','795','2022-05-10 09:23:34',10,0),('5','89',257690,'Daily shift','2022-04-01','2022-05-10 09:26:20','2022-05-11 09:26:20','397',1845336.90,1845336.90,'397','2022-05-10 09:27:46','795','2022-05-10 09:29:26',10,0),('5','89',257691,'Daily shift','2022-05-02','2022-05-10 09:31:32','2022-05-11 09:31:32','397',1453291.95,1453291.95,'397','2022-05-10 09:32:28','795','2022-05-10 09:33:22',10,0),('5','89',257692,'Daily shift','2022-05-03','2022-05-10 09:34:43','2022-05-11 09:34:43','397',1616904.30,1616904.30,'397','2022-05-10 09:35:59','795','2022-05-10 09:37:52',10,0),('5','89',257693,'Daily shift','2022-05-04','2022-05-10 09:39:43','2022-05-11 09:39:43','397',1340659.65,1340659.65,'397','2022-05-10 09:41:18','795','2022-05-10 09:43:53',10,0),('5','89',257694,'Daily shift 51','2022-05-05','2022-05-10 10:01:09','2022-05-11 10:01:09','397',1473654.60,1473654.60,'397','2022-05-10 10:10:01','795','2022-05-10 10:11:04',10,0),('5','89',257695,'Daily shift','2022-05-06','2022-05-10 10:17:35','2022-05-11 10:17:35','397',1406857.65,1406857.65,'397','2022-05-10 10:18:47','795','2022-05-10 10:20:28',10,0),('5','89',257696,'Daily shift','2022-05-07','2022-05-10 10:21:57','2022-05-11 10:21:57','397',1355253.90,1355253.90,'397','2022-05-10 10:23:13','795','2022-05-10 10:23:49',10,0),('5','89',257697,'Daily shift','2022-05-08','2022-05-10 10:25:54','2022-05-11 10:25:54','397',1315615.95,1315615.95,'397','2022-05-10 10:27:05','795','2022-05-10 10:28:47',10,0),('5','89',257698,'Daily shift','2022-05-09','2022-05-10 10:30:28','2022-05-11 10:30:28','397',1319384.55,1319384.55,'397','2022-05-10 10:31:38','795','2022-05-10 10:33:10',10,0),('5','89',257699,'Daily shift','2022-05-10','2022-05-10 10:34:07','2022-05-11 10:34:07','397',528056.10,528056.10,'397','2022-05-10 22:58:16','795','2022-05-11 09:38:19',10,0),('5','89',257700,'Daily shift','2022-05-11','2022-05-11 10:55:07','2022-05-12 10:55:07','397',0.00,0.00,'397','2022-05-12 06:31:26','795','2022-05-12 11:25:08',10,0),('5','89',257701,'Daily shift','2022-05-12','2022-05-12 21:17:14','2022-05-13 21:17:14','397',0.00,0.00,'397','2022-05-12 21:17:40','795','2022-05-13 10:58:42',10,0),('5','89',257702,'Daily shift','2022-05-13','2022-05-13 11:18:36','2022-05-14 11:18:36','397',0.00,0.00,'397','2022-05-14 06:00:27','795','2022-05-14 15:33:31',10,0),('5','89',257703,'Daily shift','2022-05-14','2022-05-15 14:22:44','2022-05-16 14:22:44','397',0.00,0.00,'397','2022-05-15 14:23:03','795','2022-05-15 14:46:09',10,0),('5','89',257704,'Daily shift','2022-05-15','2022-05-15 17:04:25','2022-05-16 17:04:25','397',0.00,0.00,'397','2022-05-15 22:05:58','795','2022-05-16 09:41:00',10,0),('5','89',257705,'Daily shift','2022-05-16','2022-05-16 19:45:50','2022-05-17 19:45:50','397',0.00,0.00,'397','2022-05-16 19:46:19','795','2022-05-17 09:30:20',10,0),('5','89',257706,'Daily shift','2022-05-17','2022-05-18 07:49:50','2022-05-19 07:49:50','397',0.00,0.00,'397','2022-05-18 07:50:08','795','2022-05-18 11:40:36',10,0),('5','89',257707,'Daily shift','2022-05-18','2022-05-18 12:24:31','2022-05-19 12:24:31','397',0.00,0.00,'397','2022-05-18 21:04:36','795','2022-05-19 09:59:48',10,0),('5','89',257708,'Daily shift','2022-05-19','2022-05-19 13:27:25','2022-05-20 13:27:25','397',0.00,0.00,'397','2022-05-20 10:27:01','795','2022-05-20 15:00:43',10,0),('5','89',257709,'Daily shift','2022-05-20','2022-05-20 18:35:24','2022-05-21 18:35:24','397',0.00,0.00,'397','2022-05-20 23:59:03','795','2022-05-23 13:07:45',10,0),('5','89',257710,'Daily shift','2022-05-21','2022-05-23 13:15:48','2022-05-24 13:15:48','397',0.00,0.00,'397','2022-05-23 13:16:06','795','2022-05-23 13:17:46',10,0),('5','89',257711,'Daily shift','2022-05-22','2022-05-23 13:19:04','2022-05-24 13:19:04','397',0.00,0.00,'397','2022-05-23 13:19:25','795','2022-05-23 13:20:01',10,0),('5','89',257712,'Daily shift','2022-05-23','2022-05-23 13:26:53','2022-05-24 13:26:53','397',0.00,0.00,'397','2022-05-23 21:05:13','795','2022-05-23 21:52:09',10,0),('5','89',257713,'Daily shift','2022-05-24','2022-05-24 12:47:45','2022-05-25 12:47:45','397',0.00,0.00,'397','2022-05-24 22:45:27','795','2022-05-25 09:28:42',10,0),('5','89',257714,'Daily shift','2022-05-25','2022-05-25 18:51:37','2022-05-26 18:51:37','397',0.00,0.00,'397','2022-05-26 06:11:28','795','2022-05-26 10:35:15',10,0),('5','89',257715,'Daily shift','2022-05-26','2022-05-26 20:47:56','2022-05-27 20:47:56','397',0.00,0.00,'397','2022-05-26 20:48:19','795','2022-05-26 23:17:02',10,0),('5','89',257716,'Daily shift','2022-05-27','2022-05-27 14:30:26','2022-05-28 14:30:26','397',817966.05,817966.05,'397','2022-05-27 22:26:31','795','2022-05-28 22:36:58',10,0),('5','89',257717,'Daily shift','2022-05-28','2022-05-28 23:34:41','2022-05-29 23:34:41','397',1351467.15,1351467.15,'397','2022-05-28 23:39:49','795','2022-05-29 19:07:57',10,0),('5','89',257718,'Daily shift','2022-05-29','2022-05-30 11:38:06','2022-05-31 11:38:06','397',1157049.30,1157049.30,'397','2022-05-30 11:43:09','795','2022-05-30 12:26:19',10,0),('5','89',257719,'Daily shift','2022-05-30','2022-05-30 21:07:21','2022-05-31 21:07:21','397',1118140.65,1118140.65,'397','2022-05-30 22:48:48','795','2022-05-31 09:45:38',10,0),('5','89',257720,'Daily shift','2022-05-31','2022-05-31 18:39:29','2022-06-01 18:39:29','397',1380809.10,1380809.10,'397','2022-05-31 22:46:26','795','2022-06-02 10:19:46',10,0),('5','89',257721,'Daily shift','2022-06-01','2022-06-02 10:34:44','2022-06-03 10:34:44','397',723831.90,723831.90,'397','2022-06-02 10:40:43','795','2022-06-02 16:18:56',10,0),('5','89',257722,'Daily shift','2022-06-02','2022-06-03 07:45:11','2022-06-04 07:45:11','397',504073.35,504073.35,'397','2022-06-03 07:45:52','795','2022-06-03 10:01:20',10,0),('5','89',257723,'Daily shift','2022-06-03','2022-06-03 14:34:50','2022-06-04 14:34:50','397',307555.05,307555.05,'397','2022-06-03 22:27:31','795','2022-06-04 15:16:21',10,0),('5','89',257724,'Daily shift','2022-06-04','2022-06-04 22:00:14','2022-06-05 22:00:14','397',0.00,0.00,'397','2022-06-05 22:38:28','795','2022-06-06 00:29:28',10,0),('5','89',257725,'Daily shift','2022-06-05','2022-06-06 09:02:21','2022-06-07 09:02:21','397',1082728.35,1082728.35,'397','2022-06-07 13:43:48','795','2022-06-08 09:46:20',10,0),('5','89',257726,'Daily shift','2022-06-06','2022-06-08 09:50:35','2022-06-09 09:50:35','397',1303574.25,1303574.25,'397','2022-06-08 09:54:03','795','2022-06-08 09:58:38',10,0),('5','89',257727,'Daily shift','2022-06-07','2022-06-08 10:34:49','2022-06-09 10:34:49','397',884810.85,884810.85,'397','2022-06-08 10:36:43','795','2022-06-08 10:53:36',10,0),('5','89',257728,'Daily shift','2022-06-08','2022-06-08 10:56:23','2022-06-09 10:56:23','397',668451.30,668451.30,'397','2022-06-08 22:30:45','795','2022-06-09 19:36:33',10,0),('5','89',257729,'Daily shift','2022-06-09','2022-06-09 20:34:34','2022-06-10 20:34:34','397',626995.05,626995.05,'397','2022-06-09 22:32:04','795','2022-06-10 09:24:47',10,0),('5','89',257730,'Daily','2022-06-10','2022-06-10 13:14:01','2022-06-11 13:14:01','397',330770.55,330770.55,'397','2022-06-11 08:24:19','795','2022-06-11 18:04:23',10,0),('5','89',257731,'Daily shift','2022-06-11','2022-06-11 22:37:44','2022-06-12 22:37:44','397',0.00,0.00,'397','2022-06-11 22:38:41','795','2022-06-12 16:21:46',10,0),('5','89',257732,'Daily shift','2022-06-13','2022-06-13 07:10:16','2022-06-14 07:10:16','397',0.00,0.00,'397','2022-06-13 07:10:36','795','2022-06-13 13:03:55',10,0),('5','89',257733,'Daily shift','2022-06-12','2022-06-13 22:11:57','2022-06-14 22:11:57','397',0.00,0.00,'397','2022-06-13 22:12:18','795','2022-06-13 23:34:40',10,0),('5','89',257734,'Daily shift','2022-06-14','2022-06-14 09:01:36','2022-06-15 09:01:36','397',0.00,0.00,'397','2022-06-15 05:59:01','795','2022-06-15 09:31:06',10,0),('5','89',257735,'Daily shift','2022-06-15','2022-06-15 10:06:49','2022-06-16 10:06:49','397',0.00,0.00,'397','2022-06-15 20:35:35','795','2022-06-15 21:30:31',10,0),('5','89',257736,'Daily shift','2022-06-16','2022-06-16 08:49:47','2022-06-17 08:49:47','397',0.00,0.00,'397','2022-06-17 06:24:03','795','2022-06-17 13:18:38',10,0),('5','89',257737,'Daily shift','2022-06-17','2022-06-17 20:53:09','2022-06-18 20:53:09','397',0.00,0.00,'397','2022-06-17 20:53:39','795','2022-06-18 17:59:05',10,0),('5','89',257738,'Daily shift','2022-06-18','2022-06-18 18:20:30','2022-06-19 18:20:30','397',0.00,0.00,'397','2022-06-18 21:11:50','795','2022-06-19 14:56:51',10,0),('5','89',257739,'Daily shift','2022-06-19','2022-06-19 16:52:22','2022-06-20 16:52:22','397',0.00,0.00,'397','2022-06-19 20:41:52','795','2022-06-20 09:19:55',10,0),('5','89',257740,'Daily shift','2022-06-20','2022-06-20 19:54:50','2022-06-21 19:54:50','397',0.00,0.00,'397','2022-06-20 19:55:08','795','2022-06-21 08:51:18',10,0),('5','89',257741,'Daily shift','2022-06-21','2022-06-21 15:32:10','2022-06-22 15:32:10','397',0.00,0.00,'397','2022-06-21 21:26:40','795','2022-06-22 12:31:17',10,0),('5','89',257742,'Daily shift','2022-06-22','2022-06-22 15:05:29','2022-06-23 15:05:29','397',0.00,0.00,'397','2022-06-22 21:50:19','795','2022-06-23 09:48:07',10,0),('5','89',257743,'Daily shift','2022-06-23','2022-06-23 17:03:32','2022-06-24 17:03:32','397',0.00,0.00,'397','2022-06-23 20:01:12','795','2022-06-24 10:10:55',10,0),('5','89',257744,'Daily shift','2022-06-24','2022-06-24 11:58:32','2022-06-25 11:58:32','397',0.00,0.00,'397','2022-06-24 22:02:53','795','2022-06-25 19:12:50',10,0),('5','89',257745,'Daily shift','2022-06-25','2022-06-26 10:16:28','2022-06-27 10:16:28','397',0.00,0.00,'397','2022-06-26 19:35:54','795','2022-06-27 09:29:15',10,0),('5','89',257746,'Daily shift','2022-06-26','2022-06-27 10:50:27','2022-06-28 10:50:27','397',0.00,0.00,'397','2022-06-27 12:37:00','795','2022-06-28 10:30:28',10,0),('5','89',257747,'Daily shift','2022-06-27','2022-06-28 13:49:44','2022-06-29 13:49:44','397',0.00,0.00,'397','2022-06-28 21:46:12','795','2022-06-29 09:31:04',10,0),('5','89',257748,'Daily shift','2022-06-28','2022-06-29 10:16:16','2022-06-30 10:16:16','397',0.00,0.00,'397','2022-06-29 10:16:34','795','2022-06-29 10:19:48',10,0),('5','89',257749,'Daily shift','2022-06-29','2022-06-29 11:19:08','2022-06-30 11:19:08','397',0.00,0.00,'397','2022-06-29 20:39:30','795','2022-06-30 11:54:34',10,0),('5','89',257750,'Daily shift','2022-06-30','2022-06-30 17:35:34','2022-07-01 17:35:34','397',0.00,0.00,'397','2022-07-01 15:47:52','795','2022-07-02 20:16:40',10,0),('5','89',257751,'Daily shift','2022-07-01','2022-07-02 20:24:32','2022-07-03 20:24:32','397',0.00,0.00,'397','2022-07-02 20:24:51','795','2022-07-02 20:26:10',10,0),('5','89',257752,'Daily shift','2022-07-02','2022-07-03 10:07:22','2022-07-04 10:07:22','397',0.00,0.00,'397','2022-07-03 10:08:07','795','2022-07-03 13:46:38',10,0),('5','89',257753,'Daily shift','2022-07-03','2022-07-03 19:35:38','2022-07-04 19:35:38','397',0.00,0.00,'397','2022-07-03 21:48:10','795','2022-07-04 09:39:50',10,0),('5','89',257754,'Daily shift','2022-07-04','2022-07-04 20:28:23','2022-07-05 20:28:23','397',0.00,0.00,'397','2022-07-04 20:28:50','795','2022-07-05 10:24:45',10,0),('5','89',257755,'Daily shift','2022-07-05','2022-07-05 10:31:31','2022-07-06 10:31:31','397',0.00,0.00,'397','2022-07-05 10:34:30','795','2022-07-05 12:42:47',10,0),('5','89',257756,'Daily shift','2022-07-06','2022-07-06 09:00:12','2022-07-07 09:00:12','397',0.00,0.00,'397','2022-07-06 09:00:45','795','2022-07-06 11:44:34',10,0),('5','89',257757,'Daily shift','2022-07-07','2022-07-07 08:10:00','2022-07-08 08:10:00','397',0.00,0.00,'397','2022-07-08 07:04:04','795','2022-07-08 09:30:45',10,0),('5','89',257758,'Daily shift','2022-07-08','2022-07-08 10:06:23','2022-07-09 10:06:23','397',768385.20,768385.20,'397','2022-07-08 21:30:18','795','2022-07-09 19:00:18',10,0),('5','89',257759,'Daily shift','2022-07-09','2022-07-09 19:32:10','2022-07-10 19:32:10','397',528717.75,528717.75,'397','2022-07-09 19:50:36','795','2022-07-09 22:31:58',10,0),('5','89',257760,'Daily shift','2022-07-09','2022-07-10 05:05:18','2022-07-11 05:05:18','397',473370.15,530748.35,'397','2022-07-10 05:39:02','795','2022-07-10 21:33:06',10,0),('5','89',257761,'Daily shift','2022-07-10','2022-07-11 09:57:00','2022-07-12 09:57:00','397',717919.95,804940.55,'397','2022-07-11 09:59:00','795','2022-07-11 11:03:51',10,0),('5','89',257762,'Daily shift','2022-07-11','2022-07-11 13:03:14','2022-07-12 13:03:14','397',742905.90,742905.90,'397','2022-07-12 04:20:58','795','2022-07-12 16:16:50',10,0),('5','89',257763,'Daily shift','2022-07-12','2022-07-12 22:16:22','2022-07-13 22:16:22','397',1370992.45,1370992.45,'397','2022-07-13 10:26:27','795','2022-07-13 14:39:57',10,0),('5','89',257764,'Daily shift','2022-07-13','2022-07-13 14:41:52','2022-07-14 14:41:52','397',1754773.10,1754773.10,'397','2022-07-13 22:30:01','795','2022-07-14 08:40:54',10,0),('5','89',257765,'Daily shift','2022-07-14','2022-07-14 12:09:54','2022-07-15 12:09:54','397',1757744.20,1757744.20,'397','2022-07-14 21:59:18','795','2022-07-15 16:37:01',10,0),('5','89',257766,'Daily shift','2022-07-15','2022-07-15 20:05:25','2022-07-16 20:05:25','397',1516559.70,1516559.70,'397','2022-07-17 15:08:43','600','2022-07-17 15:14:52',10,0),('5','89',257767,'Daily shift','2022-07-16','2022-07-17 21:38:30','2022-07-18 21:38:30','397',1406712.25,1406712.25,'397','2022-07-17 21:40:00','795','2022-07-18 11:29:45',10,0),('5','89',257768,'Daily shift','2022-07-17','2022-07-18 11:44:00','2022-07-19 11:44:00','397',810460.95,810460.95,'397','2022-07-18 11:45:22','795','2022-07-18 11:47:55',10,0),('5','89',257769,'Daily shift','2022-07-18','2022-07-18 11:52:05','2022-07-19 11:52:05','397',1043017.05,1043017.05,'397','2022-07-18 22:22:28','795','2022-07-19 06:53:25',10,0),('5','89',257770,'Daily shift','2022-07-19','2022-07-19 16:55:20','2022-07-20 16:55:20','397',1632902.50,1632902.50,'397','2022-07-19 22:30:55','795','2022-07-19 22:36:56',10,0),('5','89',257771,'Daily shift','2022-07-20','2022-07-20 09:57:58','2022-07-21 09:57:58','397',1651672.60,1651672.60,'397','2022-07-21 07:13:54','795','2022-07-21 11:24:37',10,0),('5','89',257772,'Daily shift','2022-07-21','2022-07-21 14:06:44','2022-07-22 14:06:44','397',1588184.30,1588184.30,'397','2022-07-21 20:31:25','795','2022-07-22 16:11:50',10,0),('5','89',257773,'Daily shift','2022-07-22','2022-07-22 20:29:03','2022-07-23 20:29:03','397',1582917.35,1582917.35,'397','2022-07-22 21:04:53','795','2022-07-23 12:47:40',10,0),('5','89',257774,'Daily shift','2022-07-23','2022-07-23 14:50:12','2022-07-24 14:50:12','397',1922614.35,1922614.35,'397','2022-07-23 22:02:08','795','2022-07-24 11:57:48',10,0),('5','89',257775,'Daily shift','2022-07-24','2022-07-24 18:28:52','2022-07-25 18:28:52','397',1611435.10,1611435.10,'397','2022-07-24 22:26:07','795','2022-07-25 09:21:35',10,0),('5','89',257776,'Daily shift','2022-07-25','2022-07-25 09:29:05','2022-07-26 09:29:05','397',1619847.05,1619847.05,'397','2022-07-25 20:44:26','795','2022-07-26 10:52:07',10,0),('5','89',257777,'Daily shift','2022-07-26','2022-07-26 11:07:00','2022-07-27 11:07:00','397',1566567.05,1566567.05,'397','2022-07-26 22:06:24','795','2022-07-27 09:26:45',10,0),('5','89',257778,'Daily shift','2022-07-27','2022-07-27 09:57:44','2022-07-28 09:57:44','397',1300934.80,1300934.80,'397','2022-07-27 21:15:20','795','2022-07-28 10:41:51',10,0),('5','89',257779,'Daily shift','2022-07-28','2022-07-28 12:18:36','2022-07-29 12:18:36','397',1240852.35,1240852.35,'397','2022-07-28 21:42:36','795','2022-07-29 16:46:49',10,0),('5','89',257780,'Daily shift','2022-07-29','2022-07-30 19:27:57','2022-07-31 19:27:57','397',0.00,0.00,'397','2022-07-30 19:28:13','795','2022-07-30 20:03:11',10,0),('5','89',257781,'Daily shift','2022-07-30','2022-07-31 21:12:42','2022-08-01 21:12:42','397',0.00,0.00,'397','2022-07-31 21:12:56','795','2022-08-01 09:20:33',10,0),('5','89',257782,'Daily shift','2022-07-31','2022-08-01 09:45:34','2022-08-02 09:45:34','397',0.00,0.00,'397','2022-08-01 09:46:02','795','2022-08-01 09:48:21',10,0),('5','89',257783,'Daily shift','2022-08-01','2022-08-01 11:07:06','2022-08-02 11:07:06','397',343372.95,343372.95,'397','2022-08-02 11:20:59','795','2022-08-02 11:22:49',10,0),('5','89',257784,'Daily shift','2022-08-02','2022-08-02 12:05:29','2022-08-03 12:05:29','397',1996312.80,1996312.80,'397','2022-08-02 21:08:47','795','2022-08-02 21:26:15',10,0),('5','89',257785,'Daily shift','2022-08-03','2022-08-03 10:21:48','2022-08-04 10:21:48','397',2096390.40,2096390.40,'397','2022-08-03 20:30:24','795','2022-08-04 10:50:44',10,0),('5','89',257786,'Daily shift','2022-08-04','2022-08-04 11:54:49','2022-08-05 11:54:49','397',1993954.05,1993954.05,'397','2022-08-04 20:12:29','795','2022-08-05 10:36:29',10,0),('5','89',257787,'Daily shift','2022-08-05','2022-08-05 13:51:13','2022-08-06 13:51:13','397',1979413.05,1979413.05,'397','2022-08-05 21:40:04','795','2022-08-06 14:45:55',10,0),('5','89',257788,'Daily shift','2022-08-06','2022-08-06 20:38:03','2022-08-07 20:38:03','397',2377425.75,2377425.75,'397','2022-08-06 20:40:10','795','2022-08-07 21:34:36',10,0),('5','89',257789,'Daily shift','2022-08-07','2022-08-07 21:45:31','2022-08-08 21:45:31','397',1876144.20,1876144.20,'397','2022-08-07 21:48:31','795','2022-08-07 22:23:31',10,0),('5','89',257790,'Daily shift','2022-08-08','2022-09-05 11:25:19','2022-09-06 11:25:19','397',1775137.90,1775137.90,'397','2022-09-06 10:35:09','795','2022-09-06 11:27:48',10,0),('5','89',257791,'Daily shift','2022-08-09','2022-09-06 15:06:00','2022-09-07 15:06:00','397',2284400.35,2284400.35,'397','2022-09-07 16:36:59','795','2022-09-07 16:41:45',10,0),('5','89',257792,'Daily shift','2022-08-10','2022-09-07 16:44:33','2022-09-08 16:44:33','397',2022566.15,2022566.15,'397','2022-09-07 16:46:30','795','2022-09-07 16:51:01',10,0),('5','89',257793,'Daily shift','2022-08-11','2022-09-07 16:54:16','2022-09-08 16:54:16','397',0.00,0.00,'397','2022-09-07 17:04:54','600','2022-09-07 17:06:57',10,0),('5','89',257794,'Daily shift','2022-08-11','2022-09-07 17:14:09','2022-09-08 17:14:09','397',1658297.45,1658297.45,'397','2022-09-07 17:15:43','795','2022-09-08 09:41:56',10,0),('5','89',257795,'Daily shift','2022-08-12','2022-09-08 09:44:24','2022-09-09 09:44:24','397',3027278.95,3027278.95,'397','2022-09-08 09:49:08','795','2022-09-08 09:50:58',10,0),('5','89',257796,'Daily shift','2022-08-13','2022-09-08 09:54:35','2022-09-09 09:54:35','397',2305040.80,2305040.80,'397','2022-09-08 10:21:25','795','2022-09-08 10:30:38',10,0),('5','89',257797,'Daily shift','2022-08-14','2022-09-08 10:36:01','2022-09-09 10:36:01','397',2385617.55,2385617.55,'397','2022-09-08 10:40:47','795','2022-09-08 10:41:53',10,0),('5','89',257798,'Daily shift','2022-08-15','2022-09-08 10:44:53','2022-09-09 10:44:53','397',2303272.20,2303272.20,'397','2022-09-08 10:48:13','795','2022-09-08 10:49:48',10,0),('5','89',257799,'Daily shift','2022-08-16','2022-09-08 10:50:23','2022-09-09 10:50:23','397',2247326.35,2247326.35,'397','2022-09-08 10:55:20','795','2022-09-08 10:56:14',10,0),('5','89',257800,'Daily shift','2022-08-17','2022-09-08 10:58:25','2022-09-09 10:58:25','397',2372343.80,2372343.80,'397','2022-09-08 11:01:11','795','2022-09-08 11:02:02',10,0),('5','89',257801,'Daily shift','2022-08-18','2022-09-08 11:02:49','2022-09-09 11:02:49','397',1762187.90,1762187.90,'397','2022-09-08 11:06:55','795','2022-09-08 11:09:02',10,0),('5','89',257802,'Daily shift','2022-08-19','2022-09-08 11:11:31','2022-09-09 11:11:31','397',2628213.60,2628213.60,'397','2022-09-08 11:16:25','795','2022-09-08 11:18:16',10,0),('5','89',257803,'Daily shift','2022-08-20','2022-09-08 11:20:35','2022-09-09 11:20:35','397',2262072.70,2262072.70,'397','2022-09-08 13:33:50','795','2022-09-09 10:08:45',10,0),('5','89',257804,'Daily shift','2022-08-21','2022-09-09 10:13:42','2022-09-10 10:13:42','397',2386783.05,2386783.05,'397','2022-09-09 10:17:35','795','2022-09-09 10:18:51',10,0),('5','89',257805,'Daily shift','2022-08-22','2022-09-09 10:19:55','2022-09-10 10:19:55','397',2261206.90,2261206.90,'397','2022-09-09 10:22:25','795','2022-09-09 10:24:44',10,0),('5','89',257806,'Daily shift','2022-08-23','2022-09-09 10:26:35','2022-09-10 10:26:35','397',2412642.35,2412642.35,'397','2022-09-09 10:29:40','795','2022-09-09 10:30:33',10,0),('5','89',257807,'Daily shift','2022-08-24','2022-09-09 10:35:06','2022-09-10 10:35:06','397',3343534.60,3343534.60,'397','2022-09-09 10:38:23','795','2022-09-09 10:40:10',10,0),('5','89',257808,'Daily shift','2022-08-25','2022-09-09 10:42:13','2022-09-10 10:42:13','397',2644837.70,2644837.70,'397','2022-09-09 10:44:21','795','2022-09-09 11:00:29',10,0),('5','89',257809,'Daily shift','2022-08-26','2022-09-09 11:01:55','2022-09-10 11:01:55','397',3669140.15,3669140.15,'397','2022-09-09 11:14:24','795','2022-09-09 11:51:11',10,0),('5','89',257810,'Daily shift','2022-08-27','2022-09-09 11:53:09','2022-09-10 11:53:09','397',2487066.00,2487066.00,'397','2022-09-09 11:56:20','795','2022-09-09 12:03:17',10,0),('5','89',257811,'Daily shift','2022-08-28','2022-09-09 12:06:25','2022-09-10 12:06:25','397',2127659.10,2127659.10,'397','2022-09-09 12:09:12','795','2022-09-09 12:10:13',10,0),('5','89',257812,'Daily shift','2022-08-29','2022-09-09 12:12:44','2022-09-10 12:12:44','397',3155972.35,3155972.35,'397','2022-09-09 12:15:37','795','2022-09-09 12:16:48',10,0),('5','89',257813,'Daily shift','2022-08-30','2022-09-09 12:19:46','2022-09-10 12:19:46','397',3280490.30,3280490.30,'397','2022-09-09 12:22:47','795','2022-09-09 12:23:53',10,0),('5','89',257814,'Daily shift','2022-08-31','2022-09-09 12:25:36','2022-09-10 12:25:36','397',2948467.10,2948467.10,'397','2022-09-09 15:07:24','795','2022-09-09 15:16:57',10,0),('5','89',257815,'Daily shift','2022-09-01','2022-09-09 15:18:37','2022-09-10 15:18:37','397',2883004.85,2883004.85,'397','2022-09-11 15:22:59','795','2022-09-11 16:59:27',10,0),('5','89',257816,'Daily shift','2022-09-02','2022-09-11 18:06:49','2022-09-12 18:06:49','397',2183144.30,2183144.30,'397','2022-09-11 21:23:11','795','2022-09-11 21:58:18',10,0),('5','89',257817,'Daily shift','2022-09-03','2022-09-11 22:21:06','2022-09-12 22:21:06','397',984375.75,984375.75,'397','2022-09-11 22:34:24','795','2022-09-11 22:50:52',10,0),('5','89',257818,'Daily shift','2022-09-04','2022-09-11 22:54:01','2022-09-12 22:54:01','397',348355.00,348355.00,'397','2022-09-12 05:30:20','795','2022-09-12 09:15:31',10,0),('5','89',257819,'Daily shift','2022-09-05','2022-09-12 09:32:17','2022-09-13 09:32:17','397',240339.05,240339.05,'397','2022-09-12 12:18:13','795','2022-09-12 12:20:18',10,0),('5','89',257820,'Daily shift','2022-09-06','2022-09-12 12:22:05','2022-09-13 12:22:05','397',2495180.10,2495180.10,'397','2022-09-12 12:25:57','795','2022-09-12 12:27:47',10,0),('5','89',257821,'Daily shift','2022-09-07','2022-09-12 12:35:47','2022-09-13 12:35:47','397',1990857.15,1990857.15,'397','2022-09-12 12:37:52','795','2022-09-12 12:39:40',10,0),('5','89',257822,'Daily shift','2022-09-08','2022-09-12 12:45:15','2022-09-13 12:45:15','397',2501290.65,2501290.65,'397','2022-09-12 13:16:42','795','2022-09-12 13:28:17',10,0),('5','89',257823,'Daily shift','2022-09-09','2022-09-12 13:50:23','2022-09-13 13:50:23','397',1999135.90,1999135.90,'397','2022-09-13 18:05:57','795','2022-09-13 19:07:40',10,0),('5','89',257824,'Daily shift','2022-09-10','2022-09-13 19:26:00','2022-09-14 19:26:00','397',2178796.80,2178796.80,'397','2022-09-14 05:45:02','795','2022-09-14 10:11:02',10,0),('5','89',257825,'Daily shift','2022-09-11','2022-09-15 07:31:04','2022-09-16 07:31:04','397',2142340.70,2142340.70,'397','2022-09-15 07:33:11','795','2022-09-15 09:38:54',10,0),('5','89',257826,'Daily shift','2022-09-12','2022-09-15 10:44:11','2022-09-16 10:44:11','397',2176719.25,2176719.25,'397','2022-09-15 10:45:38','795','2022-09-15 11:04:28',10,0),('5','89',257827,'Daily shift','2022-09-13','2022-09-15 12:33:40','2022-09-16 12:33:40','397',892599.10,892599.10,'397','2022-09-15 12:39:05','795','2022-09-16 08:03:56',10,0),('5','89',257828,'Daily shift','2022-09-14','2022-09-16 08:04:59','2022-09-17 08:04:59','397',2174724.95,2174724.95,'397','2022-09-16 08:11:15','795','2022-09-16 19:30:22',10,0),('5','89',257829,'Daily shift','2022-09-15','2022-09-16 19:55:47','2022-09-17 19:55:47','397',2666750.95,2666750.95,'397','2022-09-16 19:58:10','795','2022-09-16 21:54:27',10,0),('5','89',257830,'Daily shift','2022-09-16','2022-09-16 21:56:50','2022-09-17 21:56:50','397',2490349.75,2490349.75,'397','2022-09-16 22:04:15','795','2022-09-17 10:59:48',10,0),('5','89',257831,'Daily shift','2022-09-17','2022-09-17 11:01:24','2022-09-18 11:01:24','397',2128323.25,2128323.25,'397','2022-09-17 20:27:17','795','2022-09-18 11:25:17',10,0),('5','89',257832,'Daily shift','2022-09-18','2022-09-18 11:44:23','2022-09-19 11:44:23','397',2098763.95,2098763.95,'397','2022-09-18 21:12:27','795','2022-09-19 09:32:34',10,0),('5','89',257833,'Daily shift','2022-09-19','2022-09-19 09:53:39','2022-09-20 09:53:39','397',2501564.45,2501564.45,'397','2022-09-19 22:00:26','795','2022-09-20 12:13:20',10,0),('5','89',257834,'Daily shift','2022-09-20','2022-09-20 12:24:26','2022-09-21 12:24:26','397',2752698.25,2752698.25,'397','2022-09-20 21:42:27','795','2022-09-21 09:46:27',10,0),('5','89',257835,'Daily shift','2022-09-21','2022-09-21 17:25:11','2022-09-22 17:25:11','397',3078490.65,3078490.65,'397','2022-09-21 21:48:26','795','2022-09-22 14:03:40',10,0),('5','89',257836,'Daily shift','2022-09-22','2022-09-22 17:32:01','2022-09-23 17:32:01','397',2387532.30,2387532.30,'397','2022-09-22 22:19:22','795','2022-09-23 22:50:34',10,0),('5','89',257837,'Daily shift','2022-09-23','2022-09-24 04:56:37','2022-09-25 04:56:37','397',2557817.40,2557817.40,'397','2022-09-24 05:18:41','795','2022-09-24 16:27:09',10,0),('5','89',257838,'Daily shift','2022-09-24','2022-09-24 21:30:36','2022-09-25 21:30:36','397',3011748.20,3011748.20,'397','2022-09-24 21:52:45','795','2022-09-25 11:18:16',10,0),('5','89',257839,'Daily shift','2022-09-25','2022-09-26 06:38:55','2022-09-27 06:38:55','397',3064963.45,3064963.45,'397','2022-09-26 10:58:30','795','2022-09-26 12:05:38',10,0),('5','89',257840,'Daily shift','2022-09-26','2022-09-26 12:06:33','2022-09-27 12:06:33','397',4293835.20,4293835.20,'397','2022-09-27 05:46:12','795','2022-09-27 14:39:42',10,0),('5','89',257841,'Daily shift','2022-09-27','2022-09-27 14:40:36','2022-09-28 14:40:36','397',3274646.15,3274646.15,'397','2022-09-28 06:08:24','795','2022-09-28 10:08:13',10,0),('5','89',257842,'Daily shift','2022-09-28','2022-09-29 06:07:07','2022-09-30 06:07:07','397',2874737.20,2874737.20,'397','2022-09-29 06:10:36','795','2022-09-29 15:43:06',10,0),('5','89',257843,'Daily shift','2022-09-29','2022-09-30 06:53:22','2022-10-01 06:53:22','397',3009433.85,3009433.85,'397','2022-09-30 06:56:00','795','2022-09-30 09:24:43',10,0),('5','89',257844,'Daily shift','2022-09-30','2022-09-30 10:01:15','2022-10-01 10:01:15','397',4001860.80,4001860.80,'397','2022-10-01 07:30:45','795','2022-10-03 00:28:04',10,0),('5','89',257845,'Daily shift','2022-10-01','2022-10-03 09:06:39','2022-10-04 09:06:39','397',4626067.45,4626067.45,'397','2022-10-03 09:14:41','795','2022-10-03 11:55:04',10,0),('5','89',257846,'Daily shift','2022-10-02','2022-10-03 12:51:04','2022-10-04 12:51:04','397',3976280.85,3976280.85,'397','2022-10-03 12:53:54','795','2022-10-04 09:31:43',10,0),('5','89',257847,'Daily shift','2022-10-03','2022-10-04 16:34:35','2022-10-05 16:34:35','397',4169542.95,4169542.95,'397','2022-10-05 10:10:53','795','2022-10-05 13:15:42',10,0),('5','89',257848,'Daily shift','2022-10-04','2022-10-05 14:14:07','2022-10-06 14:14:07','397',2950091.40,2950091.40,'397','2022-10-05 15:13:08','795','2022-10-06 09:42:30',10,0),('5','89',257849,'Daily shift','2022-10-05','2022-10-06 10:35:46','2022-10-07 10:35:46','397',3090539.70,3090539.70,'397','2022-10-06 15:26:27','795','2022-10-07 10:08:44',10,0),('5','89',257850,'Daily shift','2022-10-06','2022-10-09 13:12:59','2022-10-10 13:12:59','397',2118675.50,2118675.50,'397','2022-10-09 13:13:54','795','2022-10-09 18:45:48',10,0),('5','89',257851,'Daily shift','2022-10-07','2022-10-11 09:40:53','2022-10-12 09:40:53','397',1912986.95,1912986.95,'397','2022-10-11 11:06:57','795','2022-10-11 11:27:36',10,0),('5','89',257852,'Daily shift','2022-10-08','2022-10-11 13:03:54','2022-10-12 13:03:54','397',574610.00,574610.00,'397','2022-10-11 13:11:23','795','2022-10-11 13:26:31',10,0),('5','89',257853,'Daily shift','2022-10-09','2022-10-11 19:19:58','2022-10-12 19:19:58','397',0.00,0.00,'397','2022-10-11 19:20:15','795','2022-10-12 15:13:37',10,0),('5','89',257854,'Daily shift','2022-10-10','2022-10-13 08:08:24','2022-10-14 08:08:24','397',0.00,0.00,'397','2022-10-13 08:08:38','795','2022-10-13 13:45:07',10,0),('5','89',257855,'Daily shift','2022-10-11','2022-10-13 14:51:07','2022-10-14 14:51:07','397',4890900.50,4890900.50,'397','2022-10-13 14:53:46','795','2022-10-14 16:48:09',10,0),('5','89',257856,'Daily shift','2022-10-12','2022-10-14 22:04:50','2022-10-15 22:04:50','397',4035453.10,4035453.10,'397','2022-10-15 07:38:33','795','2022-10-17 14:54:33',10,0),('5','89',257857,'Daily shift','2022-10-13','2022-10-17 14:58:16','2022-10-18 14:58:16','397',0.00,0.00,'600','2022-10-18 12:21:25','600','2022-10-18 12:21:43',10,0),('5','89',257858,'Daily shift','2022-10-13','2022-10-18 12:31:26','2022-10-19 12:31:26','397',2466514.35,2466514.35,'397','2022-10-18 12:36:28','795','2022-10-18 15:27:12',10,0),('5','89',257859,'Daily shift','2022-10-14','2022-10-18 15:42:07','2022-10-19 15:42:07','397',5394289.20,5394289.20,'397','2022-10-18 15:49:20','795','2022-10-19 08:44:48',10,0),('5','89',257860,'Daily shift','2022-10-15','2022-10-19 12:24:03','2022-10-20 12:24:03','397',0.00,0.00,'397','2022-10-19 12:34:04','606','2022-10-19 12:46:06',10,0),('5','89',257861,'Daily shift','2022-10-16','2022-10-19 13:03:30','2022-10-20 13:03:30','397',4707839.30,4707839.30,'397','2022-10-19 13:08:50','606','2022-10-19 13:10:38',10,0),('5','89',257862,'Daily shift','2022-10-17','2022-10-19 13:11:30','2022-10-20 13:11:30','397',5274694.10,5274694.10,'397','2022-10-19 13:17:01','606','2022-10-19 13:21:44',10,0),('5','89',257863,'Daily shift','2022-10-18','2022-10-19 13:22:56','2022-10-20 13:22:56','397',1737005.70,1737005.70,'397','2022-10-19 13:25:16','606','2022-10-19 13:26:51',10,0),('5','89',257864,'Daily shift','2022-10-19','2022-10-19 13:32:06','2022-10-20 13:32:06','397',1078220.70,1078220.70,'397','2022-10-19 20:20:38','795','2022-10-20 10:09:55',10,0),('5','89',257865,'Daily shift','2022-10-20','2022-10-20 10:40:25','2022-10-21 10:40:25','397',3764466.95,3764466.95,'397','2022-10-20 21:12:18','795','2022-10-20 21:28:15',10,0),('5','89',257866,'Daily shift','2022-10-21','2022-10-21 14:52:48','2022-10-22 14:52:48','397',2757167.85,2757167.85,'397','2022-10-21 22:30:24','606','2022-10-22 08:42:03',10,0),('5','89',257867,'Daily shift','2022-10-22','2022-10-22 19:36:07','2022-10-23 19:36:07','397',2960223.85,2960223.85,'397','2022-10-22 20:09:28','606','2022-10-23 09:04:53',10,0),('5','89',257868,'Daily shift','2022-10-23','2022-10-23 21:03:46','2022-10-24 21:03:46','397',2313162.30,2313162.30,'397','2022-10-23 21:05:38','795','2022-10-24 09:56:58',10,0),('5','89',257869,'Daily shift','2022-10-24','2022-10-24 13:41:05','2022-10-25 13:41:05','397',967905.20,967905.20,'397','2022-10-24 22:02:03','795','2022-10-25 15:43:13',10,0),('5','89',257870,'Daily shift','2022-10-25','2022-10-25 20:51:40','2022-10-26 20:51:40','397',2355357.10,2355357.10,'397','2022-10-25 20:53:00','795','2022-10-26 14:19:07',10,0),('5','89',257871,'Daily shift','2022-10-26','2022-10-26 15:42:57','2022-10-27 15:42:57','397',2491084.20,2491084.20,'397','2022-10-26 21:50:23','795','2022-10-27 10:03:57',10,0),('5','89',257872,'Daily shift','2022-10-27','2022-10-27 11:20:43','2022-10-28 11:20:43','397',4514876.90,4514876.90,'397','2022-10-27 21:46:20','606','2022-10-28 21:01:46',10,0),('5','89',257873,'Daily shift','2022-10-28','2022-10-29 06:53:47','2022-10-30 06:53:47','397',4697161.10,4697161.10,'397','2022-10-29 19:33:19','795','2022-10-31 11:26:00',10,0),('5','89',257874,'Daily shift','2022-10-29','2022-10-31 13:32:59','2022-11-01 13:32:59','397',3917228.85,3917228.85,'397','2022-10-31 13:35:10','600','2022-10-31 13:50:53',10,0),('5','89',257875,'Daily shift','2022-10-30','2022-10-31 13:53:49','2022-11-01 13:53:49','397',2327969.70,2327969.70,'397','2022-11-01 11:00:39','600','2022-11-02 11:02:15',10,0),('5','89',257876,'Daily shift','2022-10-31','2022-11-02 13:22:57','2022-11-03 13:22:57','397',374861.80,374861.80,'397','2022-11-03 07:10:04','600','2022-11-03 08:16:23',10,0),('5','89',257877,'Daily shift','2022-11-01','2022-11-03 11:17:14','2022-11-04 11:17:14','397',0.00,0.00,'397','2022-11-05 19:27:55','606','2022-11-05 19:39:38',10,0),('5','89',257878,'Daily shift','2022-11-02','2022-11-05 19:41:37','2022-11-06 19:41:37','397',3235037.65,3235037.65,'397','2022-11-05 19:44:30','606','2022-11-05 19:51:15',10,0),('5','89',257879,'Daily shift','2022-11-03','2022-11-05 19:53:26','2022-11-06 19:53:26','397',3628144.15,3628144.15,'397','2022-11-05 19:55:54','606','2022-11-05 19:57:24',10,0),('5','89',257880,'Daily shift','2022-11-04','2022-11-05 21:12:13','2022-11-06 21:12:13','397',3085337.50,3085337.50,'397','2022-11-05 21:50:19','606','2022-11-05 21:51:43',10,0),('5','89',257881,'Daily shift','2022-11-05','2022-11-06 08:35:59','2022-11-07 08:35:59','397',3692742.45,3692742.45,'397','2022-11-06 10:16:20','600','2022-11-07 09:28:02',10,0),('5','89',257882,'Daily shift','2022-11-06','2022-11-07 09:43:58','2022-11-08 09:43:58','397',4738978.50,4738978.50,'397','2022-11-07 09:50:12','606','2022-11-07 10:34:57',10,0),('5','89',257883,'Daily shift','2022-11-07','2022-11-07 12:02:38','2022-11-08 12:02:38','397',2847518.15,2847518.15,'397','2022-11-08 08:48:26','600','2022-11-09 08:19:05',10,0),('5','89',257884,'Daily shift','2022-11-08','2022-11-09 09:36:37','2022-11-10 09:36:37','397',2538003.90,2538003.90,'397','2022-11-09 09:38:43','606','2022-11-09 16:47:33',10,0),('5','89',257885,'Daily shift','2022-11-09','2022-11-09 22:08:22','2022-11-10 22:08:22','397',2401029.90,2401029.90,'397','2022-11-09 22:09:22','606','2022-11-10 17:06:07',10,0),('5','89',257886,'Daily shift ','2022-11-10','2022-11-11 22:21:07','2022-11-12 22:21:07','397',3243991.65,3243991.65,'397','2022-11-11 22:23:31','606','2022-11-12 23:34:12',10,0),('5','89',257887,'Daily shift ','2022-11-11','2022-11-13 10:43:23','2022-11-14 10:43:23','397',2682006.05,2682006.05,'397','2022-11-13 10:48:53','606','2022-11-13 14:59:58',10,0),('5','89',257888,'Daily shift','2022-11-12','2022-11-16 10:45:49','2022-11-17 10:45:49','397',2571670.20,2571670.20,'397','2022-11-16 10:48:07','606','2022-11-17 07:23:41',10,0),('5','89',257889,'Daily shift','2022-11-13','2022-11-17 21:45:18','2022-11-18 21:45:18','397',1370781.55,1370781.55,'397','2022-11-17 21:47:35','606','2022-11-18 13:46:25',10,0),('5','89',257890,'Daily shift ','2022-11-18','2022-11-18 23:00:29','2022-11-19 23:00:29','397',151057.20,156452.10,'397','2022-11-18 23:34:24','606','2022-11-19 18:29:19',10,0),('5','89',257891,'Daily shift','2022-11-15','2022-11-19 21:46:46','2022-11-20 21:46:46','397',1713810.00,1775017.50,'397','2022-11-19 21:47:59','606','2022-11-19 21:54:39',10,0),('5','89',257892,'Daily shift','2022-11-16','2022-11-19 22:01:59','2022-11-20 22:01:59','397',2198338.70,2269150.70,'397','2022-11-19 22:04:30','606','2022-11-19 22:06:34',10,0),('5','89',257893,'Daily shift','2022-11-17','2022-11-19 22:10:00','2022-11-20 22:10:00','397',2502517.20,2502517.20,'397','2022-11-19 22:16:10','606','2022-11-19 22:19:17',10,0),('5','89',257894,'Daily shift ','2022-11-18','2022-11-19 22:21:25','2022-11-20 22:21:25','397',2883758.60,2890469.90,'397','2022-11-19 22:23:48','606','2022-11-19 22:24:54',10,0),('5','89',257895,'Daily shift','2022-11-19','2022-11-19 22:30:41','2022-11-20 22:30:41','397',2075057.45,2079295.25,'397','2022-11-19 22:32:40','606','2022-11-20 21:02:01',10,0),('5','89',257896,'Daily shift','2022-11-20','2022-11-20 22:24:33','2022-11-21 22:24:33','397',364047.90,367726.80,'397','2022-11-20 22:28:00','606','2022-11-21 07:23:52',10,0),('5','89',257897,'DAILY SHIFT','2022-11-21','2022-11-21 10:13:52','2022-11-22 10:13:52','397',3030582.70,3032742.10,'397','2022-11-22 07:24:59','606','2022-11-22 09:12:54',10,0),('5','89',257898,'Daily shift','2022-11-22','2022-11-22 10:03:51','2022-11-23 10:03:51','397',4197483.25,4215945.25,'397','2022-11-23 07:45:07','606','2022-11-24 13:02:06',10,0),('5','89',257899,'Daily shift','2022-11-23','2022-11-24 16:49:25','2022-11-25 16:49:25','397',3591486.40,3591486.40,'397','2022-11-24 16:51:28','606','2022-11-24 17:16:58',10,0),('5','89',257900,'Daily shift ','2022-11-24','2022-11-25 08:54:05','2022-11-26 08:54:05','397',3615238.55,3615238.55,'397','2022-11-25 14:59:33','606','2022-11-27 07:56:16',10,0),('5','89',257901,'Daily shift ','2022-11-25','2022-11-27 23:15:42','2022-11-28 23:15:42','397',3779760.90,3779760.90,'397','2022-11-27 23:19:03','606','2022-11-28 06:59:54',10,0),('5','89',257902,'Daily shift ','2022-11-26','2022-11-28 11:44:43','2022-11-29 11:44:43','397',5086699.20,5086699.20,'397','2022-11-28 21:46:59','606','2022-11-29 09:51:45',10,0),('5','89',257903,'Daily shift ','2022-11-27','2022-11-29 10:40:30','2022-11-30 10:40:30','397',4102478.30,4102478.30,'397','2022-11-29 10:47:50','606','2022-11-29 11:22:06',10,0),('5','89',257904,'Daily shift','2022-11-28','2022-11-29 12:21:38','2022-11-30 12:21:38','397',4562721.85,4562721.85,'397','2022-11-29 13:31:33','606','2022-11-29 14:20:34',10,0),('5','89',257905,'Daily shift','2022-11-29','2022-11-29 15:03:29','2022-11-30 15:03:29','397',4965835.20,4965835.20,'397','2022-11-29 20:41:23','606','2022-11-30 11:33:51',10,0),('5','89',257906,'Daily shift','2022-11-30','2022-11-30 21:11:59','2022-12-01 21:11:59','397',4730712.80,4730712.80,'397','2022-12-01 15:35:35','606','2022-12-01 15:50:02',10,0),('5','89',257907,'Daily shift ','2022-12-01','2022-12-01 16:15:01','2022-12-02 16:15:01','397',5032951.50,5032951.50,'397','2022-12-01 22:42:22','606','2022-12-02 12:56:16',10,0),('5','89',257908,'Daily shift ','2022-12-02','2022-12-02 13:51:46','2022-12-03 13:51:46','397',2285802.85,2285802.85,'397','2022-12-03 08:51:04','606','2022-12-04 08:52:00',10,0),('5','89',257909,'Daily shift ','2022-12-03','2022-12-04 09:03:57','2022-12-05 09:03:57','397',2116837.60,2116837.60,'397','2022-12-04 09:06:12','795','2022-12-04 09:15:53',10,0),('5','89',257910,'Daily shift ','2022-12-04','2022-12-04 10:21:29','2022-12-05 10:21:29','397',1307344.45,1307344.45,'397','2022-12-04 21:45:27','795','2022-12-05 08:30:09',10,0),('5','89',257911,'Daily shift ','2022-12-05','2022-12-05 13:04:37','2022-12-06 13:04:37','397',877129.70,877129.70,'397','2022-12-07 09:44:04','795','2022-12-07 14:54:59',10,0),('5','89',257912,'Daily shift ','2022-12-06','2022-12-08 06:34:48','2022-12-09 06:34:48','397',2731353.60,2731353.60,'397','2022-12-08 06:37:27','795','2022-12-08 09:25:09',10,0),('5','89',257913,'Daily shift ','2022-12-07','2022-12-08 10:12:30','2022-12-09 10:12:30','397',3439688.05,3439688.05,'397','2022-12-08 10:16:15','795','2022-12-08 10:37:16',10,0),('5','89',257914,'Daily shift ','2022-12-08','2022-12-08 14:15:47','2022-12-09 14:15:47','397',2241411.05,2241411.05,'397','2022-12-09 14:14:45','795','2022-12-09 14:28:24',10,0),('5','89',257915,'Daily shift ','2022-12-09','2022-12-09 20:32:40','2022-12-10 20:32:40','397',20775.60,20775.60,'397','2022-12-10 07:38:08','795','2022-12-10 18:18:14',10,0),('5','89',257916,'Daily shift ','2022-12-09','2022-12-10 21:41:37','2022-12-11 21:41:37','397',14543319.90,3111490.25,'397','2022-12-10 21:44:53','795','2022-12-11 19:01:04',10,0),('5','89',257917,'Daily shift ','2022-12-10','2022-12-11 19:05:10','2022-12-12 19:05:10','397',2888726.90,2888726.90,'397','2022-12-11 19:19:38','795','2022-12-11 19:29:25',10,0),('5','89',257918,'Daily shift ','2022-12-11','2022-12-11 20:08:44','2022-12-12 20:08:44','397',601080.20,601080.20,'397','2022-12-11 22:33:53','795','2022-12-11 23:10:42',10,0),('5','89',257919,'Daily shift','2022-12-12','2022-12-12 11:47:18','2022-12-13 11:47:18','397',243065.25,243065.25,'397','2022-12-12 22:09:02','1013','2022-12-14 14:37:51',10,0),('5','89',257920,'Daily shift ','2022-12-13','2022-12-14 20:53:54','2022-12-15 20:53:54','397',250366.50,250366.50,'397','2022-12-14 20:55:03','1013','2022-12-15 10:30:31',10,0),('5','89',257921,'Daily shift','2022-12-14','2022-12-15 10:49:54','2022-12-16 10:49:54','397',160848.75,160848.75,'397','2022-12-15 10:50:22','1013','2022-12-15 11:00:20',10,0),('5','89',257922,'Daily shift','2022-12-15','2022-12-16 08:30:37','2022-12-17 08:30:37','397',418091.70,418091.70,'397','2022-12-16 08:31:08','1013','2022-12-16 14:12:00',10,0),('5','89',257923,'Daily shift','2022-12-16','2022-12-16 23:03:49','2022-12-17 23:03:49','397',554417.10,554417.10,'397','2022-12-16 23:04:27','1013','2022-12-17 12:30:57',10,0),('5','89',257924,'Daily shift','2022-12-17','2022-12-17 22:02:40','2022-12-18 22:02:40','397',470182.80,470182.80,'397','2022-12-17 22:04:46','1013','2022-12-19 09:04:55',10,0),('5','89',257925,'Daily shift','2022-12-18','2022-12-19 10:09:59','2022-12-20 10:09:59','397',414082.65,414082.65,'397','2022-12-19 10:16:32','1013','2022-12-19 12:08:25',10,0),('5','89',257926,'Daily shift','2022-12-19','2022-12-19 22:18:21','2022-12-20 22:18:21','397',448031.25,448031.25,'397','2022-12-19 22:18:50','1013','2022-12-20 09:38:31',10,0),('5','89',257927,'Daily shift','2022-12-20','2022-12-20 12:42:01','2022-12-21 12:42:01','397',170619.15,170619.15,'397','2022-12-21 07:29:32','1013','2022-12-21 09:38:32',10,0),('5','89',257928,'Daily shift','2022-12-21','2022-12-21 22:04:40','2022-12-22 22:04:40','397',211222.95,211222.95,'397','2022-12-21 22:05:33','1013','2022-12-22 09:02:11',10,0),('5','89',257929,'Daily shift','2022-12-22','2022-12-22 09:31:39','2022-12-23 09:31:39','397',248092.05,248092.05,'397','2022-12-22 21:38:36','1013','2022-12-23 11:10:53',10,0),('5','89',257930,'Daily shift','2022-12-23','2022-12-23 22:44:30','2022-12-24 22:44:30','397',183195.00,183195.00,'397','2022-12-23 22:45:07','1013','2022-12-25 18:30:08',10,0),('5','89',257931,'Daily shift','2022-12-24','2022-12-27 14:08:09','2022-12-28 14:08:09','397',0.00,0.00,'397','2022-12-27 14:08:49','1013','2022-12-28 09:02:29',10,0),('5','89',257932,'Daily shift','2022-12-25','2022-12-28 13:32:35','2022-12-29 13:32:35','397',0.00,0.00,'397','2022-12-28 13:32:51','1013','2022-12-29 07:57:06',10,0),('5','89',257933,'Daily','2022-12-26','2022-12-29 18:37:28','2022-12-30 18:37:28','397',0.00,0.00,'397','2022-12-29 18:37:49','1013','2022-12-30 08:48:31',10,0),('5','89',257934,'Daily shift','2022-12-27','2022-12-30 22:04:50','2022-12-31 22:04:50','397',0.00,0.00,'397','2022-12-30 22:05:26','1013','2023-01-01 11:31:33',10,0),('5','89',257935,'Daily shift','2022-12-28','2023-01-01 15:58:48','2023-01-02 15:58:48','397',0.00,0.00,'397','2023-01-01 15:59:01','1013','2023-01-02 21:58:06',10,0),('5','89',257936,'Daily shift','2022-12-29','2023-01-03 13:14:10','2023-01-04 13:14:10','397',0.00,0.00,'397','2023-01-03 13:14:24','1013','2023-01-03 14:22:39',10,0),('5','89',257937,'Daily shift','2022-12-30','2023-01-03 14:58:43','2023-01-04 14:58:43','397',0.00,0.00,'397','2023-01-03 14:59:00','1013','2023-01-03 15:27:47',10,0),('5','89',257938,'Daily shift','2022-12-31','2023-01-03 15:35:53','2023-01-04 15:35:53','397',0.00,0.00,'397','2023-01-03 15:36:09','1013','2023-01-03 15:42:29',10,0),('5','89',257939,'Daily shift','2023-01-01','2023-01-03 15:45:48','2023-01-04 15:45:48','397',0.00,0.00,'397','2023-01-03 15:46:03','1013','2023-01-03 16:08:00',10,0),('5','89',257940,'Daily shift','2023-01-02','2023-01-03 16:13:11','2023-01-04 16:13:11','397',0.00,0.00,'397','2023-01-03 16:13:27','1013','2023-01-03 16:14:19',10,0),('5','89',257941,'Daily shift','2023-01-03','2023-01-03 16:17:59','2023-01-04 16:17:59','397',0.00,0.00,'397','2023-01-03 21:24:34','1013','2023-01-04 11:39:07',10,0),('5','89',257942,'Daily shift','2023-01-04','2023-01-04 14:10:55','2023-01-05 14:10:55','397',0.00,0.00,'397','2023-01-05 20:26:15','1013','2023-01-06 09:12:48',10,0),('5','89',257943,'Daily shift','2023-01-05','2023-01-08 09:50:11','2023-01-09 09:50:11','397',0.00,0.00,'397','2023-01-08 09:50:27','1013','2023-01-08 10:34:22',10,0),('5','89',257944,'Daily shift','2023-01-06','2023-01-09 09:32:58','2023-01-10 09:32:58','397',0.00,0.00,'397','2023-01-09 09:33:20','1013','2023-01-09 09:39:11',10,0),('5','89',257945,'Daily shift','2023-01-07','2023-01-09 09:53:00','2023-01-10 09:53:00','397',0.00,0.00,'397','2023-01-09 09:53:15','1013','2023-01-09 09:58:00',10,0),('5','89',257946,'Daily shift','2023-01-08','2023-01-09 10:22:58','2023-01-10 10:22:58','397',0.00,0.00,'397','2023-01-09 10:23:13','1013','2023-01-09 10:24:11',10,0),('5','89',257947,'Daily shift','2023-01-09','2023-01-09 11:29:49','2023-01-10 11:29:49','397',0.00,0.00,'397','2023-01-10 08:29:03','1013','2023-01-10 09:13:26',10,0),('5','89',257948,'Daily shift','2023-01-10','2023-01-10 23:44:13','2023-01-11 23:44:13','397',0.00,0.00,'397','2023-01-10 23:44:30','1013','2023-01-11 11:46:22',10,0),('5','89',257949,'Daily shift','2023-01-11','2023-01-11 20:11:06','2023-01-12 20:11:06','397',0.00,0.00,'397','2023-01-11 20:11:22','1013','2023-01-11 20:54:27',10,0),('5','89',257950,'Daily shift','2023-01-12','2023-01-12 21:11:38','2023-01-13 21:11:38','397',0.00,0.00,'397','2023-01-12 21:11:50','1013','2023-01-12 22:26:36',10,0),('5','89',257951,'Daily shift','2023-01-14','2023-01-14 01:03:59','2023-01-15 01:03:59','397',385952.55,385952.55,'397','2023-01-14 16:02:55','1013','2023-01-14 16:07:15',10,0),('5','89',257952,'Daily shift','2023-01-14','2023-01-14 16:35:09','2023-01-15 16:35:09','397',3260974.65,3260974.65,'397','2023-01-14 23:20:02','1013','2023-01-15 09:00:29',10,0),('5','89',257953,'Daily shift ','2023-01-15','2023-01-15 10:36:55','2023-01-16 10:36:55','397',3386869.00,3386869.00,'397','2023-01-16 11:59:17','1013','2023-01-16 12:16:45',10,0),('5','89',257954,'Daily shift','2023-01-16','2023-01-16 16:26:02','2023-01-17 16:26:02','397',1138991.75,1137506.75,'397','2023-01-17 10:12:23','1013','2023-01-17 10:24:46',10,0),('5','89',257955,'Daily shift','2023-01-17','2023-01-17 20:25:40','2023-01-18 20:25:40','397',0.00,0.00,'397','2023-01-17 21:37:19','1013','2023-01-18 09:25:03',10,0),('5','89',257956,'Daily shift','2023-01-18','2023-01-18 23:35:36','2023-01-19 23:35:36','397',0.00,0.00,'397','2023-01-18 23:35:51','1013','2023-01-19 09:31:59',10,0),('5','89',257957,'Daily shift','2023-01-19','2023-01-19 19:16:56','2023-01-20 19:16:56','397',0.00,0.00,'397','2023-01-19 19:17:10','1013','2023-01-20 08:57:20',10,0),('5','89',257958,'Daily shift','2023-01-20','2023-01-20 21:54:11','2023-01-21 21:54:11','397',0.00,0.00,'397','2023-01-20 21:54:38','1013','2023-01-21 08:20:50',10,0),('5','89',257959,'Daily shift ','2023-01-21','2023-01-21 18:56:10','2023-01-22 18:56:10','397',0.00,0.00,'397','2023-01-21 18:56:38','1013','2023-01-22 10:32:50',10,0),('5','89',257960,'Daily shift ','2023-01-22','2023-01-22 14:59:56','2023-01-23 14:59:56','397',4284057.80,4284057.80,'397','2023-01-23 11:24:48','1013','2023-01-23 12:27:28',10,0),('5','89',257961,'Daily shift','2023-01-23','2023-01-23 13:42:46','2023-01-24 13:42:46','397',2285173.00,2285173.00,'397','2023-01-23 21:49:12','1013','2023-01-24 11:28:54',10,0),('5','89',257962,'Daily shift','2023-01-24','2023-01-24 14:49:13','2023-01-25 14:49:13','397',2019806.80,2019806.80,'397','2023-01-25 13:25:31','1013','2023-01-25 13:31:28',10,0),('5','89',257963,'Daily shift','2023-01-25','2023-01-25 22:07:15','2023-01-26 22:07:15','397',1132208.00,1132208.00,'397','2023-01-25 22:11:30','1013','2023-01-26 13:31:18',10,0),('5','89',257964,'Daily shift','2023-01-26','2023-01-26 17:44:01','2023-01-27 17:44:01','397',0.00,0.00,'397','2023-01-26 22:50:38','1013','2023-01-27 10:08:44',10,0),('5','89',257965,'Daily shift','2023-01-27','2023-01-27 22:20:44','2023-01-28 22:20:44','397',0.00,0.00,'397','2023-01-27 22:21:30','1013','2023-01-28 10:06:55',10,0),('5','89',257966,'Daily shift','2023-01-28','2023-01-29 08:58:50','2023-01-30 08:58:50','397',0.00,0.00,'397','2023-01-29 08:59:17','1013','2023-01-29 10:02:38',10,0),('5','89',257967,'Daily shift','2023-01-29','2023-01-29 23:03:34','2023-01-30 23:03:34','397',0.00,0.00,'397','2023-01-29 23:03:51','1013','2023-01-30 09:53:33',10,0),('5','89',257968,'Daily shift','2023-01-30','2023-01-30 23:39:13','2023-01-31 23:39:13','397',0.00,0.00,'397','2023-01-30 23:39:37','1013','2023-01-31 08:40:42',10,0),('5','89',257969,'Daily shift','2023-01-31','2023-02-01 07:03:45','2023-02-02 07:03:45','397',0.00,0.00,'397','2023-02-01 07:04:15','1013','2023-02-01 09:24:29',10,0),('5','89',257970,'Daily shift','2023-02-01','2023-02-01 14:57:40','2023-02-02 14:57:40','397',149036.80,149036.80,'397','2023-02-02 11:00:27','1013','2023-02-02 11:03:42',10,0),('5','89',257971,'Daily shift','2023-02-01','2023-02-02 11:07:24','2023-02-03 11:07:24','397',2362773.60,2362773.60,'397','2023-02-02 11:09:05','1013','2023-02-02 13:26:21',10,0),('5','89',257972,'Daily shift ','2023-02-02','2023-02-03 01:39:50','2023-02-04 01:39:50','397',2050250.40,2050250.40,'397','2023-02-03 01:41:27','1013','2023-02-03 09:39:55',10,0),('5','89',257973,'Daily shift','2023-02-03','2023-02-03 21:50:07','2023-02-04 21:50:07','397',1995215.20,1995215.20,'397','2023-02-03 21:51:13','1013','2023-02-04 13:02:07',10,0),('5','89',257974,'Daily shift ','2023-02-04','2023-02-04 15:19:46','2023-02-05 15:19:46','397',669596.40,669596.40,'397','2023-02-05 06:43:17','1013','2023-02-05 16:25:02',10,0),('5','89',257975,'Daily shift','2023-02-05','2023-02-07 04:04:35','2023-02-08 04:04:35','397',0.00,0.00,'397','2023-02-07 04:04:57','1013','2023-02-07 09:21:02',10,0),('5','89',257976,'Daily shift ','2023-02-06','2023-02-07 14:20:18','2023-02-08 14:20:18','397',224890.60,224890.60,'397','2023-02-07 14:23:23','1013','2023-02-07 20:39:20',10,0),('5','89',257977,'Daily shift','2023-02-07','2023-02-07 22:04:29','2023-02-08 22:04:29','397',2185631.80,2185631.80,'397','2023-02-08 10:00:11','1013','2023-02-09 12:08:52',10,0),('5','89',257978,'Daily shift ','2023-02-08','2023-02-09 13:02:35','2023-02-10 13:02:35','397',2226611.20,2226611.20,'397','2023-02-09 13:04:51','1013','2023-02-09 13:17:20',10,0),('5','89',257979,'Daily shift','2023-02-09','2023-02-09 22:37:55','2023-02-10 22:37:55','397',1635559.20,1635559.20,'397','2023-02-09 22:40:04','1013','2023-02-10 09:25:05',10,0),('5','89',257980,'Daily shift','2023-02-10','2023-02-11 06:24:03','2023-02-12 06:24:03','397',445891.60,445891.60,'397','2023-02-11 06:25:53','1013','2023-02-11 13:12:16',10,0),('5','89',257981,'Daily shift','2023-02-11','2023-02-12 19:55:54','2023-02-13 19:55:54','397',0.00,0.00,'397','2023-02-12 20:10:09','1013','2023-02-13 09:37:07',10,0),('5','89',257982,'Daily shift','2023-02-12','2023-02-14 23:46:04','2023-02-15 23:46:04','397',0.00,0.00,'397','2023-02-14 23:46:17','1013','2023-02-15 13:24:05',10,0),('5','89',257983,'Daily shift','2023-02-13','2023-02-15 15:15:13','2023-02-16 15:15:13','397',0.00,0.00,'397','2023-02-15 15:15:27','1013','2023-02-15 15:34:36',10,0),('5','89',257984,'Daily shift','2023-02-14','2023-02-15 16:04:00','2023-02-16 16:04:00','397',166544.40,166544.40,'397','2023-02-15 16:05:36','1013','2023-02-15 16:24:31',10,0),('5','89',257985,'Daily shift ','2023-02-15','2023-02-16 11:26:41','2023-02-17 11:26:41','397',0.00,0.00,'397','2023-02-16 11:26:59','1013','2023-02-17 09:21:47',10,0),('5','89',257986,'Daily shift','2023-02-16','2023-02-17 10:39:04','2023-02-18 10:39:04','397',0.00,0.00,'397','2023-02-17 10:39:21','1013','2023-02-18 21:06:18',10,0),('5','89',257987,'Daily shift','2023-02-17','2023-02-19 19:43:18','2023-02-20 19:43:18','397',0.00,0.00,'397','2023-02-19 19:43:36','1013','2023-02-20 09:31:20',10,0),('5','89',257988,'Daily shift','2023-02-18','2023-02-22 11:51:55','2023-02-23 11:51:55','397',0.00,0.00,'397','2023-02-22 11:53:25','1013','2023-02-23 19:54:58',10,0),('5','89',257989,'Daily shift ','2023-02-19','2023-02-23 23:33:38','2023-02-24 23:33:38','397',0.00,0.00,'397','2023-02-23 23:34:01','1013','2023-02-24 10:54:09',10,0),('5','89',257990,'Daily shift ','2023-02-20','2023-02-24 12:04:33','2023-02-25 12:04:33','397',0.00,0.00,'397','2023-02-24 12:05:13','1013','2023-02-24 12:46:43',10,0),('5','89',257991,'Daily shift','2023-02-21','2023-02-24 15:15:36','2023-02-25 15:15:36','397',0.00,0.00,'397','2023-02-24 15:15:51','1013','2023-02-24 16:18:22',10,0),('5','89',257992,'Daily shift','2023-02-22','2023-02-24 16:53:40','2023-02-25 16:53:40','397',0.00,0.00,'397','2023-02-24 16:54:01','1013','2023-02-24 16:58:14',10,0),('5','89',257993,'Daily shift ','2023-02-24','2023-02-24 17:24:24','2023-02-25 17:24:24','397',367361.40,367361.40,'397','2023-02-24 17:30:58','1013','2023-02-25 21:28:34',10,0),('5','89',257994,'Daily shift','2023-02-24','2023-02-26 15:36:38','2023-02-27 15:36:38','397',4640865.60,4640865.60,'397','2023-02-26 20:25:24','1013','2023-02-26 20:56:16',10,0),('5','89',257995,'Daily shift','2023-02-25','2023-02-27 06:43:51','2023-02-28 06:43:51','397',2804732.70,2804732.70,'397','2023-02-27 06:44:55','1013','2023-02-27 08:44:43',10,0),('5','89',257996,'DAILY SHIFT','2023-02-26','2023-02-27 09:18:50','2023-02-28 09:18:50','397',3906203.70,3906203.70,'397','2023-02-27 09:21:29','1013','2023-02-28 09:25:09',10,0),('5','89',257997,'Daily shift ','2023-02-27','2023-02-28 21:52:19','2023-03-01 21:52:19','397',5095328.70,5095328.70,'397','2023-02-28 21:55:31','1013','2023-03-01 09:20:06',10,0),('5','89',257998,'Daily shift','2023-02-28','2023-03-01 22:22:40','2023-03-02 22:22:40','397',4891523.70,4891523.70,'397','2023-03-02 13:30:24','1013','2023-03-03 11:11:28',10,0),('5','89',257999,'Daily shift','2023-03-01','2023-03-03 11:46:55','2023-03-04 11:46:55','397',3665396.70,3839939.40,'397','2023-03-03 11:54:45','1013','2023-03-03 12:08:44',10,0),('5','89',258000,'Daily shift','2023-03-02','2023-03-03 12:13:22','2023-03-04 12:13:22','397',2896168.80,2896168.80,'397','2023-03-03 12:16:03','1013','2023-03-03 13:50:15',10,0),('5','89',258001,'DAILY SHIFT','2023-03-03','2023-03-03 14:23:56','2023-03-04 14:23:56','397',2455752.60,2455752.60,'397','2023-03-04 07:38:09','1013','2023-03-04 10:15:03',10,0),('5','89',258002,'Daily shift ','2023-03-04','2023-03-05 00:38:23','2023-03-06 00:38:23','397',3514173.60,3514173.60,'397','2023-03-06 13:45:12','1013','2023-03-06 13:57:37',10,0),('5','89',258003,'Daily shift ','2023-03-05','2023-03-06 14:07:54','2023-03-07 14:07:54','397',3068711.10,3068711.10,'397','2023-03-06 14:08:53','1013','2023-03-07 09:26:50',10,0),('5','89',258004,'Daily shift','2023-03-06','2023-03-07 09:37:43','2023-03-08 09:37:43','397',337537.20,337537.20,'397','2023-03-07 09:40:13','1013','2023-03-07 09:41:30',10,0),('5','89',258005,'Daily shift','2023-03-07','2023-03-09 09:48:03','2023-03-10 09:48:03','397',0.00,0.00,'397','2023-03-09 09:48:33','1013','2023-03-09 09:58:49',10,0),('5','89',258006,'Daily shift','2023-03-08','2023-03-09 10:03:24','2023-03-10 10:03:24','397',0.00,0.00,'397','2023-03-09 10:03:41','1013','2023-03-09 10:04:43',10,0),('5','89',258007,'Daily shift','2023-03-09','2023-03-09 21:40:36','2023-03-10 21:40:36','397',0.00,0.00,'397','2023-03-09 21:40:52','1013','2023-03-10 10:29:23',10,0),('5','89',258008,'DAILY SHIFT','2023-03-10','2023-03-13 10:33:03','2023-03-14 10:33:03','397',0.00,0.00,'397','2023-03-13 10:33:20','1013','2023-03-15 11:04:35',10,0),('5','89',258009,'Daily shift','2023-03-11','2023-03-15 11:09:38','2023-03-16 11:09:38','397',0.00,0.00,'397','2023-03-15 11:09:55','1013','2023-03-15 11:13:04',10,0),('5','89',258010,'DAILY SHIFT','2023-03-12','2023-03-15 11:15:28','2023-03-16 11:15:28','397',0.00,0.00,'397','2023-03-15 11:15:45','1013','2023-03-15 11:16:24',10,0),('5','89',258011,'Daily shift','2023-03-13','2023-03-15 11:23:13','2023-03-16 11:23:13','397',0.00,0.00,'397','2023-03-15 11:23:26','1013','2023-03-15 11:47:28',10,0),('5','89',258012,'Daily shift','2023-03-14','2023-03-15 11:49:11','2023-03-16 11:49:11','397',0.00,0.00,'397','2023-03-15 11:49:24','1013','2023-03-16 16:40:14',10,0),('5','89',258013,'Daily shift','2023-03-15','2023-03-17 00:02:17','2023-03-18 00:02:17','397',0.00,0.00,'397','2023-03-17 00:02:37','1013','2023-03-17 10:12:46',10,0);
/*!40000 ALTER TABLE `depots_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `depots_shifts_nozzles`
--

DROP TABLE IF EXISTS `depots_shifts_nozzles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depots_shifts_nozzles` (
  `company_id` varchar(20) DEFAULT NULL,
  `station_id` varchar(20) DEFAULT NULL,
  `tank_id` varchar(20) NOT NULL,
  `shift_id` varchar(20) NOT NULL,
  `id` int NOT NULL AUTO_INCREMENT,
  `nozzle_id` varchar(20) DEFAULT NULL,
  `product_id` varchar(20) NOT NULL,
  `openreading` decimal(20,2) NOT NULL,
  `closereading` decimal(20,2) NOT NULL,
  `sold` decimal(20,2) NOT NULL,
  `revenue` decimal(20,2) NOT NULL,
  `retail_sold` decimal(20,2) NOT NULL,
  `retail_revenue` decimal(20,2) NOT NULL,
  `rtt` decimal(10,2) NOT NULL,
  `shortage` decimal(10,2) NOT NULL,
  `overage` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `companycode` (`company_id`,`shift_id`,`nozzle_id`,`product_id`),
  KEY `depot_id` (`station_id`),
  KEY `tank_id` (`tank_id`),
  KEY `retail_sold` (`retail_sold`,`retail_revenue`)
) ENGINE=InnoDB AUTO_INCREMENT=4911586 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `depots_shifts_nozzles`
--

LOCK TABLES `depots_shifts_nozzles` WRITE;
/*!40000 ALTER TABLE `depots_shifts_nozzles` DISABLE KEYS */;
INSERT INTO `depots_shifts_nozzles` VALUES ('5','89','662','124037',2471271,'1809','267',42625.08,42625.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','124037',2471272,'1810','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','124037',2471273,'1811','267',1080653.01,1080653.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','124037',2471274,'1812','267',935665.14,935665.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','124037',2471275,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','124037',2471276,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','124037',2471277,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','124037',2471278,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','124037',2471279,'1817','267',16950.34,16950.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','124037',2471280,'1818','267',13529.01,13529.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','124037',2471281,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','124037',2471282,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','124037',2471283,'1821','268',278897.03,278897.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','124037',2471284,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','124037',2471285,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','181971',3572769,'1809','267',1470189.62,1477901.18,7711.56,1256984.28,0.00,0.00,0.00,0.00,0.00),('5','89','663','181971',3572770,'1810','267',1177225.38,1184974.62,7749.24,1263126.12,0.00,0.00,0.00,0.00,0.00),('5','89','662','181971',3572771,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','181971',3572772,'1812','267',806128.77,806152.05,23.28,3794.64,0.00,0.00,0.00,0.00,0.00),('5','89','664','181971',3572773,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','181971',3572774,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','181971',3572775,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','181971',3572776,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','181971',3572777,'1817','267',506492.12,510566.38,4074.26,664104.38,0.00,0.00,0.00,0.00,0.00),('5','89','662','181971',3572778,'1818','267',592612.38,599881.29,7268.91,1184832.33,0.00,0.00,0.00,0.00,0.00),('5','89','665','181971',3572779,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','181971',3572780,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','181971',3572781,'1821','268',424941.40,425845.67,904.27,226067.50,0.00,0.00,0.00,0.00,0.00),('5','89','666','181971',3572782,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','181971',3572783,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','182290',3578730,'1809','267',1477901.18,1477929.45,28.27,4608.01,0.00,0.00,0.00,0.00,0.00),('5','89','663','182290',3578731,'1810','267',1184974.62,1184974.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','182290',3578732,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182290',3578733,'1812','267',806152.05,806152.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182290',3578734,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182290',3578735,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182290',3578736,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182290',3578737,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','182290',3578738,'1817','267',510566.38,511846.39,1280.01,208641.63,0.00,0.00,0.00,0.00,0.00),('5','89','662','182290',3578739,'1818','267',599881.29,602792.65,2911.36,474551.68,0.00,0.00,0.00,0.00,0.00),('5','89','665','182290',3578740,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','182290',3578741,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','182290',3578742,'1821','268',425845.67,426006.47,160.80,40200.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','182290',3578743,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','182290',3578744,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','182398',3580531,'1809','267',1477929.45,1482811.83,4882.38,795827.94,0.00,0.00,0.00,0.00,0.00),('5','89','663','182398',3580532,'1810','267',1184974.62,1190798.60,5823.98,949308.74,0.00,0.00,0.00,0.00,0.00),('5','89','662','182398',3580533,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182398',3580534,'1812','267',806152.05,806152.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182398',3580535,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182398',3580536,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182398',3580537,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182398',3580538,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','182398',3580539,'1817','267',511846.39,511846.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','182398',3580540,'1818','267',602792.65,602792.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','182398',3580541,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','182398',3580542,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','182398',3580543,'1821','268',426006.47,426635.21,628.74,157185.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','182398',3580544,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','182398',3580545,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','182677',3585784,'1809','267',1482811.83,1484038.18,1226.35,199895.05,0.00,0.00,0.00,0.00,0.00),('5','89','663','182677',3585785,'1810','267',1190798.60,1192031.67,1233.07,200990.41,0.00,0.00,0.00,0.00,0.00),('5','89','662','182677',3585786,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182677',3585787,'1812','267',806152.05,806152.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182677',3585788,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182677',3585789,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182677',3585790,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182677',3585791,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','182677',3585792,'1817','267',511846.39,511846.39,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','182677',3585793,'1818','267',602792.65,602792.65,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','182677',3585794,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','182677',3585795,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','182677',3585796,'1821','268',426635.21,427347.01,711.80,177950.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','182677',3585797,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','182677',3585798,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','182716',3586309,'1809','267',1484038.18,1488393.90,4355.72,709982.36,0.00,0.00,0.00,0.00,0.00),('5','89','663','182716',3586310,'1810','267',1192031.67,1196780.80,4749.13,774108.19,0.00,0.00,0.00,0.00,0.00),('5','89','662','182716',3586311,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182716',3586312,'1812','267',806152.05,806152.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182716',3586313,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182716',3586314,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182716',3586315,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182716',3586316,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','182716',3586317,'1817','267',511846.39,515585.46,3739.07,609468.41,0.00,0.00,0.00,0.00,0.00),('5','89','662','182716',3586318,'1818','267',602792.65,606954.57,4161.92,678392.96,0.00,0.00,0.00,0.00,0.00),('5','89','665','182716',3586319,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','182716',3586320,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','182716',3586321,'1821','268',427347.01,427769.24,422.23,105557.50,0.00,0.00,0.00,0.00,0.00),('5','89','666','182716',3586322,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','182716',3586323,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','182975',3591310,'1809','267',1488393.90,1492627.85,4233.95,690133.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','182975',3591311,'1810','267',1196780.80,1201890.47,5109.67,832876.21,0.00,0.00,0.00,0.00,0.00),('5','89','662','182975',3591312,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182975',3591313,'1812','267',806152.05,806152.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182975',3591314,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182975',3591315,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182975',3591316,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','182975',3591317,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','182975',3591318,'1817','267',515585.46,519657.15,4071.69,663685.47,0.00,0.00,0.00,0.00,0.00),('5','89','662','182975',3591319,'1818','267',606954.57,608748.53,1793.96,292415.48,0.00,0.00,0.00,0.00,0.00),('5','89','665','182975',3591320,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','182975',3591321,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','182975',3591322,'1821','268',427769.24,428016.71,247.47,65579.55,0.00,0.00,0.00,0.00,0.00),('5','89','666','182975',3591323,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','182975',3591324,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','183203',3595500,'1809','267',1492627.85,1497964.23,5336.38,869829.94,0.00,0.00,0.00,0.00,0.00),('5','89','663','183203',3595501,'1810','267',1201890.47,1205939.03,4048.56,659915.28,0.00,0.00,0.00,0.00,0.00),('5','89','662','183203',3595502,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183203',3595503,'1812','267',806152.05,810776.09,4624.04,753718.52,0.00,0.00,0.00,0.00,0.00),('5','89','664','183203',3595504,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183203',3595505,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183203',3595506,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183203',3595507,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','183203',3595508,'1817','267',519657.15,523158.38,3501.23,570700.49,0.00,0.00,0.00,0.00,0.00),('5','89','662','183203',3595509,'1818','267',608748.53,611736.15,2987.62,486982.06,0.00,0.00,0.00,0.00,0.00),('5','89','665','183203',3595510,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','183203',3595511,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','183203',3595512,'1821','268',428016.71,428574.89,558.18,147917.70,0.00,0.00,0.00,0.00,0.00),('5','89','666','183203',3595513,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','183203',3595514,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','183420',3599363,'1809','267',1497964.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','183420',3599364,'1810','267',1205939.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','183420',3599365,'1811','267',1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183420',3599366,'1812','267',810776.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183420',3599367,'1813','267',609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183420',3599368,'1814','267',682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183420',3599369,'1815','267',843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183420',3599370,'1816','267',440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','183420',3599371,'1817','267',523158.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','183420',3599372,'1818','267',611736.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','183420',3599373,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','183420',3599374,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','183420',3599375,'1821','268',428574.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','183420',3599376,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','183420',3599377,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','183603',3602661,'1809','267',1497964.23,1500226.87,2262.64,368810.32,0.00,0.00,0.00,0.00,0.00),('5','89','663','183603',3602662,'1810','267',1205939.03,1205939.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','183603',3602663,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183603',3602664,'1812','267',810776.09,817571.90,6795.81,1107717.03,0.00,0.00,0.00,0.00,0.00),('5','89','664','183603',3602665,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183603',3602666,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183603',3602667,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183603',3602668,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','183603',3602669,'1817','267',523158.38,528418.82,5260.44,857451.72,0.00,0.00,0.00,0.00,0.00),('5','89','662','183603',3602670,'1818','267',611736.15,617653.06,5916.91,964456.33,0.00,0.00,0.00,0.00,0.00),('5','89','665','183603',3602671,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','183603',3602672,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','183603',3602673,'1821','268',428574.89,429252.48,677.59,179561.35,0.00,0.00,0.00,0.00,0.00),('5','89','666','183603',3602674,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','183603',3602675,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','183619',3602989,'1809','267',1500226.87,1504977.99,4751.12,774432.56,0.00,0.00,0.00,0.00,0.00),('5','89','663','183619',3602990,'1810','267',1205939.03,1210377.62,4438.59,723490.17,0.00,0.00,0.00,0.00,0.00),('5','89','662','183619',3602991,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183619',3602992,'1812','267',817571.90,818855.18,1283.28,209174.64,0.00,0.00,0.00,0.00,0.00),('5','89','664','183619',3602993,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183619',3602994,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183619',3602995,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183619',3602996,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','183619',3602997,'1817','267',528418.82,531271.47,2852.65,464981.95,0.00,0.00,0.00,0.00,0.00),('5','89','662','183619',3602998,'1818','267',617653.06,620778.96,3125.90,509521.70,0.00,0.00,0.00,0.00,0.00),('5','89','665','183619',3602999,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','183619',3603000,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','183619',3603001,'1821','268',429252.48,429676.48,424.00,112360.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','183619',3603002,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','183619',3603003,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','183846',3607132,'1809','267',1504977.99,1510683.76,5705.77,930040.51,0.00,0.00,0.00,0.00,0.00),('5','89','663','183846',3607133,'1810','267',1210377.62,1216582.37,6204.75,1011374.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','183846',3607134,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183846',3607135,'1812','267',818855.18,821183.75,2328.57,379556.91,0.00,0.00,0.00,0.00,0.00),('5','89','664','183846',3607136,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183846',3607137,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183846',3607138,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','183846',3607139,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','183846',3607140,'1817','267',531271.47,532961.93,1690.46,275544.98,0.00,0.00,0.00,0.00,0.00),('5','89','662','183846',3607141,'1818','267',620778.96,624880.93,4101.97,668621.11,0.00,0.00,0.00,0.00,0.00),('5','89','665','183846',3607142,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','183846',3607143,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','183846',3607144,'1821','268',429676.48,430213.38,536.90,142278.50,0.00,0.00,0.00,0.00,0.00),('5','89','666','183846',3607145,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','183846',3607146,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','184253',3614350,'1809','267',1510683.76,1519217.09,8533.33,1390932.79,0.00,0.00,0.00,0.00,0.00),('5','89','663','184253',3614351,'1810','267',1216582.37,1227077.46,10495.09,1710699.67,0.00,0.00,0.00,0.00,0.00),('5','89','662','184253',3614352,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184253',3614353,'1812','267',821183.75,821183.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184253',3614354,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184253',3614355,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184253',3614356,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184253',3614357,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184253',3614358,'1817','267',532961.93,532980.14,18.21,2968.23,0.00,0.00,0.00,0.00,0.00),('5','89','662','184253',3614359,'1818','267',624880.93,626392.97,1512.04,246462.52,0.00,0.00,0.00,0.00,0.00),('5','89','665','184253',3614360,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','184253',3614361,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','184253',3614362,'1821','268',430213.38,430927.19,713.81,182021.55,0.00,0.00,0.00,0.00,0.00),('5','89','666','184253',3614363,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','184253',3614364,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','184300',3614995,'1809','267',1519217.09,1519217.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','184300',3614996,'1810','267',1227077.46,1227077.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184300',3614997,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184300',3614998,'1812','267',821183.75,821183.75,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184300',3614999,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184300',3615000,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184300',3615001,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184300',3615002,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184300',3615003,'1817','267',532980.14,532980.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184300',3615004,'1818','267',626392.97,626392.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','184300',3615005,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','184300',3615006,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','184300',3615007,'1821','268',430927.19,431174.05,246.86,62949.30,0.00,0.00,0.00,0.00,0.00),('5','89','666','184300',3615008,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','184300',3615009,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','184355',3616010,'1809','267',1519217.09,1519983.42,766.33,124911.79,0.00,0.00,0.00,0.00,0.00),('5','89','663','184355',3616011,'1810','267',1227077.46,1227077.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184355',3616012,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184355',3616013,'1812','267',821183.75,824476.14,3292.39,536659.57,0.00,0.00,0.00,0.00,0.00),('5','89','664','184355',3616014,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184355',3616015,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184355',3616016,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184355',3616017,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184355',3616018,'1817','267',532980.14,535685.38,2705.24,440954.12,0.00,0.00,0.00,0.00,0.00),('5','89','662','184355',3616019,'1818','267',626392.97,629798.20,3405.23,555052.49,0.00,0.00,0.00,0.00,0.00),('5','89','665','184355',3616020,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','184355',3616021,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','184355',3616022,'1821','268',431174.05,431262.11,88.06,22455.30,0.00,0.00,0.00,0.00,0.00),('5','89','666','184355',3616023,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','184355',3616024,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','184640',3621357,'1809','267',1519983.42,1526840.89,6857.47,1117767.61,0.00,0.00,0.00,0.00,0.00),('5','89','663','184640',3621358,'1810','267',1227077.46,1230492.58,3415.12,556664.56,0.00,0.00,0.00,0.00,0.00),('5','89','662','184640',3621359,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184640',3621360,'1812','267',824476.14,830886.59,6410.45,1044903.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','184640',3621361,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184640',3621362,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184640',3621363,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184640',3621364,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184640',3621365,'1817','267',535685.38,538633.80,2948.42,480592.46,0.00,0.00,0.00,0.00,0.00),('5','89','662','184640',3621366,'1818','267',629798.20,635662.34,5864.14,955854.82,0.00,0.00,0.00,0.00,0.00),('5','89','665','184640',3621367,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','184640',3621368,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','184640',3621369,'1821','268',431262.11,431799.13,537.02,136940.10,0.00,0.00,0.00,0.00,0.00),('5','89','666','184640',3621370,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','184640',3621371,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','184848',3625130,'1809','267',1526840.89,1532613.31,5772.42,940904.46,0.00,0.00,0.00,0.00,0.00),('5','89','663','184848',3625131,'1810','267',1230492.58,1236498.48,6005.90,978961.70,0.00,0.00,0.00,0.00,0.00),('5','89','662','184848',3625132,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184848',3625133,'1812','267',830886.59,835453.27,4566.68,744368.84,0.00,0.00,0.00,0.00,0.00),('5','89','664','184848',3625134,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184848',3625135,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184848',3625136,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','184848',3625137,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184848',3625138,'1817','267',538633.80,538633.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','184848',3625139,'1818','267',635662.34,635662.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','184848',3625140,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','184848',3625141,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','184848',3625142,'1821','268',431799.13,432485.19,686.06,174945.30,0.00,0.00,0.00,0.00,0.00),('5','89','666','184848',3625143,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','184848',3625144,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','185089',3629287,'1809','267',1532613.31,1537546.66,4933.35,804136.05,0.00,0.00,0.00,0.00,0.00),('5','89','663','185089',3629288,'1810','267',1236498.48,1241594.23,5095.75,830607.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','185089',3629289,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185089',3629290,'1812','267',835453.27,835453.27,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185089',3629291,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185089',3629292,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185089',3629293,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185089',3629294,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185089',3629295,'1817','267',538633.80,538633.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185089',3629296,'1818','267',635662.34,635662.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185089',3629297,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185089',3629298,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','185089',3629299,'1821','268',432485.19,432990.85,505.66,133999.90,0.00,0.00,0.00,0.00,0.00),('5','89','666','185089',3629300,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','185089',3629301,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','185240',3631674,'1809','267',1537546.66,1543419.46,5872.80,957266.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','185240',3631675,'1810','267',1241594.23,1248056.28,6462.05,1053314.15,0.00,0.00,0.00,0.00,0.00),('5','89','662','185240',3631676,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185240',3631677,'1812','267',835453.27,836100.70,647.43,105531.09,0.00,0.00,0.00,0.00,0.00),('5','89','664','185240',3631678,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185240',3631679,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185240',3631680,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185240',3631681,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185240',3631682,'1817','267',538633.80,538633.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185240',3631683,'1818','267',635662.34,635662.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185240',3631684,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185240',3631685,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','185240',3631686,'1821','268',432990.85,433318.38,327.53,86795.45,0.00,0.00,0.00,0.00,0.00),('5','89','666','185240',3631687,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','185240',3631688,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','185430',3635217,'1809','267',1543419.46,1543419.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','185430',3635218,'1810','267',1248056.28,1248056.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185430',3635219,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185430',3635220,'1812','267',836100.70,836100.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185430',3635221,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185430',3635222,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185430',3635223,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185430',3635224,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185430',3635225,'1817','267',538633.80,538633.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185430',3635226,'1818','267',635662.34,635662.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185430',3635227,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185430',3635228,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','185430',3635229,'1821','268',433318.38,433494.09,175.71,46563.15,0.00,0.00,0.00,0.00,0.00),('5','89','666','185430',3635230,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','185430',3635231,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','185643',3639050,'1809','267',1543419.46,1545276.75,1857.29,302738.27,0.00,0.00,0.00,0.00,0.00),('5','89','663','185643',3639051,'1810','267',1248056.28,1250305.60,2249.32,366639.16,0.00,0.00,0.00,0.00,0.00),('5','89','662','185643',3639052,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185643',3639053,'1812','267',836100.70,836100.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185643',3639054,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185643',3639055,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185643',3639056,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185643',3639057,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185643',3639058,'1817','267',538633.80,540040.41,1406.61,229277.43,0.00,0.00,0.00,0.00,0.00),('5','89','662','185643',3639059,'1818','267',635662.34,637174.06,1511.72,246410.36,0.00,0.00,0.00,0.00,0.00),('5','89','665','185643',3639060,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185643',3639061,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','185643',3639062,'1821','268',433494.09,433784.75,290.66,77024.90,0.00,0.00,0.00,0.00,0.00),('5','89','666','185643',3639063,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','185643',3639064,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','185837',3642441,'1809','267',1545276.75,1548758.63,3481.88,567546.44,0.00,0.00,0.00,0.00,0.00),('5','89','663','185837',3642442,'1810','267',1250305.60,1253674.45,3368.85,549122.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','185837',3642443,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185837',3642444,'1812','267',836100.70,836100.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185837',3642445,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185837',3642446,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185837',3642447,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185837',3642448,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185837',3642449,'1817','267',540040.41,543328.02,3287.61,535880.43,0.00,0.00,0.00,0.00,0.00),('5','89','662','185837',3642450,'1818','267',637174.06,640392.76,3218.70,524648.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','185837',3642451,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185837',3642452,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','185837',3642453,'1821','268',433784.75,434223.43,438.68,116250.20,0.00,0.00,0.00,0.00,0.00),('5','89','666','185837',3642454,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','185837',3642455,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','185968',3644761,'1809','267',1548758.63,1553547.56,4788.93,780595.59,0.00,0.00,0.00,0.00,0.00),('5','89','663','185968',3644762,'1810','267',1253674.45,1258893.68,5219.23,850734.49,0.00,0.00,0.00,0.00,0.00),('5','89','662','185968',3644763,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185968',3644764,'1812','267',836100.70,836100.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185968',3644765,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185968',3644766,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185968',3644767,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','185968',3644768,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','185968',3644769,'1817','267',543328.02,546196.37,2868.35,467541.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','185968',3644770,'1818','267',640392.76,644880.79,4488.03,731548.89,0.00,0.00,0.00,0.00,0.00),('5','89','665','185968',3644771,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','185968',3644772,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','185968',3644773,'1821','268',434223.43,434608.55,385.12,102056.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','185968',3644774,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','185968',3644775,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','186329',3650858,'1809','267',1553547.56,1557827.84,4280.28,697685.64,0.00,0.00,0.00,0.00,0.00),('5','89','663','186329',3650859,'1810','267',1258893.68,1262563.78,3670.10,598226.30,0.00,0.00,0.00,0.00,0.00),('5','89','662','186329',3650860,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186329',3650861,'1812','267',836100.70,836100.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186329',3650862,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186329',3650863,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186329',3650864,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186329',3650865,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','186329',3650866,'1817','267',546196.37,549062.49,2866.12,467177.56,0.00,0.00,0.00,0.00,0.00),('5','89','662','186329',3650867,'1818','267',644880.79,648927.35,4046.56,659589.28,0.00,0.00,0.00,0.00,0.00),('5','89','665','186329',3650868,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','186329',3650869,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','186329',3650870,'1821','268',434608.55,434942.60,334.05,88523.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','186329',3650871,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','186329',3650872,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','186493',3653695,'1809','267',1557827.84,1563300.76,5472.92,892085.96,0.00,0.00,0.00,0.00,0.00),('5','89','663','186493',3653696,'1810','267',1262563.78,1268367.79,5804.01,946053.63,0.00,0.00,0.00,0.00,0.00),('5','89','662','186493',3653697,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186493',3653698,'1812','267',836100.70,839168.66,3067.96,500077.48,0.00,0.00,0.00,0.00,0.00),('5','89','664','186493',3653699,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186493',3653700,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186493',3653701,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186493',3653702,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','186493',3653703,'1817','267',549062.49,549062.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','186493',3653704,'1818','267',648927.35,648927.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','186493',3653705,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','186493',3653706,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','186493',3653707,'1821','268',434942.60,435219.32,276.72,73330.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','186493',3653708,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','186493',3653709,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','186719',3657670,'1809','267',1563300.76,1564575.72,1274.96,207818.48,0.00,0.00,0.00,0.00,0.00),('5','89','663','186719',3657671,'1810','267',1268367.79,1269086.23,718.44,117105.72,0.00,0.00,0.00,0.00,0.00),('5','89','662','186719',3657672,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186719',3657673,'1812','267',839168.66,844387.55,5218.89,850679.07,0.00,0.00,0.00,0.00,0.00),('5','89','664','186719',3657674,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186719',3657675,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186719',3657676,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','186719',3657677,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','186719',3657678,'1817','267',549062.49,553367.53,4305.04,701721.52,0.00,0.00,0.00,0.00,0.00),('5','89','662','186719',3657679,'1818','267',648927.35,653373.57,4446.22,724733.86,0.00,0.00,0.00,0.00,0.00),('5','89','665','186719',3657680,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','186719',3657681,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','186719',3657682,'1821','268',435219.32,435799.14,579.82,153652.30,0.00,0.00,0.00,0.00,0.00),('5','89','666','186719',3657683,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','186719',3657684,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','187042',3662853,'1809','267',1564575.72,1569098.70,4522.98,737245.74,0.00,0.00,0.00,0.00,0.00),('5','89','663','187042',3662854,'1810','267',1269086.23,1271975.53,2889.30,470955.90,0.00,0.00,0.00,0.00,0.00),('5','89','662','187042',3662855,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187042',3662856,'1812','267',844387.55,847889.03,3501.48,570741.24,0.00,0.00,0.00,0.00,0.00),('5','89','664','187042',3662857,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187042',3662858,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187042',3662859,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187042',3662860,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','187042',3662861,'1817','267',553367.53,556088.55,2721.02,443526.26,0.00,0.00,0.00,0.00,0.00),('5','89','662','187042',3662862,'1818','267',653373.57,657722.55,4348.98,708883.74,0.00,0.00,0.00,0.00,0.00),('5','89','665','187042',3662863,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','187042',3662864,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','187042',3662865,'1821','268',435799.14,436537.58,738.44,195686.60,0.00,0.00,0.00,0.00,0.00),('5','89','666','187042',3662866,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','187042',3662867,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','187329',3668156,'1809','267',1569098.70,1575380.84,6282.14,1023988.82,0.00,0.00,0.00,0.00,0.00),('5','89','663','187329',3668157,'1810','267',1271975.53,1277343.87,5368.34,875039.42,0.00,0.00,0.00,0.00,0.00),('5','89','662','187329',3668158,'1811','267',1584914.44,1584914.44,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187329',3668159,'1812','267',847889.03,849698.23,1809.20,294899.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','187329',3668160,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187329',3668161,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187329',3668162,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187329',3668163,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','187329',3668164,'1817','267',556088.55,557368.08,1279.53,208563.39,0.00,0.00,0.00,0.00,0.00),('5','89','662','187329',3668165,'1818','267',657722.55,659770.63,2048.08,333837.04,0.00,0.00,0.00,0.00,0.00),('5','89','665','187329',3668166,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','187329',3668167,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','187329',3668168,'1821','268',436537.58,436823.05,285.47,75649.55,0.00,0.00,0.00,0.00,0.00),('5','89','666','187329',3668169,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','187329',3668170,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','187456',3670491,'1809','267',1575380.84,1582010.37,6629.53,1080613.39,0.00,0.00,0.00,0.00,0.00),('5','89','663','187456',3670492,'1810','267',1277343.87,1284014.32,6670.45,1087283.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','187456',3670493,'1811','267',1584914.44,1585084.00,169.56,27638.28,0.00,0.00,0.00,0.00,0.00),('5','89','664','187456',3670494,'1812','267',849698.23,849698.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187456',3670495,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187456',3670496,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187456',3670497,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187456',3670498,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','187456',3670499,'1817','267',557368.08,557368.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','187456',3670500,'1818','267',659770.63,659770.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','187456',3670501,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','187456',3670502,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','187456',3670503,'1821','268',436823.05,436979.10,156.05,41353.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','187456',3670504,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','187456',3670505,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','187696',3674607,'1809','267',1582010.37,1584945.74,2935.37,478465.31,0.00,0.00,0.00,0.00,0.00),('5','89','663','187696',3674608,'1810','267',1284014.32,1286919.66,2905.34,473570.42,0.00,0.00,0.00,0.00,0.00),('5','89','662','187696',3674609,'1811','267',1585084.00,1585084.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187696',3674610,'1812','267',849698.23,853020.10,3321.87,541464.81,0.00,0.00,0.00,0.00,0.00),('5','89','664','187696',3674611,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187696',3674612,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187696',3674613,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187696',3674614,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','187696',3674615,'1817','267',557368.08,560837.72,3469.64,565551.32,0.00,0.00,0.00,0.00,0.00),('5','89','662','187696',3674616,'1818','267',659770.63,663786.03,4015.40,654510.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','187696',3674617,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','187696',3674618,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','187696',3674619,'1821','268',436979.10,437741.50,762.40,202036.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','187696',3674620,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','187696',3674621,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','187751',3675658,'1809','267',1584945.74,1584945.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','187751',3675659,'1810','267',1286919.66,1286919.66,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','187751',3675660,'1811','267',1585084.00,1585084.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187751',3675661,'1812','267',853020.10,858493.98,5473.88,892242.44,0.00,0.00,0.00,0.00,0.00),('5','89','664','187751',3675662,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187751',3675663,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187751',3675664,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187751',3675665,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','187751',3675666,'1817','267',560837.72,565041.00,4203.28,685134.64,0.00,0.00,0.00,0.00,0.00),('5','89','662','187751',3675667,'1818','267',663786.03,669219.43,5433.40,885644.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','187751',3675668,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','187751',3675669,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','187751',3675670,'1821','268',437741.50,438244.32,502.82,133247.30,0.00,0.00,0.00,0.00,0.00),('5','89','666','187751',3675671,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','187751',3675672,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','187808',3676524,'1809','267',1584945.74,1588820.57,3874.83,631597.29,0.00,0.00,0.00,0.00,0.00),('5','89','663','187808',3676525,'1810','267',1286919.66,1287717.89,798.23,130111.49,0.00,0.00,0.00,0.00,0.00),('5','89','662','187808',3676526,'1811','267',1585084.00,1585084.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187808',3676527,'1812','267',858493.98,863182.01,4688.03,764148.89,0.00,0.00,0.00,0.00,0.00),('5','89','664','187808',3676528,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187808',3676529,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187808',3676530,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','187808',3676531,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','187808',3676532,'1817','267',565041.00,568969.08,3928.08,640277.04,0.00,0.00,0.00,0.00,0.00),('5','89','662','187808',3676533,'1818','267',669219.43,673537.00,4317.57,703763.91,0.00,0.00,0.00,0.00,0.00),('5','89','665','187808',3676534,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','187808',3676535,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','187808',3676536,'1821','268',438244.32,438851.23,606.91,160831.15,0.00,0.00,0.00,0.00,0.00),('5','89','666','187808',3676537,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','187808',3676538,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','188107',3681736,'1809','267',1588820.57,1596647.84,7827.27,1275845.01,0.00,0.00,0.00,0.00,0.00),('5','89','663','188107',3681737,'1810','267',1287717.89,1297248.56,9530.67,1553499.21,0.00,0.00,0.00,0.00,0.00),('5','89','662','188107',3681738,'1811','267',1585084.00,1585084.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188107',3681739,'1812','267',863182.01,863182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188107',3681740,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188107',3681741,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188107',3681742,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188107',3681743,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188107',3681744,'1817','267',568969.08,568969.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188107',3681745,'1818','267',673537.00,673934.23,397.23,64748.49,0.00,0.00,0.00,0.00,0.00),('5','89','665','188107',3681746,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','188107',3681747,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','188107',3681748,'1821','268',438851.23,439787.92,936.69,248222.85,0.00,0.00,0.00,0.00,0.00),('5','89','666','188107',3681749,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','188107',3681750,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','188333',3685574,'1809','267',1596647.84,1603927.46,7279.62,1186578.06,0.00,0.00,0.00,0.00,0.00),('5','89','663','188333',3685575,'1810','267',1297248.56,1305809.13,8560.57,1395372.91,0.00,0.00,0.00,0.00,0.00),('5','89','662','188333',3685576,'1811','267',1585084.00,1585289.22,205.22,33450.86,0.00,0.00,0.00,0.00,0.00),('5','89','664','188333',3685577,'1812','267',863182.01,863182.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188333',3685578,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188333',3685579,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188333',3685580,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188333',3685581,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188333',3685582,'1817','267',568969.08,568969.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188333',3685583,'1818','267',673934.23,673934.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','188333',3685584,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','188333',3685585,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','188333',3685586,'1821','268',439787.92,440449.27,661.35,175257.75,0.00,0.00,0.00,0.00,0.00),('5','89','666','188333',3685587,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','188333',3685588,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','188484',3688275,'1809','267',1603927.46,1606671.58,2744.12,447291.56,0.00,0.00,0.00,0.00,0.00),('5','89','663','188484',3688276,'1810','267',1305809.13,1309342.09,3532.96,575872.48,0.00,0.00,0.00,0.00,0.00),('5','89','662','188484',3688277,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188484',3688278,'1812','267',863182.01,865365.81,2183.80,355959.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','188484',3688279,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188484',3688280,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188484',3688281,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188484',3688282,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188484',3688283,'1817','267',568969.08,572596.17,3627.09,591215.67,0.00,0.00,0.00,0.00,0.00),('5','89','662','188484',3688284,'1818','267',673934.23,678323.50,4389.27,715451.01,0.00,0.00,0.00,0.00,0.00),('5','89','665','188484',3688285,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','188484',3688286,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','188484',3688287,'1821','268',440449.27,440758.79,309.52,82022.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','188484',3688288,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','188484',3688289,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','188647',3690991,'1809','267',1606671.58,1606671.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','188647',3690992,'1810','267',1309342.09,1309342.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188647',3690993,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188647',3690994,'1812','267',865365.81,870602.75,5236.94,853621.22,0.00,0.00,0.00,0.00,0.00),('5','89','664','188647',3690995,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188647',3690996,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188647',3690997,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188647',3690998,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188647',3690999,'1817','267',572596.17,576798.74,4202.57,685018.91,0.00,0.00,0.00,0.00,0.00),('5','89','662','188647',3691000,'1818','267',678323.50,683153.09,4829.59,787223.17,0.00,0.00,0.00,0.00,0.00),('5','89','665','188647',3691001,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','188647',3691002,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','188647',3691003,'1821','268',440758.79,440962.61,203.82,54012.30,0.00,0.00,0.00,0.00,0.00),('5','89','666','188647',3691004,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','188647',3691005,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','188815',3694018,'1809','267',1606671.58,1606671.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','188815',3694019,'1810','267',1309342.09,1309342.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188815',3694020,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188815',3694021,'1812','267',870602.75,877870.93,7268.18,1184713.34,0.00,0.00,0.00,0.00,0.00),('5','89','664','188815',3694022,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188815',3694023,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188815',3694024,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','188815',3694025,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','188815',3694026,'1817','267',576798.74,579390.73,2591.99,422494.37,0.00,0.00,0.00,0.00,0.00),('5','89','662','188815',3694027,'1818','267',683153.09,686584.05,3430.96,559246.48,0.00,0.00,0.00,0.00,0.00),('5','89','665','188815',3694028,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','188815',3694029,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','188815',3694030,'1821','268',440962.61,441441.88,479.27,127006.55,0.00,0.00,0.00,0.00,0.00),('5','89','666','188815',3694031,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','188815',3694032,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','189000',3697540,'1809','267',1606671.58,1606671.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','189000',3697541,'1810','267',1309342.09,1309342.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189000',3697542,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189000',3697543,'1812','267',877870.93,879988.16,2117.23,345108.49,0.00,0.00,0.00,0.00,0.00),('5','89','664','189000',3697544,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189000',3697545,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189000',3697546,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189000',3697547,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189000',3697548,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189000',3697549,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189000',3697550,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189000',3697551,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','189000',3697552,'1821','268',441441.88,441732.95,291.07,77133.55,0.00,0.00,0.00,0.00,0.00),('5','89','666','189000',3697553,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','189000',3697554,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','189229',3701361,'1809','267',1606671.58,1613968.30,7296.72,1189365.36,0.00,0.00,0.00,0.00,0.00),('5','89','663','189229',3701362,'1810','267',1309342.09,1316823.38,7481.29,1219450.27,0.00,0.00,0.00,0.00,0.00),('5','89','662','189229',3701363,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189229',3701364,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189229',3701365,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189229',3701366,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189229',3701367,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189229',3701368,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189229',3701369,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189229',3701370,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189229',3701371,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189229',3701372,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','189229',3701373,'1821','268',441732.95,442209.30,476.35,126232.75,0.00,0.00,0.00,0.00,0.00),('5','89','666','189229',3701374,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','189229',3701375,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','189436',3705202,'1809','267',1613968.30,1620666.43,6698.13,1091795.19,0.00,0.00,0.00,0.00,0.00),('5','89','663','189436',3705203,'1810','267',1316823.38,1324276.24,7452.86,1214816.18,0.00,0.00,0.00,0.00,0.00),('5','89','662','189436',3705204,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189436',3705205,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189436',3705206,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189436',3705207,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189436',3705208,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189436',3705209,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189436',3705210,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189436',3705211,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189436',3705212,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189436',3705213,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','189436',3705214,'1821','268',442209.30,442903.57,694.27,183981.55,0.00,0.00,0.00,0.00,0.00),('5','89','666','189436',3705215,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','189436',3705216,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','189625',3708494,'1809','267',1620666.43,1622808.01,2141.58,349077.54,0.00,0.00,0.00,0.00,0.00),('5','89','663','189625',3708495,'1810','267',1324276.24,1326614.86,2338.62,381195.06,0.00,0.00,0.00,0.00,0.00),('5','89','662','189625',3708496,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189625',3708497,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189625',3708498,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189625',3708499,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189625',3708500,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189625',3708501,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189625',3708502,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189625',3708503,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189625',3708504,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189625',3708505,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','189625',3708506,'1821','268',442903.57,443257.81,354.24,93873.60,0.00,0.00,0.00,0.00,0.00),('5','89','666','189625',3708507,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','189625',3708508,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','189824',3711994,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','189824',3711995,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189824',3711996,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189824',3711997,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189824',3711998,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189824',3711999,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189824',3712000,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','189824',3712001,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189824',3712002,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','189824',3712003,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189824',3712004,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','189824',3712005,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','189824',3712006,'1821','268',443257.81,443434.09,176.28,46714.20,0.00,0.00,0.00,0.00,0.00),('5','89','666','189824',3712007,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','189824',3712008,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190053',3716512,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190053',3716513,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190053',3716514,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190053',3716515,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190053',3716516,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190053',3716517,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190053',3716518,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190053',3716519,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190053',3716520,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190053',3716521,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190053',3716522,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190053',3716523,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','190053',3716524,'1821','268',443434.09,443552.89,118.80,31482.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','190053',3716525,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','190053',3716526,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190382',3722885,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190382',3722886,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190382',3722887,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190382',3722888,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190382',3722889,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190382',3722890,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190382',3722891,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190382',3722892,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190382',3722893,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190382',3722894,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190382',3722895,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190382',3722896,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','190382',3722897,'1821','268',443552.89,443747.01,194.12,51441.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','190382',3722898,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','190382',3722899,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190648',3727887,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190648',3727888,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190648',3727889,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190648',3727890,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190648',3727891,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190648',3727892,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190648',3727893,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190648',3727894,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190648',3727895,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190648',3727896,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190648',3727897,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190648',3727898,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','190648',3727899,'1821','268',443747.01,445291.13,1544.12,409191.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','190648',3727900,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','190648',3727901,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190772',3730087,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190772',3730088,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190772',3730089,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190772',3730090,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190772',3730091,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190772',3730092,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190772',3730093,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190772',3730094,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190772',3730095,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190772',3730096,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190772',3730097,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190772',3730098,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','190772',3730099,'1821','268',445291.13,445475.17,184.04,48770.60,0.00,0.00,0.00,0.00,0.00),('5','89','666','190772',3730100,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','190772',3730101,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190924',3732613,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','190924',3732614,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190924',3732615,'1811','267',1585289.22,1585289.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190924',3732616,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190924',3732617,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190924',3732618,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190924',3732619,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','190924',3732620,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190924',3732621,'1817','267',579390.73,579390.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','190924',3732622,'1818','267',686584.05,686584.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190924',3732623,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','190924',3732624,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','190924',3732625,'1821','268',445475.17,445681.25,206.08,54611.20,0.00,0.00,0.00,0.00,0.00),('5','89','666','190924',3732626,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','190924',3732627,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','191099',3735735,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','191099',3735736,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191099',3735737,'1811','267',1585289.22,1590982.58,5693.36,939404.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','191099',3735738,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191099',3735739,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191099',3735740,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191099',3735741,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191099',3735742,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191099',3735743,'1817','267',579390.73,583681.73,4291.00,708015.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191099',3735744,'1818','267',686584.05,692158.14,5574.09,919724.85,0.00,0.00,0.00,0.00,0.00),('5','89','665','191099',3735745,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','191099',3735746,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','191099',3735747,'1821','268',445681.25,446597.40,916.15,242779.75,0.00,0.00,0.00,0.00,0.00),('5','89','666','191099',3735748,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','191099',3735749,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','191440',3741969,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','191440',3741970,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191440',3741971,'1811','267',1590982.58,1595975.50,4992.92,823831.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','191440',3741972,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191440',3741973,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191440',3741974,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191440',3741975,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191440',3741976,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191440',3741977,'1817','267',583681.73,586073.12,2391.39,394579.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','191440',3741978,'1818','267',692158.14,695924.98,3766.84,621528.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','191440',3741979,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','191440',3741980,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','191440',3741981,'1821','268',446597.40,446777.10,179.70,47620.50,0.00,0.00,0.00,0.00,0.00),('5','89','666','191440',3741982,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','191440',3741983,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','191604',3744938,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','191604',3744939,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191604',3744940,'1811','267',1595975.50,1595975.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191604',3744941,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191604',3744942,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191604',3744943,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191604',3744944,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191604',3744945,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191604',3744946,'1817','267',586073.12,586073.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191604',3744947,'1818','267',695924.98,695924.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','191604',3744948,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','191604',3744949,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','191604',3744950,'1821','268',446777.10,446956.95,179.85,47660.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','191604',3744951,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','191604',3744952,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','191750',3747698,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','191750',3747699,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191750',3747700,'1811','267',1595975.50,1595975.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191750',3747701,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191750',3747702,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191750',3747703,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191750',3747704,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','191750',3747705,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191750',3747706,'1817','267',586073.12,586073.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','191750',3747707,'1818','267',695924.98,695924.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','191750',3747708,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','191750',3747709,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','191750',3747710,'1821','268',446956.95,447160.36,203.41,53903.65,0.00,0.00,0.00,0.00,0.00),('5','89','666','191750',3747711,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','191750',3747712,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192005',3752642,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192005',3752643,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192005',3752644,'1811','267',1595975.50,1595975.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192005',3752645,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192005',3752646,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192005',3752647,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192005',3752648,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192005',3752649,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192005',3752650,'1817','267',586073.12,586073.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192005',3752651,'1818','267',695924.98,695924.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','192005',3752652,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','192005',3752653,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','192005',3752654,'1821','268',447160.36,447529.79,369.43,97898.95,0.00,0.00,0.00,0.00,0.00),('5','89','666','192005',3752655,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','192005',3752656,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192191',3755924,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192191',3755925,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192191',3755926,'1811','267',1595975.50,1600430.38,4454.88,735055.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','192191',3755927,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192191',3755928,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192191',3755929,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192191',3755930,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192191',3755931,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192191',3755932,'1817','267',586073.12,589727.97,3654.85,603050.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','192191',3755933,'1818','267',695924.98,701306.21,5381.23,887902.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','192191',3755934,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','192191',3755935,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','192191',3755936,'1821','268',447529.79,447735.52,205.73,54518.45,0.00,0.00,0.00,0.00,0.00),('5','89','666','192191',3755937,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','192191',3755938,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192407',3759694,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192407',3759695,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192407',3759696,'1811','267',1600430.38,1607255.49,6825.11,1126143.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','192407',3759697,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192407',3759698,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192407',3759699,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192407',3759700,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192407',3759701,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192407',3759702,'1817','267',589727.97,589727.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192407',3759703,'1818','267',701306.21,706439.71,5133.50,847027.50,0.00,0.00,0.00,0.00,0.00),('5','89','665','192407',3759704,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','192407',3759705,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','192407',3759706,'1821','268',447735.52,448069.29,333.77,88449.05,0.00,0.00,0.00,0.00,0.00),('5','89','666','192407',3759707,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','192407',3759708,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192582',3763007,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192582',3763008,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192582',3763009,'1811','267',1607255.49,1612657.86,5402.37,891391.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','192582',3763010,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192582',3763011,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192582',3763012,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192582',3763013,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192582',3763014,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192582',3763015,'1817','267',589727.97,589727.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192582',3763016,'1818','267',706439.71,712224.63,5784.92,954511.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','192582',3763017,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','192582',3763018,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','192582',3763019,'1821','268',448069.29,448407.27,337.98,89564.70,0.00,0.00,0.00,0.00,0.00),('5','89','666','192582',3763020,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','192582',3763021,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192902',3769088,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192902',3769089,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192902',3769090,'1811','267',1612657.86,1616963.57,4305.71,710442.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','192902',3769091,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192902',3769092,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192902',3769093,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192902',3769094,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192902',3769095,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192902',3769096,'1817','267',589727.97,590212.43,484.46,79935.90,0.00,0.00,0.00,0.00,0.00),('5','89','662','192902',3769097,'1818','267',712224.63,715743.50,3518.87,580613.55,0.00,0.00,0.00,0.00,0.00),('5','89','665','192902',3769098,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','192902',3769099,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','192902',3769100,'1821','268',448407.27,449032.81,625.54,165768.10,0.00,0.00,0.00,0.00,0.00),('5','89','666','192902',3769101,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','192902',3769102,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192965',3770042,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','192965',3770043,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192965',3770044,'1811','267',1616963.57,1616963.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192965',3770045,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192965',3770046,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192965',3770047,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192965',3770048,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','192965',3770049,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192965',3770050,'1817','267',590212.43,590212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','192965',3770051,'1818','267',715743.50,715743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','192965',3770052,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','192965',3770053,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','192965',3770054,'1821','268',449032.81,449595.05,562.24,148993.60,0.00,0.00,0.00,0.00,0.00),('5','89','666','192965',3770055,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','192965',3770056,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','193219',3774773,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','193219',3774774,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193219',3774775,'1811','267',1616963.57,1616963.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193219',3774776,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193219',3774777,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193219',3774778,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193219',3774779,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193219',3774780,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193219',3774781,'1817','267',590212.43,590212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193219',3774782,'1818','267',715743.50,715743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','193219',3774783,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','193219',3774784,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','193219',3774785,'1821','268',449595.05,449873.10,278.05,73683.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','193219',3774786,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','193219',3774787,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','193480',3780099,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','193480',3780100,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193480',3780101,'1811','267',1616963.57,1616963.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193480',3780102,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193480',3780103,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193480',3780104,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193480',3780105,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193480',3780106,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193480',3780107,'1817','267',590212.43,590212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193480',3780108,'1818','267',715743.50,715743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','193480',3780109,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','193480',3780110,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','193480',3780111,'1821','268',449873.10,450215.66,342.56,90778.40,0.00,0.00,0.00,0.00,0.00),('5','89','666','193480',3780112,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','193480',3780113,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','193833',3786686,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','193833',3786687,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193833',3786688,'1811','267',1616963.57,1616963.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193833',3786689,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193833',3786690,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193833',3786691,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193833',3786692,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','193833',3786693,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193833',3786694,'1817','267',590212.43,590212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','193833',3786695,'1818','267',715743.50,715743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','193833',3786696,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','193833',3786697,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','193833',3786698,'1821','268',450215.66,450539.87,324.21,85915.65,0.00,0.00,0.00,0.00,0.00),('5','89','666','193833',3786699,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','193833',3786700,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194053',3790630,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194053',3790631,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194053',3790632,'1811','267',1616963.57,1616963.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194053',3790633,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194053',3790634,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194053',3790635,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194053',3790636,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194053',3790637,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194053',3790638,'1817','267',590212.43,590212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194053',3790639,'1818','267',715743.50,715743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','194053',3790640,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','194053',3790641,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','194053',3790642,'1821','268',450539.87,450899.37,359.50,95267.50,0.00,0.00,0.00,0.00,0.00),('5','89','666','194053',3790643,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','194053',3790644,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194272',3794679,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194272',3794680,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194272',3794681,'1811','267',1616963.57,1616963.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194272',3794682,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194272',3794683,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194272',3794684,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194272',3794685,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194272',3794686,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194272',3794687,'1817','267',590212.43,590212.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194272',3794688,'1818','267',715743.50,715743.50,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','194272',3794689,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','194272',3794690,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','194272',3794691,'1821','268',450899.37,451320.90,421.53,111705.45,0.00,0.00,0.00,0.00,0.00),('5','89','666','194272',3794692,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','194272',3794693,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194323',3795300,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194323',3795301,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194323',3795302,'1811','267',1616963.57,1619427.93,2464.36,406619.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','194323',3795303,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194323',3795304,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194323',3795305,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194323',3795306,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194323',3795307,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194323',3795308,'1817','267',590212.43,592361.84,2149.41,354652.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','194323',3795309,'1818','267',715743.50,718358.23,2614.73,431430.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','194323',3795310,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','194323',3795311,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','194323',3795312,'1821','268',451320.90,451601.48,280.58,74353.70,0.00,0.00,0.00,0.00,0.00),('5','89','666','194323',3795313,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','194323',3795314,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194543',3799152,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194543',3799153,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194543',3799154,'1811','267',1619427.93,1622344.45,2916.52,481225.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','194543',3799155,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194543',3799156,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194543',3799157,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194543',3799158,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194543',3799159,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194543',3799160,'1817','267',592361.84,594384.90,2023.06,333804.90,0.00,0.00,0.00,0.00,0.00),('5','89','662','194543',3799161,'1818','267',718358.23,720832.98,2474.75,408333.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','194543',3799162,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','194543',3799163,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','194543',3799164,'1821','268',451601.48,451753.14,151.66,40189.90,0.00,0.00,0.00,0.00,0.00),('5','89','666','194543',3799165,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','194543',3799166,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194864',3805641,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','194864',3805642,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194864',3805643,'1811','267',1622344.45,1626020.50,3676.05,606548.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','194864',3805644,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194864',3805645,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194864',3805646,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194864',3805647,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','194864',3805648,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','194864',3805649,'1817','267',594384.90,595787.65,1402.75,231453.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','194864',3805650,'1818','267',720832.98,724408.97,3575.99,590038.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','194864',3805651,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','194864',3805652,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','194864',3805653,'1821','268',451753.14,451947.50,194.36,51505.40,0.00,0.00,0.00,0.00,0.00),('5','89','666','194864',3805654,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','194864',3805655,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195053',3808951,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195053',3808952,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195053',3808953,'1811','267',1626020.50,1627572.21,1551.71,256032.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','195053',3808954,'1812','267',879988.16,879988.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195053',3808955,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195053',3808956,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195053',3808957,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195053',3808958,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195053',3808959,'1817','267',595787.65,596424.95,637.30,105154.50,0.00,0.00,0.00,0.00,0.00),('5','89','662','195053',3808960,'1818','267',724408.97,725595.48,1186.51,195774.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','195053',3808961,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','195053',3808962,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','195053',3808963,'1821','268',451947.50,452129.22,181.72,48155.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','195053',3808964,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','195053',3808965,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195161',3810839,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195161',3810840,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195161',3810841,'1811','267',1627572.21,1628914.92,1342.71,221547.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','195161',3810842,'1812','267',879988.16,881606.47,1618.31,267021.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','195161',3810843,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195161',3810844,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195161',3810845,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195161',3810846,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195161',3810847,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195161',3810848,'1818','267',725595.48,727423.24,1827.76,301580.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','195161',3810849,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','195161',3810850,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','195161',3810851,'1821','268',452129.22,452296.47,167.25,44321.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','195161',3810852,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','195161',3810853,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195504',3816987,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195504',3816988,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195504',3816989,'1811','267',1628914.92,1631848.17,2933.25,483986.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','195504',3816990,'1812','267',881606.47,884398.42,2791.95,460671.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','195504',3816991,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195504',3816992,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195504',3816993,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195504',3816994,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195504',3816995,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195504',3816996,'1818','267',727423.24,730569.17,3145.93,519078.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','195504',3816997,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','195504',3816998,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','195504',3816999,'1821','268',452296.47,452296.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','195504',3817000,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','195504',3817001,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195748',3821017,'1809','267',1622808.01,1622808.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195748',3821018,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195748',3821019,'1811','267',1631848.17,1634964.82,3116.65,514247.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','195748',3821020,'1812','267',884398.42,887414.66,3016.24,497679.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','195748',3821021,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195748',3821022,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195748',3821023,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195748',3821024,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195748',3821025,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195748',3821026,'1818','267',730569.17,734241.69,3672.52,605965.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','195748',3821027,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','195748',3821028,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','195748',3821029,'1821','268',452296.47,452296.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','195748',3821030,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','195748',3821031,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','195940',3824442,'1809','267',1622808.01,1623825.99,1017.98,167966.70,0.00,0.00,0.00,0.00,0.00),('5','89','663','195940',3824443,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195940',3824444,'1811','267',1634964.82,1636464.54,1499.72,247453.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','195940',3824445,'1812','267',887414.66,890022.57,2607.91,430305.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','195940',3824446,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195940',3824447,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195940',3824448,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','195940',3824449,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195940',3824450,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','195940',3824451,'1818','267',734241.69,737295.69,3054.00,503910.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','195940',3824452,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','195940',3824453,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','195940',3824454,'1821','268',452296.47,452296.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','195940',3824455,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','195940',3824456,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','196179',3829070,'1809','267',1623825.99,1627698.55,3872.56,638972.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','196179',3829071,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196179',3829072,'1811','267',1636464.54,1636664.33,199.79,32965.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','196179',3829073,'1812','267',890022.57,892136.54,2113.97,348805.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','196179',3829074,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196179',3829075,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196179',3829076,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196179',3829077,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196179',3829078,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196179',3829079,'1818','267',737295.69,740120.53,2824.84,466098.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','196179',3829080,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','196179',3829081,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','196179',3829082,'1821','268',452296.47,452296.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','196179',3829083,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','196179',3829084,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','196421',3833382,'1809','267',1627698.55,1634574.03,6875.48,1134454.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','196421',3833383,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196421',3833384,'1811','267',1636664.33,1636664.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196421',3833385,'1812','267',892136.54,892136.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196421',3833386,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196421',3833387,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196421',3833388,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196421',3833389,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196421',3833390,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196421',3833391,'1818','267',740120.53,740120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','196421',3833392,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','196421',3833393,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','196421',3833394,'1821','268',452296.47,452296.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','196421',3833395,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','196421',3833396,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','196625',3837127,'1809','267',1634574.03,1637626.67,3052.64,503685.60,0.00,0.00,0.00,0.00,0.00),('5','89','663','196625',3837128,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196625',3837129,'1811','267',1636664.33,1636664.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196625',3837130,'1812','267',892136.54,892136.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196625',3837131,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196625',3837132,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196625',3837133,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196625',3837134,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196625',3837135,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196625',3837136,'1818','267',740120.53,740120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','196625',3837137,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','196625',3837138,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','196625',3837139,'1821','268',452296.47,452527.35,230.88,61183.20,0.00,0.00,0.00,0.00,0.00),('5','89','666','196625',3837140,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','196625',3837141,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','196846',3840967,'1809','267',1637626.67,1637626.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','196846',3840968,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196846',3840969,'1811','267',1636664.33,1636664.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196846',3840970,'1812','267',892136.54,892136.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196846',3840971,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196846',3840972,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196846',3840973,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','196846',3840974,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196846',3840975,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','196846',3840976,'1818','267',740120.53,740120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','196846',3840977,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','196846',3840978,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','196846',3840979,'1821','268',452527.35,452990.03,462.68,122610.20,0.00,0.00,0.00,0.00,0.00),('5','89','666','196846',3840980,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','196846',3840981,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','197150',3846319,'1809','267',1637626.67,1637626.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','197150',3846320,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','197150',3846321,'1811','267',1636664.33,1636664.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','197150',3846322,'1812','267',892136.54,892136.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','197150',3846323,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','197150',3846324,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','197150',3846325,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','197150',3846326,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','197150',3846327,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','197150',3846328,'1818','267',740120.53,740120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','197150',3846329,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','197150',3846330,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','197150',3846331,'1821','268',452990.03,453246.28,256.25,67906.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','197150',3846332,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','197150',3846333,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198547',3870551,'1809','267',1637626.67,1637626.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198547',3870552,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198547',3870553,'1811','267',1636664.33,1636664.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198547',3870554,'1812','267',892136.54,892136.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198547',3870555,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198547',3870556,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198547',3870557,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198547',3870558,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198547',3870559,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198547',3870560,'1818','267',740120.53,740120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198547',3870561,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198547',3870562,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198547',3870563,'1821','268',453246.28,453529.45,283.17,75040.05,0.00,0.00,0.00,0.00,0.00),('5','89','666','198547',3870564,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198547',3870565,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198566',3870818,'1809','267',1637626.67,1637626.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198566',3870819,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198566',3870820,'1811','267',1636664.33,1636664.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198566',3870821,'1812','267',892136.54,892136.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198566',3870822,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198566',3870823,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198566',3870824,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198566',3870825,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198566',3870826,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198566',3870827,'1818','267',740120.53,740120.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198566',3870828,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198566',3870829,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198566',3870830,'1821','268',453529.45,453845.61,316.16,83782.40,0.00,0.00,0.00,0.00,0.00),('5','89','666','198566',3870831,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198566',3870832,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198608',3871423,'1809','267',1637626.67,1637626.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198608',3871424,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198608',3871425,'1811','267',1636664.33,1638368.92,1704.59,281257.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','198608',3871426,'1812','267',892136.54,894358.85,2222.31,366681.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','198608',3871427,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198608',3871428,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198608',3871429,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198608',3871430,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198608',3871431,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198608',3871432,'1818','267',740120.53,742774.57,2654.04,437916.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','198608',3871433,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198608',3871434,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198608',3871435,'1821','268',453845.61,454304.08,458.47,121494.55,0.00,0.00,0.00,0.00,0.00),('5','89','666','198608',3871436,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198608',3871437,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198641',3872039,'1809','267',1637626.67,1637626.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198641',3872040,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198641',3872041,'1811','267',1638368.92,1640360.14,1991.22,328551.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','198641',3872042,'1812','267',894358.85,897637.85,3279.00,541035.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198641',3872043,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198641',3872044,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198641',3872045,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198641',3872046,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198641',3872047,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198641',3872048,'1818','267',742774.57,744807.63,2033.06,335454.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','198641',3872049,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198641',3872050,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198641',3872051,'1821','268',454304.08,454668.83,364.75,96658.75,0.00,0.00,0.00,0.00,0.00),('5','89','666','198641',3872052,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198641',3872053,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198647',3872124,'1809','267',1637626.67,1637626.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198647',3872125,'1810','267',1326614.86,1326614.86,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198647',3872126,'1811','267',1640360.14,1641268.97,908.83,149956.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','198647',3872127,'1812','267',897637.85,899238.89,1601.04,264171.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','198647',3872128,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198647',3872129,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198647',3872130,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198647',3872131,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198647',3872132,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198647',3872133,'1818','267',744807.63,745912.21,1104.58,182255.70,0.00,0.00,0.00,0.00,0.00),('5','89','665','198647',3872134,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198647',3872135,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198647',3872136,'1821','268',454668.83,454836.03,167.20,45144.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198647',3872137,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198647',3872138,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198650',3872181,'1809','267',1637626.67,1638438.69,812.02,133983.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','198650',3872182,'1810','267',1326614.86,1327796.24,1181.38,194927.70,0.00,0.00,0.00,0.00,0.00),('5','89','662','198650',3872183,'1811','267',1641268.97,1642866.03,1597.06,263514.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','198650',3872184,'1812','267',899238.89,901208.73,1969.84,325023.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','198650',3872185,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198650',3872186,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198650',3872187,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198650',3872188,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198650',3872189,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198650',3872190,'1818','267',745912.21,747511.44,1599.23,263872.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','198650',3872191,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198650',3872192,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198650',3872193,'1821','268',454836.03,455424.23,588.20,158814.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198650',3872194,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198650',3872195,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198660',3872382,'1809','267',1638438.69,1640688.60,2249.91,371235.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','198660',3872383,'1810','267',1327796.24,1329989.29,2193.05,361853.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','198660',3872384,'1811','267',1642866.03,1644701.95,1835.92,302926.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','198660',3872385,'1812','267',901208.73,902831.27,1622.54,267719.10,0.00,0.00,0.00,0.00,0.00),('5','89','664','198660',3872386,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198660',3872387,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198660',3872388,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198660',3872389,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198660',3872390,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198660',3872391,'1818','267',747511.44,749953.36,2441.92,402916.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','198660',3872392,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198660',3872393,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198660',3872394,'1821','268',455424.23,455720.51,296.28,79995.60,0.00,0.00,0.00,0.00,0.00),('5','89','666','198660',3872395,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198660',3872396,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198727',3873739,'1809','267',1640688.60,1643069.81,2381.21,392899.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','198727',3873740,'1810','267',1329989.29,1332026.44,2037.15,336129.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','198727',3873741,'1811','267',1644701.95,1645617.73,915.78,151103.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','198727',3873742,'1812','267',902831.27,903424.29,593.02,97848.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','198727',3873743,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198727',3873744,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198727',3873745,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198727',3873746,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198727',3873747,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198727',3873748,'1818','267',749953.36,752067.82,2114.46,348885.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','198727',3873749,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198727',3873750,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198727',3873751,'1821','268',455720.51,456348.15,627.64,169462.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','198727',3873752,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198727',3873753,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','198817',3874783,'1809','267',1643069.81,1645487.36,2417.55,398895.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','198817',3874784,'1810','267',1332026.44,1334003.38,1976.94,326195.10,0.00,0.00,0.00,0.00,0.00),('5','89','662','198817',3874785,'1811','267',1645617.73,1647723.99,2106.26,347532.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','198817',3874786,'1812','267',903424.29,903424.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198817',3874787,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198817',3874788,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198817',3874789,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','198817',3874790,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198817',3874791,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','198817',3874792,'1818','267',752067.82,754678.12,2610.30,430699.50,0.00,0.00,0.00,0.00,0.00),('5','89','665','198817',3874793,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','198817',3874794,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','198817',3874795,'1821','268',456348.15,456751.19,403.04,108820.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','198817',3874796,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','198817',3874797,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','199001',3878109,'1809','267',1645487.36,1647432.62,1945.26,320967.90,0.00,0.00,0.00,0.00,0.00),('5','89','663','199001',3878110,'1810','267',1334003.38,1334003.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199001',3878111,'1811','267',1647723.99,1649531.62,1807.63,298258.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','199001',3878112,'1812','267',903424.29,905499.51,2075.22,342411.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','199001',3878113,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199001',3878114,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199001',3878115,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199001',3878116,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199001',3878117,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199001',3878118,'1818','267',754678.12,756791.89,2113.77,348772.05,0.00,0.00,0.00,0.00,0.00),('5','89','665','199001',3878119,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','199001',3878120,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','199001',3878121,'1821','268',456751.19,457211.94,460.75,124402.50,0.00,0.00,0.00,0.00,0.00),('5','89','666','199001',3878122,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','199001',3878123,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','199220',3882053,'1809','267',1647432.62,1650554.29,3121.67,515075.55,0.00,0.00,0.00,0.00,0.00),('5','89','663','199220',3882054,'1810','267',1334003.38,1337593.18,3589.80,592317.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199220',3882055,'1811','267',1649531.62,1652872.77,3341.15,551289.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','199220',3882056,'1812','267',905499.51,907202.55,1703.04,281001.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','199220',3882057,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199220',3882058,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199220',3882059,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199220',3882060,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199220',3882061,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199220',3882062,'1818','267',756791.89,757448.15,656.26,108282.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','199220',3882063,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','199220',3882064,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','199220',3882065,'1821','268',457211.94,457602.80,390.86,105532.20,0.00,0.00,0.00,0.00,0.00),('5','89','666','199220',3882066,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','199220',3882067,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','199530',3887060,'1809','267',1650554.29,1653061.49,2507.20,413688.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','199530',3887061,'1810','267',1337593.18,1341244.34,3651.16,602441.40,0.00,0.00,0.00,0.00,0.00),('5','89','662','199530',3887062,'1811','267',1652872.77,1656144.44,3271.67,539825.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','199530',3887063,'1812','267',907202.55,907202.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199530',3887064,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199530',3887065,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199530',3887066,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199530',3887067,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199530',3887068,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199530',3887069,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','199530',3887070,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','199530',3887071,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','199530',3887072,'1821','268',457602.80,458086.18,483.38,130512.60,0.00,0.00,0.00,0.00,0.00),('5','89','666','199530',3887073,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','199530',3887074,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','199635',3889104,'1809','267',1653061.49,1656507.39,3445.90,568573.50,0.00,0.00,0.00,0.00,0.00),('5','89','663','199635',3889105,'1810','267',1341244.34,1344846.37,3602.03,594334.95,0.00,0.00,0.00,0.00,0.00),('5','89','662','199635',3889106,'1811','267',1656144.44,1659804.75,3660.31,603951.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','199635',3889107,'1812','267',907202.55,907202.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199635',3889108,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199635',3889109,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199635',3889110,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','199635',3889111,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199635',3889112,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','199635',3889113,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','199635',3889114,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','199635',3889115,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','199635',3889116,'1821','268',458086.18,458480.49,394.31,106463.70,0.00,0.00,0.00,0.00,0.00),('5','89','666','199635',3889117,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','199635',3889118,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','200009',3895200,'1809','267',1656507.39,1659383.20,2875.81,474508.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','200009',3895201,'1810','267',1344846.37,1347863.70,3017.33,497859.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','200009',3895202,'1811','267',1659804.75,1663235.10,3430.35,566007.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','200009',3895203,'1812','267',907202.55,907202.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200009',3895204,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200009',3895205,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200009',3895206,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200009',3895207,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200009',3895208,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200009',3895209,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200009',3895210,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200009',3895211,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','200009',3895212,'1821','268',458480.49,459234.22,753.73,203507.10,0.00,0.00,0.00,0.00,0.00),('5','89','666','200009',3895213,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','200009',3895214,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','200097',3896766,'1809','267',1659383.20,1663016.36,3633.16,599471.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','200097',3896767,'1810','267',1347863.70,1351724.73,3861.03,637069.95,0.00,0.00,0.00,0.00,0.00),('5','89','662','200097',3896768,'1811','267',1663235.10,1666545.00,3309.90,546133.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','200097',3896769,'1812','267',907202.55,907202.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200097',3896770,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200097',3896771,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200097',3896772,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200097',3896773,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200097',3896774,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200097',3896775,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200097',3896776,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200097',3896777,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','200097',3896778,'1821','268',459234.22,459712.42,478.20,129114.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','200097',3896779,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','200097',3896780,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','200335',3900735,'1809','267',1663016.36,1667122.11,4105.75,677448.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','200335',3900736,'1810','267',1351724.73,1354372.86,2648.13,436941.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','200335',3900737,'1811','267',1666545.00,1669873.83,3328.83,549256.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','200335',3900738,'1812','267',907202.55,907738.41,535.86,88416.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','200335',3900739,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200335',3900740,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200335',3900741,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200335',3900742,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200335',3900743,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200335',3900744,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200335',3900745,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200335',3900746,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','200335',3900747,'1821','268',459712.42,460061.48,349.06,94246.20,0.00,0.00,0.00,0.00,0.00),('5','89','666','200335',3900748,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','200335',3900749,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','200591',3905611,'1809','267',1667122.11,1670080.60,2958.49,488150.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','200591',3905612,'1810','267',1354372.86,1355032.84,659.98,108896.70,0.00,0.00,0.00,0.00,0.00),('5','89','662','200591',3905613,'1811','267',1669873.83,1672735.73,2861.90,472213.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','200591',3905614,'1812','267',907738.41,910365.55,2627.14,433478.10,0.00,0.00,0.00,0.00,0.00),('5','89','664','200591',3905615,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200591',3905616,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200591',3905617,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200591',3905618,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200591',3905619,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200591',3905620,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200591',3905621,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200591',3905622,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','200591',3905623,'1821','268',460061.48,460307.77,246.29,66498.30,0.00,0.00,0.00,0.00,0.00),('5','89','666','200591',3905624,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','200591',3905625,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','200760',3908542,'1809','267',1670080.60,1674051.43,3970.83,655186.95,0.00,0.00,0.00,0.00,0.00),('5','89','663','200760',3908543,'1810','267',1355032.84,1355167.53,134.69,22223.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','200760',3908544,'1811','267',1672735.73,1675973.82,3238.09,534284.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','200760',3908545,'1812','267',910365.55,914219.78,3854.23,635947.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','200760',3908546,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200760',3908547,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200760',3908548,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200760',3908549,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200760',3908550,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200760',3908551,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200760',3908552,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200760',3908553,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','200760',3908554,'1821','268',460307.77,462415.84,2108.07,569178.90,0.00,0.00,0.00,0.00,0.00),('5','89','666','200760',3908555,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','200760',3908556,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','200932',3911630,'1809','267',1674051.43,1677250.54,3199.11,527853.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','200932',3911631,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200932',3911632,'1811','267',1675973.82,1679552.85,3579.03,590539.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','200932',3911633,'1812','267',914219.78,918265.19,4045.41,667492.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','200932',3911634,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200932',3911635,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200932',3911636,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','200932',3911637,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200932',3911638,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','200932',3911639,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200932',3911640,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','200932',3911641,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','200932',3911642,'1821','268',462415.84,462846.22,430.38,116202.60,0.00,0.00,0.00,0.00,0.00),('5','89','666','200932',3911643,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','200932',3911644,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','201160',3915226,'1809','267',1677250.54,1680825.72,3575.18,589904.70,0.00,0.00,0.00,0.00,0.00),('5','89','663','201160',3915227,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201160',3915228,'1811','267',1679552.85,1682814.85,3262.00,538230.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201160',3915229,'1812','267',918265.19,922618.52,4353.33,718299.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','201160',3915230,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201160',3915231,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201160',3915232,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201160',3915233,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201160',3915234,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201160',3915235,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','201160',3915236,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','201160',3915237,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','201160',3915238,'1821','268',462846.22,463255.66,409.44,110548.80,0.00,0.00,0.00,0.00,0.00),('5','89','666','201160',3915239,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','201160',3915240,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','201338',3918334,'1809','267',1680825.72,1684404.07,3578.35,590427.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','201338',3918335,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201338',3918336,'1811','267',1682814.85,1686459.04,3644.19,601291.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','201338',3918337,'1812','267',922618.52,926118.45,3499.93,577488.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','201338',3918338,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201338',3918339,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201338',3918340,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201338',3918341,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201338',3918342,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201338',3918343,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','201338',3918344,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','201338',3918345,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','201338',3918346,'1821','268',463255.66,463852.52,596.86,161152.20,0.00,0.00,0.00,0.00,0.00),('5','89','666','201338',3918347,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','201338',3918348,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','201560',3922417,'1809','267',1684404.07,1688173.81,3769.74,622007.10,0.00,0.00,0.00,0.00,0.00),('5','89','663','201560',3922418,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201560',3922419,'1811','267',1686459.04,1688387.71,1928.67,318230.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','201560',3922420,'1812','267',926118.45,930813.45,4695.00,774675.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201560',3922421,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201560',3922422,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201560',3922423,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201560',3922424,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201560',3922425,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201560',3922426,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','201560',3922427,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','201560',3922428,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','201560',3922429,'1821','268',463852.52,464227.92,375.40,101358.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','201560',3922430,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','201560',3922431,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','201839',3927915,'1809','267',1688173.81,1691748.08,3574.27,589754.55,0.00,0.00,0.00,0.00,0.00),('5','89','663','201839',3927916,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201839',3927917,'1811','267',1688387.71,1691606.43,3218.72,531088.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','201839',3927918,'1812','267',930813.45,934330.61,3517.16,580331.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','201839',3927919,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201839',3927920,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201839',3927921,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','201839',3927922,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201839',3927923,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','201839',3927924,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','201839',3927925,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','201839',3927926,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','201839',3927927,'1821','268',464227.92,464476.51,248.59,68362.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','201839',3927928,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','201839',3927929,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','202055',3931879,'1809','267',1691748.08,1693878.53,2130.45,351524.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','202055',3931880,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202055',3931881,'1811','267',1691606.43,1695225.16,3618.73,597090.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','202055',3931882,'1812','267',934330.61,938494.28,4163.67,687005.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','202055',3931883,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202055',3931884,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202055',3931885,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202055',3931886,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202055',3931887,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202055',3931888,'1818','267',757448.15,757448.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','202055',3931889,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','202055',3931890,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','202055',3931891,'1821','268',464476.51,464649.83,173.32,47663.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','202055',3931892,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','202055',3931893,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','202237',3935022,'1809','267',1693878.53,1693878.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','202237',3935023,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202237',3935024,'1811','267',1695225.16,1698900.87,3675.71,606492.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','202237',3935025,'1812','267',938494.28,941908.19,3413.91,563295.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','202237',3935026,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202237',3935027,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202237',3935028,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202237',3935029,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202237',3935030,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202237',3935031,'1818','267',757448.15,761115.55,3667.40,605121.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','202237',3935032,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','202237',3935033,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','202237',3935034,'1821','268',464649.83,465440.82,790.99,217522.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','202237',3935035,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','202237',3935036,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','202474',3939095,'1809','267',1693878.53,1693878.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','202474',3939096,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202474',3939097,'1811','267',1698900.87,1702520.54,3619.67,597245.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','202474',3939098,'1812','267',941908.19,945306.28,3398.09,560684.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','202474',3939099,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202474',3939100,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202474',3939101,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202474',3939102,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202474',3939103,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202474',3939104,'1818','267',761115.55,764156.60,3041.05,501773.25,0.00,0.00,0.00,0.00,0.00),('5','89','665','202474',3939105,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','202474',3939106,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','202474',3939107,'1821','268',465440.82,466058.65,617.83,169903.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','202474',3939108,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','202474',3939109,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','202656',3942310,'1809','267',1693878.53,1694725.00,846.47,139667.55,0.00,0.00,0.00,0.00,0.00),('5','89','663','202656',3942311,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202656',3942312,'1811','267',1702520.54,1706393.02,3872.48,638959.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','202656',3942313,'1812','267',945306.28,947789.46,2483.18,409724.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','202656',3942314,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202656',3942315,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202656',3942316,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202656',3942317,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202656',3942318,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202656',3942319,'1818','267',764156.60,767553.04,3396.44,560412.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','202656',3942320,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','202656',3942321,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','202656',3942322,'1821','268',466058.65,466598.52,539.87,148464.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','202656',3942323,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','202656',3942324,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','202872',3946118,'1809','267',1694725.00,1695536.52,811.52,133900.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','202872',3946119,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202872',3946120,'1811','267',1706393.02,1709596.84,3203.82,528630.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','202872',3946121,'1812','267',947789.46,950968.56,3179.10,524551.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','202872',3946122,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202872',3946123,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202872',3946124,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','202872',3946125,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202872',3946126,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','202872',3946127,'1818','267',767553.04,770695.89,3142.85,518570.25,0.00,0.00,0.00,0.00,0.00),('5','89','665','202872',3946128,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','202872',3946129,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','202872',3946130,'1821','268',466598.52,467285.95,687.43,189043.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','202872',3946131,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','202872',3946132,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','203153',3951477,'1809','267',1695536.52,1698183.14,2646.62,436692.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','203153',3951478,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203153',3951479,'1811','267',1709596.84,1711682.89,2086.05,344198.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','203153',3951480,'1812','267',950968.56,953513.52,2544.96,419918.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','203153',3951481,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203153',3951482,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203153',3951483,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203153',3951484,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203153',3951485,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203153',3951486,'1818','267',770695.89,773525.19,2829.30,466834.50,0.00,0.00,0.00,0.00,0.00),('5','89','665','203153',3951487,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','203153',3951488,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','203153',3951489,'1821','268',467285.95,467774.03,488.08,134222.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','203153',3951490,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','203153',3951491,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','203343',3954954,'1809','267',1698183.14,1700732.27,2549.13,420606.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','203343',3954955,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203343',3954956,'1811','267',1711682.89,1713540.20,1857.31,306456.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','203343',3954957,'1812','267',953513.52,955647.17,2133.65,352052.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','203343',3954958,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203343',3954959,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203343',3954960,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203343',3954961,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203343',3954962,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203343',3954963,'1818','267',773525.19,776193.67,2668.48,440299.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','203343',3954964,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','203343',3954965,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','203343',3954966,'1821','268',467774.03,468239.94,465.91,128125.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','203343',3954967,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','203343',3954968,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','203533',3958419,'1809','267',1700732.27,1704427.09,3694.82,609645.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','203533',3958420,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203533',3958421,'1811','267',1713540.20,1714814.74,1274.54,210299.10,0.00,0.00,0.00,0.00,0.00),('5','89','664','203533',3958422,'1812','267',955647.17,958918.89,3271.72,539833.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','203533',3958423,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203533',3958424,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203533',3958425,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203533',3958426,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203533',3958427,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203533',3958428,'1818','267',776193.67,776193.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','203533',3958429,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','203533',3958430,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','203533',3958431,'1821','268',468239.94,468402.68,162.74,44753.50,0.00,0.00,0.00,0.00,0.00),('5','89','666','203533',3958432,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','203533',3958433,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','203772',3962637,'1809','267',1704427.09,1710605.77,6178.68,1019482.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','203772',3962638,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203772',3962639,'1811','267',1714814.74,1714814.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203772',3962640,'1812','267',958918.89,960947.16,2028.27,334664.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','203772',3962641,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203772',3962642,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203772',3962643,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203772',3962644,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203772',3962645,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203772',3962646,'1818','267',776193.67,776193.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','203772',3962647,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','203772',3962648,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','203772',3962649,'1821','268',468402.68,469002.56,599.88,164967.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','203772',3962650,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','203772',3962651,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','203984',3966291,'1809','267',1710605.77,1716533.31,5927.54,978044.10,0.00,0.00,0.00,0.00,0.00),('5','89','663','203984',3966292,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203984',3966293,'1811','267',1714814.74,1716055.50,1240.76,204725.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','203984',3966294,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203984',3966295,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203984',3966296,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203984',3966297,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','203984',3966298,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203984',3966299,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','203984',3966300,'1818','267',776193.67,777915.31,1721.64,284070.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','203984',3966301,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','203984',3966302,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','203984',3966303,'1821','268',469002.56,469825.75,823.19,226377.25,0.00,0.00,0.00,0.00,0.00),('5','89','666','203984',3966304,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','203984',3966305,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','204302',3972225,'1809','267',1716533.31,1719462.95,2929.64,483390.60,0.00,0.00,0.00,0.00,0.00),('5','89','663','204302',3972226,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204302',3972227,'1811','267',1716055.50,1718590.11,2534.61,418210.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','204302',3972228,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204302',3972229,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204302',3972230,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204302',3972231,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204302',3972232,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204302',3972233,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204302',3972234,'1818','267',777915.31,781805.80,3890.49,641930.85,0.00,0.00,0.00,0.00,0.00),('5','89','665','204302',3972235,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','204302',3972236,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','204302',3972237,'1821','268',469825.75,470224.59,398.84,109681.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','204302',3972238,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','204302',3972239,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','204428',3974405,'1809','267',1719462.95,1720181.93,718.98,118631.70,0.00,0.00,0.00,0.00,0.00),('5','89','663','204428',3974406,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204428',3974407,'1811','267',1718590.11,1722484.93,3894.82,642645.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','204428',3974408,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204428',3974409,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204428',3974410,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204428',3974411,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204428',3974412,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204428',3974413,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204428',3974414,'1818','267',781805.80,786302.23,4496.43,741910.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','204428',3974415,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','204428',3974416,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','204428',3974417,'1821','268',470224.59,471957.83,1733.24,476641.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','204428',3974418,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','204428',3974419,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','204621',3978060,'1809','267',1720181.93,1723573.76,3391.83,559651.95,0.00,0.00,0.00,0.00,0.00),('5','89','663','204621',3978061,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204621',3978062,'1811','267',1722484.93,1725026.26,2541.33,419319.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','204621',3978063,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204621',3978064,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204621',3978065,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204621',3978066,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204621',3978067,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204621',3978068,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204621',3978069,'1818','267',786302.23,790160.81,3858.58,636665.70,0.00,0.00,0.00,0.00,0.00),('5','89','665','204621',3978070,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','204621',3978071,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','204621',3978072,'1821','268',471957.83,472660.87,703.04,193336.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','204621',3978073,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','204621',3978074,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','204859',3981856,'1809','267',1723573.76,1726519.76,2946.00,486090.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','204859',3981857,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204859',3981858,'1811','267',1725026.26,1726744.22,1717.96,283463.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','204859',3981859,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204859',3981860,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204859',3981861,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204859',3981862,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','204859',3981863,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204859',3981864,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','204859',3981865,'1818','267',790160.81,792756.50,2595.69,428288.85,0.00,0.00,0.00,0.00,0.00),('5','89','665','204859',3981866,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','204859',3981867,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','204859',3981868,'1821','268',472660.87,472858.04,197.17,54221.75,0.00,0.00,0.00,0.00,0.00),('5','89','666','204859',3981869,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','204859',3981870,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','205084',3985802,'1809','267',1726519.76,1729174.31,2654.55,438000.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','205084',3985803,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205084',3985804,'1811','267',1726744.22,1729316.06,2571.84,424353.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','205084',3985805,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205084',3985806,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205084',3985807,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205084',3985808,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205084',3985809,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205084',3985810,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205084',3985811,'1818','267',792756.50,795690.10,2933.60,484044.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','205084',3985812,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','205084',3985813,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205084',3985814,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205084',3985815,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','205084',3985816,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','205306',3989884,'1809','267',1729174.31,1732567.27,3392.96,559838.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','205306',3989885,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205306',3989886,'1811','267',1729316.06,1731986.62,2670.56,440642.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','205306',3989887,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205306',3989888,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205306',3989889,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205306',3989890,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205306',3989891,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205306',3989892,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205306',3989893,'1818','267',795690.10,799270.21,3580.11,590718.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','205306',3989894,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','205306',3989895,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205306',3989896,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205306',3989897,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','205306',3989898,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','205547',3994315,'1809','267',1732567.27,1736385.13,3817.86,629946.90,0.00,0.00,0.00,0.00,0.00),('5','89','663','205547',3994316,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205547',3994317,'1811','267',1731986.62,1734110.92,2124.30,350509.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','205547',3994318,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205547',3994319,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205547',3994320,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205547',3994321,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205547',3994322,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205547',3994323,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205547',3994324,'1818','267',799270.21,801834.53,2564.32,423112.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','205547',3994325,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','205547',3994326,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205547',3994327,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205547',3994328,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','205547',3994329,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','205760',3998108,'1809','267',1736385.13,1744601.42,8216.29,1355687.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','205760',3998109,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205760',3998110,'1811','267',1734110.92,1734110.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205760',3998111,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205760',3998112,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205760',3998113,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205760',3998114,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205760',3998115,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205760',3998116,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205760',3998117,'1818','267',801834.53,801834.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','205760',3998118,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','205760',3998119,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205760',3998120,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205760',3998121,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','205760',3998122,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','205996',4002419,'1809','267',1744601.42,1747516.17,2914.75,480933.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','205996',4002420,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205996',4002421,'1811','267',1734110.92,1736939.29,2828.37,466681.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','205996',4002422,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205996',4002423,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205996',4002424,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205996',4002425,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','205996',4002426,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205996',4002427,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','205996',4002428,'1818','267',801834.53,804962.57,3128.04,516126.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','205996',4002429,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','205996',4002430,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205996',4002431,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','205996',4002432,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','205996',4002433,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','206239',4006770,'1809','267',1747516.17,1750667.68,3151.51,519999.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','206239',4006771,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206239',4006772,'1811','267',1736939.29,1739742.23,2802.94,462485.10,0.00,0.00,0.00,0.00,0.00),('5','89','664','206239',4006773,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206239',4006774,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206239',4006775,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206239',4006776,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206239',4006777,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206239',4006778,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206239',4006779,'1818','267',804962.57,808606.13,3643.56,601187.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','206239',4006780,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','206239',4006781,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','206239',4006782,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','206239',4006783,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','206239',4006784,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','206547',4012242,'1809','267',1750667.68,1754153.24,3485.56,575117.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','206547',4012243,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206547',4012244,'1811','267',1739742.23,1742423.67,2681.44,442437.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','206547',4012245,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206547',4012246,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206547',4012247,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206547',4012248,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206547',4012249,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206547',4012250,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206547',4012251,'1818','267',808606.13,811355.97,2749.84,453723.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','206547',4012252,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','206547',4012253,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','206547',4012254,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','206547',4012255,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','206547',4012256,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','206773',4016181,'1809','267',1754153.24,1756611.98,2458.74,405692.10,0.00,0.00,0.00,0.00,0.00),('5','89','663','206773',4016182,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206773',4016183,'1811','267',1742423.67,1744660.16,2236.49,369020.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','206773',4016184,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206773',4016185,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206773',4016186,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206773',4016187,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206773',4016188,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206773',4016189,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206773',4016190,'1818','267',811355.97,814204.89,2848.92,470071.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','206773',4016191,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','206773',4016192,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','206773',4016193,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','206773',4016194,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','206773',4016195,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','206854',4017336,'1809','267',1756611.98,1759956.80,3344.82,551895.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','206854',4017337,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206854',4017338,'1811','267',1744660.16,1747307.84,2647.68,436867.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','206854',4017339,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206854',4017340,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206854',4017341,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206854',4017342,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','206854',4017343,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206854',4017344,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','206854',4017345,'1818','267',814204.89,817920.03,3715.14,612998.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','206854',4017346,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','206854',4017347,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','206854',4017348,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','206854',4017349,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','206854',4017350,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','207073',4021357,'1809','267',1759956.80,1763368.62,3411.82,562950.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','207073',4021358,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207073',4021359,'1811','267',1747307.84,1749818.79,2510.95,414306.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','207073',4021360,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207073',4021361,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207073',4021362,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207073',4021363,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207073',4021364,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207073',4021365,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207073',4021366,'1818','267',817920.03,820743.24,2823.21,465829.65,0.00,0.00,0.00,0.00,0.00),('5','89','665','207073',4021367,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','207073',4021368,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207073',4021369,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207073',4021370,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','207073',4021371,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','207278',4025053,'1809','267',1763368.62,1763368.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','207278',4025054,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207278',4025055,'1811','267',1749818.79,1753912.98,4094.19,675541.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','207278',4025056,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207278',4025057,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207278',4025058,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207278',4025059,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207278',4025060,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207278',4025061,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207278',4025062,'1818','267',820743.24,825123.60,4380.36,722759.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','207278',4025063,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','207278',4025064,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207278',4025065,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207278',4025066,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','207278',4025067,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','207633',4031479,'1809','267',1763368.62,1764434.01,1065.39,175789.35,0.00,0.00,0.00,0.00,0.00),('5','89','663','207633',4031480,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207633',4031481,'1811','267',1753912.98,1756292.15,2379.17,392563.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','207633',4031482,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207633',4031483,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207633',4031484,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207633',4031485,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207633',4031486,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207633',4031487,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207633',4031488,'1818','267',825123.60,827152.24,2028.64,334725.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','207633',4031489,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','207633',4031490,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207633',4031491,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207633',4031492,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','207633',4031493,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','207704',4032603,'1809','267',1764434.01,1764434.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','207704',4032604,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207704',4032605,'1811','267',1756292.15,1761717.05,5424.90,895108.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','207704',4032606,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207704',4032607,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207704',4032608,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207704',4032609,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207704',4032610,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207704',4032611,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207704',4032612,'1818','267',827152.24,831773.14,4620.90,762448.50,0.00,0.00,0.00,0.00,0.00),('5','89','665','207704',4032613,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','207704',4032614,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207704',4032615,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207704',4032616,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','207704',4032617,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','207938',4036464,'1809','267',1764434.01,1764434.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','207938',4036465,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207938',4036466,'1811','267',1761717.05,1766372.97,4655.92,768226.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','207938',4036467,'1812','267',960947.16,960947.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207938',4036468,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207938',4036469,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207938',4036470,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','207938',4036471,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207938',4036472,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','207938',4036473,'1818','267',831773.14,836574.51,4801.37,792226.05,0.00,0.00,0.00,0.00,0.00),('5','89','665','207938',4036474,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','207938',4036475,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207938',4036476,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','207938',4036477,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','207938',4036478,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','208158',4040392,'1809','267',1764434.01,1764434.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','208158',4040393,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208158',4040394,'1811','267',1766372.97,1769196.35,2823.38,465857.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','208158',4040395,'1812','267',960947.16,963199.98,2252.82,371715.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','208158',4040396,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208158',4040397,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208158',4040398,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208158',4040399,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208158',4040400,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208158',4040401,'1818','267',836574.51,839732.90,3158.39,521134.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','208158',4040402,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','208158',4040403,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208158',4040404,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208158',4040405,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','208158',4040406,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','208361',4044065,'1809','267',1764434.01,1768573.60,4139.59,683032.35,0.00,0.00,0.00,0.00,0.00),('5','89','663','208361',4044066,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208361',4044067,'1811','267',1769196.35,1769601.46,405.11,66843.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','208361',4044068,'1812','267',963199.98,966809.27,3609.29,595532.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','208361',4044069,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208361',4044070,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208361',4044071,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208361',4044072,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208361',4044073,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208361',4044074,'1818','267',839732.90,840891.35,1158.45,191144.25,0.00,0.00,0.00,0.00,0.00),('5','89','665','208361',4044075,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','208361',4044076,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208361',4044077,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208361',4044078,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','208361',4044079,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','208641',4048941,'1809','267',1768573.60,1772863.24,4289.64,707790.60,0.00,0.00,0.00,0.00,0.00),('5','89','663','208641',4048942,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208641',4048943,'1811','267',1769601.46,1769601.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208641',4048944,'1812','267',966809.27,971073.31,4264.04,703566.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','208641',4048945,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208641',4048946,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208641',4048947,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208641',4048948,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208641',4048949,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208641',4048950,'1818','267',840891.35,840891.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','208641',4048951,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','208641',4048952,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208641',4048953,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208641',4048954,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','208641',4048955,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','208918',4053757,'1809','267',1772863.24,1777102.89,4239.65,699542.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','208918',4053758,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208918',4053759,'1811','267',1769601.46,1769601.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208918',4053760,'1812','267',971073.31,975005.26,3931.95,648771.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','208918',4053761,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208918',4053762,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208918',4053763,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208918',4053764,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208918',4053765,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208918',4053766,'1818','267',840891.35,840891.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','208918',4053767,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','208918',4053768,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208918',4053769,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208918',4053770,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','208918',4053771,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','208994',4055099,'1809','267',1777102.89,1783222.70,6119.81,1009768.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','208994',4055100,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208994',4055101,'1811','267',1769601.46,1769601.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208994',4055102,'1812','267',975005.26,975829.13,823.87,135938.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','208994',4055103,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208994',4055104,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208994',4055105,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','208994',4055106,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208994',4055107,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','208994',4055108,'1818','267',840891.35,840891.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','208994',4055109,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','208994',4055110,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208994',4055111,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','208994',4055112,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','208994',4055113,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','209374',4061778,'1809','267',1783222.70,1790235.44,7012.74,1157102.10,0.00,0.00,0.00,0.00,0.00),('5','89','663','209374',4061779,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209374',4061780,'1811','267',1769601.46,1769601.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209374',4061781,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209374',4061782,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209374',4061783,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209374',4061784,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209374',4061785,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209374',4061786,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209374',4061787,'1818','267',840891.35,840891.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','209374',4061788,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','209374',4061789,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','209374',4061790,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','209374',4061791,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','209374',4061792,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','209470',4063337,'1809','267',1790235.44,1794208.08,3972.64,655485.60,0.00,0.00,0.00,0.00,0.00),('5','89','663','209470',4063338,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209470',4063339,'1811','267',1769601.46,1771070.41,1468.95,242376.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','209470',4063340,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209470',4063341,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209470',4063342,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209470',4063343,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209470',4063344,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209470',4063345,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209470',4063346,'1818','267',840891.35,843344.38,2453.03,404749.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','209470',4063347,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','209470',4063348,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','209470',4063349,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','209470',4063350,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','209470',4063351,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','209714',4067790,'1809','267',1794208.08,1794208.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','209714',4067791,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209714',4067792,'1811','267',1771070.41,1774704.69,3634.28,592387.64,0.00,0.00,0.00,0.00,0.00),('5','89','664','209714',4067793,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209714',4067794,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209714',4067795,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209714',4067796,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209714',4067797,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209714',4067798,'1817','267',596424.95,596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209714',4067799,'1818','267',843344.38,847058.08,3713.70,605333.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','209714',4067800,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','209714',4067801,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','209714',4067802,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','209714',4067803,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','209714',4067804,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','209903',4071051,'1809','267',1794208.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','209903',4071052,'1810','267',1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209903',4071053,'1811','267',1774704.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209903',4071054,'1812','267',975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209903',4071055,'1813','267',609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209903',4071056,'1814','267',682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209903',4071057,'1815','267',843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','209903',4071058,'1816','267',440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209903',4071059,'1817','267',596424.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','209903',4071060,'1818','267',847058.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','209903',4071061,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','209903',4071062,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','209903',4071063,'1821','268',472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','209903',4071064,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','209903',4071065,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210057',4073962,'1809','267',1794208.08,1794208.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210057',4073963,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210057',4073964,'1811','267',1774704.69,1778121.89,3417.20,557003.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','210057',4073965,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210057',4073966,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210057',4073967,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210057',4073968,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210057',4073969,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210057',4073970,'1817','267',449995.56,451131.45,1135.89,185150.07,0.00,0.00,0.00,0.00,0.00),('5','89','662','210057',4073971,'1818','267',847058.08,850185.54,3127.46,509775.98,0.00,0.00,0.00,0.00,0.00),('5','89','665','210057',4073972,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','210057',4073973,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210057',4073974,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210057',4073975,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','210057',4073976,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210127',4075039,'1809','267',1794208.08,1794208.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210127',4075040,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210127',4075041,'1811','267',1778121.89,1781061.43,2939.54,479145.02,0.00,0.00,0.00,0.00,0.00),('5','89','664','210127',4075042,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210127',4075043,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210127',4075044,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210127',4075045,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210127',4075046,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210127',4075047,'1817','267',451131.45,453528.08,2396.63,390650.69,0.00,0.00,0.00,0.00,0.00),('5','89','662','210127',4075048,'1818','267',850185.54,853917.35,3731.81,608285.03,0.00,0.00,0.00,0.00,0.00),('5','89','665','210127',4075049,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','210127',4075050,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210127',4075051,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210127',4075052,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','210127',4075053,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210321',4078526,'1809','267',1794208.08,1794208.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210321',4078527,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210321',4078528,'1811','267',1781061.43,1784561.30,3499.87,570478.81,0.00,0.00,0.00,0.00,0.00),('5','89','664','210321',4078529,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210321',4078530,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210321',4078531,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210321',4078532,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210321',4078533,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210321',4078534,'1817','267',453528.08,456920.77,3392.69,553008.47,0.00,0.00,0.00,0.00,0.00),('5','89','662','210321',4078535,'1818','267',853917.35,855249.71,1332.36,217174.68,0.00,0.00,0.00,0.00,0.00),('5','89','665','210321',4078536,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','210321',4078537,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210321',4078538,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210321',4078539,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','210321',4078540,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210576',4083131,'1809','267',1794208.08,1794208.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210576',4083132,'1810','267',1355167.53,1355167.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210576',4083133,'1811','267',1784561.30,1788391.88,3830.58,624384.54,0.00,0.00,0.00,0.00,0.00),('5','89','664','210576',4083134,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210576',4083135,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210576',4083136,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210576',4083137,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210576',4083138,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210576',4083139,'1817','267',456920.77,460783.01,3862.24,629545.12,0.00,0.00,0.00,0.00,0.00),('5','89','662','210576',4083140,'1818','267',855249.71,855301.85,52.14,8498.82,0.00,0.00,0.00,0.00,0.00),('5','89','665','210576',4083141,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','210576',4083142,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210576',4083143,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210576',4083144,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','210576',4083145,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','210736',4086026,'1809','267',1794208.08,1797782.74,3574.66,582669.58,0.00,0.00,0.00,0.00,0.00),('5','89','663','210736',4086027,'1810','267',1355167.53,1359568.22,4400.69,717312.47,0.00,0.00,0.00,0.00,0.00),('5','89','662','210736',4086028,'1811','267',1788391.88,1789111.45,719.57,117289.91,0.00,0.00,0.00,0.00,0.00),('5','89','664','210736',4086029,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210736',4086030,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210736',4086031,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210736',4086032,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','210736',4086033,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','210736',4086034,'1817','267',460783.01,461213.63,430.62,70191.06,0.00,0.00,0.00,0.00,0.00),('5','89','662','210736',4086035,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','210736',4086036,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','210736',4086037,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210736',4086038,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','210736',4086039,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','210736',4086040,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','211059',4091504,'1809','267',1797782.74,1802653.67,4870.93,793961.59,0.00,0.00,0.00,0.00,0.00),('5','89','663','211059',4091505,'1810','267',1359568.22,1364260.36,4692.14,764818.82,0.00,0.00,0.00,0.00,0.00),('5','89','662','211059',4091506,'1811','267',1789111.45,1789111.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211059',4091507,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211059',4091508,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211059',4091509,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211059',4091510,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211059',4091511,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211059',4091512,'1817','267',461213.63,461213.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211059',4091513,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211059',4091514,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211059',4091515,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211059',4091516,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211059',4091517,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','211059',4091518,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','211353',4097011,'1809','267',1802653.67,1807000.78,4347.11,708578.93,0.00,0.00,0.00,0.00,0.00),('5','89','663','211353',4097012,'1810','267',1364260.36,1368771.34,4510.98,735289.74,0.00,0.00,0.00,0.00,0.00),('5','89','662','211353',4097013,'1811','267',1789111.45,1789111.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211353',4097014,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211353',4097015,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211353',4097016,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211353',4097017,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211353',4097018,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211353',4097019,'1817','267',461213.63,461213.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211353',4097020,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211353',4097021,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211353',4097022,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211353',4097023,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211353',4097024,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','211353',4097025,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','211444',4098447,'1809','267',1807000.78,1811908.77,4907.99,800002.37,0.00,0.00,0.00,0.00,0.00),('5','89','663','211444',4098448,'1810','267',1368771.34,1374685.37,5914.03,963986.89,0.00,0.00,0.00,0.00,0.00),('5','89','662','211444',4098449,'1811','267',1789111.45,1789111.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211444',4098450,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211444',4098451,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211444',4098452,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211444',4098453,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211444',4098454,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211444',4098455,'1817','267',461213.63,461213.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211444',4098456,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211444',4098457,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211444',4098458,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211444',4098459,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211444',4098460,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','211444',4098461,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','211760',4103921,'1809','267',1811908.77,1814789.23,2880.46,469514.98,0.00,0.00,0.00,0.00,0.00),('5','89','663','211760',4103922,'1810','267',1374685.37,1377969.68,3284.31,535342.53,0.00,0.00,0.00,0.00,0.00),('5','89','662','211760',4103923,'1811','267',1789111.45,1789111.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211760',4103924,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211760',4103925,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211760',4103926,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211760',4103927,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211760',4103928,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211760',4103929,'1817','267',461213.63,461213.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211760',4103930,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211760',4103931,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211760',4103932,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211760',4103933,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211760',4103934,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','211760',4103935,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','211900',4106297,'1809','267',1814789.23,1815401.62,612.39,99819.57,0.00,0.00,0.00,0.00,0.00),('5','89','663','211900',4106298,'1810','267',1377969.68,1378284.93,315.25,51385.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','211900',4106299,'1811','267',1789111.45,1792148.24,3036.79,494996.77,0.00,0.00,0.00,0.00,0.00),('5','89','664','211900',4106300,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211900',4106301,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211900',4106302,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211900',4106303,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','211900',4106304,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','211900',4106305,'1817','267',461213.63,464866.17,3652.54,595364.02,0.00,0.00,0.00,0.00,0.00),('5','89','662','211900',4106306,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211900',4106307,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','211900',4106308,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211900',4106309,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','211900',4106310,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','211900',4106311,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','212073',4109359,'1809','267',1815401.62,1815401.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','212073',4109360,'1810','267',1378284.93,1378284.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','212073',4109361,'1811','267',1792148.24,1796692.00,4543.76,740632.88,0.00,0.00,0.00,0.00,0.00),('5','89','664','212073',4109362,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212073',4109363,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212073',4109364,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212073',4109365,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212073',4109366,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','212073',4109367,'1817','267',464866.17,469800.31,4934.14,804264.82,0.00,0.00,0.00,0.00,0.00),('5','89','662','212073',4109368,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212073',4109369,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212073',4109370,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212073',4109371,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212073',4109372,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','212073',4109373,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','212385',4114961,'1809','267',1815401.62,1816066.00,664.38,108293.94,0.00,0.00,0.00,0.00,0.00),('5','89','663','212385',4114962,'1810','267',1378284.93,1379059.43,774.50,126243.50,0.00,0.00,0.00,0.00,0.00),('5','89','662','212385',4114963,'1811','267',1796692.00,1800715.35,4023.35,655806.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','212385',4114964,'1812','267',975829.13,975829.13,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212385',4114965,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212385',4114966,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212385',4114967,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212385',4114968,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','212385',4114969,'1817','267',469800.31,473468.61,3668.30,597932.90,0.00,0.00,0.00,0.00,0.00),('5','89','662','212385',4114970,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212385',4114971,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212385',4114972,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212385',4114973,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212385',4114974,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','212385',4114975,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','212628',4119418,'1809','267',1816066.00,1817671.90,1605.90,261761.70,0.00,0.00,0.00,0.00,0.00),('5','89','663','212628',4119419,'1810','267',1379059.43,1381735.68,2676.25,436228.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','212628',4119420,'1811','267',1800715.35,1802106.57,1391.22,226768.86,0.00,0.00,0.00,0.00,0.00),('5','89','664','212628',4119421,'1812','267',975829.13,976264.68,435.55,70994.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','212628',4119422,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212628',4119423,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212628',4119424,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212628',4119425,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','212628',4119426,'1817','267',473468.61,475914.62,2446.01,398699.63,0.00,0.00,0.00,0.00,0.00),('5','89','662','212628',4119427,'1818','267',855301.85,855301.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212628',4119428,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212628',4119429,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212628',4119430,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212628',4119431,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','212628',4119432,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','212802',4122451,'1809','267',1817671.90,1820677.71,3005.81,489947.03,0.00,0.00,0.00,0.00,0.00),('5','89','663','212802',4122452,'1810','267',1381735.68,1384560.99,2825.31,460525.53,0.00,0.00,0.00,0.00,0.00),('5','89','662','212802',4122453,'1811','267',1802106.57,1804670.47,2563.90,417915.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','212802',4122454,'1812','267',976264.68,976264.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212802',4122455,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212802',4122456,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212802',4122457,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212802',4122458,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','212802',4122459,'1817','267',475914.62,476033.62,119.00,19397.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','212802',4122460,'1818','267',855301.85,855308.08,6.23,1015.49,0.00,0.00,0.00,0.00,0.00),('5','89','665','212802',4122461,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212802',4122462,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212802',4122463,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212802',4122464,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','212802',4122465,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','212923',4124436,'1809','267',1820677.71,1823882.38,3204.67,522361.21,0.00,0.00,0.00,0.00,0.00),('5','89','663','212923',4124437,'1810','267',1384560.99,1388386.08,3825.09,623489.67,0.00,0.00,0.00,0.00,0.00),('5','89','662','212923',4124438,'1811','267',1804670.47,1807321.73,2651.26,432155.38,0.00,0.00,0.00,0.00,0.00),('5','89','664','212923',4124439,'1812','267',976264.68,976264.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212923',4124440,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212923',4124441,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212923',4124442,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','212923',4124443,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','212923',4124444,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','212923',4124445,'1818','267',855308.08,855308.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212923',4124446,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','212923',4124447,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212923',4124448,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','212923',4124449,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','212923',4124450,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','213152',4128408,'1809','267',1823882.38,1827089.35,3206.97,522736.11,0.00,0.00,0.00,0.00,0.00),('5','89','663','213152',4128409,'1810','267',1388386.08,1391658.55,3272.47,533412.61,0.00,0.00,0.00,0.00,0.00),('5','89','662','213152',4128410,'1811','267',1807321.73,1809513.19,2191.46,357207.98,0.00,0.00,0.00,0.00,0.00),('5','89','664','213152',4128411,'1812','267',976264.68,976264.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213152',4128412,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213152',4128413,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213152',4128414,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213152',4128415,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','213152',4128416,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','213152',4128417,'1818','267',855308.08,855308.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','213152',4128418,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','213152',4128419,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','213152',4128420,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','213152',4128421,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','213152',4128422,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','213474',4133783,'1809','267',1827089.35,1831206.73,4117.38,671132.94,0.00,0.00,0.00,0.00,0.00),('5','89','663','213474',4133784,'1810','267',1391658.55,1395640.49,3981.94,649056.22,0.00,0.00,0.00,0.00,0.00),('5','89','662','213474',4133785,'1811','267',1809513.19,1810042.43,529.24,86266.12,0.00,0.00,0.00,0.00,0.00),('5','89','664','213474',4133786,'1812','267',976264.68,976463.40,198.72,32391.36,0.00,0.00,0.00,0.00,0.00),('5','89','664','213474',4133787,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213474',4133788,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213474',4133789,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213474',4133790,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','213474',4133791,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','213474',4133792,'1818','267',855308.08,856034.54,726.46,118412.98,0.00,0.00,0.00,0.00,0.00),('5','89','665','213474',4133793,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','213474',4133794,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','213474',4133795,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','213474',4133796,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','213474',4133797,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','213669',4137009,'1809','267',1831206.73,1834912.04,3705.31,603965.53,0.00,0.00,0.00,0.00,0.00),('5','89','663','213669',4137010,'1810','267',1395640.49,1399277.90,3637.41,592897.83,0.00,0.00,0.00,0.00,0.00),('5','89','662','213669',4137011,'1811','267',1810042.43,1810042.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213669',4137012,'1812','267',976463.40,976463.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213669',4137013,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213669',4137014,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213669',4137015,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213669',4137016,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','213669',4137017,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','213669',4137018,'1818','267',856034.54,859843.39,3808.85,620842.55,0.00,0.00,0.00,0.00,0.00),('5','89','665','213669',4137019,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','213669',4137020,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','213669',4137021,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','213669',4137022,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','213669',4137023,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','213914',4140907,'1809','267',1834912.04,1836568.33,1656.29,269975.27,0.00,0.00,0.00,0.00,0.00),('5','89','663','213914',4140908,'1810','267',1399277.90,1400613.95,1336.05,217776.15,0.00,0.00,0.00,0.00,0.00),('5','89','662','213914',4140909,'1811','267',1810042.43,1810042.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213914',4140910,'1812','267',976463.40,979120.06,2656.66,433035.58,0.00,0.00,0.00,0.00,0.00),('5','89','664','213914',4140911,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213914',4140912,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213914',4140913,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','213914',4140914,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','213914',4140915,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','213914',4140916,'1818','267',859843.39,862959.56,3116.17,507935.71,0.00,0.00,0.00,0.00,0.00),('5','89','665','213914',4140917,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','213914',4140918,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','213914',4140919,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','213914',4140920,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','213914',4140921,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','214249',4146905,'1809','267',1836568.33,1836568.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','214249',4146906,'1810','267',1400613.95,1400613.95,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214249',4146907,'1811','267',1810042.43,1810256.16,213.73,34837.99,0.00,0.00,0.00,0.00,0.00),('5','89','664','214249',4146908,'1812','267',979120.06,985806.55,6686.49,1089897.87,0.00,0.00,0.00,0.00,0.00),('5','89','664','214249',4146909,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214249',4146910,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214249',4146911,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214249',4146912,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214249',4146913,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214249',4146914,'1818','267',862959.56,864265.24,1305.68,212825.84,0.00,0.00,0.00,0.00,0.00),('5','89','665','214249',4146915,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','214249',4146916,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','214249',4146917,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','214249',4146918,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','214249',4146919,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','214336',4148314,'1809','267',1836568.33,1837685.82,1117.49,182150.87,0.00,0.00,0.00,0.00,0.00),('5','89','663','214336',4148315,'1810','267',1400613.95,1401088.33,474.38,77323.94,0.00,0.00,0.00,0.00,0.00),('5','89','662','214336',4148316,'1811','267',1810256.16,1810256.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214336',4148317,'1812','267',985806.55,992426.97,6620.42,1079128.46,0.00,0.00,0.00,0.00,0.00),('5','89','664','214336',4148318,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214336',4148319,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214336',4148320,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214336',4148321,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214336',4148322,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214336',4148323,'1818','267',864265.24,864265.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','214336',4148324,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','214336',4148325,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','214336',4148326,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','214336',4148327,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','214336',4148328,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','214605',4152778,'1809','267',1837685.82,1842564.49,4878.67,795223.21,0.00,0.00,0.00,0.00,0.00),('5','89','663','214605',4152779,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214605',4152780,'1811','267',1810256.16,1810256.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214605',4152781,'1812','267',992426.97,997426.91,4999.94,814990.22,0.00,0.00,0.00,0.00,0.00),('5','89','664','214605',4152782,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214605',4152783,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214605',4152784,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214605',4152785,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214605',4152786,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214605',4152787,'1818','267',864265.24,864265.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','214605',4152788,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','214605',4152789,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','214605',4152790,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','214605',4152791,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','214605',4152792,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','214892',4157740,'1809','267',1842564.49,1846346.80,3782.31,616516.53,0.00,0.00,0.00,0.00,0.00),('5','89','663','214892',4157741,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214892',4157742,'1811','267',1810256.16,1813217.27,2961.11,482660.93,0.00,0.00,0.00,0.00,0.00),('5','89','664','214892',4157743,'1812','267',997426.91,999425.63,1998.72,325791.36,0.00,0.00,0.00,0.00,0.00),('5','89','664','214892',4157744,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214892',4157745,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214892',4157746,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','214892',4157747,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214892',4157748,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','214892',4157749,'1818','267',864265.24,864265.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','214892',4157750,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','214892',4157751,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','214892',4157752,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','214892',4157753,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','214892',4157754,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','215039',4160104,'1809','267',1846346.80,1849501.62,3154.82,514235.66,0.00,0.00,0.00,0.00,0.00),('5','89','663','215039',4160105,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215039',4160106,'1811','267',1813217.27,1816178.02,2960.75,482602.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','215039',4160107,'1812','267',999425.63,1002267.76,2842.13,463267.19,0.00,0.00,0.00,0.00,0.00),('5','89','664','215039',4160108,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215039',4160109,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215039',4160110,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215039',4160111,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215039',4160112,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215039',4160113,'1818','267',864265.24,864265.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','215039',4160114,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','215039',4160115,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','215039',4160116,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','215039',4160117,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','215039',4160118,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','215256',4163918,'1809','267',1849501.62,1852881.35,3379.73,550895.99,0.00,0.00,0.00,0.00,0.00),('5','89','663','215256',4163919,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215256',4163920,'1811','267',1816178.02,1819480.50,3302.48,538304.24,0.00,0.00,0.00,0.00,0.00),('5','89','664','215256',4163921,'1812','267',1002267.76,1005052.42,2784.66,453899.58,0.00,0.00,0.00,0.00,0.00),('5','89','664','215256',4163922,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215256',4163923,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215256',4163924,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215256',4163925,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215256',4163926,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215256',4163927,'1818','267',864265.24,864265.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','215256',4163928,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','215256',4163929,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','215256',4163930,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','215256',4163931,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','215256',4163932,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','215606',4169883,'1809','267',1852881.35,1857474.77,4593.42,748727.46,0.00,0.00,0.00,0.00,0.00),('5','89','663','215606',4169884,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215606',4169885,'1811','267',1819480.50,1823430.09,3949.59,643783.17,0.00,0.00,0.00,0.00,0.00),('5','89','664','215606',4169886,'1812','267',1005052.42,1005913.37,860.95,140334.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','215606',4169887,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215606',4169888,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215606',4169889,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215606',4169890,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215606',4169891,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215606',4169892,'1818','267',864265.24,864265.24,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','215606',4169893,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','215606',4169894,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','215606',4169895,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','215606',4169896,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','215606',4169897,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','215892',4174928,'1809','267',1857474.77,1860889.57,3414.80,556612.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','215892',4174929,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215892',4174930,'1811','267',1823430.09,1826866.64,3436.55,560157.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','215892',4174931,'1812','267',1005913.37,1005913.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215892',4174932,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215892',4174933,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215892',4174934,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','215892',4174935,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215892',4174936,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','215892',4174937,'1818','267',864265.24,866245.42,1980.18,322769.34,0.00,0.00,0.00,0.00,0.00),('5','89','665','215892',4174938,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','215892',4174939,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','215892',4174940,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','215892',4174941,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','215892',4174942,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','216059',4177774,'1809','267',1860889.57,1863533.79,2644.22,431007.86,0.00,0.00,0.00,0.00,0.00),('5','89','663','216059',4177775,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216059',4177776,'1811','267',1826866.64,1829249.25,2382.61,388365.43,0.00,0.00,0.00,0.00,0.00),('5','89','664','216059',4177777,'1812','267',1005913.37,1005913.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216059',4177778,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216059',4177779,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216059',4177780,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216059',4177781,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216059',4177782,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216059',4177783,'1818','267',866245.42,868542.08,2296.66,374355.58,0.00,0.00,0.00,0.00,0.00),('5','89','665','216059',4177784,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','216059',4177785,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216059',4177786,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216059',4177787,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','216059',4177788,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','216162',4179331,'1809','267',1863533.79,1866269.66,2735.87,445946.81,0.00,0.00,0.00,0.00,0.00),('5','89','663','216162',4179332,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216162',4179333,'1811','267',1829249.25,1832080.42,2831.17,461480.71,0.00,0.00,0.00,0.00,0.00),('5','89','664','216162',4179334,'1812','267',1005913.37,1005913.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216162',4179335,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216162',4179336,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216162',4179337,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216162',4179338,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216162',4179339,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216162',4179340,'1818','267',868542.08,872100.85,3558.77,580079.51,0.00,0.00,0.00,0.00,0.00),('5','89','665','216162',4179341,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','216162',4179342,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216162',4179343,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216162',4179344,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','216162',4179345,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','216320',4182254,'1809','267',1866269.66,1869821.13,3551.47,578889.61,0.00,0.00,0.00,0.00,0.00),('5','89','663','216320',4182255,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216320',4182256,'1811','267',1832080.42,1835184.60,3104.18,505981.34,0.00,0.00,0.00,0.00,0.00),('5','89','664','216320',4182257,'1812','267',1005913.37,1005913.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216320',4182258,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216320',4182259,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216320',4182260,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216320',4182261,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216320',4182262,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216320',4182263,'1818','267',872100.85,875372.05,3271.20,533205.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','216320',4182264,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','216320',4182265,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216320',4182266,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216320',4182267,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','216320',4182268,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','216561',4186330,'1809','267',1869821.13,1873455.22,3634.09,592356.67,0.00,0.00,0.00,0.00,0.00),('5','89','663','216561',4186331,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216561',4186332,'1811','267',1835184.60,1837139.20,1954.60,318599.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','216561',4186333,'1812','267',1005913.37,1006346.99,433.62,70680.06,0.00,0.00,0.00,0.00,0.00),('5','89','664','216561',4186334,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216561',4186335,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216561',4186336,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216561',4186337,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216561',4186338,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216561',4186339,'1818','267',875372.05,877298.98,1926.93,314089.59,0.00,0.00,0.00,0.00,0.00),('5','89','665','216561',4186340,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','216561',4186341,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216561',4186342,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216561',4186343,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','216561',4186344,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','216778',4190419,'1809','267',1873455.22,1875665.31,2210.09,360244.67,0.00,0.00,0.00,0.00,0.00),('5','89','663','216778',4190420,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216778',4190421,'1811','267',1837139.20,1837139.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216778',4190422,'1812','267',1006346.99,1012080.33,5733.34,934534.42,0.00,0.00,0.00,0.00,0.00),('5','89','664','216778',4190423,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216778',4190424,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216778',4190425,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','216778',4190426,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216778',4190427,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','216778',4190428,'1818','267',877298.98,877298.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','216778',4190429,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','216778',4190430,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216778',4190431,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','216778',4190432,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','216778',4190433,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','217038',4194641,'1809','267',1875665.31,1875665.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','217038',4194642,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217038',4194643,'1811','267',1837139.20,1837139.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217038',4194644,'1812','267',1012080.33,1015184.77,3104.44,506023.72,0.00,0.00,0.00,0.00,0.00),('5','89','664','217038',4194645,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217038',4194646,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217038',4194647,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217038',4194648,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217038',4194649,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217038',4194650,'1818','267',877298.98,877298.98,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','217038',4194651,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','217038',4194652,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217038',4194653,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217038',4194654,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','217038',4194655,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','217295',4199574,'1809','267',1875665.31,1878066.06,2400.75,391322.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','217295',4199575,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217295',4199576,'1811','267',1837139.20,1837139.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217295',4199577,'1812','267',1015184.77,1018120.77,2936.00,478568.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217295',4199578,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217295',4199579,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217295',4199580,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217295',4199581,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217295',4199582,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217295',4199583,'1818','267',877298.98,880866.29,3567.31,581471.53,0.00,0.00,0.00,0.00,0.00),('5','89','665','217295',4199584,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','217295',4199585,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217295',4199586,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217295',4199587,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','217295',4199588,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','217657',4206027,'1809','267',1878066.06,1880549.86,2483.80,404859.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','217657',4206028,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217657',4206029,'1811','267',1837139.20,1839157.83,2018.63,329036.69,0.00,0.00,0.00,0.00,0.00),('5','89','664','217657',4206030,'1812','267',1018120.77,1020127.04,2006.27,327022.01,0.00,0.00,0.00,0.00,0.00),('5','89','664','217657',4206031,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217657',4206032,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217657',4206033,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217657',4206034,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217657',4206035,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217657',4206036,'1818','267',880866.29,882357.55,1491.26,243075.38,0.00,0.00,0.00,0.00,0.00),('5','89','665','217657',4206037,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','217657',4206038,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217657',4206039,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217657',4206040,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','217657',4206041,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','217818',4208694,'1809','267',1880549.86,1883149.17,2599.31,423687.53,0.00,0.00,0.00,0.00,0.00),('5','89','663','217818',4208695,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217818',4208696,'1811','267',1839157.83,1839647.18,489.35,79764.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','217818',4208697,'1812','267',1020127.04,1023153.38,3026.34,493293.42,0.00,0.00,0.00,0.00,0.00),('5','89','664','217818',4208698,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217818',4208699,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217818',4208700,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217818',4208701,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217818',4208702,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217818',4208703,'1818','267',882357.55,885012.46,2654.91,432750.33,0.00,0.00,0.00,0.00,0.00),('5','89','665','217818',4208704,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','217818',4208705,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217818',4208706,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217818',4208707,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','217818',4208708,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','217975',4211683,'1809','267',1883149.17,1884902.61,1753.44,285810.72,0.00,0.00,0.00,0.00,0.00),('5','89','663','217975',4211684,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217975',4211685,'1811','267',1839647.18,1842018.90,2371.72,386590.36,0.00,0.00,0.00,0.00,0.00),('5','89','664','217975',4211686,'1812','267',1023153.38,1025369.29,2215.91,361193.33,0.00,0.00,0.00,0.00,0.00),('5','89','664','217975',4211687,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217975',4211688,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217975',4211689,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','217975',4211690,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217975',4211691,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','217975',4211692,'1818','267',885012.46,886900.35,1887.89,307726.07,0.00,0.00,0.00,0.00,0.00),('5','89','665','217975',4211693,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','217975',4211694,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217975',4211695,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','217975',4211696,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','217975',4211697,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','218215',4215718,'1809','267',1884902.61,1887416.88,2514.27,409826.01,0.00,0.00,0.00,0.00,0.00),('5','89','663','218215',4215719,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218215',4215720,'1811','267',1842018.90,1843420.89,1401.99,228524.37,0.00,0.00,0.00,0.00,0.00),('5','89','664','218215',4215721,'1812','267',1025369.29,1027785.22,2415.93,393796.59,0.00,0.00,0.00,0.00,0.00),('5','89','664','218215',4215722,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218215',4215723,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218215',4215724,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218215',4215725,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218215',4215726,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218215',4215727,'1818','267',886900.35,889447.28,2546.93,415149.59,0.00,0.00,0.00,0.00,0.00),('5','89','665','218215',4215728,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','218215',4215729,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','218215',4215730,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','218215',4215731,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','218215',4215732,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','218441',4219776,'1809','267',1887416.88,1890163.24,2746.36,447656.68,0.00,0.00,0.00,0.00,0.00),('5','89','663','218441',4219777,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218441',4219778,'1811','267',1843420.89,1845115.52,1694.63,276224.69,0.00,0.00,0.00,0.00,0.00),('5','89','664','218441',4219779,'1812','267',1027785.22,1030014.90,2229.68,363437.84,0.00,0.00,0.00,0.00,0.00),('5','89','664','218441',4219780,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218441',4219781,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218441',4219782,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218441',4219783,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218441',4219784,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218441',4219785,'1818','267',889447.28,892204.59,2757.31,449441.53,0.00,0.00,0.00,0.00,0.00),('5','89','665','218441',4219786,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','218441',4219787,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','218441',4219788,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','218441',4219789,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','218441',4219790,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','218669',4223927,'1809','267',1890163.24,1890550.60,387.36,63139.68,0.00,0.00,0.00,0.00,0.00),('5','89','663','218669',4223928,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218669',4223929,'1811','267',1845115.52,1848872.69,3757.17,612418.71,0.00,0.00,0.00,0.00,0.00),('5','89','664','218669',4223930,'1812','267',1030014.90,1030073.61,58.71,9569.73,0.00,0.00,0.00,0.00,0.00),('5','89','664','218669',4223931,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218669',4223932,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218669',4223933,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218669',4223934,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218669',4223935,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218669',4223936,'1818','267',892204.59,895592.72,3388.13,552265.19,0.00,0.00,0.00,0.00,0.00),('5','89','665','218669',4223937,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','218669',4223938,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','218669',4223939,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','218669',4223940,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','218669',4223941,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','218924',4228177,'1809','267',1890550.60,1890550.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','218924',4228178,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218924',4228179,'1811','267',1848872.69,1848872.69,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218924',4228180,'1812','267',1030073.61,1030073.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218924',4228181,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218924',4228182,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218924',4228183,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','218924',4228184,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218924',4228185,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','218924',4228186,'1818','267',895592.72,895592.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','218924',4228187,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','218924',4228188,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','218924',4228189,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','218924',4228190,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','218924',4228191,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','219310',4235078,'1809','267',1890550.60,1890550.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','219310',4235079,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219310',4235080,'1811','267',1848872.69,1852089.05,3216.36,524266.68,0.00,0.00,0.00,0.00,0.00),('5','89','664','219310',4235081,'1812','267',1030073.61,1030073.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219310',4235082,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219310',4235083,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219310',4235084,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219310',4235085,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219310',4235086,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219310',4235087,'1818','267',895592.72,898856.66,3263.94,532022.22,0.00,0.00,0.00,0.00,0.00),('5','89','665','219310',4235088,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','219310',4235089,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','219310',4235090,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','219310',4235091,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','219310',4235092,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','219358',4235602,'1809','267',1890550.60,1890550.60,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','219358',4235603,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219358',4235604,'1811','267',1852089.05,1856800.13,4711.08,767906.04,0.00,0.00,0.00,0.00,0.00),('5','89','664','219358',4235605,'1812','267',1030073.61,1030073.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219358',4235606,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219358',4235607,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219358',4235608,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219358',4235609,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219358',4235610,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219358',4235611,'1818','267',898856.66,903287.74,4431.08,722266.04,0.00,0.00,0.00,0.00,0.00),('5','89','665','219358',4235612,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','219358',4235613,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','219358',4235614,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','219358',4235615,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','219358',4235616,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','219586',4239719,'1809','267',1890550.60,1892681.96,2131.36,347411.68,0.00,0.00,0.00,0.00,0.00),('5','89','663','219586',4239720,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219586',4239721,'1811','267',1856800.13,1860138.55,3338.42,544162.46,0.00,0.00,0.00,0.00,0.00),('5','89','664','219586',4239722,'1812','267',1030073.61,1030073.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219586',4239723,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219586',4239724,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219586',4239725,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219586',4239726,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219586',4239727,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219586',4239728,'1818','267',903287.74,906697.52,3409.78,555794.14,0.00,0.00,0.00,0.00,0.00),('5','89','665','219586',4239729,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','219586',4239730,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','219586',4239731,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','219586',4239732,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','219586',4239733,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','219854',4244304,'1809','267',1892681.96,1892681.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','219854',4244305,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219854',4244306,'1811','267',1860138.55,1863552.29,3413.74,556439.62,0.00,0.00,0.00,0.00,0.00),('5','89','664','219854',4244307,'1812','267',1030073.61,1030073.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219854',4244308,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219854',4244309,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219854',4244310,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','219854',4244311,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219854',4244312,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','219854',4244313,'1818','267',906697.52,910256.24,3558.72,580071.36,0.00,0.00,0.00,0.00,0.00),('5','89','665','219854',4244314,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','219854',4244315,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','219854',4244316,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','219854',4244317,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','219854',4244318,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','220061',4248081,'1809','267',1892681.96,1892681.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','220061',4248082,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220061',4248083,'1811','267',1863552.29,1867279.29,3727.00,607501.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220061',4248084,'1812','267',1030073.61,1030073.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220061',4248085,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220061',4248086,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220061',4248087,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220061',4248088,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220061',4248089,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220061',4248090,'1818','267',910256.24,913987.93,3731.69,608265.47,0.00,0.00,0.00,0.00,0.00),('5','89','665','220061',4248091,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','220061',4248092,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220061',4248093,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220061',4248094,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','220061',4248095,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','220287',4251996,'1809','267',1892681.96,1894723.92,2041.96,332839.48,0.00,0.00,0.00,0.00,0.00),('5','89','663','220287',4251997,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220287',4251998,'1811','267',1867279.29,1869710.31,2431.02,396256.26,0.00,0.00,0.00,0.00,0.00),('5','89','664','220287',4251999,'1812','267',1030073.61,1030737.40,663.79,108197.77,0.00,0.00,0.00,0.00,0.00),('5','89','664','220287',4252000,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220287',4252001,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220287',4252002,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220287',4252003,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220287',4252004,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220287',4252005,'1818','267',913987.93,916849.86,2861.93,466494.59,0.00,0.00,0.00,0.00,0.00),('5','89','665','220287',4252006,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','220287',4252007,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220287',4252008,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220287',4252009,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','220287',4252010,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','220527',4256401,'1809','267',1894723.92,1897213.71,2489.79,405835.77,0.00,0.00,0.00,0.00,0.00),('5','89','663','220527',4256402,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220527',4256403,'1811','267',1869710.31,1871094.67,1384.36,225650.68,0.00,0.00,0.00,0.00,0.00),('5','89','664','220527',4256404,'1812','267',1030737.40,1032534.22,1796.82,292881.66,0.00,0.00,0.00,0.00,0.00),('5','89','664','220527',4256405,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220527',4256406,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220527',4256407,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220527',4256408,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220527',4256409,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220527',4256410,'1818','267',916849.86,919364.07,2514.21,409816.23,0.00,0.00,0.00,0.00,0.00),('5','89','665','220527',4256411,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','220527',4256412,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220527',4256413,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220527',4256414,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','220527',4256415,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','220693',4259343,'1809','267',1897213.71,1899364.81,2151.10,350629.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','220693',4259344,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220693',4259345,'1811','267',1871094.67,1871738.81,644.14,104994.82,0.00,0.00,0.00,0.00,0.00),('5','89','664','220693',4259346,'1812','267',1032534.22,1034467.51,1933.29,315126.27,0.00,0.00,0.00,0.00,0.00),('5','89','664','220693',4259347,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220693',4259348,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220693',4259349,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220693',4259350,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220693',4259351,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220693',4259352,'1818','267',919364.07,921823.05,2458.98,400813.74,0.00,0.00,0.00,0.00,0.00),('5','89','665','220693',4259353,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','220693',4259354,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220693',4259355,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220693',4259356,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','220693',4259357,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','220956',4263881,'1809','267',1899364.81,1902735.74,3370.93,549461.59,0.00,0.00,0.00,0.00,0.00),('5','89','663','220956',4263882,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220956',4263883,'1811','267',1871738.81,1871738.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220956',4263884,'1812','267',1034467.51,1037568.39,3100.88,505443.44,0.00,0.00,0.00,0.00,0.00),('5','89','664','220956',4263885,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220956',4263886,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220956',4263887,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','220956',4263888,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220956',4263889,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','220956',4263890,'1818','267',921823.05,925100.37,3277.32,534203.16,0.00,0.00,0.00,0.00,0.00),('5','89','665','220956',4263891,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','220956',4263892,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220956',4263893,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','220956',4263894,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','220956',4263895,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','221161',4267528,'1809','267',1902735.74,1905340.93,2605.19,424645.97,0.00,0.00,0.00,0.00,0.00),('5','89','663','221161',4267529,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221161',4267530,'1811','267',1871738.81,1871738.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221161',4267531,'1812','267',1037568.39,1040465.63,2897.24,472250.12,0.00,0.00,0.00,0.00,0.00),('5','89','664','221161',4267532,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221161',4267533,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221161',4267534,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221161',4267535,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221161',4267536,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221161',4267537,'1818','267',925100.37,928474.74,3374.37,550022.31,0.00,0.00,0.00,0.00,0.00),('5','89','665','221161',4267538,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','221161',4267539,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','221161',4267540,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','221161',4267541,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','221161',4267542,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','221422',4272227,'1809','267',1905340.93,1908098.52,2757.59,449487.17,0.00,0.00,0.00,0.00,0.00),('5','89','663','221422',4272228,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221422',4272229,'1811','267',1871738.81,1871738.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221422',4272230,'1812','267',1040465.63,1043156.03,2690.40,438535.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','221422',4272231,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221422',4272232,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221422',4272233,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221422',4272234,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221422',4272235,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221422',4272236,'1818','267',928474.74,931658.97,3184.23,519029.49,0.00,0.00,0.00,0.00,0.00),('5','89','665','221422',4272237,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','221422',4272238,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','221422',4272239,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','221422',4272240,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','221422',4272241,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','221634',4276207,'1809','267',1908098.52,1911125.22,3026.70,493352.10,0.00,0.00,0.00,0.00,0.00),('5','89','663','221634',4276208,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221634',4276209,'1811','267',1871738.81,1871738.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221634',4276210,'1812','267',1043156.03,1046126.74,2970.71,484225.73,0.00,0.00,0.00,0.00,0.00),('5','89','664','221634',4276211,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221634',4276212,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221634',4276213,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221634',4276214,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221634',4276215,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221634',4276216,'1818','267',931658.97,934819.49,3160.52,515164.76,0.00,0.00,0.00,0.00,0.00),('5','89','665','221634',4276217,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','221634',4276218,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','221634',4276219,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','221634',4276220,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','221634',4276221,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','221892',4280692,'1809','267',1911125.22,1915078.27,3953.05,644347.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','221892',4280693,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221892',4280694,'1811','267',1871738.81,1871738.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221892',4280695,'1812','267',1046126.74,1048480.57,2353.83,383674.29,0.00,0.00,0.00,0.00,0.00),('5','89','664','221892',4280696,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221892',4280697,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221892',4280698,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','221892',4280699,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221892',4280700,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','221892',4280701,'1818','267',934819.49,938699.14,3879.65,632382.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','221892',4280702,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','221892',4280703,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','221892',4280704,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','221892',4280705,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','221892',4280706,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','222144',4285326,'1809','267',1915078.27,1917390.03,2311.76,376816.88,0.00,0.00,0.00,0.00,0.00),('5','89','663','222144',4285327,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222144',4285328,'1811','267',1871738.81,1871738.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222144',4285329,'1812','267',1048480.57,1050011.01,1530.44,249461.72,0.00,0.00,0.00,0.00,0.00),('5','89','664','222144',4285330,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222144',4285331,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222144',4285332,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222144',4285333,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222144',4285334,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222144',4285335,'1818','267',938699.14,940685.67,1986.53,323804.39,0.00,0.00,0.00,0.00,0.00),('5','89','665','222144',4285336,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','222144',4285337,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222144',4285338,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222144',4285339,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','222144',4285340,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','222284',4287625,'1809','267',1917390.03,1920238.61,2848.58,464318.54,0.00,0.00,0.00,0.00,0.00),('5','89','663','222284',4287626,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222284',4287627,'1811','267',1871738.81,1871738.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222284',4287628,'1812','267',1050011.01,1052819.40,2808.39,457767.57,0.00,0.00,0.00,0.00,0.00),('5','89','664','222284',4287629,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222284',4287630,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222284',4287631,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222284',4287632,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222284',4287633,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222284',4287634,'1818','267',940685.67,943137.04,2451.37,399573.31,0.00,0.00,0.00,0.00,0.00),('5','89','665','222284',4287635,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','222284',4287636,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222284',4287637,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222284',4287638,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','222284',4287639,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','222531',4291826,'1809','267',1920238.61,1920343.35,104.74,17072.62,0.00,0.00,0.00,0.00,0.00),('5','89','663','222531',4291827,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222531',4291828,'1811','267',1871738.81,1871943.78,204.97,33410.11,0.00,0.00,0.00,0.00,0.00),('5','89','664','222531',4291829,'1812','267',1052819.40,1058836.67,6017.27,980815.01,0.00,0.00,0.00,0.00,0.00),('5','89','664','222531',4291830,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222531',4291831,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222531',4291832,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222531',4291833,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222531',4291834,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222531',4291835,'1818','267',943137.04,945220.97,2083.93,339680.59,0.00,0.00,0.00,0.00,0.00),('5','89','665','222531',4291836,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','222531',4291837,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222531',4291838,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222531',4291839,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','222531',4291840,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','222878',4298471,'1809','267',1920343.35,1920343.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','222878',4298472,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222878',4298473,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222878',4298474,'1812','267',1058836.67,1065942.78,7106.11,1158295.93,0.00,0.00,0.00,0.00,0.00),('5','89','664','222878',4298475,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222878',4298476,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222878',4298477,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222878',4298478,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222878',4298479,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222878',4298480,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','222878',4298481,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','222878',4298482,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222878',4298483,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222878',4298484,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','222878',4298485,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','222998',4300716,'1809','267',1920343.35,1920343.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','222998',4300717,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222998',4300718,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222998',4300719,'1812','267',1065942.78,1072837.85,6895.07,1123896.41,0.00,0.00,0.00,0.00,0.00),('5','89','664','222998',4300720,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222998',4300721,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222998',4300722,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','222998',4300723,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222998',4300724,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','222998',4300725,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','222998',4300726,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','222998',4300727,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222998',4300728,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','222998',4300729,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','222998',4300730,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','223349',4306364,'1809','267',1920343.35,1920343.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','223349',4306365,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223349',4306366,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223349',4306367,'1812','267',1072837.85,1076041.33,3203.48,522167.24,0.00,0.00,0.00,0.00,0.00),('5','89','664','223349',4306368,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223349',4306369,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223349',4306370,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223349',4306371,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223349',4306372,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223349',4306373,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','223349',4306374,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','223349',4306375,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','223349',4306376,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','223349',4306377,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','223349',4306378,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','223532',4309836,'1809','267',1920343.35,1920343.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','223532',4309837,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223532',4309838,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223532',4309839,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223532',4309840,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223532',4309841,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223532',4309842,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223532',4309843,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223532',4309844,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223532',4309845,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','223532',4309846,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','223532',4309847,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','223532',4309848,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','223532',4309849,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','223532',4309850,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','223709',4313129,'1809','267',1920343.35,1920343.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','223709',4313130,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223709',4313131,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223709',4313132,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223709',4313133,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223709',4313134,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223709',4313135,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','223709',4313136,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223709',4313137,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','223709',4313138,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','223709',4313139,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','223709',4313140,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','223709',4313141,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','223709',4313142,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','223709',4313143,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','224058',4319652,'1809','267',1920343.35,1920343.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','224058',4319653,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224058',4319654,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224058',4319655,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224058',4319656,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224058',4319657,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224058',4319658,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224058',4319659,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224058',4319660,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224058',4319661,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224058',4319662,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224058',4319663,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224058',4319664,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224058',4319665,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','224058',4319666,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','224263',4323372,'1809','267',1920343.35,1920343.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','224263',4323373,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224263',4323374,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224263',4323375,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224263',4323376,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224263',4323377,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224263',4323378,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224263',4323379,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224263',4323380,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224263',4323381,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224263',4323382,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224263',4323383,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224263',4323384,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224263',4323385,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','224263',4323386,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','224390',4325323,'1809','267',1920343.35,1920343.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','224390',4325324,'1810','267',1401088.33,1401088.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224390',4325325,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224390',4325326,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224390',4325327,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224390',4325328,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224390',4325329,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224390',4325330,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224390',4325331,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224390',4325332,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224390',4325333,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224390',4325334,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224390',4325335,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224390',4325336,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','224390',4325337,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','224610',4329168,'1809','267',1920343.35,1924728.48,4385.13,714776.19,0.00,0.00,0.00,0.00,0.00),('5','89','663','224610',4329169,'1810','267',1401088.33,1404085.29,2996.96,488504.48,0.00,0.00,0.00,0.00,0.00),('5','89','662','224610',4329170,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224610',4329171,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224610',4329172,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224610',4329173,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224610',4329174,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224610',4329175,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224610',4329176,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224610',4329177,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224610',4329178,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224610',4329179,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224610',4329180,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224610',4329181,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','224610',4329182,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','224854',4333441,'1809','267',1924728.48,1928373.85,3645.37,594195.31,0.00,0.00,0.00,0.00,0.00),('5','89','663','224854',4333442,'1810','267',1404085.29,1407971.86,3886.57,633510.91,0.00,0.00,0.00,0.00,0.00),('5','89','662','224854',4333443,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224854',4333444,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224854',4333445,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224854',4333446,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224854',4333447,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','224854',4333448,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224854',4333449,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','224854',4333450,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224854',4333451,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','224854',4333452,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224854',4333453,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','224854',4333454,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','224854',4333455,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','225078',4337463,'1809','267',1928373.85,1932290.28,3916.43,638378.09,0.00,0.00,0.00,0.00,0.00),('5','89','663','225078',4337464,'1810','267',1407971.86,1411966.58,3994.72,651139.36,0.00,0.00,0.00,0.00,0.00),('5','89','662','225078',4337465,'1811','267',1871943.78,1871943.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225078',4337466,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225078',4337467,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225078',4337468,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225078',4337469,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225078',4337470,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225078',4337471,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225078',4337472,'1818','267',945220.97,945220.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','225078',4337473,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','225078',4337474,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','225078',4337475,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','225078',4337476,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','225078',4337477,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','225332',4342048,'1809','267',1932290.28,1935654.98,3364.70,548446.10,0.00,0.00,0.00,0.00,0.00),('5','89','663','225332',4342049,'1810','267',1411966.58,1415616.72,3650.14,594972.82,0.00,0.00,0.00,0.00,0.00),('5','89','662','225332',4342050,'1811','267',1871943.78,1871961.81,18.03,2938.89,0.00,0.00,0.00,0.00,0.00),('5','89','664','225332',4342051,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225332',4342052,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225332',4342053,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225332',4342054,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225332',4342055,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225332',4342056,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225332',4342057,'1818','267',945220.97,946366.80,1145.83,186770.29,0.00,0.00,0.00,0.00,0.00),('5','89','665','225332',4342058,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','225332',4342059,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','225332',4342060,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','225332',4342061,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','225332',4342062,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','225554',4346228,'1809','267',1935654.98,1935697.29,42.31,6896.53,0.00,0.00,0.00,0.00,0.00),('5','89','663','225554',4346229,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225554',4346230,'1811','267',1871961.81,1874499.17,2537.36,413589.68,0.00,0.00,0.00,0.00,0.00),('5','89','664','225554',4346231,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225554',4346232,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225554',4346233,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225554',4346234,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225554',4346235,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225554',4346236,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225554',4346237,'1818','267',946366.80,949302.21,2935.41,478471.83,0.00,0.00,0.00,0.00,0.00),('5','89','665','225554',4346238,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','225554',4346239,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','225554',4346240,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','225554',4346241,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','225554',4346242,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','225811',4350542,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','225811',4350543,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225811',4350544,'1811','267',1874499.17,1878743.56,4244.39,691835.57,0.00,0.00,0.00,0.00,0.00),('5','89','664','225811',4350545,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225811',4350546,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225811',4350547,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225811',4350548,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','225811',4350549,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225811',4350550,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','225811',4350551,'1818','267',949302.21,954273.16,4970.95,810264.85,0.00,0.00,0.00,0.00,0.00),('5','89','665','225811',4350552,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','225811',4350553,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','225811',4350554,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','225811',4350555,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','225811',4350556,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','226107',4355826,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','226107',4355827,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226107',4355828,'1811','267',1878743.56,1882440.42,3696.86,602588.18,0.00,0.00,0.00,0.00,0.00),('5','89','664','226107',4355829,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226107',4355830,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226107',4355831,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226107',4355832,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226107',4355833,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226107',4355834,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226107',4355835,'1818','267',954273.16,958215.59,3942.43,642616.09,0.00,0.00,0.00,0.00,0.00),('5','89','665','226107',4355836,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','226107',4355837,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','226107',4355838,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','226107',4355839,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','226107',4355840,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','226246',4358527,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','226246',4358528,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226246',4358529,'1811','267',1882440.42,1886358.15,3917.73,638589.99,0.00,0.00,0.00,0.00,0.00),('5','89','664','226246',4358530,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226246',4358531,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226246',4358532,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226246',4358533,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226246',4358534,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226246',4358535,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226246',4358536,'1818','267',958215.59,962568.91,4353.32,709591.16,0.00,0.00,0.00,0.00,0.00),('5','89','665','226246',4358537,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','226246',4358538,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','226246',4358539,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','226246',4358540,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','226246',4358541,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','226599',4364795,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','226599',4364796,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226599',4364797,'1811','267',1886358.15,1890738.18,4380.03,713944.89,0.00,0.00,0.00,0.00,0.00),('5','89','664','226599',4364798,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226599',4364799,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226599',4364800,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226599',4364801,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226599',4364802,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226599',4364803,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226599',4364804,'1818','267',962568.91,966937.61,4368.70,712098.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','226599',4364805,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','226599',4364806,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','226599',4364807,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','226599',4364808,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','226599',4364809,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','226832',4368947,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','226832',4368948,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226832',4368949,'1811','267',1890738.18,1892809.04,2070.86,337550.18,0.00,0.00,0.00,0.00,0.00),('5','89','664','226832',4368950,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226832',4368951,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226832',4368952,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226832',4368953,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','226832',4368954,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226832',4368955,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','226832',4368956,'1818','267',966937.61,969023.38,2085.77,339980.51,0.00,0.00,0.00,0.00,0.00),('5','89','665','226832',4368957,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','226832',4368958,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','226832',4368959,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','226832',4368960,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','226832',4368961,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227169',4375125,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227169',4375126,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227169',4375127,'1811','267',1892809.04,1892809.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227169',4375128,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227169',4375129,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227169',4375130,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227169',4375131,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227169',4375132,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227169',4375133,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227169',4375134,'1818','267',969023.38,969023.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227169',4375135,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227169',4375136,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227169',4375137,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227169',4375138,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','227169',4375139,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227357',4378458,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227357',4378459,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227357',4378460,'1811','267',1892809.04,1892809.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227357',4378461,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227357',4378462,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227357',4378463,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227357',4378464,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227357',4378465,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227357',4378466,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227357',4378467,'1818','267',969023.38,969023.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227357',4378468,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227357',4378469,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227357',4378470,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227357',4378471,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','227357',4378472,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227592',4382432,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227592',4382433,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227592',4382434,'1811','267',1892809.04,1892809.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227592',4382435,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227592',4382436,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227592',4382437,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227592',4382438,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227592',4382439,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227592',4382440,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227592',4382441,'1818','267',969023.38,969023.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227592',4382442,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227592',4382443,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227592',4382444,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227592',4382445,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','227592',4382446,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227831',4386732,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227831',4386733,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227831',4386734,'1811','267',1892809.04,1892809.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227831',4386735,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227831',4386736,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227831',4386737,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227831',4386738,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227831',4386739,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227831',4386740,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227831',4386741,'1818','267',969023.38,969023.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227831',4386742,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227831',4386743,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227831',4386744,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227831',4386745,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','227831',4386746,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227943',4388619,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','227943',4388620,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227943',4388621,'1811','267',1892809.04,1892809.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227943',4388622,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227943',4388623,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227943',4388624,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227943',4388625,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','227943',4388626,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227943',4388627,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','227943',4388628,'1818','267',969023.38,969023.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227943',4388629,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','227943',4388630,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227943',4388631,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','227943',4388632,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','227943',4388633,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','229352',4415397,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','229352',4415398,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','229352',4415399,'1811','267',1892809.04,1892809.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','229352',4415400,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','229352',4415401,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','229352',4415402,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','229352',4415403,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','229352',4415404,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','229352',4415405,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','229352',4415406,'1818','267',969023.38,969023.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','229352',4415407,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','229352',4415408,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','229352',4415409,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','229352',4415410,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','229352',4415411,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232493',4471874,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232493',4471875,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232493',4471876,'1811','267',1892809.04,1895848.67,3039.63,495459.69,0.00,0.00,0.00,0.00,0.00),('5','89','664','232493',4471877,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232493',4471878,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232493',4471879,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232493',4471880,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232493',4471881,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232493',4471882,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232493',4471883,'1818','267',969023.38,972032.75,3009.37,490527.31,0.00,0.00,0.00,0.00,0.00),('5','89','665','232493',4471884,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232493',4471885,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232493',4471886,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232493',4471887,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232493',4471888,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232496',4471921,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232496',4471922,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232496',4471923,'1811','267',1895848.67,1899032.57,3183.90,518975.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','232496',4471924,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232496',4471925,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232496',4471926,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232496',4471927,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232496',4471928,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232496',4471929,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232496',4471930,'1818','267',972032.75,975569.45,3536.70,576482.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','232496',4471931,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232496',4471932,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232496',4471933,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232496',4471934,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232496',4471935,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232786',4477534,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232786',4477535,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232786',4477536,'1811','267',1899032.57,1903610.03,4577.46,746125.98,0.00,0.00,0.00,0.00,0.00),('5','89','664','232786',4477537,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232786',4477538,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232786',4477539,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232786',4477540,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232786',4477541,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232786',4477542,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232786',4477543,'1818','267',975569.45,979816.36,4246.91,692246.33,0.00,0.00,0.00,0.00,0.00),('5','89','665','232786',4477544,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232786',4477545,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232786',4477546,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232786',4477547,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232786',4477548,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232795',4477643,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232795',4477644,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232795',4477645,'1811','267',1903610.03,1907380.03,3770.00,614510.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232795',4477646,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232795',4477647,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232795',4477648,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232795',4477649,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232795',4477650,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232795',4477651,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232795',4477652,'1818','267',979816.36,983105.91,3289.55,536196.65,0.00,0.00,0.00,0.00,0.00),('5','89','665','232795',4477653,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232795',4477654,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232795',4477655,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232795',4477656,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232795',4477657,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232799',4477705,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232799',4477706,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232799',4477707,'1811','267',1907380.03,1907380.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232799',4477708,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232799',4477709,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232799',4477710,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232799',4477711,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232799',4477712,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232799',4477713,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232799',4477714,'1818','267',983105.91,983105.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232799',4477715,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232799',4477716,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232799',4477717,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232799',4477718,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232799',4477719,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232802',4477732,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232802',4477733,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232802',4477734,'1811','267',1907380.03,1911164.53,3784.50,616873.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','232802',4477735,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232802',4477736,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232802',4477737,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232802',4477738,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232802',4477739,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232802',4477740,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232802',4477741,'1818','267',983105.91,986726.13,3620.22,590095.86,0.00,0.00,0.00,0.00,0.00),('5','89','665','232802',4477742,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232802',4477743,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232802',4477744,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232802',4477745,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232802',4477746,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232805',4477759,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232805',4477760,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232805',4477761,'1811','267',1911164.53,1912976.20,1811.67,295302.21,0.00,0.00,0.00,0.00,0.00),('5','89','664','232805',4477762,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232805',4477763,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232805',4477764,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232805',4477765,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232805',4477766,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232805',4477767,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232805',4477768,'1818','267',986726.13,988217.57,1491.44,243104.72,0.00,0.00,0.00,0.00,0.00),('5','89','665','232805',4477769,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232805',4477770,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232805',4477771,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232805',4477772,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232805',4477773,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232925',4479564,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232925',4479565,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232925',4479566,'1811','267',1912976.20,1916691.71,3715.51,605628.13,0.00,0.00,0.00,0.00,0.00),('5','89','664','232925',4479567,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232925',4479568,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232925',4479569,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232925',4479570,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232925',4479571,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232925',4479572,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232925',4479573,'1818','267',988217.57,992034.41,3816.84,622144.92,0.00,0.00,0.00,0.00,0.00),('5','89','665','232925',4479574,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232925',4479575,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232925',4479576,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232925',4479577,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232925',4479578,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232933',4479692,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232933',4479693,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232933',4479694,'1811','267',1916691.71,1921126.60,4434.89,722887.07,0.00,0.00,0.00,0.00,0.00),('5','89','664','232933',4479695,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232933',4479696,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232933',4479697,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232933',4479698,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232933',4479699,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232933',4479700,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232933',4479701,'1818','267',992034.41,996276.68,4242.27,691490.01,0.00,0.00,0.00,0.00,0.00),('5','89','665','232933',4479702,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232933',4479703,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232933',4479704,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232933',4479705,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232933',4479706,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232984',4480730,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232984',4480731,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232984',4480732,'1811','267',1921126.60,1925432.40,4305.80,701845.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','232984',4480733,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232984',4480734,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232984',4480735,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232984',4480736,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232984',4480737,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232984',4480738,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232984',4480739,'1818','267',996276.68,1000544.60,4267.92,695670.96,0.00,0.00,0.00,0.00,0.00),('5','89','665','232984',4480740,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232984',4480741,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232984',4480742,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232984',4480743,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232984',4480744,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232989',4480798,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232989',4480799,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232989',4480800,'1811','267',1925432.40,1929226.07,3793.67,618368.21,0.00,0.00,0.00,0.00,0.00),('5','89','664','232989',4480801,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232989',4480802,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232989',4480803,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232989',4480804,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232989',4480805,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232989',4480806,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232989',4480807,'1818','267',1000544.60,1004369.65,3825.05,623483.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','232989',4480808,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232989',4480809,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232989',4480810,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232989',4480811,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232989',4480812,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232995',4480874,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','232995',4480875,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232995',4480876,'1811','267',1929226.07,1933348.05,4121.98,671882.74,0.00,0.00,0.00,0.00,0.00),('5','89','664','232995',4480877,'1812','267',1076041.33,1076041.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232995',4480878,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232995',4480879,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232995',4480880,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','232995',4480881,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232995',4480882,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','232995',4480883,'1818','267',1004369.65,1008604.25,4234.60,690239.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','232995',4480884,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','232995',4480885,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232995',4480886,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','232995',4480887,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','232995',4480888,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233022',4481472,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233022',4481473,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233022',4481474,'1811','267',1933348.05,1934009.69,661.64,107847.32,0.00,0.00,0.00,0.00,0.00),('5','89','664','233022',4481475,'1812','267',1076041.33,1080526.24,4484.91,731040.33,0.00,0.00,0.00,0.00,0.00),('5','89','664','233022',4481476,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233022',4481477,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233022',4481478,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233022',4481479,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233022',4481480,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233022',4481481,'1818','267',1008604.25,1011236.82,2632.57,429108.91,0.00,0.00,0.00,0.00,0.00),('5','89','665','233022',4481482,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233022',4481483,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233022',4481484,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233022',4481485,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233022',4481486,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233024',4481492,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233024',4481493,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233024',4481494,'1811','267',1934009.69,1934025.23,15.54,2533.02,0.00,0.00,0.00,0.00,0.00),('5','89','664','233024',4481495,'1812','267',1080526.24,1086387.54,5861.30,955391.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','233024',4481496,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233024',4481497,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233024',4481498,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233024',4481499,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233024',4481500,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233024',4481501,'1818','267',1011236.82,1011236.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233024',4481502,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233024',4481503,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233024',4481504,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233024',4481505,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233024',4481506,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233194',4484444,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233194',4484445,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233194',4484446,'1811','267',1934025.23,1934025.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233194',4484447,'1812','267',1086387.54,1086387.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233194',4484448,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233194',4484449,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233194',4484450,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233194',4484451,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233194',4484452,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233194',4484453,'1818','267',1011236.82,1011236.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233194',4484454,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233194',4484455,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233194',4484456,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233194',4484457,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233194',4484458,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233195',4484459,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233195',4484460,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233195',4484461,'1811','267',1934025.23,1935142.99,1117.76,182194.88,0.00,0.00,0.00,0.00,0.00),('5','89','664','233195',4484462,'1812','267',1086387.54,1090124.64,3737.10,609147.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','233195',4484463,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233195',4484464,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233195',4484465,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233195',4484466,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233195',4484467,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233195',4484468,'1818','267',1011236.82,1012227.98,991.16,161559.08,0.00,0.00,0.00,0.00,0.00),('5','89','665','233195',4484469,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233195',4484470,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233195',4484471,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233195',4484472,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233195',4484473,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233197',4484504,'1809','267',1935697.29,1935697.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233197',4484505,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233197',4484506,'1811','267',1935142.99,1939125.29,3982.30,649114.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','233197',4484507,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233197',4484508,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233197',4484509,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233197',4484510,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233197',4484511,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233197',4484512,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233197',4484513,'1818','267',1012227.98,1016425.24,4197.26,684153.38,0.00,0.00,0.00,0.00,0.00),('5','89','665','233197',4484514,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233197',4484515,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233197',4484516,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233197',4484517,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233197',4484518,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233201',4484558,'1809','267',1935697.29,1937775.76,2078.47,338790.61,0.00,0.00,0.00,0.00,0.00),('5','89','663','233201',4484559,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233201',4484560,'1811','267',1939125.29,1941697.08,2571.79,419201.77,0.00,0.00,0.00,0.00,0.00),('5','89','664','233201',4484561,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233201',4484562,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233201',4484563,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233201',4484564,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233201',4484565,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233201',4484566,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233201',4484567,'1818','267',1016425.24,1019419.81,2994.57,488114.91,0.00,0.00,0.00,0.00,0.00),('5','89','665','233201',4484568,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233201',4484569,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233201',4484570,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233201',4484571,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233201',4484572,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233217',4484844,'1809','267',1937775.76,1940364.41,2588.65,421949.95,0.00,0.00,0.00,0.00,0.00),('5','89','663','233217',4484845,'1810','267',1415616.72,1415616.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233217',4484846,'1811','267',1941697.08,1944419.53,2722.45,443759.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','233217',4484847,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233217',4484848,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233217',4484849,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233217',4484850,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233217',4484851,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233217',4484852,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233217',4484853,'1818','267',1019419.81,1022958.19,3538.38,576755.94,0.00,0.00,0.00,0.00,0.00),('5','89','665','233217',4484854,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233217',4484855,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233217',4484856,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233217',4484857,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233217',4484858,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233341',4487280,'1809','267',1940364.41,1943626.64,3262.23,531743.49,0.00,0.00,0.00,0.00,0.00),('5','89','663','233341',4487281,'1810','267',1415616.72,1417519.50,1902.78,310153.14,0.00,0.00,0.00,0.00,0.00),('5','89','662','233341',4487282,'1811','267',1944419.53,1946503.77,2084.24,339731.12,0.00,0.00,0.00,0.00,0.00),('5','89','664','233341',4487283,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233341',4487284,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233341',4487285,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233341',4487286,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233341',4487287,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233341',4487288,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233341',4487289,'1818','267',1022958.19,1025171.87,2213.68,360829.84,0.00,0.00,0.00,0.00,0.00),('5','89','665','233341',4487290,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233341',4487291,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233341',4487292,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233341',4487293,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233341',4487294,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233389',4488007,'1809','267',1943626.64,1948198.80,4572.16,745262.08,0.00,0.00,0.00,0.00,0.00),('5','89','663','233389',4488008,'1810','267',1417519.50,1421132.45,3612.95,588910.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','233389',4488009,'1811','267',1946503.77,1946503.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233389',4488010,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233389',4488011,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233389',4488012,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233389',4488013,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233389',4488014,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233389',4488015,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233389',4488016,'1818','267',1025171.87,1026629.89,1458.02,237657.26,0.00,0.00,0.00,0.00,0.00),('5','89','665','233389',4488017,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233389',4488018,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233389',4488019,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233389',4488020,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233389',4488021,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233725',4494040,'1809','267',1948198.80,1951890.46,3691.66,601740.58,0.00,0.00,0.00,0.00,0.00),('5','89','663','233725',4494041,'1810','267',1421132.45,1424522.29,3389.84,552543.92,0.00,0.00,0.00,0.00,0.00),('5','89','662','233725',4494042,'1811','267',1946503.77,1946503.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233725',4494043,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233725',4494044,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233725',4494045,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233725',4494046,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233725',4494047,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233725',4494048,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233725',4494049,'1818','267',1026629.89,1026712.59,82.70,13480.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','233725',4494050,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233725',4494051,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233725',4494052,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233725',4494053,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233725',4494054,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','233956',4498363,'1809','267',1951890.46,1954464.71,2574.25,419602.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','233956',4498364,'1810','267',1424522.29,1426823.29,2301.00,375063.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233956',4498365,'1811','267',1946503.77,1947487.12,983.35,160286.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','233956',4498366,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233956',4498367,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233956',4498368,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233956',4498369,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','233956',4498370,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233956',4498371,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','233956',4498372,'1818','267',1026712.59,1027945.88,1233.29,201026.27,0.00,0.00,0.00,0.00,0.00),('5','89','665','233956',4498373,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','233956',4498374,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233956',4498375,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','233956',4498376,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','233956',4498377,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','234278',4504250,'1809','267',1954464.71,1954464.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','234278',4504251,'1810','267',1426823.29,1426823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','234278',4504252,'1811','267',1947487.12,1952298.14,4811.02,784196.26,0.00,0.00,0.00,0.00,0.00),('5','89','664','234278',4504253,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','234278',4504254,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','234278',4504255,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','234278',4504256,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','234278',4504257,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','234278',4504258,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','234278',4504259,'1818','267',1027945.88,1032587.69,4641.81,756615.03,0.00,0.00,0.00,0.00,0.00),('5','89','665','234278',4504260,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','234278',4504261,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','234278',4504262,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','234278',4504263,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','234278',4504264,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','234545',4508966,'1809','267',1954464.71,1954464.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','234545',4508967,'1810','267',1426823.29,1426823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','234545',4508968,'1811','267',1952298.14,1956718.06,4419.92,720446.96,0.00,0.00,0.00,0.00,0.00),('5','89','664','234545',4508969,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','234545',4508970,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','234545',4508971,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','234545',4508972,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','234545',4508973,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','234545',4508974,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','234545',4508975,'1818','267',1032587.69,1037497.42,4909.73,800285.99,0.00,0.00,0.00,0.00,0.00),('5','89','665','234545',4508976,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','234545',4508977,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','234545',4508978,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','234545',4508979,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','234545',4508980,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235034',4517678,'1809','267',1954464.71,1954464.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235034',4517679,'1810','267',1426823.29,1426823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235034',4517680,'1811','267',1956718.06,1958751.12,2033.06,335454.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','235034',4517681,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235034',4517682,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235034',4517683,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235034',4517684,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235034',4517685,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235034',4517686,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235034',4517687,'1818','267',1037497.42,1039411.91,1914.49,315890.85,0.00,0.00,0.00,0.00,0.00),('5','89','665','235034',4517688,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235034',4517689,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235034',4517690,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235034',4517691,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','235034',4517692,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235037',4517733,'1809','267',1954464.71,1954464.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235037',4517734,'1810','267',1426823.29,1426823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235037',4517735,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235037',4517736,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235037',4517737,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235037',4517738,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235037',4517739,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235037',4517740,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235037',4517741,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235037',4517742,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235037',4517743,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235037',4517744,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235037',4517745,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235037',4517746,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','235037',4517747,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235277',4521828,'1809','267',1954464.71,1954464.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235277',4521829,'1810','267',1426823.29,1426823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235277',4521830,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235277',4521831,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235277',4521832,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235277',4521833,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235277',4521834,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235277',4521835,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235277',4521836,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235277',4521837,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235277',4521838,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235277',4521839,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235277',4521840,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235277',4521841,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','235277',4521842,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235491',4525600,'1809','267',1954464.71,1954464.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235491',4525601,'1810','267',1426823.29,1426823.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235491',4525602,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235491',4525603,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235491',4525604,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235491',4525605,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235491',4525606,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235491',4525607,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235491',4525608,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235491',4525609,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235491',4525610,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235491',4525611,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235491',4525612,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235491',4525613,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','235491',4525614,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235833',4531549,'1809','267',1954464.71,1956790.71,2326.00,383790.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','235833',4531550,'1810','267',1426823.29,1429741.57,2918.28,481516.20,0.00,0.00,0.00,0.00,0.00),('5','89','662','235833',4531551,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235833',4531552,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235833',4531553,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235833',4531554,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235833',4531555,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','235833',4531556,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235833',4531557,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','235833',4531558,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235833',4531559,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','235833',4531560,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235833',4531561,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','235833',4531562,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','235833',4531563,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236182',4537765,'1809','267',1956790.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236182',4537766,'1810','267',1429741.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236182',4537767,'1811','267',1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236182',4537768,'1812','267',1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236182',4537769,'1813','267',609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236182',4537770,'1814','267',682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236182',4537771,'1815','267',843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236182',4537772,'1816','267',440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236182',4537773,'1817','267',476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236182',4537774,'1818','267',1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236182',4537775,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236182',4537776,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236182',4537777,'1821','268',472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236182',4537778,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','236182',4537779,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236605',4545103,'1809','267',1956790.71,1964198.00,7407.29,1222202.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','236605',4545104,'1810','267',1429741.57,1438416.98,8675.41,1431442.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','236605',4545105,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236605',4545106,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236605',4545107,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236605',4545108,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236605',4545109,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236605',4545110,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236605',4545111,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236605',4545112,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236605',4545113,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236605',4545114,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236605',4545115,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236605',4545116,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','236605',4545117,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236612',4545228,'1809','267',1964198.00,1971256.75,7058.75,1164693.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','236612',4545229,'1810','267',1438416.98,1446481.55,8064.57,1330654.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','236612',4545230,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236612',4545231,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236612',4545232,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236612',4545233,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236612',4545234,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236612',4545235,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236612',4545236,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236612',4545237,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236612',4545238,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236612',4545239,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236612',4545240,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236612',4545241,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','236612',4545242,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236614',4545271,'1809','267',1971256.75,1972325.00,1068.25,176261.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','236614',4545272,'1810','267',1446481.55,1449221.18,2739.63,452038.95,0.00,0.00,0.00,0.00,0.00),('5','89','662','236614',4545273,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236614',4545274,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236614',4545275,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236614',4545276,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236614',4545277,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236614',4545278,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236614',4545279,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236614',4545280,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236614',4545281,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236614',4545282,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236614',4545283,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236614',4545284,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','236614',4545285,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236620',4545329,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236620',4545330,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236620',4545331,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236620',4545332,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236620',4545333,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236620',4545334,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236620',4545335,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236620',4545336,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236620',4545337,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236620',4545338,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236620',4545339,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236620',4545340,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236620',4545341,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236620',4545342,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','236620',4545343,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236929',4550868,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','236929',4550869,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236929',4550870,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236929',4550871,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236929',4550872,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236929',4550873,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236929',4550874,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','236929',4550875,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236929',4550876,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','236929',4550877,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236929',4550878,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','236929',4550879,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236929',4550880,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','236929',4550881,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','236929',4550882,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','237843',4566822,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','237843',4566823,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','237843',4566824,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','237843',4566825,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','237843',4566826,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','237843',4566827,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','237843',4566828,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','237843',4566829,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','237843',4566830,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','237843',4566831,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','237843',4566832,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','237843',4566833,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','237843',4566834,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','237843',4566835,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','237843',4566836,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238079',4570648,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238079',4570649,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238079',4570650,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238079',4570651,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238079',4570652,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238079',4570653,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238079',4570654,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238079',4570655,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238079',4570656,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238079',4570657,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238079',4570658,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238079',4570659,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238079',4570660,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238079',4570661,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','238079',4570662,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238080',4570663,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238080',4570664,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238080',4570665,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238080',4570666,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238080',4570667,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238080',4570668,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238080',4570669,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238080',4570670,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238080',4570671,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238080',4570672,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238080',4570673,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238080',4570674,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238080',4570675,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238080',4570676,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','238080',4570677,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238083',4570690,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238083',4570691,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238083',4570692,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238083',4570693,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238083',4570694,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238083',4570695,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238083',4570696,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238083',4570697,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238083',4570698,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238083',4570699,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238083',4570700,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238083',4570701,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238083',4570702,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238083',4570703,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','238083',4570704,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238084',4570705,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238084',4570706,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238084',4570707,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238084',4570708,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238084',4570709,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238084',4570710,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238084',4570711,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238084',4570712,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238084',4570713,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238084',4570714,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238084',4570715,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238084',4570716,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238084',4570717,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238084',4570718,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','238084',4570719,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238183',4572150,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238183',4572151,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238183',4572152,'1811','267',1958751.12,1958751.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238183',4572153,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238183',4572154,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238183',4572155,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238183',4572156,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238183',4572157,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238183',4572158,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238183',4572159,'1818','267',1039411.91,1039411.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238183',4572160,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238183',4572161,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238183',4572162,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238183',4572163,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','238183',4572164,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238579',4579170,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238579',4579171,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238579',4579172,'1811','267',1958751.12,1964931.06,6179.94,1019690.10,0.00,0.00,0.00,0.00,0.00),('5','89','664','238579',4579173,'1812','267',1090124.64,1090124.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238579',4579174,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238579',4579175,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238579',4579176,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238579',4579177,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238579',4579178,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238579',4579179,'1818','267',1039411.91,1045756.66,6344.75,1046883.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','238579',4579180,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238579',4579181,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238579',4579182,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238579',4579183,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','238579',4579184,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238919',4585071,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','238919',4585072,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238919',4585073,'1811','267',1964931.06,1966193.29,1262.23,208267.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','238919',4585074,'1812','267',1090124.64,1097540.81,7416.17,1223668.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','238919',4585075,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238919',4585076,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238919',4585077,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','238919',4585078,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238919',4585079,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','238919',4585080,'1818','267',1045756.66,1046928.10,1171.44,193287.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','238919',4585081,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','238919',4585082,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238919',4585083,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','238919',4585084,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','238919',4585085,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','239038',4587298,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','239038',4587299,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239038',4587300,'1811','267',1966193.29,1966193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239038',4587301,'1812','267',1097540.81,1103929.27,6388.46,1054095.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','239038',4587302,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239038',4587303,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239038',4587304,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239038',4587305,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239038',4587306,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239038',4587307,'1818','267',1046928.10,1046928.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','239038',4587308,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','239038',4587309,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','239038',4587310,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','239038',4587311,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','239038',4587312,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','239222',4590289,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','239222',4590290,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239222',4590291,'1811','267',1966193.29,1966193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239222',4590292,'1812','267',1103929.27,1105262.55,1333.28,219991.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','239222',4590293,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239222',4590294,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239222',4590295,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239222',4590296,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239222',4590297,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239222',4590298,'1818','267',1046928.10,1046928.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','239222',4590299,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','239222',4590300,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','239222',4590301,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','239222',4590302,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','239222',4590303,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','239485',4594906,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','239485',4594907,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239485',4594908,'1811','267',1966193.29,1966193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239485',4594909,'1812','267',1105262.55,1105262.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239485',4594910,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239485',4594911,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239485',4594912,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239485',4594913,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239485',4594914,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239485',4594915,'1818','267',1046928.10,1046928.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','239485',4594916,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','239485',4594917,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','239485',4594918,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','239485',4594919,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','239485',4594920,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','239732',4599239,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','239732',4599240,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239732',4599241,'1811','267',1966193.29,1966193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239732',4599242,'1812','267',1105262.55,1105262.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239732',4599243,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239732',4599244,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239732',4599245,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','239732',4599246,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239732',4599247,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','239732',4599248,'1818','267',1046928.10,1046928.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','239732',4599249,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','239732',4599250,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','239732',4599251,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','239732',4599252,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','239732',4599253,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240204',4607316,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240204',4607317,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240204',4607318,'1811','267',1966193.29,1966193.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240204',4607319,'1812','267',1105262.55,1105262.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240204',4607320,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240204',4607321,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240204',4607322,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240204',4607323,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240204',4607324,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240204',4607325,'1818','267',1046928.10,1046928.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','240204',4607326,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','240204',4607327,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240204',4607328,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240204',4607329,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','240204',4607330,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240282',4608774,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240282',4608775,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240282',4608776,'1811','267',1966193.29,1969492.08,3298.79,544300.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','240282',4608777,'1812','267',1105262.55,1106034.63,772.08,127393.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','240282',4608778,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240282',4608779,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240282',4608780,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240282',4608781,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240282',4608782,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240282',4608783,'1818','267',1046928.10,1050988.70,4060.60,669999.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','240282',4608784,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','240282',4608785,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240282',4608786,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240282',4608787,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','240282',4608788,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240513',4612320,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240513',4612321,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240513',4612322,'1811','267',1969492.08,1969702.50,210.42,34719.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','240513',4612323,'1812','267',1106034.63,1110050.04,4015.41,662542.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','240513',4612324,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240513',4612325,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240513',4612326,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240513',4612327,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240513',4612328,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240513',4612329,'1818','267',1050988.70,1056085.58,5096.88,840985.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','240513',4612330,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','240513',4612331,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240513',4612332,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240513',4612333,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','240513',4612334,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240524',4612495,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240524',4612496,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240524',4612497,'1811','267',1969702.50,1969895.10,192.60,31779.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240524',4612498,'1812','267',1110050.04,1118144.37,8094.33,1335564.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','240524',4612499,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240524',4612500,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240524',4612501,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240524',4612502,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240524',4612503,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240524',4612504,'1818','267',1056085.58,1056642.91,557.33,91959.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','240524',4612505,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','240524',4612506,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240524',4612507,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240524',4612508,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','240524',4612509,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240954',4619778,'1809','267',1972325.00,1972325.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','240954',4619779,'1810','267',1449221.18,1449221.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240954',4619780,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240954',4619781,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240954',4619782,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240954',4619783,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240954',4619784,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','240954',4619785,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240954',4619786,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','240954',4619787,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','240954',4619788,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','240954',4619789,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240954',4619790,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','240954',4619791,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','240954',4619792,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','241083',4621963,'1809','267',1972325.00,1975835.39,3510.39,579214.35,0.00,0.00,0.00,0.00,0.00),('5','89','663','241083',4621964,'1810','267',1449221.18,1455149.66,5928.48,978199.20,0.00,0.00,0.00,0.00,0.00),('5','89','662','241083',4621965,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241083',4621966,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241083',4621967,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241083',4621968,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241083',4621969,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241083',4621970,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','241083',4621971,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','241083',4621972,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','241083',4621973,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','241083',4621974,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','241083',4621975,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','241083',4621976,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','241083',4621977,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','241460',4628737,'1809','267',1975835.39,1980826.31,4990.92,823501.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','241460',4628738,'1810','267',1455149.66,1463166.15,8016.49,1322720.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','241460',4628739,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241460',4628740,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241460',4628741,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241460',4628742,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241460',4628743,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241460',4628744,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','241460',4628745,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','241460',4628746,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','241460',4628747,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','241460',4628748,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','241460',4628749,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','241460',4628750,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','241460',4628751,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','241938',4636928,'1809','267',1980826.31,1985295.93,4469.62,737487.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','241938',4636929,'1810','267',1463166.15,1469465.91,6299.76,1039460.40,0.00,0.00,0.00,0.00,0.00),('5','89','662','241938',4636930,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241938',4636931,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241938',4636932,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241938',4636933,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241938',4636934,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','241938',4636935,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','241938',4636936,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','241938',4636937,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','241938',4636938,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','241938',4636939,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','241938',4636940,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','241938',4636941,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','241938',4636942,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','242617',4648808,'1809','267',1985295.93,1990087.68,4791.75,790638.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','242617',4648809,'1810','267',1469465.91,1474676.25,5210.34,859706.10,0.00,0.00,0.00,0.00,0.00),('5','89','662','242617',4648810,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242617',4648811,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242617',4648812,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242617',4648813,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242617',4648814,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242617',4648815,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242617',4648816,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242617',4648817,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242617',4648818,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242617',4648819,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242617',4648820,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242617',4648821,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','242617',4648822,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','242760',4651246,'1809','267',1990087.68,1990662.12,574.44,94782.60,0.00,0.00,0.00,0.00,0.00),('5','89','663','242760',4651247,'1810','267',1474676.25,1475937.81,1261.56,208157.40,0.00,0.00,0.00,0.00,0.00),('5','89','662','242760',4651248,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242760',4651249,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242760',4651250,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242760',4651251,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242760',4651252,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242760',4651253,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242760',4651254,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242760',4651255,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242760',4651256,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242760',4651257,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242760',4651258,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242760',4651259,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','242760',4651260,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','242764',4651283,'1809','267',1990662.12,1990662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','242764',4651284,'1810','267',1475937.81,1475937.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242764',4651285,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242764',4651286,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242764',4651287,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242764',4651288,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242764',4651289,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242764',4651290,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242764',4651291,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242764',4651292,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242764',4651293,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242764',4651294,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242764',4651295,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242764',4651296,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','242764',4651297,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','242767',4651310,'1809','267',1990662.12,1990662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','242767',4651311,'1810','267',1475937.81,1475937.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242767',4651312,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242767',4651313,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242767',4651314,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242767',4651315,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242767',4651316,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242767',4651317,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242767',4651318,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242767',4651319,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242767',4651320,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242767',4651321,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242767',4651322,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242767',4651323,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','242767',4651324,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','242771',4651389,'1809','267',1990662.12,1990662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','242771',4651390,'1810','267',1475937.81,1475937.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242771',4651391,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242771',4651392,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242771',4651393,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242771',4651394,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242771',4651395,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','242771',4651396,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242771',4651397,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','242771',4651398,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242771',4651399,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','242771',4651400,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242771',4651401,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','242771',4651402,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','242771',4651403,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','243336',4661519,'1809','267',1990662.12,1990662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','243336',4661520,'1810','267',1475937.81,1475937.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243336',4661521,'1811','267',1969895.10,1969895.10,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243336',4661522,'1812','267',1118144.37,1118144.37,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243336',4661523,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243336',4661524,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243336',4661525,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243336',4661526,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243336',4661527,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243336',4661528,'1818','267',1056642.91,1056642.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','243336',4661529,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','243336',4661530,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','243336',4661531,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','243336',4661532,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','243336',4661533,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','243463',4663516,'1809','267',1990662.12,1990662.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','243463',4663517,'1810','267',1475937.81,1475937.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243463',4663518,'1811','267',1969895.10,1974722.26,4827.16,796481.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','243463',4663519,'1812','267',1118144.37,1122581.55,4437.18,732134.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','243463',4663520,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243463',4663521,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243463',4663522,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243463',4663523,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243463',4663524,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243463',4663525,'1818','267',1056642.91,1061713.57,5070.66,836658.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','243463',4663526,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','243463',4663527,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','243463',4663528,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','243463',4663529,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','243463',4663530,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','243479',4663741,'1809','267',1990662.12,1995167.27,4505.15,743349.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','243479',4663742,'1810','267',1475937.81,1475948.42,10.61,1750.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','243479',4663743,'1811','267',1974722.26,1977170.31,2448.05,403928.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','243479',4663744,'1812','267',1122581.55,1128432.47,5850.92,965401.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','243479',4663745,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243479',4663746,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243479',4663747,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243479',4663748,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243479',4663749,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243479',4663750,'1818','267',1061713.57,1064393.17,2679.60,442134.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','243479',4663751,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','243479',4663752,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','243479',4663753,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','243479',4663754,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','243479',4663755,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','243782',4669199,'1809','267',1995167.27,2001135.54,5968.27,984764.55,0.00,0.00,0.00,0.00,0.00),('5','89','663','243782',4669200,'1810','267',1475948.42,1478190.51,2242.09,369944.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','243782',4669201,'1811','267',1977170.31,1977170.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243782',4669202,'1812','267',1128432.47,1132854.35,4421.88,729610.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','243782',4669203,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243782',4669204,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243782',4669205,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','243782',4669206,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243782',4669207,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','243782',4669208,'1818','267',1064393.17,1064393.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','243782',4669209,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','243782',4669210,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','243782',4669211,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','243782',4669212,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','243782',4669213,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','244020',4673345,'1809','267',2001135.54,2008024.37,6888.83,1136656.95,0.00,0.00,0.00,0.00,0.00),('5','89','663','244020',4673346,'1810','267',1478190.51,1483136.04,4945.53,816012.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','244020',4673347,'1811','267',1977170.31,1977170.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244020',4673348,'1812','267',1132854.35,1132854.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244020',4673349,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244020',4673350,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244020',4673351,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244020',4673352,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244020',4673353,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244020',4673354,'1818','267',1064393.17,1064393.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','244020',4673355,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','244020',4673356,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244020',4673357,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244020',4673358,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','244020',4673359,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','244205',4676336,'1809','267',2008024.37,2009888.25,1863.88,307540.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','244205',4676337,'1810','267',1483136.04,1486516.53,3380.49,557780.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','244205',4676338,'1811','267',1977170.31,1977170.31,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244205',4676339,'1812','267',1132854.35,1132854.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244205',4676340,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244205',4676341,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244205',4676342,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244205',4676343,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244205',4676344,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244205',4676345,'1818','267',1064393.17,1064393.17,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','244205',4676346,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','244205',4676347,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244205',4676348,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244205',4676349,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','244205',4676350,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','244460',4680811,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','244460',4680812,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244460',4680813,'1811','267',1977170.31,1978760.40,1590.09,262364.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','244460',4680814,'1812','267',1132854.35,1133435.67,581.32,95917.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','244460',4680815,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244460',4680816,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244460',4680817,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244460',4680818,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244460',4680819,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244460',4680820,'1818','267',1064393.17,1066852.69,2459.52,405820.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','244460',4680821,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','244460',4680822,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244460',4680823,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244460',4680824,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','244460',4680825,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','244719',4685223,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','244719',4685224,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244719',4685225,'1811','267',1978760.40,1978760.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244719',4685226,'1812','267',1133435.67,1139441.71,6006.04,990996.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','244719',4685227,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244719',4685228,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244719',4685229,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244719',4685230,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244719',4685231,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244719',4685232,'1818','267',1066852.69,1073112.08,6259.39,1032799.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','244719',4685233,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','244719',4685234,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244719',4685235,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244719',4685236,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','244719',4685237,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','244945',4689295,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','244945',4689296,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244945',4689297,'1811','267',1978760.40,1981721.61,2961.21,488599.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','244945',4689298,'1812','267',1139441.71,1141581.73,2140.02,353103.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','244945',4689299,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244945',4689300,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244945',4689301,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','244945',4689302,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244945',4689303,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','244945',4689304,'1818','267',1073112.08,1078927.41,5815.33,959529.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','244945',4689305,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','244945',4689306,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244945',4689307,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','244945',4689308,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','244945',4689309,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','245314',4695508,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','245314',4695509,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245314',4695510,'1811','267',1981721.61,1985114.82,3393.21,559879.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','245314',4695511,'1812','267',1141581.73,1143774.81,2193.08,361858.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','245314',4695512,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245314',4695513,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245314',4695514,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245314',4695515,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245314',4695516,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245314',4695517,'1818','267',1078927.41,1083282.76,4355.35,718632.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','245314',4695518,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','245314',4695519,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','245314',4695520,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','245314',4695521,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','245314',4695522,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','245649',4701604,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','245649',4701605,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245649',4701606,'1811','267',1985114.82,1985114.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245649',4701607,'1812','267',1143774.81,1145596.97,1822.16,300656.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','245649',4701608,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245649',4701609,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245649',4701610,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245649',4701611,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245649',4701612,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245649',4701613,'1818','267',1083282.76,1083282.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','245649',4701614,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','245649',4701615,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','245649',4701616,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','245649',4701617,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','245649',4701618,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','245816',4704254,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','245816',4704255,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245816',4704256,'1811','267',1985114.82,1985114.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245816',4704257,'1812','267',1145596.97,1145596.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245816',4704258,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245816',4704259,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245816',4704260,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','245816',4704261,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245816',4704262,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','245816',4704263,'1818','267',1083282.76,1083282.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','245816',4704264,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','245816',4704265,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','245816',4704266,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','245816',4704267,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','245816',4704268,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246090',4708507,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246090',4708508,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246090',4708509,'1811','267',1985114.82,1985114.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246090',4708510,'1812','267',1145596.97,1145596.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246090',4708511,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246090',4708512,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246090',4708513,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246090',4708514,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246090',4708515,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246090',4708516,'1818','267',1083282.76,1083282.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246090',4708517,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246090',4708518,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246090',4708519,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246090',4708520,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','246090',4708521,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246262',4711318,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246262',4711319,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246262',4711320,'1811','267',1985114.82,1985114.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246262',4711321,'1812','267',1145596.97,1145596.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246262',4711322,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246262',4711323,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246262',4711324,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246262',4711325,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246262',4711326,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246262',4711327,'1818','267',1083282.76,1083282.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246262',4711328,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246262',4711329,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246262',4711330,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246262',4711331,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','246262',4711332,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246266',4711376,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246266',4711377,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246266',4711378,'1811','267',1985114.82,1985114.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246266',4711379,'1812','267',1145596.97,1145596.97,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246266',4711380,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246266',4711381,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246266',4711382,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246266',4711383,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246266',4711384,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246266',4711385,'1818','267',1083282.76,1083282.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246266',4711386,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246266',4711387,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246266',4711388,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246266',4711389,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','246266',4711390,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246581',4716841,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246581',4716842,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246581',4716843,'1811','267',1985114.82,1985114.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246581',4716844,'1812','267',1145596.97,1153564.64,7967.67,1314665.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','246581',4716845,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246581',4716846,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246581',4716847,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246581',4716848,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246581',4716849,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246581',4716850,'1818','267',1083282.76,1083282.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246581',4716851,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246581',4716852,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246581',4716853,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246581',4716854,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','246581',4716855,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246913',4722807,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','246913',4722808,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246913',4722809,'1811','267',1985114.82,1986050.83,936.01,154441.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','246913',4722810,'1812','267',1153564.64,1160228.66,6664.02,1099563.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','246913',4722811,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246913',4722812,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246913',4722813,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','246913',4722814,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246913',4722815,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','246913',4722816,'1818','267',1083282.76,1084997.11,1714.35,282867.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','246913',4722817,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','246913',4722818,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246913',4722819,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','246913',4722820,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','246913',4722821,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','247119',4726181,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','247119',4726182,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247119',4726183,'1811','267',1986050.83,1991431.33,5380.50,887782.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','247119',4726184,'1812','267',1160228.66,1161210.85,982.19,162061.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','247119',4726185,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247119',4726186,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247119',4726187,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247119',4726188,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247119',4726189,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247119',4726190,'1818','267',1084997.11,1090997.71,6000.60,990099.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','247119',4726191,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','247119',4726192,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','247119',4726193,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','247119',4726194,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','247119',4726195,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','247372',4730774,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','247372',4730775,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247372',4730776,'1811','267',1991431.33,1992657.33,1226.00,202290.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247372',4730777,'1812','267',1161210.85,1168596.61,7385.76,1218650.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','247372',4730778,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247372',4730779,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247372',4730780,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247372',4730781,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247372',4730782,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247372',4730783,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','247372',4730784,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','247372',4730785,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','247372',4730786,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','247372',4730787,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','247372',4730788,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','247636',4735076,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','247636',4735077,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247636',4735078,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247636',4735079,'1812','267',1168596.61,1173666.14,5069.53,836472.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','247636',4735080,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247636',4735081,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247636',4735082,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247636',4735083,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247636',4735084,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247636',4735085,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','247636',4735086,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','247636',4735087,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','247636',4735088,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','247636',4735089,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','247636',4735090,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','247882',4739372,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','247882',4739373,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247882',4739374,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247882',4739375,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247882',4739376,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247882',4739377,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247882',4739378,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','247882',4739379,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247882',4739380,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','247882',4739381,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','247882',4739382,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','247882',4739383,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','247882',4739384,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','247882',4739385,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','247882',4739386,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','248217',4744733,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','248217',4744734,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','248217',4744735,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248217',4744736,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248217',4744737,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248217',4744738,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248217',4744739,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248217',4744740,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','248217',4744741,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','248217',4744742,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','248217',4744743,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','248217',4744744,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','248217',4744745,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','248217',4744746,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','248217',4744747,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','248831',4755395,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','248831',4755396,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','248831',4755397,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248831',4755398,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248831',4755399,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248831',4755400,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248831',4755401,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','248831',4755402,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','248831',4755403,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','248831',4755404,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','248831',4755405,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','248831',4755406,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','248831',4755407,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','248831',4755408,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','248831',4755409,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','249056',4759134,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','249056',4759135,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249056',4759136,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249056',4759137,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249056',4759138,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249056',4759139,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249056',4759140,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249056',4759141,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249056',4759142,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249056',4759143,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','249056',4759144,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','249056',4759145,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','249056',4759146,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','249056',4759147,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','249056',4759148,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','249743',4770574,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','249743',4770575,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249743',4770576,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249743',4770577,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249743',4770578,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249743',4770579,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249743',4770580,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249743',4770581,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249743',4770582,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249743',4770583,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','249743',4770584,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','249743',4770585,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','249743',4770586,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','249743',4770587,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','249743',4770588,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','249762',4770906,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','249762',4770907,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249762',4770908,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249762',4770909,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249762',4770910,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249762',4770911,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249762',4770912,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','249762',4770913,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249762',4770914,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','249762',4770915,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','249762',4770916,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','249762',4770917,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','249762',4770918,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','249762',4770919,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','249762',4770920,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250150',4777297,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250150',4777298,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250150',4777299,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250150',4777300,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250150',4777301,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250150',4777302,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250150',4777303,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250150',4777304,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250150',4777305,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250150',4777306,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250150',4777307,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250150',4777308,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250150',4777309,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250150',4777310,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','250150',4777311,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250430',4781964,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250430',4781965,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250430',4781966,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250430',4781967,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250430',4781968,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250430',4781969,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250430',4781970,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250430',4781971,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250430',4781972,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250430',4781973,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250430',4781974,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250430',4781975,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250430',4781976,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250430',4781977,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','250430',4781978,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250702',4786767,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250702',4786768,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250702',4786769,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250702',4786770,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250702',4786771,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250702',4786772,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250702',4786773,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250702',4786774,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250702',4786775,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250702',4786776,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250702',4786777,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250702',4786778,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250702',4786779,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250702',4786780,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','250702',4786781,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250706',4786812,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250706',4786813,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250706',4786814,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250706',4786815,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250706',4786816,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250706',4786817,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250706',4786818,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250706',4786819,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250706',4786820,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250706',4786821,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250706',4786822,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250706',4786823,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250706',4786824,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250706',4786825,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','250706',4786826,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250708',4786833,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250708',4786834,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250708',4786835,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250708',4786836,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250708',4786837,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250708',4786838,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250708',4786839,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250708',4786840,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250708',4786841,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250708',4786842,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250708',4786843,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250708',4786844,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250708',4786845,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250708',4786846,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','250708',4786847,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250711',4786882,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250711',4786883,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250711',4786884,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250711',4786885,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250711',4786886,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250711',4786887,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250711',4786888,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250711',4786889,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250711',4786890,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250711',4786891,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250711',4786892,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250711',4786893,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250711',4786894,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250711',4786895,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','250711',4786896,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250714',4786913,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','250714',4786914,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250714',4786915,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250714',4786916,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250714',4786917,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250714',4786918,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250714',4786919,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','250714',4786920,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250714',4786921,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','250714',4786922,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250714',4786923,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','250714',4786924,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250714',4786925,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','250714',4786926,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','250714',4786927,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251119',4794067,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251119',4794068,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251119',4794069,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251119',4794070,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251119',4794071,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251119',4794072,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251119',4794073,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251119',4794074,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251119',4794075,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251119',4794076,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','251119',4794077,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','251119',4794078,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251119',4794079,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251119',4794080,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','251119',4794081,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251439',4799689,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251439',4799690,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251439',4799691,'1811','267',1992657.33,1992657.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251439',4799692,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251439',4799693,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251439',4799694,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251439',4799695,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251439',4799696,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251439',4799697,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251439',4799698,'1818','267',1090997.71,1090997.71,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','251439',4799699,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','251439',4799700,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251439',4799701,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251439',4799702,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','251439',4799703,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251454',4799977,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251454',4799978,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251454',4799979,'1811','267',1992657.33,1996363.02,3705.69,611438.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','251454',4799980,'1812','267',1173666.14,1173666.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251454',4799981,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251454',4799982,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251454',4799983,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251454',4799984,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251454',4799985,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251454',4799986,'1818','267',1090997.71,1093246.02,2248.31,370971.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','251454',4799987,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','251454',4799988,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251454',4799989,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251454',4799990,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','251454',4799991,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251714',4804637,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251714',4804638,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251714',4804639,'1811','267',1996363.02,2002841.40,6478.38,1068932.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','251714',4804640,'1812','267',1173666.14,1174869.42,1203.28,198541.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','251714',4804641,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251714',4804642,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251714',4804643,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251714',4804644,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251714',4804645,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251714',4804646,'1818','267',1093246.02,1099308.32,6062.30,1000279.50,0.00,0.00,0.00,0.00,0.00),('5','89','665','251714',4804647,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','251714',4804648,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251714',4804649,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251714',4804650,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','251714',4804651,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251889',4807449,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','251889',4807450,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251889',4807451,'1811','267',2002841.40,2006771.92,3930.52,648535.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','251889',4807452,'1812','267',1174869.42,1179368.59,4499.17,742363.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','251889',4807453,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251889',4807454,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251889',4807455,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','251889',4807456,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251889',4807457,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','251889',4807458,'1818','267',1099308.32,1104047.75,4739.43,782005.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','251889',4807459,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','251889',4807460,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251889',4807461,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','251889',4807462,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','251889',4807463,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','252223',4813419,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','252223',4813420,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252223',4813421,'1811','267',2006771.92,2010793.03,4021.11,663483.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','252223',4813422,'1812','267',1179368.59,1183044.06,3675.47,606452.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','252223',4813423,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252223',4813424,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252223',4813425,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252223',4813426,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252223',4813427,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252223',4813428,'1818','267',1104047.75,1108177.76,4130.01,681451.65,0.00,0.00,0.00,0.00,0.00),('5','89','665','252223',4813429,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','252223',4813430,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','252223',4813431,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','252223',4813432,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','252223',4813433,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','252569',4819550,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','252569',4819551,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252569',4819552,'1811','267',2010793.03,2015518.25,4725.22,779661.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','252569',4819553,'1812','267',1183044.06,1183623.75,579.69,95648.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','252569',4819554,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252569',4819555,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252569',4819556,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252569',4819557,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252569',4819558,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252569',4819559,'1818','267',1108177.76,1112322.89,4145.13,683946.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','252569',4819560,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','252569',4819561,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','252569',4819562,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','252569',4819563,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','252569',4819564,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','252622',4820441,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','252622',4820442,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252622',4820443,'1811','267',2015518.25,2015518.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252622',4820444,'1812','267',1183623.75,1192504.08,8880.33,1465254.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','252622',4820445,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252622',4820446,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252622',4820447,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252622',4820448,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252622',4820449,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252622',4820450,'1818','267',1112322.89,1112322.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','252622',4820451,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','252622',4820452,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','252622',4820453,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','252622',4820454,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','252622',4820455,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','252912',4825239,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','252912',4825240,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252912',4825241,'1811','267',2015518.25,2015518.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252912',4825242,'1812','267',1192504.08,1200108.73,7604.65,1254767.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','252912',4825243,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252912',4825244,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252912',4825245,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','252912',4825246,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252912',4825247,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','252912',4825248,'1818','267',1112322.89,1112322.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','252912',4825249,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','252912',4825250,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','252912',4825251,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','252912',4825252,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','252912',4825253,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','253131',4829003,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','253131',4829004,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253131',4829005,'1811','267',2015518.25,2015518.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253131',4829006,'1812','267',1200108.73,1205935.01,5826.28,961336.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','253131',4829007,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253131',4829008,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253131',4829009,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253131',4829010,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253131',4829011,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253131',4829012,'1818','267',1112322.89,1112322.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','253131',4829013,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','253131',4829014,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','253131',4829015,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','253131',4829016,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','253131',4829017,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','253467',4834673,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','253467',4834674,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253467',4834675,'1811','267',2015518.25,2015518.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253467',4834676,'1812','267',1205935.01,1212830.84,6895.83,1137811.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','253467',4834677,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253467',4834678,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253467',4834679,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253467',4834680,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253467',4834681,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253467',4834682,'1818','267',1112322.89,1112322.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','253467',4834683,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','253467',4834684,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','253467',4834685,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','253467',4834686,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','253467',4834687,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','253605',4836961,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','253605',4836962,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253605',4836963,'1811','267',2015518.25,2020755.72,5237.47,864182.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','253605',4836964,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253605',4836965,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253605',4836966,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253605',4836967,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253605',4836968,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253605',4836969,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253605',4836970,'1818','267',1112322.89,1117728.41,5405.52,891910.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','253605',4836971,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','253605',4836972,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','253605',4836973,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','253605',4836974,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','253605',4836975,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','253878',4841891,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','253878',4841892,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253878',4841893,'1811','267',2020755.72,2023297.21,2541.49,419345.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','253878',4841894,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253878',4841895,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253878',4841896,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253878',4841897,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','253878',4841898,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253878',4841899,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','253878',4841900,'1818','267',1117728.41,1122695.28,4966.87,819533.55,0.00,0.00,0.00,0.00,0.00),('5','89','665','253878',4841901,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','253878',4841902,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','253878',4841903,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','253878',4841904,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','253878',4841905,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','254057',4844839,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','254057',4844840,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254057',4844841,'1811','267',2023297.21,2026753.87,3456.66,570348.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','254057',4844842,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254057',4844843,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254057',4844844,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254057',4844845,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254057',4844846,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254057',4844847,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254057',4844848,'1818','267',1122695.28,1128012.64,5317.36,877364.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','254057',4844849,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','254057',4844850,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','254057',4844851,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','254057',4844852,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','254057',4844853,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','254426',4851432,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','254426',4851433,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254426',4851434,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254426',4851435,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254426',4851436,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254426',4851437,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254426',4851438,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254426',4851439,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254426',4851440,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254426',4851441,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','254426',4851442,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','254426',4851443,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','254426',4851444,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','254426',4851445,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','254426',4851446,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','254747',4856608,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','254747',4856609,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254747',4856610,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254747',4856611,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254747',4856612,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254747',4856613,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254747',4856614,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254747',4856615,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254747',4856616,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254747',4856617,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','254747',4856618,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','254747',4856619,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','254747',4856620,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','254747',4856621,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','254747',4856622,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','254892',4859410,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','254892',4859411,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254892',4859412,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254892',4859413,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254892',4859414,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254892',4859415,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254892',4859416,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','254892',4859417,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254892',4859418,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','254892',4859419,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','254892',4859420,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','254892',4859421,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','254892',4859422,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','254892',4859423,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','254892',4859424,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','255182',4864440,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','255182',4864441,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255182',4864442,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255182',4864443,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255182',4864444,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255182',4864445,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255182',4864446,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255182',4864447,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255182',4864448,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255182',4864449,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','255182',4864450,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','255182',4864451,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','255182',4864452,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','255182',4864453,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','255182',4864454,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','255436',4868869,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','255436',4868870,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255436',4868871,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255436',4868872,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255436',4868873,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255436',4868874,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255436',4868875,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255436',4868876,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255436',4868877,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255436',4868878,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','255436',4868879,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','255436',4868880,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','255436',4868881,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','255436',4868882,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','255436',4868883,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','255698',4873148,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','255698',4873149,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255698',4873150,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255698',4873151,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255698',4873152,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255698',4873153,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255698',4873154,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255698',4873155,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255698',4873156,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255698',4873157,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','255698',4873158,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','255698',4873159,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','255698',4873160,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','255698',4873161,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','255698',4873162,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','255874',4875826,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','255874',4875827,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255874',4875828,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255874',4875829,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255874',4875830,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255874',4875831,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255874',4875832,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','255874',4875833,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255874',4875834,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','255874',4875835,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','255874',4875836,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','255874',4875837,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','255874',4875838,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','255874',4875839,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','255874',4875840,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','256190',4881020,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','256190',4881021,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256190',4881022,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256190',4881023,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256190',4881024,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256190',4881025,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256190',4881026,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256190',4881027,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256190',4881028,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256190',4881029,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','256190',4881030,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','256190',4881031,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','256190',4881032,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','256190',4881033,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','256190',4881034,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','256373',4884049,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','256373',4884050,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256373',4884051,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256373',4884052,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256373',4884053,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256373',4884054,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256373',4884055,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256373',4884056,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256373',4884057,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256373',4884058,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','256373',4884059,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','256373',4884060,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','256373',4884061,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','256373',4884062,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','256373',4884063,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','256601',4887980,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','256601',4887981,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256601',4887982,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256601',4887983,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256601',4887984,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256601',4887985,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256601',4887986,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256601',4887987,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256601',4887988,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256601',4887989,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','256601',4887990,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','256601',4887991,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','256601',4887992,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','256601',4887993,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','256601',4887994,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','256944',4893959,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','256944',4893960,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256944',4893961,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256944',4893962,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256944',4893963,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256944',4893964,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256944',4893965,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','256944',4893966,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256944',4893967,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','256944',4893968,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','256944',4893969,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','256944',4893970,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','256944',4893971,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','256944',4893972,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','256944',4893973,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257210',4898803,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257210',4898804,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257210',4898805,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257210',4898806,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257210',4898807,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257210',4898808,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257210',4898809,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257210',4898810,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257210',4898811,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257210',4898812,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257210',4898813,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257210',4898814,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257210',4898815,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257210',4898816,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257210',4898817,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257596',4905316,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257596',4905317,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257596',4905318,'1811','267',2026753.87,2026753.87,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257596',4905319,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257596',4905320,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257596',4905321,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257596',4905322,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257596',4905323,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257596',4905324,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257596',4905325,'1818','267',1128012.64,1128012.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257596',4905326,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257596',4905327,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257596',4905328,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257596',4905329,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257596',4905330,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257597',4905331,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257597',4905332,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257597',4905333,'1811','267',2026753.87,2031264.78,4510.91,744300.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257597',4905334,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257597',4905335,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257597',4905336,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257597',4905337,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257597',4905338,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257597',4905339,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257597',4905340,'1818','267',1128012.64,1131727.22,3714.58,612905.70,0.00,0.00,0.00,0.00,0.00),('5','89','665','257597',4905341,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257597',4905342,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257597',4905343,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257597',4905344,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257597',4905345,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257598',4905346,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257598',4905347,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257598',4905348,'1811','267',2031264.78,2034978.63,3713.85,612785.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257598',4905349,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257598',4905350,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257598',4905351,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257598',4905352,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257598',4905353,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257598',4905354,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257598',4905355,'1818','267',1131727.22,1137257.34,5530.12,912469.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','257598',4905356,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257598',4905357,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257598',4905358,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257598',4905359,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257598',4905360,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257599',4905361,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257599',4905362,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257599',4905363,'1811','267',2034978.63,2037547.42,2568.79,423850.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257599',4905364,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257599',4905365,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257599',4905366,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257599',4905367,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257599',4905368,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257599',4905369,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257599',4905370,'1818','267',1137257.34,1139841.73,2584.39,426424.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','257599',4905371,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257599',4905372,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257599',4905373,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257599',4905374,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257599',4905375,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257600',4905376,'1809','267',2009888.25,2009888.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257600',4905377,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257600',4905378,'1811','267',2037547.42,2042621.82,5074.40,837276.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257600',4905379,'1812','267',1212830.84,1212830.84,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257600',4905380,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257600',4905381,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257600',4905382,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257600',4905383,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257600',4905384,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257600',4905385,'1818','267',1139841.73,1145447.86,5606.13,925011.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','257600',4905386,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257600',4905387,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257600',4905388,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257600',4905389,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257600',4905390,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257601',4905391,'1809','267',2009888.25,2011837.31,1949.06,321594.90,0.00,0.00,0.00,0.00,0.00),('5','89','663','257601',4905392,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257601',4905393,'1811','267',2042621.82,2044667.11,2045.29,337472.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','257601',4905394,'1812','267',1212830.84,1216956.55,4125.71,680742.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257601',4905395,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257601',4905396,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257601',4905397,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257601',4905398,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257601',4905399,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257601',4905400,'1818','267',1145447.86,1147700.80,2252.94,371735.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','257601',4905401,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257601',4905402,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257601',4905403,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257601',4905404,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257601',4905405,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257602',4905406,'1809','267',2011837.31,2016199.12,4361.81,719698.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','257602',4905407,'1810','267',1486516.53,1486516.53,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257602',4905408,'1811','267',2044667.11,2045869.26,1202.15,198354.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','257602',4905409,'1812','267',1216956.55,1219243.63,2287.08,377368.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','257602',4905410,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257602',4905411,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257602',4905412,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257602',4905413,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257602',4905414,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257602',4905415,'1818','267',1147700.80,1151333.22,3632.42,599349.30,0.00,0.00,0.00,0.00,0.00),('5','89','665','257602',4905416,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257602',4905417,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257602',4905418,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257602',4905419,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257602',4905420,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257603',4905421,'1809','267',2016199.12,2021116.14,4917.02,811308.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','257603',4905422,'1810','267',1486516.53,1491351.55,4835.02,797778.30,0.00,0.00,0.00,0.00,0.00),('5','89','662','257603',4905423,'1811','267',2045869.26,2045869.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257603',4905424,'1812','267',1219243.63,1219243.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257603',4905425,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257603',4905426,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257603',4905427,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257603',4905428,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257603',4905429,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257603',4905430,'1818','267',1151333.22,1151590.36,257.14,42428.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','257603',4905431,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257603',4905432,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257603',4905433,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257603',4905434,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257603',4905435,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257604',4905436,'1809','267',2021116.14,2025257.06,4140.92,683251.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','257604',4905437,'1810','267',1491351.55,1496403.25,5051.70,833530.50,0.00,0.00,0.00,0.00,0.00),('5','89','662','257604',4905438,'1811','267',2045869.26,2045869.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257604',4905439,'1812','267',1219243.63,1219243.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257604',4905440,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257604',4905441,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257604',4905442,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257604',4905443,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257604',4905444,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257604',4905445,'1818','267',1151590.36,1151590.36,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257604',4905446,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257604',4905447,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257604',4905448,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257604',4905449,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257604',4905450,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257605',4905451,'1809','267',2025257.06,2030127.91,4870.85,803690.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','257605',4905452,'1810','267',1496403.25,1496403.25,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257605',4905453,'1811','267',2045869.26,2045869.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257605',4905454,'1812','267',1219243.63,1221288.87,2045.24,337464.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','257605',4905455,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257605',4905456,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257605',4905457,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257605',4905458,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257605',4905459,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257605',4905460,'1818','267',1151590.36,1156487.70,4897.34,808061.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','257605',4905461,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257605',4905462,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257605',4905463,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257605',4905464,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257605',4905465,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257606',4905466,'1809','267',2030127.91,2030127.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257606',4905467,'1810','267',1496403.25,1503033.34,6630.09,1093964.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','257606',4905468,'1811','267',2045869.26,2046084.53,215.27,35519.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','257606',4905469,'1812','267',1221288.87,1223233.34,1944.47,320837.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','257606',4905470,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257606',4905471,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257606',4905472,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257606',4905473,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257606',4905474,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257606',4905475,'1818','267',1156487.70,1156666.25,178.55,29460.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','257606',4905476,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257606',4905477,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257606',4905478,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257606',4905479,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257606',4905480,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257607',4905481,'1809','267',2030127.91,2033523.07,3395.16,560201.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','257607',4905482,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257607',4905483,'1811','267',2046084.53,2048561.55,2477.02,408708.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257607',4905484,'1812','267',1223233.34,1223233.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257607',4905485,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257607',4905486,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257607',4905487,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257607',4905488,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257607',4905489,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257607',4905490,'1818','267',1156666.25,1158985.04,2318.79,382600.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','257607',4905491,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257607',4905492,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257607',4905493,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257607',4905494,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257607',4905495,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257608',4905496,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257608',4905497,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257608',4905498,'1811','267',2048561.55,2048561.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257608',4905499,'1812','267',1223233.34,1227777.03,4543.69,749708.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','257608',4905500,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257608',4905501,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257608',4905502,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257608',4905503,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257608',4905504,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257608',4905505,'1818','267',1158985.04,1158985.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257608',4905506,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257608',4905507,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257608',4905508,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257608',4905509,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257608',4905510,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257609',4905511,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257609',4905512,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257609',4905513,'1811','267',2048561.55,2048561.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257609',4905514,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257609',4905515,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257609',4905516,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257609',4905517,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257609',4905518,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257609',4905519,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257609',4905520,'1818','267',1158985.04,1158985.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257609',4905521,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257609',4905522,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257609',4905523,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257609',4905524,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257609',4905525,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257610',4905526,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257610',4905527,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257610',4905528,'1811','267',2048561.55,2048561.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257610',4905529,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257610',4905530,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257610',4905531,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257610',4905532,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257610',4905533,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257610',4905534,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257610',4905535,'1818','267',1158985.04,1158985.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257610',4905536,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257610',4905537,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257610',4905538,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257610',4905539,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257610',4905540,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257611',4905541,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257611',4905542,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257611',4905543,'1811','267',2048561.55,2048561.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257611',4905544,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257611',4905545,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257611',4905546,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257611',4905547,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257611',4905548,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257611',4905549,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257611',4905550,'1818','267',1158985.04,1158985.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257611',4905551,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257611',4905552,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257611',4905553,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257611',4905554,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257611',4905555,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257612',4905556,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257612',4905557,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257612',4905558,'1811','267',2048561.55,2048561.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257612',4905559,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257612',4905560,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257612',4905561,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257612',4905562,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257612',4905563,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257612',4905564,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257612',4905565,'1818','267',1158985.04,1158985.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257612',4905566,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257612',4905567,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257612',4905568,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257612',4905569,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257612',4905570,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257613',4905571,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257613',4905572,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257613',4905573,'1811','267',2048561.55,2048561.55,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257613',4905574,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257613',4905575,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257613',4905576,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257613',4905577,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257613',4905578,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257613',4905579,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257613',4905580,'1818','267',1158985.04,1158985.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257613',4905581,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257613',4905582,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257613',4905583,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257613',4905584,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257613',4905585,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257614',4905586,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257614',4905587,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257614',4905588,'1811','267',2048561.55,2055022.30,6460.75,1066023.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','257614',4905589,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257614',4905590,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257614',4905591,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257614',4905592,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257614',4905593,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257614',4905594,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257614',4905595,'1818','267',1158985.04,1161372.35,2387.31,393906.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','257614',4905596,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257614',4905597,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257614',4905598,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257614',4905599,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257614',4905600,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257615',4905601,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257615',4905602,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257615',4905603,'1811','267',2055022.30,2056794.07,1771.77,292342.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257615',4905604,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257615',4905605,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257615',4905606,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257615',4905607,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257615',4905608,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257615',4905609,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257615',4905610,'1818','267',1161372.35,1170341.12,8968.77,1479847.05,0.00,0.00,0.00,0.00,0.00),('5','89','665','257615',4905611,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257615',4905612,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257615',4905613,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257615',4905614,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257615',4905615,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257616',4905616,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257616',4905617,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257616',4905618,'1811','267',2056794.07,2060508.61,3714.54,612899.10,0.00,0.00,0.00,0.00,0.00),('5','89','664','257616',4905619,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257616',4905620,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257616',4905621,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257616',4905622,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257616',4905623,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257616',4905624,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257616',4905625,'1818','267',1170341.12,1173961.83,3620.71,597417.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','257616',4905626,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257616',4905627,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257616',4905628,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257616',4905629,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257616',4905630,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257617',4905631,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257617',4905632,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257617',4905633,'1811','267',2060508.61,2060508.61,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257617',4905634,'1812','267',1227777.03,1227777.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257617',4905635,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257617',4905636,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257617',4905637,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257617',4905638,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257617',4905639,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257617',4905640,'1818','267',1173961.83,1173961.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257617',4905641,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257617',4905642,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257617',4905643,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257617',4905644,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257617',4905645,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257618',4905646,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257618',4905647,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257618',4905648,'1811','267',2060508.61,2066828.18,6319.57,1042729.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257618',4905649,'1812','267',1227777.03,1235543.28,7766.25,1281431.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257618',4905650,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257618',4905651,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257618',4905652,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257618',4905653,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257618',4905654,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257618',4905655,'1818','267',1173961.83,1173961.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257618',4905656,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257618',4905657,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257618',4905658,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257618',4905659,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257618',4905660,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257619',4905661,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257619',4905662,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257619',4905663,'1811','267',2066828.18,2074961.60,8133.42,1342014.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257619',4905664,'1812','267',1235543.28,1244787.27,9243.99,1525258.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257619',4905665,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257619',4905666,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257619',4905667,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257619',4905668,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257619',4905669,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257619',4905670,'1818','267',1173961.83,1173961.83,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257619',4905671,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257619',4905672,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257619',4905673,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257619',4905674,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257619',4905675,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257620',4905676,'1809','267',2033523.07,2033523.07,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257620',4905677,'1810','267',1503033.34,1503033.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257620',4905678,'1811','267',2074961.60,2077698.68,2737.08,451618.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','257620',4905679,'1812','267',1244787.27,1255039.52,10252.25,1691621.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257620',4905680,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257620',4905681,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257620',4905682,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257620',4905683,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257620',4905684,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257620',4905685,'1818','267',1173961.83,1179711.29,5749.46,948660.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','257620',4905686,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257620',4905687,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257620',4905688,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257620',4905689,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257620',4905690,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257621',4905691,'1809','267',2033523.07,2034658.01,1134.94,187265.10,0.00,0.00,0.00,0.00,0.00),('5','89','663','257621',4905692,'1810','267',1503033.34,1505328.41,2295.07,378686.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257621',4905693,'1811','267',2077698.68,2077698.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257621',4905694,'1812','267',1255039.52,1257981.20,2941.68,485377.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','257621',4905695,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257621',4905696,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257621',4905697,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257621',4905698,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257621',4905699,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257621',4905700,'1818','267',1179711.29,1186711.43,7000.14,1155023.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','257621',4905701,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257621',4905702,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257621',4905703,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257621',4905704,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257621',4905705,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257622',4905706,'1809','267',2034658.01,2041700.01,7042.00,1161930.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257622',4905707,'1810','267',1505328.41,1513996.60,8668.19,1430251.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','257622',4905708,'1811','267',2077698.68,2077698.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257622',4905709,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257622',4905710,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257622',4905711,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257622',4905712,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257622',4905713,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257622',4905714,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257622',4905715,'1818','267',1186711.43,1187072.49,361.06,59574.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','257622',4905716,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257622',4905717,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257622',4905718,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257622',4905719,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257622',4905720,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257623',4905721,'1809','267',2041700.01,2046185.23,4485.22,740061.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','257623',4905722,'1810','267',1513996.60,1519630.18,5633.58,929540.70,0.00,0.00,0.00,0.00,0.00),('5','89','662','257623',4905723,'1811','267',2077698.68,2085679.32,7980.64,1316805.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','257623',4905724,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257623',4905725,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257623',4905726,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257623',4905727,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257623',4905728,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257623',4905729,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257623',4905730,'1818','267',1187072.49,1187102.45,29.96,4943.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','257623',4905731,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257623',4905732,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257623',4905733,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257623',4905734,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257623',4905735,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257624',4905736,'1809','267',2046185.23,2046185.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257624',4905737,'1810','267',1519630.18,1519630.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257624',4905738,'1811','267',2085679.32,2098222.67,12543.35,2069652.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','257624',4905739,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257624',4905740,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257624',4905741,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257624',4905742,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257624',4905743,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257624',4905744,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257624',4905745,'1818','267',1187102.45,1187225.67,123.22,20331.30,0.00,0.00,0.00,0.00,0.00),('5','89','665','257624',4905746,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257624',4905747,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257624',4905748,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257624',4905749,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257624',4905750,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257625',4905751,'1809','267',2046185.23,2046185.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257625',4905752,'1810','267',1519630.18,1519630.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257625',4905753,'1811','267',2098222.67,2106795.65,8572.98,1414541.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257625',4905754,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257625',4905755,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257625',4905756,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257625',4905757,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257625',4905758,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257625',4905759,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257625',4905760,'1818','267',1187225.67,1190972.60,3746.93,618243.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','257625',4905761,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257625',4905762,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257625',4905763,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257625',4905764,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257625',4905765,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257626',4905766,'1809','267',2046185.23,2046185.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257626',4905767,'1810','267',1519630.18,1519630.18,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257626',4905768,'1811','267',2106795.65,2110558.73,3763.08,620908.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','257626',4905769,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257626',4905770,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257626',4905771,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257626',4905772,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257626',4905773,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257626',4905774,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257626',4905775,'1818','267',1190972.60,1193909.05,2936.45,484514.25,0.00,0.00,0.00,0.00,0.00),('5','89','665','257626',4905776,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257626',4905777,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257626',4905778,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257626',4905779,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257626',4905780,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257627',4905781,'1809','267',2046185.23,2051332.23,5147.00,849255.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257627',4905782,'1810','267',1519630.18,1524113.60,4483.42,739764.30,0.00,0.00,0.00,0.00,0.00),('5','89','662','257627',4905783,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257627',4905784,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257627',4905785,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257627',4905786,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257627',4905787,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257627',4905788,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257627',4905789,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257627',4905790,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257627',4905791,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257627',4905792,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257627',4905793,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257627',4905794,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257627',4905795,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257628',4905796,'1809','267',2051332.23,2055915.21,4582.98,756191.70,0.00,0.00,0.00,0.00,0.00),('5','89','663','257628',4905797,'1810','267',1524113.60,1529254.96,5141.36,848324.40,0.00,0.00,0.00,0.00,0.00),('5','89','662','257628',4905798,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257628',4905799,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257628',4905800,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257628',4905801,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257628',4905802,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257628',4905803,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257628',4905804,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257628',4905805,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257628',4905806,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257628',4905807,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257628',4905808,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257628',4905809,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257628',4905810,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257629',4905811,'1809','267',2055915.21,2063133.42,7218.21,1191004.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','257629',4905812,'1810','267',1529254.96,1535340.91,6085.95,1004181.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257629',4905813,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257629',4905814,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257629',4905815,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257629',4905816,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257629',4905817,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257629',4905818,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257629',4905819,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257629',4905820,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257629',4905821,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257629',4905822,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257629',4905823,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257629',4905824,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257629',4905825,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257630',4905826,'1809','267',2063133.42,2063133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257630',4905827,'1810','267',1535340.91,1535340.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257630',4905828,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257630',4905829,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257630',4905830,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257630',4905831,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257630',4905832,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257630',4905833,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257630',4905834,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257630',4905835,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257630',4905836,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257630',4905837,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257630',4905838,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257630',4905839,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257630',4905840,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257631',4905841,'1809','267',2063133.42,2063133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257631',4905842,'1810','267',1535340.91,1535340.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257631',4905843,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257631',4905844,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257631',4905845,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257631',4905846,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257631',4905847,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257631',4905848,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257631',4905849,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257631',4905850,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257631',4905851,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257631',4905852,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257631',4905853,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257631',4905854,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257631',4905855,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257632',4905856,'1809','267',2063133.42,2063133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257632',4905857,'1810','267',1535340.91,1535340.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257632',4905858,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257632',4905859,'1812','267',1257981.20,1257981.20,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257632',4905860,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257632',4905861,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257632',4905862,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257632',4905863,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257632',4905864,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257632',4905865,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257632',4905866,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257632',4905867,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257632',4905868,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257632',4905869,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257632',4905870,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257633',4905871,'1809','267',2063133.42,2063133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257633',4905872,'1810','267',1535340.91,1535340.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257633',4905873,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257633',4905874,'1812','267',1257981.20,1265570.03,7588.83,1252156.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','257633',4905875,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257633',4905876,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257633',4905877,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257633',4905878,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257633',4905879,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257633',4905880,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257633',4905881,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257633',4905882,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257633',4905883,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257633',4905884,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257633',4905885,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257634',4905886,'1809','267',2063133.42,2063133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257634',4905887,'1810','267',1535340.91,1535340.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257634',4905888,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257634',4905889,'1812','267',1265570.03,1272998.68,7428.65,1225727.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257634',4905890,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257634',4905891,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257634',4905892,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257634',4905893,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257634',4905894,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257634',4905895,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257634',4905896,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257634',4905897,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257634',4905898,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257634',4905899,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257634',4905900,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257635',4905901,'1809','267',2063133.42,2063133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257635',4905902,'1810','267',1535340.91,1535340.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257635',4905903,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257635',4905904,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257635',4905905,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257635',4905906,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257635',4905907,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257635',4905908,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257635',4905909,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257635',4905910,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257635',4905911,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257635',4905912,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257635',4905913,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257635',4905914,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257635',4905915,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257636',4905916,'1809','267',2063133.42,2063133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257636',4905917,'1810','267',1535340.91,1535340.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257636',4905918,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257636',4905919,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257636',4905920,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257636',4905921,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257636',4905922,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257636',4905923,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257636',4905924,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257636',4905925,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257636',4905926,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257636',4905927,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257636',4905928,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257636',4905929,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257636',4905930,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257637',4905931,'1809','267',2063133.42,2063133.42,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257637',4905932,'1810','267',1535340.91,1535340.91,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257637',4905933,'1811','267',2110558.73,2110558.73,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257637',4905934,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257637',4905935,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257637',4905936,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257637',4905937,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257637',4905938,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257637',4905939,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257637',4905940,'1818','267',1193909.05,1193909.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257637',4905941,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257637',4905942,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257637',4905943,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257637',4905944,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257637',4905945,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257638',4905946,'1809','267',2063133.42,2071343.29,8209.87,1354628.55,0.00,0.00,0.00,0.00,0.00),('5','89','663','257638',4905947,'1810','267',1535340.91,1544567.66,9226.75,1522413.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257638',4905948,'1811','267',2110558.73,2110641.93,83.20,13728.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257638',4905949,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257638',4905950,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257638',4905951,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257638',4905952,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257638',4905953,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257638',4905954,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257638',4905955,'1818','267',1193909.05,1202635.75,8726.70,1439905.50,0.00,0.00,0.00,0.00,0.00),('5','89','665','257638',4905956,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257638',4905957,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257638',4905958,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257638',4905959,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257638',4905960,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257639',4905961,'1809','267',2071343.29,2077758.59,6415.30,1058524.50,0.00,0.00,0.00,0.00,0.00),('5','89','663','257639',4905962,'1810','267',1544567.66,1550891.73,6324.07,1043471.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257639',4905963,'1811','267',2110641.93,2110681.72,39.79,6565.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257639',4905964,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257639',4905965,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257639',4905966,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257639',4905967,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257639',4905968,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257639',4905969,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257639',4905970,'1818','267',1202635.75,1212018.75,9383.00,1548195.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257639',4905971,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257639',4905972,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257639',4905973,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257639',4905974,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257639',4905975,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257640',4905976,'1809','267',2077758.59,2086317.87,8559.28,1412281.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','257640',4905977,'1810','267',1550891.73,1560246.46,9354.73,1543530.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','257640',4905978,'1811','267',2110681.72,2110681.72,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257640',4905979,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257640',4905980,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257640',4905981,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257640',4905982,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257640',4905983,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257640',4905984,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257640',4905985,'1818','267',1212018.75,1220375.60,8356.85,1378880.25,0.00,0.00,0.00,0.00,0.00),('5','89','665','257640',4905986,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257640',4905987,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257640',4905988,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257640',4905989,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257640',4905990,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257641',4905991,'1809','267',2086317.87,2092413.00,6095.13,1005696.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','257641',4905992,'1810','267',1560246.46,1566064.02,5817.56,959897.40,0.00,0.00,0.00,0.00,0.00),('5','89','662','257641',4905993,'1811','267',2110681.72,2110685.43,3.71,612.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257641',4905994,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257641',4905995,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257641',4905996,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257641',4905997,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257641',4905998,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257641',4905999,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257641',4906000,'1818','267',1220375.60,1224488.04,4112.44,678552.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','257641',4906001,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257641',4906002,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257641',4906003,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257641',4906004,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257641',4906005,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257642',4906006,'1809','267',2092413.00,2092413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257642',4906007,'1810','267',1566064.02,1566064.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257642',4906008,'1811','267',2110685.43,2110685.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257642',4906009,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257642',4906010,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257642',4906011,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257642',4906012,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257642',4906013,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257642',4906014,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257642',4906015,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257642',4906016,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257642',4906017,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257642',4906018,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257642',4906019,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257642',4906020,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257643',4906021,'1809','267',2092413.00,2092413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257643',4906022,'1810','267',1566064.02,1566064.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257643',4906023,'1811','267',2110685.43,2110685.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257643',4906024,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257643',4906025,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257643',4906026,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257643',4906027,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257643',4906028,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257643',4906029,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257643',4906030,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257643',4906031,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257643',4906032,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257643',4906033,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257643',4906034,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257643',4906035,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257644',4906036,'1809','267',2092413.00,2092413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257644',4906037,'1810','267',1566064.02,1566064.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257644',4906038,'1811','267',2110685.43,2110685.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257644',4906039,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257644',4906040,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257644',4906041,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257644',4906042,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257644',4906043,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257644',4906044,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257644',4906045,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257644',4906046,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257644',4906047,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257644',4906048,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257644',4906049,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257644',4906050,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257645',4906051,'1809','267',2092413.00,2092413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257645',4906052,'1810','267',1566064.02,1566064.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257645',4906053,'1811','267',2110685.43,2110685.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257645',4906054,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257645',4906055,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257645',4906056,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257645',4906057,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257645',4906058,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257645',4906059,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257645',4906060,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257645',4906061,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257645',4906062,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257645',4906063,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257645',4906064,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257645',4906065,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257646',4906066,'1809','267',2092413.00,2092413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257646',4906067,'1810','267',1566064.02,1566064.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257646',4906068,'1811','267',2110685.43,2110685.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257646',4906069,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257646',4906070,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257646',4906071,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257646',4906072,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257646',4906073,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257646',4906074,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257646',4906075,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257646',4906076,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257646',4906077,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257646',4906078,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257646',4906079,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257646',4906080,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257647',4906081,'1809','267',2092413.00,2092413.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257647',4906082,'1810','267',1566064.02,1566064.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257647',4906083,'1811','267',2110685.43,2110685.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257647',4906084,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257647',4906085,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257647',4906086,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257647',4906087,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257647',4906088,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257647',4906089,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257647',4906090,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257647',4906091,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257647',4906092,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257647',4906093,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257647',4906094,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257647',4906095,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257648',4906096,'1809','267',2092413.00,2101154.89,8741.89,1442411.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','257648',4906097,'1810','267',1566064.02,1574169.27,8105.25,1337366.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257648',4906098,'1811','267',2110685.43,2110690.94,5.51,909.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257648',4906099,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257648',4906100,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257648',4906101,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257648',4906102,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257648',4906103,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257648',4906104,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257648',4906105,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257648',4906106,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257648',4906107,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257648',4906108,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257648',4906109,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257648',4906110,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257649',4906111,'1809','267',2101154.89,2105498.35,4343.46,716670.90,0.00,0.00,0.00,0.00,0.00),('5','89','663','257649',4906112,'1810','267',1574169.27,1579717.47,5548.20,915453.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257649',4906113,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257649',4906114,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257649',4906115,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257649',4906116,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257649',4906117,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257649',4906118,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257649',4906119,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257649',4906120,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257649',4906121,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257649',4906122,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257649',4906123,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257649',4906124,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257649',4906125,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257650',4906126,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257650',4906127,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257650',4906128,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257650',4906129,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257650',4906130,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257650',4906131,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257650',4906132,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257650',4906133,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257650',4906134,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257650',4906135,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257650',4906136,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257650',4906137,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257650',4906138,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257650',4906139,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257650',4906140,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257651',4906141,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257651',4906142,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257651',4906143,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257651',4906144,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257651',4906145,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257651',4906146,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257651',4906147,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257651',4906148,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257651',4906149,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257651',4906150,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257651',4906151,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257651',4906152,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257651',4906153,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257651',4906154,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257651',4906155,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257652',4906156,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257652',4906157,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257652',4906158,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257652',4906159,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257652',4906160,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257652',4906161,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257652',4906162,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257652',4906163,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257652',4906164,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257652',4906165,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257652',4906166,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257652',4906167,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257652',4906168,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257652',4906169,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257652',4906170,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257653',4906171,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257653',4906172,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257653',4906173,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257653',4906174,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257653',4906175,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257653',4906176,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257653',4906177,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257653',4906178,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257653',4906179,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257653',4906180,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257653',4906181,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257653',4906182,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257653',4906183,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257653',4906184,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257653',4906185,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257654',4906186,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257654',4906187,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257654',4906188,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257654',4906189,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257654',4906190,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257654',4906191,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257654',4906192,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257654',4906193,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257654',4906194,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257654',4906195,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257654',4906196,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257654',4906197,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257654',4906198,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257654',4906199,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257654',4906200,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257655',4906201,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257655',4906202,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257655',4906203,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257655',4906204,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257655',4906205,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257655',4906206,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257655',4906207,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257655',4906208,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257655',4906209,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257655',4906210,'1818','267',1224488.04,1224488.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257655',4906211,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257655',4906212,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257655',4906213,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257655',4906214,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257655',4906215,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257656',4906216,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257656',4906217,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257656',4906218,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257656',4906219,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257656',4906220,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257656',4906221,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257656',4906222,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257656',4906223,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257656',4906224,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257656',4906225,'1818','267',1224488.04,1225288.04,800.00,132000.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257656',4906226,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257656',4906227,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257656',4906228,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257656',4906229,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257656',4906230,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257657',4906231,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257657',4906232,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257657',4906233,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257657',4906234,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257657',4906235,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257657',4906236,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257657',4906237,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257657',4906238,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257657',4906239,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257657',4906240,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257657',4906241,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257657',4906242,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257657',4906243,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257657',4906244,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257657',4906245,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257658',4906246,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257658',4906247,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257658',4906248,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257658',4906249,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257658',4906250,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257658',4906251,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257658',4906252,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257658',4906253,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257658',4906254,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257658',4906255,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257658',4906256,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257658',4906257,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257658',4906258,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257658',4906259,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257658',4906260,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257659',4906261,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257659',4906262,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257659',4906263,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257659',4906264,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257659',4906265,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257659',4906266,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257659',4906267,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257659',4906268,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257659',4906269,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257659',4906270,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257659',4906271,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257659',4906272,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257659',4906273,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257659',4906274,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257659',4906275,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257660',4906276,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257660',4906277,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257660',4906278,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257660',4906279,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257660',4906280,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257660',4906281,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257660',4906282,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257660',4906283,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257660',4906284,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257660',4906285,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257660',4906286,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257660',4906287,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257660',4906288,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257660',4906289,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257660',4906290,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257661',4906291,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257661',4906292,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257661',4906293,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257661',4906294,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257661',4906295,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257661',4906296,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257661',4906297,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257661',4906298,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257661',4906299,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257661',4906300,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257661',4906301,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257661',4906302,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257661',4906303,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257661',4906304,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257661',4906305,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257662',4906306,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257662',4906307,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257662',4906308,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257662',4906309,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257662',4906310,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257662',4906311,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257662',4906312,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257662',4906313,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257662',4906314,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257662',4906315,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257662',4906316,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257662',4906317,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257662',4906318,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257662',4906319,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257662',4906320,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257663',4906321,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257663',4906322,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257663',4906323,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257663',4906324,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257663',4906325,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257663',4906326,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257663',4906327,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257663',4906328,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257663',4906329,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257663',4906330,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257663',4906331,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257663',4906332,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257663',4906333,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257663',4906334,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257663',4906335,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257664',4906336,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257664',4906337,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257664',4906338,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257664',4906339,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257664',4906340,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257664',4906341,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257664',4906342,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257664',4906343,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257664',4906344,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257664',4906345,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257664',4906346,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257664',4906347,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257664',4906348,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257664',4906349,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257664',4906350,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257665',4906351,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257665',4906352,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257665',4906353,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257665',4906354,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257665',4906355,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257665',4906356,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257665',4906357,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257665',4906358,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257665',4906359,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257665',4906360,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257665',4906361,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257665',4906362,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257665',4906363,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257665',4906364,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257665',4906365,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257666',4906366,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257666',4906367,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257666',4906368,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257666',4906369,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257666',4906370,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257666',4906371,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257666',4906372,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257666',4906373,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257666',4906374,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257666',4906375,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257666',4906376,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257666',4906377,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257666',4906378,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257666',4906379,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257666',4906380,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257667',4906381,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257667',4906382,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257667',4906383,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257667',4906384,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257667',4906385,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257667',4906386,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257667',4906387,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257667',4906388,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257667',4906389,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257667',4906390,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257667',4906391,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257667',4906392,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257667',4906393,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257667',4906394,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257667',4906395,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257668',4906396,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257668',4906397,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257668',4906398,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257668',4906399,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257668',4906400,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257668',4906401,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257668',4906402,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257668',4906403,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257668',4906404,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257668',4906405,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257668',4906406,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257668',4906407,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257668',4906408,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257668',4906409,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257668',4906410,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257669',4906411,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257669',4906412,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257669',4906413,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257669',4906414,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257669',4906415,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257669',4906416,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257669',4906417,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257669',4906418,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257669',4906419,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257669',4906420,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257669',4906421,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257669',4906422,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257669',4906423,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257669',4906424,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257669',4906425,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257670',4906426,'1809','267',2105498.35,2105498.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257670',4906427,'1810','267',1579717.47,1579717.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257670',4906428,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257670',4906429,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257670',4906430,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257670',4906431,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257670',4906432,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257670',4906433,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257670',4906434,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257670',4906435,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257670',4906436,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257670',4906437,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257670',4906438,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257670',4906439,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257670',4906440,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257671',4906441,'1809','267',2105498.35,2106856.96,1358.61,224170.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','257671',4906442,'1810','267',1579717.47,1581030.28,1312.81,216613.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','257671',4906443,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257671',4906444,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257671',4906445,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257671',4906446,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257671',4906447,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257671',4906448,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257671',4906449,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257671',4906450,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257671',4906451,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257671',4906452,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257671',4906453,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257671',4906454,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257671',4906455,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257672',4906456,'1809','267',2106856.96,2112279.25,5422.29,894677.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','257672',4906457,'1810','267',1581030.28,1587086.43,6056.15,999264.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257672',4906458,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257672',4906459,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257672',4906460,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257672',4906461,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257672',4906462,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257672',4906463,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257672',4906464,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257672',4906465,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257672',4906466,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257672',4906467,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257672',4906468,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257672',4906469,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257672',4906470,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257673',4906471,'1809','267',2112279.25,2117404.87,5125.62,845727.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','257673',4906472,'1810','267',1587086.43,1591879.45,4793.02,790848.30,0.00,0.00,0.00,0.00,0.00),('5','89','662','257673',4906473,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257673',4906474,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257673',4906475,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257673',4906476,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257673',4906477,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257673',4906478,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257673',4906479,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257673',4906480,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257673',4906481,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257673',4906482,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257673',4906483,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257673',4906484,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257673',4906485,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257674',4906486,'1809','267',2117404.87,2118819.63,1414.76,233435.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','257674',4906487,'1810','267',1591879.45,1595516.82,3637.37,600166.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257674',4906488,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257674',4906489,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257674',4906490,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257674',4906491,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257674',4906492,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257674',4906493,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257674',4906494,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257674',4906495,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257674',4906496,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257674',4906497,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257674',4906498,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257674',4906499,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257674',4906500,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257675',4906501,'1809','267',2118819.63,2118819.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257675',4906502,'1810','267',1595516.82,1595516.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257675',4906503,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257675',4906504,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257675',4906505,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257675',4906506,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257675',4906507,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257675',4906508,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257675',4906509,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257675',4906510,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257675',4906511,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257675',4906512,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257675',4906513,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257675',4906514,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257675',4906515,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257676',4906516,'1809','267',2118819.63,2118819.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257676',4906517,'1810','267',1595516.82,1595516.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257676',4906518,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257676',4906519,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257676',4906520,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257676',4906521,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257676',4906522,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257676',4906523,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257676',4906524,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257676',4906525,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257676',4906526,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257676',4906527,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257676',4906528,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257676',4906529,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257676',4906530,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257677',4906531,'1809','267',2118819.63,2118819.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257677',4906532,'1810','267',1595516.82,1595516.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257677',4906533,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257677',4906534,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257677',4906535,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257677',4906536,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257677',4906537,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257677',4906538,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257677',4906539,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257677',4906540,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257677',4906541,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257677',4906542,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257677',4906543,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257677',4906544,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257677',4906545,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257678',4906546,'1809','267',2118819.63,2118819.63,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257678',4906547,'1810','267',1595516.82,1595516.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257678',4906548,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257678',4906549,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257678',4906550,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257678',4906551,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257678',4906552,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257678',4906553,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257678',4906554,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257678',4906555,'1818','267',1225288.04,1225288.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257678',4906556,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257678',4906557,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257678',4906558,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257678',4906559,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257678',4906560,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257679',4906561,'1809','267',2118819.63,2119479.23,659.60,108834.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257679',4906562,'1810','267',1595516.82,1595527.05,10.23,1687.95,0.00,0.00,0.00,0.00,0.00),('5','89','662','257679',4906563,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257679',4906564,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257679',4906565,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257679',4906566,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257679',4906567,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257679',4906568,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257679',4906569,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257679',4906570,'1818','267',1225288.04,1231910.27,6622.23,1092667.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','257679',4906571,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257679',4906572,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257679',4906573,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257679',4906574,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257679',4906575,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257680',4906576,'1809','267',2119479.23,2123711.09,4231.86,698256.90,0.00,0.00,0.00,0.00,0.00),('5','89','663','257680',4906577,'1810','267',1595527.05,1597559.51,2032.46,335355.90,0.00,0.00,0.00,0.00,0.00),('5','89','662','257680',4906578,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257680',4906579,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257680',4906580,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257680',4906581,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257680',4906582,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257680',4906583,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257680',4906584,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257680',4906585,'1818','267',1231910.27,1236368.66,4458.39,735634.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','257680',4906586,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257680',4906587,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257680',4906588,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257680',4906589,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257680',4906590,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257681',4906591,'1809','267',2123711.09,2128615.81,4904.72,809278.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','257681',4906592,'1810','267',1597559.51,1601863.16,4303.65,710102.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257681',4906593,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257681',4906594,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257681',4906595,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257681',4906596,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257681',4906597,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257681',4906598,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257681',4906599,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257681',4906600,'1818','267',1236368.66,1236472.00,103.34,17051.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','257681',4906601,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257681',4906602,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257681',4906603,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257681',4906604,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257681',4906605,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257682',4906606,'1809','267',2128615.81,2132176.40,3560.59,587497.35,0.00,0.00,0.00,0.00,0.00),('5','89','663','257682',4906607,'1810','267',1601863.16,1606441.64,4578.48,755449.20,0.00,0.00,0.00,0.00,0.00),('5','89','662','257682',4906608,'1811','267',2110690.94,2110690.94,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257682',4906609,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257682',4906610,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257682',4906611,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257682',4906612,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257682',4906613,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257682',4906614,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257682',4906615,'1818','267',1236472.00,1237183.02,711.02,117318.30,0.00,0.00,0.00,0.00,0.00),('5','89','665','257682',4906616,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257682',4906617,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257682',4906618,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257682',4906619,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257682',4906620,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257683',4906621,'1809','267',2132176.40,2134176.40,2000.00,330000.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257683',4906622,'1810','267',1606441.64,1607441.64,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257683',4906623,'1811','267',2110690.94,2111331.54,640.60,105699.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257683',4906624,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257683',4906625,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257683',4906626,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257683',4906627,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257683',4906628,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257683',4906629,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257683',4906630,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257683',4906631,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257683',4906632,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257683',4906633,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257683',4906634,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257683',4906635,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257684',4906636,'1809','267',2134176.40,2134176.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257684',4906637,'1810','267',1607441.64,1607441.64,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257684',4906638,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257684',4906639,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257684',4906640,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257684',4906641,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257684',4906642,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257684',4906643,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257684',4906644,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257684',4906645,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257684',4906646,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257684',4906647,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257684',4906648,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257684',4906649,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257684',4906650,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257685',4906651,'1809','267',2134176.40,2137805.40,3629.00,598785.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257685',4906652,'1810','267',1607441.64,1611834.10,4392.46,724755.90,0.00,0.00,0.00,0.00,0.00),('5','89','662','257685',4906653,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257685',4906654,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257685',4906655,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257685',4906656,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257685',4906657,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257685',4906658,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257685',4906659,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257685',4906660,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257685',4906661,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257685',4906662,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257685',4906663,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257685',4906664,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257685',4906665,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257686',4906666,'1809','267',2137805.40,2142289.13,4483.73,739815.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','257686',4906667,'1810','267',1611834.10,1616763.53,4929.43,813355.95,0.00,0.00,0.00,0.00,0.00),('5','89','662','257686',4906668,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257686',4906669,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257686',4906670,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257686',4906671,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257686',4906672,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257686',4906673,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257686',4906674,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257686',4906675,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257686',4906676,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257686',4906677,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257686',4906678,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257686',4906679,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257686',4906680,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257687',4906681,'1809','267',2142289.13,2145168.15,2879.02,475038.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','257687',4906682,'1810','267',1616763.53,1622384.41,5620.88,927445.20,0.00,0.00,0.00,0.00,0.00),('5','89','662','257687',4906683,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257687',4906684,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257687',4906685,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257687',4906686,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257687',4906687,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257687',4906688,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257687',4906689,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257687',4906690,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257687',4906691,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257687',4906692,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257687',4906693,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257687',4906694,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257687',4906695,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257688',4906696,'1809','267',2145168.15,2148216.78,3048.63,503023.95,0.00,0.00,0.00,0.00,0.00),('5','89','663','257688',4906697,'1810','267',1622384.41,1623384.41,1000.00,165000.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257688',4906698,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257688',4906699,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257688',4906700,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257688',4906701,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257688',4906702,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257688',4906703,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257688',4906704,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257688',4906705,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257688',4906706,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257688',4906707,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257688',4906708,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257688',4906709,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257688',4906710,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257689',4906711,'1809','267',2148216.78,2149523.78,1307.00,215655.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257689',4906712,'1810','267',1623384.41,1624191.44,807.03,133159.95,0.00,0.00,0.00,0.00,0.00),('5','89','662','257689',4906713,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257689',4906714,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257689',4906715,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257689',4906716,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257689',4906717,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257689',4906718,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257689',4906719,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257689',4906720,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257689',4906721,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257689',4906722,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257689',4906723,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257689',4906724,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257689',4906725,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257690',4906726,'1809','267',2149523.78,2154708.14,5184.36,855419.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','257690',4906727,'1810','267',1624191.44,1630190.94,5999.50,989917.50,0.00,0.00,0.00,0.00,0.00),('5','89','662','257690',4906728,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257690',4906729,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257690',4906730,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257690',4906731,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257690',4906732,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257690',4906733,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257690',4906734,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257690',4906735,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257690',4906736,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257690',4906737,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257690',4906738,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257690',4906739,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257690',4906740,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257691',4906741,'1809','267',2154708.14,2158178.86,3470.72,572668.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','257691',4906742,'1810','267',1630190.94,1635528.05,5337.11,880623.15,0.00,0.00,0.00,0.00,0.00),('5','89','662','257691',4906743,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257691',4906744,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257691',4906745,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257691',4906746,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257691',4906747,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257691',4906748,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257691',4906749,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257691',4906750,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257691',4906751,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257691',4906752,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257691',4906753,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257691',4906754,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257691',4906755,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257692',4906756,'1809','267',2158178.86,2162978.28,4799.42,791904.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','257692',4906757,'1810','267',1635528.05,1640528.05,5000.00,825000.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257692',4906758,'1811','267',2111331.54,2111331.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257692',4906759,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257692',4906760,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257692',4906761,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257692',4906762,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257692',4906763,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257692',4906764,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257692',4906765,'1818','267',1237183.02,1237183.02,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257692',4906766,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257692',4906767,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257692',4906768,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257692',4906769,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257692',4906770,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257693',4906771,'1809','267',2162978.28,2162978.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257693',4906772,'1810','267',1640528.05,1640528.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257693',4906773,'1811','267',2111331.54,2115409.47,4077.93,672858.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','257693',4906774,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257693',4906775,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257693',4906776,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257693',4906777,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257693',4906778,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257693',4906779,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257693',4906780,'1818','267',1237183.02,1241230.30,4047.28,667801.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','257693',4906781,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257693',4906782,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257693',4906783,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257693',4906784,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257693',4906785,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257694',4906786,'1809','267',2162978.28,2167784.81,4806.53,793077.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','257694',4906787,'1810','267',1640528.05,1640528.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257694',4906788,'1811','267',2115409.47,2115409.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257694',4906789,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257694',4906790,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257694',4906791,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257694',4906792,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257694',4906793,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257694',4906794,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257694',4906795,'1818','267',1241230.30,1245355.01,4124.71,680577.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','257694',4906796,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257694',4906797,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257694',4906798,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257694',4906799,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257694',4906800,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257695',4906801,'1809','267',2167784.81,2169784.81,2000.00,330000.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257695',4906802,'1810','267',1640528.05,1647054.46,6526.41,1076857.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','257695',4906803,'1811','267',2115409.47,2115409.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257695',4906804,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257695',4906805,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257695',4906806,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257695',4906807,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257695',4906808,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257695',4906809,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257695',4906810,'1818','267',1245355.01,1245355.01,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257695',4906811,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257695',4906812,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257695',4906813,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257695',4906814,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257695',4906815,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257696',4906816,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257696',4906817,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257696',4906818,'1811','267',2115409.47,2119623.13,4213.66,695253.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','257696',4906819,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257696',4906820,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257696',4906821,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257696',4906822,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257696',4906823,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257696',4906824,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257696',4906825,'1818','267',1245355.01,1249355.01,4000.00,660000.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257696',4906826,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257696',4906827,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257696',4906828,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257696',4906829,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257696',4906830,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257697',4906831,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257697',4906832,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257697',4906833,'1811','267',2119623.13,2122623.13,3000.00,495000.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257697',4906834,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257697',4906835,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257697',4906836,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257697',4906837,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257697',4906838,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257697',4906839,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257697',4906840,'1818','267',1249355.01,1254328.44,4973.43,820615.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','257697',4906841,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257697',4906842,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257697',4906843,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257697',4906844,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257697',4906845,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257698',4906846,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257698',4906847,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257698',4906848,'1811','267',2122623.13,2128619.40,5996.27,989384.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','257698',4906849,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257698',4906850,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257698',4906851,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257698',4906852,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257698',4906853,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257698',4906854,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257698',4906855,'1818','267',1254328.44,1256328.44,2000.00,330000.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257698',4906856,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257698',4906857,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257698',4906858,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257698',4906859,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257698',4906860,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257699',4906861,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257699',4906862,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257699',4906863,'1811','267',2128619.40,2130956.90,2337.50,385687.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','257699',4906864,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257699',4906865,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257699',4906866,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257699',4906867,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257699',4906868,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257699',4906869,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257699',4906870,'1818','267',1256328.44,1257191.28,862.84,142368.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','257699',4906871,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257699',4906872,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257699',4906873,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257699',4906874,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257699',4906875,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257700',4906876,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257700',4906877,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257700',4906878,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257700',4906879,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257700',4906880,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257700',4906881,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257700',4906882,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257700',4906883,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257700',4906884,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257700',4906885,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257700',4906886,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257700',4906887,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257700',4906888,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257700',4906889,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257700',4906890,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257701',4906891,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257701',4906892,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257701',4906893,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257701',4906894,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257701',4906895,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257701',4906896,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257701',4906897,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257701',4906898,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257701',4906899,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257701',4906900,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257701',4906901,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257701',4906902,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257701',4906903,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257701',4906904,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257701',4906905,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257702',4906906,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257702',4906907,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257702',4906908,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257702',4906909,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257702',4906910,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257702',4906911,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257702',4906912,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257702',4906913,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257702',4906914,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257702',4906915,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257702',4906916,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257702',4906917,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257702',4906918,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257702',4906919,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257702',4906920,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257703',4906921,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257703',4906922,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257703',4906923,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257703',4906924,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257703',4906925,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257703',4906926,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257703',4906927,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257703',4906928,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257703',4906929,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257703',4906930,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257703',4906931,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257703',4906932,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257703',4906933,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257703',4906934,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257703',4906935,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257704',4906936,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257704',4906937,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257704',4906938,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257704',4906939,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257704',4906940,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257704',4906941,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257704',4906942,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257704',4906943,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257704',4906944,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257704',4906945,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257704',4906946,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257704',4906947,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257704',4906948,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257704',4906949,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257704',4906950,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257705',4906951,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257705',4906952,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257705',4906953,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257705',4906954,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257705',4906955,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257705',4906956,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257705',4906957,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257705',4906958,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257705',4906959,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257705',4906960,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257705',4906961,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257705',4906962,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257705',4906963,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257705',4906964,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257705',4906965,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257706',4906966,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257706',4906967,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257706',4906968,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257706',4906969,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257706',4906970,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257706',4906971,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257706',4906972,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257706',4906973,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257706',4906974,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257706',4906975,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257706',4906976,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257706',4906977,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257706',4906978,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257706',4906979,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257706',4906980,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257707',4906981,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257707',4906982,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257707',4906983,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257707',4906984,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257707',4906985,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257707',4906986,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257707',4906987,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257707',4906988,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257707',4906989,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257707',4906990,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257707',4906991,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257707',4906992,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257707',4906993,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257707',4906994,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257707',4906995,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257708',4906996,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257708',4906997,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257708',4906998,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257708',4906999,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257708',4907000,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257708',4907001,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257708',4907002,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257708',4907003,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257708',4907004,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257708',4907005,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257708',4907006,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257708',4907007,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257708',4907008,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257708',4907009,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257708',4907010,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257709',4907011,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257709',4907012,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257709',4907013,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257709',4907014,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257709',4907015,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257709',4907016,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257709',4907017,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257709',4907018,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257709',4907019,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257709',4907020,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257709',4907021,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257709',4907022,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257709',4907023,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257709',4907024,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257709',4907025,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257710',4907026,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257710',4907027,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257710',4907028,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257710',4907029,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257710',4907030,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257710',4907031,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257710',4907032,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257710',4907033,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257710',4907034,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257710',4907035,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257710',4907036,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257710',4907037,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257710',4907038,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257710',4907039,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257710',4907040,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257711',4907041,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257711',4907042,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257711',4907043,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257711',4907044,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257711',4907045,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257711',4907046,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257711',4907047,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257711',4907048,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257711',4907049,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257711',4907050,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257711',4907051,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257711',4907052,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257711',4907053,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257711',4907054,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257711',4907055,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257712',4907056,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257712',4907057,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257712',4907058,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257712',4907059,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257712',4907060,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257712',4907061,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257712',4907062,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257712',4907063,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257712',4907064,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257712',4907065,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257712',4907066,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257712',4907067,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257712',4907068,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257712',4907069,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257712',4907070,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257713',4907071,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257713',4907072,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257713',4907073,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257713',4907074,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257713',4907075,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257713',4907076,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257713',4907077,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257713',4907078,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257713',4907079,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257713',4907080,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257713',4907081,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257713',4907082,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257713',4907083,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257713',4907084,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257713',4907085,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257714',4907086,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257714',4907087,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257714',4907088,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257714',4907089,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257714',4907090,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257714',4907091,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257714',4907092,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257714',4907093,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257714',4907094,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257714',4907095,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257714',4907096,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257714',4907097,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257714',4907098,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257714',4907099,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257714',4907100,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257715',4907101,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257715',4907102,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257715',4907103,'1811','267',2130956.90,2130956.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257715',4907104,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257715',4907105,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257715',4907106,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257715',4907107,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257715',4907108,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257715',4907109,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257715',4907110,'1818','267',1257191.28,1257191.28,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257715',4907111,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257715',4907112,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257715',4907113,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257715',4907114,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257715',4907115,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257716',4907116,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257716',4907117,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257716',4907118,'1811','267',2130956.90,2133090.12,2133.22,351981.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257716',4907119,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257716',4907120,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257716',4907121,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257716',4907122,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257716',4907123,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257716',4907124,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257716',4907125,'1818','267',1257191.28,1260015.43,2824.15,465984.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','257716',4907126,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257716',4907127,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257716',4907128,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257716',4907129,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257716',4907130,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257717',4907131,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257717',4907132,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257717',4907133,'1811','267',2133090.12,2136939.90,3849.78,635213.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257717',4907134,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257717',4907135,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257717',4907136,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257717',4907137,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257717',4907138,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257717',4907139,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257717',4907140,'1818','267',1260015.43,1264356.36,4340.93,716253.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','257717',4907141,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257717',4907142,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257717',4907143,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257717',4907144,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257717',4907145,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257718',4907146,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257718',4907147,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257718',4907148,'1811','267',2136939.90,2139909.92,2970.02,490053.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257718',4907149,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257718',4907150,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257718',4907151,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257718',4907152,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257718',4907153,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257718',4907154,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257718',4907155,'1818','267',1264356.36,1268398.76,4042.40,666996.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257718',4907156,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257718',4907157,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257718',4907158,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257718',4907159,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257718',4907160,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257719',4907161,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257719',4907162,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257719',4907163,'1811','267',2139909.92,2142225.07,2315.15,381999.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','257719',4907164,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257719',4907165,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257719',4907166,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257719',4907167,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257719',4907168,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257719',4907169,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257719',4907170,'1818','267',1268398.76,1272860.22,4461.46,736140.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','257719',4907171,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257719',4907172,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257719',4907173,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257719',4907174,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257719',4907175,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257720',4907176,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257720',4907177,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257720',4907178,'1811','267',2142225.07,2150593.61,8368.54,1380809.10,0.00,0.00,0.00,0.00,0.00),('5','89','664','257720',4907179,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257720',4907180,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257720',4907181,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257720',4907182,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257720',4907183,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257720',4907184,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257720',4907185,'1818','267',1272860.22,1272860.22,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257720',4907186,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257720',4907187,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257720',4907188,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257720',4907189,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257720',4907190,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257721',4907191,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257721',4907192,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257721',4907193,'1811','267',2150593.61,2152593.61,2000.00,330000.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257721',4907194,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257721',4907195,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257721',4907196,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257721',4907197,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257721',4907198,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257721',4907199,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257721',4907200,'1818','267',1272860.22,1275247.08,2386.86,393831.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','257721',4907201,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257721',4907202,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257721',4907203,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257721',4907204,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257721',4907205,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257722',4907206,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257722',4907207,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257722',4907208,'1811','267',2152593.61,2155648.60,3054.99,504073.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257722',4907209,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257722',4907210,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257722',4907211,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257722',4907212,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257722',4907213,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257722',4907214,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257722',4907215,'1818','267',1275247.08,1275247.08,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257722',4907216,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257722',4907217,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257722',4907218,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257722',4907219,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257722',4907220,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257723',4907221,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257723',4907222,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257723',4907223,'1811','267',2155648.60,2157143.77,1495.17,246703.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257723',4907224,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257723',4907225,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257723',4907226,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257723',4907227,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257723',4907228,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257723',4907229,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257723',4907230,'1818','267',1275247.08,1275615.88,368.80,60852.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257723',4907231,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257723',4907232,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257723',4907233,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257723',4907234,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257723',4907235,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257724',4907236,'1809','267',2169784.81,2169784.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257724',4907237,'1810','267',1647054.46,1647054.46,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257724',4907238,'1811','267',2157143.77,2157143.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257724',4907239,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257724',4907240,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257724',4907241,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257724',4907242,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257724',4907243,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257724',4907244,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257724',4907245,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257724',4907246,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257724',4907247,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257724',4907248,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257724',4907249,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257724',4907250,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257725',4907251,'1809','267',2169784.81,2175175.27,5390.46,889425.90,0.00,0.00,0.00,0.00,0.00),('5','89','663','257725',4907252,'1810','267',1647054.46,1648225.99,1171.53,193302.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','257725',4907253,'1811','267',2157143.77,2157143.77,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257725',4907254,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257725',4907255,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257725',4907256,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257725',4907257,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257725',4907258,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257725',4907259,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257725',4907260,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257725',4907261,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257725',4907262,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257725',4907263,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257725',4907264,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257725',4907265,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257726',4907266,'1809','267',2175175.27,2177896.68,2721.41,449032.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','257726',4907267,'1810','267',1648225.99,1652720.12,4494.13,741531.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','257726',4907268,'1811','267',2157143.77,2157828.68,684.91,113010.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257726',4907269,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257726',4907270,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257726',4907271,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257726',4907272,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257726',4907273,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257726',4907274,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257726',4907275,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257726',4907276,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257726',4907277,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257726',4907278,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257726',4907279,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257726',4907280,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257727',4907281,'1809','267',2177896.68,2180472.98,2576.30,425089.50,0.00,0.00,0.00,0.00,0.00),('5','89','663','257727',4907282,'1810','267',1652720.12,1655506.31,2786.19,459721.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','257727',4907283,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257727',4907284,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257727',4907285,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257727',4907286,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257727',4907287,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257727',4907288,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257727',4907289,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257727',4907290,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257727',4907291,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257727',4907292,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257727',4907293,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257727',4907294,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257727',4907295,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257728',4907296,'1809','267',2180472.98,2183348.23,2875.25,474416.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','257728',4907297,'1810','267',1655506.31,1656682.28,1175.97,194035.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257728',4907298,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257728',4907299,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257728',4907300,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257728',4907301,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257728',4907302,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257728',4907303,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257728',4907304,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257728',4907305,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257728',4907306,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257728',4907307,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257728',4907308,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257728',4907309,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257728',4907310,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257729',4907311,'1809','267',2183348.23,2183348.23,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257729',4907312,'1810','267',1656682.28,1660482.25,3799.97,626995.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257729',4907313,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257729',4907314,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257729',4907315,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257729',4907316,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257729',4907317,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257729',4907318,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257729',4907319,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257729',4907320,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257729',4907321,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257729',4907322,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257729',4907323,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257729',4907324,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257729',4907325,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257730',4907326,'1809','267',2183348.23,2183439.35,91.12,15034.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','257730',4907327,'1810','267',1660482.25,1662395.80,1913.55,315735.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257730',4907328,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257730',4907329,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257730',4907330,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257730',4907331,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257730',4907332,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257730',4907333,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257730',4907334,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257730',4907335,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257730',4907336,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257730',4907337,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257730',4907338,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257730',4907339,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257730',4907340,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257731',4907341,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257731',4907342,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257731',4907343,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257731',4907344,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257731',4907345,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257731',4907346,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257731',4907347,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257731',4907348,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257731',4907349,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257731',4907350,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257731',4907351,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257731',4907352,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257731',4907353,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257731',4907354,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257731',4907355,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257732',4907356,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257732',4907357,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257732',4907358,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257732',4907359,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257732',4907360,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257732',4907361,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257732',4907362,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257732',4907363,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257732',4907364,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257732',4907365,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257732',4907366,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257732',4907367,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257732',4907368,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257732',4907369,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257732',4907370,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257733',4907371,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257733',4907372,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257733',4907373,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257733',4907374,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257733',4907375,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257733',4907376,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257733',4907377,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257733',4907378,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257733',4907379,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257733',4907380,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257733',4907381,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257733',4907382,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257733',4907383,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257733',4907384,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257733',4907385,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257734',4907386,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257734',4907387,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257734',4907388,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257734',4907389,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257734',4907390,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257734',4907391,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257734',4907392,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257734',4907393,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257734',4907394,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257734',4907395,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257734',4907396,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257734',4907397,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257734',4907398,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257734',4907399,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257734',4907400,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257735',4907401,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257735',4907402,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257735',4907403,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257735',4907404,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257735',4907405,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257735',4907406,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257735',4907407,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257735',4907408,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257735',4907409,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257735',4907410,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257735',4907411,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257735',4907412,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257735',4907413,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257735',4907414,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257735',4907415,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257736',4907416,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257736',4907417,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257736',4907418,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257736',4907419,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257736',4907420,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257736',4907421,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257736',4907422,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257736',4907423,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257736',4907424,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257736',4907425,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257736',4907426,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257736',4907427,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257736',4907428,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257736',4907429,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257736',4907430,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257737',4907431,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257737',4907432,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257737',4907433,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257737',4907434,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257737',4907435,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257737',4907436,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257737',4907437,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257737',4907438,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257737',4907439,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257737',4907440,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257737',4907441,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257737',4907442,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257737',4907443,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257737',4907444,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257737',4907445,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257738',4907446,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257738',4907447,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257738',4907448,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257738',4907449,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257738',4907450,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257738',4907451,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257738',4907452,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257738',4907453,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257738',4907454,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257738',4907455,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257738',4907456,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257738',4907457,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257738',4907458,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257738',4907459,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257738',4907460,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257739',4907461,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257739',4907462,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257739',4907463,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257739',4907464,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257739',4907465,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257739',4907466,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257739',4907467,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257739',4907468,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257739',4907469,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257739',4907470,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257739',4907471,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257739',4907472,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257739',4907473,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257739',4907474,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257739',4907475,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257740',4907476,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257740',4907477,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257740',4907478,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257740',4907479,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257740',4907480,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257740',4907481,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257740',4907482,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257740',4907483,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257740',4907484,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257740',4907485,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257740',4907486,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257740',4907487,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257740',4907488,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257740',4907489,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257740',4907490,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257741',4907491,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257741',4907492,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257741',4907493,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257741',4907494,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257741',4907495,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257741',4907496,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257741',4907497,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257741',4907498,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257741',4907499,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257741',4907500,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257741',4907501,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257741',4907502,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257741',4907503,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257741',4907504,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257741',4907505,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257742',4907506,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257742',4907507,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257742',4907508,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257742',4907509,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257742',4907510,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257742',4907511,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257742',4907512,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257742',4907513,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257742',4907514,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257742',4907515,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257742',4907516,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257742',4907517,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257742',4907518,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257742',4907519,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257742',4907520,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257743',4907521,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257743',4907522,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257743',4907523,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257743',4907524,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257743',4907525,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257743',4907526,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257743',4907527,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257743',4907528,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257743',4907529,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257743',4907530,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257743',4907531,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257743',4907532,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257743',4907533,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257743',4907534,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257743',4907535,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257744',4907536,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257744',4907537,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257744',4907538,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257744',4907539,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257744',4907540,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257744',4907541,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257744',4907542,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257744',4907543,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257744',4907544,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257744',4907545,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257744',4907546,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257744',4907547,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257744',4907548,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257744',4907549,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257744',4907550,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257745',4907551,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257745',4907552,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257745',4907553,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257745',4907554,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257745',4907555,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257745',4907556,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257745',4907557,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257745',4907558,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257745',4907559,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257745',4907560,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257745',4907561,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257745',4907562,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257745',4907563,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257745',4907564,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257745',4907565,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257746',4907566,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257746',4907567,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257746',4907568,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257746',4907569,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257746',4907570,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257746',4907571,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257746',4907572,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257746',4907573,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257746',4907574,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257746',4907575,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257746',4907576,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257746',4907577,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257746',4907578,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257746',4907579,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257746',4907580,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257747',4907581,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257747',4907582,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257747',4907583,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257747',4907584,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257747',4907585,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257747',4907586,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257747',4907587,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257747',4907588,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257747',4907589,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257747',4907590,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257747',4907591,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257747',4907592,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257747',4907593,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257747',4907594,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257747',4907595,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257748',4907596,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257748',4907597,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257748',4907598,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257748',4907599,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257748',4907600,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257748',4907601,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257748',4907602,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257748',4907603,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257748',4907604,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257748',4907605,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257748',4907606,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257748',4907607,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257748',4907608,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257748',4907609,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257748',4907610,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257749',4907611,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257749',4907612,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257749',4907613,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257749',4907614,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257749',4907615,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257749',4907616,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257749',4907617,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257749',4907618,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257749',4907619,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257749',4907620,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257749',4907621,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257749',4907622,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257749',4907623,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257749',4907624,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257749',4907625,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257750',4907626,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257750',4907627,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257750',4907628,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257750',4907629,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257750',4907630,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257750',4907631,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257750',4907632,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257750',4907633,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257750',4907634,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257750',4907635,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257750',4907636,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257750',4907637,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257750',4907638,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257750',4907639,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257750',4907640,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257751',4907641,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257751',4907642,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257751',4907643,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257751',4907644,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257751',4907645,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257751',4907646,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257751',4907647,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257751',4907648,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257751',4907649,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257751',4907650,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257751',4907651,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257751',4907652,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257751',4907653,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257751',4907654,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257751',4907655,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257752',4907656,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257752',4907657,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257752',4907658,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257752',4907659,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257752',4907660,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257752',4907661,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257752',4907662,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257752',4907663,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257752',4907664,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257752',4907665,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257752',4907666,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257752',4907667,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257752',4907668,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257752',4907669,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257752',4907670,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257753',4907671,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257753',4907672,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257753',4907673,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257753',4907674,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257753',4907675,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257753',4907676,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257753',4907677,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257753',4907678,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257753',4907679,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257753',4907680,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257753',4907681,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257753',4907682,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257753',4907683,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257753',4907684,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257753',4907685,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257754',4907686,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257754',4907687,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257754',4907688,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257754',4907689,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257754',4907690,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257754',4907691,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257754',4907692,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257754',4907693,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257754',4907694,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257754',4907695,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257754',4907696,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257754',4907697,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257754',4907698,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257754',4907699,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257754',4907700,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257755',4907701,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257755',4907702,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257755',4907703,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257755',4907704,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257755',4907705,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257755',4907706,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257755',4907707,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257755',4907708,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257755',4907709,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257755',4907710,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257755',4907711,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257755',4907712,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257755',4907713,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257755',4907714,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257755',4907715,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257756',4907716,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257756',4907717,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257756',4907718,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257756',4907719,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257756',4907720,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257756',4907721,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257756',4907722,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257756',4907723,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257756',4907724,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257756',4907725,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257756',4907726,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257756',4907727,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257756',4907728,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257756',4907729,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257756',4907730,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257757',4907731,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257757',4907732,'1810','267',1662395.80,1662395.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257757',4907733,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257757',4907734,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257757',4907735,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257757',4907736,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257757',4907737,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257757',4907738,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257757',4907739,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257757',4907740,'1818','267',1275615.88,1275615.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257757',4907741,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257757',4907742,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257757',4907743,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257757',4907744,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257757',4907745,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257758',4907746,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257758',4907747,'1810','267',1662395.80,1662685.80,290.00,47850.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257758',4907748,'1811','267',2157828.68,2157828.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257758',4907749,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257758',4907750,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257758',4907751,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257758',4907752,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257758',4907753,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257758',4907754,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257758',4907755,'1818','267',1275615.88,1279982.76,4366.88,720535.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','257758',4907756,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257758',4907757,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257758',4907758,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257758',4907759,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257758',4907760,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257759',4907761,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257759',4907762,'1810','267',1662685.80,1662685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257759',4907763,'1811','267',2157828.68,2161033.03,3204.35,528717.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','257759',4907764,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257759',4907765,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257759',4907766,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257759',4907767,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257759',4907768,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257759',4907769,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257759',4907770,'1818','267',1279982.76,1279982.76,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257759',4907771,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257759',4907772,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257759',4907773,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257759',4907774,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257759',4907775,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257760',4907776,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257760',4907777,'1810','267',1662685.80,1662685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257760',4907778,'1811','267',2161033.03,2161033.03,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257760',4907779,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257760',4907780,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257760',4907781,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257760',4907782,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257760',4907783,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257760',4907784,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257760',4907785,'1818','267',1279982.76,1282851.67,2868.91,530748.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','257760',4907786,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257760',4907787,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257760',4907788,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257760',4907789,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257760',4907790,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257761',4907791,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257761',4907792,'1810','267',1662685.80,1662685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257761',4907793,'1811','267',2161033.03,2165384.06,4351.03,804940.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','257761',4907794,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257761',4907795,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257761',4907796,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257761',4907797,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257761',4907798,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257761',4907799,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257761',4907800,'1818','267',1282851.67,1282851.67,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257761',4907801,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257761',4907802,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257761',4907803,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257761',4907804,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257761',4907805,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257762',4907806,'1809','267',2183439.35,2183439.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257762',4907807,'1810','267',1662685.80,1662685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257762',4907808,'1811','267',2165384.06,2167486.90,2102.84,346968.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','257762',4907809,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257762',4907810,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257762',4907811,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257762',4907812,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257762',4907813,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257762',4907814,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257762',4907815,'1818','267',1282851.67,1285251.29,2399.62,395937.30,0.00,0.00,0.00,0.00,0.00),('5','89','665','257762',4907816,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257762',4907817,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257762',4907818,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257762',4907819,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257762',4907820,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257763',4907821,'1809','267',2183439.35,2188992.59,5553.24,1027349.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','257763',4907822,'1810','267',1662685.80,1662685.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257763',4907823,'1811','267',2167486.90,2167486.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257763',4907824,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257763',4907825,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257763',4907826,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257763',4907827,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257763',4907828,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257763',4907829,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257763',4907830,'1818','267',1285251.29,1287108.82,1857.53,343643.05,0.00,0.00,0.00,0.00,0.00),('5','89','665','257763',4907831,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257763',4907832,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257763',4907833,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257763',4907834,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257763',4907835,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257764',4907836,'1809','267',2188992.59,2193950.31,4957.72,917178.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','257764',4907837,'1810','267',1662685.80,1662713.31,27.51,5089.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','257764',4907838,'1811','267',2167486.90,2171986.93,4500.03,832505.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','257764',4907839,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257764',4907840,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257764',4907841,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257764',4907842,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257764',4907843,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257764',4907844,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257764',4907845,'1818','267',1287108.82,1287108.82,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257764',4907846,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257764',4907847,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257764',4907848,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257764',4907849,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257764',4907850,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257765',4907851,'1809','267',2193950.31,2195574.39,1624.08,300454.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','257765',4907852,'1810','267',1662713.31,1666861.11,4147.80,767343.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257765',4907853,'1811','267',2171986.93,2173986.93,2000.00,370000.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257765',4907854,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257765',4907855,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257765',4907856,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257765',4907857,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257765',4907858,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257765',4907859,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257765',4907860,'1818','267',1287108.82,1288838.26,1729.44,319946.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','257765',4907861,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257765',4907862,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257765',4907863,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257765',4907864,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257765',4907865,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257766',4907866,'1809','267',2195574.39,2196743.35,1168.96,216257.60,0.00,0.00,0.00,0.00,0.00),('5','89','663','257766',4907867,'1810','267',1666861.11,1672809.50,5948.39,1100452.15,0.00,0.00,0.00,0.00,0.00),('5','89','662','257766',4907868,'1811','267',2173986.93,2174464.89,477.96,88422.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','257766',4907869,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257766',4907870,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257766',4907871,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257766',4907872,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257766',4907873,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257766',4907874,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257766',4907875,'1818','267',1288838.26,1289440.57,602.31,111427.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','257766',4907876,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257766',4907877,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257766',4907878,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257766',4907879,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257766',4907880,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257767',4907881,'1809','267',2196743.35,2196743.35,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257767',4907882,'1810','267',1672809.50,1673413.35,603.85,111712.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257767',4907883,'1811','267',2174464.89,2181464.89,7000.00,1295000.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257767',4907884,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257767',4907885,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257767',4907886,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257767',4907887,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257767',4907888,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257767',4907889,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257767',4907890,'1818','267',1289440.57,1289440.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257767',4907891,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257767',4907892,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257767',4907893,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257767',4907894,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257767',4907895,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257768',4907896,'1809','267',2196743.35,2200507.16,3763.81,696304.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','257768',4907897,'1810','267',1673413.35,1674030.41,617.06,114156.10,0.00,0.00,0.00,0.00,0.00),('5','89','662','257768',4907898,'1811','267',2181464.89,2181464.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257768',4907899,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257768',4907900,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257768',4907901,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257768',4907902,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257768',4907903,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257768',4907904,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257768',4907905,'1818','267',1289440.57,1289440.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257768',4907906,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257768',4907907,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257768',4907908,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257768',4907909,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257768',4907910,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257769',4907911,'1809','267',2200507.16,2205193.24,4686.08,866924.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','257769',4907912,'1810','267',1674030.41,1674982.26,951.85,176092.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257769',4907913,'1811','267',2181464.89,2181464.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257769',4907914,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257769',4907915,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257769',4907916,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257769',4907917,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257769',4907918,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257769',4907919,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257769',4907920,'1818','267',1289440.57,1289440.57,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257769',4907921,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257769',4907922,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257769',4907923,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257769',4907924,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257769',4907925,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257770',4907926,'1809','267',2205193.24,2205667.49,474.25,87736.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','257770',4907927,'1810','267',1674982.26,1675287.57,305.31,56482.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','257770',4907928,'1811','267',2181464.89,2185618.42,4153.53,768403.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257770',4907929,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257770',4907930,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257770',4907931,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257770',4907932,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257770',4907933,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257770',4907934,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257770',4907935,'1818','267',1289440.57,1293333.98,3893.41,720280.85,0.00,0.00,0.00,0.00,0.00),('5','89','665','257770',4907936,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257770',4907937,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257770',4907938,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257770',4907939,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257770',4907940,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257771',4907941,'1809','267',2205667.49,2205667.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257771',4907942,'1810','267',1675287.57,1675505.29,217.72,40278.20,0.00,0.00,0.00,0.00,0.00),('5','89','662','257771',4907943,'1811','267',2185618.42,2191376.92,5758.50,1065322.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','257771',4907944,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257771',4907945,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257771',4907946,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257771',4907947,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257771',4907948,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257771',4907949,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257771',4907950,'1818','267',1293333.98,1296285.72,2951.74,546071.90,0.00,0.00,0.00,0.00,0.00),('5','89','665','257771',4907951,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257771',4907952,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257771',4907953,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257771',4907954,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257771',4907955,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257772',4907956,'1809','267',2205667.49,2205667.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257772',4907957,'1810','267',1675505.29,1675505.29,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257772',4907958,'1811','267',2191376.92,2197930.60,6553.68,1212430.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','257772',4907959,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257772',4907960,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257772',4907961,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257772',4907962,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257772',4907963,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257772',4907964,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257772',4907965,'1818','267',1296285.72,1298316.82,2031.10,375753.50,0.00,0.00,0.00,0.00,0.00),('5','89','665','257772',4907966,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257772',4907967,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257772',4907968,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257772',4907969,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257772',4907970,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257773',4907971,'1809','267',2205667.49,2205667.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257773',4907972,'1810','267',1675505.29,1676739.37,1234.08,228304.80,0.00,0.00,0.00,0.00,0.00),('5','89','662','257773',4907973,'1811','267',2197930.60,2202957.82,5027.22,930035.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257773',4907974,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257773',4907975,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257773',4907976,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257773',4907977,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257773',4907978,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257773',4907979,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257773',4907980,'1818','267',1298316.82,1300611.83,2295.01,424576.85,0.00,0.00,0.00,0.00,0.00),('5','89','665','257773',4907981,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257773',4907982,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257773',4907983,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257773',4907984,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257773',4907985,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257774',4907986,'1809','267',2205667.49,2205667.49,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257774',4907987,'1810','267',1676739.37,1677174.80,435.43,80554.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257774',4907988,'1811','267',2202957.82,2208592.49,5634.67,1042413.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','257774',4907989,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257774',4907990,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257774',4907991,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257774',4907992,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257774',4907993,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257774',4907994,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257774',4907995,'1818','267',1300611.83,1304934.24,4322.41,799645.85,0.00,0.00,0.00,0.00,0.00),('5','89','665','257774',4907996,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257774',4907997,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257774',4907998,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257774',4907999,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257774',4908000,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257775',4908001,'1809','267',2205667.49,2206000.61,333.12,61627.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','257775',4908002,'1810','267',1677174.80,1683571.52,6396.72,1183393.20,0.00,0.00,0.00,0.00,0.00),('5','89','662','257775',4908003,'1811','267',2208592.49,2210418.14,1825.65,337745.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257775',4908004,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257775',4908005,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257775',4908006,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257775',4908007,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257775',4908008,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257775',4908009,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257775',4908010,'1818','267',1304934.24,1305089.21,154.97,28669.45,0.00,0.00,0.00,0.00,0.00),('5','89','665','257775',4908011,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257775',4908012,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257775',4908013,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257775',4908014,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257775',4908015,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257776',4908016,'1809','267',2206000.61,2210758.78,4758.17,880261.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','257776',4908017,'1810','267',1683571.52,1687569.28,3997.76,739585.60,0.00,0.00,0.00,0.00,0.00),('5','89','662','257776',4908018,'1811','267',2210418.14,2210418.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257776',4908019,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257776',4908020,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257776',4908021,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257776',4908022,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257776',4908023,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257776',4908024,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257776',4908025,'1818','267',1305089.21,1305089.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257776',4908026,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257776',4908027,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257776',4908028,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257776',4908029,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257776',4908030,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257777',4908031,'1809','267',2210758.78,2214783.70,4024.92,744610.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','257777',4908032,'1810','267',1687569.28,1692012.29,4443.01,821956.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','257777',4908033,'1811','267',2210418.14,2210418.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257777',4908034,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257777',4908035,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257777',4908036,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257777',4908037,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257777',4908038,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257777',4908039,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257777',4908040,'1818','267',1305089.21,1305089.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257777',4908041,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257777',4908042,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257777',4908043,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257777',4908044,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257777',4908045,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257778',4908046,'1809','267',2214783.70,2218402.10,3618.40,669404.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257778',4908047,'1810','267',1692012.29,1695425.97,3413.68,631530.80,0.00,0.00,0.00,0.00,0.00),('5','89','662','257778',4908048,'1811','267',2210418.14,2210418.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257778',4908049,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257778',4908050,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257778',4908051,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257778',4908052,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257778',4908053,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257778',4908054,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257778',4908055,'1818','267',1305089.21,1305089.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257778',4908056,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257778',4908057,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257778',4908058,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257778',4908059,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257778',4908060,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257779',4908061,'1809','267',2218402.10,2219088.80,686.70,127039.50,0.00,0.00,0.00,0.00,0.00),('5','89','663','257779',4908062,'1810','267',1695425.97,1701446.58,6020.61,1113812.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','257779',4908063,'1811','267',2210418.14,2210418.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257779',4908064,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257779',4908065,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257779',4908066,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257779',4908067,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257779',4908068,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257779',4908069,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257779',4908070,'1818','267',1305089.21,1305089.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257779',4908071,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257779',4908072,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257779',4908073,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257779',4908074,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257779',4908075,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257780',4908076,'1809','267',2219088.80,2219088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257780',4908077,'1810','267',1701446.58,1701446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257780',4908078,'1811','267',2210418.14,2210418.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257780',4908079,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257780',4908080,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257780',4908081,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257780',4908082,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257780',4908083,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257780',4908084,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257780',4908085,'1818','267',1305089.21,1305089.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257780',4908086,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257780',4908087,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257780',4908088,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257780',4908089,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257780',4908090,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257781',4908091,'1809','267',2219088.80,2219088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257781',4908092,'1810','267',1701446.58,1701446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257781',4908093,'1811','267',2210418.14,2210418.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257781',4908094,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257781',4908095,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257781',4908096,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257781',4908097,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257781',4908098,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257781',4908099,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257781',4908100,'1818','267',1305089.21,1305089.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257781',4908101,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257781',4908102,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257781',4908103,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257781',4908104,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257781',4908105,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257782',4908106,'1809','267',2219088.80,2219088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257782',4908107,'1810','267',1701446.58,1701446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257782',4908108,'1811','267',2210418.14,2210418.14,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257782',4908109,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257782',4908110,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257782',4908111,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257782',4908112,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257782',4908113,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257782',4908114,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257782',4908115,'1818','267',1305089.21,1305089.21,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257782',4908116,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257782',4908117,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257782',4908118,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257782',4908119,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257782',4908120,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257783',4908121,'1809','267',2219088.80,2219088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257783',4908122,'1810','267',1701446.58,1701446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257783',4908123,'1811','267',2210418.14,2211021.21,603.07,111567.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','257783',4908124,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257783',4908125,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257783',4908126,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257783',4908127,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257783',4908128,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257783',4908129,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257783',4908130,'1818','267',1305089.21,1306342.21,1253.00,231805.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257783',4908131,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257783',4908132,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257783',4908133,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257783',4908134,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257783',4908135,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257784',4908136,'1809','267',2219088.80,2219088.80,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257784',4908137,'1810','267',1701446.58,1701446.58,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257784',4908138,'1811','267',2211021.21,2217456.02,6434.81,1190439.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','257784',4908139,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257784',4908140,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257784',4908141,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257784',4908142,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257784',4908143,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257784',4908144,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257784',4908145,'1818','267',1306342.21,1310698.28,4356.07,805872.95,0.00,0.00,0.00,0.00,0.00),('5','89','665','257784',4908146,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257784',4908147,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257784',4908148,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257784',4908149,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257784',4908150,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257785',4908151,'1809','267',2219088.80,2223099.21,4010.41,741925.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','257785',4908152,'1810','267',1701446.58,1705215.36,3768.78,697224.30,0.00,0.00,0.00,0.00,0.00),('5','89','662','257785',4908153,'1811','267',2217456.02,2217471.47,15.45,2858.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257785',4908154,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257785',4908155,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257785',4908156,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257785',4908157,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257785',4908158,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257785',4908159,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257785',4908160,'1818','267',1310698.28,1314235.48,3537.20,654382.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257785',4908161,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257785',4908162,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257785',4908163,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257785',4908164,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257785',4908165,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257786',4908166,'1809','267',2223099.21,2226978.79,3879.58,717722.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','257786',4908167,'1810','267',1705215.36,1707622.32,2406.96,445287.60,0.00,0.00,0.00,0.00,0.00),('5','89','662','257786',4908168,'1811','267',2217471.47,2217471.47,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257786',4908169,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257786',4908170,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257786',4908171,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257786',4908172,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257786',4908173,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257786',4908174,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257786',4908175,'1818','267',1314235.48,1318727.07,4491.59,830944.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','257786',4908176,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257786',4908177,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257786',4908178,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257786',4908179,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257786',4908180,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257787',4908181,'1809','267',2226978.79,2227399.16,420.37,77768.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','257787',4908182,'1810','267',1707622.32,1712871.01,5248.69,971007.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','257787',4908183,'1811','267',2217471.47,2218184.08,712.61,131832.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','257787',4908184,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257787',4908185,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257787',4908186,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257787',4908187,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257787',4908188,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257787',4908189,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257787',4908190,'1818','267',1318727.07,1323044.93,4317.86,798804.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','257787',4908191,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257787',4908192,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257787',4908193,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257787',4908194,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257787',4908195,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257788',4908196,'1809','267',2227399.16,2227399.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257788',4908197,'1810','267',1712871.01,1716801.90,3930.89,727214.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','257788',4908198,'1811','267',2218184.08,2222563.31,4379.23,810157.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','257788',4908199,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257788',4908200,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257788',4908201,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257788',4908202,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257788',4908203,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257788',4908204,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257788',4908205,'1818','267',1323044.93,1327585.76,4540.83,840053.55,0.00,0.00,0.00,0.00,0.00),('5','89','665','257788',4908206,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257788',4908207,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257788',4908208,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257788',4908209,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257788',4908210,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257789',4908211,'1809','267',2227399.16,2229425.71,2026.55,374911.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','257789',4908212,'1810','267',1716801.90,1720908.89,4106.99,759793.15,0.00,0.00,0.00,0.00,0.00),('5','89','662','257789',4908213,'1811','267',2222563.31,2222829.29,265.98,49206.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257789',4908214,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257789',4908215,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257789',4908216,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257789',4908217,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257789',4908218,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257789',4908219,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257789',4908220,'1818','267',1327585.76,1331327.56,3741.80,692233.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257789',4908221,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257789',4908222,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257789',4908223,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257789',4908224,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257789',4908225,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257790',4908226,'1809','267',2229425.71,2234567.88,5142.17,951301.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','257790',4908227,'1810','267',1720908.89,1724721.09,3812.20,705257.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257790',4908228,'1811','267',2222829.29,2223470.26,640.97,118579.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','257790',4908229,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257790',4908230,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257790',4908231,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257790',4908232,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257790',4908233,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257790',4908234,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257790',4908235,'1818','267',1331327.56,1331327.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257790',4908236,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257790',4908237,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257790',4908238,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257790',4908239,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257790',4908240,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257791',4908241,'1809','267',2234567.88,2237567.88,3000.00,555000.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257791',4908242,'1810','267',1724721.09,1724916.91,195.82,36226.70,0.00,0.00,0.00,0.00,0.00),('5','89','662','257791',4908243,'1811','267',2223470.26,2228109.03,4638.77,858172.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','257791',4908244,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257791',4908245,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257791',4908246,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257791',4908247,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257791',4908248,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257791',4908249,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257791',4908250,'1818','267',1331327.56,1335841.08,4513.52,835001.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','257791',4908251,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257791',4908252,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257791',4908253,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257791',4908254,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257791',4908255,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257792',4908256,'1809','267',2237567.88,2237567.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257792',4908257,'1810','267',1724916.91,1725092.68,175.77,32517.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','257792',4908258,'1811','267',2228109.03,2233539.96,5430.93,1004722.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257792',4908259,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257792',4908260,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257792',4908261,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257792',4908262,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257792',4908263,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257792',4908264,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257792',4908265,'1818','267',1335841.08,1341167.17,5326.09,985326.65,0.00,0.00,0.00,0.00,0.00),('5','89','665','257792',4908266,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257792',4908267,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257792',4908268,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257792',4908269,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257792',4908270,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257793',4908271,'1809','267',2237567.88,2237567.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257793',4908272,'1810','267',1725092.68,1725092.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257793',4908273,'1811','267',2233539.96,2233539.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257793',4908274,'1812','267',1272998.68,1272998.68,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257793',4908275,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257793',4908276,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257793',4908277,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257793',4908278,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257793',4908279,'1817','267',476033.62,476033.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257793',4908280,'1818','267',418.12,418.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257793',4908281,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257793',4908282,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257793',4908283,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257793',4908284,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257793',4908285,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257794',4908286,'1809','267',2237567.88,2237567.88,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257794',4908287,'1810','267',1725092.68,1728373.31,3280.63,606916.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257794',4908288,'1811','267',2233539.96,2233539.96,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257794',4908289,'1812','267',1272998.68,1275974.61,2975.93,550547.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257794',4908290,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257794',4908291,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257794',4908292,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257794',4908293,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257794',4908294,'1817','267',1341167.17,1343874.38,2707.21,500833.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','257794',4908295,'1818','267',418.12,418.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257794',4908296,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257794',4908297,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257794',4908298,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257794',4908299,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257794',4908300,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257795',4908301,'1809','267',2237567.88,2237613.81,45.93,8497.05,0.00,0.00,0.00,0.00,0.00),('5','89','663','257795',4908302,'1810','267',1728373.31,1731631.56,3258.25,602776.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257795',4908303,'1811','267',2233539.96,2237388.94,3848.98,712061.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257795',4908304,'1812','267',1275974.61,1277830.43,1855.82,343326.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257795',4908305,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257795',4908306,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257795',4908307,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257795',4908308,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257795',4908309,'1817','267',1343874.38,1351229.07,7354.69,1360617.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','257795',4908310,'1818','267',418.12,418.12,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257795',4908311,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257795',4908312,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257795',4908313,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257795',4908314,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257795',4908315,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257796',4908316,'1809','267',2237613.81,2237972.16,358.35,66294.75,0.00,0.00,0.00,0.00,0.00),('5','89','663','257796',4908317,'1810','267',1731631.56,1731631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257796',4908318,'1811','267',2237388.94,2240327.64,2938.70,543659.50,0.00,0.00,0.00,0.00,0.00),('5','89','664','257796',4908319,'1812','267',1277830.43,1282369.55,4539.12,839737.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','257796',4908320,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257796',4908321,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257796',4908322,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257796',4908323,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257796',4908324,'1817','267',1351229.07,1355394.89,4165.82,770676.70,0.00,0.00,0.00,0.00,0.00),('5','89','662','257796',4908325,'1818','267',418.12,875.81,457.69,84672.65,0.00,0.00,0.00,0.00,0.00),('5','89','665','257796',4908326,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257796',4908327,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257796',4908328,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257796',4908329,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257796',4908330,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257797',4908331,'1809','267',2237972.16,2237972.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257797',4908332,'1810','267',1731631.56,1731631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257797',4908333,'1811','267',2240327.64,2245553.15,5225.51,966719.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257797',4908334,'1812','267',1282369.55,1283684.66,1315.11,243295.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257797',4908335,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257797',4908336,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257797',4908337,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257797',4908338,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257797',4908339,'1817','267',1355394.89,1360951.50,5556.61,1027972.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','257797',4908340,'1818','267',875.81,1673.81,798.00,147630.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257797',4908341,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257797',4908342,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257797',4908343,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257797',4908344,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257797',4908345,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257798',4908346,'1809','267',2237972.16,2237972.16,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257798',4908347,'1810','267',1731631.56,1731631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257798',4908348,'1811','267',2245553.15,2248111.64,2558.49,473320.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','257798',4908349,'1812','267',1283684.66,1286441.93,2757.27,510094.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','257798',4908350,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257798',4908351,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257798',4908352,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257798',4908353,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257798',4908354,'1817','267',1360951.50,1365648.42,4696.92,868930.20,0.00,0.00,0.00,0.00,0.00),('5','89','662','257798',4908355,'1818','267',1673.81,4111.25,2437.44,450926.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','257798',4908356,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257798',4908357,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257798',4908358,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257798',4908359,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257798',4908360,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257799',4908361,'1809','267',2237972.16,2238915.89,943.73,174590.05,0.00,0.00,0.00,0.00,0.00),('5','89','663','257799',4908362,'1810','267',1731631.56,1731631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257799',4908363,'1811','267',2248111.64,2252645.20,4533.56,838708.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','257799',4908364,'1812','267',1286441.93,1287430.91,988.98,182961.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257799',4908365,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257799',4908366,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257799',4908367,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257799',4908368,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257799',4908369,'1817','267',1365648.42,1367355.43,1707.01,315796.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','257799',4908370,'1818','267',4111.25,8085.68,3974.43,735269.55,0.00,0.00,0.00,0.00,0.00),('5','89','665','257799',4908371,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257799',4908372,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257799',4908373,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257799',4908374,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257799',4908375,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257800',4908376,'1809','267',2238915.89,2238915.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257800',4908377,'1810','267',1731631.56,1731631.56,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257800',4908378,'1811','267',2252645.20,2255609.91,2964.71,548471.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257800',4908379,'1812','267',1287430.91,1294618.90,7187.99,1329778.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257800',4908380,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257800',4908381,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257800',4908382,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257800',4908383,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257800',4908384,'1817','267',1367355.43,1367355.43,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257800',4908385,'1818','267',8085.68,10756.46,2670.78,494094.30,0.00,0.00,0.00,0.00,0.00),('5','89','665','257800',4908386,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257800',4908387,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257800',4908388,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257800',4908389,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257800',4908390,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257801',4908391,'1809','267',2238915.89,2238915.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257801',4908392,'1810','267',1731631.56,1731638.59,7.03,1300.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257801',4908393,'1811','267',2255609.91,2258306.56,2696.65,498880.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257801',4908394,'1812','267',1294618.90,1298721.94,4103.04,759062.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','257801',4908395,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257801',4908396,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257801',4908397,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257801',4908398,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257801',4908399,'1817','267',1367355.43,1367428.74,73.31,13562.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','257801',4908400,'1818','267',10756.46,13401.77,2645.31,489382.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','257801',4908401,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257801',4908402,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257801',4908403,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257801',4908404,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257801',4908405,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257802',4908406,'1809','267',2238915.89,2241867.38,2951.49,546025.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','257802',4908407,'1810','267',1731638.59,1731638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257802',4908408,'1811','267',2258306.56,2261220.13,2913.57,539010.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','257802',4908409,'1812','267',1298721.94,1303071.88,4349.94,804738.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','257802',4908410,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257802',4908411,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257802',4908412,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257802',4908413,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257802',4908414,'1817','267',1367428.74,1367428.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257802',4908415,'1818','267',13401.77,17393.33,3991.56,738438.60,0.00,0.00,0.00,0.00,0.00),('5','89','665','257802',4908416,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257802',4908417,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257802',4908418,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257802',4908419,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257802',4908420,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257803',4908421,'1809','267',2241867.38,2241867.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257803',4908422,'1810','267',1731638.59,1731638.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257803',4908423,'1811','267',2261220.13,2265293.98,4073.85,753662.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257803',4908424,'1812','267',1303071.88,1303405.10,333.22,61645.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257803',4908425,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257803',4908426,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257803',4908427,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257803',4908428,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257803',4908429,'1817','267',1367428.74,1371522.17,4093.43,757284.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257803',4908430,'1818','267',17393.33,21120.25,3726.92,689480.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','257803',4908431,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257803',4908432,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257803',4908433,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257803',4908434,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257803',4908435,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257804',4908436,'1809','267',2241867.38,2243339.15,1471.77,272277.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','257804',4908437,'1810','267',1731638.59,1732949.65,1311.06,242546.10,0.00,0.00,0.00,0.00,0.00),('5','89','662','257804',4908438,'1811','267',2265293.98,2268444.54,3150.56,582853.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','257804',4908439,'1812','267',1303405.10,1306272.37,2867.27,530444.95,0.00,0.00,0.00,0.00,0.00),('5','89','664','257804',4908440,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257804',4908441,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257804',4908442,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257804',4908443,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257804',4908444,'1817','267',1371522.17,1373983.40,2461.23,455327.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257804',4908445,'1818','267',21120.25,22759.89,1639.64,303333.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','257804',4908446,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257804',4908447,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257804',4908448,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257804',4908449,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257804',4908450,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257805',4908451,'1809','267',2243339.15,2247554.54,4215.39,779847.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','257805',4908452,'1810','267',1732949.65,1736361.22,3411.57,631140.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','257805',4908453,'1811','267',2268444.54,2268444.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257805',4908454,'1812','267',1306272.37,1310868.15,4595.78,850219.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257805',4908455,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257805',4908456,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257805',4908457,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257805',4908458,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257805',4908459,'1817','267',1373983.40,1373983.40,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257805',4908460,'1818','267',22759.89,22759.89,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257805',4908461,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257805',4908462,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257805',4908463,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257805',4908464,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257805',4908465,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257806',4908466,'1809','267',2247554.54,2250183.13,2628.59,486289.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','257806',4908467,'1810','267',1736361.22,1739446.19,3084.97,570719.45,0.00,0.00,0.00,0.00,0.00),('5','89','662','257806',4908468,'1811','267',2268444.54,2268444.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257806',4908469,'1812','267',1310868.15,1312601.47,1733.32,320664.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','257806',4908470,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257806',4908471,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257806',4908472,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257806',4908473,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257806',4908474,'1817','267',1373983.40,1375864.95,1881.55,348086.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257806',4908475,'1818','267',22759.89,26472.77,3712.88,686882.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','257806',4908476,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257806',4908477,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257806',4908478,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257806',4908479,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257806',4908480,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257807',4908481,'1809','267',2250183.13,2252985.45,2802.32,518429.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','257807',4908482,'1810','267',1739446.19,1742190.32,2744.13,507664.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257807',4908483,'1811','267',2268444.54,2268444.54,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257807',4908484,'1812','267',1312601.47,1314648.71,2047.24,378739.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','257807',4908485,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257807',4908486,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257807',4908487,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257807',4908488,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257807',4908489,'1817','267',1375864.95,1383362.20,7497.25,1386991.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257807',4908490,'1818','267',26472.77,29454.99,2982.22,551710.70,0.00,0.00,0.00,0.00,0.00),('5','89','665','257807',4908491,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257807',4908492,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257807',4908493,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257807',4908494,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257807',4908495,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257808',4908496,'1809','267',2252985.45,2252985.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257808',4908497,'1810','267',1742190.32,1742190.32,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257808',4908498,'1811','267',2268444.54,2271619.45,3174.91,587358.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257808',4908499,'1812','267',1314648.71,1318473.04,3824.33,707501.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257808',4908500,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257808',4908501,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257808',4908502,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257808',4908503,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257808',4908504,'1817','267',1383362.20,1387124.40,3762.20,696007.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257808',4908505,'1818','267',29454.99,32989.97,3534.98,653971.30,0.00,0.00,0.00,0.00,0.00),('5','89','665','257808',4908506,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257808',4908507,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257808',4908508,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257808',4908509,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257808',4908510,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257809',4908511,'1809','267',2252985.45,2257660.24,4674.79,864836.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','257809',4908512,'1810','267',1742190.32,1742262.28,71.96,13312.60,0.00,0.00,0.00,0.00,0.00),('5','89','662','257809',4908513,'1811','267',2271619.45,2274478.64,2859.19,528950.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257809',4908514,'1812','267',1318473.04,1323003.60,4530.56,838153.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','257809',4908515,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257809',4908516,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257809',4908517,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257809',4908518,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257809',4908519,'1817','267',1387124.40,1391702.25,4577.85,846902.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257809',4908520,'1818','267',32989.97,36108.81,3118.84,576985.40,0.00,0.00,0.00,0.00,0.00),('5','89','665','257809',4908521,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257809',4908522,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257809',4908523,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257809',4908524,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257809',4908525,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257810',4908526,'1809','267',2257660.24,2261015.73,3355.49,620765.65,0.00,0.00,0.00,0.00,0.00),('5','89','663','257810',4908527,'1810','267',1742262.28,1744889.21,2626.93,485982.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257810',4908528,'1811','267',2274478.64,2276609.08,2130.44,394131.40,0.00,0.00,0.00,0.00,0.00),('5','89','664','257810',4908529,'1812','267',1323003.60,1325448.69,2445.09,452341.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','257810',4908530,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257810',4908531,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257810',4908532,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257810',4908533,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257810',4908534,'1817','267',1391702.25,1394587.90,2885.65,533845.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257810',4908535,'1818','267',36108.81,36108.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257810',4908536,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257810',4908537,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257810',4908538,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257810',4908539,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257810',4908540,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257811',4908541,'1809','267',2261015.73,2262026.85,1011.12,187057.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','257811',4908542,'1810','267',1744889.21,1745650.77,761.56,140888.60,0.00,0.00,0.00,0.00,0.00),('5','89','662','257811',4908543,'1811','267',2276609.08,2279581.71,2972.63,549936.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','257811',4908544,'1812','267',1325448.69,1328646.38,3197.69,591572.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','257811',4908545,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257811',4908546,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257811',4908547,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257811',4908548,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257811',4908549,'1817','267',1394587.90,1398145.76,3557.86,658204.10,0.00,0.00,0.00,0.00,0.00),('5','89','662','257811',4908550,'1818','267',36108.81,36108.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257811',4908551,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257811',4908552,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257811',4908553,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257811',4908554,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257811',4908555,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257812',4908556,'1809','267',2262026.85,2265608.04,3581.19,662520.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','257812',4908557,'1810','267',1745650.77,1749285.22,3634.45,672373.25,0.00,0.00,0.00,0.00,0.00),('5','89','662','257812',4908558,'1811','267',2279581.71,2283004.84,3423.13,633279.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257812',4908559,'1812','267',1328646.38,1331256.26,2609.88,482827.80,0.00,0.00,0.00,0.00,0.00),('5','89','664','257812',4908560,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257812',4908561,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257812',4908562,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257812',4908563,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257812',4908564,'1817','267',1398145.76,1401956.42,3810.66,704972.10,0.00,0.00,0.00,0.00,0.00),('5','89','662','257812',4908565,'1818','267',36108.81,36108.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257812',4908566,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257812',4908567,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257812',4908568,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257812',4908569,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257812',4908570,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257813',4908571,'1809','267',2265608.04,2269398.95,3790.91,701318.35,0.00,0.00,0.00,0.00,0.00),('5','89','663','257813',4908572,'1810','267',1749285.22,1752627.55,3342.33,618331.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257813',4908573,'1811','267',2283004.84,2286532.43,3527.59,652604.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257813',4908574,'1812','267',1331256.26,1334158.17,2901.91,536853.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257813',4908575,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257813',4908576,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257813',4908577,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257813',4908578,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257813',4908579,'1817','267',1401956.42,1406126.06,4169.64,771383.40,0.00,0.00,0.00,0.00,0.00),('5','89','662','257813',4908580,'1818','267',36108.81,36108.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257813',4908581,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257813',4908582,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257813',4908583,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257813',4908584,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257813',4908585,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257814',4908586,'1809','267',2269398.95,2273089.00,3690.05,682659.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','257814',4908587,'1810','267',1752627.55,1755454.83,2827.28,523046.80,0.00,0.00,0.00,0.00,0.00),('5','89','662','257814',4908588,'1811','267',2286532.43,2289491.49,2959.06,547426.10,0.00,0.00,0.00,0.00,0.00),('5','89','664','257814',4908589,'1812','267',1334158.17,1336923.55,2765.38,511595.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257814',4908590,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257814',4908591,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257814',4908592,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257814',4908593,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257814',4908594,'1817','267',1406126.06,1409821.95,3695.89,683739.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','257814',4908595,'1818','267',36108.81,36108.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257814',4908596,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257814',4908597,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257814',4908598,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257814',4908599,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257814',4908600,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257815',4908601,'1809','267',2273089.00,2276297.08,3208.08,593494.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','257815',4908602,'1810','267',1755454.83,1758345.02,2890.19,534685.15,0.00,0.00,0.00,0.00,0.00),('5','89','662','257815',4908603,'1811','267',2289491.49,2292287.68,2796.19,517295.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257815',4908604,'1812','267',1336923.55,1339599.10,2675.55,494976.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','257815',4908605,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257815',4908606,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257815',4908607,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257815',4908608,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257815',4908609,'1817','267',1409821.95,1413835.75,4013.80,742553.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257815',4908610,'1818','267',36108.81,36108.81,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257815',4908611,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257815',4908612,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257815',4908613,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257815',4908614,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257815',4908615,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257816',4908616,'1809','267',2276297.08,2278794.05,2496.97,461939.45,0.00,0.00,0.00,0.00,0.00),('5','89','663','257816',4908617,'1810','267',1758345.02,1759571.62,1226.60,226921.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257816',4908618,'1811','267',2292287.68,2293083.90,796.22,147300.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257816',4908619,'1812','267',1339599.10,1345503.39,5904.29,1092293.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','257816',4908620,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257816',4908621,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257816',4908622,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257816',4908623,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257816',4908624,'1817','267',1413835.75,1414928.93,1093.18,202238.30,0.00,0.00,0.00,0.00,0.00),('5','89','662','257816',4908625,'1818','267',36108.81,36392.33,283.52,52451.20,0.00,0.00,0.00,0.00,0.00),('5','89','665','257816',4908626,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257816',4908627,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257816',4908628,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257816',4908629,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257816',4908630,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257817',4908631,'1809','267',2278794.05,2278794.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257817',4908632,'1810','267',1759571.62,1759571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257817',4908633,'1811','267',2293083.90,2293083.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257817',4908634,'1812','267',1345503.39,1350824.34,5320.95,984375.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','257817',4908635,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257817',4908636,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257817',4908637,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257817',4908638,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257817',4908639,'1817','267',1414928.93,1414928.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257817',4908640,'1818','267',36392.33,36392.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257817',4908641,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257817',4908642,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257817',4908643,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257817',4908644,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257817',4908645,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257818',4908646,'1809','267',2278794.05,2278794.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257818',4908647,'1810','267',1759571.62,1759571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257818',4908648,'1811','267',2293083.90,2293083.90,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257818',4908649,'1812','267',1350824.34,1352707.34,1883.00,348355.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257818',4908650,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257818',4908651,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257818',4908652,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257818',4908653,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257818',4908654,'1817','267',1414928.93,1414928.93,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257818',4908655,'1818','267',36392.33,36392.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257818',4908656,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257818',4908657,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257818',4908658,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257818',4908659,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257818',4908660,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257819',4908661,'1809','267',2278794.05,2278794.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257819',4908662,'1810','267',1759571.62,1759571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257819',4908663,'1811','267',2293083.90,2293780.03,696.13,128784.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257819',4908664,'1812','267',1352707.34,1352707.34,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257819',4908665,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257819',4908666,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257819',4908667,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257819',4908668,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257819',4908669,'1817','267',1414928.93,1415531.93,603.00,111555.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257819',4908670,'1818','267',36392.33,36392.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257819',4908671,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257819',4908672,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257819',4908673,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257819',4908674,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257819',4908675,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257820',4908676,'1809','267',2278794.05,2278794.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257820',4908677,'1810','267',1759571.62,1759571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257820',4908678,'1811','267',2293780.03,2298847.57,5067.54,937494.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','257820',4908679,'1812','267',1352707.34,1352807.33,99.99,18498.15,0.00,0.00,0.00,0.00,0.00),('5','89','664','257820',4908680,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257820',4908681,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257820',4908682,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257820',4908683,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257820',4908684,'1817','267',1415531.93,1420105.91,4573.98,846186.30,0.00,0.00,0.00,0.00,0.00),('5','89','662','257820',4908685,'1818','267',36392.33,40138.28,3745.95,693000.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','257820',4908686,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257820',4908687,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257820',4908688,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257820',4908689,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257820',4908690,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257821',4908691,'1809','267',2278794.05,2278794.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257821',4908692,'1810','267',1759571.62,1759571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257821',4908693,'1811','267',2298847.57,2302695.98,3848.41,711955.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','257821',4908694,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257821',4908695,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257821',4908696,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257821',4908697,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257821',4908698,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257821',4908699,'1817','267',1420105.91,1423366.94,3261.03,603290.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257821',4908700,'1818','267',40138.28,43790.23,3651.95,675610.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','257821',4908701,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257821',4908702,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257821',4908703,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257821',4908704,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257821',4908705,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257822',4908706,'1809','267',2278794.05,2278794.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257822',4908707,'1810','267',1759571.62,1759571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257822',4908708,'1811','267',2302695.98,2307139.00,4443.02,821958.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257822',4908709,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257822',4908710,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257822',4908711,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257822',4908712,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257822',4908713,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257822',4908714,'1817','267',1423366.94,1428990.35,5623.41,1040330.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','257822',4908715,'1818','267',43790.23,47244.29,3454.06,639001.10,0.00,0.00,0.00,0.00,0.00),('5','89','665','257822',4908716,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257822',4908717,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257822',4908718,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257822',4908719,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257822',4908720,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257823',4908721,'1809','267',2278794.05,2278794.05,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257823',4908722,'1810','267',1759571.62,1759571.62,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257823',4908723,'1811','267',2307139.00,2311305.15,4166.15,770737.75,0.00,0.00,0.00,0.00,0.00),('5','89','664','257823',4908724,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257823',4908725,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257823',4908726,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257823',4908727,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257823',4908728,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257823',4908729,'1817','267',1428990.35,1432814.85,3824.50,707532.50,0.00,0.00,0.00,0.00,0.00),('5','89','662','257823',4908730,'1818','267',47244.29,50059.78,2815.49,520865.65,0.00,0.00,0.00,0.00,0.00),('5','89','665','257823',4908731,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257823',4908732,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257823',4908733,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257823',4908734,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257823',4908735,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257824',4908736,'1809','267',2278794.05,2284808.86,6014.81,1112739.85,0.00,0.00,0.00,0.00,0.00),('5','89','663','257824',4908737,'1810','267',1759571.62,1765334.09,5762.47,1066056.95,0.00,0.00,0.00,0.00,0.00),('5','89','662','257824',4908738,'1811','267',2311305.15,2311305.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257824',4908739,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257824',4908740,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257824',4908741,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257824',4908742,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257824',4908743,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257824',4908744,'1817','267',1432814.85,1432814.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257824',4908745,'1818','267',50059.78,50059.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257824',4908746,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257824',4908747,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257824',4908748,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257824',4908749,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257824',4908750,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257825',4908751,'1809','267',2284808.86,2290584.99,5776.13,1068584.05,0.00,0.00,0.00,0.00,0.00),('5','89','663','257825',4908752,'1810','267',1765334.09,1771138.18,5804.09,1073756.65,0.00,0.00,0.00,0.00,0.00),('5','89','662','257825',4908753,'1811','267',2311305.15,2311305.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257825',4908754,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257825',4908755,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257825',4908756,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257825',4908757,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257825',4908758,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257825',4908759,'1817','267',1432814.85,1432814.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257825',4908760,'1818','267',50059.78,50059.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257825',4908761,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257825',4908762,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257825',4908763,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257825',4908764,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257825',4908765,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257826',4908766,'1809','267',2290584.99,2296771.92,6186.93,1144582.05,0.00,0.00,0.00,0.00,0.00),('5','89','663','257826',4908767,'1810','267',1771138.18,1776717.30,5579.12,1032137.20,0.00,0.00,0.00,0.00,0.00),('5','89','662','257826',4908768,'1811','267',2311305.15,2311305.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257826',4908769,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257826',4908770,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257826',4908771,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257826',4908772,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257826',4908773,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257826',4908774,'1817','267',1432814.85,1432814.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257826',4908775,'1818','267',50059.78,50059.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257826',4908776,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257826',4908777,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257826',4908778,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257826',4908779,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257826',4908780,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257827',4908781,'1809','267',2296771.92,2299400.70,2628.78,486324.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','257827',4908782,'1810','267',1776717.30,1778913.38,2196.08,406274.80,0.00,0.00,0.00,0.00,0.00),('5','89','662','257827',4908783,'1811','267',2311305.15,2311305.15,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257827',4908784,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257827',4908785,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257827',4908786,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257827',4908787,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257827',4908788,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257827',4908789,'1817','267',1432814.85,1432814.85,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257827',4908790,'1818','267',50059.78,50059.78,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257827',4908791,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257827',4908792,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257827',4908793,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257827',4908794,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257827',4908795,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257828',4908796,'1809','267',2299400.70,2299400.70,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257828',4908797,'1810','267',1778913.38,1778913.38,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257828',4908798,'1811','267',2311305.15,2315785.37,4480.22,828840.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257828',4908799,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257828',4908800,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257828',4908801,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257828',4908802,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257828',4908803,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257828',4908804,'1817','267',1432814.85,1436891.68,4076.83,754213.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257828',4908805,'1818','267',50059.78,53258.00,3198.22,591670.70,0.00,0.00,0.00,0.00,0.00),('5','89','665','257828',4908806,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257828',4908807,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257828',4908808,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257828',4908809,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257828',4908810,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257829',4908811,'1809','267',2299400.70,2302320.77,2920.07,540212.95,0.00,0.00,0.00,0.00,0.00),('5','89','663','257829',4908812,'1810','267',1778913.38,1781937.71,3024.33,559501.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257829',4908813,'1811','267',2315785.37,2318027.66,2242.29,414823.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','257829',4908814,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257829',4908815,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257829',4908816,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257829',4908817,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257829',4908818,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257829',4908819,'1817','267',1436891.68,1440066.31,3174.63,587306.55,0.00,0.00,0.00,0.00,0.00),('5','89','662','257829',4908820,'1818','267',53258.00,56311.55,3053.55,564906.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','257829',4908821,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257829',4908822,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257829',4908823,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257829',4908824,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257829',4908825,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257830',4908826,'1809','267',2302320.77,2305615.45,3294.68,609515.80,0.00,0.00,0.00,0.00,0.00),('5','89','663','257830',4908827,'1810','267',1781937.71,1785184.44,3246.73,600645.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257830',4908828,'1811','267',2318027.66,2318526.44,498.78,92274.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257830',4908829,'1812','267',1352807.33,1352807.33,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257830',4908830,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257830',4908831,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257830',4908832,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257830',4908833,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257830',4908834,'1817','267',1440066.31,1443583.19,3516.88,650622.80,0.00,0.00,0.00,0.00,0.00),('5','89','662','257830',4908835,'1818','267',56311.55,59215.83,2904.28,537291.80,0.00,0.00,0.00,0.00,0.00),('5','89','665','257830',4908836,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257830',4908837,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257830',4908838,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257830',4908839,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257830',4908840,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257831',4908841,'1809','267',2305615.45,2308587.84,2972.39,549892.15,0.00,0.00,0.00,0.00,0.00),('5','89','663','257831',4908842,'1810','267',1785184.44,1785617.26,432.82,80071.70,0.00,0.00,0.00,0.00,0.00),('5','89','662','257831',4908843,'1811','267',2318526.44,2319309.13,782.69,144797.65,0.00,0.00,0.00,0.00,0.00),('5','89','664','257831',4908844,'1812','267',1352807.33,1355038.91,2231.58,412842.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257831',4908845,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257831',4908846,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257831',4908847,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257831',4908848,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257831',4908849,'1817','267',1443583.19,1445428.74,1845.55,341426.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257831',4908850,'1818','267',59215.83,62455.25,3239.42,599292.70,0.00,0.00,0.00,0.00,0.00),('5','89','665','257831',4908851,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257831',4908852,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257831',4908853,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257831',4908854,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257831',4908855,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257832',4908856,'1809','267',2308587.84,2311380.16,2792.32,516579.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','257832',4908857,'1810','267',1785617.26,1785617.26,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257832',4908858,'1811','267',2319309.13,2321577.07,2267.94,419568.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','257832',4908859,'1812','267',1355038.91,1355960.14,921.23,170427.55,0.00,0.00,0.00,0.00,0.00),('5','89','664','257832',4908860,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257832',4908861,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257832',4908862,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257832',4908863,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257832',4908864,'1817','267',1445428.74,1448269.14,2840.40,525474.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257832',4908865,'1818','267',62455.25,64978.03,2522.78,466714.30,0.00,0.00,0.00,0.00,0.00),('5','89','665','257832',4908866,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257832',4908867,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257832',4908868,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257832',4908869,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257832',4908870,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257833',4908871,'1809','267',2311380.16,2313556.94,2176.78,402704.30,0.00,0.00,0.00,0.00,0.00),('5','89','663','257833',4908872,'1810','267',1785617.26,1787779.79,2162.53,400068.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257833',4908873,'1811','267',2321577.07,2323912.38,2335.31,432032.35,0.00,0.00,0.00,0.00,0.00),('5','89','664','257833',4908874,'1812','267',1355960.14,1357522.76,1562.62,289084.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257833',4908875,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257833',4908876,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257833',4908877,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257833',4908878,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257833',4908879,'1817','267',1448269.14,1450823.85,2554.71,472621.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','257833',4908880,'1818','267',64978.03,67708.05,2730.02,505053.70,0.00,0.00,0.00,0.00,0.00),('5','89','665','257833',4908881,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257833',4908882,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257833',4908883,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257833',4908884,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257833',4908885,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257834',4908886,'1809','267',2313556.94,2316142.79,2585.85,478382.25,0.00,0.00,0.00,0.00,0.00),('5','89','663','257834',4908887,'1810','267',1787779.79,1790429.10,2649.31,490122.35,0.00,0.00,0.00,0.00,0.00),('5','89','662','257834',4908888,'1811','267',2323912.38,2326478.35,2565.97,474704.45,0.00,0.00,0.00,0.00,0.00),('5','89','664','257834',4908889,'1812','267',1357522.76,1359693.74,2170.98,401631.30,0.00,0.00,0.00,0.00,0.00),('5','89','664','257834',4908890,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257834',4908891,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257834',4908892,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257834',4908893,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257834',4908894,'1817','267',1450823.85,1452784.04,1960.19,362635.15,0.00,0.00,0.00,0.00,0.00),('5','89','662','257834',4908895,'1818','267',67708.05,70655.20,2947.15,545222.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','257834',4908896,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257834',4908897,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257834',4908898,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257834',4908899,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257834',4908900,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257835',4908901,'1809','267',2316142.79,2319323.23,3180.44,588381.40,0.00,0.00,0.00,0.00,0.00),('5','89','663','257835',4908902,'1810','267',1790429.10,1793934.14,3505.04,648432.40,0.00,0.00,0.00,0.00,0.00),('5','89','662','257835',4908903,'1811','267',2326478.35,2329356.40,2878.05,532439.25,0.00,0.00,0.00,0.00,0.00),('5','89','664','257835',4908904,'1812','267',1359693.74,1359693.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257835',4908905,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257835',4908906,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257835',4908907,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257835',4908908,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257835',4908909,'1817','267',1452784.04,1456830.85,4046.81,748659.85,0.00,0.00,0.00,0.00,0.00),('5','89','662','257835',4908910,'1818','267',70655.20,73685.35,3030.15,560577.75,0.00,0.00,0.00,0.00,0.00),('5','89','665','257835',4908911,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257835',4908912,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257835',4908913,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257835',4908914,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257835',4908915,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257836',4908916,'1809','267',2319323.23,2322361.95,3038.72,562163.20,0.00,0.00,0.00,0.00,0.00),('5','89','663','257836',4908917,'1810','267',1793934.14,1796315.09,2380.95,440475.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257836',4908918,'1811','267',2329356.40,2332120.96,2764.56,511443.60,0.00,0.00,0.00,0.00,0.00),('5','89','664','257836',4908919,'1812','267',1359693.74,1361054.75,1361.01,251786.85,0.00,0.00,0.00,0.00,0.00),('5','89','664','257836',4908920,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257836',4908921,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257836',4908922,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257836',4908923,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257836',4908924,'1817','267',1456830.85,1459325.00,2494.15,461417.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257836',4908925,'1818','267',73685.35,74551.54,866.19,160245.15,0.00,0.00,0.00,0.00,0.00),('5','89','665','257836',4908926,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257836',4908927,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257836',4908928,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257836',4908929,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257836',4908930,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257837',4908931,'1809','267',2322361.95,2325474.58,3112.63,575836.55,0.00,0.00,0.00,0.00,0.00),('5','89','663','257837',4908932,'1810','267',1796315.09,1796315.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257837',4908933,'1811','267',2332120.96,2334501.69,2380.73,440435.05,0.00,0.00,0.00,0.00,0.00),('5','89','664','257837',4908934,'1812','267',1361054.75,1363334.57,2279.82,421766.70,0.00,0.00,0.00,0.00,0.00),('5','89','664','257837',4908935,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257837',4908936,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257837',4908937,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257837',4908938,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257837',4908939,'1817','267',1459325.00,1463140.15,3815.15,705802.75,0.00,0.00,0.00,0.00,0.00),('5','89','662','257837',4908940,'1818','267',74551.54,76789.25,2237.71,413976.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','257837',4908941,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257837',4908942,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257837',4908943,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257837',4908944,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257837',4908945,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663','257838',4908946,'1809','267',2325474.58,2329259.60,3785.02,700228.70,0.00,0.00,0.00,0.00,0.00),('5','89','663','257838',4908947,'1810','267',1796315.09,1796315.09,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257838',4908948,'1811','267',2334501.69,2337610.81,3109.12,575187.20,0.00,0.00,0.00,0.00,0.00),('5','89','664','257838',4908949,'1812','267',1363334.57,1366112.51,2777.94,513918.90,0.00,0.00,0.00,0.00,0.00),('5','89','664','257838',4908950,'1813','267',609161.45,609161.45,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257838',4908951,'1814','267',682633.74,682633.74,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257838',4908952,'1815','267',843903.59,843903.59,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','664','257838',4908953,'1816','267',440976.92,440976.92,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','662','257838',4908954,'1817','267',1463140.15,1466814.08,3673.93,679677.05,0.00,0.00,0.00,0.00,0.00),('5','89','662','257838',4908955,'1818','267',76789.25,79722.96,2933.71,542736.35,0.00,0.00,0.00,0.00,0.00),('5','89','665','257838',4908956,'1819','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','665','257838',4908957,'1820','267',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257838',4908958,'1821','268',472858.04,472858.04,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','666','257838',4908959,'1822','268',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','667','257838',4908960,'1823','269',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00),('5','89','663'